(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    893698,      18768]
NotebookOptionsPosition[    727168,      15295]
NotebookOutlinePosition[    865484,      18244]
CellTagsIndexPosition[    865441,      18241]
WindowTitle->2. The Complex Plane | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "The Complex Plane"
}], "Section",
 CounterAssignments->{{"Section", 1}},
 CellID->29626863,ExpressionUUID->"276cfdbd-f1e5-4a91-94b4-f38b51830b2a"],

Cell["\<\
This chapter presents the basic properties of complex numbers and how to \
visualize them. The connection between geometry and complex analysis is very \
deep and historically has been important for the development of the subject.\
\>", "Text",
 CellID->18539210,ExpressionUUID->"91de936f-69ab-4076-9194-e7a32c8917bd"],

Cell[CellGroupData[{

Cell["Complex Numbers: Arithmetic", "Subsection",
 CellID->346328761,ExpressionUUID->"7b6b5bde-0f3a-4b24-ad20-a9b94d65cb65"],

Cell["A complex number has the form", "Text",
 CellID->274766732,ExpressionUUID->"8a5d6246-f782-4960-a861-cc6dbf15359c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "=", 
    RowBox[{"a", "+", 
     RowBox[{"\[ImaginaryI]", " ", "b", " ", "for", " ", "a"}]}]}], ",", 
   RowBox[{"b", "\[Element]", 
    RowBox[{"\[DoubleStruckCapitalR]", "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->390909247,ExpressionUUID->"382adea0-18d8-4510-9609-bddfd9c35e47"],

Cell[TextData[{
 "The real number ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "082b116f-7c25-4654-85ba-0919270e4721"],
 " is the ",
 StyleBox["real part",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "71ddfb86-2e58-4919-aeea-26312a8d985d"],
 ", and the real number ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath",ExpressionUUID->
  "928c9fd3-d42e-497b-98c3-20e39ae9e7c5"],
 " is the ",
 StyleBox["imaginary part",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2f45a859-17db-4af1-ad65-563343fceeb3"],
 "."
}], "Text",
 CellID->209611468,ExpressionUUID->"4d612fa8-1d38-4cdb-b372-86e9a297ad90"],

Cell[TextData[{
 "The imaginary unit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ImaginaryI]", "=", 
    SqrtBox[
     RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7069c173-2c53-4854-81a6-919cb3d2374c"],
 " has the property"
}], "Text",
 CellID->83879064,ExpressionUUID->"5bce099f-be52-4f7a-9f3c-2a31622e477d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ImaginaryI]", "2"], "=", 
   RowBox[{"-", "1."}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->101427874,ExpressionUUID->"58b5679b-5b8f-41ef-bb77-4a60d02c50d0"],

Cell["Complex numbers are added in the usual way, as follows:", "Text",
 CellID->332830525,ExpressionUUID->"7c142343-b6ac-4947-8351-5a6395311d7d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "c"}], ")"}], "+", 
    RowBox[{"\[ImaginaryI]", "(", 
     RowBox[{"b", "+", "d"}], ")"}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->228605019,ExpressionUUID->"ba7dcf3d-f26d-4708-9479-65d3c24aca28"],

Cell["and are multiplied by:", "Text",
 CellID->736564973,ExpressionUUID->"1ad71db2-247d-4fe1-969b-04e5ddc05edc"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "c"}], "-", 
       RowBox[{"b", " ", "d"}]}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{"a", " ", "d"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->533759894,ExpressionUUID->"880b7c16-e563-48fd-b17f-996af8018380"],

Cell["\<\
which follows from the usual term-by-term multiplication rules.\
\>", "Text",
 CellID->286783599,ExpressionUUID->"3c42c9f4-d51e-48dd-9e4e-faaa0d5bedce"],

Cell["To divide two complex numbers, one uses:", "Text",
 CellID->57583490,ExpressionUUID->"4387dce1-817b-4e88-a787-fa059bea4f70"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"\[ImaginaryI]", " ", "b"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"\[ImaginaryI]", " ", "d"}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", 
        RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"c", "-", 
        RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}]], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"c", "-", 
         RowBox[{"\[ImaginaryI]", " ", "d"}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["c", "2"], "+", 
       SuperscriptBox["d", "2"]}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->34575577,ExpressionUUID->"4746f7c5-a6c4-4b49-88c3-38f2e4a8cedb"],

Cell["In particular,", "Text",
 CellID->107431084,ExpressionUUID->"222f4216-5ca0-41f4-9c74-71eb61218239"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"\[ImaginaryI]", "b"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]], "-", 
    RowBox[{
     FractionBox["b", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}]], 
     RowBox[{"\[ImaginaryI]", "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->2111535,ExpressionUUID->"bf20ac0d-4493-4789-8ed9-000dcda28004"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->18183295,ExpressionUUID->"65ce4b68-10c6-4f03-8d56-b4ac80d96821"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"3", "-", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6d071809-9130-450e-935f-5521e6a4b736"],
 ","
}], "SolvedExampleNote",
 CellID->118380504,ExpressionUUID->"21d2abdd-a4d8-4d0a-968d-14bc53bff5d4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"3", "-", 
    RowBox[{"2", "I"}]}]}], ";"}]], "SolvedExampleInput",
 CellID->201022375,ExpressionUUID->"f40f2210-5cf9-43e0-a0a7-283a72708f4a"],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"fbf9447d-b771-4dee-9e3b-d18d1e5d0aa7"],
 ","
}], "SolvedExampleNote",
 CellID->43555989,ExpressionUUID->"7bea9135-0045-4a5a-baae-7e35499c6ecf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{
    RowBox[{"-", "5"}], "+", "I"}]}], ";"}]], "SolvedExampleInput",
 CellID->279448694,ExpressionUUID->"979cd32a-e604-4483-b492-c1888fc7d37f"],

Cell[TextData[{
 "then their sum ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "+", "w"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "da78ed9c-2a79-4737-8ac4-7762b682b0be"],
 " is:"
}], "SolvedExampleNote",
 CellID->89710708,ExpressionUUID->"c2a19b79-4608-4dd7-8e7e-04cd70588826"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "+", "w"}]], "SolvedExampleInput",
 CellID->67178792,ExpressionUUID->"e45bf49c-920b-4d0a-9271-5bc6baf100b3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "-", "\[ImaginaryI]"}]], "SolvedExampleOutput",
 CellID->349030951,ExpressionUUID->"059f84ff-7399-402b-a27b-051b17b5aad9"]
}, Open  ]],

Cell[TextData[{
 "Their product ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", " ", "w"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e5d4571d-a5d4-4c67-bb9d-47fd4a9c9744"],
 " is:"
}], "SolvedExampleNote",
 CellID->329023157,ExpressionUUID->"89afcc87-d1e1-4e33-bdd2-a5b49cdb7f34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "*", "w"}]], "SolvedExampleInput",
 CellID->1015213509,ExpressionUUID->"4f69f5ad-2986-4b3f-a6c0-d62c031d73aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "13"}], "+", 
  RowBox[{"13", " ", "\[ImaginaryI]"}]}]], "SolvedExampleOutput",
 CellID->24312619,ExpressionUUID->"b1c7a5c0-bd1a-4bd7-a3c7-697f871edfbc"]
}, Open  ]],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3e915384-fd21-4521-b9e1-b409e7a61fb0"],
 " is:"
}], "SolvedExampleNote",
 CellID->541062707,ExpressionUUID->"1f8c76b0-dcc9-45f1-b9d8-7a3ffdca9ee2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "z"}]], "SolvedExampleInput",
 CellID->216360819,ExpressionUUID->"31c91ed7-c095-4080-93ba-9a0a3198d15f"],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "13"], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], "13"]}]], "SolvedExampleOutput",
 CellID->68855592,ExpressionUUID->"96c950f5-64c7-42d3-8a51-5f16b85175f3"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"d58b28ea-bfc5-4c20-974b-c954f4c33e6a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conjugation, Absolute Value", "Subsection",
 CellID->103794871,ExpressionUUID->"ae70e93e-1258-441f-b3a1-ce2808504e15"],

Cell[TextData[{
 "Given ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a889354c-ce44-4624-903a-9fc06f127a96"],
 ", its ",
 StyleBox["complex conjugate",
  FontSlant->"Italic"],
 " is the complex number"
}], "Text",
 CellID->215538370,ExpressionUUID->"37de5071-8836-4b0a-8bee-48fd5829ff20"],

Cell[BoxData[
 FormBox[
  RowBox[{
   OverscriptBox["z", "_"], "=", 
   RowBox[{
    RowBox[{"x", "-", 
     RowBox[{"\[ImaginaryI]", "y"}]}], "=", 
    RowBox[{
     OverscriptBox[
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", "y"}]}], "_"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->985618216,ExpressionUUID->"2e24b501-e5bd-4f1f-a23f-fc3720569121"],

Cell[TextData[{
 "Its ",
 StyleBox["absolute value",
  FontSlant->"Italic"],
 " or ",
 StyleBox["modulus",
  FontSlant->"Italic"],
 " is the real number"
}], "Text",
 CellID->55158655,ExpressionUUID->"0630fc6a-234e-4a56-95f8-4b770d668e57"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{"z", 
       OverscriptBox["z", "_"]}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->257296754,ExpressionUUID->"a8dcc433-ba72-4489-9098-a4e200e63e10"],

Cell[TextData[{
 "Notice that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "\[GreaterEqual]",
     "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a9b3cf9b-b434-48dd-afbb-f2acd25b537a"],
 " and that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "=", 
    RowBox[{"\[LeftBracketingBar]", 
     OverscriptBox["z", "_"], "\[RightBracketingBar]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"419814af-51ad-4c82-9b5a-f293ac200218"],
 "."
}], "Text",
 CellID->79059132,ExpressionUUID->"b6359712-0df7-490a-90df-bf0a17d45b2f"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->523904063,ExpressionUUID->"c1755cb3-d977-4531-b871-4a923e39453d"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"3", "-", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"966d1af4-ff74-47c1-9f7f-877963417b66"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["3", "2"], "+", 
       SuperscriptBox["2", "2"]}]], "=", 
     SqrtBox["13"]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ef1b1f99-eab5-4c2a-aaec-21b53a2130d3"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["z", "_"], "=", 
    RowBox[{"3", "+", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b77ee796-d2ed-4fc5-a470-801c8e28ce75"],
 ". In Wolfram Language:"
}], "SolvedExampleNote",
 CellID->164893261,ExpressionUUID->"b193e710-6385-4da8-8af9-f13755a60f9d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{"3", "-", 
    RowBox[{"2", "I"}]}]}], ";"}]], "SolvedExampleInput",
 CellID->194952655,ExpressionUUID->"ffca8380-0f09-41fe-a4b4-d118c39acce6"],

Cell[TextData[{
 "Compute the absolute value using ",
 ButtonBox["Abs",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->8158935,ExpressionUUID->"71fae7da-89ac-4156-a5e5-081aa1a648eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", "z", "]"}]], "SolvedExampleInput",
 CellID->461037366,ExpressionUUID->"3ed7a7ee-9de8-4d86-8e4b-955ca74c4acc"],

Cell[BoxData[
 SqrtBox["13"]], "SolvedExampleOutput",
 CellID->153821439,ExpressionUUID->"822539e0-d461-4e94-b8c1-9be05b359db1"]
}, Open  ]],

Cell[TextData[{
 "Compute the conjugate using ",
 ButtonBox["Conjugate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->126846233,ExpressionUUID->"15cd247e-bfcb-4162-9281-0e4b82d82e40"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Conjugate", "[", "z", "]"}]], "SolvedExampleInput",
 CellID->37278318,ExpressionUUID->"aa448a92-cd55-494e-ae9d-71d7a0d7959e"],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "SolvedExampleOutput",
 CellID->51865263,ExpressionUUID->"a21100d1-1e4e-4ebf-ad34-f2b2db25a06c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "z", "]"}]], "SolvedExampleInput",
 CellID->189837019,ExpressionUUID->"4a3139cc-360c-4121-ac5c-380e36c61f4e"],

Cell["", "SolvedExampleEndCap",
 CellID->87939568,ExpressionUUID->"52482867-0f0a-4349-9779-a97c9fe63657"],

Cell["Another property of the absolute value is that", "Text",
 CellID->201668742,ExpressionUUID->"4911d8cf-be2f-4051-aa76-f35a1fe09e15"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[LeftBracketingBar]", 
    RowBox[{"z", "-", "w"}], "\[RightBracketingBar]"}], "\[LessEqual]", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "+", 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", "w", "\[RightBracketingBar]"}], 
     "."}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->261117951,ExpressionUUID->"3156bda0-55d2-417a-b9e7-9a0472950895"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Complex Plane", "Subsection",
 CellID->181787970,ExpressionUUID->"98f5c3e5-f51c-4678-b50e-6471838e24db"],

Cell[TextData[{
 "A geometric picture is obtained if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5d532592-71e1-4192-bb94-c5e8f12440af"],
 " is considered as a point in the plane, with coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"59a643c3-34e5-46fc-8cdc-98a37bb45586"],
 ", or as the vector from the origin to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b294f682-610c-4494-929b-fb21017da9a7"],
 "."
}], "Text",
 CellID->76780899,ExpressionUUID->"a013276a-36d7-4267-ac55-4d699d0bb766"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexListPlot", "[", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["9", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["5264", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[{
      Labeled[0, 0, LabelStyle -> Directive[12]], 
      Labeled[1, 1, Above, LabelStyle -> Directive[12]], 
      Labeled[2, 2, Above, LabelStyle -> Directive[12]], 
      Labeled[Pi, Pi, Above, LabelStyle -> Directive[12]], 
      Labeled[I, I, LabelStyle -> Directive[12]], 
      Labeled[2 + I, 2 + I, Above, LabelStyle -> Directive[12]], 
      Labeled[-2 - I, -2 - I, Above, LabelStyle -> Directive[12]]}, PlotStyle -> 
     PointSize[Medium], PlotRange -> {{-4, 4}, {-3, 3}}, AxesLabel -> {
       Style[
        ToString[
         HoldForm[
          Re[$CellContext`z]], TraditionalForm], 12], 
       Style[
        ToString[
         HoldForm[
          Im[$CellContext`z]], TraditionalForm], 12]}, AspectRatio -> 
     Automatic, Ticks -> {
       Range[-4, 4], 
       Range[-3, 3]}, TicksStyle -> 
     Directive[FontOpacity -> 0, FontSize -> 0], Epilog -> {{
        Text[
         Style[
          ToString[
           HoldForm[$CellContext`z], TraditionalForm], 12], {7/2, 5/2}]}, {
        Thickness[0.003], 
        Line[{{3.3, 2.25}, {3.7, 2.25}}]}, {
        Thickness[0.003], 
        Line[{{3.3, 2.25}, {3.3, 2.7}}]}}, ImageSizeRaw -> 300],
    SelectWithContents->True,
    Selectable->False], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["224", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, "Fig. 1. The complex plane."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->416109330,ExpressionUUID->"048e50b1-ca0e-4160-a5bd-43c4b3aef000"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, {}, {{}, {
         TagBox[
          {RGBColor[0.24, 0.6, 0.8], PointSize[Medium], AbsoluteThickness[2], 
           PointBox[{{0., 0.}, {1., 0.}, {2., 0.}, {3.141592653589793, 0.}, {
            0., 1.}, {2., 1.}, {-2., -1.}}]},
          Annotation[#, "Charting`Private`Tag#1"]& ], {
          TagBox[
           {Opacity[0.], PointBox[{{0., 0.}}]},
           Annotation[#, {{Labeled}, Charting`Private`Tag, {1}}]& ], 
          TagBox[
           {Opacity[0.], PointBox[{{1., 0.}}]},
           Annotation[#, {{Labeled}, Charting`Private`Tag, {2}}]& ], 
          TagBox[
           {Opacity[0.], PointBox[{{2., 0.}}]},
           Annotation[#, {{Labeled}, Charting`Private`Tag, {3}}]& ], 
          TagBox[
           {Opacity[0.], PointBox[{{3.141592653589793, 0.}}]},
           Annotation[#, {{Labeled}, Charting`Private`Tag, {4}}]& ], 
          TagBox[
           {Opacity[0.], PointBox[{{0., 1.}}]},
           Annotation[#, {{Labeled}, Charting`Private`Tag, {5}}]& ], 
          TagBox[
           {Opacity[0.], PointBox[{{2., 1.}}]},
           Annotation[#, {{Labeled}, Charting`Private`Tag, {6}}]& ], 
          TagBox[
           {Opacity[0.], PointBox[{{-2., -1.}}]},
           
           Annotation[#, {{Labeled}, Charting`Private`Tag, {
             7}}]& ]}}, {{{{}, {GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{5.999999999999998, 14.}, {0.046892344436581565`, 
                  1.0351692583274361`}], 
                 Offset[{6.000000000000002, 8.881784197001252*^-16}, {
                  0.046892344436581565`, 1.0351692583274361`}], 
                 Offset[{1.7763568394002505`*^-15, -8.881784197001252*^-16}, {
                  0.046892344436581565`, 1.0351692583274361`}], 
                 Offset[{-1.7763568394002505`*^-15, 14.}, {
                  0.046892344436581565`, 1.0351692583274361`}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox["\[ImaginaryI]",
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], 
               Offset[{3., 7.}, {0.046892344436581565, 1.0351692583274361}], 
               NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{-1.7763568394002505`*^-15, 
                  8.881784197001252*^-16}, {-0.046892344436581565`, \
-0.03516925832743618}], 
                 Offset[{
                  1.7763568394002505`*^-15, -14.}, {-0.046892344436581565`, \
-0.03516925832743618}], 
                 Offset[{-8.999999999999998, -14.}, {-0.046892344436581565`, \
-0.03516925832743618}], 
                 Offset[{-9.000000000000002, -8.881784197001252*^-16}, \
{-0.046892344436581565`, -0.03516925832743618}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox["0",
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], 
               Offset[{-4.5, -7.}, \
{-0.046892344436581565, -0.03516925832743618}], NCache[
               ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 0.5}]]]}]}}, {{}, {GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{4.499999999999998, 14.}, {1., 0.049736842105263156`}],
                  Offset[{4.500000000000002, 8.881784197001252*^-16}, {1., 
                  0.049736842105263156`}], 
                 Offset[{-4.499999999999998, -8.881784197001252*^-16}, {1., 
                  0.049736842105263156`}], 
                 Offset[{-4.500000000000002, 14.}, {1., 
                  0.049736842105263156`}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox["1",
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], Offset[{0., 7.}, {1., 0.049736842105263156}],
                NCache[
               ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{4.499999999999998, 14.}, {2., 0.049736842105263156`}],
                  Offset[{4.500000000000002, 8.881784197001252*^-16}, {2., 
                  0.049736842105263156`}], 
                 Offset[{-4.499999999999998, -8.881784197001252*^-16}, {2., 
                  0.049736842105263156`}], 
                 Offset[{-4.500000000000002, 14.}, {2., 
                  0.049736842105263156`}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox["2",
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], Offset[{0., 7.}, {2., 0.049736842105263156}],
                NCache[
               ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{5.999999999999998, 14.000000000000002`}, {
                  3.141592653589793, 0.049736842105263156`}], 
                 Offset[{6.000000000000002, 1.7763568394002505`*^-15}, {
                  3.141592653589793, 0.049736842105263156`}], 
                 Offset[{-5.999999999999998, -1.7763568394002505`*^-15}, {
                  3.141592653589793, 0.049736842105263156`}], 
                 Offset[{-6.000000000000002, 13.999999999999998`}, {
                  3.141592653589793, 0.049736842105263156`}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox["\[Pi]",
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], 
               Offset[{0., 7.}, {3.141592653589793, 0.049736842105263156}], 
               NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{12.499999999999998`, 14.000000000000004`}, {2., 
                  1.049736842105263}], 
                 Offset[{12.500000000000002`, 2.6645352591003757`*^-15}, {2., 
                  1.049736842105263}], 
                 Offset[{-12.499999999999998`, -2.6645352591003757`*^-15}, {
                  2., 1.049736842105263}], 
                 Offset[{-12.500000000000002`, 13.999999999999996`}, {2., 
                  1.049736842105263}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox[
                 RowBox[{"2", "+", "\[ImaginaryI]"}],
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], Offset[{0., 7.}, {2., 1.049736842105263}], 
               NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
              {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
                NCache[
                 Rational[2, 3], 0.6666666666666666]]}], 
               PolygonBox[{
                Offset[{15.999999999999998`, 
                  14.000000000000004`}, {-2., -0.9502631578947368}], 
                 Offset[{16., 
                  3.552713678800501*^-15}, {-2., -0.9502631578947368}], 
                 Offset[{-15.999999999999998`, -3.552713678800501*^-15}, \
{-2., -0.9502631578947368}], 
                 Offset[{-16., 
                  13.999999999999996`}, {-2., -0.9502631578947368}]}]}, 
              {RGBColor[
               0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
               AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
               StyleBox[
                RotationBox[
                 RowBox[{
                  RowBox[{"-", "2"}], "-", "\[ImaginaryI]"}],
                 BoxRotation->0.],
                StripOnInput->False,
                LineOpacity->1,
                FrontFaceOpacity->1,
                BackFaceOpacity->1,
                Opacity->1,
                FontSize->12,
                FontOpacity->1], Offset[{0., 7.}, {-2., -0.9502631578947368}],
                NCache[
               ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
                ImageScaled[{0.5, 
                 0.5}]]]}]}}}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
      AspectRatio->Automatic,
      Axes->True,
      AxesLabel->{
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[TagBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], HoldForm], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], 
        FormBox[
         StyleBox[
         "\"\\!\\(\\*FormBox[TagBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], HoldForm], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Epilog->{{
         InsetBox[
          FormBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[TagBox[\\\"z\\\", HoldForm], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
          NCache[{
            Rational[7, 2], 
            Rational[5, 2]}, {3.5, 2.5}]]}, {
         Thickness[0.003], 
         LineBox[{{3.3, 2.25}, {3.7, 2.25}}]}, {
         Thickness[0.003], 
         LineBox[{{3.3, 2.25}, {3.3, 2.7}}]}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{All, All}, {All, All}},
      ImageSizeRaw->300,
      Method->{
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& )}},
      PlotRange->{{-4., 4.}, {-3., 3.}},
      PlotRangeClipping->False,
      PlotRangePadding->{{0, 
         Scaled[0.05]}, {0, 
         Scaled[0.05]}},
      Ticks->{{{-4, 
          FormBox[
           RowBox[{"-", "4"}], TraditionalForm]}, {-3, 
          FormBox[
           RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}}, {{-3, 
          FormBox[
           RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}}},
      TicksStyle->Directive[FontOpacity -> 0, FontSize -> 0]]},
    {"\<\"Fig. 1. The complex plane.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 ShowCellLabel->False,
 CellID->1797131840,ExpressionUUID->"181478a5-891b-44ae-a670-0bb5832551be"]
}, Open  ]],

Cell["\<\
In this way, the sum (or difference) of two complex numbers is just their \
vector sum (or difference).\
\>", "Text",
 CellID->461744709,ExpressionUUID->"a81caa27-53b8-43f9-88f1-0af9c16e1625"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["10584", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[{{
       RGBColor[0.368417, 0.506779, 0.709798], 
       Arrowheads[0.05], 
       Arrow[{{0, 0}, {-1, 2}}]}, {
       RGBColor[0.368417, 0.506779, 0.709798], 
       Arrowheads[0.05], 
       Arrow[{{0, 0}, {1/2, 3/2}}]}, {
       RGBColor[0.368417, 0.506779, 0.709798], Dashed, 
       Line[{{-1, 2}, {-(1/2), 7/2}}]}, {
       RGBColor[0.368417, 0.506779, 0.709798], Dashed, 
       Line[{{1/2, 3/2}, {-(1/2), 7/2}}]}, {
       RGBColor[0.368417, 0.506779, 0.709798], 
       Arrowheads[0.05], 
       Arrow[{{0, 0}, {-(1/2), 7/2}}]}, 
      Text[
       Style[
        ToString[
         Subscript[$CellContext`z, 1], TraditionalForm], 12], {
       1/2, 3/2}, {-2, -1}], 
      Text[
       Style[
        ToString[
         Subscript[$CellContext`z, 2], TraditionalForm], 12], {-1, 2}, {
       3/2, -(1/2)}], 
      Text[
       Style[
        ToString[
        Subscript[$CellContext`z, 1] + Subscript[$CellContext`z, 2], 
         TraditionalForm], 12], {-(1/2), 7/2}, {1/2, -(3/2)}], {
       Thickness[0.003], 
       Line[{{0, -1}, {0, 4}}]}, {
       Thickness[0.003], 
       Line[{{-3, 0}, {3, 0}}]}, 
      Text[
       Style[
        ToString[
         Re[$CellContext`z], TraditionalForm], 12], {3, 0}, {-(3/2), 0}], 
      Text[
       Style[
        ToString[
         Im[$CellContext`z], TraditionalForm], 12], {0, 4}, {-(1/2), -(3/2)}], 
      Text[
       Style[
        ToString[$CellContext`z, TraditionalForm], 12], {3, 4}], {
       Thickness[0.003], 
       Line[{{2.8, 3.75}, {3.3, 3.75}}]}, {
       Thickness[0.003], 
       Line[{{2.8, 3.75}, {2.8, 4.25}}]}}, ImageSize -> 230],
    SelectWithContents->True,
    Selectable->False], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["792", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ((("Fig. 2. The sum of " <> ToString[
         Subscript[$CellContext`z, 1], TraditionalForm]) <> " and ") <> 
     ToString[
       Subscript[$CellContext`z, 2], TraditionalForm]) <> 
    " can be\nobtained by vector addition."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->18195684,ExpressionUUID->"9089eb3c-75a7-4496-b4f7-29324510621b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.05], 
      ArrowBox[{{0, 0}, {-1, 2}}]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.05], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[1, 2], 
          Rational[3, 2]}}, {{0, 0}, {0.5, 1.5}}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Dashing[{Small, Small}], 
      LineBox[
       NCache[{{-1, 2}, {
          Rational[-1, 2], 
          Rational[7, 2]}}, {{-1, 2}, {-0.5, 3.5}}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Dashing[{Small, Small}], 
      LineBox[
       NCache[{{
          Rational[1, 2], 
          Rational[3, 2]}, {
          Rational[-1, 2], 
          Rational[7, 2]}}, {{0.5, 1.5}, {-0.5, 3.5}}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.05], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[-1, 2], 
          Rational[7, 2]}}, {{0, 0}, {-0.5, 3.5}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"1\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[1, 2], 
        Rational[3, 2]}, {0.5, 1.5}], 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], {-1, 2}, 
      NCache[
       ImageScaled[{
         Rational[5, 4], 
         Rational[1, 4]}], 
       ImageScaled[{1.25, 0.25}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{SubscriptBox[\\\"z\\\", \\\"1\\\"], \
\\\"+\\\", SubscriptBox[\\\"z\\\", \\\"2\\\"]}], TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-1, 2], 
        Rational[7, 2]}, {-0.5, 3.5}], 
      NCache[
       ImageScaled[{
         Rational[3, 4], 
         Rational[-1, 4]}], 
       ImageScaled[{0.75, -0.25}]]], {
      Thickness[0.003], 
      LineBox[{{0, -1}, {0, 4}}]}, {
      Thickness[0.003], 
      LineBox[{{-3, 0}, {3, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {3, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{-0.25, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 4}, 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[-1, 4]}], 
       ImageScaled[{0.25, -0.25}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], {3, 4}], {
      Thickness[0.003], 
      LineBox[{{2.8, 3.75}, {3.3, 3.75}}]}, {
      Thickness[0.003], 
      LineBox[{{2.8, 3.75}, {2.8, 4.25}}]}}, ImageSize -> 230], 
   "\"Fig. 2. The sum of \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"1\\\"], \
TraditionalForm]\\) and \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\\\"], \
TraditionalForm]\\) can be obtained by vector addition.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->981627308,ExpressionUUID->"856a2b25-b9a6-4252-84a9-cb834f8c393d"]
}, Open  ]],

Cell["\<\
Complex numbers having the same modulus lie on a circle around the origin.\
\>", "Text",
 CellID->288076210,ExpressionUUID->"f16a89a5-9bb9-4c04-b088-7704ee2a8f96"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["7224", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[{{
       RGBColor[0.368417, 0.506779, 0.709798], 
       Circle[]}, {
       RGBColor[0.368417, 0.506779, 0.709798], 
       Circle[{0, 0}, 2]}, {
       RGBColor[0.368417, 0.506779, 0.709798], 
       Circle[{0, 0}, 4]}, 
      Text[
       Style[ToString[
          Abs[$CellContext`z], TraditionalForm] <> "=1", 12], {
       1/2, 1/2}, {(-1)/3, 0}], 
      Text[
       Style[ToString[
          Abs[$CellContext`z], TraditionalForm] <> "=2", 12], {
       3/2, 3/2}, {(-1)/2, -1}], 
      Text[
       Style[ToString[
          Abs[$CellContext`z], TraditionalForm] <> "=4", 12], {3, 
       3}, {(-1)/2, -(1/2)}], {
       Thickness[0.003], 
       Line[{{0, -5}, {0, 5}}]}, {
       Thickness[0.003], 
       Line[{{-5, 0}, {5, 0}}]}, 
      Text[
       Style[
        ToString[
         Re[$CellContext`z], TraditionalForm], 12], {5, 0}, {-(3/2), 0}], 
      Text[
       Style[
        ToString[
         Im[$CellContext`z], TraditionalForm], 12], {0, 5}, {-1, -(3/2)}], 
      Text[
       Style[
        ToString[$CellContext`z, TraditionalForm], 12], {4, 
       5}, {-(1/2), -(1/2)}], {
       Thickness[0.003], 
       Line[{{3.8, 5.5}, {3.8, 4.75}, {4.5, 4.75}}]}}, ImageSize -> 230],
    SelectWithContents->True,
    Selectable->False], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["248", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, "Fig. 3. The complex numbers having\nmodulus 1, 2 and 4."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->129743103,ExpressionUUID->"e5e4e949-4850-4644-a8ba-d7d4ef15554e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      CircleBox[{0, 0}]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      CircleBox[{0, 0}, 2]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      CircleBox[{0, 0}, 4]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \
TraditionalForm]\\)=1\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[1, 2], 
        Rational[1, 2]}, {0.5, 0.5}], 
      NCache[
       ImageScaled[{
         Rational[1, 3], 
         Rational[1, 2]}], 
       ImageScaled[{0.3333333333333333, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \
TraditionalForm]\\)=2\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[3, 2], 
        Rational[3, 2]}, {1.5, 1.5}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 0}], 
       ImageScaled[{0.25, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \
TraditionalForm]\\)=4\"", 12, StripOnInput -> False], TraditionalForm], {3, 
      3}, 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[1, 4]}], 
       ImageScaled[{0.25, 0.25}]]], {
      Thickness[0.003], 
      LineBox[{{0, -5}, {0, 5}}]}, {
      Thickness[0.003], 
      LineBox[{{-5, 0}, {5, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {5, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{-0.25, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 5}, 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 4]}], 
       ImageScaled[{0, -0.25}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], {4, 5}, 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[1, 4]}], 
       ImageScaled[{0.25, 0.25}]]], {
      Thickness[0.003], 
      LineBox[{{3.8, 5.5}, {3.8, 4.75}, {4.5, 4.75}}]}}, ImageSize -> 230], 
   "\"Fig. 3. The complex numbers having modulus 1, 2 and 4.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->2107756236,ExpressionUUID->"9a704609-9ef5-4908-b687-7baa9a4605a6"]
}, Open  ]],

Cell[TextData[{
 "The plane so described is the ",
 StyleBox["complex plane",
  FontSlant->"Italic"],
 " or ",
 StyleBox["Gauss\[Dash]Argand plane",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->8580665,ExpressionUUID->"74820525-729c-4cc8-adb1-960a590e843b"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->735285701,ExpressionUUID->"08e4bec8-577a-49a8-83b1-9a6e78c70d32"],

Cell[TextData[{
 "Plot the region in the complex plane such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "<"}], " ", "|", 
    RowBox[{"z", "-", "\[ImaginaryI]"}], "|", 
    RowBox[{"<", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c37477ae-c811-4653-8567-15274528c3fc"],
 "."
}], "SolvedExampleNote",
 CellID->718422940,ExpressionUUID->"e6312ae3-b148-4cfe-80d5-52e9ec7b2822"],

Cell[TextData[{
 "The question can be answered using ",
 ButtonBox["ComplexRegionPlot",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->378083274,ExpressionUUID->"b36dee11-2ac3-4df1-a8d8-b6d09a0d982a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexRegionPlot", "[", 
  RowBox[{
   RowBox[{"1", "<", 
    RowBox[{"Abs", "[", 
     RowBox[{"z", "-", "\[ImaginaryI]"}], "]"}], "<", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "5"}], "-", 
      RowBox[{"5", "I"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"5", "I"}]}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}]}], "]"}]], "SolvedExampleInput",
 CellID->186422184,ExpressionUUID->"3650a665-c793-47eb-857c-72c07ac834a0"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx1WHtYlFUaBxQwijJEJVQ0Y2kkzcs2Vur2Do4i+jzWaLSSuCOi9Sw76mri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    "], {{
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], Opacity[
       0.3], EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNWGVw10cQvU2ABJcEQiBEIECCJmgagpQWC1oIIXiDu7traKAUUgq0NBUo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          "]], PolygonBox[CompressedData["
1:eJwtleePT1EQhs+osaussmp0qy5W771Hb1m9rN57i251VmeVICIi4o8giN4+
SATRexeE6J43cz48e9753bv3zjkz896KGTP6Tc8RQpgJueAMbLUQNrEWhD+w
mHhhvP4LehOPZJ0LF6AT8QjWZGiFbglV0N3hHtyIuif8hj5cH8U6H+7AZegM
PaAB166ydoG+yoF4NExFL4WbsId4H2slKIo+CMfRdSETXQg6KE8ohj4EJ9Cl
oSa6hnmuHSE/ejtsRdfWb/pfGB58T+dgG3EWawH4AnXMn50G96ENcXrwM/kI
o4inBM/5AbQlHhx8zyPRH/SM4DnmIN4PR9EJMAY9Dqaj68Nn2Et8mLUM5EUf
gGPoGlAd/S7m3g4mE39jbRrPsDTxLshGN4crsJN4N2tZ6Id+wlpN7wbT2cIR
dFVYj64HfdArdMboNGiMLgkT0d2gCXoGNEYXh4Z6tt6JbqF70JW1B3Qz6B/8
t2vQyPzeZnARahH3Ym2vM0RvhszYoxvQ3c33sjJ4bmthefAc16HXmNdWv2Wh
T2lfsAYyEEmwDD0teC4bYVXwnLagT7Pm1t6DX7sb36V7xpqfic5CNUo170H1
nnJ+qnMiXqLaQD70S9bx6hMYSPyCdZyeBUPUG1BMZ6maobua7z0VeuosYGDc
Q1/+PI+1yoABOktIRA8NflaaOc1aZuzFT3Gv6sn36mvzXlEPvoIU89xqwiL0
reCzrp5NJx5knlsS3FZdzN9VOHjuq8xnU3sYij4br00KPkuvo9ZMyVsSzN8l
j9FsvVHNg8+YZvF8cO/RTKqXdojgPZWs3jL3hgYwDP02nlVbqEBc0VzrmV+D
e4y8RT0rL/urfQb3NHmDnqlnySOWoB/G3tc9pTR7cDJ4j/dATzPvxVaQqL3D
4uA1fxZrpNqoJj9jD6r3UoLXPjdx69gD/2LPqdc0gy9jj4yNPVMeXc581vU/
y9W75rXQOxeae6q8dF5wL1pgruVJ8g55lrxKHqLZViPJazTj2ejHMbeDwb20
iLlXylPlTTnNe1keJe/JY+6F8iDV5lJwb1KN5M0/4tnIo+U1Jcy9TJ4jL7oe
3HvkSfPNvyn6lsyB7+pTcy+Qh7XWXsyvaQZm6ezNvWS20DVzrW/Oo7gn7UUz
vNrcs+RVmnl9ayaYe5W+OaptSfNviWr8H8ELufM=
          "]]}]}, {}, {}, {}, {}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
      LineBox[CompressedData["
1:eJwl0jlPVAEUgNEZLE0IVKBAgRYEGrRSFAQVC0BcgLA2MIJasLqhrGoQwa2R
1YafosaCBBNEBAygLAqFFZJIIrLImVCcfPfeeS+TTCYx1FBQHwwEAkNcMpzh
LvfYcrus3zVTm7nPtv2KLmiWPmDK3KJH2DG36q626aIGdTj8RRwlgjcc4Kfz
Qz1IO510kMQjSiilmHLKeEwkVax5v1J/a0ij6CKVY2y4X9c/OssYN+w3ySGX
Q4wQy0kmPDOgmxr+gS5SRy0vmHf/RL85gQzSmXS7pbdpoIlGPruf0tPE85w4
0njGnM97NY+/5sPax7j5hH7U1xrDuvma1lBND8fp5ilPiCaFZEY9f0GzOc8v
e4V+0K+cM5+liELeu82wwlX7qhboD/3PK/M7nWaJQfuyfuMfL+1v9Qt3zPnB
/f/WHsOqTeo=
       "]], 
      LineBox[{263, 411, 262, 292, 196, 400, 234, 288, 289, 197, 348, 235, 
       326, 327, 328, 200, 299, 300, 275, 413, 274, 306, 276, 414, 277, 308, 
       307, 204, 362, 246, 361, 247, 363, 205, 309, 310, 278, 402, 201, 216, 
       242, 408, 243, 302, 301, 387, 271, 351, 238, 349, 237, 350, 269, 296, 
       236, 268, 401, 198, 294, 194, 399, 266, 232, 293, 264, 412, 265, 231, 
       341, 230, 261, 260, 287, 286, 263}]}},
    VertexTextureCoordinates->CompressedData["
1:eJx1WHtYlFUaBxQwijJEJVQ0Y2kkzcs2Vur2Do4i+jzWaLSSuCOi9Sw76mri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     "]], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->120,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-5., 5.}, {-5., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->317139261,ExpressionUUID->"e2f6e725-e633-4257-bec4-7fbd2149f916"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1468523437,ExpressionUUID->"69b8f3c0-8496-414e-9f57-01644eeea08a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Stereographic Representation", "Subsection",
 CellID->82603245,ExpressionUUID->"52c58345-b4b6-40cb-ad17-a64e86a78a0c"],

Cell[TextData[{
 "Another geometrical picture for the complex numbers comes from the ",
 StyleBox["stereographic projection",
  FontSlant->"Italic"],
 " (Fig. 4)."
}], "Text",
 CellID->253731669,ExpressionUUID->"f891441a-13d8-4a79-b1a5-12bc0ca8cefe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "=", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ",", 
         RowBox[{"y", "=", 
          RowBox[{"zp", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ParametricPlot3D", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Directive", "[", 
               RowBox[{"LightBlue", ",", 
                RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}]}], 
           "]"}], ",", 
          RowBox[{"ParametricPlot3D", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", "t", "]"}], " ", 
               RowBox[{"Cos", "[", "p", "]"}]}], ",", 
              RowBox[{
               RowBox[{"Sin", "[", "t", "]"}], " ", 
               RowBox[{"Sin", "[", "p", "]"}]}], ",", 
              RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"p", ",", "0", ",", 
              RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
            RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Opacity", "[", "0.4`", "]"}], "}"}]}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics3D", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "0"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{
                FractionBox[
                 RowBox[{"2", " ", "x"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]], ",", 
                FractionBox[
                 RowBox[{"2", " ", "y"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]], ",", 
                FractionBox[
                 RowBox[{
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"], "-", "1"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]]}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"2", " ", "x"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{"2", " ", "y"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"], "-", "1"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]]}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"\"\<N\>\"", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"ToString", "[", 
                RowBox[{
                 OverscriptBox["z", "^"], ",", "TraditionalForm"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 FractionBox[
                  RowBox[{"2", " ", "x"}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}]], ",", 
                 FractionBox[
                  RowBox[{"2", " ", "y"}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}]], ",", 
                 FractionBox[
                  RowBox[{
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"], "-", "1"}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}]]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"1", ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{"\[ImaginaryI]", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"zp", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}],
           "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Text", "[", "\"\<Fig. 4. Stereographic projection.\>\"", "]"}]}], 
  "]"}]], "Input",
 CellID->283162786,ExpressionUUID->"429163d6-fb55-4dd8-8e16-f1dc46f0639c"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`zp$$ = {-2, -2}, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`zp$$], {-2, -2}, 
           Text[
            Style[
            "\!\(\*FormBox[\"z\", TraditionalForm]\)", 12]]}, {-3, -3}, {3, 
          3}, ControlType -> Slider2D}}, 
       Typeset`size$$ = {240., {83.50477583293457, 90.73719770793457}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False, Typeset`keyframeActionsQ$$ = False, 
       Typeset`keyframeList$$ = {}}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`zp$$ = {-2, -2}}, 
        "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$, 
          Typeset`keyframeActionsQ$$, Typeset`keyframeList$$}, "Body" :> 
        Module[{$CellContext`x = Part[$CellContext`zp$$, 1], $CellContext`y = 
           Part[$CellContext`zp$$, 2]}, 
          Show[{
            
            ParametricPlot3D[{$CellContext`x, $CellContext`y, 
              0}, {$CellContext`x, -3, 3}, {$CellContext`y, -3, 3}, MeshStyle -> 
             None, PlotStyle -> {
               Directive[LightBlue, 
                Opacity[0.4]]}], 
            
            ParametricPlot3D[{
             Sin[$CellContext`t] Cos[$CellContext`p], Sin[$CellContext`t] 
              Sin[$CellContext`p], 
              Cos[$CellContext`t]}, {$CellContext`t, 0, Pi}, {$CellContext`p, 
              0, 2 Pi}, MeshStyle -> None, PlotStyle -> {
               Opacity[0.4]}], 
            Graphics3D[{
              Point[{$CellContext`x, $CellContext`y, 0}], 
              Point[{0, 0, 1}], 
              
              Point[{2 ($CellContext`x/(
                 1 + $CellContext`x^2 + $CellContext`y^2)), 
                2 ($CellContext`y/(
                 1 + $CellContext`x^2 + $CellContext`y^2)), ($CellContext`x^2 + \
$CellContext`y^2 - 1)/(1 + $CellContext`x^2 + $CellContext`y^2)}], 
              Line[{{$CellContext`x, $CellContext`y, 0}, {0, 0, 1}}], 
              
              Line[{{$CellContext`x, $CellContext`y, 0}, {
                2 ($CellContext`x/(1 + $CellContext`x^2 + $CellContext`y^2)), 
                 2 ($CellContext`y/(
                  1 + $CellContext`x^2 + $CellContext`y^2)), \
($CellContext`x^2 + $CellContext`y^2 - 1)/(
                 1 + $CellContext`x^2 + $CellContext`y^2)}}], 
              Line[{{-3, 0, 0}, {3, 0, 0}}], 
              Line[{{0, -3, 0}, {0, 3, 0}}], 
              Text[
               
               ToString[$CellContext`z, 
                TraditionalForm], {$CellContext`x, $CellContext`y, 0}, {1, 
               1}], 
              Text["N", {0, 0, 1}, {0, -1}], 
              Text[
               ToString[
                OverHat[$CellContext`z], TraditionalForm], {
               2 ($CellContext`x/(1 + $CellContext`x^2 + $CellContext`y^2)), 
                2 ($CellContext`y/(
                 1 + $CellContext`x^2 + $CellContext`y^2)), ($CellContext`x^2 + \
$CellContext`y^2 - 1)/(1 + $CellContext`x^2 + $CellContext`y^2)}, {1, 1}], 
              Point[{1, 0, 0}], 
              Text[1, {1, 0, 0}, {1, 1}], 
              Point[{0, 1, 0}], 
              Text[I, {0, 1, 0}, {1, 1}]}]}]], 
        "Specifications" :> {{{$CellContext`zp$$, {-2, -2}, 
            Text[
             Style[
             "\!\(\*FormBox[\"z\", TraditionalForm]\)", 12]]}, {-3, -3}, {3, 
           3}}}, "Options" :> {}, "DefaultOptions" :> {}], 
       ImageSizeCache -> {290.5, {158.50477583293457`, 165.73719770793457`}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ($CellContext`x = "a"; Typeset`initDone$$ = True), 
      SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   InterpretationBox[
    Cell[
     BoxData[
      FormBox["\"Fig. 4. Stereographic projection.\"", TextForm]]], 
    Text["Fig. 4. Stereographic projection."]]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {FontFamily -> "Source Sans Code"}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 ShowCellLabel->False,
 CellID->834591595,ExpressionUUID->"8607584f-cd0a-42ca-b72c-c308ee0a5670"]
}, {2}]],

Cell["The stereographic projection consists of the following:", "Text",
 CellID->22971535,ExpressionUUID->"6064bb9a-b9b1-4b40-a8eb-2e5126096524"],

Cell[CellGroupData[{

Cell["\<\
Imagine that the complex plane is horizontal in three-dimensional space.\
\>", "ItemNumbered",
 CellID->70640122,ExpressionUUID->"7b24dc54-c786-4dc2-99e9-38ac878cf755"],

Cell[TextData[{
 "Consider a sphere of radius 1 centered at the origin (the ",
 StyleBox["Riemann sphere",
  FontSlant->"Italic"],
 ")."
}], "ItemNumbered",
 CellID->116090482,ExpressionUUID->"9d9f4da1-d825-4ed8-8036-de6294e805be"],

Cell[TextData[{
 "Draw a straight line from the complex number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]],
  ExpressionUUID->"97110d18-702a-46b5-b1b0-75f2ee6515b3"],
 ", represented by the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "1e7a6982-44d0-4046-939c-e23243ef2904"],
 " of the complex plane, to the north pole of the sphere."
}], "ItemNumbered",
 CellID->241716959,ExpressionUUID->"50df35e7-fb19-4251-b599-390611489386"],

Cell[TextData[{
 "Call the intersection point of this line with the sphere ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["z", "^"], "=", 
    RowBox[{"(", 
     RowBox[{"X", ",", "Y", ",", "Z"}], ")"}]}], TraditionalForm]],
  ExpressionUUID->"66e23246-5b99-47b0-abba-d750715d4012"],
 ". The point ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["z", "^"], TraditionalForm]],ExpressionUUID->
  "3e5af28b-a279-49f6-8363-0bba1668de09"],
 " is the stereographic projection of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],ExpressionUUID->
  "c2de329a-1c20-4a9b-8b5f-663768cdfb60"],
 "."
}], "ItemNumbered",
 CellID->106131012,ExpressionUUID->"c5b2dda3-26eb-443c-abd2-78735bef0ee2"]
}, Open  ]],

Cell[TextData[{
 "This picture is a second geometric representation of the complex numbers. \
In Fig. 4, it is possible to visualize the stereographic projection as ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "dd354182-5912-4bf3-9022-05ad740696e0"],
 " is varied."
}], "Text",
 CellID->265154475,ExpressionUUID->"1cbb7c31-1f7c-4dcf-b5ed-e30a7a6f5559"],

Cell[TextData[{
 "It can be shown that the coordinates of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox["z", "^"], "=", 
    RowBox[{"(", 
     RowBox[{"X", ",", "Y", ",", "Z"}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5b52ab7e-a6fb-4cf9-871b-627c2b23b93d"],
 " are"
}], "Text",
 CellID->64411386,ExpressionUUID->"48f84580-9fa9-4c66-8130-ca5805c15c52"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"X", "=", 
    FractionBox[
     RowBox[{"2", "x"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "2"], "+",
       "1"}]]}], ",", "       ", 
   RowBox[{"Y", "=", 
    FractionBox[
     RowBox[{"2", "y"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "2"], "+",
       "1"}]]}], ",", "       ", 
   RowBox[{"Z", "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "2"], 
       "-", "1"}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "2"], 
       "+", "1"}]], "."}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->31223680,ExpressionUUID->"77accd7c-a85c-41c5-af8b-56ba6c1c73e5"],

Cell["\<\
The proof of Eq. (10) can be found from the following figure.\
\>", "Text",
 CellID->9748798,ExpressionUUID->"f4c795e1-b22e-45b7-a658-5e50b6ebe172"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", "2"}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"3", "/", "2"}]}], ",", "ts"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ts", "[", "a_", "]"}], ":=", 
      RowBox[{"ToString", "[", 
       RowBox[{"a", ",", "TraditionalForm"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ParametricPlot3D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Directive", "[", 
             RowBox[{"LightBlue", ",", 
              RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}], ",", 
          RowBox[{"Axes", "->", "False"}], ",", 
          RowBox[{"Boxed", "->", "False"}], ",", 
          RowBox[{"ImageSize", "->", "600"}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
        RowBox[{"ParametricPlot3D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Sin", "[", "t", "]"}], " ", 
             RowBox[{"Cos", "[", "p", "]"}]}], ",", 
            RowBox[{
             RowBox[{"Sin", "[", "t", "]"}], " ", 
             RowBox[{"Sin", "[", "p", "]"}]}], ",", 
            RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"p", ",", "0", ",", 
            RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
          RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"Opacity", "[", "0.4`", "]"}], "}"}]}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics3D", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "0"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              FractionBox[
               RowBox[{"2", " ", "x"}], 
               RowBox[{"1", "+", 
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"]}]], ",", 
              FractionBox[
               RowBox[{"2", " ", "y"}], 
               RowBox[{"1", "+", 
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"]}]], ",", 
              FractionBox[
               RowBox[{
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"], "-", "1"}], 
               RowBox[{"1", "+", 
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"]}]]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                FractionBox[
                 RowBox[{"2", " ", "x"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]], ",", 
                FractionBox[
                 RowBox[{"2", " ", "y"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]], ",", 
                FractionBox[
                 RowBox[{
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"], "-", "1"}], 
                 RowBox[{"1", "+", 
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"]}]]}], "}"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"2", " ", "x"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{"2", " ", "y"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"2", " ", "x"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{"2", " ", "y"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"], "-", "1"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]]}], "}"}]}], "}"}], "]"}]}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  FractionBox[
                   RowBox[{
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"], "-", "1"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  FractionBox[
                   RowBox[{"2", " ", "x"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{"2", " ", "y"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]], ",", 
                  FractionBox[
                   RowBox[{
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"], "-", "1"}], 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["y", "2"]}]]}], "}"}]}], "}"}], "]"}]}], 
            "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"\"\<N\>\"", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ts", "[", 
               OverscriptBox["z", "^"], "]"}], "<>", "\"\<=(\>\"", "<>", 
              RowBox[{"ts", "[", "X", "]"}], "<>", "\"\<,\>\"", "<>", 
              RowBox[{"ts", "[", "Y", "]"}], "<>", "\"\<,\>\"", "<>", 
              RowBox[{"ts", "[", "Z", "]"}], "<>", "\"\<)\>\""}], ",", 
             RowBox[{"{", 
              RowBox[{
               FractionBox[
                RowBox[{"2", " ", "x"}], 
                RowBox[{"1", "+", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}]], ",", 
               FractionBox[
                RowBox[{"2", " ", "y"}], 
                RowBox[{"1", "+", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}]], ",", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"], "-", "1"}], 
                RowBox[{"1", "+", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}]]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              FractionBox[
               RowBox[{"2", " ", "x"}], 
               RowBox[{"1", "+", 
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"]}]], ",", 
              FractionBox[
               RowBox[{"2", " ", "y"}], 
               RowBox[{"1", "+", 
                SuperscriptBox["x", "2"], "+", 
                SuperscriptBox["y", "2"]}]], ",", "0"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"ts", "[", 
               RowBox[{"z", "'"}], "]"}], "<>", "\"\<=(\>\"", "<>", 
              RowBox[{"ts", "[", "X", "]"}], "<>", "\"\<,\>\"", "<>", 
              RowBox[{"ts", "[", "Y", "]"}], "<>", "\"\<,\>\"", "<>", 
              RowBox[{"ts", "[", "0", "]"}], "<>", "\"\<)\>\""}], ",", 
             RowBox[{"{", 
              RowBox[{
               FractionBox[
                RowBox[{"2", " ", "x"}], 
                RowBox[{"1", "+", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}]], ",", 
               FractionBox[
                RowBox[{"2", " ", "y"}], 
                RowBox[{"1", "+", 
                 SuperscriptBox["x", "2"], "+", 
                 SuperscriptBox["y", "2"]}]], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], ",", "1"}], "}"}]}], "]"}], ",",
            "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"0", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], ",", "1"}], "}"}]}], "]"}], ",",
            "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"1", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Text", "[", 
            RowBox[{"\[ImaginaryI]", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
    "#", ",", "\"\<Fig. 5. Proof of the formulas for the stereographic \
projection.\>\""}], "]"}], "&"}]}]], "Input",
 CellID->439672978,ExpressionUUID->"25947bd1-2517-4598-9c80-fbafe1ad88e6"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InsetBox[
     Graphics3DBox[{{
        GraphicsComplex3DBox[CompressedData["
1:eJyFnF2sXUUZQC+FtoiJkRgTFKhFb3wmEbDGqo3hpwVaK6L4gEZpMSjc6IMQ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         "], {{
           RGBColor[0.87, 0.94, 1], 
           Opacity[0.4], 
           EdgeForm[None], 
           StyleBox[
            GraphicsGroup3DBox[
             TagBox[{
               Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553xsKS0kycqqKOInlTREMkpDkzQQskdGZaYiREZKNJAy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                "]], 
               Polygon3DBox[CompressedData["
1:eJwtmmXA3UTXRZNJimuRtpRCCy3uXlyKe3F3KRSKu7u7a3F3aXGKu7u7u+vL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                "]], 
               Polygon3DBox[CompressedData["
1:eJwt13ncTnUWAPDH+zz2JVJMhJGlsZZsZQ2RrCFqbE32KWuWlC1ZspZQpKKZ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                "]]}, Annotation[#, "Charting`Private`Tag$34465#1"]& ]], 
            Lighting -> Automatic]}, {}, {}, {}, {}}, 
         VertexNormals -> CompressedData["
1:eJztyDENwCAABMAPDUJYaqMekEDCjHUkVAE7w914baw+S5K3Jk9O9ue99957
77333nvvvffee++9995777333nvvvffee++9995777333nvvvffee++99957
77333nvvvffee++9995777333nvvvffee+/9Df8DFfMaLg==
          "]], {}}, {
        GraphicsComplex3DBox[CompressedData["
1:eJyNfXVcFl3zPvZjdyu2YmEnyGJgYItiYYES9mMDNioqJgYWit3dxVHCLgQB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         "], {{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[0.4], 
           EdgeForm[None], 
           Specularity[
            GrayLevel[1], 3], 
           StyleBox[
            GraphicsGroup3DBox[
             TagBox[{
               Polygon3DBox[CompressedData["
1:eJxFnAf8V/P3x+++NyNZP6NQKEJkZ0RDVIq0tDQJpZIKKSIV7ZKyigqZGdm7
YW/Zm+wysjf/19Pr/Xj8H4/v+3HP59xz3/d9732/z/uc1znnW6//sI5DkyiK
+hZRlOr4ehZFZ+VRdKKYP5dRdIfoY8XvIPoNyfSPo2iEzp2h1kv8FuIvF7+T
+G1EPy+6p+i1oltUUfS0Om0r+gXxe4l/ruj7RF+ta88Tfb/oa0QfLfpF0SdI
pp3ol0X3Fv2x7v+A6IWSOV/0ANE7iB4nuqb6ryN6oOhHuLfGdKGOn0hmiK59
VPQEtX3Ev0DHt8QfIP4/esZI18wWf5r4U9XqinWUjs9Ipptk6upYW/2P1Pif
ldx4nWuk47m539W2kl+hc7/p9wrRJ+h8L/G3Fn2z+PvqdxP1s0bnHxR/kfgT
df0EtXtFj2dMajeIfkNyHdSWiP5Ixx5q94hur2uP49kkt4XGvIP63FHnUo3r
O/FvkkwX9d1Yvx/UPbuK10NtpeTbSf5htc6S76pzj6jdL/mOkt9L8nfp93uS
fUi/LxP/XdEt1S4VfaTO3a52pegPxEsq0x+K3kd9XiX6LdHLdO1s0UeIbq12
v+47WmO8U/xZvE/JNtfvjhrDMvXXVHRL0W11vpH6vFW8t3XdXfp9ieTn6/xV
apeLXqxzDXnnkp+o4+eSOV10L9E9RG8lmTqir2Y+iL+d6GtE1xW9veiFouuJ
3kL0bNH/E10VnhurdO3m4s8SvaX4G+i4hcbzpPjrxD9C9HO6/5aiL+FekrlB
zzZEvzfQcRPx3ld7TvKniTdf9Hax3xnvi3fVT8++Su1U8bfU+cck94r4/yv8
LKsZg45r1F4SPVrXdRVdS/RQ0aervZL4my8q/N23Ziwa2+m6T3/1/bTaIPE3
E39D8V/UtZMlf7HapqLHqI9vRG8u+iIde0tuG8Yg+lLmqq7dWMd31Z5hboj/
juiTxO8nuqfoBsxV9fMtc090fx1PEH8X0Z1KXztQ8t1LP8tpoidJvp/ohpLZ
iXejsZ2lMV8o/nrJ7ST+bnwr8ceIP1H8Pvq9q/gbFR7D06I7S/Y90Serz5ai
Vxaez2Ml/51+byGZmoVlnhV9u3jD1DbRe2um4yPiHyf5LqW/1ymih4q+gfGL
3kX93KbfNyaep48WnqttNK7jRb+tsW0r/pWi64j/pn4/o3f+Jc8l/hLej/jH
iH9v6vXYXOcfUGsr/s3qf6pkWot/k+ifdM1Rogeo/3Y8k+ROFN1e9BGi50tm
jOQPisz7Krfe+0DX7Se5Wazh3OM5XvyTmbOij9G1H0nmQP2+TDLH6Np1krtT
MvfquJHOd2E9iv+Fft/M/JRsa/1uqnMfq23HnNN7WKLjBPV5hGTeU597S26i
+rxG/OniHxr5ui/1+xbRV6OHJHeI6Hmih0lmX+aJrmsjucPV9+XijxB/f/E3
U1+TUz/jZeIPF38/0deLHi+6pegHw3fpHvlZ1ubWn8tzr/G+osvM65O1OVf8
IeLvI/4h7Fs6/qR2V+712zGyrp+lVlP0L4nn42ai6+v8BMntLPov3jnrQ20T
jX+u2hY695buleh4sq57KPf86SGZZbl1y3HoRo1lf8nPUb8fiz4InYnelczG
ok+QzBfqZy/9PlP93Kfjr5LrKv6duXVRB9G3ir5V/Lail+bWLUczt0V/ouuP
Ef2H+t1QMhtpvHfnXsudxP9U5xvk3p95Z7y7O8S/VvQ4yTQX/T77ocYzTX3c
pvO7qg2KPKZRaoN5fh13En+46Ia6thHfWLyt1HYW/wzxN9C9bs6sQzYTf1sd
B7CuU8/Bk0VfUfg5ecbLC89F5uGmkt9G8v3RdZKdojGdJN51knkc20P8LdX3
0sx6j3XAerhd/N0Tr53buJfoo0UvFX02toqun8l+KvmYZxT9puiG6me66N9Y
4/rdW/Tvoh9D7/A+S88t5tWeqb/bEOZJ6W/Dd7lOx/PVfwvmqo5P6PdJzGfd
56ncz9tE/J31e5GuH6Frb9Lv87GtMusg9M/zkv1b9Fjxn2WeS2a06BdE/yP+
uaLrSv4OtT0k31jP2FXHRzBZCttgy5n/hW2elaJf1LX/ij5P9D6699VqZ7K+
xJundo7okTrerGsuEN0MXatxXi+5zpltL+yu1epnc9a7ZF5ifUtuPH2KPoCx
aiyH6Hg4e7boK3XdFWqTJfMy81byF4p+XXSkfqbq0FK83UTfqHu9Kv7d+n2x
+DsX3g/YC75GL7J/SeZ00Ut1bm+Np5Pu0VltA96PxvmiWgf9Pibx8WvGmVnm
uNCgv41Md1SrwbeOTcM/QsceiffNronvQf/bFd4j2R9n8w1F/6u+v9GYLtU4
92aNi35FvA1Fz6psF56oc6vFe1WtW+iPftdL5jAdj1d7S/QNuvY1yU4R3SXI
cN9mQYY9bmPJnKvWmLkkXne1d0S3CDS2xEFh/O+y1yS+J/PqCF23NLXt9Jx4
PdXeY84wF9TqiX5LvDfVBqi10vg3qGxHHFnZfhggumVlW2iIxtpUcv3Vhqv/
rfR+rhd/mPr6Wrx1wX7dHDtJsgeHtdBUrbF+N9exUOuhPhfoXX6v4/mJ9XMv
bCjJH6pjP7VhsXUaegodNV3yM1gvPH9ivYs9A/222kC1TPKjUtvt9Nk36P33
eDe8q8TPix+Df8Oz9Fb7WPTBOvbBh4k9hhPUXhX/x8T6aNOwr9XS+K9h30DX
ih6U2NcoCtv8yE4Othb35TzjmSDZxyXTXs+8s2Rmp/aV+A4X5P4Wt+m4JrGu
3k78qal1+0Y6jlXbS/Ql6vtxtdMS65Cawc5ZqGufKr1fX6rjk9g9op8u3efH
ahM1htX4MrpunOhJoiO+geh52Iuif9PzHxvW0XnijxL/Z927vtolqfesc8Uf
KP5X+j1GdDfsM2w50feKPkD91EGHq7WX/Fjxu2OT6fd40beL3j2zrfWAWjd0
u85NUDtc9Bb0pXaY6D2Yv6n3oCt17aZqe+qaZ/VcD+d+hwegw/gukvtSY/9C
bYza52qfqZ2tdqBklkhmYWr+6LCvce1lQR9ep/NbMp/V78jcNjr2+SWin5DM
EF0zX+fvFn2YeAvwscQ7KrcNhS2FH9RI97hC7TTRz0j2OfzPxGMbm/hea3Uc
l1hPNk2tC6YE/ldq56lNrexj1M/tB7FeuKYV+zT3YL3ouCR1Pw1S2xrsZVcn
nqfYDAN07WA9y7+ie6jPi0XHmb/fGZltrfbinyj+Z+LNwv/BDhT/GPFPEv8L
8WtqHJthayZ+F8xBvtE++CKSGy+Zn9SuU5+Zrp8s2dN0bk/sh9Q2YzPRM8Uf
JH4T0bF4f0l+Y9FHqr+ZakzLRPw0ty8f57a15ujcL3E4su9L8Fr8Fr5BuPbz
wL9O/D0i+0Mzgm4/NTWNDqwnmYWS2U70KeI/n1p/LpB8kZuPLp0W9G1vPd89
2KWsOcmel1r/7y/eTpXt13NEX5X7uTZCn8W2wbYSr3bu73EdvqhaT+YzvijY
hujtU9tf4Cq5ZGuozQ16Zmbptf+jjotzv0PWOeub9TVVvB9Kj6cudqvadTo3
pbCPgX9xCrqTtSn6ZNEnB9t7hs6fKvpA7Addk8e283dM7VuwNiu+ifitRE+W
7I265kjRPSvrw22wNZjDvBv2LMnX0rGzZM6W/JW5+78W2zC3X9AkvFv2qS66
9mG1+yLbHv9K5sHIWMH64JvU1vntRbcRfZP4u+X2BQbzfgq/xz2CXXpLYh2B
XX1rYpxkheh+kXEYcAowCnw8bNhTRG+e+Dp8wJ1S6yae/Wb1P6WyLwResSb4
HSdhWxVeJ9uG77sI2yLxcXPxN8/tKyzQ74Uawya55+Sp2Hq6toZk/lS7nM1I
x33FuyH4TdBLsKXY58K6my96Q41hI9G7BzthKvsf7zbxN+edLNG96uVe+6+o
j/Xif5fY9piS2Dc/PNDYIZ3V50OpMaiu+OW69y9hTweTwn44XvzR4v+KLak+
XyqNW7XT77tTY1bf6J4vl8a0OlbeH9/LjJGgx5j3B4YxY9uA52CDYn/WFG9J
YsxkpzCH+X2V7rlUMtcn7gOdiD/TS9euVHtC126g3xvmfo/txbtH7Ubx/8z9
7Bezn4u3KjWeg5+In4aPdr36nlN5vaFb1wbd+29inG8j1mZhjA98r4Pog3VN
M43zKbXmsf2LoyR7R2rccor63x+9I/piHffO7Hccix+vaw8HH0D/sY/wLcAJ
UuNjj8bGCHknk3XdvsFPac8alXxT7H7eY2w/4iL8x8x2dWvJjNSz3MI+GBuz
XM4eyrzAL2S/wM4v7UdsI/6hsX2NZqnXBuuihWRGMQ/BPdATog8W/Ri2Zmz7
/0z8Er6p2vLY57Hz79bvrRNf+wG6PbH9fLj62UPXNBb/MNEjNM7rdP4I9gfx
9+V6bKPMflAr8fcC4xB/FesyPMME/NnMPlFrXX9najxkTWycBr0BFjpKrRU4
Rmy85wHxZ2XWKeiTNqnXM2v53tjjGil6os7vmtlvOgqfQ2M4ILYPsqy0nmgq
/hnq/1rmms7tpTZC8gemntN8u6fFaxH7m96t457BR95C1+8T/OtJ6DH2dPY+
9dkYvAAfW8fLS38f3iV+z9mSuVD0rolx4Y90n78Tz8kW6uPBzH7viTqeBPYT
GSNdzvgl9yx+Z2kcedfCeBxYXF/WhNoL2B46lqlxvD/Uzo+N9YF5DcmMh6wT
XaXG5bDnhopfP4r+CxSA29UW+bvauNj8V8GidN+++v2a6GNF9xP9bWwsH7w0
07s8U62D+pqUGFNnnK9gL0u+j+h+6vup1HhmH9Y9e7boNwvj+GD4rxeOSRCP
+BRbBuxAMnsnPr9K9A+xz4Ovrgt4yGLRv6mdF/sZG+m6abmxozN1HJjZX8DG
HZQZC/pMbURsvDEr7Nc8FnmfAWdmr1nH9bFx6R/Vzon9fvA78J/ArrFjxsbG
ePGB8FvG6Pf7utefiWMHDfFD1e9uor9QG6nzW0bGpUbFHs/E2Pbd9pFtuNMz
jx8bAvsIe+bdzHoSnwScA5wcrIO9Z1LsGMo/ahNi36sIdg6+ya9q58b2zfdg
H1BrJPprna+Rei7NU/9d1R4SPVvHNpnxwJ3CnCWmUD+x7kRngkuAN4wK+uEV
jWlC5PUF1oCeQVeAI6BbaifWW2BQBxfGOFinB+o+92XWxStzY+P9xd9W8rvz
nkXX0/k7M8cOPoytS64X/6DCOAv6BB/hOdFjRD+TG3M4NTKusUztLL5vbN3G
enxaMneUth/AiBYFm3+NeIdWxlzAhP4qjQuBY/1ZGsv6n8ZyW2ZMba2OTXL7
JE/mxpAHsp/yTLl9ho6pY0vgt7+Id2xmHA/7CEwbnfZP7lgbuu4r9ih8TvYC
9pzK8Z7f0Q+590TwWnDb+eiQ1PGfOZFjSw+rzRX9Ov6g2jzmsK7tlNsm+IK9
qzLG/WvuGBljw3YjrocejgvH7B5GJ4j/kK65KzJGBxZOvI+41ApsF9Zm7rjh
rczJwrE/5tKPuXF+ML0/csfs2MsaJsaTF6B+xOuu8T0q+i/J/JbZnvw+N4bP
POys47jSz7MePD7s+Qenjjsx99jPjoyNR4FRjCn9e6rkD84cx2mnfs4RvxV7
i657IPW3eIB1lpj/LHZ07BjWW7HfM2OYpj4OzewnHqd+Dist92Zs/5HvOF3n
D8v8XV6LraPYp47XfR5Njft9Gjvuwbv9JHaslXf1qO6/Y+JnfLpw/BI74IPQ
D9+ou/pYnlpfdeOY+r2tkvwRku/CuNlPMn+LJ8RvVRpzfEr0kaKPR3fHftaL
JLM6NgaL/fNqbGx2YeT9HewV++eA1Jgf6wtbhTgf7wcb453cc499H3wWm4fY
4X1qkyLbSx/lfie/aFy9ctuZh6WOseE7YyMRj+Td7pzYzsIG66Dz96fGindI
vMey5+6hfu7ObEu9E3tOMseOxRdJjSc/Ezs+iV30Suw9lnlbN7FdcL7ot2PP
Q94VfvLwzPGOtqljsOwveyV+r3wv3uHPucczQ7LNMs/hHcQ/L/cesS52zJyY
19ex4+TE4y4gLqM2LLItgr+CjsKGIe40KujGBvpGu+n3eZn9H/aj83WsrTZU
9Dgdt8mMaZ+V2C4B97+xcLwMmrjYzYltc/Rkff1uyByKHUdFry4Wv25pPQYG
TgyMceDXRGFP2Vrv4KLUPuOZkklL+5PXx461sgcti43ro9uXxI7N9o2M/+8o
+fr6vZf6uCq1HXWt+PVKxx4aizc/tQ22t44LUtty2+h4cWr/Fzx/uPTVZnrm
y3Tt1qXjEwsK+yf4JjWD/0EcZ2TimCH8W2PH+tDJ4P9D1U+e2Tch1ss17Ing
LOzBp6XGrT9Ez4OdogcZG3ZC6T32ENG7lN6f7ogdo+abEoM4Hb86c2ximOia
om+MHVdhX5ura7cqHS/ZRfe5NHWc5RzJ1cgc27o9dgycb72rzs9Nve/cEDs+
xnwgFkMsk2drqPPzUu9TxGW2Eb+2+KMz+0v4Sh8Xjitjg+HX55IpY+eEDNE4
U8lNFL9maexjV/zU1HGQDVLjQ9gVV8fGCTqFdzIrd+zvTF3/T+p43yjRf6WO
rcyPHddiDCMz48LNWS86Tk+NMyzQ+Y1jP/tVOm4YO0YTJ7ZHsUWxbxfr+j9F
vxxiBGDz4Njn5I79/Zw4lp4yfwrHlbHxwPx/1+84Ns4EVgXW1D4xZro2ss12
DfEB0X/Htv+w/eZnjlMQc2gr+V9jx4vBi0q9qwodKnqT0rjJ8MQ5BWAas7EX
Sq8lsLofU+N1s2OPhfcwLPP4wH+w+75LbftdGhuHA8/ZSrxJqTGc/QpjEOAP
V+HrxqYvjz0WYtMjedbSeBCYTy0wbfYFtST2d5mjYxr7e02TzKDSuEeNgH8Q
o5xRGKPhWRarbRY7To2O/D61nqyr44zUcUAwq01Ly51bGGcBYyEhKU9Mg4Od
pvn2G7ap2szU8cQc7EKtY+Z4R0u1wbF9ohG57W18n8GSOSd1fOdU0WekjgUR
HyIe9I+OP0SO6eAPnR18IvTzt4XPjVZf30f2bc8W/V1kWx2sYJD6HJE6nkNc
h7hPbfG/Kvzd8Z9GBx+qnc4fnXj+nBV77jBnUp3/OHVsehMdx6XG7i6IPX/x
y/ALfinsWzTQ8fvCPgF+Bjx8Q7B8YmPg+XV0fm3he+HHvJvad9iFZyo8X/E5
hqd+Fny7L1OvHWwJ7E7snLti29HoavBU4mfgq4NT53p8EDnn6sXEvtcg/Eu1
9yP7ouRhrQ76hBwRrpmcOCfrRNFzM+OA2JDfxI5DEuN4u3DOFTKl3vHZaj0l
N15th8z7EX4f+V1DJfOR6G6l58CVmeMl9APuCLYL9viBZLqWjqOBSzUL2NSJ
Gu8zaq9JvgbzRa2Prq/AwYjdi/5Q1x5f+tn3FD0993wGVwNfA2ebnjhWR//E
6A4K72q82l+R59WFov+OPB/whf/OnZc1MHXO0RuRn3dD3eMp0b1T2/XQjIf8
GOwEbPqLEmNifdTHALWnEuP14Ihgjz2CH7EirBd8BvyFtbHfK/7yzKAPGgUd
+IXap1xbOi4PBv945hglmCJxyCbhGVdmjnuC8xFTI562Rtf+Kvql9L9wU9Qq
nPuEOcqaKKxLT9bJV1LnJhEL/q6wn/2bZF9N/0vPi06RzOupdXItHc9PjS0f
L/5jmTGFU4g74Ickxi0+T+3XE0PsU9rnHiz+mtT5SzviLxb2nfH9fyvs7/Kc
yOKb7yXeX4X3kk113QWpcX58ZfZz/N/GOv9PYeyEPnuXzjnZLzGG8V9umO77
aWo/+lTRb6X25ck5WV/YvyfH6+XEc49YJLFQ5nOSuG/WPvPtj8K4BbgHGAT2
/P6JsRawkTaiWyfWOfO4NrZ9Ag6Dv4TN3z91Pib2CXEn8E9iSfgmn+S2Xb/L
HKPCxma9kOvGs5DHMzv4+O0ke7Rkro2MjxIHxM/vIn4n8Zfx3grHl8Ga8E/x
0/DRjlQfczLPefzKz3LHtshDmhXwulqF8+d4LtYrNPMNjCgOPia2+buxbfje
6qNnmOdl7pgKWMghum5m5rysW0rn1YCdk6N1SfB3wCrIvwSvYI4z19EJrXW8
NPN6waf+NjfODJ5KfgbYBL4W2CvfYkblePgP+M1ql2dep/hOX8R+//T/ZGYc
/s3M8WBi2W0z60F0IDmYLVPnYRI/Pjb4JuAM4AXYpW9kjj2TM/Na5pg8MX10
FO+O9wYG9lVsHGxvdFXqnBAwaWJb+Es/xZ5zzDfwaXI7waiPw27OrHPQw8eV
zkedFtY+MTJ8R2Lc+Dkvp17v6I3nsJUz2z28J3BP/C9yJ9gn2R+vDvvRujBv
yanDxno7c64V8X4wT/Zt9t13dK8Oldf/u6KPq7wm38a/r7xfvi66beX9DHuP
fZ79nZwccm7AmbFPNisd68RmuSLYLW+Id3Tlvf93tbMyx+bYI9BtxFyIrZN/
Rd7zm6LbVd7X8ZXJwcNfBpPoFvzrRWE/ZQ2Tb8z+jn7AV34/tj8IXpoU9vEH
a4wrMseg8bnBfJg7+PH48+zF4LqtS+cJwwcvWBzmA3nb5DqAdYF5gZl0Ee+K
zL4k/YFf0A9xIjAT9o83UutYdBF5hB2C7/xJap2JbnywNJ7zJPMttX5Gh4P1
8szooNWp9Tk6HGzgvdjzFkyXPAR0InGka0rHksDayQ3ArwYLJ0cLX/108f4u
bGuC9REvAVevcsfV2NeG6vyfhW3TJpnjGfjsZ4j3b2E7+EIdNy7te+Drvxzb
l2fORKXtKuZVUnpvZl5lpffmRuqzSWpMkjxwcs2JTWMLYi8SJ5pTOI8WP429
jT2OvQ/sv05iv5W8gWWZMQ3G3Kmyvb6neAelxjnJn5gRMAHizeBB4B7YmP/E
ts3+zJxLjD2BDUacG3uXWBh5MHUj5+5gd2H/jMptA7+WeI/GFsL+Yf+dVHoP
AqN6Mfa9wDNeij2GPmG/1s9oUO79lb2VnGRspKHx//s82K4XqM+NSvtjxCaI
jYELYaP2LW1PYnOST8xextr5qfDzkf9KXGdhZBvk32CHsB5/LHwfYk3EnCZE
xsrBzFlH5BWTl7xj0DnPZravyVcCc/846Jbfw77IPHs4NoZDTs2c0jkNzDti
b2BQxNtWxcav0I9PxMaU0ImPx5YBzyBmCqaBT4muQc+ANx5eGmf+OfYY8EH4
XuQiYDcjT74aeV/kUczOnTfFN/k+fBfydcD+0Ano1s9i73fUU5D/tzyyrvk8
tgx5/mDx4IH4lOR74FeST0zca5H4J2Mfhn3/DNFDUuMV5LqT+/6k6F7o3WB/
kkvFeyZHi/hgo9K4H/HDlbFjiOBpxMAuiJyXTq45thx4ALlGYALk/RAf5R2S
40e+O7EYfE1yjfA3byydP0wOC3lMc0vnOpwWfAz8CLAH4tHgD+SNXxxi4uRj
LMidJ4D98WTsWAM5Zexr5HRhyw0s7UeT90iO40TWFL5eZtyA+BNxKPY47Aow
a3TFPqVzSsEM0WnknjK3u4NvZ8a39ytdB0GsFL1CrgW6BV1CrgX6pG3oc2lY
a2DZ2B7EW8jnwJc/tHQtDHFEMM73c9tgYMbUj4AbN6ycn3lw7loK6mJaBlse
fwp7HnsfjB7sl9xE4v3E+vGPsMmwx4jnkofJ98Rvu1Z9nprbrr4y+E3ELMCb
BoR1xP5chPkzXO3VxHjk0tiYJPjUTbExq2OJteXGp8mNfCrzHgr+Vrt0Dkwm
3pjM+Uv9kc2cy4ruIh/r9cRYFXgcONU9pePUYO7kJj6b2m5mbpOTR+0PeObO
pfNtWHfoSPJ/ahTO9cJXAge8OfZzgXndEhsre6F0Liu5ZGDgP+Xev14sXZNC
ngC4+56J11qP4AuTR8Q3a5B4n9qtdJ4t+wD1K+QA4z8TV6fOBX32fOm8XHLV
wO7B8Im5gBeSK4WPQZ7ZPZnjMm1y535hq3fAX8wcQ0FPtwq6Gmyed8M6xYfe
N/F3xEfCJ8GGJ9ZMvjExafITxpbW+eQ5UJfFnO+YO5eUPBBibMTwWFPE88nv
JXZO7jdYcz/xDyldz4UsNU/U/pDTAD5EvQB21gal88/B6chbJ48ajI99g5x/
9g7sFuL+6M+euXNNbohsnxMHx+YhBgK2jj4kfkGsiDUFrkbdBHgWez71C+z7
rFuwe3Q+dsGIYBsQfz+rtF5irPUS6zHiP9RDEQMi14+4D98Ge2R4sEmwO4YF
24OcAfLOeT/ghdQggNNNCb4ydj7+cotgMxd6Z2MzY+DgclXpegpyLjcJmM8f
ifcyzBTqpKjL+s8XSIwdaRr/h5XVKJ1rR+5OreAXs8+1DT7gt9jbmfPHyNMD
bwW7Q+fOjY0Tgm9Ry4Zd803h+iDsczDPo8J6bxv2T8bzQ2qstgX6vHC9G3sf
e2ybIL+ucH0WGBRYafswZnKJNg1+NPZ+mzBOQALwSrBKcHpqVVijvXV8Qu3N
yFjkotiYIefrBvwQrIb6JexbMHLyWtFD7BOXxY5BMCfAOo+KHLtArxG/WJ8a
X24eeb9cGBtbZt+6JjZeTd4k8Qz6Yb+fF3uc1Nx9ndvPJY8WbJpr8XnahndF
jhwYPRg1NXef5vaXyYcnP54cnr9TY+5g3StK123hx2EHPxTbbwIbBUsF82Td
3h87nwS7lRw/bNedMsdCiIMQX12o99I5ty/ZIndcDXuqZ7CpsL9OCDbYS4Xr
LdET5OU8EDs+Ti7Og7Fj7qx5Yk7Em8hPuS92TPxI9d0qdyy00hjOzRzHwcfF
1wVf68a+kjuvZ5PMsSjiUJtmjlERsyDORAwD+i2NZVXp/G38jkXgb9xD9MMa
62Pi/1y4XgzfkFgReTnEg/iu4JVglXUq14f+rXssLo3PgImACVFDCtZDngBx
Jmz1T0vrevQ8cSbyeOCDg1GXh21P7Ofa2DGjBuGd8M4Z78wwZnCBZWEMxOSI
9xDrAbulJg6sdmXpmlN8f/B+8mZR4sSHiLeBbe6YOdbFc22eORY4LNgMU3Ln
aVAjAx6K/EHM5dQxVjAM8EtwDOwG4tPEW/cnDpk5t2HfyvVoSfC3ya1nPAdU
rkvaWPx3MtcPcK8mleuYPhdvaeJaEPohP4K8JeZDJz3H/aX3pjvZNyW/LzZu
5VyIrfDfKtfm7JJ5f8NOYI9D16Jz2ceon6JuivxzYvQPJdbJ4CJHB324O0pF
rb76OKRy3sXWmcdwX+mcBnBuctHBGcBAqEtg7Fnu3EpsSGIVxF+wScDUqfsD
VwdvI0cazA0skLxo8MB6lfNv8Y/JSSdHnbz0LzPnrhNf/Spz7jn7O/mi5GiS
n0l89YrK+ay7VK7Z2V7n6leuCdpW9PaVay3xp7epXOeIz71tZR+BGsQGlWuF
6mSOD1IDhr7aoXJ9JT791pVrP8FmwCnJ4QeLeJX+1H4IY2FMu+v6PSvX+TbO
bG+QL8F7J8/21sx5L8R/ybnpH+YSNUF3JP7+HNENxAHJpyXfluv4/lyLzXpQ
7tyaA3PnwNyZOD57T2792Vz0XaX9ZeLD1KGxjsjrBLMArzhaMveWnjO1cufZ
Etcipk1/6EhkWga9B6ZFHgZ5AsS5kUN/koP/QrD3WBOH5mFdpB4nWNnVledS
u+DHo+sYG7YodQH3JNa35LXgC5Cn8Jzu/UTi3EtqwLA9sP9qh2fBdkMfskaI
C59RWs8z96kxoI56XNB12IbN9Hu/1HUETXOPk7zLxZJ9WHL9cut7xgH+iv1G
3s7yxLlYHLGhwGs7hz0IXXpN5dpyYuurctvD+ALEcojZ8M7JqcV3wD/gHHgA
9SXUrpCLvi5zHcY5iW128g+x2y+vnMe7Y+6aDGowqL8YHWjWBVgpmCn5uz9l
zism5/GjzPUh1Ib8nDnHF9z1G537NrFNyJwlXwH/A2yEfH5iL/jzHyauUwAH
Jrd/XuB9FPjkw1Grg64mt+nrMJZLKtcXoBve1+8PEufhv5+5LouaLLAeaheZ
/9TmUCeCHDnS5EIzPrAt8q95b2Bs5LuDe5PnTC579zBPyJ8mpwW8mBoPMHBy
bPHN8MsuroxRcH/6IZ+Z+f9r5vxtcidnVsbTeE/E4qndxa4j5l8rsX0+rXK/
34JzVPavecfEj/jG9PlH5vzqyWHs68P4qa2hjoW5xzv6Jrz/deG94SMQy74h
t100Nsizpr5Wn/unzv8h75qalMvEv7RyrvvGufPcyY0n153cceqeBifGWak/
AmulrpmaZ+LI1EFTU03MmvpcanWoTaFmhhok5iT2PbUNvIcPM9cWEU+eVLmm
DIz5s8w1WeR97JC7BoD8f/JVrshthxM7pdZpbfguvEdqb4iVU89MPQXPiB7h
eXkeauHAc9gjqQminpa6YGp3qe2innpO7rm0JnPNFPF/bI/plet88IU2TGw3
so9QX0SeId/p+8Q+LPVQ1Bl9mjhnhdwVfF7u91lYa7xD6sq4L7W9yHKeejFq
x1gP4CzUivHe+BbUIxA/5L1Tw8S+xvk1QYaaJGoMqeOjjnhR7nX6v9w1G+Aw
+F3Uw7AfYXdRR3lJYjuM2h9qsIl5sf/gv48I/XPPd8ParBsZF5pXubbwkNR2
LLgNewd1Yjwj9iT5MuS+YFuQF4Ttht6hNoYaCb41ddHcB5uGvBf8fuxP8m7I
xWHvpjab94QNQU4RdiW6mRjGuGCDkU9ELhR1yeRZsUehO/EpBoS9FayBb3RS
aozi9WCfk/9O7jh+Gfkb+InkJpOjTI4N+Bvxbf73Armi5D5hz6Lfie8S28Um
JA8dbIH8VvLP2VuoFSYmju0JBt6lcu4IWHrnyrkXxDXIocAHvz5zfgi+IDGo
lcEWBTPvXjkvB1y3W+W8HPxWcqDI0wK3IfeHXC7iFeh9YhbU0fE/K1Yn3pep
H2MuYdOQe4aNj51BPTl1ONg95LZh85Ij/n1sbAqbhrw1bOdbMuc74dPh95HX
hG/Iuv4g89oHh+9VORcKH4T8JfQfudz8H5s3Esfafkqc80OcELxoRWScjjhr
g8j4ETg3z0INxeOJMQnqeqjJZC8ATyLXBEzps9LYB7jHJ6WxQvAG/LE0cayf
Wh7qoKjx6RmuBZ8n9/OF2DYJdu3zsXNQyTU9oDQWBB4GJrcycmxrXfCpwQDw
qdFL+MjkJpB7QN4H+R+YxdRKP5+59pk4NTVg6CvyKf6rWY59pIaZ/GBiiGfn
zoNaHexDdA35Gy8ltgeITxFn5zdxft7rmsj1xNTZ6u+/eDM+FrF1aqepryMX
/cQgg29L/S6+BjWz5PNjwzyd2F+g5uJ20Z+XxkPB1R4r/D+GwN5WFP4/IOBA
4K99c9td5J08kzjmSd0DNhiYLrHoE4KfTuyKNcT7BG8kX4Jr9std344/AyZM
vhnYFH4RuUZgD3dlrt0ghoA9SY0PMQFiB9SP4K+DhxJv+Shy7g3/p4b4CDFo
con55vdmrhUCq6bWjFq2xYltbup6moa5dELlGiH2bPLC2Vex/ai9Jz+d+BF1
P2DOxKqo5QHHIq+JvDO+O/Ed/scH+cfkUZFP1TTsO/y/D2oK+T8l5KOCTxMf
v6xy3R35Sz1L5wuBeRWJsSNq/6jpW5gYA+d/DbFOsFHJXb836HJipehzalrg
Yc+gN7dM7KvWyV33iz1G/hf/IwWcg9rPH8PcwK+jPghMgn2HHG7yt/FzqeUB
9wZ/4H8PkTvMeuxTuS4LjJ3/P0JeNVgi9tYTYV71rVxHRA0Neb/g/WAOF1Wu
vWcNgVuxjohZfhcbOyUHgVoUYuushx9j5zWBdfN/msijx44lbx67kjwHapKo
R6K+nHgE8Xbiv/zPF/LIicmSm02cl3wD6pU6hnk+sHJONrHV9bHve2PmHEgw
KnJNW1fG4rHffg82HTY5NQbY2qydkyrXZjySOZ+cmBK+N3VVYDzYk+RYY4vu
Xvp/PrBPEe/g/9SQSw2Gw/+Wws8BLzqlcu0H8WVyt8Cbqa0n5kXsi5gwdUaM
fXnm+h3eJXkR5OuR38z/BaDGB91PvgH1QORA/x9hA0fh
                "]], 
               Polygon3DBox[CompressedData["
1:eJw1nAf8l9P7xp95zid7ZiRSESlE9qwoNCQaKFIRUhmRLTRRIikjkRYpyZ6Z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                "]], 
               Polygon3DBox[CompressedData["
1:eJwt1nuQj1Ucx/HH7u+3K6zbuqVIug4NpVLoNkmpbIqJbpgof1TWnS6MMClJ
JWFSCNVQul+oSE1CKbdqpRblmiQJW2Ftr2+PPz7zPJ/3+ZzznOec85zznNq7
f5finCRJHqEs5eQnyY/0cG6S1KQnKiVJhv+JRvO1aCK2Jy9JvscG8kc0MByr
wAbRAWxQJkkex6pFPewoNhSbjB3hi2kfNgB7DDvIb5B9AKtMY7ADWAl2P59P
o7F6/GT8BPUepJlYATYWOyYzDHsWK+cH0H5sIDYeS+Q20iisBk3AfvfSN8t9
xF9Hc8Xe5M+TW678cXWb0x/8GNlC5evk1tOjWKN4Z/drZboah5EyjbHB2Baq
Kr9X7iFcJFkTWfoc+4FGui+gTeqOkzlb3Qf5n6mh/GqZ7fQG34H2yNWt7P3l
1rkfoE5/eosOyeV6SIZ6qjsHO4D9o96/1Bl7kp9IZe5/kNtIf/ETZJtiW+W2
0UFsPtYNe4rPkduHjcim6+Rb7Dt6mynDs8rzqJey1/nn9a+R8WsS7dIRbJnr
YOUvqFdf9m9sIXY3NjXGAfuE/wev7r4G9VO2FPsXq8nXomLsU+wwVpsvpP7Y
Rqyj576mrRbYWOxY9Nd4dYn5oZXYn7Fe8Druv5ctofKYH7kbZW6iFfEt8Jvx
Ce5bYufGGPC5eAf3V9MiZUe19wU+xP0MbTXA38Pej/Vhjt7hL1O+kO+qfy/J
XS/XCavK52vvdpk7qERZNawy1iPmkTZg76j7Np2vzoJ4Z+0WxHcg14tfFs/A
qvK18U3qfOMZfeI7Uac+1j/mjM+NZ8g9rb2W7kcApfgzcjXwOrHOs2lZFb6W
uu21vVKmN81Wbw4dNr8z+Aq6V+Zl7IQYb6qIdYO9GmPA/yJTR34x9iF2E1ZE
nYPxG/A+7nthd9J+bBxd7blfxhjEfqQvM5W103YD1xOpOjbKtSDmQa481iGW
0d5qbIV6t2GrZC7CXuR38/cpK5Bbkk3vn8N34tM8s7XcrPjW+Ac8fy7WHDtH
riqeUWcF1Vb/XNfzaJiyQn798fs2rm1jjalXDx/ofhBtUfZKzGNe+h6Fse4j
J1Ml9lTsK6wfVi73dTb9Bk7Ul4Z0DPsmm34DJ/EnUyV1S7CR2Jn8WbFf8b/K
LtFWN1qobAe2C/uAv4HmYZPju8xP95//9yF1j8rtDs73pOVxNujbb9hKvjet
wR6Ta4Y/FAuKTnaZhLXCxvBVqHmSzk8TbAhfkZPO1ZTYX2lL7Gex32XSPbJB
7Nv8oZx0v/yAbyu31tp4EmidSffh0/DhcmU56Z4cY7dHbhXWNzcdx3FYdWyK
uvWjj+rOUPdCfDxfm9rCs7FNck/wjWNssFexzdjTfFPqHudCzF+cP/yZ1CPG
DyvFHuHr0eXYIuxnbBrfLPqTpOvsF2x67E256Zpbjm3FZvKt4nzEhupbpfz0
bIoz6hDN5+dR3Wy6XmLdDJfLzU/P5ziny+h9rA22BpvoXS+I9Ytl89MzO87u
v6kQ+x1bHf2gzdprz3+GXx/7AP0o39a1Hc1XvtOzp8d+6dpebp56rWkEth3r
gr3LX0nPYgu09xo1VnZSnK3YrOgb7TVnRfFu2v5J+XXqLoi5yE3/Q+IbuiL2
k+PjEt9TfAcXY7OPj198E0nltD/Rh9O1dQZNlanvGbP0/5Q4f7E1Mpfic2Mu
M+kZVBHvn03PjUZYY1rLXxb7s9xpmXQ//1juI+qhrCv+LrZM5qr4J/KMzlhR
/MNgNbCpWAOsEnYr9hc9jBXzpbGO4p+ERmH94vyNMVNvKXYtPymYskuwnbHn
K+8Y/xtYO34HvcVfQ+uwTjGm6naLd6ftWN/4F8pL/7/iP2y37F384bz0Xyv+
uXbEd813UL8UuzHWPX53/Kvlpf9L8d+0C78lvn0aht0TayPmRb1t8Y8Qa55W
KFsvUxR9dN896sV5bY4Wx55ozlu6tqD/AE30VCA=
                "]]}, Annotation[#, "Charting`Private`Tag$34492#1"]& ]], 
            Lighting -> {{"Ambient", 
               RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
              "Directional", 
               RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
               ImageScaled[{0, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
               ImageScaled[{2, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
               ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, 
         VertexNormals -> CompressedData["
1:eJx0fXVcVdvzNrbX7k4UxcAOVGTZoqLYXVcM7C4MxAZsVAxQMbBQsZulhIGA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          "]], {}}, {
        Point3DBox[
         NCache[{2, 
           Rational[3, 2], 0}, {2, 1.5, 0}]], 
        Point3DBox[{0, 0, 1}], 
        Point3DBox[
         NCache[{
           Rational[16, 29], 
           Rational[12, 29], 
           Rational[21, 29]}, {0.5517241379310345, 0.41379310344827586`, 
          0.7241379310344828}]], 
        Line3DBox[
         NCache[{{2, 
            Rational[3, 2], 0}, {0, 0, 1}}, {{2, 1.5, 0}, {0, 0, 1}}]], 
        Line3DBox[
         NCache[{{2, 
            Rational[3, 2], 0}, {
            Rational[16, 29], 
            Rational[12, 29], 
            Rational[21, 29]}}, {{2, 1.5, 0}, {0.5517241379310345, 
           0.41379310344827586`, 0.7241379310344828}}]], 
        Line3DBox[{{-3, 0, 0}, {3, 0, 0}}], 
        Line3DBox[{{0, -3, 0}, {0, 3, 0}}], {
         Dashing[{Small, Small}], 
         Line3DBox[
          NCache[{{0, 0, 0}, {2, 
             Rational[3, 2], 0}}, {{0, 0, 0}, {2, 1.5, 0}}]]}, {
         Dashing[{Small, Small}], 
         Line3DBox[{{0, 0, 0}, {0, 0, 1}}]}, {
         Dashing[{Small, Small}], 
         Line3DBox[
          NCache[{{
             Rational[16, 29], 
             Rational[12, 29], 0}, {
             Rational[16, 29], 
             Rational[12, 29], 
             Rational[21, 29]}}, {{
            0.5517241379310345, 0.41379310344827586`, 0}, {0.5517241379310345,
             0.41379310344827586`, 0.7241379310344828}}]]}, {
         Dashing[{Small, Small}], 
         Line3DBox[
          NCache[{{0, 0, 
             Rational[21, 29]}, {
             Rational[16, 29], 
             Rational[12, 29], 
             Rational[21, 29]}}, {{0, 0, 0.7241379310344828}, {
            0.5517241379310345, 0.41379310344827586`, 0.7241379310344828}}]]}, 
        Text3DBox["\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 
         NCache[{2, 
           Rational[3, 2], 0}, {2, 1.5, 0}], {1, 1}], 
        Text3DBox["\"N\"", {0, 0, 1}, {0, -1}], 
        Text3DBox[
        "\"\\!\\(\\*FormBox[OverscriptBox[\\\"z\\\", \\\"^\\\"], \
TraditionalForm]\\)=(\\!\\(\\*FormBox[\\\"X\\\", \
TraditionalForm]\\),\\!\\(\\*FormBox[\\\"Y\\\", \
TraditionalForm]\\),\\!\\(\\*FormBox[\\\"Z\\\", TraditionalForm]\\))\"", 
         NCache[{
           Rational[16, 29], 
           Rational[12, 29], 
           Rational[21, 29]}, {0.5517241379310345, 0.41379310344827586`, 
          0.7241379310344828}], {-1, -1}], 
        Point3DBox[
         NCache[{
           Rational[16, 29], 
           Rational[12, 29], 0}, {
          0.5517241379310345, 0.41379310344827586`, 0}]], 
        Text3DBox[
        "\"\\!\\(\\*FormBox[SuperscriptBox[\\\"z\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], TraditionalForm]\\)=(\\!\\(\\*FormBox[\\\"X\\\
\", TraditionalForm]\\),\\!\\(\\*FormBox[\\\"Y\\\", \
TraditionalForm]\\),\\!\\(\\*FormBox[\\\"0\\\", TraditionalForm]\\))\"", 
         NCache[{
           Rational[16, 29], 
           Rational[12, 29], 0}, {
          0.5517241379310345, 0.41379310344827586`, 0}], 
         NCache[{
           Rational[-1, 2], 1}, {-0.5, 1}]], 
        Text3DBox["0", {0, 0, 0}, 
         NCache[{
           Rational[-1, 2], 1}, {-0.5, 1}]], 
        Point3DBox[{1, 0, 0}], 
        Text3DBox["1", {1, 0, 0}, {1, 1}], 
        Point3DBox[{0, 1, 0}], 
        Text3DBox["\[ImaginaryI]", {0, 1, 0}, {1, 1}]}}, Background -> None, 
      Boxed -> False, DisplayFunction -> Identity, FaceGridsStyle -> 
      Automatic, ImageMargins -> 0., ImagePadding -> Automatic, 
      ImageSize -> {447.72265625, Automatic}, 
      Method -> {
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}}, 
      PlotRange -> {{-3, 3}, {-3, 3}, {-1, 1}}, 
      PlotRangePadding -> {{0, 0}, {0, 0}, {0, 0}}, 
      Ticks -> {Automatic, Automatic, Automatic}], {0., 0.}, 
     ImageScaled[{0., 0.}], {447.72265625, 447.72265625}, ContentSelectable -> 
     True], AspectRatio -> 0.6567597354886113, Background -> None, 
    ContentSelectable -> True, ImageMargins -> 0., ImagePadding -> 0., 
    ImageSize -> {425.3125, 279.328125}, 
    PlotRange -> {{4.164062499999947, 429.47656250000006`}, {
     58.98046874999999, 338.30859375}}, PlotRangePadding -> None], 
   "\"Fig. 5. Proof of the formulas for the stereographic projection.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->201271285,ExpressionUUID->"6aa2daa0-4f36-46bc-aac8-bdb76ab9e10c"]
}, {2}]],

Cell[TextData[{
 "Because the points ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "85e9de4f-b604-45d9-9eea-7122e2ae4799"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "'"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7987fcab-a25b-4e58-80f8-fa91f29a1831"],
 " are collinear, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     FractionBox[
      RowBox[{"|", "z", "|"}], 
      RowBox[{"|", 
       RowBox[{"z", "'"}], "|"}]], 
     RowBox[{"z", "'"}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dd590c66-f601-4c4d-a3dd-d7a9611f32b4"],
 ". And because the triangles ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "z", ",", "N"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"79780985-52bc-4f10-89f1-a3880c050e70"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"z", "'"}], ",", "z", ",", 
     OverscriptBox["z", "^"]}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2411baa2-9e79-47b0-a4b4-fef0c66e929d"],
 " are similar, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"|", "z", "|"}], 
     RowBox[{"|", 
      RowBox[{"z", "'"}], "|"}]], "=", 
    FractionBox["1", 
     RowBox[{"1", "-", "Z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f80c5b6c-e69e-47a5-a91a-23ce9ddb2ea3"],
 ". Therefore, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    FractionBox[
     RowBox[{"z", "'"}], 
     RowBox[{"1", "-", "Z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ef51f237-6403-4d8d-9dbc-cd39499cf51d"],
 ". Calculating the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", 
    SuperscriptBox["|", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"29358cb6-5361-442d-9627-8086504a6d8d"],
 ", one gets ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "z", 
     SuperscriptBox["|", "2"]}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["X", "2"], "+", 
       SuperscriptBox["Y", "2"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "Z"}], ")"}], "2"]], "=", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "-", 
        SuperscriptBox["Z", "2"]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "Z"}], ")"}], "2"]], "=", 
      FractionBox[
       RowBox[{"1", "+", "Z"}], 
       RowBox[{"1", "-", "Z"}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7345c6d4-45cc-4008-b4be-39c9ba806579"],
 ", where we used the equation of the sphere ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["X", "2"], "+", 
     SuperscriptBox["Y", "2"], "+", 
     SuperscriptBox["Z", "2"]}], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a8c1defa-9d95-42cc-8f17-b0ecf79693f5"],
 ". Solving for ",
 Cell[BoxData[
  FormBox["Z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a214a9a5-7f01-461b-bb26-dac3aaf4da9f"],
 ", one gets the third formula in Eq. (10). Then, using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "(", 
     RowBox[{"1", "-", "Z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"z", "'"}], "=", 
     RowBox[{"X", "+", 
      RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "Y"}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "fd6d94f1-653a-489b-840e-16d6d1a1f97f"],
 " and plugging in the value of ",
 Cell[BoxData[
  FormBox["Z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a216d4f9-6e0c-4cb7-bf49-2279e5de6d8f"],
 ", one finds the rest of Eq. (10)."
}], "Text",
 CellID->476668675,ExpressionUUID->"83400dd7-d46e-4233-a453-d35132b868dc"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->95002828,ExpressionUUID->"d0ca298a-13f0-44fe-9773-df746777b185"],

Cell[TextData[{
 "Find the coordinates on the Riemann sphere of the complex number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"1", "+", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c446f183-db3f-48f3-acbd-24b1a5584534"],
 ". Is it located in the upper or in the lower hemisphere?"
}], "SolvedExampleNote",
 CellID->239009425,ExpressionUUID->"96b83501-d2df-46c8-843b-abd9a5749f14"],

Cell["Using Eq. (10), the coordinates are:", "SolvedExampleNote",
 CellID->4366196,ExpressionUUID->"3de04fea-3ba4-4eac-a707-218ed4910da9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"z", "=", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"2", "x"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", "z", "]"}], "2"], "+", "1"}]], ",", 
       FractionBox[
        RowBox[{"2", "y"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", "z", "]"}], "2"], "+", "1"}]], ",", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", "z", "]"}], "2"], "-", "1"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Abs", "[", "z", "]"}], "2"], "+", "1"}]]}], "}"}]}], 
    "]"}]}], ";"}]], "SolvedExampleInput",
 CellID->169533157,ExpressionUUID->"263b756a-70a1-4d85-aae4-b807accb1631"],

Cell[TextData[{
 "So for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"1", "+", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"da70143c-3059-499e-9b4e-6c08769d8ab4"],
 " one obtains:"
}], "SolvedExampleNote",
 CellID->1431672,ExpressionUUID->"8f3ead76-e8b8-484d-9e05-85fff5ceab07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "SolvedExampleInput",
 CellID->215975845,ExpressionUUID->"9c01c6d8-33c0-4a9a-8bb7-aac852a8851f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["2", "3"], ",", 
   FractionBox["2", "3"], ",", 
   FractionBox["1", "3"]}], "}"}]], "SolvedExampleOutput",
 CellID->170998073,ExpressionUUID->"ad111c25-f611-4821-8d99-7f3ac5e2c1da"]
}, Open  ]],

Cell[TextData[{
 "which is in the upper hemisphere, since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4e9c4d85-d2e2-4a07-a799-63c0449434e3"],
 "."
}], "SolvedExampleNote",
 CellID->79316562,ExpressionUUID->"f0c30817-8e77-4ff3-9f4e-63657089cc86"],

Cell["", "SolvedExampleEndCap",
 CellID->1442079354,ExpressionUUID->"34affdbb-285c-4d79-a381-96346cababfc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties of the Stereographic Projection", "Subsection",
 CellID->65702220,ExpressionUUID->"6e751639-19cf-47e5-9cb9-f7e95ad16f67"],

Cell["\<\
The stereographic projection has various interesting properties:\
\>", "Text",
 CellID->190068978,ExpressionUUID->"b854e51a-b1d9-45fe-9908-2963beedae46"],

Cell[CellGroupData[{

Cell["\<\
Numbers with absolute value less than 1 are mapped to the southern \
hemisphere, and 0 to the south pole. Numbers with absolute value greater than \
1 are mapped to the northern hemisphere.\
\>", "Item",
 CellID->72258445,ExpressionUUID->"06c16331-ac0a-4e84-a014-5112254c7ce2"],

Cell["\<\
Both lines and circles in the complex plane are mapped to circles on the \
Riemann sphere.\
\>", "Item",
 CellID->265359487,ExpressionUUID->"4bc574ba-f0cd-4097-8f31-3c566184fc17"],

Cell[TextData[{
 "Angles are locally preserved (the projection is ",
 StyleBox["conformal",
  FontSlant->"Italic"],
 ")."
}], "Item",
 CellID->23524305,ExpressionUUID->"c76e1d0b-b266-4445-9251-62e052cc13cf"]
}, Open  ]],

Cell["\<\
Circles and lines on the plane are mapped into circles in the Riemann sphere, \
as you can see in Fig. 6. To see how the projection is formed, tick \
\[OpenCurlyDoubleQuote]Show lines,\[CloseCurlyDoubleQuote] which will show \
some lines linking the circle or line to the north pole.\
\>", "Text",
 CellID->699960867,ExpressionUUID->"8f134571-d2f7-4183-86ec-74be1bb8a46d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Which", "[", 
      RowBox[{
       RowBox[{"Figure", "===", "\"\<Circle\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Manipulate", "[", 
        RowBox[{
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"sl", "===", "True"}], ",", 
           RowBox[{"Show", "[", 
            RowBox[{"init", ",", 
             RowBox[{"circleproj", "[", 
              RowBox[{"c", ",", "r"}], "]"}], ",", 
             RowBox[{"circlelines", "[", 
              RowBox[{"c", ",", "r"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"sl", "===", "False"}], ",", 
           RowBox[{"Show", "[", 
            RowBox[{"init", ",", 
             RowBox[{"circleproj", "[", 
              RowBox[{"c", ",", "r"}], "]"}]}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", 
               RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", 
             RowBox[{"-", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"r", ",", 
             RowBox[{"7", "/", "10"}]}], "}"}], ",", 
           RowBox[{"1", "/", "10"}], ",", "4"}], "}"}], ",", 
         RowBox[{"SaveDefinitions", "->", "True"}]}], "\[IndentingNewLine]", 
        "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
       RowBox[{"Figure", "===", "\"\<Line\>\""}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"Manipulate", "[", 
        RowBox[{
         RowBox[{"Which", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"sl", "===", "True"}], ",", 
           RowBox[{"Show", "[", 
            RowBox[{"init", ",", 
             RowBox[{"lineproj", "[", 
              RowBox[{"p", ",", "\[Alpha]"}], "]"}], ",", 
             RowBox[{"lineLink", "[", 
              RowBox[{"p", ",", "\[Alpha]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"sl", "===", "False"}], ",", 
           RowBox[{"Show", "[", 
            RowBox[{"init", ",", 
             RowBox[{"lineproj", "[", 
              RowBox[{"p", ",", "\[Alpha]"}], "]"}]}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"p", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "2"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{"ToString", "[", 
               RowBox[{"p", ",", "TraditionalForm"}], "]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", 
             RowBox[{"-", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"24", "/", "10"}]}], "}"}], ",", "0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}], ",", 
         RowBox[{"SaveDefinitions", "->", "True"}]}], "\[IndentingNewLine]", 
        "]"}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
     RowBox[{"{", 
      RowBox[{"Figure", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Line\>\"", ",", "\"\<Circle\>\""}], "}"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"sl", ",", "False", ",", "\"\<Show lines\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
     RowBox[{"SaveDefinitions", "->", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Initialization", ":>", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"init", "=", 
         RowBox[{"Show", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", 
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Directive", "[", 
                RowBox[{"LightBlue", ",", 
                 RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"Sin", "[", "t", "]"}], " ", 
                RowBox[{"Cos", "[", "p", "]"}]}], ",", 
               RowBox[{
                RowBox[{"Sin", "[", "t", "]"}], " ", 
                RowBox[{"Sin", "[", "p", "]"}]}], ",", 
               RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"p", ",", "0", ",", 
               RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
             RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Opacity", "[", "0.4`", "]"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{"1", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{"\[ImaginaryI]", ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<N\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"circleproj", "[", 
          RowBox[{"c_", ",", "r_"}], "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xcirc", ",", "ycirc", ",", "zcirc", ",", "t"}], "}"}], ",",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xcirc", "=", 
             RowBox[{"2", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"c", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "+", 
                 RowBox[{"r", " ", 
                  RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                ")"}]}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"ycirc", "=", 
             RowBox[{"2", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"c", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "+", 
                 RowBox[{"r", " ", 
                  RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                ")"}]}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"zcirc", "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"], "-", 
                "1"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
               ")"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Show", "[", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"ParametricPlot3D", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", "0", ",", 
                  RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot3D", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"t", ",", "0", ",", 
                  RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Thick", ",", "Red"}], "}"}]}]}], "]"}]}], 
             "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"circlelines", "[", 
          RowBox[{"c_", ",", "r_"}], "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "xcirc", ",", "ycirc", ",", "zcirc", ",", "tL", ",", "pts", ",", 
             "pts2", ",", "t", ",", "lines", ",", "lines2"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xcirc", "=", 
             RowBox[{"2", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"c", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "+", 
                 RowBox[{"r", " ", 
                  RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                ")"}]}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"ycirc", "=", 
             RowBox[{"2", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"c", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "+", 
                 RowBox[{"r", " ", 
                  RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"1", "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                ")"}]}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"zcirc", "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"], "-", 
                "1"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
               ")"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"tL", "=", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"2", 
                RowBox[{"Pi", "/", "10"}], "*", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "1", ",", "10"}], "}"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"pts", "=", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "0"}], "}"}], "/.", 
                RowBox[{"t", "->", "#"}]}], "&"}], "/@", "tL"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"pts2", "=", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], "/.", 
                RowBox[{"t", "->", "#"}]}], "&"}], "/@", "tL"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"lines", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"#", ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], 
               "&"}], "/@", "pts"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"lines2", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"#", ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], 
               "&"}], "/@", "pts2"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Graphics3D", "[", 
             RowBox[{"{", 
              RowBox[{"lines", ",", "lines2"}], "}"}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"lineLink", "[", 
          RowBox[{"p_", ",", "a_"}], "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "xcirc", ",", "ycirc", ",", "zcirc", ",", "t1", ",", "tL", ",", 
             "pts", ",", "lines", ",", "intersects"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"xcirc", "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"p", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "+", 
                  RowBox[{
                   RowBox[{"Cos", "[", "a", "]"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}]}], 
               ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}], "2"],
                 "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}], 
               ")"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"ycirc", "=", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"p", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "+", 
                  RowBox[{
                   RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                   RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}], "2"],
                 "+", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}], 
               ")"}]}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"zcirc", "=", 
             RowBox[{"1", "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{"Sin", "[", "t1", "]"}], "2"]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", "t1", "]"}]}], ")"}], "2"], "+", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", "t1", "]"}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], " ", 
                  RowBox[{"Sin", "[", "t1", "]"}]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "2"]}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"Sin", "[", "t1", "]"}], "2"]}]}], ")"}]}]}]}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"tL", "=", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"2", 
                RowBox[{"Pi", "/", "10"}], "*", "k"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "1", ",", "9"}], "}"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"pts", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"Limit", "[", 
                RowBox[{
                 RowBox[{"N", "[", 
                  RowBox[{"{", 
                   RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], 
                  "]"}], ",", 
                 RowBox[{"t1", "->", "#"}]}], "]"}], "&"}], "/@", "tL"}]}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"pts", "=", 
             RowBox[{"N", "[", "pts", "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"lines", "=", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"pts", "[", 
                    RowBox[{"[", "k", "]"}], "]"}], "[", 
                   RowBox[{"[", "3", "]"}], "]"}], "<=", "0"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
                    RowBox[{"pts", "[", 
                    RowBox[{"[", "k", "]"}], "]"}]}], "}"}], "]"}], ",", 
                 "\[IndentingNewLine]", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"RegionIntersection", "[", 
                    RowBox[{
                    RowBox[{"InfinitePlane", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "]"}], 
                    ",", 
                    RowBox[{"HalfLine", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
                    RowBox[{"pts", "[", 
                    RowBox[{"[", "k", "]"}], "]"}]}], "}"}], "]"}]}], "]"}], "/.", 
                    RowBox[{
                    RowBox[{"Point", "[", "f_", "]"}], "->", "f"}]}]}], "}"}],
                   "]"}]}], "\[IndentingNewLine]", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"k", ",", "1", ",", "9"}], "}"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Graphics3D", "[", "lines", "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"lineproj", "[", 
          RowBox[{"p_", ",", "a_"}], "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"line", ",", "circ", ",", "t", ",", "t1"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"line", "=", 
             RowBox[{"InfiniteLine", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"p", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"p", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "a", "]"}], ",", 
                 RowBox[{"Sin", "[", "a", "]"}], ",", "0"}], "}"}]}], "]"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"circ", "=", 
               RowBox[{"{", 
                RowBox[{
                 FractionBox[
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}]}], ")"}]}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}]}], ")"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}]], ",", 
                 FractionBox[
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}]}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}]}], ")"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}]], ",", 
                 RowBox[{"1", "-", 
                  FractionBox["2", 
                   RowBox[{"1", "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox["t", "2"], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}]]}]}], "}"}]}], ";"}], 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{"circ", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}]}], 
                 ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}], "2"],
                   "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}], 
                 ")"}]}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}], "2"],
                   "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}], 
                 ")"}]}], ",", 
               RowBox[{"1", "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    RowBox[{"Sin", "[", "t1", "]"}], "2"]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", "t1", "]"}]}], ")"}], "2"], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", "t1", "]"}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], " ", 
                    RowBox[{"Sin", "[", "t1", "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "2"]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"Sin", "[", "t1", "]"}], "2"]}]}], ")"}]}]}]}], 
              "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Show", "[", 
             RowBox[{
              RowBox[{"Graphics3D", "[", 
               RowBox[{"{", 
                RowBox[{"Thick", ",", 
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                  "RGBColorSwatchTemplate"], ",", "line"}], "}"}], "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"ParametricPlot3D", "[", 
                 RowBox[{"circ", ",", 
                  RowBox[{"{", 
                   RowBox[{"t", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], "]"}],
                "*)"}], "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot3D", "[", 
               RowBox[{"circ", ",", 
                RowBox[{"{", 
                 RowBox[{"t1", ",", "0", ",", 
                  RowBox[{"2", "Pi"}]}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Thick", ",", "Red"}], "}"}]}]}], "]"}]}], 
             "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
       "\[IndentingNewLine]", ")"}]}], ",", 
     RowBox[{"SaveDefinitions", "->", "True"}], ",", 
     RowBox[{"SynchronousInitialization", "->", "False"}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   ",", "\"\<Fig. 6. Lines and circles are mapped into circles on the Riemann \
sphere by the stereographic projection. Try moving and resizing them to see \
how the projection changes. The checkbox \[OpenCurlyDoubleQuote]Show lines\
\[CloseCurlyDoubleQuote] will show how the projection is constructed.\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.962939462067127*^9, 3.9629394739360714`*^9}},
 CellID->709520648,ExpressionUUID->"5cfd54dc-5872-416c-aad5-1fece4b5263d"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`Figure$$ = "Line", $CellContext`sl$$ = 
       False, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
       Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`Figure$$], {"Line", "Circle"}, ControlType -> 
          SetterBar}, {{
           Hold[$CellContext`sl$$], False, "Show lines"}, {True, False}, 
          ControlType -> Checkbox}}, Typeset`size$$ = Automatic, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False, Typeset`keyframeActionsQ$$ = False, 
       Typeset`keyframeList$$ = {}}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, 
        "Variables" :> {$CellContext`Figure$$ = "Line", $CellContext`sl$$ = 
          False}, "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$, 
          Typeset`keyframeActionsQ$$, Typeset`keyframeList$$}, "Body" :> 
        Which[$CellContext`Figure$$ === "Circle", 
          Manipulate[
           Which[$CellContext`sl$$ === True, 
            Show[$CellContext`init, 
             $CellContext`circleproj[$CellContext`c, $CellContext`r], 
             $CellContext`circlelines[$CellContext`c, $CellContext`r]], \
$CellContext`sl$$ === False, 
            Show[$CellContext`init, 
             $CellContext`circleproj[$CellContext`c, $CellContext`r]]], \
{{$CellContext`c, {-2, -2}}, {-3, -3}, {3, 3}}, {{$CellContext`r, 7/10}, 1/10,
             4}, SaveDefinitions -> True], $CellContext`Figure$$ === "Line", 
          Manipulate[
           Which[$CellContext`sl$$ === True, 
            Show[$CellContext`init, 
             $CellContext`lineproj[$CellContext`p, $CellContext`\[Alpha]], 
             $CellContext`lineLink[$CellContext`p, $CellContext`\[Alpha]]], \
$CellContext`sl$$ === False, 
            Show[$CellContext`init, 
             $CellContext`lineproj[$CellContext`p, $CellContext`\[Alpha]]]], \
{{$CellContext`p, {0, -2}, 
             Text[
              ToString[$CellContext`p, TraditionalForm]]}, {-3, -3}, {3, 
            3}}, {{$CellContext`\[Alpha], 24/10}, 0, 2 Pi}, SaveDefinitions -> 
           True]], "Specifications" :> {{$CellContext`Figure$$, {
           "Line", "Circle"}}, {{$CellContext`sl$$, False, "Show lines"}, {
           True, False}}}, "Options" :> {SynchronousInitialization -> False}, 
        "DefaultOptions" :> {}], 
       ImageSizeCache -> {341., {232.4045805204346, 239.6370023954346}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ({$CellContext`init = Graphics3D[{{
             GraphicsComplex[CompressedData["
1:eJyFnF2sXUUZQC+FtoiJkRgTFKhFb3wmEbDGqo3hpwVaK6L4gEZpMSjc6IMQ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              "], {{{
                 EdgeForm[], Lighting -> Automatic, 
                 RGBColor[0.87, 0.94, 1], 
                 Opacity[0.4], 
                 GraphicsGroup[
                  Annotation[{
                    Polygon[CompressedData["
1:eJwtmXfgV9Mbx++553xsKS0kycqqKOInlTREMkpDkzQQskdGZaYiREZKNJAy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                    "]], 
                    Polygon[CompressedData["
1:eJwtmmXA3UTXRZNJimuRtpRCCy3uXlyKe3F3KRSKu7u7a3F3aXGKu7u7u+vL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                    "]], 
                    Polygon[CompressedData["
1:eJwt13ncTnUWAPDH+zz2JVJMhJGlsZZsZQ2RrCFqbE32KWuWlC1ZspZQpKKZ
9qlU04KsZUkJTSRZZ0KJlqlQ9r7nc98/jt8533ue5b3Pvb9zle01pOPgrFQq
9anIKbpkUqmH0qnUTvlTDrwmZrMr2J/ElfJ67Gb5X+R3yh/NkUot0N+SVWZ3
scfYk6wFq8T+xuawhWym+nJ+mSgpr+tYD3kt+X3yl/Qt1TdHXYaXFmXkDR2b
bi2iLiyukNeOz7KWVf85Qt6IzbWWU18lysobs0pRy5vIh/mM+31GW1aV9WcL
2GLWk9Vmo9nL7A02Q12UXypKyOvE320tFeckvqO8Abtdfq18qPxZr305zimr
zuJEL2Yvss/lL/LT6hKiHFsU31m0dGw0u0901nMNG8KWqF/SN1VdkBcQxeTX
OfawNb86nygur8nayavJB8gXeu0Sr+3PbmAPsjfZ8vjt5c/zE+rLRCk2QF1P
30TH3mIrWD92PZvA3mDL2Fb5C/ykupgozRqpr9Z3h2PT2KPsDlaDDWP/YK/E
9RbXAKvOerK+bIv8Of6r+lJxJaurrqCvg2MT2XQ2TX0JLxTXpbyWY+/GuRAj
4zvpe148oi4Zv5koJa/vWB95Xfl4+VI973m/vqwOG8deZ++ynfH787PxPUQF
9oKeiuL2OOdsqtgR16y+M/KSory+7uqa+kbF78xeZ7nY5ewadifrx5aqq4h+
7An2uLheX3l2K3tQPU3ffvk5nstahzViH8e5ZD+rC8V1xCqrN4umjvVmA1kF
9cZ0cg/85H3LyyuKTeJGdpe+v+urpt4imrN+bAirrv5UtGD92VB2r/qYmBn7
A3uHDVN/J2awV9nbrKr6E3ET68sGs4nq42IRW8nWs67qQ+JeNo89nUo2o/gt
R2Ql5yTOzc/Z98fNbEB8Z5FXX302KSv5veN3j/t+QzrZB37MJHtAFfGxaBa/
v55BPqKo1zZ3fC57O/4OUUfP56I9G6oera+2+j+iHRsS9yWrpf5MtGWD2Sj2
qzy397vS2oZ1YifkeWKfsLZlt8W1of7Fa/+rziNyiwksV1yr+lqrW4kf5RlW
zNpC3c5rf5LnZMVjD2bt2ffydOyp1uasLevm/Q+L4Ww+e4Ztkp9kP6nLiIps
OzvFTkUtqrOa6u2ijWOD2Eh2nXqbaM0GshFsm/w39pv6anENq6HeKlo5dg8b
HnuO73aC/Rj7Q+wvIktdJK59fd3UvfStk//Kv1UXj+/I7lYfFQ/FvsBeY/XU
O0RHNpyNZXepj4gH2FPsOfaL/J2YE9Z6rBk7LX8vZoK1aZxntiP73Jdg9VkD
8XvsJzFPrE3Ut+jLq14R+xjryLqmkr1lXTqZiccyyT4Ts2h9OplXP2SSuRRz
4oN0sv8czyQz44x8WcwkazPv19r7NVfvFT3ZBPYwa6reLbqxsWwya6L+UnRl
Y9ik2CO8b2FRKSu5fuI6uknPHtGDjY/9Sl8H9UFxN5vJ5sV1mr2vdclK5k7M
n2Z6vhLd2Tj1FH0n5Xn1lY75EvOJFdezNp3M8aNxvaaT+b4mnczJbzPJrL9N
fC0GsUfinvbaVup9ohebxGaxTur/iYHx7BF7Imug/iLeg41k41kv9TdiDHs6
9nvWO64fMZY9E/sB+0H9VDqZTTGjXs1Knis+TCcz+/tM8ozRMe5JcQ+bpW9+
Kpn5q9PJc8Y3mWT+x5x9P53M3UOZZOaezt7H+2YlMyFmQ2u+X/Rmk9WzvV8e
9XJxLevA/ppKnmdWpZMZdiSTPNu0EQdEHzYl5lgqmXcr08lsP5xJZt8n8n9a
f9FTOOaPvlMsXzw7WduzLuyCvFD8xtYurCdbnUn2v3lsPfsw9rbYr9kctk69
Wd+o2DfZo2wt+4itimeK2GPUl4gC8X7sybgP1UVEQfZAzA6vne/YBraFjWRN
2SNsDdvExrKW7Am2iW1lY9jN7HG2MUfyjDow7is2Ne5jtpqNY7ewBewjto2t
kS+K60NdNOYjez+TzIrJWcleH3v+CD03sllslXqDvuGsCZvNVrON7J64VtiU
2BfYKrYvnhV4xlqBVWNfyf/FclivYpXZnpiJLMtajlVhG+VL2PfqjCjGPsje
J3/IngkxGzbre5b9P86xuELfBraYHY99VFzOPox7gH2nvhDXrVgf9wA7xlLi
svhcn/E7O5e9D8d+PFjdmE/Tv1y9Vt9u+Ss8ZS3LKkm/k78V+7b1OlaP7Y1n
AJa2lmdV2dfypSyvtTKryY7K32SFrTXYDeyQ/A2Wz1qF1WLHYxazotZasRez
Y/J/s0utNVn9eE70fS/EvciqxrmPma5uxB+OfVW9Rt/4mEVsIdvMtrP34jkj
7k11DpGLfcNyxDOltTFrwY7IU3GfWRux5sqD8vNem9talzVmh+UXWUFrw9hz
2aTsvbgy6xr3uUjH38Cqsu7q3vruz/47CmQlcyfmz3R1B/4826neq68+2yk6
sRFsHNslP8MuxuwVddh5VtBrK1g7sx7srLxAPPdZb2Pd2QH5Wa/Naa3NGrJz
8vzxjGXtxLrFc1329XI++xzHuf7C8dPsQjwviNqxx7Ks2OetN7E27KL8Ena1
9XZ2J5sR+yx7gX3B9sWzPLuVPcd2sD1sbfYz0kF1zviNxArHH4/ZIM8boW8l
W8AOxX4j8rNlbH7sn3HO415i77DHYraqzyc/a+pdNjfmD7uYPHKm3mZzYmay
s+q4Bab6p70XPOvYZ3x37CXyJ2KexWeKfGy2urO+lx3bzQ6yKawdW8K2sy/Z
rJhj7CX2JTsQ3yeueVaN9WB9Usn/w1uzp9mnOZL/k09mbdlito3tYjPjumAv
sl1sf1x/MUPYM2xr/GasIdsV35GNYhPYH5N22nY=
                    "]]}, "Charting`Private`Tag$26482#1"]]}, {}, {}, {}, {}}},
               VertexNormals -> CompressedData["
1:eJztyDENwCAABMAPDUJYaqMekEDCjHUkVAE7w914baw+S5K3Jk9O9ue99957
77333nvvvffee++9995777333nvvvffee++9995777333nvvvffee++99957
77333nvvvffee++9995777333nvvvffee+/9Df8DFfMaLg==
               "]], {}}, {
             GraphicsComplex[CompressedData["
1:eJyNfXVcFl3zPvZjdyu2YmEnyGJgYItiYYES9mMDNioqJgYWit3dxVHCLgQB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              "], {{{
                 EdgeForm[], 
                 Specularity[
                  GrayLevel[1], 3], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 Lighting -> {{"Ambient", 
                    RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]}, {
                   "Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, 
                 AbsoluteThickness[2], 
                 Opacity[0.4], 
                 GraphicsGroup[
                  Annotation[{
                    Polygon[CompressedData["
1:eJxFnAf8V/P3x+++NyNZP6NQKEJkZ0RDVIq0tDQJpZIKKSIV7ZKyigqZGdm7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                    "]], 
                    Polygon[CompressedData["
1:eJw1nAf8l9P7xp95zid7ZiRSESlE9qwoNCQaKFIRUhmRLTRRIikjkRYpyZ6Z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                    "]], 
                    Polygon[CompressedData["
1:eJwt1nuQj1Ucx/HH7u+3K6zbuqVIug4NpVLoNkmpbIqJbpgof1TWnS6MMClJ
JWFSCNVQul+oSE1CKbdqpRblmiQJW2Ftr2+PPz7zPJ/3+ZzznOec85zznNq7
f5finCRJHqEs5eQnyY/0cG6S1KQnKiVJhv+JRvO1aCK2Jy9JvscG8kc0MByr
wAbRAWxQJkkex6pFPewoNhSbjB3hi2kfNgB7DDvIb5B9AKtMY7ADWAl2P59P
o7F6/GT8BPUepJlYATYWOyYzDHsWK+cH0H5sIDYeS+Q20iisBk3AfvfSN8t9
xF9Hc8Xe5M+TW678cXWb0x/8GNlC5evk1tOjWKN4Z/drZboah5EyjbHB2Baq
Kr9X7iFcJFkTWfoc+4FGui+gTeqOkzlb3Qf5n6mh/GqZ7fQG34H2yNWt7P3l
1rkfoE5/eosOyeV6SIZ6qjsHO4D9o96/1Bl7kp9IZe5/kNtIf/ETZJtiW+W2
0UFsPtYNe4rPkduHjcim6+Rb7Dt6mynDs8rzqJey1/nn9a+R8WsS7dIRbJnr
YOUvqFdf9m9sIXY3NjXGAfuE/wev7r4G9VO2FPsXq8nXomLsU+wwVpsvpP7Y
Rqyj576mrRbYWOxY9Nd4dYn5oZXYn7Fe8Druv5ctofKYH7kbZW6iFfEt8Jvx
Ce5bYufGGPC5eAf3V9MiZUe19wU+xP0MbTXA38Pej/Vhjt7hL1O+kO+qfy/J
XS/XCavK52vvdpk7qERZNawy1iPmkTZg76j7Np2vzoJ4Z+0WxHcg14tfFs/A
qvK18U3qfOMZfeI7Uac+1j/mjM+NZ8g9rb2W7kcApfgzcjXwOrHOs2lZFb6W
uu21vVKmN81Wbw4dNr8z+Aq6V+Zl7IQYb6qIdYO9GmPA/yJTR34x9iF2E1ZE
nYPxG/A+7nthd9J+bBxd7blfxhjEfqQvM5W103YD1xOpOjbKtSDmQa481iGW
0d5qbIV6t2GrZC7CXuR38/cpK5Bbkk3vn8N34tM8s7XcrPjW+Ac8fy7WHDtH
riqeUWcF1Vb/XNfzaJiyQn798fs2rm1jjalXDx/ofhBtUfZKzGNe+h6Fse4j
J1Ml9lTsK6wfVi73dTb9Bk7Ul4Z0DPsmm34DJ/EnUyV1S7CR2Jn8WbFf8b/K
LtFWN1qobAe2C/uAv4HmYZPju8xP95//9yF1j8rtDs73pOVxNujbb9hKvjet
wR6Ta4Y/FAuKTnaZhLXCxvBVqHmSzk8TbAhfkZPO1ZTYX2lL7Gex32XSPbJB
7Nv8oZx0v/yAbyu31tp4EmidSffh0/DhcmU56Z4cY7dHbhXWNzcdx3FYdWyK
uvWjj+rOUPdCfDxfm9rCs7FNck/wjWNssFexzdjTfFPqHudCzF+cP/yZ1CPG
DyvFHuHr0eXYIuxnbBrfLPqTpOvsF2x67E256Zpbjm3FZvKt4nzEhupbpfz0
bIoz6hDN5+dR3Wy6XmLdDJfLzU/P5ziny+h9rA22BpvoXS+I9Ytl89MzO87u
v6kQ+x1bHf2gzdprz3+GXx/7AP0o39a1Hc1XvtOzp8d+6dpebp56rWkEth3r
gr3LX0nPYgu09xo1VnZSnK3YrOgb7TVnRfFu2v5J+XXqLoi5yE3/Q+IbuiL2
k+PjEt9TfAcXY7OPj198E0nltD/Rh9O1dQZNlanvGbP0/5Q4f7E1Mpfic2Mu
M+kZVBHvn03PjUZYY1rLXxb7s9xpmXQ//1juI+qhrCv+LrZM5qr4J/KMzlhR
/MNgNbCpWAOsEnYr9hc9jBXzpbGO4p+ERmH94vyNMVNvKXYtPymYskuwnbHn
K+8Y/xtYO34HvcVfQ+uwTjGm6naLd6ftWN/4F8pL/7/iP2y37F384bz0Xyv+
uXbEd813UL8UuzHWPX53/Kvlpf9L8d+0C78lvn0aht0TayPmRb1t8Y8Qa55W
KFsvUxR9dN896sV5bY4Wx55ozlu6tqD/AE30VCA=
                    "]]}, "Charting`Private`Tag$26510#1"]]}, {}, {}, {}, {}}},
               VertexNormals -> CompressedData["
1:eJx0fXVcVdvzNrbX7k4UxcAOVGTZoqLYXVcM7C4MxAZsVAxQMbBQsZulhIGA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               "]], {}}, {
             Line[{{-3, 0, 0}, {3, 0, 0}}], 
             Line[{{0, -3, 0}, {0, 3, 0}}], 
             Point[{1, 0, 0}], 
             Text[1, {1, 0, 0}, {1, 1}], 
             Point[{0, 1, 0}], 
             Text[I, {0, 1, 0}, {1, 1}], 
             Point[{0, 0, 1}], 
             Text["N", {0, 0, 1}, {0, -1}]}}, {
           DisplayFunction -> Identity, PlotRangePadding -> {{
               Scaled[0.05], 
               Scaled[0.05]}, {
               Scaled[0.05], 
               Scaled[0.05]}, {
               Scaled[0.05], 
               Scaled[0.05]}}, ImagePadding -> Automatic, DisplayFunction -> 
            Identity, Axes -> True, DisplayFunction :> Identity, 
            FaceGridsStyle -> Automatic, 
            Method -> {
             "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}}, 
            PlotRange -> {{-2.9999995714285714`, 
             2.9999995714285714`}, {-2.9999995714285714`, 
             2.9999995714285714`}, {-1., 1.}}, PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02], 
              Scaled[0.02]}, 
            Ticks -> {
             Automatic, Automatic, Automatic}}], $CellContext`circleproj[
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`r, 
            Blank[]]] := 
         Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t}, $CellContext`xcirc = 
            2 ((Part[$CellContext`c, 1] + $CellContext`r 
                Cos[$CellContext`t])/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2)); $CellContext`ycirc = 
            2 ((Part[$CellContext`c, 2] + $CellContext`r 
                Sin[$CellContext`t])/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2 - 1)/(
             1 + (Part[$CellContext`c, 1] + $CellContext`r 
                Cos[$CellContext`t])^2 + (
               Part[$CellContext`c, 2] + $CellContext`r 
                Sin[$CellContext`t])^2); Show[
             
             ParametricPlot3D[{
              Part[$CellContext`c, 1] + $CellContext`r Cos[$CellContext`t], 
               Part[$CellContext`c, 2] + $CellContext`r Sin[$CellContext`t], 
               0}, {$CellContext`t, 0, 2 Pi}], 
             
             ParametricPlot3D[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, {$CellContext`t, 0, 2 Pi}, PlotStyle -> {Thick, Red}]]], 
         
         TagSet[$CellContext`r, 
          MessageName[$CellContext`r, "shdw"], 
          "Symbol `1` appears in multiple contexts `2`; definitions in \
context `3` may shadow or be shadowed by other definitions."], \
$CellContext`circlelines[
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`r, 
            Blank[]]] := 
         Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`tL, $CellContext`pts, $CellContext`pts2, $CellContext`t, \
$CellContext`lines, $CellContext`lines2}, $CellContext`xcirc = 
            2 ((Part[$CellContext`c, 1] + $CellContext`r 
                Cos[$CellContext`t])/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2)); $CellContext`ycirc = 
            2 ((Part[$CellContext`c, 2] + $CellContext`r 
                Sin[$CellContext`t])/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2 - 1)/(
             1 + (Part[$CellContext`c, 1] + $CellContext`r 
                Cos[$CellContext`t])^2 + (
               Part[$CellContext`c, 2] + $CellContext`r 
                Sin[$CellContext`t])^2); $CellContext`tL = 
            Table[(2 (Pi/10)) $CellContext`k, {$CellContext`k, 1, 
               10}]; $CellContext`pts = 
            Map[ReplaceAll[{
               Part[$CellContext`c, 1] + $CellContext`r Cos[$CellContext`t], 
                Part[$CellContext`c, 2] + $CellContext`r Sin[$CellContext`t], 
                0}, $CellContext`t -> #]& , $CellContext`tL]; \
$CellContext`pts2 = 
            Map[ReplaceAll[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, $CellContext`t -> #]& , $CellContext`tL]; \
$CellContext`lines = 
            Map[Line[{#, {0, 0, 
                1}}]& , $CellContext`pts]; $CellContext`lines2 = 
            Map[Line[{#, {0, 0, 1}}]& , $CellContext`pts2]; 
           Graphics3D[{$CellContext`lines, $CellContext`lines2}]], \
$CellContext`lineproj[
           Pattern[$CellContext`p, 
            Blank[]], 
           Pattern[$CellContext`a, 
            Blank[]]] := 
         Module[{$CellContext`line, $CellContext`circ, $CellContext`t, \
$CellContext`t1}, $CellContext`line = InfiniteLine[{
               Part[$CellContext`p, 1], 
               Part[$CellContext`p, 2], 0}, {
               Cos[$CellContext`a], 
               Sin[$CellContext`a], 0}]; $CellContext`circ = {(
               2 (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1])))/(
              1 + (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), (
               2 (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a]))/(
              1 + (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), 
              1 - (2 Sin[$CellContext`t1]^2)/((1 + 
                Cos[$CellContext`t1])^2 + ((2 (1 + Cos[$CellContext`t1])) (
                 Part[$CellContext`p, 1] Cos[$CellContext`a] + 
                 Part[$CellContext`p, 2] Sin[$CellContext`a])) 
               Sin[$CellContext`t1] + (1 + Part[$CellContext`p, 1]^2 + 
                Part[$CellContext`p, 2]^2) Sin[$CellContext`t1]^2)}; Show[
             Graphics3D[{Thick, 
               RGBColor[0.368417, 0.506779, 0.709798], $CellContext`line}], 
             
             ParametricPlot3D[$CellContext`circ, {$CellContext`t1, 0, 2 Pi}, 
              PlotStyle -> {Thick, Red}]]], $CellContext`line = 
         Line[{-3, -3}], $CellContext`circ[
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`r, 
            Blank[]]] := $CellContext`c + $CellContext`r 
           Cos[(2 Pi) $CellContext`t] + (I $CellContext`r) 
           Sin[(2 Pi) $CellContext`t], $CellContext`lineLink[
           Pattern[$CellContext`p, 
            Blank[]], 
           Pattern[$CellContext`a, 
            Blank[]]] := 
         Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t1, $CellContext`tL, $CellContext`pts, $CellContext`lines, \
$CellContext`intersects}, $CellContext`xcirc = (
              2 (Part[$CellContext`p, 1] + 
               Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                 Csc[$CellContext`t1])))/(
             1 + (Part[$CellContext`p, 1] + 
               Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                 Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
               Cot[$CellContext`t1/2] 
                Sin[$CellContext`a])^2); $CellContext`ycirc = (
              2 (Part[$CellContext`p, 2] + 
               Cot[$CellContext`t1/2] Sin[$CellContext`a]))/(
             1 + (Part[$CellContext`p, 1] + 
               Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                 Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
               Cot[$CellContext`t1/2] 
                Sin[$CellContext`a])^2); $CellContext`zcirc = 
            1 - (2 Sin[$CellContext`t1]^2)/((1 + 
               Cos[$CellContext`t1])^2 + ((2 (1 + Cos[$CellContext`t1])) (
                Part[$CellContext`p, 1] Cos[$CellContext`a] + 
                Part[$CellContext`p, 2] Sin[$CellContext`a])) 
              Sin[$CellContext`t1] + (1 + Part[$CellContext`p, 1]^2 + 
               Part[$CellContext`p, 2]^2) 
              Sin[$CellContext`t1]^2); $CellContext`tL = 
            Table[(2 (Pi/10)) $CellContext`k, {$CellContext`k, 1, 
               9}]; $CellContext`pts = Map[Limit[
               
               N[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}], $CellContext`t1 -> #]& , $CellContext`tL]; \
$CellContext`pts = N[$CellContext`pts]; $CellContext`lines = Table[
              If[Part[
                 Part[$CellContext`pts, $CellContext`k], 3] <= 0, 
               Line[{{0, 0, 1}, 
                 Part[$CellContext`pts, $CellContext`k]}], 
               Line[{{0, 0, 1}, 
                 ReplaceAll[
                  RegionIntersection[
                   InfinitePlane[{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}}], 
                   HalfLine[{{0, 0, 1}, 
                    Part[$CellContext`pts, $CellContext`k]}]], Point[
                    Pattern[$CellContext`f, 
                    Blank[]]] -> $CellContext`f]}]], {$CellContext`k, 1, 9}]; 
           Graphics3D[$CellContext`lines]], $CellContext`f[
           Pattern[$CellContext`z, 
            Blank[]]] := $CellContext`z^2 + 1, $CellContext`init = Show[
            
            ParametricPlot3D[{$CellContext`x, $CellContext`y, 
              0}, {$CellContext`x, -3, 3}, {$CellContext`y, -3, 3}, MeshStyle -> 
             None, PlotStyle -> {
               Directive[LightBlue, 
                Opacity[0.4]]}], 
            
            ParametricPlot3D[{
             Sin[$CellContext`t] Cos[$CellContext`p], Sin[$CellContext`t] 
              Sin[$CellContext`p], 
              Cos[$CellContext`t]}, {$CellContext`t, 0, Pi}, {$CellContext`p, 
              0, 2 Pi}, MeshStyle -> None, PlotStyle -> {
               Opacity[0.4]}], 
            Graphics3D[{
              Line[{{-3, 0, 0}, {3, 0, 0}}], 
              Line[{{0, -3, 0}, {0, 3, 0}}], 
              Point[{1, 0, 0}], 
              Text[1, {1, 0, 0}, {1, 1}], 
              Point[{0, 1, 0}], 
              Text[I, {0, 1, 0}, {1, 1}], 
              Point[{0, 0, 1}], 
              Text["N", {0, 0, 1}, {0, -1}]}]]; $CellContext`circleproj[
            Pattern[$CellContext`c, 
             Blank[]], 
            Pattern[$CellContext`r, 
             Blank[]]] := 
          Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t}, $CellContext`xcirc = 
             2 ((Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`ycirc = 
             2 ((Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                 Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2 - 1)/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2); Show[
              
              ParametricPlot3D[{
               Part[$CellContext`c, 1] + $CellContext`r Cos[$CellContext`t], 
                Part[$CellContext`c, 2] + $CellContext`r Sin[$CellContext`t], 
                0}, {$CellContext`t, 0, 2 Pi}], 
              
              ParametricPlot3D[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, {$CellContext`t, 0, 2 Pi}, 
               PlotStyle -> {Thick, Red}]]]; $CellContext`circlelines[
            Pattern[$CellContext`c, 
             Blank[]], 
            Pattern[$CellContext`r, 
             Blank[]]] := 
          Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`tL, $CellContext`pts, $CellContext`pts2, $CellContext`t, \
$CellContext`lines, $CellContext`lines2}, $CellContext`xcirc = 
             2 ((Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`ycirc = 
             2 ((Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                 Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2 - 1)/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2); $CellContext`tL = 
             Table[2 (Pi/10) $CellContext`k, {$CellContext`k, 1, 
                10}]; $CellContext`pts = 
             Map[ReplaceAll[{
                Part[$CellContext`c, 1] + $CellContext`r Cos[$CellContext`t], 
                 Part[$CellContext`c, 2] + $CellContext`r Sin[$CellContext`t],
                  0}, $CellContext`t -> #]& , $CellContext`tL]; \
$CellContext`pts2 = 
             Map[ReplaceAll[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, $CellContext`t -> #]& , $CellContext`tL]; \
$CellContext`lines = 
             Map[Line[{#, {0, 0, 
                 1}}]& , $CellContext`pts]; $CellContext`lines2 = 
             Map[Line[{#, {0, 0, 1}}]& , $CellContext`pts2]; 
            Graphics3D[{$CellContext`lines, $CellContext`lines2}]]; \
$CellContext`lineLink[
            Pattern[$CellContext`p, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]]] := 
          Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t1, $CellContext`tL, $CellContext`pts, $CellContext`lines, \
$CellContext`intersects}, $CellContext`xcirc = (
               2 (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1])))/(
              1 + (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] 
                 Sin[$CellContext`a])^2); $CellContext`ycirc = (
               2 (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a]))/(
              1 + (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] 
                 Sin[$CellContext`a])^2); $CellContext`zcirc = 
             1 - (2 Sin[$CellContext`t1]^2)/((1 + Cos[$CellContext`t1])^2 + 
              2 (1 + Cos[$CellContext`t1]) (
                Part[$CellContext`p, 1] Cos[$CellContext`a] + 
                Part[$CellContext`p, 2] Sin[$CellContext`a]) 
               Sin[$CellContext`t1] + (1 + Part[$CellContext`p, 1]^2 + 
                Part[$CellContext`p, 2]^2) 
               Sin[$CellContext`t1]^2); $CellContext`tL = 
             Table[2 (Pi/10) $CellContext`k, {$CellContext`k, 1, 
                9}]; $CellContext`pts = Map[Limit[
                
                N[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}], $CellContext`t1 -> #]& , $CellContext`tL]; \
$CellContext`pts = N[$CellContext`pts]; $CellContext`lines = Table[
               If[Part[
                  Part[$CellContext`pts, $CellContext`k], 3] <= 0, 
                Line[{{0, 0, 1}, 
                  Part[$CellContext`pts, $CellContext`k]}], 
                Line[{{0, 0, 1}, 
                  ReplaceAll[
                   RegionIntersection[
                    InfinitePlane[{{0, 0, 0}, {1, 0, 0}, {0, 1, 0}}], 
                    HalfLine[{{0, 0, 1}, 
                    Part[$CellContext`pts, $CellContext`k]}]], Point[
                    Pattern[$CellContext`f, 
                    Blank[]]] -> $CellContext`f]}]], {$CellContext`k, 1, 9}]; 
            Graphics3D[$CellContext`lines]]; $CellContext`lineproj[
            Pattern[$CellContext`p, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]]] := 
          Module[{$CellContext`line, $CellContext`circ, $CellContext`t, \
$CellContext`t1}, $CellContext`line = InfiniteLine[{
                Part[$CellContext`p, 1], 
                Part[$CellContext`p, 2], 0}, {
                Cos[$CellContext`a], 
                Sin[$CellContext`a], 0}]; $CellContext`circ = {(
                2 (Part[$CellContext`p, 1] + 
                 Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                   Csc[$CellContext`t1])))/(
               1 + (Part[$CellContext`p, 1] + 
                 Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                   Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                 Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), (
                2 (Part[$CellContext`p, 2] + 
                 Cot[$CellContext`t1/2] Sin[$CellContext`a]))/(
               1 + (Part[$CellContext`p, 1] + 
                 Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                   Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                 Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), 
               1 - (2 Sin[$CellContext`t1]^2)/((1 + Cos[$CellContext`t1])^2 + 
               2 (1 + Cos[$CellContext`t1]) (
                 Part[$CellContext`p, 1] Cos[$CellContext`a] + 
                 Part[$CellContext`p, 2] Sin[$CellContext`a]) 
                Sin[$CellContext`t1] + (1 + Part[$CellContext`p, 1]^2 + 
                 Part[$CellContext`p, 2]^2) Sin[$CellContext`t1]^2)}; Show[
              Graphics3D[{Thick, 
                RGBColor[0.368417, 0.506779, 0.709798], $CellContext`line}], 
              
              ParametricPlot3D[$CellContext`circ, {$CellContext`t1, 0, 2 Pi}, 
               PlotStyle -> {Thick, Red}]]]; Null}; 
       Typeset`initDone$$ = True), SynchronousInitialization -> False, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   "\"Fig. 6. Lines and circles are mapped into circles on the Riemann sphere \
by the stereographic projection. Try moving and resizing them to see how the \
projection changes. The checkbox \[OpenCurlyDoubleQuote]Show lines\
\[CloseCurlyDoubleQuote] will show how the projection is constructed.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.962939476973295*^9},
 CellID->2059008599,ExpressionUUID->"7aaf9f37-9f89-4107-8d59-f684807aa481"]
}, {2}]],

Cell["\<\
In Fig. 7, one can see how the stereographic projection preserves angles \
locally.\
\>", "Text",
 CellID->435992548,ExpressionUUID->"5ac8dfac-ddc3-4d90-96c0-d660b82696b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"init", ",", 
       RowBox[{"lineproj2", "[", 
        RowBox[{"p", ",", "\[Alpha]", ",", 
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Darker", "[", "Pink", "]"}]}], "]"}], ",", 
       RowBox[{"lineproj2", "[", 
        RowBox[{"p", ",", 
         RowBox[{"\[Alpha]", "+", "\[Theta]"}], ",", "Blue", ",", "Red"}], 
        "]"}], ",", 
       RowBox[{"pointproj", "[", "p", "]"}], ",", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.013", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"p", "~", "Join", "~", 
            RowBox[{"{", "0", "}"}]}], "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"arcproj", "[", 
        RowBox[{"p", ",", "\[Alpha]", ",", 
         RowBox[{"\[Alpha]", "+", "\[Theta]"}], ",", 
         RowBox[{"4", "/", "5"}], ",", 
         RowBox[{"3", "/", "10"}]}], "]"}]}], "]"}], "\[IndentingNewLine]", ",",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"p", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "0.8168"}], "}"}], ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "1.18"}], "}"}], ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SaveDefinitions", "->", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Initialization", ":>", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"init", "=", 
         RowBox[{"Show", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"y", ",", 
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Directive", "[", 
                RowBox[{"LightBlue", ",", 
                 RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"ParametricPlot3D", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"Sin", "[", "t", "]"}], " ", 
                RowBox[{"Cos", "[", "p", "]"}]}], ",", 
               RowBox[{
                RowBox[{"Sin", "[", "t", "]"}], " ", 
                RowBox[{"Sin", "[", "p", "]"}]}], ",", 
               RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"p", ",", "0", ",", 
               RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
             RowBox[{"MeshStyle", "\[Rule]", "None"}], ",", 
             RowBox[{"PlotStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Opacity", "[", "0.4`", "]"}], "}"}]}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Graphics3D", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
               "\[IndentingNewLine]", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{"1", ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{"\[ImaginaryI]", ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{"\"\<N\>\"", ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"lineproj2", "[", 
          RowBox[{"p_", ",", "a_", ",", "color1_", ",", "color2_"}], "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"line", ",", "circ", ",", "t", ",", "t1"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"line", "=", 
             RowBox[{"InfiniteLine", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"p", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{"p", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "a", "]"}], ",", 
                 RowBox[{"Sin", "[", "a", "]"}], ",", "0"}], "}"}]}], "]"}]}],
             ";", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
              RowBox[{"circ", "=", 
               RowBox[{"{", 
                RowBox[{
                 FractionBox[
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}]}], ")"}]}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}]}], ")"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}]], ",", 
                 FractionBox[
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}]}], 
                  RowBox[{"1", "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}]}], ")"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}]], ",", 
                 RowBox[{"1", "-", 
                  FractionBox["2", 
                   RowBox[{"1", "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox["t", "2"], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "t", " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "t", " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}]]}]}], "}"}]}], ";"}], 
             "*)"}], "\[IndentingNewLine]", 
            RowBox[{"circ", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}]}], 
                 ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}], "2"],
                   "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}], 
                 ")"}]}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cos", "[", "a", "]"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Cot", "[", "t1", "]"}], "+", 
                    RowBox[{"Csc", "[", "t1", "]"}]}], ")"}]}]}], ")"}], "2"],
                   "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"Cot", "[", 
                    FractionBox["t1", "2"], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], "2"]}], 
                 ")"}]}], ",", 
               RowBox[{"1", "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    RowBox[{"Sin", "[", "t1", "]"}], "2"]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", "t1", "]"}]}], ")"}], "2"], "+", 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"Cos", "[", "t1", "]"}]}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", 
                    RowBox[{"Cos", "[", "a", "]"}]}], "+", 
                    RowBox[{
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", 
                    RowBox[{"Sin", "[", "a", "]"}]}]}], ")"}], " ", 
                    RowBox[{"Sin", "[", "t1", "]"}]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "2"], "+", 
                    SuperscriptBox[
                    RowBox[{"p", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "2"]}], ")"}], " ", 
                    SuperscriptBox[
                    RowBox[{"Sin", "[", "t1", "]"}], "2"]}]}], ")"}]}]}]}], 
              "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"Show", "[", 
             RowBox[{
              RowBox[{"Graphics3D", "[", 
               RowBox[{"{", 
                RowBox[{"Thick", ",", "color1", ",", 
                 RowBox[{"Opacity", "[", "0.8", "]"}], ",", "line"}], "}"}], 
               "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"(*", 
               RowBox[{
                RowBox[{"ParametricPlot3D", "[", 
                 RowBox[{"circ", ",", 
                  RowBox[{"{", 
                   RowBox[{"t", ",", 
                    RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}], "]"}],
                "*)"}], "\[IndentingNewLine]", 
              RowBox[{"ParametricPlot3D", "[", 
               RowBox[{"circ", ",", 
                RowBox[{"{", 
                 RowBox[{"t1", ",", "0", ",", 
                  RowBox[{"2", "Pi"}]}], "}"}], ",", 
                RowBox[{"PlotStyle", "\[Rule]", 
                 RowBox[{"{", 
                  RowBox[{"Thick", ",", "color2", ",", 
                   RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}]}]}], "]"}]}],
              "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"pointproj", "[", "p_", "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "z", ",", "p1"}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y"}], "}"}], "=", "p"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"p1", "=", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", 
                RowBox[{"x", "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}], ")"}]}]}], ",", 
               RowBox[{"2", 
                RowBox[{"y", "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["y", "2"]}], ")"}]}]}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"], "-", "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["x", "2"], "+", 
                  SuperscriptBox["y", "2"], "+", "1"}], ")"}]}]}], "}"}]}], ";",
             "\[IndentingNewLine]", 
            RowBox[{"Show", "[", 
             RowBox[{"Graphics3D", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "0.013", "]"}], ",", 
                RowBox[{"Point", "[", "p1", "]"}]}], "}"}], "]"}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"arcproj", "[", 
          RowBox[{"c_", ",", "th1_", ",", "th2_", ",", "r_", ",", "r2_"}], 
          "]"}], ":=", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "xcirc", ",", "ycirc", ",", "zcirc", ",", "t", ",", "p1", ",", 
             "p2", ",", "q1", ",", "q2"}], "}"}], ",", "\[IndentingNewLine]", 
           
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"th2", ">", "th1"}], ",", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"xcirc", "=", 
               RowBox[{"2", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                  ")"}]}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"ycirc", "=", 
               RowBox[{"2", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                  ")"}]}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"zcirc", "=", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"], "-", 
                  "1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], 
                 ")"}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"p2", "=", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r2", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r2", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "0"}], "}"}], "/.", 
                RowBox[{"t", "->", "th2"}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"p1", "=", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                   RowBox[{"r2", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                   RowBox[{"r2", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "0"}], "}"}], "/.", 
                RowBox[{"t", "->", 
                 RowBox[{"(", 
                  RowBox[{"th2", "-", 
                   RowBox[{"1", "/", "8"}]}], ")"}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"q1", "=", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], "/.", 
                RowBox[{"t", "->", 
                 RowBox[{"(", 
                  RowBox[{"th2", "-", 
                   RowBox[{"1", "/", "8"}]}], ")"}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"q2", "=", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], "/.", 
                RowBox[{"t", "->", "th2"}]}]}], ";", "\[IndentingNewLine]", 
              RowBox[{"Show", "[", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"ParametricPlot3D", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"r2", " ", 
                    RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"c", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"r2", " ", 
                    RowBox[{"Sin", "[", "t", "]"}]}]}], ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"t", ",", "th1", ",", "th2"}], "}"}], ",", 
                  RowBox[{"PlotStyle", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"ParametricPlot3D", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], ",", 
                  
                  RowBox[{"{", 
                   RowBox[{"t", ",", "th1", ",", "th2"}], "}"}], ",", 
                  RowBox[{"PlotStyle", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"Graphics3D", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"p1", ",", "p2"}], "}"}], "]"}]}], "}"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"q1", ",", "q2"}], "}"}], "]"}]}], "}"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"Text", "[", 
                    RowBox[{"\"\<\[Theta]\>\"", ",", "p1", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"Text", "[", 
                    RowBox[{"\"\<\[Theta]\>\"", ",", "q1", ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", 
                    RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
               "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", ",", 
             RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        ";"}], "\[IndentingNewLine]", ")"}]}]}], "\[IndentingNewLine]", "]"}],
    "\[IndentingNewLine]", 
   ",", "\"\<Fig. 7. Angles are locally preserved by the stereographic \
projection.\>\""}], "]"}]], "Input",
 CellID->90227679,ExpressionUUID->"8ebb05c7-2c48-4979-bd4c-d5929c5f41b4"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`p$$ = {-1, -2}, $CellContext`\[Alpha]$$ = 
       0.8168, $CellContext`\[Theta]$$ = 1.18, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`p$$], {-1, -2}}, {-3, -3}, {3, 3}, ControlType -> 
          Slider2D}, {{
           Hold[$CellContext`\[Alpha]$$], 0.8168}, 0, 2 Pi, ControlType -> 
          Manipulator}, {{
           Hold[$CellContext`\[Theta]$$], 1.18}, 0, 2 Pi, ControlType -> 
          Manipulator}}, 
       Typeset`size$$ = {240., {83.50477583293457, 90.73719770793457}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, 
        "Variables" :> {$CellContext`p$$ = {-1, -2}, $CellContext`\[Alpha]$$ = 
          0.8168, $CellContext`\[Theta]$$ = 1.18}, 
        "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Show[$CellContext`init, 
          $CellContext`lineproj2[$CellContext`p$$, $CellContext`\[Alpha]$$, 
           RGBColor[0.368417, 0.506779, 0.709798], 
           Darker[Pink]], 
          $CellContext`lineproj2[$CellContext`p$$, $CellContext`\[Alpha]$$ + \
$CellContext`\[Theta]$$, Blue, Red], 
          $CellContext`pointproj[$CellContext`p$$], 
          Graphics3D[{
            PointSize[0.013], 
            Point[
             Join[$CellContext`p$$, {0}]]}], 
          $CellContext`arcproj[$CellContext`p$$, $CellContext`\[Alpha]$$, \
$CellContext`\[Alpha]$$ + $CellContext`\[Theta]$$, 4/5, 3/10]], 
        "Specifications" :> {{{$CellContext`p$$, {-1, -2}}, {-3, -3}, {3, 
           3}}, {{$CellContext`\[Alpha]$$, 0.8168}, 0, 2 
           Pi}, {{$CellContext`\[Theta]$$, 1.18}, 0, 2 Pi}}, "Options" :> {}, 
        "DefaultOptions" :> {}], 
       ImageSizeCache -> {290.5, {188.10477583293456`, 195.33719770793456`}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ({$CellContext`init = Graphics3D[{{
             GraphicsComplex[CompressedData["
1:eJyFnF2sXUUZQC+FtoiJkRgTFKhFb3wmEbDGqo3hpwVaK6L4gEZpMSjc6IMQ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              "], {{{
                 EdgeForm[], Lighting -> Automatic, 
                 RGBColor[0.87, 0.94, 1], 
                 Opacity[0.4], 
                 GraphicsGroup[
                  Annotation[{
                    Polygon[CompressedData["
1:eJwtmXfgV9Mbx++553xsKS0kycqqKOInlTREMkpDkzQQskdGZaYiREZKNJAy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                    "]], 
                    Polygon[CompressedData["
1:eJwtmmXA3UTXRZNJimuRtpRCCy3uXlyKe3F3KRSKu7u7a3F3aXGKu7u7u+vL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                    "]], 
                    Polygon[CompressedData["
1:eJwt13ncTnUWAPDH+zz2JVJMhJGlsZZsZQ2RrCFqbE32KWuWlC1ZspZQpKKZ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                    "]]}, "Charting`Private`Tag$35561#1"]]}, {}, {}, {}, {}}},
               VertexNormals -> CompressedData["
1:eJztyDENwCAABMAPDUJYaqMekEDCjHUkVAE7w914baw+S5K3Jk9O9ue99957
77333nvvvffee++9995777333nvvvffee++9995777333nvvvffee++99957
77333nvvvffee++9995777333nvvvffee+/9Df8DFfMaLg==
               "]], {}}, {
             GraphicsComplex[CompressedData["
1:eJyNfXVcFl3zPvZjdyu2YmEnyGJgYItiYYES9mMDNioqJgYWit3dxVHCLgQB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              "], {{{
                 EdgeForm[], 
                 Specularity[
                  GrayLevel[1], 3], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 Lighting -> {{"Ambient", 
                    RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]}, {
                   "Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, 
                 AbsoluteThickness[2], 
                 Opacity[0.4], 
                 GraphicsGroup[
                  Annotation[{
                    Polygon[CompressedData["
1:eJxFnAf8V/P3x+++NyNZP6NQKEJkZ0RDVIq0tDQJpZIKKSIV7ZKyigqZGdm7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                    "]], 
                    Polygon[CompressedData["
1:eJw1nAf8l9P7xp95zid7ZiRSESlE9qwoNCQaKFIRUhmRLTRRIikjkRYpyZ6Z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                    "]], 
                    Polygon[CompressedData["
1:eJwt1nuQj1Ucx/HH7u+3K6zbuqVIug4NpVLoNkmpbIqJbpgof1TWnS6MMClJ
JWFSCNVQul+oSE1CKbdqpRblmiQJW2Ftr2+PPz7zPJ/3+ZzznOec85zznNq7
f5finCRJHqEs5eQnyY/0cG6S1KQnKiVJhv+JRvO1aCK2Jy9JvscG8kc0MByr
wAbRAWxQJkkex6pFPewoNhSbjB3hi2kfNgB7DDvIb5B9AKtMY7ADWAl2P59P
o7F6/GT8BPUepJlYATYWOyYzDHsWK+cH0H5sIDYeS+Q20iisBk3AfvfSN8t9
xF9Hc8Xe5M+TW678cXWb0x/8GNlC5evk1tOjWKN4Z/drZboah5EyjbHB2Baq
Kr9X7iFcJFkTWfoc+4FGui+gTeqOkzlb3Qf5n6mh/GqZ7fQG34H2yNWt7P3l
1rkfoE5/eosOyeV6SIZ6qjsHO4D9o96/1Bl7kp9IZe5/kNtIf/ETZJtiW+W2
0UFsPtYNe4rPkduHjcim6+Rb7Dt6mynDs8rzqJey1/nn9a+R8WsS7dIRbJnr
YOUvqFdf9m9sIXY3NjXGAfuE/wev7r4G9VO2FPsXq8nXomLsU+wwVpsvpP7Y
Rqyj576mrRbYWOxY9Nd4dYn5oZXYn7Fe8Druv5ctofKYH7kbZW6iFfEt8Jvx
Ce5bYufGGPC5eAf3V9MiZUe19wU+xP0MbTXA38Pej/Vhjt7hL1O+kO+qfy/J
XS/XCavK52vvdpk7qERZNawy1iPmkTZg76j7Np2vzoJ4Z+0WxHcg14tfFs/A
qvK18U3qfOMZfeI7Uac+1j/mjM+NZ8g9rb2W7kcApfgzcjXwOrHOs2lZFb6W
uu21vVKmN81Wbw4dNr8z+Aq6V+Zl7IQYb6qIdYO9GmPA/yJTR34x9iF2E1ZE
nYPxG/A+7nthd9J+bBxd7blfxhjEfqQvM5W103YD1xOpOjbKtSDmQa481iGW
0d5qbIV6t2GrZC7CXuR38/cpK5Bbkk3vn8N34tM8s7XcrPjW+Ac8fy7WHDtH
riqeUWcF1Vb/XNfzaJiyQn798fs2rm1jjalXDx/ofhBtUfZKzGNe+h6Fse4j
J1Ml9lTsK6wfVi73dTb9Bk7Ul4Z0DPsmm34DJ/EnUyV1S7CR2Jn8WbFf8b/K
LtFWN1qobAe2C/uAv4HmYZPju8xP95//9yF1j8rtDs73pOVxNujbb9hKvjet
wR6Ta4Y/FAuKTnaZhLXCxvBVqHmSzk8TbAhfkZPO1ZTYX2lL7Gex32XSPbJB
7Nv8oZx0v/yAbyu31tp4EmidSffh0/DhcmU56Z4cY7dHbhXWNzcdx3FYdWyK
uvWjj+rOUPdCfDxfm9rCs7FNck/wjWNssFexzdjTfFPqHudCzF+cP/yZ1CPG
DyvFHuHr0eXYIuxnbBrfLPqTpOvsF2x67E256Zpbjm3FZvKt4nzEhupbpfz0
bIoz6hDN5+dR3Wy6XmLdDJfLzU/P5ziny+h9rA22BpvoXS+I9Ytl89MzO87u
v6kQ+x1bHf2gzdprz3+GXx/7AP0o39a1Hc1XvtOzp8d+6dpebp56rWkEth3r
gr3LX0nPYgu09xo1VnZSnK3YrOgb7TVnRfFu2v5J+XXqLoi5yE3/Q+IbuiL2
k+PjEt9TfAcXY7OPj198E0nltD/Rh9O1dQZNlanvGbP0/5Q4f7E1Mpfic2Mu
M+kZVBHvn03PjUZYY1rLXxb7s9xpmXQ//1juI+qhrCv+LrZM5qr4J/KMzlhR
/MNgNbCpWAOsEnYr9hc9jBXzpbGO4p+ERmH94vyNMVNvKXYtPymYskuwnbHn
K+8Y/xtYO34HvcVfQ+uwTjGm6naLd6ftWN/4F8pL/7/iP2y37F384bz0Xyv+
uXbEd813UL8UuzHWPX53/Kvlpf9L8d+0C78lvn0aht0TayPmRb1t8Y8Qa55W
KFsvUxR9dN896sV5bY4Wx55ozlu6tqD/AE30VCA=
                    "]]}, "Charting`Private`Tag$35588#1"]]}, {}, {}, {}, {}}},
               VertexNormals -> CompressedData["
1:eJx0fXVcVdvzNrbX7k4UxcAOVGTZoqLYXVcM7C4MxAZsVAxQMbBQsZulhIGA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               "]], {}}, {
             Line[{{-3, 0, 0}, {3, 0, 0}}], 
             Line[{{0, -3, 0}, {0, 3, 0}}], 
             Point[{1, 0, 0}], 
             Text[1, {1, 0, 0}, {1, 1}], 
             Point[{0, 1, 0}], 
             Text[I, {0, 1, 0}, {1, 1}], 
             Point[{0, 0, 1}], 
             Text["N", {0, 0, 1}, {0, -1}]}}, {
           DisplayFunction -> Identity, PlotRangePadding -> {{
               Scaled[0.05], 
               Scaled[0.05]}, {
               Scaled[0.05], 
               Scaled[0.05]}, {
               Scaled[0.05], 
               Scaled[0.05]}}, ImagePadding -> Automatic, DisplayFunction -> 
            Identity, Axes -> True, DisplayFunction :> Identity, 
            FaceGridsStyle -> Automatic, 
            Method -> {
             "DefaultGraphicsInteraction" -> {
               "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
                "Effects" -> {
                 "Highlight" -> {"ratio" -> 2}, 
                  "HighlightPoint" -> {"ratio" -> 2}, 
                  "Droplines" -> {
                   "freeformCursorMode" -> True, 
                    "placement" -> {"x" -> "All", "y" -> "None"}}}}}, 
            PlotRange -> {{-2.9999995714285714`, 
             2.9999995714285714`}, {-2.9999995714285714`, 
             2.9999995714285714`}, {-1., 1.}}, PlotRangePadding -> {
              Scaled[0.02], 
              Scaled[0.02], 
              Scaled[0.02]}, 
            Ticks -> {
             Automatic, Automatic, Automatic}}], $CellContext`lineproj2[
           Pattern[$CellContext`p, 
            Blank[]], 
           Pattern[$CellContext`a, 
            Blank[]], 
           Pattern[$CellContext`color1, 
            Blank[]], 
           Pattern[$CellContext`color2, 
            Blank[]]] := 
         Module[{$CellContext`line, $CellContext`circ, $CellContext`t, \
$CellContext`t1}, $CellContext`line = InfiniteLine[{
               Part[$CellContext`p, 1], 
               Part[$CellContext`p, 2], 0}, {
               Cos[$CellContext`a], 
               Sin[$CellContext`a], 0}]; $CellContext`circ = {(
               2 (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1])))/(
              1 + (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), (
               2 (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a]))/(
              1 + (Part[$CellContext`p, 1] + 
                Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                  Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), 
              1 - (2 Sin[$CellContext`t1]^2)/((1 + 
                Cos[$CellContext`t1])^2 + ((2 (1 + Cos[$CellContext`t1])) (
                 Part[$CellContext`p, 1] Cos[$CellContext`a] + 
                 Part[$CellContext`p, 2] Sin[$CellContext`a])) 
               Sin[$CellContext`t1] + (1 + Part[$CellContext`p, 1]^2 + 
                Part[$CellContext`p, 2]^2) Sin[$CellContext`t1]^2)}; Show[
             Graphics3D[{Thick, $CellContext`color1, 
               Opacity[0.8], $CellContext`line}], 
             
             ParametricPlot3D[$CellContext`circ, {$CellContext`t1, 0, 2 Pi}, 
              PlotStyle -> {Thick, $CellContext`color2, 
                Opacity[0.8]}]]], $CellContext`line = 
         Line[{-3, -3}], $CellContext`circ[
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`r, 
            Blank[]]] := $CellContext`c + $CellContext`r 
           Cos[(2 Pi) $CellContext`t] + (I $CellContext`r) 
           Sin[(2 Pi) $CellContext`t], 
         TagSet[$CellContext`r, 
          MessageName[$CellContext`r, "shdw"], 
          "Symbol `1` appears in multiple contexts `2`; definitions in \
context `3` may shadow or be shadowed by other definitions."], \
$CellContext`pointproj[
           Pattern[$CellContext`p, 
            Blank[]]] := 
         Module[{$CellContext`x, $CellContext`y, $CellContext`z, \
$CellContext`p1}, {$CellContext`x, $CellContext`y} = $CellContext`p; \
$CellContext`p1 = {
             2 ($CellContext`x/(1 + $CellContext`x^2 + $CellContext`y^2)), 
              2 ($CellContext`y/(
               1 + $CellContext`x^2 + $CellContext`y^2)), ($CellContext`x^2 + \
$CellContext`y^2 - 1)/($CellContext`x^2 + $CellContext`y^2 + 1)}; Show[
             Graphics3D[{
               PointSize[0.013], 
               Point[$CellContext`p1]}]]], $CellContext`arcproj[
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`th1, 
            Blank[]], 
           Pattern[$CellContext`th2, 
            Blank[]], 
           Pattern[$CellContext`r, 
            Blank[]]] := 
         Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t}, 
           
           If[$CellContext`th2 > $CellContext`th1, $CellContext`xcirc = 
             2 ((Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`ycirc = 
             2 ((Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                 Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2 - 1)/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2); Show[
              
              ParametricPlot3D[{
               Part[$CellContext`c, 1] + $CellContext`r Cos[$CellContext`t], 
                Part[$CellContext`c, 2] + $CellContext`r Sin[$CellContext`t], 
                0}, {$CellContext`t, $CellContext`th1, $CellContext`th2}], 
              
              ParametricPlot3D[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, {$CellContext`t, $CellContext`th1, $CellContext`th2}, 
               PlotStyle -> {Thick, Red}]], {}]], $CellContext`arcproj[
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`th1, 
            Blank[]], 
           Pattern[$CellContext`th2, 
            Blank[]], 
           Pattern[$CellContext`r, 
            Blank[]], 
           Pattern[$CellContext`r2, 
            Blank[]]] := 
         Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t, $CellContext`p1, $CellContext`p2, $CellContext`q1, \
$CellContext`q2}, 
           
           If[$CellContext`th2 > $CellContext`th1, $CellContext`xcirc = 
             2 ((Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`ycirc = 
             2 ((Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                 Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2 - 1)/(
              1 + (Part[$CellContext`c, 1] + $CellContext`r 
                 Cos[$CellContext`t])^2 + (
                Part[$CellContext`c, 2] + $CellContext`r 
                 Sin[$CellContext`t])^2); $CellContext`p2 = 
             ReplaceAll[{
               Part[$CellContext`c, 1] + $CellContext`r2 Cos[$CellContext`t], 
                Part[$CellContext`c, 2] + $CellContext`r2 Sin[$CellContext`t],
                 0}, $CellContext`t -> $CellContext`th2]; $CellContext`p1 = 
             ReplaceAll[{
               Part[$CellContext`c, 1] + $CellContext`r2 Cos[$CellContext`t], 
                Part[$CellContext`c, 2] + $CellContext`r2 Sin[$CellContext`t],
                 0}, $CellContext`t -> $CellContext`th2 - 1/
                8]; $CellContext`q1 = 
             ReplaceAll[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, $CellContext`t -> $CellContext`th2 - 1/
                8]; $CellContext`q2 = 
             
             ReplaceAll[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, $CellContext`t -> $CellContext`th2]; Show[
              
              ParametricPlot3D[{
               Part[$CellContext`c, 1] + $CellContext`r2 Cos[$CellContext`t], 
                Part[$CellContext`c, 2] + $CellContext`r2 Sin[$CellContext`t],
                 0}, {$CellContext`t, $CellContext`th1, $CellContext`th2}, 
               PlotStyle -> {Dashed, Black}], 
              
              ParametricPlot3D[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, {$CellContext`t, $CellContext`th1, $CellContext`th2}, 
               PlotStyle -> {Dashed, Black}], 
              Graphics3D[{{
                 Arrowheads[0.02], 
                 Arrow[{$CellContext`p1, $CellContext`p2}]}, {
                 Arrowheads[0.02], 
                 Arrow[{$CellContext`q1, $CellContext`q2}]}, 
                Text["\[Theta]", $CellContext`p1, {1, -1}], 
                Text[
                "\[Theta]", $CellContext`q1, {
                 1, -1}]}]], {}]], $CellContext`init = Show[
            
            ParametricPlot3D[{$CellContext`x, $CellContext`y, 
              0}, {$CellContext`x, -3, 3}, {$CellContext`y, -3, 3}, MeshStyle -> 
             None, PlotStyle -> {
               Directive[LightBlue, 
                Opacity[0.4]]}], 
            
            ParametricPlot3D[{
             Sin[$CellContext`t] Cos[$CellContext`p$$], Sin[$CellContext`t] 
              Sin[$CellContext`p$$], 
              Cos[$CellContext`t]}, {$CellContext`t, 0, 
              Pi}, {$CellContext`p$$, 0, 2 Pi}, MeshStyle -> None, PlotStyle -> {
               Opacity[0.4]}], 
            Graphics3D[{
              Line[{{-3, 0, 0}, {3, 0, 0}}], 
              Line[{{0, -3, 0}, {0, 3, 0}}], 
              Point[{1, 0, 0}], 
              Text[1, {1, 0, 0}, {1, 1}], 
              Point[{0, 1, 0}], 
              Text[I, {0, 1, 0}, {1, 1}], 
              Point[{0, 0, 1}], 
              Text["N", {0, 0, 1}, {0, -1}]}]]; $CellContext`lineproj2[
            Pattern[$CellContext`p, 
             Blank[]], 
            Pattern[$CellContext`a, 
             Blank[]], 
            Pattern[$CellContext`color1, 
             Blank[]], 
            Pattern[$CellContext`color2, 
             Blank[]]] := 
          Module[{$CellContext`line, $CellContext`circ, $CellContext`t, \
$CellContext`t1}, $CellContext`line = InfiniteLine[{
                Part[$CellContext`p, 1], 
                Part[$CellContext`p, 2], 0}, {
                Cos[$CellContext`a], 
                Sin[$CellContext`a], 0}]; $CellContext`circ = {(
                2 (Part[$CellContext`p, 1] + 
                 Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                   Csc[$CellContext`t1])))/(
               1 + (Part[$CellContext`p, 1] + 
                 Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                   Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                 Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), (
                2 (Part[$CellContext`p, 2] + 
                 Cot[$CellContext`t1/2] Sin[$CellContext`a]))/(
               1 + (Part[$CellContext`p, 1] + 
                 Cos[$CellContext`a] (Cot[$CellContext`t1] + 
                   Csc[$CellContext`t1]))^2 + (Part[$CellContext`p, 2] + 
                 Cot[$CellContext`t1/2] Sin[$CellContext`a])^2), 
               1 - (2 Sin[$CellContext`t1]^2)/((1 + 
                 Cos[$CellContext`t1])^2 + ((2 (1 + Cos[$CellContext`t1])) (
                  Part[$CellContext`p, 1] Cos[$CellContext`a] + 
                  Part[$CellContext`p, 2] Sin[$CellContext`a])) 
                Sin[$CellContext`t1] + (1 + Part[$CellContext`p, 1]^2 + 
                 Part[$CellContext`p, 2]^2) Sin[$CellContext`t1]^2)}; Show[
              Graphics3D[{Thick, $CellContext`color1, 
                Opacity[0.8], $CellContext`line}], 
              
              ParametricPlot3D[$CellContext`circ, {$CellContext`t1, 0, 2 Pi}, 
               PlotStyle -> {Thick, $CellContext`color2, 
                 Opacity[0.8]}]]]; $CellContext`pointproj[
            Pattern[$CellContext`p, 
             Blank[]]] := 
          Module[{$CellContext`x, $CellContext`y, $CellContext`z, \
$CellContext`p1}, {$CellContext`x, $CellContext`y} = $CellContext`p; \
$CellContext`p1 = {
              2 ($CellContext`x/(1 + $CellContext`x^2 + $CellContext`y^2)), 
               2 ($CellContext`y/(
                1 + $CellContext`x^2 + $CellContext`y^2)), ($CellContext`x^2 + \
$CellContext`y^2 - 1)/($CellContext`x^2 + $CellContext`y^2 + 1)}; Show[
              Graphics3D[{
                PointSize[0.013], 
                Point[$CellContext`p1]}]]]; $CellContext`arcproj[
            Pattern[$CellContext`c, 
             Blank[]], 
            Pattern[$CellContext`th1, 
             Blank[]], 
            Pattern[$CellContext`th2, 
             Blank[]], 
            Pattern[$CellContext`r, 
             Blank[]], 
            Pattern[$CellContext`r2, 
             Blank[]]] := 
          Module[{$CellContext`xcirc, $CellContext`ycirc, $CellContext`zcirc, \
$CellContext`t, $CellContext`p1, $CellContext`p2, $CellContext`q1, \
$CellContext`q2}, 
            
            If[$CellContext`th2 > $CellContext`th1, $CellContext`xcirc = 
              2 ((Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])/(
                1 + (Part[$CellContext`c, 1] + $CellContext`r 
                   Cos[$CellContext`t])^2 + (
                  Part[$CellContext`c, 2] + $CellContext`r 
                   Sin[$CellContext`t])^2)); $CellContext`ycirc = 
              2 ((Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])/(
                1 + (Part[$CellContext`c, 1] + $CellContext`r 
                   Cos[$CellContext`t])^2 + (
                  Part[$CellContext`c, 2] + $CellContext`r 
                   Sin[$CellContext`t])^2)); $CellContext`zcirc = ((
                  Part[$CellContext`c, 1] + $CellContext`r 
                   Cos[$CellContext`t])^2 + (
                  Part[$CellContext`c, 2] + $CellContext`r 
                   Sin[$CellContext`t])^2 - 1)/(
               1 + (Part[$CellContext`c, 1] + $CellContext`r 
                  Cos[$CellContext`t])^2 + (
                 Part[$CellContext`c, 2] + $CellContext`r 
                  Sin[$CellContext`t])^2); $CellContext`p2 = 
              ReplaceAll[{
                Part[$CellContext`c, 1] + $CellContext`r2 Cos[$CellContext`t],
                  Part[$CellContext`c, 2] + $CellContext`r2 
                  Sin[$CellContext`t], 
                 0}, $CellContext`t -> $CellContext`th2]; $CellContext`p1 = 
              ReplaceAll[{
                Part[$CellContext`c, 1] + $CellContext`r2 Cos[$CellContext`t],
                  Part[$CellContext`c, 2] + $CellContext`r2 
                  Sin[$CellContext`t], 0}, $CellContext`t -> $CellContext`th2 - 
                 1/8]; $CellContext`q1 = 
              ReplaceAll[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, $CellContext`t -> $CellContext`th2 - 1/
                 8]; $CellContext`q2 = 
              ReplaceAll[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, $CellContext`t -> $CellContext`th2]; Show[
               
               ParametricPlot3D[{
                Part[$CellContext`c, 1] + $CellContext`r2 Cos[$CellContext`t],
                  Part[$CellContext`c, 2] + $CellContext`r2 
                  Sin[$CellContext`t], 
                 0}, {$CellContext`t, $CellContext`th1, $CellContext`th2}, 
                PlotStyle -> {Dashed, Black}], 
               
               ParametricPlot3D[{$CellContext`xcirc, $CellContext`ycirc, \
$CellContext`zcirc}, {$CellContext`t, $CellContext`th1, $CellContext`th2}, 
                PlotStyle -> {Dashed, Black}], 
               Graphics3D[{{
                  Arrowheads[0.02], 
                  Arrow[{$CellContext`p1, $CellContext`p2}]}, {
                  Arrowheads[0.02], 
                  Arrow[{$CellContext`q1, $CellContext`q2}]}, 
                 Text["\[Theta]", $CellContext`p1, {1, -1}], 
                 Text["\[Theta]", $CellContext`q1, {1, -1}]}]], {}]]; Null}; 
       Typeset`initDone$$ = True), SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   "\"Fig. 7. Angles are locally preserved by the stereographic \
projection.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {FontFamily -> "Source Sans Code"}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->1557970,ExpressionUUID->"ce277278-1baa-45f1-9478-f0f222a5225a"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polar Coordinates and Argument", "Subsection",
 CellID->362782468,ExpressionUUID->"a2d44f76-a414-44e0-b03b-8b883a58b701"],

Cell[TextData[{
 "A complex number ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "542c1ffc-c990-4403-8f35-dea4c9917aa8"],
 " can be represented as a point in the plane. Then it is possible to use \
polar coordinates to represent ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "02db58e0-9986-43e1-882c-63f169fa4249"],
 " (Fig. 8)."
}], "Text",
 CellID->651542753,ExpressionUUID->"223ce9d8-d024-44c2-8c85-e600a7ecc2db"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "z", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"p2c", "[", "p_", "]"}], ":=", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"p", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"c2p", "[", "p_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "p", "]"}], ",", 
     RowBox[{"Im", "[", "p", "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"brace", "[", 
   RowBox[{"pa_", ",", "pb_", ",", 
    RowBox[{"a_", ":", 
     RowBox[{"1", "/", "10"}]}], ",", 
    RowBox[{"t_", ":", 
     RowBox[{"1", "/", "3"}]}]}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Theta]", ",", "\[Rho]"}], "}"}], ",", 
    RowBox[{
     RowBox[{"\[Theta]", "=", 
      RowBox[{"Arg", "[", 
       RowBox[{"p2c", "[", 
        RowBox[{"pb", "-", "pa"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"\[Rho]", "=", 
      RowBox[{"Norm", "[", 
       RowBox[{"p2c", "[", 
        RowBox[{"pb", "-", "pa"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"pa", "+", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "+", "\[Theta]", "+", 
            RowBox[{"t", " ", 
             RowBox[{"\[Pi]", "/", "2"}]}]}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "\[Pi]"}], ")"}], "/", "2"}], "+", "\[Theta]"}]}], 
          "}"}]}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"pa", "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "-", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}]}], "}"}], 
        "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "-", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
          RowBox[{"2", "a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", 
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], "+", "\[Theta]"}]}], "}"}]}], "]"}], 
       ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "+", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
          RowBox[{"2", "a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"\[Pi]", "/", "2"}], "+", "\[Theta]"}], ",", 
           RowBox[{"\[Pi]", "+", "\[Theta]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"pa", "+", "pb"}], ")"}], "/", "2"}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}], ",", 
          RowBox[{"pb", "-", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}], "+", 
           RowBox[{"a", " ", "\[Rho]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}]}]}], "}"}], 
        "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"pb", "-", 
          RowBox[{"a", " ", "\[Rho]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ",", 
         RowBox[{"a", " ", "\[Rho]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"3", "\[Pi]"}], ")"}], "/", "2"}], "+", "\[Theta]"}], ",", 
           RowBox[{
            RowBox[{"2", "\[Pi]"}], "+", "\[Theta]", "-", 
            RowBox[{"t", " ", 
             RowBox[{"\[Pi]", "/", "2"}]}]}]}], "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<1\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<-1\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[ImaginaryI]\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<-\[ImaginaryI]\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "2"}], ",", "1"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2.8"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], "/", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{
            RowBox[{"-", "3"}], "/", "2"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"Text", "[", 
          RowBox[{"\"\<z\>\"", ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.8", ",", "2.75"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3.3", ",", "2.75"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.8", ",", "2.75"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2.8", ",", "3.25"}], "}"}]}], "}"}], "]"}]}], "}"}], 
         ","}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"5", "/", "2"}], ",", 
            RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"17", "/", "2"}], "]"}]}], 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"5", "/", "2"}], ",", 
             RowBox[{"3", "/", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"5", "/", "2"}], ",", 
              RowBox[{"3", "/", "2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.45", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"ArcTan", "[", 
               RowBox[{"3", "/", "5"}], "]"}]}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[Theta]\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.6", ",", "0.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "0.4"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"StringJoin", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"HoldForm", "[", 
                RowBox[{"z", "==", 
                 RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", "*", "y"}]}], "==", "r"}], "]"}], ",",
                "TraditionalForm"}], "]"}], 
             ",", "\"\<(cos\[Theta]+\[ImaginaryI] sin\[Theta])\>\""}], "]"}], 
           ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", "/", "2"}], ",", 
           RowBox[{"3", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{
            RowBox[{"-", "3"}], "/", "2"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.0025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"BezierCurve", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2", ",", 
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"3", "/", "2"}], ",", 
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"11", "/", "8"}], ",", 
               RowBox[{"3", "/", "4"}]}], "}"}], ",", 
             RowBox[{
              RowBox[{"1", "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"17", "/", "2"}], "]"}]}], 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"5", "/", "2"}], ",", 
                RowBox[{"3", "/", "2"}]}], "}"}]}]}], "}"}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<cos\[Theta]+\[ImaginaryI] sin\[Theta]\>\"", ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0.5"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.0025", "]"}], ",", 
         RowBox[{"brace", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"5", "/", "2"}], ",", 
             RowBox[{"3", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"1", "/", "20"}], ",", 
           RowBox[{"1", "/", "3"}]}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"r", ",", "11"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", "/", "4"}], ",", 
           RowBox[{"3", "/", "4"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{"-", "2.5"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "->", "320"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<Fig. 8. The representation of the complex number \>\"", ",", 
     
     RowBox[{"ToString", "[", 
      RowBox[{"z", ",", "TraditionalForm"}], "]"}], 
     ",", "\"\< in polar coordinates.\>\""}], "]"}]}], "]"}]}], "Input",
 CellID->127122028,ExpressionUUID->"37241427-67d2-49ae-94e3-60f7c2d74fac"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      CircleBox[{0, 0}]}, 
     InsetBox[
      FormBox[
       StyleBox["\"1\"", 12, StripOnInput -> False], TraditionalForm], {1, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"-1\"", 12, StripOnInput -> False], TraditionalForm], {-1, 
      0}, 
      NCache[
       ImageScaled[{
         Rational[5, 4], 0}], 
       ImageScaled[{1.25, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"\[ImaginaryI]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 1}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"-\[ImaginaryI]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, -1}, 
      NCache[
       ImageScaled[{
         Rational[5, 4], 1}], 
       ImageScaled[{1.25, 1}]]], {
      Thickness[0.003], 
      LineBox[{{0, -2}, {0, 2.8}}]}, {
      Thickness[0.003], 
      LineBox[{{-3, 0}, {3, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
        RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
       TraditionalForm], {3, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{-0.25, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
        RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
       TraditionalForm], {0, 2.8}, 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 4]}], 
       ImageScaled[{0, -0.25}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{
         Rational[5, 2], 
         Rational[3, 2]}, {2.5, 1.5}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{5 34^Rational[-1, 2], 3 34^Rational[-1, 2]}, {
        0.8574929257125441, 0.5144957554275265}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      LineBox[
       NCache[{{0, 0}, {
          Rational[5, 2], 
          Rational[3, 2]}}, {{0, 0}, {2.5, 1.5}}]]}, {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.45, 
        NCache[{0, 
          ArcTan[
           Rational[3, 5]]}, {0, 0.5404195002705842}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Theta]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0.6, 0.1}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 0.3}], 
       ImageScaled[{0.5, 0.3}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TagBox[RowBox[{\\\"z\\\", \\\"\[LongEqual]\\\", \
RowBox[{\\\"x\\\", \\\"+\\\", RowBox[{\\\"\[ImaginaryI]\\\", \\\" \\\", \\\"y\
\\\"}]}], \\\"\[LongEqual]\\\", \\\"r\\\"}], HoldForm], \
TraditionalForm]\\)(cos\[Theta]+\[ImaginaryI] sin\[Theta])\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[5, 2], 
        Rational[3, 2]}, {2.5, 1.5}], 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 4]}], 
       ImageScaled[{0, -0.25}]]], {
      Thickness[0.0025], 
      ArrowBox[
       BezierCurveBox[
        NCache[{{2, 
           Rational[-1, 2]}, {
           Rational[3, 2], 
           Rational[-1, 2]}, {
           Rational[11, 8], 
           Rational[3, 4]}, {5 34^Rational[-1, 2], 3 34^Rational[-1, 2]}}, {{
          2, -0.5}, {1.5, -0.5}, {1.375, 0.75}, {0.8574929257125441, 
          0.5144957554275265}}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"cos\[Theta]+\[ImaginaryI] sin\[Theta]\"", 12, StripOnInput -> 
        False], TraditionalForm], 
      NCache[{2, 
        Rational[-1, 2]}, {2, -0.5}], 
      ImageScaled[{0, 0.75}]], {
      Thickness[0.0025], {
       CircleBox[
        NCache[{
          Rational[19, 8], 
          Rational[57, 40]}, {2.375, 1.425}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{Rational[1, 6] Pi + ArcTan[
            Rational[3, 5]], Rational[1, 2] Pi + ArcTan[
            Rational[3, 5]]}, {1.064018275868883, 2.1112158270654806`}]], 
       LineBox[
        NCache[{{
           Rational[23, 10], 
           Rational[31, 20]}, {
           Rational[13, 10], 
           Rational[19, 20]}}, {{2.3, 1.55}, {1.3, 0.95}}]], 
       CircleBox[
        NCache[{
          Rational[49, 40], 
          Rational[43, 40]}, {1.225, 1.075}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{-Pi + ArcTan[
            Rational[3, 5]], Rational[-1, 2] Pi + ArcTan[
            Rational[3, 5]]}, {-2.601173153319209, -1.0303768265243125`}]], 
       CircleBox[
        NCache[{
          Rational[39, 40], 
          Rational[37, 40]}, {0.975, 0.925}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{Rational[-1, 2] Pi + ArcTan[
            Rational[3, 5]], 
          ArcTan[
           Rational[3, 5]]}, {-1.0303768265243125`, 0.5404195002705842}]], 
       LineBox[
        NCache[{{
           Rational[21, 20], 
           Rational[4, 5]}, {
           Rational[1, 20], 
           Rational[1, 5]}}, {{1.05, 0.8}, {0.05, 0.2}}]], 
       CircleBox[
        NCache[{
          Rational[1, 8], 
          Rational[3, 40]}, {0.125, 0.075}], 
        NCache[
        Rational[1, 20] Rational[17, 2]^Rational[1, 2], 0.14577379737113252`], 
        NCache[{Rational[1, 2] Pi + ArcTan[
            Rational[3, 5]], Rational[5, 6] Pi + ArcTan[
            Rational[3, 5]]}, {2.1112158270654806`, 3.1584133782620785`}]]}}, 
     
     InsetBox[
      FormBox[
       StyleBox["r", 11, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[5, 4], 
        Rational[3, 4]}, {1.25, 0.75}], 
      NCache[
       ImageScaled[{
         Rational[5, 2], -0.75}], 
       ImageScaled[{2.5, -0.75}]]]}, ImageSize -> 320], 
   "\"Fig. 8. The representation of the complex number \\!\\(\\*FormBox[\\\"z\
\\\", TraditionalForm]\\) in polar coordinates.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->649300219,ExpressionUUID->"a84ecbf8-b68e-4604-8cbe-96c8aa53ce4f"]
}, {2}]],

Cell[TextData[{
 "Using the polar coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"r", ",", "\[Theta]"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b151993f-9f03-421c-8eeb-b690966a1848"],
 " one can represent ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ee73a055-39d8-470b-84da-ffc9deab56b7"],
 " as"
}], "Text",
 CellID->30638155,ExpressionUUID->"7e20c0b8-62ab-4652-8853-3406fc774ee0"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{Cell[TextData[Cell[BoxData[
     FormBox[GridBox[{
        {
         RowBox[{"x", "\[AlignmentMarker]", "=", 
          RowBox[{"r", " ", "cos", " ", "\[Theta]"}]}]},
        {
         RowBox[{"y", "\[AlignmentMarker]", "=", 
          RowBox[{"r", " ", "sin", " ", "\[Theta]", " "}]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
      TraditionalForm]],ExpressionUUID->
     "d84c2245-34e6-48d0-9d69-74288d084c42"]],ExpressionUUID->
     "dbd935dd-cc4b-45ec-bb06-8049230fb2ac"], ","}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->5952995,ExpressionUUID->"af97775d-00d9-4aa1-bfff-2f268a04227b"],

Cell["which corresponds to", "Text",
 CellID->750003249,ExpressionUUID->"3380fe69-9b51-4516-9350-609c1f927bbf"],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{Cell[TextData[Cell[BoxData[
     FormBox[GridBox[{
        {
         RowBox[{"r", "\[AlignmentMarker]", "=", 
          RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}]}]},
        {
         RowBox[{
          RowBox[{"tan", " ", "\[Theta]"}], "\[AlignmentMarker]", "=", 
          FractionBox["y", "x"]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
      TraditionalForm]],ExpressionUUID->
     "3212a330-393f-4738-90bc-fbf7ecf7faae"]],ExpressionUUID->
     "f9e5b0c4-1743-4c9d-8bf1-e45a43a62177"], "."}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->848081270,ExpressionUUID->"9651a16f-7a4e-4513-a9cd-d7a60dfbb661"],

Cell[TextData[{
 "The angle \[Theta] is called the ",
 StyleBox["argument",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f5be1dbf-f890-468a-8362-0decc3fbdef1"],
 ". In Wolfram Language, it is available as the function ",
 ButtonBox["Arg",
  BaseStyle->"Link"],
 ". In Wolfram Language, the argument always satisfies"
}], "Text",
 CellID->131896293,ExpressionUUID->"4e6d0388-68b6-4bf5-b128-1362a4351c7d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", "\[Pi]"}], "<", 
   RowBox[{"arg", " ", "z"}], "<=", 
   RowBox[{"\[Pi]", "."}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->140796883,ExpressionUUID->"d84973e1-547f-4928-8e53-5f10d710eba4"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->360137030,ExpressionUUID->"7dd6b620-87d3-4eaf-8920-908121453753"],

Cell[TextData[{
 "Find the argument of the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"c15ada8d-e368-e143-ad34-e84b4a8eafcb"],
 ". Using the function ",
 ButtonBox["Arg",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->58742649,ExpressionUUID->"0e3d3684-5364-44fb-8386-2dc0626dee79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], "]"}]], "SolvedExampleInput",
 CellID->122030470,ExpressionUUID->"fec03f01-be42-4786-a015-b067ddaeb7d1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"3", " ", "\[Pi]"}], "4"]}]], "SolvedExampleOutput",
 CellID->370580158,ExpressionUUID->"161afbbe-8553-488f-a60e-39f3d5582611"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->135786757,ExpressionUUID->"b314c0be-de85-4f63-84d4-20a0df5a5c91"],

Cell[TextData[{
 "Notice, referring to Fig. 8, that any complex number ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "46ff7f73-72e2-450a-bff8-9bf3676c1209"],
 " can be written"
}], "Text",
 CellID->71023858,ExpressionUUID->"62a79678-afae-4eea-879a-9083f62feb63"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "=", 
    RowBox[{"a", " ", "b"}]}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"where", " ", "a"}], "\[Element]", 
     RowBox[{
      SubscriptBox["\[DoubleStruckCapitalR]", 
       RowBox[{">", "0"}]], " ", "and", " ", 
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}]}]}], "=",
     "1"}], ","}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->494138068,ExpressionUUID->"95cd6e0c-b227-4962-84a6-335e76d4d3df"],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d279e85f-3f85-46eb-b9a8-43317642b3ef"],
 ", since it has modulus 1, lies on the unit circle, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{
     RowBox[{"cos", "\[InvisibleSpace]", "\[Theta]"}], "+", 
     RowBox[{
     "\[ImaginaryI]", " ", "sin", "\[InvisibleSpace]", "\[Theta]"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "70976944-c723-46ea-b788-6e7a9e9efb88"],
 ". To sum up:"
}], "Text",
 CellID->149722283,ExpressionUUID->"72e3e18a-cc2f-4bf3-9a77-8f00303861a8"],

Cell[BoxData[
 FormBox[
  RowBox[{"z", "=", 
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"cos", "\[InvisibleSpace]", "\[Theta]"}], "+", 
       RowBox[{
       "\[ImaginaryI]", " ", "sin", "\[InvisibleSpace]", "\[Theta]"}]}], 
      ")"}], "."}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->655590036,ExpressionUUID->"89db7f64-ec26-473c-a54d-bc1c5187cdff"],

Cell[TextData[{
 "Common pitfall",
 ": It is important to notice that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{
     RowBox[{"arg", " ", "z"}], "!=", 
     RowBox[{"arctan", "(", 
      RowBox[{"y", "/", "x"}], ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"efc1c7ff-e593-455d-a0ac-32690211fd2f"],
 ". The reason is that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], "<", 
    RowBox[{"arctan", "(", "a", ")"}], "<", 
    FractionBox["\[Pi]", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"50a54845-e989-4620-979a-8f1a837932b1"],
 ", therefore the two functions only agree when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "af3ae9b0-8e40-46f5-a195-8ce71347f8d1"],
 "."
}], "Text",
 CellChangeTimes->{3.961247289792284*^9},
 CellID->1632977391,ExpressionUUID->"13cec5b7-f2ee-4446-bf24-53f7e79077f8"],

Cell[TextData[{
 "It can, however, be expressed as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ArcTan",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "ba542a8d-e830-4705-9ca9-048c3e446ba0"],
 " in Wolfram Language."
}], "Text",
 CellID->317596935,ExpressionUUID->"3e7b7f54-4f65-48da-834a-7c57cce81515"],

Cell[TextData[{
 ButtonBox["Chapter 5",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 " will revisit the argument in greater detail."
}], "Text",
 CellID->117088449,ExpressionUUID->"51bd6474-32bd-44bd-846e-762ba57e6a90"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Geometric Meaning of Multiplication", "Subsection",
 CellID->31345884,ExpressionUUID->"4ef52d8c-f09e-4936-b7ec-629f17c7fa22"],

Cell[TextData[{
 "Using the polar representation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RowBox[{
     SubscriptBox["r", "1"], "(", 
     RowBox[{
      RowBox[{"cos", " ", 
       SubscriptBox["\[Theta]", "1"]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "sin", "\[InvisibleSpace]", 
       SubscriptBox["\[Theta]", "1"]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b928e71f-9c4f-4255-a0f2-e046d21a240d"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "2"], "=", 
    RowBox[{
     SubscriptBox["r", "2"], "(", 
     RowBox[{
      RowBox[{"cos", " ", 
       SubscriptBox["\[Theta]", "2"]}], "+", 
      RowBox[{"\[ImaginaryI]", " ", "sin", "\[InvisibleSpace]", 
       SubscriptBox["\[Theta]", "2"]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7a46f566-3912-442a-9f6b-2752c50e79b7"],
 ", one can find their product:"
}], "Text",
 CellID->29972869,ExpressionUUID->"00164d9e-9576-42d2-b75f-c6a1f0070a4d"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{"z", "\[AlignmentMarker]", "=", 
      RowBox[{
       SubscriptBox["r", "1"], 
       RowBox[{
        SubscriptBox["r", "2"], "(", 
        RowBox[{
         RowBox[{"cos", " ", 
          SubscriptBox["\[Theta]", "1"]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "sin", "\[InvisibleSpace]", 
          SubscriptBox["\[Theta]", "1"]}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cos", "\[InvisibleSpace]", 
          SubscriptBox["\[Theta]", "2"]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "sin", "\[InvisibleSpace]", 
          SubscriptBox["\[Theta]", "2"]}]}], ")"}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        SubscriptBox["r", "1"], 
        RowBox[{
         SubscriptBox["r", "2"], "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"cos", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "1"], "cos", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "2"]}], "-", 
            RowBox[{"sin", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "1"], "sin", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "2"]}]}], ")"}], "+", 
          RowBox[{"\[ImaginaryI]", "(", 
           RowBox[{
            RowBox[{"cos", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "1"], "sin", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "2"]}], "+", 
            RowBox[{"sin", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "1"], "cos", "\[InvisibleSpace]", 
             SubscriptBox["\[Theta]", "2"]}]}], ")"}]}], "]"}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->82756032,ExpressionUUID->"96e5c1d5-c6bd-4652-a698-cdecdaabac73"],

Cell["Using the trigonometric identities, this becomes", "Text",
 CellID->890840350,ExpressionUUID->"35f56a9a-8f46-4bd5-8f52-80ed22feac28"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["z", "1"], 
    SubscriptBox["z", "2"]}], "=", 
   RowBox[{
    SubscriptBox["r", "1"], 
    RowBox[{
     SubscriptBox["r", "2"], "[", 
     RowBox[{
      RowBox[{"cos", "(", 
       RowBox[{
        SubscriptBox["\[Theta]", "1"], "+", 
        SubscriptBox["\[Theta]", "2"]}], ")"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"sin", "(", 
        RowBox[{
         SubscriptBox["\[Theta]", "1"], "+", 
         SubscriptBox["\[Theta]", "2"]}], ")"}]}]}], "]"}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->17545120,ExpressionUUID->"fa3cc5de-fc8d-4a00-8e93-f9ab96a2df83"],

Cell["In other words, the rule to multiply two numbers is:", "Text",
 CellID->272359751,ExpressionUUID->"20c7b148-9588-47b8-a24e-eb646fde1b46"],

Cell[CellGroupData[{

Cell["Multiply their moduli", "ItemNumbered",
 CellID->497122929,ExpressionUUID->"590deb0c-b898-4cf7-a7e4-556b81398d11"],

Cell["Add their angles", "ItemNumbered",
 CellID->206996843,ExpressionUUID->"05771cc4-bb91-40b2-a5c8-cef9eff6b781"]
}, Open  ]],

Cell["The process is visualized in Fig. 9.", "Text",
 CellID->485540229,ExpressionUUID->"7599c8e4-4f81-4867-942c-836d4407c900"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", "Dashed", ",", 
         RowBox[{"Circle", "[", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"StringJoin", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"Abs", "[", "z", "]"}], ",", "TraditionalForm"}], 
              "]"}], ",", "\"\<=1\>\""}], "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              FractionBox["2", "3"], ",", 
              RowBox[{"-", 
               FractionBox["1", "3"]}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["2", "3"], ",", 
           RowBox[{"-", 
            FractionBox["1", "3"]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{"3", "/", "5"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], "/", "3"}], ",", "2"}], "}"}]}], "}"}], 
          "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], "/", "3"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrowheads", "[", "0.04", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "/", "9"}], ",", 
              RowBox[{"14", "/", "9"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
        "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{
              SubscriptBox["z", "1"], "*", 
              SubscriptBox["z", "2"]}], ",", "TraditionalForm"}], "]"}], ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "/", "9"}], ",", 
           RowBox[{"14", "/", "9"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "0.02"}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.3", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "Pi"}], ",", 
              RowBox[{
               RowBox[{"2", "Pi"}], "-", 
               RowBox[{"ArcTan", "[", 
                FractionBox["1", "2"], "]"}]}]}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(1\)]\)\>\"", ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "5"}], ",", 
           RowBox[{
            RowBox[{"-", "1"}], "/", "10"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "3"}], ",", 
           RowBox[{"2", "/", "9"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.35", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"\[Pi]", "-", 
               RowBox[{"ArcTan", "[", "3", "]"}]}]}], "}"}]}], "]"}], "]"}]}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Theta]\), \(2\)]\)\>\"", ",", 
           "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "5"}], ",", 
           RowBox[{"2", "/", "5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "0.45", ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"ArcTan", "[", "7", "]"}]}], "}"}]}], "]"}], "]"}]}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          
          RowBox[{"\"\<\!\(\*SubscriptBox[\(\[Theta]\), \
\(1\)]\)+\!\(\*SubscriptBox[\(\[Theta]\), \(2\)]\)\>\"", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"2", "/", "3"}], ",", 
           RowBox[{"2", "/", "5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
            "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{
             RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
            "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", "/", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.3"}], ",", 
           RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1.5", ",", "2.3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.5", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.8", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "->", "240"}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", 
   ",", "\"\<Fig. 9. The multiplication of two complex numbers.\>\""}], 
  "]"}]], "Input",
 CellID->729716677,ExpressionUUID->"060cccfe-78f3-4da4-a825-6af241f3cbf5"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      Dashing[{Small, Small}], 
      CircleBox[{0, 0}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \
TraditionalForm]\\)=1\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-1, 2], 
        Rational[-1, 2]}, {-0.5, -0.5}], 
      NCache[
       ImageScaled[{
         Rational[3, 2], 1}], 
       ImageScaled[{1.5, 1}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.04], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[2, 3], 
          Rational[-1, 3]}}, {{0, 0}, {
         0.6666666666666666, -0.3333333333333333}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"1\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[2, 3], 
        Rational[-1, 3]}, {0.6666666666666666, -0.3333333333333333}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[4, 5]}], 
       ImageScaled[{0.25, 0.8}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.04], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[-2, 3], 2}}, {{0, 0}, {-0.6666666666666666, 2}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-2, 3], 2}, {-0.6666666666666666, 2}], 
      NCache[
       ImageScaled[{1, 
         Rational[1, 2]}], 
       ImageScaled[{1, 0.5}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.04], 
      ArrowBox[
       NCache[{{0, 0}, {
          Rational[2, 9], 
          Rational[14, 9]}}, {{0, 0}, {0.2222222222222222, 
         1.5555555555555556`}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{SubscriptBox[\\\"z\\\", \\\"1\\\"], \\\" \
\\\", SubscriptBox[\\\"z\\\", \\\"2\\\"]}], TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[2, 9], 
        Rational[14, 9]}, {0.2222222222222222, 1.5555555555555556`}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 0}], 
       ImageScaled[{0.25, 0}]]], {
      Arrowheads[{0, -0.02}], 
      ArrowBox[
       CircleBox[{0, 0}, 0.3, 
        NCache[{2 Pi, 2 Pi - ArcTan[
           Rational[1, 2]]}, {6.283185307179586, 5.81953769817878}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(1\\)]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[3, 5], 
        Rational[-1, 10]}, {0.6, -0.1}], 
      NCache[
       ImageScaled[{
         Rational[2, 3], 
         Rational[11, 18]}], 
       ImageScaled[{0.6666666666666666, 0.6111111111111112}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.35, 
        NCache[{0, Pi - ArcTan[3]}, {0, 1.8925468811915387`}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(2\\)]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[-1, 5], 
        Rational[2, 5]}, {-0.2, 0.4}], 
      NCache[
       ImageScaled[{
         Rational[3, 4], 
         Rational[1, 2]}], 
       ImageScaled[{0.75, 0.5}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.45, 
        NCache[{0, 
          ArcTan[7]}, {0, 1.4288992721907328`}]]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(1\\)]\\)+\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(2\\)]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[2, 3], 
        Rational[2, 5]}, {0.6666666666666666, 0.4}], 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]], {
      Thickness[0.003], 
      LineBox[{{0, -2}, {0, 2}}]}, {
      Thickness[0.003], 
      LineBox[{{-2, 0}, {2, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {2, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{-0.5, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 2}, 
      NCache[
       ImageScaled[{0, 
         Rational[-1, 2]}], 
       ImageScaled[{0, -0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[\\\"z\\\", TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[3, 2], 2}, {1.5, 2}], 
      ImageScaled[{-0.6499999999999999, -0.25}]], 
     LineBox[{{1.5, 2.3}, {1.5, 2}, {1.8, 2}}]}, ImageSize -> 240], 
   "\"Fig. 9. The multiplication of two complex numbers.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->308745568,ExpressionUUID->"71686989-bad7-49a2-9b31-03f023ef6b8b"]
}, {2}]],

Cell[TextData[{
 "In the following figure, you can explore the multiplication operation \
visually, by moving the points ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fe3b837b-4b6f-4df2-9e82-ce0b0325f7a4"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6b77c6f5-29ff-4cbb-9061-11257a71dc5f"],
 "."
}], "Text",
 CellID->2213072,ExpressionUUID->"0cf0c35f-7838-4c5d-a5e1-faf5beec2833"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"a", "=", 
        RowBox[{
         RowBox[{"z1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"z1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"b", "=", 
        RowBox[{
         RowBox[{"z2", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"z2", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"c", "=", 
        RowBox[{"a", "*", "b"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Plot", "[", 
        RowBox[{"Null", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
         RowBox[{"AxesLabel", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Re", "[", "z", "]"}], ",", 
            RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotRange", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "6.5"}], ",", "6.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "6.5"}], ",", "6.5"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
         RowBox[{"AxesStyle", "->", 
          RowBox[{"Directive", "[", "12", "]"}]}], ",", 
         RowBox[{"Epilog", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Dashed", ",", 
              RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"ReIm", "[", "a", "]"}]}], "}"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Arrow", "@", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"ReIm", "[", "b", "]"}]}], "}"}], "]"}]}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"Arrow", "@", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", 
                  RowBox[{"ReIm", "[", "c", "]"}]}], "}"}], "]"}]}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{
                  SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], ",",
                 "12"}], "]"}], ",", 
              RowBox[{"ReIm", "[", "a", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{
                  SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], ",",
                 "12"}], "]"}], ",", 
              RowBox[{"ReIm", "[", "b", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", 
                RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{
                  RowBox[{
                   SubscriptBox["z", "1"], "*", 
                   SubscriptBox["z", "2"]}], ",", "TraditionalForm"}], "]"}], 
                ",", "12"}], "]"}], ",", 
              RowBox[{"ReIm", "[", "c", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]}], 
        "]"}]}]}], "\[IndentingNewLine]", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           SubscriptBox["z", "1"], ",", "12"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.3"}], ",", 
        RowBox[{"-", "2.3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2.3", ",", "2.3"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z2", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"Style", "[", 
          RowBox[{
           SubscriptBox["z", "2"], ",", "12"}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<Fig. 10. Multiplication of \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], 
       ",", "\"\< and \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], 
       ",", "\"\<.\>\""}], "]"}]}], "]"}], "&"}]}]], "Input",
 CellID->886641,ExpressionUUID->"8b622cdd-996c-42cb-aaa0-752659969080"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`z1$$ = {-2, 2}, $CellContext`z2$$ = {
         Rational[-1, 2], -2}, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`z1$$], {-2, 2}, 
           Text[
            Style[
             Subscript[$CellContext`z, 1], 12]]}, {-2.3, -2.3}, {2.3, 2.3}, 
          ControlType -> Slider2D}, {{
           Hold[$CellContext`z2$$], {
            Rational[-1, 2], -2}, 
           Text[
            Style[
             Subscript[$CellContext`z, 2], 12]]}, {-2, -2}, {2, 2}, 
          ControlType -> Slider2D}}, 
       Typeset`size$$ = {240., {107.34765625, 114.580078125}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, 
        "Variables" :> {$CellContext`z1$$ = {-2, 2}, $CellContext`z2$$ = {
            Rational[-1, 2], -2}}, "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Module[{$CellContext`a$, $CellContext`b$, $CellContext`c$}, \
$CellContext`a$ = 
           Part[$CellContext`z1$$, 1] + 
            I Part[$CellContext`z1$$, 2]; $CellContext`b$ = 
           Part[$CellContext`z2$$, 1] + 
            I Part[$CellContext`z2$$, 
               2]; $CellContext`c$ = $CellContext`a$ $CellContext`b$; 
          Plot[Null, {$CellContext`x, -3, 2}, AxesLabel -> {
              Re[$CellContext`z], 
              Im[$CellContext`z]}, PlotRange -> {{-6.5, 6.5}, {-6.5, 6.5}}, 
            AspectRatio -> Automatic, AxesStyle -> Directive[12], 
            Epilog -> {{Dashed, 
               Circle[]}, 
              Arrow[
               Line[{{0, 0}, 
                 ReIm[$CellContext`a$]}]], 
              Arrow[
               Line[{{0, 0}, 
                 ReIm[$CellContext`b$]}]], {Red, 
               Arrow[
                Line[{{0, 0}, 
                  ReIm[$CellContext`c$]}]]}, 
              Text[
               Style[
                ToString[
                 Subscript[$CellContext`z, 1], TraditionalForm], 12], 
               ReIm[$CellContext`a$], {0, 1}], 
              Text[
               Style[
                ToString[
                 Subscript[$CellContext`z, 2], TraditionalForm], 12], 
               ReIm[$CellContext`b$], {1, -1.5}], 
              Text[
               Style[
                ToString[
                Subscript[$CellContext`z, 1] Subscript[$CellContext`z, 2], 
                 TraditionalForm], 12], 
               ReIm[$CellContext`c$], {0, 1}]}]], 
        "Specifications" :> {{{$CellContext`z1$$, {-2, 2}, 
            Text[
             Style[
              Subscript[$CellContext`z, 1], 12]]}, {-2.3, -2.3}, {2.3, 
           2.3}}, {{$CellContext`z2$$, {
             Rational[-1, 2], -2}, 
            Text[
             Style[
              Subscript[$CellContext`z, 2], 12]]}, {-2, -2}, {2, 2}}}, 
        "Options" :> {}, "DefaultOptions" :> {}], 
       ImageSizeCache -> {290.5, {224.14765624999998`, 231.38007812499998`}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   "\"Fig. 10. Multiplication of \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \
\\\"1\\\"], TraditionalForm]\\) and \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \
\\\"2\\\"], TraditionalForm]\\).\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {FontFamily -> "Source Sans Code"}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->231613509,ExpressionUUID->"57065148-2836-4eef-bd93-fc7e7f4b44e7"]
}, {2}]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->461890220,ExpressionUUID->"2b27e3f6-4e2d-4558-bf42-a5d8da71a687"],

Cell[TextData[{
 "Draw the numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RowBox[{
     FractionBox[
      SqrtBox["3"], "4"], "-", 
     FractionBox["\[ImaginaryI]", "4"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4134f7b8-036b-4a74-9ae9-d15bb61a36a1"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "2"], "=", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"70a37a16-7cd6-4434-bc37-450b815e5e61"],
 " in the complex plane. Calculate their product and draw it."
}], "SolvedExampleNote",
 CellID->445189052,ExpressionUUID->"107091e0-46f1-4585-889f-a70191c353ff"],

Cell[TextData[{
 "One can calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], 
    SubscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c60bdbea-07af-449d-b757-51239d00f274"],
 " in two ways: either from Eq. (4) or from (16). The result is:"
}], "SolvedExampleNote",
 CellID->291232106,ExpressionUUID->"c75fe5b5-2077-4128-8e95-40e1b12f8796"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SqrtBox["3"], "4"], "-", 
     FractionBox["\[ImaginaryI]", "4"]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}], "//", 
  "ComplexExpand"}]], "SolvedExampleInput",
 CellID->430318055,ExpressionUUID->"bde693cd-f578-41cd-b13a-ff79add4ec19"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "-", 
  FractionBox[
   SqrtBox["3"], "2"], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      SqrtBox["3"], "2"]}], ")"}]}]}]], "SolvedExampleOutput",
 CellID->131238665,ExpressionUUID->"8fd65e6c-0357-4ecb-b625-528cc4891159"]
}, Open  ]],

Cell["Here they are plotted in the complex plane:", "SolvedExampleNote",
 CellID->52808477,ExpressionUUID->"ceb53646-d494-47dc-b5b2-6fb651ba6771"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z1", "=", 
     RowBox[{
      FractionBox[
       SqrtBox["3"], "4"], "-", 
      FractionBox["\[ImaginaryI]", "4"]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"z2", "=", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      RowBox[{"2", "\[ImaginaryI]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"z3", "=", 
     RowBox[{"z1", "*", "z2"}]}], ";", 
    RowBox[{"Plot", "[", 
     RowBox[{"Null", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",", 
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}]}], 
        "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"Epilog", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Dashed", ",", 
           RowBox[{"Circle", "[", "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"Arrow", "@", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"ReIm", "[", "z1", "]"}]}], "}"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Arrow", "@", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"ReIm", "[", "z2", "]"}]}], "}"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Arrow", "@", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"ReIm", "[", "z3", "]"}]}], "}"}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], ",", 
             "12"}], "]"}], ",", 
           RowBox[{"ReIm", "[", "z1", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], ",", 
             "12"}], "]"}], ",", 
           RowBox[{"ReIm", "[", "z2", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{
                SubscriptBox["z", "1"], "*", 
                SubscriptBox["z", "2"]}], ",", "TraditionalForm"}], "]"}], ",",
              "12"}], "]"}], ",", 
           RowBox[{"ReIm", "[", "z3", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->309463259,ExpressionUUID->"8eb991cd-2385-4c54-8f80-8a1afe65b4ba"],

Cell[BoxData[
 GraphicsBox[{{}, {}},
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
     "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
     "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{{
     Dashing[{Small, Small}], 
     CircleBox[{0, 0}]}, 
    ArrowBox[
     LineBox[
      NCache[{{0, 0}, {Rational[1, 4] 3^Rational[1, 2], 
         Rational[-1, 4]}}, {{0, 0}, {0.4330127018922193, -0.25}}]]], 
    ArrowBox[
     LineBox[{{0, 0}, {-2, -2}}]], 
    ArrowBox[
     LineBox[
      NCache[{{0, 0}, {
        Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2] + 
         Rational[-1, 2] 3^Rational[1, 2]}}, {{0, 
        0}, {-1.3660254037844386`, -0.3660254037844386}}]]], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"1\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
     NCache[{Rational[1, 4] 3^Rational[1, 2], 
       Rational[-1, 4]}, {0.4330127018922193, -0.25}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], 
      TraditionalForm], {-2, -2}, 
     ImageScaled[{1, -0.25}]], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*FormBox[RowBox[{SubscriptBox[\\\"z\\\", \\\"1\\\"], \\\" \\\
\", SubscriptBox[\\\"z\\\", \\\"2\\\"]}], TraditionalForm]\\)\"", 12, 
       StripOnInput -> False], TraditionalForm], 
     NCache[{
      Rational[-1, 2] + Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2] + 
       Rational[-1, 2] 
        3^Rational[1, 2]}, {-1.3660254037844386`, -0.3660254037844386}], 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3., 2.}, {-2., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->9935300,ExpressionUUID->"5e1a61f7-ebf6-4968-bc1f-30acb7053c26"]
}, {2}]],

Cell["", "SolvedExampleEndCap",
 CellID->1247431371,ExpressionUUID->"75c716a8-f8e5-47e5-bddc-2cc0cb667c47"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometry: De Moivre\[CloseCurlyQuote]s Formula", "Subsection",
 CellID->144078613,ExpressionUUID->"1c6dbdef-1d18-4fa9-99d2-aede7411de22"],

Cell["\<\
You will see how, often, the shortest way to prove a result about real \
numbers is by using complex numbers. Here, you will find multiple-angle \
formulas such as\
\>", "Text",
 CellID->83369900,ExpressionUUID->"4e61531d-ee75-47df-bf76-02b8c7457f30"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"cos", " ", "2", "\[Theta]"}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["cos", "2"], "\[Theta]"}], "-", 
    RowBox[{
     SuperscriptBox["sin", "2"], "\[Theta]"}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->594323451,ExpressionUUID->"84f98a84-13db-4670-ab6a-4edf4f4acfcb"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"cos", " ", "3", " ", "\[Theta]"}], " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["cos", "3"], "\[Theta]"}], "-", 
     RowBox[{"3", "cos\[Theta]", " ", 
      SuperscriptBox["sin", "2"], "\[Theta]"}]}], "=", 
    RowBox[{
     RowBox[{"4", 
      SuperscriptBox["cos", "3"], "\[Theta]"}], "-", 
     RowBox[{"3", "cos", " ", "\[Theta]"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->68456054,ExpressionUUID->"84a023ff-1bb4-490e-8bf0-72ec3a2df21e"],

Cell[TextData[{
 "using complex numbers. Start by considering a point on the unit circle, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"cos\[Theta]", "+", 
     RowBox[{"\[ImaginaryI]", " ", "sin\[Theta]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"944cd5e7-1fae-4040-892e-e3c092f978ec"],
 ". Then ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c9e1f195-3f84-4b41-8431-fa20b072061e"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", ">=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d33ca5cd-d127-4267-b589-09e9588dcd7d"],
 " is:"
}], "Text",
 CellID->4225793,ExpressionUUID->"466c41d3-4aef-413f-ad23-63fd48bbd779"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"cos\[Theta]", " ", "+", " ", 
      RowBox[{"\[ImaginaryI]", " ", "sin\[Theta]"}]}], ")"}], "n"], "=", " ", 
   
   RowBox[{
    RowBox[{"cos", " ", 
     RowBox[{"(", 
      RowBox[{"n", " ", "\[Theta]"}], ")"}]}], " ", "+", " ", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"sin", "(", 
      RowBox[{"n", " ", "\[Theta]"}], ")"}], "\t", Cell[
     "(de Moivre\[CloseCurlyQuote]s formula)",ExpressionUUID->
      "f8ec057d-587b-43d3-a9a0-26f6bb273de6"]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->765991003,ExpressionUUID->"0c3cfd98-8aef-43b1-9628-38c6b654340e"],

Cell["\<\
where the equality is due to the rule for multiplying numbers, which requires \
adding the arguments. Expanding the left side using the binomial theorem, the \
result is:\
\>", "Text",
 CellID->58469325,ExpressionUUID->"54a91e17-204e-4019-85bc-dba34f7041ae"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["cos", "n"], "\[Theta]"}], "+", 
   RowBox[{"\[ImaginaryI]", " ", "n", " ", 
    SuperscriptBox["cos", 
     RowBox[{"n", "-", "1"}]], "\[Theta]", "  ", "sin\[Theta]"}], "-", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"n"},
       {"2"}
      }], ")"}], 
    SuperscriptBox["cos", 
     RowBox[{"n", "-", "2"}]], "\[Theta]", " ", 
    SuperscriptBox["sin", "2"], "\[Theta]"}], "+", "\[Ellipsis]"}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->680898780,ExpressionUUID->"5a6bb78f-acd9-4f39-8a3e-4453d65d42ad"],

Cell["\<\
Equating to the right-hand side and taking the real part of both:\
\>", "Text",
 CellID->210750232,ExpressionUUID->"2b6f3f0e-b3c5-4ddb-9443-075c83df61c2"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"cos", 
    RowBox[{"(", 
     RowBox[{"n", " ", "\[Theta]"}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["cos", "n"], "\[Theta]"}], "-", 
    RowBox[{
     RowBox[{"(", GridBox[{
        {"n"},
        {"2"}
       }], ")"}], 
     SuperscriptBox["cos", 
      RowBox[{"n", "-", "2"}]], "\[Theta]", " ", 
     SuperscriptBox["sin", "2"], "\[Theta]"}], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->216913362,ExpressionUUID->"da910f25-b89a-47b5-ac6e-02c2e4cd8f8c"],

Cell["and similarly for the sine.", "Text",
 CellID->37997941,ExpressionUUID->"075fd92c-2afb-4a09-b2ff-ea09fb5a729a"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->566649395,ExpressionUUID->"7995a2a0-ea00-441e-9a59-cb00b5e8650f"],

Cell[TextData[{
 "Write explicitly ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", 
    RowBox[{"5", "\[Theta]"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9e06fcb5-7eb7-4955-a0dd-b96db7f4800c"],
 " in terms of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "\[InvisibleSpace]", "\[Theta]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cf39d0f0-0b63-40d5-8d12-789ea751953c"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "\[InvisibleSpace]", "\[Theta]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"bb419e83-120d-4c5b-b523-620aadb8952a"],
 "."
}], "SolvedExampleNote",
 CellID->3349350,ExpressionUUID->"81633e00-a22e-4fb2-a191-1f69cd192587"],

Cell[TextData[{
 "You can check your answer using the command ",
 ButtonBox["TrigExpand",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->131767473,ExpressionUUID->"c415bda6-ee74-4aae-ba34-2337a6c13305"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", 
   RowBox[{"5", "\[Theta]"}], "]"}], "]"}]], "SolvedExampleInput",
 CellID->5983359,ExpressionUUID->"7245f9d3-a505-47b4-943b-e488d82b4f66"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", "\[Theta]", "]"}], "5"], "-", 
  RowBox[{"10", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "3"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
  RowBox[{"5", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "4"]}]}]], "SolvedExampleOutput",
 CellID->697182903,ExpressionUUID->"76820232-410a-4678-8ee8-30165a911220"]
}, Open  ]],

Cell[TextData[{
 "You can obtain other equivalent answers by using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["cos", "2"], "\[Theta]"}], "+", 
     RowBox[{
      SuperscriptBox["sin", "2"], "\[Theta]"}]}], "=", "1"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "a9ef34b6-453d-417c-be0d-8bed26dffd5d"],
 "."
}], "SolvedExampleNote",
 CellID->53721767,ExpressionUUID->"8686d9fd-8fe9-4d39-9a88-97b079d6e393"],

Cell["", "SolvedExampleEndCap",
 CellID->184408212,ExpressionUUID->"1f1d16a4-1264-4f04-8eda-52501cb53e15"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"4c170747-0250-4152-a6ab-fe715e0644ca"],

Cell[TextData[{
 "You learned to perform the arithmetic operations ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", 
    RowBox[{",", 
     RowBox[{"-", 
      RowBox[{",", 
       RowBox[{"\[Times]", 
        RowBox[{",", "\[Divide]"}]}]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"09cdb22c-2180-4ecf-b794-04d13e4348d7"],
 " on complex numbers."
}], "SummaryList",
 CellID->53631661,ExpressionUUID->"8e4707f1-1f51-45c6-a029-e42c2baea4bd"],

Cell["\<\
The modulus or absolute value, argument and conjugation have been defined.\
\>", "SummaryList",
 CellChangeTimes->{{3.9629395842689037`*^9, 3.962939589788349*^9}},
 CellID->559205556,ExpressionUUID->"cec8cbff-ab53-44f0-bf34-a74262728071"],

Cell["\<\
Complex numbers can be represented as points on the complex plane with \
Cartesian or polar coordinates.\
\>", "SummaryList",
 CellID->150843637,ExpressionUUID->"b415d2b2-6f8e-4878-b3c8-39fffab1e9d6"],

Cell["\<\
They can also be represented as points on the Riemann sphere.\
\>", "SummaryList",
 CellID->211485454,ExpressionUUID->"9db64332-ba1c-4233-b6a6-9f2318d3c4de"],

Cell["The arithmetic operations can be pictured geometrically.", "SummaryList",
 CellID->230820584,ExpressionUUID->"e864c257-d9b0-438b-a451-d6f881eb8ed4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->55659708,ExpressionUUID->"22726d80-5832-45de-9a07-d361ac80a8cf"],

Cell[TextData[{
 "Given the complex numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RowBox[{"3", "+", 
     RowBox[{
      FractionBox["1", "2"], "\[ImaginaryI]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"713c6dfe-6fa6-45ac-8009-687bb1ca213d"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "2"], "=", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"28fbdc70-defb-4786-b3f0-aa03e735974b"],
 ":\n1. Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "+", 
    SubscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7b777d7a-5683-4362-9f99-9ac78219918c"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "-", 
    SubscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a1a4a8cc-38b5-4d86-b328-f13f91b63ee5"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], 
    SubscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b54672b4-7ce9-43cd-bc21-e8bdf64ad499"],
 ", and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["z", "1"], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "210f7505-265a-4388-9550-13751851703a"],
 ".\n2. Plot them in the complex plane."
}], "Exercise",
 CellID->23457965,ExpressionUUID->"d4b8e5c1-eec6-4497-bbc1-125dd2f8cb41"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"76afd991-f23e-46e5-8007-e6df2293539f"],

Cell["The two numbers are:", "SolutionAnswer",
 CellID->40353190,ExpressionUUID->"961f7baa-453c-4d54-a1d8-367b38c30689"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z1", "=", 
   RowBox[{"3", "+", 
    RowBox[{
     RowBox[{"1", "/", "2"}], "*", "I"}]}]}], ";"}]], "ExerciseInput",
 CellID->404368529,ExpressionUUID->"eeac5768-f960-4596-b454-0aaccaa00ecc"],

Cell["and:", "SolutionAnswer",
 CellID->101356644,ExpressionUUID->"9bf7a078-db2e-48bc-bfcc-ab7723d73448"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", "*", "I"}]}]}], ";"}]], "ExerciseInput",
 CellID->158750617,ExpressionUUID->"d8a01e83-fab1-4b71-ab31-d32f4773c10f"],

Cell["So, to answer the first question:", "SolutionAnswer",
 CellID->20232599,ExpressionUUID->"4c537b37-b5dd-46a8-9f62-97c6e3f38074"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"z1", "+", "z2"}], ",", 
   RowBox[{"z1", "-", "z2"}], ",", 
   RowBox[{"z1", "*", "z2"}], ",", 
   RowBox[{"1", "/", "z1"}]}], "}"}]], "ExerciseInput",
 CellID->73651777,ExpressionUUID->"f4a13723-f406-49ad-811b-f706d6846de9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"z1", "+", "z2"}], ",", 
   RowBox[{"z1", "-", "z2"}], ",", 
   RowBox[{"z1", " ", "z2"}], ",", 
   FractionBox["1", "z1"]}], "}"}]], "ExerciseOutput",
 CellID->452573011,ExpressionUUID->"1e320e47-3498-45c4-8dab-ef35435fc1a6"]
}, Closed]],

Cell["Here they are plotted in the complex plane:", "SolutionAnswer",
 CellID->334598242,ExpressionUUID->"d51dff39-5b64-434b-a29b-856189c7b25d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Labeled", "[", 
      RowBox[{
       RowBox[{"2", "+", 
        FractionBox[
         RowBox[{"5", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{"2", "+", 
        FractionBox[
         RowBox[{"5", " ", "\[ImaginaryI]"}], "2"]}], ",", "Above", ",", 
       RowBox[{"LabelStyle", "->", 
        RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Labeled", "[", 
      RowBox[{
       RowBox[{"4", "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{"4", "-", 
        FractionBox[
         RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], ",", "Below", ",", 
       RowBox[{"LabelStyle", "->", 
        RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Labeled", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        FractionBox[
         RowBox[{"11", " ", "\[ImaginaryI]"}], "2"]}], ",", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        FractionBox[
         RowBox[{"11", " ", "\[ImaginaryI]"}], "2"]}], ",", "Above", ",", 
       RowBox[{"LabelStyle", "->", 
        RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Labeled", "[", 
      RowBox[{
       RowBox[{
        FractionBox["12", "37"], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]"}], "37"]}], ",", 
       RowBox[{
        FractionBox["12", "37"], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]"}], "37"]}], ",", "Above", ",", 
       RowBox[{"LabelStyle", "->", 
        RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "6"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", 
        RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "4", ",", "6"}], "}"}]}],
      "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ToString", "[", 
       RowBox[{
        RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",", 
      RowBox[{"ToString", "[", 
       RowBox[{
        RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}]}], 
     "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{"FontSize", "->", "12"}], "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "400"}]}], "]"}]], "ExerciseInput",
 CellID->45232392,ExpressionUUID->"d7ccdd2c-9f4f-48a5-b854-7a32acd72c55"],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {}, {{}, {
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
       AbsoluteThickness[2], 
       PointBox[{{2., 2.5}, {4., -1.5}, {-4., 5.5}, {
        0.32432432432432434`, -0.05405405405405406}}]},
      Annotation[#, "Charting`Private`Tag#1"]& ], {
      TagBox[
       {Opacity[0.], PointBox[{{2., 2.5}}]},
       Annotation[#, {{Labeled}, Charting`Private`Tag, {1}}]& ], 
      TagBox[
       {Opacity[0.], PointBox[{{4., -1.5}}]},
       Annotation[#, {{Labeled}, Charting`Private`Tag, {2}}]& ], 
      TagBox[
       {Opacity[0.], PointBox[{{-4., 5.5}}]},
       Annotation[#, {{Labeled}, Charting`Private`Tag, {3}}]& ], 
      TagBox[
       {Opacity[0.], PointBox[{{0.32432432432432434`, -0.05405405405405406}}]},
       Annotation[#, {{Labeled}, Charting`Private`Tag, {
         4}}]& ]}}, {{{}, {{}, {{GraphicsGroupBox[{
           {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
             NCache[
              Rational[2, 3], 0.6666666666666666]]}], 
            PolygonBox[{
             Offset[{18.499999999999996`, 30.000000000000004`}, {2., 
               2.575082191780822}], 
              Offset[{18.500000000000004`, 3.552713678800501*^-15}, {2., 
               2.575082191780822}], 
              Offset[{-18.499999999999996`, -3.552713678800501*^-15}, {2., 
               2.575082191780822}], 
              Offset[{-18.500000000000004`, 29.999999999999996`}, {2., 
               2.575082191780822}]}]}, 
           {RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
            AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
            StyleBox[
             RotationBox[
              RowBox[{"2", "+", 
               FractionBox[
                RowBox[{"5", " ", "\[ImaginaryI]"}], "2"]}],
              BoxRotation->0.],
             StripOnInput->False,
             LineOpacity->1,
             FrontFaceOpacity->1,
             BackFaceOpacity->1,
             Opacity->1,
             FontSize->12,
             FontOpacity->1], Offset[{0., 15.}, {2., 2.575082191780822}], 
            NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
             ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
           {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
             NCache[
              Rational[2, 3], 0.6666666666666666]]}], 
            PolygonBox[{
             Offset[{25.499999999999996`, 30.000000000000007`}, {-4., 
               5.5750821917808215`}], 
              Offset[{25.500000000000004`, 5.329070518200751*^-15}, {-4., 
               5.5750821917808215`}], 
              Offset[{-25.499999999999996`, -5.329070518200751*^-15}, {-4., 
               5.5750821917808215`}], 
              Offset[{-25.500000000000004`, 29.999999999999993`}, {-4., 
               5.5750821917808215`}]}]}, 
           {RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
            AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
            StyleBox[
             RotationBox[
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               FractionBox[
                RowBox[{"11", " ", "\[ImaginaryI]"}], "2"]}],
              BoxRotation->0.],
             StripOnInput->False,
             LineOpacity->1,
             FrontFaceOpacity->1,
             BackFaceOpacity->1,
             Opacity->1,
             FontSize->12,
             FontOpacity->1], Offset[{0., 15.}, {-4., 5.5750821917808215}], 
            NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
             ImageScaled[{0.5, 0.5}]]]}], GraphicsGroupBox[{
           {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
             NCache[
              Rational[2, 3], 0.6666666666666666]]}], 
            PolygonBox[{
             Offset[{23.499999999999996`, 30.000000000000007`}, {
               0.32432432432432434`, 0.02102813772676787}], 
              Offset[{23.500000000000004`, 5.329070518200751*^-15}, {
               0.32432432432432434`, 0.02102813772676787}], 
              Offset[{-23.499999999999996`, -5.329070518200751*^-15}, {
               0.32432432432432434`, 0.02102813772676787}], 
              Offset[{-23.500000000000004`, 29.999999999999993`}, {
               0.32432432432432434`, 0.02102813772676787}]}]}, 
           {RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
            AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
            StyleBox[
             RotationBox[
              RowBox[{
               FractionBox["12", "37"], "-", 
               FractionBox[
                RowBox[{"2", " ", "\[ImaginaryI]"}], "37"]}],
              BoxRotation->0.],
             StripOnInput->False,
             LineOpacity->1,
             FrontFaceOpacity->1,
             BackFaceOpacity->1,
             Opacity->1,
             FontSize->12,
             FontOpacity->1], 
            Offset[{0., 15.}, {0.32432432432432434, 0.02102813772676787}], 
            NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
             ImageScaled[{0.5, 0.5}]]]}]}, GraphicsGroupBox[{
          {EdgeForm[None], FaceForm[{GrayLevel[1], Opacity[
            NCache[
             Rational[2, 3], 0.6666666666666666]]}], 
           PolygonBox[{
            Offset[{18.499999999999996`, 3.552713678800501*^-15}, {
              4., -1.575082191780822}], 
             Offset[{18.500000000000004`, -29.999999999999996`}, {
              4., -1.575082191780822}], 
             Offset[{-18.499999999999996`, -30.000000000000004`}, {
              4., -1.575082191780822}], 
             Offset[{-18.500000000000004`, -3.552713678800501*^-15}, {
              4., -1.575082191780822}]}]}, 
          {RGBColor[
           0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 
           AbsoluteThickness[1.25], EdgeForm[None]}, {}, InsetBox[
           StyleBox[
            RotationBox[
             RowBox[{"4", "-", 
              FractionBox[
               RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}],
             BoxRotation->0.],
            StripOnInput->False,
            LineOpacity->1,
            FrontFaceOpacity->1,
            BackFaceOpacity->1,
            Opacity->1,
            FontSize->12,
            FontOpacity->1], Offset[{0., -15.}, {4., -1.575082191780822}], 
           NCache[ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
            ImageScaled[{0.5, 0.5}]]]}]}}}, {}}}, {}, 
   StyleBox[{{{}, {}, {}, {}}, {}},
    FontSize->12]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
    "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", TraditionalForm], 
    FormBox[
    "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[FontSize -> 12],
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->{{All, All}, {All, All}},
  ImageSize->400,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "MessagesHead" -> ComplexListPlot, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& )}},
  PlotRange->{{-5., 5.}, {-2., 6.}},
  PlotRangeClipping->False,
  PlotRangePadding->{{
     Scaled[0.07249999999999997], 
     Scaled[0.037500000000000006`]}, {
     Scaled[0.08045977011494256], 
     Scaled[0.08045977011494256]}},
  Ticks->{{{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}}}]], "ExerciseOutput",
 CellID->674059245,ExpressionUUID->"25dd5833-3c0f-46eb-ab0d-2e055b2d94ec"]
}, {2}]]
}, Closed]],

Cell[TextData[{
 "Given the complex numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RowBox[{"3", "+", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2fed5862-a5d1-4ec3-8f19-928cebc551f1"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "2"], "=", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"384b1e8f-f5e0-4c44-a54f-17af55c13e06"],
 ", calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", 
    SubscriptBox["z", "1"], "\[RightBracketingBar]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"fac86acf-19ba-4a9f-83af-a31a318ef99a"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", 
    SubscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "38471a24-2310-4ff1-8142-7e9873331c2a"],
 "\[RightBracketingBar], ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", 
    RowBox[{
     SubscriptBox["z", "1"], 
     SubscriptBox["z", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"566b054c-7949-447d-bd15-e7234c23bfdc"],
 "\[RightBracketingBar] and verify the identity ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", 
      SubscriptBox["z", "1"], "\[RightBracketingBar]"}], 
     RowBox[{"\[LeftBracketingBar]", 
      SubscriptBox["z", "2"], "\[RightBracketingBar]"}]}], "=", 
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{
      SubscriptBox["z", "1"], 
      SubscriptBox["z", "2"]}], "\[RightBracketingBar]"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "92dc3827-80de-46b9-84ee-08aa944a975d"],
 "."
}], "Exercise",
 CellID->679048616,ExpressionUUID->"3cf54ea5-9a0f-482d-b5bf-59636d94cb74"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"9ea0d8cd-6ffa-46ff-ad88-5a359581e02c"],

Cell["The two numbers are:", "SolutionAnswer",
 CellID->214256153,ExpressionUUID->"1f38f9aa-d065-4d5a-8401-aa83e187fddd"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z1", "=", 
   RowBox[{"3", "+", 
    RowBox[{"2", "*", "I"}]}]}], ";"}]], "ExerciseInput",
 CellID->171717086,ExpressionUUID->"f5d7d81f-d4a7-4fb7-9d3f-485cac18807b"],

Cell["and:", "SolutionAnswer",
 CellID->94036905,ExpressionUUID->"f5e2e4df-0c7b-40e1-92fe-c9867004c5f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z2", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "I"}]}], ";"}]], "ExerciseInput",
 CellID->716277303,ExpressionUUID->"0e01cc44-5b41-4d2d-b3b0-362d10029316"],

Cell[TextData[{
 "Check your answers using the command ",
 ButtonBox["Abs",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->335281113,ExpressionUUID->"3710b348-ea1b-47b2-b3ce-6f9da4c8d07e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "/@", 
  RowBox[{"{", 
   RowBox[{"z1", ",", "z2", ",", 
    RowBox[{"z1", "*", "z2"}]}], "}"}]}]], "ExerciseInput",
 CellID->86472837,ExpressionUUID->"ab4c5186-8802-41d9-a666-8dc1ba13b9cf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["13"], ",", 
   SqrtBox["2"], ",", 
   SqrtBox["26"]}], "}"}]], "ExerciseOutput",
 CellID->105241969,ExpressionUUID->"94d78d8b-55a4-4a5e-8d0f-f5862b82a5ce"]
}, Open  ]],

Cell["and clearly:", "SolutionAnswer",
 CellID->164474994,ExpressionUUID->"0f0b7312-315c-4acb-9b5a-0d9791e0f9c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["13"], "*", 
   SqrtBox["2"]}], "==", 
  SqrtBox["26"]}]], "ExerciseInput",
 CellID->321265987,ExpressionUUID->"05b2b866-02be-487c-8405-b9aebe666347"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->798873384,ExpressionUUID->"7267e7d2-2ed4-47b9-af9c-4527124bba72"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Find the modulus and argument of the numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", "+", 
     RowBox[{
      FractionBox["1", "2"], "\[ImaginaryI]"}]}], ",", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", "\[ImaginaryI]"}]}], ",", " ", 
    RowBox[{"3", "+", 
     RowBox[{"2", "\[ImaginaryI]"}]}], ",", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"bf253d65-0da7-4d84-a197-8b9aa628feb9"],
 "."
}], "Exercise",
 CellID->339192516,ExpressionUUID->"49bc1f84-dca4-4266-96fc-926b1743707b"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"5e333403-1979-454e-89f7-61929e9707fb"],

Cell[TextData[{
 "To find the modulus, use the function ",
 ButtonBox["Abs",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->44173170,ExpressionUUID->"5e8634c1-4a9e-4fee-ba4d-f196b28acf17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", "+", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", "I"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "I"}]}], "}"}]}]], "ExerciseInput",
 CellID->7663821,ExpressionUUID->"c82b95d1-e487-4b6d-99fe-0e091aac933c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox["37"], "2"], ",", 
   SqrtBox["5"], ",", 
   SqrtBox["13"], ",", 
   SqrtBox["2"]}], "}"}]], "ExerciseOutput",
 CellID->15663891,ExpressionUUID->"81dde9f0-e589-41f3-b28a-0977d53b35c2"]
}, Open  ]],

Cell[TextData[{
 "To find the arguments, use the function ",
 ButtonBox["Arg",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->4279602,ExpressionUUID->"1ffbaa93-4453-40c1-bb2c-4d50f201a738"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Arg", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", "+", 
     RowBox[{
      RowBox[{"1", "/", "2"}], "*", "I"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", "I"}]}], "}"}]}]], "ExerciseInput",
 CellID->54761247,ExpressionUUID->"9644c6b7-8f85-4733-a95c-54c90c1bc848"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    FractionBox["1", "6"], "]"}], ",", 
   RowBox[{"\[Pi]", "-", 
    RowBox[{"ArcTan", "[", "2", "]"}]}], ",", 
   RowBox[{"ArcTan", "[", 
    FractionBox["2", "3"], "]"}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3", " ", "\[Pi]"}], "4"]}]}], "}"}]], "ExerciseOutput",
 CellID->759678298,ExpressionUUID->"aaddc518-9155-4748-8a1f-f8b66dda8dbc"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Find a formula for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"5", "\[Theta]"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3e17c98f-64a6-46bd-bfa9-dd1da4f5cea2"],
 " in terms of ",
 Cell[BoxData[
  FormBox["sin\[Theta]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a991abb3-40c2-4b58-8498-02fa5f711341"],
 " and ",
 Cell[BoxData[
  FormBox["cos\[Theta]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9506a806-ee06-45a3-befc-7c6c606b266f"],
 "."
}], "Exercise",
 CellID->2131385,ExpressionUUID->"8514894d-2796-48a1-8b8a-1dfb74cdc502"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"cdac09dc-21b1-417d-a2d7-49f203a32b16"],

Cell[TextData[{
 "In Wolfram Language, the command ",
 ButtonBox["TrigExpand",
  BaseStyle->"Link"],
 " can perform this task. Keep in mind that several different but equivalent \
such formulas can be found:"
}], "SolutionAnswer",
 CellID->190003827,ExpressionUUID->"24046697-c917-4783-93e0-aa9cc6a18166"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"5", "\[Theta]"}], "]"}], "]"}]], "ExerciseInput",
 CellID->471818383,ExpressionUUID->"c824e933-8bc9-42e6-88e9-5a0ff8844958"],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "4"], " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "-", 
  RowBox[{"10", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "\[Theta]", "]"}], "3"]}], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "\[Theta]", "]"}], "5"]}]], "ExerciseOutput",
 CellID->49802779,ExpressionUUID->"d11df587-3728-4636-b4dd-400cfeaaa73c"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Plot in the complex plane the regions defined by:\n1) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "<", 
    "3"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5e044c46-9927-482a-a17c-8cd31553c2cc"],
 "\n2) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<", 
    RowBox[{"Arg", " ", "z"}], "<", 
    RowBox[{"\[Pi]", "/", "4"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"eeda1a99-3e86-4d6b-89c9-aa2c1de87046"],
 "\n3) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"|", 
      RowBox[{"z", "-", 
       RowBox[{"(", 
        RowBox[{"2", "+", "\[ImaginaryI]"}], ")"}]}]}], "|>"}], "1"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "1574d318-6665-4b2f-a8fc-d557f8c30b35"],
 "\n4) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], "<", 
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{"z", "-", 
      RowBox[{"(", 
       RowBox[{"2", "+", "\[ImaginaryI]"}], ")"}]}], 
     "\[RightBracketingBar]"}], "<", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"416d2059-ab9f-4690-a5ea-32b14cd2e5c7"]
}], "Exercise",
 CellID->267427999,ExpressionUUID->"52a1c99b-edbd-466e-a97f-f6802c87f77a"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"dbdaa5b3-2f87-49dc-ae7d-b73aeb31156b"],

Cell[TextData[{
 "Use the function ",
 ButtonBox["ComplexRegionPlot",
  BaseStyle->"Link"],
 " to show the answer:"
}], "SolutionAnswer",
 CellID->456759534,ExpressionUUID->"21b5382f-dd7f-4eb1-97a3-771ebe5aa038"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ComplexRegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], "<", "3"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        RowBox[{"5", "I"}]}], ",", 
       RowBox[{"5", "+", 
        RowBox[{"5", "I"}]}]}], "}"}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["2", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["184", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[Axes -> True, ImageSize -> 120],
      SelectWithContents->True,
      Selectable->False]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ComplexRegionPlot", "[", 
    RowBox[{
     RowBox[{"0", "<", 
      RowBox[{"Arg", "[", "z", "]"}], "<", 
      RowBox[{"\[Pi]", "/", "4"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        RowBox[{"5", "I"}]}], ",", 
       RowBox[{"5", "+", 
        RowBox[{"5", "I"}]}]}], "}"}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["2", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["184", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[Axes -> True, ImageSize -> 120],
      SelectWithContents->True,
      Selectable->False]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ComplexRegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"z", "-", 
        RowBox[{"(", 
         RowBox[{"2", "+", "I"}], ")"}]}], "]"}], ">", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        RowBox[{"5", "I"}]}], ",", 
       RowBox[{"5", "+", 
        RowBox[{"5", "I"}]}]}], "}"}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["2", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["184", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[Axes -> True, ImageSize -> 120],
      SelectWithContents->True,
      Selectable->False]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ComplexRegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "/", "2"}], "<", 
      RowBox[{"Abs", "[", 
       RowBox[{"z", "-", 
        RowBox[{"(", 
         RowBox[{"2", "+", "I"}], ")"}]}], "]"}], "<", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{
        RowBox[{"-", "5"}], "-", 
        RowBox[{"5", "I"}]}], ",", 
       RowBox[{"5", "+", 
        RowBox[{"5", "I"}]}]}], "}"}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["2", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["184", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[Axes -> True, ImageSize -> 120],
      SelectWithContents->True,
      Selectable->False]}], "]"}]}], "\[IndentingNewLine]", 
  "}"}]], "ExerciseInput",
 CellID->726326818,ExpressionUUID->"562235e5-48bd-44cf-a77d-3e6d7dfe28e7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyFl21olWUYx8/OtnNCWsbSFSMiX1onyxeMQyLU88icSmWtl1EtW2ql6cQi
ExzVBysnrMy0+SkItTClNPANWyefJ1/ShZUhOgcqkVs50imzOW0eT3Su/e7B
fxw8X27+z329/K+X+z7XPWz2a0++Eo1EIr/mRSL/r4e3l93W2HI4aJyQXFeb
iIehYQ98dda4O+qKuoPZH9z7aX1XNBw3eOLImvIOh9EHow9OmLzDl82ewzNT
5aPK69IBK/7A+APjD4w/MP7A+APPsNVheKhfsK7wAcMHDB8wfMDwAcPH+Tc+
fq68a16Ul67wA8MPDD8w/MDwc/77+IHpE+0DrZPmSXmBdYUvGL5g+ILh6/z3
8QWvNr5+rr7XPtY+0zprXpW3rvAHwx8Mf+e/jz8Y/rnOmZ4D7UOtu+ZVeeoK
XzB8nf8+vrnOvZ5LPRfah1pnzZvy0hV+zn8fv1z3gp5LPQfaZ1o3zYvy0FXP
vZ4z7WPtC827xql9r310KIt/D3qzeoXhPsMe+KcsvuD2x2T9XQmas98j7l5i
/0eTd/qjTN5DXlfyr9/xc8Cwz3cw+/QXWHlfMexrHMTNPpj74Hp5IU702Sev
YPaRJw7NC3Gxsk8dwSqneVI5+gysedE85OINpr9y5Q19nR+0f/TeYh/72j/I
a98Qn+aRfezoOYMHcShP+pp9sJ4bjRt94kI/V5yaV+LU/tA66hyj/aB9o3OF
xqX1JE6NQ/t8TXbtCbZc2nwik8kPWfk+5eetL3aVxvxLWf12b8idm54ras/z
97Y/9GVlTa/Hynfk0LtmOJhmOGQffMD0gxLTD1eZXw8e2GefFT38gr82PRcX
fuBxPV74hQf2wPiHl/LAr+qBlUck+wtT9BWYvsTuldXTNicbM05vdrZvzgW5
9MDIEWe1YZd/7Gp++d5tq4sbPezSV/ijr8DqF/5g7OKHPNH3xM8+K985R2D1
A49cPKkHeaOe+r9EX8CXc0t8Ok9rn+s8Rf9gl3ixT1zUgfjwC4YfeaMuxA8v
MDzAzBP00a4sDh1vvjOH8P24yQWLzgz7uH58x4D/i+4Vf7dmVvbfw3+NGZtK
joy7PIC5N5GPbnpgZsvr6QHvyx1L79pZ2Rl1eQFvs9XX92DM7Lh7FHzR/Lh7
tN14DHgPvWVxBYVnJ59ua+9/H9E3uk8esUec+CNO+BIH8cKTfOo7J9/8uHqB
i8ecf6Ko4liQmrrwYOmxeDj/++Yzbfv3eVWLNh/NXIqHJ95evzd5Nuq/2lrV
2rYsHaTu37qlsizuNwyf0tn8SIfTww562EH+l97R1V0TO7yG+o0bay9E/W+2
PlhRtDjtYRc/fEfO+RE74Lzni4bXnewKbt0x4vPam2NhujqLPXBBsvixosWX
vTNv3r6tckNBOCN9ZHqiJ+LWalt9cHj6h6mJuQXu3GIHP3+aHf8GsxsMtX3H
Y8ajs9bWru2fH5UXdaFO1Sbv/lfhCW/8gZU3dacP4KV6YHjCm76iz47+M6im
a1DPgPmOuOAJbjV59z+Cvs5v5JVzqvMWdnab3ID5jH3ylYsX9nWO1LjAes7h
Cw94kh94YIdzrHOh1hU84aaWwXWjTwaRgsnL1u2Kh9SLurPyHTn0jln/B7ut
/8OonTuPc5gwOQ89zgvy2+x8BR/a+Qo5b2BW5DiHYOzAg3MIbjIe7l65lp/l
4eKGJ7zhCW/02UefffwTl8ahvJUnvPADL/zgl338ss///9CyeZMSmXh4rmLp
e6mSPPc+nV718P7k1Tx/frrh/fo9meCTkXXL1y2JuXdXwcrvaro2xPwX9s4p
K990PsAOdo989sXRTG883HPg7Ir6N5o89HmHcW65TxY8PXZ3Mhrzi98Zfyoz
4qJ7L8CLVd+NfIeX+gE32D3u7vXowSyvAJ7orzH5sMR4BAuNV8j9Td2IO2Z5
cO9o9N81eVfnKpP3kCdO7BPveYvHrXzn/+WU/b+E1OVxq1PId+T4jhz5wu7L
JuehN8fkPPSIg7zAk7wQF3khLvJCPZEn79SBvFOHW6x/XF8+ZfKubr+ZvI88
+/w/s0+/wZ+6wJe6wJe6EB91mbe0ZElqRdwfdvyrRS0L/nD/0+jT/+iTV/JM
XskzeSXPxas6e5qP5PsflYYn2wp73T3Nvc0cO+nyoHjj8n895grscT6xx3fk
+I4ccxZzF3WhTsRFnMRFnJxTzi15Qp+6UUfqRp2oG3WibuxTN/aZ95gr77E6
BLVWFzeXMqfyfmlqXnlj49z+e4c+Y17E3mrLezDE6uDmZOZm3j/PTN+3vXJn
vpuj+P+vsLq49xBzOPM3cz3zNHNqrjmWuOg34mK+Ii7eU/qOIA76iTiYp4iD
9xZx0G/EQb/pO4N7hH4iTvqJfNLX5Iu+Jl/0NfcE/UWeeDdQb84hcbJPnsjb
t513Hypt6g6qE/d1N79UGO4w7IHJC3liVd7gZ03Pxy5+lBcYefziD7vwRY+5
1619PHPFwXf8/Ace3XUP
      "], {{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
         Opacity[0.3], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxVmHm0llUVxs9G0G6ocJlRUZB5cAARQULR8CoIxSQyyXABEUPkiijiADgg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            "]], PolygonBox[CompressedData["
1:eJwtlHnQjlUYh88tSyRm0DBMthkZ/IGGGVuEQiTbSGPrQ4iyRHYj2YmUz76W
Kfv6WSNqEAalDKns8k/DWIcxjUzXb37PH9d3rvO9z/uc897nd+5KvYd0HJwv
pTQU8sNLkVJx2ILPgk54R8jBv4Eu+DvwIz4EiuJPs882wGLmi2AyPgWa4LcY
Z8ImKMb8w/C7+yV/NpD5keyZDfhoOI7/Cd3xHrAEHwX18BD4VBiDjITByd/J
jz9kzE3eYxHm/zGugvVQkvkomJv8ndfxx4zzYScUZN4VDuG1oTP+NvyAfyDw
AeG9a88t8RZQK3vHfWjGfBvjIKiPV4Hp+LeqGX6HcQD8BCOYDw+/+xg0wEuE
v7tGe8Y/gqP4H9AHfw8OJtegLH9qwmJ8N4zFXwifzZcwCZ8CJ/GP4a7G8Fpz
4FN8IjTCT+hM8OehT/Ke38BbhWuxAIap1vB+8p6exZ8wLod1UIj5v4yLYK3O
lPln8LPOCrbju+ASvhQm4J+E11YNB+FDw7XRGhXwyuEs7Yf++E3GvnAYmjN/
wPiF3g3lmM+BX/A98Ax+j/Hz5DPcEd6D1r6YnPWq2mNy5r/He6km+HX9Zp09
3MDPQDv8APytZ6EUXiNc6zxlEi8drrXOJAefB7/i43Wn8N1wObkmbfG88F72
wpu6e/AXvkv3Cl8H5/EZMFnZggvJZ7o2nDFlS8/sxQvDFfwqVAtnSllS5rfi
m8NnqTXWhNfQu3+HV/WusG+GZaoVvIufVZ3l4d9yWnXFZ8O45Jor+8qssqo7
8Fr4Tusu74CK+Hz4KrnGjeRwDt8IX+Orwndb/1O25obXUsaW4yvCe8lRxvFc
+C25xmXCGVT2RiafvTKyPcuAzu658NnqDGfg3cK95RS8GM60sqzf9E9yD1Pv
mpa8lnqKeonWvJn9ho1ZJpUV9UT1QmXmTlZT1VJ3/jY0Zb41OXPqVepB6j25
2We6o7qbeqZ6OGN5WcYfZTVVLYdpTd3F8F3Qne2NLwxnVT34FbxxeO/q8+Xx
fXAN35d8V6eHf7vubN1wxpXt1VAbfwu+w1cmZ1eZVVaV4T14z/DdVub269nw
s1pD31UmlUW9o1b4jupuqqfvDPcw9S71BGVbd0DZV8ZX4/nCe1fPa493CO9N
mXw53CPUG9TjW+NtwmevnlYnst+cnLnxyipUSe7xBfCG4Vrqf/8Dtmjxqg==

            "]]}]}, {}, {}, {}, {}}, 
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
        LineBox[CompressedData["
1:eJwl02VvFUEYgNF7cS/FHYq7u0OxClbcobgWd7cWiru7u7u78zdwdz8NH06e
zTszm2w2ExYbFzMiGAgEnrHVQxFqEmQLfelHe3aQjJ3Uoz5FucZz5xvoKx2i
QxlMJobx2vyGFieEEtzkjXkjfadjdRxjCKUDHUnOe+vh+lFva2myUYY7fDKf
rNnpRGdS8Nm8qX7Te1qW5jTjINOZwTRmMZNDRBJFbuaTi9T88J54TaAb3enB
T/P7WpG8LGYJi8hPGn7Zs1SX0YtH9GYFy1lJOn7b90ArU5DChLGOtcSyhtVc
JQN/nHmoNWhHTNJPZRObWc9GNvDXUhttS3WuUI3WXCY9l+hDIVZRhadUpQAX
uMh5KtGKc6TlLD3JxwISWcgZWnKCkxznNKfIQwWeUJ555GQ2c5nDMaI5wlEO
U44IWvDdd6XSrnRhKlP4ap5S65CDu3wxa6IHmMgkxpOVCZTkMaWoTRZu8cG5
xrqfUYwm6QJlZjgjieOtfQ11N3vYxT72UotiXOeFfQM0I/0ZxEBemtfVbWwP
/r+b/wB9G24Q
         "]]}},
      VertexTextureCoordinates->CompressedData["
1:eJyFl21olWUYx8/OtnNCWsbSFSMiX1onyxeMQyLU88icSmWtl1EtW2ql6cQi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       "]], {}},
    AspectRatio->1,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->120,
    Method->{
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
      "AxesInFront" -> True},
    PlotRange->{{-5., 5.}, {-5., 5.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdlntQlFUUwJcl5OW6C1gZlYOERmiW6IZScm9tWkwOroxN5sj6aMzHYtoQ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      "], {{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
         Opacity[0.3], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlllUlVUYhvcBhCMeBoEgSSUUjEFNicyIjDApzdJITc3oiJhEpU2alalN
hAQoSK3m+1aXzfM8z8N1ddlcq3mu9137cXkunvV//x6+/U37+//q7m2dW7NC
CPmJELL1vFXcIuaKIXG76BYjYlj0iEGxT6TFAbFfXCTGxUHRJ8bEqOgVU8UR
olwMiNtElzhWTBIlohQ5JSpEkShmX4EoFEcyNllUsqdMHMXTa6dxTgVjKfbP
Y/0U5gs5YzprrbtZ1ItGUY1e2z6Dp3Ufzdmem8mYdRwnakWdmMV+72tiT404
hrGZnFPL2lNZ5zWzmWsQx/M+R1wt1okFYplYSI4a0GHd87Gtihw6xvnEO018
a7Gnmhx2E6NhcljIulLykiKOfl8uWshbAfEuI44VGXEtZ+5Q7HyWa6GP/BUT
b+85W7SSn3LiOTUjr5Wsm85cJfZXMV/Nu2uwF1tKWedcrxSLiI1ruQfbp5EH
23cSPtnfVaI9I5/15HQGMZ4FDczVkyPXzBpxWoh11CnayGs1e6xvreggt+vJ
YQKb52HDJOxx7k5m3L6cgh9V+NyUIVu36+dEdOYTg/nsfdtnJKJ9tfhXg/3N
+Hg6drnelooTsG02443oXsi4bWzhrDM52/J5Ygnrl6Df8lnEugSfWpGbiFUV
9i7C5nNDvBu2c7VYjJ3NxLkOuzrQv4J4TcG/dvaeQ+ysfx1+zkHfKtba9mX4
14I/+fi6FH9t+3L8bkNvFfau4NxW/CzhzJX4ZD868XUxZ9bhx2pkx2oN/nUQ
x0bsXYuv7cSlhvycgW0L8M1+nR9ibXm8P8Se7vcNzCXYtwHZfrpXuO4uFReK
LJ5dyAO8+xvhO+5e4bt2mdjIuJ9p5EHec8SmEPuM5RSy7+AQcxPE5hDvpuWt
jOewroczR1iXi61p9G1j3Hu3YFsuvl+A/Zcz5/GLQ+wVeeIK3i2PISfFJSH2
K8vFyP7uHEBPHv73Mn8le7x+HHliONwH3au2E1/bcy1+2scbsM+27cEm678e
3+zXjZyRxKft6LmGHGRz5lWc61ztYHwH6w7laCfn7sSOHPwYxZct+Ok47kfO
IzZjrO1jfRL5IPHZSO7T2DPO/G58sx7nfx/nppFT6N+Lzr34nMSe3ewdxYZk
hn1FyMPE0M8RZPcDf2Pcb74TDxDHb8X9xLoXPXnYMhgO1+0Q9m5GZw/4jELm
/F0p4DlEvnp4t7yLHOeiZxfydeTYaybrIr4SYl8pkfxGiHe9WPILIfaYP8Vf
7P9d/IGOv8U/xChH6x8MsTeUSf4gxF7ysfgkxHvv78A7Ifaez8TnIdbUr+K3
EOuiQGseCbH//Sv+Iyffix9CrLOfxS8h1pfz6P8M15hrz/3CvcP/Ie4/rtW5
vOdnzGWxb4C9Xbz7fq9nr/cVyZ5nQuyvhZKfCLFPu+5cYxPxoT9jXz/63eQS
4iaJP4kfQ/yfep8YOT4T9Hw0xO/ASyKZiP37OddFItbR1+LeEO/kV+KeEO/w
Y+z33mw979DzZvEQ+XAu3grxH9u9/zXbm4jfhPfsayL2/i/F3SHeZ8+/GuIa
n/9siDZsIueumS/EXSH2FOt+M0T9uZKfDPF7ZT9eDNGXb8R9IfaalMY/DPHb
4vPfDdGG50OsOdfbU+iynpdDrNE2PR8nB47/w9SK6yQrEf2376+HWMeu4U/F
nSF+e54ml87jR9hhG/4Hk9Dpfg==
            "]], PolygonBox[CompressedData["
1:eJwt0+dOlGEQxfFZ4hcvw5uw914RUVARQtQYQlBAUVFREbkGey8g9oa9oth7
Q7ErWMDexYb/yZwPv2SzeXff5zlnpt2EgtT8JDMbiDZYj+PohuHYhteYjBmo
wEX0QRqq8BjjkIntaMIUFGMFGjEJBTiKdRiGrjiEOgxFF1zBA6SjHzbgFHpg
BI7hLpJ1xkd4gixk4LLO6Gfri/PYiJHorc9n0UvffcIXTEd7nEE9UvXMSWXi
WXTHUjxDtjJZhucYrzuvwkvkYipuK6NMZbwcDZiIfCzBVnTAIKzGK+RhGtZi
PzphCBbrzhnKfCVeIAeFqME9pCizC7iPUeqsVpl6lj1RiavKerS6OawuvKNN
uIkBGItW7EEZFuAGHmKMnvGuf2GuRec/sAOzMQst2IkSzFEWP/XZM9mNd8qu
VHf7g/m64189U6rvfmMX5umd3sV3vcs7eWoxwz67Wermn86eq7O8sZjNEmX/
AUXqwLv+ipkWnX+zmPFiffcRa9BWv/mszDwrn6nNSEqYlatj7+KcxSx6J/tw
B4PV8UGLzr3rzriujryb/liELfqvcmXbbDFLnnG1xUz5LHW02JUjFruWrN/e
sphF/w/fvQN6l++g794li91JV7fX9G7vOJGInfFdWWixK6ctZsl3xmfjvcXs
lulue3UWv6PP5gmLXUpRd28tZtc7/A8EDaPr
            "]]}]}, {}, {}, {}, {}}, 
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
        LineBox[CompressedData["
1:eJwt0kszlmEAx+H3lRCiaNGqGWNhxmTrg/gIPgDfob1VI+dyroRyPpfzKUXO
FOWUVCRSonC9MxbX/J7/7r7nuZMyszOygoFAIIf7XOMR+/xgm4fs0cg5Z3ym
hF0a+M8/tijmOy845YRNivjGc/5yzAaFfKWeP/xmnQJ2qOOIX6yRzxdq+cRH
VnjAKk+YZYYacrnikmE89R2uzzSPZq7bTTpHC1ftVi2lnTi7TefpIMLu1DK6
ibe7dIEeIu2XWk4vN+xXukgfUXa/VjDITXtAlxgK/QN7WCsZJcEe0WXGiLbH
tYoJEu3X+p43xNhvtZopbtmT+oF3xNrT+pgDDvlJMPQQuCfppHGXVFJI5g63
Q2e+fC8XmgZakQ==
         "]]}},
      VertexTextureCoordinates->CompressedData["
1:eJxdlntQlFUUwJcl5OW6C1gZlYOERmiW6IZScm9tWkwOroxN5sj6aMzHYtoQ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       "]], {}},
    AspectRatio->1,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->120,
    Method->{
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
      "AxesInFront" -> True},
    PlotRange->{{-5., 5.}, {-5., 5.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx1mHtwVNUdx5e8FqErMkBHVgeKE9M1QIdOTMUX50Io2g6VlTKTIjQEWscy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      "], {{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
         Opacity[0.3], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQfUFdUVRu+1a2LsBBUVYq9gQ+y9iwqKClawi4ANDTawYIiiiFhjr9hF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            "]], PolygonBox[CompressedData["
1:eJwt0ldKA1EUxvF7h6jYFuGj23EJLkBXYUFRjArWBGsEQQQhD/poVxQ1MfaG
YEPFHrv4P9zv4ceZYebcOWUqqmuraiLnXCViePHOvWEYTfjEOtrQjQOUkzBD
bMYKHjGAQbz7cIbljuAXP6hHB7ZRQv4UsRGe62tiH1KYxw360YoMLtCLBmyi
mJxJYh2OcIcEWvCBb4yq5mfsIk9vQ8QlPKBdNZ1jTd/qwRyKOH+CmCMnS3xS
b5fcLxLvkUQcpby7p1mklbus3uyMExRE4ewu9RZxP6YebRZZnW0z+cOWZmU9
l0WhR+ttGq+aWUo7sllsqFabyRlONRvr8cuHmuOaie1q1YdZ2M5mUcgZ48Qd
F2rLa3dW45XVpmedejejXViO4z7nwzPb4S0W9K8kNHubUVo7OFRP1ksRYlwf
azZJ/Vv7emb/2D+3kmuJ
            "]]}]}, {}, {}, {}, {}}, 
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
        LineBox[CompressedData["
1:eJwt0MEyQgEYBeBLSuUqin3ttNeOvRbNYM2mYZtQdFUqWuod9A71DnmFvIHe
IBtfMxbfzNn8c+b8xdrdZX0jCIIqm6zzISVOueCWiDETZnzxzZJfdh0WKVPh
mnseeKRJiyeeaRPxQocuPV7pM2DIG++MaHDFGccUCFnp/2HBnCmffNDmhnNO
OOKAPDn22SNLZr2DkB3SpEiyTYI4W8T+//UH860dEA==
         "]], LineBox[CompressedData["
1:eJwl0Fs6QlEYgOG1Q0QG0YC6MYQGwByLkIic5VAoOsgphZTeni7e5/v/tdbN
3qnMxtp6FEJIc2hIxEIo6QM5Fu07WuOEZfuxvrPLGwU+OGfF/YXuccWq/VJb
VEjar7VDmy1+2OebIb/keWHe+xud01td0HstsmTe1CYxc18HfPJFj8j58/QD
9VT/OeOJBlni7spa55ExR4z4o8s2rxxQ5S6a/a8JPZs55g==
         "]]}},
      VertexTextureCoordinates->CompressedData["
1:eJx1mHtwVNUdx5e8FqErMkBHVgeKE9M1QIdOTMUX50Io2g6VlTKTIjQEWscy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       "]], {}},
    AspectRatio->1,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->120,
    Method->{
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
      "AxesInFront" -> True},
    PlotRange->{{-5., 5.}, {-5., 5.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}], ",", 
   GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlVntQk1cWTwgkWzSoW2wxVYQVMauCRUywCJzrpnbUVsxQsdVCrK+qILjg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      "], {{
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
         Opacity[0.3], EdgeForm[None], 
         GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwBqQFW/iFib1JiAgAAAIgAAAADAAAALAwDGxIHJBEPQi0sMBIIJhQBPBMQ
DBYDMikBIQ0KRRMSNgsJHA8HJRoQDxEFHCQPORcKHxQJFQoCLg4EIxsPGQ8F
GSMPEyUQSEQaFh4DFB0BDxsHJxoGIhgFODYJuEoLLRkFRyEXDhcEQSsoFCYJ
PyYBESIFKSgBFyEKGicQCx8JFSAKGg4GQxcOHgsDJjUJDi4GLC0FNywDJy8Q
mr83MDEHEjAHCzYDRjcDPD0IOzkKFzkEOToEMzQCIDsKPjwQEzwIKj8BMUAH
QTMCHTIBM0EoDCwFemQVvGYWJUgaDSsCEhMIKCoBGAwFCg0CulkNu2IUQ0cX
GkQON0IsK0ECNkYDhHAcc3QdlJEwZ5g1lZYzoIIGp1IMW8ARTLEbXbASjY8u
s7JFraxDpaZArq9Ebb0YcaI9ZbwWgk4GtZ4EcL4cjqAGvm8cX5IxXpAvwFwR
iIcnap06vWwYuUsZqGUWVIwqt0kVe3wgY5c0YbsUn40ubrkZo3I+v1Y3frUE
WLoNm2k4T5MIU6cMi1AphU8IbKkYZLcVUbgLdotgDA==
            "]], 
           PolygonBox[{{117, 81, 11, 30}, {74, 120, 31, 11}, {177, 93, 18, 
            27}, {176, 179, 69, 18}, {90, 109, 24, 34}, {118, 155, 56, 9}, {
            73, 123, 32, 21}, {180, 125, 33, 71}, {121, 122, 21, 2}, {178, 77,
             19, 69}, {119, 163, 62, 16}, {102, 117, 30, 22}, {127, 76, 27, 
            35}, {131, 132, 28, 7}, {78, 136, 39, 6}, {107, 156, 57, 59}, {
            143, 142, 6, 46}, {170, 87, 45, 66}, {89, 85, 43, 13}, {138, 84, 
            42, 40}, {98, 115, 29, 20}, {128, 91, 17, 36}, {92, 90, 34, 17}, {
            111, 128, 36, 28}, {75, 127, 35, 25}, {77, 129, 37, 19}, {104, 
            154, 55, 70}, {114, 161, 60, 62}, {137, 149, 51, 40}, {116, 96, 
            50, 29}, {150, 99, 52, 51}, {152, 118, 9, 53}, {134, 103, 53, 
            38}, {145, 95, 49, 48}, {147, 148, 48, 8}, {156, 106, 58, 57}, {
            157, 126, 4, 58}, {124, 107, 59, 32}, {158, 159, 46, 4}, {151, 
            121, 2, 52}, {82, 168, 22, 12}, {166, 131, 7, 64}, {140, 164, 63, 
            42}, {146, 165, 64, 49}, {85, 138, 40, 43}, {135, 94, 47, 39}, {
            172, 180, 71, 67}, {169, 83, 12, 24}, {80, 137, 40, 41}, {171, 
            173, 67, 14}, {125, 88, 13, 33}, {87, 110, 25, 45}, {105, 153, 54,
             56}, {96, 139, 41, 50}, {120, 97, 20, 31}, {162, 133, 8, 61}, {
            153, 104, 70, 54}, {86, 170, 66, 55}, {129, 182, 72, 37}, {175, 
            171, 14, 68}, {144, 119, 16, 47}, {164, 134, 38, 63}, {182, 174, 
            68, 72}, {161, 113, 61, 60}}]}]}, {}, {}, {}, {}}, 
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
        LineBox[{187, 98, 115, 116, 96, 139, 80, 137, 149, 150, 99, 151, 121, 
         122, 100, 183, 73, 123, 124, 107, 156, 106, 157, 126, 181, 158, 159, 
         141, 143, 142, 160, 130, 78, 136, 135, 94, 144, 119, 163, 114, 161, 
         113, 162, 133, 79, 147, 148, 145, 95, 146, 165, 166, 131, 132, 112, 
         190, 111, 128, 91, 192, 92, 90, 109, 189, 108, 169, 83, 167, 82, 168,
          101, 188, 102, 117, 81, 184, 74, 120, 97, 187}], 
        LineBox[{105, 153, 104, 154, 191, 86, 170, 87, 110, 185, 75, 127, 76, 
         177, 93, 176, 179, 178, 77, 129, 182, 174, 175, 171, 173, 172, 180, 
         125, 88, 186, 89, 85, 138, 84, 140, 164, 134, 103, 152, 118, 155, 
         105}]}},
      VertexTextureCoordinates->CompressedData["
1:eJxlVntQk1cWTwgkWzSoW2wxVYQVMauCRUywCJzrpnbUVsxQsdVCrK+qILjg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       "]], {}},
    AspectRatio->1,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, 0},
    DisplayFunction->Identity,
    Frame->{{True, True}, {True, True}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    ImageSize->120,
    Method->{
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None, "TransparentPolygonMesh" -> True, 
      "AxesInFront" -> True},
    PlotRange->{{-5., 5.}, {-5., 5.}},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.02], 
       Scaled[0.02]}},
    Ticks->{Automatic, Automatic}]}], "}"}]], "ExerciseOutput",
 CellID->174461147,ExpressionUUID->"e69dc5f8-0516-4474-9db6-34fbab7cb751"]
}, Open  ]]
}, Closed]]
}, If[{3} === Open, Closed, Open]]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1895564419,ExpressionUUID->"10216d5d-c155-44a4-a867-da24a1d045d5"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"2. The Complex Plane | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "1. What Is Complex Analysis?"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "3. Complex Functions"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"fc725442-8e38-4a2d-bf41-46811dd790ec"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[643, 23, 222, 7, 108, "Section",ExpressionUUID->"276cfdbd-f1e5-4a91-94b4-f38b51830b2a",
 CounterAssignments->{{"Section", 1}},
 CellID->29626863],
Cell[868, 32, 328, 5, 83, "Text",ExpressionUUID->"91de936f-69ab-4076-9194-e7a32c8917bd",
 CellID->18539210],
Cell[CellGroupData[{
Cell[1221, 41, 124, 1, 56, "Subsection",ExpressionUUID->"7b6b5bde-0f3a-4b24-ad20-a9b94d65cb65",
 CellID->346328761],
Cell[1348, 44, 120, 1, 36, "Text",ExpressionUUID->"8a5d6246-f782-4960-a861-cc6dbf15359c",
 CellID->274766732],
Cell[1471, 47, 357, 9, 32, "DisplayFormulaNumbered",ExpressionUUID->"382adea0-18d8-4510-9609-bddfd9c35e47",
 CellID->390909247],
Cell[1831, 58, 786, 25, 36, "Text",ExpressionUUID->"4d612fa8-1d38-4cdb-b372-86e9a297ad90",
 CellID->209611468],
Cell[2620, 85, 339, 10, 37, "Text",ExpressionUUID->"5bce099f-be52-4f7a-9f3c-2a31622e477d",
 CellID->83879064],
Cell[2962, 97, 227, 5, 32, "DisplayFormulaNumbered",ExpressionUUID->"58b5679b-5b8f-41ef-bb77-4a60d02c50d0",
 CellID->101427874],
Cell[3192, 104, 146, 1, 36, "Text",ExpressionUUID->"7c142343-b6ac-4947-8351-5a6395311d7d",
 CellID->332830525],
Cell[3341, 107, 520, 16, 32, "DisplayFormulaNumbered",ExpressionUUID->"ba7dcf3d-f26d-4708-9479-65d3c24aca28",
 CellID->228605019],
Cell[3864, 125, 113, 1, 36, "Text",ExpressionUUID->"1ad71db2-247d-4fe1-969b-04e5ddc05edc",
 CellID->736564973],
Cell[3980, 128, 658, 21, 32, "DisplayFormulaNumbered",ExpressionUUID->"880b7c16-e563-48fd-b17f-996af8018380",
 CellID->533759894],
Cell[4641, 151, 162, 3, 36, "Text",ExpressionUUID->"3c42c9f4-d51e-48dd-9e4e-faaa0d5bedce",
 CellID->286783599],
Cell[4806, 156, 130, 1, 36, "Text",ExpressionUUID->"4387dce1-817b-4e88-a787-fa059bea4f70",
 CellID->57583490],
Cell[4939, 159, 1157, 37, 50, "DisplayFormulaNumbered",ExpressionUUID->"4746f7c5-a6c4-4b49-88c3-38f2e4a8cedb",
 CellID->34575577],
Cell[6099, 198, 105, 1, 36, "Text",ExpressionUUID->"222f4216-5ca0-41f4-9c74-71eb61218239",
 CellID->107431084],
Cell[6207, 201, 542, 18, 48, "DisplayFormulaNumbered",ExpressionUUID->"bf20ac0d-4493-4789-8ed9-000dcda28004",
 CellID->2111535],
Cell[6752, 221, 186, 8, 71, "SolvedExample",ExpressionUUID->"65ce4b68-10c6-4f03-8d56-b4ac80d96821",
 CellID->18183295],
Cell[6941, 231, 332, 10, 39, "SolvedExampleNote",ExpressionUUID->"21d2abdd-a4d8-4d0a-968d-14bc53bff5d4",
 CellID->118380504],
Cell[7276, 243, 199, 5, 25, "SolvedExampleInput",ExpressionUUID->"f40f2210-5cf9-43e0-a0a7-283a72708f4a",
 CellID->201022375],
Cell[7478, 250, 332, 10, 39, "SolvedExampleNote",ExpressionUUID->"7bea9135-0045-4a5a-baae-7e35499c6ecf",
 CellID->43555989],
Cell[7813, 262, 199, 5, 25, "SolvedExampleInput",ExpressionUUID->"979cd32a-e604-4483-b492-c1888fc7d37f",
 CellID->279448694],
Cell[8015, 269, 288, 8, 39, "SolvedExampleNote",ExpressionUUID->"c2a19b79-4608-4dd7-8e7e-04cd70588826",
 CellID->89710708],
Cell[CellGroupData[{
Cell[8328, 281, 136, 2, 25, "SolvedExampleInput",ExpressionUUID->"e45bf49c-920b-4d0a-9271-5bc6baf100b3",
 CellID->67178792],
Cell[8467, 285, 168, 3, 36, "SolvedExampleOutput",ExpressionUUID->"059f84ff-7399-402b-a27b-051b17b5aad9",
 CellID->349030951]
}, Open  ]],
Cell[8650, 291, 288, 8, 39, "SolvedExampleNote",ExpressionUUID->"89afcc87-d1e1-4e33-bdd2-a5b49cdb7f34",
 CellID->329023157],
Cell[CellGroupData[{
Cell[8963, 303, 138, 2, 25, "SolvedExampleInput",ExpressionUUID->"4f69f5ad-2986-4b3f-a6c0-d62c031d73aa",
 CellID->1015213509],
Cell[9104, 307, 192, 4, 36, "SolvedExampleOutput",ExpressionUUID->"b1c7a5c0-bd1a-4bd7-a3c7-697f871edfbc",
 CellID->24312619]
}, Open  ]],
Cell[9311, 314, 278, 8, 39, "SolvedExampleNote",ExpressionUUID->"1f8c76b0-dcc9-45f1-b9d8-7a3ffdca9ee2",
 CellID->541062707],
Cell[CellGroupData[{
Cell[9614, 326, 137, 2, 25, "SolvedExampleInput",ExpressionUUID->"31c91ed7-c095-4080-93ba-9a0a3198d15f",
 CellID->216360819],
Cell[9754, 330, 217, 5, 54, "SolvedExampleOutput",ExpressionUUID->"96c950f5-64c7-42d3-8a51-5f16b85175f3",
 CellID->68855592]
}, Open  ]],
Cell[9986, 338, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"d58b28ea-bfc5-4c20-974b-c954f4c33e6a",
 CellID->943814759]
}, Open  ]],
Cell[CellGroupData[{
Cell[10129, 344, 124, 1, 56, "Subsection",ExpressionUUID->"ae70e93e-1258-441f-b3a1-ce2808504e15",
 CellID->103794871],
Cell[10256, 347, 414, 13, 36, "Text",ExpressionUUID->"37de5071-8836-4b0a-8bee-48fd5829ff20",
 CellID->215538370],
Cell[10673, 362, 387, 12, 32, "DisplayFormulaNumbered",ExpressionUUID->"2e24b501-e5bd-4f1f-a23f-fc3720569121",
 CellID->985618216],
Cell[11063, 376, 239, 9, 36, "Text",ExpressionUUID->"0630fc6a-234e-4a56-95f8-4b770d668e57",
 CellID->55158655],
Cell[11305, 387, 441, 14, 35, "DisplayFormulaNumbered",ExpressionUUID->"a8dcc433-ba72-4489-9098-a4e200e63e10",
 CellID->257296754],
Cell[11749, 403, 667, 18, 36, "Text",ExpressionUUID->"b6359712-0df7-490a-90df-bf0a17d45b2f",
 CellID->79059132],
Cell[12419, 423, 187, 8, 71, "SolvedExample",ExpressionUUID->"c1755cb3-d977-4531-b871-4a923e39453d",
 CellID->523904063],
Cell[12609, 433, 955, 30, 40, "SolvedExampleNote",ExpressionUUID->"b193e710-6385-4da8-8af9-f13755a60f9d",
 CellID->164893261],
Cell[13567, 465, 199, 5, 25, "SolvedExampleInput",ExpressionUUID->"ffca8380-0f09-41fe-a4b4-d118c39acce6",
 CellID->194952655],
Cell[13769, 472, 196, 6, 39, "SolvedExampleNote",ExpressionUUID->"71fae7da-89ac-4156-a5e5-081aa1a648eb",
 CellID->8158935],
Cell[CellGroupData[{
Cell[13990, 482, 144, 2, 25, "SolvedExampleInput",ExpressionUUID->"3ed7a7ee-9de8-4d86-8e4b-955ca74c4acc",
 CellID->461037366],
Cell[14137, 486, 128, 2, 40, "SolvedExampleOutput",ExpressionUUID->"822539e0-d461-4e94-b8c1-9be05b359db1",
 CellID->153821439]
}, Open  ]],
Cell[14280, 491, 199, 6, 39, "SolvedExampleNote",ExpressionUUID->"15cd247e-bfcb-4162-9281-0e4b82d82e40",
 CellID->126846233],
Cell[CellGroupData[{
Cell[14504, 501, 149, 2, 25, "SolvedExampleInput",ExpressionUUID->"aa448a92-cd55-494e-ae9d-71d7a0d7959e",
 CellID->37278318],
Cell[14656, 505, 172, 3, 36, "SolvedExampleOutput",ExpressionUUID->"a21100d1-1e4e-4ebf-ad34-f2b2db25a06c",
 CellID->51865263]
}, Open  ]],
Cell[14843, 511, 146, 2, 25, "SolvedExampleInput",ExpressionUUID->"4a3139cc-360c-4121-ac5c-380e36c61f4e",
 CellID->189837019],
Cell[14992, 515, 105, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"52482867-0f0a-4349-9779-a97c9fe63657",
 CellID->87939568],
Cell[15100, 518, 137, 1, 36, "Text",ExpressionUUID->"4911d8cf-be2f-4051-aa76-f35a1fe09e15",
 CellID->201668742],
Cell[15240, 521, 448, 10, 32, "DisplayFormulaNumbered",ExpressionUUID->"3156bda0-55d2-417a-b9e7-9a0472950895",
 CellID->261117951]
}, Open  ]],
Cell[CellGroupData[{
Cell[15725, 536, 114, 1, 56, "Subsection",ExpressionUUID->"98f5c3e5-f51c-4678-b50e-6471838e24db",
 CellID->181787970],
Cell[15842, 539, 802, 22, 60, "Text",ExpressionUUID->"a013276a-36d7-4267-ac55-4d699d0bb766",
 CellID->76780899],
Cell[CellGroupData[{
Cell[16669, 565, 2941, 73, 28, "Input",ExpressionUUID->"048e50b1-ca0e-4160-a5bd-43c4b3aef000",
 CellID->416109330],
Cell[19613, 640, 16386, 367, 213, "Output",ExpressionUUID->"181478a5-891b-44ae-a670-0bb5832551be",
 CellID->1797131840]
}, Open  ]],
Cell[36014, 1010, 202, 4, 36, "Text",ExpressionUUID->"a81caa27-53b8-43f9-88f1-0af9c16e1625",
 CellID->461744709],
Cell[CellGroupData[{
Cell[36241, 1018, 3580, 96, 28, "Input",ExpressionUUID->"9089eb3c-75a7-4496-b4f7-29324510621b",
 CellID->18195684],
Cell[39824, 1116, 4272, 122, 219, "Output",ExpressionUUID->"856a2b25-b9a6-4252-84a9-cb834f8c393d",
 CellID->981627308]
}, Open  ]],
Cell[44111, 1241, 173, 3, 36, "Text",ExpressionUUID->"f16a89a5-9bb9-4c04-b088-7704ee2a8f96",
 CellID->288076210],
Cell[CellGroupData[{
Cell[44309, 1248, 2999, 81, 28, "Input",ExpressionUUID->"e5e4e949-4850-4644-a8ba-d7d4ef15554e",
 CellID->129743103],
Cell[47311, 1331, 3403, 99, 250, "Output",ExpressionUUID->"9a704609-9ef5-4908-b687-7baa9a4605a6",
 CellID->2107756236]
}, Open  ]],
Cell[50729, 1433, 262, 9, 36, "Text",ExpressionUUID->"74820525-729c-4cc8-adb1-960a590e843b",
 CellID->8580665],
Cell[50994, 1444, 187, 8, 71, "SolvedExample",ExpressionUUID->"08e4bec8-577a-49a8-83b1-9a6e78c70d32",
 CellID->735285701],
Cell[51184, 1454, 410, 11, 39, "SolvedExampleNote",ExpressionUUID->"e6312ae3-b148-4cfe-80d5-52e9ec7b2822",
 CellID->718422940],
Cell[51597, 1467, 214, 6, 39, "SolvedExampleNote",ExpressionUUID->"b36dee11-2ac3-4df1-a8d8-b6d09a0d982a",
 CellID->378083274],
Cell[CellGroupData[{
Cell[51836, 1477, 503, 14, 25, "SolvedExampleInput",ExpressionUUID->"3650a665-c793-47eb-857c-72c07ac834a0",
 CellID->186422184],
Cell[52342, 1493, 13645, 242, 140, "SolvedExampleOutput",ExpressionUUID->"e2f6e725-e633-4257-bec4-7fbd2149f916",
 CellID->317139261]
}, Open  ]],
Cell[66002, 1738, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"69b8f3c0-8496-414e-9f57-01644eeea08a",
 CellID->1468523437]
}, Open  ]],
Cell[CellGroupData[{
Cell[66146, 1744, 128, 1, 56, "Subsection",ExpressionUUID->"52c58345-b4b6-40cb-ad17-a64e86a78a0c",
 CellID->82603245],
Cell[66277, 1747, 250, 6, 36, "Text",ExpressionUUID->"f891441a-13d8-4a79-b1a5-12bc0ca8cefe",
 CellID->253731669],
Cell[CellGroupData[{
Cell[66552, 1757, 9350, 231, 70, "Input",ExpressionUUID->"429163d6-fb55-4dd8-8e16-f1dc46f0639c",
 CellID->283162786],
Cell[75905, 1990, 5496, 117, 366, "Output",ExpressionUUID->"8607584f-cd0a-42ca-b72c-c308ee0a5670",
 CellID->834591595]
}, {2}]],
Cell[81413, 2110, 145, 1, 36, "Text",ExpressionUUID->"6064bb9a-b9b1-4b40-a8eb-2e5126096524",
 CellID->22971535],
Cell[CellGroupData[{
Cell[81583, 2115, 178, 3, 30, "ItemNumbered",ExpressionUUID->"7b24dc54-c786-4dc2-99e9-38ac878cf755",
 CellID->70640122],
Cell[81764, 2120, 231, 6, 30, "ItemNumbered",ExpressionUUID->"9d9f4da1-d825-4ed8-8036-de6294e805be",
 CellID->116090482],
Cell[81998, 2128, 603, 16, 50, "ItemNumbered",ExpressionUUID->"50df35e7-fb19-4251-b599-390611489386",
 CellID->241716959],
Cell[82604, 2146, 693, 20, 50, "ItemNumbered",ExpressionUUID->"c5b2dda3-26eb-443c-abd2-78735bef0ee2",
 CellID->106131012]
}, Open  ]],
Cell[83312, 2169, 391, 8, 60, "Text",ExpressionUUID->"1cbb7c31-1f7c-4dcf-b5ed-e30a7a6f5559",
 CellID->265154475],
Cell[83706, 2179, 386, 11, 36, "Text",ExpressionUUID->"48f84580-9fa9-4c66-8130-ca5805c15c52",
 CellID->64411386],
Cell[84095, 2192, 925, 28, 52, "DisplayFormulaNumbered",ExpressionUUID->"77accd7c-a85c-41c5-af8b-56ba6c1c73e5",
 CellID->31223680],
Cell[85023, 2222, 158, 3, 36, "Text",ExpressionUUID->"f4c795e1-b22e-45b7-a658-5e50b6ebe172",
 CellID->9748798],
Cell[CellGroupData[{
Cell[85206, 2229, 14838, 370, 70, "Input",ExpressionUUID->"25947bd1-2517-4598-9c80-fbafe1ad88e6",
 CellID->439672978],
Cell[100047, 2601, 118936, 2007, 320, "Output",ExpressionUUID->"6aa2daa0-4f36-46bc-aac8-bdb76ab9e10c",
 CellID->201271285]
}, {2}]],
Cell[218995, 4611, 3667, 116, 150, "Text",ExpressionUUID->"83400dd7-d46e-4233-a453-d35132b868dc",
 CellID->476668675],
Cell[222665, 4729, 186, 8, 71, "SolvedExample",ExpressionUUID->"d0ca298a-13f0-44fe-9773-df746777b185",
 CellID->95002828],
Cell[222854, 4739, 428, 9, 61, "SolvedExampleNote",ExpressionUUID->"96b83501-d2df-46c8-843b-abd9a5749f14",
 CellID->239009425],
Cell[223285, 4750, 138, 1, 39, "SolvedExampleNote",ExpressionUUID->"3de04fea-3ba4-4eac-a707-218ed4910da9",
 CellID->4366196],
Cell[223426, 4753, 977, 31, 54, "SolvedExampleInput",ExpressionUUID->"263b756a-70a1-4d85-aae4-b807accb1631",
 CellID->169533157],
Cell[224406, 4786, 325, 9, 39, "SolvedExampleNote",ExpressionUUID->"8f3ead76-e8b8-484d-9e05-85fff5ceab07",
 CellID->1431672],
Cell[CellGroupData[{
Cell[224756, 4799, 165, 3, 25, "SolvedExampleInput",ExpressionUUID->"9c01c6d8-33c0-4a9a-8bb7-aac852a8851f",
 CellID->215975845],
Cell[224924, 4804, 237, 6, 54, "SolvedExampleOutput",ExpressionUUID->"ad111c25-f611-4821-8d99-7f3ac5e2c1da",
 CellID->170998073]
}, Open  ]],
Cell[225176, 4813, 340, 9, 39, "SolvedExampleNote",ExpressionUUID->"f0c30817-8e77-4ff3-9f4e-63657089cc86",
 CellID->79316562],
Cell[225519, 4824, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"34affdbb-285c-4d79-a381-96346cababfc",
 CellID->1442079354]
}, Open  ]],
Cell[CellGroupData[{
Cell[225663, 4830, 138, 1, 56, "Subsection",ExpressionUUID->"6e751639-19cf-47e5-9cb9-f7e95ad16f67",
 CellID->65702220],
Cell[225804, 4833, 163, 3, 36, "Text",ExpressionUUID->"b854e51a-b1d9-45fe-9908-2963beedae46",
 CellID->190068978],
Cell[CellGroupData[{
Cell[225992, 4840, 287, 5, 50, "Item",ExpressionUUID->"06c16331-ac0a-4e84-a014-5112254c7ce2",
 CellID->72258445],
Cell[226282, 4847, 189, 4, 30, "Item",ExpressionUUID->"4bc574ba-f0cd-4097-8f31-3c566184fc17",
 CellID->265359487],
Cell[226474, 4853, 207, 6, 30, "Item",ExpressionUUID->"c76e1d0b-b266-4445-9251-62e052cc13cf",
 CellID->23524305]
}, Open  ]],
Cell[226696, 4862, 382, 6, 83, "Text",ExpressionUUID->"8f134571-d2f7-4183-86ec-74be1bb8a46d",
 CellID->699960867],
Cell[CellGroupData[{
Cell[227103, 4872, 38954, 934, 2133, "Input",ExpressionUUID->"5cfd54dc-5872-416c-aad5-1fece4b5263d",
 CellID->709520648],
Cell[266060, 5808, 138120, 2355, 551, "Output",ExpressionUUID->"7aaf9f37-9f89-4107-8d59-f684807aa481",
 CellID->2059008599]
}, {2}]],
Cell[404192, 8166, 182, 4, 36, "Text",ExpressionUUID->"5ac8dfac-ddc3-4d90-96c0-d660b82696b4",
 CellID->435992548],
Cell[CellGroupData[{
Cell[404399, 8174, 27565, 650, 70, "Input",ExpressionUUID->"8ebb05c7-2c48-4979-bd4c-d5929c5f41b4",
 CellID->90227679],
Cell[431967, 8826, 134805, 2306, 424, "Output",ExpressionUUID->"ce277278-1baa-45f1-9478-f0f222a5225a",
 CellID->1557970]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[566818, 11138, 127, 1, 56, "Subsection",ExpressionUUID->"a2d44f76-a414-44e0-b03b-8b883a58b701",
 CellID->362782468],
Cell[566948, 11141, 492, 12, 60, "Text",ExpressionUUID->"223ce9d8-d024-44c2-8c85-e600a7ecc2db",
 CellID->651542753],
Cell[CellGroupData[{
Cell[567465, 11157, 17606, 483, 70, "Input",ExpressionUUID->"37241427-67d2-49ae-94e3-60f7c2d74fac",
 CellID->127122028],
Cell[585074, 11642, 6928, 202, 212, "Output",ExpressionUUID->"a84ecbf8-b68e-4604-8cbe-96c8aa53ce4f",
 CellID->649300219]
}, {2}]],
Cell[592014, 11847, 540, 16, 36, "Text",ExpressionUUID->"7e20c0b8-62ab-4652-8853-3406fc774ee0",
 CellID->30638155],
Cell[592557, 11865, 730, 18, 49, "DisplayFormulaNumbered",ExpressionUUID->"af97775d-00d9-4aa1-bfff-2f268a04227b",
 CellID->5952995],
Cell[593290, 11885, 111, 1, 36, "Text",ExpressionUUID->"3380fe69-9b51-4516-9350-609c1f927bbf",
 CellID->750003249],
Cell[593404, 11888, 766, 19, 54, "DisplayFormulaNumbered",ExpressionUUID->"9651a16f-7a4e-4513-a9cd-d7a60dfbb661",
 CellID->848081270],
Cell[594173, 11909, 473, 13, 60, "Text",ExpressionUUID->"4e6d0388-68b6-4bf5-b128-1362a4351c7d",
 CellID->131896293],
Cell[594649, 11924, 253, 6, 32, "DisplayFormulaNumbered",ExpressionUUID->"d84973e1-547f-4928-8e53-5f10d710eba4",
 CellID->140796883],
Cell[594905, 11932, 187, 8, 71, "SolvedExample",ExpressionUUID->"7dd6b620-87d3-4eaf-8920-908121453753",
 CellID->360137030],
Cell[595095, 11942, 399, 12, 39, "SolvedExampleNote",ExpressionUUID->"0e3d3684-5364-44fb-8386-2dc0626dee79",
 CellID->58742649],
Cell[CellGroupData[{
Cell[595519, 11958, 198, 4, 25, "SolvedExampleInput",ExpressionUUID->"fec03f01-be42-4786-a015-b067ddaeb7d1",
 CellID->122030470],
Cell[595720, 11964, 182, 4, 54, "SolvedExampleOutput",ExpressionUUID->"161afbbe-8553-488f-a60e-39f3d5582611",
 CellID->370580158]
}, Open  ]],
Cell[595917, 11971, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"b314c0be-de85-4f63-84d4-20a0df5a5c91",
 CellID->135786757],
Cell[596026, 11974, 300, 7, 36, "Text",ExpressionUUID->"62a79678-afae-4eea-879a-9083f62feb63",
 CellID->71023858],
Cell[596329, 11983, 497, 13, 32, "DisplayFormulaNumbered",ExpressionUUID->"95cd6e0c-b227-4962-84a6-335e76d4d3df",
 CellID->494138068],
Cell[596829, 11998, 613, 17, 36, "Text",ExpressionUUID->"72e3e18a-cc2f-4bf3-9a77-8f00303861a8",
 CellID->149722283],
Cell[597445, 12017, 474, 12, 32, "DisplayFormulaNumbered",ExpressionUUID->"89db7f64-ec26-473c-a54d-bc1c5187cdff",
 CellID->655590036],
Cell[597922, 12031, 967, 28, 63, "Text",ExpressionUUID->"13cec5b7-f2ee-4446-bf24-53f7e79077f8",
 CellID->1632977391],
Cell[598892, 12061, 361, 10, 36, "Text",ExpressionUUID->"3e7b7f54-4f65-48da-834a-7c57cce81515",
 CellID->317596935],
Cell[599256, 12073, 357, 9, 36, "Text",ExpressionUUID->"51bd6474-32bd-44bd-846e-762ba57e6a90",
 CellID->117088449]
}, Open  ]],
Cell[CellGroupData[{
Cell[599650, 12087, 131, 1, 56, "Subsection",ExpressionUUID->"4ef52d8c-f09e-4936-b7ec-629f17c7fa22",
 CellID->31345884],
Cell[599784, 12090, 1013, 29, 60, "Text",ExpressionUUID->"00164d9e-9576-42d2-b75f-c6a1f0070a4d",
 CellID->29972869],
Cell[600800, 12121, 1893, 47, 49, "DisplayFormulaNumbered",ExpressionUUID->"96e5c1d5-c6bd-4652-a698-cdecdaabac73",
 CellID->82756032],
Cell[602696, 12170, 139, 1, 36, "Text",ExpressionUUID->"35f56a9a-8f46-4bd5-8f52-80ed22feac28",
 CellID->890840350],
Cell[602838, 12173, 670, 21, 32, "DisplayFormulaNumbered",ExpressionUUID->"fa3cc5de-fc8d-4a00-8e93-f9ab96a2df83",
 CellID->17545120],
Cell[603511, 12196, 143, 1, 36, "Text",ExpressionUUID->"20c7b148-9588-47b8-a24e-eb646fde1b46",
 CellID->272359751],
Cell[CellGroupData[{
Cell[603679, 12201, 120, 1, 30, "ItemNumbered",ExpressionUUID->"590deb0c-b898-4cf7-a7e4-556b81398d11",
 CellID->497122929],
Cell[603802, 12204, 115, 1, 30, "ItemNumbered",ExpressionUUID->"05771cc4-bb91-40b2-a5c8-cef9eff6b781",
 CellID->206996843]
}, Open  ]],
Cell[603932, 12208, 127, 1, 36, "Text",ExpressionUUID->"7599c8e4-4f81-4867-942c-836d4407c900",
 CellID->485540229],
Cell[CellGroupData[{
Cell[604084, 12213, 10609, 295, 70, "Input",ExpressionUUID->"060cccfe-78f3-4da4-a825-6af241f3cbf5",
 CellID->729716677],
Cell[614696, 12510, 6057, 179, 256, "Output",ExpressionUUID->"71686989-bad7-49a2-9b31-03f023ef6b8b",
 CellID->308745568]
}, {2}]],
Cell[620765, 12692, 513, 14, 60, "Text",ExpressionUUID->"0cf0c35f-7838-4c5d-a5e1-faf5beec2833",
 CellID->2213072],
Cell[CellGroupData[{
Cell[621303, 12710, 6247, 169, 70, "Input",ExpressionUUID->"8b622cdd-996c-42cb-aaa0-752659969080",
 CellID->886641],
Cell[627553, 12881, 4891, 109, 496, "Output",ExpressionUUID->"57065148-2836-4eef-bd93-fc7e7f4b44e7",
 CellID->231613509]
}, {2}]],
Cell[632456, 12993, 187, 8, 71, "SolvedExample",ExpressionUUID->"2b27e3f6-4e2d-4558-bf42-a5d8da71a687",
 CellID->461890220],
Cell[632646, 13003, 730, 22, 67, "SolvedExampleNote",ExpressionUUID->"107091e0-46f1-4585-889f-a70191c353ff",
 CellID->445189052],
Cell[633379, 13027, 393, 10, 39, "SolvedExampleNote",ExpressionUUID->"c75fe5b5-2077-4128-8e95-40e1b12f8796",
 CellID->291232106],
Cell[CellGroupData[{
Cell[633797, 13041, 404, 13, 55, "SolvedExampleInput",ExpressionUUID->"bde693cd-f578-41cd-b13a-ff79add4ec19",
 CellID->430318055],
Cell[634204, 13056, 370, 12, 65, "SolvedExampleOutput",ExpressionUUID->"8fd65e6c-0357-4ecb-b625-528cc4891159",
 CellID->131238665]
}, Open  ]],
Cell[634589, 13071, 146, 1, 39, "SolvedExampleNote",ExpressionUUID->"ceb53646-d494-47dc-b5b2-6fb651ba6771",
 CellID->52808477],
Cell[CellGroupData[{
Cell[634760, 13076, 4120, 114, 70, "SolvedExampleInput",ExpressionUUID->"8eb991cd-2385-4c54-8f80-8a1afe65b4ba",
 CellID->309463259],
Cell[638883, 13192, 3351, 92, 203, "SolvedExampleOutput",ExpressionUUID->"5e1a61f7-ebf6-4968-bc1f-30acb7053c26",
 CellID->9935300]
}, {2}]],
Cell[642246, 13287, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"75c716a8-f8e5-47e5-bddc-2cc0cb667c47",
 CellID->1247431371]
}, Open  ]],
Cell[CellGroupData[{
Cell[642390, 13293, 147, 1, 56, "Subsection",ExpressionUUID->"1c6dbdef-1d18-4fa9-99d2-aede7411de22",
 CellID->144078613],
Cell[642540, 13296, 261, 5, 60, "Text",ExpressionUUID->"4e61531d-ee75-47df-bf76-02b8c7457f30",
 CellID->83369900],
Cell[642804, 13303, 347, 10, 32, "DisplayFormulaNumbered",ExpressionUUID->"84f98a84-13db-4670-ab6a-4edf4f4acfcb",
 CellID->594323451],
Cell[643154, 13315, 538, 15, 32, "DisplayFormulaNumbered",ExpressionUUID->"84a023ff-1bb4-490e-8bf0-72ec3a2df21e",
 CellID->68456054],
Cell[643695, 13332, 730, 20, 60, "Text",ExpressionUUID->"466c41d3-4aef-413f-ad23-63fd48bbd779",
 CellID->4225793],
Cell[644428, 13354, 674, 18, 32, "DisplayFormulaNumbered",ExpressionUUID->"0c3cfd98-8aef-43b1-9628-38c6b654340e",
 CellID->765991003],
Cell[645105, 13374, 268, 5, 60, "Text",ExpressionUUID->"54a91e17-204e-4019-85bc-dba34f7041ae",
 CellID->58469325],
Cell[645376, 13381, 592, 17, 49, "DisplayFormulaNumbered",ExpressionUUID->"5a6bb78f-acd9-4f39-8a3e-4453d65d42ad",
 CellID->680898780],
Cell[645971, 13400, 164, 3, 36, "Text",ExpressionUUID->"2b6f3f0e-b3c5-4ddb-9443-075c83df61c2",
 CellID->210750232],
Cell[646138, 13405, 562, 18, 49, "DisplayFormulaNumbered",ExpressionUUID->"da910f25-b89a-47b5-ac6e-02c2e4cd8f8c",
 CellID->216913362],
Cell[646703, 13425, 117, 1, 36, "Text",ExpressionUUID->"075fd92c-2afb-4a09-b2ff-ea09fb5a729a",
 CellID->37997941],
Cell[646823, 13428, 187, 8, 71, "SolvedExample",ExpressionUUID->"7995a2a0-ea00-441e-9a59-cb00b5e8650f",
 CellID->566649395],
Cell[647013, 13438, 690, 19, 39, "SolvedExampleNote",ExpressionUUID->"81633e00-a22e-4fb2-a191-1f69cd192587",
 CellID->3349350],
Cell[647706, 13459, 216, 6, 39, "SolvedExampleNote",ExpressionUUID->"c415bda6-ee74-4aae-ba34-2337a6c13305",
 CellID->131767473],
Cell[CellGroupData[{
Cell[647947, 13469, 205, 4, 25, "SolvedExampleInput",ExpressionUUID->"7245f9d3-a505-47b4-943b-e488d82b4f66",
 CellID->5983359],
Cell[648155, 13475, 507, 13, 38, "SolvedExampleOutput",ExpressionUUID->"76820232-410a-4678-8ee8-30165a911220",
 CellID->697182903]
}, Open  ]],
Cell[648677, 13491, 464, 14, 39, "SolvedExampleNote",ExpressionUUID->"8686d9fd-8fe9-4d39-9a88-97b079d6e393",
 CellID->53721767],
Cell[649144, 13507, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"1f1d16a4-1264-4f04-8eda-52501cb53e15",
 CellID->184408212],
Cell[CellGroupData[{
Cell[649275, 13512, 109, 1, 69, "SummarySection",ExpressionUUID->"4c170747-0250-4152-a6ab-fe715e0644ca",
 CellID->1198545324],
Cell[649387, 13515, 452, 13, 29, "SummaryList",ExpressionUUID->"8e4707f1-1f51-45c6-a029-e42c2baea4bd",
 CellID->53631661],
Cell[649842, 13530, 248, 4, 29, "SummaryList",ExpressionUUID->"cec8cbff-ab53-44f0-bf34-a74262728071",
 CellID->559205556],
Cell[650093, 13536, 210, 4, 29, "SummaryList",ExpressionUUID->"b415d2b2-6f8e-4878-b3c8-39fffab1e9d6",
 CellID->150843637],
Cell[650306, 13542, 167, 3, 29, "SummaryList",ExpressionUUID->"9db64332-ba1c-4233-b6a6-9f2318d3c4de",
 CellID->211485454],
Cell[650476, 13547, 154, 1, 29, "SummaryList",ExpressionUUID->"e864c257-d9b0-438b-a451-d6f881eb8ed4",
 CellID->230820584]
}, Open  ]],
Cell[CellGroupData[{
Cell[650667, 13553, 159, 3, 65, "ExerciseSection",ExpressionUUID->"22726d80-5832-45de-9a07-d361ac80a8cf",
 CellID->55659708],
Cell[650829, 13558, 1501, 49, 70, "Exercise",ExpressionUUID->"d4b8e5c1-eec6-4497-bbc1-125dd2f8cb41",
 CellID->23457965],
Cell[CellGroupData[{
Cell[652355, 13611, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"76afd991-f23e-46e5-8007-e6df2293539f"],
Cell[652449, 13613, 120, 1, 22, "SolutionAnswer",ExpressionUUID->"961f7baa-453c-4d54-a1d8-367b38c30689",
 CellID->40353190],
Cell[652572, 13616, 226, 6, 25, "ExerciseInput",ExpressionUUID->"eeac5768-f960-4596-b454-0aaccaa00ecc",
 CellID->404368529],
Cell[652801, 13624, 105, 1, 22, "SolutionAnswer",ExpressionUUID->"9bf7a078-db2e-48bc-bfcc-ab7723d73448",
 CellID->101356644],
Cell[652909, 13627, 220, 6, 25, "ExerciseInput",ExpressionUUID->"d8a01e83-fab1-4b71-ab31-d32f4773c10f",
 CellID->158750617],
Cell[653132, 13635, 133, 1, 22, "SolutionAnswer",ExpressionUUID->"4c537b37-b5dd-46a8-9f62-97c6e3f38074",
 CellID->20232599],
Cell[CellGroupData[{
Cell[653290, 13640, 277, 7, 25, "ExerciseInput",ExpressionUUID->"f4a13723-f406-49ad-811b-f706d6846de9",
 CellID->73651777],
Cell[653570, 13649, 277, 7, 44, "ExerciseOutput",ExpressionUUID->"1e320e47-3498-45c4-8dab-ef35435fc1a6",
 CellID->452573011]
}, Closed]],
Cell[653862, 13659, 144, 1, 22, "SolutionAnswer",ExpressionUUID->"d51dff39-5b64-434b-a29b-856189c7b25d",
 CellID->334598242],
Cell[CellGroupData[{
Cell[654031, 13664, 3153, 90, 251, "ExerciseInput",ExpressionUUID->"d7ccdd2c-9f4f-48a5-b854-7a32acd72c55",
 CellID->45232392],
Cell[657187, 13756, 10366, 247, 341, "ExerciseOutput",ExpressionUUID->"25dd5833-3c0f-46eb-ab0d-2e055b2d94ec",
 CellID->674059245]
}, {2}]]
}, Closed]],
Cell[667577, 14007, 1823, 54, 44, "Exercise",ExpressionUUID->"3cf54ea5-9a0f-482d-b5bf-59636d94cb74",
 CellID->679048616],
Cell[CellGroupData[{
Cell[669425, 14065, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"9ea0d8cd-6ffa-46ff-ad88-5a359581e02c"],
Cell[669519, 14067, 121, 1, 22, "SolutionAnswer",ExpressionUUID->"1f38f9aa-d065-4d5a-8401-aa83e187fddd",
 CellID->214256153],
Cell[669643, 14070, 200, 5, 25, "ExerciseInput",ExpressionUUID->"f5d7d81f-d4a7-4fb7-9d3f-485cac18807b",
 CellID->171717086],
Cell[669846, 14077, 104, 1, 22, "SolutionAnswer",ExpressionUUID->"f5e2e4df-0c7b-40e1-92fe-c9867004c5f4",
 CellID->94036905],
Cell[669953, 14080, 195, 5, 25, "ExerciseInput",ExpressionUUID->"0e01cc44-5b41-4d2d-b3b0-362d10029316",
 CellID->716277303],
Cell[670151, 14087, 199, 6, 22, "SolutionAnswer",ExpressionUUID->"3710b348-ea1b-47b2-b3ce-6f9da4c8d07e",
 CellID->335281113],
Cell[CellGroupData[{
Cell[670375, 14097, 220, 5, 25, "ExerciseInput",ExpressionUUID->"ab4c5186-8802-41d9-a666-8dc1ba13b9cf",
 CellID->86472837],
Cell[670598, 14104, 207, 6, 36, "ExerciseOutput",ExpressionUUID->"94d78d8b-55a4-4a5e-8d0f-f5862b82a5ce",
 CellID->105241969]
}, Open  ]],
Cell[670820, 14113, 113, 1, 22, "SolutionAnswer",ExpressionUUID->"0f0b7312-315c-4acb-9b5a-0d9791e0f9c4",
 CellID->164474994],
Cell[CellGroupData[{
Cell[670958, 14118, 196, 6, 31, "ExerciseInput",ExpressionUUID->"05b2b866-02be-487c-8405-b9aebe666347",
 CellID->321265987],
Cell[671157, 14126, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"7267e7d2-2ed4-47b9-af9c-4527124bba72",
 CellID->798873384]
}, Open  ]]
}, Closed]],
Cell[671298, 14131, 620, 18, 29, "Exercise",ExpressionUUID->"49bc1f84-dca4-4266-96fc-926b1743707b",
 CellID->339192516],
Cell[CellGroupData[{
Cell[671943, 14153, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"5e333403-1979-454e-89f7-61929e9707fb"],
Cell[672037, 14155, 199, 6, 22, "SolutionAnswer",ExpressionUUID->"5e8634c1-4a9e-4fee-ba4d-f196b28acf17",
 CellID->44173170],
Cell[CellGroupData[{
Cell[672261, 14165, 437, 14, 25, "ExerciseInput",ExpressionUUID->"c82b95d1-e487-4b6d-99fe-0e091aac933c",
 CellID->7663821],
Cell[672701, 14181, 252, 8, 50, "ExerciseOutput",ExpressionUUID->"81dde9f0-e589-41f3-b28a-0977d53b35c2",
 CellID->15663891]
}, Open  ]],
Cell[672968, 14192, 200, 6, 22, "SolutionAnswer",ExpressionUUID->"1ffbaa93-4453-40c1-bb2c-4d50f201a738",
 CellID->4279602],
Cell[CellGroupData[{
Cell[673193, 14202, 438, 14, 25, "ExerciseInput",ExpressionUUID->"9644c6b7-8f85-4733-a95c-54c90c1bc848",
 CellID->54761247],
Cell[673634, 14218, 425, 12, 45, "ExerciseOutput",ExpressionUUID->"aaddc518-9155-4748-8a1f-f8b66dda8dbc",
 CellID->759678298]
}, Open  ]]
}, Closed]],
Cell[674086, 14234, 605, 17, 25, "Exercise",ExpressionUUID->"8514894d-2796-48a1-8b8a-1dfb74cdc502",
 CellID->2131385],
Cell[CellGroupData[{
Cell[674716, 14255, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"cdac09dc-21b1-417d-a2d7-49f203a32b16"],
Cell[674810, 14257, 305, 7, 43, "SolutionAnswer",ExpressionUUID->"24046697-c917-4783-93e0-aa9cc6a18166",
 CellID->190003827],
Cell[CellGroupData[{
Cell[675140, 14268, 202, 4, 25, "ExerciseInput",ExpressionUUID->"c824e933-8bc9-42e6-88e9-5a0ff8844958",
 CellID->471818383],
Cell[675345, 14274, 501, 13, 30, "ExerciseOutput",ExpressionUUID->"d11df587-3728-4636-b4dd-400cfeaaa73c",
 CellID->49802779]
}, Open  ]]
}, Closed]],
Cell[675873, 14291, 1246, 38, 103, "Exercise",ExpressionUUID->"52a1c99b-edbd-466e-a97f-f6802c87f77a",
 CellID->267427999],
Cell[CellGroupData[{
Cell[677144, 14333, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"dbdaa5b3-2f87-49dc-ae7d-b73aeb31156b"],
Cell[677238, 14335, 212, 6, 22, "SolutionAnswer",ExpressionUUID->"21b5382f-dd7f-4eb1-97a3-771ebe5aa038",
 CellID->456759534],
Cell[CellGroupData[{
Cell[677475, 14345, 5706, 148, 112, "ExerciseInput",ExpressionUUID->"562235e5-48bd-44cf-a77d-3e6d7dfe28e7",
 CellID->726326818],
Cell[683184, 14495, 43583, 785, 133, "ExerciseOutput",ExpressionUUID->"e69dc5f8-0516-4474-9db6-34fbab7cb751",
 CellID->174461147]
}, Open  ]]
}, Closed]]
}, If[{3} === Open, Closed, Open]]]
}, Open  ]]
}, Open  ]],
Cell[726854, 15287, 310, 6, 135, "SmallText",ExpressionUUID->"10216d5d-c155-44a4-a867-da24a1d045d5",
 CellGroupingRules->"SectionGrouping",
 CellID->1895564419]
}
]
*)

(* NotebookSignature TTWUZWegxbVH@luYkmz9ZNK3 *)
