(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   3472556,      65756]
NotebookOptionsPosition[   3308418,      62320]
NotebookOutlinePosition[   3446734,      65269]
CellTagsIndexPosition[   3446691,      65266]
WindowTitle->4. The Exponential Function | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "The Exponential Function"
}], "Section",
 CounterAssignments->{{"Section", 3}},
 CellID->182295352,ExpressionUUID->"eb3005f0-5c69-4508-8aae-2d993af98435"],

Cell[CellGroupData[{

Cell["Overview", "Subsection",
 CellID->35712646,ExpressionUUID->"818410f2-6b2c-466a-a0fc-bee99d909220"],

Cell["\<\
In this chapter you will see how some very important elementary functions are \
generalized to complex arguments.\
\>", "Text",
 CellID->104330829,ExpressionUUID->"2b7311e1-d33a-4cee-a5ee-b9a6a9ab9812"],

Cell[TextData[{
 "You are certainly familiar with the exponential function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"08a5319d-82ae-461a-8ca3-99e2bca77116"],
 " and with the trigonometric functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"904db6f6-3c64-407f-b3ca-aa1199c72479"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d6770711-577b-4761-97e9-ada5db419db3"],
 " on the real line. Their plots are:"
}], "Text",
 CellID->560109729,ExpressionUUID->"b71decfb-1667-4563-a778-12414a4bf095"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["3", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["368", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[{$CellContext`x, -10, 10}, PlotLegends -> "Expressions", 
     AxesLabel -> {$CellContext`x, None}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "Input",
 CellID->121200899,ExpressionUUID->"b20bed92-3b04-49fb-89ff-9c2837558b3e"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwV1vc/1Y0fxvFjb9njEIejhIwUkvI+ZKSEEKXsclvJzi0rCS0jKqsSsjIy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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwte3k01d/3vpky34vM96IoopJKJec0IiqpkLeUMUNJylCGlKESFRkakKEk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            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJw1e3lUzc//f9o37cu9LdS9IlHSassMIhEiSqRos9S7kPZVkiQSyRaVKEWk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            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwV1vc/1Y0fxvFjb9njEIejhIwUkvI+ZKSEEKXsclvJzi0rCS0jKqsSsjIy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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwte3k01d/3vpky34vM96IoopJKJec0IiqpkLeUMUNJylCGlKESFRkakKEk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                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJw1e3lUzc//f9o37cu9LdS9IlHSassMIhEiSqRos9S7kPZVkiQSyRaVKEWk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                "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{-10, 10}, {-0.9999999784391316, 
               3.5645656194433473`}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             GoldenRatio^(-1), "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                RGBColor[0.560181, 0.691569, 0.194885], 
                AbsoluteThickness[2]], 
               Directive[
                Opacity[1.], 
                RGBColor[0.880722, 0.611041, 0.142051], 
                AbsoluteThickness[2]], 
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{-10, 10}, {-0.9999999784391316, 
              3.5645656194433473`}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            GoldenRatio^(-1), "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.560181, 0.691569, 0.194885], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[2]], 
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwV1vc/1Y0fxvFjb9njEIejhIwUkvI+ZKSEEKXsclvJzi0rCS0jKqsSsjIy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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwte3k01d/3vpky34vM96IoopJKJec0IiqpkLeUMUNJylCGlKESFRkakKEk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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJw1e3lUzc//f9o37cu9LdS9IlHSassMIhEiSqRos9S7kPZVkiQSyRaVKEWk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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, 
         "PlotRange" -> {{-10, 10}, {-0.9999999784391316, 
           3.5645656194433473`}}, "Frame" -> {{False, False}, {False, False}},
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
         "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
         GoldenRatio^(-1), "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.560181, 0.691569, 0.194885], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.880722, 0.611041, 0.142051], 
            AbsoluteThickness[2]], 
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
    Axes -> {True, True}, AxesLabel -> {
      FormBox[
       TagBox[
        TagBox["x", HoldForm], HoldForm], TraditionalForm], None}, 
    AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    Frame -> {{False, False}, {False, False}}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, 
    PlotRange -> {{-10, 10}, {-0.9999999784391316, 3.5645656194433473`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{
       RowBox[{"exp", "(", 
         TagBox["x", HoldForm], ")"}], 
       RowBox[{"sin", "(", 
         TagBox["x", HoldForm], ")"}], 
       RowBox[{"cos", "(", 
         TagBox["x", HoldForm], ")"}]}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[2]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 12.5}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{
               TagBox[#, HoldForm], ",", 
               TagBox[#2, HoldForm], ",", 
               TagBox[#3, HoldForm]}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellID->369105540,ExpressionUUID->"777f9676-22d5-464e-bcec-486ae3950dbe"]
}, {2}]],

Cell["\<\
The goal of this chapter is to generalize these functions for complex \
arguments. In doing so, you will learn about the surprising connection \
between the complex exponential function and the complex trigonometric \
functions.\
\>", "Text",
 CellID->671858908,ExpressionUUID->"35ec9a75-6bca-4a6d-934f-5ff6d9adcbcc"],

Cell[TextData[{
 "In real analysis, the exponential function and the trigonometric functions \
are completely different and unrelated functions. For example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ed7fb1b8-7ada-4a13-8132-8c33a1ecb61b"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7a77426c-4cb1-4ec1-af61-1ee48e29ca4e"],
 " are bounded and periodic, whereas ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a9d8dbef-47ae-4a48-a077-f0d98ed45e20"],
 " is unbounded and not periodic. But when complexified, the three complex \
functions are related to each other, and neither sine nor cosine is bounded \
in the complex plane."
}], "Text",
 CellID->72498932,ExpressionUUID->"e4073a13-cdcc-4589-8c91-be629a8f9b2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Complex Exponential Function", "Subsection",
 CellID->831329982,ExpressionUUID->"2d7d4139-1bf1-4060-ac18-a8e09da49448"],

Cell[CellGroupData[{

Cell["Definition", "Subsubsection",
 CellID->669617203,ExpressionUUID->"6c34ead6-07cf-4db6-bdfa-d22af8778ae5"],

Cell["\<\
There are several equivalent ways to define the exponential function:\
\>", "Text",
 CellID->15988802,ExpressionUUID->"a256baf2-eb32-4bdc-9f94-f6bd30324d94"],

Cell[CellGroupData[{

Cell[TextData[{
 "It is the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]],ExpressionUUID->
  "ad0f541b-c9f9-47ad-bed4-13a07c2f71fc"],
 " satisfying ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], "=", "f"}], TraditionalForm]],ExpressionUUID->
  "57a00b94-68ed-4bf1-8f52-c3c58a87b1d3"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "0", ")"}], "=", "1"}], TraditionalForm]],
  ExpressionUUID->"1104bb7e-0e80-4da4-a22e-bb6fc9e92bef"],
 "."
}], "ItemNumbered",
 CellID->50538286,ExpressionUUID->"3c8f9256-8bd2-42f6-9e25-a2731df7c81b"],

Cell[TextData[{
 "It is the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        FractionBox["z", "n"]}], ")"}], "n"]}]}], TraditionalForm]],
  ExpressionUUID->"412ae661-71d9-443d-a9f0-16afcdf56011"],
 "."
}], "ItemNumbered",
 CellID->313017787,ExpressionUUID->"a8d74504-041d-461a-82d3-f75a6666f32d"],

Cell["It is defined by the series", "ItemNumbered",
 CellID->569781085,ExpressionUUID->"24a9b8dc-b8b4-42e1-b1f9-d69c2f68710f"]
}, Open  ]],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], "=", " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    RowBox[{
     FractionBox[
      SuperscriptBox["z", "n"], 
      RowBox[{"n", "!"}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->243720558,ExpressionUUID->"c4f4c9ca-e66b-4522-9f7b-ac0f3a3e37f2"],

Cell["\<\
Because complex derivatives or limits will only be introduced later in the \
book, let\[CloseCurlyQuote]s focus on the third definition and postpone the \
discussion of the other definitions until later.\
\>", "Text",
 CellID->21383534,ExpressionUUID->"077f95cb-7974-495c-a6fd-a56546350126"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->77111790,ExpressionUUID->"032160bd-9972-47d4-8f73-3f5cb4e4027f"],

Cell[TextData[{
 "Use Wolfram Language to numerically compute ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", "-", 
     RowBox[{"3", "\[ImaginaryI]"}]}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dc02f801-e845-4e3d-a5cf-27718bf5ed83"],
 ":"
}], "SolvedExampleNote",
 CellID->680141357,ExpressionUUID->"2f3e19c8-f2ab-40ca-a223-ea4a95cd25b1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", 
   RowBox[{"2", "-", 
    RowBox[{"3", "I"}]}], "]"}], "//", "N"}]], "SolvedExampleInput",
 CellID->42853068,ExpressionUUID->"abe7c9c0-de88-46a2-aaca-705a61fa87ed"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7.315110094901103`"}], "-", 
  RowBox[{
  "1.0427436562359045`", " ", "\[ImaginaryI]"}]}]], "SolvedExampleOutput",
 CellID->220057481,ExpressionUUID->"82cddb29-dace-4de4-abfa-b8954cb82c65"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"d559ec27-a65c-40be-adae-64ae779ead59"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties", "Subsubsection",
 CellID->214502142,ExpressionUUID->"c07ee32f-a9cf-4801-bdf3-3a7fd222dd91"],

Cell["The formula", "Text",
 CellID->129738374,ExpressionUUID->"5d86f3fd-adc3-4491-bdfe-ae30e3b3a3e2"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"z", "+", "w"}]], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "z"], 
     SuperscriptBox["\[ExponentialE]", "w"]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->6830625,ExpressionUUID->"a6bbe865-75ba-4f0e-9ed8-644c7888f203"],

Cell[TextData[{
 "which is familiar from real analysis is still valid for complex ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", ",", "w"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "04bbb3f9-9b1a-4ab2-b76a-5bd65c56e06f"],
 "."
}], "Text",
 CellID->268846281,ExpressionUUID->"9355b8c3-713c-4ab3-ad29-e97b0829e6d1"],

Cell["Proof:", "Text",
 CellID->120708249,ExpressionUUID->"ecaa3862-b2c9-41d2-bfe9-1408ea2a68ef"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"z", "+", "w"}]], "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "w"}], ")"}], "n"], 
      RowBox[{"n", "!"}]]}], "=", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", "n", "\[Infinity]"], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"m", "=", "0"}], "n"], 
       FractionBox[
        RowBox[{
         RowBox[{"(", GridBox[{
            {"n"},
            {"m"}
           }], ")"}], 
         SuperscriptBox["z", "m"], 
         SuperscriptBox["w", 
          RowBox[{"n", "-", "m"}]]}], 
        RowBox[{"n", "!"}]]}]}], "=", 
     RowBox[{
      RowBox[{
       UnderoverscriptBox["\[Sum]", "n", "\[Infinity]"], 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"m", "=", "0"}], "n"], 
        FractionBox[
         RowBox[{
          SuperscriptBox["z", "m"], 
          SuperscriptBox["w", 
           RowBox[{"n", "-", "m"}]]}], 
         RowBox[{
          RowBox[{"m", "!"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "-", "m"}], ")"}], "!"}]}]]}]}], "=", 
      RowBox[{
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"n", "=", "0"}], "\[Infinity]"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["z", "n"], 
          RowBox[{"n", "!"}]], 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"m", "=", "0"}], "\[Infinity]"], 
          FractionBox[
           SuperscriptBox["w", "m"], 
           RowBox[{"m", "!"}]]}]}]}], "=", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "z"], 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "w"], "."}]}]}]}]}]}]}], 
  TraditionalForm]], "DisplayFormula",ExpressionUUID->"57a579e6-7d8c-4006-\
a24f-af633c46f161"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->16005289,ExpressionUUID->"1be7b561-8282-4e40-a3c7-9e8c1da3396b"],

Cell["\<\
In Wolfram Language, exponentials are always grouped together:\
\>", "SolvedExampleNote",
 CellID->9823917,ExpressionUUID->"ea47f4f1-4788-41a5-bf48-f2e95daaa5e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", "z", "]"}], 
  RowBox[{"Exp", "[", "w", "]"}]}]], "SolvedExampleInput",
 CellID->516617764,ExpressionUUID->"963e1d09-abd5-4472-9dc6-cd582225f12d"],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"w", "+", "z"}]]], "SolvedExampleOutput",
 CellID->380859827,ExpressionUUID->"775f8e61-0c00-4c16-8493-04e080c01c91"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1452557463,ExpressionUUID->"32789b73-4049-4f59-b7e7-5c432dab6ee7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graph", "Subsubsection",
 CellID->212135000,ExpressionUUID->"f1364683-84bb-4c3a-8857-82141d5ba2bf"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s examine the graph of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    SuperscriptBox["\[ExponentialE]", "z"], "|"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e9598078-f0bc-4c62-a9b6-88f9d19c3b23"],
 " in the complex plane (Fig. 1)."
}], "Text",
 CellID->113403622,ExpressionUUID->"4d609767-da4c-4a7e-ad3a-fbffbec22884"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Exp", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["4", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1056", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[PlotRange -> {0, 6}, BoxRatios -> {1, 1, 1}, AxesLabel -> {
        ToString[$CellContext`x, TraditionalForm], 
        ToString[$CellContext`y, TraditionalForm], 
        ToString[
         HoldForm[
          Abs[E^($CellContext`x + I $CellContext`y)]], TraditionalForm]}, 
      AxesStyle -> Directive[12]],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["792", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 1. The plot of " <> ToString[
       HoldForm[
       Abs[E^$CellContext`z] == Abs[E^($CellContext`x + I $CellContext`y)]], 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->525925853,ExpressionUUID->"1ec51783-cfa1-497d-a7ff-bfdbfaafed22"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"Exp", "[", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "6"}], "}"}]}], ",", 
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           FormBox["x",
            TraditionalForm], ",", 
           FormBox["y",
            TraditionalForm], ",", 
           FormBox[
            TagBox[
             TemplateBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"x", "+", 
                  RowBox[{"\[ImaginaryI]", " ", "y"}]}]]},
              "Abs"],
             HoldForm],
            TraditionalForm]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "\[Rule]", 
         RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Fig. 1. The plot of \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"Abs", "[", 
              SuperscriptBox["\[ExponentialE]", "z"], "]"}], "\[Equal]", 
             RowBox[{"Abs", "[", 
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"x", "+", 
                RowBox[{"\[ImaginaryI]", " ", "y"}]}]], "]"}]}],
            HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->60325360,ExpressionUUID->"45e9c63a-3436-40bc-8076-15a8aad42f47"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJzVnWmcFdW1RxsauhFImBQHJtEOmImXgSlqvFcFASFIJMRZlBmlY8Q4MWhU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        "], {{
          {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
            GrayLevel[1], 3], 
           StyleBox[GraphicsGroup3DBox[
             TagBox[{Polygon3DBox[CompressedData["
1:eJw1mAf8TmUbx8957nO/RVNK801DpKQlUgkVTSGhFKVQyd4zO5RoKA0jRGQn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                "]], Polygon3DBox[CompressedData["
1:eJwtmgXYlMUahndmdu1CRcVGBLsDscBAsRVRVFTKRjGwW0BsQexEUAwU7AbE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                "]], Polygon3DBox[CompressedData["
1:eJwt13fcV2MbAPCn8/RDZpEkGb0heysZSZJUFAmFSgOhoWQlaU+ptAelYbQk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                "]]},
              Annotation[#, "Charting`Private`Tag$43790#1"]& ]],
            Lighting->{{"Ambient", 
               RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
              "Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{0, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 0, 2}]}}]}, {}, 
          {GrayLevel[1], EdgeForm[None], 
           StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlE1IlFEUhu91hoxKB3QTNlpKRKmVZm7ULItSZ2hCVynmwlJHKs2NVrSt
qLYV1lYj22pY2xJrW5Fus1QwxFRCdFr1HO67eOc8c79z73f+7lfcNdDan+Wc
u4oiaIafCeyFqHMVcDmcBb+AH8DV8F14GC6Ej8NlsIfn4G9wAp6Fv8LN8EVU
COezdgDF4Qz2HroN7+d5PdwM79CZNbCzvfBlcBf8Hf4CN8Gn4QScDRcrTjtz
HI3BdayfgZPwTvix4i+FN7C/0TIa4H+5d64B2xoNay3YN/i/gk9FQ8yW43Yk
PLe982gFLaJcF2KwHP9hr6A2OMbea2gv5/9hbSES9iUVj9WwDL6BDuFzBNuP
SuFa7B180vgUwYPWDx9yv4kOw1XYEXzu43MSfgQPKcduVOBDzNfhg/A+bA+K
+1DbTzz7qF5/hqfhRvgJ/FCxdaj+uXBKNd+jvli/dqsXtapzHyrh/Bxs2mrn
Q+96UZEP/a1Xf613r+FRF/L9i11TXe29vS6cMyyOw5su9G9VvkvqwSV82hXb
S/i5ZjUPzjFfmzXVx+qQ0Tk/0S/NVVI1mVQdVuWzrHdZfDEX+ptWTTrhPvU6
XzNg77K8nmoOt7Q/ptzWFHNKc2I1tLUt5WPvzGjOjDcV54LuVIvu4zP1fVZ9
TOiOfNC9y9Nds9m7xf9j1P889p1yPKuZsfmx2ZvRXvOZ0negQTwq/wr12ute
Wx7rrKWsv+L36C18TnfKvgmLrJWgo7ojVcTyAz7hQzxj8q+E6/TNGVENbc7H
la/dx/+ftYwY
               "]], Polygon3DBox[CompressedData["
1:eJwtk0tsjVEUhf97/6MVj0oYalEzrUalTLTUI0rbtKIjGjWoR3uDlonbi6kK
piWYlmCKqKkKptVgqqESE4+hN9/KXoOVrHX2Pnuf/Tj1g6N9I8Usy3pBAmN5
lpVBLaLOKHN+1rZ16IvwYiHLTsIXgQPof2AYvjKFbwH7CXg3mEG/Ah+4vxo9
lkXMc3mgAlalsHWAB9geghect6In9TbijcAbwSX0OLiCfSv6Gvw6uI/enyLX
LOiDD6oo7g5lUdc35YLXgR5sO1PkUs7HedSr2it+m+LfwXYb3EPvQj/y+6bQ
O/zeBeQYTWGXr+48yeO9qlU1X0V3op/Cp8EbdJv9VeNd9OYUtaimm+iuFL7P
wFv0Jvd/3Hb5i6snt9At6Al4zntOwRts153Lvq/Y8rmRR/2Trm/K89EszsMv
gB9gPbZGsAa+GNvBLGbeg97r+VaT7wy8mMK/CWzEXuP90J2BPPZhDv4OvHc/
NC/FeI0+kiLWjO2qf9b7o34tQXfBu8G+PHwUq6UQd/W+zix8erFVo7fAW0G7
92wYXsqiRtVX632oh//Mg2tH1sKXud5+cBi9MEWsNrAdvdvzrCL/afhXzpai
a8AK+J4Us5v2Pnd4nrrz3P9Mu6k3VbwPE56/9q2QovfqabNi2187XUqRQ7nm
vc/z6M/wT97/Bv/Hsv+L/odsc/6PX1z/L3A0RX3d7l+7+93v+amfVe7vXzCU
or/y1dk27N/zeO9vcMz9UD+VY7n/n976UfH0Nz2fP+B4inrVX51t8P6oN6r5
kPupv6c/+DKPfWvzfJs9r5L7OeB5Nrl/mu9/xxOHbg==
               "]], 
              Polygon3DBox[{{1034, 288, 254, 73, 845}, {1051, 292, 1122, 887, 
               888}, {1006, 280, 250, 13, 786}, {1093, 302, 261, 178, 965}, {
               1037, 290, 255, 88, 860}, {1075, 296, 258, 133, 920}, {1024, 
               284, 252, 43, 815}, {1065, 294, 257, 118, 905}, {1030, 286, 
               253, 58, 830}, {1083, 298, 259, 148, 935}, {1096, 304, 262, 
               193, 980}, {1016, 282, 251, 28, 800}, {1089, 300, 260, 163, 
               950}}]}],
            Lighting->{{"Ambient", 
               GrayLevel[0.8]}}]}, {}, {}}, {
          {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0jkoh3EAx+Gf+3/h706ShCQhSZQoR4nIUe7baKBsFjOD2WK2mC1mi9l9
LgaRScLoUYbP+3ynt997VK5ujK+nhBB29aW//aFnZaWFkGQRK1jNRrawkz0c
4hjnuMJVrdnb3OIed3jAfR7xkCc85hlPOZoewgt/dK5PvSszNYSLv7PwkhFG
dWXHeM04E7qxs3nLHObqzk7ynnnM14NdwEcW8onfjHj4Ym06SzNXWMQmLduF
bNCSXcB6Ldr5rNOCncdazdtJ1mjOzuUaqzjLHFZqxs5mhabtBMs1ZcdZpkk7
xlJN2FGWaEwJZx9hnMOMcZADitr9jLCPvcqyu5nJLnYqw+6gW4d2tslnCa30
WsKry9v///ELQEcwAw==
            "]], Line3DBox[CompressedData["
1:eJwt0DtIglEAhuHjpZyqNSSkJCTEosvq0C4YtAgODWYXMbW2wPYG94b2hvYG
94Z2h9YKaghpkgi72RM4fDwvZznn/xcqre1mJIRQsmmbsk+bdViNh/Clk3pP
f+s5va9/dEof6F89rw/1SKd1TQdWuMg6I8zYkY5yyRo6xqw1dZw5a+kJrtix
nuSqnegEd7nBdXtw1aO92tCe7N3e7DkWQo/3vOUdb9jlFa95wUues8NTnrFt
Nb3DMrdY4CbzXOPy//cyxaI3vfDDZmxg/fF//QPxBSj0
            "]]}, 
          {GrayLevel[0.2], 
           Line3DBox[{775, 1100, 1243, 997, 774, 1244, 998, 776, 1245, 1246, 
            999, 777, 1247, 1000, 778, 1248, 1249, 1001, 779, 1250, 1002, 780,
             1251, 1139, 1371, 781, 1252, 1003, 782, 1253, 1140, 1372, 783, 
            1254, 1004, 784, 1255, 1005, 785, 1256, 1109}], 
           Line3DBox[{789, 1257, 1009, 788, 1258, 1010, 790, 1259, 1141, 1373,
             791, 1260, 1011, 792, 1261, 1142, 1374, 793, 1262, 1012, 794, 
            1263, 1143, 1375, 795, 1264, 1013, 796, 1265, 1144, 1376, 797, 
            1266, 1014, 798, 1267, 1015, 799, 1268, 1110}], 
           Line3DBox[{804, 1145, 1377, 803, 1269, 1019, 805, 1270, 1146, 1378,
             806, 1271, 1020, 807, 1272, 1147, 1379, 808, 1273, 1021, 809, 
            1274, 1148, 1380, 810, 1275, 1022, 811, 1276, 1149, 1381, 812, 
            1150, 1382, 813, 1277, 1023, 814, 1278, 1111}], 
           Line3DBox[{819, 1151, 1383, 818, 1279, 1027, 820, 1280, 1152, 1384,
             821, 1281, 1028, 822, 1282, 1153, 1385, 823, 1154, 1386, 824, 
            1283, 1155, 1387, 825, 1156, 1388, 826, 1284, 1157, 1389, 827, 
            1158, 1390, 828, 1285, 1029, 829, 1286, 1112}], 
           Line3DBox[{834, 1159, 1391, 833, 1160, 1392, 835, 1287, 1161, 1393,
             836, 1162, 1394, 837, 1288, 1163, 1395, 838, 1164, 1396, 839, 
            1289, 1165, 1397, 840, 1166, 1398, 841, 1290, 1167, 1399, 842, 
            1168, 1400, 843, 1291, 1033, 844, 1292, 1113}], 
           Line3DBox[{849, 1169, 1401, 848, 1170, 1402, 850, 1293, 1171, 1403,
             851, 1172, 1404, 852, 1294, 1173, 1405, 853, 1174, 1406, 854, 
            1295, 1175, 1407, 855, 1176, 1408, 856, 1177, 1409, 1410, 857, 
            1178, 1411, 858, 1179, 1412, 859, 1296, 1114}], 
           Line3DBox[{866, 1297, 1040, 864, 1298, 1041, 868, 1300, 1301, 1042,
             870, 1302, 1043, 872, 1303, 1304, 1044, 874, 1305, 1045, 876, 
            1306, 1307, 1046, 878, 1308, 1047, 880, 1309, 1310, 1048, 882, 
            1311, 1049, 884, 1312, 1050, 886, 1314, 1115}], 
           Line3DBox[{894, 1315, 1056, 893, 1316, 1057, 895, 1317, 1318, 1058,
             896, 1319, 1059, 897, 1320, 1321, 1060, 898, 1322, 1061, 899, 
            1323, 1191, 1427, 900, 1324, 1062, 901, 1325, 1192, 1428, 902, 
            1326, 1063, 903, 1327, 1064, 904, 1328, 1116}], 
           Line3DBox[{909, 1329, 1068, 908, 1330, 1069, 910, 1331, 1193, 1429,
             911, 1332, 1070, 912, 1333, 1194, 1430, 913, 1334, 1071, 914, 
            1335, 1195, 1431, 915, 1336, 1072, 916, 1337, 1196, 1432, 917, 
            1338, 1073, 918, 1339, 1074, 919, 1340, 1117}], 
           Line3DBox[{924, 1197, 1433, 923, 1341, 1078, 925, 1342, 1198, 1434,
             926, 1343, 1079, 927, 1344, 1199, 1435, 928, 1345, 1080, 929, 
            1346, 1200, 1436, 930, 1347, 1081, 931, 1348, 1201, 1437, 932, 
            1202, 1438, 933, 1349, 1082, 934, 1350, 1118}], 
           Line3DBox[{939, 1203, 1439, 938, 1351, 1086, 940, 1352, 1204, 1440,
             941, 1353, 1087, 942, 1354, 1205, 1441, 943, 1206, 1442, 944, 
            1355, 1207, 1443, 945, 1208, 1444, 946, 1356, 1209, 1445, 947, 
            1210, 1446, 948, 1357, 1088, 949, 1358, 1119}], 
           Line3DBox[{954, 1211, 1447, 953, 1212, 1448, 955, 1359, 1213, 1449,
             956, 1214, 1450, 957, 1360, 1215, 1451, 958, 1216, 1452, 959, 
            1361, 1217, 1453, 960, 1218, 1454, 961, 1362, 1219, 1455, 962, 
            1220, 1456, 963, 1363, 1092, 964, 1364, 1120}], 
           Line3DBox[{969, 1221, 1457, 968, 1222, 1458, 970, 1365, 1223, 1459,
             971, 1224, 1460, 972, 1366, 1225, 1461, 973, 1226, 1462, 974, 
            1367, 1227, 1463, 975, 1228, 1464, 976, 1229, 1465, 1466, 977, 
            1230, 1467, 978, 1231, 1468, 979, 1368, 1121}], 
           Line3DBox[{1104, 1103, 1469, 1242, 983, 1232, 1470, 984, 1369, 
            1233, 1471, 985, 1234, 1472, 986, 1235, 1473, 1474, 987, 1236, 
            1475, 988, 1237, 1476, 1477, 989, 1238, 1478, 990, 1239, 1479, 
            1480, 991, 1240, 1481, 992, 1241, 1482, 993, 1370, 1108, 1138}], 
           Line3DBox[{1130, 1107, 1313, 885, 1426, 1190, 883, 1425, 1189, 881,
             1424, 1423, 1188, 879, 1422, 1187, 877, 1421, 1420, 1186, 875, 
            1419, 1185, 873, 1418, 1417, 1184, 871, 1416, 1183, 869, 1415, 
            1182, 1299, 867, 1414, 1181, 863, 1413, 1180, 865}]}, 
          {GrayLevel[0.2], 
           Line3DBox[{309, 534, 1244, 310, 549, 1258, 339, 564, 1269, 354, 
            579, 1279, 369, 1392, 594, 384, 1402, 609, 399, 1414, 624, 1298, 
            414, 639, 1316, 429, 654, 1330, 444, 669, 1341, 459, 684, 1351, 
            474, 1448, 699, 489, 1458, 714, 504, 1470, 729, 519}], 
           Line3DBox[{311, 535, 1245, 313, 550, 1259, 340, 565, 1270, 355, 
            580, 1280, 370, 595, 1287, 385, 610, 1293, 400, 625, 1299, 1300, 
            415, 640, 1317, 430, 655, 1331, 445, 670, 1342, 460, 685, 1352, 
            475, 700, 1359, 490, 715, 1365, 505, 730, 1369, 520}], 
           Line3DBox[{315, 537, 1247, 316, 552, 1260, 342, 567, 1271, 357, 
            582, 1281, 372, 1394, 597, 387, 1404, 612, 402, 1416, 627, 1302, 
            417, 642, 1319, 432, 657, 1332, 447, 672, 1343, 462, 687, 1353, 
            477, 1450, 702, 492, 1460, 717, 507, 1472, 732, 522}], 
           Line3DBox[{317, 538, 1248, 319, 553, 1261, 343, 568, 1272, 358, 
            583, 1282, 373, 598, 1288, 388, 613, 1294, 403, 1417, 628, 1303, 
            418, 643, 1320, 433, 658, 1333, 448, 673, 1344, 463, 688, 1354, 
            478, 703, 1360, 493, 718, 1366, 508, 1473, 733, 523}], 
           Line3DBox[{321, 540, 1250, 322, 555, 1262, 345, 570, 1273, 360, 
            1386, 585, 375, 1396, 600, 390, 1406, 615, 405, 1419, 630, 1305, 
            420, 645, 1322, 435, 660, 1334, 450, 675, 1345, 465, 1442, 690, 
            480, 1452, 705, 495, 1462, 720, 510, 1475, 735, 525}], 
           Line3DBox[{323, 541, 1251, 325, 556, 1263, 346, 571, 1274, 361, 
            586, 1283, 376, 601, 1289, 391, 616, 1295, 406, 1420, 631, 1306, 
            421, 646, 1323, 436, 661, 1335, 451, 676, 1346, 466, 691, 1355, 
            481, 706, 1361, 496, 721, 1367, 511, 1476, 736, 526}], 
           Line3DBox[{327, 543, 1252, 328, 558, 1264, 348, 573, 1275, 363, 
            1388, 588, 378, 1398, 603, 393, 1408, 618, 408, 1422, 633, 1308, 
            423, 648, 1324, 438, 663, 1336, 453, 678, 1347, 468, 1444, 693, 
            483, 1454, 708, 498, 1464, 723, 513, 1478, 738, 528}], 
           Line3DBox[{329, 544, 1253, 331, 559, 1265, 349, 574, 1276, 364, 
            589, 1284, 379, 604, 1290, 394, 1409, 619, 409, 1423, 634, 1309, 
            424, 649, 1325, 439, 664, 1337, 454, 679, 1348, 469, 694, 1356, 
            484, 709, 1362, 499, 1465, 724, 514, 1479, 739, 529}], 
           Line3DBox[{333, 546, 1254, 334, 561, 1266, 351, 1382, 576, 366, 
            1390, 591, 381, 1400, 606, 396, 1411, 621, 411, 1425, 636, 1311, 
            426, 651, 1326, 441, 666, 1338, 456, 1438, 681, 471, 1446, 696, 
            486, 1456, 711, 501, 1467, 726, 516, 1481, 741, 531}], 
           Line3DBox[{335, 547, 1255, 336, 562, 1267, 352, 577, 1277, 367, 
            592, 1285, 382, 607, 1291, 397, 1412, 622, 412, 1426, 637, 1312, 
            427, 652, 1327, 442, 667, 1339, 457, 682, 1349, 472, 697, 1357, 
            487, 712, 1363, 502, 1468, 727, 517, 1482, 742, 532}], 
           Line3DBox[{337, 760, 1256, 746, 761, 1268, 747, 762, 1278, 748, 
            763, 1286, 749, 764, 1292, 750, 765, 1296, 751, 766, 1313, 1314, 
            752, 767, 1328, 753, 768, 1340, 754, 769, 1350, 755, 770, 1358, 
            756, 771, 1364, 757, 772, 1368, 758, 773, 1370, 759}], 
           Line3DBox[{518, 728, 744, 1469, 503, 713, 1457, 488, 698, 1447, 
            473, 683, 1439, 458, 668, 1433, 443, 1329, 653, 428, 1315, 638, 
            413, 1297, 623, 1413, 398, 608, 1401, 383, 593, 1391, 368, 578, 
            1383, 353, 563, 1377, 338, 1257, 548, 308, 1243, 533, 743, 745}], 
           Line3DBox[{521, 731, 1471, 506, 716, 1459, 491, 701, 1449, 476, 
            686, 1440, 461, 671, 1434, 446, 656, 1429, 431, 1318, 641, 416, 
            1301, 626, 1415, 401, 611, 1403, 386, 596, 1393, 371, 581, 1384, 
            356, 566, 1378, 341, 551, 1373, 314, 1246, 536, 312}], 
           Line3DBox[{524, 734, 1474, 509, 719, 1461, 494, 704, 1451, 479, 
            689, 1441, 464, 674, 1435, 449, 659, 1430, 434, 1321, 644, 419, 
            1304, 629, 1418, 404, 614, 1405, 389, 599, 1395, 374, 584, 1385, 
            359, 569, 1379, 344, 554, 1374, 320, 1249, 539, 318}], 
           Line3DBox[{527, 737, 1477, 512, 722, 1463, 497, 707, 1453, 482, 
            692, 1443, 467, 677, 1436, 452, 662, 1431, 437, 647, 1427, 422, 
            1307, 632, 1421, 407, 617, 1407, 392, 602, 1397, 377, 587, 1387, 
            362, 572, 1380, 347, 557, 1375, 326, 542, 1371, 324}], 
           Line3DBox[{530, 740, 1480, 515, 725, 1466, 500, 710, 1455, 485, 
            695, 1445, 470, 680, 1437, 455, 665, 1432, 440, 650, 1428, 425, 
            1310, 635, 1424, 410, 620, 1410, 395, 605, 1399, 380, 590, 1389, 
            365, 575, 1381, 350, 560, 1376, 332, 545, 1372, 330}]}, {}, {}}},
        VertexNormals->CompressedData["
1:eJztnXlcTVsbx49wG6QUhagUmiPKFGfvBiRNKlPmi0hFkiEpNJjJUJR5lvFG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         "]], {}},
      Axes->True,
      AxesLabel->{
        FormBox[
         TagBox[
          TagBox["x", HoldForm], HoldForm], TraditionalForm], 
        FormBox[
         TagBox[
          TagBox["y", HoldForm], HoldForm], TraditionalForm], 
        FormBox[
         TagBox[
          TagBox[
           TemplateBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
                TagBox["x", HoldForm], "+", 
                RowBox[{"\[ImaginaryI]", " ", 
                  TagBox["y", HoldForm]}]}]]}, "Abs"], HoldForm], HoldForm], 
         TraditionalForm]},
      AxesOrigin->{Automatic, Automatic, Automatic},
      AxesStyle->Directive[12],
      BoxRatios->{1, 1, 1},
      DisplayFunction->Identity,
      FaceGrids->None,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]], 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "RotationControl" -> "Globe"},
      PlotRange->{{-2.9999995714285714`, 
       2.9999995714285714`}, {-2.9999995714285714`, 2.9999995714285714`}, {0.,
        6.}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], Automatic},
      Ticks->{Automatic, Automatic, Automatic}]},
    {"\<\"Fig. 1. The plot of \
\\!\\(\\*FormBox[TagBox[RowBox[{TemplateBox[List[SuperscriptBox[\\\"\\\\[\
ExponentialE]\\\", \\\"z\\\"]], \\\"Abs\\\"], \\\"\[LongEqual]\\\", \
TemplateBox[List[SuperscriptBox[\\\"\\\\[ExponentialE]\\\", RowBox[List[\\\"x\
\\\", \\\"+\\\", RowBox[List[\\\"\\\\[ImaginaryI]\\\", \\\" \\\", \
\\\"y\\\"]]]]]], \\\"Abs\\\"]}], HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->170362819,ExpressionUUID->"554cc1df-686d-4008-ba86-a8b92b3f1d95"]
}, {3}]],

Cell[TextData[{
 "The modulus of the exponential function becomes very large as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Re", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7774044a-0e34-42e9-9ec4-13d9444ea0fb"],
 " grows but stays constant as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Im", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"41267074-a817-4bf4-ba37-c68ec901f5ce"],
 " increases."
}], "Text",
 CellID->720757087,ExpressionUUID->"ffdb2d83-a8c2-401b-9971-fac7ffdea36f"],

Cell[TextData[{
 "In Fig. 2, the previous plot is color-coded with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"arg", "(", 
    SuperscriptBox["\[ExponentialE]", "z"], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b74f7f68-4e6f-4c2c-8013-8a3347ff4fa9"],
 ". There is a periodic pattern in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", "z"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a3ebad0e-404b-422a-bb53-81ddc9674907"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Im", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"57404686-3054-4de7-940b-bb47d5b441fd"],
 " increases. Later, a formula that explains this pattern will be presented."
}], "Text",
 CellID->242469459,ExpressionUUID->"1c33d269-1e61-487b-8be7-27ecd14b7a91"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot3D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "10"}], "-", 
       RowBox[{"10", "\[ImaginaryI]"}]}], ",", 
      RowBox[{"10", "+", 
       RowBox[{"10", "\[ImaginaryI]"}]}]}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["3", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["680", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[PlotLegends -> Automatic, AxesLabel -> {
        ToString[$CellContext`x, TraditionalForm], 
        ToString[$CellContext`y, TraditionalForm], 
        ToString[
         HoldForm[
          Abs[E^$CellContext`z]], TraditionalForm]}, AxesStyle -> 
      Directive[12]],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["808", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ((("Fig. 2. The plot height is " <> ToString[
         HoldForm[
          Abs[E^$CellContext`z]], TraditionalForm]) <> 
      ", and its color represents ") <> ToString[
       HoldForm[
        Arg[E^$CellContext`z]], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->31453065,ExpressionUUID->"7b0a135b-8bd4-4edc-8618-3d40cca83a0f"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        RowBox[{"Exp", "[", "z", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", 
          RowBox[{
           RowBox[{"-", "10"}], "-", 
           RowBox[{"10", "\[ImaginaryI]"}]}], ",", 
          RowBox[{"10", "+", 
           RowBox[{"10", "\[ImaginaryI]"}]}]}], "}"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           FormBox["x",
            TraditionalForm], ",", 
           FormBox["y",
            TraditionalForm], ",", 
           FormBox[
            TagBox[
             TemplateBox[{
               SuperscriptBox["\[ExponentialE]", "z"]},
              "Abs"],
             HoldForm],
            TraditionalForm]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "\[Rule]", 
         RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\"\<Fig. 2. The plot height is \>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               TagBox[
                RowBox[{"Abs", "[", 
                 SuperscriptBox["\[ExponentialE]", "z"], "]"}],
                HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
           "<>", "\"\<, and its color represents \>\""}], ")"}], "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           TagBox[
            RowBox[{"Arg", "[", 
             SuperscriptBox["\[ExponentialE]", "z"], "]"}],
            HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->937117654,ExpressionUUID->"82803060-8dc8-4a50-acdb-313a278c33c3"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJyV3X+sVnUdwPEH1IsDxIvoVaPwIvlzpNNc/kh8TmpKLHSVKUtr/lYcoWIp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          "], {{{
             EdgeForm[], 
             Texture[
              GraphicsBox[
               TagBox[
                RasterBox[CompressedData["
1:eJzt3N9PFQQYxnFWFzTS6aKt2s6h0arN7CI4jANIF4AWZtQ6eHBLWQMjpBIK
2tKBsKV1lwq41rpIQdedHHWtJrhp8UuRXx4gKaMojChokGws76Ktf8Ar992+
2+d997zvH/GkltdE3rgnISGh7r7VFSl7P6+2tmx/8frVI1pdV1VZXfH61ur3
KiorarPK7119Hv1//svRg38JJNJ8UyBFx38UyObTYwLJ6BwQSPjieYFkd38h
kHBfq0DSB5oEkjG4VyAFQ6UCKRreJpCSkUyB7Bp9SCD18fUC+WRsrUBi40kC
6ZtIFMj1a0kCme5LFsgfXQ8L5O8zQYH8cypVICstGwWy3JQukKW3sgSyEM0V
yFzBFoHM5hYLZCZUJpDpp2oEMvVog0Amgx8LZCzwuUAGAzGB9Aa/EUjX48MC
iaV9J5D2nJ8EcixvViCHChcF0hAVSV25SKr2LgmkdJ9IoocWBBJpuSmQohM3
BFLQERdIqOuKQMIXvxZIdvcpgYT7mwWSNtAokMzBtwWyeWinQF4afkEgJSMZ
AikdTRbIgfg6gXw6tlYgZ8eTBHJ5IlEgk6P3C+SX3mSB/Nn5iEBuxYICuX0y
VSArzRsFstwYEshiVZZA5otzBTKX/5xAZjdtF8hMqFwg0xveEchUygGBTAYP
CyQeOC6QwcBZgfQEvxVI5xMjAulIuy6QtpyfBdKa/7tADhYuCqS+RCS1u5cE
sqdaJLv2iST64YJAIq0zAnmx7YZA8mNxgaRfuCyQ8KWvBJLdfVIgmf1HBZI2
0CCQ8OCbAtky9KpAXh4uFMiOkZBAXht9QCBN8XUC+WxsjUDOjScJ5MpEokC+
H1kjkF97HxTIXS+w0h251ZEikNvtjwlk5cjTAlluCAlkcU+WQOZfeVYgc/nP
C+S3nKhAZtJ3C2R6w7sCmUppFMhk8IhA4oE2gVwNnBNId7BHIOefHBXI6fRJ
gZzYNC2Qlvw5gXywdVEg9TtEctcLrHRHKmtEsnO/SLZ/NC+QyLEZgWxr/0Eg
eWeuCSR0oV8g4UtfCiSrp10gmf2HBfLM1XqB/Av6YJEt
                 "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                 RGBColor], 
                BoxForm`ImageTag[
                "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
               ImageSizeRaw -> {144., 144.}, 
               PlotRange -> {{0, 144.}, {0, 144.}}]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNnHfg19P6wN+f9+dTkdGwMtqFi0jbSEMyUpGsa2dmVPZIZYeSLSlKoWjg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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwl0dsqhFEchvFl5j3QXIGUAydyBZoLkAuQXMDk1AwzY78bY69klyQJSZLs
kiQhOZUrcAWaK3Dk+fcePN/8WuvbrLWmvVDqLWZSSm0k2uTSz2+eSvie+rih
i2r4jOpNKQ3QBH6gcsb3zONTea6HxvERdeIcjeJb+V0tNIc/qZBNqZvW8Dt1
4GZawR/yXIyt4kGqZf3MOn6hX971RUv4VX42xpbxE93gLVrAz/K9MbaIr+W1
/LG+WXwl+4dm8KP8bOyxjg/lvTQ4nxF8LO819jiGL+gNn9AU3pDPspWKeJd2
cJWG8bbsOPMhvE/f+I4q+ED+VoxV8Z48F+8o43P5W/GfTOJLee2xhmn8D3/Q
P1Y=
                 "]]}, 
               Annotation[#, "Charting`Private`Tag$44306#1"]& ]]}, {}, {
             EdgeForm[], 
             GrayLevel[0.82], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJxNlUtM3FUUxv8zczcttHsLmrji5b6AbnGoxjRWYQZ8t2WganQhr62luKrG
MrQxxhidNsYYo0CJMcbYR3QpDG6NxV2byKD7YuP3eX7/wOKbM/f+7z33PL5z
zqOn3z71VjHLst+FkjCkn7PCGaFWyLKyMCx8lbLsvuSrknck/xX2hDad25GC
ljDJ2RPCFPIpob0U33eFhtYLwgXhKnJROKwzfxVD17bWD3jjvULoneJcjfVF
nX9feEI2P57F2v9bpfj/cBa6fhU2imFHn/BYIWzx3qbwtfx5SPK1FLZM8MYf
+Gefr/G2bbkl/FkIG+1fL3rtdw/rpvStCmvF8PE29/ytzfEoxJv9wnHhF739
rmz+WbLsuAsT5GFBOC98oW83dO/lFLnxnu800H1T+Bzpc3e5az27+Gq7njyg
23C+vbeIn3lOLPNcNdDdofuDwoDQleIN23qMvX7eWcH/CXTbJ8f7W759k8Lv
05LXUuh+KcXZLqFb6C0Ft9pZHyoFRz5JEeexFLHsJe7t5MFr82FcGMvC5j24
tKz1jDCbhc33yfEVreeEeeEy370e1ZkZYVqoCLOs9+CH6+AD2VHR2VMpeHGL
fJ/QeigFH1ckR3TvDDG7R25G0P2O8Jt0XBfWhWXe8XuD+FEVjsBf+znAnt9u
CqvCmpFC39kU63oWfvfCV/P0qPC39v5B524Wa8ewlcXasXGMzNM28tFTijh2
FiOuX6aIwyspeLdNTG4g/a1G/odLETffs94e8tmG7CHPP6XgwOuSF1P4+axk
J3U+SK37v2v8Ae869ofQ0YWdd/jWg9/uZevk2Dn/NMXeeIrYL/Otj77leJmn
5oFz1QfP8jwcIZa+6/xtCWXpetq9RDasS15yHaTYP5ki9855XVgq7vdK9zTX
UBWudVE7rs+bKeQb6LYu198w99yvdor7sTTvnknRHz9KkdNKipps5r2AnDvX
m0ifO0/vd29Yw85l6vYSNrtPH6Ym1/Db+n5MsXeOt5a4vwU3Hach7Mpz2Eke
d+FiO/25HW58mKJmn0th71HiXqe/+p15amScuq2ynqU+vP6YflFNUStN/G7B
e3/boib8zhJ16Vx1w2HnY4Z41Pm+RFwWiNkEXB7mzknyZT5UsGkG/avE9UoK
W0ZT2D1/wI857jhu7imPZKG3m3d8ZoC6GKdGPAc3mMn5DNwhby344fhvMpNb
9PPygZ5+F1/yenZ932b2vCnZSDEbXkzR9yvUyXcp+nwN7q/Q9/vpJa79fFbl
s6tR2J+TV5lDw/jnvjPJ7F2k97i2XffT1OUo8+dYcX9GWXbSPzvgWQdxcrxq
6Mtn/gVm3Ta+2q45+oR7wlKKXvp8ij5xHU7P8v3/2YItjsUMe3WwRo8ewwbn
aYVazGfjBrlahqMjKXg2zTyo4ucg7xwnrnkN5zXdzPa5vEVvKtMn7Ov3Kd6Z
lPwsxd4L9IwhOFZB9wBzqML7l5lR9v+HFJyagjv34M1/qetGhg==
                "]], 
               Polygon3DBox[CompressedData["
1:eJwlkUtKA1EQRSudmogrCOLAkWQF4gLEqSZq/H8S4zeYgbgAcSriDxERUQki
ItGIiIhoEByKK3AF4gqc5BR3cJpDVfV99bq7itXcWmJmneCwyOOLwi+84IPQ
S70AO/gC3CWaecbLsJeo9oSvQHfarA+aeAmG6a3DAz4DPymzf7jB5129yHjE
l6EtrYw3fNY1m6F/iy+5douZV3zO1euBOl50eZx5j0/BBe+/wxU+CVsp1Wqx
GzS42zcc4ePQT68M5/gotONZOMWnXVlxh2t8wjUbmZf4quvuJfjAx1zvRuYZ
XoA/U+YJPgQHph0O8QHoMH3zbTwPG6aZfTzn+hdR28VHXLtH5jFecZ29CZ94
CyHyPGY=
                "]]}]}, {}, {}}, {{
             GrayLevel[0], 
             Line3DBox[CompressedData["
1:eJwl0stKFGAUB/AvLS+ZjbfKAgmhXfQE0V5LXLiLdm1qsmacca463jUbBxGJ
YUiJiBhEIiSGIUQiwieIXiCJgtqIT2C/ocWP/1kcvgPnfIMP42OxMyGELUbO
htCoh+Tz5hCuq+/wgDwV6nznhIjmW9wjyipVDjnilIGmEG5znyxlanzjmE5z
bjLMD0bNfiTvyhs8Vkd5wjhPeUaMOBMkSDJJip+k+UWG32TJkWeKaQrMMMsc
8423zVzjkCJfecEXVvnc2A0HrLDPMp9Yos4iNRb4yDx7zPGBWd4zwy4Fdpim
yhTvyPOWHG/I8poM26R5RYoKk5RJ8pIEm0ywQZx1YpS45oZX6ecKl7lEH730
0E3JXrpkUUbkX3lRdnKBDs7TThuttHAOY4L24NThT/P/P/YPnYhIog==
              "]], 
             Line3DBox[CompressedData["
1:eJwt0csqxHEUB/Cfy1JewFBWSp5AHmCGhHEbgxnG7e8SO9m6ZIWkaZIkaZIk
aZokSZrYyxNY2pAnkI+y+PQ9v9/inDqnObeSXK4KIUTEaKC3NoQd+tgjyT79
HDBAnkEKDHHIMEekOGaEE9KcMsoZYxQZ55wMF2S5ZIIrJrkmxw1TlJimzAy3
zHLHHPdEPDDPIws8sUiFJV54Zr0mhA02+aDH35bski1/vdVxWqnjqzqEV0rk
WSVFOzF+LPOdCkW2ieikjXq+7fiNMgXWSNPBrhnd5japE/LTu/H/Nr/tljX2

              "]]}}}, VertexNormals -> CompressedData["
1:eJztnHk8Vfn/xyWVZMlSxlKyRkWbjK7uua20TUVm1NAiJUUSLZIQRttIjTZL
2UrKKI+kId2DZpqY0rcSfUVapSlRZITK75577/t8ObfrnLvENb/849Grz/3c
zznn6fV4v9+f9+forlhvt0paSkrqqoyUVG/W7x0aulV+Rf1ypTg/QXmO3m1t
bXWMmyHT+9Gz1HMtHTZnRkVNZHovL/qI6T7LK1RVkobj44NGzmjC9AMxAS3N
4d/m+ub7xURFLaa7Vdk9wHTzG7Rt73xt8PHXsqduxvTMaZMqpVY64PrQzEcV
H1m6qWpOgPb81bjOiM4LbmLp19zs1ei0Lbh+8uQZm0psnozMITTDnbj+osZL
2Y+l/zxU+aCP0hFcn1IrO7zmYx1jjd3mfRv+ScZ1PaORRflNdYzSCan1obcu
4vqY9Td/XP2wjmG5e9G6FN8/cf23hrtxV4PqGPo3MpxvepbkSq9v3m+m855Z
Gm6v0mJUy/CXzk42DnyCj6/Zg3y4p/2SMejSM+w3rtu53jzJGsc4Pq0Q+1zu
Nc+fmzcYKqOvZPWXseZlRASMiGd9Dz6+Kr9sFWsdjOUhjdi6cicb1q1aO1kF
iTTpU8VaN+OJJQ27Dny8zDy/razrZGwolseuG9cdtvkEsO4LQ/bJBuw+4fqf
J3bKsu4j48Ib9n3F9YIsv5ZJtC0M83T2c8D1886HlrOeE+NIDvu54fpc91uX
WM+VEZXDfs64Ptv054UsDhhSn/15IzZdM+PSs8/xvHKvW1+MZ9CBZyOThWoY
z34NW5cqBM6hA89BWW1snt+EmM1UCHRkunJ5XumS5ofxXJwaVycfuI1exOVZ
PuK/bJ6XRJRHDAjcxpSmyPPhPfs93gTE0Ik8M36tXRAdkEon4znYyTS8Pc+e
KqM68Dz+td7oAS7ldODZ0CJifXue56TnsHlOP2TliPFcsqpsQfSLZrrWQz9V
jOcVnlUpGM9JYxKTenv1Re+vvtCC8axosbgV47mkaaX7pkIlJOSPD6cwnj+9
X4J9Dp9fZ0KlY2c8z7JtYfMMenG0w1OM50ujrNg899HrtU4rRxVdds/IF+O5
sY9CB55fGDtub8+zorOr67ynqoioPD/WSZ/D0FBDuptnfv4ctbO0U55BB54T
Az42YzxrGYcOND2/jr5WQv2ZjOc1cpWOryMfkPL8d/qWpRjPFloPZCxaW+m+
F6tV2vMM44Fn8OegcfY2tBHKCPizuHj+6s8c/UXgzk55tm97NfS4/mQ68Fz+
tvCzPEO84RizR/G4/nI83pCZUMDm+cDNiPvH9L2Y+Vyel7+Pe4DxPFJPXf6Y
fhCdxuXZNn9NYHue86PEy3OmV8ye9jzLvDLtwPPOltU/mao+osxz5JDxCzXW
fsJ5hnjjj7Dbhs0/yCFk8QbwHPnPyv2hxwchwvIsP2Mim+esfknBESbqyJk/
ivyo+DPoZDxfJvAcIFOxrD3P5XG/J6scVZd4f05Wf/lMM20Kk8yfgec79s13
NNOcmcT4+ci3A6I10zYwxe3Pfw2OHtqe58NPqPmz2bm6aeEpt5ngz9qr5r3D
eKatz9qqEfOW2YwWUoo3+j+/+/LWKSkE4o1Z95VTMZ6vI66ISZk8Wjh9RDMV
nhfHj3U+lqaOUuW5MNDFZIW5BiqsP9PudeSZlrS5PxV/Xjh5avakPA1UUv2Z
X/wsaLwBPINO5LlptC/iuduHLinxRp3OMbpraDGTGG/AeKr+DDr4M/A8uDr5
+d4nSjjP2ojXp/Y868rGJ7XPB0GHfLBq/HQ2z7GZW1zmemmhf2lEuWA8j9dp
6+DPqvJnHouTZ5UGDs99juccSXXSRjO1zzRjPJ8919GfX6DznP8/8wx6d/tz
tOuzvRjP35slyFrcKqFnfeLwvL+v7FuMZ28F5psjuY10V53iTusb4M8aCoP1
lCPVePw5W33MXI/byghVfwYd/NmqcCCb55dnYvPOnRmK9Fqr6dYZzxBv/B1c
lLvoBx083vgaP4uXZ6hv0C8oIYa5u/D6BhnPGxfUqevkHmUSec72f3FwQG4K
XdR4A3Rh/RnqdaU+1mcdbPuhUK8jywdBB56dztZ34NnOOWpRZ/GGuPyZH8/g
z6CDP5PxPPuibVPWYL1uj5/58UxWrzNcU9RYEO5EJ9Y3vt+UXFkQ7sFT39if
ci64INy/2+Nn8Oc7r2cO8Ayr4PFnGA/+TBZvxH9ofZNRLYeS1TegXvfBY+MA
yx3DeOp1jnvlPF7p6AudDwLPx87vcnPeboBS5TmhduroYacMeOp1YxNflj/M
NkDI/PkiwZ8nrDZh83yAy7Ofmumo0rcGyMFFBvaSkA9eubVwmPvDBXSq+ymg
E+ONdSYV/137MKjb42fgecNo2W0q5Y9wniEfhPFk+SDwfGqninnvG0oIsb6x
wWpQqe9uLcr1DdDFXa+D+kbC34eQTbbGKNQ3Sms6+rNt8tF+7Xk+usJ73MEA
Y1KeyeINtfj7s3/LM0a6u75B5s+gE/0ZdKI/38/7LWNWXGiX+7N06MbvGo7d
ZX6peGPX8qocH09VoeMN4JlZlW39JG4k5foG6F1Vf+ZXrwN/bnqV/qbS0AwF
fwaezU8N7/toshna0/JB4JnetmlSSogfT7zhUjyw+lTIHrHzLK79FIg3fneP
tUh2a6GcDyouZizPbv0GzwfNrJE0jOdeQ8JeVyYaolm68U3d6c/8eCbzZ9Cp
1p9B7+74WVie64csm+gU4U0nxhsDo+xGOEUEM4n7KcbX9tY6RvyC76cIy/Pe
JWfPzYy4gueDSQtua7fneVITtf4N/1269gf31DOhfwPiDRdFt8Ub/aVRiDfI
eAYdeBa0fwPywe9cTsuer7BEIR+Eep1uWMDSQco0vF4HPI+y3pQqtYXGU38u
2hGQ8CmRhnwpf7Y0mOlY1t8KJfLsdaDFe5CeFZ4PQvxcXLRuogvNqsviZzKe
V52OGlhX60l5P8Xb3vxtbe0+Hp6nJ0SG19YeF5ln0In+XLBDPmZdbSWTqj//
4v3Uoun5J579lFNXpA95/EeRlGeIn9NtXaPTDE1J80Etbv3Zf+ZYWbvHU1Co
P5P585XdU4yqs2YgwvrzO278fDdv6dbU2dZoNSF+NjSaOy5rmTVK5s85XJ7v
F7jqTthljW7n8ryV4M+r1m/JkUR/Noto6YPxzOE4kE7GM/Qjge5KiDc4cUZc
t+eDZP11nLhZCaG6n8Lh2IwnH+T4Mo0nH+T48tRu798g2x/kcGzDkw9y8kAb
RFLrz2T1DQ7H6yn7M+iS2i8K9Q3Qob5B4BkVdn9Q0HyQ3/4gWf2ZU3e2Ron1
Zw7H1pTrdaBDvKHErT9nsOvODmgGt/7cU+JncfXX8eMZ4o3JXzjeAJ2qP+vv
e8KON4jxM4ynGm/8yok3ePwZxhP9+U3/7+RY8QapP0P87KWpZsCKN3ji55tK
3z4rUbAm7d94Hd+R5z+L9gZ25s8OtR3jjUr7Oa1U6s/v00PNV8da4/WNeC7P
x07IyaSkW6Ntvd7ZdWe8Af38oFPtrwOd6M8jOPlgt8cb/OobgtafIR/U27vs
917bdRFi//P9d5oL3GebIV9qf/DSh+DTWD4o7v1Bce93n53FtMTyQUnxZ1/9
ZQ4pIT9SPp8CuqT2bwDPv4dVVxX7v6QLyzPUn0Ennk+ZUbz4bWXiBNL9FODZ
omx0X4srY1EynsGfS+Lk4mZVj0O+9j931MW1nyJunp2/qY+cHneCp38DxgvL
M8Qb6/ofMWiJeid0vMFvPwX6kRJO5GRL3x1G2i8qaPzc0/ZTYHx38yxo/Az1
jcZb45XcH3oxifUNGN/d8Qbkg16c/W4mMR+E8VTzwZOE/W6yfDBlgftVrx36
iLDxBvD8g2f6Y3UlY6H7n4X1Z9nC1wpHDhpLbH2DrB/p9K6E1oLwuTz1us77
kfz59SNRjp/PPl+xNj88lt7V/Ug2hpfbznvV0AXsRyLluav6kUAXrB/JnHI/
UnZw5q3AGwaIpPYjkfWLzrN/nGyYO5O0/izuflHQJb1fFHRi/8aB98qPYseq
8eSDQacfb74Yoy20P0M+6J/yq1bqCV2Eaj5o+GFP6/clugiR55/3XGkc9VwX
+bf0i4q7nz/ayuteSckqnvNWC15qHygp2SQx/aKgf76fv4py/wboxH5+0Kn2
8/uP1tn5iDEE/drPL5re08+ndPd5qxvX6nYnuUmjXX3eat+HhS8OlmsJXa/7
t563gnzQN/FOlWbaWKaoPPM7Dwvju9ufqZ2Hfdzl52FBFzV+HhufX2qzVIN0
f1DY87CgS6o/C3reStD9FEl9X0H91fKyTTq36KK+rwB0qvuDoIv6vgKjmSUB
83qrI1/fV9BR/zLvk1nSY98nA7qA75NhCtu/ATwrDN6flP9UVeR+frmY65rj
5g8Sun+jp/uzsO/7Ap3q+75gvKjv+wJdVJ7rR/015v2W60LHz8K+7wvmEfV9
X9lZiZN+ilZFqb7vK8T7ifvRW6qosP7cU3gW9/sYQZfUfBD2B+fsDNvXK7KQ
Lur7GEEn7nf3OzJi0KOnMqT73YLuD3bV+xh7KZw78/GgisjnB0HvKp69Hxdt
mlg0MLfRzWZRSgiNOfdC1SeMN4irLzTksPQReJ6oNe7X2ISMCnydRpWWP8lE
1zCi5i9cczz+Oa5LGae6sP7NV9f60TCM9Tlc37jv41HWvHx1Qa9L0HXyXU83
z+NhG7tizXRFRNzrCb/XeLj9PKMvnwrrbB66SiV7npF6cxv0A1XQ+VOGHO5s
PStdhntg81zMGaORvHoYaq52b3n79TRvue4j+x+1L3ZdajKNng0ntRCq1wU6
2XWRrWfFn4lO8SfH8FzXtgLTXzZfNkC7ip/mBA/s/3OdfttRn4mORKLKH8R0
Ns8Nq0DX9vNw/42vp5X9vMxRUdfDWccklGw9R7nztA3HPm+NcH4Lfn/Irovz
+UlCX5ek+ga/vwsf6cipVw8PI/27gHmc2TwPQ0T9+2KMr6/JRLUQUf++dHa/
SOlfoE7qG+A/oBP9h9/9AV3cftjT+RHXPBBvgE6MN0AXNt7gN74jP/1wfsjW
v1nTqVXzn76IsHEIv+vlt05B62/8vlfQuoe4xvPLQ8n2MYcxTMoKNg7C9+UF
vQ9k66/e56PUelsTJZuf3/r5zc9v3wrmLxz+zBbrSydbP4x/cNRMNaRWj3S8
oM9L0H1kvK+ePe9slCoPnHE00j58fuuBc6+c+zgVP/dKdk72Ys0s+dbbNJR4
/4nPl9/zgvWYazQMZN1/0n2cjucOhpJeL4zP3Dz4GxlEA6HKj6h8kvFGnF/c
/BDXI671Czqenw/DfbBh99v34fm7G6AcWlCSrIiQ+a2g+Szo20cVjQ1rkEfI
xkO8Me2HCpOan5T/F29wx6/82zg67ZAqzzz3lpgZjRw3mHT+jvnmUMrjqeoQ
/4MO8T/f/Itk/rmN2XWZqBVK1J0J+Rd8r8mx2an9C4b/Lw8S8rqChyiOWhyr
IfR97vgcdXmeo6j3mZ9eZbtWZ/BMeVzP6m/Jjq/48SzoeH51UX7jx4feEWh+
QccLup6v+le9J+oPTKbGta8b52U57niWOo1U//bt0tK7NGWE6nhx6Wfyxugq
ndUi/d5HXP3Z6435L2fooR9dGoLaj98dKJfzKd9Q6PWXcXXbxVF2oR4TkRCF
Pyith7sOfD0wD/fz+DxlhHnI5if7XtCJ90HQ+z/13VqPWPchaFc/d1GvS+qz
P/z5F9d4eI6XmRtqz95TxZ9vd61H2PVn11n0K/MY2uPWL2njK7jjcznjkFwJ
eb7Xx6+5mnjb4l//fHs6z8L6SYZDQ+/5U1RQca+Hn/5//DP7+g==
           "], VertexTextureCoordinates -> CompressedData["
1:eJyF23/Mn1V5gPE6hVUkGw1BsWqUoC5TYF0EhyIwplanZGxqGMNfrcMfZbAp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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox["\"a\"", HoldForm], TraditionalForm], 
           FormBox[
            TagBox["y", HoldForm], TraditionalForm], 
           FormBox[
            TagBox[
             TagBox[
              TemplateBox[{
                SuperscriptBox["\[ExponentialE]", "z"]}, "Abs"], HoldForm], 
             HoldForm], TraditionalForm]}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
         Directive[12], BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity,
          Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
         PlotRange -> {{-10., 10.}, {-10., 10.}, {0., 1751.1240850897245`}}, 
         PlotRangePadding -> {
           Scaled[0.02], 
           Scaled[0.02], 
           Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 2. The plot height is \
\\!\\(\\*FormBox[TagBox[TemplateBox[List[SuperscriptBox[\\\"\\\\[ExponentialE]\
\\\", \\\"z\\\"]], \\\"Abs\\\"], HoldForm], TraditionalForm]\\), and its \
color represents \\!\\(\\*FormBox[TagBox[RowBox[{\\\"arg\\\", \\\"(\\\", \
SuperscriptBox[\\\"\[ExponentialE]\\\", \\\"z\\\"], \\\")\\\"}], HoldForm], \
TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->1901218100,ExpressionUUID->"ce48e963-ad91-4227-aeeb-f69a749f6f97"]
}, {3}]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s also see the vector and stream plots for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", "z"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"13df2b33-8181-8b42-8f1c-c509711770aa"],
 "."
}], "Text",
 CellID->1049281835,ExpressionUUID->"31ab197f-4b73-dd4c-a359-67cf1db652b2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ComplexVectorPlot", "[", 
      RowBox[{
       RowBox[{"Exp", "[", "z", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "10"}], "}"}], ",", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["3", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["248", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[
        VectorScaling -> Automatic, ImageSize -> 200, PlotLegends -> 
         Automatic],
        SelectWithContents->True,
        Selectable->False]}], "]"}], ",", 
     RowBox[{"ComplexStreamPlot", "[", 
      RowBox[{
       RowBox[{"Exp", "[", "z", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "10"}], "}"}], ",", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["2", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["184", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[ImageSize -> 200, PlotLegends -> Automatic],
        SelectWithContents->True,
        Selectable->False]}], "]"}]}], "}"}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["448", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 3. Vector and stream plots for the function " <> ToString[
       Exp[$CellContext`z], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->353368493,ExpressionUUID->"8a080cbb-e59f-48b6-9bc1-db5303b98297"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       TemplateBox[{
         GraphicsBox[{{{{}}, {{
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.009375000000000001, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.196901211837346, -9.801412336520439}, \
{-9.553098788162654, -9.684159248629431}}]}}, {
                Arrowheads[{{0.009381590132899105, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-7.946776017737809, -9.801453547903478}, \
{-8.30322398226219, -9.684118037246385}}]}}, {
                Arrowheads[{{0.009393902122046794, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.696542124367455, -9.801530540903249}, \
{-7.053457875632545, -9.684041044246621}}]}}, {
                Arrowheads[{{0.009416903945999928, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.446105154023819, -9.801674382763816}, \
{-5.803894845976181, -9.683897202386055}}]}}, {
                Arrowheads[{{0.009459877010613928, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.195288785945804, -9.801943114738329}, \
{-4.554711214054196, -9.683628470411538}}]}}, {
                Arrowheads[{{0.009540161264857511, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-2.943763609584276, -9.802445172163349}, \
{-3.306236390415724, -9.683126412986521}}]}}, {
                Arrowheads[{{0.009690151998293562, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.6909142050124801`, -9.803383138918033}, \
{-2.05908579498752, -9.68218844623183}}]}}, {
                Arrowheads[{{0.009970371579687737, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.43559081644013364`, -9.805135491515689}, \
{-0.8144091835598664, -9.680436093634178}}]}}, {
                Arrowheads[{{0.01049389067982075, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.8243545827399936, -9.808409317172249}, {
                  0.4256454172600064, -9.677162267977614}}]}}, {
                Arrowheads[{{0.011471953122282814`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{2.092935034553316, -9.814525628720457}, {
                  1.657064965446684, -9.671045956429406}}]}}, {
                Arrowheads[{{0.013299214326528846`, 1.}}], {
                 LABColor[
                 0.21683031692199095`, 
                  0.5225458141022283, -0.7899032180425942], 
                 
                 ArrowBox[{{3.37764788854082, -9.825952403044793}, {
                  2.87235211145918, -9.659619182105073}}]}}, {
                Arrowheads[{{0.01671298768453423, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.692500037673909, -9.847300427982724}, {
                  4.057499962326091, -9.638271157167143}}]}}, {
                Arrowheads[{{0.023090755960217618`, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{6.0636598031225954`, -9.887183789272175}, {
                  5.1863401968774046`, -9.598387795877695}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 ArrowBox[{{7.409296364487961, -9.918665424411449}, {
                  6.340703635512039, -9.566906160738418}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.659296364487961, -9.918665424411449}, {
                  7.590703635512039, -9.566906160738418}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.909296364487961, -9.918665424411449}, {
                  8.840703635512039, -9.566906160738418}}]}}, {
                Arrowheads[{{0.009377784361693915, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.614638814232176, -8.530429212786537}, \
{-8.885361185767824, -8.790078862902234}}]}}, {
                Arrowheads[{{0.009386792005377786, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.364508795745612, -8.530304512140805}, \
{-7.635491204254388, -8.790203563547966}}]}}, {
                Arrowheads[{{0.009403620499276172, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.1142658892337, -8.530071540663526}, \
{-6.3857341107663, -8.790436535025245}}]}}, {
                Arrowheads[{{0.009435060264971514, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-4.863812080124784, -8.529636292642902}, \
{-5.136187919875216, -8.79087178304587}}]}}, {
                Arrowheads[{{0.009493797480134448, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.612964253091606, -8.528823142287894}, \
{-3.887035746908394, -8.791684933400877}}]}}, {
                Arrowheads[{{0.009603533044913421, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.36138030366427, -8.527303977424364}, \
{-2.63861969633573, -8.793204098264408}}]}}, {
                Arrowheads[{{0.009808546070198283, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.1084210965498733`, -8.524465803809397}, \
{-1.3915789034501267`, -8.796042271879374}}]}}, {
                Arrowheads[{{0.010191560825907695`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{
                  0.14710743017880418`, -8.519163397426748}, \
{-0.14710743017880418`, -8.801344678262023}}]}}, {
                Arrowheads[{{0.010907126594898658`, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.4074360778902117`, -8.509257198137703}, {
                  1.0925639221097883`, -8.811250877551068}}]}}, {
                Arrowheads[{{0.012243979450092927`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.67673253222279, -8.490749981362425}, {
                  2.32326746777721, -8.829758094326346}}]}}, {
                Arrowheads[{{0.014741549392491319`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.9627830550224057`, -8.45617394843869}, {
                  3.5372169449775943`, -8.86433412725008}}]}}, {
                Arrowheads[{{0.01940762434078136, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{5.2801342985061055`, -8.39157741470488}, {
                  4.7198657014938945`, -8.928930660983891}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.655962986872561, -8.270895201692554}, {
                  5.844037013127439, -9.049612873996217}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.905962986872561, -8.270895201692554}, {
                  7.094037013127439, -9.049612873996217}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.155962986872561, -8.270895201692554}, {
                  8.344037013127439, -9.049612873996217}}]}}, {
                Arrowheads[{{0.009375000000000003, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.42614226605715, -7.3973318215518695`}, \
{-9.32385773394285, -7.758112744675806}}]}}, {
                Arrowheads[{{0.0093815901328991, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-8.17617821638569, -7.3972050165262235`}, \
{-8.07382178361431, -7.7582395497014485`}}]}}, {
                Arrowheads[{{0.009393902122046795, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.9262453804416575`, -7.39696811354968}, \
{-6.8237546195583425`, -7.758476452677994}}]}}, {
                Arrowheads[{{0.009416903945999937, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.676370859417701, -7.396525520521449}, \
{-5.573629140582299, -7.758919045706227}}]}}, {
                Arrowheads[{{0.009459877010613932, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.4266052850074376`, -7.395698647885666}, \
{-4.3233947149925624`, -7.759745918342006}}]}}, {
                Arrowheads[{{0.009540161264857513, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-3.177043249667782, -7.394153846426557}, \
{-3.072956750332218, -7.761290719801117}}]}}, {
                Arrowheads[{{0.009690151998293563, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.9278614753739673`, -7.391267777345538}, \
{-1.8221385246260327`, -7.764176788882136}}]}}, {
                Arrowheads[{{0.00997037157968773, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.6793901222418164, -7.385875890452056}, \
{-0.5706098777581836, -7.769568675775616}}]}}, {
                Arrowheads[{{0.010493890679820756`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.5677539894269834, -7.375802519560377}, {
                  0.6822460105730166, -7.779642046667298}}]}}, {
                Arrowheads[{{0.011471953122282825`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{1.8124184875973406`, -7.35698298511428}, {
                  1.9375815124026594`, -7.798461581113395}}]}}, {
                Arrowheads[{{0.013299214326528839`, 1.}}], {
                 LABColor[
                 0.21683031692199095`, 
                  0.5225458141022283, -0.7899032180425942], 
                 
                 ArrowBox[{{3.0524504578732383`, -7.321823465964602}, {
                  3.1975495421267617`, -7.83362110026307}}]}}, {
                Arrowheads[{{0.016712987684534237`, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 ArrowBox[{{4.28382772663762, -7.256136836447958}, {
                  4.46617227336238, -7.899307729779714}}]}}, {
                Arrowheads[{{0.02309075596021761, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{5.49903588429033, -7.133418056396138}, {
                  5.75096411570967, -8.022026509831534}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.721573201828552, -7.036550898427935}, {
                  7.028426798171448, -8.11889366779974}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.9715732018285514`, -7.036550898427935}, {
                  8.278426798171449, -8.11889366779974}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.221573201828551, -7.036550898427935}, {
                  9.528426798171449, -8.11889366779974}}]}}, {
                Arrowheads[{{0.0093777843616939, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.933356491793864, -6.455724939184355}, \
{-8.566643508206136, -6.534656117582221}}]}}, {
                Arrowheads[{{0.009386792005377781, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.683532611214135, -6.455687031299981}, \
{-7.316467388785865, -6.534694025466596}}]}}, {
                Arrowheads[{{0.009403620499276188, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.433861645609081, -6.455616210048242}, \
{-6.066138354390919, -6.534764846718335}}]}}, {
                Arrowheads[{{0.009435060264971524, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-5.184476362787295, -6.45548389853098}, \
{-4.815523637212705, -6.534897158235596}}]}}, {
                Arrowheads[{{0.009493797480134455, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.9356248056704572`, -6.455236708073736}, \
{-3.5643751943295428`, -6.535144348692841}}]}}, {
                Arrowheads[{{0.009603533044913437, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.6877703794442667`, -6.454774895501273}, \
{-2.3122296205557333`, -6.535606161265304}}]}}, {
                Arrowheads[{{0.009808546070198288, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.4417788389735586`, -6.453912116029677}, \
{-1.0582211610264414`, -6.536468940736899}}]}}, {
                Arrowheads[{{0.01019156082590769, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{-0.19926762728468955`, -6.452300231769712}, {
                  0.19926762728468955`, -6.5380808249968645`}}]}}, {
                Arrowheads[{{0.010907126594898661`, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.0367414742269747`, -6.4492888355171845`}, {
                  1.4632585257730253`, -6.541092221249392}}]}}, {
                Arrowheads[{{0.012243979450092916`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.2606030346852966`, -6.443662806642174}, {
                  2.7393969653147034`, -6.546718250124402}}]}}, {
                Arrowheads[{{0.014741549392491341`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.4617700006779693`, -6.433152000940037}, {
                  4.038229999322031, -6.557229055826539}}]}}, {
                Arrowheads[{{0.01940762434078136, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{4.620537882304632, -6.413515230677666}, {
                  5.379462117695368, -6.576865826088911}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{5.7000938459656645`, -6.376828914017964}, {
                  6.7999061540343355`, -6.613552142748612}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.9500938459656645`, -6.376828914017965}, {
                  8.049906154034336, -6.6135521427486115`}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.200093845965664, -6.376828914017965}, {
                  9.299906154034336, -6.6135521427486115`}}]}}, {
                Arrowheads[{{0.009374999999999998, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.495829502449247, -5.556034090000665}, \
{-9.254170497550753, -5.269283457304816}}]}}, {
                Arrowheads[{{0.009381590132899121, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-8.245914439247036, -5.556134875322178}, \
{-8.004085560752964, -5.269182671983303}}]}}, {
                Arrowheads[{{0.009393902122046802, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.996073122076142, -5.556323167091663}, \
{-6.753926877923858, -5.268994380213818}}]}}, {
                Arrowheads[{{0.00941690394599994, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.746369580630136, -5.556674942428822}, \
{-5.503630419369864, -5.268642604876659}}]}}, {
                Arrowheads[{{0.009459877010613946, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.496923438125179, -5.557332145280393}, \
{-4.253076561874821, -5.267985402025088}}]}}, {
                Arrowheads[{{0.00954016126485752, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-3.2479581801512865`, -5.558559961851051}, \
{-3.0020418198487135`, -5.26675758545443}}]}}, {
                Arrowheads[{{0.009690151998293551, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.9998913327585477`, -5.560853825195654}, \
{-1.7501086672414523`, -5.264463722109827}}]}}, {
                Arrowheads[{{0.00997037157968774, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.753502937302163, -5.56513932611611}, \
{-0.496497062697837, -5.260178221189371}}]}}, {
                Arrowheads[{{0.010493890679820756`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.48974969710938365`, -5.573145695886323}, {
                  0.7602503028906163, -5.252171851419158}}]}}, {
                Arrowheads[{{0.011471953122282814`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 ArrowBox[{{1.7271439586254385`, -5.588103563843232}, {
                  2.0228560413745615`, -5.237213983462249}}]}}, {
                Arrowheads[{{0.01329921432652886, 1.}}], {
                 LABColor[
                 0.21683031692199092`, 
                  0.5225458141022283, -0.7899032180425943], 
                 
                 ArrowBox[{{2.95359333866236, -5.616048540185533}, {
                  3.29640666133764, -5.209269007119948}}]}}, {
                Arrowheads[{{0.01671298768453424, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.159594988121317, -5.6682566292675745`}, {
                  4.590405011878683, -5.157060918037907}}]}}, {
                Arrowheads[{{0.02309075596021764, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{5.327395247589326, -5.76579418064036}, {
                  5.922604752410674, -5.059523366665121}}]}}, {
                Arrowheads[{{0.028125000000000004`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.51251149265226, -5.842784722696515}, {
                  7.23748850734774, -4.982532824608966}}]}}, {
                Arrowheads[{{0.028125000000000004`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.76251149265226, -5.842784722696515}, {
                  8.48748850734774, -4.982532824608966}}]}}, {
                Arrowheads[{{0.028125000000000004`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.01251149265226, -5.842784722696515}, {
                  9.73748850734774, -4.982532824608966}}]}}, {
                Arrowheads[{{0.00937778436169393, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.680037954602886, -4.504145546722036}, \
{-8.819962045397114, -4.15610849112235}}]}}, {
                Arrowheads[{{0.009386792005377781, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.429970753955908, -4.504312696747282}, \
{-7.570029246044092, -4.155941341097104}}]}}, {
                Arrowheads[{{0.009403620499276184, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.179845206618853, -4.504624974106234}, \
{-6.320154793381147, -4.155629063738152}}]}}, {
                Arrowheads[{{0.00943506026497152, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-4.929610653313935, -4.505208385019692}, \
{-5.070389346686065, -4.155045652824693}}]}}, {
                Arrowheads[{{0.009493797480134441, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.6791724500502174`, -4.506298340100283}, \
{-3.8208275499497826`, -4.153955697744102}}]}}, {
                Arrowheads[{{0.00960353304491343, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.4283537785742446`, -4.508334644273381}, \
{-2.5716462214257554`, -4.151919393571005}}]}}, {
                Arrowheads[{{0.009808546070198288, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.1768242988987927`, -4.512138961312871}, \
{-1.3231757011012073`, -4.148115076531514}}]}}, {
                Arrowheads[{{0.010191560825907683`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{
                  0.07603314532184455, -4.519246361242691}, \
{-0.07603314532184455, -4.141007676601695}}]}}, {
                Arrowheads[{{0.01090712659489867, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.331371553935638, -4.53252473242943}, {
                  1.168628446064362, -4.127729305414955}}]}}, {
                Arrowheads[{{0.01224397945009292, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.5913450142474797`, -4.55733199572034}, {
                  2.4086549857525203`, -4.102922042124045}}]}}, {
                Arrowheads[{{0.014741549392491319`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.8599778911566878`, -4.60367806507854}, {
                  3.6400221088433122`, -4.056575972765845}}]}}, {
                Arrowheads[{{0.01940762434078135, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{5.144788688117648, -4.69026392179987}, {
                  4.855211311882352, -3.9699901160445155`}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.459823818814958, -4.852027598590301}, {
                  6.040176181185042, -3.808226439254084}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.709823818814958, -4.852027598590301}, {
                  7.290176181185042, -3.808226439254084}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.959823818814957, -4.852027598590301}, {
                  8.540176181185043, -3.808226439254084}}]}}, {
                Arrowheads[{{0.009375000000000019, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.188552440848444, -3.2674335525862364`}, \
{-9.561447559151556, -3.227756975797052}}]}}, {
                Arrowheads[{{0.009381590132899067, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-7.938421378001136, -3.2674474978616512`}, \
{-8.311578621998864, -3.227743030521637}}]}}, {
                Arrowheads[{{0.009393902122046808, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.68817652036648, -3.267473551066069}, \
{-7.06182347963352, -3.227716977317219}}]}}, {
                Arrowheads[{{0.009416903945999932, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.43771906608039, -3.2675222248599023`}, \
{-5.81228093391961, -3.227668303523386}}]}}, {
                Arrowheads[{{0.009459877010613934, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.186864428959693, -3.2676131594784636`}, \
{-4.563135571040307, -3.2275773689048246`}}]}}, {
                Arrowheads[{{0.009540161264857528, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-2.9352677566138765`, -3.2677830477119816`}, \
{-3.3147322433861235`, -3.2274074806713067`}}]}}, {
                Arrowheads[{{0.009690151998293556, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.6822847799584633`, -3.2681004407174665`}, \
{-2.0677152200415367`, -3.2270900876658217`}}]}}, {
                Arrowheads[{{0.009970371579687736, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.4267118458808723, -3.2686934089168806`}, \
{-0.8232881541191277, -3.2264971194664076`}}]}}, {
                Arrowheads[{{0.010493890679820754`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.8336997656806232, -3.2698012193583224`}, {
                  0.4163002343193768, -3.225389309024966}}]}}, {
                Arrowheads[{{0.011471953122282823`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{2.103151216890742, -3.271870881737147}, {
                  1.6468487831092582`, -3.223319646646141}}]}}, {
                Arrowheads[{{0.013299214326528853`, 1.}}], {
                 LABColor[
                 0.21683031692199092`, 
                  0.5225458141022283, -0.7899032180425943], 
                 
                 ArrowBox[{{3.389491311980236, -3.2757375201096357`}, {
                  2.860508688019764, -3.2194530082736526`}}]}}, {
                Arrowheads[{{0.016712987684534244`, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.707383547723886, -3.2829613516178906`}, {
                  4.042616452276114, -3.2122291767653977`}}]}}, {
                Arrowheads[{{0.023090755960217632`, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{6.084222942692994, -3.2964572456303585`}, {
                  5.165777057307006, -3.19873328275293}}]}}, {
                Arrowheads[{{0.028124999999999994`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.4343426774546675`, -3.3071101293754213`}, {
                  6.3156573225453325`, -3.188080399007867}}]}}, {
                Arrowheads[{{0.028124999999999994`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.684342677454667, -3.3071101293754213`}, {
                  7.5656573225453325`, -3.188080399007867}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.93434267745467, -3.3071101293754213`}, {
                  8.81565732254533, -3.188080399007867}}]}}, {
                Arrowheads[{{0.009377784361693921, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.644987247657657, -2.0096625517444267`}, \
{-8.855012752342343, -2.3204644671777643`}}]}}, {
                Arrowheads[{{0.009386792005377792, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.394886379753375, -2.009513284454707}, \
{-7.605113620246625, -2.320613734467484}}]}}, {
                Arrowheads[{{0.009403620499276191, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.144697933698968, -2.0092344164441114`}, \
{-6.355302066301032, -2.3208926024780796`}}]}}, {
                Arrowheads[{{0.009435060264971514, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-4.8943458701196265`, -2.0087134224106595`}, \
{-5.1056541298803735`, -2.3214135965115315`}}]}}, {
                Arrowheads[{{0.009493797480134451, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.643688128760764, -2.007740077413816}, \
{-3.856311871239236, -2.322386941508375}}]}}, {
                Arrowheads[{{0.009603533044913423, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.3924593061260317`, -2.005921629558277}, \
{-2.6075406938739683`, -2.324205389363914}}]}}, {
                Arrowheads[{{0.009808546070198291, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.1401635632062934`, -2.002524321703364}, \
{-1.3598364367937066`, -2.327602697218827}}]}}, {
                Arrowheads[{{0.010191560825907681`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{
                  0.11412544922281195`, -1.9961773150372712`}, \
{-0.11412544922281195`, -2.3339497038849197`}}]}}, {
                Arrowheads[{{0.010907126594898653`, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.3721383793548645`, -1.9843195454915472`}, {
                  1.1278616206451355`, -2.3458074734306438`}}]}}, {
                Arrowheads[{{0.012243979450092915`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.6371085036812585`, -1.9621663154735853`}, {
                  2.3628914963187415`, -2.3679607034486057`}}]}}, {
                Arrowheads[{{0.014741549392491324`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.915076377936302, -1.9207786330484615`}, {
                  3.584923622063698, -2.4093483858737295`}}]}}, {
                Arrowheads[{{0.01940762434078136, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{5.2173272459512585`, -1.843456262670236}, {
                  4.7826727540487415`, -2.486670756251955}}]}}, {
                Arrowheads[{{0.028124999999999994`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.5649447188925265`, -1.6989990567920392`}, {
                  5.9350552811074735`, -2.6311279621301518`}}]}}, {
                Arrowheads[{{0.028124999999999983`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.8149447188925265`, -1.6989990567920392`}, {
                  7.1850552811074735`, -2.6311279621301518`}}]}}, {
                Arrowheads[{{0.028124999999999983`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.064944718892527, -1.6989990567920392`}, {
                  8.435055281107473, -2.6311279621301518`}}]}}, {
                Arrowheads[{{0.009375000000000007, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.46295511659141, -0.916941454696423}, \
{-9.28704488340859, -1.2481220547646725`}}]}}, {
                Arrowheads[{{0.00938159013289912, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-8.213016944421543, -0.91682505340746}, \
{-8.036983055578457, -1.2482384560536355`}}]}}, {
                Arrowheads[{{0.0093939021220468, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.963132454015245, -0.9166075871699151}, \
{-6.786867545984755, -1.2484559222911804`}}]}}, {
                Arrowheads[{{0.009416903945999932, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.713348254346723, -0.9162013067507437}, \
{-5.536651745653277, -1.2488622027103518`}}]}}, {
                Arrowheads[{{0.00945987701061394, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.463751422443622, -0.915442275000043}, \
{-4.286248577556378, -1.2496212344610524`}}]}}, {
                Arrowheads[{{0.009540161264857525, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-3.2145046396108157`, -0.9140242170002337}, \
{-3.0354953603891843`, -1.2510392924608618`}}]}}, {
                Arrowheads[{{0.009690151998293563, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.9659118345384954`, -0.9113749358746859}, \
{-1.7840881654615046`, -1.2536885735864096`}}]}}, {
                Arrowheads[{{0.009970371579687737, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.7185408207734524, -0.9064254271217793}, \
{-0.5314591792265476, -1.2586380823393162`}}]}}, {
                Arrowheads[{{0.010493890679820752`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.5265475863209446, -0.8971785274028865}, {
                  0.7234524136790554, -1.267884982058209}}]}}, {
                Arrowheads[{{0.011471953122282812`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{1.7673715227304987`, -0.8799030443842837}, {
                  1.9826284772695013`, -1.2851604650768118`}}]}}, {
                Arrowheads[{{0.013299214326528854`, 1.}}], {
                 LABColor[
                 0.21683031692199095`, 
                  0.5225458141022283, -0.7899032180425942], 
                 
                 ArrowBox[{{3.000228379022507, -0.8476281930720897}, {
                  3.249771620977493, -1.3174353163890058`}}]}}, {
                Arrowheads[{{0.01671298768453424, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.2182007700923725`, -0.7873308325813575}, {
                  4.5317992299076275`, -1.377732676879738}}]}}, {
                Arrowheads[{{0.02309075596021764, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{5.408365319182428, -0.6746805326007137}, {
                  5.841634680817572, -1.4903829768603818`}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.61113465022577, -0.5857608546281734}, {
                  7.13886534977423, -1.579302654832922}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.86113465022577, -0.5857608546281734}, {
                  8.38886534977423, -1.579302654832922}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.11113465022577, -0.5857608546281734}, {
                  9.63886534977423, -1.579302654832922}}]}}, {
                Arrowheads[{{0.00937778436169392, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.937555687233878, 0.}, {-8.562444312766122, 
                  0.}}]}}, {
                Arrowheads[{{0.009386792005377797, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.687735840107556, 0.}, {-7.312264159892444, 
                  0.}}]}}, {
                Arrowheads[{{0.009403620499276188, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.438072409985524, 0.}, {-6.061927590014476, 
                  0.}}]}}, {
                Arrowheads[{{0.009435060264971517, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 ArrowBox[{{-5.188701205299431, 0.}, {-4.811298794700569, 
                  0.}}]}}, {
                Arrowheads[{{0.009493797480134448, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.9398759496026887`, 0.}, {-3.5601240503973113`, 
                  0.}}]}}, {
                Arrowheads[{{0.009603533044913426, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.6920706608982683`, 0.}, {-2.3079293391017317`, 
                  0.}}]}}, {
                Arrowheads[{{0.009808546070198293, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.446170921403966, 0.}, {-1.053829078596034, 
                  0.}}]}}, {
                Arrowheads[{{0.010191560825907688`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{-0.20383121651815378`, 0.}, {0.20383121651815378`,
                   0.}}]}}, {
                Arrowheads[{{0.010907126594898658`, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.031857468102027, 0.}, {1.468142531897973, 
                  0.}}]}}, {
                Arrowheads[{{0.012243979450092923`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.2551204109981415`, 0.}, {2.7448795890018585`, 
                  0.}}]}}, {
                Arrowheads[{{0.014741549392491338`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.455169012150173, 0.}, {4.044830987849827, 
                  0.}}]}}, {
                Arrowheads[{{0.01940762434078136, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{4.611847513184372, 0.}, {5.388152486815628, 
                  0.}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 ArrowBox[{{5.6875, 0.}, {6.8125, 0.}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 ArrowBox[{{6.9375, 0.}, {8.0625, 0.}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 ArrowBox[{{8.1875, 0.}, {9.3125, 0.}}]}}, {
                Arrowheads[{{0.009375000000000007, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.46295511659141, 
                  0.916941454696423}, {-9.28704488340859, 
                  1.2481220547646725`}}]}}, {
                Arrowheads[{{0.00938159013289912, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-8.213016944421543, 
                  0.91682505340746}, {-8.036983055578457, 
                  1.2482384560536355`}}]}}, {
                Arrowheads[{{0.0093939021220468, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.963132454015245, 
                  0.9166075871699151}, {-6.786867545984755, 
                  1.2484559222911804`}}]}}, {
                Arrowheads[{{0.009416903945999932, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.713348254346723, 
                  0.9162013067507437}, {-5.536651745653277, 
                  1.2488622027103518`}}]}}, {
                Arrowheads[{{0.00945987701061394, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.463751422443622, 
                  0.915442275000043}, {-4.286248577556378, 
                  1.2496212344610524`}}]}}, {
                Arrowheads[{{0.009540161264857525, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-3.2145046396108157`, 
                  0.9140242170002337}, {-3.0354953603891843`, 
                  1.2510392924608618`}}]}}, {
                Arrowheads[{{0.009690151998293563, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.9659118345384954`, 
                  0.9113749358746859}, {-1.7840881654615046`, 
                  1.2536885735864096`}}]}}, {
                Arrowheads[{{0.009970371579687737, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.7185408207734524, 
                  0.9064254271217793}, {-0.5314591792265476, 
                  1.2586380823393162`}}]}}, {
                Arrowheads[{{0.010493890679820752`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.5265475863209446, 0.8971785274028865}, {
                  0.7234524136790554, 1.267884982058209}}]}}, {
                Arrowheads[{{0.011471953122282812`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{1.7673715227304987`, 0.8799030443842837}, {
                  1.9826284772695013`, 1.2851604650768118`}}]}}, {
                Arrowheads[{{0.013299214326528854`, 1.}}], {
                 LABColor[
                 0.21683031692199095`, 
                  0.5225458141022283, -0.7899032180425942], 
                 
                 ArrowBox[{{3.000228379022507, 0.8476281930720897}, {
                  3.249771620977493, 1.3174353163890058`}}]}}, {
                Arrowheads[{{0.01671298768453424, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.2182007700923725`, 0.7873308325813575}, {
                  4.5317992299076275`, 1.377732676879738}}]}}, {
                Arrowheads[{{0.02309075596021764, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{5.408365319182428, 0.6746805326007137}, {
                  5.841634680817572, 1.4903829768603818`}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.61113465022577, 0.5857608546281734}, {
                  7.13886534977423, 1.579302654832922}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.86113465022577, 0.5857608546281734}, {
                  8.38886534977423, 1.579302654832922}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.11113465022577, 0.5857608546281734}, {
                  9.63886534977423, 1.579302654832922}}]}}, {
                Arrowheads[{{0.009377784361693921, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.644987247657657, 
                  2.0096625517444284`}, {-8.855012752342343, 
                  2.320464467177766}}]}}, {
                Arrowheads[{{0.009386792005377795, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.394886379753375, 
                  2.0095132844547092`}, {-7.605113620246625, 
                  2.3206137344674853`}}]}}, {
                Arrowheads[{{0.009403620499276174, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.144697933698967, 
                  2.0092344164441136`}, {-6.355302066301033, 
                  2.320892602478081}}]}}, {
                Arrowheads[{{0.009435060264971526, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-4.894345870119626, 
                  2.0087134224106613`}, {-5.105654129880374, 
                  2.3214135965115332`}}]}}, {
                Arrowheads[{{0.009493797480134455, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.643688128760763, 
                  2.007740077413818}, {-3.856311871239237, 
                  2.3223869415083764`}}]}}, {
                Arrowheads[{{0.009603533044913437, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.3924593061260317`, 
                  2.0059216295582787`}, {-2.6075406938739683`, 
                  2.324205389363916}}]}}, {
                Arrowheads[{{0.009808546070198296, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.140163563206293, 
                  2.0025243217033664`}, {-1.359836436793707, 
                  2.327602697218828}}]}}, {
                Arrowheads[{{0.010191560825907688`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{0.1141254492228123, 
                  1.996177315037273}, {-0.1141254492228123, 
                  2.3339497038849215`}}]}}, {
                Arrowheads[{{0.010907126594898658`, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.372138379354865, 1.984319545491549}, {
                  1.127861620645135, 2.3458074734306456`}}]}}, {
                Arrowheads[{{0.012243979450092918`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.637108503681259, 1.962166315473587}, {
                  2.362891496318741, 2.3679607034486074`}}]}}, {
                Arrowheads[{{0.014741549392491319`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.9150763779363023`, 1.9207786330484637`}, {
                  3.5849236220636977`, 2.409348385873731}}]}}, {
                Arrowheads[{{0.019407624340781367`, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{5.217327245951259, 1.8434562626702382`}, {
                  4.782672754048741, 2.4866707562519563`}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.564944718892527, 1.698999056792041}, {
                  5.935055281107473, 2.6311279621301535`}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.814944718892527, 1.6989990567920414`}, {
                  7.185055281107473, 2.631127962130153}}]}}, {
                Arrowheads[{{0.02812499999999999, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.064944718892528, 1.6989990567920414`}, {
                  8.435055281107472, 2.631127962130153}}]}}, {
                Arrowheads[{{0.00937500000000002, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.188552440848444, 
                  3.2674335525862377`}, {-9.561447559151556, 
                  3.2277569757970523`}}]}}, {
                Arrowheads[{{0.009381590132899067, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-7.938421378001136, 
                  3.267447497861652}, {-8.311578621998864, 
                  3.227743030521638}}]}}, {
                Arrowheads[{{0.009393902122046808, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.68817652036648, 
                  3.2674735510660704`}, {-7.06182347963352, 
                  3.2277169773172196`}}]}}, {
                Arrowheads[{{0.009416903945999911, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.4377190660803905`, 
                  3.2675222248599036`}, {-5.8122809339196095`, 
                  3.2276683035233864`}}]}}, {
                Arrowheads[{{0.009459877010613913, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.186864428959693, 
                  3.267613159478465}, {-4.563135571040307, 
                  3.227577368904825}}]}}, {
                Arrowheads[{{0.00954016126485752, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-2.935267756613877, 
                  3.2677830477119825`}, {-3.314732243386123, 
                  3.2274074806713076`}}]}}, {
                Arrowheads[{{0.009690151998293556, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.6822847799584633`, 
                  3.2681004407174674`}, {-2.0677152200415367`, 
                  3.2270900876658226`}}]}}, {
                Arrowheads[{{0.009970371579687737, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.4267118458808723, 
                  3.2686934089168815`}, {-0.8232881541191277, 
                  3.2264971194664085`}}]}}, {
                Arrowheads[{{0.010493890679820756`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.8336997656806232, 3.2698012193583232`}, {
                  0.4163002343193768, 3.225389309024967}}]}}, {
                Arrowheads[{{0.01147195312228282, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{2.103151216890742, 3.271870881737148}, {
                  1.6468487831092582`, 3.223319646646142}}]}}, {
                Arrowheads[{{0.013299214326528853`, 1.}}], {
                 LABColor[
                 0.21683031692199092`, 
                  0.5225458141022283, -0.7899032180425943], 
                 
                 ArrowBox[{{3.389491311980236, 3.275737520109637}, {
                  2.860508688019764, 3.219453008273653}}]}}, {
                Arrowheads[{{0.016712987684534247`, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.707383547723886, 3.2829613516178915`}, {
                  4.042616452276114, 3.2122291767653985`}}]}}, {
                Arrowheads[{{0.023090755960217636`, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{6.084222942692994, 3.29645724563036}, {
                  5.165777057307006, 3.1987332827529302`}}]}}, {
                Arrowheads[{{0.028124999999999994`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.4343426774546675`, 3.307110129375422}, {
                  6.3156573225453325`, 3.188080399007868}}]}}, {
                Arrowheads[{{0.028124999999999973`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.684342677454667, 3.307110129375422}, {
                  7.5656573225453325`, 3.188080399007868}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.93434267745467, 3.307110129375422}, {
                  8.81565732254533, 3.188080399007868}}]}}, {
                Arrowheads[{{0.00937778436169393, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.680037954602886, 
                  4.504145546722036}, {-8.819962045397114, 
                  4.15610849112235}}]}}, {
                Arrowheads[{{0.009386792005377781, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.429970753955908, 
                  4.504312696747282}, {-7.570029246044092, 
                  4.155941341097104}}]}}, {
                Arrowheads[{{0.009403620499276184, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.179845206618853, 
                  4.504624974106234}, {-6.320154793381147, 
                  4.155629063738152}}]}}, {
                Arrowheads[{{0.00943506026497152, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-4.929610653313935, 
                  4.505208385019692}, {-5.070389346686065, 
                  4.155045652824693}}]}}, {
                Arrowheads[{{0.009493797480134441, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.6791724500502174`, 
                  4.506298340100283}, {-3.8208275499497826`, 
                  4.153955697744102}}]}}, {
                Arrowheads[{{0.00960353304491343, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.4283537785742446`, 
                  4.508334644273381}, {-2.5716462214257554`, 
                  4.151919393571005}}]}}, {
                Arrowheads[{{0.009808546070198288, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.1768242988987927`, 
                  4.512138961312871}, {-1.3231757011012073`, 
                  4.148115076531514}}]}}, {
                Arrowheads[{{0.010191560825907683`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{0.07603314532184455, 
                  4.519246361242691}, {-0.07603314532184455, 
                  4.141007676601695}}]}}, {
                Arrowheads[{{0.01090712659489867, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.331371553935638, 4.53252473242943}, {
                  1.168628446064362, 4.127729305414955}}]}}, {
                Arrowheads[{{0.01224397945009292, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.5913450142474797`, 4.55733199572034}, {
                  2.4086549857525203`, 4.102922042124045}}]}}, {
                Arrowheads[{{0.014741549392491319`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.8599778911566878`, 4.60367806507854}, {
                  3.6400221088433122`, 4.056575972765845}}]}}, {
                Arrowheads[{{0.01940762434078135, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{5.144788688117648, 4.69026392179987}, {
                  4.855211311882352, 3.9699901160445155`}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.459823818814958, 4.852027598590301}, {
                  6.040176181185042, 3.808226439254084}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.709823818814958, 4.852027598590301}, {
                  7.290176181185042, 3.808226439254084}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.959823818814957, 4.852027598590301}, {
                  8.540176181185043, 3.808226439254084}}]}}, {
                Arrowheads[{{0.00937500000000001, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.495829502449247, 
                  5.556034090000667}, {-9.254170497550753, 
                  5.269283457304818}}]}}, {
                Arrowheads[{{0.009381590132899104, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-8.245914439247036, 
                  5.556134875322179}, {-8.004085560752964, 
                  5.269182671983305}}]}}, {
                Arrowheads[{{0.0093939021220468, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.996073122076143, 
                  5.556323167091665}, {-6.753926877923857, 
                  5.26899438021382}}]}}, {
                Arrowheads[{{0.009416903945999925, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.746369580630136, 
                  5.556674942428823}, {-5.503630419369864, 
                  5.2686426048766615`}}]}}, {
                Arrowheads[{{0.009459877010613928, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.496923438125179, 
                  5.557332145280394}, {-4.253076561874821, 
                  5.267985402025091}}]}}, {
                Arrowheads[{{0.009540161264857534, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-3.2479581801512865`, 
                  5.558559961851053}, {-3.0020418198487135`, 
                  5.266757585454432}}]}}, {
                Arrowheads[{{0.009690151998293563, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.999891332758548, 
                  5.560853825195656}, {-1.750108667241452, 
                  5.264463722109829}}]}}, {
                Arrowheads[{{0.00997037157968773, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.7535029373021632, 
                  5.565139326116111}, {-0.4964970626978368, 
                  5.260178221189373}}]}}, {
                Arrowheads[{{0.010493890679820745`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.48974969710938343`, 5.573145695886325}, {
                  0.7602503028906166, 5.25217185141916}}]}}, {
                Arrowheads[{{0.011471953122282818`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{1.7271439586254385`, 5.588103563843234}, {
                  2.0228560413745615`, 5.237213983462251}}]}}, {
                Arrowheads[{{0.01329921432652885, 1.}}], {
                 LABColor[
                 0.21683031692199092`, 
                  0.5225458141022283, -0.7899032180425943], 
                 
                 ArrowBox[{{2.9535933386623596`, 5.616048540185535}, {
                  3.2964066613376404`, 5.20926900711995}}]}}, {
                Arrowheads[{{0.016712987684534254`, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.159594988121317, 5.668256629267576}, {
                  4.590405011878683, 5.157060918037908}}]}}, {
                Arrowheads[{{0.023090755960217636`, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{5.327395247589325, 5.765794180640361}, {
                  5.922604752410675, 5.059523366665124}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.512511492652259, 5.842784722696516}, {
                  7.237488507347741, 4.982532824608969}}]}}, {
                Arrowheads[{{0.02812500000000001, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.7625114926522585`, 5.842784722696516}, {
                  8.487488507347742, 4.982532824608969}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.012511492652258, 5.842784722696516}, {
                  9.737488507347742, 4.982532824608969}}]}}, {
                Arrowheads[{{0.0093777843616939, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.933356491793864, 
                  6.455724939184355}, {-8.566643508206136, 
                  6.534656117582221}}]}}, {
                Arrowheads[{{0.009386792005377781, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.683532611214135, 
                  6.455687031299981}, {-7.316467388785865, 
                  6.534694025466596}}]}}, {
                Arrowheads[{{0.009403620499276188, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.433861645609081, 
                  6.455616210048242}, {-6.066138354390919, 
                  6.534764846718335}}]}}, {
                Arrowheads[{{0.009435060264971524, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-5.184476362787295, 
                  6.45548389853098}, {-4.815523637212705, 
                  6.534897158235596}}]}}, {
                Arrowheads[{{0.009493797480134455, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.9356248056704572`, 
                  6.455236708073736}, {-3.5643751943295428`, 
                  6.535144348692841}}]}}, {
                Arrowheads[{{0.009603533044913437, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.6877703794442667`, 
                  6.454774895501273}, {-2.3122296205557333`, 
                  6.535606161265304}}]}}, {
                Arrowheads[{{0.009808546070198288, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.4417788389735586`, 
                  6.453912116029677}, {-1.0582211610264414`, 
                  6.536468940736899}}]}}, {
                Arrowheads[{{0.01019156082590769, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{-0.19926762728468955`, 6.452300231769712}, {
                  0.19926762728468955`, 6.5380808249968645`}}]}}, {
                Arrowheads[{{0.010907126594898661`, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.0367414742269747`, 6.4492888355171845`}, {
                  1.4632585257730253`, 6.541092221249392}}]}}, {
                Arrowheads[{{0.012243979450092916`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.2606030346852966`, 6.443662806642174}, {
                  2.7393969653147034`, 6.546718250124402}}]}}, {
                Arrowheads[{{0.014741549392491341`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.4617700006779693`, 6.433152000940037}, {
                  4.038229999322031, 6.557229055826539}}]}}, {
                Arrowheads[{{0.01940762434078136, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{4.620537882304632, 6.413515230677666}, {
                  5.379462117695368, 6.576865826088911}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{5.7000938459656645`, 6.376828914017964}, {
                  6.7999061540343355`, 6.613552142748612}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.9500938459656645`, 6.376828914017965}, {
                  8.049906154034336, 6.6135521427486115`}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.200093845965664, 6.376828914017965}, {
                  9.299906154034336, 6.6135521427486115`}}]}}, {
                Arrowheads[{{0.009375000000000024, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.426142266057148, 
                  7.3973318215518695`}, {-9.323857733942852, 
                  7.758112744675806}}]}}, {
                Arrowheads[{{0.0093815901328991, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-8.17617821638569, 
                  7.397205016526225}, {-8.07382178361431, 
                  7.75823954970145}}]}}, {
                Arrowheads[{{0.009393902122046795, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.9262453804416575`, 
                  7.396968113549681}, {-6.8237546195583425`, 
                  7.758476452677995}}]}}, {
                Arrowheads[{{0.009416903945999937, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.676370859417701, 
                  7.396525520521449}, {-5.573629140582299, 
                  7.758919045706227}}]}}, {
                Arrowheads[{{0.009459877010613932, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.4266052850074376`, 
                  7.395698647885668}, {-4.3233947149925624`, 
                  7.759745918342007}}]}}, {
                Arrowheads[{{0.009540161264857532, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-3.1770432496677814`, 
                  7.394153846426557}, {-3.0729567503322186`, 
                  7.761290719801119}}]}}, {
                Arrowheads[{{0.009690151998293563, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.9278614753739673`, 
                  7.391267777345539}, {-1.8221385246260327`, 
                  7.7641767888821365`}}]}}, {
                Arrowheads[{{0.00997037157968773, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.6793901222418163, 
                  7.385875890452057}, {-0.5706098777581837, 
                  7.769568675775618}}]}}, {
                Arrowheads[{{0.010493890679820731`, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.5677539894269835, 7.375802519560377}, {
                  0.6822460105730165, 7.779642046667298}}]}}, {
                Arrowheads[{{0.011471953122282798`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{1.8124184875973408`, 7.35698298511428}, {
                  1.9375815124026592`, 7.798461581113395}}]}}, {
                Arrowheads[{{0.013299214326528858`, 1.}}], {
                 LABColor[
                 0.21683031692199092`, 
                  0.5225458141022283, -0.7899032180425943], 
                 
                 ArrowBox[{{3.0524504578732388`, 7.321823465964603}, {
                  3.1975495421267612`, 7.8336211002630725`}}]}}, {
                Arrowheads[{{0.016712987684534254`, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.622283725523013], 
                 
                 ArrowBox[{{4.283827726637621, 7.256136836447959}, {
                  4.466172273362379, 7.899307729779717}}]}}, {
                Arrowheads[{{0.023090755960217625`, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{5.499035884290331, 7.13341805639614}, {
                  5.750964115709669, 8.022026509831536}}]}}, {
                Arrowheads[{{0.02812500000000002, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.721573201828553, 7.036550898427935}, {
                  7.028426798171447, 8.118893667799743}}]}}, {
                Arrowheads[{{0.02812500000000002, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.971573201828553, 7.036550898427935}, {
                  8.278426798171447, 8.118893667799743}}]}}, {
                Arrowheads[{{0.028124999999999976`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.221573201828553, 7.036550898427935}, {
                  9.528426798171447, 8.11889366779974}}]}}, {
                Arrowheads[{{0.009377784361693885, 1.}}], {
                 LABColor[
                 0.18866761337544297`, 
                  0.5225961011139685, -0.8572105441276864], 
                 
                 ArrowBox[{{-8.614638814232176, 
                  8.530429212786537}, {-8.885361185767824, 
                  8.790078862902234}}]}}, {
                Arrowheads[{{0.009386792005377804, 1.}}], {
                 LABColor[
                 0.18866810167862544`, 
                  0.5225961002420597, -0.8572093771097019], 
                 
                 ArrowBox[{{-7.364508795745612, 
                  8.530304512140809}, {-7.635491204254388, 
                  8.79020356354797}}]}}, {
                Arrowheads[{{0.009403620499276172, 1.}}], {
                 LABColor[
                 0.18866980602419953`, 
                  0.5225960971987992, -0.8572053038166983], 
                 
                 ArrowBox[{{-6.1142658892337, 
                  8.530071540663528}, {-6.3857341107663, 
                  8.790436535025247}}]}}, {
                Arrowheads[{{0.00943506026497153, 1.}}], {
                 LABColor[
                 0.18867575477477105`, 
                  0.5225960865767759, -0.8571910866271499], 
                 
                 ArrowBox[{{-4.8638120801247835`, 
                  8.529636292642905}, {-5.1361879198752165`, 
                  8.790871783045873}}]}}, {
                Arrowheads[{{0.009493797480134448, 1.}}], {
                 LABColor[
                 0.1886965179544341, 0.5225960495022722, -0.8571414637597348], 
                 
                 ArrowBox[{{-3.612964253091606, 
                  8.528823142287898}, {-3.887035746908394, 
                  8.79168493340088}}]}}, {
                Arrowheads[{{0.00960353304491346, 1.}}], {
                 LABColor[
                 0.18876898857234556`, 
                  0.5225959200995389, -0.8569682629339229], 
                 
                 ArrowBox[{{-2.36138030366427, 
                  8.527303977424364}, {-2.63861969633573, 
                  8.793204098264411}}]}}, {
                Arrowheads[{{0.009808546070198295, 1.}}], {
                 LABColor[
                 0.18902193588319574`, 
                  0.5225954684396203, -0.8563637326513241], 
                 
                 ArrowBox[{{-1.1084210965498729`, 
                  8.524465803809402}, {-1.3915789034501271`, 
                  8.796042271879376}}]}}, {
                Arrowheads[{{0.010191560825907702`, 1.}}], {
                 LABColor[
                 0.1899048087482306, 0.5225938919916044, -0.854253714636883], 
                 
                 
                 ArrowBox[{{0.1471074301788044, 
                  8.519163397426754}, {-0.1471074301788044, 
                  8.801344678262025}}]}}, {
                Arrowheads[{{0.01090712659489867, 1.}}], {
                 LABColor[
                 0.19298633783503916`, 
                  0.5225883896473743, -0.846889028120061], 
                 
                 ArrowBox[{{1.407436077890212, 8.509257198137705}, {
                  1.092563922109788, 8.81125087755107}}]}}, {
                Arrowheads[{{0.012243979450092913`, 1.}}], {
                 LABColor[
                 0.2037419311813952, 0.5225691845789409, -0.8211837464021569], 
                 
                 ArrowBox[{{2.6767325322227906`, 8.490749981362425}, {
                  2.3232674677772094`, 8.829758094326346}}]}}, {
                Arrowheads[{{0.014741549392491332`, 1.}}], {
                 LABColor[
                 0.24128264067117247`, 
                  0.5225021523035869, -0.7314634973884976], 
                 
                 ArrowBox[{{3.962783055022406, 8.456173948438693}, {
                  3.537216944977594, 8.864334127250082}}]}}, {
                Arrowheads[{{0.01940762434078136, 1.}}], {
                 LABColor[
                 0.3723125916569374, 
                  0.5222681866733822, -0.41830905810194907`], 
                 
                 ArrowBox[{{5.2801342985061055`, 8.391577414704882}, {
                  4.7198657014938945`, 8.928930660983893}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{6.655962986872561, 8.270895201692554}, {
                  5.844037013127439, 9.049612873996217}}]}}, {
                Arrowheads[{{0.028125, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.905962986872561, 8.270895201692554}, {
                  7.094037013127439, 9.049612873996217}}]}}, {
                Arrowheads[{{0.028124999999999983`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.155962986872561, 8.270895201692554}, {
                  8.344037013127439, 9.049612873996217}}]}}, {
                Arrowheads[{{0.009375000000000001, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-9.196901211837346, 
                  9.801412336520439}, {-9.553098788162654, 
                  9.684159248629431}}]}}, {
                Arrowheads[{{0.009381590132899105, 1.}}], {
                 LABColor[
                 0.1886677836199721, 0.5225961008099818, -0.8572101372525432], 
                 
                 ArrowBox[{{-7.946776017737809, 
                  9.801453547903478}, {-8.30322398226219, 
                  9.684118037246385}}]}}, {
                Arrowheads[{{0.009393902122046794, 1.}}], {
                 LABColor[
                 0.18866869589041876`, 
                  0.5225960991810418, -0.8572079569759115], 
                 
                 ArrowBox[{{-6.696542124367455, 
                  9.801530540903249}, {-7.053457875632545, 
                  9.684041044246621}}]}}, {
                Arrowheads[{{0.009416903945999928, 1.}}], {
                 LABColor[
                 0.1886718800271476, 0.5225960934954824, -0.8572003470627242], 
                 
                 ArrowBox[{{-5.446105154023819, 
                  9.801674382763816}, {-5.803894845976181, 
                  9.683897202386055}}]}}, {
                Arrowheads[{{0.009459877010613928, 1.}}], {
                 LABColor[
                 0.18868299375635464`, 
                  0.5225960736509305, -0.8571737858558244], 
                 
                 ArrowBox[{{-4.195288785945804, 
                  9.801943114738329}, {-4.554711214054196, 
                  9.683628470411538}}]}}, {
                Arrowheads[{{0.009540161264857511, 1.}}], {
                 LABColor[
                 0.1887217844828236, 0.5225960043866388, -0.8570810781343796], 
                 
                 ArrowBox[{{-2.943763609584276, 
                  9.802445172163349}, {-3.306236390415724, 
                  9.683126412986521}}]}}, {
                Arrowheads[{{0.009690151998293562, 1.}}], {
                 LABColor[
                 0.1888571774217693, 0.5225957626305056, -0.8567574963917328], 
                 
                 ArrowBox[{{-1.6909142050124801`, 
                  9.803383138918033}, {-2.05908579498752, 
                  9.68218844623183}}]}}, {
                Arrowheads[{{0.009970371579687737, 1.}}], {
                 LABColor[
                 0.18932974521270848`, 
                  0.5225949188186886, -0.8556280851351223], 
                 
                 ArrowBox[{{-0.43559081644013364`, 
                  9.805135491515689}, {-0.8144091835598664, 
                  9.680436093634178}}]}}, {
                Arrowheads[{{0.01049389067982075, 1.}}], {
                 LABColor[
                 0.19097916887373645`, 
                  0.5225919736260557, -0.8516860525095336], 
                 
                 ArrowBox[{{0.8243545827399936, 9.808409317172249}, {
                  0.4256454172600064, 9.677162267977614}}]}}, {
                Arrowheads[{{0.011471953122282814`, 1.}}], {
                 LABColor[
                 0.19673622313287634`, 
                  0.5225816938936912, -0.8379270066967252], 
                 
                 ArrowBox[{{2.092935034553316, 9.814525628720457}, {
                  1.657064965446684, 9.671045956429406}}]}}, {
                Arrowheads[{{0.013299214326528846`, 1.}}], {
                 LABColor[
                 0.21683031692199095`, 
                  0.5225458141022283, -0.7899032180425942], 
                 
                 ArrowBox[{{3.37764788854082, 9.825952403044793}, {
                  2.87235211145918, 9.659619182105073}}]}}, {
                Arrowheads[{{0.01671298768453423, 1.}}], {
                 LABColor[
                 0.28696559566540475`, 
                  0.5224205813247806, -0.6222837255230129], 
                 
                 ArrowBox[{{4.692500037673909, 9.847300427982724}, {
                  4.057499962326091, 9.638271157167143}}]}}, {
                Arrowheads[{{0.023090755960217618`, 1.}}], {
                 LABColor[
                 0.5490058659511005, 0.5317723090646015, 
                  0.30687754562820213`], 
                 
                 ArrowBox[{{6.0636598031225954`, 9.887183789272175}, {
                  5.1863401968774046`, 9.598387795877695}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{7.409296364487961, 9.918665424411449}, {
                  6.340703635512039, 9.566906160738418}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{8.659296364487961, 9.918665424411449}, {
                  7.590703635512039, 9.566906160738418}}]}}, {
                Arrowheads[{{0.028125000000000018`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{9.909296364487961, 9.918665424411449}, {
                  8.840703635512039, 9.566906160738418}}]}}}}}}}, {
          DisplayFunction -> Identity, DisplayFunction -> Identity, 
           PlotRange -> {{-10., 10.}, {-10., 10.}}, DisplayFunction -> 
           Identity, AspectRatio -> 1, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 200, 
           Method -> {
            "VectorLengthFunction" -> (Sqrt[#]& ), "DefaultBoundaryStyle" -> 
             Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
           Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
           AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic,
            BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
           Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, 
           FormatType :> TraditionalForm, FrameLabel -> None, 
           FrameStyle -> {}, FrameTicksStyle -> {}, GridLines -> None, 
           ImageMargins -> 0., ImagePadding -> All, ImageSizeRaw -> Automatic,
            LabelStyle -> {}, PlotLabel -> None, PlotRegion -> Automatic, 
           PreserveImageOptions -> Automatic, Prolog -> {}, RotateLabel -> 
           True, TicksStyle -> {}, DisplayFunction -> Identity, AspectRatio -> 
           1, DisplayFunction :> Identity, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 200, 
           Method -> {
            "VectorLengthFunction" -> (Sqrt[#]& ), "DefaultBoundaryStyle" -> 
             Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, 
           PlotRange -> {{-10., 10.}, {-10., 10.}}, PlotRangeClipping -> True,
            PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
         FormBox[
          FormBox[
           TemplateBox[{
             FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 GraphicsBox[{
                   RasterBox[CompressedData["
1:eJxt13k01dvfB3AZUoiUeUylqKQBGXLfKEMpKqSQIU0qilQUlSGiFBkq1Lnp
JtdNdRxlKiRkPsdxjtnhOIN5uCUZGn6e9fz1/L7PXuuz1l6v/cfe+7P32mt/
NI6eO3BcSEBAoGY+FszH//T/u724EOV39AQfMpUbS2Oev0APSf9bpKoz0nUS
nJNd+NjmORK4Iz4PMZazBxsVTsFcmMOptOOjOn1M21S4GHUugx7TjQEIWWEn
MmnBBzedFCa8vgz/xnqeLV16BeXcaznq2/hI/K0XOBVcDsqjQ/6UwRtIPjPX
YLOeD7rA4L/RsRUQG3TM3iNxE7eFVh06p84HxW/PoZqzVfjHXyJbwD8G3Cwd
08TlfBjcShtcuL4aKhdOFP6lcBeXQ9b75Ynycetp0xG7+hqMyT5fKhqeAClD
4S76HA+vtCLtcp3qUOJrL7tYKQmKf166PDbOg7TNXrMftfXQ79WU+sRIQcAX
+c2iXB5C/N+2yOo2okciPYOU+wjxBxxmVNp4MNR2i9kdScXb+5qBi/PSkbLF
p0y3ngdJCtXK6AQNQ9IGWmfaSUgo9LuEMh4y77Ino4WbUJP0J/lBwlOkr9kr
viePh05HzlHy4yaQtncf67V5hv5NH/2csngouyL422QLHQPGCcYlS5/j7jGX
eNd0Ho6aGAw9KqdjTttOwJaZiY0hVzzc43nw2H5seoN9MxzJH8l5yVlYlu9Y
dySSh2DTVe93tTXj98438ucPZOPX+tHyw0E8lPqmso3cGchMSchki7+Ej4KC
/oGzPNyXFxf9g83AKa+UE57lOVDZELzU2pOHac3PW+95McFWnd1ueOk1pJvC
dxg68vBFZYmIZw8TE6N0FjPxDZ6eu/he04aHgA+9T7tdWqAolUu7coaMtFfu
PlLbefhoHxa+idGC1/sos6stchH9WsHwmy4PMS+/yITatmJbRXXMsDwF+Va7
5FpX8eB1psKSW9YK4+sPt3FGKFDR9fo3T54Huf0pXyL02hDyLISk9jEPVKO0
d3fFeVD8lrb7cmYbXngn3nyV9BY6wXMHjv3mwnxx4IpWuXa4KEQvyzj5Di4n
7Sj6X7nQaf+qW3SzHaLMVQtFjfOhsEirQrCfi3GZX4f1v7bD47Bn36B4AWpE
OP51HVwI9Uq3uXp0IC1l3dKD3QVIrSFl3WvkYipq5BRqO7AvS+S306tChN7d
4WhfzoVpgPPlia2d+HDEwezrtSLM+V32FHvHRVzuou3X0jsxQ559YmBfjFe+
LwrK/uZiSZFD55RQF1wdf2zVUn+P7UELbAIecyG7xvr6ydNdYD4/G0Qde4+c
Y4EzaglcbFcv8uuidqFlVN9pa8kH8AZe5VdFcuEV8E7DS68bQz2Tm1ziSmB+
R83XJ4iL6KVpDgIPu1Esovdjl1sppu6PCYme5aLSYefyitlu1NSqq0XKlsGE
s/AEyYML90dXm966sbBCyUusIaQMXI5Y6BYHLvizPF/WBxZUmrW1BLllcHM8
tKXMios1jU8trNR60LVaMk/T9iPqVBeeszHmgllZvPFbaA+ibjlVGuV+hLwq
R7lOhwtS+xPSl64eXKaI7zdTLEcFL1DDRoMLx8zG+gzVXhj5lG8wuVEOs9Cp
k6UyXOy+0+JxZU8vmu4vkd7QX454SefWTYu4sLfZpiN0tRcJRR/TZOw+YXmK
oXP6HAei92x0zf7uRcHU3P6pvE9YcXOsccE4B7+LHIz0WnvR4DnzlK5cAcsj
IZpefRyMwHSWLczGX76fuNnhFeixSDIvYnIgqzn5y3YLG5K0tx43BivQFJW8
eEkNBxd8cvICPdggz7AtHfdVYu3a296H33PACp847X6HDTeaQ+Ha/EroWK3T
J73mIDI+2Em8kI0jpcb1c6pV6HlA82ZlcPDY4VtcKI+NzNGZsKbIKnhXhjPk
UjiovpMqmy/dh82SK2l/D1dBrmrojE0MBwrfn7UUmvaBOnuQdPPAZ0hsPCh5
IYSDX2U5z6N9+iAjuqr+eOFnPPLPI6Wc4+CDzIzFyuQ+8KsK19quqEaoarIQ
5ej8On8+cL1d1gcO9Z8gg+hqXBNao1rtxIH4+4jYiuE+kFruXNUaq0any2Yq
04aDFHfSYaocBxZecRwNpxrcYCj/6DThwDKVrhQxP04V3NTjXlQDP0pClLQG
B3G+r4IRzcFDH13hbJVaeM6Mxb8Z6sPVcfoRzcr5vLoofq2/XoshZ6E527w+
zAVXPPpDkIvv6bqepZxanPRgNfSFzu//c7lH0h9ckOX63IJt6rDMNlEk0LoP
zvve2+te4SLq7C7Hrzl1cGaejv+1tA9k0fcR8m+5SIx6IbpGph7LDUTswjrm
z1VMOM1xnIuIgi+xYlfrwW44LTn3jA01J4GKUS0ejsWeM0/tq4dU6+KE075s
ULYYVA568cDwcOto3N0A652kiEYDNsz67UXsU3lIekDem0FpwNmSRWGaAmxw
SR73V9F5kNGdbpNUbYRv4E8pv5pe/BTx1/JdzIdCsOEPyehGnND+52nm/V4w
skO3bTbjo1xc8PLjfxshnq4X3+Dai7/amAOBl/hIyYmzfOtGxXcRSVX26l7I
LFuy2vQlH0uLZh7vr6aCLHmKVdLZg4GHlxPvsvloSaVNGSjRcD3Xf2Wcbw9G
X+7M8pXrx6bPVsPh+2iY1rJiaf1mIacKT1i7++F+NixFLJqGPec3Z8XFs7Cq
1fw671o/nBUTZ+s+0KBR8if1nQYLQTdd1kTl9iN+yH1T5SQN+ucjnEm53TAJ
KrCo4PXDcOXNE5Prm2CdozRhvqMb94cOujxTGEDRT9deZ+8mSN/RnHjY3AU5
5Uv1a2wHMOs3OTma2gTDDse9T7y7sD+K07w/dABPDq+TfEtvQubxsUTbr50Y
cpKLWft6AOUTpS/+EaNjYXdE96PwTox+W8XN7h0AozHCjmZBB7sjvSpMuhPL
DsWXsKQHUe0RRtK4SofPvo3ec6QOPJH6yai0GESOvon1EwodusqUzb90OiCg
XlR99MIgLHvGBCxH6DBkkSXCitvRudBEo+DZIMI72Mkyms1YOxqgdMWmHYdO
BOytbh6Ek2l+l7h7M2raHxexGG0Q2iH3PFloCC3khgLtB80ouHHK/5lnG1I7
G31Wbh2C5vHnir60Zoy+nqAWD7cionh/9fmjQ7C4vXeWsZiB6J6dh5UutaIg
/XR7eMIQ0lTaPT13MOA3EuX95ncL7tz4muFSNoSzFzuOSIYyoDZ5YdL3VgvM
bD4ozI4NITqcJ856x8C3+MCH5ktbYDjto+qtOowD2gr3GicYiHVbs1XhARM7
8o0iHtgO49DjLJmedUzUp0hVd6kw0R1eJ/EoeBgLDwXTJY8zMV3caRT0lIGE
ELqvz4thFJ7OXXiExMTOItlftNUMpD4tsxVjDiON7/G9up0JCZna8trMZkT/
c/KPUMERPFaQ/bJfpgUPpioErdY2Q7s2nvZJdwQ6rkm23+1a4F6qE6meSUdJ
6+0bPW4jaDW/6lEQ04Kgmdli3VV0jKW9K2uKGYER/8u9pIoW1K37Kbn7SROc
Mn98T3s3gqMrjlnens+L0EQb30S+CV5/7AsHZwRKl3XH0oxbcd5yNK4ujgZq
lwr5g9Qotjw49avyYivqB1zL3i2gQS+VUie/fRTqq5PHF5FbsVDgd64XrxF+
38hS9qdGofjWz+zYSCv0zBq/lZU1QNnOm3wsaRR/Ml8Etq5tw1Yb5W8FSfUY
OanadbhsFFfZFJmj3m2ouHg73d6zDmGWD3N1R0bRkpKQI0Rqww9F98WHVtZC
6i9z+375MVCNH9KKO9oQlrHA1Lu9Go9d71SE7RhDwUbr5bHz/xT3iSfHsyM+
o6DPRFXg3BhEWuSl/A60Y2n555XjalUI2fTSzTt1DMxX+71O3m2H9YrFUbZZ
FfDcKnf9ZeUY1t/ozb5Y2w5NlwxPvvKn+fvfFNw1MYac8A3xDxd24OPn6eSL
gR+R5hhvMqk8DqvTkwVUiw4seDPcVuJYiitOpJeTVuPYZahNU7regcrA1Z8V
jxXDtFHxNct/HIUldRHBxR348kt+ye2Jd8if01CnpI9Dq7Qucvh7B3RPyOcl
kMnI2C3THPB5HMfjB6LO63Xi0YUz46yp5zhVWpCm9mUcatsSzRb5d8JJOYrX
3XIT/1uFTCAyLmqo/2Mn/m91MoE2nivXXqWL4P7T9jNil4hunWApu4JKdOFt
lmXJa7sJbisxrRlwneikjedViluIfsHrwLpLOiyCe9oG3MmKILqHx4SxczvR
+17xR6M29hB81PqNxvYIom/wYCpdbSX6qWz65DPZXoK72H4ycADR00oWbGg4
RXQD44YHy+8T/e+Y9dpaxUT/nqgSIsEl+m3lfKVyCTbBLxZvurZbn+iMCbrU
iyNE96axtNtvEn2a5anQl0N0nvuU4icm0St33PQM/Un0kd5+6WWafQTX2htn
E76H6Ax3KRnqBaIvlyoNnkkluoiA1kXBcqJ7Nt2eHhog+vUep1GKFId4b39E
67kbEN0hY8WLITei/6l+Vc4lguh6Ktl7cv4mesBQvQSPSvR10x7LBaeIrpl/
S05EhUtwI9sjVWPmRN9ipdVQepLoVEoWNSiO6CUUO18lCtEn2wPNnrcR3Tg2
haX4i+jJ1yPagubryf/2uy/ji8ptiG70pEpi2pfovbeWOCgmEv38SuclawuI
rn62Kl+j+/+ZN5ZZu1iQT/CMmuDinjVEH+Fbzj2zJbrx+9jpg+eJ/tTrktpM
EtFNuzczYwuJrnfxZ5gEi+g6+bbR1wT7ie+MdedO9hqim92iyuvbEv1f7WqX
K+eIHkn+fpycSPRPwkb3OvKJvnvR6nVTnUSfdNW4JSwwgO8SM6VifDH8B7uN
uqw=
                    "], {{
                    Rational[-15, 2], -100}, {
                    Rational[15, 2], 100}}], {Antialiasing -> False, 
                    AbsoluteThickness[0.1], 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]], 
                    LineBox[
                    NCache[{{
                    Rational[15, 2], -100}, {
                    Rational[-15, 2], -100}, {
                    Rational[-15, 2], 100}, {
                    Rational[15, 2], 100}, {
                    Rational[15, 2], -100}}, {{
                    7.5, -100}, {-7.5, -100}, {-7.5, 100}, {7.5, 100}, {
                    7.5, -100}}]]}, {
                    CapForm[None], {}}, 
                   StyleBox[{Antialiasing -> False, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.500000000000001, -100.}, 
                    Offset[{4., 0}, {7.500000000000001, -100.}]}, {{
                    7.500000000000001, -66.10169491525424}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -66.10169491525424}]}, {{
                    7.500000000000001, -32.20338983050848}, 
                    
                    Offset[{4., 0}, {
                    7.500000000000001, -32.20338983050848}]}, {{
                    7.500000000000001, 1.6949152542372883`}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    1.6949152542372883`}]}, {{7.500000000000001, 
                    35.59322033898305}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    35.59322033898305}]}, {{7.500000000000001, 
                    69.49152542372882}, 
                    
                    Offset[{4., 0}, {7.500000000000001, 
                    69.49152542372882}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.500000000000001, -91.52542372881356}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -91.52542372881356}]}, {{
                    7.500000000000001, -83.05084745762713}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -83.05084745762713}]}, {{
                    7.500000000000001, -74.57627118644068}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -74.57627118644068}]}, {{
                    7.500000000000001, -57.6271186440678}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -57.6271186440678}]}, {{
                    7.500000000000001, -49.152542372881356`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -49.152542372881356`}]}, {{
                    7.500000000000001, -40.67796610169492}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -40.67796610169492}]}, {{
                    7.500000000000001, -23.728813559322035`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -23.728813559322035`}]}, {{
                    7.500000000000001, -15.254237288135593`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -15.254237288135593`}]}, {{
                    7.500000000000001, -6.779661016949153}, 
                    
                    Offset[{2.5, 0.}, {
                    7.500000000000001, -6.779661016949153}]}, {{
                    7.500000000000001, 10.16949152542373}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    10.16949152542373}]}, {{7.500000000000001, 
                    18.64406779661017}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    18.64406779661017}]}, {{7.500000000000001, 
                    27.118644067796613`}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    27.118644067796613`}]}, {{7.500000000000001, 
                    44.067796610169495`}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    44.067796610169495`}]}, {{7.500000000000001, 
                    52.54237288135594}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    52.54237288135594}]}, {{7.500000000000001, 
                    61.016949152542374`}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    61.016949152542374`}]}, {{7.500000000000001, 
                    77.96610169491525}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    77.96610169491525}]}, {{7.500000000000001, 
                    86.4406779661017}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    86.4406779661017}]}, {{7.500000000000001, 
                    94.91525423728814}, 
                    
                    Offset[{2.5, 0.}, {7.500000000000001, 
                    94.91525423728814}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.500000000000001, -100.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["2000", TraditionalForm], 
                    Offset[{7., 0.}, {7.500000000000001, -66.10169491525424}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["4000", TraditionalForm], 
                    Offset[{7., 0.}, {7.500000000000001, -32.20338983050848}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["6000", TraditionalForm], 
                    
                    Offset[{7., 0.}, {7.500000000000001, 
                    1.6949152542372883`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["8000", TraditionalForm], 
                    Offset[{7., 0.}, {7.500000000000001, 35.59322033898305}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["10000", TraditionalForm], 
                    Offset[{7., 0.}, {7.500000000000001, 69.49152542372882}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                    "GraphicsAxes"}, StripOnInput -> False]}, 
                  PlotRangePadding -> Scaled[0.02], PlotRange -> All, Frame -> 
                  True, FrameTicks -> {{False, False}, {True, False}}, 
                  FrameStyle -> Opacity[0], FrameTicksStyle -> Opacity[0], 
                  ImageSize -> {Automatic, 200}, BaseStyle -> {}], Alignment -> 
                 Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]}, "BarLegend", 
            DisplayFunction -> (#& ), 
            InterpretationFunction :> (RowBox[{"BarLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                    "[", "#1", "]"}], "&"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.00008481823524646916`", ",", "11789.91754655292`"}], 
                    "}"}]}], "}"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
                 RowBox[{"LegendMarkerSize", "\[Rule]", "200"}], ",", 
                 RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
                 RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
               "]"}]& )], TraditionalForm], TraditionalForm]}, "Legended", 
        DisplayFunction -> (GridBox[{{
            TagBox[
             ItemBox[
              PaneBox[
               TagBox[#, "SkipImageSizeLevel"], 
               Alignment -> {Center, Baseline}, BaselinePosition -> Baseline],
               DefaultBaseStyle -> "Labeled"], "SkipImageSizeLevel"], 
            ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           AutoDelete -> False, GridBoxItemSize -> Automatic, 
          BaselinePosition -> {1, 1}]& ), 
        InterpretationFunction -> (RowBox[{"Legended", "[", 
           RowBox[{#, ",", 
             RowBox[{"Placed", "[", 
               RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> 
        True], 
       TemplateBox[{
         GraphicsBox[{{{{}}, {{
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675225526783, 0.5225961012761406, -0.8572107611891424], 
                 
                 ArrowBox[{{-10., 
                  3.3787534133836706`*^-9}, {-9.993054570485908, 
                  3.39881360846672*^-9}, {-9.841624844007146, 
                  3.952629576502583*^-9}, {-9.663067553398431, 
                  4.727322785685795*^-9}, {-9.445775308212486, 
                  5.8783094719422834`*^-9}, {-9.169889576019559, 
                  7.679050221864399*^-9}, {-9.01983314473639, 
                  8.918295063099078*^-9}, {-8.843192415908385, 
                  1.0644826530449615`*^-8}, {-8.628734639349709, 
                  1.3196478027266624`*^-8}, {-8.4, 
                  1.654839300147044*^-8}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866752610675727`, 
                  0.5225961012697945, -0.8572107526950874], 
                 
                 ArrowBox[{{-8.360000000000001, 
                  1.713455957138451*^-8}, {-8.357296919857458, 
                  1.717417095176844*^-8}, {-8.208716168302923, 
                  1.9916858709719116`*^-8}, {-8.034126513107868, 
                  2.3721890519768176`*^-8}, {-7.822686552733358, 
                  2.9314315192965836`*^-8}, {-7.555963346508523, 
                  3.799609006133391*^-8}, {-7.4089769125383915`, 
                  4.3994952820854404`*^-8}, {-7.236593715353289, 
                  5.228031271466322*^-8}, {-7.028382545434987, 
                  6.438674601716143*^-8}, {-6.76667821992954, 
                  8.309202927245351*^-8}, {-6.7600000000000025`, 
                  8.368762977777087*^-8}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866754447770112`, 
                  0.5225961012369915, -0.8572107087895331], 
                 
                 ArrowBox[{{-6.720000000000002, 
                  8.725505050725634*^-8}, {-6.621425184093589, 
                  9.604649654900025*^-8}, {-6.451429990323903, 
                  1.138538373756605*^-7}, {-6.246693051899397, 
                  1.3971267791801102`*^-7}, {-5.990358917973921, 
                  1.7945038266557739`*^-7}, {-5.847004563360965, 
                  2.0703929222167716`*^-7}, {-5.679612323292117, 
                  2.447706739195334*^-7}, {-5.4786388482127855`, 
                  2.9919926584249895`*^-7}, {-5.228085454886658, 
                  3.8232350462828293`*^-7}, {-5.120000000000045, 
                  4.2660036009156485`*^-7}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866763894008476`, 
                  0.5225961010683206, -0.8572104830295864], 
                 
                 ArrowBox[{{-5.080000000000049, 
                  4.434554245318126*^-7}, {-4.922298515746804, 
                  5.188918478387695*^-7}, {-4.725434454605094, 
                  6.316110568648618*^-7}, {-4.481148486904185, 
                  8.025372915645232*^-7}, {-4.342237343482608, 
                  9.218605947599992*^-7}, {-4.180886086746698, 
                  1.0831785436468008`*^-6}, {-3.9885548958125145`, 
                  1.3124116578768995`*^-6}, {-3.751126670015262, 
                  1.6571760793861205`*^-6}, {-3.6148568542792567`, 
                  1.8985946563633661`*^-6}, {-3.4800000000011764`, 
                  2.175687228015687*^-6}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886681268898323, 0.5225961001970428, -0.857209316856292], 
                 
                 
                 ArrowBox[{{-3.4400000000012754`, 
                  2.2644260059315695`*^-6}, {-3.269766055241717, 
                  2.679552156359154*^-6}, {-3.0398812940819973`, 
                  3.3600053630801044`*^-6}, {-2.9068299912457385`, 
                  3.83722316259292*^-6}, {-2.7533425524627204`, 
                  4.473047409566524*^-6}, {-2.572073748455445, 
                  5.3596224174035*^-6}, {-2.3511342290542374`, 
                  6.664705513241815*^-6}, {-2.220049006239748, 
                  7.596461399538996*^-6}, {-2.0691750551811334`, 
                  8.831948127743057*^-6}, {-1.8915439262047347`, 
                  0.000010543507224629976`}, {-1.8400000000310717`, 
                  0.000011141780218050015`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867065346747816`, 
                  0.5225960956856137, -0.8572032784734639], 
                 
                 ArrowBox[{{-1.8000000000337661`, 
                  0.000011606062268558953`}, {-1.675921148038129, 
                  0.0000130462518643892}, {-1.5573159083635726`, 
                  0.000014686682112837845`}, {-1.4227314558921251`, 
                  0.000016800711117035366`}, {-1.267263937682918, 
                  0.00001961801802926426}, {-1.0837147321135698`, 
                  0.000023517352682832688`}, {-0.9994843766396881, 
                  0.00002558881563596236}, {-0.907480008512677, 
                  0.000028061614498601514`}, {-0.8061090161657525, 
                  0.00003106613460180731}, {-0.751097877332897, 
                  0.000032833292187748445`}, {-0.6928648687209111, 
                  0.00003481426949735031}, {-0.5623419033493433, 
                  0.000039659845559821414`}, {-0.41264061018645953`, 
                  0.000045995862361360695`}, {-0.3057234566089873, 
                  0.000051204475873052253`}, {-0.20000000081108346`, 
                  0.00005698192034823573}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868359294601034`, 
                  0.5225960725810241, -0.8571723538252142], 
                 
                 ArrowBox[{{-0.16000000088236682`, 
                  0.00005936550153825089}, {-0.049695706027160884`, 
                  0.00006623430873727268}, {-0.025127215127704043`, 
                  0.00006786166180021437}, {0.00005239223735416958, 
                  0.00006957047776698812}, {0.0469174768072634, 
                  0.00007299021182619068}, {0.09614668481445239, 
                  0.00007676822599708771}, {0.26107604029374365`, 
                  0.00009066192654634654}, {0.4590672757496065, 
                  0.0001107691326745237}, {0.7070576091349545, 
                  0.00014255322829136147`}, {0.9272696243089426, 
                  0.00017816391508899843`}, {1.2116729292350126`, 
                  0.00023823554581401012`}, {1.439999977166156, 
                  0.0003004991270251668}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18875053658618612`, 
                  0.5225959530472012, -0.8570123621748676], 
                 
                 ArrowBox[{{1.4799999747159225`, 0.00031442589430658437`}, {
                  1.7586459121214661`, 0.0004162040258347717}, {
                  2.0109923820472497`, 0.0005376284337879912}, {
                  2.352520421541353, 0.0007640117646646094}, {
                  2.618681029748854, 0.0010009423651340776`}, {
                  2.9122795981360396`, 0.0013509638562192864`}, {
                  3.079999319445019, 0.0016215931739734326`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.189096713183253, 0.5225953349181011, -0.856185018980941], 
                 
                 ArrowBox[{{3.119999267372262, 0.001686136320916831}, {
                  3.2111200536247213`, 0.0018331670697415026`}, {
                  3.51816857143922, 0.002509074583503844}, {
                  3.8328312480706788`, 0.003461826540491129}, {
                  4.146925686561371, 0.00477291582522482}, {4.477292659544652,
                   0.006696180048731564}, {4.719980601486342, 
                  0.008669978259357862}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.19086973253179276`, 
                  0.5225921690343766, -0.8519475994004629], 
                 
                 ArrowBox[{{4.759979278615162, 0.008995290331777398}, {
                  4.802925973315186, 0.009344578839780774}, {
                  5.136402769710158, 0.01315133544254527}, {5.47255805213586, 
                  0.018560213747669533`}, {5.809469479757098, 
                  0.026214225648789103`}, {6.1420305119174525`, 
                  0.036853790084481336`}, {6.3594386227607105`, 
                  0.046567922379000086`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.20004002748250502`, 
                  0.5225757946572119, -0.830031094419899], 
                 
                 ArrowBox[{{6.399398753622317, 0.04835340313310034}, {
                  6.464334820612552, 0.051254847531757824`}, {
                  6.771283664298293, 0.07014912490861783}, {7.060262860908749,
                   0.0942418502830613}, {7.330817880381249, 
                  0.12425186072180856`}, {7.583820888653146, 
                  0.16096253935775814`}, {7.82547247764334, 
                  0.2063091572172266}, {7.984705312015801, 
                  0.24451105252707586`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.24624994473838743`, 
                  0.522493282740424, -0.7195919114783151], 
                 
                 ArrowBox[{{8.02360157918219, 0.25384274050518885`}, {
                  8.05062805814516, 0.26032672180217553`}, {8.262163236179983,
                   0.3246017886106968}, {8.461579685000789, 
                  0.40097279652369916`}, {8.650242405784478, 
                  0.4921132338786306}, {8.86673651028317, 
                  0.6301029902590011}, {9.034993107747644, 
                  0.7738795912221914}, {9.200687948267378, 
                  0.9755388772832969}, {9.282740923368303, 
                  1.145806833789587}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3953863537967128, 
                  0.5222269864190922, -0.36316402453708463`], 
                 
                 ArrowBox[{{9.300105935353688, 1.1818409337332159`}, {
                  9.331424088485006, 1.246829167598736}, {9.377102273513772, 
                  1.4556676660187422`}, {9.378242609526234, 
                  1.6740138730618777`}, {9.33459612335003, 
                  1.8833720463740236`}, {9.220813349890157, 
                  2.129785270437825}, {9.07619965499746, 
                  2.3178486564127776`}, {8.92669568151627, 
                  2.457017491583642}, {8.790121567794502, 
                  2.556509369758059}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3083675271127688, 0.5223823662728707, -0.5711342761671435], 
                 
                 ArrowBox[{{8.756372436919678, 2.577947936219099}, {
                  8.687305118566956, 2.620515738506453}, {8.596035722022243, 
                  2.670066953459276}, {8.510502445992886, 
                  2.711554978304457}, {8.305664113464196, 
                  2.793750414084542}, {8.131880837575073, 
                  2.850783145588315}, {7.981841707376075, 
                  2.892183065143593}, {7.850220015163066, 
                  2.9234215084769537`}, {7.61648086095006, 
                  2.9687488015212176`}, {7.4257483863305325`, 
                  2.998906617582797}, {7.264971234174568, 
                  3.0201917294029945`}, {7.2331409135719875`, 
                  3.0238073201771214`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.21379132899035824`, 
                  0.5225512404854427, -0.7971662335178302], 
                 
                 ArrowBox[{{7.193396494545892, 3.028321869576355}, {
                  7.126172463940114, 3.03595781480897}, {6.875102787379994, 
                  3.0590336969553804`}, {6.673618279074939, 
                  3.07410476323104}, {6.505728658491995, 3.084547843096569}, {
                  6.361933019485177, 3.0921779168805563`}, {
                  6.1044329075147505`, 3.1031672344872043`}, {
                  5.898903045119903, 3.1103067245290155`}, {
                  5.7283294100838775`, 3.1152167767215664`}, {
                  5.596445205318474, 3.118446698971078}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.19355818831532426`, 0.522587368557486, -0.845522336648667], 
                 
                 ArrowBox[{{5.556454443375795, 3.119301558551062}, {
                  5.328660236238504, 3.12379691993932}, {5.125430195310969, 
                  3.127069208494498}, {4.956472825470529, 
                  3.1293278439984147`}, {4.811972387643694, 
                  3.1309742376043412`}, {4.563781381912564, 
                  3.133264224166479}, {4.364332977858826, 
                  3.1347691531408928`}, {4.198003938384789, 
                  3.1358147560126772`}, {4.055427521352712, 
                  3.1365808243738913`}, {3.9565721461829235`, 
                  3.137013455757587}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18962079327539247`, 
                  0.5225943991264892, -0.8549324961328405], 
                 
                 ArrowBox[{{3.916572529236235, 3.1371885103724444`}, {
                  3.8138399778369334`, 3.1376381098584223`}, {
                  3.6187366151439737`, 3.1383382457458002`}, {
                  3.4554424865773656`, 3.138828395359233}, {
                  3.3150969877495178`, 3.1391896005745625`}, {
                  3.0808455881041312`, 3.139683775490873}, {
                  2.8906107661974456`, 3.1400139408643675`}, {
                  2.730742794875905, 3.140247042333299}, {2.592930681669185, 
                  3.1404199357661278`}, {2.3669034327730656`, 
                  3.140653983261125}, {2.3165771954612513`, 
                  3.140697034715519}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1888519129521282, 0.5225957720306842, -0.8567700781871634], 
                 
                 ArrowBox[{{2.2765772100970523`, 3.140731252603398}, {
                  2.1821817661852427`, 3.1408120029508444`}, {
                  2.0262276361960536`, 3.1409246318636383`}, {
                  1.8913292805358317`, 3.1410087803188285`}, {
                  1.674691335125653, 3.1411211837252258`}, {
                  1.4963394140514095`, 3.141198035468882}, {
                  1.3449528661416703`, 3.141253413356988}, {
                  1.2134816152285306`, 3.1412951364625545`}, {
                  1.0078512151776755`, 3.1413498969832037`}, {
                  0.8370751265695279, 3.1413879218757534`}, {
                  0.6911855017948918, 3.1414156794177197`}, {
                  0.6765773883852458, 3.141418103201091}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1887031909385311, 0.5225960375870656, -0.8571255156915447], 
                 
                 ArrowBox[{{0.6365773889358372, 3.1414247400152235`}, {
                  0.5638766470145846, 3.1414368025481747`}, {
                  0.3716823206496218, 3.1414638427322346`}, {
                  0.21032121735272608`, 3.141482995051326}, {
                  0.07136221372163501, 
                  3.1414972032597275`}, {-0.05063939218125862, 
                  3.141508151321377}, {-0.2252601402421987, 
                  3.141521614558702}, {-0.3740102966692875, 
                  3.141531413669223}, {-0.5035097128533926, 
                  3.1415388428255624`}, {-0.6181601495186126, 
                  3.141544665158103}, {-0.8088152160115365, 
                  3.1415529342374873`}, {-0.9634226043214112, 
                  3.141558594859762}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18867443996687017`, 
                  0.5225960889244824, -0.8571942289463516], 
                 
                 ArrowBox[{{-1.0034226043004992`, 
                  3.1415598863834893`}, {-1.1072175054452051`, 
                  3.1415631638654538`}, {-1.2285902795336014`, 
                  3.141566530003817}, {-1.4323591121000132`, 
                  3.1415713017743094`}, {-1.6018288961509963`, 
                  3.141574622090184}, {-1.74676708830169, 
                  3.1415770519361153`}, {-1.8733514128602302`, 
                  3.141578904230205}, {-2.087931253806465, 
                  3.1415815304473687`}, {-2.264861500753867, 
                  3.1415833298763327`}, {-2.4152257461474003`, 
                  3.1415846300552004`}, {-2.5459262151207827`, 
                  3.141585611495404}, {-2.6034226040441144`, 
                  3.141585969659675}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866886960297685`, 
                  0.5225960988708626, -0.8572075418123682], 
                 
                 ArrowBox[{{-2.643422604043338, 
                  3.1415862188330768`}, {-2.7698279688896887`, 
                  3.1415870062544458`}, {-2.9530994268330937`, 
                  3.141587949840163}, {-3.1080221614520727`, 
                  3.1415886242821816`}, {-3.242149399599994, 
                  3.1415891291544376`}, {-3.4742613152480963`, 
                  3.141589848691996}, {-3.6630510494350195`, 
                  3.14159033029857}, {-3.821901120945748, 
                  3.1415906712927795`}, {-3.9589577445006054`, 
                  3.1415909247032627`}, {-4.1984245957679835`, 
                  3.141591286940601}, {-4.2434226040334, 
                  3.141591342758184}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886677829040348, 0.5225961008112601, -0.8572101389635943], 
                 
                 ArrowBox[{{-4.283422604033369, 
                  3.1415913923760095`}, {-4.392107351109171, 
                  3.1415915271935293`}, {-4.554409226342734, 
                  3.1415916958721195`}, {-4.6940229378848795`, 
                  3.1415918204163713`}, {-4.940164052552512, 
                  3.1415919989681993`}, {-5.138247736636403, 
                  3.141592116463768}, {-5.3036298860933515`, 
                  3.141592198327857}, {-5.445511466422195, 
                  3.141592258418893}, {-5.697771265939401, 
                  3.1415923448084255`}, {-5.883422604032988, 
                  3.1415923966775496`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675722247699, 0.5225961011874467, -0.8572106424755517], 
                 
                 ArrowBox[{{-5.923422604032987, 
                  3.1415924067434005`}, {-6.0680224539390775`, 
                  3.1415924403332984`}, {-6.211940876001985, 
                  3.141592468853597}, {-6.469856546940988, 
                  3.1415925099628765`}, {-6.675618804116965, 
                  3.1415925366706348`}, {-6.846320236642496, 
                  3.1415925550290646`}, {-6.992086765480361, 
                  3.141592568365801}, {-7.255266277410503, 
                  3.141592587636094}, {-7.464428256604887, 
                  3.141592600090417}, {-7.523422604032972, 
                  3.1415926029914325`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866753151690585`, 
                  0.5225961012601342, -0.8572107397651273], 
                 
                 ArrowBox[{{-7.563422604032972, 
                  3.141592604958411}, {-7.637462494359472, 
                  3.1415926085992836`}, {-7.7849200828174325`, 
                  3.1415926147519095`}, {-8.053026700884635, 
                  3.1415926236617717`}, {-8.265353687006867, 
                  3.141592629393955}, {-8.440547339120556, 
                  3.1415926332877664`}, {-8.589563286628554, 
                  3.1415926360909787`}, {-8.862304335814658, 
                  3.1415926401587777`}, {-9.077593902956908, 
                  3.141592642765387}, {-9.163422604032972, 
                  3.1415926436183264`}}]}}, {
                Arrowheads[{{0.009957217449587863, 1.}}], {
                 LABColor[
                 0.18866752360091626`, 
                  0.5225961012742689, -0.8572107586839108], 
                 
                 ArrowBox[{{-9.203422604032971, 
                  3.141592644015834}, {-9.254798053319217, 
                  3.141592644526388}, {-9.405258764577853, 
                  3.14159264578889}, {-9.682005742267746, 
                  3.1415926476224754`}, {-9.899846505068526, 
                  3.1415926487937513`}, {-10., 3.141592649234559}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.18866752255891192`, 
                  0.5225961012761295, -0.8572107611742444], 
                 
                 ArrowBox[{{-10., -6.283185032566233}, {-9.915813195634188, \
-6.28318501140801}, {-9.764507654977553, -6.283184963255649}, \
{-9.586123991272492, -6.283184895923535}, {-9.369089115784575, \
-6.283184795934355}, {-9.093608038170006, -6.2831846395488835`}, \
{-8.943684749015208, -6.283184531907932}, {-8.76722942981558, \
-6.2831843819989714`}, {-8.553045110905886, -6.2831841605595}, \
{-8.400000000000432, -6.28318396569095}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675261386199, 0.5225961012697375, -0.8572107526189375], 
                 
                 ArrowBox[{{-8.360000000000465, -6.28318391475994}, \
{-8.282035509256493, -6.283183815489685}, {-8.133598227052152, \
-6.283183577513106}, {-7.959207527486207, -6.283183247493432}, \
{-7.748059451410338, -6.2831827627065175`}, {-7.481791041016549, \
-6.283182010428367}, {-7.334960114141904, -6.283181490518241}, \
{-7.162791611303725, -6.283180772750738}, {-6.9548936476883405`, \
-6.2831797245504095`}, {-6.760000000011452, -6.283178516795468}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866754449052978`, 
                  0.5225961012369686, -0.8572107087588734], 
                 
                 ArrowBox[{{-6.72000000001222, -6.283178268915672}, \
{-6.69367475155552, -6.283178105778242}, {-6.548591432399299, \
-6.283176984436523}, {-6.378829445653536, -6.283175443737295}, \
{-6.174430680817721, -6.283173207760833}, {-5.918617557282032, \
-6.283169773567264}, {-5.775449940567919, -6.283167388716806}, \
{-5.608312996803888, -6.283164128741359}, {-5.407707337735487, \
-6.283159429169333}, {-5.157716834891977, -6.2831522563749225`}, \
{-5.120000000292583, -6.283150920838391}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866763914952608`, 
                  0.5225961010679466, -0.857210482529033], 
                 
                 ArrowBox[{{-5.08000000031766, -6.283149504455978}, \
{-5.016668274609526, -6.283147261907414}, {-4.8524196459981725`, \
-6.28314047251322}, {-4.65595930592471, -6.283130755529568}, \
{-4.412286509538648, -6.28311603135288}, {-4.27360781783691, \
-6.283105749558867}, {-4.1125707111125385`, -6.28309185740514}, \
{-3.920685511159536, -6.283072131830511}, {-3.6839287533035394`, \
-6.283042489200947}, {-3.547938660148239, -6.283021728750917}, \
{-3.480000007681546, -6.283009704245387}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866812747257372`, 
                  0.5225961001960023, -0.8572093154635717], 
                 
                 ArrowBox[{{-3.44000000830806, -6.283002624619928}, \
{-3.390521756276306, -6.282993867432471}, {-3.2037517124688955`, \
-6.282954653407402}, {-2.974655278319031, -6.282896292524569}, \
{-2.8417475169106328`, -6.282855290938379}, {-2.688451371799337, \
-6.282800681750036}, {-2.5074506002245425`, -6.282724576789422}, \
{-2.2869001698713927`, -6.282612586004219}, {-2.157869883128194, \
-6.282533848864954}, {-2.0097137160226883`, -6.282429957716577}, \
{-1.8400001989951098`, -6.282290341338943}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867064605707826`, 
                  0.5225960956988457, -0.8572032961839157], 
                 
                 ArrowBox[{{-1.800000217863974, -6.28225154101553}, \
{-1.6256894059200946`, -6.282079468290287}, {-1.4990010597525645`, \
-6.281930359855626}, {-1.35392666831396, -6.281734713631493}, \
{-1.184275881707641, -6.281467348967337}, {-0.9802256644859999, \
-6.281082754080316}, {-0.8709301631232204, -6.280840214633847}, \
{-0.7482088288743968, -6.280534240643878}, {-0.6083432844748505, \
-6.280137106891066}, {-0.4462356371209236, -6.279607317400937}, \
{-0.3414530243164281, -6.279210707517605}, {-0.22433784953298228`, \
-6.278714725022456}, {-0.2000052579918262, -6.2785976795881195`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868360506203782`, 
                  0.5225960725593899, -0.8571723248685691], 
                 
                 ArrowBox[{{-0.16000572075062217`, -6.27840527249487}, \
{-0.0915627615043654, -6.278076045915008}, {-0.04929330020405558, \
-6.2778545103275905`}, {-0.005150156017650596, -6.277612848649464}, {
                  0.09702597164825902, -6.277013675225711}, {
                  0.21087244664025265`, -6.27626910350126}, {
                  0.3703959710530693, -6.275090272926512}, {
                  0.4968535566078617, -6.2739940369089995`}, {
                  0.6417569262111052, -6.272552583044526}, {
                  0.8115227037713775, -6.270567218485406}, {
                  0.9438606432714483, -6.26877308090119}, {
                  1.0965475803379956`, -6.266380949838602}, {
                  1.2771364069667237`, -6.263020565278775}, {
                  1.414645490677282, -6.260032539230811}, {
                  1.4398575000024398`, -6.259395484582715}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18875045643231422`, 
                  0.522595953190323, -0.8570125537382515], 
                 
                 ArrowBox[{{1.4798447367736647`, -6.258385090896075}, {
                  1.5742612037963482`, -6.255999384608333}, {
                  1.7646539679527509`, -6.250231642709853}, {
                  1.9068834496718001`, -6.245166446150191}, {
                  2.0728800988030374`, -6.238252342451235}, {
                  2.2724168582295103`, -6.228198311081252}, {
                  2.419250562263092, -6.219443887851386}, {
                  2.5914832688922704`, -6.207362378941122}, {
                  2.7999704877428657`, -6.189503832772608}, {
                  2.951896171117402, -6.173990860549647}, {
                  3.076096322317631, -6.158959119464139}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18909234663942423`, 
                  0.5225953427149534, -0.8561954547826339], 
                 
                 ArrowBox[{{3.1158065446312437`, -6.154153056230738}, {
                  3.1309250076849935`, -6.152323293383925}, {
                  3.3488838771368483`, -6.119726251240784}, {
                  3.507325334613938, -6.0911716282013675`}, {
                  3.6945485521273222`, -6.050675483502819}, {
                  3.922459439988782, -5.98853733476516}, {
                  4.084186646029734, -5.934398895992653}, {
                  4.272353918785551, -5.857124841409943}, {
                  4.49256662831628, -5.739532009069604}, {
                  4.618923402550919, -5.655038163214345}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.19064139222085652`, 
                  0.5225925767563084, -0.8524933202948065], 
                 
                 ArrowBox[{{4.6499568972392495`, -5.629823813665511}, {
                  4.758053051162645, -5.540589600625541}, {
                  4.896001712406256, -5.392093525346014}, {
                  4.964177318735586, -5.307654773805093}, {
                  5.029283737541955, -5.2114855299690745`}, {
                  5.0592106126908805`, -5.147009656478917}, {
                  5.085348531649694, -5.0788860536278655`}, {
                  5.12839977938844, -4.936519068175497}, {
                  5.150917124775379, -4.7846084891409}, {
                  5.150069060604214, -4.629413708335813}, {
                  5.081657633483946, -4.3304831971283795`}, {
                  5.02182167937293, -4.221559622803227}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1914797959133057, 0.522591079711955, -0.8504895811784482], 
                 
                 
                 ArrowBox[{{5.002562726792532, -4.186501203764342}, {
                  4.9482207459807785`, -4.087578693479923}, {
                  4.790693027977813, -3.9074271214332486`}, {
                  4.634468370523977, -3.7769589844695632`}, {
                  4.4271203204313885`, -3.6463298968197626`}, {
                  4.2464456234203976`, -3.557651644425056}, {
                  4.088698315289305, -3.4942213046188564`}, {
                  3.9498280459887294`, -3.446992529350985}, {
                  3.7219104399548257`, -3.384172839880798}, {
                  3.678158000752533, -3.3743824851702673`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18938741895750735`, 
                  0.5225948158370881, -0.8554902480293448], 
                 
                 ArrowBox[{{3.6391233305181294`, -3.365647811753856}, {
                  3.5341783526788717`, -3.342164582547259}, {
                  3.3750135422258034`, -3.3123766019426535`}, {
                  3.2371176536387036`, -3.2902432438260547`}, {
                  3.0052516758962895`, -3.259762464342706}, {
                  2.8162307258677557`, -3.239383061737911}, {
                  2.656964166484237, -3.2249611198394}, {
                  2.519454370731651, -3.2142504980654265`}, {
                  2.29396201345857, -3.1997592360628926`}, {
                  2.1095117754239663`, -3.189973121292241}, {
                  2.0511885743435947`, -3.187361046265276}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.188808705586065, 0.5225958491812788, -0.8568733414364496], 
                 
                 
                 ArrowBox[{{2.0112286301844327`, -3.185571391886169}, {
                  1.9536915434092992`, -3.1829945239381536`}, {
                  1.8188595775404754`, -3.1777791788017082`}, {
                  1.6030864385589463`, -3.1708343650375657`}, {
                  1.4253029572722882`, -3.1660807961310136`}, {
                  1.2743123749115026`, -3.1626521565406156`}, {
                  1.1431314795677685`, -3.1600670596603755`}, {
                  0.9387166841241212, -3.1566838633493775`}, {
                  0.7687789021477521, -3.154330526516972}, {
                  0.6234984244084102, -3.1526101704354152`}, {
                  0.49665134756220813`, -3.1512995599597966`}, {
                  0.4116913110416376, -3.1505543196090997`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886949530855541, 0.5225960522964848, -0.8571452037110435], 
                 
                 ArrowBox[{{0.371692849792386, -3.150203466802186}, {
                  0.30606183551609367`, -3.1496277740165075`}, {
                  0.145836590867015, -3.1484407860893957`}, {
                  0.007720362592190122, -3.1475584977969744`}, \
{-0.1136318928622113, -3.1468776262687976`}, {-0.2860034713901369, \
-3.146045336806956}, {-0.4331145846090522, -3.145437390479875}, \
{-0.561369658640728, -3.1449751687255416`}, {-0.6750439552295697, \
-3.1446121115694425`}, {-0.8676146878791716, -3.1440871859951742`}, \
{-1.0292285351479673`, -3.143715827602785}, {-1.1683788162749824`, \
-3.143440379711246}, {-1.228289317314106, -3.143336314377052}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867282614057007`, 
                  0.5225960918061128, -0.8571980859032252], 
                 
                 ArrowBox[{{-1.268289256969942, -3.1432668339518206`}, \
{-1.2905279337282054`, -3.1432282050756015`}, {-1.495387648120521, \
-3.14292806452887}, {-1.665615929783313, -3.142719547684993}, \
{-1.8111088677876614`, -3.142567150970865}, {-1.9381158847631255`, \
-3.1424510938759425`}, {-2.1536729280495135`, -3.1422864858646866`}, \
{-2.331271786581536, -3.1421738533069283`}, {-2.4821190008551763`, \
-3.142092563338948}, {-2.613183890599534, -3.1420312555600276`}, \
{-2.8379341755399645`, -3.141944107326941}, {-2.8682885897422574`, \
-3.141934383843476}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886685540395386, 0.522596099434329, -0.8572082959917815], 
                 
                 
                 ArrowBox[{{-2.9082885876900084`, -3.141921570573022}, \
{-3.021778799069015, -3.141885216051849}, {-3.177111161714659, \
-3.141843163899172}, {-3.311544933509639, -3.1418117083415447`}, \
{-3.5444123171028314`, -3.1417668651764474`}, {-3.733706796796173, \
-3.141736879132332}, {-3.892914268346366, -3.1417156663847687`}, \
{-4.030236419106258, -3.1416999125998863`}, {-4.270385247308494, \
-3.1416773868058354`}, {-4.464519371618036, -3.14166245892317}, \
{-4.508288561764187, -3.1416596402295855`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866772182077085`, 
                  0.5225961009203297, -0.857210284949265], 
                 
                 ArrowBox[{{-4.548288561681242, -3.1416570642682125`}, \
{-4.627138227494017, -3.141651986425867}, {-4.766985928629842, \
-3.1416442586673328`}, {-5.01374966225744, -3.1416331767242824`}, \
{-5.2122420547129655`, -3.141625889476888}, {-5.377909096771006, \
-3.141620815765932}, {-5.519999760556708, -3.141617093525899}, \
{-5.77283313225294, -3.1416117408553066`}, {-5.975293955912394, \
-3.141608244714066}, {-6.143716909452099, -3.1416058274288394`}, \
{-6.148288560690634, -3.1416057714691394`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866756046227803`, 
                  0.5225961012084497, -0.8572106705872659], 
                 
                 ArrowBox[{{-6.188288560687638, -3.1416052818456137`}, \
{-6.287824249208079, -3.141604063470245}, {-6.54627222728528, \
-3.1416015202672587`}, {-6.752379174573992, -3.141599868902956}, \
{-6.923317749442885, -3.141598734482218}, {-7.0692565402667595`, \
-3.1415979107541556`}, {-7.332933116484928, -3.141596720275955}, \
{-7.542415133807057, -3.141595951239444}, {-7.715668267474781, \
-3.1415954261326586`}, {-7.788288560649828, -3.141595239421818}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675292148927, 0.5225961012642446, -0.8572107452668133], 
                 
                 ArrowBox[{{-7.828288560649696, -3.141595136579578}, \
{-7.863284132196661, -3.1415950466040035`}, {-8.131857332067623, \
-3.1415944968783305`}, {-8.344483202768973, -3.141594143357776}, \
{-8.51988016157119, -3.141593903346347}, {-8.669042477079355, \
-3.1415937306307646`}, {-8.942223456737821, -3.141593479951456}, \
{-9.157793552495898, -3.141593319376633}, {-9.335187535304959, \
-3.141593210950294}, {-9.42828856064824, -3.1415931629135714`}}]}}, {
                Arrowheads[{{0.0066463929918975624`, 1.}}], {
                 LABColor[
                 0.18866752315392246`, 
                  0.5225961012750671, -0.8572107597522016], 
                 
                 ArrowBox[{{-9.468288560648233, -3.1415931422750347`}, \
{-9.485784354015566, -3.1415931332478455`}, {-9.76239722196294, \
-3.1415930205512534`}, {-9.980154341861454, -3.141592948547634}, {-10., \
-3.1415929431756737`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.1886675225591116, 0.5225961012761291, -0.8572107611737672], 
                 
                 ArrowBox[{{-10., 6.283185336283969}, {-9.911943267776754, 
                  6.283185338637792}, {-9.760643973315824, 
                  6.283185343759044}, {-9.582269040891603, 
                  6.283185350920029}, {-9.365247104802275, 
                  6.283185361553939}, {-9.089786367380022, 
                  6.283185378185364}, {-8.939869776448594, 
                  6.283185389632962}, {-8.763423783124741, 
                  6.2831854055754475`}, {-8.549253215322656, 
                  6.283185429124446}, {-8.400000000000004, 
                  6.283185449335544}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675261396631, 0.5225961012697358, -0.8572107526164444], 
                 
                 ArrowBox[{{-8.360000000000005, 
                  6.283185454752138}, {-8.278265137277158, 
                  6.2831854658202495`}, {-8.129835074771702, 
                  6.2831854911276634`}, {-7.955454384986333, 
                  6.283185526222606}, {-7.744320990157024, 
                  6.283185577774425}, {-7.478075449522351, 
                  6.283185657769348}, {-7.331252350542368, 
                  6.28318571305555}, {-7.159094652536792, 
                  6.283185789379858}, {-6.951212447036405, 
                  6.283185900837817}, {-6.760000000000129, 
                  6.283186026844699}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886675444989382, 0.5225961012369537, -0.8572107087387778], 
                 
                 ArrowBox[{{-6.720000000000137, 
                  6.283186053204255}, {-6.69001796721239, 
                  6.283186072962081}, {-6.544943194356778, 
                  6.2831861921958385`}, {-6.3751929482328675`, 
                  6.28318635601665}, {-6.170811203276394, 
                  6.2831865937583276`}, {-5.915024293455857, 
                  6.283186958891213}, {-5.771866084442843, 
                  6.283187212458132}, {-5.60474199896109, 
                  6.283187559063234}, {-5.404154859217555, 
                  6.2831880587120015`}, {-5.154192687673847, 
                  6.2831888212846785`}, {-5.120000000003283, 
                  6.28318895001607}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866763915193221`, 
                  0.5225961010679422, -0.8572104825232824], 
                 
                 ArrowBox[{{-5.080000000003566, 
                  6.2831891006113}, {-5.013154586741624, 
                  6.283189352276309}, {-4.848920174976458, 
                  6.283190074077724}, {-4.652480166688909, 
                  6.283191107083682}, {-4.408838237587912, 
                  6.2831926723443345`}, {-4.270171318006668, 
                  6.28319376537028}, {-4.109150115708155, 
                  6.283195242158317}, {-3.91728748477404, 
                  6.2831973389792255`}, {-3.680564693146173, 
                  6.283200489847238}, {-3.5445880595580506`, 
                  6.283202696613331}, {-3.4800000000862163`, 
                  6.283203911840172}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866812752516113`, 
                  0.5225961001959085, -0.8572093153378907], 
                 
                 ArrowBox[{{-3.4400000000932964`, 
                  6.283204664441722}, {-3.387189217189519, 
                  6.283205658078648}, {-3.2004445814972406`, 
                  6.283209826076443}, {-2.9713860026755707`, 
                  6.2832160288600365`}, {-2.838493960334481, 
                  6.2832203866994}, {-2.6852187474870983`, 
                  6.283226190595341}, {-2.5042471329992106`, 
                  6.283234278671353}, {-2.283739635439951, 
                  6.2832461798303445`}, {-2.1547281637638136`, 
                  6.28325454724697}, {-2.006596812005581, 
                  6.2832655872898195`}, {-1.840000002235893, 
                  6.283280153237306}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867064537846934`, 
                  0.5225960957000575, -0.857203297805754], 
                 
                 ArrowBox[{{-1.8000000024438316`, 
                  6.283284222944031}, {-1.6226561526252214`, 
                  6.28330282849648}, {-1.4959929287148004`, 
                  6.283318671426992}, {-1.3509514647882128`, 
                  6.283339457812689}, {-1.1813456081476439`, 
                  6.283367861739246}, {-0.9773599414529286, 
                  6.283408715930529}, {-0.868092726391537, 
                  6.283434480128136}, {-0.7454069919775043, 
                  6.283466980652999}, {-0.6055875181826942, 
                  6.283509160811109}, {-0.44354107486580696`, 
                  6.283565425591788}, {-0.3388127507022753, 
                  6.283607537294905}, {-0.22176523620387434`, 
                  6.283660193751797}, {-0.20000005899422163`, 
                  6.283671314342076}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886836049952061, 0.5225960725595092, -0.8571723250282932], 
                 
                 ArrowBox[{{-0.16000006421531157`, 
                  6.283691751738418}, {-0.08907690074003109, 
                  6.283727988863194}, {-0.04689831890087807, 
                  6.283751467193675}, {-0.002854244780279087, 
                  6.283777073556598}, {0.05383066119562072, 
                  6.283811580495019}, {0.1139281680742714, 
                  6.283850378552707}, {0.23711370610929317`, 
                  6.283937517890263}, {0.37758358713043605`, 
                  6.284050746312904}, {0.5403465140674464, 
                  6.284201354268207}, {0.6691846810500103, 
                  6.284341720850569}, {0.8172292148603314, 
                  6.284527329993544}, {0.9913432805273411, 
                  6.2847850092005295`}, {1.1257075710290767`, 
                  6.285016193630389}, {1.281108072045542, 
                  6.2853259194470805`}, {1.439998403969369, 
                  6.285703396338522}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1887503116958804, 0.5225959534487629, -0.8570128996504376], 
                 
                 ArrowBox[{{1.479998275974744, 6.2858042867856}, {
                  1.6047453241698493`, 6.286151208261611}, {1.766678498029619,
                   6.286675900641196}, {1.960426631967405, 
                  6.28743084260146}, {2.1039606051522606`, 
                  6.288089558196157}, {2.2717822314076557`, 
                  6.2889915578909115`}, {2.474071235631591, 
                  6.290309727712528}, {2.621510557112421, 
                  6.291447583112346}, {2.794704515667, 6.293020307304217}, {
                  3.0049014974209958`, 6.295352033883055}, {3.079956235393246,
                   6.2963431233889935`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.189094606084952, 0.5225953386805124, -0.8561900548310043], 
                 
                 
                 ArrowBox[{{3.119952748467223, 6.296871272916295}, {
                  3.155915052875053, 6.29734615116477}, {3.3340670454261483`, 
                  6.300126073228941}, {3.5516574020890337`, 
                  6.304303585866456}, {3.705985240320297, 
                  6.307847374033246}, {3.888762616496173, 
                  6.312826967807431}, {4.113315798445486, 
                  6.320405925578168}, {4.270829843295947, 
                  6.326793778263151}, {4.458055082340915, 
                  6.335838319904809}, {4.689300768207224, 
                  6.349774816900876}, {4.718806094508689, 
                  6.351921411275741}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1908689620226192, 0.5225921704101892, -0.8519494408753807], 
                 
                 ArrowBox[{{4.758700653569749, 6.354823851167211}, {
                  4.849555842634836, 6.3614338183230315`}, {5.040513226304286,
                   6.378048667929832}, {5.277109813694404, 
                  6.403905543941737}, {5.442246818379037, 
                  6.425839599443514}, {5.639620808311531, 6.45747369455099}, {
                  5.884647916215394, 6.50755912999646}, {6.031223073024074, 
                  6.543960970516278}, {6.201021666615915, 
                  6.594133304650145}, {6.327329464637619, 
                  6.640539218517874}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19964823035008814`, 
                  0.5225764942458351, -0.8309674682061444], 
                 
                 ArrowBox[{{6.364875568879733, 6.654333784703162}, {
                  6.401284887140855, 6.667710691859109}, {6.5100731486840635`,
                   6.711962182618751}, {6.629010830748448, 
                  6.766706291995505}, {6.709052861139953, 
                  6.813569982347188}, {6.793165672543308, 
                  6.869307924901068}, {6.9675722447347255`, 
                  7.004367392748246}, {7.145639822547634, 
                  7.197588248751318}, {7.296236339347157, 
                  7.466553762900125}, {7.357610086162143, 
                  7.7883298782175405`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.21829818735126968`, 
                  0.5225431930890365, -0.7863950877428582], 
                 
                 ArrowBox[{{7.3651043572904555`, 7.8276215554565605`}, {
                  7.377386642175306, 7.892016286470509}, {7.277186205109651, 
                  8.315012817572505}, {7.063221900425309, 8.62430400213651}, {
                  6.832047200759293, 8.81632418558832}, {6.601254672884259, 
                  8.95062255919936}, {6.4589937372326816`, 
                  9.014903425439964}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.20026107609615026`, 
                  0.522575399955254, -0.8295028002845477], 
                 
                 ArrowBox[{{6.42254218107947, 9.031374128339635}, {
                  6.405752039699858, 9.038960784699235}, {6.2374850958045736`,
                   9.10097460500612}, {6.090958073538787, 
                  9.146295234263683}, {5.814993509415892, 9.21296265405454}, {
                  5.596438606170452, 9.254928871229136}, {5.415952574968501, 
                  9.28321258736165}, {5.2625530756385155`, 
                  9.303400652881107}, {5.008507615425308, 
                  9.330157656776656}, {4.859498205606541, 
                  9.34294058936107}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19100695588710173`, 
                  0.5225919240098722, -0.8516196430624997], 
                 
                 ArrowBox[{{4.8196445831955295`, 9.34635947524985}, {
                  4.804993413676951, 9.34761634159451}, {4.635660318660443, 
                  9.359657459949359}, {4.490786061008971, 
                  9.368429617692781}, {4.2444669800039865`, 
                  9.38051535603572}, {4.04619431481158, 9.388473299277907}, {
                  3.880646519844046, 9.39401360555839}, {3.7386220868408726`, 
                  9.398078986496035}, {3.499873958984268, 
                  9.403657573343315}, {3.306637099628257, 
                  9.407364186420718}, {3.2211098709606447`, 
                  9.40873866124972}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1891221510058812, 0.5225952894966066, -0.8561242239716941], 
                 
                 ArrowBox[{{3.1811150352511635`, 9.409381402699772}, {
                  3.144645059088934, 9.409967497502914}, {3.00525582380938, 
                  9.411890700928144}, {2.774338503461461, 
                  9.414509468070134}, {2.586328565563206, 
                  9.416266442292862}, {2.428033842255294, 
                  9.417511659261027}, {2.291389382867712, 
                  9.418437967002086}, {2.0691866708059568`, 
                  9.419685161598089}, {1.8870489265112134`, 
                  9.420531483666519}, {1.7329413056440048`, 
                  9.421137382974088}, {1.599424703689765, 9.42159161232726}, {
                  1.5811716106311227`, 9.421643449581122}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1887558719219333, 0.5225959435204848, -0.8569996110133069], 
                 
                 ArrowBox[{{1.5411717719326223`, 9.421757045769251}, {
                  1.3872397115396775`, 9.42219419991438}, {1.211937892942484, 
                  9.422608749606193}, {1.0627558775259838`, 
                  9.422909029690553}, {0.9329489044570857, 
                  9.423136179001588}, {0.7326767704495813, 
                  9.423431499930443}, {0.5656326174162293, 
                  9.42363817089417}, {0.4224768768706153, 
                  9.423790004080718}, {0.29725362630268753`, 
                  9.423906118739087}, {0.11187962403580923`, 
                  9.424052628449374}, {-0.04462826397703775, 
                  9.42415748552884}, {-0.058826040869019984`, 
                  9.424165714072249}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868462302981395`, 
                  0.5225960707417179, -0.8571698919810823], 
                 
                 ArrowBox[{{-0.09882603415109545, 
                  9.424188896693277}, {-0.1799710155252141, 
                  9.424235925534964}, {-0.29917708066517323`, 
                  9.42429676029792}, {-0.4784213934859861, 
                  9.4243752442153}, {-0.630520843903227, 
                  9.424431946421775}, {-0.7625533745108176, 
                  9.424474689379442}, {-0.8791845423474011, 
                  9.424508036104092}, {-1.0762503772300582`, 
                  9.424555922737662}, {-1.241033194808582, 
                  9.424589572486887}, {-1.3825275920421245`, 
                  9.424614396399027}, {-1.5064785136459806`, 
                  9.424633437661711}, {-1.6988259510644392`, 
                  9.424658278170911}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18867083808508292`, 
                  0.5225960953559626, -0.8572028372474536], 
                 
                 ArrowBox[{{-1.7388259507909711`, 
                  9.424662936482823}, {-1.8880206412128637`, 
                  9.424679006156678}, {-2.035439504099426, 
                  9.424692553305682}, {-2.163910652617368, 
                  9.424702834210652}, {-2.382722156383837, 
                  9.424717425701736}, {-2.5625411878155053`, 
                  9.424727365226781}, {-2.714988154195814, 
                  9.424734511705244}, {-2.8472578166682636`, 
                  9.424739885759882}, {-3.074863857149427, 
                  9.424747532164647}, {-3.260632608073099, 
                  9.424752679915576}, {-3.338825947632679, 
                  9.424754508065153}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866816538269104`, 
                  0.5225961001283104, -0.8572092248604581], 
                 
                 ArrowBox[{{-3.3788259476217464`, 
                  9.424755443259677}, {-3.4173371957033547`, 
                  9.424756343647386}, {-3.5527961456292854`, 
                  9.424759077229165}, {-3.788213456058023, 
                  9.424762978174519}, {-3.979207923374595, 
                  9.424765578354322}, {-4.139616875374109, 
                  9.42476741240046}, {-4.2778303586069075`, 
                  9.424768771408024}, {-4.520287286070425, 
                  9.424770716552288}, {-4.715946168676047, 
                  9.424772002057491}, {-4.879634014271729, 
                  9.424772901509547}, {-4.978825947500857, 
                  9.424773368685772}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866764625547322`, 
                  0.5225961010552582, -0.8572104655462067], 
                 
                 ArrowBox[{{-5.018825947500413, 
                  9.424773557078602}, {-5.020269793016107, 
                  9.424773563878855}, {-5.269145184070364, 
                  9.424774514655113}, {-5.469021458502248, 
                  9.424775138373176}, {-5.63565167106289, 
                  9.424775571584329}, {-5.778448364284946, 
                  9.424775888812869}, {-6.03323040063445, 
                  9.424776345405519}, {-6.2369593253036975`, 
                  9.424776643012212}, {-6.406258985063914, 
                  9.424776848321565}, {-6.551005616384596, 
                  9.424776997884402}, {-6.61882594749584, 
                  9.424777054122872}}]}}, {
                Arrowheads[{{0.01999999999999999, 1.}}], {
                 LABColor[
                 0.18866754606159927`, 
                  0.5225961012341633, -0.8572107050041028], 
                 
                 ArrowBox[{{-6.658825947495826, 
                  9.424777087291965}, {-6.811264650820424, 
                  9.4247772136983}, {-7.018542811473131, 
                  9.424777353576573}, {-7.190286113300015, 
                  9.424777449466376}, {-7.336808863489391, 
                  9.424777518982612}, {-7.602178627944569, 
                  9.424777619527324}, {-7.812749556050845, 
                  9.424777684374712}, {-7.986746558978138, 
                  9.424777728566024}, {-8.134899771931469, 
                  9.424777760457843}, {-8.258825947495643, 
                  9.424777781662172}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866752642837187`, 
                  0.5225961012692202, -0.857210751926446], 
                 
                 ArrowBox[{{-8.298825947495642, 
                  9.424777788506352}, {-8.405063959961982, 
                  9.424777806684157}, {-8.61870793707296, 9.424777836370218}, 
                  {-8.794796631705305, 
                  9.424777856486969}, {-8.944456499751768, 
                  9.424777870942624}, {-9.219138921570234, 
                  9.424777891937218}, {-9.435665547368181, 
                  9.424777905369158}, {-9.613706102255048, 
                  9.424777914422759}, {-9.764766103727402, 
                  9.424777920902107}, {-9.898825947495634, 
                  9.424777925442928}}]}}, {
                Arrowheads[{{0.0007646756563045814, 1.}}], {
                 LABColor[
                 0.1886675226149299, 0.5225961012760294, -0.8572107610403645], 
                 
                 ArrowBox[{{-9.938825947495634, 9.424777926797793}, {-10., 
                  9.424777928869856}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886681403293322, 0.5225961001730455, -0.8572092847366198], 
                 
                 ArrowBox[{{-3.4159481102459615`, 
                  6.185428300356614}, {-3.2820608236900366`, 
                  6.171396415170626}, {-3.1277792774046733`, 
                  6.1526751985834744`}, {-2.945986204935646, 
                  6.126536758286624}, {-2.7252822930499834`, 
                  6.088001787790077}, {-2.58365282096052, 
                  6.057895178710294}, {-2.4201457576658316`, 
                  6.017069904881349}, {-2.2275689333083317`, 
                  5.959023701782122}, {-1.9948930560193119`, 
                  5.87110451113556}, {-1.8719764516254302`, 
                  5.813279282573111}, {-1.8691467023057498`, 
                  5.811714154585697}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18867053513778104`, 
                  0.5225960958969019, -0.8572035612749888], 
                 
                 ArrowBox[{{-1.8341439509374993`, 
                  5.7923542114904185`}, {-1.7367638447131144`, 
                  5.7384934936490675`}, {-1.588850688449259, 
                  5.639182986903637}, {-1.4301330054918133`, 
                  5.504179919287313}, {-1.3466879502747167`, 
                  5.413621561365158}, {-1.2663109695673573`, 
                  5.306919513509561}, {-1.1934511672204409`, 
                  5.1825788077525985`}, {-1.1614118723630298`, 
                  5.113671397857423}, {-1.133520434566627, 
                  5.040508464343459}, {-1.095250320225643, 
                  4.892092506782325}, {-1.079418963107139, 
                  4.735475246735262}, {-1.0791711246275613`, 
                  4.72474240788765}, {-1.0790384591349178`, 
                  4.714004865979633}, {-1.0829906029539251`, 
                  4.650497233738406}, {-1.090847175426776, 
                  4.587858457974864}, {-1.1070729635437242`, 
                  4.501231210330055}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867369819221497`, 
                  0.5225960902489871, -0.857196001747337], 
                 
                 ArrowBox[{{-1.1148435660077778`, 
                  4.462016294407862}, {-1.149962251522872, 
                  4.34992367658024}, {-1.1967100838259261`, 
                  4.243613911682192}, {-1.3309404243388865`, 
                  4.036475688050423}, {-1.477539064929285, 
                  3.881328524972534}, {-1.6209965815686345`, 
                  3.765759164713793}, {-1.7551271211662276`, 
                  3.678245831558578}, {-1.9436648295966652`, 
                  3.579524316243743}, {-2.107812222813957, 
                  3.509994505352853}, {-2.251854522601193, 
                  3.4588100740506267`}, {-2.268871885347953, 
                  3.453605553601839}}]}}, {
                Arrowheads[{{0.019046953217449543`, 1.}}], {
                 LABColor[
                 0.18866940016943826`, 
                  0.5225960979234889, -0.8572062737874513], 
                 
                 ArrowBox[{{-2.3071229501131842`, 
                  3.441907004789013}, {-2.3795195516379013`, 
                  3.419765525015371}, {-2.610934265360044, 
                  3.3620208113549808`}, {-2.800698719003929, 
                  3.3235768256363247`}, {-2.9611288810080847`, 
                  3.2963986258575435`}, {-3.09986402720154, 
                  3.276251592596359}, {-3.3286157583123024`, 
                  3.2489803276607288`}, {-3.51548300325166, 
                  3.230662507944199}, {-3.673172319025676, 
                  3.217653091148493}, {-3.8094820752121885`, 
                  3.2079635742221644`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867291708983328`, 
                  0.5225960916437148, -0.8571978685394446], 
                 
                 ArrowBox[{{-1.250052310897808, -0.4032296215304988}, \
{-1.1359183313111214`, -0.45533269851020713`}, {-1.0109714016847575`, \
-0.5214762964502873}, {-0.8745962478555608, -0.6073874862855233}, \
{-0.7275629921558572, -0.7213149666744528}, {-0.6566211166758911, \
-0.7881973523799318}, {-0.5858592871988167, -0.8652807283176572}, \
{-0.5171226635027151, -0.9539094513884767}, {-0.48419175805985915`, \
-1.0028814966796833`}, {-0.45278671284925237`, -1.0551084055077251`}, \
{-0.3941017661916564, -1.1755068617084234`}, {-0.3488499254417703, \
-1.3090036747457314`}, {-0.3174699930327733, -1.4947690355657055`}, \
{-0.31917366279144277`, -1.5831812798535574`}}]}}, {
                Arrowheads[{{0.018310780186033028`, 1.}}], {
                 LABColor[
                 0.18868119682190837`, 
                  0.5225960768595168, -0.8571780804311846], 
                 
                 ArrowBox[{{-0.3199443042603152, -1.6231738555611366`}, \
{-0.32114994598131796`, -1.6857408465043602`}, {-0.32373206590943876`, \
-1.708107954292197}, {-0.32680584930106393`, -1.7303542143704067`}, \
{-0.3381395419689403, -1.7829404414962613`}, {-0.35195736690612967`, \
-1.834164141729307}, {-0.3840021656567526, -1.9334325356817947`}, \
{-0.4239267791538038, -2.0258295114890035`}, {-0.4698624130615308, \
-2.1106356783402185`}, {-0.6048836200569085, -2.293881311870066}, \
{-0.7459470735853897, -2.432131106616568}, {-0.8821629716406474, \
-2.5365819040395174`}, {-1.0093285960554916`, -2.616836196643039}, \
{-1.1889223165446532`, -2.709064912467325}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18899849849905503`, 
                  0.5225955102891541, -0.8564197467216471], 
                 
                 ArrowBox[{{2.866738296694828, -6.29248805720855}, {
                  3.016852544829982, -6.29400293604726}, {
                  3.1937547208811727`, -6.296110229442347}, {
                  3.409475939864204, -6.299266158031163}, {
                  3.562956399669304, -6.301948421470676}, {
                  3.744553010995287, -6.305709813318921}, {
                  3.967333577476069, -6.311416094154538}, {
                  4.123975397503644, -6.316230883293661}, {
                  4.309996272850195, -6.323033979088491}, {
                  4.466199392867394, -6.330146191990742}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19037771237093482`, 0.52259304758013, -0.8531235007606632], 
                 
                 ArrowBox[{{4.506157994286133, -6.331965579980783}, {
                  4.539464836464937, -6.333482101242658}, {
                  4.699103714892584, -6.342244389598515}, {
                  4.889284774853072, -6.354713747166697}, {
                  5.124942667152153, -6.374084809633639}, {
                  5.2875408392263035`, -6.390279678236442}, {
                  5.481633845051854, -6.413488217853693}, {
                  5.7225451797707905`, -6.449912492467}, {
                  5.885733667016682, -6.480001278868336}, {
                  6.07956700570441, -6.523159594295847}, {
                  6.091775573111769, -6.5266237568227705`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19736049406089456`, 
                  0.5225805792024317, -0.8364350332131383], 
                 
                 ArrowBox[{{6.130256449306234, -6.537542647210819}, {
                  6.317143762884598, -6.590571639626867}, {
                  6.488717527972064, -6.65108331502497}, {
                  6.689621118992423, -6.739575805471297}, {
                  6.924783182818216, -6.878311914695866}, {
                  7.028143871787151, -6.954490880330813}, {
                  7.135276693165503, -7.048625949603108}, {
                  7.24265425189491, -7.165345623544199}, {
                  7.295805611526186, -7.2299567208914235`}, {
                  7.347341435203747, -7.301556431280544}, {
                  7.390968648589704, -7.388396675232447}, {
                  7.402783138339105, -7.418736131284695}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.22004902178288888`, 
                  0.5225400668184542, -0.7822106889043298], 
                 
                 ArrowBox[{{7.41729786167319, -7.456009752071184}, {
                  7.427549453840607, -7.482335707455307}, {
                  7.482377168263368, -7.681068515274805}, {
                  7.496302440319218, -7.893571946348546}, {
                  7.466265198409646, -8.102663835404053}, {
                  7.342986479516222, -8.404446484420532}, {
                  7.171434453939578, -8.630160856396211}, {
                  6.992258952458763, -8.78864673520059}, {
                  6.914341266752664, -8.838836538957306}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.20715027631567504`, 
                  0.5225630986755937, -0.8130379873494317], 
                 
                 ArrowBox[{{6.880713745975349, -8.860497329487}, {
                  6.77140510145974, -8.930907267454671}, {
                  6.579151120154886, -9.023876330791117}, {
                  6.413030494405275, -9.088370778659767}, {
                  6.15882125906349, -9.16716802483341}, {
                  5.953608884950863, -9.216036445632785}, {
                  5.782310128183895, -9.24943677342751}, {
                  5.537388764354805, -9.288334098902668}, {
                  5.3601542933276285`, -9.310501481378255}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19252032288539575`, 
                  0.5225892217585104, -0.8480027784432262], 
                 
                 ArrowBox[{{5.320415284797155, -9.315044300430593}, {
                  5.176159796437379, -9.330038182771354}, {
                  4.93886157583235, -9.350357379968775}, {
                  4.747604197557613, -9.363398212961494}, {
                  4.5872012228190835`, -9.372545573855497}, {
                  4.356940661806786, -9.383430133541436}, {
                  4.170398935994335, -9.390507231646025}, {
                  4.01338639336287, -9.395511538662879}, {
                  3.7899812715638355`, -9.401442318913457}, {
                  3.7233305524915044`, -9.402872277729124}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18941900630514621`, 
                  0.5225947594350698, -0.8554147559905859], 
                 
                 ArrowBox[{{3.6833397552384426`, -9.40373026086679}, {
                  3.607971808685149, -9.40534724356544}, {
                  3.454196435344054, -9.408129899489962}, {
                  3.2378705759012427`, -9.411405520015155}, {
                  3.0605646134602966`, -9.41359032390703}, {
                  2.9101600503131686`, -9.415159831978029}, {
                  2.7013160958147306`, -9.41699223137728}, {
                  2.5290367062510906`, -9.418231218754897}, {
                  2.3822600482409153`, -9.419129040397777}, {
                  2.1814272000473407`, -9.420167292110746}, {
                  2.083447538124334, -9.420585668919118}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1888130783805464, 0.5225958413732654, -0.8568628906960376], 
                 
                 ArrowBox[{{2.0434479027837136`, -9.420756468852915}, {
                  2.0146033096237566`, -9.420879636340823}, {
                  1.8717986736869576`, -9.421400757040278}, {
                  1.6796321644433083`, -9.42199676997316}, {
                  1.5187995522415392`, -9.422412199849694}, {
                  1.3804005167845983`, -9.422719322045518}, {
                  1.197713581856749, -9.423066040759577}, {
                  1.043543635685025, -9.423311916620912}, {
                  0.9100987734731374, -9.423495843306585}, {
                  0.7379253635678573, -9.42370022624226}, {
                  0.5912808200956128, -9.423847966988138}, {
                  0.4635026324645959, -9.423959975508328}, {
                  0.44345182038283765`, -9.423974927898875}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886957963831379, 0.5225960507907018, -0.8571431882757936], 
                 
                 ArrowBox[{{0.4034518315049466, -9.424004756888005}, {
                  0.30217385887174797`, -9.424080282397622}, {
                  0.1627819123405401, -9.424170911234159}, {
                  0.04042673181306728, -9.424240787815384}, \
{-0.06857529951120456, -9.424296201947792}, {-0.2478052451440408, \
-9.424374772630228}, {-0.39988995274386346`, -9.424431532457179}, \
{-0.5319128283137355, -9.42447432380935}, {-0.6485364448719817, \
-9.424507708770477}, {-0.8395142860343402, -9.424554345038365}, \
{-1.0000038356806684`, -9.42458742316764}, {-1.1383183088291189`, \
-9.424612003886843}, {-1.1965480253102887`, -9.424621091495405}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18867299737878018`, 
                  0.5225960915003517, -0.8571976766532388], 
                 
                 ArrowBox[{{-1.2365480248231644`, -9.42462733408699}, \
{-1.2598230393676773`, -9.424630966497283}, {-1.4642128148312614`, \
-9.424657887922812}, {-1.6341140477338694`, -9.424676603414635}, \
{-1.779367970980622, -9.42469028960015}, {-1.9061929168795508`, \
-9.42470071676516}, {-2.121264338555586, -9.424715499857795}, \
{-2.2985310874546774`, -9.424725622002624}, {-2.4491384553912106`, \
-9.424732931563064}, {-2.5800224078619465`, -9.424738446742769}, \
{-2.804356489156216, -9.424746285696127}, {-2.83654801942149, \
-9.424747215187743}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866858736134737`, 
                  0.5225960993748301, -0.8572082163544753], 
                 
                 ArrowBox[{{-2.876548019404816, -9.424748370139506}, \
{-2.9879200516539806`, -9.424751585872633}, {-3.1430515964752637`, \
-9.424755372360382}, {-3.277335120204963, -9.42475820575087}, \
{-3.5098313214591284`, -9.424762244455339}, {-3.6988778683444, \
-9.424764946354632}, {-3.8579098214466, -9.424766858549015}, \
{-3.995101594222679, -9.424768279117865}, {-4.234915277547451, \
-9.424770310049125}, {-4.428827633390313, -9.424771656494466}, \
{-4.476548019194969, -9.424771934054263}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886677282680123, 0.5225961009088176, -0.8572102695407094], 
                 
                 ArrowBox[{{-4.516548019194293, -9.42477216670938}, \
{-4.591290779304788, -9.424772601441518}, {-4.731023555488339, \
-9.424773298932735}, {-4.977481235024212, -9.424774299027622}, \
{-5.17577276162567, -9.42477495689868}, {-5.341299813716123, \
-9.424775415098853}, {-5.483287752698833, -9.424775751339881}, \
{-5.735839122358104, -9.42477623479975}, {-5.938116195688314, \
-9.424776550671863}, {-6.1064119546238205`, -9.4247767691414}, \
{-6.116548019186277, -9.424776780364747}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866756171778576`, 
                  0.5225961012062079, -0.8572106675866709], 
                 
                 ArrowBox[{{-6.1565480191862525`, -9.42477682465549}, \
{-6.250426453941708, -9.424776928604132}, {-6.50861267435088, \
-9.424777158483137}, {-6.714550148598051, -9.424777307789013}, \
{-6.885372145807822, -9.424777410387131}, {-7.031226263791246, \
-9.42477748490314}, {-7.294658378279584, -9.424777592584018}, \
{-7.50398301841663, -9.424777662160967}, {-7.677128526286968, \
-9.424777709682395}, {-7.756548019185947, -9.424777728175245}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675294550018, 0.522596101263816, -0.8572107446929657], 
                 
                 
                 ArrowBox[{{-7.796548019185946, -9.424777737489256}, \
{-7.824666579077473, -9.424777744036671}, {-8.093010281316662, \
-9.424777793791762}, {-8.305489157279336, -9.424777825795061}, \
{-8.480786140896685, -9.424777847528524}, {-8.629876488131469, \
-9.424777863171443}, {-8.902841056788402, -9.424777885873421}, \
{-9.118273169500045, -9.424777900417961}, {-9.295573791558304, \
-9.424777910241517}, {-9.396548019185934, -9.42477791496477}}]}}, {
                Arrowheads[{{0.00704314976017584, 1.}}], {
                 LABColor[
                 0.1886675232001312, 0.5225961012749846, -0.8572107596417653], 
                 
                 ArrowBox[{{-9.436548019185933, -9.424777916835843}, \
{-9.446103678467969, -9.424777917282826}, {-9.722782489900863, \
-9.424777927502127}, {-9.940580739976172, -9.424777934030766}, {-10., \
-9.424777935488809}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18928158123936487`, 
                  0.5225950048197463, -0.8557431944055812], 
                 
                 ArrowBox[{{3.484575070250456, -0.41956563885293485`}, {
                  3.660943780936254, -0.5053300757071458}, {
                  3.81199324094116, -0.5990717111849212}, {
                  3.975164497122321, -0.7280972039447234}, {
                  4.141010390768119, -0.9079461277486115}, {
                  4.233278186385961, -1.0456402691930184`}, {
                  4.310004540001665, -1.2085735654370764`}, {
                  4.360759456981578, -1.3933821460856157`}, {
                  4.381024671628149, -1.5054904897400094`}, {
                  4.388802689204095, -1.621547537293599}, {
                  4.387860860035796, -1.6271770238204655`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.19017280821044064`, 
                  0.5225934134547311, -0.8536132105331564], 
                 
                 ArrowBox[{{4.381260481447036, -1.6666287031571558`}, {
                  4.3698120625450665`, -1.7350580129851927`}, {
                  4.347103707488552, -1.8229668210497405`}, {
                  4.318038059159805, -1.906223468883534}, {
                  4.250094580933745, -2.0621744739021133`}, {
                  4.166814428125568, -2.1963771307644433`}, {
                  4.075800320587921, -2.3091207913384246`}, {
                  3.8992570290527464`, -2.4757635492886148`}, {
                  3.731633079443472, -2.5933646460059223`}, {
                  3.579279148970825, -2.678291067850795}, {
                  3.3948299816429612`, -2.759072956622604}, {
                  3.3428428019167584`, -2.7781355751912704`}}]}}, {
                Arrowheads[{{0.002756917488576082, 1.}}], {
                 LABColor[
                 0.18918233374732735`, 
                  0.5225951820349695, -0.8559803905007166], 
                 
                 ArrowBox[{{3.305287901671877, -2.7919061767611737`}, {
                  3.2354870937019173`, -2.817500682659046}, {
                  3.0958777033084566`, -2.860928908840421}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.21782918332542456`, 
                  0.522544030537434, -0.7875159817951854], 
                 
                 ArrowBox[{{7.344977465891532, -0.2710819234082372}, {
                  7.467774957650849, -0.30754967259141713`}, {
                  7.605810825521609, -0.3548281403710546}, {
                  7.762548998656148, -0.41749925704536983`}, {
                  7.892496531037978, -0.4803787442742939}, {
                  8.03580308180514, -0.5632797802027186}, {
                  8.191869220632112, -0.6755553784073273}, {
                  8.316069261986478, -0.7879339213563378}, {
                  8.438811649347683, -0.9320209566313922}, {
                  8.547958604248814, -1.1135812147507202`}, {
                  8.57489212040869, -1.1956743175902993`}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.28950741377582095`, 
                  0.5224160426824963, -0.6162089188154819], 
                 
                 ArrowBox[{{8.587361564833097, -1.2336810664087212`}, {
                  8.635608581797817, -1.380737518372774}, {
                  8.648504114066586, -1.675454438874773}, {
                  8.580691197404445, -1.9565822128363233`}, {
                  8.371167501571326, -2.306367515096368}, {
                  8.128526301685843, -2.526538188617959}, {
                  8.021610379285859, -2.592565710648525}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.24445551211701447`, 
                  0.5224964868594513, -0.723880507613443], 
                 
                 ArrowBox[{{7.987577209494116, -2.613583402099453}, {
                  7.907345894014007, -2.663131447250162}, {
                  7.71591131806418, -2.7526417985925056`}, {
                  7.627376444646712, -2.7888550349575634`}, {
                  7.545199641279608, -2.819060507722399}, {
                  7.473460805741214, -2.8413042156368666`}, {
                  7.406009700562348, -2.860780833905918}, {
                  7.278629878398143, -2.8953166037639746`}, {
                  7.164873092325988, -2.922363783470843}, {
                  7.062243084140141, -2.9441136481036625`}, {
                  6.8265972122362495`, -2.9865837617235935`}, {
                  6.635606708841702, -3.0138690218483433`}, {
                  6.475069849849371, -3.0329840327474433`}, {
                  6.4571621922210785`, -3.0347437238335977`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.20025105645765554`, 
                  0.5225754178462095, -0.8295267466742935], 
                 
                 ArrowBox[{{6.417353923949108, -3.0386554724434642`}, {
                  6.238291845913113, -3.0562509586387345`}, {
                  6.04729655985285, -3.071194712289869}, {
                  5.88704744366667, -3.0816802109768546`}, {
                  5.64629182983402, -3.0946845668513703`}, {
                  5.452972410111643, -3.102976963380567}, {
                  5.2911875767886, -3.108773653797892}, {
                  5.0545306162825785`, -3.1157821702423876`}, {
                  4.863899433300709, -3.1202859123818025`}, {
                  4.819940842863478, -3.1211555483538547`}}]}}, {
                Arrowheads[{{0.008140585218700964, 1.}}], {
                 LABColor[
                 0.1909161717626728, 0.5225920861129999, -0.8518366121704615], 
                 
                 ArrowBox[{{4.779948667965649, -3.1219467164405885`}, {
                  4.704024336023496, -3.123448732987393}, {
                  4.473019677939876, -3.127238628842237}, {
                  4.2860570599778205`, -3.129699502592345}, {
                  4.12877360035419, -3.131438439275138}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866893199518783`, 
                  0.5225960987594557, -0.8572073926983854], 
                 
                 ArrowBox[{{-2.591841257389566, 
                  0.45817566010679284`}, {-2.5411820134615972`, 
                  0.48400229411549534`}, {-2.4885999182888123`, 
                  0.512640966459693}, {-2.414466218291514, 
                  0.5565948700756631}, {-2.3682403937058036`, 
                  0.5873585676724552}, {-2.3208918511471244`, 
                  0.6212368252849183}, {-2.2243430727377045`, 
                  0.6962375483590804}, {-2.125175528310473, 
                  0.787537457537924}, {-2.0265570840121425`, 
                  0.8988852733769728}, {-1.8610636132379361`, 
                  1.1774541473364026`}, {-1.7810590070008878`, 
                  1.534643871953524}, {-1.806833167025424, 
                  1.7203405576461965`}}]}}, {
                Arrowheads[{{0.017600051931637113`, 1.}}], {
                 LABColor[
                 0.1886705879415408, 0.5225960958026162, -0.8572034350768818], 
                 
                 ArrowBox[{{-1.8123323336866661`, 
                  1.7599607439914409`}, {-1.832400840967444, 
                  1.9045495602823321`}, {-1.988676529918269, 
                  2.206546034765622}, {-2.182390818778003, 
                  2.416577400049575}, {-2.369332828552284, 
                  2.5575713137266916`}, {-2.537726226743129, 
                  2.6562261379757786`}, {-2.7252154867646166`, 
                  2.7438501419230996`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866952369341233`, 
                  0.5225960977029259, -0.8572059785718875], 
                 
                 ArrowBox[{{-2.241229444427472, 
                  6.718693522993151}, {-2.092616631047175, 
                  6.794386916064586}, {-1.926998489807671, 
                  6.89769992632857}, {-1.7461142875291265`, 
                  7.044408310533978}, {-1.56244514287546, 
                  7.258303079913183}, {-1.4919992815174528`, 
                  7.377504978837711}, {-1.4336590932075346`, 
                  7.513026860641258}, {-1.3931597847151966`, 
                  7.662526328614319}, {-1.3753791843821441`, 
                  7.821984685118697}, {-1.381234094501316, 
                  7.9436912804186735`}}]}}, {
                Arrowheads[{{0.016169438926268844`, 1.}}], {
                 LABColor[
                 0.18867224381473702`, 
                  0.5225960928459074, -0.8571994776302186], 
                 
                 ArrowBox[{{-1.3832487457064557`, 
                  7.983633289300674}, {-1.4153401600912137`, 
                  8.137885955459875}, {-1.4395789341145917`, 
                  8.21103339222966}, {-1.468198015118508, 
                  8.280415300312644}, {-1.5683153950119537`, 
                  8.458970076027171}, {-1.575822175379759, 
                  8.469763606078311}, {-1.659055419382331, 
                  8.56633510744993}, {-1.7427012575890584`, 
                  8.648635987133853}, {-1.8927018851798894`, 
                  8.779206625376537}, {-2.0347564907140314`, 
                  8.87643798098034}, {-2.165563891312666, 
                  8.950225586723008}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19258852817611227`, 
                  0.5225890999718982, -0.8478397715168707], 
                 
                 ArrowBox[{{5.338918379523229, -6.227872012718156}, {
                  5.501825150204932, -6.218020252675492}, {
                  5.6966422208032315`, -6.203890435224742}, {
                  5.939450988863595, -6.181647500069684}, {
                  6.103916681646616, -6.163315540289854}, {
                  6.300567772494799, -6.1369253658999865`}, {
                  6.545143463683113, -6.095212391866268}, {
                  6.705894266108109, -6.0617237386269105`}, {
                  6.895872474849084, -6.0139756867641765`}, {
                  6.920208349791342, -6.0062025122646245`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.20857975540434612`, 
                  0.5225605462135547, -0.8096216102607058], 
                 
                 ArrowBox[{{6.9583118120184135`, -5.9940318029052575`}, {
                  7.126621129426929, -5.940271759462351}, {
                  7.292262501977963, -5.874592600283742}, {
                  7.48348067648602, -5.780074226538409}, {
                  7.7020855296120105`, -5.636152206547851}, {
                  7.830807707438685, -5.5265022990112325`}, {
                  7.960101214733374, -5.384321785619567}, {
                  8.078125658381193, -5.20246533660447}, {
                  8.132366309808193, -5.100893143945117}, {
                  8.161562427561332, -5.029774452868476}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.255662083252245, 0.5224764765300697, -0.6970974135668064], 
                 
                 
                 ArrowBox[{{8.176753240446168, -4.992771220524559}, {
                  8.178530884888739, -4.988441064473531}, {
                  8.197421935381879, -4.853240803579432}, {
                  8.197686907691455, -4.716821860048367}, {
                  8.167509414859639, -4.466251045103604}, {
                  8.08499313897978, -4.242042840292269}, {
                  7.970324004544334, -4.057519316396523}, {
                  7.773619574154341, -3.845995452875359}, {
                  7.582159972409236, -3.7033186212768863`}, {
                  7.5071790378176635`, -3.6607594029561263`}}]}}, {
                Arrowheads[{{0.01901062752832188, 1.}}], {
                 LABColor[
                 0.2219497007032053, 0.5225366729872113, -0.7776681699071264], 
                 
                 ArrowBox[{{7.4723920934814965`, -3.64101431486434}, {
                  7.409211120013733, -3.6051527607482234`}, {
                  7.204688406077506, -3.5173706150639}, {
                  7.0311013588440705`, -3.4554465267154733`}, {
                  6.880830382084662, -3.4104945665870923`}, {
                  6.748782703427116, -3.376623641047907}, {
                  6.5097775818392964`, -3.326796886916816}, {
                  6.315423393082191, -3.2938917838945856`}, {
                  6.1519899742444535`, -3.2708076783695272`}, {
                  6.011172098485628, -3.253791909349166}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19320078700432475`, 
                  0.5225880067293112, -0.8463765062969368], 
                 
                 ArrowBox[{{5.484570857515297, 6.227294771013592}, {
                  5.679356839404686, 6.215184661135726}, {5.922235968246564, 
                  6.196120110648715}, {6.086908302975352, 
                  6.180399295761612}, {6.284008942282499, 
                  6.157756510266473}, {6.5297115704757624`, 
                  6.121902470219001}, {6.69201080995455, 6.092992178214435}, {
                  6.884691310320819, 6.05160609275096}, {7.06524061564424, 
                  6.0023036474381275`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.21161736296403055`, 
                  0.5225551222951172, -0.8023618937991702], 
                 
                 ArrowBox[{{7.103827817781008, 5.991766672955089}, {
                  7.120808610936453, 5.98712974220415}, {7.284292655746059, 
                  5.932059956541234}, {7.474773092461258, 
                  5.853117719739726}, {7.697862386249488, 
                  5.732310531920911}, {7.828558706211671, 
                  5.643241825881062}, {7.966587184791807, 
                  5.526400814011548}, {8.104940682677185, 5.3722271281102}, {
                  8.172917765732297, 5.284536272950662}, {8.237189581812084, 
                  5.184732177156427}, {8.266853116727493, 
                  5.115072755829406}, {8.291937364724388, 
                  5.041601390509144}, {8.297114002890078, 
                  5.021418917115678}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.265017058064593, 0.5224597723905882, -0.6747395337854203], 
                 
                 
                 ArrowBox[{{8.307051980058914, 4.982673122378808}, {
                  8.33116121855987, 4.888676971014153}, {8.346506884603333, 
                  4.727298112562213}, {8.33582522050609, 4.56519070565167}, {
                  8.24060458614253, 4.2525280882942695`}, {8.082853827607376, 
                  4.012059372329789}, {7.909952700991742, 
                  3.8412294384188193`}, {7.745526914603711, 
                  3.720373211772012}, {7.644737033539837, 
                  3.66127677136109}}]}}, {
                Arrowheads[{{0.004731129800950913, 1.}}], {
                 LABColor[
                 0.22679656557235725`, 
                  0.5225280184789474, -0.7660844271141383], 
                 
                 ArrowBox[{{7.610231014356369, 3.6410447511923034`}, {
                  7.565895763934251, 3.6150495276934924`}, {
                  7.4067187901408005`, 3.540386231663706}, {7.265827558763208,
                   3.4852973195386765`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.2742076921191741, 0.5224433616961448, -0.6527744194554693], 
                 
                 ArrowBox[{{8.420535801760458, 10.}, {8.417090976397695, 
                  9.997007648504493}, {8.207848435619598, 9.86727443728764}, {
                  8.024314254871594, 9.788334609547517}, {7.865573358841691, 
                  9.732608630941032}, {7.7270200877415, 9.691945307788693}, {
                  7.48978960371131, 9.633011684436195}, {7.295741824964564, 
                  9.593903948723622}, {6.994622618524679, 
                  9.548722746551656}, {6.905254085013702, 
                  9.538659033250195}}]}}, {
                Arrowheads[{{0.009404084433768327, 1.}}], {
                 LABColor[
                 0.20682719736931807`, 
                  0.5225636755617843, -0.813810128417413], 
                 
                 ArrowBox[{{6.86550531452412, 9.534182958567335}, {
                  6.763564511402263, 9.522703492853454}, {6.661169184614708, 
                  9.512670649434607}, {6.568633336773452, 
                  9.504532418556401}, {6.439338646555034, 
                  9.495321905600694}, {6.324137291700395, 9.4879875233872}, {
                  6.11558172117791, 9.475892153523468}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18876544486775368`, 
                  0.5225959264271387, -0.8569767321946997], 
                 
                 ArrowBox[{{1.6480697294111222`, 6.2309112386666285`}, {
                  1.8654694194273467`, 6.21838703510406}, {2.002146387875842, 
                  6.208901007037066}, {2.160335138243815, 
                  6.1961526198928745`}, {2.34792000446067, 
                  6.178174192519719}, {2.577748212669505, 
                  6.151392687605896}, {2.723628875111514, 
                  6.130595130071999}, {2.8937015704407245`, 
                  6.102037394913409}, {3.097071670504634, 
                  6.060718472463414}, {3.232175443204085, 
                  6.026498021811053}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18916679772646613`, 
                  0.5225952097759164, -0.8560175207435728], 
                 
                 ArrowBox[{{3.27095093956755, 6.01667657172632}, {
                  3.3489996926032126`, 5.996907593789066}, {3.485824285857044,
                   5.953549317110649}, {3.6413855669568322`, 
                  5.895549208303939}, {3.820078590437837, 
                  5.814766076977049}, {4.026750590025399, 
                  5.6962811182435855`}, {4.1782994217175515`, 
                  5.5836375357590775`}, {4.3370292532746415`, 
                  5.4291752689855715`}, {4.48590548474349, 
                  5.217240606310689}, {4.523416771963982, 
                  5.117783400152135}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.19042927729541914`, 
                  0.5225929555063715, -0.8530002634023931], 
                 
                 ArrowBox[{{4.537532561453691, 5.080356878979546}, {
                  4.590026794883728, 4.941173977425203}, {4.616016015182557, 
                  4.721740178817673}, {4.594119658913581, 
                  4.501323183180108}, {4.529518226725695, 
                  4.298754326255967}, {4.487947343283327, 
                  4.204000779080884}, {4.439629687424933, 
                  4.1173097749558965`}, {4.374281572283323, 
                  4.03585292638929}, {4.307821462992598, 
                  3.9641776125646007`}, {4.175557522520567, 
                  3.837532688836454}, {4.047426546759558, 
                  3.740073886247672}, {4.007537889573488, 
                  3.7149162493473775`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1896711092758666, 0.5225943092827957, -0.8548122436348651], 
                 
                 ArrowBox[{{3.9737048608679006`, 3.6935778761992926`}, {
                  3.9271499689420684`, 3.664215868309703}, {3.723647850733477,
                   3.559563611331711}, {3.5482363481279906`, 
                  3.488570660052189}, {3.39603863230638, 
                  3.4376598561321976`}, {3.188479343254889, 
                  3.3802889122209185`}, {3.015055596847472, 
                  3.3414770244659215`}, {2.866509649220501, 
                  3.3134480432196156`}, {2.658937993904088, 
                  3.280641333705362}, {2.48686204559834, 3.258421885399558}, {
                  2.44856248695566, 3.254225656077815}}]}}, {
                Arrowheads[{{0.01167279441460808, 1.}}], {
                 LABColor[
                 0.18887744271862197`, 
                  0.5225957264450157, -0.8567090634370905], 
                 
                 ArrowBox[{{2.4088004295746814`, 3.249869190442492}, {
                  2.339924347782446, 3.242322893716732}, {2.1394496891736448`,
                   3.2237912233694064`}, {1.9726585801111005`, 
                  3.211070755956824}, {1.8297749976576916`, 
                  3.2017658319844644`}, {1.6380736236704085`, 
                  3.191160222288636}, {1.4774942444566932`, 
                  3.1837621242070298`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1896702521251401, 0.5225943108133145, -0.8548142921783708], 
                 
                 ArrowBox[{{3.9748614107710343`, -0.3015812253464293}, {
                  4.102130947871324, -0.34401341747771397`}, {
                  4.245217764420865, -0.39957315270984906`}, {
                  4.407428337977411, -0.47484815966087224`}, {
                  4.592087318140354, -0.5807057669643415}, {
                  4.670532711008069, -0.6354296158172104}, {
                  4.751803939418031, -0.6996633093108123}, {
                  4.8348936328548175`, -0.7754062768671591}, {
                  4.8767262478402085`, -0.8164231677771382}, {
                  4.918553966674384, -0.8609430339255366}, {
                  4.955866848373709, -0.9088140504363998}, {
                  4.991941400071051, -0.9603738295211764}, {
                  5.060293713501811, -1.0710646913875237`}, {
                  5.118660353311079, -1.1966762183933497`}, {
                  5.147627998658047, -1.2893604105224603`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1919462725632417, 0.5225902467764119, -0.8493747274167548], 
                 
                 ArrowBox[{{5.159560437669833, -1.327539159837099}, {
                  5.16210764521593, -1.3356891447864252`}, {
                  5.189315525536228, -1.552499548099023}, {
                  5.169606483658838, -1.7708095738762397`}, {
                  5.107885522941495, -1.9723008611714423`}, {
                  4.974866889032976, -2.2059839579011773`}, {
                  4.821388481372846, -2.379061069795826}, {
                  4.669271723846012, -2.5057200059502187`}, {
                  4.527216012378663, -2.5999945931803103`}, {
                  4.461213134329768, -2.6342625303173004`}}]}}, {
                Arrowheads[{{0.001588998958418569, 1.}}], {
                 LABColor[
                 0.19024963093728012`, 
                  0.5225932762809203, -0.8534296084042775], 
                 
                 ArrowBox[{{4.4257126779988685`, -2.652693960004057}, {
                  4.312892301732498, -2.7112690051528974`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1888217196508324, 0.5225958259435088, -0.856842238531164], 
                 
                 
                 ArrowBox[{{2.102655017222984, -0.4325448064589655}, {
                  2.271807159257583, -0.5184584990802165}, {
                  2.3510721001811445`, -0.5663294622491124}, {
                  2.4342060101069536`, -0.6226744408477045}, {
                  2.520713426506464, -0.6894808561956476}, {
                  2.5647185260432224`, -0.7257739314969183}, {
                  2.609294932616545, -0.7653423850732086}, {
                  2.6494646992994957`, -0.8073005092363493}, {
                  2.6892354509508025`, -0.8528195237800339}, {
                  2.766920049862439, -0.9515320849334696}, {
                  2.838763586104576, -1.0661711400419367`}, {
                  2.8999200632511726`, -1.1970862915489464`}, {
                  2.9650416149331655`, -1.4795120680318015`}, {
                  2.9599708139480017`, -1.656975805235517}}]}}, {
                Arrowheads[{{0.017981352227866718`, 1.}}], {
                 LABColor[
                 0.18902996864396357`, 
                  0.5225954540964116, -0.856344534791024], 
                 
                 ArrowBox[{{2.9588283310309715`, -1.6969594860663797`}, {
                  2.958247825976257, -1.7172755262298032`}, {
                  2.9001874783783204`, -1.940384973762012}, {
                  2.805092392980438, -2.1323161035915965`}, {
                  2.66908484020466, -2.313188797339442}, {
                  2.526764841265114, -2.449960607739877}, {
                  2.3893898536386615`, -2.553023542549944}, {
                  2.213854392978769, -2.6582753249387197`}, {
                  2.057620425394887, -2.733375101985035}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18877880885863424`, 
                  0.5225959025645445, -0.8569447929850813], 
                 
                 ArrowBox[{{1.7767052641356875`, 6.692630947987637}, {
                  1.925670941424608, 6.763181404233717}, {2.0929844954053243`,
                   6.85984515788664}, {2.2808727027156737`, 
                  6.997885336625703}, {2.4484244749892903`, 
                  7.1749178887345}, {2.5955363764483272`, 
                  7.417039047054214}, {2.6821036941421084`, 
                  7.721012226829512}, {2.6803998147003925`, 
                  7.886680541094454}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18894191225454843`, 
                  0.522595611328926, -0.8565549847610151], 
                 
                 ArrowBox[{{2.6799884410857757`, 7.926678425685382}, {
                  2.679115685092702, 8.011536550384388}, {2.600428741928379, 
                  8.280304399179654}, {2.4722191594459186`, 
                  8.499530480895796}, {2.3805178910876967`, 
                  8.620868621775594}, {2.284163481033673, 
                  8.720499543229497}, {2.1874182257918404`, 
                  8.791758437155478}, {2.0953995246871617`, 
                  8.85137369076759}, {1.9212554907358574`, 
                  8.952856874772765}, {1.766380973599777, 9.02538573380078}, {
                  1.684405109895487, 9.057545664652205}}]}}, {
                Arrowheads[{{0.006937563591096216, 1.}}], {
                 LABColor[
                 0.18876542365113672`, 
                  0.5225959264650228, -0.8569767829012576], 
                 
                 ArrowBox[{{1.64716811731831, 9.072154100016995}, {
                  1.6288962704959429`, 9.079322323732878}, {1.428417579286555,
                   9.14474330611326}, {1.2591811805885773`, 
                  9.18953802985503}, {1.113343324225548, 
                  9.222106391611089}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886742757180503, 0.5225960892177632, -0.8571946214920765], 
                 
                 ArrowBox[{{-1.025480809796838, 
                  6.355034529443678}, {-0.8532476737747756, 
                  6.36836079669365}, {-0.7399447590703009, 
                  6.378649108948738}, {-0.6122264709374877, 
                  6.391768718852039}, {-0.4658975884053926, 
                  6.409093346328176}, {-0.4101527655377341, 
                  6.41639717011245}, {-0.35116142506226816`, 
                  6.424597138035825}, {-0.2684227732529503, 
                  6.436877517392079}, {-0.17838855484807523`, 
                  6.45152416357198}, {-0.016049488650226255`, 
                  6.481482706424262}, {0.17547519389480573`, 
                  6.522951041225493}, {0.32361911897757906`, 
                  6.562431441252889}, {0.4951719903107909, 
                  6.617047972530273}, {0.5441613460304249, 
                  6.636486030031351}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18870137413176347`, 
                  0.5225960408311356, -0.8571298577606696], 
                 
                 ArrowBox[{{0.5813415372584838, 6.6512384325558545`}, {
                  0.6970899063666257, 6.697165214431829}, {0.7427810183853621,
                   6.717247510661937}, {0.79017585359166, 
                  6.7392257895501775`}, {0.8585023699209645, 
                  6.7758698104353785`}, {0.9301774619384655, 
                  6.818310144869749}, {1.07976724826116, 6.918123238577912}, {
                  1.2390998101341089`, 7.054612347621069}, {
                  1.3968515850643066`, 7.242676114065288}, {
                  1.5263162552286953`, 7.493438597550351}, {1.584874358417752,
                   7.74376081841948}, {1.5840313427591344`, 
                  7.781851851183054}}]}}, {
                Arrowheads[{{0.016284633712634354`, 1.}}], {
                 LABColor[
                 0.18875914577995873`, 
                  0.5225959376747201, -0.8569917866711122], 
                 
                 ArrowBox[{{1.5831462953183932`, 7.821842058622222}, {
                  1.5790519147554847`, 8.00684358566861}, {1.51114470033096, 
                  8.251546846783544}, {1.3895426236807, 8.47396631269532}, {
                  1.2462286666604376`, 8.644885421121847}, {1.10091672384282, 
                  8.772631120605526}, {0.9411727985718265, 
                  8.882271555691876}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867808352981263`, 
                  0.5225960824185767, -0.857185521029561], 
                 
                 ArrowBox[{{-0.578357683952412, 
                  6.1184834768445215`}, {-0.4020979877897794, 
                  6.086898488851237}, {-0.28591625900640677`, 
                  6.06223235112151}, {-0.15526869432088033`, 
                  6.030588694035882}, {-0.006403449659966073, 
                  5.98857127215513}, {0.039175273939476236`, 
                  5.974377372726817}, {0.08669949294901495, 
                  5.958797191334791}, {0.2021634187393212, 
                  5.91712966557631}, {0.33018585243499354`, 
                  5.8638423997153675`}, {0.46582392240596715`, 
                  5.798236881464449}, {0.6161771354164531, 
                  5.711119362801403}, {0.7812187066144778, 
                  5.591520734900959}, {0.8715769173597641, 
                  5.504248170159696}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18871403160119396`, 
                  0.5225960182300984, -0.8570996070987982], 
                 
                 ArrowBox[{{0.9003481775333759, 5.4764594208531445`}, {
                  0.9564748657857315, 5.4222494050304055`}, {
                  1.065132390387421, 5.273441052633383}, {1.1562864573373215`,
                   5.0918948343409305`}, {1.2147162723666174`, 
                  4.88139678693932}, {1.2288276528063218`, 
                  4.728762398468069}, {1.2196357089961587`, 
                  4.57536901170723}, {1.1883136408482942`, 
                  4.427979589653778}, {1.167460182773044, 
                  4.356584602826216}, {1.1420950894343587`, 
                  4.288298987791734}, {1.101365958220242, 
                  4.213558232423771}, {1.0575691448780813`, 4.144854384985}, {
                  0.9726274168911225, 4.02776083377168}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18871609495942607`, 
                  0.5225960145457887, -0.8570946757851149], 
                 
                 ArrowBox[{{0.9465413900014874, 3.9975071470223997`}, {
                  0.8702506023761851, 3.9144712630739713`}, {
                  0.7743483658507857, 3.8283168692230367`}, {
                  0.6181949851419285, 3.713582135776408}, {
                  0.47443087324781796`, 3.6288920294100078`}, {
                  0.34392685990806904`, 3.56472144118227}, {
                  0.1387102688343725, 
                  3.4815312211607696`}, {-0.03536883070376962, 
                  3.4251474460231823`}, {-0.1854378461139715, 
                  3.3845473986286407`}, {-0.3639378930610098, 
                  3.3449962661026627`}, {-0.47155730625859904`, 
                  3.324511365833035}}]}}, {
                Arrowheads[{{0.007931937646226812, 1.}}], {
                 LABColor[
                 0.18867882907443836`, 
                  0.5225960810873405, -0.8571837392185516], 
                 
                 ArrowBox[{{-0.5108517905683921, 
                  3.317031826888192}, {-0.5168561413772872, 
                  3.315888924099099}, {-0.6500617799477417, 
                  3.2939760638429436`}, {-0.767930700716864, 
                  3.276946405297408}, {-0.9707731092158609, 
                  3.252212290283749}, {-1.1399076251835152`, 
                  3.234988630473153}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18888867412201046`, 
                  0.5225957063903461, -0.8566822209953124], 
                 
                 ArrowBox[{{2.463940831589154, 6.487437265217263}, {
                  2.6842541099551562`, 6.53960611306272}, {
                  2.8364051821820513`, 6.583239426392472}, {3.012869032725345,
                   6.644187424215549}, {3.2204455594192587`, 
                  6.734577460866812}, {3.3674200966682566`, 
                  6.812612573505155}, {3.5303154505671954`, 
                  6.9187033341561275`}, {3.7064324618425393`, 
                  7.068324883367284}, {3.8392375217474357`, 
                  7.231410368533342}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18956679844235907`, 
                  0.5225944955390655, -0.8550615408400676], 
                 
                 ArrowBox[{{3.864495362163204, 7.262427162331727}, {
                  3.8820974776611696`, 7.284042675686343}, {3.961848652375075,
                   7.432791496619642}, {4.020892536624987, 
                  7.603520064600906}, {4.050249391212442, 
                  7.789870680168294}, {4.056494391785809, 
                  7.885802512481328}, {4.0535012639438435`, 
                  7.982518941908493}, {4.032099991650089, 
                  8.076673726995562}, {4.003259181393468, 
                  8.165927470334717}, {3.9340844066052227`, 
                  8.332921729032703}, {3.8469973090260656`, 
                  8.475936772161607}, {3.7510084795632053`, 
                  8.595038911688219}, {3.639837391135465, 
                  8.695186060906812}}]}}, {
                Arrowheads[{{0.01102043692387029, 1.}}], {
                 LABColor[
                 0.1893665600609185, 0.522594853082503, -0.8555400996549943], 
                 
                 
                 ArrowBox[{{3.610118013189683, 8.721958408105289}, {
                  3.558792241372132, 8.768194617552071}, {3.381654532341919, 
                  8.887215473019854}, {3.2228988911595864`, 
                  8.972211206041106}, {3.08126130771308, 9.035348577556528}, {
                  2.832179003421184, 9.122821370777197}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886788904210662, 0.5225960809778006, -0.8571835926034557], 
                 
                 ArrowBox[{{-0.5047195245796007, 
                  0.2186439838141808}, {-0.3972796205621011, 
                  0.24401681950673992`}, {-0.277764323853818, 
                  0.27591109544517006`}, {-0.14345527876834538`, 
                  0.31714236491060815`}, {-0.1004557687384717, 
                  0.33166839647050633`}, {-0.05575999606091177, 
                  0.34753435627738916`}, {0.041723516423782345`, 
                  0.3848533292142578}, {0.1478117427514597, 
                  0.4306185097021457}, {0.3172887210306766, 
                  0.5167377866086826}, {0.4339764198794409, 
                  0.588465579596702}, {0.5587256456422593, 
                  0.6797599348416177}, {0.6890224375243259, 
                  0.7977984745263906}, {0.8186966693634555, 
                  0.9516630531451163}, {0.8466379093052931, 
                  0.9978508285506469}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18871239624952843`, 
                  0.5225960211501642, -0.8571035155001218], 
                 
                 ArrowBox[{{0.8673421421042045, 1.0320755965441408`}, {
                  0.9052290288366486, 1.0947038485063127`}, {
                  0.9737069412663368, 1.261584945386693}, {1.014185581281945, 
                  1.4474901352976337`}, {1.0227311730473003`, 
                  1.516259297652994}, {1.0265653360027205`, 
                  1.5860516896548273`}, {1.02158910744436, 
                  1.6491918030017914`}, {1.0127798789083797`, 
                  1.7113482449076287`}, {0.9881167882346401, 
                  1.8326671738200107`}, {0.9506097660827943, 
                  1.9467076634308205`}, {0.9029516419463642, 
                  2.051466251699259}, {0.7801293007004685, 
                  2.239976923682087}, {0.6465603790825603, 
                  2.384940342082273}, {0.5624575785086581, 
                  2.4555280952416263`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18869960551140538`, 
                  0.5225960439891647, -0.8571340846669027], 
                 
                 ArrowBox[{{0.531818872796941, 2.481243260267556}, {
                  0.5145686067409135, 2.495721464488901}, {
                  0.38969487508253653`, 2.5813514327704485`}, {
                  0.22305677613700628`, 2.674556963485036}, {
                  0.07493458963171895, 
                  2.742650662970257}, {-0.05711126716512736, 
                  2.794159600652005}, {-0.1755809821769298, 
                  2.8342810983031255`}, {-0.40011496473160957`, 
                  2.8967474109671385`}, {-0.5855875970241411, 
                  2.938683391378922}, {-0.743140918465191, 
                  2.9685431673718754`}, {-0.8798396381657992, 
                  2.9907948052297257`}, {-0.9622983648837972, 
                  3.0020322387830305`}}]}}, {
                Arrowheads[{{0.0030737091835297777`, 1.}}], {
                 LABColor[
                 0.18867447108734045`, 
                  0.5225960888689141, -0.8571941545701243], 
                 
                 ArrowBox[{{-1.0019320179234066`, 
                  3.00743349296478}, {-1.0792269825710417`, 
                  3.017967211635981}, {-1.2460328370078317`, 
                  3.0369923218050396`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.005321156315287429, 1.}}], {
                 LABColor[
                 0.1909255731246364, 0.5225920693260321, -0.8518141434279175], 
                 
                 ArrowBox[{{4.786462668822095, -10.}, {
                  4.649441940417867, -9.918373453704906}, {
                  4.583526052290288, -9.882941610087133}, {
                  4.520682216145126, -9.851972954408202}, {
                  4.408198564783391, -9.806558455945593}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.009425553254525232, 1.}}], {
                 LABColor[
                 0.1890463024605159, 0.5225954249309296, -0.8563054978599607], 
                 
                 ArrowBox[{{3.0013569787902346`, 7.359768743601366}, {
                  3.0648148713858396`, 7.501574248804618}, {
                  3.1087508470070744`, 7.659341011265879}, {3.127322602517335,
                   7.827210477421645}, {3.129666019600246, 
                  7.912719260419645}, {3.1246832873986796`, 
                  7.998329794889816}, {3.1024270409254506`, 
                  8.090405383506042}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867961481252854`, 
                  0.5225960796843353, -0.8571818613473534], 
                 
                 ArrowBox[{{-0.44299267021696487`, 
                  5.735678108846091}, {-0.38671328748357664`, 
                  5.699680032772247}, {-0.3286294346317916, 
                  5.659286104760159}, {-0.32178780667546125`, 
                  5.654338335711991}, {-0.18173910878240077`, 
                  5.540455638510651}, {-0.030831667294411936`, 
                  5.379602370138866}, {0.05508334806499431, 
                  5.254460935783599}, {0.12882675387373937`, 
                  5.107720348833847}, {0.18211276534391702`, 
                  4.94123812116913}, {0.19058032251293186`, 
                  4.9048926962140795`}, {0.19778250311060755`, 
                  4.867951986457721}, {0.20295312961131406`, 
                  4.820076926592677}, {0.20581864536133224`, 
                  4.771871090401945}, {0.20689437043293807`, 
                  4.675358145290468}, {0.19875323154810232`, 
                  4.579525972405095}, {0.1818239369222198, 
                  4.486059923271609}, {0.15287359549748394`, 
                  4.387186125662321}}]}}, {
                Arrowheads[{{0.008632641956573603, 1.}}], {
                 LABColor[
                 0.18868917881628688`, 0.522596062606956, -0.857159003899787], 
                 
                 ArrowBox[{{0.13960972920632683`, 4.349518261377938}, {
                  0.10054557321762751`, 4.256901854266721}, {
                  0.04576761229793961, 
                  4.15751312678104}, {-0.11276851837044156`, 
                  3.9538825028914255`}, {-0.2749859176994022, 
                  3.8074390191349994`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18875183839120108`, 
                  0.5225959507227126, -0.8570092509318544], 
                 
                 ArrowBox[{{1.4991592253227086`, -6.705883106391675}, {
                  1.6453655950842447`, -6.777694113203113}, {
                  1.808562378381614, -6.875219855849307}, {
                  1.988066773401223, -7.013031487405821}, {
                  2.1746495488801463`, -7.213958167455419}, {
                  2.2557060707943455`, -7.339147322903145}, {
                  2.323999986111593, -7.484431642499735}, {
                  2.371992072450296, -7.647473082799619}, {
                  2.3899429863074335`, -7.732903726307433}, {
                  2.4007412801932397`, -7.821136889245891}, {
                  2.400969958822924, -7.829321031624118}, {
                  2.401164006091383, -7.839145767151053}, {
                  2.4011135530403767`, -7.87189911461518}, {
                  2.3999921095082963`, -7.904614105386189}, {
                  2.399512782453468, -7.911766303274853}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18887411841859436`, 
                  0.5225957323808491, -0.8567170083329204], 
                 
                 ArrowBox[{{2.3951173843600433`, -7.951457388266633}, {
                  2.357825075799412, -8.148858496752654}, {
                  2.281399951326234, -8.337479350693185}, {
                  2.182461059983696, -8.495963982626597}, {
                  2.0074129136956627`, -8.686115976394401}, {
                  1.8380334224762631`, -8.819379286343837}, {
                  1.6825475307359734`, -8.915398699008355}, {
                  1.5421390280661564`, -8.987014571779241}, {
                  1.388546108896171, -9.053254098343533}, {
                  1.3630228420382446`, -9.062521884674835}}]}}, {
                Arrowheads[{{0.014345776606676935`, 1.}}], {
                 LABColor[
                 0.18873856678712603`, 
                  0.5225959744203419, -0.8570409693420445], 
                 
                 ArrowBox[{{1.3254247687134455`, -9.076174169548182}, {
                  1.2525574629886982`, -9.102633110864502}, {
                  1.1312240240606444`, -9.140704564781322}, {
                  0.8957546072221807, -9.19976808417318}, {
                  0.702744852698579, -9.239621791577267}, {
                  0.539953801896506, -9.267718017824901}, {
                  0.39945046751000624`, -9.288396137290302}, {
                  0.2050133309846313, -9.312402713799386}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866799291726533`, 
                  0.5225961004362628, -0.857209637043423], 
                 
                 ArrowBox[{{-3.6881607884746592`, -6.3412765946596075`}, \
{-3.5485132958258263`, -6.349974744740698}, {-3.3862967756668985`, \
-6.361752045867326}, {-3.1929853361599827`, -6.378512877066345}, \
{-2.9544446825426376`, -6.403784945555003}, {-2.8248500936412118`, \
-6.420533414015361}, {-2.676364289360331, -6.442711496893594}, \
{-2.5028423335513788`, -6.473202977349801}, {-2.2955814289875915`, \
-6.516144277255095}, {-2.1366502048741283`, -6.557496906143091}, \
{-2.1074157935327062`, -6.566719570400253}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866990919988966`, 
                  0.5225960970145698, -0.857205057232424], 
                 
                 ArrowBox[{{-2.069269020664089, -6.578753843112391}, \
{-1.9503439592746077`, -6.616271476019321}, {-1.7276880416940432`, \
-6.705865314884278}, {-1.6057875071851593`, -6.764886760960401}, \
{-1.4720751779132044`, -6.841034946773199}, {-1.3264410894851275`, \
-6.941789376362638}, {-1.171244752118185, -7.078020615081377}, \
{-1.0911416353326917`, -7.167661878514061}, {-1.0143910376186152`, \
-7.272543391658315}, {-0.9451399743870407, -7.393881259526627}, \
{-0.9147657252923154, -7.460783881830033}, {-0.8883257005802774, \
-7.53159718254189}, {-0.8831090382930028, -7.554438990088619}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.188675376193974, 0.5225960872527656, -0.8571919914146151], 
                 
                 
                 ArrowBox[{{-0.8742030590972765, -7.5934349326283925`}, \
{-0.8446922617928957, -7.722651645433736}, {-0.8385435703391754, \
-7.923385627374014}, {-0.8394909856844225, -7.937014923273516}, \
{-0.8406229925626699, -7.9506171493601325`}, {-0.8415050471073755, \
-7.959285015792231}, {-0.845075667498075, -7.988875646294517}, \
{-0.8487032564263055, -8.013356188732558}, {-0.8529100802658779, \
-8.037645725048204}, {-0.9210689151347802, -8.26395455842126}, \
{-1.0252001422114436`, -8.454816071150661}, {-1.1463817687220257`, \
-8.607286369050579}, {-1.3220684741336648`, -8.764480663975323}, \
{-1.4849968318200215`, -8.875970762277484}, {-1.5459956300765916`, \
-8.90969378322218}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867140455724182`, 
                  0.5225960943444763, -0.857201483409877], 
                 
                 ArrowBox[{{-1.5810020940860652`, -8.929047012346887}, \
{-1.6327031028996282`, -8.95762977549819}, {-1.7657980489693348`, \
-9.019437729096625}, {-1.8779652527406572`, -9.064757477850721}, \
{-1.9803081453732132`, -9.101264641385884}, {-2.074131074419192, \
-9.131232282855938}, {-2.320827860511379, -9.195097983195529}, \
{-2.52123986145388, -9.23716100452646}, {-2.689297640640194, \
-9.266476660816094}, {-2.833723043273231, -9.287860247564922}, \
{-3.050719466345888, -9.314364374803988}, {-3.1215938575918885`, \
-9.321537738837398}}]}}, {
                Arrowheads[{{0.0027646007442457218`, 1.}}], {
                 LABColor[
                 0.18866832299367994`, 
                  0.522596099846882, -0.8572088481787874], 
                 
                 ArrowBox[{{-3.161390539533489, -9.32556565473015}, \
{-3.2296485580650165`, -9.33247420952008}, {-3.3816523530400557`, \
-9.345505001240014}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18885363169750433`, 
                  0.5225957689617116, -0.8567659704794182], 
                 
                 ArrowBox[{{2.289587986560742, 5.702068102615688}, {
                  2.4676899496830953`, 5.565130123179906}, {
                  2.5744921388632953`, 5.4609232241927455`}, {
                  2.678738464097935, 5.332143213091261}, {2.7722436763070015`,
                   5.17534536340784}, {2.815046537117881, 
                  5.0896524539591566`}, {2.8519292769644426`, 
                  4.9967279251732855`}, {2.8660812998905363`, 
                  4.933803298298905}, {2.8762575514475395`, 
                  4.869449108190699}, {2.8881983199643373`, 
                  4.739197217526988}, {2.8831332909221126`, 
                  4.608071940398244}, {2.8615494815115667`, 
                  4.48037815349022}, {2.8056481130903244`, 
                  4.329464651945378}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18897479627137811`, 
                  0.5225955526115895, -0.8564763937535826], 
                 
                 ArrowBox[{{2.791753904217469, 4.2919553069791245`}, {
                  2.765121060391572, 4.220056249203364}, {2.6277802798477095`,
                   4.01340126656118}, {2.477694025092041, 
                  3.8584352004967726`}, {2.3031139002750693`, 
                  3.7281136171489613`}, {2.1455998576771127`, 
                  3.6345222973261833`}, {2.004051903927572, 
                  3.565077337667046}, {1.8767741920603667`, 
                  3.5119082028493485`}, {1.6509924621883363`, 
                  3.4354884532427845`}, {1.530962535828269, 
                  3.4027335177057574`}}]}}, {
                Arrowheads[{{0.00037021916568685137`, 1.}}], {
                 LABColor[
                 0.18875147552280372`, 
                  0.5225959513706464, -0.857010118167541], 
                 
                 ArrowBox[{{1.4923735749054732`, 3.3922029861475247`}, {
                  1.4638008290703532`, 3.384405776932069}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.2130369391086085, 0.5225525875156658, -0.7989691842069323], 
                 
                 ArrowBox[{{7.16592979820178, -6.382325245044028}, {
                  7.333715639747838, -6.400611157135324}, {
                  7.535169345550435, -6.427145404214701}, {
                  7.787344123071232, -6.469679315834545}, {
                  7.950721696869236, -6.503486632552381}, {
                  8.144415769053781, -6.551994482134099}, {
                  8.380706332555166, -6.627633154528166}, {
                  8.551935933723142, -6.696117828492361}, {
                  8.706682565373002, -6.77403722926774}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.3070731972441853, 0.5223846774139581, -0.5742276539880063], 
                 
                 ArrowBox[{{8.742409080764292, -6.792026562162431}, {
                  8.750550659930711, -6.796126082541319}, {
                  8.977872636508396, -6.951484970146494}, {
                  9.172596942398206, -7.142973378322863}, {
                  9.343990388720552, -7.418301843740565}, {
                  9.435031881581573, -7.772421631538649}, {
                  9.400831198685777, -8.12324816596964}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.4171004440635669, 0.52323020252482, -0.279127015357238], 
                 
                 ArrowBox[{{9.391654102764784, -8.161613688029806}, {
                  9.251876798372123, -8.461777982224666}, {
                  9.059438639802334, -8.68583550956922}, {
                  8.96001991567913, -8.77608890763839}, {
                  8.863096146407262, -8.84934272964768}, {
                  8.775745056166924, -8.900043353930425}, {
                  8.69334164330231, -8.943203924760248}, {
                  8.537805867157797, -9.017857728228384}, {
                  8.399566252146947, -9.073209684865235}, {
                  8.276077106987263, -9.115699152310626}, {
                  8.207053853804348, -9.135164713894545}}]}}, {
                Arrowheads[{{0.015052816944379502`, 1.}}], {
                 LABColor[
                 0.25566569583195364`, 
                  0.5224764700794874, -0.6970887796982556], 
                 
                 ArrowBox[{{8.16855549730884, -9.146021810520477}, {
                  8.005021200007436, -9.192140861541844}, {
                  7.789777050941593, -9.238050573730632}, {
                  7.611880698653888, -9.268890727302347}, {
                  7.355585350453254, -9.304848675702406}, {
                  7.151857223254787, -9.327132027274954}, {
                  6.982619962445771, -9.342439574523631}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866782973899457`, 
                  0.5225961007276322, -0.8572100270305939], 
                 
                 ArrowBox[{{-4.113153719239122, -7.864297888687308}, \
{-4.12379039642945, -7.961749055863865}, {-4.14314619171113, \
-8.055907802587077}, {-4.196351169610224, -8.23471764584698}, \
{-4.273415967668055, -8.391889765654634}, {-4.3645319959334765`, \
-8.524807598713885}, {-4.560339285260759, -8.723068494695678}, \
{-4.744904688136605, -8.857094043822965}, {-4.910924244719808, \
-8.951260960255212}, {-5.058808572639641, -9.02034404575794}, \
{-5.079571827574213, -9.028332767727033}}]}}, {
                Arrowheads[{{0.01980398239298581, 1.}}], {
                 LABColor[
                 0.18866763507151343`, 
                  0.5225961010752282, -0.8572104922752609], 
                 
                 ArrowBox[{{-5.116903931837162, -9.04269640206171}, \
{-5.274226419321729, -9.103226680958763}, {-5.4551037327628356`, \
-9.158347976477591}, {-5.609954467533289, -9.197514262118068}, \
{-5.858208238909693, -9.248849441027557}, {-6.057683426638224, \
-9.28108553639018}, {-6.224294728310315, -9.303361168510282}, \
{-6.469135280226115, -9.330187203630736}, {-6.665369981883752, \
-9.347164040108577}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866753433048464`, 
                  0.5225961012551104, -0.8572107330408274], 
                 
                 ArrowBox[{{-7.307019795622596, -7.8789639940802445`}, \
{-7.3190734361351115`, -7.97627535995455}, {-7.339735820031167, \
-8.070053511952185}, {-7.395233385803203, -8.247758610166667}, \
{-7.473899070714636, -8.403355655850023}, {-7.565938964288541, \
-8.53460223954011}, {-7.76753383548005, -8.741189703880968}, \
{-7.960874709199984, -8.87956144079663}, {-8.13432557057287, \
-8.97456605141358}, {-8.282383924782149, -9.037611932297779}}]}}, {
                Arrowheads[{{0.0057132341329299, 1.}}], {
                 LABColor[
                 0.18866752631772704`, 
                  0.5225961012694178, -0.8572107521908812], 
                 
                 ArrowBox[{{-8.319186318571395, -9.053283046214192}, \
{-8.380675548056784, -9.079466253899435}, {-8.583724402245931, \
-9.14531350510856}, {-8.754651689988629, -9.19037804256889}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866752255346803`, 
                  0.5225961012761392, -0.857210761187255], 
                 
                 ArrowBox[{{-10., -6.599533933898094}, {-9.97170050830423, \
-6.608297811373105}, {-9.774813603026276, -6.683447559486439}, \
{-9.540887893684811, -6.800685477576196}, {-9.396855064993812, \
-6.892265193887334}, {-9.242286497939393, -7.016233402582901}, \
{-9.085505736428056, -7.185842141507151}, {-9.01097973725899, \
-7.291758106754167}, {-8.94441689996229, -7.413846482420119}, \
{-8.910529235605019, -7.507941967225874}, {-8.885566521639461, \
-7.607388255425566}, {-8.881728272101034, -7.63418970056477}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866752432893738`, 
                  0.522596101272969, -0.8572107569439801], 
                 
                 ArrowBox[{{-8.876057704778125, -7.673785718877681}, \
{-8.856236122726191, -7.812194396744638}, {-8.869086849173891, \
-8.0201755004641}, {-8.92117355515699, -8.215243278300592}, \
{-9.071003817457976, -8.496755689692286}, {-9.252822143724707, \
-8.699262134336367}, {-9.432505372397584, -8.839466079123294}, \
{-9.632437905991086, -8.955042590817328}}]}}, {
                Arrowheads[{{0.002734526093735047, 1.}}], {
                 LABColor[
                 0.18866752289207656`, 
                  0.5225961012755346, -0.8572107603779991], 
                 
                 ArrowBox[{{-9.667068011028022, -8.975061477527904}, \
{-9.667566293318623, -8.975349523339917}, {-9.867799357083568, \
-9.062021815015177}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866752502235165`, 
                  0.5225961012717308, -0.8572107552867577], 
                 
                 ArrowBox[{{-8.642053952057223, -6.7692278029295565`}, \
{-8.498811511151368, -6.85330226330653}, {-8.343105956541185, \
-6.967159143056046}, {-8.18090452483215, -7.124098129508228}, \
{-8.101111109475978, -7.22312935858981}, {-8.02675022224548, \
-7.338954543352399}, {-7.985966716242227, -7.429138628508685}, \
{-7.953057098170147, -7.5259904233901365`}, {-7.906863218031844, \
-7.729007711339528}, {-7.903061755890628, -7.942090058229685}, \
{-7.927080734211323, -8.067723129135778}}]}}, {
                Arrowheads[{{0.004549299717459854, 1.}}], {
                 LABColor[
                 0.18866752843662193`, 
                  0.5225961012656344, -0.857210747126838], 
                 
                 ArrowBox[{{-7.934592035386367, -8.107011554335292}, \
{-7.942389975028158, -8.147799263573301}, {-8.076264261001585, \
-8.441109244646825}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866755462493032`, 
                  0.5225961012188728, -0.8572106845382086], 
                 
                 ArrowBox[{{-6.349061719590207, 
                  1.5714507773741493`}, {-6.362069576095278, 
                  1.6841857230510795`}, {-6.386505763726905, 
                  1.7921514826987064`}, {-6.445749962596898, 
                  1.9763566753681447`}, {-6.52936351936863, 
                  2.136299673741921}, {-6.626463455455114, 
                  2.2698672220480294`}, {-6.818971005924479, 
                  2.4622485354089405`}, {-7.003013437855632, 
                  2.593560524680786}, {-7.168980334348404, 
                  2.685375418608155}, {-7.305893334801869, 
                  2.7436454830658064`}}]}}, {
                Arrowheads[{{0.013493617413142426`, 1.}}], {
                 LABColor[
                 0.18866753391019903`, 
                  0.5225961012558608, -0.8572107340452871], 
                 
                 ArrowBox[{{-7.342698627828211, 
                  2.759309786601077}, {-7.364382216377832, 
                  2.768538304698517}, {-7.531472090738175, 
                  2.8279090766289756`}, {-7.676841716704061, 
                  2.8714745924966567`}, {-7.805081768911558, 
                  2.904594337461826}, {-8.038442696470968, 
                  2.953865984191443}, {-8.229071896881374, 
                  2.9866427982156156`}, {-8.389877508038898, 
                  3.0097819877568703`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866753468748315`, 
                  0.5225961012544729, -0.8572107321876203], 
                 
                 ArrowBox[{{-7.278210699137084, 
                  6.40076867239209}, {-7.080981964968601, 
                  6.426730370951816}, {-6.835446870253938, 
                  6.4678328634000195`}, {-6.671611649173429, 
                  6.501396639975002}, {-6.477233145643608, 
                  6.549615360656688}, {-6.239836832500816, 
                  6.6249731506463485`}, {-6.075222835121084, 
                  6.689961067882036}, {-5.885294886187954, 
                  6.783251154471584}, {-5.762197832570429, 
                  6.8635279830829035`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.1886675832611903, 0.5225961011677402, -0.8572106160991085], 
                 
                 ArrowBox[{{-5.728692928164021, 
                  6.885377957470015}, {-5.668088114592223, 
                  6.924900936202234}, {-5.537262233612254, 
                  7.035242444795439}, {-5.405593239988649, 
                  7.179002199548197}, {-5.2853425725955345`, 
                  7.3638731278943945`}, {-5.234753380218338, 
                  7.472908403211306}, {-5.193743433615544, 
                  7.597590561972213}, {-5.1784336033152645`, 
                  7.6912160746694465`}, {-5.172070462274345, 
                  7.78645855177223}, {-5.177246472051356, 
                  7.975892566827335}, {-5.21601331866508, 
                  8.157207260672177}, {-5.2623464666896265`, 
                  8.27257383508925}}]}}, {
                Arrowheads[{{0.012590263994323758`, 1.}}], {
                 LABColor[
                 0.18866761786499633`, 
                  0.522596101105952, -0.8572105333978987], 
                 
                 ArrowBox[{{-5.277253812834344, 
                  8.309692173291836}, {-5.281679292087487, 
                  8.320711333512042}, {-5.4373347704598265`, 
                  8.56043938121272}, {-5.609464119024174, 
                  8.733161184929509}, {-5.775413751414602, 
                  8.85561500601922}, {-6.001614395000153, 
                  8.98265211942525}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866752381606225`, 
                  0.5225961012738848, -0.8572107581697237], 
                 
                 ArrowBox[{{-9.093307124769494, 
                  6.710871004626464}, {-8.894870666404858, 
                  6.815099906499248}, {-8.669729502868623, 
                  6.976144633949072}, {-8.528300652879276, 
                  7.112342811950223}, {-8.393212431385736, 
                  7.292175165427489}, {-8.285298733158564, 
                  7.521001802918749}, {-8.249387601698988, 
                  7.652503448395794}, {-8.23097582859933, 
                  7.791601552577145}, {-8.234547975552676, 
                  7.889500391493656}, {-8.241167066677418, 
                  7.93925342182296}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866752663365663`, 
                  0.5225961012688537, -0.8572107514358267], 
                 
                 ArrowBox[{{-8.246442146822334, 
                  7.978904065316662}, {-8.247300027822668, 
                  7.985352409753109}, {-8.288801751376814, 
                  8.169397978524161}, {-8.357540144549018, 
                  8.334418819148434}, {-8.443804135781308, 
                  8.475861359942389}, {-8.642855511820862, 
                  8.701554185876832}, {-8.839456517192032, 
                  8.852787025943641}, {-9.017408486486683, 
                  8.955738569434727}, {-9.261017495247037, 
                  9.064420943898847}, {-9.298023168876215, 
                  9.076989840089906}}]}}, {
                Arrowheads[{{0.0038833339514414327`, 1.}}], {
                 LABColor[
                 0.18866752336630627`, 
                  0.5225961012746879, -0.857210759244616], 
                 
                 ArrowBox[{{-9.335898142090747, 
                  9.089853991985718}, {-9.462804764293317, 
                  9.132957548926896}, {-9.633080417937498, 
                  9.17994509797804}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886675416257332, 0.522596101242084, -0.857210715605581], 
                 
                 ArrowBox[{{-6.851215370871958, 
                  7.890961041112461}, {-6.864420744187725, 
                  7.988124367099173}, {-6.886137014934189, 
                  8.081562533569443}, {-6.943471756514126, 
                  8.258319577597067}, {-7.023401136316796, 
                  8.412609102338019}, {-7.116156806091101, 
                  8.542489274199397}, {-7.315365650793945, 
                  8.74424413474004}, {-7.5059960073948115`, 
                  8.88008294847589}, {-7.67719328019434, 
                  8.973856183841097}, {-7.8372648037123085`, 
                  9.042126561566223}}]}}, {
                Arrowheads[{{0.005565940844134559, 1.}}], {
                 LABColor[
                 0.18866752890313998`, 
                  0.5225961012648013, -0.8572107460118852], 
                 
                 ArrowBox[{{-7.874058154074508, 
                  9.05781889629132}, {-7.924059603049621, 
                  9.079144474591018}, {-8.12748107452981, 
                  9.145167295214666}, {-8.298675062233201, 
                  9.190320425769675}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866768033597472`, 
                  0.5225961009944046, -0.8572103840956661], 
                 
                 ArrowBox[{{-4.7767580426734835`, 
                  1.5714664257021989`}, {-4.789767747954042, 
                  1.6842016325405538`}, {-4.814205696189661, 
                  1.7921672664463926`}, {-4.8753611037449165`, 
                  1.9809406516174453`}, {-4.961882530594696, 
                  2.144075962760388}, {-5.062098977935656, 
                  2.2794916764905326`}, {-5.244083317977569, 
                  2.459688797751357}, {-5.41834262465004, 
                  2.585294496085936}, {-5.576620875239846, 
                  2.6747838013455167`}, {-5.733703582951798, 
                  2.7436705836747546`}}]}}, {
                Arrowheads[{{0.004049885213786963, 1.}}], {
                 LABColor[
                 0.18866758042652848`, 
                  0.5225961011728018, -0.8572106228737957], 
                 
                 ArrowBox[{{-5.770381168972607, 
                  2.759622526037372}, {-5.9333676275590115`, 
                  2.8192112820822137`}, {-6.07712756905235, 
                  2.8635864673221154`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886790296509123, 0.5225960807291934, -0.8571832598517141], 
                 
                 ArrowBox[{{-0.4926366382603085, 
                  6.847124965241685}, {-0.41176703733979975`, 
                  6.901531148754465}, {-0.3276202918632374, 
                  6.965736280711636}, {-0.24115639586029106`, 
                  7.0419263304228465`}, {-0.1902710371065946, 
                  7.0927577703860765`}, {-0.1396801360326529, 
                  7.149022793969604}, {-0.07550452604602073, 
                  7.231295539796952}, {-0.015170963564593234`, 
                  7.324477730480604}, {0.03909037836586785, 
                  7.429930200966319}, {0.08346410943085916, 
                  7.546266392145597}, {0.12153015935842486`, 
                  7.715343724675236}, {0.13035107826780337`, 
                  7.892464197478491}, {0.10839824784594802`, 
                  8.06734055788786}, {0.101099776569474, 8.101032478225138}, {
                  0.09273168067538272, 8.134216397648993}, {
                  0.07433811252867421, 8.18731848622119}, {0.0654844303316542,
                   8.209202092391955}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18868732160474513`, 
                  0.5225960659231723, -0.8571634425341194], 
                 ArrowBox[{{0.050108059448471395`, 8.246120322485611}, {
                  0.008648691634236087, 
                  8.336015758942322}, {-0.0427572575569975, 
                  8.424725116758339}, {-0.09840098461797507, 
                  8.504433593409399}, {-0.23558740081734622`, 
                  8.657340128465723}, {-0.3714713434471427, 
                  8.773339742944938}, {-0.5001038149559363, 
                  8.862228119185778}, {-0.619500161854542, 
                  8.931606883887978}, {-0.6986419320624782, 
                  8.972176454729789}, {-0.7732960881023924, 
                  9.006944289955365}, {-0.8437386466315793, 
                  9.037002296140614}, {-1.078354360002549, 
                  9.119575123253846}, {-1.1997358142299892`, 
                  9.1538691676424}}]}}, {
                Arrowheads[{{0.0004384068125938968, 1.}}], {
                 LABColor[
                 0.18867299626783676`, 
                  0.5225960915023354, -0.857197679308333], 
                 
                 ArrowBox[{{-1.238228971233243, 
                  9.164744684362208}, {-1.271980295770189, 
                  9.174280485603095}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886677160387363, 0.522596100930654, -0.8572102987680124], 
                 
                 
                 ArrowBox[{{-4.5733521958739605`, 
                  6.57857956911435}, {-4.3254794548875894`, 
                  6.663533860910571}, {-4.188910407207463, 
                  6.722634162714533}, {-4.036165725003452, 
                  6.801370859809996}, {-3.865660674786464, 
                  6.910165444151362}, {-3.6786520723124747`, 
                  7.066068468963874}, {-3.5727802844941072`, 
                  7.1856579179367746`}, {-3.4743615625621693`, 
                  7.332380306339423}, {-3.3939179792228074`, 
                  7.507664832028786}, {-3.381529079503497, 
                  7.548147313881666}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866816942123865`, 
                  0.5225961001210992, -0.8572092152085494], 
                 
                 ArrowBox[{{-3.3698237021987074`, 
                  7.586396289582363}, {-3.3640436213518976`, 
                  7.605283521159872}, {-3.34355885088803, 
                  7.707941169265645}, {-3.3390242202271314`, 
                  7.7430364157126785`}, {-3.3376820490119594`, 
                  7.839138776695044}, {-3.3454029026520997`, 
                  7.934173632856805}, {-3.3772317917723527`, 
                  8.118345521933687}, {-3.4377318933791514`, 
                  8.286424152289577}, {-3.517979566887602, 
                  8.432570898285467}, {-3.6984446803183006`, 
                  8.649767551827374}, {-3.8779737802663017`, 
                  8.799124831968067}, {-4.0431243492588775`, 
                  8.904435224205685}, {-4.047261413164895, 
                  8.906586015701674}}]}}, {
                Arrowheads[{{0.0015338318759147995`, 1.}}], {
                 LABColor[
                 0.18866783975435986`, 
                  0.5225961007097488, -0.8572100030944169], 
                 
                 ArrowBox[{{-4.082751776632964, 
                  8.92503687207487}, {-4.191624278183218, 
                  8.981637895361139}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.017724880592519043`, 1.}}], {
                 LABColor[
                 0.18866772112916574`, 
                  0.5225961009215646, -0.8572102866021636], 
                 
                 ArrowBox[{{-4.547915233613221, 
                  4.669463742185732}, {-4.564300164626426, 
                  4.562148775599747}, {-4.590810521225332, 
                  4.459842980182637}, {-4.659674215639288, 
                  4.268378624080373}, {-4.753270188361054, 
                  4.105335980791582}, {-4.859086237665415, 
                  3.971726413240428}, {-5.043074198477847, 
                  3.799589804237181}, {-5.216915722391901, 
                  3.6798543421872054`}, {-5.373967666971447, 
                  3.594395773784362}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866752255480637`, 
                  0.5225961012761369, -0.8572107611840565], 
                 
                 ArrowBox[{{-10., -6.080194550080661}, {-9.96109796372785, \
-6.072777516409855}, {-9.802038608083123, -6.035568054408847}, \
{-9.614914052308443, -5.982749522509756}, {-9.38955404197508, \
-5.9019831760412425`}, {-9.217930192280408, -5.824932019982357}, \
{-9.02121534270288, -5.712566777288789}, {-8.802192397726076, \
-5.540539677416419}, {-8.667653143592478, -5.396204939985305}, \
{-8.627600662263372, -5.335507999624553}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866752515165175`, 
                  0.5225961012714999, -0.8572107549777376], 
                 
                 ArrowBox[{{-8.605569847364421, -5.302121727072977}, \
{-8.544361493904924, -5.209364433236825}, {-8.453240495382264, \
-4.978370911846993}, {-8.426867494520371, -4.848878101649206}, \
{-8.417542307496197, -4.714461888515133}, {-8.435212446011773, \
-4.582108478473674}, {-8.468035579760398, -4.457232970656191}, \
{-8.555907542498096, -4.227558102291811}, {-8.676234934898199, \
-4.040473345812703}, {-8.808606087088382, -3.8951840798045034`}, \
{-8.844563652959858, -3.8663067022381807`}}]}}, {
                Arrowheads[{{0.010160479526439838`, 1.}}], {
                 LABColor[
                 0.18866752434462908`, 
                  0.5225961012729409, -0.8572107569064777], 
                 
                 ArrowBox[{{-8.8757512488676, -3.84126006850238}, \
{-9.022802909625513, -3.723163466951559}, {-9.216442364130009, \
-3.609825609334465}, {-9.386133574231675, -3.5316923543334027`}, \
{-9.585844485636928, -3.4574884759875038`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.00848287414227095, 1.}}], {
                 LABColor[
                 0.1886675225517974, 0.5225961012761422, -0.8572107611912477], 
                 
                 ArrowBox[{{-10., -5.088257448671448}, {-9.999061361384584, \
-5.086195799334825}, {-9.96602077764912, -4.946744512795955}, \
{-9.953388224559115, -4.802290116076758}, {-9.964407405269956, \
-4.539424142455037}, {-10., -4.4196506428903435`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675291346237, 0.5225961012643879, -0.8572107454586517], 
                 
                 ArrowBox[{{-7.8377642544426305`, -5.838193467664706}, \
{-7.6468058717834735`, -5.733561457731962}, {-7.432644705577716, \
-5.575159351101486}, {-7.308670410312838, -5.454333214122311}, \
{-7.189044931165003, -5.300018001444475}, {-7.0873790940223955`, \
-5.1076950227665145`}, {-7.048463292168353, -4.997470410751029}, \
{-7.021297032943381, -4.878858627083822}, {-7.016697241160393, \
-4.750167020143403}, {-7.028251775968587, -4.623504646857952}, \
{-7.035532832655201, -4.58882747629305}}]}}, {
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.18866753813350873`, 
                  0.5225961012483197, -0.8572107239518071], 
                 
                 ArrowBox[{{-7.043752279580836, -4.5496810755359345`}, \
{-7.078855229733637, -4.38249778852514}, {-7.174150581867781, \
-4.1737248256709885`}, {-7.293758516993262, -4.005052362227446}, \
{-7.49379779567022, -3.8088222110705874`}, {-7.683658579825124, \
-3.676823445462244}, {-7.85367523589642, -3.585540988418904}, \
{-8.055049608446975, -3.502884005812372}, {-8.122024777926365, \
-3.47994121727413}}]}}, {
                Arrowheads[{{0.0008766152561477528, 1.}}], {
                 LABColor[
                 0.18866752709809162`, 
                  0.5225961012680244, -0.8572107503258525], 
                 
                 ArrowBox[{{-8.159866103156716, -3.466978420322434}, \
{-8.226210669176261, -3.4442516491820285`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18875444968432528`, 
                  0.5225959460600165, -0.8570030100836517], 
                 
                 ArrowBox[{{1.5298626496527121`, 0.38930659857822514`}, {
                  1.6778391563483497`, 0.4554585327115857}, {
                  1.8452521236922277`, 0.5451198993186298}, {
                  1.9827734871062779`, 0.638132179470597}, {
                  2.1284353162399094`, 0.7620195865719234}, {
                  2.273915697325013, 0.9280716545414099}, {2.348429052926793, 
                  1.040800848097609}, {2.4130753648835386`, 
                  1.1703218824248607`}, {2.4621494755312634`, 
                  1.3153330243352557`}, {2.4820459645548767`, 
                  1.391391778603945}, {2.4963962330764473`, 
                  1.4703025322175354`}, {2.4977560933939547`, 
                  1.5484791349079365`}}]}}, {
                Arrowheads[{{0.018522053013496447`, 1.}}], {
                 LABColor[
                 0.18889594763202927`, 
                  0.5225956934028472, -0.856664837702909], 
                 
                 ArrowBox[{{2.4955338163007768`, 1.5884042765562623`}, {
                  2.492535901668701, 1.6347858804113304`}, {
                  2.4694170621347404`, 1.7949406367730953`}, {
                  2.4236361902317625`, 1.9445066887792324`}, {
                  2.3606891757960424`, 2.078748388599967}, {2.231591288917556,
                   2.265708785395769}, {2.094029826039155, 
                  2.4078300308760694`}, {1.9596577318542097`, 
                  2.515746534998649}, {1.8334110670455752`, 
                  2.598881767746534}, {1.6386154110378361`, 
                  2.7017556858573886`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866756354655276`, 
                  0.5225961012029424, -0.8572106632160174], 
                 
                 ArrowBox[{{-6.109707340964927, -5.836569204942405}, \
{-5.948260678413452, -5.749865220972232}, {-5.768781693415828, \
-5.627067576146482}, {-5.578508982641547, -5.448315546414809}, \
{-5.470148750268195, -5.309289955240145}, {-5.375596076664375, \
-5.139072711409228}, {-5.3086778632514635`, -4.939322399539143}, \
{-5.289757065703657, -4.830668128598531}, {-5.282757106481858, \
-4.714086129666484}, {-5.295681235639669, -4.600556840752835}, \
{-5.299030010112305, -4.585707321540788}}]}}, {
                Arrowheads[{{0.016354168785601877`, 1.}}], {
                 LABColor[
                 0.18866761493560535`, 
                  0.5225961011111827, -0.8572105403989834], 
                 
                 ArrowBox[{{-5.30782958675948, -4.546687231191963}, \
{-5.320198304307523, -4.4918404475823595`}, {-5.387563931907144, \
-4.288105838676523}, {-5.483646163100905, -4.1147419053965075`}, \
{-5.593989820457852, -3.973642757562962}, {-5.78420917264356, \
-3.7957994816451497`}, {-5.963453305239224, -3.6735977717035717`}, \
{-6.12464307144434, -3.587270102420334}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.01789300712758686, 1.}}], {
                 LABColor[
                 0.1886675245196307, 0.5225961012726285, -0.8572107564882334], 
                 
                 ArrowBox[{{-8.80563152801562, -1.5735416051695645`}, \
{-8.81888658069722, -1.6863116268677585`}, {-8.843558154010376, \
-1.7942607313948116`}, {-8.886649781063355, -1.9367216360387058`}, \
{-8.94544442271709, -2.0655154168278798`}, {-9.014815593328944, \
-2.1788555349679966`}, {-9.143667940038915, -2.3375373684412395`}, \
{-9.275505542992, -2.459683629353421}, {-9.402430262809439, \
-2.5537547555173292`}, {-9.612790607263735, -2.672871918535771}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675229577883, 0.5225961012754172, -0.8572107602209517], 
                 
                 ArrowBox[{{-9.611274186647556, 
                  5.982790941324293}, {-9.385902581210829, 
                  5.902031881795801}, {-9.214299265973771, 
                  5.825002427463463}, {-9.017607431806013, 
                  5.712674381290056}, {-8.798600449605564, 
                  5.540711258637182}, {-8.66410116585241, 
                  5.396487335535706}, {-8.54081075217634, 
                  5.209796922012016}, {-8.450199469187673, 
                  4.980442964959707}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866752575707169`, 
                  0.5225961012704189, -0.8572107535308169], 
                 
                 ArrowBox[{{-8.441927262897364, 
                  4.941331325361321}, {-8.423175054132146, 
                  4.849555626959317}, {-8.41375896397098, 
                  4.715196695383585}, {-8.431339363894315, 
                  4.582809698870148}, {-8.464089234559651, 
                  4.457884017743544}, {-8.551850191273944, 
                  4.2280941365835565`}, {-8.672130782368027, 
                  4.040885787488936}, {-8.804499461844582, 
                  3.8954924063486955`}, {-9.018700182452868, 
                  3.7233745084507683`}, {-9.164571291776415, 
                  3.6379592814776704`}}]}}, {
                Arrowheads[{{0.00019226192788604734`, 1.}}], {
                 LABColor[
                 0.18866752360643183`, 
                  0.522596101274259, -0.8572107586707289], 
                 
                 ArrowBox[{{-9.199089057852891, 
                  3.617747309157045}, {-9.212361962357257, 
                  3.6099753236275585`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886675357422585, 0.5225961012525895, -0.8572107296667648], 
                 
                 ArrowBox[{{-7.201087747931943, -1.5733643105781367`}, \
{-7.2143218277974865`, -1.6861313532866036`}, {-7.238973433820907, \
-1.7940818670697605`}, {-7.29166427109834, -1.961324902160405}, \
{-7.365047345585676, -2.108957321394483}, {-7.4508741312073, \
-2.2349180305146126`}, {-7.610392757567416, -2.4083555959358773`}, \
{-7.767695874802702, -2.5343598322776995`}, {-7.914039801349199, \
-2.6269414683519456`}, {-8.122317467397652, -2.7277942655368523`}, \
{-8.160757323786493, -2.7429695311125126`}}]}}, {
                Arrowheads[{{0.009923234745126443, 1.}}], {
                 LABColor[
                 0.18866752689715915`, 0.5225961012683832, -0.85721075080607], 
                 
                 ArrowBox[{{-8.197962991144946, -2.757657564214741}, \
{-8.299652644440275, -2.797802550175236}, {-8.453217036891091, \
-2.848268837129079}, {-8.588089134361846, -2.8860955068811855`}, \
{-8.79176950229357, -2.933497596315305}, {-8.962311377503724, \
-2.96640501313147}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886675263962925, 0.5225961012692775, -0.857210752003114], 
                 
                 
                 ArrowBox[{{-8.29569150378796, 
                  6.057214435437547}, {-8.136665136905739, 
                  6.017136225375022}, {-7.949969940855468, 
                  5.960257426564036}, {-7.726189633775143, 
                  5.873471212048861}, {-7.558077314786926, 
                  5.791594835272855}, {-7.367810304682546, 
                  5.673443530125267}, {-7.160562855503277, 
                  5.496195083880846}, {-7.0387200886605585`, 
                  5.353724235251362}, {-6.971409103898736, 
                  5.242876639293195}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866753975103234`, 
                  0.5225961012454314, -0.8572107200860138], 
                 
                 ArrowBox[{{-6.950647576477053, 
                  5.208686597188531}, {-6.929771957763839, 
                  5.174308669771674}, {-6.851077755099867, 
                  4.958268839436407}, {-6.828637835256652, 
                  4.839022184074614}, {-6.820614173706303, 
                  4.71499858973181}, {-6.835942234138245, 
                  4.591193265341705}, {-6.864785180666417, 
                  4.473546450279277}, {-6.9430129343386175`, 
                  4.255268020848653}, {-7.052245121962628, 
                  4.073832672729283}, {-7.174803707425768, 
                  3.929900210776504}, {-7.330862259681842, 
                  3.7959606893945854`}}]}}, {
                Arrowheads[{{0.0030924640483095166`, 1.}}], {
                 LABColor[
                 0.1886675337147717, 0.5225961012562098, -0.8572107345123477], 
                 
                 ArrowBox[{{-7.361215694264425, 
                  3.7699094128607786`}, {-7.380076494757625, 
                  3.7537218566235926`}, {-7.568838575566099, 
                  3.6358494178547427`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866769455597449`, 
                  0.5225961009690134, -0.857210350110642], 
                 
                 ArrowBox[{{-4.69095240225169, -6.078704258392228}, \
{-4.550665086414852, -6.047434455981999}, {-4.3890784979223, \
-6.0051771600359265`}, {-4.199421181985804, -5.945360493977142}, \
{-3.971508575909663, -5.855364098419207}, {-3.8317958960887397`, \
-5.786031569163141}, {-3.6767838188102524`, -5.6931624131174114`}, \
{-3.507097095514071, -5.564373760402165}, {-3.32972910948739, \
-5.380664335474041}, {-3.306899062727257, -5.347470968176449}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886682280945169, 0.5225961000163329, -0.8572090749826135], 
                 
                 ArrowBox[{{-3.284231433246347, -5.314513744784358}, \
{-3.243396520707227, -5.255142501934211}, {-3.1693119631208537`, \
-5.107846859664306}, {-3.115840753550641, -4.940656222417269}, \
{-3.099237407528282, -4.851085070017643}, {-3.090701355547114, \
-4.7592345717275375`}, {-3.089603230021758, -4.713761790231238}, \
{-3.0984580905311647`, -4.619541761254794}, {-3.1155689602971184`, \
-4.528119657919963}, {-3.163775742854249, -4.353684861167573}, \
{-3.2353892867247556`, -4.198771482203101}, {-3.3214839647819363`, \
-4.066380011973768}, {-3.4884808930666598`, -3.8847659361879345`}, \
{-3.5000263702384435`, -3.875549579887147}}]}}, {
                Arrowheads[{{0.00604951328691807, 1.}}], {
                 LABColor[
                 0.18866807435290664`, 
                  0.5225961002908522, -0.8572094424166802], 
                 
                 ArrowBox[{{-3.5312875548743596`, -3.850594854179194}, \
{-3.6508295896169014`, -3.755168570040767}, {-3.8008209638577677`, \
-3.660580398112634}, {-3.937020112306628, -3.589402744728945}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866758941735343`, 
                  0.5225961011567478, -0.8572106013862143], 
                 
                 ArrowBox[{{-5.628000142425236, -1.5722408498293372`}, \
{-5.641101379039686, -1.6849890589244754`}, {-5.6656265003014346`, \
-1.792948536152101}, {-5.727166005335716, -1.982251185461246}, \
{-5.814158323149662, -2.1457061759974154`}, {-5.914830015845939, \
-2.2812611181445925`}, {-6.104661665594162, -2.4676459227334613`}, \
{-6.285556404720874, -2.59561432262989}, {-6.448812629054267, \
-2.6856573275526676`}, {-6.585562711957025, -2.74395283915659}}]}}, {
                Arrowheads[{{0.005992004629255551, 1.}}], {
                 LABColor[
                 0.18866754679253067`, 
                  0.5225961012328583, -0.8572107032572168], 
                 
                 ArrowBox[{{-6.622358808683289, -2.7596387330014247`}, \
{-6.642067222602047, -2.7680402787110006`}, {-6.8076335381994335`, \
-2.827006294973246}, {-6.951860213408732, -2.8703843855442552`}, \
{-7.079216604106065, -2.903430604065274}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866761056244427`, 
                  0.5225961011189914, -0.8572105508505999], 
                 
                 ArrowBox[{{-5.35640164679599, -5.832919242063069}, \
{-5.226828671318663, -5.764393381189981}, {-5.085186790353628, \
-5.674241697276096}, {-4.933418088618333, -5.5529626846452445`}, \
{-4.855282821821728, -5.477227514836558}, {-4.777849509404973, \
-5.38871853288128}, {-4.772590745959887, -5.382121990740843}, \
{-4.731623974935317, -5.32368361504545}, {-4.6929728419914465`, \
-5.260363744897932}, {-4.6224871026056285`, -5.124111889482189}, \
{-4.569296667339391, -4.970024694240301}, {-4.540165065579426, \
-4.802841195234013}, {-4.553998981887194, -4.578536944058645}}]}}, {
                Arrowheads[{{0.016336285344999972`, 1.}}], {
                 LABColor[
                 0.18866771920496642`, 
                  0.5225961009250004, -0.857210291200895], 
                 
                 ArrowBox[{{-4.556461294657051, -4.538612803293647}, \
{-4.560190168504558, -4.478152537560876}, {-4.671203580774293, \
-4.19332944937149}, {-4.828526097089895, -3.976676090060051}, \
{-4.994075462643933, -3.8218041714717548`}, {-5.1955612401471125`, \
-3.683135325430536}, {-5.37347886941979, -3.5883390857574047`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866759305341155`, 
                  0.5225961011502553, -0.8572105926962336], 
                 
                 ArrowBox[{{-5.575740655426823, -0.21977023007260718`}, \
{-5.392771512774296, -0.2645027474450919}, {-5.275276752290702, \
-0.29838030513926816`}, {-5.143845041974989, -0.3418330334415292}, \
{-4.995369107030889, -0.39923162541473967`}, {-4.825789004543963, \
-0.47686541544016847`}, {-4.675193728294204, -0.5637216956964565}, \
{-4.5105036561642065`, -0.6833996964024845}, {-4.338712813789029, \
-0.851602309841175}, {-4.249098989951825, -0.9674449573994751}, \
{-4.228352440736283, -1.0027258951600808`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866780207848158`, 
                  0.5225961007770225, -0.857210093137712], 
                 
                 ArrowBox[{{-4.208076677431863, -1.037206229010308}, \
{-4.16833880966712, -1.1047832137310636`}, {-4.104234197758521, \
-1.2634076177360507`}, {-4.080889788534184, -1.3498324293156974`}, \
{-4.064911887424825, -1.4397151150700258`}, {-4.056472021295752, \
-1.5529167206429866`}, {-4.056312048941291, -1.570226851769352}, \
{-4.06917530924162, -1.6829411942459889`}, {-4.087775257946859, \
-1.7732359575561718`}, {-4.113390698243288, -1.8593534711051647`}, \
{-4.175771201539332, -2.0215000044833458`}, {-4.2559778357872, \
-2.1622565360568062`}, {-4.345870919991636, -2.2810229469170245`}, \
{-4.5214420636860355`, -2.4551605418361553`}, {-4.530671541012754, \
-2.4618912989277133`}}]}}, {
                Arrowheads[{{0.004184117866640186, 1.}}], {
                 LABColor[
                 0.18866771895217246`, 
                  0.5225961009254518, -0.8572102918050587], 
                 
                 ArrowBox[{{-4.562990292053109, -2.4854603110239286`}, \
{-4.690011250302071, -2.5780925571681097`}, {-4.843872224432827, \
-2.666635576485747}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886683471023964, 0.5225960998038338, -0.8572087905602694], 
                 
                 ArrowBox[{{-3.1274183235485125`, -0.4516708188344385}, \
{-2.9513102807505507`, -0.5453837826693733}, {-2.812763210722589, \
-0.6392391634888593}, {-2.666028397288924, -0.7645221382352486}, \
{-2.5197349749274776`, -0.9327600218947453}, {-2.446447168990722, \
-1.0446576354089696`}, {-2.3829373035210994`, -1.1729197228595085`}, \
{-2.33472904741854, -1.3162622865423512`}, {-2.317952499794457, \
-1.392679867891419}, {-2.30698700981506, -1.4712463577012902`}, \
{-2.3020282554833265`, -1.5708359617219403`}, {-2.3084329375778663`, \
-1.6505024910613446`}, {-2.316613751315686, -1.7018092643807516`}}]}}, {
                Arrowheads[{{0.015320998152420495`, 1.}}], {
                 LABColor[
                 0.18866936518492447`, 
                  0.522596097985957, -0.8572063573985318], 
                 
                 ArrowBox[{{-2.323852997757024, -1.7411245172485657`}, \
{-2.3563853810611217`, -1.8789796512119334`}, {-2.4105865578872363`, \
-2.0166846338969155`}, {-2.4779674920513006`, -2.1386833907601432`}, \
{-2.6138602511141964`, -2.3171969080539685`}, {-2.755456511770288, \
-2.4523358640916513`}, {-2.8919845876462404`, -2.5543535568427322`}, \
{-3.068958174540618, -2.6601006157944562`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18912044039857429`, 
                  0.522595292551048, -0.8561283122298977], 
                 
                 ArrowBox[{{3.1803861410121037`, 0.34587538431976966`}, {
                  3.3284832268260742`, 0.40386440303235216`}, {
                  3.497466840384466, 0.48224345501072285`}, {
                  3.648316548349117, 0.5704862815168408}, {
                  3.8129319337627265`, 0.6920984346060746}, {
                  3.983824902936491, 0.8628267325871715}, {4.072863156824671, 
                  0.9809229442625611}, {4.152299310894588, 
                  1.1206579916105786`}, {4.214179793573226, 
                  1.281427888474923}, {4.239639768926125, 
                  1.3667743822696328`}, {4.2525930429675265`, 
                  1.429163866604684}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.190000340598555, 0.5225937214109899, -0.8540253987228704], 
                 
                 
                 ArrowBox[{{4.259643834398072, 1.468503452672242}, {
                  4.271320191382895, 1.5686811586709997`}, {4.258639436514678,
                   1.6813693737187811`}, {4.23451494748216, 
                  1.7893569192940126`}, {4.1741366879311315`, 
                  1.9776555071129864`}, {4.0883928794750375`, 
                  2.140630553619591}, {3.9888382102855786`, 
                  2.2761100162290995`}, {3.816037558843563, 
                  2.449336352500711}, {3.6495645636193474`, 
                  2.572234636497592}, {3.4971937266006283`, 
                  2.661083080292876}, {3.4088643153925453`, 
                  2.701386669650687}}]}}, {
                Arrowheads[{{0.006399990364968898, 1.}}], {
                 LABColor[
                 0.18921864139829608`, 
                  0.5225951172044299, -0.8558936171943436], 
                 
                 ArrowBox[{{3.372473572995724, 2.7179913035764383`}, {
                  3.3129017219504053`, 2.7451731831902304`}, {
                  3.1534322217314577`, 2.8059417483378}, {3.0135567755089387`,
                   2.8510901914181948`}, {2.8894256605590503`, 
                  2.885760650430645}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866765436002653`, 
                  0.5225961010407869, -0.8572104461767661], 
                 
                 ArrowBox[{{-4.954681577325572, 
                  0.42988755824234387`}, {-4.778796235613452, 
                  0.5194124000137775}, {-4.578430026825748, 
                  0.6492957109570747}, {-4.501148290221022, 
                  0.7120293565613789}, {-4.422431659266282, 
                  0.7853849781973434}, {-4.343903875754436, 
                  0.8712541887654982}, {-4.305356845764229, 
                  0.9194148690679946}, {-4.267871546523836, 
                  0.971381565135857}, {-4.26000366096483, 
                  0.9830419878853899}, {-4.2266546603953845`, 
                  1.0398297687941362`}, {-4.195871548444684, 
                  1.1003696095987168`}, {-4.1410198111896435`, 
                  1.2284761834566935`}, {-4.102027261880012, 
                  1.369106452883467}, {-4.08310940258814, 
                  1.5180518752146062`}, {-4.092482949089709, 
                  1.6490428585323555`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866783515504768`, 
                  0.5225961007179613, -0.8572100140865223], 
                 
                 ArrowBox[{{-4.095337997190885, 
                  1.6889408371821564`}, {-4.101706464857727, 
                  1.777937231638311}, {-4.180389494235732, 
                  2.0134156831866425`}, {-4.296221915417615, 
                  2.2068233295599646`}, {-4.4264804180574275`, 
                  2.3571685940922706`}, {-4.606497496663203, 
                  2.509537609525699}, {-4.772504899075863, 
                  2.6168487047274027`}, {-4.921916118580199, 
                  2.6952042324952874`}, {-5.05590988718211, 
                  2.7543001132641756`}, {-5.140156441681458, 
                  2.784395697508576}}]}}, {
                Arrowheads[{{0.0036246183584668335`, 1.}}], {
                 LABColor[
                 0.18866762852583926`, 
                  0.5225961010869161, -0.8572105079190653], 
                 
                 ArrowBox[{{-5.177825051739427, 
                  2.797852138951269}, {-5.272961404810444, 
                  2.8318379101862923`}, {-5.454465656337316, 
                  2.8843392583003786`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866752255360447`, 0.522596101276139, -0.857210761186929], 
                 
                 ArrowBox[{{-10., 0.33940498262933244`}, {-9.94859091328255, 
                  0.3570867814087617}, {-9.786219171915953, 
                  0.42347311051839304`}, {-9.599502673389104, 
                  0.5173447182839593}, {-9.38435308289511, 
                  0.6569135865800404}, {-9.29443805877198, 
                  0.7320621706804352}, {-9.203186855270706, 
                  0.8221986072046371}, {-9.113645501851641, 
                  0.9302439149918854}, {-9.038402326503347, 
                  1.0448704095402115`}, {-8.973475917345162, 
                  1.1766996045778229`}, {-8.924805745257595, 
                  1.3242856742717046`}, {-8.909667120622162, 
                  1.4023652294798965`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866752425769212`, 
                  0.5225961012730962, -0.8572107571142524], 
                 
                 ArrowBox[{{-8.902934885074789, 
                  1.441754548141903}, {-8.894468996210831, 
                  1.5467517193733167`}, {-8.904573890490225, 
                  1.6590612154104345`}, {-8.926235164460433, 
                  1.7672119374096793`}, {-8.963214019396759, 
                  1.9039500800008695`}, {-9.015261818003719, 
                  2.0291508515080663`}, {-9.078051760731574, 
                  2.1408073383290893`}, {-9.212587840184787, 
                  2.317096297929062}, {-9.352658028358606, 
                  2.4509421160710985`}, {-9.487819163434215, 
                  2.552290772377782}, {-9.657045756077101, 
                  2.654248932272752}, {-9.7328123295058, 
                  2.6911084239053618`}}]}}, {
                Arrowheads[{{0.0005502408426790743, 1.}}], {
                 LABColor[
                 0.18866752277697518`, 
                  0.5225961012757401, -0.8572107606530851], 
                 
                 ArrowBox[{{-9.768781718576085, 
                  2.708607082422814}, {-9.808365372481456, 
                  2.727864035639607}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18905646198370696`, 
                  0.5225954067901974, -0.856281217153417], 
                 
                 ArrowBox[{{3.028001193307697, -6.701752764785002}, {
                  3.1743980671191427`, -6.7728497479296665`}, {
                  3.3380028605871273`, -6.86944014011387}, {
                  3.51839325123816, -7.006086672075617}, {
                  3.7069025816259873`, -7.205950167171842}, {
                  3.7937654673438925`, -7.33905165384956}, {
                  3.8660018483513747`, -7.495010894002638}, {
                  3.9144970696287777`, -7.670779184511925}, {
                  3.9316436103040364`, -7.76292570634851}, {
                  3.9403991624435175`, -7.857893507922708}, {
                  3.9359049934864885`, -7.901636102826971}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18962789958928084`, 
                  0.5225943864375339, -0.8549155124300735], 
                 
                 ArrowBox[{{3.9318168634435002`, -7.941426644325569}, {
                  3.9303801525821553`, -7.955410422372911}, {
                  3.911593971974925, -8.049740281825578}, {
                  3.8593876910807876`, -8.229042961718818}, {
                  3.7830176143738385`, -8.386913925649841}, {
                  3.6922979614563527`, -8.520571747200496}, {
                  3.497026336377369, -8.719824679683533}, {
                  3.3125741806866875`, -8.854577636326836}, {
                  3.1465194727373897`, -8.949252218917461}, {
                  2.9985562357512388`, -9.018698971870737}, {
                  2.9015791281357965`, -9.05650730634992}}]}}, {
                Arrowheads[{{0.002989911772219112, 1.}}], {
                 LABColor[
                 0.1889991234263222, 0.5225955091732909, -0.8564182531795487], 
                 
                 ArrowBox[{{2.8643112891707108`, -9.07103686858945}, {
                  2.8038620841458113`, -9.094604118827982}, {
                  2.6376296891385262`, -9.14705890237067}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866907610784167`, 
                  0.5225960985021297, -0.8572070482769996], 
                 
                 ArrowBox[{{-2.494455067926276, -5.870723692134943}, \
{-2.36616510490425, -5.810115603984167}, {-2.2244999766192817`, \
-5.730829036439183}, {-2.0691121570255473`, -5.624039411532692}, \
{-1.90270563737848, -5.476438589381189}, {-1.8174158438447672`, \
-5.377699963077803}, {-1.7369022912460284`, -5.261140513335657}, \
{-1.6666203611394965`, -5.125667108403004}, {-1.6371781874753244`, \
-5.050968650623529}, {-1.6129058481027705`, -4.972149043340211}, \
{-1.5818782305824488`, -4.785912962383378}, {-1.5809652089489665`, \
-4.7729436502197435`}, {-1.5812066814183445`, -4.708882640487014}, \
{-1.5833218330637555`, -4.67755032101886}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18867137575445797`, 
                  0.5225960943959062, -0.8572015522469602], 
                 
                 ArrowBox[{{-1.5864857396674836`, -4.637687520695644}, \
{-1.6017939703731103`, -4.520012079085904}, {-1.6324578497357334`, \
-4.4004987503216}, {-1.6750608387659813`, -4.289396471174835}, \
{-1.799793475026547, -4.076943408484902}, {-1.9412489948189586`, \
-3.9154544863753413`}, {-2.082350449565196, -3.794285799277683}, \
{-2.2155910033168302`, -3.7022910225343986`}, {-2.4083801829779525`, \
-3.59639267162889}, {-2.5762549932545156`, -3.522426276029335}, \
{-2.6012263383206284`, -3.513246760070218}}]}}, {
                Arrowheads[{{0.0028337287683116393`, 1.}}], {
                 LABColor[
                 0.18866887048907838`, 
                  0.5225960988692803, -0.8572075396946339], 
                 
                 ArrowBox[{{-2.638770028520876, -3.499445625111533}, \
{-2.723399345247761, -3.4683357204809715`}, {-2.8536192274884744`, \
-3.427301694896527}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18867133289767984`, 
                  0.5225960944724307, -0.8572016546723235], 
                 
                 ArrowBox[{{-1.597599622539554, -6.072548789325952}, \
{-1.3894000043952095`, -6.02443233739292}, {-1.2368146942467835`, \
-5.980241015137655}, {-1.0597724539310733`, -5.918503892874049}, \
{-0.8515078666336199, -5.826823296625018}, {-0.740609319256566, \
-5.7680668051506}, {-0.6208412787444599, -5.69393253087117}, \
{-0.49299961807339865`, -5.598776905262869}, {-0.4336851625022665, \
-5.547711592128501}, {-0.3737674846522783, -5.490171446696948}, \
{-0.26389990932259677`, -5.362324043379532}, {-0.2334398395398238, \
-5.314414859707689}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868277625643926`, 
                  0.522596074039296, -0.8571743056687643], 
                 
                 ArrowBox[{{-0.21197865894803436`, -5.280659597486717}, \
{-0.16360483898845013`, -5.204574734849171}, {-0.08416212828914206, \
-5.012102420501495}, {-0.0427200411923066, -4.7952007957980225`}, \
{-0.04023060870552892, -4.76521796179407}, {-0.038637147573022224`, \
-4.735099017202715}, {-0.03848752357092708, -4.726964601895651}, \
{-0.0383954181984727, -4.707075729158106}, {-0.03865486245883326, \
-4.688998256743158}, {-0.03924062935256398, -4.670936055706904}, \
{-0.04890065695731626, -4.567351572804738}, {-0.0687460753306801, \
-4.466770870260992}, {-0.09762895515468575, -4.370959976069373}, \
{-0.1523842655449233, -4.242763862197975}, {-0.2181457693835582, \
-4.129081928114276}, {-0.29048723305255264`, -4.030053038461313}, \
{-0.43347886589827445`, -3.8803267408335684`}, {-0.4718579794266462, \
-3.849323344920497}}]}}, {
                Arrowheads[{{0.014323808820313144`, 1.}}], {
                 LABColor[
                 0.18867893728972118`, 
                  0.5225960808941125, -0.8571834805899254], 
                 
                 ArrowBox[{{-0.5029736921458468, -3.824187465743986}, \
{-0.5727981219549638, -3.767781930473449}, {-0.7034644125934312, \
-3.6819943382230904`}, {-0.8240630588449616, -3.615232659895952}, \
{-0.9465547711693483, -3.556647131505749}, {-1.0581148253605646`, \
-3.5103829078706434`}, {-1.160026991099791, -3.4730690248387615`}, \
{-1.3677977390121807`, -3.410303470314826}, {-1.542276011127536, \
-3.3666283288428986`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18870705774221574`, 
                  0.5225960306825438, -0.8571162742415511], 
                 
                 ArrowBox[{{0.7418127342971728, -5.789500539579382}, {
                  0.8818640417942122, -5.706947098180466}, {
                  1.0343753414594834`, -5.596413485497515}, {
                  1.1947464527392953`, -5.444576788957126}, {
                  1.3481926966928495`, -5.234705766714709}, {
                  1.404572445724372, -5.122130436816496}, {
                  1.449460140584495, -4.997602121846615}, {
                  1.4790669864565016`, -4.863501235620854}, {
                  1.4896023802551068`, -4.794464395747016}, {
                  1.4954136305504606`, -4.724123448718095}, {
                  1.4920862658355405`, -4.660444984407871}, {
                  1.4848180753997233`, -4.597563110709295}, {
                  1.4664279027596407`, -4.494028553661709}}]}}, {
                Arrowheads[{{0.015354533135481453`, 1.}}], {
                 LABColor[
                 0.1887483848027266, 0.522595956889402, -0.8570175048200236], 
                 
                 
                 ArrowBox[{{1.4570983694624429`, -4.455204731312078}, {
                  1.4276385076774114`, -4.358230110427178}, {
                  1.3815016375064961`, -4.251031929728309}, {
                  1.2473645709491652`, -4.041198653943082}, {
                  1.1000878390982631`, -3.8841592339408852`}, {
                  0.9557628458999071, -3.767380473931776}, {
                  0.820815731087333, -3.6791053104315714`}, {
                  0.6448840602676462, -3.5859755985099833`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19342646564095275`, 
                  0.5225876037600355, -0.845837146659079], 
                 
                 ArrowBox[{{5.53221867440571, -0.32320518677894333`}, {
                  5.676093169020506, -0.3754143623957002}, {
                  5.83991563598481, -0.4462842906349856}, {
                  6.0282467961244395`, -0.5458486149268145}, {
                  6.150619346743346, -0.6276266270682179}, {
                  6.279998219259243, -0.7330685369858804}, {
                  6.41148015925484, -0.8701797103608022}, {
                  6.506843180147223, -1.0004288569810587`}, {
                  6.589608638575728, -1.1560063753449576`}, {
                  6.649568934093808, -1.3351709587959422`}, {
                  6.655383438882294, -1.359266029563593}}]}}, {
                Arrowheads[{{0.019307992911898268`, 1.}}], {
                 LABColor[
                 0.20343226744161333`, 
                  0.5225697375110872, -0.8219238258578021], 
                 
                 ArrowBox[{{6.664766701478978, -1.3981498871788254`}, {
                  6.675280136523641, -1.4417171333377576`}, {
                  6.689922077286135, -1.5532634830029053`}, {
                  6.6790550095198915`, -1.665686387908848}, {
                  6.656663412963325, -1.7737897952907415`}, {
                  6.605037003826442, -1.9478784387508037`}, {
                  6.530664997637714, -2.1015700191318536`}, {
                  6.442594068479609, -2.2322890674367377`}, {
                  6.269169842011145, -2.419686328883365}, {
                  6.099047557333747, -2.552137991937748}, {
                  5.942506178920825, -2.64710717967587}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866786532774213`, 
                  0.5225961006640852, -0.8572099419754274], 
                 
                 ArrowBox[{{-4.003660152594428, 
                  5.856499589214964}, {-3.864050592220432, 
                  5.78743724534558}, {-3.7091214321588923`, 
                  5.694947996745275}, {-3.539432536012015, 
                  5.566704253584864}, {-3.3618085106703735`, 
                  5.383746974650931}, {-3.274920838606174, 
                  5.25824609861883}, {-3.2002057262912187`, 
                  5.110799250925021}, {-3.146108380396766, 
                  4.943228018317376}, {-3.129227206458832, 
                  4.853374228684707}, {-3.1204631133907292`, 
                  4.761187313318918}, {-3.119281570080043, 
                  4.717048542166536}, {-3.1259756161761922`, 
                  4.643452193071851}}]}}, {
                Arrowheads[{{0.017139518848153134`, 1.}}], {
                 LABColor[
                 0.18866834385504475`, 
                  0.5225960998096322, -0.8572087983212628], 
                 
                 ArrowBox[{{-3.1313239438886042`, 
                  4.603853611823922}, {-3.1447908110668803`, 
                  4.5308162406110295`}, {-3.1927268011889507`, 
                  4.355745609119564}, {-3.264291621726452, 
                  4.200217209254544}, {-3.350495969783154, 
                  4.067306690197177}, {-3.51740143523057, 
                  3.885485067669721}, {-3.679731912189874, 
                  3.7557324922456075`}, {-3.829735066310091, 
                  3.661032045592125}, {-3.9659558614712647`, 
                  3.5897723315118464`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18867442614321628`, 
                  0.5225960889491658, -0.8571942619841307], 
                 
                 ArrowBox[{{-1.0033827302616796`, -6.491290630729641}, \
{-0.7971018622369436, -6.538374865456776}, {-0.6472281789470505, \
-6.581077519064892}, {-0.4737375627720646, -6.640368799720919}, \
{-0.2700568649814685, -6.72766373349676}, {-0.22060772885587202`, \
-6.752105369153938}, {-0.16928041988207512`, -6.779157238709059}, \
{-0.07339689729491407, -6.834415691597909}, {
                  0.028543965808800083`, -6.901744054684569}, {
                  0.13915235985088317`, -6.9876071226710055`}, {
                  0.311500773264202, -7.158874154471323}, {
                  0.368766768585742, -7.239165693048599}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18869541911437174`, 
                  0.5225960514643488, -0.8571440899275766], 
                 
                 ArrowBox[{{0.3919934344740283, -7.271731349678151}, {
                  0.4132757139721675, -7.301570819956152}, {
                  0.49894797066863633`, -7.47356173800023}, {
                  0.5555564993734667, -7.67158558271008}, {
                  0.565444095708848, -7.725148625777102}, {
                  0.572520456248797, -7.779702101554199}, {
                  0.5730634133281526, -7.78744443704649}, {
                  0.574480634111062, -7.81404130217535}, {
                  0.5751211402328297, -7.836249905643079}, {
                  0.5752682313469251, -7.8584760039295265`}, {
                  0.568934958934172, -7.9667224150582765`}, {
                  0.551324811143665, -8.072414400159884}, {
                  0.5235625829083059, -8.173433438788125}, {
                  0.486846318266267, -8.269126011265314}, {
                  0.44327394147160903`, -8.357450251356966}, {
                  0.3946872690299386, -8.438006546540567}, {
                  0.2319547308491139, -8.635877605770746}, {
                  0.15230294444917214`, -8.704800823734645}}]}}, {
                Arrowheads[{{0.006130744562909146, 1.}}], {
                 LABColor[
                 0.18868885945690264`, 
                  0.5225960631772006, -0.8571597671513044], 
                 
                 ArrowBox[{{0.12205502978508767`, -8.730974544495636}, {
                  0.06823574344639234, -8.777544729178725}, \
{-0.08476346318265918, -8.8803917456065}, {-0.22418201194478266`, \
-8.957250395015258}, {-0.29232454347828374`, -8.990300655660493}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18876936987341006`, 
                  0.522595919418692, -0.8569673516451668], 
                 
                 ArrowBox[{{1.687873459745411, -5.9684050955462675`}, {
                  1.86683149253968, -5.903165792309562}, {
                  2.0769733205516907`, -5.805898569839658}, {
                  2.2174068834300953`, -5.726460279269906}, {
                  2.3711923729413242`, -5.6199961778068745`}, {
                  2.5347415719027575`, -5.473138892364928}, {
                  2.6950110648209136`, -5.267840586434263}, {
                  2.7679731810654844`, -5.12871818239849}, {
                  2.82295479425533, -4.970727501277032}, {
                  2.827208644584178, -4.946153739829844}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18898792660253622`, 
                  0.5225955291662155, -0.856445012977962], 
                 
                 ArrowBox[{{2.8340313909293893`, -4.906739908091368}, {
                  2.8527003759231713`, -4.798892393902372}, {
                  2.860436468654378, -4.710407091768562}, {
                  2.860323117043553, -4.62087722847612}, {
                  2.8430343524407125`, -4.528386394542518}, {
                  2.818288835902636, -4.440006980571285}, {
                  2.756871416432426, -4.273452770492955}, {
                  2.6763194035743165`, -4.128770556405735}, {
                  2.5852750707512886`, -4.006867362485587}, {
                  2.4149203648734283`, -3.8402409820494117`}, {
                  2.2534319008118766`, -3.721306724282409}, {
                  2.1056823401080424`, -3.634142721599152}, {
                  2.0871479360359335`, -3.6250068237131705`}}]}}, {
                Arrowheads[{{0.003985947483598945, 1.}}], {
                 LABColor[
                 0.18881428326468042`, 
                  0.5225958392218377, -0.8568600110886457], 
                 
                 ArrowBox[{{2.051269756849139, -3.607321907591224}, {
                  1.9719819178132818`, -3.568239690638709}, {
                  1.7578088051720853`, -3.483089934665119}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19001886635857917`, 
                  0.5225936883315978, -0.8539811231664112], 
                 
                 ArrowBox[{{4.273846128584917, 6.104247956829299}, {
                  4.46364750999997, 6.06602603398903}, {4.695879322441557, 
                  6.006914716407876}, {4.8542588633637305`, 
                  5.957553418504966}, {5.038598858431041, 
                  5.887660659423258}, {5.255486080268034, 
                  5.782108005978922}, {5.419020497184616, 
                  5.680568570815269}, {5.596283711886534, 
                  5.536760548459577}, {5.688826634847509, 
                  5.429387457897916}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19440518886507918`, 
                  0.5225858561626793, -0.8434980515120365], 
                 
                 ArrowBox[{{5.714940968000769, 5.399088256522953}, {
                  5.773596541605826, 5.331033023176823}, {5.875754204152369, 
                  5.1546544849586535`}, {5.948252030818661, 
                  4.945019845227666}, {5.975207983673449, 
                  4.7137407524068875`}, {5.975565688314827, 
                  4.594902599148159}, {5.961792552921359, 
                  4.476753835707251}, {5.923460689435763, 4.36966516982773}, {
                  5.877072364785221, 4.271492155187732}, {5.7738202497874545`,
                   4.093407497258595}, {5.656734605670079, 
                  3.950341240664736}, {5.6561278812570315`, 
                  3.9497692178430945`}}]}}, {
                Arrowheads[{{0.007186888622473919, 1.}}], {
                 LABColor[
                 0.19390959793747556`, 
                  0.5225867410843542, -0.8446824868100858], 
                 
                 ArrowBox[{{5.627023547813717, 3.9223295062042967`}, {
                  5.537100957411481, 3.837550036670768}, {5.3376178025163075`,
                   3.692077075796129}, {5.158634203110386, 
                  3.5932151022615595`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675551037341, 0.5225961012180178, -0.8572106833938937], 
                 
                 ArrowBox[{{-6.335448099755432, -6.718521692865969}, \
{-6.146878473364443, -6.818903301487203}, {-5.934389762131473, \
-6.970253628446297}, {-5.805889010362866, -7.090269804425624}, \
{-5.680447972650949, -7.245199251278102}, {-5.572269869705085, \
-7.440692793146153}, {-5.530246800396212, -7.553754274608088}, \
{-5.499965779299199, -7.679221510728295}, {-5.4924768525202925`, \
-7.775592498278858}, {-5.494304726830059, -7.872035342234456}, \
{-5.503687250860587, -7.955592774835971}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675980267862, 0.5225961011413749, -0.8572105808101393], 
                 
                 ArrowBox[{{-5.508150732669902, -7.995342961378149}, \
{-5.515507624714873, -8.060860833669679}, {-5.568254652407825, \
-8.236337261940179}, {-5.644059550521047, -8.390808891847628}, \
{-5.81883447383919, -8.618256427536034}, {-5.997514952739536, \
-8.7754693348601}, {-6.163523650340861, -8.886193831686048}, \
{-6.313288827763229, -8.967154433881513}, {-6.5451624943185305`, \
-9.068606995007993}, {-6.5745690992758, -9.07853644449051}}]}}, {
                Arrowheads[{{0.011802619097724409`, 1.}}], {
                 LABColor[
                 0.18866754710088549`, 
                  0.5225961012323076, -0.8572107025202655], 
                 
                 ArrowBox[{{-6.612466946872362, -9.091333051366856}, \
{-6.738776414453819, -9.133982771704723}, {-6.903309562488801, \
-9.179355564785737}, {-7.158475430723901, -9.236279987389498}, \
{-7.362596271540879, -9.271571502380633}, {-7.532513381176143, \
-9.295769862710879}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866760241857275`, 
                  0.5225961011335329, -0.8572105703140088], 
                 
                 ArrowBox[{{-5.45153442418078, -6.359318347408177}, \
{-5.263009232793523, -6.3752583983908435`}, {-5.030125743493281, \
-6.39990299016533}, {-4.872947576019392, -6.419997408189626}, \
{-4.686813438239219, -6.448415849995585}, {-4.4587994293571676`, \
-6.491976713367215}, {-4.293893511140109, -6.5303689465393555`}, \
{-4.098586756652754, -6.585668303126201}, {-3.886798881186184, \
-6.6629029940431685`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866792305291183`, 
                  0.5225961005610118, -0.857209804015419], 
                 
                 ArrowBox[{{-3.84959191031802, -6.677518680777549}, \
{-3.708321914049367, -6.741573776650861}, {-3.5355614271510754`, \
-6.838252496474926}, {-3.3439689051683272`, -6.978388876200344}, \
{-3.2311658157769227`, -7.0836816377818534`}, {-3.120033658033243, \
-7.2155338444646615`}, {-3.0195684502515996`, -7.37838666092138}, \
{-2.9768804197897407`, -7.471978518238145}, {-2.942171627626136, \
-7.573099558347426}, {-2.928773411238644, -7.624473730234012}, \
{-2.916271209453868, -7.712844848946001}, {-2.9117083131050947`, \
-7.802372677146442}, {-2.9135617412591954`, -7.85201576612216}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886685424367955, 0.5225960994550468, -0.857208323721705], 
                 
                 
                 ArrowBox[{{-2.915054104274952, -7.891987917085414}, \
{-2.918347411403739, -7.98019739985227}, {-2.954613430425119, \
-8.15058139925507}, {-3.01491073400112, -8.305412207504846}, \
{-3.1283011917663606`, -8.494586318164892}, {-3.2559806041388932`, \
-8.643297424983881}, {-3.384843374041714, -8.758155943287433}, \
{-3.5798566234126574`, -8.893097824034859}, {-3.7540217979927575`, \
-8.985681799929617}, {-3.8897010611058143`, -9.044297696355097}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886690971204034, 0.52259609846461, -0.8572069980581227], 
                 
                 ArrowBox[{{-2.4816287706471, -5.357550362323662}, \
{-2.352415492713238, -5.141184121658383}, {-2.299787257024756, \
-4.999624300186446}, {-2.2671353373934426`, -4.845558988009703}, \
{-2.2586811981435706`, -4.685061727496029}, {-2.264111223379029, \
-4.604557286833845}, {-2.2758375049295902`, -4.525421128858746}, \
{-2.299523128864096, -4.426811188487721}, {-2.333626478249952, \
-4.339702592534017}, {-2.373047781017455, -4.258872868639632}, \
{-2.4592400766444213`, -4.109991620611569}, {-2.555806999792383, \
-3.985878934594687}, {-2.6284839295055145`, -3.9116434956990265`}}]}}, {
                Arrowheads[{{0.007128122559051754, 1.}}], {
                 LABColor[
                 0.18866884401446596`, 
                  0.5225960989165531, -0.8572076029675142], 
                 
                 ArrowBox[{{-2.6565637366163988`, -3.883167771958517}, \
{-2.828339890920987, -3.7446632902004544`}, {-2.987999100703094, \
-3.6452463248175415`}, {-3.1320455845955752`, -3.5722008919599397`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19081942208655392`, 
                  0.5225922588681507, -0.8520678386217286], 
                 
                 ArrowBox[{{4.738563727802076, 0.4282751512425908}, {
                  4.9147148944568935`, 0.516448469042098}, {5.038159148377194,
                   0.5933434630614907}, {5.17006736872212, 
                  0.6928587891049134}, {5.306583912592787, 
                  0.8232830395525986}, {5.3939211439637, 
                  0.9285897323977546}, {5.475069373402406, 
                  1.0532242830976908`}, {5.543671030911006, 
                  1.197873175524142}, {5.573930269611196, 
                  1.2751440825912115`}, {5.598891475961382, 
                  1.3569591106663639`}, {5.6102398945225636`, 
                  1.46519777939978}, {5.609760378446759, 
                  1.5739326270321534`}, {5.602711637449962, 
                  1.6454054283264743`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.1937537988732153, 0.5225870192774389, -0.8450548380797209], 
                 
                 ArrowBox[{{5.598785830535291, 1.6852123126565586`}, {
                  5.590918913132479, 1.7649812564417624`}, {5.539544474889209,
                   1.9431740697534057`}, {5.464114608824053, 
                  2.100318784819025}, {5.318033592209159, 
                  2.3036852705795856`}, {5.162821059461081, 
                  2.454026519270173}, {5.013466161110377, 
                  2.564425770607568}, {4.824774291893572, 
                  2.6705143194600627`}, {4.6603444127157845`, 
                  2.746025403706257}, {4.557215701015137, 
                  2.785606421676257}}]}}, {
                Arrowheads[{{0.004643267429002075, 1.}}], {
                 LABColor[
                 0.19039721818868158`, 
                  0.5225930127507576, -0.8530768829196784], 
                 
                 ArrowBox[{{4.519871710417081, 2.7999391243597125`}, {
                  4.515610797068134, 2.8015744719273505`}, {4.387049841563506,
                   2.843874525283169}, {4.163454354035198, 
                  2.904069146986708}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19741440479054595`, 
                  0.5225804829400296, -0.836306189508409], 
                 
                 ArrowBox[{{6.140925541133632, 0.4220788938354656}, {
                  6.319208382920859, 0.5097291944789677}, {6.452553585737283, 
                  0.5921167927005037}, {6.595788524520377, 
                  0.701120485443666}, {6.743644551117895, 
                  0.8473371136888231}, {6.842680399622432, 
                  0.9761462728299085}, {6.930126609166516, 
                  1.1313121004299884`}, {6.995321035789516, 
                  1.311772752928303}, {7.023094959354247, 
                  1.4161414009574311`}, {7.040354949286567, 
                  1.5258730073999782`}, {7.033165833363651, 
                  1.6307320899401125`}}]}}, {
                Arrowheads[{{0.017860356281402374`, 1.}}], {
                 LABColor[
                 0.20988100989404218`, 
                  0.5225582227079406, -0.8065116829729047], 
                 
                 ArrowBox[{{7.026899880258743, 1.6702037701170633`}, {
                  7.013359460624593, 1.7460906934827025`}, {6.969415108653562,
                   1.9129910219409738`}, {6.90357758792196, 
                  2.062711886228177}, {6.823529575376992, 
                  2.1921839155976803`}, {6.6644810838981, 
                  2.3784732054444144`}, {6.504518310420672, 
                  2.513579063390383}, {6.354684296603321, 
                  2.6122145308862432`}, {6.149359488983963, 
                  2.715098504623204}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1896628370055649, 0.52259432405367, -0.8548320139098936], 
                 
                 ArrowBox[{{3.9676192751325887`, -6.5633908764804225`}, {
                  4.16168491591298, -6.626189830982182}, {
                  4.395070695832953, -6.72383090982316}, {
                  4.555994083902076, -6.808823787645805}, {
                  4.735275223900836, -6.929081671989708}, {
                  4.9264131736616505`, -7.104254318473774}, {
                  5.020562748204086, -7.218392975416297}, {
                  5.107040677078357, -7.355124629342743}, {
                  5.177694152709344, -7.514943050635223}, {
                  5.178167855769561, -7.516284200711667}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1920510683634101, 0.5225900596541909, -0.8491242711676726], 
                 
                 ArrowBox[{{5.191489562094714, -7.554000671126943}, {
                  5.207905887062442, -7.600478638728123}, {
                  5.231419530880739, -7.690980434220016}, {
                  5.2377669400960905`, -7.787393253742316}, {
                  5.2348225956481365`, -7.8836607127721425`}, {
                  5.211570166104016, -8.071768680209425}, {
                  5.157266061889359, -8.245958670757913}, {
                  5.080518162678614, -8.398912155656255}, {
                  4.904854598844914, -8.62411217438673}, {
                  4.726229415453306, -8.779687142508463}, {
                  4.560568255823538, -8.889323325702328}}]}}, {
                Arrowheads[{{0.00707733485427627, 1.}}], {
                 LABColor[
                 0.19040882579298554`, 
                  0.522592992024348, -0.8530491413782222], 
                 
                 ArrowBox[{{4.5253292540098515`, -8.908249776019607}, {
                  4.411174424868576, -8.969558749961399}, {
                  4.190816471893625, -9.065883674701182}, {
                  4.005235339555182, -9.129304396754575}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.188667522554889, 0.5225961012761366, -0.857210761183859], 
                 
                 ArrowBox[{{-10., -7.021476508028436}, {-9.895402882808153, \
-7.1222583519980756`}, {-9.814875155730745, -7.221894333787403}, \
{-9.739961413599387, -7.338357924712425}, {-9.698019630962737, \
-7.431758599989891}, {-9.66458922529258, -7.532209593251915}, \
{-9.618924064213937, -7.7426411696123845`}, {-9.618714022936667, \
-7.962573322908416}, {-9.663841307855492, -8.172950878271742}, \
{-9.810609825154373, -8.467941953798922}}]}}, {
                Arrowheads[{{0.0030662481033150698`, 1.}}], {
                 LABColor[
                 0.18866752270695367`, 
                  0.5225961012758651, -0.8572107608204327], 
                 
                 ArrowBox[{{-9.83678707883552, -8.49812076516639}, \
{-9.995726583232733, -8.67776014995035}, {-10., -8.681128644608902}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866752568063447`, 
                  0.5225961012705553, -0.8572107537134978], 
                 
                 ArrowBox[{{-8.46104375105769, 
                  0.43727739371373164`}, {-8.28218230040529, 
                  0.5294050051346304}, {-8.17609003976671, 
                  0.5966155992842709}, {-8.063803208399799, 
                  0.6803548209668745}, {-7.947478974211961, 
                  0.7857474175671612}, {-7.860427728473096, 
                  0.8821136579628481}, {-7.7772891283305725`, 
                  0.9963828251235148}, {-7.703397272890832, 
                  1.1300328305529923`}, {-7.671787058800828, 
                  1.2041385520958}, {-7.645146533499333, 
                  1.2826770496557933`}, {-7.620096742382842, 
                  1.387138978378237}, {-7.612078922208041, 
                  1.4962105947271316`}, {-7.61594836808033, 
                  1.605039072203628}, {-7.623416755862597, 
                  1.6676914068541133`}}]}}, {
                Arrowheads[{{0.015387324621828975`, 1.}}], {
                 LABColor[
                 0.18866753085963478`, 
                  0.5225961012613078, -0.8572107413359693], 
                 
                 ArrowBox[{{-7.628151382663856, 
                  1.7074102098201243`}, {-7.63613475237058, 
                  1.774382729872152}, {-7.681895614691258, 
                  1.932997093590965}, {-7.7471504647150775`, 
                  2.0750525999702747`}, {-7.893231944784121, 
                  2.2876842449057917`}, {-8.05094142401103, 
                  2.4445424583673296`}, {-8.203405214942775, 
                  2.559073255828714}, {-8.349978455864608, 
                  2.647205400288537}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866761129628107`, 0.5225961011176811, -0.85721054909677], 
                 
                 ArrowBox[{{-5.348091129687668, 
                  6.059434845367234}, {-5.182574465114845, 
                  6.018355383174775}, {-4.987198349095898, 
                  5.959671053835867}, {-4.75035390298672, 
                  5.870265501224649}, {-4.611547181255704, 
                  5.804198172212917}, {-4.4570991793373205`, 
                  5.715847190947179}, {-4.286842341329718, 
                  5.5934111841230285`}, {-4.105750145659485, 
                  5.418238801228045}, {-4.010105613360458, 
                  5.289200480920607}, {-4.001366613624628, 
                  5.2730494889444985`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886678730620012, 0.5225961006502751, -0.85720992349097], 
                 
                 ArrowBox[{{-3.982331211490609, 
                  5.237869189548443}, {-3.926622847051148, 
                  5.134911714521304}, {-3.865494223835844, 
                  4.956806679543583}, {-3.8463622546982448`, 
                  4.860443746333082}, {-3.8365770189408663`, 
                  4.761254999552405}, {-3.835755108758977, 
                  4.73969546423782}, {-3.843404924340275, 
                  4.638219772988222}, {-3.8606774373177384`, 
                  4.539731745194438}, {-3.9114123647404297`, 
                  4.352272073640589}, {-3.9889457885875643`, 
                  4.1871515070497685`}, {-4.082421488954465, 
                  4.04788506332414}, {-4.249516483976074, 
                  3.8673684277105593`}, {-4.314789327352866, 
                  3.8160057667155827`}}]}}, {
                Arrowheads[{{0.006067494347113564, 1.}}], {
                 LABColor[
                 0.188667766835879, 0.5225961008399512, -0.8572101773656107], 
                 
                 
                 ArrowBox[{{-4.346224071585134, 
                  3.791270026276859}, {-4.413704552269385, 
                  3.7381701937300256`}, {-4.565504815380393, 
                  3.6444801537707936`}, {-4.763854946756164, 
                  3.5466876485342658`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.013605338380825532`, 1.}}], {
                 LABColor[
                 0.18866755825103437`, 
                  0.5225961012123981, -0.8572106758720176], 
                 
                 ArrowBox[{{-6.2445921672795075`, 
                  4.618031435850327}, {-6.269611478349867, 
                  4.501854904284761}, {-6.3056998094947705`, 
                  4.393098188891283}, {-6.393847382142434, 
                  4.193109465764674}, {-6.505215994502958, 
                  4.028938026506303}, {-6.625125463349324, 
                  3.8987072253603636`}, {-6.827622779533698, 
                  3.7339780508898155`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.19313132695959917`, 
                  0.5225881307563982, -0.8465425120169666], 
                 
                 ArrowBox[{{5.466471535148953, 6.854302770643043}, {
                  5.647985953179262, 6.9911411938314725`}, {
                  5.8344199118872035`, 7.189712048558288}, {5.924873062701775,
                   7.323691393724766}, {6.000835378991005, 
                  7.481833662765148}, {6.052506899333484, 
                  7.661276569108777}, {6.070999199825684, 
                  7.755632783547528}, {6.0807117466863305`, 
                  7.853120002374548}, {6.071154592963244, 
                  7.950678669738229}, {6.052796012609765, 
                  8.045129774822314}, {6.001342013893442, 
                  8.224789763780242}, {6.000809773642592, 
                  8.22590127631217}}]}}, {
                Arrowheads[{{0.014532576193056618`, 1.}}], {
                 LABColor[
                 0.19614402434501788`, 
                  0.5225827513172921, -0.8393423295138583], 
                 
                 ArrowBox[{{5.9835344568434135`, 8.261978463418263}, {
                  5.9254995069361955`, 8.383176689235746}, {5.835084132763598,
                   8.51738532580928}, {5.639069138105164, 
                  8.718335687431576}, {5.453774952678349, 
                  8.853971648021796}, {5.287016416405359, 
                  8.949110777973571}, {5.138495600865109, 
                  9.01881797374271}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886680567911776, 0.5225961003222103, -0.8572094843882551], 
                 
                 ArrowBox[{{-3.5604756910530684`, 
                  6.594840988965971}, {-3.3185925220172883`, 
                  6.68260132705667}, {-3.1836746967180134`, 
                  6.7442673458788445`}, {-3.0335483975034356`, 
                  6.82609990573841}, {-2.867414337149867, 
                  6.938454662169359}, {-2.6880682953511763`, 
                  7.097705426171415}, {-2.5933104785414614`, 
                  7.21095616992693}, {-2.5058727272363037`, 
                  7.3468439004567205`}, {-2.433888001721598, 
                  7.506096528940908}, {-2.4063943237847614`, 
                  7.59387572029741}, {-2.404918944824508, 
                  7.6006741435859535`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866923629776955`, 
                  0.5225960982160963, -0.8572066654318052], 
                 
                 ArrowBox[{{-2.3964357005285866`, 
                  7.6397642262952}, {-2.386419018969558, 
                  7.685920260113872}, {-2.375165508837118, 
                  7.777635661278219}, {-2.3771770686217915`, 
                  7.8739600311708635`}, {-2.38815369039344, 
                  7.968594780154255}, {-2.425948426969339, 
                  8.150947732974043}, {-2.4910174582997393`, 
                  8.315643727296349}, {-2.574166455324682, 
                  8.45777170667978}, {-2.7602056412224947`, 
                  8.670979475887377}, {-2.942211095228964, 
                  8.81648819340123}, {-3.108360103006441, 
                  8.918789078110189}, {-3.1348657228428656`, 
                  8.93213004342308}}]}}, {
                Arrowheads[{{0.0012123371192804416`, 1.}}], {
                 LABColor[
                 0.18866831404012058`, 
                  0.5225960998628694, -0.8572088695773061], 
                 
                 ArrowBox[{{-3.170595150985375, 
                  8.950113590476128}, {-3.2572273749610288`, 
                  8.993717833733605}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.2020916621982669, 0.5225721312809716, -0.8251277993014796], 
                 
                 ArrowBox[{{6.566447692278953, 5.658738438557436}, {
                  6.77088779084037, 5.4778760366784525`}, {
                  6.8945952251614315`, 5.326154774389429}, {7.0019704672883, 
                  5.135108739146887}, {7.073764343590994, 
                  4.907193965431291}, {7.098094364519186, 
                  4.785063672193281}, {7.107639304363133, 
                  4.6577297728578095`}, {7.085484824041286, 
                  4.535287242148055}, {7.050736575897994, 
                  4.420300560820387}, {6.98309609433276, 
                  4.257388842990073}}]}}, {
                Arrowheads[{{0.01602626021530412, 1.}}], {
                 LABColor[
                 0.20866709273571846`, 
                  0.5225603902649826, -0.8094128788002349], 
                 
                 ArrowBox[{{6.967757747584085, 4.220446521473723}, {
                  6.962919581923791, 4.208793826805872}, {6.848371796537384, 
                  4.0356005029501585`}, {6.723864971251673, 
                  3.8992666897726544`}, {6.519392927770198, 
                  3.7329466343913}, {6.33318306382496, 3.6213168759063774`}, {
                  6.16877749187396, 3.5432962890634556`}, {5.968459727619807, 
                  3.4664677206395047`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19364174250857114`, 
                  0.5225872193640434, -0.8453226466820645], 
                 
                 ArrowBox[{{5.5757626879012205`, -6.759507810771045}, {
                  5.74256097099552, -6.856918200995033}, {
                  5.925793376427902, -6.996233603427305}, {
                  6.113292731578736, -7.198954141476451}, {
                  6.20313904409648, -7.335048819149433}, {
                  6.2777036083334705`, -7.495356326692407}, {
                  6.327090872893759, -7.6765902754982385`}, {
                  6.34422274390781, -7.7716841257499905`}, {
                  6.352399762807177, -7.869663103378072}, {
                  6.341243716480396, -7.967068111093768}, {
                  6.324767476487209, -8.045166658720914}}]}}, {
                Arrowheads[{{0.0149678399318262, 1.}}], {
                 LABColor[
                 0.1990713558962234, 0.5225775243064749, -0.8323461667004937], 
                 
                 ArrowBox[{{6.314529323277631, -8.083797090954281}, {
                  6.267358494887743, -8.239504156397642}, {
                  6.1897012340069235`, -8.396102857614}, {
                  6.0982412937137855`, -8.528409094366076}, {
                  5.901117293956656, -8.726528596967654}, {
                  5.715764156102388, -8.86018403882047}, {
                  5.549269450188832, -8.953981528081664}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18922341686539365`, 
                  0.5225951086774087, -0.8558822040883322], 
                 
                 ArrowBox[{{3.385880486288815, -5.6843114119041935`}, {
                  3.554891614942305, -5.553392505291238}, {
                  3.730464633322986, -5.366852105462211}, {
                  3.8235289217122106`, -5.224668135436536}, {
                  3.899565981871233, -5.056424486822791}, {
                  3.9475192196062276`, -4.86623118166511}, {
                  3.963075714705338, -4.766567116949345}, {
                  3.9687376558092144`, -4.664238894837245}, {
                  3.9530303761743024`, -4.561615796525277}, {
                  3.9280117823117155`, -4.463530248697114}, {
                  3.871287672381943, -4.302279228458161}}]}}, {
                Arrowheads[{{0.014589495930856908`, 1.}}], {
                 LABColor[
                 0.1895576945713825, 0.5225945117948367, -0.8550832985953712], 
                 
                 ArrowBox[{{3.855596534317973, -4.265634910884506}, {
                  3.774970333026812, -4.120915930430489}, {
                  3.674554076201332, -3.989734748760522}, {
                  3.502647128974037, -3.8224163705322938`}, {
                  3.3380670177278033`, -3.7033879368011813`}, {
                  3.1876560973429613`, -3.616983414079866}, {
                  2.9881212375837523`, -3.5247288875452507`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.2251034743451094, 0.5225310416439032, -0.7701308228422978], 
                 
                 ArrowBox[{{7.567343291993455, 0.6024417823943199}, {
                  7.690960172402814, 0.6969217394935385}, {7.818528348299116, 
                  0.8186430788794234}, {7.942275719387712, 
                  0.9752761749765168}, {8.01868152440789, 
                  1.1065641639307482`}, {8.07993403984778, 
                  1.2571338601549213`}, {8.118792980896146, 
                  1.4233761250039132`}, {8.13611391463623, 
                  1.5387718841741946`}, {8.140119959263782, 
                  1.6575009906527414`}, {8.116734123667534, 
                  1.7715468803122578`}, {8.08253594383401, 
                  1.8786882591684209`}, {8.036099700813455, 
                  1.9881700113716279`}}]}}, {
                Arrowheads[{{0.011927786803969156`, 1.}}], {
                 LABColor[
                 0.24599072945025593`, 
                  0.5224937455923734, -0.7202114218848951], 
                 
                 ArrowBox[{{8.020480717384437, 2.0249945596600187`}, {
                  8.000293790314592, 2.072588852467615}, {7.8953156699684826`,
                   2.2337067820615943`}, {7.781049778291768, 
                  2.3630893985986696`}, {7.625539244330109, 
                  2.498430868246465}, {7.47881813976683, 2.598117235117774}, {
                  7.344221631068683, 2.673088556189598}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.015434987756465113`, 1.}}], {
                 LABColor[
                 0.1886675233217711, 0.5225961012747673, -0.8572107593510525], 
                 
                 ArrowBox[{{-9.357867699502853, 
                  7.870320361508826}, {-9.369089082041732, 
                  7.967727571505033}, {-9.38898680680719, 
                  8.061741906127038}, {-9.443147150712862, 
                  8.240117711188898}, {-9.520886830146592, 
                  8.396654301983112}, {-9.612398915893683, 
                  8.52888993147557}, {-9.82778316805752, 
                  8.749665492900546}, {-10., 8.870201648214671}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886678881977981, 0.5225961006232488, -0.8572098873172406], 
                 
                 ArrowBox[{{-3.9386465590024815`, 
                  0.4138468838669618}, {-3.7788732452679814`, 
                  0.4909561589578996}, {-3.597299249683655, 
                  0.598352979805543}, {-3.460256305583465, 
                  0.7035293478390601}, {-3.319040059415346, 
                  0.8428660969450169}, {-3.185370280760407, 
                  1.0264076167268321`}, {-3.113746360848663, 
                  1.1669747031220792`}, {-3.0606852657170935`, 
                  1.3260785846546945`}, {-3.033340986711012, 
                  1.4983987703199584`}, {-3.030843108448806, 
                  1.5871610516571082`}, {-3.032333595050234, 
                  1.6118022457047358`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866842734663158`, 
                  0.5225960996605505, -0.8572085987809221], 
                 
                 ArrowBox[{{-3.0347486848377008`, 
                  1.6517292709046987`}, {-3.0361968666972676`, 
                  1.6756710696324837`}, {-3.0423302669146794`, 
                  1.7231367623845406`}, {-3.061828282287605, 
                  1.804762275860272}, {-3.086965580874808, 
                  1.8826380307268027`}, {-3.1462635862339696`, 
                  2.029690186667415}, {-3.2201441679602945`, 
                  2.1585157542695472`}, {-3.3022830412309636`, 
                  2.268750332574114}, {-3.46575444041187, 
                  2.43581981790281}, {-3.624423694642597, 
                  2.556499946182188}, {-3.7708742507432627`, 
                  2.645033695293997}, {-3.9562932946430376`, 
                  2.732849738090229}, {-4.057232745609256, 
                  2.772585823841193}}]}}, {
                Arrowheads[{{0.00030127850520524123`, 1.}}], {
                 LABColor[
                 0.18866783592716588`, 
                  0.5225961007165826, -0.8572100122412019], 
                 
                 ArrowBox[{{-4.094452593613941, 
                  2.7872378856247164`}, {-4.116879673955577, 
                  2.7960665881693463`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866939791106355`, 
                  0.5225960979275215, -0.8572062791848436], 
                 
                 ArrowBox[{{-2.306823077010527, -7.012314587487251}, \
{-2.1222802866568418`, -7.210197341362034}, {-2.0448375516349926`, \
-7.327759178142089}, {-1.9782960993324195`, -7.463476720626559}, \
{-1.9291100085933302`, -7.615745472472414}, {-1.912865034373047, \
-7.6969561350425675`}, {-1.9032196476376881`, -7.780296020068642}, \
{-1.9026638066838555`, -7.919647385836126}, {-1.9033048781255224`, \
-7.92905778595777}, {-1.9039228622224809`, -7.936793488887738}, \
{-1.9047356414876655`, -7.946064258062108}, {-1.9080550165728272`, \
-7.9768391481579695`}, {-1.9122999213232852`, -8.007382191153493}, \
{-1.917446829707223, -8.03763980419702}, {-1.9910956933369226`, \
-8.277072092949544}, {-2.09069063103362, -8.452723331102456}}]}}, {
                Arrowheads[{{0.010120684054694299`, 1.}}], {
                 LABColor[
                 0.1886698015011878, 0.5225960972068754, -0.8572053146264498], 
                 
                 ArrowBox[{{-2.11232494206619, -8.486201884397607}, \
{-2.2341081945871144`, -8.632494927110795}, {-2.4206218818406087`, \
-8.790504217679674}, {-2.590767608759945, -8.900601392293906}, \
{-2.7434057565303553`, -8.980313769160235}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.014062103854765935`, 1.}}], {
                 LABColor[
                 0.18866752318908092`, 
                  0.5225961012750042, -0.8572107596681748], 
                 
                 ArrowBox[{{-9.443049036045457, 
                  4.7001129661149195`}, {-9.463631248207879, 
                  4.564453305617724}, {-9.499801515387055, 
                  4.437264928181823}, {-9.594011859830346, 
                  4.20546479444658}, {-9.719817501118824, 
                  4.018833969476852}, {-9.856124938429495, 
                  3.87530414389037}, {-10., 3.7633575621174233`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18984589406841468`, 
                  0.5225939971890047, -0.8543945175096973], 
                 
                 ArrowBox[{{4.136449691777446, 6.695675335179604}, {
                  4.282270858101869, 6.765279478767996}, {4.4454014036958345`,
                   6.859736515754612}, {4.62582097121325, 
                  6.993248854883004}, {4.815992133488568, 7.18871916524899}, {
                  4.906266658499745, 7.322046468387109}, {4.982247821183579, 
                  7.479396378424881}, {5.03422926660934, 7.658000289807417}, {
                  5.0529589556018255`, 7.751942444474784}, {5.062994695706963,
                   7.849050771609256}, {5.059482597110655, 
                  7.886457743009974}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.19162261212036055`, 
                  0.5225908247009163, -0.8501482582297267], 
                 
                 ArrowBox[{{5.0557434861658015`, 7.926282597678159}, {
                  5.053832087253277, 7.94664069483731}, {5.0358398229146015`, 
                  8.041191396329896}, {4.985031860417954, 
                  8.221150027200466}, {4.909644975591734, 
                  8.379973983954903}, {4.819494276029629, 
                  8.514651938095676}, {4.623986078388343, 8.71611666302954}, {
                  4.438890579160414, 8.852179860814843}, {4.272199635798172, 
                  8.947636968212517}, {4.123693989800611, 9.01758111732613}, {
                  4.038128059513873, 9.050663539827424}}]}}, {
                Arrowheads[{{0.0013215646458986216`, 1.}}], {
                 LABColor[
                 0.18970269899899056`, 
                  0.5225942528765357, -0.8547367459188263], 
                 
                 ArrowBox[{{4.000819485784106, 9.06508818284729}, {
                  3.9022081017237813`, 9.103214379336812}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866896194234056`, 
                  0.5225960987059823, -0.8572073211263231], 
                 
                 ArrowBox[{{-2.5710193100277317`, 
                  5.597610020050794}, {-2.3974385901573236`, 
                  5.432535057697925}, {-2.3124913394200717`, 
                  5.323821849651043}, {-2.2350087982138915`, 
                  5.19594655120258}, {-2.1714778230243446`, 
                  5.048796120074479}, {-2.147021891857237, 
                  4.968578047756811}, {-2.128827823528803, 
                  4.884865967144686}, {-2.115810570820041, 
                  4.773617548711105}, {-2.11535856918805, 
                  4.76600758727467}, {-2.116054594907111, 
                  4.701812427801544}, {-2.120813281226541, 
                  4.638098982073697}, {-2.138018497509671, 
                  4.5128326431650185`}, {-2.1695372040943086`, 
                  4.393496159782355}, {-2.21287753994325, 
                  4.2827345246369815`}, {-2.2780109267680055`, 
                  4.174133822515398}}]}}, {
                Arrowheads[{{0.013435196239179839`, 1.}}], {
                 LABColor[
                 0.18866941678291982`, 
                  0.5225960978938241, -0.8572062340821359], 
                 
                 ArrowBox[{{-2.2985844777311706`, 
                  4.139830338716139}, {-2.3432962861289175`, 
                  4.0652797277033015`}, {-2.4901607651886395`, 
                  3.90192759509901}, {-2.635511163016884, 
                  3.780584681296431}, {-2.7718967957100737`, 
                  3.689119891457812}, {-2.972128418867931, 
                  3.582727142823476}, {-3.145100886412487, 
                  3.5092860459610047`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866752343582827`, 
                  0.5225961012745637, -0.8572107590784621], 
                 
                 ArrowBox[{{-9.289978104214784, -0.23437147728002353`}, \
{-9.176714731764482, -0.2632393038791264}, {-9.050132464951291, \
-0.30003391080799025`}, {-8.90306815751706, -0.3493140327442788}, \
{-8.734702888908474, -0.41669691490901206`}, {-8.539702314552796, \
-0.5132824282799175}, {-8.313304650551194, -0.6598467269754831}, \
{-8.235736484358423, -0.7243004464841771}, {-8.15696755068236, \
-0.799692244636463}, {-8.078764794771537, -0.8879183818449197}, \
{-8.040571832768565, -0.9373678561218675}, {-8.003424000940896, \
-0.9909580395526719}, {-7.970099908584173, -1.0489016213971438`}, \
{-7.96778048241881, -1.0535817953640396`}}]}}, {
                Arrowheads[{{0.019140151189303022`, 1.}}], {
                 LABColor[
                 0.1886675283411791, 0.5225961012658047, -0.8572107473549411], 
                 
                 ArrowBox[{{-7.950018624791005, -1.0894219462232309`}, \
{-7.93949534028039, -1.1106559923628778`}, {-7.885360306685538, \
-1.2412328767295437`}, {-7.847841641495684, -1.3842567481573331`}, \
{-7.831131673706015, -1.5351807092683534`}, {-7.844821132146658, \
-1.740745552954926}, {-7.896784841091146, -1.9333832018940076`}, \
{-7.977011491865079, -2.1024246173574297`}, {-8.126241373778429, \
-2.3087836043315657`}, {-8.284474266303736, -2.460376541896814}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.007347427726704587, 1.}}], {
                 LABColor[
                 0.1886675232245575, 0.5225961012749409, -0.8572107595833878], 
                 
                 ArrowBox[{{-9.419554685881003, -1.6465614950379097`}, \
{-9.441598472285632, -1.7604622808679042`}, {-9.474548971004396, \
-1.8677297661737238`}, {-9.54398304444425, -2.0410654598026454`}, \
{-9.632941639127061, -2.1892549686647973`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866753676320425`, 
                  0.5225961012507665, -0.8572107272267602], 
                 
                 ArrowBox[{{-7.129689332468046, -0.4212198110612622}, \
{-6.942202722065843, -0.5149322842719103}, {-6.726136071094561, \
-0.6546234897872995}, {-6.648676285993935, -0.7182499704442633}, \
{-6.5698975686979715`, -0.79266718413962}, {-6.491497842858834, \
-0.8797721020697384}, {-6.453112322030524, -0.9286118363149234}, \
{-6.41496541755584, -0.9826502554124239}, {-6.381423289482912, \
-1.0397573340240376`}, {-6.350478389757704, -1.1006590483432541`}, \
{-6.295393130186906, -1.2295632291860576`}, {-6.256385340048721, \
-1.371102750842553}, {-6.237723979129732, -1.5209740173399964`}, \
{-6.243872723978953, -1.6272679026079593`}}]}}, {
                Arrowheads[{{0.011780756772247889`, 1.}}], {
                 LABColor[
                 0.18866755816811714`, 
                  0.5225961012125461, -0.8572106760701853], 
                 
                 ArrowBox[{{-6.246182728175028, -1.6672011454090907`}, \
{-6.250246934120139, -1.7374594259246328`}, {-6.305166419132941, \
-1.9399801792933729`}, {-6.390922405355979, -2.116240338004464}, \
{-6.540051097095519, -2.3175598216993905`}, {-6.696889042185729, \
-2.465638816331344}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.012608116692942251`, 1.}}], {
                 LABColor[
                 0.18866763230924227`, 
                  0.5225961010801605, -0.8572104988769383], 
                 
                 ArrowBox[{{-5.13775516426578, -6.846441869984832}, \
{-5.003100787085493, -6.941317203240847}, {-4.861680325318033, \
-7.066739736477829}, {-4.72215922746795, -7.233021769759138}, \
{-4.657450133924132, -7.334261693296503}, {-4.600671912039855, \
-7.448583850724164}, {-4.596745421579192, -7.4578510625083005`}, \
{-4.569484013792498, -7.542668822465204}, {-4.549459159542242, \
-7.631321799691246}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866962713285196`, 
                  0.5225960975182256, -0.8572057313572662], 
                 
                 ArrowBox[{{-2.191047914311538, -0.43919519924484685`}, \
{-2.0717722317480898`, -0.4994947342139158}, {-1.9416224604392553`, \
-0.5768288137418657}, {-1.8009037939599766`, -0.6783055339066035}, \
{-1.6525105037820647`, -0.813956629013932}, {-1.5805272410608324`, \
-0.897074997144537}, {-1.5116032999954423`, -0.9927798832637567}, \
{-1.44886043655882, -1.1019331418500495`}, {-1.4208676073866198`, \
-1.1616048064815143`}, {-1.395931197858392, -1.2245197566898112`}, \
{-1.362385426496557, -1.337419603436291}, {-1.3415402871845188`, \
-1.4566063561990525`}, {-1.3406008964028011`, -1.4647970915347868`}, \
{-1.3397278046792815`, -1.4730029513246934`}, {-1.3377058627652267`, \
-1.5405817902033798`}, {-1.3402327122462196`, -1.6079686534058124`}, \
{-1.3467004963226292`, -1.6703486209424632`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18867239978403694`, 
                  0.5225960925674102, -0.8571991048720952], 
                 
                 ArrowBox[{{-1.3508257287164547`, -1.710135333016935}, \
{-1.3540156413065194`, -1.7409011473147213`}, {-1.3841715249004862`, \
-1.8681453828839494`}, {-1.4279991352821093`, -1.986355868916348}, \
{-1.5396426175509363`, -2.1834200061470224`}, {-1.6673626733101132`, \
-2.337503713701869}, {-1.796897506233371, -2.456198021671914}, \
{-1.9211249834289403`, -2.5481736145666165`}, {-2.1094269854187306`, \
-2.6591639130127174`}, {-2.2748514507367017`, -2.7371423675358972`}, \
{-2.4180794629269835`, -2.793390312393339}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18866754533222566`, 
                  0.5225961012354657, -0.8572107067472662], 
                 
                 ArrowBox[{{-6.680117239168414, 
                  6.023199237064932}, {-6.44820996716258, 
                  5.9517809649915225`}, {-6.285595985359526, 
                  5.889829965561368}, {-6.097808788975812, 
                  5.801306670739854}, {-5.881966964009049, 
                  5.667378218566478}, {-5.759647405275228, 
                  5.571082501457766}, {-5.634211461854175, 
                  5.4474770100397905`}, {-5.513734837063256, 
                  5.2893597775572045`}, {-5.458982314510562, 
                  5.195674951801899}, {-5.424670581878977, 
                  5.120505135797265}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866760603020552`, 
                  0.5225961011270841, -0.8572105616824034], 
                 
                 ArrowBox[{{-5.408668520553961, 
                  5.083897036187527}, {-5.380069994675988, 
                  4.978759406204346}, {-5.362720111838465, 
                  4.865197361923968}, {-5.354186623530372, 
                  4.636306267095577}, {-5.395471630476748, 
                  4.414882589109108}, {-5.4763913810249365`, 
                  4.218560239673188}, {-5.627284900963388, 
                  3.995770364626359}, {-5.79125927996372, 
                  3.8332366741939627`}, {-5.949349691604945, 
                  3.7160626719852443`}, {-5.960538612000255, 
                  3.7098684065927148`}}]}}, {
                Arrowheads[{{0.004533856282501754, 1.}}], {
                 LABColor[
                 0.1886675687810187, 0.5225961011935958, -0.8572106507059292], 
                 
                 ArrowBox[{{-5.995533811863881, 
                  3.690494816669707}, {-6.14821968455244, 
                  3.6059668386603767`}, {-6.319847182760713, 
                  3.5287778934715885`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1984053077934509, 0.5225787135945952, -0.8339379853541102], 
                 
                 ArrowBox[{{6.248130303244986, -0.2527649758362405}, {
                  6.370557594800854, -0.28652134700954274`}, {
                  6.508393047647178, -0.330256444493415}, {
                  6.665259939618268, -0.3883495731168895}, {
                  6.774658459760532, -0.4363552670736379}, {
                  6.894229165063685, -0.49681947054648234`}, {
                  7.024643575911885, -0.5746446531464124}, {
                  7.166603173700163, -0.6781604996480338}, {
                  7.314669133555287, -0.8170055280438349}, {
                  7.457037205723655, -1.0028435245340281`}, {
                  7.52529866990965, -1.1285137020288762`}}]}}, {
                Arrowheads[{{0.01642475131326561, 1.}}], {
                 LABColor[
                 0.22413125413635412`, 
                  0.5225327776295472, -0.7724543761371387], 
                 
                 ArrowBox[{{7.5405568829958955`, -1.165400840956511}, {
                  7.587186628899875, -1.2917802648931123`}, {
                  7.620278177263765, -1.4598849991342417`}, {
                  7.633786722748502, -1.5792840713131568`}, {
                  7.6329707969303975`, -1.7011575061276172`}, {
                  7.604146912561976, -1.8157486428044103`}, {
                  7.574303648730674, -1.9023044939228375`}, {
                  7.538856985938525, -1.9832465631907195`}, {
                  7.459849875190082, -2.133319751710043}, {
                  7.3688532788267445`, -2.2600438894967434`}, {
                  7.273053651710777, -2.365149814905602}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.017633542412117436`, 1.}}], {
                 LABColor[
                 0.1886675225525225, 0.5225961012761409, -0.8572107611895148], 
                 
                 ArrowBox[{{-10., -0.38446575633957597`}, \
{-9.953090343006403, -0.4035984752147753}, {-9.863679354987513, \
-0.44402827253579924`}, {-9.767666654001754, -0.49274588428517146`}, \
{-9.717064917583999, -0.520865603505223}, {-9.664637380223427, \
-0.5520719590506213}, {-9.618821445946036, -0.5822250041966958}, \
{-9.571876524788186, -0.6154024874996816}, {-9.476088640827252, \
-0.6887897618294476}, {-9.377506282924422, -0.7780046314218089}, \
{-9.279073637022494, -0.8867269072670075}, {-9.078433891710086, \
-1.2458570112257104`}, {-9.048715025657652, -1.353146414750092}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.017234046867527265`, 1.}}], {
                 LABColor[
                 0.19568385162637703`, 
                  0.5225835729966053, -0.8404421172234376], 
                 
                 ArrowBox[{{5.918859918289479, 10.}, {5.766552757277488, 
                  9.90892790505771}, {5.686065295354251, 9.866667008226717}, {
                  5.610229308834669, 9.830836180837995}, {5.489280742432697, 
                  9.78496412172652}, {5.379453430095103, 9.747983994894474}, {
                  5.17818659117824, 9.68656644936055}, {5.008769681106006, 
                  9.644741104958856}, {4.862966168949984, 9.61435567079436}, {
                  4.6191805768634415`, 9.572381406963721}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.01968388347826804, 1.}}], {
                 LABColor[
                 0.188667787774528, 0.5225961008025635, -0.8572101273233812], 
                 
                 
                 ArrowBox[{{-4.2596019841846795`, 
                  7.8710165473545}, {-4.27088437451714, 
                  7.968388339006597}, {-4.290833189062912, 
                  8.062358657394496}, {-4.3450741973699305`, 
                  8.240637510013118}, {-4.422853674572305, 
                  8.397070130615024}, {-4.514373029120673, 
                  8.529211362387432}, {-4.710471890573385, 
                  8.726229087656703}, {-4.8949451351639315`, 
                  8.85942544409642}, {-5.060776069274113, 
                  8.953047112271596}, {-5.208466684359465, 
                  9.02175536934597}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866754275312148`, 
                  0.5225961012400709, -0.8572107129111846], 
                 
                 ArrowBox[{{-6.796155834524161, 
                  0.2649482287903918}, {-6.644598780422943, 
                  0.30949947668747446`}, {-6.469122440002219, 
                  0.37105952378460094`}, {-6.341091374220614, 
                  0.42468094880181145`}, {-6.198600856495999, 
                  0.49487514825919887`}, {-6.040015998891594, 
                  0.5897075326091563}, {-5.865546773755338, 
                  0.7218619457284737}, {-5.786642775447179, 
                  0.7969967071121246}, {-5.708232124229049, 
                  0.8849609554975193}, {-5.633037689795868, 
                  0.987533432573984}, {-5.597661430519173, 
                  1.0446965093843827`}, {-5.562905281888868, 
                  1.109338519443126}, {-5.539891019700258, 
                  1.1649452788282915`}}]}}, {
                Arrowheads[{{0.01340116792213134, 1.}}], {
                 LABColor[
                 0.1886675966976939, 0.5225961011437481, -0.8572105839865974], 
                 
                 ArrowBox[{{-5.526335234798674, 
                  1.2025523914293372`}, {-5.510352565992171, 
                  1.2508188692598232`}, {-5.472984702872418, 
                  1.4015248909174913`}, {-5.458792047716708, 
                  1.5600929261337158`}, {-5.469700732621423, 
                  1.7191610593863418`}, {-5.549782664139584, 
                  1.996268317906767}, {-5.682204752542479, 
                  2.2187276326697196`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1887000486845714, 0.5225960431978395, -0.857133025507197], 
                 
                 
                 ArrowBox[{{0.5464765877119407, -6.688068717639524}, {
                  0.699505384831163, -6.760862650010158}, {
                  0.8446794647762996, -6.8432933471393875`}, {
                  1.0040672706696778`, -6.95492627888172}, {
                  1.1732970901214528`, -7.110797728354785}, {
                  1.3361635675546992`, -7.330571416895091}, {
                  1.3926920203574147`, -7.443135816029567}, {
                  1.4377420887046102`, -7.567690763809323}, {
                  1.4675105860013524`, -7.7018634587855095`}, {
                  1.4781244298324352`, -7.770948076100231}, {
                  1.4840085734628388`, -7.841348473723528}, {
                  1.48406769696355, -7.848369743719298}, {
                  1.4840794838847908`, -7.856795804338506}, {
                  1.4838512536693476`, -7.87034122791001}}]}}, {
                Arrowheads[{{0.011453165478436219`, 1.}}], {
                 LABColor[
                 0.188750460135349, 0.522595953183711, -0.8570125448882003], 
                 
                 ArrowBox[{{1.4824634744010186`, -7.910313506239102}, {
                  1.4823475330564972`, -7.912894474425737}, {
                  1.4803086014210804`, -7.940827275256462}, {
                  1.4543355941312373`, -8.097618337614877}, {
                  1.4069025888154265`, -8.243378208539829}, {
                  1.3434653491226818`, -8.373917491862573}, {
                  1.210852170376114, -8.560987678819364}, {
                  1.0707598090350128`, -8.702331739007699}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866753605345893`, 
                  0.5225961012520338, -0.8572107289230128], 
                 
                 ArrowBox[{{-7.1803119000075535`, -6.752363096491958}, \
{-6.990235946385203, -6.863534588524968}, {-6.780123733901098, \
-7.030889041487174}, {-6.651907064736569, -7.168780965314797}, \
{-6.5335625414048435`, -7.345292426600839}, {-6.443096430824914, \
-7.562379761894999}, {-6.414529570786981, -7.684260916442839}, \
{-6.400938260936824, -7.81303540856845}, {-6.40659475891478, \
-7.910812248076689}, {-6.42130503827024, -8.00616901371259}, \
{-6.427550859004702, -8.031508222282103}}]}}, {
                Arrowheads[{{0.014693196588630695`, 1.}}], {
                 LABColor[
                 0.18866755184784964`, 0.5225961012238315, -0.85721069117528], 
                 
                 ArrowBox[{{-6.437123871017348, -8.070345799974406}, \
{-6.466287245554649, -8.188661208214368}, {-6.537509760471327, \
-8.351325431843927}, {-6.625211072535059, -8.490192696987927}, \
{-6.812878995995595, -8.69967025063786}, {-6.997913462703871, \
-8.843382214920771}, {-7.16672987330903, -8.943453087170624}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18882752037109182`, 
                  0.5225958155858069, -0.8568283751259911], 
                 
                 ArrowBox[{{2.139537004517353, 0.2965537640291478}, {
                  2.2625832885906902`, 0.3367509128500891}, {
                  2.4004409022848265`, 0.3889047853647921}, {
                  2.5561905170586305`, 0.4587404774054914}, {
                  2.7336904690003725`, 0.5549770878196955}, {
                  2.8766931607981214`, 0.6545448826957397}, {
                  3.0274093886823916`, 0.7886306244891469}, {
                  3.175128701803773, 0.9696330974139417}, {3.254734349400724, 
                  1.1054371604748616`}, {3.318044118715048, 
                  1.2619939263604234`}, {3.321254733590239, 
                  1.2763005793863231`}}]}}, {
                Arrowheads[{{0.01499742339405592, 1.}}], {
                 LABColor[
                 0.18919367629797182`, 
                  0.5225951617818366, -0.8559532824230562], 
                 
                 ArrowBox[{{3.33001345519759, 1.3153298606480235`}, {
                  3.356921099969331, 1.435231609209685}, {3.3692636370946425`,
                   1.5252249079525826`}, {3.373526540965797, 
                  1.6171090248502291`}, {3.3613993351678655`, 
                  1.7058710704887163`}, {3.342106222340283, 
                  1.7915876753175122`}, {3.291533955582057, 
                  1.9547764412395219`}, {3.221001657194856, 
                  2.0994984804291463`}, {3.1382094613245246`, 
                  2.2237041215369366`}, {2.9805790215510806`, 
                  2.3987145347377834`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.1886677653283588, 0.5225961008426431, -0.8572101809685019], 
                 
                 ArrowBox[{{-4.3476903948910595`, -0.3148649926604892}, \
{-4.210510262714103, -0.3630800052449687}, {-4.055071731790394, \
-0.42756697388810666`}, {-3.8770277758482856`, -0.5162259938226724}, \
{-3.730057807193254, -0.6096221495342269}, {-3.5721823171833442`, \
-0.7368919003513992}, {-3.412448541533485, -0.9121977287602531}, \
{-3.3298619743965645`, -1.034283425960649}, {-3.2589168712545176`, \
-1.1765693076754433`}, {-3.2077204954427225`, -1.335463279230008}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866828941538077`, 
                  0.5225960999068391, -0.8572089284290918], 
                 
                 ArrowBox[{{-3.1999262608878447`, -1.3746826832600054`}, \
{-3.190564111834659, -1.4232854637515335`}, {-3.1814206525453805`, \
-1.5114964520174732`}, {-3.1798184711575477`, -1.5530185867118274`}, \
{-3.186279841411873, -1.64230746074756}, {-3.200281821605767, \
-1.729451434487283}, {-3.2413997903672715`, -1.896849709406385}, \
{-3.3049856871977688`, -2.047745446647651}, {-3.3834300198349103`, \
-2.178742387814678}, {-3.5352507244168425`, -2.3619022476422655`}, \
{-3.6893912629019954`, -2.4965424504598426`}, {-3.8349694537896273`, \
-2.5958928559356864`}, {-3.9542407408792024`, -2.6588362590995165`}}]}}, {
                Arrowheads[{{0.00044355975434671855`, 1.}}], {
                 LABColor[
                 0.18866787112078726`, 
                  0.5225961006537413, -0.8572099281303655], 
                 
                 ArrowBox[{{-3.9896167837588363`, -2.6775053670101356`}, \
{-4.020999561537734, -2.6940670968475486`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.188667527474366, 0.5225961012673526, -0.8572107494265772], 
                 
                 
                 ArrowBox[{{-8.089621402504207, 
                  6.7325174618021775`}, {-7.946605280766422, 
                  6.8087584904465475`}, {-7.78911980596681, 
                  6.9121748435697405`}, {-7.620760581494114, 
                  7.056005148117521}, {-7.535251081960354, 
                  7.147824308205942}, {-7.45241951427009, 
                  7.256957128367299}, {-7.404588364458206, 
                  7.3420676145963855`}, {-7.363206535838174, 
                  7.435040401775488}, {-7.298202790689904, 
                  7.633892376581652}, {-7.274306683898782, 
                  7.8508030921272}, {-7.288768693971961, 
                  7.98883807556795}}]}}, {
                Arrowheads[{{0.008207778187782146, 1.}}], {
                 LABColor[
                 0.18866753449666007`, 
                  0.5225961012548136, -0.8572107326436772], 
                 
                 ArrowBox[{{-7.292936705113891, 
                  8.028620328937018}, {-7.297048386951075, 
                  8.067864938188253}, {-7.412040920502395, 
                  8.376332235980628}, {-7.580613237633243, 
                  8.60979228816198}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886724932516941, 0.5225960924005155, -0.8571988814894902], 
                 
                 ArrowBox[{{-1.331608039533375, 
                  0.42424485604281664`}, {-1.186951018269719, 
                  0.49551384643642826`}, {-1.0255055498156236`, 
                  0.5918836909859267}, {-0.9488520094472377, 
                  0.6466409858847828}, {-0.8696671013484817, 
                  0.7106626889211941}, {-0.7889590425456972, 
                  0.7858151266742255}, {-0.7484634140963649, 
                  0.8281361815678978}, {-0.7082861273307512, 
                  0.8740147378283859}, {-0.6516349867735459, 
                  0.9471379676443545}, {-0.5979558471312482, 
                  1.028800921708651}, {-0.5246807545603899, 
                  1.1744138881958828`}, {-0.47151492184702953`, 
                  1.3395257070050364`}, {-0.46707321761358056`, 
                  1.3583872380077253`}, {-0.46296984683060066`, 
                  1.377413512032153}, {-0.45546262405499466`, 
                  1.430701368783263}, {-0.45081438385871275`, 
                  1.4845647771742503`}, {-0.44735254574073247`, 
                  1.5926611783714297`}, {-0.4506145609146056, 
                  1.6358197903091085`}}]}}, {
                Arrowheads[{{0.013735898197341534`, 1.}}], {
                 LABColor[
                 0.1886794862775516, 0.5225960799138459, -0.8571821685389407], 
                 
                 ArrowBox[{{-0.45362924317261877`, 
                  1.675706024662369}, {-0.45548427623875787`, 
                  1.7002493354581922`}, {-0.4746744505517176, 
                  1.8049478060595248`}, {-0.5442156213043622, 
                  2.0071077459784146`}, {-0.6416312164132218, 
                  2.1784247671844716`}, {-0.752510435684334, 
                  2.3175891413344005`}, {-0.9018776252780886, 
                  2.4561882320970616`}, {-1.0434137925791203`, 
                  2.5595364288295563`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866753267431927`, 
                  0.5225961012580675, -0.8572107369989723], 
                 
                 ArrowBox[{{-7.447311588747693, -6.011552678644587}, \
{-7.260390970266564, -5.953311669680553}, {-7.036605147726459, \
-5.864421125539325}, {-6.871093894895825, -5.781868921071094}, \
{-6.684686653961861, -5.663570689999378}, {-6.482881704341421, \
-5.487878800245435}, {-6.3659800578955625`, -5.349557103855268}, \
{-6.261223484253029, -5.17694534251607}, {-6.22379953342981, \
-5.076592380009025}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866755955978354`, 
                  0.5225961012100612, -0.8572106727441785], 
                 
                 ArrowBox[{{-6.209822857687196, -5.039113685592253}, \
{-6.1841441947059845`, -4.970255912783676}, {-6.1609690058792514`, \
-4.856264175634452}, {-6.150892141946879, -4.736296205213358}, \
{-6.162725516163495, -4.616080193853248}, {-6.187610415269833, \
-4.500977857830097}, {-6.257852167606635, -4.285856620855602}, \
{-6.359811101915386, -4.104339317741276}, {-6.476827987802593, \
-3.9584425576565434`}, {-6.67552687756066, -3.7784749215843987`}, \
{-6.810611548532235, -3.689717404835239}}]}}, {
                Arrowheads[{{0.002574577899229788, 1.}}], {
                 LABColor[
                 0.18866754182890275`, 
                  0.5225961012417213, -0.857210715120017], 
                 
                 ArrowBox[{{-6.8440411771339535`, -3.6677524342786647`}, \
{-6.860823384444795, -3.6567256683564726`}, {-7.02609883725149, \
-3.5716522971489373`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866752931062628`, 
                  0.5225961012640737, -0.8572107450380152], 
                 
                 ArrowBox[{{-7.813170288620313, 
                  0.35208943886270144`}, {-7.664039007071689, 
                  0.4116674982031499}, {-7.494152800998028, 
                  0.49278259481127445`}, {-7.3837626449999485`, 
                  0.5569443231795915}, {-7.265589501790796, 
                  0.6377237231619785}, {-7.141260806956467, 
                  0.7408506704924547}, {-7.061035016361764, 
                  0.8205898753955254}, {-6.982010157042964, 
                  0.9141232609866332}, {-6.907385578324088, 
                  1.0231858485455536`}, {-6.872896826181427, 
                  1.0838780757750925`}, {-6.840817290178579, 
                  1.149695369587723}, {-6.813995765884799, 
                  1.2239413100655068`}, {-6.79257785593647, 
                  1.301694124654514}, {-6.764904969156595, 
                  1.447557400715983}}]}}, {
                Arrowheads[{{0.007687971198775956, 1.}}], {
                 LABColor[
                 0.18866754349218118`, 
                  0.5225961012387513, -0.8572107111448721], 
                 ArrowBox[{{-6.761511802622694, 
                  1.4872906650802638`}, {-6.757926270714454, 
                  1.6279490215308068`}, {-6.7804973536332795`, 
                  1.790844496563092}, {-6.88956052862081, 
                  2.0808996508236848`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18893917738892405`, 
                  0.5225956162122718, -0.8565615209407563], 
                 
                 ArrowBox[{{2.6694248311749975`, 5.9294140375122}, {
                  2.890867240765526, 5.83754485684892}, {3.0312015498294467`, 
                  5.764447187970072}, {3.1862710059840236`, 
                  5.6664556848864445`}, {3.354436909030585, 
                  5.530642816432943}, {3.526490907030013, 
                  5.337788845105995}, {3.61456934545568, 5.194099728030379}, {
                  3.6845250195641, 5.025957490743599}, {3.7261296052183, 
                  4.83819240105449}, {3.726257704209922, 
                  4.837187196888891}}]}}, {
                Arrowheads[{{0.011129969316224246`, 1.}}], {
                 LABColor[
                 0.18945344847182688`, 
                  0.5225946979355183, -0.8553324410899579], 
                 
                 ArrowBox[{{3.7313142425606807`, 4.797508091305382}, {
                  3.7385929130430746`, 4.740391717504883}, {
                  3.7414893915394734`, 4.640576335628325}, {
                  3.7238705762095874`, 4.540000086199731}, {
                  3.6974438835815104`, 4.444154760929072}, {
                  3.6307464941617917`, 4.264417752644647}, {
                  3.5422600671711946`, 4.110286651563928}, {3.442632961950406,
                   3.9825507486843272`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1886675429239078, 0.522596101239766, -0.8572107125030145], 
                 
                 
                 ArrowBox[{{-6.789204933423073, 
                  6.754481744465929}, {-6.601122623655653, 
                  6.864914656166288}, {-6.39350383607049, 
                  7.030357065307107}, {-6.26743688649763, 
                  7.165334989862653}, {-6.150524037309637, 
                  7.337508133484137}, {-6.059697824421063, 
                  7.549064382682233}, {-6.02996269252952, 
                  7.668015698998142}, {-6.0143695253605145`, 
                  7.794898674889698}, {-6.018247998785495, 
                  7.89267632951945}, {-6.031269415992385, 
                  7.988357054743396}, {-6.042072773807281, 
                  8.035652499628434}}]}}, {
                Arrowheads[{{0.012019819473447263`, 1.}}], {
                 LABColor[
                 0.18866756605831939`, 
                  0.5225961011984575, -0.8572106572130321], 
                 
                 ArrowBox[{{-6.050980257583709, 
                  8.074648098518214}, {-6.073216802584619, 
                  8.171996284752888}, {-6.142211243564946, 
                  8.336538117252099}, {-6.228562100041471, 
                  8.477520106763164}, {-6.419790896785544, 
                  8.688307119178575}, {-6.604410285469341, 
                  8.831070736881042}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18872325334566095`, 
                  0.5225960017638536, -0.8570775676322787], 
                 
                 ArrowBox[{{1.0849722990861348`, 5.8935738149023775`}, {
                  1.2690692285204677`, 5.807725213309182}, {
                  1.4102439633381425`, 5.728206218181892}, {
                  1.5649849122296045`, 5.6214478563365535`}, {
                  1.729712738530112, 5.473871538093981}, {1.8911025971709716`,
                   5.267244528832672}, {1.9562043383675662`, 
                  5.145755602835649}, {2.0080782109456887`, 
                  5.009255286143486}, {2.0415362400368995`, 
                  4.860684860565737}, {2.0530408726148486`, 
                  4.783911821316757}, {2.0566179345193913`, 
                  4.734324572813279}}]}}, {
                Arrowheads[{{0.011889001649629135`, 1.}}], {
                 LABColor[
                 0.1888149787070528, 0.5225958379800635, -0.8568583490192905], 
                 
                 ArrowBox[{{2.0579051031062225`, 4.6944269688199505`}, {
                  2.054224174018623, 4.6422353774215654`}, {
                  2.0458856407459796`, 4.57981970122514}, {2.022069711965311, 
                  4.457894387755345}, {1.98520679400298, 4.343113564751128}, {
                  1.9379798967200617`, 4.23756098193014}, {
                  1.7968670238914168`, 4.024233829001913}, {
                  1.6438248127726005`, 3.866701904982436}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1886675280489346, 0.5225961012663266, -0.8572107480533895], 
                 
                 ArrowBox[{{-7.995270228762227, 
                  5.5324423228166175`}, {-7.867607039932985, 
                  5.394269197873758}, {-7.750037500940205, 
                  5.217641076884024}, {-7.660494699595854, 
                  5.000778536959669}, {-7.632386468837648, 
                  4.8791829120641435`}, {-7.61923548422603, 
                  4.75198166766898}, {-7.63137330944988, 
                  4.621759278211736}, {-7.658716595770909, 
                  4.49757419623364}, {-7.736638481674, 
                  4.267115409660081}, {-7.844160265056676, 
                  4.085364230386209}}]}}, {
                Arrowheads[{{0.01340386975261475, 1.}}], {
                 LABColor[
                 0.18866752891169847`, 
                  0.5225961012647861, -0.8572107459914309], 
                 
                 ArrowBox[{{-7.868608004832597, 
                  4.053850480454624}, {-7.9775215994303466`, 
                  3.9260047266460023`}, {-8.18814000523125, 
                  3.747023101262759}, {-8.380940315198387, 
                  3.6284842984186594`}, {-8.550817720665492, 
                  3.546725628123474}, {-8.749545059502152, 
                  3.4697582887627334`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18866757158444705`, 0.52259610118859, -0.8572106440058883], 
                 
                 ArrowBox[{{-5.9333225424890506`, -0.3408377435380245}, \
{-5.7845977210912345`, -0.3981550078093366}, {-5.614679117467566, \
-0.4757306166294261}, {-5.465569883423236, -0.5613698532168742}, \
{-5.302507966574316, -0.6789902752299585}, {-5.132038279747236, \
-0.8438271166908514}, {-5.033014339232453, -0.9715337877862849}, \
{-4.945223038747643, -1.125426068988631}, {-4.879243486290073, \
-1.3046948623798023`}, {-4.856059888755956, -1.412463252799033}, \
{-4.8556866995511285`, -1.4160950716436052`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18866766888941192`, 
                  0.5225961010148434, -0.8572104114523272], 
                 
                 ArrowBox[{{-4.851598010183635, -1.4558855556725303`}, \
{-4.844595945139748, -1.5240285551171482`}, {-4.844258787320008, \
-1.5318934068705228`}, {-4.8526301027920296`, -1.6439272242141865`}, \
{-4.8726228479544655`, -1.752169928720658}, {-4.925439259233079, \
-1.940451939323756}, {-5.004930517010155, -2.1056541177808454`}, \
{-5.100012498286329, -2.24448946548516}, {-5.278766303843899, \
-2.4329098232008906`}, {-5.45273689773437, -2.564794321911132}, \
{-5.6118638423274145`, -2.658701353581945}, {-5.694931662973372, \
-2.6964685148421954`}}]}}, {
                Arrowheads[{{0.0010247443294609407`, 1.}}], {
                 LABColor[
                 0.1886675830510348, 0.5225961011681155, -0.8572106166013688], 
                 
                 ArrowBox[{{-5.731344825653155, -2.7130239243404715`}, \
{-5.80597318960085, -2.746954048350994}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.00934145559991326, 1.}}], {
                 LABColor[
                 0.1886675228593505, 0.5225961012755931, -0.8572107604562126], 
                 
                 ArrowBox[{{-9.692728344343779, 
                  1.6332942017600824`}, {-9.713151807893155, 
                  1.747004227972421}, {-9.744589050282881, 
                  1.8544109540452969`}, {-9.80590430510035, 
                  2.0161053613565345`}, {-9.885081542765764, 
                  2.1568109856495985`}, {-9.974119599920831, 
                  2.275760243508629}, {-10., 2.3020751169158737`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.01990787885271093, 1.}}], {
                 LABColor[
                 0.18867355112523979`, 
                  0.5225960905115882, -0.8571963532293898], 
                 
                 ArrowBox[{{-1.1391402487905706`, -5.482653273388398}, \
{-1.0519311648482361`, -5.3828343114447135`}, {-0.969476287176435, \
-5.264561617975032}, {-0.9315326121451944, -5.198027909717538}, \
{-0.8970432394432409, -5.126495662307915}, {-0.8357851180277589, \
-4.940196518156158}, {-0.8102992243891342, -4.737190185174761}, \
{-0.8099509595833886, -4.723152377301732}, {-0.8097997299032471, \
-4.709106171253548}, {-0.8140516567181577, -4.645694440102307}, \
{-0.8221886567619608, -4.58318567127597}, {-0.8456376965980762, \
-4.461034902029968}, {-0.8822135209002783, -4.3459669502821665`}, \
{-0.9292398240438627, -4.240098532681608}, {-1.0620967318530918`, \
-4.035987180553348}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.010782455686228513`, 1.}}], {
                 LABColor[
                 0.18866752255509026`, 
                  0.5225961012761363, -0.857210761183378], 
                 
                 ArrowBox[{{-10., 6.902369038798439}, {-9.879863078552114, 
                  6.993649887439139}, {-9.788662198666895, 
                  7.079600293736321}, {-9.698122156273465, 
                  7.182773756436375}, {-9.639779930777934, 
                  7.271223234417586}, {-9.587834885984732, 
                  7.370037588751433}, {-9.50386275606541, 
                  7.58580805550725}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.1886847639815446, 0.5225960704900361, -0.8571695551141305], 
                 
                 ArrowBox[{{-0.08824482261929847, -5.822775408014057}, {
                  0.0159293695267392, -5.767588834032088}, {
                  0.1279514338209562, -5.6992115464841495`}, {
                  0.2917914543050271, -5.5771898841564305`}, {
                  0.46446037495025033`, -5.404838995202206}, {
                  0.579951554624127, -5.236958357543982}, {
                  0.6709555574760215, -5.030899646950717}, {
                  0.718188362767081, -4.794742460495904}, {
                  0.7233667049006992, -4.732193038989866}, {
                  0.7246320288025648, -4.669113490559185}, {
                  0.7180578114759975, -4.607066868161314}, {
                  0.7106845590262878, -4.563178112491516}}]}}, {
                Arrowheads[{{0.018539208916122048`, 1.}}], {
                 LABColor[
                 0.18870555113020945`, 
                  0.5225960333727335, -0.8571198749621078], 
                 
                 ArrowBox[{{0.7027555024121651, -4.523988905880234}, {
                  0.6807087785922413, -4.427574703723448}, {
                  0.641542008631192, -4.316556577424444}, {
                  0.5929855930015435, -4.214836984208938}, {
                  0.4525612900021406, -4.010822657508123}, {
                  0.3025110670777756, -3.8594725986568403`}, {
                  0.15735154132312357`, -3.747289317309421}, {
                  0.022453453038907487`, -3.6625169287335804`}, \
{-0.14505276307769824`, -3.5751499867703243`}, {-0.2933742892214106, \
-3.5117628973712924`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.1888168422577528, 0.5225958346525279, -0.8568538952347156], 
                 
                 ArrowBox[{{2.07057377338824, -6.62776839392461}, {
                  2.2580394841168765`, -6.703993211175542}, {
                  2.403836389796925, -6.775212575301291}, {
                  2.566600955753407, -6.871862420973337}, {
                  2.7457857563416876`, -7.008306945464808}, {
                  2.9325658019436918`, -7.207075357701287}, {
                  3.0113651241656507`, -7.326097146411254}, {
                  3.078997242703169, -7.463835821222787}, {
                  3.1287412561960055`, -7.618591679139573}, {
                  3.1482641989497857`, -7.699814000236916}, {
                  3.149160515021154, -7.705559082172884}}]}}, {
                Arrowheads[{{0.009537635847548924, 1.}}], {
                 LABColor[
                 0.18910933460890364`, 
                  0.5225953123814231, -0.8561548544617383], 
                 
                 ArrowBox[{{3.1553265043814323`, -7.745080982117205}, {
                  3.1613966623787273`, -7.783988635536263}, {
                  3.158674980250941, -7.881079969132852}, {
                  3.146880777090669, -7.976317845946843}, {
                  3.1073636161229032`, -8.159530811397874}, {
                  3.0405644533570735`, -8.324441619119485}, {
                  2.955928170196265, -8.466296790775523}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.18867210951601174`, 
                  0.5225960930857096, -0.8571997985968504], 
                 
                 ArrowBox[{{-1.41259114187853, 
                  6.7513808199887295`}, {-1.2608354175214178`, 
                  6.837033425105884}, {-1.0943402070552217`, 
                  6.955317157928771}, {-1.0012598262011454`, 
                  7.036034812927694}, {-0.9074247091720249, 
                  7.133408145765966}, {-0.8166482680377688, 
                  7.250543319146831}, {-0.7739377295954311, 
                  7.31727196610488}, {-0.734378792105711, 
                  7.389723886625769}, {-0.698717423962112, 
                  7.468751590037908}, {-0.653277905912553, 
                  7.609069451940372}, {-0.6236446806431929, 
                  7.852732569880069}, {-0.623623447352245, 
                  7.869666108136836}, {-0.6238889540259087, 
                  7.886597941872883}, {-0.6241863658326763, 
                  7.894623959909866}, {-0.6256814882455258, 
                  7.922094500547228}, {-0.6274993595915203, 
                  7.944909709555811}, {-0.6298312635102342, 
                  7.96763045220567}, {-0.6402206916047742, 
                  8.025015104849304}}]}}, {
                Arrowheads[{{0.0067783729647151545`, 1.}}], {
                 LABColor[
                 0.18867737975219187`, 
                  0.5225960836752342, -0.8571872030197057], 
                 
                 ArrowBox[{{-0.6473467969611572, 
                  8.06437521946359}, {-0.6538342260542449, 
                  8.100207688938276}, {-0.693308459545898, 
                  8.224666332098357}, {-0.744879215501425, 
                  8.338334156596305}, {-0.8844990559461903, 
                  8.546276086340606}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19120146448459172`, 
                  0.5225915766974734, -0.8511547781188349], 
                 
                 ArrowBox[{{4.902386029883511, -0.36685473599828283`}, {
                  5.061349039197234, -0.4336922593714717}, {
                  5.243718272754528, -0.526469880034597}, {
                  5.375077967668169, -0.6109036049202459}, {
                  5.515216350411432, -0.7220231946761786}, {
                  5.6583799053371155`, -0.8698709363480487}, {
                  5.755865716179326, -1.0034543308411152`}, {
                  5.839912913444909, -1.1635484083409025`}, {
                  5.899566895248331, -1.3480816830722615`}, {
                  5.924112251955272, -1.455853210710121}, {
                  5.927769592788887, -1.4871254091120811`}}]}}, {
                Arrowheads[{{0.01865631966045815, 1.}}], {
                 LABColor[
                 0.19576839808899385`, 
                  0.5225834220313775, -0.8402400557871382], 
                 
                 ArrowBox[{{5.932415997773779, -1.5268546290983376`}, {
                  5.93727614878956, -1.5684114906935285`}, {
                  5.924627215589468, -1.6810951655121364`}, {
                  5.900533058470902, -1.789084838359102}, {
                  5.839779435449382, -1.978418941278397}, {
                  5.753421843290069, -2.1421312747715877`}, {
                  5.653193735455251, -2.2780488714034948`}, {
                  5.464071488462735, -2.4648559337565854`}, {
                  5.283550005188448, -2.593265649269479}, {
                  5.1204778385950664`, -2.683673118779915}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868375377844632`, 
                  0.5225960722938435, -0.8571719694444606], 
                 
                 ArrowBox[{{-0.1485351082461066, 
                  0.7059400279347287}, {-0.04353918980554795, 
                  0.804487942877764}, {0.08545566171197555, 
                  0.9599235133302999}, {0.16820405054252063`, 
                  1.0984984095045556`}, {0.23404982545410055`, 
                  1.2591518916112525`}, {0.27405402560632863`, 
                  1.4375927930440249`}, {0.2792288331526491, 
                  1.476195180778428}, {0.2829292434367211, 
                  1.5151699263099483`}, {0.2831962996709707, 
                  1.5653481564337794`}, {0.28095943120686434`, 
                  1.615364030401347}, {0.27162148664734104`, 
                  1.7144683992051495`}, {0.2529478074630661, 
                  1.8108427533242728`}, {0.22592696080259875`, 
                  1.9029239635271162`}, {0.14146762404183444`, 
                  2.0892029591666708`}, {0.10800294505325483`, 
                  2.138481728676557}}]}}, {
                Arrowheads[{{0.0010764269252299282`, 1.}}], {
                 LABColor[
                 0.18868806889609865`, 
                  0.5225960645888172, -0.8571616565485256], 
                 
                 ArrowBox[{{0.08553115861117774, 2.1715727971709655`}, {
                  0.03715268664264054, 2.2428130313949857`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19193883321273472`, 
                  0.5225902600600338, -0.8493925070588835], 
                 
                 ArrowBox[{{5.157373690582065, 0.3204466180406419}, {
                  5.299208277403755, 0.3713818759140008}, {5.460478313430218, 
                  0.44021250097679004`}, {5.645656511698505, 
                  0.5363114444592422}, {5.772051416780483, 
                  0.619157473596324}, {5.906256986605578, 
                  0.7269604825308419}, {6.0430336463992065`, 
                  0.8686022862514722}, {6.140745602397471, 
                  1.002134208035403}, {6.225068058170884, 
                  1.162247733624908}, {6.285011407272662, 
                  1.3469067442457066`}, {6.286034873499723, 
                  1.3513763317675285`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.1988676189524475, 0.5225778880969066, -0.8328330868886652], 
                 
                 ArrowBox[{{6.294963170891975, 1.3903671705078724`}, {
                  6.309664253891257, 1.4545683873077058`}, {6.322963724207643,
                   1.5670368139378883`}, {6.310476975972659, 
                  1.6796971843332655`}, {6.286537470949118, 
                  1.7876975538273387`}, {6.228276043159429, 
                  1.9716883688304838`}, {6.145536649280167, 
                  2.1317389018325614`}, {6.049114869793719, 
                  2.2656065968172117`}, {5.857427522361644, 
                  2.4586791134072405`}, {5.673762150325112, 
                  2.5906371695296424`}, {5.533491162920691, 
                  2.6687327283737448`}}]}}, {
                Arrowheads[{{0.002474042213587957, 1.}}], {
                 LABColor[
                 0.19327313641052432`, 
                  0.5225878775430123, -0.8462035951605081], 
                 
                 ArrowBox[{{5.4980567630440405`, 2.6872018083952742`}, {
                  5.316192256675265, 2.765297675896564}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18867649607315742`, 
                  0.5225960852531217, -0.8571893149644211], 
                 ArrowBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA9VaH6zC5579HzfOlKW0bwFMWqufG
n+S/WSI010uyG8D1+6zcomThv5sXk7mhBhzAsF8JU3LJ3r9tAY50rkIcwIyh
Oa7Oydq/p6YDOryGHMDClW1buV/Vv/EMdxv29BzAyN386Kls0L9AXmQYj3Yd
wP97ckyAWse/yV8UrZosHsAFI4VstHrBv3DD0zeLKR/AhPaATItBwb/FUvSW
qkUfwG3mvFcPIcG/q2IHZ+BhH8DU03B3+h/Bv3DKPyahah/AXg3I7jonwb92
0pSGBYAfwJqC/G83OsG//6Wy+XOTH8BbIhgA91jBv7BgqeHaph/A63BFXOs/
wr8ynctbIfIfwF0fbWVi0cO/VEIcAPwdIMDAlzP3LgHGv4XBsoLWQSDAJ2DG
lWdryr8ti+tDHXQgwP4pokI=
                  "]]}}, {
                Arrowheads[{{0.003075991780654113, 1.}}], {
                 LABColor[
                 0.18868262991354048`, 
                  0.5225960743006043, -0.857174655420314], 
                 
                 ArrowBox[{{-0.22043596499498316`, -8.264197518963549}, \
{-0.275328748734857, -8.374820326654318}, {-0.3415403067847846, \
-8.477986888331525}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.18869731571740528`, 
                  0.5225960480777955, -0.8571395571497266], 
                 
                 ArrowBox[{{0.4586326529610358, 7.038969493596726}, {
                  0.5235977668446665, 7.1044854928206345`}, {
                  0.5878135923827441, 7.179050270081559}, {0.6495975221103335,
                   7.263674734440905}, {0.7517426612509436, 
                  7.4560774614822005`}, {0.8170244292223215, 
                  7.6830019753852925`}, {0.8287543397927185, 
                  7.927874605919162}, {0.82359303314852, 7.997905584242736}, {
                  0.8135926768571752, 8.06704995038585}, {0.7925607774815713, 
                  8.138800824632561}, {0.767326096328901, 
                  8.207198453421686}, {0.7101340548563416, 
                  8.336607916385018}, {0.64202088487383, 8.450844065657156}, {
                  0.6160747651826196, 8.485372104011136}}]}}, {
                Arrowheads[{{0.010505547352172575`, 1.}}], {
                 LABColor[
                 0.18870159052151114`, 
                  0.5225960404447525, -0.8571293406009699], 
                 ArrowBox[{{0.5920450852117881, 8.51734982251167}, {
                  0.5675766178992211, 8.549911461318786}, {
                  0.41344596835486536`, 8.70576164826567}, {
                  0.2650319045664948, 8.820514731508112}, {
                  0.12732700836895805`, 8.9065841276964}, {
                  0.0013173700183388454`, 
                  8.972761876349937}, {-0.0786942790816665, 
                  9.009866810879757}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.18866752382645813`, 
                  0.5225961012738661, -0.857210758144878], 
                 
                 ArrowBox[{{-9.087085169834197, -6.031654701743758}, \
{-8.899894571102061, -5.977926532864315}, {-8.674640849077267, \
-5.895769726958452}, {-8.504647051670121, -5.818103413734788}, \
{-8.310444763092836, -5.7053474868098535`}, {-8.09518713200412, \
-5.533920485035071}, {-7.966890108138848, -5.395414544179126}, \
{-7.848694138973365, -5.218135152653797}, {-7.819319214899113, \
-5.146978777326358}}]}}, {
                Arrowheads[{{0.013725187190941499`, 1.}}], {
                 LABColor[
                 0.18866752938792636`, 
                  0.5225961012639356, -0.8572107448532722], 
                 
                 ArrowBox[{{-7.804055801284005, -5.110005432808798}, \
{-7.758748085853275, -5.000254245154032}, {-7.730603480897682, \
-4.878037218071292}, {-7.717576798753898, -4.750245221773774}, \
{-7.730061051078296, -4.619518196369058}, {-7.757832700288667, \
-4.494952465287698}, {-7.836655886944339, -4.263976394218696}, \
{-7.950496361574744, -4.072911497708975}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.008267212644180644, 1.}}], {
                 LABColor[
                 0.1886675225541274, 0.522596101276138, -0.8572107611856792], 
                 
                 
                 ArrowBox[{{-10., 5.543564947465489}, {-9.934601068716047, 
                  5.4841520575264395`}, {-9.861184830896333, 
                  5.401947202123237}, {-9.790396347706197, 
                  5.306928321113704}, {-9.749163439957657, 
                  5.235428160767632}, {-9.712242690154202, 
                  5.158147436320387}, {-9.650092395977362, 
                  4.993346418170019}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.19335085036716243`, 
                  0.5225877387778315, -0.8460178630409991], 
                 
                 ArrowBox[{{5.5158817340953, -5.882618653621102}, {
                  5.679997264411783, -5.80500953675999}, {
                  5.86591614548886, -5.6940428982833735`}, {
                  6.0702640096590255`, -5.528786605051656}, {
                  6.192145443113381, -5.396871178505182}, {
                  6.305242913992744, -5.229956952317772}, {
                  6.394171336146879, -5.026140587035148}, {
                  6.430305719434967, -4.915224424456352}, {
                  6.454879846784504, -4.796753257308139}, {
                  6.4508403591619015`, -4.698943850819788}}]}}, {
                Arrowheads[{{0.017893079862538352`, 1.}}], {
                 LABColor[
                 0.20055475288615443`, 
                  0.5225748755692283, -0.8288009287672851], 
                 
                 ArrowBox[{{6.447515108983055, -4.659147762695231}, {
                  6.43033464214888, -4.553272760486312}, {
                  6.368196036706355, -4.327757544342621}, {
                  6.269216294945569, -4.135341120852051}, {
                  6.151534228857693, -3.980259090139795}, {
                  5.9556948747958565`, -3.7956926483761553`}, {
                  5.7712537501792545`, -3.670312717832944}, {
                  5.6059940628875875`, -3.5826304285816426`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6351198076026503, 0.537383644426187, 0.6905173028220535], 
                 
                 ArrowBox[{{10., -4.053377315230891}, {
                  9.846914406002693, -3.8700943780287442`}, {
                  9.572594905655325, -3.666605430838601}, {
                  9.336987174196873, -3.5466748839441715`}, {
                  9.229547647866285, -3.5007619580591114`}, {
                  9.131272233171071, -3.463958367867619}, {
                  9.047549500039088, -3.4383058544812317`}, {
                  8.96960315491219, -3.4162999102712526`}, {
                  8.823638966497736, -3.3779239878994027`}, {
                  8.695398369700117, -3.348897252842777}, {
                  8.614466277807347, -3.332788825364743}}]}}, {
                Arrowheads[{{0.010658162704550918`, 1.}}], {
                 LABColor[
                 0.28851539043242047`, 
                  0.5224178140283983, -0.6185798005224856], 
                 
                 ArrowBox[{{8.575202491997485, -3.3251622197268675`}, {
                  8.337302413162407, -3.2852715286361653`}, {
                  8.141130189575735, -3.2593911141213208`}, {
                  7.977026518976401, -3.2414148922368438`}, {
                  7.729549953034211, -3.2191692131172185`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.23666244058101063`, 
                  0.5225104020817302, -0.7425055237171456], 
                 
                 ArrowBox[{{7.843669086439685, -6.058889878372437}, {
                  8.03336104311415, -6.0105824766564115`}, {
                  8.26356182667626, -5.936089906741028}, {
                  8.431163643160321, -5.868636835717297}, {
                  8.624739391292342, -5.771105839874898}, {
                  8.8455877776863, -5.621874518558539}, {
                  8.976128392527428, -5.506708123160728}, {
                  9.105814361308564, -5.357059703308781}, {
                  9.171126214354155, -5.249037664849245}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.37355722488713783`, 
                  0.5222659642700623, -0.41533445253743084`], 
                 
                 ArrowBox[{{9.191822106579046, -5.214807852623414}, {
                  9.221238465599704, -5.166154891219137}, {
                  9.273201889320092, -5.059780941396602}, {
                  9.315816218686688, -4.942579002162967}, {
                  9.32779094867546, -4.797457487300725}, {
                  9.318885487781436, -4.653602490553157}, {
                  9.274886834574653, -4.410276567573027}, {
                  9.184096091956208, -4.197180513110601}, {
                  9.066609805505285, -4.0238269324440195`}, {
                  8.855234746356821, -3.811343641065127}, {
                  8.836942603768335, -3.798636907769219}}]}}, {
                Arrowheads[{{0.0022811238980026773`, 1.}}], {
                 LABColor[
                 0.315022234653747, 0.5223704837007417, -0.5552298879495412], 
                 
                 
                 ArrowBox[{{8.804091050361041, -3.7758164029823438`}, {
                  8.65421412323327, -3.671703605314691}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.25170931395316487`, 
                  0.5224835345511798, -0.7065443166921612], 
                 
                 ArrowBox[{{8.115901718420513, -0.16741219667710666`}, {
                  8.225500114094016, -0.18699816848254086`}, {
                  8.348045002710476, -0.21168991621437871`}, {
                  8.486798891633322, -0.24372164104030195`}, {
                  8.646310434977194, -0.2867546554534809}, {
                  8.766083160579006, -0.32443393495297057`}, {
                  8.900051166611325, -0.37297493553827293`}, {
                  9.051189368801852, -0.43744055167538637`}, {
                  9.222826983999154, -0.5258299995779787}, {
                  9.308430597506838, -0.5787100810466711}, {
                  9.398366643318834, -0.6417860958793791}, {
                  9.491884383673828, -0.7176548714728784}, {
                  9.562249970856778, -0.7883207606383658}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4730067009994684, 
                  0.5268200702799727, -0.03170062916905934], 
                 
                 ArrowBox[{{9.590473951687358, -0.816665194061439}, {
                  9.62155847724885, -0.8478823802746223}, {
                  9.744604791168175, -1.0157070755241893`}, {
                  9.84415860460156, -1.224966335613929}, {
                  9.898775464912875, -1.4683389676871803`}, {
                  9.892719575320651, -1.7236916184626168`}, {
                  9.827502145890909, -1.9620654621766744`}, {
                  9.729603221032503, -2.1500296240434067`}, {
                  9.637414779688212, -2.271129758565009}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.4795545692646487, 
                  0.5272467408519468, -0.0025297127853256642`], 
                 
                 ArrowBox[{{9.613046209048205, -2.302834491127208}, {
                  9.493691777651247, -2.4216703516526383`}, {
                  9.433570766427868, -2.4743489365120266`}, {
                  9.374431813374533, -2.5209023007860227`}, {
                  9.29672248645813, -2.570884159488184}, {
                  9.222609031373057, -2.614126481953095}, {
                  9.081442739636774, -2.6898839627128956`}, {
                  8.953820431792524, -2.747565647129047}, {
                  8.838335895736371, -2.792699992438252}, {
                  8.633182614826998, -2.8602471150611475`}, {
                  8.460595183963743, -2.9060849905323347`}, {
                  8.312276974446728, -2.939206224033338}, {
                  8.187022071751791, -2.9624375187310203`}}]}}, {
                Arrowheads[{{0.0030705554625419895`, 1.}}], {
                 LABColor[
                 0.2540276691682532, 0.5224793949217679, -0.7010035741215798], 
                 
                 ArrowBox[{{8.14769281371028, -2.9697320003372916`}, {
                  8.088400734895998, -2.9807290290087165`}, {
                  7.905078614728053, -3.008011729530657}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19614776775477738`, 
                  0.5225827446331012, -0.8393333829686185], 
                 
                 ArrowBox[{{5.9846451628738215`, -6.0190246421033615`}, {
                  6.171405588281967, -5.962556173946186}, {
                  6.3953801962810255`, -5.876370934662707}, {
                  6.5634740397866125`, -5.795185805525864}, {
                  6.753930272563907, -5.678009550006597}, {
                  6.96188911975427, -5.5020266413708185`}, {
                  7.087718769918979, -5.355992457686746}, {
                  7.199955068833113, -5.170745575486623}, {
                  7.224407885166962, -5.1021458867030915`}}]}}, {
                Arrowheads[{{0.019168321759203716`, 1.}}], {
                 LABColor[
                 0.21487032908079004`, 
                  0.522549313834824, -0.7945874821272721], 
                 
                 ArrowBox[{{7.237838409017341, -5.0644680280974805`}, {
                  7.279745071283462, -4.9469034927832825`}, {
                  7.3088304914436755`, -4.826084161792037}, {
                  7.32362921528104, -4.698916780011483}, {
                  7.305708925942474, -4.573051183774913}, {
                  7.274073088755401, -4.4540854587341}, {
                  7.190410570921473, -4.234443373756994}, {
                  7.076533935250268, -4.053682289763912}, {
                  6.950631647595828, -3.9114588679492}, {
                  6.744855269134611, -3.7405393285172406`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.2200979079616561, 0.5225399795278345, -0.782093853602282], 
                 
                 
                 ArrowBox[{{7.419494889153708, -6.637832553051503}, {
                  7.648013732393254, -6.736688068603214}, {
                  7.825513884377826, -6.835125160674304}, {
                  8.023259064867197, -6.979837275742289}, {
                  8.227457519757118, -7.1973799873934015`}, {
                  8.317437345151669, -7.333164308521531}, {
                  8.392257132205048, -7.493169928860291}, {
                  8.442026912004904, -7.6741772732393985`}, {
                  8.455931880359419, -7.750307861848372}}]}}, {
                Arrowheads[{{0.013643125711182813`, 1.}}], {
                 LABColor[
                 0.27769678925629776`, 
                  0.522437131602915, -0.6444356675184334], 
                 
                 ArrowBox[{{8.461162391947106, -7.7899190769492}, {
                  8.467799609170703, -7.867121670526984}, {
                  8.45688769678677, -7.964557431070719}, {
                  8.437275806407976, -8.058653124943337}, {
                  8.383617691856458, -8.23726732961456}, {
                  8.306229818684143, -8.394146364381005}, {
                  8.214921531119655, -8.526746557882248}, {
                  8.008281118505039, -8.740595896047976}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.018451129493772256`, 1.}}], {
                 LABColor[
                 0.6357186990202223, 0.537422669240575, 0.6931853790198951], 
                 
                 ArrowBox[{{10., -9.651896163280187}, {
                  9.754951633483618, -9.597426020821887}, {
                  9.601967095845737, -9.570961077809017}, {
                  9.470025860420618, -9.551637086580069}, {
                  9.365172491640958, -9.539503821602798}, {
                  9.269780553363084, -9.52945028040251}, {
                  9.094314670653612, -9.512374880307402}, {
                  8.945191703001013, -9.500147067209477}, {
                  8.815447590986201, -9.490923743820522}, {
                  8.536937160509224, -9.474530920145765}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18870921345426703`, 
                  0.5225960268333282, -0.8571111222072749], 
                 
                 ArrowBox[{{0.7947388930520856, 0.39107437342482165`}, {
                  0.9224773029624578, 0.4478421893945613}, {
                  1.0641596492903835`, 0.5221154617956232}, {
                  1.221426279842767, 0.6216215295335784}, {
                  1.3478411487301363`, 0.7229157517574554}, {
                  1.4768999940887886`, 0.8539698042569333}, {
                  1.599036364573105, 1.0225192993380363`}, {
                  1.6597875077954958`, 1.1365954909210685`}, {
                  1.7089896745185962`, 1.2638822809781554`}, {
                  1.742335126510337, 1.4020513115213944`}, {
                  1.7545234535568495`, 1.4734401591979591`}, {
                  1.7616786425863633`, 1.5464058172774025`}, {
                  1.7613586270847459`, 1.552883764108943}}]}}, {
                Arrowheads[{{0.018320473697052315`, 1.}}], {
                 LABColor[
                 0.18877692186729642`, 
                  0.5225959059339353, -0.8569493027915026], 
                 
                 ArrowBox[{{1.7593850034372607`, 1.5928350445602388`}, {
                  1.7580550438444205`, 1.6197568889301868`}, {
                  1.7492264484633242`, 1.692008347039093}, {
                  1.7220634679612725`, 1.8326841017846627`}, {
                  1.677790706088569, 1.9637195002465868`}, {
                  1.6205390201454188`, 2.082154284155159}, {
                  1.4917106630488686`, 2.2676137660322646`}, {
                  1.3546643929654085`, 2.408808055265493}, {
                  1.2208436256919795`, 2.5161477352327566`}, {
                  1.0950895868720807`, 2.598922111410146}, {
                  0.9114157206917681, 2.6966967015590253`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.20267708407808582`, 
                  0.5225710859581425, -0.8237286729250934], 
                 
                 ArrowBox[{{6.6130348833581145`, 6.329847253908752}, {
                  6.8140732081791375`, 6.340306619215809}, {7.06697433607141, 
                  6.35707942931404}, {7.234438371031953, 6.370653450487776}, {
                  7.435678139101113, 6.3903324628972955`}, {7.688242803620698,
                   6.4218739538036935`}, {7.8600457799962244`, 
                  6.4482323353072095`}, {8.066746884177807, 
                  6.486891954737911}, {8.199286186005386, 
                  6.519093520169487}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.26039936752922666`, 
                  0.5224680176876983, -0.6857755624149248], 
                 
                 ArrowBox[{{8.23815542945357, 6.528537137790175}, {
                  8.32545625285268, 6.54974762508076}, {8.44507535973705, 
                  6.58478395676959}, {8.579201561228384, 6.63005281657727}, {
                  8.730963839682776, 6.690621932187464}, {8.811678963653792, 
                  6.725527988551935}, {8.897792830637343, 
                  6.766416949613105}, {8.996029097614354, 
                  6.825430270412376}, {9.100012741068168, 
                  6.898690996925557}, {9.313736727723983, 
                  7.085244362143968}, {9.513142401934516, 
                  7.369701909550196}, {9.519775563708365, 
                  7.3931908986783155`}}]}}, {
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.45572577745134946`, 
                  0.5256940150149751, -0.10868757445269288`], 
                 
                 ArrowBox[{{9.530646208831703, 7.431685431726561}, {
                  9.621748170276778, 7.754290707293735}, {9.579442480781266, 
                  8.160847431129705}, {9.41551347186397, 8.49447102668868}, {
                  9.204559965216378, 8.726502465521094}, {9.066221615951562, 
                  8.8265276827451}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.34802125984638177`, 
                  0.5223115610065999, -0.47636401679978496`], 
                 
                 ArrowBox[{{9.033807150966204, 8.849964885217089}, {
                  8.973868735499268, 8.893303215181302}, {8.770982842202608, 
                  8.999575968318402}, {8.596140212844968, 9.07166206434349}, {
                  8.344019600318616, 9.153969491021238}, {8.13978590192968, 
                  9.205214530129533}, {7.969018915917704, 9.24029306451649}, {
                  7.708439310854984, 9.283606555871607}, {7.516410798586951, 
                  9.308328279761657}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868545407474677`, 
                  0.5225960692578133, -0.8571679058290003], 
                 
                 ArrowBox[{{-0.04902849131724806, -0.30627363291927223`}, {
                  0.026056221342814243`, -0.33102004973791294`}, {
                  0.10644886719554543`, -0.35995097144154964`}, {
                  0.25786311026425685`, -0.4220203482328166}, {
                  0.4302294132194798, -0.5076794007805404}, {
                  0.5464964403232154, -0.5775669182457599}, {
                  0.6710812104480933, -0.6664603621377669}, {
                  0.8018087881477682, -0.7814053486264911}, {
                  0.9331243523604806, -0.9314691093208335}, {
                  1.021486223205787, -1.0704486061088532`}, {
                  1.093406048992156, -1.2334659283173095`}, {
                  1.1113428994147425`, -1.3056002064602468`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1887253047224435, 0.5225959981009378, -0.8570726649536066], 
                 
                 ArrowBox[{{1.1209953304709979`, -1.3444181221011495`}, {
                  1.1389453473644977`, -1.4166053501128004`}, {
                  1.150381090191984, -1.4899937641907641`}, {
                  1.156477541326051, -1.56488097670059}, {
                  1.1526102026111158`, -1.629914684970617}, {
                  1.1446477313590158`, -1.69405087491943}, {
                  1.1211571000970284`, -1.8193761608707308`}, {
                  1.0838386125527886`, -1.9373439305621325`}, {
                  1.035556254139794, -2.0456660198713474`}, {
                  0.9137173563921343, -2.234946125011011}, {
                  0.7806706738093443, -2.3807015001802463`}, {
                  0.6489079108541795, -2.4921671080482675`}, {
                  0.5241070813863566, -2.5783482409689866`}, {
                  0.4108569258379374, -2.6419598309181667`}}]}}, {
                Arrowheads[{{0.00030717042124814954`, 1.}}], {
                 LABColor[
                 0.1886949887476517, 0.5225960522328069, -0.8571451184805745], 
                 
                 ArrowBox[{{0.37598185471913903`, -2.661548843513465}, {
                  0.354556674145898, -2.673583174014931}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.24777443925659717`, 0.5224905606198857, -0.7159484526931], 
                 
                 
                 ArrowBox[{{8.04820545353714, 6.979815851830056}, {
                  8.252553517700521, 7.197561722617084}, {8.342521184525811, 
                  7.333387678722727}, {8.417313177035417, 
                  7.493435772961021}, {8.467037754709501, 7.67447801057526}, {
                  8.484363948718833, 7.769501407751298}, {8.492753335711603, 
                  7.867446077133219}, {8.481810061601111, 7.96487883603379}, {
                  8.46216921746528, 8.058966178470927}, {8.408460257342231, 
                  8.237556019932983}, {8.331036827447171, 
                  8.394400174606508}, {8.317648795837773, 
                  8.41383280541636}}]}}, {
                Arrowheads[{{0.004937264813664559, 1.}}], {
                 LABColor[
                 0.2641505158050093, 0.5224613196788559, -0.676810522543155], 
                 
                 
                 ArrowBox[{{8.294955312540427, 8.446772231881209}, {
                  8.239708013028407, 8.52696328654713}, {8.032855553656043, 
                  8.740922418830259}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.2549703541623161, 0.5224777116738765, -0.6987506083796351], 
                 
                 ArrowBox[{{8.166772832617148, 6.121807651047632}, {
                  8.33582955154551, 6.091571121541192}, {8.538127150783605, 
                  6.0475241739983}, {8.78874219579355, 5.976943471315458}, {
                  8.904306088558895, 5.937775931694769}, {9.03277951023868, 
                  5.8876715217808835`}, {9.176354853153656, 
                  5.821620557616007}, {9.252194572066571, 
                  5.783833932067777}, {9.332397475916961, 
                  5.739997149828589}, {9.421550388614865, 
                  5.6785383113464105`}, {9.514111703725538, 
                  5.604025752008512}, {9.613534243486475, 
                  5.505948505868681}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.49039029093566794`, 0.527952815466751, 
                  0.04574369743332244], 
                 
                 ArrowBox[{{9.642010515844309, 5.477857548024518}, {
                  9.69986349482262, 5.420787381915084}, {9.865953904312784, 
                  5.159171820289766}, {9.957942769279072, 
                  4.822258499994051}, {9.94025680950616, 4.497612984846335}, {
                  9.835038963915856, 4.209539693643891}, {9.705850835505519, 
                  4.021925982991776}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5031263568546788, 0.5287827198433037, 
                  0.10248318865932034`], 
                 
                 ArrowBox[{{9.683165399210305, 3.9889810140269133`}, {
                  9.68093469582141, 3.985741470693446}, {9.464553259786804, 
                  3.782080480102199}, {9.262465330958626, 
                  3.6494109721480372`}, {9.084210891383288, 
                  3.559763201681037}, {8.885102639279046, 
                  3.4832595678141756`}, {8.715896964050435, 
                  3.4285623590132843`}, {8.569298370071467, 
                  3.388552665816372}, {8.440327807933079, 
                  3.358216762732126}, {8.261496100784534, 
                  3.324055090282474}}]}}, {
                Arrowheads[{{0.009906751334850066, 1.}}], {
                 LABColor[
                 0.2590152637239732, 0.5224704891281333, -0.6890834950500793], 
                 
                 ArrowBox[{{8.222206540976762, 3.316549726193268}, {
                  8.195833338390734, 3.3115117342031573`}, {7.998024635405041,
                   3.280874731506352}, {7.832259272721072, 
                  3.259502820803218}, {7.689777079224095, 
                  3.243818258275654}, {7.435732132629485, 
                  3.2212825973361596`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18872528176093228`, 
                  0.5225959981419377, -0.8570727198303665], 
                 
                 ArrowBox[{{1.1207492594876383`, -0.40641165305392335`}, {
                  1.2501725808038764`, -0.4665650410224487}, {
                  1.3934665614454407`, -0.5455368059401845}, {
                  1.551898639457246, -0.6517593562909682}, {
                  1.6784957234715971`, -0.7605156668087795}, {
                  1.8054235906594738`, -0.9009120225331317}, {
                  1.921342825157915, -1.0798868991336563`}, {
                  1.9789111397094103`, -1.2069701970423183`}, {
                  2.0211024856323294`, -1.3473132369956522`}, {
                  2.043413347293598, -1.4969442349618778`}, {
                  2.0491074771629036`, -1.5734355528211628`}, {
                  2.0490650098285177`, -1.5929061353266014`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1888136706309351, 0.5225958403157497, -0.8568614752498973], 
                 
                 ArrowBox[{{2.0489777659397195`, -1.6329060401827866`}, {
                  2.0489392072950694`, -1.6505845519803333`}, {
                  2.0370403414617297`, -1.7262807772051718`}, {
                  2.0199277452215574`, -1.7996306573415919`}, {
                  1.9767691157099279`, -1.9402660045789615`}, {
                  1.9183101975566068`, -2.067394688228108}, {
                  1.8495777837300875`, -2.179376906147255}, {
                  1.70685669247326, -2.3494029463937216`}, {
                  1.5635754638448356`, -2.476420508032281}, {
                  1.427703679216167, -2.5722676914669425`}, {
                  1.3019273783681404`, -2.6460834907020145`}, {
                  1.1076249237401379`, -2.738583928291478}, {
                  1.0412232821258998`, -2.7642118970679874`}}]}}, {
                Arrowheads[{{0.0027729954309753313`, 1.}}], {
                 LABColor[
                 0.1887190724034419, 0.5225960092292977, -0.857087559856243], 
                 
                 
                 ArrowBox[{{1.0039062181678902`, -2.778614561319918}, {
                  0.9401732576419816, -2.803212542374083}, {
                  0.7941289837261153, -2.850550235017541}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.28476663351182957`, 
                  0.5224245077672633, -0.6275391251857204], 
                 
                 ArrowBox[{{8.534537408498414, 5.712278219745259}, {
                  8.754849263215908, 5.538830705767288}, {8.890595930533884, 
                  5.39233269915534}, {9.014459378045148, 5.202362559173806}, {
                  9.104876512481207, 4.967774428638266}, {9.13867488778696, 
                  4.839397529422211}, {9.156447721417573, 
                  4.703117649866978}, {9.136544556074776, 
                  4.568348251505196}, {9.101180076213748, 
                  4.441803398824938}, {9.062505135616751, 
                  4.345391491932497}}]}}, {
                Arrowheads[{{0.006603729548407848, 1.}}], {
                 LABColor[
                 0.3487734987635997, 0.5223102178171153, -0.4745662067986464], 
                 
                 ArrowBox[{{9.047612942371185, 4.308267071663128}, {
                  9.008256530913313, 4.210156341083448}, {8.883467094259423, 
                  4.02322512087373}, {8.747831212845067, 
                  3.879210865590595}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.014795875795053273`, 1.}}], {
                 LABColor[
                 0.6303961733487051, 0.5370758441395435, 0.6694733944432126], 
                 
                 
                 ArrowBox[{{10., 3.0947048691095076`}, {9.901346941022858, 
                  3.0995943833166546`}, {9.764248376404586, 
                  3.105322636938572}, {9.656510263702714, 
                  3.1088658711628026`}, {9.558825230896073, 
                  3.1117881780675134`}, {9.37958987473574, 
                  3.116734786923869}, {9.227957313344929, 
                  3.1202523741285706`}, {9.096417463543807, 
                  3.1228939888618785`}, {8.816846748922575, 
                  3.127539158411131}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.18868445634912337`, 
                  0.5225960710393411, -0.8571702903388455], 
                 
                 ArrowBox[{{-0.1062496470923474, -0.6351126285099552}, \
{-0.027575826460302422`, -0.6968111343870506}, {
                  0.10152393860754039`, -0.81825793855928}, {
                  0.2284411306146705, -0.9760133429540552}, {
                  0.3118908037550877, -1.122421714939656}, {
                  0.3757941315036863, -1.2919167344962863`}, {
                  0.41052293849481153`, -1.4788193445002975`}, {
                  0.41456671292952785`, -1.522620268004333}, {
                  0.41669743787244024`, -1.5667347575473807`}, {
                  0.4140972643575128, -1.6196996108198256`}, {
                  0.40875178423990505`, -1.6721727567130398`}, {
                  0.39285585373078585`, -1.7754754813291544`}, {
                  0.36717216718634493`, -1.8745852839578163`}, {
                  0.3331247708612804, -1.967963519247277}, {
                  0.29514875770090293`, -2.038735177626257}}]}}, {
                Arrowheads[{{0.013580546870308342`, 1.}}], {
                 LABColor[
                 0.1886923807595043, 0.5225960568896016, -0.8571513514300629], 
                 
                 ArrowBox[{{0.2762356717299822, -2.073981385635865}, {
                  0.23211767382893775`, -2.1561991756558805`}, {
                  0.1146363815441279, -2.3067490116830953`}, \
{-0.006499332900378858, -2.424976120618166}, {-0.12427687711124907`, \
-2.517947578324953}, {-0.27912257065217766`, -2.617890349136754}, \
{-0.41978747796243304`, -2.6923319422764216`}, {-0.5470386526865755, \
-2.7492698297269884`}}]}}}}}}}, {
          DisplayFunction -> Identity, DisplayFunction -> Identity, 
           PlotRange -> {{-10., 10.}, {-10., 10.}}, DisplayFunction -> 
           Identity, AspectRatio -> 1, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 200, 
           Method -> {
            "VectorLengthFunction" -> 
             Function[{
               System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
               System`VectorPlotsDump`min = 
                Min[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`max = 
                Max[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`imin = If[
                  NumericQ[System`VectorPlotsDump`min], 
                  System`VectorPlotsDump`min, 
                  Min[System`VectorPlotsDump`m], 
                  Min[System`VectorPlotsDump`m]]; 
               System`VectorPlotsDump`imax = If[
                  NumericQ[System`VectorPlotsDump`max], 
                  System`VectorPlotsDump`max, 
                  Max[System`VectorPlotsDump`m], 
                  Max[System`VectorPlotsDump`m]]; Map[If[
                  
                  Or[# > System`VectorPlotsDump`imax, # < 
                   System`VectorPlotsDump`imin], #, 
                  System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
             "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.05], 
              Scaled[0.05]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
           Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
           AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic,
            BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
           Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, 
           FormatType :> TraditionalForm, FrameLabel -> None, 
           FrameStyle -> {}, FrameTicksStyle -> {}, GridLines -> None, 
           ImageMargins -> 0., ImagePadding -> All, ImageSizeRaw -> Automatic,
            LabelStyle -> {}, PlotLabel -> None, PlotRegion -> Automatic, 
           PreserveImageOptions -> Automatic, Prolog -> {}, RotateLabel -> 
           True, TicksStyle -> {}, DisplayFunction -> Identity, AspectRatio -> 
           1, DisplayFunction :> Identity, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> 200, 
           Method -> {
            "VectorLengthFunction" -> 
             Function[{
               System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
               System`VectorPlotsDump`min = 
                Min[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`max = 
                Max[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`imin = If[
                  NumericQ[System`VectorPlotsDump`min], 
                  System`VectorPlotsDump`min, 
                  Min[System`VectorPlotsDump`m], 
                  Min[System`VectorPlotsDump`m]]; 
               System`VectorPlotsDump`imax = If[
                  NumericQ[System`VectorPlotsDump`max], 
                  System`VectorPlotsDump`max, 
                  Max[System`VectorPlotsDump`m], 
                  Max[System`VectorPlotsDump`m]]; Map[If[
                  
                  Or[# > System`VectorPlotsDump`imax, # < 
                   System`VectorPlotsDump`imin], #, 
                  System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
             "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, 
           PlotRange -> {{-10., 10.}, {-10., 10.}}, PlotRangeClipping -> True,
            PlotRangePadding -> {{
              Scaled[0.05], 
              Scaled[0.05]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
         FormBox[
          FormBox[
           TemplateBox[{
             FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 GraphicsBox[{
                   RasterBox[CompressedData["
1:eJxt13k01dvfB3AZUoiUeUylqKQBGXLfKEMpKqSQIU0qilQUlSGiFBkq1Lnp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                    "], {{
                    Rational[-15, 2], -100}, {
                    Rational[15, 2], 100}}], {Antialiasing -> False, 
                    AbsoluteThickness[0.1], 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]], 
                    LineBox[
                    NCache[{{
                    Rational[15, 2], -100}, {
                    Rational[-15, 2], -100}, {
                    Rational[-15, 2], 100}, {
                    Rational[15, 2], 100}, {
                    Rational[15, 2], -100}}, {{
                    7.5, -100}, {-7.5, -100}, {-7.5, 100}, {7.5, 100}, {
                    7.5, -100}}]]}, {
                    CapForm[None], {}}, 
                   StyleBox[{Antialiasing -> False, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -100.}, 
                    Offset[{4., 0}, {7.5, -100.}]}, {{
                    7.5, -54.12844036697248}, 
                    Offset[{4., 0}, {7.5, -54.12844036697248}]}, {{
                    7.5, -8.256880733944953}, 
                    Offset[{4., 0}, {7.5, -8.256880733944953}]}, {{7.5, 
                    37.61467889908257}, 
                    Offset[{4., 0}, {7.5, 37.61467889908257}]}, {{7.5, 
                    83.4862385321101}, 
                    Offset[{4., 0}, {7.5, 83.4862385321101}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -90.82568807339449}, 
                    Offset[{2.5, 0.}, {7.5, -90.82568807339449}]}, {{
                    7.5, -81.65137614678899}, 
                    Offset[{2.5, 0.}, {7.5, -81.65137614678899}]}, {{
                    7.5, -72.47706422018348}, 
                    Offset[{2.5, 0.}, {7.5, -72.47706422018348}]}, {{
                    7.5, -63.30275229357798}, 
                    Offset[{2.5, 0.}, {7.5, -63.30275229357798}]}, {{
                    7.5, -44.95412844036697}, 
                    Offset[{2.5, 0.}, {7.5, -44.95412844036697}]}, {{
                    7.5, -35.77981651376147}, 
                    Offset[{2.5, 0.}, {7.5, -35.77981651376147}]}, {{
                    7.5, -26.605504587155963`}, 
                    Offset[{2.5, 0.}, {7.5, -26.605504587155963`}]}, {{
                    7.5, -17.431192660550458`}, 
                    Offset[{2.5, 0.}, {7.5, -17.431192660550458`}]}, {{7.5, 
                    0.9174311926605505}, 
                    Offset[{2.5, 0.}, {7.5, 0.9174311926605505}]}, {{7.5, 
                    10.091743119266056`}, 
                    Offset[{2.5, 0.}, {7.5, 10.091743119266056`}]}, {{7.5, 
                    19.26605504587156}, 
                    Offset[{2.5, 0.}, {7.5, 19.26605504587156}]}, {{7.5, 
                    28.440366972477065`}, 
                    Offset[{2.5, 0.}, {7.5, 28.440366972477065`}]}, {{7.5, 
                    46.788990825688074`}, 
                    Offset[{2.5, 0.}, {7.5, 46.788990825688074`}]}, {{7.5, 
                    55.96330275229358}, 
                    Offset[{2.5, 0.}, {7.5, 55.96330275229358}]}, {{7.5, 
                    65.13761467889908}, 
                    Offset[{2.5, 0.}, {7.5, 65.13761467889908}]}, {{7.5, 
                    74.31192660550458}, 
                    Offset[{2.5, 0.}, {7.5, 74.31192660550458}]}, {{7.5, 
                    92.66055045871559}, 
                    Offset[{2.5, 0.}, {7.5, 92.66055045871559}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -100.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["5000", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -54.12844036697248}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["10000", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -8.256880733944953}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["15000", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.61467889908257}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["20000", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 83.4862385321101}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                    "GraphicsAxes"}, StripOnInput -> False]}, 
                  PlotRangePadding -> Scaled[0.02], PlotRange -> All, Frame -> 
                  True, FrameTicks -> {{False, False}, {True, False}}, 
                  FrameStyle -> Opacity[0], FrameTicksStyle -> Opacity[0], 
                  ImageSize -> {Automatic, 200}, BaseStyle -> {}], Alignment -> 
                 Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]}, "BarLegend", 
            DisplayFunction -> (#& ), 
            InterpretationFunction :> (RowBox[{"BarLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"WL12DefaultVectorGradient\"", "SummaryItem"]}]},
                     {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                    "[", "#1", "]"}], "&"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.00004544180979811248`", ",", "21839.231223227984`"}], 
                    "}"}]}], "}"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
                 RowBox[{"LegendMarkerSize", "\[Rule]", "200"}], ",", 
                 RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
                 RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
               "]"}]& )], TraditionalForm], TraditionalForm]}, "Legended", 
        DisplayFunction -> (GridBox[{{
            TagBox[
             ItemBox[
              PaneBox[
               TagBox[#, "SkipImageSizeLevel"], 
               Alignment -> {Center, Baseline}, BaselinePosition -> Baseline],
               DefaultBaseStyle -> "Labeled"], "SkipImageSizeLevel"], 
            ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           AutoDelete -> False, GridBoxItemSize -> Automatic, 
          BaselinePosition -> {1, 1}]& ), 
        InterpretationFunction -> (RowBox[{"Legended", "[", 
           RowBox[{#, ",", 
             RowBox[{"Placed", "[", 
               RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> 
        True]},
      "RowDefault"]},
    {"\<\"Fig. 3. Vector and stream plots for the function \
\\!\\(\\*FormBox[SuperscriptBox[\\\"\[ExponentialE]\\\", \\\"z\\\"], \
TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1467797582,ExpressionUUID->"898e97af-5fd8-45f0-ac2b-eef7dce871a2"]
}, {2}]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Sine and Cosine", "Subsection",
 CellID->141653207,ExpressionUUID->"f4de25e8-1203-4a07-a21e-ffbd3c52d8f5"],

Cell[CellGroupData[{

Cell["Definitions", "Subsubsection",
 CellID->165579620,ExpressionUUID->"83697c7c-f285-44be-b5b6-ca9c843b93d4"],

Cell["\<\
Similarly to the complex exponential, the complex sine and cosine are defined \
from the series\
\>", "Text",
 CellID->62573840,ExpressionUUID->"a36dfbe2-d1f5-4bd4-817d-fdf0bc6e077d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"cos", " ", "z"}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], 
      SuperscriptBox["z", 
       RowBox[{"2", "n"}]]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "n"}], ")"}], "!"}]]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->98964326,ExpressionUUID->"00f6c0e3-24f4-4899-a4a8-c162413b0a30"],

Cell["and", "Text",
 CellID->595900788,ExpressionUUID->"c0c311c8-9dee-45b4-87d6-fb3028d96ed7"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"sin", " ", "z"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]"], 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], 
       SuperscriptBox["z", 
        RowBox[{
         RowBox[{"2", "n"}], "+", "1"}]]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "n"}], "+", "1"}], ")"}], "!"}]]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->193811385,ExpressionUUID->"37aa6896-e7b0-4561-9eef-c8f332bd512a"],

Cell["which are familiar from real analysis.", "Text",
 CellID->726807838,ExpressionUUID->"3ea9834b-1311-4f79-b1a4-1fad595e9ef7"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->353918019,ExpressionUUID->"28ae654b-c96a-4b43-83d7-9c8d0d65b4b5"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s use Wolfram Language to compute numerically ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"207b3716-ea27-4df0-aa67-e17ca9fa0f8f"],
 ":"
}], "SolvedExampleNote",
 CellID->9814578,ExpressionUUID->"f8f43344-9b31-4904-b817-13433cd2c369"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"1", "+", "I"}], "]"}], "//", "N"}]], "SolvedExampleInput",
 CellID->76737624,ExpressionUUID->"9d0c2226-5744-4d3c-a622-f2b56e1f939b"],

Cell[BoxData[
 RowBox[{"1.2984575814159773`", "\[VeryThinSpace]", "+", 
  RowBox[{
  "0.634963914784736`", " ", "\[ImaginaryI]"}]}]], "SolvedExampleOutput",
 CellID->313100789,ExpressionUUID->"bc9401b4-ed5d-43fd-9dab-ced94c518e4d"]
}, Open  ]],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{
      FractionBox["4", "3"], "\[ImaginaryI]"}]}], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f2f480de-253c-4fba-ad75-f22789fd216e"],
 ":"
}], "SolvedExampleNote",
 CellID->162510497,ExpressionUUID->"d80bb7e3-5c62-416d-9827-fbf23e2d023b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{
     RowBox[{"4", "/", "3"}], "I"}]}], "]"}], "//", 
  "N"}]], "SolvedExampleInput",
 CellID->263901560,ExpressionUUID->"8515bbeb-7d25-4149-8fcd-54d46acdd6b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.844209004216301`"}], "+", 
  RowBox[{
  "1.6049421277296851`", " ", "\[ImaginaryI]"}]}]], "SolvedExampleOutput",
 CellID->351840002,ExpressionUUID->"41fe6207-1363-41db-84f6-195895dc9df3"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1399498226,ExpressionUUID->"44ded184-324a-4ae5-9329-aee2894b6de2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphs", "Subsubsection",
 CellID->120840743,ExpressionUUID->"c27445f9-40b9-4568-99c7-404a49da7d88"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s plot the modulus of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", " ", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "13df5da5-b0a4-e949-b877-0dbfd37f4cdd"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", " ", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4b0e59a3-e092-7340-9795-a57a15c1dfbb"],
 "."
}], "Text",
 CellID->13511269,ExpressionUUID->"9659896b-bebe-674c-bed6-bc32d7170c13"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["3", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["1064", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[
        PlotRange -> {0, 6}, BoxRatios -> {1, 1, 6/8}, AxesLabel -> {
           ToString[$CellContext`x, TraditionalForm], 
           ToString[$CellContext`y, TraditionalForm], 
           ToString[
            HoldForm[
             Abs[
              Sin[$CellContext`x + I $CellContext`y]]], TraditionalForm]}],
        SelectWithContents->True,
        Selectable->False]}], "]"}], "//", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", 
         RowBox[{"Function", "[", 
           DynamicBox[
            FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
           "]"}], 
         GridBox[{{
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["776", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Labeled[#, ("Fig. 4. Plot of " <> ToString[
          HoldForm[Abs[
             Sin[$CellContext`z]] == Abs[
             Sin[$CellContext`x + I $CellContext`y]]], TraditionalForm]) <> 
       "."]& ,
      SelectWithContents->True,
      Selectable->False]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["3", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["1064", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[
        PlotRange -> {0, 6}, BoxRatios -> {1, 1, 6/8}, AxesLabel -> {
           ToString[$CellContext`x, TraditionalForm], 
           ToString[$CellContext`y, TraditionalForm], 
           ToString[
            HoldForm[
             Abs[
              Cos[$CellContext`x + I $CellContext`y]]], TraditionalForm]}],
        SelectWithContents->True,
        Selectable->False]}], "]"}], "//", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", 
         RowBox[{"Function", "[", 
           DynamicBox[
            FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
           "]"}], 
         GridBox[{{
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["776", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Labeled[#, ("Fig. 5. Plot of " <> ToString[
          HoldForm[Abs[
             Cos[$CellContext`z]] == Abs[
             Cos[$CellContext`x + I $CellContext`y]]], TraditionalForm]) <> 
       "."]& ,
      SelectWithContents->True,
      Selectable->False]}]}], "}"}], "]"}]], "Input",
 CellID->229375856,ExpressionUUID->"6f5628ea-d409-4a58-8ac1-4f48b4a16cc0"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJzFfXmYj9X7/xj7EmrsUkRpUbQooc4jEiGEsiRl14dUskSWkkpI1nzwSZbs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        "], {{
          {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
            GrayLevel[1], 3], 
           StyleBox[GraphicsGroup3DBox[
             TagBox[{Polygon3DBox[CompressedData["
1:eJxFm3kcF9P6x78z35k58yVb9oSkxA3tC0qFkiIU2UKSraztCmlTVCiVCtlK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                "]], Polygon3DBox[CompressedData["
1:eJwtm3f819MXx9+f9/6SvbJT9paS0dBQZFU0pEHDqKwK7aJUFKJBSpFKQtl7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                "]], Polygon3DBox[CompressedData["
1:eJwt1muQlmMcx/G79nmeXeTQIIdsOpJQ0sGhw3ZUOuiAlpzXtGWplWombKGi
siKV3VAKlVPIoMiLBg1iSg6jiBdmMBmV8iKmTfn85/LiN3v9vtfv/7/u576v
6763VUX16EmNsyyroTxdX5Rl19FPzHcmDhvPLM6ylvxfuSybIzODH1TIsuMa
ZVkd9kCoJMtOouFYd9mV1JQfJncy1pPvQYuwKepnYvvVnY7dww/AT+Dvtt4w
a1yk7lAhjYPNM9fA32DcHTvs2nbSEb6H+rx+C2V667dEr8HYYPPVfGd6EhtI
J8pMVjNcj0769ceOwe7ErsDOw45X216/FupK6XGZAtYc68OX0VPYDtnOap9U
+5TacfwJch3kRsmMpGfltuLnyR3HLzNXKdNAs/lZNDHuM7+Rxunzm+ww/AN+
H/2upsYa07C9/BdUHuNcem6f87dao9b4M2wLzbPuOjXvYG39bUfvqdkme72/
+2RmmNvK71R7Mb9Ipg6r5N/Hh8r9gQ9xfbv5+/S8hz9MC13TxXJj1XRTc0hm
B/3LPyj3YC5tqMVyl8k9hM3C6nNp38T+Kdaz1HiAXH+ql6mh6TJFcY/N9ZWr
w/ry/fLpGYzCrrZOJ0vss+ZX1MDfLzdVbePYA/Gs5DbTbLn55sfhP1hzgdxZ
xgtinVgfe9P823Lb9GptvMH8bLnHZApxbXIj9LoCa4E9JPMlVqt2A10p80BR
en7r+YOyc+SqsaHY3/xbVIq1zacz0VjuGP0utWYVVkcl/BuxB+VuVdtTbUf+
dWqC3RL7HbuQXxtnELsZuxy7gH+Nclg51hU7hy/oOdcaC/V/K84w/ypeZDxG
rotcO34Q3hKbjd3r+j6J+4I3xSqx/nLd+GtoqflT9TuFakvSvY573oifLH8v
1psy4wq1vQ1bFtLejzPQRG6TuUdK0v6IfXKUnxnCfsAuNV6qdrnaiXHvYy/I
5dTOiP0rV0aNjG+XK5NrLTPauKPxHr95Ox3iP7buaHW7ZSfpsZlvRt2Nb8Rv
iLOp11A6R2aBmvkxJ3MGVq7fapk1dCa/qZDO3sNyL2CnYt8W0rXGNW+N56z2
q0I6U3G2dmLnY99gy7B67AusTVwbtbFehV6303L9thfSeyXeL5vlzpbZgrUz
fiKfnmk828XUi78rzhE2MN59WKu4v0XpXfs1VqY2M34Un0+zZErxvtgdaifQ
c9iPWKXxgVw6O7tif+Nt+Ef1myNfjvXCjvK3US+5Vvp/Ry8ar8B2yHeQy+R+
9acq1tV3BX9NPHf+abln6G9+vOxyvY+X+cjc3Dh/1Dz2WJzreJfIPB3fGezO
XOo7BBtLc80fxNbTafwu11KWS9cS1zSFH6m2E7YMW4E153/C+2LPY6uxaYV0
fZdjr2Avx2+J+4L3wVbyq+Sm8tfiPbBXsdexSdgQrC1WG3sIO9m1jMA6Ys9i
z2EHsX9kH8F+jjMS301smFwHfrFcfdzT4rQHYy/+g2+MbyY/XO584yVyS+Vu
0msDnR33PJ/OZ4Vcrjjdt3Ox9vSEukHYsdiFfEdaiI2hnmpf0+8N/ar1Ko99
ha3F3ozvcJwtrCv2IvYSNj6+HfrdrN+0eAeb+zO+3cXpuzYVW4QdwV4yXqvm
U/wU43etvQ5vFmeSH2KuJ9869pt+n+Lv0MMl6VsT35yG+B+BpmPfY5fk0jmK
83RXvJfi98W3I5d+Yy+9qmilcVP829iDMs/QVfyIfPrWXxffFKyb+VXxzPW7
I543ls+l/4nif6Nf+H5UglXxA+Xa/58rYBOw8fQhvwcfEH34+8zt5fdarxm/
Pp/2VeyvUbJdzL9gvEZ+gtz+Quoda9SYOxB7VK44l/pF33Ox/wCb6iEE
                "]], 
               Polygon3DBox[{{2126, 1069, 922, 921, 1232, 1830}, {2040, 1407, 
                871, 872, 1408, 2041}}]},
              Annotation[#, "Charting`Private`Tag$23624#1"]& ]],
            Lighting->{{"Ambient", 
               RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
              "Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{0, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 0, 2}]}}]}, {}, 
          {GrayLevel[1], EdgeForm[None], 
           StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlgWYFlUUhod/5h/uIB3SKIp0CkiaNEh3x5IqYGN3ooKNLR3SzdIp3Uiz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               "]], Polygon3DBox[CompressedData["
1:eJwtmAewVsUZhg/3nPNzLr1KDxIMGAKECCEOwzgmgqhUTVTAShMwEVN1UjRF
Z9KMpvdiL7HS4V7gApZYKNEELLSLgoUSYxDRIJLnybczd+fuu9+e/c+/+33v
++7fb+bV5y2oy7JsYIssK/j/6TzLptM/QH8BAy/RNjH2HHhoyyzrWJ9l68F/
A/+glmXvlFm2n/4+2ivgflWWtSe+m0Uvov+XWqx1kLaX/mZiN7P++bSLWXsC
bStr9GN8EPMP8P9kWifml8yv4/P+SbyP48R30gbQ70g8J14QXwheBr4WvJu2
n8/eTBvM3GbwPvr9mfMxMW0k/e7Mb02sF89vAP8d/DPwCeBZvNNMWlf6P2es
mdh8cG9wN9qTzN/A2E+IZeDneL8ejA1g7e7gp+hvJHQz8Z7gZ8CbwT8FdwY/
Bn4K/CNwD/DT4E3gW8BdwI+Dnwb/GNwC/A/W78XYwCreYSP9Z7N4txp4MXgF
+BvgDuB14CfA3wcP55mjfP+VtO7gR1hrDa0R3BO8ivha8Gpwb3AjuAm8CtwL
vBQ8xb1jvfbgEeBjxBpoPcDLwOcSH0y8A3gJeLJnCW4HXgNez3pNzP8Q+CHw
OOL9ibcEPwAeC+6XzrsBvJr5K5jfDfxX8GnEexHPwPeDTwf3BraoRb6MoZ2Y
8uFB4meCP+x0cCf241Hwk+AfglcQb2T9ZazfFbwSvAq8HHwCuBXzVzJ/NfO/
DW4JXgJeCf4m+DzyYBm4EXwduCK+FNwA/ha4BC8CLwd/HXwi67cFN7P+dPqt
iTeA1xD/DvH24LXgx80H4tNZfw14PfhG4kMZe5NnF9E6gZeDG3jfpeAu4CHg
g/QXu7/07ye2krYE3Jl4G9ZvZL0m1vsuuB14NXgd+AZwW/Aq8Frw98A5eAvP
92Xso6z3AW0zuKN7Sr+v34H+LtafRv8O2lBwF55/j3m3gQel+j1SRo0NpH8o
j9q7nTaYfmfG3i1jz6yFc4vYS/PL+ROYc2V91JRncVYRtfYRcDdie/n8S+i3
4vkBhP7jO1Wx3+79Gcx/v4qcN/d38lnz6mO/+hpn/hX18Z0827FFfFdzyFza
nwfX+H3lls8QP1oFv1lrY8DH6N9JG8bcroz9twyOkqte5zMvT/zjWXqms+sj
h8zFKUXkljkml5xfRO5tZd6WPPhHHvIMPJvxRZyN+yHXvMr6l9K/qgjunQaf
7qC/jXYh/am07UXw4aPEm3hmTn1wiFzyGs9fVsX7mhvnFMG15qzcMamIXL4e
/Az4c+D6tP+rwOPAx+kvpk0yVxhrWwsOUhsmF8FNcrK5PbEIrpaPPK/xPDO/
Pr6fufZGXWiB72dtnF0E913D8/WeBfGpxG6tQh/k/8NlcJRcdbwuuM0z2VSG
BnlW5rTcO7WIXDcnNpZRk+aKNWQtvVUXtSMnyA2HaB+vQuO28vylRWif9Wh+
yDlzwfeBR9PvydjxMjh8B/0riuB2OX8neG4RWvA+c7qB9/DMjio4QK24oAhu
MMc2lFFj5p57/GwZOe/eW8NqxYVF1LaatQs8rwgt2wV+RW5j/knWWsvQ2gto
Q+jfy9goYj145oMyOEDtm1YEN8iBcuFh2jDmzmLsAPP2gC+ugpPl5iO0T5jr
cjz9nDVHVqEhakkL8CfBO/LQ6w7JH6gBakHJ2KeqeF+5VE6dWR+a9yJ4RhFa
qEa+AL68CO1U07aALylC6+T058GXFcH1au528JwitFgNf0K/koe235303zPw
LPrK8eCKdiqxm8AvZVF7zlfjt4FnF6H9C6vgpoHJP7jH7rV75F6pqWprcxn8
ZY7qr3bmkbtyIt1sVx5c6Rp6kbfzWNs9dq89c89ejpT6mvPgTjmWv2x3Htwr
52hDXs6Di6xpa1vPZD3LEXKFHsJ6kpPkJjlePrEGx6fvo563qUVuHGZsURX1
oFY/WIZ2et56gcV6hirqz9pfWIZ38Hz1AkvK0H45wdp4Jw+u0BOo5Ufy8ArW
n1r9QBnapsdQ29/Nw3voKfqoLXl4jWPl/2UgexV8TxUar5b8Kw/t10OoPQfz
8BZXVcFnelbr9wtV8JEeyfyZk/hfDVd/3AO9za4y9ubqKvhaz2b+fT7xsRpq
vSyogu/0GObfvKRXarz1PDfxpZ5CfndPJ+pls9jr2UlP9BjqwcykN3qIMvEF
Q9nePHK3qoXW/Bv8cBUeSu19Mw9vZU23Ar+WR63LSa3Br+fBVXqmtuB9eXip
WUkv9ZDy9Qzw0iw8tXxtcrXh3xt5eDHrW2+3qAzveGXSDz1E28QfJ4EfKsNb
qdFqtR7Zg1OD1eL3GDulippflvxT/yo0ck3yJ94H1Kym5If07zOS3/LM1G45
+IUyPJLcrKY/X4YnGpKef7uMO4FaKMePTf7Q3PPzDpVxR1Crff6M5Cf1W77v
OXloll7iLtYcLpeAj5bBEXKLGnlT8tcTkx5aG77fmORv9WNygtyghx6R+FEN
r0t6Zs6Ze3r24Yl/lye/Kdf0MSeLqIm6Wuzf/jI4Xy5VQ1cnP6e2PkI7W+1w
+2vB6XJ7Y6pnPanedFPSTu9s3t30fPohPZ5eT81UO+VsuXtdqn/P0LPUs+vd
5Xy5vynxgfrzWBYeV6+rRqgVa1P+yLly7/rEF2q8Wq8GqoVqjFqzKuWTmnlK
HjVhbej5RiQ+1wv+gnZLi/BA3le3VcH/3qf063qYFXnU5PXJf79YhEb6rmq+
2t+Q+Mj99h7sHXZPLe7DeqzmLO5f6qF7+3D6/vOTf9Fzq8+e94RU72qDOaA3
N2fNjd8nvj018dkfEl+OSvX7x8SXo1P9XlOFn/HOqt57pubiW3mc9bVV6Ll3
RO+Kv0x8eHLSH3O2pVqcRy7/Nj0/LOnH75IejUx887Uq/IZ3WP3LHen7npX4
567E/xOTXtxZi+86IenZ9ip+P/C+6n3G+43v5jvekO5T3ne9A3gX+GIVfcfU
/xuTf76oiLXM+XZZnIln8+ekD6cnPrs98c+4xIe/SXw5NOnlbUnPzkx68aek
N6clfrs16dHYpB+/SvoyKOn1V6vwa97Z9XeemWfnnqlNcpS/Ncg5co8c4t1N
TpJbrkt+57NF5OZ93uGyuEOrb3Jg5zxq2treWQtulPPkPjnR30rkLLnrS1Xk
tjmu17k36e+UpJ+ekWflnqgdX6nivuFvFPqjL1fBXf6mob+5J+n75KTPL9fi
tx/P0P0fXUWtmR/e536d9Gdw8iejqvB6ej7vT3cnvZiU9F/OkDv0jHqJ/wEm
WUgH
               "]], Polygon3DBox[CompressedData["
1:eJwt1AdsVWUYBuAjlNJiWSlglI0MQWXJKGWGXYhAFWUKtIxWVIqgzISVAMom
QTZuQBNZBRQRRdlbUZApKEuFgOCiaBjPn0vStz3vc7//3HP/c08rZuY8MyRf
FEVpUkB6JURRm7go2pA/ijbpFfWR8iI7zc6yufFRlMk6sW/YTjaSvc6y2En2
E5vN+rGObAvbyh7TX5E+7DA7yqaaq8U+cQFt2aOsJJsnZ/Rq4ie66fW32Fml
ujhFlMeGWNtX+Z79yN4wk8P6sR/YMfYmWyjn9FpSkP1v7QL2i/6kOIz+Yz2t
bW3tevYZq6DP9+LP+uP5Y/t0y6/afJW/7VhlVsrMCJZt7Sl2hs1h9dk6c51Y
DVaGdWctza1jG9kI9hobxE6w02wWq8NWW9ueVWEPseFsoLnj7BSbyYaxAewY
O8lmsB6sFctln7LyeopscL708JmDmctgT5v7mu1go1glVlw/58vR1msZiVGU
yq6wVlLeXJy5oSzD60fYcTaNNWTrvUcX9gQrxxqzP/UOkiZrw2eQdGt36HvM
jTXXgOVa2znsNSvLerN25jaF+yH9Xctg1p3t1w+Zm2iuD0tjm9mXrKq+lP+m
N5YkFm7ye3ItXJuUQAX15fKPniqPsML6h/K3niIPsyT9fflDryklWYL+rlwN
91aSw1voy+R3vakUZg/ob8tlvbkUYfn0FfKv3kRKsyL39+qG/pTUC8+c/jG/
5billDNXXP9Aruu1pRRLDM9LfOx+fWcPk8OzZO1HLM9xCylrrpi+Um7qzaQM
K6oPMvtsXGyPw14n2udG7LzjOlI3PNfhf4F0M7dPP2jtBGtfYj3YAfYtm8QW
yyW9oRRid1zTInZRrx/Oz26zJexXvZE8yO6yd+JjnzN83hznvaAP8B5dHG9n
u702hvVlHdgX7CtWLSF2zRfu713Yw+X6C9Le3Of6FnNV9LqypkDs+xi+l9ku
KIs9Z26Pvt/cOO/xclgf9pQdYVNYNnue7WUH2Hj2KstkR9kJNj38v5FebCvb
zibr/c11ZtvYLjY6PnbOcO7e4fmXaQmx+9HV8e4wF551vYn85bijVDVfyLp7
rye1qw==
               "]]}],
            Lighting->{{"Ambient", 
               GrayLevel[0.8]}}]}, {}, {}}, {
          {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0MtKAlEcB+D/pJZd7PICSquIkCiQyIjwFaxNQZseoN6t7KKWVi9Rmy4b
VyIRUSES9Q3B/Ob7zcw5c87M4tFJ/TiJiEPZHYtIe9+pz69cxDyz4xElFvMR
Z8YM5MGzU77Jo95gk+88l5b+wQtp65+8lGv9m1dyow/5zCZH8qK3+COvepsd
/qZzpasnGXP1Wz2jd/Q7Pad39Xs9r09Iyd7L9r7AInsccM+4OVZ54Htrxs66
3mGB25zhFqe5ySlucJIV+h2xzrV0LX2VXh9l2kKsMMtlOmLJyXLx5OZ+8v+/
/wBSIi30
            "]], Line3DBox[CompressedData["
1:eJwl0s1L03EcwPFvK1dYSIULEZEWeZOxW5c8CoF18eBhixgTQjtkl6COnvKy
a/4F9hf0B1R7cA8p9qC1h0At7QGda4REVPiKDh/er+93399+v99YPDs3efdY
CCFn9iIhJDQeDWFMk3pdr5wMYdqhNP/he87FrKf0hjN37M9z0l5W0/Ye2rtm
fZMX+JYu6ow+0RfO9R4PYbcnhOd8hj9znvv4Cxf4LH/lIp/nb1zivPZbL3OB
L/C+lq0HuM0VHuQDrvIQd7jGw/ydX/JF7vIKF/WS9SqXeIQvm6ee+b5nX9Lb
+lgzfoucd3zEp095P9eMW2+aB/aKPo/ZG7XOaMp1s/bPWU9wisd0QhN6VZ85
98HsuHfUfVv8iU9wkz9yhBu8zYHrvMV/tabv9bep8jv9ZSq88e+79aeumxYf
6lvT5B/6xjS4q69NnTta1lfaNsu8Fvn/fzkC45hVCA==
            "]], Line3DBox[CompressedData["
1:eJwl0MsuQ1EUgOFFXSMiIiIiIo0pD6MDMTHBmJl4AVMGnsUTMETbc1q96sX9
NuMBfDsGO9+/stOsfVrcOyodjkTErnM8EXHJE15zczJi2+X+aERu3uKZuVyI
qJkrrLPKe2ZsMGeTNbZYT/dOWzfYYZNdtvjANnvssM8uB8mxiB07D+wemks8
N194Y2Y+5RU3przL3ZfzOx6x7vef+kcX035+mNfSm/W7Xk3fod/0is71q17W
mX7RS7qqn/U3F81PaY9e0BU+mud1WQ/1nL7TAz2rb3Vfz+gb3dPThf//+w/d
xUCt
            "]]}, 
          {GrayLevel[0.2], 
           Line3DBox[{1569, 2109, 2273, 1568, 2110, 2274, 1570, 2111, 2275, 
            1571, 1026, 1572, 2239, 1706, 1573, 2240, 1707, 1574, 2241, 2112, 
            2276, 1575, 2113, 2277, 1576, 2114, 2278, 1577, 2115, 2279, 1578, 
            1034, 1579, 2242, 1708, 1580, 2243, 1709, 1581, 2244, 1710, 
            1582}], Line3DBox[{1584, 2116, 2280, 1583, 2117, 2281, 1585, 1766,
             2282, 2168, 1586, 2170, 2283, 1768, 1587, 1142, 1770, 1588, 2245,
             1711, 1589, 2393, 2040, 2041, 2392, 1590, 1772, 1773, 2334, 1591,
             1776, 1777, 2359, 1592, 1779, 2284, 2174, 1593, 2176, 2285, 1781,
             1594, 1443, 2071, 1595, 2246, 1712, 1596, 2335, 1782, 1783, 
            1597}], Line3DBox[{1611, 1785, 1846, 1784, 2336, 1610, 1793, 1179,
             1609, 2036, 2072, 2399, 2074, 2073, 1608, 2062, 2063, 1845, 2349,
             2177, 1607, 2175, 2289, 1844, 1780, 1606, 2173, 2288, 1843, 1778,
             1605, 2370, 1775, 1842, 1774, 1604, 2337, 1790, 2042, 2044, 2043,
             2394, 1603, 1789, 1166, 1602, 1771, 1841, 2348, 2172, 1601, 1769,
             1840, 2347, 2171, 1600, 2169, 2287, 1839, 1767, 1599, 2178, 2286,
             1788, 1598, 2369, 1787, 1786, 1847}], Line3DBox[CompressedData["
1:eJwV0EkvnWEYBuAXx3A4+A36E1g3EWMRGxUrG9YcJBVjYqohMTYiIt2xsbBo
TdWiC4n4H+YpobrH9S6uPM/33vf75ZyvpL2rKZ0RQhihMSeE8dwQzpmggjHu
aE6G8FOeaf/CCL1U0sFXtuVZ5jqvbJBgMS+ED+7f23d02sw+LmhyPi+vsk/y
wK5OtrnJJZ91lnWq7VM8sqeTY67Ec/mVfYsapplhXyfXXNWp0Xmz/yCPTmZj
X/ZRNmTvZpgekszxRIv8l3e12/u5ZoBaltwvlT/bD3Ty43fgJv5XPvFNp0zn
n/23TkHschufOZPXmfMs8EcnZf4lJWt1d82sj9+SFw51CmPfebl81D5IA+n4
uzjSKTK/x/frJMwTz8Us859jnVPzHcN3Ras=
            "]], Line3DBox[CompressedData["
1:eJwVz8kuQ3EUB+BTgnoML2DYUXNIiIhSalzxALrzAlaGjUYaaiiJIQgiMSSG
ILwOC3vhu4svZ/id/G9uw0Iht5iKiHlmayM26iKK9PLJB0P1ETOyN/07PbzS
Yl9OR0zLqtRqggpzspQ6JXt2+0I3g/ZP6iOTsnv1gR+3Xeodt+RlN+qA+y1Z
pz6YsF9Lbu0L5j/zqrrCuD5v/6X/ZpsyrTUROdmV/poOLml2W/LWmOzcfEE7
m3ZNsjP9qOxEPSVDo/2yPGu/lPyTed3cpj/miBHZgdovO0y+zx67DMuK7vtk
O+YSFfb55R9GLzNJ
            "]], Line3DBox[CompressedData["
1:eJwV0Msug1EUhuElEW2ZSLVNREgYuAISd0CitOowkRiUMQljroKY4FKcD3UW
5zM3Ye7Zgzfv2t/375Xsv7e+VFtsiog6Zlsi1jMRGyjjFMPZiNFcRLv5DA2M
4RwD8l138uYO3xWQx5y8yHu6gu4Cl+mubJyvsK8r8jVu0j5dhW9xoCvxlqxs
1525ikP5PA/JlnkFE7jHSNotz/CD8yM28YSSrK854s/8jBfUsC0fdOfI3k7n
V7xhEhX5Ox/ruvgDn+kt7kzxiXyBV7GW3ief5q/033TdvCOr2vNtnsFP+oe6
Hu6XZ/U5/Dq3ckPXxv97GTWX
            "]], 
           Line3DBox[{1628, 1809, 1879, 2121, 2339, 1824, 1811, 2122, 2340, 
            2061, 2053, 2252, 1737, 2054, 2180, 2253, 1880, 1738, 1826, 2181, 
            2254, 1881, 1739, 1893, 2361, 1815, 1882, 1740, 2001, 2381, 1816, 
            1884, 2123, 2341, 1883, 1829, 2039, 2064, 2065, 2397, 1944, 1818, 
            2077, 1064, 1831, 1820, 1885, 2358, 1741, 1894, 2182, 2255, 1886, 
            1742, 1895, 2183, 2256, 1887, 1743, 1833, 2346, 1823, 1744, 2017, 
            2385, 1835, 1745, 1888}], 
           Line3DBox[{1630, 1825, 2124, 2343, 1629, 2125, 2291, 1631, 1068, 
            1632, 2184, 2257, 1746, 1896, 2362, 1827, 1747, 1897, 2363, 1828, 
            1748, 1633, 2345, 1830, 2126, 2344, 1634, 2038, 2127, 2391, 2076, 
            2075, 2128, 2400, 1635, 1832, 1072, 1898, 2185, 2258, 1749, 1899, 
            2364, 1834, 1750, 1636, 2259, 1751, 1637, 2260, 1752, 1638}], 
           Line3DBox[{1640, 2129, 2292, 1639, 2130, 2293, 1641, 2131, 2294, 
            1642, 1078, 1643, 2261, 1753, 1644, 2262, 1754, 1645, 2263, 2132, 
            2295, 1646, 2133, 2296, 1647, 2134, 2297, 1648, 2135, 2298, 1649, 
            1086, 1650, 2264, 1755, 1651, 2265, 1756, 1652, 2266, 1757, 
            1653}]}, 
          {GrayLevel[0.2], 
           Line3DBox[{1475, 1461, 935, 2262, 1080, 920, 1229, 2363, 1295, 
            1228, 1270, 1206, 2361, 1290, 1205, 1263, 2380, 1371, 1372, 1202, 
            1374, 1373, 1390, 2373, 1343, 1344, 1184, 1346, 1345, 2352, 1253, 
            1167, 1251, 1166, 883, 2245, 1041, 870, 2240, 1028, 855, 1500}], 
           Line3DBox[{1476, 1462, 936, 2263, 1081, 921, 1232, 2345, 1230, 
            1272, 1210, 2381, 1375, 1208, 1264, 1304, 2360, 1305, 1288, 1350, 
            1349, 1414, 2374, 1347, 1348, 1187, 1337, 1336, 1335, 1171, 1333, 
            1412, 2394, 1411, 1410, 1409, 2393, 1407, 871, 2241, 1029, 856, 
            1501}], Line3DBox[{1477, 1463, 943, 2265, 1088, 928, 2259, 1073, 
            913, 1220, 2346, 1237, 1395, 1394, 1267, 2384, 1384, 1385, 1216, 
            1314, 1313, 1315, 2368, 1309, 1310, 1193, 1359, 1358, 2353, 1255, 
            1435, 1436, 1434, 1179, 888, 2246, 1046, 878, 2243, 1036, 863, 
            1508}], Line3DBox[{1478, 1464, 944, 2266, 1089, 929, 2260, 1074, 
            914, 1240, 2385, 1387, 1433, 1432, 1386, 1430, 2342, 1431, 1219, 
            1365, 1364, 1419, 2377, 1360, 1361, 1196, 1363, 2378, 1362, 1256, 
            1159, 1180, 2336, 1158, 1249, 1157, 2335, 1156, 879, 2244, 1037, 
            864, 1509}], 
           Line3DBox[{1479, 1018, 850, 2273, 1023, 865, 2280, 1038, 880, 1160,
             2369, 1332, 1402, 1047, 889, 2371, 1339, 1340, 1181, 1316, 1053, 
            2388, 896, 1317, 1318, 1197, 1366, 2379, 1056, 899, 1198, 1221, 
            2339, 1059, 906, 1222, 2343, 1066, 915, 2292, 1075, 930, 1510}], 
           Line3DBox[{1480, 1019, 851, 2274, 1024, 866, 2281, 1039, 881, 2286,
             1161, 1162, 571, 890, 2372, 499, 500, 418, 1924, 453, 433, 642, 
            541, 2356, 900, 672, 1437, 2340, 1060, 907, 2291, 1067, 916, 2293,
             1076, 931, 1511}], 
           Line3DBox[{1481, 1020, 857, 2276, 1030, 872, 1408, 2392, 1042, 884,
             1170, 2337, 1172, 1049, 892, 1397, 2389, 1399, 1398, 1188, 1299, 
            1311, 2365, 1054, 897, 1302, 1331, 1303, 1207, 1376, 1426, 2382, 
            1057, 902, 1209, 1271, 2341, 1062, 909, 1231, 2344, 1069, 922, 
            2295, 1082, 937, 1517}], 
           Line3DBox[{1482, 1021, 858, 2277, 1031, 873, 1146, 2334, 1043, 885,
             1147, 2370, 1338, 1050, 893, 2366, 1300, 1301, 1287, 1322, 1055, 
            2390, 898, 1323, 1324, 1211, 1377, 1406, 1058, 903, 1438, 1439, 
            1334, 1440, 2397, 1063, 910, 1449, 1450, 1448, 2391, 1070, 923, 
            2296, 1083, 938, 1518}], 
           Line3DBox[{1483, 1022, 859, 2278, 1032, 874, 1148, 2359, 1278, 
            1044, 886, 2288, 1149, 1284, 1051, 894, 2375, 1351, 1173, 1352, 
            1325, 1326, 2354, 1400, 1327, 1189, 1427, 1378, 1379, 2357, 904, 
            1212, 1233, 1064, 911, 1447, 2400, 1071, 924, 2297, 1084, 939, 
            1519}], Line3DBox[{1497, 852, 2275, 1025, 867, 2282, 1136, 1275, 
            1040, 882, 2287, 1137, 1281, 1048, 891, 2367, 1307, 1163, 1285, 
            1319, 1320, 2338, 1396, 1321, 1132, 1199, 1441, 2398, 1442, 901, 
            1422, 1423, 1061, 2252, 908, 1068, 917, 2294, 1077, 932, 1512}], 
           Line3DBox[{1498, 853, 1026, 868, 2283, 1138, 1276, 1139, 1246, 
            2347, 1140, 1282, 1141, 1306, 1250, 2350, 1164, 1286, 1165, 1308, 
            2386, 1257, 1368, 1182, 1420, 1183, 2248, 1367, 1261, 1425, 1200, 
            1424, 1201, 2253, 1268, 1224, 1225, 2257, 918, 1078, 933, 1513}], 
           Line3DBox[{1499, 854, 1027, 2239, 869, 1142, 1277, 1143, 1247, 
            2348, 1144, 1283, 1145, 1252, 2351, 1342, 1168, 1413, 1169, 1388, 
            1341, 2387, 1258, 1370, 1389, 1185, 1421, 1186, 2249, 1369, 1262, 
            1203, 1223, 1204, 2254, 1269, 1226, 1294, 2362, 1227, 919, 1079, 
            2261, 934, 1514}], 
           Line3DBox[{1505, 860, 2279, 1033, 875, 2284, 1150, 1279, 1045, 887,
             2289, 1151, 1174, 1052, 895, 1353, 2290, 1176, 1354, 1328, 1391, 
            1329, 2355, 1401, 1330, 1392, 1190, 1428, 1380, 2383, 1381, 905, 
            1213, 1291, 1065, 2358, 912, 1234, 1296, 1072, 925, 2298, 1085, 
            940, 1520}], 
           Line3DBox[{1506, 861, 1034, 876, 2285, 1152, 1280, 1153, 1248, 
            2349, 1154, 1175, 1155, 1254, 1356, 2376, 1177, 1415, 1178, 2247, 
            1355, 1259, 1383, 1191, 1429, 1192, 2250, 1382, 1265, 1214, 1292, 
            1215, 2255, 1273, 1235, 1297, 1236, 2258, 926, 1086, 941, 1521}], 
           Line3DBox[{1507, 862, 1035, 2242, 877, 1443, 1444, 1445, 1446, 
            2399, 1403, 1405, 1404, 1416, 2395, 1417, 1130, 1418, 1131, 1357, 
            2396, 1260, 1393, 1194, 1289, 1195, 2251, 1312, 1266, 1217, 1293, 
            1218, 2256, 1274, 1238, 1298, 2364, 1239, 927, 1087, 2264, 942, 
            1522}]}, {}, {}}},
        VertexNormals->CompressedData["
1:eJzsvXlUj233NxxpkhSKMlNkqChDJWwiDQoZQ6bIkKFopEFpLo0oSmkkFFKU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         "]], {}},
      Axes->True,
      AxesLabel->{
        FormBox[
         TagBox[
         "\"\\!\\(\\*FormBox[\\\"x\\\", TraditionalForm]\\)\"", HoldForm], 
         TraditionalForm], 
        FormBox[
         TagBox[
         "\"\\!\\(\\*FormBox[\\\"y\\\", TraditionalForm]\\)\"", HoldForm], 
         TraditionalForm], 
        FormBox[
         TagBox[
         "\"\\!\\(\\*FormBox[TagBox[TemplateBox[List[RowBox[List[\\\"sin\\\", \
\\\"(\\\", RowBox[List[\\\"x\\\", \\\"+\\\", RowBox[List[\\\"\\\\[ImaginaryI]\
\\\", \\\" \\\", \\\"y\\\"]]]], \\\")\\\"]]], \\\"Abs\\\"], HoldForm], \
TraditionalForm]\\)\"", HoldForm], TraditionalForm]},
      AxesOrigin->{Automatic, Automatic, Automatic},
      BoxRatios->NCache[{1, 1, 
         Rational[3, 4]}, {1, 1, 0.75}],
      DisplayFunction->Identity,
      FaceGrids->None,
      FaceGridsStyle->Automatic,
      Method->{"DefaultBoundaryStyle" -> Directive[
          GrayLevel[0.3]], 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "RotationControl" -> "Globe"},
      PlotRange->{{-3.9999994285714284`, 
       3.9999994285714284`}, {-3.9999994285714284`, 3.9999994285714284`}, {0.,
        6.}},
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02], Automatic},
      Ticks->{Automatic, Automatic, Automatic}], 
     Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJzFfXmcjmX7/szY971SXjutosVbeuO6E7JEorKUXZbQIksklKQiJFT2N1GM
Urw0Mbmfxp5QjzWT7bGbMWYeZowtP9/mPM7bfdxz/fH9fn6fz+sfH0dX13Ne
x3Ve53Ytd5Xur7R5MS4mJuahQjExea7/XWV/y+XXrpUI4e+Yv//c4vQa9N3n
KwcUCeCLi5QZPSA5fwBP+2Jwr+rN4gL4i3/3c9nNvX3UgkcCeIz8sbQ3lv4D
uMhjaR/nWMYbwIWfAC7/tuEh8Mo8Mw6eGQfPjIPn3NtHLXgkgINnS3tj6T+A
g2eL/I5lvAEcPDMOni14CPwxz4zj34yDZ8bBc+7toxY8EsDBs6W9sfQfwMGz
RX7HMt4ADp4ZB88WPASelk+fVbfg/DLKM/AOqQWH19xdRv9/4KMHVZrd/DqO
f+Pv/leuxLW43g94Bt7zl3bf9X+jjPIM/NMv3i3W6f0yyjPwZx4rfumeUBnl
GfjPRw92fumAtjfcHjxz/+A5d3niHJYfPPN4wTPzA56ZT/AMPjpUPNe3bEVv
nQAf/4+lH37/uzevwO/+deB9tcOeHMB3lN49P7ZSfuUZf58/9frn7cfmU56B
N+q4cvfva/Ipz8A7NklJz3g3v/IMfMpze3Z0T8uvPHN78Mz9g+fc5YlzWH7w
zOMFz8wPeGY+/focddv8/myXHXuyjV+fo274uVaZ/R731hvwgzWzPi/Z2NMP
4DX3989XOTnb+PU56q6+J/X08IVZxq/PUfeXJ+bdXmTkBePX56ibf/rI/K3N
JePX56h7cUfJx0vOx+9GDLf367PXv1+fWZ44h+X367M3Xr8+e/z49dnj089z
xF1Xdf2qboNTieeIu/ndw0+8VTlKPEfcewa/sTezapR4jri9D85+/9joVOI5
4t5ReMmUsruOEM8Rt++1csX29j9BPEfc+860zfPwpHTiOeL2iO04oMrSKPHs
tffz7PXv55nliXNYfj/P3nj9PHv8+Hn2+PTHHzExD2wqcHbh6aPkj2Ninht6
JvPid2nkP2Jiim7ZVu+3lWnKM/DWXfqnt7p0VHkGvrBp2SurWyYpz8DLVMrO
bjVpn44f+E995pwYd/q08uz/k648c3vwzP2D59zliVP7BPnBM48XPDM/4Jn5
JH02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02Fn02
rM+Qy2KfjcU+G4t9Nhb7bCz22Vjss7HYZ2Oxz8Zin43FPhuLfTYW+2ws9tlY
7LNh+4zft8QbxhJvGEu8YSzxhrHEG8YSbxhLvGEs8YaxxBvGEm8YS7xhLPGG
scQbxhJvmNzjjTjHEj87lvjZscTPjiV+dizxs2OJnx1L/OxY4mfHEj87lvjZ
scTPjiV+dizxs2OJnx2On/32PpAPKk75oOLgmXHKB6l91IJHAjh4trQ3lv4D
OOWDLL9jGW8Ap3xQccoHGQ/5/WegvhHgmXHwzDjVNwI8545HAjh4trQ3lv4D
ONU3AjxbxhvAqb4R4NmCh/zxSKBeF+CZcfDMONXrAjznjkcCOHi2tDeW/gM4
1esCPFvGG8CpXhfgmfHKf//7mtjDsPtpiflXe9U7JOsKfjjs1oip9HnqFzuN
tDfcnvox1I/iln60/bo7RtVMXlkshL9ZHxiXfzuW9gEc/4ZcK5MOn/zztljF
c+YhxV1+5N3aP4w4bwqGDhedUr2Qtn/aLbLriYWxDnC075+5ekNxk2Xwb22/
9p1VP02NcYDj7zdHtFy3PD6qPKL9+u3fjmv4dqwDXP+/5/rt3rEpU/mytDfc
HjyjfeMvO8YtLhuDedf243aVefr5nenmyXaNzjWdktdB+xa7Xv0tq0KsAxzt
txY9uqDnaOXHsfDjMD/gGeM7VHFKPmdgKsVjKW7eYV2/entRFPKELL+r/bwe
Glujzdcqv+JZF76rvWdEqo4f/cz4amn5FxucZf1UPUc74A/umx139MRxjXvx
38cUu9i1hPHWCf5+qHb/tTcVStf5Ylz+f8P6AJx/F+uR5ffHdSluq/c7LDli
ztL6irhzB9V5pM7AEzq/zA/WkUX/HebZH+9584V+eH798V7YbT/7fOfvCqSz
PhjWB7Sf9dn6qasOHad8J+yuGrxu3puF01kfDOT0x41hd9zSUgeLnD3OemLA
gz+eDLtFZ7VbcSFe7ZXm9Vtf6OzU+AL5flTb31b/jr1L7vPsHtqP+7bTkMTq
SaxXhvUK/Xw1+51znvyqV8avVxHvv3fbcmjC0FTWN8P6xr/rj1e98ZL9D9ht
5sEfx3rzQvqmPPvjW08fSN8M6xvrA+mbseibYX0DH9Bz0jdj0TfD+oZ+YN/I
XhnYK9Irw3qF9rDD/jzl+nzK/JIfMbAbpD+G9UftDfmR3HH1Swb6TPbK+O2V
6o9h/UF72Ct/HhQ2WI+kP4b1h/kk/TGsPzwvpD+G9Yf1wV8HSDF3DT5U5NeN
meynDOwexQkGfhD6ABz+lPyR8gN9QHv4a/I7hv0O2nM8wDj+f5VT4hN/vp9i
PoifPH7f5kz27zousv+G7T/ac3yF/26J6xSnuC6AcxyL/nk/mtoH4kDY7yKF
bn34UP1L5EeibucupzaUmH+Z7HbUrf7sV0uG/ZFN9jnqFvpo4X8aNLpMdtjD
/X456g5rtuLZrqMukJ2Muh3bPPGM61wie+jJ45c/4vZ7aFNa+oR0tVeQl+ZR
27t//mdF5aVR8oMRd0OFnbeN/Did4qKI27jc7CU/ho8QDxG3YfTnjGpvphIP
EfeOpys/sqpKlHjwcL8/8vrx8+DJ4687pbhYj35+vHH5/YLHjz8fiImZfWD6
ttSjp5Uf4An33tL2r2tnlR/gLRtXrF05/bTyALxq8bcKjogeVR6AN17Vffnx
5WnKA+PggfvB+uH4AfywPOCB5fevH2+8pD8G/JCeGIueGMyLP++LGMSZpCfG
oifGoifGoifajz8+iRjoJ+mPykl6Yix6YuEharDu/DxEDdapv96bYigO1/o5
1jvZDWOxG4r7eYga2B+yD4bsg+Kwb2Qn2Q4H7K2/fpjlZk3cPiR9dKyuK+Bt
964+1/e6X4OeAd9+cUG+pgtjqf6W5SYfm9No6nV/RH5W1zX6Bz7hnZaNJ448
r/PNOPkvtXsUR1GcrHGI5gWULxg/HvHmR/ohe2v4d4Fb5Fec7JvGG/46bZYB
b8SzAc/oHzjmxV/nzDKYx6S/5/uq8JPkHrvjGTOi8U7jNi1eeUp1xAvJbsUT
m/u1eOG4kfaG21M/hvoRfpKNpR9tnyPfcRe/++nWrLtviks1/7j655KVA/I4
+N2bx07ZMveLk8BD6Ae49GPwu+gHvwv+drybNmdBmbCJvnO8/4Dk4iH8Df2X
fzuMT9t286GmU4rid92/bi53z46BZwzhBjj+f7Q//ejZ6S2mnTR/vDh8w7Vr
BRSfmTpldIvYdMYNcBpvgAeMa3+fSr2ee/Ck2IeLyueykx06ftXkT50v5iHH
vp1Xfag+cG3VDQ948wJ88pE2J7JmnmTcAEc7/B2/c+Xkj3W/W3EDHPOE/z5w
7u0Hyw49w7gBnmNXzyp+6tkLl5scOazzi/F+0HRAl1UbD4EH7X9IjTbtK3dI
YtwAh/6j/dwqk1ouSznMuAH+5vfx9ZJX5tP2CR37fNL2zTOMG+AP3dqsbfVm
hbX9r+2TLsZfHw/hBjj0EON64JcFjzxyJUVx1ivCDeG6HtEP9IR5wL9zn6/L
io955dbaX5/eTHlWkln0/fCLx/oe4/XlWNaX4vBbsOdxcxqcHBlO13mH3i0s
N+rWW5qkqV+EPUfeSnriQk8QT3OeS3GvxhUUb7j+eOO86luNSNzI7kmHNE9k
u4HftYzLzX1ccerXsg4v3XHsm6jaQ7T/qtg7a7u0z1D7A3k2vdNo3uG708ku
hd3SaxbXmjsuDfoWsuih9lPx/uMDarTLYP1hPdT+b67SecXzB06pHVN5dl4p
OfK6nH77FnYnLFjS98LodKyXkGUdaT+rWhz6MFTbs4fAC1+Ktk8vkEp2Mux+
MubP7/OnnFJ/xOua9N8lOxDi9Q47yfPut59hN7VYvlfr7P5D55f1EDj62d/y
47kTnj2u8sA+j/5x8K51KxqRfl7v5633C67bupnttoHdpt81fv3XdR2wz5Cn
YWjW6PD1effb7bA7furAWx4fre0Nt4d9AR73bcE1v9diOx92L33fqtWq8Wnq
ry3+xXA8QPbHhf2BvWU98dvhsHuu8aZp4Ulp0EO1n+R/HdZb2GdeF367HXZj
t7xc56NRuu60f4oTHF6nZD9dsp8Ory9a7wb90Po1JKfqM/kXxdlfwE5a1rUB
P7RODfGv/WNdI95G3Ev2LYT5h31D3IL+yb8rjjiH4knj159kxUk/db0g3iC7
bWC3ab0YWi/GhoNPrCP4KbSHHSD/YsjOGF7v5DeNxW8a+BfEP8wb/Atwsqvq
3xF/0rrTead1ZMj+az9Yd7S+VG9pvRjya9oPxdvaPvd4ydNn4Lnfi8lSe9h3
8BvxJZftN36/HhNTa1rpZ9bXPKnrC/j815ZuKRV/luoJSW6HQtuq7L+T6wxJ
BjjWC/oZeSpu2EuVNO5Vv/DN1Aat72h+mPWW42dtv3vGvZ0q3nZG9Qb4Gzt6
75+w5CzbYY3nSd80LwCOfgpvbbNpw7XfKV7y/BThBjj0ivMX6ImO95Nic/J+
e5bqHgE+HeYTeoJ+fri7Ut3tN52hfYpkw/Nrq5NY4thA/ZnaB/JHlse/D+XZ
f9hb5oHiAcPxQO7zclzxbqPvrDKplpevsT6AF9Yf2BPWQ7Inmm/696mT3W9j
7n6kY8J+bY9+EOcgzwI+vN3GogfaeHkWcKwL2A3gWHf+fYpkt1urcW0qGG+9
oz3Wr39/J9mgvX//zst38P8D7zT0pqz/0TeK/1lPrOdwEOf79wHVP3L8H+L4
n+JS9Rd03kP3GemcgNZvqa6r5weonqN1IX9c4cU/xKfy748HvHjMH2+H3VfO
395m9oIjzL/Ge2jPeuKPe8PuqbRt35ydfUTW0QXBl5nVVRtMzuP+KPJkKv7Y
uMw3a3z5K8+vi/klP67xsN9+ht06VUo3Xnb0FPk7L9/x+y8vL6N8zeSer4UN
88x5N+VZJvc8K2zAv7+OnWywTv11nrDBuPx+J2wQz1M+a/z5rOYRgfgHOObL
73fCBvkU1Xk0DiQ7o/JTPVPrkP54JmyQJ1K+YHLPFzw+KU/nONbhOJbyBZN7
vuDNO9kxtUvol+05xclaB6P8VPmE/ue032KmVVlWpX7nHcobfmfRxLZdSrdI
M7SvzefEdP8U+yOwV9CLpL0Flg57IYv3u/l8mu6rYt8E6x39PDa5QL3ty739
+skdHnyo1gTUQb395dYdm72U+LmHo64+L3bxx9VuaA9765gV2xbf0B7rovDy
A8VOfsnto+7SZ3of/Gke4xF3ZkK13/JP8XDMU+mjY3+/8EGgveH2iOe5f+h5
7vLEOSw/9kd4vNgXsPDmMG/Es0PtwbNDvwueFSeeFSeeqb3yTLjyrDjxzO0N
tyeeWR6TuzzKM4/X4fESz8ybw7zdP3Xw/trLi4ZWJT2yePZEj/9TiZHuL1cs
GKr1TONmNW6Yr1+azClU+9M8IfwN/IlyrZtnV/7L7fL6+gbrv/DwhgOPjUi9
eN797MNvXnv/3x7eucKW4W8MPeE2jx3f78epHt6t6JATNauvc/+T58zOXuM9
vPDuiV+Hn9tnTtaJvfuTyR6+e2L6upMNzprvWg/qc2W2h98+cmLihh+yTbE5
+Z+tcIPelipadsmYrBhnS709ldfP9PCfx1zpdW1aPmfPXRNGTbmBh59/+mT0
0rsKO590mDLq7ht4eLVzg4LHvi/uzKsytpT5NICHBHeon5D049DvhuR3FRc5
QyKn4jIuV8aluPDgCg+KC2+u8Ka48GyEZ8VlXozMi+Iyj0bmUXGZdyPzrrjo
h/5NeuWIXikueuiIHipus6s2vbXZZ5s+2+yzTc9tdtum/zZ7blsXNjtvWy82
+29bRzHyh/2CbX3Z/IVt3dn8iG092vyLbZ3a/I5t/dr8kW1d/2/9lM0O2PyU
zT7Y/J3Nbtj8nc2e2Pygzc7Y/KPN/tj8ps0u2fypzV7FyB/2szY7ZvO/Nvtm
88s2u2fz1zZ7aPPjNjtp8+82+/l/9PsBe/tWlaOJ164F389Bfsd1J+Dcvu7i
kr9du5Yn0B44t68qcTi3B87t90l+ze2Bc/vqEsdze+Dc/va/8YOWd5MSEhlH
+9zf/0lIZPy2nPaBd5OAc/uKkrdye+Dcfk8OD4H2wLl9JanPcHvg3P7BnHkM
1LGBc/u9ks9ye+DcfkSOHgbaA+f20Ft+Vwf6yTj0kHHoG+PQK8ahP4xDHxiH
PjCOeWcc88s45pFxzBfjmBfGwT/j4Jlx8Ax/8mW3N79P2l7G8dd/4kJDwh2m
Pra7jPIMfNCpzX++tLKM8gy8T4/FfyR/VEZ5Bj50ZtMdvUaWUZ6BNyn8VcGn
p5dRnoEnDf564fm1uGedkAgc96zBM7cHz9w/eGZ5wDPLD56Bvy7j3eur53j8
gGfmEzzDDy+Y/enx+qvzO/790MvumEM/bywRzq88A39mb3rC/d3zK8/Ae/71
ZcVa4XzKM/DSO/uXPD4jn/IMvNm0x/d3SM+nPAPvtqlpscpT8ivPwPFuAHjm
9uAZeHPpHzyzPOAZeA+RHzzzePf69gE9fsAz8+nX56jb9fHY/IXiLlM9M+pW
XPtKnZKDLhu/PkfdYismj2534qLx623UPbRyaezTF3CuGnrovS/k18Oou/GT
gsvGj75k/HoYdTskt+vywr3Zxq+HUfew9O/Xn6hbrcmkSHbmJeMfV8QdeN/M
+2as5vMwETfr65ueKNI3SuOKuHnnHxs/5NJZkt97t8cvf8Stnb/Ax3vPpZP8
EXdPdr9rV8+dIvkj7shw5V6tdxxROWPkz7in35t29MgZ/d0Y3590/V0gW97u
VXVHXCqP11jGayzjNZbxGst4jWW8xjJew+NFvFlV5ov0zVj0zVj0zUDf/HYy
atqL/pAeGoseGosemqHbqr2UdHdADw300G8Poyb93Xve2Bq6YPz2MGq2tK9c
f1/SRUP2zVjsm7HYN2Oxb8Zi34zFvhmLfTMW+2Ys9s1Y7Jux2DdjsW/GYt+M
xb4Zi30zudu3OMfirx2Lv3Ys/tqx+GvH4q8di792LP7asfhrx+KvHYu/diz+
2rH4a8firx2Lv3bYX/M7HhR/Kk7xp+IUfypO8afiFH8qTvGn4uCZcYo/Faf4
U3GKPxWn+FNxij8Vp/hTcYo/Faf8NMAz45RvBnhmnPLHAM+MU94X4Jlxyu8C
PDNO+VqAZ8Yp/wrwzDjlUwGe+fwA1QECPDNOeX2AZ8YpTw/wnPu7KJqPB3hm
nPLoAM+MU14c4JlxynMDfPrjHY9P/zkdj89v3myRZ0p1710R8MnvjYDPP3ct
a1a9mXf+B3yeo3NB4LNwnVsnrxwQrG/0ttQrRpL84JPlB58sP/hk+cFnMskP
Pll+8PhzQpP5KwcUUBx8+s8xeXxmlP72VNMpBQN8FvLdy/T4rDygXJ3klR4O
Ph/2nb/z+Hxq44ghA5I9HHzGW/L9JJIffO4j+cEnyw8+WX7wyfKDT5YfdqA1
yQ+e87Ve9MGA5LjQ469Pn/bAinLKM/bb5+6ccOjTmTfreM9KPruW/Hh+6eez
a6vm11pYTsdbUfpZU7/kpQKdb9bf/eRvvbriju0S6lX/UEH93bVy7qDlpFu/
WFmwiM5vjp785dbsUf/KLf8pqvOLv/tmrHzqwovFdX6/nrnvStMpMaEBJYY1
KWJK6vyGZP9/TcQpeHRIKZ3fPZmPPZ68MjY0Na3Q+8V+KK3j7SV55TSKD6eJ
/Em7xzZPiy+o410n8nc5WuLAA7UL6/xC/ntSi9w1u3xRnV/I/9uOhu+cGVdc
5xfyF/2y2uqhH5XU+YX8Zd6sdXvaqlI6v3tF/pUxvTMa/lRaea7wN//n3KFf
9Os/Kuaq5iM4xxEK56/6W9Nrmo+MkHMcjw7N+8gjkWuaj+Dv70Y9N/Tivljl
J13y0yuUd1SU332p/cqm/3j1iuYdLeV3C/xR67nYw1c078Dvxnf584G7hv6l
+W+9v/X5khud3mpS9rv5dFzN/+7nqDvmhV9+Hv9D1PjjsePuk3VnPBV333nN
jzIkP+1Jed9T0s/ojeWz5+zPUHmK/L3uTrkNQ2kXSvb08tADOee73PgnYj8+
XipN+8+Znx8kr/Xy2bzzc9qXz9ujx7Y6Xj/V5b9vzlNmUO2aGcr/wr/l323C
96Wu3/dWqvafIvlmd5Iffy+72mH50gHp2n+OnmSYopeS1675+KLyg3NSNYt3
+K5EUrb+7s9/6+0ZE3E2vFXm00z93VTJ7y7Q/K6R/itsGHbpuyoXdX7VD0ey
Bh8sm6l8utJ//tMvfJm3W4bKmXOO6ZJJl/mFnDjXuaaxGfOvR/OqHdgr/S2p
3nzssE5xut6H5eiP+VL0B+u9Oc4Xi75hXD0kn5pM67quyLP8jlk35W+UT9d1
fpFn88RZmzbemUfXtfpDWRdY11/LueDpZRdOqPRjjK7r4SJnfKn6/2nRNkb1
WeyP8x9Zv+AB56dKyXoHD1/l2AeniNgH2BH8/haxJ+AnPcf+mNvF/oCfn+Uc
XEexV7CHU3Lsm0kU+wbezkh+FCL7v1vk/1jsJ3iD/KvF3oIvyP+S2GfIjb97
iD0Hbxkif1Wx/7CHkL+Z+AvYjY9F/rfFv6jf6XzwherNgnmc/1ywF1f0yPvG
TVOqezh4buF7R8GLKyAvxwmLLHnZFJIHvA0necAbywO+WB7IwfKAB4lnAjz4
z0F7PFTKiTcCPBTwvRvh8ZCeE88oDn3DvAGHvkm8F+DtRUue1YrkB2//JPnB
G8sP3lh+8MXyQ26WH/oWIvnBs8ThAZ75XDd43pcTJwd4XkvvKoDn+Jw4PMDz
VN99BY9nkSvAc2VLnlWI5AfPLD94ZvnBM8sPnpeQ/OCX5QcPWXLOeZa89wj8
uOCfCQ55vsjxp+6LgxIvbh60V+1LVNrj3UjgpwWfmnv/5jPCRR4DeTAvneQc
7O7STdeP2L5V8W/Ev79C8sjvmqkkj8ip71uSXoVYD4tY8BGU35H/dfds+Ff3
R3t68ZXEDy7HD7gnB79McYWLuAJ6WEjabxW/SX7Zvf9Em1Zr217R9vq3xA/Q
24dFzh/EL0NvxY+78ONof5vEnz0l/lQ7I+OqJHEL+pE4x0Wcg/ZNJT4cIfEh
xQku4gSKi1zERZjHeDmf3ETOJwNfJHgjwnvLfY335Z6F+kXBxwqOdQT9+lbi
Ioo33Iclnge+Picec49KvAc8v8S99Yotf7B7atRgPWIeQzLvwDGPP0keARzz
eIfoA/CFEp83l/ic4k93Y3TwXa+8nMnxsBtz8el1PRqm6jqC/IUlngSeT+R/
ROJ2Wncu1h2tUxfrFPqA+zJ4Jw36gL+XS7xNca+LuBd4Vzk/vy31jwKd7zrB
8bCLeNi/j5DibqzUcc26BmeNfx/Bu9fjr3tH3DlyvwbziPEijwCO8Y5d8++3
Vk86rXlWkuhtCVnvwJuI/r8jeZZ/3yHsdr+yOXNUi7M6XwPE7r0v/fv3EcJu
pdtrda29YKfazxj5s1PegfTvL4Td43KPA/2g/X3VH/jXwHrLtH1/udewXXjG
PKIfvGfo33cIu5mFPvp0/ttndL6y5P5Litxz9+87ePL7+Q+708nvDBYezote
oT3k3yzj9e9HePd6aL4M5ovm12Bd+Pcvwm4PmReaL9OdcMmjjSWPNk/SOs2x
A6fMv8Q+0Pwant9ucp/lPdFbrdcIPl5w//5R2JyTeSG/YOAXaH71vUqy2wZ2
G+2lDmBQByC/YOAXqD5gUB+AnizBfRa5l0R6Yix6YlhPpM5gUGcgfTCsD2Kf
Dewz2XMDe076YKAPZIcN7DDZbQO7TXbAwA6Q3TCwG/793xSzdfLmnfkHZ3Ld
yVjqTobrTmLPDdtzjBf2H3qFvPtx8afAlwje1Pceptp5w3Ze4geD+AHtpd5l
rlCcIPGJ+YHiAamDGUsdzNST+Me//5tihreuuWhQ3ixDftawnxW/bOCXMS+3
yu8Okrof1dPMHxTvcV5AcWMAL0J5AZ3rU5z2mzT+pPMM7hA5h+C3A1F3g5xb
oHMIep+LziHouR3/OvLO+fjPIaS44Nlvx7xzLH45I+5OOQfilzPi3ivnRvzy
RNw4OX/i38dPcbEu/HJG3Ew5x+JfvxH3dTn34s/nY2LK7pnT/F9TThn/Pn7E
/FviAZLfWOQ3FvkN5Cc5jUVOAzn95zRSDOIZv5xRM1zmkebdYN5pHvX8DJ2P
Mt3kfJd/vz7LPX7bM5/E946lffMst/b0hFvm1fXq2PzeoH//Osud3mZX0bRP
Yun8njeP/nMmKe47F6YuqvT7eeM/T3I9nhSc1rvqIflBt9i/WxWu2/kMzUvY
/aPGB8/3LJ9C54jCJllwP89hM0P8DsU/poT0T+vCsDzALeMyGBfpecD+470E
8En86zuE/nMLWaaOzJf//ECWwfzCPuTkoUsTf5H4CjycFv1EnEztH0V78PyX
1Pnve7H91S6bTynPUv83DwgOfZC4121/57Xz5X9O4/0Cg/0Cam/QnuJnF/Ez
/a77AMkDO3CT2AGsu3/IvG3Ne2xJ/suH1H+dpHgYuOxfPJrz73Rubzh+7ihy
fj/64sHWF1J5v8Ngv4PaG7SHHzwu8fZpibcxL6li92bJfFFc7SKuBr5N+Pnr
VLveaQ2SGDfAwY/Mr1kv9/f957tSXFOsyXPl3UC85yLeA/614AsIxzpdVKTH
gE0TjnB+4SK/IB5c8EB5kFkg/ZCfMuynIH8DkR848u55Iifwb2lc/vNpKe7N
ce0y1hU5r3gryQcfKhd/Nu18Ou9nudjPAo78veTkWdc2lU9XvUX7rZ+3bDpk
WhrbMXfDTxvS0x7w7FjOOnUTd8k6pXl0r8n8UvtHd1FeeUB4PkY8/yX4ScIH
SP5+QN5TAt5J8L2C++clyV3y9IA6A8ts4N81lt81+F2sO9nvc7HfB/y8JZ+V
v93PW3576N3OHr5U+L/c+eV7P+ubpn4HPMyQd5OAg4eZhIOHzfL+EnDwsFFw
2Oc1Mi9LxO4Bf0vWb0exe8DvEfm3iP4An0P6Q3plWK/gd24RvfWfI00xqKeh
PfLff4o+k/00sJ9U/zEzhGfg80WeLOEZ+E6xMzeJPQQ+UOzhUrGHtH4N1i/N
u9ph2I1uUvfAe1/A+wp+iHD0z/ZN7JhZQPms1M8N6ufA7xAedgo/sA/gbbOs
a/KnBv6U9MpY9MpsJBzryKK3+g4Y6ZWx6JXqD+mtseitgd7649tkt1jtU3Ev
XPlT5xF+eZG8a0T64Fr0wYU+AEc/m+Q8vL/OkOSuFDtDuAHu36+KiVki7z75
87qYmA/kfL6/DplsSsi4yL4Z2DfoD/pZKuMlPXGhJ8DRvqvU8aDn6B/v5FC9
yP2Q6khSX3Lfo3UN/2WxAy7bAalruahrkX1wYR+oDm/GUj22N9kZqtNq/En5
mvtvwk9TXZfieXcG7Tchzlwg8Qzxqe8OUTxgLPGA4TgHcchpqcdSnGZmUf0Z
7deKH6e4wljiCoO4gs57uDjvARz7U5OnffX2rFbZhuo8blOq/0hdyOW6EOoD
yEOBYz9oqOD4XX/c7e1LtvR958Hbn+2Zs18fqHuM8L3P5+3PyvkExbFe+HfB
P/8u+OTfhR3g34UdmEq/CzkryPtDP8r5Pcgp5wadKXLeD/2j/Sw5N4j+80p7
I+cMMZ7ZBU7N/3VakM/ww7t6VL7hnQHwWffg1dv/MT9PQM60RfO/mzDrhncJ
RE7nq6tO5IZ3D8Dnq4/WLpM4P8jnXRWr9Rs+x8PB57Tubfud+MTDMd41w+a2
qnnDewIY72v5/7xcYWJQzvCdV5/uOueGe/ci59N522/o+rGHo/9Vz+yrdON9
cPTvnvn8UOOPguc6BNffRd4t/Sie83dCIr8XgbhR5FEcdkDkD/Hvyngd/l3h
R3HMu/CpOOZd+Fcc8y7zpTjJrzjkl3lXXO1Yjp4orusrR68Uhz6IHioOfRC9
/T/z/9/S//9f8/7fWkf/LX37365f4lnx/5Z+/m/tCe7h870G1PEZx31yxnH/
mXHc1829fdSCRwJ4jPyxtDeW/gM47tdZ5Hcs4w3guG9jwQP3F8An4+CTcfDJ
OPjMvX3UgkcCOPi0tDeW/gM4+LTI71jGG8DBp4U3W/tAnAY+GQefjIPP3NtH
LXgkgINPS/tAXAc+LfJY2ntxMfPJOPhkHHxa2of0vtebXc21BvodaMUjNaa/
VHpZceUZ+Gf79tbtbvR784rvzXdy55ZlxZVnzefcUldv+Vdx5Rl44vaD2et7
F1eegb97dEx0QRz2G2NigBebvGXTzGdLKM/cXu9pU//gOXd54hyWHzzzeMGz
hTeHeQPP8D+zB25cXXmXfrdb8XqFb+nZ6E39Pr3ix4+vn9m6q/c+BfD6dV8q
MHREnPKs/a8632/isljlGXgk37z6x/7yvs8FfPfyAufGD4lTnoHHPn3/j62y
45Rn4Ldt+uWhrL/ilGfuHzznLo93rh/yg2f1zwd3XFu1y/t+PPBQ1SUPLu/i
3d9j3sCz1ml6fRoza2y2vqsC/J99104ZPA7fZ4xTfHKXianvrMvUdyuA7/zi
vaSRQ8/p/jTwUwPPFmh8h363S/EWRY/XONvZq4Po/aT0vOESGdlaL+D24JP7
B5/AB70xoes/q0GeOIflB588XvDJ/IBP4LVqPD9mcShT3w/SfcvmC4s1n5FB
7w0lJD6wqcDZhaePKs9o33rw+OZ7ZmUoz8Bf2/FIxVcqpCjPwKtdju/ZarD3
/R3geyfuM8XmHFOegT+RWKf+D+e9+hTwwXcc3TagVlR55vbgmfsHz8AfX39o
z7z2h5Vnlh8883jBs4U3xac9vDC/2Xda+UT8+DHhiB/vlHmBnMB/E/3EfCGu
/Mm/XhSvK+sF8wK8HtkT4DPIngA/SPYE+C1kH7g95M+9/ziH5QHPwI+IPQSf
PC7wgDi6Avk14PvJrwH/hPwa8B3k14A/T34N+Erya8BHkl/T+wrk17g9+OT+
wWfu8sQ5LD/45PFCby28Ocwb+OR7KOCf71OgPePgn3Hwzzj4z7191IJHAjj4
t7Q3lv4DOPi3yB+4VwL+GQf/Ft5s7UN8jgt8Mg4+GQefubePWvBIAAeflvbG
0n8AB58W+QPn1sAn4+CTcfDJOO6lc36He9SM454z47iXyzj2GxivJnafcVfO
XzKOe5WM455hQE65h8Y47okxjntNjOPeOOdluNfNOO4h554PHg/gVcWfMV5A
zkEyjvuHjOO+H+O4/8Y47jsxjv0GxPPjLyybuatdcaeP7DMB39j4Ur7dvxR3
cE9P85HuK2d2L1rCwT004E3zDO1e7bq9xb0p4O+/Gbe0zrHiDu59Ib5N+OCj
z95LiXP87zskJD479Ezmxe/SjP+dgoTEYlu21fttZZrBfX7gbbr0T2916ajB
vXfgK5qWvbK6ZZK0jypeolJ2dqtJ+wzuVwNf3WfOiXGnTxvcWwbuCn5G1jXw
8tJPT1nXwBfK7+LeKfBWIqf/XmVCYhEZl//eYEJiO+HBf88tIbGuxKV4rwHx
1aUvV53/8acMfdcA+PgF3aOHR6Xq/X/g7RYVHda7VUTvvQNf++qExrNvPqr3
zIFfbPtU+ccnp+k9auBfLGz73P2Hj+s9ZOD1R6VWevDKIb1nC9wceWD4Zy+f
0nukwAd2XXLf83dm6D1J4K8nH+n4++oMvdcH/M0hKy5tfThV32tA3Jg96Otn
k77J0ncNgFeKjanY76dzep8f+OZij+6bM/GcnpcC3qBQr2NvD87Se9TAG8ZE
Vu+uek54iNU66DMdnPif9pzXe7DAd5Y/M3dV5ILe89T7NzXzda7/c7beSwT+
dscBTzRenKXvLyAOXJpZ+etdr8Y6eHcA+K9Og/uH7451Cst+MPD+5WNb/Tg8
zsG9ZeA1yg4s/VnpOAf3coGXvDN11Oup1+MquXcK/MD0QQ2rZlzPb+WeJPDZ
5WtufumFOAf3xBBHTfy0QcdCLTx7Avz1l/semzbXsyfAj79V+JUt1+0D7Anw
fm2SSje4wZ4AH1Lj/KVDRUo4G+Q+EsdpuAfLOO5tMo57mxyH4L4i+wucO7fU
mQM43sGB3ZsnvIk8ig8o/2ypNh/E6fsyyFvfFX0QORVvPLvvlFKHLhi8q4J+
Dst8CQ+Kf/BOjSWPXcfx3oq+byR6iPtpaF9y0aSfGx6MdXA/DXi5oxU2/VIy
Tu/FoZ/HZb18K+ef0L7/mavd7k2Kc3D+EvjwjIQZH/4Z5/ST8yjo56GsQWml
8mYbnPcCfn+5NUWjK7LN83KuhfuR31W8n/zuITmfgX7uk37kdw3/rrxjon7q
9KgfT5tPY/GOidYTOsp6l31rbZ+v7fcnG30Yh31rbf+H2AHoJ8+LzKPD8yjz
5fB8Ie/g+gb2y/l3ce8R+HaxezhXwfOI+xvcHt/PQr7f9bZiKVfnH4N+Oqyf
os8O63Mv8vvPib9bTH6/qPjHNPL7T4s/xXdzgG+X85Np5PfLib/G+XjgE77t
NCSxepLWVYCvEb+P8XL/i8mPQ85e5McxLowX/itV6if4Th7bf/Cg97qkDiN+
JMR+RPxOiP0O8hr000jqRbj/ye+fxMgf9b9Sd+oi6xTtH5T1ki3rC3gtWV/I
g9DPDqlH4R4a+1ncL2K/jPwI/QygOhXzA/6ZZ3zHCv3XkPti00VvgT8meov5
An7lxZy6ovjHEPtH8aeKx4odAJ/oJ1Hqpbjnj/Z9xF69LvYN+BCxb7h3B7yU
2GHwgP7vl7qovM+l/vo9sTPwU1x/k/fRtH1f8Ue4n2/JNwM47lkxjnfWYAe6
Ddm+vEWnC/o9UOC9F4eb/A8/OPem+9h9hidMT8rUc+rAf8x4v/EH72XreS/G
sX6Bj5nUc8f+O8/je15ql6YvLXf1464qj8PyQH7YvX37Jve+eNb7zinwb8ot
KvU/6wXfBQN+R9/FmQMvet+v1POSX98Te/jZwzpe4I+lZme2vSlFx6v9N339
hY9nZuh4Gcd5Ne4H42V5MF6WX8br8Hj97+UlJM45MH1b6tHTygPwhHtvafvX
df160nfe63oe1Lhi7crpp3W8wKsVf6vgiOhRHS/wxqu6Lz++PE3HyzjGy/3g
vg3b+Sd978548hT0vaviyb/O9w6IN17wADuzh/QBeDzpA/Aawj/8F/DnxZ+C
H82nSB+0f9IHxsEP9wN+NH/8KkcPwQ/LCX54XODHxgPsTA9ZR+AB+BRZd6jX
AX9F9oPAD/CRsn7BA/AVZAcYBw/At4k9wbhYTowLeCexV2lUN0CckEb5PuIT
xC3svxBvsF+G32d7jt8F/oRvfy1iGIcfZP+F/mHnB8i+JPwU8L9a+/dJge+Q
fVX0D/xz2f+tRPEY3g1AHU/3raQOgPwU+MFaV8P1TxxHPUfXL+o5/ncJvP6l
zhDiOgPeJQR+QPpvJvUNtcPP5NQ38I4e8DNd/iw+u0Eq6k46v6g74b4910lw
D1zjEOkH3/FEPzvfTZuzoEwY7w2pnZwrdkbqP4qj/rOe2s+U9gUsdhh1TuD4
3jTeqcF4G0vdBt/TZDkXUfw8Xexqd7Ln1cUOnyR73kTs9nmy540ExztukOd5
qVOdw3twgn9+YNuTmRWOSh7k6cMO0YeWZOefEjtfyGLnUR9G/yOkvoS6B/D3
K9xWtPj4NPCv/YB/qVOFuE6FOgDwt6WfNKorIk9B/sLxM+IH4JlLP9/ZZ+Bh
teeQ84rgeBcA+K9S33tL3i8A/sPlp8pNbB7Rd3KB39rpvSf6vpCO+qTqD+qT
hSz6hvdn0c8gqeMhfgb+yritparliYL/kIX/EPOPfQ3gl6X+iXdpga/b277H
9uv9L6K8EnXXlhSfQE9wrl3ll/ok4nw9r/pgx7Zzu6Yb7KcA/7H/pvSXGqWi
Dqz9ow7ck+rVqBvjHSjLfLk8X31o3VWWdYf3etC+7LxFTdv3OYXvj2v7q+tz
vj/uv0+boO+CnqR1ivWLe0Hof0fXy1nDrvOMe0HAV77fudOGxAy0N5b2htvj
fhrw6aPKXll/ewbq9ioP6vbdKQ6E/RE7byx23rCdf5H8TrzMC/abLPrgsD4U
sNgZ5GWsn9i3sqwXh9fLWrI/8BeoT6L9L3KPDPkdr2v/+xfeuRfUJ2Fnykt7
qc8rjvo86pDAXxY5UYfU/QUZr9T/FUf9H/dA9Nyx8Ik4CvHMBDkXJO+Eqj2c
LH4B753xfoSe9xL8V7nnhTon+2vcUwWOe5S4pwp8qugn7DbkPCrnnVD/RPsV
oue4fw48LOsC98+5Pd5n4f0avNMKfLnYB32HguQRHgzzIPtHGs8niB1D3Rz4
JrkvifonzxfqnDzvqHOynsh77opvFL1F3Z71UPypw/406nufPSGx1rTSz6yv
eVK/Iw98/mtLt5SKP6vfhQc+8lTcsJcqndHvuQP/Ru4Jnqd4ppEvD01WfPeM
eztVvO2M3m8E/saO3vsnLDmLfUnFsS+5iPLW6b681XsfusjWNps2XPtdv7cO
HHHdH779jOvyyz3Kab53KhMSf7i7Ut3tN52hd/M93L9/7PWDfXCWB/vgwPF9
dtzrYx5wb5N5w7vPzD/eLeJ4FXmI+hfRZ7zLjH7g77DPDnx4u41FD7Q5bPzv
6nr64H9n1tMf/7uinr7JO79ap6om+49435DXKepUXAdA/sv1drz/bsmnFEc+
hXodn9N7keIQ+Dt8d575ifH98eIE9AP5H5VzhrLvrOPCvjPed2a7Df/L/WBf
hvM45N3sF+DX+Pwh3olj/ZS8Q3mmvENx5B3wU7zvg/oG1xXlnqHi6/YWWDrs
hSzdvwa+XnD4NfS/TPZ/oQ9cz8Q7+7r/MrlAve3Lz2OfWvHHBYc+2M7P8z4p
6gaMwy8zDn3IvX3Ugkcs71HHxFjaG0v/ARx6ZZE/sC+MurrlHGAAh74xjnyK
eUaewjj0jXHs+zOOfX/GEYczjria8SR5n45x1GcYR9wbuOcr/p1x+Z5KAP9T
8gjeN4c/4vNLqeJHGO8pfoRx1GlxHulNOT+AvBX4a3LeAPmg3quW8wl4xxn4
v1Mv9uj8UAkH+RHwjHHPtjtSuYSDfAT4MDn/gPf+gE+V8xJ5JR/R+wJyfgPf
CQC+Xc575IwP9tezw/guDsdR+K4Dx5my/xXi/S/wyPtleA8I+L2y3yf7g4b3
B6H/8M8r5NwX9B/4WNmfgn4Aj5d79NBn3hfDex+8jxYSfQZeVM4zQB9QR3xH
zqdBH4A3lPNs0Afgo+X82znRB31XQOYd+gB8hugJ3hUFHpLzddAH4GPkPB7q
RWxPkGcxDn/EOOqfjMdL/sJ4F8k7GMc7nowj72Ac3z9gHOdb+LwNzqUE3quX
+Jxx+LvAuR2pbzD+Ct4/IhzvszCOcxGM41wE4/iuA+N4X4BxfN+I90nxrgHj
+F4O4/jeDON4H5nx2qivcXupzzCOd1QZx3udjOM7FozjPQXG8R2CwHjF/vC7
3IgbOS4C/xxvg3/gl+V8IN4HB/6EnOvTd3sFx/u9eG8XcWCFrKGFZ7Y4gX4M
94P3JtAe5zDx3jrsMPpBnMbnCSU+1PgW5xvlXKLaYZxLRPwPu3dczi/hPX3m
uQXVyVtI/bMF1UWB430TzrPiKW8dJ3lrH6rLoT4Jf891Kth/4NulzuB/f9ur
88fTfgR+9wyd/8F5Xbynj/6/lPOreCdL43yp88TTOR+cQ8b3P7j+3JvO/+A8
M97/xbwXlXqsnOPVPAXnePGeGvrBOWQ516p+FudaH8T3OGR+8K4+7D+fZ4N/
57gL/DMO/hlHv4xjPTBO3/VQHONnHOMM3AsQ/WYcfpRx+CHGYZdtPOR+nv9a
IP4ED4zrOTzCwQPjGC/jGC/jGC/jGC/jGC/jsAu28XLcru97EI7xMo7x2t4F
YhzyMw75A/mRyG+TE+N4e1HhQQtbe+cRgf9ceMC1lp97+3zAJ/Q6XHxnCS+v
A95hS9zpK5nFVR7g6Wm3/9rQeOefgP/rctOZ4+/wcMjVZ8aT8RcfzuPwvvYW
eg8W66OT1H9sdWyMC/j26Bd57p10UuNL4B2kH1tdF78LfRwldQb8LvD5Y95Y
u6n+OY2zgX8pOH4XeL1a83pObe69owW89px6fWIue3kR+tvyyIDNhd+NVb6A
J3x5JnLbJu88LvCjTq1GA+p49wOBF9peI6P7tVidR+CrLr1b4WvXu7+teUG3
cw2LPeHpCfByc6uf/WaMpyfAO7ZMaFG3sKcnwA8ffPv9In94egJ81PSW1Vvf
oCfAl73Y+NuH7vf2oW3fb8r93l9CouW8esCOoT3j0APG0Q/mJ0HkRDvgY2Vc
WIfATwgP+F1+9wC/C7yr8An9AH6r8I/5Az5O5quuxQ+inebRolf+75xecE+K
/uj3oQRfLfqGeQK+TfoBDxyv+t+PPeveu6747rEHvPfbgX8t6wXyAK9B3yUE
vojaQ192yXq31cP1+33y318U+wNc7bHYK4xLv/sk9k2/syb4s2IPMb/AC9L8
Ah8rdlXjGMFXiR3W76AJPkzsNuTkvBJyMg45GYc+2L5/xzjkZ1zrHYRDfsYx
Htt37nhdY1yM+98b9HB974Nw6JvNbjCO8TKO8TKO8TKO8TKO8TP+liVPAQ+M
6/c4CAcPjIMHxvWdQ8L1PEqu94ITEhkHb4yDN8b1e7KEgzfGwZslX7Z+/8L2
vW/9/nCr7xY2ucnLk/W9lE3G2XbKO7enefdreW9JmuTlt/j/Hnu71oejv/f2
ldH+0J33zVx+2rs3DvyeJwtvKnsyTvnkd0UgP/D5b4/evPv+bI2T9LyE3FPA
OMH3XGlvq2fq91NE3s8k70P/aP+TyKPfSRG8gYwXcuK/411x/K6+LyvjtdU5
8bt8DhNy6r0D4VPP3Qq+VOYF8gG/ujFnHsG/+hn63hnaLxB9gB6C/3ckDoQe
Am9ausuddxXw/CX7HbQD3nH+yKfWVz+p/QCfEz7R7Mxv3rvfuo+5ptCSdYcy
KE9ISMR3BPzv+iYk8ru+wN+Q93sxL7qfSP0Dny3yoH+Nn0V+tMd/byw8QA/B
x0fXWuxNXu3NL79H5H+X3tNz/B6vL/CC361Pegh8nvQDHHx8QPL4//beAcbv
dJZ8ges2rOfADxGfwLdJfuF/dzohEe9O+7+blpDYTOYLPKCfmbJO/f4jITH3
96ITEvFeNHCuO2FcmgcJDjnBZ2X6nhffk4I8rFf+97ETEvE+tj8OSEjE93Ew
T+hnK8VvaD9OxoV2wLdI//CD+P3uMo9cT9tF+SbvL+PfHLegX8bBA+Pg3xb/
cP4Ovcr9nbqERMb1e5eEY/4Y/3+wYUkE
        "], {{
          {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
            GrayLevel[1], 3], 
           StyleBox[GraphicsGroup3DBox[
             TagBox[{Polygon3DBox[CompressedData["
1:eJxFm3n8VtP2x59znjN9NU+U0iANyFSEBpWpEUkkkebSYCpF0aBSokFlSmTK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                "]], Polygon3DBox[CompressedData["
1:eJw1m3fgV+P7xs95n/kR0ZQi7bKV1UBmSyolpT2ppFASSVpWe5BoWaWM7F0i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                "]], Polygon3DBox[CompressedData["
1:eJw11XmUzmUYxvGXmfediZKlyTZkyNJCy0QGYylUlmKQQoYRJWvLSbKGiUKr
LKdFZevIUkyn016nTkqn06LlD01EtGjjVETU5z6/+uM673N9n+u+f8v7PM+v
oGxSycSqqVRqBqWpPJNKHcxKpS6hjnwWf1puKnWUH0KDsBrYVmqZLY+txvrw
W6gFNg9bhfXmC2mu8XjNJ9BNejXFalVJpZrxTek67HnsDLUz1D4u34OfR7/x
3agDVpXvLTtZ7m6qpkcj7POcVGq4+Ul6TaYvchIe8+VxP9RPXR/8hHElTY/7
4+vgf+l/LQ3ETlG3FO+gz065cXos4zdTX2x39JPbxOdTynwaz9C1eu2P94IV
8e1pDLZbrtxLnspvUT8QO52yjce47hT5FTJ3qz3EX0qdtM7mN2WS9xvveZt8
Fbl6anONJ2ALzH0vU4q10L8E34PtxppiDfj5cmuxrlgv9cexFbTBdUv4hnIn
87dGP6wdtoamG+/Cu+m7mt+uvnv813Lj8Q/49VTbeDK22Fx7/htqoPZsdWfR
SP1Xqq/tHXSOXvIDsAKsIzYMq01DsZ1q7zU/NNabfl/xz1Id7GbsPqyILzZu
a1yp/mXawz+tX1d98tPJen6K74y3M94l8wrt5fNcp6p+1xv3xbbJ9cImYpPo
avlTXSMHH+w5BsiNwN/Azo51ihW6xoU0St187JhMCfVWW4fvg9+mponM1/KN
sQ1UD7td7mG5TvxGqo9NwZZgxXyl605RNzGd7J2vYm3QaH1K5c7Hy/l9ss2x
tvxFdL1rdsCXYkNiPdJYrK2aNvp85Fm30i7+A7lR5suMR5vbzjeXbeJeZmKz
6F3+U9e4HevP95LbwbczPs/4E70qaDf/HN449pXxY+a689fkJofKPfjJ7qmp
a4zHZmAz6SrTuXKPqKkwzvGbG/+xucLYM2r2qn2VBsUapW/Nd6di+cNyDbDq
5m/B5se7UHcKto/vQZ3l/pTri02P84VKsbquOzwnefb5WE2ZUr5TnHu0lX/J
s31j3ErtmTIPGm+Wv1ztqkyyFmNNrjX3c+x7uWbGD2CbzF2GPRnnEFacTtZ/
7IOlWBo7RMvdcyesvtqT+Ilq52IXYDXiPOF7Uhf9jujxZiZ5pni2kfJvxVkq
93Os5XhmcyfkamI/ZSV7NfbscaxCtlWcndgarG/sXblf+CvjOtg/couMNxiv
d7+HaSH2Nv1lvMjv4viP4txXX0O/zdnJOo2zvpl+DfkF5tdhXbAl8T6Nn1ef
jnNCj3Pi3Pac9WKNy1+lbqxn/hJriD2ElWCn0oHYV7H+4rp8f1pg/iAtk28d
a5IWusZr2Ouxh+M/o3zje9Q9Y65bJun343//cfzXW/i6lJEbm5WceevcR4v4
TmH3YxvV9swk+6MgO3n2eAdr+DI6x/2em07OvJZy+XHfcnfILFPbNt6znm08
/2C5XBoi04hqyk2VWy53VK6JXK4+9aMfDZNpTLXk7pRbIXdMrkhuodx3+It0
JNYjZcVeSydn1N749tIP8f2ki9T+be7R/7/JsT74jXodyEn24yx+Nv0U3ze5
Hfrk8XP0vTI32a+R+0PtNHxc/BdYFfNV08l3vZL/Pr4f/KCsJP8dfy4VmL8M
v5xuUDsnsjJFVBjPFmsNG6XfFfEtxN7hq6sdqvYabIK5D+Ndqc8zno09Eese
G4G11KM1/S6/ByuI763cXXIrY43H3o/1ITMtO/mG19L/j/iuGPeLs4lulHkP
GyvzMQ0xV02uguZE7/iOyW3lX80kZ1KcTaX4a/zmTLLPYr+9j2XJtad71e7n
X6DDmaRn9B4sdxP2PpYXz4J9xpfFu3Avo6md612cTs79NpnkvItzb5/MevoV
+xcedRlX
                "]], 
               Polygon3DBox[{{1734, 1126, 842, 843, 1127, 1735}, {2079, 1044, 
                895, 894, 1218, 1789}}]},
              Annotation[#, "Charting`Private`Tag$23680#1"]& ]],
            Lighting->{{"Ambient", 
               RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
              "Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{0, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 0, 2}]}}]}, {}, 
          {GrayLevel[1], EdgeForm[None], 
           StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtlmWUVlUUhi9z7/fNoVNAumGK7m4wESRUQsUOurtTXf5x2R0oCJh0SzoB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               "]], Polygon3DBox[CompressedData["
1:eJwtmHfcl1UZxh/eZ/C8ERmRGhEfJIyt78t079myRLFFy/YQ3LkVt1af1GII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               "]], Polygon3DBox[CompressedData["
1:eJwt1PdvlVUYB/BXu1gqggsQmZJ0UNraAjKVVQgyTQRMBMUBJgqCyJAhoAb0
DxBIQCBBoVEEfwAqYWjYoy0CHZS2GBH9gaERhN+Qz5NL0m/veT73Oed977nn
vV2mz54468EkSUolQ97PTJLDaUnSStLVlbBnsyTJV2xg66WgeZLksly2Vr1H
399Z1mDj2M+sic20Vj7rxb5m+9gtfUPZaLaP1bO39M2SI+qH01L3UeXfe+yQ
uoX4SyrYYHNHmLsH1LDX9UyV88ZD+UmZpOcFKTUu11frvTf0zJaj6tZimJyx
Xi99Bfo2sv3sP/f3IhvJfmJ1bLrmD+SYuo1oSX41t4W+WnVPyZOlMU/Gm/uL
+pK+d83LYTlsDdvNbligiBWzb9hhNl7fcDaGHWAN7B2WzbLZV2wXG8tGsLHs
IGtkM+LDsM/cUy57VnndOI/l6VvHytk/rlvMerOt7CibYO4cOal+Sny1yTlz
h+l7Sd9+dpG9raclq1PnSw/2m74CVqhvEzvAbmel9qVG/YQ8KdvVzeVMzJNO
+urNfY6VmPstO8LGuUYhK2Kb2UF2x3rzeZW6a5wPVmfuXb7Sazbrxq4az9V3
St0+zgw7z1awptgTeYb9xT5kp9VPS0tWzZazxlhLOrI/WR/30i89debj7Nep
m8lx48fkcflO/Ym5DcZdYk1zr5g7IM6guT+yKvaqnsVSrW4be8Mu6VvCLqg7
SDv2O1vEzqkfieuwRvYRq1R3lodYLVvIzkYda7IG9nE8C+pH4/5YE1vGLsa+
x3XYH2wpq4/PGvvFLrOB7nmYe96Vlnqe4rl6gH2ekTrfcc5LHJBBbLi+3epq
fdP0zZOK2OP47WA1Gam9OnH/DMRZmKvOlC/iu49nJn4PjDPYaq9FLJfdNE5n
q7wWshz27/3vo7/rfh/7LmVxlqUvK1Mf1/ey+/jf2fhUfw7rzq4ZP69voL4f
2Gk2SV8/NojtYBVsMuvLBrDt7BR7hQ1ho9hedoG9yUpYH7aNHWMT2YLM1BmL
szY1+tVZ+r50/eLYv/h9MS6PNb2/hR1ir6n76xvMdrJKNoXdA6/OqL0=
               "]]}],
            Lighting->{{"Ambient", 
               GrayLevel[0.8]}}]}, {}, {}}, {
          {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0MtKAlEcB+C/3TMzkYIIMYu2PkY+QFC7Nj2APUpXtYtlta9VtekVIkIi
wkQiIrvQsn2fBPM732/OGebMnLm19aVyIiJWZbEvotefDZ+8HYzIsMVZ/gxH
VD1zL+fmKmzKhV7jBh+4J5v6I/dlS3/igWzrLR7Kjt7mJevsyJV+xBe51o+5
y1c2pKK/8USq+jtPpaZ/8Ky3v/7NL/nVi769yzxvhqyxZG2CRa7434X+iLT7
eY6zwBTzHGOOSc5wlNMc4RQnxdFEll4fGdou0hxgiq5IGmwXdyaXE//n/Qdz
my4x
            "]], Line3DBox[CompressedData["
1:eJwl0ssrp1EcgPHj57qbhb9AVrMgo+yGKAs1JmUhsZuFMgtWir8AC1v3YTSY
cb8bd8p1hyRJkiRZSJKkSePzZvH0POf7e0/ve06/tG+1pTVxIYQW7MdCyOTn
xBByOSkphGI+5leuxElyCFWeS7WpiNP99t28TmeYlfMnswazQuts3aRzuI3z
eZAHPHeHFe/q53us6kF+wJr+zY9Y13/4CRt6iDv4mYfRqV94k0f4H7b0KL9i
W4/xf+zocY6LD2FXT+h4vacndRcnWk/pbp2ikzHrm7/69gHO41aOuYsSZ2zU
l7rZngLrA9SbtZulmH20LuMs+6rNP1in6Qqdyl84gT/zr+iMWPbu2+jsWNI3
0Z1gUV9Hd4UFfRXdIf7qS+7jZb7AT73E5+jVizzDZ9FeTOvTaC+m9AnPY1If
8xwm9BH38Cwf4oeeib3/X94AuE5W6g==
            "]], Line3DBox[CompressedData["
1:eJwl0MkuQwEYhuHf0eE6XAtrkcZObWwl3Ag3YS5WoubptDW01MI8D3sRERFB
xCMWX573z0lzTtrWN1gYaImIXuvMRZTZxRqz+YiChz1JxLG7nUPu+daIE3eZ
p1zgGRd5ziVecJmXXOGqXek1XnOdN9zgLTd5xy3eM+UDm5mIbu8seveju4PD
7n7fePT33azyy7fOeXZojWxEzu+buq4zepYH7kTP6H0delo39I+VdJ3fNqX3
+GmTepcVfnDHUv3OCW7zzcZ1ja82pqt8sVFd4bON6JRPyf///Qv34kMB
            "]]}, 
          {GrayLevel[0.2], 
           Line3DBox[{1527, 2060, 2223, 1526, 2061, 2224, 1528, 2062, 2225, 
            1529, 999, 1530, 2188, 1666, 1531, 2189, 1667, 1532, 2190, 2063, 
            2226, 1533, 2064, 2227, 1534, 2065, 2228, 1535, 2066, 2229, 1536, 
            1007, 1537, 2191, 1668, 1538, 2192, 1669, 1539, 2193, 1670, 
            1540}], Line3DBox[{1542, 1724, 1725, 2321, 1541, 1728, 1729, 2285,
             1543, 2021, 2230, 2155, 1544, 2156, 2231, 2025, 1545, 1014, 1546,
             2286, 1731, 1732, 1547, 2287, 1734, 1735, 2322, 1548, 1738, 1739,
             2289, 1549, 2067, 2232, 1550, 2068, 2233, 1551, 2122, 2234, 1742,
             1552, 1138, 1744, 1553, 2290, 1746, 1747, 1554, 2194, 1671, 
            1555}], Line3DBox[{1569, 1756, 1755, 2292, 1568, 1748, 1806, 1144,
             1567, 1745, 1805, 2309, 2124, 1566, 1743, 1804, 2308, 2123, 1565,
             2128, 2239, 1753, 1564, 2126, 2238, 1752, 1563, 2324, 1741, 1803,
             1740, 1562, 2291, 1737, 1802, 1736, 2288, 1561, 1733, 1801, 1125,
             1560, 1751, 2237, 2125, 1559, 2001, 2026, 2350, 2028, 2027, 1558,
             2023, 2024, 2236, 2022, 1750, 1557, 2121, 2235, 1800, 1730, 1556,
             2323, 1727, 1799, 1726, 1749}], Line3DBox[CompressedData["
1:eJwVzkcvplEYBuBjo28lMuqHhIz4A+wlbCQYXZQgbLBjQQgWOqMkfgkzejeT
aEskevkdrndx5Tzvc9/n5I11DlT3x4UQxsiPD6E2IYRNfvGDGk74mRTCtPyR
Ad9bDJJBHafMyJ4YMv9hmEwaE0NIdr/ePCt/ZsR8T4l9m/zFrjzqMme+c44y
QbZOu86bfZPvM+bNr3TYZ8n/2o2TRTPnLMhLnX06hTo75u3oPVq4IE2WLnsw
T7LLFDm08o9i+aK33pn1/Rb9I7nRO+6nyP+bl+S9zj0O2CcW/Y9Oqs6leVln
0VlBNZWsyj/s281X/DaXOas4pMjdBp08cwfXrOh80mWfKz+K7pFPJzfRu/Iv
enRiOsd26xTQzS1r8g3nN0oaQwk=
            "]], Line3DBox[CompressedData["
1:eJwV0EsrhAEUBuCjNJfVuJtBidzH7V+wQaykDA1WGLkWiizcigjxd9iydSlb
/oK951s8nXPe9/umr+kob8xUqiJikdFUxFI6YpkCTzzSmY0Y0d3bH8hzR1a+
kokY1t24b2kmI5+WD8nH3ON82wvyBXuJQfer+caLZ1fNddYo6qZkzzS5r7li
IPk+WbvfuXQ3csE5/bo/3an9jAZOqiP65BP2SeqTjLT3y57t1R25j6ljTpbS
zdp7dD/mL+/J98o/zQ+6dYdmm6zknVr7Aft06XbNVt2eWcMWm8n/qJv3fIuu
4s6xwzZf/AP8DyhU
            "]], Line3DBox[CompressedData["
1:eJwV0MkuREEUBuAjEc0CO9Yi3a3N9jwBC/oJOhamBS+jG02bxRQzL8LSFCuR
iESCSGx8tfhy6vyn7r1Vt2NyoThfFxElhhoipjIR02RZoa0xorMp4tWsql8l
xxrN8rL8jZp+nTwt8ops2HqUMRa9p0vdZMnsXt1im7LZnHrLstmsWpRVKFjv
pLPI3/mV7er36GafdlnWNz/MD/SH9JCpjxhRx5mgN93N3lZ7q/Z+ciQ7po+C
/CTdUf6kPvCYzuuZO/U53dvsi1Prs3Res371nJr8mxlZzrsuZANcpn8j/+HP
7Ep/zSA3bMhf1H8mljcX
            "]], 
           Line3DBox[{1586, 1768, 2072, 2294, 1785, 1770, 1841, 2073, 2295, 
            1854, 1771, 1842, 2320, 1696, 1951, 2131, 2201, 1844, 1697, 1843, 
            2133, 2202, 1698, 1958, 2340, 1773, 1699, 1855, 2325, 1775, 1845, 
            2074, 2297, 1788, 1776, 1846, 2075, 2298, 1856, 1778, 1847, 1037, 
            1964, 1779, 2203, 1700, 1587, 2154, 2204, 1701, 2016, 2132, 2205, 
            1702, 1792, 2306, 1783, 1848, 1703, 1857, 2326, 1784, 1849, 1704, 
            1794}], Line3DBox[{1589, 2076, 2242, 1588, 1786, 2077, 2300, 1858,
             1787, 2078, 2301, 1590, 2134, 2206, 1705, 1591, 2207, 1706, 1592,
             2208, 1707, 1593, 2303, 1789, 2079, 2302, 1859, 1790, 2080, 2304,
             1860, 1791, 2081, 2305, 1594, 1047, 1595, 2209, 1708, 1596, 2210,
             1709, 1597, 2307, 1793, 1710, 1861, 2327, 1795, 1711, 1598}], 
           Line3DBox[{1600, 2082, 2243, 1599, 2083, 2244, 1601, 2084, 2245, 
            1602, 1053, 1603, 2211, 1712, 1604, 2212, 1713, 1605, 2213, 2085, 
            2246, 1606, 2086, 2247, 1607, 2087, 2248, 1608, 2088, 2249, 1609, 
            1061, 1610, 2214, 1714, 1611, 2215, 1715, 1612, 2216, 1716, 
            1613}]}, 
          {GrayLevel[0.2], 
           Line3DBox[{1433, 1419, 908, 2212, 1055, 893, 2208, 1043, 881, 1190,
             2340, 1349, 1397, 1396, 1246, 2198, 1170, 1307, 1327, 1326, 1368,
             2333, 1321, 1322, 1168, 1324, 1323, 2311, 1238, 1310, 1311, 1309,
             1125, 1231, 1124, 2286, 1123, 841, 2189, 1001, 826, 1458}], 
           Line3DBox[{1434, 1420, 909, 2213, 1056, 894, 1218, 2303, 1216, 
            1253, 1194, 2325, 1270, 1192, 1247, 1345, 2296, 1346, 1189, 1348, 
            1347, 1371, 2343, 1369, 1370, 1264, 1153, 1239, 1131, 1261, 2288, 
            1129, 1232, 1128, 1257, 2287, 1126, 842, 2190, 1002, 827, 1459}], 
           Line3DBox[{1435, 1421, 916, 2215, 1063, 901, 1223, 2307, 1222, 
            1254, 1205, 2306, 1221, 1204, 1249, 2342, 1359, 1360, 1200, 1362, 
            1361, 1374, 2336, 1332, 1333, 1178, 1335, 1334, 2313, 1242, 1145, 
            1263, 1144, 1235, 1143, 1259, 2290, 1142, 849, 2192, 1009, 834, 
            1466}], Line3DBox[{1436, 1422, 917, 2216, 1064, 902, 1225, 2327, 
            1276, 1224, 1255, 1207, 2326, 1272, 1206, 1250, 1363, 2299, 1364, 
            1203, 1366, 1365, 1375, 2337, 1336, 1337, 1181, 1339, 2338, 1338, 
            1243, 1163, 1241, 2292, 1162, 859, 2194, 1019, 850, 2193, 1010, 
            835, 1467}], 
           Line3DBox[{1437, 991, 821, 2223, 996, 836, 1119, 2321, 1256, 1011, 
            851, 1120, 2323, 1260, 1020, 860, 2330, 1314, 1315, 1164, 1282, 
            1025, 2346, 867, 1283, 1284, 1182, 1340, 2339, 1028, 870, 1183, 
            1208, 2294, 1032, 877, 2242, 1039, 888, 2243, 1050, 903, 1468}], 
           Line3DBox[{1438, 992, 822, 2224, 997, 837, 1121, 2285, 1012, 852, 
            2235, 1122, 1236, 1021, 861, 2331, 486, 487, 434, 1988, 585, 435, 
            630, 527, 2317, 871, 1184, 1269, 2295, 1033, 878, 1209, 1273, 
            2300, 1040, 889, 2244, 1051, 904, 1469}], 
           Line3DBox[{1439, 993, 828, 2226, 1003, 843, 1127, 2322, 1258, 1015,
             855, 1130, 2291, 1152, 1022, 863, 1328, 2293, 1329, 1171, 1289, 
            1395, 2328, 1026, 868, 1290, 1381, 1291, 1191, 1350, 2341, 1030, 
            873, 1193, 1215, 2297, 1035, 882, 1217, 1274, 2302, 1044, 895, 
            2246, 1057, 910, 1475}], 
           Line3DBox[{1440, 994, 829, 2227, 1004, 844, 1132, 2289, 1016, 856, 
            1133, 2324, 1262, 1023, 864, 2335, 1330, 1331, 1172, 1292, 1027, 
            2347, 869, 1293, 1294, 1268, 1031, 874, 1195, 1271, 2298, 1036, 
            883, 1219, 1275, 2304, 1045, 896, 2247, 1058, 911, 1476}], 
           Line3DBox[{1441, 995, 830, 2228, 1005, 845, 2232, 1017, 857, 2238, 
            1154, 1301, 1302, 1303, 865, 2240, 1155, 1304, 1305, 1306, 2315, 
            1378, 1295, 1173, 1398, 1351, 1352, 2319, 875, 1354, 1196, 1353, 
            1037, 884, 1220, 2305, 1046, 897, 2248, 1059, 912, 1477}], 
           Line3DBox[{1455, 823, 2225, 998, 838, 2230, 1403, 1013, 853, 1404, 
            2236, 1146, 1384, 1386, 1387, 862, 2332, 1316, 1147, 1317, 1285, 
            1286, 2314, 1287, 1281, 1165, 1266, 1029, 2318, 872, 1343, 1185, 
            1341, 1034, 2320, 879, 1210, 2301, 1041, 890, 2245, 1052, 905, 
            1470}], Line3DBox[{1456, 824, 999, 839, 2231, 1405, 1406, 1407, 
            1408, 2350, 1382, 1385, 1383, 1391, 1392, 2348, 1105, 1393, 1106, 
            1318, 2349, 1167, 1320, 1110, 1267, 1111, 2196, 1278, 1245, 1187, 
            1342, 1188, 2201, 1252, 1213, 1214, 2206, 891, 1053, 906, 1471}], 
           Line3DBox[{1457, 825, 1000, 2188, 840, 1014, 854, 2237, 1148, 1149,
             1237, 2310, 1288, 1367, 1150, 1166, 1151, 1325, 1319, 2334, 1169,
             1394, 1300, 1377, 1112, 1186, 1113, 2197, 1344, 1308, 1211, 1251,
             1212, 2202, 880, 1042, 2207, 892, 1054, 2211, 907, 1472}], 
           Line3DBox[{1463, 831, 2229, 1006, 846, 2233, 1018, 858, 2239, 1156,
             1157, 1024, 866, 1379, 2241, 1107, 1174, 1297, 1372, 1298, 2316, 
            1380, 1299, 1373, 1176, 1197, 1355, 1376, 2345, 1356, 876, 1199, 
            1038, 2203, 885, 1047, 898, 2249, 1060, 913, 1478}], 
           Line3DBox[{1464, 832, 1007, 847, 2234, 1134, 1135, 1233, 2308, 
            1136, 1158, 1137, 1159, 1296, 2329, 1108, 1175, 1109, 2195, 1277, 
            1177, 1279, 1114, 1198, 1115, 2199, 1399, 1390, 1388, 1389, 2204, 
            886, 1048, 2209, 899, 1061, 914, 1479}], 
           Line3DBox[{1465, 833, 1008, 2191, 848, 1138, 1139, 1234, 2309, 
            1140, 1312, 1141, 1313, 1240, 2312, 1160, 1265, 1161, 1280, 2344, 
            1244, 1358, 1179, 1400, 1180, 2200, 1357, 1248, 1402, 1201, 1401, 
            1202, 2205, 887, 1049, 2210, 900, 1062, 2214, 915, 
            1480}]}, {}, {}}},
        VertexNormals->CompressedData["
1:eJzsvXlYT+v3P5xZSBqkeVA0EDIUSisyFCoyhoSUyhAZK1EhFJVSJIrSpAHR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