(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1981230,      38136]
NotebookOptionsPosition[   1822498,      34803]
NotebookOutlinePosition[   1960869,      37753]
CellTagsIndexPosition[   1960826,      37750]
WindowTitle->5. The Argument Function | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "The Argument Function"
}], "Section",
 CounterAssignments->{{"Section", 4}},
 CellID->237297608,ExpressionUUID->"cfcdefcb-2081-4d2a-8b2e-dbd407cd7e81"],

Cell[CellGroupData[{

Cell["Overview", "Subsection",
 CellID->77314943,ExpressionUUID->"673aba07-bb2b-48ca-bdbe-3905494f2265"],

Cell[TextData[{
 "In this chapter, you will study the roots of the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "n"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2e4bdbc7-e423-4987-a0bd-d0035db14305"],
 ", which leads to the definition of the complex square root. You will see \
that the square root cannot be made continuous in the whole complex plane, \
due to what is called a branch cut."
}], "Text",
 CellID->8642592,ExpressionUUID->"9d3946d5-8158-460a-88bc-f8f192677c8d"],

Cell["\<\
The discussion will also lead to the definition of the argument function.\
\>", "Text",
 CellID->21542089,ExpressionUUID->"7d36815c-c5f8-4ce7-b909-f7188983f2ef"],

Cell[TextData[{
 "First let\[CloseCurlyQuote]s recall that in real analysis, the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "n"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"73cbcbaf-2d7a-4095-b444-4277078ed3fa"],
 " for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ad386bf0-3907-4f44-bab4-e131ce63fe79"],
 " has at most ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1716d7a7-75e3-4659-bdf8-91fdb9b10795"],
 " solutions."
}], "Text",
 CellID->132050317,ExpressionUUID->"9975e534-a919-4604-be0a-bebc52f9f76e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"f", ",", "a", ",", "sv1", ",", "sv2", ",", "a", ",", "b"}], "]"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "a"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Row", "[", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"pl", "[", 
          RowBox[{
           RowBox[{"x", "^", "2"}], ",", "x", ",", "aa"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Opacity", "[", "0", "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
           RowBox[{"ImageSize", "->", "30"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"pl", "[", 
          RowBox[{
           RowBox[{"x", "^", "3"}], ",", "x", ",", "aa"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], "]"}]}], "]"}], "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"aa", ",", 
        RowBox[{"-", "2"}], ",", 
        RowBox[{"ToString", "[", 
         RowBox[{"a", ",", "TraditionalForm"}], "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"-", "25"}], "/", "10"}], ",", "3"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Initialization", ":>", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"pl", "[", 
         RowBox[{"f_", ",", "x_", ",", "b_"}], "]"}], ":=", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"sv1", ",", "sv2"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"sv1", "=", 
            RowBox[{
             RowBox[{"NSolveValues", "[", 
              RowBox[{
               RowBox[{"f", "==", "b"}], ",", "x"}], "]"}], "//", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"#", ",", "RealValuedNumberQ"}], "]"}], "&"}]}]}], ";",
            "\[IndentingNewLine]", 
           RowBox[{"sv1", "=", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"And", "@@", 
               RowBox[{"(", 
                RowBox[{"RealValuedNumericQ", "/@", "sv1"}], ")"}]}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"#", ",", 
                  RowBox[{"f", "/.", 
                   RowBox[{"x", "->", "#"}]}]}], "}"}], "&"}], "/@", "sv1"}], 
              ",", 
              RowBox[{"{", "}"}]}], "]"}]}], ";", 
           RowBox[{"Plot", "[", 
            RowBox[{"f", ",", 
             RowBox[{"{", 
              RowBox[{"x", ",", 
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"PlotRange", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "25"}], "/", "10"}], ",", "3"}], "}"}]}], ",", 
             RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
             RowBox[{"AxesLabel", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"ToString", "[", 
                 RowBox[{"x", ",", "TraditionalForm"}], "]"}], ",", 
                RowBox[{"ToString", "[", 
                 RowBox[{"y", ",", "TraditionalForm"}], "]"}]}], "}"}]}], ",", 
             RowBox[{"Epilog", "->", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Thin", ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "3"}], ",", "b"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "b"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"Pink", ",", 
                  RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
                  RowBox[{"Point", "[", "sv1", "]"}]}], "}"}], ",", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"a", ",", 
                    RowBox[{"FontFamily", "->", "\"\<Times\>\""}]}], "]"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "b"}], "}"}]}], "]"}]}], "}"}]}], ",", 
             RowBox[{"PlotLabels", "->", 
              RowBox[{"Placed", "[", 
               RowBox[{"Automatic", ",", "Above"}], "]"}]}]}], "]"}]}]}], 
         "]"}]}], ";"}], ")"}]}]}], "\[IndentingNewLine]", "]"}], 
  RowBox[{"(*", 
   RowBox[{"//", 
    RowBox[{
     RowBox[{"Labeled", "[", 
      RowBox[{"#", ",", 
       RowBox[{"\"\<Fig. 1. Solutions of \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "2"}], "==", "a"}], ",", "TraditionalForm"}], 
         "]"}], "<>", "\"\< and \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "3"}], "==", "a"}], ",", "TraditionalForm"}], 
         "]"}], "<>", "\"\< for real \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"x", ",", "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}]}], 
      "]"}], "&"}]}], "*)"}]}]}], "Input",
 CellID->736424642,ExpressionUUID->"0aed0eca-82da-4874-8909-6571bd16b199"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`aa$$ = 0.998, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`aa$$], -2, 
       "\!\(\*FormBox[\"a\", TraditionalForm]\)"}, 
      Rational[-5, 2], 3, ControlType -> Manipulator}}, Typeset`size$$ = {
    510., {116.34432453364002`, 123.57674640864002`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`aa$$ = -2}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Block[{$CellContext`x, $CellContext`y, $CellContext`a}, 
        Row[{
          $CellContext`pl[$CellContext`x^2, $CellContext`x, \
$CellContext`aa$$], 
          Graphics[{
            Opacity[0], 
            Line[{{0, 0}, {1, 0}}]}, ImageSize -> 30], 
          $CellContext`pl[$CellContext`x^3, $CellContext`x, \
$CellContext`aa$$]}]], 
      "Specifications" :> {{{$CellContext`aa$$, -2, 
          "\!\(\*FormBox[\"a\", TraditionalForm]\)"}, 
         Rational[-5, 2], 3}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{560.5, {164.34432453364002`, 171.57674640864002`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`pl[
         Pattern[$CellContext`f, 
          Blank[]], 
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`b, 
          Blank[]]] := 
       Module[{$CellContext`sv1, $CellContext`sv2}, $CellContext`sv1 = (
           Select[#, RealValuedNumberQ]& )[
            
            NSolveValues[$CellContext`f == $CellContext`b, $CellContext`x]]; \
$CellContext`sv1 = If[
            Apply[And, 
             Map[RealValuedNumericQ, $CellContext`sv1]], 
            Map[{#, 
              
              ReplaceAll[$CellContext`f, $CellContext`x -> #]}& , \
$CellContext`sv1], {}]; 
         Plot[$CellContext`f, {$CellContext`x, -3, 3}, 
           PlotRange -> {(-25)/10, 3}, AspectRatio -> Automatic, AxesLabel -> {
             ToString[$CellContext`x, TraditionalForm], 
             ToString[$CellContext`y, TraditionalForm]}, Epilog -> {{Thin, 
              Line[{{-3, $CellContext`b}, {3, $CellContext`b}}]}, {Pink, 
              PointSize[Medium], 
              Point[$CellContext`sv1]}, 
             Text[
              Style[$CellContext`a, FontFamily -> "Times"], {
              3, $CellContext`b}]}, PlotLabels -> Placed[Automatic, Above]]]; 
      Null); Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->108961866,ExpressionUUID->"bf6c9e96-3e27-48a5-8f03-7e31d8e3563a"]
}, {2}]],

Cell[TextData[{
 "For example, the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "=", "4"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"aa38cff3-919f-4cee-813c-daeeea971ea4"],
 " has the two solutions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"\[PlusMinus]", "2"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bf563078-487f-4a9b-b61b-14275e461272"],
 ", and by convention we say that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["4"], "=", 
    RowBox[{"+", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c3a5a4fd-aec8-4701-8996-e27201eb8e6b"],
 "."
}], "Text",
 CellID->177333502,ExpressionUUID->"77a310c8-094c-47d5-95ca-529c5c71838e"],

Cell[TextData[{
 "Next you will see how these concepts generalize to the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "n"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"becf3338-7144-4eec-b650-d7cdc2e7e6ea"],
 " for complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7b0695f8-16a5-410e-b566-f07a6a83abbf"],
 " and ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7e66e201-c438-41d5-90d8-e2e6a8d890b6"],
 "."
}], "Text",
 CellID->51703622,ExpressionUUID->"f70f2463-71f3-47a7-98ff-29091e6c951b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The Equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "n"], "=", "a"}], TraditionalForm]],ExpressionUUID->
  "19ded3f3-c905-4300-a1e4-02dd98f0c3b5"]
}], "Subsection",
 CellID->14338849,ExpressionUUID->"7c511d70-ca4c-4e09-9355-f57c1372424d"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s start by analyzing the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "n"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4d6412c8-29f9-4216-897e-164aef379a9f"],
 " in some special cases. Over the real numbers, the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "2"], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f6271541-d944-480e-a8ff-14c865ecb9d6"],
 " has the two solutions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"\[PlusMinus]", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"57ad2d04-873f-484c-aeab-261a85fbfe28"],
 ", whereas the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "2"], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6d842482-b594-4f1c-9370-5775a897a8f9"],
 " has no real solutions. However, it has two complex solutions, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"\[PlusMinus]", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2bdf59bf-8d3a-4f3e-8f5b-4d2f3d009262"],
 "."
}], "Text",
 CellID->192551170,ExpressionUUID->"ff0ec63a-1c92-4022-86dd-05765bc4e934"],

Cell[TextData[{
 "Actually, for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6396840f-28a5-4907-ab95-bc606081dfbb"],
 ", the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "n"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f00e47c3-5158-4448-9641-b43301a1457c"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Element]", "\[DoubleStruckCapitalC]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"249514f9-62d5-4e94-93d0-2f66cdf15885"],
 " always has ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "40f9cdad-5fc8-421f-802f-b0373d288d96"],
 " complex solutions. To find them, write"
}], "Text",
 CellID->1007629189,ExpressionUUID->"66208ae0-f20b-4aa3-8146-7ea640ace21e"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{"a", "=", 
    RowBox[{
     RowBox[{"r", 
      RowBox[{"(", 
       RowBox[{"cos\[CurlyPhi]", "+", 
        RowBox[{"\[ImaginaryI]", " ", "sin", " ", "\[CurlyPhi]"}]}], ")"}]}], 
     "=", 
     RowBox[{"r", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[CurlyPhi]"}]]}]}]}], ",", " ", 
   "and"}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{"z", "=", 
   RowBox[{
    RowBox[{"\[Rho]", "(", 
     RowBox[{"cos\[Theta]", "+", 
      RowBox[{"\[ImaginaryI]", " ", "sin\[Theta]"}]}], ")"}], "=", 
    RowBox[{"\[Rho]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]]}]}]}], 
  TraditionalForm]}], "DisplayFormulaNumbered",
 CellID->40326042,ExpressionUUID->"8ded9cd8-fc8f-4f1f-9b80-cc94828cf35c"],

Cell["using Euler\[CloseCurlyQuote]s formula. Then, the original equation \
becomes", "Text",
 CellID->417228762,ExpressionUUID->"f45c8931-96f3-429a-91b1-49f966fec2dd"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "n"], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Rho]", "n"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"n", " ", "\[ImaginaryI]", " ", "\[Theta]"}]]}], "=", 
     RowBox[{"r", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "\[CurlyPhi]"}]]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->155500655,ExpressionUUID->"bfc9afe6-851f-4f17-84a4-8512f684c44c"],

Cell["which has the solutions", "Text",
 CellID->7193087,ExpressionUUID->"b23d03dc-26e0-411a-8b0d-ff03b7df4b5e"],

Cell[BoxData[{
 FormBox[
  RowBox[{"\[Rho]", "=", 
   RadicalBox["r", "n"]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   RowBox[{"\[Theta]", " ", "=", 
    FractionBox[
     RowBox[{"\[CurlyPhi]", "+", 
      RowBox[{"2", "k", " ", "\[Pi]"}]}], "n"]}], ",", " ", 
   RowBox[{"k", "=", "0"}], ",", "...", ",", 
   RowBox[{"n", "-", "1"}]}], TraditionalForm]}], "DisplayFormulaNumbered",
 CellID->899190240,ExpressionUUID->"abb685ef-dbae-44da-bcbe-67e6a6ed298d"],

Cell[TextData[{
 "because of the property ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"w", "+", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]}]], "=", 
    SuperscriptBox["\[ExponentialE]", "w"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0b1a7405-5c7f-4c25-b1de-dbdafa887caa"],
 ". These are exactly ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f637126e-9592-43e3-ae15-e62e66a0a374"],
 " solutions."
}], "Text",
 CellID->259224127,ExpressionUUID->"4db94d64-b2c1-44cf-a593-8583b7df57b2"],

Cell[TextData[{
 "Plotting the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "56fdf2f2-46e2-4a22-af0c-7cd19342ead1"],
 " solutions in the complex plane, they form the vertices of a regular ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "28c30d9e-fcb0-4886-bdf6-49c64b8885d6"],
 "-gon. For example, the solutions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], ",", 
    SubscriptBox["z", "2"], ",", 
    SubscriptBox["z", "3"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2682c8fa-306d-4e99-9830-5bada3c302c1"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "3"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c45a3cf6-3589-4ac5-96e4-be5433b6a9ee"],
 " are plotted in Fig. 1."
}], "Text",
 CellID->60452173,ExpressionUUID->"3ced719c-c5e5-482f-8a96-aa0ff48f24f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Dashed", ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.004`", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.004`", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
          "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["3", "2"]}], ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{
           RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
          "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<1\>\"", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[ImaginaryI]\>\"", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RGBColor", "[", 
        RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}], ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["7", "4"], ",", 
          FractionBox["5", "4"]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"ToString", "[", 
          RowBox[{"a", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["7", "4"], ",", 
         FractionBox["5", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.003`", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["7", "4"], ",", 
            FractionBox["5", "4"]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"ReIm", "[", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["7", "4"], "+", 
             FractionBox[
              RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
           RowBox[{"1", "/", "3"}]], "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\\!\\(\\*SubscriptBox[\\(z\\), \\(1\\)]\\)\>\"", ",", 
         "12"}], "]"}], ",", 
       RowBox[{"ComplexExpand", "[", 
        RowBox[{"ReIm", "[", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["7", "4"], "+", 
            FractionBox[
             RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
          RowBox[{"1", "/", "3"}]], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", "0.003`", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"ComplexExpand", "[", 
           RowBox[{"ReIm", "[", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               FractionBox["7", "4"], "+", 
               FractionBox[
                RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
             RowBox[{"1", "/", "3"}]], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"ReIm", "[", 
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{
             FractionBox["1", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"2", " ", "\[Pi]"}], ")"}], " ", "\[ImaginaryI]"}], 
            "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["7", "4"], "+", 
              FractionBox[
               RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\\!\\(\\*SubscriptBox[\\(z\\), \\(2\\)]\\)\>\"", ",", 
         "12"}], "]"}], ",", 
       RowBox[{"ComplexExpand", "[", 
        RowBox[{"ReIm", "[", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{
            FractionBox["1", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"2", " ", "\[Pi]"}], ")"}], " ", "\[ImaginaryI]"}], 
           "]"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["7", "4"], "+", 
             FractionBox[
              RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", 
          FractionBox["3", "2"]}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"ComplexExpand", "[", 
         RowBox[{"ReIm", "[", 
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{
             FractionBox["1", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"4", " ", "\[Pi]"}], ")"}], " ", "\[ImaginaryI]"}], 
            "]"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["7", "4"], "+", 
              FractionBox[
               RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\\!\\(\\*SubscriptBox[\\(z\\), \\(3\\)]\\)\>\"", ",", 
         "12"}], "]"}], ",", 
       RowBox[{"ComplexExpand", "[", 
        RowBox[{"ReIm", "[", 
         RowBox[{
          RowBox[{"Exp", "[", 
           RowBox[{
            FractionBox["1", "3"], " ", 
            RowBox[{"(", 
             RowBox[{"4", " ", "\[Pi]"}], ")"}], " ", "\[ImaginaryI]"}], 
           "]"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["7", "4"], "+", 
             FractionBox[
              RowBox[{"5", " ", "\[ImaginaryI]"}], "4"]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.025`", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "0.35`", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            FractionBox["\[Pi]", "6"]}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
     
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]\>\"", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "4"], ",", 
         FractionBox["1", "3"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.025`", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "0.7`", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{
             FractionBox["1", "3"], " ", 
             RowBox[{"ArcTan", "[", 
              FractionBox["5", "7"], "]"}]}]}], "}"}]}], "]"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\[Theta]/3\>\"", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["2", "3"], ",", 
         FractionBox["1", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "5"]}]}], "}"}]}], "]"}]}], "}"}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#1", ",", 
     RowBox[{"\"\<Fig. 1. The three solutions \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{
        SubscriptBox["z", "1"], ",", "TraditionalForm"}], "]"}], 
      "<>", "\"\<, \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{
        SubscriptBox["z", "2"], ",", "TraditionalForm"}], "]"}], 
      "<>", "\"\<, \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{
        SubscriptBox["z", "3"], ",", "TraditionalForm"}], "]"}], 
      "<>", "\"\< of the equation \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"z", "^", "3"}], "==", "a"}], ",", "TraditionalForm"}], 
       "]"}], "<>", "\"\<.\>\""}]}], "]"}], "&"}]}]], "Input",
 CellID->180407655,ExpressionUUID->"f3afdcb6-1509-4272-b468-cbcb0202f9dc"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      Dashing[{Small, Small}], 
      CircleBox[{0, 0}]}, {
      Thickness[0.004], 
      LineBox[{{0, -2}, {0, 2}}]}, {
      Thickness[0.004], 
      LineBox[{{-2, 0}, {2, 0}}]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {2, 0}, 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{-0.25, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 2}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 0}], 
       ImageScaled[{0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"1\"", 12, StripOnInput -> False], TraditionalForm], {1, 0}, 
      ImageScaled[{0, 1}]], 
     InsetBox[
      FormBox[
       StyleBox["\"\[ImaginaryI]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 1}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{
         Rational[7, 4], 
         Rational[5, 4]}, {1.75, 1.25}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[\\\"a\\\", TraditionalForm]\\)\"", 12, 
        StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[7, 4], 
        Rational[5, 4]}, {1.75, 1.25}], 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], {
      Thickness[0.003], 
      LineBox[
       NCache[{{0, 0}, {
          Rational[7, 4], 
          Rational[5, 4]}}, {{0, 0}, {1.75, 1.25}}]]}, {
      RGBColor[1, 0, 0], 
      PointSize[Medium], 
      PointBox[
       NCache[{2^Rational[-1, 2] 37^Rational[1, 6] Cos[Rational[1, 3] ArcTan[
             Rational[5, 7]]], 2^Rational[-1, 2] 37^Rational[1, 6] 
         Sin[Rational[1, 3] ArcTan[
             Rational[5, 7]]]}, {1.2632898278472942`, 
        0.26497119971900784`}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(1\\)]\\)\"", 12, StripOnInput -> 
        False], TraditionalForm], 
      NCache[{2^Rational[-1, 2] 37^Rational[1, 6] Cos[Rational[1, 3] ArcTan[
            Rational[5, 7]]], 2^Rational[-1, 2] 37^Rational[1, 6] 
        Sin[Rational[1, 3] ArcTan[
            Rational[5, 7]]]}, {1.2632898278472942`, 0.26497119971900784`}], 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 
         Rational[1, 4]}], 
       ImageScaled[{-0.5, 0.25}]]], {
      Thickness[0.003], 
      LineBox[
       NCache[{{0, 0}, {
         2^Rational[-1, 2] 37^Rational[1, 6] Cos[Rational[1, 3] ArcTan[
              Rational[5, 7]]], 2^Rational[-1, 2] 37^Rational[1, 6] 
          Sin[Rational[1, 3] ArcTan[
              Rational[5, 7]]]}}, {{0, 0}, {1.2632898278472942`, 
         0.26497119971900784`}}]]}, {
      RGBColor[1, 0, 0], 
      PointSize[Medium], 
      PointBox[
       NCache[{
        Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
          Cos[Rational[1, 3] ArcTan[
              Rational[5, 7]]] + 
         Rational[-1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
          Sin[Rational[1, 3] ArcTan[
              Rational[5, 7]]], 
         Rational[1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
          Cos[Rational[1, 3] ArcTan[
              Rational[5, 7]]] + 
         Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
          Sin[Rational[1, 3] ArcTan[
              Rational[5, 7]]]}, {-0.8611167041515478, 0.9615554833987229}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(2\\)]\\)\"", 12, StripOnInput -> 
        False], TraditionalForm], 
      NCache[{
       Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
         Cos[Rational[1, 3] ArcTan[
             Rational[5, 7]]] + 
        Rational[-1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
         Sin[Rational[1, 3] ArcTan[
             Rational[5, 7]]], 
        Rational[1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
         Cos[Rational[1, 3] ArcTan[
             Rational[5, 7]]] + 
        Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
         Sin[Rational[1, 3] ArcTan[
             Rational[5, 7]]]}, {-0.8611167041515478, 0.9615554833987229}], 
      NCache[
       ImageScaled[{1, 
         Rational[-1, 4]}], 
       ImageScaled[{1, -0.25}]]], {
      RGBColor[1, 0, 0], 
      PointSize[Medium], 
      PointBox[
       NCache[{
        Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
          Cos[Rational[1, 3] ArcTan[
              Rational[5, 7]]] + 
         Rational[1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
          Sin[Rational[1, 3] ArcTan[
              Rational[5, 7]]], 
         Rational[-1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
          Cos[Rational[1, 3] ArcTan[
              Rational[5, 7]]] + 
         Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
          Sin[Rational[1, 3] ArcTan[
              Rational[
              5, 7]]]}, {-0.4021731236957461, -1.2265266831177306`}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(3\\)]\\)\"", 12, StripOnInput -> 
        False], TraditionalForm], 
      NCache[{
       Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
         Cos[Rational[1, 3] ArcTan[
             Rational[5, 7]]] + 
        Rational[1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
         Sin[Rational[1, 3] ArcTan[
             Rational[5, 7]]], 
        Rational[-1, 2] 2^Rational[-1, 2] 3^Rational[1, 2] 37^Rational[1, 6] 
         Cos[Rational[1, 3] ArcTan[
             Rational[5, 7]]] + 
        Rational[-1, 2] 2^Rational[-1, 2] 37^Rational[1, 6] 
         Sin[Rational[1, 3] ArcTan[
             Rational[5, 7]]]}, {-0.4021731236957461, -1.2265266831177306`}], 
      
      NCache[
       ImageScaled[{
         Rational[1, 2], 1}], 
       ImageScaled[{0.5, 1}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.35, 
        NCache[{0, Rational[1, 6] Pi}, {0, 0.5235987755982988}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Theta]\"", 12, StripOnInput -> False], TraditionalForm], 
      
      NCache[{
        Rational[1, 4], 
        Rational[1, 3]}, {0.25, 0.3333333333333333}], 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.7, 
        NCache[{0, Rational[1, 3] ArcTan[
            Rational[5, 7]]}, {0, 0.2067498286609405}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Theta]/3\"", 12, StripOnInput -> False], 
       TraditionalForm], 
      NCache[{
        Rational[2, 3], 
        Rational[1, 4]}, {0.6666666666666666, 0.25}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[2, 5]}], 
       ImageScaled[{0.25, 0.4}]]]}], 
   "\"Fig. 1. The three solutions \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\
\"1\\\"], TraditionalForm]\\), \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"2\
\\\"], TraditionalForm]\\), \\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \
\\\"3\\\"], TraditionalForm]\\) of the equation \
\\!\\(\\*FormBox[RowBox[{SuperscriptBox[\\\"z\\\", \\\"3\\\"], \\\"\
\[LongEqual]\\\", \\\"a\\\"}], TraditionalForm]\\).\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->423248744,ExpressionUUID->"9df601ca-3a70-493a-b799-b52ec2404100"]
}, {2}]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->334130463,ExpressionUUID->"95b93359-13d2-4ca3-b7ad-6302d50e1f34"],

Cell[TextData[{
 "Solve the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "3"], "=", 
    RowBox[{"-", "8"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3c7c1e93-4819-476a-80e8-d8e61e1f587c"],
 " and plot the solutions in the complex plane."
}], "SolvedExampleNote",
 CellID->7437052,ExpressionUUID->"9ede087e-c040-48ca-b4f3-4fd1d7459815"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "8"}], "=", 
    RowBox[{"8", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Pi]"}]]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "b4c5ad4f-9d8b-424f-86c6-dd8dab80c205"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     RowBox[{
      RadicalBox["8", "3"], 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
         RowBox[{
         "2", "n", "\[InvisibleSpace]", "\[ImaginaryI]", "\[InvisibleSpace]", 
          "\[Pi]"}]}], "3"]]}], "=", 
     RowBox[{"2", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "(", 
        RowBox[{
         FractionBox["\[Pi]", "3"], "+", 
         RowBox[{
          FractionBox["2", "3"], "n", "\[InvisibleSpace]", "\[Pi]"}]}], 
        ")"}]]}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7a8e558d-d028-46c5-a0ba-65191bf0aee9"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "=", "0"}], ",", "1", ",", "2"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cb4c2e8c-7bce-43f5-af9f-3fa10c5ecc9f"],
 "."
}], "SolvedExampleNote",
 CellID->593496654,ExpressionUUID->"462bec93-a0be-4ee4-ae1e-c8e9416767df"],

Cell[TextData[{
 "Check using the command ",
 ButtonBox["SolveValues",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->366862473,ExpressionUUID->"491cbeda-5744-4fa8-866c-4a148882d385"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"SolveValues", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "3"], "==", 
      RowBox[{"-", "8"}]}], ",", "z"}], "]"}], "//", 
   "ComplexExpand"}]}]], "SolvedExampleInput",
 CellID->42439076,ExpressionUUID->"5d51a638-7f3c-4318-a04a-7b0bb6bd9eed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], ",", 
   RowBox[{"1", "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}]}], "}"}]], "SolvedExampleOutput",
 CellID->526921085,ExpressionUUID->"ece1bc52-04c4-4ff6-b177-4413a9fe502c"]
}, Open  ]],

Cell["In the complex plane:", "SolvedExampleNote",
 CellID->166538141,ExpressionUUID->"d68baf7c-5774-4a99-a332-c2defb03991b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexListPlot", "[", 
  RowBox[{"sol", ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1040", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[AxesLabel -> {
       Style[
        ToString[
         Re[$CellContext`z], TraditionalForm], 12], 
       Style[
        ToString[
         Im[$CellContext`z], TraditionalForm], 12]}, 
     PlotRange -> {{-4, 4}, {-4, 4}}, AspectRatio -> Automatic, 
     PlotStyle -> {Red, 
       PointSize[Medium]}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->69031297,ExpressionUUID->"799f93fa-85ad-4669-9f52-f8c70713d381"],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
         PointBox[{{-2., 0.}, {1., 1.7320508075688772`}, {
          1., -1.7320508075688772`}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      StyleBox[
       DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              
              Point[{{-2., 0.}, {1., 1.7320508075688772`}, {
               1., -1.7320508075688772`}}]}, "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> (Identity[
                 Part[#, 1]] + I Identity[
                  Part[#, 2]]& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ComplexListPlot, "GroupHighlight" -> False|>|>],
        ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}],
       Selectable->False]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[Medium]], 
          
          Point[{{-2., 0.}, {1., 1.7320508075688772`}, {
           1., -1.7320508075688772`}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 432}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[Medium]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> (Identity[
              Part[#, 1]] + I Identity[
               Part[#, 2]]& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ComplexListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "MessagesHead" -> ComplexListPlot, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& )}},
  PlotRange->{{-4., 4.}, {-4., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->166064612,ExpressionUUID->"8b0dfec4-b94c-49e5-9f64-58efc9e6f71f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"a9d61d6a-09bf-4e1b-993f-130824782a72"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->95933590,ExpressionUUID->"c1679b5f-0149-40a4-ab04-c80214164ac3"],

Cell[TextData[{
 "Solve the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "4"], "=", 
    RowBox[{
     RowBox[{"-", "3"}], "-", 
     RowBox[{
      SqrtBox["3"], "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8d9be062-1e60-4dbf-9fdb-b6f38ef69c98"],
 " and plot the solutions in the complex plane."
}], "SolvedExampleNote",
 CellID->543514988,ExpressionUUID->"44705bfe-97bf-4373-89bd-b13b0ab97211"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", "-", 
     RowBox[{
      SqrtBox["3"], "\[ImaginaryI]"}]}], "=", 
    RowBox[{"2", 
     SqrtBox["3"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "\[InvisibleSpace]", 
       RowBox[{"\[Pi]", "/", "6"}]}]]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"723c327c-34f9-4eac-a95f-969466a8fde6"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"1", "/", "4"}]], 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "8"}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "\[InvisibleSpace]", 
       RowBox[{"\[Pi]", "/", "24"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", "n", "\[InvisibleSpace]", "\[Pi]"}]}], ")"}]}]]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "317e0c72-c008-4ec0-a54a-02885db7912a"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"n", "=", "0"}], ",", "1", ",", "2", ",", "3"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "bda3c5f3-f2bc-4fd3-a2c3-db48512528eb"],
 ":"
}], "SolvedExampleNote",
 CellID->202492206,ExpressionUUID->"37d682f8-b7cd-44c3-a7d0-44a2c6f24245"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soln", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"SolveValues", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "4"], "==", 
       RowBox[{"3", "-", 
        RowBox[{
         SqrtBox["3"], "\[ImaginaryI]"}]}]}], ",", "z"}], "]"}], "//", 
    "ComplexExpand"}], "//", "Simplify"}]}]], "SolvedExampleInput",
 CellID->113980782,ExpressionUUID->"4ab170c5-a160-4be8-adba-564af564a604"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["2", 
      RowBox[{"1", "/", "4"}]]}], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "8"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "24"], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "24"], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "8"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       RowBox[{"Cos", "[", 
        FractionBox["\[Pi]", "24"], "]"}]}], "-", 
      RowBox[{"Sin", "[", 
       FractionBox["\[Pi]", "24"], "]"}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "8"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Cos", "[", 
        FractionBox["\[Pi]", "24"], "]"}]}], "+", 
      RowBox[{"Sin", "[", 
       FractionBox["\[Pi]", "24"], "]"}]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "8"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["\[Pi]", "24"], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sin", "[", 
        FractionBox["\[Pi]", "24"], "]"}]}]}], ")"}]}]}], 
  "}"}]], "SolvedExampleOutput",
 CellID->397870784,ExpressionUUID->"76c51478-a1c0-4a42-be57-55bdf317b77b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexListPlot", "[", 
  RowBox[{"soln", ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["5", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1168", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[AspectRatio -> Automatic, PlotStyle -> {Red, 
       PointSize[Medium]}, AxesLabel -> {
       Style[
        ToString[
         Re[$CellContext`z], TraditionalForm], 12], 
       Style[
        ToString[
         Im[$CellContext`z], TraditionalForm], 12]}, TicksStyle -> 
     Directive[12], PlotRange -> {{-2, 2}, {-2, 2}}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->140702245,ExpressionUUID->"02dbaad7-243c-42d0-be3e-e0a4115dd872"],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
         PointBox[{{-1.3525901546953967`, 
          0.1780718720777711}, {-0.1780718720777711, -1.3525901546953967`}, {
          0.1780718720777711, 1.3525901546953967`}, {
          1.3525901546953967`, -0.1780718720777711}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      StyleBox[
       DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              
              Point[{{-1.3525901546953967`, 
               0.1780718720777711}, {-0.1780718720777711, \
-1.3525901546953967`}, {0.1780718720777711, 1.3525901546953967`}, {
               1.3525901546953967`, -0.1780718720777711}}]}, 
             "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-2., 2.}, {-2., 2.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-2., 2.}, {-2., 2.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> (Identity[
                 Part[#, 1]] + I Identity[
                  Part[#, 2]]& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ComplexListPlot, "GroupHighlight" -> False|>|>],
        ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}],
       Selectable->False]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[Medium]], 
          
          Point[{{-1.3525901546953967`, 
           0.1780718720777711}, {-0.1780718720777711, -1.3525901546953967`}, {
           0.1780718720777711, 1.3525901546953967`}, {
           1.3525901546953967`, -0.1780718720777711}}]}, 
         "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {{-2., 2.}, {-2., 2.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 432}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[Medium]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> (Identity[
              Part[#, 1]] + I Identity[
               Part[#, 2]]& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ComplexListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "MessagesHead" -> ComplexListPlot, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& )}},
  PlotRange->{{-2., 2.}, {-2., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[12]]], "SolvedExampleOutput",
 CellID->745124670,ExpressionUUID->"1d0daa20-129a-4959-b25a-9f483748764c"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->988138608,ExpressionUUID->"e5d2de34-a2b2-4b14-9c92-f21f01844a65"],

Cell[TextData[{
 "In Fig. 2, you can visualize the solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "n"], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"29ac688a-cf37-4544-b824-da7a97aa3703"],
 " for different values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "17119002-98eb-4b71-b490-fbd511dac509"],
 "."
}], "Text",
 CellID->644829999,ExpressionUUID->"8ebfab65-6317-47d9-9474-6ae6e1b20a87"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sol", ",", "zz"}], "}"}], ",", 
      RowBox[{
       RowBox[{"sol", "=", 
        RowBox[{"SolveValues", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox["zz", "n"], "\[Equal]", "1"}], ",", "zz"}], "]"}]}],
        ";", 
       RowBox[{"ComplexListPlot", "[", 
        RowBox[{"sol", ",", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{
                RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], 
               "]"}], ",", "12"}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{
              RowBox[{"ToString", "[", 
               RowBox[{
                RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], 
               "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
         RowBox[{"TicksStyle", "\[Rule]", 
          RowBox[{"Directive", "[", "12", "]"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "10", ",", "1"}], "}"}], ",", 
    RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#1", ",", 
     RowBox[{"\"\<Fig. 2. Solutions of \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"z", "^", "n"}], "==", "1"}], ",", "TraditionalForm"}], 
       "]"}], "<>", "\"\< for integer \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"n", ",", "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}]}], 
    "]"}], "&"}]}]], "Input",
 CellID->215262562,ExpressionUUID->"2ecb8a2a-e730-4293-bc21-63c1734a0911"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`n$$], 1, 10, 1, ControlType -> Manipulator}}, 
       Typeset`size$$ = {240., {107.13997395833333`, 114.37239583333333`}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
        "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Module[{$CellContext`sol$, $CellContext`zz$}, $CellContext`sol$ = 
           SolveValues[$CellContext`zz$^$CellContext`n$$ == 
             1, $CellContext`zz$]; 
          ComplexListPlot[$CellContext`sol$, AspectRatio -> Automatic, 
            PlotStyle -> {Red, 
              PointSize[Medium]}, AxesLabel -> {
              Style[
               ToString[
                Re[$CellContext`z], TraditionalForm], 12], 
              Style[
               ToString[
                Im[$CellContext`z], TraditionalForm], 12]}, TicksStyle -> 
            Directive[12], PlotRange -> {{-2, 2}, {-2, 2}}]], 
        "Specifications" :> {{$CellContext`n$$, 1, 10, 1}}, "Options" :> {}, 
        "DefaultOptions" :> {}], 
       ImageSizeCache -> {290.5, {155.13997395833331`, 162.37239583333331`}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ($CellContext`sol = {-2, 1 + I Sqrt[3], 1 - I 
          Sqrt[3]}; Typeset`initDone$$ = True), SynchronousInitialization -> 
      True, UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   "\"Fig. 2. Solutions of \\!\\(\\*FormBox[RowBox[{SuperscriptBox[\\\"z\\\", \
\\\"n\\\"], \\\"\[LongEqual]\\\", \\\"1\\\"}], TraditionalForm]\\) for \
integer \\!\\(\\*FormBox[\\\"n\\\", TraditionalForm]\\).\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {FontFamily -> "Source Sans Code"}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->63975074,ExpressionUUID->"fdaacb23-9063-4814-bf9e-ce6150d3eba4"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The Complex Function ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]],ExpressionUUID->
  "951500c2-763d-43c9-9667-165571aaff2a"],
 " and Rational Powers of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]],ExpressionUUID->
  "7b3e3148-9705-4b6c-bafe-b36f60e79982"]
}], "Subsection",
 CellID->1058119841,ExpressionUUID->"a85d28f3-a160-4852-9027-0257a0725164"],

Cell[TextData[{
 "The equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "2"], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cb6f7f1c-9de7-4e91-9498-702b1a9a71b4"],
 " has two solutions in the complex plane. But in order to define a \
\[OpenCurlyDoubleQuote]square root\[CloseCurlyDoubleQuote] function, we want \
it to be single valued. For this purpose, it is necessary to choose only one \
of the two solutions. This is a point that one also encounters in real \
analysis, where the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], "=", 
     SqrtBox["z"]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "af6ebb19-43ff-4fc8-a716-86ce816fd909"],
 " is defined by taking the positive solution of the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["w", "2"], "=", "z"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6ec456b3-6458-4cf7-9fff-922af1127169"],
 ". This choice is a matter of convention and of defining what the \
\[OpenCurlyDoubleQuote]square root\[CloseCurlyDoubleQuote] means."
}], "Text",
 CellID->2893102,ExpressionUUID->"dfe64bfb-f0af-478d-9ce4-23161c2024c9"],

Cell[TextData[{
 "What happens in complex analysis is similar: a convention must be chosen in \
order to define ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b4066266-a81f-41ee-85e4-5d38b07cc747"],
 " for complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "0ae9005a-7e17-41c6-aef1-a198b57d7e81"],
 " by picking one of the two roots according to some criterion."
}], "Text",
 CellID->369242603,ExpressionUUID->"05ac8931-8f7c-499f-92e4-0c90ee9bf29f"],

Cell[TextData[{
 "The most common convention, which is also the one followed by Wolfram \
Language, is to start by requiring the complex ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "08f717a3-b72f-4eed-999e-bc7a3fcc98d9"],
 " to agree with the usual real square root on the positive real axis and to \
be continuous around it."
}], "Text",
 CellID->637934722,ExpressionUUID->"2c8b1cb5-451a-4ca5-96bc-d8d753c4aca1"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s see what happens for the square root of the points \
",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"74af5d56-8acf-40ee-9568-93fc7fe33f16"],
 " that lie along the unit circle, starting from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f5723917-8b5d-4175-b047-bcf7c5f64caf"],
 " and moving anticlockwise as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<=", "\[Theta]", "<=", "\[Pi]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"99057ce6-6c81-4e4f-a072-8d2265585c46"],
 ": they are mapped to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", 
     RowBox[{"\[Theta]", "/", "2"}]}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"964a83a7-3a84-4625-916e-8b09f6b15912"],
 " (see Fig. 3). Starting from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3b284b75-350a-4bd2-a258-c58a8e21e1a7"],
 " and moving clockwise as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "<", "\[Theta]", "<=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"c5ab8cfa-222d-4677-8f42-f8f60f654a38"],
 ", they are also mapped to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"\[Theta]", "/", "2"}]}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ef9fe5d4-d407-40e3-b95f-2eb1fbdd1fd6"],
 ", but a discontinuity of the function is inevitable because approaching ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "\[Pi]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c1692650-5639-488b-995a-316fd7e726ba"],
 " from above or from below will lead to either ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d458d430-67df-4f70-a339-6a4156ded76e"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3109aa80-df20-495d-91d2-11cffc13a844"],
 "."
}], "Text",
 CellID->28822803,ExpressionUUID->"ccb2810f-99a4-4d12-b439-475264324c55"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"bezcur", "//", "Clear"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bezcur", "[", 
   RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
  RowBox[{"Arrow", "@", 
   RowBox[{"BezierCurve", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1.1", "*", "p1"}], ",", 
      RowBox[{"1.2", "p1"}], ",", 
      RowBox[{"1.3", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p1", "+", "p2"}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"1.2", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p1", "+", 
          RowBox[{"3", "p2"}]}], ")"}], "/", "4"}]}], ",", 
      RowBox[{"1.2", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p1", "+", 
          RowBox[{"7", "p2"}]}], ")"}], "/", "8"}]}], ",", 
      RowBox[{"1.1", "*", "p2"}]}], "}"}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bezcur2", "//", "Clear"}], ";", 
  RowBox[{
   RowBox[{"bezcur2", "[", 
    RowBox[{"p1_", ",", "p2_"}], "]"}], ":=", 
   RowBox[{"Arrow", "@", 
    RowBox[{"BezierCurve", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1.1", "*", "p1"}], ",", 
       RowBox[{"1.2", "p1"}], ",", 
       RowBox[{"1.6", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p1", "+", "p2"}], ")"}], "/", "2"}]}], ",", 
       RowBox[{"1.35", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p1", "+", 
           RowBox[{"3", "p2"}]}], ")"}], "/", "4"}]}], ",", 
       RowBox[{"1.3", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p1", "+", 
           RowBox[{"7", "p2"}]}], ")"}], "/", "8"}]}], ",", 
       RowBox[{"1.1", "*", "p2"}]}], "}"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Circle", "[", "]"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.004", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{
              RowBox[{"-", "7"}], "/", "4"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"7", "/", "4"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.004", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "7"}], "/", "4"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"7", "/", "4"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
           "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"7", "/", "4"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], "/", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], ",",
           "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"7", "/", "4"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<1\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[ImaginaryI]\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"2", 
               RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"2", 
               RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "0.3", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}]}], "}"}]}], "]"}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Theta]\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "5"}], ",", 
          RowBox[{"2", "/", "5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", "0.025", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "0.4", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"Pi", "/", "5"}]}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Theta]/2\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", 
          RowBox[{"1", "/", "5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"Pi", "/", "5"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", "/", "5"}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "#", "]"}], ",", 
             RowBox[{"Sin", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"4", 
             RowBox[{"Pi", "/", "5"}]}], ",", 
            RowBox[{"2", 
             RowBox[{"Pi", "/", "5"}]}], ",", 
            RowBox[{"Pi", "/", "5"}], ",", 
            RowBox[{"Pi", "/", "10"}], ",", 
            RowBox[{"Pi", "/", "20"}]}], "}"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", "#", "]"}], ",", 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "#", "]"}]}]}], "}"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"4", 
             RowBox[{"Pi", "/", "5"}]}], ",", 
            RowBox[{"2", 
             RowBox[{"Pi", "/", "5"}]}], ",", 
            RowBox[{"Pi", "/", "5"}], ",", 
            RowBox[{"Pi", "/", "10"}], ",", 
            RowBox[{"Pi", "/", "20"}]}], "}"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"bezcur", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "5"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"Pi", "/", "5"}], "]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        RowBox[{"bezcur", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "5"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"Pi", "/", "5"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "10"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"Pi", "/", "10"}], "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        RowBox[{"bezcur", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "10"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"Pi", "/", "10"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "20"}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"Pi", "/", "20"}], "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        RowBox[{"bezcur2", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"4", 
              RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"4", 
              RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"bezcur", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"2", 
               RowBox[{"Pi", "/", "5"}]}], "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "5"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", "/", "5"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        RowBox[{"bezcur", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "5"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", "/", "5"}], "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "10"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", "/", "10"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        RowBox[{"bezcur", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "10"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", "/", "10"}], "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"Pi", "/", "20"}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"Pi", "/", "20"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0025", "]"}], ",", "Dashed", ",", 
        RowBox[{"bezcur2", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"4", 
              RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"4", 
               RowBox[{"Pi", "/", "5"}]}], "]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"2", 
              RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
            RowBox[{"-", 
             RowBox[{"Sin", "[", 
              RowBox[{"2", 
               RowBox[{"Pi", "/", "5"}]}], "]"}]}]}], "}"}]}], "]"}]}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "7"}], "/", "4"}], ",", "0"}], "}"}]}], "}"}], 
         "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.001", "]"}], ",", 
        RowBox[{"Arrow", "@", 
         RowBox[{"BezierCurve", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "/", "2"}], ",", 
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], "/", "2"}], "+", 
               RowBox[{"1", "/", "2"}]}], ",", 
              RowBox[{
               RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], "/", "3"}], ",", 
              RowBox[{
               RowBox[{"-", "1"}], "/", "20"}]}], "}"}]}], "}"}], "]"}]}]}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Branch cut\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "7"}], "/", "4"}], ",", 
          RowBox[{
           RowBox[{"-", "2"}], "/", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}], 
   "\[IndentingNewLine]", 
   ",", "\"\<Fig. 3. The effect of the operation \
\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SqrtBox[\"z\"], \
TraditionalForm]],ExpressionUUID->\"8f3bd7d5-5670-4637-a5ea-fc20149e8d02\"]],\
ExpressionUUID->\"117a01b5-5d7b-4b6d-827a-41fbe4d63a8a\"]\) for complex \
numbers located on the unit circle.\>\""}], "]"}]}], "Input",
 CellID->13046947,ExpressionUUID->"214ea78b-ad16-49e2-93c2-6ac7be6c90a5"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      CircleBox[{0, 0}]}, {
      Thickness[0.004], 
      LineBox[
       NCache[{{0, 
          Rational[-7, 4]}, {0, 
          Rational[7, 4]}}, {{0, -1.75}, {0, 1.75}}]]}, {
      Thickness[0.004], 
      LineBox[
       NCache[{{
          Rational[-7, 4], 0}, {
          Rational[7, 4], 0}}, {{-1.75, 0}, {1.75, 0}}]]}, 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], 
      NCache[{
        Rational[7, 4], 0}, {1.75, 0}], 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{-0.25, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox[
       "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], 
       TraditionalForm], 
      NCache[{0, 
        Rational[7, 4]}, {0, 1.75}], 
      NCache[
       ImageScaled[{
         Rational[1, 2], 0}], 
       ImageScaled[{0.5, 0}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"1\"", 12, StripOnInput -> False], TraditionalForm], {1, 0}, 
      ImageScaled[{0, 1}]], 
     InsetBox[
      FormBox[
       StyleBox["\"\[ImaginaryI]\"", 12, StripOnInput -> False], 
       TraditionalForm], {0, 1}, 
      NCache[
       ImageScaled[{
         Rational[-1, 2], 0}], 
       ImageScaled[{-0.5, 0}]]], {
      Thickness[0.003], 
      LineBox[
       NCache[{{0, 0}, {
         Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
         0.30901699437494745`, 0.9510565162951535}}]]}, {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.3, 
        NCache[{0, Rational[2, 5] Pi}, {0, 1.2566370614359172`}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Theta]\"", 12, StripOnInput -> False], TraditionalForm], 
      
      NCache[{
        Rational[1, 5], 
        Rational[2, 5]}, {0.2, 0.4}], 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]], {
      Arrowheads[0.025], 
      ArrowBox[
       CircleBox[{0, 0}, 0.4, 
        NCache[{0, Rational[1, 5] Pi}, {0, 0.6283185307179586}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Theta]/2\"", 12, StripOnInput -> False], 
       TraditionalForm], 
      NCache[{
        Rational[1, 2], 
        Rational[1, 5]}, {0.5, 0.2}], 
      NCache[
       ImageScaled[{
         Rational[1, 4], 
         Rational[1, 2]}], 
       ImageScaled[{0.25, 0.5}]]], {
      Thickness[0.003], 
      LineBox[
       NCache[{{0, 0}, {
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
         0.8090169943749475, 0.5877852522924731}}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{{
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
         Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^
          Rational[1, 2]}, {(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
          Cos[Rational[1, 20] Pi], 
          Sin[Rational[1, 20] Pi]}}, {{-0.8090169943749475, 
        0.5877852522924731}, {0.30901699437494745`, 0.9510565162951535}, {
        0.8090169943749475, 0.5877852522924731}, {0.9510565162951535, 
        0.30901699437494745`}, {0.9876883405951378, 
        0.15643446504023087`}}]]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[Medium], 
      PointBox[
       NCache[{{
         Rational[1, 4] (-1 - 5^
           Rational[1, 2]), -(Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
         Rational[1, 4] (-1 + 
           5^Rational[1, 2]), -(Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
         Rational[1, 4] (1 + 
           5^Rational[1, 2]), -(Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {(
           Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (1 - 5^Rational[1, 2])}, {
          Cos[Rational[1, 20] Pi], -
          Sin[Rational[1, 20] 
            Pi]}}, {{-0.8090169943749475, -0.5877852522924731}, {
        0.30901699437494745`, -0.9510565162951535}, {
        0.8090169943749475, -0.5877852522924731}, {
        0.9510565162951535, -0.30901699437494745`}, {
        0.9876883405951378, -0.15643446504023087`}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{0.3399186938124422, 1.0461621679246689`}, {
        0.37082039324993693`, 1.141267819554184}, {0.7267220926874317, 
        1.0002471495819574`}, {0.8208203932499369, 0.8143236819517718}, {
        0.8958203932499369, 0.7598329923513698}, {0.8899186938124423, 
        0.6465637775217205}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{0.8899186938124423, 0.6465637775217205}, {
        0.9708203932499369, 0.7053423027509678}, {1.1440477819355657`, 
        0.5829214603338234}, {1.0986559629781223`, 0.4544508706251946}, {
        1.1199618912661533`, 0.4126356319375658}, {1.0461621679246689`, 
        0.3399186938124422}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{1.0461621679246689`, 0.3399186938124422}, {
        1.141267819554184, 0.37082039324993693`}, {1.2601841569786894`, 
        0.3025434486198659}, {1.17423646142417, 0.233496116848692}, {
        1.1797312350691675`, 0.21060873744848452`}, {1.0864571746546516`, 
        0.17207791154425398`}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{-0.8899186938124423, 
        0.6465637775217205}, {-0.9708203932499369, 0.7053423027509678}, {-0.4,
         1.2310734148701012`}, {0.03983647120308953, 1.1613222453975527`}, {
        0.22004156951557377`, 1.177341890783264}, {0.3399186938124422, 
        1.0461621679246689`}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{0.3399186938124422, -1.0461621679246689`}, {
        0.37082039324993693`, -1.141267819554184}, {
        0.7267220926874317, -1.0002471495819574`}, {
        0.8208203932499369, -0.8143236819517718}, {
        0.8958203932499369, -0.7598329923513698}, {
        0.8899186938124423, -0.6465637775217205}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{0.8899186938124423, -0.6465637775217205}, {
        0.9708203932499369, -0.7053423027509678}, {
        1.1440477819355657`, -0.5829214603338234}, {
        1.0986559629781223`, -0.4544508706251946}, {
        1.1199618912661533`, -0.4126356319375658}, {
        1.0461621679246689`, -0.3399186938124422}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{1.0461621679246689`, -0.3399186938124422}, {
        1.141267819554184, -0.37082039324993693`}, {
        1.2601841569786894`, -0.3025434486198659}, {
        1.17423646142417, -0.233496116848692}, {
        1.1797312350691675`, -0.21060873744848452`}, {
        1.0864571746546516`, -0.17207791154425398`}}]]}, {
      Thickness[0.0025], 
      Dashing[{Small, Small}], 
      ArrowBox[
       BezierCurveBox[{{-0.8899186938124423, -0.6465637775217205}, \
{-0.9708203932499369, -0.7053423027509678}, {-0.4, -1.2310734148701012`}, {
        0.03983647120308953, -1.1613222453975527`}, {
        0.22004156951557377`, -1.177341890783264}, {
        0.3399186938124422, -1.0461621679246689`}}]]}, {
      RGBColor[1, 0, 0], 
      Thickness[0.007], 
      LineBox[
       NCache[{{0, 0}, {
          Rational[-7, 4], 0}}, {{0, 0}, {-1.75, 0}}]]}, {
      Thickness[0.001], 
      ArrowBox[
       BezierCurveBox[
        NCache[{{
           Rational[-3, 2], 
           Rational[-1, 2]}, {-1, 
           Rational[-1, 3]}, {-1, 
           Rational[-1, 2]}, {
           Rational[-2, 3], 
           
           Rational[-1, 
            20]}}, {{-1.5, -0.5}, {-1, -0.3333333333333333}, {-1, -0.5}, \
{-0.6666666666666666, -0.05}}]]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"Branch cut\"", 12, StripOnInput -> False], 
       TraditionalForm], 
      NCache[{
        Rational[-7, 4], 
        Rational[-2, 3]}, {-1.75, -0.6666666666666666}], 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]]}], 
   "\"Fig. 3. The effect of the operation \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSqrtBox[\\\"z\\\"], \
TraditionalForm]]]]]\\) for complex numbers located on the unit circle.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->344173534,ExpressionUUID->"a635cb11-9822-4caf-bfac-e01656bfab10"]
}, {2}]],

Cell[TextData[{
 "This is an example of a ",
 StyleBox["branch cut",
  FontSlant->"Italic"],
 ", starting at the ",
 StyleBox["branch point",
  FontSlant->"Italic"],
 " zero. The position of the branch cut is a matter of convention, and in the \
most common convention (also followed by Wolfram Language), the branch cut of \
",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6719ac8a-afbe-4cd3-b822-59fcced89224"],
 " is along the negative real axis."
}], "Text",
 CellID->197748417,ExpressionUUID->"6d850a25-d845-414a-a73d-7eb01854f9f5"],

Cell[TextData[{
 "You could have chosen a different convention, for example, placing the \
branch cut along the positive imaginary axis, obtaining a different \
definition of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "abf72168-fc4b-405c-8de4-5bdf7099f567"],
 " numerically (this book, however, never departs from the standard \
convention). But any definition of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "cb9d1c3b-2bbc-4c47-ba6a-ebd5ca6f6667"],
 " must have a branch cut somewhere, with zero as the branching point."
}], "Text",
 CellID->252919991,ExpressionUUID->"bc0f5746-ec73-4d21-9420-2f30cae6d62b"],

Cell[TextData[{
 "By the same reasoning outlined here, not only ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"1", "/", "2"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e4f2298b-1665-40ea-a990-4ed4123182fa"],
 " (which is ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a79d0754-c74d-4ae1-8230-e63993ec96ad"],
 "), but any rational power of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ff5f0d77-5efe-4763-9d1e-12b99a2673e3"],
 " must have a branch cut. In our convention, the branch cut for all rational \
powers of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "440c59df-4d17-43d9-9acb-9d6b723f811b"],
 " is always located on the negative real axis."
}], "Text",
 CellID->169581963,ExpressionUUID->"473d559b-3079-4526-9bcf-e85a382e7916"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s visualize the function ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ba776665-c7a9-4383-a4be-c865c8a7807a"],
 " using the command ",
 ButtonBox["ComplexPlot3D",
  BaseStyle->"Link"],
 ". You can see the branch cut as a discontinuity in the argument of the \
function, located in the negative real axis. The argument jumps from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "\[Pi]"}], "/", "2"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"39722578-49a7-49aa-ad0b-f49da4326668"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6ebe902e-0f7d-4cd5-b068-087a7f22d6e3"],
 ", which is visible in the sudden color change."
}], "Text",
 CellID->8773170,ExpressionUUID->"cdb7bf01-e56b-40bd-b413-4993fef67125"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot3D", "[", 
   RowBox[{
    SqrtBox["z"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "2"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["3", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["920", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[PlotLegends -> Automatic, AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          HoldForm[
           Abs[
            Sqrt[$CellContext`z]]], TraditionalForm], 12]}, AspectRatio -> 
      Automatic],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["536", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ((("Fig. 4. Plot of the function " <> ToString[
         Sqrt[$CellContext`z], TraditionalForm]) <> " for complex ") <> 
     ToString[$CellContext`z, TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->257450374,ExpressionUUID->"4f3b73d1-baba-4bcf-8b13-04412dca0868"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        SqrtBox["z"], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "2"}], "}"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            FormBox[
             RowBox[{"Re", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12], ",", 
           StyleBox[
            FormBox[
             RowBox[{"Im", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12], ",", 
           StyleBox[
            FormBox[
             TagBox[
              TemplateBox[{
                SqrtBox["z"]},
               "Abs"],
              HoldForm],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12]}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"\"\<Fig. 4. Plot of the function \>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{
               SqrtBox["z"], ",", "TraditionalForm"}], "]"}]}], ")"}], 
           "<>", "\"\< for complex \>\""}], ")"}], "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{"z", ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->1085042893,ExpressionUUID->"ab477735-8715-4752-a5fe-5ca25c71d4c8"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJx1nAl0FeX5h6NYKwUpBEGM/otBRLa61ArI4ogEUFBALJtCVFRwgQpSKJVN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          "], {{{
             EdgeForm[], 
             Texture[
              GraphicsBox[
               TagBox[
                RasterBox[CompressedData["
1:eJzFm3m4l1W1x3vufR45gN0mM8vfAZxQEVFQEEMty+Ysx7LUShNnydDEITUt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                 "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                 RGBColor], 
                BoxForm`ImageTag[
                "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
               ImageSizeRaw -> {144., 144.}, 
               PlotRange -> {{0, 144.}, {0, 144.}}]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNnHncjcUbh895nvZ93xcpUoq0kJQsISQkIWWJSgmVJFEiSpG1CCmSRHbJ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                 "]]}, 
               Annotation[#, 
                "Charting`Private`Tag$62229#1"]& ]]}, {}, {}, {}, {}}, {{
             GrayLevel[0], 
             Line3DBox[CompressedData["
1:eJwl0rVOJkAUBtDB3W3x0CIvgPSwdFSwdFvg7u6SEEpYXgDZelmghxdAGiok
gRZ5AeD8oTi5XzHJnXtnKn4PtgxEhRDWeYgJIZKv1S3K5QbamWaPE254J8Ph
GprpZpMDLnjkk9LoEOpoY5JdjrnilTR9qmhinyc6ueOULrrpoZc++hlgkCGG
GWGUMcaZYJIppplhljnmWWCRJZZZYZVDnlnjnjM6aKSSVF7c+5J/7DBBK7WU
8GHuB87ZZ4MuflJNOm+RPfOfP0zxi3q29XikTL5V/1Iql1BMEYX8oIB88sgl
h2yyyIy8EemkkUoKySSRSALxxBGLVsEI4Sjm+z98AXH0Oxw=
              "]]}}}, VertexNormals -> CompressedData["
1:eJx1XAk0Vt33TiFp0vxFGTKkQUVFA46UhJIhRJIMpWgSRZrMpZTmUkrKEKJJ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           "], VertexTextureCoordinates -> CompressedData["
1:eJyF21+o32UdwPFDaWzQheciipkXYgiBkITroljDqCNFBBnEoIvYQIK6yIZd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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Re", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Im", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
              TagBox[
               TemplateBox[{
                 SqrtBox["z"]}, "Abs"], HoldForm], FontSize -> 12, 
              StripOnInput -> False], HoldForm], TraditionalForm]}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
         "Neutral", Method -> {"RotationControl" -> "Globe"}, 
         PlotRange -> {{-2., 2.}, {-2., 2.}, {0., 1.6817927725145718`}}, 
         PlotRangePadding -> {
           Scaled[0.02], 
           Scaled[0.02], 
           Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 4. Plot of the function \\!\\(\\*FormBox[SqrtBox[\\\"z\\\"], \
TraditionalForm]\\) for complex \\!\\(\\*FormBox[\\\"z\\\", \
TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->1633582141,ExpressionUUID->"b5118a73-a159-4b0f-8734-9ce3eb4909c7"]
}, {3}]],

Cell[TextData[{
 "The vector and stream plots of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b5f71fd4-c2ca-714e-96e3-fc430eaa137f"],
 " are as follows."
}], "Text",
 CellID->141341149,ExpressionUUID->"99e06aae-4565-a943-be31-d0eca4c1032c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ComplexVectorPlot", "[", 
      RowBox[{
       SqrtBox["z"], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "2"}], "}"}], ",", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["3", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["232", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[
        VectorScaling -> Automatic, ImageSize -> Small, PlotLegends -> 
         Automatic],
        SelectWithContents->True,
        Selectable->False]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ComplexStreamPlot", "[", 
      RowBox[{
       SqrtBox["z"], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "2"}], "}"}], ",", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["2", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["168", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[ImageSize -> Small, PlotLegends -> Automatic],
        SelectWithContents->True,
        Selectable->False]}], "]"}]}], "}"}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["432", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 5. Vector and stream plots of " <> ToString[
       Sqrt[$CellContext`z], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->180889944,ExpressionUUID->"b9fd4928-0370-4e88-918e-5126ae4d1166"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       TemplateBox[{
         GraphicsBox[{{{{}}, {{
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.028125000000000008`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{-1.919049515047873, -1.8450395743852979`}, \
{-1.830950484952127, -2.0520747426446757`}}]}}, {
                Arrowheads[{{0.02746440963260056, 1.}}], {
                 LABColor[
                 0.7935000782199334, 0.19812527721483042`, 
                  0.8152568718227564], 
                 
                 ArrowBox[{{-1.6715786003370037`, -1.8490627630239733`}, \
{-1.5784213996629963`, -2.0480515540060003`}}]}}, {
                Arrowheads[{{0.026832358587028003`, 1.}}], {
                 LABColor[
                 0.7715571462313476, 0.2481620688889848, 0.8030158264590114], 
                 
                 
                 ArrowBox[{{-1.424385732066486, -1.8532646774593289`}, \
{-1.325614267933514, -2.0438496395706447`}}]}}, {
                Arrowheads[{{0.026247222455846944`, 1.}}], {
                 LABColor[
                 0.7515458193691257, 0.29379419288450487`, 
                  0.7918523429265184], 
                 
                 ArrowBox[{{-1.1774944449116937`, -1.857634112812807}, \
{-1.0725055550883063`, -2.039480204217166}}]}}, {
                Arrowheads[{{0.025731670411238354`, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{-0.9309203600081202, -1.8621464234700644`}, \
{-0.8190796399918798, -2.0349678935599096`}}]}}, {
                Arrowheads[{{0.02531147642517895, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{-0.6846653894874972, -1.8667600025836006`}, \
{-0.5653346105125028, -2.030354314446373}}]}}, {
                Arrowheads[{{0.025012653192874015`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{-0.438711809281515, -1.871414884280766}, \
{-0.311288190718485, -2.0256994327492075`}}]}}, {
                Arrowheads[{{0.024856963721005595`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{-0.19301844800598988`, -1.8760355130724387`}, \
{-0.056981551994010116`, -2.021078803957535}}]}}, {
                Arrowheads[{{0.024856963721005557`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{0.05247835455745195, -1.880538710508997}, {
                  0.19752164544254805`, -2.0165756065209766`}}]}}, {
                Arrowheads[{{0.025012653192874035`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{0.2978577257657792, -1.8848453492334718`}, {
                  0.4521422742342208, -2.0122689677965018`}}]}}, {
                Arrowheads[{{0.025311476425178964`, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{0.5432028440686137, -1.8888917690274893`}, {
                  0.7067971559313863, -2.008222548002484}}]}}, {
                Arrowheads[{{0.025731670411238323`, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{0.7885892649550774, -1.8926367985068664`}, {
                  0.9614107350449226, -2.0044775185231067`}}]}}, {
                Arrowheads[{{0.02624722245584694, 1.}}], {
                 LABColor[
                 0.7515458193691257, 0.29379419288450487`, 
                  0.7918523429265184], 
                 
                 ArrowBox[{{1.0340769542978205`, -1.8960627136032926`}, {
                  1.2159230457021795`, -2.0010516034266805`}}]}}, {
                Arrowheads[{{0.026832358587028027`, 1.}}], {
                 LABColor[
                 0.7715571462313476, 0.2481620688889848, 0.8030158264590114], 
                 
                 
                 ArrowBox[{{1.2797075189443419`, -1.899171426448501}, {
                  1.4702924810556581`, -1.9979428905814731`}}]}}, {
                Arrowheads[{{0.02746440963260055, 1.}}], {
                 LABColor[
                 0.7935000782199334, 0.19812527721483042`, 
                  0.8152568718227564], 
                 
                 ArrowBox[{{1.5255056045089865`, -1.901978558177983}, {
                  1.7244943954910135`, -1.9951357588519902`}}]}}, {
                Arrowheads[{{0.028125000000000008`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{1.771482415870311, -1.904507643467114}, {
                  1.978517584129689, -1.99260667356286}}]}}, {
                Arrowheads[{{0.027156942109151684`, 1.}}], {
                 LABColor[
                 0.7827832828138461, 0.22256294395088275`, 
                  0.8092784192263519], 
                 
                 ArrowBox[{{-1.7913112477648565`, -1.6315850279042188`}, \
{-1.7086887522351435`, -1.8325165872335356`}}]}}, {
                Arrowheads[{{0.026429110600915736`, 1.}}], {
                 LABColor[
                 0.7577351026329185, 0.2796806789090787, 0.7953050855791669], 
                 
                 
                 ArrowBox[{{-1.5439293688866447`, -1.635893765477785}, \
{-1.4560706311133553`, -1.8282078496599694`}}]}}, {
                Arrowheads[{{0.02573167041123834, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{-1.2968737117045293`, -1.6404169876906125`}, \
{-1.2031262882954707`, -1.8236846274471419`}}]}}, {
                Arrowheads[{{0.0250888824056834, 1.}}], {
                 LABColor[
                 0.7127900130419218, 0.382169630057938, 0.770232097117681], 
                 
                 ArrowBox[{{-1.0501777648113668`, -1.6451403695053481`}, \
{-0.9498222351886332, -1.8189612456324062`}}]}}, {
                Arrowheads[{{0.024531695161273792`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{-0.8038643763157973, -1.650029505190283}, \
{-0.6961356236842027, -1.8140721099474715`}}]}}, {
                Arrowheads[{{0.024095767681528702`, 1.}}], {
                 LABColor[
                 0.6804708933844557, 0.4558673956178874, 0.7522026099894731], 
                 
                 
                 ArrowBox[{{-0.5579361637325387, -1.6550242066147152`}, \
{-0.44206383626746126`, -1.8090774085230392`}}]}}, {
                Arrowheads[{{0.023816264220024898`, 1.}}], {
                 LABColor[
                 0.6715262151062908, 0.4762640775120699, 0.747212747530615], 
                 
                 ArrowBox[{{-0.3123656191767614, -1.6600371935291154`}, \
{-0.18763438082323858`, -1.804064421608639}}]}}, {
                Arrowheads[{{0.023719763693663163`, 1.}}], {
                 LABColor[
                 0.668453431694114, 0.4832709908787462, 0.7454985699922173], 
                 
                 ArrowBox[{{-0.06708962302372674, -1.6649611845451504`}, {
                  0.06708962302372674, -1.799140430592604}}]}}, {
                Arrowheads[{{0.023816264220024894`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{0.1779863859602382, -1.6696851883921158`}, {
                  0.3220136140397618, -1.7944164267456386`}}]}}, {
                Arrowheads[{{0.024095767681528723`, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{0.42297339904583786`, -1.6741146438363383`}, {
                  0.5770266009541621, -1.789986971301416}}]}}, {
                Arrowheads[{{0.024531695161273792`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{0.6679786976214057, -1.6781864312530799`}, {
                  0.8320213023785943, -1.7859151838846745`}}]}}, {
                Arrowheads[{{0.0250888824056834, 1.}}], {
                 LABColor[
                 0.7127900130419218, 0.382169630057938, 0.770232097117681], 
                 
                 ArrowBox[{{0.913089561936471, -1.6818730427575104`}, {
                  1.086910438063529, -1.782228572380244}}]}}, {
                Arrowheads[{{0.02573167041123834, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{1.1583661801217353`, -1.685177095864348}, {
                  1.3416338198782647`, -1.7789245192734064`}}]}}, {
                Arrowheads[{{0.026429110600915736`, 1.}}], {
                 LABColor[
                 0.7577351026329185, 0.2796806789090787, 0.7953050855791669], 
                 
                 
                 ArrowBox[{{1.4038429579089078`, -1.6881214386822325`}, {
                  1.5961570420910922`, -1.7759801764555219`}}]}}, {
                Arrowheads[{{0.027156942109151684`, 1.}}], {
                 LABColor[
                 0.7827832828138462, 0.2225629439508825, 0.809278419226352], 
                 
                 ArrowBox[{{1.6495342203353416`, -1.6907395598040207`}, {
                  1.8504657796646584`, -1.7733620553337337`}}]}}, {
                Arrowheads[{{0.02694258121450808, 1.}}], {
                 LABColor[
                 0.7753592897515621, 0.23949198490316348`, 
                  0.8051368835417487], 
                 
                 ArrowBox[{{-1.9109286147664257`, -1.4139394490642243`}, \
{-1.8390713852335743`, -1.6171494641813104`}}]}}, {
                Arrowheads[{{0.026122660363396128`, 1.}}], {
                 LABColor[
                 0.7473234569574366, 0.3034225082106594, 0.7894968632736377], 
                 
                 
                 ArrowBox[{{-1.6632992671592783`, -1.4183258355337816`}, \
{-1.5867007328407217`, -1.6127630777117532`}}]}}, {
                Arrowheads[{{0.025311476425178978`, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{-1.416005720250149, -1.4229741356342087`}, \
{-1.333994279749851, -1.608114777611326}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{-1.169100343353449, -1.4278858871849849`}, \
{-1.080899656646551, -1.6032030260605499`}}]}}, {
                Arrowheads[{{0.02381626422002491, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-0.9226325284400498, -1.4330424972716316`}, \
{-0.8273674715599502, -1.5980464159739032`}}]}}, {
                Arrowheads[{{0.023209129282198798`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{-0.6766372019796315, -1.438393835858448}, \
{-0.5733627980203685, -1.5926950773870867`}}]}}, {
                Arrowheads[{{0.022761727142172197`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{-0.4311179853588847, -1.4438484924464263`}, \
{-0.3188820146411153, -1.5872404207991084`}}]}}, {
                Arrowheads[{{0.022522757522244863`, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{-0.18602962497780343`, -1.4492739610945002`}, \
{-0.06397037502219657, -1.5818149521510345`}}]}}, {
                Arrowheads[{{0.022522757522244863`, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{0.05872950447173286, -1.454514831644964}, {
                  0.19127049552826714`, -1.5765740816005707`}}]}}, {
                Arrowheads[{{0.022761727142172183`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{0.303304035823659, -1.4594264712638827`}, {
                  0.446695964176341, -1.571662441981652}}]}}, {
                Arrowheads[{{0.023209129282198798`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{0.5478493792356807, -1.463907254643136}, {
                  0.7021506207643193, -1.5671816586023988`}}]}}, {
                Arrowheads[{{0.02381626422002491, 1.}}], {
                 LABColor[
                 0.6715262151062908, 0.4762640775120699, 0.747212747530615], 
                 
                 ArrowBox[{{0.7924980406488642, -1.4679119281827175`}, {
                  0.9575019593511358, -1.5631769850628172`}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{1.0373414305622175`, -1.4714441132693183`}, {
                  1.2126585694377825`, -1.5596447999762164`}}]}}, {
                Arrowheads[{{0.025311476425178975`, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{1.2824296790114413`, -1.4745387363726183`}, {
                  1.4675703209885587`, -1.5565501768729164`}}]}}, {
                Arrowheads[{{0.026122660363396128`, 1.}}], {
                 LABColor[
                 0.7473234569574366, 0.3034225082106594, 0.7894968632736377], 
                 
                 
                 ArrowBox[{{1.5277813789110142`, -1.477245189463489}, {
                  1.7222186210889858`, -1.5538437237820457`}}]}}, {
                Arrowheads[{{0.02694258121450808, 1.}}], {
                 LABColor[
                 0.7753592897515621, 0.23949198490316348`, 
                  0.8051368835417487], 
                 
                 ArrowBox[{{1.773394992441457, -1.4796158418563417`}, {
                  1.976605007558543, -1.551473071389193}}]}}, {
                Arrowheads[{{0.02593054245950263, 1.}}], {
                 LABColor[
                 0.7408369822616863, 0.31821371219469236`, 
                  0.7858783299325707], 
                 
                 ArrowBox[{{-1.7825566139453144`, -1.2005578771821988`}, \
{-1.7174433860546856`, -1.3975183341711168`}}]}}, {
                Arrowheads[{{0.025012653192874042`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{-1.5349512645517835`, -1.2052909232006859`}, \
{-1.4650487354482165`, -1.3927852881526293`}}]}}, {
                Arrowheads[{{0.02409576768152869, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{-1.2877389113272018`, -1.2103506156093835`}, \
{-1.2122610886727982`, -1.3877255957439316`}}]}}, {
                Arrowheads[{{0.023209129282198787`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{-1.040995796509824, -1.2157436665997892`}, \
{-0.959004203490176, -1.3823325447535264`}}]}}, {
                Arrowheads[{{0.022399004130298425`, 1.}}], {
                 LABColor[
                 0.6202033359632736, 0.5364116609915092, 0.6240640497463192], 
                 
                 
                 ArrowBox[{{-0.7947980082605969, -1.2214456792914135`}, \
{-0.7052019917394031, -1.3766305320619017`}}]}}, {
                Arrowheads[{{0.02173102978123891, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{-0.5492020228784855, -1.2273794465326682`}, \
{-0.4507979771215145, -1.370696764820647}}]}}, {
                Arrowheads[{{0.02128344487068099, 1.}}], {
                 LABColor[
                 0.5728658071047388, 0.533327064647182, 0.4131741783834469], 
                 
                 ArrowBox[{{-0.30421283260109266`, -1.2333971947264053`}, \
{-0.19578716739890734`, -1.3646790166269103`}}]}}, {
                Arrowheads[{{0.02112489560420478, 1.}}], {
                 LABColor[
                 0.5662586283862395, 0.532896529302122, 0.38373903245135044`], 
                 
                 ArrowBox[{{-0.059750227734364385`, -1.2392878779422931`}, {
                  0.059750227734364385`, -1.358788333411022}}]}}, {
                Arrowheads[{{0.02128344487068099, 1.}}], {
                 LABColor[
                 0.5728658071047388, 0.533327064647182, 0.4131741783834469], 
                 
                 ArrowBox[{{0.18435908904974752`, -1.2448252730755651`}, {
                  0.3156409109502525, -1.3532509382777504`}}]}}, {
                Arrowheads[{{0.021731029781238934`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{0.4283413408560104, -1.2498360827981723`}, {
                  0.5716586591439896, -1.3482401285551433`}}]}}, {
                Arrowheads[{{0.022399004130298463`, 1.}}], {
                 LABColor[
                 0.6202033359632736, 0.5364116609915092, 0.6240640497463192], 
                 
                 
                 ArrowBox[{{0.6724075736147559, -1.2542400974160608`}, {
                  0.8275924263852441, -1.3438361139372548`}}]}}, {
                Arrowheads[{{0.023209129282198773`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{0.9167055609231314, -1.2580423091668336`}, {
                  1.0832944390768686`, -1.3400339021864816`}}]}}, {
                Arrowheads[{{0.02409576768152869, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{1.161312509932726, -1.2612991943494558`}, {
                  1.338687490067274, -1.3367770170038593`}}]}}, {
                Arrowheads[{{0.025012653192874035`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{1.4062528175240283`, -1.264086841124874}, {
                  1.5937471824759717`, -1.333989370228441}}]}}, {
                Arrowheads[{{0.02593054245950263, 1.}}], {
                 LABColor[
                 0.7408369822616863, 0.31821371219469236`, 
                  0.7858783299325707], 
                 
                 ArrowBox[{{1.651519771505541, -1.2664814917313434`}, {
                  1.848480228494459, -1.3315947196219722`}}]}}, {
                Arrowheads[{{0.0258650271635199, 1.}}], {
                 LABColor[
                 0.7386321674934113, 0.3232413838521383, 0.7846483558520262], 
                 
                 
                 ArrowBox[{{-1.901777446528052, -0.9825969637908996}, \
{-1.848222553471948, -1.1824665456701968`}}]}}, {
                Arrowheads[{{0.02485696372100557, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.3995511971909263, 0.7659798550244337], 
                 
                 
                 ArrowBox[{{-1.6537963632744996`, -0.987365228110096}, \
{-1.5962036367255004`, -1.1776982813510004`}}]}}, {
                Arrowheads[{{0.023816264220024905`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-1.4061828095883806`, -0.9925147371808458}, \
{-1.3438171904116194`, -1.1725487722802506`}}]}}, {
                Arrowheads[{{0.022761727142172193`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{-1.159031533646088, -0.9980841717123803}, \
{-1.090968466353912, -1.166979337748716}}]}}, {
                Arrowheads[{{0.021731029781238923`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{-0.9124572077805823, -1.0040922234282017`}, \
{-0.8375427922194177, -1.1609712860328947`}}]}}, {
                Arrowheads[{{0.020791741493329664`, 1.}}], {
                 LABColor[
                 0.5524730570664615, 0.5319982373142886, 0.3223239684969184], 
                 
                 
                 ArrowBox[{{-0.6665834829866593, -1.0105070494419781`}, \
{-0.5834165170133407, -1.1545564600191183`}}]}}, {
                Arrowheads[{{0.020048739425997497`, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{-0.42150869097035054`, -1.0172004995354338`}, \
{-0.32849130902964946`, -1.1478630099256626`}}]}}, {
                Arrowheads[{{0.019629495263123516`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{-0.17723930960132883`, -1.0239132603713756`}, \
{-0.07276069039867117, -1.1411502490897207`}}]}}, {
                Arrowheads[{{0.01962949526312352, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 ArrowBox[{{0.06638150564082755, -1.0302924451292192`}, {
                  0.18361849435917244`, -1.1347710643318771`}}]}}, {
                Arrowheads[{{0.02004873942599749, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{0.3096687448048855, -1.0360230637601977`}, {
                  0.4403312551951145, -1.1290404457008987`}}]}}, {
                Arrowheads[{{0.02079174149332967, 1.}}], {
                 LABColor[
                 0.5524730570664615, 0.5319982373142886, 0.3223239684969184], 
                 
                 
                 ArrowBox[{{0.55297529471143, -1.040948271743889}, {
                  0.69702470528857, -1.1241152377172074`}}]}}, {
                Arrowheads[{{0.021731029781238923`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{0.7965604686976536, -1.0450745469499658`}, {
                  0.9534395313023464, -1.1199889625111306`}}]}}, {
                Arrowheads[{{0.022761727142172193`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{1.040552416981832, -1.0485002210844603`}, {
                  1.209447583018168, -1.116563288376636}}]}}, {
                Arrowheads[{{0.02381626422002489, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{1.2849829824502979`, -1.0513489451421676`}, {
                  1.4650170175497021`, -1.1137145643189288`}}]}}, {
                Arrowheads[{{0.02485696372100557, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.3995511971909263, 0.7659798550244337], 
                 
                 
                 ArrowBox[{{1.5298334733795478`, -1.0537353914560486`}, {
                  1.7201665266204522`, -1.1113281180050478`}}]}}, {
                Arrowheads[{{0.0258650271635199, 1.}}], {
                 LABColor[
                 0.7386321674934113, 0.3232413838521383, 0.7846483558520262], 
                 
                 
                 ArrowBox[{{1.7750652090603514`, -1.0557543082024963`}, {
                  1.9749347909396486`, -1.1093092012586}}]}}, {
                Arrowheads[{{0.02485696372100558, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{-1.772644881177904, -0.7692105925039491}, \
{-1.727355118822096, -0.9628402150649281}}]}}, {
                Arrowheads[{{0.023719763693663163`, 1.}}], {
                 LABColor[
                 0.668453431694114, 0.4832709908787462, 0.7454985699922173], 
                 
                 ArrowBox[{{-1.5245565063570055`, -0.7743792744037065}, \
{-1.4754434936429945`, -0.9576715331651707}}]}}, {
                Arrowheads[{{0.022522757522244852`, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{-1.2768771201599607`, -0.78003695040609}, \
{-1.2231228798400393`, -0.9520138571627872}}]}}, {
                Arrowheads[{{0.021283444870680995`, 1.}}], {
                 LABColor[
                 0.5728658071047389, 0.533327064647182, 0.4131741783834476], 
                 
                 ArrowBox[{{-1.0297402801099245`, -0.7862552580656529}, \
{-0.9702597198900755, -0.9457955495032243}}]}}, {
                Arrowheads[{{0.02004873942599751, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{-0.783324181174918, -0.7930820683097978}, \
{-0.716675818825082, -0.9389687392590794}}]}}, {
                Arrowheads[{{0.01892174634100467, 1.}}], {
                 LABColor[
                 0.477555909167153, 
                  0.5271165046571359, -0.011433793353590762`], 
                 
                 ArrowBox[{{-0.5378434926820094, -0.8004785517233375}, \
{-0.46215650731799063`, -0.9315722558455397}}]}}, {
                Arrowheads[{{0.01808663972952732, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{-0.2934877416893677, -0.8082080974648747}, \
{-0.20651225831063233`, -0.9238427101040025}}]}}, {
                Arrowheads[{{0.017770459324010068`, 1.}}], {
                 LABColor[
                 0.4335102398713589, 
                  0.5242464116512405, -0.20765834828632876`], 
                 
                 ArrowBox[{{-0.05026244917122893, -0.8157629546132097}, {
                  0.05026244917122893, -0.9162878529556675}}]}}, {
                Arrowheads[{{0.01808663972952733, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{0.192182693680436, -0.8225376620950708}, {
                  0.307817306319564, -0.9095131454738064}}]}}, {
                Arrowheads[{{0.018921746341004665`, 1.}}], {
                 LABColor[
                 0.477555909167153, 
                  0.5271165046571359, -0.011433793353590762`], 
                 
                 ArrowBox[{{0.4344531479388989, -0.8281819111024292}, {
                  0.5655468520611011, -0.903868896466448}}]}}, {
                Arrowheads[{{0.020048739425997497`, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{0.6770566645253593, -0.8327012226095206}, {
                  0.8229433354746407, -0.8993495849593566}}]}}, {
                Arrowheads[{{0.02128344487068101, 1.}}], {
                 LABColor[
                 0.5728658071047389, 0.533327064647182, 0.4131741783834476], 
                 
                 ArrowBox[{{0.9202298542812142, -0.8362851236745141}, {
                  1.0797701457187858`, -0.8957656838943631}}]}}, {
                Arrowheads[{{0.022522757522244852`, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{1.1640115466216514`, -0.8391482836244779}, {
                  1.3359884533783486`, -0.8929025239443993}}]}}, {
                Arrowheads[{{0.023719763693663163`, 1.}}], {
                 LABColor[
                 0.668453431694114, 0.4832709908787462, 0.7454985699922173], 
                 
                 ArrowBox[{{1.4083538706192678`, -0.8414688974274332}, {
                  1.5916461293807322`, -0.8905819101414439}}]}}, {
                Arrowheads[{{0.024856963721005605`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{1.6531851887195104`, -0.8433805226065344}, {
                  1.8468148112804896`, -0.8886702849623428}}]}}, {
                Arrowheads[{{0.025012653192874053`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{-1.8916049082417508`, -0.5508559790050302}, \
{-1.8583950917582492`, -0.7481821266716273}}]}}, {
                Arrowheads[{{0.023816264220024894`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-1.6430034035099403`, -0.5559706240731866}, \
{-1.6069965964900597`, -0.7430674816034709}}]}}, {
                Arrowheads[{{0.02252275752224486, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{-1.3947179578500815`, -0.5616123077005647}, \
{-1.3552820421499185`, -0.7374257979760929}}]}}, {
                Arrowheads[{{0.02112489560420479, 1.}}], {
                 LABColor[
                 0.5662586283862399, 0.532896529302122, 0.3837390324513519], 
                 
                 ArrowBox[{{-1.146870101232683, -0.5678987238712815}, \
{-1.103129898767317, -0.7311393818053761}}]}}, {
                Arrowheads[{{0.01962949526312352, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{-0.8996454504459737, -0.5749692364678314}, \
{-0.8503545495540263, -0.7240688692088262}}]}}, {
                Arrowheads[{{0.018086639729527326`, 1.}}], {
                 LABColor[
                 0.44544884964452375`, 
                  0.5250243523877057, -0.1544715440735793], 
                 
                 ArrowBox[{{-0.6533273852064451, -0.5829489106223388}, \
{-0.5966726147935549, -0.7160891950543188}}]}}, {
                Arrowheads[{{0.016659837341764624`, 1.}}], {
                 LABColor[
                 0.39367419489955513`, 
                  0.5222300436310683, -0.3672559909567861], 
                 
                 ArrowBox[{{-0.40831967468352925`, -0.5918076833947896}, \
{-0.34168032531647075`, -0.7072304222818679}}]}}, {
                Arrowheads[{{0.015721767559349228`, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{-0.1650462217496757, -0.6010310777659555}, \
{-0.0849537782503243, -0.698007027910702}}]}}, {
                Arrowheads[{{0.015721767559349228`, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{0.07651202492762671, -0.609472831088653}, {
                  0.1734879750723733, -0.6895652745880045}}]}}, {
                Arrowheads[{{0.016659837341764624`, 1.}}], {
                 LABColor[
                 0.39367419489955513`, 
                  0.5222300436310683, -0.3672559909567861], 
                 
                 ArrowBox[{{0.3172886305564609, -0.6161993781547995}, {
                  0.4327113694435391, -0.682838727521858}}]}}, {
                Arrowheads[{{0.018086639729527326`, 1.}}], {
                 LABColor[
                 0.44544884964452375`, 
                  0.5250243523877057, -0.1544715440735793], 
                 
                 ArrowBox[{{0.55842985778401, -0.6211916676318837}, {
                  0.69157014221599, -0.6778464380447738}}]}}, {
                Arrowheads[{{0.01962949526312351, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{0.8004501836295027, -0.6248736023923551}, {
                  0.9495498163704973, -0.6741645032843024}}]}}, {
                Arrowheads[{{0.021124895604204795`, 1.}}], {
                 LABColor[
                 0.5662586283862399, 0.532896529302122, 0.3837390324513519], 
                 
                 ArrowBox[{{1.0433796710329526`, -0.6276489516056458}, {
                  1.2066203289670474`, -0.6713891540710117}}]}}, {
                Arrowheads[{{0.02252275752224489, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{1.2870932548622358`, -0.6298010949882473}, {
                  1.4629067451377642`, -0.6692370106884102}}]}}, {
                Arrowheads[{{0.023816264220024894`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{1.5314515712348578`, -0.6315156493283883}, {
                  1.7185484287651422`, -0.6675224563482692}}]}}, {
                Arrowheads[{{0.025012653192874053`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{1.7763369261667015`, -0.632914144596578}, {
                  1.9736630738332985`, -0.6661239610800795}}]}}, {
                Arrowheads[{{0.024095767681528706`, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{-1.761660889113112, -0.3373376268324788}, \
{-1.738339110886888, -0.5286877769519596}}]}}, {
                Arrowheads[{{0.022761727142172207`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{-1.5127516188418269`, -0.3428631828872464}, \
{-1.4872483811581731`, -0.523162220897192}}]}}, {
                Arrowheads[{{0.021283444870680995`, 1.}}], {
                 LABColor[
                 0.5728658071047388, 0.533327064647182, 0.4131741783834469], 
                 
                 ArrowBox[{{-1.2641292347685331`, -0.34905958918120206`}, \
{-1.2358707652314669`, -0.5169658146032363}}]}}, {
                Arrowheads[{{0.019629495263123523`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{-1.0159313220113249`, -0.3561279418449166}, \
{-0.9840686779886751, -0.5098974619395218}}]}}, {
                Arrowheads[{{0.017770459324010068`, 1.}}], {
                 LABColor[
                 0.4335102398713589, 
                  0.5242464116512405, -0.20765834828632876`], 
                 
                 ArrowBox[{{-0.7683973332530939, -0.3643529194678964}, \
{-0.7316026667469061, -0.501672484316542}}]}}, {
                Arrowheads[{{0.015721767559349224`, 1.}}], {
                 LABColor[
                 0.36413673114338385`, 
                  0.5222827853994225, -0.4378489189928766], 
                 
                 ArrowBox[{{-0.5219687073159041, -0.3740876689952285}, \
{-0.47803129268409594`, -0.4919377347892099}}]}}, {
                Arrowheads[{{0.013735823731834443`, 1.}}], {
                 LABColor[
                 0.3046656788130245, 0.5223889762522217, -0.5799814917839473], 
                 
                 ArrowBox[{{-0.27747164746366887`, -0.385430412717524}, \
{-0.22252835253633113`, -0.4805949910669144}}]}}, {
                Arrowheads[{{0.012767710606315534`, 1.}}], {
                 LABColor[
                 0.2771822551571599, 0.5224380503493075, -0.6456653759636946], 
                 
                 ArrowBox[{{-0.03611253899981248, -0.3969001628924067}, {
                  0.03611253899981248, -0.46912524089203167`}}]}}, {
                Arrowheads[{{0.013735823731834447`, 1.}}], {
                 LABColor[
                 0.3046656788130245, 0.5223889762522217, -0.5799814917839473], 
                 
                 ArrowBox[{{0.2024177108253048, -0.40554105442855026`}, {
                  0.2975822891746952, -0.4604843493558881}}]}}, {
                Arrowheads[{{0.015721767559349224`, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{0.4410749671030093, -0.41104399457631513`}, {
                  0.5589250328969907, -0.45498140920812324`}}]}}, {
                Arrowheads[{{0.017770459324010068`, 1.}}], {
                 LABColor[
                 0.4335102398713589, 
                  0.5242464116512405, -0.20765834828632876`], 
                 
                 ArrowBox[{{0.6813402175756772, -0.4146153686391253}, {
                  0.8186597824243228, -0.4514100351453131}}]}}, {
                Arrowheads[{{0.019629495263123527`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{0.9231152399526974, -0.41708137988089433`}, {
                  1.0768847600473026`, -0.44894402390354404`}}]}}, {
                Arrowheads[{{0.021283444870680995`, 1.}}], {
                 LABColor[
                 0.5728658071047388, 0.533327064647182, 0.4131741783834469], 
                 
                 ArrowBox[{{1.1660468872889829`, -0.41888346712368596`}, {
                  1.3339531127110171`, -0.4471419366607524}}]}}, {
                Arrowheads[{{0.022761727142172183`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{1.4098504809950274`, -0.42026108305039234`}, {
                  1.5901495190049726`, -0.44576432073404604`}}]}}, {
                Arrowheads[{{0.024095767681528706`, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{1.6543249249402596`, -0.42135181277910705`}, {
                  1.8456750750597404`, -0.4446735910053313}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{-1.8806372670591882`, -0.11854163127686324`}, \
{-1.8693627329408118`, -0.31447107061535595`}}]}}, {
                Arrowheads[{{0.023209129282198784`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{-1.6311438183125495`, -0.12387335245665415`}, \
{-1.6188561816874505`, -0.30913934943556504`}}]}}, {
                Arrowheads[{{0.021731029781238916`, 1.}}], {
                 LABColor[
                 0.5916799652387434, 0.5345530281649477, 0.4969917219763591], 
                 
                 
                 ArrowBox[{{-1.3817808721583569`, -0.12984712028704187`}, \
{-1.3682191278416431`, -0.3031655816051773}}]}}, {
                Arrowheads[{{0.020048739425997504`, 1.}}], {
                 LABColor[
                 0.5222060940126013, 0.5300259889557225, 0.1874838934256451], 
                 
                 
                 ArrowBox[{{-1.1326120802795263`, -0.13667347880084102`}, \
{-1.1173879197204737`, -0.29633922309137817`}}]}}, {
                Arrowheads[{{0.018086639729527326`, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{-0.883752835896426, -0.14469122405029677`}, \
{-0.866247164103574, -0.2883214778419224}}]}}, {
                Arrowheads[{{0.01572176755934922, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{-0.6354370578246173, -0.1544914218805299}, \
{-0.6145629421753827, -0.2785212800116893}}]}}, {
                Arrowheads[{{0.01276771060631554, 1.}}], {
                 LABColor[
                 0.27718225515715994`, 
                  0.5224380503493075, -0.6456653759636944], 
                 
                 ArrowBox[{{-0.3882181066690876, -0.16717570527720943`}, \
{-0.3617818933309124, -0.26583699661500976`}}]}}, {
                Arrowheads[{{0.009375000000000005, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-0.14375000000000002`, -0.18403039830419313`}, \
{-0.10624999999999998`, -0.24898230358802606`}}]}}, {
                Arrowheads[{{0.009375000000000005, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{0.09252404735808353, -0.19775635094610958`}, {
                  0.15747595264191647`, -0.2352563509461096}}]}}, {
                Arrowheads[{{0.012767710606315541`, 1.}}], {
                 LABColor[
                 0.27718225515715994`, 
                  0.5224380503493075, -0.6456653759636944], 
                 
                 ArrowBox[{{0.32566935433109984`, -0.20328824427702194`}, {
                  0.42433064566890016`, -0.22972445761519725`}}]}}, {
                Arrowheads[{{0.01572176755934922, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{0.5629850709344203, -0.2060692931214922}, {
                  0.6870149290655797, -0.226943408770727}}]}}, {
                Arrowheads[{{0.01808663972952733, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{0.8031848731041872, -0.20775351504968356`}, {
                  0.9468151268958128, -0.22525918684253562`}}]}}, {
                Arrowheads[{{0.02004873942599751, 1.}}], {
                 LABColor[
                 0.5222060940126013, 0.5300259889557225, 0.1874838934256451], 
                 
                 
                 ArrowBox[{{1.0451671278547314`, -0.20889427066658336`}, {
                  1.2048328721452686`, -0.22411843122563582`}}]}}, {
                Arrowheads[{{0.021731029781238927`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{1.2883407693409321`, -0.20972547878775277`}, {
                  1.4616592306590679`, -0.22328722310446641`}}]}}, {
                Arrowheads[{{0.023209129282198766`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{1.5323670015105446`, -0.21036253263356025`}, {
                  1.7176329984894554`, -0.22265016925865894`}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{1.7770352803307536`, -0.21086908388692138`}, {
                  1.9729647196692464`, -0.2221436180052978}}]}}, {
                Arrowheads[{{0.023816264220024898`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-1.75, -0.09526505688009959}, {-1.75, 
                  0.09526505688009959}}]}}, {
                Arrowheads[{{0.02239900413029844, 1.}}], {
                 LABColor[
                 0.6202033359632736, 0.5364116609915092, 0.6240640497463192], 
                 
                 
                 ArrowBox[{{-1.5, -0.08959601652119376}, {-1.5, 
                  0.08959601652119376}}]}}, {
                Arrowheads[{{0.02079174149332967, 1.}}], {
                 LABColor[
                 0.5524730570664615, 0.5319982373142886, 0.3223239684969184], 
                 
                 
                 ArrowBox[{{-1.25, -0.08316696597331869}, {-1.25, 
                  0.08316696597331869}}]}}, {
                Arrowheads[{{0.01892174634100468, 1.}}], {
                 LABColor[
                 0.47755590916715307`, 
                  0.5271165046571359, -0.011433793353590403`], 
                 
                 ArrowBox[{{-1., -0.07568698536401872}, {-1., 
                  0.07568698536401872}}]}}, {
                Arrowheads[{{0.016659837341764624`, 1.}}], {
                 LABColor[
                 0.39367419489955513`, 
                  0.5222300436310683, -0.3672559909567861], 
                 
                 ArrowBox[{{-0.75, -0.0666393493670585}, {-0.75, 
                  0.0666393493670585}}]}}, {
                Arrowheads[{{0.013735823731834445`, 1.}}], {
                 LABColor[
                 0.30466567881302453`, 
                  0.5223889762522217, -0.5799814917839472], 
                 
                 ArrowBox[{{-0.5, -0.05494329492733777}, {-0.5, 
                  0.05494329492733777}}]}}, {
                Arrowheads[{{0.009375000000000008, 1.}}], {
                 LABColor[
                 0.18866752225011313`, 
                  0.5225961012766809, -0.8572107619122566], 
                 
                 ArrowBox[{{-0.25, -0.03750000000000003}, {-0.25, 
                  0.03750000000000003}}]}}, {
                Arrowheads[{{0.009375000000000008, 1.}}], {
                 LABColor[
                 0.18866752225011313`, 
                  0.5225961012766809, -0.8572107619122566], 
                 
                 ArrowBox[{{0.21249999999999997`, 0.}, {0.28750000000000003`, 
                  0.}}]}}, {
                Arrowheads[{{0.013735823731834455`, 1.}}], {
                 LABColor[
                 0.30466567881302453`, 
                  0.5223889762522217, -0.5799814917839472], 
                 
                 ArrowBox[{{0.44505670507266215`, 0.}, {0.5549432949273378, 
                  0.}}]}}, {
                Arrowheads[{{0.016659837341764627`, 1.}}], {
                 LABColor[
                 0.39367419489955513`, 
                  0.5222300436310683, -0.3672559909567861], 
                 
                 ArrowBox[{{0.6833606506329415, 0.}, {0.8166393493670585, 
                  0.}}]}}, {
                Arrowheads[{{0.018921746341004686`, 1.}}], {
                 LABColor[
                 0.47755590916715307`, 
                  0.5271165046571359, -0.011433793353590403`], 
                 
                 ArrowBox[{{0.9243130146359813, 0.}, {1.0756869853640187`, 
                  0.}}]}}, {
                Arrowheads[{{0.020791741493329685`, 1.}}], {
                 LABColor[
                 0.5524730570664615, 0.5319982373142886, 0.3223239684969184], 
                 
                 
                 ArrowBox[{{1.1668330340266813`, 0.}, {1.3331669659733187`, 
                  0.}}]}}, {
                Arrowheads[{{0.02239900413029844, 1.}}], {
                 LABColor[
                 0.6202033359632736, 0.5364116609915092, 0.6240640497463192], 
                 
                 
                 ArrowBox[{{1.4104039834788062`, 0.}, {1.5895960165211938`, 
                  0.}}]}}, {
                Arrowheads[{{0.02381626422002489, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{1.6547349431199005`, 0.}, {1.8452650568800995`, 
                  0.}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{-1.8806372670591882`, 
                  0.11854163127686324`}, {-1.8693627329408118`, 
                  0.31447107061535595`}}]}}, {
                Arrowheads[{{0.023209129282198784`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{-1.6311438183125495`, 
                  0.12387335245665415`}, {-1.6188561816874505`, 
                  0.30913934943556504`}}]}}, {
                Arrowheads[{{0.021731029781238916`, 1.}}], {
                 LABColor[
                 0.5916799652387434, 0.5345530281649477, 0.4969917219763591], 
                 
                 
                 ArrowBox[{{-1.3817808721583569`, 
                  0.12984712028704187`}, {-1.3682191278416431`, 
                  0.3031655816051773}}]}}, {
                Arrowheads[{{0.020048739425997504`, 1.}}], {
                 LABColor[
                 0.5222060940126013, 0.5300259889557225, 0.1874838934256451], 
                 
                 
                 ArrowBox[{{-1.1326120802795263`, 
                  0.13667347880084102`}, {-1.1173879197204737`, 
                  0.29633922309137817`}}]}}, {
                Arrowheads[{{0.018086639729527326`, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{-0.883752835896426, 
                  0.14469122405029677`}, {-0.866247164103574, 
                  0.2883214778419224}}]}}, {
                Arrowheads[{{0.01572176755934922, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{-0.6354370578246173, 
                  0.1544914218805299}, {-0.6145629421753827, 
                  0.2785212800116893}}]}}, {
                Arrowheads[{{0.01276771060631554, 1.}}], {
                 LABColor[
                 0.27718225515715994`, 
                  0.5224380503493075, -0.6456653759636944], 
                 
                 ArrowBox[{{-0.3882181066690876, 
                  0.16717570527720943`}, {-0.3617818933309124, 
                  0.26583699661500976`}}]}}, {
                Arrowheads[{{0.009375000000000005, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{-0.14375000000000002`, 
                  0.18403039830419313`}, {-0.10624999999999998`, 
                  0.24898230358802606`}}]}}, {
                Arrowheads[{{0.009375000000000005, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{0.09252404735808353, 0.19775635094610958`}, {
                  0.15747595264191647`, 0.2352563509461096}}]}}, {
                Arrowheads[{{0.012767710606315541`, 1.}}], {
                 LABColor[
                 0.27718225515715994`, 
                  0.5224380503493075, -0.6456653759636944], 
                 
                 ArrowBox[{{0.32566935433109984`, 0.20328824427702194`}, {
                  0.42433064566890016`, 0.22972445761519725`}}]}}, {
                Arrowheads[{{0.01572176755934922, 1.}}], {
                 LABColor[
                 0.36413673114338374`, 
                  0.5222827853994225, -0.43784891899287676`], 
                 
                 ArrowBox[{{0.5629850709344203, 0.2060692931214922}, {
                  0.6870149290655797, 0.226943408770727}}]}}, {
                Arrowheads[{{0.01808663972952733, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{0.8031848731041872, 0.20775351504968356`}, {
                  0.9468151268958128, 0.22525918684253562`}}]}}, {
                Arrowheads[{{0.02004873942599751, 1.}}], {
                 LABColor[
                 0.5222060940126013, 0.5300259889557225, 0.1874838934256451], 
                 
                 
                 ArrowBox[{{1.0451671278547314`, 0.20889427066658336`}, {
                  1.2048328721452686`, 0.22411843122563582`}}]}}, {
                Arrowheads[{{0.021731029781238927`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{1.2883407693409321`, 0.20972547878775277`}, {
                  1.4616592306590679`, 0.22328722310446641`}}]}}, {
                Arrowheads[{{0.023209129282198766`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{1.5323670015105446`, 0.21036253263356025`}, {
                  1.7176329984894554`, 0.22265016925865894`}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{1.7770352803307536`, 0.21086908388692138`}, {
                  1.9729647196692464`, 0.2221436180052978}}]}}, {
                Arrowheads[{{0.024095767681528706`, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{-1.761660889113112, 
                  0.33733762683247903`}, {-1.738339110886888, 
                  0.5286877769519598}}]}}, {
                Arrowheads[{{0.022761727142172207`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{-1.5127516188418269`, 
                  0.3428631828872466}, {-1.4872483811581731`, 
                  0.5231622208971922}}]}}, {
                Arrowheads[{{0.021283444870680995`, 1.}}], {
                 LABColor[
                 0.5728658071047389, 0.533327064647182, 0.4131741783834476], 
                 
                 ArrowBox[{{-1.2641292347685331`, 
                  0.3490595891812023}, {-1.2358707652314669`, 
                  0.5169658146032365}}]}}, {
                Arrowheads[{{0.019629495263123523`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{-1.0159313220113249`, 
                  0.3561279418449168}, {-0.9840686779886751, 
                  0.509897461939522}}]}}, {
                Arrowheads[{{0.017770459324010085`, 1.}}], {
                 LABColor[
                 0.433510239871359, 0.5242464116512405, -0.2076583482863284], 
                 
                 
                 ArrowBox[{{-0.7683973332530939, 
                  0.3643529194678965}, {-0.7316026667469061, 
                  0.5016724843165423}}]}}, {
                Arrowheads[{{0.015721767559349224`, 1.}}], {
                 LABColor[
                 0.3641367311433839, 0.5222827853994225, -0.4378489189928764], 
                 
                 ArrowBox[{{-0.5219687073159041, 
                  0.3740876689952287}, {-0.47803129268409594`, 
                  0.4919377347892101}}]}}, {
                Arrowheads[{{0.013735823731834445`, 1.}}], {
                 LABColor[
                 0.30466567881302453`, 
                  0.5223889762522217, -0.5799814917839472], 
                 
                 ArrowBox[{{-0.27747164746366887`, 
                  0.3854304127175242}, {-0.22252835253633113`, 
                  0.4805949910669146}}]}}, {
                Arrowheads[{{0.012767710606315536`, 1.}}], {
                 LABColor[
                 0.27718225515716, 0.5224380503493075, -0.6456653759636942], 
                 
                 ArrowBox[{{-0.036112538999812496`, 0.3969001628924069}, {
                  0.036112538999812496`, 0.4691252408920319}}]}}, {
                Arrowheads[{{0.013735823731834447`, 1.}}], {
                 LABColor[
                 0.30466567881302453`, 
                  0.5223889762522217, -0.5799814917839472], 
                 
                 ArrowBox[{{0.2024177108253048, 0.4055410544285505}, {
                  0.2975822891746952, 0.46048434935588833`}}]}}, {
                Arrowheads[{{0.015721767559349224`, 1.}}], {
                 LABColor[
                 0.3641367311433839, 0.5222827853994225, -0.4378489189928764], 
                 
                 ArrowBox[{{0.4410749671030093, 0.41104399457631535`}, {
                  0.5589250328969907, 0.45498140920812347`}}]}}, {
                Arrowheads[{{0.017770459324010092`, 1.}}], {
                 LABColor[
                 0.433510239871359, 0.5242464116512405, -0.2076583482863284], 
                 
                 
                 ArrowBox[{{0.6813402175756771, 0.4146153686391255}, {
                  0.8186597824243229, 0.4514100351453133}}]}}, {
                Arrowheads[{{0.019629495263123527`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{0.9231152399526974, 0.41708137988089455`}, {
                  1.0768847600473026`, 0.44894402390354426`}}]}}, {
                Arrowheads[{{0.021283444870680995`, 1.}}], {
                 LABColor[
                 0.5728658071047389, 0.533327064647182, 0.4131741783834476], 
                 
                 ArrowBox[{{1.1660468872889829`, 0.4188834671236862}, {
                  1.3339531127110171`, 0.44714193666075264`}}]}}, {
                Arrowheads[{{0.022761727142172183`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{1.4098504809950274`, 0.42026108305039256`}, {
                  1.5901495190049726`, 0.44576432073404626`}}]}}, {
                Arrowheads[{{0.024095767681528706`, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{1.6543249249402596`, 0.42135181277910727`}, {
                  1.8456750750597404`, 0.44467359100533155`}}]}}, {
                Arrowheads[{{0.025012653192874053`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{-1.8916049082417508`, 
                  0.5508559790050307}, {-1.8583950917582492`, 
                  0.7481821266716278}}]}}, {
                Arrowheads[{{0.023816264220024894`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-1.6430034035099403`, 
                  0.5559706240731871}, {-1.6069965964900597`, 
                  0.7430674816034714}}]}}, {
                Arrowheads[{{0.02252275752224486, 1.}}], {
                 LABColor[
                 0.6255463011590019, 0.5367598179677607, 0.6478670929129946], 
                 
                 
                 ArrowBox[{{-1.3947179578500815`, 
                  0.5616123077005651}, {-1.3552820421499185`, 
                  0.7374257979760933}}]}}, {
                Arrowheads[{{0.02112489560420479, 1.}}], {
                 LABColor[
                 0.5662586283862399, 0.532896529302122, 0.3837390324513519], 
                 
                 ArrowBox[{{-1.146870101232683, 
                  0.5678987238712819}, {-1.103129898767317, 
                  0.7311393818053765}}]}}, {
                Arrowheads[{{0.019629495263123527`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{-0.8996454504459738, 
                  0.5749692364678318}, {-0.8503545495540262, 
                  0.7240688692088266}}]}}, {
                Arrowheads[{{0.018086639729527326`, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{-0.6533273852064451, 
                  0.5829489106223392}, {-0.5966726147935549, 
                  0.7160891950543192}}]}}, {
                Arrowheads[{{0.016659837341764624`, 1.}}], {
                 LABColor[
                 0.39367419489955524`, 
                  0.5222300436310683, -0.36725599095678585`], 
                 
                 ArrowBox[{{-0.40831967468352925`, 
                  0.5918076833947901}, {-0.34168032531647075`, 
                  0.7072304222818684}}]}}, {
                Arrowheads[{{0.015721767559349228`, 1.}}], {
                 LABColor[
                 0.36413673114338396`, 
                  0.5222827853994225, -0.43784891899287626`], 
                 
                 ArrowBox[{{-0.1650462217496757, 
                  0.601031077765956}, {-0.0849537782503243, 
                  0.6980070279107025}}]}}, {
                Arrowheads[{{0.01572176755934923, 1.}}], {
                 LABColor[
                 0.36413673114338396`, 
                  0.5222827853994225, -0.43784891899287626`], 
                 
                 ArrowBox[{{0.07651202492762671, 0.6094728310886535}, {
                  0.1734879750723733, 0.689565274588005}}]}}, {
                Arrowheads[{{0.016659837341764624`, 1.}}], {
                 LABColor[
                 0.39367419489955524`, 
                  0.5222300436310683, -0.36725599095678585`], 
                 
                 ArrowBox[{{0.3172886305564609, 0.6161993781548}, {
                  0.4327113694435391, 0.6828387275218585}}]}}, {
                Arrowheads[{{0.01808663972952733, 1.}}], {
                 LABColor[
                 0.4454488496445239, 
                  0.5250243523877057, -0.15447154407357858`], 
                 
                 ArrowBox[{{0.55842985778401, 0.621191667631884}, {
                  0.69157014221599, 0.6778464380447744}}]}}, {
                Arrowheads[{{0.019629495263123513`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{0.8004501836295027, 0.6248736023923555}, {
                  0.9495498163704973, 0.674164503284303}}]}}, {
                Arrowheads[{{0.021124895604204795`, 1.}}], {
                 LABColor[
                 0.5662586283862399, 0.532896529302122, 0.3837390324513519], 
                 
                 ArrowBox[{{1.0433796710329526`, 0.6276489516056463}, {
                  1.2066203289670474`, 0.6713891540710122}}]}}, {
                Arrowheads[{{0.02252275752224489, 1.}}], {
                 LABColor[
                 0.6255463011590019, 0.5367598179677607, 0.6478670929129946], 
                 
                 
                 ArrowBox[{{1.2870932548622358`, 0.6298010949882478}, {
                  1.4629067451377642`, 0.6692370106884107}}]}}, {
                Arrowheads[{{0.023816264220024894`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{1.5314515712348578`, 0.6315156493283888}, {
                  1.7185484287651422`, 0.6675224563482697}}]}}, {
                Arrowheads[{{0.025012653192874053`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 ArrowBox[{{1.7763369261667015`, 0.6329141445965785}, {
                  1.9736630738332985`, 0.66612396108008}}]}}, {
                Arrowheads[{{0.02485696372100558, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{-1.772644881177904, 
                  0.7692105925039491}, {-1.727355118822096, 
                  0.9628402150649281}}]}}, {
                Arrowheads[{{0.023719763693663163`, 1.}}], {
                 LABColor[
                 0.668453431694114, 0.4832709908787462, 0.7454985699922173], 
                 
                 ArrowBox[{{-1.5245565063570055`, 
                  0.7743792744037065}, {-1.4754434936429945`, 
                  0.9576715331651707}}]}}, {
                Arrowheads[{{0.022522757522244852`, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{-1.2768771201599607`, 
                  0.78003695040609}, {-1.2231228798400393`, 
                  0.9520138571627872}}]}}, {
                Arrowheads[{{0.021283444870680995`, 1.}}], {
                 LABColor[
                 0.5728658071047389, 0.533327064647182, 0.4131741783834476], 
                 
                 ArrowBox[{{-1.0297402801099245`, 
                  0.7862552580656529}, {-0.9702597198900755, 
                  0.9457955495032243}}]}}, {
                Arrowheads[{{0.02004873942599751, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{-0.783324181174918, 
                  0.7930820683097978}, {-0.716675818825082, 
                  0.9389687392590794}}]}}, {
                Arrowheads[{{0.01892174634100467, 1.}}], {
                 LABColor[
                 0.477555909167153, 
                  0.5271165046571359, -0.011433793353590762`], 
                 
                 ArrowBox[{{-0.5378434926820094, 
                  0.8004785517233375}, {-0.46215650731799063`, 
                  0.9315722558455397}}]}}, {
                Arrowheads[{{0.01808663972952732, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{-0.2934877416893677, 
                  0.8082080974648747}, {-0.20651225831063233`, 
                  0.9238427101040025}}]}}, {
                Arrowheads[{{0.017770459324010068`, 1.}}], {
                 LABColor[
                 0.4335102398713589, 
                  0.5242464116512405, -0.20765834828632876`], 
                 
                 ArrowBox[{{-0.05026244917122893, 0.8157629546132097}, {
                  0.05026244917122893, 0.9162878529556675}}]}}, {
                Arrowheads[{{0.01808663972952733, 1.}}], {
                 LABColor[
                 0.44544884964452386`, 
                  0.5250243523877057, -0.15447154407357894`], 
                 
                 ArrowBox[{{0.192182693680436, 0.8225376620950708}, {
                  0.307817306319564, 0.9095131454738064}}]}}, {
                Arrowheads[{{0.018921746341004665`, 1.}}], {
                 LABColor[
                 0.477555909167153, 
                  0.5271165046571359, -0.011433793353590762`], 
                 
                 ArrowBox[{{0.4344531479388989, 0.8281819111024292}, {
                  0.5655468520611011, 0.903868896466448}}]}}, {
                Arrowheads[{{0.020048739425997497`, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{0.6770566645253593, 0.8327012226095206}, {
                  0.8229433354746407, 0.8993495849593566}}]}}, {
                Arrowheads[{{0.02128344487068101, 1.}}], {
                 LABColor[
                 0.5728658071047389, 0.533327064647182, 0.4131741783834476], 
                 
                 ArrowBox[{{0.9202298542812142, 0.8362851236745141}, {
                  1.0797701457187858`, 0.8957656838943631}}]}}, {
                Arrowheads[{{0.022522757522244852`, 1.}}], {
                 LABColor[
                 0.6255463011590017, 0.5367598179677607, 0.6478670929129938], 
                 
                 
                 ArrowBox[{{1.1640115466216514`, 0.8391482836244779}, {
                  1.3359884533783486`, 0.8929025239443993}}]}}, {
                Arrowheads[{{0.023719763693663163`, 1.}}], {
                 LABColor[
                 0.668453431694114, 0.4832709908787462, 0.7454985699922173], 
                 
                 ArrowBox[{{1.4083538706192678`, 0.8414688974274332}, {
                  1.5916461293807322`, 0.8905819101414439}}]}}, {
                Arrowheads[{{0.024856963721005605`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{1.6531851887195104`, 0.8433805226065344}, {
                  1.8468148112804896`, 0.8886702849623428}}]}}, {
                Arrowheads[{{0.0258650271635199, 1.}}], {
                 LABColor[
                 0.7386321674934113, 0.3232413838521383, 0.7846483558520262], 
                 
                 
                 ArrowBox[{{-1.901777446528052, 
                  0.9825969637908998}, {-1.848222553471948, 
                  1.182466545670197}}]}}, {
                Arrowheads[{{0.024856963721005598`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.3995511971909263, 0.7659798550244337], 
                 
                 
                 ArrowBox[{{-1.6537963632744996`, 
                  0.9873652281100962}, {-1.5962036367255004`, 
                  1.177698281351001}}]}}, {
                Arrowheads[{{0.023816264220024915`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-1.4061828095883806`, 
                  0.992514737180846}, {-1.3438171904116194`, 
                  1.1725487722802508`}}]}}, {
                Arrowheads[{{0.022761727142172204`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{-1.159031533646088, 
                  0.9980841717123805}, {-1.090968466353912, 
                  1.1669793377487163`}}]}}, {
                Arrowheads[{{0.021731029781238923`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{-0.9124572077805823, 
                  1.0040922234282021`}, {-0.8375427922194177, 
                  1.1609712860328951`}}]}}, {
                Arrowheads[{{0.02079174149332967, 1.}}], {
                 LABColor[
                 0.5524730570664615, 0.5319982373142886, 0.3223239684969184], 
                 
                 
                 ArrowBox[{{-0.6665834829866594, 
                  1.0105070494419781`}, {-0.5834165170133406, 
                  1.1545564600191183`}}]}}, {
                Arrowheads[{{0.020048739425997497`, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{-0.42150869097035054`, 
                  1.0172004995354338`}, {-0.32849130902964946`, 
                  1.1478630099256626`}}]}}, {
                Arrowheads[{{0.019629495263123516`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{-0.17723930960132883`, 
                  1.0239132603713756`}, {-0.07276069039867117, 
                  1.1411502490897207`}}]}}, {
                Arrowheads[{{0.019629495263123523`, 1.}}], {
                 LABColor[
                 0.5054188497333666, 0.5289321026971094, 
                  0.11269630159412469`], 
                 
                 ArrowBox[{{0.06638150564082754, 1.0302924451292195`}, {
                  0.18361849435917246`, 1.134771064331877}}]}}, {
                Arrowheads[{{0.020048739425997504`, 1.}}], {
                 LABColor[
                 0.5222060940126014, 0.5300259889557225, 
                  0.18748389342564561`], 
                 
                 ArrowBox[{{0.3096687448048855, 1.0360230637601981`}, {
                  0.4403312551951145, 1.1290404457008991`}}]}}, {
                Arrowheads[{{0.02079174149332967, 1.}}], {
                 LABColor[
                 0.5524730570664615, 0.5319982373142886, 0.3223239684969184], 
                 
                 
                 ArrowBox[{{0.55297529471143, 1.0409482717438894`}, {
                  0.69702470528857, 1.124115237717208}}]}}, {
                Arrowheads[{{0.021731029781238923`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{0.7965604686976536, 1.0450745469499663`}, {
                  0.9534395313023464, 1.119988962511131}}]}}, {
                Arrowheads[{{0.022761727142172204`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{1.040552416981832, 1.0485002210844603`}, {
                  1.209447583018168, 1.116563288376636}}]}}, {
                Arrowheads[{{0.0238162642200249, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 ArrowBox[{{1.2849829824502979`, 1.0513489451421676`}, {
                  1.4650170175497021`, 1.1137145643189288`}}]}}, {
                Arrowheads[{{0.02485696372100557, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.3995511971909263, 0.7659798550244337], 
                 
                 
                 ArrowBox[{{1.5298334733795478`, 1.0537353914560488`}, {
                  1.7201665266204522`, 1.111328118005048}}]}}, {
                Arrowheads[{{0.0258650271635199, 1.}}], {
                 LABColor[
                 0.7386321674934113, 0.3232413838521383, 0.7846483558520262], 
                 
                 
                 ArrowBox[{{1.7750652090603514`, 1.0557543082024965`}, {
                  1.9749347909396486`, 1.1093092012586003`}}]}}, {
                Arrowheads[{{0.02593054245950263, 1.}}], {
                 LABColor[
                 0.7408369822616863, 0.31821371219469236`, 
                  0.7858783299325707], 
                 
                 ArrowBox[{{-1.7825566139453144`, 
                  1.2005578771821988`}, {-1.7174433860546856`, 
                  1.3975183341711168`}}]}}, {
                Arrowheads[{{0.025012653192874042`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{-1.5349512645517835`, 
                  1.2052909232006859`}, {-1.4650487354482165`, 
                  1.3927852881526293`}}]}}, {
                Arrowheads[{{0.02409576768152869, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{-1.2877389113272018`, 
                  1.2103506156093835`}, {-1.2122610886727982`, 
                  1.3877255957439316`}}]}}, {
                Arrowheads[{{0.023209129282198787`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{-1.040995796509824, 
                  1.2157436665997892`}, {-0.959004203490176, 
                  1.3823325447535264`}}]}}, {
                Arrowheads[{{0.022399004130298425`, 1.}}], {
                 LABColor[
                 0.6202033359632736, 0.5364116609915092, 0.6240640497463192], 
                 
                 
                 ArrowBox[{{-0.7947980082605969, 
                  1.2214456792914135`}, {-0.7052019917394031, 
                  1.3766305320619017`}}]}}, {
                Arrowheads[{{0.02173102978123891, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{-0.5492020228784855, 
                  1.2273794465326682`}, {-0.4507979771215145, 
                  1.370696764820647}}]}}, {
                Arrowheads[{{0.02128344487068099, 1.}}], {
                 LABColor[
                 0.5728658071047388, 0.533327064647182, 0.4131741783834469], 
                 
                 ArrowBox[{{-0.30421283260109266`, 
                  1.2333971947264053`}, {-0.19578716739890734`, 
                  1.3646790166269103`}}]}}, {
                Arrowheads[{{0.02112489560420478, 1.}}], {
                 LABColor[
                 0.5662586283862395, 0.532896529302122, 0.38373903245135044`], 
                 
                 ArrowBox[{{-0.059750227734364385`, 1.2392878779422931`}, {
                  0.059750227734364385`, 1.358788333411022}}]}}, {
                Arrowheads[{{0.02128344487068099, 1.}}], {
                 LABColor[
                 0.5728658071047388, 0.533327064647182, 0.4131741783834469], 
                 
                 ArrowBox[{{0.18435908904974752`, 1.2448252730755651`}, {
                  0.3156409109502525, 1.3532509382777504`}}]}}, {
                Arrowheads[{{0.021731029781238934`, 1.}}], {
                 LABColor[
                 0.5916799652387432, 0.5345530281649477, 0.4969917219763584], 
                 
                 
                 ArrowBox[{{0.4283413408560104, 1.2498360827981723`}, {
                  0.5716586591439896, 1.3482401285551433`}}]}}, {
                Arrowheads[{{0.022399004130298463`, 1.}}], {
                 LABColor[
                 0.6202033359632736, 0.5364116609915092, 0.6240640497463192], 
                 
                 
                 ArrowBox[{{0.6724075736147559, 1.2542400974160608`}, {
                  0.8275924263852441, 1.3438361139372548`}}]}}, {
                Arrowheads[{{0.023209129282198773`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{0.9167055609231314, 1.2580423091668336`}, {
                  1.0832944390768686`, 1.3400339021864816`}}]}}, {
                Arrowheads[{{0.02409576768152869, 1.}}], {
                 LABColor[
                 0.6804708933844555, 0.45586739561788764`, 0.752202609989473], 
                 
                 ArrowBox[{{1.161312509932726, 1.2612991943494558`}, {
                  1.338687490067274, 1.3367770170038593`}}]}}, {
                Arrowheads[{{0.025012653192874035`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{1.4062528175240283`, 1.264086841124874}, {
                  1.5937471824759717`, 1.333989370228441}}]}}, {
                Arrowheads[{{0.02593054245950263, 1.}}], {
                 LABColor[
                 0.7408369822616863, 0.31821371219469236`, 
                  0.7858783299325707], 
                 
                 ArrowBox[{{1.651519771505541, 1.2664814917313434`}, {
                  1.848480228494459, 1.3315947196219722`}}]}}, {
                Arrowheads[{{0.02694258121450808, 1.}}], {
                 LABColor[
                 0.7753592897515621, 0.23949198490316348`, 
                  0.8051368835417487], 
                 
                 ArrowBox[{{-1.9109286147664257`, 
                  1.4139394490642245`}, {-1.8390713852335743`, 
                  1.6171494641813107`}}]}}, {
                Arrowheads[{{0.026122660363396128`, 1.}}], {
                 LABColor[
                 0.7473234569574366, 0.3034225082106594, 0.7894968632736377], 
                 
                 
                 ArrowBox[{{-1.6632992671592783`, 
                  1.418325835533782}, {-1.5867007328407217`, 
                  1.6127630777117536`}}]}}, {
                Arrowheads[{{0.025311476425178978`, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{-1.416005720250149, 
                  1.422974135634209}, {-1.333994279749851, 
                  1.6081147776113263`}}]}}, {
                Arrowheads[{{0.024531695161273803`, 1.}}], {
                 LABColor[
                 0.6945540775331139, 0.42375330294687485`, 
                  0.7600590302763963], 
                 
                 ArrowBox[{{-1.169100343353449, 
                  1.427885887184985}, {-1.080899656646551, 
                  1.60320302606055}}]}}, {
                Arrowheads[{{0.023816264220024905`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-0.9226325284400498, 
                  1.4330424972716318`}, {-0.8273674715599502, 
                  1.5980464159739034`}}]}}, {
                Arrowheads[{{0.023209129282198773`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{-0.6766372019796315, 
                  1.4383938358584483`}, {-0.5733627980203685, 
                  1.5926950773870865`}}]}}, {
                Arrowheads[{{0.022761727142172197`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{-0.4311179853588847, 
                  1.4438484924464265`}, {-0.3188820146411153, 
                  1.5872404207991087`}}]}}, {
                Arrowheads[{{0.022522757522244863`, 1.}}], {
                 LABColor[
                 0.6255463011590019, 0.5367598179677607, 0.6478670929129946], 
                 
                 
                 ArrowBox[{{-0.18602962497780343`, 
                  1.4492739610945005`}, {-0.06397037502219657, 
                  1.5818149521510347`}}]}}, {
                Arrowheads[{{0.022522757522244863`, 1.}}], {
                 LABColor[
                 0.6255463011590019, 0.5367598179677607, 0.6478670929129946], 
                 
                 
                 ArrowBox[{{0.05872950447173286, 1.454514831644964}, {
                  0.19127049552826714`, 1.5765740816005707`}}]}}, {
                Arrowheads[{{0.022761727142172183`, 1.}}], {
                 LABColor[
                 0.6359154300365166, 0.5374354885783882, 0.6940618206027117], 
                 
                 
                 ArrowBox[{{0.303304035823659, 1.459426471263883}, {
                  0.446695964176341, 1.5716624419816523`}}]}}, {
                Arrowheads[{{0.023209129282198798`, 1.}}], {
                 LABColor[
                 0.652325570669265, 0.5200475904083741, 0.7365015098669776], 
                 
                 ArrowBox[{{0.5478493792356807, 1.4639072546431364`}, {
                  0.7021506207643193, 1.5671816586023992`}}]}}, {
                Arrowheads[{{0.02381626422002491, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 ArrowBox[{{0.7924980406488642, 1.4679119281827178`}, {
                  0.9575019593511358, 1.5631769850628174`}}]}}, {
                Arrowheads[{{0.024531695161273792`, 1.}}], {
                 LABColor[
                 0.6945540775331139, 0.42375330294687485`, 
                  0.7600590302763963], 
                 
                 ArrowBox[{{1.0373414305622175`, 1.4714441132693183`}, {
                  1.2126585694377825`, 1.5596447999762164`}}]}}, {
                Arrowheads[{{0.025311476425178975`, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{1.2824296790114413`, 1.4745387363726188`}, {
                  1.4675703209885587`, 1.5565501768729169`}}]}}, {
                Arrowheads[{{0.02612266036339614, 1.}}], {
                 LABColor[
                 0.7473234569574366, 0.3034225082106594, 0.7894968632736377], 
                 
                 
                 ArrowBox[{{1.5277813789110142`, 1.4772451894634893`}, {
                  1.7222186210889858`, 1.5538437237820464`}}]}}, {
                Arrowheads[{{0.02694258121450808, 1.}}], {
                 LABColor[
                 0.7753592897515621, 0.23949198490316348`, 
                  0.8051368835417487], 
                 
                 ArrowBox[{{1.773394992441457, 1.4796158418563419`}, {
                  1.976605007558543, 1.5514730713891933`}}]}}, {
                Arrowheads[{{0.02715694210915166, 1.}}], {
                 LABColor[
                 0.7827832828138462, 0.2225629439508825, 0.809278419226352], 
                 
                 ArrowBox[{{-1.7913112477648565`, 
                  1.6315850279042188`}, {-1.7086887522351435`, 
                  1.8325165872335356`}}]}}, {
                Arrowheads[{{0.026429110600915712`, 1.}}], {
                 LABColor[
                 0.7577351026329185, 0.2796806789090787, 0.7953050855791669], 
                 
                 
                 ArrowBox[{{-1.5439293688866447`, 
                  1.635893765477785}, {-1.4560706311133553`, 
                  1.8282078496599694`}}]}}, {
                Arrowheads[{{0.02573167041123834, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{-1.2968737117045293`, 
                  1.6404169876906127`}, {-1.2031262882954707`, 
                  1.823684627447142}}]}}, {
                Arrowheads[{{0.0250888824056834, 1.}}], {
                 LABColor[
                 0.7127900130419219, 0.38216963005793775`, 
                  0.7702320971176811], 
                 
                 ArrowBox[{{-1.0501777648113668`, 
                  1.6451403695053484`}, {-0.9498222351886332, 
                  1.8189612456324065`}}]}}, {
                Arrowheads[{{0.024531695161273792`, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{-0.8038643763157973, 
                  1.6500295051902831`}, {-0.6961356236842027, 
                  1.8140721099474717`}}]}}, {
                Arrowheads[{{0.024095767681528702`, 1.}}], {
                 LABColor[
                 0.6804708933844557, 0.4558673956178874, 0.7522026099894731], 
                 
                 
                 ArrowBox[{{-0.5579361637325387, 
                  1.6550242066147154`}, {-0.44206383626746126`, 
                  1.8090774085230394`}}]}}, {
                Arrowheads[{{0.023816264220024898`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{-0.3123656191767614, 
                  1.6600371935291156`}, {-0.18763438082323858`, 
                  1.8040644216086392`}}]}}, {
                Arrowheads[{{0.02371976369366314, 1.}}], {
                 LABColor[
                 0.668453431694114, 0.4832709908787461, 0.7454985699922173], 
                 
                 ArrowBox[{{-0.06708962302372674, 1.6649611845451506`}, {
                  0.06708962302372674, 1.7991404305926038`}}]}}, {
                Arrowheads[{{0.023816264220024898`, 1.}}], {
                 LABColor[
                 0.671526215106291, 0.4762640775120697, 0.747212747530615], 
                 
                 ArrowBox[{{0.1779863859602382, 1.669685188392116}, {
                  0.3220136140397618, 1.7944164267456388`}}]}}, {
                Arrowheads[{{0.024095767681528706`, 1.}}], {
                 LABColor[
                 0.6804708933844557, 0.4558673956178874, 0.7522026099894731], 
                 
                 
                 ArrowBox[{{0.42297339904583797`, 1.6741146438363388`}, {
                  0.577026600954162, 1.7899869713014165`}}]}}, {
                Arrowheads[{{0.02453169516127381, 1.}}], {
                 LABColor[
                 0.6945540775331138, 0.42375330294687513`, 
                  0.7600590302763962], 
                 
                 ArrowBox[{{0.6679786976214057, 1.67818643125308}, {
                  0.8320213023785943, 1.7859151838846752`}}]}}, {
                Arrowheads[{{0.0250888824056834, 1.}}], {
                 LABColor[
                 0.7127900130419219, 0.38216963005793775`, 
                  0.7702320971176811], 
                 
                 ArrowBox[{{0.913089561936471, 1.6818730427575106`}, {
                  1.086910438063529, 1.7822285723802442`}}]}}, {
                Arrowheads[{{0.02573167041123834, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{1.1583661801217353`, 1.6851770958643482`}, {
                  1.3416338198782647`, 1.7789245192734067`}}]}}, {
                Arrowheads[{{0.026429110600915736`, 1.}}], {
                 LABColor[
                 0.7577351026329185, 0.2796806789090787, 0.7953050855791669], 
                 
                 
                 ArrowBox[{{1.4038429579089078`, 1.6881214386822327`}, {
                  1.5961570420910922`, 1.775980176455522}}]}}, {
                Arrowheads[{{0.027156942109151684`, 1.}}], {
                 LABColor[
                 0.7827832828138462, 0.2225629439508825, 0.809278419226352], 
                 
                 ArrowBox[{{1.6495342203353416`, 1.690739559804021}, {
                  1.8504657796646584`, 1.773362055333734}}]}}, {
                Arrowheads[{{0.028125000000000008`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{-1.919049515047873, 
                  1.8450395743852979`}, {-1.830950484952127, 
                  2.0520747426446757`}}]}}, {
                Arrowheads[{{0.02746440963260056, 1.}}], {
                 LABColor[
                 0.7935000782199334, 0.19812527721483042`, 
                  0.8152568718227564], 
                 
                 ArrowBox[{{-1.6715786003370037`, 
                  1.8490627630239733`}, {-1.5784213996629963`, 
                  2.0480515540060003`}}]}}, {
                Arrowheads[{{0.026832358587028003`, 1.}}], {
                 LABColor[
                 0.7715571462313476, 0.2481620688889848, 0.8030158264590114], 
                 
                 
                 ArrowBox[{{-1.424385732066486, 
                  1.8532646774593289`}, {-1.325614267933514, 
                  2.0438496395706447`}}]}}, {
                Arrowheads[{{0.026247222455846944`, 1.}}], {
                 LABColor[
                 0.7515458193691257, 0.29379419288450487`, 
                  0.7918523429265184], 
                 
                 ArrowBox[{{-1.1774944449116937`, 
                  1.857634112812807}, {-1.0725055550883063`, 
                  2.039480204217166}}]}}, {
                Arrowheads[{{0.025731670411238354`, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{-0.9309203600081202, 
                  1.8621464234700644`}, {-0.8190796399918798, 
                  2.0349678935599096`}}]}}, {
                Arrowheads[{{0.02531147642517895, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{-0.6846653894874972, 
                  1.8667600025836006`}, {-0.5653346105125028, 
                  2.030354314446373}}]}}, {
                Arrowheads[{{0.025012653192874015`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 
                 ArrowBox[{{-0.438711809281515, 
                  1.871414884280766}, {-0.311288190718485, 
                  2.0256994327492075`}}]}}, {
                Arrowheads[{{0.024856963721005595`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{-0.19301844800598988`, 
                  1.8760355130724387`}, {-0.056981551994010116`, 
                  2.021078803957535}}]}}, {
                Arrowheads[{{0.024856963721005557`, 1.}}], {
                 LABColor[
                 0.7051675709809292, 0.39955119719092647`, 
                  0.7659798550244337], 
                 
                 ArrowBox[{{0.05247835455745195, 1.880538710508997}, {
                  0.19752164544254805`, 2.0165756065209766`}}]}}, {
                Arrowheads[{{0.025012653192874035`, 1.}}], {
                 LABColor[
                 0.7102795504602747, 0.38789427493534, 0.7688316148866869], 
                 ArrowBox[{{0.2978577257657792, 1.8848453492334718`}, {
                  0.4521422742342208, 2.0122689677965018`}}]}}, {
                Arrowheads[{{0.025311476425178964`, 1.}}], {
                 LABColor[
                 0.7201490040104007, 0.3653888143395418, 0.7743373708488032], 
                 
                 
                 ArrowBox[{{0.5432028440686137, 1.8888917690274893`}, {
                  0.7067971559313863, 2.008222548002484}}]}}, {
                Arrowheads[{{0.025731670411238323`, 1.}}], {
                 LABColor[
                 0.7341555322215386, 0.3334495213342388, 0.7821510279895308], 
                 
                 
                 ArrowBox[{{0.7885892649550774, 1.8926367985068664`}, {
                  0.9614107350449226, 2.0044775185231067`}}]}}, {
                Arrowheads[{{0.02624722245584694, 1.}}], {
                 LABColor[
                 0.7515458193691257, 0.29379419288450487`, 
                  0.7918523429265184], 
                 
                 ArrowBox[{{1.0340769542978205`, 1.8960627136032926`}, {
                  1.2159230457021795`, 2.0010516034266805`}}]}}, {
                Arrowheads[{{0.026832358587028027`, 1.}}], {
                 LABColor[
                 0.7715571462313476, 0.2481620688889848, 0.8030158264590114], 
                 
                 
                 ArrowBox[{{1.2797075189443419`, 1.899171426448501}, {
                  1.4702924810556581`, 1.9979428905814731`}}]}}, {
                Arrowheads[{{0.02746440963260055, 1.}}], {
                 LABColor[
                 0.7935000782199334, 0.19812527721483042`, 
                  0.8152568718227564], 
                 
                 ArrowBox[{{1.5255056045089865`, 1.901978558177983}, {
                  1.7244943954910135`, 1.9951357588519902`}}]}}, {
                Arrowheads[{{0.028125000000000008`, 1.}}], {
                 LABColor[
                 0.8167969189733053, 0.14500114740169545`, 
                  0.8282532063436999], 
                 
                 ArrowBox[{{1.771482415870311, 1.904507643467114}, {
                  1.978517584129689, 1.99260667356286}}]}}}}}}}, {
          DisplayFunction -> Identity, DisplayFunction -> Identity, 
           PlotRange -> {{-2., 2.}, {-2., 2.}}, DisplayFunction -> Identity, 
           AspectRatio -> 1, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> Small, 
           Method -> {
            "VectorLengthFunction" -> (Sqrt[#]& ), "DefaultBoundaryStyle" -> 
             Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
           Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
           AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic,
            BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
           Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, 
           FormatType :> TraditionalForm, FrameLabel -> None, 
           FrameStyle -> {}, FrameTicksStyle -> {}, GridLines -> None, 
           ImageMargins -> 0., ImagePadding -> All, ImageSizeRaw -> Automatic,
            LabelStyle -> {}, PlotLabel -> None, PlotRegion -> Automatic, 
           PreserveImageOptions -> Automatic, Prolog -> {}, RotateLabel -> 
           True, TicksStyle -> {}, DisplayFunction -> Identity, AspectRatio -> 
           1, DisplayFunction :> Identity, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> Small, 
           Method -> {
            "VectorLengthFunction" -> (Sqrt[#]& ), "DefaultBoundaryStyle" -> 
             Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, 
           PlotRange -> {{-2., 2.}, {-2., 2.}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
         FormBox[
          FormBox[
           TemplateBox[{
             FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 GraphicsBox[{
                   RasterBox[CompressedData["
1:eJxt13k01dvfB3AZUoiUeUylqKQBGXLfKEMpKqSQIU0qilQUlSGiFBkq1Lnp
JtdNdRxlKiRkPsdxjtnhOIN5uCUZGn6e9fz1/L7PXuuz1l6v/cfe+7P32mt/
NI6eO3BcSEBAoGY+FszH//T/u724EOV39AQfMpUbS2Oev0APSf9bpKoz0nUS
nJNd+NjmORK4Iz4PMZazBxsVTsFcmMOptOOjOn1M21S4GHUugx7TjQEIWWEn
MmnBBzedFCa8vgz/xnqeLV16BeXcaznq2/hI/K0XOBVcDsqjQ/6UwRtIPjPX
YLOeD7rA4L/RsRUQG3TM3iNxE7eFVh06p84HxW/PoZqzVfjHXyJbwD8G3Cwd
08TlfBjcShtcuL4aKhdOFP6lcBeXQ9b75Ynycetp0xG7+hqMyT5fKhqeAClD
4S76HA+vtCLtcp3qUOJrL7tYKQmKf166PDbOg7TNXrMftfXQ79WU+sRIQcAX
+c2iXB5C/N+2yOo2okciPYOU+wjxBxxmVNp4MNR2i9kdScXb+5qBi/PSkbLF
p0y3ngdJCtXK6AQNQ9IGWmfaSUgo9LuEMh4y77Ino4WbUJP0J/lBwlOkr9kr
viePh05HzlHy4yaQtncf67V5hv5NH/2csngouyL422QLHQPGCcYlS5/j7jGX
eNd0Ho6aGAw9KqdjTttOwJaZiY0hVzzc43nw2H5seoN9MxzJH8l5yVlYlu9Y
dySSh2DTVe93tTXj98438ucPZOPX+tHyw0E8lPqmso3cGchMSchki7+Ej4KC
/oGzPNyXFxf9g83AKa+UE57lOVDZELzU2pOHac3PW+95McFWnd1ueOk1pJvC
dxg68vBFZYmIZw8TE6N0FjPxDZ6eu/he04aHgA+9T7tdWqAolUu7coaMtFfu
PlLbefhoHxa+idGC1/sos6stchH9WsHwmy4PMS+/yITatmJbRXXMsDwF+Va7
5FpX8eB1psKSW9YK4+sPt3FGKFDR9fo3T54Huf0pXyL02hDyLISk9jEPVKO0
d3fFeVD8lrb7cmYbXngn3nyV9BY6wXMHjv3mwnxx4IpWuXa4KEQvyzj5Di4n
7Sj6X7nQaf+qW3SzHaLMVQtFjfOhsEirQrCfi3GZX4f1v7bD47Bn36B4AWpE
OP51HVwI9Uq3uXp0IC1l3dKD3QVIrSFl3WvkYipq5BRqO7AvS+S306tChN7d
4WhfzoVpgPPlia2d+HDEwezrtSLM+V32FHvHRVzuou3X0jsxQ559YmBfjFe+
LwrK/uZiSZFD55RQF1wdf2zVUn+P7UELbAIecyG7xvr6ydNdYD4/G0Qde4+c
Y4EzaglcbFcv8uuidqFlVN9pa8kH8AZe5VdFcuEV8E7DS68bQz2Tm1ziSmB+
R83XJ4iL6KVpDgIPu1Esovdjl1sppu6PCYme5aLSYefyitlu1NSqq0XKlsGE
s/AEyYML90dXm966sbBCyUusIaQMXI5Y6BYHLvizPF/WBxZUmrW1BLllcHM8
tKXMios1jU8trNR60LVaMk/T9iPqVBeeszHmgllZvPFbaA+ibjlVGuV+hLwq
R7lOhwtS+xPSl64eXKaI7zdTLEcFL1DDRoMLx8zG+gzVXhj5lG8wuVEOs9Cp
k6UyXOy+0+JxZU8vmu4vkd7QX454SefWTYu4sLfZpiN0tRcJRR/TZOw+YXmK
oXP6HAei92x0zf7uRcHU3P6pvE9YcXOsccE4B7+LHIz0WnvR4DnzlK5cAcsj
IZpefRyMwHSWLczGX76fuNnhFeixSDIvYnIgqzn5y3YLG5K0tx43BivQFJW8
eEkNBxd8cvICPdggz7AtHfdVYu3a296H33PACp847X6HDTeaQ+Ha/EroWK3T
J73mIDI+2Em8kI0jpcb1c6pV6HlA82ZlcPDY4VtcKI+NzNGZsKbIKnhXhjPk
UjiovpMqmy/dh82SK2l/D1dBrmrojE0MBwrfn7UUmvaBOnuQdPPAZ0hsPCh5
IYSDX2U5z6N9+iAjuqr+eOFnPPLPI6Wc4+CDzIzFyuQ+8KsK19quqEaoarIQ
5ej8On8+cL1d1gcO9Z8gg+hqXBNao1rtxIH4+4jYiuE+kFruXNUaq0any2Yq
04aDFHfSYaocBxZecRwNpxrcYCj/6DThwDKVrhQxP04V3NTjXlQDP0pClLQG
B3G+r4IRzcFDH13hbJVaeM6Mxb8Z6sPVcfoRzcr5vLoofq2/XoshZ6E527w+
zAVXPPpDkIvv6bqepZxanPRgNfSFzu//c7lH0h9ckOX63IJt6rDMNlEk0LoP
zvve2+te4SLq7C7Hrzl1cGaejv+1tA9k0fcR8m+5SIx6IbpGph7LDUTswjrm
z1VMOM1xnIuIgi+xYlfrwW44LTn3jA01J4GKUS0ejsWeM0/tq4dU6+KE075s
ULYYVA568cDwcOto3N0A652kiEYDNsz67UXsU3lIekDem0FpwNmSRWGaAmxw
SR73V9F5kNGdbpNUbYRv4E8pv5pe/BTx1/JdzIdCsOEPyehGnND+52nm/V4w
skO3bTbjo1xc8PLjfxshnq4X3+Dai7/amAOBl/hIyYmzfOtGxXcRSVX26l7I
LFuy2vQlH0uLZh7vr6aCLHmKVdLZg4GHlxPvsvloSaVNGSjRcD3Xf2Wcbw9G
X+7M8pXrx6bPVsPh+2iY1rJiaf1mIacKT1i7++F+NixFLJqGPec3Z8XFs7Cq
1fw671o/nBUTZ+s+0KBR8if1nQYLQTdd1kTl9iN+yH1T5SQN+ucjnEm53TAJ
KrCo4PXDcOXNE5Prm2CdozRhvqMb94cOujxTGEDRT9deZ+8mSN/RnHjY3AU5
5Uv1a2wHMOs3OTma2gTDDse9T7y7sD+K07w/dABPDq+TfEtvQubxsUTbr50Y
cpKLWft6AOUTpS/+EaNjYXdE96PwTox+W8XN7h0AozHCjmZBB7sjvSpMuhPL
DsWXsKQHUe0RRtK4SofPvo3ec6QOPJH6yai0GESOvon1EwodusqUzb90OiCg
XlR99MIgLHvGBCxH6DBkkSXCitvRudBEo+DZIMI72Mkyms1YOxqgdMWmHYdO
BOytbh6Ek2l+l7h7M2raHxexGG0Q2iH3PFloCC3khgLtB80ouHHK/5lnG1I7
G31Wbh2C5vHnir60Zoy+nqAWD7cionh/9fmjQ7C4vXeWsZiB6J6dh5UutaIg
/XR7eMIQ0lTaPT13MOA3EuX95ncL7tz4muFSNoSzFzuOSIYyoDZ5YdL3VgvM
bD4ozI4NITqcJ856x8C3+MCH5ktbYDjto+qtOowD2gr3GicYiHVbs1XhARM7
8o0iHtgO49DjLJmedUzUp0hVd6kw0R1eJ/EoeBgLDwXTJY8zMV3caRT0lIGE
ELqvz4thFJ7OXXiExMTOItlftNUMpD4tsxVjDiON7/G9up0JCZna8trMZkT/
c/KPUMERPFaQ/bJfpgUPpioErdY2Q7s2nvZJdwQ6rkm23+1a4F6qE6meSUdJ
6+0bPW4jaDW/6lEQ04Kgmdli3VV0jKW9K2uKGYER/8u9pIoW1K37Kbn7SROc
Mn98T3s3gqMrjlnens+L0EQb30S+CV5/7AsHZwRKl3XH0oxbcd5yNK4ujgZq
lwr5g9Qotjw49avyYivqB1zL3i2gQS+VUie/fRTqq5PHF5FbsVDgd64XrxF+
38hS9qdGofjWz+zYSCv0zBq/lZU1QNnOm3wsaRR/Ml8Etq5tw1Yb5W8FSfUY
OanadbhsFFfZFJmj3m2ouHg73d6zDmGWD3N1R0bRkpKQI0Rqww9F98WHVtZC
6i9z+375MVCNH9KKO9oQlrHA1Lu9Go9d71SE7RhDwUbr5bHz/xT3iSfHsyM+
o6DPRFXg3BhEWuSl/A60Y2n555XjalUI2fTSzTt1DMxX+71O3m2H9YrFUbZZ
FfDcKnf9ZeUY1t/ozb5Y2w5NlwxPvvKn+fvfFNw1MYac8A3xDxd24OPn6eSL
gR+R5hhvMqk8DqvTkwVUiw4seDPcVuJYiitOpJeTVuPYZahNU7regcrA1Z8V
jxXDtFHxNct/HIUldRHBxR348kt+ye2Jd8if01CnpI9Dq7Qucvh7B3RPyOcl
kMnI2C3THPB5HMfjB6LO63Xi0YUz46yp5zhVWpCm9mUcatsSzRb5d8JJOYrX
3XIT/1uFTCAyLmqo/2Mn/m91MoE2nivXXqWL4P7T9jNil4hunWApu4JKdOFt
lmXJa7sJbisxrRlwneikjedViluIfsHrwLpLOiyCe9oG3MmKILqHx4SxczvR
+17xR6M29hB81PqNxvYIom/wYCpdbSX6qWz65DPZXoK72H4ycADR00oWbGg4
RXQD44YHy+8T/e+Y9dpaxUT/nqgSIsEl+m3lfKVyCTbBLxZvurZbn+iMCbrU
iyNE96axtNtvEn2a5anQl0N0nvuU4icm0St33PQM/Un0kd5+6WWafQTX2htn
E76H6Ax3KRnqBaIvlyoNnkkluoiA1kXBcqJ7Nt2eHhog+vUep1GKFId4b39E
67kbEN0hY8WLITei/6l+Vc4lguh6Ktl7cv4mesBQvQSPSvR10x7LBaeIrpl/
S05EhUtwI9sjVWPmRN9ipdVQepLoVEoWNSiO6CUUO18lCtEn2wPNnrcR3Tg2
haX4i+jJ1yPagubryf/2uy/ji8ptiG70pEpi2pfovbeWOCgmEv38SuclawuI
rn62Kl+j+/+ZN5ZZu1iQT/CMmuDinjVEH+Fbzj2zJbrx+9jpg+eJ/tTrktpM
EtFNuzczYwuJrnfxZ5gEi+g6+bbR1wT7ie+MdedO9hqim92iyuvbEv1f7WqX
K+eIHkn+fpycSPRPwkb3OvKJvnvR6nVTnUSfdNW4JSwwgO8SM6VifDH8B7uN
uqw=
                    "], {{
                    Rational[-15, 2], -90}, {
                    Rational[15, 2], 90}}], {Antialiasing -> False, 
                    AbsoluteThickness[0.1], 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]], 
                    LineBox[
                    NCache[{{
                    Rational[15, 2], -90}, {
                    Rational[-15, 2], -90}, {
                    Rational[-15, 2], 90}, {
                    Rational[15, 2], 90}, {
                    Rational[15, 2], -90}}, {{
                    7.5, -90}, {-7.5, -90}, {-7.5, 90}, {7.5, 90}, {
                    7.5, -90}}]]}, {
                    CapForm[None], {}}, 
                   StyleBox[{Antialiasing -> False, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.499999999999999, -90.}, 
                    Offset[{4., 0}, {7.499999999999999, -90.}]}, {{
                    7.499999999999999, -35.12195121951219}, 
                    
                    Offset[{4., 0}, {
                    7.499999999999999, -35.12195121951219}]}, {{
                    7.499999999999999, 19.75609756097561}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    19.75609756097561}]}, {{7.499999999999999, 
                    74.63414634146342}, 
                    
                    Offset[{4., 0}, {7.499999999999999, 
                    74.63414634146342}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.499999999999999, -79.02439024390243}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -79.02439024390243}]}, {{
                    7.499999999999999, -68.04878048780488}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -68.04878048780488}]}, {{
                    7.499999999999999, -57.073170731707314`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -57.073170731707314`}]}, {{
                    7.499999999999999, -46.09756097560975}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -46.09756097560975}]}, {{
                    7.499999999999999, -24.14634146341463}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -24.14634146341463}]}, {{
                    7.499999999999999, -13.170731707317078`}, 
                    
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -13.170731707317078`}]}, {{
                    7.499999999999999, -2.195121951219509}, 
                    Offset[{2.5, 0.}, {
                    7.499999999999999, -2.195121951219509}]}, {{
                    7.499999999999999, 8.780487804878051}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    8.780487804878051}]}, {{7.499999999999999, 
                    30.73170731707319}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    30.73170731707319}]}, {{7.499999999999999, 
                    41.707317073170735`}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    41.707317073170735`}]}, {{7.499999999999999, 
                    52.6829268292683}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    52.6829268292683}]}, {{7.499999999999999, 
                    63.65853658536584}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    63.65853658536584}]}, {{7.499999999999999, 
                    85.60975609756098}, 
                    
                    Offset[{2.5, 0.}, {7.499999999999999, 
                    85.60975609756098}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -90.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, -35.12195121951219}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 19.75609756097561}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.499999999999999, 74.63414634146342}], 
                    
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                    "GraphicsAxes"}, StripOnInput -> False]}, 
                  PlotRangePadding -> Scaled[0.02], PlotRange -> All, Frame -> 
                  True, FrameTicks -> {{False, False}, {True, False}}, 
                  FrameStyle -> Opacity[0], FrameTicksStyle -> Opacity[0], 
                  ImageSize -> {Automatic, 180}, BaseStyle -> {}], Alignment -> 
                 Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]}, "BarLegend", 
            DisplayFunction -> (#& ), 
            InterpretationFunction :> (RowBox[{"BarLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                    "[", "#1", "]"}], "&"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.`", ",", "1.644434083993029`"}], "}"}]}], 
                   "}"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
                 RowBox[{"LegendMarkerSize", "\[Rule]", "180"}], ",", 
                 RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
                 RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
               "]"}]& )], TraditionalForm], TraditionalForm]}, "Legended", 
        DisplayFunction -> (GridBox[{{
            TagBox[
             ItemBox[
              PaneBox[
               TagBox[#, "SkipImageSizeLevel"], 
               Alignment -> {Center, Baseline}, BaselinePosition -> Baseline],
               DefaultBaseStyle -> "Labeled"], "SkipImageSizeLevel"], 
            ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           AutoDelete -> False, GridBoxItemSize -> Automatic, 
          BaselinePosition -> {1, 1}]& ), 
        InterpretationFunction -> (RowBox[{"Legended", "[", 
           RowBox[{#, ",", 
             RowBox[{"Placed", "[", 
               RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> 
        True], 
       TemplateBox[{
         GraphicsBox[{{{{}}, {{
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5913564057498271, 0.5345319444615785, 0.4955502563857128], 
                 
                 
                 ArrowBox[{{-1.0433318224856407`, 
                  0.0008851231783404941}, {-1.0433315622763033`, \
-0.0009935113449986788}, {-1.0433263906595995`, -0.004750780296506605}, \
{-1.0433144536639483`, -0.008508049248014566}, {-1.043199051891851, \
-0.023537125054029922`}, {-1.0416549843494824`, -0.08365342844934712}, \
{-1.0383789798653114`, -0.14376973186806974`}, {-1.033371038152723, \
-0.20388603499095853`}, {-1.0266311592117177`, -0.2640023378180136}, \
{-1.0190373772155623`, -0.3178880792821298}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5966062527173474, 0.5348740336908807, 0.5189384555239426], 
                 
                 
                 ArrowBox[{{-1.0178735473400915`, -0.3258024331867061}, \
{-1.007955602922182, -0.38423495559535825`}, {-0.9960199521291035, \
-0.44435129656711925`}, {-0.9823523906630602, -0.5044676632645179}, \
{-0.966952918524052, -0.5645840556875543}, {-0.9498215236802208, \
-0.6247004378121603}, {-0.9458623025402739, -0.6373182456359573}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6115987608175903, 0.5358509717946104, 0.585730452928704], 
                 
                 ArrowBox[{{-0.9434672001785559, -0.6449512977566292}, \
{-0.9309581940997086, -0.6848167736142681}, {-0.9103629297825158, \
-0.7449330630938775}, {-0.888035730728642, -0.8050493062509886}, \
{-0.876543509599252, -0.8348369118361315}, {-0.8646271080638351, \
-0.8646271332525103}, {-0.8298514881264715, -0.9416258131423988}, \
{-0.828953902430299, -0.9434609961220692}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6340607599874931, 0.5373146350274931, 0.6857992192905898], 
                 
                 
                 ArrowBox[{{-0.8254390042114125, -0.9506474758243204}, \
{-0.7922128486556711, -1.0185809059311006`}, {-0.7717044511829214, \
-1.0596830501908494`}, {-0.7503854444505708, -1.1007848445017354`}, \
{-0.7282558284586191, -1.1418862888637584`}, {-0.7053156032070667, \
-1.1829873832769189`}, {-0.6815647686959133, -1.2240881277412163`}, \
{-0.6759628422051563, -1.2334622260623715`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.656830986176782, 0.50977382493016, 0.739014893021003], 
                 
                 ArrowBox[{{-0.6718590198919271, -1.2403294411035248`}, \
{-0.657003324925159, -1.265188522256651}, {-0.6316312718948036, \
-1.306288566823223}, {-0.6054486096048477, -1.347388261440932}, \
{-0.5784553380552906, -1.3884876061097782`}, {-0.5506514572461327, \
-1.4295866008297617`}, {-0.5220369671773738, -1.4706852456008825`}, \
{-0.4957599872715535, -1.5073865343597315`}}]}}, {
                Arrowheads[{{0.01277707782258814, 1.}}], {
                 LABColor[
                 0.6791027129235516, 0.45898727771616443`, 
                  0.7514393592490329], 
                 
                 ArrowBox[{{-0.4910757258796388, -1.5138715443404762`}, \
{-0.46237615926105335`, -1.5528814852965356`}, {-0.43132984141349173`, \
-1.5939790802210678`}, {-0.39947291430632914`, -1.6350763251967373`}, \
{-0.3668053779395658, -1.6761732202235438`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3453719343344398, 0.5223162916129106, -0.4826957603358096], 
                 
                 ArrowBox[{{-0.17906265262513796`, -0.0004866550338722438}, \
{-0.1790579061685351, -0.0019069587932875876`}, {-0.1790463199691193, \
-0.003469293040332704}, {-0.1744377545653851, -0.0575580557968603}, \
{-0.16166001937919677`, -0.11164681885888014`}, {-0.1407131144105543, \
-0.1657355822263924}, {-0.11159703965945765`, -0.21982434589939712`}, \
{-0.07325454205431833, -0.2752919285001878}, {-0.060145658434296166`, \
-0.2907844578268123}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3928987278298814, 0.5222378219614374, -0.3689120939091029], 
                 
                 ArrowBox[{{-0.05497816177375978, -0.2968915830313046}, \
{-0.02632107646123425, -0.3307595116428434}, {
                  0.029203386987430045`, -0.3862255192933125}, {
                  0.060187275681666534`, -0.4139577646619884}, {
                  0.09331883291532506, -0.44169072276551197`}, {
                  0.12489080062396925`, -0.46656868234617466`}, {
                  0.1581949820190269, -0.491448027736705}, {
                  0.18314164816948472`, -0.5091636429817181}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.47209704312658524`, 
                  0.5267607953787063, -0.035753177673858993`], 
                 
                 ArrowBox[{{0.1896642822290598, -0.5137956236514609}, {
                  0.19323137710049798`, -0.5163287589371031}, {
                  0.2299999858683826, -0.5412108759473687}, {
                  0.2685008083226806, -0.566094378767502}, {
                  0.30873384446339197`, -0.5909792673975028}, {
                  0.35069909429051677`, -0.6158655418373713}, {
                  0.394396557804055, -0.6407532020871075}, {
                  0.4398262350040068, -0.6656422481467114}, {
                  0.46388273553259146`, -0.6783384457794011}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5442887554770499, 0.5314649338788894, 0.2858627008514528], 
                 
                 
                 ArrowBox[{{0.470957848611482, -0.6820724483129985}, {
                  0.486988125890372, -0.6905326800161828}, {
                  0.5358822304631506, -0.715424497695522}, {
                  0.5865085487223426, -0.7403177011847287}, {
                  0.6388670806679482, -0.765212290483803}, {
                  0.6929578262999672, -0.790108265592745}, {
                  0.7487807856183996, -0.8150056265115547}, {
                  0.7597476632107677, -0.8197499699531736}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6079623321320726, 0.5356140157282455, 0.569530072465227], 
                 
                 ArrowBox[{{0.7670900535858914, -0.8229263363645454}, {
                  0.8063359586232454, -0.839904373240232}, {
                  0.8352837865894828, -0.8522420812953135}, {
                  0.8646542257274639, -0.8645808894078785}, {
                  0.9445826618972504, -0.8964746429835261}, {
                  0.9856295667671151, -0.912414963272626}, {
                  1.0273982628269611`, -0.9283509125625768}, {
                  1.0639498073014495`, -0.942289562135709}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.6591079616984166, 0.504581604041792, 0.7402851225722299], 
                 
                 ArrowBox[{{1.071424739163694, -0.9451400697492406}, {
                  1.0728369330399734`, -0.9456785989920888}, {
                  1.1191161842542159`, -0.9630059172942758}, {
                  1.1662360164696886`, -0.9803328674691377}, {
                  1.2141964296863914`, -0.9976594495166746}, {
                  1.2629974239043242`, -1.0149856634368866`}, {
                  1.3126389991234875`, -1.0323115092297734`}, {
                  1.3631211553438807`, -1.0496369868953352`}, {
                  1.3727256354346509`, -1.0528791886686324`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6961728620711779, 0.4200619646727287, 0.7609620825656199], 
                 
                 
                 ArrowBox[{{1.3803054087227247`, -1.0554379064923487`}, {
                  1.4144438925655043`, -1.0669620964335722`}, {
                  1.466607210788358, -1.0842868378444843`}, {
                  1.519611110012442, -1.1016112111280711`}, {
                  1.573455590237756, -1.1189352162843331`}, {
                  1.6281406514643002`, -1.1362588533132698`}, {
                  1.6836662936920745`, -1.1535821222148819`}, {
                  1.6847646264461646`, -1.1539196702751617`}}]}}, {
                Arrowheads[{{0.010635492444685124`, 1.}}], {
                 LABColor[
                 0.7304161472901135, 0.34197649598377616`, 
                  0.7800649813025207], 
                 
                 ArrowBox[{{1.692411641827815, -1.1562698097928934`}, {
                  1.7400325169210793`, -1.1709050229891687`}, {
                  1.7972393211513138`, -1.1882275556361304`}, {
                  1.8552867063827783`, -1.205549720155767}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3453793537085093, 
                  0.5223162783649584, -0.48267802843627733`], 
                 
                 ArrowBox[{{-0.17907946853848358`, 
                  0.00047672098131285793`}, {-0.17907476167226993`, 
                  0.0018970717612702625`}, {-0.1790632191980842, 
                  0.0034594577309018343`}, {-0.17445608989810768`, 
                  0.057551217831480414`}, {-0.16167965196959727`, 
                  0.11164297823773331`}, {-0.14073390541255312`, 
                  0.16573473894966045`}, {-0.11161885022697506`, 
                  0.21982649996726197`}, {-0.07327821690773442, 
                  0.2752959035527582}, {-0.06017674285104576, 
                  0.2907808792769577}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3928996692695478, 0.522237892904729, -0.3689076037263845], 
                 
                 
                 ArrowBox[{{-0.05500948020841811, 
                  0.29688820248619635`}, {-0.02634685762965204, 
                  0.33076530768089724`}, {0.02917525735502437, 
                  0.3862331364317794}, {0.06015788099673084, 
                  0.41396629240198}, {0.09328811272757659, 
                  0.4417001610634122}, {0.12485929718168373`, 
                  0.4665792935456576}, {0.1581626958862938, 
                  0.4914598118071295}, {0.18310093283671453`, 
                  0.5091706713128432}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.4720949383250499, 
                  0.5267606582261494, -0.035762554617179275`], 
                 
                 ArrowBox[{{0.1896234150053528, 0.5138028658640031}, {
                  0.19319830884140698`, 0.5163417158478281}, {
                  0.2299661360470233, 0.5412250056677532}, {
                  0.26846617750314244`, 0.566109681266905}, {
                  0.3086984332097648, 0.5909957426452833}, {
                  0.35066290316689014`, 0.6158831898028883}, {
                  0.39435958737451854`, 0.6407720227397198}, {
                  0.43978848583265, 0.6656622414557779}, {
                  0.46383640832202505`, 0.6783547192443521}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5442857674326156, 0.5314647391726771, 
                  0.28584938903899487`], 
                 
                 ArrowBox[{{0.4709114233500968, 0.6820889075567647}, {
                  0.48694959854128456`, 0.6905538459510626}, {
                  0.5358429255004221, 0.715446836225574}, {0.5864684667100627,
                   0.7403412122793119}, {0.6388262221702063, 
                  0.7652369741122764}, {0.6929161918808531, 
                  0.7901341217244676}, {0.7487383758420029, 
                  0.8150326551158853}, {0.7596976247685556, 
                  0.8197739854211492}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.6079590453885414, 0.5356138015582766, 0.5695154299408446], 
                 
                 
                 ArrowBox[{{0.7670399450552036, 0.8229505138419694}, {
                  0.8062927740536556, 0.8399325742865297}, {
                  0.8352401557050219, 0.8522708366227432}, {
                  0.8646101468265016, 0.8646101990705876}, {
                  0.9445364494604037, 0.8965050167516015}, {
                  0.9855822578223719, 0.9124458689906181}, {
                  1.0273498375476846`, 0.9283823501619743}, {
                  1.0638970947557556`, 0.9423202006280997}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.6591055352247119, 0.5045871371655933, 0.7402837689438858], 
                 
                 
                 ArrowBox[{{1.0713719697042752`, 0.9451708574829306}, {
                  1.0727879370301499`, 0.9457108580838129}, {
                  1.1190666182195648`, 0.9630389978631013}, {
                  1.1661858811159294`, 0.9803667694998395}, {
                  1.2141457257192434`, 0.9976941729940273}, {
                  1.2629461520295073`, 1.015021208345665}, {
                  1.3125871600467207`, 1.0323478755547522`}, {
                  1.3630687497708838`, 1.0496741746212892`}, {
                  1.3726708005304011`, 1.0529157457307914`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6961704245860804, 0.420067522905972, 0.7609607227944796], 
                 
                 ArrowBox[{{1.3802505285075974`, 1.0554745977764766`}, {
                  1.4143909212019963`, 1.0670001055452758`}, {
                  1.4665536743400587`, 1.0843256683267124`}, {
                  1.5195570091850703`, 1.1016508629655986`}, {
                  1.5734009257370318`, 1.1189756894619345`}, {
                  1.6280854239959432`, 1.1363001478157204`}, {
                  1.6836105039618041`, 1.153624238026956}, {
                  1.6847080611751273`, 1.1539615670949346`}}]}}, {
                Arrowheads[{{0.010635486787810185`, 1.}}], {
                 LABColor[
                 0.730413721151421, 0.34198202834364433`, 0.7800636278610659], 
                 
                 ArrowBox[{{1.6923550386929516`, 1.1563118298125667`}, {
                  1.7399761656346144`, 1.1709479600956412`}, {
                  1.7971824090143744`, 1.1882713140217758`}, {
                  1.8552292341010843`, 1.2055942998053606`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6613826219439186, 0.4993946627117604, 0.7415540605275944], 
                 
                 
                 ArrowBox[{{-1.4467921715463261`, -0.0007928270329454}, \
{-1.4467905936857965`, 0.0019795353347772347`}, {-1.446770924697384, 
                  0.010851094097107999`}, {-1.446724056016638, 
                  0.019722652859438763`}, {-1.4466499876435581`, 
                  0.028594211621769543`}, {-1.4460817172279015`, 
                  0.06408044667109103}, {-1.4436395911673505`, 
                  0.13505291677632525`}, {-1.439456684795168, 
                  0.20602538687278418`}, {-1.4335330135415885`, 
                  0.27699790198391583`}, {-1.4290458886515032`, 
                  0.3185486452730519}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6637079375058198, 0.494092211316111, 0.742851256968483], 
                 
                 ArrowBox[{{-1.4281869510882645`, 
                  0.32650240075473835`}, {-1.4258685857308577`, 
                  0.3479704468144521}, {-1.4164633942491491`, 
                  0.4189429610237122}, {-1.4053174390964631`, 
                  0.4899154446116961}, {-1.3924307202727997`, 
                  0.5608878975784038}, {-1.385911313722452, 
                  0.5945213052573186}, {-1.3790014181758017`, 
                  0.6281568923828732}, {-1.375650880337803, 
                  0.6419985707450733}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.670455783839148, 0.4787049977292675, 0.74661559863061], 
                 
                 ArrowBox[{{-1.3737687439518385`, 
                  0.6497740168817672}, {-1.3615724045617021`, 
                  0.7001593028259893}, {-1.3423460623577839`, 
                  0.7721406576821996}, {-1.32151208968411, 
                  0.8465564181583454}, {-1.2987633099760056`, 
                  0.9209722304908572}, {-1.2866315826998838`, 
                  0.9575765159413366}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6809206148553393, 0.45484188911029266`, 
                  0.7524534908165659], 
                 
                 ArrowBox[{{-1.2841147782562967`, 
                  0.9651703091563736}, {-1.2740997232334712`, 
                  0.9953880946797349}, {-1.2475213294565066`, 
                  1.0698040107249787`}, {-1.219028128645112, 
                  1.1442199786265888`}, {-1.1886201207992868`, 
                  1.2186359983845643`}, {-1.1690698840673723`, 
                  1.2636460577531305`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6947412884121302, 0.4233264032163674, 0.7601634674073967], 
                 
                 
                 ArrowBox[{{-1.1658827289735032`, 
                  1.2709837714575227`}, {-1.1562973059190313`, 
                  1.293052069998906}, {-1.1220596840043457`, 
                  1.3674681934696138`}, {-1.08590725505523, 
                  1.4418843687966876`}, {-1.0478400190716841`, 
                  1.5163005959801275`}, {-1.0252618676608585`, 
                  1.558324011712924}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7109945963280554, 0.38626374528951957`, 
                  0.7692305091141864], 
                 
                 ArrowBox[{{-1.0214755503303323`, 
                  1.5653712665736876`}, {-1.0078579760537076`, 
                  1.5907168750199334`}, {-0.9659611260013015, 
                  1.665133205916105}, {-0.9221494689144647, 
                  1.739549588668643}, {-0.8995255877331352, 
                  1.776757799491049}, {-0.8764230047931978, 
                  1.813966023277547}, {-0.8592239168923158, 
                  1.8411039736772428`}}]}}, {
                Arrowheads[{{0.008602493944681227, 1.}}], {
                 LABColor[
                 0.7289840051300835, 0.34524223088859496`, 
                  0.7792660490013416], 
                 
                 ArrowBox[{{-0.8549414177711152, 
                  1.8478612069333111`}, {-0.8528417200946531, 
                  1.851174260028136}, {-0.8287817336375006, 
                  1.8883825097428164`}, {-0.8042430454217407, 
                  1.9255907724215888`}, {-0.7792256554473734, 
                  1.9627990480644524`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.20233568035733063`, 
                  0.5225716955648476, -0.8245446092048456], 
                 
                 ArrowBox[{{0.0016203792267254831`, 
                  0.00035130593118182305`}, {0.00683441214923887, 
                  0.0007183258146260774}, {0.01562663144367256, 
                  0.0010853348150840468`}, {0.08657681892204333, 
                  0.0025533592042222817`}, {0.13464898938549455`, 
                  0.0031841693375857256`}, {0.19329171533432787`, 
                  0.0038149784242134856`}, {0.2625087241223962, 
                  0.004445719259464298}, {0.301082903247594, 
                  0.004761059895520026}, {0.3215723416753997, 
                  0.004917838855897075}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.40229413791229873`, 
                  0.5224184382875863, -0.3403687377039948], 
                 
                 ArrowBox[{{0.3295721074918574, 0.004979050634462078}, {
                  0.3422981475701198, 0.005076426428348114}, {
                  0.41460797270664335`, 0.005584601052609306}, {
                  0.4938183387522325, 0.00609292197852897}, {
                  0.5360112246159267, 0.006347137304610729}, {
                  0.5799292457068873, 0.006601389206107108}, {
                  0.6255724020251143, 0.006855677683018105}, {
                  0.6495657623388171, 0.00698450041269982}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5020852239770948, 0.5287148778003075, 0.09784491573042471], 
                 
                 ArrowBox[{{0.6575656470324087, 0.0070274525865468025`}, {
                  0.6729406935706076, 0.007110002735343718}, {
                  0.7220341203433676, 0.0073643643630839535`}, {
                  0.7728526823433938, 0.007618762566238804}, {
                  0.8253963795706863, 0.007873197344808274}, {
                  0.8796652120252453, 0.008127668698792362}, {
                  0.9356591797070707, 0.00838217662819107}, {
                  0.9775619312093361, 0.008566970129716193}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5791864940508137, 0.5337389316862444, 0.4413329963261034], 
                 
                 
                 ArrowBox[{{0.9855618534160776, 0.008602250238623418}, {
                  0.9933782826161625, 0.008636721133004394}, {
                  1.0528225207525208`, 0.008891302213232338}, {
                  1.1139918941161453`, 0.0091459198688749}, {
                  1.1454713840632762`, 0.009275140549262753}, {
                  1.1773925424448797`, 0.009404373787451431}, {
                  1.2276173751003188`, 0.009598704359355899}, {
                  1.2788679823131899`, 0.009792964460913397}, {
                  1.3055592472866453`, 0.00989210637651744}}]}}, {
                Arrowheads[{{0.004430696487116367, 1.}}], {
                 LABColor[
                 0.6436002113194492, 0.5346262258640333, 0.7227978981318784], 
                 
                 
                 ArrowBox[{{1.3135591921002794`, 0.009921821335862346}, {
                  1.3311456168694729`, 0.00998714427360914}, {
                  1.3844498611738414`, 0.010181247070281394`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5260922956073544, 0.530279220662606, 0.20479701842752], 
                 
                 ArrowBox[{{-0.7524738891033557, 
                  0.0005380792619852724}, {-0.7524707690437338, 
                  0.0031113637017220453`}, {-0.752463248969668, 
                  0.005684648141458816}, {-0.7523891685289663, 
                  0.01597778590040603}, {-0.7522446878607573, 
                  0.02627092365843722}, {-0.7509627619227303, 
                  0.06744347483809768}, {-0.7450200018081689, 
                  0.14978850525456308`}, {-0.734572236486057, 
                  0.23213339118051546`}, {-0.7242349322949281, 
                  0.29155200670449516`}, {-0.718557080458803, 
                  0.31815075622094335`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5347074689443662, 0.5308406004562262, 
                  0.24317783045175564`], 
                 
                 ArrowBox[{{-0.7168870015449961, 
                  0.32597449167286513`}, {-0.7115512179534933, 
                  0.35097077113217834`}, {-0.6987698176444135, 
                  0.4021056279942068}, {-0.6842508419103112, 
                  0.4532401403185739}, {-0.6679942907511863, 
                  0.5043743081052794}, {-0.6500001641670391, 
                  0.5555081313543235}, {-0.630268462157869, 
                  0.6066416100657064}, {-0.6202400070595739, 
                  0.630526267649924}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.55780692283257, 0.5323458013557586, 0.3460864734777556], 
                 
                 ArrowBox[{{-0.617142961293816, 
                  0.6379024663677462}, {-0.6087991847236766, 
                  0.6577747442394276}, {-0.5855923318644616, 
                  0.7089075338754877}, {-0.5606479035802241, 
                  0.7600399789738859}, {-0.533965899870964, 
                  0.8111720795346228}, {-0.5055463207366815, 
                  0.8623038355576983}, {-0.4753891661773762, 
                  0.9134352470431123}, {-0.4701676828440319, 
                  0.9218059093442195}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5904866094489924, 0.5344752670102083, 0.4916752921782849], 
                 
                 
                 ArrowBox[{{-0.4659336293860966, 
                  0.9285936034530716}, {-0.4434944361930485, 
                  0.964566313990865}, {-0.4098621307836983, 
                  1.015697036400956}, {-0.37449224994932556`, 
                  1.066827414273386}, {-0.3373847936899303, 
                  1.1179574476081542`}, {-0.29853976200551247`, 
                  1.169087136405261}, {-0.2820742731906492, 
                  1.1902856132903827`}}]}}, {
                Arrowheads[{{0.011173199723387074`, 1.}}], {
                 LABColor[
                 0.6281610146564099, 0.5369301972818071, 0.6595157067383387], 
                 
                 
                 ArrowBox[{{-0.2771387654571576, 
                  1.1965815769630477`}, {-0.2597385303306848, 
                  1.2185233023052362`}, {-0.21144343045300618`, 
                  1.2754850668570406`}, {-0.16097149881677966`, 
                  1.3324230529392276`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.4739797792190435, 0.5268834777621801, -0.0273655414384458], 
                 
                 ArrowBox[{{-0.5542784517524305, -0.0000269280342662965}, \
{-0.5542773748509003, -0.0015454249809802802`}, {-0.55426898095416, \
-0.004582418874408248}, {-0.554252266932513, -0.007619412767836215}, \
{-0.5542272327859593, -0.010656406661264177`}, {-0.5540438949506783, \
-0.02280438223497606}, {-0.5537274351173456, -0.03495235780804814}, \
{-0.5511303757967655, -0.0835442601044949}, {-0.546403368466209, \
-0.13213615722266248`}, {-0.5395464114935775, -0.1807280520053585}, \
{-0.5305594992726395, -0.22931995248710574`}, {-0.5194426318033946, \
-0.277911858667904}, {-0.509119341404244, -0.31577968766217174`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.48715683424364986`, 0.5277421177617325, 
                  0.03133856724845505], 
                 
                 ArrowBox[{{-0.5070152178040993, -0.3234980206347322}, \
{-0.506195809085843, -0.32650377054775326`}, {-0.4908191815077981, \
-0.37509553674408275`}, {-0.47331289945707317`, -0.42368700587432195`}, \
{-0.45367696293366816`, -0.4722781779384707}, {-0.4319113719375832, \
-0.5208690529365289}, {-0.40193543965901307`, -0.5811762113625423}, \
{-0.3820055390241531, -0.6173163817400353}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.52059510915959, 0.5299210143592831, 0.1803069157377222], 
                 
                 ArrowBox[{{-0.3781423326542802, -0.6243217822670412}, \
{-0.36867795840079265`, -0.6414841406904003}, {-0.3423878768141267, \
-0.6854325617528714}, {-0.3143545867571647, -0.729381250189995}, \
{-0.2845780882299066, -0.7733302060017712}, {-0.25305838123235247`, \
-0.8172794291881998}, {-0.2197954657645023, -0.8612289197492808}, \
{-0.19813068297351127`, -0.8884287880088092}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5639525491990186, 0.5327462611406408, 
                  0.37346539217327446`], 
                 
                 ArrowBox[{{-0.19314647634179802`, -0.8946863981159017}, \
{-0.18478934182635612`, -0.9051786776850143}, {-0.14804000941791393`, \
-0.9491287029954001}, {-0.1095474685391756, -0.9930789956804384}, \
{-0.06931171919014123, -1.0370295557401292`}, {-0.027332761370810903`, \
-1.0809803831744726`}, {0.01638940491881551, -1.1249314779834685`}, {
                  0.02251092807680744, -1.1308491523203281`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6103399986906866, 0.5357689486483108, 0.5801226362677939], 
                 
                 
                 ArrowBox[{{0.028262740261894643`, -1.136409427186509}, {
                  0.061854779678737995`, -1.168882840167117}, {
                  0.10906336290895655`, -1.2128344697254176`}, {
                  0.15801515460947108`, -1.2567863666583707`}, {
                  0.20871015478028168`, -1.3007385309659765`}, {
                  0.26114836342138836`, -1.3446909626482346`}, {
                  0.26691323299988595`, -1.349443948887076}}]}}, {
                Arrowheads[{{0.01195114791837783, 1.}}], {
                 LABColor[
                 0.6531379012986148, 0.5181952208849004, 0.7369546752000973], 
                 
                 
                 ArrowBox[{{0.27308581212369765`, -1.3545330811274765`}, {
                  0.28619012026433094`, -1.365337245109656}, {
                  0.31161461556741354`, -1.3859849507857294`}, {
                  0.3669873085892765, -1.4289346080417846`}, {
                  0.4240399274010557, -1.471872135134661}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6883569255560603, 0.43788476006528565`, 
                  0.7566018979972371], 
                 
                 ArrowBox[{{-1.669886998510104, 
                  0.0004754772651189992}, {-1.6698867181317105`, \
-0.001269518714017622}, {-1.6698858957264815`, -0.002665515491229316}, \
{-1.6698844898066048`, -0.0040615122684410105`}, {-1.6698815423904094`, \
-0.006015254722974028}, {-1.6698786779436599`, -0.007437506200143403}, \
{-1.669440670051031, -0.05459965273006923}, {-1.6673324352701657`, \
-0.13065750159359157`}, {-1.6634922066729878`, -0.20671506978371154`}, \
{-1.6579199842594974`, -0.28277235730042904`}, {-1.654438351956759, \
-0.31902573802522655`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6902457476037039, 0.43357765127250164`, 
                  0.7576555929356016], 
                 
                 ArrowBox[{{-1.6536735819905937`, -0.3269890995578239}, \
{-1.6506157680296945`, -0.35882936414374433`}, {-1.6415795579835788`, \
-0.4348860903136572}, {-1.630811354121151, -0.5109425358101677}, \
{-1.6183111564424102`, -0.5869987006332759}, {-1.6077293368171524`, \
-0.6435472404552305}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.695716653798772, 0.42110226312957477`, 0.7607075830228632], 
                 
                 ArrowBox[{{-1.6062578539093109`, -0.6514107471826347}, \
{-1.604078964947357, -0.6630545847829816}, {-1.5881147796359918`, \
-0.7391101882592853}, {-1.5704186005083134`, -0.8151655110621864}, \
{-1.5509904275643225`, -0.8912205531916851}, {-1.5311937007837366`, \
-0.9623747813206224}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.704473291486692, 0.4011343729686599, 0.7655925454894774], 
                 
                 ArrowBox[{{-1.528990570137206, -0.9700650136571354}, \
{-1.5069381002274036`, -1.0433297954304754`}, {-1.4823139458344752`, \
-1.119383995539767}, {-1.455957797625234, -1.1954379149756564`}, \
{-1.4278696555996806`, -1.2714915537381433`}, {-1.4271647512632577`, \
-1.2733431177222496`}}]}}, {
                Arrowheads[{{0.017792385567522835`, 1.}}], {
                 LABColor[
                 0.7160510273259862, 0.37473349105595555`, 
                  0.7720512807985044], 
                 
                 ArrowBox[{{-1.4243183873891747`, -1.2808196284522837`}, \
{-1.4135188254579956`, -1.3091867115906417`}, {-1.398743358645285, \
-1.3468839503602426`}, {-1.3779846486429084`, -1.3956880065277923`}, \
{-1.3565085775759222`, -1.4444834664011172`}, {-1.3343154236205155`, \
-1.4932700534092702`}, {-1.3114050940512918`, -1.5420478597425666`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.46043106221053615`, 
                  0.5260006196163809, -0.08772541353052073], 
                 
                 ArrowBox[{{-0.507699965335667, 
                  0.0007771337653611151}, {-0.5076950585015012, 
                  0.002755658316317554}, {-0.5076581376314209, 
                  0.00908693447556834}, {-0.5075817395575515, 
                  0.015418210634819126`}, {-0.507465864279893, 
                  0.021749486794069864`}, {-0.506607591131368, 
                  0.047074591431078144`}, {-0.5029961390532927, 
                  0.09772480070021927}, {-0.4968581459327839, 
                  0.14837500997666742`}, {-0.4881936142481481, 
                  0.19902521167436546`}, {-0.4770025433538296, 
                  0.2496754096920573}, {-0.46328493012433103`, 
                  0.3003256155316237}, {-0.4583515995016115, 
                  0.3157080248608353}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.4754512412492768, 
                  0.5269793608069593, -0.020810141404814707`], 
                 
                 ArrowBox[{{-0.45590847081669605`, 
                  0.32332584096710515`}, {-0.4470407745596524, 
                  0.350975829193065}, {-0.4282700766597937, 
                  0.401626050676381}, {-0.4069729485953435, 
                  0.45227610927545975`}, {-0.38314950253689006`, 
                  0.5029258342841892}, {-0.3567997384844335, 
                  0.5535752257025695}, {-0.3279236564379739, 
                  0.6042242835306005}, {-0.3223061259068067, 
                  0.613251460784035}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5123306307921555, 0.5293824864645097, 
                  0.14348845854706432`], 
                 
                 ArrowBox[{{-0.3180793743878692, 
                  0.6200437042718054}, {-0.293516124023979, 
                  0.6595159979647524}, {-0.25609726299511804`, 
                  0.7148084310992779}, {-0.22565097508270063`, 
                  0.756834440040245}, {-0.19346423392875906`, 
                  0.7988608566544514}, {-0.15953703953329323`, 
                  0.8408876809418971}, {-0.1285418026453316, 
                  0.8774094057168109}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5587466168352562, 0.5324070334638844, 
                  0.35027283368973805`], 
                 
                 ArrowBox[{{-0.12335142706433597`, 
                  0.8834968413830381}, {-0.08646129101778861, 
                  0.9249425525365076}, {-0.04731273689775004, 
                  0.9669705998436716}, {-0.006423729536187264, 
                  1.0089990548240753`}, {0.03620573106689998, 
                  1.0510279174777186`}, {0.08057564491151134, 
                  1.0930571878046014`}, {0.10087084086754772`, 
                  1.1115562934262972`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6074041660804069, 0.5355776446500754, 0.5670434287879306], 
                 
                 
                 ArrowBox[{{0.10678326175235996`, 1.1169454751156482`}, {
                  0.12668601199764695`, 1.1350868658047235`}, {
                  0.17453683232530678`, 1.177116951478085}, {
                  0.22412810589449092`, 1.219147444824686}, {
                  0.2754598327051993, 1.2611783458445265`}, {
                  0.32853201275743193`, 1.3032096545376066`}, {
                  0.35260079568105374`, 1.3216662072762142`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6521703486643547, 0.520401545437127, 0.7364149179929041], 
                 
                 ArrowBox[{{0.3589491601404672, 1.3265342940349374`}, {
                  0.3833446460511888, 1.345241370903926}, {
                  0.43989773258646986`, 1.3872734949434848`}, {
                  0.4672411249044059, 1.4072881260747698`}, {
                  0.494977165165104, 1.427304088989242}, {0.5580992284136062, 
                  1.4708678528266268`}, {0.6195869751256436, 
                  1.5120588653580875`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4130899826831261, 
                  0.522915791904247, -0.29863110321176367`], 
                 
                 ArrowBox[{{-0.36099932630310033`, -0.0013966445169901298`}, \
{-0.36099803694631016`, 0.00011324570475040549`}, {-0.36081587819993893`, 
                  0.016218774012587173`}, {-0.36064242045632416`, 
                  0.02266098533572188}, {-0.36041148028695724`, 
                  0.029103196658856585`}, {-0.36012305769183817`, 
                  0.035545407981991295`}, {-0.3600253218403091, 
                  0.0374780713789288}, {-0.35994028266275613`, 
                  0.03908862452937067}, {-0.35604540034590637`, 
                  0.08456788487301323}, {-0.34928579609478466`, 
                  0.13004705933278943`}, {-0.3396614699093909, 
                  0.1755261479086995}, {-0.3271724217897251, 
                  0.22100515060074344`}, {-0.3118186517357873, 
                  0.26648406740892117`}, {-0.29463035307021423`, 
                  0.3093912262118591}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.43654633835226825`, 
                  0.5244442491493325, -0.1941324538528143], 
                 
                 ArrowBox[{{-0.291400631427093, 
                  0.31670751592637353`}, {-0.2725169458250957, 
                  0.357441643373678}, {-0.24856900996834191`, 
                  0.402920302530257}, {-0.22175635217731599`, 
                  0.4483988758029699}, {-0.19207897245201816`, 
                  0.4938773631918166}, {-0.1595368707924483, 
                  0.5393557646967969}, {-0.12413004719860649`, 
                  0.5848340803179111}, {-0.12216893855719876`, 
                  0.587164473514813}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.48806999736371465`, 0.5278016210710486, 
                  0.03540673171684723], 
                 
                 ArrowBox[{{-0.11701789333291668`, 
                  0.5932854810378766}, {-0.08585850167049268, 
                  0.630312310055159}, {-0.04472223420810676, 
                  0.6757904539085406}, {-0.0007212448114488169, 
                  0.7212685118780563}, {0.04614446651948114, 
                  0.7667464839637056}, {0.08788992386784548, 
                  0.8050953822361674}, {0.10670651455054808`, 
                  0.821576919212814}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.545584271778551, 0.5315493519916211, 0.2916342582766099], 
                 
                 ArrowBox[{{0.1127244297188011, 0.8268480383565737}, {
                  0.13167235086289578`, 0.843444608278991}, {
                  0.17386672222954502`, 0.8788149074527006}, {
                  0.2177950951737992, 0.9141857825081825}, {
                  0.26345746969565836`, 0.9495572334454365}, {
                  0.3108538457951225, 0.9849292602644626}, {
                  0.3599842234721915, 1.020301862965261}, {
                  0.36484014273295795`, 1.0236788686755558`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6015951888403707, 0.5351991215122824, 0.541164290344475], 
                 
                 ArrowBox[{{0.3714080342463493, 1.0282464502094009`}, {
                  0.4108486027268655, 1.0556750415478313`}, {
                  0.46344698355914443`, 1.0910487960121737`}, {
                  0.5177793659690283, 1.1264231263582885`}, {
                  0.5738457499565172, 1.1617980325861754`}, {
                  0.631646135521611, 1.1971735146958344`}, {
                  0.6399673182216558, 1.2021180628113377`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6514490949244012, 0.5220462309854864, 0.7360125606527759], 
                 
                 
                 ArrowBox[{{0.6468447603916987, 1.206204722718611}, {
                  0.6911805226643097, 1.2325495726872655`}, {
                  0.7524489113846135, 1.2679262065604688`}, {
                  0.815451301682522, 1.303303416315444}, {0.8801876935580356, 
                  1.3386812019521916`}, {0.9257830396124754, 
                  1.3629489782128166`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6865764491401701, 0.441944806714885, 0.7556086445620386], 
                 
                 ArrowBox[{{0.9328450595761608, 1.3667076846435597`}, {
                  0.9466580870111542, 1.3740595634707113`}, {
                  1.0148624820418777`, 1.409438500871003}, {
                  1.0487706358686781`, 1.4268066776815052`}, {
                  1.0830946075917678`, 1.4441758795946142`}, {
                  1.126909950805321, 1.4655965864642324`}, {
                  1.1713683102881045`, 1.4870138631566272`}, {
                  1.2164698870331296`, 1.5084274466704757`}, {
                  1.219101680110034, 1.509659209008277}}]}}, {
                Arrowheads[{{0.0024750823647291644`, 1.}}], {
                 LABColor[
                 0.7195272433688156, 0.366806624307251, 0.7739905165531697], 
                 
                 ArrowBox[{{1.226347350758318, 1.5130504118710666`}, {
                  1.2622146140427262`, 1.529837424672886}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4304415056974555, 0.5240464475541956, -0.2213296355458593], 
                 
                 ArrowBox[{{-0.4118649266972277, -0.0028919941044832794`}, \
{-0.4117418173308876, -0.014532166059876034`}, {-0.41100214094630266`, \
-0.037812509970661}, {-0.4096045210258512, -0.061092853881449014`}, \
{-0.40754895756670173`, -0.08437319778931529}, {-0.4014640001316131, \
-0.1309338856628236}, {-0.3927472687460181, -0.17749457366358531`}, \
{-0.37994551081588207`, -0.22933591724490654`}, {-0.3638811623469165, \
-0.2811772584308925}, {-0.351174241687509, -0.3152614855619749}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.45064415150557185`, 
                  0.5253628873622743, -0.13132634474469224`], 
                 
                 ArrowBox[{{-0.3483796555647482, -0.32275750373180834`}, \
{-0.3445542233391215, -0.33301859722154303`}, {-0.3219646937924971, \
-0.384859933616858}, {-0.29611257641341976`, -0.43670127054401386`}, \
{-0.2669978739082658, -0.48854261093018686`}, {-0.23462058627703528`, \
-0.540383954775377}, {-0.19898071351972832`, -0.5922253020795841}, \
{-0.19232985202323616`, -0.6010882140265226}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.496465900351163, 0.5283487128243971, 0.07281068886656442], 
                 
                 
                 ArrowBox[{{-0.18752815295534395`, -0.6074869393731368}, \
{-0.16007826352935714`, -0.6440665543694845}, {-0.11791324419893418`, \
-0.6959076131717536}, {-0.07248565552845955, -0.7477484784863917}, \
{-0.02379549751793301, -0.7995891503133989}, {
                  0.015177461643393533`, -0.8387782726631247}, {
                  0.0239252909483001, -0.84717307430075}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5499258556797441, 0.5318322572076969, 
                  0.31097612280802484`], 
                 
                 ArrowBox[{{0.029697416088542244`, -0.852712259382094}, {
                  0.05601488552418165, -0.8779676602153661}, {
                  0.09716897424940946, -0.9157624323434399}, {
                  0.14005825933804686`, -0.9535577322011902}, {
                  0.18468274079009372`, -0.9913535597886168}, {
                  0.23104241860554986`, -1.0291499151057197`}, {
                  0.27207586773471937`, -1.0613973532001248`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6033774278189745, 0.535315255327686, 0.549104209431905], 
                 
                 ArrowBox[{{0.27836590273978945`, -1.0663405768077512`}, {
                  0.27913729278441546`, -1.0669467981524987`}, {
                  0.3289673633266907, -1.1047442089289543`}, {
                  0.3805326302323754, -1.1425421474350865`}, {
                  0.4338330935014693, -1.1803406136708943`}, {
                  0.48886875313397277`, -1.2181396076363789`}, {
                  0.5391707892039256, -1.2516320197267272`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6515612932656997, 0.5217903834518635, 0.736075151421698], 
                 
                 ArrowBox[{{0.5458315027829926, -1.2560631094887924`}, {
                  0.6041456614892081, -1.2937391787563768`}, {
                  0.66438691021194, -1.3315397559108901`}, {
                  0.7263633552980813, -1.36934086079508}, {
                  0.7900749967476319, -1.407142493408946}, {
                  0.8184584778396938, -1.4235368210679298`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6859022069641397, 0.4434822911001762, 0.7552325130101005], 
                 
                 
                 ArrowBox[{{0.8253859287736585, -1.4275381238004798`}, {
                  0.8555218345605922, -1.4449446537524886`}, {
                  0.9227038687369618, -1.4827473418257073`}, {
                  0.9559215867925462, -1.5012004584059646`}, {
                  0.989550754349604, -1.5196546471112964`}, {
                  1.0313533686941811`, -1.5418225626449324`}, {
                  1.0737592280531343`, -1.5639871457140007`}, {
                  1.1062819213260076`, -1.580744829930362}}]}}, {
                Arrowheads[{{0.0032947028078290025`, 1.}}], {
                 LABColor[
                 0.7183239862727719, 0.3695504292224966, 0.7733192696703657], 
                 
                 
                 ArrowBox[{{1.1133933999941719`, -1.5844090994554165`}, {
                  1.1167684932256157`, -1.5861481542778069`}, {
                  1.1603811106119082`, -1.6083056690165827`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.3152175603570644, 0.5223701349293277, -0.5547630701674966], 
                 
                 ArrowBox[{{0.030630034748076178`, -0.11328908635486412`}, {
                  0.060170527930151194`, -0.13400717427434394`}, {
                  0.0946624846719379, -0.15472508187473252`}, {
                  0.13410590497343605`, -0.1754428091560297}, {
                  0.17850078883464576`, -0.1961603561182355}, {
                  0.22784713625556716`, -0.2168777227613501}, {
                  0.2821449472362001, -0.2375949090853733}, {
                  0.31849049139047, -0.25030343357513407`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4305921769355218, 0.5240562655561348, -0.2206583914234875], 
                 
                 ArrowBox[{{0.326042162258252, -0.2529439386602821}, {
                  0.3413942217765445, -0.25831191509030516`}, {
                  0.40559495987660066`, -0.27902874077614576`}, {
                  0.4651365209572162, -0.29695298465067166`}, {
                  0.5283827263906251, -0.3148781493385886}, {
                  0.5737092644998144, -0.3271052912218268}, {
                  0.6207629513257593, -0.33933302382720504`}, {
                  0.6331733632920541, -0.342444051517961}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5199213205104017, 0.5298771091100178, 0.1773051705055682], 
                 
                 
                 ArrowBox[{{0.6409332622415934, -0.3443892939946048}, {
                  0.6695437868684596, -0.3515613471547232}, {
                  0.7200517711279154, -0.3637902612043814}, {
                  0.7722869041041266, -0.37601976597617953`}, {
                  0.8262491857970933, -0.38824986147011764`}, {
                  0.8819386162068152, -0.4004805476861957}, {
                  0.9393551953332928, -0.4127118246244137}, {
                  0.9529052454112489, -0.4155141914245603}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5921608893196018, 0.5345843660209255, 
                  0.49913425074778317`], 
                 
                 ArrowBox[{{0.9607394539892533, -0.4171344308995523}, {
                  0.998498923176526, -0.4249436922847718}, {
                  1.0593697997365146`, -0.43717615066726984`}, {
                  1.1219678250132585`, -0.44940919977190785`}, {
                  1.1862929990067579`, -0.4616428395986858}, {
                  1.2523453217170126`, -0.4738770701476037}, {
                  1.2748983916381187`, -0.47794810779055064`}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.6515208704484821, 0.5218825601985739, 0.736052601220132], 
                 
                 ArrowBox[{{1.282771158268684, -0.47936921495774715`}, {
                  1.320124793144023, -0.4861118914186616}, {
                  1.3896314132877887`, -0.4983473034118595}, {
                  1.4608651821483098`, -0.5105833061271974}, {
                  1.4973152302270212`, -0.5167695764289524}, {
                  1.5342043390842313`, -0.5229562782778538}, {
                  1.5902723154683422`, -0.5320072233317883}, {
                  1.5981941491587797`, -0.5332641653429109}}]}}, {
                Arrowheads[{{0.010003365816082773`, 1.}}], {
                 LABColor[
                 0.6909974559658619, 0.4318635195996432, 0.7580749396375951], 
                 
                 
                 ArrowBox[{{1.6060953093349633`, -0.5345178271275608}, {
                  1.6473010326127069`, -0.5410558594456348}, {
                  1.7052912574785621`, -0.5501019292432262}, {
                  1.764242734412163, -0.5591455185166184}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.26834546437621215`, 
                  0.5224538292251178, -0.6667848241607016], 
                 
                 ArrowBox[{{-0.04691095725399692, 
                  0.0050363051276108945`}, {-0.046401940979409174`, 
                  0.011006932567174754`}, {-0.045514055228443914`, 
                  0.016977560007427978`}, {-0.04424729996598115, 
                  0.022948187401838797`}, {-0.03539158709093799, 
                  0.046830708926736055`}, {0.0005055736290018708, 
                  0.09459576895741868}, {0.06065039336509504, 
                  0.14236081441569304`}, {0.11341942061209871`, 
                  0.1737723999073564}, {0.17667489750045068`, 
                  0.2051839711957818}, {0.18385639657401578`, 
                  0.20824277733660612`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3867489979124745, 
                  0.522306846537315, -0.38181917873046134`], 
                 
                 ArrowBox[{{0.19121658120140217`, 0.21137769077253782`}, {
                  0.25041873128694075`, 0.2365935821033922}, {
                  0.29122399133356286`, 0.25229749076056573`}, {
                  0.3346514818616099, 0.2680009511180551}, {
                  0.3913458935405552, 0.2872135502375305}, {
                  0.43115421334632825`, 0.2999452242541773}, {
                  0.4726900573293231, 0.3126778092900482}, {
                  0.4924993952882952, 0.31850819507555816`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.48510192751952425`, 0.5276082164381524, 
                  0.0221839065561189], 
                 
                 ArrowBox[{{0.500173888136543, 0.3207669911093325}, {
                  0.5159534254895398, 0.3254113053451431}, {
                  0.5609443178269783, 0.33814571241946223`}, {
                  0.6076627343416383, 0.3508810305130053}, {
                  0.6561086750335203, 0.3636172596257724}, {
                  0.7062821399026241, 0.37635439975776364`}, {
                  0.7581831289489497, 0.3890924509089789}, {
                  0.8098176862561174, 0.4013577671127214}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5630905219223811, 0.5326900899325033, 0.3696250391623546], 
                 
                 
                 ArrowBox[{{0.8176106093719847, 0.4031660119817499}, {
                  0.8671676795732662, 0.41457128626908174`}, {
                  0.9242512411512571, 0.42731207047796926`}, {
                  0.9830623269064699, 0.44005376570608085`}, {
                  1.0436009368389045`, 0.45279637195341643`}, {
                  1.1058670709485607`, 0.46553988921997613`}, {
                  1.1304462002221434`, 0.4704348578581172}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.628889115603741, 0.5369776416156073, 0.662759414612924], 
                 
                 ArrowBox[{{1.138292123370998, 0.47199738463941315`}, {
                  1.1698607292354388`, 0.47828431750575995`}, {
                  1.2355819116995388`, 0.49102965681076777`}, {
                  1.2691585313311367`, 0.49745694615174024`}, {
                  1.3031719078815833`, 0.5038847540267827}, {
                  1.3540747262374984`, 0.5131208683567559}, {
                  1.4059006264290936`, 0.5223543765221348}, {
                  1.4528750450264902`, 0.5305743493648771}}]}}, {
                Arrowheads[{{0.0032702501668720216`, 1.}}], {
                 LABColor[
                 0.6746566003805368, 0.4691258137691589, 0.7489590587422605], 
                 
                 
                 ArrowBox[{{1.4607563905867507`, 0.5319470406407936}, {
                  1.5123238255474332`, 0.5408127558956932}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.41235735698310144`, 
                  0.5228680527296312, -0.30189496897241747`], 
                 
                 ArrowBox[{{-0.3113561708417856, -0.17857157179150043`}, \
{-0.29743009347560484`, -0.22484885291544457`}, {-0.280309035181239, \
-0.2711261584286698}, {-0.2599929781933795, -0.3174033863309345}, \
{-0.23648192251202618`, -0.36368053662223926`}, {-0.209775868137179, \
-0.40995760930258385`}, {-0.1798748150688383, -0.45623460437196794`}, \
{-0.17326898472053084`, -0.4654712791261904}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.45859620138591745`, 
                  0.5258810568692658, -0.09589976425400286], 
                 
                 ArrowBox[{{-0.1686152522148272, -0.4719784116563728}, \
{-0.14677876330700368`, -0.502511521830392}, {-0.11048771285167538`, \
-0.5487883616778556}, {-0.0710016637028533, -0.5950651239143592}, \
{-0.028320615860537517`, -0.6413418085399025}, {
                  0.017555430675272016`, -0.6876184155544854}, {
                  0.04280222491950502, -0.7114274461290528}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5177497496332615, 0.5297356057457613, 0.1676307681026868], 
                 
                 
                 ArrowBox[{{0.048622375131604036`, -0.716916148298838}, {
                  0.06662647590457547, -0.7338949449581083}, {
                  0.1188925198273725, -0.7801713967507709}, {
                  0.17435356244366326`, -0.8264477709324732}, {
                  0.23300960375344798`, -0.8727240675032154}, {
                  0.29486064375672627`, -0.9190002864629971}, {
                  0.2958813921020682, -0.9197264843323374}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5764185857225232, 0.533558569928528, 0.4290018957094695], 
                 
                 ArrowBox[{{0.3024000320623839, -0.9243640842577056}, {
                  0.3599066824534983, -0.9652764278118188}, {
                  0.41642376207546045`, -1.003754003980674}, {
                  0.475149603425558, -1.0422318487308526`}, {
                  0.5289804064525103, -1.0762877612914312`}, {
                  0.56917592851118, -1.1009253591740262`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6315746420461611, 0.5371526352252577, 0.6747235018739227], 
                 
                 
                 ArrowBox[{{0.575996615088062, -1.1051060570368167`}, {
                  0.5845422924781685, -1.110344077402979}, {
                  0.6418352615025331, -1.1444007970654964`}, {
                  0.700859313525604, -1.1784579202789836`}, {
                  0.761614448547381, -1.21251544704344}, {
                  0.8241006665678643, -1.2465733773588663`}, {
                  0.8544610063354338, -1.2626753089519132`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.6718679708267232, 0.4754847668987196, 0.7474033987744555], 
                 
                 
                 ArrowBox[{{0.8615285343925917, -1.266423648205674}, {
                  0.8883179675870538, -1.280631711225262}, {
                  0.9542663516049493, -1.3146904486426272`}, {
                  1.0219458186215515`, -1.3487495896109625`}, {
                  1.0913563686368597`, -1.382809134130267}, {
                  1.1476106667284987`, -1.4097415840974121`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.7060603566051906, 0.3975153649551028, 0.7664779028392092], 
                 
                 
                 ArrowBox[{{1.1548263309631461`, -1.4131961737478382`}, {
                  1.162498001650874, -1.416869082200541}, {
                  1.2353707176635946`, -1.4509294338217846`}, {
                  1.3099745166750214`, -1.4849901889939978`}, {
                  1.3863093986851545`, -1.5190513477171805`}, {
                  1.4463016427871187`, -1.5452270256610043`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7381576084906825, 0.32432352775018203`, 
                  0.7843836192031955], 
                 
                 ArrowBox[{{1.4536340812779474`, -1.5484262983561983`}, {
                  1.4643753636939938`, -1.5531129099913328`}, {
                  1.5441724117015392`, -1.5871748758164548`}, {
                  1.5843080096267743`, -1.6041233208346126`}, {
                  1.6248702631033984`, -1.6210725716653678`}, {
                  1.6802359901077102`, -1.643492274653285}, {
                  1.7363603839245187`, -1.6659086440020026`}, {
                  1.749219557106681, -1.6709753286695574`}}]}}, {
                Arrowheads[{{0.006322695321812395, 1.}}], {
                 LABColor[
                 0.7684386826940812, 0.2552731473191057, 0.8012761658865446], 
                 
                 
                 ArrowBox[{{1.7566626367612326`, -1.6739080007030454`}, {
                  1.7932437030260173`, -1.6883214256519907`}, {
                  1.8508858612548085`, -1.710730704289759}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7287515459755897, 0.3457723109295033, 0.7791363697471353], 
                 
                 
                 ArrowBox[{{1.3448391465561316`, 1.5257999979586636`}, {
                  1.4221809198918873`, 1.5603349452610766`}, {
                  1.4615009333745048`, 1.5776025632293453`}, {
                  1.5012536980669484`, 1.5948702774089891`}, {
                  1.5414392139692183`, 1.6121380878000076`}, {
                  1.5820574810813146`, 1.6294059944024009`}, {
                  1.6227094332765848`, 1.646596693832975}, {
                  1.6383917031774697`, 1.653159709269747}}]}}, {
                Arrowheads[{{0.016640853507101466`, 1.}}], {
                 LABColor[
                 0.7594881005126587, 0.2756832919710239, 0.796283009886621], 
                 
                 ArrowBox[{{1.645771508574435, 1.656248150997046}, {
                  1.66378837025128, 1.6637881909309744`}, {
                  1.7199620449597064`, 1.6865774027404878`}, {
                  1.7768981226447391`, 1.7093632892923136`}, {
                  1.8345968577127165`, 1.7321455998948945`}, {
                  1.8930581653615262`, 1.7549244181120833`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36239074933379445`, 
                  0.5222859030052167, -0.4420217203293121], 
                 
                 ArrowBox[{{0.20648433175869937`, 0.07488604484102462}, {
                  0.25689311644236895`, 0.08327144398205698}, {
                  0.3126488079307441, 0.09165697134823898}, {
                  0.373751406223825, 0.10004262693957067`}, {
                  0.4402009113216114, 0.10842841075605197`}, {
                  0.5119973232241033, 0.11681432279768293`}, {
                  0.5235083044434308, 0.11807125296806456`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.47111635341504765`, 
                  0.5266968919183426, -0.04012217479094783], 
                 
                 ArrowBox[{{0.5314610334217794, 0.11893964331631487`}, {
                  0.5789229892170465, 0.12412220447662889`}, {
                  0.6499069433234042, 0.1314304910462351}, {
                  0.6983985737234234, 0.1361918750539247}, {
                  0.7486159817862155, 0.14095347277089282`}, {
                  0.8005591675117804, 0.14571528419713947`}, {
                  0.849933463140934, 0.15009624522173742`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.5539903482463351, 0.5320971066667787, 
                  0.32908353853488537`], 
                 
                 ArrowBox[{{0.857903035404259, 0.1507932377520144}, {
                  0.909622871951228, 0.15523954817746832`}, {
                  0.9667433906651113, 0.16000200073155058`}, {
                  1.0255896870417671`, 0.16476466699491132`}, {
                  1.086161761081196, 0.16952754696755062`}, {
                  1.1484596127833973`, 0.17429064064946842`}, {
                  1.1768743354330888`, 0.17640467354261327`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6222967153885929, 0.5365480692637264, 0.6333901072817387], 
                 
                 
                 ArrowBox[{{1.1848522859585862`, 0.1769982267522895}, {
                  1.2124832421483716`, 0.17905394804066477`}, {
                  1.2782326491761185`, 0.18381746914113964`}, {
                  1.3457078338666382`, 0.188581203950893}, {
                  1.4149087962199307`, 0.19334515246992495`}, {
                  1.485835536235996, 0.19810931469823537`}, {
                  1.5040728539343509`, 0.1993052737700504}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6710618342724322, 0.47732301198141724`, 
                  0.7469536888571308], 
                 
                 ArrowBox[{{1.512055707543617, 0.19982876995248705`}, {
                  1.558488053914834, 0.20287369063582436`}, {
                  1.6328663492564448`, 0.20763828028269185`}, {
                  1.6711411359235269`, 0.21006205582707}, {
                  1.7098601391494388`, 0.21248599223411163`}, {
                  1.7714826537762223`, 0.2161997658869534}, {
                  1.8314341994235575`, 0.21975042430333724`}}]}}, {
                Arrowheads[{{0.0077210387084231755`, 1.}}], {
                 LABColor[
                 0.7091075897003958, 0.39056671435331974`, 
                  0.7681778269228146], 
                 
                 ArrowBox[{{1.8394205154636931`, 0.2202181224255581}, {
                  1.897928253145879, 0.22362424577560902`}, {
                  1.9627519572808774`, 0.22733487620225232`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3803233323970292, 0.5222538827833818, -0.3991638244674964], 
                 
                 ArrowBox[{{0.2597721744947148, -0.0612055508108294}, {
                  0.3154618009572196, -0.06736504603025677}, {
                  0.37648875433487977`, -0.07352466037030188}, {
                  0.4428530346276953, -0.0796843938309647}, {
                  0.5145546418356662, -0.08584424641224528}, {
                  0.5783677488359008, -0.09096841180290709}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.4849311646826034, 0.5275970892324191, 
                  0.021423153859893074`], 
                 
                 ArrowBox[{{0.5863436772665362, -0.09158827780626468}, {
                  0.653314129813669, -0.09665694403101233}, {
                  0.7018184590021028, -0.1001573837187753}, {
                  0.7520484330893589, -0.10365798233438121`}, {
                  0.8040040520754373, -0.10715873987783003`}, {
                  0.857685315960338, -0.11065965634912178`}, {
                  0.9055768023321594, -0.11368584402941401`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5651104521371829, 0.532821712125436, 0.37862387863356034`], 
                 
                 ArrowBox[{{0.9135609342656902, -0.11418945551011783`}, {
                  0.9702247784266061, -0.11766196607523406`}, {
                  1.0290829770079737`, -0.12116335933005457`}, {
                  1.0896668204881632`, -0.12466491151271798`}, {
                  1.1519763088671757`, -0.12816662262322437`}, {
                  1.2160114421450101`, -0.13166849266157366`}, {
                  1.2330313555162395`, -0.1325748722890776}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6319046898280463, 0.5371741417171682, 0.6761938729715217], 
                 
                 
                 ArrowBox[{{1.2410200356048517`, -0.13300030200337945`}, {
                  1.2817722203216666`, -0.13517052162776585`}, {
                  1.3492586433971456`, -0.13867270952180097`}, {
                  1.4184707113714468`, -0.14217505634367902`}, {
                  1.4894084242445702`, -0.1456775620934}, {
                  1.5606138266646306`, -0.1491099474875795}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.6771964475794068, 0.4633341627154094, 0.7503759334240269], 
                 
                 
                 ArrowBox[{{1.568604894940803, -0.14948785748715002`}, {
                  1.636460784687284, -0.1526830503763707}, {
                  1.6747624433450155`, -0.15446595726877183`}, {
                  1.7135087814045016`, -0.15624898278598987`}, {
                  1.7754576807947893`, -0.15899296214314945`}, {
                  1.8384838910029337`, -0.16173620640660943`}, {
                  1.8882812695653537`, -0.1638665649092564}}]}}, {
                Arrowheads[{{0.004472514490066477, 1.}}], {
                 LABColor[
                 0.714712509658131, 0.37778573264944376`, 0.7713045776915125], 
                 
                 ArrowBox[{{1.8962739589019235`, -0.16420849643615062`}, {
                  1.9025883641560697`, -0.16447863007190952`}, {
                  1.967770782878486, -0.16722026164053652`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5335492237110223, 0.5307651271668772, 
                  0.23801781905790992`], 
                 
                 ArrowBox[{{-0.776807640892471, -0.10069806747465763`}, \
{-0.7709503976376977, -0.16857062004257056`}, {-0.7621403711333272, \
-0.23644317091737427`}, {-0.7503775568872044, -0.30431572600357315`}, \
{-0.7356619548993298, -0.37218828530116704`}, {-0.7243004476702012, \
-0.41583315802399456`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5463807794786032, 0.5316012538293186, 
                  0.29518271994019935`], 
                 
                 ArrowBox[{{-0.7222850773225322, -0.42357513983498696`}, \
{-0.7179935651697031, -0.4400608488101558}, {-0.6973725053207492, \
-0.5079333026150189}, {-0.6737988929748926, -0.5758055328002356}, \
{-0.6472727281321334, -0.643677539365806}, {-0.6177940107924718, \
-0.7115493223117297}, {-0.6120505245211627, -0.7235573462976913}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5718500252085658, 0.5332608745185647, 
                  0.40864884470883045`], 
                 
                 ArrowBox[{{-0.6085986270393456, -0.7307742988245565}, \
{-0.5846297213696955, -0.7808865791718038}, {-0.5483833584830198, \
-0.8502243159224216}, {-0.5190443323496947, -0.9024699795368011}, \
{-0.48795517032592256`, -0.9547157629952812}, {-0.45511587241170365`, \
-1.006961666297862}, {-0.4530264193880277, -1.0101177055569999`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6052758813248629, 0.5354389618853654, 0.5575618671360422], 
                 
                 
                 ArrowBox[{{-0.4486101648535138, -1.01678828993068}, \
{-0.4205264386070376, -1.0592076894445435`}, {-0.38418686891192466`, \
-1.1114538324353258`}, {-0.3460971633263648, -1.1637000952702088`}, \
{-0.30625732185035803`, -1.2159464779491926`}, {-0.26466734448390433`, \
-1.2681929804722767`}, {-0.25933850174371825`, -1.2746169146380761`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6424707041315082, 0.5360954521713629, 0.720329426049379], 
                 
                 ArrowBox[{{-0.2542308619605051, -1.280774188048031}, \
{-0.22132723122700365`, -1.3204396028394618`}, {-0.1762369820796561, \
-1.3726863450507478`}, {-0.12939659704186154`, -1.4249332071061345`}, \
{-0.08080607611362, -1.4771801890056218`}, {-0.04061084926935196, \
-1.5188976444234747`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6710733886316316, 0.47729666440560126`, 
                  0.7469601345515886], 
                 
                 ArrowBox[{{-0.035060077856076836`, -1.5246586284294903`}, \
{-0.030465419294931607`, -1.5294272907492097`}, {
                  0.02162537341420383, -1.5816745123368985`}, {
                  0.07546630201378615, -1.633921853768688}, {
                  0.13105736650381541`, -1.686169315044578}, {
                  0.15660084770790386`, -1.709804430787809}, {
                  0.18250102358480175`, -1.73344077904569}, {
                  0.196347030188991, -1.7455903242905018`}}]}}, {
                Arrowheads[{{0.006814484750340417, 1.}}], {
                 LABColor[
                 0.6990305353500217, 0.4135455701179498, 0.7625562591441777], 
                 
                 
                 ArrowBox[{{0.20236025788887688`, -1.7508667902128143`}, {
                  0.23304889862062012`, -1.7777953508968223`}, {
                  0.2848667763109269, -1.8221421176172403`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.37913416520507226`, 
                  0.5222560061471577, -0.4020058692245435], 
                 
                 ArrowBox[{{0.08608187647879004, 0.24915904397150374`}, {
                  0.13887053909686495`, 0.28429307143132176`}, {
                  0.19861353073254873`, 0.31942684997163623`}, {
                  0.2653108513858413, 0.3545603795924471}, {
                  0.3389625010567426, 0.3896936602937542}, {
                  0.3666341274598843, 0.40202055196045067`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.4731567554145293, 
                  0.5268298480886439, -0.03103213300855652], 
                 
                 ArrowBox[{{0.3739418345179543, 0.4052759194594335}, {
                  0.37839619927379653`, 0.40726020729959395`}, {
                  0.4195684797452527, 0.42482669207555773`}, {
                  0.46247934247111083`, 0.44239311462164554`}, {
                  0.5071287874513714, 0.4599594749378575}, {
                  0.5707577514233336, 0.4838921936404801}, {
                  0.6376129360914385, 0.5078255159350386}, {
                  0.6726275709498608, 0.5198491916709062}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5509389670410011, 0.5318982733195786, 0.3154895591830048], 
                 
                 
                 ArrowBox[{{0.6801939007186164, 0.5224473937089399}, {
                  0.688589597184572, 0.5253303919835639}, {0.7412940190276546,
                   0.5428357591043979}, {0.7957262016206863, 
                  0.5603416172975403}, {0.8518861449636672, 
                  0.5778479665629913}, {0.909773849056597, 
                  0.5953548069007508}, {0.9693893138994759, 
                  0.6128621383108189}, {0.9857118275184418, 
                  0.6175207076662008}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6170200919340487, 0.5362042352316011, 0.6098826182261817], 
                 
                 
                 ArrowBox[{{0.9934046420056443, 0.6197162953473211}, {
                  1.030732539492304, 0.6303699607931955}, {1.093803525835081, 
                  0.6478782743478807}, {1.1586022729278072`, 
                  0.6653870789748745}, {1.2251287807704825`, 
                  0.6828963746741769}, {1.2933830493631069`, 
                  0.7004061614457877}, {1.302449985402058, 
                  0.7026748091361527}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6664560092377234, 0.48782574278645324`, 
                  0.7443842914212423], 
                 
                 ArrowBox[{{1.3102107398392722`, 0.7046166357415063}, {
                  1.3633650787056806`, 0.7179164392897072}, {
                  1.4350748687982031`, 0.7354272082059352}, {
                  1.508512419640675, 0.7529384681944717}, {
                  1.5836777312330956`, 0.7704502192553169}, {
                  1.621426590869464, 0.7790474458982982}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7039895341528402, 0.4022374919569235, 0.7653226774758589], 
                 
                 
                 ArrowBox[{{1.6292268517738722`, 0.7808239395862022}, {
                  1.6605708035754656`, 0.7879624613884706}, {
                  1.6998222588944045`, 0.7968027078648732}, {
                  1.7395117537316478`, 0.8056434731040676}, {
                  1.7990134368625021`, 0.8184399427582976}, {
                  1.8594514153508765`, 0.8312336821163246}, {
                  1.920826283633696, 0.8440244198145184}, {
                  1.9420084872499759`, 0.8483715160014794}}]}}, {
                Arrowheads[{{0.002124159001450013, 1.}}], {
                 LABColor[
                 0.7384814564209583, 0.32358505253503095`, 
                  0.7845642804387826], 
                 
                 ArrowBox[{{1.9498451610743546`, 0.8499797894142717}, {
                  1.983137843565319, 0.8568122463074225}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.6920282101944567, 0.42951307551904916`, 
                  0.7586499543748081], 
                 
                 ArrowBox[{{0.6426717643405273, 1.5754463934102199`}, {
                  0.7073489160687715, 1.6183298686093732`}, {
                  0.7737632690388307, 1.6612137408778014`}, {
                  0.8419148232507051, 1.704098010215504}, {0.8752711907942236,
                   1.7248234066699695`}, {0.9090314718670147, 
                  1.745549890321317}, {0.912413620422988, 
                  1.7475598528989063`}}]}}, {
                Arrowheads[{{0.011104077070895712`, 1.}}], {
                 LABColor[
                 0.722823159806423, 0.35929089740941583`, 0.775829170687852], 
                 
                 
                 ArrowBox[{{0.9192908404930868, 1.7516468865551698`}, {
                  0.9491766220224002, 1.7694075796417708`}, {
                  0.9898646725534895, 1.79326226078698}, {1.0310957257541262`,
                   1.8171137414884573`}, {1.0728697475263627`, 
                  1.8409620858356994`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6463356811811763, 0.5337064238141654, 0.7331600006746029], 
                 
                 
                 ArrowBox[{{-0.12235408884744768`, 
                  1.3236494930382288`}, {-0.07555906540002705, 
                  1.3740138831974504`}, {-0.027016098516727816`, 
                  1.4243784280542116`}, {0.023274811802450085`, 
                  1.4747431276085121`}, {0.07531366555750668, 
                  1.5251079818603521`}, {0.10283783529674322`, 
                  1.5508811293173363`}}]}}, {
                Arrowheads[{{0.019469805125705553`, 1.}}], {
                 LABColor[
                 0.6753385718851447, 0.46757070408183354`, 
                  0.7493395021638155], 
                 
                 ArrowBox[{{0.1086773883243883, 1.5563491838559562`}, {
                  0.1291004627484419, 1.5754729908097314`}, {
                  0.18463520337525577`, 1.6258381544566498`}, {
                  0.21045620327301298`, 1.6488927647915221`}, {
                  0.23664190735678892`, 1.6719486450597703`}, {
                  0.28933445233750826`, 1.7165032404871656`}, {
                  0.3434050490842604, 1.7610490763554327`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5821997087276158, 0.5339352780355546, 
                  0.45475694284174323`], 
                 
                 ArrowBox[{{-0.9986617668457805, 
                  0.04475372185118164}, {-0.9986220111879734, 
                  0.04649701854924553}, {-0.9960448927388521, 
                  0.11163255058179987`}, {-0.991344676937423, 
                  0.17676808343970876`}, {-0.9845213637836862, 
                  0.2419036171229722}, {-0.9755749532776414, 
                  0.3070391516315899}, {-0.9661044773878351, 
                  0.36276599888170663`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5893244790196462, 0.5343995405546786, 0.4864979721393763], 
                 
                 
                 ArrowBox[{{-0.9647641382212825, 
                  0.3706529178567313}, {-0.9645055291454415, 
                  0.37217464375884707`}, {-0.9513131751132384, 
                  0.43731005029802894`}, {-0.9359978911810325, 
                  0.5024453712491352}, {-0.9185596773488235, 
                  0.5675806066121659}, {-0.8965471711983788, 
                  0.6404111049752547}, {-0.8832107519897876, 
                  0.6797872696515035}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6065107838829126, 0.5355194303003421, 0.5630633888228007], 
                 
                 
                 ArrowBox[{{-0.8806444111779391, 
                  0.6873644653621501}, {-0.87187993824399, 
                  0.7132418260052068}, {-0.8499562426300482, 
                  0.7722492055845143}, {-0.826289880679131, 
                  0.8312564945559051}, {-0.8008808523912383, 
                  0.8902636929193793}, {-0.7737291577663701, 
                  0.9492708006749369}, {-0.7574774222008217, 
                  0.9824595062656784}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6312340659755412, 0.5371304426916013, 0.6732062269875015], 
                 
                 
                 ArrowBox[{{-0.7539591735067813, 
                  0.989644346286645}, {-0.7448347968045266, 
                  1.008277817822578}, {-0.7141977695057075, 
                  1.0672847443623021`}, {-0.6818180758699128, 
                  1.1262915802941096`}, {-0.6476957158971426, 
                  1.1852983256180005`}, {-0.6118306895873971, 
                  1.244304980333975}, {-0.5966499477349543, 
                  1.2681236023839542`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6562317867367871, 0.5111401882568977, 0.7386806246775234], 
                 
                 
                 ArrowBox[{{-0.592350220035051, 
                  1.2748698859317074`}, {-0.574222996940676, 
                  1.3033115444420325`}, {-0.5348726379569796, 
                  1.3623180179421734`}, {-0.4937796126363076, 
                  1.421324400834398}, {-0.4509439209786601, 
                  1.4803306931187055`}, {-0.4084297522740901, 
                  1.5366046279502343`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.679500738455726, 0.45807965422060054`, 0.7516614010708738], 
                 
                 ArrowBox[{{-0.40354017009422255`, 
                  1.5429360260551268`}, {-0.3600445386524388, 
                  1.5983430058635708`}, {-0.31198084798386494`, 
                  1.6573490263241286`}, {-0.2889620428315874, 
                  1.6851051596300493`}, {-0.26555905280511805`, 
                  1.712862857841938}, {-0.21415471421237361`, 
                  1.7708588674519252`}, {-0.1982214424372787, 
                  1.7882571571709478`}}]}}, {
                Arrowheads[{{0.0029394448992999278`, 1.}}], {
                 LABColor[
                 0.7037830479765318, 0.4027083454323347, 0.7652074874614848], 
                 
                 
                 ArrowBox[{{-0.19281843958491074`, 
                  1.794156950402689}, {-0.1610547812343185, 
                  1.828841184646623}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5433900413842251, 0.5314063720935117, 0.2818589071596821], 
                 
                 
                 ArrowBox[{{-0.40549405024847074`, -0.7184070851726742}, \
{-0.36365441040496954`, -0.7868104613619121}, {-0.3180120953762345, \
-0.8552135884134945}, {-0.27855988773968104`, -0.9102069068557475}, \
{-0.23664960418535222`, -0.9652006084090483}, {-0.2236508533949675, \
-0.9813852167924655}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5847134558899755, 0.5340990782062554, 0.4659557491269857], 
                 
                 
                 ArrowBox[{{-0.2186413025766439, -0.9876225560167368}, \
{-0.19948588824520033`, -1.011472761653869}, {-0.1605813093822283, \
-1.0577452380363013`}, {-0.11993586759643615`, -1.1040180375563449`}, \
{-0.07754956288782382, -1.1502911602140002`}, {-0.03342239525639136, \
-1.196564606009267}, {-0.0047887156943007434`, -1.2254515727210178`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.628724366063149, 0.5369669062468017, 0.6620254513017768], 
                 
                 ArrowBox[{{0.000843174489786461, -1.2311332813508564`}, {
                  0.01244563529786134, -1.2428383749421454`}, {
                  0.06005452877493416, -1.2891124670126355`}, {
                  0.10940428517482698`, -1.3353868822207364`}, {
                  0.16049490449754006`, -1.3816616205664496`}, {
                  0.21332638674307322`, -1.427936682049774}, {
                  0.23644510837870278`, -1.4475405259441998`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.664639236314742, 0.4919685568968806, 0.7433707896805724], 
                 
                 ArrowBox[{{0.24254674895864992`, -1.452714497555365}, {
                  0.2678987319114266, -1.4742120666707101`}, {
                  0.3242119400026001, -1.5204877744292578`}, {
                  0.38226601101659374`, -1.566763805325417}, {
                  0.44206094495340753`, -1.6130401593591877`}, {
                  0.4932280188774034, -1.651519260672951}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6953168531694424, 0.42201393440538093`, 0.760484550948452], 
                 
                 ArrowBox[{{0.4996217878016362, -1.6563275575589091`}, {
                  0.5035967418130415, -1.65931683653057}, {
                  0.5668734015954956, -1.7055938368395638`}, {
                  0.5973194347983212, -1.7275582935240872`}, {
                  0.6281558958770354, -1.7495239284741888`}, {
                  0.6972034398645656, -1.7967960951160655`}, {
                  0.7617275323581382, -1.8398189226748614`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3055238265980111, 0.5223874439530349, -0.5779305653628448], 
                 
                 ArrowBox[{{-0.09824486506023984, -0.019927458723002448`}, \
{-0.0953930634894743, -0.03910527113822218}, {-0.06545648649775913, \
-0.11581661120040243`}, {-0.03937115646125309, -0.15417221632622102`}, \
{-0.00587534583067581, -0.1925275627049969}, {
                  0.035031787534508016`, -0.23088265407536726`}, {
                  0.08335108577483381, -0.2692374941759693}, {
                  0.08597912162186613, -0.27104611768432363`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.38881103513562776`, 
                  0.5222648473524546, -0.3780729680386344], 
                 
                 ArrowBox[{{0.09256929184381818, -0.27558149599772774`}, {
                  0.1390825488903016, -0.307592083006803}, {
                  0.2022261768809112, -0.34594642056786834`}, {
                  0.2727819697466629, -0.3843005068591655}, {
                  0.3507499274875565, -0.4226543418806942}, {
                  0.371160337547183, -0.4320263161034782}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.48031180719344124`, 0.5272960838025245, 
                  0.0008438010681623133], 
                 
                 ArrowBox[{{0.37843053340364396`, -0.4353646169000958}, {
                  0.3925134681861815, -0.4418311651652954}, {
                  0.4361300501035919, -0.4610079256324545}, {
                  0.48159967323978803`, -0.48018462328217165`}, {
                  0.5289223375947695, -0.49936125811444665`}, {
                  0.5934649734530864, -0.5243866373643332}, {
                  0.6611625595806825, -0.5494125730162551}, {
                  0.6753442177150968, -0.5544477463461173}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5563052873188014, 0.5322479521539102, 
                  0.33939664982263834`], 
                 
                 ArrowBox[{{0.6828831416204068, -0.557124428312647}, {
                  0.7132993219238406, -0.5679236408171763}, {
                  0.7671639217178056, -0.5864351770881422}, {
                  0.8227563589625776, -0.6049471818291527}, {
                  0.8800766336581565, -0.6234596550402081}, {
                  0.9391247458045421, -0.641972596721308}, {
                  0.9870078425988323, -0.6565586199119783}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6213773651339984, 0.5364881627898809, 0.629294378974749], 
                 
                 ArrowBox[{{0.9946606588236844, -0.6588898006918926}, {
                  0.9999006954017348, -0.6604860068724527}, {
                  1.0624044824497343`, -0.6789998854936421}, {
                  1.1266361069485407`, -0.6975142325848762}, {
                  1.1925955688981544`, -0.7160290481461552}, {
                  1.260282868298575, -0.7345443321774788}, {
                  1.3026077497622903`, -0.7458340459975568}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.6690539962115827, 0.48190151474569776`, 
                  0.7458335998554104], 
                 
                 ArrowBox[{{1.3103374892768929`, -0.7478958721387221}, {
                  1.3296980051498022`, -0.7530600846788471}, {
                  1.4008409794518364`, -0.77157630565026}, {
                  1.4737117912046775`, -0.7900929950917177}, {
                  1.5483104404083257`, -0.8086101530032201}, {
                  1.620613388657217, -0.8261516257034989}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.7062604180154785, 0.39705916196847285`, 
                  0.7665895087449351], 
                 
                 ArrowBox[{{1.6283924251564916`, -0.8280187571840308}, {
                  1.7026912511680425`, -0.8456458742363591}, {
                  1.7425218939883407`, -0.8549922170466053}, {
                  1.7827904744731509`, -0.8643390901381366}, {
                  1.8430540755881544`, -0.8778516875323644}, {
                  1.9042511314420123`, -0.8913614964987082}, {
                  1.940364345122168, -0.8992121911362021}}]}}, {
                Arrowheads[{{0.00331283685641491, 1.}}], {
                 LABColor[
                 0.7404817832103048, 0.3190236778340191, 0.7856801792158212], 
                 
                 
                 ArrowBox[{{1.9481817562127792`, -0.900911627466397}, {
                  1.966382209599564, -0.904868245757671}, {
                  2., -0.9120666582465398}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6260625369597389, 0.5367934567972933, 0.6501669362769289], 
                 
                 
                 ArrowBox[{{-1.2173185765649865`, 
                  0.0002225556479002757}, {-1.2163384663718868`, 
                  0.06908313937594296}, {-1.2134107223329995`, 
                  0.13794372338965977`}, {-1.2085353444483249`, 
                  0.20680430768905045`}, {-1.201712332717863, 
                  0.2756648922741148}, {-1.1961557439065098`, 
                  0.31929135324765945`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6303017449609737, 0.5370696910203033, 0.6690527136214228], 
                 
                 
                 ArrowBox[{{-1.1951449703540913`, 
                  0.3272272424118131}, {-1.1929417419709258`, 
                  0.34452545545892277`}, {-1.1822236270368258`, 
                  0.4133859755575444}, {-1.1695579879155629`, 
                  0.48224645256997967`}, {-1.1549448246071368`, 
                  0.5511068864962284}, {-1.1370574652768297`, 
                  0.6251553598446369}, {-1.1327836433830836`, 
                  0.6408690889428955}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6423692819400535, 0.5375799460552655, 0.7223551549566855], 
                 
                 
                 ArrowBox[{{-1.1306840730581718`, 
                  0.6485886617581975}, {-1.1169177223168438`, 
                  0.6992039451272527}, {-1.0973871254324685`, 
                  0.7642104965221896}, {-1.0761206416033449`, 
                  0.8292168983928083}, {-1.0531182708294724`, 
                  0.8942231507391089}, {-1.0309542400788936`, 
                  0.9524648134426708}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6563053649718514, 0.5109724067215227, 0.7387216709020514], 
                 
                 
                 ArrowBox[{{-1.0280924904518067`, 
                  0.9599352512348043}, {-1.0019058684474815`, 
                  1.0242352068587555`}, {-0.9736958368393631, 
                  1.0892410106321018`}, {-0.9437499182864961, 
                  1.1542466648811298`}, {-0.9120681127888802, 
                  1.2192521696058396`}, {-0.8956899774086342, 
                  1.2511115360103042`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6732094128455924, 0.47242585686445304`, 
                  0.7481517332547497], 
                 
                 ArrowBox[{{-0.8920323734046481, 
                  1.258226445212116}, {-0.8786504203465159, 
                  1.2842575248062311`}, {-0.8434968409594029, 
                  1.3492627304823048`}, {-0.8066073746275413, 
                  1.4142677866340603`}, {-0.767982021350931, 
                  1.4792726932614975`}, {-0.7329188792954975, 
                  1.535744472128675}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6925526793564171, 0.42831712074827455`, 
                  0.7589425338170988], 
                 
                 ArrowBox[{{-0.7286989605433464, 
                  1.5425409628205868`}, {-0.727620781129572, 
                  1.5442774503646166`}, {-0.6855236539634644, 
                  1.6092820579434177`}, {-0.6416906398526082, 
                  1.6742865159979006`}, {-0.5961217387970033, 
                  1.7392908245280652`}, {-0.5735212509229891, 
                  1.770927931053428}, {-0.550510937061699, 
                  1.8025667845132949`}, {-0.5476457430591077, 
                  1.8063188021677776`}}]}}, {
                Arrowheads[{{0.011136825304155593`, 1.}}], {
                 LABColor[
                 0.7135022334345303, 0.38054554338485463`, 
                  0.7706294151305811], 
                 
                 ArrowBox[{{-0.542790416158976, 
                  1.8126769308777722`}, {-0.5218668854760177, 
                  1.8400766310186967`}, {-0.4926404776942686, 
                  1.8775810594830318`}, {-0.46283178744286013`, 
                  1.915079816262252}, {-0.43244079014632286`, 
                  1.9525729859043741`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.648422659668426, 0.5289474559675132, 0.7343242388151062], 
                 
                 ArrowBox[{{-1.3452922313937326`, -0.0004588836430886201}, \
{-1.3452914762280392`, -0.0020674255680173366`}, {-1.3452889734366897`, \
-0.004212148134588959}, {-1.3452847610410452`, -0.006356870701160581}, \
{-1.345250815415521, -0.014935760967479925`}, {-1.3448414962264503`, \
-0.049251322032552926`}, {-1.3439945187221913`, -0.08356688633009111}, \
{-1.3409876135000474`, -0.15219801475949962`}, {-1.336230123713214, \
-0.22082912992636847`}, {-1.3336953148889323`, -0.25171382196659053`}, \
{-1.330806175155654, -0.28260053050649286`}, {-1.3261211620932414`, \
-0.31968191763574677`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6510055679304795, 0.523057612135839, 0.735765135465683], 
                 
                 ArrowBox[{{-1.3251183815161243`, -0.327618820754354}, \
{-1.323572797207498, -0.33985195849070077`}, {-1.315119368176359, \
-0.39709063356973423`}, {-1.306606254405803, -0.45106614410975454`}, \
{-1.2970098976870088`, -0.5050417706544821}, {-1.2863302980199767`, \
-0.5590175132039171}, {-1.2745674554047062`, -0.6129933717580595}, \
{-1.267602949350489, -0.6422564495835124}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6584023866866637, 0.5061905371548294, 0.7398915117397813], 
                 
                 
                 ArrowBox[{{-1.2657507133748256`, -0.6500390726561311}, \
{-1.2617213698411975`, -0.6669693463169091}, {-1.2477920413294508`, \
-0.7209454368804661}, {-1.2327794698694658`, -0.7749216434487305}, \
{-1.2166836554612426`, -0.828897966021702}, {-1.1995045981047814`, \
-0.882874404599381}, {-1.1812422978000823`, -0.9368509591817673}, \
{-1.1741990582082773`, -0.9565025460274926}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6701296228952505, 0.47944874734351844`, 
                  0.7464336470613208], 
                 
                 ArrowBox[{{-1.1714999345752661`, -0.9640334644053348}, \
{-1.1618967545471448`, -0.9908276297688611}, {-1.1414679683459692`, \
-1.044804416360662}, {-1.1199559391965555`, -1.0987813189571705`}, \
{-1.0973606670989036`, -1.1527583375583865`}, {-1.0736821520530135`, \
-1.2067354721643093`}, {-1.0493898758114817`, -1.2596893166733611`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6852017921103801, 0.4450794574287819, 0.7548417808142949], 
                 
                 
                 ArrowBox[{{-1.0459517451445857`, -1.2669126927286187`}, \
{-1.023075173197012, -1.314690002478832}, {-0.9961462695478865, \
-1.3686672243645401`}, {-0.9681336831115089, -1.4226443884320645`}, \
{-0.9390374138878792, -1.4766214946814054`}, {-0.9088574618769972, \
-1.5305985431125617`}, {-0.8974640286610763, -1.5502694240487096`}}]}}, {
                Arrowheads[{{0.009878982772327289, 1.}}], {
                 LABColor[
                 0.7027501563206411, 0.40506366351993855`, 
                  0.7646312803428477], 
                 
                 ArrowBox[{{-0.8934544131805445, -1.5571920668748476`}, \
{-0.8775938270788635, -1.584575533725535}, {-0.845246509493477, \
-1.6385524665203233`}, {-0.8118155091208386, -1.6925293414969285`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6800435927238523, 0.45684177562088596`, 
                  0.7519642367960856], 
                 
                 ArrowBox[{{-1.5994006811820787`, -0.008992764246349722}, \
{-1.599314329529282, -0.025165805056359104`}, {-1.599146208128786, \
-0.04133884586628013}, {-1.5976560249247687`, -0.10603100911988973`}, \
{-1.594857543575835, -0.17072316918371602`}, {-1.5907507821521807`, \
-0.23541532283941746`}, {-1.585335740653807, -0.3001074700869947}, \
{-1.5823948229366558`, -0.32840512937441424`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6821643148187837, 0.4520058617276078, 0.7531472990860957], 
                 
                 
                 ArrowBox[{{-1.5815678533992807`, -0.3363622721646533}, \
{-1.5786124190807127`, -0.36479961092644714`}, {-1.5703068928679984`, \
-0.4315269920655258}, {-1.5606093630807003`, -0.4982543914473709}, \
{-1.5481584653427711`, -0.5726574832724832}, {-1.5339769619846588`, \
-0.6470603631165487}, {-1.5328144235970216`, -0.6524962206544377}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6881010054656941, 0.4384683384245291, 0.756459130866696], 
                 
                 ArrowBox[{{-1.5311413395822926`, -0.6603193140246882}, \
{-1.5180648530063636`, -0.7214630309795672}, {-1.5004221384078857`, \
-0.7958654868615382}, {-1.4810488181892247`, -0.8702677307624623}, \
{-1.4599448923503806`, -0.9446697626823396}, {-1.452085361442348, \
-0.9702784949864109}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6974971740127046, 0.41704211660665286`, 
                  0.7617008608911605], 
                 
                 ArrowBox[{{-1.4497381531383562`, -0.9779264105964104}, \
{-1.4371103608913536`, -1.01907158262117}, {-1.4125452238121434`, \
-1.0934731905789523`}, {-1.3862494811127508`, -1.1678745865556885`}, \
{-1.358223132793175, -1.2422757705513776`}, {-1.343297598117322, \
-1.2795939144033923`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7097871935212701, 0.38901700373015724`, 
                  0.7685569495124952], 
                 
                 ArrowBox[{{-1.3403267683338156`, -1.2870218461745808`}, \
{-1.328466178853416, -1.3166767425660193`}, {-1.2969786192934742`, \
-1.391077502599614}, {-1.2637604541133494`, -1.4654780506521616`}, \
{-1.2288116833130416`, -1.5398783867236623`}, {-1.2095357649142722`, \
-1.5789774898377689`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7243901876890266, 0.355717580600604, 0.776703350100484], 
                 
                 ArrowBox[{{-1.2059982858381124`, -1.586152881240733}, \
{-1.192132306892551, -1.6142785108141158`}, {-1.153722324851877, \
-1.6886784229235223`}, {-1.1341127554521047`, -1.7258251467973638`}, \
{-1.1140728693934925`, -1.7629738105431547`}, {-1.085261555175434, \
-1.8130954124587544`}, {-1.0556591596094158`, -1.8632080727138984`}, \
{-1.0532303843845288`, -1.8672119145699067`}}]}}, {
                Arrowheads[{{0.006557853566435299, 1.}}], {
                 LABColor[
                 0.7406425792250497, 0.31865701230837196`, 
                  0.7857698805971967], 
                 
                 ArrowBox[{{-1.0490812167767498`, -1.8740518274467317`}, \
{-1.0252659127000356`, -1.9133114140477716`}, {-0.9940817377790946, \
-1.9634055622139797`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5899075824619582, 0.5344375365969286, 
                  0.48909571251378203`], 
                 
                 ArrowBox[{{0.10624645297060234`, -1.0308999432714967`}, {
                  0.1403876194948958, -1.0612560500134163`}, {
                  0.1877766579584015, -1.102006301345865}, {
                  0.23695105661768273`, -1.1427567328344075`}, {
                  0.2871512673770452, -1.1829056835524892`}, {
                  0.3390852313062465, -1.2230550150209383`}, {
                  0.35351857661658687`, -1.2338528408255192`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6396379147831668, 0.536734566745731, 0.7090779185235903], 
                 
                 ArrowBox[{{0.3599243628702601, -1.238645116117304}, {
                  0.39275294840528624`, -1.263204727239754}, {
                  0.44815441867416456`, -1.3033548202089367`}, {
                  0.5052896421128813, -1.3435052939284862`}, {
                  0.5641586187214368, -1.3836561483984031`}, {
                  0.6220892827100609, -1.4220370550799981`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6751720704204254, 0.46795037982926474`, 
                  0.7492466179501736], 
                 
                 ArrowBox[{{0.6287922396545882, -1.426403725054884}, {
                  0.6870978314480631, -1.4639589995893367`}, {
                  0.7511680675661344, -1.5041109963103545`}, {
                  0.8169720568540441, -1.5442633737817388`}, {
                  0.8845097993117922, -1.58441613200349}, {
                  0.9012725208890033, -1.594132623367546}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7075237665617058, 0.39417832963247024`, 
                  0.7672942781382247], 
                 
                 ArrowBox[{{0.9081938251340093, -1.5981445490333657`}, {
                  0.953781294939379, -1.6245692709756083`}, {
                  1.0247865437368044`, -1.6647227906980933`}, {
                  1.0975255457040682`, -1.7048766911709452`}, {
                  1.1719983008411707`, -1.7450309723941642`}, {
                  1.1879590891767384`, -1.7534410160332885`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7382805072546226, 0.32404327988487946`, 
                  0.7844521792910325], 
                 
                 ArrowBox[{{1.1950366744110208`, -1.7571703306152817`}, {
                  1.2482048091481117`, -1.7851856343677501`}, {
                  1.2860725419537684`, -1.8049145358780092`}, {
                  1.3243569614461295`, -1.8246443691307557`}, {
                  1.3732569688539173`, -1.8490741445361005`}, {
                  1.422805400495122, -1.8735007262409162`}, {
                  1.473002417069998, -1.897923896530155}, {
                  1.4805798641375967`, -1.9015631528203734`}}]}}, {
                Arrowheads[{{0.002499974516192293, 1.}}], {
                 LABColor[
                 0.7675383140070697, 0.2573262713248386, 0.8007738877977487], 
                 
                 
                 ArrowBox[{{1.48779127554137, -1.905026611433599}, {
                  1.5238479650117942`, -1.9223437279755002`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6746549624244164, 0.4691295488246753, 0.7489581449949462], 
                 
                 
                 ArrowBox[{{1.4733082945975735`, 0.49601912129017905`}, {
                  1.5464921187631802`, 0.507865103939031}, {1.621402663834684,
                   0.5197114856199739}, {1.698039929812085, 
                  0.5315582663330083}, {1.737328593908936, 
                  0.5375640503920658}, {1.7770587346964801`, 
                  0.5435702011987097}, {1.7894755075676239`, 
                  0.5453806532701784}}]}}, {
                Arrowheads[{{0.012790778961922445`, 1.}}], {
                 LABColor[
                 0.7119958764150142, 0.3839805115291136, 0.769789081458696], 
                 
                 ArrowBox[{{1.797391801211273, 0.5465349040867337}, {
                  1.838530033464599, 0.5525331452217297}, {
                  1.9010054390183366`, 0.5614939916591593}, {
                  1.9644856911095645`, 0.570452517497044}, {2., 
                  0.5753850880046403}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6322815076050194, 0.5371986958239278, 0.6778726055633858], 
                 
                 
                 ArrowBox[{{-1.249911508120068, -0.0010242223554946667`}, \
{-1.2499096584038005`, -0.0032088875929272426`}, {-1.2499002312521021`, \
-0.007578218067792394}, {-1.2498584660720513`, -0.016316879017522698`}, \
{-1.2497861530564622`, -0.025055539967252998`}, {-1.2496832922053347`, \
-0.0337942009169833}, {-1.2489663704454417`, -0.06874884471590394}, \
{-1.2460662308196864`, -0.13865813231381618`}, {-1.241211029729095, \
-0.2085674199063312}, {-1.2344007665072299`, -0.27847670779632355`}, \
{-1.2291782128987885`, -0.3201302752938885}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6363818967119758, 0.537465884364492, 0.696139941272606], 
                 
                 ArrowBox[{{-1.228182959613802, -0.3280681258152024}, \
{-1.2256354932994469`, -0.3483859756695822}, {-1.2149152629274185`, \
-0.4182952029034803}, {-1.202240075391144, -0.4882043894980181}, \
{-1.1876099306906238`, -0.5581135354531951}, {-1.1698703818955547`, \
-0.6326010745978533}, {-1.1673459887921709`, -0.6420220598009173}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6470223396949608, 0.5321406262706379, 0.733543058782836], 
                 
                 ArrowBox[{{-1.165275399907034, -0.6497494566244763}, \
{-1.1499111005244198`, -0.7070887184633022}, {-1.1304202077153283`, \
-0.7729510545169843}, {-1.109193895840081, -0.8388132404774435}, \
{-1.086232164898678, -0.9046752763446793}, {-1.067621888691282, \
-0.9543048038577409}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.6599058548915779, 0.5027621564171438, 0.7407302338626442], 
                 
                 
                 ArrowBox[{{-1.064813006569278, -0.9617954768064609}, \
{-1.0615350148911196`, -0.9705371621186918}, {-1.035102445817405, \
-1.0363988977994811`}, {-1.006934457677535, -1.1022604833870473`}, \
{-0.9770310504715092, -1.16812191888139}, {-0.9453922241993276, \
-1.2339832042825094`}, {-0.9351473369491328, -1.2542005874340663`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6763157931836293, 0.46534233193187347`, 
                  0.7498846531149916], 
                 
                 ArrowBox[{{-0.9315312217114176, -1.261336672536387}, \
{-0.9120179788609905, -1.299844339590406}, {-0.8769083144564976, \
-1.3657053248050792`}, {-0.840063230985849, -1.4315661599265292`}, \
{-0.8014827284490446, -1.4974268449547559`}, {-0.7751693002834257, \
-1.5404127519130184`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6951829220447088, 0.42231933952582995`, 
                  0.7604098363672678], 
                 
                 ArrowBox[{{-0.7709925859597299, -1.5472358785759373`}, \
{-0.7611668068460846, -1.5632873798897593`}, {-0.7191154661769689, \
-1.6291477647315393`}, {-0.6753287064416974, -1.6950079994800964`}, \
{-0.6298065276402703, -1.76086808413543}, {-0.6071772849906737, \
-1.7929949590180325`}, {-0.592844462732551, -1.8129809307869449`}}]}}, {
                Arrowheads[{{0.012611951832869573`, 1.}}], {
                 LABColor[
                 0.7156855573340132, 0.3755668776727042, 0.7718474003529397], 
                 
                 
                 ArrowBox[{{-0.5881822607108415, -1.8194819978000412`}, \
{-0.5841364289833035, -1.8251235858440509`}, {-0.5551508905504423, \
-1.8635996471835043`}, {-0.5255685979612084, -1.9020701055641034`}, \
{-0.4953896308297969, -1.9405347000242752`}, {-0.464613962618143, \
-1.9789935175512112`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5754655488555567, 0.5334964683759811, 
                  0.42475609270443115`], 
                 
                 ArrowBox[{{-0.9628505207627286, -0.10111072396036429`}, \
{-0.9579016451076893, -0.17127726651212652`}, {-0.950403127069031, \
-0.24144381068584295`}, {-0.9403549666467536, -0.31161035648151375`}, \
{-0.9277571638408573, -0.38177690389913893`}, {-0.91996597741927, \
-0.417867724048094}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5849547156266249, 0.534114799113528, 0.46703056726924835`], 
                 
                 ArrowBox[{{-0.9182778475738218, -0.4256875845087996}, \
{-0.9126098172622898, -0.45194338837527315`}, {-0.8949130255219995, \
-0.5221097453464714}, {-0.8746667886199857, -0.5922759748127332}, \
{-0.851871106556249, -0.6624420767740586}, {-0.8266704170314689, \
-0.7319877015517121}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6043915707283225, 0.5353813386570492, 0.5536222413793505], 
                 
                 
                 ArrowBox[{{-0.8238617397077518, -0.7394773773960926}, \
{-0.7949374028857069, -0.8116096482381618}, {-0.7696444762948246, \
-0.8697255029843051}, {-0.7426021476270734, -0.9278413371457647}, \
{-0.7138104168824536, -0.9859571507225409}, {-0.6905752386273615, \
-1.0301706649199327`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6311920364422461, 0.5371277039735507, 0.6730189843687214], 
                 
                 
                 ArrowBox[{{-0.6868536693689401, -1.0372523259012825`}, \
{-0.6832692840609653, -1.0440729437146334`}, {-0.650978749162608, \
-1.1021887161220423`}, {-0.6169388121873821, -1.160304467944768}, \
{-0.5811494731352875, -1.2184201991828099`}, {-0.5436107320063241, \
-1.2765359098361682`}, {-0.5206354483545663, -1.3105213404265161`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6573565172368442, 0.5085754486974712, 0.739308064851897], 
                 
                 ArrowBox[{{-0.5161549618039768, -1.31714895238483}, \
{-0.5043225888004922, -1.3346515999048432`}, {-0.4632850435177916, \
-1.3927672693888344`}, {-0.4204980961582223, -1.4508829182881422`}, \
{-0.3759617467217843, -1.5089985466027664`}, {-0.32967599520847757`, \
-1.567114154332707}, {-0.32454890050190316`, -1.573317197249236}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.681490533324861, 0.45354229561268977`, 0.7527714245294661], 
                 
                 ArrowBox[{{-0.31945216996644005`, -1.579483503911159}, \
{-0.28164084161830216`, -1.6252297414779642`}, {-0.2318562859512581, \
-1.6833453080385377`}, {-0.1803223282073453, -1.7414608540144276`}, \
{-0.15652712942572958`, -1.767847156507555}, {-0.13237261597077798`, \
-1.7942347993523164`}, {-0.10809578228638558`, -1.8196518089629943`}}]}}, {
                Arrowheads[{{0.0059951255799380754`, 1.}}], {
                 LABColor[
                 0.7064425238100405, 0.3966439034373934, 0.7666910979625198], 
                 
                 
                 ArrowBox[{{-0.10257017316961628`, -1.8254369315968437`}, \
{-0.08465503156615535, -1.8441934684760564`}, {-0.035636456118282936`, \
-1.8941433876665583`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7065133143275399, 0.39648247877552634`, 
                  0.7667305890358406], 
                 
                 ArrowBox[{{-1.8290527429585441`, -0.0008832173044135304}, \
{-1.8290266016105394`, -0.011278306160471216`}, {-1.8282165194401012`, \
-0.07780683401487194}, {-1.8261965151528285`, -0.14433536016148302`}, \
{-1.8229666007632956`, -0.21086388288330493`}, {-1.8185267762715032`, \
-0.277392402180338}, {-1.8148688622366749`, -0.32046621173265516`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7081650204359453, 0.3927160689586344, 0.767652006894269], 
                 
                 ArrowBox[{{-1.8141919228128836`, -0.3284375198446602}, \
{-1.81287704167745, -0.34392091805258235`}, {-1.806095027115737, \
-0.4097568592906455}, {-1.7981280921897744`, -0.4755928101925666}, \
{-1.7869225341233412`, -0.5551481817494246}, {-1.7739868123367453`, \
-0.634703359197661}, {-1.7719890175358204`, -0.6455403817579634}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7129866770351019, 0.3817211742516824, 0.7703418077462872], 
                 
                 
                 ArrowBox[{{-1.7705386640643863`, -0.6534078130292169}, \
{-1.7593209268299874`, -0.7142583425372757}, {-1.7429248776030668`, \
-0.793813131768269}, {-1.724798664655984, -0.8733677268906406}, \
{-1.7049422879887388`, -0.9529221279043906}, {-1.7014570392395405`, \
-0.9657665297924904}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7207300768753879, 0.3640637853093286, 0.7746615271330978], 
                 
                 
                 ArrowBox[{{-1.6993620438243506`, -0.9734873454366004}, \
{-1.6833557476013312`, -1.0324763348095192`}, {-1.6600390434937613`, \
-1.112030347606026}, {-1.634992175666029, -1.1915841662939115`}, \
{-1.6082151441181345`, -1.2711377908731754`}, {-1.6053023824333439`, \
-1.2792662714897227`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7310335294482999, 0.3405686703363838, 0.7804093930251227], 
                 
                 
                 ArrowBox[{{-1.6026036952900682`, -1.2867973462936746`}, \
{-1.5797079488500778`, -1.3506912213438176`}, {-1.5494705898618581`, \
-1.4302444577058382`}, {-1.5175030671534764`, -1.5097974999592372`}, \
{-1.4857982464009487`, -1.584645629255341}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7434777262015596, 0.31219198481327587`, 0.787351490692438], 
                 
                 ArrowBox[{{-1.4826414410974345`, -1.5919962610865066`}, \
{-1.4663077261155995`, -1.6291266993856703`}, {-1.4483775305762259`, \
-1.6689030021401707`}, {-1.4300147941068118`, -1.7086792563675155`}, \
{-1.4112195167073571`, -1.748455462067705}, {-1.3921985834553585`, \
-1.7882512797211914`}, {-1.3727456509170886`, -1.8280489979311465`}, \
{-1.3451605455575322`, -1.8808764440912396`}}]}}, {
                Arrowheads[{{0.007983509370007358, 1.}}], {
                 LABColor[
                 0.7576232795373645, 0.2799356707642922, 0.7952427041441744], 
                 
                 
                 ArrowBox[{{-1.3413920415874505`, -1.8879331367854968`}, \
{-1.3152055189321858`, -1.9366783948072104`}, {-1.2852177841889232`, \
-1.9909790550095632`}, {-1.2801001923525959`, -2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7004086274299504, 0.41040308640852285`, 
                  0.7633250391629373], 
                 
                 ArrowBox[{{-1.7738661105964215`, 
                  0.05537057080274993}, {-1.7730303900943405`, 
                  0.09485341962481685}, {-1.7700410695152746`, 
                  0.1738191173219978}, {-1.7652945871720496`, 
                  0.2527848067865867}, {-1.7628520810529649`, 
                  0.287073162656659}, {-1.7600783917638325`, 
                  0.3213631084466453}, {-1.7543646526304704`, 
                  0.3746583525007305}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7026716319233793, 0.40524272386197346`, 0.764587474860994], 
                 
                 ArrowBox[{{-1.7534753860796486`, 
                  0.3826085551124604}, {-1.7464384594360587`, 
                  0.4394143743489471}, {-1.7382561880532776`, 
                  0.5011324422710525}, {-1.7290002441260597`, 
                  0.5628505987764469}, {-1.718670627654405, 
                  0.6245688438651305}, {-1.7072673386383133`, 
                  0.6862871775371031}, {-1.7047401428994071`, 
                  0.698788180523995}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.708193318787309, 0.39265153981035816`, 0.7676677933626836], 
                 
                 ArrowBox[{{-1.7031549355077509`, 
                  0.7066295526950783}, {-1.6947903770777848`, 
                  0.7480055997923648}, {-1.6812397429728196`, 
                  0.8097241106309155}, {-1.6666154363234174`, 
                  0.8714427100527553}, {-1.6509174571295784`, 
                  0.9331613980578843}, {-1.6341458053913025`, 
                  0.9948801746463023}, {-1.6276100677394365`, 
                  1.0174843203901782`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7167423292349537, 0.37315710510985955`, 
                  0.7724369292629902], 
                 
                 ArrowBox[{{-1.6253879772490554`, 
                  1.025169521353885}, {-1.6163004811085897`, 
                  1.0565990398180094`}, {-1.59738148428144, 
                  1.1183179935730054`}, {-1.5773888149098536`, 
                  1.1800370359112906`}, {-1.5563224729938303`, 
                  1.241756166832865}, {-1.5341824585333703`, 
                  1.3034753863377284`}, {-1.524653558015314, 
                  1.3288103168333105`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7278622690690973, 0.34780014218441224`, 
                  0.7786402792994701], 
                 
                 ArrowBox[{{-1.5218372384017147`, 
                  1.3362981966289573`}, {-1.5109687715284732`, 
                  1.3651946944258806`}, {-1.4866814119791394`, 
                  1.4269140910973221`}, {-1.461320253460663, 
                  1.4886335034662679`}, {-1.4348851695483387`, 
                  1.5503528586469333`}, {-1.4073761602421662`, 
                  1.612072156639318}, {-1.3984001439980551`, 
                  1.6314541030295688`}}]}}, {
                Arrowheads[{{0.019715027844782577`, 1.}}], {
                 LABColor[
                 0.741098436822036, 0.3176175135018614, 0.7860241845127819], 
                 
                 ArrowBox[{{-1.3950382632091725`, 
                  1.6387134251440187`}, {-1.3787932255421456`, 
                  1.6737913974434222`}, {-1.3491363654482769`, 
                  1.7355105810592462`}, {-1.3184055799605598`, 
                  1.7972297074867896`}, {-1.286600869078995, 
                  1.8589487767260524`}, {-1.253722232803582, 
                  1.9206677887770347`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7463363272139664, 0.30567347473396067`, 0.788946184814806], 
                 
                 ArrowBox[{{-1.984691230330263, 
                  0.9573737604527238}, {-1.9747438353722662`, 
                  0.9999465088566476}, {-1.9643636843198873`, 
                  1.0425192099124048`}, {-1.9535507771731264`, 
                  1.0850918636199958`}, {-1.942305113931983, 
                  1.1276644699794203`}, {-1.9306266945964574`, 
                  1.1702370289906783`}, {-1.91851551916655, 
                  1.21280954065377}, {-1.90597158764226, 
                  1.2553820049686955`}, {-1.9025560180898577`, 
                  1.2665874108038957`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7548389225281684, 0.2862848811473027, 0.793689427650579], 
                 
                 ArrowBox[{{-1.9002234573393917`, 
                  1.2742398065297704`}, {-1.8929949000235882`, 
                  1.2979544219354544`}, {-1.8795854563105339`, 
                  1.340526791554047}, {-1.8657432565030978`, 
                  1.3830991138244733`}, {-1.8514683006012793`, 
                  1.4256713887467332`}, {-1.8367605886050786`, 
                  1.4682436163208266`}, {-1.821620120514496, 
                  1.5108157965467537`}, {-1.8060468963295309`, 
                  1.5533879294245145`}, {-1.797125944319961, 
                  1.5771155315662502`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7652813698206854, 0.26247281446378906`, 
                  0.7995148328918983], 
                 
                 ArrowBox[{{-1.7943105660961076`, 
                  1.584603765367131}, {-1.7900409160501838`, 
                  1.5959600149541087`}, {-1.7736021796764545`, 
                  1.6385320531355367`}, {-1.7570141141804125`, 
                  1.680932684383032}, {-1.7399975456186223`, 
                  1.7233351868468278`}, {-1.7156653185344235`, 
                  1.7796882030414283`}, {-1.690570742367095, 
                  1.8360328275173246`}, {-1.6705689284195175`, 
                  1.8796123538356537`}}]}}, {
                Arrowheads[{{0.004271020331101834, 1.}}], {
                 LABColor[
                 0.7772243952027025, 0.2352389574154245, 0.8061773479813894], 
                 
                 
                 ArrowBox[{{-1.6672318493871798`, 
                  1.8868831105728807`}, {-1.6647140632747317`, 
                  1.8923688093419488`}, {-1.638095199204635, 
                  1.9486962321594905`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7704937141778645, 0.2505870286959712, 0.8024225821280021], 
                 
                 
                 ArrowBox[{{-1.8044093723262062`, -1.6538674519507712`}, \
{-1.787792555293258, -1.6965893647311854`}, {-1.770747241478974, \
-1.7393131375325936`}, {-1.746379650157344, -1.7960871832016678`}, \
{-1.721249944944377, -1.8528528854707498`}, {-1.6953583696550016`, \
-1.9096099979057704`}, {-1.6775389198059496`, -1.9475497771336658`}}]}}, {
                Arrowheads[{{0.0007987566621282933, 1.}}], {
                 LABColor[
                 0.7825052290197336, 0.2231969941214549, 0.8091233046268507], 
                 
                 
                 ArrowBox[{{-1.6741379452254237`, -1.9547908662715383`}, \
{-1.6687048430175757`, -1.9663586026514197`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7404911224014946, 0.3190023815385097, 0.7856853891605576], 
                 
                 
                 ArrowBox[{{-1.9884897292122885`, -0.8080114566879912}, \
{-1.9710781357062352`, -0.8926770411900679}, {-1.9519329421763039`, \
-0.977342635983172}, {-1.941710245243109, -1.0196754334355271`}, \
{-1.9310541479853953`, -1.062008225853975}, {-1.9199646504031622`, \
-1.1043410132385152`}, {-1.9158161746919327`, -1.1195816689131135`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7481235190991691, 0.30159811470057313`, 0.789943184529879], 
                 
                 ArrowBox[{{-1.9137150385232906`, -1.1273008156794877`}, \
{-1.90844175249641, -1.146673795589148}, {-1.8964854542651393`, \
-1.1890065729058734`}, {-1.884095755709349, -1.2313393451886914`}, \
{-1.8712726568290396`, -1.273672112437602}, {-1.8580161576242114`, \
-1.3160048746526052`}, {-1.8447746083952783`, -1.3576097901790258`}, \
{-1.8311150560652052`, -1.3992166066153213`}, {-1.819079716700328, \
-1.4329112969631617`}}]}}, {
                Arrowheads[{{0.011033222547488265`, 1.}}], {
                 LABColor[
                 0.7578510567515021, 0.27941626702107997`, 
                  0.7953697715393856], 
                 
                 ArrowBox[{{-1.816388723839424, -1.4404451245044958`}, \
{-1.8126985164154223`, -1.4507763991533773`}, {-1.7936361991393042`, \
-1.5023292205544416`}, {-1.7739283156145444`, -1.5538749047225549`}, \
{-1.7535747953819127`, -1.605413507023037}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.550420563766465, 0.5318644932536546, 0.31318005966925255`], 
                 
                 ArrowBox[{{-0.8553522345888902, -0.00006528063530155229}, \
{-0.85535159889529, 0.001444988826855317}, {-0.8553406901078625, 
                  0.006277851098223859}, {-0.8553161281390417, 
                  0.011110713369592396`}, {-0.8550813484498243, 
                  0.030442162455066573`}, {-0.8546281178586805, 
                  0.04977361154000711}, {-0.8506306864694203, 
                  0.12709940788323615`}, {-0.8431380436428284, 
                  0.2044252001454609}, {-0.832150188165841, 
                  0.281750990563616}, {-0.82535057841176, 
                  0.3180544223697908}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5575641319640581, 0.5323299806772503, 0.3450048341048681], 
                 
                 
                 ArrowBox[{{-0.8238777942182582, 
                  0.32591768547866434`}, {-0.817667115819589, 
                  0.35907678546684374`}, {-0.7996888266040725, 
                  0.43640258485514405`}, {-0.7782153205192914, 
                  0.513728388728517}, {-0.7532467048425413, 
                  0.591054084102154}, {-0.7375750739993804, 
                  0.6336283022471371}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5771208513134105, 0.5336043307852232, 
                  0.43213050642692746`], 
                 
                 ArrowBox[{{-0.7348115439933623, 
                  0.6411358252678035}, {-0.7247830868511175, 
                  0.6683795579912467}, {-0.6928244665450201, 
                  0.7457048103957952}, {-0.6573708439242489, 
                  0.8230298413157989}, {-0.6212321810128011, 
                  0.8949995333181102}, {-0.6012987175622654, 
                  0.9316278148766616}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6055852916219361, 0.5354591236025962, 0.5589402977242357], 
                 
                 
                 ArrowBox[{{-0.5974746442478913, 
                  0.9386546536599475}, {-0.5820653491341256, 
                  0.9669696527792125}, {-0.5502579091254346, 
                  1.021704544769005}, {-0.5166987439728865, 
                  1.0764395505014157`}, {-0.48138785367648174`, 
                  1.1311746699764451`}, {-0.4443252382362201, 
                  1.1859099031940927`}, {-0.4275419004353471, 
                  1.2095774910973638`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6394016341536684, 0.5376626557485943, 0.709592946868469], 
                 
                 ArrowBox[{{-0.422914311261094, 
                  1.2161032415089514`}, {-0.40551089765210147`, 
                  1.2406452501543588`}, {-0.364944831924126, 
                  1.2953807108572437`}, {-0.3226270410522936, 
                  1.3501162853027469`}, {-0.2785575250366043, 
                  1.4048519734908687`}, {-0.23273628387705814`, 
                  1.459587775421609}, {-0.225557866731032, 
                  1.4678470299122202`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6668082000289501, 0.4870226369271571, 0.744580763955284], 
                 
                 ArrowBox[{{-0.2203099122187831, 
                  1.473885156561883}, {-0.18516331757365523`, 
                  1.5143236910949678`}, {-0.1358386261263953, 
                  1.5690597205109449`}, {-0.08476220953527838, 
                  1.6237958636695404`}, {-0.031934067800304715`, 
                  1.6785321205707546`}, {-0.002416563753293775, 
                  1.708134263895598}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.693461292154518, 0.42624519757434787`, 0.7594494109511764], 
                 
                 ArrowBox[{{0.00323218601109983, 1.7137992110356217`}, {
                  0.02264579907852589, 1.733268491214587}, {
                  0.07897739110121331, 1.7880049756010383`}, {
                  0.13706070826775765`, 1.8427415737301078`}, {
                  0.16349529170145194`, 1.867282971353126}, {
                  0.19028067047772007`, 1.8918255215900126`}, {
                  0.23656562227314892`, 1.9327011797518645`}}]}}, {
                Arrowheads[{{0.004215788247729913, 1.}}], {
                 LABColor[
                 0.7201236420852307, 0.36544664751182904`, 
                  0.7743232224899295], 
                 
                 ArrowBox[{{0.24257415228041324`, 1.937982865209577}, {
                  0.2936457289849672, 1.982045875928699}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6070716275462296, 0.5355559758563803, 0.5655619613267658], 
                 
                 
                 ArrowBox[{{0.20083616857985614`, 1.102313338682541}, {
                  0.25055929581652453`, 1.1430430155330302`}, {
                  0.30105044807512404`, 1.1829631627459676`}, {
                  0.35327519939286345`, 1.2228836908133462`}, {
                  0.4072335497697428, 1.2628045997351656`}, {
                  0.4547825645336059, 1.2968888437989259`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6530199209553554, 0.5184642532029329, 0.7368888588937522], 
                 
                 
                 ArrowBox[{{0.46128461915303326`, 1.3015496683746832`}, {
                  0.46292549920576204`, 1.3027258895114262`}, {
                  0.5203510477009211, 1.3426475601421277`}, {
                  0.5795101952552202, 1.3825696116272705`}, {
                  0.6404029418686592, 1.422492043966854}, {0.7030292875412381,
                   1.4624148571608786`}, {0.7281752741970212, 
                  1.4780131941231571`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6865461712600022, 0.4420138498119098, 0.7555917537971742], 
                 
                 
                 ArrowBox[{{0.7349735481063652, 1.4822302395169764`}, {
                  0.7673892322729567, 1.5023380512093445`}, {
                  0.8334827760638155, 1.542261626112251}, {0.9013099189138141,
                   1.582185581869599}, {0.9708706608229525, 
                  1.6221099184813876`}, {1.0107704181998236`, 
                  1.6444537191057804`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7184004592616344, 0.3693760467373117, 0.7733619307571454], 
                 
                 
                 ArrowBox[{{1.017750471063644, 1.6483625375996827`}, {
                  1.042165001791231, 1.6620346359476175`}, {
                  1.1151929418186493`, 1.7019597342682882`}, {
                  1.1899544809052074`, 1.7418852134434}, {1.2664496190509056`,
                   1.7818110734729529`}, {1.299992382991573, 
                  1.7991223007482602`}}]}}, {
                Arrowheads[{{0.016484410787637745`, 1.}}], {
                 LABColor[
                 0.7486916449397325, 0.30030260896124145`, 
                  0.7902601182099482], 
                 
                 ArrowBox[{{1.307107377939406, 1.8027796983311757`}, {
                  1.3429419325003134`, 1.821073893384069}, {
                  1.3922346748698966`, 1.8454695267611214`}, {
                  1.4421814354050042`, 1.8698619562116037`}, {
                  1.4927823786400525`, 1.8942509623099206`}, {
                  1.5440374497302358`, 1.918636618197937}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3760680308269489, 
                  0.5222614810027665, -0.40933376322690584`], 
                 
                 ArrowBox[{{-0.2552366835916906, 
                  0.00338752535573847}, {-0.25353680359272607`, 
                  0.04179759167321549}, {-0.24894692330958298`, 
                  0.0802076580593257}, {-0.24146703364212177`, 
                  0.11861771796068757`}, {-0.21783745170583194`, 
                  0.19543806583084214`}, {-0.1826483018080612, 
                  0.27225889608260867`}, {-0.16337711937054808`, 
                  0.3060132461642207}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.40960431616396387`, 
                  0.522688659764868, -0.3141598344650735], 
                 
                 ArrowBox[{{-0.15928686824996668`, 
                  0.3128854513835205}, {-0.13589927212893502`, 
                  0.3490798162495905}, {-0.1081896854389107, 
                  0.38749016287638843`}, {-0.07759005084857862, 
                  0.4259004338653915}, {-0.04410036835793903, 
                  0.46431062921659927`}, {-0.0077206379669919195`, 
                  0.5027207489300117}, {0.031549140324262634`, 
                  0.5411307930056289}, {0.04754640981549089, 
                  0.5557052035702623}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4766682276908944, 
                  0.5270586617763894, -0.01538843646347555], 
                 
                 ArrowBox[{{0.05346014235675896, 0.5610929459017354}, {
                  0.07370896651582498, 0.5795407614434511}, {
                  0.11875884060769472`, 0.6179506542434781}, {
                  0.16669876259987199`, 0.6563604714057097}, {
                  0.21752873249235682`, 0.6947702129301462}, {
                  0.27124875028514916`, 0.7331798788167874}, {
                  0.3061925439591629, 0.7568890333695383}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5429634067644564, 0.5313785718339664, 0.2799582392910478], 
                 
                 
                 ArrowBox[{{0.31281258828642067`, 0.7613806937646641}, {
                  0.32785881597824906`, 0.7715894690656334}, {
                  0.3873589295716565, 0.8099989836766842}, {
                  0.44974909106537175`, 0.8484084226499399}, {
                  0.5150293004593943, 0.8868177859854003}, {0.578398684994019,
                   0.9225745145074501}, {0.5865092751441058, 
                  0.9269770348890318}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6037340454379675, 0.5353384931567488, 0.5506929498163032], 
                 
                 
                 ArrowBox[{{0.5935402375947418, 0.9307935211025201}, {
                  0.6442724862613339, 0.9583315614454601}, {
                  0.7009207449665918, 0.9880388229352469}, {
                  0.7592985285120153, 1.0177464697963767`}, {
                  0.8194058368976038, 1.047454502028849}, {0.8786802364599826,
                   1.075931843502428}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6549992384492161, 0.513950786308498, 0.7379930374622411], 
                 
                 ArrowBox[{{0.8859147671911164, 1.0793465025134534`}, {
                  0.9448090281892766, 1.106871722607822}, {1.010104911095361, 
                  1.1365809109543223`}, {1.0771303188416104`, 
                  1.1662904846721653`}, {1.1458852514280249`, 
                  1.196000443761351}, {1.1781738200012106`, 
                  1.2096106002337337`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.691372415404624, 0.43100849405732483`, 0.7582841138492199], 
                 
                 ArrowBox[{{1.1855456800790765`, 1.2127179590788573`}, {
                  1.2163697088546048`, 1.2257107882218796`}, {
                  1.28858369112135, 1.255421518053751}, {1.3625271982282605`, 
                  1.2851326332569648`}, {1.438200230175336, 
                  1.3148441338315213`}, {1.48252316800279, 
                  1.331858017198919}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7251825330504401, 0.35391078377857216`, 
                  0.7771453664872576], 
                 
                 ArrowBox[{{1.4899918169616844`, 1.334724946345027}, {
                  1.515602786962577, 1.3445560197774207`}, {
                  1.5947348685899831`, 1.3742682910946626`}, {
                  1.6349494812187482`, 1.389124571267537}, {
                  1.6755964750575545`, 1.4039809477832472`}, {
                  1.7166758501064021`, 1.418837420641793}, {1.758187606365291,
                   1.4336939898431746`}, {1.7903303641629094`, 
                  1.4451379426324933`}}]}}, {
                Arrowheads[{{0.01334708818172612, 1.}}], {
                 LABColor[
                 0.7568635550424558, 0.28166808174297425`, 
                  0.7948188855764934], 
                 
                 ArrowBox[{{1.797866939992936, 1.447821228818918}, {
                  1.8000145796842988`, 1.448585864118452}, {
                  1.8422740262156252`, 1.4634784387839783`}, {
                  1.902490462811925, 1.484041534614406}, {1.963545451418612, 
                  1.50460135423914}, {2., 1.5167086874081277`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.37706436582423203`, 
                  0.522259701958023, -0.40695257690218806`], 
                 
                 ArrowBox[{{-0.2440373180202217, -0.08359515121442171}, \
{-0.23627346258437384`, -0.12158526863535868`}, {-0.2121208840070653, \
-0.19756572798294844`}, {-0.17646865923056643`, -0.27354666135851813`}, \
{-0.15433009808614176`, -0.3115372089260972}, {-0.1293164625289615, \
-0.3495276812392753}, {-0.11268081148825759`, -0.3721890015028835}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.42446096153512186`, 
                  0.523656744815057, -0.24797310890594187`], 
                 
                 ArrowBox[{{-0.10794669211384827`, -0.3786378861931879}, \
{-0.10142775255902586`, -0.387518078298052}, {-0.07066396817633473, \
-0.4255084001024276}, {-0.037025109380888224`, -0.4634986466524018}, \
{-0.0005111761726862493, -0.5014888179479748}, {
                  0.03887783144827111, -0.5394789139891465}, {
                  0.08114191348198396, -0.577468934775917}, {
                  0.11565627962800336`, -0.6065168610819062}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4931578880335832, 0.5281331569441506, 0.05807341151087451], 
                 
                 ArrowBox[{{0.12177703715568312`, -0.611668203362065}, {
                  0.12628106992845228`, -0.6154588803082863}, {
                  0.17429530078767577`, -0.6534487505862541}, {
                  0.22518460605965476`, -0.6914385456098207}, {
                  0.2789489857443893, -0.7294282653789861}, {
                  0.3355884398418792, -0.7674179098937501}, {
                  0.3822436450823841, -0.797199060735523}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5584806188697636, 0.5323897005702639, 0.3490878061211644], 
                 
                 
                 ArrowBox[{{0.3889869419610763, -0.8015034709396998}, {
                  0.39510296835212466`, -0.8054074791541131}, {
                  0.4574925712751255, -0.8433969731600747}, {
                  0.5227572486108816, -0.8813863919116349}, {
                  0.5864765397979219, -0.9169590388962748}, {
                  0.6527164973963805, -0.9525320068578046}, {
                  0.6669351150941176, -0.9599092021063309}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6180215576518043, 0.5362694924929422, 0.6143441729689937], 
                 
                 
                 ArrowBox[{{0.674036216664542, -0.9635935414618348}, {
                  0.7094935489857042, -0.981990242820978}, {
                  0.7680000496500922, -1.0114488628950733`}, {
                  0.8282359993895445, -1.0409078670800904`}, {
                  0.8902013982040611, -1.0703672553760297`}, {
                  0.953896246093642, -1.099827027782891}, {
                  0.9618352589375857, -1.1034019161933184`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6644016785056842, 0.4925102634750431, 0.7432382660999177], 
                 
                 
                 ArrowBox[{{0.969129828701765, -1.106686615868406}, {
                  1.0193205430582875`, -1.1292871843006742`}, {
                  1.0864742890979973`, -1.1587477249293794`}, {
                  1.155357484212771, -1.188208649669006}, {
                  1.2259701284026092`, -1.217669958519555}, {
                  1.2631942420206397`, -1.2328296719959329`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7001425733203331, 0.4110097735214346, 0.7631766186862785], 
                 
                 
                 ArrowBox[{{1.27060337490104, -1.2358470798173207`}, {
                  1.298312221667512, -1.247131651481026}, {
                  1.372383764007479, -1.276593728553419}, {
                  1.4481847554225102`, -1.3060561897367338`}, {
                  1.5257151959126058`, -1.3355190350309705`}, {
                  1.5689265159852515`, -1.3515819521405563`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7334138930587754, 0.3351406920631041, 0.7817372984733643], 
                 
                 
                 ArrowBox[{{1.576425181659818, -1.3543694264635013`}, {
                  1.604975085477766, -1.3649822644361291`}, {
                  1.645253573663495, -1.3797140231803044`}, {
                  1.6859644241179903`, -1.39444587795221}, {
                  1.7271076368412515`, -1.409177828751846}, {
                  1.768683211833279, -1.4239098755792126`}, {
                  1.8105887615818614`, -1.4386820840358927`}, {
                  1.8529270666449102`, -1.453454987088639}, {
                  1.8778174925764877`, -1.4618706406130617`}}]}}, {
                Arrowheads[{{0.007550705746694919, 1.}}], {
                 LABColor[
                 0.7646302672193264, 0.26395753333543515`, 
                  0.7991516099423017], 
                 
                 ArrowBox[{{1.885396033458017, -1.4644330063377362`}, {
                  1.913388170934324, -1.4738973735227807`}, {
                  1.9746920757326325`, -1.4943364905923278`}, {
                  2., -1.502658400635167}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.40198917958927466`, 
                  0.5222151964864389, -0.34738363086967716`], 
                 
                 ArrowBox[{{0.29333942734626645`, -0.15137344058673452`}, {
                  0.3595133624404278, -0.16666522736141437`}, {
                  0.43205192762538214`, -0.18195708812144987`}, {
                  0.5109551229011294, -0.1972490228668411}, {
                  0.5962229482676696, -0.21254103159758803`}, {
                  0.6070209772542022, -0.21435734692893973`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5004955003087795, 0.5286112886199253, 0.09076265715044281], 
                 
                 ArrowBox[{{0.6149101478530189, -0.21568436888157125`}, {
                  0.6665547567892426, -0.22437140751700363`}, {
                  0.740694211333978, -0.236202233228027}, {
                  0.7927677399006803, -0.24416231583790401`}, {
                  0.8465672836031313, -0.25212266414213536`}, {
                  0.9020928424413309, -0.26008327814072113`}, {
                  0.9312081192317444, -0.26413178195758746`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5770856442900254, 0.5336020366338755, 0.4319736582599068], 
                 
                 
                 ArrowBox[{{0.9391318824547703, -0.2652335879230017}, {
                  0.9593444164152792, -0.26804415783366126`}, {
                  1.018322005524976, -0.2760053032209558}, {
                  1.0790256097704216`, -0.2839667143026047}, {
                  1.1414552291516158`, -0.29192839107860796`}, {
                  1.2056108636685585`, -0.29989033354896555`}, {
                  1.2565144613408292`, -0.3060423507363921}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6418894654293361, 0.5378247671946979, 0.7206762972323214], 
                 
                 
                 ArrowBox[{{1.2644566687560075`, -0.3070022160260492}, {
                  1.2714925133212498`, -0.3078525417136776}, {
                  1.33910017810969, -0.315815015572744}, {
                  1.4084338580338787`, -0.3237777551261648}, {
                  1.4794935530938158`, -0.33174076037393996`}, {
                  1.5522792632895017`, -0.33970403131606947`}, {
                  1.5824316272744559`, -0.34292660406153613`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6833075397156627, 0.44939894912214556`, 
                  0.7537850565120833], 
                 
                 ArrowBox[{{1.5903863248447874`, -0.34377677261221334`}, {
                  1.6267909886209364`, -0.34766756795255344`}, {
                  1.7030287290881194`, -0.3556313702833917}, {
                  1.7809924846910512`, -0.3635954383085844}, {
                  1.8210804746554081`, -0.36764569727905455`}, {
                  1.8616125878831928`, -0.3716961998090118}, {
                  1.9087341652764847`, -0.3762374800642579}}]}}, {
                Arrowheads[{{0.00522976373579083, 1.}}], {
                 LABColor[
                 0.7201492929827003, 0.36538815539174213`, 
                  0.7743375320543809], 
                 
                 ArrowBox[{{1.916697270532276, -0.3770049138954038}, {
                  1.9258723889160236`, -0.3778891539030736}, {
                  1.991192875249228, -0.38408061411380495`}, {
                  2., -0.3849018363319336}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.717165534960785, 0.3721920628470596, 0.7726730180632833], 
                 
                 ArrowBox[{{1.0959772844083, -1.5835334784555564`}, {
                  1.1691726655085326`, -1.6214347903595963`}, {
                  1.244099353526589, -1.6593364268412942`}, {
                  1.3207573484624686`, -1.6972383879006505`}, {
                  1.3597355860245923`, -1.7161894901469505`}, {
                  1.382040026130297, -1.7269147913401164`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7479095660853157, 0.30208599491584265`, 
                  0.7898238290786725], 
                 
                 ArrowBox[{{1.3892497914483197`, -1.7303816752520804`}, {
                  1.3991466503161718`, -1.7351406735376649`}, {
                  1.4389905413372073`, -1.7540919380727937`}, {
                  1.4792672590876985`, -1.7730432837523373`}, {
                  1.5199768035676458`, -1.7919947105762954`}, {
                  1.5611191747770488`, -1.8109462185446679`}, {
                  1.6026943727159078`, -1.829897807657455}, {
                  1.6447023973842225`, -1.8488494779146567`}, {
                  1.6797414048081807`, -1.8645761321315515`}}]}}, {
                Arrowheads[{{0.018778937143872302`, 1.}}], {
                 LABColor[
                 0.777124145638712, 0.23546755797579724`, 0.8061214229363162], 
                 
                 ArrowBox[{{1.6870405640493809`, -1.8678506141213473`}, {
                  1.729083200268939, -1.8865319567439478`}, {
                  1.7865499197932082`, -1.9113153359562878`}, {
                  1.8447648486012311`, -1.9360954322302595`}, {
                  1.9037282025709517`, -1.9608720134212763`}, {
                  1.9634399097430555`, -1.985645156910867}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.013450703064809104`, 1.}}], {
                 LABColor[
                 0.7883079206358937, 0.20996503078591727`, 0.812360383944336], 
                 
                 ArrowBox[{{-1.9240090475594251`, 
                  1.8017728348040638`}, {-1.906491046123079, 
                  1.8461076820552933`}, {-1.8885427203128602`, 
                  1.8904443295532356`}, {-1.8626182457097338`, 
                  1.9501321976761083`}, {-1.8402996187484812`, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7220102544106631, 0.3611445775812172, 0.7753756847165558], 
                 
                 
                 ArrowBox[{{-1.9706395462085673`, -0.000502144849335373}, \
{-1.9706379168161805`, 0.00249959646179309}, {-1.970618587150619, 
                  0.01259424992831623}, {-1.9705734024087007`, 
                  0.02268890339483937}, {-1.9705023625904254`, 
                  0.03278355686136251}, {-1.9704850520176076`, 
                  0.03480248755466713}, {-1.970470926601828, 
                  0.036367158842019624`}, {-1.9688340999665088`, 
                  0.11926845607563899`}, {-1.9654535220713, 
                  0.20216976764099126`}, {-1.960329192916203, 
                  0.28507109353807664`}, {-1.957506924126091, 
                  0.3191373611192953}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7234895253180796, 0.3577713742981492, 0.7762009081776855], 
                 
                 
                 ArrowBox[{{-1.956846415488625, 
                  0.3271100475134684}, {-1.9534611125012167`, 
                  0.36797243376689504`}, {-1.9448492852020682`, 
                  0.4508737714007617}, {-1.9344937153944832`, 
                  0.5337750895129917}, {-1.9223944030784623`, 
                  0.6166763881035855}, {-1.9177292180582368`, 
                  0.644614571559072}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7277966817386728, 0.3479497019419972, 0.7786036908669202], 
                 
                 
                 ArrowBox[{{-1.9164116021582087`, 
                  0.6525053185668016}, {-1.9085513482540053`, 
                  0.6995776671725425}, {-1.9016844524006462`, 
                  0.7382645337872004}, {-1.894438150144869, 
                  0.7769532006414515}, {-1.8773063740774745`, 
                  0.855830557810155}, {-1.8585924376137537`, 
                  0.9346928323626357}, {-1.8510697921350434`, 
                  0.9656460687619348}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7346263329839572, 0.3323759474070431, 0.7824136680730461], 
                 
                 
                 ArrowBox[{{-1.8491805255570104`, 
                  0.9734197854918606}, {-1.8476118791359453`, 
                  0.9798742546856506}, {-1.8361132071755026`, 
                  1.0250557040618058`}, {-1.8240964217324256`, 
                  1.0702371804911015`}, {-1.8115615228067143`, 
                  1.1154186839735376`}, {-1.7985085103983687`, 
                  1.160600214509114}, {-1.7849373845073886`, 
                  1.205781772097831}, {-1.7708481451337743`, 
                  1.250963356739688}, {-1.761138480757799, 
                  1.2809960594368377`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7439695536790397, 0.31107046335738747`, 0.787625860702157], 
                 
                 ArrowBox[{{-1.7586774783394732`, 
                  1.2886081200709232`}, {-1.7562407922775258`, 
                  1.2961449684346857`}, {-1.7411153259386427`, 
                  1.3413266071828238`}, {-1.7254717461171256`, 
                  1.3865082729841023`}, {-1.709310052812974, 
                  1.4316899658385214`}, {-1.692630246026188, 
                  1.4768716857460802`}, {-1.6754323257567676`, 
                  1.5220534327067796`}, {-1.657716292004713, 
                  1.5672352067206197`}, {-1.6488852306452102`, 
                  1.5891174067719762`}}]}}, {
                Arrowheads[{{0.004127764478377136, 1.}}], {
                 LABColor[
                 0.7553469200790702, 0.28512648683433306`, 
                  0.7939728182689566], 
                 
                 ArrowBox[{{-1.6458912697061243`, 
                  1.5965360453192587`}, {-1.639482144770024, 
                  1.6124170077876}, {-1.620729884052701, 
                  1.6575988359077207`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.661880423702323, 0.4982595180149047, 0.7418317633391398], 
                 ArrowBox[{{0.32806165541858917`, -1.4131859146700918`}, {
                  0.38450322148426974`, -1.4573343833936165`}, {
                  0.4426813440205559, -1.5014832040610204`}, {
                  0.5025960230274479, -1.545632376672304}, {
                  0.5642472585049454, -1.5897819012274663`}, {
                  0.5848084082559085, -1.6041028326605495`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6934640668814613, 0.4262388703235462, 0.7594509588554583], 
                 
                 
                 ArrowBox[{{0.5913730261010323, -1.6086751179258718`}, {
                  0.6276350504530486, -1.633931777726508}, {
                  0.6927593988717574, -1.678082006169429}, {
                  0.7596203037610718, -1.7222325865562291`}, {
                  0.828217765120992, -1.7663835188869086`}, {
                  0.8582249179639073, -1.7852201270646186`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7238221646842367, 0.35701285184200343`, 0.776386473788198], 
                 
                 ArrowBox[{{0.8650005556709877, -1.7894734473749634`}, {
                  0.8985517829515177, -1.8105348031614672`}, {
                  0.9706223572526491, -1.854686439379905}, {
                  1.0059755156668604`, -1.8760866390863813`}, {
                  1.0417348820081131`, -1.897487864373197}, {
                  1.084711020772548, -1.922419879591592}, {
                  1.1282461777151982`, -1.9473489448913666`}, {
                  1.1395759393840985`, -1.9537535144592024`}}]}}, {
                Arrowheads[{{0.005048432167331477, 1.}}], {
                 LABColor[
                 0.7529104760766941, 0.2906823460529665, 0.7926136279121335], 
                 
                 
                 ArrowBox[{{1.1465402337421984`, -1.9576903411119442`}, {
                  1.1723404554806587`, -1.972274876940543}, {
                  1.2169938198540649`, -1.9971977368497804`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6820546493822105, 0.4522559334412022, 0.7530861213189392], 
                 
                 
                 ArrowBox[{{-1.6115179318052022`, 
                  0.12465271347178185`}, {-1.6079667092879835`, 
                  0.19612221381827907`}, {-1.602833067098634, 
                  0.26759170830232654`}, {-1.5961170293677471`, 
                  0.3390611909715776}, {-1.5878185960953228`, 
                  0.410530661826032}, {-1.5832917572258525`, 
                  0.44327393987003516`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6855172788503688, 0.44436004835924703`, 
                  0.7550177776910054], 
                 
                 ArrowBox[{{-1.582196158450811, 
                  0.45119856373013906`}, {-1.5779377672813615`, 
                  0.4820001208656895}, {-1.5663519296256285`, 
                  0.5541840603379448}, {-1.553151757321512, 
                  0.6263680305329052}, {-1.5377858182213051`, 
                  0.7011132567351019}, {-1.5230452099255065`, 
                  0.7655572335501672}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.692619279775897, 0.4281652508287644, 0.7589796874097235], 
                 
                 ArrowBox[{{-1.5212613974896407`, 
                  0.773355824012145}, {-1.5206889926692253`, 
                  0.7758583016735452}, {-1.5018612806652722`, 
                  0.8506031653482357}, {-1.4813026822094464`, 
                  0.9253478477591732}, {-1.4590131973017468`, 
                  1.0000923489063576`}, {-1.4349928259421745`, 
                  1.0748366687897888`}, {-1.4329321043088317`, 
                  1.080818002383159}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7029842453142547, 0.4045298669328302, 0.7647618688162325], 
                 
                 
                 ArrowBox[{{-1.4303262213629064`, 
                  1.0883816902450514`}, {-1.4092415681307287`, 
                  1.1495808074094669`}, {-1.3817594238674098`, 
                  1.224324764765392}, {-1.352546393152218, 
                  1.2990685408575644`}, {-1.321602475985153, 
                  1.3738121356859836`}, {-1.3157988988520781`, 
                  1.3870877829054955`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7160199008116955, 0.37480446930589556`, 
                  0.7720339166161042], 
                 
                 ArrowBox[{{-1.3125944424014282`, 
                  1.3944179574502038`}, {-1.2889276723662146`, 
                  1.4485555492506494`}, {-1.2545219822954032`, 
                  1.5232987815515626`}, {-1.2183854057727188`, 
                  1.5980418325887225`}, {-1.1805179427981611`, 
                  1.6727847023621294`}, {-1.1749819890753659`, 
                  1.6832339274106505`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7311527411886287, 0.34029683004543965`, 
                  0.7804758962764664], 
                 
                 ArrowBox[{{-1.1712367679519382`, 
                  1.6903031083205318`}, {-1.1409195933717304`, 
                  1.7475273908717832`}, {-1.0995903574934265`, 
                  1.8222698981176841`}, {-1.0785511780938588`, 
                  1.8595380832368276`}, {-1.0570827885548222`, 
                  1.8968081333539857`}, {-1.0265958995468458`, 
                  1.9467036288395863`}, {-1.0130267237892356`, 
                  1.9683557015133595`}}]}}, {
                Arrowheads[{{0.0018358444611177584`, 1.}}], {
                 LABColor[
                 0.7478034754858532, 0.3023279148756113, 0.789764645563846], 
                 
                 ArrowBox[{{-1.0087784885925795`, 
                  1.9751345286769544`}, {-0.9953320597744773, 
                  1.9965907364211115`}, {-0.9931420350499078, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6596851254688536, 0.5032654889775767, 0.7406070981359287], 
                 
                 
                 ArrowBox[{{-1.4327872015790313`, -0.037887049917545025`}, \
{-1.4309186218382486`, -0.11021074720440331`}, {-1.4272249967865005`, \
-0.18253444448873352`}, {-1.421706326033896, -0.2548581419074883}, \
{-1.4143626466436885`, -0.327181827438029}, {-1.4105890775110765`, \
-0.35694829464826694`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.662596537678997, 0.49662655274461076`, 0.742231253419984], 
                 
                 
                 ArrowBox[{{-1.4095829502436008`, -0.3648847742155336}, \
{-1.4051939960748658`, -0.39950548891818405`}, {-1.3942003743274283`, \
-0.47182912634795365`}, {-1.3813817814013758`, -0.5441527397273382}, \
{-1.366246911967798, -0.6187561186331422}, {-1.3523293264011267`, \
-0.679557426285573}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6699138576806859, 0.47994075994681645`, 
                  0.7463132806590196], 
                 
                 ArrowBox[{{-1.3505442727335595`, -0.687355732730174}, \
{-1.349169980499509, -0.6933595589345518}, {-1.3312612193731466`, \
-0.7638270770651064}, {-1.3116197838775905`, -0.8342944290056924}, \
{-1.29024567401284, -0.9047616147563096}, {-1.267138889778896, \
-0.9752286343169579}, {-1.26042889125284, -0.9942641732877359}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6811031378734702, 0.45442567917815124`, 
                  0.7525553127857553], 
                 
                 ArrowBox[{{-1.2577693006748136`, -1.0018091436625798`}, \
{-1.2422994311757583`, -1.0456954876876376`}, {-1.2157272982034262`, \
-1.1161621748683486`}, {-1.1874224908619004`, -1.1866286958590906`}, \
{-1.1573850091511806`, -1.257095050659864}, {-1.1386359269569684`, \
-1.2986805045951102`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6953987880067196, 0.42182709718664313`, 
                  0.7605302589723617], 
                 
                 ArrowBox[{{-1.1353478143356892`, -1.305973536570207}, \
{-1.1256148530712669`, -1.3275612392706686`}, {-1.0921120226221595`, \
-1.3980272616915044`}, {-1.056876517803858, -1.4684931179223717`}, \
{-1.0199083386163625`, -1.53895880796327}, {-0.9910556343810791, \
-1.5914930735312647`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7120375071665662, 0.383885580311912, 0.7698123055163807], 
                 
                 ArrowBox[{{-0.9872045011507262, -1.5985051183715429`}, \
{-0.9812074850596734, -1.6094243318141996`}, {-0.9407739571337902, \
-1.6798896894751605`}, {-0.8986077548387131, -1.7503548809461527`}, \
{-0.8547088781744422, -1.820819906227176}, {-0.8325782930296568, \
-1.8556556697295086`}, {-0.8217687829322643, -1.8723532380430934`}}]}}, {
                Arrowheads[{{0.00918714034125957, 1.}}], {
                 LABColor[
                 0.7303706031844944, 0.34208035088001487`, 
                  0.7800395741480335], 
                 
                 ArrowBox[{{-0.8174212982986446, -1.8790688450417525`}, \
{-0.810025479990577, -1.89049324636255}, {-0.7796319340022249, \
-1.934988292931029}, {-0.7485423512560819, -1.9794762872877003`}, \
{-0.7338762744024728, -2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6614654161261366, 0.499205865916071, 0.7416002479441581], 
                 
                 ArrowBox[{{-0.01674793842820449, -1.4473560167308035`}, {
                  0.03406988515218881, -1.4978845773211225`}, {
                  0.08663190289256799, -1.5484133694425208`}, {
                  0.14093811479293306`, -1.5989423930949984`}, {
                  0.196988520853284, -1.6494716482785552`}, {
                  0.2164001566305482, -1.666443129842182}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.69029193285915, 0.43347233435284976`, 0.7576813577608011], 
                 
                 
                 ArrowBox[{{0.22242287616323442`, -1.6717087589053234`}, {
                  0.25478312107362083`, -1.7000011349931914`}, {
                  0.3143219154539436, -1.7505308532389066`}, {
                  0.3756049039942522, -1.8010608030157014`}, {
                  0.43863208669454673`, -1.8515909843235752`}, {
                  0.4684403997687752, -1.875162813616129}, {
                  0.46900211016173626`, -1.8756014625254702`}}]}}, {
                Arrowheads[{{0.011913059830497601`, 1.}}], {
                 LABColor[
                 0.7186688775996608, 0.3687639684394645, 0.7735116701380974], 
                 
                 
                 ArrowBox[{{0.47530732519455976`, -1.880525308927406}, {
                  0.4986267089442953, -1.898735800270487}, {
                  0.5624670946807165, -1.9467429299656067`}, {
                  0.6278941804026585, -1.994740725888183}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6587433641693107, 0.5054130011685877, 0.7400817288372625], 
                 
                 
                 ArrowBox[{{1.425594443583313, 0.025533239307936263`}, {
                  1.49661479454076, 0.026161326247149428`}, {
                  1.5693604679394937`, 0.026789435607052412`}, {
                  1.6438314637795144`, 0.027417567387645222`}, {
                  1.7200277820608216`, 0.02804572158892785}, {
                  1.7455828861722709`, 0.028251737771672697`}}]}}, {
                Arrowheads[{{0.015401550240266439`, 1.}}], {
                 LABColor[
                 0.6980091866636395, 0.41587456660181815`, 
                  0.7619864913661656], 
                 
                 ArrowBox[{{1.7535826262244472`, 0.02831622883777491}, {
                  1.7979494227834159`, 0.028673898210900297`}, {
                  1.8381354433209103`, 0.028994322058142067`}, {
                  1.8787680515689675`, 0.029314765487641566`}, {
                  1.9448036563862794`, 0.02981662075784821}, {2., 
                  0.03022899984399812}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4895713862341105, 0.5278994542011824, 0.04209545656958832], 
                 
                 ArrowBox[{{-0.6022333533353975, 
                  0.09955772194095422}, {-0.5957519864912723, 
                  0.1600964535850861}, {-0.5862483428175373, 
                  0.22063517857686527`}, {-0.5737224215726271, 
                  0.28117390037397777`}, {-0.5581742194787258, 
                  0.34171262910817446`}, {-0.5396037365358335, 
                  0.4022513647794551}, {-0.5361812106271071, 
                  0.4118469597230134}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5077104574115315, 0.5290814278696976, 
                  0.12290547093852817`], 
                 
                 ArrowBox[{{-0.5334936343175513, 
                  0.41938200674213105`}, {-0.51801097274395, 
                  0.4627901073878198}, {-0.49339603074961835`, 
                  0.5233287073489108}, {-0.46575901319938134`, 
                  0.5838670150783704}, {-0.435099920093239, 
                  0.6444050305761984}, {-0.4014187514311913, 
                  0.7049427538423949}, {-0.3988909352705937, 
                  0.7091147417255347}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5417205094123253, 0.5312975824641957, 0.2744211005973173], 
                 
                 
                 ArrowBox[{{-0.39474531481020547`, 
                  0.7159568050837922}, {-0.36531004761241487`, 
                  0.7645377026982497}, {-0.3262721504114351, 
                  0.824133222769211}, {-0.29417410337371586`, 
                  0.8700921376215229}, {-0.2603334257054889, 
                  0.9160513504596876}, {-0.22475011740675419`, 
                  0.9620108612837048}, {-0.21170171506194513`, 
                  0.9780774920033906}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5835244562901277, 0.5340216009084847, 0.4606587262635458], 
                 
                 
                 ArrowBox[{{-0.20665830941903401`, 
                  0.9842874887442151}, {-0.1874241784775118, 
                  1.0079706700935747`}, {-0.1483556089177615, 
                  1.0539307768892971`}, {-0.10754440872750354`, 
                  1.0998911816708725`}, {-0.06499057790673778, 
                  1.1458518844383003`}, {-0.020694116455464123`, 
                  1.191812885191581}, {0.008488730438386233, 
                  1.220946421138903}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6278721507652021, 0.5369113744043923, 0.6582288109005723], 
                 
                 
                 ArrowBox[{{0.014150365965276348`, 1.2265984900663538`}, {
                  0.025344975626317184`, 1.2377741839307141`}, {
                  0.07312669833860623, 1.2837357806557}, {0.122651051681403, 
                  1.3296976753665386`}, {0.17391803565470756`, 
                  1.3756598680632297`}, {0.22692765025851988`, 
                  1.4216223587457735`}, {0.2509021194375219, 
                  1.4417481719539}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.664231020582562, 0.4928994172559168, 0.743143063171717], 
                 
                 ArrowBox[{{0.2570293617406352, 1.4468917992497816`}, {
                  0.28167989549283995`, 1.4675851474141701`}, {
                  0.3381747713576678, 1.5135482340684192`}, {
                  0.3964122778530034, 1.559511618708521}, {0.4242311022558888,
                   1.5811437783744786`}, {0.45243414353976347`, 
                  1.6027772132704796`}, {0.5088280946293372, 
                  1.6442633701803555`}}]}}, {
                Arrowheads[{{0.004760553396924093, 1.}}], {
                 LABColor[
                 0.6950403056479999, 0.42264454980015215`, 
                  0.7603302766355675], 
                 
                 ArrowBox[{{0.5152845887920973, 1.6489869193408413`}, {
                  0.5772261989021167, 1.6933144650668288`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6895266631175551, 0.43521739023939404`, 
                  0.7572544457315773], 
                 
                 ArrowBox[{{0.38490533615781086`, 1.63523391610241}, {
                  0.44571823743415906`, 1.68270518531675}, {
                  0.5082716936669713, 1.7301767576596658`}, {
                  0.5725657048562476, 1.7776486331311574`}, {
                  0.638600271001988, 1.8251208117312243`}, {
                  0.6411100921591052, 1.8269016552721464`}}]}}, {
                Arrowheads[{{0.01519641380476566, 1.}}], {
                 LABColor[
                 0.7189931221481108, 0.3680245888100372, 0.7736925526304], 
                 
                 ArrowBox[{{0.6476345417385414, 1.8315310783123746`}, {
                  0.6703954500450321, 1.8476810802470502`}, {
                  0.7025820400553326, 1.8702424769173935`}, {
                  0.7384918304604775, 1.8946274158821308`}, {
                  0.7748648128796296, 1.9190097435613762`}, {
                  0.8117010437042996, 1.9433893136751448`}, {
                  0.8490005041373176, 1.967766174983432}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.555679530735562, 0.5322071767582434, 0.3366088886419021], 
                 
                 ArrowBox[{{-0.8784147696633609, -0.008642459532015668}, \
{-0.8782207983315683, -0.027500140580888854`}, {-0.875420792157752, \
-0.10293086477893364`}, {-0.8693821955619084, -0.17836158565832194`}, \
{-0.860105007295041, -0.2537923050666682}, {-0.8479942622537693, \
-0.3267819193742712}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5628392218108602, 0.5326737147768073, 0.3685054908996966], 
                 
                 
                 ArrowBox[{{-0.8464595461977638, -0.33463183229261256`}, \
{-0.831834843193308, -0.40465375499359607`}, {-0.8128418673584427, \
-0.48008448551217753`}, {-0.7906104057026017, -0.5555151168169545}, \
{-0.7651405682608088, -0.6309455459907111}, {-0.7607195485394812, \
-0.6425616824146202}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5820504674207999, 0.5339255532104418, 
                  0.45409206909874517`], 
                 
                 ArrowBox[{{-0.757873932818662, -0.650038477929373}, \
{-0.736432355033064, -0.7063757730334472}, {-0.7044857660193674, \
-0.7818057979451627}, {-0.6704042948932217, -0.8549708684122374}, \
{-0.6332754441214972, -0.9281363526901178}, {-0.6260871587713049, \
-0.9413512273219069}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6098714662264243, 0.535738418251788, 0.5780353124572741], 
                 
                 ArrowBox[{{-0.6222644709118034, -0.9483788199060583}, \
{-0.6030828707757069, -0.9836420890567249}, {-0.5711362534235952, \
-1.0391479080489874`}, {-0.5374355920651622, -1.0946538096669054`}, \
{-0.501980886700408, -1.150159793910479}, {-0.4647721373293323, \
-1.2056658607797086`}, {-0.454320184393498, -1.2205556469547028`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.6426745351634775, 0.5359574594510208, 0.7209861452959874], 
                 
                 
                 ArrowBox[{{-0.44972390033057097`, -1.2271034842169506`}, \
{-0.4258093439519355, -1.2611720102745934`}, {-0.38509250656821736`, \
-1.3166782423951338`}, {-0.34262162517817796`, -1.3721845571413296`}, \
{-0.29839669978181727`, -1.427690954513181}, {-0.25458727479676413`, \
-1.4805783289634074`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6689173098823173, 0.4822132025997055, 0.7457573482606822], 
                 
                 
                 ArrowBox[{{-0.24941908103922608`, -1.4866844282176301`}, \
{-0.2046847169701318, -1.5387039971338508`}, {-0.15519765955480727`, \
-1.594210642382669}, {-0.10395655813316133`, -1.6497173702571426`}, \
{-0.050961412705194116`, -1.705224180757272}, {-0.03358687644278454, \
-1.7228391726392092`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.695182385982863, 0.4223205619155689, 0.7604095373207513], 
                 
                 ArrowBox[{{-0.027969029977986073`, -1.7285347675245526`}, {
                  0.003787776729094425, -1.7607310738830568`}, {
                  0.06029101016970426, -1.8162380496344972`}, {
                  0.0856983478556573, -1.840815938240689}, {
                  0.11144830496288491`, -1.8653949735054294`}, {
                  0.1592421987051188, -1.909369105034512}, {
                  0.2036198393669207, -1.949269491470961}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.01281961252401228, 1.}}], {
                 LABColor[
                 0.7899541707789882, 0.20621106228724934`, 
                  0.8132787581475726], 
                 
                 ArrowBox[{{-1.9397585730011873`, -1.810916778541153}, \
{-1.9222153431778586`, -1.8554158083344963`}, {-1.9042417535870984`, \
-1.8999166331509756`}, {-1.8782769324863362`, -1.959839324131626}, \
{-1.8603459266415452`, -2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6300690466584322, 0.5370545279910819, 0.6680160368815792], 
                 
                 
                 ArrowBox[{{-0.9643116333970516, -0.7768246594082966}, \
{-0.93552203226299, -0.8545650065359569}, {-0.9106115134436547, \
-0.9165413977130438}, {-0.8839568454888813, -0.978517735135975}, \
{-0.85555802839867, -1.0404940188047507`}, {-0.840395624109699, \
-1.071669074611703}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6510668338872792, 0.5229179064703109, 0.7357993131843592], 
                 
                 
                 ArrowBox[{{-0.8368966147675431, -1.0788633038006783`}, \
{-0.825415062173021, -1.1024702487193707`}, {-0.793527946811934, \
-1.1644464248798354`}, {-0.7598966823154091, -1.2264225472861443`}, \
{-0.7245212686834465, -1.2883986159382974`}, {-0.6874017059160458, \
-1.350374630836295}, {-0.6821239061598445, -1.3587911380765985`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6710305285294812, 0.4773943989291166, 0.7469362246905459], 
                 
                 
                 ArrowBox[{{-0.6778737954907756, -1.365568789535671}, \
{-0.6485379940132074, -1.4123505919801371`}, {-0.6079301329749309, \
-1.4743264993698235`}, {-0.5655781228012167, -1.5363023530053543`}, \
{-0.5214819634920647, -1.5982781528867298`}, {-0.49795743684630417`, \
-1.6300831328406273`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6929434534186005, 0.4274260328867569, 0.7591605303466715], 
                 
                 
                 ArrowBox[{{-0.4932001510217264, -1.63651494686027}, \
{-0.4756416550474747, -1.6602538990139495`}, {-0.42805719746744686`, \
-1.7222295913870136`}, {-0.37872859075198106`, -1.784205230005922}, \
{-0.32765583490107747`, -1.8461808148706749`}, {-0.30341701478196825`, \
-1.875100235527906}, {-0.29363971611946915`, -1.8865867993980918`}}]}}, {
                Arrowheads[{{0.00900884685032828, 1.}}], {
                 LABColor[
                 0.7159414042925517, 0.37498346607704697`, 
                  0.7719901266862882], 
                 
                 ArrowBox[{{-0.288454305853412, -1.8926787219495258`}, \
{-0.2787997359869082, -1.9040211016025188`}, {-0.22625500856167932`, \
-1.9629706444405979`}, {-0.192244293204647, -2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.38168482767568546`, 
                  0.5222514517124816, -0.39590992497832384`], 
                 
                 ArrowBox[{{0.011344966161822883`, 0.27042175932554147`}, {
                  0.06444730861350223, 0.31728304659826634`}, {
                  0.12601866247174853`, 0.36414406783015185`}, {
                  0.19605902773656167`, 0.41100482302119795`}, {
                  0.23425508964643085`, 0.4344351008514063}, {
                  0.27119088647653095`, 0.455902289300718}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4691385903718484, 
                  0.5265680174122138, -0.04893315846128223], 
                 
                 ArrowBox[{{0.2781518221436347, 0.45984407420981843`}, {
                  0.31699897202109434`, 0.4812954569811933}, {
                  0.36154679248588883`, 0.5047255352807722}, {
                  0.40821186580232505`, 0.5281555470701412}, {
                  0.4569941919704029, 0.5515854923493003}, {
                  0.5078937709901225, 0.5750153711182496}, {
                  0.5609106028614838, 0.598445183376989}, {0.5654774479241742,
                   0.6003789172932722}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5450265862446155, 0.5315130122248285, 0.2891497553177835], 
                 
                 
                 ArrowBox[{{0.5728442552905134, 0.603498236005307}, {
                  0.6266709438241329, 0.626290008397372}, {0.6954210641530223,
                   0.6541353066475193}, {0.7496947517562029, 
                  0.6752968095745826}, {0.805696547832923, 
                  0.6964587453571058}, {0.8634264523831823, 
                  0.7176211139950888}, {0.8707421050212967, 
                  0.7202249632780009}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6104558667752077, 0.535776498815769, 0.5806388314733518], 
                 
                 ArrowBox[{{0.8782789348884267, 0.7229075358406609}, {
                  0.922884465406981, 0.7387839154885316}, {0.9840705869043193,
                   0.7599471498374344}, {1.0469848168751965`, 
                  0.7811108170417967}, {1.1116271553196135`, 
                  0.8022749171016191}, {1.1779976022375693`, 
                  0.8234394500169011}, {1.181674132342761, 
                  0.8245821120511269}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6615931036607452, 0.49891469814633443`, 
                  0.7416714794871598], 
                 
                 ArrowBox[{{1.1893136624976923`, 0.8269564707038783}, {
                  1.246096157629065, 0.8446044157876432}, {1.3159228214941, 
                  0.865769814413845}, {1.3874775938326742`, 
                  0.8869356458955067}, {1.4607604746447878`, 
                  0.9081019102326281}, {1.4960584209884662`, 
                  0.9180623300176732}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6990579691868621, 0.41348301233490037`, 
                  0.7625715633360441], 
                 
                 ArrowBox[{{1.5037577568332534`, 0.9202349384842805}, {
                  1.5357714639304407`, 0.9292686074252093}, {
                  1.6125105616896331`, 0.9504357374732505}, {
                  1.6909777679223648`, 0.9716033003767514}, {
                  1.7711730826286358`, 0.9927712961357121}, {
                  1.8120466967574347`, 1.0034452175836241`}, {
                  1.8126980459332382`, 1.0036135223652591`}}]}}, {
                Arrowheads[{{0.011565613171775931`, 1.}}], {
                 LABColor[
                 0.7335714667493206, 0.3347813744508889, 0.7818252022546411], 
                 
                 
                 ArrowBox[{{1.8204436465010325`, 1.0056149398240077`}, {
                  1.8533575784012566`, 1.014119705511909}, {
                  1.9147253285922163`, 1.0294544231374314`}, {
                  1.977012657372819, 1.044786200321025}, {2., 
                  1.0503609097602347`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7555926333635036, 0.28456618320530297`, 
                  0.7941098914487298], 
                 
                 ArrowBox[{{-1.5722134448092966`, 
                  1.6726565171986367`}, {-1.5543107296857759`, 
                  1.7135545118630078`}, {-1.535975523884689, 
                  1.7544524622186695`}, {-1.5172078274060359`, 
                  1.7953503682656216`}, {-1.4980076402498161`, 
                  1.8362482300038645`}, {-1.4785635161671489`, 
                  1.877204397816196}, {-1.458686605846192, 
                  1.9181624239408512`}, {-1.4359254474890817`, 
                  1.9621105604901825`}}]}}, {
                Arrowheads[{{0.002177797526665492, 1.}}], {
                 LABColor[
                 0.7692722266996855, 0.2533724046206662, 0.8017411652763521], 
                 
                 
                 ArrowBox[{{-1.4322463201089761`, 
                  1.9692143638180455`}, {-1.4295683280610543`, 
                  1.974385135812755}, {-1.415925184985306, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5208586939792, 0.5299381900080885, 0.18148119268122118`], 
                 
                 ArrowBox[{{-0.09190849902814968, 
                  0.7254045375608956}, {-0.03942789479667079, 
                  0.7826916700439698}, {0.017039835931104377`, 
                  0.8399787367957423}, {0.07749469315517575, 
                  0.8972657378162132}, {0.13622605088976059`, 
                  0.949476102794826}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.5748564807705799, 0.5334567804321092, 
                  0.42204267919956023`], 
                 
                 ArrowBox[{{0.14221037735304032`, 0.9547851943363294}, {
                  0.17565284117183835`, 0.9831961161007292}, {
                  0.21036578709220743`, 1.0118395426632505`}, {
                  0.24607551463665045`, 1.0404829527929462`}, {
                  0.2827820238051675, 1.0691263464898166`}, {
                  0.32048531459775853`, 1.0977697237538615`}, {
                  0.3591853870144237, 1.126413084585081}, {0.3942822061476862,
                   1.1517372645992077`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6273210046735612, 0.5368754607591205, 0.6557734413202199], 
                 
                 
                 ArrowBox[{{0.40078553592141847`, 1.1563961151083129`}, {
                  0.4395758767199761, 1.183699756949044}, {0.5002313578711223,
                   1.2251514076365058`}, {0.5629743037074373, 
                  1.2666032548739337`}, {0.6219234649080104, 
                  1.304343780876421}, {0.6676952956536891, 
                  1.3328121931384984`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6676886528308564, 0.48501492740817265`, 
                  0.7450719318035177], 
                 
                 ArrowBox[{{0.6744885364545299, 1.3370373415881736`}, {
                  0.6826036043593287, 1.3420846183714028`}, {
                  0.7450147220613919, 1.3798257673588787`}, {
                  0.8091568180142001, 1.4175672278388487`}, {
                  0.8750298922177536, 1.455308999811313}, {0.942633944672052, 
                  1.493051083276271}, {0.9511897203165888, 
                  1.4977084038292416`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7011386446194133, 0.4087384174369054, 0.7637322852655629], 
                 
                 
                 ArrowBox[{{0.9582161504309203, 1.5015332279883913`}, {
                  1.0119689753770953`, 1.530793478233723}, {1.083034984332884,
                   1.5685361846836692`}, {1.1558319715394179`, 
                  1.6062792026261101`}, {1.2303599369966964`, 
                  1.6440225320610444`}, {1.241825181267024, 
                  1.6496971459731038`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.732758802208815, 0.33663450539689954`, 0.7813718506464326], 
                 
                 ArrowBox[{{1.248995050280123, 1.6532458046401217`}, {
                  1.3066188807047203`, 1.681766172988473}, {1.384608802663489,
                   1.7195101254083958`}, {1.424252880486903, 
                  1.7383822184280424`}, {1.4643297028730031`, 
                  1.7572543893208126`}, {1.5048392698217894`, 
                  1.7761266380867065`}, {1.5376844548687378`, 
                  1.7912666005812832`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7627493154465219, 0.2682466954243441, 0.7981023055015875], 
                 
                 
                 ArrowBox[{{1.544949757957058, 1.7946155363876022`}, {
                  1.545781581333262, 1.7949989647257236`}, {
                  1.5871566374074209`, 1.8138713692378643`}, {
                  1.628964438044266, 1.8327438516231287`}, {
                  1.6712049832437974`, 1.8516164118815164`}, {
                  1.7138782730060151`, 1.8704890500130278`}, {
                  1.756583983729038, 1.8892807832428111`}, {1.799716941179253,
                   1.9080732981059383`}, {1.8375761818692886`, 
                  1.92408646124675}}]}}, {
                Arrowheads[{{0.0104904819234077, 1.}}], {
                 LABColor[
                 0.7912690991553172, 0.20321261170338767`, 
                  0.8140123017739709], 
                 
                 ArrowBox[{{1.8449442137148007`, 1.927202886558469}, {
                  1.858677411793129, 1.9330115593491843`}, {
                  1.9184016984705878`, 1.9579465306744372`}, {
                  1.978890024022766, 1.9828779791895075`}, {2., 
                  1.9914691608454198`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5237659299134961, 0.5301276305967982, 
                  0.19443300125655774`], 
                 
                 ArrowBox[{{0.613743396945427, -0.41869204674135263`}, {
                  0.6830860480968723, -0.4395697821849874}, {
                  0.7558016313361037, -0.46044802713565763`}, {
                  0.8099115972363604, -0.47538010121809615`}, {
                  0.8657485393605124, -0.4903125509428833}, {
                  0.9218877564349899, -0.5048757903622745}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5945462128152167, 0.5347397978804254, 0.5097609263956051], 
                 
                 
                 ArrowBox[{{0.9296429000476505, -0.5068397824766167}, {
                  0.9826033522805027, -0.5201785773195038}, {
                  1.0436212230763406`, -0.5351121539713369}, {
                  1.1063660700960738`, -0.550046106265519}, {
                  1.1708378933397023`, -0.5649804342020496}, {
                  1.2370366928072258`, -0.5799151377809288}, {
                  1.2409705299965577`, -0.5807800844005007}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.652631509622018, 0.5193499532989909, 0.7366721804319292], 
                 
                 ArrowBox[{{1.2487838930522361`, -0.5824980360180265}, {
                  1.3049624684986452`, -0.5948502170021569}, {
                  1.37461522041396, -0.6097856718657337}, {
                  1.4459949485531693`, -0.6247215023716591}, {
                  1.5191016529162744`, -0.6396577085199333}, {
                  1.561957277363574, -0.6482115646810119}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6917174061715815, 0.43022180651963654`, 
                  0.7584765697904131], 
                 
                 ArrowBox[{{1.5698025301137633`, -0.6497774539764753}, {
                  1.5939353335032749`, -0.6545942903105562}, {
                  1.6704959903141705`, -0.6695312477435277}, {
                  1.7487836233489615`, -0.6844685808188479}, {
                  1.8287982326076477`, -0.6994062895365168}, {
                  1.869776313812639, -0.7069747951925702}, {
                  1.8841571165186606`, -0.7096027351277252}}]}}, {
                Arrowheads[{{0.006853244843329734, 1.}}], {
                 LABColor[
                 0.7274060309200108, 0.3488405087694941, 0.7783857630897609], 
                 
                 
                 ArrowBox[{{1.8920267966595825`, -0.711040836125423}, {
                  1.9111955354363461`, -0.7145437208508297}, {
                  1.9749159326775436`, -0.7257926809234705}, {
                  2., -0.7301519788595159}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.39508901061171314`, 
                  0.5222275173517922, -0.3638746585384997], 
                 
                 ArrowBox[{{0.2674472699520147, 0.15523535836441293`}, {
                  0.309462095230542, 0.16616025042083715`}, {
                  0.3543345451812906, 0.17708449096285125`}, {
                  0.40206393979094307`, 0.18800845439484468`}, {
                  0.4526486164320638, 0.1989329538099774}, {
                  0.4939826753972689, 0.20741518454921706`}, {
                  0.5370432595478856, 0.2158980347789941}, {
                  0.5798883592697734, 0.22401365357071862`}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.4946915249114361, 0.5282330914109685, 0.06490580204089784], 
                 
                 ArrowBox[{{0.5877560608379013, 0.22546235100143444`}, {
                  0.6283440034053532, 0.23286559371016052`}, {
                  0.6765841631122039, 0.24135030241154978`}, {
                  0.7265508480044663, 0.24983563060347647`}, {
                  0.7782440580821399, 0.25832157828594055`}, {
                  0.8316637933452252, 0.26680814545894205`}, {
                  0.8868100537937218, 0.275295332122481}, {0.9034353427301436,
                   0.27777652287434956`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5721664124723425, 0.5332814908671739, 
                  0.41005835785764966`], 
                 
                 ArrowBox[{{0.9113477112616526, 0.2789573802838558}, {
                  0.9436828394276299, 0.28378313827655727`}, {
                  1.0022821502469492`, 0.292271563921171}, {
                  1.0626079862516802`, 0.3007606090563221}, {
                  1.1246603474418224`, 0.3092502736820107}, {
                  1.1884392338173762`, 0.3177405577982366}, {
                  1.2283093809032255`, 0.32290858235722064`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6375419180017786, 0.5375414733847926, 0.7013078650422603], 
                 
                 
                 ArrowBox[{{1.2362430092730285`, 0.32393695042841714`}, {
                  1.2539446453783414`, 0.326231461405}, {1.321176582124718, 
                  0.3347229845023007}, {1.3556500520077999`, 
                  0.33902200919995606`}, {1.39056351757715, 
                  0.3433213747479852}, {1.4442834955465766`, 
                  0.3496726687693749}, {1.4989868318078792`, 
                  0.35602210872053414`}, {1.553932865991505, 
                  0.3622849420553622}}]}}, {
                Arrowheads[{{0.003110757358866704, 1.}}], {
                 LABColor[
                 0.6805270819528654, 0.455739267996043, 0.7522339552452112], 
                 
                 ArrowBox[{{1.5618830194061837`, 0.3631765917983855}, {
                  1.611346052755969, 0.36871482584438725`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6767100379536705, 0.4644433297640032, 0.7501045858075326], 
                 
                 
                 ArrowBox[{{1.5322870843355765`, 0.3493107472041298}, {
                  1.6063576482057964`, 0.3575482724266523}, {
                  1.6821541830674158`, 0.36578604890296024`}, {
                  1.7596766889204352`, 0.3740240766330535}, {
                  1.838925165764854, 0.382262355616932}, {1.850459729673915, 
                  0.3834485329967457}}]}}, {
                Arrowheads[{{0.008892822360595944, 1.}}], {
                 LABColor[
                 0.7140967901263279, 0.3791897669853551, 0.7709610934787343], 
                 
                 
                 ArrowBox[{{1.8584177606505383`, 0.3842669112559282}, {
                  1.8796831809697387`, 0.3864537785491989}, {
                  1.920885700141278, 0.39064544567678683`}, {
                  1.9863885757483293`, 0.39707499172396565`}, {2., 
                  0.39838929631595504`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7226029300866481, 0.3597930904898375, 0.7757063137245432], 
                 
                 
                 ArrowBox[{{-1.975931546185457, -0.030018365374726543`}, \
{-1.9747722523973927`, -0.10032133943261283`}, {-1.9723623635896157`, \
-0.1706243118689402}, {-1.9687018906842795`, -0.240927281052194}, \
{-1.963790833681384, -0.3112302469823742}, {-1.960431977691196, \
-0.3495540512199417}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7243372659978875, 0.3558382587139914, 0.7766738272991419], 
                 
                 
                 ArrowBox[{{-1.9597335022879196`, -0.3575235011451886}, \
{-1.9576291925809295`, -0.38153320965948095`}, {-1.9505154865343661`, \
-0.449217388737601}, {-1.942242568271821, -0.5169015765439455}, \
{-1.9305653544551453`, -0.5995869397807327}, {-1.9183774370226572`, \
-0.6747527495139668}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.728871431447906, 0.3454989343175643, 0.7792032488454181], 
                 
                 ArrowBox[{{-1.9170893276985432`, -0.6826482907876292}, \
{-1.902021080004449, -0.7649571406745299}, {-1.885154019370429, \
-0.8476419783315402}, {-1.8665570097972939`, -0.9303266407952916}, \
{-1.8505178875361263`, -0.9955693872511465}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7360536483435918, 0.3291212191264055, 0.7832099077038642], 
                 
                 
                 ArrowBox[{{-1.848608051473122, -1.003338076085979}, \
{-1.8462300512850442`, -1.0130111280657839`}, {-1.8241731438336792`, \
-1.0956954401430175`}, {-1.8003862874431995`, -1.1783795770269918`}, \
{-1.787844128395792, -1.2197215797715073`}, {-1.7748694821136057`, \
-1.2610635387177078`}, {-1.7614623485966405`, -1.3024054538655936`}, \
{-1.75878588062633, -1.310400629202019}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7455574017830559, 0.3074496698903985, 0.7885116548468095], 
                 
                 
                 ArrowBox[{{-1.7562463172605964`, -1.3179868415580913`}, \
{-1.7476227278448966`, -1.3437473252151646`}, {-1.7333506198583737`, \
-1.3850891527664209`}, {-1.7186460246370725`, -1.4264309365193624`}, \
{-1.7035089421809926`, -1.4677726764739891`}, {-1.6879393724901337`, \
-1.5091143726303011`}, {-1.671937315564496, -1.5504560249882986`}, \
{-1.65550277140408, -1.591797633547981}, {-1.6448505691790054`, \
-1.617906478538011}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.7570568908601069, 0.2812272152244986, 0.794926739554965], 
                 
                 ArrowBox[{{-1.641828480099746, -1.6253137032272602`}, \
{-1.6386357400088851`, -1.633139198309349}, {-1.6213362213789115`, \
-1.6744807192724023`}, {-1.6036042155141592`, -1.7158221964371405`}, \
{-1.5854397224146284`, -1.7571636298035642`}, {-1.5668427420803186`, \
-1.7985050193716732`}, {-1.5478132745112303`, -1.8398463651414674`}, \
{-1.5285394996016177`, -1.8812479721295166`}, {-1.511313152796535, \
-1.9174404187853693`}}]}}, {
                Arrowheads[{{0.005292043161430494, 1.}}], {
                 LABColor[
                 0.7702317330235923, 0.2511844281886959, 0.8022764337830334], 
                 
                 
                 ArrowBox[{{-1.5078230716963064`, -1.9246383808657375`}, \
{-1.4799425251455438`, -1.979496897138684}, {-1.4692238158578756`, \
-2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4631845780773984, 
                  0.5261800435360864, -0.07545843168840673], 
                 
                 ArrowBox[{{0.24549087426063493`, -0.4550006090396683}, {
                  0.28772751521863005`, -0.4795417292342688}, {
                  0.332182565008491, -0.504082785321868}, {
                  0.37885602363021764`, -0.5286237773024658}, {
                  0.42774789108380995`, -0.5531647051760623}, {
                  0.47885816736926823`, -0.5777055689426577}, {
                  0.5299464387715509, -0.6012153747944261}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.539576027532262, 0.5311578442664648, 0.26486738035184176`], 
                 ArrowBox[{{0.53724860925819, -0.6044826554272105}, {
                  0.5877339464357815, -0.6267871041548441}, {
                  0.6547281396609088, -0.6551633559464314}, {
                  0.7246878231374054, -0.6835400525892051}, {
                  0.7800927675797283, -0.7051939106258643}, {
                  0.8334576756020808, -0.7254200124835049}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.60545614813838, 0.5354507083868704, 0.5583649602849733], 
                 
                 ArrowBox[{{0.8409519435673994, -0.728219016575567}, {
                  0.8960868433513359, -0.748502856229655}, {
                  0.9566759746806203, -0.7701579437967861}, {
                  1.0189931683055589`, -0.791813441207408}, {
                  1.0830384242261513`, -0.8134693484615206}, {
                  1.1431911492573594`, -0.8332750466213409}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6582908878164415, 0.5064447896742338, 0.7398293111765608], 
                 
                 
                 ArrowBox[{{1.150794761481024, -0.8357618851669727}, {
                  1.2163131229542974`, -0.8567823925002178}, {
                  1.2855425657618516`, -0.8784395292848025}, {
                  1.3565000708650594`, -0.9000970759128777}, {
                  1.4291856382639214`, -0.9217550323844438}, {
                  1.4566668582090851`, -0.9297535446301226}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.6959546800272172, 0.4205594884077694, 0.7608403679151318], 
                 
                 
                 ArrowBox[{{1.4643481224776453`, -0.9319892054354642}, {
                  1.5035992679584371`, -0.9434133986995004}, {
                  1.5797409599486067`, -0.9650721748580476}, {
                  1.6576107142344303`, -0.9867313608600857}, {
                  1.7372085308159075`, -1.0083909567056144`}, {
                  1.7726141982556043`, -1.017820758986952}}]}}, {
                Arrowheads[{{0.014177857867834445`, 1.}}], {
                 LABColor[
                 0.7306224074033054, 0.341506158003426, 0.7801800452057231], 
                 
                 ArrowBox[{{1.7803447138930875`, -1.0198796732587536`}, {
                  1.818534409693039, -1.0300509623946337`}, {
                  1.8599907571887409`, -1.0409763085549746`}, {
                  1.9018846554706377`, -1.0519022184920979`}, {
                  1.9642242766859581`, -1.0676310615907532`}, {
                  2., -1.0765241154427938`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.017511160383071787`, 1.}}], {
                 LABColor[
                 0.7388863257510626, 0.3226618230260382, 0.7847901401296742], 
                 
                 
                 ArrowBox[{{1.0357615352117122`, 1.8621558601265058`}, {
                  1.1107561040572955`, 1.9057470006716395`}, {
                  1.1477311423559213`, 1.9269932725487213`}, {
                  1.1851166805448263`, 1.948240520998435}, {1.231107817931772,
                   1.973591627767373}, {1.2776915917194227`, 
                  1.9989397201266008`}, {1.2796651780422283`, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.774641247888531, 0.24112934636117186`, 0.8047363179736193], 
                 
                 ArrowBox[{{-1.9789545579253802`, -1.5127097297221304`}, \
{-1.9642376538826023`, -1.556196211799001}, {-1.9490983147112961`, \
-1.599684529197668}, {-1.928225566896446, -1.6551117550864238`}, \
{-1.9066623677900776`, -1.7105316672909754`}, {-1.8844089319833421`, \
-1.7659440848415118`}, {-1.865418719468307, -1.8118020060254632`}}]}}, {
                Arrowheads[{{0.00014583039150428052`, 1.}}], {
                 LABColor[
                 0.7852852219065221, 0.21685773531118202`, 
                  0.8106741465588115], 
                 
                 ArrowBox[{{-1.8623579069280032`, -1.8191933135277338`}, \
{-1.8614651879458561`, -1.821349068061303}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.013327739252109509`, 1.}}], {
                 LABColor[
                 0.7764775803633273, 0.23694193031605704`, 
                  0.8057607311713904], 
                 
                 ArrowBox[{{-1.9657775657198329`, 
                  1.5609437331845974`}, {-1.9505719307198375`, 
                  1.6045451338955363`}, {-1.9349422168468606`, 
                  1.6481483675755584`}, {-1.913190413933703, 
                  1.7043320521563172`}, {-1.8907300459751957`, 
                  1.7605081986214508`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.605900523480695, 0.5354796646629892, 0.5603446635148924], 
                 
                 ArrowBox[{{-1.1143696276211605`, 
                  0.023208398743257374`}, {-1.1122250706865038`, 
                  0.10049372970552375`}, {-1.107400804553657, 
                  0.17777906025622836`}, {-1.0998968268313087`, 
                  0.2550643919712967}, {-1.0897131375194593`, 
                  0.332349724850729}, {-1.0881292742939213`, 
                  0.34186582400709903`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6113963383487981, 0.5358377815917778, 0.5848286557831008], 
                 
                 
                 ArrowBox[{{-1.0868158198391493`, 
                  0.3497572647751236}, {-1.0768497366181085`, 
                  0.4096350588945248}, {-1.0613067087042873`, 
                  0.48692034272523244`}, {-1.0430841383550271`, 
                  0.5642055249654004}, {-1.0221820255703273`, 
                  0.6414906056150281}, {-1.016053445962335, 
                  0.6615760127776751}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6256613557799136, 0.5367673151285045, 0.6483796641178897], 
                 
                 
                 ArrowBox[{{-1.0137187041500786`, 
                  0.6692277433446843}, {-0.9986003703501886, 
                  0.7187755846741158}, {-0.9719306530349112, 
                  0.7972033019878942}, {-0.9425010879049323, 
                  0.8756312517328069}, {-0.9171416456402641, 
                  0.9379831370261843}, {-0.9034759863137405, 
                  0.9694206506335776}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6461932285741743, 0.5335208952077404, 0.7322325259559035], 
                 
                 
                 ArrowBox[{{-0.900286731877323, 
                  0.9767574521260396}, {-0.8900377542636199, 
                  1.0003349733779634`}, {-0.8611894137749994, 
                  1.062686760788144}, {-0.830596624174403, 
                  1.1250384992567264`}, {-0.7982593854618304, 
                  1.1873901887837097`}, {-0.7641776976372817, 
                  1.249741829369095}, {-0.7567844801014226, 
                  1.2626089403709402`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.6650514203079357, 0.4910286476536865, 0.7436007299165224], 
                 
                 
                 ArrowBox[{{-0.7527988874212902, 
                  1.2695454417216265`}, {-0.728351560700757, 
                  1.3120934210128814`}, {-0.690780974652256, 
                  1.37444496371507}, {-0.6514659394917789, 
                  1.4367964574756598`}, {-0.6104064552193258, 
                  1.4991479022946512`}, {-0.5822413476507199, 
                  1.54017529471131}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6861811048403371, 0.442846316156768, 0.7553880984877459], 
                 
                 ArrowBox[{{-0.5777136182566631, 
                  1.5467707224104206`}, {-0.5676025218348966, 
                  1.5614992981720441`}, {-0.5230541393384912, 
                  1.6238506451078385`}, {-0.4767613077301098, 
                  1.6862019431020345`}, {-0.4287240270097522, 
                  1.748553192154632}, {-0.3855871922931894, 
                  1.8025817167283316`}}]}}, {
                Arrowheads[{{0.015742465941198363`, 1.}}], {
                 LABColor[
                 0.708672210708674, 0.3915595154939975, 0.7679349471658679], 
                 
                 ArrowBox[{{-0.38059570108228236`, 
                  1.8088335177081643`}, {-0.37894229717741856`, 
                  1.8109043922656312`}, {-0.32741611823310873`, 
                  1.8732555434350318`}, {-0.3030048584147494, 
                  1.90230355734634}, {-0.2782162774311789, 
                  1.931352998568976}, {-0.22558800144124455`, 
                  1.9902839139664126`}, {-0.21665070619546895`, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.013926451368950703`, 1.}}], {
                 LABColor[
                 0.7084797980632624, 0.3919982768891904, 0.7678276081866344], 
                 
                 
                 ArrowBox[{{-0.17271367980880137`, 
                  1.8386351510309522`}, {-0.11763832705511032`, 
                  1.898163003735669}, {-0.09301080529451121, 
                  1.9243640339888288`}, {-0.06804444163741806, 
                  1.9505662202226821`}, {-0.022250666509774447`, 
                  1.996873386066393}, {-0.019086183076437006`, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7028287050516491, 0.40488454768930304`, 
                  0.7646750993994821], 
                 
                 ArrowBox[{{1.3892332275960808`, 1.1385303449010225`}, {
                  1.464307918158924, 1.165052083092901}, {1.5411112889043552`,
                   1.1915741937341966`}, {1.6196433398323737`, 
                  1.2180966768249095`}, {1.692028092224983, 
                  1.2420168468065604`}}]}}, {
                Arrowheads[{{0.019681459665476023`, 1.}}], {
                 LABColor[
                 0.7363706423781691, 0.32839837295077406`, 
                  0.7833867454372772], 
                 
                 ArrowBox[{{1.699624083910359, 1.2445270082188407`}, {
                  1.69990407094298, 1.2446195323650397`}, {
                  1.7406826915667535`, 1.2578810998036363`}, {
                  1.7818934822361738`, 1.271142760354587}, {
                  1.8235364429512413`, 1.2844045140178921`}, {
                  1.8656115737119554`, 1.2976663607935515`}, {
                  1.90816694922986, 1.3110110906708698`}, {
                  1.9511579173829734`, 1.3243564514934314`}, {2., 
                  1.3390447868703772`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.7195203084953807, 0.36682243800149783`, 
                  0.7739866478768983], 
                 
                 ArrowBox[{{1.5426453920666936`, -1.1887550050730347`}, {
                  1.6211885490795108`, -1.2152107406366348`}, {
                  1.7014603713718885`, -1.2416668484748699`}, {
                  1.7422445319979125`, -1.2548950419969755`}, {
                  1.7834608589438268`, -1.26812332858774}, {
                  1.825109352209631, -1.281351708247163}, {
                  1.8468027923386958`, -1.2881712563234287`}}]}}, {
                Arrowheads[{{0.009519189633235918, 1.}}], {
                 LABColor[
                 0.7519657317481429, 0.2928366604890524, 0.7920865945061624], 
                 
                 
                 ArrowBox[{{1.854434580072564, -1.290570384495324}, {
                  1.8671900117953257`, -1.2945801809752449`}, {
                  1.9097538060742698`, -1.3078922219493305`}, {
                  1.9527532472140756`, -1.3212048925268225`}, {
                  2., -1.335375756422928}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5088341536525718, 0.5291546498861575, 
                  0.12791156571022871`], 
                 
                 ArrowBox[{{-0.6834852550300229, -0.0006907049361973435}, \
{-0.6834720231092137, -0.004848868177265454}, {-0.6834599928003288, \
-0.00751009018909193}, {-0.6834427815818778, -0.010171312200918405`}, \
{-0.6834203894538606, -0.01283253421274488}, {-0.6834058978014983, \
-0.0142962063255527}, {-0.6820320795564327, -0.06293088444607536}, \
{-0.6789279030496229, -0.11156556180046134`}, {-0.674093368281069, \
-0.16020023838871048`}, {-0.6675284752507707, -0.20883491421082281`}, \
{-0.6592332503544931, -0.25746961184717515`}, {-0.6492077199880002, \
-0.3061043538781439}, {-0.6463737462021537, -0.3178287188424774}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5186842435341004, 0.529796499006137, 0.17179396173128225`], 
                 
                 ArrowBox[{{-0.6444941435551722, -0.3256047778629234}, \
{-0.6374518841512927, -0.35473914030372933`}, {-0.6239657428443702, \
-0.40337397112393125`}, {-0.6087492640449952, -0.45200878625118596`}, \
{-0.5918024157309298, -0.5006435255979297}, {-0.5731251979021743, \
-0.5492781891641623}, {-0.5527176105587285, -0.5979127769498839}, \
{-0.5420944841471528, -0.6221997372511421}, {-0.5397149388974196, \
-0.6274289472845288}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5448207575138078, 0.531499600063993, 0.28823278318996964`], 
                 
                 ArrowBox[{{-0.536401478665116, -0.6347104980320648}, \
{-0.5310412896317817, -0.6464898723797915}, {-0.4968311899324751, \
-0.7120719937738843}, {-0.4594400174166677, -0.7775946423796721}, \
{-0.42483358376830405`, -0.8360418823638736}, {-0.38772236049655306`, \
-0.894487296625341}, {-0.37622409671895657`, -0.9114501292785518}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.580315985506682, 0.5338125313290593, 0.44636490892435793`], 
                 
                 ArrowBox[{{-0.3717353549776771, -0.9180721529556536}, \
{-0.3481063476014148, -0.9529308851640745}, {-0.3059855450828893, \
-1.0113726479800742`}, {-0.26135995294097636`, -1.0698125850733398`}, \
{-0.21422957117567618`, -1.1282506964438717`}, {-0.17717145900203082`, \
-1.171879807978295}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6208986790757064, 0.5364569707673759, 0.6271618206496599], 
                 
                 
                 ArrowBox[{{-0.17199243279209778`, -1.1779771588388595`}, \
{-0.16459439978698867`, -1.1866869820916695`}, {-0.11245443877491385`, \
-1.2451214420167334`}, {-0.05780968813945172, -1.3035540762190634`}, \
{-0.0006601478806022808, -1.3619848846986595`}, {
                  0.04829273998189953, -1.4099322415202542`}}]}}, {
                Arrowheads[{{0.011214854059164999`, 1.}}], {
                 LABColor[
                 0.6575768160400653, 0.5080730980850473, 0.7394309603539754], 
                 
                 
                 ArrowBox[{{0.05400798753956997, -1.41553009337204}, {
                  0.058994182001634476`, -1.4204138674555216`}, {
                  0.12115330150725852`, -1.47884102448965}, {
                  0.1531721573688408, -1.508053918360689}, {
                  0.18581721063627, -1.5372663558010444`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.646509422413652, 0.5333102391174662, 0.7332569236523249], 
                 
                 ArrowBox[{{-1.3306027586824696`, 
                  0.006932440834897583}, {-1.330598201016886, 
                  0.008512982717329054}, {-1.3293341513308672`, 
                  0.08246401415170775}, {-1.3260151233748463`, 
                  0.1564150458399068}, {-1.3206411171488228`, 
                  0.23036607778192594`}, {-1.3132121326527977`, 
                  0.304317109977765}, {-1.310418367504693, 
                  0.3261015529109301}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6492704136656422, 0.5270143100154727, 0.7347971653657884], 
                 
                 
                 ArrowBox[{{-1.3094007348070749`, 
                  0.33403656543094157`}, {-1.3037282196248616`, 
                  0.37826812274643906`}, {-1.292189427803106, 
                  0.45221909640696345`}, {-1.278595757187531, 
                  0.5261700309593378}, {-1.262947207778137, 
                  0.6001209264035618}, {-1.2513349983948914`, 
                  0.6485296693437119}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6569592812350045, 0.5094812718153603, 0.7390864634760571], 
                 
                 
                 ArrowBox[{{-1.2494689095995146`, 
                  0.6563089824629899}, {-1.244591100025613, 
                  0.6766434960754213}, {-1.224034411153121, 
                  0.7531661629992585}, {-1.2039437381454583`, 
                  0.8211097848201219}, {-1.1821182502979364`, 
                  0.8890532660256262}, {-1.158557947610556, 
                  0.956996606615771}, {-1.156560168673808, 
                  0.9623626814584246}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6689138464789274, 0.48222110024957254`, 
                  0.7457554161725715], 
                 
                 ArrowBox[{{-1.153768949144421, 
                  0.9698599538650248}, {-1.1332628300833167`, 
                  1.0249398065905566`}, {-1.1062328977162184`, 
                  1.0928828659499827`}, {-1.0774681505092614`, 
                  1.1608257846940502`}, {-1.0469685884624453`, 
                  1.228768562822758}, {-1.0298877454399875`, 
                  1.2647710433415298`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6842386834794458, 0.4472756482546347, 0.7543045027309643], 
                 
                 
                 ArrowBox[{{-1.026458622215282, 
                  1.2719988447990813`}, {-1.0147342115757705`, 
                  1.2967112003361068`}, {-0.9807650198492366, 
                  1.3646536972340961`}, {-0.9450610132828441, 
                  1.4325960535167264`}, {-0.9076221918765928, 
                  1.5005382691839975`}, {-0.8764739782205175, 
                  1.5545611905349395`}}]}}, {
                Arrowheads[{{0.019999999999999993`, 1.}}], {
                 LABColor[
                 0.7019993049078194, 0.40677584107857784`, 
                  0.7642124116971004], 
                 
                 ArrowBox[{{-0.8724780136941196, 
                  1.5614917220804827`}, {-0.8684485556304822, 
                  1.5684803442359092`}, {-0.8275401045445129, 
                  1.6364222786724618`}, {-0.7848968386186848, 
                  1.704364072493655}, {-0.7405187578529977, 
                  1.7723057256994892`}, {-0.7005007486794732, 
                  1.8312671949025152`}}]}}, {
                Arrowheads[{{0.012532424596460057`, 1.}}], {
                 LABColor[
                 0.7214348047810305, 0.3624567838648566, 0.775054665400425], 
                 
                 ArrowBox[{{-0.696008088508485, 
                  1.8378865607775832`}, {-0.6944058622474518, 
                  1.840247238289964}, {-0.6714225246984156, 
                  1.8734850209561826`}, {-0.6480252905320717, 
                  1.9067245370287063`}, {-0.618206576307254, 
                  1.9470544435789505`}, {-0.5877720672338834, 
                  1.9873785752660444`}, {-0.5780519153402458, 2.}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.192, 0.48, 0.64]], {{
                Arrowheads[{{0.013490242868552956`, 1.}}], {
                 LABColor[
                 0.7115524672914928, 0.3849916238978526, 0.7695417220265769], 
                 
                 
                 ArrowBox[{{0.23106018930166825`, -1.8602202546828595`}, {
                  0.29259495880690456`, -1.9138125968948512`}, {
                  0.32113229254062503`, -1.938318526838617}, {
                  0.3500336970499323, -1.9628255965257009`}, {
                  0.3955070809807995, -2.}}]}}}}}}}, {
          DisplayFunction -> Identity, DisplayFunction -> Identity, 
           PlotRange -> {{-2., 2.}, {-2., 2.}}, DisplayFunction -> Identity, 
           AspectRatio -> 1, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> Small, 
           Method -> {
            "VectorLengthFunction" -> 
             Function[{
               System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
               System`VectorPlotsDump`min = 
                Min[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`max = 
                Max[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`imin = If[
                  NumericQ[System`VectorPlotsDump`min], 
                  System`VectorPlotsDump`min, 
                  Min[System`VectorPlotsDump`m], 
                  Min[System`VectorPlotsDump`m]]; 
               System`VectorPlotsDump`imax = If[
                  NumericQ[System`VectorPlotsDump`max], 
                  System`VectorPlotsDump`max, 
                  Max[System`VectorPlotsDump`m], 
                  Max[System`VectorPlotsDump`m]]; Map[If[
                  
                  Or[# > System`VectorPlotsDump`imax, # < 
                   System`VectorPlotsDump`imin], #, 
                  System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
             "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.05], 
              Scaled[0.05]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
           Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
           AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic,
            BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
           Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, 
           FormatType :> TraditionalForm, FrameLabel -> None, 
           FrameStyle -> {}, FrameTicksStyle -> {}, GridLines -> None, 
           ImageMargins -> 0., ImagePadding -> All, ImageSizeRaw -> Automatic,
            LabelStyle -> {}, PlotLabel -> None, PlotRegion -> Automatic, 
           PreserveImageOptions -> Automatic, Prolog -> {}, RotateLabel -> 
           True, TicksStyle -> {}, DisplayFunction -> Identity, AspectRatio -> 
           1, DisplayFunction :> Identity, Frame -> True, 
           FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
           GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], ImageSize -> Small, 
           Method -> {
            "VectorLengthFunction" -> 
             Function[{
               System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
               System`VectorPlotsDump`min = 
                Min[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`max = 
                Max[System`VectorPlotsDump`vrange]; 
               System`VectorPlotsDump`imin = If[
                  NumericQ[System`VectorPlotsDump`min], 
                  System`VectorPlotsDump`min, 
                  Min[System`VectorPlotsDump`m], 
                  Min[System`VectorPlotsDump`m]]; 
               System`VectorPlotsDump`imax = If[
                  NumericQ[System`VectorPlotsDump`max], 
                  System`VectorPlotsDump`max, 
                  Max[System`VectorPlotsDump`m], 
                  Max[System`VectorPlotsDump`m]]; Map[If[
                  
                  Or[# > System`VectorPlotsDump`imax, # < 
                   System`VectorPlotsDump`imin], #, 
                  System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
             "DefaultBoundaryStyle" -> Automatic, 
             "DefaultGraphicsInteraction" -> {
              "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
               "Effects" -> {
                "Highlight" -> {"ratio" -> 2}, 
                 "HighlightPoint" -> {"ratio" -> 2}, 
                 "Droplines" -> {
                  "freeformCursorMode" -> True, 
                   "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
             "TransparentPolygonMesh" -> True}, 
           PlotRange -> {{-2., 2.}, {-2., 2.}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.05], 
              Scaled[0.05]}, {
              Scaled[0.05], 
              Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
         FormBox[
          FormBox[
           TemplateBox[{
             FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 GraphicsBox[{
                   RasterBox[CompressedData["
1:eJxt13k01dvfB3AZUoiUeUylqKQBGXLfKEMpKqSQIU0qilQUlSGiFBkq1Lnp
JtdNdRxlKiRkPsdxjtnhOIN5uCUZGn6e9fz1/L7PXuuz1l6v/cfe+7P32mt/
NI6eO3BcSEBAoGY+FszH//T/u724EOV39AQfMpUbS2Oev0APSf9bpKoz0nUS
nJNd+NjmORK4Iz4PMZazBxsVTsFcmMOptOOjOn1M21S4GHUugx7TjQEIWWEn
MmnBBzedFCa8vgz/xnqeLV16BeXcaznq2/hI/K0XOBVcDsqjQ/6UwRtIPjPX
YLOeD7rA4L/RsRUQG3TM3iNxE7eFVh06p84HxW/PoZqzVfjHXyJbwD8G3Cwd
08TlfBjcShtcuL4aKhdOFP6lcBeXQ9b75Ynycetp0xG7+hqMyT5fKhqeAClD
4S76HA+vtCLtcp3qUOJrL7tYKQmKf166PDbOg7TNXrMftfXQ79WU+sRIQcAX
+c2iXB5C/N+2yOo2okciPYOU+wjxBxxmVNp4MNR2i9kdScXb+5qBi/PSkbLF
p0y3ngdJCtXK6AQNQ9IGWmfaSUgo9LuEMh4y77Ino4WbUJP0J/lBwlOkr9kr
viePh05HzlHy4yaQtncf67V5hv5NH/2csngouyL422QLHQPGCcYlS5/j7jGX
eNd0Ho6aGAw9KqdjTttOwJaZiY0hVzzc43nw2H5seoN9MxzJH8l5yVlYlu9Y
dySSh2DTVe93tTXj98438ucPZOPX+tHyw0E8lPqmso3cGchMSchki7+Ej4KC
/oGzPNyXFxf9g83AKa+UE57lOVDZELzU2pOHac3PW+95McFWnd1ueOk1pJvC
dxg68vBFZYmIZw8TE6N0FjPxDZ6eu/he04aHgA+9T7tdWqAolUu7coaMtFfu
PlLbefhoHxa+idGC1/sos6stchH9WsHwmy4PMS+/yITatmJbRXXMsDwF+Va7
5FpX8eB1psKSW9YK4+sPt3FGKFDR9fo3T54Huf0pXyL02hDyLISk9jEPVKO0
d3fFeVD8lrb7cmYbXngn3nyV9BY6wXMHjv3mwnxx4IpWuXa4KEQvyzj5Di4n
7Sj6X7nQaf+qW3SzHaLMVQtFjfOhsEirQrCfi3GZX4f1v7bD47Bn36B4AWpE
OP51HVwI9Uq3uXp0IC1l3dKD3QVIrSFl3WvkYipq5BRqO7AvS+S306tChN7d
4WhfzoVpgPPlia2d+HDEwezrtSLM+V32FHvHRVzuou3X0jsxQ559YmBfjFe+
LwrK/uZiSZFD55RQF1wdf2zVUn+P7UELbAIecyG7xvr6ydNdYD4/G0Qde4+c
Y4EzaglcbFcv8uuidqFlVN9pa8kH8AZe5VdFcuEV8E7DS68bQz2Tm1ziSmB+
R83XJ4iL6KVpDgIPu1Esovdjl1sppu6PCYme5aLSYefyitlu1NSqq0XKlsGE
s/AEyYML90dXm966sbBCyUusIaQMXI5Y6BYHLvizPF/WBxZUmrW1BLllcHM8
tKXMios1jU8trNR60LVaMk/T9iPqVBeeszHmgllZvPFbaA+ibjlVGuV+hLwq
R7lOhwtS+xPSl64eXKaI7zdTLEcFL1DDRoMLx8zG+gzVXhj5lG8wuVEOs9Cp
k6UyXOy+0+JxZU8vmu4vkd7QX454SefWTYu4sLfZpiN0tRcJRR/TZOw+YXmK
oXP6HAei92x0zf7uRcHU3P6pvE9YcXOsccE4B7+LHIz0WnvR4DnzlK5cAcsj
IZpefRyMwHSWLczGX76fuNnhFeixSDIvYnIgqzn5y3YLG5K0tx43BivQFJW8
eEkNBxd8cvICPdggz7AtHfdVYu3a296H33PACp847X6HDTeaQ+Ha/EroWK3T
J73mIDI+2Em8kI0jpcb1c6pV6HlA82ZlcPDY4VtcKI+NzNGZsKbIKnhXhjPk
UjiovpMqmy/dh82SK2l/D1dBrmrojE0MBwrfn7UUmvaBOnuQdPPAZ0hsPCh5
IYSDX2U5z6N9+iAjuqr+eOFnPPLPI6Wc4+CDzIzFyuQ+8KsK19quqEaoarIQ
5ej8On8+cL1d1gcO9Z8gg+hqXBNao1rtxIH4+4jYiuE+kFruXNUaq0any2Yq
04aDFHfSYaocBxZecRwNpxrcYCj/6DThwDKVrhQxP04V3NTjXlQDP0pClLQG
B3G+r4IRzcFDH13hbJVaeM6Mxb8Z6sPVcfoRzcr5vLoofq2/XoshZ6E527w+
zAVXPPpDkIvv6bqepZxanPRgNfSFzu//c7lH0h9ckOX63IJt6rDMNlEk0LoP
zvve2+te4SLq7C7Hrzl1cGaejv+1tA9k0fcR8m+5SIx6IbpGph7LDUTswjrm
z1VMOM1xnIuIgi+xYlfrwW44LTn3jA01J4GKUS0ejsWeM0/tq4dU6+KE075s
ULYYVA568cDwcOto3N0A652kiEYDNsz67UXsU3lIekDem0FpwNmSRWGaAmxw
SR73V9F5kNGdbpNUbYRv4E8pv5pe/BTx1/JdzIdCsOEPyehGnND+52nm/V4w
skO3bTbjo1xc8PLjfxshnq4X3+Dai7/amAOBl/hIyYmzfOtGxXcRSVX26l7I
LFuy2vQlH0uLZh7vr6aCLHmKVdLZg4GHlxPvsvloSaVNGSjRcD3Xf2Wcbw9G
X+7M8pXrx6bPVsPh+2iY1rJiaf1mIacKT1i7++F+NixFLJqGPec3Z8XFs7Cq
1fw671o/nBUTZ+s+0KBR8if1nQYLQTdd1kTl9iN+yH1T5SQN+ucjnEm53TAJ
KrCo4PXDcOXNE5Prm2CdozRhvqMb94cOujxTGEDRT9deZ+8mSN/RnHjY3AU5
5Uv1a2wHMOs3OTma2gTDDse9T7y7sD+K07w/dABPDq+TfEtvQubxsUTbr50Y
cpKLWft6AOUTpS/+EaNjYXdE96PwTox+W8XN7h0AozHCjmZBB7sjvSpMuhPL
DsWXsKQHUe0RRtK4SofPvo3ec6QOPJH6yai0GESOvon1EwodusqUzb90OiCg
XlR99MIgLHvGBCxH6DBkkSXCitvRudBEo+DZIMI72Mkyms1YOxqgdMWmHYdO
BOytbh6Ek2l+l7h7M2raHxexGG0Q2iH3PFloCC3khgLtB80ouHHK/5lnG1I7
G31Wbh2C5vHnir60Zoy+nqAWD7cionh/9fmjQ7C4vXeWsZiB6J6dh5UutaIg
/XR7eMIQ0lTaPT13MOA3EuX95ncL7tz4muFSNoSzFzuOSIYyoDZ5YdL3VgvM
bD4ozI4NITqcJ856x8C3+MCH5ktbYDjto+qtOowD2gr3GicYiHVbs1XhARM7
8o0iHtgO49DjLJmedUzUp0hVd6kw0R1eJ/EoeBgLDwXTJY8zMV3caRT0lIGE
ELqvz4thFJ7OXXiExMTOItlftNUMpD4tsxVjDiON7/G9up0JCZna8trMZkT/
c/KPUMERPFaQ/bJfpgUPpioErdY2Q7s2nvZJdwQ6rkm23+1a4F6qE6meSUdJ
6+0bPW4jaDW/6lEQ04Kgmdli3VV0jKW9K2uKGYER/8u9pIoW1K37Kbn7SROc
Mn98T3s3gqMrjlnens+L0EQb30S+CV5/7AsHZwRKl3XH0oxbcd5yNK4ujgZq
lwr5g9Qotjw49avyYivqB1zL3i2gQS+VUie/fRTqq5PHF5FbsVDgd64XrxF+
38hS9qdGofjWz+zYSCv0zBq/lZU1QNnOm3wsaRR/Ml8Etq5tw1Yb5W8FSfUY
OanadbhsFFfZFJmj3m2ouHg73d6zDmGWD3N1R0bRkpKQI0Rqww9F98WHVtZC
6i9z+375MVCNH9KKO9oQlrHA1Lu9Go9d71SE7RhDwUbr5bHz/xT3iSfHsyM+
o6DPRFXg3BhEWuSl/A60Y2n555XjalUI2fTSzTt1DMxX+71O3m2H9YrFUbZZ
FfDcKnf9ZeUY1t/ozb5Y2w5NlwxPvvKn+fvfFNw1MYac8A3xDxd24OPn6eSL
gR+R5hhvMqk8DqvTkwVUiw4seDPcVuJYiitOpJeTVuPYZahNU7regcrA1Z8V
jxXDtFHxNct/HIUldRHBxR348kt+ye2Jd8if01CnpI9Dq7Qucvh7B3RPyOcl
kMnI2C3THPB5HMfjB6LO63Xi0YUz46yp5zhVWpCm9mUcatsSzRb5d8JJOYrX
3XIT/1uFTCAyLmqo/2Mn/m91MoE2nivXXqWL4P7T9jNil4hunWApu4JKdOFt
lmXJa7sJbisxrRlwneikjedViluIfsHrwLpLOiyCe9oG3MmKILqHx4SxczvR
+17xR6M29hB81PqNxvYIom/wYCpdbSX6qWz65DPZXoK72H4ycADR00oWbGg4
RXQD44YHy+8T/e+Y9dpaxUT/nqgSIsEl+m3lfKVyCTbBLxZvurZbn+iMCbrU
iyNE96axtNtvEn2a5anQl0N0nvuU4icm0St33PQM/Un0kd5+6WWafQTX2htn
E76H6Ax3KRnqBaIvlyoNnkkluoiA1kXBcqJ7Nt2eHhog+vUep1GKFId4b39E
67kbEN0hY8WLITei/6l+Vc4lguh6Ktl7cv4mesBQvQSPSvR10x7LBaeIrpl/
S05EhUtwI9sjVWPmRN9ipdVQepLoVEoWNSiO6CUUO18lCtEn2wPNnrcR3Tg2
haX4i+jJ1yPagubryf/2uy/ji8ptiG70pEpi2pfovbeWOCgmEv38SuclawuI
rn62Kl+j+/+ZN5ZZu1iQT/CMmuDinjVEH+Fbzj2zJbrx+9jpg+eJ/tTrktpM
EtFNuzczYwuJrnfxZ5gEi+g6+bbR1wT7ie+MdedO9hqim92iyuvbEv1f7WqX
K+eIHkn+fpycSPRPwkb3OvKJvnvR6nVTnUSfdNW4JSwwgO8SM6VifDH8B7uN
uqw=
                    "], {{
                    Rational[-15, 2], -90}, {
                    Rational[15, 2], 90}}], {Antialiasing -> False, 
                    AbsoluteThickness[0.1], 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]], 
                    LineBox[
                    NCache[{{
                    Rational[15, 2], -90}, {
                    Rational[-15, 2], -90}, {
                    Rational[-15, 2], 90}, {
                    Rational[15, 2], 90}, {
                    Rational[15, 2], -90}}, {{
                    7.5, -90}, {-7.5, -90}, {-7.5, 90}, {7.5, 90}, {
                    7.5, -90}}]]}, {
                    CapForm[None], {}}, 
                   StyleBox[{Antialiasing -> False, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -90.}, 
                    Offset[{4., 0}, {7.5, -90.}]}, {{
                    7.5, -36.107784431137716`}, 
                    Offset[{4., 0}, {7.5, -36.107784431137716`}]}, {{7.5, 
                    17.784431137724564`}, 
                    Offset[{4., 0}, {7.5, 17.784431137724564`}]}, {{7.5, 
                    71.67664670658684}, 
                    Offset[{4., 0}, {7.5, 71.67664670658684}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -79.22155688622755}, 
                    Offset[{2.5, 0.}, {7.5, -79.22155688622755}]}, {{
                    7.5, -68.44311377245509}, 
                    Offset[{2.5, 0.}, {7.5, -68.44311377245509}]}, {{
                    7.5, -57.66467065868263}, 
                    Offset[{2.5, 0.}, {7.5, -57.66467065868263}]}, {{
                    7.5, -46.88622754491018}, 
                    Offset[{2.5, 0.}, {7.5, -46.88622754491018}]}, {{
                    7.5, -25.329341317365262`}, 
                    Offset[{2.5, 0.}, {7.5, -25.329341317365262`}]}, {{
                    7.5, -14.550898203592814`}, 
                    Offset[{2.5, 0.}, {7.5, -14.550898203592814`}]}, {{
                    7.5, -3.7724550898203493`}, 
                    Offset[{2.5, 0.}, {7.5, -3.7724550898203493`}]}, {{7.5, 
                    7.005988023952106}, 
                    Offset[{2.5, 0.}, {7.5, 7.005988023952106}]}, {{7.5, 
                    28.562874251497036`}, 
                    Offset[{2.5, 0.}, {7.5, 28.562874251497036`}]}, {{7.5, 
                    39.341317365269475`}, 
                    Offset[{2.5, 0.}, {7.5, 39.341317365269475`}]}, {{7.5, 
                    50.11976047904193}, 
                    Offset[{2.5, 0.}, {7.5, 50.11976047904193}]}, {{7.5, 
                    60.89820359281437}, 
                    Offset[{2.5, 0.}, {7.5, 60.89820359281437}]}, {{7.5, 
                    82.4550898203593}, 
                    Offset[{2.5, 0.}, {7.5, 82.4550898203593}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["0.`", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -90.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"0.5\"", ShowStringCharacters -> False], 0.5, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -36.107784431137716`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"1.0\"", ShowStringCharacters -> False], 1., 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 17.784431137724564`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox[
                    TagBox[
                    InterpretationBox[
                    StyleBox["\"1.5\"", ShowStringCharacters -> False], 1.5, 
                    AutoDelete -> True], NumberForm[#, {
                    DirectedInfinity[1], 1}]& ], TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 71.67664670658684}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                    "GraphicsAxes"}, StripOnInput -> False]}, 
                  PlotRangePadding -> Scaled[0.02], PlotRange -> All, Frame -> 
                  True, FrameTicks -> {{False, False}, {True, False}}, 
                  FrameStyle -> Opacity[0], FrameTicksStyle -> Opacity[0], 
                  ImageSize -> {Automatic, 180}, BaseStyle -> {}], Alignment -> 
                 Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]}, "BarLegend", 
            DisplayFunction -> (#& ), 
            InterpretationFunction :> (RowBox[{"BarLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 3.5 (CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IkbB/BxKbvuWrnUqKSitGnLqkhfFCltKqxKmUGJyqgQogvCltqm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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                    "[", "#1", "]"}], "&"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.004173533119316708`", ",", "1.6737366698001679`"}], 
                    "}"}]}], "}"}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
                 RowBox[{"LegendMarkerSize", "\[Rule]", "180"}], ",", 
                 RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
                 RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
                 RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
               "]"}]& )], TraditionalForm], TraditionalForm]}, "Legended", 
        DisplayFunction -> (GridBox[{{
            TagBox[
             ItemBox[
              PaneBox[
               TagBox[#, "SkipImageSizeLevel"], 
               Alignment -> {Center, Baseline}, BaselinePosition -> Baseline],
               DefaultBaseStyle -> "Labeled"], "SkipImageSizeLevel"], 
            ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           AutoDelete -> False, GridBoxItemSize -> Automatic, 
          BaselinePosition -> {1, 1}]& ), 
        InterpretationFunction -> (RowBox[{"Legended", "[", 
           RowBox[{#, ",", 
             RowBox[{"Placed", "[", 
               RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> 
        True]},
      "RowDefault"]},
    {"\<\"Fig. 5. Vector and stream plots of \\!\\(\\*FormBox[SqrtBox[\\\"z\\\
\"], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1819386951,ExpressionUUID->"1a5161fe-482e-468a-9afe-046cebc47cae"]
}, {2}]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->33390695,ExpressionUUID->"ca2cc933-e539-4c5c-8b5e-1b30498eb9f9"],

Cell[TextData[{
 "Draw the branch cuts of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"963d8bb5-dd35-4a8b-a16f-0b3afe24bbf3"],
 "."
}], "SolvedExampleNote",
 CellID->649039036,ExpressionUUID->"db5c1ee4-212d-4907-af1f-1c65284bea3f"],

Cell[TextData[{
 "The branch cuts of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "15a44b5a-1ae6-4ee5-9ae9-6e7215a3adfe"],
 " correspond to the points such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"19ecdbcc-4533-4108-8194-8a2cdf39caac"],
 " lies on the negative real axis:"
}], "SolvedExampleNote",
 CellID->465514197,ExpressionUUID->"f90d421b-7e1f-42ce-af4c-6e84adcd9bef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}], "<", "0"}], ",", "z", ",", 
    "Complexes"}], "]"}], "//", "Simplify"}]], "SolvedExampleInput",
 CellID->87084377,ExpressionUUID->"6d72890a-a3f8-4878-9ef6-fc6a46df4ed2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Im", "[", "z", "]"}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "<", 
     RowBox[{"Re", "[", "z", "]"}], "<", "1"}]}], ")"}], "||", 
  RowBox[{
   RowBox[{"Re", "[", "z", "]"}], "\[Equal]", "0"}]}]], "SolvedExampleOutput",\

 CellID->428907939,ExpressionUUID->"adb8eb87-ccf4-4b4d-a90a-1d07dd208475"]
}, Open  ]],

Cell[TextData[{
 "In words, the branch cut corresponds to either ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5363c6be-f468-457c-83af-f8e63a0e3607"],
 " purely imaginary or to ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f54bbbc2-d9f1-452d-960c-446e48dccc4f"],
 " real between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6d70c746-634e-6545-80bb-13f3e82c0511"],
 " and 1."
}], "SolvedExampleNote",
 CellID->136708361,ExpressionUUID->"1c9d88b3-eaa3-4714-bd21-5ed7275296b9"],

Cell[TextData[{
 "Visualize ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d1126d03-d256-4cfa-8808-519aaea8883e"],
 ":"
}], "SolvedExampleNote",
 CellID->768764923,ExpressionUUID->"758ec263-f3ac-48be-8f7a-29d493f95598"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["3", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["496", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[PlotLegends -> Automatic, AxesLabel -> {
       ToString[
        Re[$CellContext`z], TraditionalForm], 
       ToString[
        Im[$CellContext`z], TraditionalForm]}, AspectRatio -> Automatic],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->269652751,ExpressionUUID->"8d17990e-2f76-4113-8398-2192223baa5a"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJx1nHt8z+X7xzdjs81h6EumnEYRHRYdNHXdVAgl55zPkSgRzUYtOZ/CEqWI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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzNnWeUlfW59rPedy1BNPbus4felF6tOYnpxRajUWNiNBo1djSKYo8Fo1Gx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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnHX8F8Xahje+tsfuxIOCLYqtKAiCCqISKoKiEgqiiEGpCNiB3R3Y2N1i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             "]]}, 
           Annotation[#, 
            "Charting`Private`Tag$28525#1"]& ]]}, {}, {}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0kcyZlEYBuAj59Byi2UqbEAzF2aq5AkGsl/ollrLaQPCBtiAsAE2IFUz
ZAPCgCGevwyeer9Tdeu+55x7K/snWiMxIYQtOuJDiM6/5G5cCBXmBnpY4IAz
bngly8O1tDDMDkdc8MgnZbHeRxdz7HHCFc9k6KmmiVt6dQ/KNvkmhxhmhFHG
GCfCBJNMMc1v/jDDLHPMs8BfFvnHEsussMoa62zwnz7dm7JdvssBGqkinSf7
vuSYXWbppI5SPpz7gXMO2WaIZmrI5MX9XXPKPvN0Ux9d6+jUXW5ukffWZeZS
SijmJ0UUUkA+eeSSww+yo9+ITDJIJ41UUkgmiUQSUBVUBUcId3Hf/8MXMzc3
ng==
          "]]}}}, VertexNormals -> CompressedData["
1:eJx0fHc419/7v5KZjJQSMhukoWRziyKrRRpapGFFJS0hokFRRkaaVAqpSBKH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       "], VertexTextureCoordinates -> CompressedData["
1:eJx1233InlUdwPERGrOiHBXZrLBWUTRqhEqQ60axiRmYCrbeqAkSM6Ra/pFM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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
       FormBox[
        TagBox[
        "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", HoldForm], TraditionalForm], 
       FormBox[
        TagBox[
        "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", HoldForm], TraditionalForm], None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 4.24591025557347}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->172844040,ExpressionUUID->"cdc86d95-8dbb-4ad2-a61b-51e8132f91c1"]
}, Open  ]],

Cell["Its stream plot:", "SolvedExampleNote",
 CellID->320507061,ExpressionUUID->"5c1286b4-da6f-4a64-8238-752f209c9a93"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexStreamPlot", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["168", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[PlotLegends -> Automatic, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->80235005,ExpressionUUID->"e0644346-f454-4a60-9f67-5972c3835654"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}}, {{
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.326668029737394, 0.5223496890979391, -0.5273970726120638], 
           
           ArrowBox[{{0.00001571767120625087, 0.000020871143330096432`}, {
            0.00001574918532591571, 0.04478799708831583}, {
            0.00001581235597504595, 0.08968980648154079}, {
            0.000016013202780433294`, 0.18385007463318373`}, {
            0.000016353047567356552`, 0.279606360107885}, {
            0.00001683544141370988, 0.37780010572583156`}, {
            0.000017463935397387435`, 0.4792727543072107}, {
            0.00001746946379047255, 0.4800208711393056}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3435098055712847, 0.5223196166094195, -0.48714614655909794`], 
           
           ArrowBox[{{0.000017558140737940538`, 0.4920208711389779}, {
            0.00001824466722655007, 0.5849234585455136}, {
            0.000019183774609358626`, 0.6956513711342316}, {
            0.000019799190997072973`, 0.7619584162933881}, {
            0.000020472322804194003`, 0.8303984544640903}, {
            0.000021205121580465623`, 0.9011983506482395}, {
            0.000021971782257335978`, 0.9720208711183508}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3857732116451551, 0.5222441515393171, -0.38613891018425983`], 
           
           ArrowBox[{{0.000022105783784292215`, 0.9840208711176024}, {
            0.00002285752623943632, 1.050785177064487}, {
            0.0000237810352216232, 1.1300258373003882`}, {
            0.000024772017371936327`, 1.2125338155573435`}, {
            0.0000258324242401196, 1.2985359768372544`}, {
            0.00002696701411162939, 1.3883295919864145`}, {
            0.00002794587646500618, 1.4640208710820026`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4466888539110811, 0.5251051532389501, -0.14894729414821506`], 
           
           ArrowBox[{{0.000028101064068913695`, 1.4760208710809992`}, {
            0.0000281814088829105, 1.4822335951878527`}, {
            0.00002947885552018952, 1.5805073464485757`}, {
            0.00003086260098969301, 1.683410205775588}, {
            0.00003233589225764758, 1.791201533175896}, {
            0.00003390197629027978, 1.904140688656504}, {
            0.0000346306112560151, 1.956020871036568}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5172710468253945, 0.5297044126318246, 0.1654981351578235], 
           
           ArrowBox[{{0.00003479914612206294, 1.9680208710353846`}, {
            0.00003556410005381621, 2.0224870322244186`}, {
            0.00003732551051448344, 2.146499923886645}, {
            0.0000391939000296745, 2.2766786264733927`}, {
            0.00004017127832866215, 2.3442719312455904`}, {
            0.000041178328769449, 2.4135962190681637`}, {
            0.00004168059101333294, 2.448020870986051}}]}}, {
          Arrowheads[{{0.010379480869653526`, 1.}}], {
           LABColor[
           0.5916936681634867, 0.5345539210715397, 0.49705276884775457`], 
           
           ArrowBox[{{0.00004185567330437083, 2.4600208709847737`}, {
            0.000042215713687688315`, 2.484697750489479}, {
            0.00004328409541903341, 2.5576227860579044`}, {
            0.0000443841362991376, 2.6324175863218082`}, {
            0.0000455164986636542, 2.7091284118295587`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999987`, 1.}}], {
           LABColor[
           0.7462892287440028, 0.3057808740701552, 0.7889199105453654], 
           
           ArrowBox[{{-2.5425423158936926`, -2.844259990310322}, \
{-2.4868465389367564`, -2.777494761215739}, {-2.43245542908265, \
-2.7121852376385345`}, {-2.3793304729066076`, -2.648284678175681}, \
{-2.3274331569838633`, -2.5857463414241484`}, {-2.274299314226554, \
-2.5215924129255693`}, {-2.235823981047609, -2.475040085585019}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6884708727405563, 0.43762492461870783`, 0.756665464372743], 
           
           ArrowBox[{{-2.2281791525913115`, -2.46579040462437}, \
{-2.2224001363549633`, -2.4587982194160025`}, {-2.1717356233690914`, \
-2.3973637608954483`}, {-2.1223057752689396`, -2.337289037363906}, \
{-2.074110592054507, -2.2785740488213757`}, {-2.027150073725793, \
-2.221218795267857}, {-1.981424220282798, -2.16522327670335}, \
{-1.9369330317255224`, -2.110587493127856}, {-1.9239112356818127`, \
-2.094549536965554}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6252078099248144, 0.5367377612857003, 0.6463591060248625], 
           
           ArrowBox[{{-1.9163472887697712`, -2.0852335986278545`}, \
{-1.8935736587413636`, -2.05718504996175}, {-1.8512432520177184`, \
-2.0048895526254085`}, {-1.7696693373519699`, -1.9036193954420186`}, \
{-1.6922112877282762`, -1.806777021577686}, {-1.6188691031466385`, \
-1.7143624310324115`}, {-1.6160485495951793`, -1.710777567373783}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5445734478815294, 0.5314834849349181, 0.28713101261183455`], 
           
           ArrowBox[{{-1.6086283896851583`, -1.7013467017237107`}, \
{-1.5493100707219793`, -1.625954378173598}, {-1.483201477569222, \
-1.5411316173686473`}, {-1.420543323688367, -1.4598941486175607`}, \
{-1.361335609079414, -1.3822419719203378`}, {-1.3286257716743102`, \
-1.3390748666125718`}, {-1.3153288459768464`, -1.3213929052169537`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.46471647515341336`, 0.5262798646343673, -0.06863379201895092], 
           
           ArrowBox[{{-1.3081165442242926`, -1.311802143858745}, \
{-1.296940662095753, -1.2969406998787654`}, {-1.2392048631034012`, \
-1.2182961217546198`}, {-1.1850057116184762`, -1.143127003238531}, \
{-1.1357497265436187`, -1.0741451616460658`}, {-1.0893821426186288`, \
-1.007832401754552}, {-1.0459029598435066`, -0.9441887235639896}, \
{-1.030156220008887, -0.9205343106899732}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.38849051298686565`, 0.5222392995561171, -0.37964470812103546`], 
           
           ArrowBox[{{-1.023506504954947, -0.9105452521907249}, \
{-1.005312178218252, -0.8832141270743787}, {-0.9673993245272832, \
-0.8245891760318331}, {-0.9319539255550188, -0.7679944341824667}, \
{-0.8989759813014586, -0.7134299015262795}, {-0.8684654917666027, \
-0.6608955780632714}, {-0.8142129366878372, -0.5608202072757853}, \
{-0.7826995645771051, -0.4958274391268201}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3255279234216957, 0.5223517248591575, -0.5301218645495831], 
           
           ArrowBox[{{-0.7774640502000714, -0.4850297824732738}, \
{-0.7685623201535564, -0.4666709703790013}, {-0.7376014507139171, \
-0.3939790431478754}, {-0.7119799380664696, -0.32428358451942835`}, \
{-0.6913374732466382, -0.2568695529172331}, {-0.675313747289847, \
-0.1910219067648631}, {-0.6637970222787594, -0.12629291295280426`}, \
{-0.6569548375067992, -0.06249514345617484}, {-0.6559655221465003, \
-0.046630833339834275`}, {-0.655263690509509, -0.0307870913017688}, \
{-0.6550962517290585, -0.02439534440197047}}]}}, {
          Arrowheads[{{0.0005115523480090757, 1.}}], {
           LABColor[
           0.29089631902896285`, 0.522413562668649, -0.6128895109816422], 
           
           ArrowBox[{{-0.6548109611807633, -0.012398865176997358`}, \
{-0.6547901676117268, -0.01100056145936069}, {-0.6547492686893381, \
-0.007044592731014547}, {-0.6547263015610151, -0.003088816934991771}, \
{-0.6547208435420034, -0.00012204652744707133`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2910302578954886, 0.5224133235088914, -0.6125694043928052], 
           
           ArrowBox[{{0.6534613964062876, -0.0016509439265419649`}, {
            0.6535489784192884, -0.009681859494014858}, {
            0.6548778442729031, -0.04925889299034729}, {
            0.6579943291123301, -0.08897039279751835}, {
            0.6629064434467112, -0.1289241506129871}, {
            0.6723687546420173, -0.1819649470790026}, {
            0.685009059739128, -0.23587124306774387`}, {
            0.7050418801282099, -0.3048145744629868}, {
            0.7302671208008961, -0.3760107308643104}, {
            0.7607601866257168, -0.4498405010842972}, {
            0.7674642024196044, -0.4641783334417543}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3242931995299104, 0.5223539295684724, -0.5330727873355324], 
           
           ArrowBox[{{0.7725469371512881, -0.47504874316942036`}, {
            0.7968306659192678, -0.5269841864609914}, {
            0.8467517762547581, -0.6226400452205885}, {
            0.9052285270266726, -0.7245878003287605}, {
            0.937837317666452, -0.7781889584448578}, {
            0.9729091185956624, -0.8338987295106899}, {
            1.010300265444062, -0.8914958138458167}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.38699098381820135`, 0.5222419770988035, -0.38322850108191286`], 
           
           ArrowBox[{{1.0169592203384161`, -0.9014786900508096}, {
            1.050441751322379, -0.951644110491559}, {
            1.0931128771861298`, -1.0139910091336446`}, {
            1.1386676014718025`, -1.079069098179562}, {
            1.187105924179397, -1.146878377629312}, {
            1.2384278453089137`, -1.217418847482894}, {
            1.2672415803597514`, -1.2566860237488553`}, {
            1.2942643446517679`, -1.293200045197481}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.46291102911320553`, 0.5261622186061569, -0.07667709914446401], 
           
           ArrowBox[{{1.3014714181161835`, -1.3027945011248245`}, {
            1.3625137161534397`, -1.3833195172454011`}, {
            1.4323764700493324`, -1.4741653686045821`}, {
            1.4943033167633581`, -1.554254095442272}, {
            1.559725177148683, -1.6380121779885362`}, {
            1.594908197372051, -1.682645098014333}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5427846061722144, 0.5313669208740094, 0.2791616781944556], 
           
           ArrowBox[{{1.6023369683736355`, -1.6920691821293024`}, {
            1.6286420512053077`, -1.725439616243375}, {
            1.7010539389332309`, -1.8165364102067876`}, {
            1.777292713730703, -1.9117195558887552`}, {
            1.857690248995974, -2.011406049299258}, {
            1.8994485518040336`, -2.06293805140271}, {
            1.902470888155933, -2.066656676745926}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6234266068798257, 0.5366216949735466, 0.6384238020475169], 
           
           ArrowBox[{{1.9100394374795142`, -2.0759688763323028`}, {
            1.9422465447290433`, -2.1155958904382963`}, {
            1.9860842277710022`, -2.169379566406016}, {
            2.0309616009299107`, -2.224289079305869}, {
            2.0769810667570927`, -2.280449465619878}, {
            2.124245027803872, -2.337985761830066}, {
            2.172753484070248, -2.396897967936431}, {
            2.2142870780966173`, -2.447226281330466}}]}}, {
          Arrowheads[{{0.01383809239726281, 1.}}], {
           LABColor[
           0.6871548189035556, 0.44062594160714996`, 0.7559312928988379], 
           
           ArrowBox[{{2.221925067021881, -2.4564816108857848`}, {
            2.22250643555622, -2.457186083938973}, {
            2.2735038822617897`, -2.518850109837694}, {
            2.325745824186957, -2.5818900456325933`}, {
            2.3792322613317207`, -2.6463058913236694`}, {
            2.4339631936960813`, -2.712097646910924}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.7480315790452373, 0.30180776696251715`, 0.789891895013441], 
           
           ArrowBox[{{-2.8174005734135354`, 
            2.6301235060699617`}, {-2.753320787531063, 
            2.5660767378300253`}, {-2.6907023826862693`, 
            2.503384565989726}, {-2.6295453588791533`, 
            2.4420469905490636`}, {-2.569849716109716, 
            2.382064011508038}, {-2.5116154543779565`, 
            2.32343562886665}, {-2.4785873049946816`, 
            2.2901160730397856`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.689917534679598, 0.43432608004750767`, 0.7574724966522498], 
           
           ArrowBox[{{-2.4701393733952797`, 
            2.281593605574795}, {-2.4548425736838766`, 
            2.266161842624899}, {-2.3995310740274745`, 
            2.210242652782785}, {-2.3456809554087514`, 
            2.1556780593403086`}, {-2.2931705214583786`, 
            2.1023446785080884`}, {-2.2418780758070294`, 
            2.0501191264967424`}, {-2.1918036184547023`, 
            1.9990014033062715`}, {-2.1429471494013987`, 
            1.9489915089366763`}, {-2.1335701391045316`, 
            1.93936577854125}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6265312573240307, 0.5368239994377114, 0.6522550971867651], 
           
           ArrowBox[{{-2.1251966357658008`, 
            1.93077017258028}, {-2.0953086686471174`, 
            1.9000894433879552`}, {-2.04888817619186, 
            1.8522952066601093`}, {-1.9597011561784128`, 
            1.7600302196670423`}, {-1.8749903185759667`, 
            1.6717855240725568`}, {-1.794359892599429, 
            1.587150095991734}, {-1.7923010587658526`, 
            1.5849708749661653`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5447867841670351, 0.5314973863011755, 0.28808143108301726`], 
           
           ArrowBox[{{-1.7840601364964679`, 
            1.5762480772412402`}, {-1.7178098782488012`, 
            1.506123935424574}, {-1.6453402755240827`, 
            1.4287070423710766`}, {-1.605145592679624, 
            1.385554453894562}, {-1.5661681689702958`, 
            1.3434525741094818`}, {-1.4965273534943708`, 
            1.2667918129166698`}, {-1.4581146793049815`, 
            1.2239113123013885`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4632678553036007, 0.5261854700260976, -0.07508742956926891], 
           
           ArrowBox[{{-1.450107827530923, 
            1.2149731735315856`}, {-1.4308903474489192`, 
            1.1935204841817735`}, {-1.3698240095365866`, 
            1.1248237226296445`}, {-1.3121612272102121`, 
            1.0588709462785306`}, {-1.2579020004697954`, 
            0.9956621551284321}, {-1.2070463293153368`, 
            0.9351973491793492}, {-1.1593361562284152`, 
            0.8771668607387376}, {-1.137917225529457, 0.850451771868168}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.38478189075389524`, 0.5222459216309283, -0.38850811306894417`], 
           
           ArrowBox[{{-1.1304108757422542`, 
            0.8410893623026683}, {-1.1145134236906098`, 
            0.8212610221140538}, {-1.0725781317019207`, 
            0.7674798333052981}, {-1.0335302802623476`, 
            0.7158232943124699}, {-0.9633013518130991, 
            0.6178286760958422}, {-0.9030310911254131, 
            0.5262216777854158}, {-0.8612594764668785, 
            0.45622703146230453`}, {-0.856582446417983, 
            0.4474962160673269}}]}}, {
          Arrowheads[{{0.013149685405883287`, 1.}}], {
           LABColor[
           0.31751801003172575`, 0.5223660272718507, -0.5492651208623507], 
           
           ArrowBox[{{-0.8509159706705076, 
            0.4369183593560988}, {-0.8255495290394033, 
            0.3895657195839969}, {-0.7954422211640214, 
            0.3255630443153562}, {-0.7704785251617671, 
            0.26354430782124577`}, {-0.7358462845750884, 
            0.1441781571172366}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.288387888855512, 0.5224180416938027, -0.6188845223400896], 
           
           ArrowBox[{{0.6791890616292403, 0.05215338524450483}, {
            0.682696605487251, 0.09139279171569598}, {0.6955695087819801, 
            0.17104779915969526`}, {0.716325081568995, 0.252626610668637}, {
            0.734950301452699, 0.3085485066795578}, {0.7572992846640705, 
            0.36603784981224663`}, {0.7904065844713157, 0.4407286791439067}, {
            0.8234250235583248, 0.5063004130120304}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.32922061696016897`, 0.5223451312264469, -0.5212965283131125], 
           
           ArrowBox[{{0.8288219768002488, 0.5170182904000437}, {
            0.8297826705210122, 0.5189261441547495}, {0.8755914728241115, 
            0.6010739336707105}, {0.9283179661214905, 0.6879860052683202}, {
            0.9606709257309274, 0.7384269088053403}, {0.995437413615039, 
            0.7907851837743284}, {1.0326174297738255`, 0.8450608301752843}, {
            1.0722109742072872`, 0.9012538480082083}, {1.0867673114177427`, 
            0.9213906546669365}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.39473660727311166`, 0.5222281465992931, -0.3647168833052208], 
           ArrowBox[{{1.093797351510831, 0.9311158043464824}, {
            1.1144197258339117`, 0.9596441874543922}, {1.1594453635721877`, 
            1.020511798695128}, {1.207287887422115, 1.0838566817304158`}, {
            1.2579472973836932`, 1.1496788365602553`}, {1.3116782451244127`, 
            1.2183065610673014`}, {1.3687353823117627`, 1.290068153134209}, {
            1.3861878258170004`, 1.3117150025345103`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.47302247997051605`, 0.5268210984653804, -0.03163033345961463], 
           
           ArrowBox[{{1.3937196279434911`, 1.3210569486233823`}, {
            1.4291187089457442`, 1.3649636127609786`}, {1.4928282250263563`, 
            1.4429929399476091`}, {1.528680129586144, 1.4866454347217304`}, {
            1.5656137052164736`, 1.5313498013840519`}, {1.642721154605729, 
            1.623178997123382}, {1.6999398821238734`, 
            1.6906693574703533`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5535422498088698, 0.5320679077872547, 0.32708724882324147`], 
           
           ArrowBox[{{1.7076999977851863`, 1.6998225320520515`}, {
            1.7244266745655044`, 1.7195519020027026`}, {1.7999272803622128`, 
            1.808265067948507}, {1.8794817020062944`, 1.9010778750131394`}, {
            1.9630899394977503`, 1.9979903231966005`}, {2.0064142391862436`, 
            2.047983912707892}, {2.020355185283012, 2.0640254596282306`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6346404062040666, 0.5373524057908549, 0.6883815576381291], 
           
           ArrowBox[{{2.028226684996895, 2.073083025098838}, {
            2.05075199283658, 2.09900241249889}, {2.096199862903679, 
            2.15115709346817}, {2.14285451184246, 2.204559226514307}, {
            2.190715939652921, 2.2592088116373006`}, {2.2397841463350643`, 
            2.3151058488371508`}, {2.290059131888889, 2.372250338113857}, {
            2.3415408963143953`, 2.430642279467421}, {2.344579265365522, 
            2.4340814803996778`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6953711949256863, 0.4218900180965757, 0.7605148659448105], 
           
           ArrowBox[{{2.352524281002745, 2.4430746292655803`}, {
            2.394229439611583, 2.4902816728978405`}, {2.4481247617804516`, 
            2.551168518405117}, {2.503345170011897, 2.6134362739599593`}, {
            2.5600089714968135`, 2.677218397533077}, {2.6181161662352017`, 
            2.742514889124471}, {2.6711772707690704`, 2.8020450822811}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.32677464961211905`, 0.522349498718671, -0.5271422569242372], 
           
           ArrowBox[{{0.015034235519822406`, -0.040996960623742654`}, {
            0.015169043783020617`, -0.1403561843248837}, {
            0.015452070724394947`, -0.2410867063365726}, {
            0.015689280558343614`, -0.30049070816803625`}, {
            0.015978164432527486`, -0.36089821231521546`}, {
            0.016464750539003252`, -0.4478618182237597}, {
            0.01694575880722976, -0.5209923640390878}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.34620529456550875`, 0.5223148035741059, -0.4807040748171875], 
           
           ArrowBox[{{0.017024685804176005`, -0.5329921044749952}, {
            0.01705381355223988, -0.5374205691293275}, {
            0.017754145209843985`, -0.6304899961257061}, {
            0.018574537249422186`, -0.7279856303066834}, {
            0.019165762777791598`, -0.7930698347390183}, {
            0.019810149767097718`, -0.8604633727318554}, {
            0.020507698217340553`, -0.9301662442851948}, {
            0.0212584081285201, -1.0021784493990367`}, {
            0.02137514919022925, -1.0129721218583652`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.38999967779670236`, 0.5222366048081365, -0.3760378865030776], 
           
           ArrowBox[{{0.02150492993124116, -1.0249714200444784`}, {
            0.022066542947769847`, -1.0768971680251571`}, {
            0.022936366122223273`, -1.1547195801153318`}, {
            0.023867877651880393`, -1.2356456856695615`}, {
            0.024861077536741192`, -1.3196754846878458`}, {
            0.02592152085981494, -1.4072729388147154`}, {
            0.027054762704110898`, -1.4989020096947012`}, {
            0.027130866207091934`, -1.5049383859509187`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4523659511073911, 0.5254750828419603, -0.12365568458781281`], 
           
           ArrowBox[{{0.027282143964871566`, -1.5169374323730307`}, {
            0.028260803069629074`, -1.594562697327804}, {
            0.02953964195636946, -1.6942550017140225`}, {
            0.030253251359795934`, -1.749438822087871}, {
            0.030990032521409035`, -1.8059612312333801`}, {
            0.03185898202979577, -1.8713190694539736`}, {
            0.032758209562594724`, -1.9384466967044318`}, {
            0.03354681750169054, -1.996896527103649}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5233370414341764, 0.5300996834718145, 0.1925222923874262], 
           
           ArrowBox[{{0.03370882977481678, -2.0088954333831848`}, {
            0.03465491327050258, -2.0785486713316845`}, {
            0.03623385577141768, -2.1945923148105533`}, {
            0.03790463160564621, -2.3162461780713866`}, {
            0.039667240773188166`, -2.4435102611141857`}, {
            0.040298854507343475`, -2.488850189837718}}]}}, {
          Arrowheads[{{0.015032556040113526`, 1.}}], {
           LABColor[
           0.5980196193534338, 0.5349661311379591, 0.5252350391281185], 
           
           ArrowBox[{{0.0404660058394094, -2.5008490256325855`}, {
            0.04058298285695167, -2.509246135053822}, {
            0.041521683274043535`, -2.5763845639389493`}, {
            0.042485639547684154`, -2.64508997397011}, {
            0.04347714920109391, -2.7155267913478456`}, {
            0.04449621223427281, -2.7876950160721568`}, {
            0.04554282864722087, -2.8615946481430425`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
           
           ArrowBox[{{1.0013458660190648`, -0.001102692180202161}, {
            1.0067145850426298`, -0.0023464831698987694`}, {
            1.015962902631119, -0.0035971018316858713`}, {
            1.0291253822112578`, -0.0048612619789147596`}, {
            1.0322306845148426`, -0.00511609230147135}, {
            1.0347465376911942`, -0.005314125140361614}, {
            1.1365093364086947`, -0.010568198345350027`}, {
            1.2062600716328866`, -0.013227044183025729`}, {
            1.2920480444435636`, -0.016059213131409997`}, {
            1.3951650312057313`, -0.019104407091357876`}, {
            1.4807314213555762`, -0.0214224318723253}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.3423803750480322, 0.522321633308061, -0.4898454239347009], 
           
           ArrowBox[{{1.492727020450349, -0.021747397035814606`}, {
            1.516902808284396, -0.02240232796372442}, {
            1.5851921077650588`, -0.024157739585741075`}, {
            1.6590118339701343`, -0.02599969012321516}, {
            1.738361986899623, -0.02792817957614668}, {
            1.8232425665535243`, -0.02994320794453564}, {
            1.8680572471419947`, -0.03099564818677812}, {
            1.914439026426035, -0.03207414441975014}, {
            1.9725854594555539`, -0.033391351194236044`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4352928282748282, 0.5243625682357806, -0.19971687250241058`], 
           
           ArrowBox[{{1.9845823816165842`, -0.033663120696166914`}, {
            2.005934470900711, -0.034146815313172936`}, {
            2.1032949347965646`, -0.036319087172222354`}, {
            2.203715294139376, -0.0385448309670285}, {
            2.3102554443761045`, -0.04087751863334813}, {
            2.423214916178436, -0.04332374384365277}, {
            2.4644665085792434`, -0.04420833418297686}}]}}, {
          Arrowheads[{{0.013641028213315885`, 1.}}], {
           LABColor[
           0.5269646791912649, 0.530336066705876, 0.20868350904556116`], 
           
           ArrowBox[{{2.476463750514529, -0.0444656004773631}, {
            2.542893240218058, -0.04589010027041401}, {
            2.669632483758919, -0.048583885026513104`}, {
            2.735778225566295, -0.049981299445394846`}, {
            2.8037747140649683`, -0.05141239522483138}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.5729249540058425, 0.5333309187629189, 0.41343767930261316`], 
           
           ArrowBox[{{-2.727947444746799, -0.1326984371609785}, \
{-2.6604116214456113`, -0.12889713122115543`}, {-2.5948503674733088`, \
-0.12519189041678408`}, {-2.4696515675153625`, -0.11806960421439686`}, \
{-2.351646002119863, -0.11129123915528889`}, {-2.2487292214398793`, \
-0.10531581279000345`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4835642246599409, 0.5275080170248388, 0.015333401976106883`], 
           
           ArrowBox[{{-2.2367495337110848`, -0.10461791030415397`}, \
{-2.1350994467569158`, -0.09864525427132687}, {-2.0365584567894683`, \
-0.09277763444647283}, {-1.9845299640385878`, -0.08965700844765061}, \
{-1.9342587932578466`, -0.08661566259157337}, {-1.8461200081766196`, \
-0.08114088436856663}, {-1.7636036256547702`, -0.07591432375850742}, \
{-1.7576322790933758`, -0.07553173793736216}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.39043895417853836`, 0.5222358204410912, -0.37498803989922275`], 
           
           ArrowBox[{{-1.7456568335236808`, -0.07476446783676494}, \
{-1.6838108045649676`, -0.07080197570363098}, {-1.6094651063392584`, \
-0.06591805275912012}, {-1.5403278997398098`, -0.061247082722371865`}, \
{-1.4761605535287885`, -0.05677359339078324}, {-1.3619337824367637`, \
-0.0483626148030238}, {-1.2902878150548511`, -0.0426650361782871}, \
{-1.2668792658843833`, -0.040649814960928295`}}]}}, {
          Arrowheads[{{0.010657770309898049`, 1.}}], {
           LABColor[
           0.2917261622289906, 0.522412080909816, -0.610906230975465], 
           
           ArrowBox[{{-1.2549234882371243`, -0.03962055267690873}, \
{-1.2276179898001176`, -0.03726984655667488}, {-1.1732912922303294`, \
-0.03212987937680262}, {-1.1266747079032537`, -0.027197968077285768`}, \
{-1.0874356857257743`, -0.02244046717500669}, {-1.0556058143075047`, \
-0.017836918021769798`}, {-1.0309640337995627`, -0.013353615717898455`}, \
{-1.0133297263348207`, -0.008962732249592277}, {-1.0022019961259703`, \
-0.004398392548476631}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6639424342871726, 0.4935574848446023, 0.7429820729296174], 
           
           ArrowBox[{{-1.2215101007294114`, 
            2.766701830718952}, {-1.1944892418873274`, 
            2.698610261239907}, {-1.1680923974968147`, 
            2.6319166515608265`}, {-1.1423195675578732`, 
            2.5666210016817104`}, {-1.117170752070503, 
            2.5027233116025585`}, {-1.0926459510347042`, 
            2.4402235813233704`}, {-1.068745164450477, 
            2.3791218108441474`}, {-1.0457501726576148`, 
            2.320039316204597}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5937296192084719, 0.5346865872098454, 0.5061229815168855], 
           
           ArrowBox[{{-1.0413977816544226`, 
            2.308856441236355}, {-1.0228156346367363`, 
            2.261112149285594}, {-0.9972982686827856, 
            2.1953141980850566`}, {-0.9725248325770507, 
            2.1311542090949516`}, {-0.9290258470745862, 
            2.016974407875863}, {-0.8878699998978006, 
            1.9078784225162007`}, {-0.8700840720109291, 
            1.860473260968517}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5171906934423296, 0.5296991766645565, 0.16514015883276556`], 
           
           ArrowBox[{{-0.8658687223037068, 
            1.8492380116679532`}, {-0.8488872762849657, 
            1.8039770504770614`}, {-0.8119520498007182, 
            1.7043713749131704`}, {-0.7770643204450581, 
            1.6090613958245283`}, {-0.744224088217985, 
            1.5180471132111335`}, {-0.7132691068282021, 
            1.4308761758688424`}, {-0.7018479850622228, 
            1.3981428120321202`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4435635013918949, 0.5249014997912971, -0.16287081754768334`], 
           
           ArrowBox[{{-0.6978947457394122, 
            1.3868126796914728`}, {-0.6840371299844119, 
            1.3470962325935092`}, {-0.6565281576866149, 
            1.266707283385135}, {-0.6307421899348105, 
            1.1897093282437188`}, {-0.6065514745927753, 
            1.1157194878255656`}, {-0.5838282595242856, 
            1.0443548827869802`}, {-0.5625725447293414, 
            0.9756155131279625}, {-0.5490732091770905, 
            0.9305130667996321}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3790994795599468, 0.5222560680814617, -0.4020887660253806], 
           
           ArrowBox[{{-0.545632377539984, 
            0.9190169510362498}, {-0.5427843302079427, 
            0.9095013788485126}, {-0.513423570037124, 
            0.8064180077025304}, {-0.4876484023381907, 
            0.7091025722379249}, {-0.4651497846366041, 
            0.6165596696109288}, {-0.44561867445782577`, 
            0.5277938969777741}, {-0.43107423917755816`, 
            0.4531114485675872}}]}}, {
          Arrowheads[{{0.018440333932871197`, 1.}}], {
           LABColor[
           0.33238605347135053`, 0.5223394790580485, -0.5137313076265541], 
           
           ArrowBox[{{-0.4288065832867753, 
            0.44132799844476767`}, {-0.4152323399305018, 
            0.35980960091477404`}, {-0.4042953451241089, 
            0.27976767805197283`}, {-0.3960361252798344, 
            0.20158140249249398`}, {-0.3904047094709996, 
            0.12470592866015272`}, {-0.3874234180801937, 
            0.04865872479339931}, {-0.3870859763115415, 
            0.02971865908478314}, {-0.3869115995052243, 
            0.010791064128240985`}, {-0.3868934641609971, 
            0.006060186649595932}, {-0.3868855114467867, 
            0.0013294686724558066`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.31681695070305294`, 0.5223672790756284, -0.5509406144371056], 
           
           ArrowBox[{{0.36034279940730196`, 0.00033580618438027544`}, {
            0.36034439141349944`, 0.00279311736187965}, {0.360366289832219, 
            0.010656727413804}, {0.3604137959115268, 0.018521094732618128`}, {
            0.36048691289155177`, 0.026386768841803618`}, {
            0.36052333198260894`, 0.029533538904353875`}, {
            0.36056385007184955`, 0.03268064475077813}, {0.36063472919541956`,
             0.037559401816399884`}, {0.3640248679145883, 
            0.13364452185375617`}, {0.37123213048688297`, 
            0.23113019319414643`}, {0.3823554612526861, 0.331052198493325}, {
            0.3974938045523806, 0.43444632040704656`}, {0.4050339211877312, 
            0.4776356361843445}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3370051212967257, 0.5223312313016646, -0.5026919873490165], 
           
           ArrowBox[{{0.40709770105884674`, 0.4894568380117214}, {
            0.4089427548457769, 0.5000251905298015}, {0.42201147362169844`, 
            0.5675958822723367}, {0.4432277104897775, 0.6671280963003847}, {
            0.4679521496126677, 0.7719469022765555}, {0.4962935251920564, 
            0.8826369294312656}, {0.5165781204505455, 
            0.9566314666228668}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3847011150831986, 0.5222460658630719, -0.3887011625181328], 
           
           ArrowBox[{{0.5197507053393942, 0.9682044828728791}, {
            0.5285489066878448, 1.0002987311731835`}, {0.548232961134192, 
            1.0689195546344208`}, {0.5692987156487992, 1.1403080421363296`}, {
            0.591746170231667, 1.21446419367891}, {0.615575324882795, 
            1.2913880092621615`}, {0.6409073529383023, 1.371463920044392}, {
            0.6589818582647524, 1.4275274772155433`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.44999530662943293`, 0.5253206074929776, -0.1342169648459723], 
           
           ArrowBox[{{0.6626639517220552, 1.438948606221543}, {
            0.6678634277343076, 1.455076357183909}, {0.6964435492708113, 
            1.5422253206807124`}, {0.7266477175478131, 1.6329108105348025`}, {
            0.7586278041991559, 1.727585649413097}, {0.7925356808586823, 
            1.8267026599825145`}, {0.8157763672669103, 
            1.8938644209712778`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.5235556239309314, 0.5301139266903914, 0.19349608286053263`], 
           
           ArrowBox[{{0.8197005457342573, 1.9052046512756593`}, {
            0.8283713475263927, 1.9302618422430555`}, {0.8661348042022865, 
            2.038263196194719}, {0.8873917613445715, 2.0987629096336464`}, {
            0.9092783240580198, 2.1607512318380815`}, {0.9318577219581936, 
            2.223984218125694}, {0.9550780104997891, 2.2887419935084146`}, {
            0.9789904078785242, 2.3551648575296675`}, {0.9798989186632748, 
            2.357678993519524}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6000060644350619, 0.5350955713809279, 0.5340847014961282], 
           
           ArrowBox[{{0.9839771473344793, 2.368964738993588}, {
            1.0035778413624932`, 2.4232060436749787`}, {1.025648550188831, 
            2.484298281402389}, {1.0483139394335057`, 2.5468432197327773`}, {
            1.0715740090965162`, 2.6108408586661422`}, {1.095428759177863, 
            2.6762911982024846`}, {1.1198781896775465`, 
            2.7431942383418058`}, {1.144922300595566, 2.811549979084103}, {
            1.1480453790743463`, 2.8200533924448368`}}]}}, {
          Arrowheads[{{0.005385226802840085, 1.}}], {
           LABColor[
           0.6684058711911441, 0.4833794437956243, 0.7454720379738581], 
           
           ArrowBox[{{1.1521824598459705`, 2.8313176972475778`}, {
            1.1705610919319218`, 2.881358420429379}, {1.1967945636866137`, 
            2.9526195623776315`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.24697566852370278`, 0.5224919868960654, -0.717857471196856], 
           
           ArrowBox[{{0.9244593121733758, -0.07741913371330743}, {
            0.951790428992864, -0.12957650803892443`}, {
            0.9931511612076975, -0.18363071430600245`}, {
            1.0195748650335006`, -0.21164257431949052`}, {
            1.049779577000478, -0.24043233508531067`}, {
            1.0988762927532978`, -0.282721876070246}, {
            1.1560918139451237`, -0.32711778552581633`}, {
            1.221644190046396, -0.3738473024910113}, {
            1.2675417962097504`, -0.40432518079708274`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.337006018156919, 0.5223312297002409, -0.5026898439020502], 
           
           ArrowBox[{{1.277538499074048, -0.410963398317091}, {
            1.2961842519794249`, -0.42334493703945}, {
            1.3441847146542898`, -0.453715715189951}, {
            1.39570278954763, -0.48530936744590736`}, {
            1.450738476659446, -0.518125893807319}, {
            1.509291775989738, -0.5521652942741864}, {
            1.5716729305689179`, -0.5876040782011444}, {
            1.638192183427397, -0.6246187549428277}, {
            1.691471067474463, -0.653717814666945}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.42239050900184005`, 0.5235218304993066, -0.25719702656568266`], 
           
           ArrowBox[{{1.7020026675428253`, -0.6594698056266105}, {
            1.7088495345651769`, -0.6632093244992373}, {
            1.7836449839822566`, -0.7033757868703725}, {
            1.8629691550063872`, -0.7453267802659664}, {
            1.9472126709653188`, -0.7892709428957516}, {
            2.0363755318590524`, -0.8352082747597289}, {
            2.1274829477451864`, -0.8816232589613131}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[0.510903524252794, 0.5292894937012534, 0.137130663331212], 
           
           ArrowBox[{{2.1381836230450526`, -0.8870542274917707}, {
            2.1831035536879546`, -0.9098194909782749}, {
            2.237335767781053, -0.937161580889747}, {
            2.2954114945230817`, -0.9660827976818953}, {
            2.3552231815002598`, -0.9957315602350205}, {
            2.4169165162399207`, -1.0261784895539032`}, {
            2.480442936232953, -1.0574000453036168`}, {
            2.568137442007436, -1.1004440458360496`}}]}}, {
          Arrowheads[{{0.0177233523737213, 1.}}], {
           LABColor[
           0.5969235743041136, 0.5348947109216133, 0.5203521311049768], 
           
           ArrowBox[{{2.5789097463092086`, -1.1057315272809356`}, {
            2.591739366027036, -1.1120288221124408`}, {
            2.70902965064491, -1.169244024491278}, {
            2.76992248851277, -1.198821535269452}, {
            2.8323137900865762`, -1.2290456524401285`}, {
            2.896203555366331, -1.2599163760033087`}, {
            2.9615917843520343`, -1.2914337059589922`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2504209539505907, 0.5224858350325404, -0.7096234268587303], 
           
           ArrowBox[{{0.9485341229187366, 0.10624155389538478`}, {
            0.9854914896091558, 0.157699267085514}, {1.0097608611154882`, 
            0.18427542049643314`}, {1.0378320095055114`, 
            0.2115368479610965}, {1.1353284973442763`, 
            0.29130235481086464`}, {1.195857984737565, 0.3340978330540199}, {
            1.2648879558489703`, 0.3792876555390996}, {1.3151915844127469`, 
            0.40996636389295427`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.343754257849607, 0.522319180118137, -0.4865619189411035], 
           
           ArrowBox[{{1.325436616678621, 0.4162145087273193}, {
            1.3598661042429843`, 0.4372120438538484}, {1.4688030468714932`, 
            0.49962302401384395`}, {1.528809954988266, 0.5326786127853449}, {
            1.5929143395928278`, 0.5671911030172285}, {1.661116200685179, 
            0.6031604947094951}, {1.733415538265319, 0.6405867878621445}, {
            1.7461535271523525`, 0.647070326956869}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.42993808761681523`, 0.5240136439497689, -0.22357237564716928`], 
           
           ArrowBox[{{1.756847910589705, 0.6525136864797078}, {
            1.8101970866410313`, 0.6796680097930373}, {1.8918455801200982`, 
            0.7206021878200342}, {1.9783610187025211`, 0.7633893219431355}, {
            2.069743402388299, 0.8080294121623406}, {2.1207695565365, 
            0.8328129277604354}, {2.1733563537069838`, 0.8582095709365023}, {
            2.1873177624240956`, 0.8648436222440169}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5185117975337126, 0.5297852621225223, 0.17102571049984414`], 
           
           ArrowBox[{{2.1981563756461484`, 0.8699938128640562}, {
            2.2901884850321017`, 0.913724767811095}, {2.3514235142611972`, 
            0.9426064018933926}, {2.414537852534651, 0.9722373930723579}, {
            2.5230570847590577`, 1.0231160489643598`}, {2.6325862687388444`, 
            1.0741235681138384`}}]}}, {
          Arrowheads[{{0.011043841020443807`, 1.}}], {
           LABColor[
           0.6046208818499136, 0.5353962809716235, 0.554643828143605], 
           
           ArrowBox[{{2.643469417027965, 1.0791789584420861`}, {
            2.696934397756404, 1.1039623105117058`}, {2.7578530926650493`, 
            1.1321186050833127`}, {2.820251582861793, 1.1608786700161653`}, {
            2.8841298683466348`, 1.1902425053102637`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.648180591893952, 0.5294994466863782, 0.7341891993130935], 
           
           ArrowBox[{{-2.8253135679258277`, -1.2921756596205833`}, \
{-2.7622044843251556`, -1.2600050268390437`}, {-2.7005688847674683`, \
-1.2285007288814405`}, {-2.640406769252764, -1.1976627657477739`}, \
{-2.5817181377810443`, -1.1674911374380437`}, {-2.468761326966557, \
-1.1091468852903927`}, {-2.398483303192087, -1.0725982312942517`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5647712245585085, 0.5327996074618783, 0.3771126113123792], 
           
           ArrowBox[{{-2.38783695468015, -1.0670615117454236`}, \
{-2.361698452324006, -1.0534679724384877`}, {-2.302248785908348, \
-1.0224365370288748`}, {-2.2445540318303245`, -0.9921842770656468}, \
{-2.1405263611972045`, -0.9368644284448112}, {-2.0423286203120647`, \
-0.8840980887219019}, {-1.9640028761507544`, -0.8417670439672426}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.47826148137145813`, 0.5271624809785564, -0.0082904515909102], 
           
           ArrowBox[{{-1.9534459923323044`, -0.8360615900813759}, \
{-1.9511269545372454`, -0.8348082691746735}, {-1.8648284013480627`, \
-0.7875875156299073}, {-1.7834329607445176`, -0.7424358280876033}, \
{-1.7069406327266092`, -0.6993532065477616}, {-1.6349578768612187`, \
-0.6581160729162672}, {-1.5670911527152263`, -0.6185008490990049}, \
{-1.5356686191896693`, -0.5997740535527154}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3903018137320579, 0.5222360653175545, -0.37531579808960597`], 
           
           ArrowBox[{{-1.5253604088125614`, -0.5936306995159304}, \
{-1.5033404602886322`, -0.5805075350959751}, {-1.4437057995814364`, \
-0.5441361309071776}, {-1.3355503903299506`, -0.47550616220106634`}, \
{-1.2413907419654788`, -0.4118580532094576}, {-1.1757825119518854`, \
-0.3642472479380527}, {-1.127212824642802, -0.3261865309585479}}]}}, {
          Arrowheads[{{0.01298194430324339, 1.}}], {
           LABColor[
           0.30512765777382955`, 0.5223881513477026, -0.5788773872540691], 
           
           ArrowBox[{{-1.1177885048394687`, -0.31875917530402903`}, \
{-1.0684103221266115`, -0.27639610799385844`}, {-1.0252445222103712`, \
-0.23523902709982217`}, {-0.9587516946775588, -0.15718076827844116`}, \
{-0.9178757341428944, -0.08342587661463784}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3176594103670082, 0.522365774788977, -0.5489271817699738], 
           
           ArrowBox[{{0.35346197765547066`, -0.06678127383031857}, {
            0.35791371902976155`, -0.1635926855397583}, {
            0.3661264149305149, -0.26212224825796004`}, {
            0.37820964287219505`, -0.3634209053491051}, {
            0.3942729803692665, -0.46853960017737467`}, {
            0.40627524730686404`, -0.5353720106640069}, {
            0.40781647197330273`, -0.5431790738285005}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.34253749348556717`, 0.522321352759118, -0.4894699194348696], 
           
           ArrowBox[{{0.4101405864211418, -0.5549518599062879}, {
            0.41989075174219165`, -0.6043412566524374}, {
            0.4419494625011319, -0.7064212243282797}, {
            0.46753552003517024`, -0.8141458925488072}, {
            0.4967644633996382, -0.9281200921560337}, {
            0.5223012031860369, -1.0215296261108386`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3922430228470642, 0.5222325991160445, -0.3706764141367434], 
           
           ArrowBox[{{0.525465694773565, -1.0331048579872402`}, {
            0.5299442399859483, -1.0494866993884306`}, {
            0.5500238060642556, -1.1198862943188697`}, {
            0.5714838279854404, -1.1931681657439577`}, {
            0.594324305749503, -1.269332313663695}, {
            0.6185452393564431, -1.3483787380780816`}, {
            0.6442691183996706, -1.430700752457294}, {
            0.6639740237939682, -1.4926563428527173`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.45949286475336776`, 0.5259394850257839, -0.0919051065949076], 
           
           ArrowBox[{{0.6676110870672489, -1.5040918914073846`}, {
            0.6716184324725953, -1.5166916702715083`}, {
            0.7005931815752173, -1.6063514915207249`}, {
            0.7311933657075365, -1.6996802162049438`}, {
            0.7635720588558357, -1.7971417034089314`}, {
            0.7978823350063977, -1.8991998122174525`}, {
            0.8184624428203182, -1.9597641955596417`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5334521892188971, 0.5307588042293074, 0.2375855279760663], 
           
           ArrowBox[{{0.8223232941921557, -1.9711261419899229`}, {
            0.8341241941592225, -2.005854542630508}, {
            0.87229763631431, -2.117105894648098}, {
            0.8937895552386315, -2.179457655764418}, {
            0.9159131678846706, -2.2433493363596337`}, {
            0.9386020882457234, -2.308186668137356}, {
            0.961927244197384, -2.374584036831514}, {
            0.9795749231637856, -2.4246336134677366`}}]}}, {
          Arrowheads[{{0.01491102391691042, 1.}}], {
           LABColor[
           0.6100980565273058, 0.5357531832729163, 0.5790447778974277], 
           
           ArrowBox[{{0.9835653708298051, -2.435950694691478}, {
            0.9859393004975745, -2.4426832613401706`}, {
            1.0106213688936547`, -2.512437068697306}, {
            1.0328883837049807`, -2.5753802567401607`}, {
            1.055751694011253, -2.63982212726919}, {
            1.0792112998124717`, -2.705762680284393}, {
            1.1032672011086366`, -2.773201915785771}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6281499109818064, 0.5369294737469097, 0.6594662395911244], 
           
           ArrowBox[{{-2.8253729118567783`, 
            1.015666841082907}, {-2.761465136155965, 
            0.9898336534798553}, {-2.6990807856708208`, 
            0.9645413288897251}, {-2.578882360347536, 
            0.915579268748228}, {-2.4647776358869247`, 
            0.8687806606584166}, {-2.3810131240477364`, 
            0.8341652859322484}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5421660426166552, 0.5313266141886327, 0.27640596213138285`], 
           
           ArrowBox[{{-2.3699227807817773`, 
            0.8295822425936801}, {-2.3567666122889865`, 
            0.8241455046202905}, {-2.29705404082334, 
            0.7993686000468161}, {-2.239140918790946, 
            0.7752176784175722}, {-2.130833125172817, 
            0.7293251085243475}, {-2.0289746953432264`, 
            0.6856425028979302}, {-1.9374110627383707`, 
            0.6461187419778599}, {-1.928086045050637, 
            0.6420367843511496}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.45384095410087394`, 0.5255711966221107, -0.11708450947461586`], 
           
           ArrowBox[{{-1.9170931366330641`, 
            0.6372247198749755}, {-1.8509405169639659`, 
            0.6082668991578801}, {-1.7695630580200132`, 
            0.5720869744379911}, {-1.6932786859065112`, 
            0.5375789678181924}, {-1.6216769343512665`, 
            0.5045552408262161}, {-1.5543473370820846`, 
            0.4728281549897937}, {-1.4912898940989663`, 
            0.4423977103089255}, {-1.4808013085569551`, 
            0.43719960042102246`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.36546713113727314`, 0.5222804098519187, -0.43466933553902576`], 
           
           ArrowBox[{{-1.4700493119996103`, 
            0.4318709448653643}, {-1.43250460540191, 
            0.41326390678361125`}, {-1.3264768922491874`, 
            0.35825559162153037`}, {-1.2349905990071175`, 
            0.30717257792543656`}, {-1.172522201841853, 
            0.269283417430001}, {-1.1184087751189369`, 
            0.23338357325295392`}, {-1.0719532617826881`, 
            0.1991004410903965}, {-1.0580458488121942`, 
            0.1874662760656304}}]}}, {
          Arrowheads[{{0.004473422135852154, 1.}}], {
           LABColor[
           0.27078454711082106`, 0.5224494740259834, -0.6609555494003612], 
           
           ArrowBox[{{-1.0488417440871243`, 
            0.17976663606041302`}, {-1.032458604777427, 
            0.16606141663843}, {-0.973897435445584, 
            0.1030773432482917}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6611348691177016, 0.4999596171380218, 0.7414158495726365], 
           
           ArrowBox[{{-1.0585015244105966`, -2.794233266990597}, \
{-1.034980711703547, -2.72500710591607}, {-1.012006559851256, \
-2.657207865189928}, {-0.9895790688537235, -2.59083554481217}, \
{-0.9676982387109494, -2.525890144782795}, {-0.9463640694229342, \
-2.4623716651018057`}, {-0.9255765609896773, -2.400280105769201}, \
{-0.9052815429926673, -2.3393456268511086`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5901948354034047, 0.5344562545020336, 0.4903754315301945], 
           
           ArrowBox[{{-0.9014895803091767, -2.3279605041461475`}, \
{-0.8856415266874393, -2.2803777481491427`}, {-0.8634851653476431, \
-2.2136101145374965`}, {-0.8419787509605874, -2.148509110632282}, \
{-0.8038053930330994, -2.031338598958988}, {-0.7677256705902048, \
-1.9194550385120617`}, {-0.7524127458770993, -1.8717011071540723`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5142455410234019, 0.5295072653712556, 0.1520194313729983], 
           
           ArrowBox[{{-0.7487485642465116, -1.8602742189959576`}, \
{-0.7339263880965111, -1.8140507054801258`}, {-0.701917404174315, \
-1.7130132283862325`}, {-0.6716987188236166, -1.6163426072303826`}, \
{-0.6432703320444155, -1.5240388420125743`}, {-0.6164901806163695, \
-1.4356378832174554`}, {-0.606443149903051, -1.401863310491935}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4415154125829287, 0.5247680427350176, -0.17199510425798842`], 
           
           ArrowBox[{{-0.6030216476674037, -1.3903614270613196`}, \
{-0.5912162013191358, -1.3506756813296725`}, {-0.5674483941527149, \
-1.2691522363492258`}, {-0.5451867591171061, -1.1910675482761144`}, \
{-0.5243197648897479, -1.1160288733821786`}, {-0.5047358801480782, \
-1.043643467939259}, {-0.48643510489209707`, -0.9739113319473551}, \
{-0.47475098113162556`, -0.9278557924300567}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3785582278388279, 0.5222570345345442, -0.4033823281305688], 
           
           ArrowBox[{{-0.4718001057476902, -0.9162242691218875}, \
{-0.4694174391218044, -0.9068324654064668}, {-0.4442038731157635, \
-0.8021797520235423}, {-0.4221303393278429, -0.7033402101721739}, \
{-0.4029274566663895, -0.6092913606134805}, {-0.38632584403975034`, \
-0.5190107241085813}, {-0.37457632960436715`, -0.44634904146052745`}}]}}, {
          Arrowheads[{{0.01368900729507152, 1.}}], {
           LABColor[
           0.3337497215362721, 0.5223370441074452, -0.5104722152966646], 
           
           ArrowBox[{{-0.3726607913279171, -0.4345029149581025}, \
{-0.3722507432655664, -0.43196708402306006`}, {-0.3607386092525038, \
-0.34790994521076635`}, {-0.35168688054544717`, -0.26623791066521785`}, \
{-0.3449929956892812, -0.18634958337993188`}, {-0.34061571779073635`, \
-0.10768606156546294`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6854229589547433, 0.4445751274093305, 0.7549651605602747], 
           
           ArrowBox[{{-2.889213000064581, 
            1.7590313018908927`}, {-2.8260159154387465`, 
            1.7169251681249547`}, {-2.7643596543304603`, 
            1.675757134426265}, {-2.704244216739722, 
            1.6355272007948225`}, {-2.6456696026665316`, 
            1.596235367230628}, {-2.5793804906340605`, 
            1.5517139009041472`}, {-2.5149428896410626`, 
            1.5083061943460634`}, {-2.4905252213914904`, 
            1.4917356935237036`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6185188005617396, 0.5363018937124231, 0.6165594025308432], 
           
           ArrowBox[{{-2.4805957707283404`, 
            1.484997295381113}, {-2.4599568035539265`, 
            1.4709911249703786`}, {-2.4063592086311645`, 
            1.434509466935127}, {-2.303104809004914, 
            1.3638903190106675`}, {-2.200676907820567, 
            1.2935795510146826`}, {-2.103327273448495, 
            1.2262281998920588`}, {-2.0848655438598365`, 
            1.2133446097899594`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5343316320754172, 0.5308161102671526, 0.24150346782959706`], 
           
           ArrowBox[{{-2.0750248493267973`, 
            1.2064772426738506`}, {-2.0110559058887008`, 
            1.1618362656427967`}, {-1.923862805141183, 
            1.1004037482668958`}, {-1.8413354205033157`, 
            1.0416384870602493`}, {-1.7630612012724731`, 
            0.9852483213187497}, {-1.6890401474486547`, 
            0.9312332510423973}, {-1.6842846271646688`, 
            0.9277133659885148}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.44895141788156423`, 0.5252525858726436, -0.1388675152456999], 
           
           ArrowBox[{{-1.6746393003310105`, 
            0.9205742014525267}, {-1.6192722590318611`, 
            0.8795932762311919}, {-1.553425977969987, 
            0.8300827025475301}, {-1.4911697462109277`, 
            0.782455835653808}, {-1.4325035637546832`, 
            0.7367126755500264}, {-1.377427430601253, 
            0.6928532222361843}, {-1.295885737859819, 
            0.6258323210867194}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3663169302252574, 0.522278892460073, -0.4326383620485994], 
           
           ArrowBox[{{-1.286778911492728, 
            0.6180181124859317}, {-1.2218116324350774`, 
            0.5621294960458298}, {-1.1559737232433545`, 
            0.5024142377310472}, {-1.0970526708508868`, 
            0.44563990633297884`}, {-1.044765200287449, 
            0.3915198095727658}, {-0.9991217950833963, 
            0.3399563494137219}, {-0.959765740643358, 
            0.29061556001644495`}, {-0.9503425709353037, 
            0.2772380446962943}}]}}, {
          Arrowheads[{{0.012020781138934162`, 1.}}], {
           LABColor[
           0.28739497755168597`, 0.522419814625237, -0.6212575262241], 
           
           ArrowBox[{{-0.9434320587085524, 
            0.2674276002229832}, {-0.9263403223719635, 
            0.24316347554153284`}, {-0.8768713349168167, 
            0.15261072000639764`}, {-0.8498947138813762, 
            0.06566868010350589}, {-0.8444373659250493, 
            0.022796315980727934`}, {-0.8438908126000991, 
            0.012109208058452055`}, {-0.8436792067175473, 
            0.00142677071765128}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6794268736973363, 0.4582480891193428, 0.7516201950069484], 
           
           ArrowBox[{{-1.6556192370230853`, -2.7285671205059354`}, \
{-1.6142765819023568`, -2.6535736306829953`}, {-1.5740715707845656`, \
-2.58045033764467}, {-1.540398225845505, -2.518809142915114}, \
{-1.5075456379444718`, -2.458513905948185}, {-1.47546488077077, \
-2.39947333135927}, {-1.4441722630946319`, -2.3417178509432413`}, \
{-1.425531862975325, -2.3073093745236433`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6142128966178836, 0.5360213134649003, 0.5973764930989972], 
           
           ArrowBox[{{-1.4198158783261199`, -2.2967581888324493`}, \
{-1.411811722536959, -2.2819832481676903`}, {-1.3802270697589019`, \
-2.2234892426539474`}, {-1.3494183047604598`, -2.1662358344020136`}, \
{-1.3193854275416328`, -2.1102230234118884`}, {-1.2616473364428258`, \
-2.0019191932170655`}, {-1.2070127964624797`, -1.8985777520694769`}, \
{-1.1937796580197717`, -1.8733146968155818`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5358130742626439, 0.5309126436364526, 0.24810332971147586`], 
           
           ArrowBox[{{-1.188211537929213, -1.862684737330376}, \
{-1.1552298116877857`, -1.7997201446138869`}, {-1.1060463862059342`, \
-1.7048678154950583`}, {-1.0594625200169254`, -1.6140207647129916`}, \
{-1.0154782131207594`, -1.527178992267686}, {-0.9738898552796423, \
-1.4439397482238734`}, {-0.9696571285114365, -1.4353402704883704`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.45943251113343503`, 0.5259355522781332, -0.09217398347654464], 
           
           ArrowBox[{{-0.9643577891782347, -1.4245737946196573`}, \
{-0.9344938362557815, -1.363900282646286}, {-0.8972901560491767, \
-1.2870605955349235`}, {-0.8622788146598276, -1.2134206868897854`}, \
{-0.809549506879841, -1.0994373021388357`}, {-0.7620848080310083, \
-0.9926989057898761}, {-0.7608890170303341, -0.9898838433457382}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.38889044241962734`, 0.5222385854465486, -0.37868889858032756`], 
           
           ArrowBox[{{-0.7561973583780495, -0.9788390102057382}, \
{-0.7193826851555332, -0.8921720224767128}, {-0.6809411052956186, \
-0.7968231768331523}, {-0.6465762564185308, -0.7061501017048281}, \
{-0.6162861670201443, -0.6199540774869903}, {-0.5898415649355733, \
-0.5376569501378685}, {-0.5875478655308344, -0.5297217383036882}}]}}, {
          Arrowheads[{{0.017883568384551306`, 1.}}], {
           LABColor[
           0.33442259343882724`, 0.5223358426348235, -0.5088640881335916], 
           
           ArrowBox[{{-0.5842156400693659, -0.5181936737014256}, \
{-0.5670131779999326, -0.4586805656156932}, {-0.5476988728553221, \
-0.38254965365944704`}, {-0.5318691668906909, -0.30884773473997174`}, \
{-0.5194037640614264, -0.2370848409132852}, {-0.5101823683229166, \
-0.1667710042354057}, {-0.5041307684996238, -0.09745733067744573}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3061057072035063, 0.5223864049534662, -0.5765399024390269], 
           ArrowBox[{{0.5106746400773228, -0.0002839718156388989}, {
            0.5106766031362944, -0.002400788047699326}, {
            0.5106840359027589, -0.005223234546129856}, {
            0.5106969720284896, -0.008045737332816522}, {
            0.5108037529367392, -0.01933691968019843}, {
            0.5109986091444971, -0.030631436185505047`}, {
            0.5112815742747717, -0.04193123430753989}, {
            0.5114194414635983, -0.04645306882518926}, {
            0.5115714175157563, -0.05097618487399405}, {
            0.5117375066240382, -0.05550070723615661}, {
            0.5119177133514178, -0.060026760212579106`}, {
            0.5120227582121505, -0.06251677690309336}, {
            0.5186150661195276, -0.15219961150144073`}, {
            0.5307404869723039, -0.24350795273813142`}, {
            0.548561103456457, -0.33742898461648596`}, {
            0.5722389982579651, -0.4349498911398256}, {
            0.583379950912675, -0.47311945219793206`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.33096181515068185`, 0.52234202216223, -0.5171351595654735], 
           
           ArrowBox[{{0.5867422215302437, -0.4846387896916525}, {
            0.602065985903218, -0.537138910462474}, {
            0.6383338809186062, -0.6450642807387557}, {
            0.6640454750137054, -0.7145151783644755}, {
            0.6924302141084436, -0.7868481005154637}, {
            0.715302221374381, -0.8428077202966506}, {
            0.7397612136390219, -0.9006396691607721}, {
            0.7543360417317815, -0.9340463561244822}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3846848892971187, 0.5222460948356559, -0.3887399412622566], 
           
           ArrowBox[{{0.7591346463312384, -0.9450451466897248}, {
            0.7658699826443766, -0.9604830832730105}, {
            0.7936913201324549, -1.0224770987985474`}, {
            0.8232264080871641, -1.0866542122489042`}, {
            0.8545257162988934, -1.1531322318585304`}, {
            0.8877259682193772, -1.2221782613770016`}, {
            0.9229638873003495, -1.2940594045538925`}, {
            0.9605689958281165, -1.3694312328981613`}, {
            0.9651727137477033, -1.3785129498197866`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4545845063193454, 0.5256196477878183, -0.11377196580184337`], 
           
           ArrowBox[{{0.9705984618868921, -1.3892162790742797`}, {
            1.0004369565375857`, -1.4480784349487976`}, {
            1.0425677694287565`, -1.5300010107058004`}, {
            1.0869614345016294`, -1.6151989601691707`}, {
            1.133827082844822, -1.7040696117466643`}, {
            1.183373845546951, -1.7970102938460366`}, {
            1.192865087722003, -1.8146398093246405`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5310377016486166, 0.5306014719875892, 0.22682892564844218`], 
           
           ArrowBox[{{1.1985535543342083`, -1.825205856248719}, {
            1.2356017226080167`, -1.8940210064672878`}, {
            1.2905107140280199`, -1.9951017496104184`}, {
            1.3483572610135526`, -2.1007228153209785`}, {
            1.4093978047712072`, -2.211354495644519}, {
            1.4288142000882684`, -2.2463666819116703`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6094255095438526, 0.5357093589327665, 0.576048564317082], 
           
           ArrowBox[{{1.4346339385220885`, -2.256860996780299}, {
            1.441115825439581, -2.268549316286157}, {
            1.4736323453009854`, -2.32699679058104}, {
            1.5069473643554199`, -2.386696918529168}, {
            1.5410608826028853`, -2.447649700130541}, {
            1.5791047927136668`, -2.5155292186996467`}, {
            1.6182023174855282`, -2.5850870273016406`}, {
            1.6553499061220256`, -2.650752294187397}, {
            1.669399375755702, -2.6755299066265334`}}]}}, {
          Arrowheads[{{0.008191404822199983, 1.}}], {
           LABColor[
           0.6760474931126984, 0.4659541405435173, 0.7497349797103131], 
           
           ArrowBox[{{1.6753183398745666`, -2.6859685781780094`}, {
            1.693416262250162, -2.7178860325921756`}, {
            1.7324685646986249`, -2.786605474863788}, {
            1.772484420524519, -2.856871543552964}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.27619090570359284`, 0.5224398204919192, -0.6480346471107359], 
           
           ArrowBox[{{1.145274883080117, -0.1374451861019404}, {
            1.1838472579757213`, -0.1534719721116207}, {
            1.242758783264529, -0.17624203308687197`}, {
            1.3096115860450936`, -0.2001090866876361}, {
            1.385315739260403, -0.22533671818517112`}, {
            1.4707813158534448`, -0.252188512850735}, {
            1.5292492773087794`, -0.26982544190315444`}, {
            1.591914263342201, -0.2882220250874974}, {
            1.5999173813210337`, -0.2905149508591045}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.37579543784791486`, 0.5222619677417727, -0.4099852455854098], 
           
           ArrowBox[{{1.6114532590161517`, -0.29382002662272605`}, {
            1.6587762739537104`, -0.3073782624037639}, {
            1.7298353091433072`, -0.32729415385195404`}, {
            1.8054851694742653`, -0.34807799547484897`}, {
            1.886119655509857, -0.3698380833152297}, {
            1.9717387672500835`, -0.3925744173730965}, {
            2.0623425046949437`, -0.4162869976484492}, {
            2.07469895462332, -0.4194786047610217}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4669587893594676, 0.5264259777579209, -0.05864422632186743], 
           
           ArrowBox[{{2.086317634794052, -0.4224796497607231}, {
            2.158425931624183, -0.44110484990902965`}, {
            2.2604841118175445`, -0.46715699992257953`}, {
            2.3685170452750297`, -0.494443447689099}, {
            2.4825247319966373`, -0.5229641932085879}, {
            2.5458744943670424`, -0.5387415998191464}, {
            2.5516620155320564`, -0.5401766762602283}}]}}, {
          Arrowheads[{{0.018536901979758755`, 1.}}], {
           LABColor[
           0.5562754786292051, 0.5322460097674533, 0.339263851367247], 
           
           ArrowBox[{{2.5633092934832584`, -0.5430647407206305}, {
            2.6111311886086206`, -0.5549226800880329}, {
            2.733688287000005, -0.584969700240498}, {
            2.7974467033828763`, -0.6005236498576125}, {
            2.862858364557202, -0.6164312258353152}, {
            2.928307706409194, -0.6323490895383327}, {
            2.995485654407971, -0.6486411550525675}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.5820158680726208, 0.5339232986562754, 0.453937928139919], 
           
           ArrowBox[{{-2.7446293089820526`, 
            0.40545719771694255`}, {-2.672715704337631, 
            0.39325299459621177`}, {-2.6029710205401, 
            0.38136782179926515`}, {-2.532821692657361, 
            0.36927838214015096`}, {-2.4649508832622895`, 
            0.35752360087911467`}, {-2.399193080627579, 
            0.3460737158808601}, {-2.3356034553289993`, 
            0.33493864785715266`}, {-2.2716428477744697`, 
            0.3237084271540106}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.49336909997976686`, 0.5281469198847347, 0.05901436599741062], 
           
           ArrowBox[{{-2.259823648583523, 
            0.3216332089763913}, {-2.2244489474593885`, 
            0.3154221094243267}, {-2.11952401330269, 
            0.29677690806706714`}, {-2.0208286528589046`, 
            0.2790030437853742}, {-1.9283628661280316`, 
            0.2621005165792476}, {-1.8415947942920348`, 
            0.2459711826955668}, {-1.7875750127833427`, 
            0.23574061414705275`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4005448677106297, 0.5223586391982998, -0.3464903280610293], 
           
           ArrowBox[{{-1.7757845930179863`, 
            0.23350767846578152`}, {-1.7599925785328763`, 
            0.23051689838121103`}, {-1.6835562188505573`, 
            0.2157376636361804}, {-1.6122857152450765`, 
            0.2016334784604748}, {-1.545768561825522, 
            0.18812281983655926`}, {-1.4835922527009797`, 
            0.17512416474689863`}, {-1.4257567878714508`, 
            0.16263751319149297`}, {-1.3722621673369342`, 
            0.15066286517034216`}, {-1.3060431541091417`, 
            0.13502659518662216`}}]}}, {
          Arrowheads[{{0.0051088603182255846`, 1.}}], {
           LABColor[
           0.3062884419282943, 0.5223860786643643, -0.576103176409225], 
           
           ArrowBox[{{-1.2943787027001539`, 
            0.1322103292529631}, {-1.232498943672185, 
            0.11643289190601838`}, {-1.1759090744248741`, 
            0.10063661389580278`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6414567201205896, 0.5377965687519491, 0.7187484060919291], 
           
           ArrowBox[{{-0.48519946721068713`, -2.7478444554298918`}, \
{-0.4727313565030364, -2.6681326166260364`}, {-0.4606254754422913, \
-2.5904656295731714`}, {-0.4494559473243679, -2.518151680598474}, \
{-0.43860544555309744`, -2.4476323301882146`}, {-0.4280527538966016, \
-2.3787662993938348`}, {-0.41780494443217303`, -2.311600681198187}, \
{-0.4119985532116074, -2.2734594206630425`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5652122270928355, 0.5328283439599175, 0.3790772885986155], 
           
           ArrowBox[{{-0.41019255420586054`, -2.2615961004030463`}, \
{-0.39873773261506373`, -2.186351199038026}, {-0.38066413744327965`, \
-2.066493310675887}, {-0.3635841589168209, -1.952027016111769}, \
{-0.3474977970356873, -1.8429523153456722`}, {-0.339331762112029, \
-1.7868563889021194`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.49140117864709365`, 0.5280186866817126, 0.050247227392859604`], 
           
           ArrowBox[{{-0.33760311009223015`, -1.7749815515476777`}, \
{-0.332322718014887, -1.7387083187813568`}, {-0.31797658806942797`, \
-1.6387341368225832`}, {-0.3044594071993102, -1.543029769469351}, \
{-0.29177117540453384`, -1.4515952167216606`}, {-0.2798467857085075, \
-1.363959969385602}, {-0.27127568698452315`, -1.2995896548663772`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.42231563672377054`, 0.5235169516904462, -0.2575305844313229], 
           
           ArrowBox[{{-0.2696918302882213, -1.2876946391889776`}, \
{-0.26862113113464015`, -1.2796535182672661`}, {-0.2580942116829317, \
-1.1986758633666525`}, {-0.2482660273533821, -1.1210270046837614`}, \
{-0.23371106494677202`, -1.0012885169429768`}, {-0.22082532362168314`, \
-0.888842588467722}, {-0.21251478505093582`, -0.8111268702640009}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.36726454993422464`, 0.5222772004008092, -0.43037360260706736`], 
           
           ArrowBox[{{-0.21123883834054177`, -0.7991948980886966}, \
{-0.20945329086851638`, -0.7824974117592622}, {-0.19943945417767256`, \
-0.6810611793188622}, {-0.19073520333447905`, -0.5839394000306928}, \
{-0.18335301514993546`, -0.49087890642629883`}, {-0.177229007652951, \
-0.40119987647800726`}, {-0.1726722511933331, -0.32080267783745403`}}]}}, {
          Arrowheads[{{0.012906256395138517`, 1.}}], {
           LABColor[
           0.33183341153647217`, 0.5223404658493707, -0.5150520917216489], 
           
           ArrowBox[{{-0.17205980013153288`, -0.30881854306577106`}, \
{-0.16853772550600005`, -0.22934798795582262`}, {-0.165950808510092, \
-0.14606510748716836`}, {-0.16450405264452858`, -0.06378620238859815}, \
{-0.16431932335458627`, -0.043306985975724036`}, {-0.16420521877451855`, \
-0.022846387232739723`}, {-0.1641616809281329, -0.0023956065332813325`}, \
{-0.16416059627547375`, 0.0007995169822546009}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.32409457597001007`, 0.5223542842285025, -0.5335474868150161], 
           
           ArrowBox[{{0.1865271431291425, -0.0008398173976362411}, {
            0.18652836817126361`, -0.0036583733268073237`}, {
            0.18653238960136495`, -0.007416504446068362}, {
            0.18659583025428375`, -0.02468195857829922}, {
            0.18707952565607086`, -0.07498590367570054}, {
            0.18805242681860293`, -0.1254859368084273}, {
            0.18951625988152268`, -0.17631419000097287`}, {
            0.1939542447719008, -0.2798345020460324}, {
            0.20042944791969802`, -0.3862934382086093}, {
            0.20773217973453192`, -0.48023167269655}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3417719829357027, 0.522322719646283, -0.4912994479144825], 
           
           ArrowBox[{{0.20866225015493903`, -0.49219557544661796`}, {
            0.20902276870243647`, -0.4968330832602382}, {
            0.21981510649763836`, -0.6125955219724538}, {
            0.22760042965275387`, -0.6864735795750512}, {
            0.23628340691883962`, -0.7630701233485019}, {
            0.24989974415433336`, -0.8750818902867964}, {
            0.2622065124009348, -0.9691537708025295}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3854751403302193, 0.5222446837721578, -0.3868512843765259], 
           
           ArrowBox[{{0.2637631247970336, -0.9810523823958336}, {
            0.26543187514590877`, -0.9938081668783535}, {
            0.27393765260866926`, -1.0558844705278585`}, {
            0.2829479256805807, -1.1198736706711825`}, {
            0.2924984556741139, -1.1860038583900192`}, {
            0.3026250039017396, -1.254503124766061}, {
            0.31484032287141095`, -1.3352754122158053`}, {
            0.3278655630297082, -1.4195545016277755`}, {
            0.3335989827439276, -1.4559337925962232`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4475764944814343, 0.525162993454196, -0.14499283327515872`], 
           
           ArrowBox[{{0.33546713862733574`, -1.467787483734231}, {
            0.34170072437663146`, -1.5073403930019724`}, {
            0.35634580691218054`, -1.598633086338395}, {
            0.3718764818797693, -1.6938979823260194`}, {
            0.3883684205228112, -1.79360048165382}, {
            0.40582162284130624`, -1.8977405843217965`}, {
            0.4132334599286621, -1.9414431966329941`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5189176443842157, 0.5298117078145895, 0.17283376833808467`], 
           
           ArrowBox[{{0.41523997306249105`, -1.9532742534346401`}, {
            0.42423608883525443`, -2.0063182903299492`}, {
            0.443705995144408, -2.1198859786039446`}, {
            0.46432551840851866`, -2.2389960280694474`}, {
            0.47506638639868304`, -2.3006294382490147`}, {
            0.48609465862758666`, -2.3636484387264587`}, {
            0.49709231498668993`, -2.4262429781975214`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.593938999666936, 0.5347002308074796, 0.5070557766799653], 
           
           ArrowBox[{{0.49917535502328997`, -2.4380608010241325`}, {
            0.509013415801612, -2.4938432105749784`}, {
            0.5218895593845753, -2.566718001941879}, {
            0.5351413395337093, -2.6414397980966977`}, {
            0.5490906475876514, -2.719411965094287}, {
            0.563439075870707, -2.7993560096131063`}, {
            0.5782200677987792, -2.881455684127431}, {
            0.5834822125655522, -2.91059852161473}}]}}, {
          Arrowheads[{{0.0018308935285187256`, 1.}}], {
           LABColor[
           0.6633193064422157, 0.49497841246633906`, 0.7426344559283207], 
           
           ArrowBox[{{0.5856144985064146, -2.9224075586909017`}, {
            0.5934224755665675, -2.965649737812503}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.3054886453727904, 0.5223875067722413, -0.5780146465730911], 
           
           ArrowBox[{{1.300940787028234, 0.10218001068789548`}, {
            1.3709412094632867`, 0.11497670996371488`}, {1.4495408416537778`, 
            0.12849867285842645`}, {1.5376224430416023`, 
            0.14287927817093543`}, {1.6011115721118485`, 
            0.15286643432607025`}, {1.6691660889954618`, 
            0.16330009172164622`}, {1.7417859936924434`, 
            0.17418025035766346`}, {1.7747207386333064`, 
            0.17901330393471704`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4002695563382431, 0.5223650863510845, -0.3469646000971287], 
           
           ArrowBox[{{1.7865935817355607`, 0.1807556003128484}, {
            1.8189712862027916`, 0.18550691023412183`}, {1.9011659980130053`, 
            0.19734406605656576`}, {1.9888141606095813`, 
            0.20975571253053937`}, {2.0819157739925203`, 
            0.22274184965604285`}, {2.1804708381618214`, 
            0.23630247743307603`}, {2.261945501837193, 
            0.24737567683823133`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.49343092176876185`, 0.5281509483008547, 0.059289783608827015`], 
           
           ArrowBox[{{2.2738361852293645`, 0.24899173638761102`}, {
            2.285038328537902, 0.250514216641286}, {2.3961772205411753`, 
            0.2654536880603194}, {2.513887514171644, 0.28112089169017646`}, {
            2.6381692094293068`, 0.2975158275308571}, {2.7067918828228783`, 
            0.306530935057014}, {2.7496637545309373`, 
            0.31214034004219227`}}]}}, {
          Arrowheads[{{0.010017629756335033`, 1.}}], {
           LABColor[
           0.5822667561654432, 0.533939646964111, 0.4550556408490028], 
           
           ArrowBox[{{2.761562338388373, 0.3136971644342077}, {
            2.7774895894396563`, 0.3157811042737287}, {2.8435692126791974`, 
            0.3243506000146761}, {2.9113923035730496`, 
            0.33311836834455033`}, {2.981091690030265, 0.3421013109058466}, {
            3., 0.34453121304094203`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.29529245579472113`, 0.5224057129754978, -0.6023829837826999], 
           
           ArrowBox[{{1.200595980094406, 0.19449220675749607`}, {
            1.26566749878102, 0.22296457928213725`}, {1.339844525422412, 
            0.2530520357501295}, {1.4234160273847651`, 0.2849004159525462}, {
            1.5171862310668416`, 0.31880076905203264`}, {1.5783022567351792`, 
            0.34010544700616596`}, {1.6436193358219353`, 
            0.3623360608866024}, {1.6493700169861985`, 
            0.3642516177349258}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.389020271858319, 0.5222383536245397, -0.3783786132999738], 
           
           ArrowBox[{{1.6607550103216921`, 0.368043968819776}, {
            1.7131374683271092`, 0.3854926106933419}, {1.7868566542507012`, 
            0.40957509642638457`}, {1.865172065395549, 0.4347104870029618}, {
            1.948478873564489, 0.4610257513403049}, {2.036777078757522, 
            0.48852088943841404`}, {2.1181596144186634`, 
            0.5135359513502135}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.48019083007444097`, 0.5272882007214256, 0.0003048449866130277], 
           
           ArrowBox[{{2.129629980917743, 0.5170616700537964}, {
            2.1300666809746485`, 0.5171959012972891}, {2.2288414250957227`, 
            0.5472019452333237}, {2.3335950560005996`, 0.5786901795629109}, {
            2.4443275736892796`, 0.611660604286051}, {2.561038978161763, 
            0.646113219402744}, {2.5895332731511007`, 
            0.6544909375336752}}]}}, {
          Arrowheads[{{0.017225656649690235`, 1.}}], {
           LABColor[
           0.5687139521964517, 0.5330565225048037, 0.39467756124606745`], 
           
           ArrowBox[{{2.601045982517834, 0.6578758338448109}, {
            2.6261756838299983`, 0.665264314745517}, {2.693239168218624, 
            0.6849036366431747}, {2.7660755307116762`, 0.7060317055007321}, {
            2.8410872222013985`, 0.7277132135867944}, {2.918464057803418, 
            0.750002083779499}, {2.9981427658125277`, 
            0.7728803417861333}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.33870931434563983`, 0.5223281883134189, -0.49861905887233016`], 
           
           ArrowBox[{{1.1779175640203812`, -0.49296861400313957`}, {
            1.259436203997745, -0.5625398213285949}, {
            1.3520629742975703`, -0.6370876383633728}, {
            1.4027041186924234`, -0.6763724823943738}, {
            1.456316948116712, -0.7170751270998441}, {
            1.5131335239148784`, -0.7593579094414109}, {
            1.5548786878271905`, -0.7898602972300942}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4194156707525499, 0.5233279848252718, -0.27045000513989176`], 
           
           ArrowBox[{{1.56456778966092, -0.7969399374508694}, {
            1.5733859074313639`, -0.8033831663807006}, {
            1.6382205387007118`, -0.8499679318694446}, {
            1.7069422590020773`, -0.898598941648949}, {
            1.7795510683354614`, -0.949276195719214}, {
            1.856046966700863, -1.0019996940802391`}, {
            1.9367928234508534`, -1.057017023426317}, {
            1.958264517597241, -1.0714957354519838`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5058906246241648, 0.528962844375828, 0.11479807049570752`], 
           ArrowBox[{{1.9682138552530606`, -1.0782047353931443`}, {
            2.022151507938002, -1.1145757704517396`}, {
            2.1121230201623105`, -1.1746759351565075`}, {
            2.206707360123777, -1.23731751754062}, {
            2.3063491932970823`, -1.302794060391384}, {
            2.368382590900631, -1.3432700212841169`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5906558649626041, 0.534486295996113, 0.49242932971158526`], 
           
           ArrowBox[{{2.378432479938556, -1.3498274392458907`}, {
            2.4114931851569055`, -1.371399106496106}, {
            2.466128490594262, -1.4068748182687019`}, {
            2.5221393357032476`, -1.4431326558547868`}, {
            2.5795257204838618`, -1.4801726192543614`}, {
            2.6382876449361063`, -1.5179947084674255`}, {
            2.703752583656865, -1.5600743472579788`}, {
            2.771029753240854, -1.6031997233019537`}, {
            2.781774966652355, -1.6100452601429176`}}]}}, {
          Arrowheads[{{0.010272054102497827`, 1.}}], {
           LABColor[
           0.6658582554419517, 0.48918880958933175`, 0.7440508295423013], 
           
           ArrowBox[{{2.791895629459631, -1.6164929096635894`}, {
            2.835291957534035, -1.644139746559162}, {
            2.9011517967727554`, -1.6860043917346819`}, {
            2.9687273132496896`, -1.7288678990732782`}, {
            3., -1.7486640535125217`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2966803097771545, 0.5224032348387878, -0.5990660884285397], 
           
           ArrowBox[{{0.8411102623440131, -0.2997346691337481}, {
            0.8857144952609148, -0.3809350778462631}, {
            0.941269928685755, -0.4668451811785688}, {
            1.0084683457480537`, -0.5585263245178285}, {
            1.0469319018234429`, -0.6069952890824493}, {
            1.0886515454377848`, -0.6573522596151977}, {
            1.1173366627811991`, -0.6908561913614119}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.36499471152950164`, 0.5222812533991414, -0.4357983926459441], 
           
           ArrowBox[{{1.125141054676383, -0.6999716434701331}, {
            1.1271893474554273`, -0.7023640290631147}, {
            1.16830614929968, -0.7489864695681898}, {
            1.2121108251955302`, -0.7973358567890635}, {
            1.2587122493679648`, -0.847528466384375}, {
            1.3081164917621584`, -0.8995914649482746}, {
            1.3604118657471354`, -0.9536233063265038}, {
            1.4158306106836585`, -1.0098471970550902`}, {
            1.4547959127820214`, -1.0487228606496806`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.44261382967792995`, 0.5248396175180173, -0.16710162871219347`], 
           
           ArrowBox[{{1.4632909598300692`, -1.0571983650978802`}, {
            1.4746049659324905`, -1.068486343670061}, {
            1.5356679505328628`, -1.1284996050026295`}, {
            1.600280882722398, -1.191155202495601}, {
            1.668443762501095, -1.2564531361489752`}, {
            1.7401565898689544`, -1.324393405962752}, {
            1.809611525478793, -1.389529732986139}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5255180175801749, 0.5302417996998735, 0.20223859549757872`], 
           
           ArrowBox[{{1.818375801654195, -1.397726490073895}, {
            1.8955557509724672`, -1.4694440631621495`}, {
            1.979573000608198, -1.5468652278204298`}, {
            2.0678020296332447`, -1.6275502831844306`}, {
            2.11359690989147, -1.6692088088171662`}, {
            2.160646631946441, -1.7118673849985113`}, {
            2.1720839566955896`, -1.7222046668658153`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6080935201669532, 0.5356225641705189, 0.5701145184316183], 
           
           ArrowBox[{{2.1809865570222198`, -1.7302510143244005`}, {
            2.2089511957981576`, -1.7555260117284668`}, {
            2.2585106014466194`, -1.8001846890070314`}, {
            2.309324848891827, -1.8458434168342062`}, {
            2.361393938133781, -1.8925021952099905`}, {
            2.41471786917248, -1.940161024134385}, {
            2.469296642007925, -1.9888199036073888`}, {
            2.530158763426673, -2.0430151854623415`}, {
            2.5385558954865517`, -2.0504740336194094`}}]}}, {
          Arrowheads[{{0.015898620055413645`, 1.}}], {
           LABColor[
           0.6772169189524562, 0.46328748154130356`, 0.7503873535481145], 
           
           ArrowBox[{{2.547527602234907, -2.058443254285291}, {
            2.5926773586699485`, -2.0985480394876856`}, {
            2.650784927574973, -2.1498829229111878`}, {
            2.7102778656642807`, -2.202339497924063}, {
            2.7712548345134027`, -2.2560039586549516`}, {
            2.833682946930495, -2.3108475737276395`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.7261619282660884, 0.3516774544132192, 0.7776917301760309], 
           
           ArrowBox[{{-2.1191246908247052`, -2.9302955800602444`}, \
{-2.0664230757043733`, -2.8517048862672274`}, {-2.0151362616593143`, \
-2.7750666996921143`}, {-1.9733373017360658`, -2.7122976123950333`}, \
{-1.9325022759546278`, -2.650856360804654}, {-1.892575165083799, \
-2.5906575972637667`}, {-1.853574642200647, -2.531729770991442}, \
{-1.8529834023012162`, -2.5308363183968527`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6689242499406896, 0.48219737708216937`, 0.7457612198294136], 
           
           ArrowBox[{{-1.8463611201812464`, -2.5208290520606584`}, \
{-1.8121162805876707`, -2.4690799383495796`}, {-1.7716216681178383`, \
-2.407732419350641}, {-1.732090804791149, -2.347687213994625}, \
{-1.6935236906076025`, -2.288944322281531}, {-1.6559203255672004`, \
-2.2315037442113623`}, {-1.6192807096699406`, -2.1753654797841153`}, \
{-1.5836048429158245`, -2.120529528999792}, {-1.5829705137668102`, \
-2.1195512554507068`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5988150339925258, 0.5350179617498886, 0.5287786311778757], 
           
           ArrowBox[{{-1.5764418626190626`, -2.10948265504196}, \
{-1.548892725304852, -2.0669958918583915`}, {-1.4820454420964615`, \
-1.9633501222781387`}, {-1.4184245646288942`, -1.8639427348171356`}, \
{-1.3580300929021503`, -1.7687737294753818`}, {-1.3179557233487589`, \
-1.7050320699335624`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5196222773483546, 0.5298576229334748, 0.17597292576240625`], 
           
           ArrowBox[{{-1.3115687299317187`, -1.694873019038391}, \
{-1.3008620269162297`, -1.6778431062528778`}, {-1.246664154366305, \
-1.5907427786429236`}, {-1.19518026294755, -1.5070646601388193`}, \
{-1.146410352659964, -1.4268087507405656`}, {-1.1003544235035474`, \
-1.3499750504481614`}, {-1.0646261597768092`, -1.2895413771469268`}, \
{-1.0619293818590028`, -1.284917104268294}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4423386260905366, 0.5248216847699401, -0.16832766755586534`], 
           
           ArrowBox[{{-1.0558841247763922`, -1.2745510603360533`}, \
{-1.0306012414073822`, -1.231197489734271}, {-0.9981999979773672, \
-1.174812637877588}, {-0.9673427590688641, -1.120256071244273}, \
{-0.9099416131447968, -1.016104792317328}, {-0.8577604402919844, \
-0.917697650292596}, {-0.8253069425701977, -0.853656171296852}}]}}, {
          Arrowheads[{{0.0008602578879421558, 1.}}], {
           LABColor[
           0.3728613549778022, 0.5222672068076704, -0.4169975436828899], 
           
           ArrowBox[{{-0.8198825916684962, -0.8429521338672084}, \
{-0.8105499103681866, -0.8245356686038505}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.399110429922255, 0.5222203367499815, -0.3542636856284538], 
           
           ArrowBox[{{1.1767842723605464`, -0.9267581032503878}, {
            1.2243395047911363`, -0.9851154719252416}, {
            1.2748544397915753`, -1.0458579148392955`}, {
            1.3284610058066295`, -1.1091399918136184`}, {
            1.3851735816656312`, -1.174998142341771}, {
            1.44510058589026, -1.2435633021793204`}, {
            1.4880799523572912`, -1.2920691091590166`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.47939432966436046`, 0.5272362993587556, -0.003243584199970218], 
           ArrowBox[{{1.4960381474393787`, -1.3010505974006967`}, {
            1.508515006463801, -1.3151317755403458`}, {
            1.5756898313695413`, -1.3899998666389266`}, {
            1.6425708699405714`, -1.46372267401732}, {
            1.713133955930152, -1.5407570156394206`}, {
            1.7873790893382842`, -1.6211028915052297`}, {
            1.8195474957562272`, -1.6556367414370112`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5607284323721027, 0.5325361720376015, 0.359101871320314], 
           
           ArrowBox[{{1.8277267244618278`, -1.6644174144056099`}, {
            1.865306270164967, -1.7047603016147463`}, {
            1.947263157750868, -1.792100152070491}, {
            2.033597411436653, -1.883493348974982}, {
            2.0784060505670023`, -1.9307099523455085`}, {
            2.124309031222323, -1.9789398923282213`}, {
            2.1572384911217166`, -2.0134430177557907`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6424398845639817, 0.5378606334701778, 0.7231284282011341], 
           
           ArrowBox[{{2.1655234968417596`, -2.022123955505761}, {
            2.1713063534026147`, -2.0281831689231207`}, {
            2.2193980171078778`, -2.078439782130207}, {
            2.268689322993113, -2.1298196708729105`}, {
            2.31928557171332, -2.1824327740746607`}, {
            2.3711867632685, -2.236279091735458}, {
            2.4243928976586524`, -2.2913586238553014`}, {
            2.478903974883779, -2.347671370434193}, {
            2.498486918090269, -2.3678612601030635`}}]}}, {
          Arrowheads[{{0.01999999999999999, 1.}}], {
           LABColor[
           0.7011765114395476, 0.40865206916806845`, 0.763753409583101], 
           
           ArrowBox[{{2.506841738521654, -2.3764750267332495`}, {
            2.534719994943877, -2.405217331472131}, {
            2.591840957838948, -2.4639965069691154`}, {
            2.6502668635689917`, -2.5240088969251473`}, {
            2.7154235970335376`, -2.590875788004045}, {
            2.78230493647134, -2.659388184339304}, {
            2.8418928769158343`, -2.7201902968247205`}}]}}, {
          Arrowheads[{{0.008900134350911705, 1.}}], {
           LABColor[
           0.7593498287458254, 0.2759985951217177, 0.7962058738424855], 
           
           ArrowBox[{{2.8502977037260715`, -2.7287552767952805`}, {
            2.903974827882876, -2.783450059107144}, {
            2.966935191220073, -2.8475182018139136`}, {
            3., -2.8811217723376465`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.7223049545995779, 0.36047256839088976`, 0.7755400856445215], 
           
           ArrowBox[{{-2.921786143259483, 
            2.2104902638994046`}, {-2.8490733216548425`, 
            2.151182654615144}, {-2.7783132778077992`, 
            2.0933494554711993`}, {-2.720585782230197, 
            2.045935604963001}, {-2.664191320120037, 
            1.9995265624453593`}, {-2.6090523045881584`, 
            1.9540576566765822`}, {-2.5551945979309476`, 
            1.9095504447372333`}, {-2.5507968228891027`, 
            1.9059157016647774`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.663596092640866, 0.49434725281240804`, 0.7427888633892515], 
           
           ArrowBox[{{-2.5415471394730265`, 
            1.898270876179368}, {-2.4979611164668323`, 
            1.8622472065577398`}, {-2.442059384979985, 
            1.815928610849047}, {-2.3874894034704055`, 
            1.7705946576111553`}, {-2.334251171938094, 
            1.7262453468440646`}, {-2.2823446903830504`, 
            1.6828806785477748`}, {-2.231769958805275, 
            1.6405006527222858`}, {-2.182526977204767, 
            1.5991052693675976`}, {-2.172841827464708, 
            1.590936327278091}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5884931237522386, 0.5343453679884185, 0.48279426369434114`], 
           
           ArrowBox[{{-2.1636689746840485`, 
            1.5831994821934101`}, {-2.134615745581528, 
            1.5586945284837106`}, {-2.0423536627973187`, 
            1.4804595691935822`}, {-1.9545488409831135`, 
            1.4054283699171428`}, {-1.871201280138912, 
            1.3336009306543923`}, {-1.7991455696987084`, 
            1.270922401491785}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5052129635932134, 0.5289186867953802, 0.11177907370624626`], 
           ArrowBox[{{-1.790101520224405, 
            1.2630354201639575`}, {-1.7175234340577, 
            1.1992486158830766`}, {-1.646484134215047, 
            1.1361063078007443`}, {-1.5791930807367567`, 
            1.0755503271583355`}, {-1.5156502736228281`, 
            1.0175806739558493`}, {-1.4664724588855833`, 
            0.972093319334809}, {-1.4337900080043438`, 
            0.9414494215565212}}]}}, {
          Arrowheads[{{0.018259634491537446`, 1.}}], {
           LABColor[
           0.4216695243440879, 0.5234748498754075, -0.2604090311927588], 
           
           ArrowBox[{{-1.4250361095294086`, 
            0.9332415435426539}, {-1.4196357058021156`, 
            0.9281779875571496}, {-1.3750304756946428`, 
            0.8857364448683025}, {-1.332547229885384, 
            0.8446704575136997}, {-1.2535085364503804`, 
            0.7662722137889535}, {-1.1816433160748536`, 
            0.692197386346365}, {-1.1166060998518725`, 
            0.6220769194978394}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3896903849038474, 0.5222371570781027, -0.3767770796547857], 
           
           ArrowBox[{{0.8989633241305421, -0.9561886238467581}, {
            0.9332144934200562, -1.0181476934611733`}, {
            0.969655144348582, -1.082498916752544}, {
            1.008377567636009, -1.149400653917389}, {
            1.0493889605028313`, -1.2188900597297205`}, {
            1.092764594969059, -1.2911012533015556`}, {
            1.1386988739538546`, -1.3663380413364223`}, {
            1.1412666409592838`, -1.3704816179752985`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4632808223633921, 0.5261863149824398, -0.07502966099458203], 
           
           ArrowBox[{{1.1475876932204134`, -1.3806818286746942`}, {
            1.1873862003763798`, -1.444904230537847}, {
            1.237127429167146, -1.5241116525402525`}, {
            1.2896945916110232`, -1.6068399198935501`}, {
            1.3450876877080118`, -1.6930890325977415`}, {
            1.403306717458111, -1.7828589906528252`}, {
            1.4051669307065897`, -1.7857018434458336`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5414060676938616, 0.531277092890729, 0.2730202549013765], 
           
           ArrowBox[{{1.4117374482792773`, -1.7957431729806614`}, {
            1.4646167851040937`, -1.8765555048505764`}, {
            1.5292829948887294`, -1.9745842859827676`}, {
            1.59730534681202, -2.0769453340494004`}, {
            1.6686838408739646`, -2.1836386490504744`}, {
            1.6768940326354695`, -2.1958538935324343`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6210242107650465, 0.5364651506322605, 0.6277210674556353], 
           
           ArrowBox[{{1.6835880344535754`, -2.2058133282382393`}, {
            1.7057122787566796`, -2.2387301054575186`}, {
            1.7437410272735534`, -2.2951450262103554`}, {
            1.782770086424586, -2.3528834113089863`}, {
            1.8227994562097767`, -2.4119452607534098`}, {
            1.8638291366291264`, -2.4723305745436273`}, {
            1.9058591276826347`, -2.5340393526796374`}, {
            1.9488894293703012`, -2.5970715951614416`}, {
            1.952997303441723, -2.6030757165098533`}}]}}, {
          Arrowheads[{{0.01957419645137926, 1.}}], {
           LABColor[
           0.6849241709318659, 0.44571252109962034`, 0.7546869075529689], 
           
           ArrowBox[{{1.9597732756574715`, -2.6129795642737985`}, {
            1.9929200416921267`, -2.6614273019890384`}, {
            2.042037966987165, -2.73314225057463}, {
            2.0924780257305393`, -2.8066267401180625`}, {
            2.1387807591918935`, -2.873762315844968}, {
            2.186163500820561, -2.9423469702346527`}, {
            2.226059299473858, -3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6655222329645823, 0.48995504660390693`, 0.7438633766353308], 
           
           ArrowBox[{{-2.928501793799512, 
            1.3973753105568039`}, {-2.854582599661303, 
            1.358478292577877}, {-2.7827236888799294`, 
            1.3205616673919367`}, {-2.7210209815131186`, 
            1.2877827394421637`}, {-2.6608817258870228`, 
            1.25574636525147}, {-2.602209685466809, 
            1.224400302425992}, {-2.5450369390974217`, 
            1.1937619650970177`}, {-2.50465958435601, 
            1.1720847861820216`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5895324099141517, 0.5344130896961848, 0.48742430945887716`], 
           
           ArrowBox[{{-2.4940868920918073`, 
            1.1664086802733487`}, {-2.4307059869158207`, 
            1.1323817057453431`}, {-2.3220242928069696`, 
            1.073612446388549}, {-2.2189918567708684`, 
            1.017454187026636}, {-2.121608678807516, 
            0.9639069276596033}, {-2.072621851473874, 
            0.9367071325656652}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5036664499026483, 0.5288179132528783, 0.10488931665452382`], 
           
           ArrowBox[{{-2.062130590757304, 
            0.9308818902035862}, {-2.0294103918178075`, 
            0.9127140937768927}, {-1.9419326287026366`, 
            0.8636191108679456}, {-1.8591753894620031`, 
            0.816621978932762}, {-1.7811386740959068`, 
            0.7717226979713415}, {-1.7074487228367894`, 
            0.7287060258469861}, {-1.6457517608821464`, 
            0.692113394696152}}]}}, {
          Arrowheads[{{0.01852283507533149, 1.}}], {
           LABColor[
           0.41558534011578346`, 0.5230791123378863, -0.28749205838850134`], 
           
           ArrowBox[{{-1.635441173767153, 
            0.6859741514655135}, {-1.5719878333368142`, 
            0.6476747816993742}, {-1.5102168950959562`, 
            0.6096602096761179}, {-1.41832349043055, 
            0.5514424115811271}, {-1.3357689713712126`, 
            0.4969102792020164}, {-1.2616601694340694`, 
            0.44552833223134597`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6978273838537296, 0.41628913423252367`, 0.7618850711710649], 
           
           ArrowBox[{{-1.4404110309233227`, -3.}, {-1.404264096701968, \
-2.917808553884523}, {-1.3690895078662146`, -2.837633660408961}, \
{-1.3395344494654169`, -2.7698662634150186`}, {-1.310699635927396, \
-2.703592095214365}, {-1.282541720623654, -2.638710004708546}, \
{-1.2550751524303576`, -2.5752537089303815`}, {-1.2484904894800746`, \
-2.5600392655600284`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6403614155738709, 0.5371373347584818, 0.7128920247960265], 
           
           ArrowBox[{{-1.2437242359699892`, -2.5490264172691637`}, \
{-1.2267581479480998`, -2.509824777432098}, {-1.1991169359641973`, \
-2.445764782641229}, {-1.1721515164786507`, -2.383073724557776}, \
{-1.1458618894914596`, -2.3217516031817387`}, {-1.0953100130121454`, \
-2.2032141705519113`}, {-1.0548997322222682`, -2.107728737291376}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5624483650194053, 0.5326482458632593, 0.36676421414827265`], 
           
           ArrowBox[{{-1.0502228157307176`, -2.0966776535376868`}, \
{-1.0474613065262535`, -2.0901524847517456`}, {-1.002094391118382, \
-1.9820415530346212`}, {-0.9589878878731279, -1.8783563826539154`}, \
{-0.9181417967904917, -1.779096973609629}, {-0.879556117870473, \
-1.6842633259017616`}, {-0.8670049034792133, -1.6530269748035353`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.48646467146442984`, 0.5276970152219518, 0.028254964808874895`], 
           
           ArrowBox[{{-0.8625308049323042, -1.6418922344746123`}, \
{-0.843051698840762, -1.5934143599050634`}, {-0.8084493874290484, \
-1.5061089959942837`}, {-0.7757491836353323, -1.4223472341694232`}, \
{-0.7449510874596135, -1.3421290744304812`}, {-0.7211443302166384, \
-1.2790635484904453`}, {-0.6985311623207383, -1.2181483976538527`}, \
{-0.689759276104882, -1.1940869366851747`}}]}}, {
          Arrowheads[{{0.008376973722382629, 1.}}], {
           LABColor[
           0.41423522282049224`, 0.5229904177587493, -0.29352902984476303`], 
           
           ArrowBox[{{-0.6856491470741434, -1.1828127697824418`}, \
{-0.6770563474697768, -1.1592425470043124`}, {-0.6566646493616171, \
-1.1022049216254333`}, {-0.6189096581651556, -0.993170047014093}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6375495694426921, 0.5375419719660925, 0.7013419524023086], 
           
           ArrowBox[{{-2.987451305439484, 
            0.7362465580074508}, {-2.9101393408080174`, 
            0.7149595957604565}, {-2.835066145892044, 
            0.6942225591806266}, {-2.7654106204440043`, 
            0.6748213111296839}, {-2.697745944820941, 
            0.6559082382655044}, {-2.631938022993928, 
            0.6374448973438581}, {-2.5680315536392744`, 
            0.6194441027794885}, {-2.525090392968267, 
            0.6073232355149395}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.550977698801213, 0.5319007971489553, 0.3156621101404734], 
           
           ArrowBox[{{-2.5135416475983203`, 
            0.6040634072402998}, {-2.448682373787967, 
            0.5857557826571314}, {-2.33556896260811, 
            0.5535444873369298}, {-2.2286913200997023`, 
            0.5228102168188836}, {-2.1280494462627444`, 
            0.49355297110299284`}, {-2.0522826952801383`, 
            0.47125834152976936`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.46175332213177295`, 0.5260867803902457, -0.08183471261262444], 
           
           ArrowBox[{{-2.040770732623319, 
            0.4678709065432344}, {-2.0331169582001194`, 
            0.4656187568418248}, {-1.9433674730147108`, 
            0.4388535806879469}, {-1.8588009907065182`, 
            0.413257442641359}, {-1.7794175112755415`, 
            0.38883034270206124`}, {-1.7047997648506692`, 
            0.365443874521028}, {-1.6345304815607888`, 
            0.3429696317492339}, {-1.5822731398804948`, 
            0.32587679664821423`}}]}}, {
          Arrowheads[{{0.0000989925484611556, 1.}}], {
           LABColor[
           0.3711261847537817, 0.522270305108417, -0.4211445059192484], 
           
           ArrowBox[{{-1.570867757201114, 
            0.3221462141284342}, {-1.568609661405901, 
            0.3214076143866788}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3816812211725832, 0.5222514581522136, -0.3959185443241167], 
           
           ArrowBox[{{0.6186983884351035, -0.9365647456889098}, {
            0.6403810885219241, -0.9989438018955942}, {
            0.6634853390987714, -1.0635430702801674`}, {
            0.6880663322870922, -1.1305121869138626`}, {
            0.714125569187122, -1.199884887241399}, {
            0.7417075037160654, -1.271787627208707}, {
            0.7709317572208237, -1.3465091236388365`}, {
            0.7867133368300302, -1.3861481992966713`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4480681191329005, 0.5251950285781085, -0.142802633194872], 
           
           ArrowBox[{{0.7911520644273183, -1.3972970870132586`}, {
            0.8019179510482977, -1.4243380933548369`}, {
            0.8350825133316031, -1.5062964353707637`}, {
            0.8702209690666101, -1.591865577486714}, {
            0.9073333182533186, -1.681045519702688}, {
            0.946419560891729, -1.7738362620186854`}, {
            0.9749066006669481, -1.8407190595410072`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5227103009375992, 0.5300588439626301, 0.18973014784823755`], 
           
           ArrowBox[{{0.9796089345937354, -1.8517593519121804`}, {
            0.9876642822175956, -1.8706719587800664`}, {
            1.0312520674666734`, -1.9719867643321911`}, {
            1.0771829166389626`, -2.07778067867506}, {
            1.1254568297344631`, -2.188053701808672}, {
            1.1505289524653866`, -2.244998527477169}, {
            1.171230509907802, -2.2918479998770476`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5999253060347435, 0.5350903090220258, 0.5337249208091072], 
           
           ArrowBox[{{1.1760805991417043`, -2.30282418475264}, {
            1.17629987560105, -2.3033204269536744`}, {
            1.2027695991414544`, -2.36301940023819}, {
            1.229938123086599, -2.4240954473307146`}, {
            1.2578054474364837`, -2.4865485682312487`}, {
            1.2863715721911095`, -2.5503787629397916`}, {
            1.315636497350475, -2.615586031456344}, {
            1.3456002229145816`, -2.682170373780906}, {
            1.3720976635170508`, -2.740975233934502}}]}}, {
          Arrowheads[{{0.011352561827963117`, 1.}}], {
           LABColor[
           0.668719454307424, 0.4826643755873289, 0.7456469728984016], 
           
           ArrowBox[{{1.3770274934155886`, -2.7519158361652516`}, {
            1.379015434772251, -2.7563276061631883`}, {
            1.4133533539565066`, -2.832328955590538}, {
            1.446078950945771, -2.9043319184058354`}, {
            1.4796145071386915`, -2.9779588055506503`}, {
            1.489674547917219, -3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6764744325044566, 0.46498058434719847`, 0.7499731513668993], 
           
           ArrowBox[{{-0.8024224162724263, -3.}, {-0.7845110393713981, \
-2.926072228358122}, {-0.7645330336732163, -2.8433842260416573`}, \
{-0.7468991797825795, -2.769882481901551}, {-0.7297311085922271, \
-2.6981134972395613`}, {-0.7129990941037543, -2.627950693931786}, \
{-0.6967130449832961, -2.5594362646861937`}, {-0.6904853732795504, \
-2.533235040071396}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6118381424913992, 0.5358665703240169, 0.586796904254185], 
           
           ArrowBox[{{-0.687710445462101, -2.521560290583379}, \
{-0.680703594952792, -2.4920808843509836`}, {-0.665089659453588, \
-2.4261566250662114`}, {-0.6498712384856842, -2.361663486831876}, \
{-0.6350483320490802, -2.298601469647977}, {-0.6065890627697729, \
-2.1767707984314923`}, {-0.5797118516156657, -2.060664611416755}, \
{-0.5782332714507453, -2.0542126625073966`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5358461782892778, 0.5309148007528464, 0.24825080897553495`], 
           
           ArrowBox[{{-0.5755527428653253, -2.042515878055987}, \
{-0.5542853858528454, -1.9497134016417395`}, {-0.530178352747398, \
-1.843347662144418}, {-0.5073907522993238, -1.7415673929247906`}, \
{-0.48592258450862275`, -1.6443725939828575`}, {-0.47063805984342133`, \
-1.5741252739699894`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4629946344743332, 0.5261676664780149, -0.0763046351760522], 
           
           ArrowBox[{{-0.4680867734442843, -1.56239962099416}, \
{-0.46566863470402264`, -1.551285911562985}, {-0.4465236882142516, \
-1.4618299919095397`}, {-0.4284877450393093, -1.376004835022521}, \
{-0.411560805179196, -1.2938104409019295`}, {-0.3862643421051546, \
-1.1671719860870375`}, {-0.37192504682188315`, -1.092144648369731}}]}}, {
          Arrowheads[{{0.010553683928915689`, 1.}}], {
           LABColor[
           0.3968526639311156, 0.522313390914602, -0.35691359942506135`], 
           
           ArrowBox[{{-0.36967236858372804`, -1.0803579846876137`}, \
{-0.3636089214574199, -1.048632276674105}, {-0.34333947995693986`, \
-0.9369815141030243}, {-0.3252009543246622, -0.8310098998136869}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6211368086257216, 0.5364724877062015, 0.6282226937324205], 
           
           ArrowBox[{{-3., 0.1408480133979621}, {-2.9271499773026988`, 
            0.1370025623858416}, {-2.8492701589809215`, 
            0.13287714667087328`}, {-2.7685983896863258`, 
            0.12856202233354674`}, {-2.690612927901397, 
            0.12437243921302005`}, {-2.6151090194046427`, 
            0.12029702899634676`}, {-2.5421549156032284`, 
            0.11633958112117572`}, {-2.520687264180963, 
            0.11517240236962507`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[0.5334735177605813, 0.530760194034464, 0.237680547161068], 
           
           ArrowBox[{{-2.508704961007513, 
            0.1145209342894147}, {-2.417528978493351, 
            0.10956377025926324`}, {-2.299869151819678, 
            0.1030999391016924}, {-2.1891754355822113`, 
            0.0969480876484633}, {-2.0854478297809496`, 
            0.09110821589957589}, {-2.0294434227071254`, 
            0.08790887486515638}}]}}, {
          Arrowheads[{{0.01803928880181987, 1.}}], {
           LABColor[
           0.4421047719647648, 0.5248064464252514, -0.1693694935170192], 
           
           ArrowBox[{{-2.0174629555982446`, 
            0.087224471582707}, {-1.9880708676450258`, 
            0.0855454017025091}, {-1.8964290824035726`, 
            0.08022472290474184}, {-1.8105224740565902`, 
            0.07514617950627414}, {-1.7303510426040778`, 
            0.07030977150710596}, {-1.6554365667638655`, 
            0.06568668806043912}, {-1.5853008252537817`, 
            0.061248118319475395`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.36355775591145123`, 0.5222838192111884, -0.4392326382322767], 
           
           ArrowBox[{{1.4862124384064912`, -0.3886974772287732}, {
            1.5929858713771845`, -0.4347227298429626}, {
            1.6583050476708698`, -0.46201502227795677`}, {
            1.7278541563681888`, -0.49050798920522676`}, {
            1.801633197469141, -0.5202016306247725}, {
            1.8796421709737265`, -0.5510959465365941}, {
            1.930267502262205, -0.570853371197471}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.45252463668342896`, 0.5254854230722079, -0.12294873638995096`], 
           
           ArrowBox[{{1.941446344117295, -0.5752161105638418}, {
            1.9622804023642213`, -0.5833469677003293}, {
            2.0499472171229005`, -0.6171107248756158}, {
            2.1426426152497635`, -0.6523872180624537}, {
            2.240366596744812, -0.6891764472608428}, {
            2.343613934434352, -0.7276639989052471}, {
            2.3904245101479087`, -0.744959594361557}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5413774382657693, 0.5312752273470184, 0.2728927100853892], 
           
           ArrowBox[{{2.4016807541292273`, -0.7491185571448757}, {
            2.452879401144689, -0.7680354594301295}, {
            2.5681629968758237`, -0.8102908288354906}, {
            2.6894647216277567`, -0.85443010712133}, {
            2.7574934246696143`, -0.8791006752359883}, {
            2.8274829975617615`, -0.9043964917785531}, {
            2.852679451307409, -0.9134315468161401}}]}}, {
          Arrowheads[{{0.006019236692469135, 1.}}], {
           LABColor[
           0.6277292432291589, 0.5369020622988835, 0.6575921542642911], 
           
           ArrowBox[{{2.8639751874469743`, -0.9174820214877459}, {
            2.8998243355087703`, -0.9303369664358969}, {
            2.974179039866751, -0.9569216752150219}, {
            3., -0.9661278828353863}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.42485479815447963`, 0.5236824078994137, -0.24621855694691258`], 
           
           ArrowBox[{{1.3153424446557915`, 1.029241862431278}, {
            1.3708624084570018`, 1.0913754282762163`}, {1.4295921545970172`, 
            1.156047826273962}, {1.4916442087573916`, 1.2233878037208794`}, {
            1.5573014169184065`, 1.2936868040451268`}, {1.6268466250603428`, 
            1.3672362706748618`}, {1.6408946385390417`, 
            1.3819328796171186`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.506405888754177, 0.5289964198895931, 0.11709358504233586`], 
           
           ArrowBox[{{1.6491863469531736`, 1.390607415430349}, {
            1.6959956539646583`, 1.439577903752343}, {1.76894299723756, 
            1.5151729261854194`}, {1.845688654879048, 1.5940213379740913`}, {
            1.9262326268891221`, 1.6761231391183586`}, {1.9839801302594824`, 
            1.7345644281778068`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5883425670742921, 0.5343355574514174, 0.4821235299401597], 
           
           ArrowBox[{{1.9924145940173967`, 1.7431002246325278`}, {
            2.0109338709552853`, 1.7618419944672843`}, {2.1001513447650395`, 
            1.8515415688699308`}, {2.1464536678237645`, 1.8978841257164}, {
            2.1938850483183865`, 1.9452218623262993`}, {2.2424454862489065`, 
            1.9935547786996286`}, {2.2921349816153245`, 
            2.0428828748363883`}, {2.331987227517109, 
            2.0823468553238187`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6628416177195572, 0.49606769311093074`, 0.7423679733394463], 
           ArrowBox[{{2.3405139435190647`, 2.0907904987448775`}, {
            2.343062225265721, 2.093313953542742}, {2.3953359080481755`, 
            2.1449558176248535`}, {2.4489560299626887`, 2.197808467082723}, {
            2.5039225910092604`, 2.25187190191635}, {2.5602355911878902`, 
            2.3071461221257348`}, {2.6178950304985786`, 
            2.3636311277108777`}, {2.6769009089413256`, 
            2.4213269186717774`}, {2.682908633781939, 
            2.4271907283174396`}}]}}, {
          Arrowheads[{{0.01792976120151327, 1.}}], {
           LABColor[
           0.7211412761762311, 0.36312612147463447`, 0.7748909180503089], 
           
           ArrowBox[{{2.691496148791438, 2.435572529195629}, {
            2.737253226516131, 2.4802334950084357`}, {2.80455572431538, 
            2.545866742202302}, {2.8736376424358268`, 2.6131152846495125`}, {
            2.9357093166331474`, 2.6733071514741686`}, {2.9991764271431447`, 
            2.734768227965754}, {3., 2.7355647210449905`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2988309225468673, 0.5223993947284298, -0.5939262411573225], 
           
           ArrowBox[{{0.970743475701302, 0.32725991092336315`}, {
            1.033896464629412, 0.40281091789846274`}, {1.070757120127857, 
            0.4425781757631896}, {1.1111419895837484`, 0.4838007918537024}, {
            1.1846260239424282`, 0.5544922142669314}, {1.2684393591199878`, 
            0.6300341281855896}, {1.3098798992263843`, 
            0.665890592659801}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3767670345051401, 0.5222602328695354, -0.40766318254473055`], 
           
           ArrowBox[{{1.319001168569912, 0.673687862451282}, {
            1.363039411740715, 0.7108908872564934}, {1.4146802975102817`, 
            0.7535613948004632}, {1.469495189320598, 0.7979426473736425}, {
            1.5290913115384894`, 0.8453004609956871}, {1.5923389097258043`, 
            0.8947099115585982}, {1.659237983882544, 0.9461709990623762}, {
            1.6943338903793284`, 0.9727913098911215}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4598718454402166, 0.5259641800715418, -0.09021673818561829], 
           
           ArrowBox[{{1.7038947325894271`, 0.9800432266193798}, {
            1.7297885340087065`, 0.9996837235070204}, {1.8043278489113943`, 
            1.0555010434611594`}, {1.8831932173977073`, 
            1.1138759174934203`}, {1.966384639467647, 1.1748083456038043`}, {
            2.0539021151212116`, 1.2382983277923103`}, {2.090450770514353, 
            1.2645822091482224`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5448102805500382, 0.5314989173666719, 0.28818610805514755`], 
           
           ArrowBox[{{2.100193118425548, 1.2715883962123276`}, {
            2.146160121279326, 1.3046454604544861`}, {2.243573134862915, 
            1.3741493399858782`}, {2.2942127694392624`, 
            1.4100850598275305`}, {2.3461411558719782`, 
            1.4468099663864873`}, {2.399358294161063, 1.4843240596627478`}, {
            2.4538641843065157`, 1.5226273396563128`}, {2.4917548982174442`, 
            1.5492145196019613`}}]}}, {
          Arrowheads[{{0.01648956909671235, 1.}}], {
           LABColor[
           0.6287609571000108, 0.5369692905828932, 0.6621884652833447], 
           
           ArrowBox[{{2.5015779191855527`, 1.5561071431271585`}, {
            2.514575117742225, 1.5652270255771936`}, {2.5769820284591214`, 
            1.6088824713540912`}, {2.6370628069137174`, 
            1.6506226723469133`}, {2.6986605424985712`, 
            1.6933103036369686`}, {2.7618880585255354`, 
            1.7370226284260823`}, {2.826707747223992, 
            1.781733892313646}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.40400036330867756`, 0.5223234963753118, -0.33912558416245875`], 
           
           ArrowBox[{{1.354664541607242, 0.8590141907315242}, {
            1.409332233266176, 0.9109579067896425}, {1.4671511949473888`, 
            0.9649206920614177}, {1.5283794260974894`, 1.0211281263171814`}, {
            1.593274926163087, 1.0798057893272643`}, {1.659990525865541, 
            1.1393166381956152`}, {1.7091260867635505`, 
            1.1826210747517258`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4879471628108168, 0.5277936169563014, 0.03485950072097172], 
           
           ArrowBox[{{1.7181287271239623`, 1.190555333793444}, {
            1.7305161803576725`, 1.2014727156823872`}, {1.804851889639482, 
            1.2662740217875808`}, {1.8829976537109698`, 
            1.3337205565111958`}, {1.9653111300305453`, 
            1.4041185907957092`}, {2.0521499760566195`, 1.477774395583598}, {
            2.0823414251499752`, 1.503190607766617}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5712545112026464, 0.5332220697822393, 0.40599581496411213`], 
           
           ArrowBox[{{2.0915215827998654`, 1.510918783846596}, {
            2.1435141917891922`, 1.5546879708748624`}, {2.2394037772282624`, 
            1.634859316669502}, {2.2891544379907454`, 1.6762574190952335`}, {
            2.340254149985876, 1.718651495326101}, {2.3927029132136526`, 
            1.7620415453621037`}, {2.446500727674076, 1.8064275692032425`}, {
            2.4604882733190423`, 1.817938336960562}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6513474968384682, 0.5222779066003481, 0.7359558833236284], 
           
           ArrowBox[{{2.469754162097253, 1.8255635127060663`}, {
            2.5016475933671467`, 1.851809566849517}, {2.558143510292864, 
            1.898187538300927}, {2.6159884784512273`, 1.9455614835574726`}, {
            2.675182497842238, 1.9939314026191541`}, {2.7411924735698356`, 
            2.0478122725511603`}, {2.8089842271357504`, 
            2.1030242551954372`}, {2.84142019862908, 2.12931251022529}}]}}, {
          Arrowheads[{{0.007998032291539345, 1.}}], {
           LABColor[
           0.710139728418304, 0.38821311320131013`, 0.7687536140087958], 
           
           ArrowBox[{{2.850742839560139, 2.136868194580168}, {
            2.871482959263477, 2.153677358326756}, {2.935449342337099, 
            2.205429560016144}, {3., 2.2575668087741154`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6677044717481933, 0.48497885529749457`, 0.7450807565168617], 
           
           ArrowBox[{{-0.241135501509384, -3.}, {-0.23683686621429834`, \
-2.940667131920128}, {-0.23067136166597704`, -2.8553116525278743`}, \
{-0.22486870087361907`, -2.7743452340562946`}, {-0.21923445904895425`, \
-2.6954641757810256`}, {-0.21375702355373324`, -2.6185023614609575`}, \
{-0.20844026526737253`, -2.543515163176461}, {-0.20685982494272417`, \
-2.5212254071729716`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6002656964427608, 0.5351124894575815, 0.5352413685640051], 
           
           ArrowBox[{{-0.20601110369023837`, -2.509255458458145}, \
{-0.2035168877207269, -2.474078258463082}, {-0.19871952829063294`, \
-2.4061534844707446`}, {-0.1940481869770907, -2.339740841199449}, \
{-0.18950286378010006`, -2.2748403286491943`}, {-0.18079027173577394`, \
-2.1495756957118117`}, {-0.17258596542893964`, -2.030420776937782}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.525328124409328, 0.5302294259280537, 0.20139261668672304`], 
           
           ArrowBox[{{-0.17177081278679904`, -2.0184484953783497`}, \
{-0.1648344711095586, -1.9165673993291}, {-0.15750559465530306`, \
-1.8075745375628791`}, {-0.15059512279488788`, -1.703381000359933}, \
{-0.14410305552831304`, -1.6039867877202616`}, {-0.139962461172207, \
-1.5395039773877317`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4541515135656614, 0.5255914332211239, -0.11570095931560186`], 
           
           ArrowBox[{{-0.139193496358257, -1.5275286405191961`}, \
{-0.13799543211567455`, -1.5088707999590103`}, {-0.13223829181706825`, \
-1.4175119373913239`}, {-0.12683163463249422`, -1.3299102000172032`}, \
{-0.12177546056195243`, -1.2460655878366473`}, {-0.11432471874491738`, \
-1.1181223135592773`}, {-0.11046460672821175`, -1.0483908097569068`}}]}}, {
          Arrowheads[{{0.006300526933115066, 1.}}], {
           LABColor[
           0.39131450840275916`, 0.5222342570611592, -0.3728955130373252], 
           
           ArrowBox[{{-0.10980134075200304`, -1.0364091538511147`}, \
{-0.10769349584604686`, -0.9983317109068726}, {-0.10180215324104772`, \
-0.8854083792857563}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3418252321251187, 0.5223226245651197, -0.49117218525484946`], 
           
           ArrowBox[{{1.4729803925626104`, -0.13389292728240096`}, {
            1.5643467079548454`, -0.14878170253721507`}, {
            1.629472409437609, -0.15902321347581228`}, {
            1.6992143365739083`, -0.16972568318886236`}, {
            1.7735724893637446`, -0.18088911167636534`}, {
            1.8525468678071173`, -0.19251349893832123`}, {
            1.936588405902265, -0.2046640906677876}, {
            1.9474906122317666`, -0.2062151954126082}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.43396792962259234`, 0.5242762355175794, -0.20561932903270075`], 
           
           ArrowBox[{{1.9593709734837363`, -0.20790546655141867`}, {
            2.026148037647426, -0.21740613255782198`}, {
            2.1212257630426015`, -0.2307396246084245}, {
            2.2218215820877907`, -0.24466456681959514`}, {
            2.32850206033125, -0.2592590958640994}, {
            2.434845228861717, -0.27365527721125515`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.5253936267234713, 0.5302336941736429, 0.20168443112944467`], 
           
           ArrowBox[{{2.4467375852837008`, -0.27525896178896303`}, {
            2.5618166910577482`, -0.2906913244714059}, {
            2.688450843540787, -0.30752902403420806`}, {
            2.7584544635391777`, -0.31680013651479877`}, {
            2.830564289644346, -0.32631321047614803`}, {
            2.8978593540373088`, -0.3351159452159027}, {
            2.9225743199018277`, -0.33833907237008165`}}]}}, {
          Arrowheads[{{0.002753320167295712, 1.}}], {
           LABColor[
           0.6131786400934701, 0.5359539194971282, 0.5927688544949294], 
           
           ArrowBox[{{2.9344735596620004`, -0.33989087555667474`}, {
            2.96691962221686, -0.3441222301877119}, {
            3., -0.34842375926098623`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.3908293474079449, 0.5222351233592617, -0.3740550213646333], 
           
           ArrowBox[{{1.4815651499606117`, 0.6461828458185642}, {
            1.5385053126868493`, 0.6841708904210011}, {1.5988770811204172`, 
            0.7237018132174181}, {1.6647830708542992`, 0.7661176591167187}, {
            1.7346818847225538`, 0.8103987730235034}, {1.8085735227251813`, 
            0.8565451549377721}, {1.8861660731961225`, 
            0.9043768567628905}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.47757203632142686`, 0.5271175555307728, -0.011361946479191495`], 
           
           
           ArrowBox[{{1.8964133462666084`, 0.9106213169279277}, {
            1.9687088994318065`, 0.9546616321762807}, {2.055699894732306, 
            1.0070875462755604`}, {2.147430970763682, 1.061834547157364}, {
            2.2439021275259323`, 1.1189026348216908`}, {2.308472585814563, 
            1.1567923975280658`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5635937891745085, 0.5327228837086798, 0.37186710731887984`], 
           
           ArrowBox[{{2.318822295097929, 1.1628655777287358`}, {
            2.345571900215554, 1.1785621705245548`}, {2.4528988240290417`, 
            1.241083515521969}, {2.508683717607236, 1.2734173665061328`}, {
            2.5658828989663958`, 1.3064666698139338`}, {2.6244963681065228`, 
            1.3402314254453724`}, {2.6845241250276164`, 
            1.3747116334004488`}, {2.734286651705983, 
            1.4032557423517344`}}]}}, {
          Arrowheads[{{0.012237378122114041`, 1.}}], {
           LABColor[
           0.646892118894266, 0.5305386234263942, 0.7303151856747684], 
           
           ArrowBox[{{2.744695789684813, 1.4092264915959816`}, {
            2.751361854753108, 1.4130501898743186`}, {2.820060939547264, 
            1.4523447898895079`}, {2.886429418230474, 1.4900653781394686`}, {
            2.9544752781201256`, 1.5286501055987136`}, {3., 
            1.5544072277403187`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.41155932068773576`, 0.5228160512859842, -0.3054502405662413], 
           
           ArrowBox[{{1.4341893476670031`, -0.8533404225626441}, {
            1.4924854288306244`, -0.9039079690137688}, {
            1.5542191376650714`, -0.9565599046476274}, {
            1.6196492058637901`, -1.011506083587245}, {
            1.6874081227568767`, -1.067621416116086}, {
            1.7590614413823413`, -1.1262300760638788`}, {
            1.8023706321068211`, -1.1612579711741036`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4963160112669181, 0.5283389457889717, 0.07214292925896898], 
           
           ArrowBox[{{1.8117009332334135`, -1.1688041941291394`}, {
            1.8346091617401847`, -1.1873320634306241`}, {
            1.9140512838304067`, -1.2509273782163217`}, {
            1.9977535200465237`, -1.317306411067618}, {
            2.0860815827820525`, -1.3867595526311596`}, {
            2.1790354720369933`, -1.4592868029069466`}, {
            2.188270776468237, -1.4664419945380103`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5801037642427103, 0.5337987026195592, 0.44541945790191056`], 
           
           ArrowBox[{{2.1977568358568678`, -1.473791462360606}, {
            2.2766151878113456`, -1.5348881618949786`}, {
            2.32725113397636, -1.5739277065419452`}, {
            2.3792663434373442`, -1.6139079271386905`}, {
            2.432660816194299, -1.6548288236852151`}, {
            2.4874345522472234`, -1.6966903961815174`}, {
            2.543587551596118, -1.7394926446275991`}, {
            2.5785206587736074`, -1.7660529813139885`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6578939044732883, 0.5073500366507909, 0.7396078507484505], 
           
           ArrowBox[{{2.588073132757374, -1.7733159174137667`}, {
            2.6011198142409833`, -1.7832355690234594`}, {
            2.6600313401818183`, -1.8279191693690982`}, {
            2.7203221294186237`, -1.873543445664516}, {
            2.7875477506672373`, -1.9243587571296668`}, {
            2.856594629060047, -1.9764313993584712`}, {
            2.92061288943004, -2.024469426687312}, {
            2.971254882657261, -2.0624018339925714`}}]}}, {
          Arrowheads[{{0.000995996861944166, 1.}}], {
           LABColor[
           0.7168216188414438, 0.37297629984992714`, 0.7724811616231153], 
           
           ArrowBox[{{2.9808593494510824`, -2.0695958744154757`}, {
            2.986147848496756, -2.073557122523027}, {
            3., -2.0839148489964625`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.36251629614495257`, 0.5222856788302203, -0.44172167029528053`], 
           
           ArrowBox[{{0.3439036664056994, -0.7591248634105722}, {
            0.3580122695571985, -0.8375629822247156}, {
            0.38077833213299017`, -0.9566695563331961}, {
            0.4066625179698004, -1.0836178806405525`}, {
            0.4208139241273231, -1.150258509427516}, {
            0.43579288151958295`, -1.219130548134646}, {
            0.4381526034374134, -1.2297426696182903`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4178432425479193, 0.5232255226476153, -0.277455211997919], 
           
           ArrowBox[{{0.44075731800853235`, -1.2414565699936135`}, {
            0.45166114088065396`, -1.2904931501434822`}, {
            0.46848045294460994`, -1.3646054688355633`}, {
            0.48771247646077864`, -1.4477309049860956`}, {
            0.508153955130606, -1.5345086818307427`}, {
            0.5298048889540924, -1.6249387993695048`}, {
            0.5501834921663514, -1.708807411031299}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4875853892727491, 0.5277700431585155, 0.03324779058853982], 
           
           ArrowBox[{{0.5530213327165531, -1.7204670212310231`}, {
            0.576848671796363, -1.817218143894205}, {
            0.6024686202837911, -1.9199915456098067`}, {
            0.6295251233935217, -2.027341462749187}, {
            0.6580181811255549, -2.139267895312345}, {
            0.6700200557622283, -2.1859870062976783`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5620399217573562, 0.5326216309844651, 0.3649445892318554], 
           
           ArrowBox[{{0.6730058387571372, -2.1976096178762914`}, {
            0.6880880091259167, -2.2563192455544234`}, {
            0.7198748230406338, -2.379043915730565}, {
            0.7364120997158754, -2.4425337457939094`}, {
            0.7533786228697058, -2.5074419058407686`}, {
            0.7707743925021249, -2.5737683958711446`}, {
            0.7885994086131328, -2.6415132158850354`}, {
            0.7940252394349323, -2.662102304974138}}]}}, {
          Arrowheads[{{0.01406785524923169, 1.}}], {
           LABColor[
           0.6386516459516068, 0.5366194199422756, 0.704599526087567], 
           
           ArrowBox[{{0.7970831908025902, -2.6737061376785953`}, {
            0.8084359523928635, -2.7167858110901513`}, {
            0.8288369360269772, -2.7939549347312296`}, {
            0.849372662392753, -2.871072079705444}, {
            0.8704589229948618, -2.9500463295009984`}, {
            0.8838306798059836, -3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.38162768060271307`, 0.5222515537536626, -0.3960465033671494], 
           
           ArrowBox[{{0.14000421007732383`, -0.9439826901142305}, {
            0.14880203982127232`, -1.065333236881626}, {
            0.15359909550940465`, -1.1288062056432073`}, {
            0.15866768263027373`, -1.1942447364943796`}, {
            0.16402725565759504`, -1.2618762128811394`}, {
            0.16969726906508417`, -1.3319280182494833`}, {
            0.1767424408588414, -1.4171658819578126`}, {
            0.1771954231390543, -1.4225363233471324`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.44154036074104025`, 0.5247696684007246, -0.1718839595915523], 
           
           ArrowBox[{{0.17820400942997772`, -1.4344938629642008`}, {
            0.1842527545688346, -1.506206229354993}, {
            0.19222821019506384`, -1.5990490604410255`}, {
            0.2006688077375292, -1.6956943752159104`}, {
            0.2096191250827078, -1.7966461657299841`}, {
            0.2191237401170768, -1.9024084240335841`}, {
            0.2200567772609516, -1.9126648467086458`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5119256855120538, 0.5293560995203499, 0.14168441722744093`], 
           
           ArrowBox[{{0.22114394013588565`, -1.9246154984433155`}, {
            0.22918265284063635`, -2.0129811501267105`}, {
            0.2397958632533863, -2.1283643440093627`}, {
            0.25101885322491896`, -2.2491582579937512`}, {
            0.26290710462482625`, -2.375963144392085}, {
            0.2654169319946943, -2.4025691020830915`}}]}}, {
          Arrowheads[{{0.01999999999999999, 1.}}], {
           LABColor[
           0.5862978174248707, 0.5342023179806262, 0.4730141192688839], 
           
           ArrowBox[{{0.26654392807341876`, -2.4145160631962175`}, {
            0.26910070336042047`, -2.4416197022464816`}, {
            0.2754606174531084, -2.5087790032043644`}, {
            0.28198684690289, -2.577441047265734}, {
            0.28867939170976525`, -2.6476058344305895`}, {
            0.296089475875653, -2.7251615869067423`}, {
            0.3037162844928804, -2.804711630835754}, {
            0.311958874563633, -2.889985646389092}, {
            0.3121872302352927, -2.8923409077608637`}}]}}, {
          Arrowheads[{{0.004006855932569939, 1.}}], {
           LABColor[
           0.6575994858076047, 0.5080214038795391, 0.7394436068705385], 
           
           ArrowBox[{{0.31334526662706447`, -2.904284900046332}, {
            0.3204441024280657, -2.9775023227848716`}, {
            0.3226317472044753, -3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6242029882025778, 0.5366722853412256, 0.6418826001984097], 
           
           ArrowBox[{{-3., -0.3226028794151009}, {-2.9820423048958116`, \
-0.3204393815984406}, {-2.9033358147211628`, -0.31092566677757955`}, \
{-2.8249483510546014`, -0.3013655103305641}, {-2.7490300279152775`, \
-0.2920702448590216}, {-2.67540005644848, -0.2830170818223565}, \
{-2.604118699605779, -0.27421361740076733`}, {-2.523561230501723, \
-0.26424317997222047`}}]}}, {
          Arrowheads[{{0.015493880070841098`, 1.}}], {
           LABColor[
           0.5366876498600742, 0.5309696325151652, 0.251999585804403], 
           
           ArrowBox[{{-2.511652098964414, -0.2627692104925227}, \
{-2.4785178405167603`, -0.2586682493492809}, {-2.3597508705948047`, \
-0.2438284565327794}, {-2.247817789839912, -0.2296942389512629}, \
{-2.142718598252082, -0.21626559660473127`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6080122994987415, 0.5356172716894306, 0.5697526783296063], 
           
           ArrowBox[{{-2.8015096792125855`, -0.7617990669679707}, \
{-2.7293502928790394`, -0.7395628529603868}, {-2.6593008537035985`, \
-0.7178982446141623}, {-2.5939044818447634`, -0.6974807266047707}, \
{-2.530410539346242, -0.677577634266895}, {-2.4087889198986105`, \
-0.6392046720942538}, {-2.343407427717956, -0.6184796949026015}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5209054597426787, 0.5299412373471986, 0.18168953532355997`], 
           
           ArrowBox[{{-2.3319683707737675`, -0.614853681081943}, \
{-2.2975534333958954`, -0.6039446490543812}, {-2.192218836552548, \
-0.5702184210785677}, {-2.092785129368568, -0.5380259881668135}, \
{-1.999252311843954, -0.5073673503191182}, {-1.911127400457691, \
-0.4780797305727899}, {-1.875608663710805, -0.46609386118935603`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.43060488869277314`, 0.524057093876516, -0.2206017602279821], 
           
           ArrowBox[{{-1.8642385910750057`, -0.4622570072363563}, \
{-1.8279174116887615`, -0.45000035196513644`}, {-1.7496223455371658`, \
-0.4231292144961578}, {-1.6762422020029035`, -0.39746631816585404`}, \
{-1.607388133489223, -0.372875687708777}, {-1.542671292399372, \
-0.34922134785947856`}, {-1.4820916787333507`, -0.32650329861795885`}, \
{-1.4256492924911595`, -0.3047215399842179}, {-1.4127241784909115`, \
-0.29951617208193465`}}]}}, {
          Arrowheads[{{0.011346025161524607`, 1.}}], {
           LABColor[
           0.3408621967055536, 0.5223243441505057, -0.49347378740426756`], 
           
           ArrowBox[{{-1.4015929786538, -0.29503327232995646`}, \
{-1.3442732824608863`, -0.2719487481450638}, {-1.272294675524284, \
-0.24112310863338415`}, {-1.2088474543498284`, -0.2119247005517691}, \
{-1.1530656016059944`, -0.18403360300280866`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6552828325078057, 0.5133041025910688, 0.7381512427439185], 
           
           ArrowBox[{{-3., -1.0700875990442837`}, {-2.9423132201270406`, \
-1.0473065530515016`}, {-2.867441654769569, -1.0176541104918686`}, \
{-2.801268422132969, -0.9912567995851866}, {-2.7368486125632248`, \
-0.9654824028939079}, {-2.674070380198691, -0.9402852288994308}, \
{-2.6129710069932504`, -0.9156805081079561}, {-2.5542632941587824`, \
-0.8919941368259839}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5741605547696592, 0.5334114326742071, 0.4189423115134728], 
           
           ArrowBox[{{-2.5431349109941364`, -0.8875042495065941}, \
{-2.493929306613744, -0.8676516243874032}, {-2.380886406997192, \
-0.821692121093921}, {-2.2738423081435966`, -0.7778019982275101}, \
{-2.1727970100529554`, -0.7359812557881696}, {-2.0991194374125137`, \
-0.7051678632836931}}]}}, {
          Arrowheads[{{0.01557941536986282, 1.}}], {
           LABColor[
           0.4867762524974686, 0.5277173183881425, 0.02964306607991946], 
           
           ArrowBox[{{-2.088048627106016, -0.7005378352970019}, \
{-2.0772516053727337`, -0.6960223110116053}, {-1.9867071867503958`, \
-0.6577175811335221}, {-1.9011637541859407`, -0.6210670661539197}, \
{-1.8206213076793696`, -0.5860707660727985}, {-1.7446803359332757`, \
-0.5525549850885055}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.632025904591786, 0.5371820402836147, 0.6767338877663112], 
           
           ArrowBox[{{-3., -0.5683985785963878}, {-2.9832024839622835`, \
-0.564844148604389}, {-2.905538053391689, -0.5483580321466834}, \
{-2.831858641068071, -0.5325876465436359}, {-2.7603474791495963`, \
-0.5172270659009183}, {-2.6908542693832747`, -0.5022431633266611}, \
{-2.6234291111867707`, -0.48764698111815413`}, {-2.5307175569110445`, \
-0.4675354058923627}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5450140924827371, 0.531512198109408, 0.28909409529709995`], 
           
           ArrowBox[{{-2.518990309734515, -0.4649914574533063}, \
{-2.499819009230873, -0.460832698005605}, {-2.3827352653117835`, \
-0.43520970174868123`}, {-2.272177879429505, -0.41077799234738344`}, \
{-2.168146851584035, -0.38753756980171117`}, {-2.070083939612137, \
-0.36536292997805225`}, {-2.050424397526571, -0.3608573268570174}}]}}, {
          Arrowheads[{{0.01625437594729387, 1.}}], {
           LABColor[
           0.4550769960894339, 0.5256517392843765, -0.11157791159652385`], 
           
           ArrowBox[{{-2.0387276474533302`, -0.35817664826305107`}, \
{-1.977430901350572, -0.3441285687427941}, {-1.8901877367993412`, \
-0.32383448609593696`}, {-1.808354445958444, -0.3044806820374806}, \
{-1.7314897226165595`, -0.28596280315828154`}, {-1.659152260562367, \
-0.26817649604919624`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.009829057039343178, 1.}}], {
           LABColor[
           0.7157490578441024, 0.3754220765223296, 0.7718828246355756], 
           
           ArrowBox[{{-1.8142765335710775`, -3.}, {-1.7729463003678512`, \
-2.925994735442227}, {-1.735835216417815, -2.8592141274272125`}, \
{-1.6995878300460534`, -2.7938593139667667`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.009004754137901711, 1.}}], {
           LABColor[
           0.7655645567239752, 0.26182705918859905`, 0.7996728110386379], 
           
           ArrowBox[{{2.802765189662507, 2.8416036078561975`}, {
            2.8716832741152154`, 2.9159981957903205`}, {2.9329531806358426`, 
            2.9819108652810984`}, {2.949788473975474, 3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.7521253744916853, 0.29247262478475017`, 0.7921756525256974], 
           
           ArrowBox[{{-3., 2.496129138695068}, {-2.9998381437018713`, 
            2.495985520132478}, {-2.925590465201525, 
            2.4299925803065747`}, {-2.8660968396736988`, 
            2.376901067835764}, {-2.807927808985568, 
            2.3249101022064043`}, {-2.7510076612505676`, 
            2.2739513170023566`}, {-2.69536163376422, 
            2.224047501029001}, {-2.6420992232677194`, 
            2.1762753978802216`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6936499359566584, 0.4258150303280918, 0.7595546474501451], 
           
           ArrowBox[{{-2.6331678376021697`, 
            2.168261015544562}, {-2.576305093581613, 
            2.11715491172575}, {-2.5188365776013013`, 
            2.0653933945085305`}, {-2.4627412310283185`, 
            2.014755062247583}, {-2.4080190538626645`, 
            1.9652399149429063`}, {-2.354670046104338, 
            1.9168479525945006`}, {-2.30269420775334, 
            1.8695791752023658`}, {-2.2771642224041306`, 
            1.846297867646639}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.631232248978649, 0.5371303242928993, 0.6731981322210429], 
           
           ArrowBox[{{-2.2682974384352677`, 
            1.8382120688580519`}, {-2.2520915388096707`, 
            1.8234335827665022`}, {-2.202749820348596, 
            1.7783087009254481`}, {-2.1545568334453815`, 
            1.7341020553177424`}, {-2.107512578100028, 
            1.690813645943384}, {-2.061617054312536, 
            1.6484434728023747`}, {-1.9732722014111335`, 
            1.5664578352203993`}, {-1.9156516050361132`, 
            1.5125780978454932`}}]}}, {
          Arrowheads[{{0.009896628490885412, 1.}}], {
           LABColor[
           0.5487319124786818, 0.5317544577762069, 0.3056570760779125], 
           
           ArrowBox[{{-1.906886572380534, 
            1.5043821108673052`}, {-1.8895222747411742`, 
            1.4881451425718157`}, {-1.8099994031802564`, 
            1.4131610626066156`}, {-1.7343357156059769`, 
            1.3411612630747891`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6600628450931232, 0.5024041693435073, 0.7408178121397759], 
           
           ArrowBox[{{1.98165174922295, -2.344551049526993}, {
            2.0258581722571596`, -2.402574191044435}, {
            2.071206808519875, -2.4619578568976257`}, {
            2.117697658011097, -2.5227020470865638`}, {
            2.165330720730826, -2.584806761611252}, {
            2.214105996679061, -2.648272000471687}, {
            2.264023485855802, -2.713097763667871}, {
            2.2736220834918086`, -2.7255399737300814`}}]}}, {
          Arrowheads[{{0.013958297612625431`, 1.}}], {
           LABColor[
           0.7176325694803819, 0.37112707713895693`, 0.7729335571172162], 
           
           ArrowBox[{{2.2809518787611514`, -2.7350412421353796`}, {
            2.31508318826105, -2.779284051199803}, {
            2.372032524357319, -2.8530385726719314`}, {
            2.4304917734979514`, -2.928609164191012}, {
            2.4831951521878812`, -2.9964677815546286`}, {
            2.4859423839264796`, -3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.017255839241224747`, 1.}}], {
           LABColor[
           0.7295086251114842, 0.34404593220202484`, 0.7795587125794993], 
           
           ArrowBox[{{2.5106660647936185`, -2.6877186103906485`}, {
            2.567226427231476, -2.7528423382435556`}, {
            2.6302995683164854`, -2.825404704909962}, {
            2.695033861373727, -2.8997514304799137`}, {
            2.7529253930109965`, -2.965995544267807}, {
            2.78268091528322, -3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5192317723253813, 0.5298321769417775, 0.1742332161483388], 
           
           ArrowBox[{{1.470296232006458, 1.6047516237841197`}, {
            1.5334666823398762`, 1.6892301424542415`}, {1.5999342615094356`, 
            1.7773406844666217`}, {1.669698969515137, 1.8690832498212613`}, {
            1.7430721656398198`, 1.964864754969623}, {1.7603144222856604`, 
            1.987223117497945}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5994106703263519, 0.5350567744573148, 0.5314322058964682], 
           
           ArrowBox[{{1.7676425654076933`, 1.9967256602304455`}, {
            1.820365209166324, 2.06509211636317}, {1.8604816737052594`, 
            2.116872993151888}, {1.90157810009465, 2.169765334001903}, {
            1.943654488334496, 2.2237691389132137`}, {1.9867108384247971`, 
            2.278884407885821}, {2.030841463375105, 2.3352317525468833`}, {
            2.062464042376014, 2.3755111239962963`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6698455267876705, 0.4800965758906702, 0.7462751617074784], 
           
           ArrowBox[{{2.0698742060379822`, 2.3849498460762626`}, {
            2.0761406761949717`, 2.39293178452356}, {2.1226084768843956`, 
            2.45198450381585}, {2.1702448654433777`, 2.512389910423754}, {
            2.219049841871919, 2.574148004347273}, {2.269023406170018, 
            2.6372587855864054`}, {2.3201655583376746`, 2.701722254141152}, {
            2.3676269477243745`, 2.761437069864971}}]}}, {
          Arrowheads[{{0.01221488228466515, 1.}}], {
           LABColor[
           0.7275220586590299, 0.34857592900372963`, 0.7784504901197461], 
           ArrowBox[{{2.3750948867909916`, 2.7708301460394025`}, {
            2.4308188581989425`, 2.8408788040006128`}, {2.4907061313016596`, 
            2.916024469903128}, {2.5446027662404775`, 2.983388098729464}, {
            2.557912205130576, 3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3069003939989489, 0.5223849859695201, -0.5746406443231303], 
           
           ArrowBox[{{0.5055929648390314, 0.049849643720886266`}, {
            0.505752826228746, 0.05438651260199838}, {0.5059266058190994, 
            0.05892487818723875}, {0.5061143083925924, 0.06346486537141374}, {
            0.5063159390932894, 0.06800659857336509}, {0.5064326877586699, 
            0.07050532990069577}, {0.5134111207273133, 
            0.16058650045749365`}, {0.525858887696217, 0.252380026187735}, {
            0.5439409813423255, 0.3468773637485989}, {0.567822394342584, 
            0.4450699697972651}, {0.5899249709141038, 
            0.5209937606036631}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3357030640644801, 0.5223335562406469, -0.5058038331477468], 
           
           ArrowBox[{{0.5932791157667622, 0.5325154667406632}, {
            0.5977963114603522, 0.548032328304831}, {0.6341559174589905, 
            0.656838923242394}, {0.6598464206244367, 0.7267613839500159}, {
            0.6881798055560505, 0.799600434655572}, {0.7110738393736443, 
            0.8561504511679147}, {0.7355479894902376, 0.9146054223343738}, {
            0.7616651596210782, 0.9751062838804229}, {0.76417717795338, 
            0.9807660649737721}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.39076855652078074`, 0.522235231906797, -0.37420030827072165`], 
           
           ArrowBox[{{0.7690452721997894, 0.9917342762412521}, {
            0.7894882534814137, 1.0377939715315356`}, {0.8190186580610829, 
            1.1027013088473232`}, {0.8503069737302512, 1.1699476091200864`}, {
            0.8834899242746574, 1.2398035426743346`}, {0.9187042334800402, 
            1.3125397798345757`}, {0.9562289892189634, 1.3887188567957873`}, {
            0.9746018891612807, 1.4254397160324648`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.461898067834937, 0.5260962122739457, -0.08118986689598798], 
           
           ArrowBox[{{0.9799713676702155, 1.4361713841480042`}, {
            0.99600434235888, 1.4682155692541143`}, {1.0380302928997904`, 
            1.5510299172095583`}, {1.082306840841695, 1.6371619006621183`}, {
            1.1290423338213875`, 1.7270128288381443`}, {1.178445119475663, 
            1.8209840109639857`}, {1.2004867131992012`, 
            1.8625067367045338`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5384887963088429, 0.5310869983744619, 0.26002373814285007`], 
           
           ArrowBox[{{1.2061131207457896`, 1.8731059601723021`}, {
            1.230515197804521, 1.9190754470396418`}, {1.285252568807962, 
            2.021287137065114}, {1.34291260457887, 2.1280941672168465`}, {
            1.4037506772101294`, 2.239971623671285}, {1.4340995124258709`, 
            2.29550267040511}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6169261845054506, 0.5361981160589713, 0.6094642582903205], 
           
           ArrowBox[{{1.4398652676134498`, 2.3060267391941243`}, {
            1.4677667867017408`, 2.3569195064284303`}, {1.5009666052701782`, 
            2.4172948576705173`}, {1.5349609330537035`, 
            2.4789378154882806`}, {1.5728729541648934`, 
            2.5475894365426583`}, {1.611833500072323, 2.617939229200829}, {
            1.6488104284326628`, 2.684286792996949}, {1.672153165466164, 
            2.7260754052186775`}}]}}, {
          Arrowheads[{{0.0074500133714428055`, 1.}}], {
           LABColor[
           0.6813911715027672, 0.45376887184211334`, 0.7527159947185227], 
           
           ArrowBox[{{1.678005164232676, 2.736551764817161}, {
            1.6866998558549513`, 2.7521171672834317`}, {1.7255684463220016`, 
            2.821548463739153}, {1.7653939785062098`, 
            2.8925413118044885`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4106898826686459, 0.5227593971808804, -0.3093236086195631], 
           
           ArrowBox[{{0.9518243522293858, 1.095100534630284}, {
            0.9898430858128167, 1.1627122265642127`}, {1.030106959302048, 
            1.2329395287925822`}, {1.0726898111344219`, 
            1.3059178668644886`}, {1.1177823617803948`, 
            1.3819541271888638`}, {1.1655753317104232`, 
            1.4613551961746394`}, {1.1946896440482377`, 
            1.509087716236302}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4868141698970952, 0.5277197891523564, 0.029811989040675776`], 
           
           ArrowBox[{{1.2009383595174248`, 1.5193324004669233`}, {
            1.2144324560311097`, 1.541455788616362}, {1.2660650933759807`, 
            1.6251190202338008`}, {1.320473243745036, 1.7123448910269563`}, {
            1.3776569071382758`, 1.8031334009958284`}, {1.437876600367252, 
            1.897895074639783}, {1.4558912881064774`, 
            1.9260150127442814`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.5653634501193239, 0.5328381979173574, 0.379750990952166], 
           
           ArrowBox[{{1.4623645017735816`, 1.9361193437374753`}, {
            1.5013928402435162`, 1.9970404364581857`}, {1.5682056267670685`, 
            2.1005694864510374`}, {1.6383149599379088`, 
            2.2084822246183364`}, {1.6746850745907114`, 2.264204109955147}, {
            1.7120378120546342`, 2.3212651837110556`}, {1.723564571093497, 
            2.3388251008493834`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6441164280474934, 0.5328072773672738, 0.722019460368903], 
           
           ArrowBox[{{1.7301496716160483`, 2.3488568729315182`}, {
            1.7503731723296778`, 2.379665445886061}, {1.7896911554158417`, 
            2.4394048964801645`}, {1.829991761313127, 2.500483535493366}, {
            1.8712749900215317`, 2.5629013629256647`}, {1.9135408415410575`, 
            2.626658378777061}, {1.9567893158717038`, 2.6917545830475555`}, {
            1.9949845619434223`, 2.749183781974083}}]}}, {
          Arrowheads[{{0.01207385462459194, 1.}}], {
           LABColor[
           0.7019935453178667, 0.40678897475655396`, 0.764209198662401], 
           
           ArrowBox[{{2.001630012823724, 2.7591756778200924`}, {
            2.005035282065901, 2.7642957360687075`}, {2.0545800768675164`, 
            2.838627496007952}, {2.1000850752724896`, 2.9065738994045223`}, {
            2.1466521609026157`, 2.975988172748751}, {2.1627870376326874`, 
            3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.39876110948911403`, 0.5222209604926805, -0.3550985424191998], 
           
           ArrowBox[{{0.6748046951130958, 1.0709607802830317`}, {
            0.6999468574309241, 1.1382531186288958`}, {0.7265979688602433, 
            1.2079742620748712`}, {0.7548037114331101, 1.280251749635541}, {
            0.7846866424972722, 1.355376685781912}, {0.816369319400477, 
            1.433640174984992}, {0.8501798941020557, 1.515834584339662}, {
            0.8508641906361681, 1.5174742468880555`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.46967732147511143`, 0.5266031220750843, -0.04653309796370444], 
           
           ArrowBox[{{0.8554859267661891, 1.528548521362912}, {
            0.8859958665037844, 1.6016542628765298`}, {0.9238172366056633, 
            1.6910992105955964`}, {0.9636440044076923, 1.7841694274968614`}, {
            1.0056638264924322`, 1.8812994538165122`}, {1.0443419184165856`, 
            1.9698262505576927`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5453050863318343, 0.5315311597786119, 0.29039048015037067`], 
           
           ArrowBox[{{1.0491462826049793`, 1.9808225265066346`}, {
            1.050064359442444, 1.9829238297907366`}, {1.0968456032577278`, 
            2.0890425554195344`}, {1.146007557938283, 2.1996556307029054`}, {
            1.1715387318335997`, 2.2567763176333773`}, {1.1977799434063594`, 
            2.3152781283141346`}, {1.2247311926565618`, 
            2.3751610627451774`}, {1.2446215652047221`, 
            2.4192141447375755`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[0.6230556747425957, 0.5365975243853879, 0.63677129012746], 
           ArrowBox[{{1.2495596639549318`, 2.4301510172673795`}, {
            1.2523924795842065`, 2.436425120926505}, {1.2807638041892946`, 
            2.49907030285812}, {1.309845166471825, 2.5630966085400195`}, {
            1.3396365664317977`, 2.6285040379722053`}, {1.3701380040692135`, 
            2.695292591154676}, {1.4041545639103385`, 2.7696824472017774`}, {
            1.4391088113130688`, 2.8459217317782155`}, {1.4487657331896209`, 
            2.8668616455071065`}}]}}, {
          Arrowheads[{{0.005610461359045399, 1.}}], {
           LABColor[
           0.6854127555276684, 0.4445983944346838, 0.7549594684944309], 
           
           ArrowBox[{{1.4537911475916534`, 2.8777586730874996`}, {
            1.47234334791449, 2.9179869652086747`}, {1.5063973024958948`, 
            2.991673409142909}, {1.5102532196471647`, 3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4235832670015948, 0.5235995527010021, -0.2518832599369465], 
           
           ArrowBox[{{1.7878516767008739`, 0.5343975564056371}, {
            1.8647659607940767`, 0.5660220677315183}, {1.9459933346306715`, 
            0.5989356737343344}, {2.031943075834864, 0.6333022160344794}, {
            2.1230244620308594`, 0.6692855362523471}, {2.219237493218658, 
            0.7068856343879374}, {2.2335987458590063`, 
            0.7124429412539512}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5134275682381141, 0.5294539648309845, 0.14837534221948137`], 
           
           ArrowBox[{{2.2447900581910734`, 0.7167735911227494}, {
            2.3205821693982593`, 0.7461025104412502}, {2.4275638829423984`, 
            0.7871310718463624}, {2.5406880262238096`, 0.8301662260373508}, {
            2.599553509015993, 0.8524362754275487}, {2.659954599242494, 
            0.8752079730142156}, {2.693307631116532, 0.8877407148786801}}]}}, {
          Arrowheads[{{0.013139398846358624`, 1.}}], {
           LABColor[
           0.6003247704167246, 0.5351163388212583, 0.5355045445909441], 
           
           ArrowBox[{{2.7045407712752847`, 0.8919616818500992}, {
            2.7218912969033138`, 0.8984813187973515}, {2.7853636019984513`, 
            0.9222563127769564}, {2.8557852835053184`, 0.9485940407151705}, {
            2.9282149016896124`, 0.9755988373250633}, {3., 
            1.002172537426264}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.4385812775212445, 0.5245768493520239, -0.18506674911653312`], 
           
           ArrowBox[{{1.9999492042450124`, 0.0667585653604974}, {
            2.0946116118271445`, 0.07094011523339838}, {2.1951436621824394`, 
            0.07532024665684438}, {2.301545355310897, 0.07989895963083532}, {
            2.414433546378792, 0.08470270633835464}, {2.4795031648361165`, 
            0.08744408332724317}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5299884837360476, 0.5305331031095436, 0.2221546336870984], 
           
           ArrowBox[{{2.4914925294173624`, 0.087949194144759}, {
            2.5344250905523955`, 0.08975793896238568}, {2.5970846200538396`, 
            0.09237986249309312}, {2.661519987831711, 0.09506465750292847}, {
            2.72773119388601, 0.09781232399189178}, {2.7957182382167365`, 
            0.100622861959983}, {2.8695168553385417`, 0.10366799939393698`}, {
            2.9455446396581797`, 0.10679369168232987`}, {2.971080396552217, 
            0.10783514046922066`}}]}}, {
          Arrowheads[{{0.0007059852030727684, 1.}}], {
           LABColor[
           0.6178684015109273, 0.5362595125703806, 0.6136618585426424], 
           
           ArrowBox[{{2.9830704290062213`, 0.10832414123805707`}, {3., 
            0.10901459585223651`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.7503618213287966, 0.29649408109075603`, 0.7911918398665904], 
           
           ArrowBox[{{-2.3895344144876782`, -3.}, {-2.33106983389723, \
-2.9214810710122556`}, {-2.283611089511277, -2.8574815081108205`}, \
{-2.2372118637674063`, -2.7948101593223558`}, {-2.1918115388209816`, \
-2.733384299678129}, {-2.147430320620215, -2.6732315041677177`}, \
{-2.103906345879687, -2.6142332183512824`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6927865604512281, 0.42778379823587404`, 0.7590730063124241], 
           
           ArrowBox[{{-2.0967861522094284`, -2.60457388047922}, \
{-2.0526240108920195`, -2.5445848856108553`}, {-2.006863296379901, \
-2.4822879891056573`}, {-1.9621975421024362`, -2.4213420344492818`}, \
{-1.9186267480596242`, -2.3617470216417282`}, {-1.8761509142514654`, \
-2.3035029506829967`}, {-1.8347700406779595`, -2.2466098215730876`}, \
{-1.8134051701683058`, -2.2171540753752814`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6317134042596418, 0.5371616772142831, 0.6753416909948302], 
           
           ArrowBox[{{-1.8063595157880667`, -2.2074402319364452`}, \
{-1.7944841273391068`, -2.191067634312001}, {-1.7552037583030622`, \
-2.1367529503730847`}, {-1.7168395176379807`, -2.083542331229687}, \
{-1.6793914053438619`, -2.031435776881808}, {-1.6428594214207064`, \
-1.9804332873294477`}, {-1.5725438386872843`, -1.881740502611283}, \
{-1.526903148507261, -1.817182713191131}}]}}, {
          Arrowheads[{{0.014209305961633285`, 1.}}], {
           LABColor[
           0.5516045176342391, 0.5319416417626801, 0.31845460367049583`], 
           
           ArrowBox[{{-1.5199758115113848`, -1.8073841417572143`}, \
{-1.5058927694377147`, -1.7874639770751937`}, {-1.4426132350629066`, \
-1.697188827432789}, {-1.3824122569537693`, -1.6105001703956783`}, \
{-1.3252898351103033`, -1.5273980059638623`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.7123089530678175, 0.3832665982169585, 0.7699637338484171], 
           
           ArrowBox[{{-2.8846099832956575`, -2.1255882968389788`}, \
{-2.821885732849956, -2.075536986692123}, {-2.76066562787165, \
-2.026594044891366}, {-2.7009496683607424`, -1.9787594714367065`}, \
{-2.642737854317232, -1.9320332663281454`}, {-2.5768209698464166`, \
-1.8790654718269455`}, {-2.5127134448346484`, -1.8274170518378259`}, \
{-2.510126321730368, -1.8253194662890442`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6534789885658016, 0.5174174345553525, 0.7371449535417883], 
           
           ArrowBox[{{-2.500805108511767, -1.8177620206800191`}, \
{-2.459217441472447, -1.7840436061040386`}, {-2.4070167158389513`, \
-1.7416127326439423`}, {-2.3062961002737428`, -1.6594092324040521`}, \
{-2.2546120665253864`, -1.617161257411403}, {-2.2041647832072186`, \
-1.575790938693642}, {-2.154954250319239, -1.5352982762507685`}, \
{-2.129155148967203, -1.5139943159034974`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5741736583345172, 0.5334122865254587, 0.41900068822163455`], 
           
           ArrowBox[{{-2.119902139273457, -1.506353516756324}, \
{-2.106980467861448, -1.4956832700827831`}, {-2.0147431542364327`, \
-1.4190862265714763`}, {-1.927452842332171, -1.3459998081597213`}, \
{-1.844707739852287, -1.27608614530381}, {-1.7661060545004033`, \
-1.2090073684600344`}, {-1.7525990972053505`, -1.1973533304246367`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4907507417122192, 0.5279763030710783, 0.04734951463021735], 
           
           ArrowBox[{{-1.7435135414540064`, -1.189514154658702}, \
{-1.6916477862765205`, -1.144763477628395}, {-1.6213329351806376`, \
-1.0833544728088913`}, {-1.5548365085423428`, -1.0244961595697752`}, \
{-1.4918335136912226`, -0.9679043434792982}, {-1.4323239506272778`, \
-0.9135790245374606}, {-1.385389819900734, -0.8699605972769354}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4065206397604985, 0.5224877220059571, -0.32789768972986705`], 
           
           ArrowBox[{{-1.376599729270423, -0.8617914904279022}, \
{-1.3763078193505076`, -0.8615202027442621}, {-1.2922191587311966`, \
-0.7812496986297568}, {-1.2164525355955922`, -0.7060782604277074}, \
{-1.1482141743151906`, -0.6352847633455507}, {-1.0867102992614888`, \
-0.5681480825907237}, {-1.0427825302128357`, -0.5172356636985238}}]}}, {
          Arrowheads[{{0.018605840956240422`, 1.}}], {
           LABColor[
           0.3315998906861736, 0.5223408828216163, -0.5156101938226327], 
           
           ArrowBox[{{-1.0349433905408092`, -0.5081500768048521}, \
{-1.0316455251452723`, -0.504327840709008}, {-0.9830092611569203, \
-0.4437012301538109}, {-0.9404349233873203, -0.3858734809940081}, \
{-0.9035559279273594, -0.33044982329847483`}, {-0.846380571579856, \
-0.2254350263238057}, {-0.8104764074014132, -0.12589732727698144`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3252901993566042, 0.5223521493366169, -0.5306900121047688], 
           
           ArrowBox[{{0.15998749528143827`, 0.08093258529724257}, {
            0.16086551498889762`, 0.13171422689146256`}, {
            0.16216358464509287`, 0.18284032052885218`}, {
            0.16605280487530083`, 0.28701094247686393`}, {0.1716866887838562, 
            0.3941964894236024}, {0.17913547928161655`, 0.5055475662090264}, {
            0.1835130805622311, 0.5602642811686207}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3480655206067534, 0.5223114819750762, -0.4762582359955315], 
           
           ArrowBox[{{0.18447008059460968`, 0.572226059921717}, {
            0.18846941927943944`, 0.6222147776730946}, {0.1951980485955425, 
            0.69674151182616}, {0.20269766213057291`, 0.7740313507481185}, {
            0.21435377945211675`, 0.8861824638975975}, {0.22762998471842683`, 
            1.0050370514933784`}, {0.23285730359316226`, 
            1.0497524145225192`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3941040928247952, 0.5222292760100912, -0.36622855835289514`], 
           
           ArrowBox[{{0.23425064010622848`, 1.0616712489186066`}, {
            0.23489343693055406`, 1.0671698408435448`}, {0.2425832910484947, 
            1.1312085299671817`}, {0.25072974293344447`, 
            1.1973791391700104`}, {0.2593629884465993, 1.265907688757752}, {
            0.2698904291931706, 1.3476102424330865`}, {0.2811177364702413, 
            1.4328801751707188`}, {0.29304491027781143`, 1.521717486970649}, {
            0.2952391296952199, 1.5377747863473075`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.45854835178674247`, 0.5258779389055223, -0.09611293541139337], 
           
           ArrowBox[{{0.2968638229919213, 1.5496642931365587`}, {
            0.30567195061588104`, 1.6141221778328771`}, {0.31906462475105235`,
             1.7105691112900996`}, {0.33328869994992766`, 
            1.8115331508750114`}, {0.348344176212507, 1.9170142965876136`}, {
            0.36393371226213966`, 2.024953803971094}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5304333248437245, 0.5305620897357497, 0.2241364119133187], 
           
           ArrowBox[{{0.3656640457121816, 2.0368283944077588`}, {
            0.38103122859294897`, 2.1420919841905723`}, {0.39882659803915455`,
             2.262816681670298}, {0.4080974806592749, 2.3252960035540586`}, {
            0.417617161877407, 2.3891866408670843`}, {0.42738564169355076`, 
            2.454488593609374}, {0.4359688614751955, 2.511651289842225}}]}}, {
         
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6057773695788498, 0.5354716397389051, 0.5597960098114938], 
           
           ArrowBox[{{0.43775135630458817`, 2.5235181643492077`}, {
            0.44851092040350626`, 2.5950446193470094`}, {0.4599437205487035, 
            2.670766210306881}, {0.4720926591309641, 2.7505347764375507`}, {
            0.48459316342545106`, 2.8323467044339954`}, {0.4974751034853946, 
            2.916394784089431}, {0.5100261320793431, 
            2.9980453583943136`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.7531067055906834, 0.29023488099602224`, 0.7927230961629441], 
           
           ArrowBox[{{-2.8861350036776097`, -2.6226606348892054`}, \
{-2.814584295474514, -2.5532114925862217`}, {-2.7449298689417376`, \
-2.4854825298358407`}, {-2.688964314033952, -2.430833457964691}, \
{-2.6342528238895455`, -2.377320276037634}, {-2.580723575826302, \
-2.3248719726883627`}, {-2.542587505059125, -2.28743801842962}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6948555962130075, 0.4230657454509328, 0.7602272349557214], 
           
           ArrowBox[{{-2.534023757061509, -2.2790319360939937`}, \
{-2.528400510738293, -2.273512218372312}, {-2.4719456683795764`, \
-2.2180896426115115`}, {-2.4167833936002747`, -2.163818655305884}, \
{-2.3629136864003875`, -2.1106992564554274`}, {-2.3103365467799137`, \
-2.0587314460601434`}, {-2.259051974738855, -2.0079152241200315`}, \
{-2.2090599702772105`, -1.9582505906350915`}, {-2.1924970609745422`, \
-1.9417510740848807`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6333082086011954, 0.5372655974602379, 0.6824465841007686], 
           
           ArrowBox[{{-2.1839955258421493`, -1.9332820776630673`}, \
{-2.1603605333949796`, -1.9097375456053234`}, {-2.112953664092163, \
-1.8623760890307277`}, {-2.0215956734738065`, -1.770685794269262}, \
{-1.9345640436711737`, -1.6827575593729043`}, {-1.8518587746842639`, \
-1.598591384341654}, {-1.8459427067164875`, -1.5925224530269575`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5513645950990983, 0.5319260079898014, 0.31738574279429566`], 
           
           ArrowBox[{{-1.8375663326415517`, -1.583929644559597}, \
{-1.7734798665130769`, -1.5181872691755107`}, {-1.6990818914800263`, \
-1.4411904805534461`}, {-1.6283194219075248`, -1.3672462851544305`}, \
{-1.5611924577955725`, -1.2963546829784638`}, {-1.5057449906016593`, \
-1.2371104743355847`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4694314616047792, 0.5265871014150386, -0.04762840981622212], 
           
           ArrowBox[{{-1.497546076806874, -1.228348184672}, \
{-1.4483943276729587`, -1.175209335672912}, {-1.4013639304424188`, \
-1.123770284045037}, {-1.356502162630631, -1.0740851414978767`}, \
{-1.3137013794156776`, -1.0260405303873865`}, {-1.2338521874885995`, \
-0.9344193919002404}, {-1.1789839999503673`, -0.8693730342708088}}]}}, {
          Arrowheads[{{0.009108628384256781, 1.}}], {
           LABColor[
           0.38986800793497517`, 0.52225449916916, -0.3758078472444599], 
           
           ArrowBox[{{-1.17124675770833, -0.8602005164873409}, \
{-1.1609551960858397`, -0.8479998474312439}, {-1.0946628868364319`, \
-0.7663548908217375}, {-1.0349212500576253`, -0.6893318101951723}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.720603594101746, 0.3643522058448513, 0.7745909676759256], 
           
           ArrowBox[{{-2.0629057217334426`, 
            2.90881559257721}, {-2.0181090934188313`, 
            2.8404938142932274`}, {-1.974383971467352, 
            2.7736829316692404`}, {-1.9317303558790042`, 
            2.7083829447052477`}, {-1.8901482466537887`, 
            2.644593853401251}, {-1.8430789578198687`, 
            2.5723109747998745`}, {-1.8005618767360922`, 
            2.506851380417532}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6634062372307774, 0.49478018290615106`, 0.7426829509848082], 
           
           ArrowBox[{{-1.7940397447764256`, 
            2.4967785702377356`}, {-1.7592709725531903`, 
            2.4429143948802814`}, {-1.7221576970446668`, 
            2.3852749416226016`}, {-1.685903931641488, 
            2.3288223506091885`}, {-1.6505276509647973`, 
            2.2735849862117035`}, {-1.613637608854949, 
            2.2159758100411717`}, {-1.5776261853241011`, 
            2.1595607040111178`}, {-1.542493380372254, 
            2.1043396681215407`}, {-1.535070843732948, 
            2.0926325696542682`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5912681967457962, 0.5345261966082804, 0.49515728307338175`], 
           
           ArrowBox[{{-1.5286452513734692`, 
            2.0824978884639296`}, {-1.5082391939994078`, 
            2.050312702372441}, {-1.4423666769907175`, 
            1.9458409812956747`}, {-1.3800086342980298`, 
            1.8461455407808176`}, {-1.3208801410278443`, 
            1.750769064626741}, {-1.2745368796768077`, 
            1.6752830632839386`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5124132608100764, 0.5293878707812951, 0.14385657733717158`], 
           
           ArrowBox[{{-1.268258489896883, 
            1.66505653788323}, {-1.2646962722866604`, 
            1.6592542366323149`}, {-1.211457028074478, 
            1.5716010567975396`}, {-1.1611624083912973`, 
            1.4878095251224153`}, {-1.1135817507239212`, 
            1.4074946947445446`}, {-1.068484392559152, 
            1.3302716188015302`}, {-1.0258703338969908`, 
            1.2561402972933724`}, {-1.0235955220742174`, 
            1.2521134198944042`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.435428540851213, 0.5243714115051082, -0.19911226959080428`], 
           
           ArrowBox[{{-1.017693291806665, 
            1.241665277577763}, {-0.9857395747374369, 
            1.1851007302200705`}, {-0.925239437293659, 
            1.0751606359873653`}, {-0.8706992482836939, 
            0.9722347356425636}, {-0.821549417711298, 
            0.8753355085857647}, {-0.793555337470487, 0.817325296567277}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3675880918775939, 0.5222766226878961, -0.42960035500146837`], 
           
           ArrowBox[{{-0.7883399880167812, 
            0.8065178856804952}, {-0.777220355580227, 
            0.7834754342170683}, {-0.7375006395163597, 
            0.6961766488489843}, {-0.7023835143582166, 
            0.6132525213154003}, {-0.6716063909285158, 
            0.5341523797984817}, {-0.6449066800499756, 
            0.4583255524803943}, {-0.6221653275283032, 
            0.3853185415649964}, {-0.6152821485492453, 
            0.35950294184339043`}}]}}, {
          Arrowheads[{{0.009968472420560917, 1.}}], {
           LABColor[
           0.31609631168166846`, 0.5223685658406888, -0.5526629024099843], 
           
           ArrowBox[{{-0.6121906080805055, 
            0.34790801288586143`}, {-0.6033452991594843, 
            0.31473337726854206`}, {-0.588307035751656, 
            0.24610267979179037`}, {-0.5769109781129553, 
            0.17895906933550101`}, {-0.5690665996108349, 
            0.11287609893418568`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6676205800053884, 0.4851701548767893, 0.7450339568170835], 
           
           ArrowBox[{{-0.6256226918437562, 
            2.9543446794163093`}, {-0.6115380029193894, 
            2.880414295131639}, {-0.5978124876199712, 
            2.808180040336905}, {-0.5844461459455011, 
            2.7376419150321065`}, {-0.5714389778959796, 
            2.668799919217244}, {-0.5568331136927716, 
            2.591380013975797}, {-0.5426516157930014, 
            2.5159354255059556`}, {-0.5364625661778151, 
            2.4826984186260317`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5997986633439238, 0.5350820567623376, 0.5331607244638386], 
           
           ArrowBox[{{-0.5342658116384186, 
            2.4709012041457554`}, {-0.5296641010605199, 
            2.4461886722310417`}, {-0.5170449111528234, 
            2.3781500287310897`}, {-0.5047698596336696, 
            2.3116857879324684`}, {-0.492847008648473, 
            2.246840518859723}, {-0.4705141472340124, 
            2.125093534076897}, {-0.44934570682230557`, 
            2.008549082360808}, {-0.4475926882661435, 1.99879182080848}}]}}, {
         
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5245524860384606, 0.5301788839724217, 0.1979371284050015], 
           
           ArrowBox[{{-0.4454707081394735, 
            1.98698092751703}, {-0.42934168741335266`, 
            1.897207163711457}, {-0.41050208900715357`, 
            1.7910677781288429`}, {-0.3927311964228201, 
            1.6895890407651561`}, {-0.37593329447946405`, 
            1.5922290667725867`}, {-0.3626861617490873, 
            1.5141762632249465`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4527181247838565, 0.5254980310959396, -0.12208674207817893`], 
           
           ArrowBox[{{-0.3606782338714762, 
            1.5023454464467898`}, {-0.36010838317708543`, 
            1.4989878561511347`}, {-0.34525646251568426`, 
            1.4098654089007998`}, {-0.3313018812021074, 
            1.3244063944792863`}, {-0.3181689879432017, 
            1.242155482344298}, {-0.30585778273896735`, 
            1.163112672495835}, {-0.29436826558940415`, 
            1.0872779649338973`}, {-0.28578984654369727`, 
            1.0282345492131173`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.38931517377926317`, 0.5222378270509339, -0.37767381378655696`], 
           
           ArrowBox[{{-0.28406448173026283`, 
            1.016359233795809}, {-0.27733174646467773`, 
            0.9700192630965646}, {-0.2622690148065267, 
            0.8598051787993309}, {-0.24899853817187778`, 
            0.755474510997654}, {-0.2373387841176576, 
            0.6558660586469913}, {-0.22723373832824184`, 
            0.5603966983419517}, {-0.2253341460968833, 
            0.5400126243435682}}]}}, {
          Arrowheads[{{0.016688640028229847`, 1.}}], {
           LABColor[
           0.3441579432535121, 0.5223184593019479, -0.4855971328341331], 
           
           ArrowBox[{{-0.22422069026083966`, 
            0.5280643936753404}, {-0.21869911113226276`, 
            0.4688136367566589}, {-0.2116609570530319, 
            0.38045116796584283`}, {-0.20604533061386068`, 
            0.29464358604423374`}, {-0.20182197495869936`, 
            0.2107997800571619}, {-0.19899947326224254`, 
            0.12841180366452906`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.752445518195604, 0.29174259637163275`, 0.7923542473280978], 
           
           ArrowBox[{{-2.5370594249716807`, 
            2.91460361547906}, {-2.474165895809114, 
            2.837373342445834}, {-2.412940301276602, 
            2.7620558769795975`}, {-2.3637217408589217`, 
            2.7012495176670974`}, {-2.3156074787849197`, 
            2.6417075880032193`}, {-2.2685342479740367`, 
            2.5833509430309434`}, {-2.23493231432761, 
            2.5416179407548287`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6947074557144259, 0.4234035524162865, 0.7601445935582871], 
           
           ArrowBox[{{-2.227406576531112, 
            2.5322711086380973`}, {-2.222523137453125, 
            2.526205964402609}, {-2.1729156567475205`, 
            2.464586429937316}, {-2.1244446952918663`, 
            2.404246717487598}, {-2.0771102530861607`, 
            2.345186827053455}, {-2.0309123301304046`, 
            2.2874067586348863`}, {-1.985850926424599, 
            2.2309065122318934`}, {-1.941926041968742, 
            2.1756860878444755`}, {-1.9274989510736182`, 
            2.157498761228667}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6340666908977757, 0.5373150214960016, 0.6858256416437777], 
           
           ArrowBox[{{-1.9200413706832675`, 
            2.1480974584082353`}, {-1.8991376767628354`, 
            2.1217454854726325`}, {-1.8574858308068778`, 
            2.0690847051163646`}, {-1.7772208639148792`, 
            1.9671331193012782`}, {-1.7007603085628147`, 
            1.869361839249942}, {-1.6281041647506838`, 
            1.7757708649623556`}, {-1.6239159301279673`, 
            1.7703320351000753`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5534809893986381, 0.5320639159515588, 0.3268143321682118], 
           
           ArrowBox[{{-1.6165944386040796`, 
            1.7608243665180496`}, {-1.5592524324784862`, 
            1.6863601964385182`}, {-1.4939016104905414`, 
            1.6007352513405457`}, {-1.431748197531168, 
            1.5185014473305527`}, {-1.3727921936003662`, 
            1.439658784408539}, {-1.3271636822835842`, 
            1.3779151084082866`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4735817612188768, 0.5268575422117218, -0.0291387215532359], 
           
           ArrowBox[{{-1.3200318102299524`, 
            1.368264388175546}, {-1.317033598698135, 
            1.364207262574504}, {-1.2737060064559773`, 
            1.3048752657219505`}, {-1.2323834460025183`, 
            1.2476201729642646`}, {-1.1929711794848457`, 
            1.192315605087448}, {-1.1553744690500485`, 
            1.1388351828775023`}, {-1.0852487650174338`, 
            1.036841258602231}, {-1.0443650111843845`, 
            0.9753793123729515}}]}}, {
          Arrowheads[{{0.017495317697006647`, 1.}}], {
           LABColor[
           0.3966351308441654, 0.5223408261819191, -0.3565991959458832], 
           
           ArrowBox[{{-1.0377188399242854`, 
            0.9653878956775358}, {-1.0212484310813812`, 
            0.9406273664264642}, {-0.9630688701303283, 
            0.8497151867306131}, {-0.910664516887987, 
            0.7639308079478873}, {-0.8636660162839761, 
            0.6827198084454986}, {-0.8217040132479143, 
            0.6055277665906583}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.7031974486326208, 0.4040436962592451, 0.7648808060436358], 
           
           ArrowBox[{{-1.6605051234064614`, 
            2.9549081074688397`}, {-1.6189807285132907`, 
            2.8744539262772757`}, {-1.578588132836963, 
            2.796009333152891}, {-1.545016343968252, 
            2.730439455652756}, {-1.5122476961932894`, 
            2.6662925237528157`}, {-1.4802344938850296`, 
            2.6034738088755063`}, {-1.4489926355858214`, 
            2.54201488721335}, {-1.441705589965029, 2.5276779815779213`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6461955095015512, 0.5303677651412385, 0.7270033032848342], 
           
           ArrowBox[{{-1.4362683530271274`, 
            2.5169804839975938`}, {-1.4164335170862212`, 
            2.4779564149883955`}, {-1.38464520233607, 
            2.4152336330822974`}, {-1.353627691335367, 
            2.3538465414950536`}, {-1.3233809840841122`, 
            2.2937951402266648`}, {-1.2651999808299483`, 
            2.177699408646454}, {-1.2206452613870766`, 
            2.088139234353539}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5688521130262343, 0.5330655253066136, 0.39529307118760515`], 
           
           ArrowBox[{{-1.215300337789315, 
            2.077395315527799}, {-1.210102192573578, 
            2.0669464383416636`}, {-1.1578358576778949`, 
            1.9610283665911978`}, {-1.1081492145057927`, 
            1.8594373306739609`}, {-1.0610422630572711`, 
            1.7621733305899527`}, {-1.0165150033323305`, 
            1.6692363663391732`}, {-1.0053886427361964`, 
            1.6457342460398938`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.49185348640511556`, 0.5280481598479413, 0.052262269732537614`], 
           
           ArrowBox[{{-1.000253952164118, 
            1.6348882812267014`}, {-0.9743632396638681, 
            1.5801995414040546`}, {-0.9343827763847818, 
            1.494635959267029}, {-0.8965736134950714, 
            1.4125456199280966`}, {-0.8609357509947366, 
            1.3339285233872569`}, {-0.8333534378684747, 
            1.2720945854085224`}, {-0.8071344662289895, 
            1.2123729819156777`}, {-0.8010241325765556, 
            1.1982130907618511`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4180437431058348, 0.5232385876153671, -0.27656197701319196`], 
           
           ArrowBox[{{-0.7962696318845902, 
            1.1871951634082105`}, {-0.7822156845671573, 
            1.1546269968209097`}, {-0.7585339413738539, 
            1.0987199140364057`}, {-0.7146289643563354, 
            0.9918755910469328}, {-0.67491432310344, 
            0.8907462842447504}, {-0.6391991194056419, 
            0.7948053596456705}, {-0.6203339689922404, 
            0.7407227482950006}}]}}, {
          Arrowheads[{{0.004918156482634843, 1.}}], {
           LABColor[
           0.35736917233282317`, 0.5222948694775295, -0.45402301559228764`], 
           
           ArrowBox[{{-0.6163816668812446, 
            0.7293922889917147}, {-0.6074720629753976, 
            0.7038502373902585}, {-0.5794973536226861, 
            0.6172732699631378}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[0.68091248887952, 0.4548604188928864, 0.7524489576740178], 
           
           ArrowBox[{{-2.888102348655636, -1.6963345860214691`}, \
{-2.8157015392550124`, -1.649756832344931}, {-2.7452910776977824`, \
-1.6043451864617924`}, {-2.6861310048711644`, -1.5659540671892915`}, \
{-2.628415297410942, -1.5284075781993736`}, {-2.5720572354454747`, \
-1.4916483569846621`}, {-2.5170857255986436`, -1.45569552438095}, \
{-2.485472104488501, -1.43501664532282}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6120354853226692, 0.5358794295287661, 0.5876760714879727], 
           
           ArrowBox[{{-2.475429696501431, -1.428447776179563}, \
{-2.460310507746526, -1.4185581189767247`}, {-2.4048960257863192`, \
-1.3821971866001563`}, {-2.3508422797180226`, -1.3466127272512445`}, \
{-2.298149269541636, -1.3118047409299893`}, {-2.1968454568645965`, \
-1.2445181873704494`}, {-2.1009845877551987`, -1.1803375259215363`}, \
{-2.0754519124675617`, -1.1630913047445663`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5275279903383537, 0.5303727730474811, 0.21119307425125386`], 
           
           ArrowBox[{{-2.065507835654645, -1.1563745096502667`}, \
{-2.010121563210595, -1.118963470893959}, {-1.923811284227936, \
-1.060096736598427}, {-1.8420537508072221`, -1.00373732303494}, \
{-1.7648489629484538`, -0.9498852302034982}, {-1.6918369338241148`, \
-0.8982890880868715}, {-1.6708242328473815`, -0.8832260085890311}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4418110900943954, 0.5247873095998703, -0.1706778535720802], 
           
           ArrowBox[{{-1.661071301422266, -0.8762345617704538}, \
{-1.6226576766066902`, -0.8486975266678306}, {-1.5573111912961797`, \
-0.8011105459463753}, {-1.4957974778925829`, -0.7555281459225053}, \
{-1.4036548136937672`, -0.6854472779158405}, {-1.3205890623006076`, \
-0.6198576379540441}, {-1.2791330738362336`, -0.5856732167512073}}]}}, {
          Arrowheads[{{0.005027119676345156, 1.}}], {
           LABColor[
           0.3592744269178244, 0.5222914674760303, -0.4494695610059466], 
           
           ArrowBox[{{-1.269874756352092, -0.5780388498905674}, \
{-1.2457264624794675`, -0.5581262756244614}, {-1.1781932529967105`, \
-0.4996202405144368}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.35371672402039767`, 0.5223013912488098, -0.4627521679326176], 
           
           ArrowBox[{{0.31655235472325977`, 0.6625388779755742}, {
            0.32849358537327733`, 0.7373531748680701}, {0.34173105089213573`, 
            0.8150866314987503}, {0.36299700337497176`, 0.93231472681844}, {
            0.3872047286367657, 1.0571058270899283`}, {0.40044843580186795`, 
            1.1225569063776173`}, {0.4029567488380141, 
            1.1346493815248537`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4048131753624673, 0.522405903699305, -0.3345962758137921], 
           
           ArrowBox[{{0.40539399933426506`, 1.1463992670569993`}, {
            0.4144716018522249, 1.1901620196572802`}, {0.4293317358186297, 
            1.2601732410391242`}, {0.4450863467318754, 1.3328426446333557`}, {
            0.4632577264526293, 1.4149906884727492`}, {0.48258459798285175`, 
            1.5007321275831367`}, {0.503066961322543, 1.590066961964519}, {
            0.5088946843893429, 1.615095320078981}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.4731173934768377, 0.5268272831957981, -0.031207491422410173`], 
           
           ArrowBox[{{0.5116160246414072, 1.6267826768046267`}, {
            0.524704816471703, 1.6829951916168955`}, {0.5476063338345469, 
            1.7799759451931392`}, {0.5718796838152898, 1.8814683513461223`}, {
            0.5975248664139315, 1.9874724100758452`}, {0.6234610967247506, 
            2.093567066292846}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5466629127610615, 0.5316196381284712, 0.29643963074816754`], 
           
           ArrowBox[{{0.626326648097998, 2.105219896479345}, {
            0.6530645127032216, 2.213560246277662}, {0.683226542870488, 
            2.3347335457740583`}, {0.6989223326145653, 2.397420635997648}, {
            0.7150279721322716, 2.461508019871498}, {0.7315434614236075, 
            2.5269956973956087`}, {0.7426553893311485, 
            2.570909400436856}}]}}, {
          Arrowheads[{{0.017954126702672196`, 1.}}], {
           LABColor[
           0.6230439354814102, 0.5365967594345549, 0.6367189914261755], 
           ArrowBox[{{0.7455990910956977, 2.5825427413121758`}, {
            0.7484688004885727, 2.5938836685699806`}, {0.7672970353003207, 
            2.6681711961738115`}, {0.7866636874795639, 2.7443306761533104`}, {
            0.8062970498232487, 2.82095508672802}, {0.8264626747551808, 
            2.899437710307012}, {0.8472031072424846, 2.979942114535648}, {
            0.8523837253763421, 3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6682063720810734, 0.4838343645607701, 0.7453607457519402], 
           
           ArrowBox[{{-0.30310403706433164`, 3.}, {-0.2953583936001966, 
            2.914900409236963}, {-0.28769138637950264`, 
            2.830409742178715}, {-0.2805198104964872, 
            2.750750110974364}, {-0.2735547969703182, 
            2.6731233070558336`}, {-0.266782221990402, 
            2.597368486324367}, {-0.26020679349360326`, 
            2.5235392634795506`}, {-0.260063791183472, 
            2.5219336591358585`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6009451234870333, 0.5351567621145523, 0.5382682329868449], 
           
           ArrowBox[{{-0.2589992314267244, 
            2.509980972721319}, {-0.2540837208639987, 
            2.454790499897966}, {-0.24811708732267504`, 
            2.387533438570917}, {-0.24230689286963236`, 
            2.3217680794984052`}, {-0.2366531375048705, 
            2.2574944226804288`}, {-0.22581494404018967`, 
            2.133422215808086}, {-0.21702947745766726`, 
            2.031819531284395}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5259147746822407, 0.530267653088002, 0.20400615827989105`], 
           
           ArrowBox[{{-0.21599570881605432`, 
            2.0198641424410484`}, {-0.21560250692863248`, 
            2.015316817953887}, {-0.20596285537615305`, 
            1.90256312774342}, {-0.1968430185887055, 
            1.7945460438022693`}, {-0.1882429965662899, 
            1.691265566130436}, {-0.18016278930890606`, 
            1.5927216947279192`}, {-0.17603673075035722`, 
            1.5415308993276444`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4546344544357616, 0.5256229024946232, -0.11354944569781948`], 
           
           ArrowBox[{{-0.17507263848913393`, 
            1.5295696901031617`}, {-0.17256037963604928`, 
            1.4984008331623584`}, {-0.16539375036721465`, 
            1.4077893850013918`}, {-0.15866290150240225`, 
            1.3208873502450194`}, {-0.15236783304161197`, 
            1.237694728893241}, {-0.14307626068052745`, 
            1.110510906787651}, {-0.1389402937399361, 
            1.0509341885329402`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3916093787906349, 0.5222337305438584, -0.3721907888862228], 
           
           ArrowBox[{{-0.13810922355279137`, 
            1.0389630013593956`}, {-0.13480742653018063`, 
            0.9914021204877999}, {-0.1274623455381833, 
            0.8790952029763394}, {-0.12094203265214723`, 
            0.7723169872359217}, {-0.11521399996455148`, 
            0.6704462467407004}, {-0.1102837579363708, 
            0.5732342923885451}, {-0.10968316779830131`, 
            0.5598155887160651}}]}}, {
          Arrowheads[{{0.006584696222451391, 1.}}], {
           LABColor[
           0.3469078752819564, 0.522313549053755, -0.47902494520859434`], 
           
           ArrowBox[{{-0.10914661271331147`, 
            0.5478275901908412}, {-0.1061093190679604, 
            0.4799667632976812}, {-0.10264869585967547`, 
            0.38992929858633385`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6749874309178471, 0.46837141601212917`, 0.7491436152827007], 
           
           ArrowBox[{{-0.9500251169004706, 
            2.9512364953223336`}, {-0.9259002569303545, 
            2.8684258604473887`}, {-0.9024531738934716, 
            2.787715210506787}, {-0.8819988023408443, 
            2.716808351483561}, {-0.862075887434313, 
            2.6475436276500455`}, {-0.8426510522586089, 
            2.5798028567792866`}, {-0.8237354224521553, 
            2.5136254329469367`}, {-0.8169945679637933, 
            2.490040148766221}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6095598679534769, 0.5357181139622146, 0.5766471343820067], 
           ArrowBox[{{-0.8136969185762694, 
            2.4785021459703747`}, {-0.8049337022208902, 
            2.4478409073343017`}, {-0.7865940969741576, 
            2.383445302399292}, {-0.7687166067119569, 
            2.3204386181419063`}, {-0.7513012314342888, 
            2.2588208545621464`}, {-0.7178568258325495, 
            2.1397520894355013`}, {-0.6862608801689392, 
            2.026239007019356}, {-0.6835712730046134, 2.016478382851406}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5333228390190005, 0.5307503755435825, 0.237009269610352], 
           
           ArrowBox[{{-0.6803834061234068, 
            2.0049095668036117`}, {-0.65636095347007, 
            1.917731730927947}, {-0.6280046047625536, 
            1.8136803847755099`}, {-0.6011918340463902, 
            1.714084968562044}, {-0.5759226413215796, 
            1.61894548228755}, {-0.5556351876097243, 1.541408305869704}}]}}, {
         
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4601428794542504, 0.5259818411229112, -0.08900927489522605], 
           
           ArrowBox[{{-0.5525976635329477, 
            1.5297991091928014`}, {-0.5520747157842618, 
            1.527800440832391}, {-0.5295257466305766, 
            1.4401883590769304`}, {-0.5082757338605243, 
            1.3561092370211685`}, {-0.48832467747410435`, 
            1.2755630746651043`}, {-0.4584495672673955, 
            1.1512335537777327`}, {-0.4383038721020645, 
            1.0636249222014058`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.393870408274972, 0.5222649077604461, -0.3657008142142121], 
           
           ArrowBox[{{-0.4356146436979087, 
            1.0519301348758372`}, {-0.4316789648235169, 
            1.034814843609905}, {-0.40771487514466803`, 
            0.9251316702927788}, {-0.38625930323304813`, 
            0.8210087599575121}, {-0.3672075673987371, 
            0.7218725908145613}, {-0.3505654506991751, 
            0.6274934994054102}, {-0.34316887188048123`, 
            0.5810066396594119}}]}}, {
          Arrowheads[{{0.0013477306661627204`, 1.}}], {
           LABColor[
           0.34527783436312226`, 0.5223164596367779, -0.48292065413705976`], 
           
           ArrowBox[{{-0.34128325706916496`, 
            0.5691557132490697}, {-0.3362006552576019, 
            0.5372119993577582}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.7891621114784322, 0.20801720680048552`, 0.8128369013422045], 
           
           ArrowBox[{{-2.9253073928520728`, -3.}, {-2.8885224098044366`, \
-2.960096235296148}, {-2.817247414190809, -2.882663464421924}, \
{-2.7608001301228997`, -2.8211247580678194`}, {-2.7055804584791336`, \
-2.760842468277384}, {-2.6515191202881527`, -2.7017402982084238`}, \
{-2.6008515305742668`, -2.646265884710503}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.731138470847219, 0.3403293709155756, 0.7804679354489596], 
           
           ArrowBox[{{-2.5927591884871353`, -2.637405072137823}, \
{-2.540732337990965, -2.5804357943148597`}, {-2.4841295719363217`, \
-2.5183446021962883`}, {-2.428830910376477, -2.4575701037859545`}, \
{-2.3748363533114323`, -2.3981122990838584`}, {-2.3221459007411878`, \
-2.339971188090001}, {-2.2707595526657434`, -2.2831467708043816`}, \
{-2.2699094391436327`, -2.2822045632868866`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6730963593573306, 0.47268365440231785`, 0.7480886654350499], 
           
           ArrowBox[{{-2.261870757748183, -2.2732950402119716`}, \
{-2.2206773090850986`, -2.227639047227}, {-2.171899169999254, \
-2.1734480173578574`}, {-2.124318599979108, -2.1204551851335665`}, \
{-2.0778290635955594`, -2.0685420544907416`}, {-2.032430560848608, \
-2.0177086254293837`}, {-1.9881230917382542`, -1.9679548979494914`}, \
{-1.94174516650085, -1.9156390996294765`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6033224385029471, 0.5353116721274792, 0.548859230657918], 
           
           ArrowBox[{{-1.9337847934931627`, -1.9066595416460075`}, \
{-1.9027812544273386`, -1.871686547734106}, {-1.821803551662812, \
-1.7797370038445852`}, {-1.7448396406799798`, -1.6917080771820112`}, \
{-1.6715391787141474`, -1.6072015786474656`}, {-1.618113673585653, \
-1.545070612863382}}]}}, {
          Arrowheads[{{0.0005360285245440526, 1.}}], {
           LABColor[
           0.5222030018878127, 0.530025787467452, 0.18747011793261356`], 
           
           ArrowBox[{{-1.6102898022171148`, -1.5359718746646776`}, \
{-1.6019021657653147`, -1.5262175082409488`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.7885291792247072, 0.20946049156024132`, 0.8124838148707133], 
           
           ArrowBox[{{-2.917134500973852, 3.}, {-2.8885184623041633`, 
            2.96887121590928}, {-2.8172472219949807`, 
            2.891226992057095}, {-2.760816277215926, 
            2.8295355798083506`}, {-2.705611983338473, 
            2.7691033280903885`}, {-2.6515651326699485`, 
            2.70985381013819}, {-2.5986987944412436`, 
            2.6518125015400953`}, {-2.593206767569382, 2.6457821694944}}]}}, {
         
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.730506717213641, 0.34176996805041476`, 0.780115506480426], 
           
           ArrowBox[{{-2.585126717184836, 
            2.636910146851102}, {-2.5407926032017794`, 
            2.588230591104699}, {-2.4841901465674736`, 
            2.525968972159596}, {-2.428891424538327, 
            2.4650276447047847`}, {-2.374896437114338, 
            2.405406608740266}, {-2.3222051842955076`, 
            2.347105864266039}, {-2.2708176660818356`, 
            2.290125411282105}, {-2.2628098814684634`, 
            2.281226032028521}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6724770271303687, 0.47409592682032053`, 0.7477431658505179], 
           
           ArrowBox[{{-2.2547832222009605`, 
            2.2723056765981915`}, {-2.2207338824733216`, 
            2.234465249788463}, {-2.171953833469966, 
            2.1801253797851134`}, {-2.1243710123600072`, 
            2.1269870169111487`}, {-2.0778789124316823`, 
            2.07493137680566}, {-2.0324775336849914`, 
            2.0239584594686475`}, {-1.9881668761199345`, 
            1.9740682649001116`}, {-1.935201853359011, 
            1.9141633779908862`}}]}}, {
          Arrowheads[{{0.01619896924165662, 1.}}], {
           LABColor[
           0.6024672863729672, 0.5352559489159474, 0.5450495065967806], 
           
           ArrowBox[{{-1.9272533042967595`, 
            1.9051733519728493`}, {-1.9028177245347235`, 
            1.8775360440684696`}, {-1.8218314576760493`, 
            1.7853347143107339`}, {-1.7448578030614321`, 
            1.6970651193141595`}, {-1.6715464882083932`, 
            1.6123281027660021`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4023076939456868, 0.5222146277507295, -0.3466223989228089], 
           
           ArrowBox[{{0.11468031727144477`, 1.13842188446055}, {
            0.11844625189636025`, 1.2037581865029008`}, {0.12242623959842125`,
             1.2712726909006467`}, {0.1266345785464225, 
            1.3411901430260156`}, {0.13192144741816145`, 
            1.4272224793747341`}, {0.13755828473819726`, 1.517114680487142}, {
            0.14354509050653003`, 1.6108667463632405`}, {0.1439773877341264, 
            1.617525870635835}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.46852288663148867`, 0.5265278970774075, -0.051676133976335595`], 
           
           
           ArrowBox[{{0.14475476773734622`, 1.6295006641760426`}, {
            0.1498818647231597, 1.708478677003029}, {0.1566023420492209, 
            1.8104635961928697`}, {0.1637402571458482, 1.917334627719124}, {
            0.17129561001304167`, 2.0290917715817933`}, {0.1767188650014516, 
            2.1084348961898938`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.5406513296138575, 0.5312279128346795, 0.2696578779365723], 
           
           ArrowBox[{{0.17753717870673977`, 2.1204069621218764`}, {
            0.1792684006508012, 2.145735027780876}, {0.18770063868485062`, 
            2.2678760434791836`}, {0.19663433374091355`, 
            2.3961264658395254`}, {0.20128922765220011`, 
            2.4625427045179595`}, {0.20606948581899004`, 
            2.5304862948619022`}, {0.21092476339328797`, 
            2.5992442786135666`}}]}}, {
          Arrowheads[{{0.01624066845016969, 1.}}], {
           LABColor[
           0.616055880183991, 0.5361414055040867, 0.6055870308383413], 
           
           ArrowBox[{{0.21177278961945187`, 2.611214276568199}, {
            0.21600609491908004`, 2.6709555305463137`}, {0.22157162738712138`,
             2.7493653342678925`}, {0.2273002921942887, 
            2.8297989531660015`}, {0.23355177320843545`, 
            2.9168625799406804`}, {0.239539565479527, 3.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.008988435748748793, 1.}}], {
           LABColor[
           0.6953379674250609, 0.42196578725666384`, 0.7604963297098766], 
           
           ArrowBox[{{-1.3809158017586725`, 3.}, {-1.3552269926503104`, 
            2.9390348681625236`}, {-1.326000231530628, 
            2.8692827172529993`}, {-1.2974812297116844`, 
            2.801065868463962}}]}}}}}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRange -> {{-3., 3.}, {-3., 3.}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, Frame -> True, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Small, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, AlignmentPoint -> 
     Center, Axes -> False, AxesLabel -> None, AxesOrigin -> Automatic, 
     AxesStyle -> {}, Background -> None, BaselinePosition -> Automatic, 
     BaseStyle -> {}, ColorOutput -> Automatic, ContentSelectable -> 
     Automatic, CoordinatesToolOptions -> Automatic, Epilog -> {}, FormatType :> 
     TraditionalForm, FrameLabel -> None, FrameStyle -> {}, 
     FrameTicksStyle -> {}, GridLines -> None, ImageMargins -> 0., 
     ImagePadding -> All, ImageSizeRaw -> Automatic, LabelStyle -> {}, 
     PlotLabel -> None, PlotRegion -> Automatic, PreserveImageOptions -> 
     Automatic, Prolog -> {}, RotateLabel -> True, TicksStyle -> {}, 
     DisplayFunction -> Identity, AspectRatio -> 1, DisplayFunction :> 
     Identity, Frame -> True, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Small, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRange -> {{-3., 3.}, {-3., 3.}},
      PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJxt13kw1d//B3CJZImUbKEkoU0LktITZSlFWZL1kjZCKSlJhdCmyFKh7kc+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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                
                LineBox[{{7.5, -112.49999999999999`}, {7.5, 
                 112.49999999999999`}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -59.622302158273385`}, 
                    Offset[{4., 0}, {7.5, -59.622302158273385`}]}, {{
                    7.5, -5.665467625899293}, 
                    Offset[{4., 0}, {7.5, -5.665467625899293}]}, {{7.5, 
                    48.2913669064748}, 
                    Offset[{4., 0}, {7.5, 48.2913669064748}]}, {{7.5, 
                    102.24820143884888`}, 
                    Offset[{4., 0}, {7.5, 102.24820143884888`}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -102.78776978417265`}, 
                    Offset[{2.5, 0.}, {7.5, -102.78776978417265`}]}, {{
                    7.5, -91.99640287769783}, 
                    Offset[{2.5, 0.}, {7.5, -91.99640287769783}]}, {{
                    7.5, -81.20503597122303}, 
                    Offset[{2.5, 0.}, {7.5, -81.20503597122303}]}, {{
                    7.5, -70.4136690647482}, 
                    Offset[{2.5, 0.}, {7.5, -70.4136690647482}]}, {{
                    7.5, -48.830935251798564`}, 
                    Offset[{2.5, 0.}, {7.5, -48.830935251798564`}]}, {{
                    7.5, -38.039568345323744`}, 
                    Offset[{2.5, 0.}, {7.5, -38.039568345323744`}]}, {{
                    7.5, -27.24820143884893}, 
                    Offset[{2.5, 0.}, {7.5, -27.24820143884893}]}, {{
                    7.5, -16.45683453237411}, 
                    Offset[{2.5, 0.}, {7.5, -16.45683453237411}]}, {{7.5, 
                    5.125899280575538}, 
                    Offset[{2.5, 0.}, {7.5, 5.125899280575538}]}, {{7.5, 
                    15.917266187050343`}, 
                    Offset[{2.5, 0.}, {7.5, 15.917266187050343`}]}, {{7.5, 
                    26.70863309352516}, 
                    Offset[{2.5, 0.}, {7.5, 26.70863309352516}]}, {{7.5, 
                    37.49999999999998}, 
                    Offset[{2.5, 0.}, {7.5, 37.49999999999998}]}, {{7.5, 
                    59.08273381294961}, 
                    Offset[{2.5, 0.}, {7.5, 59.08273381294961}]}, {{7.5, 
                    69.87410071942443}, 
                    Offset[{2.5, 0.}, {7.5, 69.87410071942443}]}, {{7.5, 
                    80.66546762589925}, 
                    Offset[{2.5, 0.}, {7.5, 80.66546762589925}]}, {{7.5, 
                    91.45683453237407}, 
                    Offset[{2.5, 0.}, {7.5, 91.45683453237407}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -59.622302158273385`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["2", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -5.665467625899293}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["3", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 48.2913669064748}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["4", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 102.24820143884888`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IsaBnC3KHc7IY0kFW17pZ1SsfWgSGmnXHYpNYNSKnRxl9qx6aJO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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    "\"WL12DefaultVectorGradient\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJxl1Ws01IsaBnC3KHc7IY0kFW17pZ1SsfWgSGmnXHYpNYNSKnRxl9qx6aJO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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "WL12DefaultVectorGradient", "ThemeGradients", {0, 1}, 
                    Blend["WL12DefaultVectorGradient", #]& ], Selectable -> 
                    False, Editable -> False, SelectWithContents -> True], 
                   "[", "#1", "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0.02001317259830914`", ",", "4.187968827258731`"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", 
             RowBox[{"Max", "[", 
               RowBox[{"150", ",", "Small"}], "]"}]}], ",", 
           RowBox[{"Charting`AxisLabel", "\[Rule]", "None"}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->219509924,ExpressionUUID->"3169f226-ad5c-40e5-aee5-c515d917a4a3"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->371645072,ExpressionUUID->"b8eb8596-cd5c-4ca2-b27c-337d50dd2945"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->377821150,ExpressionUUID->"b4f98720-99d0-4011-bfe2-f7f41086d06d"],

Cell[TextData[{
 "Describe the branch cuts of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SqrtBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "z"], "-", "1"}]]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "4bd882e4-51fa-4885-8487-fa3ccc7f2d73"],
 "."
}], "SolvedExampleNote",
 CellID->435689056,ExpressionUUID->"7a53e892-ef01-4f0e-a7ee-1106eaf8646c"],

Cell[TextData[{
 "The branch cuts correspond to the points such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "z"], "-", "1"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f5c66980-ffb1-4df9-9c10-aab637b4d6c5"],
 " is a negative number. Find them using ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->18860352,ExpressionUUID->"64ca1487-e761-4ec8-a89f-0f7811aa8faf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "z", "]"}], "-", "1"}], "==", "0"}], ",", "z", ",", 
   "Complexes"}], "]"}]], "SolvedExampleInput",
 CellID->325014679,ExpressionUUID->"f6536895-16ea-46ec-8950-2857e55e378c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   TemplateBox[{"1"},
    "C"], "\[Element]", 
   TemplateBox[{},
    "Integers"]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    TemplateBox[{"1"},
     "C"]}]}]}]], "SolvedExampleOutput",
 CellID->30012014,ExpressionUUID->"32941ce9-f8cb-4833-a6fa-7ac63f42b266"]
}, Open  ]],

Cell["Plot the function:", "SolvedExampleNote",
 CellID->496415844,ExpressionUUID->"5e5e4d3c-c534-482f-b74a-4a5f4a89f197"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "z", "]"}], "-", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "5"}], "-", 
      RowBox[{"10", "I"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"10", "I"}]}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["3", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["496", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[PlotLegends -> Automatic, AxesLabel -> {
       ToString[
        Re[$CellContext`z], TraditionalForm], 
       ToString[
        Im[$CellContext`z], TraditionalForm]}, AspectRatio -> Automatic],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->403110035,ExpressionUUID->"d243eb92-bab3-45a8-91ab-77ca3e9c8ac8"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJx1nHdUVMnWt0EwgoGgMoIRFTCNOWNv46CCWRFzRDEiRsyOASMYURjFUTFj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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztnHl0VdW5wLveW8tqtdanxWftvQECBALIFBDH19rhvde+Do7VVqsF5wkH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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnHn8VsP7h5/znCchijaUpaJUaF9UKmnXnoTomygJSUILhWypEL7JWpEi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             "]]}, 
           Annotation[#, 
            "Charting`Private`Tag$30830#1"]& ]]}, {}, {}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0kdKXlEYBuBjjb23WHFqwaFgwYKCZebI6MyB0cQa2//ba7IA2wZ0A5YN
6EiioHEDCjo1cQNJHnHw8H4HLrz3O/dWDk32TcSEEHZoiw/hba6Tu3EhVJib
GSTKIefc80qmh2vpZZQfHHPJI/8oiw2hkU8ssM8pd/wmXU813VzRofuzbJFP
coRRvvCVMcaZYJIppvnGDLPMMc8CEaIsssQyK6yyxjobbLLFTzp1b8tW+SyH
6aKKNF689y0n7DFPPw2U8tfeD1xwxHdG6KGGDP64v1+ccUCEAZrY19Guu9xc
L2+cy8yllFDMR4oopIB88sglh2yy3r4RGaSTRiopJJPEBxJJQFVQFawQruPe
/4f/BbA2iA==
          "]]}}}, VertexNormals -> CompressedData["
1:eJx0fHdUz3H7vlHJSKIUKlpGEhUV0a0olSIjo432oL3THko0pCFpSArRpnWn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