(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1195539,      21413]
NotebookOptionsPosition[   1042059,      18176]
NotebookOutlinePosition[   1180587,      21132]
CellTagsIndexPosition[   1180511,      21127]
WindowTitle->8. The Point at Infinity | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "The Point at Infinity"
}], "Section",
 CounterAssignments->{{"Section", 7}},
 CellID->18257850,ExpressionUUID->"d7f3a795-23df-4aa8-b5c6-b0630f295f1f"],

Cell[TextData[{
 "In real analysis, infinity can only be approached from two directions: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"88e96971-93d3-49f2-bb81-61feca9f9c55"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"06af3d02-f0e9-40d6-a27e-cd0e4e1c7b3a"],
 ". In complex analysis, it can be approached from all kinds of directions. \
It is often useful to treat complex infinity just like any other point: this \
is possible using the stereographic projection, which you already encountered \
in ",
 ButtonBox["Chapter 2",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "Text",
 CellID->968626782,ExpressionUUID->"a47cb883-8827-4559-b144-0ca940e7accf"],

Cell[TextData[{
 "In real analysis, infinity can only be approached from two directions: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e732892b-a120-4e40-8a81-275258dd6d37"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c2d865bf-a27f-46db-a706-5dbe2d96f715"],
 "."
}], "Text",
 CellID->66085126,ExpressionUUID->"adbe21a7-18fe-4a46-98d0-1f420aaa9d75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"f", "[", "x", "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2.2", ",", "8"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2.6", ",", "8"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2.1"}], ",", "8"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2.5"}], ",", "8"}], "}"}]}], "}"}], "]"}]}], "}"}],
       ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"HoldForm", "[", 
           RowBox[{"+", "\[Infinity]"}], "]"}], ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.9", ",", "8"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"-", "\[Infinity]"}], ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.9"}], ",", "9"}], "}"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "250"}]}], "]"}]], "Input",
 CellID->45533750,ExpressionUUID->"6308e878-e5a4-4df3-bc0f-087a94097dec"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwtmWc41o/3x424hUQkqaSEqCij7PMx01ZWg4iUmZHMlr0iCSFlZWYTWfe5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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwtmWc41o/3x424hUQkqaSEqCij7PMx01ZWg4iUmZHMlr0iCSFlZWYTWfe5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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-3, 3}, {-26.99999669387769, 26.99999669387769}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{-3, 3}, {-26.99999669387769, 26.99999669387769}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {250, 250/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwtmWc41o/3x424hUQkqaSEqCij7PMx01ZWg4iUmZHMlr0iCSFlZWYTWfe5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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{-3, 3}, {-26.99999669387769, 26.99999669387769}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {250, 250/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox["x", HoldForm], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"f", "(", 
        TagBox["x", HoldForm], ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{{
     Arrowheads[0.03], 
     ArrowBox[{{2.2, 8}, {2.6, 8}}]}, {
     Arrowheads[0.03], 
     ArrowBox[{{-2.1, 8}, {-2.5, 8}}]}, 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"+", "\[Infinity]"}], HoldForm], 12, StripOnInput -> False], 
      TraditionalForm], {2.9, 8}], 
    InsetBox[
     FormBox[
      StyleBox[
       RowBox[{"-", "\[Infinity]"}], 12, StripOnInput -> False], 
      TraditionalForm], {-2.9, 9}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->250,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-3, 3}, {-26.99999669387769, 26.99999669387769}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellID->255555399,ExpressionUUID->"ad72c5ec-fbe3-4f8c-8b06-7b6886b2c6e3"]
}, {2}]],

Cell["\<\
In complex analysis, it is possible to define a neighborhood of infinity.\
\>", "Text",
 CellID->174986683,ExpressionUUID->"fb6bbb1a-8169-45f9-a1db-f2a99095708d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"RegionDifference", "[", 
    RowBox[{
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2.5"}], "]"}]}], "]"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"FrameLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "Input",
 CellID->17302643,ExpressionUUID->"e245da1a-2f3e-4c1d-9f7a-e6060aca87fc"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJyFWnlcTtn/f57nPs9jGUuWBk0zytj3oZDiHCRLkiWksoVE1pisNRkmISJb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    "], {{
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], Opacity[
       0.3], EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmgn4llMaxp/3U4QpEto3KpUWSkUqRbSQNkrJqH+WSv5JUpJJJdmyM0O2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         "]]]}, {}, {}, {}, {}}, 
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2.], 
      LineBox[CompressedData["
1:eJwt0k1Ik3EAx/FlNFcr017tvWk127x0SOkUFNRBEBoZsYOQKAWDBh6ECklh
vjNQ6Gg2bMEWlYcpUzwJXrwJQXjoFgQehI5BhH4e8PDlw++B5/D/P0+sJ5t6
eSAUCr3Xmi4p7UE3f+qyPtgfGeMVPuZT/tBVfba/sZUxzrIQvMsmDjHHGjZz
jFM8zGvMcZxhXucz9vGXbmjCzjPKOPOc4XG2cJrveII3ucQVtjPBEr8wwSQX
ucw2HmKVq7zDMBdY4S3WssIqbzPCVxzkv+AMmrPng7vgEX5imXFGeY8PuK6j
Ktql4Gw8xlFOMsI6vuFb/g/OqIJdZBPrOcDX/KsGPbK7+D24AwUftJ9/dFIZ
O8sdndKwPcKDPM3nzHBbZ9Rrv+BvndWgPcxdNarTTnFT51S2vzLJ83zIDm7o
gp7YaW7pou7a9/f/tz2dc0DL
       "]], 
      LineBox[{197, 44, 358, 106, 232, 51, 434, 182, 308, 1, 438, 186, 312, 
       53, 370, 118, 244, 47, 418, 166, 292, 56, 406, 154, 280, 2, 409, 157, 
       283, 57, 429, 177, 303, 61, 332, 80, 206, 46, 401, 149, 275, 59, 405, 
       153, 279, 55, 330, 78, 204, 3, 347, 95, 221, 54, 398, 146, 272, 45, 
       349, 97, 223, 50, 417, 165, 291, 4, 365, 113, 239, 48, 323, 71, 
       197}]}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[12],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->200,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-3., 3.}, {-3., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellID->6845467,ExpressionUUID->"f9518183-172a-4409-960c-da74d9a0fe8a"]
}, {2}]],

Cell[CellGroupData[{

Cell["Neighborhoods of Infinity", "Subsection",
 CellID->65844649,ExpressionUUID->"3bf4d3c6-e4a8-445f-9ddf-afb543176040"],

Cell["\<\
In order to treat infinity on the same footing as any other point, one needs \
to define a neighborhood of infinity.\
\>", "Text",
 CellID->239928584,ExpressionUUID->"46130a4a-0662-42ed-a3ba-13508a58348b"],

Cell[TextData[{
 "The definition is: the set of points ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "296a7825-8ac3-45a5-ac52-1151b15b9957"],
 " such that"
}], "Text",
 CellID->356329916,ExpressionUUID->"25f38db2-9884-4527-a67b-d764869f8b76"],

Cell[BoxData[
 FormBox[
  RowBox[{"|", "z", "|", " ", 
   RowBox[{">", 
    RowBox[{"R", "."}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->12487302,ExpressionUUID->"41fcf61a-577b-4d93-abec-643a866c821e"],

Cell[TextData[{
 "As seen in ",
 ButtonBox["Chapter 2",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", the north pole of the Riemann sphere is called the point at infinity."
}], "Text",
 CellID->76308478,ExpressionUUID->"5511463a-2ea2-4ed4-97dd-b429c1eb5d21"],

Cell["\<\
On the Riemann sphere, a neighborhood of infinity looks like the interior of \
a circle around the north pole (Fig. 1). This is the reason for the \
definition.\
\>", "Text",
 CellID->49158754,ExpressionUUID->"fd90f2ab-3d23-4e38-b0d9-8f00ad93b28c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "r", ",", "xcirc", ",", "ycirc", ",", "zcirc"}], 
      "}"}], ",", 
     RowBox[{
      RowBox[{"c", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"r", "=", 
       RowBox[{"5", "/", "2"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"xcirc", "=", 
       RowBox[{"2", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], ")"}]}]}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"ycirc", "=", 
       RowBox[{"2", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], ")"}]}]}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"zcirc", "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"r", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{"r", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"], "-", "1"}], 
         ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"r", " ", 
              RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", 
             RowBox[{"r", " ", 
              RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}], "2"]}], ")"}]}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"MeshStyle", "->", "None"}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"{", 
             RowBox[{"Directive", "[", 
              RowBox[{"LightBlue", ",", 
               RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}], ",", 
           RowBox[{"ImageSize", "->", "250"}]}], "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"Sin", "[", "t", "]"}], " ", 
              RowBox[{"Cos", "[", "p", "]"}]}], ",", 
             RowBox[{
              RowBox[{"Sin", "[", "t", "]"}], " ", 
              RowBox[{"Sin", "[", "p", "]"}]}], ",", 
             RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"p", ",", "0", ",", 
             RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"MeshStyle", "->", "None"}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"{", 
             RowBox[{"Opacity", "[", "0.4`", "]"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<N\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{"1", ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{"\[ImaginaryI]", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"5", "/", "2"}], 
              RowBox[{"Cos", "[", "t", "]"}]}], ",", 
             RowBox[{
              RowBox[{"5", "/", "2"}], 
              RowBox[{"Sin", "[", "t", "]"}]}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "Pi"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"{", 
             RowBox[{"Directive", "[", 
              RowBox[{"Blue", ",", 
               RowBox[{"Opacity", "[", "0.4`", "]"}]}], "]"}], "}"}]}]}], 
          "]"}], ",", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"xcirc", ",", "ycirc", ",", "zcirc"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "Red", ",", 
              RowBox[{"Opacity", "[", "0.4", "]"}]}], "}"}]}]}], "]"}], ",", 
         RowBox[{"Region", "[", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"RegionDifference", "[", 
             RowBox[{
              RowBox[{"ImplicitRegion", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"z", "==", "0"}], "&&", 
                 RowBox[{
                  RowBox[{"-", "3"}], "<", "x", "<", "3"}], "&&", 
                 RowBox[{
                  RowBox[{"-", "3"}], "<", "y", "<", "3"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], ",", 
              RowBox[{"ImplicitRegion", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"x", "^", "2"}], "+", 
                  RowBox[{"y", "^", "2"}]}], "<", 
                 RowBox[{"r", "^", "2"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "]"}], ",", 
            RowBox[{"Opacity", "[", "0.3", "]"}], ",", "Blue"}], "]"}], "]"}],
          ",", 
         RowBox[{"Region", "[", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ImplicitRegion", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "^", "2"}], "+", 
                 RowBox[{"y", "^", "2"}], "+", 
                 RowBox[{"z", "^", "2"}]}], "==", "1"}], "&&", 
               RowBox[{
                RowBox[{
                 RowBox[{"x", "^", "2"}], "+", 
                 RowBox[{"y", "^", "2"}]}], "<", 
                FractionBox[
                 RowBox[{"4", " ", 
                  SuperscriptBox["r", "2"]}], 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["r", "2"]}], ")"}], "2"]]}], "&&", 
               RowBox[{"z", ">", "0"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], ",", 
            RowBox[{"Opacity", "[", "0.3", "]"}], ",", "Red"}], "]"}], 
          "]"}]}], "}"}], "]"}]}]}], "]"}], ",", 
   RowBox[{
   "Text", "[", "\"\<Fig. 1. A neighborhood of infinity in the complex plane \
and on the Riemann sphere.\>\"", "]"}]}], "]"}]], "Input",
 CellID->1213493829,ExpressionUUID->"b7e8b7fd-6b9f-40c5-8994-6db401d35edb"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[{{GraphicsComplex3DBox[CompressedData["
1:eJyNnFusXUUZgA+FtoiJkRgTFKhFz4OPXgAxVm0Ml9bSWlEhJmiUgoJwog9C
DBcxxJj4gnIoCImPJlIggQdzshO2dAMHo0EfCIRCD4jWBoJQ6OFWQPFo9sw3
0/n+NcG+nOwv07X/+dbas2b986856YLvn3PRqpmZmY+unpk58n9/n7joyj+s
rKyd8Hcm/zv7vNNf2TR/VOC7N71n/fzsEYFf+MO7b12Y+9du8y9Oj/Nq4N+e
tn8+8POnfCnw9G9xg/kPUvvPm1+ajh/4l1I8gV+c4g/8vtTfjebbkp/A8+ce
n+DVns3xbI5nczyb49kcz+Z4NsezOZ7N8WyOZ3M8m+PZHM8dPsGfPZvz2RzP
5ng2x7M5ns3xbI5nczyb49kcz+Z4NsezOZ47fIInezbn/5vz2RzP5ng2x7M5
ns3xbI5nczyb49kcz+Z4Nsdzh0/wYc/meDbnuOZ8NsezOZ7N8WyOZ3M8m+PZ
HM/meDbHszmeO3xCv+3ZHM/meDbn+8z5bI5nczyb49kcz+Z4NsezOZ7N8WyO
5w6f0D97NsezOZ7N8WxOHOZ8NsezOZ7N8WyOZ3M8m+PZHM/meO7wCf2wZ/N2
fK+8HY8qb38/lbfnu/I2vsrbz5Xj2RzP5ng2x7M5ns3xbI7nDp+08VbP5ng2
x7M5ns3xbI5nc+I257M5ns3xbI5nczyb49kczx0+ac9/9WyOZ3M8m+PZHM/m
eDbHszn9MeezOZ7N8WyOZ3M8m+O5wyft76l6NsezOZ7N8WyOZ3M8m+PZHM/m
9NOcz+Z4NsezOZ7N8dzhk3Z8qp7N8WyOZ3M8m+PZHM/meDbHszmezem/OZ/N
8WyOZ3M8d/ikHe+rZ3M8m+PZHM/meDbHszmezfFsjmdzPJvjxZzP5ng2x3OH
T9r7Z/VsjmdzPJvj2RzP5ng2x7M5ns3xbI5nczyb48ucz+Z47vBJOx8J+brg
2Vz5uuDZXPm64Nkcz+bK1wXP5srXBc/mytcFz+bK1xU+/82nz5/dvGbCX/s3
35k+b+y0D5zP/D8f35zPPd6L33lItQ/x9Pz4e0/dd+ex87NrJ/wV39jhtPdx
NpoTX+/4jp92vfg73xv8qL15N35/77oP3PGXlZWY193x56VHV1Zi/hzu9ttX
jhutrLwd8uFwt987bXcotIeHfPL0e5dDe7jbPzlt92xoD3f7p6d8TyefPxqb
0344Lz0amz+S2oe8PdztH0txhvbwkD9PHkJ7uNvvSZ5De7jbb03nMbSHu/0F
6ToJ1z/c7U9M12FoD3d7rlvne7k+zbkOzbneQl49X1fmXD/mXA/D+fPR2Jzz
bs75DXn7fB7NOV/mnBdz/Jvj2RzPzvfi2RzP5ngOefXs2RzP5ngezp+PxuZ4
NsdzyNtnz+Z4NsezOZ7N8WyOZ+d78WyOZ3M8h7x69myOZ3M8D+fPR2NzPJvj
OeTts2dzPJvj2RzP5ng2x7PzvXg2x7M5nkNePXs2x7M5nofz56OxOZ7N8Rzy
9tmzOZ7N8WyOZ3M8m+PZ+V48m+PZHM8hr549m+PZHM/D+fPR2BzP5ngOefvs
2RzP5ng2x7M5ns3xnD7VfC+ezfFsjmdzPJvj2RzP5ng2x7M5ns3xbI5nczyb
49kcz+Z4dr4Xz+Z4NsdzyKtnz+Z4NsfzcP58NDbHszmeQ94+ezbHszmezfFs
jmdzPDvfi2dzPJvjOeTVs2dzPJvjeTh/Phqb49kczyFvnz2b49kcz+Z4Nsez
OZ6d78WzOZ7N8Rzy6tmzOZ7N8TycPx+NzfFsjueQt8+ezfFsjmdzPJvj2RzP
zvfi2RzP5ngOefXs2RzP5ngezp+PxuZ4NsdzyNtnz+Z4NsezOZ7N8WyOZ+d7
8WyOZ3M8h7x69myOZ3M8D+fPR2NzPJvjOeTts2dzPJvj2RzP5ng2x7PzvXg2
x7M5nkNePXs2x7M5nofz56OxOZ7N8Rzy9tmzOZ7N8WyOZ3M8m+PZ+Trl5YJn
c+XZgmdz5c2C5+H8ecmPBc/mymsFz+bKUwXP5so7BZ/tfLn6PLj32NsW5lYX
js/7f/2j6+aWKsfnTuXJ8fmd9Wd+ammhcnyepjwtPt/1m/e9sGk+5hu3dfKH
6xU/PpcVPz4fUPz4vEnx49Px49Px4/GGYy5/a9N8zL+1zx/V5ynXf+GuhblV
wefa7bt+PrdUebk+j33vhbObjww+73jkis8tLVSOz6tveuq4+dmYj72vk3+7
UfGXvJDix+epih+fRyv+cn0qfnw6fsaBaxQ/no9+45pts5v/HZ6j77xqy5Hz
s28Xjuf2Oa96fvW6Zy6bW/pPeI6+Zc3vTlpaWAnP0ese3Hjp7OaZ4Pmln/32
jKWFyvF8cSf/9m7Fj+e7FD+ez1H8eH5N8eP5VsWPZ8eP54OKH88vTn9HrwXP
ad3p9eA5rascCp7b5+nq+cfPnXXV3NIbwfNJc+//2NLCmyFf8eDBffs3zb8V
8hXbOvm3ZcWP55sUP55PU/x4XlL8eL5W8eP5w4ofz44fz7um5/1A8Lw8Pb8v
Bs8nTM/jweB5Mv1dLwfPbd6iek7jzMvBc/o9vhI8X9LJv92t+PH8uuLH84cU
P57vV/x4vkjx4/loxY/nOxU/nl+YxvPX4Pne6ff+PXheMz3+vuB56/R62x88
p+vqmeC5zQ9Vz+k6eS54vqyTf3tT8eP5AcWP52MUP563K348/0rx4/kpxY/n
WcWP549P478jeD53yu8JnrdM41kMnr83bf9Q8Lw47e/DwfM50+M8Gjy3ebjq
+adbjrhkZWVhbM+3KH48X6v4S55T8eP5CsWP5z8pfjx/VfHjeZ/ix/Pfmnxh
9fzldJzwHJ3Gh4fDc/QFKc7wHH166ld4jt6ePITn6NOSt/Ac/a1O/u0RxY/n
MxU/nkeKH8/nKn48f0bx4/lMxY/ndYofzx9J13nwvNTkZavnG9PvKHhO67b7
g+ej0u80eP59+l0HzwfSOBA87+jk305Q/Hh+TPHj+ReKH8+bFT+eVyl+PI8V
P57/qfjxnO87wXO+TwXPO5r8t9evl4PnfN8Mng+m+1TwfHu6rwXPWzr5t9sU
P35XK/6yDqX48Xyv4sfzBxU/nl9S/Hi+TfHjeTHNQ4Ln9WneEjxfneY5wfMT
zTpD9XxKmkcFzzekeVfwnOeZwfOFnfzbfYofz+sUP36vVPx43qP48Xyy4sez
48fzAcWP5/xcsNGeT0zz8MLxfHOatwfPL6d5fvC8rVnPOex5MD1HBM9r03NH
8Ly7k387oPjxfILix/NOxY/fZcWP562KH8+3K348O3485+fc4Pn29FwZPD+e
nkMLx3Oa760qHM8np+fcwvHcrptVzzkPUDiez+7k365U/HjepfjxvEfx43m1
4i/Xs+InbseP518qfjyvTfmZ4Nn1daXuJeVPgud51SXieZLyM8HzSymfEzy3
65PV855O/m2N4sfzyYofzzsUP55vUPx4dvxlfFb88jmx/2M6/HjluzjOenmg
vf3o+IH38oS9fQacP6SdOXVU5tT9mFOnYk5dhTl1AObp3+IGc9ZZzVkXNGcd
y5x1F3PWCczJa5vj03lCfJrj0xyf5vg0x6c5Ps3xaY5Pc3ya49Mcn+b4NMdn
x1vgeHY+EM/meDbHszmezfFsjmdzPJvj2RzP5ng2x7M5ns3x3PEWOJ6d98Oz
OZ5DnjB7NsezOZ7N8WyOZ3M8m+PZHM/meDbHszmeO94CL/s2KD9W9nkQL/s5
iJf9HMTLfg7iZT8H8bKfgziezct+DuJlPwfxsp+DeNnPQbzs5yBe9nMY9hY4
np3Hw7M5ns3xbI5nczyb49kcz+Z4NsezOZ7N8WyOZ3M8d7wFjmfn69p699FY
xwnt2/lKbc95cfu2zru253y5fVuvXNtzHt2+rbut7Tm/bt/Wj9b2nHe3b+sg
a/v0b3HDcP6Ter7anuvE7du6tNqe68ft2/qq2p7ryu3bOqHanuvN7dt6l9qe
69Dt27qN2p7r0+3b+oNwvYX27by5tue6dZ6T69Oc69Cc682c68qc68ec68Q8
/VvcYM55N+f8mnMezTlf5pwXc/x3vAWOZ+cz8WyOZ3M8m+M55EuzZ3M8m+PZ
HM/meDbHszmezfFsjueOt8DLvjrKW5Z9eMTLfjviZb8d8bLfjnjZb0e87Lcj
jmfzst+OeNlvR7zstyNe9tsRL/vtiJf9doa9BY5n5yfxbI5nczyb49kcz+Z4
NsezOZ7N8WyOZ3M8m+PZHM8db4Hj2XlIPJvj2RzP5ng2x7M5ns3xbI5nczyb
49kcz+Z4Nsdzx1vgeHa+Ec/meDbHszmezfFsjmdzPJvj2RzP5ng2x7M5ns3x
3PEWOJ6d98OnOT7N8WmOT3N8DudjFzeY49Mcn+b4NMenOT7N8WmOT3Pq+Zyv
o/7MnHopc+p7zJ/P9Rzm/8jzG3PWoc1ZNzVnnc+cdSlz1lHMyfubU2/nPBv1
YebUM5nnde7A9+b5hznrweasX5qz3mbO+pA56xnD/FDI11GPZb4619+Ys25t
zjqrOeuC5qxjhfxkXrcwpz5sOO+0P/DH8/3SnPVIc9bPzFnvMb851xuF/Azv
EYuzjhXyPHndxZzx0XkG1mM6+Yp8vsNzZeBtfaefK+Pzfls/V3lb71V5WzdT
eVvnUXlblxDyGIHv7jwXt+uUlTM++vm3XW+r7akn9vMa9a/m1Gua35XHT3Pq
4cypdzGnPiM8h+Zx0pz1b3PWa81ZXxyO/+3wPEgdqjl1k+bU+ZkflcdDc+oh
zFm/N2e92Zz1UXPqZf38Qn2nOfWI5tRnmFNPEOpk8rhnznqtOXWlnv9TB2l+
MI9v5qyvm7MebH5LHt88H/5kHsfMWT82Z7zyfI/1Y9+XWQ/urM8GznpzZ14U
OOvH5p/IdZM+Pu+T+H769VxPaf6VXP9nzvsnvq/xHoX51lyXOXwffDjcT3fm
urdhviasT/GehjnvFQyvBz3UWbd6KNxPqRccXi9bDpz3VcK6Rn7vwpz3HMyp
yzd/INetmp+R6yzNqWs0pw7PnLoxc9638f2a90bMec/BnLp8c+rgzfN1GDj1
r+bUa5pTX2hOPVnoV65/Muf9KN9/ec/HnPdSzHkPwZy6f/P83NGto27/zsx8
OtfRuj11q+bUWZpTF2hOHZg5dVfmvCfm+zJ13sPzkNUxP5zHI/Of5HHM/Kw8
joX7eB7HfJ/ifSpz3v8x/0Ye38ypkza/Po9v5rz/5vsX73GZ896R+ZN5PDK/
PI975l/L4575pjzumVMXa/7dPO75vrk3j3vmvB9lzvs85rx/Yv7HPB6afzaP
h+ZH5PHQnLreME/I46E546HnA4yH5oyH5oyH5rxXY35eHg9D/i2Ph+b35PHQ
nHplc8ZD8115PDTn/UDPQ3ifzZxxz5xxz5z3W8yPz+ObOXXt5tRhm1M3bL4m
j2/m1GWGePL4Zs78yfMx5jfmzCdCnV6+/s3Le5HijL/mjLPmpX7b9X55nDLn
92/O78S8vP/Y8TCcdzoUOB7M8WCOB3P6G+rxqDsVp7/m9Nec/oY8WL4+ev0N
eaTcX/PyHpA4/Q31b518V3kfzfP23C9z+mVOv3rxe55M/ObEb06c5sRpTpzm
xNmLx/Pesr+feNlnr5PvMi/77HWO73lmL2/GccJ8u/ldHZanaq6zytvzVHnr
5bD8VRN35W0clbfzv8rbeV7l7fzssPqcZp5UeTv/qLy9T1fe3rfeOZ/WjuPR
p+er+DTHZ6gnyT7N8WlOfL339UL9SfZmjjdzvJnjzRw/PQ+eb+NheD6/HDge
zPHQe2/OnP6a019z+mtOf3v9CvUVuV/mZd9F8bLvovNsOX7zsi+ieNkXUbzs
i9iJc/g54tnAibP33pY58ZgTT+97Pd/me3vvK5lz/N5xeu/dDK9Hj8aet/B5
uD5/NDbnd2LOcYbXp2LdO8c35/jmXK/mfK/vg3yvOf9/uH57NDYnHnPiCfm3
fF2al/1+dd8s+/2Kl/eexMt+v+LEb1726RVv92NZDvGbl316xemX7+P0K+S7
cr/M6Veoc87fN1yfPBqb019z+hvqonN/zemvOb/D3rzF9188mOPBHA+hTjh7
MCeOXj7t/82z4c3t8RbqirO34fW7Q4HjzZxxyhyfw/Wlo7E57X1fw/9w/eRo
bM5xw/pXPn5YJ8rHNy/7G4vzveZl/2Hxsv+wOPH4vkM8YX0qx2PO9TZcj8f7
j4dCnObEGeoAc9zmxO/7GvGbE3/Iy+X4Qx1dJ89Gv8zplzn9CnV3uV/m9NOc
/vq+TH/N6a952WdDnP727vvm9Nec/ob6t9xfc/prTv9D/vAd8kvmeDDHQ6hD
yx7MGSd77/ma48ccP6GeLfsxx485fszx1Xvf1vO3/wKayZiZ
         "], {
          {RGBColor[0.87, 0.94, 1], Opacity[0.4], EdgeForm[None], 
           StyleBox[GraphicsGroup3DBox[
             TagBox[{Polygon3DBox[CompressedData["
1:eJwtmXfgV9Mbx++553xsKS07WWVGiB8NDRUNo4Sm0UDISmRUGmaD7JQoJGWU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                "]], Polygon3DBox[CompressedData["
1:eJwtmnXgFUUXhndn1+4WLBDB7kT9TFRsxe4OLOwO7O7GQuxuxRaxu7u7u/N7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                "]], Polygon3DBox[CompressedData["
1:eJwt13n8VWMaAPD7u/dWWkXblG3SYlqNVu3THm20mjajHS1oYahIpWhVkaXF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                "]]},
              Annotation[#, "Charting`Private`Tag$77889#1"]& ]],
            Lighting->Automatic]}, {}, {}, {}, {}},
         VertexNormals->CompressedData["
1:eJztyEENwCAABLALC0L4zcU8IIGEN9aRMAUIIGmfbWP1WZK8NXlysj/vvffe
e++9995777333nvvvffee++9995777333nvvvffee++9995777333nvvvffe
e++9995777333nvvvffee++9995777333nvvb/wfFyMcjg==
          "]], {}}, {GraphicsComplex3DBox[CompressedData["
1:eJyFfXVcFl3zPvYjdvsY2IrdCbIYGGAHFhYoYfuYgI2KiomBLXZ3YXGQsAME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         "], {
          {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[2], 
           Opacity[0.4], EdgeForm[None], Specularity[
            GrayLevel[1], 3], 
           StyleBox[GraphicsGroup3DBox[
             TagBox[{Polygon3DBox[CompressedData["
1:eJxFnAnUV9P3xu98b0JCKRmakFAJqWhQKkoayJC5CKEUZYpIhFBEA8pMZoqM
kSnK0M9MIXNSyDzG//n0HOu/1nvW3d9zz53P2fvZz977bTRoeP9hSRRFxxZR
lGr7ThZFZ+T6rc65anPUzlD/s3EU7aF2puRvNWYvjRmjfWsk95Q8VvIr2t9N
bYLGLFLffTrniZLb68T3qo2X/LL6Hyyj6ATJCyXfoTFDJO+u7Sv6fY7kF7T9
TWOOlVxX579frYnO+422bbXvLF3rRW1/15jjNOZjbdtWUTRL1+io9oDaZerv
rXMu17jrJe8v+RPJN0huqeMH6HxPSW4l+SDJ8yW/pDG/aMwDkj9Q375q90q+
QtftmPnYHbV9WG137WuoY9toe776t5a8m+SxkrvpPO/pPFdIbqr+Tuq/UvJj
kh9Vu1hyC93jzWonS95X45dq/BTJbdQ3O/V72Ef9H6j/asl7S35X8uWS20l+
TfK5kjtK/p/kCyV3kvxG7vf8pd7JnnonL+hcf+h+j1P/Jbr2v9q+pnFPaEyk
7etqT0qMOU/hd/KPxrwq+XHJayTPl3y35C90zj10zvk65+eS20ueJ7mL2tzU
999PYz/XMbdITiUfqms/LXmF+nrE/hbvaNtHbarkn7T/AO0bp3ubr/aU2rXq
X6r9PdXuk/w331rjHpX8g+Sndd57JDdS30NqO2lcAx23o7Yj1N9B+5dwTsnb
qL+z+idJbq17vF1tFHOSZ9eY8yRvrjE7aMypkp9T383aN4g5yTWZ69r3k/qf
K3w/P0peUHhu/Cn5fckPS/5D8mN6L3Ml/yZ5kfofktxf13w2tfyr+vvonA9K
vlLbzmozJb+ha/RSm8V3Z6zaTZI31b21Vv9QyfUk7xzW4Km6zkNqm6hvd429
Re0C9c+N/T54Dxfp3M0yP2N33Uur0nP0YvU1zzxXe+i4B9VulPy19h2itkDy
hdrfVG1MmFc76thWnFfb6Wr1E8/JFpJ3iT3nW0reVfJ4Hbdt5vn5sn53UZss
+WFtW6iNlPyIti3VTpN8mcbulnmN9NV52pf+Zi/FfveTwlreXf0d9Hu0tufq
+lup9VF/u9Jr7FKdY5fM626Cti3VJkq+RNudM68d1stwzdvb9MzzYj/T6WHO
DFP/rervIXnn0mu7k37flfr+0SFt1d8RfRFbB7D2v9Y33Se2flikbVe1qyR/
qm2/2Ovocd3rlon14346z9mlZZ6hu7aXaMxM9Z1T+vdbar1jzwHWVEf1763f
E/Uc7dWuQ2/ovuagRyQvjr0fXdFXfY+l1mNvcr3Y37ef+h5PPff6aPuo2v2S
L9f59sy8Nt+LvU5Z7+/Hfi7W2mTt75G5/2317R/7ul9oe2DQpU/rWRonXtuf
qfWPrWeaqK+v5GnMK8nNwu9/9Uwj9M676bwH6hnHlj7243B+1stV2rdv5nu4
Wttemdfd59p/QGzddbCe4+nUOvx5nWfv0vr9RcndSut3dHt3yQdLPlRjF6g9
o/GHsE2to57Wvrax19H2ifU/a/M5yc+q3SZ5D33rTrlt41vaPlz4212nc89Q
u1RyV/VtW1mPv6Mxf5eeh+ikewrrJXT2vYX1dmdtm1bWTRtq+5L2Ha/+6eqf
J3mA5BmSH5V8kOTmGjct9ZjbC9vC44J+wwaO5rurr5bOdZHk03X9uws/V2v1
t1G7X/c/Tf1T1c5W/23qO19juki+FXsueS/Ojx6V3JX5oLE7cU5d4w7sDO8a
W6n+Fuq/XP05dqqwDimxIdr3nOSG6LzMOnox19e+s9R/mvbfVXgdbax72lz7
B0tuq76GlW0ktu7P0voEnf1XaZ32quQ/Suuo2jq2fmy9vR7zVK2efm+vMTup
3ZV4vn2PrDH7af9TmefuQeobmPs7D0DX6bpP6Lr7p7ZvjD8otd17TPInOmag
2iPoWB0zXm1eZBt2gdqdknvqPNtXxj3LdO6uateo/5vcc5s1uDd6Izcu6K1t
v9w28N3Y6+MOjflQfU8WXjuf6n631O9TNWYvyY9ntpE7JF7jrOXbCuMnsNNm
6m8a9G3dxBgKuzBa8ii1kyTfr75mwb6AL9aW1pN1dO771Bpr3y/qe0b7jsJ+
SV4g+WjJK3PrKPTMmep/sLCubp7YlmErwUHbB538s8Y8rd9HRsY/16mdgj3F
lqm/r+QbwU06z56SZ/GtwBySp0keof5deYfYO53zL8mxrvWHttuo7az9kzWu
HXNAY8apNWdtaswM8IHkj7B1OvZbyWt1j6t4T2o3qO91tT/Quxr7O3hT/b9I
PjU1Nt4Mva3zbyx5kvbXwNaylplHGneA2iT0udpXzAFtf9OYryXX17FjdOym
kreSfK7kzSUnGvOnttuqNVP/xbwvyV10zicyv8dVYc6AqXqmnpvIv2r/4bnn
4HL0mtrt6s90nqSyfntW+2/S72Mif8NZhb9joXOcp9ZIMg93jloD9J72T8j9
3lpIvkLyLpJ3kny55NbMeXQ3z6G2TPdQU/1DwW1q12DnwhzoGfDM1jr2vNzn
b4rOk9xE8hPoAX3fQyU/KflO7RsoeQW2O/c8na9tDT3LEXw78EvleYNeXD+z
bnxM8nU69mDWC3iksn5cCmaRPFnyVI0ZXvhZNtbvS1PPE3TqT6X16nTJp2nM
bpLvkrxG/T0k3y15ovr3YZ7goxQ+9l/d3+k6z/qS70Wfa3xPyffhZ2hML3Sm
7jFBn2vsr/hSqedPTd3XVWqbYh/0nlayRpnHOm68+ppi+zR+stqG2B1tf2EN
RV5/NxZeg9dKPqXwd3kYHSP5AMkPSP5c195f8hfgMZ5N51ime9xZ150CdlDf
VRrfT2Pm4mdI7h95LU4uvB6f0b21i22zOuuYu1NjG/DfnrF1OFh6W523uX4P
w9Zwz4ltUxP93hZbrtYoYOw5sfUKuuh83VsDtWGSz9N208xzFR9nGx27vcad
kRgHo6ceVGuoNjzoolP0LBvrmNngutJjwMTbxfY9wXhcH8w/VuPqZ9Y5O+s5
ZqbGfrdga0rrx5bquz61zqyv7SWp58DZGlNqTKUx02NvmQ/XY1eCLthMYy9W
64Y+1Phc40vwpeRYcg52xc+WXEiup7ET1Lpr/K3qb1RaX7dS3w2psTG692Q9
40aZdXtj/d6Gda5WJ/Za/kF9J2pMmlmXDpWcS95O57gmtT29VsduVtpGzo5t
G7GVr+j+u2IL9PtTjdkYv0j9J+u419WWs16Yp/iHQccWOs8/kgfquHZqQ3Xs
sbreadgmyc9JfgsfWfsOVWurdqL6fwczgRF07OY6z9eF9eRUdGDQKSfouHdS
68n26h8JlpT8gvoP1u+OYOjE+z5X/zXan8XGITvqfINLnwe8tLnkLZijOrbM
PM/v0O+6sdfONI2pVxpz3Mn3iz33ztbYGpnXQjPdy7Wp7Sl4rL7GNwBXoFNS
467TdS+18Ediz/stY+ux6zX+5NK/7419L0PUP1P9p5Qe/4Da1rHnP/bxJL3r
DbFtMcZN+7Q5V+OP0771mPfYLl13Z/QDHEnpcfh/25f2/fAJOpT2Q1ivu5TG
tT1L+/6HS963tI9/WOw1t3XpNTkM7gReRc9xIPZH8hG8L3QtvE1snwCfB0yO
r4Bvj1/AWPgExg/WcyyUvL+OGyj5EWx38CH2Ku0b8E3qlH7vR1Q+bwf17Vea
izgSLF7avx4s+ULJn/PuYt/LR4Xvp7/kpbwjfALJyyQPkXyg5A8lHy/5Ccnj
1VrruYbkxqWvSr5I268Kz9tDJX/GN5PcpbSPj4/B/cI5cM+Ldcw43nNin/53
netZ3kNpfx//uW9pDDxIctfSvAE4E9v3vdqXGn9kZf+iU2bbjo3H37lU+zfS
MbXVN0FyLckbSb5Mcm3JG/OtY2+xd5erfyg8APpV9zMptS0boftbD73JN9U2
Tzx/dtX4E0vrq5G69k+pMdVV+h3Hxvw1Ep8P+3Wqxnyf2r6MkPxDahs6RfvT
2H7B1domsX2Hoypj0a7487rWSaXvYWsdd4XagZHn7x+Fr/en5Joas35sLAmm
vEljjq78e+/wfsDNN4M9CvserPdZrLfY9m60xv2T+n5mqm+D2Ov3e+aszvU7
uj7z9XjGhtpemRo/XK+xNWPbuxti3wu6YpTG/536ubjuhjpXLe07Xv1vqH8T
dGDp9fKr+n/Te1uifu2Ovos9f19Bv6njoMy+6sWJ5w7+w2L8ntLyt7HXzWKN
eUP9vdV/lH6/U3g+MZd+jL1dojHvFV4brIu3WGeSj8Ye6Povqr0KrtNzj1Tr
q2u/rTF9NOYYdJz2v5Razx+r7SK1t3nn2i7E30KXJsaT8FqrYuuJlyWvjq0/
Fkluk3gtvgnGKLy+hun3lXBDwS5coW2XoP9T3cvpaodlXsuvw2dhe1KvuY8j
2yDWIb+Xg+lKn+fazPoIPoFjeO7nUX0632lq/bXvg8Jr81jtG8pzqH2kMZ+w
LkvbuEsT6wDGZDpuFNgy8/1/ie8U2b8o1bbjWG3XJsbq6IqnSj/34Ykx2Tk6
z0/YjNj4Fn9idGyf4mMd+zd+aWS/4y/J9SS/XJgHxAd8HqwS3jV876m6n3vg
J/S7fWx+YKl+D82MD+GKdyu9r4vkUaV5ec6JDkL/PJyYK6S/g7YjYuu30brm
EPBoZLw5KvY5P8APy4w5fweHxZbxq8bG9q0+1JhhmWX8lfNj+yyr1F+pNWNu
aFsjtf/yZWrdgd7APl0cbBm677TY9n0FtlNyncj44Ti1T8B1amPUv1FknDE+
tj+Cff+tsM/1G3Yxth8BRz63MPf1sbYHlZ5vud7laLWjdN4T1d5Pfa199QL2
SeyXXYBPnRlPskbgrOGCdku8nlhH+EF/Fn43JzNXUl8Xn+j3wvdykvo/U39j
yS3V93fh99cYO1Yatw/S/pdT4yj0Bc/JM/Luv0r9zq9g3Zfex7GDCvtZrbT9
p/C7Ryfg4+HfvaH7/F/i9ct6X5uboxii872i9m7kdVdT41+KPOfXL7yW8UlX
qH2BPUodK2AMcYIJai+yFmKvFdbFUTr3YLWXwP5qw2Ov9xPUd7Laa4n9lzWF
v+2uiXUYOnBganv5bFizxBjgRQ/Wsz+TWVdepvGdEttuvjnfnrl0oeS1kefY
WZJ/iLymGug6Kwt/R3zM79R+ZM4k3taM7FMfr+udjV2E31FbE9kHH4LuUP+Z
Ouf3kdcmc/msMJ8namznxPjhuswYCP28JVgD3apxl8PFJMYh48BRmX2cPTRm
u9JxhT0lNyvNfdXWMReotdWY/jqun9p3kveDM0nMOdTS/rFqbZifsXkO1hrr
7+vUa3Cc+v+OrKM2Ut/5arvzrbX9NLXPiC//a/H/+oktegw9NCL1826r/T8U
1gdnxOZF0F3ovzODDtxC+78pfG/b8Y4L67k+Os/+aqsj66dlqfXJDXrW69Wm
873gdgrz5+/rm88p7D/CayyLzRHBZV0deF14L/gv+C444U6lOY09tH9SZi4O
PABHjP4EL04OvDQ6dHmwWeBOeHC4KWIST8TmDIl/PBk79gFO+TA2b9Y7Mye+
TlbfR7GPJVYDb861wGpXBS4a271PaY6uu/qmZF538IpTg62Hg/4yNjd+SGae
en64fzh0OBzwDTw+2Aae+qvYY3pmtnnYu320vSbzeiGeBmeNjkLXE7NBD8Br
r4jd/4f2n8HzRLaTK4Ot7Ke+aZnX+AHaTs+sB7Cb/UrzmWC2jSV3iIwBZ8TG
gf/5vfjC+MnEmfDficG1DP7yd/is+t1Z8pqAt8BaP6bGUuAo1sCccCwc47iw
XlgncATI+MDEijgnsaXHY3O/TTL77fjs4OObY+O3xpl9ZvzlTTLrdPQ5fAR8
AXLtzFwDfhZcNDEw5sDPqbEjuBFsXJXmHuGWGgZ8uDa1Dwkm/It1kRkrxpl9
ePx3/PxpsWXw+k2xsW7NzNgXGex4Y2y8+m9qPxOM+kvqNc96/zX1emYt4/fV
0P20kPxbat2B3gBgwjXAM8AjTI0twy9cGxsbEyd7Pg4xL/R3bA4WLpY4GfJ7
WrvvJ8YDxwZ5MH6N9p+utfqG+t/CtiS2y+CeJQHzva0xZ+bmRfHR303sp4Mx
yB/g90nBLnDMk+jP3LFRMO8rhXHvcTrBYrV3mJPaHoGOiBxLPSbYmqex37nj
CAsT9yGDUV8I2Ol1fEa1H7BL8BBqb0reRedslzsmcl/iuAf5DPBJDyWOrd6r
8++SOydhtxAfeRC9rnucUzpe3zl3zsO8xNzXvMB/7YF/kDvOAk+yt9oI/T40
xBS4vyX4W4Xt6WPogdyxpAck75n7fjrmjis9ovEfqC1Vqx35/h6Lzc8flpvv
fVH7BgVbvChxnJo4JTq2Tea4MnEr/MslsWV869djxyjhZf8Xm5ttobHtUuPM
nSS3Tc31kedAXPmCyHHQp2LHaIjLLozN8++QOXZL3Ba+mlgycUZisS/GoR+8
VjonBMwKrh0f+d09F5s/xJfhW7+c2G8k/n0Tz545Nklc8rDEXBUYvmuQP6Q/
tT8PrsCfB4Mwb/ERFgU/AZ/98so5EPgHiwP+hyuGO8aPxvb2Dva3bWauEzvV
Dh2WGlvCX5ALwjuE93gt9r0Rz21TOp+B2O2rsWOCxGOJy5IXQdz+0dixe/g7
4t/oK7hJOEp0GvY8TWxza+u+bs0c+9gErlv30DKy3w7fCAbGdh9dGg+AEYgl
gBPAiseX5rHBokNK+/jwYvBs4Mn//El8wGMy+41g3fV0rUxyw8j4d03sfrAK
sZEanIf5lZnnx5/8IbbPCNb7Pjbeq/DjM8dc/ou1gCvAS/CBSyNjPjAi48Fa
8IUfRPZ/yUfBbuLbJoVtIti+VuHx+F34X+DqYwIefQt9HlsGl4Lp/omNc8Bg
xBqZw2CYY0q/K3zMjQo/41GJecWYZw/+Xa3IPGP7oN/QaehH5hh68KfY/i8Y
6fDSzwjHOyO3Pt9c2zsyxwXguTZKzDHCvxKzHBR0DroAPQBXTByCbwdvAoez
X2SOs0ys27fR/i30jXpH5j/WT2xT4IvuzG0L4JOfz839NiGOljnOAucIV3lY
ZI6kZmIbtAWxKZ2zo+QjwvvkXcKNkxMzKOjAXVPHi//LucGOH5nYz/wlNiY/
rDQOjImtBD0GViSmVkXmoeCjwBhwSEVi+0t8oE5iDLC7jt0xdYwSLD2ytL2G
o6wbrot/i5/LmoLfJv7Be9gxt05HnxMPQNejP+F7H8ltizkOHc+65L65f3xk
fBA45vcj63Ds1tygM4lpgVd7BRn9CYYk/orew5e5LvgI6Or9UseC0cPkE/yH
b8l/ADcey72kjh3DM7ZIjBuxi3BE4LEBOt+MzHwLHCK5a6wLcht+zo1XsQXY
SGwi+Q/kKnGf2EW4BfAz7x79xvsnp47YAHOjknxuZj6cGErT0nOjVuZ4CbES
YjDw1GCnVkFfEU8ptH9M5hhEpu05mWO78N23xubA4boblJ7D8Ob3xObS/+Mx
4Srh3++OfT/Ebe6LHbshVnFX/P8xfeJDrB14dPh0uPdBYe59yrvNbV+xreTw
EJPGTsEDbFD4HS7MHEfArztS8otq74X13S2s/TfByJl1EXGKi0vzBsR2eyTr
0uaiP7VdrDHQ772D78a7/SMxv8AY4r/wDIwhDtIl6D32dw9jiA/3DGMYi4w/
uyjzOGTyp7ZNbN/h1roG20f8BZ5tWeRcIvKLsLNgiTmZcct/eYrovX3Vv2fq
HBXywc4obaOJDTRKbOt7gEEy5+CRi3Vu6XlOHha5dLxPeMpdEs9z7Ch82guR
ebbahW0BeV5bJMbw5GiNKY1D+sPdpvYNyfUhXwi72bl0niH5Uqx98jzBZ71Y
16Xvh282MdiIRuq/qbQNQs8QY52SmFdZt1V/ouuk6MrItoVj8eV30LG3lo5V
wzdcFtY76/XhsGa/1XGvlo6t91bfI2qz1b9av1clzvMYoL6nUucl0k/+B881
C3xbOi+Ea91W2g5i97B/cAV7BZn5UDd1Tk1nbIr6Tk6shy8FPxfG//gpt2W2
A63hhCrnN2yoMRvnznGYHFu3oldXpObr4epXpub6wQAxnKTkDSSfgM1PPX8O
1/a51Bj15czzDN6VeTopzNUeQf5K8ompxzAPO4Z3CG/zl+5lTWIO6QiNeV5t
ocbsohPcUToPA/nO0tgG+9gAbj9x3IEtfufd4O7K+S41dY71td0hclxsehKt
W6jgi1q53y1xv5MKY5xZ6OPENhcMVS/3tWYnzgPCLpBbsn7lcbXDO7whMf4h
n4FrECcZUxhzTVLf0ML+F7G7OxPbUmwN+UX3oGfRNzpnjdz4qMg9P5nv94U5
/1rp9/N9Yt3/ZND/2OimYIXEccP74D0SY4dGeXgW/b4tsR0nxs010ZdN4Gk0
5pDIdr557jHc44TKsf8GGrOVtvtGjlFyHfQ08ZlJhbHGRO3/rnRsccPU+SHI
V6r/xMI+KfkpxxTm5Zpru0Xl3BFyOlaX5kWbqL9+5VwHMNHAwrjoIo05qjC3
Nkj9RxTGumCxwwrjsXEa801pHnWFtp0r85hwlksDbzlB/UcW5gDR68uCbie/
ZlVpbvm91DoU/blh4Tgg+mo98F7lOXmExh5eGB+Sj3N0YX6sv7Y7VM5p/kz9
TxTmZ8glbx38kY8l/1M6D7N76pxz5E/hNQv7L+jORwvrz/PwNQrjhK8kd6zM
BTfk3VTOIxmrY9errK8u15iJpXH4P1m0LmhOPgg5HCPVDo8c938wN89zPliv
MMe+ic5VR7/bR8bLHwXMPCz4xXDGDcN8Yz7dFnsuY/fBkvAU4ChyHq7PPed3
49yV82Yap86pYb4RlyRXBl4ITuPOzJh0g8Q8CFgLX+T4wpj2BOJxhbHxZmHt
swbBtvAX4FtyJ67LPd+Ih87OzatUifkO8G1VOBYMr3Vd7PkLxtgqdR4i76Se
9m9SOX/rUl33ktJYlByHsrLvMyizvkPX4Qc9nzl2cI6uubJ0jO8syQcV5urr
aPtkafxft3DsGPxPnPGW3Dp8MmuqtL9Grt7wxFg9z60byJP6Wvu7Vs6x2KRw
3Jm43rapc3PAUfh95AfNTBz/P6+wfm+ROz/qXuyH7jdPnceF3VgebAf5WB+i
w9Q+Qt9rTCv1f6TfHye+t2VhDHPsE42pozGdIp/jk3Cea3Td50v/Zu59Fubf
p0Hmua7W/mdLn5d9n4f5Sf7WF4lzDRdq/0ulf6P70IHoveHhXJyHcV8mxvxs
vwryat3bbqlrIqgz+UbtPLUVvMfE/siYIJ/D+TW+Q+oakLPCec4Mdnt1sNHU
EwwItnt8uCfuB7v+bWIMMC6Mp2+lxu+Uul7jR8ndJM+IPPa7MB67D2bg9y+Z
cQOYYWW4Z3AXOVlbps7Lqhv0MjqZfPAnEuM4cBo1NU8mzg9nC6/QVWN75c4j
PQBfpnS9BPK80riXc0yrnFcKBuyWGweSv0x+K74MedZPFcZfYGbyTp/Rvvc0
/ufE+WlgwP1z4y7ytxck9l16wWXCTUTGctRuLAj2nm9K3IhcN/irIYljCwcX
ji9sndtWoTfIQyNHjfewQW6dhb4ix3hK7rlKXvHNueckuXzk4ZFzRRxsSOFY
GHG24wrH2ohRHFKYwyFGcWjhOEUWMAT4gfzqdmqtct8rfCGYB534Y+JY2pLA
JfKbuB+1UcT+wKLk8VLD85rez6uZ+RB88cuCP74kcy5ov9DgTRgDd4JMrAc/
AH8APUP+FDgeDEYspW/ieArnJx+V38SbsHn1wxh8aXwNMOQhifEkPgs5V/ze
O5wTncY9HBiuS/yLHNX1IvuDfcK1Dghj6G8b7g1ciu9OPhA6Ex0zOugZeBH4
EfIR4QngX4YHHxp/jHgzMaAfMq/XmUE+P7GfBc8yMoyHO8B3g3uGj4Z/5vzE
1+Felob5xD0QG70S+xHm1wdhjnEs/LX+1vGCcIUfhnuDy4AXInd3pl7acLjF
3DoN3QzXNSrwXbwH3hHxQXTh+KAPr86t38DmTeEFU+u3F4NOQ9+hb+4MOgd9
uKC0Poa3GxO4O3QteplrwbVcGPiWF0rrUvQgevrcoKvb4H+BUfX7/txj0MHo
j4lBh6CfnyutR7eBp0ydK4uvhJ+Lv4NeHBP0JHpoZdCf3A824MSgn8YGHTUg
vAfmw3Kd743MsdSO4ZzvBxtXVX4e7pNaAs5PHd8s9d+UWu+ix9G96Mv7g87k
ftDd6Gr80TuCT4p+nRF0LMeiu9H/8EDTAxeEHXkq9/uvWzrfFS6tGf5B6poI
apWorYCrICeO+gL4qual6yDwTYknUkcDj7tr7roIYgPkyhGvxCeG+yWXjjy6
z8CKleuy5mWuV4ILp/aI3DY47/0rv5MPte9TMG3l2qoNStdKgItYB2vCuugP
Ri4c86Huhzx/9HyrzLVLxHB2KF0zQq0Uuh07gc/cunS+Pf49mJT6JuI85IaQ
CwHXfoDOf1bh2FH33PUG1BrsWjoOS17veRrzQGEu/7vMtZ3MFXI88XeIwZ9P
HWHhGGkUsBx887vwOpVjzy+XriXhW4OFP8q9FsjxI8+Y2Bm5iviz+G7kJRIP
hmNfWzi3Hy6Q3I1jAgYjV5D6Q2K7/xbOzcb/TQKGhC+nHo1aEuIk5GddXBi/
ZqV9FvIGiIHjsxD/JoecnHLWCDmT1MbAe5ADSa48/NIFeqY3C8dsqXP8Mve8
/bmwzwKvvLh0jJt1hF58urQu2i+3jcQ+dqts+8iv2S5zTRyx6G0y19YR2/w5
cw0kWOPgyj5p/dwxZeqi4EP65K4PoTbkyNwxj2ex6Tr3oMo1UcSsyZmjvmtY
wLvozPmZa6OIRVNPQM0X/CW8Jbl61IkNyB17I+7Gs1yQW88fpP2XFI5zzs6c
v8e7hS/nG8GZJ5lzDonHXqD+AyvnzBGz5vuRM3mh+gdUzs+7p3SePL7sM5yn
cn3Xqsz1vax54rzU5zHnB2bOVSPOgJ4EP4ExictTw0Xce0HmnDfiD4tK12Gh
W/atbLvJRZqbueaRWBb1g9RtEYNaLvnQyjV+c0vnU8GjESeldpJ8AWp5lgXc
1SF3DRj1Xz0rYw+4lm0q11u1zx1HY36jQ6hlnFdYVxBrI7eLdUf8nZw1cung
eMltg1dbAt6onC9IvJ7cPXLvqDtsHdb4IblrlsBzv2WuA4GnIsZHHi21fNgK
bAaYhOeCEyS2SM0QNafw2fDS5KF2DJwo3Ci6/a/CtRLkdJIXD19MzB8uAU6B
+MN2levamMtvp87rhheCs8Tvhjd6S/v3qZxP827qvO4V4IrC/j5xoV0r13d8
ldl+vh30xiv42Zn5UepryLUBw8zKnGcCrmtWuV6JtfUovnjl+PHI3DFYYtfU
c63OPbc/T52jRb4W8cB1ccDcOX7kB5FX9EthjgL55sz5NutyrnT+XpXzcojl
1q6MG5tX5gHQ2VdIvrl0fAwsDNcDxkT3gsOpASVWWRRev00q17JtpfG3lM4T
Iz5HLJo6eXiqxpVr37bInBeGj/9rwPMzKmPxutp+W5rz2Lwyf/Km5E0r+7D/
gw+ozI28HXTVxKCvWleuf9lA558KT17Zv4RPejxwSm9qf4/K+UBvSO5eOX8I
LNwl4OF6lbmLtZn9D2wVXPINld8VMXlyCvCf8Z0bVOaLmBctK9faoEuY28TH
yYtE7+GDUFc6Khz/TuL6EupM4L5OyZ0/AG5nDVHfTs4M3BV8FvwVeabkmxKv
o44WPofYLHnT1JrBN5I/S24NMc8tK/NgzBfqR8ljJzdnj9J8Dlz4nqX5HLh5
cu3hfMAJ1J5iK9G3cwJ/BHdE7Qh1Q+TRMM8XBR0FT3xjaR+U/LINA0/VpvL/
QNiMdVD5GYbmzpWmTpMc5fVK12mSu8zzXhb09jOl+QdwHXoAvYnOpKaSmknq
JckvxsahM7tU5kMG61rXVn6/O+TGfuTHgYfhoMgrI976Qea6JnA598X9kZ9B
bjW1o3tFjueT70FMn5wF8j3IW8DXxPfE3yQP/JrwjejHh50f5jXzG7vEPCbX
+svI85j86i8kT6/s/2JvWWvwzvjve6m/qMzrUO+LncBGdKhcEzcw6Arq9Mkl
6VSZD2QekZ9I3T55+MfnXqvkFJCrTo0V+ervZv4fGceG9Q2PwBpvVLkWdfPM
+UjUkYMzx1bW/22CX4guQ4/BFcNXT1NfmZsrpg6G2hnmAT4dNS/kroLh+fbk
WZLfcHjmHGrqHfhWfDM4X/g9crmJfRPbIq95HSefmdfC14Szh+8ihoTOBW+v
410y+zXUsmCL8TnOTszlwsk2jmzHwbLgWPgQMP6ZYW1S+0Oe0NeZsTo1W+B0
9AlYHbuNb8I8ZJ6Rm00uB1gRLhXulLoo8HARsMT6pWPU1E6NKswPNgu6CS6f
3Ht4uc907KrCPDP+7JTCvgF+Abw+sQbiI9h6cDOYGXv3Qni36Fv+l8IDiWMr
V+XmIuC3L8nNG/yZ+f9owHOsLswb8x3Rh6vCdbkW8QLiCPgUnJdz7pybbyD/
iJowMDn5YpMrx0TgP/AXpwSfEYxBXhB53PCuM3NzRPh51wZfb3bp2lhiHWAO
cpz4Xy1zgq2H82HdEccCG3yWmaMYEebP8alzgzcpXetXJ/gmxCnw099Tf+/K
uarXVI5HNMZWantpZV+OehTqIonl8n6IH5Ffj63ET8BHYH0QA5oQsArxDmog
+LbUlfN94WnhW+FaNy1dk0iNFtw4nDh8+H95vdRaUl9PXT019dR4UftJTHhc
ZX4A/QSuJpbH/xsAD5ySupaNeiPqHMnFgNe7rHJsjzlFLersYFuoRcW+zC/N
G8NLjCzsh+CDDCuMk8BI6IrBqfO6l2f266m5oYaB2gZqEKj3hEeAQ7iycvwR
XgpfEX7gpMT/04P/mUNOwtuSL6zMBRAHIW6xMPJ3wbdZG+zyTwFHrQ74CZvC
/8a4pLJfTf0ZtajEeuCc4ZrhmcEbYJWrE2M6Ylrkmpxa2B/DFyNOQT3/Ao1/
oHR9Za2A634OfhD2nngidar4g/hm+GXoHGKL1H9MrGzj4EQ3yh2zo27yjMp8
HfUN5FtSZ0cuAHXn+GONAx6mHoxcoXUYJXUeAXORGAbxi3sy1zmSL1Avc10n
OVbUO04t3M//HiA3m/xT/mcMvh+cAP9biHpP8C04jFoAclHRh9TNwrdQw8r/
KSJXC78eHAAGOLMyx0htxFmVOcmVARfB1eIvkEdBPR81fmMq3w85odhH8unJ
ZSQ3lfpO6lrJX6WelVwY8Aj1OGASbATxA2IHYEFqZslvxd5Q00qOBliButGm
YX72qVy7RV4uthb7hf4ndgtHyFz9OPOc5LsQS0ZPkj9MvRS4gnxX7Dp4gxwP
akzRFegT/h8BHBq5oPBqrBFsHBwo3BG5ANhi8gGYV30r14+RTwFeJaeCvB7y
ccntwXZQ+z064A/+dwPxWvT5IZVrMslXgVNg/ZJ/Qp0rugJ/gXyM/cI67Ve5
to26Rv6fD3Pp9sz1udgR/pfRd7n5eXwW8jb2CbqanFHyRVmDzwQcxf+Y4v9V
DYlck4dfTHxri9I19Xxf/HZizTdp/Fal6+75jmdXtl/k+fK/PvjfHBdF5tvx
t4cEPYQ+IrYA1wS+BFuOr2wXiOFcVFn/E6vB96e2kJwgYuXEcG8JduHqyvE/
fO0pleO++NrUNJJnRHzzi9wcBf8niv+vRBwEbAN3QO0nWJtap3eCPsFnxl/+
tnDsFUy4e+X/wcWaQ98wDg6J/zOE/4zv3Cx8X9Ydtbasc9Y4uWn4lYN1nnMq
8zbkNfN/d+Cj8NOp5yAmi+7fsnTNO2sEGwT/Avfyf2jUTko=
                "]], Polygon3DBox[CompressedData["
1:eJwtnAf8V9Mbx+8890ZCVioqo2QVDUUkqawG2dkkpYGEVLSHGZlJGSnK3hFK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                "]], Polygon3DBox[CompressedData["
1:eJwt1nnQjlUYx/H7fd/n8dhey/uSXVKpSZOoFNqGSCFioo1mtPzRYl8ixtIk
2SqKSSFUYyuMIdNUqhFaLWXfUiEh2cuSPld3f/zmOb/vua5z7vvc51znuaR7
z4498pMkGUFZapFLks9LJEmbTJJMpG15SbJRRwtsTkGSNKYh4g5h92Ef8XfT
bGyB3PlUW1+N4NgG7dvFvcs3ogFYIzG7aS5/G602xyoxLbEd2h2we8zdnF+B
36X9Km3Vt5K/A9+u3V5cO/xXc3TEl/DN6TVzbMfuxhbwTekFrJm8PbSIv5PW
G2M5/yF1Fd8JWyJuBv8NHbYw7bCT5riIn2S8UtqDabrcm7GfabGY1rQB2yCm
HbZXuwt2v9iRxr4UH8ifMmaxOb7FbsJmYtfQM1jpkkkyDC/UPifvPP3D5+Ed
tTvRGn1/GH8sXlf7Z7m/UCkxn2BPY2/w+8ROEDeeTmFbYv3oGzE3mvdtMQcy
aXxZudPxZtpV/Vaj1VQOv9Zvw2z63SrJK8J6831oN1aBL41v1P463gOfYs7G
2Az+oDkGeefyJdO9EOM08duUZtERsX+J+5va63tM3hkabf16yd2LPyeuKtYr
voWxMrEG2K9yP8E604fYXuwXbFnsH5qTpOtZR24//kJ+urajsCuxwdhPVB0r
5n+T+z3/NO1K0vfaH3uBf6IgfcehcmvjffndVAZ7gv+HxnjmPh7uAH5O3F65
K7W70ao4X2L2YWv47rQWW4Y1xdbJnSC3MT2OnaOXsN78frElrd8r4hrIGcLv
wN/jryuRfrdirNCcs7H62NVYGSyDHcZGUSvv/5W8zfhSvpO4d8S14duKK2GO
ilgLcWvEdaeKWClsPdZLTE9aIfdHGhpz0k59TcU2o7nG2ydmaqyzvHLiXvce
VcTFhxuNlccmY1WxPOxr/if6gG8Ze8Z4XcQdpWHinom9iz8VdURcKeNn6YIh
X8bmYbX4PeIqiS+DFXjuh/iHaZO4fD6Df6+92lgP4g/wx2i4nB78DrwsnxHb
le8WayV+pvFn0Rlx07ALVCguK+4R7ZV0q2ce7Bmq4D2N8yMWr3w//zsNkPtk
1FNworgyciv5Lc6m37SQ/zjOh3Ea+L2GcliR3J36v5P3qPy2nmMt1ll7ctQ+
4y7lmwTXHo9dT39GfTVG51gjufnYPH4b/gpfl7ro+zuX1qKoP9XEVKcz2HdY
D6wGX5MW8tujBsqrR11jXbCt2Di+dpw5bDm2A5vCXxXnBluL3eIZZ8e8xuob
9S2X3itxl1yGXR71DtuEDcXq8VfQIv4oXqCdiW+i72yc09iL2rWw2rSOvzX2
szku5fvpm4RtEfsCdlHcNdgJMT9gg+JM0UhrdgHrQ8cL0vMb5zg/noWGYxVo
HJbhN9MIviKNx5J4DxrGl6ex2EJjNcRWaY8xXn0qG3lxrsX05yfpOx81LfZ5
QXrO47wf5zeIfRbL0QjsYJw/rDd/1v4YiJ3FetCRgrRORr0sFPN81KK4Z7HX
sBfjbMT7YeviDpH/F/ZlNl2jaXhV/DP+FF6kXZxJ13YuP4cqZ9P6EnXmdf6L
uL+NUznqZ9xR/C4xY/U34K+lxfwxPKtdgh7RtxVr7Vnmx52HPY+9ijXCRmKl
qT72ey69M+OeXB/3atQEbEg2/Y/yQ5wvOhTvC1TCNvKb4k7LpfdF3BFr451p
NH+VOZ6LA0k1/ZyO2pxN9+JbWBUJ0/gbou7yRfG/Qd/5mNA57KD/XlrNrsJ2
yZ/+/3+a/kl69+7Epv5/n8e9ejz+W+CPa0+OWin/fexNc9TyberEHU6Dopbk
0v0U++o0fYqfwMrJKZ9Jz2d/cXm5dI/FXjtJk/jPcmkN/q8Wix0Y9S+X7tnY
u6foSNRLrKX+VrTceCuwk1iFqPOZ9LxPllsFmyH34rjf8H8BGUhMrw==
                "]]},
              Annotation[#, "Charting`Private`Tag$77917#1"]& ]],
            Lighting->{{"Ambient", 
               RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
              "Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{0, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 2, 2}]}, {"Directional", 
               RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
               ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}},
         VertexNormals->CompressedData["
1:eJx0XXVcVU3XRcXu7kJRDLAbGVsUBbsbA7s7UEzAQlQMUDEQFQu7GEUwkJQW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          "]], {}}, {Point3DBox[{0, 0, 1}], 
        Line3DBox[{{-3, 0, 0}, {3, 0, 0}}], 
        Line3DBox[{{0, -3, 0}, {0, 3, 0}}], Text3DBox[
         FormBox["\<\"N\"\>", StandardForm], {0, 0, 1}, {0, -1}], 
        Point3DBox[{1, 0, 0}], Text3DBox[
         FormBox["1", StandardForm], {1, 0, 0}, {1, 1}], 
        Point3DBox[{0, 1, 0}], Text3DBox[
         FormBox["\[ImaginaryI]", StandardForm], {0, 1, 0}, {1, 
         1}]}, {{{}, {}, 
         TagBox[
          {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[0.4], 
           Line3DBox[CompressedData["
1:eJxN2Xk0Vd0bB3CcMpVSiKRelVQkSqUMnSNSojLLUCHN6FYSScbKUIaUeZYM
mUnmc0xlnmcRMkvmWfzOu9bv3fvcf+5an3XWXXft/exnf597dxs9ULvJQEdH
p0JPR4eQ7/Vr/74QLN3sbYG+44fTdP9/FRoOeP4l/UXdLZ6pnMfof17/rlhu
jvTbnRNxxTmOwHt1gnhGSL/0Anvu5v8WOEcCbXMb6RMsWW+icryBEylnDxSR
/tl79K1dnB9wh1z+GzGkC1Uaumv6BwMv27MONSY9VaXvunlOJPBAjp3dkqQ/
qGA9W3/0E/Adx69GbiR9a4FokVBcDPAFKXvP8FUEMxro2lvmlwC8hKmL0esv
gp1RctZoyk4DztubkI2RXhQoJn9rLh14Py+/1+gKgrkwtW2fOpIBfDwP/XSU
dO2Ta3KLMZnA4xKXHr9aQrDegQKRPJ88uJ5WmV/k5xDM/mvuNpPMIuAKXCuh
n2YRbO/4Z2JRsxg+H5+TiJA+PBH11GEa+u7gS5JJ0wi2ic7wsdPhb8BllI03
VU4g2LhnGU3hYylcB7vjDXwjCDZjHbsa5l4FfNDbX4OvDcHkEoYv1Cc2AOcZ
64gobUGwd+JHDucgjcD/NAnKP2hGMOeL49ohV6AX8d6w/9yAYBuGU3aqMzQB
V/scO/mzCsGkxHvLH2s2A99gYsR8qgDBgv1ULJ4vtQIXf8SulxRJPn81uJwe
7QJ+9B6dXKU2gn0SFmlR1uoDTuMsKhP1YMCiNGdkhWvHgKtfvL2Q7ECPLQg9
tk9QnwZe1cWiVsBBhwUbqCTPlc8DD3biSwucX0GHnTkdgj4sAz+RLeD1CFlE
F1ROIc0n1mA9hzTGWabMoIc2qfaE7KTH/vMDfGLxLloTqPkHCd0HsgzAnSIj
GR4mDKAOk+HCKyIIcISh01Py9QBaMT5pUykGXfDJdpdVgwE07gz/Jj9x6GbF
zp1POAfQNkP1fv5T0LvzWPj3Wvejoxvn9BbloP/Zevqa3bk+VPD03qbiK9C3
i4z6Ov/oQRlGd78teAGdVYq3K+VLD3r/Ok13wQ56ncF+otm9B53EclWFHKH7
B956wSHbgz7ew59r+xp6uortpE5UNyprIfhwwgP6Q+EHSgrtXSjXe4+hoVDo
e744iTRNt6H+NvuSjuZCv+wfcYr41IZKmJ3NKcmD/uHEzIEonTY0wZufQwOH
PhySuqSPt6Lmv99+NCqE7td13/SVawvqn3xQ/lwpdJpveVztP01orpnUwcMN
0NdG5EKLFGpRu2l7fVo/dD0FBZedUzXoDvs+GZMB6NMHUIl4rRpU7bma4Y1B
6FwhG1TT/qlGE5VvmcoNQ497EOZiklKB8gTIvS//Dd11OdTuc8M3VGyPzPjM
FHR9LdfrbRLf0KnBY60fp6EnhnFP0weVoJt8ttCpzEAP3R1dKWdcjCbFtmzw
m4WebJKi4z5TgMbw3Nk8Pg895JQVnn8gG1WP6ozJXIbOoGF5j7U5E22NeJMq
sAL9jEX3zsuOX1HXMsbdbhQPGlvHW9KZjnYeGxU+9xf6TmMD/w6BJDSEJW3O
ehX6e+1ZlMc2Hq1r/LM3h+JiWlxDym2x6OkZqS8zFL/N8+p4+NuPaO/BCkR7
DbqF+17twsFwFI2fJGwpfoezvD/XMQQ9pDfVE0Hxda0re7h+e6Ovb+lfbqX4
woGsMzTsLcr7LSNwhPp89TfWxBgH1PVKldI8xbfPp4lU7aahce5B11cpzt8R
ybBdQgM/abKnZY3i7jLb5K/IPMM7X19LXab481jPJw8zXuPCG9QmJykeQNu2
hWe/Fx6SuubdS3GW9Pe+U4988ICq+wFVFI9XHK77lh+Im54OWpdG8aPsXeGK
L8NwpWd+9e8orl4nZ8ZUF4XfYuQNkKX4PzyO9duPJeNWT8Nb9Sjrb39mcHjm
VQoeKffSiJPiw7K+2yraUnEr4ViV75R9r6j7JH7b9gteo8eiy0fxIv+H3Brl
2fidjNG9jpR6yzrxNUUrqRDPFbiZJEepz+afHyNeXSnCK9o7XSPmKH2yTE4w
hb4Yt7mcULlMqfP0pOL9s+olONduNqdgyrkIF7T6Jb7wHTfcrPo9eBJ6/aMC
wgitwlP4ttV5jUAvfVgy2/6jCk9zit4ZQzm/l/JDfio9q8blfoi8zRqC/mwj
cpL7Sw2+ORBprqL0h9tPP//az1WHtwXZcOX2Uvrq5A0jb5cG/Fh0r1NSG6Wf
BHgNJ5m14mm510VmiqArXVw/NrS1B3/eNFjM7AqduSGuqVi6B1c/ctc3l9KH
x3/OVgTe6sGdhHfV3HsJ3fyXRYpkdg+eJlZNy6D0ebWfF9mlDHtx1ulLnqxP
KfV51iZSKvEXviFDt/OTEXTLP52RQ3ID+JbT1ePpx6FHspzr1tMbxf3l2A5r
VTAAP12wtX/++RSetTF+/lwuvDdPiQSNsyfP4b0as9qEJR1wH6Xx0g0dS7jo
erFr/R//gvuXZZeJRq7qKu4xXcZwkXsJ+NyK1vaYEjrifXT+9N7yWeAR1oqa
jpsZiEu98dLdhyeB7xo1+5K/xEB48oeVPZMcBq5MP/KRd5WBqNzIHDW4BXq0
1usDD+kRItbJ6srF4SHgTGG6Q2zMCNG8r+UJ4gf9TRC3GCMXQtx7ZVezY3YQ
5hmRyK2TIghxsna3CFPiAPCXOwI3xOkhhNDH0ru8O2DOmf/wu1jrGkJEK1t0
Z07+Au7FMjT31wAh/Fhyo1RLoYtPNRdI3UIIfkNtpUdPoHN1FHWZ0xBi2pTv
0sOaXuCqrY7ePxwRwjjskRfNoQd+zgJ6xOYTQghe9k11L+uEOSonVlIrBiHO
834Q4LeGHvvj53WhOIR4qxGMxR2Cvt6qe7koASHqOweKYzx+AM/eV2iam44Q
3nUWu1U1O4Dndtu2FRQgxDvGxfMGP2E+nBet4eRrRQh1eZo//TjMq4L0mVXa
bQix2TQeqw6FzvFEyse9HSE4jRvX+6hA1xPu0hj7gRDKWoUnuVPrgbMt3LN7
0IMQrDfV7vaa18H83Gai/moYIVSK/Z/oTsP8zCi7DVuZRYiXGz3XZOhhPk9e
vWPsM4cQ/spn1TfehDlfoNmxUHgeIUq2eiHNpYXAXTmchM8vIMSLOP3N+p4F
wB2dNiWcW0KIY/x7G01P5wOvqV4MzCFdcKP9w9L1cL6wv51UJLSMENk/6Xfx
VeUAf6TOnrdE+msvl5okvSz4PQuYNQ3/IoTku4ZCT0s473wVDmFKIj1s83Wm
XBTOR4mSilPzpK9/Y5rSy5gKXPFz4APyXieWYjMKFYSSgCcF7GXIIF1qR+Gi
dWY8cPcLDpWjpFtNmajFKcQBfxXoxay4Rq6P+0V8xigKuPWE8DMa6Xwqnatb
JiPguTal7fUmnekgkSFkGwZ8uFRrXQrpC/uVF1/wBsG5o7OFr5x0yWXbyvAT
vsA/xI6ZdJHuhdluxdXeAR9R854ZI/2s/dWxpE5X4NJ7StIWSE8LGzrfwWUP
3O+lXRyZAwgHLP0U60lT4D82F7eSOYBwX3dSF69Wx/9zwtLj9Arpe8bKAm44
WgKvCfrVMU36BYNdBc4sr4Cb2RQmD5DObxP1QLfOA3gDJprXSLrH4DbZd5Xv
gW88epg+n/TtmnMqj5L9gas4LIo6kO43YX1/c244cG/RRt6rpBscFbaeEfkI
nCv6qow46fcKjb82hn4CLiD46WAduY/xo/nXnBw/Az9SZhrWQNaJvNSh9eej
UoG/EOa+4Ez6Jc7qzf90pQF3s/gpfJL0T2NbdCe3fQHO4Mnr57KCEGKlmMMr
56/A+zUCuabJ+pcMLp+6dz8XuLyOW043ee4Eziw/GuMuAh4wr9AmRfpr0QPn
jAqgH+VIuOJFnt+p6J9udfeK4fdRlrQRniH78IJITEheCXD17StGfJMIkd54
Y3bMqBR4I+vthgmyP+TMbz8iEV8F96uMReRWC3l+F0XdOPgagXPHxy6zNSNE
4gmNLgUadJ1khuPJjQjhKF1GMy+mPG99f/hXHUJofOuZyTNpAr4zEDVmrkSI
57SaXqa8ZuD79mvQKeAIsaHhcaSRfhtw4ReW3L7hCFHMc8DN/UMX8OW86/uS
QxHiqFxSrNIv6Crrh28UB5PrX8Fygv7IT+C0lWLzLn+E2HiKVVmzEnpA4Y7p
Vi+EOJMuEn/Zvhu4dsZI3aAdQpSJdR1oyugBbs7UUU8j77utXW2+brv6gCuq
h7xRZUCIgyldCb5dQ8Ddrf7WZdEzEGe6kBGDO5PA9ZlSo49/oSMWfZ9HmK/M
Aq+fdUhRtVzFJcwrzcRHFoEXcPpJcxYu4c8nmgJpOX+Bfz3aUrS3cw7/JGNx
ROAuHfGfb+MeqfqbNoWjFTF1TQn0wE8/tq9KIkZxM5+aP6yFDMCPTl8WiAgc
xeNnpS2flEDPOZdPvLUYxf/ovjfrKIWucTz8j8qhUfyHUmqIfw10NZORHc6+
I3hoOzHb9QO6pDRPQoHJMB7J97LizRz0keFTtuFbB/HuIpe0B4IIcBcDQVnu
S724eVTwDmFL6P0/+2m3BXrxMpsuucBn0N/lOZulLvXgRAN963ob6BMnZJFT
0T34ielDsuX20GPNlHpY6Hpwszvb17G7Qf8SndfkYvgTXyhIynIPgn4ysjFq
aGc77nr7XKRGDvSbqs9X7pW14VMvEjZvyYPevM9jot+8Ddd8Mdb4PR+6/kD5
lm8Vrbi0GOMdgULoGrFdXUesWnCfedlI/1LoAwHsPyrrG/G/TI+YzRuhe0qY
bHyC1ODrJp9+7R+ELt5rel/RuBqPHTQ42jEEvfCrn/i2kipcwcolvWIY+jcx
Woj/q0r8+4O4quBR6K3HMiWUWcpxiXNDyozj0G83lV1wZCvBTbSVVYdmoOtq
x/dOmBbj5iW4oPssdK/qdwY61UW4MN05OtE56AlPmxJ2eBTijLTJfMN56G0R
OiN32Qn812roLbdF6JLCZ8JCBTJwg22lZ8ZXKOtm1Te50peOn4y9qnj2L3TF
p7UbNKPS8EN129V8KC6UWdsyty8FDz+ccffgKnTp3TvUHSqTcKbYh5b3Ka5w
snz95osJuNEZVpcYiue123NzXIrBX2z1TeJYgy5oNvrFrToKt35NK5GleN9+
5d7VS5H4b9/JH/coLi13Rdq0JgyfpmOfc6e47nXX74mhQfhUfiF7IsV3Vr2b
sA7zxZ3YGERKKW7odlJcLvwd7nT7+4VOirdGtwRvkHfDN71muzdG8RYOaUbX
s/a43c1a1wWK6x/c8IydzxR/JsWWsErxTNcnDXy5mmiPXWHtGsXNcoyVuEys
0B+/x2eXKf7Z2MjJPf0V2vrEh2+a4na9lXqvdDxRJ9VM+X6KLz2WNCi48gFt
nLliVk9xPqMyYUHtUNQyQuhbMMWd8xizBYUj0IX6OzPWFM/6lt74Je4jas6N
CWhS/Gt/75+i2Fj0SneP8wJlH/Nt3/7zvSEF9TdUuY1Q3MeOp/kIWxrqKMO/
J4dSP/K865d8FdLRT8sf2M0o3iq/+6pmVgaKyeU7l1DqM5vjhdabkBw0/rnK
kOQydAOhxKjGtEL0nEfGM5RS/7xVkpXqKkVoJhuXdRzlvHRwbFSp/l2EZrtW
JLNTfKfDmbb0fSWo8sWm3GrKebQoiWuW8/2Osk4l6G2Zgn79OXP0eatK9C1H
WXsy5bzTLqeymHBVoZxJlvI1I9BDH6g+dE6pQnUqrgwMUfrGG3PPrM/D1eit
FucGNkqfqU2JZ62Mr0W3pq7o7OqD/p1TInh6RwNau+R/UbcDer22UFP8XAsa
QlvMR79BH9H5+yH7QisaNFT3KKoY+r3BqGcFIa3onWhXr/VF0FUm3VWyFdrQ
BnXzLV9wyjorNfho+rSjfbzGB+oyoYv+ftW481gnmjWVu3s1Frp5u21v9LEe
9Hc4HZuoM6WvVhclu+kOoJGEjxT7MegMIpHBfonj6GQtHfuNq/Bey7a1GL4a
MoMG6JnbGe6F96/3jcKS1KkFtOr58ThJ+TWYS/WVOvr9VtDG5jdBxPwy8Hn/
pZ8HmekwxUNZTsIj88Ad1jO+SzWmx96/fq/Xnj8NfMrG5KrJUwZsuW84Jivz
D3BJ6f6JXFUEy91WsxiTAnPL0qYYd0UNBPOsl5kyc4N+0fPYozotBJORvdon
ehM6beYIc4MegjkPbu+I4IG+4X7qteCbCJawiPNcsv0F/BT7qSOXLBGs9eFF
1kKlXuAJY11OfAEIVibGpl9UCPMYm6s6zh6EYBG+KwJHn0DP+4YcpgtBsPNb
tKT990N3CRP/VBuOYBKpRyNU3sAcGL2pfUYiFsEqT927dkuzE3hy3a3of74i
WIOoiczpgXaYP0Nt7FRqEOzM+8db9yEwly6IiuvU1yKYMNOC1cfPMMdKDHbv
v1SPYGhfvsJODeiXg7WjxJsQzO972bPljzAPp3HbcGa0I1hzqeRJU4UGmOc5
N97x60MwJ9XquzLOtcCbw1nMsvoRbJj5c9x1Meg8dmE3GgcQbDRudGExuQbu
L5cc38IQghlLzFqrqVYDN7A2zJ77jWBR9Acu+XhVAH/GI3+ndhrBGJkZt/ix
fwOew28h5zmDYOeqq+q1DeAc0Z2Rw3JhFsF+/ypn35IM5w73P2Fan+cQ7IWX
UivtMpxTuli5fwssIljexp0Wo28J4E7MfLzppN/hMptZzMaB57+NPCKzhGCH
ixBVDt18OA+OvOeTWUaw+eU3X4T8coDzzvzqnF5BsEYOqYl5jgzgFVIN6mp/
ESz9rNv1ttR04K8LhVLjSHdpn7BNV4Vz3JnEmP2Kqwj2q9LWQccjGe5vachp
D9ILE7qentdPBC7uFiRTQ3pAKl1coz+cH+N/GU1Lr5F1znkutpETzpsuLKxx
5H2PrWpv2ndBLRJ+zuKT8//+rr3WcjUvyyMMuF9oQPW/v4PrsPN4nw8IBH6g
xFS6hvSzFT2yXFw+wH+wDXr1ka51v+J4h4cncKnFterpf/8HZ+eQOskF53Ht
3rTplX8/B1EMvcVlAeeO///PbmojVqjv+CH/P/8fu2W2ng==
            "]]},
          Annotation[#, "Charting`Private`Tag$77945#1"]& ]}, {}}, {{{}, {}, 
         TagBox[
          {RGBColor[1, 0, 0], Thickness[Large], Opacity[0.4], 
           Line3DBox[CompressedData["
1:eJxF1X0w1HkcB/DVuWXCeSruVEInjG5oz0pyviJzypWsu8ahyONhug1TLrY2
CZW20laXh6I85WHvZHCshy8rRGfX47YeFvvw23XcyWNUctfN5Pv94/vPaz7z
fXjPe+ZrGkynhW0gkUjuH9YnH9ZBo5N1xboK0LTkqDRojHem8mK9duxSgnf2
4popsgJMHgl3KucVgnW3FgVbNikIcMjEz2ZTbTXyKr8BWlcZAdiBau9JFc3I
Dwrr0rR8CbDmMK0mPd2OnHEx1LsiQQ5obfV6w7E9yDXfx5CiaTKQO0crSfIZ
RJ790+xYSqMEBIi9qDr7h4H9R2dv33228fU4GBvQOrP99Bia75wtTxnPHAFZ
976vbHCQICeO3aYxBoVA1KvnIZdKkceJigX2an3goklit/xLOXJ/47BtKuRO
sLH+vPGUFYH8Bv0UwapuBWlt+tc2JmN/Y+lIMclvANHs6T5hO/YWmqq6YOkp
iKqqLPddxG5oDtSTxTngwnc5eq80Fehdvry5N/aSDPio5astIm0FmueuLFes
mFXAMQlFZcNbvI+Bpp9H3RIXCjwTa8IE2JsK3Dh6L3mwxtCXzriJnfogZ56V
8Ry+YsuC6BTsnMEHO0Q2fNityS7UbsQ5/BI8t3A3fAA698ybLWfIkJcUCK4r
1IdgyKcU1vIunOfntnYr+x+L4cMzXmZv/SaQFxTtcznGnYDWGak0t65R5OnZ
RSv9SVKoRfzBtNUQIQ9pDK7h/yODfX6O2TNLfcjv2NRyAufk8HKukXmm8AVy
+DKtyjuAgHs8GcqbNrhvFlFe0dLfCHjlXwdgR8f97FKPDM8nCHjLleqhXMN9
Tk85zMsiK6DVauRDsn4Rzq2X5VKkq4CvdEstp42PIs9szZy4p6aAO10272fr
FsJ1L/zVgzMsJ6CnPYv/2LYG+UFTxt2EEgLmubpGtIw3I98ZG3pL78P9Ny7l
fRPwdTtypX+zQf0bOTz6Z3qOXcwL5E7KIf37YzI421u1NZjaj7zjC+FrDl0K
B/vjS6tdRch/tKkcyBVMQLPtHYHM+6NwvW+8KXXH6lQxLKyjHYiKmEDzlDYd
rXzHIchezFFp2iJFfqI2lXw4fwA6bW6NJl+SIVfzKUkqzuXDA2tH3PmVcuSP
lCCo5EwnvJzh0XjXlEBeeXJJPEJ5Bq9OSx+3JWIn+XQssnoboLluMV/Shp1h
kS4L2foU3j5aZ6a9jF3ovydKnX4ffnvHiO/+mQL5uVh4XV7GBvrmT5LPamNP
lsys+Ub/Dtzm4xqc3+F9uJEai54xXMAhperM9GJv6rajea3yQJifXk0MC7uP
6c+MK6XPAdPZ3SLXFnuJaX2nIKEXcMVUXoMbzmGy5VJeRLMQaGS5xoG/cJ57
AkqtQtNGwLn0yeMmLhLkU/O3Tu27MQ6q1wyyo0bHkL8GDbH1FRJwPn4lnhky
jM9NGvag7ZaBMutV/rPOQeSb/t7Ljg+Sgx8u9ORbLvQgZ2qd4B73JgA5WZ73
dBD3LYxSu7D3EQFUGZ2U2ZQW5FI1bcXMCAG2XWW6GB6qRb6NsTeKqqoADxK1
o2d8n+Cef/xfONKZ//+XpnX/D7IhNSU=
            "]]},
          Annotation[#, "Charting`Private`Tag$77972#1"]& ]}, {}}, 
       GraphicsComplex3DBox[CompressedData["
1:eJyFnX3MZGV5xmfnxdfaNjUgpFX56BYRDaGaLCBa8ZymNWCspkH9o7Q1Vrti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        "], 
        {Hue[0.6, 0.3, 0.85], Opacity[1], EdgeForm[Hue[0.6, 0.3, 0.75]], 
         EdgeForm[None], 
         TagBox[
          {RGBColor[0, 0, 1], Opacity[0.3], Polygon3DBox[CompressedData["
1:eJxNnQfcluPfh3ue7jsjSUsp7aVd2lq0995DU9pD0dIuSTvaGmaZ0TASoSRl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            "]]},
          Annotation[#, "Geometry"]& ]}], GraphicsComplex3DBox[CompressedData["
1:eJx1nXu8T2X2x+miDKNGqTRFEpKpMSllHO0uM92mYlIp/dJtRFcV+jUpCUUX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        "], 
        {Hue[0.6, 0.3, 0.85], Opacity[1], EdgeForm[Hue[0.6, 0.3, 0.75]], 
         EdgeForm[None], 
         TagBox[
          {RGBColor[1, 0, 0], Opacity[0.3], Polygon3DBox[CompressedData["
1:eJxNnHm8FWLb7/dea+29SUQpU0kpTUopJFFp0BwpQpMoKY1IVJJm0iiRpCRk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            "]]},
          Annotation[#, "Geometry"]& ]}]},
      Axes->True,
      DisplayFunction->Identity,
      FaceGridsStyle->Automatic,
      ImagePadding->Automatic,
      ImageSize->250,
      Method->{
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}},
      PlotRange->{{-2.9999995714285714`, 
       2.9999995714285714`}, {-2.9999995714285714`, 
       2.9999995714285714`}, {-1., 1.}},
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic, Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]},
    {"\<\"Fig. 1. A neighborhood of infinity in the complex plane and on the \
Riemann sphere.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->538588444,ExpressionUUID->"63a4e853-82ce-45e9-8cc5-a025d39595bb"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limits at Infinity", "Subsection",
 CellID->46703775,ExpressionUUID->"44f37a80-a3dd-43dc-bb13-ff7ad55cef77"],

Cell[TextData[{
 "The limit of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ad1e4b2e-3ca8-4b33-84ac-d4b6ae14dbd7"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6943203b-8789-4a20-80e0-0938eb077be7"],
 " is ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2b9d2d23-6679-4c8e-838b-3b276ecf7f4d"],
 ", which is defined as:"
}], "Text",
 CellID->545726767,ExpressionUUID->"1c3d8e4f-19b5-456a-af4d-3d6ac47df9f3"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"A", " ", "\[DoubleLongLeftRightArrow]", 
     RowBox[{
      UnderscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      RowBox[{"f", "(", 
       FractionBox["1", "z"], ")"}]}]}], "=", "A"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->704442279,ExpressionUUID->"85c33da5-668e-4c37-a01f-50dc98548fb5"],

Cell["\<\
Similarly, if a function tends to infinity, what that means is:\
\>", "Text",
 CellID->680725892,ExpressionUUID->"88446ccc-da5b-428a-9bc5-f7a3fff9d628"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"z", "->", 
      SubscriptBox["z", "0"]}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"\[Infinity]", " ", "\[DoubleLongLeftRightArrow]", 
     RowBox[{
      UnderscriptBox["lim", 
       RowBox[{"z", "->", 
        SubscriptBox["z", "0"]}]], 
      FractionBox["1", 
       RowBox[{"f", "(", "z", ")"}]]}]}], "=", "0"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->1480860,ExpressionUUID->"b4b2fede-114c-4b93-b7a4-6b3d480c805f"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"\[Infinity]", " ", "\[DoubleLongLeftRightArrow]", 
     RowBox[{
      UnderscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      FractionBox["1", 
       RowBox[{"f", "(", 
        RowBox[{"1", "/", "z"}], ")"}]]}]}], "=", "0"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->136603806,ExpressionUUID->"ef5021db-1c28-4357-9a37-437f18419865"],

Cell[TextData[{
 "In Wolfram Language, use the command ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 " and the syntax ",
 Cell[BoxData[
  RowBox[{"z", "\[Rule]", 
   ButtonBox["ComplexInfinity",
    BaseStyle->"CodeLink"]}]], "InlineCodeText",ExpressionUUID->
  "deb94583-efce-4b1c-9d30-5f67030b3515"],
 "."
}], "Text",
 CellID->262966955,ExpressionUUID->"55f846db-80ef-4be0-801f-2f1db2511fe3"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->625434282,ExpressionUUID->"65bb00f2-3ad3-4c2b-84d1-fb0ee2aa73d8"],

Cell[TextData[{
 "Show that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "\[Infinity]"}]], 
     SuperscriptBox["z", "n"]}], "=", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7774d1e6-e756-41d4-aedb-b8fce8140ad4"],
 " for positive ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "60e9476d-45b2-42e6-ae27-565f4257dcf4"],
 "."
}], "SolvedExampleNote",
 CellID->197411071,ExpressionUUID->"8c5ad8c2-7d67-4d22-9526-c4ece1c9129d"],

Cell[TextData[{
 "Consider ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    RowBox[{"|", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "/", "z"}], ")"}], "n"], "|"}]], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5f1577dd-29ee-460b-96fb-bb0fd28df683"],
 ". Since this tends to zero as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "034bac3d-0f4d-4c0d-bfab-3b737d8ebe30"],
 ", then the limit is proven. In Wolfram Language:"
}], "SolvedExampleNote",
 CellID->136374161,ExpressionUUID->"e44a38a4-66bf-43f7-88fe-e9825a8aaa1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"z", "^", "n"}], ",", 
   RowBox[{"z", "->", "ComplexInfinity"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->63628727,ExpressionUUID->"fc6d4f74-d266-495d-9c27-c3eb177b823c"],

Cell[BoxData["ComplexInfinity"], "SolvedExampleOutput",
 CellID->155226936,ExpressionUUID->"3e2934c6-f239-420b-b93e-26f22b39f0a7"]
}, Open  ]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s plot, for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "009e3970-35db-4640-8795-a847bf0b2b11"],
 ", both ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5398d0e9-d2b7-4f2b-a6f9-e0d5bc296a84"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"1", "/", "z"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"af9451ef-6593-4772-981c-1467a9247bad"],
 ":"
}], "SolvedExampleNote",
 CellID->160854157,ExpressionUUID->"4d92efa7-4e2a-4904-80ce-b49fcc505c24"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      SuperscriptBox["z", "2"], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      SuperscriptBox["z", 
       RowBox[{"-", "2"}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "SolvedExampleInput",
 CellID->46904305,ExpressionUUID->"6cdf062a-4e35-4997-9086-a5609db8eced"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJx1nA/QV2WVx18B9wWHxCRA0Y1/YmoaL4ILrNg50SQ55pBoaopmmPkv05Xp
H6ilG8ZuWu5sUiv+SSdUcgywyH8ZWEokiCAjKkH+QWN1XZWXUgOBbV7u5zC/
b/t1nLlzv9z3Ps895/O793mec54zZOolk8/t1tbW9mr3tra//d82v//RL+/c
2b6E46DbT1u7c+fI/NALe8089rR/KL3jzOcPOeyJjrx13rrh1y3oUfqRm+8/
7cqzR+SAaT9duqZn99J/9d+3PnLF5CPy++Onnzfw83uUvu3H066dfOmHs0/v
H+zzm8t2LkZ/c//RD7z3wKHZduuoyZOGvVf6DSe9OPHyEYfk5pFr/nP9mndL
7zxhxtjVqw7Olx697OkLvv2X0rv36vbdbTcPzzWn7jvgndGdpS/79ldi2+yD
ctbT5yzsufx/S//4I09/ZtVDw/LCbbePHnb4ptL/5ddDV07vPSw/NeSl+465
7oXST7p8yl1bZw3NM7434asL1q8p/bWtV788aeTQ/Pr53bfcMOPB0o/659lX
T99zaF6+Sw/Vp+y6T+h9mnZD2236GdrP5rlCn6uxQ6gdGruF2q2xc6idG7+E
+qXxY6gfG7+n+r3hJJWThqtUrhoOUzlszlO55Rx+uZ5zjld2rHj7rtEjimf0
k89buv2prYcXz+gbzrrni0+9fljxjH7ggKtG3rnXocUzep/rP3bWiSd/qHhG
v+/3b7y+6vdl59L7Pjprw/CLyi+lH/TNPh2fHlt+LP3VhhN4Rp86ZuPWg04Z
UjyjXz+6Y9qTdwwuntGndV5wwqRhg4vn6s9Lg/se98NBxTP63WdPnHRLDCqe
VYdnvQ88a7vwrP2EZ30ueFY7wLPaDZ7VzvCsfoFn9SM8q9/hWTmBZ+UKnpVD
eFZu4RlO5XdROvfnnOOhtyzpsX3JYcUz+r033Hnxe/ceUjyjb25+7/CM/srS
o8+dMXB48Yx+XdurW7Z+v+xcuvil9L8u6jVm+o7BxTP6FedsXbvljUHFM/ql
6x/sfsvYDxbP6CvWnvznzucOLJ7R/2Pysrs6nzqgeEZfPKnfkJuHHVA8o5+y
8ugzO5cPLJ5Vh2e9Dzxru/Cs/YRnfS54VjvAs9oNntXO8Kx+gWf1Izyr3+FZ
OYFn5QqelUN4Vm7hGR55/8MzuvyOSqc/nHMcf9331m77ycHFM/qMT0y9bdVv
Diqe0b/cfDfhGb3/u09O2XrVkOIZ/bLmfQXP6D3OeDG2vPCPxTP69Q0P8Ix+
9fJZT9904MDiGf2Pjw1duvnh/Ypn9Lkfmz198y8HFM/oqz+6sXNO+4DiGf3C
h3uN2Dy/f/GsOjzrfeBZ24Vn7Sc863PBs9oBntVu8Kx2hmf1CzyrH+FZ/Q7P
ygk8K1fwrBzCs3ILz3DHOAee0flewDO6/O5Kp/+cc3xg+1FfmvvC0OIZ/Z6v
vv2jSYcNKZ7R5zXfZXhGP/szMzo+efWBxTO6+LH03r+95KM37V1+L71tfMdF
x57Wv3hGn/JPj58x568fKJ7Rh9x7zD5zOvsWz+ifnv/vsz7x8b7FM/qmIxY+
euP/7Fs8qw7Peh941nbhWfsJz/pc8Kx2gGe1GzyrneFZ/QLP6kd4Vr/Ds3IC
z8oVPCuH8KzcwjN8MZ6v8VCjMy6CZ3S+L/CMLr/T0nneum9zjOcv/u6WTR8s
nov35n0Cz+gTJ773bzf12794Rj+/ee/BM3rnL9764Vu3ld9L/1PDFTyjTzjk
+EVvXvv+4hm9509+fcGbM/cpntEvnDDg0VH39Cme0f8rvjD+j9v3Lp5Vh2e9
Dzxru/Cs/YRnfS54VjvAs9oNntXO8Kx+gWf1Izyr3+FZOYFn5QqelUN4Vm7h
GY6Yt8IzOuN/eEZnHAXP6HyP6n3R6PK7Xlzv48Y+nHPkewrP6LMfPOXOOW39
i2f0+zu+8Km3buxbPKOL30v/UsMPPKMPG3P83A1v9i6e0X/2kSP33vDiXsUz
+l6Hrtgx8l97Fc/oYw/e/2vr1/QsnlWHZ70PPGu78Kz9hGd9LnhWO8Cz2g2e
1c7wrH6BZ/UjPKvf4Vk5gWflCp6VQ3hWbuEZXjpb3/OlM8+t8X2jM1+AZ3TG
XfX9aHS+X/CMLu+B0rEn5xwnNd9leEa/dPiPjrhxwz7FM/pfxu04fNSt7yue
0dd/+JvXfOfI4qT0Hwz++Xkjv9JePKMP2u/GVR3n7Vk8o8/Yd/QjM3v2KJ7R
5/W5alzHZ7sXz6rDs94HnrVdeNZ+wrM+FzyrHeBZ7QbPamd4Vr/As/oRntXv
8KycwLNyBc/KITwrt/AMF6xDwjM66znwjM68GJ7RmV/AMzrjNHhG53sHz+jy
3igd+3Ne/WzeV/CMPq55H8IzunBS+jO9Vy5cN69b8Yw+tceigevmtBXP6Fds
v7n/WdN3BDyjP/fOmPafH7A94Bn92UaHZ70PPGu78Kz9hGd9LnhWO8Cz2g2e
1c7wrH6BZ/UjPKvf4Vk5gWflCp6VQ3hWbuEZ/7PeDs/o/F7gGZ31H3hGv771
u1M68xF4RmdcB8/ofB/hGV3eM6XjL845ntBv0yf/cF+P4hl9dPv5t484fo/i
GR0O4Rn9jT/t+dzCne8GPKPf8YdxD54x4e3iGb3b2jU/XbDxz8Uz+h6NDs/o
c5v7wLO2C8/aT3jW54JntQM8q93gWe0Mz+oXeFY/wrP6HZ6VE3hWruBZOYRn
5Rae8TNxJXhGZ30entFZ54RndH6P8Fzj1mbeDc/ozF/gGZ1xIDyj8z2FZ3R5
L5WOfznneFTn6nfaH94GJ6ULV6U/9Hj7tacf3Fk8o79y5dfW9XzqjeIZ/eZp
dz907wdeL55r/bvR4Rl9U3MfeNZ24Vn7Cc/6XPCsdoBntRs8q53hWf0Cz+pH
eFa/w7NyAs/KFTwrh/Cs3MIz/iR+Cs/oxKHgGZ31/FpXbXTmC/CMzvpSzecb
nd87PKMPa/0Ols64EZ7R+f7CM7q8x0qHB85rHfqx2y6f/7u3imf0U89//qYp
p75aPKMvO3Hi5xas31g8o3/r2Bl5+qAXi2fV4VnvA8/aLjxrP+FZnwue1Q7w
rHaDZ7UzPKtf4Fn9CM/qd3hWTuBZuYJn5RCelVt4xm/kCcAz+rTWcXvpxK3g
GZ31f3hGZx0VntFZj4JndOb18IzO+wSe0RlnwjM632t4Rpf3XunwwzlHOITn
Gl9/bumeU457pnhGP/G4jyybv3J18aw6PKNvbO4Dz9ouPGs/4VmfC57VDvCs
doNntTM8q1/gWf0Iz+p3eFZO4Fm5gmflEJ6VW3jGP6+1zitLJ68AntGJz8Iz
OnEueEYnXgDP9Z5rvl/wjM76FTyjsw4Az+jMp+AZ/Y7W73LpjBPgGV3ek6XD
LeccZ557eL/2u5YVz+grLn131JnnPlQ8o69sdHhGv6a5Dzxru/Cs/YRnfS54
VjvAs9oNntXO8Kx+gWf1Izyr3+FZOYFn5QqelUN4Vm7hGT+Q9wXP6OTPwDM6
eQjwXN/b1nlu6cTF4Bmd+AI8o49tnaeUznoXPKPzPYVndOZl8IzO+Bae0Xkf
wjM671XsiA63nHM8+vSz317w2g3FM3o0Ojyjr2ruA8/aLjxrP+FZnwue1Q7w
rHaDZ7UzPKtf4Fn9CM/qd3hWTuBZuYJn5RCelVt4xt7KM7ryjK481zhReEZX
ntGVZ3TlGV15Rn9WeEbfQ3iu/CDhGV15Rlee0VcKz+ghPHOcIDyjK8/aLjxr
P+FZnwue1Q7wrHaDZ7UzPKtf4Fn9CM/qd3hWTuBZuYJn5RCelVt4xq463kDX
8Qa6jjfQdbyBruONmg/JeANdxxvoOt5A1/EGuqwDlL5JxhvoOt5A3yjjDfRr
ZLyBvkrGG6pzXuscMt7QduFZ+wnP+lzwrHaAZ7UbPKud4Vn9As/qR3hWv8Oz
cgLPyhU8K4fwrNzKfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDM
fDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDMfDDM
fDDMfDDMfDDMfDB0PoidzHpdmPW6MOt1YdbrwqzXhVmvC7NeF2a9Lsx6XZj1
ujDrdWHW68Ks14VZrwuzXhdmvU6/C6HtynpdmPW6MOt1YdbrwqzXhVmvC7Ne
F2a9Lsx6XZj1ujDrdWHW60LX67CHiaeEiaeEiaeEiaeEiaeEiaeEiaeEiaeE
iaeEiaeEiaeEiaeEiaeEiaeEiaeEiaeEiafodyS0nxJPCRNPCRNPCRNPCRNP
CRNPCRNPCRNPCRNPCRNPCRNPCY2n8Nwm3h0m3h0m3h0m3h0m3h0m3h0m3h0m
3h0m3h0m3h0m3h0m3h0m3h0m3h0m3h0m3q2/o9B2Jd6t353Q55J4d5h4d5h4
d5h4d5h4d5h4d5h4d5h4d5h4d5h4d2i8m+cz+Uhh8pHC5COFyUcKk48UJh8p
TD5SmHykMPlIYfKRwuQjhclHCpOPFCYfKUw+Uph8pDD5SGHykcLkI+l3KtQO
ko8UJh8pTD5SmHykMPlIYfKRwuQjhclHCpOPFJqPxHOYfNEw+aJh8kXD5IuG
yRcNky8aJl80TL5omHzRMPmiYfJFw+SLhskXDZMvGiZfNEy+aJh8Uf3dhfZT
8kXD5Ivqdy3UbpIvGiZfNEy+aJh80TD5omHyRcPki4bJFw3NF6W/Jp8/TD5/
mHz+MPn8YfL5w+Tzh8nnD5PPHyafP0w+f5h8/jD5/GHy+cPk84fJ5w+Tzx8m
nz9MPn+YfP4w+fxh8vn1OxhqZ8nnD5PPHyafP0w+f5h8/jD5/GHy+UPz+emX
2W8VZr9VmP1WYfZbhdlvFWa/VZj9VmH2W4XZbxVmv1WY/VZh9luF2W8VZr9V
mP1WYfZbhdlvFWa/lf5OQ59L9luF2W8VZr+VfjdD/SL7rcLstwqz3yrMfqsw
+63C7LcK3W9F+2Y/bJr9sGn2w6bZD5tmP2ya/bBp9sOm2Q+bZj9smv2wafbD
ptkPm2Y/bJr9sGn2w6bZD5tmP2ya/bBp9sOm2Q+bZj9smv2wafbDptkPm2Y/
bJr9sGn2w6bZD5tmP2zqfljaMfUK0tQrSFOvIE29gjT1CtLUK0hTryBNvYI0
9QrS1CtIU68gTb2CNPUK0tQrSFOvIE29gjT1CtLUK0hTr0B/16F2kHoFaeoV
pKlXkKZeQZp6BWnqFaSpV5CmXkGaegWp9Qq4n6knk6aeTJp6MmnqyaSpJ5Om
nkyaejJp6smkqSeTpp5MmnoyaerJpKknk6aeTJp6MmnqyaSpJ5OmnkyaejJp
6smkqSeTpp5MmnoyaerJpKkno9/xVE6knkyaejJp6smk1pPh70y9rzT1vtLU
+0pT7ytNva809b7S1PtKU+8rTb2vNPW+0tT7SlPvK029rzT1vtLU+0pT7ytN
va809b7S1PtKU+9L3wOhdpN6X2nqfaWp95Wm3leael/63U/lSup9pan3lVrv
i3839RjT1GNMU48xTT3GNPUY09RjTFOPMU09xjT1GNPUY0xTjzFNPcY09RjT
1GNMU48xTT3Guo/UY0xTjzFNPcY09RjT1GNMU48xTT3GNPUY09RjTFOPMU09
Rh0npHIo9RiL24u67NO+hON+XfkAuzlHnzPqinnPnDMyv9Hll8cXo1/WtW75
t/FV13/fGt96n8E5Y9f1odc352naTdfu9K7jusVPduWnLQ/aRd+Vn/lYcD3H
Y7r0RUF/3H1ar59b16NHcx/6h85zcV907g//6LvykR6pftA+/ed3wfXLu+5z
d/WD6+knvxf+fUVzPde1HgePa9oN7SfPy/XZ3J/rtZ/4Ue2AfbgeHmqds9F3
7YO4v+xA+/Sn1j+b63flk8+sfnM9fql10eb6Cc31nHM9z1Xrpc2/z2r6w3Wt
1y8qO2g/sYM+L3bgeuxT+yUa/aSGB5639f67/U77tMvzcv1q8TvX46/Km2yu
P7lpV34Xf/dc2n/6yfW78uh+V/1RXd4zad4zad4zad4zad4zad4z1S7nvG9o
l37SL+0P+je6TfrOa/2GVn9a69wOqf7o9dJu3V/suRi70S688N4QO9f19Kd1
n9FuntHhrfrH+7LpJ/elX9of9OXCW+u+j5nFG3+nvHE9nMONtouftJ8Vb2ra
x/70Hztp/9H1Pdmazz+z+om+Wvqp9684gvSHftb3pOk//cFO2Ie/b8273u1H
vZ529f7C89/9vsqu/z/PaXhOsX/q7/d9vS659v2z25dwnP3ExTu+PrX0NDrX
p7m+dOzJ360bc86F4xfuvp5/F73sgM45f2euX2KuV32JuU9qu/8HRfD1RQ==

      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJy1vWdUlee6773H+46xEpNY05OJNTGmiCJVxYqCvQFib7HX2HvBEkuw994r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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnHf8T9Ufxz+fz61fe+8pWSmSskqEjMrMLJKykpVsoRSRkYjsEkJJNqVB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             "]]}, 
           Annotation[#, 
            "Charting`Private`Tag$1373733#1"]& ]]}, {}, {}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0rlOFFAUgOErI4s6i4CC4oCxRXgBlR6xswLtLHAGgRGVWcAVzFBQkai8
gL6AMI2IJBg6TZShYE3ccGlQX0D4DMWX/xTnFvfmnrmWuTx4IIQwxfdICP/n
L1rktLmDqxSYpkSZvyQst3OJNBMsOfdC3+tbXdHPuktzRQjn6SHHU2b4yG9i
ds9ykRI/uc431kiRpo8b9DPAIBluMsQtbnOHdYbZIMsmOfIUGGGUu9zjPg94
yCPGGOcVv3jMNlv00kkrUXbc4QMveUKWbs6R5J83WLX3Scu6qO/0uRZJ0UUb
cf5442VmeUaeK1xg0rkftJi/6gLN5iSnaOIkJ2ikgeMco546annj3FGd14S+
1rjGiHKEwxyihmqqqOQg1oOrhbnI/v/ZA1fxRcY=
          "]]}}}, VertexNormals -> CompressedData["
1:eJx1XAlUjl3X7jWFMhQylbFQyKwQRxElyRgps1RUMoQ3CZlFFEoKDRQyZXqR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       "], VertexTextureCoordinates -> CompressedData["
1:eJx120Go5lUZgPFLMXFt5V1EMiVUQhBIzULdiImBI0WbDCRoESNIYAtT3F0V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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 17.999997517241464`}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXu0n9OZxzNxCy2mamQV0zYjHVOiFcK4PxsRVNFhipEyqq3ruI8EsVxD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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzVvWeUldW2rrvbva0tFRdJl661dBYi5kSqSM45hyKjRMkoOUnOSM4ZQZRU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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxVnHn811P2x9+fbWxj+CmypZKyDNKKkvZNu0qIFoVIKbJEpaIoJdsMYxkZ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             "]], 
            Polygon3DBox[CompressedData["
1:eJwlkztMk2EUhr/27xlY2R1chBUGghdcFXAyJEwszKYMxsTBSW6mxsYavFBA
ARslNlpBhSqBYKzxgi0gtahEg4o6sLK4+bw5w5s8X8/5z3fe850e7O07nYyH
EFpRAqUshGwshCK6DD9HSQJ1JL2AH6J2+CR6BO+gY+S2oR/wN3Q05r99h6uo
HIVwmPMn+AHqiHuNPPwW/SV+lvg7+D46n/CcGfix+V0n0Cz8FLUQb+T8DF5C
e3xbRsvwOLpLvBlNwAPoJ/W7OQ/CQ+Z8gfxhc0/yphqLcAn9Iz/D+bVqyR/5
neTk4Cn543yK8zT8AaXJ/4zK8AI6kPCZFeEr5rOsobS5B3k5R3wOfmLO8iRv
oyhPrSbOWXjF3FsBvYRH0D58iPh1+J55b5qZZvcFHVHv1PgKXzW/+wzxDPwH
dcFV4l3wmPldmplmdwcVIvc4ae5RXjUDzeK2+WyVo9xddDzmNX+bz1Sz1Q5d
gtdQjliF/HXzHdAulDjX4FX1HPkMNUt5krd67rwBV8xnqxqq9ct813Sn7pYn
edNMrsEfUSrynds09yivPcQvwhvmvShHuepBvWhmW/Ab87fXTmo3tZPaTfX4
Hp433z29sd5aParXBs434Vfmb6Ud0i71m9+tHdQu6k30NvqPbMO3zL/Vm+vt
/wP8CYi5
             "]]}, Annotation[#, "Charting`Private`Tag$1373833#1"]& ]]}, {}, {
        
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNmXeUltURxvfbvS/YKIqAYI6K5ZyIgCYxsaSYHtMTPRbAoGCLJZKIEUv+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            "]], 
           Polygon3DBox[CompressedData["
1:eJwlkscuhGEUhj9mzsZu9trodaIEI0i0sNBHsNCHaAmityghYkEigsTWxkLC
veAS3IIL8Lw5izd53jn/nO+0eHoztZEZQkigKCq2EBaAv0gItXARmsT/4mvg
fDSK/8aPwPtoFR9DaTgbTWSEcE98AN5Di8QMzcGF6IT4FIrD8+Yx5VCubvTG
fx/wpfAm+sQnKLIaXkHv+Bi+Er5Az1H/phc+R0/4D3yPeQ7lesXXw7noCn+H
b4Nz0CX+Ft+i2tABvhltwP3mMfXUBw+b954ingdvmffyw2/bcAm6JxZBdXDK
PKaZaXZJ89pUs2o/1gzhJFqHB9FXxGtUrWfoBo6iGfgUXcMvfNMBz5rHNGPN
ugqVM5sm/BHcYM56Q281mr+lHtXruPmudulhDJ42r103oFs4NN9tFjnL4C7z
WapH9Vpg/t9HzUhsfiva8Y7eNp+ldqLddJrXrp7U25L5LrXzZd2a+e3p5nR7
7ea51bN6XzW/Bd3AmvkOtAvNbEi9m9eqGVTArea71o6163/eakns
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0rVRBEAABdDF7Q53HVKkASTHAyIkI8DhcHdtAGkAGsCGGBpAGoAGkAaA
d0PwZv/O7Mxfqx2K9U4nhBAOyUwJIZ7fkkO4SwqhRm5lkFXOueWVb3IsbqST
MY655JF3fqlKDKGZfpY55ZpnPonqqaedDr0RexiR04075qPyGONMMMkU08SY
YZY55llgkSWWWWGVNdbZYJMtttlhlz326dIZ1X0gZxh3zYflNuqI8GHfT1xx
whJ9NFHJj3O/8cAFR4zSQQPZfLm/F244Y4UBWrjXkaW7Wv7R30OVXEkF5ZRR
SgnFFFFIAfnkkRt/I7KJEiEr/s5kkE4aqagLaoLq4AihO/n/P/wBAAU0DA==

          "]], 
         Line3DBox[CompressedData["
1:eJwl0VVSAlAAAMDnB7dQARu7xcLuxrGwMTDB7jyt13Bn+NgTbDxbSOdLQgg5
/iIhxKlkk3se2KKVKrZpo5pd2qlhjGc6qGWcEzrJccoEDZzxywXnTNNEgV5u
mOKHJB9M8k0Ped7p5po3urjilUYuqSfBMXW8cESWJw454JF99vhilB1G+GSY
DENsUEELa6yTYoFSmpljnj5m6KeMAWYZpJxFloiyzAox0qxyx22k+PIP/vck
3w==
          "]], 
         Line3DBox[CompressedData["
1:eJwl0cVRA0AAAMDjkUJoiaGCfPKDHtDgTrDg7k5wd3d3qYOdyWMr2MxoblZO
RgghRmEkhALyySObP3754ZsvPvngnTdeeeGZJx554J47brnhmisuueCcM045
4ZgjDjlgnz122WGbLTbZYJ01VllhmSUWSbHAPHPMMsM0U0wywThjjDLCMEMM
MkA/ffTSQzdddNJBO0naaKWFZppI0EgD9dRRSw3VVFFJBeWUUUoJcYopiqRf
/gFmV0v7
          "]]}}}, VertexNormals -> CompressedData["
1:eJztfHlYj13XdsYyzzKT+zZkCCHJsCSVIUNmMiYzIVMi8xAZIpFKkSg0kMpY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       "], VertexTextureCoordinates -> CompressedData["
1:eJyN233MnlV9wHFkInVv0MECK7ghZC5op80C7IXVJ4iU4FQmOIbZMi2DIDLn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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 1.1417520615771846`}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->69689897,ExpressionUUID->"d2806fc3-0842-4e2b-a0bf-2edc37ebb1a7"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"ff3df421-aa33-4d7c-b5d2-2af7d0abf606"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->216457562,ExpressionUUID->"9f31602f-77cf-4e5a-9b1e-5944ba09fb8d"],

Cell[TextData[{
 "Does ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", "z"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3d85c0dc-8aa9-46b9-9d55-151189860b0a"],
 " tend to a limit for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"784cb548-5c2e-4325-ac33-7cd41febc159"],
 "?"
}], "SolvedExampleNote",
 CellID->60636581,ExpressionUUID->"64d4fd41-608c-402e-a08a-d6efb00ee10d"],

Cell[TextData[{
 "No, because ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "/", "z"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f3703b0b-4e0f-4802-ba46-0d538ecc192b"],
 " does not have a limit for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4ad91138-fe7f-41a6-b831-205eb10cfe2e"],
 ". This can be seen, for example, by approaching the origin along the \
imaginary axis, considering ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"t", "->", "0"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", "t"}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cda5a66d-0062-47f9-aa47-a1f7b0524609"],
 ". The limit can\[CloseCurlyQuote]t be defined because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "t"}], ")"}]}]], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "/", "t"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"c80a1676-7a47-40af-9efe-7b857694a2de"],
 " keeps oscillating around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9fa6a359-8569-4e79-b8e9-197e900db4fa"],
 "."
}], "SolvedExampleNote",
 CellID->444522959,ExpressionUUID->"8d9b3fda-93a2-47e4-a5f9-719b5f327d3f"],

Cell["In Wolfram Language:", "SolvedExampleNote",
 CellID->218240690,ExpressionUUID->"dcdbca65-f51d-4b80-9cd6-388de4e462c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], "/.", 
    RowBox[{"z", "->", 
     RowBox[{"1", "/", "w"}]}]}], ",", 
   RowBox[{"w", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->403902981,ExpressionUUID->"2c0ca048-b149-465b-8d63-b63544077c93"],

Cell[BoxData["Indeterminate"], "SolvedExampleOutput",
 CellID->11923725,ExpressionUUID->"ff787230-b546-4517-b861-79c25676e418"]
}, Open  ]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s plot both ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"15b2dae5-d65c-4ea4-8853-1827e1ca82e4"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"1", "/", "z"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dacbfc61-a2f5-4d41-a6d9-24f640638fe3"],
 ":"
}], "SolvedExampleNote",
 CellID->418902190,ExpressionUUID->"55cca177-2a43-444c-9131-2ab3505fa52e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{"Exp", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"1", "/", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "SolvedExampleInput",
 CellID->212908760,ExpressionUUID->"87ac0e35-8fe6-4473-8892-ff7499d8e9a1"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJx1nH3InmUZh1+dORWnpulATFtjFiGkcybRx30pUqBSZIqOzNQonduUJkjZ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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztyP9PFAQcxnFWW1qWkWu13J3RnDWbGWl8EYkiRu3KUR5+SW2aEJCFUFxJ
zExXsYqtsA1X9pW1cFnmbLpcuVwoqSjHcdyhphFGGGIkWmb2W7T1T7y39/Z6
Pnuez00l1eHyS1JSUiJjR094eW1+Tc3yuuLU0TG/KrKioqrs8VDVs2UVZTXZ
JZeOPtf/n/961ndfCSS79UuR7PlcILP2tggku61ZJN+/K5CsfU0Cydz/pkAy
DrwukJntLwvkjoNrBHL7oVqRdDwjkIyOSoHkRJ8QSF60VCD3RpcKpDC6SCCh
znkCmdNZJJCizpBA5nYWCKQ4liuQBbFMgTwSmy6QxV1TBPJo10SBlHRNEEhl
/BqBPBdPFciL3VcL5NXu8QJpTIjk7cRVAvkwcaVANiXHCeSL5BUC2ZG8XCC7
hLKnZ6xA2nvGCCTWc5lAkskxAjkSHyeQY9HxAuk9mCqQE/snCKS/7VqBnGy9
TiCnvr1eIKe/uUEgv++cKJCR7QGBnNsWFMj5LZMEcmHzjQK52JImkH+aJwvk
4ns3C+TvDVMFcmH9NIH81TBdIOfr0wXy59oZAvmj7k6BnItkCuTsyiyBjJTP
EsiZx3IEMrxotkB+C+cK5PQDeQIZKrxHIKcKCgUymB8SSV6RQH7NDQvkZM4C
kWQtFshAxjKB/DKjVCD96RUC+fm2pwRy4tZqgfTdEhHIT5NrBdKbtlogP05a
J5DjwXqB/BBsEMjRYKNADgebBJIMbBRIIvCRQOKBTwQSC2wWSDSwVSCHAtsF
ciDwtUD2BXYLpC24VyCtwXaB7E7rEMiuKTGB7JwaF8iOaQmBbEs/LJAtM48K
5NPM4wJpye4VSPPsPoG8f1e/QN65e0AgTfmDAmksGBJIQ+GwQOrvPyOQlx4c
Ecjah0SyplgkqxeK5PklIlm1VCSREpE8XXZWICtXiOTJSpGUV4ukNCKSZatE
sqROJAtfEMn8dSMieWVYIPNeGxJI8RuDAgm/NSCQuRv6BfLwxj6BFH3QK5A5
Hx8TSGjTEYHc91mPQAq2dgvkX6YU2k4=
             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnHf8j9X7x9/3fbf33koobaRERBSSZCRRiIRkFtIgIskomRmVpkppT1Ha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             "]]}, 
           Annotation[#, 
            "Charting`Private`Tag$1374274#1"]& ]]}, {}, {}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0kkyHUAYB/COKaZHxDyXLXIBYW/YWRl2FngSc/KMMSYoZVrgxbDkAoYL
cAHDBeQCwgXwe2Xxq+9f1V319dfdNT3D7UMfQgh/OEgOIZH31BWq5Sa6mSLO
Jfc8k2vzF9qIssop1/zjlcqkEL7SyQR7nHPLfyL61NHCOkf0EWebfqIM8I3v
DDLEMCOMMsY4P/hJjAkmmWKaGWb5xRzzLLDIEstscMxv/rJDL83Uks2jc99w
xi4xOmigghdzP3DFCSv000o9OTy5vzsu2GeSLhpZ0+OQqsSaukWlXEE5ZZRS
QjFFFFJAPp/J41PijcghQjZZZJJBOh9JI5UUtApGCJvJ7//hDeewN+o=
          "]]}}}, VertexNormals -> CompressedData["
1:eJzdnAlYTekfx0PLIBIp0SKhtO/7fU/7IirLJI02SZFk+WMsWTJjbYwGDf8h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       "], VertexTextureCoordinates -> CompressedData["
1:eJx120uo52Mcx/ET0diZhWhQLmU1MQtmozFRRmSDkrIQJcUCk90MNZmwmcLi
LBiDlH9Z6LiUOSPJPaOUSGIwLmPchkRZWAzq93qm3vWzeXqf/seZnnfP7fP9
/s++5c5rbz1uaWlp9/FLS/+P//23ccv9t1xi3HvdN/fsWzy9Ga85572Dq4sX
Bm947MwHl7ftG3z+SfuWVxdvDL7s8kM/Lda+O/j6HSdvWt62f/Dtr1388M5D
Hw5+fftLd68uPhr8/rorH1858PHgj/d+9fZi7aeDv7z+nt/2bPls8OG/Tjpt
edvng/949MlLd60cGPzPhovu2Hnoq8H333br/k27Dg5+aOOGm1YX3wzedcI/
f1745reDH/3knYdWDnw3ePmZh89c//f3g3dvvfHFxdofBj916XlXnLv+8OBn
T/7jiz1bfhz83Nev3rXu5p8Grzz/wAnL234e/PK91zy2dvmXwfuuPuOCXSu/
Hpuv0w+/teaDI4Pf/vmFG3Ye+m3w/tXtR44e/X3znNeO/GJ+Mb+YX8wv5hfz
i/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8wv5hfzi/nF/I75mvxifjG/c+u0
Xjvyi/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8wv
5nfM1+QX84v5ndt3u07rtSO/mF/ML+YX84v5xfxifjG/mF/ML+YX84v5xfxi
fjG/mF/ML+YX84v5xfyO+Zr8Yn4xv3PnaPfdrtN67cgv5hfzi/nF/GJ+Mb+Y
X8wv5hfzi/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+x3xNfjG/mN+5e1HP0e67Xaf1
2pFfzC/mF/OL+cX8Yn4xv5hfzC/mF/OL+cX8Yn4xv5hfzC/mF/OL+R3zNfnF
/GJ+5+65vRf1HO2+23Varx35xfxifjG/mF/ML+YX84v5xfxifjG/mF/ML+YX
84v5xfxifjG/Y74mv5hfzO/cu6X33N6Leo523+06rdeO/GJ+Mb+YX8wv5hfz
i/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb9jvia/mF/M79w7tO+W3nN7L+o52n23
67ReO/KL+cX8Yn4xv5hfzC/mF/OL+cX8Yn4xv5hfzC/mF/OL+R3zNPnF/GJ+
53KFvkP7buk9t/einqPdd7tO67Ujv5hfzC/mF/OL+cX8Yn4xv5hfzC/mF/OL
+cX8Yn4xv2O+Jr+YX8zvXE7UXKHv0L5bes/tvajnaPfdrtN67cgv5hfzi/nF
/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+Y3zFfk1/ML+Z3LvdrTtRcoe/Qvlt6z+29
qOdo992u03rtyC/mF/OL+cX8Yn4xv5hfzC/mF/OL+cX8Yn4xv2O+Jr+YX8zv
XI7b3K85UXOFvkP7buk9t/einqPdd7tO67Ujv5hfzC/mF/OL+cX8Yn4xv5hf
zC/mF/OL+R3zNfnF/GJ+53L55rjN/ZoTNVfoO7Tvlt5zey/qOdp9t+u0Xjvy
i/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb9jvia/mF/M71ydpbl8c9zmfs2Jmiv0
Hdp3S++5vRf1HO2+23Varx35xfxifjG/mF/ML+YX84v5xfxifjG/Y74mv5hf
zO9c3ax1lubyzXGb+zUnaq7Qd2jfLb3n9l7Uc7T7btdpvXbkF/OL+cX8Yn4x
v5hfzC/mF/OL+R3zNfnF/GJ+5+qgrZu1ztJcvjluc7/mRM0V+g7tu6X33N6L
eo523+06rdeO/GJ+Mb+YX8wv5hfzi/nF/GJ+x3xNfjG/mN+5unbroK2btc7S
XL45bnO/5kTNFfoO7bul99zei3qOdt/tOq3XjvxifjG/mF/ML+YX84v5xfyO
+Zr8Yn4xv3N9Cq1rtw7aulnrLM3lm+M292tO1Fyh79C+W3rP7b2o52j33a7T
eu3IL+YX84v5xfxifjG/mN8xX5NfzC/md67vpH0KrWu3Dtq6WesszeWb4zb3
a07UXKHv0L5bes/tvajnaPfdrtN67cgv5hfzi/nF/GJ+Mb9jvia/mF/M71wf
UftO2qfQunbroK2btc7SXL45bnO/5kTNFfoO7bul99zei3qOdt/tOq3Xjvxi
fjG/mF/ML+Z3zNfkF/OL+Z3rC2sfUftO2qfQunbroK2btc7SXL45bnO/5kTN
FfoO7bul99zei3qOdt/tOq3XjvxifjG/mF/M75ivyS/mF/M71+fXvrD2EbXv
pH0KrWu3Dtq6WesszeWb4zb3a07UXKHv0L5bes/tvajnaPfdrtN67cgv5hfz
i/kd8zX5xfxifuf6Ntvn176w9hG176R9Cq1rtw7aulnrLM3lm+M292tO1Fyh
79C+W3rP7b2o52j33a7Teu3IL+YX8zvma/KL+cX8zvXhtm+zfX7tC2sfUftO
2qfQunbroK2btc7SXL45bnO/5kTNFfoO7bul99zei3qOdt/tOq3Xjvxifsd8
TX4xv5jfub7q9uG2b7N9fu0Lax9R+07ap9C6duugrZu1ztJcvjluc7/mRM0V
+g7tu6X33N6Leo523+06rdeO/I75mvxifjG/c33y7atuH277Ntvn176w9hG1
76R9Cq1rtw7aulnrLM3lm+M292tO1Fyh79C+W3rP7b2o52j33a7Teu3IL+YX
8zv3vYf2ybevun247dtsn1/7wtpH1L6T9im0rt06aOtmrbM0l2+O29yvOVFz
hb5D+27pPbf3op6j3Xe7Tuu14+jPmXj058x8j6Xfe2iffPuq24fbvs32+bUv
rH1E7Ttpn0Lr2q2Dtm7WOktz+ea4zf2aEzVX6Du075bec3sv6jnafbfrtF47
8jv3vaR+j6Xfe2iffPuq24fbvs32+bUvrH1E7Ttpn0Lr2q2Dtm7WOktz+ea4
zf2aEzVX6Du075bec3sv6jnafbfrtF47nvXKKU+8unhkjHzjK6499dw3tx77
3Nzv+Zzfx3Nj/z/9vf47+u/2uYP33nfktcWOMa458ao1N6/O/7yjv9PP9ef9
+/07XSf9ef+uz/0Ls+Vl+w==
       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 20.085532767559766`}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXd4jcnbxyNRg9W71XvvZUPu0YJV1yKrrF5X73XV4Kd3Vrd6WUQnwkH0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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzVnHmQVdW5xVPvVTkPqImaeC+jIAgICN3NaCQOiSOCOBMVHigqQQVUBgFB
RFFQQBAZBBERkURDHNAoqCAgCM3ULREE5xG0G1DA/97a4/n2eM7tBqtS9b1X
Z9h7n8P9Za1v7dN5r06P27vc9D+/+c1v+h+G/9Wl+z0d+/XrPujyGji5om//
W27u26vnBX0H9Lq5V7/WPf4XF8fL/2HHX3e4jFRnWe1RXVRdLqsdqquqK1i1
veIrVlequuqrNrqultX6GlXXsiph9WXJdaq6fVms669JFV1P6oakWom6UdcX
BdaXRvHV6Pr0ufR99EvihdXLi3+L/Hfpf6b+h+ufAj9L8hOxH03+esmPeXny
Iyc/e+cEh8HIy6uLzaudh9dXQV4BWJJXFFaMlBdT96RaBoqOCYFLp2Yj+0og
a52GzOT1lZdXO5dXlwPMq4riKhwWIWVjCgGKVxBcNZEVKrGDzatrNl7ZYJVE
YEVIeTH1yFxBcCnULGQlBSJL4dX1IPPymWEGcfnaVjqshFQVGWVgZ1PLiIw0
snSJpVnir8GrquKKwyqI1Jmo/8tcVaOWgqwqEjuAvNpn4FWQGVYdFnU/C1N2
RoHyglMOWQ1kVbNEH6/2B05fcTMMOqFuWzFYPlnF1dTTqBakrFspivMKLYrM
aGQhiXksMROvA+iHfl4FiisTrBApHx1ZvUg5d/3svEJLRVaoxH4tXk6Yz2aG
jrgMJwzDsmTlJeWn0+tzp76wywLnpaaFFkBWHEJmSiy9hbmR/lfnZZuhJS7L
CS1YrqxMUg6mBE3zm2LlwUfBeftaIjQfMssVlcQilnhgeHUqkJcTDqsgriyw
DFkFMMUZRdnZ4AxqBSErSGKhiJiRV6eDzMsrLuKE6bC0+0Uw3WxUM1LWrRg4
yyHjyBxXDEnsgPM6y8urc4xXJGz4k0ZEXCq6G7A8svKRcug06x0ol6CXmiM0
A5kK+VGJhVNHPHK4vHzfe8+qPi9v8/KaYdgJY7CUrIKYQozS2FngbKFFkAVc
McUSrRZ2QHh5t8xWns/OS5mhV1y2E/phcVK9fKQIgjNuyVouOIMaEZoXmd8V
qcQilpjGK/j3lMscXo7ECublNC/bDD1OmA0WkZVFysZxa7RC4DQ1S2hpyMIS
sy2RtrBq8WKwvvFaYtV4tTZ4xczQdUIaMGxYJqkzeluMPmtq1W2kjFsOuwA1
D7KQK8YtUfwaB4gXh+Xn1aFqvK7x8ErMMIu4QrBcTXnp8GpCyr2bgPNpLYIs
IjEZFKklBiJHdl6+5nUAeKU0r1RxZYalft7PXFJN+mQtS3ceahmRpUgs2sKq
y+ublBZ2wHmZ4pJOmAVWBNPfWDUOlLgbAJdoLR2ZV2IHg5eneX1DeaW2sIJ4
uc0rVVwhWF73o5gSLn2jRdlZ1G51qHmRZZFYoIVl5ZXevArnZX4/jPNKF1fi
hGmwTFIWo9P7fsrq9kCxATY7h1oUmeWKcYll4+X5Pp+VV8ASq8krbIaGuJQT
yn1WAFaT21xSNqNGd/jLYuehFkdmuqIlsaAlVoNXzAwvzSAxu4VF82GIlzZD
V1zaCUOwqPsJNXkZ3cmqISlxxcdOKY44ZASZcEVHYoYlZuHV1ssrrXkZsH4F
XknzMvdcVFzceYyAYcJSslKYbk8YJYD6BYriE7MUNUtoFFkSP9i7ORLTezEn
1R90XpcWaIkickR4hcIGMcMkFlJxRWARWYnfnDI6TVT/T5z6lBW/S9kRrRGh
BZB5JBaxRCsi+nnFwkbQDC+1eXkkdsB5mWboiisAS7YqixRl1GBArCg7D7U4
MktijiUeVF4ecXkl5rVE1R/tSJ/Ky9u8HHHxb00+WFpWCSnOiGCqf1esEnYC
nKImHJJ6o4FMfbNyJRZsYXFeNMyrHzNmhiFYBUssGy8jbNhmGBSXSoMWLC8p
SeTuT06NFgYY4CxqLjKWGKMSo5ZoRo4svKosrj9e4kgsnDqCvK4qkJc0Q1Nc
txji0rAaUVjE+gxM92yvJ2qgU+w6BhjglEkyh9TIGpnIEondYkrMssSMvEJh
PpY0PLBcXhYyvyWSFubhda2P140mL2KGSlzECc2epWHZpBSjuqIGBYrf5ewk
OELNQKZ7WRMTmZaYxxJJ5DB4XRviZTQvjxlGxeVFlsUSkxZmRY5CeLni0k5o
wlKy4p5mkOJE6qAGs6qNGkJqsLxeR7EzqN3FFhRCI8h4YtSuaEusYF522KDN
K2aGQVgxiWW3xCy8SNhoYfPyOaEJS8kqISUwcUbbULXu9ZfBjlIjQrOQua5I
ebVwIkcmXoWYYURcfol18knMsMQMvLp5eKmw4TFDJS6SBpUNSljK/SQpgqnm
UF7DnOLXKThJjTkkE5pCJo2xkUZmSsywRB05XF7OfjnCi5phPBYmpC52kGWW
WLiFhXn18PBKYqEjLg3rVA3LJJUwGv4xq/ucGr6NlWJHqXGhEW8UyDwSU0HR
5dUjyCvWvAoUlwHL5VUFiRXEy9O8qBkSWP14bqfKUrASUprRCF4jnRLX2RgF
jlGzkeERrJeJkG9KzGuJuoVl5KWbV3XFFUcWCIpSYlZKpJZI/p6SkRczQyou
0rYILCKr4QrTyK017+c1amte1AO8+DEu8ruKnaCmhGYgI41MS4wFxUJ5kTBv
miFJhsFYmAGWF5nXFcOpw7BE1cJSeSXNS4urLxGXdEIDFpcVtz5FSgIavYXV
g06N3sqK40uoKaEZyLQraolRS0xaWAZetHlpMwwkjQKc8OJvzr4oBRl1RZ/E
/JZII2I6L22GjrhEGrRhMVlpUgrTQ1vyYz5i9TCpMVtYPaTAaWpCaBYy3sg8
ElMtLAuvJGxEzDAkrgywWMVcMV1iAUu0I73+vmHxMsKG4EXFdQ9PgxYsIStB
SmACmkc+yo8V9Z/8OJQ+5bceVuA4NSk0C1niikxieA2Ll4ochJf+vmGG+aAZ
ZhFXwAnP1ryqicwrMaeFJbx6WLxk8xJ7ZBoLtRPKnqVhjdoqNSVICUCP8nqM
13he4lhcF/gEtQeZQ9YclSAT8UO7IgmKau+sWxjl1cPh5TavqLiqCOuiKrki
CYqWxKglkhZGvm+4vGgy5GZIxUVh5UcJWQlNKVLjN+cnbM5P5PX4h7w2sxJX
JnB8gprQmhCaiYxKzLBE0cIcXvr7hqd5UTM0xZXEwio4IerCzMgySMxMHZ4W
lnzfCPOSZqg6F3dCETAgCgILsnp0syQFQJM+zE/+MP9EeS4pnPKLkzg7DGPU
lNA4MqYyET+GKomJbC8sMcJLft/wNK9Y0vCLqxBYF1YbmQ6KlsSclEgjB/bL
fl6qeQkzTMQlAoaExWX1mCI1uZxhmlKee7IsN7UsN43UVFxktzg4QY2b5DiB
jBsjix+JxBJL1C3M5WWFjXAyFOIy9lzVh5UVmdHItCuq4OHtYr4WFuXV8E5i
hlRcI3nAeJDAmgjhcFJPcjTTN+VmbMo9tSk3kxROZ+AWBjBwjBq0NpEgQy97
gLtiIjFiiam8nObl71xWzAi0rSywOl7gQWbHj0D2iLkiTR1OC0u+R4FXby8v
ZoZ1Bm2rNUSJizkhj+tjE1i5KVxQDNPG3KyNuac35mZvyD2zITeH1zM45Rdn
YUAZAwe5TdHIuDGO0a7IJTaEfVqsF+LF98vJ916zeZV0c5JGxAldWJeGAwaB
JSoVWSguWq6YLrEkckhezRxeDQQvaYZEXA/xgCFgTRayUqSAac763Nz1uefW
5+at47WeFU7n4hYHJ6gxoXFvFMge4a6oJKYtsT7/NmXxaqZ4qbBhm6EjLjNm
hGGdlRXWtxpZx4g3OshkXPQ0shSJMUu0IgffL/M8T3ip5sXM8D60GO2EaEBc
WU9yA5ypSD23Lvd8ae6F0tyC0tzf1/IqZYXTF3ALAwQ1TMFEjmwS72XKFVkX
u49ZouR1t8lL7Zdp2GDNK1VcobYVgeWSSmB92/EvBJlPaCFjtJFRV7SDB5GY
SolJC1PfoxJePGwgycvmNYJn+IeEEyKocxtksOB4kA8ntWBt7h9rci+tyf3z
g9zCD3L/4rUQp7iIWxjAqUFrzyhkMMbHhStyiQlLFC1MRQ7NS3+PSpqXSoZ+
cdGYoZzQC8u2waAHKli6MiIj8SOYPbQriv8jPkdi1BJl5DD1xXnxbxrDhBmi
0ShxTeY2KGBBVvM5KWD61+rcq6tyr63KvU7qNVzELQzAMAzmQhPIpnFXFBIb
IyyRtbCEV3+Hl2WGrrj4Bw3hhHbbsgKhd1Mc9MAE0598yDqmhcZUZI4rUomR
lGi0sCRvJLxY8+JJ4xElricR+eBsEAu8bm3uRUXq9ZW5N1fmFq/ILVmRe5vX
EpziIm4JahiMKZjIjXEGd8XHVRcbzXkNT3jpvEGaFzHDmLhU28oCKxAFbQ9U
sP70Z1aZhBZC1slB5mtkci9GJGZYIo8c/HsUz4cJL9W8xmK3K8SF5LAh9yxX
FmC9vCq3CFAA6L380mX595blVyzNr0ThAKe4iFuc2iIMxhRMxHQsoiQ2nlsi
a2EJr/qcl/ge1aQPaV7aDLW41AeNYNvy2qA3XYRl1VGRSqogoVUNmUdipiXy
74ciz3NeH0teD3EznIimA13A0BD/4G8cFmS1GFCW5le8m1/1ds0PltRes6TO
Wla11+AUF3ELAzAMgzkyGOM87oqQ2BQeFMexFsYih+Z116eCV+O+phna4uJO
WB1YhciK1fnp1CyheZGd5UWmd2SmKyYS66ElxixRtrB+Ms8n+mK8uBlORevh
TrhgTW4hJAPTey+/DFBA5616pf9usO71husXNdyAwgFOcRG3MADDMBhTMBHT
sQiWwoLcEiUvPI7lDZ7n2fdD2byouGjnMp2Q7rYsWJ5NMYUV7VYGnfNJketE
hk50DAmNIOtgIdPZQyMje7FEYqKF9RURke2Xed5QvB5FAudm+DQX14toSStz
b4HCO/nVi+uufeO09a+dvvHlpmULm5X/s9mHKBzgFBdxCwMwDIMxBRO5K87D
UtwSJ2FxxWsY53WPCofaDLW4yJ7LgEUyhpUGNayYrHQIDBmgwnTO+RmoFSI0
YyvtQ8YamemKicR4ShQtDJGD7b8sXtPhY8gMyOrv595Ynl/6bn41FLSo0Qag
eanF5gUtP5pftOX54q0oHOAUF3ELAzAMgzEFEz9gEnsBS2FBm1edwTJsMDPk
yVCLizohy4RxWOF0kS6rgKYA65zzZBVMzRGap52FkelGJoMHlZiyxLqD+P5r
pOI1mTevZ7ERXp17ZUVuMUIFhAMWkBLQPFfy8TNtt89q9+nM9p+hcIBTXMQt
DMAwDMYUTMR0LIKlsCCWFbx4PhzKvh9qM1Ti+kKLK2lbqbAsDwzKKhup8/xV
NWoRbxT7eh7yeS8zswfJiqbEhCUO5N+jRiC88f41CT8v+g7cDG1oef5dxInX
T1sPFi+02jKnzfanOnw+5eyvHv/TNxPO+RaFA5ziIm5hAIZhMKZgIqZjEd7C
ZnB9oX89yPbLte5lzQtm2OhOQ1xGJiQZg8HS0Z18bop5YDVJncvLuhgwyYzU
vN6YILvSQUZcEUFRSOy0fsISWURk++Wx3A8Fr5fgacvyy2FxrzTZtKDVR9DR
1D9+CUZjzt856i8VIy9khQOc4iJuYQCGYTCmYCKmYxEsVcZ5YXG+Xx4uzJD9
JUWK6xbthKptUVhXGrD8HlgQqYD1GaSsyiK3VGpJRzOFRrfSxBgpMuGKootB
Ykj1NYeis3yUfxjBG+1mfe7ZNbmXsJ9amn//jQbrX2r+4dzW20Bk3Lnfj7yg
YliXiiFXVQy6lhUOcIqLuIUBGIbBmIKJmL6G8XoWC2JZLM6b11CW5Jm4WOdS
TmjBStKg3BRTD3S7VYSUndLjglJ17jmsCgDnmmQqNSW09lpoal/mQdZLuWJf
3sXu3l4bEruPW+J4xO8NuTlrGa+3EB7QkqAatKrHzvluxEUVg6+uGNC9ou/N
lbfdygoHOMVF3MIADMNgTMFETMciWAoLYlluhvfhQXgcHir3XM16s7blgaUb
lg7tRFaZSHmDX5qaBCmrUsDFTDIbtURozBvlVponRgcZTAk5DemaSSw/ilvi
Extzs7HhhUDeyX/wauNN80q2oknB+sDl9psqe91Z2W1g5ZX3ssIBTnERtzAA
wzAYUzAR07EIlsKC3AxHMXEhxiMWwgldWEiDiO5yU2zLKgOpsPXZvpeK6U+8
srDLCC4ztURozBvlvowiQyOTrjgIzQURbnN+wqbcU+tyL6zKvQ6ZoB8923ob
OtSwzhV39qy88a7KK0bt7DLxy07TPkHhAKe4iFsYgGEYjCmYiOlYBEthQZ4M
h7NYKJwQbYvCkvss5YFaVhlI+QSVDZMXByf1neRFywUXZWeDc+UWp0aExrxR
hHwTGbI9+zY1Elooz01BDkcgX5pfAbEg+z1y3g50q5vuqOz64PcXP721wyvr
Wi5egcIBTnERtzAAwzAYUzAR07EIlsKCWBaLswxvweLRnXmgIas0UlRQSYfy
mp71kwYZ6fqOVUde4thl5+Cz2WUEp+VGM6SmJuxRdjQmtKLr2Z81z2Txgxkj
R4awjRSHdgNdwM2W5955veF6pAiEwAE3VlwzpPKSmR+3Wry09fIZrVY9gGIH
i5fiIm5hAIZhMKZgIqZjESyFBbGshMVs8Gb255JW3bkHXke6FTdAm5T+VCu/
+xWOKQWQYkRInedUCsGIZ7rsDKs0wHmodVHUeEdjIYQJDYn6s6a3sl7GkW3J
j96cf3xD7pnVudeW1F7zQtGWseft6NejsuvoHW1fW1u8cuxfSrteva4pCgc4
xUXcwgAMw2BMwURMxyJYSsJiPetWFt2lrFS3kqRcTXkxmaYXYpSuoCid885W
5b2bSjADPsrO7nEOON7XuEMKaryjMaH1RsZmvaz2EPzOH+Ynr8vNW5F7G/3o
ibO/uuuGiq6PfNv6nVcuKL38+bIjP1txAgoHOMVF3MIADMNgTMFETMcizAYb
DGDRHR54Zk/RrRQp3ae8mNzeZDHKBCgDHRdTaqVDDBJ08VHP1KJLrFKD03Lj
DlncjX1pxO7sjFthXNvrDcR2Cfvcdbn5aEbzi7cOv6ziivt/aLPsuXs21Nj3
RCPx/3sBBzjFRdzCAAzDYEzBREzHIlgKC7IdFiPVjblf26u0oBJMZ1NMmpHl
dSFALp04mlQcf3QqO0ofTT9Ht/1R9WnpCcNMRKcUxwMJ62s3QAifgVrDfrCy
/+THrc/NXZpfOav9p3+7pbJoydvQ1Jb8mIvmbEHhAKe4iFsYgGEYjCmYyDZZ
IAVNFd3Avle0uYoFP6kmIqWOF0odaRHZCvKgyWxoWcqhc36G8jDNDtelSVG6
SjyPClCqD7+eYscaHHyy6AYoCH1nW+0hm/MTV+UWIftdO7jy8nXtZ3T4fFLH
r1E4wCku4hYGYBgGYwomMkzwPbSnhNHFiYIMf3NVY0I5AAIphMX5Z1WjMj4i
Qj+K+NyOBlZNExw5RPaHgHZdEeSAYHvdgZAPQiA0tab8UBQOcIqLuMUYlVzH
vK5DJ4GGc1FEDBCpP36hv/CB/c1J/fng1F/CdQGr70VdKKrD9xepurjD95fw
urTDjk4ddnTusKNL+x1d2++8sv3Oa9r98Nd2P/ZoW3Fr610Din+6v8X+p+p/
s+SkWzcchxC4uO5aFA5wiou4hQEYhsGYgomYjkWwFFuwM1scj5DPupi8AF5G
vBV/Q/G2sX/OQfoBQ4wibxL4qXV9T+tC8uPT318guNgAIVmgLlNELudQrmi/
8yrO5TqO5sa2P/5fm4qb21T2ab2rX/HuQa2AYO/4Jr/Mrlf5r9z2VcfN2HRU
qzV9B15X8eimY+7beCwKBzjFRdzCAAzDYEzBREzHIlgKC2JZLI5H4EGM41Xs
0Qzl5YrmZfINxdsmWC824Uq+HZJ/PvlNrJ+rsJ86xCiCwAahWFg4XCIKisGF
otF0oJqrE0A/3ND2x+6SEXRR2bdkV3+Gac99Z/48ptm+Saf/8kzd3S/WhHzK
Nx02adPR2G11eKUUmvppQc02y+ahcIBTXMQtDMAwDMYUTMR0LIKlGLj+xVgc
j5DsurfFoxN8V/MX0wQpRIvjpeSf7KWZAO1g/JLO7xyBG8YREIgFJYDm+04+
Oko7CSD8h/nqdpJRt3Y/XN+W6ahH2x97Kkx/K9l1Z/Huu4v2DGn10whGau/E
xvtn1N/7fO2Kl3NfvXvihxsPf67syGvWNWz+wZCLntky/pzvsKWCglA4wCku
4hYGYBgGYwomYjpbZGJjLIhlsTgegQfhcRJczzbsNaC769uyF5PsuPo0Pq1B
l2AcohelK08vUKqUgtBE6AhAroIsRtcqKVFMN7WpuKV15W2tK28vYb53d9Hu
IVxTo5vvfbQptlS/PF3v5/m18Jt//faJW0qPfqv88Ps3Htu59JxWq0af+/dN
fXtXQlNr2H8TeyEOcIqLuIUBGIbBmIKJmI5FsBQWxLJYnGlNUINP3l6CF8Br
4GUMcFx0eG2LnUd9nclPESFYAESFMjudjIAII0NHXkzS9Nr+2IsLCqT6KFJ3
FTH3G9YSSmGyGt9k35MNYWX4ndGJvn3r5E/eP25d+SHzy468Y8Nxl5ZecObq
4UWL3738sa+w2xrWhf2lEgc4xUXcwgAMw2BMwURMxyIMGbzxyYZYnAnt/hZ4
HB6KR0tqfTg1yK1XG/aS3dkL+8G5uqPSy44vlWBGQKmMQlKyMHVTvUkICu2J
kurL3G/XgKLdA1vtubcl/jP/0wPNf37kjL0TGu+betovs+vufb7Wrn/md7zx
+y+W/e6jdUe/V37YzE1HIQReVnremWtub/3e7DaL1nSa9knXh79D4QCnuIhb
GIBhGIwpmIjpWARLYUEsi8XxCDwIj8ND8Wi8AF6DOWTfhFpFL97ghNxEj+sW
BGeLLiO7VHwRQBFGISk5mHZSTNe39ZO6jfepO3iiuJvLamhLtJWfRitYUBa8
a17tPf+o+eOrpyA2fLryeDSjxeWHIfv13XBc13XtOq69oeXqEW2WzSlesqTo
36tROMApLuIWBmAYBmMKJmI6FsFSWBDLssWhMoFsdHPW0YZyocEe+xfjxfB6
0iFdatcn4HZGwHlFl8rOxZeFUVhKBibZm1jGswUlSHWXpJj7oU/1bs0SRZ8S
ZoBMVsW77ynaPZh74MgWP2tYUxrun3nq/rl1flpQq3Jhbscbf0Bm2La6RlnZ
oehHkMzADTWuWdf4ktJL2q29qcXqoSUrx7dePh2FA5ziIm5hAIZhMKZgIqZj
ESyFBbEsFscj8CCBDI/GCzBvHNwKr4QXY0Jj9sjTSG/e1zS17jY1KTeRLa9S
v0wInCu6ODuLUURKcUxUUGFNyUTRO5FV5R2sW+1CtxrIowWHJZWFnjW50f4Z
DX6ZUweJDlH8x1dO+e7Nk+FmH685dlP5IRDLnLIjH9h47A3rj79iXeuLSjud
vfbG4jV9mq3ph8IBTnERtzAAwzAYUzAR07EIlsKCWBaL4xF4EB7HeplQmUCG
EDKwaJfoaFRovdvINBLQGqPmyi0LOEd0lF0BmCKCipMSiaKnMkApK96tuAdy
WK32UFgPn7H30SbYJe2fetr+WfX2z6398wusc/3w2infLj758/d+ix8cMnm3
/LAFZUdO3HT03RtqdFufv2JdSafSP19Y2vnPpVeicIBTXMQtDMAwDMYUTMR0
LIKlsCCWxeJ4BHvQ1NPwUDwaL6CRsbSPdnaX8kbR0YTQhD32VGkkTi0ut2zg
PJg6Z8OUkRQ1QNKtpAf25zlwYCuprBE8YCANjmuKzRFzwhn1mbjQuf5eE4lu
56I/oO8IXtj/rig/9OWyI2ZtOmrMxmP6MWQnwveuXFeMboXCAU5xEbcwAMMw
GFMwUfDCUlgQy2JxPIJLrD5zxYmN8QIsMT7Ae5lUGc+N/ZU30o5m2mMmalnA
dfaB61y4oGKkLAN0ZOWFNVgFjFEtfn6omXRCiGsaxHXq/mfr7J1fa8+LNbFp
2vG65LXtgxofbjhiTTlrYVDNNI5s0IYaCIHXrz++2/rfo3CA00EcFgZgGAZj
CiZiuuCFBbEsFscj8CD2uGlcYtwV8TJ4JRk/BgeQuUKj9nh9u+pSo3KLYiqA
VEhWPZWsfLBkz+KwWHS/XzuhFlcDFrafY2a4+8W85vXFst9uX3Xcf9YdtbH8
EOTz18oOx8YK2e+xTcegSQ3beOzgjTVQOMApLuIWBmAYBmMKJmI6FtG8sDge
gQfhcayLCYlhHy1cEfuy+zSyol0RZLSjuUIriFoInFdQcVI6+1kGSGH1NDxQ
NiwLlkiD2GcNP5O1LTghxDW2qRDXvqkN9z/FzBB5GxFu90uSF5rOl0t/98n7
x29Ze0z5psPXlrMuBhYLyo54puwo6GjypqMn8sIBTnERtzAAw9YyMzwcEzEd
i2ApyeulPB6xT1jiU/XxaCmxsU2ZxB7gjWw435eJxGghE+2MemPPBBnbYlv2
aGRIP7WdIWoFktppkfLISnlgKizss4a0lG0LTvggEdcTjYQZ/vKswWsneL11
MqL4ZytOgKdBKQgPH5QfurT8sDfKDl9YdgTQzCs7ci4vHOAUF3ELAzAMgzEF
EzEdi2CpnRYvbYlPNNISw4tJV2TZg+/L0pAZ3mgJjVDbWQVqBZFyDdDrgb2S
0G7AuqOYRfcBRWxTLDKGcMJEXGfsfazJvsdPZ2Y4vQG2sax5UV6L/oAQ/vXb
J6L7fPL+cVvXHLN5w5HI5+hKy8sPfbv8sH+XHb6o7PBXeeEAp7i4nP/5EsMw
GFMwEdOxCJbCgpoXHoTHsYdOZ5aI18DL4JUSiQlXFNkDW+kBLOTjH2Uj602R
Od4YsseM1FxSWQyQyiorLL7PGsC/YAxUTjjsTENc45QZPsmbl+D1vOSFIIf4
/f2/f4++AzeDRravqgFzAwUIZ335IVDQyvJD0aSW8sIBTnERtzAAwzAYUzAR
07EIlsKCWFbyel7xQgt7UloiC4qGxJQrDiziyPh/Au8oyYgsJLSYPZrUUkkl
sgp5YASWCBh9+abYdkJHXI9wM5zQGJtW2bxmE329WLNyYe7HV09Bx/nurZO/
fudEBIZPVx6/bXWNrWuP+c/6oz7cyD5cIE6sKz+ktPxQFA42clK4hQEYhsGY
gomYjkWwFBbEslg80RceKloY9s4TuCU+YkuM7cgsVxT7Mh0/QsjC3pgiNE3N
MkDxmcLbrdzELkhZsG52YOm2pZ2QikvEwjHSDFnzmtyIbZMVL7QVhLc9/6i5
a2H+x1eYJTKJLT4JDeiL9xgyhD3sp7aUHg0omzccATq6cIqLuIUBGMZgvfdb
TMR0LIKlsCCWxeIsHxJebOM8mbcwYYnYi/GgaEpMuaJuZBaymx1ktje2M7zR
7mjtEigaWeGyygqrj4Il2xbfbemYMVTFwlHNpRkiGbLmxcOGl9c/8xWwRCGx
N0+GoQlk8De0JGgHUCAi0NGFU1zELQzAMAlryUmYjkWwFBbEsn5eTzTCy7D/
CI3VlqiC4tAkeLAdmXRFhaxPZmRVEFpIVlWD1bu1/IJB25Z2QkNcas8lzFA3
L4QNzevpeiwfYv81v9ZPf6+JXRKzxFdOgS52vPF7GJpEtux3ny8/4dMVxyOl
Q0TbV9fYxgsHOMVF3MIADJOw4IRvCHEJM8xjcTyC7b9E/0p4kRYmLFHsxfDy
VGLKFWkjU58ZDwgyIjRLVla0qAIsnTG0E+qYQTvXcGKGonl5ec1hvPY+Xwv9
RUsMTUe4okCGZoT8gK6E1PfZ8hPEfxlb1vITcBG3MADDBCzphERcPGxwXnMC
vEQL05Y43OhiSfCgrtiH/RRVQeaGECq0iAcWDstxQp4JQ+JiZqialwgblNeM
+vtnMV7759beKyxRSowF+x8EMqjszZOx7f3mbUYN8gEXzo6VOMZFRurtkzAM
g7/nymJO+HIOS2FBLIvFWdiYy/fLs+qxR1NeInKIFoYXHhmWmM6KlitWB5nl
jdWAlXzBoIGwj5kJzc7l8OLNy8+rAdsvP1NXtLC985XEXmKuqJHB2YTQGLUl
JzFwrE7kxU5xkZHistphwMphKSmu+ap54XHYL+PRPl5JC6O8rC5Gs6JwRR0X
6dePKiOLwLregdXdgRVxQhEzEnH5zPABPy+2/5reYP/MU3+ZXVe0MGyOoALe
xZgrYtOE3xye9sOiP+x8XVF7k3H5lhROmaYEKQQMYYOAxZ2QxXghrudry+Y1
uy772+h0vv/y8nrAZ4liL5ZILOqKFrLuDjInNBrICobFvw1GnNARl9xzaTO0
eTUzefH9F3hNa6Bb2P65UmLKFTkyrjJkBux5dwpqAhxnx+oNhgkXcYvJ6rVT
MFgqi8OSTijENbdO0rymcV6TeT40eDWzeWlLFHsxj8TCrkg/WGVHVigsu235
nJCKS+y5LDMM8xL7L/Y9appoYcwS2We953gXE64okDFjVEIDtVcZuB9eY2h0
4ZRdfFWR+hfrWZgoYGEpLMg6lxCXNMP67PvhlIZy/xXhZVmi3ou5EnNcMWlk
BSJL71k32rBcJwyKyzRD9sFQN68RLWxe4xSvSafvm8JbmLBEITHtigrZnhdr
7n4pL4QmqFW8wsCxepUXP8ZFRYrLCj2LwuJOyDqXEBc3Q9a8pjRi36MEr3Eu
L9LCvJaYKjHqiuSzcGovywqLti2/E1Jx6Q8axAx189Jhw+WFzekEzuuJxBKZ
xNDFeFCkyNB6kBZ2K2q7Fkpwdi1kXzAEKSarf7CeZcDisZB1LohLm+ETnNcE
vl92eenIkbQwYol0L+aRGHFFX/ZIQebCcj/k+ttWQFy3E3FpMxTNS3zWGHZm
Ci9EDmGJIiUKiQlXBLJ5EhmLHwuYUjQ1Cc4scV2Q4rJiPUvCEhmeO6EUl0iG
U0TzSuWlPnSoFmZYorEXMyVmuaJuZO5nYRdZHFZWJ3TERc1QNy/1GcrPa2zT
vY82SSxRS0x0sdlAxlxRq2yvRMaoCa2xepGzU7XnRXmda4rLigcMrSye4fk3
KNm5iLhk8+Lfo7y8hhNeuoURS0yXmNcV48gcWHbG8DthBl4DHF73ennJ71Hs
L8uPkhamJTZdu6JsZAKZEJqgRsHZpTAlpOYRWHMULDxiOhFXwqvpz2Pl96gk
z1Ne9zq8BmTgRSXmuqKdPQiyv/oCYcQJveLym6EZNkK8RmteliVqiQlXTBoZ
N0YWP/bx0CipKXCemi9J7eWkOCy2SNK2sDgegVgoxIVHUzMce4bkNTrKayDh
5bXEgMRSXJHGxQgs1wkziMtIhgOKdpOwEeIlvx/qFkYtUUuMuaJGxnsZFZrQ
mgDHqhap2hJTQkrJCosIZUlYXnGR5iW+H8Z46Q8dZkosSGJeV7SQpTphSFxu
0rgjEDZcXiLPj+K8VAuTliglRrqYcEX0F4HsaYmMCY1TS8Bxdkk9RzAJUhrW
0xqWckLVudg2WYhLmKFuXqP59yid5728zMhhWiJLHexzR0xiaa5owbKcMIu4
DF7FnrBh8RL5UOyXR6nIYVmikJgIigYy1cuATAlNao2bpORilLwrRgpZSVhP
cWVRWCIWCnFZZijCxqgWcr+s86HLy4gcUUuMSMzvij5YWcSVboYRXi0lr5Ga
F7FEIjHiigrZNIUM2ZtSU+CE6JKaQzBRUjMVrGkK1pRGiRMqcSXJUIcN/n1e
8WoZ5EVbWMgSM0vMRpZdXB4zrBKv4YqXbmHCErXERBfTrmggU95IqQlwSCOz
60o0EpCoemIMIcU9EEuZsKQT6s4lxKXNUDWv5HtUlXjZlliQxAoTV9wMC+CV
RA7dwoQlUolpV5yUGOM+jSyhJsExdrMkGlmz6onrbMDM+gkpDmsftcFJpxtO
qMWlzVA3Lx02svGyW1jIEjNKzA8rKi7LDLPzGmLykpGDpPoxCtm4MDJEOCo0
0dQEOMmO4xOAZqrrM1SrMmQVhjVOwRJmOLo5aV4mryGF8ApZYlxiJrKIuLKa
YXZeRkR0LPEhHRQJMtHIDGQmNQ1OsjNrOsFESU1pZMPSbUs4YdK5HDMk4bAA
XtktMSyxmLjiZmg1r0y8SESkLcwnMZbtRSNjyITKHKFxauy/rDj1tISdW/wu
+68USlKGrFjPYrCEskTbCosraV6aV6tMvKwWlsUSfRIrWFwGrxKTV3Gc1+4h
Tgsb0UKnRENiupFpZOMtoSlqFJyuqQ0lHV0akyA1+XRDVuMTWHstWFpcMhk6
zSudV7HJq8TgVaDEsorL27worzsivIrCvAyJZUWmqQmtaXCaHS19a7LSlJDV
xMaFwbLM0MOrKMgrEjksXlkkFk8ajhkWzMvbwrgl+iRmumKCTMUPLzWtOH+R
YRYpEjAkLINX84C4As2rUF4hS4ykjoC4HF6t/WEjlVewhUUkFkWmhcapJX1N
1CSn9K3H5Xg5V5DKCCsgLrd5pfPyRg5r4xyRWCov1wyz80ptYVRiYi/muiKN
HxY1E5zER4peTzBZpGjA8DihjoVKXNHmxb73Fsor3sKy8OqV1ryy8BpQ5Ikc
hiX6JOYiSxIjEZpFbTzPkBMaB4oM06S0rMYSWbmwYuJqKf5FTtjIxivewkKW
mMkMC+fV3+IVtkSvK4aQUWoSnEJg4bMAPaZChdJUQioEy+uEITM0wkaR/AUK
4uVtYV5kB4xXicnLHzmkJboSS1zRQWZ5o0VNK07gs6tpoiYvKe2BQVg+cblm
aIUNuv86yLwq7OaVgRfdL0damJ0SaVDkEvMgc4RGqLG+RsFFaizvUy4pJask
YFBYhhM6Zjgo2ry8++U4L9XCgqk+VVxmOCyUl9cSPRLLiMyipsFJdpIgKXXx
ERMTJZURVkRc1AwL5WVFxFSJHXBeocgRSh3EFT3IVPzwU6PgKDurHnYwuaTc
gKFhUScMJY1Q2Pgv4uXdhVGJ+VwxiEwIzaJGwVnsvIzGkImc1M+jqawisEwn
NMTl23n9t/DSEdHbwmyJma4YQka90aJGwVnsvIwkJoeU9sBUWDoWOuIKNK+D
wEvAivO6JcrLjfSuJcYlZjYyPzKTmg3OxWcAMjFZpCKwXCeMicvDq9L6e4qX
V2QLJnkRZFRcNBym8urj8gpYoiuxjMhGtIhRU+AkO4nPrNGEEcXkJ5UZVkRc
lhnaf//KyiuJiD3DvHpVg1eohdkSC7ui1xgtoWlqo8wfn7Czyxo2yiRFZOW3
wZATqlhoiyvUvKrAy2uJKc2rQF4hSwxJLILMS80DjrNz8RmAmieDLUwuqVRY
fnGlNa9UXnQLFmlh1eRFIkfSwhxL9Esshsz1RmKPlJrNzlfW4JGGAXo8MBWW
JS6/GarmZYSN6vFKDxvhfEh5eVtYXGJ2Iwsjs6mZ4Fx23hrpwWSTCsGy2lYW
cXmbV4hX7yy8OLJUXjTPW39PcSOi1xK9XczKil5kljcqajFw8XIxGaSIB7qw
BvtgeTtXxAxFOPT+PUX3r4PEK9DC4hLLhGxIS4/QfNRMcCZEgoYWnWuTsmWV
DVaquALN61fjVRVLdF0x0MhkL7OQeamZ4BKCGqLvroHJJWXBGhxrW7YTVtkM
q8Cr54HjRS3RlpgTPCxkhtDUT+eh5oAL47MBWZhcUnSfNZi8mIblxgyPuEJm
WFVePTPwcr9HeXh5WliqxDIjS6UWABcqiilAyvbAFFhp4go1rwivmw4ar0Il
FnJFjczxRik0LzUPuwxlTTdIEVlZadCEleaE6eI6yLzIFiwUOTJKLDsyIjQP
NRecCzEy4F4fKb+sMsDKKq5A2PBuvg4or5glZpJYANk9AWQJtVY2tVR2XkaW
+7mystKgF1ZGcaWa4UHiFWlhqRLzIrsrhCxMLelrPsVlqSES0x4LU0RWFqy7
wrBSxRVpXtXhFfnEoXlFLNGQmOmK3uyhkUW80aJmKE6xS6lWHjVZpEIeaMBy
2hZxwrC4HDOM8+rl5/X/Egt0Bw==
             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnXn81cP3x++973uzZQ8RrWijsiQJUQiVop1KixAlS9lpU8hSti9fKRUR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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkkkvnWEUxx/ue2xIGiyx6FfgE0i6sTJsTNUi5uEaWlMNpcR0gwRJy9Uu
EG64dha67NZSF20XVnwDYdfG79/zLn55/+d9zvOc8WX7UF0yN4RQDhFsWwip
RAjTOSHUoKegkoM09jA6AxWxj3w34JLzB+x59DgUYX+CRfRH6EJ/5nwOPQHF
2IUE7UMfQylUwQwMwg2+P/DpRI+av603Uuhd5UQu1/zLzwuhAfsRO4Pdj96B
W3zvoRvdAwecPcEyelYxOLuCd+Z3dFc5N6M/QHXkb7ab16zav8PbOEflWgKH
sGZe2yZ31tFv4D36N/+G0EvmZ3+wa9Er8BX7L3Y9eksxI89xE72vevQWdKBH
zGP/glbzO7qrO23o11AWeQ+PoNfcVzWoFsVUbOWk3DQTzUYz0CwUQ7HUc/U+
Cy+YTQHfC/hmrtUz9W5VM0Nn8R9DJ+FnwnfiVL2AO87/qSZ0i/ms5CPfRsiP
vAfqxYD5W6pBtXSZ755mqFlqRprVK75ncc9L4hynzWMolnZ0Er1n3nv1MI1u
Mt815azctRPaDeX4Bb1gvhvaYe3yuXms/znyPTHfRe1cHfoZ2/hsWA==
             "]]}, Annotation[#, "Charting`Private`Tag$1374375#1"]& ]]}, {}, {
        
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNlstvVVUUxu/tPbuihgIDMTAzwfCSCRMYATEWYWKif4ITwIHOLBEkYQwD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            "]], 
           Polygon3DBox[CompressedData["
1:eJwtkjlLg0EQhjf5slGUoP4EIXb+hnQWlvoTLC20E7HzJwhqYWdl55EEooL3
hbfgAR7xiHhDPIgXBvV5ma942Hd3ZnZ2Z6a+rbO1I+qca4QYbHjnthCDsIk+
gRpIsD9lTesscC7FmoGquHM9EecusQ+wP4a/wGIUG8NeUCx4dI6zPuwl9pPo
Q6gOY45Y9+ElYmcHMAZJaIBxb2/QW5pYz+AXhvDvJ/4PfS47tOBzwboEWewT
7JfReW+xidC3Im5v0x8q0QHkA3uz3v6ATy+6Fh7R91AXszPZVrzdnYFV9DyM
ortgwduZbN2wht6BHLpMjl30LNwFFjPnLYdyjXD2pF5464VittE3skftDbfo
d2hHF/H/QM/IP2J36u5Pb7ZmfL685VRu1XgPXYLhwO7QXYWwdspxjV709hfV
ULV8VUzEYt7QU956qZzT6B+4CqwnZdUm7J1mJh3OTCqcgSzrurfaaOY0e9G4
9VI9UC+K3mqhnM+qrbdZS4azoT/pb8r5jf4HkGt3SA==
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0kcyZlEYBuAj59By4xemtKIwEubCrEfCgDKQc/hlusUNCBtgA1IZtw00
NsAGhA3g+cvgqfOeqnPr/c69t3po5vd0XAhhn8qkEGL5PTGEmwR7uZ1+Vjnl
msfYGXIcrqObMQ45545nPonEh9BKL8scc8k9r2TpqaWTBr31ZhiRI9YB+1F5
jHEmmGSKaWaYZY55FlhkiSjLrLDKGutssMkW2/zhLzvs0qizQfeeXGEdtB+W
O6ghkxdz/+eCI6L00EI5H+79xD/OOGCULn6RzZv398AVJ6zQRxu3Oqp0V8g/
rM1miMjllFHKT0oopohCCsgnL/YcubFvRDZZZJJBOmmkkkIyaoKaoDq4QmhK
/P4fvgDPnTM2
          "]], 
         Line3DBox[CompressedData["
1:eJwl0Nc6AmAAANDfRW48hTciuxDJKClU9t4UGX32zF7v6Hyfi/MCpzmZj+Ya
QggJmhpDqEVCeCXKG8d8MswEKa654Yo8/bSyxTYH7LPCKu2UmabCGoesc8IO
YxxRZYNButilhzu++aLAMvc88cAvPzyySJ0lXnimlywl9ogxRJEMs2wyQ5xx
ukmyQJpOBpiigwSTzDPHLRdcMsoZI7RxTgunfPBOjr7I//sfuLUx5A==
          "]], 
         Line3DBox[CompressedData["
1:eJwl0Ocxw3EAANBfkL+yhZUs4M4AMk3W0IUoES1RondCdKKX6IR358Nb4DW3
JVraYyGEVuqjECLi1FFLDTECv/EQqvzwzReffPDOG6+8UOGZJx554J47brnh
mivKXHLBOWeccsIxRxxS4oB9iuyxyw7bbLHJBuusscoKyyyxyAIF5pljlhny
5JhmikkmGCfLGBlGGWGYIdIMMkCKfvropYduuuikgyRNPhtpiP7f/wCIOUmC

          "]]}}}, VertexNormals -> CompressedData["
1:eJzMvHk4Vv3b/0ulDCEiSlLKEMkUkXKmFM1RitIgVIgoiRAylCGzDJmnMl/m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       "], VertexTextureCoordinates -> CompressedData["
1:eJyFnGl0VEUaQIEBjFsEFRcQRFFcACeKIi74VCBuKAKj4A6o46AjKuIIElEB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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 2.507958438783983}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->341503710,ExpressionUUID->"f95fc5c5-9caa-475e-89cd-9b57a14accdb"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->320505178,ExpressionUUID->"76ff5ac6-f30b-45b4-94c3-4ddf6e9f3ed5"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->122002931,ExpressionUUID->"575f665a-4185-4642-b244-fbfc52179278"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    FractionBox["1", "z"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ce193782-2c5b-4b1f-87f3-c3adbef7d2b3"],
 ". This is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], "z"}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e08a24de-0e71-4925-900d-7bb318769053"],
 "."
}], "SolvedExampleNote",
 CellID->152283339,ExpressionUUID->"40209c64-3b51-44dd-bd19-0e3d5965d6eb"],

Cell[TextData[{
 "With ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->746663307,ExpressionUUID->"17375d2e-a7af-4abf-9f8f-07bc61af196c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "z"], "/.", 
    RowBox[{"z", "->", 
     RowBox[{"1", "/", "w"}]}]}], ",", 
   RowBox[{"w", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->53144418,ExpressionUUID->"54dfcec4-a062-47a7-91c8-66c55dd9d630"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->19944224,ExpressionUUID->"336a2429-dce9-429c-8c54-1a91426fb423"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->304343862,ExpressionUUID->"ea6b2788-2ff6-49a7-90bb-7d44b360ea7d"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->95981031,ExpressionUUID->"691721e2-fe46-4376-8da1-521d54f70b33"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    FractionBox[
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["z", "2"]}], "-", "1"}], 
     RowBox[{
      SuperscriptBox["z", "2"], "+", "2"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a8d2647c-8d4a-45c9-9e0c-7e0f1224cf0f"],
 ". This is:"
}], "SolvedExampleNote",
 CellID->105993517,ExpressionUUID->"3d0889b1-3b58-4d91-8faf-32ed80457d7d"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"9d0bfe33-37a0-4b4c-9640-08234799b6f5"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "\[Infinity]"}]], 
     FractionBox[
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["z", "2"]}], "-", "1"}], 
      RowBox[{
       SuperscriptBox["z", "2"], "+", "2"}]]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"w", "->", "0"}]], 
      FractionBox[
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "/", "w"}], ")"}], "2"]}], "-", "1"}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "/", "w"}], ")"}], "2"], "+", "2"}]]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"w", "->", "0"}]], 
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["w", "2"]}], "+", "2"}], 
        RowBox[{
         RowBox[{"2", 
          SuperscriptBox["w", "2"]}], "+", "1"}]]}], "=", "2"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "bd2c73e5-9fcb-4be4-9be6-3dde757c96e5"]
}], "SolvedExampleNote",
 CellID->589869,ExpressionUUID->"fdfbdaf3-fd73-47b8-87ab-2e9597a20110"],

Cell[TextData[{
 "With ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->14672125,ExpressionUUID->"af2c6610-9228-49dd-8333-fae60a4f3cdc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["z", "2"]}], "-", "1"}], 
     RowBox[{
      SuperscriptBox["z", "2"], "+", "2"}]], "/.", 
    RowBox[{"z", "->", 
     RowBox[{"1", "/", "w"}]}]}], ",", 
   RowBox[{"w", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->214640721,ExpressionUUID->"d3f2d76c-1b3e-475b-8aec-b46fbbb45d1d"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->52697321,ExpressionUUID->"97b76b03-9c72-4761-9ae9-acb53075f85c"]
}, Open  ]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"604e5bec-0641-4dbe-a4cb-cd9d1021f969"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"1", "/", "z"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"35782138-1d67-49f3-b1c3-9dee39f1e6ff"],
 ":"
}], "SolvedExampleNote",
 CellID->895399388,ExpressionUUID->"6b7f03ce-bd23-4c6a-8ff1-d40cbae1b1d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox["z", "2"]}], "-", "1"}], 
       RowBox[{
        SuperscriptBox["z", "2"], "+", "2"}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "15"}], "}"}]}], "]"}], ",", 
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ComplexPlot3D", "[", 
       InterpretationBox[
        DynamicModuleBox[{Typeset`open = False}, 
         TemplateBox[{"Expression", "SequenceIcon", 
           GridBox[{{
              RowBox[{
                TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                TagBox["Sequence", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                
                TagBox["3", "IconizedItem"]}]}, {
              RowBox[{
                TagBox["\"Byte count: \"", "IconizedLabel"], 
                "\[InvisibleSpace]", 
                TagBox["1080", "IconizedItem"]}]}}, 
            GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
            "Column", 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
           Dynamic[Typeset`open]},
          "IconizedObject"]],
        Sequence[(-$CellContext`z^2 + 2)/(2 $CellContext`z^2 + 
         1), {$CellContext`z, 3}, PlotRange -> {{-3, 3}, {-3, 3}, {0, 6}}],
        SelectWithContents->True,
        Selectable->False], "]"}], ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}], "]"}]}], "]"}]}], 
   "}"}], "]"}]], "SolvedExampleInput",
 CellID->350297771,ExpressionUUID->"6f4facfe-a4fc-445e-b514-f3bc9751836f"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJytnXm4jtX+/7d5zhCZKpkylMRWDqrnLiWpJCGcdCQaVKboSJOKozJUhspc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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzt3XlwVdUdB3CnnbGtOh3r+E8lRJCKLLIFEl4SIOyBLAQIIQmYFIIBWQWC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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnHf819MXxz+zsomQjPYipSlES0h7yEhTVkqLUJpmRsmWkZIG2YSsflY2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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtlElsTlEUx+/rd29pa2hrJUVUWBSxMVM1LWysCGLoRiPhk6gYNm1JNKp2
JEpIN3wRKTpJJBIx1VgxxRgzMRQfgtKGRMvvn/MWv/f+59773rnn3nNO4cry
BesynHOLwcNlHksi56bCL/Ty4NwM3iWwAv2X99GEc8+hGLs02Fw1TEcvg2Jv
3+jb+7xv8K8mcNjvscfhcD70wz4CjYw1wyT0HW9rd0Ev+i7Uo0/DPXRgTQ7f
ZsMEdDtju5nbAMlM52ZqP1AII2AtLGLNCZiMXg0L0YfgFdyEqsh83EJ/8La3
JAxgbRp7O3oVfET7YL6z4Bl2X+x8dB68kR/sU7yvcj7j0Z3QQ+i9cIbxb970
PziHHsl8Bb4rYRT6OGxCb4ZGdBtrhqNL4Kc3n/Kdxn6EvqJ7iezMl7L+kre1
GutCf/fmy2Gf93aGOsvHELH+gTfdDQnsT95i3wn52FkwKMNifMvcU+iKbExz
dVDF2EGB3hvb7cRfiZ4YTHfAC28+5Ev/eILdAfP4VxHkMPfQW2zKGeXObMZm
wRgYCz+8xRLBBfQWxsqUkzA02B3prvTP/thnsQsiuwPdxTtvvpQD2dgv471r
z3uCxazYa+ErY3nB9A74gt0n2F3nQgv6N2MbI7uz63EON8f/09k0QIvymPin
BNuj9loHB6Sh1dsarR0M9QmrQdVij7fcUI4qV5XjynX5vIb9x1v8DXCYb4dB
KmFjW4PVkGpJNXIbPSdYbqomkujRUBSfsc56PZTHNaRaWhPXTwpeQ26ws6iB
z9gDg2nVSDquMdWaYjqmtao59DaYht4XTGusJtgd6i6V421xD6mO5/VtE5z0
FlOB9q578nZG3bz3BztLjWmuNvanHlWBHhLsbMriXEkFi0UxqTeoxlRr8tGM
nhssV9Vj1GsueuuFyqFO6WB3qR6mXqYcUC6o5luD9RT1FvW0TPXOYL1SNa5a
/w+Gcbbg
             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkcsuQ1EUhlc49QKKDiSUQV0TPIGRO6m6R4KISyLRkqKd0Zq4pG4DRtQ1
6cwzmHoCI/EcTHwr5x985//XXmevvdbe8dVMKl1lZo0QgTKfcmD2BWv4dViC
fuIVdBTG4I/4Fz6DMLfM2jXk8VfoPhzoX99zBlvkWtE7KOBvI2ENr7WJ34AS
5Igv0VPtOUHroB6K3hNrBfQQjqBbey7QcZjQ2d5DFhbJ5dBhGIJj1WjSfD7n
D/EzvOD7vCZ+Dh2AQYhBA8wqN6+zvYdXqLD2hm7DAn4XzcAORKEWJiFObgpt
cQ/T8F5t1oY2K59Sn97vnvo/R9uhQ/P5nDe670qN2YjqJHRWVPfl95ZWT3k0
CR/816t5YprP53zQ29+jT/CI/w7Cd/H36YJOmFGNHvQfn+s83w==
             "]]}, Annotation[#, "Charting`Private`Tag$1376547#1"]& ]]}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNl9lvlVUUxe/lfj1QBiGAJg6ozINjinMcodCWSYOJKCpQFIcAZUr5B4pM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            "]], 
           Polygon3DBox[CompressedData["
1:eJwlk0tLVlEYhffxfN8biZfuGoWhdqULJaZR0RWMJK3sQmmkWVROdNC/KFC0
oHLcLKhBEUg/wImTJjZrEDgqBTVNk8pnsQYLnrX3fvd5L/vU9g509JeklJpQ
AZ2KlN7mKb3KUjoN30CL+KfoJvyrmNJ79t6hBfgia6UEPmO/FT6ORtl7jU7A
NWiZvVn8DrgLreH8C/wduIh68DP4gMtQBX6QmHK4O3z2Db4HPqwc8JPoCPyH
HCbgH2gF3s3aGPFz+D3wmXAt3aydhRvRV/wYOgpfQZ3sfeP+q/ClcC13WWsL
r2mvDt8B70Wf4U9oH9wcvks1HwvHKPYjvh1eh+7hv+DXw+fCubzEn4dzNJ25
BwV4i74Bt6Mq+HfRvVaNS/A8Gs48A81iE2e+547ZDO9EU7l7sCucg3JRjZfh
ynBvlZNyU07K7Ql+Q7hn6p1qVK0t4Vw14wvwrfBb0Axvw2vDs9PMSsMz0WzU
4wb4b9Gz+Yn+wQdZm888w0PqTXi2z/G9cIbGc/ekBH6MRjLX3Bd+U3pbeqMn
4brw21LN9fD98F0fyOcB/DDMuuMRvD88O+VwAN6GhnK/0e3wxnAv1FP19jqq
L/gf0L+gmWg2lag6XJNqU87/4Wvht6IYxeqMzuobW+FVDN1nHQ==
            "]]}]}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxFlltsV0UQxk//5+zGB4XwgCj0gq//losJJooYwpOgDyAhhpsvxlCJCqJY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            "]], 
           Polygon3DBox[CompressedData["
1:eJwlkstLlWEQh99zOu/gQgj3ZbQVcuNOkGgXtJBcCeUmpFOgKWgXL2CplFFS
4OVUWC68kIGrUtQ0ShRNLeiCkSWUaBpoR/+Dnh+z+MEz883M987l+IWasivJ
EEIRSqGFGMLwoRByMBbhMVScCKEcjcObqAE+h7bgfygfPoqy8H0LYYf8wxTt
hHfxHUt4zB68jB5R+xRagZ8RUwq/Jqcf7kVnseewM/B+9NpH0AHcge8MtU+g
u/AqvgriXxD/Da7BV4b9HrsWHkHnsd9iF/L9sXntPHxP4EFUD2epPwT/JOYk
9g9i1uFf0TmD7zc8ja4R24M9Az8lpzHlPaiXB+a9fyTnIfyFmN6Ev/GrZoev
gO+nUSPcZR6rnrvN/6F/acYb8Cf0nO9pfJ/hAfNZ6c16+xy+ypTvbB6+hS9N
7Uuo1TxHuXqD3tJk/u+LqNm8B/UyQP6b6DvRbvTPD/BE9N33YU/Cf6LvvgRt
w9+jz14zW4PrqTkK51L/KnwbXU76zu7AL6PvUjf1Cq4z35VylLsU/fZ0I7qV
PvNdacaatXakXWmnw3CLeS/q+aZuL/rbdHN/4evmb9HMb5j3oF60wym4yvw2
dDPV8D3z29IN65bfRZ+NZjwLt5nPVj21w/8BmLt2ag==
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0kcyZlEYBuDDL7ccWy5TYQPCXJgZoWcGWs45Z0Oh+FkAGxA20DYgdOke
MqVK2AAeZfDU+52qW/Xe79xb0TnUOhgTQthgNy6Er7lTRiMhlJsb+MUMh1xw
yxsZHq6hhR62OOGSBz4ojQ2hjnamOOCMa15I01NFE3851v1bbstH2U0PvfTR
zwCDDDHMCKOMMc4Ek0wxzQyzzDHPAossscwKq6xxx4nudbkjn2QXjVSSyrP3
vuKUfSZpo5YS3u19zx+O2aSbZqpJ59X93XBOlGk6qOdIx57uMvOC/O9cai6h
mCIK+UkB+eSRSw7ZZJH59Y1IJ41UfpBCMkkkkkA8qoKqYIXwL/L9P3wCYw05
jw==
          "]], 
         Line3DBox[{1522, 1213, 1266, 1218, 1268, 1220, 1305, 1306, 1270, 
          1222, 1432, 1434, 1433, 1309, 1405, 1308, 1445, 1408, 1410, 1311, 
          1353, 1312, 1363, 1300, 1354, 1436, 1377, 1320, 1314, 1343, 1392, 
          1389, 1412, 1232, 1400, 1302, 1417, 1315, 1356, 1374, 1375, 1275, 
          1431, 1338, 1414, 1339, 1373, 1435, 1372, 1371, 1370, 1369, 1221, 
          1269, 1219, 1267, 1217, 1216, 1265, 1215, 1264, 1214, 1263, 1212, 
          1522}], 
         Line3DBox[{1513, 1512, 1511, 1510, 1509, 1508, 1507, 1506, 1505, 
          1504, 1503, 1502, 1501, 1500, 1499, 1498, 1497, 1496, 1495, 1494, 
          1493, 1492, 1491, 1490, 1489, 1488, 1487, 1486, 1485, 1484, 1483, 
          1482, 1481, 1480, 1479, 1478, 1477, 1476, 1475, 1474, 1473, 1472, 
          1471, 1470, 1469, 1468, 1467, 1466, 1465, 1464, 1463, 1462, 1461, 
          1460, 1459, 1262, 1521, 1520, 1519, 1518, 1517, 1516, 1515, 1514, 
          1513}], 
         Line3DBox[CompressedData["
1:eJwl0ckrbnEAx+Hfy2taSxZKKUM3K2GHRKRuEnFt9SZFIsnCEEm6NyJdsbSy
M/snzPdmnmX4J5DpKYunzznf3zmdxcmKdTd0RUII/XQkhrAdDeGTf3zwn5AQ
wrGecsY1UduNFmkCldy6L9ZB5pjlztamU0xTy19m6KOXIc49N6k/KCefJmLU
UUA6v2immgUuvNeq99quHVRQyAYP9k1dZ40kHm3J+qQpeqVxeqnxeqIRPdJD
DtjnnT1ynGVTSglvtgH9zTjzvNp2aXH9kwn+kEYX/XTSQzdlZNFILlXkkUo9
DdQwxigjLPLiG8OaSQYrrLLMEjvOn9mKfv/fLw4PQH0=
          "]], 
         Line3DBox[CompressedData["
1:eJwl0cc2HWAAhdH/KhfRW3TRuxDRa0j0fnWJqEEmjD233m3LYE++tc7oVB6c
x84iIYQLxqIhjPKDEYYZYpAB+umjlx666aKT73TwjXba+EorLTTTRCMN1FNH
LTVUU0UlFXyhnDJKKaGYIgop4DP55JFLDtlkkUkG6aSRyidSSCaJKIkkEE8c
EQKviSG88MwTjzxwzx233HDNFZfvLSGE/7annHDMP4445IB99tjlLzv84Tfb
bLHJBuusscoKMZZZYpEF5pljlhmmmWKSCcb5xc/ox79v+Iwojw==
          "]], 
         Line3DBox[{1704, 1358, 1325, 1423, 1383, 1441, 1440, 1428, 1334, 
          1446, 1447, 1286, 1247, 1384, 1290, 1252, 1291, 1254, 1293, 1256, 
          1258, 1295, 1259, 1296, 1260, 1297, 1261, 1298, 1257, 1294, 1255, 
          1292, 1253, 1337, 1348, 1336, 1448, 1449, 1450, 1335, 1387, 1442, 
          1443, 1381, 1439, 1437, 1351, 1330, 1368, 1304, 1360, 1327, 1379, 
          1328, 1324, 1345, 1322, 1396, 1420, 1394, 1399, 1398, 1425, 1704}], 
         
         Line3DBox[{1690, 1689, 1688, 1687, 1686, 1685, 1684, 1683, 1682, 
          1681, 1680, 1679, 1678, 1677, 1676, 1675, 1674, 1673, 1672, 1671, 
          1670, 1669, 1668, 1667, 1666, 1665, 1664, 1663, 1662, 1661, 1660, 
          1659, 1658, 1657, 1656, 1655, 1654, 1653, 1652, 1651, 1650, 1649, 
          1648, 1647, 1646, 1645, 1644, 1643, 1326, 1705, 1703, 1702, 1701, 
          1700, 1699, 1698, 1697, 1696, 1695, 1694, 1693, 1692, 1691, 
          1690}]}}}, VertexNormals -> CompressedData["
1:eJzsvHk419/6N4qiOUKmBiWlDKGIiJUIEZlFhsxzppAylrmMhUKUISmZh4wr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       "], VertexTextureCoordinates -> CompressedData["
1:eJyVm3m8jmXewLXZasI7bWiztlBDi5HoyhRGQmk7qcmSSrIvE0k1RgsRZToj
IdPIQUyWxpJIVMIkOVKcxXkOB0NUaqaJqd7nfd/rez/z+fo8H5/3/HN/vue+
7+e57+t7Lb/rd11Pre79Ot13fLly5WaXL1fuf47pvyatf9/9Go5Lb0kNfivv
TwE+sfbakmV5CxJuNPmcp3OHv5Vww0pv5S7LezfhX7Uq+3tetQ8Szvld1Ra5
w9cn3HvF1RNGlW1MeNWjiwYsy/sk4fU12r48vzA/4S1Li9/Lq7Y14eLbBx+c
1vrzhPd+W+ms3OHbE/7mhVdajptfmPAPja58aFRZccKjHrhvfYtxJQmPbtKo
y7K8VMLPnXTkmytWlyY8ccv7z8wv3JnwpD9POKfhd7sSnjrwroV51XYn/GrL
+m3qNNyTcF7Vrwumtd6b8Nwdy/vX6Pb3hBf+5amTcofvS3jJiJsnV8vdn/Db
N579i3Hzv0h4dc09aypuOJDw2n0LckaVHcyU37JHD/z005chm1cf8QvjF8Yv
jF8YvzB+YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfEL4xfGL4xfGL8wfmH8wviF
8QvjF8ZvUn7Rb7Z2aq8+4hfGL4xfGL8wfmH8wviF8QvjF8YvjF8YvzB+YfzC
+IXxC+MXxi+MXxi/MH5h/ML4hfEL4xfGb1J+0W+2ftft1F59xC+MXxi/MH5h
/ML4hfEL4xfGL4xfGL8wfmH8wviF8QvjF8YvjF8YvzB+YfzC+IXxC+MXxm9S
ftFvtnHU/a7bqb36iF8YvzB+YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfEL4xfG
L4xfGL8wfmH8wviF8QvjF8ZvUn7Rb7a4yOOo+123U3v1Eb8wfmH8wviF8Qvj
F8YvjF8YvzB+YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfEL4xfGb1J+0W+2ONdx
kcdR97tup/bqI35h/ML4hfEL4xfGL4xfGL8wfmH8wviF8QvjF8YvjF8YvzB+
YfzC+IXxC+MXxm9SftFvtnmL41zHRR5H3e+6ndqrj/iF8QvjF8YvjF8YvzB+
YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfEL4xfGL4zfpPyi32zzUM9bHOc6LvI4
6n7X7dRefcQvjF8YvzB+YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfEL4xfGL4xf
GL8wfpPyi36z5RU8D/W8xXGu4yKPo+533U7t1Uf8wviF8QvjF8YvjF8YvzB+
YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfGblFv0my1P5LyC56GetzjOdVzkcdT9
rtupvfqIXxi/MH5h/ML4hfEL4xfGL4xfGL8wfmH8wviF8QvjF8YvjF8Yv0n5
Rb/Z8n7OEzmv4Hmo5y2Ocx0XeRx1v+t2aq8+4hfGL4xfGL8wfmH8wviF8Qvj
F8YvjF8YvzB+YfzC+IXxC+M3Kb/oN1se13k/54mcV/A81PMWx7mOizyOut91
O7VXH/EL4xfGL4xfGL8wfmH8wviF8QvjF8YvjF8YvzB+YfzC+E3KL/rNlpd3
Htd5P+eJnFfwPNTzFse5jos8jrrfdTu1Vx/xC+MXxi+MXxi/MH5h/ML4hfEL
4xfGL4xfGL8wfmH8JuUX/WZbZ3Fe3nlc5/2cJ3JewfNQz1sc5zou8jjqftft
1F59xC+MXxi/MH5h/ML4hfEL4xfGL4xfGL8wfmH8wvhNyi/6zbZu5nUW5+Wd
x3Xez3ki5xU8D/W8xXGu4yKPo+533U7t1Uf8wviF8QvjF8YvjF8YvzB+YfzC
+IXxC+MXxm9SftFvtnVQr5t5ncV5eedxnfdznsh5Bc9DPW9xnOu4yOOo+123
U3v1Eb8wfmH8wviF8QvjF8YvjF8YvzB+YfzC+E3KL/rNtq7tdVCvm3mdxXl5
53Gd93OeyHkFz0M9b3Gc67jI46j7XbdTe/URvzB+YfzC+IXxC+MXxi+MXxi/
MH5h/CblF/1m26fgdW2vg3rdzOsszss7j+u8n/NEzit4Hup5i+Ncx0UeR93v
up3aq4/4hfEL4xfGL4xfGL8wfmH8wviF8ZuUX/Sbbd+J9yl4XdvroF438zqL
8/LO4zrv5zyR8wqeh3re4jjXcZHHUfe7bqf26iN+YfzC+IXxC+MXxi+MXxi/
MH6T8ot+s+0j8r4T71PwurbXQb1u5nUW5+Wdx3Xez3ki5xU8D/W8xXGu4yKP
o+533U7t1Uf8wviF8QvjF8YvjF8YvzB+k/KLfrPtC/M+Iu878T4Fr2t7HdTr
Zl5ncV7eeVzn/Zwncl7B81DPWxznOi7yOOp+1+3UXn3EL4xfGL8wfmH8wviF
8ZuUX/SbbZ+f94V5H5H3nXifgte1vQ7qdTOvszgv7zyu837OEzmv4Hmo5y2O
cx0XeRx1v+t2aq8+4hfGL4xfGL8wfmH8JuUX/Wbbt+l9ft4X5n1E3nfifQpe
1/Y6qNfNvM7ivLzzuM77OU/kvILnoZ63OM51XORx1P2u26m9+ohfGL8wfmH8
wvhNyi/6zbYP1/s2vc/P+8K8j8j7TrxPwevaXgf1upnXWZyXdx7XeT/niZxX
8DzU8xbHuY6LPI6633U7tVcf8QvjF8YvjN+k/KLfbPuqvQ/X+za9z8/7wryP
yPtOvE/B69peB/W6mddZnJd3Htd5P+eJnFfwPNTzFse5jos8jrrfdTu1Vx/x
C+MXxm9SftFvtn3y3lftfbjet+l9ft4X5n1E3nfifQpe1/Y6qNfNvM7ivLzz
uM77OU/kvILnoZ63OM51XORx1P2u26m9+ohfGL9J+UW/2X734H3y3lftfbje
t+l9ft4X5n1E3nfifQpe1/Y6qNfNvM7ivLzzuM77OU/kvILnoZ63OM51XORx
1P2u26m9+ojfpPyi32y/Y/HvHrxP3vuqvQ/X+za9z8/7wryPyPtOvE/B69pe
B/W6mddZnJd3Htd5P+eJnFfwPNTzFse5jos8jrrfdTu1Vx/xm+13Sf4di3/3
4H3y3lftfbjet+l9ft4X5n1E3nfifQpe1/Y6qNfNvM7ivLzzuM77OU/kvILn
oZ63OM51XORx1P2u26m9+vivbr22VtxQFHbVC7+v0W1bKP/x+j8Mr5FKmPMH
12yZWy23IDkPc+Q6H7kePnnaixd9d0Vp1s/1fT5yf7bP9XWcr9qn68qBHXcm
5+GqS06fujzv+eRIfYd/3enMOqsHfpmcp9xgPn/707PvrNPws4Sph7wf5Un9
c/lST4/73590liTnqY8w511u3G8vfF+2/1P/7dHrrJzn+13ufh7up5xdDn5v
fy/M87le8Rw+0l5djzjP8/j5Xa5mrze7HLzu7OdyPbZXe3Q5ur57PdTvyXtx
nb+f/7tdcB9Hns+eYZ4Ppnzc/ry+53LnOXgut2evF3I91/k9Tm/e4JaDD+4K
bse0bzjb0e3c98E8v9uv17EpN97D7c31CuZ9vE7q+uv7XQ+9jmrfXo+3H6/H
urwZB91PcqTceE7qFeXg/Tt+btdrtzeeZ/i6j6e3zikO94+b0T7n4LaE+zdo
9nDHOum4fdFlZdNalyTMket8/HDkD8NqdEsdxXwO7Ov+dvOHp+YOL02ug7kO
5vpuK7ctLcz/PAw5fOIpG1oUJc/fquakNwrzSxLm/EN39yvNr1iQ3A9zPcz3
+bzfP9vn8n+Ox/o/38f/b9jX/fqcg6mjPPAcXGfmc/g/x2P9n+/j/5QzzHn7
4v98f7b7/Lnc33HZJdvyK+5MzsN8j89vPn/in6vl7gxPTJp85eqBOxK/MB6o
PzDnKUf6AZ6b8zwX7creuA52ffb5ZF4br+M9aP8w91FeXA9znvLjfrcryovr
3b9SHrDrseMG3p/reR6Y5ykZ8diBFXm/S46Vy99QsduyLxPmeuI9OMkbxOfH
J+x+1eMq53kut1/eD6aftCfek//z/TD3ux/ONo5xn+uV64G/z0fqD9/vftvj
Fp/regkzLrjdu99hfOF7uJ/xjOtcH4gfXA985HmpZ3y+2x/13P1ktn6Q6xxn
8T68P9dxH3EJz52tnzc77vZ46XLlPO9ldj/jcnH9cjzN9bD7e9cv7ue8P9/1
1OXvONrv7XkF98OUi+s5n+dyg6lHjic9Hjgu8nP5cx1fuh07XnQ5Zau3sD/P
8ab7HcdxHmfo7zkPU48dT7pfLqc8Ff+nHOjXKCf6V8rV463jd85TLu5vkzxw
vN/7zt1/On7lPP2Sy8n7Y+3Z8bn7M+9Hcz9GuTEOOh70uON+xXG8+33H3XwP
nwdz3vNQ99dcD3Ody9HzDOdJeD+OnlfyOTDf6yPP4Xks9ZjzSb2atPqLZfPy
w1O99+fMeO7o34Ounti/04Q2m5Pyez8yn/tCvP/ttmPy5y3N7Lv+wwmd1l/Z
oyDJizb5cWuNsvaZfboX5s07fN8VBZnfyzWcffxH92X27TZssqLjK99kyin5
nGdSE99fUhDCrd0nXzdoy1G/tzlhe6/mm5sXhEXL2v3mT9Mz75nsY43nyY9e
FT8v9enGy+75oOyo3/dcdmGtEX+fXRRm3T2309TqmXKhPLrctnz2yx8UJfnV
pvH6OZ/Mvr3xoMy+tXnxfu7jvH+PsPehfi1PbpAKv4rv5/3nbe8/7nDbE1Jh
cXw/73vbGe8vju/j/e9lV1dpck7dTDn/9ML6VG63TNzX44HxF7S8JNMecuq2
2PTZvFS4OPpw+74znuf/3E95/xg/n/Lm+/Gf7AeO/mHqD/ddGesPTH1N1h1j
/fP+wRWLplWqc1HGw3mL1279ZWGm3M+OzPssi9d3nZ2X0zS3MDRtfPPCu1bn
hx6Lnnl7z+KicNnUKV/8/C+bw49tDrW768kdYVVsD4eqnF+yYWgqTPvowqmf
PpYfprz22N6FjxeExzaseOijki3hyZWdlpz3diqsufi5diNO2hLqrtx9dvUT
0+185PJ1F0/eGk7e2PuMTo1Kw7Y9d1y+rfZnYei2Rnt7pfuFvle/vHJQut84
564+Y3OafRqaX3lppWu2FYSNt1Vp2XvV1lD6fLM/dL64IOzr8+7Fj08oTI6t
y01vtHRGKvSp//iuMXMKwz0/rNjwep/0852/vMbA5oXhyITidR/2Kg0fzb7/
wJvHFYaZVRvnVH5yVzi1T8nitn8rCGf1uWfQme3yQ7vf33Dd/luKQ7VD1Q//
rNaW0KxX/+n7vi0Mc2J9HlzxzPpvNsjU57O+/GTRH2ftCP8q/83xw74sC7vW
r31jzJOpMHjdTa0Hd94dOq/sfE/lrSVhafHUjvv/sTU8sm583YLqpaFPy9d7
dxu1LWx6vd20ya1Lw+Lceeu+blkY+lU4vumeMaWh4ZZ+M+4dsjPUP+m1Kns7
l4aatw3dse6VXaHaktK/bk6/x4BO65bldy8L3ct6Hun689JQ9b62t/RPl9+r
KyZXezXdD+69t37+Xa8UhJ+fcuv9E/vuCgenjx3wzYjS8K9rar+8b+GucGhk
5+dXPV0Ypuxr2rnlD2Wh8bxVz9a/tjRcW6PWDS+NLwuXlrwTep5aFK5+6aHG
L167O/xYUL5zpxYl4ZxYfzrMXF5rbN1UeGDBgkr/nLU73NRgbv7ON1Pp9vBZ
/c3n7g6/Pa3Og+edUhweeWPBdYdGF4WT+zeoeMZV6XnPLbNnHLm7KKwd0rfd
V9+XhGHx/JE2+44M3lkSSuP5D+P56y+8oLj81en+IJ6vevvrl4y8OZW877uj
1hcu77otdBg6s6Drf+S5f1b8q9590/VkY/Sd/C7xiQ0zb51SEEa2bTe/6pyj
8/NXdxpwb7MK6XFx4y++Hz/q6Ph8bsN3B87eXRi23jFs7oEJO0K9yl9fVLNZ
ur+r0Cpn/Z93hA6d6z12zQWZeG1WvL5tlzltP26xM3SZ1XPN+oEF4dLod+E/
/lryixsy4/ew69Y1qf91UZg//OKzFwzLzKMvbXD3pqf3Z3hz/P6Dj1R46FBp
SZgdv39bpwOrun5REqrfuuai0b8sSc5f+mhRfo1L0/PneP7D+H6Or+c8+Err
18dm4ukpa4rOuO7sdLva98mZzcdk4vRLVu8bcMGao/Prc+P9L44u2d343tIw
cuENvd8uXxrm33H+kqanbwv1Yn2uHP3UeP3G0fV+SoXHow/G+2vv2p733ZxM
fHH9xD3Prk8f23ZfeH7rdP0e2v6urWvTPCPWd96jNPq9Jt7vOK1p49T8Ea8V
hCc+nHt5h69Kj1p3qLfvwLdbh2Ti83Edbhry6X/Mmw5UHv3kae9n4u2ln9/R
6sX8TH505+1tNnb/dyqU9Z056d7zMnmH7WsavvDxf+TL9xyaVDTrveJw6vTy
PXbtLwovb3q2wnsdUuHbK/p90X9QKjwydOOMcxumwunjGnY8IzcVNt2z96uH
uxeFmrm1Lji3elGoVuXexavzisL2spnd8vMLw28Llsxcubk49D/lQLXrlhaF
yfHzqsfrh8bP+yxevzF+Ht9XJX7eafH7Jjx1+fOvTy0Jh9/490c/q5wK1/3X
jLnTc0vCB8MqPVxcJ1Nftp59Xo9+7YtC33f6N6mfl8mHXXjgpMdHn5mJ16tv
/9vp9c7aEU47+fjfzf4h/b0vVB9yYFBJ+O3hx0KD4zL1548Dvmr/6ztTof30
tbt6N8zkGfpVGnHt1d9m4nL8vx3bP/VjUBw/9vWoldOofGacf+2Ki2pW2JEK
tb4+Mr7xvu2hV+Nl88ctSI/zG1dXenBkQZh8Vs8TlrbIxE98z+Iqa8/d1yHD
25+qU+U36fGgXrN2g3N3F4dNObd+9M91mTzd9fe8vKt3hVT4qvv2998cWxIm
59/20ok1U6FNHJ829F417q10vewSx6eF/V499EEqPW//6Z1p4xen47B4/vqT
RvWcVbcoLIjnGR/bxfp/cttXeq1akkqO65ZNONj3+NKwocaVk1tuT4U7qt79
eI/ZqdDivQcr3Xh5Jm/f8/IfTu79fVHoFdszHi+M7Rk+M/YfdWP/1jD2H+1j
//Zd9Fct+qT/6nhb7QYL0/3FjNh/4bV+7L/gQXF8oH+vGMeHU2P//mysz+/E
+tY+1r8esX4/F+vnKbH90M6uiv037Zr2uDO2t+9jfb59R5vjfjmvMDz7cMMD
D7xUEAaNLa5d+0hB6LP+xQ2PtisMQ6OPvjGeaBV9TI/xxJSxPVutWJkZV6jn
y2N9gYtiffky1oePY32pGr3tjPHL7dHXM/F5Pow+e8fnodzyY3vrHdsD3/Pr
2F7g82N7GxLbV91YX6mPufH56Te574XmfYd+8mSG6wyd8tWYzzPt/cXYPmvH
9k27uC+2f/if8b0qxPe8NZZ381gf+8fyXh/rK8/RYcmTXW6aURhmfJG/ccOw
TH5lSYyP6sb2e97UcdN2TSkMNWL77dgl57GXbszkE+7clH/tom1H5w82DL1+
87C1RWFKbO/OZ06M7w/Xi++P53Fh8txPG5eGRfVzuvc8JZN/4nPGx/Mz4/N7
/nlTfL/F8X7e74z4PocnnTt8wzWl4cb4Psxz98f+jHFsZuzP+sd4sX/szw7F
+2fF8Zb4YkCMN7vG+IN+8ao4Hpbr93/jFe2mXYxXPonx6Zg4Xibz8YWfHXh2
SXo8bjewToeLS8P0f1T6/L11peH7eU+1eiA9H/L82vMDz5c9P/B8+VjxnucP
nk+7/ri+uD45PnR/4XjSPt1fuH9wfOnx3PGmx1PH0x7/Xd89XjmedPzq+Mf9
v8cP92/OF7j/drzv/szxs+OXY43Xnv+5P3G86P7X8aPjBfcvji8cfzg+cfzi
fJDnx84neX7tfJTzVZ6vO7/l+b3zYc4HOJ/m/IHzVZ5PO9/k+bfzT55/O790
rHyS80Gejzs/5PmK5+uO751P8vzG8YjHP4+Xzkc5PjzW+O343uOzx3PHY47f
HD85P+d4w/NTz588P/V8wPG05yOefzpfcKz5hOdbHv+db3T87nzgseJxzw89
P/Z46vyix1ePxx6vnT9yftL5JOcrnV9yftX5Ludjnf9y/tf5M+ePnV92vtr5
bOfznP92vsX5GOcDnC9w/tDzDcfrju8d3zpf6fy955uezzve9/zA+TXP7zx/
8vzQ8zvPB50vcT7M833nt5z/cL7L+cNj5RucH/H8y/M1z+8cnzu/7Pmh84XO
Nx4rvnY87njd6zvOf3t9yPly53Oc7/P8zvkGz288//F8zvm7Y81nnO/2eovz
Hc5vez3F+W6vpzjf7fUUr584/+31FOfDvb7i/LjXW5wv93qO8/FeD3I+3+tJ
zo86/+h86v93fun8rPNNx5oPO//l+bbn586HOt/s/KDXC5y/dH7b+Trnu50/
d/7X+Xfnu5x/cb7M+S7nw5yfd/7lvwG2XQ5B
       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-15., 15.}, {-15., 15.}, {1.8709338516875764`, 
      2.12673180398537}}, PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   Graphics3DBox[{{
      GraphicsComplex3DBox[CompressedData["
1:eJydnXd8z1f7/2PHqB0pYtS4W2rVLMp1ULVXKGrVqE2DqtVSW22KUrEVtWeN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       "], {{{
          EdgeForm[], 
          Texture[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJytnXeUVNW27u94bwyzBO8JHk81ilmPxI7QxCZnhCaDCpIlKCgISAbJGQSU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              "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {144., 144.}, 
            PlotRange -> {{0, 144.}, {0, 144.}}]], 
          GraphicsGroup3DBox[
           TagBox[{
             Polygon3DBox[CompressedData["
1:eJxNnXf8l2MXx7/j/v5kZxXZM0qlgUqEZKbsWSgeJKSQkVH23nuWPRJ57BnZ
kqx4yIoQDx5b5nPenff9+vnj/K7ruu9rnutc45zz+d6/lYcM3+HQWqVS2W/B
SqUe4cPxh/RKQZsHtQ1aM6hv0BqmtwxaK6hd0Ba+J72Vz9oHrR+0dNAyQf2C
OgR1DOruszZB6wW1Nt+6Qa1M0858QS2CVgtqBDUFrVzJvtHPVQyLoG2C1raN
VX3WsE8LBMXQKqtbx3yOgbrnt+/zm29b+9gpaGvHQb197Ad1PBk0Lmh80BNB
15t+KuiGoBuDJvue9NM+uyloTNDgoCFBzwbdEnRr0GNB1wZdF3Ri0D7mOyFo
b9MbO37G3UP+LRvU03C5oE0dP33dzP7Cy00sx7tVgzGPBeMeDdrAcssH9a7k
nNPGRkErmn4m6Gb72k5eLhTUJWiJoCWDjgzaJWjXoKODdg/aI+iooN1MHxu0
Z9DAoKHyl3kbZTnyHRc0KGivoOMNGf+BlZQtyhxQSfkjvX8l5Y/0jkHdKilH
OxkiX9vb165Bo22fNnb2/fq23UNe7m64gWPifXf72N18yMTCQYsEHWFd5B1p
P2i/g+8XDVonaLGgxSspWy1Nd/YZfGwvX6m3o+Va2m94vJTjI2SdfFBJWZwc
1N96aWc762XMI4J2sE8HyW/W4jBD5P1w+8sYDvYZ9R0aNMD6DvEZ6cPkKfUO
932Z7mofp1RS3pGbR4OuqaR83xV0XtD5lZSn04POMN9ppm8LOjPorEqujTNM
XxF0TCXl6EpD5vN2854ddGkl5ekoyw113NR7oOmTg/YL+pflhjnusw0Z64Sg
c+3rSUH7WuYUy+1vnw6yPH0/wDZO9T3pc6wPXt5p+lx5c6rlbqpGPOi0oAdj
TZ4RG9wtQQ9E/PQIbw66LejMoLOCHqpn/NagG6PMKZY/ITa944NOjee3m/fs
oBvi3cnmGxftjXVM7FtjTF9dybXHmrtBHjHWGw3p6x3yiDFcJe+Pc24px141
3ropX+5lY5z7E0w/7jvav6iS8scauqSS+wjz94LzSptvBz0U9HDQjKAHTf8n
6BHl6x3fk35eGaL8i9YB7981L3vtc8rWbdZ3hTL1kCHjm2T/Lg661/AS+TVE
mXi/kmcA6/C+SsrfZUEPBF1uvf+23KX28Sr5/YjhNdZ9hOOfKY+o9y3roo8T
K7luLqikXLL2DlOeDjXNO9b8SPMeZvpu311o/1gfR5se6RzcY5oxT3f8jPtV
35F+uZJrg3X8umNj3G8G3W9f35PHjOEleU+ZqZZjHK9ZN+Wn2T/aeMX3pCeE
7J4bdF4t9x32NvY19m7OJ86rFiHTcyL8MmiBiH8V4X+DfrMf8HLheP5NhN8G
LRTxryuZnr+a5SjTiPhnEX4etGA16yBfUzWffRE0XzVD2ptbSXl6z7ZfdnzU
gfwhv59W8oxH1oooO9v3c+TLy7ZH3hdt40Xf/VpJ+aaNXyop36RnWx9tnFnP
dD3q/t2xIo+s838F7e+eckDQgUFjggYHDQk6K2hY0MFBZwYdZPpUy1FmrHn3
DTojaKj5TvLZfu4r+9neJkGrBK1Ku9G3j6IvfwWdGvEPI/wz6Ix68qUWef6w
v5xjM2PfOj3efcz4I3wh6JOInxXPn4n4LHhQz/o3Drok4itH2Dvor3qO68Sg
h+NuM6Wed5ZFqjnn/wv6MOq5KJ4vH8/aVXOOkYVtIv/WQRfHu70jnEUfghaK
i+JjkT4/ys2M9AVBy0b+dYNaBbUOWs9w6aD34/2FQctF/Lwo85+ILxPx9yJ8
N6hNxF+J8Kx6jntahGfXkyfU8asy1S3iS9nG1Hj/cj3ntm01ZX1+25urjK9V
TblnPGv6nvRqjZQ9eLh2NdcA/OgatKRt/OC6fcs184pr8edK7rnI3E+V3HNJ
/2jeGfL0NfeAr5T9V1wz1MGe8X3QG7bxjc+muw6nW36d6MdiQYsHdQpqabpj
0KKm2ztXjKGzeZcw/MF+dfEZY3uynndu5I/y39kX7qPc6XoFbaqcrhb0c+Tf
JcIjXAP9grZV1rcxfbDP+hMGb/sFXR7lhkd6u6DtXTNbBm0VdIh5BwQdarid
65D3WwcdZrkdgi4NmbmM+3jE+watUc0539rxM4d97O/qrtEtbG9z865pei1l
fAufkf4y6p4T1MP221nvZta3hmt4c8vNrufaGlRNPQS9Ah1on0rqEqSH+Aw9
gzv1hpXcl7kfoTdyL+f+zj69cSXPS/KiR+5nSL69fU+9q0e7TUHzBT1eT52K
veOzeq77vaq592wmnwbEPPQPuqKe+1Bfx7B3NfOzJ7E3bCr/9vEZ6afqeU/9
uJL7XJ+SH1HfrhEe6dx3UB77K6PI7E0xXwsUuefcGOH8QSdEfMEi99nrgs6r
pnwwz+OruW+yX14VNDrouKDrq5mfvXacIfmu9v3xQecqQ9R1jrJF+vvo/8AI
j0WOos//jfRuzHnEf4/4VfCxyLauDLo24n/WkwfHObd72cZe8uzsaso6bfxQ
zzyU31YeMP4bop5r6tnu9SjaQSOVY/aXbsp1F9M7+oy986sod2lQz4hfHOW+
iHj3aq4P+Mr63sm87K8XRZ7PI8/61Vw/na13hO1R95WR58d6lqtG/PAILwyq
R7wWdDTzEeHf9SzXiPjVET+G+quZn7W/f/Dtl3g+ir75DBm4KvL/FM93Jh55
lgwaV+Qe+rPn851xRznH+8pX8e7IoNMi/id1NlIWbo5nCwWdH/GJES4DHyO+
XJHy8hhzGXk7Ba0Vz+50vpn/ufFspXi2YtAREV8naJWI3+Gcke/2ap7rpG+N
dwsHXRDxB4OuUAYeMkQGHzZE1haLvHdH+ErQJPkCDxYtkpe8u0e+8u7Wat4J
uDvcZkjb90T+NkHXRrxlhBMjnBq0TFPK+uNBz8CLoFuCnjWkvnrw69MIZzNH
Ef8sws+D9ox6No/0fkFPV1PnQWfaLNKrB60R1NewbdBT1dR5yDe5mmuP9HO2
Q39fdTyM9ZPg5erRxr0RPyri7YPaRnraP8b9YjV5zZw8bx3w+wVD3j1RzTGy
jp80pO1do75to761om/X1XMuHoAP8fzaSF8e8ZnyhjpaNmX8PdaL/GNe/mtI
v742ZBzvW442f7Mc9f1uyPsPfA8/WkX9iwWtwJ4Vfege1DHis+LdFOenS6RX
DnqJscb7rhFflf3Duj6UqA9+r12kPL0dVNRyDpm/ZaPs0shrvJ+hLCKDw+PZ
2kFLxfM//tHH2fHs+uDJ9Ij/GPRWNcv1iHwdiqz/LflHXUsXGX+TeYmyzwW1
jmc/+Iy8GP3+jueXRPxg3gctwZ7RyDzfB/0c8Z+Y+3jeM6hT0DuUjbF8XE3e
VGsZfhJUq2WIvP4lLz4KWqIp+T8XeY54Lagze0WESwb9Hm2cFNQtaF32iAjX
hyK+WpFz/WXQHhFfs5Zyv2nQqkGrBfWO5xsVOf8bRzg+ePVNxM+IOnoFbcL6
q+Xcw9flajln9HGBWsoTcrR85B0QefsHdY3nSwYtFTR/Ldsn30aR54l43z3o
8aBeQXPgeS3Hh6wtU8uQ9patZZu0t3nkbRnpjkGtg36VJ32L5DfvFqtlnLna
sMh2W2C3iHbPDOoTz1pF+pdqlt8pnu0YdFOMeYV4/rfzA1/YL5rYH6LM1kHz
RfzCoHuC7g6aHPRh0AdBFwfdGzRJvhaWP6NI2yh2Ue7O3KHRI1ap5d5EvpVr
Ofektymyv+w7z0V816DFI/58hLsFLRHx3YvkbRfmsZFj7hTUL54vWMs9gT2r
hbxf05C5WrGW40PuVjKk7V2inp2DbuZ+FPVsGfRzNdv+wXXT2zL0dyPrIr1h
LXlH+qUod1s95+jliO9bZN82thzjHmR56psa7/8VtE7EewUtb109ailzzH9P
Q+Ru/ujjXpH/lmhjk5D9fSLeJcJN4vngiN/K/cU+0UYf55I9/bF4vwH3gxjL
JvaFuVq/lvKH3HU3pO2tipQTZHhvx0C5fQxZQzsFrRu0XtDOhtS3i2F3n7W2
DfK2Mr1jUDefTY62tuBOUM1nS5lvh1quJZ7tan3wZrugzsrAEMfJ2bWvIWfX
/kXmGRC0l/xmDIPtO2X2CNpA3u9pCO+2t27a3s02mYc7amn/417ykfs05yd7
83OeY8fbHjw7wRCenWhI+9xpcBANt65DTI8ssr+kz/P9YUHnG44w3wB5MNxw
e99vL88uCToyaJRldpDfhztnzNUFvhsZdDB3o5CdbSL+asTvivi2EZ8T8WGs
/4hPj/Aw9jf6EOGEyNMv4sfKO+RujONjTi6yvSOCTirStvps0HO1jGN/fd4Q
2yo6yucRfhHUiPhntUyPirL3RHpoLXUY3s8JalHP8EuIO1zQgbQba+F17qxB
i0T8Ne5hkffNCP8d4cGR57giecxcXigP6OvF9hfeHcv9JfIPi/hYx4R8HVDk
vemkoInx/l8Rnhx0dDyfFOmDIj5/Pfv1VdBoeTPIdnZ0DiY6r8zD3Yb05Ymg
64PGBT0edJ1p9tvxQTcE3aV8UL5vjHGzoBsj/qTlxlvuROfkesOxvh9r/6+y
f8cFXc4Ygo4JeivGcn+M4ZRa7vcXOp9XOt+UudpyyPs1hsj7ffXkB3241mcn
mhcesDbGFmmPf4Z3Eb8pwqeDLgs6yn5whz29mndi5oM9ZVfnZ2fT5Nu9luv4
Cvt+rCHPkMtRlmMdP+QYGPeDliH9gOMn/YhjY0yPGjKOxwzh65gifQhTannu
ITesuYetm/KT5Bnv7ndstHFf0KWmuYtz3+UuXMeOF89mBy0Y8f9G+HXQq84B
9b2vfDDPHyoTTwX9FDQj6G3LTLMc4d2W/1/Qa0Gv17LuV3xPONF8U2spW6Rf
rqW9mPSbjgE+vStf4Md7hsjpN7Y5PegNx0mZl2qpy02w7X/7brpjgn8v1nJv
Jd9M62Oc31mG+n4Mestxsi+8YLkVQ/anxXzszfkf8aHocMG/PSJ+e4Rb1PJO
+ax7NPvK85b/zD37Be+gz5iPOXjOfMxJuW99UkuZJf2V/IJ/39tH+PSDIX39
yPlBtr+Up5SZpexQ1xx5xLsvHBPpjy1HvoXqOa/w+APnf7LzjUwjd38pE7S5
SOT/1jlftJ4hvGxZz5D+rhDxv2uVeQ7/vy1HmytFugpeAdtuPest831s33k/
S378aZ9o+yLnFHkr6slH+L1APfmF3K1Yz7qogzm43bmfq2whU78ZIgu/GyL7
fxjS3n9quVaRxZXtL2totXqeH5wnS9ezXur71TK08UvQO6Z/lo/vKFsPytPW
9Swz13cP2x7z+oD5WtWzLvItVc+6SC9ZzzVJerl68gg+rmIf4c2qhvR1sXrO
CbKzbD3HSZkl6in31NWmnrzg3TL1HBPpxetZjnzYuH/R14Ht9kftzdhwf9IO
3S/yd+COGrR1UPugtYP6B3UKWidogGHnoO0Mu3AnsBz5dgjqGtQtaHvfk96o
nnOMHG1YTzkj3Ut5WsG6GTN9X7Oe5yUyspYh+9829ou+tvPZQqaR70V9v7Bp
+tTSejv6vqV9px14uaVtUN8m9ZwP5gH8AXiFEo9ACPagxC7wDtzLltpgsckO
0kYL3gE//07awvewzIa+B5+xvvWR7+Robz/uDUEnBe1relP7gvxuIV/o68b1
lG/62lu+ku5jXuy7fYPWCGobtJnPSJd3C/bzzX1PvSWeAwxDF3mDzPaop5wh
g8cG7Rk0MOj4oL2C9g46LmiQ6RN8tk/QocoN8jLacuQbEzQ4aEjQWEPGfJZr
n/vfIcof5YfVU0a3tY3e8mDXoO72cTfDnkEn2j5t7O6zDex7L2VwD5/1sk8b
We9A35PuKg9Yx8dYhjqOsj3q7uZ71v369dxfWIvr1XO/WNo+LiMfd7TMulIr
8/WUx8vZL0LWxk7mo76dDWlnF0PqHiUv6NNw+c36O8yQdXm0/WUMI3xGXw63
Deoe6TPSR9oG9R7h+12cW3jPWummvIBJAasD7gXsEPrLne7hq+rH2KSSeKk+
plfXT0F6Df0UpFcxL76KlQ3xbZyvzJb3XMLSdz3B9sDrIMfd0lw+r+1VKs04
NuoDj9bWNlu7VinTsH+Umc/3JZZtdd+V2KASK0QI/ueReuL5wHIt437B+l7J
vrM3fKh9CLtNTRvVL/+wc5V2L8LSHkb4t3a7P7T/YDfrrC0CWxe2sF+16/1p
vve0G2ELKm2UpJdzPyqxbIQlxq2H/V7avsOXErsGbg1/Ir5N/IMrOib2M3QX
dBj0Rvx/+BXxB3ZVLrbPYczjPfxYwH0TPGCJkQLfA74JbMWhljnMNH5F6sNP
iayBowBrAU4KzE+JpTrYus5W7thHBljfIcrUPpVmPxghfrMO9mMb53J7+9Je
Wd7Kd/QRXFNH26MMWIkBlWZcWH/f9bZuzoPO1ke+EgeJ/LEGBtsn1sAQ04vY
J9ZTS+vtaBn8eKyTJexriWvrbF8WNS/lwQ+2k9eL+Z66FnJsvFvYdki/FzJ1
atD+9WwH/+J+lWY/4r7yAx6Av9rMZ/Sb829/y2zl+xI/eIDv1jTf5ra9le+x
3WPfxm6+j/sK597JRd5FDqynLICzOc+5v8A0snChabBRYHxKjBXhVbYNruqU
SrNeii42yHyj7TfvT3ashCdVmvGRxzkm8G2nyYMzTA+3X+CDwF5daz8oP76S
WDDmdUwlcVnwa6zpfc03Vj6dZl8Ptb5zLHOd9Y61PjBdxzkOdEtwA9zjuM+h
56KzoleCZeHeV2JbfjEf/ZpcSTwVOBiwMuBijrYceij2iMNd2+CYwDOBrcLv
BmYO/RycINgrMFglXvAKeXqV6TH2lzGAuwKjVeKwCEts2kXOJfg6/HrYLkbZ
JmXAAIHFAJNxiLwBJweWD70bDB/lwTeBa8LmgF0Dm8ae9u8YZYX3E21zkmUG
2u9jK824MXBkpX0Eewk2ELB/2FuYp5sqid3DLoJtAxvH+dZ9l30El1Vi+gjB
y+0iL45QdsgLdgusI1i5W53/CZZHzsBxlvjNm227xFOCr9xHWZmH/6ulTQLb
BPdOMGjM4Sn294ZK7n/kRb5P9hlyMcz6SiwomDjwZuAhsc+AmzzI96yB3ax7
lHJA3vudM3Bn4M9OsC/z7CaVxK2VeNVH5XVpk6LfV8n7Eif4kP3Y1XaOrDTj
BScpI/fZ3mD3D+7C7yovrAFsQFe6NsAkfFRJ/Ao4FrAPT1VyPYCTAi8Fvunj
SmIXwDvhp5hlG+BxwNWAEQMb9mklfRmEn9gv3pf4PsJXnbdnrJM1AfYQ/N44
237CeX7WfODPPrON0a51xnCD/Z1cyTs762ekMjGl0oyFf9p8t9pX6gXv8YFl
mSdwQ+CHhsgzdAX0EHQDdA70kL6m9/cZOtPB9byPc0ff13LkG1rPfRtd7SBD
7u5neq/Hzsu9gH2cfR395wjHAC/A172nHL1l/5j7GaafcH5mKhdv+w4ZYr8r
Marv+O4x6ytxqe+a7yj3Oexut8lreMTeALYKnBWYuj+UCfCH4L5KLCQhWEVs
j9jzSts2IbZR+khZcGXgvsCOldhJQuqa6fvfnAPuT98pO2C/vrUflP/K8aO/
/+CYfzINHgzsFm1MNe+XjuNry79pue8rzfiwEi/2jfkm2t5Un3HXo17wk2A0
wW+yh4GfLLHDL8g79iqwliUW9SXz3WV9vLvOOWZO7rHtadZBG59VmjGan1uG
cczxHe2D8QTDCObxo0piGsEu/l1JPCRYvw8rzVjSJm3FlzhP4B7BR1ariXsE
A1mp5hqjbnCeYD7BTrKeW8T9er6mZp85PmHwAKdHuo0+5RKnCJ4GTCLxpZ1v
cGHgw8A3gl0EGwZeEawjmBz0b/wW2DuwyYDlAXsDvhFMI5gcMDDdfNfKdkiD
hwRv2VMbT6tqM16GkPrAN4KHBCe5hHWD72FPbG194B/pb3m+Em+tjNL3tso6
+LXVtSGV2EDu/dgU0M+Qv3aOucRagdUAjwU2hLteiWUBI4ItH5s+OBUwseBN
wJOcZF7Kg/sCAwaG5xTfUxfYMHBgYGDG2A74HjBUYKuGqTOAp+qg3gK+r739
hgfrKN/t7Td6RifLjHQdM7bFzMu7ftZd4hYJweyCTQPjA86rtK/BIzCo59QT
1wruDVwdODjwc2ABwdOB0QI3CD4S3CD4xRLnSAgOsa95KQ+2DnwZWLItfE9d
4O0G+66P7ZAG3wUGbGfncwvbX818lFvFejeWqHsv535z21/dMfRRFvqaBjsG
LqxcA8TBjIHFBX8LLhdsITg38I7gJMGngf/7I/r2ZsTPC3q7nnhj1mAL26ad
Jtumvw1DcKXnR/6VqrlWp0f83HpigwvfM6b3o/4X64lJnhnr9ZxIv1FPrPJH
9cSCVuP5t/XEmvZrSpxot6bEPILRBP+3byNxdeBHS/8rdojtxKmCjRzuM2wS
LcU1g3P+u0jMM/jnVeU3vAYfiMyADwMHBxYM3NeX+jfBth2rj5LzE58ld0z8
i//Vj4lP83V9nfwmBfwiOLhzlVPwYme6Js42DUaPPGAmwSCe47tDLUcarN8I
5xEM4IhqM5aWcLiyT93448AHgt8bqcyxJsFtgusD+wv+D98o93F8pfhe8bli
8wMLyviR/6P1sXLPHKX/lLs983iu+zwyMZ8ysrryMd8/5IP0Oc57RVkofMda
/t6zcLprk7MEWULukD/ksFB+3mukfCIzrDP2qRL7T1hi8wlLzD4h+x9r9zTL
4IvAN4LvaKg8Y/87z7MGOcY+O5/nARhJ5AFsZIlvZq7An/KMtVNiDcFogXN8
WHliLsHKgZkDEwjmkb0R3CA4yEerzdhEyh8WYzxUnNhNjcRNgi8EOweW7v5q
4uloBxwYeFQwoOAerxSnCQb0gEbiO+fWE896lX08JJ4NEw92EP64RuJGwbiC
naVu8KLgXS9XRun7bfKJs4JzYjvlDl5UMcwFLV6kvN7pmAe5rmh/iPOALILL
5TcM4IfB57JPl3vc8ZZZQkwvmN8dGon3vbKe+ArWNHZN8LpgctkTDvEZNqf+
zg/rDAwquNC7Iv5XI/GpYFLBx4GFZF7Bq97pegNHCgYUHCfrnzwlDpQQfCTY
Woya4FoPNx/v+V0Fv9PYqJq/3eitDHMeglcE44j/En8ntkZ8m/g4ZzuXYPfA
54FFXFUsEJhE/ND4oJ8zL+XBtoBxwZaJf/Rz6wLPiO0Sm+UztkMaPCN4O/Bs
YCTQpcFLlJjUZ5zb50xPtm5smWAryI9eWGJl0CMH+4w0OESwiW9E/qMjPkpM
KXeEp+3vk9b3vvI7wzGvq40D+2WJTwJDANYHbAY4AXBAYAbAE4D3AS8AbqDE
NlEeTBAYGzA33X1PXeCEdvBdN9shja0WrBNYphOjv8eLC122SNzlw84b/cV2
C+ZzhusUfCd40v84r7zH1gvOFDzru9W0KVM3eClwa2C2wMZ1to/ghG6W91Oq
zfha5GJS9GU58YhgBsHRgSFk/sHlgccDlwUWDtwd+CzwcGDhwBKCO1y0lvhJ
MJNg78DKkYe6wFLeEM8XqiWGEszjwrXEf2Cbw6YFBhVcKLgvsKLgR7+L+MkR
jhXPCTYT7B4YS/CqPzqvyDHtfe8c/2i6xF3RBnLMOLC53+a4kT+wmNQJLhCZ
BqvImI+MNg8XB846BA8MPnh0PDtGDPmnjcQ3L1kkxvlV1zB4b7CmrOs7XE8v
uKZftS6w5jxnL1gm6mjVSAz6VPsEXhNcKNhN8JZg9sCINimjJbYFHB99/twy
jKOFsjzafIPkMekS6/xVtRnrTBr8ITg5MF27NRJXDQYSbDU4WbCTYBzBzoEn
BI/ZyfkFOwiOrsQSEpY4x40ts4JrDFxdiS9k/bVxjZFe0brJV+Idebe85ViX
+EVW8Bl+j+VqzdjYZa2PdYjuh45esd4VXM/YOrEBlLhP3oGL7OMYwJF2VP5r
joF84E7Bm3Z2rY+yDfQJzifOanQJ7vHc39HTyjtUV8PydxvbWwa9Yt5vnqqp
O1GOOzp6ydbWtY51kw99Bj0E/aOj5fq57tetNeMlu9WacceE7FVgaMHNgi9l
H1rPMje4X7IHL+2c8I57EvoS96YSc8/+VOKSyYt/qY3zWXfu4Re4QfCB4OXY
dzhHD1EO9lIe2RPRIUusIiH3aLCFYB/B5oE5BIsIlq/EOFIXGEUwh+AAwR+C
UQRrV/5WAdznzs4/tpndxfSClQWLC84WTOOisXf+IGYI/CyYWfCNYHfB64Jp
BEsLjncbZXOQa6vEiXJOfCXWCNxRiYstcbJ7O2aw1eC2O9QSn8x6Yt9hrba1
7yVGua31HqO8giMHy8y+ep7Y8hvruU+tKt8byjHps7TRYN8Cr81z9o25znFr
5Z2ztsTADrbfezYSLwVuCrw3OOzVa82YWsqApeIuz77A70f2le9lvnl42iKf
MZZZlbSjYiN9opH3fu78+E9XaaQPFZscGDHwYCXGDjwPdlvwNeBssIE+ZBqb
6MOmL/c95UusXonde8R82Jcft17szU+Yxsb/pGnwk2AQwWmB6wNzhb8DG/9k
8+FfBKsEHgzsIpis8hsCPAMbhh/yRfOBdwXbhQ39Vt+DGQOnSZ34FPBhv2QZ
+gsWCZwRvm4wYi87NrBkYMvAcZR4PfBVJb4PvNV00xN9P1WeUq7E3BG+Js/e
sl54OsM0PH3bNLx81z6VOL935ek75oNP4ME+kqczzfeUz8CDTXAcL8nr980H
Tz8wDXYJfA64Hfg6y3rhF/rTJ/IIbFyJ+yP8zHrn+A5egJErsY2EX8n72dZF
X760zFTff+kcfmY+sBJgJsBTwNNvrJcxg+f6SX79aN9n+OzHWjN2ba68Bnf3
rXwEI/aLfJxrmjn5znzv+J42nnHcs2rNGLjf7O8C2g/hL5iyP+07ODLwZPCu
xPSVWL2K+ih6KWnm52/LM2bKlfhTQvLBYzB01At/0VVJl9hr0vAYXBZ9gkfg
s0jD0/nVbUvc3u/yAqwWmC3wbsw5GK0PHMcftWbMIvlKzCJpZPl7+QWvwSwh
N+B2mDOwL/APjA0YHcYGpgZsDfwGmwP2Bj6CzyFNn8DpkGY+eE95+kK5EotH
2Eaegl9bXp6Ca1tBnq5kusT2rSLvVjMNT1c2X4l1W1Oerm6++X3WVj62Mx+8
XsN8LXy/hnO2ivXCU/Bw7e03GKMe8g48XAfHBr6om+sNHF4n+djZNHztYrql
7zvK0271ZpxUV/PBs/WsF56ubxqedjdd4px6yrteptvYx+6OAzzAxvJ0Q/Ot
7LPeykQHxwmvNzLfSr4nzVpc0nGwlpayv/AOv1UfedfXNGPDt9VP3uPz2ly+
b2kanuLn2kreb275DpYrsYrbmA+e9bfeEk/Zv96MpxwgL8Ff7SDvdjINT7c3
H/wCx7VbvRkTtlO9GQO3q3zcw3wlVmxnebqraeRvU/kLT/e0TOm3GyrvwMYN
dGz4AveV9+DA9rL8Pqapb7Dp3r4fJE8pV/oYh5gPnv3LeuHp/qY3jzPxlCIx
IPBymH2Cdweb3to+gg9ZzXo3laeHmK/EwA1XJgY6Tnh9qPm28z3pC4u0oWD/
LnHb7C/MAdi4EY4HvONo+Q0WcJS8Pto0fDzGNO0daxq+g6sDT/dcPf1V2B4H
Wt+xzs8o88G/420P/p5gGpzOyfIKvoIZHSsfTzb9fD39ZNhLnzaOv+zZevo1
8ZNNtg/4y5izE23jCfPg92SexvjuL2zN9fQ5YbPEdokf7fcix3OOz/GfYUvF
/4nvCR8n/ifi+ALoA34B3lP+DMsdWOSdEvv2q+bBb4Jvjjo/xZcZeV6zLcZ4
rjwk/wXWT9vnW+eMesaxib1Vzz5ja6Uu2v0kwj+tE//c1xH/wPjr1o/v4IMi
68d/N6jIezG/IygxrPCI+rHxr1jNOi41P+DCD+vpO/i0nr6CDdGlsG3U0+/w
iWGveH5JkWX5zkCLIm2w2EW/jfg31sO4LnEsFxQZx/bHXnC48rpfI/Njw/xY
+yq/xy/i+R/1/H3+XdaPLfDZeD6hyN9LtzD/PNtsPG/y+eVF9h/75zVF1n1U
xL8pcozIxhpF+kpflVfYD7bkThTxHdRZumkjwu7wmXHsQk3R1nraiX6McFPj
v8Xzz4LWLJKH8Bmb53yNzEOdPxRZdlzENyvyN6yLcDdD7zP9S4RD1PFeLFIX
3Io7lHl4fn4j+3mL/WQs/P53P3VA9MGByiq6z3aOEd1sF/Og3/ENA3gEfw5S
ZvaP52cX6ZtgbfL8bmV+bsSHq9N+oT5LWyOMo0ezRvCjoHf9GvFD1I35XRY4
JPxD5e/QiC/cyH5PMH23eSmHjwmdGh3739ZPW/hf0KNHG8f3dFSRuC98UuNt
C52FOsFa0eY44+PNT/34bs60fnw9izZyjPh12JfA4nxcyT0HbAp7Eb8RBnsK
7pQ+gD3CH/Qf4+hP6IunF824W8KVIjymSEwY7XLmHeF6GNjIMuia75gHXQx8
K231MnzMOHsj2CD2TPbCJ+zb05V8/lQl+8tz9sm35Q86IHvqZMtOqeQYKVeW
mWwdk63zkUbKwwrYVYocwyR587T1sH+z37HXIT9gHvBt0Tf2U/bSs43/KRbi
OeNnFolnmuV+jF+WffIc8/xlnmeci3NtC/n8pJIYCcqyj4MV+M1nYCnK/Zv4
J/YBnzf79tm29YflwCKU5wBx6hvUyLqoB9zBy+ZZqJHrFNk+XT7QN/bvN83P
XsMezf7MuYA/D/8v/Z/uuBjja/bnQuPL2bdX5cMzleTPFMf+unkuMA9l6ecb
8nwv4+zz7LvsxZwvfOeKM2Alz58ZxvFxv2V+zsppzsu5Rfoa8TOe692Det5w
jOTHD0kezjT4Ar4EPq1nHHzIK0XaX9gTSIMb6e54OYd6OJb3HC/xmT7n7Jvp
GN81D2U569+XD18bB2dyqXX2lP8fGr/MOP70RxvJI3zfnGuEnHdNTXGWNKW8
/+0+znPezzLOd58+Mc53h8jDPn+xeeBJS/NwVhb85r2RvnzOwdnm5wzFV4qf
lHsd+APOR+xOc3wOr8AuwMudjIORYPxfyFv8iZTdyzvAHPnzUZF5sF/x7Evr
vNR4D+NgBjjHr7Y/fPfm/UbiCTibK+IK4CFnK77HPSO+cVNiEtpGOLmR3xvi
rnCFY6Rf3Be+lQ/9I9+WnIVNiZUBM1NiY8DJ4IufVaT/crTjxcePbXqeP7Ke
3+5g/PjxeT/S+OGO92f5M8KyIx0XZfFJk488R3g3mOt4r2C+TK/dlN8KWrUp
v53EPYT01ca5n/yvSD/sMbYFXgHMAbgWfLf4bfHj4s9lXOeZB9/o8ebh/WDz
UO5jeXus48KXOkKe4IM+1v7j1+b9OOz/+GiL5GvNc/zqiB8YNJ57onF82RdY
Fp/sNfiFzFP4njF+V6Sfm7scdyvijHGo96vLqnnfoj9XmqeF+bl7NRm/wnnk
DnadeSh3ovPO2M93jBfIK/BJ8OZq48gI/PhdebtWOQEnMBU/m76ta7GXF+m/
7hzx24r85hAhPm58W9eBHTDfLRGODLrPtslDX24v0seNDw0eLer7+61vqnkW
K5q/Z0QcP9WHUV878QNPyVviyBT+f+R2fDzr4nx9g926SH9ch0beX8E23MHd
MuiBiHf1Lkmej5xr8rSzLPWu632Yb92Mifi9RfpfuTPjdwYXcRx26yL9t/AU
HAY8vrvI+CPyto3vF27Ksm+ah3L4fL+Nem4EH+AcLOf6pU3iYDhujvc9zLN4
1PNHI/vzayP9iPgQ74r497RbpC8QXz4+/RHx/N9F5iPkOX7HafH8Qcc4Qt8j
3yNayviEiJ/dSF8td2nmEllgzf0vnt/qXNMG+AF8/bMayd+2psEA4JPk20/4
R/GNoiMQn64MkOflat611/A574mjR7zk/FLnp84deV5u5Hd+SN8ZYU/n925s
CEGPwgfnHXl+qEifMf7iDRx7e5/ja8cHj9+YPPigP/U9PmjmiTz44j9WzvEL
f9FIOcCPP6eRegh+auSik3XCpy7ylvnBl48fH7kiDiZnYiPnrbNtU/Zn57CL
PCbN+1/kd9d/8LjrP3iI3oJuNV2e0B9wrOhH6DLjzUP8xUaubcbSS/3r23h+
T8Q3lIevKnuM8VR5C/b1tUbycX352uMffe/h2In3dCyMYQNlk/HynG9A0Vf8
+vig8WGRB18VY+vl2GcXmQf/F/K0oWMnH3nwj/O+t3kYY2/5gH6Ingje4HXH
BQaBPOASSt1zY3lCXdSPXw49dBPL8n0kdEtwDjdYJ2V7N1JW+J7SZobkwWeH
fohuuJxlWUforQMsi86ITxB/85PGKYvfFvwGvlx4Ct4C2QRPQRwMBv3cWl6R
BptBOXi9pXOxmnnwyzGebeQVend/eTWlSB8/fsfVzYMvEp7jp8RHCa6ir2th
is/Xss88b6leTD1bqBdTfzv5MMA4sruV8sB3lrbzOToquio675eN9HGih6NP
7yJ/4A1x9Gv4AP5gMXm1uzyZ0cjvH+1sGn83edcxju+eezD3Xe7UnS2Lf/yF
In2W6PWMY6BxdP2Bjos83Lfxa35eZB/m1d1Iewd5tm3K7zKt1JQ8pU58oAua
B3sI9gXyYH/Yqin32S2a0i6xt3nebaRPGn80tokhxuHJYPlAH/Blg8O40zz4
qfs00n8N3/Bzk6e/ZfczD3YG8vAePuzvWPobx29PX4baH+wK2CCwV6B3gOvC
7wtWizh2gPui3QsbWe5286ObYHsZbLvYQqgTewi+5oOscxHjPJ8/eLFVI783
tGDEFwj6vpF2D3z/Qx0vtgzsGNgvwBtgz8CWAiYAOwa2k0OVK2RsuGXvsexQ
x3uYfJhknrLsCOP3Gi/xDCPl58WNxOGCv6V/YHEPqGU/yHOIdo9RtvVGkXlO
sw88P934UT4nz5HWOcM4PugLbQv+PGB+yvL+BPPTz6PtM20fJ0+weWBbOMM8
YItL28yxjmuSeagTW8to89xrnLJnWefZjp3fxGFTwh5E/Eb7fKJx/L/En/b9
CT7HnoNfHDsM9pMxjhGfLz51fJ7YQ462XcqTh/fYcMiDvQUb18HKFWWoE1/x
u0X6EPAR4FvAbo7NnGf4F/DdYPPA9jErrstbRD2nFZkPIn6yefitCLr/JY38
fh02KmxO2KBq2kPOsh7yY6PBfoKOzm850CXR49Hz0fFfNE/FOHhl7D9T7M/H
lbQDnFO2q35b4jypZxX3MOpnH0MXBnOOPvh4I/Vw0rMti/67teNn7IMbiXVH
Z0fHRU/G94EezG8G0PXAt6OXoiN84XPGgs7L7xZKXZk4ujA6Lro3Ou+lxtGL
0QnBexyp3kGdA82PDslzdE3w4uhhP6jroueia4IvRy+b7fOB5uf5TvLkQsf4
s/XQ/1+sHz0UTO81xuvq0+ig6GXoVuig/B4MnAT4CHQ+sM3ofVeqz11azW9q
Er9M/QZd6C51GnQY9JevG6n3Up57PdjrR73Lcf/mHsg3QdEB0BHQHa8vmnVT
8L4jrBN8cKlL3Wr966hv0S46H7+TKfU84uga6I9grK+wzuutB/2S5+i8N6lP
PKLOQT/RO5b2OX2+oZH4cHShFxr5DVDi6J7oQuhBnBVgBzk7OBs5GzgXpjTy
W7voZdjesNNhUzrAPJwL1zcSH04edCPqxB8BxhtdDL2B76miC6EHlToM+sti
8hy9stRLJzqWe+0/utfEolk/g+fc5Z9u5HdoaWMZ88CHv+Qtug/6783yGf4T
P1/9AJ3h7VInKFKn4H7CfYi7EHc08LLlvYw497F5Op9l4RX3Ce4Y4NM4+zln
O5mHu/HP6ingnF9p5LdM0XHGejfnro5+Bm6Xu+UbjbyPkuasB8fG2Xe8+gV1
3t5IvDT1YP/DDoi9cEIjca20h06BboYuPt25w566ov3cynGBM+b+tXxT3pG3
bMo70XPKA/hZ6kE3uU19kXgr46wF7lrcKblPIs83Fc02CeLYNvqZh/sU91Nw
afN5p6Mt7njcZcD2lfcd4p2MI5/9zQNPOnovg/99rQd8Z3kffN6528oxcl/d
2na5I2MHxTaK7e594/CQ3xbhD8M+ir+F3+lwPnJuE9/fs5gz7GbPWc5CzsGz
1CO4Y3N3mG6f2dOwwbHH8jsF7FnYjg4zz8HeX1517OXvgk717OU8vsk7w9vG
OUvftg/st9jC2BO4S3D/4B5yhPUcYPwN6+RuNk0Z4I5Eu8M8t99xLOw/H1sn
ZzJjxHfDecfveTgfsUVjV+3uXs3vR7DnzDXOXk14gM/PtSw2f9Ytth72B/DX
xLHncP7yu9CP9ZvMtK05toVtlvqwH1Fna+Ps7W3k///cJ+HJaM84+M+ZMs/X
WeS5iT37Q/tzfyOxC9w7HmjkfYLvavR1T1jUexpzcaN3obeUDXj4hXPHPRfM
K3da/CDEufNjH/2f8855xbmFPRB5/sI1zl2JOxP3ONYL+tuCyv/nrkfm8Uvn
l28Uoweih3IXwMd8mXZB2rpKOyVtXe29mLs1d0vs/d/IB8b11T9k7Cvr39V2
O3m//dJx4T9k7NwZ8UHhF8EnMs34OerW6N7sKegN6A/oQOjsnzmujRwj+il6
xzRllW81UxYdnfstvzcr761vul6wc2CrYf8cYv3cIdkjsdFgn8Fvg/8Gv9Nr
7pP4SvjmNnmWL/K+DM+5o75pfvwU6BboKiU+Gb6hf5ykjQg/9cHmQY/hW9aP
2C62B3D/pf0D3D82kB587zrKd29K/wHxK9Wl0C05OxgLcoPMYDPkLKef3Hf4
rSN+A+5B+KdZZ5x12Ps47/BF4JNABpA37NfYrvHD4LPBD4NOzneH0V/RTfGd
My+D7AO6HbZD9nf2dvTwFo30vyO32GO5O/G7M+LYtj+0XfZSfiNGu8jbhk1Z
tldT/j6Cfi5S5JpgjHeqP6FfIfPcd/EP9fLegg33vmr+XoM4dk6+/489sFWR
8kxZ5gjbzE72E3/+zvITfRS9tNzLibOH44OiLfxX2KXZR9hD2EuIY0PGtgf/
uYdgG29l/8fJf+6WrDX2dNY1+yVx7sjo6Og2yOTBxifYL+wm2ExYI9iSFlKe
sWFhv2IdcE6zP7NWWOelDWZ58/O7PGzpRZHfbG9nn1+0LPo7v3/BNsjd6mnz
/LuavMKe1ce1wnpgrE/4nHsI48Jvhe7wnXH2E+7Oa8kr7mvUz/3qoUbqVitU
8jzFB8kZ+mAjffdcY9mb2aPby9dlle0B8gE7H78F6+L88r8GunouIGsdlD2+
jd/RsU8xjpxg26R+9n9kDZlDlte2LD6CjeUze0sr8zCn+H3Wtk58KJ2sk3Oq
vX3AHou9+rVqYlqIsw9g324vb6+3/8Rftv/kx067jry6zjjtdrBdxjXedhk7
+/cf6jhgWnZWZgh3V7b5DVoPecidsKdtsWY3cV1jR+L3MPO+qd5IHy3+WfQD
ynJnvqCRthrkDXsNcfYf7troOdx5sSF3N//JttWuyDntLc/5DVpv5WqwfcDG
hf7Lbx3xp2O/xU7Nvs19Ffvz69X8JsMGygZ26fV9fqdx2sJWyFi4n19snejU
PGOcHbUbcI6jJ89y32O8ryuT6C/4FflNKb7FDdyfscG+3ciyB9Rz32YPn2eX
buRdnTFyH+M3BtwBwP8Tx0Yy2TRxzh3wBPQRnFg/1xHYq37yn75vI0/QVfFT
sleX9XK2vtPIe8gp9byLEMe2wZ2hj3OK/ZX9hD0Pmz99RZ94wzh9BkvG72HR
6wnRpbmbsefvZln2DeSKc4F+8vv5Usff3vxDGumvZ38mxAbB/QF7ALaGcnzb
OV7OKdrijENH4Pdo2Fdpjzj6AuFuPuf82td+8lsb9nPuXWDAdlSW0NF29Dl9
HKAMcMYNsA/Y+zeUD/jYh9hn7Jn8LgZbJb8NBxcCFoVvC4B5wIYz27FTJ2cE
64UzF91tPWUSexFl2dTYt5Fn9pNHbRfZZs8Dt1QVJ4adlLN1b9vijgGWYL9/
zMt+8qpvU54t7bwnwBPOdHAS+8jzWdZFPdRHnLOs/FYy/CTc0/Fix8BPiT59
k3H2AOwc2DvYz/GJ48++zDsqcc5xwoOMF8bxi+PbRfdnrxtnnP0TvRD/Gnoi
uj6+Se4S+NrQY9FhKY//veZ5yxnG+cVezv7OXs3/8aEe9smVrGdFz4LDzHOo
8Ws9mw60/+2sE18z/TrEvqEboyNzl8C3eIxzytxyt1jLvtM2PjX0X87Rlp51
R/ocPyk6OPvtHcZbeVZwbi0pb/l/SNwXwB5c6Xjvt17qXMe2GGNXy+InxUd5
uDykj6Ptcyf7SVsTHD9jx95wnLxd1/yMhf9fw3P2cPp4tGW7GG/r+Thc/qwl
r+AbvnXq5xzEHoO/k7vQOsbxX+MzHavM322cvZqzkbsy5yP3ZeL4MdGn+L0x
OjJ3fO76rFfkgvNsec8l4vgrqe9k6+xjWdY+Pll82Kt6p+DsX9/z6gTHy7qk
ftYmeThjOF82ME7+ntZf/q+ZU/7R/5edX+z2/B8C9HL0Puzm6NFbN+VdacWm
vMPg8+KM3sE49xl8Yef7/Dj7xrh29jn77ZLKCff5u1wjy3u2YlNg3Oxl+Jjm
/ea68MyuJT/Okp/cv7BxcwfjGyP0E/0UGwD9R7f6WjlkvdPmFbb7ifLKc34L
yZi5J19knLJN/s9H9iFs1MTZM7FVP24cWeIuxVrE3oYNDszBLcbv8m52nTK/
jvFbXKfcn9hPWIO3mAd5uFme0PerG8330GuU2y6WnWeHND/7GzZR9r42rpUb
lGfORs7LeTa4Ru6J5Jlk/nk+ffdK7jzsS+Nsa5hx2lrXOlmL3KXvsp/oghNd
j/j2sZ2xlpHZ25Rb1uPtylhP49j02IvYU1qZ5w6f/+m9BVsxmCnszNgz2W9Z
D+yxXYyvqmzfqTy3kp/k7WnfOrvu6PMjrgvuZA96jsEf5I41cbf1jDUO39a3
/gfcUynLXsrz08zPvIx3LAc6d+yB3GWws3C34axET8AfgwyjS4DlxZ/C9/tm
+dtT4s9U0gYFDnF57T/ob+xX3LXA26GvILP3Kbfc6bDvcK9DZh9RVtc0P3cV
7EvgC7HRPaY8o49yn+Vei25E3ifNjz+E/PhH+vmcewJn8aPWT3ninMud5AMy
A1b/BWUG+Uc3WMWzb4p5OhlHVsnP91yw1WO3J47tiJB37P8vGCfPcvaZfQNd
Ej6gD3ImogeWOs3TrjVwRHyPAxv1WvKTfaCzfWPNPm+fqZ9+k27tmcU+uaZ1
ogu1dd5fsn78As9ZlvB5448qW9xRT1Fm1nfs6GBreV5Ps2/s7eghHd0TiLM2
2avRzdZV5qe7ppDD16yT+xp3Pvxy6Df45tFx6De/TZhu/leU4Q0sS5z7J7gE
9CpsRNTDvREZ5o6OrxEZQ3/AN7mJ+bmvMt5p8orzCP2nvJ8S59xkjc+Sb12N
039sothG7/UOz32R+yDriLsa95yhxuvO74fyfJjxJZSrj5QlbKZ8ywbcKHsu
/hL2Z+R2pvzZ17a4lx5qWe5a+DNnKtv069NGM9brE+PczeEXdhj4Otvn8377
0ch7ERgnnn/jPs9dh73xcOOshUn2k7HPsE74yXp8Q5nBnsM5xxnHev+q0Yx3
IM75xRnLGbyDa4FvBbAnnOdzzuVFmhLbx/dKFvR7AujBYPT41jc2vR+86zBf
nOPcZdnbsceCG8AuSrnvrZ89nr3+Ps8szt1x3h3o8+HupXOU2+OtE9nmLMbG
zbmMbP/m+lrBPtEfcDj0jW/SsEbwM3G3AdvH94n4NhHYQuITfEb6Tu+Tn7u+
+E7Lz64vvpfInHFnW888yP9cy1JPe8tw34BvP1mW7yT9ZZ55d7tGYo6WEuv4
rmcuc8deisxRhv5+5hhpl37+aT3c+ecap33iK7pnnKoMbCH2Zhvx6dxRuJ/w
/6kL4+x3Vb83xZnHN9xL/hGHn4R14+Tj+1SsFWyV2PSHeabX/X+FvKfOe9WF
aQsdk7OFfnA2gdmDp+OUd9LfqDPO53PqXtD6kR3SyBJ71DwMTS2/cTG/efBX
NBwXfGvh9y3h8VJ+m55vCi3u/69c1v9l+Zhzgpy/6Z5MnLmj7kX1CXH2LWT9
vF/EPMj2ovaBOV/E9cL9Z6p7CzLD/sl9YE0x8Bs7DwuJb2jt94749hGyyzfw
+aYF/V/c7yAt3ZT5eEf/21jmB9cnfCLPkuYnXMr44o73XeeXd796pjf5+wW+
fcx3dW+pZN5W8qeN7T1mv1rbz55NiTnYwDaXtm/oRK3kM9/s4ntt11kP8cfd
wyrKSUvH8rh529hWZ/Fm29r3ZR1va9tiLPw2ABvR0AhXa8rf4633j3zk6dqU
fiC+g7hyU9r3+b+C/wdnlfPd
              "]], 
             Polygon3DBox[CompressedData["
1:eJwlkbsuRFEUhvfMnLODhCdwmXG/B+N+LZAYEpJJtMJ0GkpqrUYzBS1P5SFM
FHrfl1X8ybfXOmevf/270XlsP1RTSnVUoLGc0hCFr1pKy/A9OitTeqqkdAof
oxbnN/QCX6HvMmr2RlGbi/7QJLyOuvAd/Sl4GP1wd4/aODyDepwr9LfgE3QL
d9A0PId+6dc478L7qA++5v8V+BD1lzHT2dbsDVA7gi/Qaxk7ncML6J37qtR2
4CX0wfmZ/RbhzRzeP6ltwHs5ZvuN3+pRr3rSmzu4izs24TX9F5GJ2dTRTREe
9WqmZusOBzlmOGsQfyPwRA4vZn6ZYwd38c5GjgzN0ozMyjfwLZyxCm/n2M2M
zdoMzdKMZ33LHLPMpAXP53hbMzGbf7/7Lb8=
              "]]}, Annotation[#, "Charting`Private`Tag$1376668#1"]& ]]}, {}, {
          EdgeForm[], 
          GrayLevel[0.82], 
          GraphicsGroup3DBox[{
            Polygon3DBox[CompressedData["
1:eJwtUrtOQlEQPALn9NwPINBcCkn4BSorG+D6QEUjKBo1gKJGxVdiqyX4H/gL
8gc0foSJNMRYOZOdYjN79+7O2dndQqtX66acc6uwNOwkOJdknDsFjrxz77Ax
vmP530jKMqb4BPjhraYifwp/7u3fcsriM1gJ/iJjPnNy3vKYw7qKeAre8pgz
QB914KWQ8SrsIVjdY7DaiThb+G4sOdcGvkhLOVgd60uqYe0T8EK8A+mlLtaz
t0+9tRtM9x4wQvwP/k/a/r96y9lRThN4Eyx+C9yAbYFvE3gI+0VOB7itfNZx
nozz3Y5yjoB5r1lrH9RyFuz9L289VIP5NfKLh3HuaqR90Y/FUxYP99xUD9TX
1twOpLHorW9ipFq+Gyn+5m1u1N4LNtd+sJnktNO6ek2C7TSnWcXiJ+dYGvn2
WD0zfieuoeaRld5j6VzRfCLFJ7ol3kBRetkn6/LKGYrzPtju2eMzsKv+qaMv
/xy4r5nwpubqf6r7XeiWZrpbxte1a+48kfa1YLtnvAG8Cja7a805L70L3X1V
8yuI8x9d23HV
             "]], 
            Polygon3DBox[CompressedData["
1:eJwtjzsOQWEQhcfjzgpsQKNhESo1LhJX4RE3FB4h3iEhWkobsQabsAiJUlS+
yShO8t25c+Y/J9ubVidJEcmgNBqrSDEQKTCcwGX0Tok8mVXgLbrAD5Z3cBu9
+H9j1oH7qJkQ+TCL4aq698t3CK/Q1W7hX8N79Vt53juYF0X4c+xE8And4Ro7
Z/WZ/bM3W3Bd/bZ5GnAJxYFntuwz9S4h/jk80H82dobwSP22dbbulsmyWceN
eifrZp268EL9lnVYwkf17JbRsv4A1A4o1w==
             "]]}]}, {}, {}}, {{
          GrayLevel[0], 
          Line3DBox[CompressedData["
1:eJwl0kcypkEcB+AeaRhp5EzZChcQ9sLOymA1CznnHD8fBxAuwAUYoZQVFzAs
KDZcQLgAHmXx1P/XVV31637fLv871DL4I4Swzkl8CF+5wzyLDaFMrqedGXY5
4oY30m2uppkeNtjnkic+KIkJoZY/TLHNIf95IVVPJY1E4kK41d0lH5n31t1y
D7300c8AgwwxzAijjDHOBJNMMc0Ms8wxzwKLLLHMCqusEdV5pzsiH5sP1p1y
AxWk8OzcVxywxSSt1FDMu3s/csEeUbppooo0Xn2/a/6xwzRt1HGu41R3qbxl
bjpDiVxMEYUUkE8eueSQTRaZZPD76x+RRiopJPOLJBL5SQJqgpqgOrhC2Ij7
fg+f8+I5uw==
           "]], 
          
          Line3DBox[{1641, 1602, 1614, 1571, 1580, 1581, 1595, 1594, 1577, 
           1591, 1575, 1600, 1576, 1574, 1604, 1573, 1588, 1612, 1587, 1570, 
           1564, 1592, 1593, 1579, 1578, 1605, 1641}], 
          
          Line3DBox[{1666, 1603, 1615, 1586, 1601, 1569, 1599, 1584, 1596, 
           1597, 1582, 1567, 1610, 1611, 1607, 1609, 1608, 1565, 1589, 1590, 
           1572, 1566, 1598, 1568, 1613, 1585, 1666}], 
          
          Line3DBox[{1621, 1620, 1619, 1618, 1617, 1616, 1606, 1640, 1639, 
           1638, 1637, 1636, 1635, 1634, 1633, 1632, 1631, 1630, 1629, 1628, 
           1627, 1626, 1625, 1624, 1623, 1622, 1621}], 
          
          Line3DBox[{1660, 1659, 1658, 1657, 1656, 1655, 1654, 1653, 1652, 
           1651, 1650, 1649, 1648, 1647, 1646, 1645, 1644, 1643, 1642, 1583, 
           1667, 1665, 1664, 1663, 1662, 1661, 1660}]}}}, 
       VertexNormals -> CompressedData["
1:eJycvHc419//Py600aAQMssIDUoK9xBaKhqKSihRyi5NIaUhhLJ3hOxsOVZG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        "], VertexTextureCoordinates -> CompressedData["
1:eJyN3HnwXVVhwPHoKMTWUWJ1pFFbbVwLVsZx1/gqo2FwQ6SlAZcaRrHghtEZ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        "]], {}}, 
     Point3DBox[{0, 0, 2}]}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 6.}}, 
     PlotRangePadding -> {Automatic, Automatic, Automatic}, 
     Ticks -> {Automatic, Automatic, Automatic}}]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->9287734,ExpressionUUID->"6c746db0-572f-4519-9abd-2167cf65e33f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->46307688,ExpressionUUID->"84e98ed8-f351-4902-ba56-de9adf891c1a"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->120978240,ExpressionUUID->"74161bf8-ae4c-44f2-bcf6-d9c77f357a51"],

Cell[TextData[{
 "Does ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1a2bd1ca-60a2-4c5a-a16d-9368fcba8c7a"],
 " exist? No, for the same reason as in ",
 ButtonBox["Example 7.2",
  BaseStyle->"Hyperlink",
  ButtonFunction:>
   NotebookLocate[{
    "ComplexAnalysis-07_Limits-and-Continuity.nb", "Example72"}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]],
 ":"
}], "SolvedExampleNote",
 CellTags->"Example72",
 CellID->149262623,ExpressionUUID->"f0cc23b3-df1a-4a5d-8251-230620244805"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "z"}], "]"}], "/.", 
    RowBox[{"z", "->", 
     RowBox[{"1", "/", "w"}]}]}], ",", 
   RowBox[{"w", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->34824091,ExpressionUUID->"6c089450-2d53-4c2f-a575-3fe6b418c7c3"],

Cell[BoxData["Indeterminate"], "SolvedExampleOutput",
 CellID->428233766,ExpressionUUID->"6b6f35ec-46a5-456c-849e-4dde6a9cf4e1"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1536764508,ExpressionUUID->"02da9fec-affb-4a61-9b3e-f153628a7f60"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"225eb0bd-94b5-4773-80fc-e5a8b77512f9"],

Cell[TextData[{
 "Neighborhoods of infinity are those of the type ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "06cd7055-7a76-4e68-a6d9-ef6ed57a0ba7"],
 "."
}], "SummaryList",
 CellID->411962959,ExpressionUUID->"75a95141-fe8a-42f9-98c9-0306df689e89"],

Cell["The limit at infinity is defined by ", "SummaryList",
 CellID->184695939,ExpressionUUID->"b95b4124-4aba-489b-bc5f-54fbddf17ef3"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    RowBox[{"f", 
     RowBox[{"(", "z", ")"}]}]}], "=", 
   RowBox[{
    RowBox[{"A", " ", "\[DoubleLongLeftRightArrow]", 
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      RowBox[{"f", 
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}]}]}]}], "=", 
    RowBox[{"A", "."}]}]}], TraditionalForm]], "DisplayFormula",
 CellID->633252345,ExpressionUUID->"b2172105-4fc6-449a-94bb-5134a74c4b34"],

Cell["When a function tends to infinity, it means:", "SummaryList",
 CellID->258976763,ExpressionUUID->"efe4bd28-5cc2-4d2b-8313-a7197e319276"],

Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {
      RowBox[{
       RowBox[{
        UnderscriptBox["lim", 
         RowBox[{"z", "->", 
          SubscriptBox["z", "0"]}]], 
        RowBox[{"f", 
         RowBox[{"(", "z", ")"}]}]}], "=", 
       RowBox[{
        RowBox[{"\[Infinity]", " ", "\[DoubleLongLeftRightArrow]", 
         RowBox[{
          UnderscriptBox["lim", 
           RowBox[{"z", "->", 
            SubscriptBox["z", "0"]}]], 
          FractionBox["1", 
           RowBox[{"f", "(", "z", ")"}]]}]}], "=", "0"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{"Center"}}}], ","}], 
  TraditionalForm]], "DisplayFormula",
 CellID->378483072,ExpressionUUID->"b248052a-e7f1-42dd-a00f-78b75bd86c00"],

Cell[BoxData[
 FormBox[
  RowBox[{GridBox[{
     {
      RowBox[{
       RowBox[{
        UnderscriptBox["lim", 
         RowBox[{"z", "->", "\[Infinity]"}]], 
        RowBox[{"f", 
         RowBox[{"(", "z", ")"}]}]}], "=", 
       RowBox[{
        RowBox[{"\[Infinity]", " ", "\[DoubleLongLeftRightArrow]", 
         RowBox[{
          UnderscriptBox["lim", 
           RowBox[{"z", "->", "0"}]], 
          FractionBox["1", 
           RowBox[{"f", "(", 
            RowBox[{"1", "/", "z"}], ")"}]]}]}], "=", "0"}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{"Center"}}}], "."}], 
  TraditionalForm]], "DisplayFormula",
 CellID->225049880,ExpressionUUID->"7a122677-b6cb-4761-b17f-364e40c58b8f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->574022168,ExpressionUUID->"8d5f4497-1446-41f5-9e99-af1f213dfa4d"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "+", "3"}], 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["z", "2"]}], "-", "z", "+", "1"}]]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"3d63516f-a312-497f-8454-91796933a5e7"],
 "."
}], "Exercise",
 CellID->104512899,ExpressionUUID->"32223fa9-c863-4200-abb1-ed71f18e1199"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"c5eb776b-7376-4295-bb78-b17edff3ab36"],

Cell[TextData[{
 "Find the answer with ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->383535582,ExpressionUUID->"6c1e0dcd-93d6-4431-a59f-924065e2f1af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "+", "3"}], 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["z", "2"]}], "-", "z", "+", "1"}]], ",", 
   RowBox[{"z", "->", "ComplexInfinity"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "ExerciseInput",
 CellID->57896209,ExpressionUUID->"daed3be4-14e8-4cdc-8fa8-fce4ff94e9ba"],

Cell[BoxData[
 FractionBox["1", "2"]], "ExerciseOutput",
 CellID->81914636,ExpressionUUID->"c2885d8b-aedd-422f-8b0f-be90a71c3ee0"]
}, Open  ]],

Cell["\<\
Check the result by using the definition of limit at infinity:\
\>", "SolutionAnswer",
 CellID->416350283,ExpressionUUID->"85ff0d7d-1a9a-4040-aa81-f5514ee07d7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "+", "3"}], 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["z", "2"]}], "-", "z", "+", "1"}]], "/.", 
    RowBox[{"z", "->", 
     RowBox[{"1", "/", "w"}]}]}], ",", 
   RowBox[{"w", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "ExerciseInput",
 CellID->401509344,ExpressionUUID->"b00091fc-a3ff-4cb8-9822-f35cce9b7178"],

Cell[BoxData[
 FractionBox["1", "2"]], "ExerciseOutput",
 CellID->74218845,ExpressionUUID->"5a859aa2-8fd7-4429-9602-ac2bb0d73119"]
}, Open  ]],

Cell[TextData[{
 "A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1be9f86b-0735-4a01-852b-4a93b30561c8"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"1", "/", "z"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"266cd4ec-dfbf-46b3-9856-f1cbb3713f6d"],
 " looks as follows:"
}], "SolutionAnswer",
 CellID->539792714,ExpressionUUID->"8188d0de-ef2c-43ac-a369-1e749308cf72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], "+", "3"}], 
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox["z", "2"]}], "-", "z", "+", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "5"}], "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ComplexPlot3D", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["z", "2"]}]}], 
          RowBox[{"2", "-", "z", "+", 
           SuperscriptBox["z", "2"]}]], ",", 
         RowBox[{"{", 
          RowBox[{"z", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], "]"}], "]"}]}], "}"}], "]"}]}], 
   "}"}], "]"}]], "ExerciseInput",
 CellID->203346692,ExpressionUUID->"def3742a-b068-450e-a31a-0c2dc626856a"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXdcj93/xxvqJhGyyYiyd1Y3rmNm3DYZEbJHVvbIuskohJQyuxG3vZLV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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzNnXd0VcXa/+/6vWsJCAjqtVzdJ9JEmtQAoUkJICVIL9KrASnSpIMgVVEU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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnXfg19P3x9/TpkhmSVp2pVIZDWQ2lKSdUklpEyGyooQiW8hMIiERsiok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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkElOQkEQhkugFgbiGlaGK3EE2MOWFSwFEQzjYxJQphhxYPIMrLwFiS71
BH6Veosv/fV71dV/VzpbyOQjIpKEGCxUJI5MoyL3eB++8T4E+AauIUHNC2s7
9AxM8A4k8TIM8aXt4fdCpMa6h0sY02/H+gF/eIP6LX6AUswztPB3OOFFzt/g
t+p3WU0dn6n/y7F/xBthb+v5pJ7BsqSgi/fUazdwVsf8h/omPlLPYm+u4K/q
b7cMb/hKfTb2pjUc4SriM/mEL/W77NszPlDvHZDxDq+qu81gblnD2djMHvB/
5RM3jg==
             "]]}, Annotation[#, "Charting`Private`Tag$1378099#1"]& ]]}, {}, {
        
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJwtUjlOA0EQHNjp1KElMptHsAmZAyRCnkCMIIDMPMLR+gFkSGyALHEu97UC
i0vAcp8CiYgnUK2qoNQzPb3V1dXbnJyZmB4MIYwCCfBsIfRjCC+IR8AyzseI
j8A48ASsA13kNxBngTrwNxBCDbks8tyLrFlIyOffZshPif8X+TZiEZnPEeeV
b6BmznlxHzZyOs8YziXOrUh+z9fE0Va+itTsGpb05nnXWFO+0rfO73297idh
/1znTL3res+lrdDdNXeMtedGzV7vOr3XkPqtKLdq1Dhi1NOUt85/L28ejNyp
eFPdW9Lbkw8X8uFSMRXnqXw7A7akYdv4XmquV+MO3nwP0r0IbEpvgbinve4D
J0atpeZryJMr4z6ugRvjXLfGOV3jGuKn0dMvxAP9I4faZ6VddDWX9/7W3B3N
7X67Lzv6x3aNub78v5Onlbys5Oe76j4Q/wHyGG7n
            "]], 
           Polygon3DBox[CompressedData["
1:eJwtkDtOQlEQhgdlWksjHXcTbsDCxNIlWBMpoJN1wALsLGkMPgF5XYSAD0B5
iY9IYuUS+CZzii//f+/MmfOfiU6yx6dbIrIHSeiqyC4mjz7CBaThfFvkEv2C
P3yBnm98zfohB3WIIQozbNYUigmRI3QGr3BAbR8dwQDWzIv5N8QvoY/PoB/w
pF47RJ/hR/1uO/OLfwh3/3NHA62ErCV6rvBtKCc9Uwde1GdZBsvSDGetp4Uf
q2c743uCztWzW6YFeq0+ewdu8G+h1974jr9Vr6XQO1ipv8V29oneq9dsZ1Xo
qe/adtyHDQ7FP5o=
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0jVOYFEUBuCLu/tgoUUSSoIUSDFARzEMUECmwN3dZQMMbAA2gIRMCxtA
NgAbQDoqmI9QfDn/TV7yn/veK/sz0TEeEULYozkmhK/8Hh3CVVQIpXIDPSxx
zCUPvJHm4SraGeKAU2544pPiyBDq6GKBv5xzxwspeipopUbvLzsMyI1mr/Og
PMQwI4wyxjgTTDLFNDPMMsc8CyyyxDIrrLLGOhtsssU2O9Tq7NS9KzeZfc79
8k/KSebZ3recccg8v6mliA/3fuSaE/YZpI1KUnn1/u654IhFuqnnn44W3SVy
tVlvh2K5iEJ+UEA+eeSSQzZZZJJB+tc3IpUUkkkikQTiiSMWNUFNUB1cIdRF
f/8P/wEpVzSA
          "]], 
         Line3DBox[{1486, 1429, 1434, 1428, 1437, 1436, 1419, 1445, 1447, 
          1446, 1423, 1444, 1426, 1460, 1421, 1418, 1438, 1427, 1451, 1452, 
          1448, 1462, 1461, 1449, 1486}], 
         Line3DBox[{1509, 1430, 1441, 1440, 1415, 1455, 1439, 1454, 1453, 
          1431, 1432, 1416, 1435, 1457, 1456, 1442, 1422, 1458, 1459, 1443, 
          1417, 1420, 1433, 1425, 1509}], 
         Line3DBox[{1507, 1506, 1505, 1504, 1503, 1502, 1501, 1500, 1499, 
          1498, 1497, 1496, 1495, 1494, 1493, 1492, 1491, 1490, 1489, 1488, 
          1487, 1424, 1510, 1508, 1507}], 
         Line3DBox[{1474, 1473, 1472, 1471, 1470, 1469, 1468, 1467, 1466, 
          1465, 1464, 1463, 1450, 1485, 1484, 1483, 1482, 1481, 1480, 1479, 
          1478, 1477, 1476, 1475, 1474}]}}}, VertexNormals -> CompressedData["

1:eJx8vHc41+37P66kRWmSJIpUSmhQUWeIKNmFVGZmVkZmRvbee29JZMu4SHYy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       "], VertexTextureCoordinates -> CompressedData["
1:eJyF3HvQpmVdwPHVQBdPw6Z4WHWCUCZGSkjAMvCJGdzCE4hioCmuozaIZKKO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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-5., 5.}, {-5., 5.}, {-5., 5.}}, 
     PlotRangePadding -> {Automatic, Automatic, Automatic}, 
     Ticks -> {Automatic, Automatic, Automatic}}], 
   Graphics3DBox[{{
      GraphicsComplex3DBox[CompressedData["
1:eJytnXVUlUvU/0klVBoUUVRsATuwzrEVAwuxsFvE7sbA7u5C7A5E5XhtBRUF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       "], {{{
          Texture[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJy9nXV0VFfb9t/1fms9pTi1pzJDoS3S4gQiuLtD8FJcSnFaKG4FCoUWKw7F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              "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {144., 144.}, 
            PlotRange -> {{0, 144.}, {0, 144.}}]], 
          EdgeForm[None], 
          GraphicsGroup3DBox[
           TagBox[{
             Polygon3DBox[CompressedData["
1:eJxN3XW8fUXVBvBz7z3nnosKiHQIkiIYoDRIl1LSXdIh3d0poCIgqdKtgIAg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              "]], 
             Polygon3DBox[CompressedData["
1:eJwtlElsjVEUx2/6ve/du7IQYcNLRGJlaWWqoTrwTDWUBKFiSp9WhVpZm2ND
NQSJiKld2mBBQswbc+mGqIW2WiK6wMLvn38X/7zfOfd+955z7jlvanNbY2tV
CKEOFdCOFEJHDOE7xk64H27KQziThfAF/oNqUR/2bNbfwI9Zf8S3r+E9+BYV
Q6hBrfARfA9Y/4S64A58vQWfcRDeix4SwAd87XAD+gW/Z/8S+AT76rEncN5b
+DqagT0L3YAPoxJ8ing64ZdoXNExH4UXcMZk7HfYC+HlaBiehFYkn6mzlcMx
eB6+f/BpVA3fxzez4DNfwVvxFeAq1pvhs/imsN6AfQdehW+EWPqwG+Gn+CrB
MT6D5yefrZgU2yi+TrgLXY3OQbnUs+c2fFMx8W2/agxfROcy+47DF6LfRjUe
guckv81H1ufCy9DE3Dkr95/s2cddl9jzFb4X/XbKUbl2o2p4lP0vomusWutO
3b2UM4Yyn1lO3qO9T9BJeDG+Euefx66F16Np2L3YG+AK+py5R9QrqplqV+b3
L7qrGuZ+42vRNVAtVOPL0TkpN72R3mpl8luq5qp9TfJbKwbFoh5SLylmxa4Y
Fatq8CM6RsWqnquDn+ObXvCb6e2a8N3KnYNyWaP8sA+xtja5p9Xb+uYKvCt5
dgbx7YZbklk5K/eNybUoYW9Klng8vs3wuuSzdafuPoAGcs+MZkc9ol5pQQNj
NSuP9dBvfrdrZjPPsGZ5mN/2omdIs/Qt+tsKGoyWWDVX7bckx6IeV6+rh9XL
ynl1cg+qF9UjPfD+5NlVjIpVPaXe0p0j0TOiWVFM2+C25P8Gzbxm/z/+hJ24

              "]]}, Annotation[#, "Charting`Private`Tag$1378226#1"]& ]]}, {}, {
          GrayLevel[0.82], 
          EdgeForm[None], 
          GraphicsGroup3DBox[{
            Polygon3DBox[CompressedData["
1:eJxFl0tsVVUUhk97e/fe0lagUjWRetuiUmhLeQilAYegkhjQERNCIQwYSGHo
2IAkii/AB0qpLQNQYwCNj4Ey8AFMQIlQCrRIuUJJaS0iDBxIXR/rbxjcrH32
WWfv9fjXv9atW7/5pY7SLMs2lWRZzmQhZdmLIctqTZbHLJtkv89tf0HwZ9bF
fJYtLsuy2fabZPuNJndkrotOW5nvzbLfm7Zfbjqr8q4/aHKmyTfQtzte573J
aN+F6O9GTOesfXMl59/ODa6/zeRr7JvB+0zOs98HplNv35+w9zNMttsZZ6SD
Dehg26smt9qvmHPJ8zHTadH5C033Zpm/Y3+n6TWUuX3oNMjmzcH95F5sxeZd
tm4K7sPEHutNpl9h+8nWrba/Mfg79mcqFtzznu3Vmuw2WWo6edu/Zs8/23PO
5FcmW5LHcq7JL+35qtl41ORO+xVM50J0X7lrh3L0QPQ8zQ++/sz2a2x9y/b+
tO+fDX7f3/ZcMDme93W96dZF1ytXjipM/mR7/bZ32OQnwTGxx+7uCn7Hh7Z+
RvdxF3nYplxwD/dx7zz5Mt/kStvbFPyOyuTrB5Pb8FxwP1cF1ztoOpnJ5+2X
M1t7gmP1uG13SIdzyFWH1uyxft9su2Rnjti7AZPT7Pta2y+x/ZLg/uP7b/aO
QnjX5NPJMbzQZK09LzOdX0odY6dtPWbvlkTPa0fm/i2Xj8vlL2e2m1wbPJfY
2xQdr+AIPFFTJfKraN8ekG1leccR2AIzK+25OTjeiOv24Lb2kS9bn4uOA/Cw
2+Si5Ha1mvwveu10Ra+v3239l9k2J/iZYIZ7OfOqsN+iuA2aXBf83EsmV9hv
2NbVeV+X5tw//BzKuU9bgueYGtyiOqXOWlTL1MUc3dusNRwR834Osao2u4/Z
88PJcUXcwFi/aoQ4U1dFcUtT8lg2J/cR/4jnRvvuuuJGHaAPPl+wdbftLzW9
mcmx3GDydt73Ps2cz8A5nEbNXpf9fSbPCz9g8oLihuzTGoycFU7AQ6/4hzj3
6duczgHP1Fu/8NOnM9lfZzZcVJyJz0XFuVN24Qu12yu8VZmsDF77IyZv2G91
3u0cU0zAcyF6jO7kPb6cMyX4N+jPVjwbk9cMtXMkOnaWCT/4dVN80i8OhT+p
u2HVLGcNC0svR7eH/STOmshhq2xA/0re40++5ssXMH9GsQUL2EwdgRHOXFTm
ckTrrbKtKOzRS+D5e/FW/OGYc8FtXx89/sQW34gP3+Jrbby/xxoeGKWX0bfy
3k8K2qcW6sTRyLU6k/zyPCScZMovNcQ55Jdccy74fiw5t01P/h497spJYj/+
4j/xBBfgg3PgDzgODqlRHPDxhjCUEz7JKX12fKJecm5jveyvUXywfYb67BPJ
uapE9oMH6o1zPo7O92+b3KN4vBXd/lHZNqYeDw4HgnMKfILPo+p9+DegHE3T
Gp0T0X342mSN4vN4cp3L4kxyWq/+9Y74HF4/r9rE5gb1X2p5b3C8gc/JWoOT
FbINW+C/QdmwIfq6oFrmTu6g9uhz2H9TtUE8ua9E+/QTeLxDvMcaDmSe6VQt
kLsDym803/6xdUrOPatkc7tyDZbg183iWHi0Qnpz1Wfpt7eiY/SV5LMdfagu
+fyGDbPEbXDcLnEs8eN8anel6rckeS8qhSfVU+gtlaoteHix+k5bcnxS89Q0
sRyYwK646prOR+egZgbwQY2zpteOyTZ4HL+QzfIRboAH6AunbP+u7f2h9xs1
m+0Pzmtwep9iy/nfCktgKq948twWPd/DqpE14j6wGYTPaepN9KhB1dqwZjhm
uW+YkTS/MceB7VJx+1HVVm/0OBLPXHIctiiO8Bs5wq9dOofzyBUzx734Ru/B
3If91aov5rHbmtGfUl+jvzGzwfX0jO9kJ7MneF8t/IPty/KnUfxPX6VP0i+p
N2LTpu8HpAtWxxW3oegzFzXGmT36lvjv1nxyN/pcgh/g5V9xxRfReRguy2se
2SbOr0qOkYeS42VYfapJuGWW/j56/zkZPeer1Ud6lH/iOVWcSY+oUM2BW3BE
rOC4oLkO/CxR3FlvF34y9e6c8EAfY9ahBpnr2rReoBmSWZL8EDdwwtlLhM8p
yWfcqWBAfAVvndNcdz46VzXIx2rhlPg/ktyfR5NzOHMsvEpt4Nts/QfaJz/B
Vnm47y94wOeTituh6PxODJ5MXl9d6r/MQWAI36ipbvVZMLtX/ECvqFE/7RXO
f1Q8OsVRcCx8QV6oq7vqHWC2S5jvlM3o/6q6PqVz7mh+I598g36j/osSa3zH
R3iSWFEbxIt5g5jAt1H71Au5naT9gvoaMZzoteSXGtmr2sTH58SP9MFM+lWq
O/xiZqAv4hcz4Gmt1+i/Az0yiNvheDguE86Z48hlUXPIuHplq2KI78SAXOxR
r6kRt6wQD4Cx6eqP9MlDyu9H0WuMWqM/H9Z/uh+i95FG/WcnP1XKET5VCQNH
xIXH1QM36L8UNi8Xp49qZiW2BfWdouJA38dXzqoUDqn1deJI+s56rS9qPSQe
btdscVn3FpSXybIzE5fSozh7svIFD+wXVpfqGX34tUd465bOUs3MU6QPb6FD
HP8HlAQU5Q==
             "]], 
            Polygon3DBox[CompressedData["
1:eJwtks1LlFEUhw/zzrz3GuVHSplB4whKE2owQwP9AUG7sr2ErdqMs20t6EIo
aVxZQrQLAheV1qI2xcy4a1sQOQ6kga2yhUFoz48zix/vcz7ec+859xTu1e7M
Z8yshLLoZzC7n5pVYYtmH7C/EWiS9B7uxVclfgv1wcf48onZHPYJfA5fM2c2
gH0e7kF14suUOwVfR/PmZ+isNyhLfgH7CzxI/IV5jSH4SfCzF4j/hqfwvSRe
w56Gx9E29hpnTMBfg9dSzQbcQr+4/yzff+gaOcWs36ECr+DrUH+Jf/7AW2iU
WgfoLXyBnAr5z4mPwG18N+AO8Q34WfB/F9EhXCSnnPodr8Cno/eumZ2BIzrM
+Uw0G9VQrWN8n+GP6Af3uUn+LrwTPKYevsN76G7qOa/UKzVmUp/BGPwaX5J4
jnJ1J93N8K3D+8HfSj2+g4ejv5V6VK8l9NB8RuXoM5vtzugp30v4WuZn5uFH
+BoZn4lm0+i+Zxv7KHgP6kU79AnOdfdBM0ij5yhXO1QPPmPNWmdchDeDv4V6
WoUfRN8FnfkX+3Hw3nSmdkk7qd28jfqj74h2RT1dhS9H3xW9kd5qIHqudu4s
nETf/UntUHSJdWfd/T9ek2TZ
             "]]}]}, {}, {}}, {
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0rlOlFEUB/AzjMOiDCIiLjASO5nRWBiiiCaUg3ZWKJ2FwybD5ixuuBBt
bExcXkBewKUh0UJegOUFpLJTfADE35cpfjn/k+/e+537zZy5U745m4qIN0RL
RJJfN0fspSP65WuMU+cDX9nmL4ctPs8NJnnFKuvssE+uKWKYW1R5x2c2+UPW
ewqMciETcdYMJXnPDGv6CXmSKaaZ4R6zlJljngUWWeI+FarUqHPRWQPOfpCs
V7/p8+pD/aD8SH3ME5Z5yjOe84JL1hSsX5H3zfZdf1cukqed3+6zwSfeUmGM
K/Txz/f4yQ8+8pIJrnOODnZ91y2+8J4at7lKx4GIJjOcln+ZYcQMObmPXk5x
khMcp4eMPcfUon1pOaV260vqkP1H5S6O0Jn8psl7yNLOIQ7SRmvjLxLNybk4
Llw7XC0uZxoP/wNkbzit
          "]], 
         Line3DBox[{2106, 1954, 1977, 1942, 1927, 2011, 1955, 1994, 1993, 
          1995, 1957, 1956, 1944, 1928, 2028, 1949, 2018, 2019, 2020, 1929, 
          2001, 2002, 1984, 1983, 2003, 2004, 1985, 2039, 1930, 2005, 1932, 
          2030, 2031, 2021, 2033, 2032, 1933, 1996, 1963, 1964, 1990, 1962, 
          2012, 1931, 1950, 1961, 1960, 2029, 1959, 1979, 2027, 2025, 2026, 
          1958, 2038, 2037, 2043, 1978, 1943, 2106}], 
         Line3DBox[{2086, 2085, 2084, 2083, 2082, 2081, 2080, 2079, 2078, 
          2077, 2076, 2075, 2074, 2073, 2072, 2071, 2070, 2069, 2068, 2067, 
          2066, 2065, 2064, 2063, 2062, 2061, 2060, 2059, 2058, 2057, 2056, 
          2055, 2054, 2053, 2052, 2051, 2050, 2049, 2048, 2024, 2105, 2104, 
          2103, 2102, 2101, 2100, 2099, 2098, 2097, 2096, 2095, 2094, 2093, 
          2092, 2091, 2090, 2089, 2088, 2087, 2086}], 
         Line3DBox[{2168, 2034, 1946, 1967, 1997, 1980, 1981, 1968, 1987, 
          2017, 1986, 2006, 1982, 1970, 2022, 1971, 1988, 1952, 1939, 1973, 
          1992, 1975, 1974, 1953, 1941, 1976, 2023, 2047, 2046, 1940, 2010, 
          1938, 2040, 1989, 2009, 2007, 2008, 1972, 1937, 2000, 1936, 1948, 
          2035, 1951, 2045, 2036, 1935, 1947, 2044, 1991, 1969, 2013, 2014, 
          2015, 1998, 1999, 1966, 2016, 1934, 1945, 1965, 2041, 2168}], 
         Line3DBox[{2122, 2121, 2120, 2119, 2118, 2117, 2116, 2115, 2114, 
          2113, 2112, 2111, 2110, 2109, 2108, 2107, 2042, 2167, 2166, 2165, 
          2164, 2163, 2162, 2161, 2160, 2159, 2158, 2157, 2156, 2155, 2154, 
          2153, 2152, 2151, 2150, 2149, 2148, 2147, 2146, 2145, 2144, 2143, 
          2142, 2141, 2140, 2139, 2138, 2137, 2136, 2135, 2134, 2133, 2132, 
          2131, 2130, 2129, 2128, 2127, 2126, 2125, 2124, 2123, 2122}]}}, 
       VertexNormals -> CompressedData["
1:eJy8vGk0luHb9q1ISKhoNEYylSKKaJcxkSGahVI0GENUhhKiQRlS5igZQyRj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