(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    638281,      12494]
NotebookOptionsPosition[    485656,       9272]
NotebookOutlinePosition[    624015,      12222]
CellTagsIndexPosition[    623972,      12219]
WindowTitle->12. Fundamental Theorem for Complex Line Integrals | Essentials \
of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Fundamental Theorem for Complex Line Integrals"
}], "Section",
 CounterAssignments->{{"Section", 11}},
 CellID->592339613,ExpressionUUID->"3819e9ac-1a0a-4723-9f58-ebb579ae2e9a"],

Cell[CellGroupData[{

Cell["Review: Real Analysis", "Subsection",
 CellID->379010489,ExpressionUUID->"7a615b2f-a518-4a81-975b-d362cdc2635f"],

Cell["\<\
In calculus, the definite integral of a derivative only depends on the \
extremes of integration:\
\>", "Text",
 CellID->337483200,ExpressionUUID->"5a1cecd6-8020-4823-b4c9-bbe88105b4d5"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "b"], 
    RowBox[{
     RowBox[{"F", "'"}], 
     RowBox[{"(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "\[AlignmentMarker]", "=", 
   RowBox[{
    RowBox[{"F", "(", "b", ")"}], "-", 
    RowBox[{"F", "(", "a", ")"}]}]}], TraditionalForm]], "DisplayFormula",
 CellID->26550042,ExpressionUUID->"6c26770a-cb46-4026-b986-16d0d26d4809"],

Cell["\<\
This statement is called the fundamental theorem of calculus.\
\>", "Text",
 CellID->38504125,ExpressionUUID->"22a8971e-e959-4f03-aca9-9a84ff1b0049"],

Cell["\<\
In multivariable calculus, a similar theorem holds for line integrals:\
\>", "Text",
 CellID->38730901,ExpressionUUID->"077fb86f-ee44-41b7-9932-c5d3a693c0bd"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"\[Del]", "f"}], "\[CenterDot]", 
     RowBox[{"\[DifferentialD]", 
      StyleBox["r",
       FontWeight->"Bold"]}]}]}], "=", 
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      StyleBox["r",
       FontWeight->"Bold"], "(", "b", ")"}], ")"}], "-", 
    RowBox[{"f", "(", 
     RowBox[{
      StyleBox["r",
       FontWeight->"Bold"], "(", "a", ")"}], ")"}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->90659139,ExpressionUUID->"62c57a5c-aa2e-45bb-b24b-20faad3dc09f"],

Cell["\<\
The line integral of a function being zero over all closed paths is \
equivalent to the path independence of the integral of the function in a \
region.\
\>", "Text",
 CellID->392610201,ExpressionUUID->"6c0e0abc-a6d9-457f-a2bf-be891d532946"],

Cell["\<\
In this chapter, you will see how these ideas work for complex integrals.\
\>", "Text",
 CellID->219104598,ExpressionUUID->"6d9f45af-1808-4202-b6f7-6359118d6ce1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Path Independence for Contour Integrals", "Subsection",
 CellID->33104974,ExpressionUUID->"3c0e916b-a43a-49de-916f-dcdbf4de5a1a"],

Cell["\<\
Similarly to what happens in real vector analysis, sometimes the result of a \
complex contour integral only depends on what the endpoints of the path are, \
not on the specific path.\
\>", "Text",
 CellID->401938787,ExpressionUUID->"b03175c2-bb1e-4758-85fa-75545eeaf512"],

Cell["\<\
Under what conditions does this happen? A first answer is given by the \
fundamental theorem for line integrals.\
\>", "Text",
 CellID->42090823,ExpressionUUID->"f75060d6-017c-45f3-99a9-88a4469d525a"],

Cell[CellGroupData[{

Cell["Fundamental Theorem for Complex Line Integrals", "Subsubsection",
 CellID->355975948,ExpressionUUID->"2e3fa0fa-ec26-4ee9-a999-97366f3bd851"],

Cell["\<\
The fundamental theorem for contour integrals describes a necessary and \
sufficient condition for when a complex integral is path independent.\
\>", "Text",
 CellID->493879672,ExpressionUUID->"dac13197-f92c-405d-8794-d7b8dabce77d"],

Cell[TextData[{
 "Fundamental theorem for line integrals:",
 " The integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"de5e2baa-176a-44bd-951c-7aafd801e77d"],
 " for continuous ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "943072ef-a9fe-4ef7-b08c-94c55a10e40d"],
 " and path ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "\[Element]", "\[CapitalOmega]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"877e814f-db84-4051-bb1a-75843f89a99f"],
 " depends only on the endpoints of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bc0c5244-864f-4d34-abd1-2f1586f24df9"],
 " if and only if ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "90960325-3b17-41b7-8538-0e1ebbd796f7"],
 " is the derivative of an analytic function ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a6d91104-1a28-4ca0-9ef1-87188f1378a0"],
 " in ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2c757614-d6a5-4664-a5f7-c0bc08be2a02"],
 "."
}], "Text",
 CellID->157630104,ExpressionUUID->"0eb5130d-5e97-43a4-84a6-5fdd9aac1ebd"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{
       RGBColor[0.87, 0.94, 1], 
       EdgeForm[
        RGBColor[0.368417, 0.506779, 0.709798]], 
       FilledCurveBox[
        BSplineCurve[{{1, 1.7}, {0.5, 2.5}, {0.5, 5.5}, {1, 6.1}, {2, 8.5}, {
          3, 10.8}, {4, 11.1}, {5, 11.3}, {6, 11}, {6.7, 10}, {6.6, 9}, {6, 
          8}, {5.7, 7}, {5.8, 6}, {6, 5}, {6.4, 4}, {6.5, 3}, {6, 2}, {5, 
          1}, {4, 0.7}, {3, 0.6}, {2, 1}}, SplineClosed -> True]]}, 
      InsetBox[
       StyleBox[
       "\"\[CapitalOmega]\"", StripOnInput -> False, FontSize -> 12], {5, 10}, 
       NCache[
        ImageScaled[{
          Rational[1, 2], 
          Rational[1, 2]}], 
        ImageScaled[{0.5, 0.5}]]]}, 
     InterpretationBox[{
       TagBox[{{{}, {}, 
          TagBox[{
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2], 
            Opacity[1.], 
            FaceForm[
             Opacity[0.3]], 
            LineBox[CompressedData["
1:eJw92Hk4Vdv7AHDHUKacc9YxT6fRUKZSKmK9Gm7fSi4yiwwZSiLFLRJJuKUS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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.368417, 0.506779, 0.709798]], 
                Line[CompressedData["
1:eJw92Hk4Vdv7AHDHUKacc9YxT6fRUKZSKmK9Gm7fSi4yiwwZSiLFLRJJuKUS
ZUiDoSQarmvInDSY1VVIIUOFTJlFe5/vus/39/z2P+v5PGvv51nrfdd61957
mauvhTs/Hx+fIIOP79/2/y74X8OCfO0AEX+KhzsWrv4ZxmCBxK2Uiq/zPPxy
ZwqTIcCCwWnGmuZpHm6YFmPzL2JBpqCj0LMhHt5ZoDUoIM4CvpIrfw608XCy
dNXwIlkWBKXxyZ/K5WHrxW66ojosmNjbnhN+iIdFq9PNhJxZ0Mwtu6HtycOn
JI5p3HNhge7hXp+ugzwctTFCYIcbC37FlTwzdubhSE3fjAgPFoQ69QhzbXjY
JJ2dLeDDAqbG7iHdHTzcfdL2LV8QC1bJxFe9XM7DYupHfGfjWVDUYbXnWB+N
DZbc9m6pZkHlcJ9Dfg+Ns3LjLtrWssBW1oTx8zONp/k7Mj/VsUBw/X2RqA4a
u0QdfNPTSPqTfUUKW2hcKCU5MPKOBSW/zsYcqKFx9+ZVekLdLFDUPPGx6zGN
j2q+0dOZY4HM6xhhy0c09kj0LP/7JwtOC7u9qMuhcXoUB29YYAFe2N5VlkVj
8dZbuvo0C4rzX6XlpdP4k9q2nm2CbHC1nVQZSqCxXJLwXmsWG5QPvXYLC6Ox
7Goj2z/U2GDzWc9PM5TG7gXROePqbIju05n4FELjA+rtP73XsCGJ0WhlGEzj
z8oRUc5abCiNnL7GDqQxRDd47FrPhvGdUeU8bxp/SzilKw9s4Blki43b0ni0
oHX2qQ0bhjPeWzTYkPm/Uslaa8eG0dm+xQ+safybHd6XY8+GiTdlJR6WNP7o
UpV825ENe9bd3zL5O40DjT72R7ixQXpfV7DZThq/9MyINPNlg0RKs4H8RhpT
MZrP+yLZsEL/bPcSPRpvPalZejqaDeXBT1cLbKDxvtDnj6UusEG3MPzxxDoa
b5K6Gb7zEhsUCkW9v2rReKGptSM7ng1pZgnH5VRpbDhuaOeXyoaZo+omqio0
diu3GxJOJ/M/6vZKbxWNZwN7A9My2BDcE59kv4LGjd90gpoz2RC3zbG4gEtj
llrI2vWP2NDnuTO1WJbGTfcfO88Us2Fy/G+nHhka8/kej75cyga5m1+KRIm3
TYc8UClng+1SV+wqReP9x+3brCvZcD5hS8xKROPqu8M9ha/Z4Je1smdajMYW
+8z/CnjHhsH2I1a1fGR9JMwuHR0m8f6kMaFFnJqXbHR4lA1S4rIj13kU7s5U
sP42RvK7zv+XJ01hPbmn/l0TbDDdsiNI8ReFlxyTdG2aI/nz6St5PUvhUrEc
mUeCCJbvT1bcSrz3oUOz2iIEvV7nPlTMUDhnV0Pk3cUINsnPOJZNUzgg4mtH
iiiCtWfdk6onKcwyqjS8wELgET0Yr/yDwrmfbd+6KyL47L0y+MkYud9XXqVH
CcFpp5tFxsQvlp8O2M9FsOXRjg2HRyl8m5Jh7FuOYPL6Ja36YQrr15yqx2oI
whMrKz2IFxUJjpaok+eXbrgvQPy0iyuqtwZBi+BXX+MhCp/6SGtpaCFYV+Y7
2DBIYZM3qmtk15P53K6QPk7MLvklF78BwevQfQnyxApj5vwSGxFYnDG/6DNA
4WzjgGcC+gjCljzesaKfwucbPIdGMQKjmx4vG79Q+FyikfDLPQj8ZHjbzxGn
Ovxt5LQXgUz0OlN94udxTj5zpghmTFR/PuyjcNlG6zwNCwTOwcez7vaS+RwJ
7rlmiyCjSMLdg1jlg3e7lj2CV+MV99WJj/qH1dY4IGizV6jI76FwEVM87pcT
gjzlsVWd3RT+/sv9pZs7gv3mjqI5xI5DOiGUB4K9kfb+QcRhL8S0Er0QbJuv
qFciviDR/0edN4Lukoiy8c8U3uHXyzrog2AhLEG7mnh/cl8adRTBl6UOKYHE
ZtyRHB1/BDtPH4k3I2Z4/1hZdxyBa3ekuAZxicPYdbcABN9exYf1d1F4SqT1
QMJJBIM1X4Kqif9TWFSkHYSgtW1hKovY4muMSG0wglTFzZ5+xGse8OIWziCQ
fV/uZE38TiO5/loYgic3Xr03JG5nyf/SDEegk8urUSHObghdWX0OgbetggGb
+K+26u3O5xFo/lO9muqksO2Dsf0/IxEY789P/E4sVjx1JC4awUn92LPtxOvO
vD+x5gKClIeiA7XEBn4xJ15eRBA02VxXSnxlkfwRx0sI+n5PUn9CfLMoyGHm
MskPv6jgXeJaKmfrlVgEUSZtdjeIw/fmLFOLQ+Bw9MnqOOL13MC5yngEQ1nG
gReJf/suUm13HYGooeGWSGJVlYOXJhIQhHqbnw4nNtodvudiEgLFAE29MOK5
RhfGyhv/zj/sUCjxczW+J2UpCPiU5qX+7edvtre0ukXGt2WXwb/Pqxr7jo/c
RqBsoNR+njhpRD8yMhVBpO2qsQvEr0xLETed5LuFFXKVmNMxkvA0AwFj6nJ4
MvGk+Ftkdo+sp0lTXjpxg+2ByIFMBFVSfJOPiEU2Jo+HZSGgbpg7lhBLcoMt
5bIRaL+cMKwhdojmf5Kbg0CrOe5aG/Gu7xqM3Y8QFAv1OA8Qbyub3d37GEFd
93Y7CZIvucsHX6G/EczuvKS8gtg1xi4iIw8Bf2TD7s3EESXrDNYXIHjaR7Ue
IrZhRsdaFSHoWWujF0Ecc5in9a2Y1IO8gIU7xOlO5q8CSxG8+ettwSfikKDg
9sQKEg/7E9kLxC9aTW3UKsl+u5YjoETW69z6yYai52R8shm9bsSqzvfutL8k
+Rm2381P9seQ2ZFe+XoEclnYQZO4LiVCOacBgcYTyyY74vsl9hYGTQjcFjrb
C4ndOvXSHP5B4C6Dzpwl+1MrwftTShsZT6FS0lNiQ2ftljXtCMwdZthjxE5v
b70u/Yggk9W5wpXs7w6xY7GfOhFUP11ZZEvqg/ibR8/kv5D4ihnWJBP3Z50L
zP6KoFzp2YYO4r75Hyv1+xF4dTapupP6Yu0X7WX3ndQzi+cHor5S2DLM80Li
DwTLVjdYvCOOnS+gVCYQOAV3pi79RmGhZ9FehZMIEr/1mDwjvnkld2XLDNnP
3tId4qTe1Ws16iEKwfWkn7fdiAU+zrun0SQeP0NLSomj0pJjdPg4sDx3+7wv
qZd/jC6tNBXggF+0xbWB7xTecoBTeUGEAxu17o7Jkfrtm3B0GUOaA3JJe2rP
EP/jMrdwQoYD5TqP674Qy2SONg3IcuBG18Nt+aT+V72VdXqrwAHlZ9WLXcbJ
etHVXHZnGQcCVHTSx6co/Ob39E0Gmhy4l3nyoxc5bzauFk1+rMWBGembej3E
YQ7PxpfpcGBvUbBdCzmfdOZFYoR1ObAttmVr/RyF4x4OurVs4kCU2l8+I+S8
OyDCveOznQOCLddfB1IUrmn2P9e9gwNCuoGYQc5HqX+mDuzbyYEPk1qxcuT8
rMsIZmzezYHfFIoybRg03qji9E3AjAPR174eE1lEY4UXVRuSHDhwve5qkzGL
xoIh3p0l/hzYPdZpRhFfKc2b3XOCA1807iqWsGn8vi5MuDOAA18fuF7ZyKHx
It87S3gnOaD9iNFuLE3jTOsH97aGcgAPJj6NV6SxY/8L0ZqLHFAouXdy9Woa
968rTKy/y4G/chlXJdbQOGOhNsQhkwP2wdMDk8Qaazn2Q/c5ILnFy7pKk8bL
ZgymRXOIA94rH11L+v3SCnblcqC1JXEpYzONnQ/F7n9VzgHxlt0VaBeNQ6+l
ri1o5cAl+SgX8d00vuiau1/9AweuqOahxXtoXHpj6sytdg7c3Np+i2dC4wg9
0QfnOzigpGppRpnRuCdhc7xVLwfG54tHVtvReOrdl/LJEQ402PzYufcwjTuF
TZzUhSRBTG+/Z+oVGgdl7bM/pSsJIo1O1i2xNK64vXehb70kKFjabRaLI/F5
ZBVvqicJVOW2j6eu0Vg3MDprxWZJUFkwOeuaTONDwds8G40kgVZU03bJIO93
lu7rubsl4UNAiQsqovEba2G+MmdJKDsh3633hcYmDiYT7ZckQVJFrUDVjIdF
pPc/NhqTBInWP48wXpD3/110bOAuKRBIaRruUuGDcbHalLBsYp13exOO8cEO
0+CYWWFpoL6a5meW8YGNNcfP3Fka/B67ajhxGDB/2M18Q4U0RAwLGVZ5MSDz
7r5KfikZ0BO1+H6xlgFHN8Rd4frLgP5hIcNdGvzwIOSMekyDDFx1is/WvsgP
6+ZWjS9wZSH/tarVjSl+kO8SyTt0ShYKHj3PMLYTgDF3K43xelmQCGvW5pUL
QGON6YppBTnIz3ToiNUUhMw7D1ZUH5OD6+nqPvWJgsAz9AqZqpSDo/fOz69b
IgS3Gl6+r5OSh/O3Ne1LwoXg/sJiSsFLHiRc6nNtJ4RgJi1zXjhfHlK4Qosu
+CyCJ3IDOEBIAZDRs4LI3kWgvjrx420zBRBKfTcoZrMYmpqlzCOTFaDnyJm3
4W2LoUpAp/l1vwIkG4iLYXNhmNp4yoKnrQj+y0/F6rcJg5W0b+yxEEWICMi/
oWstAnF1ylYLLxXBZ6Gw3fO9CLiHHLjjIaoEfW+3DKw9IAoekW5Zg5ZKIJ3i
0BLUKwoRQdclSpOVwKI+zS/VXwxa+5FrdJ8SXLJWbRXgF4fmIc1Vm9cow+y1
pheH/hSH1m+iT3x8lEGio2BqQWkJ2G/vHgvNVwZJk3MSZtlLoG7+7Pu1M8qA
Pgrfcd4gAUVn74zQG7hAz0f+51ujBCgP7i2+HMSFq15HOsscmeBQn794tJgL
L4rVD291ZgI6YfT34lIuPCAfYjWuTKhj+JgvK+NC3ieFsneeTNiaXO5jWcGF
8T0HDw4fY8KRfabKJVVcMNHyYq6IZEJmo77zuXouzG17X3HvMRPk0jJ9l3Ry
yfer/CetXCYs3rQ0d1UXF55cK+AU5TFBVtG93/AzF5IH+9rriphwP8lq3dEe
LjikdRSPVzHhFj1h3PSVC2/N177e3saED9Yau2JGuVAV/jTzTTsTTr/+3pYx
xgXHRp8M+w4mWD6Ncij9wYXnv7uM+/Uw4d6gi/H3CS7YHV7++fYQE4bXFEft
nOVCTW1/6upRJljApXKnOS5sOld3pvAHE2Z8dw0E/CS+23W5aZoJUyNnFO8u
cKHXQey5/RwT3qfPryr9xYX8JSbM/nnSj91WNlNcKHO5feo4xYTkuWKZQZr7
//8J/tcuhf8C/Cykfg==
                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{1.8665765877901028`, 4.}, {4., 8.}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {1.8665765877901028`, 4.}, 
              "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
              "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.368417, 0.506779, 0.709798]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> 
              False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{1.8665765877901028`, 4.}, {4., 8.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {1.8665765877901028`, 4.}, 
             "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
             "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.368417, 0.506779, 0.709798]], 
            Line[CompressedData["
1:eJw92Hk4Vdv7AHDHUKacc9YxT6fRUKZSKmK9Gm7fSi4yiwwZSiLFLRJJuKUS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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{1.8665765877901028`, 4.}, {4., 8.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {1.8665765877901028`, 4.}, 
          "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
          "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.368417, 0.506779, 0.709798]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.08], 
      ArrowBox[{{2.4436272978225997`, 6.239251258311313}, {
       2.4978204017104844`, 6.323871099174995}}]}, 
     InterpretationBox[{
       TagBox[{{{}, {}, 
          TagBox[{
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2], 
            Opacity[1.], 
            FaceForm[
             Opacity[0.3]], 
            LineBox[CompressedData["
1:eJw92Xc4ln/UAPBnmBnPzbPIeJBZSSiJ5CgjIxXKKCNlVkKaZCa0rSSRlZUW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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.368417, 0.506779, 0.709798]], 
                Line[CompressedData["
1:eJw92Xc4ln/UAPBnmBnPzbPIeJBZSSiJ5CgjIxXKKCNlVkKaZCa0rSSRlZUW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                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{2., 4.205219546600555}, {3.985031834872257, 
               8.}}, "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {2., 3.985031834872257}, 
              "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
              "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.368417, 0.506779, 0.709798]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> 
              False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{2., 4.205219546600555}, {3.985031834872257, 
              8.}}, "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {2., 3.985031834872257}, 
             "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
             "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.368417, 0.506779, 0.709798]], 
            Line[CompressedData["
1:eJw92Xc4ln/UAPBnmBnPzbPIeJBZSSiJ5CgjIxXKKCNlVkKaZCa0rSSRlZUW
CkUpaciPFIWSnZ2MSlbvcb3v9frnuT7Xw32f+/s933POfZF1PWzlRiGRSH1k
Emnx8/9+4H8/CPgS3HaYj0qCIz029LR/NHh1RdJPhIcEeQ+bqzegg/1jFRUE
SfDDzXkucIEGNpY2NtZiJGgtvv+OPE+DEJ+xI7WrSbBsUrt3+QwN1G/Tmr5o
kqBWu672w18alF8MqRrVIsH3AzcsA9Hcpnx6dD0SqLX9Ua2fpsH28o9P9puS
oCChzDzwDw1yoqgxsq4k2HV4G9fkFA1S7w5F6bqRIJOi/iwbrXaJX3iXJwnE
w13Ytui+wLy7F3xIoBd552blJManEaZNCiTBnL0UETdBA13RbUqkBBKErdjk
Z/eTBp3bgo/IJZGg408YmYEesfvPwOg6CaTvyai9H6NBT+OZfRfSSTAtFeJq
hl4eerhI5g4JSh+3qxj/oMFcU6/W3lckCP5G27B7hAZ3+dMLG96SgDzHqpBA
K6kaP9z4HwlOxyn9+jpMg4q+4tPSTSQwTvCO24sOzSzv6O0iAbxPPXlkCNf3
g2+XbR8JKq+zXqxHt+g2+b8bwPs/yKomoX86kzaXjJHg7GrSxJVBGpT5x128
MI/rZz0wWz5AgzsT28hcZDJUe6oInUUn/j5FDuIiQ3NazGcrdLTaqVuHBMiw
91Nh0o9+GvAPP/e1FSeDhl12zSp07f3r5YZrycB+f7a1sY8GRfUR1S+1ybB8
157T+ehSbkdrow1kgGz3tjC0236gbtlMBi8Kp2oNeq/X4WvWO8jw+rahTlYv
DTY3n3712YYMG22/54ai27L1ju+xI0NE2ut6J7QHQ8PZw5kMJt6WW6TQSo/j
9CIOkYH2NW4os4cG9968PyrgRwY+c1u5s+iwyDDVhAAyJKi4073RZvdSxHMD
yaB501N2Dfq7z9qt6iFkWD/stHEpmhWeufAknAxFxC0GGR28xbb1QwwZPuxQ
HH3fTQM7yway80UyHJTbP1aOpm0NzBm+QgZrrT8FWWivtgZXnmtkIMXJWZ5E
Pyun3TDIIUPffLGhKlqTZauUmE+GOc06NSn0m3xxycFCMgwoR1QIoZttnkJc
MRmOlTY+/tlFg4jdfw73PyKDeuSBlT3ot8ftefUek+HvyTz9T+hLDcaHBqvI
0AuE+VO0yYyyLrwkg7yJ3uZitKB49+Gk12TI/irSnoc+mSUlMFaL15e4LHYT
vUokStCkngwFUo9+JaKft749crORDEbzUQEX0Z8DYmG6Cfe/iTsxEs3nEOO/
o4UM/ypW2wajp0iO/Le/kEGnkf/JcbRGVykXdwcZ6CviqvzQ3v5G+527yZDV
W+txEK268oHS4z4yjLEf3vdAy57NsWQOkkG4Y0fKPvS3P+9bfEfIQLbJVHJB
c/39UlM3hs93JXenI3ol+QhTZZIMj++5KuxG/40yeB35mwzJtU1X7dFU7sm2
7r9kiJldyLdDD4xpbId5Mlzf0+20aJOqQsU0EgXaeEMfLvrJqIDTHJUCtuzW
O4t/3zU2+8uBlwLSt36YLF7fbqPyj/IlFNj47nnE4v2fbN9gLC5MgRdZ1nsX
48tL65k/IUKByi23Ohfjr7j5ltHKoMC6plKyJzrxXfK59WIU2Oxy4eXi89cl
/3O6LkGBIR55Ff/FeMNzYmelKQDdIWon0M2z6+Uc5ShgKZjxeXF9vwW7Ec8U
KLDsZrTsWbRQiAbXmZUUsPe4d/0q+tDwcv5+NQq0vP/5dnE/T+h7eZtpUsBK
YP56PprntBuI6lAgaPcpuWfoVztPlRzTo4DFrdGWWnTGVHjEF6DAFuXV6p/R
q/dJqeeYUEBhk9LrcbS0HA9N0JwCHKFvXCTMz5TIK8b+lhQIPenZK4yuE9N+
rr+TAq/S5qJXocvXFVJz7Sjw+jyfpT66oPVwmvAeCniHj5RsR0tFxn/55orr
PwWeR9GfTpudNnGnwLPs4pJotFDLwtH7XhSIeEXJuoF2vSx0IMKXAk2vddxe
odulzzioBlNgZcrqUFk8n6pzkcFRYRQQvvLKeT3a73HKZNcZCnSX/WnbgebV
fdmQdJ4CZ/5Tyz6DDpqyMuFNpsAJBiN8HJ0Wpje87wbG/zh9ozDWE76ip+1V
Nylg0PP+6gp0r6PxncAcCvR3cZZ6ortiSkaniinwIDfx4AD6WGvqvHUprp/f
bp4lWM/yL6XbFz/G9RX4T3clmnG+eMr/OQVKPpee9EfLBtjf/VVPgf963hjw
fKeB45aJQb4hCtTZPqeaYz2tsZG4enCUAtcqq+yOof3N98W8/0kBwytBppno
BjsRw+Q/FPDKUl2YRRemqJFXcVMhIy6u5BHWa2XqC5v9MlTYtGz7LtPF+s+K
2Fq3jApPR+I8gtEFyZ7Ra5SokPQsk1GCpm91reZeRQX/PNVNsthfftIdjG7r
UqHomtAwBfsRZ1+eJsWWCr1h3wJ6RmlAicnzLnOggkenc6oS9jNFn+RBHycq
sGJNTx9EX61+VPnVjQpja3fvm0YvK68qfhJAhfS8G2/EsF9WPF0afDaOChX8
z6cDsb86DZ/mMrhKheYr7tfeoScFj9fNJlOBnRYzJoH92CMogeOfQQWRa1tf
PkV7LXd8vfc+FTrkJ3iFftHgdtGqlxb1VCg9+Wn6HfZ/C4MtawQ+UGGD1ySh
hPNB4syNjrfNVOgTzeoMR5/X2fvdpJ0K+V3PcjbgPPFPSCvfeIQK3VGM+jKc
PwYnxG9bLuEC4Qarcx9xPjmuKdoSacwFJ6hr95pSCJCwvRm2xIwLzBxvXg1G
W/mWWl/eygWkKSHJErTcqJ5vsg0XZP77y5KhElA1mRx2z5ULXLMl/5tFP96u
V9kdzAXyb7l0X3ATwKtcsHNfKRcs5CvInucn4ITKUd+Rx1xgUSNnV4u+fuhY
/tGnXHDXfm0H/xK0UmNAdA0XaDFT22PQ40btHvc+csHscGTKRQECakz+HaP8
5ML8WSuZLUTA/o09vx8rc0OExMc1QqIEcD2v3hy/khv81j9I2INOS/qVe2A1
N1wreGBViK4JyiuR1OaGUEPJQQs6AQbv3n4MMeGG2OjbIXEMAkJTxupM3bmh
s8PcRo1N4JzjVzuYxQ08ei7p9yQJcN2RMLaJwwMV+rpDtcoEpBh3Nwks44GM
6Hu/1VQIKKqwKm1S5IHEo/xOiehZspC/+yoeGPnoq7d3OQEd9dSSGD0eUKzj
6M+vIKDJpUu0YTcPGP29bGmsRsDJr/ERVtd44F/55kxJLQLahmK9FUV4ofOI
hUGbIQGyjesLCxi80McVXrrViABF4xfNq8R4wT9+Iug52rhEvUOLwwt6L8/+
yjfG/YwueWGkygvhGudSg7cQUGySHOlkitdbfeStlgUBhyftak6G8cIJ1dMJ
3dYY776QUKNxXqANjzCU9xNgWxZfpdjFB1dmRf+UnCdgZduPN1UV/HD52JKZ
7w8J+DkTVFh4aQlsyPw2uq6XAK2aUJMFbwE4Muh4lUdSBLh6HYV1VguChpy1
sNVOEdislK/vMSsIkrFq62WTRYCnmlyZ+EgIhksrxQO7RCD8YdS/RjthyDCf
vSGzXBSmSbviP/0VhgHt4wFxwaLgd3jTTmJOGHiWJna1hIhC2EkfZdMFYYgP
+pDOCROFJ1zryWUUrCs/7zDvRojCumNhR84JYB2s+N1SHy0Kb8tXiFKksG+r
m77ixIvCnLvRxHp9Gvh0P9H/lysKVcfPEY9DaXCKtqKu5IMoJOd4TXSE0+Bg
zuU3K5tEgZQZk8UViXO5TYzCrWZR0FDs8zOLwbn60UZyUosoxJ06Vfw6lgbu
7S/1Q76Jgj/PzUPRmTiH8LW27h0SBcKwuZVTjX3AZvLsYQodYjoVyk3wPWPE
/dRwoSYdWpdE315Fxn2y3flm7Vo6VB1a+o+B525+H4PyTIsO3vtiazvwnHld
jTn/YT0dxspEpw/xEtDVvHt8Xp8O+13LPh8UJkDefrbTzYIOb/bozP2SIOC8
PpV+0o0O2o4+h2EtAYUkqdbMa3QYFZyGKfSpDdklCtfpkJlWH5eLeadQsPxz
XgoduKL/lQpqE7BmOuPnvTQ6OFlVCDbqYF56r/F7nk0Hw2oSZRNgHvOWR4/f
p8MQ151Vr8wIeCb4khb5Fq9/+MdOb3MCCm6MRBDv6JBe4UYRxrzbYBKoc6OO
DkyJ+GHrrVgX3q7zKWmgw/i7NdS2bQT8uqg00t9MB9PZCa8GGwIiAopkd3fT
ITLEStnFCf8+e9rPb5YOTy8avCM7E6DOozegOE+H32JZPZlooxPLcr8u0CG6
P/JojwsBCTwSC1soDPBRNVzmtI8AB5kEAQV+BpSn+n1Y70nApZG8wCEWAyQl
Kd/O+xHgwqfhma/BgCW74YqkP+7PgZ4kjzUM2Caj+bQQ3XXHYYmiFgNoIQsX
3x0h4Jtxx6Os9QyI35lDoR4jIFZWRiUTGCCVx3fQ/hQBFOlA09uWDJAdi0m9
FU7AC+sD6qPeDAjW8MqWiiAgK3DzhsSDDDjS7q6XiM6oWxek58OAUXcXxYgz
BNwy/Xr9kh8Dnqg/b7E/S0Dg1gFLzRMM0J7s7J6IIWC5d77v2UgG8J37mN90
hYBSt9LLVukMGNbw36wfS8AYn9IUKZMBL1RMAvLR+R9Go+9lMUBsQetGUBwB
O9cPbBLKZcDE8ix+6QQ8x+P7pmrvMGCoyyZ4axIBU9P0ldueMEBLxW7EOZWA
Q5/0ek5+YsC6z8J9T9CSuhnHFVoY4BU4eZqdRoDgw761ja0M4FrfeeU/tLF4
uJpKOwOSzp/SX5tOQPAfcfqXHgb8zDDrmsgk4OCd7UHG4wy4ri5uqJyH+UZX
+6IjyATeO+MXTqA1CwXdh4WYUFX88tQbtEuHBesGDf1r0sgjH/PR0O37vCgT
fC0L0tILsA678BpUizPBzF04kHIH61hwSpWNEhPE6wNGIh7g+XGzG43dxITK
P4oz9WgJ64rJA4ZM+LRtX6Z4EQH2uz7IGBszYT5tY/Ud9BeS448ZUyac2fTV
vLGYgO2p/TvcdzBh22BSFvcjAjbfyxU1dGGCu6DmS/nHBFBFwtYvDWZCeKR8
+D40rWFd5XQIE4Rqqzoz0N6VPXs/hzGB521lqNQTApwu7RNKjGRCj5LiDqKC
gNtl8/0iF5kgU5Lg1FtJgMiQX4TIDSaYOApEmDwn4HMyr6jSYybQos5bHEd/
UciSG3zCBJtT9m9y0IKVv8xuVzJBhxX8mesFAfrNy7vVnjPhTayRXSVaS6lK
UecNEzKW5PPIvMTztWyy3+oTE7avK+I1Rw9+CXdlteB6xZ6tPIp+VRUw0drK
hD751Vtq0WtbBnfsbWfCfd3u9sM1BKiUcQn49TLh/bVU1TuvCIgXtjdKmGCC
NYXn0ke0CN9lLvspJlyZe3TrL3rbtg+fpH4zQXoudtbwNfbxy8PFuX+Z0J0Y
ZdSCVt1uY1FBYkF1jsXR8TcEeOY4NA8Is8D1o/jusVr8fS3xzZYrWGA/c8GL
9g73K+C5rq4qC76/8VdWQ18bszBSVmNBsM7eskPoR7e2naNosuB+yE7FfnSC
8YdPpTosiBWdc39Xh/VVYON2BTMWpN91TviOLuP5DHQLFih57T1K/o+AO467
9cmWLHBhL7HWQvMre7q172BBuGdQ+A307f0u26/as2DG0eibQz16ld6JJV4s
cGjf7uiHXt28Rf2vNwuWTijER6F7f5v86j/IgoPlf5YVoy8Uu6bW+LLAp6Gm
g6cB56YtLZ5hJ1hQz1+wVAJNX9ga4HuKBeTEUSE19JuNujHOQSy4EOgovQv9
2eNpvV4oC3YlHxxJR7+8tLZ6JooFxt6fx4rQEu/XModiWHDCZN2dl+jY2+qH
W89jfFwZu/rRF7WddMous0DlWp6XynucuzrtlI8lscApb6AiHX1N0nj9ZA4L
30Pb1t1FN/X09rfmscDmu63/E3TmG/uUqgIWWP8rUmxGt6mIEpfusqDDe2Uc
dyMBdZSPK1QeseCI4CNhEfRTH+05WhkLsmLNLCTR5GOC73+Xs6Bb10ZAA+2Y
aBH2spIF+tUqaQ7o4IZN3C41LBBaa6a8H82q1xgxfs2CxIBfAYfQz/pUmlXf
suDjjsJdIeilN08WztaxgDnEHolCb3I5cb27ngXiRvWGV9A2J2tj3r7H/dP+
AuloxYmSA0lNLDjwLrY3F23lN+kY/An3n2VtcQ+9Napxu1sL+s1Dz0p0zKOy
dZpfWZC3Q7ftE1qnbQt3Qw8LLu2KyvqKHnmd/OdhHwv2zjtqdKOVa+UGb/Sz
oFfhQMYIWt5c5a33MMaTSQ4fR28btCjdMcqCrQ+7lX+j+9umsrTHWFCWaFi7
gNb8I3WCZ5IFxx0VaigfCNhlYOQ8OsWCTQ+IKB70Syk9w6bfLNh9SYtYgla/
0aL4ZJoFfBOvXITQdnVDPJkzLIhuHT9BoH9UGvdGz7Fg2aZ+Ozr6Xuizp4cX
MD9VPpNYaEt55au7SGwoOj/uK4Y+U2btrUdhg6qHe/5SNP9Wpq48FxsaytwK
JNFXx/X5BHjY8PU0J0Aa3f0wp3Gclw1JxdU8MuisfMmkFn42bLYNd5VFx30N
sHsmwAYF9/NRcmhvp3BmjhAbQtuFjy1Df90oVn+BxoZrjzeskkfnXOQPPyLC
hrszhvcXHeSgou5AZwN/iu3colkPzb4Akw1D17JFFdBqdyBUic2G+PHdk4vf
n7L6xhEWZ8PWzDtpiy4q+V0+tZQNtnlvGYu+1LPH8oskG36ROncu3r/6R8/X
59JsOJgv47oYn9B3J7c8GTZ0eFptW4y/Y+vllT5ybLg10C68+HweTuo/NOXZ
ECY+lL74/BnpMgV/FdigNpLKLYUOT9V2eabEBv8dMnoSi+v3zYaIVGEDj841
E3G04vD2x2Yr2KBix/WJgWZc3jXbvIoNWoeNHUTRH9ex41JWsyGxTryIhiYa
FeT2arDBRIpo50e3T19XHVnLBvZE6P3FfHBKLst7sI4NG95L21HR+pZxksfX
s8HvwGn5OcynabGBUbIeG6hLLphOo6tBwvz1Rjb0BezbPIVuSD+RfgHwfv58
j4bRUaoymmxDNnR/X6bWj152UNb3qxEbgoeyTi/mdyfPk+wMEzbccD2U0oJO
C1CYWmHOhptlXAc+ouPt7wiPW7Dhh8sNoh4d/VRX5pHlYjye316gnVe2KYEV
GxYqHkYXoHvjZGqs7dngOBMrmI2WOtIRL7abDdxEjkcqWlIizK59Dxs0okSy
L6Mtvre9cHdhw+TfdTr+6KL9w+yTHmy4askM8kZvCa6O1fNiQzjZ9aor+kCu
A4lyAPPZqM/GCr3KYs2Tcz5sqLvWPK+G7mlLyko5yob0Nb68SujfBw48cz7O
hsclD4ak0HY2bfXLTqLlazYKoAcsp1/fDsL1EfOV7cX65/B9HedJBBsu/B2Y
uISeP95u8DmWDXodYcXh6AKH+YyqeMw30W7TY2hey5af+YmYnwLPpveg6124
HYKS8foN9vuV0YWCijtlMtjQrhSVVor1Wn3V+5r999lQE/j1Qx6a5dk0a1HE
BqVyemcyuvT6bam1JWyo6OqLDFzsD6eV5LnL2NDiUk/WQ1OeN+hmP2PD5z1O
b8uw//i6+qR+q8f4tGhJueiC49yXa96zAWQHN15dtETSwcIPmB8fHaSOoMNt
/hs++YkNAZv42CvQAt5Bs/RvbPCa4QgmYD+UVrrhYTjKBvkzA35m2E9bF5Lv
XxUQAz71XeJa6Dgt9b8OQmLwwOt6hiz6b5C5OocmBvmPvtpMv1s8bwq+uaJi
cMr0pUk2+sWMjkqpuBiMZM96/8b+31O+8vJHJTH4WTPKfeYtzoPDrntIhmKg
ssa3+wC61Mog64WRGNT+PJVhjXYzi247YyIG5y86v5ZDz10/uJTfXAxcOzqL
n+F8ERxn20lYicF9rXSJKZw/drvPn5NyEYOHxlNnTHBeGZ6vuLgiSAwOjL6x
W4kOrJeV6DmNz3NnREQE7WLkcf16iBgYnrdZ04bz0MzKez78EWLQuUNA9wC6
X/Snz/cYMbA4YbA7GuenwoecptQkMXC7pwn3cB7bty7chVIsBqIT5h5FT7Ff
qxXPZg2KQfLUVfFLaGXHkJ2nhzGeldr3vdAaYXnpu0bFIC706TkZNFVzjQD/
uBh0ncv6fQHnxc+TchqHpsVgTy2zzAXnSZ8bw/UavOKw9G+D9VQ5vq8sTQot
lheH5nWbQxtKsD7bVedecBaHe+bUVH2cnxvDZDTb6sSBxLNmNBHn+wJ5z+Di
TUvh2Krsba34fjGdorty8/2lMHbFubMU31eYESs6d0pIQETs/Z/zARifU0ql
9mUJyMu0n6N6YH7EfUg0mJUAnUtbH7bbYn2TjGqy9pWEofJXl/VMcZ42fOPl
1iMJo3rLZpZswPyQTWqctpSCDB3JwGOrCKjN7ysjvZQCC4304QdyBPbs3JCn
6tKQXhLdoy2G/Su7R7g3VRr61LcSwmjpkKbXj29KQ7RXjU0PG/Pv07aLsRnS
cDlNVOES2rCIb6P+LWnw2jjc28vC5+c+ti6lUBoMzH+MXWXivH7mU+zOJ9Kw
3ZSaI0THeUbAW7apRRosduYom+L79VxeSewMnQOhmYXqSug3Sh5zJUwOvBTp
t+JGJzAGjhxmc2AwXfXbcyGcr739YnqXcsD33DHxDeheD49tDbIc0G68uWqt
IM6nBQJbc9U44LMvbrXOEpwfnS/CXnMOCMyP2EugFRceWklt5cBvAcXUOX6c
J1Mv+bdackCxydPvGdqAdvDLDisOlLFyrIzRSctSrTbbc8Dpdi7Vno+ABWFq
u7IHB4K28J+O4yGg+d/a+IVwDhADA7VH0AzK3OafZzhguHyp7k709vghnu6z
HBgofRIuhu5M8ayuOceBxi7yg3RuAviaZ9iX4jgQWNmYXMqF6+kmqC2XyYGh
hfXSJCrW9+Goa3bPORAvpdXWRyHA7JhzhkU1B/oHmx6/Q3+zS66EGg6MFxoO
JaHjnHavVnnLAb1Xk1QN9PfZ5aTZ9xygxL/WOETG9Z69sCOzkwPvjqYZ7ER3
lcglJnXjep+HY3poUkHpyIVeDtz1X71DGC0QztNyfIADZNarhgckrN8nzNIt
f3LgX+C8cAraI2vkjOEE3t82IeAM2ijo62mdKQ4w4pcX2y5+719XqDiN603Z
dsEArbOys1tyhgOqS6QurEAn/OepSp/jAF09t4iJfibve4F/gfP//zf+308Z
+B8vC5w9
             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{2., 4.205219546600555}, {3.985031834872257, 8.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {2., 3.985031834872257}, "ImageSize" -> {360, 432}, 
          "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
          Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.368417, 0.506779, 0.709798]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {{
       RGBColor[0.368417, 0.506779, 0.709798], 
       Arrowheads[0.08], 
       ArrowBox[{{4.164444983582529, 5.26317564760381}, {4.180513252499701, 
        5.363662630259497}}]}, {
       RGBColor[1, 0.5, 0.5], 
       PointSize[Medium], 
       PointBox[{2, 4}]}, {
       RGBColor[1, 0.5, 0.5], 
       PointSize[Medium], 
       PointBox[{4, 8}]}, 
      InsetBox[
       StyleBox[
       "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\
\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
        12], {2, 6}, 
       NCache[
        ImageScaled[{
          Rational[2, 3], 0}], 
        ImageScaled[{0.6666666666666666, 0}]]], 
      InsetBox[
       StyleBox[
       "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\
\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
        12], {5, 5}, 
       NCache[
        ImageScaled[{
          Rational[3, 4], 
          Rational[1, 2]}], 
        ImageScaled[{0.75, 0.5}]]]}}, ImageSize -> Small], 
   "\"Fig. 1. Two curves contained in the region \[CapitalOmega], having the \
same endpoints. \""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->322622981,ExpressionUUID->"ddbef80e-cf2f-4eb0-9ef3-0d51ae86c71f"],

Cell["Proof: Using the chain rule:", "Text",
 CellID->25582749,ExpressionUUID->"722482e4-4604-4832-abf5-96183655b550"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SubscriptBox["\[Integral]", "C"], 
       RowBox[{"f", 
        RowBox[{"(", "z", ")"}], 
        RowBox[{"\[DifferentialD]", "z"}]}]}], "\[AlignmentMarker]", "=", 
      RowBox[{
       SubscriptBox["\[Integral]", "C"], 
       RowBox[{
        RowBox[{"F", "'"}], 
        RowBox[{"(", "z", ")"}], 
        RowBox[{"\[DifferentialD]", "z"}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Integral]", "r"], "s"], 
        RowBox[{
         RowBox[{"F", "'"}], 
         RowBox[{"(", 
          RowBox[{"\[Rho]", 
           RowBox[{"(", "t", ")"}]}], ")"}], 
         RowBox[{"\[Rho]", "'"}], 
         RowBox[{"(", "t", ")"}], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Integral]", "r"], "s"], 
        RowBox[{
         FractionBox["d", 
          RowBox[{"d", " ", "t"}]], 
         RowBox[{"F", "(", 
          RowBox[{"\[Rho]", 
           RowBox[{"(", "t", ")"}]}], ")"}], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{"F", "(", 
         RowBox[{"\[Rho]", "(", "s", ")"}], ")"}], "-", 
        RowBox[{
         RowBox[{"F", "(", 
          RowBox[{"\[Rho]", "(", "r", ")"}], ")"}], "."}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->182179116,ExpressionUUID->"b91310e2-9b2a-4edc-9be2-0a8a4c712981"],

Cell["\<\
This formula also gives an alternate way to compute the contour integral if \
the conditions demanded by the theorem are met.\
\>", "Text",
 CellID->587641253,ExpressionUUID->"19127ca4-2686-48b7-a6a5-4c096a613675"],

Cell["We won\[CloseCurlyQuote]t see the proof of the converse.", "Text",
 CellID->2537213,ExpressionUUID->"54c2149b-47a6-4f11-8606-32051eb9b708"],

Cell[TextData[{
 "You will see later that in this scenario ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "dec11ee6-d6f8-4533-8d12-d583c4c4728e"],
 " is also analytic, because all derivatives of an analytic function are \
analytic, as will be proven later."
}], "Text",
 CellID->260535210,ExpressionUUID->"79913545-a341-467a-bdcb-6406c9504a2c"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->54763527,ExpressionUUID->"0246105c-c8f0-402f-8f06-81e93b9a1c15"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", 
      RowBox[{"-", "2"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8ba40320-1f20-477d-8482-caa462544aa6"],
 " if ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b84c84bb-6cbb-48a3-b12d-d350323931d8"],
 " is the arc of a circle of radius 1 from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "69e90979-762b-456d-9845-9dd68aeb0ade"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"95b2d6c3-2756-48f6-8e78-26c8e782612a"],
 ", centered at 0:"
}], "SolvedExampleNote",
 CellID->127010386,ExpressionUUID->"531634c3-2c6d-4c69-8143-2ce695812204"],

Cell["1) directly", "SolvedExampleNote",
 CellID->134933130,ExpressionUUID->"8064f416-1515-45cf-a72f-5e155fa29d3a"],

Cell["2) using the fundamental theorem for line integrals", \
"SolvedExampleNote",
 CellID->759427217,ExpressionUUID->"18f88e33-428c-4eb2-991b-3c095ddd6680"],

Cell[TextData[{
 "To answer the first question, parametrize the path as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    SuperscriptBox["e", 
     RowBox[{"\[ImaginaryI]", " ", "t"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d75fecc8-c05f-4b10-89c5-ac7cddd61121"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", 
      RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ca7133fa-9217-457b-b198-b11928fc8148"],
 ". Then,"
}], "SolvedExampleNote",
 CellID->142312647,ExpressionUUID->"370ce942-e214-471d-84b0-1d184846117f"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", 
      RowBox[{"-", "2"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", 
      RowBox[{"\[Pi]", "/", "2"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "t"}]], 
      "\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "t"}]]}], 
      SubsuperscriptBox["|", "0", 
       RowBox[{"\[Pi]", "/", "2"}]]}], "=", 
     RowBox[{
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["\[Pi]", "2"]}], "\[ImaginaryI]"}]]}], "=", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", "."}]}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"aa317d58-1384-44b3-8a64-0f415a4f22cc"]], \
"SolvedExampleNote",
 CellID->368313309,ExpressionUUID->"603d1468-6a7e-41c0-9ac5-58cfdfb06895"],

Cell[TextData[{
 "To answer the second, notice that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"-", "2"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4dfada4d-2906-4d29-a62e-321f8c1076bf"],
 " is the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "/", "z"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9740d1fa-db00-4c4e-be4d-90a915340b3e"],
 ", so you can use the fundamental theorem, because the contour does not \
intersect 0 and is not a closed curve containing 0, which is the only point \
where either function is not analytic. So:"
}], "SolvedExampleNote",
 CellID->220523542,ExpressionUUID->"875261e1-c1d2-4faa-9582-2388f7a4c801"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", 
      RowBox[{"-", "2"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox["1", "\[ImaginaryI]"]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", "."}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"c9792ba2-d991-4b9d-b3b0-cc5e16f3d408"]], \
"SolvedExampleNote",
 CellID->502280093,ExpressionUUID->"6e07ce85-2564-4b87-ab52-5c154d71b183"],

Cell[TextData[{
 "Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->69745742,ExpressionUUID->"a62334a4-7b42-4da4-a076-8a041aceaa8b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"-", "2"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->834731088,ExpressionUUID->"aa867e3b-aac0-484c-8158-8ba128190b98"],

Cell[BoxData[
 RowBox[{"1", "+", "\[ImaginaryI]"}]], "SolvedExampleOutput",
 CellID->415500299,ExpressionUUID->"cfb6d3a5-7730-430c-8720-92b3fae289bc"]
}, Open  ]],

Cell["Plot the function and the contour:", "SolvedExampleNote",
 CellID->214213369,ExpressionUUID->"487c9ae7-30ac-4186-82a6-4bf71fe3fc97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"-", "2"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1384", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[{0, 0}, 1, {0, Pi/2}]]}, ImageSize -> Small, FrameLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, FrameStyle -> Directive[12]],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->33263346,ExpressionUUID->"1c29f8fe-2778-4c8f-aa18-0deec21e6107"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxsu2dUFGn39vtf53x5P56J5jTOjCDmHJGcc845R8k5I0kEEUVFUVREBQXJ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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW
CCwPHmEJ4rq6ruu6vM5W3gvnLOebuWmGw7t399/9MjP/f/6573/x9adfvnNx
cfH43YuLm5H/fnh09+Hzpz/dT12sP3/+9M6TRyfrJ7d/f2H97Y288zM+31k/
+Gz/6vGfr/D93vq9Xz76/tmbS+vbP9+5sr759o8PXuP6g/Xl2wtYf3x7v1+t
39x+4Dfcf7T+5IMP/7v38nfEM1m//ObmE38gvtn63u0H/kK8i/VNtHcf/o34
V+vbyz35B8+zWX/37OYJ/sX73K3f/ruGPri2x2ItvtLiKy2++fnOWnzz+721
+EqLr7T45vUHa/GVFl9p8c37j9bim/FM1uKb8c3W4pvxLtbim/Gv1uKbz7NZ
i2++z/1+zstr6GOetrkeY/It4FvAt4BvAd8CvgV8C/gW8C3gW8C3gG8B3wK+
BXwL+BbwLeBbwLeAbwHfAr4FfAv4FvAt4FvAt1532/P04MpRfKXFNz/XWYtv
fr+3Fl9p8ZUW37z+YC2+0uIrLb55/9FafDOeyVp8M77ZWnwz3sVafDP+1Vp8
83k2a/HN97lbi++5fbS97paKozRH8c3Pd9bim9/rrcVXWnylxTevP1iLr7T4
Sotv3n+0Ft+MZ7IW34xvthbfjHexFt+Mf7UW33yezVp8833u1uJ7Li9q76Ol
mpfkKM1RfKXFN7/fW4uvtPhKi29ef7AWX2nxlRbfvP9oLb4Zz2QtvhnfbC2+
Ge9iLb4Z/2otvvk8m7X45vvcrcX3XJ7bzouOfZTrLucpuXLM9bkzX+lcnzus
zx3W5858pXN97rA+d1ifO/OVzvW5w/rcYX3usD53WJ87rM8d1ufOfKVzfe6w
PndYnzuszx3W57puaee5pdo3uc5yXpKjNEfxlRZfafGVFt+8/mAtvtLiKy2+
ef/RWnwznslafDO+2Vp8M97FWnwz/tVafPN5Nmvxzfe4W4vvuTq0XbcUzLMj
L+I+ynWX85RcOeb+22P/7bH/9uYrnftvj/23x/7bm6907r899t8e+2+P/bfH
/ttj/+2x//bmK537b4/9t8f+25tv+gjX0Iev0K5DS5XXMg/ivsl1lvOSHKU5
iq+0+Ob1B2vxlRZfafHN+4/W4ptxTNbim/HN1uKb8S7W4pvxr9bim8+zWYtv
vs/dWnzP+URtX6FUdQrzWuZB3De5znJekqM0R/HN6w/W4istvtLim/cfrcU3
45msxTfjmq3FN+NdrMU341+txTefZ7MW33yfu7X4pj58v7ZPVKq6k3UK81rm
Qdw3uc5yXpKjNEfxlRZfafGVFt+8/2gtvhnPZC2+Gd9sLb4Z52Itvhn/ai2+
+Tybtfjm+9ytxfecj9v2/Q6fiL4C61DWLcxzmRdxH+W6y3lKrhwzfx6QPw/I
nwfzlc78eTBf6cyfB/OVzvx5MF/pzJ8H85XO/HlA/jwgfx7MVzrz59qXb/u4
pfKF6COw7mSdwryWeRD3Ta6znJfkKM1RfKXFN+8/WotvxjNZi2/GN1uLb8a7
WItvxr9ai28+x2Ytvvk+d2vxPddnafvypfL56AvRR2DdyTqFeS3zIO6bXGc5
L8lRmqP45v1Ha/HNeCZr8c34ZmvxzXgXa/HN+Fdr8c3n2azFN9/nbi2+5/pm
7T5LqXxb+nz0hegjsO5kncK8lnkQ902us5yX5CjNUXylxTfjmazFN+ObrcU3
412sxTfjX63FN59nsxbffJ+7tfie64O2+2YF+9Thy9PHpe9Hn4i+AutQ1i3M
c5kXcR/lust5Sq4cs/4dzVc669/RfKWz/h3NVzrr39F8pcU3n2ezzvp3RP07
ov6t+9rtPmip+ir04enb0uejL0QfgXUn6xTmtcyDuG9yneW8JEdpjuIrLb4Z
32wtvhnvYi2+Gf9qLb75PJu1+Ob73K3F99w5hXZfuyCPPOH/9dFnoS9PH5e+
H30i+gqsQ1m3MM9lXsR9lOsu5ym5ckx/YzJf6fQ3JvOVTn9jMl9p8c3n2azT
35jgb0zwN+pzJ+1zCqXqe7JPxr4KfXj6tvT56AvRR2DdyTqFeS3zIO6bXGc5
L8lRmqP4SotvxrtYi2/Gv1qLbz7PZi2++T53a/E9d46ofe6koM47Yd85+qDs
m7HPQl+ePq740heij8C6k3UK81rmQdw3uc5yXpJjxneM6V/N5iud/tVsvtLi
m8+zWad/NcO/muFf1efC2ueISnUugX1s9j3ZJ2NfhT48fVv6fPSF6COw7mSd
wryWeRD3Ta6znJfkKM1RfKXFN+NfrcU3n2ezFt98n7u1+J4759c+F1bgw5yQ
Fx7nFNjXZh+UfTP2WcSXvi19PvpC9BFYd7JOYV7LPIj7JtdZzktyzHiPMf3J
xXylxTefZ7NOf3KBP7nAn6zPbbbP+ZXq3FDm+S+qcwn5+a7qe7JPxr4KfXj6
tvT56AvRR2DdyTqFeS3zIO6bXGc5L8lRmqP4SotvPs9mLb75Pndr8U19nMNt
n9s8zvml/3ycG5LmuROeU2Bfm31Q8WVfhT48fVv6fPSF6COw7mSdwryWeRD3
Ta6znJfkmPEfo/jm82zW6T+v8J9X+M/1uer2OdxSnevLOvxFdW4oP99V5xLy
+33V98w846rqq+T1h8q3labvR5+IvgLrUNYtzHOZF3Ef5brLeUquHMVXWnzz
fe7W4pv6OCffPldd8P/oBF/lOOfHc2HZX9jQXzjOJWSdd4m88Qr70Gtc/+iz
0Jenj0vfjz4RfQXWoaxbmOcyL+I+ynWX85RcOWZ/YUN/YUN/of7dQ/ucfKnO
3fKcJs/18RwYzw3xnAnPJbCPzb4n+2Tsq9CHp29Ln4++EH0E1p2sU5jXMg/i
vsl1lvOSHKU5im/+buUa+vgdS/t3DwXr/Am+53EOl+c2xZfnwHhuiOdMeC6B
fWz2PdknY1+FPjx9W/p89IXoI7DuZJ3CvJZ5EPdNrrOcl+SY7/MYxffc75La
v2Mp2LdP8LGPc9U8hyu+ed9X+H4PX+0SdfoV8v7XuP6Adenog7Jvxj4LfXn6
uPT96BPRV2AdyrqFeS7zIu6jXHc5T8mV4/88ZMtv
     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}, 1, 
      NCache[{0, Rational[1, 2] Pi}, {0, 1.5707963267948966`}]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[12],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->1974715204,ExpressionUUID->"20b38c03-8a67-4e19-99de-1756b04526a6"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"03abe1f6-9e91-4ca2-8dee-0d65054751d1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Closed Contours", "Subsubsection",
 CellID->491936,ExpressionUUID->"ffa40174-355d-4d19-89c3-5a6b4016f836"],

Cell[TextData[{
 "It is often interesting to consider contour integrals over closed paths, in \
which case it is common (but not mandatory) to use the symbol ",
 Cell[BoxData[
  FormBox["\[ContourIntegral]", TraditionalForm]], "InlineMath",
  ExpressionUUID->"e86ddefe-69be-4430-9d0a-67fb0765a8fe"],
 ". (Closed contours around a region are typically traversed so that the \
region is to the left, unless otherwise noted.)"
}], "Text",
 CellID->24394261,ExpressionUUID->"3a60d8a6-b189-4c81-91f7-4522d79ef848"],

Cell["\<\
As in vector analysis and in real calculus, one wants to understand when a \
contour integral depends on the contour of integration, and when it only \
depends on the endpoints: Is it possible to tell if a contour integral is \
path dependent or not?\
\>", "Text",
 CellID->177863685,ExpressionUUID->"834ba002-38ca-48ea-9c51-1ca70db0958c"],

Cell["\<\
Path independence is closely related to the behavior of the integral around \
closed paths:\
\>", "Text",
 CellID->531913813,ExpressionUUID->"4e96cb80-1ebe-46cf-968f-4367e88750a3"],

Cell[TextData[{
 "Theorem:",
 " The integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f651edc9-84ee-4d64-9368-3c8d0181911e"],
 " is path independent if and only if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[VeryThinSpace]", "\[Gamma]"}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cc2cbd4d-b158-471a-8d13-e526b0b58f35"],
 " along all closed paths."
}], "Text",
 CellID->900656904,ExpressionUUID->"9e607678-5b07-483f-ac63-9a9d47345ee1"],

Cell[TextData[{
 "Proof:",
 " Consider again Fig. 1. If the integral is path independent, it has the \
same value along ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a8549af4-b15b-4820-91ae-167c992ae388"],
 " and along ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6fd15ba6-ab36-4aa8-acbe-a0cbc3c93ee7"],
 ". You can form the closed path ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Gamma]", "=", 
    RowBox[{
     SubscriptBox["C", "1"], "\[Union]", 
     RowBox[{"(", 
      RowBox[{"-", 
       SubscriptBox["C", "2"]}], ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a0163d74-a6fd-48ad-bd8e-3f1903a05aca"],
 ". Clearly, the integral along ",
 Cell[BoxData[
  FormBox["\[Gamma]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "cb388b9c-f792-43a2-b6b3-845ba2c1bfcd"],
 " must be zero. Conversely, a closed path can be split into two curves with \
the same endpoints; if the integral is zero over the closed path, it must be \
the same over the two curves once signs are taken into account using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{"-", "C"}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{"-", 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0a2c9825-66e4-432e-b176-c71c6727464c"],
 "."
}], "Text",
 CellID->785466622,ExpressionUUID->"f2d1737f-a115-4b66-b4f4-2398645b1c85"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->398609883,ExpressionUUID->"c3c01bc0-91fc-41cd-a83b-1b0d50f03b40"],

Cell[TextData[{
 "Discuss the contour integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "a"}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8a791e88-ce74-4ceb-962a-e6519eb9bebd"],
 " over closed curves ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ec0068db-9d12-4b33-b403-2a0461036a56"],
 ", for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "01d4adf6-8bbe-4176-9613-6a765a7c2c2c"],
 " and complex ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "24bf280f-5e03-4bb9-8ae9-0085ea621ad0"],
 ", assuming that ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ef3fa957-c143-420f-8f27-c63ef7222b47"],
 " is not on the curve."
}], "SolvedExampleNote",
 CellID->222137120,ExpressionUUID->"fff2a065-3479-488b-a74b-abc1be4b2585"],

Cell["Let\[CloseCurlyQuote]s distinguish three cases:", "SolvedExampleNote",
 CellID->41249873,ExpressionUUID->"e451306b-927b-487b-867f-fd3c1d40f200"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", ">=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3fb1cc54-0f1e-40ae-849e-633cec2ffb0e"],
 ". In this case, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "a"}], ")"}], "n"], "=", 
    RowBox[{
     RowBox[{
      FractionBox["d", 
       RowBox[{"d", " ", "z"}]], "[", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", "a"}], ")"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{"n", "+", "1"}]], "]"}], "=", 
     RowBox[{
      FractionBox["d", 
       RowBox[{"d", " ", "z"}]], 
      RowBox[{"F", "(", "z", ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d2da7473-fc68-41d4-8a76-4609724af7ef"],
 ". Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "z", ")"}], "=", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "a"}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"n", "+", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c02682e8-20e5-478b-8bde-b74b46194ae4"],
 " is analytic everywhere, the integral of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", "a"}], ")"}], "n"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a9fa1d73-5070-4d67-aa20-f5159c3d5159"],
 " is path independent. So it must be zero over ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5224580e-e746-4694-8be4-4a892e161bc3"],
 " because ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1aa3f97e-ea21-447f-9762-9e0c5acc9cdd"],
 " is closed."
}], "SolvedExampleNote",
 CellID->420630712,ExpressionUUID->"28a3a92a-4431-4f2d-904e-9d8771f1f3e4"],

Cell[TextData[{
 "2. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ce7c435c-585a-4645-8f89-529803213915"],
 ". Then, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "a"}], ")"}], 
     RowBox[{"-", "1"}]], "=", 
    RowBox[{
     FractionBox["d", 
      RowBox[{"d", " ", "z"}]], 
     RowBox[{"log", "(", 
      RowBox[{"z", "-", "a"}], ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"74d4c854-1f35-482f-9bbc-75e9deb76167"],
 ". If ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d027ae37-44b7-4539-8513-99434a608fcc"],
 " is outside ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "39fca838-695b-4d3c-9836-98d5b42166cd"],
 ", the integral is zero for the same reason. If ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5423fb5d-9bd2-41d6-976b-5dc6fbe910e4"],
 " is inside ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e909cd96-ff80-44fe-9420-71286af628d0"],
 ", however, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", 
    RowBox[{"z", "-", "a"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d411ad82-fc75-45f8-a188-a7a8e3d2db17"],
 " is not analytic in a region containing ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e75c0630-a6c4-4b6b-8d74-d99ae43a6093"],
 ", and therefore the fundamental theorem cannot be applied. However, it can \
be applied to the path ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "1"], "\[Union]", 
    SubscriptBox["C", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8367b92a-3f7e-4f87-8ddc-59de9a7cae3a"],
 " on the right of Fig. 2, where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "80e6f9f0-3764-4cd3-b561-65dc1a4c4d20"],
 " is a circle centered in ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7598cb54-7908-40d6-8b4a-faf623f5522a"],
 "."
}], "SolvedExampleNote",
 CellID->698542096,ExpressionUUID->"1992ae9f-1031-4ca8-b86d-fe217ed5a724"],

Cell["", "SolvedExampleEndCap",
 CellID->1259313594,ExpressionUUID->"f1451094-32ce-446d-bea4-fe84c0723f9a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "pts", ",", "ip", ",", "si", ",", "pts2", ",", "si2", ",", "ip2", ",", 
      "pts3", ",", "si3", ",", "ip3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "6.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "6.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "6.7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5.8", ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5.9", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5.1", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5.4", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5.5", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1.7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "1.7"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"si", "=", 
      RowBox[{
       RowBox[{"Accumulate", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", "0", "}"}], "}"}], ",", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{"#", ".", "#"}], "]"}], "&"}], ",", 
            RowBox[{
             RowBox[{"Rest", "[", "pts", "]"}], "-", 
             RowBox[{"Most", "[", "pts", "]"}]}]}], "]"}]}], "]"}], "]"}], "//",
        "Flatten"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ip", "=", 
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"si", ",", "pts"}], "}"}]}], "]"}], ",", 
        RowBox[{"Method", "->", "\"\<Spline\>\""}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Row", "@", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"ip", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", 
            RowBox[{"Max", "[", "si", "]"}]}], "}"}], ",", 
          RowBox[{"Axes", "->", "False"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"Thickness", "[", "0.01", "]"}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Epilog", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ip", "[", 
                   RowBox[{
                    RowBox[{"Max", "[", "si", "]"}], "/", "2"}], "]"}], ",", 
                  RowBox[{"ip", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Max", "[", "si", "]"}], "/", "2"}], "-", "0.1"}],
                    "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"2d597b2a-01d0-4b2d-8fcf-7da628019f2d\"]],\
ExpressionUUID->\"2d1886f0-9b1d-427f-b219-abfb68ff6a33\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"5.5", ",", "5.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"a\", \
TraditionalForm]],ExpressionUUID->\"dc9175e9-3d1d-4487-97e2-cc4ae1abef4f\"]],\
ExpressionUUID->\"1a831c8d-4912-433d-9e60-6ce31beecbeb\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"3", ",", "4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1.5"}]}], "}"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "120"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\[IndentingNewLine]", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"ParametricPlot", "[", 
             RowBox[{
              RowBox[{"ip", "[", "s", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"s", ",", "0", ",", "2.01"}], "}"}], ",", 
              RowBox[{"Axes", "->", "False"}], ",", 
              RowBox[{"PlotStyle", "->", 
               RowBox[{"Thickness", "[", "0.01", "]"}]}], ",", 
              RowBox[{"PlotRange", "->", "All"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"ParametricPlot", "[", 
             RowBox[{
              RowBox[{"ip", "[", "s", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"s", ",", "2.25", ",", 
                RowBox[{"Max", "[", "si", "]"}]}], "}"}], ",", 
              RowBox[{"Axes", "->", "False"}], ",", 
              RowBox[{"PlotStyle", "->", 
               RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                  "RGBColorSwatchTemplate"], ",", 
                 RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"ip", "[", 
                    RowBox[{
                    RowBox[{"Max", "[", "si", "]"}], "/", "2"}], "]"}], ",", 
                    RowBox[{"ip", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Max", "[", "si", "]"}], "/", "2"}], "-", "0.1"}],
                     "]"}]}], "}"}], "]"}]}], "}"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"e159a410-7348-4056-9603-bad24839c671\"]],\
ExpressionUUID->\"7531cbfa-4872-46d9-81b4-ff0dbc51415c\"]\)\>\"", ",", "14"}],
                   "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"5.5", ",", "5.5"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
                 RowBox[{"Point", "[", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "}"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  
                  RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"a\",\
 TraditionalForm]],ExpressionUUID->\"318c3bec-d6ae-4159-ba0b-b9a797034e1b\"]],\
ExpressionUUID->\"2af1428c-008a-4498-8f74-7b4ade5c9233\"]\)\>\"", ",", "14"}],
                   "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "4"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", 
               "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                  "RGBColorSwatchTemplate"], ",", 
                 RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}], ",", "1", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "Pi"}], "+", "0.1"}], ",", 
                    RowBox[{"Pi", "-", "0.1"}]}], "}"}]}], "]"}]}], "}"}], ",",
                "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                  "RGBColorSwatchTemplate"], ",", 
                 RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.5", ",", "4.1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "4.1"}], "}"}]}], "}"}], "]"}]}], "}"}],
                ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                  "RGBColorSwatchTemplate"], ",", 
                 RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                 RowBox[{"Line", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.55", ",", "3.9"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "3.9"}], "}"}]}], "}"}], "]"}]}], "}"}],
                ",", "\[IndentingNewLine]", 
               RowBox[{"{", 
                RowBox[{
                 
                 TemplateBox[<|
                  "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                  "RGBColorSwatchTemplate"], ",", 
                 RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
                 RowBox[{"Arrow", "[", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "+", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", "2", "]"}]}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "0.1"}], ",", 
                    RowBox[{"1", "+", "0.1"}]}], "}"}]}], "+", 
                    RowBox[{"{", 
                    RowBox[{"3", ",", "4"}], "}"}]}]}], "}"}], "]"}]}], "}"}],
                ",", "\[IndentingNewLine]", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"4a1e5975-4c41-4e83-860c-cce3be716339\"]],\
ExpressionUUID->\"33e98271-a133-4f33-a5e4-4fc72d0cad8e\"]\)\>\"", ",", "14"}],
                   "]"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "5"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0.5", ",", "0"}], "}"}]}], "]"}]}], 
              "\[IndentingNewLine]", "}"}], "]"}]}], "}"}], ",", 
          RowBox[{"ImageSize", "->", "120"}]}], "]"}]}], 
       "\[IndentingNewLine]", "}"}]}]}]}], "\[IndentingNewLine]", "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"\"\<Fig. 2. Two contours around \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"a", ",", "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}]}], 
    "]"}], "&"}]}]], "SolvedExampleInput",
 CellID->122001654,ExpressionUUID->"60b7314f-c061-48c9-a8ef-5914ea34338c"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     GraphicsBox[
      InterpretationBox[{
        TagBox[{{{}, {}, 
           TagBox[{
             RGBColor[0.24, 0.6, 0.8], 
             Thickness[0.01], 
             Opacity[1.], 
             FaceForm[
              Opacity[0.3]], 
             LineBox[CompressedData["
1:eJws13c81e/7OHDn2PPs4RihlCIZRYPuq5IohKiUSiIt3kVZZSShlFKyk2SU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              "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
        StyleBox[
         DynamicBox[
          (Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
               Annotation[{
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8], 
                  Thickness[0.01]], 
                 Line[CompressedData["
1:eJws13c81e/7OHDn2PPs4RihlCIZRYPuq5IohKiUSiIt3kVZZSShlFKyk2SU
rCJFGVmJIoVQCFlZx95878/j9+sfPTnn9brHdV33dcvb/mduT+Th4XHj5+H5
38//94+L/v9/QGLT403BsyMoWdl9LFqUB753Pg0zHR9Bl7WODG5m8cAiaTU5
sHcEiZBL67xUeUCrdM/XqY4RJOO8mLpqKw9kH2RMPv49gtqahRxqdvOATMBM
+b3vI4i3Y9Z23TEeqLPMIjV/HUEvaQ/v/z7DA2ccD/Mf+jyCHjrbXQu9zAPv
fxVsGi4eQQm/mOd47/DA3tMyFIGCEUTzeGlVHMEDBvGvmvfnjSCjs+2dPs94
QOf2BxfX1yPo+Zk7jwXe88C0Y0O3WeYIoojmffhawQN5ZxwCrNNGUNXqQdOI
7zzgFFaa9OjFCPK5uWx6qo0HZkS2hS0kj6Bv3C/Z6v94QLdHNuF+4gg6pqF6
kTiFxw/FK8wSRtAX2uK1BgIB/DQuHtONH0EfjtPqUsUJcPCnz0uLuBH08/fe
U36SBHA1gCPhsSMo75DXOmtFAnx7QswnxIwg4Sh/mc3qBIBpllR41Ag6c26r
JlOXAK/O1H01jxxB7o/cbacMCCAq4augHTGCOrrYCU0WBFhPuHJ2Z/gIQism
+z7YEIBgTRh3eTSCtlJ61z+7QICLm11J1WEjyPVGpUOwOwEss1aR9mDfQy53
r/gTILb12M7ehyNoPenjo5P3CaDa4jybij3xPthtfywB+oty/EOx/Unpa9Fz
AuQ+v7wxGvv6j6UEtRwCeGbwWpVh36s70rKymAAyA693kvDzTX9EV7C/EOC6
+48dntinEyKPk5oIcPdibjIfHp+rkGqU4F8CrBpK+5iOLVe70ZHAJYCmkFDX
ZTwfkeKAuoV5AkT+Yh+1wvP9mbj4YVaQCNuuq3keweuhtMdl9QyNCERa/H03
vF5PL37km1lBhNrUd8OZ0SOo899Hk1llIoTYVv8l4vV+6GMyP69NBFmLtaX/
PR5BFjNA4NEjwpmolS2TeH8+y7oc4jclQnGA+vhevJ+HYhZraWeIEGXb+4iN
9zvPX/iP9GUilMx6vV5IGkFWOz9IrfElwv2PodH8qSPoj43X6PZIIgiufiWw
FscT2RJ5GCUS4VT65HqbDDwfPZLQ0SwinLyjMSKQPYIGNwPzaiUR7tgc4V+J
41frzruJ8hkiZKnpXBLF8R3kVNjZxs8LHKOgIL7SEXQhgpA5Q+UFnozZLYo4
H+r3xGWrrucF4RUeKkKNI6hlpGL1s5O84F2Qeun+6AhSKblx/VkVL6g27U7m
TOL8OOj8u+wnL+icyglKmRlBR63ZR3v+8sI7WvLP8uURtLC3P2ztMi/cHxGm
LAlwka7XxpxMTT64//BCeTmdi6RiZJ2yYvlgbvjEz/NMLnr8OPJuzQs+kHt0
aYcYm4tMt+sxB3P5YEePzvGtUly0rTtko2IdH1jF3ruG5Lmo8VHg8RB+fpA0
CaWkKXDR7YOrridT+eHXw30+pFVcdLA6M7NgBT8I8Wgr5q3mIhXrUUL/Fn64
cZT/WLAyF3n35mzUcOKHL+m9HgkqXJTIOHZxx1V+ONYqzU1bz0VV4q+O7A/i
h5Oa7/anqnJRlrNQ39FH/LA080UpegMXkXvzxRwS+OGEm5PoNTUueiEuV3Ax
kx9eTmcG7lfnoo237g25f+AHsdLE9XQNLrqyYPPA5zM/pCrY3P2MrSAy+MS/
kR8yT0xq/afJRYsWQSJBXfywq9Qtn28jFxX73K24xeWHkPC5lFvY69YfqLy1
yA/vFULvLWLPLKvxBYkIwFiWCcFmExf1RHs7+bME4Oht/btZ2K/iH857rxIA
2Zng0mFsRs6nJ27qAnB6l8ZGjhYXfXdz3u+0XQC6bkQ7qWPTg931AvcKwO9N
fiHa2FIizpfiDgoAs6p6swq2nEvHl2xbAbB4ZUUlYR/XMzT+5CQAx6wlitvx
86kLyv1NngIwve1Lz2NsN7ZYRF+AAHQXX1E2xK5kXTCeeiAAw0eHNDrw+JF7
DZH4RAAavRgJ9tiS796ki74UALuIbzKNeD0eWCbq0d4KgLUkYZ8G9t8a6UJ2
qQD4X75V44HXb1/CU7J0rQA8lTQyTsPrTTR5oyHzSwDcPZQvfMb7oWfawpHu
FYBaPpFv3/B+Ga95WMQeF4DzKlUyJXg/rcxsWbRlAaCcNJmLxfv9zKiKLSoq
CEE0D5GTOB5ORxjn87AE4UGOyrg4jpfWTKexcQVBmM7ZZ/VsLRftome9/asq
CNduvuuQU8LxuDOM58dWQegOt1QPwPFWm/e4tFBfELxQap7ASi7q9Fj3IOS4
IGi+W60jj+PXpej1bedzgtC78ZikwgouOqx/7ucBV0EwWbzu1sDhIjHKpT0S
IYJwd92mnYE4H8zMyg/1RglCm6zKvAzOl5Zq8/CCJEF8WvxXPUPmopgzK91P
FghCq7ivio4EF+0NPC+04bMgrAg4TjolykVrm6fiZ+sFQbFJfNiKn4tsSR1l
NwcF4fLDZ5priVykydXT3TMjCLPa8jJvFnH9XJyM4OcTgsTMiQ1lIyMIwgxr
3KWEwLTZTe6/vhHUyxkNX79GCKJXFtj++jOCIitGpNo1hGBj/FPeyW8jSDBg
YePmvUKQ8PdIJRvXq4cuUVEf3YXgbKHb4Xxc/0RH0baj/kIgX+4VxMLnlcNN
M+PRe0IQ3n54hBA4gt4PFMVSU4Qgb/xHv9/REXTYi9Su1CAE6E/J7aH9I8jN
12Iu8Y8QSAiUSErojSDLO+ytMoNCkHWDb62TMh7v2zUEIq8wyI8pyIZPDSMj
pefPYtSEwSWoQbOrbxjdnNX4WbhNGO69/i+hq2UYkbfXiLXpC4NWlNev+YJh
pNp08Qj5mDD8Fzo+4eo7jFLNCDd33RIGxn1jUaOLw2h64H3N7jBh2CndllN7
Aj8/brx51xNhuFGv2dyjO4zE+oJtNN8IQ/jh/V4uU0OI/3b3tY4/wqDs4OTy
q2sIzZj4skoHhCG153fx3LchVPyopi5+ShjGlKK/n0odQsmP9jeYiolArIlm
35LVEOI2nTntry0CfQVf7pulD6KQ7asU9e6KwJio7uac8EHE7Yy3GIoQgVV3
y+bafQZR0ocZ24cJIhAlKbozwmwQ9S/wGjW+FYH0YRr32dgAml0nEbe5UwSY
awk+qioDyERCJtdDSxQCf2WQavz7EdnzxqEdraIwT+cnrHXoR1/8S5B3nyjM
Mk/vdjTsR3IHjurkjYuCn7m/81vxfvSeGJ25VkQMHuXVi3k+6kMWa/aundIS
g/6G1tzJhF6kZn724977YnD3neWt10XdKPneDj3jneLQH8D3deppNxoSjNt1
zlgcgsUfF5j5d6MbN81R4GFxCJX/ZGpm2I1+HS4989FJHNxcE4bi6v+i980l
qptjxOHnyRDXV6NdyIa8vl1nQhxWZy07PtnfiQxfG4WKp0hARPvhSuqWTuT1
fWV14CsJ4LeJMP6o0Inueo6+4P0gAfcmz16un+pAQ9X8QTx1EqDYPnh5/GkH
8jukJE+el4BjxBkHm7sd6GT059ZIfhJM5WkWUDw60NXNdxJWkkmwENi5Vt+s
A7G4Iq5IkQRrRJOMmfwdKFeNLz50Pwl0dT88rBj7g/apV8woHyEBY89+l7I/
f5CvTf2HSjsSFN4IiU4v+IOcc869E/YkQaPYbJXl1T/InPmoKTWRBL/PuMo+
PP8HZfxX02OVSQLhP/k711j/QYLV3qWi+SR4SlSKPrj9D7q1W1PCvZYEEtZe
4uUCf1C5EB9ymSOB8ZEelQvj7SjhQmZKLJEMqfLZVVPN7chh//HVBCEy9DX9
3UN40Y6uCWy8U0Mlw2FFvSnv0Hb0Oab+ijabDIKmHjXxnu0obP2/lqcyZNgy
axX9xaQdxVc6SF9VIoN+/bJ1/ZZ21PbAcL5/PRky9C/2XlVsRw9+PTxyRJMM
j1KTRpOW2tCRc5ZP0HYy+HnT1u9514Y0RTfZSVuQgbuyyEf1eRuaO8h7NsKK
DAPfZRvTItvQWkX5GdoJMtwRGFE+d7UNva/ank85R4aPvVZzyY5tSOrUu5EH
/5EhMtjxnKtNG2pdvpzDuEKG7fU3vlbuaUPelancFb5kiGrwvWeog9//5vG5
lJtkyDKXCj2s3obuK31yVwsmQ5nHt7yJ1W3oCdFO+v19Msh4yIxKy7QhgVWv
Du4JJwPRx0f2G60N7XAcUGqIIUN+nstacdE29K1wf5jdUzK8CRB0lZtvRX8W
bm0LSiNDntbJLpvxVhRdMrMi7DUZSsUE5nQHW1FaRue/p+/IcCBk2CK3uxV9
pPx6/KqQDI1Au1fZ3oqu61zZWlpGhooXF3a5tLSiMB+9ksYqPH6TcbE3Da0o
Qfm31uA3/LycJwF36lqRZWhtFO9PMhSePLdv5msrOkx4PSjdSob5ln1TU1Wt
aP8XpvrmLjKMJekoBFa2os6doWcs+8kgZbDpXEpFKyp+kxN2eYQM/fqqZw+W
t6I7V+hvH03i8ayRy39Q1oq433fVvZsng/lF3pkj2I9kG/+2EijQlPStIB1b
8cXxcT4hCrQa+ybfwt/fU3pxab0EBeqHRIyH8POfFjwRtKJTQEv0rNHP/72/
z5scwKGAp/JDpF/ditIfPeW8kaMAvf76x801rSiDHrOmZzX+++31jul4fsG5
S5sl11NAoT6kNQHPf7j6hKmJJgV8teLSWXh9fJPM/ru5hQIkbQt3Ebx+fQ8d
IgoRBXYcfdHk8bcV1fVurJrdTYEQpfCzdv9aUdeokbC2EQXOr6JVVHJbUSlx
10FXcwrsr2ffSppuRXLnU1+/PUyBjIInxrNLrejxVabc/HEKEE7HZ5QItKEe
f0482FPAXHj0VRarDXmWabfVXaKALknj9ne5NsSMdXsi406B8f6ac3br2pBc
ZqzHeW8KRGguZX3f3oZkq7q8xYMpcCn9ulGaYRuyc1FJPxlKgSHKLmuuRRvK
i06ZextBgadZJ/VeX2hDm5L9Zs8lUqBiMtN8vUcbSlMWzviUSgH7bbI7xAPa
UOMlUtDqVxQYaNVZNxXfhv769b3+V0CBafYrud2/2pDF7X7S3Z8UaJhbv7L4
Xxuq7b0tPd9KgTahe61hc20IgvWPnv9LAf2i9u7dUu0orcfqivkonp/qP+0n
Nu2IWiJusE2UCpm/WVenZtvRy7j7le6ICv8OTNcQBf+gVLomcXA3FTJaz7av
o/xBdpVdl04aUUHZ5lVzs+IfdP/66VlzKyp4qXfnxZv+QS9OZ343daFC5613
Vttf/kEBR2DhXQoV7Dd+f8y52IHOt/VH76bSYHPAmOMpWhf6Rsz2ezZMg7OM
1gaPFV3IN/L7U61JGtibb6sNVO5CIi2neb7M0yDPvt8saFcX2mlf5rsoRIf/
Hlr3ibl0oa0Q9/zqSjr47lwlo/qtC6VcfHGs+TAdFitKrZdv/kU33qeNeZbR
4cG15Qv7Qv+i7krl+s3VdGDW++2PjP2Lji7ExU7V0WEmRc1RK/svevey6Oal
djpIxLZoh/75iwIEr6rZztHhktfkf+t0upFZiE0iR40BTnZvIrTmutHZTJl/
u6MZwJt34t99wR50o2XTxpNPGbCXc31ikd6D4tGGaffnDGjfeO0RVa0HeQa+
uPQ4lwGv1kQ3ajn0oL/5U4u53xmwOJLydrS5By1Jfn5MFWFCZr+fT1FfD1Lf
khLXS2ZC7Vv5yBfTPaj62yR6y2IC4l2Sb2D0ourNlUO7FZlwLsfNLvpAL1KK
uvZeBphAupAgYNfQi+r4Zg0eX2bChQDPpu09vchy6b6HxFUmDOucCkPTvehZ
hpKz+3UmmGTlqb2R7EObebft1gphAr/Ex0/XbfrQubWrNx9MYYKYg11urHMf
cgyYcrydzgRaceHRTv8+dGFLiE9uNhMYiQNq3Bd9aOridNFkERNOhl6oWz3V
h+x/DHiKNzFhco/EzufC/ejKXXWLxVYmnLEV17KS6UdZOgIyf7uYUDfhKmG0
ux/t2wuC4SN4fkO6xgER/UijVp03SIAF2ewaux+7/6Ed/e0ltzVYcClspyr5
6D8UtDU26bo2C0zNqG+8L/5DK12XBP/TYcF3m/DhsZh/KI4eO6CizwJ25MT7
3ZP/UEXlvbsaVixobhWQkhUbQEX6tV9ajrEgWpizQmXlAEryuVHtbssC/26G
yIDZALp+Wz3l0XkWrLy4hkl8PYBi2qa1TL1YMJTMZ/CoagCRJdTrnl1nQfiZ
IAHbrgEk+jn93OBNFkwfPyiTyhhEvw2ttlmHsIDQXGtN9BpEwmZfXmfHsaBl
TVLcfxGDqCz3SnJaAgvOJ1dYcF4Poih39eaoZBYY8X+krOsbRGPun2JMM1jQ
IXLIAw4NoSP6HydUClhQHWkmlOIyhOQczKC8mAWH5nXHTe4Pocc5JSJmZSwo
Jhd9s6saQuLb1T7srGbBgO5qy9wdw+j739vc4CYWjKi7OG2yGUb/7XZ/UPCL
BU5PDlXPeg+jI88Y4x1teDx5ebsscH/sUrTnPrGbBftTk5uP6eJ+3bw1Kp6L
11/ZJZ9+fARNucXdtx9nATdiqIjuM4JC/6oFSk/h8XHtY0c+jqC4J4sRNvMs
2GZ849LnrhFUfjKgb2iRBSuOb3GaxPeRadOhu448bGioL9C8rshF9pdf7tbj
Z8P8rbfF8/j++TBw/b0YQTbs2HiZGmXARZk3u2K6hdkgZ0Fe2nqBi5J4djia
S7BhWfNzFf0Nvr8rcCZCmWw4mVCRDJ+4SNdeL9edzQbNbaumgpu5KOHLxocH
OGxQpvHP+CxxkfXJo/w9Mmyo7xbZoEQZRUe3Btc8XsGGSWHXzuGVoyji3mXO
Xnk2PHO8/qnRcBRJCjgk+K5iwytI9Jq2HkWUH2epoqvZAHfU8zZdHEXPXCQd
b6/Bz8u+/1k4YhSNBTjvPbOODasP3gwR7hlFnVbZ155tYIPR0opM0two0ltT
Jtmkhsd/YYODusQY4nU7c4mowQaR8lfJFVpjaGji+LvNG9nQsyPl9ZZ9Y6iy
JvWX3iY2WKQxT3w6MYaO+XnJ79Fiw/DFMwnqt8YQoyb1mupmNkQf/1ogHjeG
+ijL5bQtbOiyeeXHmz2GGgK+Ro1g61bNU7a14u8f/WIQvI0NP8v+2lwbG0Op
p6cO7dNhg8S8mW2j4DhynLtrRdRlg+2Owps/NMbRJ+psjOV2NhC6kYqrwTgS
3VVBHsPWH9gbonZ8HK07MNF+E7Fh/LGcE/HyOJpj+66kABuq9IkhA7fGkeW5
05MPsW9vUM8aeDKOKDKJ/0nsYMPs0+FwYu44EhbUSvPF7tvLee/SOY4Emwzr
jXayoZsu6vV1ZhwVnCsfT8aOvndPTJc0gSTuBOnOYpfy9SuXKE6g75T71bt2
sUGh8PBja50J1FnX9DYA24NfbqXYgQlESTghXYJ9e5Wvz7ezE0j3sDxtCptt
n3/5he8E2lbFyVXQw+tFJpeHR0ygv18NVhhgZ14q0YjMmECkLc/PnMbeVkf1
TS+fQBEdm9K8sI09dv7X+HsCmT4e5g3BTsh+UEKdmED0nbW3IrDnP+vp2IpO
ovdJ9YeiseUEouPKFCaRdNx8YDj2l1c/Xm7ZOokohB0b72CXMTVXfzSbRJcS
n7pexf7kPVt75Owkoh/nnLXDjtY8c17g+iSq432uuAd7ybs4vzRyEt04v6di
JXZ26i7fB1mTaOncpN0cnt81Hk1v58pJJNuUIVWNLV1V63rqDz5Lgi7yhWNb
mh1VsZ+ZRInm2luOYv9tZ550I0+hAlGeeg62+y/rzynrppCX/vOCGrzeMXwV
/AN6U2iGOGFyDbvr+a2i5x5TaFWfzlAZ3r88IaUnCmFTyML/sY4N9rUTl1gZ
GVMI3TrzbhLvv+b7O+EzXVPIPIcP325wviQmLOcuTaEp4y1+YTh+Sk0Gym9K
TiMr7SfzNOyJtFjVA/un0dE/5QG8ON620LW+Jb6fRpa/h588x/G7cD3Sr7Vx
Gk3qyT4UwP62U1dq1dg0sqgW22GzlQ3MwIbSZqUZdIg9bCaI4/9ZzLRZW/gM
cuPT6F+D82cVMfeE4JVZZJe+Y7YW5+fFrWu8Z+/Poq18r9fMqrLhwMBs2ETa
LGqgL66Uw9b33XeRr3sW2ez9J3JGhQ1OM5a6fpZzqOZQqGaXEhtUNnxQfaU9
j2z9w+af4frRJOdknbO0gCpO3yjRprFBzVtFdLfkIqq1Ms4+S2WD6N47M/Wa
i4iUcdvyMYUN58J7Q0bPLKLNu3Q5ImQ2+P8hP2f+WEStcQ8iFsTYsCK0zTB6
aBG5c4QEEba+34e1UkJLaPuttOUbomxYf8/mGU13CSFhmxmGCBvOahhfa0pe
Qr0UvzlrXE/3VcSLoY9LKCbJJzlXgA2FF1xa4n8tIadCh2watvYRY1VL8jI6
bNBwtImPDR8t1TamrFtG3MeG6wG76Yuh27jeMoraEVD9kpcNj8N/5nh4LCNZ
Ha2WECIbvj5esyH74TJydYv0FcC+dcu+pzt9GbV8jj/hR2BDrJutqFbnMiq6
dl0zENd/d9XFGfOFZfTho8FxMrZjVBxloygPfOh5uD5umQXkwQUNXUUemNll
KlG5xIJkk+9vtmnwwIBZoZId9qTRFTUtxAMTeb+F+bHHjluTV1jxwL85PjlL
fN68eqjjJn6aB5T5Fyz4sC2TFZqnnXlg9Rcv03cL+DxL2RxafIcH5sbmo1Wx
ed7y9cdF8cAa/+5+Lj6/4nokkEcyD7zZuHH5LfYPfcWw/dk8YP64reUGtkof
o1++mAeeH/x1zQJ7w6+M7dwvPHBsVq57LbajWuGj/GYekJdNpvFhO81QRnx7
eCDm2EmhrjkWvNvlvm/XOA9cNjUsrcBuVih6SeAhwMF7FnqZ2MeTc8gfxAgw
+NojOBa7pm31VWdJAnQcyIwMwc7+3TWwajUBWkUGz9/EjsjKO/VDgwB3Lq7m
v44tfN61ywsRIEzG0u5/vi/dd36VEQGSU51uBWC/afi9WHGYAPZZZy/fx+ZL
UYi2tyeAzycdxSfYQk8Dd/A4EyAmqC3mNbZxffNEuDcBztzZ3VSFbWXWm7M2
GL/v/JmWXuz3St5+7yII8LpQN0EYz3f23IXjuxIJ4Cf7YYMadrySr2FVFgFS
V7b4HcXWcQ7UMy4gwI/TITHB2NYvbxQ0VREg92uVfDl24ZxQ5IkmAhRX6e/i
w/vT+kOmoaMbz/fU1LIB9vrUyisnxgmwEPf10EPs1aOkq008RKD4Fe/twt4h
PddtJEEEflpp02a8/28Gv3HXrCWC0cFP5RPYS+5VD0K0iOBFf7XqKI6f3W99
47i7iLA30lP2E3YqS3c6+TgRPIW8OjNxPObKmerPnyfCW564NBUcr49fbOHd
50EE00YnSiZ2u1Bq1e+HRNBT56aW4XhfVaH7U/YpEXxKgtoP4XxQrPtoaZ1B
hG8GTzO42MpxOWmfK4lwzkhBWhPn18o9aoGzDUR40OCc/xs7SzT356ouIl5f
2ngw7o/Ovpltc1wkwosGuuY8zteA62URwSK8kP7m2Nb3OL/p2tlViSxe2J5f
8ctXiA0XVJjPPqvzQqHB50FpXA+EO5K3ttrzgoP8Dv1IcTbURO3uaHTmhZHq
bTI3cT9V8XObyBcfXvCqmrrrRsLn4yuD3udRvGDzy0vHEdenK56R/1S+8sK5
Md8vMQw2FC2mFBNbeGFzl+rFN7j/Gnm6U76+hxd8D+mm17PYwOVoBpzl4QPo
3De+EvdfJy6+mT+uyQfxq/+k8+N+aznm+04K8IFj804pIzk27PHPkC4y4gM1
lCwfievn48Mf7oif5gPDbWgWcP/l9eqv55VIPpiKOfe9YS2ev4r4FecFPjii
pqIghuv574XdexKF+EGupvdSojYbAgfZ3XV0fvixsKi4E9f/lxecAuXW88Oe
PLH3d3G/86GUxy/4GD+cs3ONsMfnncw5YaWoAn7Yu/E+iW3OhlbevUpBn/kh
jpL0RMAC93OVL3hdGvhBTP3EwzlLXO9pz/frDPGDT+ejpDErNsQFVB56LC0A
LeW1Litt2bDOt50Q7SkAS9uD0wNd2FAZ7q60J0AAvjklOn+5gp/X9WYLN1QA
+kLTo5nubOCxWVqh9UIA0HFb2vtrbMgpGGGG/hSAqHJ2sl4AG1STowP9NQUh
2KdG/0g0GzJo+tvP9AkCr6Lo6nsVbAimDk39GBME37XSBsaf2VA3aaKrsygI
63buZZO/sEGPddaVSBWCkoGmkmd1+Dy4uZRpv00I+EoKEW8rG1pEeum37gqB
+byYwtMJvL9ikem3NwjDXbmZlOnVkiCVeeiDmqMItOTkNxmFSQJ6eVm+1U0E
kEdVoHykJPAuTTwO8hOB/8YDzk7HSIJ7SLx0a4QIyKyXcUx+JgmctLVDXiUi
0JBlI07KloQOW62iNJYo6P844DZdJwkU3hoD1RJR8DQ9KxlM4kDNu3Lr319E
Yafa7ltHaRzYsbjGP/inKPz7G3BhHYsDByTTjYYGRaGEa76pVJYDG0bQ9WKW
GLy/m3mmbT0HLkTnW2c7isHZ3NtSz/dxIF4zcmmLlDgsh+xpGfbnQE6bWaqT
ojj8pHZaKQVxYJGUspy0QRxKl0OkjwdzoHjPpxZpPXEw35+4sjCUAzvbLD+o
OIrD0vEjeiZxHBDeYuv+p0gcKBIdKk9yOWDNmKraXSUO75fkvMLyOGDo9/pR
Rr043N/pP+b/gQMPTA0+3e4Xh11Lm/kPlXCAEXqc7z+aBLi0zzQUfOXAfc1B
9TEHCXBmFl0P6OLA29519EfOEvCQkV2q2MOBNq0VujpeEjBl9kusqI8DP/uq
wyMeSACtwMixfYgDzx3Tvt8okICDU6bODdMcUPkiYbG3UgL3qf6zO+c40LvX
8QbjB35exsTMiwX8+YGPK/L7JCDhHEnSjiAFXnfgnS6dBLYl1f0BIlLAWzRH
VV5BgvBLftsLxaRgPnzaT2YdCZQNvK8NS0hBjYd1IwVIsJD0+cIWmhTothrm
bLlAgtYCo3VuUlKw70uR8/1yEswu0hxurJOCzPn35uV1JDhnHF59WkUKUkYn
3HnaSJB6IZu2Q1UK5Le5Gd2awt+n/XZoUZcC1zJJn1EaGboa3tXGb5aCr2z9
5ZUcMiRf7uLR2SoFOi3/DlrJkeFDw989Ndvw+15Unf6iQoY1TbfUmrZLgU+0
LM+P3WQozVCV9tOTgiEPQ00pIzJMqnW8bNwtBTu+6Y/Zm5Nh3iH5hsIeKbjZ
0z1EPEGG+qGAVfGGUtCvFMeytCfDni3qc3V7pUC61zLlxXkyfNcQU5/fJwU/
fnG/W7mTwW2t8y9NEymoDvt39I03GTRX3jm6a78UeNaQFWk3yWBYNmG511QK
fleSzBtCyVA9Wft9u7kUkBeoEi4vydDd4xNbYikFAq0v77W/IoPB4J+4kINS
4GtQzW/yjgy3gr8Ymx+Sgu7Sqhdq5WTou3+yqviwFOw++LEssZoMKeNRieet
pIDkfj6D850MQf2eehJH8Ho5CVaKtpNhKNBieOtRKdCsIHUHdJOBuv43Xzn2
4KuZVN5BMkQdXzenby0FGi7GZL8xMvyIDqgvxt62L0qUOEsGCZvN0RrHpEDv
qsPDG8tkeKISaBaLHaS3K05AgAI/vfN5lrBR31uFYDEK8DRIZhw6LgXPUkxZ
FBoFnNIHT7zAHiyNdI6UpMClAE/pcezD3lLK8nIUONIm8m/jCSmQYdtpv1xN
gWua3TVO2G7fF+9qrafASj6zunjs2GEXxVJNCjypeTRdhf0l3WzCdCsF9Cnz
e4awdc0URtuBArZ7KysFbaRgHecS9eIeChjO6PlysKsNP5sQTLCj3l1WxLaW
z419aEGBrJfn0pSw6Z0lY6uPUuBHesL6VdgbvnrueX8Sz0f2+RILu2fl2VDT
MxQI9CxR5MO+skbyU48TBfJ3bHnRh99Pk2S2e12hQO/ogXvl2HNbBmoZ1yhg
I3ykLRo7pna85p4fBQpdJCPPYldoj94RuUWBuG/t+EiRgvEgLk/APQqsdYjb
OYrX51HzkjwxnAJ3vfVRKrY8rO31jqXA2LHPQtbYoj+u7VlIoICPETtJAPvH
zx9vZjIpUO7S7qiP9yPKdfSVWy4Fvm/dmvwL7+eDmAuK0x8okL1+9eez2CN1
mSbTnykQlu3acxHHAyI/GHP7RoHB+oLBfhw/j1QF/s3gDC/cfnTyKPYa+6bM
+S4K3BA6rqiM480o1fSC1z8KVEwlHQ7C8Wi09t7hZS4FVPcKJ7fheM1UfRjL
u0QBhm5vsiuO57kO586bfFToO6d3+h2O9wkl441ColQI4vgdGreQgrJqxSYx
NhWapex6LQ7gfLTYzr4nS4W2+X+hV3G+VFTdBIoiFQ55sgJizKTgaXODIkOD
Chb/rT71Ceebz2SfAceICiSib3gtzk/6id7aaHMqWMdFbPyI87furNc0x4oK
F6nt+9Jwfkd9SOTjnKbCo7iSRSec/2u+mEhTfalwjgSMlJ1S8DnbPT0kAI9P
Y+tK+x243nATIkTuUqHw9HCzNEiB/UeVAzzRVJBesdfKQ1cKgrf4X+jMpsKG
SA39Xm1cv3RWVB/Op0Ky2Elw0ZKC5j0rt9UU4+dV/6DObpSCn3XRyrlfqaC6
e9/hMVzvvNbkHvDopUI8t1s0VhnXVx/KYBmHBkTHPoM6GSnQSm3zy5ejwV+J
AjkZaSkwVB35mrGaBhf8IkdOcaTg/NqqUw81aLB0JetmJ1MK7m+aLtm3lwbL
2dc4iST894mUcWcPGsy92rNCl0cKKOmfTpv60CBH7Ubq1iUOmB36J6lykwa7
2qc9NPH5EHdaaWXbfRr8d6p5hjnDAZN85pTycxr8VHm0mDTCAaWbWjvPNNLA
+V/W0b5WDhD3JRiv/k2DcSUPx9hfHHCI/raqs4MG7pNpZKNmDlS9t5M8MESD
Fd+eycbVc6DLfG6/JB8dMrN62sWr//d9Da6aOh32Sku9XvGWA/T0Q/scb9FB
obmJRbvDAT9CXo7JPTroUeK5PLc4oNi8s0blER0cdC5U9d/kQEG8wFJbPB10
HeSvp/lwoMTtSznnHR3Oc23mJ53xeDwhYaCbDptbdq2OOsyB1fkhHx4N0EG1
cJGsbYk//7ZdW2eUDgE3JhZqzTigc7VY13uBDpPpyU1jeznwR3h+voHKgBlb
nycLOhwQubpruHY7A2iHKE5ychy4barwSVePAdSvOk5O0hwIlm17lWLIgHpq
639v2Rz4rLHyxX8WDDAQvu22lYKtcDKs9iwDFv2mI/mIHJizjBGufsgA+ewN
a150SsKW1341d/8yoMHs7i3NeEmoz7y3Rb6fAW+UdXcox2Lb1adnDTGgyKo0
Thb3X3c2/HtaOsWAz7Tj+2buSQKxM3hPnhATCl9In3fzkQTmnS/EP8pM+JC+
7VPiMUlwaVWX1VBjwo1Nya0HrSTh7rdTRN+NTNgYQY/ms5SEkEYqg6TLhHpD
If4DRpLQOd8xNmvMBGFmzLP3WyWh7tpZkWUnJrRED/B/YEpC8qcrtaIuTEhS
6fdSokrCw7guabobEziy7Nj74pKwT/kzsHyYEHSdUX2ATxIOHeHR6Q1hguNE
63jSKBs62nd5pqYzYaFFwcWjmg35ZP3ep71M6N/goNN6lQ26n6JCBQaYkC8u
Z9DkyoZnnkJXTg8zodH5tWLtJTYkaIs0sSaZwL7jdDDLgQ0bUk4nApEFdSL3
QuAA7v93FvOlSLHgct7no5H4/nBzNsijQJYFPoXWAab4fnFeOf9fjTwLnDdM
+PHh+0n7ibXZnWtYsE5i29gJOhscjq2w+KrJgraWiKW/+H6o/ETZ7PlefO8l
W46o/WBB34hhwnljFmTEmLi/+Ipd0uK71pQFR14l28pW4vuku8KnMEsW5Kxb
cWvxAws4nSOPlWxYEMj8Z/0gmQXnn2U93X6ZBVt+pcvIebDgraKyQoorC55d
+sK0c8HvMzHPFsa/37Z3YU2SIwuiOVf6Pnix4Od/OsWytiywtHld2hLAgq/G
04KjeFzk8C3nhyJYsPWYzJiUNP5ZWTEhG82C2nHluFwGC0wco4cNYlnA+6A5
14TEgvprO0QD4lkg+c72jBteN78X5XXPnuP3O9napfUxAZ0vqIhIZUEL/xPx
jZ1MkPGw+H0jjQUWe6Uj834x4Wf3nR16WSz4nL42uLCGCf7zx1rt3rLANaH8
+qscJtxiBhaz81iw3UH369oMJvw9+PxyWT4Ler0jnOJTmAA5y2t4C1kQ5rFr
KCiaCcXNmxOly1hAs8lyNvBlQgnryMzdchZY+1zkf+PBBHOLL1+nKlggF5Fj
K4fjLn/Tt/qMzyxo95N8O26Pnx96R+dtDQvXyzsnQvYxcb2/4N9Vy4KYN0/b
xvSYQCuaWhSoY8Hpud+xB7czYeztxuOaeB9J6gyKtDoTEv8uqenUs8D8zta/
XuuY8NbyibhOAwu8Dzeqta9kQuylex/kfrLAjFlyMZ7JhDzzSU/+JhYcu7T1
Og+ZCXV/j0l1YCuQPXfbCDPhYdCplmstLLg/8GTligUG3PrG7Nb5xYKk0Iwj
3pMMYGrNvhjH1jFp8GkdZkBohdvW3a0sKG59XxPTwYDqNevG2rFpnETGfAsD
ttI261xqw/GHJv2P1DOAkJgmMYvtcGOXcv5XXGcmH5xwa2dBleRKFucTA7QV
plYNYkdpKx3yLGbAxO4Oi0N/WBBM6Z1tyWNA0tUT3e+wTX+Pi+tkM8C57eoX
cgdery+dTx+nMcD31g6eE9gKLIOy5SQGzEa8d32GHcl9e8P2CX6/4qRiG/br
uxXD5ZEMKN43y0vqxPuzUoi+7gEDrNf8ENDCjuwmE+8FM2D5+91VB7Brha98
mvDH8zu78cBpbNeySuej3gz4J/A96D/s3XvjqaVuDIik7pD8n11fy52OvcSA
PSrR/fbYHjulU1zPM8C/u3z0f88rJl3oMLNnwK/atLVbsDM39MupnmBA6zXt
WwzsnLcXLolaMYDhbSLUj8erXVDb1m/OAIp9S1w2doLlwOXPRgw4VlqqdwXb
JjwSpeoz4O668dH12G1hWXvvAAPWqJjFteL18jstlvDf1v/V4Yod/tj5cjfN
LDYyoE1vW7089nDTuN1WVfw+n0jjXLz+dxLV++SVGMCNqkjagT0fyeoVUWBA
5Vvt7zp4/ybMILCDwYCu1n3haXi/D+7YBLUkBjSv+8GmYWtkaiUWCjMg2Kd1
cxmOFyHr0tiERTrYpapXSGDXl/MYRkzTwXRnzOh+HG+feDNr7+Jz7f6yKTEX
x2OxWUmMLz4HeQ2cfrbg+H18p3nmWjsdinftWjfVyALD0fITV5vpYBiTq0TG
8f7mrp+n91c6rMjVSP72jQXXzxluePKGDof9vQKe43y6vK9ydXomHfY8KHvm
ivMtgNAdUPCCDj7Z/Zcnq/F67LTO6n5Mh+ap5ZBrOF+nL/JMWATQYVdG7GV+
nM9h5irX3Hzp8EPd86B/KQuScwqrYz3pEN4VNXyqGNfv/Ve5I050WNn66+4L
XD/at1Bj8w7RQa1j2LkD15cSV7WX42Z0qNINpJFyWXCm3euPmhEdRvX/nd73
Gr//lshQDtDhrH+/yx5cv2aiXjT/XUuH65sjzFVwfcu9s2y/ZRV+X51EmgCu
w8EHjd1CZekwM7OYEfOUBZrlGw8b0eggIWRE1Y9kAeH06PHhBRp0pP9lPn3E
gpM9L637p2jgc4bsMvKABTC5daiPS4M1PoNCp++ywMBXhXfqLw2Ue/Vv511n
wfeIN88Nv9LAtU9QOcMb1/GmC13nPtHgUdnYt0dXWfCfcuLa0I80ML5I4d1+
hQWLlX30oTc0OMq3oDzqgM8NWkN3VxwN1C6ZBXrZsaCycLpCNQq/T15WZxGf
J+FNQo3eD/Hfg6Ltf1rhc+i8goFqEA2uK9yJn8fnwsFkB97Pl2hwT+Dd7Dpl
XI+p7aTO3TTQ+aM6ScDnXZIs7boH0ODLOIVdq4Dr23C3AWMbDQwFogONOCyo
GHyYbKVGA88g2akmIVyP5nfL06VoAL7HLU78xecCf4qx3igVkHqPmnU4E7rE
/fZrxlPBY/Vw5ulQJni/Dsw2j6ECeaCI7XiHCSGeG1Iuh1Ph+64IMyc/3I/c
chUpvoP7+rZRvj24v1DVOGLt4kGFr2I6Ua67mbBi3UbhHQeoYDRvkjk9xoCU
+0z7FUJUIEqeeVmH+6Gb95Mp7rxU0KMutaf1MaD00MncOnwP4Zl1jXVoY0Cn
6Zk3gZMUmNvhITj+mQFsL03FxU4KOLCSvgQ8ZUD35qspxEIK1F4t21t9gAG7
ODn0FZcpUFmv2++0H9eds11NX/+jwMgXaU32PlxXErfRrp2nwL2MX+bXdjJA
NZz6sdEWf/+jeGCIOgOOmIr9uWFGAXnvT70zZFzXogvlclQpYCG9aCsozoD+
nzH/Wa6jwOTzpiwZnNdqP0zvTSpS4PBTMxNbAgME84ZYGjIUsI6at9g/hvNI
LUklRpQCrIXs3MYGOtANo61W9ZHhy49UP+fvOK7vUdvSu8iwqT/QgF1Lh2F7
SsimdjJM/inb51dJBy03kz2okQyDIXMTP97TwY/jvri1jAxLbT8sSnG/PFrb
+CGniAwOYZolBTjPt3vTLFXek4Gy6+D+epznPz2+99Bfk+Hy1ubp4EQ6UH6z
naqekGEGhQf9fEqHk3skf6jHkOHKd4+tG57gvKPvLwwPJ4Pya/9g3micR0EC
S4fvkmFPr1XKrvt0eFF2kFDoSQbj9nn+ibt0eKuS40p2JcNYsF3Uq2A6WJ2I
W2FziQy/mEf6LALpUNJU1jnlQIZ5r4AB5EMHTVExcYIlGQ44PknY5IXzeLEl
r34/GQosNq3VuUoHUeavvMS9ZFh9N+LANTd83/Ce8d4CZGAeO6mSewXXoUw9
jaWtZMjjtWETLtPha/412aJNZFig9r38fJEORN+fuZuUyXAn2oG+5z86GFTe
dRxQJEOmlhC1wZEOBUKHnB/LkeHuv0gThfN0OHfP8OoUgwza8j4mHWfx+tkJ
3H5MJoNFqrN91hk6uJkszoMoGUpHHY94n6aDuW+xrBcPGXhrz89es6eDVDrk
KE+RIEznlHqwHR2+FZZIHRwgwYhhbefzU3SwLov29vhDgtsCysMNtnQ4aGTd
+6iBBL+vj2pSsY91R9u8rCLB8erHYcdO0kFM9t9EXhEJAsZSuW9t6LDg35rx
MYcENQJhSvLYn58LRZW8IEEGq1466gQdqOzlgg9xJIjZ2JO+AtvlpIVS1kMS
iDvu/pBzHMcXLbYzNogE3t8uKB3GbvlwdtrPiwT2Tj+/C2PLDJpesnUmgfZB
ntjPx+jQuaH7yDYHEjhF2NpFYJcx8wvFrUngv8NDzAX75IZTKc2mJBg4VXTZ
GttE6PKKJ7tJICeR5XUAW0PNV/34VhJE7q8QPIydsEmqj7mBBNXaXuNnsbek
NBl/XkkC9cb98reww2hGjlfYJICteZfeYBsJC5tJiZPA2WVj+TD2MvMZ73sC
CVCozsJGPF6D6vR7FlMSIPPMaDoQuyTnw3LvPwkIeNce3ostaHvq+JV2CRj+
c/H9AbweOSc35S78kIBa5au7v2Cf3llB8a6UgPjnHgwzvJ65D15cnf0gAS2n
e0U7sVGH85LTKwmw614YWoP353w2v4dBtAQklUVH/8bebTF1My1EAlRWho3E
4v39vF6qUeSGBAzG3KQDjoct5fvP5Z6XAFaDS5ICjpej8QGlvDYSYF/9wobs
QIfQYXR7n4UEHFjf/FMMx1uWbNDtKh0J6HhbaSF1DsezzPZmgroEOOsOem3E
8elUVVakqSgBN9zeHwzA8Zt8+oF3oLgEnDvMzUx0psPcLvOBkVZxoN7JPzbk
Qgftw9wPld/FwcjMxXs7zhfjYR/5x5/EQWGfwutZnE87DrSWb34lDn+YD+h1
OP8Cey5f0PEXh7nOqINDt/H92U7r3bW14nCI9FT11R063Ajf/5EqK47Hd6z9
aggdXjIJvYlUcZDbfNZO8QEdZt+EpxbMi0EHqVu1IooO1Qcv8pZ8FYNirulB
pVQ6RB1Y8JO5JAZni3jfGKfh9XNaPOZhLwZNExrm7hm4D0nUba+zEoM0E/eO
36/p4MXonnLfKQblTfk3/+B6NzaWfT6eJgbSUjyu72twvny5OHb0jSicmg+9
Job7pvxgm/SPUyIgEnHlR/QsHUp13T2X/4mAc8wNOeUFvD+rUlnb2kVA+/R1
HTNcn4snP3W+/CQCYXlvfmaJMmD7iV9xlyNFwE3wnvtzOQY82dBe/mKLCPgX
XjL9thefJ4WGwb88hcFG1TreyZgBD7zSSF1OwpCpd7ND1JQB70P9HfptheHQ
4GTjTksGPJTmeT22VxgKWon/nuA+dos7/dEMRxi+zxwOIVxmwPnVai+b8oVg
Qe3NfF40AzKOPqlUmBOE8WpX6tbHDBgNlXwjPiQIq2qq0t7gPl0md6XdTLsg
bJpKMHmSiJ+378PKr+WC8PCgrfu2DAY82l7TejlUEKrtQofv43sCY3a0q0RJ
ECotkyrLSxhw/bw5T7qUIFTYb8iaLGPAoaYw/QgJQXj5Tfa2Pj5Pj60KO3dh
QgAKD+RFv6xjQIWUUblksQDclzLLu4bvMfrashcCDglAUtvYxPEu3Edn3Fzv
ulcArroPf9rWzYBpZXnf07oCYCF7gdmNz2/fosoxg5UCcCynNmByBH/+94sS
xgg/8GaGZLwcZcAJueslIp38YGQdpWE9zoDPlzYF8jTww8sPIhppUwwwLhL2
GM7nhz3MNCS4yACBGLXs+gB+8F/DunpviQEv2opCvnnwA3wq+knhYULRpgbb
rxf4YUP8zp98vEw49fS0RJU5P5zfckzumRATPPkm1nyT5YdexhH7fCrud15s
EmW85YP0IYNXX2lMyB06ZUN4yQc6Bcmev+hMOLTtau9wHB8kv8927MH3xNC0
E/FfA/iAz0tjfR6HCSd4f+2PPsgH14+8+/BECt+T01Q+3d/LB9ErcqN8pXF/
VG8dHbSdD0KaZFapyzJB0PrA2Wur+aDaqOC7kTwTSPaXda5M8cLdDPnV/Ar4
ffKPFN3+8cL7XoGIt9i7vt8K82zjBePDh/NEVjGB+LWfHVDBC8+qK46/xNa7
/H1zSD4vmIXkC+srMoFVfWs8IoMXojy0Dp9dzYSjO0+YZIXzglJb8cgo9rbi
uZnC27wwI9xw+fIaJkQ/P3Gg1psXtm94ssFBiQnPXHxVJk/zQqrdIauf2J+z
896IHOUFnebHh3esZcI+ybe8Cvt5oXS6uYiI79UnSbPEg9q8kN5aJ3UE++xi
fqGzMi8897Te9BI7t3qbRegKXsgY9BSYwhZYm1/5isYLeWaqt7YqM4FTdlm+
XhA/75PbW3fsJ/tST83ME+HThcPBWdiHnKLCZLlEKDpet9SBvdTim6f/lwhJ
77tExVWYYAhPfl5sIsKVp/fT1LEnjDQnYr8QYbVqc8t+7A+ZV+nVxUTI9im8
74BtwXqrO59DBHbOjkp3bE+NVVfWvyCCSf+pqzewRzIJxScfY+uuTgzEttke
sjIylAiMmls6N7Hv3RFK+naTCJF597Zfw9YyzDQU9SRCk8yWxAvY5JUfmQZO
RKhmBzocxP5WeY0SaEsEx0pPvy3/+3y/HKo8SIQ3exkjDOxFjcFE0X1EiC84
lDKA5/fLQsbADBFBCe1KyscOXhxbH6VJhD1DTZ1+2NW/Xh7tWkOEyW7JI3rY
++MCGjdIE2HDHkH+Zby+9eMfn3mTiTCimtD6GlsyOLaylo8Iau8HWk9g11Et
966cJUCvcPcyP3bOlnWqHkMEoG+5p5uE9zco44hHXQcBMk8P3NfFnluhqK7S
SADmpkIbKxwP77L95vsKCVBbryL4HcfPmqWv28xeE8DmmcPFndj5i+FOH5II
cHJ3zgURHG/u2tYVMXcIMGnhwz2J43OTz5sZki8BXoveYr/C8asfob850IUA
oz1VWlormXD1QNWs9xECRO/5IHMBx/92fs6tZWMC5H06fjsK54t7wlG4sYMA
KXFrG1tWMOFBvtOOMCUCnBqdPjmF8+/GigGD1ikeaIt4GN+L8/PYwJ/vbv94
4KxJ+Zpvknh/mnXyGW08IGB3bDSAxQTZTR3vj5bzwKWr12Nu43qgmTG2mxLG
A48Hhw02UZgwpa/m+imQB9yP/yT8JDGhT9tgy/WrPOD3IdhtWQyvl+7HB8u2
PNA+OMX3V4AJBeTYC0oaPGCWU5auz4/nQzekLCjywKb4xNPxuB6prQ8P/SHJ
A/Glzqu24Ho18WbKNITAA7NGGx7yzDIg9on2gkPCMuI3uuIjPc2AMCOl0/tv
LyNJFa/sDZMM0Lo5qoWcl9Ezx1QJHVw/N1Y1223euYwMRWwthnC91Z8NP/yw
cwnFKcbtKOthgKlVx4niqiX0oG1fxoO/DMhKjvWaer2E4gXr5Zl/GHBgq4aF
940ldGiv98Z3jQyYiXaqX1q1hN5quKz4D58XFqONlo1nFxGLUz82XMQAr62d
lkoWi8gzklPgUMAAG46Ny43tiyivgtdY7x0DPK5sMLGkLaK59qmZF+kMkL/q
43a2YAGNfWh3VYnA51nj/LZTtAXE+Jxlsz2MAUsl2S77l+ZRjwwj1jCUAVcS
vvbs7p9HRIldskbBDBijPqswK5pHQstdwwQfBhyM1T7Ze34eJf3Ky91kz4AJ
W9kkyU9zCK1pPNl+Ep+fBe7jr17PoY2Omnl+x/H5fGZVjGXcHAq3sL6Rewjf
FwMGdIuuzCH1INaqH4YMOFcSUy6jOIfYW7PvdKvg9TCP8WUFzKKwG17J4cN0
mDhZW+BpNoPWuTTZPvpHh3dBv0yWt8+gIa/gdyE9dPC3Khu6rzKDMtIO7r7U
RofI8KDIX4IzyLBbxHPqKx0ufz3lQS6aRh0uWgv8uN/he5aySlBtGq32HqvJ
SqHD4fbD7nay0yigxOP+wWd0KN9m1VsrNo2MPupPPsD3rcNjz47U9U8hprjd
r9ogOnCS+h19E6dQUsh0+XF8v1gf7s4bJz2FPBP0Bd7jfna/4RT3r+gUsiDV
36YepcODB5sEt81Pot/vBVyzzXB/f9NylN4yiYwaLc4VbKdDxuZnD69HTqKi
j+2uUyzcL+9/98WIPYne8YKfwicadPKGjcutmkDhm1r7fT/S4OjCmpwN9Ank
K1oe1vKeBrtebeCa802gJVPTIZ8sGnRv7479+XccXSQc0g6LokHhf5Ps9uRx
dHJY48nIORrctZKQpmwYR/JvN3cL2dMgVyL5sLfcOGK0TJvJnqDBu62tkrzU
caTw26tJ9wANKrovDx6YHEMx91LXmG2jgYPEQQV2wRjSSA3b3iBCg3O/dplZ
mo2hYxeGo97y0eDHeHSsmd4Y6tl+cTl8iQqeugVXzmiPoUcln+SNx6hAO5Dx
sEdmDG3mrTSLbKZClvj+mrWDo+jjCana3BQqHBgbLpy6O4r+eOW4XnxKhUD6
x5ev/UZRgO1fUaUYKtgq3N5wx20UDaj81Q4NoULcyL7CyJOjqNXffpXxFSo4
NkYbyGiPonhtryK3nVSQFKy6v9TLRZO+Vc03dKiwUersiEE7FzXFHhkI0aLC
j5yLuZmNXJQWc00hYR0VNFPTpX6Uc9G1jsOrCqlU6JoJDruSxEWyA8Y6pWJU
sA+TDkp5zEVyp2dSPglQ4QV7acX0Iy56tZz8vGaOAsLiz1tGArioZ3D+QWMn
BQJ5dn/dd46LXNLX3/n5mwKWuiKb/jvFRRregZuaGikgUyHk9cqa+39dXHk8
lN/3Z2bsy8yEUklKm+yVEHVuZClLogVFSJYsIRGRkjZFSmQvRUlKkRIiZEup
qMiH7JV1ZjDGeGb43e+/vz/fr3Ofe895n3vued/X63keKL83Vt/xkY52juda
JO5lQou09IaOIjpSGJfS+bqVCf0R9D/tBXQkP7SHOaHFhIXUwhftj+jI4saT
BnVVJpRpsVPb0+iIs/S9l6QS9pe3VaAzmo5exy3U7ZNggqN0tsd/EXRU68gp
Pi3MhEB/+a3dIXS0axuXWybIhDRPrx39J+go8oOi/X4WA9zynOKH3OmIdsWg
Je8fAwIup54edqajhm/7tXb2MqDRW1FvypaOet2OT+/4yoCGxTEbuZZ01Ndp
M53TyICQF979C6Z0ZLxjlYJNNQOsuONfqQZ0dGyjw8rQYgZssHmiuFSHjqoH
X6VMFTBAcWCFi7ImHVWMd59+/YgBVZK+Y9uU8XrW5+/S0rHdws3afAUdBXWM
h+UlMUBQzqL14BIcrwyddyWBASaVry560OlIZdmgb+F1BlSmqfuHStBRC9l1
+corDLCYN868JkRH5cMXDrZHM6De8LJC5gINVQ4iv45zDBhNbdBvnKKhXZEX
vF+HYn9dBiZ6xmnI3ZIzlhjMAKF97qu5f2noZ+LUlfJABoxVdfTI9NOQp2/A
NfWTDOgT+LJJq4uGxiY80YgvA955/lhn/ZOGtLZ8J1gnGOBgHt7g95WGBA8U
ipt4MyBhxkLp5kdsPzFVPuDJAKjvMCz6QENxN9KcWzyw3cah1aGShk5GXxzi
HGfAto70ZHIpDTmuMT9yFuMtMgdSCl/SUFW693oHjCPe6P9xekpDtEXeT29h
LHl2Pl46l4YaXzRYrsXztcvYZ1dn0dC+bOEAWbzeb11CNTSFhtZKPQ476sWA
JZkZ2zVv09DLFRtbhLG/EVzm4PB1GvLl0VrFcTzC5Gda//tOtL61a9jHnwGF
Jy9pekbRkN5H6fCNmI8gtgZTJYyGNCQ3/DXFfJnscb7ACKIhhZonSdWYzzVr
GllvfGkoQk5uJO0sA8T0V9lc9KCht5qj5m1RDJjYofh0nwsNWWx7ttgnhgFN
o6foyo40dN+5643bNQaksH/e4tjRkHY9N6EsngE2i3jbvlhhftIuC5+6wwAG
5+7yfDMaaqZQIm+kMcD3yFGjqzvx/BpT9iLZDHjPFq70NsDx7fwxP/CYAb+y
mia2atJQcGPItg+vGXBzmXX1ahUa2nhTL7WxkgGUh5eUFynTUPEgy06rgQHU
ot5vxGIaEurfe1L1F/Ynx89ghkZDJV0zKVX9DKg7e/7ktDjOr2Tai9IxBgwc
lRuc5VORcvtY5rgAEz6yfpZLTlIRdZthRTSuv1re7qwNf6hoi/iNZRaSTGhU
H5k900JFvF2aLiHyTHirOvL0WQ0VLflFLvilyIQrtjt7Rl5TkaX6fwKBa3G9
fkwzjLpHRQyvO/GGm5lQPXUy+2ciFX0J46gGbmPCXqnr7K1Xqaij7P6lzp1M
aO/7rbIokIrcDOcGd+9jgvJZda6mMRU9TOAdjQtiQlvugtsnXSr6HPCJ73iW
CXrf9HkBalRUEBAZ7RCDz4v4kYOtclTU26pn9DcZnz8uRwYm/0mjE3rUx7qV
TPhhHyqWlCCN7htJeBjKsWDsmOfR/y5Jo7YvV0UfKbHgipUNbcNZaeSmG6uk
q8aCttrY1d+PSyNPxuaWz8YsQIGyx4MNpNGmM/2jVcEs8Dglafr+rxTqSXoc
b9XNgr9me3ku3VKo1+buJHuEBWz5i9eF26RQsdUZVDnLArVSg+9HK6XQew+V
NwWyk3Bm5TEf8yQpdO+6SNeU1SQ80FG402UshS7sLnStrpuEV8WbY6v0pZBR
/t/Pmj8mwdJyS/v/3l90eHUu5fXgJKR+95eLWC6FTikOHpegTIFyiEGU5ZQk
Ol1l8eyD8RSoZH8Y9XwoiS50X7OUbJiC8DfKJr0USTTxLaviwa9pqO4a0n5C
SKBHJ+NrKCPTIMrc4BU0KYGOPPLp95+bhidb/3MT6pVAvzum/josZ4Nk1i1f
1XIJJKHqbHveiQ1rc22eewRKoFizl0Ol/WxQlvFvo3WLI5lIEarqxAwE37eb
r2gTR9oRMqdb52egspki4PlRHIn83VJymor1i+0p/VdvxBGaqzB4jvXO5rDV
Ltq3xZE5g5LfFcQBufk2h1xTcaTfHmv5i82BLLfOPyMFYii1bE3Rwymsn1rN
AhweiKEGwUC2HYULLq5Xb9TcFUNiEc//MmW5sPA2Z2lMtBiqcjUfmtDhgrqj
bnP1ITH00EEkfTyECy+j1IrpgmIoVk89++o0FzSLa0tWzIii5AWXXU3kOfgQ
UlK+elQU67fiholFc+AV+9FvyQ9RRFJcCP+jNQcF/x4X5uWJIqV9RiPhPnNw
JWjT8UPWoij+devp1s45OOUgzx82EkXlBu09av+w/nwSPR6sK4rSNdtkPNlz
UDqQvCRYSRQ5LHfrCKcSUOqRZb10UgRliL38uNKIgJJSDV2pOyLIJrRc/Gg2
AZ9DjVrUroqg+qCxsZICAjauyqkwiRBBqKI9cewNAcKJ5J5j7iJIjhWnwf1M
QGOSzKztFhEkNGwVf3OWAFPVyBPibcJIxvzDsxdmPHDR7ky82yCM9uobbfKw
4UGWYtynlRXCaPsB17QFex643W66typXGJ3RD5L97c2DlctO6o2FCKOwYa+8
3bE8OHbHyszORxjZeYQbKd7mQdw71c8lR4VRgIdE5c9UHpgKVAT6mQujLoV0
+6k8HmRGz1/NWyqMXFMImf/qeND5vKBsTEoY3TmeWNTyiQfP9lGa1UjCKF/6
mtajNh5wf8eU3x8RQu+VIpsE+nigaZdp6lAuhF6EL/Jyn8Pzh787LH9ECFm8
NlYYWs+Hnlp2rJKNEPIOep+wWJ0PF2RUvdbuEkJ3yw/1qm7iQ12eq8taNSF0
clUdlWTIh/1/vhYtEBS0JHBt3hFrPlin11ZMMCiovllgosCWD7KKTl2dAxS0
VPKHZN9BPlQEOCTkN1OQyIlD36ed+fDh0u6tKukUxPtqdfGjHx+YA7vsSTcp
aC4+/Jp+IB/utidwOqIpaNP1cx43gvlgfIzRd+4EBRWdIB52h/Nhs9+YqbUz
BS0bHCV3RfLhHFPaabktBUk1PtCvPM8HCbPUr8/1KaiHsF2rcRmPvzFqdlqd
ggb6ajvLr/IhQ0MvR38VBVU6j7irX+fDoH8SVIhSkMlus5nym/i+dS4hJZxH
Rkus2LyOW3zI+eIorsskIwlZ8/ZfiXxIkt/km99ORjlLmoWu3OXDui1063vN
ZGTz1mazaiofNOvN425XkRFpDixfpfGBslV6a0wxGUUm29uszuDDzEjy/uDH
ZBRj4QinM/lgji8Fbulk1P6DsvRZFh90qxuUbW6Ske7kku6me/h++LJzzOAi
GXk52V1vvo/tFy8fWRdKRuu+hygXZfNxvxOIovqQkY6MUW7kAz4gn3MuHGcy
cmwPpmk85EPZXh2p37ZkZNvd4l6LcUax461aUzLq66M+2J7DB+V5Ze7jbWRU
l81pyMA4I7ne5roGGX34ZfKzF2OrwdAcv9VklGla9kkslw9nrP0E9i4mo0W5
sk+XYBxg2BWgKU5GAy9lA8UxviQ3J0idJ6HvKuGK/fj5WcSrGmeRUG4TpTgL
Y/o6+TfNQyQkbx2sgTBernZxKu8XCY2fuppQj/07WBZ04dJnEhriCPzSxlhW
T8HPtZqEapMzRaJxfLmSJTWGJSS0W0pR4Q2O3+JeUPySJySkL2+0+Bvmx/xQ
bBcrg4Rsg5vYXzB/o+nab5sTSOjA71NlxZjfK98ztXJj/vf9i6B7BOb/iBdl
77kzJLTui9akCs5PQWWa0iFfEgr+UuNegfMnaKMmLbqfhJ7clJy5ifOd4nDb
qNeMhGhNxrLfkvjwuYbvWGpAQvn6XXIcvD8O7yvz8lImoWvFmjUsvJ9MTEJC
0BISstp6wrc+jg9sHalUeQkSsh6gcKPw/uvPz7ZqmhREIoUOpdl4v5bwxWaz
/wgiY7PEEbEYPviNrP4X3imI3vFU5w9ewPWqYfhRvUYQRRSFNd47y4eHhQOj
KbcEkfnEuf5Rf1xPK/KWnr4kiArl8uXP+vAhyqVxYl+YIPJAmzQYnjhfC6wq
KVdBVH3bfuaSC64fNQHtm1qCCPm+fRRow4eg1o66wDWCaEXz+A41Sz7cCN1j
cUBeEJ04IGzdYsaHA/k7jFYKCCKGbszW5h182L5yf0rVFwFUYSI3W6qK/St9
U/KwRgCdN4kh2a3D8ZxuU7tWIoAgzb7nhxLmU6R6t326AEqe6VyZKscHVYv9
KqKeAmiVx4iK6jwP9AeKCnz4C2AaYfdlAz7fREYyQeToPMy77m4ccuHB07Tn
3qYm83BofXKJnCMPJk6Ju8SqzoN0X9KkqR0PnHiV00qzfAgZOuTzwoQHEqOd
ibG4jvNWxNa92ojnP9l50Bmfo6aP669pzBCwJax19eRTHkw3rDX/wiBgTOFi
w3V8Lr8o+H0ncpiA1DiV31+P8mBTiMiwUDcBy9P2LM6ZI6B/umO48wMBdjd/
HY3UJuA2L61sZwruN25qLauXEfDc1v2XfyLuH85nDVtIBNTxRo8VxeN+Rbqz
V/f7HEiwGHpRlwjYEHb4s13oHPi0d1vsDCbgH9ng7UaXOSje80x7cwD2Z5Xy
ItHdc2Dv+DwC+RLga5W48+eyOZienK8sdMfPd2bJ1lRyYeDyuNPkQQI+hfj/
+fyYCwmOTj+/2hFAW2R3uzeBC8IyQc++2BAgEt73fNkxLoT+NJ7WsiAg0bVl
m5ElF24WOz24Y05ASOTB9gDc9x8u/am63JSAyiuVZwZEuDC1JgOvTMBsQl/K
etYsmGWYrrkMeH3KOoFTnbPQjMTssrYT8MpfvaKudhZunF0U1mVAwJxTaufK
Z7OQVJKgs3MbAUFHJbwvJM/C1KGi9Z/1CEgRWHt6JGoWSptzJ87rElDfckXy
sPcsjISlqjhtJeDEoR+GbbazkNVcHuqmg/lZXyhjZzgLHSoGZ25tIeDl59dZ
nWtnIZ9v8nFkMwGaP+NGvamzsPqFuNRJjMtafogIcjmwO/9NjyLG33ZpCd7v
58CmA2f75jYRMFK3Y8j0EweGlsa8JGO7a8+DanYJB066CjD0MX6gOP+w4B4H
eu8o6mdhvJg+mepzjQNohZSmNl5fYZfSy02nOJBzbO7kFMYbTTZyBJ04IPNN
Nn0I+1uR/TLslykH0lpi94ri+DT+HjJ9i3Xb7rpYtSM4/n8PKk9kL+OAqqLx
tz59AuzdrkzfomCdZ9TflYr5ay+yY8ViXViRljwRg/ntX1Xnf6NjBq4mxOc+
xPwzDCPDk2tmoPTG7P0ZnB+nWytWPymYAedZ0vlzuwi4U2B26kPyDMQYdvUZ
mBFAVsg8++/8DGyrKTquuYcAAb8qczmfGYibfJXvYIXHDzM9r8EM6HDY0/v3
Y7uW8Y+vKjPwKPOW3np7At7G/du+SnYG/txeVLbpCAE5H4p0u/+xQUz63BQH
78fnpcsGzdsw9qgbLvLG8XMP17x7h/HLp2lP/AlwT2Huqb3NBtMP0k8swwjo
dDwe9TOcDTv/Jjs+jiJgNI7rz3Zjg4tzZf7eywT0TNs3H9zMBndaTsaNOwSo
nKc5p2JdTSrcwV2dgfnZ+J7zl8wGDW/tE+I5BByL673+5Ps0JHHa57+8IiA3
Y3uBwrtpiNH06i58R4BcuM/KjNxpCNojZjpYT8A560V73odMQxpzq6p1JwE1
a8Jq7y2dBp0gq8gdQljP+e2OCyVNw386QYOdNB6870vfeWR0Cux9lla3KvCg
knevxPIdvjdMPbbp0OGBcC39d7PrFBiMtArY+fLgtnavtJQFHv9C3nIgnAdB
Kv3Vh7dMgWqo7eyPazxY5+4wt0pkCja0OA4PYb1X9Umw0e7ZJDyX+3S8cRTP
b+Wwgnx3EuQOVDEv8nlQXpJ04/35SWApyzfmUXG/HE6ieOyfhBTd4m/aOnzw
enTfz4nHghf5GVcdLvEhep1kbtQfFoh1Nj0Pxf1MdlQq/sVXFjStb5EUfoH7
GbPg/Y5cFhQNyf4J6eJD6CuTcum9LHA9mmdSvW0etJRsbufpsyCcne4WZjcP
U+oPivatYcF3vY4Heb7zkPibvayVy4SI+AFSwP15iDxsnhmXy4SmYduwMqkF
8LwX8e1hAhM8nFL/GW9cgPH+J3+a8D1USSrNw8JsAeqXNC6Y2DJB7F80pSN6
Ac655KpkbGcCM8Ssxzl7ATIO7T9PUmGCm1jUDs/3C9C9oXlxmCwT1ny7u8Dq
WYD//3/d/wNYKjNv
                  "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{0., 5.971128595179588}, {0.981121613481143, 
                6.8439051570994}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0.981121613481143}, 
               "ImageSize" -> {120, 120}, "Axes" -> {False, False}, 
               "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8], 
                  Thickness[0.01]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> 
               False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0., 5.971128595179588}, {0.981121613481143, 
               6.8439051570994}}, "Frame" -> {{False, False}, {False, False}},
               "AxesOrigin" -> {0, 0.981121613481143}, 
              "ImageSize" -> {120, 120}, "Axes" -> {False, False}, 
              "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
          ImageSizeCache -> {{
           4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
         False]}, 
       Annotation[{{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8], 
              Thickness[0.01]], 
             Line[CompressedData["
1:eJws13c81e/7OHDn2PPs4RihlCIZRYPuq5IohKiUSiIt3kVZZSShlFKyk2SU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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0., 5.971128595179588}, {0.981121613481143, 
            6.8439051570994}}, "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0.981121613481143}, "ImageSize" -> {120, 120}, 
           "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8], 
              Thickness[0.01]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"]], Axes -> {False, False}, 
      AxesLabel -> {None, None}, AxesOrigin -> {0, 0.981121613481143}, 
      DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
      Identity, Epilog -> {{
         RGBColor[0.368417, 0.506779, 0.709798], 
         Arrowheads[0.08], 
         ArrowBox[{{5.824925002498502, 5.952209624055743}, {5.775326411107623,
           6.043468907330329}}]}, 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"", 14, StripOnInput -> False], TraditionalForm], {
         5.5, 5.5}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 
            Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], {
         PointSize[Medium], 
         PointBox[{3, 4}]}, 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"a\\\", \
TraditionalForm]]]]]\\)\"", 14, StripOnInput -> False], TraditionalForm], {3, 
         4}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], -0.25}], 
          ImageScaled[{0.5, -0.25}]]]}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 120, 
      Method -> {
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None}, PlotInteractivity :> True, 
      PlotRange -> {{0., 5.971128595179588}, {0.981121613481143, 
       6.8439051570994}}, PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
     GraphicsBox[{
       InterpretationBox[{
         TagBox[{{{}, {}, 
            TagBox[{
              RGBColor[0.24, 0.6, 0.8], 
              Thickness[0.01], 
              Opacity[1.], 
              FaceForm[
               Opacity[0.3]], 
              LineBox[CompressedData["
1:eJwt2HlcTG/UAPC5U3NnKjVo0UKi0IIWbYruSUkiihbtSdsvQiIkS1qEVL9W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               "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
          "WolframDynamicHighlight", <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
         StyleBox[
          DynamicBox[
           (Charting`HighlightActionBox["DynamicHighlight", {}, 
            Slot["HighlightElements"], 
            Slot["LayoutOptions"], 
            Slot["Meta"], 
            Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
                Annotation[{
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   RGBColor[0.24, 0.6, 0.8], 
                   Thickness[0.01]], 
                  Line[CompressedData["
1:eJwt2HlcTG/UAPC5U3NnKjVo0UKi0IIWbYruSUkiihbtSdsvQiIkS1qEVL9W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                   "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0.5362793865677238, 2.}, 
                "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
                "LabelStyle" -> {}, "AspectRatio" -> Automatic, 
                "DefaultStyle" -> {
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   RGBColor[0.24, 0.6, 0.8], 
                   Thickness[0.01]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> Identity, 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ParametricPlot, "GroupHighlight" -> 
                False|>|>]]& )[<|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0.5362793865677238, 2.}, 
               "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
               "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8], 
                  Thickness[0.01]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
           ImageSizeCache -> {{
            4.503599627370496*^15, -4.503599627370496*^15}, {
            4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
          False]}, 
        Annotation[{{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8], 
               Thickness[0.01]], 
              Line[CompressedData["
1:eJwt2HlcTG/UAPC5U3NnKjVo0UKi0IIWbYruSUkiihbtSdsvQiIkS1qEVL9W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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0.5362793865677238, 2.}, 
            "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8], 
               Thickness[0.01]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>, 
         "DynamicHighlight"]], 
       InterpretationBox[{
         TagBox[{{{}, {}, 
            TagBox[{
              RGBColor[0.24, 0.6, 0.8], 
              Thickness[0.01], 
              Opacity[1.], 
              FaceForm[
               Opacity[0.3]], 
              LineBox[CompressedData["
1:eJwU2Hc81d8bAHBce93hLqSsImWHSnUeKSmilIYIJaOBirLJSCgleyQjiSTy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               "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
          "WolframDynamicHighlight", <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
         StyleBox[
          DynamicBox[
           (Charting`HighlightActionBox["DynamicHighlight", {}, 
            Slot["HighlightElements"], 
            Slot["LayoutOptions"], 
            Slot["Meta"], 
            Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
                Annotation[{
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   RGBColor[0.24, 0.6, 0.8], 
                   Thickness[0.01]], 
                  Line[CompressedData["
1:eJwU2Hc81d8bAHBce93hLqSsImWHSnUeKSmilIYIJaOBirLJSCgleyQjiSTy
VWgoFZkphGzKjGvv8Tu/v7zer3vv53PG8zznPKTOOZlc4GBjY/vLycb2/78L
XdGKJsc6UWWWb36TBwm4K3NU3up3oh3y5y/l+pJALOpL5sM9nUhoNfDMnUAS
zCgWL4Vs6UQ7d7b3oHAShG65afFMuhO9/fveXSKSBJX287vUxDrR3DVNg+VY
ErSvcfsG8Xei0Xf7kt+nksD/jqvtYUInavhwWyrlKQku5zo0eS93oIqtRT0B
z0nAy3dcmD7bgSw2v+yyzyNBiXLGMdp4B1Jo1llnXEiCoeLaAY/hDvT1lF6c
ZgkJONAeIb2/HehT/cPjG0pJ4HDCjvtGdwcqsF45yveFBHdii2n87R1IXck8
YvobCb7GZ3izt3SgxlNBIj21JAiZTvQ709iBNnMat9b9JMEeJGTN+NGBqkzu
971vJoE++aL1troOZGi3Tj23nQRUDpkv+dUdaJ9NzbfHPSTgyXpWHV7ZgfQu
u2Y87CfB7UeXSqoqOlB/6mjl7RESrNxo/2lT3oFK5AS0vMZJ8Kvm0knzrx3I
TPLJ6LUZErhqhobmfelAJ3PDxy4ukkDX4FmuFfbB6ZSdNmskeJamyX0Z+zM1
/+dZTjIIN2Y0/MA2V4t+Y8ZHhtYbtqcj8POeOMkMnxQmg4v0UGsWfp8WS/XS
CREy6Dsmx4p960BZDTHaJ5hkKJ6YbezF4w1B8uYnJcigvu98I3tNB7pm+q72
tDQZ1q0ca7mB5zuvtTnCQo4M7QU7ZHTwerzk2595bisZ2tYC5yzxeimM/iU5
qJIhwO1p7M/mDsTJ1VvnrEkG7UJhvbi2DlR3ndjrrk0Gu8NK+/O6OpCY+T6D
QMDja3FtFv3TgQK6Twg82E+GqlFT1DjYgZJlJGQeHSLDCDUtfvtUB1JzlrB4
e5wMt01ZpJ75DtT6gXCr5jQZ+Hxi7ZpXO1Dgidm1zrNkuPCn5F22QCfSGjlF
4XUgg9BRBtymdKLLiq6Z6x3JgAgROTminWh+72yC5nUytEQnH2qW70RO13xT
LnqTYT/helf4oU4k8Vx0d18EGccz/3gOzgfrI9/aOWPJEHdcd4Vo0YkyO+72
yCWRIZv7LCPNuRPd2Zknce0pfp9HUHhPQica/1p9k/GWDH4Voi+4MzuRzIH1
rQUfyUBN0m52LehEoQGU/qPlZPihwXtHqbYTRd+T4Yn8QQZm9sD4GKEL/Qko
Ddg8SIagkIY7Ld5dyKcv0fQZjQLaC6HyiuFd6Kgha9xSnAL95kffvkvuQtVj
E/qiUhQ4cmZk6s7HLnQI9NUjtlLA87R2ugWhG5W/IhFjdCkQZrUmaGbUjT6X
1v6YvkoBVZLbaZlT3WjX3MKbbzcpsHt8eyTHuW5U3d97KdmbAuudAkbYbnSj
ysNKOsYhFNiXWbPASu5GPi3+peUpFFhaLO5RnO5Gq1VdC0L1FMhaNQ5oe9aD
7FyPtHGqiABaGrx30fQP6rPs0/fNpMLM0j2+E5Z/0MsWwW0OL6jwXX7mLjj8
QY5x38yOFVDhs2T8uIj3H/TQ2nKdfCkVeJAU5f2TPwgM/xb/+EUF1y7fGcvp
P8iSvPUFg5sG0oQ/c1KxfxGj5uoImw0NbEQ2SNxN/YtOF3vNNTjQYG599I21
53+RbJTFoQwnGqzofBIgfPqLFIP5bu/1pMHPy4Snt0f+otqov8kXHtJAgM37
R/nefuTbHpwBH2mw5PTqg81yP+K5r+PdLkoHwey7h5P4BlCVQDnfjw10CHb+
mj9MH0AR7Rfg00Y6ePl0x9eqDqB4P4p5lCodHFIe7X9jP4Dy19olCAfp8FZw
16RL2wDq2it5dOIGHTRqk0MODQ8guU+B0rFedFi7E+uye2EA7XjhfFbLnw67
6lr+eDEGkWLTwlfbe3SwjPAMu2I6iK5GhMv6ptOhnP9Qi3PzIDoo+zwjsI4O
vSjnjOHgIAqC/LKKBjqodrXlGSwMouN/svk5W+kgs13V+Y34EKJWRlbb9dHB
yjT6sdG5IXRg20JP6xwdpDt1hY+7DCH5klNyf5bpEHqn7Z7f7SHk3dgz18/O
AI71xy2PPB9CCzVhw00CDHh02ODZr9khZLC41H9iAwOi/sosbeAfRqNHLpyQ
kWVA6gn25EiJYTSgr5Q/IM+A4senri/tG0amMostJ9UYMPT9dHFL9DDSeKlZ
1rCPAW+LcuNlYQQNhW29JW/PgOS8vcrfjo+gq8eqWqUuM+DKK7JOjMMIAktP
ERFnBshuUdhSEDmCMvs3DrXfZEDEsXLThaERpLmZcFIwmAGvVwr4FtdGUFxw
6kRZKAMMrJw65Oj/0EZn5xHncAbwP2VqCur+Q2/8c9++imZAdMzrQbbH/9Bh
aQpvTToDuOwim6+//ody9BKbtDMZYJNcH0Kv+4dEta/5pWUzQDteI/TfCrYW
U/F4PgPYpbdo/bEcRdrj2eIHPjCAEfN9o6HiGKIKbhC1+MUAVaJBd++BMfT9
4K4N6q0MQIaGGbnnxpBtX8/qahsDXB2yUvrjxpBgbSOfWw8DKJHG8T08LNQ7
Vho8OsKA++EefzbLshC73+1I5zEG+Cy/78gCFup8NTk7OM6ArMyvm008WIh3
l3Fg8QwDPprVh+uOs5DpienR1lUGyBiFSWzkGUfDRW5JPOxMKLl5+KsufRxN
lL7uVCAwQUQ66NTPbePIJXjc3oSHCbGejwqVr4+j8QdHkuWITDAPi/rIGzCO
ap/HThPITNgi0Vyy9HAcGRFKrv+iMOEhgVajVDCOzLZJaZ2lM+F5gHHIl+lx
tEfdqX1xHRPOzBnP1HJPoEta1+89X88ENzELtWnmBArWarQ6KskEVXbJPTG7
J1AUX3StlwwTFoQYSeQjE8ivyj6GYyMTnMwfDT07N4FOXLjV7b2JCaVHfl9V
uDOBirkdTppuZsJb9FObmjiB9i4/L8hXYEIuR7uIaO4EyskSHydsZUJdTKbg
9cYJJMXvYB+qxISOubxZa+lJtG+KwpJSZ0Lq7Uru9ZqTKLWY8ld5GxP+CS1Y
Tx2cRPVTwu7bNJhwMW4Dc+jqJIpN/dMqpcWED39OcvDdnkRbOdV+8W9nQt/b
zSd0EibRnaLz34exWUnrTi+WTaLI6TOMBzuZMMvyifVonkS7L8VEm2ozQdRq
xYLybxI9JT9youxiwujmH6nBtCmUWz0bfW03Eypr7HJtFKaQft17Mn0PEwgb
HlmfQlMosXO7fj72wHnb3/4OU8iCW33fd8SEgsfaysU+U6hScNMOE2DCJgm1
g1xRU6h79b8DtdiNfsMs26wpJNcYHww6TDBx4hrp+DCFGIHhpBxspXsyHBcb
p5AK9+FF4l4mzPv8XeYfnkJjR++bX8Y2GBpJ+7g2herPEo0/Yec5N78NpU0j
U9ngIWFdHE/F+kSHLdNoPj5P1xSbzaHb5ozONNr+Zr9rFDZJBgVan5xG0dfZ
Ymqwve5yaXhemUZh5QnvV7B/H2zc8yxgGsVk1hHk9zHh9ZqBw2D8NNISPuFn
gP3ERMhLO28ajUwMH7LH3jlQtCe1fBopHTrg6YPNe47lJtoxjW4Jb9wcjp1o
d3QyfWoaWWnuuRyLHZzkew34Z9DBYkPzBGzbDLFPY5IzqCScn/z/zz9t+pyR
qzWDlHNV0+5hb/4qOuhrNIMUiF5y/3++5sZS43MXZtCmrPSi/7/fY+TYE1Ov
GZR6/dyVw9iB79xenI6cQUzbaxZbsXt31ak5Zs8gAbd7KVzYW8kzSw8/zaD5
lCtGrXi+Mx336itaZpBZS41PJnblgR1uguMz6BXtwkFn7D1TsSVWPLPI68j4
V3Vsk9QJRS3NWWSRVKH+HK//4x9zggaHZ9HBZekyK+ywkDmJKzazKNgzOpyM
Hb0xgK3t4SxSDAnXvoD316bxrN2m7Fmk6rysz4utnNKg4PtpFhXLHRl7iuND
XFZ+8uT4LIopvmnWjONp5OnJsGaeOXTrn5qRA7Zoe+nz8xvm0ObUNPU5HH/D
k605KUZzqAMcFXmw6YMRvzNfzKH9ahZHF3F83xD50xz0dQ7dNDh/wBF7Rjw3
37FjDlXrv+3txPlQcPrgRiuheURNVT7/egcTKh4taL67Mo/uptSvAc6vrJnN
JxVUFtD9ZIXDLapMOOHyQuyR/gJifAheL4WduVHuAsN6AUXdvrpsp8KEyMKk
YqmHC+jx52KtcZzf6imjocHTC+hi+WfJ0S04Pw8TpR1KFhG8mrbOwfUkySW2
WPjgMrLa41fVwWRCQt0U3cJqGdmw2eySwtY49l0z5+Yy2vPz9qULDFyPAptI
hk+XUaf1lUPjNCaMbfp99R5hBbWdnOeliDDhz4FUron3K0ik+ZdHtBATaoT9
kVbTCrJ9fsZgVBDXmzT5YM9/K+jQrdxlPWzBtriHK2KrSGMs9RCbABOI8p86
em+uosSphYi7vEyYYAifF1RdQ2t/0EdxTibwu3QobtBfQ3YDx+UTcL2uQ8VH
FS3X0LqO8ihx7Kk6u7md99ZQ99mMz3IcTEizTZfe+WQNbawMyH6F630y/f2C
+ts1JNeX1gnYdHvzVfrQGqrvvX3Tjo0J3R2HmtbW1lDu0/e4G2SCYaiL6VUB
Nij6xZRMWmOAqb7I30PSbPD4W7tZFz5PtgsAoUCRDSLfP/S6je2iZsHN3MEG
8u8bDFSxJ7Oi37cYs4HJ1Y7JiBV8/rlVXNt2hg2cnOOrDmCXP6UT79mywV5i
hTE79ksX4cjeq2wgPGXp/2EZ3w8kd65t82YD0U8W53yxXYZljwfeYYPM9SUs
XeyjJLOH9ZFssJDnqCCIvXi5vsYymw0E+CoyM5cYUColX5VWyAaGomeHPbB/
Kc296v3IBg5T6r+PYms1fAveUMMG6bv23tyK3XdY/uDpZjZACf6f+LGbOlLm
7veygW/+WNG/RQaQy95Hfh5lg2dyfhY/sWN38K+fnmcD9jSVl2+xrQLIsVKc
7FD7deHFM+yuu1Yru0jssOr9a0ccdkPT88rj69hhwVmTeRebMfRk2V6eHdIC
yQcDsUOPrsS4b2OHlmTLGj9sgQTb+NvADh4ZzLRb2J6HH3I+MGQHW59tVbex
C2dVW6NPsYM38fm+B9gxknOMOBt2SNrjQk7GXjWN/BTjzA4ZE8Eqedi1UkW/
IrzY4YZwZ2o5dq8w41TIHXZgeThe6MGmP7PW845ih4l1qp5seP4H3Q6mXUlh
B9PfEn0y2Ob8fpfNctiBLX7rIwPsLUOvM3SL2KF+j2nWTez4x4+NNn9hhyf5
93meYfsWjdgJ1LPDmeaGN+3YJR8MJ4fa2KEhWrSEhvdr626XsS8D7DD285Tw
MexXH0QskqbYIcwl5L8obIW69j3Oa+wQYpWe8xv7xqxfFAhwwBev5FlZHC9T
7ySTf0lzgHsHw68c+4+z77EkJQ7IGw0qlcDxJ+3g63t2Jwc8/frfEXds1tHN
e1qOcoCuzTb73Tiet2k8cEj144ASv5aLCzjeP2vbDBy6ywF6Uw5a13F+POi4
0DMeywFh5p6mE9jH1hcZqr3kgILslaBFnF/dXwjUsA4OYDd79Aa4cH41vbzN
HMKfPzUgdmCHtdA806Y5gCm6o8ibmwkO3U0jzwUI4MKdv1KN71f+8hFs0TsI
0C+ndiKJnwlrizejuPcTILJ8VvMMrgcp9IyXLkcIMFpcbL8e14ui43E+enYE
kNEUK83H9SVlndHDj1EE4Mg6pymI72MVFke2ElkEmEhcPPAA1y/Xg40ZoQsE
eMa1o9ZfFJ9fMo7SBE5OKFwWormLMeGr40a5ESYnZG6z/ueM72fneZwcY/dy
QsP26aJ7+D62Xb/hmnU0J1gt8HzxxPcrD43L1i8ec0KecpxTNr5fndKXNp/N
4oQCD9OOdlxfy3Pk3Hw/cEL2+K41Q1x/n5NtzBwHOGFPJbe5Gb5fbTTl1Svd
zgWUqE/XN+Pz4sW7zTvb93JBnaAgisLni8UtJ91ZQy5IlBKr4cDnE2U8K1bK
mgu0P9luGcHnnwBn5gnTEC7w3c+3OniQCVVEuReqrVywpTJ3NO4EXl+C3ctP
N7ihfubEt8prTNC7YH7wqB83rAyUa6S7MGHQsH9TZwg3uPAW7fG7gc9DwZZc
VhI3vF3mlNnvget5H419sowbUmoTty3ewp8XEDe5CPNA4+DhG+SH+PdfUhWu
pfPAqa+H9Kf/YwKqa9rzPIcHLtFbRHXeMGHuWGpmTyEP7GzdcDuimAlW6hvc
9b7xgG/7V6XdH5jQ3BqnMP6PBxKm35eWVjDBMyBuzxcNXpDXZf2+2obvh3/M
PLy+8kJ2cfJTTy5ROMH2wnTjd1442Xq08DqvKJi7NyVVt/DCgBjtkJOAKGhO
P4on/eMF0TOmVc5kUdiw7p27N4UPFtV9ghIlRCEgJ2PHv7N80Gvv9cdfUxTG
70302c/ywbfBAA3Vi6Lwc38obJcWAN17wU+rm0ThhmV+2LiCAIRXHhCYbREF
/28No8/UBUArbXS/ZLsoCA2wRMX2C8Cya6KgS68olA5Vca3ZCcD4l1P3GCxR
eJ++ve73CwHYMCpdrcsrBi1tJ9UZOwUhr3pXbvsOMSgP4djft1cQDIQeOgzv
EgNp94bAPANB0Dpx0m0WiYGdR22+kYUgnDHos+TTE4OuBLvCBD9BsOtu5RQ1
EYPmCSsu9wpBME7jpzU5iIHTUE1r2AkhMBz+9OVSrBjQtxVZHbESgtmAH/ft
EvDzm+9EMi4KwT+icJLlIzG4sWawOddbCJZOBO/cly4G4t9uGK48EYINAjXd
HbliUJ2/X0FxWgg+nNxssf+rGGhOdDyRWhWCmsvAtVohBsRRaW9RXmHgaHKY
z68SA+aU7HWRdcKgNHfZX6BeDO7KbcpR3ScMhH9BNwJ+i4FtNqeAVLQwfO67
5+A+JgZiGz5GH3ksDBL+HPe6xsVA/z+WcmCWMAQ0OnLBlBiQRCVK594LQ+Zo
5hvWHP7921pf8oAwtJuNXuNlF4dJ6QPvz00IA51w9T4iiMOSOfN80ZIwVBO7
gpy5xOG21DbqVRIR2nKnykr5xCGy7Yqu6E4iyFw58p1MEQdGedli+D4iFKe5
CdKp4iChcew6nzERdox6PxOhi8NL97hGQRsiKIvGly6KisNi2I9wo3AiuGqe
f3tDShzuqd2Bsj4i9PGQW9cpi+NzxH/r8TEiBIoUPM5WEQdO0cKU4XkilPAO
5KiqiUOhzws3Cg8JSFbM51s0xCF/9PS47ToSvIpUyPy+Uxwk/cssPkmRYOf7
vxT5XeJgONHWKSFHgv9UzP667xaH0FsjhA5VEuRk+NfxAZ6PKafK9QMkGIw7
I922Txzqn3tEdBiSQKfv4ra1/eKgJqn566AJ/rzZrHbdAXFYF6Q3IWdBAiPn
8fR9B8XBY8vxLwvXSFCh5HX8wGFxaDrrEXPNjQTNSWLC243E4dOUu/ioNwki
aZ8cpY3FYfn8940Dd0ig3bxD488RcZg5aPZwLJkEDy7bHFh3HH/f9edRlyck
APbarN/Yd/SKIpeySLDAdqHhoak4FM3H3BYuxPOd0Lw7fgKv57DLloQS/P4S
D5mYk+Iwmh66U+4jCWiP2R9qnBKH6DA53/3VJAhy+Md57rQ4yFZHPvtVT4IP
cmZkFjZzil3W4RcJzPLXc90wE4cuidz5iB4SzPwqfXX1jDiEq/7YLz9AAl6D
py792CeNP9aU/iNB3s45RVNzcRiqqnGanCPB0K5/MZIWeD93fPe9t0KCCLkE
I2/s1Qa7/M0EMiztLhdqxH4pHbJazksGrcuuLbJnxYGQu9H6gjAZ9JNzXjlh
O68qN3BSyaDz0TnlP2yrpASjDFEybP5QnjGFrUM6Vau3gQzCgQXlWy3Fwa/X
7OCQLBkWV7R5rLBDE6Pf3VUgwwrjwqV72HWfFyVVVcgg8UF97j/s131ezr80
yODQnpP7C/tVgHCGlzYZ/p1tip7EVt6aViSjQ4Z81Vd5vFbiEH9BIaNajwxl
oE8QxbYsirdxMSSDsltShAz2v5zecQkTMrB9KbCUx/7BHulne5IMp8ZfvJTD
brffW/TSnAyvska4pLH9+HkjF6zJ0BH68gIDW524JLDPjgxJSrt+8mBfeay2
/v5lMhQrNxpN4fGk9n398vsqGdbkSzpbsQ9w1ixuukkGzUKVoLfYPzebv73u
RQZ5J4/9cdhvve6xf7pFhkcTrdLO2Dc23vwmHEwGi+YISV1sT0MVAYu7ZNB4
+0eHjL1LrP7L8wgyDGvRQn/j9VV9c2V8MYYM+wcvLCdj1xtIhhxKIoOInWjS
WezeFcmx4adkkNUucP6O9xMuP8rTziHD/Nf1OX7YG1zCau7mk+F86JyUIvb2
SeaK8jsyMLcsVd7E8XKmuJ/H/xMZZnc956Bj/37rf6qxnAz3p376v8TxlU/1
f+P+gwyCJZG2jTge596KvKv5RYbAtfx6S+wrUD+5oZ0MrcdN7vfj+H3vv6mv
vJ+M79cyjH4c7z9P1++nL5NhzvtozgucHy4ndUwuslPAVKWSRsWedo1x+MBN
gdZvzaOuOJ/OvzmYYUumgCvjy+wWnG89ReYVrzdRgE1UusL6qDgcUbiZyr+V
AreH49me4Hw9zKZseVaVAt5u78t6cD6XejZc5dpFgcZtlDFjnO9XJdwuHj1K
gd0S2rvmDomDlCR3S/oJCqh8PE2nYwtWD7PPnqHA75ntkSq4fti/pd6Mt6XA
jUBd/1O4vohev27R7kmB8nU/H7joioNTxuO6w08pUJi17lA3rm/8dXM2gjn4
eQrNP1N3iIOPx0+jqnwKWB6cvXF2uzg8WWLj3PeeAhltXNKVuD4GDXTsU2qk
wL6Y3ps2uJ42ZF/NaGEXgcTY4+WvZfF4ruwNDOERgWbBW/NbZMShZqO5yQ4h
ERhce3wnCddnH4Z5ejRTBI43n2pwWo/3b99mB1AWgcoIpeAuhjgo8DXwnjYX
gWH7rYID+Hy4ez/g34y1CEx+eUai8uL5+OqeibDD9s4o3MWN81mz7+PnayIQ
5/N5wo8D12ej3Su0EBHgY+fPbFoUgxp7zdKLhSIAewKyCobFgHBN+H6WIBV2
bd++1RKfl68n1SdfkqnQ6fzmuAo+T82zLc79R6dC8i0rqdUyMbhg/tr8jSQV
oof3Zd//IAYeEbpXMrZRYcfPeI/QQjEo1DuctMGcCpdfSjO60sSAn75+k3sW
Fd6YbTrM6YnP9/Njtdq5VPjto7P+opsYfP0xr7D8igpirpVRNa5i8KKqdcH1
HRUm78hdC3YWgz9bkpIPf6dCs6zJWOMFMVh7lZYWOk2FzD/EsTpjMfAUfHNH
fjcNruxOZyIpMXD08i9Z0qFBnk3U93kJMZhe39ZYrUcDjZzimFwxMVhad6bw
3BEaSF3INhWmioH/38wvF8/ToHHFPiaZWwy2jxJoPXdokPzVZyPHiChwryAd
ox80mLq9NawpTxQ+N2d8f9NEgweilofJL0Shf+xHs8RvGvRQqZIHs0QhYSr9
QFcvDXKFiXM5qaJwEOns05qmgWH4vUv7H4pCpOx41nY6HTKK6p2Lr4lCiGH8
iP1JOgxF3F95oSIKMWllafpn6JD5bt0b362ioKNyJ0TWkg5i6j8zDsuLwlH1
2pZ6WzrU7S+V7tyA73vJAdJLrnQwbupN+CEsCpd3fguMjKTDH/UTtzn+4f7j
ycOcbbF0aBr2jowdYMKmQ+HffyTQYf/8ZJN8HxOMg1cX1lLpYHa6bhH9ZsLf
BzxBW/LoIMcT9gW+MeEWpTf6XTUdYp9Jm91NZ8LpykcD4t/p4B6n8f5PMhNa
Pmxgu/mTDllDJaY7EpiQ8/SMm2QrHRImN8o1P2DCb+X5zdBPhzdXPxj89WbC
7dPDBS/X6MD9bu2RwUkm3Km+67hdmQFu8Sq3AfdXznaEf62qDNi8M3D8Ju7X
5DkNT93cxoCJi5flc3C/KCvhMpCxgwEca2xSAtMM2NjKdeCHLu77/expT7oZ
8KjZcq/5SQbk2z8SPFiM+02H+nUlpxmwcHiFdPQ/Bjy4GhMuYs4AkxqB8yde
MuC/97rSxVYMOEfXJp3OYMBNU76rdQ4MKHAiOaEIBuzvce5b54l/9x8HxNoz
4Fg+JV3VmwF1V4jdN88zgHnpXpqOLwN4K/8cPnGWAeNuSgbHAhhQPsB6JXic
AXf5uLJ3heFxmBb6WyEGNJtva5JOYEDoNYedz2kM6M7fwzGUyADS/c83L5MY
wLiQwch+xICQE2yErQIMkP/87O+6VAak2MvLPGXD83K44volkwFcm60uBo/Q
If3D+kQ6nhc17jeN6xMdgrKdsjILcd/d/K9V+y3eF37WMbU3DDB/TNa6WkiH
UUa89bYSvN4l5/82Z9FBdN49abiUAeSSbuWYh3TIYayvPPCJAbWtu3+X3aXD
QpiKWXIZA+5dMHYau00HwvmP97S+4vm/svLf60kHf/NLN0WrGBD9cdKh6zwd
kgqsOXWqsduzgjnP0mEMcX+wrmEAXf9Nj/wpOjgPuieG1zHg6FrGdSdDOnxY
PpWf8J0BI59ZpRF6dAjQ5G55XM+AL5VWVwuADqn8I9rRPxkwGBqydWYbHdY9
UrsU1IDXvTTrEE2ZDvr77e87NjIAbSqb3baZDhPl7xO2/GKAnm+O1HUJOmyX
mlgwbmXAkXmJ7hEuOvybvCPE85sBkVavw/jY6FBTYtT5Gtu4a5Aut0iDwxKB
iWztDGCRR6etx2gglEfwSMD+b4+cue8gDXZs/rGwtQPHx/Wa6iSc53ylrp+0
O/H+DcqPNv+iQV2D+dIbbJMU/YKZevz90vySrV0MuGPyJFukmgZnvL3m47E3
ajt3qH6lgS7/1xdr2HEx3aZHSmnAcS6ywQLHsXHq5vVOxTTI8GOd+w/7Xawv
hBfQQPtcz3FCDwMMX9MrXrygwS+Oq2mHsJ12yLyrzaRBwNmn+0Kxoy1aN4+l
0uD41ZBtZdiqllfEiEk0MNWSvjSJnechEqcSQ4P4HLcesV4G+P5byzF5QIMt
tVEPtLGJE7bnXUNpsD7a5+px7MYvXl/jAmlwi22P9wVs7SeuHe98aGAt0Jbj
iJ1XHVTY40aDH/kWC07YT2/2nOS5ToMOVu0ZB+zwP+/qFK/QIPaTeq0ZdrOR
oaypHQ0EZWL19mH/m/x8ztsa10kS26eN2LpCp6KenqGBQ9ANjTU8Xv3fuz7X
m9LA0YfjUT32pZinC0vG2HPPx+OxJXwqdeQP4e9/mo+0xBbKtfcp2kcDe9If
yfXYrweaSw4iGij0fIpowutpv//CWtsO/HuV/u4g7Es9Z487baPB7OITXmVs
4i9KGUEZz3e3CeEH3p+E3d+PxG+mwSOJb2ZreH8f1cVPVqynwcv/tueEYT/f
uo9uLUqDstcDxSTsGltlryURGoyOHZnixPFyq4VNZRsfDYLWF4i44HjK2hcQ
/pNAA4mc9Na2NgbQZn2OXFulgkmjL4rG8TgYISb5egqfo/Yijf04fvvyTuwx
G6NC8OGgORVsI599PWuDVHi/cqwxt5kBafeu/DLupMKJslP+vTj+pTn371hs
oQKrKuyZMPbuh9x7nzZQYX1ijd4RnC++Z/1sCZVU0DD3L7iA82nnj8aH/32m
wsHjr29dx/n27ovBbbsPVLjSPrjFDefj0djWvp8FVIifyGRuxPncX7Vm/TEZ
3wuIvpPLOP9VZKde+sVT4fEhF7baSrw+9e48ulFUiOHnSzOtwPXlrvt0bQgV
jp8UsODF9eTxldrcFRd8b+Ag7Ej9iPcX+lW/O1GBmVckrobrkdN2Anv6RSpU
8OR2ar/D9ZnD/8lRKyr0GYy/HcP1TbFDYqjagAqJBTzKB3D9437X+1+eHhUM
OL09Y18xoPDhOmKcDhVij/0I2YDrfPUDuQeOWlRoNTrSUYPrJzlv4wttGSp8
65J1iI3F++UlGmuxJAL3DXNqXKMZ8Od50kTwrAi0KiQQDCMZ4PD7JRROiEBF
jv6vrnAGsFk3tDEHReBJm6H7kyAGuOpu6eFsEgGF4fO9gOv/QtKhtwfqRaDW
QHK60Y8BPoZR3+5V43uXu/xyHz5PmlqmEmXKRMD14U/eR1cZUNG0xnbzpQg8
NHaWmnVkgIVwuHFjtghkT354q3eZAauVQ0IaT0VgYannY50tA34lQQXbIxEo
zBeO9zqD81Fkyv5jqAgEtTzqOo/PwysRMYa/bUVgM5vbEwT4vPk26nvpnAjw
NMSepu7Gz2u8+HrNQgTuvSifeKbJAH7vIZKqqQikJP534dZmBgRf9yl6rSsC
9aGXSwjCDCjRV3t9QEoEkrduEpzA570O37p7xp0UOF9bsfVLHR2Ovvd3/d1K
AWPaxOWHVXTIlWvrsWuigPvlD2WSZXTIiy2WDq2hAP+MDydvPh3clOMMRkoo
4H/iSq9YOB0UIjWvMOMooBaTS5fG58C7hqrQrmMUMOzb9UvzPxpY+vRzKX0n
AxG3Y7x5NNCqCOk+XU2GlOQm/fbnNHg89mIpqIIMv/i9FkPTafBa1PdXZynu
k3T7N/BE4jzLcD72MI8Mb491Rt+/RgOTV2Mii7gvk+uv1Q3Feb87/8Bi/HEy
jB58kPpDhQYtNOH20iNk4Praq71ekQYVFsH0v7gv/RH663bFRhpotsS5Ke4n
w1emsZgFgwbh2uc3FeK+94W5mlnWEhUCO6Z+xNPJsOlUaIPxPBW0+J605lNw
nxrxT2AF31/TxSTLv+G+PE/fUewyzms1ZX+VKW4ySIa+M3ncQwX7PlG/Hbjv
P++udswJ52lw/ExBUDMJZn50hhuXU8HmQvyyWgMJ7OMe+u7AeSs+89qps44E
nTKUJYX3VHCr8sxTLieBn5z3m+B8KthqTMWX/EeChz3O80X4/v2Yd+u2U3kk
sLzu9Gf6ORUuujBeTj0nAaMhfPu9p1Rg+ElLy6aTwMP1nJJuEs7bI/WLDhEk
6Ooqkq3Fef6y3iZu5i4J2sIk3p2LpcKpD39qfO6QwNNC5GD+QyoMGnxuCvEl
wXDru+1dOO/jmWU2t66QcJ5ERFUGU6FnxO3NvD0JnE7dDP4YRAVF9uMnr9iQ
IHmHx4vGW3g9zCNPG50hgW217cl4Dyp4vVu5MKZPgiH/xm8jbnh+dx5tMN5H
gtMsm68GN3EdsaJ25CAS+LaSDLbhuiLi2GJtqUmCaaP4Z++uUSHF+6LKf6ok
qFhrNTa5SoV1vwQEuRXxfL4ckMlwpILPlkMLKTIkqMs/IXPuChUUhIwow+vx
+MJ6qFsvU+E0u/IBFTESSL1Wcul3oEL9sKnIfyQSdHT9LPxlT4W/XzheTQiQ
ICXz9YMGOyoIeJp5buUhQWwZW8nkBSqYh+btUF8igsuYfjsVu8ezaj52gggv
HaKQrg0VCouaFOYGiJAk2VjrfR7X1Y07mo90EiFibd75yzkqOGSe4cpoJEL/
5BSFgd0r/eTdVBUR/vUXPnK1xnXSy51z9yciLFQoL3XhOjkSv/eP3xsi2Pib
0E5g0yxtz5e+III/B/FXsyUVhPINQubTifBs2wm5C9hJLqcttiYQYQuX6NTK
WSrcCZ/tN3tABGsrfZk07NS+EMXA20RIVmtKPYqdfcpj+zMvImjZ550SxL78
U4lYcY0IgaNVqj8tcL+nIVzcbU+E1lwaIx3byM5398xZIhQct/P3xaazymTU
TYmQdtTVwRa7T/WC9GUDIrDtsnpzEttA2Q5SdIggm61/8hh2e39l4HctItir
GW87jS17Knx2QZEI8peidjhg5/kXJm2QJcK74e0mAdhEW/ABMSJ4H7BwyMRu
YVdJMycRoZwhfbEJO8I0iOjCTYTJiUwkhMdfZaVTe3tZGE5dJjYZYVNlLvRG
TQrDMQl3WgI2IWnCNHlQGHYlcv0bw5asHlBK7xTG/WaT7mG8fqsv9V3SG4VB
5yQfbyH2xkM0xcdVwiBc9klmE15/uXgjq5iPwrDt2Ab/FOzopBlqyGth4End
KyyL94/juIDJzRxhkKwxN9fD+8vdcfuWXpwwiP6Kmv6D/fbF2C25cGGQn6Xa
3cXxka5SuYkzUBhYP5yCZ3D8mBn8ds9zwuMvCRN4g+NLr5ei6XdBGIByjX7L
Fn9/c9krgzPCMOQgeUUJx+tExR2+X3rC4KEQ1TRyiQqhmj/HiySEIYYt6gAL
x/t/+9pd7ESEYXn+XPwizofyNZsJMh+eT/b4HXlnHF8esyyzaSEg+Z4x7sL5
1uKmUfG+SggMWm1ubrhBBc7eIw2GH4XgEe/eFlucn/enJ4kthULAQovj/Dif
qdTvmn0pQkAJmNR46ksFKxXCWs0NIWiZU2iXwPlv0uJ0bM9lIQic1qYm+eN7
y6ZLpBxrIfjX6dD/HNeL4Hxyt5ehEPQOBVXR7+L5eu5MmJYSgjbbvUY8CVTI
uPk7YW+NIL7vTDh+SMTjDxI6rlUmCF+8b270eEQFb9lrRpuLBOFYzwHSWgoV
pN+ESXA9EQRDuVKO3c9w/GRLfUnyFASeDrkQjzf487t/thxVEITic313g/C9
KvKKrNJskADuE4XnN0nheyOfDzhp8cNDy5KaPBkacNduKFvewg/ltQ582pto
YMF3r/COJD+sUi/bHNlCAx3Bb8JJfPzg1rF1n5cGDWjEAtP8Nj7IqRH58vUg
DT4+n7qb5MsHnE1iEXeu0oD9ZKPFs3JeSCw+dHcG36tjp5dkKG95QSJx/y6r
GzSQXe3S9XzJi/dNw0bJkwYu19teGMTxwvJHhZvP8b1d5+3Dmb8OvLB/Z18F
LZYGP39+yeYW4oUJt7M2h3CfsbWPz1z6GA9QEosJW9/SgChb8vCgPg8sXDI2
4n+P+xQvUrPzbh5IUTnT+O4jDb5dtIktleOBtV5dpYUKGtTwJVmcXeYG49bO
S9VNNBhM7NZ6ksEN98KCy12babDOXo6jLoEbsvS2hKxrpYHH1kHq/H1u4BqL
1LBsp8FU9F3pwx7cMJ68s7AI91V6hcf2Lxlxw+CNc2lFuA97ffVq98V5Lqgw
OxsoN477kua7IwmjXPA4lRb2cIIGEbRZ9+peLihy7J8xn8bjo9kpK9Vyge4T
6+qyBRrwjxaeX0zlAuGLut/qCHQg6j7anG/ABXSpuJUVTjpEGldLjwAXKEXb
Uzdz04GdLv57oyYXkKpzmq7x0uHbt8aIR5JcYCIgotooSIeY++l3Y2Y4Qay6
7VEVlQ4Xx/YN5D/mBJLyiFk+jQ7/LZQFKUdzwpa3/L2RdDrsUHcSyQ3lhA35
6XsMmXSwpijy57pygkrr2bIQcTqsf76zvNiAE7x0ydZG6+igbLIJIR1OuJ+y
KVsY97Enh2fKvmpygklc+hb/9XRA38UXmqQ44Y4ur/c2KdxXR/v4EeYJoMw3
vdaEPT0WlB8xSoBdd6OFrkvT4czyJj6pPgI0K8sUP5ahwyEqeaduHQGECbLG
yrJ08Lt/QOzXZwIszROsSrD5UyaVLhYTYN+r0N6yjXS4eu4WIeYJAQ7J6xnC
JjpwB5lUKSYQ4MQmfqli7JPrrzeU3yfAjw1NS0lydAiJ8S5Z9iBAf+34Ao88
HWT6jz+OdyaAqcOeY47YXfdONGrZEsC/No5HEfftahUFu9yOEmBYv8QsCNut
cvmG2AE8HrrWQgu2MZcB8cMuAnBGiHbJKdBBSJ3Gd16NAOaky7zXsPkEftrx
yRPg9Nj2q2+ws/fPK+VL4PEGhtLmsXUSV63NRAhwZ8ulCfUtdNj05QwnFx8B
zu3+y3YJu8Tttmj+Kgeo4+88wj59debJ2WkO0Of+nl2Ffcx2Q7bQMAcsOB3b
PYUtTPLc+qGLA5KyEqboW+nQu8lX2bmJA3wEX1ZqYEudT3stU80BixMJb42x
1b3PfG35yAFWBfZfbbAdFKUs77/mAO5s6T4X7HVbLwYfyOEAHeUGkh92vuoL
HfY0DrBOCjx0G9t91iriXSwHfDykczcYu15t2d39HgfkRIr8DMCmPZ5Z1Qrg
AK96LqYndsrUZ5l5Nw4INJM2u4JdPtgxUuzIAaJh16PMsEc1S8y8bTgg/C3h
815s+5jv1/eacYDm/o6ejdj3S6N28h3hANtb/KME7C8X/V792M8B1yqju9vx
/M8e4etK1OaAvBshRXnY/8k//WynygHOvSxnX2z5nNrzGnIcwGvbwHXw/+sV
OVvGKcEB3832XBfCLouO/dNE4QCamHZhDd6ftMtyNc94OcD84UqMH/aUmSpP
ygo7vEr7fEoJO0NHyzp+kh04NXxmmnA8RPI/7YwaYAekvt7+JnbS4+GAh+3s
YBIc9ZyC/Xj4qunDH+ywWfxnSSaON9emZyejytmhPctWvhTH5ya11rXkPHaI
cnvspYP9/mZObmYGO5Qrnb/zHsdzBmff41cJ7HB8wehVGo7/7kTFM98D2SGk
51S5ADbLXVypx50dxk/lezvifKnVkzSdcWQHnkfkMkmcX+eOS+fLnmaHyN1L
+5xx/jXbL4whI/w5be5EMc7PCJHEhxa67Dh+h0S2S9JBv2FiXYoiOxTUEW0G
cP7LP/hVvJeDHW6++/ODA5s2MpJ6dY4NHqoce8rA9UJ7i7pI+j82cDn20VFR
FK8fh0C6UDMbsItpjPPi+mOYVjnFnsMG5+qVuVgidDB4ezJ1fyobBJobnKqj
0OEGr+9SWAwblD569sSNRIfP/YYVkrfYQPhgvr6nAB30jgxvv3SCDRJpZysU
+OmQbMZT+cWADRYFtS814Hp4jv5aUUqHDV7bzW4j4Xq5r6ktoncLG1jtDjm6
nY0Op37VPbjDzgZ/62s98ldpkJ++JjU1uoZUbWXHZFZosFL5A7W1rKG4W25f
p3F9LuAfFfqQu4YGRn6+0ZuiwV55wbDvZmtomsT538s/NPikcuyT0n+r6Ng3
Q1oPPh8W3MIN21NWEZ2fv0uwB5+vVgrT9++tIuXQ9pJjHTQo6/tQwWe3iogC
JcvJ+DxST5mt0hdbRc9uiY8rfcX9I7dfzOqtFURvICTwfqZBoke2s4jTCiqX
PTTYjs+37SOSssrmK+jkphE/13c0QHFb9Tw1V1CcykkBuwIapHGe+WQ3soyK
GhKrjVJoYLR7ajDxxDKSlHjr1fgI94u5Zd0y+5ZRdruUsGkiDcLcKx0LVJfR
XfGP3XoxNOCbfOM1JLiMujYxc0fDaCBo8l/2q89L6N/fRWUDfJ4X/+F78llt
CZFjc7mtDtBAVUCqQI2xiBLbeYy499FA+0pe+mHOReRpLiyRCTTgfPtX+/rE
AtrSo3WhZQcN7lteedxZvYB8msNlFvF9g+2/DS1atxZQhk5b4B4iDXK/Bu9g
H5tH53e7B9wXoIGi0J382rZ5xFvNONHGg593su1TRuU8Grx6KfQ8Gw32az0d
cMuYR9oVq/9pTlAhjLz8L8diHk2dttnz7wcVJu038J6un0NlgV7F/2qpgMst
pf/DHOKMHzw+iPvXjS+eZPi+mEPfjv1Yq/9EhUsJpuktoXMoeOTGc3vcn8Kj
qBQZvTmUfSX1duF9fB/3Xa1WKJ1FV/iH8/r1qTAVpa1m93YGMQ9n09P2USHq
U8iFFzkz6KfomU+ngQoS8683syXPoEFvxsx7LXx/fv48utpvBgVnvt1rtgk/
H4ZNlvRm0IbtBe1/OXB/NrROrLJpGu1//O+MTbEIpHw7KuSyMoUoY4/48v4T
AZPW73E241PodlFv2PxLESg/NRRwvm8Kse24p+T3VAQMGE8H7lZOoUvb1L9f
jBSBnuJD/x7ETKHnNxSj/rssAmm11tI31KcQSUOp20RCBJSm6jluuk+ib22K
UueYIqBzmcs5xXESnf6+29hJRATGh76ztZ2fRB9r6BEBfCIQxuM1E2A0idwc
bW9FzVDA0CyQ65nsJDr2Tq/sbC0Fun9OPDRunEBhFWB/5BsFKAs+12OrJpB1
5yVX+EwBa9dZ5uTHCfT0bEefeDEF3gYuiHW/mEAn5vr7Pz6hwNjd9KbUOxNo
2/xZ9SpPCjgVycz/1JlA+49bdmfcoMCHdCPrYzsm0DuPfEe/qxTI1ixSGVSZ
QPdPNBxWs6PAO7uki8aSEyg5tnwkxIQCVkHLsgy2CaSfq3GcuBm/T6bodtrn
cRR6QD+7XYYCsv++3nN9N44WHGrPZK2nQM4L26SzheOI3+MNC6gUcFR5vf16
5jjqpn7Jc1gjg9fn7gNZd8eRxJOQ/c+ayJAexRZpeWYcxUBQ8sp3Mqx+b3kp
YzqOcraeLjepIkPg05wMgvE4MlK8lbX8gQy/l66kMnTHkZBNVJ3xMzKYy9l5
R24dR3Mk2ssnaWTIEd/KvVNuHH33M89ZSCLD11M7r61IjaORXk3ZJxFkWBd4
2r2NMY689rWLLnuQQcT31cAc5zhySDKdMHElg1H8D6UQtnEUrRConu1Ehu5j
xArneRY6LjO/3syGDI78pRq9AyxUolDc9uosGW7f2PxxpouF+NI2KQieJgPR
m6ii18JC3GKraR8Pk2GFO6kquZKF7rzp6xbXJ4OGtYNHZhkLPVq93HxzLxnc
CGxiY29ZSO6zNU1Niwxfan+pab5kIacOfecHqmSIr9mtuj2LhcZ/V2WztpCB
+entZvd0FjIsjvmbJ0mGgu2HRIrjWGhZ03yBIk6Gxw9vhRRFstCDHwUiN2hk
aLovwTkfzkJXT57Z85tIhuLE/K83Q1lIIJYUgPixpX6Qtt9moYqzESMZnGTQ
vEeU3+HPQiTvxFtCayRIOshm5OnDQpOzey26p0jw8Zxe/eebLGTJOvPaYIwE
h2LK8qtcWIjTbeZ80SAJLL7tyRG5xkL6lrVOm/pIYGVjxPHYiYXirqf2RXeQ
4E1T4OzlKyx0NkC5kruFBHXBrtXel1iIYKGh4P6TBPz9BZ9/OLDQVJ0zabSG
BI1nGqQc7FkoOvNx0LkKEkQet5PfZ8dCJwt9I1s/keClNkHsvC0LpZbX6Zq8
I0G4184d5RdYqDPrUErNaxIk+qd8u4Ltrpj/Sj+fBNrF3/jNsNs3fAwsf06C
ljC9vWHYzsYaknpPsS+8yGf///NC68IrUkiQ8epB4nvsX48P/j6USILUjoC9
pfj93hY2gvXR+HkmYkPceLzsD9uVTj7Av/cc+BF1kYWqBJwNukNJ0PnVBzlc
ZiHd+PZLl4JIUJh43SXQkYWaebvj531JUG5/uqDfmYVY8tu7gj1I4B73ec+D
6yw0W5G2X9SVBBox+0/fuoHn+1/HrxwnEpyvvba/xJ2F5hnXV5MvkmAs65L6
ihfe33VvRCMvkGBW86Gkrx8L5ctGq4RYkeDpdm5dCGShjMj5Q7fOkGDj9YF6
uMNC22tqnD1P4P3NNmW7dZeFTFRXsm4eJYFWujMPewQLdQhK3rhxgASeg1tc
PyWw0MaDQ0z3vSS4+V5AnyOFhTJ3vxvz3k2C3TaM6oAMFhJp23osXJ0EVVqq
JQfz8f4Wz7VXbSDBtUuDcgPVLGQRUjvTJUYCXd0UO/UGFlqT5701RyOBvLA/
b9lvFqo7d1pYSRCv3729epnDLNRUpid5mIcEM1VWxquTLLTFR++LIweOBwH5
h3FLOB9kTb9cn/j//53i6qq5cb6eq24uHyCCVkWLvY/AONJy/GS0oZMIo7qK
gsdI42iI+87T7ioioD9Hf58TG0eZPctFT58Q4aOHXugGlXFEUWelb0ok4nrb
d+6vBv79EO1qTgQRvtkTJeq0x9GF+B2fK32IkBE8IMirP44eVVn3HjxNhJ2U
6Hz6uXGkXvdCZN6YCKYq/1mM2Y8jX66ihud6RPC4uk18wGkclXqLV8psI8Lr
1tA3O33GkWDCC97jRCLsyRmfOJc0jrLBQ1mRmwifDD0ytJ+Mo4E5xZsCK8JA
5q/ap54zjiq4LdWah4Vh6uSYug+ut2rPbzRnlWNnPz/i2TmOdmyfblH2FQZL
X067X3ITKEJaTTLWVRhaXjskHFabQI8u/HEgXBaGV3rTAn92TSAB7rIPw6eE
QWvts8EVkwnEL7UpaFJNGETLTuYO+EygiwcKdzYPCIEzR4qvcscEaosUWPQ4
LgT9PMqmmTmTyNb2cqGVgRBUjZkPmZdMoiqK9L6De4VAKYezbtO3SSTP9yxa
WkUI3HcKbpntm0QXOno3TAsIAW8k1xP3dVPo4nOtYMIXQWjIHCdXPJhCM+Ie
Jqc1BMF0UaabETiN+FvVhFK3CgLdUvHIhchp9FXulu2QjCCg8C+1b9Om0S2x
t688KYKgve3FU/9P08jhTU7vE5YAnFnoKHNcm0b13ZXyS1kC8GKPM7h5zSBp
f84HuusFwNV2TFHIfRYR1x2m+tIEYEdWD6H9zixSP0TaVCwoAA8Whu5nxc0i
T0LfS/klfrB+fsgXFc0iE8Oye1PN/CCXW5Z7eG4WcR58vrg5gh/iueFftssc
CvNBbRns/LBawF268eI8mm4O2qi8wAeuzhelN7vNo52nR60Lx/ngdWf5Jenb
80iA5OxZ1MUHm7y/pc+kzqP+Wdfi2Pd8QPUMOsJonUdSI6T0XDc+4NuX1Cq4
fwG9bq//wubMB45m6VLGJgsofHCS3diOD0KaJCQCLBfQh7AXcV2mfOD2tFqq
1H0BKT5T+vhdDftyKp/fiwXE7Tm6vXuEF9hNRu4PkxeRzhbN8tFeXpCegCj5
9YtIblAqbraVF/5mBooeV1hEz76oNS5U8MIIr0bCtb2LKDbvksbXdF7QNKkX
L7+6iCJuePNfMOMFu9iJ8fs1i0jKV+xM22cecFivxK58bQkZh5y54VnMAytu
6/jSvZYQy2JOhf6SB6KVj3Ku3l5CBPv+l9oJPFA4nNlgn7iEunjVufWdeYCi
VPadjO/LkpXCqU7iPBAbZSuQL7SMktLDv38g8cB7t9qtUfRltHyYy5CPmwdC
U/p2n92wjMpEfMwejHMDdUZLKVNlGf29rLRm95UbdA9s1xE0WUYKqZRpPUdu
uKB9fFX6wTK6mRax4ch5biiWKVtziV1GVPf0A6anuMFWS3/0RfIyCsncVHxs
Lzdki70Ja8xZRoOUXcek6dxgZNv8fbpiGZG+9UYJCnDD+z0ftvjULaMdphcV
pta44OTriatjjfj982VehUNcMP/u1LuAnmW03mnLOPE9F5i879x7a2EZfRh1
4OjM54IA2d5hnbVlJHKgufTZUy54nWzrOcS5graF/bXb9oALeLiFTEeJK+jL
Oevkjee54KNG8J8K2RXk8zFT+/dJLjhXdaiqdPMKerx0sS3MkAt+/f0ck6y0
gq4LEI36Nbhgy8h4L2n7CupLOKvqzssFI19Gdb4dXEHNfpeet6xwQvPa3dW8
wytITPt1k8YUJxiFH2sNOLqCXMNCzw51cEJDTuLgwKkVlKrWuEOzgBO+Si3Z
Z9muoCcmrkqBzzhBT6GI3OewgoI4LcXqH3HC5ahNzdxX8Hi8Ipas73BCQZT5
G8HrK+i1KbPd0YIT7twgfSP7rCD+pPSAFyaccPe99tEkvxX0VdXfYfgAJxx1
SZshBawgzewPIpZqnKCy3e5+UfAKMtzVNRQjxwl13+wCR0JWULhXi1TtOk7Q
rh+M5L27gkxsf//exsMJCYfy2dkfrKDdpRlXbJcJIKyTaNkesYKIG78HxUwQ
wKbwUHNq5Ao6feOTw2QbAV6vRyIjMStoM/nwgfU/CLAzdlOzY9wKesl4V6tf
ToC8KOZ/7fErKLa8cj4+jwBXNloX3UhaQRbrt7z8mEGAPbvMutIeraAkmFHt
TyCAUFfa+uLkFcQVxBfK/4AAScaCN4ofryB93YMfFYMIkPvd7m96ygqiNUR3
GHsQgDv19mW31BUkebd+2NmJAI7/a7nMw6na+jh+zj4pQskQEtVNSsp0qQz1
W6ZQ3XANUU6XopwMRYQoSaUokagbLo6ho0kSSVTiqgwV9QohxaXpFs5sn33O
u3qfd/+zn8+znr3X+n1/45KzVlzLpkCltX8iM4iBijd4Nr3HzOnNEVX6MRAr
oyQjqgTbrzMy+8VWBjqxRhL1A3P4WInpVwcGaogzjvAppWBW1v2oWVYM1JWr
eOwq5hkH5fp/MWagU91BnI+Y54+G7F+/lIFKwhXHZ5VR8M3mb5ttWgw0XvHK
RhPz2m7S+YAyA2k+P1mugvmm9N/80wQDkUoSAx7+Xqh1xKFISKCt92Y0NmF+
EZfmeO8bgQYVIkPiMQ/FCDmdHwgUtFHVUAdz396y+JEeAt28dV9ajs8bWR7z
SNROoNgT6z4vxOx7xjVFuYlAZxQCPiViey1DiBdLaglUlkSXtGJ9nl9J5lhe
J9C5Fd+Xkli/R3EcHdciAilsFP6h/ZP9fE39cwjUp/29cgnWOy0n6kdEGoGa
/ylRU8f+aEvpDUxOIlDa189pE9h/xomhmdnRBJoMy9K4l0cBq0fpRBmLQA3X
Q6v3XqHAYC5t6JkngTJCqOWplyiwiju5fZ4rgVYxd2pKcyi4u4j52G8DgdCC
Zu4fFylwrDnM+rKCQNUt41GjOP5orMRGcz0CHS1w05h1noKIMeeFCWoEuqKh
WKp+joJXz6t1lKR0dKO+4+TEaQrC+HM7vbh0NOf14d6Hp3B8HLp5reATHRUH
dsyPO0HBOF1fyfQ1HZnXVXhfT6KgXNXxd18OHTGMEt+qx1DwqeaHW0kBHY29
iT6ObzzQ19Le8P0CHVWyb2tu3k/B8qqzcqlH6KjnmB1tNc5XtVCf9Q9/p6NO
3d3PuDso8J8TkK/sQkdvjoURkTjfld6HX2Wup6OBWbXtfV4UGIVcei1bTkfB
CZm39+N6EVJjRPxG0ZD4uZpD3XqsT0AAsKdoaFjv5aECKwp2C/O2iMZp6HJa
7/FIS1zPNhl+Lu+moZ5C/2fjqyigdMs5czg05Jbdf1pLh4JlATFmSp405LzK
YnCMJwGFRnZfo6cMuLkXHs0vloDU1n5wxFYGAz0mY0Z5EihpKdZTNpCBnNUA
0zZHAtZmf51miaSA7h/w8ziD10PjbTYXSCGf+ma6PVIC8s2LVzWM47hd4z3g
byeBSnHEfp0uCt7nXGDsscH7eURxjtZTUB2qNRxlKYEZnBxDD+wnqy7F7j8N
JWA8YnNt+a8UzOzluxipSkD1W/jd0iQJtMeIqa5REnaxGmpdWBIw3xDG8n5P
gu/imj2TP/tOd8D30T4S7iezKXcDbEfVIHPlSxJyKT/XTZ0k2JWlHWfWk2Bt
MT6tfo8EP70DLPcaEuaZadeOFmFW5uV53iYhtTkkNjuahFXsfyRny0nIW1uy
12QhCUHka2Z/NglZ6Q6cpTNJeBk7z2Pnefw/85StuhPTEKU++4kgjYTuxkHx
4pZpSGfYrNl7nIRl9d+UQ8OmwVaZpumN+3Xo+ejGdB/c598fvpoeQcIHh1zj
O2gajiR2jvfvw+fNLE1R0ZgGnVD5rL93k6Bf1met/lAMT/dbWfb7kOB0K9Lt
bYUYXp0NvjPfi4QH8edrC3PEoO4y+FuYBwleuvXFKFwMc9QVLwZtIcGsN2ad
tp8YFn38riW/Cff/BRrOQkcxLHsef6DVmYQl1I7J5oViaPUf3pzjQMK+pDuF
d+TF0ND6uaLcjoTZbpu+lvNEsKuFn/EGSHAePDxYNCyCAAudkEUbsF55eUlF
HSJg8Q+wU21J0CMZ78rqRKA/pnxd2YYEZrii+HapCBz/kf9RZUXCrd0KI02Z
IjjUFfcueh0JSW7e7N5EEYSeiR70WUuCJnsj4oeIoP2r6i7fNSS0dVi0anqL
wOXtvp54SxJkKHY9shPB2ZXZVx9YYH0OBFdGrBbBlha2vR7mE+0+y0q0RWCa
clud/SsJCS1szqAcnvucXqc5Y97TUWSvNyWERV+XqM7FfMGLIwkaEsIpj2pN
sTn2zwuV4ao2IbRv+0t+Jl7fcd1MMOOeEPIGxB5rMN/y3+Wys0QI7IcDAWmY
Wz2n3zeeF0L2AJNN4P2FdI/WpYlC0NS4mFKIObu3cUZmiBCGNuZGBuLzz3S9
XEp4C+Gye0KfC7avrmVtZYKdEL6rbF/x035RA3c1uVoIWXtc289gfVRLlq5M
XiAEY9MAk1GsX/QnvZvKs4RwaEtNUzDW95TU9nERVwDzrvzxY856Ei77/CfM
elgA1cKYZcPYP8QuaOjvEADDcW5XHyLB1XcsxKRcAHFLDda7OJEwtKy7d+SC
AHgHu9424nj4LexflcIkAfSv3pHPxPEiXaEiM/QTwBXf4G267ti+5NanYicB
vDyltmKDJ/a39uyjr8wFYPgn2ZOG47PwaW7vBSUBCEbfpFQwSahqyjh/VMyH
lnfcHYmBOH8fRfpFjvHhgBmnNTGYBJd0n81hj/kwM3qVvDzOhzW2s05F3+TD
Fr2V97NxvvxaSxOnXOGDAVuramssCTPajW7WRfMBVS1d6ZVMQqaLEn0okA9D
4vCThXjeLfDKvjPbjQ/PcmcM6JzF8T445XnYkA/LXaJMKi6RMLXgdE71EA+M
Rl8yf6ki4cm79+Ivz3kQV6t2tKuOhAWfD30xquHB2UAnYdNjEkqjmaVt6Two
Hor0ZHWRwFl3LXVFLA+Gjn4LXtJPQuUbU6PMXTzYd9HLVHeEhN8Xj40lWvGA
++Db5o98vK6hqk0s44FJfn7HDRmuJxFRkKXCA/sMq6BGBQnc7mnL7xznwnZH
67XVehJwc78r9ziXCyuRlxyxRQK95kyn3ONcKBawepR9JUDLNPlwKIILU8LQ
xKAgCXQ4bQ7ctpELFbEW5bwjeD7fv+5HrmAK9KvfKFTdlcA80czEpo9TsFB+
k45+swTmq/I6BC+mQDJ87dFYlwRenNL/kXx1Cj7WGy9mTkggw6GuSMdvCoy3
2fbpmVGAVnrXFzhNAVdVUWeRPQUP7svRjMynoDy95eZBTwryduY77FWcAnd3
of7CWArXr3jNkIeTkBPhxz38BM9jGecox+uTEOGX4G3cQ0HP5muxqy9Pgp11
aqv1Fwq0Loh2LImaBMfD/haBalJ4pPPEPddgEjg20295LCnM+cy371KbhA+6
rE3Jx6Tgem65mRZ9ErRNms6EXpKCwdhRy7Z3EyCfsOrFjlYpfK146/o4awKq
aP/ObFghg4Oy16n+SRNwkc2Od7aXgcS+2VAufAKO3UCxlv4yuLYopjPBZQK+
XLSMssmSwWmpxWfXNRPQaKdU6HVDBjKfj/n6+hOgzG2r6X4qg7ftCXxF1QnQ
zTTbWjsiA9r/non/v2nov2nExuQ=
                   "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, 
                "PlotRange" -> {{0., 5.971130272239365}, {0.9811220369936459, 
                 6.843904013964675}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0.9811220369936459}, 
                "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
                "LabelStyle" -> {}, "AspectRatio" -> Automatic, 
                "DefaultStyle" -> {
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   RGBColor[0.24, 0.6, 0.8], 
                   Thickness[0.01]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> Identity, 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ParametricPlot, "GroupHighlight" -> 
                False|>|>]]& )[<|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{0., 5.971130272239365}, {0.9811220369936459, 
                6.843904013964675}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0.9811220369936459}, 
               "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
               "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8], 
                  Thickness[0.01]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
           ImageSizeCache -> {{
            4.503599627370496*^15, -4.503599627370496*^15}, {
            4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
          False]}, 
        Annotation[{{{{}, {}, 
            Annotation[{
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8], 
               Thickness[0.01]], 
              Line[CompressedData["
1:eJwU2Hc81d8bAHBce93hLqSsImWHSnUeKSmilIYIJaOBirLJSCgleyQjiSTy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               "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, 
            "PlotRange" -> {{0., 5.971130272239365}, {0.9811220369936459, 
             6.843904013964675}}, "Frame" -> {{False, False}, {False, False}},
             "AxesOrigin" -> {0, 0.9811220369936459}, 
            "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
            "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.24, 0.6, 0.8], 
               Thickness[0.01]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>, 
         "DynamicHighlight"]], {{
         RGBColor[0.368417, 0.506779, 0.709798], 
         Arrowheads[0.08], 
         ArrowBox[{{5.824925002498502, 5.952209624055743}, {5.775326411107623,
           6.043468907330329}}]}, 
        InsetBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
          14], {5.5, 5.5}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 
            Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], {
         PointSize[Medium], 
         PointBox[{3, 4}]}, 
        InsetBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"a\\\", \
TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 14], {3, 4}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], -0.25}], 
          ImageScaled[{0.5, -0.25}]]], {
         RGBColor[0.368417, 0.506779, 0.709798], 
         Thickness[0.01], 
         CircleBox[{3, 4}, 1, {-3.041592653589793, 3.041592653589793}]}, {
         RGBColor[0.368417, 0.506779, 0.709798], 
         Thickness[0.01], 
         LineBox[{{0.5, 4.1}, {2, 4.1}}]}, {
         RGBColor[0.368417, 0.506779, 0.709798], 
         Thickness[0.01], 
         LineBox[{{0.55, 3.9}, {2, 3.9}}]}, {
         RGBColor[0.368417, 0.506779, 0.709798], 
         Arrowheads[0.08], 
         ArrowBox[
          
          NCache[{{3 - 2^Rational[-1, 2], 4 + 2^Rational[-1, 2]}, {
            2.363603896932107, 4.7778174593052025`}}, {{2.2928932188134525`, 
           4.707106781186548}, {2.363603896932107, 4.7778174593052025`}}]]}, 
        InsetBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
          14], {2, 5}, 
         NCache[
          ImageScaled[{0.75, 
            Rational[1, 2]}], 
          ImageScaled[{0.75, 0.5}]]]}}, Axes -> {False, False}, 
      AxesLabel -> {None, None}, AxesOrigin -> {0.5362793865677238, 2.}, 
      DefaultBaseStyle -> {"PlotGraphics", "Graphics"}, DisplayFunction -> 
      Identity, FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 120, 
      Method -> {
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None}, PlotInteractivity :> True, 
      PlotRange -> {All, All}, PlotRangeClipping -> True, 
      PlotRangePadding -> {{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]}, "RowDefault"], 
   "\"Fig. 2. Two contours around \\!\\(\\*FormBox[\\\"a\\\", \
TraditionalForm]\\).\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "SolvedExampleOutput",
 CellID->1748890194,ExpressionUUID->"7e2b6cec-06a0-4278-9a52-1c6cc23838a2"]
}, {2}]],

Cell[TextData[{
 "Notice that the contribution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "\[Gamma]"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "a"}], ")"}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e86826df-2584-46f7-a5b4-f8f290499c3c"],
 " coming from the two horizontal lines cancels, because they are traversed \
in opposite directions. So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       SubscriptBox["C", "1"], "\[Union]", 
       SubscriptBox["C", "2"]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "a"}], ")"}], 
      RowBox[{"-", "1"}]]}], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"494194ea-2152-4388-a3e5-4c2f6c00e740"],
 " and therefore ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "1"]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "a"}], ")"}], 
       RowBox[{"-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{"(", 
       RowBox[{"-", 
        SubscriptBox["C", "2"]}], ")"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "a"}], ")"}], 
      RowBox[{"-", "1"}]]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f815c44b-7a16-4c3e-9b95-1a97a503e1e8"],
 ". In other words, it is possible to deform ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fcfe29fb-6162-4811-9747-8d89b25c3a66"],
 " into a circle centered at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6092eb07-d942-42a0-a00b-53755e019cf1"],
 ". In that case, you already know from ",
 ButtonBox["Example 11.2",
  BaseStyle->"Hyperlink",
  ButtonFunction:>
   NotebookLocate[{
    "ComplexAnalysis-11_Complex-Line-Integrals.nb", "Example112"}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]],
 " that the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"1fc8286e-e29d-4cf3-a3f9-c3d0e50144f7"],
 "."
}], "SolvedExampleNote",
 CellChangeTimes->{{3.968834509197134*^9, 3.968834509700926*^9}, 
   3.972998096139604*^9},
 CellID->325717811,ExpressionUUID->"ecc98f18-8a61-4ed3-ad72-20e060ebf750"],

Cell[TextData[{
 "3. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "517a1a1d-79a9-4734-9f52-aad71a7204a7"],
 ", the same reasoning as in case 2 can be used, but the integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b56a8ce1-cf29-43ed-8339-eb334802b66b"],
 " is zero, as seen in ",
 ButtonBox["Example 11.2",
  BaseStyle->"Hyperlink",
  ButtonFunction:>
   NotebookLocate[{
    "ComplexAnalysis-11_Complex-Line-Integrals.nb", "Example112"}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]],
 " from an explicit computation."
}], "SolvedExampleNote",
 CellChangeTimes->{{3.968834509197134*^9, 3.968834509700926*^9}, 
   3.973000155055394*^9},
 CellID->298437524,ExpressionUUID->"a9902cbc-3782-41be-ae35-a698b275efa4"],

Cell["", "SolvedExampleEndCap",
 CellID->625641604,ExpressionUUID->"05b08544-d11d-4b13-acc4-73a95bcb8a0c"],

Cell["\<\
Because the result in Example 12.2 is very important and occurs frequently, \
here it is repeated in a boxed formula:\
\>", "Text",
 CellID->354751848,ExpressionUUID->"536ecfda-559f-4986-bc80-51d43aeb42a4"],

Cell[BoxData[
 FormBox[
  FrameBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", "a"}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
    TagBox[GridBox[{
       {"\[Piecewise]", GridBox[{
          {"0", 
           RowBox[{
            RowBox[{"if", " ", "a", " ", "is", " ", "outside", " ", "C"}], 
            ","}]},
          {"0", 
           RowBox[{
            RowBox[{
             RowBox[{
             "if", " ", "a", " ", "is", " ", "inside", " ", "C", " ", "and", " ",
               "n"}], "!=", 
             RowBox[{"-", "1"}]}], ","}]},
          {"1", 
           RowBox[{
            RowBox[{
            "if", " ", "a", " ", "is", " ", "inside", " ", "C", " ", "and", " ",
              "n"}], "=", 
            RowBox[{"-", "1."}]}]}
         },
         AllowedDimensions->{2, Automatic},
         Editable->True,
         GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
         GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.84]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}},
         Selectable->True]}
      },
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.35]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}],
     "Piecewise",
     DeleteWithContents->True,
     Editable->False,
     SelectWithContents->True,
     Selectable->False,
     StripWrapperBoxes->True]}]], TraditionalForm]], "DisplayFormulaNumbered",\

 CellID->783543040,ExpressionUUID->"6f468507-4266-46ad-9609-b871af6f4285"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"f125729d-1d58-423d-abc8-933f14903bf1"],

Cell["\<\
The complex line integral is path independent if the integrand is the \
derivative of an analytic function.\
\>", "SummaryList",
 CellID->366108579,ExpressionUUID->"7bbf801e-da71-4a9c-8c42-7bc1e952bc4e"],

Cell["\<\
The integral\[CloseCurlyQuote]s path independence is equivalent to the \
integral over closed contours being zero.\
\>", "SummaryList",
 CellID->31286396,ExpressionUUID->"98ff453e-0df6-4aba-aac8-938a3c963e8d"],

Cell["\<\
The fundamental theorem for complex line integrals states that:\
\>", "SummaryList",
 CellID->767260243,ExpressionUUID->"c4496e07-2b9a-4137-9c36-726a8baea798"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"F", "'"}], 
     RowBox[{"(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "\[AlignmentMarker]", "=", 
   RowBox[{
    RowBox[{"F", "(", 
     RowBox[{"\[Rho]", "(", "s", ")"}], ")"}], "-", 
    RowBox[{"F", "(", 
     RowBox[{"\[Rho]", "(", "r", ")"}], ")"}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->173649464,ExpressionUUID->"b8f73282-d841-451d-9caf-63472d6ca04b"],

Cell[TextData[{
 "For closed contours ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "3202a833-cb43-4e8b-86a3-0370a08351f8"],
 ", the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "a"}], ")"}], "n"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3df880e4-9c9b-49d6-aea2-ef6371589b65"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9e8bae73-9ecf-4e9f-92f9-f087cbc2082a"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3eb5b96e-ada3-4810-9307-77c410625c27"],
 " and ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ca3ead88-5e4c-428e-a247-0eea37590f5e"],
 " is inside ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "eac728e8-41be-46e3-9be1-2c096af7bfd5"],
 " and is zero if ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5dcda578-1523-427d-9e36-d37461861725"],
 " is outside or if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "!=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8bca7b61-8d64-4140-b32b-1a714790bfb3"],
 "."
}], "SummaryList",
 CellID->121712212,ExpressionUUID->"e16a400a-48fe-442f-8c2e-73dfa0b3d2c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->7858937,ExpressionUUID->"e7e22eb3-4f91-407b-acab-0cae87323e88"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "+", 
       SuperscriptBox["z", "2"]}], ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1eab6285-55a9-45b3-82ad-fa0e46d0ea67"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d54d3ab5-1272-4114-b017-900f38bee02e"],
 " is the straight line between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "33358efd-a45d-440f-8020-216b448a1051"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"95e56030-d19f-4438-bfa1-10e7ac61de4b"],
 ", using the fundamental theorem for line integrals."
}], "Exercise",
 CellID->90133499,ExpressionUUID->"54dcf8ca-7508-408f-b027-4a5de54a54aa"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"1d86b934-ad91-48d6-9362-0866803bb075"],

Cell[TextData[{
 "The antiderivative of the integrand is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["z", "2"], "2"], "+", 
     FractionBox[
      SuperscriptBox["z", "3"], "3"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2ff1a9cc-0a67-4475-a516-f83329b845a7"],
 ":"
}], "SolutionAnswer",
 CellID->187131525,ExpressionUUID->"271fb396-5ab5-47f8-846c-08f65481f408"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", "z_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"z", "+", 
     RowBox[{"z", "^", "2"}]}], ",", "z"}], "]"}]}]], "ExerciseInput",
 CellID->387423139,ExpressionUUID->"af6c69f3-7d93-4887-9843-9c0bc6ff222f"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["z", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["z", "3"], "3"]}]], "ExerciseOutput",
 CellID->576202728,ExpressionUUID->"51f364f5-04a0-49d8-a05d-1a1ff80ab2a9"]
}, Open  ]],

Cell["So, the integral is:", "SolutionAnswer",
 CellID->575850748,ExpressionUUID->"88b16a27-8945-47f9-8000-8f3ac13fb720"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", "\[ImaginaryI]", "]"}], "-", 
  RowBox[{"F", "[", "0", "]"}]}]], "ExerciseInput",
 CellID->508313729,ExpressionUUID->"77be6b3d-e09e-4b22-8790-81f7277b78cc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "-", 
  FractionBox["\[ImaginaryI]", "3"]}]], "ExerciseOutput",
 CellID->838804812,ExpressionUUID->"7465c11a-9a88-4410-8a8b-350f793527f0"]
}, Open  ]],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->408431724,ExpressionUUID->"993f6e64-d138-4aac-b77b-6bfe2b1779bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{"z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->200129570,ExpressionUUID->"824e504a-f5ec-4b76-b4db-4d1f3a487090"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "-", 
  FractionBox["\[ImaginaryI]", "3"]}]], "ExerciseOutput",
 CellID->423508579,ExpressionUUID->"b3fdd5df-a2c8-4054-b838-e74a8d5d1a44"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", "2"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a6145a35-bb24-43ea-8793-283262289cb4"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "488f74d2-d7ab-4d76-8b73-18a7c99d2d93"],
 " is the contour pictured here, using the fundamental theorem for line \
integrals:"
}], "Exercise",
 CellID->232718658,ExpressionUUID->"7f5b27e5-fde4-41e1-b876-2bff080a4f7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "t", "]"}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "2.5"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", "Black"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "170"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]], "ExerciseInput",
 CellID->19139565,ExpressionUUID->"7001bd8a-70d0-45ad-88aa-c9d22d5240ce"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[CompressedData["
1:eJxd2XlUjd3bB/CjZGiSpEJISJ4UqUjom5BkKprQqGh4RIokaTAkoVSiKM1J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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJxd2XlUjd3bB/CjZGiSpEJISJ4UqUjom5BkKprQqGh4RIokaTAkoVSiKM1J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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-0.5, 2.5}, {-0.5, 2.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {170, 170}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{-0.5, 2.5}, {-0.5, 2.5}},
           "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {170, 170}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             Thickness[0.01], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxd2XlUjd3bB/CjZGiSpEJISJ4UqUjom5BkKprQqGh4RIokaTAkoVSiKM1J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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {{-0.5, 2.5}, {-0.5, 2.5}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {170, 170}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]]}, 
       "HighlightLabelingFunctions" -> <|
        "CoordinatesToolOptions" -> Identity, 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{
    Arrowheads[0.07], 
    ArrowBox[{{0.2, 2}, {0, 2}}]},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->170,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-0.5, 2.5}, {-0.5, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->49745357,ExpressionUUID->"efe552ca-5998-4147-9711-1dbe1e4d9b4b"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"94de4747-4e6e-421b-9d47-0aaae06c3428"],

Cell[TextData[{
 "The antiderivative of the integrand is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "t", ")"}], "=", 
    FractionBox[
     SuperscriptBox["z", "3"], "3"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d38d4e72-cd91-426c-b482-6c404717e27f"],
 ":"
}], "SolutionAnswer",
 CellID->36783165,ExpressionUUID->"fdf43274-3391-4caa-bcfc-a1b792c52575"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", "z_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", "z"}], "]"}]}]], "ExerciseInput",
 CellID->752469882,ExpressionUUID->"088612ab-bb1d-4ea3-8fac-061c5b1917f0"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["z", "3"], "3"]], "ExerciseOutput",
 CellID->94388535,ExpressionUUID->"5d449a56-902b-4337-971c-e6d7450c870d"]
}, Open  ]],

Cell["So the integral is:", "SolutionAnswer",
 CellID->413758707,ExpressionUUID->"45226d9d-eba7-47bf-9cd3-370ec9a08449"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", 
   RowBox[{"2", "\[ImaginaryI]"}], "]"}], "-", 
  RowBox[{"F", "[", "0", "]"}]}]], "ExerciseInput",
 CellID->153529400,ExpressionUUID->"b240b7cf-10f4-4497-97cd-6eb8cca298de"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]"}], "3"]}]], "ExerciseOutput",
 CellID->306558678,ExpressionUUID->"91694195-99f9-4d7a-8fc1-a60efe03e0ea"]
}, Open  ]],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->87074535,ExpressionUUID->"04734e59-9e75-463a-9498-47fd023f869b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   SuperscriptBox["z", "2"], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "Pi"}], "/", "2"}], ",", 
        RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->673767498,ExpressionUUID->"2e006de4-a320-455d-88c0-e71f15332fb0"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]"}], "3"]}]], "ExerciseOutput",
 CellID->648079561,ExpressionUUID->"455e77a4-eb85-41f6-89c5-3835a395cd31"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"log", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"236eaa1e-fcca-4a51-8b4b-ec888b5a2b69"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1655f6af-0b8d-415e-a073-802d810998aa"],
 " is the contour pictured here, using the fundamental theorem for line \
integrals:"
}], "Exercise",
 CellID->103266790,ExpressionUUID->"ea4c3064-c93a-4926-bd7c-6f570ef58834"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", "Black"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "170"}]}], "]"}]], "ExerciseInput",
 CellID->67821223,ExpressionUUID->"a77b0f5d-e40c-421a-a0fc-04d7c3d3b197"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7BlQwAf7pN9iJ9slW+xR+VPg/JNBwQwfPi6B
82t/GK91k1sP59/zdZ94uHsLnG9wetLz6V92wvkXNmS1MTLuh/OFEgsWnLc5
BOfLvTz5PuLNETg/cGnm4zW5x+H8uPIbT6RUT8H5k2p7u4LXnYHzNZgTFx3T
Og/n+55nfLLy3QU4X9L824mrBpfg/Eual7bw9V2G821i9t588uQKnL9rxemA
BSrX4HyVhoPnMuqvw/mLCm/NEzt8A87nfXer9KLiLThfc9WrVs2q23B+ZIPs
i7Tdd+D80ofmgRvF78H5S2NKeR7G3IfzD3MnMlz3fQDnr9L7/ffwLwR/9r1l
S5TnPITzmUKOneP0fgTnO2XmTt33DcHv4VZjfTbtMZzvUxz0Y7LLEzhfLGPC
lC3PEPwdf0LPLm59CudfDOvvlDR6Bud/tr31jvEygt/zasb1gsbncL6+SmZm
kMoLhPv/HpjOdATBnzOnx9Oy8CWcP/1E5pJHQq/gfM5du5qEDiH4Id6T/wrk
vYbzV2TWKjbxvYHzi31vn6jcg+C77/OSfBL3Fs7/cs6RTfYfgi++dE3ZnVXv
4HwXDs0JfD7v4XylFhEP9mUIPowGAAwPDhQ=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7BlQwAf7pN9iJ9slW+xR+VPg/JNBwQwfPi6B
82t/GK91k1sP59/zdZ94uHsLnG9wetLz6V92wvkXNmS1MTLuh/OFEgsWnLc5
BOfLvTz5PuLNETg/cGnm4zW5x+H8uPIbT6RUT8H5k2p7u4LXnYHzNZgTFx3T
Og/n+55nfLLy3QU4X9L824mrBpfg/Eual7bw9V2G821i9t588uQKnL9rxemA
BSrX4HyVhoPnMuqvw/mLCm/NEzt8A87nfXer9KLiLThfc9WrVs2q23B+ZIPs
i7Tdd+D80ofmgRvF78H5S2NKeR7G3IfzD3MnMlz3fQDnr9L7/ffwLwR/9r1l
S5TnPITzmUKOneP0fgTnO2XmTt33DcHv4VZjfTbtMZzvUxz0Y7LLEzhfLGPC
lC3PEPwdf0LPLm59CudfDOvvlDR6Bud/tr31jvEygt/zasb1gsbncL6+SmZm
kMoLhPv/HpjOdATBnzOnx9Oy8CWcP/1E5pJHQq/gfM5du5qEDiH4Id6T/wrk
vYbzV2TWKjbxvYHzi31vn6jcg+C77/OSfBL3Fs7/cs6RTfYfgi++dE3ZnVXv
4HwXDs0JfD7v4XylFhEP9mUIPowGAAwPDhQ=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 1.5}, {-0.5, 1.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {170, 170}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 1.5}, {-0.5, 1.5}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {170, 170}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             Thickness[0.01], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7BlQwAf7pN9iJ9slW+xR+VPg/JNBwQwfPi6B
82t/GK91k1sP59/zdZ94uHsLnG9wetLz6V92wvkXNmS1MTLuh/OFEgsWnLc5
BOfLvTz5PuLNETg/cGnm4zW5x+H8uPIbT6RUT8H5k2p7u4LXnYHzNZgTFx3T
Og/n+55nfLLy3QU4X9L824mrBpfg/Eual7bw9V2G821i9t588uQKnL9rxemA
BSrX4HyVhoPnMuqvw/mLCm/NEzt8A87nfXer9KLiLThfc9WrVs2q23B+ZIPs
i7Tdd+D80ofmgRvF78H5S2NKeR7G3IfzD3MnMlz3fQDnr9L7/ffwLwR/9r1l
S5TnPITzmUKOneP0fgTnO2XmTt33DcHv4VZjfTbtMZzvUxz0Y7LLEzhfLGPC
lC3PEPwdf0LPLm59CudfDOvvlDR6Bud/tr31jvEygt/zasb1gsbncL6+SmZm
kMoLhPv/HpjOdATBnzOnx9Oy8CWcP/1E5pJHQq/gfM5du5qEDiH4Id6T/wrk
vYbzV2TWKjbxvYHzi31vn6jcg+C77/OSfBL3Fs7/cs6RTfYfgi++dE3ZnVXv
4HwXDs0JfD7v4XylFhEP9mUIPowGAAwPDhQ=
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 1.5}, {-0.5, 1.5}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {170, 170}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]]}, 
       "HighlightLabelingFunctions" -> <|
        "CoordinatesToolOptions" -> Identity, 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{
    Arrowheads[0.07], 
    ArrowBox[
     LineBox[{{1, 1}, {0, 1}}]]},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->170,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-1, 1.5}, {-0.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->220558848,ExpressionUUID->"e07fc293-38ef-474e-9b69-e88a3f13d296"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"36569ec2-b26f-4d5f-978e-a14a1ad92fd6"],

Cell[TextData[{
 "The fundamental theorem for line integrals can be used because ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "fa753c39-ac99-436a-8d93-24facf0073df"],
 " is not a closed curve around the origin. The antiderivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b8c984c8-30f3-4c1f-a3e4-9d05138ca344"],
 " is:"
}], "SolutionAnswer",
 CellID->15391170,ExpressionUUID->"58599101-5e69-43bd-96c6-d86003dc8d97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", "z_", "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Log", "[", "z", "]"}], ",", "z"}], "]"}]}]], "ExerciseInput",
 CellID->349654309,ExpressionUUID->"a97cac32-094d-4edc-8030-6d8e902f8e5f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "z"}], "+", 
  RowBox[{"z", " ", 
   RowBox[{"Log", "[", "z", "]"}]}]}]], "ExerciseOutput",
 CellID->36464723,ExpressionUUID->"98628901-2c45-4b16-8f5c-df0b7a619740"]
}, Open  ]],

Cell["So the integral is:", "SolutionAnswer",
 CellID->464097779,ExpressionUUID->"564cf5fa-f1bb-4edf-9b34-365e4b76883f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", "\[ImaginaryI]", "]"}], "-", 
  RowBox[{"F", "[", "1", "]"}]}]], "ExerciseInput",
 CellID->415921525,ExpressionUUID->"b7430d3d-990f-4780-af9b-fbfd564a3b81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "-", 
  FractionBox["\[Pi]", "2"]}]], "ExerciseOutput",
 CellID->300628951,ExpressionUUID->"6b6d048b-1086-43c0-af6d-cfc9d891cad4"]
}, Open  ]],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->535448003,ExpressionUUID->"7025c208-958d-43d2-817c-4a461a77c5a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", "z", "]"}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->167710769,ExpressionUUID->"66567672-f08c-434e-b13c-510ee1ba53ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "-", 
  FractionBox["\[Pi]", "2"]}]], "ExerciseOutput",
 CellID->247436032,ExpressionUUID->"22d31cc1-89d5-475f-aff5-08ed7a9372d2"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Are contour integrals of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"682684f8-1898-45ec-94c4-91b8f4cefa74"],
 " path independent?"
}], "Exercise",
 CellID->192778493,ExpressionUUID->"c15ee5f3-5c8a-40fd-8f70-862379190d79"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"a2581860-fc6e-4a21-abb2-86b25ed3a76e"],

Cell[TextData[{
 "Yes, because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"db638ead-500e-46e4-a7be-f4e090b3dd8c"],
 " is the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    RowBox[{"cos", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"80775f18-7e72-4a22-85b6-ebf7480a5e73"],
 ", which is analytic everywhere."
}], "SolutionAnswer",
 CellID->183076685,ExpressionUUID->"7ddd7ab2-72d2-4882-9870-d95d70e5821c"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"exp", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1a9afe2c-c30c-447d-872b-b6b11ab90562"],
 ", where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bc89e10e-4912-4492-82bd-212fb51cc46e"],
 " is the contour pictured here:"
}], "Exercise",
 CellID->46333560,ExpressionUUID->"85f1d49a-6f33-4904-ad4b-1cca6108c910"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"5", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "5.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", "Black"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3.9", ",", "0.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "ExerciseInput",
 CellID->334041819,ExpressionUUID->"9a24e407-7bac-42c2-a320-aa0bdb33e477"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[CompressedData["
1:eJxde3k81N/3v7GMZURKtlTaJBVtaHVukiSJqBQlKktKsheKEpHslS2JrKVS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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJxde3k81N/3v7GMZURKtlTaJBVtaHVukiSJqBQlKktKsheKEpHslS2JrKVS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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 5.5}, {-1.5, 1.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 5.5}, {-1.5, 1.5}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {200, 200}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             Thickness[0.01], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxde3k81N/3v7GMZURKtlTaJBVtaHVukiSJqBQlKktKsheKEpHslS2JrKVS
IpRLZMmSfd93Y2Ze9n35vd6P7+ev3/hjHs/H6957zvOcc88yj5eNJnfP3WRn
Y2Pz42Bj++/7//+YzIuUeInrQXAav3nHhvvwf/gGXKXvsMrd4P0/bAflfS+8
VDeE/Q97AFuP2bzeuqT/4RAIC+z5/HpN5v/weyiayvn3Zar4fzgNkMyny7PO
jUA7NLk91ToNYqNXRD/qbIQ0pxqf5qI00PooUP5LtQm4pvw1dzl8hxyDHL0r
/M2QOMJTWV2dDrX7Hbx5Q1uA1TdXv843E0aW33RLRrfDg8r23m9LOYADuk/8
VeiGTYK/TrSdx9CoJHfV2aQbSs9ExFNTMNRey5Wb9usGv74daR935cImlDSp
OdANnSaD9sstuYCO+G27/rIHnlwxnn1/4Des9WW9KuvvhZJzumwjowXwTueC
k4bBAFyroxq8k/gD80cWOcdcB2DqYtb3c8f/wLK8guLV6AHYcmWj5feQP8Ax
xb3jSe8AuJkRdQ+UCuHWkALblMUgKLo8/8DlWgRXDCWvK1oMQfmSMjUjrgii
7ZLz2Z4NwQ33sWvmFUXANE175xM/BIGel0RKNxRD6fLBmJbuIWAEbHMP+F0M
m+Pnb9/Sp0NsXP6FtTx/IUbuOv+84jAcknFMLdv9F/6u+O0RrjMMlcmy/A8v
/YWjcTemJiyHYelzYF5n8l8QXVua3fR2GC5nGe2MP1MKZd0DqQacDFj5b56y
J7gMbO8MJfLlMiBB57Nhd3YZRF30Yz9SzwDlWpOM4N4yGKY/frSFwQDLppLb
Uwrl8K4+gSohyoTCntcN2Y3lMPrIxSLQggmuM/tS1Nb/A8G7aj0ebCzgu877
eYfaP3gVcurHDyEWvCpv/7LS6h+MqPF5xW5iwZcY77TmX/9ge9UGqzfHWWAT
T1zJkKuE1SdWrVz/mAU/DJrbk1QqQTbhnQFXIAuWV/4xirxQCZ+iiyxj3rLA
1znc2P1hJVhEvtJczGZBvPaJm6crKkFKaqXB3lEWMLh29x/troSaUiWhgkUW
7MuWMNs9VQkmT9qf8PERkLt1xHzN+irY0rxR5vtGAqgtzUPce6tg+a+qlPgu
As4E/Lk1d6IKIqfGjfccIKB5Lvx2x50qCDQcvPDwDAFSX54yq9yrQKPBpv7r
RQLMblpbFbysgm3PhQ9EGBMw8e+EddKvKmirF1XxsiNAIG7E1nZFNQSdWVoo
eUWA3uWWiZsbq0FGSUQ4IoqACMFCe32FanCtETLeEE+AzIMIx6NXqkG/3ELv
WBoBVvKeM/L3quFopW1jexYB33ut7296Wg2Tm3+dkc8jQOWsmjN3SjU4ONj8
Gywj4BnnnoXZ3Go4L3sT61QT8C9zrSujthqutb83u9NAgMhd6lL7YDXcai/J
PtxKgOGW0YdVC9WwfEzmy89OAmKaWpbzV9ZADk/lwZFeAob8Ct3St9RA3/4X
WvWDBOxWTaUkHagByd6BXisGAQ6zEY8jNGvAynTLRCZBwM9Pnhx+12rAQ/e4
XcYYARw37nm42dWAUBTlqtkkARrihly2z2rgXlxjcsk0AQEVap43I8n1J5b0
2mcJqH+yh1v/Cym/98bFuHkC1h2UfKZRQJ7vlp2yfpGAGywq79HGGtifcUdP
Y4mA5NhRb3lGDWRXxarLLBMwot/Kt4mtFkJLVJ79ILGSQNFzYeFauK3FEJon
8cP8VH5umVpQLFnqJUhc4BT5YvZwLTReeUl5TWI+OS8BxtlaaKV7mY+Q5+v0
3PNvv14L17gt1y6Q8kNDDVdWOdaC2rK/ZNYCAe1nTgbmP6+FF+Wcd2VJfWuc
o7tN39VCwDsNwY0kn+Kk2X18GbXQ36Gk83OKgJyGc09Tymoh4nns4YVxAr5x
fazX7q4FZopFfecIAYn7uGQmpmuhHixlbzEJiDK+ev/1ijpIWel3LHSIgGD/
jL+HNtdBa9JPacs+0t+/Vkq2H6iDr/L9fd2k/1yHLe64a9WBKiw9X24hwEY8
P2fLjTqwLFmQzqsn4Iq9vbGlfx3o5r1z2ldKwLnYiq8CcXXQfFRTu7eAAPWq
bZxfs+pAZqL36qEcAvbuao6f6auDG+dWWtV/JmCbwb6ZiPk6WLD+/VoykQBJ
b99TIFQPe4690+CJJoC7T5nx9Eg9HFU5llTpR8DCqtCj28/Vg/usgmfKUwLG
0KhfmVk9xHT/0trtQkBrZOye1cH1cGV0WVDGnIDqvwuP0xPrIaFn5tibKwQU
zZyvvZRTDxGLlOof5wj4qsfjGD1UDxbrCr17DhPgxX/n5y7UALNKbkv/3W+X
Q4Urqs43wJ6v13LTF8j8Yr7ByM6yAYrnDk7yEiwwLKiiZL9qgOcjm88nVLNg
r4viSXVmA+zbK27z+yULtiX7hw6zN4I4z5pTn56yQLJxcMhPrBEuZu8ZULFn
Aff+CN+6443wsc1ewUyXBa3Dy1Um4Y0QFcB//x2NBVXilzZTvzTCNda6rsYZ
Ml+e/GqX9KcRgj8UxGT1MSE19oboyEgjNFVrCTzMYYKnQYmh68km0OPj+Ml3
mwm7S4MGXk80wXx2iJJ1BgMKZQX8SniaodH64yTXOwZc8fHePy/ZDLqpC/f0
fBjgc8rN/eqJZviS2O8laciA3qI7a7e+agYx6XJ3o4VhCC1QP/tVqQXkB0JS
++SHQW5LwWTP6RaIezJ8evOaYfjzBCLXXGuBDVq1ruvm6DCmojjk9KwFOiL5
09Xz6aCZt/kJNLWAwA7dBfdzdGDLWUove9AKi/bS63JuDMGrdQ+uLPm1gtZL
R6n+E0Owy3WSY3dsK2zO0T/yT3oILh9haAeXtsIVDuZ438AgpGU10S9JtoHo
QYXlXWaDYJ6Rtn7gVxsc6k0wvnt5ACq/3PKkUDrgoG6qPb9IH6zx1lvsEekA
0de+VwoZvXDZWNmucGcHjGY9lzie3wt9QqtMnut3wMQC/5zn3V6Ys8k8uuZL
ByzQUO6JPz0QJOHxIES+E17qnNi6wrQbfrVW70ls74Q3b0u54tg6YJWxdfS/
I90wFf4LrbxdDeuHSgh9Uk5a6I2x7tO5WNA8FK5O9UJk88+rr1flYbYBU//r
bH3g/MF0ZGNTHu7q5ZC3Eu6Dj592DqXezMfvO49aPTnSB/5ddwSfuRTiHY2p
jBTfPkjbLFN4820ZPlAUNsS+qx+qs22yb16oxdvVzA/yKPWDGbfzGu3vtVji
j6L3imP9cO/0xg/cwnV4/neNjNj5fqB9mhpsrqzDOTkrzHe59sO5n9h85mQD
Vk13779Y3g+l/L+oJ3c0Y504i56PdwYgiM2kekVuBw6/djfCx2kATKf6tCUF
O3H3Wntd8ycDMPqx/w6Hcie2CXLL3xw2AI5aTz6oRnTioEevY8MLBqDzJ+2F
h24Xrr305/qztYPwRGTR0TOrG+sLbOy9XjIIIWx/DogY9eHoEunIY7WDoPow
3tDMqw8PeuzU29AxCPXrLtx78LkP359XKmieGIQ7zrlve5f6cPig1nsdqSFo
+9UU/jO8H7f8drkBjkOkn75nixcO4KuOjb0SW+nQbfO8Km5wCDuevlsE8nTI
Ee+dOkWl44AN1OQbB+kg5deU9XEzHecV7bv76Qwd+PXHpz9eoeMtYv6zxxzo
EOLiaxhQQcfDP04IWBTR4fDez7FxscOY80XryIsqOjz6ip+u+jWMJY1ta762
0CHrm8iPg/XDWIv3XegCQYf7Bz2E0rkZ+OulhU0BYsPQu82kyciMgZ3mvipl
WAyD2kd+EVVxJg6sOCXRajsMX1u3dR+UY+LkmM4FtofDsA1LGfWrMHGLhsBv
jaBheDgQG2liycTKERaa7VnDoDF7OK77BxNfvMsmz/FnGJyWfWyelTKx9fHX
QjL/hiEw5enNnjYmjhkuqL/XMwxzUYWcPygszHVEypiLnwHObMWnG06w8PqV
GcdlRRhQPB57Y+MFFlbsPSN9VooB5mpzahtMWdjc13k4dD8D9uttKlZ4ysJl
rfX2O68wwLoo37MEs3Dflzv6OmYMGAuL/JJSzsJLHpyHHe4x4P5QmKNqCwvL
79rLlvuUAblmiue9J1k4yPWFj+4nBqRVCOXfliZwYinjwokfDLjamq2dtIfA
WFxzs9JvBpiNMV6EHyEw4zvfTwmyr6xXYKaE6xCYnfPWM/5OBmzW57maZEBg
sXMlektDDBAeUNG/fZPAJ1hezK5FBgzqeJULOBHY8MhAZg03EyRsg9ey3Ahs
46Pm+UeICTtm8i+5exM4SpprQ9JWJlQZ3NfLDyNwmt2N4XB5JnCF/xq6947A
pb/zM3wPMmHr5Tip2kQCz1x9rG19hgnrxEp2fksnsEBKl6TJRSbsdPHqlP9F
4C3zaEjXmAlWj1hjRvkE1nm97K5kzwQ9zZSZpgoCm/dd1dr+iAm2AWcrN9cS
+OG+HIm13kyI+yD/T6qJwMn/XL4tRTLhuIXi6v3dBM5d1/poJJ4JFcW2Khr9
BG6wPKzZ/YUJ/p8k76ymE5iVGS5Wm8UE+e0rfPyZBObkmev9U8CEau2WgJwR
AktcuJSaUcEEJ4OG+9HjBN79/odrUiMTXD7TlBWmCKw2JqoR0U3qO3GkwWWG
wFeQo8gLBhNEN9HBcY7Adn713Q+nmFD0QtN2ywKBfVoVPluTfXrT5MU7HosE
jpZ96WzCx4KHz7NkXy8RON1p4qSeMAty5loTDZcJXFaoK6y2ngWZ1t19tSTu
Ef7WqSRD1snoxM5lEs+ZrErZvpcFawqKQttIvDL13v21R1jQGR0kYEVi6eXK
EyvUWHD7icjxVPL8I2d2r1o+y4II5bUHEkj55yL820cusWBJevPIWVI/iyFW
cvd1FpnPLK0+kPq7KWk51t5hAc9+enomye/V05TjhY4smNY4V/GA5P+xhn/l
D3cWFFwVzGKR9vm98XZr0nNSXsVJtzWjBG68W5oYQdb13sOt2wjSvsQvWfsX
5Bzx0NnshzNpfyq/z7FHSSx47q58KJv0j+TloRX3vrHguJZ1egrpv72J6s0m
v1jQ3vBHUbedwOpTCfF6RSyYG8v784H0t32QKRxoIfsE1qWjDv8I7Nv5hybb
xwKZ7gjlwRICx8htbVxL9h3H9CofrSggcMXfHutldgImhfTm72UQuFfs+NFR
fgL4G1brpX4h8LxpDG+PCAHv8+O3v08isAyHcUyhLAHZ68QC3oeT/F9M1wco
ENDg31BDCSLjRcyPZoAIEBsXMuQi70PHzmw74jzZl9VKvVu2J7Bmhk5S5jVy
zgiihkxZEjjr2GDbE0sCeGS9lUKMyfMurDkp5k7A35573AWnyfO6Pjh3PyfA
bb7h3gVE3jdLlS8fybklTrqZJ2A/gc+43RU/9pHsUzX8js+uJdcnlwxbkHOF
16vC6oR+FrbZf02KjHv48mvfY8dGFu7MmdJbIucEBVenp0QJC7cPCRmdoozA
Un36rqYPLJy5pFzcJjICVcOvC19bsrC1TFg4VWUEfIarzg43M3HCnd40y5Mk
Puj3/XwRE7d/lf9XqTkCKhvsHS2/MbHm0UKOiIsjsJiwbjzMh4m3nRu/LX9n
BHYoflbgVSDXO58B/dAR4JX+rm32gIHX5IVe+vVmBMRPVvC+N2ZgTWqv7abY
EdhakyMaoM7AWQEPEhkpI/DbXEbbcQ0Dv4pLEHLPHwGF5HlFnw/D+Mw/Sm8S
awSq9RbaOEvomBH9Mvjr+Ag4i20v10+hY1+b7cezZ0ZANVvqx61AOv67Riem
jH0U3sz4vCrRp2M1w+hrhMgo+LHb73TuHcJoSLltP4wCZcvZx0xiEO/jcKnH
/qOgNhDfvrOpH1fXCnoWh4wC/zPK+urv/dgmPlahKmwUxrkOyEJQP/5yqjSk
O3YUPn3v5bXR6Mc7AyR0uX6MQrXoUqLqjz4svS7zn0bnKJwKqlZgevdicaWp
4rrdYyBckefSy92Ne+PjPmoojoHzCeU16c1d+JPI+QB8eAzEN37J103pwqpT
3y4mqY2B15sum0mdLmz9/V6/i+EY8Pk0pHSGduLifUyOLc9IrIf5ww+3Y4fd
vco2HWNAy9BXCRVsxNXbq9ME/Mbhuefrh0dG/+Ajhr+aensnYGCt3i/Bff/A
6mVYUc/QBIw6i8dkTPyD6Ar7792sCdjCGKniMagEzmNygZ0zE1BqIaFDX1sF
ZVvfqrfyT8K/4h+vUyOqwZBwy6jZPwmTpUMHnwbVgfNj1Ze/PSaBowCLzl5o
gY/ZUk/yvCdBvJm3Vy61BdonFqxz/SZhIT53z0ZaK6iYfdfMCZ2Eg157+pRy
WoFPU5oz6+MkOLftaVmzsR3C1/DYptZOgnbXhzbL252QlViqHb1lClzyq4oM
uHpAzC3fhiY7BaarfU/V7O4B+4vZIQ7yUxDtfP7PasMe2E390Kh5aArgfVI2
M7UHEq77XJs9OwW+l9wPzVzuhZD1p6zPOU9B/1aNi0vv+mBsEgX9cpsCywvu
OWUlfaBdfiBNxnMKqqXkUgxH+4DmIjOzFDAF3a+6DTD0w+MmbrcP8VPwN+ZU
/pOmfrgbUujPWT0FzdJfIYltEMosc1LvNkxB0qHWp4ZbBkH2eHpNc+sUJENd
8N+Tg9A/GieaOjAFZv1x9+peDILh2advryxOgV9L4akIkSHQ4FP9nC4zDTv6
rb4GSdAhsetw1Ua5aeDqmAsuIPswrsx94777pmGifur4B3062SdsVrquPA09
c6kpL1/SQekPOxbUm4bnm8d31tGGYYtbXoX5o2lQ2OlW+31oGOg9FE9Hj2my
fvjt1WJnwJeTKkc9vafhx2/F8GgJBhwRzP8QGzwNaW+Wg200GKAXVfCsPWEa
bkYmZRTEM8DjZ5GKXuU07Jc/fmBEhwkaUjxzJnXTYHn+wEEBUyas9FBPvdc8
DZ5j20u77zMh8nTJBv/eaahTD239FM2EtOa/CyUz06DWIuBUTmdCz0x5Omyc
gVNhUdRFaxYkGgpYaUnPgKjgsJ2VGwuscrW2XtkxA/bq7V+D/ck64PUv+IHC
DPg83sI9+5EFq0SrrL+fmoF5D7rkjl4WND4QkinQmoGouEkBpVEWRLXrdFTr
zgDqI9InF1kgG199ZuQKiT0lk33IvK+iUCu7w2YGdoq+rRJUJfN0mHD3QccZ
8L8jvemTFgEVC3ph6i4zMOQgDUv6BFwuqOM29ZwB6YxTTt9uEyAlI4Ltns/A
o097r4s5END//ILDk4AZ+KAn9UPuEQE2ug290eEz8KWSXe1uAAEHMkQjP7+d
Aa2sDt2wUAKWJPR1c97PwEBfoL0dOc/7dDfmtXyagTcqv+KPkvO/tpr4ffq3
GVgIORm4I50AkeRLu2d/zMCa4pITf38SEHOvOUokfwbstC6WipcQEGKr6BNY
PANmRh4x6B8BnvZB9vwVM2BVLyzPV0eAkyPrmlfNDDiECV5zaCbA4r6GJnvT
DBgavNj6tIPk5xyv5No+AyF/f1gr9hKg6cq+eaZnBhJ+VuzzGSRA+dFVAduh
GfC7sN7Ejawzu92zZpmsGSD28I6IjRCw6YlIn/nEDMg94qjRHSdg9VObyp7Z
Gbi8JYSyZ4oATq+K7KvLMzDTqGf7ZYaAqWeyCU2csxCjPCZVPUfAoI9nkB7f
LHhN7eB8tUBAs2+36z/BWfj5rVb0v9+DyvyULTTWzIK1RvVFzmUCfgWE6/2R
mIWR7HV5n0j8KWgKkNQs+EC+zn+/P0WHnNuRvXUWVNW7eegkDnr1SURxxyzY
eaX0PyCxRygfe+ruWTL/3WKkLBHgEG7K3KE4C1fe2ko+IeWZRf5ujD88C2hx
34O5eQL0o9YXbDw2C4s+O/iESX01oh98jlSbhXdDjKp/0wQciakPF9WchV9/
1jXumiRA7v1ezyCdWWDkO2yRGyPjJd7v3oqLsyB7Kx9XsggQSqQbPjOcBR5q
97c1wwSwJ6upc5jMQo5/Pm2xn4CJDzH7HprNwgofyxpPss43fr7MZ2czC7WZ
TgPujWQfkZo+yXKchXJDpDNeTfYt31Z1WbjOgsJk0E3ucgKiMv5mGD2bhV3y
JrWiuQQEZErHNr+YhZ0c//SEMwl4nP3Y73zwLCj9ji/9lkrATXzo5umoWRBx
2TvR8o6AC3mvtAtjZ0HqwZXaG2EEqOePHT6WNAvXujq5A8l43lmUvEopbRb2
JflV1bgSMFYhkbvp7yxkf5DhpuoR0Fvp8OHNv1n4clE96KM6AfXV1a/E6mZB
ucDlyvQRAjLrfe4IdM7CrLu38oMtZB/UPicxNzkLHz4kyR0k+zibzgtU+/lZ
2P7WK52riwXXu7+OEmxz8IjL6ZNjNQvU+m8V99FIDPrhmmksWMFqtq/aOAdK
Q9Za2Jbsc3eurd+7bQ462HR1+ck+l2VpoBiycw76MsetOc6xoGKoZeqC0hxE
sHH+GJFjQUBfq2Or5hzcfnBysqyXCcJt7fcHHOcAlAaVsxETOCU3NKu7zsHh
ZH/r37JMmLxsdCj58RxsCS3d5SjMhPrGjrnbL+ZgJJldnd7PgNDaTuexmDlw
+ScjvuTFgLVl3a6L5XNQNZ3JL5Y9DPy0ze1Xa+bIPFxzXzR6GBZOXVfObZwD
HuuDFcUew9Ba1LP0uGcOdmkFmaicGYao/N5HPLNzwBc73BnWTIdN2f3uq7fM
g2XINYVNA0OwPZn+dPuDedhnffIOx98BeGxv6yz3aB6cJytGdRMHoBktWO/z
mActr5hjtzwHwLdhheFRv3moPekSOHRsAAjOPXt1YubBo1ZM4Uh6P3w3cmx3
+jsPE7IDt11D+uDYGk6lYokFuORPF6Jv74FLbusGTbMXQOGzVn1sBFnvh/KE
GnMXwGzt6miNgy1gomt6+FThAuR3+6TE1DfDLenPfjuqFmBr+x9ey5XN4FKG
FEb6FyD92PZ9Lm6NEC124/H9VYuwb5WFQZRuHQx8SZb0tViEk7Liu8cjysG+
S0knVXQJIhNemY9ffglxhvb8XYbLMPz50sAf9wYc4K+GWo2X4WPKkW/n2huw
y29RuwbTZZD1pSTFHWrEejJZLeXWy+CW2hscPtaI2SeWkrM8yOcD/qsSjZrx
1efPToV8XAZW/L7lgF1tWCQrwvPkwjKYDomqG5zqwm4OilfesbGhymVPrz22
XXhKcMP0eg421MEyfNgW2YW7VUZkJXjYUOuBX0tpRBfOTAwKWrmKDcWLxOpf
DO7GZnYNxotb2ZBE7uTx1dU9OJ9mzNZwhg2B9EJuuWw/1rK7mOajzYak2TMO
JOj04+bWM+bKumwoOuQ03zGnfjyWcqgyTp8NZdBucqQV9GMpbeFou+tsaM2M
pvXzywPYJaQIVt1nQwOrM9Ni7w9insVf43+c2ZDZ4rNi7chBHHwzLeH+QzbE
nyiTkpEziJMV3wl2PWFDtqV7jVPZh3BT44OOz35syEFBYfiU1xBWXCf36Mx7
NnTZmL/z12M6/v10yz5KAsn/QEF+SzQdn2FJDKQlsaGEXQczUnLo+AbmPiv5
mQ3R5fke3J6l42DjrvXDmWxII6DjoqblMB6JC8l59o8NLSeb+p9FDOwi8Nzm
SDUbInQv2T27xMDcju7SI7VsyKf0nJu1DQOvV7fyu9jMhibbt4xpxjLwGfrJ
q9J9bMi38HWqPIWJk+XmF/Pn2NCoRefx6ylMfKvtpcupRTa0Ka1BYm0uE8v6
7p6vWGZD/VkHBL2rmThp6OZMEycFPSprCfOcYuLE95VjhAAFbbhjb8JxmIXN
dS3v2QtR0PKNZ6fNTrOwDDt1ZG41Bf1YtXrmkQELJxgdZnKJU1AE/42Figcs
HC8RP7B2MwUpna1w6/jOwqYlyPTdVgqqVzE625fPwtJOLb3SMhT0rXd7elQV
C8fVrezes4uC3u6sLdjBYOH3Ac6tJ5UoaGjv/OUP6wh8A0QMyg9S0OGfSZc1
thN4C+tL07kjFBT8MW8qgpwHY0/31185RkHM664hFzTIeZeqU2V7moLU7z94
LG1DYJPvw2dnz1CQ528fl4vOBN50w7PioTYFHTqifPKQB4Hf5WWXep+nIFcj
2rTwSwJfs76gIahPQR4ep77yvyGw1IbR4pDLFEQ/YEf//p7A0S7ShW+NKEjv
l5Kn5Ddy/Y481a0mFJTQxl/YlEmubzbIT75BQUWeJw+r5xL4rVJg7ncLCvpg
XO55oIzAV/t3wOHbFBR/wgayqgi8/mXhr1wrCnK7tnuMUU/gqLH5rFJbCpq3
F199s5Nc/+7VQR0HCqpdn2uR3Euu197zo96JgkxeOj6PHiRw+1KpoqEzBdke
s7A6ySDwmxTT712uFES59IT3LUFgQ0PKfjM3CsqactJLGCOwJC3yK+MxBb2W
+33y2iSBWzMV99g8paAgqcjWkmkCR5pXfZ72oiB7Xt4VvbPkftHbcq4+FJSh
U1nzaZ7cX0hNYX9BQXbhD3fKLpL77d7teOZPQQ+Kb66+sETu33wkeUUQBd1b
8ebp3mVyf3W9THAIBa0k2NwxiSXd7yWIvaYgS819nIskbpXnl44KI/kYRwgM
kziiPf795kgKEiq+Ge1NYmvDs0c7oiioKmdco5A8X615ui78HQXdHJqNiiPl
S+pHW114T0E25r/fblsg8FidOveqBArSeZOgozlH4GLd0bflSRRksE44a/UM
aZ+qsAPeHylIKuZxhyvJ3+asSpXqZ1L/KdcSH9I+6uV0C7avFBTQGe12iLTf
+tPB7D/TKOgnzyuBF8MEHi8+HOGYQUGX20QfPh4gz1fr3bcvi4IcbEeaJXpI
/xX4lrF+UpDZjdk9F9oJbKeicDMZU9C1xLWB+5sIfCq3bfHmbwoqu3OWO72G
wBPZcvJtRRT064jog5giAv892FAU+peCmsX7w1bkkfGT8eiaXjm5/sdhUcks
Amt8qwwsrSbjk+LvsvkDGW977st61VFQpN7BAMlYAk992piv0khBpUfy9TPD
yfhOtpnIbKOgJ9Emlu3PCOwgs/aFfScFpbz3GzJ9RGDN+Pyte3ooSCOj0CPY
nsAz74QvJg5S0K0uAc+mawTWCkvPfDVOQdrFZmKS+8j7J2p07twUBXkHcrUW
SxN4NoR7eMUsBeGT+7GEBEHeX33Jp0sUVEJTvf9pmYXnveYe2vKyo4zWaZ7w
Qhau5IoVlednRxJ57wXsMsh88eT0F7oAO4p4kuw0kcDC5x5FdhkLs6Nxtbfy
Q14snOigrKq9gR2te3DAIOE4Cz+c6G+lbWJH2gIvPmXuYWFdG3/7oi3sqDpN
n2G7gYWX7nTGK8uyoy+6fouds0x8/uZj3l0K7Ej5+bh3bDITs+sVVvCeZkc3
qbPSS/MMfHGk892PM+zot0egkFgfA3/0nbcz02ZH75xTf3WWM/CFP7vX/jnP
jqa2eV17FMUg60OEmds1drSVunPn7GEGPiduzTZtz472e54PkzQfxgnffWri
nNhRGd1q03HNYbygExev58yOhsuC6ZK7h3G8T7PmVzd2lCxpZT88Rcdz86ph
d56zo5jIQ+cW3eg4pl18b280O3Jz+JN/lKw30w/2cwXHsqON54S3YdMhrCl6
tvFYPDsSdPJfP3tiCE+d9Xj49gM7epljeTiUYwhr5LH+Xk5nRweCO+69cB7E
Y7H516tK2RE7Vdwl8eoAVrG48zJnih0tPUmh3ZnoxaWnd+6DWdIf0y+13Cp6
sZ7ccCWeZ0e2i7ofryX2YtNxc/48Ng50PbJyl49BL37ueuNJPh8HKni1KdwH
9+DaQIN7xes5kMPM5I6XD8l6nnXqTLUaB2pTcLq1KqMD+9KkufpfcaCNjoGd
U2drsabtuZlgVU7U//JauW9NJmywzH8geZITHWUTZX4wzYYxk/2L709xIvXS
PEPP2Z8Qek6EPV2LE4noR3+VE8yFvj3NtEZ9TtTINk9ftTcfHo4Yb5C8w4lW
fRJ10LcqgdQ799Tev+RE3erecxFN1eBxs7t4ZygnenPPcuDSoRrQv6J7+ns4
J7Lsk383EF4DS5oK2oVvOdGmpe/frAxqQWPn7KXBJE4kZ+wzt7K5Dnrpbnd2
5nCiM7uixmrLGkHEPCAkrZ8TxbTw9hPu7WD+0FZn9xAn4ugrdlvX1A7ZIRcE
Pg5zovhvDqVsuzvgWp7ks9gRTgR7hHf2tXZAskSSc9AcJ5IyOrXHK6wTlMvz
TKwFuNDsvogk0cEuMNs7vnunIhcykpudlrzRC1nq9cyEA1xI1fi80WmfXuA3
ykzefJgLtQV7nFb/0gtfnz/ashZxITmRItWP872w0EsT49PgQk/fHa1fFdAH
Aa+3LA9c4UK6XaF9/J/74cfC+fLYp1xIRlou2iR/EKS61d6ff8aFQpLze4z7
BsG7SMmZ+zkXEpsK8ZbgHoLLQeLbLQO4yHiXfJh+agjmt7V57I3gQjn4cqFf
6RAo6944kveFC0VKPtK9l0eH+APnV9t+40IBxJ/3Le10EFyvRt+SzoW0lLxy
Zufp0Dm4LfRZNhfSD56kaCsMg/vD4fGzhSS/kNBJg/fDUJBk86G9hQtJj0F5
ii0DdvpffxzQTurP5l4p78uAl3Z6l1S6uNDED8fma+8ZYAqK3PH9XOj2x/GR
ihoGcNfNmtwZ5ULujukdNXJMsM6iH9wwwYUsW8dKClWZ0Pi2ZWXVFBeajtf+
bHqZCYm3fuXsX+BCyw4cjh89mKDB5i6xQKWizKvij07VMeFr373RFF4qqj1R
nPtmkAlrS02KjfipCJ537HwzzwTGS1WHfCEq6udLSYmUYoHfDp5qH0kqEmWz
SQw1ZcHUytnEIxuoSFXX/QVyZIHR1NAj1kYq6kq9wRPkxYLdeaW7zm2jIr5r
Ttx7ElhQdcHfW3wvFS0NGF283M0Cq8dbdrzZT0WWPko1V8j5j+9TZpmUEil/
UzpDeIEFqly9gjJHqOj89X/Ob4QJSP924JWiGhW9KBooEVYh4FxHuVKWOhWl
nVBjpmoSQPBdbzp6moooFU1FlIsEyJi8kDyhTcqbeHo08xYB4Su7Y3QvU1HO
jzWBHn4EKB5xVG0wJPVFvP/SXhFQY8bff9mIirb72qx4HUUAP1bcbnKD1D/Q
W/leCgGJ9NK/faZUJLnkw2+RRsAJEePbFhZUVEckBa7KJuDhneefra2oyL5n
v9uDIgIkwqR0JqypaOfY0t8D5HyeUfB9zNGWilroMf6J5PyuN6IRMm9PRV5q
abklDQSMrO1UeORERYeePNOJbCXA96R9A7szFaHjSopSXQRst+W77+lKRYG3
wq+f7yOgMOqtBJ8bFeke0vp3eIgAk7/7f754TEWPbqXerWEQsDRZckXoKRVl
H+s7LDlCQMRGo+UQL5Lfh/IdIuMEHDgzES3mQ0UuGkIH8iYJqHXyVon0pSIR
P/HL62YIsH6/vneDP3k+XuUrO0fAispvT2MDqWhoJaN4cJ6A5Hn1bdtCqMj0
w0V+/UUC1La1Fye/oqKmjL/nnJYI6D5ne0sujIp8zF3DTi0T8OghD//XCCpq
Xb7VXkpiyeQ3KQpRVHSiTkdqmcQ/6vaezYymojv63672kFiPUjxyJJaKrq+q
DXMi8ejOK0G5cVQ0+T67Ooc8309/bJ9qIhVtLt5PSyfly3p41RUlU9GPE+Un
ri6Q9vks6Xg6hYrGx+qeZpD6X29JFfv3mYqMEk3+5ZH82LhPZp37SkVYSWOb
6xQBkXtbDerTqEj8mnTw0H/2uXpv8VIGFfViXXHuUQLqvKlv2zKpSOfPaG4d
kwCb7xHI+CcVpUd2B56nEyDQtbu7N4eKxNaVhnj2k/bhL3xinkfer6+rasy7
CTh5wGArI5+KLqn3XFhoI8DN/6n5eDEVlcwFGSjVErAuW4LPsZTU1zFwor2C
gKz+zx/myqmo/f5FjgMlBIwfbWZRaqiosacia+knQeYj1+TsOipSjuf0bvlO
gP4+KVP7RiryXG2qa/iJgJ8ypm2DbaS/y7L2a5DxbLWZNyymk4pGtmk/yHhJ
wMb1H/UMe6hIolhPvMSXAM/VY6X/BqloVtOorOk+yV/gpZf3MBUdyb0g2nSX
gGGeA8ePs6jIY/LtdtebBGgvuWalj5P5JOv2urSzZLwP8Sa9WaKilZrBZZ0b
CCjr+XjjIoUbxca51PGuJv3fflZKiJMbqX6jfmvkIqC35uVrD15udFNFytOc
zoKUnI2elsLc6JCq5YLeZxZcyyw4tlWUG3Wp7lmd+pYFq9LMFtvFudFnO80z
af4scEhKsTu3gRvN7hHu/2LFAhRy8PpBWW7kUiS04CXDgjG/1vXjO7mRVn6o
0yYRFsR5P2r+KM+NrPZGJtzkIPPNoz86UgrcaOB64HR/KxNqLHQQN/nXeTnR
v+U5k8y/FuvqzpPYwUg/r4kBYof4m/z0uVGVhOkb9t8MKN3/OUTdgNRnb+vd
kSQG7JadpP28xo2Glyzrqp0YMCvsPhdjyY0k96x4nLWKAb700AZrd5K/3sOb
F5WGwWZH55WFJ9zITlvs1l3JYbh0e1uvlyc3erAmrF6FMgzSrO8jUc+5UXXo
8pzkXzrkjlbzlr/kRmz8HVLx+nSYnOE/sj2ZG9VMWfucthiCq9zu0V3V3KjW
WJqP3WAAVNWLpe/UcaPvKuqjYgcGYIe3YMpMAzc6pS4rPik8ADN8UZmCbdyo
6fUN/6XyfggSyK4+OsCNlvpPjxsd7YfCNZOc4fPcKPjwzqspQn0gv8XC4twW
HqR4sur4muBuCHmySbZKmgcdbfux1vBWN8x1t9DPbudBnCL/ZB2OdUPhO63b
Z+R4kLPbX5etRBdc3bD/rvoBHhTjfXjYWb0L/CSW7ZQ1eVDfUxGV3/0dwFj5
0k3WjgfNyNRM1l5qhuTF3NfsBTyoZdfKsxNryyEy0vfUwXu8aM+9Pft6I4qx
ptAMC9vyIvMQzZrVJiV44en1EDUHXpRxoEKeU+YvNrx7qEPXmRfx1GlZbPhW
iiVVBu2snvIiTbMuIb7CChwxcDw6Nox8bhQp8tiqGofvnZ9a8ZsX/bX/o7PD
uBFrJJhGhhTwIqH6NmunnEY8t7b62NoiXjTjsbHXa20TvsyV5CtTxouW/Dlk
6LVNWLzxwqbj9bxoNCmbGaPagkNdv55xovOiPO/emnWi7fh1scX77lV86E/0
hdsr87qwIX/P9bdr+BA+Omz+mNWFN2kbbjYU40OK8+lDeG03/tSgFVO3jg/d
2zZkGmHfjQv790UXy/Ah95Qvc3+ke/AE51LEJ2U+tCwtNer0sBdnqTsaWB7j
Qx1G8a6mZH/r5jsiIaPKh4zv/g4Wre7FNOGesHen+NBgs6797y19eNPm4tch
enzInEeva1dRH9Y+FhT84BYfClyfrDex3I9FntJ0le7woSx33YburQO4tdhj
1cRdPvQ99lfYi9MD2EzbMfCOPR86H/V2q8irAfzQyND/mhsfCm4XdRnYNog/
uko/V3vFh4bCfRvklIcwb1bW41W/+ZD6w3njsL3DWEsy3uV3AR8q8yrpKNAa
xiEPAx1sivjQ0U1RurG3hvH64+a3qsv4kOFIRo/ju2G8t2zNuaAGPhR7e7OK
I42BDdutN65i8iE2Bd5vfpUM/A4Zrv1N8KHNXNVhhQMM3B9zco3NGB8auZg/
8XGJga3N1vNWT/MhLqFILo8dTPx0pHQkkJ2GpH3ls/XcmfgT+7ZcITEacr+f
m6a5joXHb6zKypOgIb0XR4PPyrPwgaLFb/fW0VAae9upRcTC+c9rE6o20dBF
4Ukn/ess3Cj82D9wFw1ZVd+L43nPwusc73gf201Dx78ZcF35xsImTfpPRvfS
UHJPW/Hl3yzMeCPvqHOAhvbb2VXrdLAwZVvbVaHjNOQcLOS7fQ2B1byL9fNO
0NBg5MGogo0E9h3+du6eOg0twuNWbjkCi3zxUas6Q0Nud/n1PE8Q2GCVA3LX
pqEcTerpPG0CR9sZH9qjS0M7pYKGYg0ILHvwgFygPg1Vmz2JNbIm8N2IzTLH
DGho39ItjwMPCJy2KLBp9AoNrbUbev3jCYHhd98anes0lNVszUh5SWCPLVWC
FFMa4hGsnNsURc7znj95U81piPegbb1yPIH1TgcvrrSioZ5NbBG3vhO4fHzT
7yBrGlL6U5PN8ZPkE/nVU9iWhj5Kz05o/SbwQWaVoJgTDbWMy9rOlxP460vj
2rAHNOQ56BdhWEPgncqjoWtdaej1xHjM3UYCr/dfuWnDYxqSUUtZ96GLwKFK
0f3RHjTUdefig5o+Agt1yn/Y5EVD3EmfnqUMEdjnGb773puG5E4rw8H/3v/Z
c3a/tC8NLczpvHQYIbBrU/tMgh8N2RVNPr45TuApd6tf2wNp6MnhKTbqFIGt
ZZfcPwST/r7byaM/Q+Ch6hdqu17R0Jw4+0uDOQKbOK+jfQ4ln0dYRK9cIHDr
5pR/uyNoqHJFv7TjIoHPlx0J+fqGhvhOc2/1XyJwhV2Z/v5oMj5m1oXqLxNY
fZ3huvQYGup4fvhhDYnz/gx3KcWRfLT31v/3/s8hK+f4zAQacrB8+fa/93/S
RGiWh5NJPk0/mm+TeBcOl//1kYbOW6c+SyHPjzeTnVD+TENabXof3pLypVZm
/chNpaFVUQdPHCf1C/txylUljYbq59MvhZL6rzJuOlaQTkO17H2MKJKfL68F
VS2ThsApkuMiyZ/r68zfomwaMq1wiM0l7fPw8jP/Uzmkf0UqqltI+02zi+mV
5tKQ2PjP0ETSvtYfEsTO5NNQ0uP1i9J0AtN1ldoq/tDQKW0/nov9BL6+UPhO
u5j07xHzggPdpL3eXzCt/ktDzabFh8raCHzhTL+sXjmpn/BzB6Em0j5RXGkX
q2koVc7iTmoFgX+rvXRqqiXtT184xl9C4MPElqMGDTR09EWPgHg+geWQauHV
Vhoy3FFfpp5O4ITBGp/OdjLeOi60WX4m7RF4/axJFw2FvVm99VgigVd3P268
2U9DIcrX3rGHkfx9Vr0ZGKShUCvDeVYAgan7Yowthkl79t9uePGMwDNP8ui3
R2jo4M4q8x4HArdvZVu0naMhRR4Do5GzBL5Y4Z83uUDGg5jTPlvyPlY6bPB0
XKahuAfTKkmHCJxfpCzozMmPDoX+fSi/hcCJFq4bHwvwo51Rka4J4yys1CXB
dkiIxPavu1P6WLhQ/0f76Gp+pJ2lLGHQwMJ9J8cjjMX50aUnIwnJmSy8SdpC
5NgWfsRx6jll8wMWTn1DnZyR5kfyFz0zb1iwMFrzvubLdn6kLNufrKXPwlc5
OwKk5PkRr9VqNkkFFo7o1qOxHeJHFqE00Rg6E8teHhvKOMKPShU3Ke5oYOKs
Kv/iu8CPJKQT91/NZ+LG3L9PO1T5EX9U8Pff4Uws/Bax4bP86LPswnHfE0zs
Z7Bz0vUmP3p7q+ut/nMGXldTUqNgzo9ctzmGRdow8EcNs6/MW/wo7kSYo98l
Bv57MObuFWt+pMf1lcNVmoG5xcToR5z50dGFedcXP4exWy1Hx3wAP5IbMObP
baJj2zMtxfd/8qNeQbvErOZBrEhbZ8OB+VEPO8UsNmsQzxVfXfsijx8d/1NG
nAkfxG6q3XeiC/nR38/i8UP6g9jv8NCqokp+1FV1MFW1ZgAnbp82FO7jR2e2
ZQTV/OzHbVyrRz+tWIF0Dt/e/edmLz6ZoyHee3UFQvQxGXv1duwTvrRwzXgF
8o0zuR830obLHL52tl1fgSReV5q+CG3D5+QlEhvMV6A942p3vAZasWH0kGKp
zQpUrng96vDjFmzz+JneV88VqKF9t4HJh0YcpVbo7/ZpBXI5LJqYXl2NJyqO
UdctrUBGDoEjnFFZWDTuo0NrsgDyw/8enF6ogfevVoFxigDaKa22dtCgFnY/
c+Lu/yyAnpS4qZ/LrgUNS9VQIk0AXTZbfv38fh247GnNZMcCKE0lVstpvB66
f9EWZWoE0KbbEdN3WpvgU/2tJ/bzAmjD6yu0Zy4dcLi48vTcogDK0lDhFa3t
gOJMReFHbILowdRi8Ic1ndAVyR73jEsQhTexvtne7gTh6+GFEYKCyIdNQ1lM
rAvuEyW8vzcLouZ4qYXzZt2gyrM9QEBTEC1Z5XnUd/fC5huD59u1BNGzYF1v
7RV9wJ6bsPaTjiAqfs7p663UB7mO0glnLgqipjnqE8XnfXBkYHOOr4kgmnzD
vs1Kvh/2Fa5n8N0XRG38QXf7bw3Aqk3tqc3OJD5RtygcOAAjrm8ckx8KIpbQ
mcK59AH4pCDJoeEhiEpux+ylUwZBNk5cwttfEGVVbuw9HTIImzyE1bnjBRH1
3KXFH8lDQOmsWdGQKIhU353QlC4bgs7DwTXxH0i+V+dGjzOHIGpcyEgtVRBt
cUtO8pOjg8R1QYenPwWRqcV8w4UUOgip8L3nqBFEJj9w85WIYRh5U2JRUyeI
Fh/olsVkDEPF7DP52EZBtNWLsi2oZhh8U7mzVdoF0R6OZGzFxwCejVzV7kOC
SPKokbaIHQMGXApe6zAEkfyXgvNxLxhQ2PjkykZCEF3ovSXf+t/7OQHsQ7kT
gugAu8R21MiA64y8TwHTgkhQ5O2X2yMMUFF3t7s2J4jq1hi1AA8TNr5Hh3Yv
CqJ9W4uNMjcw4f/+i3El6jxyZbJRkQn/D3TXSlI=
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 5.5}, {-1.5, 1.5}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {200, 200}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]]}, 
       "HighlightLabelingFunctions" -> <|
        "CoordinatesToolOptions" -> Identity, 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{
    Arrowheads[0.07], 
    ArrowBox[
     LineBox[{{3.9, 0.5}, {4, 1}}]]},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->200,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-1, 5.5}, {-1.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->10338972,ExpressionUUID->"2f0060d6-2dfc-45d9-a90e-23f2e67bd67b"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"9a78300e-06be-4ea4-94b9-d4e660464061"],

Cell[TextData[{
 "Because the integrand is the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a652938a-59aa-40f8-a4df-fc19cff82736"],
 ", which is analytic everywhere (and therefore in some region including the \
path), one can use the fundamental theorem. Therefore:"
}], "SolutionAnswer",
 CellID->218507297,ExpressionUUID->"6b116786-0b68-4610-8712-b17db50fef58"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"exp", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"exp", "(", 
       RowBox[{"4", "+", "\[ImaginaryI]"}], ")"}], "-", 
      RowBox[{"exp", "(", "0", ")"}]}], "=", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"4", "+", "\[ImaginaryI]"}]], "-", "1"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "7ed88aaa-7530-459e-adad-1777c07e11a2"],
 "."
}], "SolutionAnswer",
 CellID->158406688,ExpressionUUID->"68da2da0-b04a-4110-bfd2-d5457251751d"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->262319513,ExpressionUUID->"1b52b183-046f-498f-9b6c-b4095cc0e3fc"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"12. Fundamental Theorem for Complex Line Integrals | Essentials \
of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "11. Complex Line Integrals"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "13. Cauchy\[CloseCurlyQuote]s Theorem"}, "PrettyTooltipTemplate"], 
      "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"61ef163c-8905-4ad0-947c-f52cbbdedcbb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[675, 24, 253, 7, 108, "Section",ExpressionUUID->"3819e9ac-1a0a-4723-9f58-ebb579ae2e9a",
 CounterAssignments->{{"Section", 11}},
 CellID->592339613],
Cell[CellGroupData[{
Cell[953, 35, 118, 1, 56, "Subsection",ExpressionUUID->"7a615b2f-a518-4a81-975b-d362cdc2635f",
 CellID->379010489],
Cell[1074, 38, 196, 4, 36, "Text",ExpressionUUID->"5a1cecd6-8020-4823-b4c9-bbe88105b4d5",
 CellID->337483200],
Cell[1273, 44, 438, 12, 47, "DisplayFormula",ExpressionUUID->"6c26770a-cb46-4026-b986-16d0d26d4809",
 CellID->26550042],
Cell[1714, 58, 159, 3, 36, "Text",ExpressionUUID->"22a8971e-e959-4f03-aca9-9a84ff1b0049",
 CellID->38504125],
Cell[1876, 63, 168, 3, 36, "Text",ExpressionUUID->"077fb86f-ee44-41b7-9932-c5d3a693c0bd",
 CellID->38730901],
Cell[2047, 68, 593, 20, 45, "DisplayFormula",ExpressionUUID->"62c57a5c-aa2e-45bb-b24b-20faad3dc09f",
 CellID->90659139],
Cell[2643, 90, 251, 5, 60, "Text",ExpressionUUID->"6c0e0abc-a6d9-457f-a2bf-be891d532946",
 CellID->392610201],
Cell[2897, 97, 172, 3, 36, "Text",ExpressionUUID->"6d9f45af-1808-4202-b6f7-6359118d6ce1",
 CellID->219104598]
}, Open  ]],
Cell[CellGroupData[{
Cell[3106, 105, 135, 1, 56, "Subsection",ExpressionUUID->"3c0e916b-a43a-49de-916f-dcdbf4de5a1a",
 CellID->33104974],
Cell[3244, 108, 282, 5, 60, "Text",ExpressionUUID->"b03175c2-bb1e-4758-85fa-75545eeaf512",
 CellID->401938787],
Cell[3529, 115, 210, 4, 60, "Text",ExpressionUUID->"f75060d6-017c-45f3-99a9-88a4469d525a",
 CellID->42090823],
Cell[CellGroupData[{
Cell[3764, 123, 146, 1, 54, "Subsubsection",ExpressionUUID->"2e3fa0fa-ec26-4ee9-a999-97366f3bd851",
 CellID->355975948],
Cell[3913, 126, 242, 4, 60, "Text",ExpressionUUID->"dac13197-f92c-405d-8794-d7b8dabce77d",
 CellID->493879672],
Cell[4158, 132, 1378, 38, 85, "Text",ExpressionUUID->"0eb5130d-5e97-43a4-84a6-5fdd9aac1ebd",
 CellID->157630104],
Cell[5539, 172, 56920, 1018, 257, "Output",ExpressionUUID->"ddbef80e-cf2f-4eb0-9ef3-0d51ae86c71f",
 CellID->322622981],
Cell[62462, 1192, 118, 1, 36, "Text",ExpressionUUID->"722482e4-4604-4832-abf5-96183655b550",
 CellID->25582749],
Cell[62583, 1195, 1727, 55, 105, "DisplayFormulaNumbered",ExpressionUUID->"b91310e2-9b2a-4edc-9be2-0a8a4c712981",
 CellID->182179116],
Cell[64313, 1252, 224, 4, 60, "Text",ExpressionUUID->"19127ca4-2686-48b7-a6a5-4c096a613675",
 CellID->587641253],
Cell[64540, 1258, 145, 1, 36, "Text",ExpressionUUID->"54c2149b-47a6-4f11-8606-32051eb9b708",
 CellID->2537213],
Cell[64688, 1261, 381, 8, 60, "Text",ExpressionUUID->"79913545-a341-467a-bdcb-6406c9504a2c",
 CellID->260535210],
Cell[65072, 1271, 186, 8, 71, "SolvedExample",ExpressionUUID->"0246105c-c8f0-402f-8f06-81e93b9a1c15",
 CellID->54763527],
Cell[65261, 1281, 931, 27, 63, "SolvedExampleNote",ExpressionUUID->"531634c3-2c6d-4c69-8143-2ce695812204",
 CellID->127010386],
Cell[66195, 1310, 115, 1, 39, "SolvedExampleNote",ExpressionUUID->"8064f416-1515-45cf-a72f-5e155fa29d3a",
 CellID->134933130],
Cell[66313, 1313, 157, 2, 39, "SolvedExampleNote",ExpressionUUID->"18f88e33-428c-4eb2-991b-3c095ddd6680",
 CellID->759427217],
Cell[66473, 1317, 678, 19, 39, "SolvedExampleNote",ExpressionUUID->"370ce942-e214-471d-84b0-1d184846117f",
 CellID->142312647],
Cell[67154, 1338, 1297, 39, 42, "SolvedExampleNote",ExpressionUUID->"603d1468-6a7e-41c0-9ac5-58cfdfb06895",
 CellID->368313309],
Cell[68454, 1379, 711, 17, 84, "SolvedExampleNote",ExpressionUUID->"875261e1-c1d2-4faa-9582-2388f7a4c801",
 CellID->220523542],
Cell[69168, 1398, 656, 21, 42, "SolvedExampleNote",ExpressionUUID->"6e07ce85-2564-4b87-ab52-5c154d71b183",
 CellID->502280093],
Cell[69827, 1421, 188, 6, 39, "SolvedExampleNote",ExpressionUUID->"a62334a4-7b42-4da4-a076-8a041aceaa8b",
 CellID->69745742],
Cell[CellGroupData[{
Cell[70040, 1431, 475, 14, 27, "SolvedExampleInput",ExpressionUUID->"aa867e3b-aac0-484c-8158-8ba128190b98",
 CellID->834731088],
Cell[70518, 1447, 150, 2, 36, "SolvedExampleOutput",ExpressionUUID->"cfb6d3a5-7730-430c-8720-92b3fae289bc",
 CellID->415500299]
}, Open  ]],
Cell[70683, 1452, 138, 1, 39, "SolvedExampleNote",ExpressionUUID->"487c9ae7-30ac-4186-82a6-4bf71fe3fc97",
 CellID->214213369],
Cell[CellGroupData[{
Cell[70846, 1457, 1496, 39, 28, "SolvedExampleInput",ExpressionUUID->"1c29f8fe-2778-4c8f-aa18-0deec21e6107",
 CellID->33263346],
Cell[72345, 1498, 51515, 873, 203, "SolvedExampleOutput",ExpressionUUID->"20b38c03-8a67-4e19-99de-1756b04526a6",
 CellID->1974715204]
}, Open  ]],
Cell[123875, 2374, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"03abe1f6-9e91-4ca2-8dee-0d65054751d1",
 CellID->943814759]
}, Open  ]],
Cell[CellGroupData[{
Cell[124018, 2380, 112, 1, 54, "Subsubsection",ExpressionUUID->"ffa40174-355d-4d19-89c3-5a6b4016f836",
 CellID->491936],
Cell[124133, 2383, 509, 9, 83, "Text",ExpressionUUID->"3a60d8a6-b189-4c81-91f7-4522d79ef848",
 CellID->24394261],
Cell[124645, 2394, 349, 6, 83, "Text",ExpressionUUID->"834ba002-38ca-48ea-9c51-1ca70db0958c",
 CellID->177863685],
Cell[124997, 2402, 190, 4, 36, "Text",ExpressionUUID->"4e96cb80-1ebe-46cf-968f-4367e88750a3",
 CellID->531913813],
Cell[125190, 2408, 807, 24, 64, "Text",ExpressionUUID->"9e607678-5b07-483f-ac63-9a9d47345ee1",
 CellID->900656904],
Cell[126000, 2434, 1718, 48, 132, "Text",ExpressionUUID->"f2d1737f-a115-4b66-b4f4-2398645b1c85",
 CellID->785466622],
Cell[127721, 2484, 187, 8, 71, "SolvedExample",ExpressionUUID->"c3c01bc0-91fc-41cd-a83b-1b0d50f03b40",
 CellID->398609883],
Cell[127911, 2494, 1097, 31, 63, "SolvedExampleNote",ExpressionUUID->"fff2a065-3479-488b-a74b-abc1be4b2585",
 CellID->222137120],
Cell[129011, 2527, 150, 1, 39, "SolvedExampleNote",ExpressionUUID->"e451306b-927b-487b-867f-fd3c1d40f200",
 CellID->41249873],
Cell[129164, 2530, 1818, 57, 90, "SolvedExampleNote",ExpressionUUID->"28a3a92a-4431-4f2d-904e-9d8771f1f3e4",
 CellID->420630712],
Cell[130985, 2589, 2267, 66, 110, "SolvedExampleNote",ExpressionUUID->"1992ae9f-1031-4ca8-b86d-fe217ed5a724",
 CellID->698542096],
Cell[133255, 2657, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"f1451094-32ce-446d-bea4-fe84c0723f9a",
 CellID->1259313594],
Cell[CellGroupData[{
Cell[133387, 2662, 13794, 334, 70, "SolvedExampleInput",ExpressionUUID->"60b7314f-c061-48c9-a8ef-5914ea34338c",
 CellID->122001654],
Cell[147184, 2998, 209558, 3576, 168, "SolvedExampleOutput",ExpressionUUID->"7e2b6cec-06a0-4278-9a52-1c6cc23838a2",
 CellID->1748890194]
}, {2}]],
Cell[356754, 6577, 2544, 77, 119, "SolvedExampleNote",ExpressionUUID->"ecc98f18-8a61-4ed3-ad72-20e060ebf750",
 CellID->325717811],
Cell[359301, 6656, 884, 24, 61, "SolvedExampleNote",ExpressionUUID->"a9902cbc-3782-41be-ae35-a698b275efa4",
 CellID->298437524],
Cell[360188, 6682, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"05b08544-d11d-4b13-acc4-73a95bcb8a0c",
 CellID->625641604],
Cell[360297, 6685, 216, 4, 60, "Text",ExpressionUUID->"536ecfda-559f-4986-bc80-51d43aeb42a4",
 CellID->354751848],
Cell[360516, 6691, 2174, 63, 80, "DisplayFormulaNumbered",ExpressionUUID->"6f468507-4266-46ad-9609-b871af6f4285",
 CellID->783543040],
Cell[CellGroupData[{
Cell[362715, 6758, 109, 1, 69, "SummarySection",ExpressionUUID->"f125729d-1d58-423d-abc8-933f14903bf1",
 CellID->1198545324],
Cell[362827, 6761, 213, 4, 29, "SummaryList",ExpressionUUID->"7bbf801e-da71-4a9c-8c42-7bc1e952bc4e",
 CellID->366108579],
Cell[363043, 6767, 219, 4, 29, "SummaryList",ExpressionUUID->"98ff453e-0df6-4aba-aac8-938a3c963e8d",
 CellID->31286396],
Cell[363265, 6773, 169, 3, 29, "SummaryList",ExpressionUUID->"c4496e07-2b9a-4137-9c36-726a8baea798",
 CellID->767260243],
Cell[363437, 6778, 504, 15, 45, "DisplayFormula",ExpressionUUID->"b8f73282-d841-451d-9caf-63472d6ca04b",
 CellID->173649464],
Cell[363944, 6795, 1496, 45, 54, "SummaryList",ExpressionUUID->"e16a400a-48fe-442f-8c2e-73dfa0b3d2c5",
 CellID->121712212]
}, Open  ]],
Cell[CellGroupData[{
Cell[365477, 6845, 158, 3, 65, "ExerciseSection",ExpressionUUID->"e7e22eb3-4f91-407b-acab-0cae87323e88",
 CellID->7858937],
Cell[365638, 6850, 982, 28, 50, "Exercise",ExpressionUUID->"54dcf8ca-7508-408f-b027-4a5de54a54aa",
 CellID->90133499],
Cell[CellGroupData[{
Cell[366645, 6882, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"1d86b934-ad91-48d6-9362-0866803bb075"],
Cell[366739, 6884, 466, 14, 28, "SolutionAnswer",ExpressionUUID->"271fb396-5ab5-47f8-846c-08f65481f408",
 CellID->187131525],
Cell[CellGroupData[{
Cell[367230, 6902, 272, 7, 25, "ExerciseInput",ExpressionUUID->"af6c69f3-7d93-4887-9843-9c0bc6ff222f",
 CellID->387423139],
Cell[367505, 6911, 225, 6, 48, "ExerciseOutput",ExpressionUUID->"51f364f5-04a0-49d8-a05d-1a1ff80ab2a9",
 CellID->576202728]
}, Open  ]],
Cell[367745, 6920, 121, 1, 22, "SolutionAnswer",ExpressionUUID->"88b16a27-8945-47f9-8000-8f3ac13fb720",
 CellID->575850748],
Cell[CellGroupData[{
Cell[367891, 6925, 200, 4, 25, "ExerciseInput",ExpressionUUID->"77be6b3d-e09e-4b22-8790-81f7277b78cc",
 CellID->508313729],
Cell[368094, 6931, 206, 5, 45, "ExerciseOutput",ExpressionUUID->"7465c11a-9a88-4410-8a8b-350f793527f0",
 CellID->838804812]
}, Open  ]],
Cell[368315, 6939, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"993f6e64-d138-4aac-b77b-6bfe2b1779bc",
 CellID->408431724],
Cell[CellGroupData[{
Cell[368527, 6949, 461, 14, 27, "ExerciseInput",ExpressionUUID->"824e504a-f5ec-4b76-b4db-4d1f3a487090",
 CellID->200129570],
Cell[368991, 6965, 206, 5, 45, "ExerciseOutput",ExpressionUUID->"b3fdd5df-a2c8-4054-b838-e74a8d5d1a44",
 CellID->423508579]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[369246, 6976, 610, 17, 46, "Exercise",ExpressionUUID->"7f5b27e5-fde4-41e1-b876-2bff080a4f7d",
 CellID->232718658],
Cell[CellGroupData[{
Cell[369881, 6997, 1408, 41, 70, "ExerciseInput",ExpressionUUID->"7001bd8a-70d0-45ad-88aa-c9d22d5240ce",
 CellID->19139565],
Cell[371292, 7040, 32635, 587, 154, "ExerciseOutput",ExpressionUUID->"efe552ca-5998-4147-9711-1dbe1e4d9b4b",
 CellID->49745357]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[403973, 7633, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"94de4747-4e6e-421b-9d47-0aaae06c3428"],
Cell[404067, 7635, 386, 11, 28, "SolutionAnswer",ExpressionUUID->"fdf43274-3391-4caa-bcfc-a1b792c52575",
 CellID->36783165],
Cell[CellGroupData[{
Cell[404478, 7650, 247, 6, 27, "ExerciseInput",ExpressionUUID->"088612ab-bb1d-4ea3-8fac-061c5b1917f0",
 CellID->752469882],
Cell[404728, 7658, 154, 3, 48, "ExerciseOutput",ExpressionUUID->"5d449a56-902b-4337-971c-e6d7450c870d",
 CellID->94388535]
}, Open  ]],
Cell[404897, 7664, 120, 1, 22, "SolutionAnswer",ExpressionUUID->"45226d9d-eba7-47bf-9cd3-370ec9a08449",
 CellID->413758707],
Cell[CellGroupData[{
Cell[405042, 7669, 219, 5, 25, "ExerciseInput",ExpressionUUID->"b240b7cf-10f4-4497-97cd-6eb8cca298de",
 CellID->153529400],
Cell[405264, 7676, 185, 4, 45, "ExerciseOutput",ExpressionUUID->"91694195-99f9-4d7a-8fc1-a60efe03e0ea",
 CellID->306558678]
}, Open  ]],
Cell[405464, 7683, 186, 6, 22, "SolutionAnswer",ExpressionUUID->"04734e59-9e75-463a-9498-47fd023f869b",
 CellID->87074535],
Cell[CellGroupData[{
Cell[405675, 7693, 502, 15, 27, "ExerciseInput",ExpressionUUID->"2e006de4-a320-455d-88c0-e71f15332fb0",
 CellID->673767498],
Cell[406180, 7710, 185, 4, 45, "ExerciseOutput",ExpressionUUID->"455e77a4-eb85-41f6-89c5-3835a395cd31",
 CellID->648079561]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[406414, 7720, 616, 17, 46, "Exercise",ExpressionUUID->"ea4c3064-c93a-4926-bd7c-6f570ef58834",
 CellID->103266790],
Cell[CellGroupData[{
Cell[407055, 7741, 1406, 41, 70, "ExerciseInput",ExpressionUUID->"a77b0f5d-e40c-421a-a0fc-04d7c3d3b197",
 CellID->67821223],
Cell[408464, 7784, 7609, 173, 136, "ExerciseOutput",ExpressionUUID->"e07fc293-38ef-474e-9b69-e88a3f13d296",
 CellID->220558848]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[416119, 7963, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"36569ec2-b26f-4d5f-978e-a14a1ad92fd6"],
Cell[416213, 7965, 531, 12, 43, "SolutionAnswer",ExpressionUUID->"58599101-5e69-43bd-96c6-d86003dc8d97",
 CellID->15391170],
Cell[CellGroupData[{
Cell[416769, 7981, 253, 6, 25, "ExerciseInput",ExpressionUUID->"a97cac32-094d-4edc-8030-6d8e902f8e5f",
 CellID->349654309],
Cell[417025, 7989, 204, 5, 28, "ExerciseOutput",ExpressionUUID->"98628901-2c45-4b16-8f5c-df0b7a619740",
 CellID->36464723]
}, Open  ]],
Cell[417244, 7997, 120, 1, 22, "SolutionAnswer",ExpressionUUID->"564cf5fa-f1bb-4edf-9b34-365e4b76883f",
 CellID->464097779],
Cell[CellGroupData[{
Cell[417389, 8002, 200, 4, 25, "ExerciseInput",ExpressionUUID->"b7430d3d-990f-4780-af9b-fbfd564a3b81",
 CellID->415921525],
Cell[417592, 8008, 217, 5, 42, "ExerciseOutput",ExpressionUUID->"6b6d048b-1086-43c0-af6d-cfc9d891cad4",
 CellID->300628951]
}, Open  ]],
Cell[417824, 8016, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"7025c208-958d-43d2-817c-4a461a77c5a8",
 CellID->535448003],
Cell[CellGroupData[{
Cell[418036, 8026, 509, 15, 25, "ExerciseInput",ExpressionUUID->"66567672-f08c-434e-b13c-510ee1ba53ee",
 CellID->167710769],
Cell[418548, 8043, 217, 5, 42, "ExerciseOutput",ExpressionUUID->"22d31cc1-89d5-475f-aff5-08ed7a9372d2",
 CellID->247436032]
}, Open  ]]
}, Closed]],
Cell[418792, 8052, 324, 8, 25, "Exercise",ExpressionUUID->"c15ee5f3-5c8a-40fd-8f70-862379190d79",
 CellID->192778493],
Cell[CellGroupData[{
Cell[419141, 8064, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"a2581860-fc6e-4a21-abb2-86b25ed3a76e"],
Cell[419235, 8066, 518, 14, 22, "SolutionAnswer",ExpressionUUID->"7ddd7ab2-72d2-4882-9870-d95d70e5821c",
 CellID->183076685]
}, Closed]],
Cell[CellGroupData[{
Cell[419790, 8085, 566, 16, 27, "Exercise",ExpressionUUID->"85f1d49a-6f33-4904-ad4b-1cca6108c910",
 CellID->46333560],
Cell[CellGroupData[{
Cell[420381, 8105, 1466, 43, 70, "ExerciseInput",ExpressionUUID->"9a24e407-7bac-42c2-a320-aa0bdb33e477",
 CellID->334041819],
Cell[421850, 8150, 62158, 1067, 112, "ExerciseOutput",ExpressionUUID->"2f0060d6-2dfc-45d9-a90e-23f2e67bd67b",
 CellID->10338972]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[484054, 9223, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"9a78300e-06be-4ea4-94b9-d4e660464061"],
Cell[484148, 9225, 448, 9, 43, "SolutionAnswer",ExpressionUUID->"6b116786-0b68-4610-8712-b17db50fef58",
 CellID->218507297],
Cell[484599, 9236, 681, 21, 24, "SolutionAnswer",ExpressionUUID->"68da2da0-b04a-4110-bfd2-d5457251751d",
 CellID->158406688]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[485343, 9264, 309, 6, 135, "SmallText",ExpressionUUID->"1b52b183-046f-498f-9b6c-b4095cc0e3fc",
 CellGroupingRules->"SectionGrouping",
 CellID->262319513]
}
]
*)

(* NotebookSignature qRGpnPG45nRGklIpb7#kKHM8 *)
