(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    293212,       7106]
NotebookOptionsPosition[    140171,       3874]
NotebookOutlinePosition[    278557,       6824]
CellTagsIndexPosition[    278514,       6821]
WindowTitle->14. Applications of Cauchy\:2019s Theorem | Essentials of \
Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Applications of Cauchy\[CloseCurlyQuote]s Theorem"
}], "Section",
 CounterAssignments->{{"Section", 13}},
 CellID->129221763,ExpressionUUID->"91ec148e-6196-427c-bf8b-f4bc82ee23ad"],

Cell[TextData[{
 "Cauchy\[CloseCurlyQuote]s theorem states that if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fabe4a34-1d44-48aa-8e5f-c9ab1bc03fb4"],
 " is analytic in the region ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalR]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b10d97a8-006e-4ce7-a423-614ddc2189ee"],
 " whose boundary is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PartialD]", "\[ScriptCapitalR]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"ef100def-ea24-4d33-85e0-a60d89048d1b"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", 
       RowBox[{"\[PartialD]", "\[ScriptCapitalR]"}]}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e6c9983f-294c-4ca9-a562-c3785d3102bc"],
 "."
}], "Text",
 CellChangeTimes->{{3.968834509197134*^9, 3.968834509700926*^9}, {
  3.973000371215184*^9, 3.973000371963005*^9}},
 CellID->833569938,ExpressionUUID->"b7616f95-6757-49a1-8ac5-993c905a0bdf"],

Cell["\<\
The following examples will show how the theorem can be used to compute \
contour integrals by carefully choosing the region and, if necessary, moving \
the contour of integration.\
\>", "Text",
 CellID->297126330,ExpressionUUID->"def0ddda-571f-5048-bcc7-849b98a504e3"],

Cell[TextData[{
 "Example 1:",
 " Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9497e57f-a701-49c3-b41d-ee6e2c0c3065"],
 " for a simple closed curve traversed anticlockwise."
}], "Text",
 CellID->21285915,ExpressionUUID->"a9901b95-e376-4571-bb69-442a1224d558"],

Cell[TextData[{
 "The integrand is analytic everywhere except for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "42dfcbe6-70b0-704b-8231-0d1966055a4e"],
 ". Therefore, one needs to distinguish two situations: either the contour \
encloses the origin, or it does not. If it does not, like the path ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "14d16e94-a1bf-d04d-a777-1514188c69e6"],
 " in Fig. 1, the integral is zero by Cauchy\[CloseCurlyQuote]s theorem. If \
it does, like the path ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "02e7cb83-77e3-9a4d-84c2-27b25cb65ae9"],
 ", Cauchy\[CloseCurlyQuote]s theorem cannot be applied to the interior of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "58ef8aae-b39f-6942-b5c9-a9ad8ee4ff2d"],
 " because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "56278cc1-78e3-824a-be2b-e8e9fb18ea72"],
 " is not analytic in all of it. But it can be applied to the interior of the \
region bounded by ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1a109dc5-3668-824d-86ae-4e8a7896e647"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    SubscriptBox["C", "3"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2e3d6a61-f8cb-b145-9e3e-0c4d8d4aab84"],
 ", which is shaded in blue in Fig. 2, to conclude that"
}], "Text",
 CellID->8260647,ExpressionUUID->"e76f67eb-3055-8549-83a9-384fa0c200b3"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SubscriptBox["\[Integral]", 
        SubscriptBox["C", "2"]], 
       RowBox[{
        FractionBox["1", "z"], 
        RowBox[{"\[DifferentialD]", "z"}]}]}], "\[AlignmentMarker]", "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[Integral]", 
         SubscriptBox["C", "3"]], 
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
       RowBox[{
        SubscriptBox["\[Integral]", 
         RowBox[{"-", 
          SubscriptBox["C", "3"]}]], 
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
       RowBox[{
        SubscriptBox["\[Integral]", 
         SubscriptBox["C", "2"]], 
        RowBox[{
         FractionBox["1", "z"], 
         RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Integral]", 
          SubscriptBox["C", "3"]], 
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
        RowBox[{
         SubscriptBox["\[Integral]", 
          RowBox[{
           SubscriptBox["C", "2"], "\[Union]", 
           RowBox[{"(", 
            RowBox[{"-", 
             SubscriptBox["C", "3"]}], ")"}]}]], 
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         SubscriptBox["\[Integral]", 
          SubscriptBox["C", "3"]], 
         RowBox[{
          FractionBox["1", "z"], 
          RowBox[{"\[DifferentialD]", "z"}]}]}], " ", "+", " ", 
        RowBox[{
        "0", "         ", Cell[
         "by Cauchy\[CloseCurlyQuote]s theorem",ExpressionUUID->
          "b6995040-47a2-4507-9cf2-72837aa60739"]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormula",
 CellChangeTimes->{{3.9634836681413593`*^9, 3.963483670233055*^9}},
 CellID->382570416,ExpressionUUID->"c7df7b3e-69a0-4f8c-9c88-1e2fbdf6b43b"],

Cell[TextData[{
 "where the last step comes from the integral around the circular path, which \
you have computed before, in ",
 ButtonBox["Chapter 11",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "Text",
 CellID->185546139,ExpressionUUID->"97eeb03b-8930-4e5e-8df9-249f8b1f30bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", ",", "pts2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "2.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.9"}], ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.5"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.4"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "1.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1.9"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2.1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"pts2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5", ",", "4.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5", ",", "3.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.4", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5", ",", "3.5"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Row", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Labeled", "[", 
         RowBox[{
          RowBox[{"Graphics", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"LightBlue", ",", 
                RowBox[{"EdgeForm", "[", "White", "]"}], ",", 
                RowBox[{"FilledCurve", "[", 
                 RowBox[{"BSplineCurve", "[", 
                  RowBox[{"pts", ",", 
                   RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], ",", 
                RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"BSplineCurve", "[", 
                  RowBox[{"pts", ",", 
                   RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"LightBlue", ",", 
                RowBox[{"EdgeForm", "[", "White", "]"}], ",", 
                RowBox[{"FilledCurve", "[", 
                 RowBox[{"BSplineCurve", "[", 
                  RowBox[{"pts2", ",", 
                   RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], ",", 
                RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"BSplineCurve", "[", 
                  RowBox[{"pts2", ",", 
                   RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"9984d5b1-c0b5-4ac2-99ba-0f2900ace0c5\"]],\
ExpressionUUID->\"af45aa61-8f41-4edd-af44-f3cc75c2df2a\"]\)\>\"", ",", "12"}],
                  "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"4", ",", "4.5"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"152a9158-9ac1-4909-a8ae-b22d6932b17c\"]],\
ExpressionUUID->\"5016c905-a235-400a-b322-fdc4b3a8999a\"]\)\>\"", ",", "12"}],
                  "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2.5", ",", 
                  RowBox[{"-", "1.5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"Axes", "->", "True"}], ",", 
            RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
            RowBox[{"AxesLabel", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", 
               RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "12", "]"}]}], ",", 
            RowBox[{"PlotRange", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "4.5"}], ",", "5.5"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"Ticks", "->", "None"}], ",", 
            RowBox[{"ImageSize", "->", "Small"}]}], "]"}], 
          "\[IndentingNewLine]", 
          ",", "\"\<Fig. 1. Two contours \
\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"a5b79f92-c3df-49d9-8830-39a8c40cce31\"]],\
ExpressionUUID->\"cd699beb-c88b-46c7-95a8-c9488267c664\"]\) and \
\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"981b7b5c-16b7-4854-9e20-d4538a7a60f3\"]],\
ExpressionUUID->\"13f95b36-6baa-48bd-b24d-06e3a4b8bfd5\"]\).\>\""}], "]"}], 
        "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
        RowBox[{"Labeled", "[", 
         RowBox[{
          RowBox[{"Graphics", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"LightBlue", ",", 
                RowBox[{"EdgeForm", "[", "White", "]"}], ",", 
                RowBox[{"FilledCurve", "[", 
                 RowBox[{"BSplineCurve", "[", 
                  RowBox[{"pts", ",", 
                   RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], ",", 
                RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"BSplineCurve", "[", 
                  RowBox[{"pts", ",", 
                   RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"White", ",", 
                RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], ",", 
                RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
                RowBox[{"Arrowheads", "[", 
                 RowBox[{"-", "0.07"}], "]"}], ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"Circle", "[", "]"}], "]"}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"fc593005-2048-4bd3-977d-1e00ed0bc99d\"]],\
ExpressionUUID->\"5c5a1449-1b7a-4a35-a208-d69d06e2dede\"]\)\>\"", ",", "12"}],
                  "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2.5", ",", 
                  RowBox[{"-", "1.5"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Text", "[", 
               RowBox[{
                RowBox[{"Style", "[", 
                 
                 RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[RowBox[\
{\"(\", RowBox[{\"-\", 
SubscriptBox[\"C\", \"3\"]}], \")\"}], \
TraditionalForm]],ExpressionUUID->\"001c54df-9fe5-4cf1-91db-ed92655dee64\"]],\
ExpressionUUID->\"7dfa1d21-a89a-4a84-ba26-73a340fd7c51\"]\)\>\"", ",", "12"}],
                  "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "1.5"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
                RowBox[{"Point", "[", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"Axes", "->", "True"}], ",", 
            RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
            RowBox[{"AxesLabel", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", 
               RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "12", "]"}]}], ",", 
            RowBox[{"PlotRange", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "4.5"}], ",", "5.5"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"Ticks", "->", "None"}], ",", 
            RowBox[{"ImageSize", "->", "Small"}]}], "]"}], 
          "\[IndentingNewLine]", 
          ",", "\"\<Fig. 2. A domain that excludes the origin.\>\""}], 
         "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      RowBox[{"Spacer", "[", "12", "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellID->187504106,ExpressionUUID->"b9008107-0cab-4275-b6cc-45357e60bc96"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{12}, "Spacer1"], 
   TemplateBox[{
     GraphicsBox[{{
        RGBColor[0.87, 0.94, 1], 
        EdgeForm[
         GrayLevel[1]], 
        FilledCurveBox[
         BSplineCurve[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, {
        RGBColor[0.87, 0.94, 1], 
        EdgeForm[
         GrayLevel[1]], 
        FilledCurveBox[
         BSplineCurve[{{4, 4}, {3, 4.5}, {2.5, 4.4}, {2.4, 4}, {2.5, 3.7}, {
           3, 3.5}, {3.4, 3}, {3.2, 2}, {4, 1.5}, {4.2, 2}, {4, 2.5}, {
           4.2, 3}, {4.5, 3.5}}, SplineClosed -> True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{4, 4}, {3, 4.5}, {2.5, 4.4}, {2.4, 4}, {2.5, 
           3.7}, {3, 3.5}, {3.4, 3}, {3.2, 2}, {4, 1.5}, {4.2, 2}, {4, 2.5}, {
           4.2, 3}, {4.5, 3.5}}, SplineClosed -> True]]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {4, 4.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {2.5, -1.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], {
        PointSize[Medium], 
        PointBox[{0, 0}]}}, Axes -> True, AspectRatio -> Automatic, AxesLabel -> {
        FormBox[
         RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
        FormBox[
         RowBox[{"Im", "(", "z", ")"}], TraditionalForm]}, LabelStyle -> 
      Directive[12], PlotRange -> {{-5, 5}, {-4.5, 5.5}}, Ticks -> None, 
      ImageSize -> Small], 
     "\"Fig. 1. Two contours \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\", \
\\\"1\\\"], TraditionalForm]]]]]\\) and \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\", \
\\\"2\\\"], TraditionalForm]]]]]\\).\""}, "Labeled", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"]}, {
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Labeled", "[", 
       RowBox[{#, ",", #2, ",", 
         RowBox[{"{", "}"}]}], "]"}]& )], 
   TemplateBox[{
     GraphicsBox[{{
        RGBColor[0.87, 0.94, 1], 
        EdgeForm[
         GrayLevel[1]], 
        FilledCurveBox[
         BSplineCurve[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, {
        GrayLevel[1], 
        DiskBox[{0, 0}]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[-0.07], 
        ArrowBox[
         CircleBox[{0, 0}]]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {2.5, -1.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\n \
RowBox[{\\\"(\\\", RowBox[{\\\"-\\\", \\nSubscriptBox[\\\"C\\\", \
\\\"3\\\"]}], \\\")\\\"}], \\n  TraditionalForm]]]]]\\)\"", 12, StripOnInput -> 
          False], TraditionalForm], {0.5, 1.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], {
        PointSize[Medium], 
        PointBox[{0, 0}]}}, Axes -> True, AspectRatio -> Automatic, AxesLabel -> {
        FormBox[
         RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
        FormBox[
         RowBox[{"Im", "(", "z", ")"}], TraditionalForm]}, LabelStyle -> 
      Directive[12], PlotRange -> {{-5, 5}, {-4.5, 5.5}}, Ticks -> None, 
      ImageSize -> Small], "\"Fig. 2. A domain that excludes the origin.\""}, 
    "Labeled", DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"]}, {
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Labeled", "[", 
       RowBox[{#, ",", #2, ",", 
         RowBox[{"{", "}"}]}], "]"}]& )]},
  "RowWithSeparator"]], "Output",
 CellID->1097253012,ExpressionUUID->"19db85bf-725e-4601-924c-8f1ce4a6dfb2"]
}, {2}]],

Cell[TextData[{
 "Example 2:",
 " Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], "+", "3"}], 
      RowBox[{
       SuperscriptBox["z", "4"], "-", 
       RowBox[{"2", "z"}], "+", "3"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1c91dbf3-9066-497d-a2c7-6718bb77d238"],
 " with ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "21acbf44-a863-492b-9235-229bb919d913"],
 " the circle ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "z", "|"}], "=", "2"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"27583c6e-0e5e-4ad5-aafb-1314d18535ed"],
 " traversed anticlockwise."
}], "Text",
 CellID->393627039,ExpressionUUID->"59caea3b-52e7-4a92-921a-be1cf894ce0e"],

Cell[TextData[{
 "Because the denominator has zeros inside of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2d7d3b91-08b4-784b-94ca-ab3e6e652205"],
 ", the integrand ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "+", "3"}], 
     RowBox[{
      SuperscriptBox["z", "4"], "-", 
      RowBox[{"2", "z"}], "+", "3"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e34217b8-b5a7-e144-a875-72dac28ec97b"],
 " is not analytic inside the region whose boundary is ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d4fa823f-4f8e-df4c-b998-ad5d58e6c172"],
 ", and Cauchy\[CloseCurlyQuote]s theorem can\[CloseCurlyQuote]t be applied \
to the disk bounded by ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6393a521-9615-8e40-ac3f-af74c3f6d700"],
 ". However, the denominator has no zeros outside of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "82b0865e-d463-2b43-93f6-30be82e9e4e7"],
 ". So, considering the contour ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PartialD]", "\[CapitalOmega]"}], "=", 
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{"C", "\[Union]", 
       SubscriptBox["C", "1"], "\[Union]", 
       SubscriptBox["C", "2"], "\[Union]", 
       SubscriptBox["C", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c424c2a4-b1ae-3149-ad31-525cd493b364"],
 ", the integrand is analytic in the region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "31d5c681-a75a-5a41-abdb-0545cc805f53"],
 " delimited by it, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{"\[PartialD]", "\[CapitalOmega]"}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"6d9ff89a-9694-fb4d-bebe-8e78a574fbe8"],
 ". Furthermore, by the way these two paths are defined, the integrals along ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "11b68556-c628-5843-b601-63d96c25dd5a"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "3"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "40237179-e54e-1c4e-bab7-c52eb0e110c1"],
 " cancel out. So, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{"-", 
       SubscriptBox["C", "2"]}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"ec83de27-b24a-0e49-aae3-20082903c22d"],
 ". Choosing ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "965a19ac-e19c-cf41-876a-9071a7039a57"],
 " to be a circle of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "82b5dffe-92a9-e04a-b7e8-0faa13dd90f5"],
 ", one can bound the integral using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}]}], "|"}], "=", 
    RowBox[{
     RowBox[{"|", 
      RowBox[{
       SubscriptBox["\[Integral]", 
        RowBox[{"-", 
         SubscriptBox["C", "2"]}]], 
       RowBox[{
        RowBox[{"f", "(", "z", ")"}], 
        RowBox[{"\[DifferentialD]", "z"}]}]}], "|", 
      RowBox[{"<=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", " ", "R"}], ")"}], "\[CenterDot]", 
        FractionBox["2", 
         SuperscriptBox["R", "2"]]}]}]}], "=", 
     FractionBox[
      RowBox[{
       SuperscriptBox["R", "2"], "+", "3"}], 
      RowBox[{
       SuperscriptBox["R", "4"], "-", 
       RowBox[{"2", "R"}], "-", "3"}]]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1446efe0-0eec-834b-aa6a-550f8e03a21c"],
 ". This is zero in the limit of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f365799f-9017-cf4d-8cd6-37d3518186e9"],
 ". Since ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "552a84df-1908-124e-8300-0abdad820683"],
 " can be arbitrarily large, the integral must be zero."
}], "Text",
 CellID->187009770,ExpressionUUID->"c89efebf-8fca-464e-bbba-3e1144dff972"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", 
    RowBox[{
     RowBox[{"t", "=", "0.01"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ComplexListPlot", "[", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{"SolveValues", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"z", "^", "4"}], "-", 
               RowBox[{"2", "z"}], "+", "3"}], "==", "0"}], ",", "z"}], "]"}],
            "]"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "}"}]}],
           ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "z", "]"}], ",", 
             RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
          RowBox[{"LabelStyle", "->", 
           RowBox[{"Directive", "[", "12", "]"}]}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "5.5"}], ",", "5.5"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"Ticks", "->", "None"}], ",", 
          RowBox[{"ImageSize", "->", "250"}]}], "]"}], ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"LightBlue", ",", 
             RowBox[{"Annulus", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.05", ",", 
                 RowBox[{
                  RowBox[{"2", "\[Pi]"}], "-", "0.05"}]}], "}"}]}], "]"}]}], 
            "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], ",", 
             RowBox[{"Thickness", "[", "t", "]"}], ",", 
             RowBox[{"Arrowheads", "[", 
              RowBox[{"{", 
               RowBox[{
               "0", ",", "0.07", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
                "0", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"Arrow", "[", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
                RowBox[{"{", 
                 RowBox[{"0.1", ",", 
                  RowBox[{
                   RowBox[{"2", "\[Pi]"}], "-", "0.1"}]}], "}"}]}], "]"}], 
              "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], ",", 
             RowBox[{"Thickness", "[", "t", "]"}], ",", 
             RowBox[{"Arrowheads", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0.07", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"Arrow", "@", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"5", ",", "0.2"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"2", ",", "0.2"}], "}"}]}], "}"}], "]"}]}]}], "}"}],
            ",", 
           RowBox[{"{", 
            RowBox[{
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], ",", 
             RowBox[{"Thickness", "[", "t", "]"}], ",", 
             RowBox[{"Arrowheads", "[", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0.07", ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"Arrow", "@", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"2", ",", 
                   RowBox[{"-", "0.15"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"5", ",", 
                   RowBox[{"-", "0.15"}]}], "}"}]}], "}"}], "]"}]}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], ",", 
             RowBox[{"Thickness", "[", "t", "]"}], ",", 
             RowBox[{"Arrowheads", "[", 
              RowBox[{"{", 
               RowBox[{
               "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
                RowBox[{"-", "0.07"}], ",", "0"}], "}"}], "]"}], ",", 
             RowBox[{"Arrow", "[", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", "5", ",", 
                RowBox[{"{", 
                 RowBox[{"0.05", ",", 
                  RowBox[{
                   RowBox[{"2", "\[Pi]"}], "-", "0.05"}]}], "}"}]}], "]"}], 
              "]"}]}], "}"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              
              RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"021f6825-5758-4bf0-a4c9-bb1975581c79\"]],\
ExpressionUUID->\"0ed93be1-5df9-4112-855a-ed74b8325255\"]\)\>\"", ",", "12"}],
               "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"90609795-4c57-4d7e-af83-aabcd852f0f3\"]],\
ExpressionUUID->\"75611adf-2d78-4fba-be98-35a108eee69c\"]\)\>\"", ",", "12"}],
               "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3.5", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"3\"], \
TraditionalForm]],ExpressionUUID->\"50f64cb4-8b36-4dc3-92fe-6993f0f67757\"]],\
ExpressionUUID->\"6557bc55-99eb-408f-bbe2-2ffeb1ba11be\"]\)\>\"", ",", "12"}],
               "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3.5", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"bb53c9e4-e5a6-4443-b119-4c3418377978\"]],\
ExpressionUUID->\"f5be81c6-e9f1-4e45-9dd8-09dc69789c4f\"]\)\>\"", ",", "12"}],
               "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"-", "4"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              
              RowBox[{"\"\<\!\(TraditionalForm\`\[CapitalOmega]\)\>\"", ",", 
               "12"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"2", ",", "12"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Fig. 3. By cutting the annular region with two overlapping \
lines traversed in opposite directions, the integration contour can be \
deformed from the smaller to the larger circle. Poles of \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
       "<>", "\"\< are marked in red.\>\""}], "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellID->789919316,ExpressionUUID->"1fd76736-c843-42db-b85c-6e3d7266a312"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{{}, {}}, {}, {{}, 
         InterpretationBox[{
           TagBox[
            TagBox[
             {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
              PointBox[{{-0.9513248470511935, -1.1960776684564085`}, \
{-0.9513248470511935, 1.1960776684564085`}, {
               0.9513248470511935, -0.6159838798652404}, {0.9513248470511935, 
               0.6159838798652404}}]},
             Annotation[#, "Charting`Private`Tag#1"]& ],
            {
            "WolframDynamicHighlight", <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
           StyleBox[
            DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
              Slot["HighlightElements"], 
              Slot["LayoutOptions"], 
              Slot["Meta"], 
              Charting`HighlightActionFunction["DynamicHighlight", {{
                 Annotation[{
                   Directive[
                    AbsoluteThickness[2], 
                    PointSize[Medium], 
                    RGBColor[1, 0, 0]], 
                   
                   Point[{{-0.9513248470511935, -1.1960776684564085`}, \
{-0.9513248470511935, 1.1960776684564085`}, {
                    0.9513248470511935, -0.6159838798652404}, {
                    0.9513248470511935, 0.6159838798652404}}]}, 
                  "Charting`Private`Tag#1"]}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PanelPlotLayout" -> <||>, 
                  "PlotRange" -> {{-6., 6.}, {-5.5, 5.5}}, 
                  "Frame" -> {{False, False}, {False, False}}, 
                  "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
                  "Axes" -> {True, True}, "LabelStyle" -> {
                    Directive[12]}, "AspectRatio" -> Automatic, 
                  "DefaultStyle" -> {
                    Directive[
                    AbsoluteThickness[2], 
                    PointSize[Medium], 
                    RGBColor[1, 0, 0]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> ComplexListPlot, "GroupHighlight" -> 
                  False|>|>]]& )[<|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{-6., 6.}, {-5.5, 5.5}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
                 "Axes" -> {True, True}, "LabelStyle" -> {
                   Directive[12]}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                   Directive[
                    AbsoluteThickness[2], 
                    PointSize[Medium], 
                    RGBColor[1, 0, 0]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>],
             
             ImageSizeCache->{{
              4.503599627370496*^15, -4.503599627370496*^15}, {
              4.503599627370496*^15, -4.503599627370496*^15}}],
            Selectable->False]},
          Annotation[{{
             Annotation[{
               Directive[
                AbsoluteThickness[2], 
                PointSize[Medium], 
                RGBColor[1, 0, 0]], 
               
               Point[{{-0.9513248470511935, -1.1960776684564085`}, \
{-0.9513248470511935, 1.1960776684564085`}, {
                0.9513248470511935, -0.6159838798652404}, {0.9513248470511935,
                 0.6159838798652404}}]}, "Charting`Private`Tag#1"]}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{-6., 6.}, {-5.5, 5.5}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
              "Axes" -> {True, True}, "LabelStyle" -> {
                Directive[12]}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                Directive[
                 AbsoluteThickness[2], 
                 PointSize[Medium], 
                 RGBColor[1, 0, 0]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> (Identity[
                   Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
           "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, \
{}}}}, {
        {RGBColor[0.87, 0.94, 1], 
         InterpretationBox[FilledCurveBox[BSplineCurve[CompressedData["
1:eJxTTMoPSmViYGAQBWIQXRH988PMn8IODLb7vaf9OW//jv2qvKSQsMNrKB0G
FS+HqutJnG239afQgaTQ8MV1P0UcoOIHYOqg4gdg6qDi+2HqoOIOMHUwc2Hq
eBsOb+f6zu2wp3z+OaaUY/sjJmlIH/7639415f+ie9N27heZ88MgNOafvZ/L
mqYZxxkOwMSh6vbDxKHq4OJQdfYwcag6B5g4zB6vZYpp0c3/7N2gdBRUnBmq
Dua+Boj77NHDDwC8i7Bk
            "], 
            SplineKnots -> {
             0, 0, 0, Rational[1, 10], Rational[1, 10], Rational[1, 5], 
              Rational[1, 5], Rational[3, 10], Rational[3, 10], Rational[
              2, 5], Rational[2, 5], Rational[1, 2], Rational[1, 2], Rational[
              3, 5], Rational[3, 5], Rational[7, 10], Rational[7, 10], 
              Rational[4, 5], Rational[4, 5], Rational[9, 10], Rational[
              9, 10], 1, 1, 1}, 
            SplineWeights -> {
             1.0025041725771424`, 1.0500417083755387`, 2, 2, 4, 4, 8, 8, 16, 
              16, 16, 8, 8, 4, 4, 2, 2, 1.0500417083755387`, 
              1.0025041725771424`, 1.0025041725771424`, 1.0025041725771424`}, 
            SplineDegree -> 2]],
          Annulus[{0, 0}, {2, 5}, {0.05, 6.233185307179586}]]}, 
        {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.01], 
         Arrowheads[{0, 0.07, 0, 0, 0, 0, 0, 0}], 
         ArrowBox[CircleBox[{0, 0}, 2, {0.1, 6.183185307179587}]]}, 
        {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.01], 
         Arrowheads[{0, 0.07, 0}], ArrowBox[LineBox[{{5, 0.2}, {2, 0.2}}]]}, 
        {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.01], 
         Arrowheads[{0, 0.07, 0}], 
         ArrowBox[LineBox[{{2, -0.15}, {5, -0.15}}]]}, 
        {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.01], 
         Arrowheads[{0, 0, 0, 0, 0, 0, -0.07, 0}], 
         ArrowBox[CircleBox[{0, 0}, 5, {0.05, 6.233185307179586}]]}, 
        InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {1.5, 2}, NCache[
         ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {3.5, -1}, NCache[
         ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"C\\\", \\\"3\\\"], TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {3.5, 1}, NCache[
         ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {4, -4}, NCache[
         ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], InsetBox[
         StyleBox["\<\"\\!\\(TraditionalForm\\`\[CapitalOmega]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {-3, 3}, NCache[
         ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
          ImageScaled[{0.5, 0.5}]]], InsetBox[
         StyleBox["2",
          StripOnInput->False,
          FontSize->12], {2, 0}, ImageScaled[{1.25, 1}]]}},
      AspectRatio->Automatic,
      Axes->True,
      AxesLabel->{
        FormBox[
         RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
        FormBox[
         RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->250,
      LabelStyle->Directive[12],
      Method->{
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& )}},
      PlotRange->{{-6., 6.}, {-5.5, 5.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{}, {}}]},
    {"\<\"Fig. 3. By cutting the annular region with two overlapping lines \
traversed in opposite directions, the integration contour can be deformed \
from the smaller to the larger circle. Poles of \
\\!\\(\\*FormBox[RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \
TraditionalForm]\\) are marked in red.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->282170156,ExpressionUUID->"3607a9a2-171e-4495-be5a-448d559054a1"]
}, {2}]],

Cell[TextData[{
 "You can confirm this using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->834091415,ExpressionUUID->"07e0950c-f3ce-4231-b664-d53431ab5bc8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "+", "3"}], 
    RowBox[{
     SuperscriptBox["z", "4"], "-", 
     RowBox[{"2", "z"}], "+", "3"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], "]"}]], "Input",\

 CellID->189350834,ExpressionUUID->"83385ebf-a785-41ec-9d90-d8ec3d5a3975"],

Cell[BoxData["0"], "Output",
 CellID->394085046,ExpressionUUID->"d0254cec-050c-4f9b-ad90-a2d206a72224"]
}, Open  ]],

Cell["\<\
These examples illustrate once again that the value of the integral does not \
change if a closed path is continuously deformed into another, while staying \
at all times in the region of analyticity of the integrand.\
\>", "Text",
 CellID->450975194,ExpressionUUID->"b6bc2780-a308-48dc-9c6b-d3263dfda0a0"],

Cell[TextData[{
 "From Cauchy\[CloseCurlyQuote]s theorem one can deduce that, for example, if \
a function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bc03ed32-d17b-4c65-b107-649e8a5d5c93"],
 " is analytic in the shaded region, but not in the white regions, the \
integral over ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9f83f9a2-d324-4fc9-ab5a-135ffa1339b6"],
 " can be replaced with the sum of integrals over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "i"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "78ba1fc4-6a9a-4d2b-89ed-44c16a79b75a"],
 " (Fig. 4)."
}], "Text",
 CellID->40865661,ExpressionUUID->"3d41c076-6fa5-47f7-aeda-9ec6abad2ea6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"pts", ",", "pts2"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"pts", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4", ",", "4.3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.6", ",", "3.6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.7", ",", "2.3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.2", ",", "1.8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "0.7"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3.4", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5.2", ",", "0.8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6.1", ",", "2.4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5.5", ",", "4"}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pts2", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3.4", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "2.8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.2", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.7", ",", "1.6"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3.6", ",", "1.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4.9", ",", "2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5.1", ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4.6", ",", "2.9"}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"LightBlue", ",", 
               RowBox[{"EdgeForm", "[", 
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"White", ",", 
               RowBox[{"EdgeForm", "[", 
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts2", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts2", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"f9da365d-a80f-4ff5-878b-a1aad228c4d7\"]],\
ExpressionUUID->\"38ab4f52-1b43-4348-9446-6d4bb420755e\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"2.8", ",", "4.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"58a07c2d-1ba4-48c3-9f99-06343d44e14e\"]],\
ExpressionUUID->\"b447fd20-980d-42db-b203-21a3467ef57d\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"3.4", ",", "3.4"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"Axes", "->", "True"}], ",", 
           RowBox[{"PlotRange", "->", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"AxesLabel", "->", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], 
           ",", 
           RowBox[{"Ticks", "->", "None"}], ",", 
           RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
           RowBox[{"ImageSize", "->", "200"}]}], "]"}]}]}], "]"}], 
      "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"pts", ",", "pts2", ",", "pts3", ",", "pts4"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"pts", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4", ",", "4.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.5", ",", "4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.6", ",", "3.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0.8", ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.4", ",", "1.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.1", ",", "0.7"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "0.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"8.3", ",", "1.4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"8.5", ",", "2.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"7.6", ",", "4.7"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6.6", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5.6", ",", "5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5", ",", "4.5"}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pts2", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2.8", ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.1", ",", "2.1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2.2", ",", "1.8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3.2", ",", "1.8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3.2", ",", "2.3"}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pts3", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"5.1", ",", "3.4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3.9", ",", "3.4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4.4", ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"5.3", ",", "2.7"}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"pts4", "=", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"7", ",", "3.1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6.4", ",", "2.8"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6.4", ",", "2.4"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"7", ",", "2.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"7.9", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"7.4", ",", "3.6"}], "}"}]}], "}"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"LightBlue", ",", 
               RowBox[{"EdgeForm", "[", 
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.012", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"White", ",", 
               RowBox[{"EdgeForm", "[", 
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts2", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.012", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts2", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"White", ",", 
               RowBox[{"EdgeForm", "[", 
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts3", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.012", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts3", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"White", ",", 
               RowBox[{"EdgeForm", "[", 
                
                TemplateBox[<|
                 "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                 "RGBColorSwatchTemplate"], "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts4", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.012", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts4", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"c37efe88-80bf-48d0-b215-1f61407d45cb\"]],\
ExpressionUUID->\"f88eacdc-3898-4b29-aade-9e7e7eb75522\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"3.5", ",", "4.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"d6710e7b-5704-4fde-955f-ee646191f358\"]],\
ExpressionUUID->\"b8041897-b80b-4662-9cd5-77786affa72e\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "2.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"b52a4ad3-0cfa-4500-b203-95ba13fba7f5\"]],\
ExpressionUUID->\"53dacf78-5c6f-4d7b-8179-ab404fd6f29b\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"5.2", ",", "3.7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"3\"], \
TraditionalForm]],ExpressionUUID->\"82d4bb6e-56a9-4e46-b511-ccee39dd6751\"]],\
ExpressionUUID->\"e91b3a72-54be-4783-9b7a-258afad70b33\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"6.3", ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], 
            "\[IndentingNewLine]", "}"}], ",", 
           RowBox[{"Axes", "->", "True"}], ",", 
           RowBox[{"PlotRange", "->", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "9"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "6"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"AxesLabel", "->", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], 
           ",", 
           RowBox[{"Ticks", "->", "None"}], ",", 
           RowBox[{"AspectRatio", "->", "0.95"}], ",", 
           RowBox[{"ImageSize", "->", 
            RowBox[{"1200", "/", "7"}]}]}], "]"}]}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", 
    RowBox[{"(*", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<\[Rule]\>\"", ",", "32", ",", 
       RowBox[{"GrayLevel", "[", "0.6", "]"}]}], "]"}], "*)"}], 
    RowBox[{"Spacer", "[", "50", "]"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"\"\<Fig. 4. The integral over \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"C", ",", "TraditionalForm"}], "]"}], 
      "<>", "\"\< can be deformed into a sum of integrals over \
\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"i\"], \
TraditionalForm]],ExpressionUUID->\"a97f419b-4418-4f7e-8f3f-b1e1a7db0fd7\"]],\
ExpressionUUID->\"e1f5f81c-5fb3-47b9-91b2-d64eda8ef6eb\"]\) if the integrand \
is analytic in the blue-shaded region.\>\""}]}], "]"}], "&"}]}]], "Input",
 CellID->140283603,ExpressionUUID->"a6818e93-4d74-49f9-8fdd-43f076943351"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     TemplateBox[{50}, "Spacer1"], 
     GraphicsBox[{{
        RGBColor[0.87, 0.94, 1], 
        EdgeForm[
         RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{4, 4.3}, {2, 4}, {1.6, 3.6}, {1.7, 2.3}, {1.2, 1.8}, {
           2, 0.7}, {3.4, 1}, {5.2, 0.8}, {6.1, 2.4}, {5.5, 4}}, SplineClosed -> 
          True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{4, 4.3}, {2, 4}, {1.6, 3.6}, {1.7, 2.3}, {1.2, 
           1.8}, {2, 0.7}, {3.4, 1}, {5.2, 0.8}, {6.1, 2.4}, {5.5, 4}}, 
          SplineClosed -> True]]}, {
        GrayLevel[1], 
        EdgeForm[
         RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{4, 3}, {3.4, 3}, {3, 2.8}, {2.2, 2}, {2.7, 1.6}, {3.6,
            1.5}, {4.9, 2}, {5.1, 2.5}, {4.6, 2.9}}, SplineClosed -> True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{4, 3}, {3.4, 3}, {3, 2.8}, {2.2, 2}, {2.7, 1.6}, {
           3.6, 1.5}, {4.9, 2}, {5.1, 2.5}, {4.6, 2.9}}, SplineClosed -> 
          True]]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], TraditionalForm], {
        2.8, 4.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {3.4, 3.4}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]]}, Axes -> True, 
      PlotRange -> {{-1, 6}, {-1, 5}}, AxesLabel -> {
        FormBox[
         StyleBox[
          RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm], 
        FormBox[
         StyleBox[
          RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm]}, Ticks -> None, AspectRatio -> Automatic, 
      ImageSize -> 200], 
     GraphicsBox[{{
        RGBColor[0.87, 0.94, 1], 
        EdgeForm[
         RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{4, 4.2}, {2.5, 4}, {1.6, 3.5}, {0.8, 2.5}, {1.4, 
           1.2}, {2.1, 0.7}, {5, 0.5}, {8.3, 1.4}, {8.5, 2.2}, {7.6, 4.7}, {
           6.6, 5}, {5.6, 5}, {5, 4.5}}, SplineClosed -> True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.012], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{4, 4.2}, {2.5, 4}, {1.6, 3.5}, {0.8, 2.5}, {1.4, 
           1.2}, {2.1, 0.7}, {5, 0.5}, {8.3, 1.4}, {8.5, 2.2}, {7.6, 4.7}, {
           6.6, 5}, {5.6, 5}, {5, 4.5}}, SplineClosed -> True]]}, {
        GrayLevel[1], 
        EdgeForm[
         RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{2.8, 2.5}, {2.1, 2.1}, {2.2, 1.8}, {3.2, 1.8}, {3.2, 
          2.3}}, SplineClosed -> True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.012], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{2.8, 2.5}, {2.1, 2.1}, {2.2, 1.8}, {3.2, 1.8}, {
          3.2, 2.3}}, SplineClosed -> True]]}, {
        GrayLevel[1], 
        EdgeForm[
         RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{5.1, 3.4}, {3.9, 3.4}, {4.4, 2.5}, {5.3, 2.7}}, 
          SplineClosed -> True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.012], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{5.1, 3.4}, {3.9, 3.4}, {4.4, 2.5}, {5.3, 2.7}}, 
          SplineClosed -> True]]}, {
        GrayLevel[1], 
        EdgeForm[
         RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{7, 3.1}, {6.4, 2.8}, {6.4, 2.4}, {7, 2.2}, {7.9, 3}, {
           7.4, 3.6}}, SplineClosed -> True]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.012], 
        Arrowheads[0.07], 
        ArrowBox[
         BSplineCurveBox[{{7, 3.1}, {6.4, 2.8}, {6.4, 2.4}, {7, 2.2}, {
           7.9, 3}, {7.4, 3.6}}, SplineClosed -> True]]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], TraditionalForm], {
        3.5, 4.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {2, 2.5}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {5.2, 3.7}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"3\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {6.3, 2}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]]}, Axes -> True, 
      PlotRange -> {{-1, 9}, {-1, 6}}, AxesLabel -> {
        FormBox[
         StyleBox[
          RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm], 
        FormBox[
         StyleBox[
          RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm]}, Ticks -> None, AspectRatio -> 0.95, ImageSize -> 
      NCache[
        Rational[1200, 7], 171.42857142857142`]]}, "RowWithSeparator"], 
   "\"Fig. 4. The integral over \\!\\(\\*FormBox[\\\"C\\\", \
TraditionalForm]\\) can be deformed into a sum of integrals over \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\", \
\\\"i\\\"], TraditionalForm]]]]]\\) if the integrand is analytic in the \
blue-shaded region.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->2131887395,ExpressionUUID->"02d4ca77-dc7c-480e-b40d-5f85a7560ff3"]
}, {2}]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->202305252,ExpressionUUID->"c2c62b1c-161e-4b21-901e-8386163a8a52"],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "5"}]}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "z"], "+", 
       FractionBox["1", 
        RowBox[{"z", "-", "3"}]]}], ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"649e0978-ce25-db40-a081-2b36005d4280"],
 "."
}], "SolvedExampleNote",
 CellID->758441683,ExpressionUUID->"a28e74c8-1ea5-644c-a078-be8c040f8241"],

Cell[TextData[{
 "The integrand is not analytic at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "40dbe587-de8d-44f6-97fe-b2f8ecac4f70"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "3"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "778aee41-3c37-458c-986b-f4830651710b"],
 ", which are inside the contour. Therefore you can replace the original \
contour as in the figure. Using what you computed in ",
 ButtonBox["Chapter 11",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", namely ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "a"}], ")"}], 
       RowBox[{"-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "046361a4-ee1d-422e-85dc-7e23e0072320"],
 " when ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c5c79933-bb24-481e-8044-827515460aee"],
 " is inside the contour, you can conclude that the result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "013a2195-d576-45bb-9f5e-f1804794b860"],
 "."
}], "SolvedExampleNote",
 CellID->805348312,ExpressionUUID->"e793c154-a0f1-4121-98ba-544536c21bee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t", "=", "0.01"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Row", "[", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
               "RGBColorSwatchTemplate"], ",", 
              RowBox[{"Thickness", "[", "t", "]"}], ",", 
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{
                "0", ",", "0.07", ",", "0", ",", "0", ",", "0", ",", "0", ",",
                  "0", ",", "0"}], "}"}], "]"}], ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "5", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "]"}]}], "}"}], ",",
             "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               
               RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"8cdc6b02-c060-47aa-aca2-42992ff5c091\"]],\
ExpressionUUID->\"553657b9-e813-4274-89e4-cd27f80fcb5e\"]\)\>\"", ",", "12"}],
                "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "3"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
           "}"}], ",", 
          RowBox[{"Axes", "->", "True"}], ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "z", "]"}], ",", 
             RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", "12", "]"}]}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "170"}]}], "]"}], "\[IndentingNewLine]", 
        ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", "0", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
          
          RowBox[{"ImageSize", "->", "30"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
               "RGBColorSwatchTemplate"], ",", 
              RowBox[{"Thickness", "[", "t", "]"}], ",", 
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0.05", ",", "0", ",", "0"}], "}"}], "]"}], 
              ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "]"}]}], "}"}], ",",
             "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
               "RGBColorSwatchTemplate"], ",", 
              RowBox[{"Thickness", "[", "t", "]"}], ",", 
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0.05", ",", "0", ",", "0"}], "}"}], "]"}], 
              ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"3", ",", "0"}], "}"}], ",", "1", ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"Point", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"3", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",",
             "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"6522338e-eab8-433f-bedd-0c3b2b06f025\"]],\
ExpressionUUID->\"c514572c-d357-4458-a168-1e3f10dcaba6\"]\)\>\"", ",", "12"}],
                "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"569e749e-0e90-4a7f-bea5-2373d1d0f80f\"]],\
ExpressionUUID->\"51d879fa-1121-474d-985d-8d3ffc6866d9\"]\)\>\"", ",", "12"}],
                "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"4", ",", "1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], 
           "\[IndentingNewLine]", "}"}], ",", 
          RowBox[{"Axes", "->", "True"}], ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Re", "[", "z", "]"}], ",", 
             RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
           RowBox[{"Directive", "[", "12", "]"}]}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "7"}], ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "7"}], ",", "7"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "170"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
    "#", ",", "\"\<Fig. 5. Deforming the contour into two circles around the \
singularities.\>\""}], "]"}], "&"}]}]], "SolvedExampleInput",
 CellID->539812757,ExpressionUUID->"3a4bca9f-5870-4874-9201-e42932aeb49c"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     GraphicsBox[{{
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[{0, 0.07, 0, 0, 0, 0, 0, 0}], 
        ArrowBox[
         CircleBox[{0, 0}, 5, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], TraditionalForm], {3, 
        3}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], {
        RGBColor[1, 0, 0], 
        PointBox[{{0, 0}, {3, 0}}]}}, Axes -> True, AspectRatio -> Automatic, 
      AxesLabel -> {
        FormBox[
         RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
        FormBox[
         RowBox[{"Im", "(", "z", ")"}], TraditionalForm]}, LabelStyle -> 
      Directive[12], PlotRange -> {{-7, 7}, {-7, 7}}, ImageSize -> 170], 
     GraphicsBox[{
       Opacity[0], 
       LineBox[{{0, 0}, {1, 0}}]}, ImageSize -> 30], 
     GraphicsBox[{{
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[{0, 0.05, 0, 0}], 
        ArrowBox[
         CircleBox[{0, 0}, 1, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]]}, {
        RGBColor[0.368417, 0.506779, 0.709798], 
        Thickness[0.01], 
        Arrowheads[{0, 0.05, 0, 0}], 
        ArrowBox[
         CircleBox[{3, 0}, 1, 
          NCache[{0, 2 Pi}, {0, 6.283185307179586}]]]}, {
        RGBColor[1, 0, 0], 
        PointBox[{{0, 0}, {3, 0}}]}, 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {1, 1}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], 
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\
\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", 12, StripOnInput -> False], 
         TraditionalForm], {4, 1}, 
        NCache[
         ImageScaled[{
           Rational[1, 2], 
           Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]]}, Axes -> True, AspectRatio -> Automatic, 
      AxesLabel -> {
        FormBox[
         RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
        FormBox[
         RowBox[{"Im", "(", "z", ")"}], TraditionalForm]}, LabelStyle -> 
      Directive[12], PlotRange -> {{-7, 7}, {-7, 7}}, ImageSize -> 170]}, 
    "RowDefault"], 
   "\"Fig. 5. Deforming the contour into two circles around the \
singularities.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "SolvedExampleOutput",
 CellID->283030473,ExpressionUUID->"70e89134-0187-4f9c-822d-4348c883b031"]
}, {2}]],

Cell[TextData[{
 "Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->314865864,ExpressionUUID->"dc753f99-64f1-461c-b9f6-6a333f598ca5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "z"], "+", 
    FractionBox["1", 
     RowBox[{"z", "-", "3"}]]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->53701562,ExpressionUUID->"93c07494-f93b-472a-9c66-37e27bece054"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->377012568,ExpressionUUID->"12aad69e-107b-4113-b046-85541f51df77"]
}, Open  ]],

Cell["and:", "SolvedExampleNote",
 CellID->33856802,ExpressionUUID->"4f21e1b2-859c-4a8a-9939-ea70fbd1968c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "z"], "+", 
     FractionBox["1", 
      RowBox[{"z", "-", "3"}]]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], "]"}], "+", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "z"], "+", 
     FractionBox["1", 
      RowBox[{"z", "-", "3"}]]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->430701616,ExpressionUUID->"10ae29e4-8386-4af4-a66d-827678e12811"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->106938539,ExpressionUUID->"f5e5ae3f-231c-4ea0-a1bc-9b5df010d41c"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"159747a8-43a7-40cb-ac82-720f45305e16"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->461271504,ExpressionUUID->"b3fb8c7d-2940-4ee5-9a34-0694cdd56375"],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", 
       RowBox[{
        RowBox[{"|", "z", "|"}], "=", "4"}]}]], 
     RowBox[{
      FractionBox["z", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "5"}]], 
     RowBox[{
      FractionBox["z", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"4d72f079-b5c4-8443-a5f7-e16dac347224"],
 " and explain why this is the case."
}], "SolvedExampleNote",
 CellID->577820613,ExpressionUUID->"8519380c-d192-2549-97eb-abe2b36c12e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
        "RGBColorSwatchTemplate"], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}]}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"Orange", ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "8"}], ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "SolvedExampleInput",
 CellID->244080349,ExpressionUUID->"a6e4a00f-b93e-4d8d-b353-2828871b55ae"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], ArrowBox[CircleBox[{0, 0}, 4]]}, 
   {RGBColor[1, 0.5, 0], ArrowBox[CircleBox[{0, 0}, 5]]}, 
   {RGBColor[1, 0, 0], PointBox[{{-1, 0}, {1, 0}}]}},
  Axes->True,
  AxesStyle->Directive[12],
  ImageSize->200,
  PlotRange->{{-8, 8}, {-8, 8}}]], "SolvedExampleOutput",
 CellID->180340213,ExpressionUUID->"d9fa0ce3-9802-4d35-8934-5ac24782f02e"]
}, {2}]],

Cell[TextData[{
 "With ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->11335950,ExpressionUUID->"d0bafddc-79ca-4789-824a-752497836359"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox["z", 
     RowBox[{
      SuperscriptBox["z", "2"], "-", "1"}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}]}]}], "]"}], "==", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox["z", 
     RowBox[{
      SuperscriptBox["z", "2"], "-", "1"}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->772790942,ExpressionUUID->"e6c4f024-e6b9-4f0e-849b-7a1b647eb32a"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->22186740,ExpressionUUID->"3efb6ba5-0638-41bb-975f-da3a31c191c0"]
}, Open  ]],

Cell["\<\
The reason is that the two closed contours can be deformed into each other \
without crossing any singularity of the integrand:\
\>", "SolvedExampleNote",
 CellID->208987786,ExpressionUUID->"48e1a1bf-266e-4693-b937-b7f942c18830"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionAnalytic", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["z", 
      RowBox[{
       SuperscriptBox["z", "2"], "-", "1"}]], ",", 
     RowBox[{"4", "<=", 
      RowBox[{"Abs", "[", "z", "]"}], "<=", "5"}]}], "}"}], ",", "z", ",", 
   "Complexes"}], "]"}]], "SolvedExampleInput",
 CellID->264396447,ExpressionUUID->"699d0c59-01c8-4385-93cc-2b4bb5937753"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->235727786,ExpressionUUID->"b273d70d-a10b-40e2-9933-3b032eb7a88d"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->80449110,ExpressionUUID->"356b9146-3e5f-4a0a-b042-d9471699f5ef"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->147732145,ExpressionUUID->"2d2732df-d075-4bd0-a08f-03a658225aac"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "3"}]}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "3"], "+", 
       RowBox[{"2", "z"}]}], 
      RowBox[{
       SuperscriptBox["z", "5"], "-", 
       SuperscriptBox["z", "3"]}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ae0cdb5e-c3c6-3d4b-9f2a-29e0d7ee2b0d"],
 "."
}], "SolvedExampleNote",
 CellID->41562701,ExpressionUUID->"f2eb6511-5972-6646-963e-b6ed8870f905"],

Cell[TextData[{
 "Considering the integral instead over a circle of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d29edb47-694b-456b-ae10-501bcfdfd42a"],
 ", it must be bounded in absolute value by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "R"}], ")"}], "\[CenterDot]", 
    
    FractionBox[
     RowBox[{
      SuperscriptBox["R", "3"], "+", 
      RowBox[{"2", "R"}]}], 
     RowBox[{
      SuperscriptBox["R", "5"], "-", 
      SuperscriptBox["R", "3"]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"14fea2e8-a9ac-48f3-9ff8-bc97a90f4f8d"],
 ", which goes to zero as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"de0bacc2-0007-4548-98bf-af9780c745dd"],
 ". But the contour ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "z", "|"}], "=", "3"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6c6c9df1-5bfc-41ba-bed4-7d23bd4169e6"],
 " can be enlarged into a circle of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "99163218-e35d-4c04-9079-be02c3abb9a2"],
 " without crossing any singularities, so the original integral must also be \
zero."
}], "SolvedExampleNote",
 CellID->366905541,ExpressionUUID->"565409b6-6c7a-4a58-9aaa-99932c56b4bc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
        "RGBColorSwatchTemplate"], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}]}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"Orange", ",", "Dashed", ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "6"}], "]"}]}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"R", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "SolvedExampleInput",
 CellID->523319097,ExpressionUUID->"2cf83352-10a9-476b-9661-54ed81aa57f6"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], ArrowBox[CircleBox[{0, 0}, 3]]}, 
   {RGBColor[1, 0.5, 0], Dashing[{Small, Small}], 
    ArrowBox[CircleBox[{0, 0}, 6]]}, 
   {RGBColor[1, 0, 0], PointBox[{{-1, 0}, {0, 0}, {1, 0}}]}, InsetBox[
    StyleBox["R",
     StripOnInput->False,
     FontSize->12], {0, 6}, NCache[
    ImageScaled[{Rational[-1, 2], 0}], ImageScaled[{-0.5, 0}]]]},
  Axes->True,
  AxesStyle->Directive[12],
  ImageSize->200,
  PlotRange->{{-10, 10}, {-10, 10}}]], "SolvedExampleOutput",
 CellID->239142201,ExpressionUUID->"3ed418f3-cf49-4114-9272-eb0d1936c0da"]
}, {2}]],

Cell[TextData[{
 "Checking with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->668390226,ExpressionUUID->"cd95d0dc-4735-4a1c-8c99-c5d13f23960f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "3"], "+", 
     RowBox[{"2", "z"}]}], 
    RowBox[{
     SuperscriptBox["z", "5"], "-", 
     SuperscriptBox["z", "3"]}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->143071516,ExpressionUUID->"6a93d025-a927-48dc-8a6b-a40a330155bf"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->92322677,ExpressionUUID->"077c6d6a-0a0b-4d70-9f95-793c6cb17135"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->534620468,ExpressionUUID->"61ce0375-ba02-4479-aa3a-52f8ca1ce4f1"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->37597735,ExpressionUUID->"b69e7628-d94b-4432-8873-176a8e1aa04c"],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", 
       SubscriptBox["C", "1"]}]], 
     RowBox[{
      FractionBox["1", "z"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", 
       SubscriptBox["C", "2"]}]], 
     RowBox[{
      FractionBox["1", "z"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5e7f56a3-2df7-4ed1-8ddd-87eedbb78ea8"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "63a28537-2456-4cde-a844-1b0a3fddd189"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "da7a5f55-767c-43fe-b2d3-a70e4df36465"],
 " are as in the figure."
}], "SolvedExampleNote",
 CellID->8275963,ExpressionUUID->"bbae5a22-3049-46e1-aa60-5f034419be6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "@", 
      RowBox[{"Circle", "[", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Arrow", "@", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"619a49d2-352c-4feb-a2b9-9ced243c0736\"]],\
ExpressionUUID->\"3d547f7e-dd75-4822-aa57-b5d265f86daf\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"4c115011-90d9-4a70-8935-bbcacd6ff29b\"]],\
ExpressionUUID->\"46663c4e-04aa-4d16-8c75-faaa94b9ba0e\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
    "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->650689364,ExpressionUUID->"c62a2cc3-d4b5-488b-8af1-48b77aa5d7f0"],

Cell[BoxData[
 GraphicsBox[{ArrowBox[CircleBox[{0, 0}]], 
   ArrowBox[CircleBox[{0, 0}, {2., 1.}]], InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {0.5, 0.6}, NCache[
    ImageScaled[{Rational[1, 2], Rational[1, 2]}], ImageScaled[{0.5, 0.5}]]], 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {1.5, 0.5}, NCache[
    ImageScaled[{Rational[1, 2], Rational[1, 2]}], ImageScaled[{0.5, 0.5}]]]},
  
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  LabelStyle->Directive[12],
  PlotRange->{{-3, 3}, {-2, 2}}]], "SolvedExampleOutput",
 CellID->108959339,ExpressionUUID->"d54307f6-682b-4e0c-8507-33285ecd36ec"]
}, {2}]],

Cell[TextData[{
 "Over the circle, the result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"d9d4a5b3-28c6-4722-aee9-20e6feb1ee78"],
 ". Over the ellipse:"
}], "SolvedExampleNote",
 CellID->318539521,ExpressionUUID->"54dfb94e-4c75-4a0a-98ab-d406f2e8b0b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox["1", "z"], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->3269787,ExpressionUUID->"62b84f64-9d9c-4bf8-b5e7-310aa87f95e5"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->36923265,ExpressionUUID->"1924d5d7-3b07-4425-8f59-1d45668b5681"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->274684662,ExpressionUUID->"26966e60-fcd8-4aee-ba8a-0443b9911040"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->177748023,ExpressionUUID->"bb6b6e43-4dca-4f35-8d75-ba7efab08987"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
       RowBox[{"2", " ", "z"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"z", "+", "1", "-", "\[ImaginaryI]"}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0f572ab5-22ae-4b85-ba27-f93026444cfd"],
 " by decomposing the integrand into partial fractions, where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "52b1c6bd-c0ae-46aa-b2a1-39a94d781519"],
 " is as in the figure."
}], "SolvedExampleNote",
 CellID->88068250,ExpressionUUID->"663dbab4-b594-4a72-b291-b8033aa7106a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], 
         RowBox[{"{", 
          RowBox[{"0.9", ",", "1.1"}], "}"}]}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"C", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"13", "/", "10"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "}"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->80263617,ExpressionUUID->"9fd29e56-ad7e-407f-8371-4e92e3242f08"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}, 2, NCache[{0, Pi}, {0, 3.141592653589793}]], 
   LineBox[{{2, 0}, {0, 0}, {-2, 0}}], 
   ArrowBox[NCache[{{2^Rational[1, 2], 2^Rational[1, 2]}, {
      1.2727922061357857`, 1.5556349186104048`}}, {{1.4142135623730951`, 
     1.4142135623730951`}, {1.2727922061357857`, 1.5556349186104048`}}]], 
   InsetBox[
    StyleBox["C",
     StripOnInput->False,
     FontSize->12], NCache[{Rational[13, 10], 1}, {1.3, 1}], NCache[
    ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
     ImageScaled[{0.5, 0.5}]]], 
   {RGBColor[1, 0, 0], PointBox[{{-1, 1}, {0, 1}}]}},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  LabelStyle->Directive[12],
  PlotRange->{{-3, 3}, {-1, 3}}]], "SolvedExampleOutput",
 CellID->18101161,ExpressionUUID->"426080a9-8e7d-4473-8dae-77ee4c58b5eb"]
}, {2}]],

Cell[TextData[{
 "The singularities of the integrand are marked in red. Decompose into \
partial fractions with ",
 ButtonBox["Apart",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->481201372,ExpressionUUID->"eeb7c15c-cd90-4ccb-997a-69eb661b2e11"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
    RowBox[{"2", " ", "z"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"z", "+", "1", "-", "\[ImaginaryI]"}], ")"}]}]], 
  "]"}]], "SolvedExampleInput",
 CellID->782391943,ExpressionUUID->"9f960821-cb52-42de-93b9-0f47414c3138"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["5", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}]]}], "+", 
  FractionBox["3", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "+", 
    "z"}]]}]], "SolvedExampleOutput",
 CellID->20036878,ExpressionUUID->"f77cb5b9-5c2d-4244-8ae5-ecee12e658c0"]
}, Open  ]],

Cell[TextData[{
 "The two terms contribute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], "+", 
     RowBox[{"3", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"-", "4"}], "\[Pi]", " ", "\[ImaginaryI]"}]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"9b3f996a-a053-4029-a309-a70d69f84b10"],
 " because the contour can be deformed similarly to Fig. 4 around the \
singularities ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "\[ImaginaryI]"}]}], ",", "\[ImaginaryI]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "88add094-5d65-462e-ad42-11c230d6ee67"],
 ". Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->14530282,ExpressionUUID->"fabaea5e-6361-411e-9141-1dbf9dd9fd15"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "5"}], "+", 
       RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], "-", 
     RowBox[{"2", " ", "z"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"z", "+", "1", "-", "\[ImaginaryI]"}], ")"}]}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->657809931,ExpressionUUID->"136afedf-3073-4d66-a338-da4a687820f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", 
  "\[Pi]"}]], "SolvedExampleOutput",
 CellID->1414272,ExpressionUUID->"a64b1573-c5b4-4538-b538-c95992b0ad22"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1332533226,ExpressionUUID->"542f4e79-8bf5-4ded-9bef-c631a3657647"],

Cell[TextData[{
 "You will see later a more systematic method of calculating integrals over \
closed contours using residue calculus (",
 ButtonBox["Chapter 24",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ")."
}], "Text",
 CellID->327821372,ExpressionUUID->"58c9d570-ca75-45da-9b0e-fbdc78c789ac"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"933b7484-fdf3-496b-8d2b-aaa4ef0cdcb7"],

Cell["You saw examples of how to deform an integration contour.", \
"SummaryList",
 CellID->47341551,ExpressionUUID->"2fcb9317-ac21-45d9-a69a-c63d71c6de86"],

Cell["\<\
A closed contour can be shrunk or enlarged, possibly into more than one \
contour, if the deformations never go outside the region of analyticity of \
the integrand.\
\>", "SummaryList",
 CellID->649301534,ExpressionUUID->"a920feaf-6d86-4b9a-b71e-a2e1293f6e38"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->441248674,ExpressionUUID->"fe5fdb10-6a53-49bb-8344-e17a1203544f"],

Cell[TextData[{
 "Show that, for a circle ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "92eb3a3c-d2d9-4a88-81db-b5390dbe51b2"],
 " of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "faa5ac7f-3710-4da3-99da-bddc4d8f2502"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"R", "->", "\[Infinity]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "2"], "+", "2"}], 
        RowBox[{
         SuperscriptBox["z", "4"], "-", "1"}]], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "0"}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"b40fba3d-bdcb-4e27-9ade-90289b761629"],
 ". Use this to prove that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "2"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], "+", "2"}], 
       RowBox[{
        SuperscriptBox["z", "4"], "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f8b57a8c-4a2a-44b3-992a-85ceb5a3816e"],
 "."
}], "Exercise",
 CellID->285356943,ExpressionUUID->"4b57213f-2346-47d6-8e95-aa99ebda487a"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"fd857f78-2857-4b8b-bbd7-80fd2b369bb5"],

Cell[TextData[{
 "The integral over a circle of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "02b00189-17ed-4ca2-af94-692719d21962"],
 " can be bounded in absolute value by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "R"}], ")"}], "\[CenterDot]", 
    FractionBox[
     SuperscriptBox["R", "2"], 
     RowBox[{
      SuperscriptBox["R", "4"], "-", "1"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2cc999ec-fb95-4049-9b2f-ae06d5dee63b"],
 ", which goes to zero as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a05c2a60-f4a1-4b6f-9e18-8d93e014598a"],
 ":"
}], "SolutionAnswer",
 CellID->8115547,ExpressionUUID->"e1ba2490-2904-45c0-a11d-19e695e5a01e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "R"}], ")"}], "*", 
    FractionBox[
     SuperscriptBox["R", "2"], 
     RowBox[{
      SuperscriptBox["R", "4"], "-", "1"}]]}], ",", 
   RowBox[{"R", "->", "Infinity"}]}], "]"}]], "ExerciseInput",
 CellID->633766449,ExpressionUUID->"c387222e-5e06-485a-b7be-a315f4d27f15"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->100978557,ExpressionUUID->"22e489b8-56d2-4d17-b57b-7b0fd5e024d4"]
}, Open  ]],

Cell[TextData[{
 "Because the circle ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "z", "|"}], "=", "2"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"50ccc2b9-845e-4268-b8d0-c5cb263dd195"],
 " can be enlarged without crossing any singularities, the second integral \
follows. Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->4007311,ExpressionUUID->"c4f5513e-412d-410b-803a-ef2abfc2adb7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "+", "2"}], 
    RowBox[{
     SuperscriptBox["z", "4"], "-", "1"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->645057320,ExpressionUUID->"ba3bc345-9804-4238-9fd2-8bd86b85979b"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->213537294,ExpressionUUID->"da294cba-ad83-4bb3-bcb8-20a9204962ad"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "10"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["z", "2"]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b107429e-3ad1-4758-8bd3-5e0a88c7256c"],
 " by decomposing the integrand into partial fractions and deforming the \
contour."
}], "Exercise",
 CellID->666092767,ExpressionUUID->"c57098e9-9444-4fdc-baf3-e9d81468d889"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"79733c5d-6fd8-4451-8c36-9198d5863428"],

Cell[TextData[{
 "Use ",
 ButtonBox["Apart",
  BaseStyle->"Link"],
 " to decompose the integrand into partial fractions:"
}], "SolutionAnswer",
 CellID->78595550,ExpressionUUID->"e8f04256-b696-4c39-9531-e78a4d31096f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", "\[ImaginaryI]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", "+", 
       RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "2"]}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", "z", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}], ")"}]}]], 
  "]"}]], "ExerciseInput",
 CellID->295143761,ExpressionUUID->"ab4077e9-0e7a-4d8b-a392-217ce3d9f500"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "z"}]], "+", 
  FractionBox["1", "z"], "+", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}]]}]], "ExerciseOutput",
 CellID->75342763,ExpressionUUID->"319f1823-6b5f-499f-85ab-cb9d55c6e316"]
}, Open  ]],

Cell[TextData[{
 "The integral is not analytic at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", "2", ",", "\[ImaginaryI]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "88b2118b-cefb-4828-9dd6-6fe16a17dd1b"],
 ", all of which are inside the contour. By deforming the contour to three \
circles, each enclosing one of the singular points, and recalling the \
integral of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", "a"}], ")"}], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5945d32f-a4f9-4654-b86c-4d9951fc2ad4"],
 ", you should conclude that the result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"6", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "e72ac178-4dee-433c-a705-0b5e9fe7a2d1"],
 ". Check with ContourIntegrate:"
}], "SolutionAnswer",
 CellID->390477475,ExpressionUUID->"f34a8d17-ee5b-4f17-97d6-87234d59ca78"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "\[ImaginaryI]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", "z"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", "z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}], ")"}]}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "10"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->559614875,ExpressionUUID->"36404abc-2cdc-4350-9eca-25f2ddae425f"],

Cell[BoxData[
 RowBox[{"6", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->467255952,ExpressionUUID->"700ea48d-2c5b-4155-a43b-5e1a1be912b8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{"z", "-", "1"}], "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bfa6f5bc-ea67-44c8-9150-cd5e3fb93916"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2091e5a9-8c86-40bf-bfb8-53f139a6995c"],
 " is the ellipse here:"
}], "Exercise",
 CellID->621220330,ExpressionUUID->"d0f0cf7b-bf32-4341-8445-cad59fe0aff6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Arrow", "@", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "ExerciseInput",
 CellID->8869834,ExpressionUUID->"6628f4bf-4390-48ab-b6a1-cce4eab177f8"],

Cell[BoxData[
 GraphicsBox[ArrowBox[CircleBox[{0, 0}, {2., 1.}]],
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  ImageSize->200,
  LabelStyle->Directive[12],
  PlotRange->{{-3, 3}, {-2, 2}}]], "ExerciseOutput",
 CellID->65464456,ExpressionUUID->"29e09ae8-8632-4bfa-8483-b8bd99ac95bb"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"05c2bf8e-9e7f-4b80-904d-82e4dc6a0e97"],

Cell[TextData[{
 "Use ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 " to find the answer:"
}], "SolutionAnswer",
 CellID->295816084,ExpressionUUID->"7b3ae13e-6371-49bb-b428-8f9fba7ae9e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "-", "1"}], "z"], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}]}], "]"}]], "ExerciseInput",
 CellID->218118459,ExpressionUUID->"09c12d14-c7c8-485a-a44d-3f30933af722"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",\

 CellID->788111631,ExpressionUUID->"7e8bf368-0533-42aa-9a51-52de55175b6b"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "5"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"z", "-", "2"}]], "-", 
       FractionBox["3", 
        RowBox[{"z", "+", "\[ImaginaryI]"}]]}], ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ad931556-6b3d-4d4a-b428-0ff0f8d0b0ab"],
 ". "
}], "Exercise",
 CellID->142282403,ExpressionUUID->"20a4ff2f-b5e0-4af1-895c-6ccf415f2b02"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"0de4463d-484d-4333-93cf-5028ed3d200b"],

Cell[TextData[{
 ButtonBox["The contour can be deformed into two small circles around ",
  BaseStyle->"Link"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "2"}], ",", 
    RowBox[{"-", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0dffba66-1f8a-41c0-aab1-1598978e9068"],
 ButtonBox[". Each of the two summands contributes only to one of the two \
integrals. So the result is ",
  BaseStyle->"Link"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], "-", 
     RowBox[{"3", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{"-", "4"}], "\[Pi]", " ", "\[ImaginaryI]"}]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"94918c3a-0268-4e8b-8fde-7b2210dbe92a"],
 ButtonBox[". With ContourIntegrate:",
  BaseStyle->"Link"]
}], "SolutionAnswer",
 CellID->9815061,ExpressionUUID->"1c227fba-e43d-4dea-8b68-f714abd9c452"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "-", "2"}]], "-", 
    FractionBox["3", 
     RowBox[{"z", "+", "\[ImaginaryI]"}]]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->280985232,ExpressionUUID->"7df4837f-4737-4ddb-8972-340cee1b27a7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",\

 CellID->269065024,ExpressionUUID->"eefcbf48-c14e-43f9-bae9-a31c9d028b4a"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "2"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], "-", "z", "+", "1"}], 
      RowBox[{
       SuperscriptBox["z", "4"], "+", 
       SuperscriptBox["z", "3"]}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0c8e7c32-e52e-472b-b1a4-a07ae319f9da"],
 "."
}], "Exercise",
 CellID->118956291,ExpressionUUID->"30f7a6dc-e608-450b-bc06-24299de6b018"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"af912f5b-09d4-4a60-a573-e78f90870772"],

Cell[TextData[{
 "Deform the contour to a large circle of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "71be3cae-554b-495b-9361-15fc72acfc48"],
 ". The result can be bounded in absolute value by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "R"}], ")"}], "\[CenterDot]", 
    FractionBox[
     SuperscriptBox["R", "2"], 
     RowBox[{
      SuperscriptBox["R", "4"], "-", 
      SuperscriptBox["R", "3"]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5b829669-2812-4a2d-a2c7-7cd91abb1f5c"],
 ", which is zero as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dd5b713e-755b-4be1-914f-4d1f54d9d610"],
 ". Confirm using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->123504017,ExpressionUUID->"8a9577d3-46ff-4353-9758-e4e4592e65c5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "z", "+", "1"}], 
    RowBox[{
     SuperscriptBox["z", "4"], "+", 
     SuperscriptBox["z", "3"]}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->118007309,ExpressionUUID->"afc983bd-bf88-4977-8c60-ad7880ee746a"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->34905578,ExpressionUUID->"231ca187-1358-409a-9ab8-ba1999e47c59"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->387548075,ExpressionUUID->"dadadb1d-e58b-4e44-a808-e2395ac4032b"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"14. Applications of Cauchy\[CloseCurlyQuote]s Theorem | \
Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "13. Cauchy\[CloseCurlyQuote]s Theorem"}, "PrettyTooltipTemplate"], 
      "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "15. Cauchy\[CloseCurlyQuote]s Integral Formula"}, 
        "PrettyTooltipTemplate"], "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"66760895-7b82-4f8b-9b09-537517feb9e5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[666, 24, 256, 7, 108, "Section",ExpressionUUID->"91ec148e-6196-427c-bf8b-f4bc82ee23ad",
 CounterAssignments->{{"Section", 13}},
 CellID->129221763],
Cell[925, 33, 1180, 31, 62, "Text",ExpressionUUID->"b7616f95-6757-49a1-8ac5-993c905a0bdf",
 CellID->833569938],
Cell[2108, 66, 279, 5, 60, "Text",ExpressionUUID->"def0ddda-571f-5048-bcc7-849b98a504e3",
 CellID->297126330],
Cell[2390, 73, 481, 14, 40, "Text",ExpressionUUID->"a9901b95-e376-4571-bb69-442a1224d558",
 CellID->21285915],
Cell[2874, 89, 1701, 42, 154, "Text",ExpressionUUID->"e76f67eb-3055-8549-83a9-384fa0c200b3",
 CellID->8260647],
Cell[4578, 133, 2343, 73, 115, "DisplayFormula",ExpressionUUID->"c7df7b3e-69a0-4f8c-9c88-1e2fbdf6b43b",
 CellID->382570416],
Cell[6924, 208, 427, 11, 60, "Text",ExpressionUUID->"97eeb03b-8930-4e5e-8df9-249f8b1f30bc",
 CellID->185546139],
Cell[CellGroupData[{
Cell[7376, 223, 12908, 316, 756, "Input",ExpressionUUID->"b9008107-0cab-4275-b6cc-45357e60bc96",
 CellID->187504106],
Cell[20287, 541, 6856, 163, 203, "Output",ExpressionUUID->"19db85bf-725e-4601-924c-8f1ce4a6dfb2",
 CellID->1097253012]
}, {2}]],
Cell[27155, 707, 883, 28, 42, "Text",ExpressionUUID->"59caea3b-52e7-4a92-921a-be1cf894ce0e",
 CellID->393627039],
Cell[28041, 737, 4751, 136, 217, "Text",ExpressionUUID->"c89efebf-8fca-464e-bbba-3e1144dff972",
 CellID->187009770],
Cell[CellGroupData[{
Cell[32817, 877, 8937, 218, 70, "Input",ExpressionUUID->"1fd76736-c843-42db-b85c-6e3d7266a312",
 CellID->789919316],
Cell[41757, 1097, 13154, 281, 293, "Output",ExpressionUUID->"3607a9a2-171e-4495-be5a-448d559054a1",
 CellID->282170156]
}, {2}]],
Cell[54923, 1381, 192, 6, 36, "Text",ExpressionUUID->"07e0950c-f3ce-4231-b664-d53431ab5bc8",
 CellID->834091415],
Cell[CellGroupData[{
Cell[55140, 1391, 475, 15, 51, "Input",ExpressionUUID->"83385ebf-a785-41ec-9d90-d8ec3d5a3975",
 CellID->189350834],
Cell[55618, 1408, 103, 1, 36, "Output",ExpressionUUID->"d0254cec-050c-4f9b-ad90-a2d206a72224",
 CellID->394085046]
}, Open  ]],
Cell[55736, 1412, 316, 5, 83, "Text",ExpressionUUID->"b6bc2780-a308-48dc-9c6b-d3263dfda0a0",
 CellID->450975194],
Cell[56055, 1419, 741, 18, 83, "Text",ExpressionUUID->"3d41c076-6fa5-47f7-aeda-9ec6abad2ea6",
 CellID->40865661],
Cell[CellGroupData[{
Cell[56821, 1441, 18334, 436, 70, "Input",ExpressionUUID->"a6818e93-4d74-49f9-8fdd-43f076943351",
 CellID->140283603],
Cell[75158, 1879, 7592, 191, 219, "Output",ExpressionUUID->"02d4ca77-dc7c-480e-b40d-5f85a7560ff3",
 CellID->2131887395]
}, {2}]],
Cell[82762, 2073, 187, 8, 71, "SolvedExample",ExpressionUUID->"c2c62b1c-161e-4b21-901e-8386163a8a52",
 CellID->202305252],
Cell[82952, 2083, 607, 19, 43, "SolvedExampleNote",ExpressionUUID->"a28e74c8-1ea5-644c-a078-be8c040f8241",
 CellID->758441683],
Cell[83562, 2104, 1671, 47, 86, "SolvedExampleNote",ExpressionUUID->"e793c154-a0f1-4121-98ba-544536c21bee",
 CellID->805348312],
Cell[CellGroupData[{
Cell[85258, 2155, 7771, 190, 70, "SolvedExampleInput",ExpressionUUID->"3a4bca9f-5870-4874-9201-e42932aeb49c",
 CellID->539812757],
Cell[93032, 2347, 3565, 94, 193, "SolvedExampleOutput",ExpressionUUID->"70e89134-0187-4f9c-822d-4348c883b031",
 CellID->283030473]
}, {2}]],
Cell[96609, 2444, 189, 6, 39, "SolvedExampleNote",ExpressionUUID->"dc753f99-64f1-461c-b9f6-6a333f598ca5",
 CellID->314865864],
Cell[CellGroupData[{
Cell[96823, 2454, 427, 13, 47, "SolvedExampleInput",ExpressionUUID->"93c07494-f93b-472a-9c66-37e27bece054",
 CellID->53701562],
Cell[97253, 2469, 164, 2, 36, "SolvedExampleOutput",ExpressionUUID->"12aad69e-107b-4113-b046-85541f51df77",
 CellID->377012568]
}, Open  ]],
Cell[97432, 2474, 107, 1, 39, "SolvedExampleNote",ExpressionUUID->"4f21e1b2-859c-4a8a-9939-ea70fbd1968c",
 CellID->33856802],
Cell[CellGroupData[{
Cell[97564, 2479, 783, 25, 94, "SolvedExampleInput",ExpressionUUID->"10ae29e4-8386-4af4-a66d-827678e12811",
 CellID->430701616],
Cell[98350, 2506, 164, 2, 36, "SolvedExampleOutput",ExpressionUUID->"f5e5ae3f-231c-4ea0-a1bc-9b5df010d41c",
 CellID->106938539]
}, Open  ]],
Cell[98529, 2511, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"159747a8-43a7-40cb-ac82-720f45305e16",
 CellID->943814759],
Cell[98638, 2514, 187, 8, 71, "SolvedExample",ExpressionUUID->"b3fb8c7d-2940-4ee5-9a34-0694cdd56375",
 CellID->461271504],
Cell[98828, 2524, 866, 27, 44, "SolvedExampleNote",ExpressionUUID->"8519380c-d192-2549-97eb-abe2b36c12e1",
 CellID->577820613],
Cell[CellGroupData[{
Cell[99719, 2555, 1502, 46, 70, "SolvedExampleInput",ExpressionUUID->"a6e4a00f-b93e-4d8d-b353-2828871b55ae",
 CellID->244080349],
Cell[101224, 2603, 412, 9, 221, "SolvedExampleOutput",ExpressionUUID->"d9fa0ce3-9802-4d35-8934-5ac24782f02e",
 CellID->180340213]
}, {2}]],
Cell[101648, 2615, 182, 6, 39, "SolvedExampleNote",ExpressionUUID->"d0bafddc-79ca-4789-824a-752497836359",
 CellID->11335950],
Cell[CellGroupData[{
Cell[101855, 2625, 738, 23, 91, "SolvedExampleInput",ExpressionUUID->"e6c4f024-e6b9-4f0e-849b-7a1b647eb32a",
 CellID->772790942],
Cell[102596, 2650, 118, 1, 36, "SolvedExampleOutput",ExpressionUUID->"3efb6ba5-0638-41bb-975f-da3a31c191c0",
 CellID->22186740]
}, Open  ]],
Cell[102729, 2654, 239, 4, 61, "SolvedExampleNote",ExpressionUUID->"48e1a1bf-266e-4693-b937-b7f942c18830",
 CellID->208987786],
Cell[CellGroupData[{
Cell[102993, 2662, 403, 11, 46, "SolvedExampleInput",ExpressionUUID->"699d0c59-01c8-4385-93cc-2b4bb5937753",
 CellID->264396447],
Cell[103399, 2675, 119, 1, 36, "SolvedExampleOutput",ExpressionUUID->"b273d70d-a10b-40e2-9933-3b032eb7a88d",
 CellID->235727786]
}, Open  ]],
Cell[103533, 2679, 105, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"356b9146-3e5f-4a0a-b042-d9471699f5ef",
 CellID->80449110],
Cell[103641, 2682, 187, 8, 71, "SolvedExample",ExpressionUUID->"2d2732df-d075-4bd0-a08f-03a658225aac",
 CellID->147732145],
Cell[103831, 2692, 645, 21, 45, "SolvedExampleNote",ExpressionUUID->"f2eb6511-5972-6646-963e-b6ed8870f905",
 CellID->41562701],
Cell[104479, 2715, 1399, 38, 89, "SolvedExampleNote",ExpressionUUID->"565409b6-6c7a-4a58-9aaa-99932c56b4bc",
 CellID->366905541],
Cell[CellGroupData[{
Cell[105903, 2757, 1906, 58, 70, "SolvedExampleInput",ExpressionUUID->"2cf83352-10a9-476b-9661-54ed81aa57f6",
 CellID->523319097],
Cell[107812, 2817, 609, 14, 217, "SolvedExampleOutput",ExpressionUUID->"3ed418f3-cf49-4114-9272-eb0d1936c0da",
 CellID->239142201]
}, {2}]],
Cell[108433, 2834, 192, 6, 39, "SolvedExampleNote",ExpressionUUID->"cd95d0dc-4735-4a1c-8c99-c5d13f23960f",
 CellID->668390226],
Cell[CellGroupData[{
Cell[108650, 2844, 506, 16, 51, "SolvedExampleInput",ExpressionUUID->"6a93d025-a927-48dc-8a6b-a40a330155bf",
 CellID->143071516],
Cell[109159, 2862, 115, 1, 36, "SolvedExampleOutput",ExpressionUUID->"077c6d6a-0a0b-4d70-9f95-793c6cb17135",
 CellID->92322677]
}, Open  ]],
Cell[109289, 2866, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"61ce0375-ba02-4479-aa3a-52f8ca1ce4f1",
 CellID->534620468],
Cell[109398, 2869, 186, 8, 71, "SolvedExample",ExpressionUUID->"b69e7628-d94b-4432-8873-176a8e1aa04c",
 CellID->37597735],
Cell[109587, 2879, 1023, 32, 43, "SolvedExampleNote",ExpressionUUID->"bbae5a22-3049-46e1-aa60-5f034419be6b",
 CellID->8275963],
Cell[CellGroupData[{
Cell[110635, 2915, 2170, 59, 70, "SolvedExampleInput",ExpressionUUID->"c62a2cc3-d4b5-488b-8af1-48b77aa5d7f0",
 CellID->650689364],
Cell[112808, 2976, 1034, 24, 177, "SolvedExampleOutput",ExpressionUUID->"d54307f6-682b-4e0c-8507-33285ecd36ec",
 CellID->108959339]
}, {2}]],
Cell[113854, 3003, 341, 8, 39, "SolvedExampleNote",ExpressionUUID->"54dfb94e-4c75-4a0a-98ab-d406f2e8b0b0",
 CellID->318539521],
Cell[CellGroupData[{
Cell[114220, 3015, 407, 12, 47, "SolvedExampleInput",ExpressionUUID->"62b84f64-9d9c-4bf8-b5e7-310aa87f95e5",
 CellID->3269787],
Cell[114630, 3029, 163, 2, 36, "SolvedExampleOutput",ExpressionUUID->"1924d5d7-3b07-4425-8f59-1d45668b5681",
 CellID->36923265]
}, Open  ]],
Cell[114808, 3034, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"26966e60-fcd8-4aee-ba8a-0443b9911040",
 CellID->274684662],
Cell[114917, 3037, 187, 8, 71, "SolvedExample",ExpressionUUID->"bb6b6e43-4dca-4f35-8d75-ba7efab08987",
 CellID->177748023],
Cell[115107, 3047, 989, 28, 66, "SolvedExampleNote",ExpressionUUID->"663dbab4-b594-4a72-b291-b8033aa7106a",
 CellID->88068250],
Cell[CellGroupData[{
Cell[116121, 3079, 2317, 72, 70, "SolvedExampleInput",ExpressionUUID->"9fd29e56-ad7e-407f-8371-4e92e3242f08",
 CellID->80263617],
Cell[118441, 3153, 957, 22, 177, "SolvedExampleOutput",ExpressionUUID->"426080a9-8e7d-4473-8dae-77ee4c58b5eb",
 CellID->18101161]
}, {2}]],
Cell[119410, 3178, 261, 7, 61, "SolvedExampleNote",ExpressionUUID->"eeb7c15c-cd90-4ccb-997a-69eb661b2e11",
 CellID->481201372],
Cell[CellGroupData[{
Cell[119696, 3189, 491, 15, 50, "SolvedExampleInput",ExpressionUUID->"9f960821-cb52-42de-93b9-0f47414c3138",
 CellID->782391943],
Cell[120190, 3206, 348, 11, 57, "SolvedExampleOutput",ExpressionUUID->"f77cb5b9-5c2d-4244-8ae5-ecee12e658c0",
 CellID->20036878]
}, Open  ]],
Cell[120553, 3220, 1010, 31, 61, "SolvedExampleNote",ExpressionUUID->"fabaea5e-6361-411e-9141-1dbf9dd9fd15",
 CellID->14530282],
Cell[CellGroupData[{
Cell[121588, 3255, 753, 23, 50, "SolvedExampleInput",ExpressionUUID->"136afedf-3073-4d66-a338-da4a687820f4",
 CellID->657809931],
Cell[122344, 3280, 183, 4, 36, "SolvedExampleOutput",ExpressionUUID->"a64b1573-c5b4-4538-b538-c95992b0ad22",
 CellID->1414272]
}, Open  ]],
Cell[122542, 3287, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"542f4e79-8bf5-4ded-9bef-c631a3657647",
 CellID->1332533226],
Cell[122652, 3290, 434, 11, 60, "Text",ExpressionUUID->"58c9d570-ca75-45da-9b0e-fbdc78c789ac",
 CellID->327821372],
Cell[CellGroupData[{
Cell[123111, 3305, 109, 1, 69, "SummarySection",ExpressionUUID->"933b7484-fdf3-496b-8d2b-aaa4ef0cdcb7",
 CellID->1198545324],
Cell[123223, 3308, 156, 2, 29, "SummaryList",ExpressionUUID->"2fcb9317-ac21-45d9-a69a-c63d71c6de86",
 CellID->47341551],
Cell[123382, 3312, 271, 5, 52, "SummaryList",ExpressionUUID->"a920feaf-6d86-4b9a-b71e-a2e1293f6e38",
 CellID->649301534]
}, Open  ]],
Cell[CellGroupData[{
Cell[123690, 3322, 160, 3, 65, "ExerciseSection",ExpressionUUID->"fe5fdb10-6a53-49bb-8344-e17a1203544f",
 CellID->441248674],
Cell[123853, 3327, 1386, 44, 36, "Exercise",ExpressionUUID->"4b57213f-2346-47d6-8e95-aa99ebda487a",
 CellID->285356943],
Cell[CellGroupData[{
Cell[125264, 3375, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"fd857f78-2857-4b8b-bbd7-80fd2b369bb5"],
Cell[125358, 3377, 828, 23, 49, "SolutionAnswer",ExpressionUUID->"e1ba2490-2904-45c0-a11d-19e695e5a01e",
 CellID->8115547],
Cell[CellGroupData[{
Cell[126211, 3404, 384, 11, 49, "ExerciseInput",ExpressionUUID->"c387222e-5e06-485a-b7be-a315f4d27f15",
 CellID->633766449],
Cell[126598, 3417, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"22e489b8-56d2-4d17-b57b-7b0fd5e024d4",
 CellID->100978557]
}, Open  ]],
Cell[126724, 3421, 463, 13, 43, "SolutionAnswer",ExpressionUUID->"c4f5513e-412d-410b-803a-ef2abfc2adb7",
 CellID->4007311],
Cell[CellGroupData[{
Cell[127212, 3438, 453, 14, 49, "ExerciseInput",ExpressionUUID->"ba3bc345-9804-4238-9fd2-8bd86b85979b",
 CellID->645057320],
Cell[127668, 3454, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"da294cba-ad83-4bb3-bcb8-20a9204962ad",
 CellID->213537294]
}, Open  ]]
}, Closed]],
Cell[127806, 3459, 993, 30, 33, "Exercise",ExpressionUUID->"c57098e9-9444-4fdc-baf3-e9d81468d889",
 CellID->666092767],
Cell[CellGroupData[{
Cell[128824, 3493, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"79733c5d-6fd8-4451-8c36-9198d5863428"],
Cell[128918, 3495, 217, 6, 22, "SolutionAnswer",ExpressionUUID->"e8f04256-b696-4c39-9531-e78a4d31096f",
 CellID->78595550],
Cell[CellGroupData[{
Cell[129160, 3505, 598, 19, 51, "ExerciseInput",ExpressionUUID->"ab4077e9-0e7a-4d8b-a392-217ce3d9f500",
 CellID->295143761],
Cell[129761, 3526, 305, 9, 44, "ExerciseOutput",ExpressionUUID->"319f1823-6b5f-499f-85ab-cb9d55c6e316",
 CellID->75342763]
}, Open  ]],
Cell[130081, 3538, 995, 26, 64, "SolutionAnswer",ExpressionUUID->"f34a8d17-ee5b-4f17-97d6-87234d59ca78",
 CellID->390477475],
Cell[CellGroupData[{
Cell[131101, 3568, 798, 25, 51, "ExerciseInput",ExpressionUUID->"36404abc-2cdc-4350-9eca-25f2ddae425f",
 CellID->559614875],
Cell[131902, 3595, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"700ea48d-2c5b-4155-a43b-5e1a1be912b8",
 CellID->467255952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[132110, 3603, 562, 17, 29, "Exercise",ExpressionUUID->"d0f0cf7b-bf32-4341-8445-cad59fe0aff6",
 CellID->621220330],
Cell[CellGroupData[{
Cell[132697, 3624, 993, 29, 70, "ExerciseInput",ExpressionUUID->"6628f4bf-4390-48ab-b6a1-cce4eab177f8",
 CellID->8869834],
Cell[133693, 3655, 430, 12, 144, "ExerciseOutput",ExpressionUUID->"29e09ae8-8632-4bfa-8483-b8bd99ac95bb",
 CellID->65464456]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[134169, 3673, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"05c2bf8e-9e7f-4b80-904d-82e4dc6a0e97"],
Cell[134263, 3675, 198, 6, 22, "SolutionAnswer",ExpressionUUID->"7b3ae13e-6371-49bb-b428-8f9fba7ae9e4",
 CellID->295816084],
Cell[CellGroupData[{
Cell[134486, 3685, 426, 12, 45, "ExerciseInput",ExpressionUUID->"09c12d14-c7c8-485a-a44d-3f30933af722",
 CellID->218118459],
Cell[134915, 3699, 179, 4, 28, "ExerciseOutput",ExpressionUUID->"7e8bf368-0533-42aa-9a51-52de55175b6b",
 CellID->788111631]
}, Open  ]]
}, Closed]],
Cell[135121, 3707, 599, 19, 29, "Exercise",ExpressionUUID->"20a4ff2f-b5e0-4af1-895c-6ccf415f2b02",
 CellID->142282403],
Cell[CellGroupData[{
Cell[135745, 3730, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"0de4463d-484d-4333-93cf-5028ed3d200b"],
Cell[135839, 3732, 979, 26, 43, "SolutionAnswer",ExpressionUUID->"1c227fba-e43d-4dea-8b68-f714abd9c452",
 CellID->9815061],
Cell[CellGroupData[{
Cell[136843, 3762, 461, 14, 46, "ExerciseInput",ExpressionUUID->"7df4837f-4737-4ddb-8972-340cee1b27a7",
 CellID->280985232],
Cell[137307, 3778, 179, 4, 28, "ExerciseOutput",ExpressionUUID->"eefcbf48-c14e-43f9-bae9-a31c9d028b4a",
 CellID->269065024]
}, Open  ]]
}, Closed]],
Cell[137513, 3786, 598, 19, 32, "Exercise",ExpressionUUID->"30f7a6dc-e608-450b-bc06-24299de6b018",
 CellID->118956291],
Cell[CellGroupData[{
Cell[138136, 3809, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"af912f5b-09d4-4a60-a573-e78f90870772"],
Cell[138230, 3811, 949, 27, 49, "SolutionAnswer",ExpressionUUID->"8a9577d3-46ff-4353-9758-e4e4592e65c5",
 CellID->123504017],
Cell[CellGroupData[{
Cell[139204, 3842, 490, 15, 49, "ExerciseInput",ExpressionUUID->"afc983bd-bf88-4977-8c60-ad7880ee746a",
 CellID->118007309],
Cell[139697, 3859, 110, 1, 28, "ExerciseOutput",ExpressionUUID->"231ca187-1358-409a-9ab8-ba1999e47c59",
 CellID->34905578]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],
Cell[139858, 3866, 309, 6, 135, "SmallText",ExpressionUUID->"dadadb1d-e58b-4e44-a808-e2395ac4032b",
 CellGroupingRules->"SectionGrouping",
 CellID->387548075]
}
]
*)

(* NotebookSignature ARcFx4Smkn38ojYRsGjowHIT *)
