(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    576507,      11531]
NotebookOptionsPosition[    422117,       8272]
NotebookOutlinePosition[    560524,      11223]
CellTagsIndexPosition[    560481,      11220]
WindowTitle->15. Cauchy\:2019s Integral Formula | Essentials of Complex \
Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Cauchy\[CloseCurlyQuote]s Integral Formula"
}], "Section",
 CounterAssignments->{{"Section", 14}},
 CellID->731141457,ExpressionUUID->"04343c3e-1859-441f-a192-52b2d5a49bf4"],

Cell["\<\
Cauchy\[CloseCurlyQuote]s integral formula is a crucial result in complex \
analysis. The formula has the surprising implication that the value of an \
analytic function inside a closed curve is completely determined by the \
values the function takes on the boundary. This has no counterpart in real \
analysis.\
\>", "Text",
 CellID->382294426,ExpressionUUID->"06da5be7-f314-4e01-bb17-1af2985851d1"],

Cell[TextData[{
 StyleBox["Cauchy\[CloseCurlyQuote]s integral formula",
  FontSlant->"Italic"],
 ":",
 " If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"545d2355-4b8c-4da7-b6b0-faf121311909"],
 " is analytic in a region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "78b7cf2b-491c-4012-957b-007ec8ea726d"],
 " containing a simple closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "58a1bd11-88cb-473e-ad80-c13a3304965a"],
 " and its interior, then"
}], "Text",
 CellID->127633416,ExpressionUUID->"a20ab71b-fb2e-44ba-ad60-3cb1e54925e6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    FrameBox[
     RowBox[{
      RowBox[{"f", 
       RowBox[{"(", "a", ")"}]}], "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
       RowBox[{
        SubscriptBox["\[ContourIntegral]", "C"], 
        RowBox[{
         FractionBox[
          RowBox[{"f", "(", "z", ")"}], 
          RowBox[{"z", "-", "a"}]], 
         RowBox[{
          RowBox[{"\[DifferentialD]", "z"}], "."}]}]}]}]}]],
    TraditionalForm], "                     ", Cell[
   "Cauchy\[CloseCurlyQuote]s Integral Formula.",ExpressionUUID->
    "0216717c-09da-401f-a8dc-fe8edb0b7f6b"]}], 
  TextForm]], "DisplayFormulaNumbered",
 CellID->416097994,ExpressionUUID->"e86ab3a0-18ae-428a-9061-9d7e27067d85"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "pts", ",", "pts2", ",", "a", ",", "aa", ",", "f", ",", "C", ",", "z"}], 
    "}"}], ",", 
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "2.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.9"}], ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.5"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.4"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "1.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1.9"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2.1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"pts2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", "1.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1", ",", "1.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.4"}], ",", "1.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9"}], ",", "1.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.3"}], ",", "0.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.7"}], ",", 
         RowBox[{"-", "0.4"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.3"}], ",", 
         RowBox[{"-", "0.9"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "0.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", 
         RowBox[{"-", "0.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6", ",", "0.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.8"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"aa", "=", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"pts", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "+", "aa"}], "&"}], "/@", "pts"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"pts2", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"#", "+", "aa"}], "&"}], "/@", "pts2"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Labeled", "[", 
     RowBox[{
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Plot", "[", 
           RowBox[{"Null", ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
            RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
            RowBox[{"AxesLabel", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", 
               RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "->", 
             RowBox[{"Directive", "[", "12", "]"}]}], ",", 
            RowBox[{"PlotRange", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", "6.5"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"Ticks", "->", "None"}]}], "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"LightBlue", ",", 
               RowBox[{"EdgeForm", "[", "White", "]"}], ",", 
               RowBox[{"FilledCurve", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"BSplineCurve", "[", 
                 RowBox[{"pts2", ",", 
                  RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"\
\[CapitalOmega]\", \
TraditionalForm]],ExpressionUUID->\"95dda100-d4c8-416b-839e-0e1ae751219c\"]],\
ExpressionUUID->\"ea45af22-d07a-4f4a-b95b-4c9976188028\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"aa", "+", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.5"}], ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
               RowBox[{"Point", "[", 
                RowBox[{"aa", "+", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"a\", \
TraditionalForm]],ExpressionUUID->\"05440902-d1f2-4f3d-a091-8e5962501a1d\"]],\
ExpressionUUID->\"916532e1-d307-471b-ab18-ace9bc9ad722\"]\)\>\"", ",", "12"}],
                 "]"}], ",", "aa", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"d10e86d9-6202-4e60-85b6-61f1cea952cc\"]],\
ExpressionUUID->\"df2504fa-de6a-45f6-a828-6e5e9cf0920e\"]\)\>\"", ",", "12"}],
                 "]"}], ",", 
               RowBox[{"pts2", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"-", "1.5"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"ImageSize", "->", "Small"}]}], "]"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Fig. 1. The closed contour \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"C", ",", "TraditionalForm"}], "]"}], 
        "<>", "\"\< inside a region \
\!\(\*Cell[\"\[CapitalOmega]\",ExpressionUUID->\"1326b520-8272-4200-9025-\
2b60f7fb1fd6\"]\) where \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"f", ",", "TraditionalForm"}], "]"}], 
        "<>", "\"\< is analytic.\nCauchy\[CloseCurlyQuote]s integral formula \
allows us to write \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{
          RowBox[{"f", "[", "a", "]"}], ",", "TraditionalForm"}], "]"}], 
        "<>", "\"\< as an integral over a path \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"C", ",", "TraditionalForm"}], "]"}], 
        "<>", "\"\< around \>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"a", ",", "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}], 
       "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.973000536175622*^9, 3.973000536956649*^9}},
 CellID->1438724859,ExpressionUUID->"4d3d20b9-f42c-490e-a1c7-e21c444eb6b8"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, {
        {RGBColor[0.87, 0.94, 1], EdgeForm[GrayLevel[1]], 
         FilledCurveBox[
          BSplineCurve[{{3, -1}, {4, -0.5}, {5, 0.5}, {5.2, 2}, {5, 4}, {
            4.5, 5}, {4, 5.5}, {3.5, 5}, {3, 5.1}, {2, 5.5}, {1, 5}, {1, 4}, {
            1.1, 3.5}, {0.5, 3}, {0, 2.3}, {0, 2}, {-0.3999999999999999, 1}, {
            0, 0.19999999999999996`}, {1, 0.10000000000000009`}, {
            2, -0.10000000000000009`}}, SplineClosed -> True]]}, 
        {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.01], Arrowheads[
         0.07], ArrowBox[
          BSplineCurveBox[{{3.5, 3.4}, {3.1, 3.7}, {2.6, 3.8}, {2.1, 3.3}, {
            2.7, 2.4}, {2.5, 2}, {2.3, 1.6}, {2.7, 1.1}, {3, 1.2}, {3.5, 
            1.5}, {3.8, 2}, {3.6, 2.3}, {4, 2.8}},
           SplineClosed->True]]}, InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"\
\[CapitalOmega]\\\", TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {0.5, 1}, NCache[
         ImageScaled[{0, Rational[1, 2]}], ImageScaled[{0, 0.5}]]], 
        {PointSize[Medium], PointBox[{3, 2}]}, InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"a\\\", \
TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {3, 2}, NCache[
         ImageScaled[{Rational[1, 2], -0.25}], ImageScaled[{0.5, -0.25}]]], 
        InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], {3.5, 3.4}, NCache[
         ImageScaled[{Rational[1, 2], -0.25}], ImageScaled[{0.5, -0.25}]]]}},
      Axes->{True, True},
      AxesLabel->{
        FormBox[
         TagBox[
          RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
        FormBox[
         TagBox[
          RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->Small,
      LabelStyle->Directive[12],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-1., 7.}, {-2., 6.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{}, {}}]},
    {"\<\"Fig. 1. The closed contour \\!\\(\\*FormBox[\\\"C\\\", \
TraditionalForm]\\) inside a region \\!\\(\\*Cell[\\\"\[CapitalOmega]\\\"]\\) \
where \\!\\(\\*FormBox[\\\"f\\\", TraditionalForm]\\) is analytic. Cauchy\
\[CloseCurlyQuote]s integral formula allows us to write \
\\!\\(\\*FormBox[RowBox[{\\\"f\\\", \\\"(\\\", \\\"a\\\", \\\")\\\"}], \
TraditionalForm]\\) as an integral over a path \\!\\(\\*FormBox[\\\"C\\\", \
TraditionalForm]\\) around \\!\\(\\*FormBox[\\\"a\\\", TraditionalForm]\\).\"\
\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1023569120,ExpressionUUID->"cfe20d6e-c69f-46d0-9ea7-bb48d3fe2911"]
}, {2}]],

Cell[TextData[{
 "If you know the function only on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c530a311-785c-4b2e-b520-a6ac6f5aebee"],
 ", and that it is analytic, that is enough information to compute it for any \
",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f6d5593f-8a99-4467-acc8-37df20b8f3b1"],
 " inside the curve. Notice how strongly constrained ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "827ff46f-47ea-479a-8706-c236a6c11470"],
 " is by the property of being analytic."
}], "Text",
 CellID->5769414,ExpressionUUID->"2ed5c27a-9ce3-41dc-9f7c-9b4f9312c33d"],

Cell[TextData[{
 "Proof:",
 " It suffices to show the formula for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "87e20cfc-dfd1-4e32-982b-43a5b4c16f91"],
 ", since it can then be recovered by a change of variables. So let\
\[CloseCurlyQuote]s prove ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "0", ")"}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", 
       RowBox[{"\[ThinSpace]", "C"}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "z", ")"}], "z"], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b674420c-d476-4e40-bc1c-18d6415dc07d"],
 " for a contour enclosing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "04c12e29-8ce9-4680-b3a0-da5cf2ae71cc"],
 ". Define the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], "-", 
      RowBox[{"f", "(", "0", ")"}]}], 
     RowBox[{"z", "-", "0"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e854c2fd-fa0c-4fb8-9852-f438e1db2b62"],
 ", which can be made continuous by defining ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "0", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "0", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8925fa17-3506-43ec-8df0-76098548f75e"],
 ", which exists and is bounded because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2fe4d58f-d61f-4461-903e-8238424b45c2"],
 " is analytic by hypothesis. Then:"
}], "Text",
 CellID->660764377,ExpressionUUID->"f427b7e2-5f17-40f4-a32a-2d0fba26d31d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{"f", "(", "z", ")"}], "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      RowBox[{"g", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
    RowBox[{
     RowBox[{"f", "(", "0", ")"}], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       FractionBox["1", "z"], 
       RowBox[{
        RowBox[{"\[DifferentialD]", "z"}], "."}]}]}]}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->23042944,ExpressionUUID->"7e9df5b0-899b-4145-928c-49766d0a19ae"],

Cell[TextData[{
 "The second integral on the right-hand side of the equation is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"acd393ad-f7c1-43c7-8047-8e90e65eb261"],
 ", as seen before. The first integral can be bounded by deforming the \
contour to a circle of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e82659af-0966-4cb9-b0a1-30c5806d57be"],
 " around the origin. Then:"
}], "Text",
 CellID->455256528,ExpressionUUID->"c820aa5e-5bbb-4422-b587-e347c5e84b08"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     RowBox[{"g", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "<=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "r"}], ")"}], "M"}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->306044062,ExpressionUUID->"c51fe9f0-9de9-4df6-908e-30a326cb625c"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a38780f0-83f0-4c1c-ae40-47b2b9f8f05d"],
 " is the maximum of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8c5bee97-023d-4584-abe8-785c7565d3cd"],
 " inside the circle. So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      RowBox[{"g", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"428d4e17-5e9f-474f-9a9f-ecbe7898126d"],
 ", since you can deform to smaller circles so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e9eaaf09-746a-4dda-b163-da1694ef8c55"],
 ". From this, one can conclude that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      FractionBox[
       RowBox[{"f", "(", "z", ")"}], "z"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     RowBox[{"f", "(", "0", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"add81cca-9c12-4a3b-aa4c-54c581fee119"],
 ", which proves Cauchy\[CloseCurlyQuote]s integral formula."
}], "Text",
 CellID->562277164,ExpressionUUID->"a8e0af70-9b43-4123-be31-a1aa11c4c1a9"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->117665326,ExpressionUUID->"012454b0-f40d-427e-840d-235c8220d56b"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"cos", " ", "z"}], 
      RowBox[{"z", "-", "\[Pi]"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5f439d72-b318-4d7b-9dc6-e8bf49bef726"],
 " for the path in the figure here."
}], "SolvedExampleNote",
 CellID->202291452,ExpressionUUID->"4536a4a7-c5df-424f-a517-7d8b0863bb69"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", ",", "pts2", ",", "z"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pts2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3.2", ",", "1.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5", ",", "2.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7", ",", "1.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4", ",", 
         RowBox[{"-", "0.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6", ",", 
         RowBox[{"-", "1.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8", ",", 
         RowBox[{"-", "2.3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.2", ",", 
         RowBox[{"-", "2.2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.6", ",", 
         RowBox[{"-", "1.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.1", ",", 
         RowBox[{"-", "0.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.7", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.3", ",", "0.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5", ",", "1.3"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
           "RGBColorSwatchTemplate"], ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
          RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"BSplineCurve", "[", 
            RowBox[{"pts2", ",", 
             RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], "}"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"\[Pi]", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           
           RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"\[Pi]\", \
TraditionalForm]],ExpressionUUID->\"e823d8ef-c66c-4d14-9ae9-243b87803a0a\"]],\
ExpressionUUID->\"896f6b8a-580a-44e9-8282-8f88fd42c56a\"]\)\>\"", ",", "12"}],
            "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Pi]", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           
           RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"d4158ee2-4086-4db6-94bc-65aa34af724f\"]],\
ExpressionUUID->\"455babe7-3a12-4da7-8fa5-d5e607be07e0\"]\)\>\"", ",", "12"}],
            "]"}], ",", 
          RowBox[{"pts2", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1.5"}]}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"Axes", "->", "True"}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "[", "z", "]"}], ",", 
         RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}], ",", 
      RowBox[{"ImageSize", "->", "Small"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "SolvedExampleInput",
 CellID->399180990,ExpressionUUID->"dea25f43-cfa7-44c7-8463-c5051c7f3d3e"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.01], Arrowheads[0.07],
     ArrowBox[
     BSplineCurveBox[{{3.2, 1.8}, {2.5, 2.3}, {1.7, 1.8}, {2, 0.8}, {
       1.6, 0}, {2.4, -0.8}, {2.6, -1.8}, {2.8, -2.3}, {4.2, -2.2}, {
       4.6, -1.5}, {4.9, -1}, {5.1, -0.5}, {4.7, 0}, {4.3, 0.7}, {4.5, 1.3}},
      SplineClosed->True]]}, 
   {PointSize[Medium], PointBox[NCache[{Pi, 0}, {3.141592653589793, 0}]]}, 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"\[Pi]\\\", \
TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{Pi, 0}, {3.141592653589793, 0}], NCache[
    ImageScaled[{Rational[1, 2], -0.25}], ImageScaled[{0.5, -0.25}]]], 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {3.2, 1.8}, NCache[
    ImageScaled[{Rational[1, 2], -0.25}], ImageScaled[{0.5, -0.25}]]]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  ImageSize->Small,
  LabelStyle->Directive[12],
  PlotRange->{{-1, 6}, {-3, 4}},
  Ticks->None]], "SolvedExampleOutput",
 CellID->277819275,ExpressionUUID->"01b05ed2-5d96-42f4-bd7b-52b9312c2bb5"]
}, {2}]],

Cell[TextData[{
 "Using Cauchy\[CloseCurlyQuote]s integral formula \
\[OpenCurlyDoubleQuote]right to left\[CloseCurlyDoubleQuote] with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"cos", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9b55e963-c307-440d-ba90-d676ea72e5b3"],
 ", the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", "\[InvisibleSpace]", 
     RowBox[{"cos", "(", "\[Pi]", ")"}]}], "=", 
    RowBox[{
     RowBox[{"-", "2"}], "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "92c856b5-5e7e-45b8-a770-df5751c547bd"],
 "."
}], "SolvedExampleNote",
 CellID->262963593,ExpressionUUID->"7c2f17ae-87c6-4856-a44a-dfeeba2ae470"],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"4f6f8733-096d-4626-958f-78e520473f22"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->48176556,ExpressionUUID->"d74e37fb-c6b3-4cf1-8391-540f3dcafc14"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"exp", " ", "z"}], 
      RowBox[{"z", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b0b4bf66-1a13-4776-84a4-96760631e615"],
 " over a circle of radius 2 around the origin."
}], "SolvedExampleNote",
 CellID->6821212,ExpressionUUID->"84fae0fb-f430-433a-a334-5fa625b749ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Exp", "[", "z", "]"}], 
    RowBox[{"z", "+", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1160", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[{0, 0}, 2]]}, ImageSize -> Small, FrameLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, FrameStyle -> Directive[12]],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->21937935,ExpressionUUID->"10e820ce-0424-4c5c-b350-38633d54748e"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxU2lVQnOu66Ptd59zsu73WmmvKsIQIcXeDECEhIe7u7kKEKB7c3d3d3a2B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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}, 2]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[12],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->105762194,ExpressionUUID->"d48e6498-8510-4aed-8bd2-1d4dc2d001fa"]
}, {2}]],

Cell[TextData[{
 "You can read the result from Cauchy\[CloseCurlyQuote]s integral formula: it \
is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "72851581-3286-4606-b684-bd237b1d1df8"],
 ". Confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->714916390,ExpressionUUID->"1b91f89c-fa55-4159-9209-8d7217cdd838"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Exp", "[", "z", "]"}], 
    RowBox[{"z", "+", "1"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->37972597,ExpressionUUID->"16cd39f7-205d-4fe4-a1f4-eee183936301"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], 
  "\[ExponentialE]"]], "SolvedExampleOutput",
 CellID->447388994,ExpressionUUID->"771cb174-964f-46e8-803a-b17b60cb2117"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->2040335330,ExpressionUUID->"29d0ba24-6c1c-41dc-9acc-90fae5a88d28"],

Cell[CellGroupData[{

Cell["Mean-Value Property", "Subsection",
 CellID->651827160,ExpressionUUID->"1c1b46f8-9a7a-400d-bcca-7e2489bf70d3"],

Cell[TextData[{
 "For the special case of a circular contour around its center ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "234707f2-6a2a-4d19-953c-ae45ee7d9c46"],
 ", Cauchy\[CloseCurlyQuote]s formula can be written as:"
}], "Text",
 CellID->25166690,ExpressionUUID->"238925c3-18d8-4c1c-969a-28ab6f04ff95"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], "\[AlignmentMarker]", "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
       RowBox[{
        SubscriptBox["\[ContourIntegral]", 
         RowBox[{"\[ThinSpace]", "C"}]], 
        RowBox[{
         FractionBox[
          RowBox[{"f", "(", "\[Zeta]", ")"}], 
          RowBox[{"\[Zeta]", "-", "z"}]], 
         RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", "\[Pi]"}]], 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Integral]", 
           RowBox[{"\[VeryThinSpace]", "0"}]], 
          RowBox[{"2", "\[Pi]"}]], 
         RowBox[{
          RowBox[{"f", "(", 
           RowBox[{"z", "+", 
            RowBox[{"r", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}]}],
            ")"}], 
          RowBox[{"\[DifferentialD]", "\[Theta]"}], "     ", 
          RowBox[{"(", 
           RowBox[{"mean", " ", "value", " ", "property"}], ")"}]}]}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->498145113,ExpressionUUID->"9d1c4db1-c700-4d8d-ab9b-2d92583845f9"],

Cell[TextData[{
 "after the change of variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Zeta]", "=", 
    RowBox[{"z", "+", 
     RowBox[{"r", " ", 
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "cb43ed2b-079b-4371-88a5-d19986847f1e"],
 ". This formula, called the ",
 StyleBox["mean-value property",
  FontSlant->"Italic"],
 ", states that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9b823587-fcb4-423b-ad7b-ca29823310e1"],
 " is the arithmetic mean of the values it assumes on the circle centered at ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5e109e54-bdd4-4361-b7bf-72c49eeb98bd"],
 ". Naturally, the circle must be contained in the region of analyticity of \
",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "18e5fc92-6d64-4a16-85c4-50d52b4735e4"],
 "."
}], "Text",
 CellID->332768962,ExpressionUUID->"a1e14215-ae53-43c0-b1f8-1e24f555bb48"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->283395,ExpressionUUID->"76408f86-1f02-4a9c-a012-d077a44c2b59"],

Cell[TextData[{
 "Check the mean-value property for the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"z", "+", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e41ba9e1-4b9f-4794-aa8e-88baed5a2611"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7c269130-1341-42f6-89c6-6be169436c36"],
 " by integrating over a circle of radius 1:"
}], "SolvedExampleNote",
 CellID->256435896,ExpressionUUID->"e47cfbad-c2dc-468e-9073-dbac9f559392"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{"z", "+", "2"}]}], ";"}]], "SolvedExampleInput",
 CellID->35141512,ExpressionUUID->"da4d2d4f-a2cf-4ffc-bc07-a4a316728db5"],

Cell[TextData[{
 "Its value at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b09fca2a-822e-4b19-a866-1f326142af86"],
 " is:"
}], "SolvedExampleNote",
 CellID->129659950,ExpressionUUID->"c60b06b9-fb1e-4338-b115-cb42f789fd7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "0", "]"}]], "SolvedExampleInput",
 CellID->202225552,ExpressionUUID->"cd06d41c-efee-4369-ac50-2f1e8ca09969"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->348687955,ExpressionUUID->"78ec4b58-f4e6-472d-a6a9-5ed61f948332"]
}, Open  ]],

Cell[TextData[{
 "Meanwhile, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"\[VeryThinSpace]", "0"}], 
       RowBox[{"2", "\[Pi]"}]], 
      RowBox[{
       RowBox[{"f", "(", 
        RowBox[{"z", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}], 
        ")"}], 
       RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"\[VeryThinSpace]", "0"}], 
       RowBox[{"2", "\[Pi]"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}], 
        ")"}], 
       RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9c6356c9-1b27-48a4-a338-f2d656a2c9f0"],
 ":"
}], "SolvedExampleNote",
 CellID->14416421,ExpressionUUID->"bc1ad5e4-9fd9-4906-9732-9638655e6123"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]"}]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SuperscriptBox["E", 
        RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}], ")"}], 
     
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], "//", 
  "FullSimplify"}]], "SolvedExampleInput",
 CellID->248128950,ExpressionUUID->"61a23c5f-cb02-481d-a4b4-3e23bee18e4f"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->145985437,ExpressionUUID->"f175b572-747d-49e8-934f-a9d40aced7f0"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1775975144,ExpressionUUID->"d5ca3616-42ba-4bf1-b6e1-fa3102e082e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cauchy\[CloseCurlyQuote]s Integral Formula for Derivatives", \
"Subsection",
 CellID->674965709,ExpressionUUID->"cb76ba6d-cd31-4078-9e80-68ea02c01659"],

Cell["Recall Cauchy\[CloseCurlyQuote]s integral formula", "Text",
 CellID->435373346,ExpressionUUID->"551a3aea-06cf-41a2-89f0-4fb6a192b88e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", "z", ")"}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", "z"}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->235646558,ExpressionUUID->"43e1a38f-44d4-4691-8831-82d7a7e1e9d5"],

Cell[TextData[{
 "which, for a function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ba17924c-507e-4823-9c17-5172d93fe291"],
 " analytic inside the closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "dca37db5-8a2f-42f3-b176-21953564621c"],
 ", allows us to express ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9dfb7520-3d4d-42b0-bf94-f042c25076fb"],
 " as a contour integral, for ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "482651dd-e71f-4511-b29e-19357de28711"],
 " inside the curve."
}], "Text",
 CellID->50207621,ExpressionUUID->"432d71ed-e83d-4126-b258-3e8dd9e69354"],

Cell[TextData[{
 "Differentiating with respect to ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b9ab3f4c-09b8-40eb-aecf-f5d9568bb6ce"],
 " inside the integral:"
}], "Text",
 CellID->441775637,ExpressionUUID->"32405afd-8468-45e1-8f0f-8118830ab806"],

Cell[BoxData[
 FormBox[
  FrameBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"(", "n", ")"}]], "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"n", "!"}], 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"\[Zeta]", "-", "z"}], ")"}], 
         RowBox[{"n", "+", "1"}]]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}]], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->535607176,ExpressionUUID->"1f17bb23-5529-413a-881c-8f5852f19e5e"],

Cell[TextData[{
 "The differentiation can be done inside the integral because the contour ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "3fc98329-2845-45f9-85f2-5385914f9e75"],
 " has finite length and the integrand has continuous derivatives near ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b6cac212-6e06-4552-ba8d-42319dca532a"],
 "."
}], "Text",
 CellID->215387463,ExpressionUUID->"e3916754-919f-4fe6-9461-0b124b2ac5a9"],

Cell[TextData[{
 "This formula has the important consequence that a function that is analytic \
in an open region has an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "946a4fb4-f9fc-48bb-bb90-2351e97a4ba6"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"da986695-d9d1-4955-838b-2249876ab956"],
 " derivative. Therefore, a function that is differentiable once is \
differentiable any number of times, and all derivatives are analytic."
}], "Text",
 CellID->653011000,ExpressionUUID->"b1f64dac-089b-40b1-8ad1-049c29ef3382"],

Cell["This fact has no counterpart in real analysis.", "Text",
 CellID->670564336,ExpressionUUID->"fcc1f581-8813-4c33-bc7b-86cd6a44a4ed"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->84667823,ExpressionUUID->"9ef5a4b2-4c38-47a3-ad6b-faf274d1b207"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"cos", " ", "z"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"115009f8-32f1-4cb7-814b-a6e070afd670"],
 " with ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "419e36d8-b1b5-43bb-bd76-177e0c877d17"],
 " the circle of radius 2 traversed counterclockwise:"
}], "SolvedExampleNote",
 CellID->812420734,ExpressionUUID->"74649dd7-0202-40c1-97c1-5eb6230cf835"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["3", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1032", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[{0, 0}, 2]]}, ImageSize -> Small, FrameLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->55863097,ExpressionUUID->"648d1015-4be6-4a92-afbd-478dafd80135"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxsu2Vwowma5zlx9+Ui7sPt3d7Fzu1u7/ZMz0xPw0xPM1VVYiVnJUMlO8nO
dJqZmZlJZtmSxcwGSQYZxMz4skySzHbWSe7umdm7i/inI51hp+2fH/o/z6u/
eZ1y9/3/9Fd/9VcZ/0v0zd24nHPp6XF59/5D9J0HyRkf4pPfvb2anPku/l36
717/z9F/fPvnP7G/T9RG8I2RsZbIaEdkpHtnuG9ncHAHN7LTP77TN7HTQ9zp
Iu900na6mJFubqhbsN0j3uqZ2eiRrvfOB3uX0J4VpEcJ92igbh3YZQQ6zYEO
m7/d4et0eLqdrl6Xo99tG/BYBr2mIa9x2Kcf8etG/ZqxgHocUOEBJR5cnYBW
JqHlSVgxCS8RkEUCskBA56fQeTIqp6JyOiZjYFIWJmVjcxxslovN8oIz/OC0
ICgRBiWioFgUFImDQnFQIAnyJUGuJMiZDrKng8zpIH06SJ0OkmeCUzNBwkwQ
PxMcmQ0OS4ND8uDgQhC3GBxQBPtWgr2rwR5lsFsd7NRiHTqs3YC1mrAWC9Zk
wxodWL0LrfWgNT60KoBWjNVERhsiI82R4fbIYFcE17fTj9vpG97pGdvpntjp
JO60k3baaZEOZriDu90p2OoUb3TNrHdJg13zaNcS0rUCdyqhTg3YoQPajYE2
s7/F5muzezocri6no9tl63Vb+tymAY8B59UP+rRDPs2wXzUSUI4G1saA1TFw
eRxU4KElPLSIhxcm4PkJRE5A5FOojIzKKKiUhs4x0DkmNsvCZtnYDAeb5mLT
PEzCD4oFQZEwJqEoKBAF+eIgVxzkiINsSZAlCTIkQZokSJUEyZIgURKclATH
JcGR6eDgbBAnDQ7Igv3zWN8i1qvAepaxrlWsU4l1qLA2Ddaqw5oNWJMJbbCg
dTa01oFWu9BKD1rhQ8pGqiPD9ZHB5giuLTLQFenrjfQO7HQP7XSO7rTjd1oJ
Oy2knVZauI0ZauNutQs228Xr7TPBdhnWvoC0K+D2FahNCbZqAi16f7PR12Tx
Ntk8LXZXm8Pe4bB2Os3dLlOP29Dn0fV7NQNeNc6nGvSvDflXhwMrI4BiBFga
BRfHoIUxaH4Mlo/DsnFEOolIicgcCZmjoLNUdJaOzjDQGSY2zcKmOZiEg4m5
mJiHifiYUIAJBEGBMMgXBnmiIEcUZIuCLHGQKQ7SxUGaOEgRB0niIFGMTYix
cTE2IsZw01j/DNY3h/XKsJ55rHsB61rCOpax9hWsbQ1rUaHNGrRRhzbo0Toj
WmNGq61opQMpdyGlHqR4qDqCq48MNEX62iK9nZHunkjXQKRjKNI2utOC32ma
3GkiRZqpoWbmdgt3s0Ww0SIOts5gLTKkZQFuUUAtq2CzKtCk8TfqfQ0mb53F
02B1NdnsLXZrm8Pc4TR2uvTdbm2PW9PrUfV5lf2+1QH/Cs6/PBhYGgIWh4CF
YXB+BJSPQLIRWDoKz43DcxPILAGZnUJmyMgMBZ2modN0VMJAJSxUzMbEHEwU
FRcT8jABH+PzMZ4gJq4Q4wgxlhBjCjGGCKOJMKoII4uwKRFGEGETImxMhA2L
MJwI65NgvTNYzxzWLcU65VjHAtq+iLYq0JYVtGkVbVSi9Wq0TovW6JEqI1Jp
RsqtSKkdKXYhhQNV4f66SG9TpKc10tUZ6eiJtPdHWgcjzSORxvGd+slIAync
SNtuZG41cjeaBMEmMdY0izbJ4MYFqFEBNKwGGlT+Oq2vVu+tNnlqLK46q73B
Zm2ym1scxjanvt2p7XSpu9zKbs9aj3el17vc51P0+xcHAgu4wDwOkA+CskFQ
OgTNDUGzI/DMGDwzAc8QkGkiMk1CJBREQkXFNFTMQMVMVMRCRWxUyMEEUXEx
Pg/j8TAuPyaOAGMLMKYAYwgwuhCjCTGKECMJsSkhRhBieCE2JsSGBRhOgPaK
0G4x2jWNds6iHXNomwxtnUdbFtGmJbRxGa1fRWqVSI0aqdIgFTqkzIiUmuFi
K1xoh/P7qsI9deHuxkhna6S9I9LWHWnpjzQNRhpGIrXjkdrJcB0pVEfbqmdu
1HPX6wVYvQStn4XrZVDdAlCnCNSu+mtUvmqtp9LgrjC5qsz2Gou1zmpusBma
7LoWh6bVqWp3KTvcq52e5S6Potu72ONb6PXP9/nl/QFZPyAdAOYGwFkcNDMI
TQ9D02OwBA9LJmExERFPIWIyIqIgIhoqoqNCBipkogIWKmCjfA4WFY+LcXkY
51RsPsbiY0w+xuBjNAFGFWBkAUYSYEQBNinA8Hx0jI8O81EcH+3lo11CtFOM
dkjQthm0dQ5tliJNcqRhAalfRGoVSM0KUrWGVKiQMg1cooOLDXChCc63wrk9
VeGu2nBHY7i9JdLaEWnujjT2RepxkZrhSNVYpHoyVEParqFt1rLWa7nBWiFa
K4FrZqEaOVi9GKhe9leteSvUnnKdu9ToKjPZK83Waoup1mqos+ka7Jomh6rZ
udbqWmlzK9rdSx2ehU7vfJdP3u2X9vjnegKzvcBMHzDdB0r6QfEgJB6GxKOQ
CA+LJmARARZOIUISIqQgQioioKECOspnoHwmymehPDbK46BcDsrhYlGxeRiL
hzF5GIOH0aOs+BiFj5H52BQfJfLRSR6K56GjPHSYh+J4aB8X7eKh7QKkTYS0
ipHmaaRpBmmYQ+plSO08Ur0AVy3BFctw2SpcooSL1HChFs43QLkmKLuzKtxR
G25rDLe0hJs6Ig3dkbq+SDUuUjkcqRgPVxK2q0ibVbSNKlawiotWCZEqCVQ1
B1bKAxWL/vJlb5nSU6pxF+ucRUZHqclabjZVWgzVVm2tTV1nVzY4Vhudy03O
pRbXYqt7vs0jb/dKO3xznb7ZLv9MV2C6OyDpAcQ9oKgfFOJA4TAkHIWE47Bg
AhYQYAERFpAQPhnhUxE+DeHTER4D5TFRLismDjsmNicmFhdlclEGF6VzURoP
pfJQCg8l8dApHkrgohNcdJyLjnLRYS6K4yB9HKSbg7RxkVY+0ixAmkRIgwSp
n4ZrZ+FqKVwlhyvm4bJFuEQBF61AhWtQvhrK1ULZeiijvTLcWhtubgw3toTr
28O13ZGqvkgFLlI2HCkfD5UTtirIGxX0YAULq+AhFSKofBosnwuUzftLl7wl
K54ipatA48zTOwoN1mKjqdSkLzdrKy3qautajW2lzq6odyw2OOebXPJmt7TF
M9fqnWnzTrf5JO1+cUdA1BkQdgKCHkDQD/JxIH8Y4o9C/HGIPwHzJmEeEeZN
wTwywqMgXCrCpSFcOsJloBwmymGh7KjYKCsqDsrkoAzOX1hxUQoXJXNREhcl
clECB53goOMcdJSDDLMRHBvpYyPdLKSDhTRzkCYu3MCH64VwrQiukcBVM3DF
HFwmhUrkUPECVLgE5S9DuWtQtgrM1IBpLZXhptpwQ2O4riVc0x6u6g6X90VK
cZGS4VApfruUsFlKXi+jY2VspJQPl4rAkplAidRfPO8tUngKVl15KmeO1p6r
t+YbTIVGfbFJW2pWlVvWKq3LVbalGvtCrUNe55TWu+Ya3DONnukmj7jZK2rx
CVv9grYAvy3A6wR4PQCvD+TiQO4QyB2BuGMQFw9xJ2EOEeZMwRwSzKEgHCrC
oSEcOsJmRIWymTFWLFaMFZONMtgxVnQOSuOgVA5K4aBkDkrioEQOSmCjE2xk
nI2MspFhFoJjIf1MpIcJdzDhFibcwILrOXAtF67hw1VCqEIMlUmg0hmoeA4q
lEH582DuIpitADNXwXQlmNJUGW6oDdc1hqtbwpXt4fLucElfuAgXLhrZLsZv
FhPXiynBYgZazIGL+WCRGCia8RfKvPkLnrxlV86aM0ttz9RZs/WmPIO+wKgp
MqlKzKulluVy62KFbb7KLqt2zNU4Z2pd03Vucb1H1OARNHr5TT5es5/b7Oe0
BTidAU4PwO4D2DiQPQSyR0D2GMTGQ+xJiE2A2VMwmwSzyQibgrCpCIuGsOgI
i4GwmGhUTFZMDFaMFZ2N0k5FZaMUNkpmo1NslMhGJlnIBAsZZyGjTGSYiQwy
kX4G3MOAO+lwGx1upMN1DKiGBVVxoAouVM6HSoVQsRgsnAbzZ8FcKZgtBzMX
wPQlIHUFSKqvCtfWhqsbw5Ut4bL2cHF3uLAvXDAYKhzdKpzYKJwKFlLRQgZc
yIEKBECBxJ8/682Ve3IWXVnLzgylPVVjTdeasnT6HIMmz6gsMK0WmRXFlsVS
q7zMJi23z1Y6pquc4mqXqMYtqHXz6zzcei+n3sdu8LOa/ay2ALMzwOwBmH0A
Ewcwh0DmCMgcg5h4iDkJMQkwcwpmkmAmGWZSECYVYdIQJh1hMk7FRBnMU1As
lH4qGgulslAKCyWzUBILmWIhRBYyyUQmmMg4ExllIMMMeJAOD9DhXhrcRYPb
qVAzFaqnQtV0qJIBlbPAUg5YzAUL+WC+EMwVg9nTQOYskC4DUueB5EXgU21V
qLo2XNEYLmsJF7eHC7rDeX3hvMHt/NHN/In1/Cksn4rkM6E8LpAn9OdKfNlz
nqx5V8aSI23FnqyypmjMaVp9hk6TrVfmGFbyTEsF5oVCi6zYOldimym1S8oc
onKnoMLFq3Rzq9zsag+rxsus9TEafPRmP73NT+8M0HsC9D6AjgPoQyB9BKSP
gXQ8RJ+A6ASIToQZJJhBhhkUmEFFGDSEQT8V41RMhM5EYzoFdcoKobAQMgsh
MZEpJkJkIgQGMsFAxhnIGB0eocODNHiABvdS4W4q1EGBWshQAxmqIYPlFLCM
BpYwwCIWWMABoj9uDh/IEgIZEiB1BkieC3ySBz5WVYUq6sKljeHilnBBRzi3
O5zTH8od2sod28idDOaS0FwanMMCc3iBbJEva9qTIXWlLThTFPakNWui2pyk
MaRqNek6ZaZ+JduwlGOczzNJ8y2zhVZJkU1UbBeUOHilTk6Zi13uYla4GRUe
eqWXWuujNviozX5Ku5/SGaD0BCj9AAUHUIYA6ghIHQOpeIg6AVEJEI0I00gw
jQzTKTCditBpp6IjdMapmH8W7VTUU1GYCJl5yoqBEBmnrOgwng6P0eARGjxE
hXEUqI8CdZOhTjLUSgKbpsC6KbCSCJaQwCIKUEAD8hhADhPIYgMZvECaIJAi
CiRJAh9nAwkVVaHSulBxY7igNZzbEc7qDmUPbGUPb2SPB7MJaDYZzqaDWexA
Jt+XIfakz7pTZc7kRXvisjVBaf6oMnzSaJO1ylTdSrp+KdMwn2WU5phmcs3i
PKsw38YvsHMKHawiJ7PYRS9xUUvdlDIPudJLqvWSGn2kFh+p3U/q8pN6AqT+
AAkHkIYA0ghIHgPJeJA8AVEIEIUIUUgwlQxTKTCNCtNoSEx0hMb4i5j/pn9j
xUBIjFNWdIRAhydpMJ4Gj1HhEQo8RIFwZKifDPWQoK4psI0INhPBegJYPQmU
TwKFBCB/CsglB7KpgUx6IJ0ZSOEEknj+RIH/g9j/vrQ6VFQXKmgK5baGMzvC
mT3bmbjNzJH1TDyWSUQyKVAGA0jn+NME3lSJO3nO+Ulu/7hkjV81v1caP6i0
iWplknYlRbeYqpenG+YyjNNZJlG2WZBj5eba2Hl2Zr6DXuCkFrjIhW5SkZtY
5iFWeQl1XkKjj9DiI7T7CV1+Qk+A0B8g4ADiEEAcAYlj4BQenJqESASIRITI
JJhMhikUmEKFqTQkJvr/Py4qIyYKI8aKTEdIdGSKBhNo8CQVxlPhcQo8SoaG
ydAgCRqYgnqJYBcR7CCALZNg4wRQOwFU4oGS8UDeRCCHEMicCqSTA6lUfzLd
/4np/8Dxx/P874qqQwX1odymUGZrKL0zlN67lTG4kTEazJhA0qegdCqQxvSn
cr3JQnfStDNRak9YsL5TmF+vGd8ptfEq1Qf1SqJ2MUknT9HPphokaUZhhomX
aeZkWZlZNnq2nZrjIOc6p3JdhHz3ZLF7otyDr/bg67z4Ji++1Ydv9+G7/Pje
AL4/MIEDJoaByVFgcgwk4EHCJEQkQFNT0BQJJpFhEgUmU2EKDaGcsvoTFtq/
E5Xxb6wo9FNWtBgrIhUmUOAJCjxOhsZI0MgUNDQF4YhgHwHsmQQ7J4C2CaAJ
D9SPA9VjgfLRQNFoIGfMn4H3p036U4j+TyT/R6ovge57x/K9KagJ5daHsppD
aW2htK7ttL7NtKFg2hiaNgmnksAUWiCZ7UviexJFro8zjniZ7e2iJW7FFLem
e6tUvVetJKgXP2rlibrZJL0k2SBIMXJTTaw0MyPdSs2wkTPsxEzHZJYTn+0a
L3CNlbjHKtyj1Z7Reu9ok3ek1TfS4Rvt9o/2+kf7A2ODgbFhYHwUwI+DeDw4
MQlNEiHCFEQkwUQyPEWBSVSYTItBiKKg/Ds4/29cpx8Q+0ha7FOIFJhAhifJ
MJ4EjU9Bo0RomADiCGD/JNg7AXThgfZxoGUMaBgN1I4EKkcCJcP+/CF/1rA/
ddSXNO5LnPB9IPrek3xvqd643NpQVkMorTmU0h5K6d5MGVhPGcZSxpEUApRM
CSQxfJ84no8CV4LE8X7O9mbe8mrJ9GJFH7emfqNcfadailfLE7SzH3XiRL3g
k4GTZGQmm2gpFnKKdSrVNplqx6c5xjKcI7nO4ULXcKl7qNI9WOMZrPcMNnsH
W32DHb7Bbv9Qr39oIDA8GBgZBkZGgdFxcGwCHJ+E8ERoYgqK/pjRwIiGRzRI
oqESzSzyn4Ln/8OKdgoqptPwi8ZhNBqnyDHUBFLsvxonQmMEcGQSHJoAB/BA
3zjQPQZ0jAZaRwNNI4G6YX/1kL980F+E8+UO+NIHfJ+GfB9HvPHj3ncT3tdE
76us2lB6Yyi5JZTcsZXcu5GMCyaPoEl4KGkK+ET1JzK9H7jueKHj3bTttdTy
csH0dNnwfEXzam31tXLpjUr+Tj0brxUn6Pgf9JyPBkaikZpoIn2yED5Z8Um2
sST7cIpjKNOBy3MOFLkGylz9le7+Wk9fg6ev2dvX5u3v9PV3+wf6/AMDAdxg
YHAEGBoDhvHgyAQ4SoDGiNA4CcKTYxlEiEYIDZ6i/5lVDNdfinmsWP0rrtNS
Fqtp1FiJI1Ni+TtFgohTsSjFE6DxSXB0Aox+Cdw40D8G9IwCXSOB9uFAy5C/
YdBfi/NXDvhK+n0Ffb7sPm9qr/dDv/f9oPfNiCduzPMyvS6U0hj61Lr9qXMz
qW/90yD6aQz+NAkmkgIfad4Elvs93/lWbH89a30pNz1dMjxZ1j5bWXu5pnil
lL9Wzb5Ri99p+e917Hg9I95ASTBOfTBPfLCMfbCOfLANfrIPpDn6shy9+c6e
YmdPmau7yt1d6+5u9HS1eLvbvN2dvu4eX0+fvxcX6BsK9I8AA2MADg8ORn/1
hFhtGY0mDiVWmSeiVZoe62tTpz2OzPwfWTH/MkXQkT/3SmqsdVLIcLQ1kKJF
L5rOBGhyEsRPgGPj4MgYMDQKDIwAfcOB7qFAx6C/FedvGvDX9fuq+3zlvb6i
Hm9ejzez25vc5Ynv8bzu87zCeZ6n1IcSm0KJbVuJ3RuJ/VjiMPJxHPpIAD6Q
ffEMz3uO663AHiexvpgzP5k3PlTovl1WPl1Zfr42/1I5F6cSv1bz32jZb3X0
t3ryOwPxnQn/3jz63jL43jqQYOtNsvek27tyHJ0Fzo4SZ3u5q73a3Vbnbmv0
tLV42tu97V2+jh5fR7+/Exfoin7bo0DvONA3ESsmOCI0RIq1rVFKrN1Hm/4E
PTYsEU9npxgrFhKd0mnMmOj/jlVsAItOYpTYVEYlwZQpmEyMtVTiJBRtGRPj
4PgYMDoKDI8Ag8OB/sFAD87fNeBv7/c39/kaen21Pb7Kbm9pl7egy5vT6Unr
8Hxq97zrcL/odj/71BD62Lz9sWPzY0/wIw79MAJ/wAMJU/73VO87pusN1xEn
tL2YMT+RGR8u6h8q1I+XV56uLjxbk75QSl6q+K807DgtPU5Hfq0nvDaOvzYN
vzbjXlt631q7P9o6U2ztmfa2XEdroaOlxNlc4WqqdjXVu5uaPE2tnqYOb3OX
r7nX19Lvbx30RxOhYxTojNaQCbCXAPZNQQMkaJACD1PhURo8TkfwjJhhibKa
ik3mMS9DPZ3VYwYn5ndOJ3n66WwfnfCjsys5NsdSibE5jRydQCZA4jgYbbIT
o8B4tDAOBYYGA7hoPA/4u/v8Hb2+1h5fU7evrstb3ekt7/AUt3vy2j1Zbe6U
VvfHFvebFtfTDw2hD61bHzrXP/RhCYNIwhgYPxmI1X2a+zXb+YpvfyG2PJk1
PZTr7y1pHihWHy8vPVmVPV2bfqYUPFexX2joL7Wkl7rJl4axl8ahl6b+l+bu
OEtHvLXtk60l1dacZW/MszcUOepLnXWVzroaV229u7bJU9vqqevw1nX76qO/
zQF/45A/Wl2j/agND3REWzkRjM6KfWRogBpzJcN0OOrmop4u6oIJUaN3ao0p
pzY5apbpp5Ywag9jJpF+6hmjzpFy6oymYDoRok3GXAB5HCSNgcToTDIM4IeA
MVxgZCAw2B+rlr09vq5uXzTIWzq9DR3e2nZPZZuntNVT2OLOaXFnNLuTmlwJ
ja64+KbthPaNhO5gfD8aPwy9HwfeEXxvKZ7XDNcrjv25wPpk2vRQari7oLu7
pHygUDxalj9enXmyJnyq5DxT059pyM+0k8/1o88Ng8+Mfc9MXc/NbW8sLQnW
piRrQ7qtLttek2+vLnJUlTkrK50Vta6KBndFs7uizVPR6a3s8Vb1+apx/poh
f91ooGEcaJoAWghg2xTYQYa6KVDU5Eat7iADGWEiYyxkgh3bsUydrlwopxsY
Oie2ZGD+aT/DRGMbG9rpRoKCsEgx680gxKwlLWqaonZgFCQNxybeSVwAPxAY
7fMP9/pxPf7+Ll9Pp6+zw9vW7m1q89S3eqpbPOXN7uImd36jK7vRldbg+lTv
fB/fshnfsf6+F32Pg9+NgG8n/G+mvK+p7ldMx3Oe7YnI/GjGeFemu7Wovru0
cl+x8HBl9tGq6PEa91sl44ma/EQz+UQ7+kQ/+MTQ+62x81tzy0tz0ztL/UdL
bbK1OsNWmWMrL7CXFjtKyh3FVc7iWldRo7uoxV3U7inu9Bb3eKNNpxTnLx/2
V44GqvFA7SRQTwSbSFArBeqgwl10uJcBD7CQodgCCsVz0EkuOnW6yqOervUY
3Niij8WOrbNiO0AGyqGfLrvICIcEs4kwazK2tWCMQ7RRkDoMkgeBKRwQtQkT
fYHxHn90uhvq9A10+PraY72mvdXT0uJpbPbUNrmrGt1lDa6ieldunSuz1plS
6/z4vnXjXRf2rg95NwS9HQu8mfTFkTwv6c7nbPtTvuWR2HRvTv/NvPbW4tqd
paV7CumDFcnDVd6jNeYjFeWxmvBYM/ZYh3uk73lo6Hhgan5qaogz18ZbqhIt
5anW0kxrca6tsNBeUOLIq3DkVjtz6lw5ja5oYOe0e3K6vLm93rwBX/6gv2Ak
UDQWKJkAyglg1RRYG7X/VKiFDrcz4G5WbJM5yEFHuOg4L7Y8n+LFdulUPkY/
3bGzuBiHg3LZscVybMlMR3hUhEdGuFMwlwBzJiD2OMQaAxkjID3qzXEAuT8w
1Rsg9Pgnuvxjnb6Rdt9gdHpp9fY0ezqbPNG+09zgbqh319S5ollQUuMqqHHm
VDvTqxxJ79qDb3vQtwPwm2HgNd4fR/S8pLieMxxPOdbHQvP9acMtqe7GgurW
4vKdJfnd5Zn7K4IHq+wHSupDFfGheuyBdvCBrve+vv2esemRse6FqfqNuSLB
XJpkKUqz5mdZc/Ns2YX2zFJ7RoUjrcaZWu9KbXJFq2VKhyel25sSnWEGfGlD
/vTRQBY+kEsACqfAEjJYToWqaXAdA25mIe3s2Hp8gBu7LIzx0UkBNiXAKILY
sYYhiN1uODyMy8V4HIzPRgXM2AlDQEUEZIQ/BfMJMG8itmjljICsIZCJA+j9
ALU3QO4OTHX6CR1+fJtvrNU33OzFNXn7Gj3dDZ6OOndrrbupxhUtrdXVzvJo
LlQ68yscWdHv/20n9qYXfjMIvh4NvJrwvpxyP6c5n7Jsj3mWByLjnVn9dbnm
xsLqN4uLt5fm7i6L7q1w763S7yun7qvG72mG7ml77+rabxua7hlrnxgrX5nK
3pmKPpjzky056ZbMbGt6vi2lyJ5UZk+sdHyscSbUu+KbXe/b3O86PW97o2Oe
70PUSkz4U4mBTDKQQwUKGGAJEypnQ9UcuI4DN3KRFi7SwYsdqgYF2KgQmxDG
zqMUEUYXBZnCIEeIcQWxQ6GAiwnZWOyAyEBFVFRERkRTiHASFuBjO3zeMMjB
gex+gNkL0LsD1E4/ud0/1eqbbPZFneloo3eo3jNQ5+mrdXfVuNurXS1VrsZK
Z22Fs7LcWVbmKCpz5JY6Ml93I6/7obgh4NW47yXB85zsekq3f8u2PhSY7koM
N+e0V+dVNxYU3yzKbimm7yzz76ww766R7yon7qqG72j6bms7bumbbhlqHxoq
nhlL4kwF7025iebMFEtahiU5x5pYYEsotr0rs7+pcryqdb5ocD5rcT3pcj8f
8Lwa8b7F+xKI/kSKP4UeyGACORywgAcW86FyAVwthOtEsSNLqwjtEKLdQmxA
FDuyT4iDU6cPKjAkQbY4yBXFDvRCQVDEi52kJSxMwoidqiVkREJExBOweAwW
jkCCQZDfD3J7AXZXgNkRoLf5qS1+cpOP2OidrPeO13lGajxD1e6BKndvpaur
wtVW7mwuczaUOmtKHBXRYltsLyiy58T1wnE48NWI/yXe+5zofkp1fMu0PeSa
7wmNt6Z1V2Waq/Or1xcWbi7O3lKIbi1zbq9Qb68RbitHb6kHvtF03tQ1X9fX
3jFUPDYUvzDmvzFmJ5jSP5mTU80fMy3vc61vCmwvS2zPyu2Pqxz365132lz3
e92Ph9xPxz0viN7XFN97uv8jO5DMBdIFQLYIzJdAxdNw+QxcPYvUzyLNs2jb
LNo1g/VOYwOS4NB0ED8de+6FNrPOnFnnTK/zJetCcexpmWlBcIYXez5klonN
0tBZcuzQP4OHp0dhyRAkHgCFvSC/C+C1BzitAWazn97oo9b7SLVeYo13osoz
VukeqXAPRl1YqaunxNlZ7GwtdjZFR51CR3WBPdqeivPt+a/6wZdDgRdjvueT
nqck57c0+yOW5T7PdFusvz6rvSxXXZ1XXF+Q3VySfKPgfbPMuLVKurWG/0Y5
eFPdfUPTek1Xd0NfcV9f/MSQ99KY+daY+sGUmGSOTzO/zrK8yLN+W2h9UGq7
XWG/2ui40em81e+6O+p+MOn5lux9Rve+Yvve8vwJwkCSBEibAbPmwHwZVCyH
y+eRmnmkYR5tmcfa57FuOdYnCw7OBYdng/i5ddLcOn1unT23zptdF86sS6bX
Z8Trs8KglB+UcoIyJiajoTISKiUg0nF4bhiexUGxc20PIOoEBG0BXrOfU+9n
1vro1V5qpZdU4SGUeSZK3WMl7uFiF67I1Vfo7I4ajXxHa54jOhzW5dqrcm3l
ObbilzjgxYj/Od7zlOj6luJ4xLA+4JjvCIw3Jborc+rL8tWr84vXFuZuLIlu
Kjg3l6k3Vwk310ZuqPquq9uvahsu6ypv6Ysf6vOeGTLjjMnvjR8+mt4mm16m
m59kW+7nW78psl6utF1stl/udlwddN4Yd92ect+jeR6xvU/4vhci/5tpf3xs
mw2kLoBZi1CeAi5ehiuWkZoVtHEFbV3BOpeDvYrgwNL68ML6mHx9QrZOkm8w
5Btc2YZAtiGRbszMbkin12XidblgfZ4bXGBhCzRsgYTOTyLz47B8FJINgdIB
MHbj7gpI2v3CFj+/wcet9bKqvPRyD7XEQypyEwrd+ALXaL5rKM+Jy3X25jii
1qw9294SnaWzbLWZtqpMW9mLIf/zMe/TSfeTKedjqu0B03KXa7ol1F+b1n4t
U12SL1+Zl19bnL6+xL+hYN5YId1YHb++hrum6rqibr6krb6qK72jz3+kz3xu
SH5tSIg3vk40PUsxPcww38qxXMm3flVlO9NiP9fruDjsuDzpvEZx3WS67/A8
98XexzO+5zJ/3ELg/RLwcRlIWQUzlVCeCi5WIxVqtFaNNqqxNnWwSxXsV60P
ra2PrmzgFRuEhQ3SwgZzcZO3sCle2JyRb0plG/NzGwvTG0uidQVvXcEKKmiY
gowqppDY82/j0OIIuDAIyPsC0m7/bIdvusUnavQK6jzcag+7ws0odVML3aQ8
FyHbhc9yjmY5hzIdAxmO3qiTTbe3p9la0mwNqbbaVGvlsxHfU7znCcH1mGx/
SLfeY5tv8403xLors5qLsrVL8qUr89Kri+JrS9zrCtr1FcL11ZFryr4rqvZL
mvoL2vIbuoJ7uqxv9SkvDQlvDXEJxqdJpntpphuZ5gv5lt9XW//Qavuiz35m
zHFuynmR7rrMdV0Tub+Z9dyVex8u+p4u+1+uBd6qgA8aMFkHZeqhPANcbEQq
jGitEWs2BtsNwR7DOk6/MaLdwGs2CMpN8uomVbHJWt4UKjanFZvSxc35hc0l
2eby7MaKZGNVsL7GDq4xsTUaukZG1ohw7LnBUVAxFFjq9y/0+OUdvtjtu8kj
rvcIq928Cje71MUoclHznaQcJyHTiU9zjKY4hpLtA8n23iRbV5KtLcnW/Mna
8Mla+3TM82TS9XjK8ZBqu8+w3OGYvhHor0m0X8+pLspWLskXLs/PXl0UXl1i
XVNQrq1MXF0duqLsvqRqvqCp/lpbfFOXc1+X+kT/4ZX+9TvDkw/Gu8nGq+mm
M7nmX1VbftNm/e2A7fd4+xdkx1cs5zmh6+KM+4rcfWPJc3vVe1/l+1brf6EP
vDECCWYwyQJlWOE8G1JsRyvtWJ0da7EFO23rfdaNIcvGmHmTYNwk6bdomi3m
2hZnbUu8tjW3urWwsqVQbK0ubCllm6qZTbVwQ8Nb13AwLRPV0hANCVYTQNU4
oBwOrA74l3t8i53e+VaPtMk9W++W1LiEFS5eqZNd5GTkO6g5DlKmg5Bmxyfb
RxPtQx9s/Qm2ngRbZ4K1LcHaHG9p+Bbvfkx0PiTb79Osd1nmWzzDDaHuyrTm
vFR5Uaa4JJdfnp++ssi/usS8qiBdXRm/sjpwSdlxUdVwTlN+WZt/S5vxUJf4
TP8mTv/0veFuovFKivGLbNO/VJl/3mb5Jc76q0nbb2j23/Ecf5Q4v5K5zi25
v17zXNV4buq9d02+R1b/M3sgzgnEu8AkN5ThgXO9SLEXrfRi9Z5gq2e9270x
4NoYcW5OOLZIti2aZZtl3ObqtgXq7Wn1tly1rVBur61uqxTb2oUt3dymfnrD
IF43CoJGDmpkIEYKZCCCenxAO+JXD/iUvd6VTo+i1b3Q5JLVu2arndMVTlGp
g1/s4BTYmbl2WpadnG4jptgmPtnGPliH3lsH3lh7X1s7X1vaXluaH086H07Z
H1Bt9xiW22zjTb7+mkj79Yz6vHTtgmzpa7n00rzk8iL3yhL9ioJ4eWX00mrf
18q28+raM5riK9qc29qUR7r3z/XPX+vvxxuufjJ+kW78p3LzP7Va/hln/RnB
9nOG/ZdC+6/nHL9bdP5xzfWV1n3e6Lls9Vx3eG+7fQ+8/if+wKsA8B4AP4FQ
OgTnQkgJhFZBWAMYbAPXe4CNwcDmuG+L6N2iureZzm2uLSQ0hyT60Kw+tKQL
rWlDGnVIvxYyLm2b5FsW6aZ1dt0mDtr4qI0N22iQdQow4wPGEZ9+wKvt8ag6
3GutruVG52KdU17tmKtwTJfaRUV2foGNk2tjZtlo6VZyqpWYZJ34aBmLtwy/
s+BeW/peWrqemdsfEh0PyLZ7NMsdlukbruG6QHdFrLkwqzonXbkgW/haPndp
XnR5kXN5iXZZQbi0Mvz1as8FZctZddVZTeFVbcYdbeJjXdwL3aM3+hsJhq+S
jD8pMf24xfxjnOUnROtP2bZ/ltj/Zd7+i1XHr7XO35ldX9jdZ93ur73u6z73
nYD7EeB+AXnewt6PiC8VDWSjQCEGlWNIbRBrDq53YBt96OYwsjUBb5HBbUYg
xPWFhJ7wtCMstYTnzeEVU0RjDBv0YbM6bF0N2RXbzsVNl3zDPRv0iFA3B3bT
QddUwIH324a9lgGPsduta3epW5xrDY7lWsdilV1ebp8rtU0X2UT5VkGulZtl
ZWVY6KkWSpJlKtE8mWAef28eeWMefGXqf27qeUCy3aNa7zDMt9jGGzz9VaH2
kkR9bk55Trp8QTZ/UT779bzo0gLn0hL1kmLy6+Xhi6vd55VNX6kqzmryrmlS
72rjv9U9e6m7/VZ/4YPh53nGHzaY/mHA/EOi5R851h/N2n6ssP9U7fiZyfEL
h/M3bvsXXtt5v+0KYPsGst2HbU8Q+yvUEY85k4LujHVP3rqvdCNQvQE2bsLt
m2jv5vrg5ubYxhZxfZuGhThIWAiFZ4CIzBdZdEWW7Tsq+47BumMxRxz6iEsd
9qhCvtUt/9JGQBYEJCjAgwN00D/l94373EMeZ5/b1uU0tzn1TQ5NvV1ZY1up
tC2V2+ZLrNJC60y+RZxrEWRZuBlmdqqZkWyOHQ4+mIjvTRNvTWNxxuGXRtw9
ivUO3XyLZbrJMVzn666ItBen1WdirBTn/8xK+PUC+9Ii9esYq6ELq93n1hq/
VJWf1eRe0yTf1b75Vvvole7aO/3vUgx/V2X8Qa/5BwTLD7jWv5Na/37V9kOD
/Ud22z+5LL/0mv7gN54BDV/DhuuI4Q5meBQ0Pl83vdkwf9i0pmzas7echdvu
im1v3ba/NQR2h2BcCBsLrRNDm9TtEGsrzN+ITAcjMnRnEdpZCeyq3Lta967F
tet07HosO35jBNCHIc02srqJLgSxaRTjQSgNQAg+eNQDDLh93U53u8PebI89
n1lr01RZlRXWlVLLUrFlvtAizTPP5JjFWWZhuomXauIkm5iJRtoHIyXeOPXW
MPnagH9lGL1Ds9ximr5hG69Hg0qgvSTWnJ9RnZlbO2UlvyCfuRhjxfk6ymqJ
cHF5+MJK99m1pi9U5WfUOVc1n+5qXj3R3nulO/9e/5MCw9+0m74/Yf4+1/J9
ufX7auvfWmx/5zT9xGP4uV/3W1DzJaw+j6ouB1U311X3NtXfbmlebGvfhfSJ
IUNa2JQbtpZE7FURV2PE0xHx90XAkQg8GcEokQ1WZIsfCUvCEen2zuLm7mpw
V43s6YE9k3/P6dvzefYAxy5k30GtkaAhtKHa3FoKbsngLUlgg+NZpzgxvAPG
2cFOu7/Z5m6w2Wut5mqLocKiKbMoS8wrRealAnPsMYxs02ymSZJuFKUa+clG
bqKB/cHAiDfQ3unJb/RTr/STtxgxUDe4+mt83WWh9mI0AWeUZ+ZWz0qXTlnN
XpgXXVzgXFykX1wiXlCMnF/pPbva/IWy4kt1zhVN4l3Niyfab+J0f0zU//da
438bNn2Pbf6vcst/1Vq/ZzP9rVv3I7/6Z+Dar5CVP2DLZ9YVFzeXrm4rboUU
98PLTyIrryJr73eUSbvqjF1d/q6hbM9cu2dr2XN273kG9/zjeyBpD2HsBXl7
m5LdbeluZHFndyW8p9neN2zsW7B9B7zvhfZBYB/17Qe9u5uunZA1HDFsRNRI
ZDkQlrpDAtsW3bxBMGLDRrjbCLSYfDUWd5XZXmE2l5n1JWZNkUlZYIo93pNr
XMg2yjKNc+mG6RSDOMkgTNTHDnnxetY7HeONjhanI99kGW9wDNd4uivRoBJp
Lkyrzs5GWa1EWZ2Tyc/LZi/IxRfmeRcXGBcXSReWxs8v959dbftCWfUHde4l
9afbmuffaq/H6X6Zrf9el/G/UE3/t8z813rLXzv03/eqfgis/BOy9Ivg/G83
ZV9sS8+F5i5F5q7vzN3elT7ckz3bn3+9v5hwoEg+WMk6UBYeaCoO9PWHprZD
a++hc/jAQzgIUA8gzgEqPliXHmwt7ofX9nc0e/uGnX1r+MC5deANHgaChyh6
uAEfbEP7Ef/urie051jfN4L7SvfevGVXpI8w1CGCamNYhfWooRZtoNbgLTO5
Sk3WYpOpyKgrMKrzjWu5xpVsgyLLsJBhkKfppSn62ST9dKJO/EEnjNfx32m5
b7TsOC3jOkf/r6AuitXnp1Vn/pWVdP6cbO68XHJhXnBhnn1hgXphafK8Yujs
SteXq3W/VRWcVyd/o3nxreZqnO7HZYb/PGb8T9Pm/0tv/j+dmu/5V/4eXvhx
cO5ftqZ/FRL/PiL8aldwYU9weV9w40B491D06Ej8/Gj67dHsxyNp2tF87tFS
ydFq1bGq8VjXcWwaOLaOHTunjr2MI4B/BM8cYQtHm6uHIc1hxHi4Zzs4cO4d
+nYOwdARsnW0sXkU2jjcCR7so7uH0PaRFzuy+o40tqMF7aFg+YC2sDsxH8It
rnctI81rQK3GW6ZzFRochQZLgcGQb9DlGtQ5BmWWYSVTr0jXL6bqF5J18k86
6Uft7AftdLxW/E4jeqMRxKl5V3m6y1FQwhioCxJVNAG/ml37am7ljFRxVrpw
TiY7J5s5Lxedn+edX2CeXySfX8KfVQx8tdL6+7XyL1Tp19Rxj6KstD9oMvwn
luk/asz/u1P1X4DFH2CzP9oS/XOY94td9m/3mX88ZJw9oF06oN44oN45oD06
oD8/YL45YH844KYcCLIPJYWHsxWH8vqjpbaj1d4jzfCxYfLYSj1xck584hNQ
eoIqjtdVx1uG47DteNd9dOA/OgIPjtC9442d41DkeDd8fLB9eLS1dxzcPoHR
E6/n2GI4WlMcTM/s0wR7w4KdXslWmwxtWAKq13ylGneBzpGnt+bqTbl6Q45e
m6VXZ+qV6bq1NN1Kik6RpF38pF34qJEnaGTvNXNv1TOv1dOvVOJLAu3Xor+A
iiZglNXcKas5xRnp4lnp/FmZNIrrnFx0Ts47P884t0A6tzR+RtH3xUrjr5UF
F1QJ9zTfxGn/W5/hPy6a/jen8q9h6d9sCn4YYf10n/rzg6nf7E98sT92fn/k
8t7Ijb2Ru3sjj/ZGn+2Nx+1NxO8Rk/bJGfv0vH126QG/5kDcfDDXdbiAO1wZ
P1KTjgzMY4vg2Dl74ls8gdY+Y7rPm5aTkPNkx3eyDx0fYsfHG4cnof2Tnf2T
g72To72jk529z+HtzxvICew4dq0dakQHc9Q9OnEXR9ptZW03StCaeaBi2Vus
cudrHdk6W7bekq03Zun0mTpdhk6TplOlapXJ2rVPmpVEzfIH9VK8evGdauGN
Sh6nkr1Szl0UqS9EU+8voKIJ+GWM1epXc8t/wnUmiksqPSubOSsTn5Xzz86z
zs5Tziziv1rq/8NK/a+VmTfUj19q/2bK+B9smv8Dnf7vYcY/HBB/sj/8q72+
P+x2ntlpv7jTenWn9eZO692dtoc77U93Ol/t9Lzb6f+4M5i6O5q9O1G4O1Wx
R6vfY7fuC3oPpocP5JOHCuqhinOklxxZZceu5WO/5gQynQTtn7e8nyPg5z30
88Hm5+PQycnO8ef9o89HR59Pjo4/H+5/3g+d7CBH29Y9dD7somyudG9Sm3Z6
+iI1U9uVAqRM5i9WeAqUrlyNI0tnz9JZM3XmTJ0xQ2dI1+pTtdoUrSZJo07U
qD6qlQnqtfeq1beq5ddKxau1pZdri+f+RGlaeeYUVDQBo6y+jLFaieL6ak7x
1dzSGenCGan8jFR6Rjp7RiY5IxOckbO+mid/uTjyh+Xm3ylTvtX8Smb8X4Oi
7x1M/HC385c79b8PV34VLj0fKr4UKroWKvomVHw3VPIwVPYkVPEiVP0mVJcQ
bkoKt2VEuvIi/SU7w1U7+MZdUscuvX+PO7ovJu5L6QdL/EPlzKF+4ci6duzS
HQcsJ7DrZD3weRv5vLP+eX/7u6Od7072P38++vzdyefvPp+cfHdy+Pk4fHyI
7O5ZNkIzfrTfYkuz8BLhhtpwweR6gSiQP+/JXXHlKB3ZGnum1pahtWZoLRla
c7rWlKo1pmgMSRr9J7X+o1qXoNLGqzTvlOo3SlXcmvLl6trz1dWvZtZiBeov
+vLPrGK4/qKVUy1/Oaf4Ym7pi7nFL+bm/zgn++Pc3B/nxH+Ucv44j/+NMgkV
/edw2a+3Ur7YTDi78e7Cxpuv199cWX97ff3dNxvxdzc+PNj49O1GyvPN9LjN
7Pdb+R+3SlK3K7K2awtCzWXhjppwX3NkuGtnErdDGd9lk/ZEzP05wcHS7IFy
8VCvPLIajty244DnBAFONtDPoc3Pu+HPB3vfHR9+9/n4u+8+f/dd7M3no5PP
u/sn69uHzsDevCY0yEE/9hp+zXrfuP2B70qat6eu2NKVtgy1LUMTBRVTutYa
VZrWkqKxJGvMn9TmRLXpg8oYrzS+UxrerOnj1vQvV3XPV3RPV7SnHFb/nU5B
/Tt6X82chtz0qSTKs2LVWZHqnEB9gaf5mq27QjXeGrU/y9/Sf2/I/6t34Fff
QhcewJfvI9fuIzcfILcfovcfo4+eYk9eYC/igq/fBt8nrCd+2khJ28jM2szP
3ywp3aqq3m5oDLW3h3v7wsPDkcnJHSp1l8PZE4v3pLJ9xfKBWnNoNB3ZHUde
3zEIHWPBk83tz+Gdz3v7nw+Pvjs++ROqGKyTo+8Odz+H109g55Fl/kA6uE9P
hJd+dlFb+UwpjiZUolqXojFFyaTHIuovuDS2NI0tVW1LUVmTVNZPSuvHNUvC
miV+1fxuxfxm2RS3bHqpML5YMp5mmeI03aJJ9yduMURRPtHyFU3PaCmLFrSL
Qs0lgeYyT3uVrb/OMNykmG8TbPeGXA/bwBcFW8WPNgU/1Rm+P+T6u1LvzzP9
v08CvvoIXkiAriRANxLg2x+Q+4nI4yT0WSoWl4G9zw4m5q+nFm9kVWwU1G6W
NW3Vdmw394W6hkO4yfA4JUJi7zCFu4K5vdml/UXl/pr+QG89tLqPXIGjAHKM
bJysh062d092Dj7vH0dT8HOUViwPT04+H5xEi9gBfBS2HGDTEX8P5I2nua6k
WHLeGMc/6SVpuuUMnTZaoDJ1lmgOZmrtWRp77OUMKnuG0p6+Zk9bjcVe8oot
admWqLB+WLImLFrfL1jezVveyC2ntWjxzNzSX4jFWEULVxRUlFK0P34t1ESH
iuhocZ1tuMkw3qKY7xBt98ecD/t9j5vhpyVbKUlblbc2yb+3L/6tTP+Dcdvf
t7p+VOn9eZHvd/mBr3KBCznglRzoZg50Nw9+VIA8LULjSrH3FVhiTTCtYT2n
daOoa7Oyf6t+eKttYruXHBpmhicFEdrMDnd+V7KyJ9PsL5v21Y4Do/fQDh55
sCNg6xiNHG/uHYcPT3ZPjg8+Hx9/F02+aK3aP9nbPd7cOQyE9vTBsMi1MSCD
Crs86cWOxmQbPtMkyDYu5hhU2XpDts6SFe2DGnuO2pGjcuSsObJXHVkrjsxl
R4bCkb7kSF10pCw4omn7SWb/KLV/mLPHz9rOSmXRweCU2NKZGK6VGKsoqOkY
qOjcdYWvvcbV32AZvqGb7pCt9ybtD0bdj/v8T1rhJxWb8TlbOe+3qr7ZHD/r
Ef+zbvnvpnX/QLL8I87+k3bXPzd4flnj+0OV/2xl4FIFcL0SvF0FPayBn9Yh
cY3o+xbsU0cwoyeYh1svHd2ontxsIm91MrcHeKFxSZgkizAVOwLV7qx+b8G6
t+ra1/oPzPCBc/3Qt30I7RwF94+2jo4iJ4d7nw8OYr1w9/godLy3ebSJHAS8
u1pTaEa2PkmDcf3+/irPaIGDVmiVFEatn1GdZzDk6q05OnuexpGncuavOfNW
XXnLrlyFK2fJlb3gir3YQe5Kl7nS5lwps87kGecniTNR7Dwnm41OUGel8rN/
xhUNrbWzp6yic1d0nr/G099kG26dgrpPsD8ccz8e8D3pgJ7WrccVbyVnbOW/
3aq+szV4CWD+wTr3E/XKP85qf8Qw/nTC+rNBxy96Xb/u8Py+zfdli/9CS+Bq
K3CrDXwQ/eQuOK4XiR9Ak4exzPFgAWG9nLJRx9xs5W31iLeH5kITi2HKaoSt
3RGZdqT23SXvngrcM6D7ts19d/ggsHuAHO5vHO9vn+xFPu/ufd45OInOohuH
e/DBlm8Psu3YVduq2fU5GsIbAJj1Pna1S1xpk5dZVktM2kKjOd9gi45YhWpX
odJVtOouXHYXLrkLFj3RRpkn9+RIPbGXh8x4MqY96RJPmsiTIvQk8z3nZNNR
XOdiuKJzVHSaiqVhlNUFiTrqeq7ydVG3eItpukO13J+yP8S7vh3yPukBnjWj
zyq33hdsp6VtFUZZ3d/quQYTz7v5vzPJfqpe+YlM/U98w7/QzL8g2n4z7vj9
sOvLQc+5Ae+lAf/1gcBtHPBgEHw6Ar0egxMmkZQpNJuKFTHXK3kbDeLN9rmt
voWt0ZVtojrEMIT5tsiMO7Lg31mFd7XBXfP2riOy59nfBQ93sePIxklk+3Mo
/Hlr52R97wjZ3wvsbTt2UW3Es7BtEqwriejCICjr8slaXIv19tVqq7bcbCox
2or0zhKNq0TlLl31lC57Spa8xQveonlvocxbMOfLn/XlTftyxL7YS0UEvgy+
L53rS2P7Yv5FPn0+hiuajAtnpYrYkmFWeVGiviz8U1AZb9PN98jWhwTH41HP
kwH/s07oeUPwZfn2h/ztjCiraA5+u9X+TXD0ip9+ziH6vVH+L5rlny2qfj6j
+xXf+Fum5Q9U21ckx3mi6xLBc33Se5vge0AMPJ0C4shgPA1KYsKZXLRAgJVL
gnXS9daFjd6VzWH11qQhtl/nOkNiX1gGhhVoRLUZ0Ycilt2Iaz/sPwxBx9vo
ydb6ycbWSTB0goSPAjv7rp2wJbyu3gYXNt2ioJmG6PBA7MX7XW5Ni0NfbzVX
mW1R71yuc1eoPRVr3ooVb4XCV77gK5P7S6X+kjl/8UygUBKIDWOCQC4/kMMN
ZLOBTCaQQQcuzPMv/BnX3DlZNBOXYsb5lNUVofY6T3+LZbxLszwg2R9NuJ6M
eJ/1Ac/bkRf1G6/LtxPztzPTtwoTtiqfbzXd3Ry4CRMue1nn7eIvTPLf6JZ/
uar8zbzmdzP6P4pMZ3iWCxzbZZbjBtN1m+l5yPI+ZfviOIF4PpAkBDMlUP4s
XCZHa5ewltVgt3p9UL+Ot2yQHZss75YQ2JpFthfWt1e2tzWRbdPutn1/y3O4
4T9eB0+C6AkaPIHWT4DNI+/2vjW0o9/eXtvE5OuACPUwIQcxYB32Wnpd1naH
vdHmrLG4aw2eqIOuUfpqVv3VCn/VYqBKHqiQAuWzQNk0UCoGioVgER8s5IL5
HDCPBeUyoGwalEWBL8xzYmsEufiCfOZ81CnHPODy2TnlxekYqxs8/W2W6R7N
8nDK/hjvejrse94LvmhDX9ZtvCnf/lSwnZmxXZi4VfF6q/7RVted4OhNkHzV
w/naLj5rln1hUPxOu/aHVfWXi7qzMuPFWfOVaetNif2O2PFQ7Hom8cRNe+Nn
fUnSQIYcyF8ES5ehGiXcrEG6DCjOgo05glOedUZggwdvSIKb0s3NpdCGamdD
v7tu2Q86DjH3Meo/hsFjED7xI8de7MgZ3Df/P218Z5sT19blT5uZe22MsbGN
DTY2uQGTMw00DZ1zzrlbrZxzzjnnrJY656RUqqpzqvGHUcn33nnfmXme9Y1G
j7RKZ++11j7aeTySr7jzJcvJiebwQLK/y9nZom5tzq1vjq9ujaxsk0skYjsD
oZ3+wG6fd6/Xtdfj2O+27neZ9zuN5I8t27QHLerDZuVhk+zwk+SoUXTUIDj6
wDt+zzn+yin7yqH8yqH9p934T7vlHzbH/yKPYaDK1be66MUaV5dFK79xV39n
bFxf2r45s39r9Ph2X/Fee/npp/Lbd+XG5+W2P0s9N0rDV4rzPx8zftwTfrep
PL+qP7di/WfK9T8Tvv8RDf0jGDnni1/wJH9wpX92rvzmzF13rtW51h+4N595
t974tz8Gd1sie13x/cHUwcTK4dzaEXXzmL17LDw4kZ+cagqn5vKJq3ISwE4i
4DhJHGbODnJ/7W/8tbf91/buXxt7f63uf1k5JJKHIHyIug/L5oOiev9UvHtM
ZsgbB4ur+7Mre1OpvYnY3lh4bzSwP+zdH3IfDDgO+m0HvebDHuNht/6oU3PU
oTpqUxy3yo6bJcdNwpNP/JNG7mkD+/QDI08Gnk75Vw71Vw79V3bzP8l8z/0/
rYGvTCGSK3X80r+5+qPKFWWnytXtseM7/YV7HeWnTeU3H8ofX5VbH5e77pYH
rpUmf80vXT5iX9oT/bilvLiu/y5nubDi/DbtPZ8KnE+Ev4vGfowkLodSV0OZ
G8FsXSj3MLz2PLL+JrrZEN9qSW13ZXYGcntj6/uzW/uU3QPmwSHv5FCaP9QU
D03lQ0fl0IsdBMF+lNhLnu1kvmzn/tpa/2tj86/Vrb8y21+SO0RsFwR3MfdO
xbpT1m0V5Jt54foJO3dMXzmipA7n44ezkcOp4OGE73DMfTjqOBq2HQ2ajwaM
x336417NcbfqpFNx0iE9bROftgpPm3n5Jk7+E6vQSC80UItfuwRfuyRkou7Q
fOUwfmW3/tPmIgde5tB5fY0reeqKeOUqb/Uac+MGZefW7P6d8eO6gcK9rvLT
lvKbxnJDfbn5RbnzYbmvrjx8rTxzNU/99YhzZU/8y7by503dpTXzpVX7paz7
0orv50zol0zkSjr2Ryp5K5W6m8o8SmWfp3NvM2sN2fXm1c3O9a3+ze3RnZ3p
vd3Fw13G8R7/dE9a2FOX9ozIng3ddeG7PrATIraiXzarHjH9ZT1Lup/M2pfE
+pfYxll4A/o3cNcGal1H9Gsl5WpRks3zM6fs5Ak9dkKJHC8Ej+d8x9Oe40nn
8bjtZNRyMmw8GdKfDmhO+1SnvfJ8tzTfKS50CAptvEIru9jMLH6mlT4tlz8u
lr92c8+5hOdcsnNO1dcO/dd281c2xz9s3n9YQucNkYua+CVF6opk5Sp/9Rpr
4+by9u35/TuTx3VD+bs95Sft5ddN5Q8fyk1vyu3Pyj0PyoN15bHrpflredof
R9zf98VXdxW/bWt/2zRdXbddXXP+seq9thq4kQvdzkXvrsb/XE0+Xku/WF95
u5H9uJlr3lrr3Fkf2NsY29+cOdykHG8xT7f4+W1pcVtV3tZXti3olgPf9MAN
P7EW/LIW/bKa+JJNfclkvqRWvsSyX0LZM3+O8OSAI4dZsqh+BVFlyrJUUZgo
cGMFZjhPC+YpvtMFz+mc83TafjppyY8b86P6/LAmP6QqDMgLfdJij7jYLSh2
8krt7FIbo9xCQ5ooyOeFSuNc5ZyHdc7NP+cSk0NAp/acw/S13f6VzfMPa/Ab
U+R7XeySMnlFmvldkLvOXr9J2769sFc3fXR3NH+vr/S4s/yytfz+U/nT+3Lb
63L3s3L/w/LI3fLkrdLizTz9xjH3xqH4xr7ixq725rbx1pbl9qajbsN9b8P3
50bg0Ub42Ub01Wa8fiv5cTvVvJPp2F3p3csOH+QmD1fnjteWT9ZZ+XV+cV1S
2lAi69rKuglbt4I1J8x5iKz/LBs6W4l+Sce/JBNf4qkvkdSXQPrMmyZcaWhL
4+YUpk+i6gQij5XF0RI/VGIHigxfkeopLDkLC/bCrKUwbSpM6ovj2uKoqjis
KA1KS/3iUp+g3MMtd7GRDgbSTqu0UsitAi1zaMtMlSv6OQ/nG7fwG5fsG6f6
nMNwzmH92u76p81/zhz+Xh+7pE5ekWV+F+Wuc9dvMrbuLO3dnT28N356f7D4
sKf8oqNc31xubCy3vCt3vi73PS8PPSqP3S9P15WW6gqMuhNe3ZG47lB+d19z
b89wf9f8YMf2aMf5dNvzYtv/eif4bif8cTfatBtv30t076cGDtKjR5np45WF
kyw1n2UVcvxSTlzOKSo5DZoz4FkzWLHBjPMs7TlL+89SobNk5CwePYvEzkLx
M1/8zBU/s8cJaxwYY7guhqkiqDxcEQcRgb/M8ZaZ7jLNWVq2lxYtpXlTaUZf
mtKWJlTlMUV5RFoeEiMDAqSfV+llV7oZ5NqTTgrauYh2zKMdM2jHVOWcd/kb
D/MbD4+8seBSfuPUfeMwn7M7vrZ5v7aGvjNGf9IkrijSv4uz1/lrt1ibd6i7
d+cP7k+d/DlSeNCHPOtG3rYjDc3l5sZy+/tyz5vywIvyyFNk4iEy82eZ8meR
8Wee9+BE/OBI/uhQ/fhA/3Tf9Hzf+nLf8WbP/W7P+3Hf37QfbDsIdx1G+w5j
w0fx8ZPkzGlqMZ+iFtKsUoZXzoiRjBzNqLCMDk8bQcpCJG1nSddZwnMW95/F
gmeR0FkofBaInHkjZ87ImTVyZg5DQxhoQ7gqiMkDqNiHCjwVrrvCciIMG0K1
IEsmZEGPzGmRaTUyqUDGZZVRcWVYgA7y0H421sfE+mho7zLau4T2zqM9s2jP
FNozUTnnW/rGSz/v4Zx3C8+7Zedd6vNO4zcO2zm75ytb8IIp8pMuflmVuipd
uS5cvcXZrKPv3Fvavz979GA8/3Co9LQPed2FfGhDPjcjbY1I1wekvx4Zfo2M
vUCmniJzjxHK4xLzSYH3NC96diJ7fqx6eax7fWSsP7K8P7R/PHR+PnS3Hnk7
j/y9x8HBk/DoSWTyNDqbjy0V4rRSglVO8JCkqJKUokklntCAhB7GjUTcSsTs
ZzHXWdRzFvGdhfxngcCZL3jmDp45goQ1SBgDhC4ANX6g9AGZFxe7MaEL4zlQ
tg1lWFCaCaXo0UUtOq9GZxTolAydEKNjQmyEhw1zsGEWNkTHhqjo4BI6uIAO
zKED0+jABDowVjnnn//Gt3zey/zWw//WLfnWpfzWpf/WaTnvcJ2z+7+1RH40
xC5rklflmevi1Vu8jTrW9j3q3p8Lhw+nTx6NFR8PIi97kXddSGM70tKCdH5G
ej8ig++R0Xpk8jUy8xKZf44sPy8zX5R4rwqi13nZ27zy3an2w4mh8cTcdGJt
PXF0nLi6Tz39p77hvH88H5wqhOaK4aVShFaOspAorxITojEJFpPjURWIamHE
QETMRMRGRBxE2EWE3GcB75nPd+bxES4/YfcTFh9h9BE6L6H2EAo3lLmA2AmE
dpxnxdlmjGnEaHpsWYstqbF5JTYrw6cl+JQQJ1ftcbFxNrkhbYyGjVKwkUV0
ZA4dmUGHJ9HhcXR4pMrVzHn/4rc++gUv54JHdMEtv+DSXHCavnU4zju839jC
F02xX3TJq6rMNWnulnC9jrN1j777gHLwcO748WT+yWjp+SDytg9p6EaaOpD2
VqS7Cen/hAx/RMY/IFPvkLl6ZPFtZflNhfm2zH1XEr4vShuKyk8FTVNB35o3
duQt3QVbX8ExWHCNFj0TRe9MyT9fDlDKQRoSYlVCXDQswMJiPCwDISUMaYiQ
nggZiZCFCNmIoIMIOAmfi/C6CbeHcHoIu4eweAijm9C5CbWLUDih1A7FNiiw
AJ4ZcIyAqQd0LaCqAUWJL8rxBSk+J8JnBfgMj1xOOMXEpujY5DI2sYRNzKPj
s+j4FDo+gY6NomNDlXOByfP++W/9yxd8rO+8/O880u/cqu9chgtO67cO93l7
8HtL9GdD4jdN+poie0u8VsffvM/aeUDbf7R49GT2lPyF5gjyepD80fTnHqS1
E+lqR/pakaFmZPQzMvmpMvOxstBQoTRUaB8qzIYKtxERfipLm8uK1pK6vaTr
Khl6S+aBknW4ZB8rOafKrtmyZwHxUio+esXPQv1cLCDAA2IQkMKAAgbUREBH
BAxEwEQELITfRvjshNdBuJ2Ey0U4XITNRVhchNFJ6J2ExgGVdii3QokFisyQ
bwRcPWBrAVMD6CpAU+DLUpwixheF+AIfn+ficyxsloHN0rAZCja9iE3PkVvm
pibRqTF0chidHEDPBcfOB2a+9S9956N/5+N+7xV971F879Z97zJ/53RecPgv
2CKXTPFfdalrqpWbstU60fp97tYD5u4j6sGTheNnM/nnE6WXI8i7IaSxn1z1
0NGN9HRWBtorI22VidbKdEtlrrmy2FRZbqrQmyqsJpTbjApbK5IORN6FqHoR
bT+iH0JMo4hlArFOV+xzFeci6lpG3XTMw8I8XNzLB14R9EqhTw59KujXEn49
4TMSPjPhtRBeK+G2ES474XQQdgdhdRBmB2G0E3o71NqgygoVFigzQbERCvWA
rwNcDWCrAEsBGDKcLsGpInxZgFN4+BIbX2RiC3RyB+b8EjY3j83NorNT6Ow4
OjtC7p2b6UPPhUbOBycvBOa/81O/97EuegUXvbKLHvVFt/Giy/6903PBEfrR
GrtiTP6hTd9UZuska/cFmw85O48Z+0+Xj54vnL6YKbycKL8dRRqGK02Dlbb+
Sncvuc9nuKsy1lmZ6qjMdlQW2iuU9gqtHWV2oJwOlNeJCrtQSQ8q70eVg6hm
BNWNo4ZJ1DSDWuYx6xJmp2IOOu5k4U4ucPGhWwQ9UuiRQ68KejXQqyO8BsJj
JDxmwm0hXFbCaSUcNsJmI6w2wmwjjFaot0KtBarNUGmCciOU6qFYB4QawFcD
nhJw5IAtBUwxzhDidD5O4+JUFr7MwCg0bImCLS1ii3PYwjS6MIkujKHzw+j8
ADrfi54LD54PjV8Izn4fWLroZ/zg4/3gFf/oUf7o0f/gtvzgcl10Bn6wRy+b
E7/rUzfVK3fkq/fFGw/524/Ze88YB8+Xj18u5F/PFN9MIu/HK59Gyb00nYPk
4qPB/spoX2WitzLTU5nvQZd6UGoPyuhBWb0otw8V9GOiAUwyhMlHMOUYpp7A
tdO4fhY3LuBmCm6hAisD2FjAwQVOAXSKoEsK3XLoVkK3Grq10K0n3AbCbSRc
JsJpJhwWwm4hbBbCYiHMFmi0QL0Z6sxQY4IqI1TooUwHpVogVgOhEggUgCcD
XAngiHCWAGfycAYbpzNxGh2jLWPUJWx5HluexShTGGUcXRpBlwbRpT50sbvK
Vd/58MiF0NT3wYWLAdoPfvaPPuFPXvlPHs1PHtOPbsePLu9FZ/hnW+yqKXlD
l7mjyt2XrT8UbT3h7zxj77+gH71aPnmzUHg7W6qfqnycqDSPVzpGKz0j5PKx
4aHK+CC5DHBuAF0cQJcHUPogyhxEOUMYbxgTjmDiMUw6jikmcdU0rpnFdQu4
fgk3LgMTHViYwMoBNh6wC6FDDJ1S6JRDlxK61NClgS4ddOmh00A4jYTDRNhN
hM1MWM3QYoZmMzSaoMEEdUaoMUC1Hip1UK6FMjWQqIBYAYQyIJACvhjwhDiX
j7O5OIuFsxg4k4YxKBh9EaPPYbQZjDaJUcdQ6jD5tpd70eUu9OtI9/nw0IXQ
xPeh2R+ClB8DzJ/8/Es+ySWv6pLHcMljveR2/+QKXnJEf7MmrhvTd7TZe8q1
h7KNJ6LtZ7y9l+yD14zjt8un9YvF93PlhpnK56lK22Sla5zc0jY0RnaQyep5
H0EXRlDKCEodRRmjGHsM445jgglMNIlJpjH5LK6cw9ULuGYJ1y3jBhowMoGZ
DSxcYOUDmxDaxdAhhQ45dCqhUw2dGujUQqcOOvTQYYB2IwmbCVpN0GKCJiM0
GqHBAHUGqNVDjQ6qtFCpAXIVkCmBRA7EUiCSAKEICAQ4n4fzODiXiXPoOJuK
s5bIcS5zFmNMYYwJjDGK0odQej9K70FpHejX0c7zkf4L4dGLoekfQos/BemX
Apyf/aJffIpfvNpfvOZfPM6f3b5LrsgVe/yaOXXbsHJPk3uoXH8i3Xou2nnJ
23/DPqxnnLyj5j8slRoWkE+zlap16pyu9E6hg5PoyCQ6MYFOT6BzE+jiBLo8
gdInMdYUxpnC+NOYcBYTz+GyBVyxiCspuJqKa+m4ngEMLGDkADMPWATAKoI2
CbTJoF0O7UroUEGHBjq00FHjyl6FAdoM0GqEFiM0G6DJAI0GaNBDvR7qdFCj
hWoNVKmAQgnkCiCTAakESMRALARCPi7k4gI2zmfgPBrOXcY5ixhnHmPPYOzq
mxzHWCNY9RQwe1FmF8psR7+OtZ2P9l6IDF8MT/4Ymr8UWv45yPolILjsl132
qS97jZe9tssezy/u4GVX7A9b8pY5c0+ffaBZe6LYfC7dfiXae8M/qOccvWee
NtAKjculT4tI8zzaPkdag/5ZdHgGHZ9Bp2bQ2WqpnMEoM+TXu/rg2HMYbx4T
LGCiRVy6hMuXcSUVV9FxDRPoWEDPAQYeMAmAWQgsYmCVQqsM2hTQpoR2FbSr
oV0D7Vpo10Gb/l+wGqDFAM16aNJDox4adFCvgzot1GqgRg3VSqBSAIUcyKVA
JgZSEZAIgJiHizi4kIULGbiAivMpOH8B481h3GmMO4FxxjDOMMbpR9k9KLsT
ZbeiF2Kt38S6vosOXIyM/RieuRRa+iXEuBzkXQmIf/Urf/XpfvVZfvU6r3j8
V9yRq87ETWv6rmnlgX71iXr9uWLrlXTnrWj/Hf/wA/f4Iyv/iVFsopabKZW2
JbRrkdy9ObSAjs2Tu3Bn5rH5eWxpHqMuYIwFjL2IcZew6tsTLeMSKi6j4QoG
rmTiajbQcoCOB/R8YBQCkwiYJcAihRY5tNa4sqmgTQ1tGmjTQpvuX7DqSVj0
Na50JIxaaNBCvQbq1FCrgholUMuBSgaUEqAQA7kQyPhAysUlbFzMxMV08m0I
l3DhAiaYxfjV7/w4xh/FeNW62odyu1FuB8ptQS/Gm7+Nd1yI9V2MjvwUmfo5
vPBLiHYlxP41KPwtIL/q11z1m6767Fe9nt88od888RuOZJ0188CUe6Jbe67e
fKXYfivbey8+aBAcNfJOPrPzzcxiC73cRq10Vr0nBR2koKNLaFUGTy+RumWp
2mWq9ZOCsZYxTvVRUnEhjXyrUiYuZ+FKNlBxgIYHtHygFwKDCBjFwCQFZhnJ
lUUBrUpoVUHrf7jSQqvuX7DUYK7BpK1xpYF6NdSpoE4JtQqgkQG1FKjEQCkC
CgGQ84Ccg8tYuJSBS2i4ZBkXL+KieVw0gwknMeE42XoEg5igFxN0oYJ2VNhS
uRRvuhhvvxDvuRgb+ik68XNk7nJ4+dcw87cQ/2pQ+ntA9UdA/4ff+ofP9bvP
/7s3et2duONI/2nNPjauPtdtvNJsvVXuvJftf5QcfhIeN/FPW7gFctMmE+mk
V3po6AANHaZi41RsiorNUbFFKrZMw2g0jFmtpXScV/3yM3ERi3y+Mg6u4AIV
D6j5QCsEOhHQi4FBAoxSaJJDswJalNCi+hdXVk0N2hr+K1daEiYNNFahhgYV
1CuhTgF1cqCVAY0EqMVAJQQqPlDygIIDqg9IzsBlVFxKwaWLuGQOr/Ya8STZ
oEXDpKoR9WCiLlTcXpG0lq/EP12Kt34f7/ohPvBTbOyX6MyVyNJvYfrVMPeP
kOhaUHEtqL0eMF/3O677vdd8oWve+G1X6k/7ymNL7rlx/bV+s16z/UG5+1F+
8Fl61Cw6aRXk23nFTm6pi430sNB+JjbEIA3pFIN0EAtVvcfAaEycwcTZLJxb
ratsXMjBxVxcWn3Q1Y8gID+LRgS0YqCTAIMUGGXQKIcmBTTXuLKoSfw3rmqw
1EBypSG5MqlJrowqaFBCvQLqZUAnBVoJ+coaIfk4VNXnwgbVU6+g4woqLq/W
zAVcNovLpjHpBCYdJbWfpB+T9qCyroq8A6masquJxsuJlp8SnT8k+i7FR36J
Tf0aXbgaof4eYV8LC66HZDdC6htB482A7WbAfdMfuOGL3vIm77syj+3Z55bV
16aNev3WB+1Oo2rvs+KwRXbcJjnpEOW7BMUefrmXi/Rz0EE2NsrGJtnYDBub
Z2NVN0Gtaj8OzuLgHC7ZtYU8XMzHpQKyjChE5DFRS4BWCnQyUP2MBjk0KqBJ
CU0qaP6bKw2J/8qV5T/QkFyZ1SRX1b83Ksn/W32F6uvoqy8oJr+uWgF5zDVc
UK2NKiauouHKamdZwhXzuGIWl0/h8nFSIcsGsaqtUPRWlFUv1lFWtxWvJRqu
JpouJ9p/SvRcSgxdjk/8Gpv7PUr5I8q8HuHdCEtuhpW3QrrbQcvtoPN2wHc7
EL7tj9/zph+5Vp7bV19b1+tNmx8M243a3Sb1fqvysF1+3Ck97ZYUekWlfmF5
gF8Z4qEjPGyiauS52BwPX+ThyzyczsOZfJzDx3kCvKpzREIgEZEdqlp4q+W3
Wliq5UUrB3oFMChqH1lV40pN4m+u/ibn/6ar9k/kn9X+3lTjqvq1NMjI41w9
1NUyqBOQvaPaQTQsoGEANQ1XL+OqRVw1jytncOUUrhzHlFU3MYSqBirqXkTT
XdZ2lnRthZvJD9eSn68m2y4nuy8lBi4nxn6Lz/weW7oWo9+Icm9FROR2nbC2
LmSqC9nvBj13g8G6QLQukHrozTxz5V7Z1+qtGw3mrU+GnWbdXqvmoEN11KU4
6ZHn+6SFAUlpSIyQq/KF6LgAmxLgcwJ8UUDaVZoQZwpxthDniXCBGIjEQCIB
MgnZ05UyoJIDTbXCKEC1LFcLTrXskFypycNlruE/X6T/dgz/5rB2SKtcVc9s
FdXDa6qe4upZlpDNwiAkO6yeB3QcUpxoGUBLwzUUXLOIq6t6eAZXT+LqcUwz
imqGKtoBRNdX1veUDJ1FY3u+Lvn+VvLT9WTr1WTX5WT/leTI1cTUH/GF6zHq
zRj7dlRwJyq7G1HfCxvuha33Q677Id/9YPh+MPHAn37mzb5yrdY71husm5/M
283G3Tb9fqf2sFtz3Ks67VfmB+XFYVl5VIqMSyoTYmxKhM+K8AUxmYTQqr5V
jLMleNWX8asqWgrEVZUoA3I5UMpJLVRVRFol2cX01ZpTKz4mzb+50v7/ufq7
iP3NFVnZlGRHMFf7ggyaqg2i2iZEpA4x8IGBCwwcoK8KOQbQUYGOgmsXce0c
6Um1k1jVyOtGK/phxDBYNvaXjD1FU1fB3J6/n3pXl2q8lWq5nuq8muq7khy+
mpy4lpi7GV++HWfeifHvRiX3osr7Ed2fEfODsONB2PswFHwYij0IpZ76V155
c/XutQbH5mfbdotlt92032k46NEf9WlPBjSnQ6rCiLI0pihPyJFJGTotxWal
ZLxGkeJUKc6Q4uyqh5UBvgwIq9ZDDqQKUlpXBbaqKodUQKMi1VG17xv+7msa
Ugz83elIomqN7//liuySarJdkn1TQYqNKldmKazqtKpaM1U1W1W5cYGRDQxM
YKADAxXoKbi+akXncP0MZphCDROocaxiGkFMg2Vzf9HSW7B25W0dpw9S9fdT
H+tSzbdTHddTvVdTg7+nxq8nZ28llu4kGHfj3HsxEbk2Lap5GDU+itgeR9yP
w/7H4cjjcOJJKPMqkK33rjW4Nz47t1rsO+3WvS7zQa/xsN9wPKg7HdbmRzXF
cXVpUlWeVlZmFOicApuX40tynCrHGXIyR+IqAF9B2n+xEkiVQFY1IyqgUgO1
Gmo0pOqu6klDTS9VYfq3gvoXUf/Bf6Xr31yRYqwqyarCrCrPqmpWDM1VZVv1
Anxg4gITG5iYwEgHRiowUoBhATfOY6ZZzDSNmicr5nHEMlK2DpVsA0V7b8HR
fersOHmcfvsw3fBnuuluuv12uud6evCP9OiN1PTt5GJdknYvwf4zLnwYlz2K
qR/HDE+ilqdR57Oo71kk9CwSexZOvwxl6wOrDb71z57NVtd2h2O327bfZzkY
MB8NGU9GDafj+sKErjilLc9okDl1ZV6FLqqwJSVOVQK6ErBUgKMCfBUQqsjA
RKoGMjVQaIBSQ5q4qpXTVrW3ljQsxhr+D1f6/8YVqd5r0pTUqJqasFfVRH6N
q6o/Il2SGFpEpMG08ElXXvXm5qpDpwMTFZgouHkRN89jllnUMl2xTiK28bJt
tGQfLjoGC86+vKvn1N15/Cz95kn6w6P05z/TbffS3XfSAzfSIzfTU3dS83dT
1PtJ1oME/1FC8iSufBrXPYuZn8fsL2KeF9HAy2j0ZTT5MrJSH8o1BNaafBut
nq1O106Pc6/PfjBoPRy2HI+ZTyeM+SlDYVpfmtWX53XIoraypEGXNRhVjdPV
gKUBHA3ga8gUTqwBUi2QaYFCC5VVw6sjIwJtzdYZahbPWPN65pqXsej/5WtI
M/hvp/M3XaRVVJO28W+ubHLSd9ukpAGv2nCrkMwurFxgYZOxj4UOLFRgoeDW
Jcy6gNrmKvaZin0KcUyUnWMl10jRNZh39596ek+8XccvM6+fZ94/zXx+nGl7
kOm6l+m/kxm5mZmoS8/dS1MepJiPkrwnSfHThOJ5QvsiYXwZt72Ku17H/K9j
4Tex+Jto+m001xBeawputPm3Or07Pe7dftf+kONwxH40bj2ZtJxOmwuzpuKc
sbRgQJYMFYoepeowmg5naAFLCzg6wNMBoQ6IdUCqAzIdGc2p9GTupNFDnR7q
DWTAYqwFCFWYax65iqpZtv7bOFdNNAltDX9zVaPLXvXaCmiXQbsU2iXQJoI2
IbTxgY0LbGxgZQIrHdhouG0Zs1MwxyLqmK84ZxHndNk1WXKPFz2jBe9Q3jtw
6us98Xcfvcm8epV5/yLz6Vmm9Umm62Gm/35muC4zcTczez+z9DDNeJziPk2J
niflL5PqV0nD64T1TcL5Nu6tj4fexWPv4ql3sWxDdLUpvN4W3Ozyb/f6dgc8
e8Pug1Hn0YTjeMp+OmPLz1kLC5bSorlMMSFUY4VmROkGjGnAWXrA0QOeHggN
QGyAUgOUGaDCAFUGqDaQSZ3OCPVGaKhFUiYjNNeClyqsRpIrWw32v5MZXS2l
0daggQ51Lb1RQoeCDL7I+EtCZoZ2IbTzgZ0L7BxgZwE7A3fQcQcVc1JQ11LF
tYC45xDPTNkzVfJOFH1jBf/waWDwJNh3HOw5ql959Xbl3euVxpcrrc9Xup6u
9D1aGf5zZfzeysyDzOKjDP1pmvM8LXyZkr5Oqd6k9PVJ87uk433S8z4R+JCI
NCQSDfFMQ3y1KbreFt7sCm31BXYGfXsj3oMxz+Gk63jaeTLryM/bC4u2IsVa
WraUaZYK3YwyTRjLhLFNOMcI+EYgNJLjA6mRzMYVRqgyQbUJak1QZ4L6Wshp
NEGTCZpraZ61xpWtBruBhMNQy/1qdJExoKYWCapq2aCCDFSdMuiUQKcYOoTQ
IYAOHnBwgJMNnEzcxcBcNMy9jHooFc8i4p0v+2ZLvumif7IQGM8HR05DQyfh
/uNw7+GH7Mv32Xf12cY32ZZX2c4X2b5n2eHH2fEH2emHKwtPVmjPMuyXGcHr
tORtWlmf1pFrtFP2hpT7Y9LfmAw3JuOfkulPiWxTYq09ttEd2eoL7QwFd0f8
++O+wynv0Yz7ZM51uuDMLzmKy/YSzV6m2xCmtcKyomwLxrXgPDPgm4HQDMVm
KDVDuRkqzFBlhhoz1NYyc70ZGs3QVAuHzbWU2GoiU9Aq/k5EHcYaVwbo1JNh
qbNGF5kzq6FLVYud5dAlIxN7lxi6RJAM8HnQxQUuNu5m4R4G5qGjXmrFu1zx
LSH+hbJ/rhSYKZJT3Yl8ePQ0MnwcGTiK9h02Zl9+zNZ/yDa+y7bUZzvfZPte
ZYeeZ8efZKcfZReeZqkvVlivVvhvMpL6jOJ9RtuQNn5MWxvTrk8p3+dUqCkV
a04lm5MrzcnV9sRGd2yrP7o9FN4dDe1PBA6m/UezvuN57+miJ09xF6iuIt1Z
YjgQlr3CtqNcG8azYXwrLrACoQWKLVBqgXILVFqgygI1FnIQo7dAQ23WYLJA
swVaLNBqhjYShN1MxuyOKoxk6u6scmUgQ3gyiv83V25VbZyhqM01pNAtIUdC
bgF084GbBzwc3MvGvEzMx0D9tIqfipAz3MVScL4Ymi2Ep/PkhYGxk+jIcWzw
KN5/2JR78SlX35hr/Jhr+ZDrfJfre5sbep0bf5Gbfpabf5Zbfpllvsny6lfE
71fkDSuaxozhU8balHE2p70t6WBrOtKaTrSlM22pXHtqvSexORDfHo7ujkX2
JkMHM8HDucDxgv+E4jtd9hZoniLDXWK5ymwnwnVWeA6U78AEdlxoByIbkNig
zAblNqi0QbUNamxQVxtdGazQaIVmK7RYiSqstXmN3UJy5TCTQxyniYTLSLgM
JNx66NbVZj0acujjUUGPgpyXeWTQI4EeMfQIoUcAvHzcx8V9HMzPQgNMNECv
kJPu5XJoqRReKEbmCtGZfHTqNDZ+Eh89TgwdJQcOWnIvmnP1TbmPn3MtjbnO
hlzfh9Whd6vjb1anX63Ov1ilvM4x6nPc91lRQ1bemFV/XtE3rVhaVhytGU9b
JtCeCXdk4p0Z8i50Z3qtJ7U5kNweie+Mx/amovuz4cP50NFS8GQ5cErz5xm+
AtNbYnvKHDfCc1f4LlTgwoROTOzAJQ4gsUOZHSrsUGWHajvU2qHODg12aLRB
U23qZ6mN/2xWwl6Dw0I4LSRXLjM5+XKbyBGY20B49DXooEcLPRqSK68SehXQ
KyMHsl4x9IqATwj8AtzPwwNcLMhGg6xKiIGE6UiYWo5QStHFYmy+EJvNx6dP
E5MnybHj1MhhevCgffVF22p96+rHltWWptXOz6t9jatDDavj71en61fnX69R
3qwy3q1yG3Kixpzsc07dnNW3Zs1tWXt71t254u9aCXetxLpXUj0rKz2Z1d7M
5mB6azS5M5HYm47vz0UPFyJHlPAxNXRKD+aZgQLbX+T4Sjxvme9FBJ6KyI2K
3ZjEhUtdQOYEcidUOKHKATUOqHVAvYMwOAijgzDbCYudsNoJm50cmNpt5OTU
WRuhuiwk3GYSHlNtwGogvHqCnLdqCXLwqian1T5FbWwthT4J9IuBXwQCQjzI
x0I8jLwywa5EWEiEUY7SyrHlUnypGF8oJOby5O2mqZP0+FFm9DAzdNC19rxz
rZ5cdbjW0rrW2bLW17w29HltvHFtumFt/v0apX6N8WGN07gq/Lwqa15VteZ0
7TlTR87WlXN1Z3092VBvNtqXTfZnM/0ruYGVjcGVrdH0zmRqdya5Px8/WIod
LUePaZETRjjPChU4wSI3UOL7ywI/IvJVxF5U4sWkHlzmxuVuoHBBpQuqXVDj
InS1OwlGJ2FyEmYnYanN320Owm4nHHbCWYWNcNkIt5WEx0LOoL1VmAivkfAZ
CJ+e8OkIn5bwaQi/GvqV0K+Afhkk70VIQFCMh0R4SICF+WiEh0Y4lSgbiTHL
cXopTismlgvJpUJqIZ+ePUlPH2cmj1bGDrPDBz1rz7vX6rvWGjvXWjrWOtvX
+trWh1vWx5vXpz+vLzSuL39YZ3xc53xaEzavSVvXVO2rus5VU/eqrWfV1Zvz
9eWCA7noQC4xmEsP5XJD2fXh7NbYys5UZnc2tb+QPKAkjqjxY3rshBk9ZUcK
3HCRHyoJgmVRABEHKhI/KvVhMh8m9+IKL1B6oMoN1W5C6yb0bsLgJowuwly7
zmF1ETYnYXcSDgd5daEKl51w28nLDB4beauBvNtgJi85+EzkbQe/gbz24NcR
fi1B3hhREQElDMhhUAZDUhCS4GExHhFhUQEa5Vdi3Eqcg8RZ5QSzlKQXU9RC
ipJPL55m5k9WZo6zU0e58cPVkYP+9ed96/W964096y3kRs31vs714Y71ibb1
mdaNheaN5c8bjMYNTtO6sHVd2r6u7FzTda+ZetdsfWvOgVXv4GpwaJX8+cbI
anp0NTuaWxvLbY7ndqazu3OZ/cX0wXLqkJY8ZiZO2PFTbizPixYFkZIoXBaH
EEmwIgtW5AFU4ceUflzlA1WovVDjIXQeQu8hjB7C5CHMbsLqJmxuwl67CeOs
wkm4nITbQXiqsBPeKmyEz0r4LIS/CjPhNxEBY+06jZ4IaImghgiqiaCSCClg
SA7CMhCR4lEJHhVjMSEaF1Ti/EqCiyQ55RSrlGIU07RCZjm/snSaXTjJzh3n
po9WJw/Xxg7+N/HiIRU=
           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}, 2]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->1887807719,ExpressionUUID->"5be79c29-73a6-4c63-aaef-a956a0b6b778"]
}, Open  ]],

Cell[TextData[{
 "Use, from right to left, the formula for the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"cos", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"20bd65be-6000-454b-98c4-f7947aa07658"],
 ":"
}], "SolvedExampleNote",
 CellID->239142860,ExpressionUUID->"d0008120-bebb-4ad4-8768-c0ce9f8ac2e4"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      FractionBox[
       RowBox[{"cos", " ", "z"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}], "2"]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", 
      SubscriptBox[
       RowBox[{"\[ImaginaryI]", "[", 
        RowBox[{
         FractionBox["d", 
          RowBox[{"d", " ", "z"}]], 
         RowBox[{"cos", "(", "z", ")"}]}], "]"}], 
       RowBox[{"z", "=", "1"}]]}], "=", 
     RowBox[{
      RowBox[{"-", "2"}], "\[ImaginaryI]", " ", "\[Pi]", " ", 
      RowBox[{"sin", "(", "1", ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9ddd490f-3fdf-48f7-ad30-78ae2d3747c0"],
 "."
}], "SolvedExampleNote",
 CellID->136139264,ExpressionUUID->"bec2f3a0-9548-4d4a-9b46-9183356cc704"],

Cell[TextData[{
 "With ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->177479,ExpressionUUID->"6a8b1a07-8a81-40ca-8ec6-44597b86aa83"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->111089734,ExpressionUUID->"71f73c04-daf1-4279-96cf-7ff97f6606f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
  RowBox[{"Sin", "[", "1", "]"}]}]], "SolvedExampleOutput",
 CellID->64337928,ExpressionUUID->"d669345b-0ca4-48c8-93f4-37dd22c2ce4a"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->290432513,ExpressionUUID->"e43606b9-4062-4217-9a8f-7f11b6c4dcf3"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->105821735,ExpressionUUID->"a0e80d68-9410-49bd-a5e4-6bd5cd5ec1ed"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["z", "2"]}], "-", "1"}], 
      SuperscriptBox["z", "3"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"21cda77e-c2cb-4b14-9615-aa1ed5557960"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "88ba6014-adde-4281-913c-5feaca1f7cf4"],
 " is a closed curve around the origin, using Cauchy\[CloseCurlyQuote]s \
integral formula."
}], "SolvedExampleNote",
 CellID->724715829,ExpressionUUID->"da1cadb9-64fe-4d15-a961-25de7b4e1bbe"],

Cell[TextData[{
 "The result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"2", 
         SuperscriptBox["z", "2"]}], "-", "1"}], 
       SuperscriptBox["z", "3"]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox[
      RowBox[{
       FractionBox[
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], "2"], "[", 
       RowBox[{
        FractionBox[
         SuperscriptBox["d", "2"], 
         RowBox[{"d", " ", 
          SuperscriptBox["z", "2"]}]], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           SuperscriptBox["z", "2"]}], "-", "1"}], ")"}]}], "]"}], 
      RowBox[{"z", "=", "0"}]], "=", 
     RowBox[{"4", "\[Pi]", " ", "\[ImaginaryI]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"939d7500-2926-4455-a77c-b7ca2632d9f6"],
 ". Check for the case of a circular contour:"
}], "SolvedExampleNote",
 CellID->33406630,ExpressionUUID->"082d34ba-027c-48dd-ac97-45e0991eb076"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["z", "2"]}], "-", "1"}], 
    SuperscriptBox["z", "3"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->478679220,ExpressionUUID->"085c7968-4963-48c0-af74-10e5a1e24c0d"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->195707251,ExpressionUUID->"ea8d40d1-9e85-4938-a067-97885be0cc5c"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->316889252,ExpressionUUID->"e78cbd57-4341-4329-b8a1-003e5612b7e2"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"6f1af9cb-faf5-4595-882f-434bd0b56970"],

Cell[TextData[{
 "Cauchy\[CloseCurlyQuote]s integral formula permits us to write, for an \
analytic function, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "a", ")"}], TraditionalForm]],ExpressionUUID->
  "dacf73c4-ccca-4d72-8902-883f2f1df6a1"],
 " as an integral:"
}], "SummaryList",
 CellID->155871797,ExpressionUUID->"d9fb3e30-a2dd-438b-958d-22746f048cf6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "(", "a", ")"}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      FractionBox[
       RowBox[{"f", "(", "z", ")"}], 
       RowBox[{"z", "-", "a"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->312760059,ExpressionUUID->"35eca50c-715d-4922-911b-3f41b84f7c90"],

Cell["\<\
Derivatives of an analytic functions also can be written as an integral:\
\>", "SummaryList",
 CellID->470955442,ExpressionUUID->"ca47861d-7fed-43e3-88db-2f78e0291965"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox[
     SuperscriptBox["d", "n"], 
     RowBox[{"d", " ", 
      SuperscriptBox["z", "n"]}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "!"}], 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      FractionBox[
       RowBox[{"f", "(", "\[Zeta]", ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Zeta]", "-", "z"}], ")"}], 
        RowBox[{"n", "+", "1"}]]], 
      RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->173794401,ExpressionUUID->"2d8ce16f-bd6a-41a4-8e5a-46911ea0a4cc"],

Cell["\<\
You can read Cauchy\[CloseCurlyQuote]s formula \[OpenCurlyDoubleQuote]right \
to left\[CloseCurlyDoubleQuote] in order to compute a contour integral.\
\>", "SummaryList",
 CellID->207209504,ExpressionUUID->"8261ff34-cb79-4419-ab92-ae02d167ddcf"],

Cell["\<\
An analytic function is differentiable an infinite number of times.\
\>", "SummaryList",
 CellID->97037780,ExpressionUUID->"c36df98d-14a7-41f6-833a-21a386bbe185"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->50506963,ExpressionUUID->"dfb1725e-390f-4ca0-9a36-ffe59adb3041"],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{"z", "+", "1"}], 
      RowBox[{"z", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"59a96b4e-ea58-4874-8f86-46042a5805df"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "cca6e387-67fa-46b6-bdb6-15efbef41500"],
 " is a curve surrounding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ea84f70b-c6b0-4955-beb1-a0a7a9f4dc1e"],
 " using Cauchy\[CloseCurlyQuote]s integral formula:"
}], "Exercise",
 CellID->385112845,ExpressionUUID->"82ea1fe5-de07-4dae-9224-ae9f03d06927"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", "-", "1"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Arrow", "@", 
         RowBox[{"BSplineCurve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.5", ",", 
               RowBox[{"-", "0.5"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"-", "1.2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0.5", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "0.5"}], ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"SplineClosed", "->", "True"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"HoldForm", "[", 
           RowBox[{"z", "==", "1"}], "]"}], ",", 
          
          TemplateBox[<|
           "color" -> RGBColor[
             0.33336385093631155`, 0.33336385093631155`, 
              0.33336385093631155`]|>,
           "RGBColorSwatchTemplate"], ",", 
          RowBox[{"LightDarkAutoColorRules", "->", 
           RowBox[{"<|", 
            RowBox[{"\"\<MarkedColors\>\"", "->", "True"}], "|>"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"LightDarkAutoColorRules", "->", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "ExerciseInput",
 CellID->794065569,ExpressionUUID->"d7a91960-2f8f-408b-91ba-b424371965dd"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxc2HdwI/mB6Pcr+x//4yq7ylX2c71nv2ffne98ujtJJ52klbRahd3VbJjd
yYkc5ggwkzNDDoczHOacc845R+ScAQIMIAiCRAY6InUjk5xzo0frd3bVp7u6
+89vdfcv/JfkvLvp/81f/dVfFf13xOlu0svfFxYmld77H4ibB7lFWRm5aam3
covTMtIKf5n83xIPU/9yxK7Rlz3oy170BaGP1I+WEAbQkkHSEFo8hBQPI8Uj
pFGkiDCGFI0jRROkSaRoijSNFM3ARbOkObhoHi5agIsJi3DxEly8DJcQVuCS
VfjFWszLdeTlBvJqAyndRMq2Yl5vI+XbyJsdpGIHebtLQN/toZV76Pt9tGof
rd5Ha/ZdNTRXLc1VR3PV01wNdFcj3d1EdzfT3S10dyvd3Ub3tNM9HXRPJ6mL
7umme3roXkIv3dtH6qd7B2gE3yBpiLDvGyaNEPZiRvewmF1s7P+1g43voC96
yFBkq5I+MhTZqpgwSEA+tioijJChyFaF40jhBGkSKZyCC6dJM3DhLFw4R5qH
CxfgokW4aIm0DBevwMWrMSVEq3X4xQb8cgN+tQmXbhGQsm3k9Q5SvoO82UUq
iFB7Me/20cp9shUNraahNTS0lu4i1NFd9XSyFcPdxHA3M9wtDHcrw93G8LQz
PB0MTyfD00XqZnh7GN5e0sdQsVZ07yDdRxgiWw2TRvb/YnQf+9hqbO8vocY/
+tiKzFXSS7bqQ4v7SbFWSBFhiAw1jBSOIIWjpB9aFUzABZNwwRRcME2agQtm
4YI5uGA+hmhVuAgXLsGFyzFFK3AR0WoNLl6HSz622oRfbsGviFbbcNkO/HoH
Lt9F3uwhFUSo/Zh3NKSShr6noVV0tJqO1tDRWgZax3DVkxoYP7RiuluY7lam
u43pbmd6OpieTqani+npZnp6mH9p1cfw9pMGYshQpGE6GeoHsVD72Ng+GYo0
vvdDq91YqJIeMhTZqviHVkUDSAzZqpDwsdUIUjCKFIwhBeNwDNkqfwrOnybN
wPmzcP4cnD8P5y/ABYRFuGAJLliGC1bgwlW4aC0m1moDfrEJv9iCX27Dr7bh
0h24bBd+vQuX78Fv9uGKfaSChrylIe/oSCUdeU9HqhhoNQOtYaC1TLSO6apn
uhqYrkZSE/PftWK521meDtb/p1UvqY/p7Wd6B5ixVoMM3xBpmGw1QhqlfYSN
0chW+9j4PhmKNLFLQEu6yVY9aHEvqQ8tIvQjH1sVDpKhhpCCYaRghDSK5I/B
+eOkCTj/h1Z5M6RZOG8OzpuH8xag/EUof4m0DBWsQAWrUOEaVLQOFW9AxZtQ
yRb0Yht6uQ292oFLd+GyPfg1YR8u34ff0OAKOvyWjrxjIJUM5D0DqWIi1Uy0
honWstA6FlrPcjWwXI0sVxPL1cxyE1pY7lZWrFUsFKmL5elmeXpY3l6Wt4/l
7Wf9pdVgjG+I6RtmxIyQRukfkaFo2DiNDEWa2PvBx1bdaHEPqZcM1YcQrQoJ
ZKsCAtkqnzAC54/CRKu8cdIEnDcJ503BedNw7gxpFsqdg3LnodwFKHcRyluC
8pahvBUofxUqWIMK1qHCDahoEyregkq2yVY70Mtd6NUeVLoHle3Dr2lwOQ1+
Q4crGPBbBvyOiVQykfdEKBZSw0JiodhoPamB7Wpku5rYrma2q4XtbmW729ju
dra7g+3pZHu62J5utqeH7ellewkfWw2wvIMxZCjSCJMMRRojQpHGaX8xsf+D
PWwyhgxFtioi9MYU9iEx/UjBAGkQyR8iDcN5I3DeKJw3FpM7DudOwLmTcO4U
nDsN5c5AObOkOShnHspZgHIWodwlKJdslbcK5f+7VkVbUPE2VLIDvdiFXu5B
r/ah0n2ojAa9pkPldPgNA65gwm+Z8DsW/J6FVLGQajZSw0Zq2WgdB63noA0c
tJHjauK4mjmulhh3K8fdxnG3c9wdHE8nx9PF8XRzPD0cTy/H28f29rO9A6RB
tneIaMXyDbN8I6xYq1HSGNGKgY0T6DETBNpfTO6TyFbFXbFWRd1kqx60sBeJ
6UMK+mPyB5B8slXeEJxHtsodJZGtcibgnEkoZwrKmYaoMxB1FqLOQdR5iLoA
URch6hKUswzlroC5q2DeGpi/DuZvgAWbYOEWWLQNFu+AJbvgiz3w5T70igaV
0qAyOvSaAZUzoTdMqIIFv2XBlWz4PRuu4iDVHKSGg9RykTouWs9FG7hoIxdt
4rqaua4WrquV627jutu57o4YTyfX08X1dHN/aMXx9nO8AxwyVIxvmE2GYvlG
SWNEKyY2ziRbMchQpEnaD/axKQLZqqiLbNWNFvbEQhUQ+mLyyVZ5gwSYaJU7
DOeOxOSMwjljcM44TJ2AqJMQdQqiTkOUGYgyC1HmIMo8RFmAKIsgdQmkLoM5
RKs1MHcdzNsA8zfBgi2wcBss3AGLdsHiPbBkH3xBA1/SwVI6WMYAXzOhchb0
hgVVsKG3bKiSA7/nwFVcuJqL1HCRWh5Sx0MaeGgjD23ioc08VwvP1cpztcW4
23nuDp67k+fp4nm6eZ4erqeX6+njevu53gGud5ATM8TxDXN8I+yYUTYZKoYM
xcQmCIyYSQI9Zor2g318ah8t6iRbdaGFZKuCnlirfALZKo8wAOcOwrlkqxwC
2Yo6BlPHIcoERJmEKFMQZRrKnoGyZ6HsOSh7HsxeALMXQcoSSFkBqatgDtkq
dwPM2wLyt4GCHaBwFyjaA4r3wRIa+IIOvmSAr5hgKRN8zQLL2eAbNlTBgd5y
oUou9J4HV/Hgah5cw0fq+Eg9H2ngI418tEmANgvQFoGrVeBq47va+e4OvruT
7+7iewixVjxPL8/Tx/P288hWXO8Q1zvMJVtxfKOcWKsxtm+cwMImPmJik0wy
FAObItBJNGyahsd8bNWJFsZaIQXdsVb5PbFWeX2kfiSXbJVDGIKpwzB1BKaO
QpQxiEK2yp6Esqeg7GkoawbKmgWz5sCseTCLaLUEZi8TrQDKKkBdB3I2gNxN
gGiVtwPk7wIFe0DhPlBEA0rowAsG8JIJvGKBpWywjA2Wc8A3XLCCC73lQZU8
6D0fquLDNQK4VgDXCZB6AdIgRJqEaLMQbRGirUJXm9DVLnR1CN2dAndXjKdb
4Onhe3r5nj6+t5/vHeB7B3neIZ53mOcjWo1wfaNc3xgnZpzAxiZIkywSE5ti
kqEY2DSBjsf8u1aFZKuCrlir/O5Yq7zemNw+JLcfJlrlDMRaUclWlBGIMgpl
j0HZ41D2BJQ1CWVNQZnTYOYMmDkLZsyBmfNg5iKYtQRkLQPZqwBlDaCsA9RN
IGcLyN0mW+0BBftAIQ0oogPFDKCECbxgAa/YQCkHKOMC5VzwDQ+s4INv+WCl
AHovgKqEUI0QrhXCdUK4QYQ0ipAmEdIsQltEaKsIbRe5OkSuToLQ3SV0dwvd
PUJPryCmT+DtF5Ct+N4hfqzVCM83yvONcWPGCRxsgjTJjplikZjY9EcMnDBD
J9EIaGFHrFVBZ6xVflesVV5PTG6sFZxD6IepAzB1EKYMwZRhKHskJmsUyhqD
ssahzEkwcwrMmAYzZsD0WTB9DsxYADIWgcwlIHMFyFoFstcByoaTsumkbjtz
dpy5u868fWc+zVlAdxYynMVMZwnL+YLtfMkBSrlAGQ94zQfe8IEKAfhOCFYK
wfciqFoE1YigWjFcL4YbxHCjGGkWIy1itFWMtonRdrGrQ+zqFLu6xO5ukbtH
5O4VefoIQk+/0Dsg8A4KvEMC77DAO8L3jfJ9YwSeb5znm+ASsEkCB5sisGOm
WSQmNsPEZxg/IHPNkq0KCJ1IfmesVR6hG8nticnpjbWikq0ohEE4ewjKHoay
RqDMUShzDMoYBzMmwIwpMH0aTJ8B02KtgPQFIH0RyFgmWjkz15xZ687sTSdl
y0nZcVJ3nTl7zlyaM5/uLGA4C5nOIpazmO18wXW+5Dpf8ZxlfOdrAfBGCFQI
gXcisFIMvheD1WKoRgLVSaB6CdwggZukSLMUaZEibVK0XYp2SFydEleXxNUt
cfdI3L1id5/Y008QeQZE3kGhd0joHRZ6RwS+UYFvTBBrNc73TRB42CQv1mqK
G2s1TWDHzLAIeKwVE59lkOgfoQXtsVb5HbFWeZ2xVrndMTk9MNGK2hdD6Yez
B+DsQShrCMoahjLJVhljYPo4mD4Bpk2CadNg6gyQOgukzQNpRKslZ/qyM2PV
mbHmzNxwZm06srcdlB0Hdc+Rs+/IpTvyGI58pqOA5SjiOIq5jhKe4yXf+Urg
LBM6Xwudb0RAhRh4JwYqJWCVBKyWgrVSqE4GNcjgRhncJINbZEirDGmToR0y
tFOGdslc3VJXj9TdK3X3Sdz9Es8AQewZFHuHRDEjIu+o0EcYE/rGBb4JgW+S
jxGmeDHTXBIHmyEQrdj4LIvEJDHwOQKdQLZqj7XK64i1yiV0ITlEq26Y2gNT
emFKH5wdawVlDUKZQ1DmMJQxAmWMguljYNo4mDYBpk6CqdNAygyQMgukzgOp
i860JWfaijN91Zm+7sjYdGRuObJ2HNm7Dsq+nUqz5zDsuUx7HstewLEXcu1F
PEcJ3/FC4HgldJSKHK/FznKJs0LifCcFKmVAlQyoloG1crBeDjXIoSY53KyA
WxRImwJplyMdcrRLjnbLXT1yV6/M3Sdz98vcA1LPIEHiGZJ4h8UxI2LfqMg3
JvKNC30TQt8k0UqATfGxaQIvZoYbM8vBY9gxcywSk/SXXGhBG5rfhuS3k606
Yq1yiFZdMLUbppCtsgl9cFY/lDkAZQ5CGUNQ+jCYPgKmjYKp42DqBJgyCSRP
AckzQPKsM2XembLoTF1ypq440tYcaRuO9E1HxrY9c9eetWfPptkpdDuVac9h
2fM49nyuvYBnLxLYi4X2FyL7K7GjVOJ4LXWUSx0VMuc7ubNSDlQpgBoFUKsA
65VgoxJqUkItSrhVCbcrkQ4l0qlEu5Roj8LVq3D1Kdz9cveA3D0o9wzJYoal
3hFJzKjYNyb2jYt9EyLfpMg3JcQI04KYGX7MLA+b5eKEOQ6JHTPPIjFJDAKa
3xprlUdoR3I7kBxCJ0IlWnXBlG44uyfWKqsPyuyHMgagjEEofQhKGwbTRsDU
UTBlDEyeAJIngaQpIGnGmTTnTJ53Ji86UpYdKauO1DVH6oY9bcuevmPP2LVn
7tuy6LZsho3CsuVwbLlcWx7fViCwFQptxSLbC7H9pcReKrW/ltnL5Y4KheOd
wvle6axSAjUqoE4F1qvAxgOo+QBqOYDbDuD2A6RThXSp0G4V2qty9Sld/Ur3
gNI9qHAPKTzDcs+I3Dsi844SpL4xiW9c4psQ+ybFvikRNk0QYjMEATZL4GNz
fHyOh89x8XkCh8QmsfAFAhNfYBBirfJaY61yCe2xVlRCJ0zpgrO7Y7J64Mxe
KKMPyuiH0gegtEEwdQhMHQFTRsHkMSBpHEicBBKnnIkzzsQ5Z9KCI2nRkbTs
SF61p6zbUzbtqdu2tF1b+p4tg2bLZNiyWFYK20rlWnP41jyBNV9oLRRbiyS2
EqntpcxWKreVKezlSnuFyvFO5Xh/4Kw+cNaogTo10KAGm9RgsxpqVUPtarhD
DXepkW412qtG+w5c/QeuAZV7UOUeUrmHlZ4RhWdU4R2Ve8fk3nGZb1zqm5D6
JiW+KQk2LcZmCCJsliDE5gQEfJ5P4sVaLRA4JDYZ6mMrJtmqhWzVGmuVQ2iP
taJ0wNmdcHYXnNUNZ/ZAGWSr9H4obQBKHQRThsCUYTB5BEgaAxLHgYQJIGHK
mTDjTJhzJCw4EpcciSv2pDV78rotedOWsm1L3bWm7VvT6dYMpjWTbc3mWik8
C1VgyRVZ8sXWAom1SGYtkVtfKqyvlLYyla38wFahtr9T299rHNUaR+2hs/4Q
aDwEmg7BlkOw7RDqOIQ7D+HuQ6RHg/Rp0H4NOqB2DardQwfu4QP3iMozqvKM
Kb3jipgJuW9C5puU+aakvmkpNiPBZsUxc6KYeSE+L4hZ4JN4sVaLBA6+yCax
CP5Fpn+RgeY1o3ktSG5rDNGK2oZQ2uGPrbI64cwuOLMbyuiB0nuhtD4otR9M
GQCTB8HkYTBpBEgcBRLGgecTzvgp5/MZx/M5x/MFR8KSPWHFnrhmS9ywJW1Z
k3esKXvWVJoljWFJZ1kyOJYsniVbYKGKLDliS57UUiCzFCosxUrLC5X11YG1
TG0t19gqDm3vDu3vj+zVR47aI0f9sbPxGGg+BlqPwfZjqPMY6jqGe46Q3iOk
/wgdOEQHD13DGteIxj2qdo+pPeMHnnGVd0LlnVT6JhW+KXnMtAybkWGzUmxO
EjMvxuZF+AJBiC8I8EUCH1/kkbj4EoGDL7H9MSz/EpNAtmpGcluQnBaE2kq2
aoOz2+GsDrJVJ5zRBaV3Q2k9UGovlNIHJpOtkoaAhBHg+SgQP+aMm3DGTTni
Zhzxc474BXv8kv35iu35mi1h05q4bU3atSTvW1LollSWOY1jTueZMwXmLKGZ
IjZTpeZcuTlfYS5UmYsPzC/UllcaS9mhpfzIWnFsfXdsqzqx15zY67SOBq2z
Sets0QJtWrBDC3Zpoe4TuPcE7j9BBo7RwWN0+Mg1cuQePXSPHXrGNZ4JtWdS
7Z088E6pfNNK37SCgM3IsVkZNifD5qXYvARbkOALYnxRRBLiSwISH1/iEfxL
XP8Sx79MYPuXWR9zoXlNaC7Rqpls1YJQWslWbXBWO5zZAWd0Qun/tRUYa9UP
Jg2ACUPA82EgfgSIG3M+m3A+m3I8m3HEzdnjFuxxS7b4VVv8uvX5pjVhx5Kw
Z0mkmZOY5mS2OZVrSuObMoSmTLEpW2qiyk05SlOeylSgNhVpTCWH5ldH5rJj
c/mJpUJrrTy1Vp3aak7tdTp7o87RrHO26oB2HdCpA7t1UO8p3HcKD5wig1p0
WIuOnLhGj93jx+6JI8/kIcE7pfFOq70zB74ZVcysEptTYPPymAUZvijFFyX4
EkGML4nwZYIQXxbgy3x/DM+/zCV9bEXmWiZaNaK5TUgOoRmhNiOUFiS7Fc4i
tMGZ7XBGB5TeCaV1QandUEoPmNwLJvWBiQPA80EgfgiIG3E+G3U+HXc8nXQ8
nbE/nbM/XbA9W7I9W7XGrVvitizxO+bn++YEuimRZUrimFJ4xlShMU1szJAa
s+SXFOVlzsFlntpYcGgsOjKWnBhfak1lp6ZynblCZ6k8s1SdWWv1tnq9vVFv
b9E72vTODj3QpQd79FDfGTRwBg/qkGEdOnKKjp26xrXuiRP35Iln6tgzfeSd
OfTOaHyzat/cAQGbU2HzSmxBgS3KccKSDF+S4ssSkhhfEeErQn+MwL/C96/w
SFz/CofE9q+wCGgu0aox1orahFCaY7JbYq0yW+GMNji9HUrrgFI7oZQuKLkb
TOoBE/vAhH4gfgCIG3I+G3Y+GXU+GXc8mbQ/mbY/mbM9WbA9WbY+XbU83bA8
2zLH7ZrjaabnDFMC25jINSYJLlNEl6nSy3T5RabyIvvggqq5yD26yD++LNRe
lpxevtQZy86M5XrT23Nz5bm52mCpNVgbDLamC3vLhaPd4Ow0AN0GoNcA9p9D
g+fwsB4Z0aNjZ+i4zjWpc0+duqe1npkTz+yxd/bIO3fomydosAU1tnCALaiw
RSW+pMCX5TErMnxFiq9I8FWJf1XsXxX5V4X+VQGJ71/l+Ve5JI5/lU0iWjWg
OQ1ITiNCbUQoTUh2E5LVDGe1kK1a4fQ2KK0dSu2AUjrBpC4wsRtM6AWe98Va
PRt0Ph12Ph5xPBpzPJq0P5q2P56zPV6wPl62PF61PNkwP902Pd0zPaMb45jG
eM7lc/5FougiSXKRIjekKQ0ZB4YsjYFyZMg5MeSdGgp1F8X6i5fnF6WGy/IL
49sLU+WlqfrSXGe0NBitzUZbq9HeYXR0GZ09l0D/JTh4AQ1fwCMGZMyATJyj
k3rX1Jl7Ruee1XnmTj1zWu/8iXfh2Ldw5Fs8xBY12KIaWzrAl1X4shJfUeAr
cnyVIMNXpf41iX9N7F8TkYT+NYF/je9f45G4/jVOzF9a1aM59Qi1IYbSiGQ3
IllNcGYznNECp7fAaa1QahuU0g4ld4BJnbFWz3uA+F4grh94OuB8MuR8NOJ4
OGZ/OGF/OG17OGt9uGB9tGx5tGZ+tGl6vGN6sm98yrh8xr6I413ECwzPxYZE
2Xmy8jz14Dz9UJ95rM/W6qk6fZ7+vOD8vNhw/vLSUGq8KDddvDVdvjcba8ym
OrO50WJpsVjbzLZOs6PH7OwzAQMmcMgIjRjhsUtk4gKZukCnDa6Zc/ec3j1/
5lnQeRdOvYta39KJb+kYWz7Clg+xZQ2+rMZXDvBVFb6qxNcU+Jrcvy4jSf3r
Ev+62L8u8q8L/esCEt+/zvOvc2Niudj+NaJVHZpTh1DrEQqhgWzVCGc2wRnN
cHoznNYCpbZCKW1QUjuY2AEmdIHPu4G4HuBZn/NJv/PRoPPhsOPBqP3BhP3B
lO3BrPXBguXBsvnBmvnhpunhjvHR/uVj5sUTjuEp3/BMdB4v1Sco9IkHZ8mH
Z6nHZxnas6yzM+r5Wa7hrODyrNiof2HWl5nP31gM76wXVdbLGpux3mZqsplb
bdYOm63LZu+1OvqtziELMGIBx8zwhAmZMiIzl+jspWvuwr1g8Cyee5b03iWd
d/nUt6L1rZxgK8fY6hG+eoivavA1Nb52gK+r/OtK/4bCvyH3b8j8G1L/hsS/
ISaJ/BtC/4bAv8H3b/BiYrk4gXU2Ac2tJVvVIZQ6JLseyW5AshrgzEY4owlO
b4JTm6GUFii5FUpqAxPbweedYHwX8KwbeNrrfNznfDjguD/kuDdivzduuzdl
vTdrvbdgubdsvr9mur9pfLB7+YB28ZBleMQ9fyzQP5Xon8nP4lW6BI0u6fg0
5fQ0/ew003BKuTzNNZ4Wmk5fmHWlFt0b69k7m77Kdl5rNzTYL5scxlaHqd1p
6XRaexy2fodj0O4csQNjNnDCCk1Z4BkzMmdC542uhUv30oVn2eBZOfeu6H2r
Z741HbamxdZOsLVjfO0IXz/ENzT4htq/eeDfVPk3lf5NhX9T7t+U+Tel/k2J
f1Ps3xT5N4WBTUFgkx+zwQtscAMbnMDGx1Y1aE4tSq1FKLVIdh2SVYdk1sMZ
DXB6A5zWCKc2QSnNUHILlNgKJrSBz9vBuE7gWRfwpMf5qNf5oN9xb9Bxd9h+
d8x2d9J6d8Zyd958d9l0d814d+vy3u7FfbrhPvv8AU//SHT2WKZ7qjyN02jj
j7WJpyfJ+pNUw3HW5XGO8bjAdFxiPnllPSm3at/aTt/bdbWOswaHvtlpaHVe
dADGLsDUC1j6ANsAaB8GHKNOYMIBTtmhGRs8Z0UXLK5Fs2vZ5F4xelYvvWsX
3vVz37ret3GGbeiwDS2+cYJvHOObR/7NQ/+W2r914N9S+beV/m2Ff1vu35b5
t6WBbUlgSxzYEpGEgS1BYIvIxQtscgObnJgNNppTjebUoNQahFKDZNciWbVI
Zh2cUQ+n18NpDXBqI5TSBCU1Q4ktYEIrGN8GxrUDTzuBx93Ohz3O+32OuwP2
O0P270dt309Yv5+xfD9v/n7Z9P3a5Z2tizt7hruM83sc/X3B2QPJ6UOF9vHB
ydOjk7jT4+f6o2TDYfrlIcWoyTNriiyHL62HZbajCvtRpeO4xqmtd542AbpW
QN8BGrrBiz7IOACZhyDrCGQbgxwTkHMKBGcAaN4JL9rRJZtrxepetbjXzJ51
o3fj0rd54ds8x7b02NYZvnWKb2nxrRP/9pF/+9C/o/HvqP07B/4dlX9HGdhR
BHbkgR1ZYEca2JEEtsWBbVFgWxjYJltt8QJb3JhYLqJVVSwXtRqhVCPZNUhW
DZJZi2TUwul1cFo9nNoAJTdASY1QYhP4vAWMbwWftQFPOoDHnc6H3c57vY47
/fbvBm3fjVi/G7fcnjbfnjPdXjLeXrv8bsvw3d7590z9Ha7urvD0nkx7X3Xy
8PDosfbwqV6TYFCnXhxkGg+oZlWBRVViPXhlPyh3qN85NdXAYR1w1ASetELa
DkjXDev7YMMgfDkMm8ZgywRsnYLt07BzBgbnIWgRhJcBdNXhWrO7N2yeTYt3
y+zdNvm2L7GdC2znHN/R4ztn+M6pf0fr3z327x75dw/9e5rAnjqwdxDYUwX2
FIFdeWBXFtiVBnYlgV1xYEcU2BEGdgSBbX5gmxcTy8UJbBGt3sdQqxBKFZJd
jWRVI5k1SEYNnF4Lp9XCKXVQcj2U1AAlNILPm8C4ZvBZK/CkDXjU4XzQ5bjX
4/i+z357wPbtsPXbMcu3U+Zv5kzfLF1+s3bx7Zbh2339bebZd7zT78UndxTH
99RH9080D8/UceeqpAtlmlGRbZbnWuSFNvkLu7zMoagAFO9BVS140ACpW+DD
dvi4G9H2IbpBVD+CGsbRy0nUNINa51D7POpcQMFFBFqBkTUI3QBcm073lsOz
Y/PuWn27Zt+eCdu7xPcu8P1zfE/v39P59079+yf+/ePA/lFg/zCwrw7sHwT2
VYF9ZWBfEdiXB/ZkgT1pYE8c2BUFdoUxRK4dfmCHyMUNbH9sVRlDfY9S3iPZ
75GsKiSzCsmohtOr4bQaOKUWTq6DkuqghHrweSMY1wQ+bQYetwIP25z3Oxx3
uxzf9di/7bN9M2T9etTy9aT561njV4uXX60Zvt46/3r/7BvW6Tf8k9vS4+9U
h3eO1HdPVY/1iniDPNkozTBJKBZJnk1c7BC/corLAck7UFoNyephRROibEMP
ulBNr+to0KUdcenG3edT7otZt3HebVl025ZdjlUXsOaC1lFkE0G3INcO6N51
evYc3n2bj2bFaGaMbsTplzjd4Kef+2lnfpouQNcG6CcB+nGAfhigawJ0dYB+
EKApAzRFgCYP7MsC+9LAviSWa08U2CNyCQK7ZKsdbmCHE9gmWr2Lob5DKZVI
diWSVYlkvkcy3iPpVXBqNZxSDSfXQIm1UEIdFF8PxjWATxuBx83Aw1bn/TbH
nQ7Hd932b3ptXw1Yvxqx3Jow3Zox3lq4+POq4daW/hZNd4ut/Up4/LXs8Fu1
+vaJ6t6Z/IlB+vxSnGISZVoEVBu/wMEvAfilIP8NJKhEhDWoqAGVtLhkHW5F
j1s14NEMe47GPdopz9msx7DguVz2mFc91nWPY9MDbLmhbTey40L3EPc+7KGB
XgbgYzgwpg1jWnCmGWca/cwLP9MQYOoDTF2AeRpgagPM4wDzKMA8DDDVQcZB
kKEKMpRBujxIlwVp0iBNEtwXB/dFwX1hcE8Q3OMHdnmBXbLVDjEOvkVz3qLU
tyjlHZr9Dsl6h2RWIhmVSHolnPoeTqmCk6ugxGoooQaKrwXj6sCnDcDjRuBh
s/Nei/NOm+N2p/3rbtutPuufhyxfjpm+nDZ+OX/xxer5F1tnX9JOv+Sc/Fl0
eEuh/vpQeftUdl8veXohTDDxUy3cLBsnx8EuBFgvIFYZzH6Lsqtc3Do3r8kj
aPOIurzSPq98yKca82mmfMezvtNFn37Fd7HmM236rNte+64X2PNC+x6E5nHR
XW4G6mHBXjboYzsxjgPn2HCOxc8x+TmXAfZFgH0eYJ8F2LoAWxtknwTZx0HW
YZClCbLUQaYqyFQGGYogQxakS4N0SZAmDtLIVvuxVsE9XnCXG9zlBHeJVhVo
TgVKrUApFWh2BZL1Fsl8i2S8Q9LfwWnv4JRKOPk9nPgeSqiC4qvBuBrwaR3w
uB540Oi81+S80+K43W7/utP2ZY/1iwHLFyOmzycvP58z/GlF/6ct3Z9o2s85
R1+I1V+qVH8+kX13Jn5gEDwzchPNrDQbI9tBzwVpRfD+S2S/3LX/zk2r9jAa
vMwWH6cD4/VgwkFcMorLJ3HVLH64gJ+s4Lp13LCFG3cxyz5mp2NOpg9i+RCW
18XyujluLxf18WCMD+J8J863+/lWP98c4BkDvMsg1xDk6oPcsyD3NMjVBrnH
Qc5RkKMJstVB9kGQpQyyFEGmPMiUBhmSIF0cpIuCNGGQJgju84P7vOAeN7gX
a+XKfYPmvEGpb1DKGzT7DZr1BsmsQDIqkPQKJO0tnPIWTn4HJ1VCCZVQ/Hso
rgp8WgM+rgUe1DnvNTi/b3LcbrF/1W77ssv6ea/lT0OmP45f/nHW8Idl/R82
T/9AO/4D9/CPUtWf1PI/a8Xf6fkPL9jPTIwk6366Y5cCbufBW8Xo5iv35hvv
ZqVvqxbbacT32vy0Lj+zP8AZDgjGA5LpgHw+cLAcOFoPnG4H9Hv+S7rfzPTb
2LiTi0M8DOFjLr7PI/B6hW5MhOIiGBcBfpEjILIFRJaA0BQUGIOCi6DgPCg4
C/J1Qb42yD8J8o6C3MMgVx3kHAQ5yiBbEWTJgyxZkCkJMsRBhihIFwbpgiCN
H6Txgvtkqz2i1Ws05zVKfY1SytHscjSrHM0sRzLKkfQ3SNobJLUCTq6Ak97C
CW+h5++guErw6XvwcTXwsAa4V+e80+C43WT/qsX2Zbv1j92WP/Sbfj96+dm0
4bPFs882tL+jHX3GVf9epvjDoeTPp/zvz9kPjbQ4y26SYzMdXKfAK/mu5RLP
UqlvqQJbrvKv1AfWWwKbnYGd3uD+UJA5FuRMhQRzIclSSLEW0myFTvZCZ/Tg
BTto4gZsgoBT6IfEfkSCuyWYV+LzST2Y1IXLEL8MCkiBgNQRlNiCEnNQbAyK
L0MiQ0ikD4l0IeFpSHASEhyH+IchnibEOwhxVUGOIsiRB9myIEsSZIqDTFGQ
IQwyBEE62YrGDe5zgvtEqzJXThlKoJahlDI0uwzNeo1kvkbSXyNpr5HUcji5
HE56Aye8gZ5XQHFvoafvwMeVwMP3wL1q551ax+16x9dN9i9bbH/ssPy+x/S7
octPJwyfzp/9dl372/3D3/JUn8plnx0LbunY31/QHpm34+1rycBSBjJPdc8W
eKdfYNOv8dlK/1ydf7E5sNwRWOsNbA4Fd8eD9OkQez7EWw6J1sOy7bBqL3JE
j5yywwZe2CQMWSUhpywIyQOoIuBW+r0KHFP6cKXHr0QDSjigBIMKZ1BuC8ks
IZkpJL0MSQ0hyXlIchYSn4ZEJyHhcUh4GBJoQvyDEE8V4ipCXHmIIwuxJUGW
OMgSBZlkKwY/SCdb0T62Ko3JKUWppSilFM0uRbNK0cxSJKMUSStFUsuQlDI4
qQxOfA0/L4fiyqFnb8DHFeDDd8D9SuBOlfN2jePrOvuXjbY/tlp/12n+tO/y
N6OGX8+c/Xr15JM9zSc85a8V4s9OuLf0tDvGrUfWlXjnfAo8lekez/GNFuFj
Zfj4O3yi1j/V7J/tCMz3BpaHAmvjwa3p4N5CiLES4m6EhTthKS2sYkYOOREt
P6oXRYzSiFURdqpCkDqEaoIeTcCn8eMazK/xBjTuoAYJqqHQARBS2UNKa0hp
DimMIflFSH4ekp2FpLqQRBsSH4dEhyGhJiQ4CPFVIb4ixJOHuLIQRxJii0Ns
UYglDDLJVgxekE62orFdea9cuS9dOS9d1Jco5SWa/RLNeolmvkQzXiLpr5C0
V0jKKyT5FZxYCieUwvFl0LPX0JNy8NEb8H4FcPed87v3jm+q7X+us/2p0fq7
VvNvuoyfDBp+NXn2y6WTX+5ofsmV/1Ip+EzLvHW+fce88tgx+xweS3UPZmED
BdjAK3zgLT5Ygw83+Ufb/RO9gemhwPx4YHk6uL4Q3F4J0TZD7N2wgB6WsCNK
XuRQFNVKo3p59FJ1ZVVHnUcR+CTs0oa82hCmDfpP/IETLHjiCR67Qsdw6BAM
axxhtS18YAkfmMKqy7DSEFbow3JdWKYNS49DkqOQWBMSHYSEqpBAEeLLQzxZ
iCsJcchWbGGIJQgxeUEGN8jgBOkfW71w5b5w5ZCoL1DKCzT7BZr1As0sQdNf
IGkvkNQXSPILJOkFnPASfv4SinsFPS2FHpeCD14D98qB7yuc375z3Kqyf15r
+6zB8kmr6Vc9F78YOfvXuZOfb6p/zpH9XMX9nXbv1sXqXevME3A4wdWb5uvO
w7peYl0VeFc13t2I97b7B3r8w4OBsbHA1HRwbiG4vBLc2Azt7oYY9DCPHRbz
IwpxRCOPalVRvebKeHRlOblynl7BZ1H3ecR7HsbPQwF9IKjHQ2fekM4dPkXC
WjB87Awf2cKHlrDGFFZfhg8MYZU+rNSF5dqw7DgsPQxLNGHxQUikCgkVIYE8
xJeGeJIQVxziEK0EITY/xOKFmNwQ0YrBDtJZrrySmNwSV06xi1rsohSj2cVo
VjGaWYxmFKPpRUhqEZJSjCQXI4nF8PNiOL4EelYCPXkBPnwJ3n8F3Clz3i53
flXh+KLS9odq628azL9ou/x5v/5nk9qfrqp/ypL+VMX63enmLePsXcfQU7Qz
yddG9bWUYM1vsOZqvLkRb2nH23r8nYP+nrHAwHRgZCE4uRKc2wyt7IY2GeF9
TpgtiAglEbkiqj6Iao+i59oro+7Kqr92Gq6Ryyu3KeozRfymcPAyFLr0hy98
YYMnokcjZ1Dk1BnR2iMn1sixKXJ4GdEYwmp9WKULK7VhxXFYdhiWasKSg7BY
GRYpQkJ5SCAN8SUhnjjEFYY4P7RicUNMTojBDhGt8otdeUWu3CJXDola6KIU
otmFaFYhmlmAphegaQVIagGSXIAkFSAJBfDzQjiuEHpaCD0uAh8Ug3dLgO9f
Or8pdfz5tf1Pb22fVll+WW/8l3bDT4ZOf7yg/mea5J+V9E91y1+ZR+5B7c98
TZm++iJfTTlWXYVVNeLV7XhND1436G8c87dOBzoXAn0rweHN4ORuaJ4RWuWE
twVhhiTCU0Sk6ujBcfTk9Opcf2W6uLaZrkHzNWK99tiucHs0YI+ErOGwJRAx
YxGTJ3qJRg1w9ByInNkjOmtEa46cXEaODBGNPqLWRVTasPI4rDgMy9Rh6UFY
ogyLFWGRLCyUhgTiEF8U4glDXEGIww+xf2jFZIcYLHd+oYuQV+jKLXDlFLio
BS5Kvis7H83KRzPz0Iw8ND0PTctDUnKR5FwkMRdJyIXjc+FnefCTPOhRPnQ/
H7xTCNwucn5d4vjilf335dZfV5r/pe7yx51n/zih+dGW+Efy3d+eTX9t73jg
rk/1vS/wVbz2va7CShux0na8tBcvH8LfTWA1s1jjEta2hvVsY4P7+DjTP8v1
r4gCW8SyQxniaCKi46hSFz02XOmNVybLtd12DTlvXMCNF7zxQ9ch6CoCRCLO
YNSOR63eqNkVNcHRSyBqcET11qjOHNFeRk4MkSN9RKOLqLUR1XFYeRiWq8My
VViqDEvkZCtJ+L+24oc4vBCHG2JzQix2iMkKMZjuggJ3foE7L99FyM1z5eS5
qHkuSq4rO9eVlYNm5qAZVDSdiqZS0RQKkkxBEinIcwocT4GfUeAnFOghBbpP
Be/kAN/mOb8qcHxebP/slfVXFeZ/rjX8Q8/x3y9K/l689Rv94Ddgbbz3Ta7v
xWtfQTWW04zldvkKBz0l4+6yGVfFIlq1itZvuVr2XF0M9wDHMybwzkp8ywps
6wCnHQWIubZYH1JdEB9T9Mx6ZXRc28FrCL5xozeY6ybgvgm7r6No9AoOXYH+
K6f3yu66ssJXJiB66YgarFG9Kaq7jGrPI8dnkaPTiOYkcnAUUWkiCnVYrgrL
FLFWYmlYJAkLxWGBMMwXhHj8EPfftWKxQkyiVb67IM+dn+fOy3Xl5rpycmKo
VBeF6sqmuLIorsxsNCMLTctCUzPRlEw0KQNJzECeZyBx6fDTdPhxOvwwHbqf
Ad7JAL/NAr7Kdn6eY/9dofUXpaZ/qD77vwblf8Nc+/V543eesmxv7mtfap0v
vcOVOQBTxsHcWaBwyflizVm25Xy7B1QzgEYO2M6HesXwiAydUrkWNZ6NE+++
DuMYcLExoLIEj+1hPRAxQVd29Bpy33i8Nzj2IYR/iOI3176ra0/oGvVfQ75r
wHVlh6+swJXJfnVpiRpMUf1FVHce1Z5FjrWRw+OI+jByoIkoDyIKZayVVBaW
SMNicVgk+tgqzOOFuNwQhxPisENsVojFDDEZ7sJcd0GuOz8nJo/qzqW6cigu
anYMJcuVnenKynRlZrgy0tG0NDQ1DU1JRZNS0MRk5HkyEp+EPEuEnyTCjxLh
+wnQ3UTodiL4dRLwRarjs0zbL/NNf//26P+YXfrEUJbsTa7wPW+HE4YciVPW
5AVz6qopY8tE2TXl0U3FLHMp1/JWYK2R2Jrkjk6Vc0ADjh9Dc6fI6rlr99LD
MnuFNkzp9B+BQT0SMrkjDm8Uwa69gZtA8EMk/OE6/OEmcHWDhW68/mvUew25
rp3wtd15ZbFdGS1XF8bouSF6po+e6qIn2sjRcURzGFGrIypVRKGIyOVhmTQs
kZCthGGhICzgh/m8MI8b4v7/WuXEFFDd+ZSYvGx3bpY7J9NNzXRRM1yUdFd2
misr1ZWZ4spIdqUnoamJaEoCmvwcTYxHE+LQ+GdI3BPk6WPk8SP44UP4/gP4
zn3o9n3o6/vgFw+dnz2z/jh37lcXD1vBOzOG71d1329r7+5r7zO0j1naOO5p
Il+XJjrLlujz5YYXyos3amP1obnpxNKpsw3qHZMXwIIJ2rAiNIeLB3iksE/j
wnWegBEL2f1hOBj1hq8D0Zvo9YcPN//2IXL1IRi6wfAbt+cGQa9B8NrhuLZa
r8ymq8vLK8N5VH8WPT2Nak+ix0eRQ01EfRA5UEaUiohCFiFaScVhiYhsxQ8L
eGE+N8zjhLnsEIcVYjNDbEaIRXcXU91FBIq7MNtdQMhy52e68zLceenu3HR3
Tpqbmuqmprgpya7sRFdWgivzuSsj3pUe50p/6kp74kp95Ep54Eq+70q660r6
3pV425X4tSvplivlC3fGH7wFvw22/GTy5L//pazxd6KFPwh3Phcybom434oF
dyTih1LpM7kiUalKV6mp6sPCw5PSk9N3p2f1Z+dthsu+S9OY2TJnta85nHsg
yIERsct14PFoMd+FH7cFA1A45IlG/NfRyA0R6/rfriMfwsEPfuzG575xITcw
cA3Yr+2WawsxGFxcXeivznXRM230lBhND6NH6qhGFVErIyp5RCmNyCURmTgs
FYbFgrCIHxbywgJumM+Jze24rBDnL608L6ieEgop21OcFVOU6SnK8BSmuwvT
3AWp7oIUd36yOz/JnZfozktw58a7c+PcOc/cOU/cOY/dOQ89Ofc9uXc9ed97
8m97C7/2lfzZV/Y5XvlZoOVXkal/gDj/24L2f3yo+fLTg8LfKRu/UAx+LZ/+
Tr58X7HxWLkbr6KnqNmZGn7ukajkRPr6VPH+7KDh/LDj4qTfpBu3nM/bL9ad
pn3IykEcEjdw4IW1GHrhd1uDXjCMuaJ+7Jp4mYLXN8EP14F/i2Ifgt4POHrj
gW5Q5w1ku3aar+3Ga4vhyqi/utBdnZ9cnR1FTzXRE3X0SBXVKCJqeUQljSiJ
CZwoIhNGpIKwhB8W8cJCTljADvNZYR4zzGWGOYwQm+55RfW8onheErI9L7M8
LzI9LzJiStI9JWmeklRPSYqnONlTnOQpTvAUP/cUx3uKn3mKn3qLH3tLHnlf
PPC+vOd7dcdXdht78zVe+Wd/7eeB1s9C/b+KzP+jZ+9vjar/sHb6P2Uc/cdH
h/e+1lA/07z5Qt30rbr3nnr0sWbmuWYp5Wg963g772S/5JRZfsatOhc2Xkg6
jIoB88G47WjeoV0DzvZgAxs1it0Wpc9+jDv1AcgUQuxhFxL1+K6IP5Qneu29
ufZ+iLo/hNAPfviDD7hx228Q6w1ounZcXtvOr81nV8bTK8PJlf7oSqeJag+i
J8rokSKqkUXU0ohKHFGKInJhRCaISHlhMTcs4oSF7LCAFeYzwzxGmEsPc+je
Mqq3jOIlRilCaZa3NNNbmuEtTfeWpnlfpXpfpXhfJXtfJXlfJXpLE7ylz72l
cd6yZ76yJ77Xj3zlD30V97G3d7H33+E13/gbbgVavwh2/z488uvIwk/w7R9B
/L85P/5fdk7/59qT/5R69Ku4o0cPjrK/P3r19fH728fND467n50MJZ1MZpzO
5eqWi882Xp/vvr+gNxjZ7WZ+n1U8ZpfPOlWr0OEOcsJ06QSec5nvUo2bTwM2
Y9BhDwNwBHJHIfwKCl/B11fwTQT+EAI/BJwfMPsHj/UGNd9AlzfE/N6uv7bo
rk3aq8vjK8PhlV59pVNFtcrosTx6KItqJJEDcUQliigEETk/IuNFpNywmBMW
scNCVljADPMZYR49zKV5y6necoq3PNtbnkXK9JZneMvTveVp3vJUb3mKtzzZ
W57ke5Poe/Pc9ybeVxHne/sUe/cYq3yEVT3Aa+7hdd/7G28HWr8Odn0ZGvhj
ePy3kcV/DWz+xM38kUP6N2fa/8DQ/a/9p/970clfpx//Kfn4yfPjrGcnxU+1
FU+0tU9PW+J13alnQxT9RKFh9tXF0lvjeq15p9VC67Gxhh28KUC0CMk2UNW+
W8P1nkh9Og1+rvNfXgbNtpAFCFvRiAWL2kNRx1XUcR123ATtH/zWD5j5g8d0
47q8gQ03gP7aobu2aq/Nx9fGw6sLzdX5wdWZ8upUET2RRY+k0UNJVC2KHggj
SkFEwY/IiVacCLFcF7PCIlZYyAwLGGE+sS6leSsopGxvRZa3IpPgq8jwVaT7
3qb53qb63qb43ib73iX53iX4Kp9j7+OxqmdY9VO85jFe9xBvuO9vuutv/S7Q
+U2w91Zo6PPw5GeRhU9CGz/H9n+C8H5kU/ztme4/8s7+06zuvzSe/m2u9kfZ
2luZ2mfp2sy008L009cZuqrMs0bKeUeeoa/oYviVcaLCNFdjWW62rXc5doac
9CmQvQTzt1Axwy3new7kvkMNdnLq110E9JbguSOkR8MXWMQYjJiiEdNV2Hwd
NN/4TR+wyw9ewwfX+Q2svwF1Nw7tte342nJ0bdJcXx5cGVRXesWVTn6llUaP
JdEjcVQjiqoFURU/tp2h4EZknIiUHZGwImJmWMQIC+mxzQ4+zfeOQsr2vcvy
VWb6KjNI6b73ab73xJokBatKwqoSseoErOY5VhuH1z3DG57gjY/8zQ/8bfcC
HXeCPbeDA1+HRv4cnvpTZOHT8Pqv/Lv/6mH9FBL9k/Xg7/S6/yzW/+f1s78e
1P1dte5HBaf/mnf6be5pXK4uI++sIP+srFBfWXJe/+qitfyyu9I4WGsea7bM
dNkWBxyr486tOXB/DWbuolyWSyjwSORehQY70OKa88ChKXjoDJ2gYZ0vfBaI
nEfC59GQ4SpguMYNN77zD56zDy7dDXJ6A57cOI9v7EfXFs21SX19qboyKK/0
8qsz2dWpJHoijh6JoofCWKsDfkTFjSg4ETk7ImNFpKyIhBn5SytamL/ve0/x
vc/2VRGyfFWZvqoMX1U6Vp0WU5OC1SRjtUlYXSJen4A3xOONcXjTU3/LE3/b
o0DHg0D3vWDf98HB26HRr8NTX0YW/hBZ+21w+xOM/gs392eg5MdW9T+c6/5a
of8/afq/ndP/3z1n/1R99tMXuk9KdLdLzuJe6DNe6vNLz1+VG96+vaitMrbU
mzqbzf2d1pF+29SoY34aWF4CNzbgnT2ExnaxhB6e3CtU+8QnuPTMLzUHFM7g
ARo69IWOA+GTcEgbCequ/LprXHftO73xaD+4Tj4gxzfg0Y3z8MauvrYeXJtV
10bl9YX86lx2dSa9OhVfaUXRY2H0SBDV8KNqXpRopeREFB9bMSMSRkRMj4jo
YSEtLNj3VVN81dm+mmysJgurycRqMrDadKw2DatLxepT8PpkvCEJb0zEmxLw
5nh/a5y/7am/40mg61Gg90Gw/25o+PvQ2Lfhqa8i819EV38f3vo0sPdrH+tX
LsHPQdlPrZp/NOj+TnP+t7zzv984/9GU/sc9+p/V63/5Wv/b1/rvys/j3pyn
vzXkvb94WXNZ0WCsaTE3dVg6eq29w/bhCcfEHDCzAi5uwav7yCbbtSt002Re
5oGPfYyxz3G+xS8GAjI0qPQFDwIhdSioiQSOovjxFXZ87T26cR/duA4/IJob
SH3jPLixq26symuz4toov76QXZ1Lr/TiK53oSiu8OhFEj/jRQ15UzY0ecKIq
dkTBisiZERkjImVEJPSImBYR7YeF+1gtBavNxuoIWVhdJlafgdWnYw1peEMq
3piCNyXjzUl4S6K/NcHfHu/viAt0PQ30PA72PQoO3g+N3A2Nfx+e/jYyfyuy
8nlk8/eh3d/56b/1cj5Bhb8A5D+zan5yqfvRieHvJYZ/oJ//8+r5TyfP/7Xv
/JPW809rzv9YeX77veFZ9UVa3WVuo7GkxVTeYa7qsTQM2trG7N3TjoEFYHQV
nNqG52jIEtu1KnCvSz2bau/OKUa7xNk2Pw/0C10BiS8o8wfloYAy7D+IYOqo
T33lUV+7D27QgxtYdQMqb5zKG7vixiq/NsuujdLrS8m1QXylF13phFengqsT
/tUxL3rIjWo40QN2VMWKKpkRxcdW9IiE9rFVRLiH1VOw+uyYhiysIRNvzMAb
0/GmNLw5FW9JwVuT/W1J/vZEf0dCoCs+0B0X6H0a7H8cHHoYGrkfGr8bnv4u
PPdtZPlWdP3z8PYfg/u/x5mfeni/QcWfgIpf2A5/Zjz9sd7wI5Xhn/iGn+wb
frZq+OW04TfDhs96DH9qu7jVcHG74fJRkzG51UjpMBf1WMoGrO9GbLUT9uZZ
Z8cS0LsODu7AozRkgo1OCd2zSs/ykXdD79sxYTQ7zoL8XJef7wsIAwFR0C8N
4/KITxH1Kq48imuX4hpV3MDyG1B245Td2GU3Vum1WXJtEl9fiq4Noiu98OpM
cHXKvzrhXR1zo0ecqIYdVbOiB7FWUQUjIqdHZLSIlBaR7EfEexHRHtZAwRqz
CXhTFt6UiTdn4C3peEsa3prqb0vxtyf7O5L8XYmB7oRAb3ygLy448DQ49Dg0
+jA0cT88fTc8911k6dvI2q3o1heh3T8F6H/A2J95+J+ikt+Ayk/sh78wn/7M
YPjx8cVPZBf/8v/UQZfLcZ0LokAf6tadGjxnDgVPEscx22JqVIvNHMcxW8zM
zMzYzIxqUotaatr0QVfd3tv2TP7cqvUEa8P1L/Oufx93/WnA9Zcu11et7u8a
3T/Vei5Ve65X76fXePMbfIXN/vL2wIPug6cDoZcjh28mjz7MnVSvnjZsh9sU
Z926yIAlOuqMTXrjswfxhZPE8jmxGiPWCWKTSuzQ8T0mKoURGTyXobAMn8qS
x9LkkTQZ2ksG95L+vaR3F+/vYPcOdm5j+xaybSLLJjJvIOM6MqxB/SrUrkDN
ClQvQ+USUCxyVwtAOs9dzSXeCBNvBax3/MQ7XuJ9QeJDPvEhj/iYS1TmEFXZ
ZE0WWZtJ1meQDWlU0y2q5Qbddo3uvMp0X2b6L4KhC2DsBzj1LZj9ml74B7Hy
9/j6XyPb/x2W/elY9Z8Hun/3mf/VY/+/Nvf/0bn/Rer+tw33fy66/zzt/tuo
++tBz/e9ngtd+5c69693eNM7fLmdfn53QNIXLBs6uDcWejJ9+GLh+M3aycft
0zp5uFlz1mE677VHBj3RUX9s8jA+c5qYjyQW44llIrFGxTfo2BYT2QbnO/Bs
F53u4pNdfLyTPNxJhnaSwZ2kfzvp3cb729i9hZ2b2LGJbBvIso7Ma8i0hgyr
UL/CXS1D9RJULULlIlAsANk8dzXHXr0TJt4JEu9T+IkPPOJjAVGZT1TlEVW5
RE0OWZtN1mWR9ZlkYwbVnEa13qLbb9Cd1+nuq0zfZWbwIhi5ACd+gDPfMfPf
UEtfE6v/iG/+PbLz17DsL8eqP4d0/xUw/ce+7d9crn8xu/9V4/4PqedPm56/
rHj+Me/5dnr/h4n9n0e9l0e8N4Z9GcP+3JEAfyxQOBEsnT64O3/4aPno1/Xj
Vzsn7+Wn1Zpwg+Gs1Xre6Yr0eaODwdjoUWwiHJ+OxGfjiXkivkTGVunIOnO+
Ac42YXgTnW6h4y18tJU83EoebCaDm0n/ZtK7iT2b2L2BnRvYsY5ta8i6hsyr
yLSKDCtIvwx1y1CzBNWL3NUCUMwD+TyQzQHpHNibTbwXJj6kCIiPfKKSR1QV
sKrziZo8si6XrM8hG7KopkyqOYNqTafbb9GdN+nu60zfVWbgMhj+BYxfgFM/
wrnvmYXvqOVviLWv45tfRXb/fib724nqr4e6/w6a/uyz/pfH+R8Oz7+bPP+l
8fy33PO3nf2v1ve/W9n/cdF7cd57ZdZ3c9afMevPnQ3w54OFiwely6E7a4cP
t46e7R2/VJy81ZxWGsJ1lrMmx3mbJ9Llj/SFooMnsZGz2HgsPhmPzRDReTKy
SJ8vM2erILwGT9fgyTo6WseH6zi0njxYTwbWk/71pHcde9axew0717BjDdtW
kXUFmVeQaRkZlpF+CeqWoHYRqhegagEq5yF7NQdks0A6C/ZmEh+FKUSlgKji
E9U8Vk0BWZtP1uWR9blkYw7VlE21ZFKtGXR7Ot2ZRnffZHqvMwPXwPAVMPoL
mPwZzvwI5v/JLH5PrXxHrH8b3/omuvv1mfwfp6q/H2n/FjL+NWD5i9fxZ4/7
Tw7Pn037f9Xu/0O5/43U+/2O96dN3y/rvqtr/pur/szVQO5akL8eFG8clGyH
bu8ePpAdPVUev9CevDacfrCEqx1n9e6zZt95+0Gk6yjadxodiMSGY7GxRHSS
iMyQ53PU2QITXmJOl8HJCjxeQUcrOLSKD1aTwZVkYCXpW016V7FnFbtWsXMF
21ewbQVZl5F5GZmWkHEJ6RehbhFqF6BmHqrmoXIOKuaAfJa7mkldEZVCokpI
VAuIaj5RwydqeWRdAVmfTzbkkY25VHMO1ZJNtWZR7Zl0Zzrdncb03mT6bzBD
18DIFTB+CU5dhHM/gYUf6aUfqNV/Ehvfx7e/i+59ey7/Jqz6+lj71aHhHwfm
v/vtf/O6/urx/MWx/zez9yu991uN9wel74LMd2nPf23Xf2s3kLkTyN0N8vcO
xNJQiTxUoTy8rzl6rDv+1Xjyu+X0nSNc6Q7Xes8agucth5H2k0jXWbQ3Gh2I
RYYT5+PE+SR5Nk2FZ+nTeeZkARwvwqNFdLiEQkv4YCkZWEr6l5K+5eT+MvYs
Y9cydi5j+xK2LSHLEjIvItMiMi4g/QLSLUDtPHulnoOq1NUsZK9m2CvpNFEt
IqqFRI2AqOUTdXyynkc2FJCN+WRTHtWcS7XkUG3ZVHsW3ZlJd2fQvWlM/y1m
8AYYvg7GroLJy3DmFzh/ASz+RC//SK39QGz8EN/+Z3Tv+3P5d2HVtyfab48M
34TMXwetX/sdX3ndX3n2v3J6v7F6vzf5ftT7ftb6L6v911WBW8pApjKYqzzg
qw7E6lCx9rBcf3jPePTIfPzMdvKb4/S1+/S9N1wVOKsLnTcen7eEI+2RSFc0
0hc/H0ycjRDhcTI8SZ1O0SczzPEsOJqDh/MoNI8OFnBwAQcWkv6FpHcxub+I
3YvYtYgdi9i+iG2LyLKAzAvItIAM80g/j3TzUDsHNXNQPQtVs1A5AxUzQD4N
ZNNAOkXUiIhaIVErIOsEZD2fbOCRjQVkUz7VnE+15lFtuVR7Dt2ZTXdn0j0Z
TF86M3CLGb4JRq+D8Wtw6gqcvQQXLoKln+mVC9TaT8Tmj4ntH2N7P0Tk/zxT
/vNU8/2J/vsj03chy3dB+3d+53c+z3f73u9cvn/afT9Z/RfN/ivGwHVDIE0f
zNIH8/QHPMOByBgqNh2WW47uWo8e2o+fuk5eeE5f+U7fBsIfQ2fVx2d1p+eN
5+etkfOO2FlPPNyfCA8RpyPkyRh1MkEfTzJH0+BwBoZm0cEsCs7hwBz2zyV9
c0nvXNIzj93z2DmPHfPYPo+t89gyj8zzyDSHDHNIP4d0s1A7CzWzUD0DVTNQ
OQ0V05C9mmKvakVEnZCsF5INArKBTzbyyCYe1VJAteZTbXlUey7dmUN3ZdM9
WXRfJjOQzgylgZFbYOwGmLwGp6/Cuctw8RewfJFe/Zla/5nYvJDYuRDb+ykq
/+lc+WNY8+Op7odj4w+H5h9Cth+Cjh8Crh/9nh+93p88/p9d/ksO/1V74IYt
kGYNZlmDedYDnjUksoWK7IdljqM7rqMHnuPH3pPn/pOXwdPXofD743Dl6VnN
2Vn9+VlzNNweC3fFT3sTJ/3EyRB5PEIdjdFH48zhBAhNwoMpGJxGgWnsn8G+
maR3Jrk/m/TMYtcsds5hxxy2zWHrHLbMIfMsMs4iwyzSzyLdDNTOQM0MVE9D
1TR3NQXlU9zVJFEnIutFZIOQbBSQTXyymU+18KjWAqotn2rPozpz6a4cuieb
7s1i+jOZwQxmOB2M3gLjN8HUdThzDc5fgYuXwPIlevUXav0iuXUxsfNzfO/n
qPzniPLCmfpCWHfhxHDh2HTh0HohZP/5wPlz0H0xsH/R7/vF57+8H7jmCdx0
B9NdwSzXQZ7rgOcKiVyhIvdhqefotvfovu/4UeDk2cHJi8PTV8fht6fhD+Fw
9flpXeS0KXraGjvpSJx0E8e95PEAdTREHw7ToVEmNAYOxmFwAgYmkX8S+6ZS
kt6p5P500j2NXTPYOYPtM9g2g60z2DKDTDPIOIMMM0g/g3TTSDsNNdPc1RRU
TnFXk0A2CaQTZIOI1SgkmwRks4Bq4VOtPKqtgGovoDrz6a48ujuX7s1h+rOZ
gSxmKJMZSQdjaWDiFpy+AWevw4WrcOkKWLnMrF2mNi6RW5eInV/ie7/EZL9E
lRfP1RfPtBfD+osnxl+OLb8c2X45dFw6cF4+cF8J7l8N+K4F/Df8gVu+YIYv
mO09yPMe8Lwhke9Q4jss9R9VBI/uHRw/DJ08OTr59eT05enpm/DJh7OTqshJ
XfSkMXbcEj9uTxx1Ekc95GEfdThAhwaZg2HmYAQER2FgDPrHkX8c+yawdyK5
P5H0TCbdU9g5hR1T2D6NbdPYOo3N08g0jYzTyDCN9NNIN4W0U1AzBdVTUDUJ
lZNQMQnlE1A2wV41islGEdkkJJuFZIuAauVTbXyqnUd1FtBd+XR3Ht2bS/fl
MgM5zGAWM5wJRjPAeDqYTIMzN+HcDbhwDS5dBStXmLUr9MYVcusysXM5sXc5
LrscVVyKqC6day6f6S6fGi+fmK8cW64c2a4eOq6FXNdD7hsH+zcPvGlBf0Yw
kBUM5gQP8oMhfjAkOjiUHByWhI4qDo/uHh0/OD5+cnL86+nxy/Dxm7Pj9+fH
VZGj2uhRQ+yoOX7YmjjsIA67yFAPFeqjD/qZ4CATHAKBYegfgb5R5BvF3jG8
P5b0jCfd40nXBHZOYMcktk1i6yS2TGHzFDJNIeMUMkwh/STSTSLtJNRMQvUk
VE1A5QRUTHBX40A6TjaJyWYRq0VItQqoNgHVzqc6eHQXj+4uoHvy6b48pj+X
GcxhhrKZkSwwlgkmMsBUOpy5BedvwsXrcPkaWL3GrF2lN65SW1fJnavE3pW4
7EpMcSWquhrRXD3XXT0zXA2brp2ar59Yrx/bbxw5bh660g7d6aH9zJA3O+TL
DfnzQwFeKCgMHRQeHhQdhsqOQrePD+8dHz48OXx6evhr+PDl2eGb88P3kcPK
6GFN7LA+ftiYCLUQoTbyoIM86KKCPXSwlwn0M4EB4B+EviHoG0beEbw/gj2j
yRT3WNI5hh3j2D6ObRPYOoEtE9g8gUwTyDiB9BNIN4G0E0gzAdUTbBR7NQ4V
41A+zl2Nkc1isiVFRLUKqTYh1S6gOvhUJ5/u5tE9BXRvPt2fzwzkMUO5zHAO
GM0G41lgMhNMp8PZNDh/Cy7egMvXwep1Zv06vXGd2rpG7lwj9q4lZNfiimsx
5bWo+npEe/1cf+PMeCNsunlquXViSzuxpx87M45dWUfu7CNP7pE3/8jHO/IJ
jvzio4DkOFhyHCw/ObhzcnD/9OBROPQ0HPr1LPTyPPQ6EnoXDX2MharjB3Xx
g4bEQRNx0EoG26lgBxXoogM9jL8X+PuArx96B6B3EO0PYc9wStI9nHSNJJ2j
2DGK7WPYOoYt49g8jk3jyDiODONIP45040g7jjTjUD0OVeNsFHs1BuVjUDbG
XrUUpq6oVhHVJqLahVSHkOoU0F18uodH9/LovgJmIJ8ZzGOGc5mRXDCWAyay
wVQWmM6As+lwIQ0u3YIrN8HqDWb9Br15g966Qe3cIPduENIbCfmNuPJGTH0z
qrkZ0d06N9w6M6aFzelhS8apLfPUnnXizDlx5R678489vON9wbFXdOyTnPiK
T/xlJ4GK08Dd0+CDcPDxWfDZWfDFefBlJPg6GnwXC36MBaviwdpEsJ4INpKB
ZjLQSgXaaX8n7e9ifN3A1wu8fXC/H+0PIM8Adg+mJF1DSecwdgxj+wi2jWLr
KLaMYvMYNo0h4xgyjCH9GNKNIe0Y0oxB9RhUjUHlGBvFXo1C2SiUjpKthVSr
mGoTU+0iqkNEdQqpLgHdLaB7+XQfj+5PXRUwQ/nMcB4zmgvGP1/BmUw4lwEX
0uFSGly5BVdvgfVbzOZNeusmtXOT3L1JSG8l5Lfiilsx1a2YJi2qTYvo088N
GeemzDNzVtiaHbblnNrzTp35py7eqVtw6hGdegpP94tOvSWnvvKw73bYf+/M
//DM//g88Ow88CISeBkNvI4G3sYCH+KBykSgJhGoI/wNpL+J8rdQvlba1874
OhlvF/B2g/0e6OlFnj7k7scproGkcyDpGMT2IWwbxtZhbBnB5hFsGkXGUWQY
RXqObhRpR5FmFKpHoWoUKkehYpSN+nw1QqWu2gqpdjHVIaY6RVSXkO4W0j3c
VT+fHuAxgwXMcAEzks+M5YHxXDCZA6az4UwWnMuECxlwKR2tpMG1NLCexmym
0Vtp1E4atZtGStMIWVpCkR5XpcfUGTFtRlSXGTFkRYzZ56acc0vumTXvzFYQ
tvPCDkHYKQy7xGG3JOwpDu+Xne1XnHnvnHnvn/senvueRHzPIr4XUf/LmP91
zP827n+f8Fcm/NWEr5b01ZO+RsrXTHtbaG8b421n9jvAfhf0dENPD3L3IFcv
dvVhZ38yxTGA7YPYNoitQ9gyjM3D2DSMjCPIMIL0I0g3grQjSDOC1CMwRTUC
lSNQMQLlI1DGSV21Saj2Qi5KTHWJ6G4R3SOke4V0nyB1xQzymSEeezVaAMby
wUQemMwF0zlwNhvOZ8HFLLiUgVbS4Vo6WE9nNtOZrXR6J53aTSelGYQsg1Bk
JJSZcXVmXJMV02ZH9dlRQ07EmBsx559bCs6tvHOb4MwuPHOIz5ySM1fxmbv0
3F1+7rl97rl7vn8/sv8o4n0S9T6Lel/EvC9j3ldx79uE933C+5HwVhHeGtJb
R3kbKG8jvd/M7LcwnjbgaQeeDujuhO4u5OpGrh7s7E1JOvqwvR/b+rF1AFsG
sXkQm4awcQgZh5FhGOmHkW4YaYeRZhh9ivp8NQzlw1DGkQ5T7RKqo5DqLKS6
xFS3mO4R0b0iuk9I9wvpAQF7NcxnRnjs1XgBmMgHU3lgJhfO5sD5HLiYDZez
0EomXMsA6xlgM4PZyqS3M+ndTGovk5RlEvIsQpmVUGXH1dlxbU5MlxvT50WN
+VFTQcTMi1gEEaswYhNH7IXnjqJzR0nEWRZxVURcdyLuexH3g6jnUdTzJLb/
PLb/Ir7/Mr7/KrH/JrH/jtj/QOxXkvvV1H4ttV9PexpoTxPjaWbcrcDdBtzt
0NUBXZ3I2YWc3diR0pO092JbL7b2YUs/tgxg8wA2DWLjIDIMIf0Q0g0hLYe9
GoaqYagcZqP+50qaMkR1SKhOCXdVSLNXYu5KlLpiBgXMkIC74jNjPPZqsgBM
5YOZPDibC+dz4WIOXM5GK1lwLQuuZ4HNLGYri9nOonezqL0sSppNyrMJRQ6h
zEmocxOavLg2L67LjxkKYkZ+1CSImoVRiyhqLYzaJFF7cdReGnWUR523o847
Ude9qOtBzP045n4acz+Pe17EPS8TnlcJzxvC847wfCA9laSnivLU0J462l3P
uBsZdxNwNwNXK3S1QWc7cnYgZydydGJHF7Z3Y1tKD7b2YksfNvdjUz82DmDD
ADIMIv0g0g0i7SDSDCE1C6qGoHIIKoagnCMbSkXBvdRVEXvVJaG6C+meQrpX
TPeJ6X4RPSBiBoXs1YiAGU1d8cEEj72aLgAz+XAuD87nwcVcuJyDVrLRWjZc
zwab2WArm9nOpney6b0cSppDyXJJRS6hzCNUeQl1fkJTENfx4np+3CCIGYUx
kyhmLoxZJDFrccxaErOVxewVMfvtmONuzHk/5nwYdz6Ou57GXc8TrhcJ98uE
+xXhfkO435Lu96T7I+WuotzVtLuWdtUxrgbG1QhcTcDZDJ2t0NmGHCnt2N6B
7Z3YltKFrd3Y0oPNvdjUxzL2I0M/0g8g3QDScjSDSD2IVINQyVEMQvkglHGk
g3BvkOosorqKqG4J3SOhewvpvkK6X0wPiOlBETMkYoaFzIiQGRUw46krPpjk
gWkemCmAc/lwPh8u5sHlXLSSi9Zy4HoO3MgBWznMdg6zk0vv5tLSXEqWR8nz
SEU+qSwg1AWEhpfQ8hM6QUIvjBtEcaM4bpLEzUVxS0nMUhqzlsdsFXHbnbj9
Xtz+IO54GHc8TjifJpzPE84XhPMl4fqddL0mXW9J13vK9YFyVdKuatpZwzhr
GWc9cDYAZyN0NEFHM3S0IHsrsrdhWzu2dbCsndjShc3d2NSDTb3Y2IsNfUif
0o90/UjbjzQDSM1RDUDlAFRw5ANfrgbg3gAbxV4VcVcS7qqQuxJzVyJmVMiM
CZlxAZgQgCk+mOaDWR6cK4ALBXAxHy7nw5U8tJaL1nPhRi7YygXbecxOHrOb
R+/l09J8Sl5AKQpIJY9U8Qk1n9AICK0woRMl9OKEQZIwFsVNxXFzadxcFreU
x62349a7Cdu9hO1Bwv4oYX+ccDwlHM8JxwvC8Rvp+J10vqacbynnO8r5gXZ+
pJ1VjKOacdQCRx1w1ANHA7Q3QnsTsjcjWwuytWJbG7a2sywd2NyJzV3Y1I2N
PdjQgwy9SN+LdH1Iy9H0I3U/UrGgsv9zFHs1wEZ9virmooro3iK6T0L3S+iB
QnqwkBkSM8NiZiR1JUpdgXEhmExdCbgrPpzjwQUeXCyAywVwJR+t5aP1PLiR
BzfzwHY+2MlndvOZvQJaWkDLeJScRyn4pFJAqoSkWkhoRIRWTOgKCX1RwlCc
MJYkTKUJU3nCXJGw3ElY7ias9xPWB4TtEWF7QtieEvbnpP0Faf+NtP9OOV5T
jjeU4x3teE87PjKOSvbKXgPstcBeB+310N4AbY3I1oRszdjagq2t2NqGLe3Y
zF2ZOrGxCxu6U5C+B+lSepG2F2n6kJqj6uOiOPJ+KONI++Eei+oupnqKv1wV
cVcS7qqQuxIzo2JmXAQmRGBSCKaEYEYAZgVwjg8X+HCRB5d4cKUArRag9Xy0
kQ838+FWAdguADsFzB6PkfJoGZ+W8ymFgFIKKZWIVItIjZjUFpI6CaErJvQl
hKGUMJYRxgrCdJsw3yHM9wjLfcLykLA+Iq1PSOsz0vactL2gbL9Rtt8p+yva
/oa2v6Xt7xn7B8ZeydirgK0a2GqgrRba6qGtAVkbkbUpBVubsaUFW1qxuQ2b
2rGpAxs7sSGlC+m7ka6bvdL2IE1KL1L3IlUvd9UHFX1QzpH1QWnfH65K2Kve
Yi6qiB4o4q4k7NVIITNayIylrsTclYi7EoJZIZwTwAUBXOTDJT5c4aFVHlrn
oY0CuFkAt3hwmwd2eGCXz+zxGamAlglpuZBWiCilmFKJKXUhqZGQ2iJSV0zq
Skl9GWkoJw0VpPEOabpLmu6R5gek+SFpeUxanpCWZ5T1OWV9QVl/o6y/07ZX
tO0NbXvL2N4xtg+M7SOwVQJbFbDWQGsttNYhaz2yNiBLI2Y1YUszNrdgUys2
tWFjOzZ0sPSdSNfF0nYjTTd7pe5Bqh72StkLFRx5Lxv1+aoP7vXB3T6qp4Tu
LeGuiun+YvZqsIgekjDDEmZEwl0VcldiMCkG0yIwI+KuhHBBCBcFcEkAVwRw
lY/W+GiDhzZ5cIsPt/lghw92BWBPwEiFjEzEyEW0QkwrC2lVIaWSUOoiSlNM
aUuo1JWujNRXkIbbpOEOabxLGu+TpgeU6SFlfkyZn1DmZ5TlOWV5QVt+oy0v
aesr2vqasb5lrO8Y63tg/QCslcBaBa3V0FIDLbXIUocs9cjSgM2NnCZsasam
FmxsxYY2bGjH+g6kS+lE2pQupOlC6m5W6krZA1MUPWwUe8WR9sI9zm7v56u+
EjaKvSpOXTFDRcxwEXcl4a4KwUQhmEpdicGMGMyKwJwILojgohAuCeGyEK4K
0JoArQvQJh9tCeC2AO4IwK4Q7KWIGKmIkYkZeSGtkNBKCa0qotXFlLqE0pRS
2jJKV07pKij9bUp/lzLcowz3KeMDyviIMj2mTE9o8zPa/Jw2v6DNv9Hml4zl
FWN5zVjeAMs7YHkPLB+A5SO0VEJLFbRUI3MNMtcicx0212NzAzY1YlMTNjZj
Yws2tLL0bVjXzl5pO9grTSdSd7FU3SxlN1R0c1c9UMaR9ny+2mXRvaVfrkq4
qGJ6qJiNYq+KuCsJMyEBk6mrQjBdyF2JwZwYzovhogguieCyCK4I4ZoQrQvR
hhBtCtGWEG4L4Y4I7orAnhhIxUBWyMgljCKliFYW06oSWl1Kq8toTTmtraC1
t2ndHVp/l9bfow0PaMND2viINj6mjU9p0zPa9Jw2vWBMvzGpK/PvjPk1ML8B
5rfA/A6Y30PzR2iuhOYqZP58hU0pddhUj40N2NiIDU3Y0Iz1LVjfinVtKEXb
ztJ0IHUnS5XShZRdSMFdyTmfo3rgHmeXxV71ldL9pdxVCT1Ywl0VMyPFzGgR
M1bEjBdxVxIwJQHTEjBTCGYLwVwhdyWGS2K4LIYrIrgqQusitCFCmyK0JULb
IrgjhrtiuFcIUqQSIJMw8iJGUcwoSxhlKaPirtTltIa70t6ldfdo3X1a/4DW
P6QNj2jDE9rwlDE+Y4zPGSN3ZXoJTL8D0ytgegNMb6HpHTS9h6YP0PQRmSqR
qQqZqrGphr0y1mEjd2XgrvTNLF0L0rUibRtL047UKR1I1cFeKVO6oKILyjmy
bpaUs9f9KQrspK7KPl8NlLJR7FUJM1zCXRUzY8XcVRGYLAJTRdyVBMxKwJwE
zhfChUK4VAiXC+GKGK6K0ZoYrYvRphhtidG2GKWudgrhbiHckwBpEZClFAN5
CaPgrpRljKqcUVcw6tuM5g6jucto7zG6+4zuAaN7yOgfM/onTOrK8IwxPGcM
L4DxN2B8CYy/A+MrYHwNjW+g8R00vofGD8j4ERkrkbEqBRursbEGG2uxoQ4b
6rG+Aesbsa4J65qRtoWlaUWaNqRuY69U7eyVsoO9UnTCFDaKI+36HMVescBO
N91Xxvp8VUoPlX65KmFGS7irYmaiGEwWc1dFYKYIzBZxVxK4IIGLErgsgSuF
cLUQrhWi9UK0UYg2C9FWIdouRDsSuCuBe0UsaTGQlaSugLwUKMqAspxRVjCq
24z6DqO+y2juMZr7jPYBo33I6B4xuseM7gmjfwr0z4D+OUhdGX4DhpfA8Ds0
vIKGT1dvU13I+B596cKGKmyoxoYabKjF+jqs5650qatGpG1C2makaWGpW9kr
VRt7pWxnrxQdMEXeyZJ1fr7a4+xydr5c9ZfRA5xPV8OlzEjpl6sSZrzky1Ux
mC4GM8XcVRGYL4ILRXCxCC4VcV0SuCpB6xK0IUGbErQlQduS1BXaKYK7xXCv
GEpLWLJSIC8DinKWsgIobwPVHaC+C9T3gOY+0DwA2odA+whoHwPdE6B7CnTc
lf4F0P8G9S+h/suV4Q0yvEWGd8jwHhk+IMNHbKjkVGF9NdbXYH0t1tVhXT3W
NiAtd6VJaUbqFpaqlb1StrFXChaUd7BkHeyVlLPX+YerLrDdRfeV0/3lXBRn
qIz5dDXK+XxVAiZLwFTJl6tiMFcM5ovhQvGXqyK4UgRXi+BaEVovQhtFaLMI
bRWh7SK0U4x2i9FeCUyRlkJZGUteDhUVQHEbKO8A5V2gSrkH1PeB+gHQPAQa
7kr7BGjZK6h7DnW/Qt2XK/0rqH+N9G+Q/i3Sv0vB+vdY/wHrP2J9JdZXYV01
1tVgXS3W1mFtPUpdaRpZ6iakbmapWljKVpaiLQXK21ky7krK2eOudjk7neDT
Vf+nq/JPUdxVGTNSxkVxxkuZiVLm81UJmCkBsyVgrgTMl3BXxXCpGC4Xw5Vi
uFoM14rhejHaKEabxWirGG2XoB3ObgnaK0XSMpgiK4eyCii/DRUpd6DyLlTe
g6r7UPUAqh9C9SOoecx5ArVPofYZ1D6H2tTVC7ZL9xLpfke6V0j3GuneIN1b
rHuHde+x7gPWfcS6SqyrwtpqrK3BWvYKaeo5DUjNXalSmpEypYWlaGXJU1dt
UNbOkrZzUZzdjk9R7NU2i+6vYKPYq3J6qJweLv9yVcaMlTHjZV+uSsFUKZgu
BTOl/3MFFkrgYglcKoHLnJUSuFoC10rQegnaKEGbJWirFG2Xop1StJtShvbK
kLQcSSvQpyv5Hai4y0pdKbkr1UOoegTVj6H6CdQ8hZpnUPMcan5NXSHtC6T9
DWlfIu3/XuE/Xmk/Ym0l1nJXmpoUpKlF6jqkrkfqBqRKaWSvlE3slSKlhSVv
hSmyNpa0jb3a4+x2fLbD+sNVBT1Y8Yercmak/A9XZcxEGTNZBqbKvlyVgrlS
MM+CC6VwsRQulcLlUrhSCldL4VopXC9FG6VoM6UMbZWh7TK0U4Z2y9EeJ3Ul
vY1kd5A85S5S3IOK++yV8gFUclcq7kr9FKmfIfVzpPmV8wJpvlxpX2Hta6x9
g7VvsfYd1r7HWu5KU4k1VSlIU43UNUjNXanqOQ1I2chpQoom9kqe0gJTZK0s
KXe11/blivM5irPV8YerCnqogv4UxV6VM2PlzHg5G/W/V2VgpgzMcubKwHwZ
WCiDi2VwqQwul8GVMrjKWSuD62Voo4y7KkfbnJ0KtFuB9lJus1fSO0h2l72S
30Py+0jxACkeImXKI6R6jFRPkOrLlfpX1qcrzUus+R1rXmHNa6x5gzVvseYd
1rzHmg9Yw14hdUoVUnNXqlpOHVLWI2UDS9HIaULylGYoS2lhSVtZe63cVRvc
beOiONvtn6LYq4HbrE9R7FUFM1LBjFb84YozWQ6mysF0OZgp//9esV3lcLUc
rpXD9XK4UY5SNivQVgXa5uzcRru30d4dlvQuS3YPye6zV3LuSvEIKR9zuCvV
M6R6jlTsFVa/wOrfsPolVv+O1a+w+jVWv8Hqt1j9DqvfY/UHpP7IqUSqKqSq
RqoalrIWKbkrRUoDS97IRTUh2aerZihtYe21frbLXe1w2CjOFuv/AVOXLgs=

           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     ArrowBox[
      BSplineCurveBox[{{0, -1}, {0.5, -0.5}, {1, -1.2}, {2, -1}, {1.5, 0}, {2,
         1}, {1, 0.5}, {0.5, 1}, {0, 1.5}, {-0.5, 1}}, SplineClosed -> 
       True]]}, {
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     PointBox[{1, 0}]}, 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"z", "\[LongEqual]", "1"}], HoldForm], 
       RGBColor[
       0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, StripOnInput -> 
       False], TraditionalForm], {1, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 0}], 
      ImageScaled[{0.5, 0}]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->884795037,ExpressionUUID->"0a3cbea8-3899-47b6-bd84-ffa04360d4d2"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"bd220f71-d652-4d79-82f4-beb6ecc9d2c2"],

Cell[TextData[{
 "One can write: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      FractionBox[
       RowBox[{"z", "+", "1"}], 
       RowBox[{"z", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
      SubscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], 
       RowBox[{"z", "=", "1"}]]}], "=", 
     RowBox[{"4", "\[Pi]", " ", "\[ImaginaryI]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"c8de4b43-c576-4e2e-899d-1066108b160c"],
 ". Check for a circular contour:"
}], "SolutionAnswer",
 CellID->123504017,ExpressionUUID->"16cbf0ce-7c9a-4c4b-8d9e-c5e34da76006"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", "-", "1"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->532740583,ExpressionUUID->"1d0edca3-2989-4d43-8913-b8f090193f8b"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->282452106,ExpressionUUID->"b6c36ae6-0d5b-43b3-bb12-33aad3a47863"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "3"], "+", "z"}], 
      RowBox[{"z", "-", "3"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"60bbc8f0-4d6c-488a-bc1f-0e5ae0ab3776"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1c6d8109-02e6-4ce2-9858-2a4ad6ca3a8a"],
 " is a curve surrounding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "3"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ad5d0c73-b6a3-47e7-9f62-ae286619121b"],
 " using Cauchy\[CloseCurlyQuote]s integral formula:"
}], "Exercise",
 CellID->59838584,ExpressionUUID->"4edbfe18-664c-4d59-ab21-2f4fc44db66e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"z", "^", "3"}], "+", "z"}], 
    RowBox[{"z", "-", "3"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "I"}], ",", 
     RowBox[{"6", "+", 
      RowBox[{"3", "I"}]}]}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Arrow", "@", 
         RowBox[{"BSplineCurve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1.5", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.3", ",", 
               RowBox[{"-", "0.8"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4.5", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1.5"}], "}"}]}], "}"}], ",", 
           RowBox[{"SplineClosed", "->", "True"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"HoldForm", "[", 
           RowBox[{"z", "==", "3"}], "]"}], ",", 
          
          TemplateBox[<|
           "color" -> RGBColor[
             0.33336385093631155`, 0.33336385093631155`, 
              0.33336385093631155`]|>,
           "RGBColorSwatchTemplate"], ",", 
          RowBox[{"LightDarkAutoColorRules", "->", 
           RowBox[{"<|", 
            RowBox[{"\"\<MarkedColors\>\"", "->", "True"}], "|>"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"LightDarkAutoColorRules", "->", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "ExerciseInput",
 CellID->784666982,ExpressionUUID->"c0602cfb-e61b-4d36-b558-c7754474b366"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd2z3o7nYZh/G7J9Ucg8E0GiNuRUcXoYKLNoN0FZy6VnCoi1jdBKezOAhO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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJyc3GVwXGe66Ptd91TdPZPJZDKZTCYZxxjbseOYYmZmZgaZmdmOmWRmlm1J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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL
xd0dSpGi5T17zfOt9f2xV0/3nXNmZj/DhVSytO4R2d0fEBBQ1QsIiGF/9Zn0
95lNmajto4AseKq1LghPdUxTVjzVsUzZ8FTHNmXHUx3HlANPdVxTTjzV8UzB
eKrjm3LhqU5gyo2XxpTWVMxUlDqdqTheIlNiUz5TXuokphA81UlN+fFUJzMV
wFOd3FQQT3UKUyE81SlNoXiqU5kK46lObSqCl5ozF8XTXRKa8nCnhJw5L57u
EmgqwZ2CuXe4qbIpvSmDqZSpJHVG0zd4meBWxlSaWtzK4mWBWzm8ILiVx8sK
twp42eAWhpcdbhXxcsCtEl4o94401eEu6TlrCe6ie1fhTrm5d1W8PGRRDS8v
3Krj5YNbDbwQuNXEyw+3WngF4BaBVxButfEKceY6eDnJvDJ3Kgy3utypCCzr
4anWu4vCK849G5jqU+vuDfHKk2NLUwt6i7M2irXi2IieUrBtjFcWTs1NzajL
M0teaTg3NTVhL3FqxZ5lmNGMNWFwa82aGuTWxdSZDJRFW1MbanFrhxcOt/Z4
VeDWAa8anDqZOjK3q2miaQJ71cLrQi0u3fCqc6bOzKjImdpw5gi4daenNix7
4NWBW0+8unDqbepFrdz74EXBoi9efbj1w2sAl/54DeEyAK8RrAbiNSHnwaZB
1Mp+CF4zuA3Fi+SMvThzc9gOY01LOA03RZOBshhpGkEtLqPwWtATzYxW9Ixg
RmdyF4vx9IrjaGa0h+VY0xhqcRyH1xEu3+J1YuZ4vHbMGMNMvY1q9HWAsbhN
CnBvYotpq+m86S8YitsU02Rq5TIVrydZTcPrBcfpeL3hOAOvDxxn4vWF43d4
/eA4C68/HGfjDYDt93hjuffPpqXUuvcyvCFw+8E0j1oc5uMNg82PeNFw+Qlv
OKwW4I2A60K8kXBahDeKnBfjjSb7JXhjOPNSPL1JvcO5pjnUQzjrXO4ilsu5
0yzuvdH0W4B7N+K20rSCWixX4U2C22q8yXBbgzcFbr/gTYXbWrxpcFuHNx1u
v+LNgNt6vJlw24C3iHvvNe3hLhM463LuIpabuNMc7q13uJlaWWzFmwe3bXg/
wG073ny47cD7EW478X6C2y68BXDbjbeQM+/B+47Mf+NOi+G2jzstgeV+PNV6
dwfwlnHPQ6aD1Lr7Yby15HjKdJLeZaw9wFpxPELPSjgexVsDpxOm49RrmXWC
teJ8jJ51cPqdPVcz4zhrfoXbadZsJ7dLpotkoCz+MJ2hFrc/8TbC8izeZrjp
u+QczMTpQoD7jtF3j75j9C4nsZe4XGbPnXC5greNM11kxnrOdIYz74LbVXp2
w/Ia3h64XcfbB6ebphvUyv0W3gFY3MY7CLc7eIfgchfvMFzu4R0h9/t4R8n5
Ad4xsn+Idxxuj/D2csYbnPkEbB+z5hScnpqekIGyeG56Ri0uL/BO0vOEGb/T
84wZF8n9nektveL4khnnYPmP6RW1OL7GOw+XN3gXmPkWT7P0Nv5m5iW4/sue
l+H2Hu8K3D7gXSOHT6aP1MrmM949cvXsByu/z/VeY+0H1orrF3puwvU/vDtw
8+kHM5+rNVOz5N2C+1d67sMths/teZsZ6v3KZ+IY0+fWvOTuiaxO6HMMxSG2
1bF8rhabOD7nPYFLXJ/znsIqns95z+GSwOr4zNTsvKY8PsdIXJJYndjnanFJ
6nPeCzioTzMe8q50Fp35Ge9Gs7Xnazgm87kZb+GWwurkPsdIOae2OpXP1co+
jc95AeSYyZTR5xirR2tT+txacUzrcz2f4JTO57z/yD6D1enJOIBZ8j7DMdDn
et7xjjRbZ3zDW9RZk3EWsc3MmeKRYy5TMBkoi2ymrNTikh3PD/cszIhBj9YG
sVbcctATB2458eKTe272TADDPHhxOVMwPR57BLHnb6aNpj9Nf8BYXENM+WCk
exYw5YeRcihkKkitbELxAsm1pKkEvclZW4C1YlWYnlRwLYKXltyLm4pRBzKr
OGvFtSg96eFWij3TMKMYazLA9hvW5CCHSqaKMFPuZUylqZVLWbwsZFUOLwg2
5fGywSXMVIHskpJVCHsp+8rsGQyncLzsnKkiMzJyptKcORccq9CTG7ZV8VTr
12o1vBD2rmmqQa3ca+EVgEUEXkG41cYrBJc6eKFwicQrTO518YqQcz28omQf
hVcMbvXx8nFGna06n4ltA9aUhFMjU0MyUBZNTI2pxaUpXgl6GjKjFD2NmfGF
71m9k0B6xbEZM8rBsoWpObU4tsSrAJdWeGGwao1XlhnNmVkRzm1YUwnObfEq
w7EdXlXYdTR1IBNl09nUiYyVay9TT5hXZW171oprF3pqwrUrXm249TB1p45k
Vg/Wins3elpyr+GmaD6rTW83ziKuvTlTU+49xDQYBmLR39SPWhwG4NXjHfRh
Rn16tLYva8VuID2N4TwIrxlZD2XP5nAahteEMw2mJ4o9+rJnC+4YTU8rOI3g
zoOZO880F2biNMo0klrsRuO1g8MYvPawGYvXAbbj8DrBabzpW2pxmoDXBQ4T
8bqS+yS8brCYjNeaM47kDt3hOoU1PeE0zTSVzJXDDNN0amUzE68HPVOZ0Yue
6cwYQs4/kFFf2H3HjP5wm22aRS1u3+MNhMscvEFkPhevHzNmMXODz/0epd+b
zrC3uM3nDItMi017TXvIQFksNC0gU+W4wrScWjmuxBtOj9b+5HPvYjj1j8wa
xT4LYTaeWctgLs5LOMcovMX0TITTKvbUG9Bb+Nm0lM/EaTVrZpHTRu49BRa/
mNZQi8NavOlw+9W0jllTWLuatdP5bC1rxWk9PbPhsIk9Z/6/3LVG31X6ztG7
bsdnszjbBu4+lrssYZY4bmbmHNhuwZtPrjtM26mV9U68pWRzwLQfxvNZu421
YrWLngVw2Y23mHPs87k3sYSZ+/EWwmUPPfPYQ7O3wlRsD5kO+twbEbcjpsPk
qNx+N50iY2V93HSM3hWsPcTd5zF7C4xXs/aoz73laHKYz16r+OwIjMXtpOkE
e4vLac6wHg5n8NZyxlP0rGHGCc6oP7vozyz6fa08zMXprM/9GfCi336mMr0z
vfU7Zjr3X6Zz1LrLebytZHcBbxusLuJth+slvB1wu4y3E25X8HbB5Sreblhd
w9sD1+t4p8jhqekJtXJ4hifueku3TDdhKi53TLepxeou3mFyv4d3BBb38Y7C
7gHeMXJ9iHecrB/hnYDDY7yTnPkJnu6id3mDO+3jzDfxTsP2OXe6yr0/mj74
3PeiuL00vaAWy7/xzsLtFd45uP2D9xfcXuOdh9sbvAtwe4t3EW7v8C7B7V+8
y3B7j/eQe8eytxTT7+7yB2d9zl1070/c6Tr3/ox3gyy+4N2E5X94t+Gmf/H5
lVrcfH7n3YWb3++8e3Dz/M67D7cYfuc94Mw6q7wrZP6BOz2CW2y/u9NjWMbx
O0+13l1cv/Oecc/4Vsfzu1p3T+B33htyTG51Mr/rVY/WasYLOCb0u56XcEzk
d94/cEpqdRK/qzVTs+T9DefEftfzFk4p/G7PV3BXr9a8g1tKv1sTQG6ZTBn9
LgNlkdrqVH5Xi1sav/M+wi2t33mf4JbO77wvsEtvdSBzM5vKmEqzlx8vE7W4
ZMH7CmudJYPfnVVn0llSslbcguiJwbvLihcTbtnwYsMphyk7tXLPiRcXbsF4
8eCWCy8+XHLjJYBLHryE5J4XLxE558NLDLcQvCRwy48XizNm58xJeScFWJMc
ToVMBclAWRQ2hVKLSxG8ZPQUZEYKekKZkZHcxeIbesWxKDPEUCyLm4pRi2MJ
PNViWxIvAzM1qxSz0tKrmZ/5dRzIrMxwK8ub6GTqbBpv+haG4lbeVI5auVTA
y0ZWYXjZ4VgRLwccK+HlhGNlvGA4huPlgmMVvNxwrIqXB47V8Ipz7wam+tTK
oiFeCNxqmmpQi0MtvAKwicArCJfaeIVgVQcvFK6ReIXhVBevCDnXwytK9lF4
xThzfTzdRe+wOnfKx5lr4JWCZWNTIzLQvTuY2vvduxG3pqYm1GLZDK8s3Jrj
lYNbC7zycGuJVwFurfDC4NYaryLc2uBVgltbvMpwa4dXl3v3NvXiLqU5a2Pu
ont35E7VuHcnvOpk0RmvBty64NWEW1e8WnDrhhcBt+54teHWA68O3HriRXLm
XnjhZN6eO9WDWx/uFAXLvniq9e764TXingNNA6h190F4rchxhGk4vXq7/ZnR
BI6D6WkKxyF4LeAUbRpG3YpZ0awV56H0tIbTSPZszoxhrGkDt1Gs6Upuk0wT
yUBZjDGNpha3sXgd4DYOryPcvsXrDKcJfvcdo+8efcfoXZZlL3GZzJ7d4TIF
rwtnmsiMtpxpNGfuAbep9PSE5TS8XnCbjtcHTjNNM6iV+3d4/WAxC28A3L43
zaYWlzl4g+AyF28wuc/DG0LOP+ANJfv5eMPg9iNeb844gzNHw/Yn1oyA00LT
AjJQFotNi6jFZQnecHoWMGMkPYuYMZHcV5lW0iuOS5kxDpbLTD9Ti+NyvPFw
WYE3gZkr8cYy42dmToLravacDLc1eFPg9gveNHJYZ1pLrWx+xZtLrltNW+id
xtpfWCuu6+mZCdcNeN/DbbNpE/VcZm1mrd7Cb/TMg9s29pzNDPVu5DNx3M6a
pdz9gGk/DMVhp2kHtdjswlsAl914C2G1B28xXPaZ9jJTs2+ZbrKXuBzEXwaX
Q3hLONN+ZsznTDs48yL22Muey+F4mBkr4XbUdARGyvmE6Ti1sj+Jt4kcz5nO
wngNa4+xVhxP0bMOTr/jbSD7P0xnyHgTs/5krTiepmcVexzjjCs48xHusBm2
f3GmPdz1uukaGSgL/Yx+kVpcLuNtgft5ZmyjR2svsFbcrtCzC25X8faS+w32
3AeLm3i7OdM1erayxwX21D9L2MzPmfrZ8wBcb/MGDnHPu6Y73Fs53Dfdo1Y2
D/BOk+tz0zN6j7D2LmvF6iE9x+H6CO8UuT81PaE+zaynrBXXx/ScgeUL9jzJ
jCes+RO2f5tekply+GB6DzPl/o/pFbVyeY13nqze4F2AzVu8S3D51+/+GcxB
MrtDhlfJ/iN7XoPTJ7zLnOk9M85yplec+TocP9NzA7Zf8G7C6T+82+yt/5D4
K7Vy93nOuwsLv+e8e3DzPOfdh0sMz3kP4BLTc95Dco/lOe8ROcf2nPeY7ON4
znsCt7ie825xxq+c+Sls43luzXNYJrA6vucyUBaJrU7kuVpcknjOewZ3rdWM
l+SmtQk992t5A+/kNL3imNRzM97AMrnVyTxXi2MKz3nv4JLSc96/sErlOe81
70C9mvkezqk9t+YDnNN4zvsIx7Se876QQ3qrAz1XK5sMnvNikms2U1bPMVeP
1qaDsbhm9FxPAFwz4XlwCzJloY7JrCDWintmelJwr1BTIT7z6M3MWcQ1O2dK
wr3zm0JgIBa5TMHUYpkbLzbvIAcz4tKjtTlhJnZ5TXmoxTkfXlI4FWDPZHAq
iJeYM4XQE4c9crJncu5YiJ6UcCrMnUOYW9NUA2biVNRUhFrsiuGlhUNxvHRw
LIEXCMeSeOnhVAovA5y+wcsIh9J4mci9DF5mWJTFS8UZi3CHLHAtx5qscKpg
Kk/myqGiKYxa2VTCC6KnPDOy0RPGjPzkXIuMcsKuMjNywbqKKRyG4lbNc/8P
RF64VMfLR+Y18IKZEc7MtqZ2ptGmUewtbhGcoZ4pytTH1JsMlEVdUySZKsfG
pkbUyrEJXig9WlvHc+8ilLo2s4qyT12YlWJWQ5iLc33OURQvip7ScGrKniWY
od4GfCZOzVgTTnbtuXc5WLQwNacWh5Z4YXBrbWrFrHKsbcbaMD5ryVpxakNP
VTh0NHXgs//LXWs+8fuM3nVaPgvnbG25ewnuUp9Z4tiJmdVh2xkvgly7m7pR
K+seeA3Ipr+pH4wjWNuVtWLVk55IuPTCi+IcfT33Juozsx9eXbj0pqcme2h2
F/YW2wGcoTHcBpkGkqNyG2EaTsbKeqhpCL2NWTuAu9dkdmcYN2PtYM+95ULk
EMFeTflsEIzFLdo0jL3FZSRnaAOHUXgtOeNwepozYxhnFDe9rTGe+zX1P4uT
Py0=
          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz+I5sYdhj+Sxu216ULalN4ybHVuA65c3gVSpAqk3ZQufe2RyrDVpfSU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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     ArrowBox[
      BSplineCurveBox[{{1.5, 0}, {1.3, -0.8}, {2, -1}, {4, -1}, {4.5, 0}, {4, 
        1}, {3, 1}, {2, 2}, {1, 1.5}}, SplineClosed -> True]]}, {
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     PointBox[{3, 0}]}, 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"z", "\[LongEqual]", "3"}], HoldForm], 
       RGBColor[
       0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, StripOnInput -> 
       False], TraditionalForm], {3, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 0}], 
      ImageScaled[{0.5, 0}]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->857192863,ExpressionUUID->"b078873f-4057-4611-bcdb-301543f780f0"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"a05f55e3-5535-4767-863c-04e3da3fa520"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "3"], "+", "z"}], 
       RowBox[{"z", "-", "3"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
      SubscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["z", "3"], "+", "z"}], ")"}], 
       RowBox[{"z", "=", "3"}]]}], "=", 
     RowBox[{"60", "\[Pi]", " ", "\[ImaginaryI]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"dab067de-187c-4a03-bdeb-3dfc8fc6b1f3"],
 ". Check for a circular contour:"
}], "SolutionAnswer",
 CellID->538437555,ExpressionUUID->"f9f47c75-1084-4134-8201-26101b914332"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "3"], "+", "z"}], 
    RowBox[{"z", "-", "3"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->1196601,ExpressionUUID->"c7ca34c1-7f1b-4db8-9b1e-036554b8352c"],

Cell[BoxData[
 RowBox[{"60", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->43671960,ExpressionUUID->"831af3b2-1f2a-4c99-b338-6f88509c4aea"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Confirm by explicit computation that the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"2", "z"}], "-", "5"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0cdd9fe2-3c07-4b20-b1ec-a85bdc29e731"],
 " satisfies the mean-value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "90d764e5-4d88-4f74-996f-7932f73c0089"],
 " for a circular contour of radius two:"
}], "Exercise",
 CellID->74090572,ExpressionUUID->"65ee2b9f-13a0-43c8-b90e-17c949e00728"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "z"}], "-", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "4"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Arrow", "@", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"HoldForm", "[", 
           RowBox[{"z", "==", "1"}], "]"}], ",", 
          
          TemplateBox[<|
           "color" -> RGBColor[
             0.33336385093631155`, 0.33336385093631155`, 
              0.33336385093631155`]|>,
           "RGBColorSwatchTemplate"], ",", 
          RowBox[{"LightDarkAutoColorRules", "->", 
           RowBox[{"<|", 
            RowBox[{"\"\<MarkedColors\>\"", "->", "True"}], "|>"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"LightDarkAutoColorRules", "->", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "ExerciseInput",
 CellID->175757203,ExpressionUUID->"b2fc64d1-7944-461b-bc86-e5ec51709453"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GXOVARReuKiNW4YhiajFO0WCcYTMqwnTrjisFotRhWBUG3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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx83FeMHkeC4PnF3cs9HnDAPSxwB+wOFrcLzGHmdnd2DGa60dPdM93bXmpJ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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     ArrowBox[
      CircleBox[{1, 0}, 2]]}, {
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     PointBox[{1, 0}]}, 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"z", "\[LongEqual]", "1"}], HoldForm], 
       RGBColor[
       0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, StripOnInput -> 
       False], TraditionalForm], {1, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 0}], 
      ImageScaled[{0.5, 0}]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->864919447,ExpressionUUID->"852168e5-5c51-4618-b754-39dc432d4c2b"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"79b76d5d-1f7b-4d47-8aff-f66e53716ca8"],

Cell["Define the function:", "SolutionAnswer",
 CellID->399144589,ExpressionUUID->"ad33cd0e-8e4a-41c5-a4a5-42d9e389c6fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"2", "z"}], "-", "5"}]}], ";"}]], "ExerciseInput",
 CellID->177141838,ExpressionUUID->"53e0607e-302c-49f5-8259-c4179af750fa"],

Cell[TextData[{
 "Its value at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "acbf15ec-9635-4d9c-9f79-f344d4bd322f"],
 ":"
}], "SolutionAnswer",
 CellID->65646841,ExpressionUUID->"42c9d5cf-8451-44be-9993-3772b22ceac6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "1", "]"}]], "ExerciseInput",
 CellID->219616554,ExpressionUUID->"43b87a7c-545c-42c1-9b83-769cecd77b25"],

Cell[BoxData[
 RowBox[{"-", "3"}]], "ExerciseOutput",
 CellID->132181,ExpressionUUID->"a29da767-d1cf-4b0d-9339-8d25d8d315d9"]
}, Open  ]],

Cell["The mean-value property:", "SolutionAnswer",
 CellID->73866957,ExpressionUUID->"6d91041f-3bd3-478d-9588-4b55a6763d70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]"}]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["E", 
        RowBox[{"2", "\[ImaginaryI]", " ", "\[Theta]"}]]}], "]"}], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}], "//", 
  "FullSimplify"}]], "ExerciseInput",
 CellID->455766353,ExpressionUUID->"b5ecf7f8-ca43-4b48-b91c-7a67cbafea48"],

Cell[BoxData[
 RowBox[{"-", "3"}]], "ExerciseOutput",
 CellID->1002428695,ExpressionUUID->"556f1e61-17d4-4618-8c3c-5bec8208dff8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{"2", "z", " ", 
       RowBox[{"sin", "(", "z", ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "4"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a5bb45d8-83ec-43af-9fde-b57bcb7db9ea"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "62b759f3-6e8a-4794-b300-0833ea0efc23"],
 " is a curve surrounding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a7292a9e-be5f-4ab6-8154-34db374a886c"],
 ":"
}], "Exercise",
 CellID->634626211,ExpressionUUID->"dfa2f25d-7cd5-4d52-91d8-d0d12b155dbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"2", 
     RowBox[{"Sin", "[", "z", "]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], "4"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "4"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Arrow", "@", 
         RowBox[{"BSplineCurve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2.5"}], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1.3"}], ",", 
               RowBox[{"-", "0.8"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.5", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "2"}], ",", "1.5"}], "}"}]}], "}"}], ",", 
           RowBox[{"SplineClosed", "->", "True"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"HoldForm", "[", 
           RowBox[{"z", "==", 
            RowBox[{"-", "1"}]}], "]"}], ",", 
          
          TemplateBox[<|
           "color" -> RGBColor[
             0.33336385093631155`, 0.33336385093631155`, 
              0.33336385093631155`]|>,
           "RGBColorSwatchTemplate"], ",", 
          RowBox[{"LightDarkAutoColorRules", "->", 
           RowBox[{"<|", 
            RowBox[{"\"\<MarkedColors\>\"", "->", "True"}], "|>"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"LightDarkAutoColorRules", "->", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "ExerciseInput",
 CellID->116267116,ExpressionUUID->"c9347202-b94a-415f-939a-ebd067a4f68e"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GXOVARReuKiNW4YhiajFO0WCcYTMqwnTrjisFotRhWBUG3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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJyEvAdQU/nb/v3M+868z2/X3l1XAXtv1IQUSkLvvTcRpCOCNBHpVlRUBLGL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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     ArrowBox[
      BSplineCurveBox[{{-2.5, 0}, {-1.3, -0.8}, {-1, -1}, {1, -1}, {1.5, 0}, {
        1, 1}, {0, 1}, {-2, 2}, {-2, 1.5}}, SplineClosed -> True]]}, {
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     PointBox[{-1, 0}]}, 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"z", "\[LongEqual]", 
          RowBox[{"-", "1"}]}], HoldForm], 
       RGBColor[
       0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, StripOnInput -> 
       False], TraditionalForm], {-1, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 0}], 
      ImageScaled[{0.5, 0}]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->488793168,ExpressionUUID->"cefb10f2-5354-4480-86cb-e518e0025e65"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"eaa2e67f-088a-43cf-b9eb-fc09d72cd5d4"],

Cell["Using Cauchy\[CloseCurlyQuote]s formula for derivatives,", \
"SolutionAnswer",
 CellID->383961777,ExpressionUUID->"85c6ab81-7e4a-4366-baca-590c1a9e016d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{"\[ImaginaryI]", "/", 
     RowBox[{"3", "!"}]}], "*", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"2", "z", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}]}], "]"}]}], "/.", 
   RowBox[{"z", "->", 
    RowBox[{"-", "1"}]}]}], "//", "Simplify"}]], "ExerciseInput",
 CellID->439329399,ExpressionUUID->"2765e0f8-b9db-4ea4-a429-f168ace2f327"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "1", "]"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Sin", "[", "1", "]"}]}]}], ")"}]}]], "ExerciseOutput",
 CellID->235507395,ExpressionUUID->"3e0952ac-7748-41b4-a03a-646e99f53803"]
}, Open  ]],

Cell["Confirm for a circular contour:", "SolutionAnswer",
 CellID->15174699,ExpressionUUID->"e0978c1e-fe21-4842-ad09-6a1a04e5cc67"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"2", "z", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], "4"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->199378461,ExpressionUUID->"d2dc7d4f-5407-44c6-b8e3-1edb69ee7a9a"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "1", "]"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Sin", "[", "1", "]"}]}]}], ")"}]}]], "ExerciseOutput",
 CellID->146854002,ExpressionUUID->"d244184e-52fc-41bc-a848-6f6a533b94b8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"exp", "(", "z", ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "5"}], ")"}], "3"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"173891dd-6d6e-444b-ae5f-3b164a3109b0"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ca5af463-a1a2-4419-982b-a709a8e645b7"],
 " is a curve surrounding ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "5"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "724bf717-417c-4945-8d51-759584137a61"],
 ":"
}], "Exercise",
 CellID->69563545,ExpressionUUID->"45fbeb2c-58e9-4fa0-bd89-c060eb3de528"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], 
     RowBox[{"Exp", "[", "z", "]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "5"}], ")"}], "4"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "8"}], "-", 
      RowBox[{"3", "I"}]}], ",", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"3", "I"}]}]}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Arrow", "@", 
         RowBox[{"BSplineCurve", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6.5"}], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "5.3"}], ",", 
               RowBox[{"-", "0.8"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "5"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "4"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "3.5"}], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "5"}], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6"}], ",", "1.5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6"}], ",", "1.2"}], "}"}]}], "}"}], ",", 
           RowBox[{"SplineClosed", "->", "True"}]}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        TemplateBox[<|
         "color" -> RGBColor[
           0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`]|>,
         "RGBColorSwatchTemplate"], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"HoldForm", "[", 
           RowBox[{"z", "==", 
            RowBox[{"-", "5"}]}], "]"}], ",", 
          
          TemplateBox[<|
           "color" -> RGBColor[
             0.33336385093631155`, 0.33336385093631155`, 
              0.33336385093631155`]|>,
           "RGBColorSwatchTemplate"], ",", 
          RowBox[{"LightDarkAutoColorRules", "->", 
           RowBox[{"<|", 
            RowBox[{"\"\<MarkedColors\>\"", "->", "True"}], "|>"}]}]}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"LightDarkAutoColorRules", "->", 
      RowBox[{"{", "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "ExerciseInput",
 CellID->523873467,ExpressionUUID->"91416c31-9300-4021-8726-72c84cda69a3"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxt2z9oVVccwPGnEUmlllirTa3WI3V0KWRwsHoGkW4Fp4yNIJgu1eImOGUR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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx0vHdUVFnX9fuNe8d4n25zTk0RVMxiAIoi55xzDhJURBBBgiBJUQmimABF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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL
xd0dSpGi5T17zfOt9f2xV0/3nXNmZj/DhVSytO4R2d0fEBBQ1QsIiGF/9Zn0
95lNmajto4AseKq1LghPdUxTVjzVsUzZ8FTHNmXHUx3HlANPdVxTTjzV8UzB
eKrjm3LhqU5gyo2XxpTWVMxUlDqdqTheIlNiUz5TXuokphA81UlN+fFUJzMV
wFOd3FQQT3UKUyE81SlNoXiqU5kK46lObSqCl5ozF8XTXRKa8nCnhJw5L57u
EmgqwZ2CuXe4qbIpvSmDqZSpJHVG0zd4meBWxlSaWtzK4mWBWzm8ILiVx8sK
twp42eAWhpcdbhXxcsCtEl4o94401eEu6TlrCe6ie1fhTrm5d1W8PGRRDS8v
3Krj5YNbDbwQuNXEyw+3WngF4BaBVxButfEKceY6eDnJvDJ3Kgy3utypCCzr
4anWu4vCK849G5jqU+vuDfHKk2NLUwt6i7M2irXi2IieUrBtjFcWTs1NzajL
M0teaTg3NTVhL3FqxZ5lmNGMNWFwa82aGuTWxdSZDJRFW1MbanFrhxcOt/Z4
VeDWAa8anDqZOjK3q2miaQJ71cLrQi0u3fCqc6bOzKjImdpw5gi4daenNix7
4NWBW0+8unDqbepFrdz74EXBoi9efbj1w2sAl/54DeEyAK8RrAbiNSHnwaZB
1Mp+CF4zuA3Fi+SMvThzc9gOY01LOA03RZOBshhpGkEtLqPwWtATzYxW9Ixg
RmdyF4vx9IrjaGa0h+VY0xhqcRyH1xEu3+J1YuZ4vHbMGMNMvY1q9HWAsbhN
CnBvYotpq+m86S8YitsU02Rq5TIVrydZTcPrBcfpeL3hOAOvDxxn4vWF43d4
/eA4C68/HGfjDYDt93hjuffPpqXUuvcyvCFw+8E0j1oc5uMNg82PeNFw+Qlv
OKwW4I2A60K8kXBahDeKnBfjjSb7JXhjOPNSPL1JvcO5pjnUQzjrXO4ilsu5
0yzuvdH0W4B7N+K20rSCWixX4U2C22q8yXBbgzcFbr/gTYXbWrxpcFuHNx1u
v+LNgNt6vJlw24C3iHvvNe3hLhM463LuIpabuNMc7q13uJlaWWzFmwe3bXg/
wG073ny47cD7EW478X6C2y68BXDbjbeQM+/B+47Mf+NOi+G2jzstgeV+PNV6
dwfwlnHPQ6aD1Lr7Yby15HjKdJLeZaw9wFpxPELPSjgexVsDpxOm49RrmXWC
teJ8jJ51cPqdPVcz4zhrfoXbadZsJ7dLpotkoCz+MJ2hFrc/8TbC8izeZrjp
u+QczMTpQoD7jtF3j75j9C4nsZe4XGbPnXC5greNM11kxnrOdIYz74LbVXp2
w/Ia3h64XcfbB6ebphvUyv0W3gFY3MY7CLc7eIfgchfvMFzu4R0h9/t4R8n5
Ad4xsn+Idxxuj/D2csYbnPkEbB+z5hScnpqekIGyeG56Ri0uL/BO0vOEGb/T
84wZF8n9nektveL4khnnYPmP6RW1OL7GOw+XN3gXmPkWT7P0Nv5m5iW4/sue
l+H2Hu8K3D7gXSOHT6aP1MrmM949cvXsByu/z/VeY+0H1orrF3puwvU/vDtw
8+kHM5+rNVOz5N2C+1d67sMths/teZsZ6v3KZ+IY0+fWvOTuiaxO6HMMxSG2
1bF8rhabOD7nPYFLXJ/znsIqns95z+GSwOr4zNTsvKY8PsdIXJJYndjnanFJ
6nPeCzioTzMe8q50Fp35Ge9Gs7Xnazgm87kZb+GWwurkPsdIOae2OpXP1co+
jc95AeSYyZTR5xirR2tT+txacUzrcz2f4JTO57z/yD6D1enJOIBZ8j7DMdDn
et7xjjRbZ3zDW9RZk3EWsc3MmeKRYy5TMBkoi2ymrNTikh3PD/cszIhBj9YG
sVbcctATB2458eKTe272TADDPHhxOVMwPR57BLHnb6aNpj9Nf8BYXENM+WCk
exYw5YeRcihkKkitbELxAsm1pKkEvclZW4C1YlWYnlRwLYKXltyLm4pRBzKr
OGvFtSg96eFWij3TMKMYazLA9hvW5CCHSqaKMFPuZUylqZVLWbwsZFUOLwg2
5fGywSXMVIHskpJVCHsp+8rsGQyncLzsnKkiMzJyptKcORccq9CTG7ZV8VTr
12o1vBD2rmmqQa3ca+EVgEUEXkG41cYrBJc6eKFwicQrTO518YqQcz28omQf
hVcMbvXx8nFGna06n4ltA9aUhFMjU0MyUBZNTI2pxaUpXgl6GjKjFD2NmfGF
71m9k0B6xbEZM8rBsoWpObU4tsSrAJdWeGGwao1XlhnNmVkRzm1YUwnObfEq
w7EdXlXYdTR1IBNl09nUiYyVay9TT5hXZW171oprF3pqwrUrXm249TB1p45k
Vg/Wins3elpyr+GmaD6rTW83ziKuvTlTU+49xDQYBmLR39SPWhwG4NXjHfRh
Rn16tLYva8VuID2N4TwIrxlZD2XP5nAahteEMw2mJ4o9+rJnC+4YTU8rOI3g
zoOZO880F2biNMo0klrsRuO1g8MYvPawGYvXAbbj8DrBabzpW2pxmoDXBQ4T
8bqS+yS8brCYjNeaM47kDt3hOoU1PeE0zTSVzJXDDNN0amUzE68HPVOZ0Yue
6cwYQs4/kFFf2H3HjP5wm22aRS1u3+MNhMscvEFkPhevHzNmMXODz/0epd+b
zrC3uM3nDItMi017TXvIQFksNC0gU+W4wrScWjmuxBtOj9b+5HPvYjj1j8wa
xT4LYTaeWctgLs5LOMcovMX0TITTKvbUG9Bb+Nm0lM/EaTVrZpHTRu49BRa/
mNZQi8NavOlw+9W0jllTWLuatdP5bC1rxWk9PbPhsIk9Z/6/3LVG31X6ztG7
bsdnszjbBu4+lrssYZY4bmbmHNhuwZtPrjtM26mV9U68pWRzwLQfxvNZu421
YrWLngVw2Y23mHPs87k3sYSZ+/EWwmUPPfPYQ7O3wlRsD5kO+twbEbcjpsPk
qNx+N50iY2V93HSM3hWsPcTd5zF7C4xXs/aoz73laHKYz16r+OwIjMXtpOkE
e4vLac6wHg5n8NZyxlP0rGHGCc6oP7vozyz6fa08zMXprM/9GfCi336mMr0z
vfU7Zjr3X6Zz1LrLebytZHcBbxusLuJth+slvB1wu4y3E25X8HbB5Sreblhd
w9sD1+t4p8jhqekJtXJ4hifueku3TDdhKi53TLepxeou3mFyv4d3BBb38Y7C
7gHeMXJ9iHecrB/hnYDDY7yTnPkJnu6id3mDO+3jzDfxTsP2OXe6yr0/mj74
3PeiuL00vaAWy7/xzsLtFd45uP2D9xfcXuOdh9sbvAtwe4t3EW7v8C7B7V+8
y3B7j/eQe8eytxTT7+7yB2d9zl1070/c6Tr3/ox3gyy+4N2E5X94t+Gmf/H5
lVrcfH7n3YWb3++8e3Dz/M67D7cYfuc94Mw6q7wrZP6BOz2CW2y/u9NjWMbx
O0+13l1cv/Oecc/4Vsfzu1p3T+B33htyTG51Mr/rVY/WasYLOCb0u56XcEzk
d94/cEpqdRK/qzVTs+T9DefEftfzFk4p/G7PV3BXr9a8g1tKv1sTQG6ZTBn9
LgNlkdrqVH5Xi1sav/M+wi2t33mf4JbO77wvsEtvdSBzM5vKmEqzlx8vE7W4
ZMH7CmudJYPfnVVn0llSslbcguiJwbvLihcTbtnwYsMphyk7tXLPiRcXbsF4
8eCWCy8+XHLjJYBLHryE5J4XLxE558NLDLcQvCRwy48XizNm58xJeScFWJMc
ToVMBclAWRQ2hVKLSxG8ZPQUZEYKekKZkZHcxeIbesWxKDPEUCyLm4pRi2MJ
PNViWxIvAzM1qxSz0tKrmZ/5dRzIrMxwK8ub6GTqbBpv+haG4lbeVI5auVTA
y0ZWYXjZ4VgRLwccK+HlhGNlvGA4huPlgmMVvNxwrIqXB47V8Ipz7wam+tTK
oiFeCNxqmmpQi0MtvAKwicArCJfaeIVgVQcvFK6ReIXhVBevCDnXwytK9lF4
xThzfTzdRe+wOnfKx5lr4JWCZWNTIzLQvTuY2vvduxG3pqYm1GLZDK8s3Jrj
lYNbC7zycGuJVwFurfDC4NYaryLc2uBVgltbvMpwa4dXl3v3NvXiLqU5a2Pu
ont35E7VuHcnvOpk0RmvBty64NWEW1e8WnDrhhcBt+54teHWA68O3HriRXLm
XnjhZN6eO9WDWx/uFAXLvniq9e764TXingNNA6h190F4rchxhGk4vXq7/ZnR
BI6D6WkKxyF4LeAUbRpG3YpZ0awV56H0tIbTSPZszoxhrGkDt1Gs6Upuk0wT
yUBZjDGNpha3sXgd4DYOryPcvsXrDKcJfvcdo+8efcfoXZZlL3GZzJ7d4TIF
rwtnmsiMtpxpNGfuAbep9PSE5TS8XnCbjtcHTjNNM6iV+3d4/WAxC28A3L43
zaYWlzl4g+AyF28wuc/DG0LOP+ANJfv5eMPg9iNeb844gzNHw/Yn1oyA00LT
AjJQFotNi6jFZQnecHoWMGMkPYuYMZHcV5lW0iuOS5kxDpbLTD9Ti+NyvPFw
WYE3gZkr8cYy42dmToLravacDLc1eFPg9gveNHJYZ1pLrWx+xZtLrltNW+id
xtpfWCuu6+mZCdcNeN/DbbNpE/VcZm1mrd7Cb/TMg9s29pzNDPVu5DNx3M6a
pdz9gGk/DMVhp2kHtdjswlsAl914C2G1B28xXPaZ9jJTs2+ZbrKXuBzEXwaX
Q3hLONN+ZsznTDs48yL22Muey+F4mBkr4XbUdARGyvmE6Ti1sj+Jt4kcz5nO
wngNa4+xVhxP0bMOTr/jbSD7P0xnyHgTs/5krTiepmcVexzjjCs48xHusBm2
f3GmPdz1uukaGSgL/Yx+kVpcLuNtgft5ZmyjR2svsFbcrtCzC25X8faS+w32
3AeLm3i7OdM1erayxwX21D9L2MzPmfrZ8wBcb/MGDnHPu6Y73Fs53Dfdo1Y2
D/BOk+tz0zN6j7D2LmvF6iE9x+H6CO8UuT81PaE+zaynrBXXx/ScgeUL9jzJ
jCes+RO2f5tekply+GB6DzPl/o/pFbVyeY13nqze4F2AzVu8S3D51+/+GcxB
MrtDhlfJ/iN7XoPTJ7zLnOk9M85yplec+TocP9NzA7Zf8G7C6T+82+yt/5D4
K7Vy93nOuwsLv+e8e3DzPOfdh0sMz3kP4BLTc95Dco/lOe8ROcf2nPeY7ON4
znsCt7ie825xxq+c+Sls43luzXNYJrA6vucyUBaJrU7kuVpcknjOewZ3rdWM
l+SmtQk992t5A+/kNL3imNRzM97AMrnVyTxXi2MKz3nv4JLSc96/sErlOe81
70C9mvkezqk9t+YDnNN4zvsIx7Se876QQ3qrAz1XK5sMnvNikms2U1bPMVeP
1qaDsbhm9FxPAFwz4XlwCzJloY7JrCDWintmelJwr1BTIT7z6M3MWcQ1O2dK
wr3zm0JgIBa5TMHUYpkbLzbvIAcz4tKjtTlhJnZ5TXmoxTkfXlI4FWDPZHAq
iJeYM4XQE4c9crJncu5YiJ6UcCrMnUOYW9NUA2biVNRUhFrsiuGlhUNxvHRw
LIEXCMeSeOnhVAovA5y+wcsIh9J4mci9DF5mWJTFS8UZi3CHLHAtx5qscKpg
Kk/myqGiKYxa2VTCC6KnPDOy0RPGjPzkXIuMcsKuMjNywbqKKRyG4lbNc/8P
RF64VMfLR+Y18IKZEc7MtqZ2ptGmUewtbhGcoZ4pytTH1JsMlEVdUySZKsfG
pkbUyrEJXig9WlvHc+8ilLo2s4qyT12YlWJWQ5iLc33OURQvip7ScGrKniWY
od4GfCZOzVgTTnbtuXc5WLQwNacWh5Z4YXBrbWrFrHKsbcbaMD5ryVpxakNP
VTh0NHXgs//LXWs+8fuM3nVaPgvnbG25ewnuUp9Z4tiJmdVh2xkvgly7m7pR
K+seeA3Ipr+pH4wjWNuVtWLVk55IuPTCi+IcfT33Juozsx9eXbj0pqcme2h2
F/YW2wGcoTHcBpkGkqNyG2EaTsbKeqhpCL2NWTuAu9dkdmcYN2PtYM+95ULk
EMFeTflsEIzFLdo0jL3FZSRnaAOHUXgtOeNwepozYxhnFDe9rTGe+zX1P4uT
Py0=
          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJxl2z/IJHcdx/FFmxRapE2l2FqmCshTeZUhIhaWRhC1EmxjYZFSuxCChZgq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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     ArrowBox[
      BSplineCurveBox[{{-6.5, 0}, {-5.3, -0.8}, {-5, -1}, {-4, -1}, {-3.5, 
         0}, {-4, 1}, {-5, 1}, {-6, 1.5}, {-6, 1.2}}, SplineClosed -> 
       True]]}, {
     RGBColor[
     0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
     PointBox[{-5, 0}]}, 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"z", "\[LongEqual]", 
          RowBox[{"-", "5"}]}], HoldForm], 
       RGBColor[
       0.33336385093631155`, 0.33336385093631155`, 0.33336385093631155`], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, StripOnInput -> 
       False], TraditionalForm], {-5, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 0}], 
      ImageScaled[{0.5, 0}]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->2033757126,ExpressionUUID->"9f376145-8a41-422a-85d5-222535edfb59"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"7e3dbca3-8a25-4dec-8675-d8cc773aad85"],

Cell["Using Cauchy\[CloseCurlyQuote]s formula for derivatives:", \
"SolutionAnswer",
 CellID->622813021,ExpressionUUID->"e8ff89bc-34c1-4e4f-9221-3bb6172ee5cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{"\[ImaginaryI]", "/", 
     RowBox[{"2", "!"}]}], "*", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"Exp", "[", "z", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "2"}], "}"}]}], "]"}]}], "/.", 
   RowBox[{"z", "->", 
    RowBox[{"-", "5"}]}]}], "//", "Simplify"}]], "ExerciseInput",
 CellID->18813251,ExpressionUUID->"d11e0f7e-6a72-452c-ba9d-cc9014300fc8"],

Cell[BoxData[
 FractionBox[
  RowBox[{"7", " ", "\[ImaginaryI]", " ", "\[Pi]"}], 
  SuperscriptBox["\[ExponentialE]", "5"]]], "ExerciseOutput",
 CellID->11225626,ExpressionUUID->"f2408ede-87af-4fe6-a670-c0f41e7476e0"]
}, Open  ]],

Cell["Confirm for a circular contour:", "SolutionAnswer",
 CellID->171273046,ExpressionUUID->"ab98ab34-1209-4228-996e-3c052a4d8fe1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"Exp", "[", "z", "]"}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "5"}], ")"}], "3"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->16471763,ExpressionUUID->"03d7733f-6886-46fe-be40-752ac15dc721"],

Cell[BoxData[
 FractionBox[
  RowBox[{"7", " ", "\[ImaginaryI]", " ", "\[Pi]"}], 
  SuperscriptBox["\[ExponentialE]", "5"]]], "ExerciseOutput",
 CellID->389133411,ExpressionUUID->"587bd40b-7e85-400b-a662-6293b798419a"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->884116559,ExpressionUUID->"e277faf1-e5e0-4c74-b5d4-101e38728661"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"15. Cauchy\[CloseCurlyQuote]s Integral Formula | Essentials of \
Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem"}, 
        "PrettyTooltipTemplate"], "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "16. Three Important Theorems"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"46218761-2eb3-4c86-93d0-67e247fc5bba"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[659, 24, 249, 7, 108, "Section",ExpressionUUID->"04343c3e-1859-441f-a192-52b2d5a49bf4",
 CounterAssignments->{{"Section", 14}},
 CellID->731141457],
Cell[911, 33, 411, 7, 83, "Text",ExpressionUUID->"06da5be7-f314-4e01-bb17-1af2985851d1",
 CellID->382294426],
Cell[1325, 42, 702, 19, 60, "Text",ExpressionUUID->"a20ab71b-fb2e-44ba-ad60-3cb1e54925e6",
 CellID->127633416],
Cell[2030, 63, 774, 23, 59, "DisplayFormulaNumbered",ExpressionUUID->"e86ab3a0-18ae-428a-9061-9d7e27067d85",
 CellID->416097994],
Cell[CellGroupData[{
Cell[2829, 90, 9215, 247, 475, "Input",ExpressionUUID->"4d3d20b9-f42c-490e-a1c7-e21c444eb6b8",
 CellID->1438724859],
Cell[12047, 339, 4180, 90, 231, "Output",ExpressionUUID->"cfe20d6e-c69f-46d0-9ea7-bb48d3fe2911",
 CellID->1023569120]
}, {2}]],
Cell[16239, 432, 685, 16, 83, "Text",ExpressionUUID->"2ed5c27a-9ce3-41dc-9f7c-9b4f9312c33d",
 CellID->5769414],
Cell[16927, 450, 1925, 56, 117, "Text",ExpressionUUID->"f427b7e2-5f17-40f4-a32a-2d0fba26d31d",
 CellID->660764377],
Cell[18855, 508, 737, 24, 49, "DisplayFormula",ExpressionUUID->"7e9df5b0-899b-4145-928c-49766d0a19ae",
 CellID->23042944],
Cell[19595, 534, 593, 13, 83, "Text",ExpressionUUID->"c820aa5e-5bbb-4422-b587-e347c5e84b08",
 CellID->455256528],
Cell[20191, 549, 392, 12, 45, "DisplayFormula",ExpressionUUID->"c51fe9f0-9de9-4df6-908e-30a326cb625c",
 CellID->306044062],
Cell[20586, 563, 1512, 42, 90, "Text",ExpressionUUID->"a8e0af70-9b43-4123-be31-a1aa11c4c1a9",
 CellID->562277164],
Cell[22101, 607, 187, 8, 71, "SolvedExample",ExpressionUUID->"012454b0-f40d-427e-840d-235c8220d56b",
 CellID->117665326],
Cell[22291, 617, 519, 15, 43, "SolvedExampleNote",ExpressionUUID->"4536a4a7-c5df-424f-a517-7d8b0863bb69",
 CellID->202291452],
Cell[CellGroupData[{
Cell[22835, 636, 4335, 117, 70, "SolvedExampleInput",ExpressionUUID->"dea25f43-cfa7-44c7-8463-c5051c7f3d3e",
 CellID->399180990],
Cell[27173, 755, 1379, 32, 182, "SolvedExampleOutput",ExpressionUUID->"01b05ed2-5d96-42f4-bd7b-52b9312c2bb5",
 CellID->277819275]
}, {2}]],
Cell[28564, 790, 831, 21, 61, "SolvedExampleNote",ExpressionUUID->"7c2f17ae-87c6-4856-a44a-dfeeba2ae470",
 CellID->262963593],
Cell[29398, 813, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"4f6f8733-096d-4626-958f-78e520473f22",
 CellID->943814759],
Cell[29507, 816, 186, 8, 71, "SolvedExample",ExpressionUUID->"d74e37fb-c6b3-4cf1-8391-540f3dcafc14",
 CellID->48176556],
Cell[29696, 826, 525, 15, 43, "SolvedExampleNote",ExpressionUUID->"84fae0fb-f430-433a-a334-5fa625b749ac",
 CellID->6821212],
Cell[CellGroupData[{
Cell[30246, 845, 1519, 40, 47, "SolvedExampleInput",ExpressionUUID->"10e820ce-0424-4c5c-b350-38633d54748e",
 CellID->21937935],
Cell[31768, 887, 53137, 900, 203, "SolvedExampleOutput",ExpressionUUID->"d48e6498-8510-4aed-8bd2-1d4dc2d001fa",
 CellID->105762194]
}, {2}]],
Cell[84917, 1790, 517, 14, 61, "SolvedExampleNote",ExpressionUUID->"1b91f89c-fa55-4159-9209-8d7217cdd838",
 CellID->714916390],
Cell[CellGroupData[{
Cell[85459, 1808, 410, 12, 47, "SolvedExampleInput",ExpressionUUID->"16cd39f7-205d-4fe4-a1f4-eee183936301",
 CellID->37972597],
Cell[85872, 1822, 202, 4, 54, "SolvedExampleOutput",ExpressionUUID->"771cb174-964f-46e8-803a-b17b60cb2117",
 CellID->447388994]
}, Open  ]],
Cell[86089, 1829, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"29d0ba24-6c1c-41dc-9acc-90fae5a88d28",
 CellID->2040335330],
Cell[CellGroupData[{
Cell[86221, 1834, 116, 1, 56, "Subsection",ExpressionUUID->"1c1b46f8-9a7a-400d-bcca-7e2489bf70d3",
 CellID->651827160],
Cell[86340, 1837, 347, 7, 60, "Text",ExpressionUUID->"238925c3-18d8-4c1c-969a-28ab6f04ff95",
 CellID->25166690],
Cell[86690, 1846, 1445, 41, 66, "DisplayFormulaNumbered",ExpressionUUID->"9d1c4db1-c700-4d8d-ab9b-2d92583845f9",
 CellID->498145113],
Cell[88138, 1889, 1075, 29, 83, "Text",ExpressionUUID->"a1e14215-ae53-43c0-b1f8-1e24f555bb48",
 CellID->332768962],
Cell[89216, 1920, 184, 8, 71, "SolvedExample",ExpressionUUID->"76408f86-1f02-4a9c-a012-d077a44c2b59",
 CellID->283395],
Cell[89403, 1930, 569, 15, 61, "SolvedExampleNote",ExpressionUUID->"e47cfbad-c2dc-468e-9073-dbac9f559392",
 CellID->256435896],
Cell[89975, 1947, 209, 5, 25, "SolvedExampleInput",ExpressionUUID->"da4d2d4f-a2cf-4ffc-bc07-a4a316728db5",
 CellID->35141512],
Cell[90187, 1954, 287, 8, 39, "SolvedExampleNote",ExpressionUUID->"c60b06b9-fb1e-4338-b115-cb42f789fd7c",
 CellID->129659950],
Cell[CellGroupData[{
Cell[90499, 1966, 142, 2, 25, "SolvedExampleInput",ExpressionUUID->"cd06d41c-efee-4369-ac50-2f1e8ca09969",
 CellID->202225552],
Cell[90644, 1970, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"78ec4b58-f4e6-472d-a6a9-5ed61f948332",
 CellID->348687955]
}, Open  ]],
Cell[90775, 1974, 1178, 36, 43, "SolvedExampleNote",ExpressionUUID->"bc1ad5e4-9fd9-4906-9732-9638655e6123",
 CellID->14416421],
Cell[CellGroupData[{
Cell[91978, 2014, 540, 16, 47, "SolvedExampleInput",ExpressionUUID->"61a23c5f-cb02-481d-a4b4-3e23bee18e4f",
 CellID->248128950],
Cell[92521, 2032, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"f175b572-747d-49e8-934f-a9d40aced7f0",
 CellID->145985437]
}, Open  ]],
Cell[92652, 2036, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"d5ca3616-42ba-4bf1-b6e1-fa3102e082e7",
 CellID->1775975144]
}, Open  ]],
Cell[CellGroupData[{
Cell[92796, 2042, 157, 2, 56, "Subsection",ExpressionUUID->"cb76ba6d-cd31-4078-9e80-68ea02c01659",
 CellID->674965709],
Cell[92956, 2046, 140, 1, 36, "Text",ExpressionUUID->"551a3aea-06cf-41a2-89f0-4fb6a192b88e",
 CellID->435373346],
Cell[93099, 2049, 561, 17, 50, "DisplayFormulaNumbered",ExpressionUUID->"43e1a38f-44d4-4691-8831-82d7a7e1e9d5",
 CellID->235646558],
Cell[93663, 2068, 767, 20, 60, "Text",ExpressionUUID->"432d71ed-e83d-4126-b258-3e8dd9e69354",
 CellID->50207621],
Cell[94433, 2090, 286, 7, 36, "Text",ExpressionUUID->"32405afd-8468-45e1-8f0f-8118830ab806",
 CellID->441775637],
Cell[94722, 2099, 708, 22, 61, "DisplayFormulaNumbered",ExpressionUUID->"1f17bb23-5529-413a-881c-8f5852f19e5e",
 CellID->535607176],
Cell[95433, 2123, 502, 11, 60, "Text",ExpressionUUID->"e3916754-919f-4fe6-9461-0b124b2ac5a9",
 CellID->215387463],
Cell[95938, 2136, 627, 13, 83, "Text",ExpressionUUID->"b1f64dac-089b-40b1-8ad1-049c29ef3382",
 CellID->653011000],
Cell[96568, 2151, 137, 1, 36, "Text",ExpressionUUID->"fcc1f581-8813-4c33-bc7b-86cd6a44a4ed",
 CellID->670564336],
Cell[96708, 2154, 186, 8, 71, "SolvedExample",ExpressionUUID->"9ef5a4b2-4c38-47a3-ad6b-faf274d1b207",
 CellID->84667823],
Cell[96897, 2164, 737, 21, 44, "SolvedExampleNote",ExpressionUUID->"74649dd7-0202-40c1-97c1-5eb6230cf835",
 CellID->812420734],
Cell[CellGroupData[{
Cell[97659, 2189, 1544, 42, 51, "SolvedExampleInput",ExpressionUUID->"648d1015-4be6-4a92-afbd-478dafd80135",
 CellID->55863097],
Cell[99206, 2233, 50803, 861, 202, "SolvedExampleOutput",ExpressionUUID->"5be79c29-73a6-4c63-aaef-a956a0b6b778",
 CellID->1887807719]
}, Open  ]],
Cell[150024, 3097, 392, 10, 39, "SolvedExampleNote",ExpressionUUID->"d0008120-bebb-4ad4-8768-c0ce9f8ac2e4",
 CellID->239142860],
Cell[150419, 3109, 954, 29, 44, "SolvedExampleNote",ExpressionUUID->"bec2f3a0-9548-4d4a-9b46-9183356cc704",
 CellID->136139264],
Cell[151376, 3140, 180, 6, 39, "SolvedExampleNote",ExpressionUUID->"6a8b1a07-8a81-40ca-8ec6-44597b86aa83",
 CellID->177479],
Cell[CellGroupData[{
Cell[151581, 3150, 465, 14, 51, "SolvedExampleInput",ExpressionUUID->"71f73c04-daf1-4279-96cf-7ff97f6606f9",
 CellID->111089734],
Cell[152049, 3166, 221, 4, 36, "SolvedExampleOutput",ExpressionUUID->"d669345b-0ca4-48c8-93f4-37dd22c2ce4a",
 CellID->64337928]
}, Open  ]],
Cell[152285, 3173, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"e43606b9-4062-4217-9a8f-7f11b6c4dcf3",
 CellID->290432513],
Cell[152394, 3176, 187, 8, 71, "SolvedExample",ExpressionUUID->"a0e80d68-9410-49bd-a5e4-6bd5cd5ec1ed",
 CellID->105821735],
Cell[152584, 3186, 757, 22, 67, "SolvedExampleNote",ExpressionUUID->"da1cadb9-64fe-4d15-a961-25de7b4e1bbe",
 CellID->724715829],
Cell[153344, 3210, 1109, 34, 45, "SolvedExampleNote",ExpressionUUID->"082d34ba-027c-48dd-ac97-45e0991eb076",
 CellID->33406630],
Cell[CellGroupData[{
Cell[154478, 3248, 365, 10, 51, "SolvedExampleInput",ExpressionUUID->"085c7968-4963-48c0-af74-10e5a1e24c0d",
 CellID->478679220],
Cell[154846, 3260, 164, 2, 36, "SolvedExampleOutput",ExpressionUUID->"ea8d40d1-9e85-4938-a067-97885be0cc5c",
 CellID->195707251]
}, Open  ]],
Cell[155025, 3265, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"e78cbd57-4341-4329-b8a1-003e5612b7e2",
 CellID->316889252],
Cell[CellGroupData[{
Cell[155156, 3270, 109, 1, 69, "SummarySection",ExpressionUUID->"6f1af9cb-faf5-4595-882f-434bd0b56970",
 CellID->1198545324],
Cell[155268, 3273, 363, 9, 29, "SummaryList",ExpressionUUID->"d9fb3e30-a2dd-438b-958d-22746f048cf6",
 CellID->155871797],
Cell[155634, 3284, 489, 15, 49, "DisplayFormula",ExpressionUUID->"35eca50c-715d-4922-911b-3f41b84f7c90",
 CellID->312760059],
Cell[156126, 3301, 178, 3, 29, "SummaryList",ExpressionUUID->"ca47861d-7fed-43e3-88db-2f78e0291965",
 CellID->470955442],
Cell[156307, 3306, 741, 24, 51, "DisplayFormula",ExpressionUUID->"2d8ce16f-bd6a-41a4-8e5a-46911ea0a4cc",
 CellID->173794401],
Cell[157051, 3332, 255, 4, 29, "SummaryList",ExpressionUUID->"8261ff34-cb79-4419-ab92-ae02d167ddcf",
 CellID->207209504],
Cell[157309, 3338, 172, 3, 29, "SummaryList",ExpressionUUID->"c36df98d-14a7-41f6-833a-21a386bbe185",
 CellID->97037780]
}, Open  ]],
Cell[CellGroupData[{
Cell[157518, 3346, 159, 3, 65, "ExerciseSection",ExpressionUUID->"dfb1725e-390f-4ca0-9a36-ffe59adb3041",
 CellID->50506963],
Cell[CellGroupData[{
Cell[157702, 3353, 798, 23, 33, "Exercise",ExpressionUUID->"82ea1fe5-de07-4dae-9224-ae9f03d06927",
 CellID->385112845],
Cell[CellGroupData[{
Cell[158525, 3380, 3003, 83, 170, "ExerciseInput",ExpressionUUID->"d7a91960-2f8f-408b-91ba-b424371965dd",
 CellID->794065569],
Cell[161531, 3465, 48699, 827, 195, "ExerciseOutput",ExpressionUUID->"0a3cbea8-3899-47b6-bd84-ffa04360d4d2",
 CellID->884795037]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210276, 4298, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"bd220f71-d652-4d79-82f4-beb6ecc9d2c2"],
Cell[210370, 4300, 754, 22, 26, "SolutionAnswer",ExpressionUUID->"16cbf0ce-7c9a-4c4b-8d9e-c5e34da76006",
 CellID->123504017],
Cell[CellGroupData[{
Cell[211149, 4326, 399, 12, 45, "ExerciseInput",ExpressionUUID->"1d0edca3-2989-4d43-8913-b8f090193f8b",
 CellID->532740583],
Cell[211551, 4340, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"b6c36ae6-0d5b-43b3-bb12-33aad3a47863",
 CellID->282452106]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[211759, 4348, 826, 24, 31, "Exercise",ExpressionUUID->"4edbfe18-664c-4d59-ab21-2f4fc44db66e",
 CellID->59838584],
Cell[CellGroupData[{
Cell[212610, 4376, 2983, 84, 154, "ExerciseInput",ExpressionUUID->"c0602cfb-e61b-4d36-b558-c7754474b366",
 CellID->784666982],
Cell[215596, 4462, 47467, 806, 195, "ExerciseOutput",ExpressionUUID->"b078873f-4057-4611-bcdb-301543f780f0",
 CellID->857192863]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[263109, 5274, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"a05f55e3-5535-4767-863c-04e3da3fa520"],
Cell[263203, 5276, 796, 23, 28, "SolutionAnswer",ExpressionUUID->"f9f47c75-1084-4134-8201-26101b914332",
 CellID->538437555],
Cell[CellGroupData[{
Cell[264024, 5303, 424, 13, 49, "ExerciseInput",ExpressionUUID->"c7ca34c1-7f1b-4db8-9b1e-036554b8352c",
 CellID->1196601],
Cell[264451, 5318, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"831af3b2-1f2a-4c99-b338-6f88509c4aea",
 CellID->43671960]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[264659, 5326, 613, 16, 44, "Exercise",ExpressionUUID->"65ee2b9f-13a0-43c8-b90e-17c949e00728",
 CellID->74090572],
Cell[CellGroupData[{
Cell[265297, 5346, 1981, 56, 77, "ExerciseInput",ExpressionUUID->"b2fc64d1-7944-461b-bc86-e5ec51709453",
 CellID->175757203],
Cell[267281, 5404, 43097, 736, 195, "ExerciseOutput",ExpressionUUID->"852168e5-5c51-4618-b754-39dc432d4c2b",
 CellID->864919447]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[310424, 6146, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"79b76d5d-1f7b-4d47-8aff-f66e53716ca8"],
Cell[310518, 6148, 121, 1, 22, "SolutionAnswer",ExpressionUUID->"ad33cd0e-8e4a-41c5-a4a5-42d9e389c6fa",
 CellID->399144589],
Cell[310642, 6151, 225, 6, 25, "ExerciseInput",ExpressionUUID->"53e0607e-302c-49f5-8259-c4179af750fa",
 CellID->177141838],
Cell[310870, 6159, 280, 8, 22, "SolutionAnswer",ExpressionUUID->"42c9d5cf-8451-44be-9993-3772b22ceac6",
 CellID->65646841],
Cell[CellGroupData[{
Cell[311175, 6171, 137, 2, 25, "ExerciseInput",ExpressionUUID->"43b87a7c-545c-42c1-9b83-769cecd77b25",
 CellID->219616554],
Cell[311315, 6175, 125, 2, 28, "ExerciseOutput",ExpressionUUID->"a29da767-d1cf-4b0d-9339-8d25d8d315d9",
 CellID->132181]
}, Open  ]],
Cell[311455, 6180, 124, 1, 22, "SolutionAnswer",ExpressionUUID->"6d91041f-3bd3-478d-9588-4b55a6763d70",
 CellID->73866957],
Cell[CellGroupData[{
Cell[311604, 6185, 523, 15, 45, "ExerciseInput",ExpressionUUID->"b5ecf7f8-ca43-4b48-b91c-7a67cbafea48",
 CellID->455766353],
Cell[312130, 6202, 129, 2, 28, "ExerciseOutput",ExpressionUUID->"556f1e61-17d4-4618-8c3c-5bec8208dff8",
 CellID->1002428695]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[312308, 6210, 867, 27, 31, "Exercise",ExpressionUUID->"dfa2f25d-7cd5-4d52-91d8-d0d12b155dbe",
 CellID->634626211],
Cell[CellGroupData[{
Cell[313200, 6241, 3174, 90, 193, "ExerciseInput",ExpressionUUID->"c9347202-b94a-415f-939a-ebd067a4f68e",
 CellID->116267116],
Cell[316377, 6333, 48761, 828, 195, "ExerciseOutput",ExpressionUUID->"cefb10f2-5354-4480-86cb-e518e0025e65",
 CellID->488793168]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[365184, 7167, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"eaa2e67f-088a-43cf-b9eb-fc09d72cd5d4"],
Cell[365278, 7169, 159, 2, 22, "SolutionAnswer",ExpressionUUID->"85c6ab81-7e4a-4366-baca-590c1a9e016d",
 CellID->383961777],
Cell[CellGroupData[{
Cell[365462, 7175, 488, 14, 25, "ExerciseInput",ExpressionUUID->"2765e0f8-b9db-4ea4-a429-f168ace2f327",
 CellID->439329399],
Cell[365953, 7191, 327, 8, 45, "ExerciseOutput",ExpressionUUID->"3e0952ac-7748-41b4-a03a-646e99f53803",
 CellID->235507395]
}, Open  ]],
Cell[366295, 7202, 131, 1, 22, "SolutionAnswer",ExpressionUUID->"e0978c1e-fe21-4842-ad09-6a1a04e5cc67",
 CellID->15174699],
Cell[CellGroupData[{
Cell[366451, 7207, 515, 16, 50, "ExerciseInput",ExpressionUUID->"d2dc7d4f-5407-44c6-b8e3-1edb69ee7a9a",
 CellID->199378461],
Cell[366969, 7225, 327, 8, 45, "ExerciseOutput",ExpressionUUID->"d244184e-52fc-41bc-a848-6f6a533b94b8",
 CellID->146854002]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[367345, 7239, 890, 28, 34, "Exercise",ExpressionUUID->"45fbeb2c-58e9-4fa0-bd89-c060eb3de528",
 CellID->69563545],
Cell[CellGroupData[{
Cell[368260, 7271, 3477, 101, 195, "ExerciseInput",ExpressionUUID->"91416c31-9300-4021-8726-72c84cda69a3",
 CellID->523873467],
Cell[371740, 7374, 48017, 817, 224, "ExerciseOutput",ExpressionUUID->"9f376145-8a41-422a-85d5-222535edfb59",
 CellID->2033757126]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[419803, 8197, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"7e3dbca3-8a25-4dec-8675-d8cc773aad85"],
Cell[419897, 8199, 159, 2, 22, "SolutionAnswer",ExpressionUUID->"e8ff89bc-34c1-4e4f-9221-3bb6172ee5cd",
 CellID->622813021],
Cell[CellGroupData[{
Cell[420081, 8205, 511, 15, 27, "ExerciseInput",ExpressionUUID->"d11e0f7e-6a72-452c-ba9d-cc9014300fc8",
 CellID->18813251],
Cell[420595, 8222, 217, 4, 46, "ExerciseOutput",ExpressionUUID->"f2408ede-87af-4fe6-a670-c0f41e7476e0",
 CellID->11225626]
}, Open  ]],
Cell[420827, 8229, 132, 1, 22, "SolutionAnswer",ExpressionUUID->"ab98ab34-1209-4228-996e-3c052a4d8fe1",
 CellID->171273046],
Cell[CellGroupData[{
Cell[420984, 8234, 536, 17, 52, "ExerciseInput",ExpressionUUID->"03d7733f-6886-46fe-be40-752ac15dc721",
 CellID->16471763],
Cell[421523, 8253, 218, 4, 46, "ExerciseOutput",ExpressionUUID->"587bd40b-7e85-400b-a662-6293b798419a",
 CellID->389133411]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[421804, 8264, 309, 6, 135, "SmallText",ExpressionUUID->"e277faf1-e5e0-4c74-b5d4-101e38728661",
 CellGroupingRules->"SectionGrouping",
 CellID->884116559]
}
]
*)

(* NotebookSignature hScVkL8I@cQVYkIkDm6SnOJ6 *)
