(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1399127,      26081]
NotebookOptionsPosition[   1232778,      22619]
NotebookOutlinePosition[   1371059,      25567]
CellTagsIndexPosition[   1371016,      25564]
WindowTitle->22. Holomorphic and Meromorphic Functions | Essentials of \
Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Holomorphic and Meromorphic Functions"
}], "Section",
 CounterAssignments->{{"Section", 21}},
 CellID->66509986,ExpressionUUID->"6f177a3d-8842-4ec2-be54-d20404de82de"],

Cell["\<\
In this chapter, you will encounter some important terminology pertaining to \
the analytic properties of complex functions.\
\>", "Text",
 CellChangeTimes->{{3.968834509197134*^9, 3.968834509700926*^9}, {
  3.9739013891340446`*^9, 3.9739013902177763`*^9}},
 CellID->226166649,ExpressionUUID->"e621fd5a-eca6-4ac5-b1b7-223999a50c9a"],

Cell[TextData[{
 "You have already encountered ",
 StyleBox["analytic",
  FontSlant->"Italic"],
 " functions: analytic simply means differentiable. Analytic functions are \
also called ",
 StyleBox["holomorphic",
  FontSlant->"Italic"],
 " functions; you have seen some of their properties in the previous chapters."
}], "Text",
 CellID->13748183,ExpressionUUID->"96c268c2-e16b-4e9c-b0cd-8faf70b2e76f"],

Cell[TextData[{
 "A complex function is called ",
 StyleBox["entire",
  FontSlant->"Italic"],
 " if it is analytic for all ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath",
  ExpressionUUID->"872512e0-a722-45c1-86d1-1eb8fdd29ea2"],
 ". Examples are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", " ", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8ee6c554-03de-43a0-865c-dbd07a3d5b3a"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", " ", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8ecfc3e4-ebd7-48d7-908e-d1f3381f6463"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", " ", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "59cecf9b-0f9f-4f15-bdac-1f9dc95c2e80"],
 " and polynomials."
}], "Text",
 CellID->17059917,ExpressionUUID->"3bc970ae-6773-4b1b-bd21-ec7757cceb75"],

Cell["\<\
In the rest of this chapter, you will turn to the important topic of \
classifying the possible singularities of a function that is not entire.\
\>", "Text",
 CellID->107223087,ExpressionUUID->"7012741f-fed6-4704-becf-7e5be49a1b8e"],

Cell[CellGroupData[{

Cell["Classification of Singularities", "Subsection",
 CellID->18480651,ExpressionUUID->"8fe03454-021d-40c0-a5ab-751805f90066"],

Cell[TextData[{
 "A singularity of a function is a point where the function is not analytic. \
Singularities can be ",
 StyleBox["isolated",
  FontSlant->"Italic"],
 " or not isolated. A singularity is isolated if there is a neighborhood \
where no other singularity is present."
}], "Text",
 CellID->107936015,ExpressionUUID->"df5af95a-f7c7-4fa3-9dc4-309d5eab9fc1"],

Cell["Isolated singularities can be of three types:", "Text",
 CellID->854918598,ExpressionUUID->"64320ab3-56e7-49cc-9817-54775ffccc46"],

Cell[CellGroupData[{

Cell["Removable singularities", "Item",
 CellID->241094657,ExpressionUUID->"666155b2-5950-4179-a4d1-1b9574b9a3e6"],

Cell["Poles", "Item",
 CellID->17740760,ExpressionUUID->"737f36ae-fb30-49d2-ab6d-c107b2f28633"],

Cell["Essential isolated singularities", "Item",
 CellID->44686422,ExpressionUUID->"77c839bc-2de6-4622-88ae-8a8feefb9f01"]
}, Open  ]],

Cell["Non-isolated singularities can be:", "Text",
 CellID->260973285,ExpressionUUID->"0c4ccd52-243e-4bd2-b497-d4903f19084d"],

Cell[CellGroupData[{

Cell["Branch points", "Item",
 CellID->907524377,ExpressionUUID->"ff1d3ff4-3cae-48c8-822c-0304ff68b817"],

Cell["Points of accumulation of other singularities", "Item",
 CellID->386583975,ExpressionUUID->"47a63a1f-fdcf-432d-ac27-b9794b4e51e2"]
}, Open  ]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->118567754,ExpressionUUID->"5943839c-ecb4-4357-92ca-8266b97f35b8"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    RowBox[{"sin", "(", 
     RowBox[{"\[Pi]", "/", "z"}], ")"}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e490f1f9-e260-4afc-99af-4ca277cdc6a9"],
 " has a singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "279f31e3-b100-4a31-80d9-bcaed2287701"],
 ". It is not isolated, because the denominator has zeros at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"1", "/", "n"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ce904265-4246-4588-9895-3ff612d594bb"],
 " for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "4ef61988-26a9-4da4-ad6c-3a0a718ec1b9"],
 ". In any neighborhood of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6827b5b3-facc-48a4-be7c-54bf84d5a700"],
 ", there are infinitely many such points. Plotting the function for real \
values of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "68013e41-464c-447d-b481-c251ed332114"],
 ":"
}], "SolvedExampleNote",
 CellID->23879849,ExpressionUUID->"88f7c893-7761-4172-8a2e-adcbb94bc518"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", "/", "z"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->394488119,ExpressionUUID->"73cc0d81-513d-4f3f-89ec-9db290c2dd2e"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJw9WGk4ltvffQwRIvMUJ6SUNIkGqSSkHClKUdHAKWWKDIdkaFJRoiiVBtKA
MlWSrLuicITwDPczUhKabjzGDP/7ej+8n/a1rj2u9Vt779/ehvuDXH0lGQyG
lASD8X+lVPENhpsIdfktUa239An3YGljXScRmg6uzMveqEdkmKq+VXMQoeHE
HWtBwgyC0zFzr+I6uj33bF76e11il8eqm4zlIrQ5PBftP6xD3FTbaDW6RIRn
jPQCtVptQvjRndNvJgKHOP0qepE2sdc2RP2bkQhhUrV/3FW0iLtjscVt+iKI
QtLruRc0ic/Pk7dwtUXY9HJjnMU0TcJn/qOkj0oiWDstXSTW0yDuf31u+kFO
BFeFD2eK89WJzttVNYS0CO+plv4BG3XCT71NunRUCDFD30AiXI143PDzXsGA
ENG7SyZdNNWIH4l/bB5QQqzVKXJYUq5KBI5rxmR2CtGG3Yu+KagST18Yz7jS
LsS/PxKj9r9UIaij5i+T+UL8NzOgq8JPhQjpdB6IaxbiwJ4Bq+PNykRE46mA
g5VCaBWvDFoXP51I+h7OFpcJ4cdiOJ0bViLuyfqtSygRwiDG2MrzmBJRv9ZZ
49ZDIWK9PseURyoSn3etjTXNFmJNSJFsB0ORGIpY0v3iFj2+UfzZuqRphFGh
xuvmVCFIpvvmWU8ViBX1siZ7k4W440dtdbBXIJy7RlJ+nhWiJc3v4FmhPBFp
IPSZGiNE+L7ieQIdeaIhJXfamoNCrAybtiK5cCrRkX8t/L99QuhmZfzYsHsq
MVJzvm3nbiE0I4qK1shPJYwlgkpDtwrRO/NX1Tl/WSLq6PLdj1bR/K7r/zzq
KEOkJM97v2yZED8qj/3TJiVD3H80Y3HVYiGkX30cGCSmEE3tk1Ki2UJ0BjUr
f147hZjjWpOnrixEmdeyJdYu0oR1YLnGPXmaz98ReiGa0sTW8/mxi6YIke/4
z7LvQini+NsUt02jAhQZ13ueCJUims09/sR2CNB4sW7WrMeSRNdmJ19FkQBj
roFivyhJYvzw6sZMUoB+1fHGfCdJYm62YfazBgEK72+Jl+uVIGLUejZ9LxMg
eKJfdr+DBJG6iF8aWSJAcrTmmjp9CeKhU8NfMk8ESKzs/z46wCCaTxb3GWQL
cG9/08o7DxnEXHFUpnuyAPNGLn8N1GQQra0KPW/2CWB9NIlxyWAC8T7PKvN2
C+B9XPWMWtc4Foq90q7uEEAz7EB2XOE4EtWKrf2cBWjtvhPCsBvHatedl5RX
CnDd5uAclbAx5DbmWHgrCxCl3CVV/mcUbt6b5TYq0OthxkwWNo6C8XtIYC4j
wEab5xmbc0bhqeR0VmaMj5PMW63BLqOY7txLFnzjw54YzB3LH0Fk3erYsUo+
apOLx2oThjHb85tb50s+sq74K7Z6D6O5O2VuUykfr9JkTD1XD8NMruNT9mM+
HMLPqTWPDKF9w3ljp3Q+7p9/7bYicgibqlm11wP4GHD9k2x7bhBD2+KyTh7i
47NWbMvcgEHkdMwLDTjAh8nNt5mBWwcxKRWjt86Dj/L0B92qMwZRajsrqMuO
D9aT7P6M4gHoE0Hqy/X4mHH/YFdErxj1qpbHrLT4aPt5+KUpT4wo39GW1ap8
XPnACZxTLQZL/nSa3VQ+nn6YWy6+LkbK9kxVVzEPB5kbt7c4iCH1vUo5oJ6H
ly7dC/j5/ShefT44+AMPDTGFK59l9mNviktT6FsenH/fVatL7EeFJfdSVBkP
N3R3xOT49iM87rdSYg4PV+3uTsgZ9aNbQ1cx+zgPOZFl3ir3+3DtkMg/N4IH
Y/NbJnvS++DwKqf+UQgPdtMn/Hhn+3Bv76KkwkM8fJQ4eDTgSB9259kpVG6j
55s4ms216IP8hNyRNy48LLPJtCsw6cPLLY11VZt4qPqxuPaJbh80Bz3O/2fD
g/hYmshaog+NNkFypBkPuRY2YVFNvTiRZuHHN+FBX8Jq+8uqXph1jtSIjHiI
r36qbfyyF4kXTiV2avOQz+rui77XC1vWdVmxNA9hZs+kzCJ68exI1ZTpAi5a
e1T8/p7bixUGgUty2Vx8VZifsvevXpS3au1Z3cxF/dECxWz1XhCrj5Qe+cAF
88CnX0USvaibrnqgpogL6RPjE78FFJyrXl30zudie868E0FMCk2RvuWDuVzY
XmNvm/GRArO9TGX2TS7yb1xeOlRBoa3Em4g/w0Vj1h/P8iwK+w/J/dCO58JR
3n1+RgaFr3olWoXRXBQ/O9aWlUKh57RMkDCYC97k9YMLT1IY2FGgv2oXF/we
jwObDlOInLZjY/N2Li6GaVVH+VAYJRhhflu4UA5z/ovpRYFhuq0+w56L3j07
D8puoyA/NholXsTF+tyIjL02FJILc3IvmHIRXenUI1xFQdl3c7PRbC4uzZev
O7OcgkbD3XlbdbnQ4HYZui2icC3BaXuXOhdk65RrEfMp6C4fiIudzsXgL/mM
ahMKBnccOQXSXPzweWErNKBwb1uflP0kCf9/tSce6lOYLXdzEX+ERP1dnvct
XQoPX9vvChWTWJtbdOyVFgXTkN9n5H+TiCoPdZLSoFAw53rx3W4S12AycEyV
wmKerXBFB4n+T9KnlZUpWNqlWx4kSbBMTZ9WK1AoG167b6KFhIS6dLRIjoJV
QXfS1QYSZLplyqypFF7vSyszqyVxWnWVYqoMBRvN1R3v3pHYLd2hOn8Khbd1
ndN3VZLwYHpU/ZKiYB+bsqqvjMQIw2SDQJJCzVKrg+dKSFRnrHk3KEFhU9eX
VIMnJO7OlD6wisYfbyZXvnhIwrnVzS2PQWHL1uU9m7NJ/LvpwjsHGjdPadfo
vEVCOjL1qyKNt5efXxdzjYSO8defDBpzAi0C1NNofm9uqhnQ2HOW8FpeMgnH
l1EpR2gsYJ+tsk0k8c/M/jtfaLw3aQlFJpBw6Fh+KpGeP6o09czHGBIt1C5l
J3q9V/n9em8iSZx5P1fbkuZTKL29pDSUxOEfj5gO0hTqzJ5vfBhIwv7CrNNx
NP+ObVptN/zo+Mjq+X6m9Zk4Hhl+yYfE6JDvc39aP+375LST3iSsw00rZspT
WPrRKjvck8RmZv+rP7T+mwdurDy8nUTpi7JxhhKFQ/rjjXu2kOhK/vbfIjpe
CfZe/2x1IhF2IiQ0kY7nzQCM2TmQWPeKt16BjvfzqwZpK9aRKNxge6mM9sOn
1/HzzKxJKC4NepxC+0VGyc5dzZzECqevhW9pfxksu/9DZgGJ9PMpbvrGFFZ5
yZwcNSFxYXGHRQ7tx+AnNU/b9Wl93d1sV9D+Pc+a58DUJnEnK3i1w1IKORPn
+TVqJDYt2a2RQPud3OwsVyhHwujhJb3T9P4Qhz+5nS1N8x3KsnC2p6B0e/qy
jEkODjWY/7HbRMH296f9JwY40Kl7dqGa3l/5l9wr/m7noK9izEXHn8L7Fy9c
bfgcmOrIewaEUGgXaXcvZXNQd83CdyCSguZinsaMjxx4PTsxkH2GQmyTd1B3
GQcveuesTM6hkDlMTBGUcDD+3ulwWj6FUgOjm01POLhc1CPZUkqhK7ij5kUO
BzGenccl3lNwVfEzOpPCwZaEV87m3yn4r6wr+/cCB/fX12zRHaBwdt98l4Az
HNxaczbcdpJCRdHP6G3HOZj5IGvCnT7vZruGMI0OcWDyVnp3wbpe2ES1HNE8
wIHxz/v3ip174XnPQlLeiwPhcrNQhmcvLvYNLux144BzMux4VGgvhlOjE7GW
g6LCRyUKj3vxTe9Nj4MVB5ODxXFF9PnMypVxbrDgYJadifTL2l6UlF9WEczj
YC1z6hdxTy8CPz/IHFWj6111TnuY0/eH/8+xeCUORiJKjB3s++A0aO4tJ0fz
0/K/c39nH+bKV87SnmDDXebpnA9xffiypDXfsouNHtl9hiJWH5pf6Ux//ZkN
/wOd9fk/+0DYex+1E7BxmqGYKzWlH1kePZZuzWzoJUoOeVj2Y2c8A8EVbIRP
Pe6rcKsfGxQcDIefs/FfU5LGqbJ+LLt64WRsERu5BaqHslv7ofZI0/FiLhtz
fK/s/6YkRkOT2ae8FDbGn3xcPTVJjArPkKVLL7CxJcg9aUWBGHkdL66Wn2bj
ms91ueWNYiQO23rWRrFxYp6j1XONAaw38PjS6cOG20CT4tGCAZg/zrIP9GbD
5x/b/irmAAwsOh4MeLBhrrnGWn9yABMbgvylXdiotFDk/Nk2iLKg0wOGK9m4
ktnm4a80hAcjdTseLWWjY/GHLfy1Q0g/qVy+eCEbd/NJ1s2QIYRm3DixdhbN
/5Rc/Br+EBaiSHaPIq2XTkVtwJth6G0c8uuQZSPZiu9dMzEMhRbr+iOSbPyV
ad7cvnoEXZ0fUqKGWDjw4uL19DcjyFYS6lxrZ0FHR/DQqH0UqbvWyq7ks7Av
dfGE7oI/SHh4R0yyWHR+scFxX/Qf7Lc90DijnoWFQw/9rWeOwfVSVUXFexaO
ST5wkqXzQVv+7Md73rAg9WX93qSPYzAK7zp1+zkL5l7fPq4/Ow7VdxtDbIpY
2FlW71VO55uSynne7XksRMY//xLqPIHPjwKsZt1l4c2v2+u3Gk7inqDvd+4F
ur9x3xphNININd0m2HCGBZ+bmcWGFQwiIeJZXVccC5JnZ+1ummAQ+1Ui75uG
s9Dl4zl/5IIE4epFpv4XzMKwcsuHSpYEYZtnFed/hIUXEUpyZ40lCUP7cc8n
e1kws8kb5NRKEsqpXo4uu1iQlt7xtcZQimCIYEltZyHC0aU2MUaKaItMUDZ3
YqH7X7FU5Dppoqn6y3izPQuV1J4jlo+lCULV/nuoDQuFGVeXt2lNIe7ky75/
ZslC/uVbWofo90bKyKES98UsWPRpBConyBBxDnV3hkxZmNtwrmeNrCyxty0p
eqUBC835K4ptTKYSWxb8OsTVZUHeY9J63buphE2Ui3u0BgvC6g1hcw7JETPV
VZe8lmdB1Tuv8EOjPKG0L/Qvrym0Pp6ltduvKBATBa0Kk5NMfFjAiTvmO434
NWo5cnuUibv1tQf22CkSwg0ZnTYDTIiquw2PmSsRDVeGW9p/M9F8J03ovGQ6
Udnu8Sahhwmv3/On7TFUJrKi9W5WiZhIK0glh1xViIs1Med8uUys3+OdFzah
QpzQEIXLMJnIitauiy+j36f7bXweNDLhwr04Q/akGuH19O5WxzomftUueL5p
rzqxeUxybXcVE5+rg9Ml3DSINRt9zM6DiXkpb3r8vTSJhenVOvPLmZjJTzsc
e0aL0P8yR7a+lIlJmXuO05u0iWmLE8X+T5m4bDJTSnedLjF2vLtd8TETmW8/
TRq2zyBMR6Z9ncxh/v//wP8A1A8JKw==
          "]], LineBox[CompressedData["
1:eJw9lnk01d/Xx28h85i4MoQQZUpz4RwhkVCRopIhRKlvlKFJAyolmVJJSYpU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          "]], LineBox[CompressedData["
1:eJw9Vmk0lY0WPjjGhE83ZMoQqbgfKWRIg0KRTGlAg1JJMmRKIpUGJYpTdESl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          "]], LineBox[CompressedData["
1:eJw9lGlUlHUYxUc2WQYRSCFWNRhK8YCKSEg8f4mljiKbsaXiYJCCIqEsaiwC
4XBc0QYMhkVZFEkFBwnKeBB4l/G4BJmAGAkYxuL0DsswIFL0pQ/33HM/3fvh
d+7KyEOBUWo8Hm/3gv7zq21LBvhCGU4tSg68U2ZJVtFFb15/LsNkeXTHxCsz
cnrIzUkjQIbEf2CZ8tlyotTqO2DmLcOrr/UHvfuMyR679ErHzTJsfBy64/hF
Q3LfZ0Wft6MM9bbLy8Q5BsRp373lu2xlmBc/Y7Unn09KRJF+h81k+OHBCEve
B7pEp1pdlGsgQ6FPQ32itTY5IqtoKdWQ4Vvd4udP92qRvmGvmTszLN6Uatza
OKRBPtF9te6BnMW4A31TDYXq5PZqUczAIIsxouUmYSlqxLpjT9OaHhZtmxO0
z329iJxO/lA78RGLgefT3TMlPKKyNAppbmOxgFoSYHHtH4hqH6lc3MSi8806
w9swD50xbZP+N1mM1Ewo3Do7B+6Gko8Ly1l8HnFDvvfXN1Dzw5ELg5dYPIx+
Vi7MLJju9u23P8ui+PXhI2WdM5CtIXBMymKxqra1dHxcBYrr82mYwmL6RpOM
EVsV7A7oeqgdx6K2oPDvgv3TcH/6lkXgXhYPPRQE+d9VwqYSUWxRKIuEZ7a0
3EIJFZ7CH1/6sjgs1yX+uVOQmmcUmuzCok+0zfyJrEkY2TRa1bKWRT2x0bSb
wSQE97VN6bzHYm/7iqk75RPQli3xDDJl8ZqiwdyHTIDjmsSLEn0Wj9X2Dux6
OQ6SDt+BP9VYrJbyqlLOjYNOimCdg4pBN/53Ypst4zDQ3vXo3gCDCRWrfq5o
UIBfbK2lXjeDrZJzgsdHFXDXMPfAjocMynfm/eLkoYD3G4U/FbcyWPTiBBYY
KEC821X31Q8MhtxnSu71c6CmaRzmeIPBxpTz5lmNHMTVjF49eoXBvs2PwqQX
OegNaFe2FjBo/GJbhsNhDj5RSbz4Zxi0OLMt7FkwB3dKEr/9LJNB2alLmhJ3
DlZ5bR8sSWYw71Bmi3A1B2dHBev/OsCg/fRZqaUZB2/y/slYF8lgec5cN63P
wT6X7sfHQhi0aSwZC9Xk4ElfrVX7NgYvWT6LecLjYMs3uQf1PRjcWd9T7L6Q
b66JvBu8iUHntC+bLqtzYN7pqldmz6CplkBLX48DUYpx+PBKBm2jPS3FyzmY
tBq7tt6EwaoNa513CDgQUu3Tx/kL+6sFohhXDh7FFntTixhUZX7ROh/IgatR
knjJNI0zabXF7vEcXG3c/jJkjMa3ZuJTERc4eCfCbsPlfhorlw6fLG3i4IQm
L3PkKY0T2rSR9xAH8pruXzY8oLFFPTa80lQB4YF11qn3aIx3EJaYByiAUeXG
0Q00Zi0+2/XOeQU4lUb+bPA9jdmbuqT8pwoo89rMD7tML/DfMX3+vXHQHzP+
/Eo+jYEj8l2eR8fh2IWx6tFTNNboWBsOdI3DkAulcjpB40fxKcNbFngK+qPY
Jy2JxubQ15Jd0glo+SYpn4mlMSIrxzZk/STY2/v9uVRIo+XiAmlG8yR812nn
FB5MY32XS2l02BRoHeVllW+lsXGvaLJXQwkJ1j0dY4TG0rLrcbptSviDqlvh
7Ewj72261sn8afg6aMbTxZ7GKxn3TWu/UoFpP9nvuopGV/xd3TxqBurjRGfc
TGm0OynMij8yC/5zj+vcl9C42GbI3LbiDYzlmjwlGjTe7oneIp2ZA5FJxKzH
LIXPosiVkePzYFNZZeXFUSjxHF56610eaVkv9/AZorC6qO5a+rJFZGfLxi8/
fU6h3bvZqekuakTlm3pqayeFti8KpfzT6uTb3vZbviyF54bNJhgLTeK4n//E
r5lCcZo0Z+WcFnmgDFIF1C/0jXpb9XvokH3ZRRY7rlNY+zAwMWkZn2gYDZLg
Mgp9vepG7tYYkLLS1VGh+RQ6HBxRTjgYEbe1CbnhpylsqtY16oleRrp/bLqx
M5PC33xzckX6ZmSFY8HEsVTq/z//F3HGEK8=
          "]], LineBox[CompressedData["
1:eJw1VGlQU3ccDMoREW2iUdAGD4rKoRSFgkVskZQiSAYVVFRGkY5cTkELUokU
xQBCAaUBqUNVZCiCQD25pIV9vv8LFME71bQOSqFcEvXlEMHE2PRDP+zs7MzO
zv5+H3ZxdNLmvVM4HE6gCf9xkFW8um2FHLfqH0oUZ+2prY1rdUlOcmSInaOa
G+ZRGv9su28WyKEVyALuWc2hTtzr8U0RyPF4bGfG4dt8ymWXYE+qtRzh54Wb
OvtnUh1jO7MPceRoOKEeWRg8nYpOq7woGWdw1T8/bGUqlzJajt1OVzHQTB4O
6nazpMpKVmky+hk89u6bCAk1p7wcJHMzlQy8Yzg299unUA8u3/SR3mFgadHZ
pdhnRiWunbY7m2EQtf39i7ogDmXdvVF6vJUBkf74Uf9ZIy5EnK7Ou8Igedh5
eOaoAaKhZ935FxjY5tYMDsfr0Ze8jC08w2DIa3G60vYt0s2SBEUyBpMFARK+
agJ2J5tWy3IZhDeHNc7/+w0ahMbIkgwGHrGLUqSacWysDcgsTWGgDdz0YY1w
HCrvwqrTCQzu/lMsz4l8jVy5oqssikFTxUjWucs6OIYJX57ZyqDgt8KoR7N1
oPq+mlUeYspf4mORcFyLyMQ6rwp/BoWUpPEvrhYTes2OytUMZGmL9g+UalCS
53Okyo2B67c2+UnuGrjbHqusdjTd++q6R7FCjZ6fuzovzmfwsO2TfdnH1Ihb
xVfV8Ux6ndjtp0/VMKcieJcsTf8wUxSIJlmcF5/3vGIgGFiqOmZ+k4Xvk+GI
axqCqkL5/kNFLJRxH3/XMEIw1us5NySWRcp4akXTU4LPnNrf+Qaw4GW1y1sU
BDMcOgLtXFjU8y2ft94ioNqbb92Yw2J9uXhmG0VwxGb70elcFoPLT61CE0FW
l3SNhRkLl4yqlyN1BH55eqGOwyLxbmPtrAqCmpvOSUqT//qijhjfUoLwxF35
fXYsJg48cojJJ1gTcEm6caWpLxl6evIoge1QsCBrM4tMwZuyGwcJplpbi9Tp
LDr2Wm0bSCCw9+fdc73KwrrZdvaMKILMiMjq0VcsQrlOd722EPyZYCzm+qhR
sn11flQwgbOlvuBUkRrK2vWB339OcKPBMPuRTg17Q8TUBk8CUYvbhvA4DaLF
8eh1JpB9EFDzUqXBhXNph60WErjWX89VZWkx9irPe6WAYJ6LXeo8Dx3c15Vp
d0wj4Ll9+evoWx0OymovZxlplFZuW17f9xqtA637LmlpuLgLjXdGx2H07F6m
HKGxP3R5i5/9BEQ5TwbMntLovF/1g146idzHY+WuD2lwU7flPHDWo8fJsHPL
7zTKzXvDqxe8A19iY3ekjYYotrNLfOg9tnYLFTXXaBS8a0ntcTGjyoQrih5U
0xhsDttNqadQz75eG2I4Q8MzfXDcwcOCcoSYu1RGYwP/CyZyCZeK4+1iQo/T
6A/jN3U72lC/7Ek8mpZOoyk03u/5Cx6luZbhW3mAhkRpmFW1ZQ7lZX5yoieG
RrKoP6dXL6SS/4gtjjbp//flX1Vzfuk=
          "]], LineBox[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAAvbpu9oUrwr/1AXdStaAdQNLr8GDH
JcK/s5on1s4BGEAXPQEd8RrCvzZQZa//ZBJAXI4R2RoQwr+8FmHcXdsNQKDf
IZVEBcK/5GwGtHkpCUDlMDJRbvrBvyhD+ZXpxwVAKoJCDZjvwb87hGlsujwD
QG7TUsnB5MG/H5SOcqdCAUCzJGOF69nBv7zh7/TgXv8/+HVzQRXPwb9Srl/7
t8/8PzzHg/0+xMG/AQujhy6z+j+BGJS5aLnBv6LLYr637/g/xmmkdZKuwb89
uTfH/HL3Pwu7tDG8o8G/B6oEYYEv9j9QDMXt5ZjBvzdvdUknG/U/lF3VqQ+O
wb87mMsmNi70P9mu5WU5g8G/IJ7qNLVi8z8eAPYhY3jBv8xSHQz5s/I/YlEG
3oxtwb+Js9uQUx7yP6eiFpq2YsG/lJ1C39qe8T/s8yZW4FfBvxG1Ww1AM/E/
MEU3EgpNwb8yPoYZsdnwP3WWR84zQsG/OunM6sKQ8D+651eKXTfBvwqGvkxh
V/A//jhoRocswb/O4Ll9wyzwP0OKeAKxIcG/XOgqXmQQ8D+I24i+2hbBvwSd
SqX9AfA/zCyZegQMwb9mA8jBhQHwPxF+qTYuAcG/ta+QQzAP8D+GtijIEPfA
v8ApoJMXKfA/+u6nWfPswL+RIf5ASFDwP24nJ+vV4sC/mmXJwpKF8D/iX6Z8
uNjAv+vGwVUMyvA/VpglDpvOwL99xmqzGx/xP8rQpJ99xMC/uDtHZoqG8T8+
CSQxYLrAv7u7O1ucAvI/skGjwkKwwL+ClgUWMJbyPyZ6IlQlpsC/0NBrH+tE
8z+asqHlB5zAv3xgByV4E/Q/Dusgd+qRwL/gPONO3wf1P4IjoAjNh8C/AYna
ZQYq9j/2Wx+ar33Avzn/BitvhPc/apSeK5JzwL/abhLuWSX5P97MHb10acC/
udbapY8g+z9SBZ1OV1/Avyzs2udPkv0/xj0c4DlVwL8FOk+YKlIAQDp2m3Ec
S8C/GkzKkXNLAkCurhoD/0DAv72vZroy6QRAIueZlOE2wL86GCitHIYIQJYf
GSbELMC/5kE/a+7ODUAKWJi3piLAv/p4ktoTHRNAfpAXSYkYwL9Gx+k89dMa
QDByrGADF8C/9QF3UrWgHUApObJa
          "]], LineBox[CompressedData["
1:eJw9klkwlAEAx5cdV4xrnTtui4pxPSA1ShGjHGOsKZlhDLsh6TC5hzxIOijK
fQwapVXMGEez3/f/csQwq7GEDDM6aBC+3WXXER0vPfzm9/h7+VnHpYYnKDMY
DMe//PPQhO2nsY/AqGAya6rOnCrkOvj+HAM261f1dvZNqOsf7OI7e4AKtQDN
HhV9KtKTc+9OM8BXsHsDT2tRPi9t2k6WAPlsFZYgQI1yMLUWMbIBm+mU3RNz
TEq32JIe4gHsa8mtxleUqJ09c9aDcCAoJr2Yu3GIxWQzjzAfYCLmfa7Xr32M
zLMvGx4HOq1FRyabd9ERbJozZwhEFe6WbBMKVJLGDQ1KwLpowpzhKke+i1F/
/DqJ3qpsrv+PLVxtNFg69pmEvF3ZOWJahjA9lvrmIAmume96sEwKrwI9x64O
EsNny71nPKSwkumEZNaSyDCa7ePVSKARr33Tp4hEaJCN27iZBNIprXJmGonA
qYLalR4ac/6aPSMxf3u/Ozr4STT6uzXmHl0g8dZOotfiTqPNQf0g3JPEZlRq
6mMdGk8rVa1MbEmUGGWU1TBoZGmonFvQJkFOlA2QKjTispi8pj0CbrcNRpIs
aQStKd3nLxNoXckWV4fQcI9mCJzEBDRnOPzv5TTYosNxCUFARyR+Xr5FQ9nn
QNL9ikDCGCdj/oYEa2/2DXKeEXDIMY9kaUsxZbnn6XuXQNxoJcdULIWwdCdK
NYXAUV6JaHVQhhYlRe7YJQJDodtxhZItPLy13VjqR6Aoxz4tgi9H2jfZANeV
QFdiMDvz1A6iI6TLbDMC+n1VuqIne/AbojUW1QiMKjybtKsP4OSx6fRCJsT5
msQzy5MMiuecl9e3IMSSIDmWt8GkGux1xKJhIVjvWoF2dWrWooHztVMIk6wv
8uxYXUrf2CVdXiOEwju+rvm1CXWx3iK/t0L4/88/w2d8pg==
          "]], LineBox[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAt7abnTd6ub/KrNN61J0dwFz3/WXm
cLm/DrUh7ZCBFMCW7424+lq5vxA4C9vdzQrAz+cdCw9Fub8D/kFyPgsEwAjg
rV0jL7m/UFW6xJMiAMBC2D2wNxm5v2wL3ddAPvu/e9DNAkwDub/r5+RtzMv3
v7TIXVVg7bi/qUWwQ0RW9b/uwO2ndNe4vz4wkCpHi/O/J7l9+ojBuL9QWT77
sTryv2CxDU2dq7i/3TmaBhJH8b+aqZ2fsZW4v38uONkKnvC/06Et8sV/uL/t
LMhbZDTwvwyavUTaabi/GzJq9/UD8L9Gkk2X7lO4v/pSZwqjCvC/f4rd6QI+
uL895J+zEUrwv7iCbTwXKLi/7zf91AbI8L/yev2OKxK4v7fGnDyJj/G/K3ON
4T/8t7+2Tz5fObPyv2RrHTRU5re/XY0jPd1R9L+eY62GaNC3v1OEnAN1n/a/
11s92Xy6t79n80P5ufj5vxBUzSuRpLe/KIrn/9QR/79KTF1+pY63v8hp31PL
vAPAg0Tt0Ll4t79uG+RP7bcLwMJI7E80Y7e/x9wegEmyF8Aq33QJ6l23v8qs
03rUnR3Axpf1Cg==
          "]], 
         LineBox[{{-0.07110969387755102, -5.103243226248486}, \
{-0.07099718267210106, -3.786833385336398}, {-0.070668790647986, \
-2.1956783911109836`}, {-0.07036243252073396, -1.6176535172369544`}, \
{-0.07005607439348194, -1.3176369842365994`}, {-0.0697497162662299, \
-1.1471964554538556`}, {-0.06944335813897787, -1.051220772493595}, \
{-0.06913700001172583, -1.00641714175604}, {-0.0688306418844738, \
-1.0039971590545087`}, {-0.06852428375722176, -1.0446163975803915`}, \
{-0.06821792562996973, -1.139003076478017}, {-0.06791156750271769, \
-1.315199690090611}, {-0.06760520937546566, -1.6433044825371892`}, \
{-0.06729885124821362, -2.3345333289728236`}, {-0.06699249312096159, \
-4.401569390228817}, {-0.06698554421768707, -4.49536183783641}}], 
         LineBox[{{-0.05231270139634801, 
          2.80998988815163}, {-0.05198094488561192, 
          1.4715925690432712`}, {-0.05167458675835988, 
          1.11899210125038}, {-0.05136822863110785, 
          1.0053045850152162`}, {-0.051061870503855813`, 
          1.0359343384730653`}, {-0.05072971464081376, 
          1.2727811718130408`}, {-0.05039755877777171, 
          2.1026066946561244`}, {-0.0503188775510204, 2.5790756686866603`}}], 
         LineBox[{{-0.029984152752009892`, 
          1.1206258761034942`}, {-0.02980389526916451, 
          1.0138430233217743`}, {-0.02973064225690276, 1.0977254888459496`}}],
          LineBox[{{-0.009885204081632652, 
          2.060572751003258}, {-0.00976541824092948, -1.04916468013099}}], 
         LineBox[{{0.009582112547940518, 1.1033631247583113`}, {
          0.009582112547940518, 1.1033631247583113`}}], 
         LineBox[{{0.050318877551020394`, -2.5790756686866603`}, {
          0.050643578668224415`, -1.3960876796256034`}, {
          0.05097717218980839, -1.0710893996539441`}, {
          0.05131076571139237, -1.0005879428178173`}, {
          0.05164435923297635, -1.100037134002879}, {
          0.051977952754560325`, -1.46609463073246}, {
          0.052311546276144295`, -2.8002409360164315`}, {
          0.05231270139634801, -2.80998988815163}}], 
         LineBox[{{0.07174744897959183, -5.148419904713501}, {
          0.07198747403028682, -2.986180388805129}, {
          0.07231497753255878, -1.947883378332608}, {
          0.07264248103483073, -1.4912688635485754`}, {
          0.07296998453710268, -1.2483318064818185`}, {
          0.07329748803937464, -1.1102107077186005`}, {
          0.07362499154164659, -1.034420147461659}, {
          0.07395249504391854, -1.0024357323192412`}, {
          0.0742799985461905, -1.0069521300837392`}, {
          0.07460750204846245, -1.0478050755787844`}, {
          0.0749350055507344, -1.1317139277371286`}, {
          0.07526250905300635, -1.275497426283205}, {
          0.07559001255527831, -1.5161428884865624`}, {
          0.07591751605755026, -1.9419239549696603`}, {
          0.07624501955982221, -2.8147675388862563`}, {
          0.07657252306209417, -5.379702966358355}, {
          0.07660419937205651, -5.910570866517362}}], LineBox[CompressedData["

1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAZSTkF5Fdtz/1AXdStaAdQKbCvp8a
YLc/InpwDs1zGkBOpZM4kXW3P/T9ocZkfA1A9odo0QeLtz9a9Zefq7IEQJ5q
PWp+oLc/wrTSVbAnAEBFTRID9bW3P0H0m5862fo/jmEJ8fnJtz+n+bpaf3n3
P9h1AN/+3bc/i0sC8I8Z9T8hivfMA/K3P6ylUND/YvM/ap7uuggGuD8eBWsn
BiTyP7Oy5agNGrg/mvi3m1g+8T/8xtyWEi64PywugT3vnvA/RdvThBdCuD8d
LFeNwjnwP47vynIcVrg/OsSQUH0H8D/XA8JgIWq4P/4jqLA6BPA/IBi5TiZ+
uD+09gEl5C7wP2ossDwrkrg/tT0dvP2I8D+zQKcqMKa4P7fMIffQFvE//FSe
GDW6uD8YlA5IAODxP0ZplQY6zrg/ax+3R6vw8j+PfYz0PuK4P0nHVYh8W/Q/
2JGD4kP2uD/9oHIcWj32PyGmetBICrk/IhiD80bE+D9qunG+TR65P11NMcgM
Pfw/s85orFIyuT/9BpH+bZgAQPziX5pXRrk/kLgKWtxWBEBF91aIXFq5Pzig
jE5EjApAjgtOdmFuuT97TDe9vlETQMQ3KQbRerk/9QF3UrWgHUCeueB7
          "]], LineBox[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAAZ+IEaGavD/1AXdStaAdQEZL4JIr
o7w/vvGaNisgFUCPX9eAMLe8P0GMtNMTUw5Ahuw8P+bMvD+F5YCnw10HQH55
ov2b4rw/IBnGCo4hA0B2Bgi8Ufi8P97MwhlWTQBAbpNtegcOvT9tpDee4Jb8
P2Yg0zi9I70/2GZ2e52e+T9erTj3cjm9P75fKkyGW/c/VjqetShPvT9GOGSM
R5n1P07HA3TeZL0/qw49qmg29D9GVGkylHq9PwYQaKOWHPM/PuHO8EmQvT/Q
6PH/cDzyPzZuNK//pb0/Rqizeh6L8T8u+5lttbu9P7/sKMTXAPE/Joj/K2vR
vT+5cpVn/pfwPx4VZeog570/Ly4lRYdM8D8Wosqo1vy9P5tfpBiZG/A/Di8w
Z4wSvj/88qzdTAPwPwa8lSVCKL4/RUmQXYUC8D/+SPvj9z2+PxlY+Z7XGPA/
9tVgoq1Tvj8fHqO6gEbwP+5ixmBjab4/kVvAjGeM8D/m7ysfGX++P/zzfVIq
7PA/3nyR3c6Uvj91adDYOWjxP9YJ95uEqr4/u2QazgUE8j/OllxaOsC+P+H/
In9AxPI/xiPCGPDVvj+9cjWCRK/zP76wJ9el674/gM+r2q3N9D+2PY2VWwG/
P3hMO2hEK/Y/rsryUxEXvz/nBJbya9j3P6ZXWBLHLL8/FcMcWXns+T+e5L3Q
fEK/PyPjVySkifw/lnEjjzJYvz9F9xCCCeT/P47+iE3obb8/cjwNpngnAkCG
i+4LnoO/P3FQ0A39KwVAfhhUylOZvz+lFwr6X4IJQHaluYgJr78/VPA3Pu0c
EEBuMh9Hv8S/PzYjgGSl9xVAXkwxK93Rvz/1AXdStaAdQPBAOjs=
          "]], LineBox[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAANVJmyCAXwD/KrNN61J0dwKN5jf+l
GMA/OlmBDSC1GsAfQMDegCPAP119WdBeqhLAmwbzvVsuwD9GLJcmNtIMwBfN
JZ02OcA/219ihieTB8CTk1h8EUTAP2v50KgECATAD1qLW+xOwD+bR63UGn0B
wIsgvjrHWcA/rurqxFEr/78H5/AZomTAP8k6xMr2Ofy/g60j+XxvwD+/QnfR
2uX5v/9zVthXesA/uSPLy5QF+L97Oom3MoXAP6fuiDhLffa/9wC8lg2QwD8+
RR+BmTn1v3PH7nXomsA/qqR68pos9L/vjSFVw6XAP2REwmkfTPO/a1RUNJ6w
wD8RvlqriZDyv+cahxN5u8A/ea7ZqxL08b9j4bnyU8bAPxxjPyxLcvG/36fs
0S7RwD/bf1MWxQfxv1tuH7EJ3MA/XDih8tax8L/XNFKQ5ObAP4dxhPhwbvC/
U/uEb7/xwD/QI+tL/jvwv8/Bt06a/MA/IBnF4E4Z8L9LiOotdQfBPzNY5K6H
BfC/x04dDVASwT/2IT2pFwDwvxQu4RZyHME/S45sK68H8L9gDaUglCbBP+Kz
H0xyG/C/rexoKrYwwT8Xl1DEgDvwv/rLLDTYOsE/UDTvKClo8L9Gq/A9+kTB
P03BkTXrofC/k4q0RxxPwT/bmHvxe+nwv+BpeFE+WcE/Sicn9Ms/8b8sSTxb
YGPBP6JN1zcQpvG/eCgAZYJtwT81fMsezh3yv8UHxG6kd8E/QYDxmeuo8r8S
54d4xoHBP9X4hsnESfO/XsZLguiLwT+r8IcKSQP0v6qlD4wKlsE/1GEzSyLZ
9L/3hNOVLKDBP7ow8uPqz/W/RGSXn06qwT9eQbdfeO32v5BDW6lwtME/2tLv
IUU5+L/cIh+zkr7BP0PnC6oIvfm/KQLjvLTIwT9T4uonmIX7v3bhpsbW0sE/
CJXUsjqk/b/CwGrQ+NzBP4BTlHZeGADAD6Au2hrnwT9VCr9FZ6YBwFx/8uM8
8cE/txnA89mUA8CoXrbtXvvBP//2MZo1CQbA9T1694AFwj8eSaEyeD8JwEId
PgGjD8I/sn+Mu++dDcCO/AELxRnCP89YZR498RHA29vFFOcjwj+43+bl0swW
wEUVuNEDLMI/yqzTetSdHcBBKsGL
          "]], LineBox[CompressedData["
1:eJw9lGtUk3UAh9lwMBFvXLzkJddBnBc09ShO0t8bJMSAElBAp4KoSDiWwMAL
4pQjIYlMRcsyBGmI7YQOA0QM0Pf9zxQRjKuQCnJLub6DbRAXyb704TnPx+fb
Iwj+2mcf18TExP09/7mhXFVrvp+GgXPIJz9jHjVgXLCtNozG1ErVQT/lbIqq
awselNPoTXvmFlFqTSXn35DOVtAIe7mtJ0owjWq4KI1xSqLxdnTccG/rJMpe
/vGJnak0UnqWSyK15lSkrz5JkUbDTbPnUKANjypdVZh6LZtGlveTGnqYS1la
HUtjcmkE5GmL1Z4cKkCH7PZ7NAa3JGRt/2scWc9Mc80f0kg/clrieGkM/bf+
KFr8jEbZPOvUGb+OYKPyDPFopBHsmn82y3IYZ2RfVoS30fCIE7zMuDGE517W
z5W9NPzrPZrcogdh51D/OneIxqX7yRe3hRlx0PJKVzWXgVKRHxBy0oDirl0G
gyWDuq2475+vh8WTj8ZnzmSw70yTfg5XDz91B3+9gMG1xr1doXsHkJmkttqx
lEGxMOEfZUM/+kJlc4+vYbAwKLtlR2A/Pvl8lX0GGLS+cJk2NqDD6UXGFbQ7
A7taq/zuSzrUmBWJ2nwZNOSUuL9x0UHQEeditosBFfut2+tRFjLtp17CUAaJ
r+5uNZSyKFLx/MWRDKKt3Pz2J7MwP/U4SHqMwYHmgvYfdrPYsudsWMo3DKwH
O8YswCLD2VuuOcfgThTvxGY7Fj0C2+NVPzLIu1Vx2HY6i3Wx1yIeqBiMKJe0
OPNYxNc47NPcZBDlsC7T0YRFuUNRQHohA61ZZWUNh8WMRFfPFJrBwyNetyZa
sAhqrkJcOYPzd145Vs9ioRYFrpbWve/xwpuclrPQX+iylzQz0HjkqCViFhu7
D30g7mSw4MO1JwPCWZzeNGGKSM+AI7B+FPI9i6qr5zjCdwzuBbW6lT1iMXdo
rmEGn0DQHBNSz9EhxPuXNzwrgqNR60v1zjpo1Gte6OcQdKaULU5L1mHYlK5s
XUjAC+W5BDfp8NnOL5iqFQSzysWpfU79UBY0FjwQEUxu18qn/NyPxqn71RoX
gt3L/f5W2w7A7quBtHQvAkNv99mGiwOQ0YrzKf4EVxOC7ZoEehTOsUyI202w
xv1tnahED2705cPSAwS6aB9+zgEDPCvspJJoAueIEtfNy4z4blFuoFhBIAss
iM7kDqL5xAZfURLB6AbPK5m6QSxpfOwqTCWYz8nzZUeHIF/tt35mGsHTWPen
RuEwSpJbHMyyCVojlAr72BHwO2QCg4ag9op/vcvwKHwwYtNWRFAtyXGtufkO
P11O5FcTgvCViUtfeJtQHTrr0QcVBMZy8fipKA610iOjT/Oc4PZvptdva7nU
MdWy1vQWgsq7kX09WyZQD8cK61K6CVKOTneOX2VGTfPfVBZnJHDMk6tGYvjU
ds2fxVITLe4KQq7vdZ1EqSbuypVYaNHe2ZvYWj+F6g3uVIlttJBPcCoW0tOp
db/HXBbN1yJp8nClZ78NFW9rmiwUanGVe6HDJnk2pZDx1z5y0P7/n38BOlFN
OQ==
          "]], LineBox[CompressedData["
1:eJw9lGs8lAkYxce4RQxJRiQRsbFJGzWSp4ukmnaHimoql25SYqOyZlPUoiRR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          "]], LineBox[CompressedData["
1:eJw9lmk0lYsXxs+RWSGlotIsma6UjHle0kghJ4lKRKlEInQpmtwSpaiEVKRO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          "]], LineBox[CompressedData["
1:eJw9Vmk0lW0XPmRWJAcpUYrEG/pCUWxjSanOCRUS9VLGvEWiFJKhpFGdJqGE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          "]], LineBox[CompressedData["
1:eJw9WHk01tv3Ns9jmctNpiRCkUbPSSpdISGiiEjialCirtyQUqZUSErkqlSU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          "]], LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAbOdpCJlLvL/1AXdStaAdQPf3bsFH
RLy/Zc7dOaCeFkAw8P4TXC68vz7RBsvyoQ5AauiOZnAYvL8KCy1/CkEHQKPg
HrmEAry/7i9fHGfVAkDc2K4Lmey7v+Zx1s540/8/FtE+Xq3Wu7+KqZMQ1bf7
P0/JzrDBwLu/Pjeg6Ya0+D+IwV4D1qq7v6LdAN59bvY/wrnuVeqUu793N9bt
Ia/0P/yxfqj+fru/LtmAROxT8z81qg77Emm7vzyJ+KwqRvI/bqKeTSdTu7+G
jI3Zj3bxP6iaLqA7Pbu/FxDNea7a8D/hkr7yTye7v9D/5p99a/A/GotORWQR
u7+3EU08diTwP1SD3pd4+7q/VuuLlQ8D8D+Ne27qjOW6v1WaBK18BvA/xnP+
PKHPur8A5BS4nC/wPwBsjo+1ubq/PCJNIByB8D85ZB7iyaO6v2MT1AnO//A/
clyuNN6Nur/JWOUBVLPxP6xUPofyd7q/xOjE0T+n8j/lTM7ZBmK6v81ATJwF
7fM/HkVeLBtMur/rioa0a5/1P1g97n4vNrq/Qicy0uno9z+SNX7RQyC6v4QA
ojBMEPs/yy0OJFgKur8SVIh5HpT/PwQmnnZs9Lm/M9woN+o2A0A+Hi7JgN65
vzsD1yiX6ghAdxa+G5XIub/PfJJqqQkSQB0GWFcnuLm/9QF3UrWgHUDxLwus

          "]], LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAUCaudG9Atb/xeCuCELgbwBS30jWl
M7W/UMhlCnlAEcBTu9G0Hx61v/XlpsA5TQXAkr/QM5oItb9rHmf2+kP/v9DD
z7IU87S/ioOq1bkd+b8OyM4xj920v6gZ6y6NYvW/TMzNsAnItL9oC89HwP/y
v4rQzC+EsrS/1FOn87l28b/I1Muu/py0v1E77g+jh/C/BtnKLXmHtL8f63qo
MxLwv0XdyazzcbS/+H0XCDUJ8L+E4cgrbly0v/j7HaMxbvC/wuXHquhGtL+P
aohaV1LxvwDqxiljMbS/5bqPoEjd8r8+7sWo3Ru0v+qlmbtVX/W/fPLEJ1gG
tL/SNysIioH5v7r2w6bS8LO/TNM0dH9sAMD4+sIlTduzv0ZgLeL4HwjAGGpY
9CDGs78yNt0hVNYXwJTtsHU=
          "]], 
         LineBox[{{-0.062181122448979595`, -3.9226990817915124`}, \
{-0.06178440495767701, -1.8186868407229564`}, {-0.06147804683042497, \
-1.3482970630062292`}, {-0.06117168870317294, -1.1269961941016169`}, \
{-0.0608653305759209, -1.0248834920750012`}, {-0.06055897244866887, \
-1.0008128269664063`}, {-0.060252614321416834`, -1.048081598317164}, \
{-0.0599462561941648, -1.1882004547470295`}, {-0.059639898066912764`, \
-1.4977837348198095`}, {-0.05933353993966073, -2.2567585839576223`}, \
{-0.059142406962785124`, -3.5212326350258305`}}], 
         LineBox[{{-0.04134778911564626, -1.820634552138917}, \
{-0.041097194612594264`, -1.1563235208158575`}, {-0.040765038749552215`, \
-1.0047071071732772`}, {-0.04043288288651016, -1.341886857214552}, \
{-0.040318877551020406`, -1.7182688775410655`}}], 
         LineBox[{{0.020318877551020458`, -1.59739408997913}, {
          0.02038633469346006, -6.0944732325283235`}, {
          0.02038633469346006, -6.0944732325283235`}}], 
         LineBox[{{0.04031887755102041, 1.7182688775410313`}, {
          0.04076831578702775, 1.0041221369365703`}, {0.041076111572821705`, 
          1.1314271713206836`}, {0.04134778911564626, 1.820634552138917}}], 
         LineBox[{{0.05914240696278512, 3.5212326350258305`}, {
          0.05931701022940779, 2.326455596907483}, {0.05965060375099176, 
          1.482225045340118}, {0.05998419727257573, 1.1640817807037305`}, {
          0.060317790794159706`, 1.0314911358897496`}, {0.060651384315743684`,
           1.0007507212459354`}, {0.06098497783732766, 1.054206172723444}, {
          0.06131857135891164, 1.2135645941780049`}, {0.061652164880495616`, 
          1.568632317276797}, {0.061985758402079594`, 2.468969181426472}, {
          0.062181122448979595`, 3.9226990817915124`}}], 
         LineBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAGGpY9CDGsz8yNt0hVNYXQBiT0Yyl
2rM/Q0uh2xp9CEDAdaYlHPCzP2awRzV3lwBAaFh7vpIFtD8uFFfgArP5PxA7
UFcJG7Q/D6slA9t+9T+4HSXwfzC0PyGsWdod8vI/YAD6iPZFtD+LQ125yl/x
PwjjziFtW7Q/RMtP2s118D+wxaO643C0Pyt6XuKJC/A/WKh4U1qGtD+zoFyQ
Gg/wPwCLTezQm7Q/VbMOVT9+8D+obSKFR7G0P0xRXhU8ZfE/UFD3Hb7GtD+l
yyVdyuLyP/gyzLY03LQ/mfISeMoz9T+gFaFPq/G0P8nLpypc0Pg/R/h16CEH
tT/1B3yIhrr+P+7aSoGYHLU/PlL4IV7ABECWvR8aDzK1P5lCJDVffBBAUCau
dG9AtT/xeCuCELgbQNOdjzY=
          "]], LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAoG1CPoi9uT/KrNN61J0dwP1wIRx6
0rk/yJxqk7D1DcBGhRgKf+a5PzC+fCtpcwbAj5kP+IP6uT9y9YGTnhkCwNit
BuaIDro/ocoDRTST/r8hwv3TjSK6PzvY7A6Jrvq/atb0wZI2uj+jktF25dz3
v7Pq66+XSro/rF6J22DC9b/8/uKdnF66P5uXCDG0KPS/RRPai6Fyuj9Z+qQ7
6e3yv44n0Xmmhro/HQyjkdL78b/XO8hnq5q6P2MTgjODQ/G/IFC/VbCuuj+8
v3rrwLrwv2pktkO1wro/7agRiINa8L+zeK0xuta6Pw5WB5YLHvC//IykH7/q
uj8rtWKNUwLwv0ahmw3E/ro/+QOVjroF8L+PtZL7yBK7P6LMCeTWJ/C/2MmJ
6c0muz9sqmpQZ2nwvyHegNfSOrs/Ov0rH2DM8L9q8nfF1067P2DJ1uAVVPG/
swZvs9xiuz+Q6bctjQXyv/waZqHhdrs/LbFMYf7n8r9FL12P5oq7P6n4I6Go
BfS/jkNUfeueuz+ew4KxJW31v9hXS2vwsrs/OMf3s5oz978hbEJZ9ca7P2Vv
qRN5ePm/aoA5R/rauz8nUFnkQWz8v7SUMDX/7rs/6+K688EuAMD9qCcjBAO8
P1R7jUn66QLARr0eEQkXvD+BGITItecGwI/RFf8NK7w/anZjIu04DcDY5Qzt
Ej+8Px4TOUH7ThTAjQtHGTBNvD/KrNN61J0dwJFkKRw=
          "]], LineBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAASIP2Hlktt7/1AXdStaAdQHxV6cyj
Ire/jIhK5wSgE0C6WehLHg23v+Qep3q/ighA+V3nypj3tr8BDzfkfgcCQDhi
5kkT4ra/UbdLHNLT/D92ZuXIjcy2vwxSENAfUvg/tGrkRwi3tr8ecoOxAFP1
P/Ju48aCoba/Q+FPlr9D8z8wc+JF/Yu2v05ZCmsj1/E/b3fhxHd2tr+Zva+4
3OHwP6574EPyYLa/q6CuHD1L8D/sf9/CbEu2vwFpBAMjBvA/KoTeQec1tr/H
vfr2wA3wP2iI3cBhILa/CYZI0pxk8D+mjNw/3Aq2v+uYVLxVFfE/5JDbvlb1
tb8uujiRmTXyPyKV2j3R37W/HDBWQ+js8z9hmdm8S8q1vxVd1GiOg/Y/oJ3Y
O8a0tb/8sYVad4b6P96h17pAn7W/ELKhQgeVAEAcptY5u4m1v8jqOHai0AZA
WqrVuDV0tb/z7vul7AMTQFqE/DU7arW/K3VtFzPuG0DBE8av
          "]], 
         LineBox[{{-0.06634778911564626, 
          4.453286353322944}, {-0.06576706061195345, 
          1.6642464539448878`}, {-0.06546070248470141, 
          1.3103844097896689`}, {-0.06515434435744938, 
          1.1256408822793968`}, {-0.06484798623019734, 
          1.0318728036819933`}, {-0.06454162810294531, 
          1.0001850840514062`}, {-0.06423526997569327, 
          1.0231015136405852`}, {-0.06392891184844124, 
          1.1091081832110583`}, {-0.0636225537211892, 
          1.290146899030078}, {-0.06331619559393717, 
          1.6568294177647533`}, {-0.06300983746668513, 
          2.52782460448276}, {-0.0628188775510204, 3.962041497624635}}], 
         LineBox[{{-0.02470912145345943, -1.0041979309371902`}, \
{-0.02470912145345943, -1.0041979309371902`}}], 
         LineBox[{{0.05587443310657596, -3.153057602532256}, {
          0.05598107501356803, -2.3996943898357483`}, {
          0.056314668535152004`, -1.4480936768896737`}, {
          0.05664826205673598, -1.1274085856181644`}, {
          0.05698185557831995, -1.0121876626118123`}, {
          0.05731544909990392, -1.0138621410622044`}, {
          0.0576490426214879, -1.1290117999199374`}, {
          0.05798263614307188, -1.4298283642113063`}, {
          0.058316229664655855`, -2.231842650953323}, {
          0.05850465186074431, -3.484323152696618}}], 
         LineBox[{{-0.07660419937205651, 
          5.910570866517362}, {-0.0765798470820574, 
          5.493690869319044}, {-0.07625145505794231, 
          2.8407775309602266`}, {-0.07592306303382723, 
          1.9517557570426225`}, {-0.07559467100971215, 
          1.520585997906497}, {-0.07526627898559707, 
          1.2776151731026664`}, {-0.07493788696148199, 
          1.1326829135873064`}, {-0.07460949493736692, 
          1.0481746067835538`}, {-0.07428110291325185, 
          1.0070271257377232`}, {-0.07395271088913677, 
          1.0024270597747211`}, {-0.07362431886502169, 
          1.0345269540265065`}, {-0.0732959268409066, 
          1.1107001725818595`}, {-0.07296753481679152, 
          1.2496828157138655`}, {-0.07263914279267646, 
          1.4945579756015472`}, {-0.07231075076856139, 
          1.9561933666537874`}, {-0.0719823587444463, 
          3.0124823218839296`}, {-0.07174744897959183, 5.148419904713501}}], 
         LineBox[{{-0.058504651860744314`, 
          3.484323152696701}, {-0.0581081074306526, 
          1.636194686796276}, {-0.05780174930340057, 
          1.2346198141331177`}, {-0.05749539117614853, 
          1.059637977730024}, {-0.0571890330488965, 
          1.0009860703688125`}, {-0.05688267492164446, 
          1.0324735805760235`}, {-0.05657631679439243, 
          1.1733710687193575`}, {-0.05626995866714039, 
          1.5201362725296252`}, {-0.05596360053988836, 
          2.495460760793538}, {-0.05587443310657596, 3.153057602532256}}], 
         LineBox[{{-0.0353954081632653, -1.4043123629610637`}, \
{-0.035118389077837334`, -1.0030649215144687`}, {-0.03480163617171006, \
-1.349256379613811}}], 
         LineBox[{{-0.015065737833594946`, -1.0813071969165946`}, \
{-0.014803845779489892`, 1.0124725317966445`}}], 
         LineBox[{{0.0628188775510204, -3.962041497624635}, {
          0.06298653896683151, -2.6413614444743394`}, {
          0.06332013248841549, -1.650112644922948}, {
          0.06365372600999947, -1.2655727304192381`}, {
          0.06398731953158344, -1.0868227483801702`}, {
          0.06432091305316742, -1.0110212057231331`}, {
          0.0646545065747514, -1.0054555243907872`}, {
          0.06498810009633538, -1.0659641435166387`}, {
          0.06532169361791935, -1.2120562540177149`}, {
          0.06565528713950333, -1.506432898180336}, {
          0.0659888806610873, -2.1489625640917627`}, {
          0.06632247418267127, -4.130056176116478}, {
          0.06634778911564625, -4.453286353322806}}], LineBox[CompressedData["

1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAWoT8NTtqtT8rdW0XM+4bwI5lnuRy
crU/BZY3oW8kFMA2SHN96Ye1P4Fsz7rnlwfA3ipIFmCdtT8LhLaO7vgAwIYN
Ha/WsrU/jsavgv78+r8u8PFHTci1P2583f9d0Pa/1tLG4MPdtT8fSwbQ7CD0
v361m3k687U/ZwEetCZZ8r8mmHASsQi2PxVa60DYLPG/znpFqycetj8vvyQG
d3Lwv3ZdGkSeM7Y/wNwUdRoT8L8eQO/cFEm2P2CSdMBCA/C/xiLEdYtetj/9
E1Lmoz/wv24FmQ4CdLY/zv5WFDDM8L8W6G2neIm2P/SN+PvhtPG/vspCQO+e
tj98xP9qnRDzv2atF9lltLY/zd4eZpQH9b8OkOxx3Mm2PxbIUtr+4Pe/tnLB
ClPftj9NCNHNkCL8v15VlqPJ9LY/hJRoJi1xAcAGOGs8QAq3P67qsNcDZQfA
rhpA1bYftz9rtaiprSESwKu9EWAJLbc/yqzTetSdHcCdD8B9
          "]], 
         LineBox[{{-0.04968112244897959, -2.548145835186544}, \
{-0.04940109118864555, -1.4489012768411613`}, {-0.049068935325603504`, \
-1.0762080170388715`}, {-0.048736779462561455`, -1.0016703079663114`}, \
{-0.0484046235995194, -1.1395497343432657`}, {-0.048072467736477345`, \
-1.7156338214813787`}, {-0.04793792517006802, -2.3535132944912696`}}], 
         LineBox[{{0.011813130424583485`, 1.1251618892011548`}, {
          0.012140592627035013`, 1.092152524706618}, {0.012470422309692015`, 
          1.7811858320170577`}, {0.012800251992349018`, 
          2.6439988979089017`}, {0.013130081675006018`, 2.064099366870183}, {
          0.01345991135766302, 1.2513957626759704`}, {0.013789741040320023`, 
          1.00154416187368}, {0.013966836734693625`, -1.0495227705370078`}}], 
         LineBox[{{0.05295045649838882, 2.8427315848374635`}, {
          0.05297873331931224, 2.6230460262968665`}, {0.05331232684089622, 
          1.4482137997738325`}, {0.0536459203624802, 1.1064075463962042`}, {
          0.053979513884064176`, 1.0032292605672881`}, {0.054313107405648146`,
           1.0396921121561147`}, {0.05464670092723212, 1.2378607595912448`}, {
          0.054980294448816094`, 1.7929218352874938`}, {0.05523667800453515, 
          3.11833419248745}}], 
         LineBox[{{-0.03814266091051805, -1.584736317978237}, \
{-0.0381077918452158, -1.4542527440948227`}, {-0.03777563598217375, \
-1.0038566668081095`}, {-0.03744348011913169, -1.2562026442509924`}, \
{-0.03735591458805744, -1.5095795132866188`}}], 
         LineBox[{{-0.01739386396486446, 
          1.0003534200409254`}, {-0.01739386396486446, 1.0003534200409254`}}],
          LineBox[{{0.04198554421768707, -1.8455061629354201`}, {
          0.042307294715997534`, -1.0996964055424494`}, {
          0.04261509050179149, -1.0057773906610754`}, {
          0.04292288628758545, -1.2429277340289417`}, {
          0.04315938331854481, -1.9651809696942875`}}], 
         LineBox[{{-0.043159383318544804`, 
          1.96518096969424}, {-0.043090129790846574`, 
          1.6505469352461268`}, {-0.04275797392780452, 
          1.0659417887706217`}, {-0.04242581806476247, 
          1.0250772864417346`}, {-0.04209366220172042, 
          1.4442144594325923`}, {-0.04198554421768707, 1.8455061629354201`}}],
          LineBox[{{-0.0025660685603606263`, 
          1.2394747418860614`}, {-0.0025660685603606263`, 
          1.2394747418860614`}}], 
         LineBox[{{0.03735591458805744, 1.5095795132866188`}, {
          0.03769035792908816, 1.0050697334310699`}, {0.03799815371488212, 
          1.1913884361132403`}, {0.03814266091051805, 1.584736317978237}}], 
         LineBox[{{-0.05523667800453515, -3.11833419248745}, \
{-0.05473816803088022, -1.3376349787415371`}, {-0.054431809903628184`, \
-1.0872495835474913`}, {-0.05412545177637615, -1.002946074352981}, \
{-0.053819093649124114`, -1.0330774014313413`}, {-0.053512735521872086`, \
-1.2017832830206756`}, {-0.05320637739462006, -1.663686976996888}, \
{-0.05295045649838882, -2.8427315848374635`}}], 
         LineBox[{{-0.013194635962493774`, 
          1.620912909258744}, {-0.01274718712931908, -1.0131394327463483`}, \
{-0.012437065163140072`, -1.0464326825569041`}, {-0.012126943196961063`, \
-1.007548666638213}, {-0.011816821230782057`, -1.0825715077099811`}, \
{-0.011813130424583535`, -1.1251618892004618`}}], 
         LineBox[{{0.006985544217678628, -2.165791057867302}, {
          0.007373731537710104, -1.0709888250222455`}, {
          0.007373731537710104, -1.0709888250222455`}}], 
         LineBox[{{0.028096655328798185`, -1.0427146859543108`}, {
          0.02825255102040816, -1.0569485908775333`}}], 
         LineBox[{{0.06698554421768706, 4.495361837836691}, {
          0.06732325474742319, 2.2543887426831097`}, {0.06765684826900717, 
          1.571619881625478}, {0.06799044179059115, 1.259308815139728}, {
          0.06832403531217512, 1.0989899614020813`}, {0.0686576288337591, 
          1.0212338755850783`}, {0.06899122235534308, 1.0001440486763298`}, {
          0.06932481587692706, 1.028532458552865}, {0.06965840939851103, 
          1.112239267106741}, {0.06999200292009501, 1.2738555758833134`}, {
          0.07032559644167899, 1.5713599040818447`}, {0.07065918996326297, 
          2.1700955259401433`}, {0.07099278348484694, 3.7492986720965487`}, {
          0.07110969387755102, 5.103243226248486}}], 
         LineBox[{{-0.009115084713028219, 
          1.2602218060448998`}, {-0.008739961646240073, \
-1.0350053652965383`}, {-0.008435929699373089, -1.0081817441557013`}, \
{-0.008432296795986952, -1.0429338518665856`}}], 
         LineBox[{{0.031568877551020405`, -1.1768507387844258`}, {
          0.03193918696510862, -1.2103635283472904`}}], 
         LineBox[{{-0.039681122448979596`, 
          1.6947129717237766`}, {-0.03943641529738401, 
          1.1096956876196176`}, {-0.039104259434341954`, 
          1.0266323728362046`}, {-0.03878041601255886, 1.6070236463190173`}}],
          LineBox[{{0.021595473295701263`, 1.2195817420762023`}, {
          0.02170565342408807, 4.523975733796885}, {0.02170565342408807, 
          4.523975733796885}}], 
         LineBox[{{-0.045135667903525, -2.131672488431482}, \
{-0.045083064969098884`, -1.8545561652817502`}, {-0.044750909106056835`, \
-1.129807279029969}, {-0.04441875324301478, -1.0008363218623266`}, \
{-0.044086597379972725`, -1.1906589972690156`}, {-0.043797138420585614`, \
-1.9914305334674012`}}], 
         LineBox[{{-0.02357469150450877, -1.0338081943051065`}, \
{-0.02357469150450877, -1.0338081943051065`}}], 
         LineBox[{{0.016191893424037703`, -1.457409321730208}, {
          0.016428378501576038`, 2.523084192198296}, {0.016523066115477707`, 
          1.0022758509785354`}}], 
         LineBox[{{-0.03416388106966925, 
          1.3306361070775972`}, {-0.03412192148871118, 
          1.2177882577402037`}, {-0.03378976562566913, 
          1.0460091765965067`}, {-0.03365221088435373, 1.2837049865296026`}}],
          LineBox[{{0.005103566546299602, -5.463182181536369}, {
          0.005549539856508198, 1.7381828483280386`}, {0.0058535718033751825`,
           2.027996650210815}, {0.006157603750242166, 1.050568781933258}, {
          0.006347789115637811, -1.0061331343595816`}}], 
         LineBox[{{0.026634667024704618`, -1.010101076359158}, {
          0.026653098663943095`, -1.001801026141157}, {
          0.026708149476006613`, -1.016977759366425}}], 
         LineBox[{{0.045773423005565854`, -2.1593785753415373`}, {
          0.04630863993131899, -1.0454891684972136`}, {
          0.04661643571711295, -1.011642550807847}, {
          0.04692423150290691, -1.2066273918898018`}, {
          0.047232027288700865`, -1.9431051365577416`}, {
          0.04730017006802721, -2.3242539936017734`}}], 
         LineBox[{{-0.04730017006802721, 
          2.3242539936017734`}, {-0.047076000147351194`, 
          1.449958722208891}, {-0.04674384428430914, 
          1.0590645950396849`}, {-0.04641168842126709, 
          1.0106711268526134`}, {-0.04607953255822504, 
          1.2406402072016482`}, {-0.04577342300556581, 2.159378575341772}}], 
         LineBox[{{-0.02599691192266379, -1.005695629475926}, \
{-0.025959903192046045`, -1.0021687512176434`}}], 
         LineBox[{{-0.006260069817238766, 
          1.3825644928533676`}, {-0.006099224371767264, 7.140279911760392}}], 
         LineBox[{{-0.03671815948601663, 
          1.488528082413267}, {-0.03644701253000554, 
          1.0198526493910782`}, {-0.036114856666963485`, 
          1.2076189032386815`}, {-0.03603316326530611, 1.4241463055005497`}}],
          LineBox[{{0.0033583912284399576`, -1.4687803173058853`}, {
          0.003725348175306291, 1.023761669300975}, {0.004029380122173276, 
          1.893236415472078}, {0.00433341206904026, 1.4860505245933209`}, {
          0.004333412084407722, -7.404130858583082}}], 
         LineBox[{{0.024099365355898458`, -1.0001299511100101`}, {
          0.024099365355898458`, -1.0001299511100101`}}], 
         LineBox[{{0.04379713842058562, 1.9914305334674012`}, {
          0.04415406943076128, 1.118712200845175}, {0.044461865216555235`, 
          1.0003836481012476`}, {0.04476966100234919, 1.1480506555243937`}, {
          0.04507745678814315, 1.8298479609321252`}, {0.045135667903525044`, 
          2.131672488431767}}], 
         LineBox[{{0.03878041601255886, -1.6070236463190173`}, {
          0.03922933685805795, -1.0003886612554482`}, {
          0.039537132643851905`, -1.2574105905712112`}, {
          0.0396811224489796, -1.6947129717238096`}}], 
         LineBox[{{-0.030931122448979588`, -1.1620109129509257`}, \
{-0.030800362858290662`, -1.0053490011969914`}, {-0.03062190785405071, \
-1.1340947098425598`}}], 
         LineBox[{{0.04793792517006802, 2.3535132944912696`}, {
          0.048463210431876694`, 1.0959823943937208`}, {0.04877100621767065, 
          1.0000783870816834`}, {0.04907880200346461, 1.0818362998245963`}, {
          0.049386597789258566`, 1.4213383565965152`}, {0.049681122448979584`,
           2.548145835186459}}], 
         LineBox[{{0.010219867649981335`, -2.1841960118039916`}, {
          0.01034188911955486, 1.219938868816132}}], 
         LineBox[{{-0.019288965586234462`, 
          2.113432478055047}, {-0.019288965586234462`, 2.113432478055047}}], 
         LineBox[{{0.015244250685348668`, -1.0498678678675883`}, {
          0.015438889453605031`, 1.520278887222892}, {0.015481280863737346`, 
          1.0453850314965596`}}], 
         LineBox[{{0.03603316326530612, -1.4241463055005292`}, {
          0.03645917478591233, -1.026184692580808}, {
          0.03671815948601663, -1.488528082413267}}], 
         LineBox[{{0.02595990319204604, 1.0021687512176443`}, {
          0.025993439298629094`, 1.0040939502040134`}, {0.0259969119226638, 
          1.0056956294759338`}}], 
         LineBox[{{-0.0267081494760066, 
          1.016977759366417}, {-0.026634667024704607`, 1.010101076359164}}], 
         LineBox[{{-0.007256880024737146, 
          1.7032635881263842`}, {-0.006915769965038165, \
-1.0483601160380658`}, {-0.006811080772873762, -1.8623792611494543`}}], 
         LineBox[{{0.03365221088435374, -1.283704986529588}, {
          0.03399680849956066, -1.0371687818600395`}, {
          0.03416388106966925, -1.3306361070775972`}}], 
         LineBox[{{0.02357469150450878, 1.0338081943051296`}, {
          0.02357469150450878, 1.0338081943051296`}}], 
         LineBox[{{-0.021903344671201808`, 
          1.1317623775645265`}, {-0.021903344671201808`, 
          1.1317623775645265`}}], 
         LineBox[{{-0.0019283134583198101`, -1.0393656422767104`}, \
{-0.0018219354660969085`, -2.4619676375386685`}}], 
         LineBox[{{-0.031939186965108626`, 
          1.210363528347314}, {-0.03179683044741682, 
          1.0126291476529976`}, {-0.031568877551020405`, 
          1.1768507387844258`}}], 
         LineBox[{{0.028890306122448976`, 1.0673558855365262`}, {
          0.02896190644254211, 1.0039131006778383`}, {0.029092887154861944`, 
          1.0857235333780613`}}], 
         LineBox[{{-0.018005147126102426`, 
          1.0078180688890674`}, {-0.018005147126102426`, 
          1.0078180688890674`}}], 
         LineBox[{{0.0017494927155411524`, -1.0455100857409163`}, {
          0.0017968196000098936`, 1.0075133463862977`}}], 
         LineBox[{{-0.022936936402467953`, 
          1.049132839100129}, {-0.022913445681302824`, 1.1093136885266521`}}],
          LineBox[{{-0.0035570914412276443`, 
          2.5445528752739}, {-0.003267386602634352, -5.816564744782249}, \
{-0.0031528532952564796`, 1.9335490198289587`}}], 
         LineBox[{{0.016810267217854613`, -1.000777235549339}, {
          0.016810267217854613`, -1.000777235549339}}], 
         LineBox[{{-0.03301445578231292, -1.2663100056342425`}, \
{-0.032793298036542975`, -1.0001755726631563`}, {-0.032576942067149436`, \
-1.2265047087480854`}}], 
         LineBox[{{0.02734590457804743, 1.0236438399864674`}, {
          0.027458900226757368`, 1.0340693743810025`}}], 
         LineBox[{{0.03480163617171006, 1.349256379613811}, {
          0.03522799164273649, 1.0671009063590255`}, {0.03539540816326531, 
          1.4043123629610834`}}], 
         LineBox[{{0.024681122448979593`, 1.0013937299538536`}, {
          0.024681122448979593`, 1.0013937299538536`}}], 
         LineBox[{{-0.020514455782312906`, -1.3972599942308326`}, \
{-0.020514455782312906`, -1.3972599942308326`}}], 
         LineBox[{{-0.0011117380032909486`, 
          1.0002773754786995`}, {-0.0011068525656225034`, 
          7.406941689027453}}], 
         LineBox[{{0.019489010946363607`, -1.2065862104507181`}, {
          0.019489010946363607`, -1.2065862104507181`}}], 
         LineBox[{{0.008448958851833418, 1.1088521919206988`}, {
          0.008893891272045026, 1.0200887265750527`}, {0.00919792321891201, 
          1.2984923543726297`}, {0.009285811980342768, -1.212120245936567}}], 
         LineBox[{{0.02973064225690276, -1.0977254888459496`}, {
          0.029951395490513115`, -1.0659721343258761`}, {
          0.029984152752009892`, -1.1206258761034942`}}], 
         LineBox[{{-0.009652057486841024, 
          1.0568204377558328`}, {-0.009652057486841024, 
          1.0568204377558328`}}], 
         LineBox[{{0.03062190785405071, 1.1340947098425598`}, {
          0.03093112244897959, 1.1620109129509355`}}], 
         LineBox[{{-0.014607918926393126`, -1.0096213154345381`}, \
{-0.014607918926393126`, -1.0096213154345381`}}], 
         LineBox[{{-0.017088894655825193`, -1.0015193453301199`}, \
{-0.017033622474879606`, -1.2577034010764587`}}], 
         LineBox[{{0.002509220387838353, 1.0045053596227405`}, {
          0.002509220387838353, 1.0045053596227405`}}], 
         LineBox[{{0.023024972154716078`, -1.0238887103237235`}, {
          0.023024972154716078`, -1.0238887103237235`}}], 
         LineBox[{{0.017747697232204047`, 1.1308864611979526`}, {
          0.017758005948167357`, 1.2023643896650553`}}], 
         LineBox[{{-0.02825255102040815, 
          1.056948590877528}, {-0.02809665532879818, 1.0427146859543195`}}], 
         LineBox[{{0.011429988662113713`, -1.000581148836737}, {
          0.011429988662113713`, -1.000581148836737}}], 
         LineBox[{{-0.01832938252054122, -1.016372723107755}, \
{-0.01832938252054122, -1.016372723107755}}], 
         LineBox[{{-0.016074565071930762`, -1.6310317481967116`}, \
{-0.01607456507190054, -7.404130858583082}}], 
         LineBox[{{0.019067015962832053`, 1.0142433213480548`}, {
          0.019067015962832053`, 1.0142433213480548`}}], 
         LineBox[{{-0.011175375322542718`, 
          1.001521292322918}, {-0.010886455332245033`, 2.3065858560735584`}}],
          LineBox[{{-0.029092887154861944`, -1.0857235333780613`}, \
{-0.02889030612244897, -1.0673558855365317`}}], 
         LineBox[{{0.010491444213750001`, -1.1945728439834646`}, {
          0.010713142784026651`, -1.1347646678367425`}}], 
         LineBox[{{-0.018949626452899236`, -1.5202276053974382`}, \
{-0.018949626452899236`, -1.5202276053974382`}}], 
         LineBox[{{0.021045994058774064`, -1.001108487425831}, {
          0.021045994058774064`, -1.001108487425831}}], 
         LineBox[{{-0.024071366351418613`, 
          1.0092522212922825`}, {-0.024044356114538847`, 
          1.0411597447217182`}}], 
         LineBox[{{-0.004465811444178235, 
          4.199686260704038}, {-0.004194846543268461, -1.065580770881473}}], 
         LineBox[{{0.015768719136262033`, -1.0352543662097455`}, {
          0.015768719136262033`, -1.0352543662097455`}}], 
         LineBox[{{-0.01417387607215579, -1.0136681475028817`}, \
{-0.01383239106453459, -1.2532147548204278`}}], 
         LineBox[{{-0.0066117380181711805`, 
          1.4315779455896498`}, {-0.0066117380181711805`, 
          1.4315779455896498`}}], 
         LineBox[{{-0.016468650723467176`, -1.302686222830171}, \
{-0.016468650723467176`, -1.302686222830171}}], 
         LineBox[{{-0.021430602182331303`, -1.1456225498210395`}, \
{-0.021400980605007978`, -1.3216010493066699`}}], 
         LineBox[{{0.01840735659751805, 1.1703435191277534`}, {
          0.01840735659751805, 1.1703435191277534`}}], 
         LineBox[{{0.007981795431444075, -1.281037541368668}, {
          0.007981795431444075, -1.281037541368668}}], 
         LineBox[{{-0.027458900226757364`, -1.0340693743809948`}, \
{-0.027345904578047416`, -1.023643839986477}}], 
         LineBox[{{-0.007827865805639118, 
          1.4086522211937202`}, {-0.007827865805639118, 
          1.4086522211937202`}}], 
         LineBox[{{0.03257694206714943, 1.2265047087480976`}, {
          0.03301445578231293, 1.2663100056342567`}}], 
         LineBox[{{-0.017709138588183203`, -1.0050680924167688`}, \
{-0.01769385533338117, -1.0013936364943439`}}], 
         LineBox[{{0.002005461768811399, 1.1023909951802264`}, {
          0.002005461768811399, 1.1023909951802264`}}], 
         LineBox[{{0.02242957329982937, 1.0358560042887974`}, {
          0.02242957329982937, 1.0358560042887974`}}], 
         LineBox[{{-0.022541099773242625`, -1.099706684199619}, \
{-0.022541099773242625`, -1.099706684199619}}], 
         LineBox[{{-0.002963354655767367, 
          1.0099016909607257`}, {-0.0027530803758095924`, 
          1.5148632136614069`}}], 
         LineBox[{{0.01708803786689004, 1.002071267198551}, {
          0.01714273655464829, 1.153842726394912}}], 
         LineBox[{{-0.025322148090005228`, 
          1.0003892185815886`}, {-0.02529087854654056, 1.0079268260799803`}}],
          LineBox[{{-0.005461469269726447, 
          3.207818262116256}, {-0.005461469269726447, 3.207818262116256}}], 
         LineBox[{{0.014604591836734442`, 1.0039890241501674`}, {
          0.01460649558330785, 1.0069084350839799`}}], 
         LineBox[{{0.02531887755102041, -1.0000704525555677`}, {
          0.025322148090005225`, -1.0003892185815877`}}], 
         LineBox[{{-0.02019011431761527, 
          1.0042193947526803`}, {-0.020073279311724736`, 
          1.8432521075662236`}}], 
         LineBox[{{-0.0004599200030015673, -1.2619944049847962`}, \
{-0.00045992000300091516`, -7.404130858583082}}], 
         LineBox[{{0.019726675328146058`, 1.2163360691647904`}, {
          0.019726675328146058`, 1.2163360691647904`}}], 
         LineBox[{{-0.010266211399887017`, 
          1.0443358626439423`}, {-0.010266211399887017`, 
          1.0443358626439423`}}], 
         LineBox[{{0.0008455995498670019, 7.406941689027453}, {
          0.0011117376135003363`, -1.0002545229179203`}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ], {}}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
      Slot["HighlightElements"], 
      Slot["LayoutOptions"], 
      Slot["Meta"], 
      Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]], 
            Line[CompressedData["
1:eJw9WGk4ltvffQwRIvMUJ6SUNIkGqSSkHClKUdHAKWWKDIdkaFJRoiiVBtKA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             "]], 
            Line[CompressedData["
1:eJw9lnk01d/Xx28h85i4MoQQZUpz4RwhkVCRopIhRKlvlKFJAyolmVJJSYpU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             "]], 
            Line[CompressedData["
1:eJw9Vmk0lY0WPjjGhE83ZMoQqbgfKWRIg0KRTGlAg1JJMmRKIpUGJYpTdESl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             "]], 
            Line[CompressedData["
1:eJw9lGlUlHUYxUc2WQYRSCFWNRhK8YCKSEg8f4mljiKbsaXiYJCCIqEsaiwC
4XBc0QYMhkVZFEkFBwnKeBB4l/G4BJmAGAkYxuL0DsswIFL0pQ/33HM/3fvh
d+7KyEOBUWo8Hm/3gv7zq21LBvhCGU4tSg68U2ZJVtFFb15/LsNkeXTHxCsz
cnrIzUkjQIbEf2CZ8tlyotTqO2DmLcOrr/UHvfuMyR679ErHzTJsfBy64/hF
Q3LfZ0Wft6MM9bbLy8Q5BsRp373lu2xlmBc/Y7Unn09KRJF+h81k+OHBCEve
B7pEp1pdlGsgQ6FPQ32itTY5IqtoKdWQ4Vvd4udP92qRvmGvmTszLN6Uatza
OKRBPtF9te6BnMW4A31TDYXq5PZqUczAIIsxouUmYSlqxLpjT9OaHhZtmxO0
z329iJxO/lA78RGLgefT3TMlPKKyNAppbmOxgFoSYHHtH4hqH6lc3MSi8806
w9swD50xbZP+N1mM1Ewo3Do7B+6Gko8Ly1l8HnFDvvfXN1Dzw5ELg5dYPIx+
Vi7MLJju9u23P8ui+PXhI2WdM5CtIXBMymKxqra1dHxcBYrr82mYwmL6RpOM
EVsV7A7oeqgdx6K2oPDvgv3TcH/6lkXgXhYPPRQE+d9VwqYSUWxRKIuEZ7a0
3EIJFZ7CH1/6sjgs1yX+uVOQmmcUmuzCok+0zfyJrEkY2TRa1bKWRT2x0bSb
wSQE97VN6bzHYm/7iqk75RPQli3xDDJl8ZqiwdyHTIDjmsSLEn0Wj9X2Dux6
OQ6SDt+BP9VYrJbyqlLOjYNOimCdg4pBN/53Ypst4zDQ3vXo3gCDCRWrfq5o
UIBfbK2lXjeDrZJzgsdHFXDXMPfAjocMynfm/eLkoYD3G4U/FbcyWPTiBBYY
KEC821X31Q8MhtxnSu71c6CmaRzmeIPBxpTz5lmNHMTVjF49eoXBvs2PwqQX
OegNaFe2FjBo/GJbhsNhDj5RSbz4Zxi0OLMt7FkwB3dKEr/9LJNB2alLmhJ3
DlZ5bR8sSWYw71Bmi3A1B2dHBev/OsCg/fRZqaUZB2/y/slYF8lgec5cN63P
wT6X7sfHQhi0aSwZC9Xk4ElfrVX7NgYvWT6LecLjYMs3uQf1PRjcWd9T7L6Q
b66JvBu8iUHntC+bLqtzYN7pqldmz6CplkBLX48DUYpx+PBKBm2jPS3FyzmY
tBq7tt6EwaoNa513CDgQUu3Tx/kL+6sFohhXDh7FFntTixhUZX7ROh/IgatR
knjJNI0zabXF7vEcXG3c/jJkjMa3ZuJTERc4eCfCbsPlfhorlw6fLG3i4IQm
L3PkKY0T2rSR9xAH8pruXzY8oLFFPTa80lQB4YF11qn3aIx3EJaYByiAUeXG
0Q00Zi0+2/XOeQU4lUb+bPA9jdmbuqT8pwoo89rMD7tML/DfMX3+vXHQHzP+
/Eo+jYEj8l2eR8fh2IWx6tFTNNboWBsOdI3DkAulcjpB40fxKcNbFngK+qPY
Jy2JxubQ15Jd0glo+SYpn4mlMSIrxzZk/STY2/v9uVRIo+XiAmlG8yR812nn
FB5MY32XS2l02BRoHeVllW+lsXGvaLJXQwkJ1j0dY4TG0rLrcbptSviDqlvh
7Ewj72261sn8afg6aMbTxZ7GKxn3TWu/UoFpP9nvuopGV/xd3TxqBurjRGfc
TGm0OynMij8yC/5zj+vcl9C42GbI3LbiDYzlmjwlGjTe7oneIp2ZA5FJxKzH
LIXPosiVkePzYFNZZeXFUSjxHF56610eaVkv9/AZorC6qO5a+rJFZGfLxi8/
fU6h3bvZqekuakTlm3pqayeFti8KpfzT6uTb3vZbviyF54bNJhgLTeK4n//E
r5lCcZo0Z+WcFnmgDFIF1C/0jXpb9XvokH3ZRRY7rlNY+zAwMWkZn2gYDZLg
Mgp9vepG7tYYkLLS1VGh+RQ6HBxRTjgYEbe1CbnhpylsqtY16oleRrp/bLqx
M5PC33xzckX6ZmSFY8HEsVTq/z//F3HGEK8=
             "]], 
            Line[CompressedData["
1:eJw1VGlQU3ccDMoREW2iUdAGD4rKoRSFgkVskZQiSAYVVFRGkY5cTkELUokU
xQBCAaUBqUNVZCiCQD25pIV9vv8LFME71bQOSqFcEvXlEMHE2PRDP+zs7MzO
zv5+H3ZxdNLmvVM4HE6gCf9xkFW8um2FHLfqH0oUZ+2prY1rdUlOcmSInaOa
G+ZRGv9su28WyKEVyALuWc2hTtzr8U0RyPF4bGfG4dt8ymWXYE+qtRzh54Wb
OvtnUh1jO7MPceRoOKEeWRg8nYpOq7woGWdw1T8/bGUqlzJajt1OVzHQTB4O
6nazpMpKVmky+hk89u6bCAk1p7wcJHMzlQy8Yzg299unUA8u3/SR3mFgadHZ
pdhnRiWunbY7m2EQtf39i7ogDmXdvVF6vJUBkf74Uf9ZIy5EnK7Ou8Igedh5
eOaoAaKhZ935FxjY5tYMDsfr0Ze8jC08w2DIa3G60vYt0s2SBEUyBpMFARK+
agJ2J5tWy3IZhDeHNc7/+w0ahMbIkgwGHrGLUqSacWysDcgsTWGgDdz0YY1w
HCrvwqrTCQzu/lMsz4l8jVy5oqssikFTxUjWucs6OIYJX57ZyqDgt8KoR7N1
oPq+mlUeYspf4mORcFyLyMQ6rwp/BoWUpPEvrhYTes2OytUMZGmL9g+UalCS
53Okyo2B67c2+UnuGrjbHqusdjTd++q6R7FCjZ6fuzovzmfwsO2TfdnH1Ihb
xVfV8Ux6ndjtp0/VMKcieJcsTf8wUxSIJlmcF5/3vGIgGFiqOmZ+k4Xvk+GI
axqCqkL5/kNFLJRxH3/XMEIw1us5NySWRcp4akXTU4LPnNrf+Qaw4GW1y1sU
BDMcOgLtXFjU8y2ft94ioNqbb92Yw2J9uXhmG0VwxGb70elcFoPLT61CE0FW
l3SNhRkLl4yqlyN1BH55eqGOwyLxbmPtrAqCmpvOSUqT//qijhjfUoLwxF35
fXYsJg48cojJJ1gTcEm6caWpLxl6evIoge1QsCBrM4tMwZuyGwcJplpbi9Tp
LDr2Wm0bSCCw9+fdc73KwrrZdvaMKILMiMjq0VcsQrlOd722EPyZYCzm+qhR
sn11flQwgbOlvuBUkRrK2vWB339OcKPBMPuRTg17Q8TUBk8CUYvbhvA4DaLF
8eh1JpB9EFDzUqXBhXNph60WErjWX89VZWkx9irPe6WAYJ6LXeo8Dx3c15Vp
d0wj4Ll9+evoWx0OymovZxlplFZuW17f9xqtA637LmlpuLgLjXdGx2H07F6m
HKGxP3R5i5/9BEQ5TwbMntLovF/1g146idzHY+WuD2lwU7flPHDWo8fJsHPL
7zTKzXvDqxe8A19iY3ekjYYotrNLfOg9tnYLFTXXaBS8a0ntcTGjyoQrih5U
0xhsDttNqadQz75eG2I4Q8MzfXDcwcOCcoSYu1RGYwP/CyZyCZeK4+1iQo/T
6A/jN3U72lC/7Ek8mpZOoyk03u/5Cx6luZbhW3mAhkRpmFW1ZQ7lZX5yoieG
RrKoP6dXL6SS/4gtjjbp//flX1Vzfuk=
             "]], 
            Line[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAAvbpu9oUrwr/1AXdStaAdQNLr8GDH
JcK/s5on1s4BGEAXPQEd8RrCvzZQZa//ZBJAXI4R2RoQwr+8FmHcXdsNQKDf
IZVEBcK/5GwGtHkpCUDlMDJRbvrBvyhD+ZXpxwVAKoJCDZjvwb87hGlsujwD
QG7TUsnB5MG/H5SOcqdCAUCzJGOF69nBv7zh7/TgXv8/+HVzQRXPwb9Srl/7
t8/8PzzHg/0+xMG/AQujhy6z+j+BGJS5aLnBv6LLYr637/g/xmmkdZKuwb89
uTfH/HL3Pwu7tDG8o8G/B6oEYYEv9j9QDMXt5ZjBvzdvdUknG/U/lF3VqQ+O
wb87mMsmNi70P9mu5WU5g8G/IJ7qNLVi8z8eAPYhY3jBv8xSHQz5s/I/YlEG
3oxtwb+Js9uQUx7yP6eiFpq2YsG/lJ1C39qe8T/s8yZW4FfBvxG1Ww1AM/E/
MEU3EgpNwb8yPoYZsdnwP3WWR84zQsG/OunM6sKQ8D+651eKXTfBvwqGvkxh
V/A//jhoRocswb/O4Ll9wyzwP0OKeAKxIcG/XOgqXmQQ8D+I24i+2hbBvwSd
SqX9AfA/zCyZegQMwb9mA8jBhQHwPxF+qTYuAcG/ta+QQzAP8D+GtijIEPfA
v8ApoJMXKfA/+u6nWfPswL+RIf5ASFDwP24nJ+vV4sC/mmXJwpKF8D/iX6Z8
uNjAv+vGwVUMyvA/VpglDpvOwL99xmqzGx/xP8rQpJ99xMC/uDtHZoqG8T8+
CSQxYLrAv7u7O1ucAvI/skGjwkKwwL+ClgUWMJbyPyZ6IlQlpsC/0NBrH+tE
8z+asqHlB5zAv3xgByV4E/Q/Dusgd+qRwL/gPONO3wf1P4IjoAjNh8C/AYna
ZQYq9j/2Wx+ar33Avzn/BitvhPc/apSeK5JzwL/abhLuWSX5P97MHb10acC/
udbapY8g+z9SBZ1OV1/Avyzs2udPkv0/xj0c4DlVwL8FOk+YKlIAQDp2m3Ec
S8C/GkzKkXNLAkCurhoD/0DAv72vZroy6QRAIueZlOE2wL86GCitHIYIQJYf
GSbELMC/5kE/a+7ODUAKWJi3piLAv/p4ktoTHRNAfpAXSYkYwL9Gx+k89dMa
QDByrGADF8C/9QF3UrWgHUApObJa
             "]], 
            Line[CompressedData["
1:eJw9klkwlAEAx5cdV4xrnTtui4pxPSA1ShGjHGOsKZlhDLsh6TC5hzxIOijK
fQwapVXMGEez3/f/csQwq7GEDDM6aBC+3WXXER0vPfzm9/h7+VnHpYYnKDMY
DMe//PPQhO2nsY/AqGAya6rOnCrkOvj+HAM261f1dvZNqOsf7OI7e4AKtQDN
HhV9KtKTc+9OM8BXsHsDT2tRPi9t2k6WAPlsFZYgQI1yMLUWMbIBm+mU3RNz
TEq32JIe4gHsa8mtxleUqJ09c9aDcCAoJr2Yu3GIxWQzjzAfYCLmfa7Xr32M
zLMvGx4HOq1FRyabd9ERbJozZwhEFe6WbBMKVJLGDQ1KwLpowpzhKke+i1F/
/DqJ3qpsrv+PLVxtNFg69pmEvF3ZOWJahjA9lvrmIAmume96sEwKrwI9x64O
EsNny71nPKSwkumEZNaSyDCa7ePVSKARr33Tp4hEaJCN27iZBNIprXJmGonA
qYLalR4ac/6aPSMxf3u/Ozr4STT6uzXmHl0g8dZOotfiTqPNQf0g3JPEZlRq
6mMdGk8rVa1MbEmUGGWU1TBoZGmonFvQJkFOlA2QKjTispi8pj0CbrcNRpIs
aQStKd3nLxNoXckWV4fQcI9mCJzEBDRnOPzv5TTYosNxCUFARyR+Xr5FQ9nn
QNL9ikDCGCdj/oYEa2/2DXKeEXDIMY9kaUsxZbnn6XuXQNxoJcdULIWwdCdK
NYXAUV6JaHVQhhYlRe7YJQJDodtxhZItPLy13VjqR6Aoxz4tgi9H2jfZANeV
QFdiMDvz1A6iI6TLbDMC+n1VuqIne/AbojUW1QiMKjybtKsP4OSx6fRCJsT5
msQzy5MMiuecl9e3IMSSIDmWt8GkGux1xKJhIVjvWoF2dWrWooHztVMIk6wv
8uxYXUrf2CVdXiOEwju+rvm1CXWx3iK/t0L4/88/w2d8pg==
             "]], 
            Line[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAt7abnTd6ub/KrNN61J0dwFz3/WXm
cLm/DrUh7ZCBFMCW7424+lq5vxA4C9vdzQrAz+cdCw9Fub8D/kFyPgsEwAjg
rV0jL7m/UFW6xJMiAMBC2D2wNxm5v2wL3ddAPvu/e9DNAkwDub/r5+RtzMv3
v7TIXVVg7bi/qUWwQ0RW9b/uwO2ndNe4vz4wkCpHi/O/J7l9+ojBuL9QWT77
sTryv2CxDU2dq7i/3TmaBhJH8b+aqZ2fsZW4v38uONkKnvC/06Et8sV/uL/t
LMhbZDTwvwyavUTaabi/GzJq9/UD8L9Gkk2X7lO4v/pSZwqjCvC/f4rd6QI+
uL895J+zEUrwv7iCbTwXKLi/7zf91AbI8L/yev2OKxK4v7fGnDyJj/G/K3ON
4T/8t7+2Tz5fObPyv2RrHTRU5re/XY0jPd1R9L+eY62GaNC3v1OEnAN1n/a/
11s92Xy6t79n80P5ufj5vxBUzSuRpLe/KIrn/9QR/79KTF1+pY63v8hp31PL
vAPAg0Tt0Ll4t79uG+RP7bcLwMJI7E80Y7e/x9wegEmyF8Aq33QJ6l23v8qs
03rUnR3Axpf1Cg==
             "]], 
            
            Line[{{-0.07110969387755102, -5.103243226248486}, \
{-0.07099718267210106, -3.786833385336398}, {-0.070668790647986, \
-2.1956783911109836`}, {-0.07036243252073396, -1.6176535172369544`}, \
{-0.07005607439348194, -1.3176369842365994`}, {-0.0697497162662299, \
-1.1471964554538556`}, {-0.06944335813897787, -1.051220772493595}, \
{-0.06913700001172583, -1.00641714175604}, {-0.0688306418844738, \
-1.0039971590545087`}, {-0.06852428375722176, -1.0446163975803915`}, \
{-0.06821792562996973, -1.139003076478017}, {-0.06791156750271769, \
-1.315199690090611}, {-0.06760520937546566, -1.6433044825371892`}, \
{-0.06729885124821362, -2.3345333289728236`}, {-0.06699249312096159, \
-4.401569390228817}, {-0.06698554421768707, -4.49536183783641}}], 
            
            Line[{{-0.05231270139634801, 
             2.80998988815163}, {-0.05198094488561192, 
             1.4715925690432712`}, {-0.05167458675835988, 
             1.11899210125038}, {-0.05136822863110785, 
             1.0053045850152162`}, {-0.051061870503855813`, 
             1.0359343384730653`}, {-0.05072971464081376, 
             1.2727811718130408`}, {-0.05039755877777171, 
             2.1026066946561244`}, {-0.0503188775510204, 
             2.5790756686866603`}}], 
            
            Line[{{-0.029984152752009892`, 
             1.1206258761034942`}, {-0.02980389526916451, 
             1.0138430233217743`}, {-0.02973064225690276, 
             1.0977254888459496`}}], 
            
            Line[{{-0.009885204081632652, 
             2.060572751003258}, {-0.00976541824092948, -1.04916468013099}}], 
            
            
            Line[{{0.009582112547940518, 1.1033631247583113`}, {
             0.009582112547940518, 1.1033631247583113`}}], 
            
            Line[{{0.050318877551020394`, -2.5790756686866603`}, {
             0.050643578668224415`, -1.3960876796256034`}, {
             0.05097717218980839, -1.0710893996539441`}, {
             0.05131076571139237, -1.0005879428178173`}, {
             0.05164435923297635, -1.100037134002879}, {
             0.051977952754560325`, -1.46609463073246}, {
             0.052311546276144295`, -2.8002409360164315`}, {
             0.05231270139634801, -2.80998988815163}}], 
            
            Line[{{0.07174744897959183, -5.148419904713501}, {
             0.07198747403028682, -2.986180388805129}, {
             0.07231497753255878, -1.947883378332608}, {
             0.07264248103483073, -1.4912688635485754`}, {
             0.07296998453710268, -1.2483318064818185`}, {
             0.07329748803937464, -1.1102107077186005`}, {
             0.07362499154164659, -1.034420147461659}, {
             0.07395249504391854, -1.0024357323192412`}, {
             0.0742799985461905, -1.0069521300837392`}, {
             0.07460750204846245, -1.0478050755787844`}, {
             0.0749350055507344, -1.1317139277371286`}, {
             0.07526250905300635, -1.275497426283205}, {
             0.07559001255527831, -1.5161428884865624`}, {
             0.07591751605755026, -1.9419239549696603`}, {
             0.07624501955982221, -2.8147675388862563`}, {
             0.07657252306209417, -5.379702966358355}, {
             0.07660419937205651, -5.910570866517362}}], 
            Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAZSTkF5Fdtz/1AXdStaAdQKbCvp8a
YLc/InpwDs1zGkBOpZM4kXW3P/T9ocZkfA1A9odo0QeLtz9a9Zefq7IEQJ5q
PWp+oLc/wrTSVbAnAEBFTRID9bW3P0H0m5862fo/jmEJ8fnJtz+n+bpaf3n3
P9h1AN/+3bc/i0sC8I8Z9T8hivfMA/K3P6ylUND/YvM/ap7uuggGuD8eBWsn
BiTyP7Oy5agNGrg/mvi3m1g+8T/8xtyWEi64PywugT3vnvA/RdvThBdCuD8d
LFeNwjnwP47vynIcVrg/OsSQUH0H8D/XA8JgIWq4P/4jqLA6BPA/IBi5TiZ+
uD+09gEl5C7wP2ossDwrkrg/tT0dvP2I8D+zQKcqMKa4P7fMIffQFvE//FSe
GDW6uD8YlA5IAODxP0ZplQY6zrg/ax+3R6vw8j+PfYz0PuK4P0nHVYh8W/Q/
2JGD4kP2uD/9oHIcWj32PyGmetBICrk/IhiD80bE+D9qunG+TR65P11NMcgM
Pfw/s85orFIyuT/9BpH+bZgAQPziX5pXRrk/kLgKWtxWBEBF91aIXFq5Pzig
jE5EjApAjgtOdmFuuT97TDe9vlETQMQ3KQbRerk/9QF3UrWgHUCeueB7
             "]], 
            Line[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAAZ+IEaGavD/1AXdStaAdQEZL4JIr
o7w/vvGaNisgFUCPX9eAMLe8P0GMtNMTUw5Ahuw8P+bMvD+F5YCnw10HQH55
ov2b4rw/IBnGCo4hA0B2Bgi8Ufi8P97MwhlWTQBAbpNtegcOvT9tpDee4Jb8
P2Yg0zi9I70/2GZ2e52e+T9erTj3cjm9P75fKkyGW/c/VjqetShPvT9GOGSM
R5n1P07HA3TeZL0/qw49qmg29D9GVGkylHq9PwYQaKOWHPM/PuHO8EmQvT/Q
6PH/cDzyPzZuNK//pb0/Rqizeh6L8T8u+5lttbu9P7/sKMTXAPE/Joj/K2vR
vT+5cpVn/pfwPx4VZeog570/Ly4lRYdM8D8Wosqo1vy9P5tfpBiZG/A/Di8w
Z4wSvj/88qzdTAPwPwa8lSVCKL4/RUmQXYUC8D/+SPvj9z2+PxlY+Z7XGPA/
9tVgoq1Tvj8fHqO6gEbwP+5ixmBjab4/kVvAjGeM8D/m7ysfGX++P/zzfVIq
7PA/3nyR3c6Uvj91adDYOWjxP9YJ95uEqr4/u2QazgUE8j/OllxaOsC+P+H/
In9AxPI/xiPCGPDVvj+9cjWCRK/zP76wJ9el674/gM+r2q3N9D+2PY2VWwG/
P3hMO2hEK/Y/rsryUxEXvz/nBJbya9j3P6ZXWBLHLL8/FcMcWXns+T+e5L3Q
fEK/PyPjVySkifw/lnEjjzJYvz9F9xCCCeT/P47+iE3obb8/cjwNpngnAkCG
i+4LnoO/P3FQ0A39KwVAfhhUylOZvz+lFwr6X4IJQHaluYgJr78/VPA3Pu0c
EEBuMh9Hv8S/PzYjgGSl9xVAXkwxK93Rvz/1AXdStaAdQPBAOjs=
             "]], 
            Line[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAANVJmyCAXwD/KrNN61J0dwKN5jf+l
GMA/OlmBDSC1GsAfQMDegCPAP119WdBeqhLAmwbzvVsuwD9GLJcmNtIMwBfN
JZ02OcA/219ihieTB8CTk1h8EUTAP2v50KgECATAD1qLW+xOwD+bR63UGn0B
wIsgvjrHWcA/rurqxFEr/78H5/AZomTAP8k6xMr2Ofy/g60j+XxvwD+/QnfR
2uX5v/9zVthXesA/uSPLy5QF+L97Oom3MoXAP6fuiDhLffa/9wC8lg2QwD8+
RR+BmTn1v3PH7nXomsA/qqR68pos9L/vjSFVw6XAP2REwmkfTPO/a1RUNJ6w
wD8RvlqriZDyv+cahxN5u8A/ea7ZqxL08b9j4bnyU8bAPxxjPyxLcvG/36fs
0S7RwD/bf1MWxQfxv1tuH7EJ3MA/XDih8tax8L/XNFKQ5ObAP4dxhPhwbvC/
U/uEb7/xwD/QI+tL/jvwv8/Bt06a/MA/IBnF4E4Z8L9LiOotdQfBPzNY5K6H
BfC/x04dDVASwT/2IT2pFwDwvxQu4RZyHME/S45sK68H8L9gDaUglCbBP+Kz
H0xyG/C/rexoKrYwwT8Xl1DEgDvwv/rLLDTYOsE/UDTvKClo8L9Gq/A9+kTB
P03BkTXrofC/k4q0RxxPwT/bmHvxe+nwv+BpeFE+WcE/Sicn9Ms/8b8sSTxb
YGPBP6JN1zcQpvG/eCgAZYJtwT81fMsezh3yv8UHxG6kd8E/QYDxmeuo8r8S
54d4xoHBP9X4hsnESfO/XsZLguiLwT+r8IcKSQP0v6qlD4wKlsE/1GEzSyLZ
9L/3hNOVLKDBP7ow8uPqz/W/RGSXn06qwT9eQbdfeO32v5BDW6lwtME/2tLv
IUU5+L/cIh+zkr7BP0PnC6oIvfm/KQLjvLTIwT9T4uonmIX7v3bhpsbW0sE/
CJXUsjqk/b/CwGrQ+NzBP4BTlHZeGADAD6Au2hrnwT9VCr9FZ6YBwFx/8uM8
8cE/txnA89mUA8CoXrbtXvvBP//2MZo1CQbA9T1694AFwj8eSaEyeD8JwEId
PgGjD8I/sn+Mu++dDcCO/AELxRnCP89YZR498RHA29vFFOcjwj+43+bl0swW
wEUVuNEDLMI/yqzTetSdHcBBKsGL
             "]], 
            Line[CompressedData["
1:eJw9lGtUk3UAh9lwMBFvXLzkJddBnBc09ShO0t8bJMSAElBAp4KoSDiWwMAL
4pQjIYlMRcsyBGmI7YQOA0QM0Pf9zxQRjKuQCnJLub6DbRAXyb704TnPx+fb
Iwj+2mcf18TExP09/7mhXFVrvp+GgXPIJz9jHjVgXLCtNozG1ErVQT/lbIqq
awselNPoTXvmFlFqTSXn35DOVtAIe7mtJ0owjWq4KI1xSqLxdnTccG/rJMpe
/vGJnak0UnqWSyK15lSkrz5JkUbDTbPnUKANjypdVZh6LZtGlveTGnqYS1la
HUtjcmkE5GmL1Z4cKkCH7PZ7NAa3JGRt/2scWc9Mc80f0kg/clrieGkM/bf+
KFr8jEbZPOvUGb+OYKPyDPFopBHsmn82y3IYZ2RfVoS30fCIE7zMuDGE517W
z5W9NPzrPZrcogdh51D/OneIxqX7yRe3hRlx0PJKVzWXgVKRHxBy0oDirl0G
gyWDuq2475+vh8WTj8ZnzmSw70yTfg5XDz91B3+9gMG1xr1doXsHkJmkttqx
lEGxMOEfZUM/+kJlc4+vYbAwKLtlR2A/Pvl8lX0GGLS+cJk2NqDD6UXGFbQ7
A7taq/zuSzrUmBWJ2nwZNOSUuL9x0UHQEeditosBFfut2+tRFjLtp17CUAaJ
r+5uNZSyKFLx/MWRDKKt3Pz2J7MwP/U4SHqMwYHmgvYfdrPYsudsWMo3DKwH
O8YswCLD2VuuOcfgThTvxGY7Fj0C2+NVPzLIu1Vx2HY6i3Wx1yIeqBiMKJe0
OPNYxNc47NPcZBDlsC7T0YRFuUNRQHohA61ZZWUNh8WMRFfPFJrBwyNetyZa
sAhqrkJcOYPzd145Vs9ioRYFrpbWve/xwpuclrPQX+iylzQz0HjkqCViFhu7
D30g7mSw4MO1JwPCWZzeNGGKSM+AI7B+FPI9i6qr5zjCdwzuBbW6lT1iMXdo
rmEGn0DQHBNSz9EhxPuXNzwrgqNR60v1zjpo1Gte6OcQdKaULU5L1mHYlK5s
XUjAC+W5BDfp8NnOL5iqFQSzysWpfU79UBY0FjwQEUxu18qn/NyPxqn71RoX
gt3L/f5W2w7A7quBtHQvAkNv99mGiwOQ0YrzKf4EVxOC7ZoEehTOsUyI202w
xv1tnahED2705cPSAwS6aB9+zgEDPCvspJJoAueIEtfNy4z4blFuoFhBIAss
iM7kDqL5xAZfURLB6AbPK5m6QSxpfOwqTCWYz8nzZUeHIF/tt35mGsHTWPen
RuEwSpJbHMyyCVojlAr72BHwO2QCg4ag9op/vcvwKHwwYtNWRFAtyXGtufkO
P11O5FcTgvCViUtfeJtQHTrr0QcVBMZy8fipKA610iOjT/Oc4PZvptdva7nU
MdWy1vQWgsq7kX09WyZQD8cK61K6CVKOTneOX2VGTfPfVBZnJHDMk6tGYvjU
ds2fxVITLe4KQq7vdZ1EqSbuypVYaNHe2ZvYWj+F6g3uVIlttJBPcCoW0tOp
db/HXBbN1yJp8nClZ78NFW9rmiwUanGVe6HDJnk2pZDx1z5y0P7/n38BOlFN
OQ==
             "]], 
            Line[CompressedData["
1:eJw9lGs8lAkYxce4RQxJRiQRsbFJGzWSp4ukmnaHimoql25SYqOyZlPUoiRR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             "]], 
            Line[CompressedData["
1:eJw9lmk0lYsXxs+RWSGlotIsma6UjHle0kghJ4lKRKlEInQpmtwSpaiEVKRO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             "]], 
            Line[CompressedData["
1:eJw9Vmk0lW0XPmRWJAcpUYrEG/pCUWxjSanOCRUS9VLGvEWiFJKhpFGdJqGE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             "]], 
            Line[CompressedData["
1:eJw9WHk01tv3Ns9jmctNpiRCkUbPSSpdISGiiEjialCirtyQUqZUSErkqlSU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             "]], 
            Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAbOdpCJlLvL/1AXdStaAdQPf3bsFH
RLy/Zc7dOaCeFkAw8P4TXC68vz7RBsvyoQ5AauiOZnAYvL8KCy1/CkEHQKPg
HrmEAry/7i9fHGfVAkDc2K4Lmey7v+Zx1s540/8/FtE+Xq3Wu7+KqZMQ1bf7
P0/JzrDBwLu/Pjeg6Ya0+D+IwV4D1qq7v6LdAN59bvY/wrnuVeqUu793N9bt
Ia/0P/yxfqj+fru/LtmAROxT8z81qg77Emm7vzyJ+KwqRvI/bqKeTSdTu7+G
jI3Zj3bxP6iaLqA7Pbu/FxDNea7a8D/hkr7yTye7v9D/5p99a/A/GotORWQR
u7+3EU08diTwP1SD3pd4+7q/VuuLlQ8D8D+Ne27qjOW6v1WaBK18BvA/xnP+
PKHPur8A5BS4nC/wPwBsjo+1ubq/PCJNIByB8D85ZB7iyaO6v2MT1AnO//A/
clyuNN6Nur/JWOUBVLPxP6xUPofyd7q/xOjE0T+n8j/lTM7ZBmK6v81ATJwF
7fM/HkVeLBtMur/rioa0a5/1P1g97n4vNrq/Qicy0uno9z+SNX7RQyC6v4QA
ojBMEPs/yy0OJFgKur8SVIh5HpT/PwQmnnZs9Lm/M9woN+o2A0A+Hi7JgN65
vzsD1yiX6ghAdxa+G5XIub/PfJJqqQkSQB0GWFcnuLm/9QF3UrWgHUDxLwus

             "]], 
            Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAUCaudG9Atb/xeCuCELgbwBS30jWl
M7W/UMhlCnlAEcBTu9G0Hx61v/XlpsA5TQXAkr/QM5oItb9rHmf2+kP/v9DD
z7IU87S/ioOq1bkd+b8OyM4xj920v6gZ6y6NYvW/TMzNsAnItL9oC89HwP/y
v4rQzC+EsrS/1FOn87l28b/I1Muu/py0v1E77g+jh/C/BtnKLXmHtL8f63qo
MxLwv0XdyazzcbS/+H0XCDUJ8L+E4cgrbly0v/j7HaMxbvC/wuXHquhGtL+P
aohaV1LxvwDqxiljMbS/5bqPoEjd8r8+7sWo3Ru0v+qlmbtVX/W/fPLEJ1gG
tL/SNysIioH5v7r2w6bS8LO/TNM0dH9sAMD4+sIlTduzv0ZgLeL4HwjAGGpY
9CDGs78yNt0hVNYXwJTtsHU=
             "]], 
            
            Line[{{-0.062181122448979595`, -3.9226990817915124`}, \
{-0.06178440495767701, -1.8186868407229564`}, {-0.06147804683042497, \
-1.3482970630062292`}, {-0.06117168870317294, -1.1269961941016169`}, \
{-0.0608653305759209, -1.0248834920750012`}, {-0.06055897244866887, \
-1.0008128269664063`}, {-0.060252614321416834`, -1.048081598317164}, \
{-0.0599462561941648, -1.1882004547470295`}, {-0.059639898066912764`, \
-1.4977837348198095`}, {-0.05933353993966073, -2.2567585839576223`}, \
{-0.059142406962785124`, -3.5212326350258305`}}], 
            
            Line[{{-0.04134778911564626, -1.820634552138917}, \
{-0.041097194612594264`, -1.1563235208158575`}, {-0.040765038749552215`, \
-1.0047071071732772`}, {-0.04043288288651016, -1.341886857214552}, \
{-0.040318877551020406`, -1.7182688775410655`}}], 
            
            Line[{{0.020318877551020458`, -1.59739408997913}, {
             0.02038633469346006, -6.0944732325283235`}, {
             0.02038633469346006, -6.0944732325283235`}}], 
            
            Line[{{0.04031887755102041, 1.7182688775410313`}, {
             0.04076831578702775, 1.0041221369365703`}, {
             0.041076111572821705`, 1.1314271713206836`}, {
             0.04134778911564626, 1.820634552138917}}], 
            
            Line[{{0.05914240696278512, 3.5212326350258305`}, {
             0.05931701022940779, 2.326455596907483}, {0.05965060375099176, 
             1.482225045340118}, {0.05998419727257573, 1.1640817807037305`}, {
             0.060317790794159706`, 1.0314911358897496`}, {
             0.060651384315743684`, 1.0007507212459354`}, {
             0.06098497783732766, 1.054206172723444}, {0.06131857135891164, 
             1.2135645941780049`}, {0.061652164880495616`, 
             1.568632317276797}, {0.061985758402079594`, 2.468969181426472}, {
             0.062181122448979595`, 3.9226990817915124`}}], 
            Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAGGpY9CDGsz8yNt0hVNYXQBiT0Yyl
2rM/Q0uh2xp9CEDAdaYlHPCzP2awRzV3lwBAaFh7vpIFtD8uFFfgArP5PxA7
UFcJG7Q/D6slA9t+9T+4HSXwfzC0PyGsWdod8vI/YAD6iPZFtD+LQ125yl/x
PwjjziFtW7Q/RMtP2s118D+wxaO643C0Pyt6XuKJC/A/WKh4U1qGtD+zoFyQ
Gg/wPwCLTezQm7Q/VbMOVT9+8D+obSKFR7G0P0xRXhU8ZfE/UFD3Hb7GtD+l
yyVdyuLyP/gyzLY03LQ/mfISeMoz9T+gFaFPq/G0P8nLpypc0Pg/R/h16CEH
tT/1B3yIhrr+P+7aSoGYHLU/PlL4IV7ABECWvR8aDzK1P5lCJDVffBBAUCau
dG9AtT/xeCuCELgbQNOdjzY=
             "]], 
            Line[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAoG1CPoi9uT/KrNN61J0dwP1wIRx6
0rk/yJxqk7D1DcBGhRgKf+a5PzC+fCtpcwbAj5kP+IP6uT9y9YGTnhkCwNit
BuaIDro/ocoDRTST/r8hwv3TjSK6PzvY7A6Jrvq/atb0wZI2uj+jktF25dz3
v7Pq66+XSro/rF6J22DC9b/8/uKdnF66P5uXCDG0KPS/RRPai6Fyuj9Z+qQ7
6e3yv44n0Xmmhro/HQyjkdL78b/XO8hnq5q6P2MTgjODQ/G/IFC/VbCuuj+8
v3rrwLrwv2pktkO1wro/7agRiINa8L+zeK0xuta6Pw5WB5YLHvC//IykH7/q
uj8rtWKNUwLwv0ahmw3E/ro/+QOVjroF8L+PtZL7yBK7P6LMCeTWJ/C/2MmJ
6c0muz9sqmpQZ2nwvyHegNfSOrs/Ov0rH2DM8L9q8nfF1067P2DJ1uAVVPG/
swZvs9xiuz+Q6bctjQXyv/waZqHhdrs/LbFMYf7n8r9FL12P5oq7P6n4I6Go
BfS/jkNUfeueuz+ew4KxJW31v9hXS2vwsrs/OMf3s5oz978hbEJZ9ca7P2Vv
qRN5ePm/aoA5R/rauz8nUFnkQWz8v7SUMDX/7rs/6+K688EuAMD9qCcjBAO8
P1R7jUn66QLARr0eEQkXvD+BGITItecGwI/RFf8NK7w/anZjIu04DcDY5Qzt
Ej+8Px4TOUH7ThTAjQtHGTBNvD/KrNN61J0dwJFkKRw=
             "]], 
            Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAASIP2Hlktt7/1AXdStaAdQHxV6cyj
Ire/jIhK5wSgE0C6WehLHg23v+Qep3q/ighA+V3nypj3tr8BDzfkfgcCQDhi
5kkT4ra/UbdLHNLT/D92ZuXIjcy2vwxSENAfUvg/tGrkRwi3tr8ecoOxAFP1
P/Ju48aCoba/Q+FPlr9D8z8wc+JF/Yu2v05ZCmsj1/E/b3fhxHd2tr+Zva+4
3OHwP6574EPyYLa/q6CuHD1L8D/sf9/CbEu2vwFpBAMjBvA/KoTeQec1tr/H
vfr2wA3wP2iI3cBhILa/CYZI0pxk8D+mjNw/3Aq2v+uYVLxVFfE/5JDbvlb1
tb8uujiRmTXyPyKV2j3R37W/HDBWQ+js8z9hmdm8S8q1vxVd1GiOg/Y/oJ3Y
O8a0tb/8sYVad4b6P96h17pAn7W/ELKhQgeVAEAcptY5u4m1v8jqOHai0AZA
WqrVuDV0tb/z7vul7AMTQFqE/DU7arW/K3VtFzPuG0DBE8av
             "]], 
            
            Line[{{-0.06634778911564626, 
             4.453286353322944}, {-0.06576706061195345, 
             1.6642464539448878`}, {-0.06546070248470141, 
             1.3103844097896689`}, {-0.06515434435744938, 
             1.1256408822793968`}, {-0.06484798623019734, 
             1.0318728036819933`}, {-0.06454162810294531, 
             1.0001850840514062`}, {-0.06423526997569327, 
             1.0231015136405852`}, {-0.06392891184844124, 
             1.1091081832110583`}, {-0.0636225537211892, 
             1.290146899030078}, {-0.06331619559393717, 
             1.6568294177647533`}, {-0.06300983746668513, 
             2.52782460448276}, {-0.0628188775510204, 3.962041497624635}}], 
            
            Line[{{-0.02470912145345943, -1.0041979309371902`}, \
{-0.02470912145345943, -1.0041979309371902`}}], 
            
            Line[{{0.05587443310657596, -3.153057602532256}, {
             0.05598107501356803, -2.3996943898357483`}, {
             0.056314668535152004`, -1.4480936768896737`}, {
             0.05664826205673598, -1.1274085856181644`}, {
             0.05698185557831995, -1.0121876626118123`}, {
             0.05731544909990392, -1.0138621410622044`}, {
             0.0576490426214879, -1.1290117999199374`}, {
             0.05798263614307188, -1.4298283642113063`}, {
             0.058316229664655855`, -2.231842650953323}, {
             0.05850465186074431, -3.484323152696618}}], 
            
            Line[{{-0.07660419937205651, 
             5.910570866517362}, {-0.0765798470820574, 
             5.493690869319044}, {-0.07625145505794231, 
             2.8407775309602266`}, {-0.07592306303382723, 
             1.9517557570426225`}, {-0.07559467100971215, 
             1.520585997906497}, {-0.07526627898559707, 
             1.2776151731026664`}, {-0.07493788696148199, 
             1.1326829135873064`}, {-0.07460949493736692, 
             1.0481746067835538`}, {-0.07428110291325185, 
             1.0070271257377232`}, {-0.07395271088913677, 
             1.0024270597747211`}, {-0.07362431886502169, 
             1.0345269540265065`}, {-0.0732959268409066, 
             1.1107001725818595`}, {-0.07296753481679152, 
             1.2496828157138655`}, {-0.07263914279267646, 
             1.4945579756015472`}, {-0.07231075076856139, 
             1.9561933666537874`}, {-0.0719823587444463, 
             3.0124823218839296`}, {-0.07174744897959183, 
             5.148419904713501}}], 
            
            Line[{{-0.058504651860744314`, 
             3.484323152696701}, {-0.0581081074306526, 
             1.636194686796276}, {-0.05780174930340057, 
             1.2346198141331177`}, {-0.05749539117614853, 
             1.059637977730024}, {-0.0571890330488965, 
             1.0009860703688125`}, {-0.05688267492164446, 
             1.0324735805760235`}, {-0.05657631679439243, 
             1.1733710687193575`}, {-0.05626995866714039, 
             1.5201362725296252`}, {-0.05596360053988836, 
             2.495460760793538}, {-0.05587443310657596, 3.153057602532256}}], 
            
            
            Line[{{-0.0353954081632653, -1.4043123629610637`}, \
{-0.035118389077837334`, -1.0030649215144687`}, {-0.03480163617171006, \
-1.349256379613811}}], 
            
            Line[{{-0.015065737833594946`, -1.0813071969165946`}, \
{-0.014803845779489892`, 1.0124725317966445`}}], 
            
            Line[{{0.0628188775510204, -3.962041497624635}, {
             0.06298653896683151, -2.6413614444743394`}, {
             0.06332013248841549, -1.650112644922948}, {
             0.06365372600999947, -1.2655727304192381`}, {
             0.06398731953158344, -1.0868227483801702`}, {
             0.06432091305316742, -1.0110212057231331`}, {
             0.0646545065747514, -1.0054555243907872`}, {
             0.06498810009633538, -1.0659641435166387`}, {
             0.06532169361791935, -1.2120562540177149`}, {
             0.06565528713950333, -1.506432898180336}, {
             0.0659888806610873, -2.1489625640917627`}, {
             0.06632247418267127, -4.130056176116478}, {
             0.06634778911564625, -4.453286353322806}}], 
            Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAWoT8NTtqtT8rdW0XM+4bwI5lnuRy
crU/BZY3oW8kFMA2SHN96Ye1P4Fsz7rnlwfA3ipIFmCdtT8LhLaO7vgAwIYN
Ha/WsrU/jsavgv78+r8u8PFHTci1P2583f9d0Pa/1tLG4MPdtT8fSwbQ7CD0
v361m3k687U/ZwEetCZZ8r8mmHASsQi2PxVa60DYLPG/znpFqycetj8vvyQG
d3Lwv3ZdGkSeM7Y/wNwUdRoT8L8eQO/cFEm2P2CSdMBCA/C/xiLEdYtetj/9
E1Lmoz/wv24FmQ4CdLY/zv5WFDDM8L8W6G2neIm2P/SN+PvhtPG/vspCQO+e
tj98xP9qnRDzv2atF9lltLY/zd4eZpQH9b8OkOxx3Mm2PxbIUtr+4Pe/tnLB
ClPftj9NCNHNkCL8v15VlqPJ9LY/hJRoJi1xAcAGOGs8QAq3P67qsNcDZQfA
rhpA1bYftz9rtaiprSESwKu9EWAJLbc/yqzTetSdHcCdD8B9
             "]], 
            
            Line[{{-0.04968112244897959, -2.548145835186544}, \
{-0.04940109118864555, -1.4489012768411613`}, {-0.049068935325603504`, \
-1.0762080170388715`}, {-0.048736779462561455`, -1.0016703079663114`}, \
{-0.0484046235995194, -1.1395497343432657`}, {-0.048072467736477345`, \
-1.7156338214813787`}, {-0.04793792517006802, -2.3535132944912696`}}], 
            
            Line[{{0.011813130424583485`, 1.1251618892011548`}, {
             0.012140592627035013`, 1.092152524706618}, {
             0.012470422309692015`, 1.7811858320170577`}, {
             0.012800251992349018`, 2.6439988979089017`}, {
             0.013130081675006018`, 2.064099366870183}, {0.01345991135766302, 
             1.2513957626759704`}, {0.013789741040320023`, 
             1.00154416187368}, {
             0.013966836734693625`, -1.0495227705370078`}}], 
            
            Line[{{0.05295045649838882, 2.8427315848374635`}, {
             0.05297873331931224, 2.6230460262968665`}, {0.05331232684089622, 
             1.4482137997738325`}, {0.0536459203624802, 
             1.1064075463962042`}, {0.053979513884064176`, 
             1.0032292605672881`}, {0.054313107405648146`, 
             1.0396921121561147`}, {0.05464670092723212, 
             1.2378607595912448`}, {0.054980294448816094`, 
             1.7929218352874938`}, {0.05523667800453515, 3.11833419248745}}], 
            
            
            Line[{{-0.03814266091051805, -1.584736317978237}, \
{-0.0381077918452158, -1.4542527440948227`}, {-0.03777563598217375, \
-1.0038566668081095`}, {-0.03744348011913169, -1.2562026442509924`}, \
{-0.03735591458805744, -1.5095795132866188`}}], 
            Line[{{-0.01739386396486446, 
             1.0003534200409254`}, {-0.01739386396486446, 
             1.0003534200409254`}}], 
            
            Line[{{0.04198554421768707, -1.8455061629354201`}, {
             0.042307294715997534`, -1.0996964055424494`}, {
             0.04261509050179149, -1.0057773906610754`}, {
             0.04292288628758545, -1.2429277340289417`}, {
             0.04315938331854481, -1.9651809696942875`}}], 
            
            Line[{{-0.043159383318544804`, 
             1.96518096969424}, {-0.043090129790846574`, 
             1.6505469352461268`}, {-0.04275797392780452, 
             1.0659417887706217`}, {-0.04242581806476247, 
             1.0250772864417346`}, {-0.04209366220172042, 
             1.4442144594325923`}, {-0.04198554421768707, 
             1.8455061629354201`}}], 
            
            Line[{{-0.0025660685603606263`, 
             1.2394747418860614`}, {-0.0025660685603606263`, 
             1.2394747418860614`}}], 
            
            Line[{{0.03735591458805744, 1.5095795132866188`}, {
             0.03769035792908816, 1.0050697334310699`}, {0.03799815371488212, 
             1.1913884361132403`}, {0.03814266091051805, 1.584736317978237}}], 
            
            Line[{{-0.05523667800453515, -3.11833419248745}, \
{-0.05473816803088022, -1.3376349787415371`}, {-0.054431809903628184`, \
-1.0872495835474913`}, {-0.05412545177637615, -1.002946074352981}, \
{-0.053819093649124114`, -1.0330774014313413`}, {-0.053512735521872086`, \
-1.2017832830206756`}, {-0.05320637739462006, -1.663686976996888}, \
{-0.05295045649838882, -2.8427315848374635`}}], 
            
            Line[{{-0.013194635962493774`, 
             1.620912909258744}, {-0.01274718712931908, \
-1.0131394327463483`}, {-0.012437065163140072`, -1.0464326825569041`}, \
{-0.012126943196961063`, -1.007548666638213}, {-0.011816821230782057`, \
-1.0825715077099811`}, {-0.011813130424583535`, -1.1251618892004618`}}], 
            
            Line[{{0.006985544217678628, -2.165791057867302}, {
             0.007373731537710104, -1.0709888250222455`}, {
             0.007373731537710104, -1.0709888250222455`}}], 
            
            Line[{{0.028096655328798185`, -1.0427146859543108`}, {
             0.02825255102040816, -1.0569485908775333`}}], 
            
            Line[{{0.06698554421768706, 4.495361837836691}, {
             0.06732325474742319, 2.2543887426831097`}, {0.06765684826900717, 
             1.571619881625478}, {0.06799044179059115, 1.259308815139728}, {
             0.06832403531217512, 1.0989899614020813`}, {0.0686576288337591, 
             1.0212338755850783`}, {0.06899122235534308, 
             1.0001440486763298`}, {0.06932481587692706, 1.028532458552865}, {
             0.06965840939851103, 1.112239267106741}, {0.06999200292009501, 
             1.2738555758833134`}, {0.07032559644167899, 
             1.5713599040818447`}, {0.07065918996326297, 
             2.1700955259401433`}, {0.07099278348484694, 
             3.7492986720965487`}, {0.07110969387755102, 5.103243226248486}}], 
            
            Line[{{-0.009115084713028219, 
             1.2602218060448998`}, {-0.008739961646240073, \
-1.0350053652965383`}, {-0.008435929699373089, -1.0081817441557013`}, \
{-0.008432296795986952, -1.0429338518665856`}}], 
            
            Line[{{0.031568877551020405`, -1.1768507387844258`}, {
             0.03193918696510862, -1.2103635283472904`}}], 
            
            Line[{{-0.039681122448979596`, 
             1.6947129717237766`}, {-0.03943641529738401, 
             1.1096956876196176`}, {-0.039104259434341954`, 
             1.0266323728362046`}, {-0.03878041601255886, 
             1.6070236463190173`}}], 
            
            Line[{{0.021595473295701263`, 1.2195817420762023`}, {
             0.02170565342408807, 4.523975733796885}, {0.02170565342408807, 
             4.523975733796885}}], 
            
            Line[{{-0.045135667903525, -2.131672488431482}, \
{-0.045083064969098884`, -1.8545561652817502`}, {-0.044750909106056835`, \
-1.129807279029969}, {-0.04441875324301478, -1.0008363218623266`}, \
{-0.044086597379972725`, -1.1906589972690156`}, {-0.043797138420585614`, \
-1.9914305334674012`}}], 
            
            Line[{{-0.02357469150450877, -1.0338081943051065`}, \
{-0.02357469150450877, -1.0338081943051065`}}], 
            
            Line[{{0.016191893424037703`, -1.457409321730208}, {
             0.016428378501576038`, 2.523084192198296}, {
             0.016523066115477707`, 1.0022758509785354`}}], 
            
            Line[{{-0.03416388106966925, 
             1.3306361070775972`}, {-0.03412192148871118, 
             1.2177882577402037`}, {-0.03378976562566913, 
             1.0460091765965067`}, {-0.03365221088435373, 
             1.2837049865296026`}}], 
            
            Line[{{0.005103566546299602, -5.463182181536369}, {
             0.005549539856508198, 1.7381828483280386`}, {
             0.0058535718033751825`, 2.027996650210815}, {
             0.006157603750242166, 1.050568781933258}, {
             0.006347789115637811, -1.0061331343595816`}}], 
            
            Line[{{0.026634667024704618`, -1.010101076359158}, {
             0.026653098663943095`, -1.001801026141157}, {
             0.026708149476006613`, -1.016977759366425}}], 
            
            Line[{{0.045773423005565854`, -2.1593785753415373`}, {
             0.04630863993131899, -1.0454891684972136`}, {
             0.04661643571711295, -1.011642550807847}, {
             0.04692423150290691, -1.2066273918898018`}, {
             0.047232027288700865`, -1.9431051365577416`}, {
             0.04730017006802721, -2.3242539936017734`}}], 
            
            Line[{{-0.04730017006802721, 
             2.3242539936017734`}, {-0.047076000147351194`, 
             1.449958722208891}, {-0.04674384428430914, 
             1.0590645950396849`}, {-0.04641168842126709, 
             1.0106711268526134`}, {-0.04607953255822504, 
             1.2406402072016482`}, {-0.04577342300556581, 
             2.159378575341772}}], 
            
            Line[{{-0.02599691192266379, -1.005695629475926}, \
{-0.025959903192046045`, -1.0021687512176434`}}], 
            
            Line[{{-0.006260069817238766, 
             1.3825644928533676`}, {-0.006099224371767264, 
             7.140279911760392}}], 
            
            Line[{{-0.03671815948601663, 
             1.488528082413267}, {-0.03644701253000554, 
             1.0198526493910782`}, {-0.036114856666963485`, 
             1.2076189032386815`}, {-0.03603316326530611, 
             1.4241463055005497`}}], 
            
            Line[{{0.0033583912284399576`, -1.4687803173058853`}, {
             0.003725348175306291, 1.023761669300975}, {0.004029380122173276, 
             1.893236415472078}, {0.00433341206904026, 1.4860505245933209`}, {
             0.004333412084407722, -7.404130858583082}}], 
            
            Line[{{0.024099365355898458`, -1.0001299511100101`}, {
             0.024099365355898458`, -1.0001299511100101`}}], 
            
            Line[{{0.04379713842058562, 1.9914305334674012`}, {
             0.04415406943076128, 1.118712200845175}, {0.044461865216555235`, 
             1.0003836481012476`}, {0.04476966100234919, 
             1.1480506555243937`}, {0.04507745678814315, 
             1.8298479609321252`}, {0.045135667903525044`, 
             2.131672488431767}}], 
            
            Line[{{0.03878041601255886, -1.6070236463190173`}, {
             0.03922933685805795, -1.0003886612554482`}, {
             0.039537132643851905`, -1.2574105905712112`}, {
             0.0396811224489796, -1.6947129717238096`}}], 
            
            Line[{{-0.030931122448979588`, -1.1620109129509257`}, \
{-0.030800362858290662`, -1.0053490011969914`}, {-0.03062190785405071, \
-1.1340947098425598`}}], 
            
            Line[{{0.04793792517006802, 2.3535132944912696`}, {
             0.048463210431876694`, 1.0959823943937208`}, {
             0.04877100621767065, 1.0000783870816834`}, {0.04907880200346461, 
             1.0818362998245963`}, {0.049386597789258566`, 
             1.4213383565965152`}, {0.049681122448979584`, 
             2.548145835186459}}], 
            
            Line[{{0.010219867649981335`, -2.1841960118039916`}, {
             0.01034188911955486, 1.219938868816132}}], 
            
            Line[{{-0.019288965586234462`, 
             2.113432478055047}, {-0.019288965586234462`, 
             2.113432478055047}}], 
            
            Line[{{0.015244250685348668`, -1.0498678678675883`}, {
             0.015438889453605031`, 1.520278887222892}, {
             0.015481280863737346`, 1.0453850314965596`}}], 
            
            Line[{{0.03603316326530612, -1.4241463055005292`}, {
             0.03645917478591233, -1.026184692580808}, {
             0.03671815948601663, -1.488528082413267}}], 
            
            Line[{{0.02595990319204604, 1.0021687512176443`}, {
             0.025993439298629094`, 1.0040939502040134`}, {0.0259969119226638,
              1.0056956294759338`}}], 
            
            Line[{{-0.0267081494760066, 
             1.016977759366417}, {-0.026634667024704607`, 
             1.010101076359164}}], 
            
            Line[{{-0.007256880024737146, 
             1.7032635881263842`}, {-0.006915769965038165, \
-1.0483601160380658`}, {-0.006811080772873762, -1.8623792611494543`}}], 
            
            Line[{{0.03365221088435374, -1.283704986529588}, {
             0.03399680849956066, -1.0371687818600395`}, {
             0.03416388106966925, -1.3306361070775972`}}], 
            
            Line[{{0.02357469150450878, 1.0338081943051296`}, {
             0.02357469150450878, 1.0338081943051296`}}], 
            
            Line[{{-0.021903344671201808`, 
             1.1317623775645265`}, {-0.021903344671201808`, 
             1.1317623775645265`}}], 
            
            Line[{{-0.0019283134583198101`, -1.0393656422767104`}, \
{-0.0018219354660969085`, -2.4619676375386685`}}], 
            
            Line[{{-0.031939186965108626`, 
             1.210363528347314}, {-0.03179683044741682, 
             1.0126291476529976`}, {-0.031568877551020405`, 
             1.1768507387844258`}}], 
            
            Line[{{0.028890306122448976`, 1.0673558855365262`}, {
             0.02896190644254211, 1.0039131006778383`}, {
             0.029092887154861944`, 1.0857235333780613`}}], 
            
            Line[{{-0.018005147126102426`, 
             1.0078180688890674`}, {-0.018005147126102426`, 
             1.0078180688890674`}}], 
            
            Line[{{0.0017494927155411524`, -1.0455100857409163`}, {
             0.0017968196000098936`, 1.0075133463862977`}}], 
            
            Line[{{-0.022936936402467953`, 
             1.049132839100129}, {-0.022913445681302824`, 
             1.1093136885266521`}}], 
            
            Line[{{-0.0035570914412276443`, 
             2.5445528752739}, {-0.003267386602634352, -5.816564744782249}, \
{-0.0031528532952564796`, 1.9335490198289587`}}], 
            
            Line[{{0.016810267217854613`, -1.000777235549339}, {
             0.016810267217854613`, -1.000777235549339}}], 
            
            Line[{{-0.03301445578231292, -1.2663100056342425`}, \
{-0.032793298036542975`, -1.0001755726631563`}, {-0.032576942067149436`, \
-1.2265047087480854`}}], 
            
            Line[{{0.02734590457804743, 1.0236438399864674`}, {
             0.027458900226757368`, 1.0340693743810025`}}], 
            
            Line[{{0.03480163617171006, 1.349256379613811}, {
             0.03522799164273649, 1.0671009063590255`}, {0.03539540816326531, 
             1.4043123629610834`}}], 
            
            Line[{{0.024681122448979593`, 1.0013937299538536`}, {
             0.024681122448979593`, 1.0013937299538536`}}], 
            
            Line[{{-0.020514455782312906`, -1.3972599942308326`}, \
{-0.020514455782312906`, -1.3972599942308326`}}], 
            
            Line[{{-0.0011117380032909486`, 
             1.0002773754786995`}, {-0.0011068525656225034`, 
             7.406941689027453}}], 
            
            Line[{{0.019489010946363607`, -1.2065862104507181`}, {
             0.019489010946363607`, -1.2065862104507181`}}], 
            
            Line[{{0.008448958851833418, 1.1088521919206988`}, {
             0.008893891272045026, 1.0200887265750527`}, {0.00919792321891201,
              1.2984923543726297`}, {
             0.009285811980342768, -1.212120245936567}}], 
            
            Line[{{0.02973064225690276, -1.0977254888459496`}, {
             0.029951395490513115`, -1.0659721343258761`}, {
             0.029984152752009892`, -1.1206258761034942`}}], 
            
            Line[{{-0.009652057486841024, 
             1.0568204377558328`}, {-0.009652057486841024, 
             1.0568204377558328`}}], 
            
            Line[{{0.03062190785405071, 1.1340947098425598`}, {
             0.03093112244897959, 1.1620109129509355`}}], 
            
            Line[{{-0.014607918926393126`, -1.0096213154345381`}, \
{-0.014607918926393126`, -1.0096213154345381`}}], 
            
            Line[{{-0.017088894655825193`, -1.0015193453301199`}, \
{-0.017033622474879606`, -1.2577034010764587`}}], 
            
            Line[{{0.002509220387838353, 1.0045053596227405`}, {
             0.002509220387838353, 1.0045053596227405`}}], 
            
            Line[{{0.023024972154716078`, -1.0238887103237235`}, {
             0.023024972154716078`, -1.0238887103237235`}}], 
            
            Line[{{0.017747697232204047`, 1.1308864611979526`}, {
             0.017758005948167357`, 1.2023643896650553`}}], 
            
            Line[{{-0.02825255102040815, 
             1.056948590877528}, {-0.02809665532879818, 
             1.0427146859543195`}}], 
            
            Line[{{0.011429988662113713`, -1.000581148836737}, {
             0.011429988662113713`, -1.000581148836737}}], 
            
            Line[{{-0.01832938252054122, -1.016372723107755}, \
{-0.01832938252054122, -1.016372723107755}}], 
            
            Line[{{-0.016074565071930762`, -1.6310317481967116`}, \
{-0.01607456507190054, -7.404130858583082}}], 
            Line[{{0.019067015962832053`, 1.0142433213480548`}, {
             0.019067015962832053`, 1.0142433213480548`}}], 
            
            Line[{{-0.011175375322542718`, 
             1.001521292322918}, {-0.010886455332245033`, 
             2.3065858560735584`}}], 
            
            Line[{{-0.029092887154861944`, -1.0857235333780613`}, \
{-0.02889030612244897, -1.0673558855365317`}}], 
            
            Line[{{0.010491444213750001`, -1.1945728439834646`}, {
             0.010713142784026651`, -1.1347646678367425`}}], 
            
            Line[{{-0.018949626452899236`, -1.5202276053974382`}, \
{-0.018949626452899236`, -1.5202276053974382`}}], 
            
            Line[{{0.021045994058774064`, -1.001108487425831}, {
             0.021045994058774064`, -1.001108487425831}}], 
            
            Line[{{-0.024071366351418613`, 
             1.0092522212922825`}, {-0.024044356114538847`, 
             1.0411597447217182`}}], 
            
            Line[{{-0.004465811444178235, 
             4.199686260704038}, {-0.004194846543268461, \
-1.065580770881473}}], 
            
            Line[{{0.015768719136262033`, -1.0352543662097455`}, {
             0.015768719136262033`, -1.0352543662097455`}}], 
            
            Line[{{-0.01417387607215579, -1.0136681475028817`}, \
{-0.01383239106453459, -1.2532147548204278`}}], 
            
            Line[{{-0.0066117380181711805`, 
             1.4315779455896498`}, {-0.0066117380181711805`, 
             1.4315779455896498`}}], 
            
            Line[{{-0.016468650723467176`, -1.302686222830171}, \
{-0.016468650723467176`, -1.302686222830171}}], 
            
            Line[{{-0.021430602182331303`, -1.1456225498210395`}, \
{-0.021400980605007978`, -1.3216010493066699`}}], 
            
            Line[{{0.01840735659751805, 1.1703435191277534`}, {
             0.01840735659751805, 1.1703435191277534`}}], 
            
            Line[{{0.007981795431444075, -1.281037541368668}, {
             0.007981795431444075, -1.281037541368668}}], 
            
            Line[{{-0.027458900226757364`, -1.0340693743809948`}, \
{-0.027345904578047416`, -1.023643839986477}}], 
            
            Line[{{-0.007827865805639118, 
             1.4086522211937202`}, {-0.007827865805639118, 
             1.4086522211937202`}}], 
            
            Line[{{0.03257694206714943, 1.2265047087480976`}, {
             0.03301445578231293, 1.2663100056342567`}}], 
            
            Line[{{-0.017709138588183203`, -1.0050680924167688`}, \
{-0.01769385533338117, -1.0013936364943439`}}], 
            
            Line[{{0.002005461768811399, 1.1023909951802264`}, {
             0.002005461768811399, 1.1023909951802264`}}], 
            
            Line[{{0.02242957329982937, 1.0358560042887974`}, {
             0.02242957329982937, 1.0358560042887974`}}], 
            
            Line[{{-0.022541099773242625`, -1.099706684199619}, \
{-0.022541099773242625`, -1.099706684199619}}], 
            
            Line[{{-0.002963354655767367, 
             1.0099016909607257`}, {-0.0027530803758095924`, 
             1.5148632136614069`}}], 
            
            Line[{{0.01708803786689004, 1.002071267198551}, {
             0.01714273655464829, 1.153842726394912}}], 
            
            Line[{{-0.025322148090005228`, 
             1.0003892185815886`}, {-0.02529087854654056, 
             1.0079268260799803`}}], 
            
            Line[{{-0.005461469269726447, 
             3.207818262116256}, {-0.005461469269726447, 3.207818262116256}}], 
            
            Line[{{0.014604591836734442`, 1.0039890241501674`}, {
             0.01460649558330785, 1.0069084350839799`}}], 
            
            Line[{{0.02531887755102041, -1.0000704525555677`}, {
             0.025322148090005225`, -1.0003892185815877`}}], 
            
            Line[{{-0.02019011431761527, 
             1.0042193947526803`}, {-0.020073279311724736`, 
             1.8432521075662236`}}], 
            
            Line[{{-0.0004599200030015673, -1.2619944049847962`}, \
{-0.00045992000300091516`, -7.404130858583082}}], 
            
            Line[{{0.019726675328146058`, 1.2163360691647904`}, {
             0.019726675328146058`, 1.2163360691647904`}}], 
            
            Line[{{-0.010266211399887017`, 
             1.0443358626439423`}, {-0.010266211399887017`, 
             1.0443358626439423`}}], 
            
            Line[{{0.0008455995498670019, 7.406941689027453}, {
             0.0011117376135003363`, -1.0002545229179203`}}]}, 
           "Charting`Private`Tag#1"], {}}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|"PlotRange" -> {{
             Rational[-1, 2], 
             Rational[1, 2]}, {-7.404130858583082, 7.406941689027453}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>]]& )[<|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|"PlotRange" -> {{
            Rational[-1, 2], 
            Rational[1, 2]}, {-7.404130858583082, 7.406941689027453}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
         "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>],
     ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
      4.503599627370496*^15, -4.503599627370496*^15}}]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJw9WGk4ltvffQwRIvMUJ6SUNIkGqSSkHClKUdHAKWWKDIdkaFJRoiiVBtKA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          "]], 
         Line[CompressedData["
1:eJw9lnk01d/Xx28h85i4MoQQZUpz4RwhkVCRopIhRKlvlKFJAyolmVJJSYpU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          "]], 
         Line[CompressedData["
1:eJw9Vmk0lY0WPjjGhE83ZMoQqbgfKWRIg0KRTGlAg1JJMmRKIpUGJYpTdESl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          "]], 
         Line[CompressedData["
1:eJw9lGlUlHUYxUc2WQYRSCFWNRhK8YCKSEg8f4mljiKbsaXiYJCCIqEsaiwC
4XBc0QYMhkVZFEkFBwnKeBB4l/G4BJmAGAkYxuL0DsswIFL0pQ/33HM/3fvh
d+7KyEOBUWo8Hm/3gv7zq21LBvhCGU4tSg68U2ZJVtFFb15/LsNkeXTHxCsz
cnrIzUkjQIbEf2CZ8tlyotTqO2DmLcOrr/UHvfuMyR679ErHzTJsfBy64/hF
Q3LfZ0Wft6MM9bbLy8Q5BsRp373lu2xlmBc/Y7Unn09KRJF+h81k+OHBCEve
B7pEp1pdlGsgQ6FPQ32itTY5IqtoKdWQ4Vvd4udP92qRvmGvmTszLN6Uatza
OKRBPtF9te6BnMW4A31TDYXq5PZqUczAIIsxouUmYSlqxLpjT9OaHhZtmxO0
z329iJxO/lA78RGLgefT3TMlPKKyNAppbmOxgFoSYHHtH4hqH6lc3MSi8806
w9swD50xbZP+N1mM1Ewo3Do7B+6Gko8Ly1l8HnFDvvfXN1Dzw5ELg5dYPIx+
Vi7MLJju9u23P8ui+PXhI2WdM5CtIXBMymKxqra1dHxcBYrr82mYwmL6RpOM
EVsV7A7oeqgdx6K2oPDvgv3TcH/6lkXgXhYPPRQE+d9VwqYSUWxRKIuEZ7a0
3EIJFZ7CH1/6sjgs1yX+uVOQmmcUmuzCok+0zfyJrEkY2TRa1bKWRT2x0bSb
wSQE97VN6bzHYm/7iqk75RPQli3xDDJl8ZqiwdyHTIDjmsSLEn0Wj9X2Dux6
OQ6SDt+BP9VYrJbyqlLOjYNOimCdg4pBN/53Ypst4zDQ3vXo3gCDCRWrfq5o
UIBfbK2lXjeDrZJzgsdHFXDXMPfAjocMynfm/eLkoYD3G4U/FbcyWPTiBBYY
KEC821X31Q8MhtxnSu71c6CmaRzmeIPBxpTz5lmNHMTVjF49eoXBvs2PwqQX
OegNaFe2FjBo/GJbhsNhDj5RSbz4Zxi0OLMt7FkwB3dKEr/9LJNB2alLmhJ3
DlZ5bR8sSWYw71Bmi3A1B2dHBev/OsCg/fRZqaUZB2/y/slYF8lgec5cN63P
wT6X7sfHQhi0aSwZC9Xk4ElfrVX7NgYvWT6LecLjYMs3uQf1PRjcWd9T7L6Q
b66JvBu8iUHntC+bLqtzYN7pqldmz6CplkBLX48DUYpx+PBKBm2jPS3FyzmY
tBq7tt6EwaoNa513CDgQUu3Tx/kL+6sFohhXDh7FFntTixhUZX7ROh/IgatR
knjJNI0zabXF7vEcXG3c/jJkjMa3ZuJTERc4eCfCbsPlfhorlw6fLG3i4IQm
L3PkKY0T2rSR9xAH8pruXzY8oLFFPTa80lQB4YF11qn3aIx3EJaYByiAUeXG
0Q00Zi0+2/XOeQU4lUb+bPA9jdmbuqT8pwoo89rMD7tML/DfMX3+vXHQHzP+
/Eo+jYEj8l2eR8fh2IWx6tFTNNboWBsOdI3DkAulcjpB40fxKcNbFngK+qPY
Jy2JxubQ15Jd0glo+SYpn4mlMSIrxzZk/STY2/v9uVRIo+XiAmlG8yR812nn
FB5MY32XS2l02BRoHeVllW+lsXGvaLJXQwkJ1j0dY4TG0rLrcbptSviDqlvh
7Ewj72261sn8afg6aMbTxZ7GKxn3TWu/UoFpP9nvuopGV/xd3TxqBurjRGfc
TGm0OynMij8yC/5zj+vcl9C42GbI3LbiDYzlmjwlGjTe7oneIp2ZA5FJxKzH
LIXPosiVkePzYFNZZeXFUSjxHF56610eaVkv9/AZorC6qO5a+rJFZGfLxi8/
fU6h3bvZqekuakTlm3pqayeFti8KpfzT6uTb3vZbviyF54bNJhgLTeK4n//E
r5lCcZo0Z+WcFnmgDFIF1C/0jXpb9XvokH3ZRRY7rlNY+zAwMWkZn2gYDZLg
Mgp9vepG7tYYkLLS1VGh+RQ6HBxRTjgYEbe1CbnhpylsqtY16oleRrp/bLqx
M5PC33xzckX6ZmSFY8HEsVTq/z//F3HGEK8=
          "]], 
         Line[CompressedData["
1:eJw1VGlQU3ccDMoREW2iUdAGD4rKoRSFgkVskZQiSAYVVFRGkY5cTkELUokU
xQBCAaUBqUNVZCiCQD25pIV9vv8LFME71bQOSqFcEvXlEMHE2PRDP+zs7MzO
zv5+H3ZxdNLmvVM4HE6gCf9xkFW8um2FHLfqH0oUZ+2prY1rdUlOcmSInaOa
G+ZRGv9su28WyKEVyALuWc2hTtzr8U0RyPF4bGfG4dt8ymWXYE+qtRzh54Wb
OvtnUh1jO7MPceRoOKEeWRg8nYpOq7woGWdw1T8/bGUqlzJajt1OVzHQTB4O
6nazpMpKVmky+hk89u6bCAk1p7wcJHMzlQy8Yzg299unUA8u3/SR3mFgadHZ
pdhnRiWunbY7m2EQtf39i7ogDmXdvVF6vJUBkf74Uf9ZIy5EnK7Ou8Igedh5
eOaoAaKhZ935FxjY5tYMDsfr0Ze8jC08w2DIa3G60vYt0s2SBEUyBpMFARK+
agJ2J5tWy3IZhDeHNc7/+w0ahMbIkgwGHrGLUqSacWysDcgsTWGgDdz0YY1w
HCrvwqrTCQzu/lMsz4l8jVy5oqssikFTxUjWucs6OIYJX57ZyqDgt8KoR7N1
oPq+mlUeYspf4mORcFyLyMQ6rwp/BoWUpPEvrhYTes2OytUMZGmL9g+UalCS
53Okyo2B67c2+UnuGrjbHqusdjTd++q6R7FCjZ6fuzovzmfwsO2TfdnH1Ihb
xVfV8Ux6ndjtp0/VMKcieJcsTf8wUxSIJlmcF5/3vGIgGFiqOmZ+k4Xvk+GI
axqCqkL5/kNFLJRxH3/XMEIw1us5NySWRcp4akXTU4LPnNrf+Qaw4GW1y1sU
BDMcOgLtXFjU8y2ft94ioNqbb92Yw2J9uXhmG0VwxGb70elcFoPLT61CE0FW
l3SNhRkLl4yqlyN1BH55eqGOwyLxbmPtrAqCmpvOSUqT//qijhjfUoLwxF35
fXYsJg48cojJJ1gTcEm6caWpLxl6evIoge1QsCBrM4tMwZuyGwcJplpbi9Tp
LDr2Wm0bSCCw9+fdc73KwrrZdvaMKILMiMjq0VcsQrlOd722EPyZYCzm+qhR
sn11flQwgbOlvuBUkRrK2vWB339OcKPBMPuRTg17Q8TUBk8CUYvbhvA4DaLF
8eh1JpB9EFDzUqXBhXNph60WErjWX89VZWkx9irPe6WAYJ6LXeo8Dx3c15Vp
d0wj4Ll9+evoWx0OymovZxlplFZuW17f9xqtA637LmlpuLgLjXdGx2H07F6m
HKGxP3R5i5/9BEQ5TwbMntLovF/1g146idzHY+WuD2lwU7flPHDWo8fJsHPL
7zTKzXvDqxe8A19iY3ekjYYotrNLfOg9tnYLFTXXaBS8a0ntcTGjyoQrih5U
0xhsDttNqadQz75eG2I4Q8MzfXDcwcOCcoSYu1RGYwP/CyZyCZeK4+1iQo/T
6A/jN3U72lC/7Ek8mpZOoyk03u/5Cx6luZbhW3mAhkRpmFW1ZQ7lZX5yoieG
RrKoP6dXL6SS/4gtjjbp//flX1Vzfuk=
          "]], 
         Line[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAAvbpu9oUrwr/1AXdStaAdQNLr8GDH
JcK/s5on1s4BGEAXPQEd8RrCvzZQZa//ZBJAXI4R2RoQwr+8FmHcXdsNQKDf
IZVEBcK/5GwGtHkpCUDlMDJRbvrBvyhD+ZXpxwVAKoJCDZjvwb87hGlsujwD
QG7TUsnB5MG/H5SOcqdCAUCzJGOF69nBv7zh7/TgXv8/+HVzQRXPwb9Srl/7
t8/8PzzHg/0+xMG/AQujhy6z+j+BGJS5aLnBv6LLYr637/g/xmmkdZKuwb89
uTfH/HL3Pwu7tDG8o8G/B6oEYYEv9j9QDMXt5ZjBvzdvdUknG/U/lF3VqQ+O
wb87mMsmNi70P9mu5WU5g8G/IJ7qNLVi8z8eAPYhY3jBv8xSHQz5s/I/YlEG
3oxtwb+Js9uQUx7yP6eiFpq2YsG/lJ1C39qe8T/s8yZW4FfBvxG1Ww1AM/E/
MEU3EgpNwb8yPoYZsdnwP3WWR84zQsG/OunM6sKQ8D+651eKXTfBvwqGvkxh
V/A//jhoRocswb/O4Ll9wyzwP0OKeAKxIcG/XOgqXmQQ8D+I24i+2hbBvwSd
SqX9AfA/zCyZegQMwb9mA8jBhQHwPxF+qTYuAcG/ta+QQzAP8D+GtijIEPfA
v8ApoJMXKfA/+u6nWfPswL+RIf5ASFDwP24nJ+vV4sC/mmXJwpKF8D/iX6Z8
uNjAv+vGwVUMyvA/VpglDpvOwL99xmqzGx/xP8rQpJ99xMC/uDtHZoqG8T8+
CSQxYLrAv7u7O1ucAvI/skGjwkKwwL+ClgUWMJbyPyZ6IlQlpsC/0NBrH+tE
8z+asqHlB5zAv3xgByV4E/Q/Dusgd+qRwL/gPONO3wf1P4IjoAjNh8C/AYna
ZQYq9j/2Wx+ar33Avzn/BitvhPc/apSeK5JzwL/abhLuWSX5P97MHb10acC/
udbapY8g+z9SBZ1OV1/Avyzs2udPkv0/xj0c4DlVwL8FOk+YKlIAQDp2m3Ec
S8C/GkzKkXNLAkCurhoD/0DAv72vZroy6QRAIueZlOE2wL86GCitHIYIQJYf
GSbELMC/5kE/a+7ODUAKWJi3piLAv/p4ktoTHRNAfpAXSYkYwL9Gx+k89dMa
QDByrGADF8C/9QF3UrWgHUApObJa
          "]], 
         Line[CompressedData["
1:eJw9klkwlAEAx5cdV4xrnTtui4pxPSA1ShGjHGOsKZlhDLsh6TC5hzxIOijK
fQwapVXMGEez3/f/csQwq7GEDDM6aBC+3WXXER0vPfzm9/h7+VnHpYYnKDMY
DMe//PPQhO2nsY/AqGAya6rOnCrkOvj+HAM261f1dvZNqOsf7OI7e4AKtQDN
HhV9KtKTc+9OM8BXsHsDT2tRPi9t2k6WAPlsFZYgQI1yMLUWMbIBm+mU3RNz
TEq32JIe4gHsa8mtxleUqJ09c9aDcCAoJr2Yu3GIxWQzjzAfYCLmfa7Xr32M
zLMvGx4HOq1FRyabd9ERbJozZwhEFe6WbBMKVJLGDQ1KwLpowpzhKke+i1F/
/DqJ3qpsrv+PLVxtNFg69pmEvF3ZOWJahjA9lvrmIAmume96sEwKrwI9x64O
EsNny71nPKSwkumEZNaSyDCa7ePVSKARr33Tp4hEaJCN27iZBNIprXJmGonA
qYLalR4ac/6aPSMxf3u/Ozr4STT6uzXmHl0g8dZOotfiTqPNQf0g3JPEZlRq
6mMdGk8rVa1MbEmUGGWU1TBoZGmonFvQJkFOlA2QKjTispi8pj0CbrcNRpIs
aQStKd3nLxNoXckWV4fQcI9mCJzEBDRnOPzv5TTYosNxCUFARyR+Xr5FQ9nn
QNL9ikDCGCdj/oYEa2/2DXKeEXDIMY9kaUsxZbnn6XuXQNxoJcdULIWwdCdK
NYXAUV6JaHVQhhYlRe7YJQJDodtxhZItPLy13VjqR6Aoxz4tgi9H2jfZANeV
QFdiMDvz1A6iI6TLbDMC+n1VuqIne/AbojUW1QiMKjybtKsP4OSx6fRCJsT5
msQzy5MMiuecl9e3IMSSIDmWt8GkGux1xKJhIVjvWoF2dWrWooHztVMIk6wv
8uxYXUrf2CVdXiOEwju+rvm1CXWx3iK/t0L4/88/w2d8pg==
          "]], 
         Line[CompressedData["
1:eJwBwQE+/iFib1JlAgAAABsAAAACAAAAt7abnTd6ub/KrNN61J0dwFz3/WXm
cLm/DrUh7ZCBFMCW7424+lq5vxA4C9vdzQrAz+cdCw9Fub8D/kFyPgsEwAjg
rV0jL7m/UFW6xJMiAMBC2D2wNxm5v2wL3ddAPvu/e9DNAkwDub/r5+RtzMv3
v7TIXVVg7bi/qUWwQ0RW9b/uwO2ndNe4vz4wkCpHi/O/J7l9+ojBuL9QWT77
sTryv2CxDU2dq7i/3TmaBhJH8b+aqZ2fsZW4v38uONkKnvC/06Et8sV/uL/t
LMhbZDTwvwyavUTaabi/GzJq9/UD8L9Gkk2X7lO4v/pSZwqjCvC/f4rd6QI+
uL895J+zEUrwv7iCbTwXKLi/7zf91AbI8L/yev2OKxK4v7fGnDyJj/G/K3ON
4T/8t7+2Tz5fObPyv2RrHTRU5re/XY0jPd1R9L+eY62GaNC3v1OEnAN1n/a/
11s92Xy6t79n80P5ufj5vxBUzSuRpLe/KIrn/9QR/79KTF1+pY63v8hp31PL
vAPAg0Tt0Ll4t79uG+RP7bcLwMJI7E80Y7e/x9wegEmyF8Aq33QJ6l23v8qs
03rUnR3Axpf1Cg==
          "]], 
         Line[{{-0.07110969387755102, -5.103243226248486}, \
{-0.07099718267210106, -3.786833385336398}, {-0.070668790647986, \
-2.1956783911109836`}, {-0.07036243252073396, -1.6176535172369544`}, \
{-0.07005607439348194, -1.3176369842365994`}, {-0.0697497162662299, \
-1.1471964554538556`}, {-0.06944335813897787, -1.051220772493595}, \
{-0.06913700001172583, -1.00641714175604}, {-0.0688306418844738, \
-1.0039971590545087`}, {-0.06852428375722176, -1.0446163975803915`}, \
{-0.06821792562996973, -1.139003076478017}, {-0.06791156750271769, \
-1.315199690090611}, {-0.06760520937546566, -1.6433044825371892`}, \
{-0.06729885124821362, -2.3345333289728236`}, {-0.06699249312096159, \
-4.401569390228817}, {-0.06698554421768707, -4.49536183783641}}], 
         Line[{{-0.05231270139634801, 
          2.80998988815163}, {-0.05198094488561192, 
          1.4715925690432712`}, {-0.05167458675835988, 
          1.11899210125038}, {-0.05136822863110785, 
          1.0053045850152162`}, {-0.051061870503855813`, 
          1.0359343384730653`}, {-0.05072971464081376, 
          1.2727811718130408`}, {-0.05039755877777171, 
          2.1026066946561244`}, {-0.0503188775510204, 2.5790756686866603`}}], 
         
         Line[{{-0.029984152752009892`, 
          1.1206258761034942`}, {-0.02980389526916451, 
          1.0138430233217743`}, {-0.02973064225690276, 1.0977254888459496`}}], 
         Line[{{-0.009885204081632652, 
          2.060572751003258}, {-0.00976541824092948, -1.04916468013099}}], 
         Line[{{0.009582112547940518, 1.1033631247583113`}, {
          0.009582112547940518, 1.1033631247583113`}}], 
         Line[{{0.050318877551020394`, -2.5790756686866603`}, {
          0.050643578668224415`, -1.3960876796256034`}, {
          0.05097717218980839, -1.0710893996539441`}, {
          0.05131076571139237, -1.0005879428178173`}, {
          0.05164435923297635, -1.100037134002879}, {
          0.051977952754560325`, -1.46609463073246}, {
          0.052311546276144295`, -2.8002409360164315`}, {
          0.05231270139634801, -2.80998988815163}}], 
         Line[{{0.07174744897959183, -5.148419904713501}, {
          0.07198747403028682, -2.986180388805129}, {
          0.07231497753255878, -1.947883378332608}, {
          0.07264248103483073, -1.4912688635485754`}, {
          0.07296998453710268, -1.2483318064818185`}, {
          0.07329748803937464, -1.1102107077186005`}, {
          0.07362499154164659, -1.034420147461659}, {
          0.07395249504391854, -1.0024357323192412`}, {
          0.0742799985461905, -1.0069521300837392`}, {
          0.07460750204846245, -1.0478050755787844`}, {
          0.0749350055507344, -1.1317139277371286`}, {
          0.07526250905300635, -1.275497426283205}, {
          0.07559001255527831, -1.5161428884865624`}, {
          0.07591751605755026, -1.9419239549696603`}, {
          0.07624501955982221, -2.8147675388862563`}, {
          0.07657252306209417, -5.379702966358355}, {
          0.07660419937205651, -5.910570866517362}}], 
         Line[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAZSTkF5Fdtz/1AXdStaAdQKbCvp8a
YLc/InpwDs1zGkBOpZM4kXW3P/T9ocZkfA1A9odo0QeLtz9a9Zefq7IEQJ5q
PWp+oLc/wrTSVbAnAEBFTRID9bW3P0H0m5862fo/jmEJ8fnJtz+n+bpaf3n3
P9h1AN/+3bc/i0sC8I8Z9T8hivfMA/K3P6ylUND/YvM/ap7uuggGuD8eBWsn
BiTyP7Oy5agNGrg/mvi3m1g+8T/8xtyWEi64PywugT3vnvA/RdvThBdCuD8d
LFeNwjnwP47vynIcVrg/OsSQUH0H8D/XA8JgIWq4P/4jqLA6BPA/IBi5TiZ+
uD+09gEl5C7wP2ossDwrkrg/tT0dvP2I8D+zQKcqMKa4P7fMIffQFvE//FSe
GDW6uD8YlA5IAODxP0ZplQY6zrg/ax+3R6vw8j+PfYz0PuK4P0nHVYh8W/Q/
2JGD4kP2uD/9oHIcWj32PyGmetBICrk/IhiD80bE+D9qunG+TR65P11NMcgM
Pfw/s85orFIyuT/9BpH+bZgAQPziX5pXRrk/kLgKWtxWBEBF91aIXFq5Pzig
jE5EjApAjgtOdmFuuT97TDe9vlETQMQ3KQbRerk/9QF3UrWgHUCeueB7
          "]], 
         Line[CompressedData["
1:eJwBkQJu/SFib1JlAgAAACgAAAACAAAAAZ+IEaGavD/1AXdStaAdQEZL4JIr
o7w/vvGaNisgFUCPX9eAMLe8P0GMtNMTUw5Ahuw8P+bMvD+F5YCnw10HQH55
ov2b4rw/IBnGCo4hA0B2Bgi8Ufi8P97MwhlWTQBAbpNtegcOvT9tpDee4Jb8
P2Yg0zi9I70/2GZ2e52e+T9erTj3cjm9P75fKkyGW/c/VjqetShPvT9GOGSM
R5n1P07HA3TeZL0/qw49qmg29D9GVGkylHq9PwYQaKOWHPM/PuHO8EmQvT/Q
6PH/cDzyPzZuNK//pb0/Rqizeh6L8T8u+5lttbu9P7/sKMTXAPE/Joj/K2vR
vT+5cpVn/pfwPx4VZeog570/Ly4lRYdM8D8Wosqo1vy9P5tfpBiZG/A/Di8w
Z4wSvj/88qzdTAPwPwa8lSVCKL4/RUmQXYUC8D/+SPvj9z2+PxlY+Z7XGPA/
9tVgoq1Tvj8fHqO6gEbwP+5ixmBjab4/kVvAjGeM8D/m7ysfGX++P/zzfVIq
7PA/3nyR3c6Uvj91adDYOWjxP9YJ95uEqr4/u2QazgUE8j/OllxaOsC+P+H/
In9AxPI/xiPCGPDVvj+9cjWCRK/zP76wJ9el674/gM+r2q3N9D+2PY2VWwG/
P3hMO2hEK/Y/rsryUxEXvz/nBJbya9j3P6ZXWBLHLL8/FcMcWXns+T+e5L3Q
fEK/PyPjVySkifw/lnEjjzJYvz9F9xCCCeT/P47+iE3obb8/cjwNpngnAkCG
i+4LnoO/P3FQ0A39KwVAfhhUylOZvz+lFwr6X4IJQHaluYgJr78/VPA3Pu0c
EEBuMh9Hv8S/PzYjgGSl9xVAXkwxK93Rvz/1AXdStaAdQPBAOjs=
          "]], 
         Line[CompressedData["
1:eJwBYQOe/CFib1JlAgAAADUAAAACAAAANVJmyCAXwD/KrNN61J0dwKN5jf+l
GMA/OlmBDSC1GsAfQMDegCPAP119WdBeqhLAmwbzvVsuwD9GLJcmNtIMwBfN
JZ02OcA/219ihieTB8CTk1h8EUTAP2v50KgECATAD1qLW+xOwD+bR63UGn0B
wIsgvjrHWcA/rurqxFEr/78H5/AZomTAP8k6xMr2Ofy/g60j+XxvwD+/QnfR
2uX5v/9zVthXesA/uSPLy5QF+L97Oom3MoXAP6fuiDhLffa/9wC8lg2QwD8+
RR+BmTn1v3PH7nXomsA/qqR68pos9L/vjSFVw6XAP2REwmkfTPO/a1RUNJ6w
wD8RvlqriZDyv+cahxN5u8A/ea7ZqxL08b9j4bnyU8bAPxxjPyxLcvG/36fs
0S7RwD/bf1MWxQfxv1tuH7EJ3MA/XDih8tax8L/XNFKQ5ObAP4dxhPhwbvC/
U/uEb7/xwD/QI+tL/jvwv8/Bt06a/MA/IBnF4E4Z8L9LiOotdQfBPzNY5K6H
BfC/x04dDVASwT/2IT2pFwDwvxQu4RZyHME/S45sK68H8L9gDaUglCbBP+Kz
H0xyG/C/rexoKrYwwT8Xl1DEgDvwv/rLLDTYOsE/UDTvKClo8L9Gq/A9+kTB
P03BkTXrofC/k4q0RxxPwT/bmHvxe+nwv+BpeFE+WcE/Sicn9Ms/8b8sSTxb
YGPBP6JN1zcQpvG/eCgAZYJtwT81fMsezh3yv8UHxG6kd8E/QYDxmeuo8r8S
54d4xoHBP9X4hsnESfO/XsZLguiLwT+r8IcKSQP0v6qlD4wKlsE/1GEzSyLZ
9L/3hNOVLKDBP7ow8uPqz/W/RGSXn06qwT9eQbdfeO32v5BDW6lwtME/2tLv
IUU5+L/cIh+zkr7BP0PnC6oIvfm/KQLjvLTIwT9T4uonmIX7v3bhpsbW0sE/
CJXUsjqk/b/CwGrQ+NzBP4BTlHZeGADAD6Au2hrnwT9VCr9FZ6YBwFx/8uM8
8cE/txnA89mUA8CoXrbtXvvBP//2MZo1CQbA9T1694AFwj8eSaEyeD8JwEId
PgGjD8I/sn+Mu++dDcCO/AELxRnCP89YZR498RHA29vFFOcjwj+43+bl0swW
wEUVuNEDLMI/yqzTetSdHcBBKsGL
          "]], 
         Line[CompressedData["
1:eJw9lGtUk3UAh9lwMBFvXLzkJddBnBc09ShO0t8bJMSAElBAp4KoSDiWwMAL
4pQjIYlMRcsyBGmI7YQOA0QM0Pf9zxQRjKuQCnJLub6DbRAXyb704TnPx+fb
Iwj+2mcf18TExP09/7mhXFVrvp+GgXPIJz9jHjVgXLCtNozG1ErVQT/lbIqq
awselNPoTXvmFlFqTSXn35DOVtAIe7mtJ0owjWq4KI1xSqLxdnTccG/rJMpe
/vGJnak0UnqWSyK15lSkrz5JkUbDTbPnUKANjypdVZh6LZtGlveTGnqYS1la
HUtjcmkE5GmL1Z4cKkCH7PZ7NAa3JGRt/2scWc9Mc80f0kg/clrieGkM/bf+
KFr8jEbZPOvUGb+OYKPyDPFopBHsmn82y3IYZ2RfVoS30fCIE7zMuDGE517W
z5W9NPzrPZrcogdh51D/OneIxqX7yRe3hRlx0PJKVzWXgVKRHxBy0oDirl0G
gyWDuq2475+vh8WTj8ZnzmSw70yTfg5XDz91B3+9gMG1xr1doXsHkJmkttqx
lEGxMOEfZUM/+kJlc4+vYbAwKLtlR2A/Pvl8lX0GGLS+cJk2NqDD6UXGFbQ7
A7taq/zuSzrUmBWJ2nwZNOSUuL9x0UHQEeditosBFfut2+tRFjLtp17CUAaJ
r+5uNZSyKFLx/MWRDKKt3Pz2J7MwP/U4SHqMwYHmgvYfdrPYsudsWMo3DKwH
O8YswCLD2VuuOcfgThTvxGY7Fj0C2+NVPzLIu1Vx2HY6i3Wx1yIeqBiMKJe0
OPNYxNc47NPcZBDlsC7T0YRFuUNRQHohA61ZZWUNh8WMRFfPFJrBwyNetyZa
sAhqrkJcOYPzd145Vs9ioRYFrpbWve/xwpuclrPQX+iylzQz0HjkqCViFhu7
D30g7mSw4MO1JwPCWZzeNGGKSM+AI7B+FPI9i6qr5zjCdwzuBbW6lT1iMXdo
rmEGn0DQHBNSz9EhxPuXNzwrgqNR60v1zjpo1Gte6OcQdKaULU5L1mHYlK5s
XUjAC+W5BDfp8NnOL5iqFQSzysWpfU79UBY0FjwQEUxu18qn/NyPxqn71RoX
gt3L/f5W2w7A7quBtHQvAkNv99mGiwOQ0YrzKf4EVxOC7ZoEehTOsUyI202w
xv1tnahED2705cPSAwS6aB9+zgEDPCvspJJoAueIEtfNy4z4blFuoFhBIAss
iM7kDqL5xAZfURLB6AbPK5m6QSxpfOwqTCWYz8nzZUeHIF/tt35mGsHTWPen
RuEwSpJbHMyyCVojlAr72BHwO2QCg4ag9op/vcvwKHwwYtNWRFAtyXGtufkO
P11O5FcTgvCViUtfeJtQHTrr0QcVBMZy8fipKA610iOjT/Oc4PZvptdva7nU
MdWy1vQWgsq7kX09WyZQD8cK61K6CVKOTneOX2VGTfPfVBZnJHDMk6tGYvjU
ds2fxVITLe4KQq7vdZ1EqSbuypVYaNHe2ZvYWj+F6g3uVIlttJBPcCoW0tOp
db/HXBbN1yJp8nClZ78NFW9rmiwUanGVe6HDJnk2pZDx1z5y0P7/n38BOlFN
OQ==
          "]], 
         Line[CompressedData["
1:eJw9lGs8lAkYxce4RQxJRiQRsbFJGzWSp4ukmnaHimoql25SYqOyZlPUoiRR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          "]], 
         Line[CompressedData["
1:eJw9lmk0lYsXxs+RWSGlotIsma6UjHle0kghJ4lKRKlEInQpmtwSpaiEVKRO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          "]], 
         Line[CompressedData["
1:eJw9Vmk0lW0XPmRWJAcpUYrEG/pCUWxjSanOCRUS9VLGvEWiFJKhpFGdJqGE
UmggQ+67oiTqmYTmVDrKq+c4x0w+35/vx157XWuvde3h2muvPWfbLn6gNIfD
eThh//MVZ0pfNvxFQGMxHcdcmYUNEsRFi8wI+F1JmPOUdHCvVFK5qwUBNlqv
lMN8tTE6PPXpVmsCAm29P5QaaeEM2auv99oR8J/WZA9HngbenLrw/XEnAvos
LAOcHqtjQ8Ua4XVXArbNW9tTEjwN9z43DclzJ+B1qmLAT2c1XJuS++sqn4BZ
0fWnSaep+KgLN/zKRgJ0Y5sWX8Qq2EsmteeiLwEjKvEtC0ymYP2nQ7sEAQQE
L3EtK0fKuCcxTJQVRMBbywH/2fuUcJX9p91nQgng3TiaEbxOER8Z50lORhJQ
9dwnKMZBAa+vrYvOjCagzYXO+uImj3XilwwciyPAMjfnS/NOOSxcdnNf+qGJ
/PH3AxiBLL4/rDOckkxAnPHfQ11tMjih8sT+5HQCvnhZJa6bL4PX7JMeS8wk
QKnINS45aRL+1vdj/ICAgPr81GNe3tK49L53YtwVAhLiQuPfMFL4wJ5m6X15
BAzWbp7yaaMUdv2PfXJ0AQFJo33bbndwMFd0V3ZPMQGSDVzrrCgO/lxikBpZ
RoDJBc2ysckcXBwhUIgoJ2DjCY+Nj7zGkVN3vHIwJqBslzn2Z8eQyi02I6ie
gIOl40HXV4+ht8HbVf5uJEBxzpvM8yWjaPcPV7WtDAEpXabxs06MILsb1ad9
2wkgZdWKLiuOIKVAU673RwLWBZl15RwdRnkd6lqeQgK8VQSVmdlDKCI3RcD/
lwCZdznNleZDyMZ/SHt9LwEBO8/N/fV8EFEfPuqsHiXgqrEnXiwziLIv87Jd
pUgIq4hwfVo4gEJ86vRWyJET/DExrrwBJNVepO8wlYSvvuXxm2/3o6bzOtft
NEjY2RegmeTfjwReJwyWzyDBsPW1QbtmPzJnooyWzCNBekHHhciMPuT/GkwX
LiVh2OipQ/B5Cfor826Jse1EvJNYq+4vQYNrDBYZOZKgu2O057uxBJ1oVLKY
u4YE55as9BvPxMg7Pf7BbB4JmPfwx87zYmToylrpepGQ0bU2dDRYjGrrW6y1
/UkwuJ3g4M4Vo6PJrtWagSR0tN4MFf7qRV5O1cu5ISQEmji6TK3vRT04B1Sj
SCitPNT5cn8vmlUT6iKbNsFvWe+VOiRCXO3h4YjjJMyRGjuY3y5Ck/emlbad
JsHmc0SJfrUIjZrlzyy+QoIWJCgqJ4mQJGMxqXGNBD+jv938d4jQr67HKYcK
SbDsNLotdBeht9c+ivj3SJBZFrcnXFeEKE54Qc1DEoT4S/gmBRF6sWXE17CW
hPKKwsINYhY91JreMNRAQm56ndaWJhaVRt2I3/6KhPx3MuFbqlhUQFosbqZJ
cJN3suYXsejcMV52zkcSPJcLD0odZVGm8NMGpW8k2F7w6yndz6IjLhGKUV0k
KE0VPLSLYNGBvNHaDz0kFArcp98IYFHU+NGolRISuov8Mjs8WTRxQ4zLhkhY
1Hf24283Fm2vLPg0Y5yEq8LcyY32LPLWtMpKlqFgnYS3OXwJi/h76tx6FCm4
0CmCN6YsciP4nE2qFCyQ+bpHaj6LHBZ+efCYS0H0C++Pv/RYtPTorlCTGRQM
Hll9+bQ2i8x/jM3O0qPA3W7PaK86i4ycM978mUeBblxmvJIqi/RyZ2TsNKbg
Uktx0xslFmn+KXSgzCjw3JL/1FOeRSo+SwaWWVIg21m444gMi+Qe1hfn21Bw
upL9sV2aRWNcj22q9hSYaKVd/s1hkeSfDq1YFwq6Dcxk50/g7leRzR1uFMho
ezUoTOBvJuNJa9ZTwA0wu3tmAr9LO7603JOCm19a7z2TYhH1fWaPng8FIpuz
HTmTWNToePNauj8Fmuv0Y+bIsejJ1aWbxYEUmDroNq9UZFHl6DOVLaEU6NnH
bVOfMqHnZs+6Z5EUPDis0HpYjUWF5V9jzfdSQEg0uwWaLMpR3212cT8Fhso6
yXwdFgkiOd8nJVKw6kBUXqk+i042Z14MT6GgdMei0HsLWJRqPGt96zEKwqr7
9X0Wsehg6i1Zh1MUbL/cZVpozaK936yrb56joOzWHe4lRxZFODREci9TIFDb
F2exhkVB2V6GB3MpyHCeOz/ai0V+I9/e/bhBAf9UkLTfxH54btpzildMwdIY
FQ02jEXO006OzqugoFVryi1uCouW79K9m1kzoef1KGHRGRYtbireMfiYglPM
WurfXBbpp7ygXjZRoNEQcDUNs2jG141plhQFKyQjXl8JFqnZd9pebaUge6Zz
oOQLizjD0kW7Oyi4+K2vyVFOhPy/tosP/aBALvNJoNV0EcJNpXbHuyf0xt9C
SGMRSrjqxxT0U2C39+wqeb4IfU6z1HswQoEDsrUrCBIh+92TQ55waNBvCmsd
3C9C485V4++VaBiYdv5uTaEI+ZmecvupSkOGV4i5JRahWq2dWQNcGjSiOc2h
bSJ08KeGyTQ9Gq6pLsuao9yL/pz4x2vlYhoq8j2idOJ6kV+sa67HUhpu2tl3
ic73otptet0BtjR8tvhw7kZ5Lzpo2Zx4YCUNnRKj0cf9vWjsrdHtMh8a1lp+
+OmbJEa+deMDtf40tMrQpc8KxKjm9hvHpkAa+rXEQ3avxOhAQnJb5y4ahCEb
5u7TlaBRg8+TdJJpmHlf+tivJgnyVa1YuyCdhrlqHO0bIxJUM3j8glUmDctj
hl/fNelDB14uM+MJaIj2NjzRfaIPjUSe904ppuHolsqkuSH9yNs7Iv9MGQ21
71WT71zvR1VOLmxOOQ3q1UXd/37uR3Ga4iPVmIZVvkTic78BNFy9toxlaLht
rbT86T+DyDvfYHSsnYY/LVVujdWDqCpzdIXyJxpiHLQspisModiAm+8Numiw
D7TX6iwYQm1uifMX99BAb1hjJBgZQkstNu22F9NgOE15Tx9vGA3KySn4jNHw
MSWiylB+BG1i3/N3SjPAuX44zzpoBD1sv3clWp6BVc8cP0U3jKB9xQGLT6ox
kJMeK/hzbhQN8B751RswcCpfR/en/x+U1F7ywc6EgYrQvff3C/8glYA834fm
DDQP/LM7NnocGUamet9axkCbr/uFA+s5+O5AbPs8BwZOVrgnaeRwsO2hsE3Z
KxjwaUoVc8Uc7JHJ8zrFY6BqMCN/znUp/FnDuUVpIwPtf4U1FEhL49ArVh7J
vgyYDrTapwZK46TimfyYHQyovXvy9LD1JKxioUKyYQwsGxFeWX1rEr5QzVkf
spuBuef0jOv0ZXBp43f3LfEMTLnscjxhnixezm9repPEgPhbbPmjEln8vL1x
9fo0Bs7IhazMdZTD/IBHjS+OMxCZ/n7w5Qc5/FFYssrpzMS8zsQUsYnyOCQy
r6FGwECPydj4GzMF3DdwdqVV9kS9+rEpfkIFPFk+zmVBEQOzHf4kb4lXwoLM
sLq8Owzcv3bJ3dxXGc/V3Oqkc58B8x3aMUFuk/GdK7wnWZUMDHcb/M5eNQXb
GDg7qCIGFtYLZz3wUcHPiq1wWt1E/1ufeDQlqWK+xQKQbmQg6VjawB3/qTjY
ScW2j2GgKFyFE9ughiWNnJqItwz84vhR+Wen4QS+2Eb4iYF5/ui3XJQ6nvz2
e2XAdwbUYx/zwoO5WBDQtvTdTwayQ8yX2e3TwPO6Gis8WAbORivsvHRdE5dE
PrJ61cfAgFSfygWxFrYZLHmwcoSBmdJPs1JDtfGzQ3kWjzkt8N2h/Ptm7kzM
l8+6ZyPXAoxWva3VoA6Wtn2s+16+5f//9n8BYiMQWA==
          "]], 
         Line[CompressedData["
1:eJw9WHk01tv3Ns9jmctNpiRCkUbPSSpdISGiiEjialCirtyQUqZUSErkqlSU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          "]], 
         Line[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAbOdpCJlLvL/1AXdStaAdQPf3bsFH
RLy/Zc7dOaCeFkAw8P4TXC68vz7RBsvyoQ5AauiOZnAYvL8KCy1/CkEHQKPg
HrmEAry/7i9fHGfVAkDc2K4Lmey7v+Zx1s540/8/FtE+Xq3Wu7+KqZMQ1bf7
P0/JzrDBwLu/Pjeg6Ya0+D+IwV4D1qq7v6LdAN59bvY/wrnuVeqUu793N9bt
Ia/0P/yxfqj+fru/LtmAROxT8z81qg77Emm7vzyJ+KwqRvI/bqKeTSdTu7+G
jI3Zj3bxP6iaLqA7Pbu/FxDNea7a8D/hkr7yTye7v9D/5p99a/A/GotORWQR
u7+3EU08diTwP1SD3pd4+7q/VuuLlQ8D8D+Ne27qjOW6v1WaBK18BvA/xnP+
PKHPur8A5BS4nC/wPwBsjo+1ubq/PCJNIByB8D85ZB7iyaO6v2MT1AnO//A/
clyuNN6Nur/JWOUBVLPxP6xUPofyd7q/xOjE0T+n8j/lTM7ZBmK6v81ATJwF
7fM/HkVeLBtMur/rioa0a5/1P1g97n4vNrq/Qicy0uno9z+SNX7RQyC6v4QA
ojBMEPs/yy0OJFgKur8SVIh5HpT/PwQmnnZs9Lm/M9woN+o2A0A+Hi7JgN65
vzsD1yiX6ghAdxa+G5XIub/PfJJqqQkSQB0GWFcnuLm/9QF3UrWgHUDxLwus

          "]], 
         Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAUCaudG9Atb/xeCuCELgbwBS30jWl
M7W/UMhlCnlAEcBTu9G0Hx61v/XlpsA5TQXAkr/QM5oItb9rHmf2+kP/v9DD
z7IU87S/ioOq1bkd+b8OyM4xj920v6gZ6y6NYvW/TMzNsAnItL9oC89HwP/y
v4rQzC+EsrS/1FOn87l28b/I1Muu/py0v1E77g+jh/C/BtnKLXmHtL8f63qo
MxLwv0XdyazzcbS/+H0XCDUJ8L+E4cgrbly0v/j7HaMxbvC/wuXHquhGtL+P
aohaV1LxvwDqxiljMbS/5bqPoEjd8r8+7sWo3Ru0v+qlmbtVX/W/fPLEJ1gG
tL/SNysIioH5v7r2w6bS8LO/TNM0dH9sAMD4+sIlTduzv0ZgLeL4HwjAGGpY
9CDGs78yNt0hVNYXwJTtsHU=
          "]], 
         Line[{{-0.062181122448979595`, -3.9226990817915124`}, \
{-0.06178440495767701, -1.8186868407229564`}, {-0.06147804683042497, \
-1.3482970630062292`}, {-0.06117168870317294, -1.1269961941016169`}, \
{-0.0608653305759209, -1.0248834920750012`}, {-0.06055897244866887, \
-1.0008128269664063`}, {-0.060252614321416834`, -1.048081598317164}, \
{-0.0599462561941648, -1.1882004547470295`}, {-0.059639898066912764`, \
-1.4977837348198095`}, {-0.05933353993966073, -2.2567585839576223`}, \
{-0.059142406962785124`, -3.5212326350258305`}}], 
         Line[{{-0.04134778911564626, -1.820634552138917}, \
{-0.041097194612594264`, -1.1563235208158575`}, {-0.040765038749552215`, \
-1.0047071071732772`}, {-0.04043288288651016, -1.341886857214552}, \
{-0.040318877551020406`, -1.7182688775410655`}}], 
         Line[{{0.020318877551020458`, -1.59739408997913}, {
          0.02038633469346006, -6.0944732325283235`}, {
          0.02038633469346006, -6.0944732325283235`}}], 
         Line[{{0.04031887755102041, 1.7182688775410313`}, {
          0.04076831578702775, 1.0041221369365703`}, {0.041076111572821705`, 
          1.1314271713206836`}, {0.04134778911564626, 1.820634552138917}}], 
         Line[{{0.05914240696278512, 3.5212326350258305`}, {
          0.05931701022940779, 2.326455596907483}, {0.05965060375099176, 
          1.482225045340118}, {0.05998419727257573, 1.1640817807037305`}, {
          0.060317790794159706`, 1.0314911358897496`}, {0.060651384315743684`,
           1.0007507212459354`}, {0.06098497783732766, 1.054206172723444}, {
          0.06131857135891164, 1.2135645941780049`}, {0.061652164880495616`, 
          1.568632317276797}, {0.061985758402079594`, 2.468969181426472}, {
          0.062181122448979595`, 3.9226990817915124`}}], 
         Line[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAGGpY9CDGsz8yNt0hVNYXQBiT0Yyl
2rM/Q0uh2xp9CEDAdaYlHPCzP2awRzV3lwBAaFh7vpIFtD8uFFfgArP5PxA7
UFcJG7Q/D6slA9t+9T+4HSXwfzC0PyGsWdod8vI/YAD6iPZFtD+LQ125yl/x
PwjjziFtW7Q/RMtP2s118D+wxaO643C0Pyt6XuKJC/A/WKh4U1qGtD+zoFyQ
Gg/wPwCLTezQm7Q/VbMOVT9+8D+obSKFR7G0P0xRXhU8ZfE/UFD3Hb7GtD+l
yyVdyuLyP/gyzLY03LQ/mfISeMoz9T+gFaFPq/G0P8nLpypc0Pg/R/h16CEH
tT/1B3yIhrr+P+7aSoGYHLU/PlL4IV7ABECWvR8aDzK1P5lCJDVffBBAUCau
dG9AtT/xeCuCELgbQNOdjzY=
          "]], 
         Line[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAoG1CPoi9uT/KrNN61J0dwP1wIRx6
0rk/yJxqk7D1DcBGhRgKf+a5PzC+fCtpcwbAj5kP+IP6uT9y9YGTnhkCwNit
BuaIDro/ocoDRTST/r8hwv3TjSK6PzvY7A6Jrvq/atb0wZI2uj+jktF25dz3
v7Pq66+XSro/rF6J22DC9b/8/uKdnF66P5uXCDG0KPS/RRPai6Fyuj9Z+qQ7
6e3yv44n0Xmmhro/HQyjkdL78b/XO8hnq5q6P2MTgjODQ/G/IFC/VbCuuj+8
v3rrwLrwv2pktkO1wro/7agRiINa8L+zeK0xuta6Pw5WB5YLHvC//IykH7/q
uj8rtWKNUwLwv0ahmw3E/ro/+QOVjroF8L+PtZL7yBK7P6LMCeTWJ/C/2MmJ
6c0muz9sqmpQZ2nwvyHegNfSOrs/Ov0rH2DM8L9q8nfF1067P2DJ1uAVVPG/
swZvs9xiuz+Q6bctjQXyv/waZqHhdrs/LbFMYf7n8r9FL12P5oq7P6n4I6Go
BfS/jkNUfeueuz+ew4KxJW31v9hXS2vwsrs/OMf3s5oz978hbEJZ9ca7P2Vv
qRN5ePm/aoA5R/rauz8nUFnkQWz8v7SUMDX/7rs/6+K688EuAMD9qCcjBAO8
P1R7jUn66QLARr0eEQkXvD+BGITItecGwI/RFf8NK7w/anZjIu04DcDY5Qzt
Ej+8Px4TOUH7ThTAjQtHGTBNvD/KrNN61J0dwJFkKRw=
          "]], 
         Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAASIP2Hlktt7/1AXdStaAdQHxV6cyj
Ire/jIhK5wSgE0C6WehLHg23v+Qep3q/ighA+V3nypj3tr8BDzfkfgcCQDhi
5kkT4ra/UbdLHNLT/D92ZuXIjcy2vwxSENAfUvg/tGrkRwi3tr8ecoOxAFP1
P/Ju48aCoba/Q+FPlr9D8z8wc+JF/Yu2v05ZCmsj1/E/b3fhxHd2tr+Zva+4
3OHwP6574EPyYLa/q6CuHD1L8D/sf9/CbEu2vwFpBAMjBvA/KoTeQec1tr/H
vfr2wA3wP2iI3cBhILa/CYZI0pxk8D+mjNw/3Aq2v+uYVLxVFfE/5JDbvlb1
tb8uujiRmTXyPyKV2j3R37W/HDBWQ+js8z9hmdm8S8q1vxVd1GiOg/Y/oJ3Y
O8a0tb/8sYVad4b6P96h17pAn7W/ELKhQgeVAEAcptY5u4m1v8jqOHai0AZA
WqrVuDV0tb/z7vul7AMTQFqE/DU7arW/K3VtFzPuG0DBE8av
          "]], 
         Line[{{-0.06634778911564626, 
          4.453286353322944}, {-0.06576706061195345, 
          1.6642464539448878`}, {-0.06546070248470141, 
          1.3103844097896689`}, {-0.06515434435744938, 
          1.1256408822793968`}, {-0.06484798623019734, 
          1.0318728036819933`}, {-0.06454162810294531, 
          1.0001850840514062`}, {-0.06423526997569327, 
          1.0231015136405852`}, {-0.06392891184844124, 
          1.1091081832110583`}, {-0.0636225537211892, 
          1.290146899030078}, {-0.06331619559393717, 
          1.6568294177647533`}, {-0.06300983746668513, 
          2.52782460448276}, {-0.0628188775510204, 3.962041497624635}}], 
         Line[{{-0.02470912145345943, -1.0041979309371902`}, \
{-0.02470912145345943, -1.0041979309371902`}}], 
         Line[{{0.05587443310657596, -3.153057602532256}, {
          0.05598107501356803, -2.3996943898357483`}, {
          0.056314668535152004`, -1.4480936768896737`}, {
          0.05664826205673598, -1.1274085856181644`}, {
          0.05698185557831995, -1.0121876626118123`}, {
          0.05731544909990392, -1.0138621410622044`}, {
          0.0576490426214879, -1.1290117999199374`}, {
          0.05798263614307188, -1.4298283642113063`}, {
          0.058316229664655855`, -2.231842650953323}, {
          0.05850465186074431, -3.484323152696618}}], 
         Line[{{-0.07660419937205651, 
          5.910570866517362}, {-0.0765798470820574, 
          5.493690869319044}, {-0.07625145505794231, 
          2.8407775309602266`}, {-0.07592306303382723, 
          1.9517557570426225`}, {-0.07559467100971215, 
          1.520585997906497}, {-0.07526627898559707, 
          1.2776151731026664`}, {-0.07493788696148199, 
          1.1326829135873064`}, {-0.07460949493736692, 
          1.0481746067835538`}, {-0.07428110291325185, 
          1.0070271257377232`}, {-0.07395271088913677, 
          1.0024270597747211`}, {-0.07362431886502169, 
          1.0345269540265065`}, {-0.0732959268409066, 
          1.1107001725818595`}, {-0.07296753481679152, 
          1.2496828157138655`}, {-0.07263914279267646, 
          1.4945579756015472`}, {-0.07231075076856139, 
          1.9561933666537874`}, {-0.0719823587444463, 
          3.0124823218839296`}, {-0.07174744897959183, 5.148419904713501}}], 
         Line[{{-0.058504651860744314`, 
          3.484323152696701}, {-0.0581081074306526, 
          1.636194686796276}, {-0.05780174930340057, 
          1.2346198141331177`}, {-0.05749539117614853, 
          1.059637977730024}, {-0.0571890330488965, 
          1.0009860703688125`}, {-0.05688267492164446, 
          1.0324735805760235`}, {-0.05657631679439243, 
          1.1733710687193575`}, {-0.05626995866714039, 
          1.5201362725296252`}, {-0.05596360053988836, 
          2.495460760793538}, {-0.05587443310657596, 3.153057602532256}}], 
         Line[{{-0.0353954081632653, -1.4043123629610637`}, \
{-0.035118389077837334`, -1.0030649215144687`}, {-0.03480163617171006, \
-1.349256379613811}}], 
         Line[{{-0.015065737833594946`, -1.0813071969165946`}, \
{-0.014803845779489892`, 1.0124725317966445`}}], 
         Line[{{0.0628188775510204, -3.962041497624635}, {
          0.06298653896683151, -2.6413614444743394`}, {
          0.06332013248841549, -1.650112644922948}, {
          0.06365372600999947, -1.2655727304192381`}, {
          0.06398731953158344, -1.0868227483801702`}, {
          0.06432091305316742, -1.0110212057231331`}, {
          0.0646545065747514, -1.0054555243907872`}, {
          0.06498810009633538, -1.0659641435166387`}, {
          0.06532169361791935, -1.2120562540177149`}, {
          0.06565528713950333, -1.506432898180336}, {
          0.0659888806610873, -2.1489625640917627`}, {
          0.06632247418267127, -4.130056176116478}, {
          0.06634778911564625, -4.453286353322806}}], 
         Line[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAWoT8NTtqtT8rdW0XM+4bwI5lnuRy
crU/BZY3oW8kFMA2SHN96Ye1P4Fsz7rnlwfA3ipIFmCdtT8LhLaO7vgAwIYN
Ha/WsrU/jsavgv78+r8u8PFHTci1P2583f9d0Pa/1tLG4MPdtT8fSwbQ7CD0
v361m3k687U/ZwEetCZZ8r8mmHASsQi2PxVa60DYLPG/znpFqycetj8vvyQG
d3Lwv3ZdGkSeM7Y/wNwUdRoT8L8eQO/cFEm2P2CSdMBCA/C/xiLEdYtetj/9
E1Lmoz/wv24FmQ4CdLY/zv5WFDDM8L8W6G2neIm2P/SN+PvhtPG/vspCQO+e
tj98xP9qnRDzv2atF9lltLY/zd4eZpQH9b8OkOxx3Mm2PxbIUtr+4Pe/tnLB
ClPftj9NCNHNkCL8v15VlqPJ9LY/hJRoJi1xAcAGOGs8QAq3P67qsNcDZQfA
rhpA1bYftz9rtaiprSESwKu9EWAJLbc/yqzTetSdHcCdD8B9
          "]], 
         Line[{{-0.04968112244897959, -2.548145835186544}, \
{-0.04940109118864555, -1.4489012768411613`}, {-0.049068935325603504`, \
-1.0762080170388715`}, {-0.048736779462561455`, -1.0016703079663114`}, \
{-0.0484046235995194, -1.1395497343432657`}, {-0.048072467736477345`, \
-1.7156338214813787`}, {-0.04793792517006802, -2.3535132944912696`}}], 
         Line[{{0.011813130424583485`, 1.1251618892011548`}, {
          0.012140592627035013`, 1.092152524706618}, {0.012470422309692015`, 
          1.7811858320170577`}, {0.012800251992349018`, 
          2.6439988979089017`}, {0.013130081675006018`, 2.064099366870183}, {
          0.01345991135766302, 1.2513957626759704`}, {0.013789741040320023`, 
          1.00154416187368}, {0.013966836734693625`, -1.0495227705370078`}}], 
         
         Line[{{0.05295045649838882, 2.8427315848374635`}, {
          0.05297873331931224, 2.6230460262968665`}, {0.05331232684089622, 
          1.4482137997738325`}, {0.0536459203624802, 1.1064075463962042`}, {
          0.053979513884064176`, 1.0032292605672881`}, {0.054313107405648146`,
           1.0396921121561147`}, {0.05464670092723212, 1.2378607595912448`}, {
          0.054980294448816094`, 1.7929218352874938`}, {0.05523667800453515, 
          3.11833419248745}}], 
         Line[{{-0.03814266091051805, -1.584736317978237}, \
{-0.0381077918452158, -1.4542527440948227`}, {-0.03777563598217375, \
-1.0038566668081095`}, {-0.03744348011913169, -1.2562026442509924`}, \
{-0.03735591458805744, -1.5095795132866188`}}], 
         Line[{{-0.01739386396486446, 
          1.0003534200409254`}, {-0.01739386396486446, 1.0003534200409254`}}], 
         Line[{{0.04198554421768707, -1.8455061629354201`}, {
          0.042307294715997534`, -1.0996964055424494`}, {
          0.04261509050179149, -1.0057773906610754`}, {
          0.04292288628758545, -1.2429277340289417`}, {
          0.04315938331854481, -1.9651809696942875`}}], 
         Line[{{-0.043159383318544804`, 
          1.96518096969424}, {-0.043090129790846574`, 
          1.6505469352461268`}, {-0.04275797392780452, 
          1.0659417887706217`}, {-0.04242581806476247, 
          1.0250772864417346`}, {-0.04209366220172042, 
          1.4442144594325923`}, {-0.04198554421768707, 1.8455061629354201`}}], 
         Line[{{-0.0025660685603606263`, 
          1.2394747418860614`}, {-0.0025660685603606263`, 
          1.2394747418860614`}}], 
         Line[{{0.03735591458805744, 1.5095795132866188`}, {
          0.03769035792908816, 1.0050697334310699`}, {0.03799815371488212, 
          1.1913884361132403`}, {0.03814266091051805, 1.584736317978237}}], 
         Line[{{-0.05523667800453515, -3.11833419248745}, \
{-0.05473816803088022, -1.3376349787415371`}, {-0.054431809903628184`, \
-1.0872495835474913`}, {-0.05412545177637615, -1.002946074352981}, \
{-0.053819093649124114`, -1.0330774014313413`}, {-0.053512735521872086`, \
-1.2017832830206756`}, {-0.05320637739462006, -1.663686976996888}, \
{-0.05295045649838882, -2.8427315848374635`}}], 
         Line[{{-0.013194635962493774`, 
          1.620912909258744}, {-0.01274718712931908, -1.0131394327463483`}, \
{-0.012437065163140072`, -1.0464326825569041`}, {-0.012126943196961063`, \
-1.007548666638213}, {-0.011816821230782057`, -1.0825715077099811`}, \
{-0.011813130424583535`, -1.1251618892004618`}}], 
         Line[{{0.006985544217678628, -2.165791057867302}, {
          0.007373731537710104, -1.0709888250222455`}, {
          0.007373731537710104, -1.0709888250222455`}}], 
         Line[{{0.028096655328798185`, -1.0427146859543108`}, {
          0.02825255102040816, -1.0569485908775333`}}], 
         Line[{{0.06698554421768706, 4.495361837836691}, {0.06732325474742319,
           2.2543887426831097`}, {0.06765684826900717, 1.571619881625478}, {
          0.06799044179059115, 1.259308815139728}, {0.06832403531217512, 
          1.0989899614020813`}, {0.0686576288337591, 1.0212338755850783`}, {
          0.06899122235534308, 1.0001440486763298`}, {0.06932481587692706, 
          1.028532458552865}, {0.06965840939851103, 1.112239267106741}, {
          0.06999200292009501, 1.2738555758833134`}, {0.07032559644167899, 
          1.5713599040818447`}, {0.07065918996326297, 2.1700955259401433`}, {
          0.07099278348484694, 3.7492986720965487`}, {0.07110969387755102, 
          5.103243226248486}}], 
         Line[{{-0.009115084713028219, 
          1.2602218060448998`}, {-0.008739961646240073, \
-1.0350053652965383`}, {-0.008435929699373089, -1.0081817441557013`}, \
{-0.008432296795986952, -1.0429338518665856`}}], 
         Line[{{0.031568877551020405`, -1.1768507387844258`}, {
          0.03193918696510862, -1.2103635283472904`}}], 
         Line[{{-0.039681122448979596`, 
          1.6947129717237766`}, {-0.03943641529738401, 
          1.1096956876196176`}, {-0.039104259434341954`, 
          1.0266323728362046`}, {-0.03878041601255886, 1.6070236463190173`}}], 
         Line[{{0.021595473295701263`, 1.2195817420762023`}, {
          0.02170565342408807, 4.523975733796885}, {0.02170565342408807, 
          4.523975733796885}}], 
         Line[{{-0.045135667903525, -2.131672488431482}, \
{-0.045083064969098884`, -1.8545561652817502`}, {-0.044750909106056835`, \
-1.129807279029969}, {-0.04441875324301478, -1.0008363218623266`}, \
{-0.044086597379972725`, -1.1906589972690156`}, {-0.043797138420585614`, \
-1.9914305334674012`}}], 
         Line[{{-0.02357469150450877, -1.0338081943051065`}, \
{-0.02357469150450877, -1.0338081943051065`}}], 
         Line[{{0.016191893424037703`, -1.457409321730208}, {
          0.016428378501576038`, 2.523084192198296}, {0.016523066115477707`, 
          1.0022758509785354`}}], 
         Line[{{-0.03416388106966925, 
          1.3306361070775972`}, {-0.03412192148871118, 
          1.2177882577402037`}, {-0.03378976562566913, 
          1.0460091765965067`}, {-0.03365221088435373, 1.2837049865296026`}}], 
         Line[{{0.005103566546299602, -5.463182181536369}, {
          0.005549539856508198, 1.7381828483280386`}, {0.0058535718033751825`,
           2.027996650210815}, {0.006157603750242166, 1.050568781933258}, {
          0.006347789115637811, -1.0061331343595816`}}], 
         Line[{{0.026634667024704618`, -1.010101076359158}, {
          0.026653098663943095`, -1.001801026141157}, {
          0.026708149476006613`, -1.016977759366425}}], 
         Line[{{0.045773423005565854`, -2.1593785753415373`}, {
          0.04630863993131899, -1.0454891684972136`}, {
          0.04661643571711295, -1.011642550807847}, {
          0.04692423150290691, -1.2066273918898018`}, {
          0.047232027288700865`, -1.9431051365577416`}, {
          0.04730017006802721, -2.3242539936017734`}}], 
         Line[{{-0.04730017006802721, 
          2.3242539936017734`}, {-0.047076000147351194`, 
          1.449958722208891}, {-0.04674384428430914, 
          1.0590645950396849`}, {-0.04641168842126709, 
          1.0106711268526134`}, {-0.04607953255822504, 
          1.2406402072016482`}, {-0.04577342300556581, 2.159378575341772}}], 
         Line[{{-0.02599691192266379, -1.005695629475926}, \
{-0.025959903192046045`, -1.0021687512176434`}}], 
         Line[{{-0.006260069817238766, 
          1.3825644928533676`}, {-0.006099224371767264, 7.140279911760392}}], 
         
         Line[{{-0.03671815948601663, 
          1.488528082413267}, {-0.03644701253000554, 
          1.0198526493910782`}, {-0.036114856666963485`, 
          1.2076189032386815`}, {-0.03603316326530611, 1.4241463055005497`}}], 
         Line[{{0.0033583912284399576`, -1.4687803173058853`}, {
          0.003725348175306291, 1.023761669300975}, {0.004029380122173276, 
          1.893236415472078}, {0.00433341206904026, 1.4860505245933209`}, {
          0.004333412084407722, -7.404130858583082}}], 
         Line[{{0.024099365355898458`, -1.0001299511100101`}, {
          0.024099365355898458`, -1.0001299511100101`}}], 
         Line[{{0.04379713842058562, 1.9914305334674012`}, {
          0.04415406943076128, 1.118712200845175}, {0.044461865216555235`, 
          1.0003836481012476`}, {0.04476966100234919, 1.1480506555243937`}, {
          0.04507745678814315, 1.8298479609321252`}, {0.045135667903525044`, 
          2.131672488431767}}], 
         Line[{{0.03878041601255886, -1.6070236463190173`}, {
          0.03922933685805795, -1.0003886612554482`}, {
          0.039537132643851905`, -1.2574105905712112`}, {
          0.0396811224489796, -1.6947129717238096`}}], 
         Line[{{-0.030931122448979588`, -1.1620109129509257`}, \
{-0.030800362858290662`, -1.0053490011969914`}, {-0.03062190785405071, \
-1.1340947098425598`}}], 
         Line[{{0.04793792517006802, 2.3535132944912696`}, {
          0.048463210431876694`, 1.0959823943937208`}, {0.04877100621767065, 
          1.0000783870816834`}, {0.04907880200346461, 1.0818362998245963`}, {
          0.049386597789258566`, 1.4213383565965152`}, {0.049681122448979584`,
           2.548145835186459}}], 
         Line[{{0.010219867649981335`, -2.1841960118039916`}, {
          0.01034188911955486, 1.219938868816132}}], 
         Line[{{-0.019288965586234462`, 
          2.113432478055047}, {-0.019288965586234462`, 2.113432478055047}}], 
         Line[{{0.015244250685348668`, -1.0498678678675883`}, {
          0.015438889453605031`, 1.520278887222892}, {0.015481280863737346`, 
          1.0453850314965596`}}], 
         Line[{{0.03603316326530612, -1.4241463055005292`}, {
          0.03645917478591233, -1.026184692580808}, {
          0.03671815948601663, -1.488528082413267}}], 
         Line[{{0.02595990319204604, 1.0021687512176443`}, {
          0.025993439298629094`, 1.0040939502040134`}, {0.0259969119226638, 
          1.0056956294759338`}}], 
         Line[{{-0.0267081494760066, 
          1.016977759366417}, {-0.026634667024704607`, 1.010101076359164}}], 
         Line[{{-0.007256880024737146, 
          1.7032635881263842`}, {-0.006915769965038165, \
-1.0483601160380658`}, {-0.006811080772873762, -1.8623792611494543`}}], 
         Line[{{0.03365221088435374, -1.283704986529588}, {
          0.03399680849956066, -1.0371687818600395`}, {
          0.03416388106966925, -1.3306361070775972`}}], 
         Line[{{0.02357469150450878, 1.0338081943051296`}, {
          0.02357469150450878, 1.0338081943051296`}}], 
         Line[{{-0.021903344671201808`, 
          1.1317623775645265`}, {-0.021903344671201808`, 
          1.1317623775645265`}}], 
         Line[{{-0.0019283134583198101`, -1.0393656422767104`}, \
{-0.0018219354660969085`, -2.4619676375386685`}}], 
         Line[{{-0.031939186965108626`, 
          1.210363528347314}, {-0.03179683044741682, 
          1.0126291476529976`}, {-0.031568877551020405`, 
          1.1768507387844258`}}], 
         Line[{{0.028890306122448976`, 1.0673558855365262`}, {
          0.02896190644254211, 1.0039131006778383`}, {0.029092887154861944`, 
          1.0857235333780613`}}], 
         Line[{{-0.018005147126102426`, 
          1.0078180688890674`}, {-0.018005147126102426`, 
          1.0078180688890674`}}], 
         Line[{{0.0017494927155411524`, -1.0455100857409163`}, {
          0.0017968196000098936`, 1.0075133463862977`}}], 
         Line[{{-0.022936936402467953`, 
          1.049132839100129}, {-0.022913445681302824`, 1.1093136885266521`}}], 
         Line[{{-0.0035570914412276443`, 
          2.5445528752739}, {-0.003267386602634352, -5.816564744782249}, \
{-0.0031528532952564796`, 1.9335490198289587`}}], 
         Line[{{0.016810267217854613`, -1.000777235549339}, {
          0.016810267217854613`, -1.000777235549339}}], 
         Line[{{-0.03301445578231292, -1.2663100056342425`}, \
{-0.032793298036542975`, -1.0001755726631563`}, {-0.032576942067149436`, \
-1.2265047087480854`}}], 
         Line[{{0.02734590457804743, 1.0236438399864674`}, {
          0.027458900226757368`, 1.0340693743810025`}}], 
         Line[{{0.03480163617171006, 1.349256379613811}, {0.03522799164273649,
           1.0671009063590255`}, {0.03539540816326531, 1.4043123629610834`}}], 
         Line[{{0.024681122448979593`, 1.0013937299538536`}, {
          0.024681122448979593`, 1.0013937299538536`}}], 
         Line[{{-0.020514455782312906`, -1.3972599942308326`}, \
{-0.020514455782312906`, -1.3972599942308326`}}], 
         Line[{{-0.0011117380032909486`, 
          1.0002773754786995`}, {-0.0011068525656225034`, 
          7.406941689027453}}], 
         Line[{{0.019489010946363607`, -1.2065862104507181`}, {
          0.019489010946363607`, -1.2065862104507181`}}], 
         Line[{{0.008448958851833418, 1.1088521919206988`}, {
          0.008893891272045026, 1.0200887265750527`}, {0.00919792321891201, 
          1.2984923543726297`}, {0.009285811980342768, -1.212120245936567}}], 
         
         Line[{{0.02973064225690276, -1.0977254888459496`}, {
          0.029951395490513115`, -1.0659721343258761`}, {
          0.029984152752009892`, -1.1206258761034942`}}], 
         Line[{{-0.009652057486841024, 
          1.0568204377558328`}, {-0.009652057486841024, 
          1.0568204377558328`}}], 
         Line[{{0.03062190785405071, 1.1340947098425598`}, {
          0.03093112244897959, 1.1620109129509355`}}], 
         Line[{{-0.014607918926393126`, -1.0096213154345381`}, \
{-0.014607918926393126`, -1.0096213154345381`}}], 
         Line[{{-0.017088894655825193`, -1.0015193453301199`}, \
{-0.017033622474879606`, -1.2577034010764587`}}], 
         Line[{{0.002509220387838353, 1.0045053596227405`}, {
          0.002509220387838353, 1.0045053596227405`}}], 
         Line[{{0.023024972154716078`, -1.0238887103237235`}, {
          0.023024972154716078`, -1.0238887103237235`}}], 
         Line[{{0.017747697232204047`, 1.1308864611979526`}, {
          0.017758005948167357`, 1.2023643896650553`}}], 
         Line[{{-0.02825255102040815, 
          1.056948590877528}, {-0.02809665532879818, 1.0427146859543195`}}], 
         Line[{{0.011429988662113713`, -1.000581148836737}, {
          0.011429988662113713`, -1.000581148836737}}], 
         Line[{{-0.01832938252054122, -1.016372723107755}, \
{-0.01832938252054122, -1.016372723107755}}], 
         Line[{{-0.016074565071930762`, -1.6310317481967116`}, \
{-0.01607456507190054, -7.404130858583082}}], 
         Line[{{0.019067015962832053`, 1.0142433213480548`}, {
          0.019067015962832053`, 1.0142433213480548`}}], 
         Line[{{-0.011175375322542718`, 
          1.001521292322918}, {-0.010886455332245033`, 2.3065858560735584`}}], 
         Line[{{-0.029092887154861944`, -1.0857235333780613`}, \
{-0.02889030612244897, -1.0673558855365317`}}], 
         Line[{{0.010491444213750001`, -1.1945728439834646`}, {
          0.010713142784026651`, -1.1347646678367425`}}], 
         Line[{{-0.018949626452899236`, -1.5202276053974382`}, \
{-0.018949626452899236`, -1.5202276053974382`}}], 
         Line[{{0.021045994058774064`, -1.001108487425831}, {
          0.021045994058774064`, -1.001108487425831}}], 
         Line[{{-0.024071366351418613`, 
          1.0092522212922825`}, {-0.024044356114538847`, 
          1.0411597447217182`}}], 
         Line[{{-0.004465811444178235, 
          4.199686260704038}, {-0.004194846543268461, -1.065580770881473}}], 
         Line[{{0.015768719136262033`, -1.0352543662097455`}, {
          0.015768719136262033`, -1.0352543662097455`}}], 
         Line[{{-0.01417387607215579, -1.0136681475028817`}, \
{-0.01383239106453459, -1.2532147548204278`}}], 
         Line[{{-0.0066117380181711805`, 
          1.4315779455896498`}, {-0.0066117380181711805`, 
          1.4315779455896498`}}], 
         Line[{{-0.016468650723467176`, -1.302686222830171}, \
{-0.016468650723467176`, -1.302686222830171}}], 
         Line[{{-0.021430602182331303`, -1.1456225498210395`}, \
{-0.021400980605007978`, -1.3216010493066699`}}], 
         Line[{{0.01840735659751805, 1.1703435191277534`}, {
          0.01840735659751805, 1.1703435191277534`}}], 
         Line[{{0.007981795431444075, -1.281037541368668}, {
          0.007981795431444075, -1.281037541368668}}], 
         Line[{{-0.027458900226757364`, -1.0340693743809948`}, \
{-0.027345904578047416`, -1.023643839986477}}], 
         Line[{{-0.007827865805639118, 
          1.4086522211937202`}, {-0.007827865805639118, 
          1.4086522211937202`}}], 
         Line[{{0.03257694206714943, 1.2265047087480976`}, {
          0.03301445578231293, 1.2663100056342567`}}], 
         Line[{{-0.017709138588183203`, -1.0050680924167688`}, \
{-0.01769385533338117, -1.0013936364943439`}}], 
         Line[{{0.002005461768811399, 1.1023909951802264`}, {
          0.002005461768811399, 1.1023909951802264`}}], 
         Line[{{0.02242957329982937, 1.0358560042887974`}, {
          0.02242957329982937, 1.0358560042887974`}}], 
         Line[{{-0.022541099773242625`, -1.099706684199619}, \
{-0.022541099773242625`, -1.099706684199619}}], 
         Line[{{-0.002963354655767367, 
          1.0099016909607257`}, {-0.0027530803758095924`, 
          1.5148632136614069`}}], 
         Line[{{0.01708803786689004, 1.002071267198551}, {0.01714273655464829,
           1.153842726394912}}], 
         Line[{{-0.025322148090005228`, 
          1.0003892185815886`}, {-0.02529087854654056, 1.0079268260799803`}}], 
         Line[{{-0.005461469269726447, 
          3.207818262116256}, {-0.005461469269726447, 3.207818262116256}}], 
         Line[{{0.014604591836734442`, 1.0039890241501674`}, {
          0.01460649558330785, 1.0069084350839799`}}], 
         Line[{{0.02531887755102041, -1.0000704525555677`}, {
          0.025322148090005225`, -1.0003892185815877`}}], 
         Line[{{-0.02019011431761527, 
          1.0042193947526803`}, {-0.020073279311724736`, 
          1.8432521075662236`}}], 
         Line[{{-0.0004599200030015673, -1.2619944049847962`}, \
{-0.00045992000300091516`, -7.404130858583082}}], 
         Line[{{0.019726675328146058`, 1.2163360691647904`}, {
          0.019726675328146058`, 1.2163360691647904`}}], 
         Line[{{-0.010266211399887017`, 
          1.0443358626439423`}, {-0.010266211399887017`, 
          1.0443358626439423`}}], 
         Line[{{0.0008455995498670019, 7.406941689027453}, {
          0.0011117376135003363`, -1.0002545229179203`}}]}, 
        "Charting`Private`Tag#1"], {}}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|"PlotRange" -> {{
          Rational[-1, 2], 
          Rational[1, 2]}, {-7.404130858583082, 7.406941689027453}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->NCache[{{
      Rational[-1, 2], 
      Rational[1, 2]}, {-7.404130858583082, 7.406941689027453}}, {{-0.5, 
    0.5}, {-7.404130858583082, 7.406941689027453}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->72830685,ExpressionUUID->"4d216cc6-b64a-44f3-b425-758ba49e9fa9"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"5c95048e-a823-4f25-b558-1bd7c9eab55f"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->391783544,ExpressionUUID->"2abde430-1cf5-4072-bd0c-47fd54548cc7"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"aadcadc8-e39d-4d3c-9337-f9c3103f4360"],
 " has isolated singularities at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "2", ",", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0af0667c-a0e5-4fc6-aa69-5a5610722c41"],
 ". Plotting it:"
}], "SolvedExampleNote",
 CellID->192521300,ExpressionUUID->"2a58a359-43cb-481c-8ea4-6dc5c3a1bc4c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"3", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["5", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["624", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[
    PlotRange -> {0, 6}, BoxRatios -> {1, 1, 1}, ImageSize -> Small, 
     PlotLegends -> Automatic, AxesStyle -> Directive[12]],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->180707928,ExpressionUUID->"4232a11d-cd80-40e5-8f36-f1d2eb0e63ae"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJx0nXc8lt//+GUTilQaKmmiQUpFnbtUokFDopQ0aElTFCWhaBKlvRUNJC26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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJylnHV0VFf7/d/1+61VKA71vhNa2lKqSHSS4BLcgrtDkeJS3F2KW3F3dwgk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             "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {100., 100.}, 
           PlotRange -> {{0, 100.}, {0, 100.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxN3XW8fUXVBvB777nnXEJCSlq6u7tDpRGkERCQbpTukG6kuwRJKUnp7vYF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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkrlKg1EQha9mmULB2tLeRvICVtpZRARtI6KFxMZdEBG1sM8TCO5L0Ljg
HnfjmohGxDfwJfwO8xeH/8x/Z+aee2aaMkPpbG0IoRnEQdVCmE6GMMDPb/gC
OCFu53AcPg+OifdqQhiGb4M0Z92JEHbgLyAFysSvfO9BPzxHzoN6KQfeT/9T
eAHUct5Kz334IYjB4+AIPgdy8DL3ZdQX5KkvxUKowJdBF3EnOSvmGqTljPw8
/BLMEk9xXpR2896q6YC/RVrV8x2+a14rTXvwkrn2FuIneBuocP5HnIXfgC3O
Z4hv4RMg0L9Azph5jnLrQY95jnLlyZ20mntbJO6DP5vflYq8PDf3Sm+4sMgD
eleJB81rVCtN0rYKBuj3yL818xzl1oFe+I/5bBv5/oIlc23yWF5vgIaEz3QT
/qn5RDvxxfcaTCb9zXq7PJf3ulN3H5jPUjPULOW5vFfNlbkn8kY7pd3SDDVL
3fFhvlPaLXk4Ah81166d0+4tmmvXDmmX9Ea9VZrX4f8+nGaC
             "]]}, Annotation[#, "Charting`Private`Tag$11080#1"]& ]]}, {}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJwtU8kuRFEQvWhdS39ArNj0xs7WEEOIKSExR4QgMSakSaNZIIaYYogmSO+t
JToRMS2FnbfxBb7BOeosbk7denWrzqmqVzo01T6ZH0LoxCnA2bcQFgpDOAB+
AStwGhEQFfr9LhbCh/wN8CeBrzhRnmNOdrHeP8fc945TCXsU/hfYTeZ+vumI
eZ432Q+Kp50GlplzoO9BeW7ge4R9a17jSzx/4iEk5PuE7ynmPJ90J/9B8zwD
5jo+pWU+7nGMqTbXsQRcNfe3Acfk53fWKVYt5juIO7cUsBz+ImCNee4V4J65
lk69Yxxr7ZrH16pnkfq7hfsKYhoUn9CbZWASmDLnRG79wCPN7thcS1J6yGNe
tS7wrQ52xnyO36pVYt47auEcXtT/SP1hDGsXKc+0udZG8++RenuKez1izoBZ
zWjYfHY55WzVPCeAVeon+3opblfAdfN+dqgn1M/8CfFMqS/szxrwHqcd9qL5
7rIPh8Bf7Qzrbujtpjk/8jwHps31b5vPm3yalS+nfaP+tHbsRG+ptdt8d3uA
19LL3ewzj+8150E+nE9GGv+1aje4IzvaDe7IrfJkpY8zYd057VQE7NLbOv1P
v9I4o7lwPt/iTO4jiuP/16LZjwNnlZO5+S8mlecPkiSK9g==
            "]], 
           Polygon3DBox[CompressedData["
1:eJwtkc0qhVEUhjf5zhq6BDHhFgwpOU5ER1H+SRIhBkSO3wFCKBQKt6EoiUyN
nYkrcA2e1/sN3vazvvWttde7duPUUnmxNqXUhOrQQ6TUAbxmKT3Cw2gdrtak
1A5XUX0hpRbOU7SAvsl/oV54D22TL9G0D25Dv+Q+0Ax8lvdfIz6H58K1Xfw/
CB+iH+obOHfRBioTt1KzDBdRpeB/DuDj8L/v5Mu6O9zrjXgHHlGfzDNq1or8
ULuKNuGesLcX8pPhHuolD0dwKXz3BfE+fJvP30l8B8+iz8w7GoK7w171Tblx
9Jx5B9rFVV5fpP4avgmzvqn3fbi34v+3CO9anuVdM2pW7eQJHgt7lacteD68
+2bOk7BHedWbrcD9YS+aaQK+DL+F7tNs0+G3V6y3Ggj30g5HOf8ARl1Few==

            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0rkyWAEUBuBjjYgl1iTW0Vr6DNILnUqkU9j3fY8tvIDECzBj6ZAXiBdI
QipjhsaQIngBfEbxzfmLO/Ofc++taBto7k+IiK/spkY85ffmaVJEufyBz0yx
wQ+OuSPbwzU00cUaWxxxwQOliRF1fGKCbxzwmxsy9VTxkcvkiBPdHfK22ZgS
0Sl30U0PvfTRzwCDDDHMCKOMMc4Ek0wxzQyzzDHPFxZYZIllruzwV/eKvGM2
2aFdbqCSDP7b+xf7rDNOC7WUcO/uc36yySqdNFJNFrfe3x8O+c4krdRzpmNP
d5m8av6zU6lcQjFFvOMtbyikgHzyyCWH10/fiCwyyeAV6bwkjReoCGeGmlAd
Tojr5Of/4RGFEzn3
          "]], 
         Line3DBox[{1955, 1877, 1881, 1902, 1862, 1893, 1880, 1867, 1912, 
          1926, 1911, 1913, 1903, 1909, 1908, 1925, 1910, 1876, 1891, 1900, 
          1890, 1924, 1955}], 
         Line3DBox[{1977, 1889, 1869, 1915, 1859, 1897, 1858, 1883, 1882, 
          1896, 1868, 1895, 1894, 1857, 1887, 1888, 1875, 1923, 1866, 1904, 
          1905, 1914, 1977}], 
         Line3DBox[{1967, 1966, 1965, 1964, 1963, 1962, 1961, 1960, 1959, 
          1958, 1957, 1870, 1978, 1976, 1975, 1974, 1973, 1972, 1971, 1970, 
          1969, 1968, 1967}], 
         Line3DBox[{2011, 1907, 1906, 1916, 1917, 1918, 1886, 1873, 1920, 
          1919, 1860, 1863, 1879, 1898, 1871, 1901, 1884, 1885, 1878, 1934, 
          1932, 1899, 1872, 1922, 1865, 1929, 1874, 1931, 1921, 1928, 1927, 
          1864, 1861, 1933, 2011}], 
         Line3DBox[{1985, 1984, 1983, 1982, 1981, 1980, 1979, 1930, 2012, 
          2010, 2009, 2008, 2007, 2006, 2005, 2004, 2003, 2002, 2001, 2000, 
          1999, 1998, 1997, 1996, 1995, 1994, 1993, 1992, 1991, 1990, 1989, 
          1988, 1987, 1986, 1985}], 
         Line3DBox[{1943, 1942, 1941, 1940, 1939, 1938, 1937, 1936, 1935, 
          1892, 1956, 1954, 1953, 1952, 1951, 1950, 1949, 1948, 1947, 1946, 
          1945, 1944, 1943}]}}}, VertexNormals -> CompressedData["
1:eJx0mnc01v///4WGIiJFaaJ4K1ISpR4hiRIJpchKCBVRkVW2ZO/tsmWPbA97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       "], VertexTextureCoordinates -> CompressedData["
1:eJyVnHl0VUWex9MoTrRbmwhqm25tNbbLIagogqhQamvU0RFZFNxGA6IdNxS1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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
     Directive[12], BoxRatios -> {1, 1, 1}, DisplayFunction :> Identity, 
     ImageSize -> Small, Lighting -> "Neutral", 
     Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-2.999999793103448, 
      2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 6.}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], Automatic}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -112.5}, {7.5, 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -112.5}, 
                    Offset[{4., 0}, {7.5, -112.5}]}, {{7.5, -56.25}, 
                    Offset[{4., 0}, {7.5, -56.25}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 56.25}, 
                    Offset[{4., 0}, {7.5, 56.25}]}, {{7.5, 112.5}, 
                    Offset[{4., 0}, {7.5, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -101.25}, 
                    Offset[{2.5, 0.}, {7.5, -101.25}]}, {{7.5, -90.}, 
                    Offset[{2.5, 0.}, {7.5, -90.}]}, {{7.5, -78.75}, 
                    Offset[{2.5, 0.}, {7.5, -78.75}]}, {{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -33.75}, 
                    Offset[{2.5, 0.}, {7.5, -33.75}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -11.25}, 
                    Offset[{2.5, 0.}, {7.5, -11.25}]}, {{7.5, 11.25}, 
                    Offset[{2.5, 0.}, {7.5, 11.25}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 33.75}, 
                    Offset[{2.5, 0.}, {7.5, 33.75}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}, {{7.5, 78.75}, 
                    Offset[{2.5, 0.}, {7.5, 78.75}]}, {{7.5, 90.}, 
                    Offset[{2.5, 0.}, {7.5, 90.}]}, {{7.5, 101.25}, 
                    Offset[{2.5, 0.}, {7.5, 101.25}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", 
             RowBox[{"Max", "[", 
               RowBox[{"150", ",", "Small"}], "]"}]}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->118756744,ExpressionUUID->"350e050e-dc68-43e0-8df0-f5320faaed9e"]
}, Open  ]],

Cell["The singularities are visible as spikes on the plot.", \
"SolvedExampleNote",
 CellID->61965365,ExpressionUUID->"df797728-0521-4b54-966c-0ccaced14fae"],

Cell["", "SolvedExampleEndCap",
 CellID->327091612,ExpressionUUID->"e6b40876-5008-4398-a18b-00c674f9dba1"],

Cell["\<\
Let\[CloseCurlyQuote]s now examine the different types of singularities in \
order.\
\>", "Text",
 CellID->126471580,ExpressionUUID->"b357a217-da3b-42b4-af63-17e9ad0ba941"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Removable Singularities", "Subsection",
 CellID->265730516,ExpressionUUID->"d00dd276-200c-4d7e-aa98-7eba6fb9c857"],

Cell["\<\
You have already encountered removable singularities, for example, when \
discussing Taylor\[CloseCurlyQuote]s theorem. Here is a formal definition:\
\>", "Text",
 CellID->12187780,ExpressionUUID->"6707f7f2-8b63-4d04-b8a0-31a79b242967"],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b306077b-71d4-4cce-b378-5a4e3e990ba5"],
 " has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c87e0cdb-7ea7-4a7e-9bec-566d6d946807"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"627b5154-a0dc-4b70-b4e6-30065da9d9e0"],
 " can be made analytic by redefining its value at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "145ebdbc-7ba2-4709-a796-0ca3d8273bfd"],
 "."
}], "Text",
 CellID->194161672,ExpressionUUID->"4d3c993b-5884-4df5-9127-1f8aa562769d"],

Cell[TextData[{
 "Examples are the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"sin", " ", "z"}], ")"}], "/", "z"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"de8fad85-d2f7-4e48-977d-5bbcfd3bfa2d"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "0"], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"28bdfa74-bfd0-4a93-a6b0-faa008bffc30"],
 " or the function"
}], "Text",
 CellID->12928416,ExpressionUUID->"2c6c38b7-1d57-4919-83cb-e7289ec37c7d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {"0", 
          RowBox[{
           RowBox[{
            RowBox[{"if", " ", "z"}], "!=", "0"}], ","}]},
         {"1", 
          RowBox[{
           RowBox[{"if", " ", "z"}], "=", "0."}]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True]}], TraditionalForm]], "DisplayFormula",
 CellID->41898798,ExpressionUUID->"13b0991a-570b-4c0d-8148-969938118fc1"],

Cell[TextData[{
 "Both can be made analytic by redefining ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "0", ")"}], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f0d6a3da-aea1-476a-973d-aff4f4214243"],
 "."
}], "Text",
 CellID->354195267,ExpressionUUID->"a76ec9d1-2bbb-471a-b652-2e8b0e10e2ec"],

Cell[TextData[{
 StyleBox["1st criterion for removable singularities",
  FontSlant->"Italic"],
 ":",
 " A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d9976190-e77a-4394-ad7a-a0c3e10c30fa"],
 " that is singular at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dd07d5d6-1c8a-40e7-b71e-1bcb16b12d66"],
 " and is analytic and bounded by ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath",ExpressionUUID->
  "730e9895-5a9e-4ed8-9d87-ed0543ee1301"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "\[Epsilon]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"684923a8-b935-4c94-91f6-7bbe549ad2e3"],
 " for all small ",
 Cell[BoxData[
  FormBox["\[Epsilon]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ee2d3a06-5dfc-4cc9-bb8f-a04a81d42122"],
 " has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ad952547-564d-4d2b-b159-7caa7f5e7439"],
 ". (The bound ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath",ExpressionUUID->
  "37600503-92f8-426e-ba42-3e3f962f7128"],
 " must be the same for all ",
 Cell[BoxData[
  FormBox["\[Epsilon]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ff629f66-daff-4a43-aa19-8ad9b5ab023e"],
 ".) The proof is similar to that of Cauchy\[CloseCurlyQuote]s integral \
formula."
}], "Text",
 CellID->92155648,ExpressionUUID->"db096eb6-3372-4658-9bfc-50df51d013c6"],

Cell[TextData[{
 StyleBox["2nd criterion for removable singularities",
  FontSlant->"Italic"],
 ":",
 " A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b3e50ce6-99ee-46b7-aad2-be19cdff2659"],
 " analytic in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalOmega]", "-", 
    RowBox[{"{", 
     SubscriptBox["z", "0"], "}"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"66f010d0-6bf8-4066-b4c5-8a42145ff4de"],
 " has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f84dc58c-76e8-499c-98be-1f992909823a"],
 " if and only if "
}], "Text",
 CellID->684931604,ExpressionUUID->"1669353d-b01d-45b4-a33d-e63efc0d2d59"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", 
      SubscriptBox["z", "0"]}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "f", 
     RowBox[{"(", "z", ")"}]}]}], "=", "0."}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->477161422,ExpressionUUID->"0f2e5606-4b03-45ac-9b52-4c79a89d5111"],

Cell[TextData[{
 "The proof is again similar to that of Cauchy\[CloseCurlyQuote]s integral \
formula, and the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    SubscriptBox["z", "0"], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3bec3e67-28a1-495e-8644-7b5661ed2e2a"],
 " that makes the function analytic is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     SubscriptBox["z", "0"], ")"}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", 
       RowBox[{"\[ThinSpace]", "C"}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", 
         SubscriptBox["z", "0"]}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a48a297d-7aba-4f9d-8255-d2ff1180ef2e"],
 "."
}], "Text",
 CellID->146795801,ExpressionUUID->"23c79a50-a280-4065-9067-28fa5970381c"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->284635988,ExpressionUUID->"9d0abbad-33bc-4fe7-af17-edcb7e4b5ca7"],

Cell[TextData[{
 "Show that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"sin", " ", "z"}], ")"}], "/", "z"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"40616abc-a35a-4825-b41a-b2891621d3dd"],
 " has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "28a69c0b-1807-49de-9d7c-3c8a97f3c254"],
 ":"
}], "SolvedExampleNote",
 CellID->244894093,ExpressionUUID->"eadf7be6-a906-4446-af06-c53f7f250777"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"z", "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", "z", "]"}], "/", "z"}], ")"}]}], ",", 
   RowBox[{"z", "->", "0"}]}], "]"}]], "SolvedExampleInput",
 CellID->525262339,ExpressionUUID->"d6f978b9-96d8-4a7b-b007-99657e1cf3c0"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->100579569,ExpressionUUID->"be0fd297-2d17-4030-abe0-d915cc95466c"]
}, Open  ]],

Cell["\<\
This proves that the singularity is removable. Plotting the function:\
\>", "SolvedExampleNote",
 CellID->590559,ExpressionUUID->"efce1fdd-4cf4-4cbf-92fc-2c2062cb79db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "z", "]"}], "/", "z"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", "SequenceIcon", 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Sequence", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["3", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["448", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       Sequence[AxesLabel -> {
          Re[$CellContext`z], 
          Im[$CellContext`z]}, AxesStyle -> Directive[12], PlotLegends -> 
        Automatic],
       SelectWithContents->True,
       Selectable->False]}], "]"}], ",", 
    RowBox[{"ListPointPlot3D", "[", 
     RowBox[{"{", 
      RowBox[{"Callout", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
        InterpretationBox[
         DynamicModuleBox[{Typeset`open = False}, 
          TemplateBox[{"Expression", 
            RowBox[{"ToString", "[", 
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
              "]"}], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Byte count: \"", "IconizedLabel"], 
                 "\[InvisibleSpace]", 
                 TagBox["176", "IconizedItem"]}]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
             "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
            Dynamic[Typeset`open]},
           "IconizedObject"]],
         ToString[
          HoldForm[$CellContext`z == 0], TraditionalForm],
         SelectWithContents->True,
         Selectable->False]}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "SolvedExampleInput",
 CellID->18078069,ExpressionUUID->"18093267-b63e-4ea2-8812-e3f456e82716"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{{
      GraphicsComplex3DBox[CompressedData["
1:eJx13AdwllX2BvA0CMUSWQUUpLcVVEp2FRTOoYuSBXEhsiDdABZkZYAoRVcD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       "], {{{
          EdgeForm[], 
          Texture[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJytnXewlGW35W/NVEmOBj61+5CTIDnnnHNOBpIREUQFFAFRERBBouSg5AxK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              "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {144., 144.}, 
            PlotRange -> {{0, 144.}, {0, 144.}}]], 
          GraphicsGroup3DBox[
           TagBox[{
             Polygon3DBox[CompressedData["
1:eJxNnHncT1XXh3/nnOZ5nkukEEpkKClFFGWWucyRKaEQimRIotAgoUmToqIi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              "]]}, 
            Annotation[#, 
             "Charting`Private`Tag$14737#1"]& ]]}, {}, {}, {}, {}}, {{
          GrayLevel[0], 
          Line3DBox[CompressedData["
1:eJwl0jVSHkAYBuAlBEtwTdChRS4QoEc6KqSjSJDg7kGGn4JBf2BwCnKBBC4A
F0AuQC6AXAB4mBTPvF/x7ex+u1va1tvYExNCiHAUG8J7vSeXKFHX0Mo4u1xw
xzNpmitpoIMIv9mw9kr+45WiDyFU0cwo2/zlhkdS9JdTxwon/OCALdrpoJMu
ftJND7300c8AgwwxzAijjDHOBJNMMc0Ms/xijnkWWOWURQ6J8p1aykjmwbmv
+UOUEZr4RiEv5r5nU++lPGOJduqpIJUn93jLOTuM0UI1y9YeU6zel+sUqQsp
IJ+vfCGPXHLIJotMMkh/fytSSSGZz3wiiUQSiCeOj9gqGCOsxf7/F2+BXzlJ

           "]]}}}, VertexNormals -> CompressedData["
1:eJx1fHc01+/7vzSoFEplZCQlGhQKlUtLKEqRUlqyUmmrhBKayi6jkIwyo2F2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        "], VertexTextureCoordinates -> CompressedData["
1:eJx920uo52Mcx/ET0diZhcilXMpqYhbMRogyIhujpCxESbHAZDcozYTNFBZn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        "]], {}}, {{{{
         Directive[
          PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], 
          RGBColor[0.3315753, 0.4561011, 0.6388182]], {
          Point3DBox[{0., 0., 1.}]}}}, {{{}, {{
           Inset3DBox[
            FormBox[
             GraphicsBox[{
               GraphicsGroupBox[{{
                  Directive[
                   AbsoluteThickness[4], 
                   GrayLevel[1], 
                   Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]], 
                  CapForm["Butt"], 
                  JoinForm["Round"], 
                  BSplineCurveBox[{
                    Offset[{2.121320343559643, 2.121320343559643}, {0., 0.}], 
                    
                    Offset[{5.656854249492381, 5.656854249492381}, {0., 0.}], 
                    
                    Offset[{7.65685424949238, 5.656854249492381}, {0., 0.}], 
                    Offset[{9.65685424949238, 5.656854249492381}, {0., 0.}], 
                    
                    Offset[{9.65685424949238, 5.656854249492381}, {0., 
                    0.}]}]}, {
                  Directive[
                   RGBColor[
                   0.6666666666666666, 0.6666666666666666, 
                    0.6666666666666666], 
                   AbsoluteThickness[1.25]], 
                  BSplineCurveBox[{
                    Offset[{2.121320343559643, 2.121320343559643}, {0., 0.}], 
                    
                    Offset[{5.656854249492381, 5.656854249492381}, {0., 0.}], 
                    
                    Offset[{7.65685424949238, 5.656854249492381}, {0., 0.}], 
                    Offset[{9.65685424949238, 5.656854249492381}, {0., 0.}], 
                    
                    Offset[{9.65685424949238, 5.656854249492381}, {0., 
                    0.}]}]}, {
                  FaceForm[
                   Directive[
                    GrayLevel[1], 
                    Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]]], 
                  EdgeForm[], 
                  PolygonBox[{
                    
                    Offset[{48.656854249492376`, 20.056854249492382`}, {0., 
                    0.}], 
                    Offset[{48.65685424949238, -3.9431457505076164`}, {0., 
                    0.}], 
                    
                    Offset[{9.656854249492383, -3.9431457505076235`}, {0., 
                    0.}], 
                    
                    Offset[{9.656854249492376, 20.056854249492375`}, {0., 
                    0.}]}]}, {
                  EdgeForm[], 
                  Directive[
                   RGBColor[
                   0.6666666666666666, 0.6666666666666666, 
                    0.6666666666666666], 
                   AbsoluteThickness[1.25]]}, {}, 
                 InsetBox[
                  FormBox[
                   StyleBox[
                    RotationBox[
                    "\"\\!\\(\\*FormBox[TagBox[RowBox[{\\\"z\\\", \\\"\
\[LongEqual]\\\", \\\"0\\\"}], HoldForm], TraditionalForm]\\)\"", BoxRotation -> 
                    0.], {
                    Opacity[1]}, StripOnInput -> False], TraditionalForm], 
                  Offset[{29.15685424949238, 8.05685424949238}, {0., 0.}], 
                  NCache[
                   ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                   ImageScaled[{0.5, 0.5}]]]}]}, PlotRange -> 
              NCache[{{-1 + 2^Rational[-1, 2], 1 + 2^Rational[-1, 2]}, {-1 + 
                  2^Rational[-1, 2], 1 + 
                  2^Rational[-1, 2]}}, {{-0.29289321881345254`, 
                1.7071067811865475`}, {-0.29289321881345254`, 
                1.7071067811865475`}}], ImageSize -> {68, 53}, AspectRatio -> 
              Full], TraditionalForm], {0., 0., 1.}, 
            
            Offset[{-2.1627865594543785`, -1.42298724578741}, {0, 
             0}]]}}}, {}}, {}}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
       FormBox[
        TagBox[
         RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
       FormBox[
        TagBox[
         RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
     Directive[12], BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, 
     Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 3.3374849339124784`}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->283928731,ExpressionUUID->"463c2514-b152-4542-9a79-7de55debc16b"]
}, Open  ]],

Cell[TextData[{
 "No singularity is visible at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "37f1d6af-3b08-4380-a3ee-ad03d5c8ab27"],
 " in the plot."
}], "SolvedExampleNote",
 CellID->436637925,ExpressionUUID->"4a58310a-65ef-4865-adaf-2591a12197f0"],

Cell["", "SolvedExampleEndCap",
 CellID->246337806,ExpressionUUID->"31ccf6c4-43f8-46a0-9fdd-cb90221cc2df"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->391653386,ExpressionUUID->"47d73f87-7fe4-40dc-afb1-36f2dba921d8"],

Cell[TextData[{
 "Show that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"335e5d7b-0985-456a-b13b-109fdfca8efb"],
 " defined here has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a9f0e7ed-a0d9-423c-91d0-80aeb3158488"],
 ":"
}], "SolvedExampleNote",
 CellID->274101,ExpressionUUID->"6720f5d9-9175-4f12-ab6a-5988d5a5a3a4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {"2", 
          RowBox[{"z", "==", "1"}]},
         {
          SuperscriptBox["z", "2"], "True"}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}},
        Selectable->True]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}], 
    RowBox[{"f", "[", "z", "]"}]}], ",", 
   RowBox[{"z", "->", "1"}]}], "]"}]}], "SolvedExampleInput",
 CellID->244086943,ExpressionUUID->"c2a1eb48-1e25-4fbf-a3af-0fb412553ea9"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->255858378,ExpressionUUID->"5fdee223-da5b-4c12-bf5e-cc22ef0d9cf6"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->2055610653,ExpressionUUID->"bf7ab60a-2f13-4012-b9bf-1621f4e968ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Poles", "Subsection",
 CellID->296140747,ExpressionUUID->"0b59b035-58c4-47d4-bf47-4766f87f3daf"],

Cell["\<\
Removable singularities are in a sense trivial, because they can be redefined \
away. The simplest type of \
\[OpenCurlyDoubleQuote]real\[CloseCurlyDoubleQuote] singularities are poles.\
\>", "Text",
 CellID->574741587,ExpressionUUID->"ef1a858f-6072-4483-ad12-9c04cdf50c3f"],

Cell[TextData[{
 StyleBox["1st definition of pole",
  FontSlant->"Italic"],
 ":",
 " A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c68d8119-b560-4178-b157-966842c9f675"],
 " has a pole at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9fbb243b-3f6c-4dc9-9fca-dd0a6a14832b"],
 " if:"
}], "Text",
 CellID->259110030,ExpressionUUID->"41fb44e6-6a38-4467-a748-1cf36b58c25b"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"08f6cc81-97a4-5c4c-843e-f68628b93175"],
 " has an isolated singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "01f3427c-13a4-c141-8b7d-024d377deeae"],
 ", and"
}], "Text",
 CellID->419565916,ExpressionUUID->"1ac0738d-8a44-7444-92a7-2a690924faa6"],

Cell[TextData[{
 "2. there is a positive integer ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9e2a0ac7-add2-2744-b6a0-9cdd90eeed10"],
 " such that"
}], "Text",
 CellID->390397192,ExpressionUUID->"7a591dea-305a-2c47-a8e3-098505e349f4"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"|", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], 
      SuperscriptBox["|", "\[Alpha]"], "|", 
      RowBox[{"f", "(", "z", ")"}], "|"}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9b55f087-5185-9e46-b6b0-ef14c4387d80"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ">", "h"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ca372e48-2e45-3345-a732-e22cd3a52780"],
 " and"
}], "Text",
 CellID->229546347,ExpressionUUID->"49e55508-96f3-4445-bc27-3a708c29f7d7"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"|", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], 
      SuperscriptBox["|", "\[Alpha]"], "|", 
      RowBox[{"f", "(", "z", ")"}], "|"}]}], "=", "\[Infinity]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "8c9025df-228e-e543-9cc5-2e774a0b3c10"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "<", "h"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9c27625d-658b-934d-b693-bc413a7cc5a5"],
 "."
}], "Text",
 CellID->99330275,ExpressionUUID->"2b4a0d0b-7c1e-fe4a-a71b-338747827c9d"],

Cell[TextData[{
 "The integer ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ef36ce57-ca69-014e-abf6-43d40c37dbaa"],
 " is called the ",
 StyleBox["order",
  FontSlant->"Italic"],
 " of the pole."
}], "Text",
 CellID->199793475,ExpressionUUID->"cd1f1a5e-89d2-bb43-a770-c91e0e8bf7a5"],

Cell[TextData[{
 "A pole of order 1 is also called a ",
 StyleBox["simple pole",
  FontSlant->"Italic"],
 "; a pole of order 2 a ",
 StyleBox["double pole",
  FontSlant->"Italic"],
 ", etc."
}], "Text",
 CellID->183434968,ExpressionUUID->"066ff22e-59c2-4abc-8a7d-f7bb7ca1f552"],

Cell[TextData[{
 StyleBox["2nd definition of pole",
  FontSlant->"Italic"],
 ":",
 " A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ae5b222f-319b-49a0-9751-1422d3e75ca4"],
 " has a pole at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b3e68b5b-b422-4830-8abe-142992bc1708"],
 " if it is:"
}], "Text",
 CellID->220857533,ExpressionUUID->"1f450033-bcfc-4228-9e65-fab0bcf2cd9e"],

Cell[TextData[{
 "1. analytic in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "\[Epsilon]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"de4d73ed-d0cd-2744-bc66-7f2d356d7244"],
 ", and"
}], "Text",
 CellID->145602307,ExpressionUUID->"d5629948-9908-8b40-b5af-089a47172d87"],

Cell["2. its Laurent expansion", "Text",
 CellID->265580663,ExpressionUUID->"1dd0f687-01c0-574a-8723-8c24b7048809"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "1"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     FractionBox[
      SubscriptBox["b", "n"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}], ")"}], "n"]]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     SuperscriptBox[
      RowBox[{
       SubscriptBox["a", "n"], "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2223338a-3f34-42fe-ae80-660c767913f6"]
}], "Text",
 CellID->16154870,ExpressionUUID->"ba017883-70ff-4fe8-80c1-d5f0e1c363d3"],

Cell[TextData[{
 "in this annulus has at least one, but not infinitely many, nonzero terms ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bdb09d2a-ac12-4cd9-b3b1-f694d228011b"],
 ". Then, the highest index ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7e911e02-2d18-41d0-9d1a-430cd152a04d"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", 
     RowBox[{"h", "+", "k"}]], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"80be0124-381b-4593-ab77-f1289b655704"],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ">=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f7360389-bb2b-4d88-9d3c-b9178bc99bee"],
 " is the order of the pole."
}], "Text",
 CellID->172392321,ExpressionUUID->"66e9ff30-7d76-48fe-b9bb-e5e64072c13a"],

Cell["It is easy to see that the definitions are equivalent:", "Text",
 CellID->215559798,ExpressionUUID->"2913c067-19a6-4264-9ba1-df024f080f55"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8b433fa7-7bd2-b445-8f68-d11add193dee"],
 " is a pole in the first definition, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "h"], 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5d4f8154-9410-2249-b8dc-c1b1fdca4404"],
 " has a removable singularity by the second criterion, so it can be expanded \
in a Taylor series"
}], "Text",
 CellID->24840743,ExpressionUUID->"2f020047-9238-064f-b39b-650be9f9c336"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "h"], "f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SubscriptBox["B", "n"], "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->34805783,ExpressionUUID->"ce63f2e5-9637-4403-b1fd-83da4b595ba2"],

Cell[TextData[{
 "Dividing by ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}], "h"], TraditionalForm]], "Text",
  ExpressionUUID->"86584b47-7b38-4e87-9006-c5655af30061"],
 ", we see that the second definition is also satisfied. Conversely, if the \
pole satisfies the second definition, it is straightforward to check that it \
satisfies the first."
}], "Text",
 CellID->14194342,ExpressionUUID->"1422267e-e823-4a25-901b-1fe3edb1cbc8"],

Cell[TextData[{
 "In words, a function that has a pole at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "97c9708d-5c99-4104-9050-56aded1f958e"],
 " behaves locally like: "
}], "Text",
 CellID->228221421,ExpressionUUID->"3fe89027-2a86-43d1-97f8-9f0b57252291"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "\[TildeTilde]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SubscriptBox["b", "h"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], 
     RowBox[{"-", "h"}]], "."}]}], TraditionalForm]], "DisplayFormula",
 CellID->257003000,ExpressionUUID->"3162b995-d40b-4705-a6c7-0cc15dbd3416"],

Cell[TextData[{
 "A function that is analytic in a region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "eeadc4d2-efbb-4eb7-8df8-e01cdb0f0a9b"],
 " except for poles is called ",
 StyleBox["meromorphic",
  FontSlant->"Italic"],
 " in that region."
}], "Text",
 CellID->29393094,ExpressionUUID->"2c694014-422d-4e67-b28c-522d4e55228d"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->548910164,ExpressionUUID->"ead8e34f-06e3-4420-bd98-c71772d263a3"],

Cell[TextData[{
 "What are the poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "-", "1"}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"z", "(", 
        RowBox[{"z", "-", "2"}], ")"}], "3"], 
      RowBox[{"(", 
       RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8a6efffb-ceed-40e2-a1a8-1beaa3e443e3"],
 " and their order?"
}], "SolvedExampleNote",
 CellID->252605793,ExpressionUUID->"6866084d-4529-489d-bb2f-466a53bec309"],

Cell[TextData[{
 "The poles are located at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", "2", ",", "\[ImaginaryI]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "5d70b3e4-a142-4077-890a-5b1d60c5432e"],
 ". You can find their order, for example, using the Wolfram Language command \
",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ". Expanding around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dbf7c190-f76a-4d60-8aef-0d8f478e0f3a"],
 ":"
}], "SolvedExampleNote",
 CellID->692129598,ExpressionUUID->"e5dd039a-0ca2-4afd-b17b-c7dc6a6fa5a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], "3"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->46777875,ExpressionUUID->"b8d38013-dd45-4d08-be77-333b4f150896"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[ImaginaryI]", 
    RowBox[{"8", " ", "z"}]], "+", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "8"], "+", 
     FractionBox[
      RowBox[{"3", " ", "\[ImaginaryI]"}], "16"]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["3", "16"], "-", 
      FractionBox["\[ImaginaryI]", "16"]}], ")"}], " ", "z"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "16"], "+", 
      FractionBox[
       RowBox[{"7", " ", "\[ImaginaryI]"}], "32"]}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["7", "32"], "+", 
      FractionBox["\[ImaginaryI]", "128"]}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "128"], "-", 
      FractionBox[
       RowBox[{"37", " ", "\[ImaginaryI]"}], "256"]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["37", "256"], "-", 
      FractionBox[
       RowBox[{"7", " ", "\[ImaginaryI]"}], "128"]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    Complex[0, 
     Rational[1, 8]], 
    Complex[
     Rational[1, 8], 
     Rational[3, 16]], 
    Complex[
     Rational[3, 16], 
     Rational[-1, 16]], 
    Complex[
     Rational[-1, 16], 
     Rational[-7, 32]], 
    Complex[
     Rational[-7, 32], 
     Rational[-1, 128]], 
    Complex[
     Rational[-1, 128], 
     Rational[37, 256]], 
    Complex[
     Rational[37, 256], 
     Rational[-7, 128]]}, -1, 6, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->491417360,ExpressionUUID->"78925881-3916-4701-a5ee-18d4bb26eae2"]
}, Open  ]],

Cell[TextData[{
 "The pole at zero has order 1 (a simple pole), because the \
\[OpenCurlyDoubleQuote]lowest\[CloseCurlyDoubleQuote] term in the Laurent \
expansion is a power ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "cd52c920-6f20-471e-bf69-d9570871ca59"],
 ". The pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "00b974bd-d7a8-4377-a065-5c32e24d7ff8"],
 " has order 3, because in its Laurent expansion:"
}], "SolvedExampleNote",
 CellID->258917990,ExpressionUUID->"2c6e0063-a7d1-4f96-a252-04a7edceeb61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], "3"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "4"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->224654936,ExpressionUUID->"6d4b29a1-afbc-4c3d-bc4c-fe75adbae577"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     FractionBox["3", "5"], "+", 
     FractionBox[
      RowBox[{"3", " ", "\[ImaginaryI]"}], "10"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], "3"]], "+", 
   FractionBox[
    RowBox[{
     FractionBox["8", "25"], "+", 
     FractionBox["\[ImaginaryI]", "100"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], "2"]], "-", 
   FractionBox[
    RowBox[{
     FractionBox["22", "125"], "+", 
     FractionBox[
      RowBox[{"93", " ", "\[ImaginaryI]"}], "1000"]}], 
    RowBox[{"z", "-", "2"}]], "+", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["48", "625"], "+", 
     FractionBox[
      RowBox[{"849", " ", "\[ImaginaryI]"}], "10000"]}], ")"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["82", "3125"], "+", 
      FractionBox[
       RowBox[{"5557", " ", "\[ImaginaryI]"}], "100000"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "2"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["88", "15625"], "+", 
      FractionBox[
       RowBox[{"30601", " ", "\[ImaginaryI]"}], "1000000"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["58", "78125"], "-", 
      FractionBox[
       RowBox[{"149293", " ", "\[ImaginaryI]"}], "10000000"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], "3"]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["672", "390625"], "-", 
      FractionBox[
       RowBox[{"660449", " ", "\[ImaginaryI]"}], "100000000"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "2"}], "]"}], "5"],
    SeriesData[$CellContext`z, 2, {}, -3, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 2, {
    Complex[
     Rational[3, 5], 
     Rational[3, 10]], 
    Complex[
     Rational[8, 25], 
     Rational[1, 100]], 
    Complex[
     Rational[-22, 125], 
     Rational[-93, 1000]], 
    Complex[
     Rational[48, 625], 
     Rational[849, 10000]], 
    Complex[
     Rational[-82, 3125], 
     Rational[-5557, 100000]], 
    Complex[
     Rational[88, 15625], 
     Rational[30601, 1000000]], 
    Complex[
     Rational[58, 78125], 
     Rational[-149293, 10000000]], 
    Complex[
     Rational[-672, 390625], 
     Rational[660449, 100000000]]}, -3, 5, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->128075014,ExpressionUUID->"2a9a1783-ec4a-418c-be4a-a44619cda10f"]
}, Open  ]],

Cell[TextData[{
 "the lowest term is a power ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], "3"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"88d4db64-2c75-42d4-a239-68f7e0cc9816"],
 ". Finally, the pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6a320271-5d92-496a-902d-2ce4eb4aa18c"],
 " has order 1:"
}], "SolvedExampleNote",
 CellID->270562286,ExpressionUUID->"827588a2-1dc4-4f18-b87a-b8ce003f5c70"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], "3"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "\[ImaginaryI]", ",", "4"}], "}"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->580767944,ExpressionUUID->"adc8533b-00f7-42a5-9c1f-1ec9b3bb2f5d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     FractionBox["22", "125"], "-", 
     FractionBox[
      RowBox[{"4", " ", "\[ImaginaryI]"}], "125"]}], 
    RowBox[{"z", "-", "\[ImaginaryI]"}]], "+", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["144", "625"], "+", 
     FractionBox[
      RowBox[{"42", " ", "\[ImaginaryI]"}], "625"]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["217", "3125"], "+", 
      FractionBox[
       RowBox[{"506", " ", "\[ImaginaryI]"}], "3125"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["234", "3125"], "-", 
      FractionBox[
       RowBox[{"88", " ", "\[ImaginaryI]"}], "3125"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["496", "15625"], "-", 
      FractionBox[
       RowBox[{"1522", " ", "\[ImaginaryI]"}], "15625"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["54638", "390625"], "+", 
      FractionBox[
       RowBox[{"9634", " ", "\[ImaginaryI]"}], "390625"]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], "]"}], "5"],
    SeriesData[$CellContext`z, 
     Complex[0, 1], {}, -1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   Complex[0, 1], {
    Complex[
     Rational[22, 125], 
     Rational[-4, 125]], 
    Complex[
     Rational[144, 625], 
     Rational[42, 625]], 
    Complex[
     Rational[217, 3125], 
     Rational[506, 3125]], 
    Complex[
     Rational[-234, 3125], 
     Rational[88, 3125]], 
    Complex[
     Rational[496, 15625], 
     Rational[-1522, 15625]], 
    Complex[
     Rational[54638, 390625], 
     Rational[9634, 390625]]}, -1, 5, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->321497895,ExpressionUUID->"ecdf62ba-7f07-44c2-a2c2-e1199be2698d"]
}, Open  ]],

Cell[TextData[{
 "We can confirm all this using the command ",
 ButtonBox["FunctionPoles",
  BaseStyle->"Link"],
 ", which will compute the poles and their order:"
}], "SolvedExampleNote",
 CellID->11009856,ExpressionUUID->"5ebea7c7-1303-4f9c-8e87-dfe645ac4b0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionPoles", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], "3"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", "z"}], 
  "]"}]], "SolvedExampleInput",
 CellID->66131157,ExpressionUUID->"7facbbee-aa0c-4f30-a819-278bd0ef12a1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ImaginaryI]", ",", "1"}], "}"}]}], 
  "}"}]], "SolvedExampleOutput",
 CellID->14780997,ExpressionUUID->"f3a60420-addb-4329-aec6-e75aad68ffb2"]
}, Open  ]],

Cell["A plot of the function is:", "SolvedExampleNote",
 CellID->359750561,ExpressionUUID->"0fdec3a3-d39a-41f0-9300-073e9212793b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], "3"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["600", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[AxesLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, AxesStyle -> Directive[12], PlotLegends -> 
     Automatic, PlotRange -> {0, 6}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->163104435,ExpressionUUID->"2fbed201-ecc7-4635-8d9b-32b87b942c53"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJx8nXc8l98b/61CEUU0KBqURCqaOu8mDRVpaEhD0lDRkkQ2aSsiISvKyCgj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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJy0vXVUXNn27f8dvzdGdzqe3NteRdwd15CgcQOSQIi7e4gT4u7uTtw9WAKE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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxN3XWcrVXVB/CZOXPmDCDd0iDd3XDp7lAQkO7uDkEkpEOklFCQDguQEngV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             "]], 
            Polygon3DBox[CompressedData["
1:eJwlk8tL1GEUhj9H5/cdzCEtRbO8DF0wIy2prFQUL+FOsHCRuIkWrRIUAiUQ
3bisbS6S1hWkkZsUwlX/wrhwJ6hoJVjjDfJ5OYuXec53vsv5vedM9tno4MtU
CKEVFaFuC+FFEsJMQQg9cDFaJ65i0xm4ES0Sfyd/A16JIZQQN6RD+AJ/RmXw
Nhogfx/d5OIPxA/gdlRFPM35DviY/avklgpDOIHz6Cn3DaMD+BdKkd9Av+Gr
nBkjl+P8Nd2F1ognyF2Av/I7xN5N9A7+g+7w3ifu3xOzp4l4gvxd1Wb+LX2s
NcHv2fMYniL/Da5h7Tm/46zVwgVoEv5JPgU/QnO8P8/9/fBttJD2N1rgj5xN
iLfQXHSP5FWGM0/IX0S5xN+4BO9Hr/UHNf2F68zfzhPXwxG9LfKemPk36Fvk
8T14J3ot8mwX7jXvpWrsM79Dd70izsKXzVmeXjH3TN6pZtWumlW7PJE36ql6
K4/ltXqi3shjeX0YvXfrvHEE/4/eW3kWOFuOXifeswpzD+TFEvll9jab90Ie
3jL3WF6/Ya3Q/E7drZnR7CSszabdE3nTYD4bmtHr8DlUmfI3z8Od5rOnGe8y
77F6rZnV7Fabz5J6ot6UmM/+CHEGfmg+y5rhNvOaVbv+A/ov/IveO82wZvms
+VnVUAqnzb9FNav2UzO9afM=
             "]]}, Annotation[#, "Charting`Private`Tag$21546#1"]& ]]}, {}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNl0tslVUQx79r7z2HWBYu3BiCiW3dSG/Q4I5WNkIpFQMtAa4mtiXRhA0m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            "]], 
           Polygon3DBox[CompressedData["
1:eJwtkstL1UEUx8d+3ntcuHDbIiFx1yraim4Eg1aKOyFBuFtbuu0hoWJaaerC
R/f6QhHEBxaUaBqplWVpkY98lD3/BTd+vpxZfDjfmTkz58x35nLDrZrGCyGE
a5APXyyEZ+kQ5pIQ3qI3oYfxYF4IT9DbMM/4Jsmf0B+hj/EE+e3oNahLhXCD
9TfoGahJ+Z7P6O9whF4kv0saLkEx3IVWKIMO9o8R75jXvsKeVfQrKEUnnDmJ
fgjlaa85j95QfuJnHsMEZPN8zwp63Lx2BePXsaZqlzBeIq7Dy8R7OIE/UA1X
6WeL+B6uwwH5u8TH8CLxuV/Qae5dEfHQvGf1Lo960f8gIx8Y7xGHzL2sh6fo
KSjkLgvQoTrRC3km73Rn3T0HVQUh/GWcZq2dnFH0gLn3OqMZPQ0XU56TRZ9C
VexZvaumauvNd9DL0YsB1rvNPZJXZ3h4Hz0LtSn39IF5j+pVc1rbj3eTh+vR
g6LYwzviI3nIehM1c+hh87M19xXdEr3NRK/azHvpZe6D+R7t1Zvr7X9CZXxz
vf03uB3vqLv2mO/VH9Zf7jf/q7P081x/3Vzrj+qv3otvrTN/mHssr/UHfsOI
udeq8R/OAQ4kfXk=
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0rtSU1EUBuCFRhFMAJFLYhIZWoFeVAqpQMfGSrTDGU2QqygJIKDiKAUl
lxfAFxB9AX0BxRfQxqFgSKzs1O8MxTfrL/bstdbZp3d85u50Q0RscKkxIsmb
ZyN+nY7okYd4wCK7fOI7v2l1eIDblHnHe77wk38UT0VcZ4wK2+zzjRoZffoY
5SgVcdUMj+WsevNMREkuM8ETJplimhlmmeMp8zzjOQtUqLLIEsu8YIVV1njJ
K16zzrEZBvV+I+fUYTM8kke4Qjo5Y+6vfGCLBe5xjQJ/7b3inh/qQ/Wzekfd
U99S4hb9tFD3LQ/4yA5V7nODQ/3y5rgs//EudfcU5QL55M3IkaWbLjrp4CLt
XKAteS9ayJDmPM00cQ5tQouwcmgTWod1opY6+Tf+AwLAOBM=
          "]], 
         Line3DBox[CompressedData["
1:eJwl0Ekug2EAANDP6ncNp7F3AYkDcAZUi5gpFpWaWkOEEKFYGEvN8zzWzCm8
xOJd4JVV1VRUl4QQKikvDWEyCmGdDSZYoZ9W5mhjihgD5NlmhwaWmKeDYTq5
YoRl4mwxxgLjdPPIA1maKFLgnjt+aOSWAz7o4p0bfhnlmgzfDDHDNPs80c4e
l1wwSJpTzjljlkVypGjhmD42qSVBkkN6OaKZHtZYpY5nXtjljVfqOeGLz+j/
/Q+cdEfF
          "]], 
         Line3DBox[{2127, 1965, 1973, 1950, 1946, 1963, 1945, 1971, 2127}], 
         Line3DBox[CompressedData["
1:eJwl0McyQ2EAgNE/Wi6iRG/BjSiJ3rtEy1h7ATMegAfxqLroBGfG4my/xRef
X55eJEIIZ2SjEGJGGWGYDEMMMkA/ffTSQzdddNJBmnbaaKWFFM000UhEkgbq
qaOWGhIEfpMh/FDlmy8++eCdN1554ZkKTzzywD133HLDNVecaJc55ohDDtin
RJE9dtlhmy022WCdNVZZYZklFllgnjlmmWGaAnmmmGSCcXKMRf/f/wAYnCO4

          "]], 
         Line3DBox[{2132, 1968, 1981, 1980, 2132}], 
         Line3DBox[{2130, 2129, 1982, 2131, 2130}], 
         Line3DBox[{1947, 2121, 2122, 2123, 2124, 2125, 2126, 2128, 1947}]}}},
       VertexNormals -> CompressedData["
1:eJy0nFVUVd8brkkFAyUkVBQDEEVFkBD1NwGRUDqUEASku0s6pEFKSQEpAQFp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       "], VertexTextureCoordinates -> CompressedData["
1:eJyV3HucVlW9x3HyiqYeSbyEmiLmKUXTjpqmuI0IIk0UwtBMHUwNlaMgmYR3
MFFCzRTNlDSlOXgl8wL4yhTJG14ozAsMwowMzMAMVCqI18PhPO/94JfX8/Kc
+We/Ps/al7XXd63f+v1+a+3pOvjs/qdu0KFDh+917NDhf45r/g7sPXrwYY5T
BzSOmF5/e4E77vb0wmn1fyh535t3vmLCqOkl77PZ9AnT6p8ouee3mlvrOz1V
8rGXbt1jwqjnSj7jT4dcO6b5xZL/fMEfh02r/2vJz3bp+5spDXNKnjP1jZn1
nV4pef6xI5ZP7P1ayUve3myHCaPmlvzP6377jfFTGkp+f98DzhzT/EbJo08/
9bke4xeWPPbAfU+aVt9Y8viN339r/xlNJV/38l/GTml4s+QJd1y7c/dVi0q+
ZfgPHqjvtLjk276xR59u3ZeU/Put/zlvYu+Wku9a8Og5XepaS55y3883njBq
ackPXnjMzZ0mLCt5+pE7fWX8lLZqe+245MmOs9pLnrn0D4PGNC8v+blpF7R/
/PGKopaueaQvpi+mL6Yvpi+mL6Yvpi+mL6Yvpi+mL6Yvpi+mL6Yvpi+mL6Yv
pi+mL6Yvpi+mL6Zv2V4VfTF9MX1rjdPUNY/0xfTF9MX0xfTF9MX0xfTF9MX0
xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9C3bq6Ivpi+mby27m+M0dc0j
fTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9
y/aq6Ivpi+lbax5Nu5vjNHXNI30xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0x
fTF9MX0xfTF9MX0xfTF9MX3L9qroi+mL6VvLL8p5NO1ujtPUNY/0xfTF9MX0
xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9C3bq6Ivpi+mby0/
N/2inEfT7uY4TV3zSF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9M
X0xfTF9M37K9Kvpi+mL61opb0s9Nvyjn0bS7OU5T1zzSF9MX0xfTF9MX0xfT
F9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTt2yvir6Yvpi+teLQjFvSz02/KOfR
tLs5TlPXPNIX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTt2yn
ir6Yvpi+tfIKGYdm3JJ+bvpFOY+m3c1xmrrmkb6Yvpi+mL6Yvpi+mL6Yvpi+
mL6Yvpi+mL6Yvpi+mL6YvmV7VfTF9MX0rZUnyrxCxqEZt6Sfm35RzqNpd3Oc
pq55pC+mL6Yvpi+mL6Yvpi+mL6Yvpi+mL6Yvpi+mL6Yvpm/ZXhV9MX0xfWvl
/TJPlHmFjEMzbkk/N/2inEfT7uY4TV3zSF9MX0xfTF9MX0xfTF9MX0xfTF9M
X0xfTF9MX0zfsr0q+mL6YvrWyuNm3i/zRJlXyDg045b0c9Mvynk07W6O09Q1
j/TF9MX0xfTF9MX0xfTF9MX0xfTF9MX0xfTF9C3bq6Ivpi+mb628fOZxM++X
eaLMK2QcmnFL+rnpF+U8mnY3x2nqmkf6Yvpi+mL6Yvpi+mL6Yvpi+mL6Yvpi
+mL6lu1V0RfTF9O31jpL5uUzj5t5v8wTZV4h49CMW9LPTb8o59G0uzlOU9c8
0hfTF9MX0xfTF9MX0xfTF9MX0xfTF9O3bK+Kvpi+mL611s1ynSXz8pnHzbxf
5okyr5BxaMYt6eemX5TzaNrdHKepax7pi+mL6Yvpi+mL6Yvpi+mL6Yvpi+lb
tldFX0xfTN9a66C5bpbrLJmXzzxu5v0yT5R5hYxDM25JPzf9opxH0+7mOE1d
80hfTF9MX0xfTF9MX0xfTF9MX0zfsr0q+mL6YvrWWtfOddBcN8t1lszLZx43
836ZJ8q8QsahGbekn5t+Uc6jaXdznKaueaQvpi+mL6Yvpi+mL6Yvpi+mb9le
FX0xfTF9a+1TyHXtXAfNdbNcZ8m8fOZxM++XeaLMK2QcmnFL+rnpF+U8mnY3
x2nqmkf6Yvpi+mL6Yvpi+mL6YvqW7VXRF9MX07fWvpPcp5Dr2rkOmutmuc6S
efnM42beL/NEmVfIODTjlvRz0y/KeTTtbo7T1DWP9MX0xfTF9MX0xfTF9C3b
q6Ivpi+mb619RLnvJPcp5Lp2roPmulmus2RePvO4mffLPFHmFTIOzbgl/dz0
i3IeTbub4zR1zSN9MX0xfTF9MX0xfcv2quiL6YvpW2tfWO4jyn0nuU8h17Vz
HTTXzXKdJfPymcfNvF/miTKvkHFoxi3p56ZflPNo2t0cp6lrHumL6Yvpi+mL
6Vu2V0VfTF9M31r7/HJfWO4jyn0nuU8h17VzHTTXzXKdJfPymcfNvF/miTKv
kHFoxi3p56ZflPNo2t0cp6lrHumL6Yvpi+lbtldFX0xfTN9a+zZzn1/uC8t9
RLnvJPcp5Lp2roPmulmus2RePvO4mffLPFHmFTIOzbgl/dz0i3IeTbub4zR1
zSN9MX0xfcv2quiL6YvpW2sfbu7bzH1+uS8s9xHlvpPcp5Dr2rkOmutmuc6S
efnM42beL/NEmVfIODTjlvRz0y/KeTTtbo7T1DWP9MX0Lduroi+mL6ZvrX3V
uQ83923mPr/cF5b7iHLfSe5TyHXtXAfNdbNcZ8m8fOZxM++XeaLMK2QcmnFL
+rnpF+U8mnY3x2nqmkf6lu1V0RfTF9O31j753Fed+3Bz32bu88t9YbmPKPed
5D6FXNfOddBcN8t1lszLZx43836ZJ8q8QsahGbekn5t+Uc6jaXdznKaueaQv
pi+mb63vHnKffO6rzn24uW8z9/nlvrDcR5T7TnKfQq5r5zporpvlOkvm5TOP
m3m/zBNlXiHj0Ixb0s9Nvyjn0bS7OU5T1zyW+3MqXO7PqfEdS373kPvkc191
7sPNfZu5zy/3heU+otx3kvsUcl0710Fz3SzXWTIvn3nczPtlnijzChmHZtyS
fm76RTmPpt3NcZq65pG+tb5Lyu9Y8ruH3Cef+6pzH27u28x9frkvLPcR5b6T
3KeQ69q5DprrZrnOknn5zONm3i/zRJlXyDg045b0c9Mvynk07W6O09Q1j1+Y
+/gFzRMXFy+2brNv91UvF90mj+tUN21JyV86/9jfN8xpKbnn6COv7j1oecmu
f+2Kycd16/5qeT12Pd67T9dDBi1vLfnQBy9d/VyP9pLdH/fpv323GcNXlOx5
TV8sRnepe718HvY87Hn4a80P/6hft7aS3R+vrDvjlY6z5hdtT758T6cJ84rN
J97w5VX7N5X8b0NPfmx4vzdL7nzoXgOWD1lUsvph9cPqh9UPf3W7tpfmdFxW
svpiR/XM4/9+Erqw5I1feu76UV0aS/Y+2Ptg74O9D/Y+2Ptg74O9D6Z31ls9
86i+WP2w+mH1w+qH1QdrX6x+WH+sVS/Px56PtQf2fOz52POx52P9tZaO6oc/
/9mVS4aMaS5ZfbH6YvXF6ofVD6sfVr9a/Ur/TB2x98Lqj9Ufqz+mN1Z/rP5Y
/bH65zhQD/XF6ovVD6sfVh+sPlh9sPrgtDM5TnNcZD/NcbzrI9ve+mj9L8uj
+R57PjZvYO09/d6Whh7jZ5c884iLNjlgxt/K/qQcKzcelGPl6p3MD/AeyrFy
9cGeb/7yPGx+zvmNn+H+2P2x+2P3N3/R3/3pj/U759Md8yew+ub8mHninJ+V
qz9Wf6y+rudvYP4G1r9yPl1nP+Ha8a8c53yq3Ptj5blupVx7YO2RefL0HzLP
mv6Ecu2D6et8/hmmLza+k72/8ZbzvSP/Nf0Avxv/yrVv7qtJf0Z52hntneuC
yp2vHtpfufZOfyjz2OkfZR40/aXMoynX3uk/pf9R7kettL9y7f9p/TjbHYsf
0h9z1P7p9ygXX6S/ply8oVy8gemT85br6aOcPpgeWPtj7Z3+nftrb6y9sfbG
5pNs/0+zE+nnJuc+wNRBu6+zz+oTv7su/ZZ11v0/4cc4n71Rnn6D/q8cu17/
V46V6//K18mTr2XlnrfO/xP5RHumncDi4WyH7Kf6pfZL/9jv6Ze6zlF/Vq59
sf6cfo37a79c50r/3/O0l3L9OeODzMtmvJB5vYwflOvPGU9kXkE5fTLuTH8/
OffPpd1IHZzv9/S706/F9Mhy96MPpk+uO6YemB5Y+2e8lHnUjJ8yD5fxlHL6
YO2fcX7Okxnf5P425Wm31SP1yHLsPEf61Prd+MnfM55yf3ph4yXjw1wnVm68
YHpl/Jh57ownM0+a8aVyeuH0C2v5LRnP5X61tPPayTjNeNX19Mp2z7gV51H7
574K17HnWHtj7Z3xbq4jZPybeeiMh5Vrb5x+efqBtfzI3E+WfmPuL8v2z3k0
95tlv8b6M9aeWHsm00V7Yu2Z8XsZp1baM+N55doz/QRcy4/Iea5W3ivzPJmX
8n7Y+2Hvg9Uf069Wns3zcOYROlTyC7jWMfMMeR32HOsE9MXeN8vlA5Qn57qv
+Nw4EO+arzC9ct+sceN+Gf853/vldy/GkfvVGnfun/FPxjvY89b5Hmxt/dMP
xPTNcYy1H/Z8rH+V34tV6oPVJ7/vUq+sp2PuS007nv5zfl+U/m1+d5D+q3L9
L9cBne/+6Y/ldww57+e8gt3POE8/u5bf4Hd2Pvf1OY8/hj2vVhzkPJx+iPbP
fWXO87zM67hO/bDr017TXX/D+lu5v7rS37D+lvNT2l9xM11zP2zaW+Xqh9UP
q1+5P7hSv3yednB/nHlZR+9Vrg9X8qPajz1Tjtkz7Hz2zfmZn8x9bBlnGrfa
KfNY+Z1mrg+lLjkPYeMRG++5DyfX+fJ7woxzc17G9MX0xfQtv5+s6IvpVMvv
Uf+MJ/O7t4zf8vsq41Q/x/TOeCe/78j7ph3JcY/dP+1HxpG5D1E7uB7TL8tT
F/1iwfi36sY0Ly6OX7HV7nXTXi0WnfDYyo8/XlKy8h+Nv/O7g5a/Xpbj1r2u
HDeqS+t65f+519d/2q9bQ1mOl783YNdV+y8t+Yk/frV5Yu+FxfnPvnRb70Fv
FE9d9uHILnWNJbseux673lE5dj/HuY996YWOs5pLdj5+69kvPDS837KS372p
te/yIW0lf3T6g28MGdO+XvmsY57ZasKoprIcb/i1i89tnri8ZNfN3vVXd3Sa
8GZ5PXY9dj323n9f8cODxk9ZVL4ndn/sftj12sH12S7J+sHgdwZ1nzF8SXHs
rr2uaZ74SnHazG5P9BjfUrL2xGf9avnAafWtZX9y/cmPvT61Yc5r5fXY+dj9
8Al7XH1j70GLy/7jfkNOOLtpTsd55f2w++Hz9htz8ZSGZeX1ftcu57630Raz
eswvj5/2+0U33XzAjOEL1uu/zuu14033N8yp9u++Swf3GrS82r8HjH13aL9u
i8rz6YS1O/b+rvf+yrFy7aEcK9c+yrU3PmfwtKX7z6iOt1Ed+nXuvqqtZEfv
mUftUet37ZH91nneF7MHWP0wfbHxhY0HbHxl/bJeWPtgz8PaB1/y0ucn13da
XrL7G8/G2VHT9n59Tsc3y/dVzp4q9zzlnqfc8/DPJy7q0a37ipLpqt9lP9Sf
Uwfl2gMrd773VM7uYe+D1R+rf44L7eT+WP2zn2D1xeqD3YcdGPT9JzeY1aN5
vf7OXuhP6kWPtAeO7Gut39XX7+qLlTtf/ZSrP1ae8yF/znhxPna+90y7hvkP
WX9+y6e9l/o5H+d87Dr+Tr6P69UfK/d89i3tEL8b5zqN87F+x/6kPXCeehuf
3s/5+lmOL/5fLR1r6e657pf9mH/qfP0Ae+/0B4wPzzMP4YwD9BP1SXYdvzT7
X97P+2Q/WXjhRe1/qr+0PHbc5Dsd66atKDn7Mc75TTth8ZbxneNdOb3cz/3V
Xz3TbuX8jfUnLJ7E/NH0Q3I8pl3xu36X4zD94/xuKu+fdijvk/OlfqU9XK89
sLgmxyv2/jm/5vyuPN9b/dh9bD5U3/TPlXsOdr3xjc1Xnp/zpXbwHP0bK9fv
sh+lHUn7YHxifmCOkzyyO/mds3GX913nu6S15fRRvs53LWvL6aN8ne8i1pbz
x5SzT/qP/EH+f5Tcr5f5IvlpnPu1kvP/ZInzjTv2QjyvnM50U9/c/5T2xf3E
98rpW8tP097Ktad20J7K6ZvfMbPL/DH9PPNq+pF+LH7Azvce+ov3yLyc5yl3
f+NAPie/o5d/cX/j0fXGI3uu3P3y/yxoF/ZIO3uecs9Tzn4bv/Io8jrya7le
rLzWPOA51m2MW3ZY/9Kf87sc/VE8o3/pH8r51+nn5Xzkeux69tn1OPenuZ9y
/Zu/7P76K/Y++rP3cT/1z/yP8/VjnHkPOmQeBOsfGR/n+HN/75PztXY13rHz
c97MPE7GYcrVP89Pe+164wOv893/2vONR+XGN17nO/K15+sPeb52p3/O57Xy
fBnnmD/Tv6i1zpZ5L+2TcR9Wf+z9sPqzP/zTzA+mf6J+9HU+Vu5+dDc/pH+T
17Pfnpv+jPZQnpzrdK7H7GXG8cZH+inJruffY+3tfP0hOeMp5doLa4/kXIdI
/8z8oT2w/se+6+euV3/vo78rZ/fY+1p5vNyHmvFf+nfKvVf6h3RhV9OOZR4j
95NkviT9cuerD1bOzvAjzVvuk34sdp/Mn+S+GPU2PjB7ivlv2P3oqjzn0YwL
M0+T+2KznTJOrhU3ex/l2Y78E+U48yd0UB/2AStnv9K+Gi84x7ty/RRr15xX
8j0z3sj11ozTO8R3sxm/6w/GP/9AfIrplOMMm88zn43dL+fv/H+53pMdxp6X
8Xf+Xzd6mm9y/sj9tBnfKnd/9pzO+X/jMh7O+JW9ynkz+4H3N44zrne//H9R
GWfSWX/L9eycX9Wj1nei+f+59E/+pPUn86n1J+1pPYm9sH7p+fqX/sJuZFxv
/srvGXN+M18YJ9rB/OK+5hfl2t/75zqP91N//TD9be2m/6W9rPWdTK5jpZ+d
/bLWvl6c6wy18oTJuQ6e8aj2Np6VG0+Z53I+e4zpkfuv0356r+wX2iX3JdHT
880jWP9VH/elR67Tak92GNeyU+yD9pY/UZ5sfOW6pXqpb67D5rqk/qb9sPuN
O3jgm0PGtBZ79vrg4fpO1fqpP1Yf/THXWfUX91u2ap9beg9qKu7f9rzJ5y9e
/3upX/z893PGt1T/79CidxrbF68Z70efMnrI5GOq++923uDmLScdX92foj9t
fdhG9w9Z0Fhstdew13bq2lpM/fLmna7bt6E4/NoVjx5+ztJi5yWn3LXg4abi
7euPOPCp85cVL+z0zjWtdzYVt7300KyvP91a/PXlD194pc+8Yt64IU/23KWt
uPO8s1fsOXFeMWLnu4+ecmdLcc092+w15az5xaxDPzx5+Zy2Yptz6yb1W9VQ
3N15jy/t/+X2Yofbu4488O35xdQfntT5pOtbip+0PrHH6uMaiysnt135+n7t
Rf+ZB3zxqq0ai4YfH/WXSdu2F6d1+eiZ23o2Fit373jKLpNbi56P3/eZfX/W
VPzXYZtuOKdxWXFTr2+NO/e8qv3a4KEBl47pUrUXt474wW+2enxe0eOQfb+x
5bj14/3t/1V387FtDcWIoWNPPuHxtvXmzf/retjEeXvuvtHY6vdW7z706wnt
p7YXV33w0l+m37+guCz8sumnv/P+9wa0FEO3rrvriksWFmfPnDTqgoHV74EO
n7Tjppdt2Fr865zZzxyzcVPxzJXD5zy/T/V7lOEPjD79iYVt630fM277dz9u
ObqpeHWfpb1uPaxqD/SX7Z5cct/S25qKsb0/d+CDR6///UXnLTd/cOmg6vcZ
Tds9+v1fXt1Qlj8xdVL9gt9Vv9P6IPZ/3rTFghv2H1tdD/Hex944+4jT/9Sy
3v7K13Z8v+Hwp6r+YONpm8zstG1zcfzgba/b7IfV/V7P79jct363ar7wg1h3
8fyRF7w48NF51Xy/4yVPn3vQ4Qe1FQMu6f/hkr5NxfIvzn27fXhLccYmpxy8
+BdvFPsccNKs4oKWYpO7ez/0nQPfKO756c333d+/vfjXnhddvNvvFhYjuo4Y
+NtZbUXPz469fNaMxuK94fNu2G1aWzGsd9cRg39b3bd61Mi+pw09v7nY9Mpf
XbP9XdX1sHE3vrDysr2r8dJr967u1f+ApcUNK7v9euc14/ewYZt+9Mia+HHT
vq/cOnANv33ijw496ZttxWmPfOWE/V6ZV3zmzdvHTBnWVpx447OfmbVNQ7HZ
iyOPunN+S/HAYYt/udPMhuLykftc/8gVbcUrz9Vf3XWLpmJ24y2H/uPH1Xz1
d+8/4b2hde3F1u/P7XBHtzXzX/9j7tnmuPbia8/esP07w6r73bZfNvvau6dX
/5/Bh/8xd9wfnp9bHH/C5j1eHLZO/vXKjn3Ourel6PXtpo+/fWl1P9t9H9Vd
durNTcUdZ977eMvQ1mL+vEeOvO/+av5t7IAjr/3rOWv8kz5PdZ/6SDXfdtUl
fd756cxlRc/HWlb2OnheMXXvGWeMPLqa79lk0qk3jjyxpXj0uC80HbztguLS
jvMab18zXr69dfe3VzcuKI6+ZaPLV5zcUuzz1vnnXl2/sBh8+w5n3nTWmvLD
7tj4srcXFie+O/vpgzZsLyb/7OK9/31oY3HGu1uM7dCvtTji8l6f69SnqVi5
6sM+193eWgx8+NUOZ/+kqVi9/aUHvbn50uKJ/X+zcvKkNXFsjyF7fDR6abHo
vB3mPD+tqTjlykl3bNJhWfHY+Q8+ffoa/kXPG3a5bN6yonHw6/ed/rNqfD9t
4mljJo9sKv7xnc7Xnvbranyzx449O4y4d2nx9xcu2bL/grnF9XUXnvnAq0uL
ricuWfja/LnFBX0vWvJW52XFN//244bOa+zx6jG3/nm/gcuKExcPe2Hgh3OL
Qxrnnjq7z7Ji9VVLvnnN6rll+65+YPereq153jOT9nhp+L3V+euaXgOW7LVt
df+4+nU6/shdPvpeNV96z4WPzPr+dlX/4Y+HLP7719e833ktHTpfNKq16NB3
9JlfrWtazx58Wn9Ne5LjJ+1vzh85/nM+SfuT82Ha4//v+Mj5NO1D2p+cz9J+
5/yW/TPte9qfnM9z/Kd9T/uX9j7n0+y/2b9zPkl/Iftv2pccPzm+sv+lf5Lj
M+1P9v/0H3K85PjP/p7za9qPnG9zPOV8nvNfzo9pX9N+pP+U9jntX9rH9DfS
H0n7m/Y27XHO1582v6a/lP5jzg/pr+X8l/5y+rfpD+b8lP5hzlfp/6a/mfN3
zu/pv3+a/c/5N+19zgcZD+R8mvY+/fecH9J/S38q/dn0j9M/TL85/ef059If
TH8q/a30r/4bwuyH2g==
       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
       FormBox[
        TagBox[
         RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
       FormBox[
        TagBox[
         RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
     Directive[12], BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, 
     Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-2.999999793103448, 
      2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 6.}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], Automatic}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ
sjR2QkWWzuFw7Fs6lrN9z8I0aJoa5vz+gN+L+7qe63lxv7rv5/NoeVw+dkFM
REREVKgLQv1vLhkcHStV/ACqx1peSgYLohaxiqa7OOARS/czAzuhHqXg6E5j
wmuquYvUwMG/4eFBv3t249lSV3SxFBNq8enKW0HAbrMqP7GCBrkZZ9YZKwac
Q3rZaW8ITKffkax/24PGxBUyRyOm4dAycTdkLxfiK1qKf0zvxSnx/qsnyqaQ
KOe0ee41F8sl+243mPdhb3K4mzV7Env6F+R1zXhgXrC+NFjVB5m1NM6Y6iR6
OKfVt5XzwE0smUiR7cfdS80Low4ToLlmzKrr8xEkf2bxxf5+zBcpywqi6Yi6
LW8oX8BHb7YoCMd+/PTH0Ycu7p/wfZtOO0ldgEIdG8JrYQCygS8/b90zjsNu
qrOJKgKcFru1filgCP3BHxzFlD5ixyF2yPg6AR56hl3Kah2GvI+G9uTkKMpX
F49IrBVAfpXl14Flo3hWt8s+o3AEWfdEU5crCuCpcSaMsWkMdzSOsgo9hxHi
8UV5YpUA5by5xr/NPmLJbcOfuxWG0NyuzUuXEWDLiZrkdLNxeKtYPxL8MYCC
Q0+idFYKsMlYRrRJ9xO6yHnl2ejHbo+NR5IkBPjx9BwnRYKO+cL90hLVvajk
/d01ICqA/1aLG0mBdLyeySMpK/Tgp3Txa1//5WNp3+dDDI8JhA7ekCF50MCQ
9hW8iONjuO+GcajtJK4+PBmkV9ANnYfdytWKfBifyiD9rjaFbq2CJF5NFyz8
wnZqPOZhplA5+0diCkleVZWmElRYBZvFTOvx4LCpfIlSPI0EdpQ+U68DX9bY
2a+o5iLk2qqjjhcZWOih59hqkVG6XffPeCsurjFlmvrUmBCxmfPuGG1DpN/j
scBuAk+d/gla08GEZ0K83ya7FrzMabhT4ybM1UFBUmMwCxxNvdr3lk0YdBb/
7TyXA27xCRH3dWzcL1oh8FRvgD3zScjVMA4iZo79RUtho15bt6Kyoh7k3eT+
H8LYWOmCFDsJDhqbVdRiLtYjnmtsoxrOwjqLhX/9AznQzLx3gmNRj7tj2/Sj
IpkI+usxfbiPg30WLl4l2+pBpxnydkUz8L1l1FLJiECVlN990731yGPYHbO6
OY3MCql7qfEE6K6L5FTfeux9lTGXED+FLAMTommcQKvzFcUbZfUIa66xl0md
RPzxd4Zi+lyMJZffjlNqwGJncFL+wwnoldeHF13lIsE/RXsmoQHF5iYb9+bT
sX618clV9Vy4lmVYT2k0QsyNQzonzHXqLvKsGY8L2bfDbfm0d3Dv854njX6E
z5aFg19IPDifdPButXmPFPVDq3qcxpCdkK/kY8MDAymR3rGtyEsSUV2gjqAk
5pTH8wAekj5XLRzPbIeT9SC1w2YYC5oCalc6D8TgWuVb98gof5uwyrd2EIYG
d/L/qeOB/bW3zvBiB4zMXT0e6Q5Ajuwpum+cBymj868HtlORvm+DCC25D5EJ
BFG1xMOve3adoU53QeKJ1DH25x642NF+vqLBh4GipejJlm5IdlylCQ7QYFHt
9j5pDx8J+wNqm5Jp0NZRjLTS6IKeqrNz7jU+Sqh+vKprfYijbkwRPU1FLWvg
4Lc6PnI7L4i66A4ieuXNWfdfO1G2+chCxjwfAofrl6WeD+OBXKrvyVsduMJO
2uOvLwB7w5+dR5ePoa732YjWZQq+GfvFXPIQ9ps6+83wyDgWe1lZE0ZkyL6p
yUlKEyBxZY+noiUd5+QcF7ZR20Gx5g19aBYgwGDnmKTzBGoWPYssTdog3UYM
ycwKoNBWutrr/CQe2no3RLu2QD5E7ZE9aQbdXeWR1gFTkCDFvczc0YxLXQ98
IjCDotqNBhHB0/iW0rWFlPwWTt1bfJoHBSDFHohMXc8AOef9kMWtN5CeWp6Y
5S+AYDRKN4nKgJybsa0MpQHzpgo2FGHvT2gRhWNXmJg2+sX/LPc11uTXD2rG
81Gz9PvGfhILTJ6JjR29FodfFFS5KvFxQdLx+Ic6FkJ1ddi7c6tRnKHzm3kW
D75f3mUtnmSjqeF2RrpaJaIpDxQChLkKppoN/jHHBvv8mewIqzK4FfsN5aVx
ET2fULcugYPkZ4Gm58eL4estGnpFiovep2XjHjoEnrcdW0+rzwfXUio9IpxA
oajxq7o6Aopirc1PN2SCEjJyOMOcA1GKmWl1pbBPwbHpHw4/giepMSpwjoX+
oV/Xrysh8MCIbNDgk4tmmYCtDQVMGDiN+/CfEphxj/u+fuAJMnLn+b0ODER0
L9O2zSBQyqg0ifHJxyfG2vkY/hTusZrydsQR2DJHiaxYeA65BT1qZ+Qk8h7z
Y+quEnCXsPHSj3gBBf+KnZFf6fhZs7Fq1oPAoR9C7DPmi3CqJDA1rW4c209r
pnyyJzAvVdjScKEUd2t04+MsRiEnzRtOMSbgvyPn0TvGK/gEqOz47DSIWj1T
6hplAmk1+0b8FcuwR61pzPbxAGJzqsklMgTCWyQjrJ2bYHCDe/jvoX6w7t1l
eC5xoN3YPsytb8cb8y38QpF+HB/Sdtr5WXi3VrLoViuokLbarOKi2IfwB4nH
NjE4eNxy/bqDKw1MidVjOrK96Dp7k2Q2JOT9N4kGt9he5IqnhlLYNKhaHGBf
pHAwUVGQkxPXDy3HO2xGTjdIr3KXGho5OFLuizNXBkG0qX8cOUAFOajziUmZ
cL/98p5Kh2GYcTUk13WRofA96IeefA78szliH1VGMVNaaOaW2IqU9sT8tCwO
TqWuLZgcG4NqqP5p8dvtqMoZuK7nxYHOi6zdy4Scyzkb+EvZcjLmzn0oqjMU
+iTcj+suo6Pp/TJ7QpOCWCMXL7slNlYHuRVGdEwgfFHJfBudgv37iiR7KWyI
1RRLmkxOQjXbKZh7sAORafvFz2ayocRxPcCcm8Ji6eSndvcOtHaZcGfPsxH2
yF3SRoKBQmmyHUmzAzESt3ziDNgIlX/dTFdk4rvmOemXNylQkfWy3bwo5IRt
uf9WLRYOXIuInrxFRm3Y04ABMgumDi+1buqz8f/+q/8A5ejSSA==
                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->177664873,ExpressionUUID->"816e0727-8167-425f-b8dc-f0b02a4903e4"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1541765316,ExpressionUUID->"b7fe42af-814d-4702-a532-0ebbc1919fc4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Meromorphic Functions", "Subsection",
 CellID->101876808,ExpressionUUID->"b1b67ca1-de3d-4dfe-8e16-00e82b4c52ea"],

Cell[TextData[{
 "A ",
 StyleBox["meromorphic",
  FontSlant->"Italic"],
 " function is a function that is analytic in a region, except for poles."
}], "Text",
 CellID->26475499,ExpressionUUID->"82deebf7-7f5e-4f01-ba9f-136bdde4e33e"],

Cell["\<\
The sum, product and quotient of meromorphic functions are also meromorphic \
(except when denominators are identically zero).\
\>", "Text",
 CellID->54911284,ExpressionUUID->"1790ead6-33e1-45d3-9ed0-366012695710"],

Cell["In particular, rational functions are meromorphic.", "Text",
 CellID->174933861,ExpressionUUID->"be5352a7-8cc0-4994-b5e4-91298dbd93e0"],

Cell[TextData[{
 "Theorem:",
 " Every function meromorphic in all of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath",
  ExpressionUUID->"7e30d125-9f42-4be1-9075-0132c915d100"],
 " is the quotient of two entire functions."
}], "Text",
 CellID->60984686,ExpressionUUID->"75bfe403-f0da-4eda-905d-8a7107cf53b5"],

Cell["We won\[CloseCurlyQuote]t prove the theorem.", "Text",
 CellID->337777854,ExpressionUUID->"2bb80730-7ebf-40b2-975c-0f819337fd83"],

Cell[TextData[{
 "In Wolfram Language, the commands ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["FunctionPoles",
  BaseStyle->"Link"],
 " can help study the poles of a meromorphic function, as shown in the \
following example. You can also test if a function is meromorphic with the \
command ",
 ButtonBox["FunctionMeromorphic",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->14474159,ExpressionUUID->"c0b152a1-9ea4-471b-be2a-3bbe1001898f"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->315542404,ExpressionUUID->"ef1798b3-8660-4c12-bc01-2121e01f6a09"],

Cell[TextData[{
 "What order is the pole of ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"sin", " ", "z"}], 
    SuperscriptBox["z", "3"]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b73ed247-ddcd-4263-bbab-c5a94b9aa556"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "63b6017a-90d4-4813-ab2d-d6fe88b1730e"],
 "?"
}], "SolvedExampleNote",
 CellID->146664469,ExpressionUUID->"a969dec2-97a6-4fba-9a81-e892893e5f49"],

Cell["From its series expansion:", "SolvedExampleNote",
 CellID->208591530,ExpressionUUID->"acf6e60f-6b17-47e8-8408-d0fd45ef0ee0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "/", 
    RowBox[{"z", "^", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "3"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->5852404,ExpressionUUID->"20b0eafa-3554-4f1e-8773-5163d60c5a13"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["z", "2"]], "-", 
   FractionBox["1", "6"], "+", 
   FractionBox[
    SuperscriptBox["z", "2"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "4"],
    SeriesData[$CellContext`z, 0, {}, -2, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120]}, -2, 4, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->288901,ExpressionUUID->"c19d6d2a-4f16-48f8-a4c6-5d39350fc0ee"]
}, Open  ]],

Cell["\<\
you can see that the pole is of order 2. You can also check that:\
\>", "SolvedExampleNote",
 CellID->231118075,ExpressionUUID->"5768ba03-9f82-49f8-88f9-88955a32c577"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "3"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", "z", "]"}], "/", 
      RowBox[{"z", "^", "3"}]}], ")"}]}], ",", 
   RowBox[{"z", "->", "0"}]}], "]"}]], "SolvedExampleInput",
 CellID->141728963,ExpressionUUID->"6f0638cf-8f23-496a-9c5e-7e24c7455ad7"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->82907011,ExpressionUUID->"43c09dd9-3717-4f0d-b3cb-56139ed11a4e"]
}, Open  ]],

Cell["and:", "SolvedExampleNote",
 CellID->49892458,ExpressionUUID->"3e23fccd-7854-40b4-a164-5194cd609236"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"z", "^", "1"}], "]"}], "*", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "z", "]"}], "/", 
      RowBox[{"z", "^", "3"}]}], "]"}]}], ",", 
   RowBox[{"z", "->", "0"}]}], "]"}]], "SolvedExampleInput",
 CellID->522371092,ExpressionUUID->"24bd3663-c94f-449e-b02b-89317dccb52f"],

Cell[BoxData["\[Infinity]"], "SolvedExampleOutput",
 CellID->380290444,ExpressionUUID->"048cc7e3-2864-4d7b-9aa9-dcc7c0c0bb71"]
}, Open  ]],

Cell["\<\
further confirming that the pole is indeed of order 2. In Wolfram Language:\
\>", "SolvedExampleNote",
 CellID->127504017,ExpressionUUID->"32eb35ce-aefa-4ac4-ae54-d6cc083a09b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionPoles", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "/", 
    RowBox[{"z", "^", "3"}]}], ",", "z"}], "]"}]], "SolvedExampleInput",
 CellID->669224029,ExpressionUUID->"900cdeba-d0fc-4df1-9db6-1647afb3dcee"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2"}], "}"}], "}"}]], "SolvedExampleOutput",
 CellID->33186933,ExpressionUUID->"a497d705-2faa-4df9-bad0-3f1dddccd6a3"]
}, Open  ]],

Cell["and:", "SolvedExampleNote",
 CellID->7321489,ExpressionUUID->"cabf0658-547e-4f73-9207-1533d2777c44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionMeromorphic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "/", 
    RowBox[{"z", "^", "3"}]}], ",", "z"}], "]"}]], "SolvedExampleInput",
 CellID->297521535,ExpressionUUID->"7670eaf0-1ec4-4ee8-83b1-f0b80c9a28f5"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->363260929,ExpressionUUID->"94413db4-c082-4129-bce0-04c2d1c97156"]
}, Open  ]],

Cell["A plot of the function is:", "SolvedExampleNote",
 CellID->818762792,ExpressionUUID->"e87168b4-f63d-4f32-a0d7-0ae41b94b2e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "/", 
    RowBox[{"z", "^", "3"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["5", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["904", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[AxesLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, AxesStyle -> Directive[12], PlotLegends -> 
     Automatic, PlotRange -> {0, 6}, BoxRatios -> {1, 1, 2/Pi}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->142029234,ExpressionUUID->"5081510b-7cd1-4664-be43-64868aa612ad"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXmcT9X/+AfD2HeDmKzJh8qarL1vUslWUXyQVJYwyb5kly1FIgyyDIns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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJyUvXdUldfWPfyO3zfGTWLsKTe592CLsXeqFJUigh0FC4IFe8Pee+9dUewF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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnHn8V8P3x9/v970fsu/7Fik7bRTaV6WFlD1aKFSy86XIUlkisoQWWZKl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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkrdOA0EQQBduF2EoyCaD6Mi5sMg5Jxsw0Y0lCkDCEi5o+Cv4DJJNFOEL
yLnljYbiad7O7c3uzF1VNBbaSTXG1IOFdGfMHrIFfjwAfvLt8Etul3WcGAAf
fk88TDFmjVjBuhtCnjHz0IOXQ5RnB+y5I5Y5fVfeuSXmsk7gHXge/kBMst4m
VrL+JrZydgtc4U9Qg1fDMd7r9KwF6MP7nfoiDOCDTj0MQ3gBRP7PyMeLnN4t
TK4YL3Xau9ypBC90eheZiczGwYbVnnLwNNi0WjMbfybWGr3jCf4CdUZzp/gP
tBnt6RrPcNq71JTaX1Z7bYZLPEhunbtHIIS/k2vkWQMk8U+re5vgAv+w6rLn
3OqMZFY+OMI7qRH09Bt14ZlOe4//f9ssp99SepLehp3ObglG5K4Q87SG1Hqz
ehf5fxL4q1WXns/wWannaQ9z+DSsepqbwcdhGV+BCXzSqcueKXzU6dmyZ8zp
Pyj/oszwxupMZDb78Mj6D26ESBo=
             "]]}, Annotation[#, "Charting`Private`Tag$25596#1"]& ]]}, {}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJwtksdOQkEUhq8wExIbFtyLvfcSgk9hC2CJIhgUxYLdhRHfzB3xCdzY+xvY
/Y5zFn++f87MnDL3hpMb4zmf53ljyI8WrOftGc9bhFNoGz8N0+gMvwyz6ILD
azBqXDyE4sbFz1GCvSKcgeuowF4OxozLGTSuTkLvJq3jEpxDKfy8dfviJdc7
3ITXcFV7yOqZotadYH0M34yrLfFZGLCu5qR1NaRWCo6iOuaOwLyeCWif4iVn
p8Q506XzhjQuuWPqgzq/+FPj4rLfy51q7vbBflSDH4CDqBY/BDPG5ZV5mlmX
E2+BjagM3wTDqBTfAFtRBb4Nnmhdqd/Nuop4D2xHlfgOOCzz4kd07oT2Wa85
Jbe8l7ybwb/ij/B+/DP+AF+Cv9L3//8OWntL3sq6mePW9VLQWURRrRXRd75k
ndGZV+ALPGTfh7+VfwP/CR/l/8D/wjuUx3/Be7SD/4YPaBf/A2+kF/wHfEL7
8jOT8w8Fr062
            "]], 
           Polygon3DBox[CompressedData["
1:eJwtkUdOA1EMQE3me0MLJRyAFnpvC26BaImoESUgSIXQFgg4HeIOiF6uQH+W
WTzNs/3/jO1pzeRncjERSUKAPRW5iUQuCfbxUWgi3wxj+DyUqC3CAj4L8eC5
OfyXZ4X7h/CE/wT3A3jEJzmT4F0tMIXH4ITaMbxSj4hPI8+9EX9BGS/BPR6o
n0V+5p24Sv3uEbwQdxPX8e566MFz6rOkII+L+lnr8Zlcr/rZOPSpz2SzXdiM
eL96rQEG8JR67Zr7aXwFNojTsIoPqp9thCF8B7LBd7qLD6vXbKcjeBHOg++w
jI+r79p2NIF/kC9ytwC3+Ba5K57TsK3+Tft2Bdbwz+C7sjt3eJJcrfhOuvAO
qBHPdeJtUC2ea8e/g/8r2/nD/85sd9ZjAV9Sn91mXlbvwXqxGbP4unovCcjY
btTdet7E/wBM3zzW
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0jlPVFEYBuCjiEsC2LmxhRad3gyMCqgsgwhUAp2FDoLQoSTsGPwDLJ2J
CoWaSILwB7AFZBGk1FqdGUQQC5VnYvHk/e7NyX3vOfeW3O1u7joSQnjO62Mh
ZOZJOZkVQrE5Rhu9TLHABjuctjhCnHaeMsN7vvCPwqMhlNHCIyZ4xxopcvVc
pJZ93uq+L1/IPZmgnQd00MlDuugmmu35lBPjCle5RgWVVHGdG9ykmhpqqSNO
Pbdo4DaNNNHMV+/Sp6ufAQYZYpgRRjlg1ron8pWMcM9cQyk5JO13lTnG6eEO
UQr467w+s8g0YySo4xJ5pJ37OvOZ78RjWinnmY43eovML+Uf14XmAvK5wHnO
cZYzXLa/X9Zus8+nzLmzxU822eUjP9hgh3XSrJFilSQf+M4K31hmiVO6TnKC
46gNbgevGGw9/M76//8dAtxHUu4=
          "]], 
         Line3DBox[{11, 10, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 
          1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 
          1331, 1332, 1333, 1334, 1335, 1337, 1241, 21, 20, 19, 18, 17, 16, 
          15, 14, 13, 12, 11}], 
         Line3DBox[{1247, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 
          890, 891, 1363, 1258, 1284, 1257, 1283, 1256, 1282, 1255, 1281, 
          1254, 1280, 1253, 1279, 1252, 1278, 1251, 1277, 1250, 1276, 1249, 
          1275, 1248, 1274, 1246, 1273, 1247}], 
         Line3DBox[{1394, 1291, 1305, 1304, 1292, 1243, 1309, 1297, 1285, 
          1290, 1299, 1298, 1294, 1306, 1307, 1302, 1288, 1303, 1311, 1245, 
          1272, 1300, 1301, 1296, 1286, 1295, 1310, 1244, 1293, 1242, 1308, 
          1289, 1394}], 
         Line3DBox[{1384, 1383, 1382, 1381, 1380, 1379, 1378, 1377, 1376, 
          1375, 1374, 1373, 1372, 1371, 1370, 1369, 1368, 1367, 1366, 1365, 
          1364, 1287, 1395, 1393, 1392, 1391, 1390, 1389, 1388, 1387, 1386, 
          1385, 1384}]}}}, VertexNormals -> CompressedData["
1:eJzsvPc71+8f/y1FpVJGUnYlbUIa5IxooFRmg1QyIhKyFWWksrIVshKy9+i0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       "], VertexTextureCoordinates -> CompressedData["
1:eJyFnH2Uj1UewKeWmvRmekEjR1KtltIL2tJ42MOkTdnoWGe3k6aNNttS0oZB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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
       FormBox[
        TagBox[
         RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
       FormBox[
        TagBox[
         RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
     Directive[12], BoxRatios -> 
     NCache[{1, 1, 2/Pi}, {1, 1, 0.6366197723675814}], DisplayFunction :> 
     Identity, Lighting -> "Neutral", 
     Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-9.424777310784693, 
      9.424777310784693}, {-9.424777310784693, 9.424777310784693}, {0., 6.}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], Automatic}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ
sjR2QkWWzuFw7Fs6lrN9z8I0aJoa5vz+gN+L+7qe63lxv7rv5/NoeVw+dkFM
REREVKgLQv1vLhkcHStV/ACqx1peSgYLohaxiqa7OOARS/czAzuhHqXg6E5j
wmuquYvUwMG/4eFBv3t249lSV3SxFBNq8enKW0HAbrMqP7GCBrkZZ9YZKwac
Q3rZaW8ITKffkax/24PGxBUyRyOm4dAycTdkLxfiK1qKf0zvxSnx/qsnyqaQ
KOe0ee41F8sl+243mPdhb3K4mzV7Env6F+R1zXhgXrC+NFjVB5m1NM6Y6iR6
OKfVt5XzwE0smUiR7cfdS80Low4ToLlmzKrr8xEkf2bxxf5+zBcpywqi6Yi6
LW8oX8BHb7YoCMd+/PTH0Ycu7p/wfZtOO0ldgEIdG8JrYQCygS8/b90zjsNu
qrOJKgKcFru1filgCP3BHxzFlD5ixyF2yPg6AR56hl3Kah2GvI+G9uTkKMpX
F49IrBVAfpXl14Flo3hWt8s+o3AEWfdEU5crCuCpcSaMsWkMdzSOsgo9hxHi
8UV5YpUA5by5xr/NPmLJbcOfuxWG0NyuzUuXEWDLiZrkdLNxeKtYPxL8MYCC
Q0+idFYKsMlYRrRJ9xO6yHnl2ejHbo+NR5IkBPjx9BwnRYKO+cL90hLVvajk
/d01ICqA/1aLG0mBdLyeySMpK/Tgp3Txa1//5WNp3+dDDI8JhA7ekCF50MCQ
9hW8iONjuO+GcajtJK4+PBmkV9ANnYfdytWKfBifyiD9rjaFbq2CJF5NFyz8
wnZqPOZhplA5+0diCkleVZWmElRYBZvFTOvx4LCpfIlSPI0EdpQ+U68DX9bY
2a+o5iLk2qqjjhcZWOih59hqkVG6XffPeCsurjFlmvrUmBCxmfPuGG1DpN/j
scBuAk+d/gla08GEZ0K83ya7FrzMabhT4ybM1UFBUmMwCxxNvdr3lk0YdBb/
7TyXA27xCRH3dWzcL1oh8FRvgD3zScjVMA4iZo79RUtho15bt6Kyoh7k3eT+
H8LYWOmCFDsJDhqbVdRiLtYjnmtsoxrOwjqLhX/9AznQzLx3gmNRj7tj2/Sj
IpkI+usxfbiPg30WLl4l2+pBpxnydkUz8L1l1FLJiECVlN990731yGPYHbO6
OY3MCql7qfEE6K6L5FTfeux9lTGXED+FLAMTommcQKvzFcUbZfUIa66xl0md
RPzxd4Zi+lyMJZffjlNqwGJncFL+wwnoldeHF13lIsE/RXsmoQHF5iYb9+bT
sX618clV9Vy4lmVYT2k0QsyNQzonzHXqLvKsGY8L2bfDbfm0d3Dv854njX6E
z5aFg19IPDifdPButXmPFPVDq3qcxpCdkK/kY8MDAymR3rGtyEsSUV2gjqAk
5pTH8wAekj5XLRzPbIeT9SC1w2YYC5oCalc6D8TgWuVb98gof5uwyrd2EIYG
d/L/qeOB/bW3zvBiB4zMXT0e6Q5Ajuwpum+cBymj868HtlORvm+DCC25D5EJ
BFG1xMOve3adoU53QeKJ1DH25x642NF+vqLBh4GipejJlm5IdlylCQ7QYFHt
9j5pDx8J+wNqm5Jp0NZRjLTS6IKeqrNz7jU+Sqh+vKprfYijbkwRPU1FLWvg
4Lc6PnI7L4i66A4ieuXNWfdfO1G2+chCxjwfAofrl6WeD+OBXKrvyVsduMJO
2uOvLwB7w5+dR5ePoa732YjWZQq+GfvFXPIQ9ps6+83wyDgWe1lZE0ZkyL6p
yUlKEyBxZY+noiUd5+QcF7ZR20Gx5g19aBYgwGDnmKTzBGoWPYssTdog3UYM
ycwKoNBWutrr/CQe2no3RLu2QD5E7ZE9aQbdXeWR1gFTkCDFvczc0YxLXQ98
IjCDotqNBhHB0/iW0rWFlPwWTt1bfJoHBSDFHohMXc8AOef9kMWtN5CeWp6Y
5S+AYDRKN4nKgJybsa0MpQHzpgo2FGHvT2gRhWNXmJg2+sX/LPc11uTXD2rG
81Gz9PvGfhILTJ6JjR29FodfFFS5KvFxQdLx+Ic6FkJ1ddi7c6tRnKHzm3kW
D75f3mUtnmSjqeF2RrpaJaIpDxQChLkKppoN/jHHBvv8mewIqzK4FfsN5aVx
ET2fULcugYPkZ4Gm58eL4estGnpFiovep2XjHjoEnrcdW0+rzwfXUio9IpxA
oajxq7o6Aopirc1PN2SCEjJyOMOcA1GKmWl1pbBPwbHpHw4/giepMSpwjoX+
oV/Xrysh8MCIbNDgk4tmmYCtDQVMGDiN+/CfEphxj/u+fuAJMnLn+b0ODER0
L9O2zSBQyqg0ifHJxyfG2vkY/hTusZrydsQR2DJHiaxYeA65BT1qZ+Qk8h7z
Y+quEnCXsPHSj3gBBf+KnZFf6fhZs7Fq1oPAoR9C7DPmi3CqJDA1rW4c209r
pnyyJzAvVdjScKEUd2t04+MsRiEnzRtOMSbgvyPn0TvGK/gEqOz47DSIWj1T
6hplAmk1+0b8FcuwR61pzPbxAGJzqsklMgTCWyQjrJ2bYHCDe/jvoX6w7t1l
eC5xoN3YPsytb8cb8y38QpF+HB/Sdtr5WXi3VrLoViuokLbarOKi2IfwB4nH
NjE4eNxy/bqDKw1MidVjOrK96Dp7k2Q2JOT9N4kGt9he5IqnhlLYNKhaHGBf
pHAwUVGQkxPXDy3HO2xGTjdIr3KXGho5OFLuizNXBkG0qX8cOUAFOajziUmZ
cL/98p5Kh2GYcTUk13WRofA96IeefA78szliH1VGMVNaaOaW2IqU9sT8tCwO
TqWuLZgcG4NqqP5p8dvtqMoZuK7nxYHOi6zdy4Scyzkb+EvZcjLmzn0oqjMU
+iTcj+suo6Pp/TJ7QpOCWCMXL7slNlYHuRVGdEwgfFHJfBudgv37iiR7KWyI
1RRLmkxOQjXbKZh7sAORafvFz2ayocRxPcCcm8Ji6eSndvcOtHaZcGfPsxH2
yF3SRoKBQmmyHUmzAzESt3ziDNgIlX/dTFdk4rvmOemXNylQkfWy3bwo5IRt
uf9WLRYOXIuInrxFRm3Y04ABMgumDi+1buqz8f/+q/8A5ejSSA==
                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->292064745,ExpressionUUID->"42e76044-7c87-47d2-990c-c6c86a6638a2"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1254186125,ExpressionUUID->"165851ba-c869-4ec9-9842-374eb2507d32"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Poles at Infinity", "Subsection",
 CellID->110515088,ExpressionUUID->"4a004786-16a5-4120-aefa-0d953ce0892f"],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f91d5ff7-69c8-4b97-957f-0ea8866286f8"],
 " has a ",
 StyleBox["pole of order ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox["n", TraditionalForm]],
  FontSlant->"Italic",ExpressionUUID->
  "cbc30727-cbcc-4e32-b961-b5630b0e8a52"],
 StyleBox[" at infinity",
  FontSlant->"Italic"],
 " if:"
}], "Text",
 CellID->201973890,ExpressionUUID->"629ba392-9899-4f88-98c2-63ac70a57be1"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"335b7551-22ea-5143-bc51-dabb4019916f"],
 " is analytic in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0c333b80-9431-6c45-9407-556fa1887f83"],
 " for some ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1b42a198-8616-e34f-8ede-4c23d91c8245"],
 ", i.e. in a neighborhood of ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bd9f05f7-17d5-2c46-9089-a8c539ed6614"],
 ", and"
}], "Text",
 CellID->379419992,ExpressionUUID->"75e2b084-2c65-8645-8d3e-02307354c082"],

Cell[TextData[{
 "2. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"1", "/", "z"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"72ed4b37-e36c-2446-b63b-9f67b30d8202"],
 " has a pole of order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b5afe8ba-3aad-dd46-88f8-37d6da3a4ccb"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ccf7af64-6a65-854e-b501-b47ade11f31e"]
}], "Text",
 CellID->28441576,ExpressionUUID->"d57d536f-fce7-0549-9ba9-cdaf7e88766b"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->691301702,ExpressionUUID->"70f3c412-43eb-456f-9e86-699c6b2828ba"],

Cell[TextData[{
 "Does ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     SuperscriptBox["z", "2"], 
     RowBox[{"z", "-", "2"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3becbb3d-e02a-478f-b016-c453671ee4bb"],
 " have a pole at ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "0335a036-8330-40ae-9397-526340eb5143"],
 ", and if so, of what order?"
}], "SolvedExampleNote",
 CellID->7906016,ExpressionUUID->"200c2b7b-d0b7-4739-bb3c-8cbd32166d62"],

Cell["To find out, we define:", "SolvedExampleNote",
 CellID->412360643,ExpressionUUID->"3f87b0a5-280f-42ff-882c-b86e252608d2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{"z", "-", "2"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "z_", "]"}], ":=", 
   RowBox[{"f", "[", 
    RowBox[{"1", "/", "z"}], "]"}]}], ";"}]}], "SolvedExampleInput",
 CellID->199565841,ExpressionUUID->"ffed72e5-304a-405e-b786-390d712392fe"],

Cell[TextData[{
 "and compute the Laurent series of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"94ff19b5-e64c-4df1-b48e-2ded937d05b2"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7a7f8d33-c83b-4e35-b9b8-2b2f56eea3ff"],
 ":"
}], "SolvedExampleNote",
 CellID->735455987,ExpressionUUID->"754daebf-d8fa-4962-8c7e-53c0329b75f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"g", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->468038769,ExpressionUUID->"9c513dee-26f3-4108-a1f6-07e1cfee9f14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "z"], "+", "2", "+", 
   RowBox[{"4", " ", "z"}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{"16", " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{"32", " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{"64", " ", 
    SuperscriptBox["z", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 2, 4, 8, 16, 32, 64}, -1, 6, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->63273985,ExpressionUUID->"cb0b9249-7a77-487e-9bcd-4f76983a1800"]
}, Open  ]],

Cell[TextData[{
 "Clearly, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f6f2a6cc-0c6b-42d0-9821-9ec5fb9e2061"],
 " has a simple pole at infinity."
}], "SolvedExampleNote",
 CellID->359691543,ExpressionUUID->"a34dd663-17a2-4c30-a1cd-74ec8de588c2"],

Cell["", "SolvedExampleEndCap",
 CellID->1121019277,ExpressionUUID->"ac2f9ede-44d8-4b99-8edc-50cbc805233e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->3015461,ExpressionUUID->"8b24080b-82ed-4567-abb1-0bdc0ca6a33a"],

Cell[TextData[{
 "Does ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"exp", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ee9ecde7-b2d1-4cd7-9083-46b99c55ff96"],
 " have a pole at infinity?"
}], "SolvedExampleNote",
 CellID->426440715,ExpressionUUID->"7403153d-418c-44c7-b188-8c9f898e3357"],

Cell[TextData[{
 "The function has a singularity at ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6614bc8b-d00c-4093-96d0-5c9672bd22da"],
 ", but it is not a pole. To see why, consider"
}], "SolvedExampleNote",
 CellID->120143420,ExpressionUUID->"b6c10a31-ec71-4ad4-938f-3329637a5c00"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"dcd55feb-0f70-4a34-bd42-6caeb249126d"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    RowBox[{"exp", "(", 
     RowBox[{"1", "/", "z"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9780ca67-3b5d-48a5-98f9-0694f2b29ac7"]
}], "SolvedExampleNote",
 CellID->2819327,ExpressionUUID->"1574d4b7-09ea-4d07-b912-914db98ea915"],

Cell["and", "SolvedExampleNote",
 CellID->655958140,ExpressionUUID->"cea7594a-4aef-4f9d-8b6b-be33279b55c7"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"7df6f6b4-60d4-43f1-8fdc-14f964a132ae"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "0"}], ")"}], "n"], 
      RowBox[{"g", "(", "z", ")"}]}]}], "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{
      SuperscriptBox["z", "n"], 
      RowBox[{
       RowBox[{"exp", "(", 
        RowBox[{"1", "/", "z"}], ")"}], "."}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8d419f18-4a84-4510-a998-76a0d841a361"]
}], "SolvedExampleNote",
 CellID->105734776,ExpressionUUID->"dab5b642-9479-4c0d-a48f-50f43fd9c8b7"],

Cell[TextData[{
 "The limit does not exist for any integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ff4e9f7c-48db-4364-8b60-b505d87c8be5"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bd5244f9-6c1b-4a68-9441-e3d4a279b4b9"],
 " does not have a pole at ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e231dcfc-bfd7-4c23-836e-91c0175bda54"],
 ":"
}], "SolvedExampleNote",
 CellID->719118027,ExpressionUUID->"da9346fd-b758-443b-b158-e834cf6a0458"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "2"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "z"}], "]"}]}], ",", 
   RowBox[{"z", "->", "0"}]}], "]"}]], "SolvedExampleInput",
 CellID->348373594,ExpressionUUID->"ae970071-e4f8-431e-8fe6-c9e33d39f89c"],

Cell[BoxData["Indeterminate"], "SolvedExampleOutput",
 CellID->236742436,ExpressionUUID->"8d859f36-fdbf-4e11-8bbd-01c54b44c3a8"]
}, Open  ]],

Cell["You will see that it has an essential singularity.", "SolvedExampleNote",
 CellID->303839369,ExpressionUUID->"687ef854-8c5e-4fd0-b362-c21d8b36fcfe"],

Cell["", "SolvedExampleEndCap",
 CellID->741418403,ExpressionUUID->"3acf27bb-1c7e-4b27-be2b-7626e196a45c"],

Cell[CellGroupData[{

Cell["Essential Isolated Singularities", "Subsubsection",
 CellID->79840106,ExpressionUUID->"43ab3739-1ed4-4bf9-af70-d858031b6acc"],

Cell[TextData[{
 StyleBox["1st definition of essential singularity",
  FontSlant->"Italic"],
 ":",
 StyleBox[" ",
  FontWeight->"Bold"],
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2b470983-7281-491a-93ca-9a3c7921454c"],
 " has an essential singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d643f33b-d6d6-4be4-9fab-146e8622c981"],
 " if:"
}], "Text",
 CellID->344943727,ExpressionUUID->"1dd1d394-7f66-4935-a486-f76b22c734b3"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"948f5d5e-1a26-7c4b-88cf-05fd5bcebdcd"],
 " has an isolated singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fd28e109-84b9-ba4a-91fe-a532a89f4188"],
 ", and"
}], "Text",
 CellID->307612996,ExpressionUUID->"7a46889d-cece-e64b-9a2c-91063efdeedb"],

Cell[TextData[{
 "2. there is no number ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c65f104b-e7be-ed44-a872-0c7627024b00"],
 " such that"
}], "Text",
 CellID->41113612,ExpressionUUID->"76c468fc-cdf9-cb41-b5d7-a9c6d19dd96d"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"|", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], 
      SuperscriptBox["|", "\[Alpha]"], "|", 
      RowBox[{"f", "(", "z", ")"}], "|"}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0da06cca-db35-f540-8fb5-b1b71769f23b"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ">", "h"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a27c3074-3579-b145-b302-353428af7c69"],
 " and"
}], "Text",
 CellID->31204120,ExpressionUUID->"258bd45c-4a6d-8e4b-821a-d0028eccb9b2"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"|", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], 
      SuperscriptBox["|", "\[Alpha]"], "|", 
      RowBox[{"f", "(", "z", ")"}], "|"}]}], "=", "\[Infinity]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "47d5c761-b3e0-2c48-9f8e-e05f92bffcd9"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "<", "h"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8eabe52f-7ac3-e841-85e6-560102b3903e"],
 "."
}], "Text",
 CellID->459927261,ExpressionUUID->"2e911ee3-db55-c545-9858-cfd9fd12f6a7"],

Cell[TextData[{
 StyleBox["2nd definition of essential singularity",
  FontSlant->"Italic"],
 ":",
 " A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fd01fb87-6c80-4f3d-9206-07d29757dcbe"],
 " has an essential singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dd2e450a-eb9d-4a9f-b9f9-da52a9ab31a9"],
 " if it is:"
}], "Text",
 CellID->154548230,ExpressionUUID->"243e7671-e319-4101-bb0b-da261066d0aa"],

Cell[TextData[{
 "1. analytic in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "\[Epsilon]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b9d7028c-fd46-744c-b975-329838fc4545"],
 ", and"
}], "Text",
 CellID->11365532,ExpressionUUID->"6aa1b2d4-2483-d143-97db-5f915bfaed04"],

Cell["2. its Laurent expansion", "Text",
 CellID->199906047,ExpressionUUID->"c0d903bb-4f87-7348-b17d-06fe5499a3df"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "1"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     FractionBox[
      SubscriptBox["b", "n"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}], ")"}], "n"]]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     SuperscriptBox[
      RowBox[{
       SubscriptBox["a", "n"], "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"aee83e40-8e7d-6b44-b3d1-3c45747607a2"]
}], "Text",
 CellID->31137134,ExpressionUUID->"d82fc0cc-f576-df43-9558-d57d17ece727"],

Cell[TextData[{
 "has infinitely many nonzero terms ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "17b0431a-9d7f-3646-9b78-05347b6b95f2"],
 "."
}], "Text",
 CellID->254377407,ExpressionUUID->"0876fe12-1696-b54c-a613-9fe1e4b4feaa"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->416201619,ExpressionUUID->"365d82fb-2502-4e1c-a766-494131cc82a3"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"exp", "(", 
     RowBox[{"1", "/", "z"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c920d8d0-2619-499c-b756-24ae92439801"],
 " has an essential singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "901f212c-65be-4e95-aa86-5309ad916afb"],
 "."
}], "SolvedExampleNote",
 CellID->39080737,ExpressionUUID->"2f84bc35-3689-4a29-b367-291973ddcf83"],

Cell["The reason is that its series expansion is", "SolvedExampleNote",
 CellID->341883642,ExpressionUUID->"4049f577-6e67-46dc-a36d-4f79b750151f"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"630fbf6e-33c7-4884-b82d-6e8531e6863c"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"exp", "(", 
     RowBox[{"1", "/", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       FractionBox["1", "z"], "+", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"2", "!"}], 
         SuperscriptBox["z", "2"]}]], "+", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"3", "!"}], 
         SuperscriptBox["z", "3"]}]], "+"}], "..."}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
      FractionBox["1", 
       RowBox[{
        RowBox[{"n", "!"}], 
        SuperscriptBox["z", "n"]}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"78f02244-da67-49e0-a4c9-f8b1bc032726"],
 ","
}], "SolvedExampleNote",
 CellID->550276968,ExpressionUUID->"bda8cfc2-7d08-4f95-8a6e-3e7dafa478c4"],

Cell["\<\
which has infinitely many terms with negative exponents. Plotting the \
function:\
\>", "SolvedExampleNote",
 CellID->230492644,ExpressionUUID->"c8082a2b-1b5d-4634-ab34-53318da728cd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["5", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["776", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[AxesLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, AxesStyle -> Directive[12], PlotLegends -> 
     Automatic, PlotRange -> {0, 4}, BoxRatios -> {1, 1, 1}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->80945100,ExpressionUUID->"33633af8-4018-4add-9ca2-bf128ac75e08"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXdcz93//9sZRYTsnT2yt1dFVvYemVF2yB6RmRFdCleIuGxJRjLibROh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      "], {{{
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzFnHeQVdW27k+9V3WUIGJOuxFQEBWRnDEcFPWYRQQVAwhmUYwgogQVBAMi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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         EdgeForm[None], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnXf819MXxz8bRSmRlbZKQkZD5VehIkWURIOGFYVKVlZWZG8ZGdmU9bOS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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtk7tPlFEQxe8+7ggC2eWlEIm4xpUQNYuvDSIEhF1YK812FlqQAJ3Wxl7/
ABMqTWgtqEhMLI0VBbFSwl+AVKC8Ca/fcb7i5J6ZO/d+c8+crzD9pv46HUIo
gyy4aCF8S4WwCg5iCJPEK6wjbA7D86AKb9UheBO4QfwVXIffBMvwhUwIRfgd
MMz5V6ABngMV9n+CK/C74Cl7S9TfgqfAYsZrtsk/Jp6N3tM+6xbYTXmNatNg
D54nfwLaiT9z1uDN8NPovfSRu0p8Hzwn9x18gT8B8/BfoBPeBj5QO0fcaA7x
2aSX2+Aj972jh3VyZ9G1GuRMC3ubxKWsa3CYvFlvfwkewR+CF/Df7B+z9hMX
o/es3nfg9az3NEZcArUkp72/ySz+gF7zN+qtmlEVPgRmor+hFT5o/m3ltDcK
3sNzzK8DPmXO1UPNXBNp8wzcg4+ba/uWN26w7oEf3J2Sxpq9ZhbdA13wbnOt
/+fgu8ld+2iWIc6a36UZaBYV+S26ptJWNapVbsJcU2mrmR+Re2D+bWlYhv+L
7kV5SF6Sh+QlaTZg7jF5TZ6Vd6WZtNOMNKse4jV4WpomHpAXpJG0ugY+Zbym
YF6jWmkgLS6Ye0Eel9ePk9nKk/LmZfN/Q3dcgp8D+mpcAA==
             "]]}, Annotation[#, "Charting`Private`Tag$28769#1"]& ]]}, {}, {
         GrayLevel[0.82], 
         EdgeForm[None], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNmEtsVlUQx7/ae49GNy4sCjagG1dQEQUSNxWrC40mii8UFARURKDiI1Hw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            "]], 
           Polygon3DBox[CompressedData["
1:eJwlkjcvh1EUh+/r/zqDycBmsYuwWkhserToNbpoiZ5o0RJC1CCIEiJiFINd
bAbfwDcwGMQgnp8zPMlz27nnnnMzO4Yrh5JCCFkQQ72FcBiFkM6gAT+AXTwF
DvFe+MDj5BD68H5zz2ZuAC+GNMbXUIJfwjJrBYyv8DuYIf53IoR7fAVyWHuC
VfwCLPYzOnsKJ5HPnZnnpNx+oBFvMvcXaMYnYIlY+Ywn8SLzu5STcuuG98jf
0IO3wiPjX8ZteLu5B/Z34OW6Ez8iRgU+DW+MF2EGL4NE7Hu0dxQW8FzmxvAb
yEv2N9/iO5oj1jPru/gWfEU+t43PwTlrqTRlHt+HjNh78N8L87Oa28M34CHh
MTbxUvPaKyflVmWeex1z1XgXvMZeA9ViGD4jz3kErzHfqz9Qa95T9VZ7Bs1r
otooRie+BoWx57Bu3mP1Wm++xsfNa6GeqDeqmWqnN87iLea9Uw/UC/VMvVON
p8z/hP6G7tBdx+Z/UX/iRLHMa6U/tIT/AZjQWDo=
            "]]}]}, {}, {}}, {
        GrayLevel[0], 
        Line3DBox[CompressedData["
1:eJwl0jdSHEEYBtBGLMLt4oVAuCLFXACT4yIiSWQEsItZvLcSZi+AE6QQogDE
BSCgyDAXEBfAXADpbRG8+r+umZqve2bq+8d6kxkhhC0Os0JI5x7zOjOEOrmd
PhbY54IHXil0czPdJEhxwhWP/KPmQwitfGOOXc6545mYnkY6GYqEcKZ7UD4w
T63jciJ9jWFGGCXJGONMMMkU08wwyxzzLLDIEsussMoa6/zgJxvp5+s8170p
/zJ/Ww/IHTQQ5cm+bzljh1m+0kI1b879l0uO2SZOF00U8OL93fOHPeb5Ths3
Oo5018opM2kPNXI1VXyhkgo+U84nyiilhGKK0t+IAmJEySePXHLI5iNqgpqg
OjhCGI28/w//ATRLOBs=
         "]], 
        Line3DBox[CompressedData["
1:eJwl0UVSQ0EUQNEOkI+H4BrF3d2dMUuAOayLleFOcAKnisGp+/r1r5783NHp
4UkshHDMWRTCNGUMcBkPYUv7mefHuUS/dVbnmCHi1e6CLnOKHFlaaOXaXV6r
6aaNHtq5dZfWovZqHx18ON+TMT/qiu6xSw2NDLLGEAfss0oT6zSzyQYv3hjX
CYaZ5Mnui4Q5kKSTOp7tY/qgn9Saf/WOd6qcb/SNZXMlDdSzxAKLVDBKOVe+
HdNzHdEdtimlYDcV/f+HP9AtJ5w=
         "]], 
        Line3DBox[CompressedData["
1:eJwl0VVSAlAAAMDnh9zD4yhYiN1ggyBid4AtBna3jqd0Z/zYE2xNMhfPVoUQ
UnxGQvjgnTdeeeGZJx554J47brnhmisuuaDCOWecckKZY4445IB99thlhxJF
ttlikw3WWWOVFZZZYpEF5pljlhkKTJNnihxZJsmQZoJxxhhlhGGGSJFkkAH6
6aOXHrrpopMO2mmjlQQtxGmmiUYaqCdGlDpqqeaXH775ivw//AErnjLt
         "]]}}, VertexNormals -> CompressedData["
1:eJzEvHc81v/fPpxkRFKhobIrCSWFMp5GKUllhSKZZUQlIpWSzCSSQpnZI3vz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