(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    505724,      10945]
NotebookOptionsPosition[    342365,       7534]
NotebookOutlinePosition[    480707,      10483]
CellTagsIndexPosition[    480664,      10480]
WindowTitle->23. Residues | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Residues"
}], "Section",
 CounterAssignments->{{"Section", 22}},
 CellID->324123876,ExpressionUUID->"7037e091-7496-4448-9af1-6cc27d037048"],

Cell["\<\
The concept of residue of a function at an isolated singularity is very \
useful to the computation of integrals: it allows to compute, in a \
standardized and algorithmic way, many complex integrals, particularly for \
meromorphic functions. It is important to remark that residues are only \
defined for isolated singularities.\
\>", "Text",
 CellID->270265697,ExpressionUUID->"652b9d8f-978f-469c-88eb-ffd25987e659"],

Cell["\<\
In the next several chapters, you will see what residues are and how they are \
used to compute complex integrals.\
\>", "Text",
 CellID->75871582,ExpressionUUID->"fa6c4000-e753-4a53-8314-ba1216f20232"],

Cell[CellGroupData[{

Cell["Definition of Residue", "Subsection",
 CellID->448533537,ExpressionUUID->"9c4f2932-00d2-4791-b66d-f54474f94b9b"],

Cell["Let\[CloseCurlyQuote]s state two equivalent definitions of residue.", \
"Text",
 CellID->549653781,ExpressionUUID->"20512af0-2608-4e3f-a11e-2a7f258e4ba0"],

Cell[TextData[{
 StyleBox["1st definition of residue",
  FontSlant->"Italic"],
 ":",
 " The residue of a complex function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"736d16ee-a2b7-490c-91f2-81ba95a6aa73"],
 " at an isolated singularity ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "81c40d04-8ab9-4709-853e-ec87115e2b10"],
 " is given by the coefficient ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fff1c7e4-a689-483d-863c-25b8a55731f6"],
 " of its Laurent expansion around ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f9ef54cd-a7cf-40cf-8b1f-b568231037b5"],
 ":"
}], "Text",
 CellID->792745798,ExpressionUUID->"64f45504-43da-4a21-9346-59a2b0f3099d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     SubscriptBox["b", "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"]]}], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{
       SubscriptBox["a", "n"], "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->115165494,ExpressionUUID->"fba9f0b3-2cc8-4c12-a5d2-5b332cc745f0"],

Cell[TextData[{
 "The notation used is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    SubscriptBox["b", "1"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d0a61fce-dde5-4e7c-856b-5b637896261f"],
 ". The Laurent expansion must be in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "r"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c287496a-5dab-4906-a5d9-72d34ef7444c"],
 " for some ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e8f4bb44-3b01-4f70-9227-6a7ed5b5d824"],
 "; expansions in other regions cannot be used to compute the residue."
}], "Text",
 CellID->696967244,ExpressionUUID->"001ae3d2-3498-4e6c-8a87-e63efa91a88b"],

Cell[TextData[{
 StyleBox["2nd definition of residue",
  FontSlant->"Italic"],
 ":",
 " The residue of a complex function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0e90a1db-470d-485a-999a-19dc770598f1"],
 " at an isolated singularity ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b8f8e863-6232-4c42-8a3d-b5a1a346c833"],
 " is the quantity"
}], "Text",
 CellID->491350299,ExpressionUUID->"91d75336-b3b6-40a9-9e26-46d96d9007ac"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Res", 
     RowBox[{"z", "->", 
      SubscriptBox["z", "0"]}]], "f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->574203713,ExpressionUUID->"b43b0122-0776-4bc9-b142-364462bbb2bd"],

Cell[TextData[{
 "along a small closed contour ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "07435384-243e-4988-a391-aeee6c60a039"],
 " around ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ab84b6f9-868b-4c84-bfee-c799dab4aa0b"],
 ", having no other singularity inside."
}], "Text",
 CellID->3808753,ExpressionUUID->"21c1e6c1-41d9-437b-babf-cc4f95e29c29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "-", "\[ImaginaryI]"}], ",", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"3", "\[ImaginaryI]"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"2", "\[ImaginaryI]"}]}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Ticks", "->", "None"}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"2", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"1", "/", "2"}]}], "]"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(0\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(1\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(2\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(3\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
    "#", ",", "\"\<Fig. 1. The residue at \
\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"z\", \"0\"], \
TraditionalForm]],ExpressionUUID->\"fc00839c-4170-4434-9617-6a2834bdff22\"]],\
ExpressionUUID->\"33fb0519-3f0a-4362-bd30-f4caf997b982\"]\) is related to the \
contour integral around it.\>\""}], "]"}], "&"}]}]], "Input",
 CellID->120948677,ExpressionUUID->"9e8ca401-2f83-4abc-b79b-5ccb13d32601"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, {}, {{}, 
        InterpretationBox[{
          TagBox[
           TagBox[
            {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
             PointBox[{{2., -1.}, {1., 1.}, {-2., 3.}, {-3., -2.}}]},
            Annotation[#, "Charting`Private`Tag#1"]& ],
           {
           "WolframDynamicHighlight", <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
          StyleBox[
           DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
             Slot["HighlightElements"], 
             Slot["LayoutOptions"], 
             Slot["Meta"], 
             Charting`HighlightActionFunction["DynamicHighlight", {{
                Annotation[{
                  Directive[
                   AbsoluteThickness[2], 
                   RGBColor[1, 0, 0], 
                   PointSize[Medium]], 
                  Point[{{2., -1.}, {1., 1.}, {-2., 3.}, {-3., -2.}}]}, 
                 "Charting`Private`Tag#1"]}}, <|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                 "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                 Automatic, "DefaultStyle" -> {
                   Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ComplexListPlot, "GroupHighlight" -> 
                 False|>|>]]& )[<|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, 
                "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   AbsoluteThickness[2], 
                   RGBColor[1, 0, 0], 
                   PointSize[Medium]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>],
            
            
            ImageSizeCache->{{
             4.503599627370496*^15, -4.503599627370496*^15}, {
             4.503599627370496*^15, -4.503599627370496*^15}}],
           Selectable->False]},
         Annotation[{{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              Point[{{2., -1.}, {1., 1.}, {-2., 3.}, {-3., -2.}}]}, 
             "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
          "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
      AspectRatio->Automatic,
      Axes->True,
      AxesLabel->{
        FormBox[
         StyleBox[
          RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm], 
        FormBox[
         StyleBox[
          RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Epilog->{{
         RGBColor[0.368417, 0.506779, 0.709798], 
         ArrowBox[
          CircleBox[{2, -1}, 
           NCache[
            Rational[1, 2], 0.5]]]}, 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(0\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], {2, -1}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(1\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], {1, 1}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(2\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], {-2, 3}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(3\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], {-3, -2}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& )}},
      PlotRange->{{-4., 4.}, {-4., 4.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{}, {}}]},
    {"\<\"Fig. 1. The residue at \\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\
\\nSubscriptBox[\\\"z\\\", \\\"0\\\"], TraditionalForm]]]]]\\) is related to \
the contour integral around it.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1874848294,ExpressionUUID->"9633e57a-c51d-41d3-96d6-6e782c9f4775"]
}, {2}]],

Cell[TextData[{
 "The two definitions are clearly equivalent, because for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2986fe97-eb31-4df1-8933-308ea957a073"]
}], "Text",
 CellID->136426496,ExpressionUUID->"be42c6fd-539b-43a4-95f6-f57ce996c77a"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"]}]}], "=", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {"1", 
          RowBox[{
           RowBox[{
            RowBox[{"if", " ", "n"}], "=", 
            RowBox[{"-", "1"}]}], ","}]},
         {"0", 
          RowBox[{"otherwise", "."}]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->520559709,ExpressionUUID->"39cf1ca7-3a2c-4f00-b0d3-a49072aaa753"],

Cell[TextData[{
 "You computed this integral before, in ",
 ButtonBox["Chapter 11",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "Text",
 CellID->266648484,ExpressionUUID->"878e85ab-45e2-43e0-8911-0feb65069c8e"],

Cell[TextData[{
 "In Wolfram Language, residues can be calculated using the command ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->221541776,ExpressionUUID->"d64b62c1-a305-4b50-bb45-0dbb6611e857"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->154820015,ExpressionUUID->"b366efda-27c8-4827-8d1c-3e6d2bcc77fb"],

Cell[TextData[{
 "Does the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox["1", 
     RowBox[{"sin", "(", 
      RowBox[{"\[Pi]", "\[InvisibleSpace]", "/", "z"}], ")"}]]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "3e1f8db0-f14e-42d4-b196-13fd05ebb7b6"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3091a3f1-9558-4ae2-a940-643b9da34af4"],
 " exist?"
}], "SolvedExampleNote",
 CellID->75728564,ExpressionUUID->"3e803a67-9126-4d60-ab16-d84e762453e7"],

Cell[TextData[{
 "No, because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6c3a9926-5ae5-4c6f-8985-3d6051de8c9b"],
 " is not an isolated singularity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cf115b63-cde0-4b8f-8cf8-7d724276df0e"],
 "."
}], "SolvedExampleNote",
 CellID->669099423,ExpressionUUID->"ad436400-6f87-43a4-ad56-232515f5c3fa"],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"e3e9aafc-3fe1-4f19-8765-b51af35e40a3"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->912421477,ExpressionUUID->"886d40e6-fd93-4abf-be60-288e79d179a9"],

Cell[TextData[{
 "Calculate the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", "z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cd160e82-269a-48d8-bb24-495833cf7385"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fd6c8a5d-64ea-457a-a09a-df7282f1b332"],
 "."
}], "SolvedExampleNote",
 CellID->108886030,ExpressionUUID->"caf0544a-1233-466b-9cc0-4c94e06c0b78"],

Cell[TextData[{
 "The point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "da9ee631-91a5-4fe8-8f3b-f6a481cc5e19"],
 " is an essential singularity. The Laurent series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6b3d1a0a-53c0-4c68-9dad-3657be146a0b"],
 " around zero (",
 ButtonBox["Chapter 21",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ") is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"1", "!"}], "z"}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"2", "!"}], 
       SuperscriptBox["z", "2"]}]], "+", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"3", "!"}], 
       SuperscriptBox["z", "3"]}]], "+", "\[Ellipsis]"}]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"5b2ab464-ab87-47b1-a36d-47a7b24d828f"]
}], "SolvedExampleNote",
 CellID->794075810,ExpressionUUID->"172ed942-90a8-4a0f-ab2b-e3f5e6ff5876"],

Cell[TextData[{
 "So the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "0"}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", "z"}]]}], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2c04f5ce-0dcf-4b1d-ba1e-26207e4210fd"],
 ". Confirm with ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->89494711,ExpressionUUID->"7596b012-3f80-4010-ae71-2f117d0cd9c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->46283287,ExpressionUUID->"c6abec52-7d20-47c4-8639-969f8bf182d7"],

Cell[BoxData["1"], "SolvedExampleOutput",
 CellID->568678105,ExpressionUUID->"f7562e41-2a62-4eac-98f8-a56f443a46d0"]
}, Open  ]],

Cell[TextData[{
 "This corresponds to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], ")"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "f1732329-39f9-46ed-8c8b-1e13a06f9618"],
 " times the integral in the picture:"
}], "SolvedExampleNote",
 CellID->366755292,ExpressionUUID->"ecec6e6e-6706-4b7c-b36a-7f5a165093d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      StyleBox[
       TemplateBox[<|"color" -> RGBColor[
           Rational[1, 3], 
           Rational[1, 3], 
           Rational[1, 3]]|>,
        "RGBColorSwatchTemplate"],
       StripOnInput->False,
       LightDarkAutoColorRules->{}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"1", "/", "2"}]}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "]"}]], "SolvedExampleInput",
 CellID->85203801,ExpressionUUID->"e0d081bc-02dd-4fde-a88d-82a858137625"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJyM11eQK1li5neG9CA9KhSKkJ6WIe3LKmRDwV1R67gUjUhxRDNLDocznOG4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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}, 
      NCache[
       Rational[1, 2], 0.5]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->413761025,ExpressionUUID->"53002ab4-2524-48a9-a602-2c2b20217e90"]
}, Open  ]],

Cell["as you can check with:", "SolvedExampleNote",
 CellID->169171312,ExpressionUUID->"a0865c20-bba3-452d-a047-ebc7f22bf2a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], "*", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "z"}], "]"}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->556382888,ExpressionUUID->"7bf73452-b24d-42f5-a020-dfb06fd05a4f"],

Cell[BoxData["1"], "SolvedExampleOutput",
 CellID->458660577,ExpressionUUID->"66198df4-d042-41b0-b44e-1a0146fb8ce4"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1586096596,ExpressionUUID->"3a9b1faa-ea6e-4abd-bcc4-163904780667"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Computation of Residues", "Subsection",
 CellID->778994815,ExpressionUUID->"18484bd6-10bc-4138-aa5e-973d274781bb"],

Cell[TextData[{
 "It is, of course, possible to compute the residue of a function from the \
two definitions given previously. However, you don\[CloseCurlyQuote]t need to \
find all terms of the Laurent series just to find ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0081f5cb-6634-46b2-80de-c9502d52701e"],
 ". Also, most often, residues are calculated in order to find the value of \
an integral, not vice versa."
}], "Text",
 CellID->634039486,ExpressionUUID->"2c58a024-f4ff-4d9c-9afb-5c4f0fb58140"],

Cell["\<\
In order to use residues to compute an integral, one needs an easy method to \
compute residues without computing the integral explicitly.\
\>", "Text",
 CellID->230319373,ExpressionUUID->"a5f6ee73-ae13-4a8b-95b2-e7b75188bc85"],

Cell["\<\
Let\[CloseCurlyQuote]s describe the most straightforward way to calculate a \
residue, starting from the simplest case.\
\>", "Text",
 CellID->170260561,ExpressionUUID->"c1a96931-5cd9-447e-9f48-ac26900944cb"],

Cell[CellGroupData[{

Cell["Residues at Simple Poles", "Subsubsection",
 CellID->223167042,ExpressionUUID->"c0470cc0-e691-492a-8750-4ba233a12836"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c7018489-54a2-4989-8667-73637f894823"],
 " has a simple pole at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a92fb8c2-5ea9-415f-ab38-35c6fa2994c0"],
 ", then its Laurent expansion at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "66c96d6f-23c9-47bd-919f-3ca1167e3f38"],
 " is"
}], "Text",
 CellID->104041704,ExpressionUUID->"ef56bd79-ae25-4223-93c5-76d8635868a9"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    FractionBox[
     SubscriptBox["b", "1"], 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}]], "+", 
    SubscriptBox["a", "0"], "+", 
    RowBox[{
     SubscriptBox["a", "1"], "(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}], "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "2"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "2"], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->98937483,ExpressionUUID->"556dbdbe-24c0-4cb2-a2b1-24ef6213bedd"],

Cell["So the function", "Text",
 CellID->114052419,ExpressionUUID->"18580e31-d605-405b-b339-479697dfdbcc"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"g", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}], "f", 
    RowBox[{"(", "z", ")"}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->501661444,ExpressionUUID->"3968f058-f993-401b-b505-5bd725110ecb"],

Cell[TextData[{
 "has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5b22f8a3-cc9e-447d-8837-8f11df7ef8b2"],
 ", and its series expansion is"
}], "Text",
 CellID->66520717,ExpressionUUID->"6f894edc-0587-4fd0-bd63-d469a1b15d2c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"g", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    SubscriptBox["b", "1"], "+", 
    RowBox[{
     SubscriptBox["a", "0"], 
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}]}], "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "1"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "2"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "3"], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->206872034,ExpressionUUID->"6fa29089-04c8-45b5-8126-53f796adf972"],

Cell[TextData[{
 "So clearly ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7ff99ad8-cd67-4fc5-a598-06da087ecb76"],
 ", which is the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4b825084-0d87-4901-a341-5adca7c71d1c"],
 " at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "93b3e96b-b45d-413a-89e1-0f72ee8ca87d"],
 ", is equal to"
}], "Text",
 CellID->189861345,ExpressionUUID->"a7db57bf-6832-4d07-a5a7-d4927492148e"],

Cell[BoxData[
 FormBox[
  FrameBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], 
      RowBox[{"f", "(", "z", ")"}], "      ", "if", " ", 
      SubscriptBox["z", "0"], " ", "simple", " ", 
      RowBox[{"pole", "."}]}]}]}]], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->368114463,ExpressionUUID->"bc712666-d95d-4520-b9a5-2281287c5f95"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->101243708,ExpressionUUID->"48271af4-ab40-4f95-b2ec-f1fd31ac58a1"],

Cell[TextData[{
 "Find the residues of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "3"], "-", "2"}], 
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "1"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dfb5850a-3730-40ce-a808-f0e414669107"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ec132bb9-a2b1-425c-b042-3c3673f2fbfb"],
 " and at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "eafff579-ff5e-4861-8298-b749fe37e7b3"],
 "."
}], "SolvedExampleNote",
 CellID->82553203,ExpressionUUID->"7bfadd8d-ddff-4323-8058-3f0214beb977"],

Cell[TextData[{
 "Applying the formula at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5e4840f6-b495-4aef-b2db-b3b9fea798d6"],
 ":"
}], "SolvedExampleNote",
 CellID->201466207,ExpressionUUID->"2a73a88e-3c29-45fd-b92a-e57b1363a035"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"eeea514d-07f1-4a1e-8506-5d019dea4d82"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      RowBox[{"z", "\[CenterDot]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "3"], "-", "2"}], 
        RowBox[{"z", "(", 
         RowBox[{"z", "-", "1"}], ")"}]]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", "0"}]], 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "3"], "-", "2"}], 
        RowBox[{"z", "-", "1"}]]}], "=", "2"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7b2a5306-1195-490d-8fb6-8d72ef012675"]
}], "SolvedExampleNote",
 CellID->346253189,ExpressionUUID->"8584d737-8e6e-43e9-a331-f8eac41df9a2"],

Cell[TextData[{
 "corresponding to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], ")"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "a641b925-14cf-4516-a69e-02b51933a4a0"],
 " times the integral below:"
}], "SolvedExampleNote",
 CellID->54141627,ExpressionUUID->"2cebf164-ea50-411a-a209-5b2e2a8463c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "3"}], "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      StyleBox[
       TemplateBox[<|"color" -> RGBColor[
           Rational[1, 3], 
           Rational[1, 3], 
           Rational[1, 3]]|>,
        "RGBColorSwatchTemplate"],
       StripOnInput->False,
       LightDarkAutoColorRules->{}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"1", "/", "3"}]}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "SolvedExampleInput",
 CellID->20976512,ExpressionUUID->"0ce93160-e5bf-4628-a68e-4583d151d874"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx83FeQHHee4PcN6UUvitCrnhSSHi5CIV1cXOgupDOh3dDt7e3N3t3uzM7t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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}, 
      NCache[
       Rational[1, 3], 0.3333333333333333]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->2140970035,ExpressionUUID->"a61cc350-c5f0-4ef6-bac4-58ce560bf50a"]
}, {2}]],

Cell["as you can check using:", "SolvedExampleNote",
 CellID->166465163,ExpressionUUID->"e45e1603-b18d-4a35-9c48-e94ffbb61dc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", "^", "3"}], "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"z", 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}], ")"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}], "]"}]}]], "SolvedExampleInput",
 CellID->32164384,ExpressionUUID->"f7e810c6-1246-46d5-8797-e31261313099"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->204414958,ExpressionUUID->"7724e398-6094-43d7-9b08-f11c4739223b"]
}, Open  ]],

Cell[TextData[{
 "And for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0a254474-0380-45a0-a96c-4fb172c6774b"],
 ":"
}], "SolvedExampleNote",
 CellID->387285508,ExpressionUUID->"5bd2336b-bf30-485c-b7cc-a6d330e68e8a"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"1aba7dcb-29fb-47d4-9854-3be0f7f06f44"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "1"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "\[CenterDot]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "3"], "-", "2"}], 
        RowBox[{"z", "(", 
         RowBox[{"z", "-", "1"}], ")"}]]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", "1"}]], 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "3"], "-", "2"}], "z"]}], "=", 
      RowBox[{"-", "1"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"aadcf44c-708f-4c3a-bc74-19d13baf493b"]
}], "SolvedExampleNote",
 CellID->247013697,ExpressionUUID->"f2592415-a03b-46df-8234-20f7e0670037"],

Cell[TextData[{
 "corresponding to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], ")"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "513a7265-2c4a-49fe-b4b3-06c511648f4a"],
 " times the integral shown:"
}], "SolvedExampleNote",
 CellID->58121628,ExpressionUUID->"4803f455-a935-4487-b29b-f2ba31bb1dfe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "3"}], "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      StyleBox[
       TemplateBox[<|"color" -> RGBColor[
           Rational[1, 3], 
           Rational[1, 3], 
           Rational[1, 3]]|>,
        "RGBColorSwatchTemplate"],
       StripOnInput->False,
       LightDarkAutoColorRules->{}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"1", "/", "3"}]}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "SolvedExampleInput",
 CellID->626915360,ExpressionUUID->"f6e04a45-154b-4a48-95b5-0bef547fb949"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx83FeQHHee4PcN6UUvitCrnhSSHi5CIV1cXOgupDOh3dDt7e3N3t3uzM7t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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW
CCwPHmEJ4rq6ruu6vM5W3gvnLOebuWmGw7t399/9MjP/f/6573/x9adfvnNx
cfH43YuLm5H/fnh09+Hzpz/dT12sP3/+9M6TRyfrJ7d/f2H97Y288zM+31k/
+Gz/6vGfr/D93vq9Xz76/tmbS+vbP9+5sr759o8PXuP6g/Xl2wtYf3x7v1+t
39x+4Dfcf7T+5IMP/7v38nfEM1m//ObmE38gvtn63u0H/kK8i/VNtHcf/o34
V+vbyz35B8+zWX/37OYJ/sX73K3f/ruGPri2x2ItvtLiKy2++fnOWnzz+721
+EqLr7T45vUHa/GVFl9p8c37j9bim/FM1uKb8c3W4pvxLtbim/Gv1uKbz7NZ
i2++z/1+zstr6GOetrkeY/It4FvAt4BvAd8CvgV8C/gW8C3gW8C3gG8B3wK+
BXwL+BbwLeBbwLeAbwHfAr4FfAv4FvAt4FvAt1532/P04MpRfKXFNz/XWYtv
fr+3Fl9p8ZUW37z+YC2+0uIrLb55/9FafDOeyVp8M77ZWnwz3sVafDP+1Vp8
83k2a/HN97lbi++5fbS97paKozRH8c3Pd9bim9/rrcVXWnylxTevP1iLr7T4
Sotv3n+0Ft+MZ7IW34xvthbfjHexFt+Mf7UW33yezVp8833u1uJ7Li9q76Ol
mpfkKM1RfKXFN7/fW4uvtPhKi29ef7AWX2nxlRbfvP9oLb4Zz2QtvhnfbC2+
Ge9iLb4Z/2otvvk8m7X45vvcrcX3XJ7bzouOfZTrLucpuXLM9bkzX+lcnzus
zx3W5858pXN97rA+d1ifO/OVzvW5w/rcYX3usD53WJ87rM8d1ufOfKVzfe6w
PndYnzuszx3W57puaee5pdo3uc5yXpKjNEfxlRZfafGVFt+8/mAtvtLiKy2+
ef/RWnwznslafDO+2Vp8M97FWnwz/tVafPN5Nmvxzfe4W4vvuTq0XbcUzLMj
L+I+ynWX85RcOeb+22P/7bH/9uYrnftvj/23x/7bm6907r899t8e+2+P/bfH
/ttj/+2x//bmK537b4/9t8f+25tv+gjX0Iev0K5DS5XXMg/ivsl1lvOSHKU5
iq+0+Ob1B2vxlRZfafHN+4/W4ptxTNbim/HN1uKb8S7W4pvxr9bim8+zWYtv
vs/dWnzP+URtX6FUdQrzWuZB3De5znJekqM0R/HN6w/W4istvtLim/cfrcU3
45msxTfjmq3FN+NdrMU341+txTefZ7MW33yfu7X4pj58v7ZPVKq6k3UK81rm
Qdw3uc5yXpKjNEfxlRZfafGVFt+8/2gtvhnPZC2+Gd9sLb4Z52Itvhn/ai2+
+Tybtfjm+9ytxfecj9v2/Q6fiL4C61DWLcxzmRdxH+W6y3lKrhwzfx6QPw/I
nwfzlc78eTBf6cyfB/OVzvx5MF/pzJ8H85XO/HlA/jwgfx7MVzrz59qXb/u4
pfKF6COw7mSdwryWeRD3Ta6znJfkKM1RfKXFN+8/WotvxjNZi2/GN1uLb8a7
WItvxr9ai28+x2Ytvvk+d2vxPddnafvypfL56AvRR2DdyTqFeS3zIO6bXGc5
L8lRmqP45v1Ha/HNeCZr8c34ZmvxzXgXa/HN+Fdr8c3n2azFN9/nbi2+5/pm
7T5LqXxb+nz0hegjsO5kncK8lnkQ902us5yX5CjNUXylxTfjmazFN+ObrcU3
412sxTfjX63FN59nsxbffJ+7tfie64O2+2YF+9Thy9PHpe9Hn4i+AutQ1i3M
c5kXcR/lust5Sq4cs/4dzVc669/RfKWz/h3NVzrr39F8pcU3n2ezzvp3RP07
ov6t+9rtPmip+ir04enb0uejL0QfgXUn6xTmtcyDuG9yneW8JEdpjuIrLb4Z
32wtvhnvYi2+Gf9qLb75PJu1+Ob73K3F99w5hXZfuyCPPOH/9dFnoS9PH5e+
H30i+gqsQ1m3MM9lXsR9lOsu5ym5ckx/YzJf6fQ3JvOVTn9jMl9p8c3n2azT
35jgb0zwN+pzJ+1zCqXqe7JPxr4KfXj6tvT56AvRR2DdyTqFeS3zIO6bXGc5
L8lRmqP4SotvxrtYi2/Gv1qLbz7PZi2++T53a/E9d46ofe6koM47Yd85+qDs
m7HPQl+ePq740heij8C6k3UK81rmQdw3uc5yXpJjxneM6V/N5iud/tVsvtLi
m8+zWad/NcO/muFf1efC2ueISnUugX1s9j3ZJ2NfhT48fVv6fPSF6COw7mSd
wryWeRD3Ta6znJfkKM1RfKXFN+NfrcU3n2ezFt98n7u1+J4759c+F1bgw5yQ
Fx7nFNjXZh+UfTP2WcSXvi19PvpC9BFYd7JOYV7LPIj7JtdZzktyzHiPMf3J
xXylxTefZ7NOf3KBP7nAn6zPbbbP+ZXq3FDm+S+qcwn5+a7qe7JPxr4KfXj6
tvT56AvRR2DdyTqFeS3zIO6bXGc5L8lRmqP4SotvPs9mLb75Pndr8U19nMNt
n9s8zvml/3ycG5LmuROeU2Bfm31Q8WVfhT48fVv6fPSF6COw7mSdwryWeRD3
Ta6znJfkmPEfo/jm82zW6T+v8J9X+M/1uer2OdxSnevLOvxFdW4oP99V5xLy
+33V98w846rqq+T1h8q3labvR5+IvgLrUNYtzHOZF3Ef5brLeUquHMVXWnzz
fe7W4pv6OCffPldd8P/oBF/lOOfHc2HZX9jQXzjOJWSdd4m88Qr70Gtc/+iz
0Jenj0vfjz4RfQXWoaxbmOcyL+I+ynWX85RcOWZ/YUN/YUN/of7dQ/ucfKnO
3fKcJs/18RwYzw3xnAnPJbCPzb4n+2Tsq9CHp29Ln4++EH0E1p2sU5jXMg/i
vsl1lvOSHKU5im/+buUa+vgdS/t3DwXr/Am+53EOl+c2xZfnwHhuiOdMeC6B
fWz2PdknY1+FPjx9W/p89IXoI7DuZJ3CvJZ5EPdNrrOcl+SY7/MYxffc75La
v2Mp2LdP8LGPc9U8hyu+ed9X+H4PX+0SdfoV8v7XuP6Adenog7Jvxj4LfXn6
uPT96BPRV2AdyrqFeS7zIu6jXHc5T8mV4/88ZMtv
     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{1, 0}, 
      NCache[
       Rational[1, 3], 0.3333333333333333]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->1416313729,ExpressionUUID->"fcac6cbc-7dd9-4204-abb8-b35d75d98084"]
}, {2}]],

Cell["as can be checked with:", "SolvedExampleNote",
 CellID->175475252,ExpressionUUID->"e3970cdb-ac83-4a3c-a466-2ab9e0758a33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", "^", "3"}], "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"z", 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}], ")"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}], "]"}]}]], "SolvedExampleInput",
 CellID->19421528,ExpressionUUID->"0eb40752-6534-4e34-b0eb-d8d5f7184922"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "SolvedExampleOutput",
 CellID->46030225,ExpressionUUID->"16b92dfa-dd55-433d-ae98-6b7bb838210c"]
}, Open  ]],

Cell[TextData[{
 "You can confirm using the command ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->617999607,ExpressionUUID->"c536b0e3-feb8-429a-95e9-d072f5d84af8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "3"], "-", "2"}], 
    RowBox[{"z", "(", 
     RowBox[{"z", "-", "1"}], ")"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->14824385,ExpressionUUID->"680c4b3e-92d3-42f8-89a9-13ce4014c378"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->90514778,ExpressionUUID->"931da3bc-cb59-42dd-b031-94b264b6b50f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "3"], "-", "2"}], 
    RowBox[{"z", "(", 
     RowBox[{"z", "-", "1"}], ")"}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->173643312,ExpressionUUID->"f33549cd-7f32-4f85-9c4a-3ccd496f6a1d"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "SolvedExampleOutput",
 CellID->440348068,ExpressionUUID->"8571fe1c-035d-40d4-87c4-6422b8367476"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1442706338,ExpressionUUID->"bd883170-8be5-4e2d-89b0-bc8e8c974057"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->737719333,ExpressionUUID->"951442c8-b9aa-43f6-97cc-c4261fa8fec3"],

Cell[TextData[{
 "Find the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"exp", " ", "z"}], "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4ec97800-172e-46fb-8089-8e9e21a77ad8"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "24b996c3-3568-42f7-bfb4-1104a68fb738"],
 "."
}], "SolvedExampleNote",
 CellID->968566102,ExpressionUUID->"0efdd959-25ab-41a4-9cd3-91da78daa00b"],

Cell["Using the formula:", "SolvedExampleNote",
 CellID->569809934,ExpressionUUID->"45cfbb4e-2aa7-4071-ba44-d9a14610f27c"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"9a8b9a56-793e-479b-b13f-2082174525c9"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      RowBox[{"z", "\[CenterDot]", 
       FractionBox[
        RowBox[{"exp", " ", "z"}], "z"]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", "0"}]], 
       RowBox[{"exp", " ", "z"}]}], "=", "1."}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f632b714-d837-4af1-8e23-2ee4f2e0d923"]
}], "SolvedExampleNote",
 CellID->26551088,ExpressionUUID->"741888f9-b7d8-46ed-b8ac-fbbfe68f1219"],

Cell["In Wolfram Language:", "SolvedExampleNote",
 CellID->365059817,ExpressionUUID->"998a91ee-9609-4851-b801-a5537310a85c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], "/", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->458530947,ExpressionUUID->"7999b42b-8318-400a-8ba8-1bc740e72b8e"],

Cell[BoxData["1"], "SolvedExampleOutput",
 CellID->186142935,ExpressionUUID->"8fad7124-7ad2-46f3-ba1d-219ed1a24c78"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1062303059,ExpressionUUID->"2ad27f87-038b-4aab-98e5-d092a01948ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Residues at Higher-Order Poles", "Subsubsection",
 CellID->140574552,ExpressionUUID->"f6bd7cdd-f454-4ae8-97c1-5f3b42d7752b"],

Cell[TextData[{
 "A similar method can be used to find the residue at poles of higher order: \
suppose that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"28349fc9-5912-43ab-8bbb-dc769dee9957"],
 " has a pole of order ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d6f425a7-2879-4398-a2de-a228912135b3"],
 " at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bd8cb623-969d-44e3-9924-f94eed8f8f2d"],
 ": then its Laurent series is"
}], "Text",
 CellID->1008736006,ExpressionUUID->"fdecc6d4-f82d-4f60-b084-68cd287ba722"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "(", "z", ")"}], "=", 
   RowBox[{
    FractionBox[
     SubscriptBox["b", "k"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "k"]], "+", 
    FractionBox[
     SubscriptBox["b", 
      RowBox[{"k", "-", "1"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], 
      RowBox[{"k", "-", "1"}]]], "+", "\[Ellipsis]", "+", 
    FractionBox[
     SubscriptBox["b", "1"], 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}]], "+", 
    SubscriptBox["a", "0"], "+", 
    RowBox[{
     SubscriptBox["a", "1"], 
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}]}], "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "2"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "2"], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->223245362,ExpressionUUID->"d6efafad-bfe0-4c8d-b73d-b1fcae756e1a"],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "k"], 
     RowBox[{"f", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"06f0e7f8-9485-4a8b-bdc4-bd0048e28e47"],
 " has a removable singularity at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8ad1bbc6-a2b4-4844-8b03-c57c42055dad"],
 ", and its series expansion is"
}], "Text",
 CellID->301713522,ExpressionUUID->"ce9c0fef-96ba-4ad0-ac32-c9f1eea51032"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"g", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    SubscriptBox["b", "k"], "+", 
    RowBox[{
     SubscriptBox["b", 
      RowBox[{"k", "-", "1"}]], 
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}]}], "+", "\[Ellipsis]", "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["b", "1"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], 
     RowBox[{"k", "-", "1"}]], "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "0"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "k"], "+", 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "2"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], 
     RowBox[{"k", "+", "1"}]], "+", "\[Ellipsis]"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->348782592,ExpressionUUID->"e1cad3b3-0b95-48e9-85bd-c12f9f6ed3d3"],

Cell[TextData[{
 "So the general formula for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "1"], "=", 
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"f", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"eac74f90-3a62-49cf-a981-3e4beccdd314"],
 " is"
}], "Text",
 CellID->18552761,ExpressionUUID->"74067a8e-b14d-4fef-82fd-fbbf3fb393ec"],

Cell[BoxData[
 FormBox[
  FrameBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "0"]}]], 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"k", "-", "1"}], ")"}], "!"}]], 
      RowBox[{
       FractionBox[
        SuperscriptBox["d", 
         RowBox[{"k", "-", "1"}]], 
        RowBox[{"d", " ", 
         SuperscriptBox["z", 
          RowBox[{"k", "-", "1"}]]}]], "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", 
           SubscriptBox["z", "0"]}], ")"}], "k"], 
        RowBox[{"f", "(", "z", ")"}]}], "]"}], "   ", "if", " ", 
      SubscriptBox["z", "0"], " ", "pole", " ", "of", " ", "order", " ", 
      RowBox[{"k", "."}]}]}]}]], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->646897887,ExpressionUUID->"64e732d5-4599-4ea5-93ac-b11b46972c76"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->95196737,ExpressionUUID->"f808dd0a-37b8-4f05-a7fe-5ee7b75d59fc"],

Cell[TextData[{
 "Find the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "-", "4"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}]]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "8566e92a-c64a-48c8-8c8f-3233be8fcbc4"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2669d606-485e-4e41-8042-daf6086e5129"],
 "."
}], "SolvedExampleNote",
 CellID->366355903,ExpressionUUID->"a054a4c0-9647-4a39-b4c2-a11c56383fc2"],

Cell[TextData[{
 "Using the formula, because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3939d3ba-86c2-47fd-90cb-e3aad96f9a83"],
 " is a pole of order 2:"
}], "SolvedExampleNote",
 CellID->59882574,ExpressionUUID->"449b7010-cfbf-47f0-b9f8-09da1b33afb4"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Res", 
     RowBox[{"z", "->", "\[ImaginaryI]"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "\[ImaginaryI]"}]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "!"}]], 
     RowBox[{
      FractionBox["d", 
       RowBox[{"d", " ", "z"}]], "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"], "\[CenterDot]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "2"], "-", "4"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "-", "1"}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}]]}], "]"}]}]}]}],
   TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "\[ImaginaryI]"}]], 
     RowBox[{
      FractionBox["d", 
       RowBox[{"d", " ", "z"}]], "[", 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], "-", "4"}], 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]], "]"}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "\[ImaginaryI]"}]], 
     RowBox[{"[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "z"}], 
        RowBox[{"z", "-", "1"}]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "2"], "-", "4"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "1"}], ")"}], "2"]]}], "]"}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox[
       RowBox[{"3", " ", "\[ImaginaryI]"}], "2"], "."}]}]}]}], 
  TraditionalForm]}],ExpressionUUID->"795a2c59-0ab9-4df5-86bf-f3f8f25dfdfd"]],\
 "SolvedExampleNote",
 CellID->59020675,ExpressionUUID->"04df45f2-890b-4f09-8aa6-57c20942c716"],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->49210441,ExpressionUUID->"b613bc16-e644-4952-9e82-b294ba441ee5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "-", "4"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "I"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->280052835,ExpressionUUID->"54591534-35b8-4c4e-ab68-ba87003fdc76"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]], "SolvedExampleOutput",
 CellID->207020945,ExpressionUUID->"47972ce2-567a-4945-8648-96efdb01ff24"]
}, Open  ]],

Cell["Visualize the function around the pole:", "SolvedExampleNote",
 CellID->411345042,ExpressionUUID->"8f7dd286-051b-42e2-82d8-6be27f9fc5f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", "4"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "I"}], ")"}], "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["960", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[{0, 1}, 1/3]]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->40425968,ExpressionUUID->"3bbcf899-6da6-4bb6-adc7-97380e0f0f66"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxc3HVc1ene8Pvndc4/5zzPc9+7ZvbUntTR0RnHsWlYdHd3p3QrISGgIKLS
ClIK0khJs2hWd7ACVnf9VhPus2Bm38++D7xB4A9evD7r+l6/60f4fXS6d/z/
9T/+x//I/n8Mr7yj8kFZWVGFPn82vOOXlp2UkBYX65SWE5cQl2UU/X8bPhj7
x8vp25aLcAOrRQRo4ZT1AtJmHmk7j7SbR9nPoRzm0I4f0E6zGOdZjOsM1m0a
5z6F95wkeL0n+kwQfcfI/qN7gcOUoCFqyDtaaP9++NuDiD5mVA8r+jUntoMb
95If3ypMaBInvpAmNciTngBptUBWDZBbBRRWAsVlwINSoKIIqC4EHucBdVnA
03TgeQrQmKBojVF0REl7IsRvwwRDIbyxQPakP3PWZ3/ek7bsugd2JG3YErYt
sRAzFMwMijDdQpmAMSZLWOM5vNEUwWiceGeYdGeAfLtv73Y35VYH9VYb7WYz
/eaL/RsN+zeeHNx4fHCjhnHzIeNWBeN2GfNOKdOohGlcxDK+xzIpZJnms0zz
WKY5bLNstlkW2zyDbZ7ONk9jW6SaLcMMzM9YLMEtl+BWS3DQEsJ6EWGziLBd
QNotIO3nUY5zaKc5tPMHjOss1m0G5zGN95oieL8n+k6Q/MfJgaN7QcOUkCFa
2Dt6eP9B5BtGdC8rposT18mLf8lPaBMmNouTXkiTG+R3nwAZtUBODVBQBRRV
Ag/KgIoSoPo+8LgAeJIDNGQCz1OBpiSgNU7RESPtjRL3RwiGQ3njweypAOYH
3/1FL9qK2966E2nLFr9riYVaIODmu0izDbTpKtZ0AWcyQzB+TzQeJRkNko3e
7t3podzupN5up91qod9q3L/VsH/zycHNx4xbNYzbDxl3KphGZUzjUqZxMcuk
iGV6j2VawDLLZ5vlss1z2OZZbItMtkUG2yKNY5nKsbzLsUwxW9k1W4H8C/QM
zHwFZrECs1yGWy2fdrNZQtguIu0XUA4LKKd5tMscxvUD1n0W5zmD954i+E4S
/SdIgeN7QaOUkGFq2CA9YuAg6i0jpo8V282Jf81LeCVIahMlN0tSXsjuNijS
nwDZtUB+DVBUBZRWABUPgOpi4PE94Ek+0JANvEgHmlOAtnhFZ5ysN0Y8ECkY
CedNhLCnA5lzfvtL3lSw+96GE3HbFg+xwsAt4UiLbbT5GsZ8GWc2RzCdIpqM
k0yGyMb9FONeqtFr2p2XtDut9NuN+7efHdyqP7j1mHG7hnGnimlUwTQuY5qU
skyLWWb3WWaFLPMCtnke2yKHbZHNtsxkW2ZwLNM5Vqkcq7scqxSOVTLHKsl8
devM9r/sWJzaPQOxWIVarMIsV2FWK3DrZYTNMsJuCemwiHJaQLvMY9zmsB6z
OK8ZvM80wW+SFDhBDh6nhI5Sw4fpke/2o/sZsW9Y8T2chNe8pA5BcrsopVmS
+kKe2gBkPQHya4H7NUBpFVBRAVQ/AB4XA08KgWe5QGMm0JwKtCUCr+NlfbHi
d9HC0QjeZBh7Npi54L+/4kNdc9/bcibu2uJh1igECIqy2sJYgnEWi3jzWaLZ
e5LZCNn0HcXkDdWkm2bcQTdq2zdq2r/z7OBOPeN2LcOohmlcxTSpYJqWscxK
WWbFLPP7bItCtkU+2zKXbZnDtsriWGVwrNI5oDQO6C4HlMIBJXOsk7jWiVzr
BIvV9VPgjf9iCd48s3Vm2xK8YwXetQJDrMBQKzAMtAq3WUHYLSMdllBOi2jX
BYz7PNbzA85nluA3TQycJAVP7IWOUSNGaFFD+zEDjLi3rIReTlIXL6VDeLdd
nNoiTXuhyGwA8uqBe7VAaQ1QUQVUlwOPS4H6IuBZAdCYA7SkA+0pQFei7E28
ZChWOBbFmwpnfwhhLAbur/pSNzzIO85EqC0OboNEWu9iQBtYqxW85RzRcppk
MU42H6KY9VNNe2imnXST9n3j5gPj5wdGTxlGtQzjGqZpFdOsgmVexjIvZVkU
sS3vsS0L2FZ5bKtcDiibA8rkgDI41mkc61SOdQrXJplrk8S1SeTaJHBt4rk2
cRbgVcv/A2xg9Yc1AxB4HQTeAIE3QeAtEHgbBN4BgXetwRAQGGYNhtutIhyX
Uc5LaLdFjOc81nsO7zdLCJwmhUzuhU1QIkdp0cP7ce8YCf2spD5uSjc/tVOY
1i5Jb5FlvAByGoDCeqCkFqioAaofArXlwNMS4Pl9oCkfaM0CXqYC3Sny/kTJ
cLxwIoY3E8meD2MsB+2v+VG3PMm7LgSYPRZpB0fbbmNt1vDWiwTQLMnqPdly
hGLxjmrRRzN/TTd7uW/acmD6gmHylGFSxzR9xDSvYllUsCzKWJYlbKsiNuge
G1TAts7jWOdwrLM4Nhkcm3SOTSrX9i7XNplrm8S1TeTaJnBt47l2sVy7GJ5d
jOXakoHVvwGdWj6zYn1q9QzYZm3NZm3dZm3TZm3LZm3HZm3XZg1qswa3ByOc
VlCuy2iPRaz3As5vjhA4SwyZJoe/p0SN02JH9uOHmEkD7JQ33NQeQXqnKOOl
NKtFnv1CWfhMWVKvrKhVVtcoax8qn5YpX5QomwuVbbnAqwygJ1U+kCIZSRS+
j+PNRrMXIxirIfQNf+qOFxnqQkA4olEOUKz9Jt5ulWA7T7KZJluPU0BDVKu3
NMtuukXHvnnrgVkjw6yBaVbHNH/EsqxiWVWyrMrYoBK2dRHb+h7HJp9jk8ux
zebYZnJt07l2aVy7u1y7FK5dEtc+kWufwLOP49nH8uxjePbRPPsonn2k1dr8
H9bnQf9i/YcFA5v1xTNLtuvLtusrtuurdutgu/V1u/UNu/Utu/Ud+3WI/Rrc
YQ3psopyX8F4L2H9FvBBc8TQGXLEFCV6ghY3dpA4zEx5x059y0vvEWS+Fme/
lOW0KAoalcXPlOX1yupaZV2NsqFS2VimbClSvixQdmYrezMU71IlYynCqUTe
XCx7OYqxFkrfCqRAvMlwVzzKGYlx2sU5rhMclkn2H8h2kxSbEar1AA3Uu2/V
eWDVzrBsYlg8Y1o8YVk9ZoGqWdaVbOsytk0J27aIY1vIscvn2OVy7bO59plc
+3SufSrXIYXrkMxzSOQ5JPAc4ngOsTyHGJ5DNM8xiucYyXOM4DmGW63PWq3P
gP6N9cYfbDZmf2e78cF2Y87u1LzdxoL9xpL9xrL9xorDBthhY91hY9NxY9tx
HeK4DndaR7qB0V4rWL8lfNA8MewDOWqGEjtJSxg/SB5hpg5yMt7ys3qFOa8l
eS/l+S3K4iZl+XNlzVNlXa3yWY2yqVLZ9kD56r7ydZ7yTZZiKEM6kSqaSeYv
JLBXYxgb4fSdIArMh4R0x2HcEDjXbYIzmOS0QHacodiPU+2G6LZv9m26Dqxf
MkAtTKvnTFA9y7qWZVPDtq1k25Vx7Eo49kUch0KuQx7XIYfrmMV1zOA6pvEc
7/KcknlOiTynBJ5THM8plucUw3OK4jtF8p0i+E7hfKcwvlOogdX6JGjjD9Yb
7/+LjcHme9vNyd/ZbU7ZbU7bn5px2PzgsDnnuDnvuLnotLnstLnqtLnmvLnp
vLHtvAFx3oC7rqO8wBj/FVzwIiF8nhw9S4mfoidPHKSOsjKGuNn9gtw+UX6X
tPCVoqhVWd6krHmufPJU+bxW2VyjbK9QdpYquwuVb/MUI9nSyQzRh1T+UhJn
LY6xFUmHhFAQviS0FwbrCSO4b5LcVsgucxTnSZrTKN1hYN++98Cug2HbyrRp
ZNk0sOzq2PY1bPuHHIdyjmMpx7GI61TIdcrjOudwnTN5zuk851SecwrPOYnn
ksBzieO7xPJdovkuUXyXSL5LBN8lnO8SxncJ5TuH8J2D+c5BoI3xM2MG1psG
owY2/2K7dcpua8zAfmvcfmvC4dR7x60px61pp61Z560PzlvzLltLLlsrrltr
rlubbps7bptQt02k1zrGH4wLWSZELpJj5yhJM/TUSUbGGDt7mJc3ICzsk9zv
khe/Upa3qR41q+pfqF48VbXWql5Vq7rKlb3FyoFCYCxPNp0tms/gr9zlbCQy
dmLo8FAKyp+I9UXjfSBEr3WyxxLFfZbmOkF3Gdp3esNw7GI6tLPsm1j2z9gO
T9iOjzhOVRzncq5zKdeliOtSyHXN47lm81wzea5pPNe7fNdkvlsi3y2e7xbL
d4vhu0Xx3SL5ruF81zC+ayjfNUTgGixwDRK4BgpcAwxAmyOgzWED682hU1sG
gzb/YmuwPWh3xn57yMBhe9hhe8Rxe9Rpe9x5e8J5e9Jle9p1e9Zte85te9F9
e8Vje81ze9Nza9dzC+61hQ5Yx4WBCdHL5IQF6t3Z/YwpZs4EJ3+Ef++dqPiN
tLQbKO9QPWpXPW1RNb1QtTWoOmtVPdWqN2WqwWJg4p5sNl+8lM1fS+dspzCg
cXRkOAUTRMAHIon+O2RfMMV7geY1TfcYPXAbYLj2MJ07WE4tbKcXbJd6jstj
jmsV162C61bKdS/iuRfy3PN47tk8jwy+RyrfI4XvkcT3SOB7xPE9YgQeUQKP
CIF7uMA9TOAeInAPFrgHCdwDBe4BAnd/gZvfGV/Q5iBo8x1oa8D6VP+Ztzbb
v3tje8Zu55T9zlsDh51+h50Bx513TjuDzjtDLjsjrjtjbjsT7juTHjsznjtz
XjuL3jsr3jvrPjvbvtsw321U4BYuYp0Qt0pOXqSmzx3kzLAK3nOLRgWlg5Ky
t/KKbtXjTlXDS1Vzq+plo6qrQdVXqxqoUo2UKadKZPP3xSv5/M1szm4aE5FI
x0RS8GE4YgicHLRFCVih+c3t+74/8B5meL5luXex3drZbk0c9waORx3Xs4br
WcnzfMDzKuJ5FfK9cvleWXyvdL5XKt8rWeCVKPCKE3jFCLyiBF4RAq9wgVeo
wDNE4Bkk8AwUeAYIPP0FHn4CD1+Bh88Zb4G7F2jrLWjrzantPuvt3jM9BjY7
3We6bA12u+zO2O92Gzjs9jju9jpB+pwhb1wg/a6QATfIkDtkxAMy5gl57w2Z
9tmd891d8tsFB+xuBuxCAneRwTu46E1i4tpe2jItZ4FROMsunuSXjYkqh2TV
/UBtr/p5l7r1lbqzTd3bpO5vUA/VqserlLMV8qVS8dp9wU4+B5bJRKfQcbF7
xGjsXgSUGrZBC1naD5phBIwz/d6xfHrZXq84Xi1c7+dcn3quzyOe70Oebxnf
t5jvW8j3zeX7Zgl80wW+dwW+SQLfBIFvrMAnWuATKfQJF/qECn2Chd5BQu8A
obe/0NtP6O0r9PIRenkLvbyEXp5CTwMPoac7aKsXtN0D2u4GbXeBtl+Ddl5b
73Ra73RY7xq8sjn10sAWcsoO8tL+1CsHaIcjtNMJ+toZ2uUC7XGD9rlD33pA
33lBh72hY77Q9/7QmQDofBB0JRi6EQrZDYMgwiC4uG1S6gYle3W/cIlZMset
mBZUT0geDyvqBtQv3qjbe9Rdneo37erBJvVog3qyVjVfI1+tlGw9EEDvc5G5
TFwanZhE3otHU2Mh9Ki1g4gFRtgUK3iEHfiW49/F9W/n+jfxAhp4AbX8wCp+
YDk/sIQfWCgIyBMEZAkC0gUBKcKARGFAnNA/RugfKfQPF/qHCv2ChX6BQr8A
oa+f0NdX6Osj9PUS+ngKfTxOebsLvd1OebkaWG2/ttrutNrpAO28Au28BO20
g3YN2kC7rdaQljPNBjbQJgPbM3awZntYswOsxRHW6gRrd4a9dIV1uMFfe8B7
vOBvvOEDvvAhf/hYIHwyGPYhFLYUDluLhO1EwxAxMFzyLjlri1q4dlC6wn64
wH80K37yXtYwqmwaVHf0q3v7NO+6NKMvNe+b1TMN6qUnio3Hkt2HQsQDLraQ
Scyk76URqSlIetLOQfwqM2aOFfWeHT7EDe3jhnTwQlp5oc/5oU/4oTWC0ApB
aKkg5J4gJE8YkiUMSRMGpwiDE4XBscKgaFFQhCgoVBQYLAoMFAX4iwJ8RQE+
In8vkb+nyN9D5Ocu8nc74yryM3A542xgtfPKauel1U671W6r1W6L1W6zFaTJ
CtJoBXlhBXkOgj470wCCNVjDnhrYwJ7awg0a7OAN9vBnjojnTohGZ0SzK6LV
HdHuiejwRnT5IvoCEANBiOFQxEQ4YiYKsRiDAMchdhIQiCQEPh22V7BDf7DJ
rAZz65aEz+akTVNAy7ima0TT/04z/FYz0a2ZeaWZb1aDXyi2n0rhtULMQy6h
hLWXT6flEPYzEYy0LWbKMjtxlhM3xo0e4EV286Ne8qOaBFENgqjHgsiHwsgH
wsj7woh8YUSWKDxNFJ4iCksQhcWKQiNFoWGikBBRSKAoxF8U7CsK9haHeIlD
PMWhHmfcxaFuZ1zFIS5nnMXBv3Oy3Gmz3G2x3G223G2yhLywhDy3hDyzhDZY
QustoU8sYXWWsFoDK/hjK/gjAxDilDXikQ3ikS3ysR2y1gFZ54isd0Y2uKKe
u6OavFCtPqhX/qiuIFRfKOpdBGosGjUVh5pPRIFTUDtpKGQGipCHoD6AHtRs
s5+uC5pWJG0Lio4Zde+kZnBcOzGsnRnQzvdqlzs0W+0ArFmKfiYi1PL2Kli0
Ytr+PTwzH87K3uRkLHFTp3lJI/yEt4KE14KENmHCC2H8E2F8jTCuXBRbLIot
EMVki6LTRdHJ4qh4cWSMODJCHBEqjggSRwSII/3EUb6SKB9JtJck2lMS7XHG
XRLtJol2PRXlcsZZEmngJIlwkoQ7GRJZ7DZaQJ5bQJ5ZQJ5aQOstoHUW0FoL
2CMLWI05vNocXmUOf2iOqLRAVFggyi2Q5ZZnrFDlIFS5NarCFl1ph65yQNc4
oR+7op+4Yxq8MI1+mNZAzKtQTHcEpj8GM5KAmUzBzKdjwVnYnVwsqgBLKkXT
H8FZzyG8ti1x55q8Z0nVP6cdm9FOT2oXxrQrg9r1Pg2kW4nqkOFbRHvPePQa
9kEllVmGZRdDuYXrvLwFftakIH1ImN4nTOsUpbaIUp+J7j4WpTwUJ5eKkwrF
iTnihHRxfLI4Ll4cGy2OCZfEhkjigiTxgZIEf2mirzTJR5rkLU3ykiZ5SJPc
z7hJE12liS7SBANnabyBkzTOSRrraCCJcTyr1GAOqTeHPjGH1ppDH5nBasxg
VWbwSjN4hSmizBTxwBRRaoosNkUWmSGLLFD3rVD3rVH3bVD37dBF9ugiB3Sx
I6bECfPAGVPugq10wVa7Y2u9cU/9cY3BuLZw3OsY3JtE/FAqfjITP5+HX7tH
gJQQMGUEymMcoxHFfQUX9u7KBjaVw6vaySXd/LxudUa3MaHbGdYi3ynxffK9
12J6C5/RwGLXUTg1WF4lhP9gTVg0JyyYEOUPivJ6xbmvxDlN4qx6cWaNJKNM
knZfkponuZshSUmRJMdLkqKlKRHSu2HS1BBZWpAsPUCW4SfL8JFleMsyvGQZ
HrIMd1mGmyzd9VSaiyzNWZbqLLvrdCrFUZbsKE1ylCY6SBMczirVmUFrzU4r
VZvCHprCK0zgZSaIUmNEsTGyyBh5zwxZaIEssELlW6PybFF59qhcR3SuMzrX
BZ3rhs5zx+R5Ygq8MIXe2Ps+2GJf3AM/XIU/vtofXxtAaAglNEcTXyUSe1OJ
Q9nEyULSQilpo5IMryHj6/bozUR2F04wgJKOwoDJHc2HTd3qmn5zWQ+Z0yOm
dLgJ1d6wgv5WwuwUcFqZvMY9fgNGWLsrqgaLyz+IH4xLSt9JirslRe2Sey8k
BXXSvIfSnBJpdoE0M1OacVeakSDLipVlR8lyI+R5ofK8YHl+oDzfX17gKy/w
VhR4KQo8FPnuinw3RZ6rPM9Fnussz3GWZzudynKUZzrKMxxk6Q6yNAdZqr3s
rr2hkin0kelZJRNYhTH8gTG8xAhRdAdxzwRZYIbMt0TmgZA5Nqhse1SWIyrT
GZXhik53R6d7oNO80Gk+mHRfTLo/JiMAmxmEzQ7G5YbiCsLw98PxpZGEiihi
TTSpPprcGE9+mbrXm7M3dJ8yVU5ZekTdfkpFNdLIrTRWL4U/QpRM44B5lGYZ
pt+C6KFbetSaHreo35tT708BrFEp942Q380UvtoTtaLFL3Yl9avS2g/SR+PS
6gHpwy5peavsQYOs5JHsfpms8J4sP0dWkCa/lyK/nyAvilUURylKwhWlIYrS
QKDUH3jgCzzwBkq9gFIPoNQdKHEDil2BYhegyFlx30lxz1FR6KgocFDkOyjy
HBS59vJse3mWvTzTTp5hZwqtNvmjUpkRvOQOoug24p4xwlApzwKZA0Jm2SAz
7VHpjqg0Z9RdV1SKOzrZE53kjU70RSf4YxICMQnBmIQQbGIYNikClxKJS43G
Z8Tis+MJ+QnE+0mkBymkqlRyXfreiwzqy2xabxFt5CF99sk+uHEf+vIA382g
v2Xy3tMlCxQFmKTexOlh6EMM4pAAOdzb1O+DNexFJW9aJhwViAeZkjdkaRda
9nJH1rIqb5yVPx+TP+2X13XKHzXLq+rlFVXyshL5gwJFebaiIl1RmQw8TACq
YoDqSGV1qLImWFkToKzxU9b4KKu9lNUeyio3ZZWr8qGLstJZWeGkLHdUljkA
DxyAEnug2B4osgfu2ykK7RQFdop8O0WurSLH1gRWaQwrN4KX3oEXGyrdQRSY
IPLMkTlWp5Uy7JBpjsi7zqhkV1SiOyreCx3ng47xQ0cHoKOCMJHBmIhQTEQ4
NiISGxGNi4zFRcfjYxPx8cmEpLvE1DRiVgYpP5tcnLdXWUCpu09rLKF3PDh4
W8UYb2AutLG2etiodxzKGIc9wxGDmYqdfTWcqseQj0iEIyrm6AB+yIFo+Zsq
8ZJc+kEgm2TKR8mKAbSid0fRvaromFW0jyma3ypedCieNirqahWPK4DaEqCu
QPkkW1mfpnyarHoar2qIVjWEqxpCVA2BqgY/dYOP+qmn+qmHut5N9cRF9cRZ
VeekeuyoeuSgqrFXVdsrH9opK+2U5bbKMltlqS1QYgsU2wD3bYB7NooCGyNY
2R14yW34/VuIQiNEvikixwKZBUJm2CLT7JEpTsgkF1SCOyrOExXtjYr0RYf7
o0MD0cHBmKBQTEA4xj8S6xeN9YvF+cXj/BPxAcn4oFRCSDoxPJMYnUNKyCen
3tvLKabcf0CtqKTX1ew31zG6GliDLzjTHVxwPw82zid+EDCWhcItgQLJVeNY
etLBEZ12zNw75hCOhBidBKaWb8oVYAGwyFTO7Ckn0MrRXeXgqvLtrLJnVNn5
Rtn+Emh+rmyuVbZUqlpKVK2FqtZsdWuaui1J3RarbovUtIVq2oI0bf6aNh9N
q6emxV3T4qppdtY0OWleOKqf26uf2auf2qnrbdV1tqpaG9UjG1W1jarKWllp
raywVpZZK0utgRJroMj6dDnB791CFBgj8swQ2ZaITBAy3RZ51wGZ7IxMcEXF
uqOivVARPqhQP3RwIDogGO0XivEOx3hGYtyjsa6xWJd4nHMizikZ73QX75xO
cMkkuGUTvfJIfoXk4KK9yFJKQgU1o5pWWLdf8YxR38xse8l+08WdeMNfHBLu
zIhwq5L9bSkfJpXjxWqKUL/PO2azj3mMYxHtSLqnU+A0SoRcBRGqN5jqlT31
AkY9C1FPgtWjs6p3o6o3farel+reF+qeOnXPQ01PqaanQNOTpelN1fYmaHuj
tT3h2p5gbY+/tttH2+2p7XLTvnbRdjppOxy0r+y17XbaNltNi42m2VrTaK15
DlI3gNT1IHUdSFULUj0CqapBqocgZQVIWQ5SPgDdOg2Vb4zIPQuVYY1Ms0Wm
OCATnZFxrqhoD1SEFyrUFxXkj/YPRPuEoD3DMK4RGKcojH0M1iYOC0rAWSTh
zO7iTdLwRhkEoyyCUS7ROJ9keo9sWUy2K9tzq6T6P6JFPqGnPD/Ib2VWdrKf
9XE7h/jDE8K5WfHmohS9JaciFVw8INsDNEy5nis5FopOJPwTOedYydCrKRoN
UaHFCLUwlnaXot3AalehmgWwZmZWMzGiGX+jGevQjjVpR+u1I1XakVLdSIFu
JFM3nKIbjtMNR+qHQ/RD/vohb/2gh/6dq37ASd/voHtrp3tjo+u11nWDdF1W
2k4r7StLbbulttVS02ypeWGpeWapfmqpfmKprrVUPbJUVVuqqiyVlZaGUEaI
XFNEliEUCJlqi0x2QCY4I2PdkFEeqHBvVLAvKiAA7ROE9ghBu4RjHCIxNtEY
y1isaTz2diLuWjLulzT8Tzn4y/cIv5QSfq0kXqsh3awl33m6Z/acAmqk2rfQ
3Nrovi8Pwl4xEjpZmW84lcO8pknBm3nx9Jp0fUeOggMUvIpDVUuZGjVPrRcr
j2XyE0B6ohIda3iHOqZGT1foySI9nq1H03RwnG4bqlsD61Y+6JbHdYsDuoXX
uvkW/Vy9/kOVfrZEP5unn0k/nEk8nIk+nA49nA44nPI+nHI/nHQ+fO9wOGF7
OGZ9OGqlH7bUD1roB8z1b810fWa6HjNdl5m2w0z70kzbZqZpNtM0mmuem6sb
zNVPzNW1FqpHFqpqi99DWRhCIf5PKFdkpAcqzBsV5IvyC0B5BaHdQtCO4Wib
SIxFNMY4DnsjAftLEvZcFu58If7HB/gLVYSf6oiXnxF/aSb92k6+3rl3q+f0
x5mWAzS7IbrLyL7POCP0PSthip01yyuZE9QtitrXJCMQ+TIagBNVe1QNm6mV
8HUqsf5QoT1Wqj9qlB918hO9+OhQoD3iKI4Y4kMa55BEP8Th9UiYHr6hhy4c
7k4ebg8ebnYdbrQcrtcfrj08BBcdgbOPVlMOV2MPV8L1S0G6RV/dgod23kU7
56j9YKedtdZOW2mnLHTvzXTjJvoxY/2IkX7ISD9gpH9jpOs11nUZ6zqNtS9N
tG0mmmZTTaOp5pmZ+qmZ+omZutbcBJFtjsiwQqTaIJPtkQlOZ6HckaFeqEBf
lK8/yjMI7RKCtg9HW0ViTKIxN+IwPydgv8vEfX8P9305/odHhHMNhPPNxB9f
ES/2kC71k38Z2rs6vndjknJnlmo2T7dZ2ndePfBeY4ZssuO3uVkQfilc+AQl
eYWRDeGBOZJqe19D4ujYAr1EcqgCjvTqwxOt/qNe+/FIfXKsODqWao9FwDFP
csTiHu3Tj6jEIzLyiLh9hF8+wk4doQePkN1HiOZjeN0xrPwQck+/m6XbTtZu
xWo2w9QbAap1b9Wau3LVSblir1y2US5aKRfMVXOmqlkT9bSRZvKOduK2buyW
buSWfuimfuCW/s1tXe9tXdcdXYeRtt1Y22qsaTLRvDDRPDNV15uaITItEWnW
iBQ7ZIIjMtblNFSYJyrQ5zSURyDKOQRtG4a2iMTcicZcjcP8eBf7bR7u21Lc
tzX4bxsI37USvn9N/OEt8dww6cf35Iuz5EuLe7+sUn7boN7aoZlA6VaIfQc0
wxPHCiaw40i8TIqglCaq35d2MhUjbOUiTw0RaAkiPUN2ZBg+leZErzs5OTz+
eHz4zxPdxxPN0YlSeyJXnoglxwLeMe/gmE0+ZqKPD3aOaSvHlOnjvcFj0usj
QvMhrk6HqdCi76mRWSpEshIeDcBCFRB/+a6nbMdFtu0g27SRbVjJ1szlq6by
ZWPF4h1g/rbywy3VzE311A3NxA3t2HXdyHX94HV9/w19301d9y1d523tqzva
NiNts7Gm0Vjz3MQCkQ5C3LVFJDog45yRUa7IMA9kkDfKzw/lGYByDj4LFYG+
HY25Eov5Pg37dSHu6wrc10/wXzcTvu4kfPOW+M0o8dtp0vcL5B/A5PPbexdh
lMsoyhU89TqZdodKt9jft2cceLCYQRxWHI+bJRA8EImfSmWdMsWYQrUMaGBK
HVl9yNYci7UnSv2J/ujjycnHf348+efHo48fDe9pdR9Vyo+A9KOcfyJlnoj2
TgToE97OCWf5mDl9dDCkp3frqC2avSdqUoWSeE9ByJTjEqXYKAkmWIz2ESHd
RAhHIdxWCLUS7pqLdkxEW0bijdsS8C3pyg3Z0g3F/HXgwzXl9DX15DXN+DXt
6G+6od/0767p317X9dzQvb6l67itbb+jbbmjaTKyRKRaI5LtEPGOyBgXZIQ7
MtgL6e+L8vJHuQSh7ELRFuHoO1GYKzGY79Kw/7iH/eoh7qsG/Fft+K96CV8N
E7+aIv5jkfT1OukbCPlbFPl7wt75PfIlGunqPvEWk2DGJthyia58kp+QHCmm
pEjpBXJGFcBpUgneqCVTWsW6XoU61FKPDrnHx9LjE/XJx8OTfxpS/fOfhhfD
v8dH/zzUfdSrPmplH9WCj0rGR8XeiRRzLN49Eq7oeTM6zrCG1a1itigPnijo
5TJaoYSaLqLEC8nhfJI/j+jJJThzcLYcrBUHbcZBGnPht3nQm/zdG4Lta8KN
a2Lwb5KVq7LFq/K5q8DMVdXUVfXEVc3oVd3wVf27q/q31/S913VdN3Qdt7Tt
t7Wtd6wQKTaIRHtkrBMy0hUZ6oEM9Eb5+KHcAlEOwWirMLRRJPpqNOaHu5iv
CrFfPsR9+Qz/xUv8F28JX4wRvpgjfrFG/AJC+hJD+opE+oaCP0/HXmKgr7JR
N7kIEwECZHhMJQhPGTJIgYpRYtJU+Psa8iMtrVXPHDjkzR6JNo/l2BMV/aOW
//FQ/vFY88+To39+PE119mRYXkeno3ik+ngoPdHxjzXMY9XeEYDRy3d10lWt
eEYtHFbyuxW8ZhmnTsIuE7Ly+My7XEYM+yCYte/NoLkcUG0PKJb7ZJN94p0D
/E0G9joT/RsLcZUD+5W7e4W/dUW4fkW8ekW6dEU2f0Uxe0U5dUU98atm7Fft
8K/6wV/1/b/pe6+d5bqpbb8FQiTbIuIdkDHOyHA3ZLAn0s8H5emPcg5C2YSi
TcPR16PQFxIxX+Zhv6zAfdGA+/wl/vN+wmfvCZ8tEj/bIn6GJH1GJH5BwX2z
jz7PRFziQH/l714XbRtJNs1lG7aKDWflhrd6M0S7FaffzTiEFR+hao9xbcfk
dyf0uRP2zokA/1F68BEQftQoDBv6P4+OTpfT6bPByeky+6g9OQGOjyRHh7wj
3YFeS9ap0VrljhpYUcmnAemgTNIlETeKhI/4ghI2L4fBTaaxoyisQBLDk3Dg
hN+3xtPNCLTbROq1PeoVCvlnKvEyHXfpAH3J8NWyoZe425f5G5dF4MuSpZ9l
8z8rZn9RTv2imvhFM3pFO3xF/+5X/durZ7mu6zpuWCMS7RBxjsgoF2SYOzLQ
C+nji3ILMCwqlGUY+k4E+udozFeZmC9KsZ8/wX3Whv/sLf7v7wmfLhE+2SF+
giV+QsZ9QUN9w4Cd4+z+xN/8RbR2Tbp6S7FkYrjiaObtdfOuh/O+h/Nhh/OJ
hws5h8tlh2tPD7c6D2HDR5iFI/Lu8T7+mHNwIhScyBUf1dqPuqOPpxvW2fx9
PDn8eKg/UeuPFbpjse6Io9Xva3REtRapVG8pVEsyYEqsGBTIujiSJoaoliYo
I/PycNxUFDsGzgyGMLy3D5y36DZbNPNt6p0d6nUo5QqScgm7d4G0d45COEfD
nj9A/siEXeDsXORv/CQE/yReuiSbv6yY/Vk59fNZrl90Q4ZcV/Rvf9X3/mbI
ZYNIsEf8PoAhHsgAb6SXH8olEGUbgjILQ1+PRJ9PwnxRiP28GvdZE+7vvfhP
xwmfLBL+tkv8K4741z3M5/vwb1i7P/A2LopWfzYMPjB3Qz1zRztpdjgB0o86
6Ye8dIPBuncx2nep2sEC7UilduKZdqZTtzisW5/XQ7YN56UjGuOILTw9GMi1
J+rjY8PMHf3z6Pij/uREe6LXHGtUx3LlkRA4ZCv0NLmOINMgJeotkWqZD0yz
5cMMWQ9V0koU1WMEFXBe4TYnfY0Vv8QMnT/wnd13nabbTdMsZqhGHyg3FvZ+
Xd27vLl3AUr+AUP+9nTTwH1HR/3ANDzQOz/yNi4IVy9Kln6SzV1SzFxWTl5W
j/+sGflFN/iLfuCK/s2vup7fzlrFOCEjXJHBHkg/b6SnH8opEGUdgjIOR/8a
hf46HfN5KfazetzfO/CfDOH/Nkf46zbhLzjin/fQnx3A/sHZ+l4A/lGyeMkw
7IZLieGsoh8y0b0B6bodtR0emvYAdWu4uiVB1Zyharmnan+o6nim6ulQD49o
Zhe1a1AdjKjHMw+pokOO8lCkO1Qc69UfdbqP2sOPmuNj1bEeOFbLj+TSQ6FY
zxTpKEItnq9BcNVbbOXyATBDlY+QpH1YSTtc1LAlqFrhFc1xst6zEocZ4f37
/n10tx6afTfFsodi/Gbv5jvy1THy5RnyhSXyuU3ytwjS1wTSl3u4r+mo75jQ
Hzjb5/nrP4pWLkgWLso+/ARMX1K9v6we+1k7/LPu3S/6/iv6vl9tEPH2iGgn
ZPhZK19vpIcfyjEQZRWCuhOOvhyD/jwH89lD7N+bcJ/04f82if/LGuHPaMKf
9tCfHkC/4mx+J1w+b/jMysmftSNX9QOGY4mpth2kaXRQP3VT1fooq4OByihF
eaKiLFNedk9eXa142gS09il73qtGVtWzcA2YrIWxtQSJlq7Scg81kmO14qNK
/VGpO1EcHskPdYYDqvhQJtQLeToWW0tharAMNWxftUlVLpMVMzj5KFL6dkfc
ARa+mOM/GueWDrBzXjOTWw6intED6qgejykOj/asaskmT8k3m0hXX5F+7iNd
HCGdmyV9ByZ9DSN9SSB9vof9io74lgn5nrt5zvC4i5cuSOcvymd+AiYvqcYv
a0Yua4d+1g/8on975d9aBZ21cvdDOQSiLENQtyLQF+PRnxVg/v4I+2k77m9D
+L8sEP4MJfwnCfuXfdjnnI1vREs/yGcuqMcuG4Za13VL22pquE9XPbJXlrso
irzk+f6yrFBpWrQkLUWalS/Nr5AWP5VVdsieDMqbZxVdG8AQGvhAU27wlAi5
kqQBGIcK/rFcciIDPsrUxxLdoUivFeiVXL2UoxOwtCyGhkbXEChqBFG5iQOW
UYpZqGxsUzqwJH49I2wb47/o59a9Zj9sYZQ83c+roaWVU+KL98IKyT55JIdc
4p37xN8eEn9uIF58RTw3QPxumvg1mPgl/PTa9BkV/dUB7Bv29ve89XPClR8l
CxdksxeBqZ+UE5fUo5e1w5d1737W9//yRyvEf62r/2p1MwJ9IQH92T3Mp3XY
Tzpxfx3H/3mN8J84wn9QEZ+yNr8SLn0nn/5RM/KTvu+K4XqqbjBVVVkBJXaK
XGdZmrskwUccESiOjBZF3xXF5YkSy0SpdaKsVnFh3+n3yR8tSpohkl6CdIwh
XRBJt5USrFZMPRSxjkWCE4H0RAAcGe6jOVoNW6tgaMX7Wh5dw6RpaHtqIkmF
wikhaGADrljekX1Yk04uikemhQMj/J4+7suXrKbnjPrH+9Xl1NL7lII8cnoW
KSGdGJZK8E7F26XibxTgL9YQzrUSvusnfD1D/HKD+Bma+CkZ9xkd8Q/m7rfc
je8Fq+fEiz/KPlxQTF9Uvv9JPXbJsLR0g5f1Az9bI+LtEDGOiAgXZLA70s8L
6eGL/H0Gb4WjLyag/34f82k99m/duL9M4/+0S/gPEubPB7uf81e+kU2f0wxf
1HVf0TTeUj0yBYqt5Nm20iQnSYSbKMBLGBAiDIgVBKQKgvIFIQ/44Y/5UU38
uC5+yhA/7wO/bIP/BM1vp/Lf8vhTMt6akgPXsfFHbPoxm3PMFB6zZIcMpW5f
raKr5VSNiKThkNUMkppKUBFxSgwGgCEVO1D5+rZsZU26sCCemRK+H+KPdHMH
Wlg9dYxX5fSmQmp95l51CulBAiE/Dp8ei4uLxQXF41wSccYZuPMP8Ya7s68H
CV8sED+DED8hED6hor5gQL427Cp88A+ipfPSuR/lMxeByZ9U4z9pRi5phwxL
67I1IsEWEeuAiHRGhrgh/T2Rnj5I5wAUKBh1Jwx9KQ7993tnrXpxf/6A/08E
4X9REH/jrH8p+fCdeuRHXdfPmmc3VRUmijxLWZKtOMxB6O0q9PQTeITz3RN4
7hk890KuRxnXs5bj3cjx62SHDrLiZljpYOY9OLOKzHzGYnSL9sfl9CU1dVtP
RR9RyUfUg2MK94gq0u3JNSQAICmlRJUAp2JhVftY1R5WSUADGCSAgCsgEPn2
lmwDLAUviJcnRQvv+B86uJMNrNGKg3e59N4USkc0uTmE+DQAX+2PKw3A5gZh
k0MxYZEY91iscRr2uxrcP17jv5gk/H2D+Inhmk4xXKqg/2BvfcsHfy9aOnfW
6gIwedHQSj1qaHXJ0AqESLRBxNkjopwQYa7IQA+ktzfS1Q9pG4QyCUVdiUR/
lof5pA77V0Orefx/YAn/kw75VLD0D2D8B33PT5qG68pSE3m6pSTCRujpIHD1
5DsH8xyjufYpHLtsjm0R26aSZVPHtG1iOHcdeA7tB8zQI8G0JBg1m0gpYZCf
8oidEsIQgJvRYsF6HOz0BIGlHuFYehxfg5Go0HI5RiFCA1wkwIArqQiAjATw
CAADVyBhCtiuHLIl3wVLtxckW+9FG28Fa6+4K8+ZS9X0uSLKdBZxIhE/FIHt
C8C88kC/cEBXO6Lve6DT/NERoWjXaMz1fOw/GvFfDBM+XSX8DUP8yx7674ar
FXvrm3+1Ov9vrX76vZUlIun3MXRARDgjgt2Qfp5IDx+kYwDKMhh1Ixz9fTrm
02rsX1/j/jyH/984/P9kbP9dMvuNtv+85vlvymIjWZKFyN9a4OzMt/fj2YRz
QAlsiwyWWQHT5AHDqPrAuGHfrJ0G6qXaj+y5zpJ91oghMEIsEZexj37AQdYL
4e0y6FvV7oQOsqyH7ughqEMISQ/b18K4KogIgEglUBkfKmftKujbij2IggBV
YKEKNFSBhCrgu3L4thy+LoMvSuGTYviIANHHQbQx4HVUaClpJxu3mYRejUQs
BMEnfWCDbrDX9vDnFsgyB1SGNyo0FG0bi/nHY9zn/fhPlwl/RZ8egT49gHzJ
2fyGv/qdaPGH01bTPwKTF1TjF//V6pIFIsXqbGnZIaIcEWEuiEB3pI8X0tUX
aRt4urR+jkF/Woz5Wyvuz9NnrdgbnykmvtO1/6wsuS2NMxe6WfPtPbigYI55
LNs4lXk7l3Gj+OC3h/TfntBuNFNuvyabDJAs3hNsFnBOmxgPJCqABI+nQ7JZ
2w/4G7VScItypUe7OqYFz+vAG/pVmH4Nr92gqdZZCrBAtiYWbkg4G9KDDRll
TU7YlGN35OhdBRKiQBhaGV7vKlBbcsyKHLckIc0I94Y41I4D2pM9WjGOmonc
i4MSg3cxvtswj+0N1+05x51hW0i7GbzSFpnqi/KOQP9agTXchvxtlfBnHOE/
qci/M3a/4q5/I1j5Xrzwg+zDeYWh1fsLqrGL6pE/WpkhUi0QySBEgg0i1h4R
6YgIdUEEuCO9vZAufkjrIMOuhfoxFf3JY+xfhnD/gcb/vxzw55p3P6iqrktj
zQSOtjyQL8c0inU7hXEt5+BK0f6lStrlJ5Rfmsi/dhKvvcXfHMMazaLNVpGg
Xbg9ZteLtBVOW09iruTwFkvFHx4pphs1M92a2RHt7KxuBqybgWjnsKoFimKe
KZ3lixcE3CXRwbKEsiQlLskwYBlqQ47YlhumD2ZoBVMg4QAGChB3FNRtGXNF
xJ3gCPv3hC+RgvotXtkyJ2+OeXdmP3qGGvSB6LaIsQbv2mx8AG13GcHKnZBR
ISijB9i/D+L/skX4TyL2L3TY56ytf/DA34qWvpfMnZPNnFdM/qicOG2l+Vcr
E3i6GfyuIZfVWS67P3IFup3mMqwum8DTXOeyMX9rwf5p47TVZ7pXF2XJJnw7
B45pCOtmEuNKzv7FYtqPVZQL9eSLLcRLr/E/92OvjKGuziBurMBub0NMkFs2
+HV38kogfSGa9SGFN5UrHi9RDNeoRprUI92akSHN8LR2cFk3uqOaQCsmyNLx
A9E4hzfJY8wIqLMiwqwY80GKWJJC12SQTdnujnwXpoAadniMEodVUbCGnR8Q
QcXA+r5yGqXsW1M2TQM1Q/KiPll2lzjltSCuixvey/AfpDhNYc1W1823uo3g
mYEo80fYv83i/4Ql/G/DKYi5/SVv7WvDQUgy/4Ns9pxi6mxRnQ7gRc3wT9rB
nwyt7sAzjeHppvBUc0SyJSLRGhFni4i2R4Q7IYJdEH7uSA9vpIM/0iwEdTkT
/dc+3H8wtj5RVV7nWzuxbsQdXMqlff9g74da0g+NhHOvcOd7MReGUD+9h1+e
g/6yunt1e+s6ct0Eu2pDXHSlfPDdnwpljcfyh1PF/bmKvtLT3wvta1b3dat7
BzXdU5reZdXbbcUAStpPEr454A2wmMMc6iiPMCZAj4tgU+KdecnWinRjXbax
I9+AKbbQAJSowlDV1H0tn6lR0UR6JPlodVs/Pq3tfqtpbFc9eq4sqVPmPgJS
qoHoGkV4nTi4kevdQzNZgBntPAlE3X6D+xOK8L+o8E9YW1/yVr8WLn4rmfte
NmMIdR54/6Ny/IJq1DCAFzVDf7S6Bc++Dc80gmeYwNNM4XfN4afFQIg4G0S0
HSLCARHqhAh0Rfh4IFx9kIaDxMUJ3P/kWbnSvisiffsU/20b9ttu9Hf9yO9H
4Ocmoefndi+sbP+0uXkZunYVtXIbu2hO+GC7N+1Cm/BmjARxBiIFfQmS12mK
jgJlR4Xy1RPVyxZVe7e6dVDdOqV6tSzv3JZ0ooQdJN7LfWY3g9rHJvRzUQN8
yIBwc1y0NiNeXZQsg6VLW7IlmHwZA6ztqXZZhhukQ6Hq+FgiOqFjj+AL+qU3
2tFGdU+NqqVUWV8IVOcqHmQr7mUpsrPkqTny2AJ5QLnU6j2qAfunPeSfWBuG
s+I/RAvfSOa+k838IJ86p5g8r5z4UTV2QT164d9D6QYuXYfn3oDn3Dwrdgee
YQRPN4anGqKZwlPM4Enm8MQzCabwxDvwu79BC4xWp15Y8xZ/RKx/s7X57frm
d+sb329u/LCzdg4KvohY/gW1eA0zdxs/a0qcBO2N29NGXBjvvNhvAnjdYaJX
MbLWZKAlB2guVjZVK180qJ63qZ72qOuHVM+n5Y0rkqYdQSOa+4zMbKJR2/fx
HUzka/ZuF3e9l788JFh4L/zwQTSzLJnakL6HyidIwBxbtSHTog8PWR/VKt2B
WrSlpI3IES3S1UrJZJ5k4K7kday0OVz2NEheGyCv8ZNX+cgfusvqHUSzlzHS
OBN9z3n18A/KsR+U4+fOnFeOGSr9eFbpguGkrRm6eBbqJ0Mofb+hVcE1eP41
eN41eO51eM4NePZ/uQ7P/g2e8xss7zr0/i1IpdH2C2PwhGsv+W6K/LGDuNvs
YOj23vgN4uR1wuQNwuQtwvs7xAkT8pg5ZcSKNmi73+/I7HNjd3nxXvkLW0Ok
LyIVzxMVzzKBhntAffnpH5U8fqGseamq6lM+GpXXzorrwPw6COcxhllDotVT
8M/piCbGTgsL3MJZeM2b7edPjgrGpoTD86IBsKQHJRugKcaFyjmNavNYjjtm
0XTIfcUUnde2T33AQGUdbMUfLIUdzPgzxr0YQ66MAUdGv+3BoAXt/S3i2vcQ
4reNXAs/ebqJpv6aruNnfd8F3cAF7bsL2sELp31OE51W0r77V6izVjdg92/A
7hlchxX+G8NHim5AS25Bym7vVhvtPDXZfGmyNnprAeL5ih5WKM+LlFe4yZ7Z
CdqtOa+tmN1WjF6rg14Qo8eG2W3Heu3I6XDhtbsLWrxFL/ylT4MV9VGKJ0mK
2gzF4wKgphSoqlZW1ivLmpUlncqyflnFhLhynl+5zi6HMkpwtAoioWYPUUvb
frK/Ws+ca2BPtnNGe7iD73hvx/jd08K2dVEbRtLJkPVKFYMaycwJd+UIv6ld
3gTebIrqNll5O5RYKM4PgXDC7FjjNixwYGPsyk0M+FfUxgUI5Nw87vsu+o9F
XPMgcYAlUGCsrr2hbbmq6/xF33NJ/+Ynfb8hzr87rXTq7aWb0JL/rvQW9MEt
aPltSOWd3RrDHmi83Wiy2WGyNmS0smQ1ifJ8te9fLk3KkOdFyUv9ZZVussfO
kqdOomdOwudOwhcuwueuogZ3cb2XtM5X/jhQ/jhcXhOrqE5WVGUoKvOB8hLg
QSVQXAvce64saAfu90qLhkXFU7ziJfb9rYMCBLUASyghIMvJ25XUlSr6hyrG
RB1zqJn1toPdbbg1HuQ1TvIfbwjrcaJnTEmTTPxSw+k7pr07hIyqxwaBlyOS
yhF+6igzfILmNU2y/4CzmEffWUReW0BemUNdmsRceEc8/5J2vop5LZ1rFSD0
sJbfNVc+MFLX3dQ2XdO9/FX32lDssr7PEO00zn93+Ra07He3T/tUnCaCVJ1W
2q0z3mkw2W423ew0XR8wAU/fWtqyHcd4dtL9HwvC7slT0uU5cfJ74fKSIHmZ
n7zCR15p2A185Q/95A8D5Q9D5A8j5JUx8opERXmq4kGWoqRAUVQM3KsA8h+d
/qFldosi97U0b0CYP87N/8DKBe9n7VLTUMQcLLIQv11EWimmzJbQxksOBh4x
ep8xO9pYLa/ZDW84Dye5Dzb45ThBJUtYJeXVqfdfnP58cKNNM9wCvGiSlrWK
0tt4oS9Z7h37tl1U85692z3ka92kK53ky22UnxroFysYv+WyTeJ4tj5CDxtZ
oiVQaKqquqN5elPbbMhlWGBXdN2/6HsNg3lZ/+a/uQ39vY/BwzuQaqPdR0a7
tcY79cY7z022W0w3O0w33piujRmvLN5ehNiNYT26qH7POAEV0sgCeXKmPDNF
nhsvL4yR34+SF0fKSwyi5CUx8pJ4eXGSvPiuoihDcS9HUVCoyCtR5FQAmY+A
tHogrUme0SHOfCPIHOFmTjEzFumpG5QEGDEFicrA7GTjV/KIs/l7Y3nU/vv0
rof77U8OGhsZT9qZlV2s3Pec3HVuPpaXz+IXiFklSkq5Hl15CK7WDhuuFhWy
kgpxRpUguobn95jtVMu0rGPcqTu4Ubt/tebgagXjWhHzVjbbNJELCuE7uol8
T1sp8s2U5YZJvK15bhjGf8vV83uxs2hnTlcRpMroj0qPjXefGBt2p+0Xp6G2
Xplu9JquD5mAp4xWVo0WoHbjGLe+PZ9Wpn+dILBMFnlPnpArv5spz0iTZ9+V
56TI887kp8rz0uV5mYrcHEVOgSKrSJHxQJFWqUh5BCTVK1KapHdfiVJ7+amD
7LvvGSlz9ETwXswOMRaOSkTu3MWspuE+ZBDHM8gDadTXhbS2cvrzR/u1DQcV
TYyCTmbKBCtljX0Xw0lhcFOEBxkKUo4WkXsEzteNFqja8hXl2dLMHFFcviCk
kOd9n+tcxLa9z7a8Z7hFZZ3+fwtpHMt4rnUY38FH4OogDrGRJVsp8s2VZSbq
R3c0DYZJvK5t+0336qru9f8v1ykjSI0R5PdKdca79Sanc/fC9DTUS9PNbtON
fsOiMlmdNVpeM56H2k5gXPtJXh10vxfsgMfCwHJZWLE8ulCekC9PNkTLOT3A
pBnkytPyFWmFitQiRUqpIqlckVCliHusiG+QJTSLE18Jknq4ie9YieMH8bO0
mGVyxCYhDIKOhu/GIcGJmLlk3HgyYSCJ3JVKac2nPiulPa6iV9TRC5/tp3Ye
RI8zo8GsaBQ76oAdwafHygiJaljS4VqifiJF8/qu8kmyvDBBkpggikwWBqbw
vVN5rqk8xxSufRLXLp5nF8WzD+E7GUK5iPzspNHW8jTDDJory89aPb2labyh
bTUsrd90nb/quq7o/3uus0q1/yfUjiFUs+lWu2GbMtvoM1sfNF2bMFmdM7Qy
rCvrSZTTEMGjh+LTfuD/ghNQJwiqkgSVycNK5ZHF8pgieWyRPO7/a+SuvqPI
GrWB/wkvxN2d4PGWuLu7CwSCBoIMMLgNGQZ3DwRIkLhLd7rjXdpV1R3BNRAi
xHivTu3d3SHMzPm+s9ZzydVvPbtWSPZ+9kzk7Z3I3TeRu38i5+BE1pGJrBPj
2cXfcs5+zbk0knvjY+7d97mP3uQ8e5lVM5TeLEvuoOK78ZS+nnSJIAttyCEq
cqWPcug72fLLBQNntg+e3DN46ODQ7uPDm4tfZN54mfTsVWLb60TkTfzwm9gP
w4lfqdTJ/rQ5Ydp/azNmH2RNX8ycPJoxVpQ2mpfyJTV1JCFtJDr9c0Ta59AU
+BIw9nNoxEhY0Jc4v9EMn7F1nhPb3Cf3cKcOuU2fdFFZrQJWN9hqLZu7s3Sh
FYQqXgB1gdN1mT19XPEdrugBt6OcI6x0a290aROy3yuPWtT/qRRU6/ZwzNXX
ceffJZz+lPjHSOLxr0lHviUfHks+NJ5yaDz18HjakfG0Y2PpJ79lFI9mnvkC
3n9c/Zh1831mydvMR68yng2n1QwkNzHxAmlUFxbf05PUJ0iVNKajlRnE4wzp
3XT6SqbszHr5ycKBQ7sGfvt9cOuRoTUnhmOvv4h+8jKq5VVk/+vwgdeh74Yi
RqQxY/2x0x1x/22M/VGeMHsrcepM4uShhPEd8d/Wx45mRn9JjPoSFzkSEwFf
IbFKAV9T/L5ls1Be41s9Jnfxv+/nTh11nT7FnkHH2Qv/b6t5qLOcrvPw9F3l
dt7kiu9yRaXcjiccYRXbK9c2gVNLD69e4lOJB5ZTYQ/kkXeGY669irv0Nv7c
+4QzHxP//JxUPJJ86gublOIvqX+OpP41knbuc9rFT2lXPqTfeJd2503a/Vep
j1+kPBtKqpHHN9LR7WSYGIvu6onrEST2NSYjlSlYWQpxL1l6LZE+m8n8sU52
eIt8746BbXsH1h8YTD82FHp1OKTsRXDjy6CelwHMK7/XQwEfqZBRSeikOGy2
Oey/VWFzpZEz16KmTkd9Pxw18Vvk+NaIsYKwb2tCR3OCR7ODRrMDvuX5jeX7
jm/0nij0nNzl/v133tRhzvQJ1+k/nWfOOs5eXD17ZeXcdfYMLp+7/avVfTsI
ddqt+4zy9HVd5oJS3eKK73FFDxVWHAFr1ebc2una1M9Wy+85GVxGh5XKI+8O
Rd98GXvtddyVN/GX3iVceJ944UMSTPKl98mX3ydfe5dy423K7dfJJa+SH75I
Kh9KeD4QV8NEN1Lh7USwCAnv7I7qFsT2Nsb3VyUgZQlYSQJxPU56Pp4+lckc
yWf2bZLt2C7fuFue8/tA/LHBgCtD/o+G/epf+HS+8JK+8Hg55PGe8hlB/Me6
AqbaAubqAn48DZy7FzxzJWT6r5Dvx0Mm94dM7A6eKAoaLwwY3+I/vsVvfKvP
xHbviZ2ek3vcv+8HUFMn3KaLXWbOOM2cd5i9vHr2KvuT/ApQqtsKKHsFFBsI
taBUXVeg1W2uuERhxRVWcgR1bu0tLm0dTi293AaJVw3m/5wMKqdDH8oi7g9G
sWK3X8TefBl341X8jddsEtjcfJ1w+1XC3ZcJ918klA7Hlw3GPZXHVDJRdVR4
ExncjgWKJCHirvCu9qiexui+qlhJeSxyPxa7EUNciJIWJ1JHM+n9a5mdG5kt
hbK1O+Vpe+QRxwa8Lw96lQ551A67i4Z5+DBneNj1Dc3/iHl+7fGaEHpPN3nP
VXv9KPOZu+s3e9V/+pz/1Cn/qWP+3w/6Tf7uO7kXXsDe6/X9d4/vB9ynDvOm
jnGnT85DOc5eYqFWzZfqB1sqJRS0emAHoc5wlF+qS1xwAG8ssCrnCis4glpO
e5Mr+2NDa6dLSx+/AWG5/CrIwKdUSBkT9kgWUToQyaKVDEWXDMWUDMfcH4p9
MBRbOhTzaDCmbCD6qSyqgomoocLqyeBm3F+A+nf0BYnFoZ1t4d0Nkb1VUX3l
UZL7UejNSPxSBHk6UnoskTqQSe1eQxduYNZvZbKKZAm75YFHB/iXBngPBrnV
Q26CIRfJsNPAsMMrxuU9zvncx/sm5k+28qfr+XOV/B9l7nP3PGeve81c9J4+
4z1d7DV10mvquOfUMQ9wUfY4f+oEd/oPznSx28xfLjNnnWcusFAOEGrlz9M3
D/XADvzcXmqrLJXqq77A6h78XpVxhc+4wmqOoJ6tlmub0KW1y7W5j8e2qxb1
rcIDKsigZ1TIEzq0nAkrk4WXySIUKZdFPGUintPhlVRotTSkjgxswv1aUbAT
0tEdIOoI7mwN7aoP66kM7y2P6L8fgdwKRy+H4X+FkCeipAeTpHsyqe1r6I0F
dN5mJnU7E7VT5nVUzrkw4FYy6FIx6Nw65Ng7tJoeWvlCvvoN6fRR4vKly3VM
4DbZzJmudZurcPtRxvlxnzt3iz97lT9ziT9znj9zBt6VPc2dPs2Z+ctt5ozr
zDlWyWn2kuPsldWz11bN3Vg5dws26u7Sn0ePhSpV/pdQZXX+n1Y80QOe6DG3
4yl7DLlstQSNbu2trm0dLBfbLm6TxKMe8a7FfKtx/yoioJIMrJAGVUiD2VRK
g6ukQdVkUC0RUI/7N2I+Lahnu8RL2OvbIfYXCQLFzcFddSHdFeChdN/9MMmt
UORyCHYmiDgZQh6KIfcmS3dkUlvyqPz1dOYmOqGQCS1iuEdkzuflTncHHJ8N
rm4aXNk1uIIYXDY4sOyVdOU71OFTr+NXkdNYm/Nko/N0jfNshfOPcucfpfDG
7C232etus1fdZi+7zl5i4zJ7yXn2stPsFcfZqw6z11bP3Vg1d3PF3O3lc3eW
/bi39EeJvbJOpRDqIfjlFZtfrS5xu66C71XnLZ74Lk90nyd6yOso53Ww1ari
Cuo4giZOe5tbm9C1rdOltccVirk3Ip71qHcd6lOHsfFlU4/5NmA+jah3M+LZ
KuG393sIeryEnT4dQj9Ra4C4MbCzJqj7eXBPWUjv/ZD+W8GSK0Ho2UDslB9x
OIz8PZbclSwtzJQW5FG566jUjXT0VjpgO+N0ROZwTr76tnzVk4EVDQPLReCO
0BL5oO0LeukbfMWH/lWfu1Z/FTqMtThMNjhM1TjMVDjMPXH48djhR6njj3uO
c3ec5m45zd10nLvBxmHuxuq5m6vmbq2au71y7s6KH3cXKi2BSnbzSuB3fY/+
dgZZK/ht77zJE9/hiUt4olK2WryOJzzhc/YkslxcQSOnvZXTLnBrE7m1dbq2
dru29rqxaC39vGY2En6LhNcCVtq4bX389l53sG4k9hIKfTrawL6KuC6gsyqw
62lgz6Og3pKgvltBkiuByLkArNgPPxpI7I8gdseR21OkGzOla3OpjHVUwgY6
fAvtvZ1ZfZhZdVa28pZ8eZl8We2AvWBgSd+ALTVgPcjYviTt3yLLPvasGBGv
HBWsHGtZNdmwaqpm1XTlKnBptnzlj8crfzxcCa41lqz8cU+RFTDLf5Qs+1Gy
9Md9e0gElR7azbF5ZDsf8LusxzY/v+3drNVFLjiG19hjyFNUSwyrJSrjdTzl
dVTwhNU8YS1X0MAVNHOhGKe9g9Mm4rSJOW2dnLYuNlwwONbJbxe7C0RgFUrY
7tXR6t3R5COq9xVX+3U+9+8qD+h+GNB7L6DvZkD/FX/JOT+02Bc75oMfCCZ+
iyKK4snNKeS6TGlOrjQln4opoII30+7b6RWHmeVnZMtuyJY+kttXye1aB2y7
B6zxAUu53HJYavMaW/Kuf+nH7mUjouWj7cvHmldMNKz4XrtiqmrFzPMVs0+X
z5YvnytbDm42PloGrlQpYw+zhA30UcR27jHro4jNbJkyKivFMYRWymPIVus2
j/1q/eR6wut4zhNW8YQ1PGEdT9DAEzTxBC1cQSuvvY3X3s5rF/AEAtWgVhuc
h2r26mgA6z1gjqbCt/OpX9dj/+4H/j13/Xtv+Pdf9pOc80WKfdDjnvgBf3xP
KLEjmtiaQBakknmZ0oxcaeJaaWQB5b+J4hTRyw4xS/9i7K/LlpTK7SrkNk1y
a/GAJTJgwQyYDdKWLwmbN4jd+94lnzrtwS3QtqXfmpeNNyybrFv2vXrZVOWy
6efLZp4tnX0CLjfOltvPlcE8XqLI7GO72TJFbBWZAbGZKf8Ztx7w8xVHcQy7
L3DBMVRywWrdWcD1mN9Rzu94xu+o4Aur+MIavrCWL6znCxv4wkZF3GE8hA0e
HfWeHXVeohovUZW3uALu0pT5dj307S7x67nt13vdt++Sb/9ZH6TYm4XCDnrj
e4PwneFEYQyxMZHITyWzM8mUXGnsWmnoesp7I+VcRNsfou1PM3ZXZbb3ZTbP
5Nb1ckuh3KJXbkbKTeUy02GpxSvM+m2/zfseu09iuxHhkq9t9t+a7cca7Sfq
7Sdr4EXQSnAXdPq5/fSzJTNPl8w8YWO3ILYLYvOPWLuxP7f3LKyWgusKt+sa
T3kSlVx8USlf9IgvKuN3PIFizwFaRxW/o9odpIaNB0g13D6q9BJVeImfeYuf
gF2arodgbqX7rk/PTZ/eqz59F336z3pLir2Q4x7oIQ9srx++KwTfHklsjiXW
JxG5aWR6JpmYK41aKw1cL/XYQK0uopYcou3+ZGyvMDb3wH0zy1q5RZvcrEtu
ispNGLnRIG36grB4hVi97bP+0G3zSWw7IrT70mY32mL3rWnJeMOSibolkzVL
JquXfK+ym6q0m6qwm3oOMv3M9mee2vwj1vOBVopqKb5a57ngJC7kusnrZA/j
Xb64hC9+oBJ7zBeVu4ueuIueuoueKeKhzFPFng9c8nnk1Vnq3XXfu/uud/ct
sCLSe9m774JX/xkvySlP5Lg7eoiH7fPGdgfi28PwLVF4QRx46JqVRqZkkrE5
ZNgaqd86KXcDtbyIsj1I2xTT1pcZq7uMZZnMolpm3iwzFclN+uXGpNxQzhgN
SU1fYOavJZZve60+dFl/Ett8Ftp8abf92mL7rcl2rNF2vN52vM52osZ2stp2
ssr2O5tK2+8VbGymKsD1IVWslXn2S9x6iv+Fq3ue6yoPHMaboGCdd/hKsfsA
TfzQHeSRu/gxG4+fAUs+np2lnp334TrNHa/uW3Bx5SqYEOk759l/2lPyhwdy
jI8e4mL7PLHdflhRML41HN8Qg+fHEznJRFoamZBJRuWQwWuk3uukrgVS+x2U
zUHaupi2usRY3mYsHsnMK2RmjeAqo3GP3AiTGzJygwHKaJgwfYmave63eNdr
+aHL6qPI6rPQeqTd+murzWizzbcmm7EGm7F6m/E6m4lam4kam4lqm0k2VWys
JyutvytSsSDP2ViBv6s+t3LtOfW/cCm/XTyWCxQMiPE7b/E7b/M77/I77/HF
99zFJe7i+4p4dCpSwgZu1MCBmu6bYHoFjK5c8uw979l3xqP/T/f+k+6Sozzk
IBfd547t9sGKArGtoeCl+bpYPDeByEghktOJ2CwyPIcMWCP1yJc6rZfa7KCs
D1JWp2jLi4zFLca8lDF7JjOtkxm3yYw6ZYYSmYFUpi9jDAalRsO4ySsE3C5+
12Pxvsvyo8jyk9BqpN3qS5vV1xbr0Wbrb43W3xqsx+qtx+usx2tBJmpgqkEm
q6yUqVTme4Uyil/0zXNxehRc4FMPuGDBePNiXdf5XTf4P9Fuu3fe+Zmu2x4g
ioEaOL3ScwXsroDRlbMefafd+0+BiQzJES5ykIPu5aO7vbAif6wwGNsUjq+P
wtfE4VmJRGoKkZBORMFHr75rSF6+dHWB1GoHZXmQsvyDtrhAm98Ar6VMnzAm
NTLjZplRh8ygV6aPgYuyunLKYJA0eoGZvJKYvukze9dj/r7L4qMY3DH+LLAc
abP80mr1tdlqtMlqtNHqW4PVWD1MndV4LUyN1QSbalV+dXPtVfxe9A+3v4sp
uM4rxboVYlcUaHyQ66rccO+6rkz3Nffuq3B35TLcXTkPRlfA4koxv/8kr/8Y
T3KYgxxwQ/dy0V2eaJEvVhiIbQrFCiLwtdF4djyenkQkpRCx6UR4FhmYQ3rl
kW750hUbpJY7KYuDlMUftPl52uw6bVrCmJQzxlWMUaPMUCAz6JLpS2R6pEyX
YXQHpAZDhNEL1PiVxORNn+nbHrP3XeYfxOYfOyw+CyxG2i2AWIvl12bL0SbL
0UbLbw0gY/WWY3Ug47UwNSATbKphqkBce0/AnPwXrp4zio5xF6DxWDSQy2z4
f88lkJ6LYHSl55xqdKWY3/cHr/8EV3IUDonsdwX7Ibs80CIfrNAf2xyMFYRh
+ZF4biyeEY+nJBHxqURUOhGaRfrlkB55pPNaculGqcVOqflByvwkZXaONr1G
m9xjjB8zRhWMYT1j0CrTF8n0emW6mEyHlmnLaN0BUn8INwRc/SZvek3fdpu+
7zL7IDb72GH+SWj+GXBZfGm1+NJi8bXZ4muTxWijhRKt/ifa2AK0cYgG/oLT
e1zJ9asYB0SJxu1hxRRowI0HcuFnes7zFD49YJeGB0ZXTitGV7j9cE6ErRPY
Etnngv7GQXe6o0XeaKEftjkQ2xCK5UdgedF4VhyeloAnJhMxqUR4BhGURfjk
kLw80nEtabdJas5aHaDMTlKmZ2mTq7TxHdr4IWP0jDGsZQyaGX2hTK9bpiuR
6ZDwDrac0h0k9Icxw5eI0at+4ze9JizXuy7T9yyXyOyT0OyTgBUzH2kz/9Jq
/quYxbcGmHqLMTZ1MLUW42xqLFwUf/DqPeaqFANobr0KMYDG+QXtLy7Imb+F
1/OX0qf3T25vMReMrpzkzs+JSA66Sfa7Inud0d0sFB/d7oUW+qKbA7ANwdg6
MPuAZcfg6XF4ciIelwwe6YdmEP5ZhGcO6ZZHrlpLWm+Smu2Smh2gTE9SJmdo
kyu08W3aqJQxfMIYVDP6jYxeO6Mrlun2yXQwmTYl02JobblUwWXwEjF81W/0
ptf4bbfJuy6T92LTDyLTjx1A7HO72ec285FWhZj512bzr03mo2wazUdVYt8W
iLn0HYFcC8V+1gyggZxiwwFuikC9XhAgo8wpbu8fnL6TYHGl7zin/6hb/+GF
oysuyC4OuoOF8kS3+qCb/bENQdi6UGxNBJYdhWXE4inxeEISHpNChKcRQRmE
L3yB7pJHrlhLWmwGVqYHKJMTrBVlfJk2ukUbPqANyxmDSka/ntFrZXQ7GJ1u
Rlsi0yZkWjSjJaN0BkjdIVx/GDV4KQFcrwGXMeDqNIFcph+Fpp8ECjGzkVaz
Ly1m82JflWLm39jUg4zVmTv3HYY58r+jnXADOamKQu8PDshJZaCPW98xt76j
cHEFbImwSmBOBE7TuCA7OarRFR90kx+6IRBsiawJw3IiscxoPDUOT0zAY5Pw
yBQiNI0IyCC8sghuDumYRy5dS5ptkZrukpockLJWxn9RRpdoo5u0YQlt8JjR
f87o1TJ6zYyugNHpZLT7GC2U0ZIymgytJZfqDBC6Q5iekqvP8HWv0RvAZfyu
ky2YyYcOE8hl+qndlBUbmRdrNvvKpslsXmwUijn3HXTuOwQD0FxAoFvfUZDe
o67AbT4QELAoZBQ56gpyxBUQHXLtP+AClPbB0ZXfnJBdrmBOZDsfLfREt3gD
qIIAdF0wtiYUy4nAMqOwtBg8KR6PTwT7D+GpRFA64ZtJeGQRbjnk6jzSLp80
3So12Q2sjE9QRqzVRdrwBm1wjzZ4ROs/Y/SqGd1GRqeN0REx2j2MloTRxBlN
mtFgKMA1CLleIPovJQYqLqO3gMsYcIlMPqrEPrNibaYjraZ/F2s0G2XTYOYE
bn0cgGIHF7gdUrkt1FPGVZnDMIdc+tkcdGGJ+mGRgNIeVskR2eUMVjKKuKrd
FW90oy+EUiyKhINFkbRoLDkWT4jHYxLxiGQ8JBUPSCe8Mwl+NuGSQ6zII23W
kSZbSdbK+KDUiLU6TRlepAyv0wZ3af2HtN4TWq+K0a1ndFoYbSF4/qnVx2ii
jCYJX0PIWC5SexBfyGXwutfwTQ/LZQS5jD+IjGHBTD4JTGDBVGItpl/YKAsG
xJz69i+Iwk2Rg/+MiyL9ihxwBtkP8zscpdnrxCqBIZFdTmAio8hNMSeCbpmH
8kfz56dXIrD0KOWoSGwCHpWEh6XgQWm4bzrhmUlwsgnHHGJZHmm5njQpJI1/
g1bHKUPW6gJlcI3Wv0Prl9J65bRuBa1by+g0MdrtjJaI0ephNCWMBs5oUIw6
w3JJtQYIyIVCrn59FZch5DJiud4DLmOWSyVmwnJ9blWJNYOwXI79+2B+d/ol
+/8W51/yuzP4N/tAgA8gcpT85ijZ7YDsZJWckSJXMJGxjaecE9nkjW7wBdMr
+YHommA0J1S1vhKNJcZicapdkZAU1WJGJuGaTazOIezzSLMC0ngbsDI6KDWE
Vgas1VVK/zatd5/WK6N1n9M6NYxOA6PdymgJGa0uRrOP0UAZDYJRp1kuSlNO
Qi5MZxjVfYHoqbgMAFe3Icv1TmwEuJRixioukAUFM3Xs3/uP7FsYp5/Zqwj4
NwBH6QOIJLtYJUeo5IJsd0O2ccGWyBYItdEbLfAFiyIsVJ4CKgxLjwC7ImCA
JQ6LScAV0yKBqbhvGu6ZQXAzCedsYmUOYZtHmmwAVkZKK6nBn5TBefiQ/xat
V0LrPgav1HWqaO16RruZ0RIwmmJGs4fRYKuFMepSRo2m1WVSyIVrDym4JAou
fchlwHK97TKEBWPFjBRcHwULxFpZMRNWzKH/N5g9f4vj3wJYQByAjCK7HCQ7
VyM7HJAdTkiRM7LdBdnmhhRykK08ZAsfbIls8kI3qKDWslBwfYWFymChIrGk
aCwhFmywRCXgYUl4cArun4p7p+PucGDEMZtYlkNYryGNN5JG20mjPVJDlZU+
a3WF0rsJrR7SOk9onUpau5bWamK02hjNDkazi9HoY9QRRp1g1ChGjaEgF6E1
qOBCFFx681xvlFyGKi6jD0ou40/txqqCmSguiy4Q+NfsUmQ1iwOyg40DUuSI
FDkh2xVKrlCJi2zhIZvdkU0eyEYvtMAbXe+L5vuDRRElVChcqonEkqPABkts
HBYdj0ck4iFJeGAKLFU6zssgXLKIVdmEfQ5hsZY02kQaFZGG0MpAYXWO0gNW
lO49WreU1imntSto7Rpaq4HWamE0BYyGmNHoYdT7GXWMUSNBtVguDRmpOaDg
Qv/GpQ+5DBRc78SGKi4jZcHajT+1AbHVQGAe4V+zYz4OkiI2jsh2BZEzss0F
KVyoxIdKnmAfY70Pus4XXQuhcoPAUEZmKJrOQkUAqMRoLC4Wi47DIhLw0CQ8
KBn3T8G903D3dJyTSThlESuyCbtcwiyfNNpMGkIrA2ilr7C6TOndoHTv0jqs
VRmt/YzWrqa16mnNZlqzndEQMRpdjDqslhoOnrEvBlxSDbmCC5vn0p3neq3k
MviFq4PlMlJytRuvkuz4R4oUWQ0DfbY7wjgh29jME7khWznIlnkld2SjB7LB
EynwRtb5oPkQKm8hFFyqSY6EUHDYJzIeC0vEg5PwgGTcNxX3TGNLhbtmEg5Z
xLJswiaXMF5HGm4hDXeQBnulBoek+qxVsVQPWulep3TvUDoPaJ3HtPZTWquK
1qqjNZtozVZGQ8hodDLqsFpqKKjWYopZDE8i5MLnuXRUXHqQS/9XLsP3P7mM
oNVPltXgXcB2B1WgzzYnGGdAVOgCstUV2eqGbIFKm3nIpoVKXmBFhIVa64eu
gVA5CqgQCBUOoaKweBYqFouC2z4hiXhgMu7HlioVlioDTLKsyiLsswnLXMJw
PWm4lTTYCaz0oZUea3WW0r0ErHRuUzr3ae1HtPYTWquC1qqhNRvgdoQAVEsd
VksNVmsxrBbkIjXkxK9c/bov+/Re9eqxVvNcbzsNlFwiQ+V5FBipZLaxcVQF
+hSycWYDfeaJoNJmhRIP2chHNrgjGzyQAk9kvReYEAF18kPz/NFcCJUVDJYf
IBSaHAGhorHYGAAVEQ+WWIKScP9k3CcFliodd80gHDOJFVmEXQ5hnkcYFpAG
Cqt9/7C6Bq1KKO2HtHY5rfWc1qqmNevBfIRGG63ewajDaqnBai0mQLUW0RR7
EpVcg7jWEKo9hOgMSxRcupBL73U3y6Wv4jJQcRmyXCqfQidVgI9kq4tkq4po
CyTazIHhQiKVUsG8kjeS74Os9UXXQKicADC6ooBKC1VBRSqhomPBDEtYAhac
iAck4b7JuBdbqjSck447ZxCrM+EBzCFM1xAGG0iDQtJgF6kPrfSglS5rdZEC
ay23KO17lHYprVVGaz2jNatozTpao5HWaKXVBbS6iFbrZtRgtRZjzGKSWUTR
i1kumVRdTmoM4JqDGOAaRrT/j1wQZ6siLspsYX0g0WYV0SYuiJJIpbReoeSF
5Hsja32QNb5onh+sUyCaFQRGVxRQKWEsFAqgorDYaAAVyULFYyEJWGAS7peM
e6eAkR9eGu6ajrOlWgkPoFUOYZRPGGwkDbaR+sAKDNr8YnX1V6untGYlrVlL
azTQGi20ejtbLVqtk1aD1VoMq7VIylaLPYlSNRmpLid+4Xrx71z6Cq53IiAG
ibYo4gqUNquINimiIOJBIj5SoFJa57lQCQFKijqpoNLnocIXQMVgkbFYeByA
CkoEU0igVCk4P1VRKpwt1XL2AGYT5jmEwTrCYBOpv53U303q/07qHQZWuqzV
GakOtNK+SWnfhRM3j6FVBa1ZQ2uwx7CJVmePoZBWE7PVohf3MYthtRbBarEn
8f/Ipfem6xcuV8lmRSDRJhXRRi4MS8RTEbmD175sfip5gzf4eQugsgLRzCA0
A0KlQqgkFioCjY/8BSo0HkzWBCRivkm/lioDX5lJLM0ibLIJ01zCYD2hv1lp
pQetdOetLvy00rpPaT2iNZ/Qms9pzWpaAx5D9RZwDNVEcNGlh14Mq7UIh9Vi
uRhqsUyqJifUB3CNAUxzENUaAidR+0W/zks2gEv3Vy59lstNsoklcvtfiBYo
rYNK+V4gCiVYJyTXD83xR7MXQKX9EyoKi47GomKwiFglVGAi5peE+yTjnopS
pYFNJIcMfHkmsSSLsMwmjNcQ+gWE/hZSv4jU+43U2w+tTgArHYXVFUr7BqV9
B1o9pDTLac1ntEYVrVFLqzfQ6s2gWmqwWotBtejFEnqRqlr/oalFC6qlMYhp
Di3k6vt3LtZHRbSBC4l4kAgqrf9Vaa1KKQ/WKdcPUSoFoJmBaEYQmq6CSoZQ
CQAKXQgVxp6+eLDt4w9L5ZWMu6fg3FTcNQ13SgezSMsyCdsswjybMFxL6G8g
9LeSejuUVrq/WmlDK63blFYJtCqDVpW0Rg2tXk+rs8ewlVaD1VrMVquXrRa9
CKUV1frPP06ikmt4IVfvQi491uqfRHxI5A6JPJD8hUreC5T8kOz5OqmgUkPQ
lP8fVJDy9GHeybhHCs5Lxd1UpVqRidtnEdZZhGkOoZ9P6G8k9Aqh1R5Sl7U6
Aqx0FlpdV1ppllKajynNp7RGBa1RTavX0eqNtFoLrdZOq3XQizuV1VoEqkUv
Iuj/qKq1WEaqyQh1ufIk/p2LtXrVA7jeQK7/AXPNAeM=
           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 1}, 
      NCache[
       Rational[1, 3], 0.3333333333333333]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->419141379,ExpressionUUID->"d47637e0-6d4d-499b-90e7-ccf1125d90a1"]
}, Open  ]],

Cell["Compare the residue to the integral:", "SolvedExampleNote",
 CellID->144024778,ExpressionUUID->"8a0942d3-9ade-4034-a340-f9ea4eddd2f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "-", "4"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}]}], "]"}]}]], "SolvedExampleInput",
 CellID->735691309,ExpressionUUID->"c4d17bd7-286b-4394-9e45-44f9df4c5286"],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}]], "SolvedExampleOutput",
 CellID->147341242,ExpressionUUID->"ade6792c-b15b-472d-b046-75c797bc4bcd"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->903088054,ExpressionUUID->"4bfe876c-de21-4c49-be7d-643ad3c6041b"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->588099053,ExpressionUUID->"818aa0f0-4ce9-4d3c-8507-644695e08923"],

Cell[TextData[{
 "Compute the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"cos", "(", 
      RowBox[{
       FractionBox["\[Pi]", "2"], " ", "z"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "4"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"567bfc13-dee9-415c-bc93-1bd08904418e"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "29169210-1922-4106-a7bd-9e4056e785b6"],
 "."
}], "SolvedExampleNote",
 CellID->6080057,ExpressionUUID->"e5b8eb95-3527-42a3-af74-952093d7bc2e"],

Cell[TextData[{
 "First, you should recognize that the pole has order 3, because the \
numerator has a simple zero at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "55a98a44-d443-47c9-888c-e02e8d47dfc8"],
 ". So, from the formula:"
}], "SolvedExampleNote",
 CellID->350020632,ExpressionUUID->"74438e3f-d884-40b6-b347-c8a62c07025f"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Res", 
     RowBox[{"z", "->", "1"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "1"}]], 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{
      FractionBox[
       SuperscriptBox["d", "2"], 
       RowBox[{"d", " ", 
        SuperscriptBox["z", "2"]}]], "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}], "3"], "\[CenterDot]", 
       FractionBox[
        RowBox[{"cos", "(", 
         RowBox[{
          FractionBox["\[Pi]", "2"], " ", "z"}], ")"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "1"}], ")"}], "4"]]}], "]"}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "1"}]], 
     RowBox[{
      FractionBox["1", "2"], 
      RowBox[{
       FractionBox[
        SuperscriptBox["d", "2"], 
        RowBox[{"d", " ", 
         SuperscriptBox["z", "2"]}]], "[", 
       FractionBox[
        RowBox[{"cos", "(", 
         RowBox[{
          FractionBox["\[Pi]", "2"], " ", "z"}], ")"}], 
        RowBox[{"z", "-", "1"}]], "]"}]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "1"}]], 
     RowBox[{
      FractionBox["1", "2"], "[", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"cos", "(", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "z"}], "2"], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], ")"}], "3"]], "-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[Pi]", "2"], " ", 
         RowBox[{"cos", "(", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "z"}], "2"], ")"}]}], 
        RowBox[{"4", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], ")"}]}]], "+", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"sin", "(", 
          FractionBox[
           RowBox[{"\[Pi]", " ", "z"}], "2"], ")"}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], ")"}], "2"]]}], "]"}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[Pi]", "3"], "48"], "."}]}]}], 
  TraditionalForm]}],ExpressionUUID->"7b60b26b-8ffe-473e-912f-8f37dab31333"]],\
 "SolvedExampleNote",
 CellID->746388581,ExpressionUUID->"4a349ba8-6d0f-4da3-ab94-4bb1f9ccccb5"],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->89197973,ExpressionUUID->"3be502b3-d9a0-4af8-80ab-631500b909c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", 
     RowBox[{
      FractionBox["\[Pi]", "2"], " ", "z"}], "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "4"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->292132913,ExpressionUUID->"d3d32a35-7e0a-487b-8145-ad0891129e19"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "3"], "48"]], "SolvedExampleOutput",
 CellID->480478357,ExpressionUUID->"464a115f-f8d4-4322-8c5a-397f1d5028fc"]
}, Open  ]],

Cell["Visualize the function around the pole:", "SolvedExampleNote",
 CellID->4405082,ExpressionUUID->"4f2f1251-116d-405f-b6d1-16ab981d19ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"Pi", "/", "2"}], "*", "z"}], "]"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "^", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["960", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[{1, 0}, 1/3]]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->58535670,ExpressionUUID->"a4c482d9-1f29-4e3c-95b9-aecd778fb076"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxkvAdUVGuW/v1f37fWN9N9O9zuO9Pd03PBgIKKCkrOOeecMyYEEQOgIIJE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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{1, 0}, 
      NCache[
       Rational[1, 3], 0.3333333333333333]]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->2116558676,ExpressionUUID->"ac2121a7-97cf-4f4f-94e3-db5ee9f8158b"]
}, {2}]],

Cell["Compare to the contour integral in the figure:", "SolvedExampleNote",
 CellID->203348715,ExpressionUUID->"63ca0be1-d470-4706-9c9e-bae46104e423"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["\[Pi]", "2"], " ", "z"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "4"]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->180404352,ExpressionUUID->"ddbfcaa0-d22b-4f41-adbc-23dc7e836b0b"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "3"], "48"]], "SolvedExampleOutput",
 CellID->36253866,ExpressionUUID->"182162d1-880d-45b7-8473-fb9d7755aca8"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1382559361,ExpressionUUID->"e30c6f23-3bbc-4302-b999-882d70e98923"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Residue at Infinity", "Subsubsection",
 CellID->76767682,ExpressionUUID->"0d9555f6-60a8-460c-b857-d132d3acc581"],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dc1c3fc1-8d1e-42c9-848b-716cef90981d"],
 " with an isolated singularity at ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7435f299-90a5-4327-90e9-94c6687e671a"],
 " has a residue at infinity defined by"
}], "Text",
 CellID->217956439,ExpressionUUID->"07af33ea-a2c0-44a9-a607-d5d57cca4363"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Res", 
     RowBox[{"z", "->", "\[Infinity]"}]], "f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]]}], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{"f", 
      RowBox[{"(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->232148208,ExpressionUUID->"6836b886-d7f9-4d36-b846-9c8f9172858a"],

Cell[TextData[{
 "for ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "8694e4bc-3acb-43fd-8633-13e1f9d916ff"],
 " a closed curve traversed counterclockwise, enclosing all finite \
singularities. The logic behind the minus sign in the definition is that a \
curve surrounding infinity that leaves infinity to the left has to be \
traversed clockwise, in conformity with our conventions. In order to traverse \
it counterclockwise, one adds a minus sign to the definition."
}], "Text",
 CellID->715292654,ExpressionUUID->"52f4a87a-40d5-4368-8e51-67aaa0f1bfcd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], "-", "\[ImaginaryI]"}], ",", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "3"}], "+", 
       RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Ticks", "->", "None"}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"7", "/", "2"}]}], "]"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(0\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(1\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(2\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "3"}], ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"ToString", "[", 
            RowBox[{"C", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"7", "/", "2"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
      "}"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
    "#", ",", "\"\<Fig. 2. The residue at \
\!\(\*Cell[\"infinity\",ExpressionUUID->\"1967147a-8e69-410c-b80f-\
d8784cdda168\"]\) is related to the contour integral around all finite \
singularities.\>\""}], "]"}], "&"}]}]], "Input",
 CellID->134060535,ExpressionUUID->"28a561bd-7a47-4647-8764-0e0420729f97"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, {}, {{}, 
        InterpretationBox[{
          TagBox[
           TagBox[
            {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
             PointBox[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
              0.5}, {-1., -0.5}, {0.25, 0.}}]},
            Annotation[#, "Charting`Private`Tag#1"]& ],
           {
           "WolframDynamicHighlight", <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
          StyleBox[
           DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
             Slot["HighlightElements"], 
             Slot["LayoutOptions"], 
             Slot["Meta"], 
             Charting`HighlightActionFunction["DynamicHighlight", {{
                Annotation[{
                  Directive[
                   AbsoluteThickness[2], 
                   RGBColor[1, 0, 0], 
                   PointSize[Medium]], 
                  
                  Point[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
                   0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
                 "Charting`Private`Tag#1"]}}, <|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                 "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                 Automatic, "DefaultStyle" -> {
                   Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ComplexListPlot, "GroupHighlight" -> 
                 False|>|>]]& )[<|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, 
                "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   AbsoluteThickness[2], 
                   RGBColor[1, 0, 0], 
                   PointSize[Medium]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>],
            
            
            ImageSizeCache->{{
             4.503599627370496*^15, -4.503599627370496*^15}, {
             4.503599627370496*^15, -4.503599627370496*^15}}],
           Selectable->False]},
         Annotation[{{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              
              Point[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
               0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
             "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
          "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
      AspectRatio->Automatic,
      Axes->True,
      AxesLabel->{
        FormBox[
         StyleBox[
          RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm], 
        FormBox[
         StyleBox[
          RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Epilog->{{
         RGBColor[0.368417, 0.506779, 0.709798], 
         ArrowBox[
          CircleBox[{0, 0}, 
           NCache[
            Rational[7, 2], 3.5]]]}, 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(0\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], 
         NCache[{
           Rational[1, 2], -1}, {0.5, -1}], 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(1\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], {1, 1}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(2\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], 
         NCache[{
           Rational[-1, 3], 
           Rational[1, 2]}, {-0.3333333333333333, 0.5}], 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[\\\"C\\\", TraditionalForm]\\)\"", 12, 
           StripOnInput -> False], TraditionalForm], 
         NCache[{
           Rational[7, 2], 0}, {3.5, 0}], 
         NCache[
          ImageScaled[{
            Rational[3, 2], 
            Rational[3, 2]}], 
          ImageScaled[{1.5, 1.5}]]]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      Method->{
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& )}},
      PlotRange->{{-4., 4.}, {-4., 4.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{}, {}}]},
    {"\<\"Fig. 2. The residue at \\!\\(\\*Cell[\\\"infinity\\\"]\\) is \
related to the contour integral around all finite singularities.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->553360793,ExpressionUUID->"bc59d4aa-cdcb-406e-a4a7-ac799fcde263"]
}, {2}]],

Cell["\<\
Theorem: For a function with a finite number of singularities,\
\>", "Text",
 CellID->254828936,ExpressionUUID->"fdc53a21-5d7e-4ae1-ba6a-01037ad433f7"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Res", 
     RowBox[{"z", "->", "\[Infinity]"}]], "f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"z", "->", "0"}]], "[", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["z", "2"]], 
       RowBox[{"f", "(", 
        FractionBox["1", "z"], ")"}]}], "]"}], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->370547823,ExpressionUUID->"6b913853-0523-4416-b901-060ebbd3c0ff"],

Cell["\<\
You will see the proof of this theorem in the next chapter. For the moment, \
let\[CloseCurlyQuote]s see some computations of the residue at infinity.\
\>", "Text",
 CellID->450039523,ExpressionUUID->"e19f409c-b51b-4a13-ac5b-68d34eda245d"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->324068005,ExpressionUUID->"7e015849-b58e-45ea-8be6-69d09edae090"],

Cell[TextData[{
 "Find the residue at infinity of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"3", 
       SuperscriptBox["z", "3"]}], "+", "1"}], "z"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5497bba7-b9f2-4d46-bd53-0d071124e66b"],
 "."
}], "SolvedExampleNote",
 CellID->46733270,ExpressionUUID->"0c66d340-a3bd-4769-8d26-903c66c89a79"],

Cell[TextData[{
 "This is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"z", "->", "0"}]], "[", 
      RowBox[{
       FractionBox[
        SuperscriptBox["", "1"], 
        SuperscriptBox["z", "2"]], "\[CenterDot]", 
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          RowBox[{"3", "/", 
           SuperscriptBox["z", "3"]}], "+", "1"}], 
         RowBox[{"1", "/", "z"}]], ")"}]}], "]"}]}], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b201ab12-3074-4720-b5a3-fd0b0867fd63"],
 ". Confirm with ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->346627922,ExpressionUUID->"e4690273-f4c2-4579-943c-18386b1f924f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", 
       RowBox[{"z", "^", "3"}]}], "+", "1"}], ")"}], "/", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->15751680,ExpressionUUID->"89bd69ca-6596-4938-a3a0-ea0c864e3098"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "SolvedExampleOutput",
 CellID->111334742,ExpressionUUID->"53fbe78f-4805-40be-a1f3-56b9ac703ac4"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1803284084,ExpressionUUID->"f42b6370-b80c-4305-b4eb-41d2d9418495"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->332475691,ExpressionUUID->"ce5d5c88-20c2-4b82-a57c-c064b483fdc6"],

Cell[TextData[{
 "Find the residue at infinity of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "5"], "+", 
      RowBox[{"3", 
       SuperscriptBox["z", "3"]}], "+", "2"}], 
     RowBox[{"2", 
      RowBox[{"z", "(", 
       RowBox[{"z", "+", "1"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"77ad149c-f7ef-481d-87f0-adab1ffbe009"],
 "."
}], "SolvedExampleNote",
 CellID->68224539,ExpressionUUID->"b0a50de9-8798-44cc-893e-13185c6623d3"],

Cell[TextData[{
 "This is easily computed with ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->221535777,ExpressionUUID->"caffeaf2-1edf-4055-b282-59572a8cff80"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Residue", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["w", "2"]], "*", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "5"], "+", 
         RowBox[{"3", 
          SuperscriptBox["z", "3"]}], "+", "2"}], 
        RowBox[{"2", "z", 
         RowBox[{"(", 
          RowBox[{"z", "+", "1"}], ")"}]}]], "/.", 
       RowBox[{"z", "->", 
        RowBox[{"1", "/", "w"}]}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "0"}], "}"}]}], "]"}]}]], "SolvedExampleInput",
 CellID->553264741,ExpressionUUID->"18456979-e1e0-4634-8196-86f594d823a1"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "SolvedExampleOutput",
 CellID->9629729,ExpressionUUID->"b07a8780-90ec-4fea-86ab-b678dbaa28a5"]
}, Open  ]],

Cell["or directly with:", "SolvedExampleNote",
 CellID->239208734,ExpressionUUID->"7c7b4114-f41c-4484-9015-c1e3362f0692"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "5"], "+", 
     RowBox[{"3", 
      SuperscriptBox["z", "3"]}], "+", "2"}], 
    RowBox[{"2", "z", 
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->30870128,ExpressionUUID->"aaff8bf1-0b0d-40ef-ab65-f45459960d2a"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "SolvedExampleOutput",
 CellID->197982396,ExpressionUUID->"6d5c83c4-2499-4092-8f09-46525d832723"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "\[Infinity]"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{"-", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0eb31a6c-eae7-4abc-9b2d-8dee54baece6"],
 "."
}], "SolvedExampleNote",
 CellID->850303937,ExpressionUUID->"5763bc11-950a-4c33-b106-1e6ff5e1b4e2"],

Cell["", "SolvedExampleEndCap",
 CellID->1426917136,ExpressionUUID->"610fb010-c6e1-4a6c-bf6f-4ffeb227e5a7"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"75df4c47-06b2-4f1b-b554-e9ceaa1d9b0b"],

Cell["Residues are defined for isolated singularities.", "SummaryList",
 CellID->312737344,ExpressionUUID->"3bf1b538-3d00-4635-8fbb-8a6aee6cd701"],

Cell[TextData[{
 "The residue of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "af1bab1d-1f05-4337-8d65-76476fb40b60"],
 " at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0c7741a0-a735-4bc9-a3f0-07c1e816f0c8"],
 " is the coefficient of the term ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4005ad2e-cf44-4e87-90c8-bd8295ad1568"],
 " in the Laurent expansion."
}], "SummaryList",
 CellID->242547148,ExpressionUUID->"357fc55d-62df-4d58-b5b8-1168bcf1ff14"],

Cell[TextData[{
 "It is closely related to the integral of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d0f78051-8fba-4bda-9ae6-8f9c2dab89b0"],
 " over a closed path around ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "512f5c7f-feab-4088-a9e4-482b01eca670"],
 "."
}], "SummaryList",
 CellID->889336061,ExpressionUUID->"ad5ecaef-0af9-4473-913e-bf3286a7d53d"],

Cell[TextData[{
 "The residue at infinity is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "\[Infinity]"}]], "f", 
     RowBox[{"(", "z", ")"}]}], "=", 
    RowBox[{"-", 
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"z", "->", "0"}]], "[", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["z", "2"]], 
       RowBox[{"f", "(", 
        FractionBox["1", "z"], ")"}]}], "]"}]}]}], TraditionalForm]],
  CellChangeTimes->{{3.906790378297154*^9, 3.906790421560205*^9}, 
    3.906790518300707*^9, {3.911641231131399*^9, 3.911641231138397*^9}},
  ExpressionUUID->"428219e9-8879-4ea8-8ba2-22ea2a4a4634"],
 " if ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "8bb2b025-8c53-47ff-82ea-84bc05c55861"],
 " has finitely many singularities."
}], "SummaryList",
 CellID->43197424,ExpressionUUID->"cc121380-7a7f-418f-a298-d2b1f60892ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->468959188,ExpressionUUID->"760f41d4-2320-4e63-a9dc-d12f66197788"],

Cell[TextData[{
 "Compute the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"3", "z"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"44c973c7-26a9-40f1-a569-e1205509f062"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "348825ca-9d5d-4a54-bc99-5018c0f197d5"],
 ", 2 and ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e3800495-13eb-438d-8162-73f92be7e390"],
 "."
}], "Exercise",
 CellID->2721810,ExpressionUUID->"52c718f3-b189-4b2c-9aac-4f381b41c09e"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"aa3598bd-79db-4673-89ce-926cf84d1db3"],

Cell[TextData[{
 "The points 1 and 2 are simple poles of the function. At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "13a5f935-e41a-43a3-a856-c3584f9cc358"],
 ", the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "1"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], 
       RowBox[{"f", "(", "z", ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", "1"}]], 
       FractionBox[
        RowBox[{"3", "z"}], 
        RowBox[{"z", "-", "2"}]]}], "=", 
      RowBox[{"-", "3"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2dd83895-b9ee-4479-b65d-644cff7ab0ae"],
 ":"
}], "SolutionAnswer",
 CellID->127855160,ExpressionUUID->"fd22d134-9714-46d9-97ea-d7bdf63b8700"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "z"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->634307281,ExpressionUUID->"4f7b10bd-7ec6-4d9c-96ea-b3ad03467e81"],

Cell[BoxData[
 RowBox[{"-", "3"}]], "ExerciseOutput",
 CellID->23684142,ExpressionUUID->"879fa399-917d-4637-ad8e-13e81f42ce6e"]
}, Open  ]],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f48239b4-4246-413e-97b5-d56d51e94d6f"],
 ", the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "2"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "2"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "2"}], ")"}], 
       RowBox[{"f", "(", "z", ")"}]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", "2"}]], 
       FractionBox[
        RowBox[{"3", "z"}], 
        RowBox[{"z", "-", "1"}]]}], "=", "6"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"73207c3c-852b-4475-a0bb-a0144fdb4883"],
 ":"
}], "SolutionAnswer",
 CellID->94750313,ExpressionUUID->"5e61577c-f2ce-4675-b4d0-13870d512ecd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "z"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->428194791,ExpressionUUID->"12224e69-b42a-41ce-959d-cded406440aa"],

Cell[BoxData["6"], "ExerciseOutput",
 CellID->563502590,ExpressionUUID->"3b746a68-7906-471e-9723-bd75de207bb9"]
}, Open  ]],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b74f49ed-cea3-4344-a013-10883ec7adb8"],
 ", the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "\[Infinity]"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"w", "->", "0"}]], "[", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["w", "2"]], 
        RowBox[{"f", "(", 
         FractionBox["1", "w"], ")"}]}], "]"}]}], "=", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        SubscriptBox["lim", 
         RowBox[{"z", "->", "0"}]], 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["w", "2"]], "\[CenterDot]", 
         FractionBox[
          RowBox[{"3", "/", "w"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1", "/", "w"}], "-", "1"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1", "/", "w"}], "-", "2"}], ")"}]}]]}]}]}], "=", 
      RowBox[{"-", "3"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6da43484-e5d1-449a-80a0-2a3326e2f46b"],
 ":"
}], "SolutionAnswer",
 CellID->388470331,ExpressionUUID->"812bff16-64f9-4da5-a929-589216b46e7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "z"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->133789978,ExpressionUUID->"98f20e3b-b6f6-4a98-971c-61370bbb2553"],

Cell[BoxData[
 RowBox[{"-", "3"}]], "ExerciseOutput",
 CellID->644209465,ExpressionUUID->"eeb2c0ff-e890-4f02-8029-257771617761"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"3", "z"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"37f9945e-7661-45bc-bfd7-c5a1fc116ba2"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5acaf7ee-3b37-4807-84c0-a8c055a0256a"],
 "."
}], "Exercise",
 CellID->110796339,ExpressionUUID->"267a1072-07b4-4f95-9a47-fa13780c4c36"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"ac0f3b3e-a727-496e-b25f-f92646abfdd4"],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "42357a6c-6223-4b0f-93f8-763470467441"],
 ", the function is analytic, so the residue is zero:"
}], "SolutionAnswer",
 CellID->124664818,ExpressionUUID->"b98771f8-55de-4fbc-a621-ede55b582f52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"3", "z"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->348443747,ExpressionUUID->"3bbdc06e-7152-49c4-be93-102297d04958"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->754240042,ExpressionUUID->"bf2ddd6a-e9e3-4b82-bf7a-3760dbf6ed21"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "+", "1"}], 
     SuperscriptBox[
      RowBox[{"z", "(", 
       RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], "2"]]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"cb50e989-16a9-4c28-9565-1df0c855b047"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", 
    RowBox[{"-", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"94f416be-7f0b-430d-8fff-9bb66b62ead6"],
 " and ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9e8d3b55-8b96-4716-bcf7-ca749f2a93a3"],
 "."
}], "Exercise",
 CellID->82897209,ExpressionUUID->"034ca6f6-4c8f-4c1f-9908-dec08c557551"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"5654722a-08a3-4bf9-bf48-9e1488aae146"],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c5a92d8e-68f6-4fe8-be51-f51305fedec9"],
 ", the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{"z", " ", 
      RowBox[{"f", "(", "z", ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], "+", "1"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], "2"]]}], "=", 
     RowBox[{"-", "1"}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5356c579-76a0-41d9-9b57-7065e077246b"],
 ":"
}], "SolutionAnswer",
 CellID->866961535,ExpressionUUID->"7dd57020-07a3-47f6-ad72-88b34030e35b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "+", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->57340033,ExpressionUUID->"444337d8-e435-4232-9dc8-6a5de319bb30"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "ExerciseOutput",
 CellID->169994532,ExpressionUUID->"1ef15024-2d6a-49c6-979d-c1a6e52d9a88"]
}, Open  ]],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8c629749-9a0c-4b1c-bbac-055eb84c5e62"],
 ", there is a simple pole. So the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       RowBox[{"-", "\[ImaginaryI]"}]}]], 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], 
       RowBox[{"f", "(", "z", ")"}]}], "]"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", 
        RowBox[{"-", "\[ImaginaryI]"}]}]], 
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox["z", "2"], "+", "1"}], 
        RowBox[{"z", "(", 
         RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}]], ")"}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", 
         RowBox[{"-", "\[ImaginaryI]"}]}]], 
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}], 
         RowBox[{"z", "(", 
          RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}]], ")"}]}], "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["lim", 
         RowBox[{"z", "->", 
          RowBox[{"-", "\[ImaginaryI]"}]}]], 
        RowBox[{"(", 
         FractionBox[
          RowBox[{"z", "-", "\[ImaginaryI]"}], "z"], ")"}]}], "=", 
       "2"}]}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "328fc85f-1637-4615-bc26-efa998f31fa5"],
 ":"
}], "SolutionAnswer",
 CellID->43137864,ExpressionUUID->"d95c096e-3961-4624-9fbe-7183a92c9e72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "+", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "I"}]}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->152637839,ExpressionUUID->"065df090-b3b9-4e1c-92c1-3d7610b4010f"],

Cell[BoxData["2"], "ExerciseOutput",
 CellID->607834206,ExpressionUUID->"b4d9e2cf-07e6-4187-888e-508590ade9a7"]
}, Open  ]],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"074d69f1-0b68-47e1-822b-2a2a2fd032a3"],
 ", the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"w", "->", "0"}]], 
      RowBox[{"[", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["w", "2"]], " ", 
        RowBox[{"f", "(", 
         FractionBox["1", "w"], ")"}]}], "]"}]}]}], "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"w", "->", "0"}]], "[", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["w", "2"]], 
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{"1", "/", 
            SuperscriptBox["w", "2"]}], "+", "1"}], 
          RowBox[{
           FractionBox["1", "w"], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "w"], "+", "\[ImaginaryI]"}], ")"}], "2"]}]], 
         ")"}]}], "]"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["Res", 
         RowBox[{"w", "->", "0"}]]}], 
       FractionBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["w", "2"]}], "-", "1"}], 
        SuperscriptBox[
         RowBox[{"w", "(", 
          RowBox[{"w", "-", "\[ImaginaryI]"}], ")"}], "2"]]}], "=", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         SubscriptBox["lim", 
          RowBox[{"w", "->", "0"}]], 
         FractionBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["w", "2"]}], "-", "1"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"w", "-", "\[ImaginaryI]"}], ")"}], "2"]]}]}], "=", 
       RowBox[{"-", "1"}]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2718c411-9387-4310-b328-226ed685ec01"],
 ":"
}], "SolutionAnswer",
 CellID->133669787,ExpressionUUID->"88f3d5d3-652f-4d0c-b3cf-1495cb18f7fe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "2"], "+", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->5691406,ExpressionUUID->"1f2d1411-60fb-408d-8f10-4a5fa6e23044"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "ExerciseOutput",
 CellID->216271259,ExpressionUUID->"bbcc4aa0-e7c8-4ff8-b2db-5a5b4d7e043a"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"sin", "(", "z", ")"}], 
     SuperscriptBox["z", "2"]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"98bfac0d-2911-4b4b-9054-5b1cc21ba85f"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c28ce603-6cac-4375-ae5e-49180975b7c7"],
 "."
}], "Exercise",
 CellID->459944470,ExpressionUUID->"d6ce202a-eb0f-4d95-a1ce-86ad9af35032"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"09c60075-6774-495e-af34-7b4d6b27923e"],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f2e45a0f-d4a2-4f2a-ab1c-6d626003a916"],
 ", there is a simple pole. The residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{"[", 
      RowBox[{"z", " ", 
       RowBox[{"f", "(", "z", ")"}]}], "]"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      FractionBox[
       RowBox[{"sin", " ", "z"}], "z"]}], "=", "1"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"38595ec3-4654-4288-9bfc-d469a532182c"],
 ":"
}], "SolutionAnswer",
 CellID->131102330,ExpressionUUID->"2dd990a5-d313-46d9-937a-5772568a5fdb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "z", "]"}], 
    SuperscriptBox["z", "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->458836708,ExpressionUUID->"e4dd3842-5611-4ec6-a2cf-41482c8693c5"],

Cell[BoxData["1"], "ExerciseOutput",
 CellID->633687092,ExpressionUUID->"da69f486-3289-49b2-933f-e653d9d18a6d"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      RowBox[{"4", "z"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "4"], 
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1a1f1919-a181-43e4-a8aa-a17a3e73cba4"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", 
     RowBox[{"-", "1"}]}], ",", "3"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c1665238-bd66-4a15-8e0f-234278137ce3"],
 " and ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9bb14e53-28ff-4b4f-a4be-28289174a384"],
 "."
}], "Exercise",
 CellID->169403244,ExpressionUUID->"60ef1e6c-e590-4501-9369-5e75ba0f9b4e"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"dc554cfd-bfbd-4fc2-9527-894e3e88c5e0"],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f3a1a3e2-dde4-40a9-a222-2f34aa0a8afc"],
 ", there is a pole of order four. The residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", 
       RowBox[{"-", "1"}]}]], 
     RowBox[{
      FractionBox["1", 
       RowBox[{"3", "!"}]], 
      RowBox[{
       FractionBox[
        SuperscriptBox["d", "3"], 
        RowBox[{"d", " ", 
         SuperscriptBox["z", "3"]}]], "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "+", "1"}], ")"}], "4"], 
        RowBox[{"f", "(", "z", ")"}]}], "]"}]}]}], "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "6"], 
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", 
         RowBox[{"-", "1"}]}]], 
       RowBox[{
        FractionBox[
         SuperscriptBox["d", "3"], 
         RowBox[{"d", " ", 
          SuperscriptBox["z", "3"]}]], 
        RowBox[{"(", 
         FractionBox["18", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"z", "-", "3"}], ")"}], "4"]], ")"}]}]}]}], "=", 
     FractionBox["3", "256"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bcd6c92f-2e7f-4f76-9ce0-23e55517f702"],
 ":"
}], "SolutionAnswer",
 CellID->244671311,ExpressionUUID->"c2cd6886-825e-4278-b5e3-bbfe166b671b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"4", "z"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "^", "4"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->103943963,ExpressionUUID->"62329dff-80ee-4a84-b1ce-b6c7395a0a1b"],

Cell[BoxData[
 FractionBox["3", "256"]], "ExerciseOutput",
 CellID->755149062,ExpressionUUID->"3adae065-0afe-4467-988a-b94177ef464e"]
}, Open  ]],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "3"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d720883b-803a-4089-a640-309e49e0aa69"],
 ", there is a simple pole. The residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "3"}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}], 
      RowBox[{"f", "(", "z", ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "3"}]], 
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "2"], "-", 
        RowBox[{"4", "z"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "+", "1"}], ")"}], "4"]]}], "=", 
     RowBox[{"-", 
      FractionBox["3", "256"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ad06c52e-cbd3-4e92-9468-f21973d55efb"],
 ":"
}], "SolutionAnswer",
 CellID->510451484,ExpressionUUID->"82eed651-3a49-4ec6-a451-8f5967c6e860"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"4", "z"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "^", "4"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->851418028,ExpressionUUID->"0c9634d8-2fa6-4b11-8832-7a8e546e77d4"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["3", "256"]}]], "ExerciseOutput",
 CellID->33173818,ExpressionUUID->"5ea34956-98d1-44f2-83f1-01401d259f8e"]
}, Open  ]],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1640823b-d312-47e4-af68-193a074c4af8"],
 ", the residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"w", "->", "0"}]], "[", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["w", "2"]], 
       RowBox[{"f", "(", 
        FractionBox["1", "w"], ")"}]}], "]"}]}], "=", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"w", "->", "0"}]], "[", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["w", "2"]], "\[CenterDot]", 
        FractionBox[
         RowBox[{
          RowBox[{"1", "/", 
           SuperscriptBox["w", "2"]}], "-", 
          RowBox[{"4", "/", "w"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"1", "/", "w"}], "+", "1"}], ")"}], "4"], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"1", "/", "w"}], "-", "3"}], ")"}]}]]}], "]"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubscriptBox["Res", 
         RowBox[{"w", "->", "0"}]]}], 
       FractionBox[
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"4", " ", "w"}]}], ")"}]}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "w"}], ")"}], "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"3", " ", "w"}]}], ")"}]}]]}], "=", "0"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "99835833-4285-4554-a7a9-7a1e66151612"],
 ":"
}], "SolutionAnswer",
 CellID->354636453,ExpressionUUID->"0e6cd851-5f4d-4235-8674-b171e3bbc195"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"4", "z"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "^", "4"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->27789853,ExpressionUUID->"241d9cfb-d957-46d4-bce9-473d3f59cafc"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->157438391,ExpressionUUID->"5a8eabe7-a675-4f34-a295-08a644327cb0"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->778347762,ExpressionUUID->"f7760af8-858c-4d4d-80d7-01eb4a944fae"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"23. Residues | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
              ""}, FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "22. Holomorphic and Meromorphic Functions"}, 
        "PrettyTooltipTemplate"], "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "24. The Residue Theorem"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"a1b652f6-f1a1-4b86-a760-2a8503526c5a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[635, 23, 215, 7, 108, "Section",ExpressionUUID->"7037e091-7496-4448-9af1-6cc27d037048",
 CounterAssignments->{{"Section", 22}},
 CellID->324123876],
Cell[853, 32, 428, 7, 107, "Text",ExpressionUUID->"652b9d8f-978f-469c-88eb-ffd25987e659",
 CellID->270265697],
Cell[1284, 41, 212, 4, 60, "Text",ExpressionUUID->"fa6c4000-e753-4a53-8314-ba1216f20232",
 CellID->75871582],
Cell[CellGroupData[{
Cell[1521, 49, 118, 1, 56, "Subsection",ExpressionUUID->"9c4f2932-00d2-4791-b66d-f54474f94b9b",
 CellID->448533537],
Cell[1642, 52, 160, 2, 36, "Text",ExpressionUUID->"20512af0-2608-4e3f-a11e-2a7f258e4ba0",
 CellID->549653781],
Cell[1805, 56, 907, 26, 60, "Text",ExpressionUUID->"64f45504-43da-4a21-9346-59a2b0f3099d",
 CellID->792745798],
Cell[2715, 84, 683, 22, 56, "DisplayFormulaNumbered",ExpressionUUID->"fba9f0b3-2cc8-4c12-a5d2-5b332cc745f0",
 CellID->115165494],
Cell[3401, 108, 942, 27, 60, "Text",ExpressionUUID->"001ae3d2-3498-4e6c-8a87-e63efa91a88b",
 CellID->696967244],
Cell[4346, 137, 560, 16, 60, "Text",ExpressionUUID->"91d75336-b3b6-40a9-9e26-46d96d9007ac",
 CellID->491350299],
Cell[4909, 155, 542, 17, 48, "DisplayFormulaNumbered",ExpressionUUID->"b43b0122-0776-4bc9-b142-364462bbb2bd",
 CellID->574203713],
Cell[5454, 174, 455, 12, 36, "Text",ExpressionUUID->"21c1e6c1-41d9-437b-babf-cc4f95e29c29",
 CellID->3808753],
Cell[CellGroupData[{
Cell[5934, 190, 3699, 102, 70, "Input",ExpressionUUID->"9e8ca401-2f83-4abc-b79b-5ccb13d32601",
 CellID->120948677],
Cell[9636, 294, 10275, 246, 263, "Output",ExpressionUUID->"9633e57a-c51d-41d3-96d6-6e782c9f4775",
 CellID->1874848294]
}, {2}]],
Cell[19923, 543, 292, 6, 36, "Text",ExpressionUUID->"be42c6fd-539b-43a4-95f6-f57ce996c77a",
 CellID->136426496],
Cell[20218, 551, 1711, 50, 50, "DisplayFormulaNumbered",ExpressionUUID->"39cf1ca7-3a2c-4f00-b0d3-a49072aaa753",
 CellID->520559709],
Cell[21932, 603, 358, 10, 36, "Text",ExpressionUUID->"878e85ab-45e2-43e0-8911-0feb65069c8e",
 CellID->266648484],
Cell[22293, 615, 222, 6, 36, "Text",ExpressionUUID->"d64b62c1-a305-4b50-bb45-0dbb6611e857",
 CellID->221541776],
Cell[22518, 623, 187, 8, 71, "SolvedExample",ExpressionUUID->"b366efda-27c8-4827-8d1c-3e6d2bcc77fb",
 CellID->154820015],
Cell[22708, 633, 593, 18, 43, "SolvedExampleNote",ExpressionUUID->"3e803a67-9126-4d60-ab16-d84e762453e7",
 CellID->75728564],
Cell[23304, 653, 474, 13, 39, "SolvedExampleNote",ExpressionUUID->"ad436400-6f87-43a4-ad56-232515f5c3fa",
 CellID->669099423],
Cell[23781, 668, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"e3e9aafc-3fe1-4f19-8765-b51af35e40a3",
 CellID->943814759],
Cell[23890, 671, 187, 8, 71, "SolvedExample",ExpressionUUID->"886d40e6-fd93-4abf-be60-288e79d179a9",
 CellID->912421477],
Cell[24080, 681, 547, 16, 39, "SolvedExampleNote",ExpressionUUID->"caf0544a-1233-466b-9cc0-4c94e06c0b78",
 CellID->108886030],
Cell[24630, 699, 1228, 37, 66, "SolvedExampleNote",ExpressionUUID->"172ed942-90a8-4a0f-ab2b-e3f5e6ff5876",
 CellID->794075810],
Cell[25861, 738, 495, 16, 39, "SolvedExampleNote",ExpressionUUID->"7596b012-3f80-4010-ae71-2f117d0cd9c9",
 CellID->89494711],
Cell[CellGroupData[{
Cell[26381, 758, 275, 7, 25, "SolvedExampleInput",ExpressionUUID->"c6abec52-7d20-47c4-8639-969f8bf182d7",
 CellID->46283287],
Cell[26659, 767, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"f7562e41-2a62-4eac-98f8-a56f443a46d0",
 CellID->568678105]
}, Open  ]],
Cell[26790, 771, 417, 11, 39, "SolvedExampleNote",ExpressionUUID->"ecec6e6e-6706-4b7c-b36a-7f5a165093d6",
 CellID->366755292],
Cell[CellGroupData[{
Cell[27232, 786, 856, 25, 43, "SolvedExampleInput",ExpressionUUID->"e0d081bc-02dd-4fde-a88d-82a858137625",
 CellID->85203801],
Cell[28091, 813, 36645, 627, 202, "SolvedExampleOutput",ExpressionUUID->"53002ab4-2524-48a9-a602-2c2b20217e90",
 CellID->413761025]
}, Open  ]],
Cell[64751, 1443, 126, 1, 39, "SolvedExampleNote",ExpressionUUID->"a0865c20-bba3-452d-a047-ebc7f22bf2a6",
 CellID->169171312],
Cell[CellGroupData[{
Cell[64902, 1448, 502, 14, 47, "SolvedExampleInput",ExpressionUUID->"7bf73452-b24d-42f5-a020-dfb06fd05a4f",
 CellID->556382888],
Cell[65407, 1464, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"66198df4-d042-41b0-b44e-1a0146fb8ce4",
 CellID->458660577]
}, Open  ]],
Cell[65538, 1468, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"3a9b1faa-ea6e-4abd-bcc4-163904780667",
 CellID->1586096596]
}, Open  ]],
Cell[CellGroupData[{
Cell[65682, 1474, 120, 1, 56, "Subsection",ExpressionUUID->"18484bd6-10bc-4138-aa5e-973d274781bb",
 CellID->778994815],
Cell[65805, 1477, 565, 11, 83, "Text",ExpressionUUID->"2c58a024-f4ff-4d9c-9afb-5c4f0fb58140",
 CellID->634039486],
Cell[66373, 1490, 237, 4, 60, "Text",ExpressionUUID->"a5f6ee73-ae13-4a8b-95b2-e7b75188bc85",
 CellID->230319373],
Cell[66613, 1496, 218, 4, 60, "Text",ExpressionUUID->"c1a96931-5cd9-447e-9f48-ac26900944cb",
 CellID->170260561],
Cell[CellGroupData[{
Cell[66856, 1504, 124, 1, 54, "Subsubsection",ExpressionUUID->"c0470cc0-e691-492a-8750-4ba233a12836",
 CellID->223167042],
Cell[66983, 1507, 622, 18, 36, "Text",ExpressionUUID->"ef56bd79-ae25-4223-93c5-76d8635868a9",
 CellID->104041704],
Cell[67608, 1527, 648, 21, 50, "DisplayFormulaNumbered",ExpressionUUID->"556dbdbe-24c0-4cb2-a2b1-24ef6213bedd",
 CellID->98937483],
Cell[68259, 1550, 106, 1, 36, "Text",ExpressionUUID->"18580e31-d605-405b-b339-479697dfdbcc",
 CellID->114052419],
Cell[68368, 1553, 340, 10, 32, "DisplayFormulaNumbered",ExpressionUUID->"3968f058-f993-401b-b505-5bd725110ecb",
 CellID->501661444],
Cell[68711, 1565, 315, 8, 36, "Text",ExpressionUUID->"6f894edc-0587-4fd0-bd63-d469a1b15d2c",
 CellID->66520717],
Cell[69029, 1575, 704, 23, 32, "DisplayFormulaNumbered",ExpressionUUID->"6fa29089-04c8-45b5-8126-53f796adf972",
 CellID->206872034],
Cell[69736, 1600, 616, 18, 36, "Text",ExpressionUUID->"a7db57bf-6832-4d07-a5a7-d4927492148e",
 CellID->189861345],
Cell[70355, 1620, 660, 21, 43, "DisplayFormulaNumbered",ExpressionUUID->"bc712666-d95d-4520-b9a5-2281287c5f95",
 CellID->368114463],
Cell[71018, 1643, 187, 8, 71, "SolvedExample",ExpressionUUID->"48271af4-ab40-4f95-b2ec-f1fd31ac58a1",
 CellID->101243708],
Cell[71208, 1653, 770, 24, 45, "SolvedExampleNote",ExpressionUUID->"7bfadd8d-ddff-4323-8058-3f0214beb977",
 CellID->82553203],
Cell[71981, 1679, 295, 8, 39, "SolvedExampleNote",ExpressionUUID->"2a73a88e-3c29-45fd-b92a-e57b1363a035",
 CellID->201466207],
Cell[72279, 1689, 986, 31, 45, "SolvedExampleNote",ExpressionUUID->"8584d737-8e6e-43e9-a331-f8eac41df9a2",
 CellID->346253189],
Cell[73268, 1722, 404, 11, 39, "SolvedExampleNote",ExpressionUUID->"2cebf164-ea50-411a-a209-5b2e2a8463c2",
 CellID->54141627],
Cell[CellGroupData[{
Cell[73697, 1737, 993, 31, 43, "SolvedExampleInput",ExpressionUUID->"0ce93160-e5bf-4628-a68e-4583d151d874",
 CellID->20976512],
Cell[74693, 1770, 45099, 765, 202, "SolvedExampleOutput",ExpressionUUID->"a61cc350-c5f0-4ef6-bac4-58ce560bf50a",
 CellID->2140970035]
}, {2}]],
Cell[119804, 2538, 127, 1, 39, "SolvedExampleNote",ExpressionUUID->"e45e1603-b18d-4a35-9c48-e94ffbb61dc1",
 CellID->166465163],
Cell[CellGroupData[{
Cell[119956, 2543, 673, 20, 47, "SolvedExampleInput",ExpressionUUID->"f7e810c6-1246-46d5-8797-e31261313099",
 CellID->32164384],
Cell[120632, 2565, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"7724e398-6094-43d7-9b08-f11c4739223b",
 CellID->204414958]
}, Open  ]],
Cell[120763, 2569, 279, 8, 39, "SolvedExampleNote",ExpressionUUID->"5bd2336b-bf30-485c-b7cc-a6d330e68e8a",
 CellID->387285508],
Cell[121045, 2579, 1036, 33, 45, "SolvedExampleNote",ExpressionUUID->"f2592415-a03b-46df-8234-20f7e0670037",
 CellID->247013697],
Cell[122084, 2614, 404, 11, 39, "SolvedExampleNote",ExpressionUUID->"4803f455-a935-4487-b29b-f2ba31bb1dfe",
 CellID->58121628],
Cell[CellGroupData[{
Cell[122513, 2629, 994, 31, 43, "SolvedExampleInput",ExpressionUUID->"f6e04a45-154b-4a48-95b5-0bef547fb949",
 CellID->626915360],
Cell[123510, 2662, 45099, 765, 202, "SolvedExampleOutput",ExpressionUUID->"fcac6cbc-7dd9-4204-abb8-b35d75d98084",
 CellID->1416313729]
}, {2}]],
Cell[168621, 3430, 127, 1, 39, "SolvedExampleNote",ExpressionUUID->"e3970cdb-ac83-4a3c-a466-2ab9e0758a33",
 CellID->175475252],
Cell[CellGroupData[{
Cell[168773, 3435, 673, 20, 47, "SolvedExampleInput",ExpressionUUID->"0eb40752-6534-4e34-b0eb-d8d5f7184922",
 CellID->19421528],
Cell[169449, 3457, 132, 2, 36, "SolvedExampleOutput",ExpressionUUID->"16b92dfa-dd55-433d-ae98-6b7bb838210c",
 CellID->46030225]
}, Open  ]],
Cell[169596, 3462, 203, 6, 39, "SolvedExampleNote",ExpressionUUID->"c536b0e3-feb8-429a-95e9-d072f5d84af8",
 CellID->617999607],
Cell[CellGroupData[{
Cell[169824, 3472, 349, 10, 53, "SolvedExampleInput",ExpressionUUID->"680c4b3e-92d3-42f8-89a9-13ce4014c378",
 CellID->14824385],
Cell[170176, 3484, 115, 1, 36, "SolvedExampleOutput",ExpressionUUID->"931da3bc-cb59-42dd-b031-94b264b6b50f",
 CellID->90514778]
}, Open  ]],
Cell[CellGroupData[{
Cell[170328, 3490, 350, 10, 53, "SolvedExampleInput",ExpressionUUID->"f33549cd-7f32-4f85-9c4a-3ccd496f6a1d",
 CellID->173643312],
Cell[170681, 3502, 133, 2, 36, "SolvedExampleOutput",ExpressionUUID->"8571fe1c-035d-40d4-87c4-6422b8367476",
 CellID->440348068]
}, Open  ]],
Cell[170829, 3507, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"bd883170-8be5-4e2d-89b0-bc8e8c974057",
 CellID->1442706338],
Cell[170939, 3510, 187, 8, 71, "SolvedExample",ExpressionUUID->"951442c8-b9aa-43f6-97cc-c4261fa8fec3",
 CellID->737719333],
Cell[171129, 3520, 527, 16, 43, "SolvedExampleNote",ExpressionUUID->"0efdd959-25ab-41a4-9cd3-91da78daa00b",
 CellID->968566102],
Cell[171659, 3538, 122, 1, 39, "SolvedExampleNote",ExpressionUUID->"45cfbb4e-2aa7-4071-ba44-d9a14610f27c",
 CellID->569809934],
Cell[171784, 3541, 808, 25, 43, "SolvedExampleNote",ExpressionUUID->"741888f9-b7d8-46ed-b8ac-fbbfe68f1219",
 CellID->26551088],
Cell[172595, 3568, 124, 1, 39, "SolvedExampleNote",ExpressionUUID->"998a91ee-9609-4851-b801-a5537310a85c",
 CellID->365059817],
Cell[CellGroupData[{
Cell[172744, 3573, 276, 7, 25, "SolvedExampleInput",ExpressionUUID->"7999b42b-8318-400a-8ba8-1bc740e72b8e",
 CellID->458530947],
Cell[173023, 3582, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"8fad7124-7ad2-46f3-ba1d-219ed1a24c78",
 CellID->186142935]
}, Open  ]],
Cell[173154, 3586, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"2ad27f87-038b-4aab-98e5-d092a01948ae",
 CellID->1062303059]
}, Open  ]],
Cell[CellGroupData[{
Cell[173298, 3592, 130, 1, 54, "Subsubsection",ExpressionUUID->"f6bd7cdd-f454-4ae8-97c1-5f3b42d7752b",
 CellID->140574552],
Cell[173431, 3595, 683, 18, 60, "Text",ExpressionUUID->"fdecc6d4-f82d-4f60-b084-68cd287ba722",
 CellID->1008736006],
Cell[174117, 3615, 1062, 35, 51, "DisplayFormulaNumbered",ExpressionUUID->"d6efafad-bfe0-4c8d-b73d-b1fcae756e1a",
 CellID->223245362],
Cell[175182, 3652, 662, 20, 36, "Text",ExpressionUUID->"ce9c0fef-96ba-4ad0-ac32-c9f1eea51032",
 CellID->301713522],
Cell[175847, 3674, 950, 31, 32, "DisplayFormulaNumbered",ExpressionUUID->"e1cad3b3-0b95-48e9-85bd-c12f9f6ed3d3",
 CellID->348782592],
Cell[176800, 3707, 443, 14, 36, "Text",ExpressionUUID->"74067a8e-b14d-4fef-82fd-fbbf3fb393ec",
 CellID->18552761],
Cell[177246, 3723, 1054, 33, 62, "DisplayFormulaNumbered",ExpressionUUID->"64e732d5-4599-4ea5-93ac-b11b46972c76",
 CellID->646897887],
Cell[178303, 3758, 186, 8, 71, "SolvedExample",ExpressionUUID->"f808dd0a-37b8-4f05-a7fe-5ee7b75d59fc",
 CellID->95196737],
Cell[178492, 3768, 742, 24, 45, "SolvedExampleNote",ExpressionUUID->"a054a4c0-9647-4a39-b4c2-a11c56383fc2",
 CellID->366355903],
Cell[179237, 3794, 330, 8, 39, "SolvedExampleNote",ExpressionUUID->"449b7010-cfbf-47f0-b9f8-09da1b33afb4",
 CellID->59882574],
Cell[179570, 3804, 2122, 71, 138, "SolvedExampleNote",ExpressionUUID->"04df45f2-890b-4f09-8aa6-57c20942c716",
 CellID->59020675],
Cell[181695, 3877, 181, 6, 39, "SolvedExampleNote",ExpressionUUID->"b613bc16-e644-4952-9e82-b294ba441ee5",
 CellID->49210441],
Cell[CellGroupData[{
Cell[181901, 3887, 461, 14, 54, "SolvedExampleInput",ExpressionUUID->"54591534-35b8-4c4e-ab68-ba87003fdc76",
 CellID->280052835],
Cell[182365, 3903, 195, 4, 54, "SolvedExampleOutput",ExpressionUUID->"47972ce2-567a-4945-8648-96efdb01ff24",
 CellID->207020945]
}, Open  ]],
Cell[182575, 3910, 143, 1, 39, "SolvedExampleNote",ExpressionUUID->"8f7dd286-051b-42e2-82d8-6be27f9fc5f1",
 CellID->411345042],
Cell[CellGroupData[{
Cell[182743, 3915, 1627, 46, 27, "SolvedExampleInput",ExpressionUUID->"3bbcf899-6da6-4bb6-adc7-97380e0f0f66",
 CellID->40425968],
Cell[184373, 3963, 48079, 814, 202, "SolvedExampleOutput",ExpressionUUID->"d47637e0-6d4d-499b-90e7-ccf1125d90a1",
 CellID->419141379]
}, Open  ]],
Cell[232467, 4780, 140, 1, 39, "SolvedExampleNote",ExpressionUUID->"8a0942d3-9ade-4034-a340-f9ea4eddd2f5",
 CellID->144024778],
Cell[CellGroupData[{
Cell[232632, 4785, 713, 21, 54, "SolvedExampleInput",ExpressionUUID->"c4d17bd7-286b-4394-9e45-44f9df4c5286",
 CellID->735691309],
Cell[233348, 4808, 195, 4, 54, "SolvedExampleOutput",ExpressionUUID->"ade6792c-b15b-472d-b046-75c797bc4bcd",
 CellID->147341242]
}, Open  ]],
Cell[233558, 4815, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"4bfe876c-de21-4c49-be7d-643ad3c6041b",
 CellID->903088054],
Cell[233667, 4818, 187, 8, 71, "SolvedExample",ExpressionUUID->"818aa0f0-4ce9-4d3c-8507-644695e08923",
 CellID->588099053],
Cell[233857, 4828, 672, 21, 48, "SolvedExampleNote",ExpressionUUID->"e5b8eb95-3527-42a3-af74-952093d7bc2e",
 CellID->6080057],
Cell[234532, 4851, 393, 9, 61, "SolvedExampleNote",ExpressionUUID->"74438e3f-d884-40b6-b347-c8a62c07025f",
 CellID->350020632],
Cell[234928, 4862, 2771, 93, 160, "SolvedExampleNote",ExpressionUUID->"4a349ba8-6d0f-4da3-ab94-4bb1f9ccccb5",
 CellID->746388581],
Cell[237702, 4957, 181, 6, 39, "SolvedExampleNote",ExpressionUUID->"3be502b3-d9a0-4af8-80ab-631500b909c3",
 CellID->89197973],
Cell[CellGroupData[{
Cell[237908, 4967, 408, 12, 59, "SolvedExampleInput",ExpressionUUID->"d3d32a35-7e0a-487b-8145-ad0891129e19",
 CellID->292132913],
Cell[238319, 4981, 165, 3, 57, "SolvedExampleOutput",ExpressionUUID->"464a115f-f8d4-4322-8c5a-397f1d5028fc",
 CellID->480478357]
}, Open  ]],
Cell[238499, 4987, 141, 1, 39, "SolvedExampleNote",ExpressionUUID->"4f2f1251-116d-405f-b6d1-16ab981d19ca",
 CellID->4405082],
Cell[CellGroupData[{
Cell[238665, 4992, 1528, 42, 27, "SolvedExampleInput",ExpressionUUID->"a4c482d9-1f29-4e3c-95b9-aecd778fb076",
 CellID->58535670],
Cell[240196, 5036, 51338, 868, 202, "SolvedExampleOutput",ExpressionUUID->"ac2121a7-97cf-4f4f-94e3-db5ee9f8158b",
 CellID->2116558676]
}, {2}]],
Cell[291546, 5907, 150, 1, 39, "SolvedExampleNote",ExpressionUUID->"63ca0be1-d470-4706-9c9e-bae46104e423",
 CellID->203348715],
Cell[CellGroupData[{
Cell[291721, 5912, 634, 19, 59, "SolvedExampleInput",ExpressionUUID->"ddbfcaa0-d22b-4f41-adbc-23dc7e836b0b",
 CellID->180404352],
Cell[292358, 5933, 164, 3, 57, "SolvedExampleOutput",ExpressionUUID->"182162d1-880d-45b7-8473-fb9d7755aca8",
 CellID->36253866]
}, Open  ]],
Cell[292537, 5939, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"e30c6f23-3bbc-4302-b999-882d70e98923",
 CellID->1382559361]
}, Open  ]],
Cell[CellGroupData[{
Cell[292681, 5945, 118, 1, 54, "Subsubsection",ExpressionUUID->"0d9555f6-60a8-460c-b857-d132d3acc581",
 CellID->76767682],
Cell[292802, 5948, 480, 12, 36, "Text",ExpressionUUID->"07af33ea-a2c0-44a9-a607-d5d57cca4363",
 CellID->217956439],
Cell[293285, 5962, 548, 17, 48, "DisplayFormulaNumbered",ExpressionUUID->"6836b886-d7f9-4d36-b846-9c8f9172858a",
 CellID->232148208],
Cell[293836, 5981, 594, 11, 107, "Text",ExpressionUUID->"52f4a87a-40d5-4368-8e51-67aaa0f1bfcd",
 CellID->715292654],
Cell[CellGroupData[{
Cell[294455, 5996, 3824, 107, 70, "Input",ExpressionUUID->"28a561bd-7a47-4647-8764-0e0420729f97",
 CellID->134060535],
Cell[298282, 6105, 10633, 258, 263, "Output",ExpressionUUID->"bc59d4aa-cdcb-406e-a4a7-ac799fcde263",
 CellID->553360793]
}, {2}]],
Cell[308927, 6366, 161, 3, 36, "Text",ExpressionUUID->"fdc53a21-5d7e-4ae1-ba6a-01037ad433f7",
 CellID->254828936],
Cell[309091, 6371, 550, 18, 50, "DisplayFormulaNumbered",ExpressionUUID->"6b913853-0523-4416-b901-060ebbd3c0ff",
 CellID->370547823],
Cell[309644, 6391, 249, 4, 60, "Text",ExpressionUUID->"e19f409c-b51b-4a13-ac5b-68d34eda245d",
 CellID->450039523],
Cell[309896, 6397, 187, 8, 71, "SolvedExample",ExpressionUUID->"7e015849-b58e-45ea-8be6-69d09edae090",
 CellID->324068005],
Cell[310086, 6407, 445, 13, 45, "SolvedExampleNote",ExpressionUUID->"0c66d340-a3bd-4769-8d26-903c66c89a79",
 CellID->46733270],
Cell[310534, 6422, 773, 26, 45, "SolvedExampleNote",ExpressionUUID->"e4690273-f4c2-4579-943c-18386b1f924f",
 CellID->346627922],
Cell[CellGroupData[{
Cell[311332, 6452, 351, 10, 25, "SolvedExampleInput",ExpressionUUID->"89bd69ca-6596-4938-a3a0-ea0c864e3098",
 CellID->15751680],
Cell[311686, 6464, 133, 2, 36, "SolvedExampleOutput",ExpressionUUID->"53fbe78f-4805-40be-a1f3-56b9ac703ac4",
 CellID->111334742]
}, Open  ]],
Cell[311834, 6469, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"f42b6370-b80c-4305-b4eb-41d2d9418495",
 CellID->1803284084],
Cell[311944, 6472, 187, 8, 71, "SolvedExample",ExpressionUUID->"ce5d5c88-20c2-4b82-a57c-c064b483fdc6",
 CellID->332475691],
Cell[312134, 6482, 564, 17, 45, "SolvedExampleNote",ExpressionUUID->"b0a50de9-8798-44cc-893e-13185c6623d3",
 CellID->68224539],
Cell[312701, 6501, 198, 6, 39, "SolvedExampleNote",ExpressionUUID->"caffeaf2-1edf-4055-b282-59572a8cff80",
 CellID->221535777],
Cell[CellGroupData[{
Cell[312924, 6511, 673, 21, 53, "SolvedExampleInput",ExpressionUUID->"18456979-e1e0-4634-8196-86f594d823a1",
 CellID->553264741],
Cell[313600, 6534, 131, 2, 36, "SolvedExampleOutput",ExpressionUUID->"b07a8780-90ec-4fea-86ab-b678dbaa28a5",
 CellID->9629729]
}, Open  ]],
Cell[313746, 6539, 121, 1, 39, "SolvedExampleNote",ExpressionUUID->"7c7b4114-f41c-4484-9015-c1e3362f0692",
 CellID->239208734],
Cell[CellGroupData[{
Cell[313892, 6544, 437, 13, 53, "SolvedExampleInput",ExpressionUUID->"aaff8bf1-0b0d-40ef-ab65-f45459960d2a",
 CellID->30870128],
Cell[314332, 6559, 133, 2, 36, "SolvedExampleOutput",ExpressionUUID->"6d5c83c4-2499-4092-8f09-46525d832723",
 CellID->197982396]
}, Open  ]],
Cell[314480, 6564, 410, 13, 39, "SolvedExampleNote",ExpressionUUID->"5763bc11-950a-4c33-b106-1e6ff5e1b4e2",
 CellID->850303937],
Cell[314893, 6579, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"610fb010-c6e1-4a6c-bf6f-4ffeb227e5a7",
 CellID->1426917136],
Cell[CellGroupData[{
Cell[315025, 6584, 109, 1, 69, "SummarySection",ExpressionUUID->"75df4c47-06b2-4f1b-b554-e9ceaa1d9b0b",
 CellID->1198545324],
Cell[315137, 6587, 146, 1, 29, "SummaryList",ExpressionUUID->"3bf1b538-3d00-4635-8fbb-8a6aee6cd701",
 CellID->312737344],
Cell[315286, 6590, 716, 21, 29, "SummaryList",ExpressionUUID->"357fc55d-62df-4d58-b5b8-1168bcf1ff14",
 CellID->242547148],
Cell[316005, 6613, 459, 12, 29, "SummaryList",ExpressionUUID->"ad5ecaef-0af9-4473-913e-bf3286a7d53d",
 CellID->889336061],
Cell[316467, 6627, 942, 27, 34, "SummaryList",ExpressionUUID->"cc121380-7a7f-418f-a298-d2b1f60892ee",
 CellID->43197424]
}, Open  ]],
Cell[CellGroupData[{
Cell[317446, 6659, 160, 3, 65, "ExerciseSection",ExpressionUUID->"760f41d4-2320-4e63-a9dc-d12f66197788",
 CellID->468959188],
Cell[317609, 6664, 788, 25, 35, "Exercise",ExpressionUUID->"52c718f3-b189-4b2c-9aac-4f381b41c09e",
 CellID->2721810],
Cell[CellGroupData[{
Cell[318422, 6693, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"aa3598bd-79db-4673-89ce-926cf84d1db3"],
Cell[318516, 6695, 1021, 33, 46, "SolutionAnswer",ExpressionUUID->"fd22d134-9714-46d9-97ea-d7bdf63b8700",
 CellID->127855160],
Cell[CellGroupData[{
Cell[319562, 6732, 383, 12, 48, "ExerciseInput",ExpressionUUID->"4f7b10bd-7ec6-4d9c-96ea-b3ad03467e81",
 CellID->634307281],
Cell[319948, 6746, 127, 2, 28, "ExerciseOutput",ExpressionUUID->"879fa399-917d-4637-ad8e-13e81f42ce6e",
 CellID->23684142]
}, Open  ]],
Cell[320090, 6751, 945, 32, 26, "SolutionAnswer",ExpressionUUID->"5e61577c-f2ce-4675-b4d0-13870d512ecd",
 CellID->94750313],
Cell[CellGroupData[{
Cell[321060, 6787, 383, 12, 48, "ExerciseInput",ExpressionUUID->"12224e69-b42a-41ce-959d-cded406440aa",
 CellID->428194791],
Cell[321446, 6801, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"3b746a68-7906-471e-9723-bd75de207bb9",
 CellID->563502590]
}, Open  ]],
Cell[321572, 6805, 1382, 45, 28, "SolutionAnswer",ExpressionUUID->"812bff16-64f9-4da5-a929-589216b46e7e",
 CellID->388470331],
Cell[CellGroupData[{
Cell[322979, 6854, 390, 12, 48, "ExerciseInput",ExpressionUUID->"98f20e3b-b6f6-4a98-971c-61370bbb2553",
 CellID->133789978],
Cell[323372, 6868, 128, 2, 28, "ExerciseOutput",ExpressionUUID->"eeb2c0ff-e890-4f02-8029-257771617761",
 CellID->644209465]
}, Open  ]]
}, Closed]],
Cell[323527, 6874, 645, 21, 31, "Exercise",ExpressionUUID->"267a1072-07b4-4f95-9a47-fa13780c4c36",
 CellID->110796339],
Cell[CellGroupData[{
Cell[324197, 6899, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"ac0f3b3e-a727-496e-b25f-f92646abfdd4"],
Cell[324291, 6901, 321, 8, 22, "SolutionAnswer",ExpressionUUID->"b98771f8-55de-4fbc-a621-ede55b582f52",
 CellID->124664818],
Cell[CellGroupData[{
Cell[324637, 6913, 383, 12, 48, "ExerciseInput",ExpressionUUID->"3bbdc06e-7152-49c4-be93-102297d04958",
 CellID->348443747],
Cell[325023, 6927, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"bf2ddd6a-e9e3-4b82-bf7a-3760dbf6ed21",
 CellID->754240042]
}, Open  ]]
}, Closed]],
Cell[325161, 6932, 844, 26, 34, "Exercise",ExpressionUUID->"034ca6f6-4c8f-4c1f-9908-dec08c557551",
 CellID->82897209],
Cell[CellGroupData[{
Cell[326030, 6962, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"5654722a-08a3-4bf9-bf48-9e1488aae146"],
Cell[326124, 6964, 879, 29, 31, "SolutionAnswer",ExpressionUUID->"7dd57020-07a3-47f6-ad72-88b34030e35b",
 CellID->866961535],
Cell[CellGroupData[{
Cell[327028, 6997, 402, 12, 52, "ExerciseInput",ExpressionUUID->"444337d8-e435-4232-9dc8-6a5de319bb30",
 CellID->57340033],
Cell[327433, 7011, 128, 2, 28, "ExerciseOutput",ExpressionUUID->"1ef15024-2d6a-49c6-979d-c1a6e52d9a88",
 CellID->169994532]
}, Open  ]],
Cell[327576, 7016, 1794, 57, 51, "SolutionAnswer",ExpressionUUID->"d95c096e-3961-4624-9fbe-7183a92c9e72",
 CellID->43137864],
Cell[CellGroupData[{
Cell[329395, 7077, 424, 13, 52, "ExerciseInput",ExpressionUUID->"065df090-b3b9-4e1c-92c1-3d7610b4010f",
 CellID->152637839],
Cell[329822, 7092, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"b4d9e2cf-07e6-4187-888e-508590ade9a7",
 CellID->607834206]
}, Open  ]],
Cell[329948, 7096, 2046, 68, 35, "SolutionAnswer",ExpressionUUID->"88f3d5d3-652f-4d0c-b3cf-1495cb18f7fe",
 CellID->133669787],
Cell[CellGroupData[{
Cell[332019, 7168, 408, 12, 52, "ExerciseInput",ExpressionUUID->"1f2d1411-60fb-408d-8f10-4a5fa6e23044",
 CellID->5691406],
Cell[332430, 7182, 128, 2, 28, "ExerciseOutput",ExpressionUUID->"bbcc4aa0-e7c8-4ff8-b2db-5a5b4d7e043a",
 CellID->216271259]
}, Open  ]]
}, Closed]],
Cell[332585, 7188, 553, 17, 29, "Exercise",ExpressionUUID->"d6ce202a-eb0f-4d95-a1ce-86ad9af35032",
 CellID->459944470],
Cell[CellGroupData[{
Cell[333163, 7209, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"09c60075-6774-495e-af34-7b4d6b27923e"],
Cell[333257, 7211, 782, 25, 26, "SolutionAnswer",ExpressionUUID->"2dd990a5-d313-46d9-937a-5772568a5fdb",
 CellID->131102330],
Cell[CellGroupData[{
Cell[334064, 7240, 295, 8, 47, "ExerciseInput",ExpressionUUID->"e4dd3842-5611-4ec6-a2cf-41482c8693c5",
 CellID->458836708],
Cell[334362, 7250, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"da69f486-3289-49b2-933f-e653d9d18a6d",
 CellID->633687092]
}, Open  ]]
}, Closed]],
Cell[334500, 7255, 918, 30, 33, "Exercise",ExpressionUUID->"60ef1e6c-e590-4501-9369-5e75ba0f9b4e",
 CellID->169403244],
Cell[CellGroupData[{
Cell[335443, 7289, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"dc554cfd-bfbd-4fc2-9527-894e3e88c5e0"],
Cell[335537, 7291, 1454, 49, 30, "SolutionAnswer",ExpressionUUID->"c2cd6886-825e-4278-b5e3-bbfe166b671b",
 CellID->244671311],
Cell[CellGroupData[{
Cell[337016, 7344, 545, 18, 25, "ExerciseInput",ExpressionUUID->"62329dff-80ee-4a84-b1ce-b6c7395a0a1b",
 CellID->103943963],
Cell[337564, 7364, 133, 2, 45, "ExerciseOutput",ExpressionUUID->"3adae065-0afe-4467-988a-b94177ef464e",
 CellID->755149062]
}, Open  ]],
Cell[337712, 7369, 992, 33, 30, "SolutionAnswer",ExpressionUUID->"82eed651-3a49-4ec6-a451-8f5967c6e860",
 CellID->510451484],
Cell[CellGroupData[{
Cell[338729, 7406, 524, 17, 25, "ExerciseInput",ExpressionUUID->"0c9634d8-2fa6-4b11-8832-7a8e546e77d4",
 CellID->851418028],
Cell[339256, 7425, 150, 3, 45, "ExerciseOutput",ExpressionUUID->"5ea34956-98d1-44f2-83f1-01401d259f8e",
 CellID->33173818]
}, Open  ]],
Cell[339421, 7431, 1887, 63, 30, "SolutionAnswer",ExpressionUUID->"0e6cd851-5f4d-4235-8674-b171e3bbc195",
 CellID->354636453],
Cell[CellGroupData[{
Cell[341333, 7498, 530, 17, 25, "ExerciseInput",ExpressionUUID->"241d9cfb-d957-46d4-bce9-473d3f59cafc",
 CellID->27789853],
Cell[341866, 7517, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"5a8eabe7-a675-4f34-a295-08a644327cb0",
 CellID->157438391]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[342052, 7526, 309, 6, 135, "SmallText",ExpressionUUID->"f7760af8-858c-4d4d-80d7-01eb4a944fae",
 CellGroupingRules->"SectionGrouping",
 CellID->778347762]
}
]
*)

(* NotebookSignature iRcEoGa@PoqgSiIxnyDaEoiz *)
