(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    443414,      10134]
NotebookOptionsPosition[    280678,       6734]
NotebookOutlinePosition[    418955,       9682]
CellTagsIndexPosition[    418912,       9679]
WindowTitle->28. Laplace Transforms | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Laplace Transforms"
}], "Section",
 CounterAssignments->{{"Section", 27}},
 CellID->209017977,ExpressionUUID->"c1f60595-87e2-4f3d-af00-9114ffe2dc95"],

Cell["\<\
This chapter is an introduction to the Laplace transform. The Laplace \
transform is an example of an integral transform, which is an operation that \
transforms a function into another by taking an integral of the original \
function, often multiplied by a \[OpenCurlyDoubleQuote]kernel\
\[CloseCurlyDoubleQuote] or otherwise manipulated.\
\>", "Text",
 CellID->602462738,ExpressionUUID->"92e3b7ef-fa54-4926-802f-9e0360aa97ed"],

Cell["\<\
Famous examples of integral transforms are the Fourier transform, the Mellin \
transform and the Laplace transform, which is the subject of this chapter.\
\>", "Text",
 CellID->532596437,ExpressionUUID->"9f21c376-6229-4562-af91-bb0a16e8f066"],

Cell["\<\
Integral transforms have many applications in science and engineering. For \
example, the Laplace transform is the standard method by which many \
differential equations occurring in electronics are solved.\
\>", "Text",
 CellID->23118163,ExpressionUUID->"7c6128d8-91ae-4e4c-a0ac-ed42c7aca0bc"],

Cell[CellGroupData[{

Cell["The Laplace Transform", "Subsection",
 CellID->578882762,ExpressionUUID->"41833d14-c978-441f-bbe3-095a25e8c598"],

Cell[TextData[{
 "The Laplace transform of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3c5fa57c-de91-418f-bf4d-10e4d58d0ce6"],
 " is denoted by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{
     RowBox[{"\[ScriptCapitalL]", "[", 
      RowBox[{"f", "(", "t", ")"}], "]"}], 
     RowBox[{"(", "s", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c0078e07-b0e6-4dc1-921e-e561194a3a29"],
 " and is defined as:"
}], "Text",
 CellID->435757350,ExpressionUUID->"3b569e6a-4b29-44f7-90a3-eae3b49906e6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", "s", ")"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"\[ScriptCapitalL]", "[", 
      RowBox[{"f", "(", "t", ")"}], "]"}], 
     RowBox[{"(", "s", ")"}]}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "s"}], "\[InvisibleSpace]", "t"}]], 
      RowBox[{"f", "(", "t", ")"}], 
      RowBox[{
       RowBox[{"\[DifferentialD]", "t"}], "."}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->551401871,ExpressionUUID->"5f707744-837a-43bd-badd-e619465bd112"],

Cell[TextData[{
 "Here, the parameter ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7971f80d-0a36-4fcf-8e6b-58c5335d2f84"],
 " is a complex variable, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"834b9af7-b833-4a74-9a47-fe163dcfd1a1"],
 " is a complex function. Notice that the Laplace transform does not exist \
for all functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"083ca806-85c6-4025-8cd6-caa382cdb314"],
 ", for example, when the integral in Eq. (1) diverges."
}], "Text",
 CellID->522198673,ExpressionUUID->"e45db0b1-63f3-4c56-ba83-fe2ec0ca9e00"],

Cell[TextData[{
 "In Wolfram Language, you can compute the Laplace transform either using the \
command ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 " and Eq. (1) or using the specialized command ",
 ButtonBox["LaplaceTransform",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->536763341,ExpressionUUID->"8e60c18b-030e-496c-8f4e-62744bf75a65"],

Cell["\<\
Let\[CloseCurlyQuote]s calculate the Laplace transform of some simple \
functions.\
\>", "Text",
 CellID->68663891,ExpressionUUID->"e05119dd-792b-497d-b33d-6e41a84cfb26"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->1906984,ExpressionUUID->"9975f5dd-b282-4a58-9c74-f2abea375dfd"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalL]", "[", 
     RowBox[{"f", "(", "t", ")"}], "]"}], 
    RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2b4a2dfb-8222-4fde-98ee-07845b671576"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", "a"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"16e73edb-6d7b-4339-afe6-3e4d5aae1417"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Element]", "\[DoubleStruckCapitalC]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"042e51f6-623d-4ee3-b94b-5d9a29d5062b"],
 " is a constant."
}], "SolvedExampleNote",
 CellID->311349781,ExpressionUUID->"87c6c78d-5162-40ea-a0dd-c759d55343a7"],

Cell["From the definition Eq. (1):", "SolvedExampleNote",
 CellID->248782227,ExpressionUUID->"3e4fe40b-75cc-42fa-92f5-2ba1fa5c1a95"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"\[VeryThinSpace]", "0"}], "\[Infinity]"], 
      RowBox[{"a", "\[InvisibleSpace]", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "s"}], "\[InvisibleSpace]", "t"}]], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
     RowBox[{
      RowBox[{"a", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"\[VeryThinSpace]", "0"}], "\[Infinity]"], 
        "\[InvisibleSpace]", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "s"}], "\[InvisibleSpace]", "t"}]], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}], "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], "\[InvisibleSpace]", 
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "s"}], "\[InvisibleSpace]", "t"}]], "s"]}], 
        SubsuperscriptBox["|", 
         RowBox[{"t", "=", "0"}], 
         RowBox[{"t", "=", "\[Infinity]"}]]}], "=", 
       FractionBox["a", "s"]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ee354f0b-eda1-4bd6-bac6-c4f09beda500"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "(", "s", ")"}], ">", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"fece4be5-633d-45a5-b640-e9867927ce3c"],
 "."
}], "SolvedExampleNote",
 CellID->289749354,ExpressionUUID->"bc8a9aea-5dfb-431c-ade8-de131e85326a"],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["LaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->496505997,ExpressionUUID->"11976656-9d7b-4dd2-9ebb-72102acb3ac0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{"a", ",", "t", ",", "s", ",", 
   RowBox[{"GenerateConditions", "->", "True"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->1034554352,ExpressionUUID->"2fe1fe66-8ac6-4dfe-b0b9-a2910da26578"],

Cell[BoxData[
 TemplateBox[{
   FractionBox["a", "s"], 
   RowBox[{
     RowBox[{"Re", "[", "s", "]"}], ">", "0"}]},
  "ConditionalExpression"]], "SolvedExampleOutput",
 CellID->432571558,ExpressionUUID->"6dc96fe4-cdd2-452d-afca-77d847b41405"]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "(", "s", ")"}], "<", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2dc72905-d5ed-454b-a57e-1e7c365efc4b"],
 ", the integral diverges, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4fa5be13-4b65-4c7d-8d1b-5bb9532be941"],
 " is not defined there. The two functions look like this for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ee6d491a-3e05-46db-a2e0-87da03dc45c5"],
 ", plotting ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"97a1d3f0-0db7-4b51-a895-8e3ea1cf51a4"],
 " on the real line only:"
}], "SolvedExampleNote",
 CellID->62923732,ExpressionUUID->"f8c164fc-8338-4ac6-a0b1-575fe07acbee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"Ticks", "->", "None"}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{"t", ",", 
         RowBox[{"f", "[", "t", "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"5", "/", "2"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"ImageSize", "->", "Small"}]}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "->", "50"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"1", "/", "s"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "5"}], "}"}], ",", 
      RowBox[{"Ticks", "->", "None"}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{"s", ",", 
         RowBox[{"F", "[", "s", "]"}]}], "}"}]}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"5", "/", "2"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"ImageSize", "->", "Small"}]}], "]"}]}], "}"}], 
  "]"}]], "SolvedExampleInput",
 CellID->1266185,ExpressionUUID->"cbadc20e-2f91-4316-9115-9cfecc00c3dc"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdqOAQw+2LPffqT+Vn6lPYy/8NT8wtfy
O+H8des7b+fonYLz0+0vznxTdBnOz3uq+XjLuptwPpdii/p9iwdwfp/Aaa2F
CY/h/KTbIfuZzzyD8wuPtiTlq7+C8zcW8ARLeL5FuKc6+5VB+Ac4v2n+n8Av
bz7C+QyXHzjsqfoM56uVpFWEaH2F8598nR7GvfcbnO/1NKt2UuEPON/vyQRt
OblfcP6rw0kNJ9b+hvP1BK/JOsf/RfjP/mvinc//4Hz3t1HflUIZHGD8G4dS
GKN0GOH8rR1H4hS+IvhprKUPzp1jgvOTi6q38sxihvP107XP+SSywPnnhXS4
Sy1Z4fzd65pm6zCzwfnVjFoBZ+4i+Fx3qjzytrDD+U+XKU6ZX8MB50/RkGTZ
GcoJ50+YlXY8UYELzo+aEnuO5zmC/8Nl6c/5+7jh/MdPnSoOtfPA+YtsDaXP
JvLC+WtbSwXTdfng/PbQZG/mrwi+6Z2FK9vP8sP5MzRnrz3rLQDn1x/oneG9
E8H3lQ5dekpFEM53zDseLdiJ4M+XSVI58xXBVzm8fJpftBDCf7qHtC7tQ/DT
PrNcPKklDOcnbfyk0NmP4E+4xNN75DiCv++z2s///xF8AP7L+hA=
            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdqOAQw+2LPffqT+Vn6lPYy/8NT8wtfy
O+H8des7b+fonYLz0+0vznxTdBnOz3uq+XjLuptwPpdii/p9iwdwfp/Aaa2F
CY/h/KTbIfuZzzyD8wuPtiTlq7+C8zcW8ARLeL5FuKc6+5VB+Ac4v2n+n8Av
bz7C+QyXHzjsqfoM56uVpFWEaH2F8598nR7GvfcbnO/1NKt2UuEPON/vyQRt
OblfcP6rw0kNJ9b+hvP1BK/JOsf/RfjP/mvinc//4Hz3t1HflUIZHGD8G4dS
GKN0GOH8rR1H4hS+IvhprKUPzp1jgvOTi6q38sxihvP107XP+SSywPnnhXS4
Sy1Z4fzd65pm6zCzwfnVjFoBZ+4i+Fx3qjzytrDD+U+XKU6ZX8MB50/RkGTZ
GcoJ50+YlXY8UYELzo+aEnuO5zmC/8Nl6c/5+7jh/MdPnSoOtfPA+YtsDaXP
JvLC+WtbSwXTdfng/PbQZG/mrwi+6Z2FK9vP8sP5MzRnrz3rLQDn1x/oneG9
E8H3lQ5dekpFEM53zDseLdiJ4M+XSVI58xXBVzm8fJpftBDCf7qHtC7tQ/DT
PrNcPKklDOcnbfyk0NmP4E+4xNN75DiCv++z2s///xF8AP7L+hA=
                "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 4.}, {-1., 2.5}},
              "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 4.}, {-1., 2.5}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQPbcuic0wpdqOAQw+2LPffqT+Vn6lPYy/8NT8wtfy
O+H8des7b+fonYLz0+0vznxTdBnOz3uq+XjLuptwPpdii/p9iwdwfp/Aaa2F
CY/h/KTbIfuZzzyD8wuPtiTlq7+C8zcW8ARLeL5FuKc6+5VB+Ac4v2n+n8Av
bz7C+QyXHzjsqfoM56uVpFWEaH2F8598nR7GvfcbnO/1NKt2UuEPON/vyQRt
OblfcP6rw0kNJ9b+hvP1BK/JOsf/RfjP/mvinc//4Hz3t1HflUIZHGD8G4dS
GKN0GOH8rR1H4hS+IvhprKUPzp1jgvOTi6q38sxihvP107XP+SSywPnnhXS4
Sy1Z4fzd65pm6zCzwfnVjFoBZ+4i+Fx3qjzytrDD+U+XKU6ZX8MB50/RkGTZ
GcoJ50+YlXY8UYELzo+aEnuO5zmC/8Nl6c/5+7jh/MdPnSoOtfPA+YtsDaXP
JvLC+WtbSwXTdfng/PbQZG/mrwi+6Z2FK9vP8sP5MzRnrz3rLQDn1x/oneG9
E8H3lQ5dekpFEM53zDseLdiJ4M+XSVI58xXBVzm8fJpftBDCf7qHtC7tQ/DT
PrNcPKklDOcnbfyk0NmP4E+4xNN75DiCv++z2s///xF8AP7L+hA=
            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 4.}, {-1., 2.5}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {180, 216}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    Axes -> {True, True}, AxesLabel -> {
      FormBox[
       TagBox[
        TagBox["t", HoldForm], HoldForm], TraditionalForm], 
      FormBox[
       TagBox[
        RowBox[{"f", "(", 
          TagBox["t", HoldForm], ")"}], HoldForm], TraditionalForm]}, 
    AxesOrigin -> {0, 0}, AxesStyle -> Directive[12], DisplayFunction -> 
    Identity, Frame -> {{False, False}, {False, False}}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> Small, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, PlotRange -> {{-1., 4.}, {-1., 2.5}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
    Ticks -> {{}, {}}], 
   GraphicsBox[{
     Opacity[0], 
     LineBox[{{0, 0}, {1, 0}}]}, ImageSize -> 50], 
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           LineBox[CompressedData["
1:eJwdkH881PcDx51DEgufffuO6kKayMRKUvF6U0vSJLlEU7kKw5RKEq225EfN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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]], 
               Line[CompressedData["
1:eJwdkH881PcDx51DEgufffuO6kKayMRKUvF6U0vSJLlEU7kKw5RKEq225EfN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                "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 4.}, {-1., 2.5}},
              "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                RGBColor[0.368417, 0.506779, 0.709798], 
                AbsoluteThickness[2]]}, 
             "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                 Identity[
                  Part[#, 1]], 
                 Identity[
                  Part[#, 2]]}& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 4.}, {-1., 2.5}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[2]]}, 
            "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                Identity[
                 Part[#, 1]], 
                Identity[
                 Part[#, 2]]}& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            Plot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]], 
           Line[CompressedData["
1:eJwdkH881PcDx51DEgufffuO6kKayMRKUvF6U0vSJLlEU7kKw5RKEq225EfN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            "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1., 4.}, {-1., 2.5}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {180, 216}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            RGBColor[0.368417, 0.506779, 0.709798], 
            AbsoluteThickness[2]]}, 
         "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
             Identity[
              Part[#, 1]], 
             Identity[
              Part[#, 2]]}& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    Axes -> {True, True}, AxesLabel -> {
      FormBox[
       TagBox[
        TagBox["s", HoldForm], HoldForm], TraditionalForm], 
      FormBox[
       TagBox[
        RowBox[{"F", "(", 
          TagBox["s", HoldForm], ")"}], HoldForm], TraditionalForm]}, 
    AxesOrigin -> {0, 0}, AxesStyle -> Directive[12], DisplayFunction -> 
    Identity, Frame -> {{False, False}, {False, False}}, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> Small, 
    Method -> {
     "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Identity[#]& )[
           Part[#, 1]], 
          (Identity[#]& )[
           Part[#, 2]]}& )}}, PlotRange -> {{-1., 4.}, {-1., 2.5}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
    Ticks -> {{}, {}}]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->667829092,ExpressionUUID->"dc2ee8a7-f556-4ab5-b969-e7cff4f181a5"]
}, {2}]],

Cell[TextData[{
 "However, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5d8934b9-4bb3-4604-8878-44e30d55e822"],
 " is a complex function; its plot in the complex plane is:"
}], "SolvedExampleNote",
 CellID->115253968,ExpressionUUID->"4cb00d34-9e68-440b-a844-4e3912a6ee7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "/", "s"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{
      RowBox[{"-", "5"}], "I"}], ",", 
     RowBox[{"9", "+", 
      RowBox[{"5", "I"}]}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["944", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[
    PlotRange -> {{-1, 5}, {-3, 3}, {0, 4}}, AxesStyle -> Directive[12], 
     BoxRatios -> {1, 1, 2/3}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->7725860,ExpressionUUID->"ccc8e13e-d7e5-f544-b45f-54b426891d46"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJyVnHlUz9n/x1NjG/uSJWtkGRJZQ3m/LGPJkjWZbEm2rFmnyC7r2Hcia8ae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    "], {{
      {Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJzFmGeUldXZhl3ft5bMgC0GjcZzBpAiTUCaIGgsabZoUFOMsUU0VhRb1Nhi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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroup3DBox[
        TagBox[{Polygon3DBox[CompressedData["
1:eJxNnHn8TVUXh++5R/OoWSOlIik00KCIIolCVNJAFCUpKilSqYgkpZAUhShC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           "]], 
          Polygon3DBox[{{1039, 904, 422, 1040}, {1044, 998, 452, 1045}, {1036,
            929, 983, 1037}, {1038, 983, 904, 1039}, {1049, 985, 938, 1026}, {
           1041, 422, 998, 1042}, {1046, 452, 907, 1047}, {1047, 907, 985, 
           1048}}]},
         Annotation[#, "Charting`Private`Tag$5544#1"]& ]]}, {}, 
      {GrayLevel[0.82], EdgeForm[None], 
       GraphicsGroup3DBox[{
         Polygon3DBox[{{1006, 1019, 421}, {1035, 1005, 1034}, {1028, 421, 
          1022}, {1006, 960, 928}, {1031, 932, 1025}, {1050, 451, 1030}, {
          1006, 1007, 933}, {960, 1005, 928}, {1007, 1006, 928}, {995, 1007, 
          928}, {1025, 932, 1023}, {960, 1006, 421}, {995, 932, 451}, {1015, 
          995, 451}, {1019, 1006, 933}, {1021, 960, 1027}, {1027, 960, 
          1029}, {995, 1015, 933}, {1024, 999, 1033}, {932, 995, 928}, {1007, 
          995, 933}, {999, 932, 928}}], 
         Polygon3DBox[{{1032, 928, 1005, 1035}, {1030, 451, 932, 1031}, {1029,
           960, 421, 1028}, {1033, 999, 928, 1032}, {1023, 932, 999, 1024}, {
          1034, 1005, 960, 1021}}]}]}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0jlPVGEUBuBPxg2cFWZDRgkt4h9A7BU6KpTOAnADZZlFUVEI/oFRIFQk
VHaChoSgBaU2qH9AeyOCYLRRnxuLJ++5ybn3W87tuDbWP3okhLDIYSyEqP4q
67SrLzJIjQVe84k9UprP08eS/utyWT6VKzJ+NIQESVKkydBMC1ly5ClQpJUG
Xnj/i++8lH/lhjzTEMIFrlDhGet8YJeEnnNcZpNfDPODd4xEe+QGN7nFbUYZ
4w53GWeCSaYoU6FKjXvcZ5oHPOQRMzzmCbNs8Zs5DnjPEJfojO6Hb/a9wxp1
ygzQTYk/zv6ZbVaZZ4Reukjy3Sw+8ornVLlKT/RsjZ+cVe/Lt9E9qku0cZpW
ihTIkyNLC81kSEfzJkmCOKdoopGTnOA4xzDCYKngCOFN7P+/9Q/QNEBY
       "]], 
      Line3DBox[{1022, 421, 1019, 933, 1015, 451, 1050, 1030, 1031, 1025, 
       1023, 1024, 1033, 1032, 1035, 1034, 1021, 1027, 1029, 1028, 1022}]}},
    VertexNormals->CompressedData["
1:eJx8vHc81v37Pl4pMlK0iFJIQyrSkDgz0hAhRVqShGRmZO+9995bkRGRelLS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     "],
    VertexTextureCoordinates->CompressedData["
1:eJyF231sVfUZwPHGgEOzbNSpwzqNjigixqkBhw680WAVo2G+ZCPRZIPJnNsc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     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->Directive[12],
  BoxRatios->NCache[{1, 1, 
     Rational[2, 3]}, {1, 1, 0.6666666666666666}],
  DisplayFunction->Identity,
  FaceGrids->None,
  ImageSize->Small,
  ImageSizeRaw->Automatic,
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-1., 5.}, {-3., 3.}, {0., 4.}},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-0.07062380998484859, -3.3155716580405845`, 0.6723071157300273},
  
  ViewVertical->{0.004231157461782598, 0.19863988878542138`, 
   0.9800634121779311}]], "SolvedExampleOutput",
 CellID->998364246,ExpressionUUID->"0823d715-16ea-4c49-9016-bb12ae5c0fab"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"d9a04fc4-994b-496d-86c3-29abe403d4fe"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->460022107,ExpressionUUID->"a9538d2a-71e1-46ae-8b0f-1eba607ef44a"],

Cell[TextData[{
 "Calculate the Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", "\[InvisibleSpace]", "t"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"ce28120d-e6d8-468e-9fd4-c1eb1001f1d4"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Element]", "\[DoubleStruckCapitalC]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"c223b4fa-fa49-483d-b870-85266a835b72"],
 " is a constant."
}], "SolvedExampleNote",
 CellID->1337174875,ExpressionUUID->"4a7b79d9-24c1-4050-a4ba-3a2260f0aa68"],

Cell["From the definition,", "SolvedExampleNote",
 CellID->493876631,ExpressionUUID->"63209ab2-7512-44e1-b631-5caf36dabfe0"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"\[VeryThinSpace]", "0"}], "\[Infinity]"], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "s"}], "\[InvisibleSpace]", "t"}]], 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"a", "\[InvisibleSpace]", "t"}]], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
     FractionBox["1", 
      RowBox[{"s", "-", "a"}]]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c1a0a48c-13ca-4d5b-9cd3-4114feeb3559"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "(", 
     RowBox[{"s", "-", "a"}], ")"}], ">", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2a0f1d10-f934-4d5b-bee2-ee7ebd36ba4e"],
 "."
}], "SolvedExampleNote",
 CellID->336180965,ExpressionUUID->"c9fa0824-ab3f-4f15-8a4a-55e9904af6b2"],

Cell[TextData[{
 "Check with ",
 ButtonBox["LaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->390900230,ExpressionUUID->"d7adeb04-a346-4641-8215-33859e7a50ad"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"a", " ", "t"}], "]"}], ",", "t", ",", "s", ",", 
   RowBox[{"GenerateConditions", "->", "True"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->184876379,ExpressionUUID->"4b5010d4-5125-49f2-8137-1fc897533376"],

Cell[BoxData[
 TemplateBox[{
   FractionBox["1", 
    RowBox[{
      RowBox[{"-", "a"}], "+", "s"}]], 
   RowBox[{
     RowBox[{"Re", "[", "a", "]"}], "<", 
     RowBox[{"Re", "[", "s", "]"}]}]},
  "ConditionalExpression"]], "SolvedExampleOutput",
 CellID->104982529,ExpressionUUID->"8a664607-3ae9-423f-a669-e31ac0b51e5a"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1806916060,ExpressionUUID->"d1a9237c-ad89-4035-89cf-7d79a0a00bbf"],

Cell[CellGroupData[{

Cell["Basic Properties", "Subsubsection",
 CellID->523232412,ExpressionUUID->"94eba930-fafd-4638-8416-01283333dc25"],

Cell["The Laplace transform satisfies:", "Text",
 CellID->14146692,ExpressionUUID->"6ebcc027-deaf-40a9-9921-f45cb78b122a"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[ScriptCapitalL]", "[", 
     RowBox[{
      RowBox[{"a", " ", "f", 
       RowBox[{"(", "t", ")"}]}], "+", 
      RowBox[{"b", " ", "g", 
       RowBox[{"(", "t", ")"}]}]}], "]"}], 
    RowBox[{"(", "s", ")"}]}], "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"\[ScriptCapitalL]", "[", 
      RowBox[{"f", 
       RowBox[{"(", "t", ")"}]}], "]"}], 
     RowBox[{"(", "s", ")"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"\[ScriptCapitalL]", "[", 
      RowBox[{"g", 
       RowBox[{"(", "t", ")"}]}], "]"}], 
     RowBox[{
      RowBox[{"(", "s", ")"}], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->33410458,ExpressionUUID->"4b7b8b4f-5ae7-4894-95cc-44aabb948017"],

Cell["\<\
This property is a consequence of the linearity of the integral.\
\>", "Text",
 CellID->11885026,ExpressionUUID->"fe545731-b82d-490f-a823-efe3fad9e1c3"],

Cell[TextData[{
 "Not all functions have a Laplace transform. To be more precise, a function \
is said to have exponential order ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d92e3770-b0bf-4f45-96c1-e3d6724d1f52"],
 " if there exist ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e86c2e64-a08c-4620-8265-ba6de2248d9c"],
 " and ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6cbaaac1-fb99-492a-80f3-879c4ff1cbc2"],
 " such that"
}], "Text",
 CellID->42789449,ExpressionUUID->"3b027c88-3249-48d9-a6e6-7f68a91c1931"],

Cell[BoxData[
 FormBox[
  RowBox[{"|", 
   RowBox[{"f", "(", "t", ")"}], "|", 
   RowBox[{"<=", 
    RowBox[{"M", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[Alpha]", " ", "t"}]], "    ", "for", " ", "all", " ", "t"}], 
    ">=", 
    RowBox[{
     SubscriptBox["t", "0"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->461527324,ExpressionUUID->"89181e0c-418d-47c5-a924-61712bf74cbe"],

Cell[TextData[{
 "For example, the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d3fa67eb-ebda-4757-95a4-840625c6c1d4"],
 " of Example 28.1 has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a676100d-d2bd-44fd-8d91-5ebea02c6bd9"],
 ", and the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", " ", "t"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"578db9f3-86de-41fc-977f-92885948cbcb"],
 " of Example 28.2 has exponential order ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "79e3bb5a-a6eb-43bc-ac45-14a9974c6bea"],
 "."
}], "Text",
 CellID->665468202,ExpressionUUID->"ef9555b8-8a74-4dc0-a748-fc1a543629e5"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"81777887-da9a-49e2-b297-ac7920c5cfae"],
 " is piecewise continuous and has exponential order ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9cf0c8f3-801d-476e-ae58-58d4fe75a4a5"],
 ", then its Laplace transform exists for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "(", "s", ")"}], ">", "\[Alpha]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2e1499a8-2fc5-45ca-9095-d07ce52bd791"],
 "."
}], "Text",
 CellID->4366998,ExpressionUUID->"8cfdb925-c2ec-4e1c-b616-91ac14aec6c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"s", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3.8", ",", "3.6"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4", ",", "3.4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3.6", ",", "3.4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3.6", ",", "3.8"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Thin", ",", "Dashed", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "4"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0.03", "]"}], ",", "Blue", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0.04", "]"}], ",", "Red", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", 
            RowBox[{"-", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "4"}], "}"}]}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Alpha]\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<convergent\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2.6", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<divergent\>\"", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.8"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
     "}"}], ",", 
    RowBox[{"Axes", "->", "True"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "s", "]"}], ",", 
       RowBox[{"Im", "[", "s", "]"}]}], "}"}]}], ",", 
    RowBox[{"Ticks", "->", "None"}], ",", 
    RowBox[{"AxesStyle", "->", 
     RowBox[{"Directive", "[", "12", "]"}]}], ",", 
    RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{
    "#", ",", "\"\<Fig. 1. Regions of convergence and divergence of the \
Laplace transform. The red point illustrates that its rightmost singularity \
lies on the vertical line separating the two regions.\>\""}], "]"}], 
   "&"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->545674920,ExpressionUUID->"74eedb66-b87b-4fbb-87fb-20de8c65f0c3"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     InsetBox[
      FormBox[
       StyleBox["s", 12, StripOnInput -> False], TraditionalForm], {3.8, 
      3.6}], {
      Thickness[0.003], 
      LineBox[{{4, 3.4}, {3.6, 3.4}, {3.6, 3.8}}]}, {
      Thickness[Tiny], 
      Dashing[{Small, Small}], 
      LineBox[{{1, -2}, {1, 4}}]}, {
      Opacity[0.03], 
      RGBColor[0, 0, 1], 
      RectangleBox[{1, -2}, {4, 4}]}, {
      Opacity[0.04], 
      RGBColor[1, 0, 0], 
      RectangleBox[{-3, -2}, {1, 4}]}, {
      RGBColor[1, 0, 0], 
      PointSize[Medium], 
      PointBox[
       NCache[{1, 
         Rational[3, 2]}, {1, 1.5}]]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Alpha]\"", 12, StripOnInput -> False], 
       TraditionalForm], {1, 0}, 
      ImageScaled[{0, 1}]], 
     InsetBox[
      FormBox[
       StyleBox["\"convergent\"", 12, StripOnInput -> False], 
       TraditionalForm], {2.6, 2}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]], 
     InsetBox[
      FormBox[
       StyleBox["\"divergent\"", 12, StripOnInput -> False], 
       TraditionalForm], {-1.8, 2}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]]}, Axes -> True, 
    PlotRange -> {{-3, 4}, {-2, 4}}, AxesLabel -> {
      FormBox[
       RowBox[{"Re", "(", "s", ")"}], TraditionalForm], 
      FormBox[
       RowBox[{"Im", "(", "s", ")"}], TraditionalForm]}, Ticks -> None, 
    AxesStyle -> Directive[12], AspectRatio -> Automatic], 
   "\"Fig. 1. Regions of convergence and divergence of the Laplace transform. \
The red point illustrates that its rightmost singularity lies on the vertical \
line separating the two regions.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->1996551769,ExpressionUUID->"d2b40fe7-6727-499e-9c41-33bcca87d3e9"]
}, {2}]],

Cell["Additionally, if the Laplace transform exists, it satisfies", "Text",
 CellID->178058459,ExpressionUUID->"34b4546c-662f-415d-b40c-f9708b482c22"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[ScriptCapitalL]", "[", 
     RowBox[{"f", "(", "t", ")"}], "]"}], 
    RowBox[{"(", "s", ")"}]}], "\[Rule]", 
   RowBox[{
    RowBox[{"0", "    ", "as", " ", 
     RowBox[{"Re", "(", "s", ")"}]}], "->", 
    RowBox[{"\[Infinity]", "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->207213420,ExpressionUUID->"e27c837a-75d9-4cda-a2ea-38c47e80b680"],

Cell["\<\
In Table 1, some common examples of Laplace transforms can be found.\
\>", "Text",
 CellID->89869648,ExpressionUUID->"c502ea05-9c7d-41dd-999f-fb4897c344a3"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    TagBox[
     GridBox[{{
        TagBox[
        "\"\\!\\(\\*FormBox[RowBox[{\\\"f\\\", \\\"(\\\", \\\"t\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", HoldForm], 
        TagBox[
        "\"\\!\\(\\*FormBox[RowBox[{\\\"F\\\", \\\"(\\\", \\\"s\\\", \
\\\")\\\"}], \
TraditionalForm]\\)=\[ScriptCapitalL][\\!\\(\\*FormBox[RowBox[{\\\"f\\\", \
\\\"(\\\", \\\"t\\\", \\\")\\\"}], \
TraditionalForm]\\)](\\!\\(\\*FormBox[\\\"s\\\", TraditionalForm]\\))\"", 
         HoldForm]}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{SuperscriptBox[\\\"t\\\", RowBox[{\\\"n\\\", \
\\\"-\\\", \\\"1\\\"}]], \\\"/\\\", RowBox[{RowBox[{\\\"(\\\", \
RowBox[{\\\"n\\\", \\\"-\\\", \\\"1\\\"}], \\\")\\\"}], \\\"!\\\"}]}], \
TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[SuperscriptBox[\\\"t\\\", \
RowBox[List[\\\"n\\\", \\\"-\\\", \\\"1\\\"]]], \\\"/\\\", \
RowBox[List[RowBox[List[\\\"(\\\", RowBox[List[\\\"n\\\", \\\"-\\\", \
\\\"1\\\"]], \\\")\\\"]], \\\"!\\\"]]]], TraditionalForm]]]]]], \
TraditionalForm]\\)   for \\!\\(\\*FormBox[\\\"n\\\", \
TraditionalForm]\\)=1,2,3,\[Ellipsis]\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"1\\\", \\\"/\\\", SuperscriptBox[\\\"s\\\", \\\"n\
\\\"]}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"1\\\", \\\"/\\\", \
SuperscriptBox[\\\"s\\\", \\\"n\\\"]]], TraditionalForm]]]]]], \
TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{\\\"a\\\", \\\
\" \\\", \\\"t\\\"}]], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[SuperscriptBox[\\\"\\\\[ExponentialE]\\\
\", RowBox[List[\\\"a\\\", \\\" \\\", \\\"t\\\"]]], TraditionalForm]]]]]], \
TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"1\\\", \\\"/\\\", RowBox[{\\\"(\\\", \
RowBox[{\\\"s\\\", \\\"-\\\", \\\"a\\\"}], \\\")\\\"}]}], TraditionalForm]]], \
TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"1\\\", \\\"/\\\", \
RowBox[List[\\\"(\\\", RowBox[List[\\\"s\\\", \\\"-\\\", \\\"a\\\"]], \\\")\\\
\"]]]], TraditionalForm]]]]]], TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{RowBox[{SuperscriptBox[\\\"t\\\", RowBox[{\\\"v\\\", \
\\\"-\\\", \\\"1\\\"}]], \\\"/\\\", RowBox[{\\\"\[CapitalGamma]\\\", \
\\\"(\\\", \\\"v\\\", \\\")\\\"}]}], \\\",\\\", \\\"  \\\", \
RowBox[{\\\"v\\\", \\\">\\\", \\\"0\\\"}]}], TraditionalForm]]], \
TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[RowBox[List[SuperscriptBox[\
\\\"t\\\", RowBox[List[\\\"v\\\", \\\"-\\\", \\\"1\\\"]]], \\\"/\\\", \
RowBox[List[\\\"\\\\[CapitalGamma]\\\", \\\"(\\\", \\\"v\\\", \\\")\\\"]]]], \
\\\",\\\", \\\"  \\\", RowBox[List[\\\"v\\\", \\\">\\\", \\\"0\\\"]]]], \
TraditionalForm]]]]]], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"1\\\", \\\"/\\\", SuperscriptBox[\\\"s\\\", \\\"v\
\\\"]}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"1\\\", \\\"/\\\", \
SuperscriptBox[\\\"s\\\", \\\"v\\\"]]], TraditionalForm]]]]]], \
TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[RowBox[{\\\"log\\\", \\\"(\\\", \\\"t\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{RowBox[{\\\"-\\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{\\\"log\\\", \\\"(\\\", \\\"s\\\", \\\")\\\"}], \\\"+\\\", \
SubscriptBox[\\\"\[Gamma]\\\", \\\"E\\\"]}], \\\")\\\"}]}], \\\"/\\\", \
\\\"s\\\"}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[RowBox[List[\\\"-\\\", \
RowBox[List[\\\"(\\\", RowBox[List[RowBox[List[\\\"log\\\", \\\"(\\\", \
\\\"s\\\", \\\")\\\"]], \\\"+\\\", SubscriptBox[\\\"\\\\[Gamma]\\\", \
\\\"E\\\"]]], \\\")\\\"]]]], \\\"/\\\", \\\"s\\\"]], TraditionalForm]]]]]], \
TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"sin\\\", \\\"(\\\", RowBox[{\\\"a\\\", \\\" \\\", \
\\\"t\\\"}], \\\")\\\"}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"sin\\\", \\\"(\\\", \
RowBox[List[\\\"a\\\", \\\" \\\", \\\"t\\\"]], \\\")\\\"]], \
TraditionalForm]]]]]], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"a\\\", \\\"/\\\", RowBox[{\\\"(\\\", \
RowBox[{SuperscriptBox[\\\"s\\\", \\\"2\\\"], \\\"+\\\", SuperscriptBox[\\\"a\
\\\", \\\"2\\\"]}], \\\")\\\"}]}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"a\\\", \\\"/\\\", \
RowBox[List[\\\"(\\\", RowBox[List[SuperscriptBox[\\\"s\\\", \\\"2\\\"], \
\\\"+\\\", SuperscriptBox[\\\"a\\\", \\\"2\\\"]]], \\\")\\\"]]]], \
TraditionalForm]]]]]], TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"cos\\\", \\\"(\\\", RowBox[{\\\"a\\\", \\\" \\\", \
\\\"t\\\"}], \\\")\\\"}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"cos\\\", \\\"(\\\", \
RowBox[List[\\\"a\\\", \\\" \\\", \\\"t\\\"]], \\\")\\\"]], \
TraditionalForm]]]]]], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{\\\"s\\\", \\\"/\\\", RowBox[{\\\"(\\\", \
RowBox[{SuperscriptBox[\\\"s\\\", \\\"2\\\"], \\\"+\\\", SuperscriptBox[\\\"a\
\\\", \\\"2\\\"]}], \\\")\\\"}]}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[\\\"s\\\", \\\"/\\\", \
RowBox[List[\\\"(\\\", RowBox[List[SuperscriptBox[\\\"s\\\", \\\"2\\\"], \
\\\"+\\\", SuperscriptBox[\\\"a\\\", \\\"2\\\"]]], \\\")\\\"]]]], \
TraditionalForm]]]]]], TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{\\\"a\
\\\", \\\" \\\", \\\"t\\\"}]], RowBox[{\\\"f\\\", \\\"(\\\", \\\"t\\\", \\\")\
\\\"}]}], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[SuperscriptBox[\\\"\\\\[\
ExponentialE]\\\", RowBox[List[\\\"a\\\", \\\" \\\", \\\"t\\\"]]], \
RowBox[List[\\\"f\\\", \\\"(\\\", \\\"t\\\", \\\")\\\"]]]], \
TraditionalForm]]]]]], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[RowBox[{\\\"F\\\", \\\"(\\\", RowBox[{\\\"s\\\", \
\\\"-\\\", \\\"a\\\"}], \\\")\\\"}], TraditionalForm]\\) for \
\\!\\(\\*FormBox[RowBox[{\\\"a\\\", \\\"\[Element]\\\", TemplateBox[List[], \
\\\"Reals\\\"]}], TraditionalForm]\\), \
\\!\\(\\*FormBox[RowBox[{RowBox[{\\\"Re\\\", \\\"(\\\", \\\"s\\\", \
\\\")\\\"}], \\\">\\\", \\\"a\\\"}], TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[RowBox[{RowBox[{\\\"\[Theta]\\\", \\\"(\\\", \
RowBox[{\\\"t\\\", \\\"-\\\", \\\"a\\\"}], \\\")\\\"}], RowBox[{\\\"f\\\", \\\
\"(\\\", RowBox[{\\\"t\\\", \\\"-\\\", \\\"a\\\"}], \\\")\\\"}]}], \
TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[RowBox[List[RowBox[List[\\\"\\\\[Theta]\
\\\", \\\"(\\\", RowBox[List[\\\"t\\\", \\\"-\\\", \\\"a\\\"]], \\\")\\\"]], \
RowBox[List[\\\"f\\\", \\\"(\\\", RowBox[List[\\\"t\\\", \\\"-\\\", \
\\\"a\\\"]], \\\")\\\"]]]], TraditionalForm]]]]]], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[\
BoxData[FormBox[SuperscriptBox[\\\"\[ExponentialE]\\\", RowBox[{RowBox[{\\\"-\
\\\", \\\"a\\\"}], \\\" \\\", \\\"s\\\"}]], TraditionalForm]]], \
TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[SuperscriptBox[\\\"\\\\[ExponentialE]\\\
\", RowBox[List[RowBox[List[\\\"-\\\", \\\"a\\\"]], \\\" \\\", \\\"s\\\"]]], \
TraditionalForm]]]]]], TraditionalForm]\\)\\!\\(\\*FormBox[RowBox[{\\\"F\\\", \
\\\"(\\\", \\\"s\\\", \\\")\\\"}], TraditionalForm]\\) for \
\\!\\(\\*FormBox[RowBox[{\\\"a\\\", \\\"\[GreaterEqual]\\\", \\\"0\\\"}], \
TraditionalForm]\\)\""}}, RowSpacings -> 1, ColumnSpacings -> 3, 
      RowAlignments -> Baseline, ColumnAlignments -> Left, 
      GridBoxDividers -> {
       "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}}, 
      ColumnAlignments -> Left], {None, OutputFormsDump`HeadedColumns}], 
    Function[BoxForm`e$, 
     TableForm[
     BoxForm`e$, 
      TableHeadings -> {
       None, {"\!\(\*FormBox[RowBox[{\"f\", \"(\", \"t\", \")\"}], \
TraditionalForm]\)", 
         "\!\(\*FormBox[RowBox[{\"F\", \"(\", \"s\", \")\"}], \
TraditionalForm]\)=\[ScriptCapitalL][\!\(\*FormBox[RowBox[{\"f\", \"(\", \
\"t\", \")\"}], TraditionalForm]\)](\!\(\*FormBox[\"s\", \
TraditionalForm]\))"}}]]], 
   "\"Table 1. The Laplace transform of some functions.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->8756414,ExpressionUUID->"59d3a7d3-1b46-448b-ac09-ed431d02e43d"],

Cell[TextData[{
 "The last two lines in Table 1 are referred to as translation theorems, and \
the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c16cf2be-bd40-401e-b5bd-9f12d2c0354b"],
 " is the Heaviside theta function"
}], "Text",
 CellID->49755625,ExpressionUUID->"945fbedc-b897-45e0-bc61-c4eaf5654389"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Theta]", "(", "t", ")"}], "=", 
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {"1", 
          RowBox[{
           RowBox[{
            RowBox[{"if", " ", "t"}], ">=", "0"}], ","}]},
         {"0", 
          RowBox[{
           RowBox[{"if", " ", "t"}], "<", "0."}]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->50408794,ExpressionUUID->"ac834879-e91a-4d1d-9a14-617e50b6906b"],

Cell["\<\
Wolfram Language can automatically use the first of the two theorems: \
\>", "Text",
 CellID->297339089,ExpressionUUID->"6fabea38-1641-4fe4-9a65-e3ebcd593875"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"a", " ", "t"}], "]"}], 
    RowBox[{"f", "[", "t", "]"}]}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellID->21392940,ExpressionUUID->"750c1442-4b3d-42bb-8867-ad1530f76c45"],

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", "t", ",", 
   RowBox[{
    RowBox[{"-", "a"}], "+", "s"}]}], "]"}]], "Output",
 CellID->160726252,ExpressionUUID->"ee9ab0d8-45e2-4084-949a-aae1cb2cd4f7"]
}, Open  ]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->78658241,ExpressionUUID->"ce494679-1e0e-43a1-931c-81d61f72aa80"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalL]", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "(", 
       RowBox[{"t", "-", "1"}], ")"}], "\[CenterDot]", 
      SuperscriptBox["t", "2"]}], "]"}], 
    RowBox[{"(", "s", ")"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e0e95f9e-8561-4aee-ab40-99fce61df5ae"],
 "."
}], "SolvedExampleNote",
 CellID->92739498,ExpressionUUID->"7d563f92-4bcc-49f9-9708-bd30cdba258a"],

Cell["Using the properties in Table 1:", "SolvedExampleNote",
 CellID->618228798,ExpressionUUID->"f4b0ce50-96a8-428c-846d-2f58e3d74d5e"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[ScriptCapitalL]", "[", 
     RowBox[{
      RowBox[{"\[Theta]", "(", 
       RowBox[{"t", "-", "1"}], ")"}], "\[CenterDot]", 
      SuperscriptBox["t", "2"]}], "]"}], 
    RowBox[{"(", "s", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "s"}]], 
     RowBox[{"\[ScriptCapitalL]", "[", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"t", "+", "1"}], ")"}], "2"], "]"}], 
     RowBox[{"(", "s", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "s"}]], "(", 
      RowBox[{
       FractionBox["2", 
        SuperscriptBox["s", "2"]], "+", 
       FractionBox["2", "s"], "+", 
       FractionBox["1", "s"]}], ")"}], "."}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"2884375c-553f-4124-8170-5d2aa4649557"]], \
"SolvedExampleNote",
 CellID->298659010,ExpressionUUID->"67b55b6f-ed88-4bd8-8c6c-46e2c1c3f0be"],

Cell["Confirm with Wolfram Language:", "SolvedExampleNote",
 CellID->45421807,ExpressionUUID->"4302a71e-8f85-4db7-b0c0-701b7565d822"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HeavisideTheta", "[", 
     RowBox[{"t", "-", "1"}], "]"}], "*", 
    RowBox[{"t", "^", "2"}]}], ",", "t", ",", "s"}], 
  "]"}]], "SolvedExampleInput",
 CellID->8873858,ExpressionUUID->"7e257f18-c747-433c-bb57-8a7b2678df27"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "s"}]], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", "s"}], "+", 
     SuperscriptBox["s", "2"]}], ")"}]}], 
  SuperscriptBox["s", "3"]]], "SolvedExampleOutput",
 CellID->192229859,ExpressionUUID->"3a3ecf54-a007-45e9-bd60-03d25cb6380f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1995350052,ExpressionUUID->"513e3f8b-a985-4b5e-81bf-31ee48e51ed4"],

Cell[TextData[{
 "Two more properties, listed here without proof, concern the differentiation \
and the integration of the Laplace transform: if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"eecb1866-e477-46fe-a94d-6fd67187505c"],
 " has exponential order ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b3c09378-519f-4fea-8746-f83e2be1749a"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bbd9ff1b-d8f0-4c17-8040-a6403c7df8a9"],
 " is its Laplace transform, then"
}], "Text",
 CellID->510790180,ExpressionUUID->"38022c4e-3c1c-4eb7-8ad1-8373492c1d26"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["d", "n"], 
      RowBox[{"d", " ", 
       SuperscriptBox["s", "n"]}]], 
     RowBox[{"F", "(", "s", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], 
        SuperscriptBox["t", 
         RowBox[{"\[VeryThinSpace]", "n"}]], 
        RowBox[{"f", "(", "t", ")"}]}], "]"}], 
      RowBox[{"(", "s", ")"}], "   ", "for", " ", "n"}], "=", "1"}]}], ",", 
   "2", ",", "3", ",", 
   RowBox[{
    RowBox[{"\[Ellipsis]", " ", "and", " ", "s"}], ">=", "\[Alpha]"}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->17982628,ExpressionUUID->"465a7a43-fa35-492b-ac13-df7c40733716"],

Cell["which you can check with Wolfram Language:", "Text",
 CellID->252935255,ExpressionUUID->"c1a1930b-ee4c-41eb-914b-aff6fcbf3426"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "n"}], "*", 
    RowBox[{"t", "^", "n"}], " ", 
    RowBox[{"f", "[", "t", "]"}]}], ",", "t", ",", "s", ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"n", "\[Element]", "PositiveIntegers"}]}]}], "]"}]], "Input",
 CellID->222434729,ExpressionUUID->"c96c62c6-6790-4fa8-88c8-251c402e6caa"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"2", " ", "n"}]], " ", 
  RowBox[{
   SuperscriptBox["LaplaceTransform", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"0", ",", "0", ",", "n", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s", ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{
      RowBox[{"n", "\[Element]", 
       TemplateBox[{},
        "Integers"]}], "&&", 
      RowBox[{"n", ">", "0"}]}]}]}], "]"}]}]], "Output",
 CellID->371378360,ExpressionUUID->"3740665b-4b86-4238-85ab-91f8fdbc6cbe"]
}, Open  ]],

Cell[TextData[{
 "Another property concerning derivatives is the following: for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d29e08ad-6acf-41da-8851-1ecd323da843"],
 " continuous in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", "\[Infinity]"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1bb2b3db-12d9-4aa8-b840-d0dc179dfd58"],
 " and of exponential order ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e0ed11c8-6e9c-449a-99b3-f84579c77617"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "'"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ad2f4f1c-8f06-4948-b595-267c53cdee7a"],
 " piecewise continuous in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{"0", ",", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2ea21d37-5cc7-466c-9d88-08852c4eedb0"],
 ", then"
}], "Text",
 CellID->254620036,ExpressionUUID->"9bc605b6-36c5-4b59-b03d-7e17fd376279"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", 
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "t", ")"}]}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"s", "\[CenterDot]", 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{"f", "(", "t", ")"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"f", "(", 
       SuperscriptBox["0", "+"], ")"}], "   ", "for", " ", 
      RowBox[{"Re", "(", "s", ")"}]}]}], ">=", 
    RowBox[{"\[Alpha]", "."}]}]}], TraditionalForm]], "DisplayFormulaNumbered",\

 CellID->67794458,ExpressionUUID->"dd2f91df-0058-401a-b26a-6fe686ebf759"],

Cell["In Wolfram Language:", "Text",
 CellID->108768924,ExpressionUUID->"f476fe1a-c8df-4684-a0a4-cc9129c15505"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",\

 CellID->5652017,ExpressionUUID->"3d9ff970-0b9d-4a6d-86bc-8e7ad4f1fe1e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"f", "[", "0", "]"}]}], "+", 
  RowBox[{"s", " ", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}]}]], "Output",\

 CellID->59494624,ExpressionUUID->"b2488db0-4994-40c9-a454-ff1854ca10fd"]
}, Open  ]],

Cell["Eq. (7) can be iterated, leading to:", "Text",
 CellID->89555827,ExpressionUUID->"aefd4c16-9a7b-411f-b359-77cb241ad142"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", 
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"(", "n", ")"}]], "(", "t", ")"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["s", 
       RowBox[{"\[VeryThinSpace]", "n"}]], 
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{"f", "(", "t", ")"}], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["s", 
       RowBox[{"\[VeryThinSpace]", 
        RowBox[{"n", "-", "1"}]}]], 
      RowBox[{"f", "(", 
       SuperscriptBox["0", "+"], ")"}]}], " ", "-", 
     RowBox[{
      SuperscriptBox["s", 
       RowBox[{"\[VeryThinSpace]", 
        RowBox[{"n", "-", "2"}]}]], 
      RowBox[{"f", "'"}], 
      RowBox[{"(", 
       SuperscriptBox["0", "+"], ")"}]}], "-", "\[Ellipsis]", "-", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]], "(", 
       SuperscriptBox["0", "+"], ")"}], "  ", "for", " ", 
      RowBox[{"Re", "(", "s", ")"}]}]}], ">=", 
    RowBox[{"\[Alpha]", "."}]}]}], TraditionalForm]], "DisplayFormulaNumbered",\

 CellID->688297651,ExpressionUUID->"474a7164-c9eb-44a8-b86d-6a300a12da8e"],

Cell["For example:", "Text",
 CellID->50420723,ExpressionUUID->"45bfe2c2-d9f3-4b99-94a0-674c113227ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "''''"}], "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellID->660130710,ExpressionUUID->"b90d2d91-54ce-4ce1-b51e-5e621ea3b1c4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["s", "3"]}], " ", 
   RowBox[{"f", "[", "0", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["s", "4"], " ", 
   RowBox[{"LaplaceTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["s", "2"], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "0", "]"}]}], "-", 
  RowBox[{"s", " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "0", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "3", ")"}],
     Derivative],
    MultilineFunction->None], "[", "0", "]"}]}]], "Output",
 CellID->119076703,ExpressionUUID->"31de369f-d3c0-4d80-a3da-558e4e009f70"]
}, Open  ]],

Cell["\<\
You will see later how Eq. (8) can be useful when solving differential \
equations.\
\>", "Text",
 CellID->165388288,ExpressionUUID->"00acb395-3cd1-41f2-85a1-d2184f7118e3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Laplace Transform", "Subsection",
 CellID->26183447,ExpressionUUID->"72f2bfe4-f2b6-4477-8780-d81a2041a595"],

Cell[TextData[{
 "The previous sections described how, from a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7c99a74b-f01e-46b1-8a7e-d5700e242cb4"],
 ", one calculates the Laplace transform ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{
     RowBox[{"\[ScriptCapitalL]", "[", 
      RowBox[{"f", "(", "t", ")"}], "]"}], 
     RowBox[{"(", "s", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bb60017f-76e6-4b51-892d-a1be851c1f0d"],
 ". This section will describe the inverse operation: given ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"947d1b28-4e85-4da7-a910-cc7a92a9a19d"],
 ", how to recover ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3051c2bc-af5d-4fca-86ec-a460d9897116"],
 ". This operation is the inverse Laplace transform and is defined by a \
contour integral."
}], "Text",
 CellID->29919128,ExpressionUUID->"7f212b76-37bb-4bee-97af-3385647ce33c"],

Cell[TextData[{
 "To be precise, the following assumes that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6affb327-a846-480e-8dbc-89c0a8f2784d"],
 " is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "<", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b82886f5-f4e7-4573-b333-9a4129e30dcd"],
 " and has exponential order ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "66893645-ba39-4734-b347-d1a108544de4"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1e664164-f59c-43d0-843a-2e56b0c4df6d"],
 " is its Laplace transform, then the inverse transform is"
}], "Text",
 CellID->125924177,ExpressionUUID->"b8e7baba-e1f4-46b5-8c35-8149163538e8"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "(", "t", ")"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ScriptCapitalL]", 
       RowBox[{"-", "1"}]], "[", 
      RowBox[{"F", "(", "s", ")"}], "]"}], 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"x", "-", "\[ImaginaryI]\[Infinity]"}], 
        RowBox[{"\[VeryThinSpace]", 
         RowBox[{"x", "+", "\[ImaginaryI]\[Infinity]"}]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"t", "\[InvisibleSpace]", "s"}]], 
        RowBox[{"F", "(", "s", ")"}], 
        RowBox[{"\[DifferentialD]", "s"}], "   ", "with", " ", "x"}]}]}], ">", 
     RowBox[{"\[Alpha]", "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->49734511,ExpressionUUID->"9272a533-4ea1-4060-90ec-5e8a24c2c21a"],

Cell[TextData[{
 "The contour in this integral, called a ",
 StyleBox["Bromwich line",
  FontSlant->"Italic"],
 ", is a vertical line lying in the region of analyticity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0e7946d4-d612-4633-b48e-4f6acc16cdb9"],
 ", as shown in Fig. 2. Notice that by the properties of the Laplace \
transform, all the singularities of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"693b8469-4e51-4b72-8653-5fe8296ac9e5"],
 ", and therefore of the integrand, lie in the half-plane to the left of ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "cec30f30-f91f-445d-aed5-2e11b945e32e"],
 "."
}], "Text",
 CellID->259248944,ExpressionUUID->"26fed254-1cc4-4430-9877-ee82b2d32faa"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{
     InsetBox[
      FormBox[
       StyleBox["s", 12, StripOnInput -> False], TraditionalForm], {4.8, 
      3.6}], {
      Thickness[0.003], 
      LineBox[{{5, 3.4}, {4.6, 3.4}, {4.6, 3.8}}]}, {
      Thickness[Tiny], 
      Dashing[{Small, Small}], 
      LineBox[{{1, -2}, {1, 4}}]}, {
      Opacity[0.03], 
      RGBColor[0, 0, 1], 
      RectangleBox[{1, -2}, {5, 4}]}, {
      Opacity[0.04], 
      RGBColor[1, 0, 0], 
      RectangleBox[{-3, -2}, {1, 4}]}, 
     InsetBox[
      FormBox[
       StyleBox["\"\[Alpha]\"", 12, StripOnInput -> False], 
       TraditionalForm], {1, 0}, 
      ImageScaled[{0, 1}]], 
     InsetBox[
      FormBox[
       StyleBox["x", 12, StripOnInput -> False], TraditionalForm], 
      NCache[{
        Rational[5, 2], 0}, {2.5, 0}], 
      NCache[
       ImageScaled[{
         Rational[-1, 4], 1}], 
       ImageScaled[{-0.25, 1}]]], 
     LineBox[
      NCache[{{
         Rational[5, 2], -1.6}, {
         Rational[5, 2], 3.6}}, {{2.5, -1.6}, {2.5, 3.6}}]], 
     ArrowBox[
      NCache[{{
         Rational[5, 2], 1}, {
         Rational[5, 2], 
         Rational[11, 10]}}, {{2.5, 1}, {2.5, 1.1}}]], {
      PointSize[Small], 
      PointBox[
       NCache[{{
          Rational[5, 2], 3.75}, {
          Rational[5, 2], 3.85}, {
          Rational[5, 2], 3.95}, {
          Rational[5, 2], -1.75}, {
          Rational[5, 2], -1.85}, {
          Rational[5, 2], -1.95}}, {{2.5, 3.75}, {2.5, 3.85}, {2.5, 3.95}, {
        2.5, -1.75}, {2.5, -1.85}, {2.5, -1.95}}]]}}, Axes -> True, 
    PlotRange -> {{-2, 5}, {-2, 4}}, AxesLabel -> {
      FormBox[
       RowBox[{"Re", "(", "s", ")"}], TraditionalForm], 
      FormBox[
       RowBox[{"Im", "(", "s", ")"}], TraditionalForm]}, Ticks -> None, 
    AxesStyle -> Directive[12], AspectRatio -> Automatic], 
   "\"Fig. 2. The Bromwich line.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->535918468,ExpressionUUID->"4f72a816-e9a6-4a2e-a038-cda5023fe71c"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cfb05a7f-7397-4c29-9f9d-60f956afa55f"],
 " is sufficiently well behaved, then the contour integral can be computed by \
closing the contour with an arc of circle large enough to contain all \
singularities, then using the residue theorem. This arc will not contribute \
to the integral, provided that for large ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "s", "|"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9c3dfebb-f2ae-4e7a-9bd8-30b6d60d1f1e"],
 ","
}], "Text",
 CellID->213093425,ExpressionUUID->"64756d16-452b-4f5f-a07c-aebc6617eeda"],

Cell[BoxData[
 FormBox[
  RowBox[{"|", 
   RowBox[{"F", "(", "s", ")"}], "|", 
   RowBox[{"<=", 
    RowBox[{
     FractionBox["M", 
      RowBox[{"|", "s", 
       SuperscriptBox["|", "p"]}]], "   ", "with", " ", "p"}], ">", "0."}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->183566527,ExpressionUUID->"0f8e0a6c-da2f-45d3-a55a-130d7342019f"],

Cell[TextData[{
 "Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4d80042a-3636-43a1-8cd2-2f89d38f6ab9"],
 " decays fast enough and the integral over the arc does not contribute to \
the integral. Another condition that can ensures this is"
}], "Text",
 CellID->615943027,ExpressionUUID->"f86ab0ff-cfe8-42ba-8fac-58b9f3c44ea4"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"|", 
    RowBox[{"F", "(", "s", ")"}], "|", 
    RowBox[{"<=", 
     RowBox[{
      RowBox[{"\[Epsilon]", "(", "R", ")"}], "      ", "with", " ", 
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"R", "->", "\[Infinity]"}]], 
       RowBox[{"\[Epsilon]", "(", "R", ")"}]}]}]}]}], "=", 
   RowBox[{
    RowBox[{"0", "   ", "and", " ", "R"}], "=", 
    RowBox[{"|", "s", "|", "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->249715280,ExpressionUUID->"ea37a135-06f9-442d-a8ee-587a234a5b4b"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->86350016,ExpressionUUID->"748d2836-707e-4276-b737-4531ef791dae"],

Cell[TextData[{
 "Compute the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"s", "-", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "3"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6a77430a-cf1c-4110-b7ea-78bad6dbadcd"],
 "."
}], "SolvedExampleNote",
 CellID->10863979,ExpressionUUID->"a34ab745-e13b-45c7-863d-cee7904a8ef1"],

Cell[TextData[{
 "The integration contour and the poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"990096c0-e89f-4e52-87b0-25f449438494"],
 " are shown here:"
}], "SolvedExampleNote",
 CellID->385270235,ExpressionUUID->"dd53ce37-a519-4c6e-b650-d6ce11a28705"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"4", "I"}]}], ",", 
      RowBox[{"5", "+", 
       RowBox[{"4", "I"}]}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"TicksStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Re", "[", "s", "]"}], ",", "12"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Im", "[", "s", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4.2", ",", 
           RowBox[{"-", "3.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.2", ",", "3.5"}], "}"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Small", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"4.2", ",", "3.7"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4.2", ",", "3.9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4.2", ",", 
             RowBox[{"-", "3.7"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"4.2", ",", 
             RowBox[{"-", "3.9"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4.2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.2", ",", "1.1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ",", 
   
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "SolvedExampleInput",
 CellID->18950043,ExpressionUUID->"cd1da699-de32-4218-85f4-94117e14afbd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
         PointBox[{{2., 0.}, {3., 0.}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      StyleBox[
       DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              Point[{{2., 0.}, {3., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> (Identity[
                 Part[#, 1]] + I Identity[
                  Part[#, 2]]& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ComplexListPlot, "GroupHighlight" -> False|>|>],
        ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}],
       Selectable->False]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[Medium]], 
          Point[{{2., 0.}, {3., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {180, 216}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[Medium]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> (Identity[
              Part[#, 1]] + I Identity[
               Part[#, 2]]& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ComplexListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox[
      RowBox[{"Re", "(", "s", ")"}], 12, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
      RowBox[{"Im", "(", "s", ")"}], 12, StripOnInput -> False], 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Epilog->{
    LineBox[{{4.2, -3.5}, {4.2, 3.5}}], {
     PointSize[Small], 
     PointBox[{{4.2, 3.7}, {4.2, 3.9}, {4.2, -3.7}, {4.2, -3.9}}]}, 
    ArrowBox[{{4.2, 1}, {4.2, 1.1}}]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "MessagesHead" -> ComplexListPlot, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& )}},
  PlotRange->{{-3., 5.}, {-4., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[12]]], "SolvedExampleOutput",
 CellID->212999953,ExpressionUUID->"0825df2b-f475-43ee-a422-43831d51045f"]
}, {2}]],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"98b4d9a5-32bb-455d-a06a-d43677225b39"],
 " decays fast enough at large ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "s", "|"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fa0b0a2f-7ea3-4edd-b6b2-47a504bf4f82"],
 ", you can close the vertical integration contour and use the residue \
theorem. So:"
}], "SolvedExampleNote",
 CellID->7570065,ExpressionUUID->"2374f95e-d4cb-4724-b0de-5f9d318d187a"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "(", "t", ")"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"s", "\[InvisibleSpace]", "t"}]], 
       RowBox[{"F", "(", "s", ")"}], 
       RowBox[{"\[DifferentialD]", "s"}]}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"s", "->", "2"}]], "[", 
       FractionBox[
        FormBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"s", " ", "t"}]],
         TraditionalForm], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s", "-", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "3"}], ")"}]}]], "]"}], "+", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"s", "->", "3"}]], "[", 
       FractionBox[
        FormBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"s", " ", "t"}]],
         TraditionalForm], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s", "-", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"s", "-", "3"}], ")"}]}]], "]"}]}], "=", 
     RowBox[{
      RowBox[{
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "t"}]], 
        RowBox[{"-", "1"}]], "+", 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"3", "t"}]], "1"]}], "=", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", "t"}]], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "t"}]], "."}]}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"3fe88816-b00b-43c1-b322-3e480588f4e9"]], \
"SolvedExampleNote",
 CellID->427237187,ExpressionUUID->"43fe8543-83d4-4900-b19a-6a6079e800ef"],

Cell[TextData[{
 "Alternatively, to solve this problem, you could have decomposed ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"270642f7-a099-4f46-ac61-3c2eeffd4b2e"],
 " into partial fractions and consulted Table 1. Check with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->26996803,ExpressionUUID->"a949fd8d-281b-4930-9184-3e3f21231d1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseLaplaceTransform", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s", "-", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"s", "-", "3"}], ")"}]}], ")"}]}], ",", "s", ",", "t"}], 
   "]"}], "//", "Expand"}]], "SolvedExampleInput",
 CellID->10375129,ExpressionUUID->"2d91986e-bcb1-47b3-a35f-9921e85e666f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "t"}]]}], "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"3", " ", "t"}]]}]], "SolvedExampleOutput",
 CellID->19368484,ExpressionUUID->"ef3d2604-6548-44be-89cd-edb55ecbc2a8"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1068519411,ExpressionUUID->"03f6f35d-78cb-418e-8eeb-dc43ff1ff6e5"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->76770863,ExpressionUUID->"8db37898-fe1d-42be-9391-8d874dc7ab76"],

Cell[TextData[{
 "Calculate the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{"log", "(", 
     FractionBox[
      RowBox[{"s", "+", "1"}], 
      RowBox[{"s", "-", "1"}]], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ced06e2e-5db6-4d52-bf43-4fe6aa12a5cd"],
 "."
}], "SolvedExampleNote",
 CellID->17179390,ExpressionUUID->"8b01ba39-db55-4b71-a090-a3943eface08"],

Cell[TextData[{
 "The inverse Laplace transform is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"s", "\[InvisibleSpace]", "t"}]], 
       RowBox[{"log", "(", 
        FractionBox[
         RowBox[{"s", "+", "1"}], 
         RowBox[{"s", "-", "1"}]], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a6c52fb6-930c-4a7a-9167-19a34088ffbe"],
 ", with ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b6ab4575-2350-4fc3-a1a8-839eec96fdd9"],
 " the vertical Bromwich line. In red, the branch cut of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7b1f5836-8b4c-4308-9ac4-b1b171af501b"],
 " is shown:"
}], "SolvedExampleNote",
 CellID->41935617,ExpressionUUID->"bfcfc4d3-fd3a-42b5-8db2-e2f635b7412a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4.2", ",", 
          RowBox[{"-", "3.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4.2", ",", "3.5"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Small", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"4.2", ",", "3.7"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4.2", ",", "3.9"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4.2", ",", 
            RowBox[{"-", "3.7"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4.2", ",", 
            RowBox[{"-", "3.9"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"C", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.8", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4.2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4.2", ",", "1.1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "s", "]"}], ",", 
      RowBox[{"Im", "[", "s", "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "SolvedExampleInput",
 CellID->102175376,ExpressionUUID->"23159786-190f-4cb7-a8ca-e79585e65d18"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], Thickness[0.02], LineBox[{{-1, 0}, {1, 0}}]}, 
   {RGBColor[1, 0, 0], PointSize[Medium], PointBox[{{-1, 0}, {1, 0}}]}, 
   LineBox[{{4.2, -3.5}, {4.2, 3.5}}], 
   {PointSize[Small], 
    PointBox[{{4.2, 3.7}, {4.2, 3.9}, {4.2, -3.7}, {4.2, -3.9}}]}, InsetBox[
    StyleBox["C",
     StripOnInput->False,
     FontSize->12], {3.8, 1}], ArrowBox[{{4.2, 1}, {4.2, 1.1}}]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "s", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "s", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  ImageSize->Small,
  PlotRange->{{-3, 5}, {-4, 4}}]], "SolvedExampleOutput",
 CellID->51213956,ExpressionUUID->"519434b6-c664-42e8-a4de-11e7f8ba35f3"]
}, {2}]],

Cell["\<\
The contour can be deformed to the \[OpenCurlyDoubleQuote]dumbbell\
\[CloseCurlyDoubleQuote] contour shown here:\
\>", "SolvedExampleNote",
 CellID->764935885,ExpressionUUID->"c38fcc09-5f6c-4731-a563-794b7c82bc64"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"4", "I"}]}], ",", 
      RowBox[{"5", "+", 
       RowBox[{"4", "I"}]}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Re", "[", "s", "]"}], ",", "12"}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"Im", "[", "s", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"TicksStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7"}], ",", "0.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.7", ",", "0.2"}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7"}], ",", 
           RowBox[{"-", "0.2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.7", ",", 
           RowBox[{"-", "0.2"}]}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "0.3", ",", 
        RowBox[{"{", 
         RowBox[{"0.6", ",", 
          RowBox[{
           RowBox[{"2", "\[Pi]"}], "-", "0.6"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", "0.3", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"\[Pi]", "-", "0.6"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", "0.3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[Pi]", "+", "0.6"}], ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"C", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "1"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", "0.2"}], "}"}]}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "SolvedExampleInput",
 CellID->4617079,ExpressionUUID->"410394ef-bbf6-438c-9229-52f29bf3457b"],

Cell[BoxData[
 GraphicsBox[{{{}, {}}, {}, {{}, 
    InterpretationBox[{
      TagBox[
       TagBox[
        {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
         PointBox[{{-1., 0.}, {1., 0.}}]},
        Annotation[#, "Charting`Private`Tag#1"]& ],
       {"WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
      StyleBox[
       DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              Point[{{-1., 0.}, {1., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
            Automatic, "DefaultStyle" -> {
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> (Identity[
                 Part[#, 1]] + I Identity[
                  Part[#, 2]]& ), 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ComplexListPlot, "GroupHighlight" -> False|>|>],
        ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}],
       Selectable->False]},
     Annotation[{{
        Annotation[{
          Directive[
           AbsoluteThickness[2], 
           RGBColor[1, 0, 0], 
           PointSize[Medium]], 
          Point[{{-1., 0.}, {1., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {180, 216}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
           Directive[
            AbsoluteThickness[2], 
            RGBColor[1, 0, 0], 
            PointSize[Medium]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> (Identity[
              Part[#, 1]] + I Identity[
               Part[#, 2]]& ), 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ComplexListPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     StyleBox[
      RowBox[{"Re", "(", "s", ")"}], 12, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
      RowBox[{"Im", "(", "s", ")"}], 12, StripOnInput -> False], 
     TraditionalForm]},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Epilog->{{
     RGBColor[1, 0, 0], 
     Thickness[0.02], 
     LineBox[{{-1, 0}, {1, 0}}]}, 
    LineBox[{{-0.7, 0.2}, {0.7, 0.2}}], 
    LineBox[{{-0.7, -0.2}, {0.7, -0.2}}], 
    CircleBox[{-1, 0}, 0.3, {0.6, 5.683185307179587}], 
    CircleBox[{1, 0}, 0.3, {0, 2.541592653589793}], 
    CircleBox[{1, 0}, 0.3, 
     NCache[{3.741592653589793, 2 Pi}, {3.741592653589793, 
      6.283185307179586}]], 
    InsetBox[
     FormBox[
      StyleBox["C", 12, StripOnInput -> False], TraditionalForm], {0.5, 1}], 
    ArrowBox[{{0, 0.2}, {-0.1, 0.2}}]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[2]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "MessagesHead" -> ComplexListPlot, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
         Part[#, 1]] + I Identity[
          Part[#, 2]]& )}},
  PlotRange->{{-3., 5.}, {-4., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic},
  TicksStyle->Directive[12]]], "SolvedExampleOutput",
 CellID->206293082,ExpressionUUID->"8677bfa0-41dd-48a6-9ef9-7a30eb0b702b"]
}, {2}]],

Cell[TextData[{
 "The integrals over the circular parts go to zero in the limit of their \
radius ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "509c6583-8368-4fbd-8f18-c42b1406c5d0"],
 ". You can use Wolfram Language to compute the integral:"
}], "SolvedExampleNote",
 CellID->114759054,ExpressionUUID->"a3881e2b-e8a2-4918-b743-0fdf7cc81e5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"s", " ", "t"}], "]"}], 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"s", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"s", "-", "1"}], ")"}]}], "]"}]}], ",", 
    RowBox[{"s", "\[Element]", 
     RowBox[{"{", 
      RowBox[{"\"\<Dumbbell\>\"", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"t", ">", "0"}]}]}], "]"}]}]], "SolvedExampleInput",
 CellID->221860726,ExpressionUUID->"49a9ebee-fb68-4490-b8fc-0f5bdba82787"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Sinh", "[", "t", "]"}]}], "t"]], "SolvedExampleOutput",
 CellID->128743741,ExpressionUUID->"0dfb0ec7-3a8a-4397-ac6c-33eba29d9aec"]
}, Open  ]],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->463033996,ExpressionUUID->"db80a6cf-5e05-460b-8ad7-a3aebe0d79e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseLaplaceTransform", "[", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"s", "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}]}], "]"}], ",", "s", ",", "t"}], "]"}], "//",
   "FullSimplify"}]], "SolvedExampleInput",
 CellID->101551085,ExpressionUUID->"8b30a688-ef10-48f2-9a10-fb33135f339b"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Sinh", "[", "t", "]"}]}], "t"]], "SolvedExampleOutput",
 CellID->568894024,ExpressionUUID->"4d9591eb-e8c7-4868-85fa-cf39d189a024"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->686072142,ExpressionUUID->"e05c550e-b047-4638-aef9-20f986de9cba"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->553058626,ExpressionUUID->"a5788392-cc46-42f7-941a-7687640ffefd"],

Cell[TextData[{
 "Calculate the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    FractionBox["1", 
     SqrtBox["s"]]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "18c3ceaf-e104-4db8-b70a-0754d928910d"],
 "."
}], "SolvedExampleNote",
 CellID->600259306,ExpressionUUID->"514480fb-5b66-46b0-9217-2645ff738fc3"],

Cell["\<\
The Bromwich line and the contour it can be deformed into are:\
\>", "SolvedExampleNote",
 CellID->327667734,ExpressionUUID->"e58a6395-3887-417e-ac18-7938ff522a5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexListPlot", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"TicksStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Re", "[", "s", "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Im", "[", "s", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
      
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
      RowBox[{"Epilog", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4.2", ",", 
              RowBox[{"-", "3.5"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4.2", ",", "3.5"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "Small", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"4.2", ",", "3.7"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4.2", ",", "3.9"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4.2", ",", 
                RowBox[{"-", "3.7"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"4.2", ",", 
                RowBox[{"-", "3.9"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"C", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3.8", ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"4.2", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"4.2", ",", "1.1"}], "}"}]}], "}"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", 
      RowBox[{"ImageSize", "->", "Small"}]}], "]"}], "\[IndentingNewLine]", ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "->", "60"}]}], "]"}], ",", "\[IndentingNewLine]", 
    
    RowBox[{"ComplexListPlot", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"TicksStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Re", "[", "s", "]"}], ",", "12"}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Im", "[", "s", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
      
      RowBox[{"PlotStyle", "->", 
       RowBox[{"{", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
      RowBox[{"Epilog", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Thickness", "[", "0.02", "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3"}], ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.3"}], ",", "0.2"}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3"}], ",", 
              RowBox[{"-", "0.2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.3"}], ",", 
              RowBox[{"-", "0.2"}]}], "}"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "0.3", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"\[Pi]", "-", "0.6"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "0.3", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"\[Pi]", "+", "0.6"}], ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"C", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0.2"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.1"}], ",", "0.2"}], "}"}]}], "}"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}]}], ",", 
      RowBox[{"ImageSize", "->", "Small"}]}], "]"}]}], "}"}], 
  "]"}]], "SolvedExampleInput",
 CellID->94344254,ExpressionUUID->"2faf0fc4-64f4-4a15-8d85-c83db012bcaa"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{}, {}}, {}, {{}, 
      InterpretationBox[{
        TagBox[
         TagBox[{
           RGBColor[1, 0, 0], 
           PointSize[Medium], 
           AbsoluteThickness[2], 
           PointBox[{{0., 0.}, {0., 0.}}]}, 
          Annotation[#, "Charting`Private`Tag#1"]& ], {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
        StyleBox[
         DynamicBox[
          (Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{
              Annotation[{
                Directive[
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0], 
                 PointSize[Medium]], 
                Point[{{0., 0.}, {0., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  AbsoluteThickness[2], 
                  RGBColor[1, 0, 0], 
                  PointSize[Medium]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ComplexListPlot, "GroupHighlight" -> 
               False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}},
               "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0], 
                 PointSize[Medium]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> (Identity[
                   Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>], 
          ImageSizeCache -> {{
           4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
         False]}, 
       Annotation[{{
          Annotation[{
            Directive[
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0], 
             PointSize[Medium]], 
            Point[{{0., 0.}, {0., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[Medium]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> (Identity[
                Part[#, 1]] + I Identity[
                 Part[#, 2]]& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ComplexListPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}}, 
    AspectRatio -> Automatic, Axes -> True, AxesLabel -> {
      FormBox[
       StyleBox[
        RowBox[{"Re", "(", "s", ")"}], 12, StripOnInput -> False], 
       TraditionalForm], 
      FormBox[
       StyleBox[
        RowBox[{"Im", "(", "s", ")"}], 12, StripOnInput -> False], 
       TraditionalForm]}, AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    Epilog -> {{
       RGBColor[1, 0, 0], 
       Thickness[0.02], 
       LineBox[{{-3, 0}, {0, 0}}]}, 
      LineBox[{{4.2, -3.5}, {4.2, 3.5}}], {
       PointSize[Small], 
       PointBox[{{4.2, 3.7}, {4.2, 3.9}, {4.2, -3.7}, {4.2, -3.9}}]}, 
      InsetBox[
       FormBox[
        StyleBox["C", 12, StripOnInput -> False], TraditionalForm], {3.8, 1}], 
      ArrowBox[{{4.2, 1}, {4.2, 1.1}}]}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> Small, 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.571589, 0.586483, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05],
       "MessagesHead" -> ComplexListPlot, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
           Part[#, 1]] + I Identity[
            Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
           Part[#, 1]] + I Identity[
            Part[#, 2]]& )}}, PlotRange -> {{-3., 5.}, {-4., 4.}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
    Ticks -> {Automatic, Automatic}, TicksStyle -> Directive[12]], 
   GraphicsBox[{
     Opacity[0], 
     LineBox[{{0, 0}, {1, 0}}]}, ImageSize -> 60], 
   GraphicsBox[{{{}, {}}, {}, {{}, 
      InterpretationBox[{
        TagBox[
         TagBox[{
           RGBColor[1, 0, 0], 
           PointSize[Medium], 
           AbsoluteThickness[2], 
           PointBox[{{0., 0.}, {0., 0.}}]}, 
          Annotation[#, "Charting`Private`Tag#1"]& ], {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
        StyleBox[
         DynamicBox[
          (Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{
              Annotation[{
                Directive[
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0], 
                 PointSize[Medium]], 
                Point[{{0., 0.}, {0., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  AbsoluteThickness[2], 
                  RGBColor[1, 0, 0], 
                  PointSize[Medium]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ComplexListPlot, "GroupHighlight" -> 
               False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}},
               "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0], 
                 PointSize[Medium]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> (Identity[
                   Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>], 
          ImageSizeCache -> {{
           4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
         False]}, 
       Annotation[{{
          Annotation[{
            Directive[
             AbsoluteThickness[2], 
             RGBColor[1, 0, 0], 
             PointSize[Medium]], 
            Point[{{0., 0.}, {0., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 5.}, {-4., 4.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {180, 216}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              AbsoluteThickness[2], 
              RGBColor[1, 0, 0], 
              PointSize[Medium]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> (Identity[
                Part[#, 1]] + I Identity[
                 Part[#, 2]]& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ComplexListPlot, "GroupHighlight" -> False|>|>, 
        "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}}, 
    AspectRatio -> Automatic, Axes -> True, AxesLabel -> {
      FormBox[
       StyleBox[
        RowBox[{"Re", "(", "s", ")"}], 12, StripOnInput -> False], 
       TraditionalForm], 
      FormBox[
       StyleBox[
        RowBox[{"Im", "(", "s", ")"}], 12, StripOnInput -> False], 
       TraditionalForm]}, AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    Epilog -> {{
       RGBColor[1, 0, 0], 
       Thickness[0.02], 
       LineBox[{{-3, 0}, {0, 0}}]}, 
      LineBox[{{-3, 0.2}, {-0.3, 0.2}}], 
      LineBox[{{-3, -0.2}, {-0.3, -0.2}}], 
      CircleBox[{0, 0}, 0.3, {0, 2.541592653589793}], 
      CircleBox[{0, 0}, 0.3, 
       NCache[{3.741592653589793, 2 Pi}, {3.741592653589793, 
        6.283185307179586}]], 
      InsetBox[
       FormBox[
        StyleBox["C", 12, StripOnInput -> False], TraditionalForm], {-1, 1}], 
      
      ArrowBox[{{-1, 0.2}, {-1.1, 0.2}}]}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLines -> {None, None}, GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> Small, 
    Method -> {
     "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
      "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
        Directive[
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.363898, 0.618501, 0.782349], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[1, 0.75, 0], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.647624, 0.37816, 0.614037], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.571589, 0.586483, 0.], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.915, 0.3325, 0.2125], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
         AbsoluteThickness[2]], 
        Directive[
         RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
         AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
      "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05],
       "MessagesHead" -> ComplexListPlot, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
           Part[#, 1]] + I Identity[
            Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
           Part[#, 1]] + I Identity[
            Part[#, 2]]& )}}, PlotRange -> {{-3., 5.}, {-4., 4.}}, 
    PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
    Ticks -> {Automatic, Automatic}, TicksStyle -> Directive[12]]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->273184104,ExpressionUUID->"d54472fe-87aa-41fd-a693-e9cd42fc6bb8"]
}, {2}]],

Cell[TextData[{
 "Once again, the tiny circle does not contribute to the integral in the \
limit of a small radius, and the remaining lines are computed using the fact \
that if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{
     RowBox[{"-", "x"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "\[Epsilon]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"264cfb69-708f-41db-9697-82f3eed02e8e"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2aea960b-429c-4a5e-b02f-4baf3a8a0494"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SqrtBox["s"], "\[TildeTilde]", 
     RowBox[{
      SqrtBox["x"], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"\[Pi]", "/", "2"}]}]]}]}], "=", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["x"]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4e68f45b-5361-4298-8629-4105bee33426"],
 ". And similarly, if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{
     RowBox[{"-", "x"}], "-", 
     RowBox[{"\[ImaginaryI]", " ", "\[Epsilon]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"d1c393ca-be3a-4be1-86e3-e64f445254be"],
 " then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["s"], "\[TildeTilde]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], 
     SqrtBox["x"]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0ab49748-df13-4de3-ba94-8f4066a5b7ae"],
 "."
}], "SolvedExampleNote",
 CellID->12140647,ExpressionUUID->"116c29c8-d022-4510-978c-56d27c72b2e1"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "r"}], 
         RowBox[{"-", "R"}]], 
        RowBox[{
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"s", " ", "t"}]], 
          SqrtBox["s"]], 
         RowBox[{"\[DifferentialD]", "s"}]}]}], "+", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "R"}], 
         RowBox[{"-", "r"}]], 
        RowBox[{
         FractionBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"s", " ", "t"}]], 
          SqrtBox["s"]], 
         RowBox[{"\[DifferentialD]", "s"}]}]}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           RowBox[{"\[VeryThinSpace]", "r"}], "R"], 
          RowBox[{
           FractionBox[
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "x"}], " ", "t"}]], 
            RowBox[{"\[ImaginaryI]", 
             SqrtBox["s"]}]], 
           RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "R", 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "r"}]], 
         RowBox[{
          FractionBox[
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "x"}], " ", "t"}]], 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], 
            SqrtBox["s"]}]], 
          RowBox[{"\[DifferentialD]", "x"}]}]}]}], ")"}]}], "=", 
     RowBox[{
      FractionBox["1", "\[Pi]"], 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"\[VeryThinSpace]", "r"}], "R"], 
       RowBox[{
        FractionBox[
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "x"}], " ", "t"}]], 
         SqrtBox["s"]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"25ad9312-6d36-4016-9c45-de374eb5d89a"],
 ","
}], "SolvedExampleNote",
 CellID->210861342,ExpressionUUID->"af92b698-be57-4a66-962a-7ae7e9b0b07f"],

Cell[TextData[{
 "which after taking ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1c56708b-a0c5-415c-adb1-c28e58cc4d8d"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "561f7e65-71d1-412d-8852-fa5eeceb6151"],
 ", and after the change of variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"x", " ", "t"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "62fae5c3-a98d-46a9-9499-04758f914588"],
 " becomes"
}], "SolvedExampleNote",
 CellID->102159963,ExpressionUUID->"06cfcdd4-8d82-4703-ab7e-2e81b2102632"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "\[Pi]"], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{"\[VeryThinSpace]", "0"}], 
       RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
      RowBox[{
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "x"}], " ", "t"}]], 
        SqrtBox["x"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}], "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["t", 
         RowBox[{"1", "/", "2"}]]}]], 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"\[VeryThinSpace]", "0"}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "u"}]], 
        SuperscriptBox["u", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]], 
        RowBox[{"\[DifferentialD]", "u"}]}]}]}], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["t", 
          RowBox[{"1", "/", "2"}]]}]], 
       SqrtBox["\[Pi]"]}], "=", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"\[Pi]", " ", "t"}]]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ccafd0f6-0c75-4771-800e-c328b99d5584"],
 "."
}], "SolvedExampleNote",
 CellID->21861966,ExpressionUUID->"b92fa2af-6e8c-47fe-b055-7d2accdbf9b6"],

Cell["Confirm with Wolfram Language:", "SolvedExampleNote",
 CellID->336416808,ExpressionUUID->"4fb823be-ee04-43e6-bc9f-8a94826d6e29"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    SqrtBox["s"]}], ",", "s", ",", "t"}], "]"}]], "SolvedExampleInput",
 CellID->421930791,ExpressionUUID->"05fb7445-a54d-4da3-9f22-6f6920d8406a"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   SqrtBox["t"]}]]], "SolvedExampleOutput",
 CellID->601780313,ExpressionUUID->"4abcb958-822e-4c6f-89ed-1d59cb5cafb9"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1795973623,ExpressionUUID->"39309c74-cf68-4e80-96b8-ea33134b4aa6"],

Cell["\<\
Wolfram Language can compute the inverse Laplace transform of quite \
complicated functions:\
\>", "Text",
 CellID->518028258,ExpressionUUID->"24078b88-c1f6-4ca9-a45a-2b63a25a6069"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "3"}], " ", "s"}]]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "s"}]]}], ")"}]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "4"}], " ", "s"}]]}], ")"}], " ", 
     SuperscriptBox["s", "2"]}]], ",", "s", ",", "t"}], "]"}]], "Input",
 CellID->1733914346,ExpressionUUID->"33ca2f1e-0aa2-48d7-b809-964ad494be4c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "3"], "+", 
    RowBox[{
     FractionBox["1", "8"], " ", "t", " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", "t"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{
       RowBox[{"-", "4"}], "+", "t"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "3"], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", "t"}], ")"}], " ", "t"}], "+", 
       TemplateBox[{
         RowBox[{"(", 
           TagBox[
            GridBox[{{"\[Piecewise]", 
               GridBox[{{
                  RowBox[{"-", 
                    FractionBox[
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
                    "\[FormalN]", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "4"}], "+", "t"}], ")"}]}]], 
                    RowBox[{
                    SuperscriptBox["\[FormalN]", "2"], " ", 
                    SuperscriptBox["\[Pi]", "2"]}]]}], 
                  RowBox[{"\[FormalN]", "\[NotEqual]", "0"}]}, {"0", 
                  TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                ColumnWidths -> Automatic, 
                AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                Editable -> True]}}, ColumnAlignments -> {Left}, 
             ColumnSpacings -> 0.5, ColumnWidths -> Automatic], "Piecewise", 
            SyntaxForm -> Equal, SelectWithContents -> True, 
            StripWrapperBoxes -> True, Selectable -> False, Editable -> False,
             DeleteWithContents -> True], ")"}], "\[FormalN]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"},
        "InactiveSum",
        DisplayFunction->(RowBox[{
           UnderoverscriptBox[
            StyleBox["\[Sum]", "Inactive"], 
            RowBox[{#2, "=", #3}], #4], #}]& ),
        InterpretationFunction->(RowBox[{
           RowBox[{"Inactive", "[", "Sum", "]"}], "[", 
           RowBox[{#, ",", 
             RowBox[{"{", 
               RowBox[{#2, ",", #3, ",", #4}], "}"}]}], "]"}]& )]}], ")"}]}], 
    "-", 
    RowBox[{
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{
       RowBox[{"-", "3"}], "+", "t"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "3"], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", "t"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "t"}], ")"}]}], "+", 
       TemplateBox[{
         RowBox[{"(", 
           TagBox[
            GridBox[{{"\[Piecewise]", 
               GridBox[{{
                  RowBox[{"-", 
                    FractionBox[
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
                    "\[FormalN]", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "3"}], "+", "t"}], ")"}]}]], 
                    RowBox[{
                    SuperscriptBox["\[FormalN]", "2"], " ", 
                    SuperscriptBox["\[Pi]", "2"]}]]}], 
                  RowBox[{"\[FormalN]", "\[NotEqual]", "0"}]}, {"0", 
                  TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                ColumnWidths -> Automatic, 
                AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                Editable -> True]}}, ColumnAlignments -> {Left}, 
             ColumnSpacings -> 0.5, ColumnWidths -> Automatic], "Piecewise", 
            SyntaxForm -> Equal, SelectWithContents -> True, 
            StripWrapperBoxes -> True, Selectable -> False, Editable -> False,
             DeleteWithContents -> True], ")"}], "\[FormalN]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"},
        "InactiveSum",
        DisplayFunction->(RowBox[{
           UnderoverscriptBox[
            StyleBox["\[Sum]", "Inactive"], 
            RowBox[{#2, "=", #3}], #4], #}]& ),
        InterpretationFunction->(RowBox[{
           RowBox[{"Inactive", "[", "Sum", "]"}], "[", 
           RowBox[{#, ",", 
             RowBox[{"{", 
               RowBox[{#2, ",", #3, ",", #4}], "}"}]}], "]"}]& )]}], ")"}]}], 
    "-", 
    RowBox[{
     RowBox[{"HeavisideTheta", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "t"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "3"], "+", 
       RowBox[{
        FractionBox["1", "8"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "t"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"3", "+", "t"}], ")"}]}], "+", 
       TemplateBox[{
         RowBox[{"(", 
           TagBox[
            GridBox[{{"\[Piecewise]", 
               GridBox[{{
                  RowBox[{"-", 
                    FractionBox[
                    SuperscriptBox["\[ExponentialE]", 
                    RowBox[{
                    RowBox[{"-", 
                    FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
                    "\[FormalN]", " ", "\[Pi]", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "t"}], ")"}]}]], 
                    RowBox[{
                    SuperscriptBox["\[FormalN]", "2"], " ", 
                    SuperscriptBox["\[Pi]", "2"]}]]}], 
                  RowBox[{"\[FormalN]", "\[NotEqual]", "0"}]}, {"0", 
                  TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
                ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, 
                ColumnWidths -> Automatic, 
                AllowedDimensions -> {2, Automatic}, Selectable -> True, 
                Editable -> True]}}, ColumnAlignments -> {Left}, 
             ColumnSpacings -> 0.5, ColumnWidths -> Automatic], "Piecewise", 
            SyntaxForm -> Equal, SelectWithContents -> True, 
            StripWrapperBoxes -> True, Selectable -> False, Editable -> False,
             DeleteWithContents -> True], ")"}], "\[FormalN]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"},
        "InactiveSum",
        DisplayFunction->(RowBox[{
           UnderoverscriptBox[
            StyleBox["\[Sum]", "Inactive"], 
            RowBox[{#2, "=", #3}], #4], #}]& ),
        InterpretationFunction->(RowBox[{
           RowBox[{"Inactive", "[", "Sum", "]"}], "[", 
           RowBox[{#, ",", 
             RowBox[{"{", 
               RowBox[{#2, ",", #3, ",", #4}], "}"}]}], "]"}]& )]}], ")"}]}], 
    "+", 
    TemplateBox[{
      RowBox[{"(", 
        TagBox[
         GridBox[{{"\[Piecewise]", 
            GridBox[{{
               RowBox[{"-", 
                 FractionBox[
                  SuperscriptBox["\[ExponentialE]", 
                   RowBox[{
                    RowBox[{"-", 
                    FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
                    "\[FormalN]", " ", "\[Pi]", " ", "t"}]], 
                  RowBox[{
                    SuperscriptBox["\[FormalN]", "2"], " ", 
                    SuperscriptBox["\[Pi]", "2"]}]]}], 
               RowBox[{"\[FormalN]", "\[NotEqual]", "0"}]}, {"0", 
               TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
             ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, ColumnWidths -> 
             Automatic, AllowedDimensions -> {2, Automatic}, Selectable -> 
             True, Editable -> True]}}, ColumnAlignments -> {Left}, 
          ColumnSpacings -> 0.5, ColumnWidths -> Automatic], "Piecewise", 
         SyntaxForm -> Equal, SelectWithContents -> True, StripWrapperBoxes -> 
         True, Selectable -> False, Editable -> False, DeleteWithContents -> 
         True], ")"}], "\[FormalN]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"},
     "InactiveSum",
     DisplayFunction->(RowBox[{
        UnderoverscriptBox[
         StyleBox["\[Sum]", "Inactive"], 
         RowBox[{#2, "=", #3}], #4], #}]& ),
     InterpretationFunction->(RowBox[{
        RowBox[{"Inactive", "[", "Sum", "]"}], "[", 
        RowBox[{#, ",", 
          RowBox[{"{", 
            RowBox[{#2, ",", #3, ",", #4}], "}"}]}], "]"}]& )]}], 
   ")"}]}]], "Output",
 CellID->921376098,ExpressionUUID->"1730d364-4378-4cd9-a87d-8c62471c022f"]
}, Open  ]],

Cell["An approximation of the plot is:", "Text",
 CellID->302979053,ExpressionUUID->"73cb9648-476b-4f03-8e31-0951507e2cda"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Activate", "[", "%", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "14"}], "}"}]}], "]"}]], "Input",
 CellID->1938199875,ExpressionUUID->"7d04c6c8-91aa-46be-b250-9facf7c1549c"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwtxV1IU3EYB+CDtDAjQQzZhbEkKEJZIAZTaL/oJryY5sI0LVBhCy9GW0Ij
mqbFSPxALDqSIjgVP1ADP1BSQUegRRJ4Vo44bkePw6U721GxzPBC+/NePDxp
FY/NljiO4y6f+L+neGiqPuOtkeO6Tn5l7P2X8rKHd2CeXQ5To+ZqNV+HMrYD
3T7XUSXfii52HZacBmsZ78FndivWc1M6SvlRrLE9UDLd1+/zXmyzR+Hon40r
5pdhZ3uh14+8H7sr0wKe3Ez4YnLKtIBJ86O/v9plWoDRmVakk2XcYAvIm393
vsm+QftgM9e0WJpD9HcMP813axc36RXs1A9PjG9v0ivI6jgTyksM037Mzn26
5S4M034sxRu4vY0w7YfSfvH5V26L/on0uV17TU6EFmF1NQnWhxFY2CK6s69k
5ddGaBHaiQcHuoUILeL04GK1t0CBhr2KtTedDacqo3QAqXcMitIYpQMoOucz
/fgQxT12AN9exyf17UfpAGZcVW23a2N0EH+yEw+v9cTwmx1E5sFAiXYhRgcx
4Ahe2Dqr0hJC+mcvlvUqLUGnJK9/LFBpCbw1t7ehTaUlCJdCmqpplZYwZRMn
baJKSzgG87A0ZQ==
          "]], 
         LineBox[{{1.0044642857142858`, 0.5000000000000001}, {
          1.0128159186121473`, 0.5}, {1.021338315908464, 0.5}, {
          1.0383831105010974`, 0.5000000000000001}, {1.055427905093731, 
          0.5}, {1.089517494278998, 0.5}, {1.1236070834642649`, 
          0.49999999999999994`}, {1.2715228258392604`, 0.5}, {
          1.4194385682142558`, 0.5}, {1.6955276813749598`, 0.5}, {
          1.9947315658035192`, 0.49999999999999994`}, {2., 
          0.49999999999999994`}, {2.288478792928506, 0.5000000000000001}, {
          2.5624836484642053`, 0.5}, {2.85960327526776, 0.5000000000000001}, {
          2.928947589071327, 0.5000000000000002}, {2.9955357142857144`, 
          0.5}}], LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAkiRJkiQJCEC4bdu2bdvfP/GSJZAB
IAhAPrRpv/l/3z9IeTWpgkMIQOQaKlv18d4/9UVV24SKCEAs6KqS7NXdP1Df
lD+JGAlAxIKsAdud2z+kQ2jSPCEJQHDxXrYMe9s/96c7ZfApCUAoYBFrPljb
P55w4opXOwlAiD121KES2z/sATDWJV4JQFD4P6doh9o/iSTLbMKjCUDcbdNM
9nDZP8JpAZr7LgpA9Fj6lxFE1z8z9G30bUULQDgvSC5I6tI/NTxcdamhDUBY
Hh5VtPLCPwzrnqh4qg1AoKcIuzqswj/imeHbR7MNQPgw8yDBZcI/kPdmQubE
DUCAQ8jszdjBP+qycQ8j6A1AqGhyhOe+wD+eKYepnC4OQDBmjWc1Fr0/Bxey
3Y+7DkCQj94kAke0P97F9BBfxA5AAKKz8A66sz+0dDdELs0OQMC0iLwbLbM/
YtK8qszeDkDg2TJUNROyP7yNx3cJAg9AgEgOB9G+rz9wBN0Rg0gPQCBzX8Sd
76Y/RrMfRVJRD0AAlwlct9WlPx1iYnghWg9AQLyz89C7pD/Kv+fev2sPQMAG
CCMEiKI/JHvyq/yOD0AAN2ED1UCcP/opNd/Llw9AgIG1MggNmj/R2HcSm6AP
QEDLCWI72Zc/fjb9eDmyD0BAYLLAoXGTP9nxB0Z21Q9AABMH/NxEhT989XrU
At8PQIBBhcKVfoA/IPntYo/oD0AA3wYSnXB3P8P8YPEb8g9AAHoGPh3Iaz9u
27Zt2/YPQAAiSZIkSWI/Q+sFEA==
          "]], LineBox[CompressedData["
1:eJxFl3kglOsXx4c0iBhGiLGMZWzRtFqS85QSQkJutEmyVoRE5Zqi0CXJWpKl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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ], {}}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwtxV1IU3EYB+CDtDAjQQzZhbEkKEJZIAZTaL/oJryY5sI0LVBhCy9GW0Ij
mqbFSPxALDqSIjgVP1ADP1BSQUegRRJ4Vo44bkePw6U721GxzPBC+/NePDxp
FY/NljiO4y6f+L+neGiqPuOtkeO6Tn5l7P2X8rKHd2CeXQ5To+ZqNV+HMrYD
3T7XUSXfii52HZacBmsZ78FndivWc1M6SvlRrLE9UDLd1+/zXmyzR+Hon40r
5pdhZ3uh14+8H7sr0wKe3Ez4YnLKtIBJ86O/v9plWoDRmVakk2XcYAvIm393
vsm+QftgM9e0WJpD9HcMP813axc36RXs1A9PjG9v0ivI6jgTyksM037Mzn26
5S4M034sxRu4vY0w7YfSfvH5V26L/on0uV17TU6EFmF1NQnWhxFY2CK6s69k
5ddGaBHaiQcHuoUILeL04GK1t0CBhr2KtTedDacqo3QAqXcMitIYpQMoOucz
/fgQxT12AN9exyf17UfpAGZcVW23a2N0EH+yEw+v9cTwmx1E5sFAiXYhRgcx
4Ahe2Dqr0hJC+mcvlvUqLUGnJK9/LFBpCbw1t7ehTaUlCJdCmqpplZYwZRMn
baJKSzgG87A0ZQ==
              "]], 
             
             Line[{{1.0044642857142858`, 0.5000000000000001}, {
              1.0128159186121473`, 0.5}, {1.021338315908464, 0.5}, {
              1.0383831105010974`, 0.5000000000000001}, {1.055427905093731, 
              0.5}, {1.089517494278998, 0.5}, {1.1236070834642649`, 
              0.49999999999999994`}, {1.2715228258392604`, 0.5}, {
              1.4194385682142558`, 0.5}, {1.6955276813749598`, 0.5}, {
              1.9947315658035192`, 0.49999999999999994`}, {2., 
              0.49999999999999994`}, {2.288478792928506, 
              0.5000000000000001}, {2.5624836484642053`, 0.5}, {
              2.85960327526776, 0.5000000000000001}, {2.928947589071327, 
              0.5000000000000002}, {2.9955357142857144`, 0.5}}], 
             Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAkiRJkiQJCEC4bdu2bdvfP/GSJZAB
IAhAPrRpv/l/3z9IeTWpgkMIQOQaKlv18d4/9UVV24SKCEAs6KqS7NXdP1Df
lD+JGAlAxIKsAdud2z+kQ2jSPCEJQHDxXrYMe9s/96c7ZfApCUAoYBFrPljb
P55w4opXOwlAiD121KES2z/sATDWJV4JQFD4P6doh9o/iSTLbMKjCUDcbdNM
9nDZP8JpAZr7LgpA9Fj6lxFE1z8z9G30bUULQDgvSC5I6tI/NTxcdamhDUBY
Hh5VtPLCPwzrnqh4qg1AoKcIuzqswj/imeHbR7MNQPgw8yDBZcI/kPdmQubE
DUCAQ8jszdjBP+qycQ8j6A1AqGhyhOe+wD+eKYepnC4OQDBmjWc1Fr0/Bxey
3Y+7DkCQj94kAke0P97F9BBfxA5AAKKz8A66sz+0dDdELs0OQMC0iLwbLbM/
YtK8qszeDkDg2TJUNROyP7yNx3cJAg9AgEgOB9G+rz9wBN0Rg0gPQCBzX8Sd
76Y/RrMfRVJRD0AAlwlct9WlPx1iYnghWg9AQLyz89C7pD/Kv+fev2sPQMAG
CCMEiKI/JHvyq/yOD0AAN2ED1UCcP/opNd/Llw9AgIG1MggNmj/R2HcSm6AP
QEDLCWI72Zc/fjb9eDmyD0BAYLLAoXGTP9nxB0Z21Q9AABMH/NxEhT989XrU
At8PQIBBhcKVfoA/IPntYo/oD0AA3wYSnXB3P8P8YPEb8g9AAHoGPh3Iaz9u
27Zt2/YPQAAiSZIkSWI/Q+sFEA==
              "]], 
             Line[CompressedData["
1:eJxFl3kglOsXx4c0iBhGiLGMZWzRtFqS85QSQkJutEmyVoRE5Zqi0CXJWpKl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              "]]}, "Charting`Private`Tag#1"], {}}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 14}, {0., 0.5000000000000036}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 14}, {0., 0.5000000000000036}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwtxV1IU3EYB+CDtDAjQQzZhbEkKEJZIAZTaL/oJryY5sI0LVBhCy9GW0Ij
mqbFSPxALDqSIjgVP1ADP1BSQUegRRJ4Vo44bkePw6U721GxzPBC+/NePDxp
FY/NljiO4y6f+L+neGiqPuOtkeO6Tn5l7P2X8rKHd2CeXQ5To+ZqNV+HMrYD
3T7XUSXfii52HZacBmsZ78FndivWc1M6SvlRrLE9UDLd1+/zXmyzR+Hon40r
5pdhZ3uh14+8H7sr0wKe3Ez4YnLKtIBJ86O/v9plWoDRmVakk2XcYAvIm393
vsm+QftgM9e0WJpD9HcMP813axc36RXs1A9PjG9v0ivI6jgTyksM037Mzn26
5S4M034sxRu4vY0w7YfSfvH5V26L/on0uV17TU6EFmF1NQnWhxFY2CK6s69k
5ddGaBHaiQcHuoUILeL04GK1t0CBhr2KtTedDacqo3QAqXcMitIYpQMoOucz
/fgQxT12AN9exyf17UfpAGZcVW23a2N0EH+yEw+v9cTwmx1E5sFAiXYhRgcx
4Ahe2Dqr0hJC+mcvlvUqLUGnJK9/LFBpCbw1t7ehTaUlCJdCmqpplZYwZRMn
baJKSzgG87A0ZQ==
          "]], 
         Line[{{1.0044642857142858`, 0.5000000000000001}, {
          1.0128159186121473`, 0.5}, {1.021338315908464, 0.5}, {
          1.0383831105010974`, 0.5000000000000001}, {1.055427905093731, 
          0.5}, {1.089517494278998, 0.5}, {1.1236070834642649`, 
          0.49999999999999994`}, {1.2715228258392604`, 0.5}, {
          1.4194385682142558`, 0.5}, {1.6955276813749598`, 0.5}, {
          1.9947315658035192`, 0.49999999999999994`}, {2., 
          0.49999999999999994`}, {2.288478792928506, 0.5000000000000001}, {
          2.5624836484642053`, 0.5}, {2.85960327526776, 0.5000000000000001}, {
          2.928947589071327, 0.5000000000000002}, {2.9955357142857144`, 
          0.5}}], 
         Line[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAkiRJkiQJCEC4bdu2bdvfP/GSJZAB
IAhAPrRpv/l/3z9IeTWpgkMIQOQaKlv18d4/9UVV24SKCEAs6KqS7NXdP1Df
lD+JGAlAxIKsAdud2z+kQ2jSPCEJQHDxXrYMe9s/96c7ZfApCUAoYBFrPljb
P55w4opXOwlAiD121KES2z/sATDWJV4JQFD4P6doh9o/iSTLbMKjCUDcbdNM
9nDZP8JpAZr7LgpA9Fj6lxFE1z8z9G30bUULQDgvSC5I6tI/NTxcdamhDUBY
Hh5VtPLCPwzrnqh4qg1AoKcIuzqswj/imeHbR7MNQPgw8yDBZcI/kPdmQubE
DUCAQ8jszdjBP+qycQ8j6A1AqGhyhOe+wD+eKYepnC4OQDBmjWc1Fr0/Bxey
3Y+7DkCQj94kAke0P97F9BBfxA5AAKKz8A66sz+0dDdELs0OQMC0iLwbLbM/
YtK8qszeDkDg2TJUNROyP7yNx3cJAg9AgEgOB9G+rz9wBN0Rg0gPQCBzX8Sd
76Y/RrMfRVJRD0AAlwlct9WlPx1iYnghWg9AQLyz89C7pD/Kv+fev2sPQMAG
CCMEiKI/JHvyq/yOD0AAN2ED1UCcP/opNd/Llw9AgIG1MggNmj/R2HcSm6AP
QEDLCWI72Zc/fjb9eDmyD0BAYLLAoXGTP9nxB0Z21Q9AABMH/NxEhT989XrU
At8PQIBBhcKVfoA/IPntYo/oD0AA3wYSnXB3P8P8YPEb8g9AAHoGPh3Iaz9u
27Zt2/YPQAAiSZIkSWI/Q+sFEA==
          "]], 
         Line[CompressedData["
1:eJxFl3kglOsXx4c0iBhGiLGMZWzRtFqS85QSQkJutEmyVoRE5Zqi0CXJWpKl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          "]]}, "Charting`Private`Tag#1"], {}}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{0, 14}, {0., 0.5000000000000036}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 14}, {0., 0.5000000000000036}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellID->43800211,ExpressionUUID->"34dee4c6-5d7b-4c66-9b43-febe2455e346"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Application to Differential Equations", "Subsection",
 CellID->561413315,ExpressionUUID->"b8661fdd-45f0-419e-9659-d27cc3703f0b"],

Cell["\<\
The Laplace transform can help solve differential equations by invoking Eq. \
(8). This technique is useful if it can transform the differential equation \
into an algebraic equation, which one can solve, then inverse-transform back \
into a solution of the differential equation. The method is illustrated in \
the following example.\
\>", "Text",
 CellID->106186112,ExpressionUUID->"3ef7c6c4-4e66-4e66-8567-8ea6584400c9"],

Cell["Consider the equation", "Text",
 CellID->14924026,ExpressionUUID->"49618f3b-cb41-4f1d-a05a-006229331286"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], 
      RowBox[{"(", "t", ")"}]}], "+", 
     RowBox[{"y", "(", "t", ")"}], "-", "3"}], "=", 
    RowBox[{
     RowBox[{"0", "    ", "with", " ", 
      RowBox[{"y", "(", "0", ")"}]}], "=", "3"}]}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], 
     RowBox[{"(", "0", ")"}]}], "=", "2."}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->262913549,ExpressionUUID->"9eba82c6-917a-42ed-9521-baea1a361030"],

Cell[TextData[{
 "Assuming that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"27dd87bd-3eb1-4ffd-9f31-8544d934e9d5"],
 " is continuous, one can take the Laplace transform of both sides of the \
differential equation and use Eq. (8), obtaining:"
}], "Text",
 CellID->808558506,ExpressionUUID->"7f108898-4ac5-4eaf-9684-5571e948a985"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], 
         RowBox[{"(", "t", ")"}]}], "+", 
        RowBox[{"y", "(", "t", ")"}], "-", "3"}], "]"}], "\[AlignmentMarker]",
       "=", 
      RowBox[{
       RowBox[{"\[ScriptCapitalL]", "[", 
        RowBox[{
         RowBox[{"y", "''"}], 
         RowBox[{"(", "t", ")"}]}], "]"}], "+", 
       RowBox[{"\[ScriptCapitalL]", "[", 
        RowBox[{"y", "(", "t", ")"}], "]"}], "-", 
       RowBox[{"\[ScriptCapitalL]", "[", "3", "]"}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         SuperscriptBox["s", "2"], 
         RowBox[{"\[ScriptCapitalL]", "[", 
          RowBox[{"y", "(", "t", ")"}], "]"}]}], "-", 
        RowBox[{"s", " ", 
         RowBox[{"y", "(", "0", ")"}]}], "-", 
        RowBox[{
         RowBox[{"y", "'"}], 
         RowBox[{"(", "0", ")"}]}], "+", 
        RowBox[{"\[ScriptCapitalL]", "[", 
         RowBox[{"y", "(", "t", ")"}], "]"}], "-", 
        FractionBox["3", "s"]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["s", "2"], "+", "1"}], ")"}], 
         RowBox[{"\[ScriptCapitalL]", "[", 
          RowBox[{"y", "(", "t", ")"}], "]"}]}], "-", 
        RowBox[{"3", "s"}], "-", "2", "-", 
        FractionBox["3", "s"]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", "0."}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->50536103,ExpressionUUID->"6d0daac0-822c-42d7-bd1e-6d55d4041b8c"],

Cell["From this, it follows that", "Text",
 CellID->747089371,ExpressionUUID->"79df53bf-0ecf-4c45-8a17-9a25c5f319d6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"\[ScriptCapitalL]", "[", 
     RowBox[{"y", "(", "t", ")"}], "]"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"3", 
       SuperscriptBox["s", "2"]}], "+", 
      RowBox[{"2", "s"}], "+", "3"}], 
     RowBox[{"s", "(", 
      RowBox[{"1", "+", 
       SuperscriptBox["s", "2"]}], ")"}]]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->675568773,ExpressionUUID->"dc36c234-f280-4195-bb62-8a5b606b83f4"],

Cell["and calculating the inverse Laplace transform:", "Text",
 CellID->251861984,ExpressionUUID->"7da42931-6d79-4ebb-86c4-b439748c2316"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"3", 
      SuperscriptBox["s", "2"]}], "+", 
     RowBox[{"2", "s"}], "+", "3"}], 
    RowBox[{"s", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["s", "2"]}], ")"}]}]], ",", "s", ",", "t"}], 
  "]"}]], "Input",
 CellID->272326960,ExpressionUUID->"66e44c91-d721-48ef-8fb1-2e02c015431e"],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", "t", "]"}]}]}]], "Output",
 CellID->354769591,ExpressionUUID->"89a174c2-947a-4e8b-b6df-32985e54095d"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "(", "t", ")"}], "=", 
    RowBox[{"3", "+", 
     RowBox[{"2", "sin", "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"75d8af18-71c9-47ef-8d25-c355f7624832"],
 "."
}], "Text",
 CellID->194151510,ExpressionUUID->"72e98e30-deaa-4dd0-abda-1f0ec718a8cb"],

Cell["\<\
This method is very useful for the differential equations occurring in simple \
electronics problems, such as the LRC circuit, or in mechanics problems, such \
as damped or driven harmonic oscillators.\
\>", "Text",
 CellID->5368102,ExpressionUUID->"f36fd9f9-1ecc-4ff2-832a-c0ad011d544d"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"43a650ff-f65d-4746-97e8-f27818e0314e"],

Cell[TextData[{
 "The Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"939bbfe9-6d91-4c17-b864-0cac6f46701e"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{"f", "(", "t", ")"}], "]"}], 
      RowBox[{"(", "s", ")"}]}], "=", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "s"}], "\[InvisibleSpace]", "t"}]], 
       RowBox[{"f", "(", "t", ")"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]],
  ExpressionUUID->"23ce7bb0-44a0-4f16-ba90-af10017ce3e3"],
 "."
}], "SummaryList",
 CellID->7942750,ExpressionUUID->"b0cc31f7-870f-41f8-8f66-4321e11870ae"],

Cell[TextData[{
 "It is analytic for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "(", "s", ")"}], ">", "\[Alpha]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"57243970-889f-40a4-92e0-3cb04fb18477"],
 "."
}], "SummaryList",
 CellID->501202724,ExpressionUUID->"9efec064-4368-4e76-a989-71c17a58e4ac"],

Cell[TextData[{
 "The inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cec54601-e104-42dd-a237-4c917468aa30"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ScriptCapitalL]", 
        RowBox[{"-", "1"}]], "[", 
       RowBox[{"F", "(", "s", ")"}], "]"}], 
      RowBox[{"(", "t", ")"}]}], "=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"x", "-", "\[ImaginaryI]\[Infinity]"}], 
        RowBox[{"\[VeryThinSpace]", 
         RowBox[{"x", "+", "\[ImaginaryI]\[Infinity]"}]}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"t", "\[InvisibleSpace]", "s"}]], 
        RowBox[{"F", "(", "s", ")"}], 
        RowBox[{"\[DifferentialD]", "s"}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a80fc22f-f9fa-4fbd-b49f-f789e6dbf05a"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "\[Alpha]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cfc7163b-0505-48f0-aca6-ddc1ae6ee041"],
 "."
}], "SummaryList",
 CellID->364162254,ExpressionUUID->"0e51d678-9533-43db-86cc-2b95c92a78af"],

Cell[TextData[{
 "It can be computed as a residue sum if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"F", "(", "s", ")"}], "|"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"29765d82-d5a0-4266-994d-661d4f4b6330"],
 " decays quickly enough at large ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "s", "|"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fc1f945c-bbf2-4315-9e95-7edec4035cbd"],
 "."
}], "SummaryList",
 CellID->441876433,ExpressionUUID->"e054e168-e0d3-445b-b575-9dcd0ebcfca0"],

Cell["\<\
The Laplace transform is the basis of a very important technique to solve \
differential equations.\
\>", "SummaryList",
 CellID->108232001,ExpressionUUID->"d256c497-0f58-451c-8652-32085e86a91d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->207779636,ExpressionUUID->"56909042-36bd-4c73-88fb-df13fa1b6726"],

Cell[TextData[{
 "Compute the Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", "t"}]], "-", 
     RowBox[{"3", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "3"}], "t"}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a5457e7a-340e-4f95-9f9f-3c45b70b52b5"],
 "."
}], "Exercise",
 CellID->642314276,ExpressionUUID->"673b7539-cd85-40f1-9b6d-5de7c34bbdae"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"31389e06-a2d3-4f0a-a8bc-49ffdf68c05b"],

Cell[TextData[{
 "By definition of Laplace transforms, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ScriptCapitalL]", "[", 
       RowBox[{"f", "(", "t", ")"}], "]"}], 
      RowBox[{"(", "s", ")"}]}], "=", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "s"}], " ", "t"}]], "(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", "t"}]], "-", 
          RowBox[{"3", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "3"}], "t"}]]}]}], ")"}], 
        RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"s", "-", "2"}]], "-", 
       FractionBox["3", 
        RowBox[{"s", "+", "3"}]]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dfcd668d-ee7d-49d8-aa77-937cae92f707"],
 ". Confirm with ",
 ButtonBox["LaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->491480609,ExpressionUUID->"63ae8e89-3cb5-48af-aaf3-e628b885eb85"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"2", "t"}], "]"}], "-", 
    RowBox[{"3", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "3"}], "t"}], "]"}]}]}], ",", "t", ",", "s"}], 
  "]"}]], "ExerciseInput",
 CellID->211837721,ExpressionUUID->"f1f0bf7f-bec4-4944-9546-6041a6dfd1ba"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "s"}]], "-", 
  FractionBox["3", 
   RowBox[{"3", "+", "s"}]]}]], "ExerciseOutput",
 CellID->327684079,ExpressionUUID->"b212a171-7fc8-4945-9642-e1f709b560d9"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"3", "s"}], "+", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "-", "2"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b810bb95-56fa-4aea-9479-19c7aa4e25f8"],
 "."
}], "Exercise",
 CellID->395268916,ExpressionUUID->"99b70530-856b-4096-8ef1-7922a5d05b1d"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"436ff0c6-6d70-4c01-a55c-af9d64173973"],

Cell[TextData[{
 "The rightmost pole of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c40db074-45d7-46eb-a66b-310524da8b31"],
 " is at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e6d8fc54-e202-4b8d-9624-9f7f8c0523dd"],
 ". So you have to integrate over a vertical line located to the right of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bce72b70-d33b-4a75-a8ad-b7a0abd835ab"],
 ". Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"F", 
     RowBox[{"(", "s", ")"}]}], "|"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"394cb967-c95f-47e7-a661-7a09d79ebc03"],
 " goes to zero like ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/"}], "|", "s", "|"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"075197e7-6463-46d4-857c-c5faf1ee8cb7"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "s", "|"}], " ", "->", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"aebec53c-21cc-49aa-965c-49beb443fe39"],
 ", you can close the contour and compute the inverse Laplace transform as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"s", "->", "1"}]], "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"s", " ", "t"}]], 
        RowBox[{"F", "(", "s", ")"}]}], "]"}], "+", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"s", "->", "2"}]], "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"s", " ", "t"}]], 
        RowBox[{"F", "(", "s", ")"}]}], "]"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], 
       SuperscriptBox["\[ExponentialE]", "t"]}], "+", 
      RowBox[{"7", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", "t"}]]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9ed73fcc-d995-4e67-a97a-f01c88b15660"],
 ". Confirm with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->80818990,ExpressionUUID->"4e3f645a-fb22-4aac-ba74-b02b8b61593b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"3", "s"}], "+", "1"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"s", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "-", "2"}], ")"}]}]], ",", "s", ",", "t"}], 
  "]"}]], "ExerciseInput",
 CellID->537164559,ExpressionUUID->"fdae8d3a-b149-46d6-a716-33c69b58fc34"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "t"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["\[ExponentialE]", "t"]}]}], ")"}]}]], "ExerciseOutput",
 CellID->23464242,ExpressionUUID->"554b5f43-367a-46ab-9fdf-c092ce7de53a"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"s", "+", "1"}], ")"}], "2"], 
      RowBox[{"(", 
       RowBox[{"s", "+", "1"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"06b1d164-b7dc-4b9c-8d4b-b622a822c05d"],
 "."
}], "Exercise",
 CellID->692387099,ExpressionUUID->"fef03f8e-b832-42a8-8030-e4a2dc238dc1"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"48ca8dd7-61a8-4fa3-8a81-40386f88e667"],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1d336700-79c2-4c0d-b337-eaf210530c84"],
 " has poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"s", "=", 
     RowBox[{"\[PlusMinus]", "\[ImaginaryI]"}]}], ",", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "23a0c222-6da4-40e6-a086-69105a170071"],
 " after deforming the integration contour (",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath",ExpressionUUID->
  "86468e46-c7e4-4b1b-8047-d3f41386eed3"],
 " decays fast enough), the inverse Laplace transform is just the sum of the \
residues of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"s", " ", "t"}]], 
    RowBox[{"F", "(", "s", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ee43d4f7-d85b-4d4f-b348-f8a336a81982"],
 " at those poles. So:"
}], "SolutionAnswer",
 CellID->78354248,ExpressionUUID->"32e27492-2f0b-445b-9071-494157ae7527"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ResidueSum", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Exp", "[", 
      RowBox[{"s", " ", "t"}], "]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"s", "^", "2"}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"s", "+", "1"}], ")"}]}]], ",", "s"}], "]"}], "//", 
  "FullSimplify"}]], "ExerciseInput",
 CellID->142131968,ExpressionUUID->"43357ac0-bcf0-426e-9617-4e2b9d3a5fb4"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", "t", "]"}]}], "+", 
    RowBox[{"Cosh", "[", "t", "]"}], "+", 
    RowBox[{"Sin", "[", "t", "]"}], "-", 
    RowBox[{"Sinh", "[", "t", "]"}]}], ")"}]}]], "ExerciseOutput",
 CellID->426709824,ExpressionUUID->"43d8106a-3666-45b6-b4a6-6abffdcfd4d1"]
}, Open  ]],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->41148191,ExpressionUUID->"5737e045-1329-4380-9b1f-459098f4e646"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"s", "+", "1"}], ")"}]}]], ",", "s", ",", "t"}], 
  "]"}]], "ExerciseInput",
 CellID->108152564,ExpressionUUID->"ff1ad292-414f-4aad-b5c5-d6dd5377fd96"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "t"}]], "-", 
    RowBox[{"Cos", "[", "t", "]"}], "+", 
    RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}]], "ExerciseOutput",
 CellID->132492374,ExpressionUUID->"0d92cda5-f348-49e4-813f-249febcd2a8c"]
}, Open  ]],

Cell["The two expressions are the same:", "SolutionAnswer",
 CellID->22972672,ExpressionUUID->"6d06b5f8-2ca4-4664-b29a-81fd82a1fb6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", "==", "%%"}], "]"}]], "ExerciseInput",
 CellID->408144357,ExpressionUUID->"d22df83e-3545-4c56-aca8-726caa54ee08"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->409928064,ExpressionUUID->"efcbf758-ec7a-4e71-a17e-ff6e52e9e262"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    RowBox[{"1", "/", 
     SuperscriptBox["s", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"61c3c11d-3a06-4910-9359-e902b31ec5ea"],
 "."
}], "Exercise",
 CellID->177482918,ExpressionUUID->"a2e242ba-4af6-43c4-8a06-5379cfbf972f"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"225c6e60-d617-4eb2-b738-3739c1f937e1"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5addb44b-6139-4e31-a23a-fdea9646d72e"],
 " has a double pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0404d00b-e537-4856-a010-e3551bc4e954"],
 ". After deforming the Bromwich contour, the inverse Laplace transform \
becomes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"s", "->", "0"}]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"s", " ", "t"}]], 
      RowBox[{"F", "(", "s", ")"}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"s", "->", "0"}]], 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"s", " ", "t"}]], 
        SuperscriptBox["s", "2"]]}], "=", "t"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"4bae9040-813e-46a0-b95d-76503c8619de"],
 "."
}], "SolutionAnswer",
 CellID->182888504,ExpressionUUID->"78a309b6-9589-4342-8c8c-947c8b6c3688"],

Cell[TextData[{
 "Check with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->331161216,ExpressionUUID->"e6daeb5e-2980-4e4f-9fc9-c4237748116e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"s", "^", "2"}]}], ",", "s", ",", "t"}], "]"}]], "ExerciseInput",
 CellID->43470489,ExpressionUUID->"b058e7ad-bab3-489a-a0af-a921607de0dc"],

Cell[BoxData["t"], "ExerciseOutput",
 CellID->484279412,ExpressionUUID->"68c6ebc3-374c-4b9e-b13e-3a5aae9c7fb9"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    FractionBox[
     RowBox[{"s", "+", "\[ImaginaryI]"}], 
     RowBox[{
      SuperscriptBox["s", "2"], "-", "1"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cf206978-608c-4eb9-8ba3-4bd9091d33da"],
 "."
}], "Exercise",
 CellID->97368005,ExpressionUUID->"d084c29a-6a28-47ae-8914-bd44f00e94d8"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"4e722e5f-b465-44da-8e34-efd9a5161d05"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "s", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d5980b83-f58f-4660-a029-47fa39301ab3"],
 " decays fast enough, so the Bromwich contour can be closed and the residue \
theorem can be used. The inverse Laplace transform then is:"
}], "SolutionAnswer",
 CellID->432195264,ExpressionUUID->"6a655fac-5835-4feb-ae77-bfde074bc0e7"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "(", "t", ")"}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"s", "->", "1"}]], "(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"s", " ", "t"}]], 
      RowBox[{"F", "(", "s", ")"}]}], ")"}], "+", 
    RowBox[{
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"s", "->", 
        RowBox[{"-", "1"}]}]], "(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"s", " ", "t"}]], 
       RowBox[{"F", "(", "s", ")"}]}], ")"}], "."}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"8d1220b9-0faa-4ddc-8330-29dac78def7f"]], \
"SolutionAnswer",
 CellID->262097987,ExpressionUUID->"619bc2c7-b259-4824-90b6-27da4da3ceb2"],

Cell[TextData[{
 "Using ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->44252249,ExpressionUUID->"a4bb195b-026f-49cd-b5e9-f00c2f327ea4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Residue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"s", " ", "t"}], "]"}], "*", 
      FractionBox[
       RowBox[{"s", "+", "\[ImaginaryI]"}], 
       RowBox[{
        SuperscriptBox["s", "2"], "-", "1"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1"}], "}"}]}], "]"}], "+", 
   RowBox[{"Residue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"s", " ", "t"}], "]"}], "*", 
      FractionBox[
       RowBox[{"s", "+", "\[ImaginaryI]"}], 
       RowBox[{
        SuperscriptBox["s", "2"], "-", "1"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "//", 
  "Simplify"}]], "ExerciseInput",
 CellID->612172767,ExpressionUUID->"ba0a1427-83e9-4594-8e26-773bb7168864"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "2"], "+", 
    FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "t"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "t"}]]}], ")"}]}]], "ExerciseOutput",
 CellID->89896778,ExpressionUUID->"1c7a2040-7714-4349-9cfa-f46946e66497"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "t", ")"}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "t"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "t"}]]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7b787e6d-563f-4d43-a171-96c87e0ff489"],
 ". Check with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->135776627,ExpressionUUID->"6fe08d5c-27a2-423f-826c-5280bd238d81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"s", "+", "\[ImaginaryI]"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"s", "^", "2"}], "-", "1"}], ")"}]}], ",", "s", ",", "t"}], 
  "]"}]], "ExerciseInput",
 CellID->205216594,ExpressionUUID->"046b7aa6-dc81-431a-83f0-8a6b30ca2e2e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "2"], "+", 
    FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", "t"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", "t"}]]}], ")"}]}]], "ExerciseOutput",
 CellID->240215890,ExpressionUUID->"709572c8-3005-4c64-bdf6-26b62b9a8fdb"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1862896846,ExpressionUUID->"50d9c958-da33-4f92-8add-5330e317446c"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"28. Laplace Transforms | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "27. Gamma Function"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "29. Hydrodynamics"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"ae323239-4076-4baa-9037-783eb8d1e29e"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[645, 23, 225, 7, 108, "Section",ExpressionUUID->"c1f60595-87e2-4f3d-af00-9114ffe2dc95",
 CounterAssignments->{{"Section", 27}},
 CellID->209017977],
Cell[873, 32, 438, 7, 83, "Text",ExpressionUUID->"92e3b7ef-fa54-4926-802f-9e0360aa97ed",
 CellID->602462738],
Cell[1314, 41, 252, 4, 60, "Text",ExpressionUUID->"9f21c376-6229-4562-af91-bb0a16e8f066",
 CellID->532596437],
Cell[1569, 47, 304, 5, 83, "Text",ExpressionUUID->"7c6128d8-91ae-4e4c-a0ac-ed42c7aca0bc",
 CellID->23118163],
Cell[CellGroupData[{
Cell[1898, 56, 118, 1, 56, "Subsection",ExpressionUUID->"41833d14-c978-441f-bbe3-095a25e8c598",
 CellID->578882762],
Cell[2019, 59, 640, 18, 36, "Text",ExpressionUUID->"3b569e6a-4b29-44f7-90a3-eae3b49906e6",
 CellID->435757350],
Cell[2662, 79, 691, 20, 45, "DisplayFormulaNumbered",ExpressionUUID->"5f707744-837a-43bd-badd-e619465bd112",
 CellID->551401871],
Cell[3356, 101, 738, 18, 83, "Text",ExpressionUUID->"e45db0b1-63f3-4c56-ba83-fe2ec0ca9e00",
 CellID->522198673],
Cell[4097, 121, 348, 10, 60, "Text",ExpressionUUID->"8e60c18b-030e-496c-8f4e-62744bf75a65",
 CellID->536763341],
Cell[4448, 133, 180, 4, 36, "Text",ExpressionUUID->"e05119dd-792b-497d-b33d-6e41a84cfb26",
 CellID->68663891],
Cell[4631, 139, 185, 8, 71, "SolvedExample",ExpressionUUID->"9975f5dd-b282-4a58-9c74-f2abea375dfd",
 CellID->1906984],
Cell[4819, 149, 768, 22, 39, "SolvedExampleNote",ExpressionUUID->"87c6c78d-5162-40ea-a0dd-c759d55343a7",
 CellID->311349781],
Cell[5590, 173, 132, 1, 39, "SolvedExampleNote",ExpressionUUID->"3e4fe40b-75cc-42fa-92f5-2ba1fa5c1a95",
 CellID->248782227],
Cell[5725, 176, 1607, 46, 42, "SolvedExampleNote",ExpressionUUID->"bc8a9aea-5dfb-431c-ade8-de131e85326a",
 CellID->289749354],
Cell[7335, 224, 191, 6, 39, "SolvedExampleNote",ExpressionUUID->"11976656-9d7b-4dd2-9ebb-72102acb3ac0",
 CellID->496505997],
Cell[CellGroupData[{
Cell[7551, 234, 249, 5, 25, "SolvedExampleInput",ExpressionUUID->"2fe1fe66-8ac6-4dfe-b0b9-a2910da26578",
 CellID->1034554352],
Cell[7803, 241, 243, 6, 61, "SolvedExampleOutput",ExpressionUUID->"6dc96fe4-cdd2-452d-afca-77d847b41405",
 CellID->432571558]
}, Open  ]],
Cell[8061, 250, 888, 24, 61, "SolvedExampleNote",ExpressionUUID->"f8c164fc-8338-4ac6-a0b1-575fe07acbee",
 CellID->62923732],
Cell[CellGroupData[{
Cell[8974, 278, 2276, 65, 70, "SolvedExampleInput",ExpressionUUID->"cbadc20e-2f91-4316-9115-9cfecc00c3dc",
 CellID->1266185],
Cell[11253, 345, 23416, 459, 158, "SolvedExampleOutput",ExpressionUUID->"dc2ee8a7-f556-4ab5-b969-e7cff4f181a5",
 CellID->667829092]
}, {2}]],
Cell[34681, 807, 341, 8, 39, "SolvedExampleNote",ExpressionUUID->"4cb00d34-9e68-440b-a844-4e3912a6ee7f",
 CellID->115253968],
Cell[CellGroupData[{
Cell[35047, 819, 1372, 35, 27, "SolvedExampleInput",ExpressionUUID->"ccc8e13e-d7e5-f544-b45f-54b426891d46",
 CellID->7725860],
Cell[36422, 856, 65888, 1095, 173, "SolvedExampleOutput",ExpressionUUID->"0823d715-16ea-4c49-9016-bb12ae5c0fab",
 CellID->998364246]
}, Open  ]],
Cell[102325, 1954, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"d9a04fc4-994b-496d-86c3-29abe403d4fe",
 CellID->943814759],
Cell[102434, 1957, 187, 8, 71, "SolvedExample",ExpressionUUID->"a9538d2a-71e1-46ae-8b0f-1eba607ef44a",
 CellID->460022107],
Cell[102624, 1967, 623, 16, 39, "SolvedExampleNote",ExpressionUUID->"4a7b79d9-24c1-4050-a4ba-3a2260f0aa68",
 CellID->1337174875],
Cell[103250, 1985, 124, 1, 39, "SolvedExampleNote",ExpressionUUID->"63209ab2-7512-44e1-b631-5caf36dabfe0",
 CellID->493876631],
Cell[103377, 1988, 965, 28, 42, "SolvedExampleNote",ExpressionUUID->"c9fa0824-ab3f-4f15-8a4a-55e9904af6b2",
 CellID->336180965],
Cell[104345, 2018, 189, 6, 39, "SolvedExampleNote",ExpressionUUID->"d7adeb04-a346-4641-8215-33859e7a50ad",
 CellID->390900230],
Cell[CellGroupData[{
Cell[104559, 2028, 304, 7, 25, "SolvedExampleInput",ExpressionUUID->"4b5010d4-5125-49f2-8137-1fc897533376",
 CellID->184876379],
Cell[104866, 2037, 322, 9, 63, "SolvedExampleOutput",ExpressionUUID->"8a664607-3ae9-423f-a669-e31ac0b51e5a",
 CellID->104982529]
}, Open  ]],
Cell[105203, 2049, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"d1a9237c-ad89-4035-89cf-7d79a0a00bbf",
 CellID->1806916060],
Cell[CellGroupData[{
Cell[105335, 2054, 116, 1, 54, "Subsubsection",ExpressionUUID->"94eba930-fafd-4638-8416-01283333dc25",
 CellID->523232412],
Cell[105454, 2057, 122, 1, 36, "Text",ExpressionUUID->"6ebcc027-deaf-40a9-9921-f45cb78b122a",
 CellID->14146692],
Cell[105579, 2060, 760, 24, 32, "DisplayFormulaNumbered",ExpressionUUID->"4b7b8b4f-5ae7-4894-95cc-44aabb948017",
 CellID->33410458],
Cell[106342, 2086, 162, 3, 36, "Text",ExpressionUUID->"fe545731-b82d-490f-a823-efe3fad9e1c3",
 CellID->11885026],
Cell[106507, 2091, 642, 16, 60, "Text",ExpressionUUID->"3b027c88-3249-48d9-a6e6-7f68a91c1931",
 CellID->42789449],
Cell[107152, 2109, 425, 12, 32, "DisplayFormulaNumbered",ExpressionUUID->"89181e0c-418d-47c5-a924-61712bf74cbe",
 CellID->461527324],
Cell[107580, 2123, 925, 26, 60, "Text",ExpressionUUID->"ef9555b8-8a74-4dc0-a748-fc1a543629e5",
 CellID->665468202],
Cell[108508, 2151, 678, 18, 60, "Text",ExpressionUUID->"8cfdb925-c2ec-4e1c-b616-91ac14aec6c3",
 CellID->4366998],
Cell[CellGroupData[{
Cell[109211, 2173, 4309, 124, 306, "Input",ExpressionUUID->"74eedb66-b87b-4fbb-87fb-20de8c65f0c3",
 CellID->545674920],
Cell[113523, 2299, 2541, 71, 254, "Output",ExpressionUUID->"d2b40fe7-6727-499e-9c41-33bcca87d3e9",
 CellID->1996551769]
}, {2}]],
Cell[116076, 2373, 150, 1, 36, "Text",ExpressionUUID->"34b4546c-662f-415d-b40c-f9708b482c22",
 CellID->178058459],
Cell[116229, 2376, 426, 12, 32, "DisplayFormulaNumbered",ExpressionUUID->"e27c837a-75d9-4cda-a2ea-38c47e80b680",
 CellID->207213420],
Cell[116658, 2390, 166, 3, 36, "Text",ExpressionUUID->"c502ea05-9c7d-41dd-999f-fb4897c344a3",
 CellID->89869648],
Cell[116827, 2395, 9961, 166, 237, "Output",ExpressionUUID->"59d3a7d3-1b46-448b-ac09-ed431d02e43d",
 CellID->8756414],
Cell[126791, 2563, 390, 9, 60, "Text",ExpressionUUID->"945fbedc-b897-45e0-bc61-c4eaf5654389",
 CellID->49755625],
Cell[127184, 2574, 1489, 42, 49, "DisplayFormulaNumbered",ExpressionUUID->"ac834879-e91a-4d1d-9a14-617e50b6906b",
 CellID->50408794],
Cell[128676, 2618, 169, 3, 36, "Text",ExpressionUUID->"6fabea38-1641-4fe4-9a65-e3ebcd593875",
 CellID->297339089],
Cell[CellGroupData[{
Cell[128870, 2625, 283, 7, 25, "Input",ExpressionUUID->"750c1442-4b3d-42bb-8867-ad1530f76c45",
 CellID->21392940],
Cell[129156, 2634, 251, 6, 36, "Output",ExpressionUUID->"ee9ab0d8-45e2-4084-949a-aae1cb2cd4f7",
 CellID->160726252]
}, Open  ]],
Cell[129422, 2643, 186, 8, 71, "SolvedExample",ExpressionUUID->"ce494679-1e0e-43a1-931c-81d61f72aa80",
 CellID->78658241],
Cell[129611, 2653, 478, 14, 39, "SolvedExampleNote",ExpressionUUID->"7d563f92-4bcc-49f9-9708-bd30cdba258a",
 CellID->92739498],
Cell[130092, 2669, 136, 1, 39, "SolvedExampleNote",ExpressionUUID->"f4b0ce50-96a8-428c-846d-2f58e3d74d5e",
 CellID->618228798],
Cell[130231, 2672, 1010, 31, 42, "SolvedExampleNote",ExpressionUUID->"67b55b6f-ed88-4bd8-8c6c-46e2c1c3f0be",
 CellID->298659010],
Cell[131244, 2705, 133, 1, 39, "SolvedExampleNote",ExpressionUUID->"4302a71e-8f85-4db7-b0c0-701b7565d822",
 CellID->45421807],
Cell[CellGroupData[{
Cell[131402, 2710, 309, 8, 25, "SolvedExampleInput",ExpressionUUID->"7e257f18-c747-433c-bb57-8a7b2678df27",
 CellID->8873858],
Cell[131714, 2720, 354, 10, 59, "SolvedExampleOutput",ExpressionUUID->"3a3ecf54-a007-45e9-bd60-03d25cb6380f",
 CellID->192229859]
}, Open  ]],
Cell[132083, 2733, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"513e3f8b-a985-4b5e-81bf-31ee48e51ed4",
 CellID->1995350052],
Cell[132193, 2736, 738, 18, 83, "Text",ExpressionUUID->"38022c4e-3c1c-4eb7-8ad1-8373492c1d26",
 CellID->510790180],
Cell[132934, 2756, 826, 25, 48, "DisplayFormulaNumbered",ExpressionUUID->"465a7a43-fa35-492b-ac13-df7c40733716",
 CellID->17982628],
Cell[133763, 2783, 133, 1, 36, "Text",ExpressionUUID->"c1a1930b-ee4c-41eb-914b-aff6fcbf3426",
 CellID->252935255],
Cell[CellGroupData[{
Cell[133921, 2788, 433, 11, 25, "Input",ExpressionUUID->"c96c62c6-6790-4fa8-88c8-251c402e6caa",
 CellID->222434729],
Cell[134357, 2801, 662, 21, 38, "Output",ExpressionUUID->"3740665b-4b86-4238-85ab-91f8fdbc6cbe",
 CellID->371378360]
}, Open  ]],
Cell[135034, 2825, 1071, 30, 60, "Text",ExpressionUUID->"9bc605b6-36c5-4b59-b03d-7e17fd376279",
 CellID->254620036],
Cell[136108, 2857, 612, 18, 32, "DisplayFormulaNumbered",ExpressionUUID->"dd2f91df-0058-401a-b26a-6fe686ebf759",
 CellID->67794458],
Cell[136723, 2877, 111, 1, 36, "Text",ExpressionUUID->"f476fe1a-c8df-4684-a0a4-cc9129c15505",
 CellID->108768924],
Cell[CellGroupData[{
Cell[136859, 2882, 226, 6, 25, "Input",ExpressionUUID->"3d9ff970-0b9d-4a6d-86bc-8e7ad4f1fe1e",
 CellID->5652017],
Cell[137088, 2890, 306, 9, 36, "Output",ExpressionUUID->"b2488db0-4994-40c9-a454-ff1854ca10fd",
 CellID->59494624]
}, Open  ]],
Cell[137409, 2902, 126, 1, 36, "Text",ExpressionUUID->"aefd4c16-9a7b-411f-b359-77cb241ad142",
 CellID->89555827],
Cell[137538, 2905, 1188, 36, 33, "DisplayFormulaNumbered",ExpressionUUID->"474a7164-c9eb-44a8-b86d-6a300a12da8e",
 CellID->688297651],
Cell[138729, 2943, 102, 1, 36, "Text",ExpressionUUID->"45bfe2c2-d9f3-4b99-94a0-674c113227ab",
 CellID->50420723],
Cell[CellGroupData[{
Cell[138856, 2948, 232, 6, 25, "Input",ExpressionUUID->"b90d2d91-54ce-4ce1-b51e-5e621ea3b1c4",
 CellID->660130710],
Cell[139091, 2956, 811, 26, 38, "Output",ExpressionUUID->"31de369f-d3c0-4d80-a3da-558e4e009f70",
 CellID->119076703]
}, Open  ]],
Cell[139917, 2985, 182, 4, 36, "Text",ExpressionUUID->"00acb395-3cd1-41f2-85a1-d2184f7118e3",
 CellID->165388288]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[140148, 2995, 121, 1, 56, "Subsection",ExpressionUUID->"72f2bfe4-f2b6-4477-8780-d81a2041a595",
 CellID->26183447],
Cell[140272, 2998, 1135, 29, 107, "Text",ExpressionUUID->"7f212b76-37bb-4bee-97af-3385647ce33c",
 CellID->29919128],
Cell[141410, 3029, 846, 22, 60, "Text",ExpressionUUID->"b8e7baba-e1f4-46b5-8c35-8149163538e8",
 CellID->125924177],
Cell[142259, 3053, 994, 27, 48, "DisplayFormulaNumbered",ExpressionUUID->"9272a533-4ea1-4060-90ec-5e8a24c2c21a",
 CellID->49734511],
Cell[143256, 3082, 883, 21, 83, "Text",ExpressionUUID->"26fed254-1cc4-4430-9877-ee82b2d32faa",
 CellID->259248944],
Cell[144142, 3105, 2638, 74, 234, "Output",ExpressionUUID->"4f72a816-e9a6-4a2e-a038-cda5023fe71c",
 CellID->535918468],
Cell[146783, 3181, 686, 16, 83, "Text",ExpressionUUID->"64756d16-452b-4f5f-a07c-aebc6617eeda",
 CellID->213093425],
Cell[147472, 3199, 358, 10, 50, "DisplayFormulaNumbered",ExpressionUUID->"0f8e0a6c-da2f-45d3-a55a-130d7342019f",
 CellID->183566527],
Cell[147833, 3211, 398, 9, 60, "Text",ExpressionUUID->"f86ab0ff-cfe8-42ba-8fac-58b9f3c44ea4",
 CellID->615943027],
Cell[148234, 3222, 564, 16, 32, "DisplayFormulaNumbered",ExpressionUUID->"ea37a135-06f9-442d-a8ee-587a234a5b4b",
 CellID->249715280],
Cell[148801, 3240, 186, 8, 71, "SolvedExample",ExpressionUUID->"748d2836-707e-4276-b737-4531ef791dae",
 CellID->86350016],
Cell[148990, 3250, 495, 15, 43, "SolvedExampleNote",ExpressionUUID->"a34ab745-e13b-45c7-863d-cee7904a8ef1",
 CellID->10863979],
Cell[149488, 3267, 332, 8, 39, "SolvedExampleNote",ExpressionUUID->"dd53ce37-a519-4c6e-b650-d6ce11a28705",
 CellID->385270235],
Cell[CellGroupData[{
Cell[149845, 3279, 2181, 65, 70, "SolvedExampleInput",ExpressionUUID->"cd1da699-de32-4218-85f4-94117e14afbd",
 CellID->18950043],
Cell[152029, 3346, 7853, 189, 189, "SolvedExampleOutput",ExpressionUUID->"0825df2b-f475-43ee-a422-43831d51045f",
 CellID->212999953]
}, {2}]],
Cell[159894, 3538, 544, 14, 61, "SolvedExampleNote",ExpressionUUID->"2374f95e-d4cb-4724-b0de-5f9d318d187a",
 CellID->7570065],
Cell[160441, 3554, 1931, 61, 45, "SolvedExampleNote",ExpressionUUID->"43fe8543-83d4-4900-b19a-6a6079e800ef",
 CellID->427237187],
Cell[162375, 3617, 462, 11, 61, "SolvedExampleNote",ExpressionUUID->"a949fd8d-281b-4930-9184-3e3f21231d1c",
 CellID->26996803],
Cell[CellGroupData[{
Cell[162862, 3632, 417, 12, 25, "SolvedExampleInput",ExpressionUUID->"2d91986e-bcb1-47b3-a35f-9921e85e666f",
 CellID->10375129],
Cell[163282, 3646, 281, 7, 38, "SolvedExampleOutput",ExpressionUUID->"ef3d2604-6548-44be-89cd-edb55ecbc2a8",
 CellID->19368484]
}, Open  ]],
Cell[163578, 3656, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"03f6f35d-78cb-418e-8eeb-dc43ff1ff6e5",
 CellID->1068519411],
Cell[163688, 3659, 186, 8, 71, "SolvedExample",ExpressionUUID->"8db37898-fe1d-42be-9391-8d874dc7ab76",
 CellID->76770863],
Cell[163877, 3669, 453, 13, 42, "SolvedExampleNote",ExpressionUUID->"8b01ba39-db55-4b71-a090-a3943eface08",
 CellID->17179390],
Cell[164333, 3684, 1068, 30, 65, "SolvedExampleNote",ExpressionUUID->"bfcfc4d3-fd3a-42b5-8db2-e2f635b7412a",
 CellID->41935617],
Cell[CellGroupData[{
Cell[165426, 3718, 2895, 86, 70, "SolvedExampleInput",ExpressionUUID->"23159786-190f-4cb7-a8ca-e79585e65d18",
 CellID->102175376],
Cell[168324, 3806, 792, 20, 189, "SolvedExampleOutput",ExpressionUUID->"519434b6-c664-42e8-a4de-11e7f8ba35f3",
 CellID->51213956]
}, {2}]],
Cell[169128, 3829, 224, 4, 39, "SolvedExampleNote",ExpressionUUID->"c38fcc09-5f6c-4731-a563-794b7c82bc64",
 CellID->764935885],
Cell[CellGroupData[{
Cell[169377, 3837, 3605, 109, 70, "SolvedExampleInput",ExpressionUUID->"410394ef-bbf6-438c-9229-52f29bf3457b",
 CellID->4617079],
Cell[172985, 3948, 8222, 199, 189, "SolvedExampleOutput",ExpressionUUID->"8677bfa0-41dd-48a6-9ef9-7a30eb0b702b",
 CellID->206293082]
}, {2}]],
Cell[181219, 4150, 406, 9, 61, "SolvedExampleNote",ExpressionUUID->"a3881e2b-e8a2-4918-b743-0fdf7cc81e5c",
 CellID->114759054],
Cell[CellGroupData[{
Cell[181650, 4163, 753, 22, 43, "SolvedExampleInput",ExpressionUUID->"49a9ebee-fb68-4490-b8fc-0f5bdba82787",
 CellID->221860726],
Cell[182406, 4187, 191, 4, 55, "SolvedExampleOutput",ExpressionUUID->"0dfb0ec7-3a8a-4397-ac6c-33eba29d9aec",
 CellID->128743741]
}, Open  ]],
Cell[182612, 4194, 198, 6, 39, "SolvedExampleNote",ExpressionUUID->"db80a6cf-5e05-460b-8ad7-a3aebe0d79e7",
 CellID->463033996],
Cell[CellGroupData[{
Cell[182835, 4204, 404, 11, 25, "SolvedExampleInput",ExpressionUUID->"8b30a688-ef10-48f2-9a10-fb33135f339b",
 CellID->101551085],
Cell[183242, 4217, 191, 4, 55, "SolvedExampleOutput",ExpressionUUID->"4d9591eb-e8c7-4868-85fa-cf39d189a024",
 CellID->568894024]
}, Open  ]],
Cell[183448, 4224, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"e05c550e-b047-4638-aef9-20f986de9cba",
 CellID->686072142],
Cell[183557, 4227, 187, 8, 71, "SolvedExample",ExpressionUUID->"a5788392-cc46-42f7-941a-7687640ffefd",
 CellID->553058626],
Cell[183747, 4237, 382, 11, 45, "SolvedExampleNote",ExpressionUUID->"514480fb-5b66-46b0-9217-2645ff738fc3",
 CellID->600259306],
Cell[184132, 4250, 174, 3, 39, "SolvedExampleNote",ExpressionUUID->"e58a6395-3887-417e-ac18-7938ff522a5a",
 CellID->327667734],
Cell[CellGroupData[{
Cell[184331, 4257, 7275, 206, 70, "SolvedExampleInput",ExpressionUUID->"2faf0fc4-64f4-4a15-8d85-c83db012bcaa",
 CellID->94344254],
Cell[191609, 4465, 17196, 392, 189, "SolvedExampleOutput",ExpressionUUID->"d54472fe-87aa-41fd-a693-e9cd42fc6bb8",
 CellID->273184104]
}, {2}]],
Cell[208817, 4860, 1604, 49, 84, "SolvedExampleNote",ExpressionUUID->"116c29c8-d022-4510-978c-56d27c72b2e1",
 CellID->12140647],
Cell[210424, 4911, 2414, 74, 45, "SolvedExampleNote",ExpressionUUID->"af92b698-be57-4a66-962a-7ae7e9b0b07f",
 CellID->210861342],
Cell[212841, 4987, 677, 19, 39, "SolvedExampleNote",ExpressionUUID->"06cfcdd4-8d82-4703-ab7e-2e81b2102632",
 CellID->102159963],
Cell[213521, 5008, 1477, 47, 45, "SolvedExampleNote",ExpressionUUID->"b92fa2af-6e8c-47fe-b055-7d2accdbf9b6",
 CellID->21861966],
Cell[215001, 5057, 134, 1, 39, "SolvedExampleNote",ExpressionUUID->"4fb823be-ee04-43e6-bc9f-8a94826d6e29",
 CellID->336416808],
Cell[CellGroupData[{
Cell[215160, 5062, 235, 5, 31, "SolvedExampleInput",ExpressionUUID->"05fb7445-a54d-4da3-9f22-6f6920d8406a",
 CellID->421930791],
Cell[215398, 5069, 189, 5, 61, "SolvedExampleOutput",ExpressionUUID->"4abcb958-822e-4c6f-89ed-1d59cb5cafb9",
 CellID->601780313]
}, Open  ]],
Cell[215602, 5077, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"39309c74-cf68-4e80-96b8-ea33134b4aa6",
 CellID->1795973623],
Cell[215712, 5080, 191, 4, 36, "Text",ExpressionUUID->"24078b88-c1f6-4ca9-a45a-2b63a25a6069",
 CellID->518028258],
Cell[CellGroupData[{
Cell[215928, 5088, 714, 21, 54, "Input",ExpressionUUID->"33ca2f1e-0aa2-48d7-b809-964ad494be4c",
 CellID->1733914346],
Cell[216645, 5111, 8738, 206, 282, "Output",ExpressionUUID->"1730d364-4378-4cd9-a87d-8c62471c022f",
 CellID->921376098]
}, Open  ]],
Cell[225398, 5320, 123, 1, 36, "Text",ExpressionUUID->"73cb9648-476b-4f03-8e31-0951507e2cda",
 CellID->302979053],
Cell[CellGroupData[{
Cell[225546, 5325, 289, 7, 25, "Input",ExpressionUUID->"7d04c6c8-91aa-46be-b250-9facf7c1549c",
 CellID->1938199875],
Cell[225838, 5334, 27929, 511, 169, "Output",ExpressionUUID->"34dee4c6-5d7b-4c66-9b43-febe2455e346",
 CellID->43800211]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[253816, 5851, 134, 1, 56, "Subsection",ExpressionUUID->"b8661fdd-45f0-419e-9659-d27cc3703f0b",
 CellID->561413315],
Cell[253953, 5854, 433, 7, 107, "Text",ExpressionUUID->"3ef7c6c4-4e66-4e66-8567-8ea6584400c9",
 CellID->106186112],
Cell[254389, 5863, 111, 1, 36, "Text",ExpressionUUID->"49618f3b-cb41-4f1d-a05a-006229331286",
 CellID->14924026],
Cell[254503, 5866, 530, 17, 32, "DisplayFormulaNumbered",ExpressionUUID->"9eba82c6-917a-42ed-9521-baea1a361030",
 CellID->262913549],
Cell[255036, 5885, 399, 9, 60, "Text",ExpressionUUID->"7f108898-4ac5-4eaf-9684-5571e948a985",
 CellID->808558506],
Cell[255438, 5896, 1788, 54, 105, "DisplayFormulaNumbered",ExpressionUUID->"6d0daac0-822c-42d7-bd1e-6d55d4041b8c",
 CellID->50536103],
Cell[257229, 5952, 117, 1, 36, "Text",ExpressionUUID->"79df53bf-0ecf-4c45-8a17-9a25c5f319d6",
 CellID->747089371],
Cell[257349, 5955, 488, 15, 55, "DisplayFormulaNumbered",ExpressionUUID->"dc36c234-f280-4195-bb62-8a5b606b83f4",
 CellID->675568773],
Cell[257840, 5972, 137, 1, 36, "Text",ExpressionUUID->"7da42931-6d79-4ebb-86c4-b439748c2316",
 CellID->251861984],
Cell[CellGroupData[{
Cell[258002, 5977, 416, 13, 54, "Input",ExpressionUUID->"66e44c91-d721-48ef-8fb1-2e02c015431e",
 CellID->272326960],
Cell[258421, 5992, 179, 4, 36, "Output",ExpressionUUID->"89a174c2-947a-4e8b-b6df-32985e54095d",
 CellID->354769591]
}, Open  ]],
Cell[258615, 5999, 365, 11, 36, "Text",ExpressionUUID->"72e98e30-deaa-4dd0-abda-1f0ec718a8cb",
 CellID->194151510],
Cell[258983, 6012, 298, 5, 83, "Text",ExpressionUUID->"f36fd9f9-1ecc-4ff2-832a-c0ad011d544d",
 CellID->5368102],
Cell[CellGroupData[{
Cell[259306, 6021, 109, 1, 69, "SummarySection",ExpressionUUID->"43a650ff-f65d-4746-97e8-f27818e0314e",
 CellID->1198545324],
Cell[259418, 6024, 906, 27, 31, "SummaryList",ExpressionUUID->"b0cc31f7-870f-41f8-8f66-4321e11870ae",
 CellID->7942750],
Cell[260327, 6053, 322, 9, 29, "SummaryList",ExpressionUUID->"9efec064-4368-4e76-a989-71c17a58e4ac",
 CellID->501202724],
Cell[260652, 6064, 1374, 39, 33, "SummaryList",ExpressionUUID->"0e51d678-9533-43db-86cc-2b95c92a78af",
 CellID->364162254],
Cell[262029, 6105, 517, 14, 29, "SummaryList",ExpressionUUID->"e054e168-e0d3-445b-b575-9dcd0ebcfca0",
 CellID->441876433],
Cell[262549, 6121, 205, 4, 29, "SummaryList",ExpressionUUID->"d256c497-0f58-451c-8652-32085e86a91d",
 CellID->108232001]
}, Open  ]],
Cell[CellGroupData[{
Cell[262791, 6130, 160, 3, 65, "ExerciseSection",ExpressionUUID->"56909042-36bd-4c73-88fb-df13fa1b6726",
 CellID->207779636],
Cell[262954, 6135, 523, 16, 29, "Exercise",ExpressionUUID->"673b7539-cd85-40f1-9b6d-5de7c34bbdae",
 CellID->642314276],
Cell[CellGroupData[{
Cell[263502, 6155, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"31389e06-a2d3-4f0a-a8bc-49ffdf68c05b"],
Cell[263596, 6157, 1236, 38, 47, "SolutionAnswer",ExpressionUUID->"63ae8e89-3cb5-48af-aaf3-e628b885eb85",
 CellID->491480609],
Cell[CellGroupData[{
Cell[264857, 6199, 363, 11, 25, "ExerciseInput",ExpressionUUID->"f1f0bf7f-bec4-4944-9546-6041a6dfd1ba",
 CellID->211837721],
Cell[265223, 6212, 243, 7, 45, "ExerciseOutput",ExpressionUUID->"b212a171-7fc8-4945-9642-e1f709b560d9",
 CellID->327684079]
}, Open  ]]
}, Closed]],
Cell[265493, 6223, 535, 17, 31, "Exercise",ExpressionUUID->"99b70530-856b-4096-8ef1-7922a5d05b1d",
 CellID->395268916],
Cell[CellGroupData[{
Cell[266053, 6244, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"436ff0c6-6d70-4c01-a55c-af9d64173973"],
Cell[266147, 6246, 2305, 69, 84, "SolutionAnswer",ExpressionUUID->"4e3f645a-fb22-4aac-ba74-b02b8b61593b",
 CellID->80818990],
Cell[CellGroupData[{
Cell[268477, 6319, 389, 12, 48, "ExerciseInput",ExpressionUUID->"fdae8d3a-b149-46d6-a716-33c69b58fc34",
 CellID->537164559],
Cell[268869, 6333, 303, 8, 30, "ExerciseOutput",ExpressionUUID->"554b5f43-367a-46ab-9fdf-c092ce7de53a",
 CellID->23464242]
}, Open  ]]
}, Closed]],
Cell[269199, 6345, 517, 16, 31, "Exercise",ExpressionUUID->"fef03f8e-b832-42a8-8030-e4a2dc238dc1",
 CellID->692387099],
Cell[CellGroupData[{
Cell[269741, 6365, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"48ca8dd7-61a8-4fa3-8a81-40386f88e667"],
Cell[269835, 6367, 1053, 29, 43, "SolutionAnswer",ExpressionUUID->"32e27492-2f0b-445b-9071-494157ae7527",
 CellID->78354248],
Cell[CellGroupData[{
Cell[270913, 6400, 451, 14, 48, "ExerciseInput",ExpressionUUID->"43357ac0-bcf0-426e-9617-4e2b9d3a5fb4",
 CellID->142131968],
Cell[271367, 6416, 372, 10, 44, "ExerciseOutput",ExpressionUUID->"43d8106a-3666-45b6-b4a6-6abffdcfd4d1",
 CellID->426709824]
}, Open  ]],
Cell[271754, 6429, 194, 6, 22, "SolutionAnswer",ExpressionUUID->"5737e045-1329-4380-9b1f-459098f4e646",
 CellID->41148191],
Cell[CellGroupData[{
Cell[271973, 6439, 371, 11, 48, "ExerciseInput",ExpressionUUID->"ff1ad292-414f-4aad-b5c5-d6dd5377fd96",
 CellID->108152564],
Cell[272347, 6452, 336, 9, 44, "ExerciseOutput",ExpressionUUID->"0d92cda5-f348-49e4-813f-249febcd2a8c",
 CellID->132492374]
}, Open  ]],
Cell[272698, 6464, 133, 1, 22, "SolutionAnswer",ExpressionUUID->"6d06b5f8-2ca4-4664-b29a-81fd82a1fb6d",
 CellID->22972672],
Cell[CellGroupData[{
Cell[272856, 6469, 169, 3, 25, "ExerciseInput",ExpressionUUID->"d22df83e-3545-4c56-aca8-726caa54ee08",
 CellID->408144357],
Cell[273028, 6474, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"efcbf758-ec7a-4e71-a17e-ff6e52e9e262",
 CellID->409928064]
}, Open  ]]
}, Closed]],
Cell[273169, 6479, 385, 11, 25, "Exercise",ExpressionUUID->"a2e242ba-4af6-43c4-8a06-5379cfbf972f",
 CellID->177482918],
Cell[CellGroupData[{
Cell[273579, 6494, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"225c6e60-d617-4eb2-b738-3739c1f937e1"],
Cell[273673, 6496, 1167, 35, 49, "SolutionAnswer",ExpressionUUID->"78a309b6-9589-4342-8c8c-947c8b6c3688",
 CellID->182888504],
Cell[274843, 6533, 193, 6, 22, "SolutionAnswer",ExpressionUUID->"e6daeb5e-2980-4e4f-9fc9-c4237748116e",
 CellID->331161216],
Cell[CellGroupData[{
Cell[275061, 6543, 240, 5, 25, "ExerciseInput",ExpressionUUID->"b058e7ad-bab3-489a-a0af-a921607de0dc",
 CellID->43470489],
Cell[275304, 6550, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"68c6ebc3-374c-4b9e-b13e-3a5aae9c7fb9",
 CellID->484279412]
}, Open  ]]
}, Closed]],
Cell[275442, 6555, 447, 13, 29, "Exercise",ExpressionUUID->"d084c29a-6a28-47ae-8914-bd44f00e94d8",
 CellID->97368005],
Cell[CellGroupData[{
Cell[275914, 6572, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"4e722e5f-b465-44da-8e34-efd9a5161d05"],
Cell[276008, 6574, 421, 9, 43, "SolutionAnswer",ExpressionUUID->"6a655fac-5835-4feb-ae77-bfde074bc0e7",
 CellID->432195264],
Cell[276432, 6585, 774, 24, 22, "SolutionAnswer",ExpressionUUID->"619bc2c7-b259-4824-90b6-27da4da3ceb2",
 CellID->262097987],
Cell[277209, 6611, 171, 6, 22, "SolutionAnswer",ExpressionUUID->"a4bb195b-026f-49cd-b5e9-f00c2f327ea4",
 CellID->44252249],
Cell[CellGroupData[{
Cell[277405, 6621, 837, 27, 47, "ExerciseInput",ExpressionUUID->"ba0a1427-83e9-4594-8e26-773bb7168864",
 CellID->612172767],
Cell[278245, 6650, 449, 13, 45, "ExerciseOutput",ExpressionUUID->"1c7a2040-7714-4349-9cfa-f46946e66497",
 CellID->89896778]
}, Open  ]],
Cell[278709, 6666, 754, 24, 26, "SolutionAnswer",ExpressionUUID->"6fe08d5c-27a2-423f-826c-5280bd238d81",
 CellID->135776627],
Cell[CellGroupData[{
Cell[279488, 6694, 360, 10, 25, "ExerciseInput",ExpressionUUID->"046b7aa6-dc81-431a-83f0-8a6b30ca2e2e",
 CellID->205216594],
Cell[279851, 6706, 450, 13, 45, "ExerciseOutput",ExpressionUUID->"709572c8-3005-4c64-bdf6-26b62b9a8fdb",
 CellID->240215890]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[280364, 6726, 310, 6, 135, "SmallText",ExpressionUUID->"50d9c958-da33-4f92-8add-5330e317446c",
 CellGroupingRules->"SectionGrouping",
 CellID->1862896846]
}
]
*)

(* NotebookSignature YRGXjQj16pCUciI6WQGmjwu8 *)
