(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   2795330,      52522]
NotebookOptionsPosition[   2632432,      49120]
NotebookOutlinePosition[   2770722,      52068]
CellTagsIndexPosition[   2770679,      52065]
WindowTitle->29. Hydrodynamics | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Hydrodynamics"
}], "Section",
 CounterAssignments->{{"Section", 28}},
 CellID->708701785,ExpressionUUID->"912fbbc3-8bdc-404b-9fb1-45b52a990c46"],

Cell["\<\
This chapter explores the connection between analytic functions and \
hydrodynamics in two dimensions. Hydrodynamics is the study of fluid flow.\
\>", "Text",
 CellID->172364031,ExpressionUUID->"051d5797-3398-4159-ae52-4c797719cb21"],

Cell[CellGroupData[{

Cell["Review: Vector Fields", "Subsection",
 CellID->380816573,ExpressionUUID->"27d719fe-cf2e-424a-8e1f-92832863f124"],

Cell["\<\
The motion of a fluid can be represented by a vector field that at every \
point describes the velocity of the fluid. For example, the vector field \
representing the movement of the wind over the surface of the Earth may look \
like this:\
\>", "Text",
 CellID->357973425,ExpressionUUID->"acd488e5-211b-44b6-8f97-4812781634b0"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      TagBox[{
        Texture[
         GraphicsBox[
          TagBox[
           RasterBox[CompressedData["
1:eJztnU/PJcd13pk/iyyzzi6fIZtss8zWQT6AjThGNg5gBwjyaYwBspBgWMgi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            "], {{0, 282.}, {563., 0}}, {0, 255}, ColorFunction -> RGBColor], 
           
           BoxForm`ImageTag[
           "Byte", ColorSpace -> "RGB", Interleaving -> True, 
            MetaInformation -> <|
             "Exif" -> <|
               "Software" -> 
                "Created with the Wolfram Language: www.wolfram.com"|>, 
              "GeoMetaInformation" -> <|
               "GeoModel" -> "ITRF00", 
                "LonLatBox" -> {{-180.00000000000003`, 
                  179.99999999999997`}, {-90., 90}}, 
                "PlotRange" -> {{-2.770964967578247, 
                 2.770964967578247}, {-1.3854824837891235`, 
                 1.3854824837891235`}}, 
                "Projection" -> {
                 "EckertVI", 
                  "LongitudeDetermination" -> -2.842170943040401*^-14, 
                  "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
                   179.99999999999997`}}, "Centering" -> 
                  GeoPosition[{0., -2.842170943040401*^-14}]}, "Software" -> 
                "Created with the Wolfram Language: www.wolfram.com", 
                "TileSources" -> {"Wolfram", "OSM"}|>|>], Selectable -> 
           False], DefaultBaseStyle -> "ImageGraphics", 
          ImageSizeRaw -> {563., 282.}, PlotRange -> {{0, 563.}, {0, 282.}}]], 
        PolygonBox[{{-2.770964967578247, -1.3854824837891235`}, \
{-2.770964967578247, 1.3854824837891235`}, {2.770964967578247, 
         1.3854824837891235`}, {
         2.770964967578247, -1.3854824837891235`}, {-2.770964967578247, \
-1.3854824837891235`}}, 
         VertexTextureCoordinates -> {{0., 0.}, {0., 1.}, {1., 1.}, {1., 
          0.}, {0., 0.}}]}, 
       Annotation[#, "GeoBackground", "WolframGeoGraphics"]& ], 
      TagBox[
       TagBox[
        TooltipBox[{
          Opacity[0], 
          RectangleBox[
           Scaled[{0.8, 0}], 
           Scaled[{1, 0.2}]]}, 
         TagBox[
          GridBox[{{
             StyleBox["\"Geo data sources\"", Bold, StripOnInput -> False]}, {
            
             
             TemplateBox[{
              "\"Wolfram Knowledgebase\"", "\" (\"", 
               "\"https://www.wolfram.com/\"", "\")\""}, "RowDefault"]}, {
             
             TemplateBox[{
              "\"\[Copyright] OpenStreetMap contributors\"", "\" (\"", 
               "\"https://www.openstreetmap.org/copyright\"", "\")\""}, 
              "RowDefault"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           DefaultBaseStyle -> "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         Annotation[#, 
         Column[{
           Style["Geo data sources", Bold], 
           
           Row[{"Wolfram Knowledgebase", " (", "https://www.wolfram.com/", 
             ")"}], 
           
           Row[{"\[Copyright] OpenStreetMap contributors", " (", 
             "https://www.openstreetmap.org/copyright", ")"}]}], 
         "Tooltip"]& ], 
       Annotation[#, "Metadata", "WolframGeoGraphics"]& ], {{{{
          Opacity[0.8], {{
            GraphicsComplexBox[CompressedData["
1:eJxtmnlc11W6x3/8fiyijZpLOmaMazO5ReM2hfr56WiXDB0qIZu0zG3UchmH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             "], {{{
                EdgeForm[], 
                Directive[
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[2.], 
                 Opacity[1], 
                 FaceForm[]], 
                GraphicsGroupBox[{
                  PolygonBox[CompressedData["
1:eJxNmgX4H8URhm8XJyRosAIBgiaBAA0eoEhxCU6AJhDcoRDcobiUUFyDFnd3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                   "]], 
                  PolygonBox[CompressedData["
1:eJwllemPzmcYhd/njk8+1C61VIwtkZbQhtAiaqeWGmZGxDq2qrEz9qqlZmyl
jH1pJ9aqpbVXUTGIPTpIxL6kaROJP0Fcx/lwJddv8r6/91nOuScrf3L2pMhk
MoVQAbrycBZOpkzmFEzDe8EIfD5Uwe9DGV6Rz8/A+8BInhfAHfweXMBnwl28
GxQn/20ungdj8EXQBH+p7+CtYRe+G7bgwyELfwK38ErQDG8IU/A5cAI/Dp+x
lh08f4zXg234bGiKfwhb8R8hB/8fnuGd+U4xXgTLeV4BN/ASWIefgwb4U7iD
fwAd8cnh386DfPwxXMdz4U/8NPTF18BefE94bTthKP4IruIDtGf8D/gteQ9j
8OdQzvMg2ID/Apvwo7BW74IN+O+wH9+nz+Cl0EZ3B4e0V97XFp8XPuvD2iO+
MnwWveAA/ivswnfDTXwjrMfPwxt8QPis/uP5mr4b3ttf8DX+AK7gPWAqXhlW
4fOUGbw2rMYXQ13tNfxbDzM+6zrwU/KZf4l3gcH4UhgYXoN+uycorC2hKz5L
Z4bPDGevG3TCx8FUfBlc17thLX4WOuDDYSJ+HG7jQ6AAP5ac1QKYkZzZT/FX
2iPeiPWuC9+Bzl7v7Btek9aiDmzV3iEHL4Fvwp1636Xku20UzrLu+Dx+Lpx9
dU5d6A7DkjsxEf9bmcIL4edwRpVNZeJCuDPqij7zL94DOuKPkrszKpxNdagM
vwg12cuZ5Gwr08qyMq5u5IazoY68VvfD2X+RfBY6c521zmR7OBPKgjI5WNkO
Z3GcMh++A539Rjiis4P9yWs4hdcKZ/VIcpY/D7syrSwrw8quMn0Yb6HMJr/j
GH40nD11qDScYWV3M1zCL4f32gUOhjOgu9+bnP324btXB85oL+HvZuuMwx1U
99QJdb0+vM2485od/+iOkmdIeXgGavbpb5qVvcO/rZnZGW8Oc5MzXjU8YzVb
lenl4Rmm2bUSquGF8B2eD1+FM6EsaCZXCndOXdPMHIsvgR+SOzBBDkXJmdZs
3BLOpmbkF/i28F1pZmltjcNZ1RrXh+9Qd6eODgrPNM0yzfD+eCtYiI9KXmuN
sGvNo8OdVpc1s78Nd1TdnJ783WwYnfwO3W2/8F51x5qVH4VnhWbmZrxd+G7U
2ZHhjCqb6pxmUfVwVzWTPsEPhe9ad7YwPIM1e5fAMJ1t2DUTZodnjmbN98qo
uh12rbFnuGPqljqq/y2acZpt+h+zNDzDNbt1Bzr78eG96g7eAQgO9zM=
                   "]]}]}, {}, {}, {}, {}}}], {}}, {{{}}, {{
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.00007224463614766065, 1.}}], {
                 LABColor[
                 0.3353766719310453, 0.5223341390428278, -0.5065838925522138], 
                 
                 ArrowBox[{{-0.1716887870193479, -0.00015259273526993812`}, \
{-0.17316079297801482`, 5.093593268642099*^-6}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.22233413145649794`, 
                  0.5225359865519132, -0.7767494013653833], 
                 
                 ArrowBox[{{-1.7723176052780472`, -1.0803870112164469`}, \
{-1.7536860360115551`, -1.1059606941556261`}, {-1.7118760751728281`, \
-1.1290833425395022`}, {-1.6483848314005713`, -1.144248927400029}, \
{-1.582362935159195, -1.1466785889300952`}, {-1.512368976577881, \
-1.1427046345533607`}, {-1.4445025607953634`, -1.1366432924892886`}, \
{-1.3784535297712635`, -1.1277977481980745`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2822019992338795, 0.5224290871498439, -0.6336684612897518], 
                 
                 ArrowBox[{{-1.3682057892739454`, -1.1261184578147616`}, \
{-1.304459468649336, -1.1127688196466101`}, {-1.2397392964506597`, \
-1.0913605517630913`}, {-1.1892999084298996`, -1.0657052993994187`}, \
{-1.1431073686477602`, -1.0298389205670984`}, {-1.1016483762251426`, \
-0.9836261888222545}, {-1.084050130373865, -0.9593077203868495}, \
{-1.0676048296415197`, -0.9333341844874635}, {-1.0523356657356637`, \
-0.906108605900036}, {-1.0458984875041535`, -0.8945663270985005}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.2900432737266605, 0.5224150858568991, -0.6149282427473095], 
                 
                 ArrowBox[{{-1.0408372200271498`, -0.885491145674634}, \
{-1.0292102835216945`, -0.8646432931020896}, {-1.0079525550887585`, \
-0.8289747286480688}, {-0.9886123328629105, -0.7977086513873676}, \
{-0.9739589859170993, -0.7748449707070588}, {-0.9605318025550447, \
-0.7533302624062174}, {-0.9487756324342781, -0.731444630295725}, \
{-0.9392491479164364, -0.7068217024773719}, {-0.9340725133254533, \
-0.6760562889485693}, {-0.9358790355166191, -0.6343171588425163}, \
{-0.9496549927742097, -0.5733673760891583}, {-0.9554312372617443, \
-0.555309110407428}, {-0.9624418618316078, -0.5353107752708062}, \
{-0.9708531246916196, -0.5131207709539505}, {-0.9746964448316493, \
-0.5034788674370446}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5077968885835146, 0.5290870598763435, 
                  0.12329052396475847`], 
                 
                 ArrowBox[{{-0.9786248282403233, -0.493859059374807}, \
{-0.9808344751139446, -0.48848949484553456`}, {-0.9890763809225357, \
-0.4692873251020521}, {-1.0161124960965098`, -0.4101662410748128}, \
{-1.0419269947800507`, -0.3599103402882265}, {-1.0875058969723506`, \
-0.2832872438304651}, {-1.1356567365222758`, -0.21713430490211216`}, \
{-1.181447300156291, -0.16860937752398583`}, {-1.2060992130015176`, \
-0.15197477453233044`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.25356526458893636`, 
                  0.5224802205862668, -0.7021086958564969], 
                 
                 ArrowBox[{{-1.2147127589281297`, -0.14616253116853292`}, \
{-1.2389830666082287`, -0.12978542748175168`}, {-1.2864736892324673`, \
-0.1199647065217323}, {-1.3421774470267422`, -0.12821584897302477`}, \
{-1.3972194965969857`, -0.14249413358379945`}, {-1.4288168863566917`, \
-0.14785548124602815`}, {-1.4594817838546406`, -0.14780138196085418`}, \
{-1.4880917348131228`, -0.14095820814813897`}, {-1.5017367844226583`, \
-0.13575559864823258`}, {-1.5145962005501676`, -0.12911409479952687`}, \
{-1.5288103129120387`, -0.11767255717229846`}, {-1.5413232305538118`, \
-0.10580667086039347`}, {-1.563260436297262, -0.08251354657938217}, \
{-1.5795072215549253`, -0.061361510750677646`}, {-1.5847292467226208`, \
-0.05363258255494482}}]}}, {
                Arrowheads[{{0.007144644978771635, 1.}}], {
                 LABColor[
                 0.2075974585657392, 0.5225623001919175, -0.8119692461515283], 
                 
                 ArrowBox[{{-1.5905466204704286`, -0.045022500730235955`}, \
{-1.5914493777314116`, -0.04368636277144602}, {-1.6102212513486067`, \
-0.015184233459852427`}, {-1.6251725399314318`, 
                  0.005510451710021589}, {-1.6405151997699599`, 
                  0.024192508012973186`}, {-1.6474710576255143`, 
                  0.031941519830996766`}, {-1.6554650548534569`, 
                  0.04037070507229182}, {-1.6728107044295932`, 
                  0.054613943744904594`}, {-1.6906006858865765`, 
                  0.05990855852514021}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.3546275526958193, 0.5222997648832083, -0.4605753370554638], 
                 ArrowBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA9cgXX2r3AsCMQdQGwRjlPwmCXCLZ
5gLAGIa7bP4c5T8paqAPT2sCwKhdpF6Hc+U/cZvj45oKAsBdl2F4/d3lP+4l
VSPolgHAsgQ3jpda5j+VIoLvyxQBwO/KN75AtuY/j948PZn9AMBuY4JPQL7m
P24Bnhh85gDA9jIrTAzC5j9soDB8kM8AwLeISwY5weY/t/VAlQLLAMCfvpyo
fcDmP0VnoIB3xgDASdZZu5S/5j/EquYZEcMAwPVzVWTIvuY/8OAIauu/AMCs
Ix4E6r3mP/wT+427uwDA/1JaVJ+85j+wYQGKjrcAwP3M7Cctu+Y/HKuCv9+i
AMB+7uBNd7HmP5Or+TiMjgDAcKgDD5mj5j8fDumln3oAwLZMLjuHkeY/KQAH
hUXN/7+AT9sIR1jlP5g2PWygo/+/hizFvVHr5D/fFKRQ
                  "]]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5396982371827451, 0.5311658076614755, 
                  0.26541182739187885`], 
                 
                 ArrowBox[{{-1.9711373157330543`, 
                  0.6454700959081243}, {-1.9351980806583131`, 
                  0.5984550635325507}, {-1.9168434873112088`, 
                  0.5535549684578726}, {-1.9038505680728521`, 
                  0.500445563844388}, {-1.8924554588844618`, 
                  0.41199551720580485`}, {-1.8868282550173097`, 
                  0.3444128283318271}, {-1.8817769466629097`, 
                  0.28995627150238973`}, {-1.8774280572153064`, 
                  0.2485879083941554}}]}}, {
                Arrowheads[{{0.012670194590905385`, 1.}}], {
                 LABColor[
                 0.4331323660580572, 
                  0.524496369548637, -0.20087197642680865`], 
                 
                 ArrowBox[{{-1.8761603551545818`, 
                  0.2382750337656797}, {-1.8685686912881208`, 
                  0.17980125914602818`}, {-1.8604074611443822`, 
                  0.13177555654052261`}, {-1.8526433094636343`, 
                  0.09676312935862467}, {-1.8452286456330582`, 
                  0.07112582302483729}, {-1.8344675804403276`, 
                  0.04392300273298738}, {-1.8249253416779376`, 
                  0.026434844868031143`}, {-1.8167879517032572`, 
                  0.014635512028804717`}, {-1.8099262657143496`, 
                  0.006473840127347684}, {-1.8019198352792694`, \
-0.0012596626219341994`}, {-1.7955838419021006`, -0.00577744966506491}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.23258496205403362`, 
                  0.5225176827822573, -0.7522504750982016], 
                 
                 ArrowBox[{{1.0980954045632028`, -0.501379352140422}, {
                  1.081962427837263, -0.4773497450913674}, {
                  1.0803276449190735`, -0.43728165683359493`}, {
                  1.093532968254583, -0.38305073953665264`}, {
                  1.116092744476593, -0.31413394320360094`}, {
                  1.1280472478280057`, -0.27688948999894214`}, {
                  1.1410237653563642`, -0.23426571271370572`}, {
                  1.1547864729060082`, -0.18484963324010556`}, {
                  1.1618298775051474`, -0.15824004488607077`}, {
                  1.168968663477028, -0.12948264867169898`}, {
                  1.1744035389466412`, -0.10390852136129755`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.46240389220142414`, 
                  0.5261291726761754, -0.07893640673123221], 
                 
                 ArrowBox[{{1.176411297870591, -0.09371353797943931}, {
                  1.1806580089412884`, -0.07167737436690011}, {
                  1.1916902879447528`, -0.008243479801205149}, {
                  1.2008856723262369`, 0.05688994750859088}, {
                  1.207441658853219, 0.11575110290695347`}, {
                  1.2121154872113684`, 0.177559707240203}, {
                  1.2136399300274547`, 0.22789357859099793`}, {
                  1.212689731923392, 0.2695569920492878}, {
                  1.2095613845250452`, 0.30417177225990627`}, {
                  1.2056530953854312`, 0.3186955449433328}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.29296598591145434`, 
                  0.5224098670943713, -0.6079431199678276], 
                 
                 ArrowBox[{{1.2029529411006998`, 0.32872971223257563`}, {
                  1.1921361538252755`, 0.36892647197608636`}, {
                  1.1603661869574735`, 0.4124542106638245}, {
                  1.1111423581473654`, 0.4465014905029794}, {
                  1.0409505420355014`, 0.47980236173680246`}, {
                  0.9957681562573844, 0.4975750239948481}, {0.947144741066452,
                   0.5139835312736054}, {0.8973680544041005, 
                  0.5285659860492027}, {0.8674597916139186, 
                  0.5361254154631886}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3239677185551192, 0.5223545107436984, -0.5338506691205167], 
                 
                 ArrowBox[{{0.8573854874860412, 0.5386717349028692}, {
                  0.8487258542117257, 0.540860490797768}, {0.8015537561526402,
                   0.553091675442454}, {0.7561873758901564, 
                  0.5674841699064136}, {0.7133708990819334, 
                  0.5861578606954763}, {0.67384851138563, 
                  0.611232634315472}, {0.6381982291376971, 
                  0.642357952747987}, {0.6069980686745855, 
                  0.6791832779746076}, {0.5792397591799766, 
                  0.7218860710285497}, {0.5539150298375518, 
                  0.770643792943029}, {0.5476183914222887, 
                  0.7847017739921633}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.35350042616225097`, 
                  0.5223017774678712, -0.46326910802133203`], 
                 
                 ArrowBox[{{0.5433707726016564, 0.794185079360255}, {
                  0.5325071577179499, 0.8184393690444214}, {
                  0.5108567996117451, 0.8703763849713608}, {
                  0.5034940930933975, 0.8872112033009045}, {
                  0.4971977126993973, 0.8988316512660421}, {
                  0.4903685321802077, 0.9095660956322943}, {
                  0.47530419290642145`, 0.9284484121209182}, {
                  0.45860211883861635`, 0.943997685660405}, {
                  0.44061742322393943`, 0.9564415504269665}, {
                  0.37768591939403895`, 0.9788729518814446}, {
                  0.3145921450233307, 0.9817674363533982}, {
                  0.25632298331570114`, 0.9719006916213306}, {
                  0.22759907533336887`, 0.9614310509898447}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2874793571433574, 0.5224196639579721, -0.6210558636002625], 
                 ArrowBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA+CYm9w7iyz8ZlWxl5KbuP/Zt74QV
d8o/uANFHNGF7j8prWn7B3rCP8LoittnPe0/asDhsoSqtj9Vf6xHNM/rP0CS
3SLpxKA/gmE0R6q/6j9rxsBx8HeUP7l46DkBmOo/a2eMnHbxfz/nhb+OsHnq
Pyxm82ughW+/qFQBCuxj6j9PncvzJqyOv52CmwvlVOo/ChOR5wUvob/Imz/E
4kXqP2l/nhOz+Km/255eF6lC6j97Kg6VLAuxvzzHTpzvR+o/C6cuHVBUtb+i
5IWplVTqPw1FtuZCQbm/qvkQcbFk6j9Ug7ELPty8v2m6wq1Qduo/bcAkSvtE
wL9QqjWq94rqP3T9Mf8p88G/Xl/WBx2g6j+OFufCe3zDv1mmJ1ckteo/yupo
3U0ixL/uZaXq0b7qP2t+o3g=
                  "]]}}, {
                Arrowheads[{{0.004852267887244553, 1.}}], {
                 LABColor[
                 0.21107070477446999`, 
                  0.5225560984019301, -0.803668377069181], 
                 
                 ArrowBox[{{-0.1674159008044099, 
                  0.8381558189974774}, {-0.17243288618912672`, 
                  0.8393270729859349}, {-0.18938609159919273`, 
                  0.8436458405413936}, {-0.2035674512004715, 
                  0.8474569034682023}, {-0.21845722383049324`, 
                  0.8516546825647775}, {-0.23009667756639204`, 
                  0.8551202235434983}, {-0.23913673343048836`, 
                  0.8579423255917793}, {-0.2505552974480957, 
                  0.8617640097373245}, {-0.25751290270439015`, 
                  0.8643753054886085}, {-0.2617906422512824, 
                  0.8660678215665374}, {-0.26401603566978943`, 
                  0.8668289974132709}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4592294558874002, 
                  0.5259223208424263, -0.09307859966054122], 
                 
                 ArrowBox[{{-0.9816574596148085, -0.31671293434763953`}, \
{-1.005903480049338, -0.25371156295300706`}, {-1.0260748033799367`, \
-0.19975889315024783`}, {-1.0467150417852584`, -0.14129484655572355`}, \
{-1.0628519090375588`, -0.09072719222111392}, {-1.0750180506330793`, \
-0.046309222632865646`}, {-1.0922900793518724`, 
                  0.03155086425170179}, {-1.1002127866145954`, 
                  0.08056609329624737}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2786748261053175, 0.5224353852311425, -0.6420982127704757], 
                 
                 ArrowBox[{{-1.1018708623902345`, 
                  0.09082407219426152}, {-1.1030736698756893`, 
                  0.09826545333344067}, {-1.1098385369185833`, 
                  0.15551867904648645`}, {-1.1150543951946075`, 
                  0.20499467582497477`}, {-1.1196707470071263`, 
                  0.25585682606221183`}, {-1.1229548352083305`, 
                  0.300001298909314}, {-1.1261053227287023`, 
                  0.37218525494904975`}, {-1.124588330631832, 
                  0.42900070997616}, {-1.1178173237767737`, 
                  0.4746078096046975}, {-1.1102405100881112`, 
                  0.5038130445691933}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2248805734934028, 0.5225314396531968, -0.7706635437256344], 
                 
                 ArrowBox[{{-1.107631091250245, 
                  0.5138711895114008}, {-1.1048765792224855`, 
                  0.5244886039403209}, {-1.0859615925760455`, 
                  0.5819741212830148}, {-1.0712594919006537`, 
                  0.6226621728289683}, {-1.0534345563329013`, 
                  0.6638984805030325}, {-1.038845873821864, 
                  0.6854587099554043}, {-1.0228788469361365`, 
                  0.7041931420696375}, {-0.990250783382837, 
                  0.7335205198704499}, {-0.9595717746879989, 
                  0.7445064069394893}, {-0.9339350991143499, 
                  0.7378979066863935}, {-0.9135909587120571, 
                  0.7229145100918959}, {-0.8941251493522043, 
                  0.7062060253228578}, {-0.8750576186470912, 
                  0.6914456357804657}, {-0.8544398491731295, 
                  0.678337279663657}, {-0.8517991930155269, 
                  0.6770753905575873}}]}}, {
                Arrowheads[{{0.0032250429210250544`, 1.}}], {
                 LABColor[
                 0.20430474306849747`, 
                  0.5225681796282646, -0.8198386566756983], 
                 
                 ArrowBox[{{-0.8424235816540995, 
                  0.6725950716013814}, {-0.8360122848338492, 
                  0.6695313082295541}, {-0.8202893910744601, 
                  0.6643301458115818}, {-0.8118782421371895, 
                  0.66229494967135}, {-0.8048028273880613, 
                  0.6608324977797745}, {-0.7989267324522777, 
                  0.6598437350057739}, {-0.7943935491395826, 
                  0.659232212650405}, {-0.7906932590151938, 
                  0.6588161729578783}, {-0.7877100903116736, 
                  0.658527144151098}, {-0.7851857934865005, 
                  0.658312657907338}, {-0.7832153663067416, 
                  0.6581638088337656}, {-0.7816874281879416, 
                  0.6580583623261338}, {-0.7794169177377054, 
                  0.657925782656693}, {-0.7775086245119357, 
                  0.6578696393524003}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.21607784619849654`, 
                  0.5225471577056237, -0.7917015820480958], 
                 
                 ArrowBox[{{1.7318964441529756`, -0.731233690084737}, {
                  1.7522220799574784`, -0.7425506014774217}, {
                  1.7666298906861675`, -0.7456957846880167}, {
                  1.7854652229118804`, -0.7463917928736481}, {
                  1.7871759850593418`, -0.7462515710251909}, {
                  1.7892652822036001`, -0.7460654066976995}, {
                  1.7965606185608427`, -0.7452832033462728}, {
                  1.8043938161905608`, -0.7442400927034726}, {
                  1.8128162264550793`, -0.7429136992573177}, {
                  1.892503116204232, -0.719270611240956}, {
                  1.9400254172761355`, -0.695984523666038}, {
                  1.9873712152658494`, -0.6625800797798886}, {
                  2.0323660831571866`, -0.6199908449606284}, {
                  2.0728355939339593`, -0.5691503845863778}, {
                  2.0782777446428926`, -0.5604228984609663}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36437681003839273`, 
                  0.5222823567172048, -0.4372751435225706], 
                 
                 ArrowBox[{{2.0837759218319687`, -0.5516055636058421}, {
                  2.117990147587864, -0.496736781657904}, {
                  2.155768976217591, -0.41628150260076435`}, {
                  2.1811752869595806`, -0.3316563400583744}, {
                  2.193970667535312, -0.263013365373023}, {
                  2.202678572574615, -0.1977955171031162}, {
                  2.2058621332708315`, -0.15980832656473576`}}]}}, {
                Arrowheads[{{0.01886194204750932, 1.}}], {
                 LABColor[
                 0.3419463193257748, 0.5223224083531545, -0.4908827934467861], 
                 
                 ArrowBox[{{2.206729930911799, -0.14945350770566362`}, {
                  2.2078277541874023`, -0.13635395474366738`}, {
                  2.211641038254433, -0.06431516615374265}, {
                  2.214330457860989, -0.0008809578727457176}, {
                  2.2265088815302185`, 0.0717698390276591}, {
                  2.2581845347196587`, 0.11761329269575724`}, {
                  2.3106807047225733`, 0.14555971840492585`}, {
                  2.3239554465710808`, 0.14990346830780393`}, {
                  2.337062968557727, 0.1536678202333676}, {2.351068605486165, 
                  0.15716538528907817`}, {2.357011132874223, 
                  0.1584779370831727}, {2.3631114500758406`, 
                  0.15975567426630508`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.25232988608023177`, 
                  0.5224824264644584, -0.7050611831411946], 
                 
                 ArrowBox[{{0.12323179189942203`, -1.0832568816986252`}, {
                  0.12424731569096102`, -1.0581575006363972`}, {
                  0.11349626546506048`, -1.0283202133276599`}, {
                  0.08714985088738296, -0.9989826349726374}, {
                  0.0583638666285448, -0.9828649399399946}, {
                  0.02200193738747834, -0.9741488372978024}, \
{-0.018319409737852725`, -0.9756005220005155}, {-0.08046235464088956, \
-1.000311271324841}, {-0.11907809503662778`, -1.0411577628077384`}, \
{-0.12862045959240576`, -1.0810733909902206`}, {-0.12385169206150089`, \
-1.0970058247198804`}, {-0.11474938405767557`, -1.1099896437154984`}, \
{-0.10557326344300651`, -1.117775096036702}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.26640944795614435`, 
                  0.5224572861546092, -0.6714117978557597], 
                 
                 ArrowBox[{{-0.09698215806491708, -1.1235495767110533`}, \
{-0.08849835464880565, -1.1284454329235432`}, {-0.07321352347218925, \
-1.1349892761131164`}, {-0.05720602766722647, -1.1404484322434192`}, \
{-0.03837015662054575, -1.1458909606928798`}, {-0.01907074158306623, \
-1.1508773262946692`}, {0.0007681633270146364, -1.1556523804821928`}, {
                  0.04607251713271342, -1.165793719499313}, {
                  0.09798032324881631, -1.1736289148221255`}, {
                  0.1570080856706771, -1.1743094601257502`}, {
                  0.20708931603347744`, -1.166520114170183}, {
                  0.2555556905081495, -1.1473348061291013`}, {
                  0.295304138600818, -1.1144266135808476`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.33742170481394246`, 
                  0.5223304874547471, -0.5016963754544185], 
                 
                 ArrowBox[{{0.3019894867623137, -1.10659423229186}, {
                  0.32007673063225134`, -1.0802802030585674`}, {
                  0.3369732241161773, -1.0386511585258045`}, {
                  0.34702322975796335`, -0.983632199931703}, {
                  0.34879520762081645`, -0.9498695074490028}, {
                  0.3475405174442475, -0.9103236676841019}, {
                  0.34335784592181035`, -0.8650726063403833}, {
                  0.33864306757499524`, -0.8181579657607789}, {
                  0.33473564363975966`, -0.765758620144915}, {
                  0.3329710891801406, -0.7173852606344651}, {
                  0.3334605575596161, -0.7014557083290792}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5059794768375354, 0.5289686341417739, 
                  0.11519390932168515`], 
                 
                 ArrowBox[{{0.3337796955089504, -0.6910694916300516}, {
                  0.3356332736941121, -0.6307455322268002}, {
                  0.34578785936626, -0.5550609767700534}, {
                  0.3525871408026256, -0.5196557832632285}, {
                  0.36075810191311025`, -0.4867075762966373}, {
                  0.3713275561252079, -0.45738338734660133`}, {
                  0.3807511227954025, -0.43090762788881465`}, {
                  0.3939104941570347, -0.3899690867749841}, {
                  0.4022125247980739, -0.35525566856857643`}, {
                  0.4066150528951289, -0.32516324476256697`}, {
                  0.40624555891396935`, -0.28461413174665773`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.27439905768756606`, 
                  0.522443019995904, -0.6523170661799953], 
                 
                 ArrowBox[{{0.40615087629050745`, -0.2742234444955333}, {
                  0.4061406780729876, -0.2731042688232402}, {
                  0.39466864392030576`, -0.23132328158139484`}, {
                  0.37336595725163185`, -0.19670455528046787`}, {
                  0.3154409069510603, -0.15150116259816343`}, {
                  0.2748545267544588, -0.13424589186816077`}, {
                  0.22560474221203589`, -0.12058556331422343`}, {
                  0.16668117767928275`, -0.11067275053220998`}, {
                  0.0970734575116909, -0.10466002711797913`}, {
                  0.06485819636902607, -0.10327974280432832`}}]}}, {
                Arrowheads[{{0.006840853233110581, 1.}}], {
                 LABColor[
                 0.3669754133343102, 
                  0.5222777166799217, -0.43106462331754025`], 
                 
                 ArrowBox[{{0.05447383316289323, -0.1029094932024373}, {
                  0.02330966868982748, -0.10192963973106925`}, \
{-0.014758178157315623`, -0.1004216984009956}, {-0.0873715897059461, \
-0.09406671685266041}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.25697394231917886`, 
                  0.5224741340890398, -0.6939621419175535], 
                 
                 ArrowBox[{{-1.2901671316425865`, -1.0194359321482782`}, \
{-1.2892377181130732`, -0.9707066072515094}, {-1.3016445323590482`, \
-0.9362160470357865}, {-1.328185691113244, -0.8962427546819475}, \
{-1.368683805107044, -0.8530602050851613}, {-1.3957240007563119`, \
-0.8276478377489326}, {-1.4229648957422003`, -0.8045501767636298}, \
{-1.4798907924856248`, -0.7586954328311231}, {-1.5358749183156346`, \
-0.7123874426260637}, {-1.5393192321950309`, -0.7095002068328351}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.35010232447813944`, 
                  0.5223078450806273, -0.47139038578661346`], 
                 
                 ArrowBox[{{-1.547282576294578, -0.7028248418913453}, \
{-1.6030429252903386`, -0.6560830869001597}, {-1.6703666690509147`, \
-0.598521524800054}, {-1.7048262257161815`, -0.5718220887296475}, \
{-1.7400094960253876`, -0.5491785946710733}, {-1.7997429801441849`, \
-0.5170138375115929}, {-1.8610608718999646`, -0.496696678254279}, \
{-1.8971806323441425`, -0.4919041202097934}}]}}, {
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.32725693072012313`, 
                  0.5223486375628625, -0.5259896313693981], 
                 
                 ArrowBox[{{-1.907481471570728, -0.4905373511810613}, \
{-1.9242528181659222`, -0.4883120415152933}, {-2.0069886780641677`, \
-0.4854319409309963}, {-2.0839760895315926`, -0.4781285364986858}, \
{-2.15177513027054, -0.4607643199273635}, {-2.2089908080717358`, \
-0.43436290502438424`}, {-2.2551652464397347`, -0.40034259400663447`}, \
{-2.286347143827102, -0.36351813182515874`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.27239861164966156`, 
                  0.5224465919702078, -0.6570980231490708], 
                 
                 ArrowBox[{{-2.293062059242808, -0.355588109296201}, \
{-2.3106032968916472`, -0.33487267192587455`}, {-2.3424941171506966`, \
-0.26740181588812467`}, {-2.35231107032151, -0.20401474392617186`}, \
{-2.327303764704242, -0.11796767217812551`}, {-2.2992169093918395`, \
-0.08367184127547679}, {-2.2627024805228833`, -0.05298638434670522}, \
{-2.2198957602162293`, -0.024701937253814536`}, {-2.205415696396265, \
-0.01620314671325364}}]}}, {
                Arrowheads[{{0.013890125910196168`, 1.}}], {
                 LABColor[
                 0.25488266905801577`, 
                  0.5224778682434281, -0.6989601709984438], 
                 
                 ArrowBox[{{-2.196454129727904, -0.010943330252730681`}, \
{-2.173577527929945, 0.00248364419834972}, {-2.149767531780297, 
                  0.015654145414543436`}, {-2.1256573303908066`, 
                  0.027054548594476317`}, {-2.101322104503469, 
                  0.03440252057933382}, {-2.0767942046450365`, 
                  0.036500147188668564`}, {-2.036576496148013, 
                  0.03173511940683456}, {-1.9991696351981894`, 
                  0.022310268294942603`}, {-1.9669885405669967`, 
                  0.013644342500654653`}, {-1.9431074955828014`, 
                  0.007406146367437447}, {-1.9226692924308042`, 
                  0.0020048664953056555`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.22493738373265204`, 
                  0.5225313382134624, -0.7705277703510434], 
                 
                 ArrowBox[{{-0.8449096888787017, -0.6384460904620362}, \
{-0.8339367441754579, -0.6284183218083594}, {-0.824060103584809, \
-0.6190534834683216}, {-0.815039356837434, -0.6096767044457942}, \
{-0.8069686540011257, -0.5995894786152866}, {-0.8008027659573184, \
-0.5893592442278949}, {-0.7957159098761964, -0.576598908813619}, \
{-0.7921557838226482, -0.5592433806253553}, {-0.7909141065322137, \
-0.5409476840894002}, {-0.7918364001292082, -0.5157272159623207}, \
{-0.7966801569624333, -0.4800108179067247}, {-0.8010976770892138, \
-0.45732751478965905`}, {-0.8067275434141891, -0.4314830383061615}, \
{-0.812992240929164, -0.40319070695408576`}, {-0.8241161256559342, \
-0.34461534064558896`}, {-0.8318599104698969, -0.2859887201245433}, \
{-0.8339759823518562, -0.24511676226794443`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.39243378812489055`, 
                  0.522232258487676, -0.3702204955229942], 
                 
                 ArrowBox[{{-0.8345132441988927, -0.2347395422135376}, \
{-0.8356229521881775, -0.2133055169529287}, {-0.831549322199426, \
-0.14409957834891557`}, {-0.8234002145853536, -0.09641108695925715}, \
{-0.8104174825987763, -0.05012844174114879}, {-0.7930150712112525, \
-0.004840993283836877}, {-0.7716069253943406, 
                  0.039861907823432144`}, {-0.7473011286022246, 
                  0.0855850150254583}, {-0.7212057642890887, 
                  0.13393308176704163`}, {-0.7099343329245008, 
                  0.1546719617466328}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.4212851773301414, 0.523449805150371, -0.2621213067230701], 
                 
                 
                 ArrowBox[{{-0.7049723330916153, 
                  0.16380179767113384`}, {-0.696737239559867, 
                  0.1789539652043725}, {-0.6716358703487084, 
                  0.22672780977240797`}, {-0.652838894151711, 
                  0.2655051496046719}, {-0.6335038722313375, 
                  0.3070598428041438}, {-0.6140084212902917, 
                  0.35008691091205224`}, {-0.5941921123079006, 
                  0.3960587288368339}, {-0.56885935469538, 
                  0.46303488912632673`}, {-0.5554644126506221, 
                  0.5175880499460139}, {-0.5550402569679788, 
                  0.5480127162662723}}]}}, {
                Arrowheads[{{0.012527074363680406`, 1.}}], {
                 LABColor[
                 0.31580000042223755`, 
                  0.522369094930794, -0.5533710701655493], 
                 ArrowBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA9NKuAaDI4b9i3aoncN3hP2nTOeup
E+K/WS7kWcbP4j/SdZ4dUZjiv3eaMPode+M/7CvziSEy478U7Rsp6+zjP1cL
Kq0Z8eO/a6wWAltG5D+ZUhkPL6TkvxHx9BrXf+Q/NVc8pnJB5b/aSoTg/qfk
P4FfM1APx+W/hjdM4JfE5D8tqjImODnmv+NQgPag2OQ/5McEl1ya5r/mSCCc
IebkP8ju3R4wC+e/YfEx57Dx5D9VCpRwBmTnvxAo53A1+OQ/+0GbXNip57/3
sNgcofzkP6sa/CK78ee/zsvV4N8A5T+xk8dbOyfov0ri1MG8A+U/GELFD61P
6L+J6X5qvgXlP4T4sAdih+i/QTa6kFMI5T+GFU0BiKfov7OjVDK3CeU/AJxl
H+e66L+YEK3fpwrlP0m1aN0byOi/BjIOvYAL5T8SA67f
                  "]]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36745256363124323`, 
                  0.5222768646856327, -0.4299242601214363], 
                 
                 ArrowBox[{{-1.4282658599552593`, -1.358232344415472}, \
{-1.37617300936248, -1.359237883751074}, {-1.3001658916561625`, \
-1.3611361194683549`}, {-1.2241510661907322`, -1.3629166530695924`}, \
{-1.1481290351862272`, -1.3645871088171826`}, {-1.0721003008626846`, \
-1.3661551109735213`}, {-1.020056610803509, -1.3671274378141804`}, \
{-1.0127199266695184`, -1.3672459761483493`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36750169045872816`, 
                  0.5222767769653134, -0.4298068496820731], 
                 
                 ArrowBox[{{-1.002330164058571, -1.3674138428753093`}, \
{-0.9679231000414185, -1.367969755597971}, {-0.9150769903973667, \
-1.3681315181506901`}, {-0.8608955036923069, -1.3670621792981341`}, \
{-0.8057234310755517, -1.3651294113229753`}, {-0.7499055636964131, \
-1.3627008865078856`}, {-0.6875543462629728, -1.359565875913638}, \
{-0.6245363095779439, -1.3560740041014092`}, {-0.5870327936830657, \
-1.3537814928162542`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.38785650437353697`, 
                  0.5222404316348798, -0.38115995414162923`], 
                 
                 ArrowBox[{{-0.5766610346505425, -1.3531474889352415`}, \
{-0.5607657677636154, -1.3521758446013883`}, {-0.49615703494227664`, \
-1.3478219709437644`}, {-0.4305533292214655, -1.3429201143963203`}, \
{-0.3637978687087201, -1.3373780062268392`}, {-0.2958744844864193, \
-1.3312230747419715`}, {-0.22676700763694185`, -1.324482748248368}, \
{-0.1624125296976301, -1.319388984955596}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.39859532902766853`, 
                  0.5222212565084375, -0.35549474868393605`], 
                 
                 ArrowBox[{{-0.15203632852922513`, -1.318883134655228}, \
{-0.09413381464815873, -1.3170169948927453`}, {-0.03266073899007656, \
-1.3178265833575176`}, {0.025891148332735203`, -1.321120807467138}, {
                  0.07579123656799036, -1.3250859277189537`}, {
                  0.12570866662688107`, -1.328839557502612}, {
                  0.17603596187387466`, -1.332246510655509}, {
                  0.2263806304376604, -1.335464545486223}, {
                  0.26289362245743575`, -1.3377370949446223`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36677075845823937`, 
                  0.5222780821094033, -0.4315537373138523], 
                 
                 ArrowBox[{{0.2732646730613333, -1.3383825836906598`}, {
                  0.282307113638313, -1.3389453804459817`}, {
                  0.33825018378014726`, -1.342239295917272}, {
                  0.394209840863163, -1.3453462919000938`}, {
                  0.4501860848873604, -1.3482663683944474`}, {
                  0.5061789158527393, -1.3509995254003324`}, {
                  0.5621883337593, -1.353545762917749}, {
                  0.6182143386070421, -1.3559050809466975`}, {
                  0.6742569303959658, -1.358077479487177}, {
                  0.6884072837674666, -1.3585875736006157`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3669337971452557, 0.5222777909893282, -0.4311640837405243], 
                 ArrowBox[{{0.6987916574984916, -1.3589619111010918`}, {
                  0.7303133761596947, -1.3600982108607098`}, {
                  0.7863809429318522, -1.3620025273888168`}, {
                  0.8424596307124386, -1.363790429071498}, {
                  0.8985494395014535, -1.3654619159087533`}, {
                  0.9546503692988973, -1.3670169879005833`}, {
                  1.0107624201047698`, -1.3684556450469878`}, {
                  1.0668855919190705`, -1.3697778873479656`}, {
                  1.1142637128372497`, -1.370795622427947}}]}}, {
                Arrowheads[{{0.013024268141605812`, 1.}}], {
                 LABColor[
                 0.36712695826760056`, 
                  0.5222774460829662, -0.43070243918899387`], 
                 
                 ArrowBox[{{1.1246524133379223`, -1.371019771970523}, {
                  1.1294913680118566`, -1.3711266485037867`}, {
                  1.1359629668275013`, -1.371268405806634}, {
                  1.1424346810994288`, -1.3714089929611724`}, {
                  1.1489065107496146`, -1.3715484161402698`}, {
                  1.1553784557250666`, -1.3716866813861401`}, {
                  1.1683225778137778`, -1.3719609016289214`}, {
                  1.1812671649271635`, -1.3722305215946042`}, {
                  1.1942122208647397`, -1.372495572296059}, {
                  1.2589798858207146`, -1.3734809652911801`}, {
                  1.3238299619396423`, -1.3738094296228873`}, {
                  1.388164103114676, -1.3780244475142207`}, {
                  1.3950279682672746`, -1.3793973379808409`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1957464752833431, 0.5225834611764966, -0.8402924500974429], 
                 
                 ArrowBox[{{1.8318828732259265`, -0.15567637686738015`}, {
                  1.8281826534381946`, -0.15866612573390723`}, {
                  1.823475117394196, -0.16296505363332833`}, {
                  1.8165856541868384`, -0.16967991712786168`}, {
                  1.8061429227419834`, -0.18007355599030336`}, {
                  1.7917187163714192`, -0.1941718451752051}, {
                  1.769444585448407, -0.2147441207471703}, {
                  1.7313224545031025`, -0.24623194554748276`}, {
                  1.692594266739533, -0.2749303132548981}, {
                  1.6364763371950797`, -0.3135737190690733}, {
                  1.5664776328779162`, -0.3622752905016969}, {
                  1.5293725936707856`, -0.38884539131981616`}, {
                  1.5038210410736739`, -0.4096866712804224}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.4916225186647004, 0.528033109585181, 
                  0.051233302690115765`], 
                 
                 ArrowBox[{{1.4958485243376112`, -0.4163402626657208}, {
                  1.4835444200210222`, -0.4293686269649098}, {
                  1.4715996836224947`, -0.44305256205844773`}, {
                  1.4608899588494328`, -0.45655629825065536`}, {
                  1.4510557836861153`, -0.4698651861899695}, {
                  1.4419401230364532`, -0.4829054624618591}, {
                  1.4247492676795188`, -0.5082133018771701}, {
                  1.4091425575996375`, -0.5320633677752581}, {
                  1.394167417042385, -0.5547358722110007}, {
                  1.349268103337752, -0.6143699834438674}, {
                  1.287963538630131, -0.6713179922445502}, {
                  1.2480842621160986`, -0.6990235444483106}, {
                  1.216252246138696, -0.7173266361503389}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.5008578009102251, 0.5286348967620846, 0.09237671536336463], 
                 
                 ArrowBox[{{1.2072440810795055`, -0.7225062412140715}, {
                  1.2010965995440415`, -0.7260409817834405}, {
                  1.147173891747757, -0.7516307761724783}, {
                  1.0874960468619366`, -0.774390145342527}, {
                  1.0580815206872132`, -0.7833470015655645}, {
                  1.0300874838889047`, -0.7896690939711696}, {
                  1.002802191792858, -0.7929900342689331}, {
                  0.9527711758412397, -0.7885820397053399}, {
                  0.9099734975846934, -0.7709485928741395}, {
                  0.8741845421163748, -0.744641047698726}, {
                  0.8366012411217383, -0.7016111175954484}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.42089107975441054`, 
                  0.5234241250616396, -0.2638770212492482], 
                 
                 ArrowBox[{{0.8297656375528483, -0.6937848879668953}, {
                  0.8271432557866318, -0.6907824666489673}, {
                  0.7940257440941437, -0.6394112965806438}, {
                  0.7707029065381927, -0.5937534258609484}, {
                  0.7539087470758803, -0.5550932327883544}, {
                  0.7331060212012744, -0.4997360948458766}, {
                  0.7208790526746807, -0.46441295556229273`}, {
                  0.7137805282129188, -0.4397979999414748}, {
                  0.7094818805907838, -0.4204083451776024}, {
                  0.7051153799484328, -0.3958014782634208}, {
                  0.7010259089967674, -0.3732184604831171}, {
                  0.6968325619855037, -0.3509719916936368}, {
                  0.6925908626560386, -0.3280679562312816}, {
                  0.6880117259446364, -0.307318110464759}}]}}, {
                Arrowheads[{{0.019665133325605214`, 1.}}], {
                 LABColor[
                 0.21633291605593058`, 
                  0.5225467022557094, -0.7910919789948799], 
                 
                 ArrowBox[{{0.685772462409353, -0.2971711382479145}, {
                  0.6776855123843909, -0.26052602884952036`}, {
                  0.6557523622475635, -0.203418571414833}, {
                  0.6202674678344585, -0.16713174918199186`}, {
                  0.606194207682588, -0.16043428093476203`}, {
                  0.5896215490241759, -0.15440919533284156`}, {
                  0.5697766739279158, -0.1482860758256028}, {
                  0.5156671296820798, -0.1336029549955687}, {
                  0.4304494158156674, -0.11329324070073343`}, {
                  0.36993898340823456`, -0.10190790842073295`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3640638560300655, 0.5222829155244183, -0.4380230865406583], 
                 
                 ArrowBox[{{0.21275470080847414`, -1.0318358860251367`}, {
                  0.20826772784129158`, -0.9823039063176967}, {
                  0.19028445615155565`, -0.9215048191090295}, {
                  0.15679771368518922`, -0.8568052184318979}, {
                  0.12219070067837245`, -0.8061774355271554}, {
                  0.08932842682048664, -0.7642994139366167}, {
                  0.04403083273286052, -0.7131250573275715}, {
                  0.012026375431010095`, -0.6790410499745618}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3278216792475636, 0.5223476291541427, -0.5246399131781142], 
                 
                 ArrowBox[{{
                  0.004902113148790068, -0.6714766722211656}, \
{-0.021859774373768237`, -0.6432094442099239}, {-0.04813948138749989, \
-0.6144655571362597}, {-0.0689093146332401, -0.5894873805174867}, \
{-0.08475477637939909, -0.5661563372682771}, {-0.0927981281578262, \
-0.5523604023046413}, {-0.0992442308861499, -0.5384681182012635}, \
{-0.09978316827462988, -0.5368544688195437}, {-0.10142693534249023`, \
-0.5311951331780147}, {-0.10253276855151215`, -0.5263007353118304}, \
{-0.10337418934801827`, -0.5212104276221523}, {-0.10282278753012272`, \
-0.4950974637290915}, {-0.09385344399704533, -0.461015245772859}, \
{-0.07755241252128547, -0.41857569349785584`}, {-0.0616975981529303, \
-0.3730993231882272}, {-0.05384697024220145, -0.33114331360348287`}, \
{-0.055320618652404875`, -0.30082048578864506`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.29554177814163346`, 
                  0.5224052677882746, -0.6017871169662847], 
                 
                 ArrowBox[{{-0.05739864532079104, -0.2908155237493649}, \
{-0.07813638119367929, -0.2441279686555163}, {-0.11859894867463405`, \
-0.20542152390648508`}, {-0.16766833431299763`, -0.1724760536287324}, \
{-0.20902890181168857`, -0.14593075766650415`}, {-0.24613103109272175`, \
-0.11477954564825342`}, {-0.2752322372772641, -0.07507269344730172}, \
{-0.2948179164987066, -0.023846434818843545`}, {-0.3021936441776411, 
                  0.023378023789246204`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.34963685323092775`, 
                  0.5223086762209345, -0.47250283669060894`], 
                 
                 ArrowBox[{{-0.30379713604656394`, 
                  0.03364467661166904}, {-0.3049662119163222, 
                  0.04112990077182834}, {-0.3084619542213784, 
                  0.12086090920838641`}, {-0.3081313894468269, 
                  0.16692313897381322`}, {-0.3065946044007831, 
                  0.21768748245233488`}, {-0.30400390508546304`, 
                  0.27349175481115895`}, {-0.30051159750308243`, 
                  0.3346737712174932}, {-0.29799250150561896`, 
                  0.37366441448013216`}, {-0.29509114966581684`, 
                  0.4146692821537746}, {-0.2925088930753095, 
                  0.4486561779131775}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.5195855564832659, 0.5298552301375485, 
                  0.17580933339285026`], 
                 
                 ArrowBox[{{-0.29175121237117624`, 
                  0.4590194796095841}, {-0.2898956379069271, 
                  0.48869835937075407`}, {-0.28880184625888, 
                  0.5177370987561438}, {-0.2882843818391597, 
                  0.5703532687079594}, {-0.29084504678496687`, 
                  0.6127949784364282}, {-0.29602488599818483`, 
                  0.6465567830089213}, {-0.3268260949551183, 
                  0.7073994452760036}, {-0.38316468559308753`, 
                  0.7230206180194977}, {-0.4243103384056423, 
                  0.7162806508434012}, {-0.47431853533028245`, 
                  0.7012350328214784}, {-0.48090504120641836`, 
                  0.6989289506586299}}]}}, {
                Arrowheads[{{0.0018945154491367168`, 1.}}], {
                 LABColor[
                 0.36042996519438747`, 
                  0.5222894041596735, -0.4467078875232895], 
                 
                 ArrowBox[{{-0.4907124115036686, 
                  0.6954951722437526}, {-0.5016565288750998, 
                  0.6916633934018298}, {-0.5279416842516584, 
                  0.6826835235273973}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.25889214675901784`, 
                  0.5224707089644233, -0.6893777378841581], 
                 
                 ArrowBox[{{1.2922111179840778`, 0.35100553297567666`}, {
                  1.302483894224064, 0.3782022685664044}, {
                  1.3114174642683143`, 0.39271814226928675`}, {
                  1.3228194653674448`, 0.40364097704307356`}, {
                  1.3392412477879823`, 0.41184508931391717`}, {
                  1.3653061117600909`, 0.41816831383352165`}, {
                  1.4108525477465064`, 0.4237860453162701}, {
                  1.4942069517828784`, 0.4289271532209845}, {
                  1.552936291426656, 0.4307842323981001}, {
                  1.6282562101670013`, 0.43148080757670393`}, {
                  1.6732890649113703`, 0.4295537643880663}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.6658124089755509, 0.48929335396332346`, 
                  0.7440252537133614], 
                 
                 ArrowBox[{{1.6836706827370305`, 0.42910951482779436`}, {
                  1.704934101449632, 0.42819961190403194`}, {
                  1.7397434505225409`, 0.42496656178066033`}, {
                  1.7711252505159647`, 0.42028325392929716`}, {
                  1.7970865885958638`, 0.4130859564481381}, {
                  1.8206148101619417`, 0.40495931387147177`}, {
                  1.8632515792032691`, 0.3874949221598543}, {
                  1.8980124903501776`, 0.36852523464398734`}, {
                  1.9269800867630191`, 0.3496003158661568}, {
                  1.9753962396807578`, 0.31231777376886555`}, {
                  2.0138113889607188`, 0.282222128885673}, {
                  2.0454070616153426`, 0.2586801124021367}, {
                  2.050652711920687, 0.255274272647372}}]}}, {
                Arrowheads[{{0.00888165405295055, 1.}}], {
                 LABColor[
                 0.28289711856746336`, 
                  0.5224278459524556, -0.6320071639794191], 
                 
                 ArrowBox[{{2.05936798773238, 0.2496157115338035}, {
                  2.0729121587634447`, 0.24082189695261927`}, {
                  2.1264804360229363`, 0.21561638915195996`}, {
                  2.1777762535477336`, 0.2025180636274263}, {
                  2.233651956379396, 0.19571483818916163`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1979432024048675, 0.5225795387248623, -0.8350423920394858], 
                 ArrowBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAArc5B79549D9DI056WFPgP1f3JxnA
cvQ/GMaHtrmT4D+hO9rJ3Wz0P7a0ZdSF2eA/oOG7/Jxm9D8lIHbSwjDhP8eI
dwg8YfQ/ze9LN0iP4T8kXXLCHF30P7es78r99OE/3LZlUKha9D/jJ8jvnm3i
P8Thd6dFW/Q/dFLt1VPu4j9kLFVzBGD0P/ShRVuGduM/prPWNKpr9D/+9oTP
JhTkP/wXBTIKgPQ/jOv9+uK45D+CDNQLMp/0Pxn4Flm5Y+U/Ebvx/JXJ9D9Z
31ugmA/mP60O3ORUAPU/O06ka1LA5j9ZAT+MzEH1PxEYzeZqduc/AD9A2ZF2
9T8uLdGnlQDoP8LONf3nq/U/WseJqi+P6D/X5BnYRt71PzZzEHy5Iuk/DFnX
ml4E9j9dYLO/EqXpPw7rh7PEI/Y/rhle5yEr6j+TDDITJj32P4bJMjzfs+o/
VspmoqdU9j8GXs8uT1XrP0wOdUaeZPY/d1YZ/yH16z83x8etuG72P+g7FNkl
j+w/IYnYfshu9j/c0Zcv3Y/sP/W807s=
                  "]]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.20976869142822333`, 
                  0.5225584232625501, -0.8067801179827662], 
                 
                 ArrowBox[{{1.403813464656615, 0.9028013390306202}, {
                  1.4052088387912274`, 0.9108885393402698}, {
                  1.4114047032142996`, 0.9273569256694824}, {
                  1.4226599917001348`, 0.94132770960149}, {
                  1.4376597105625533`, 0.9505030323164746}, {
                  1.4609077380070126`, 0.9565828898134933}, {
                  1.4984282713219994`, 0.9578244704588046}, {1.52457625552925,
                   0.9561161235907487}, {1.5561972265336232`, 
                  0.9529361817650913}, {1.5928832757412708`, 
                  0.9487335262327676}, {1.6735772594097058`, 
                  0.9412700182057587}, {1.7592414830252128`, 
                  0.9372281305023364}, {1.7768713517430215`, 
                  0.9367619149940106}, {1.7902735751398395`, 
                  0.9365729008002125}}]}}, {
                Arrowheads[{{0.015589494874925516`, 1.}}], {
                 LABColor[
                 0.33773369342373155`, 
                  0.5223299303713387, -0.5009507396862046], 
                 
                 ArrowBox[{{1.8006642679962426`, 0.936510664403336}, {
                  1.8015738797080965`, 0.936510664403336}, {
                  1.8037592329408247`, 0.936510664403336}, {1.805944586173553,
                   0.936510664403336}, {1.8670812997277995`, 
                  0.936510664403336}, {1.928218013282046, 
                  0.936510664403336}, {1.9936949585884263`, 
                  0.936510664403336}, {2.060610606306324, 
                  0.9365106644033359}, {2.124648849201187, 
                  0.9365106644033359}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.22339457400866636`, 
                  0.5225340930374294, -0.7742150014795436], 
                 
                 ArrowBox[{{1.8634464207133243`, -0.2862106185034364}, {
                  1.8786663399563648`, -0.2892192818739126}, {
                  1.9004992943594439`, -0.28698361029231195`}, {
                  1.9282676984013762`, -0.2777781288462722}, {
                  1.9511911309225936`, -0.2658175943357089}, {
                  1.9740998556254816`, -0.24940812923723535`}, {
                  1.995168620794452, -0.2289502805750147}, {
                  2.0050269309528757`, -0.217781946691828}, {
                  2.013980352722218, -0.2057907439595237}, {
                  2.0264957677104385`, -0.17532683454298473`}, {
                  2.033839707942932, -0.14392357829727476`}, {
                  2.039079357620466, -0.08234908600715626}, {
                  2.027767510874151, -0.02156157765625198}, {
                  2.0130167374412884`, 0.022906820817631044`}}]}}, {
                Arrowheads[{{0.007389584074092327, 1.}}], {
                 LABColor[
                 0.2689636567109937, 0.5224527253877272, -0.665307378183554], 
                 
                 
                 ArrowBox[{{2.009824184845599, 0.03279303008074613}, {
                  1.9999329718532404`, 0.07014466443738501}, {
                  1.9999980984796681`, 0.09544740895315645}, {
                  2.0066061964773634`, 0.11278749747294961`}, {
                  2.016372370585747, 0.12506956218854223`}, {
                  2.0286591427523972`, 0.13495228798924344`}, {
                  2.043120913204222, 0.1431569021774765}, {2.064365724454762, 
                  0.15193484101253185`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2162177431871195, 0.5225469079071092, -0.7913672358722749], 
                 
                 ArrowBox[{{-1.2904145354534655`, -0.025777992649403968`}, \
{-1.3010333592530987`, -0.0020438231236712626`}, {-1.3053302753488203`, 
                  0.014900943141397633`}, {-1.308155315328491, 
                  0.03283062000851909}, {-1.3101941953039693`, 
                  0.05136031441781898}, {-1.3203318408575562`, 
                  0.13228977910208023`}, {-1.3280291318875619`, 
                  0.17782119544458364`}, {-1.3381939197897759`, 
                  0.22742609990572288`}, {-1.3488027009634025`, 
                  0.2723660872958118}, {-1.361811537312759, 
                  0.32129669074437006`}, {-1.378654314494176, 
                  0.3756720105050902}, {-1.3798188750992737`, 
                  0.37872244303495783`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2505410434650744, 0.5224856206020326, -0.7093364194662266], 
                 
                 ArrowBox[{{-1.3835249867628274`, 
                  0.38843017617339626`}, {-1.3953463087276925`, 
                  0.4193947690935224}, {-1.419311899794942, 
                  0.4721026753787329}, {-1.44853664929506, 
                  0.5413977854903534}, {-1.4651024224118923`, 
                  0.5984337449920917}, {-1.4770387027273164`, 
                  0.6696531408224398}, {-1.4820221196347863`, 
                  0.7332492658861577}, {-1.4824351260505764`, 
                  0.787245031362288}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.4193644098223191, 0.5234225765343644, -0.2676575327645945], 
                 
                 ArrowBox[{{-1.4825146040075625`, 
                  0.7976358460370003}, {-1.4825859779235817`, 
                  0.8069671520001591}, {-1.4790527948720533`, 
                  0.8871637905247896}, {-1.4763375496954885`, 
                  0.9279245341898963}, {-1.4733348383541476`, 
                  0.9637389108058411}, {-1.4712591310670402`, 
                  0.9836963295484135}, {-1.4691941827993342`, 
                  1.001913668616326}, {-1.4650852362808107`, 
                  1.0352428370353186`}, {-1.461077496722466, 
                  1.0629567423513087`}, {-1.4572722699102918`, 
                  1.086114242770048}, {-1.4478793206175915`, 
                  1.1334742634247714`}, {-1.441246064958029, 
                  1.1637124835372643`}, {-1.4367726927092215`, 
                  1.183526942051398}, {-1.4336741948152867`, 
                  1.1966274184541066`}, {-1.43172894147049, 
                  1.2053743870414577`}, {-1.430999692843506, 
                  1.2091255310445987`}}]}}, {
                Arrowheads[{{0.00032168183799009527`, 1.}}], {
                 LABColor[
                 0.19225210023807754`, 
                  0.5225897006939006, -0.8486438159471936], 
                 
                 ArrowBox[{{-1.4293635926852806`, 
                  1.21938404244781}, {-1.4292681809699697`, 
                  1.220117979788961}, {-1.4290515108748092`, 
                  1.2227344387813723`}, {-1.4289556750621215`, 
                  1.2243510515541494`}, {-1.4288637000168019`, 
                  1.2260488513809145`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.244082901922017, 0.5224971521880913, -0.7247710256653008], 
                 
                 
                 ArrowBox[{{-1.5454250455885374`, -1.0703908218369307`}, \
{-1.5205360296723176`, -1.0201505359006704`}, {-1.5285094482998987`, \
-0.9868863612350728}, {-1.5530596222418818`, -0.9460318122400228}, \
{-1.5982555684397222`, -0.8965334303633279}, {-1.6073455712102784`, \
-0.8880670113050313}, {-1.617095010532791, -0.8794288342423373}, \
{-1.6274816667927072`, -0.8704176807941251}, {-1.6860703913571526`, \
-0.8323531100446891}, {-1.7541903785375272`, -0.8109677806046931}, \
{-1.7843687033338538`, -0.8094838519121503}}]}}, {
                Arrowheads[{{0.01878263750471728, 1.}}], {
                 LABColor[
                 0.3873228608841902, 0.5222413845027878, -0.3824353329876724], 
                 
                 ArrowBox[{{-1.7947472824273143`, -0.8089735163846301}, \
{-1.8321758353928264`, -0.8071330794471683}, {-1.8738610813170562`, \
-0.809958729148336}, {-1.9178851921510385`, -0.8167969196665497}, \
{-2.0049380331273343`, -0.8353595647557281}, {-2.0598166455753, \
-0.8480083464685}, {-2.1154074247293853`, -0.8611562776577963}, \
{-2.150361168880918, -0.8696158954859737}, {-2.1779409353112213`, \
-0.8751208967934848}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19705434590023257`, 
                  0.5225811258571988, -0.8371667106263515], 
                 
                 ArrowBox[{{0.6951420964085137, 0.011181223133700634`}, {
                  0.6849810802790083, 0.02401245463055547}, {
                  0.6603082867974441, 0.038796602468524594`}, {
                  0.6126676442435841, 0.05501838833747919}, {
                  0.5760220329414859, 0.06490459074005642}, {
                  0.5301018824493268, 0.07636230730568866}, {
                  0.47556455631816336`, 0.09059064778780468}, {
                  0.4259344456457189, 0.10556066268946625`}, {
                  0.3745939105727062, 0.12595385063354825`}, {
                  0.323511302399727, 0.15666380715536604`}, {
                  0.31552724091857026`, 0.16542957722675922`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.30381081521058956`, 
                  0.5223905026872083, -0.5820245691878002], 
                 ArrowBox[{{0.30853013762590425`, 0.17311175737705686`}, {
                  0.27747674782882925`, 0.20720554229353644`}, {
                  0.2638233692751112, 0.23564681994888603`}, {
                  0.25382390415868594`, 0.2705558572047339}, {
                  0.24877892485560224`, 0.31300290669372366`}, {
                  0.24766954750444511`, 0.33623481871925076`}, {
                  0.24813474189833043`, 0.36157834525280985`}, {
                  0.25210457761539246`, 0.38992937614051987`}, {
                  0.25796264668192326`, 0.41998520179658466`}, {
                  0.270181543858342, 0.4783716147506311}, {0.2807517007595804,
                   0.5309159967804854}, {0.28598189231275056`, 
                  0.5683702333920309}}]}}, {
                Arrowheads[{{0.013813026278761594`, 1.}}], {
                 LABColor[
                 0.38439136555015313`, 
                  0.5222466189484096, -0.3894414470150008], 
                 
                 ArrowBox[{{0.2871678535963011, 0.578683071966251}, {
                  0.2894334003159152, 0.648035769578713}, {
                  0.28172929290069143`, 0.7031511458201173}, {
                  0.26627209759208115`, 0.7439668843020925}, {
                  0.22349621036838943`, 0.7890859913599206}, {
                  0.1714520005682779, 0.81031362895605}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.20453601462151164`, 
                  0.5225677666723394, -0.8192859302725957], 
                 
                 ArrowBox[{{0.7818478166614065, 1.196813471871301}, {
                  0.7918408860823712, 1.2007306854228932`}, {
                  0.8108747857731419, 1.205618001873415}, {0.8525823237603295,
                   1.197254847054767}, {0.8948299890418083, 
                  1.1518874507717365`}, {0.9270504651132019, 
                  1.077777930455328}, {0.9418631907474228, 
                  1.0316544101297995`}, {0.9530756245284643, 
                  0.9863375748020303}, {0.9563669353585722, 
                  0.9654093013862497}, {0.9588512816611334, 
                  0.9454135298563096}, {0.9622411110257733, 
                  0.9074030029975396}, {0.9622736306223743, 
                  0.8821074931373963}}]}}, {
                Arrowheads[{{0.012624085809408325`, 1.}}], {
                 LABColor[
                 0.27920246416511285`, 
                  0.5224344430864631, -0.640837186573653], 
                 
                 ArrowBox[{{0.962101867102312, 0.8717277345715488}, {
                  0.9584262485350803, 0.8421823343266089}, {
                  0.9322318377956218, 0.7783444043885932}, {
                  0.8809048015878432, 0.7183042116909311}, {
                  0.8099505633656399, 0.6722478737549774}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.2491609382072475, 0.5224880849027056, -0.7126347957910268], 
                 
                 ArrowBox[{{-0.19793606528554786`, -0.48116780721246527`}, \
{-0.2228917272417787, -0.48318231795756844`}, {-0.25509547090543105`, \
-0.4963328083105882}, {-0.29970157832359645`, -0.527351516520979}, \
{-0.3530364447981533, -0.5782333826056961}, {-0.3815977409635137, \
-0.6115412016132076}, {-0.41116211626782717`, -0.6509371136479993}, \
{-0.4417188404357689, -0.6974579234240853}, {-0.473489938667839, \
-0.7525340664005475}, {-0.4805412293561421, -0.7662306789976269}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.6748854050710672, 0.46860406705636337`, 
                  0.7490866993236412], 
                 
                 ArrowBox[{{-0.48529749032928976`, -0.7754693654792203}, \
{-0.5084539427617735, -0.8204490680770082}, {-0.542379237427034, \
-0.8964639328991357}, {-0.5470558832968349, -0.908641500159345}, \
{-0.5511104682124008, -0.9202142249226849}, {-0.5545956320189458, \
-0.9312240141968092}, {-0.5552279690521158, -0.9333613015342002}, \
{-0.5558412306874907, -0.935479264919665}, {-0.5562889735548722, \
-0.937055327218157}, {-0.5604274243412889, -0.9558124661094137}, \
{-0.5631791623350724, -0.9730554385599478}, {-0.566312655113833, \
-1.0048456859487154`}, {-0.5653020064799634, -1.0317861960044654`}, \
{-0.5611294882163783, -1.0548011039908405`}, {-0.5407882381846904, \
-1.0995914249421892`}, {-0.5099542095214897, -1.1301633774739095`}, \
{-0.4858997147966735, -1.1430899661829468`}}]}}, {
                Arrowheads[{{0.01414740383807972, 1.}}], {
                 LABColor[
                 0.3630850952375364, 0.5222846631888562, -0.4403622714741351], 
                 
                 ArrowBox[{{-0.47674653523471344`, -1.1480087719583745`}, \
{-0.4715486022329701, -1.1508020770275242`}, {-0.4249421181508218, \
-1.1648492860127344`}, {-0.3742798293180409, -1.1736907967878623`}, \
{-0.321357027704797, -1.1793305172220188`}, {-0.25386856567432237`, \
-1.183403714725615}, {-0.1867096882542269, -1.1848592845390389`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.19776737404951258`, 
                  0.5225798526820276, -0.8354626122228684], 
                 
                 ArrowBox[{{-0.8143021794060818, 
                  1.2218723079222726`}, {-0.8123672839192768, 
                  1.2193990112715902`}, {-0.8090069204461183, 
                  1.2155998198029192`}, {-0.8029140762551884, 
                  1.2094597636657534`}, {-0.7914289347276815, 
                  1.1990012962852359`}, {-0.7711791189049998, 
                  1.1811527806170496`}, {-0.750546623285641, 
                  1.1619624888089561`}, {-0.7263418690065222, 
                  1.1359059121835782`}, {-0.7025699005375077, 
                  1.1026918223018893`}, {-0.6914368861564442, 
                  1.084337783648341}, {-0.6820727319864066, 
                  1.0644226073641774`}, {-0.678350385210598, 
                  1.0421570187803202`}, {-0.677808035373161, 
                  1.0193257609854063`}, {-0.6826592298441482, 
                  0.973054067139236}, {-0.6980468262241528, 
                  0.9266695849195983}, {-0.7200103114676367, 
                  0.8824058444334156}, {-0.7289809383115691, 
                  0.8668292031662806}}]}}, {
                Arrowheads[{{0.005287773041992017, 1.}}], {
                 LABColor[
                 0.4101171613824279, 0.5239341663361503, -0.2744866149854904], 
                 
                 ArrowBox[{{-0.7341667171941358, 
                  0.8578245908075508}, {-0.753044985521482, 
                  0.8250442713721604}, {-0.7711201007031239, 
                  0.7868223695633075}, {-0.7821389318559008, 
                  0.7591519021431611}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.0031469740121606617`, 1.}}], {
                 LABColor[
                 0.5093154963429996, 0.5291860150194684, 
                  0.13005595939772158`], 
                 
                 ArrowBox[{{-1.9320706520873907`, 
                  1.0828672210314725`}, {-1.8725072899795712`, 
                  1.0686045619338989`}, {-1.8704313158318873`, 
                  1.0681074625339322`}, {-1.8684675155304862`, 
                  1.0676372235607878`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.7454101402859695, 0.30778547245566934`, 0.7884295038076], 
                 
                 ArrowBox[{{-2.2745063234236422`, 
                  0.7709674008730931}, {-2.238422330603371, 
                  0.7830838410630351}, {-2.179012693133939, 
                  0.8023275082215727}, {-2.123444197787761, 
                  0.817615159260604}, {-2.0688082532569743`, 
                  0.8279623924678882}, {-2.017471295588868, 
                  0.8328965936931856}, {-1.9717997608307327`, 
                  0.8319451487862572}, {-1.8960909542833293`, 
                  0.817815344047046}, {-1.8692627774326966`, 
                  0.8112449893786845}}]}}, {
                Arrowheads[{{0.01977768261864233, 1.}}], {
                 LABColor[
                 0.4596691029464338, 0.5259509690153198, -0.0911199610505341], 
                 
                 ArrowBox[{{-1.8591699282639742`, 
                  0.8087732001467144}, {-1.8359111967689543`, 
                  0.8030770204953988}, {-1.7838413499308785`, 
                  0.8053717477054849}, {-1.7762567093925283`, 
                  0.8077528291241515}, {-1.7687271680078578`, 
                  0.8107199946080451}, {-1.7604904838931044`, 
                  0.8146745855947882}, {-1.7586234411202286`, 
                  0.8156748963067559}, {-1.7571306372231685`, 
                  0.8165003076458375}, {-1.7557248884565468`, 
                  0.8173062262358955}, {-1.7539682856707939`, 
                  0.8183418415106276}, {-1.7462418919331137`, 
                  0.8233092671975693}, {-1.7392142001066424`, 
                  0.8284134129045394}, {-1.7321745017143688`, 
                  0.8340757506201032}, {-1.6902721587677472`, 
                  0.8774596260006869}, {-1.649604280192144, 
                  0.9307199883840862}, {-1.6133709321675807`, 
                  0.9813432371675658}, {-1.5633854376020504`, 
                  1.0510894550404135`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.21281730025130466`, 
                  0.5225529797003783, -0.7994941091014856], 
                 
                 ArrowBox[{{-0.8815839556382834, 
                  1.3004584163459656`}, {-0.8887074788016484, 
                  1.2951084558637573`}, {-0.9007062378794525, 
                  1.2884772044762483`}, {-0.9203765758094283, 
                  1.2797566571262458`}, {-0.9442048568630719, 
                  1.2705695202730913`}, {-0.980368658450065, 
                  1.2578798974798382`}, {-1.031538520097613, 
                  1.241176528625745}, {-1.1035917606859607`, 
                  1.2214457066248345`}, {-1.1346498440731037`, 
                  1.214696830592457}, {-1.161106760961808, 
                  1.2106922421837822`}, {-1.191346077648871, 
                  1.2108200866422745`}, {-1.2178361812701568`, 
                  1.2132912208477735`}, {-1.2650776805770927`, 
                  1.2186121188367163`}, {-1.2811035255469503`, 
                  1.2208926540177136`}}]}}, {
                Arrowheads[{{0.0017915680686370495`, 1.}}], {
                 LABColor[
                 0.25823988334632497`, 
                  0.5224718736387535, -0.6909366118800063], 
                 
                 ArrowBox[{{-1.2913910039188492`, 
                  1.2223565990636687`}, {-1.3012363934554922`, 
                  1.223757633283778}, {-1.328212045492005, 
                  1.2278760025463953`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2465578898074133, 0.5224927328771171, -0.7188559395520773], 
                 
                 ArrowBox[{{-1.165774461918939, 
                  0.6098232502813477}, {-1.165417519932498, 
                  0.6805246055887513}, {-1.1657525440656682`, 
                  0.7661976173367194}, {-1.165585735745351, 
                  0.8067065027230363}, {-1.1655751956704563`, 
                  0.8502343897400653}, {-1.1688263400542662`, 
                  0.8941879766042933}, {-1.171905987943261, 
                  0.9156973321224883}, {-1.1773893407698914`, 
                  0.9356879223984225}, {-1.189935655267461, 
                  0.954295182880794}, {-1.2056487565528509`, 
                  0.9715937478097207}, {-1.237460483926371, 
                  1.0003593240957929`}}]}}, {
                Arrowheads[{{0.004611088924652203, 1.}}], {
                 LABColor[
                 0.2896373473769779, 0.5224158106744962, -0.6158983845925149], 
                 
                 ArrowBox[{{-1.245598780538241, 
                  1.0067790436545656`}, {-1.2835909459092847`, 
                  1.0324765776073117`}, {-1.3259377153971512`, 
                  1.0589896314268457`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.019926197812345735`, 1.}}], {
                 LABColor[
                 0.2628121103635296, 0.5224637095207982, -0.6800092385803012], 
                 
                 ArrowBox[{{-0.8522240030560234, 
                  1.098967210521785}, {-0.8763704972869959, 
                  1.0575905639742458`}, {-0.9071250159977149, 
                  1.0209223607019393`}, {-0.923559115070808, 
                  1.004357048631103}, {-0.9392384195161144, 
                  0.9902646048905943}, {-0.9551283665493113, 
                  0.9804534161938004}, {-0.9698006345867188, 
                  0.9743983642982539}, {-0.997016220611954, 
                  0.9697109850229937}, {-1.0225545065469097`, 
                  0.9779783542399185}, {-1.0528608106255801`, 
                  0.995181870980552}, {-1.087844254685661, 
                  1.0146350094465186`}, {-1.1331722026349873`, 
                  1.0374460749896062`}, {-1.1870061162670875`, 
                  1.062318190475508}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.003675548863957351, 1.}}], {
                 LABColor[
                 0.37329379571531446`, 
                  0.5222664346462758, -0.41596403389629905`], 
                 
                 ArrowBox[{{-1.6241838924320917`, 
                  1.2327625076564828`}, {-1.5911318892504387`, 
                  1.2299632038632229`}, {-1.5480051431821282`, 
                  1.2271903487459936`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02000000000000001, 1.}}], {
                 LABColor[
                 0.24414662850822616`, 
                  0.5224970383986044, -0.7246187225985452], 
                 ArrowBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAApXKSLQDjAcCo26AH3ZfcP2JJ8LJA
GALAoj6QcW3u3D+8EaLeq0ECwKCO6dhozN0/qUo39o9lAsAcTYqnGrHeP6jz
RkADhALAW28fnQ1p3z/avqk2MKMCwOhKiBptAeA/DT3nd0bBAsCXQS/a3Szg
P9C53+fC4wLAfrRKtX4y4D/g5+opJwQDwKliKyaMGOA/5ySFh2UvA8COFEHG
fbffP+yME4ePawPAypJhQ+Tc3j8tiubZnpsDwOYqIEOzGN4/EG+pvHXWA8Ao
5C5dKhjdP2Jx/R+AHQTA3PfsctnP2z+XlF/hL0QEwApPMS5XGNs/j7Cp/FNt
BMBeBkHpuE3aP9QGF4AcmATAP3V6g6Jn2T8PN1hHpcIEwPl8HTBMfdg/19oI
mkzPBMDE2vwgnTbYP6PslJI=
                  "]]}}, {
                Arrowheads[{{0.0021550323874617687`, 1.}}], {
                 LABColor[
                 0.492378955008534, 0.528082400303078, 0.054603245462625113`], 
                 
                 ArrowBox[{{-2.6097400285795813`, 
                  0.3723844117722507}, {-2.6201357857791283`, 
                  0.3651254937678062}, {-2.626368732644504, 
                  0.3607677542113198}, {-2.6325578031664283`, 
                  0.3564383853430699}, {-2.6464459602212305`, 
                  0.3467232459399122}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01052634556552145, 1.}}], {
                 LABColor[
                 0.20434068654839715`, 
                  0.5225681154479848, -0.8197527537183262], 
                 
                 ArrowBox[{{-2.387303917095061, 
                  0.15698781402444842`}, {-2.4006515620219067`, 
                  0.16124586707343014`}, {-2.4265924760859283`, 
                  0.15993358966096674`}, {-2.4584025127734592`, 
                  0.149615426610144}, {-2.4922397538489927`, 
                  0.13144060649075867`}, {-2.520885495585075, 
                  0.11077094768808213`}, {-2.5441576027002384`, 
                  0.08987115151418745}, {-2.5596287782056053`, 
                  0.0722238201657985}, {-2.565263065359131, 
                  0.0645210134227862}, {-2.568790892572544, 
                  0.05811918427433449}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01999999999999999, 1.}}], {
                 LABColor[
                 0.35538891812345275`, 
                  0.5222984053975277, -0.45875571519199676`], 
                 
                 ArrowBox[{{-1.653503681905538, -0.6961015480758568}, \
{-1.7036291864190392`, -0.6634452350916423}, {-1.7529589410640307`, \
-0.6389209388037811}, {-1.8050712358435819`, -0.6226996928798051}, \
{-1.8597427339786412`, -0.6141690497296604}, {-1.9167500986901576`, \
-0.612716561763293}, {-1.9749660422078437`, -0.6155694264442411}, \
{-2.0332632767614123`, -0.6199548412360427}, {-2.0502829788374055`, \
-0.6208860436634142}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.3573317282827398, 
                  0.5222949363372109, -0.45411250483058974`], 
                 
                 ArrowBox[{{-2.060658579211064, -0.62145372600064}, \
{-2.1132780320818627`, -0.6243327048465362}, {-2.189655476575841, \
-0.6230132387371732}, {-2.2619999966767934`, -0.6137374397667801}, \
{-2.3299159788181667`, -0.5942463047941834}, {-2.402256599944804, \
-0.557515080697653}, {-2.4492846549991425`, -0.5173711611530978}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3369234237994299, 0.5223313771798115, -0.5028872399135204], 
                 
                 ArrowBox[{{-2.457187935368959, -0.510624791333266}, \
{-2.4643822669819717`, -0.5044835918063894}, {-2.513248279776212, \
-0.4364469443107061}, {-2.548910001864637, -0.3641256057691509}, \
{-2.5748678386650887`, -0.29879363574754353`}, {-2.5935124259685955`, \
-0.24304429887990422`}, {-2.6011799642844764`, -0.21750644625122434`}, \
{-2.6073338459342636`, -0.1941664585060376}, {-2.611311149604872, \
-0.17070818352266945`}, {-2.6135712297685885`, -0.14949647464003485`}, \
{-2.614119749718011, -0.1327331621543153}}]}}, {
                Arrowheads[{{0.005867244581393959, 1.}}], {
                 LABColor[
                 0.24300878209211463`, 
                  0.522499070124571, -0.7273381134992587], 
                 
                 ArrowBox[{{-2.6144595803441075`, -0.12234760191447118`}, \
{-2.6148255120403596`, -0.11116436714030546`}, {-2.60985222076379, \
-0.08014147897897177}, {-2.5993221115622114`, -0.054857743818256026`}, \
{-2.564883765378997, -0.01597983614834115}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2841074536805887, 0.522425684791474, -0.6291145290448249], 
                 
                 
                 ArrowBox[{{-2.2475898955164015`, 
                  0.5561267632865635}, {-2.234057772583832, 
                  0.5601072488340033}, {-2.2187267888323285`, 
                  0.5628611817852909}, {-2.187997240908049, 
                  0.5621772312251144}, {-2.1566743518098845`, 
                  0.5491953630912303}, {-2.130561993337522, 
                  0.5177077230328897}, {-2.121390261312668, 
                  0.4940882777501265}, {-2.1157703141839272`, 
                  0.465941198970063}, {-2.1133093739224695`, 
                  0.4353005364674422}, {-2.1120633393442354`, 
                  0.3686665675716178}, {-2.1103913158429366`, 
                  0.31128438650129214`}, {-2.108737551723856, 
                  0.2850507464960915}, {-2.106358083460014, 
                  0.2610018658485881}, {-2.1041790090327765`, 
                  0.24756024282635045`}, {-2.1027908272651543`, 
                  0.24017760938444785`}}]}}, {
                Arrowheads[{{0.004991725676318546, 1.}}], {
                 LABColor[
                 0.32995740707462057`, 
                  0.5223438156221736, -0.5195356401083382], 
                 
                 ArrowBox[{{-2.1007472478768094`, 
                  0.2299903134222144}, {-2.09650075954415, 
                  0.210245313646958}, {-2.0904035687905007`, 
                  0.18801349495834374`}, {-2.0835611499752273`, 
                  0.16780182196630447`}, {-2.0676789108963693`, 
                  0.1320164026680316}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.017123674858405862`, 1.}}], {
                 LABColor[
                 0.21658277143752, 0.5225462561167055, -0.7904948382546466], 
                 
                 ArrowBox[{{-1.7146349895678465`, 
                  0.5685184114818724}, {-1.7030187051013341`, 
                  0.5794716084447832}, {-1.696993547489213, 
                  0.5883671899648458}, {-1.6903264287321083`, 
                  0.6007314898940981}, {-1.6895332304318285`, 
                  0.6024028695756999}, {-1.6866882014236844`, 
                  0.60851533892543}, {-1.6841544545605356`, 
                  0.6140922248228571}, {-1.6814585282998833`, 
                  0.6201361540009985}, {-1.6582954082774473`, 
                  0.6748446621684469}, {-1.6423670969150992`, 
                  0.7143382371942633}, {-1.6226258090128787`, 
                  0.7647247385513561}, {-1.5993877082003594`, 
                  0.82474051772239}, {-1.5729689581071156`, 
                  0.8931219261900294}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.1913081597043819, 0.5225913861836698, -0.8508997823604103], 
                 ArrowBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAyPB0p+lW9r/k8E4K6O+LP6xuUD0Q
ava/wHFlUmEglz9T+A4R9Yr2v2pYUe6VdKM/Zsech9+q9r9bNaeq4/yqP1iQ
fGtB2fa/PAYeyPC+sj+IpVQzJh73v07Z6qvVFLo/DGeZl3mI978jLqXEGkXC
P9J8qFC50fe/KhFK9HibxT//H8i8EDH4v2KxTRrIuMk/jfCvNhqy+L/CjZDB
kP7OP5GC0oYtX/m/NuYJQLKY0j8U1SA7WYb5vxxDT6ggM9M/RgU6CAav+b97
fe+gHMjTP+Rbt6oC2fm/LeE3wJtU1D+Yp08aCgT6v4gwf+MK1dQ/mvEIK70M
+r83wM336ezUPzawqA52Ffq/b4FqJSUE1T8rqp8MBBz6v0hcEAUiFdU/X6Ye
ENEh+r+2biarsSPVP4KvYBPJKPq/ZSA+j8E01T93KePsDkD6v2FoU9DTadU/
T8OmD1ZX+r8m6L6NdJjVP9K60PUcX/q/4G4QOqql1T+X2cFv
                  "]]}}, {
                Arrowheads[{{0.0007121065478924445, 1.}}], {
                 LABColor[
                 0.2540843434321959, 0.5224792937248296, -0.7008681257205582], 
                 
                 ArrowBox[{{-1.65816775882396, 
                  0.34183635082589087`}, {-1.6723908542764405`, 
                  0.34401708466131925`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.00007063765944939012, 1.}}], {
                 LABColor[
                 0.22886453460402478`, 
                  0.5225243259363334, -0.7611420938712283], 
                 
                 ArrowBox[{{1.4800759896632627`, -1.0114516400258353`}, {
                  1.480520176990177, -1.0121978773999964`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.00901039885753047, 1.}}], {
                 LABColor[
                 0.3675469276584552, 0.5222766961902702, -0.4296987352409943], 
                 
                 ArrowBox[{{1.57137626425394, -1.1148204383112614`}, {
                  1.5728810916108862`, -1.1152253281260345`}, {
                  1.5743859189678324`, -1.1156302179408075`}, {
                  1.6535641749978423`, -1.1369339703414172`}, {
                  1.6852354774098461`, -1.1454554713016611`}, {
                  1.71690677982185, -1.153976972261905}, {
                  1.7454915717435577`, -1.1521657973315131`}, {
                  1.7526787293826955`, -1.1488673379623435`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.20187673939284345`, 
                  0.5225725150447541, -0.8256414530891513], 
                 
                 ArrowBox[{{1.7757750118472153`, -0.05677831496748833}, {
                  1.7629114285843244`, -0.06098481211345074}, {
                  1.743422368889002, -0.07054640606530073}, {
                  1.712655620231274, -0.08493624535556335}, {
                  1.6967399017014089`, -0.09131942278569431}, {
                  1.6776977452546524`, -0.0975953607002574}, {
                  1.655186922435834, -0.10296621187012327`}, {
                  1.6162632928491083`, -0.1067272472683709}, {
                  1.5785571366453148`, -0.09944869957188379}, {
                  1.550800856225079, -0.07377680343101221}, {
                  1.539665750636602, -0.024505031558309912`}, {
                  1.543049884814069, 0.005968575804740344}, {
                  1.5537176339112857`, 0.037114287055324345`}, {
                  1.5713124311880151`, 0.06568110302901682}, {
                  1.5817413050842881`, 0.0789420910523872}, {1.58618387332947,
                   0.08335664051137684}}]}}, {
                Arrowheads[{{0.01569239007075244, 1.}}], {
                 LABColor[
                 0.3352745196332942, 0.52233432144484, -0.5068280309746388], 
                 
                 ArrowBox[{{1.5935547105385217`, 0.0906809906659997}, {
                  1.593743090248738, 0.09086818228623468}, {
                  1.6086441541881638`, 0.100040181381835}, {
                  1.6243508607660613`, 0.10768509449660041`}, {
                  1.6565320428178016`, 0.12003090202200448`}, {
                  1.6890344059156177`, 0.12691424607417806`}, {
                  1.7199349985190968`, 0.12948611608926164`}, {
                  1.7603843136082313`, 0.12843780843190752`}, {
                  1.794501367141707, 0.1244957291471639}, {
                  1.8225082992236563`, 0.12015012834176356`}, {
                  1.859999648647989, 0.11421123925062145`}, {
                  1.8880745372506176`, 0.11225957105205783`}, {
                  1.9110040148910847`, 0.11302198143624419`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.3391006571801861, 0.5223274895359851, -0.4976837708332279], 
                 
                 ArrowBox[{{1.5031752189905792`, 0.7550126591140977}, {
                  1.5447819832305716`, 0.7544659090437615}, {
                  1.5950495601440449`, 0.7526223905863999}, {
                  1.667434223806557, 0.7481069321290578}, {
                  1.7413651511732464`, 0.7410973903662057}, {
                  1.8124304969313658`, 0.7306871239762853}, {
                  1.876218415768165, 0.7159694916377377}, {
                  1.9139348162666228`, 0.7037139626148075}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.3726255708437221, 0.5222676278212104, -0.4175610549087205], 
                 
                 ArrowBox[{{1.923817301316391, 0.7005027579201532}, {
                  1.934400730046847, 0.6970637892949918}, {
                  1.9886492621306158`, 0.6740893128924766}, {
                  2.0409309031169274`, 0.6490804494600767}, {
                  2.091910376547996, 0.6207946857699742}, {
                  2.1141087359387614`, 0.6061567562736553}, {
                  2.1362682352558044`, 0.5906980670900794}, {
                  2.180991916064541, 0.5515816929208958}, {
                  2.2261202790479273`, 0.5042663229496802}, {
                  2.2612758556343207`, 0.467407039723542}}]}}, {
                Arrowheads[{{0.010886164583329793`, 1.}}], {
                 LABColor[
                 0.41922163354100656`, 
                  0.5233153410204974, -0.2713144457553759], 
                 
                 ArrowBox[{{2.2684476512728518`, 0.45988768511898914`}, {
                  2.2712486420313134`, 0.45695095297846466`}, {
                  2.324543879416017, 0.40107292621535395`}, {
                  2.377839116800721, 0.34519489945224324`}, {
                  2.4245943466309665`, 0.29617382154782823`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.1986613307004836, 0.5225782564429261, -0.8333261045643123], 
                 
                 ArrowBox[{{1.5482153473178506`, -0.8642777374381948}, {
                  1.5458835529000652`, -0.8649539720876104}, {
                  1.542566250935626, -0.8660732659209}, {
                  1.537875821693325, -0.8678107490523761}, {
                  1.5361492687358869`, -0.8684760053580607}, {
                  1.5337823932692876`, -0.8694040124437317}, {
                  1.5310785892090757`, -0.8704845749089342}, {
                  1.528096838709068, -0.8716910799674888}, {
                  1.5111697929664543`, -0.8787845129821431}, {
                  1.4818976623079343`, -0.8916063678235604}, {
                  1.4320028835264074`, -0.9146764333595455}, {
                  1.3608902722072393`, -0.9496885892779683}, {
                  1.2854586341090541`, -0.9906973197610636}, {
                  1.2246647439593594`, -1.0300860016521565`}, {
                  1.199405133915515, -1.0487106024944661`}, {
                  1.1842768656603873`, -1.0617428181369228`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.336916814662962, 0.5223313889810124, -0.5029030353893578], 
                 
                 
                 ArrowBox[{{1.176957626098814, -1.0690408507923503`}, {
                  1.1670105131017596`, -1.0823701105754406`}, {
                  1.1590813861979101`, -1.097519754381376}, {
                  1.1509227876035781`, -1.1259954159581378`}, {
                  1.1572064102419708`, -1.151035380971233}, {
                  1.176148189210087, -1.17304941619801}, {
                  1.223324866261014, -1.2004735922676404`}, {
                  1.287897023181697, -1.2235280755728115`}, {
                  1.3631319038959382`, -1.2441142865804977`}, {
                  1.4420672331474573`, -1.2645850500519862`}, {
                  1.4563234982599198`, -1.2683874827052402`}}]}}, {
                Arrowheads[{{0.00345937778335597, 1.}}], {
                 LABColor[
                 0.36754692765845526`, 
                  0.5222766961902702, -0.42969873524099417`], 
                 
                 ArrowBox[{{1.4663636265303603`, -1.2710653868601656`}, {
                  1.521187022868416, -1.28568788937072}, {
                  1.535828819891972, -1.2895931511391772`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2399092499067517, 0.5225046046149348, -0.7347458264401221], 
                 
                 ArrowBox[{{1.1870303275771592`, -0.46696493739019085`}, {
                  1.203091029605166, -0.4939643131139029}, {
                  1.1996134629182837`, -0.5311083987473895}, {
                  1.176416202494712, -0.5609808464679729}, {
                  1.1333768064153702`, -0.5849343845496189}, {
                  1.0762155496222674`, -0.5945047860792095}, {
                  1.0098445397214353`, -0.5753053844233976}, {
                  0.9574229686334804, -0.5213057846436459}, {
                  0.9366950438098269, -0.4676322811399614}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.347374033773424, 0.5223127166863121, -0.4779108518282949], 
                 
                 
                 ArrowBox[{{0.932951595277344, -0.4579388844476499}, {
                  0.9284612226860799, -0.4463113804374545}, {
                  0.9203154508637421, -0.3976560427143404}, {
                  0.9148611934939662, -0.34794783359645876`}, {
                  0.9119326561044574, -0.2962451920245042}, {
                  0.9113640442229206, -0.24160655693917166`}, {
                  0.9129582057967248, -0.18617987500908315`}, {
                  0.9166676652761894, -0.12581844831849442`}, {
                  0.9228518647642845, -0.059527543878725185`}, {
                  0.924396671791531, -0.04469727796964998}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4336995281167571, 
                  0.5242587460050578, -0.20681506443343015`], 
                 
                 ArrowBox[{{0.9254732463974575, -0.03436207920679406}, {
                  0.9302311578141048, 0.011314235204123849`}, {
                  0.9337767056759249, 0.08079031889708396}, {
                  0.9296990161091077, 0.1433000868792898}, {
                  0.9256763895460047, 0.17245423098725032`}, {
                  0.9197891478957723, 0.19951744709280506`}, {
                  0.9095780338014923, 0.22461580285920568`}, {
                  0.8976352695351926, 0.24776597565583697`}, {
                  0.8707465706617671, 0.290764872606688}, {0.8385122907049003,
                   0.32833266476151396`}, {0.8189614204205973, 
                  0.3469906059895132}}]}}, {
                Arrowheads[{{0.01169309176983704, 1.}}], {
                 LABColor[
                 0.34803273072200375`, 
                  0.5223115405243315, -0.4763366020324245], 
                 
                 ArrowBox[{{0.8114441304206093, 0.35416456566363635`}, {
                  0.8020652691941362, 0.3631150747204936}, {
                  0.7611584593088516, 0.39837623636502006`}, {
                  0.7179035489584699, 0.4366989518636961}, {
                  0.6749081706070753, 0.47873633771712953`}, {
                  0.6360850098779555, 0.5219840251277643}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.2579645502023372, 0.522472365270568, -0.6915946430833596], 
                 
                 
                 ArrowBox[{{-0.21143322673708148`, -0.3857907072761036}, \
{-0.2428735830388657, -0.37362135003918384`}, {-0.2843643044251848, \
-0.3711809159647071}, {-0.3085120049272396, -0.37365033857807123`}, \
{-0.334000780584417, -0.3779861963238582}, {-0.3598803499270943, \
-0.3834506098842066}, {-0.4447051214341897, -0.3952553505801199}, \
{-0.4766875491740394, -0.3919146580039998}, {-0.49989282867762364`, \
-0.38156255552793}, {-0.5157375298967571, -0.36455499377673095`}, \
{-0.521983420886613, -0.35444512776462245`}, {-0.526718357053896, \
-0.3427843187226985}, {-0.52894186377522, -0.32618176410954375`}, \
{-0.5297112186227405, -0.30754318516462037`}, {-0.5285261250050615, \
-0.2700989784795449}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2741517882907406, 0.5224434615174021, -0.652908026557627], 
                 
                 
                 ArrowBox[{{-0.5275382771889963, -0.2597689967824713}, \
{-0.5213413064708301, -0.2150442772156203}, {-0.5081651014795351, \
-0.1529670845314982}, {-0.4914886082381227, -0.0893543191317447}, \
{-0.4689197285709182, -0.013278384859258963`}, {-0.45577423037999004`, 
                  0.02985718809244605}, {-0.44239983015082684`, 
                  0.07614009276511165}, {-0.42921125940616617`, 
                  0.1255808423263305}, {-0.42514428402093485`, 
                  0.1425779649995649}}]}}, {
                Arrowheads[{{0.006954185431696186, 1.}}], {
                 LABColor[
                 0.41935952373553503`, 
                  0.5233243261872397, -0.27070014150064353`], 
                 
                 ArrowBox[{{-0.4227262125300322, 
                  0.15268381858126437`}, {-0.41662324966874553`, 
                  0.17818994994369505`}, {-0.40465987958082744`, 
                  0.23423346134301792`}, {-0.3931219975672601, 
                  0.2941234408548086}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.32758066754303306`, 
                  0.5223480595019747, -0.5252159180123216], 
                 
                 ArrowBox[{{0.25440413290163744`, 0.09266263051306087}, {
                  0.2023190674777099, 0.10622691336155035`}, {
                  0.14600770106505373`, 0.12807373709615538`}, {
                  0.0873029610305784, 0.1643294949929749}, {
                  0.05554877638078681, 0.19683367179625313`}, {
                  0.028201018374073447`, 0.24056859072619236`}, {
                  0.007296535966364072, 
                  0.29892939499165644`}, {-0.0013646366502538363`, 
                  0.34215005166328444`}, {-0.0043239036744193125`, 
                  0.3713302374122006}}]}}, {
                Arrowheads[{{0.016831812665088732`, 1.}}], {
                 LABColor[
                 0.6461994401507739, 0.5011950027121475, 0.6785478854593321], 
                 
                 
                 ArrowBox[{{-0.005372326613529535, 
                  0.3816683298711899}, {-0.006645738845024341, 
                  0.39422495458485163`}, {-0.008412838688190883, 
                  0.45523463553219734`}, {-0.008454968485675191, 
                  0.47055749634620897`}, {-0.008533955564008473, 
                  0.4851089367357006}, {-0.008650780958825828, 
                  0.49894392996504}, {-0.008678845251365237, 
                  0.501629083598929}, {-0.008708421192821678, 
                  0.5042898511932623}, {-0.008731593774754964, 
                  0.5062697769180687}, {-0.00935449468869651, 
                  0.5351354656209022}, {-0.010220951978928078`, 
                  0.5611628429276434}, {-0.012447933897265222`, 
                  0.608305550998931}, {-0.015595372788198052`, 
                  0.6467283417186211}, {-0.01952010799110037, 
                  0.6782786234792216}, {-0.030144410221221232`, 
                  0.7298513033410813}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.010036350695621274`, 1.}}], {
                 LABColor[
                 0.3427025657961855, 0.5223210580078272, -0.4890754056120028], 
                 
                 ArrowBox[{{2.026447407293671, -0.9017198488878848}, {
                  2.080023080935266, -0.8780480301299445}, {
                  2.1335987545768615`, -0.8543762113720043}, {
                  2.187174428218457, -0.830704392614064}, {
                  2.217232264651168, -0.8174236700784814}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.26330229447872266`, 
                  0.5224628342534676, -0.6788377252691412], 
                 
                 ArrowBox[{{-0.5268185639016545, 
                  1.3853958204842542`}, {-0.4384555172668779, 
                  1.385304853573006}, {-0.3502487787388815, 
                  1.3852147579708523`}, {-0.26213248842198467`, 
                  1.385135240951997}, {-0.17404078642050666`, 
                  1.3850760097906443`}, {-0.11117397235400764`, 
                  1.3850510332693176`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2637098885132056, 0.522462106458071, -0.6778635977481829], 
                 
                 
                 ArrowBox[{{-0.1007828545456636, 
                  1.3850469049548895`}, {-0.08610156648544261, 
                  1.3850410721874782`}, {0.001581447309804307, 
                  1.3850075205218175`}, {0.08911036937730248, 
                  1.3849446890858186`}, {0.17658731412912027`, 
                  1.3848219121716363`}, {0.26401359577539807`, 
                  1.3846711423896587`}, {0.3148615950688712, 
                  1.3846003869906245`}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.26166100797983827`, 
                  0.5224657649164739, -0.6827603105208335], 
                 
                 ArrowBox[{{0.32525270363717085`, 1.3845859276796708`}, {
                  0.3511618553303814, 1.3845498748871878`}, {
                  0.43779119741229644`, 1.3844657577617527`}, {
                  0.5236607266393697, 1.3844264391108811`}, {
                  0.5798129388994782, 1.3844217146541973`}, {
                  0.6359571250741848, 1.3844217146541973`}, {
                  0.6924829779620953, 1.3844550444372732`}, {
                  0.7359987707357372, 1.3845462217423623`}, {
                  0.7408972490559627, 1.3845599539146187`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.26329712870566463`, 
                  0.5224628434774148, -0.6788500711851192], 
                 
                 ArrowBox[{{0.7512883268537726, 1.3845890837914745`}, {
                  0.7799875654168725, 1.3846695379369889`}, {
                  0.8239698013790863, 1.384777086354246}, {0.8497719566615339,
                   1.3848333547497242`}, {0.8755705954494465, 
                  1.3847258297185825`}, {0.9013710758737603, 
                  1.3843271545664382`}, {0.9251817892555337, 
                  1.38362218090892}, {0.9490076798429045, 
                  1.3824015641917922`}, {0.9728486590066342, 
                  1.3806085935292478`}, {1.0030554385923778`, 
                  1.3762579560413748`}, {1.0334417917365044`, 
                  1.3661393435995093`}, {1.0638994310560816`, 
                  1.346453026427847}, {1.1027992783793636`, 
                  1.305902871054453}, {1.1256608635439043`, 
                  1.2743447397266021`}}]}}, {
                Arrowheads[{{0.018300965470804776`, 1.}}], {
                 LABColor[
                 0.3071270868374064, 0.5223845811892968, -0.5740988607981931], 
                 ArrowBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW6yeLq0b8j9QjZN+P0H0PxdEinL+
OfI/8tEV2GUX9D8yBs3kg77yP5rpWne+ZfM/P8DaSZX88j/OAcC4fR7zP4nN
rrVoNfM/59PIcBXt8j9XoGLEloHzP7/HB+YtuvI/Dk1/v4/S8z+vHzKB26Ty
P9D3tOkDGvQ/SSHt4rue8j9RCLss0pf0P7zDUbsFoPI/ZnOwWLn49D8zIDll
Xa/yP4Tsib9DRfU/C1UXH0O/8j8lH+vTk7f1P/I5LAoF3vI/hFnwSpEH9j93
CO3G6fjyPx6khon8RPY/npb83fgO8z88nnJfPoj2P+qT5ovNJfM/6a6O1QHF
9j8kURIc8DLzP2AslY2BFfc/yqibhtU08z/SUYlHuDP3P6FMxe2pM/M/Oq+y
M29W9z+WSRYLwTLzP8+F2UDBX/c/F1wovKIy8z9zZdUhTWn3P8afCVeXMvM/
KoOyBg==
                  "]]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.21775931865328135`, 
                  0.5225441552870194, -0.7876829545526836], 
                 
                 ArrowBox[{{-0.3922674176732043, 
                  1.1359510400131962`}, {-0.391861729259368, 
                  1.1270221185120903`}, {-0.39352649482861896`, 
                  1.116020425286261}, {-0.39411376664593967`, 
                  1.1135048472707443`}, {-0.39463180435717904`, 
                  1.1114664758900026`}, {-0.3950985612140151, 
                  1.1097360228618838`}, {-0.39575924976843946`, 
                  1.107417029103871}, {-0.4002120214369817, 
                  1.0940665575123776`}, {-0.4069990619274498, 
                  1.0771656760081003`}, {-0.4171993943810133, 
                  1.0553615427735554`}, {-0.43672218506114646`, 
                  1.0203388231458728`}, {-0.4731470507932536, 
                  0.9683469958435076}, {-0.5246337788441019, 
                  0.9097542455749161}, {-0.5770536648106265, 
                  0.8577923072726658}, {-0.6243577748830539, 
                  0.8130894821954587}, {-0.6314782488105088, 
                  0.806270857711574}}]}}, {
                Arrowheads[{{0.003343053902478618, 1.}}], {
                 LABColor[
                 0.5005891648860369, 0.5286173919679362, 0.0911799351775249], 
                 
                 
                 ArrowBox[{{-0.6389832318175717, 
                  0.7990840241658765}, {-0.656992489493674, 
                  0.7818382106739713}, {-0.6887174289000928, 
                  0.750574073371049}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.6752465421270729, 0.46778056089745185`, 
                  0.7492881626051843], 
                 
                 ArrowBox[{{1.3254293625046512`, -0.8807538089707863}, {
                  1.2781734875090607`, -0.9011416399319495}, {
                  1.2350082279283097`, -0.9208108642457369}, {
                  1.1956827443077074`, -0.9398237439877029}, {
                  1.1292388634471482`, -0.9740999634390863}, {
                  1.0771398381544293`, -1.0025268462839623`}, {
                  1.0130982730582587`, -1.0354081515007978`}, {
                  0.9717429372167042, -1.0502382624045934`}, {
                  0.9487400640575379, -1.0512527140467007`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2599916262266078, 0.5224687457460553, -0.6867500418986989], 
                 
                 ArrowBox[{{0.9383992607726097, -1.0510981908363248`}, {
                  0.9245897028154598, -1.0486527484303199`}, {
                  0.9088887383916017, -1.0412433316631178`}, {
                  0.907320968749948, -1.0400717352322426`}, {
                  0.9018026908612404, -1.0356576238110764`}, {
                  0.8970054098110377, -1.031471287734988}, {
                  0.8919945495453631, -1.0267842626008894`}, {
                  0.8488702448324329, -0.975638467163808}, {
                  0.8256564711227525, -0.9418934318264156}, {
                  0.7978545795510726, -0.896511203318482}, {
                  0.7594322624353758, -0.8279372164393759}, {
                  0.7283442435946138, -0.7651907250640364}, {
                  0.7081082510259169, -0.7169673761879112}}]}}, {
                Arrowheads[{{0.0075691956600747535`, 1.}}], {
                 LABColor[
                 0.39137319494102923`, 
                  0.5222341522711261, -0.37275525541036764`], 
                 
                 ArrowBox[{{0.7044535772588645, -0.7072450177533826}, {
                  0.6834425729778207, -0.6471576913446496}, {
                  0.6689947468647928, -0.5961494645858345}, {
                  0.6596535739154913, -0.5566027058648695}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3291448610408254, 0.522345266495378, -0.5214775808302368], 
                 
                 
                 ArrowBox[{{0.3700825588778677, -1.1610470764904859`}, {
                  0.45463282627016394`, -1.133285043438695}, {
                  0.4937737881685055, -1.11765514422746}, {
                  0.5311025789610881, -1.0999110780818648`}, {
                  0.5646060849485495, -1.0782356275967566`}, {
                  0.5801412497281541, -1.066142568173053}, {
                  0.5941654333995801, -1.052501548174491}, {
                  0.6047178175501083, -1.033923312565089}, {
                  0.6127997449918194, -1.0123620560492192`}, {
                  0.623489123703278, -0.9623916152489608}, {
                  0.6226778597908329, -0.897210852908104}, {
                  0.6223272551400976, -0.8938876790746648}}]}}, {
                Arrowheads[{{0.00986927698498089, 1.}}], {
                 LABColor[
                 0.4236105515021669, 0.5236013306068783, -0.2517617068065951], 
                 
                 ArrowBox[{{0.6212370123319417, -0.883553913208867}, {
                  0.6149942235203536, -0.8243822154494516}, {
                  0.6109980161616105, -0.7843245937872836}, {
                  0.607543655505289, -0.7473728393009266}, {
                  0.601902800203425, -0.6793701681755586}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.0000801147818072866, 1.}}], {
                 LABColor[
                 0.23671691812759205`, 
                  0.5225103048072259, -0.7423753253508556], 
                 
                 ArrowBox[{{-0.1473070684265308, 
                  1.1433851026497808`}, {-0.148314446171109, 
                  1.142678099651784}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3734034536962717, 
                  0.5222662388421987, -0.41570195730021076`], 
                 
                 ArrowBox[{{-0.1020742839485225, -0.7039643538594976}, \
{-0.1277804694543367, -0.716578877299921}, {-0.15665432527616, \
-0.7369224080592243}, {-0.18942892591930902`, -0.7672050164340707}, \
{-0.2068794634228422, -0.785156069554832}, {-0.22536626861453832`, \
-0.8062710829000641}, {-0.24392396851536047`, -0.8321847109201989}, \
{-0.26343742029686634`, -0.8625934792176955}, {-0.29183517006830245`, \
-0.9100443068125554}, {-0.31287418996453503`, -0.9518503164111707}, \
{-0.3269976469304638, -0.9875844432551547}, {-0.33181730300837503`, \
-1.003429423121501}, {-0.335337455067284, -1.018065305459915}, \
{-0.33766861193594444`, -1.0315733366756918`}, {-0.33767559757643784`, \
-1.0316880368677246`}}]}}, {
                Arrowheads[{{0.0024972114671999207`, 1.}}], {
                 LABColor[
                 0.4259092495784402, 0.5237972155404909, -0.2400990037475898], 
                 
                 ArrowBox[{{-0.33830728238070745`, -1.0420599374003137`}, \
{-0.339125259163307, -1.0554906448825037`}, {-0.33695929705437966`, \
-1.0758118959881258`}, {-0.3317403800856013, -1.0930446512959815`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.26122662807595026`, 
                  0.5224665405404224, -0.6837984548093418], 
                 
                 ArrowBox[{{0.6287031321201222, 0.14014797335746815`}, {
                  0.5782519015553721, 0.18438180103391286`}, {
                  0.5528007284766367, 0.21236489302784992`}, {
                  0.5278357115146746, 0.24627633240177643`}, {
                  0.5049960218803683, 0.2877605036838639}, {
                  0.4943346207137248, 0.31063174816308514`}, {
                  0.4847935466679236, 0.3359155925987905}, {
                  0.4789555231678689, 0.3618376913436816}, {
                  0.47435896685904255`, 0.39023937546685805`}, {
                  0.46745682834080926`, 0.4509551813110338}, {
                  0.46372687983067773`, 0.5033711126583195}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3835922131248814, 
                  0.5222480459061349, -0.39135137774272905`], 
                 
                 ArrowBox[{{0.4629893068298722, 0.5137360213611661}, {
                  0.46286635286981936`, 0.5154638592419044}, {
                  0.4568336363631395, 0.5777500405812651}, {
                  0.4433943568919862, 0.6595660730219872}, {
                  0.4248216909195629, 0.7315585053946121}, {
                  0.4008443923959307, 0.7917534856292499}, {
                  0.3410908155998091, 0.8562112644469245}, {
                  0.2999965984815461, 0.8611049592110598}}]}}, {
                Arrowheads[{{0.0013027471832960577`, 1.}}], {
                 LABColor[
                 0.2890054893897015, 0.5224169389131247, -0.6174084907340929], 
                 
                 ArrowBox[{{0.2894480279477038, 0.8623611331452661}, {
                  0.26302469271042733`, 0.8655077495397216}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.39667027547709327`, 
                  0.5222246938627505, -0.3600955217185872], 
                 
                 ArrowBox[{{-0.9499640901965458, -0.1778112948200504}, \
{-0.9583796394343298, -0.11595610682565971`}, {-0.9623780423148466, \
-0.060409884534954314`}, {-0.9633440394211332, -0.01053785039682163}, \
{-0.962251923957271, 0.03433746473718119}, {-0.9549173964827323, 
                  0.11210665576788327`}, {-0.9414270387844187, 
                  0.18783034373399632`}, {-0.9296630283468932, 
                  0.23408738380044378`}}]}}, {
                Arrowheads[{{0.015500672940569999`, 1.}}], {
                 LABColor[
                 0.28725340653023446`, 
                  0.5224200674128859, -0.6215958732471153], 
                 
                 ArrowBox[{{-0.9271019033851358, 
                  0.24415793419653073`}, {-0.9239931395529386, 
                  0.2563818449034063}, {-0.9022480719985376, 
                  0.32064680024488557`}, {-0.8885488587289174, 
                  0.3564244309307267}, {-0.8727349801765271, 
                  0.3930963561580474}, {-0.853125736717661, 
                  0.43265395716141}, {-0.8320536251037313, 
                  0.47321248275498107`}, {-0.7971921167681294, 
                  0.5380068675565006}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.008975315575308186, 1.}}], {
                 LABColor[
                 0.23300547948395917`, 
                  0.5225169319109888, -0.7512454613667009], 
                 
                 ArrowBox[{{-0.14166393270203245`, 
                  1.0547630356764295`}, {-0.16931027428384762`, 
                  1.029254398246608}, {-0.1879851072448493, 
                  1.0232761143422147`}, {-0.2091070730544443, 
                  1.0216290787145652`}, {-0.23213963159725476`, 
                  1.0233627175449995`}, {-0.244150659036749, 
                  1.024868526639508}, {-0.2566901915671377, 
                  1.026617985233787}, {-0.27124059399109246`, 
                  1.027951499571492}, {-0.2862010034423528, 
                  1.028214168638351}, {-0.3166609764863041, 
                  1.0245616175283458`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3866582793510527, 
                  0.5222425711722176, -0.38402364661981664`], 
                 
                 ArrowBox[{{-1.1060993997673154`, -0.4142809668167556}, \
{-1.1459613728687272`, -0.37885536947138976`}, {-1.2218359427073224`, \
-0.35738113644149166`}, {-1.2578941864770754`, -0.3678581399088477}, \
{-1.295124455929422, -0.39063634260220953`}, {-1.3340141714486993`, \
-0.42114865947614855`}, {-1.3538747988750985`, -0.4373761039091052}, \
{-1.3737141005959879`, -0.45072243353387553`}, {-1.3945394384229153`, \
-0.4583308380868283}, {-1.414886660303188, -0.4627941000352082}, \
{-1.4546343744822545`, -0.46596299493901583`}, {-1.4746245601730452`, \
-0.4618901917344111}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3081421992191735, 0.5223827686158634, -0.5716727975482753], 
                 
                 ArrowBox[{{-1.4848065010667681`, -0.4598157216848329}, \
{-1.4923995990665404`, -0.4582687028454533}, {-1.5279085002986377`, \
-0.4407060907995721}, {-1.5889375054484862`, -0.38540677134126616`}, \
{-1.6278036267671838`, -0.33700691829434437`}, {-1.6619108544976995`, \
-0.2943280433305472}, {-1.6921874437327977`, -0.258639614478783}, \
{-1.7432240073883307`, -0.20492684101166866`}, {-1.7789026386002302`, \
-0.17233511767292883`}}]}}, {
                Arrowheads[{{0.005658864985965143, 1.}}], {
                 LABColor[
                 0.23498376348854566`, 
                  0.5225133995089664, -0.7465174704490127], 
                 
                 ArrowBox[{{-1.7866700615626998`, -0.1654345660099091}, \
{-1.8134921794509746`, -0.14239286393069772`}, {-1.8410215165668977`, \
-0.1169843479225693}, {-1.8570590049725062`, -0.09676259708031981}, \
{-1.8638724564691853`, -0.07905671480742651}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.33278128547052155`, 
                  0.5223387733361653, -0.5127867246960305], 
                 
                 ArrowBox[{{-1.1203987411222536`, -0.8211119531758387}, \
{-1.1307317090121345`, -0.7719004153642972}, {-1.1485895534633115`, \
-0.7263389993278389}, {-1.1736404503916051`, -0.6868067086707388}, \
{-1.1878771949500282`, -0.6689675352064569}, {-1.2036253737070082`, \
-0.6538777523763073}, {-1.2228693942646134`, -0.6446340200102795}, \
{-1.2431082258202275`, -0.6382058957918938}, {-1.2850936042334806`, \
-0.6293352005601853}, {-1.32959386423843, -0.6258639458825718}, \
{-1.3757666370470043`, -0.6225616736513824}, {-1.4237933484841032`, \
-0.6153450583868453}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.31953481870272016`, 
                  0.5223624260806103, -0.5444450580922581], 
                 
                 ArrowBox[{{-1.4340691073511205`, -0.6138009968411877}, \
{-1.4384548216148003`, -0.6131419883112653}, {-1.4994897218620464`, \
-0.5895699186956771}, {-1.54247775421728, -0.5598712550401208}, \
{-1.5833820581456366`, -0.5221554709828876}, {-1.6219399073955865`, \
-0.4780127318203171}, {-1.6580129049550028`, -0.42995297027594087`}, \
{-1.691583392829118, -0.38304507992041187`}, {-1.7228166166602237`, \
-0.34537679888510087`}, {-1.7321831132702041`, -0.3369866944864669}}]}}, {
                Arrowheads[{{0.01841995191460892, 1.}}], {
                 LABColor[
                 0.2965927584903973, 0.5224033911693964, -0.5992753312307159], 
                 
                 ArrowBox[{{-1.7399230794333052`, -0.33005356603360264`}, \
{-1.7662598530411484`, -0.3064622181375769}, {-1.8057313195119125`, \
-0.2784833436411645}, {-1.841496835505599, -0.2578483527178806}, \
{-1.87364374613829, -0.242398430707641}, {-1.927624604161288, \
-0.2197969507328096}, {-1.9682561037485518`, -0.20012266060464665`}, \
{-1.9955913424998704`, -0.17933752896210484`}, {-2.0099755766936647`, \
-0.15643333913405674`}, {-2.002353938629254, -0.09988690505571154}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.23728232700016563`, 
                  0.5225092952194013, -0.7410240289707046], 
                 
                 ArrowBox[{{0.7512148919207207, 1.1593696964042002`}, {
                  0.7326342864337528, 1.1550979088892102`}, {
                  0.7028548642651824, 1.1520066152327135`}, {
                  0.6571666424958454, 1.151809160588834}, {0.629793766459582, 
                  1.1526806540516312`}, {0.5985842818191395, 
                  1.1542605437261628`}, {0.5517176924778866, 
                  1.1569334287421984`}, {0.5066391206883983, 
                  1.1566725229645762`}, {0.4638696509335228, 
                  1.1527605790998547`}, {0.38408444708047945`, 
                  1.1412136932950463`}, {0.33856772993757994`, 
                  1.1306405139988114`}}]}}, {
                Arrowheads[{{0.010644981565240689`, 1.}}], {
                 LABColor[
                 0.3518722245488553, 0.5223046847666507, -0.4671604211100758], 
                 
                 ArrowBox[{{0.3284461034836597, 1.1282893389144828`}, {
                  0.31643902470665775`, 1.1255001879233275`}, {
                  0.26170952903306505`, 1.1088434192111651`}, {
                  0.19465272506258396`, 1.0698365105050396`}, {
                  0.18469497066937687`, 1.058100425125311}, {
                  0.17618084005416487`, 1.0458707604990143`}, {
                  0.16858029691360793`, 1.0333184634789223`}, {
                  0.1548013919989166, 1.0076329015429015`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.3942564136302159, 
                  0.522229004027747, -0.36586451993225677`], 
                 
                 ArrowBox[{{0.09562628147351498, -0.64856611379594}, {
                  0.09065318400885476, -0.6036950115417196}, {
                  0.09499341888654644, -0.5541773838817642}, {
                  0.1099005979931873, -0.5020629138190073}, {
                  0.13246601161565635`, -0.44932402461243015`}, {
                  0.14641415983272654`, -0.4201643260101492}, {
                  0.15919854470923034`, -0.3927199659337999}, {
                  0.1666545444730278, -0.3712452967280536}, {
                  0.17217313500970213`, -0.351281410438109}, {
                  0.17972040972089354`, -0.3141395493303535}, {
                  0.18085459115192593`, -0.2821506096000767}, {
                  0.17651513956639303`, -0.2545700465308437}, {
                  0.17393383793385256`, -0.24988555133496215`}}]}}, {
                Arrowheads[{{0.0019848935796821588`, 1.}}], {
                 LABColor[
                 0.29693145614481853`, 
                  0.5224027863946135, -0.598465862301971], 
                 
                 ArrowBox[{{0.16478044926058244`, -0.23327416244285132`}, {
                  0.1531494810665046, -0.2121665111936693}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.014491413916174, 1.}}], {
                 LABColor[
                 0.2812527258559789, 0.5224307821618808, -0.6359371729098793], 
                 
                 ArrowBox[{{0.7991964306035013, 1.0666718008958371`}, {
                  0.7900770585763033, 1.0376187606207818`}, {
                  0.7770763668997952, 1.0058917464981605`}, {
                  0.7600846743141728, 0.9720108870396376}, {
                  0.7505909096759631, 0.9546311758717844}, {
                  0.7401998282960013, 0.9372336163083976}, {0.724039499103304,
                   0.9170991702878899}, {0.7077351893186717, 
                  0.9009146938319781}, {0.6753772330753266, 
                  0.8787380067768528}, {0.6433396234868287, 
                  0.8772676527732555}, {0.6101375772722573, 
                  0.8964892591200548}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01348141290015546, 1.}}], {
                 LABColor[
                 0.33773369342373155`, 
                  0.5223299303713387, -0.5009507396862046], 
                 
                 ArrowBox[{{2.227809003155278, 0.8015446615202617}, {
                  2.2436181384838396`, 0.7930223445059575}, {
                  2.2517465376893195`, 0.7845000274916534}, {
                  2.2598749368947995`, 0.7759777104773492}, {
                  2.2680033361002794`, 0.767455393463045}, {
                  2.2842601345112388`, 0.7504107594344367}, {
                  2.300516932922198, 0.7333661254058284}, {
                  2.3335698868080987`, 0.6987113620072832}, {
                  2.3666228406939993`, 0.6640565986087381}, {2.3996757945799, 
                  0.6294018352101929}, {2.4245943466309665`, 
                  0.6032756823542327}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.016244457089859474`, 1.}}], {
                 LABColor[
                 0.20707894230339202`, 
                  0.5225632260488164, -0.8132084717497575], 
                 ArrowBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAArjE/IvxQw7/YVlKWGhT1P+nZ+2tr
ZcK//EgMxVoF9T+Yvj7e14fBvyPmnVtg9fQ/Ao5iYJ1TwL/eIxIJTd30P0E9
o2sYIr2/FHCJTBm49D/xLNj29wS6v/uxxSVXlvQ/fAx0cHfEtb9i1K7Q6Wf0
P8jpwbCeG6+/wzJuJmsk9D83xqFyve+kv9hv+y7I7fM/5zymZfiIjb904X0m
AKbzP2YRoTn9l44/g0K/70BV8z80DmJLzd2dP7x+FZVELfM/ok6oW9RQpT9I
fCavggjzP+UwFTmbTqo/mhtR58Lo8j/vH85Tdr+uP7BK4f0Gy/I/L9Eb1r1W
sz+yIAV7EpPyP/IY1H4pebY/AMc1aUNh8j8UexxsP/u4P2IC8ygeNPI/grwd
0YlvvT8o4DOuLtDxP7b8nYE=
                  "]]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2510142434588797, 0.5224847756613612, -0.7082054972792329], 
                 
                 ArrowBox[{{1.8273763893115385`, -0.36479975321520214`}, {
                  1.8249030338926868`, -0.38043709579123586`}, {
                  1.8215804329762302`, -0.3951215001585515}, {
                  1.816271520459092, -0.41151476821619676`}, {
                  1.807958171519425, -0.4299558180852949}, {
                  1.7726115116087369`, -0.4788505792854204}, {
                  1.7075805882469872`, -0.541232584200649}, {
                  1.6670597724524092`, -0.5752069580315531}, {
                  1.6264412346990984`, -0.6083400845765695}, {
                  1.5857738359664213`, -0.6410525874786421}, {
                  1.5550814166465654`, -0.6656965753558861}}]}}, {
                Arrowheads[{{0.013414385284471192`, 1.}}], {
                 LABColor[
                 0.39315414847873553`, 
                  0.5222309722202013, -0.36849887355034233`], 
                 
                 ArrowBox[{{1.5469274614148545`, -0.672134929254532}, {
                  1.495431959791839, -0.7094887206472064}, {
                  1.4658944689017481`, -0.7292045416129801}, {
                  1.430998687381578, -0.7502725100251725}, {
                  1.3558950053936634`, -0.7913414755010217}, {
                  1.3080535250924656`, -0.8148140950824154}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.018460723167362376`, 1.}}], {
                 LABColor[
                 0.3049699288080424, 0.522388432986798, -0.5792543508831381], 
                 
                 
                 ArrowBox[{{1.5762040137430129`, -0.9808231817650009}, {
                  1.6103849376633594`, -0.9760845199935998}, {
                  1.650324174396316, -0.9685632094441616}, {
                  1.7193399346999956`, -0.9532216100269604}, {
                  1.747914034805549, -0.9455814913938828}, {
                  1.7763734731061682`, -0.9375201522448722}, {
                  1.8321301409025368`, -0.9173978341982373}, {
                  1.886724599894036, -0.8932758764029888}, {
                  1.9413190588855354`, -0.8691539186077403}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01912839279427392, 1.}}], {
                 LABColor[
                 0.23103825744332132`, 
                  0.5225204445608909, -0.7559470147936347], 
                 
                 ArrowBox[{{-0.8286312111134712, 
                  1.3242545494032911`}, {-0.8010955870001482, 
                  1.3234595371249538`}, {-0.7887004120587429, 
                  1.3226524531922148`}, {-0.7745060708132178, 
                  1.320638122777572}, {-0.7570744738076183, 
                  1.316404121499746}, {-0.7415822145368762, 
                  1.3112112344745024`}, {-0.7213171335325917, 
                  1.3027430777028481`}, {-0.6915433080771748, 
                  1.2878062710372602`}, {-0.6678168228427142, 
                  1.2746796428666463`}, {-0.6360097349828806, 
                  1.256100117804449}, {-0.5965369878204827, 
                  1.2324483536986806`}, {-0.575311379310424, 
                  1.2196698101604682`}, {-0.5569383198340321, 
                  1.208138143137204}, {-0.5432545711286867, 
                  1.1984156562688117`}, {-0.5314682380344765, 
                  1.18935177962566}, {-0.51117610390884, 
                  1.1723265013155597`}, {-0.49640085991859295`, 
                  1.1570911265318269`}, {-0.48547654215754765`, 
                  1.1429456668160172`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.2705572168928869, 0.5224498799443044, -0.6614988562274987], 
                 
                 ArrowBox[{{1.37307377388681, 0.5889146640939517}, {
                  1.40433914906066, 0.5913697219127526}, {1.4227424325811897`,
                   0.5924900024126541}, {1.444701016228854, 
                  0.5934547846979249}, {1.4464810766021374`, 
                  0.5935051990124492}, {1.448738889777481, 
                  0.5935666092157401}, {1.4591646719626281`, 
                  0.5938124527789276}, {1.4693772411173607`, 
                  0.5939991597536021}, {1.4803417755561505`, 
                  0.5941476521022873}, {1.5303750948248473`, 
                  0.5941689743061666}, {1.5930242218918647`, 
                  0.5932425728208355}, {1.6479784623629423`, 
                  0.5911635872886721}, {1.7040870300987967`, 
                  0.5871350270114405}, {1.758058650154652, 
                  0.5805674115761215}, {1.7873917131384833`, 
                  0.574708369497824}}]}}, {
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.49771013227464883`, 0.5284297891571763, 
                  0.07835377310895611], 
                 
                 ArrowBox[{{1.7975815486960554`, 0.5726730322629892}, {
                  1.806602047585732, 0.5708712605696961}, {
                  1.8884767066915236`, 0.5417181180041832}, {
                  1.9471158011502738`, 0.5072337669240946}, {
                  1.9991228731300583`, 0.4652890572382351}, {
                  2.0612444043688862`, 0.40639909317876}, {
                  2.1143155201545576`, 0.35686130336931005`}, {
                  2.1345034645664844`, 0.33969800751462803`}}]}}, {
                Arrowheads[{{0.0010569848181072345`, 1.}}], {
                 LABColor[
                 0.34185224195165065`, 
                  0.5223225763366723, -0.49110763324197604`], 
                 
                 ArrowBox[{{2.1449513924712815`, 0.3308154351219437}, {
                  2.1566246665485944`, 0.3208911034270662}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.27294915298732275`, 
                  0.5224456089296888, -0.6557822593668031], 
                 
                 ArrowBox[{{-2.1938972061549262`, 
                  0.3851739645044792}, {-2.228963455975692, 
                  0.33781299886995536`}, {-2.2553909170142985`, 
                  0.32963357483983974`}, {-2.2898448209907363`, 
                  0.3356410230958547}, {-2.3389766350751207`, 
                  0.3477563016480517}, {-2.409270028579919, 
                  0.3408327264827851}, {-2.478626485163862, 
                  0.31310404218759796`}, {-2.55531848608551, 
                  0.26846395376262294`}, {-2.5631528869334876`, 
                  0.26325472563601704`}}]}}, {
                Arrowheads[{{0.008010172998209109, 1.}}], {
                 LABColor[
                 0.35861648391369116`, 
                  0.5222926422917763, -0.45104200891569374`], 
                 
                 ArrowBox[{{-2.5718058005290625`, 
                  0.25750125427888154`}, {-2.593657540859253, 
                  0.24297165558306114`}, {-2.6303906883020405`, 
                  0.21751014379972372`}, {-2.666320882079351, 
                  0.1920640252144985}, {-2.6994139688270584`, 
                  0.16855892460294955`}, {-2.700681611901922, 
                  0.16766905979297303`}, {-2.7023103600904244`, 
                  0.16652639499354896`}, {-2.7043353667433445`, 
                  0.16510682665818485`}, {-2.70634831810253, 
                  0.1636969264611305}, {-2.708351363666411, 
                  0.1622949718863567}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.006553388631696423, 1.}}], {
                 LABColor[
                 0.44737596566662924`, 
                  0.5251499266451758, -0.14588619414503357`], 
                 
                 ArrowBox[{{2.362138563968868, -0.3635795338108835}, {
                  2.3614988486502444`, -0.3078428139835543}, {
                  2.360859133331621, -0.2521060941562251}, {
                  2.3606700487370142`, -0.2356316487796025}, {
                  2.360622777588363, -0.23151303743544685`}, {
                  2.3605755064397114`, -0.2273944260912912}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.013415668608326464`, 1.}}], {
                 LABColor[
                 0.44737596566662924`, 
                  0.5251499266451758, -0.14588619414503357`], 
                 
                 ArrowBox[{{2.3147192164503245`, -0.7030099070435084}, {
                  2.313922151428957, -0.6335637198305885}, {
                  2.31312508640759, -0.5641175326176685}, {
                  2.3123222568549116`, -0.49416909689317634`}, {
                  2.3115194273022333`, -0.4242206611686842}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.00804346686425916, 1.}}], {
                 LABColor[
                 0.35392359028806164`, 
                  0.5223010218706919, -0.4622577688309601], 
                 
                 ArrowBox[{{-0.05519418785574674, 
                  1.0913485517556731`}, {-0.02324740160915724, 
                  1.0508637466334125`}, {-0.008762012125095553, 
                  1.0306321627937494`}, {0.00334522066942256, 
                  1.0109209493795928`}, {0.010061607312107118`, 
                  0.9938116029351067}, {0.014682135383663517`, 
                  0.9773544262819546}, {0.019877278043017196`, 
                  0.9456769479988415}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.3145118978163481, 0.5223713949525499, -0.556449565168075], 
                 
                 
                 ArrowBox[{{-1.7770655259028878`, -0.41248636395415816`}, \
{-1.821189504989873, -0.38571055519463693`}, {-1.8640000650575759`, \
-0.367734205279845}, {-1.9448098665058804`, -0.3481156517669697}, \
{-2.0164536622249014`, -0.3346545258731436}, {-2.0494415070536793`, \
-0.3272353329997657}, {-2.078834949250253, -0.31718136857836265`}, \
{-2.09876387866927, -0.30487097664222346`}, {-2.11590883082065, \
-0.2915685311238698}, {-2.1449471584309188`, -0.26358875481686067`}, \
{-2.1509328118667197`, -0.2540999618504835}}]}}, {
                Arrowheads[{{0.008898076037961356, 1.}}], {
                 LABColor[
                 0.23427886163637854`, 
                  0.5225146581739116, -0.7482021474454303], 
                 
                 ArrowBox[{{-2.156476783103788, -0.24531134823555986`}, \
{-2.1638124084506827`, -0.23368250421006587`}, {-2.1731716400722547`, \
-0.20323600616637952`}, {-2.1640969584607275`, -0.1388928839583395}, \
{-2.118636488613507, -0.0800726585260479}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01590337090281396, 1.}}], {
                 LABColor[
                 0.3855305496849213, 
                  0.5222445848338274, -0.38671885903962844`], 
                 
                 ArrowBox[{{-2.030435069449584, -0.6979801264256317}, \
{-2.0982888003434015`, -0.707378778784645}, {-2.1653217682071664`, \
-0.7147031190913367}, {-2.2163146730338066`, -0.7181929875336234}, \
{-2.2668368346783385`, -0.7185160683831538}, {-2.3268659366445297`, \
-0.7264611584593393}, {-2.3582909206376903`, -0.7342927474570661}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.27226355074304837`, 
                  0.5224468331334677, -0.6574208113525447], 
                 ArrowBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAM116GfoO9L+yA8nB6FvPv4z7NHJd
2fS/EpwbUPN/0L9DL0cHk6f1v2QUO35+69G/KZGdYY6r9r+8MNtKt2nTv/fs
yEZlyva/zsZ+r3+F079y8O9DEun2v3UyyybZmtO/OKTlNpMK97/6o6SMiKrT
v/Dj9mQmEve/pOiNxe+s078rECf+Mhj3v8bVU6yRrtO/P6NulCke979c2TsL
1a/Tv+UCCjOaJfe/tIoziw2x0790opNHHkb3vwU7MC9AsdO/AlgUa1dj979s
zBLQJ6rTv/FYCVE2gPe/7k4oklec07/8GDBN/BT4v4LowkQp7NK/l0r71c2b
+L8P8iiNhK7Rv38PuDiwE/m/+xn1pTcd0L+N0RHDCtL5vxz8wpQxrcm/wnd+
7g7i+b8bbCFsbg7Jv8sFrgs=
                  "]]}}, {
                Arrowheads[{{0.009816223743836701, 1.}}], {
                 LABColor[
                 0.2547346705591207, 0.5224781325079098, -0.6993138793421322], 
                 
                 ArrowBox[{{-1.6242160384371573`, -0.18766672095183942`}, \
{-1.6495140232919943`, -0.15632076129448927`}, {-1.677116106011295, \
-0.12127006813679901`}, {-1.698666671519855, -0.09487675264045714}, \
{-1.7266315238644967`, -0.062019999009138155`}, {-1.743289019179204, \
-0.04209407978962325}, {-1.7524700537410005`, -0.02909264458826196}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01181911380548423, 1.}}], {
                 LABColor[
                 0.3546431574850706, 
                  0.5222997370194693, -0.46053804245990443`], 
                 
                 ArrowBox[{{1.9180502161595794`, -0.4584534160658205}, {
                  1.9403656616575933`, -0.45644665914285654`}, {
                  1.9678585146049288`, -0.45154950646888387`}, {
                  1.9940653592185575`, -0.44143888764526784`}, {
                  2.0175247838657917`, -0.42930092914295065`}, {
                  2.0590905935739006`, -0.4014206389995676}, {
                  2.090339525074357, -0.36728166919190697`}, {
                  2.113016202036568, -0.3290374189130944}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.23416824103184697`, 
                  0.5225148556968386, -0.7484665246593804], 
                 
                 ArrowBox[{{-1.266463298334419, 
                  0.3359639887639797}, {-1.264986319017017, 
                  0.40030491968075843`}, {-1.2619428557145023`, 
                  0.46580639456016065`}, {-1.2637864917225923`, 
                  0.5027394301864215}, {-1.27298206909679, 
                  0.5439196919190563}, {-1.2913312518710307`, 
                  0.5916330973669156}, {-1.3029472069213106`, 
                  0.6175084416764237}, {-1.3170293216135587`, 
                  0.6459384523721566}, {-1.327069640839081, 
                  0.6643779426975345}, {-1.3380826345039587`, 
                  0.6842043873560425}, {-1.3621542433368683`, 
                  0.7271040256441603}, {-1.363346216531585, 
                  0.7292608817901894}}]}}, {
                Arrowheads[{{0.0021575768037047608`, 1.}}], {
                 LABColor[
                 0.32359577829273656`, 
                  0.5223551748761143, -0.5347395860699489], 
                 
                 ArrowBox[{{-1.3728781420691856`, 
                  0.746508746314652}, {-1.3855550422137093`, 
                  0.7694473913366233}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.009240115464553396, 1.}}], {
                 LABColor[
                 0.3620535660866551, 
                  0.5222865050758908, -0.44282756990721667`], 
                 
                 ArrowBox[{{2.346497703985582, -0.14144347668638121`}, {
                  2.3559715420452725`, -0.10576187453628785`}, {
                  2.3667224626829952`, -0.07223273301979463}, {
                  2.3818310693439324`, -0.03977016130983627}, {
                  2.399039973249692, -0.009339189735291131}, {
                  2.4245943466309665`, 0.03262853827391956}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.005791315101380481, 1.}}], {
                 LABColor[
                 0.3953460340618765, 0.5222270584135644, -0.3632603865051679], 
                 
                 ArrowBox[{{-0.22856118146116447`, 
                  1.214196997004657}, {-0.24595911137683918`, 
                  1.2206653479193388`}, {-0.26069799751826095`, 
                  1.2267676190486185`}, {-0.27755528761092085`, 
                  1.2346165167240997`}, {-0.2887406789900807, 
                  1.2416886070389643`}, {-0.2977429836752867, 
                  1.248358085678438}, {-0.31186901643834336`, 
                  1.2608460788645972`}, {-0.31964738658406305`, 
                  1.271819553146021}, {-0.3234235150291514, 
                  1.2816227587881774`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.26810658660935677`, 
                  0.5224542557626144, -0.6673557290002046], 
                 
                 ArrowBox[{{0.7908354831862651, -0.36583779587554355`}, {
                  0.7852015076355239, -0.31455530733383674`}, {
                  0.7820855039561883, -0.26341283938659915`}, {
                  0.7810265227303922, -0.21102341481290832`}, {
                  0.7816007638387396, -0.16980843397036638`}, {
                  0.7833979090078418, -0.12699754560222357`}, {
                  0.7865350192738285, -0.08187956280193019}, {
                  0.7913852720447083, -0.029730993622124894`}, {
                  0.7949399511459126, 0.0251421738394953}, {
                  0.7935090448794573, 0.048859009548621955`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.29301189759302326`, 
                  0.5224097851149808, -0.6078333935519186], 
                 
                 ArrowBox[{{0.7928832561331377, 0.059231267489631916`}, {
                  0.791615763724411, 0.0802395682603062}, {0.7869658265540912,
                   0.11106072432710079`}, {0.7788330122471562, 
                  0.14119561608340628`}, {0.7652725319084619, 
                  0.16672210254594352`}, {0.7489291315674607, 
                  0.19122369872448447`}, {0.7114502234522115, 
                  0.23999047312201843`}, {0.6659015616460491, 
                  0.29154647306528897`}, {0.6158671690991291, 
                  0.3543008395639728}, {0.5832321661030109, 
                  0.4044006228460979}, {0.5816957283336806, 
                  0.40755392220199627`}}]}}, {
                Arrowheads[{{0.005140120266397247, 1.}}], {
                 LABColor[
                 0.36879911844595475`, 
                  0.5222744602922597, -0.4267060675265585], 
                 
                 ArrowBox[{{0.5771442213523815, 0.4168951817824303}, {
                  0.55453454264005, 0.46329802786173524`}, {
                  0.5355989450253174, 0.5151541084623588}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.008372566273097626, 1.}}], {
                 LABColor[
                 0.23590715945944718`, 
                  0.5225117507033412, -0.7443106044208133], 
                 
                 ArrowBox[{{-1.6879928816757044`, 
                  0.2559832774522089}, {-1.7005004417737752`, 
                  0.24348767113742256`}, {-1.7111702799500705`, 
                  0.22728622101499696`}, {-1.7171870782551069`, 
                  0.21634047680476193`}, {-1.7225132543193638`, 
                  0.2045714034134793}, {-1.7269079130709186`, 
                  0.19123198671953107`}, {-1.7307073765681755`, 
                  0.17805819928295646`}, {-1.7352398801892972`, 
                  0.16100983240412414`}, {-1.7389054625546525`, 
                  0.1447088521071263}, {-1.7418338108149491`, 
                  0.12941736887316027`}, {-1.746771045136571, 
                  0.09594004603708456}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.3730200795190822, 
                  0.5222669233908862, -0.41661820068267036`], 
                 
                 ArrowBox[{{1.6480982160477184`, 0.8276452486912453}, {
                  1.7223865507430356`, 0.8212483895630127}, {
                  1.7979316288429195`, 0.8139074057493377}, {
                  1.8692365416063372`, 0.8050982758312624}, {
                  1.9036395100752013`, 0.7998695330462823}, {
                  1.936809863243924, 0.7939499250916763}, {
                  1.9691077659551457`, 0.7908370787206683}, {
                  1.985079780974038, 0.7908370787206683}, {2.00105179599293, 
                  0.7908370787206683}, {2.0170238110118226`, 
                  0.7908370787206683}, {2.048967841049607, 
                  0.7908370787206683}, {2.0615013277528336`, 
                  0.7908370787206683}}]}}, {
                Arrowheads[{{0.0037489086236316385`, 1.}}], {
                 LABColor[
                 0.33773369342373155`, 
                  0.5223299303713387, -0.5009507396862046], 
                 
                 ArrowBox[{{2.071892446381252, 0.7908370787206683}, {
                  2.0809118710873915`, 0.7908370787206683}, {
                  2.1498031548517664`, 0.7908370787206683}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.009548304736182973, 1.}}], {
                 LABColor[
                 0.4473759656666292, 
                  0.5251499266451758, -0.14588619414503376`], 
                 
                 ArrowBox[{{2.1708496075675874`, -0.7307048119203509}, {
                  2.1707641605710988`, -0.7232600389647397}, {
                  2.17067871357461, -0.7158152660091285}, {
                  2.1704650960833884`, -0.6972033336201005}, {
                  2.1702514785921667`, -0.6785914012310724}, {
                  2.1693898952046005`, -0.6035238977922354}, {
                  2.169174499357709, -0.5847570219325261}, {
                  2.1689591035108173`, -0.5659901460728168}, {
                  2.1718174120008906`, -0.5324019257651078}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01804582502088983, 1.}}], {
                 LABColor[
                 0.2494670172307879, 0.522487538371389, -0.711903283611765], 
                 
                 ArrowBox[{{-2.475054932312673, -0.0330192318576986}, \
{-2.449358958057793, -0.013949747392356746`}, {-2.418468048640031, 
                  0.003479776054855312}, {-2.376727782511599, 
                  0.02683779486148481}, {-2.3412792635921997`, 
                  0.050800063038369994`}, {-2.2824016932314004`, 
                  0.0995101050147712}, {-2.249925831287908, 
                  0.13277936978082472`}, {-2.223423618935016, 
                  0.15105811783137685`}, {-2.1957593515169185`, 
                  0.1511086497931823}, {-2.1865224328002264`, 
                  0.14756511015608684`}, {-2.1764324771876953`, 
                  0.14242335184078556`}, {-2.165310456755704, 
                  0.13576622298453095`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36508174747511973`, 
                  0.5222810979887202, -0.43559038148099477`], 
                 
                 ArrowBox[{{0.9719528592372769, 1.27583994823877}, {
                  0.9836625492668164, 1.250535163617796}, {0.9953989201892113,
                   1.2191857298191047`}, {1.0171686473714507`, 
                  1.1577932714061183`}, {1.0358675131282316`, 
                  1.1100424188412414`}, {1.0671950516567557`, 
                  1.043387908395739}, {1.1082070006150861`, 
                  0.9861005458588277}, {1.1425059685823171`, 
                  0.9648557520483575}, {1.1595159657082246`, 
                  0.9601835227407902}, {1.1741449062349743`, 
                  0.9594470275711271}, {1.1759264312581592`, 
                  0.9596813612385842}, {1.1781804014074921`, 
                  0.9600285884310183}, {1.1887595627321497`, 
                  0.9623918950786131}, {1.1946448849562459`, 
                  0.9643862127211831}}]}}, {
                Arrowheads[{{0.006387125497031769, 1.}}], {
                 LABColor[
                 0.2099042962215951, 0.5225581811281318, -0.8064560299195911], 
                 
                 ArrowBox[{{1.2042654472249297`, 0.9682854265157987}, {
                  1.2069383148371666`, 0.9694771788876806}, {
                  1.2274937357337312`, 0.9822552907079961}, {
                  1.2440787647271614`, 0.9968215168412657}, {
                  1.2581689968996996`, 1.0120696482603497`}, {
                  1.2716122210221612`, 1.028843230498335}, {1.283942372393758,
                   1.0456466719538506`}, {1.295886727442131, 
                  1.062228628372159}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.2958932540565384, 0.5224046401967712, -0.6009471086916365], 
                 
                 ArrowBox[{{1.2308497580097437`, -0.28201171683100773`}, {
                  1.2611114144204787`, -0.2465710483328765}, {
                  1.2873388432090862`, -0.20312869241971776`}, {
                  1.3094109196689137`, -0.1456601651142686}, {
                  1.3163227320596327`, -0.12110107906231418`}, {
                  1.3231078342690297`, -0.09326312799201474}, {
                  1.3298610289859076`, -0.06150975051433232}, {
                  1.333239164536154, -0.04456650581865296}, {
                  1.3365991583142147`, -0.026470895037510128`}, {
                  1.3475405130837725`, 0.041244723605033076`}, {
                  1.359981266584458, 0.10263472038543081`}, {
                  1.3609894902224058`, 0.10566334530677883`}}]}}, {
                Arrowheads[{{0.020000000000000007`, 1.}}], {
                 LABColor[
                 0.4069412650661715, 0.5228401116613688, -0.3159993247966452], 
                 
                 ArrowBox[{{1.3642715887233463`, 0.1155225124004023}, {
                  1.3768925337096918`, 0.1534348436312136}, {
                  1.3865402053129612`, 0.17638734753389543`}, {
                  1.397575223760372, 0.1971327795279954}, {
                  1.4131349583444295`, 0.21495762384653072`}, {
                  1.4313873757925326`, 0.23082609666461926`}, {
                  1.475242232416696, 0.2588364517268608}, {1.53623474661748, 
                  0.27929639541725304`}, {1.614190945549032, 
                  0.29125154506586}, {1.665097854178366, 
                  0.29365546374929286`}, {1.6983222902370156`, 
                  0.2925141971690816}}]}}, {
                Arrowheads[{{0.012074398809990946`, 1.}}], {
                 LABColor[
                 0.48947525750994664`, 0.5278931902850404, 
                  0.041667200706596685`], 
                 
                 ArrowBox[{{1.708707283850549, 0.2921574703874468}, {
                  1.7138270891858969`, 0.29198160396442896`}, {
                  1.7969837095548116`, 0.27940623302604245`}, {
                  1.8582421551788526`, 0.26056447982733505`}, {
                  1.9091433611940685`, 0.23871677294569627`}, {
                  1.946877705233156, 0.21976622366759516`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.019999999999999997`, 1.}}], {
                 LABColor[
                 0.3412924526667701, 
                  0.5223235758902236, -0.49244549911391255`], 
                 
                 ArrowBox[{{0.5920116417937247, -1.1829062841229414`}, {
                  0.6523468461098054, -1.1844725831148488`}, {
                  0.7096877661231193, -1.1852983617253106`}, {
                  0.7821729522421497, -1.1833915955721896`}, {
                  0.853192845132116, -1.1847341082973728`}, {
                  0.9004109109018414, -1.1881579206116506`}, {
                  0.9482973411332054, -1.196656834175591}, {
                  0.9992142717028449, -1.209094208330055}, {
                  1.005014363010049, -1.2106639010517966`}}]}}, {
                Arrowheads[{{0.0050214734968402, 1.}}], {
                 LABColor[
                 0.34444553588346943`, 
                  0.522317945779731, -0.48490980212768264`], 
                 ArrowBox[{{1.015044653069459, -1.2133784226807331`}, {
                  1.0555238384873973`, -1.2243334024159043`}, {
                  1.1158969926807796`, -1.2401952313552203`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.008360572530135894, 1.}}], {
                 LABColor[
                 0.21817741987880143`, 
                  0.5225434087300987, -0.7866837154179839], 
                 
                 ArrowBox[{{1.1773167442294319`, 0.702679315921386}, {
                  1.1620986548710877`, 0.7451815662216047}, {
                  1.1579922264034923`, 0.7666622337008652}, {
                  1.158183903724183, 0.7880699450841665}, {
                  1.1651682772973961`, 0.8075429568067151}, {
                  1.1739391019701886`, 0.8270621325239687}, {
                  1.1919037224061446`, 0.8663955952994244}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.4179010672815165, 
                  0.5232292906086004, -0.27719760136796145`], 
                 
                 ArrowBox[{{0.05127269284975232, 
                  0.07994344588491344}, {-0.02010319800553454, 
                  0.09783541437994017}, {-0.05865323692771928, 
                  0.11601080714052436`}, {-0.09109896140686213, 
                  0.14141218663348507`}, {-0.11700347794451696`, 
                  0.1746626735310619}, {-0.1283313201313153, 
                  0.19329828588609038`}, {-0.13815637822742152`, 
                  0.2139047217029526}, {-0.14472868446820902`, 
                  0.23659494205162263`}, {-0.15016426611296527`, 
                  0.26128316025072723`}, {-0.15883378365488193`, 
                  0.31480507846822203`}, {-0.16306784942909372`, 
                  0.37720788364672964`}, {-0.1630898325247508, 
                  0.38298659972309407`}}]}}, {
                Arrowheads[{{0.016936803004271757`, 1.}}], {
                 LABColor[
                 0.5801874683368908, 0.533804156925036, 0.44579236172853504`], 
                 
                 ArrowBox[{{-0.16312936159988295`, 
                  0.3933776431645432}, {-0.1633338063919341, 
                  0.447120229058045}, {-0.1617667546897405, 
                  0.522092902711946}, {-0.16089194221690253`, 
                  0.5847215501215897}, {-0.1611443864785726, 
                  0.6348238910301666}, {-0.16352720501880222`, 
                  0.7006807410870619}, {-0.16757639188506893`, 
                  0.7451115697944416}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.009659298674943141, 1.}}], {
                 LABColor[
                 0.1886675222501131, 0.5225961012766809, -0.8572107619122568], 
                 
                 ArrowBox[{{1.6375170489340776`, 1.1091681244482299`}, {
                  1.6438325355678032`, 1.1081661012175956`}, {
                  1.646565985168123, 1.1077324085889606`}, {1.648684408608371,
                   1.107396296801768}, {1.7036816611144816`, 
                  1.0986703619960636`}, {1.7414468949635462`, 
                  1.0926784814298023`}, {1.7730885238888339`, 
                  1.0926784814298023`}, {1.8047301528141215`, 
                  1.0926784814298023`}, {1.8369588822761092`, 
                  1.0926784814298023`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.37447867258606227`, 
                  0.5222643189432499, -0.41313224277303934`], 
                 
                 ArrowBox[{{0.4541050234507112, -1.0001150127070333`}, {
                  0.4657820223685129, -0.9618058432952875}, {
                  0.4741219409403798, -0.9171646914822611}, {
                  0.47884803686624383`, -0.865291714418017}, {
                  0.48245147770891617`, -0.812468573128024}, {
                  0.4863475038257737, -0.7632123086836097}, {
                  0.4905144237313763, -0.7178524827316943}, {
                  0.4996289230503823, -0.6381668886977687}, {
                  0.5077820750551741, -0.5888542104019183}}]}}, {
                Arrowheads[{{0.017176535782688896`, 1.}}], {
                 LABColor[
                 0.33735253080395133`, 
                  0.5223306109710938, -0.5018616975670273], 
                 
                 ArrowBox[{{0.5094770879719905, -0.5786022702166806}, {
                  0.5110445595307763, -0.5691217379426757}, {
                  0.5241523672366188, -0.5149388900915954}, {
                  0.537042688126066, -0.47300669702754367`}, {
                  0.5431405069830836, -0.45473787386243236`}, {
                  0.5484628102944201, -0.43870994288469123`}, {
                  0.5527696489697116, -0.42476910446924887`}, {
                  0.5564401803614626, -0.41203420809615643`}, {
                  0.5625746373174604, -0.38840373961897845`}, {
                  0.5665754330711427, -0.36780831868592667`}, {
                  0.5689163438839957, -0.3492602196461411}, {
                  0.5690090902070328, -0.30670625829129156`}, {
                  0.5611605141008738, -0.2691765121991102}, {
                  0.5447455893387423, -0.23405791111713625`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.007377495651255906, 1.}}], {
                 LABColor[
                 0.25680735235632945`, 
                  0.5224744315502337, -0.6943602828465122], 
                 
                 ArrowBox[{{1.1950396113792212`, 1.331141215301644}, {
                  1.2441320763762553`, 1.3264136446082124`}, {
                  1.2669853823102266`, 1.3260167226956143`}, {
                  1.2876562485778607`, 1.3258013324018596`}, {
                  1.2898762283527696`, 1.3257963636362657`}, {
                  1.292703988269802, 1.325793102417336}, {1.3101288908445925`,
                   1.3257963280626393`}, {1.333207054766142, 
                  1.3257969509081677`}, {1.3462635767728406`, 
                  1.3257969509081677`}, {1.3443983593433122`, 
                  1.3257969509081677`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.012188082065004897`, 1.}}], {
                 LABColor[
                 0.2388342285458997, 0.522506524161178, -0.7373150688838992], 
                 
                 
                 ArrowBox[{{1.14802372269996, 0.593655980037248}, {
                  1.1216575490281335`, 0.6115672359993577}, {
                  1.0931135327335035`, 0.6285791712636145}, {
                  1.0617178144080368`, 0.6423576705647056}, {
                  1.0451647209020392`, 0.6481310263883172}, {
                  1.0275534313949493`, 0.6523414506891606}, {
                  1.0024999700550394`, 0.6529359422094181}, {
                  0.9740036062040776, 0.6509176180333888}, {
                  0.9100171556615388, 0.6417558007492368}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.020000000000000004`, 1.}}], {
                 LABColor[
                 0.3578717666888908, 0.5222939720506101, -0.4528218424820265], 
                 
                 ArrowBox[{{0.18225741674485568`, 0.19754654519575474`}, {
                  0.14888944779581978`, 0.25991913870540223`}, {
                  0.1382587711203682, 0.29888948818519767`}, {
                  0.13168601636407995`, 0.34619274889936874`}, {
                  0.13027185340985944`, 0.4029599188263264}, {
                  0.13253878440989025`, 0.45586544187730577`}, {
                  0.13541917967529785`, 0.5070404445150689}, {
                  0.13697514083422557`, 0.5519534546134639}, {
                  0.13731992673367177`, 0.5726526644376899}, {
                  0.13726211711599884`, 0.591753773604221}, {
                  0.13675102498540784`, 0.6027592854339939}}]}}, {
                Arrowheads[{{0.006760719431832908, 1.}}], {
                 LABColor[
                 0.42058458833084217`, 
                  0.523404153543322, -0.2652424481831999], 
                 
                 ArrowBox[{{0.1361540063679581, 0.6131325060216898}, {
                  0.13541069421824917`, 0.6237036606993054}, {
                  0.13265741414986804`, 0.6523649312453579}, {
                  0.12881159091821498`, 0.6770693765873702}, {
                  0.12403021622519407`, 0.6983911348910505}, {
                  0.10366207828325733`, 0.7486821967890519}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01130607775051467, 1.}}], {
                 LABColor[
                 0.3538353363762885, 
                  0.5223011794558999, -0.46246869086861814`], 
                 
                 ArrowBox[{{1.6113811203758304`, -0.20009152294864413`}, {
                  1.5478423146206635`, -0.22753121097636406`}, {
                  1.492247859870997, -0.2507036574696476}, {
                  1.468076373406028, -0.2607728036478641}, {
                  1.4484589466029008`, -0.26952631649095476`}, {
                  1.4268411589553456`, -0.2804127124797705}, {
                  1.4113957780566417`, -0.2905786230583936}, {
                  1.4004135393995285`, -0.3010335276156721}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.00024978215749678036`, 1.}}], {
                 LABColor[
                 0.4473759656666293, 0.5251499266451759, -0.1458861941450334], 
                 
                 ArrowBox[{{-1.9453432867856921`, -1.0142315283813284`}, \
{-1.947275338601011, -1.0146941650664583`}, {-1.9499275299269385`, \
-1.0153292417210427`}, {-1.9503916057776365`, -1.0154403663355656`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.004094493631071427, 1.}}], {
                 LABColor[
                 0.2029486407230988, 0.5225706010696028, -0.8230796673484004], 
                 
                 ArrowBox[{{-0.7007746122825959, -0.5309509666193579}, \
{-0.6892883625475884, -0.5230983189231798}, {-0.6780164672800727, \
-0.5157632319235982}, {-0.6670865463031586, -0.5091477001485902}, \
{-0.6611158502985676, -0.5056849820909588}, {-0.6553558236097192, \
-0.5024604463237877}, {-0.6498775045622315, -0.49947042075551124`}, \
{-0.6447534056641447, -0.4966784918487817}, {-0.6400458543617411, \
-0.49400467970986034`}, {-0.6357981761799335, -0.49133170005016286`}, \
{-0.6320391981031844, -0.4885610797078613}, {-0.6288019841183703, \
-0.4857733308039501}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.017831542671891402`, 1.}}], {
                 LABColor[
                 0.3101732593228702, 0.5223791419774226, -0.5668186746309924], 
                 
                 ArrowBox[{{-0.6454019731711366, -0.6042264700349396}, \
{-0.6485494318527407, -0.6248637313472658}, {-0.6519323484196041, \
-0.6493925642386279}, {-0.6554823589598672, -0.6786418338393894}, \
{-0.6572887397615182, -0.694562167998008}, {-0.6590999525445941, \
-0.7118961839096989}, {-0.6609032631604643, -0.7328380669497419}, \
{-0.662678585336486, -0.7558859459827324}, {-0.66617369069853, \
-0.8065751849227532}, {-0.6692008935944879, -0.8650944778207811}, \
{-0.6691112280048204, -0.9234252795909005}, {-0.6635042360054565, \
-0.9732649946995371}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.31432475636974083`, 
                  0.5223717291102457, -0.5568968230227769], 
                 
                 ArrowBox[{{-1.1026639192013996`, -1.1113910567150889`}, \
{-1.0561598348605157`, -1.103508806718167}, {-1.0050637417494832`, \
-1.0995882502171272`}, {-0.9460363802102641, -1.102534301082532}, \
{-0.9140065441853092, -1.1060772838391484`}, {-0.8786070350523624, \
-1.1118143686549582`}, {-0.8232377894553323, -1.1220991261256654`}, \
{-0.7670092754865012, -1.1319968991461082`}, {-0.7398653437580482, \
-1.1366430156908174`}, {-0.7136766427962096, -1.1413278746107778`}, \
{-0.6915663637235271, -1.1454498062550988`}}]}}, {
                Arrowheads[{{0.003231654779300822, 1.}}], {
                 LABColor[
                 0.4087655856059813, 0.522634006611748, -0.317896400013513], 
                 
                 ArrowBox[{{-0.6813512405870812, -1.1473541711510977`}, \
{-0.6631207241986076, -1.1507528140242582`}, {-0.6153691100022843, \
-1.159881804272144}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.01011945366283623, 1.}}], {
                 LABColor[
                 0.35113339835799434`, 
                  0.5223060040065196, -0.46892617542646425`], 
                 
                 ArrowBox[{{-0.9208853328328414, -0.8902058857404701}, \
{-0.8961246344652734, -0.911095342044929}, {-0.8827348569116702, \
-0.9230133048518945}, {-0.8682947225185547, -0.9361030921782629}, \
{-0.8588649234948803, -0.9445675336062146}, {-0.8491859458268007, \
-0.9532079739539441}, {-0.8293675005343208, -0.9708575836129215}, \
{-0.8094785374282746, -0.9884880736347605}, {-0.7858727960604008, \
-1.0090674933581183`}, {-0.7626418647074424, -1.0286982099991473`}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.33175999019508295`, 
                  0.5223405969497051, -0.5152275647247406], 
                 
                 ArrowBox[{{-0.723991803999137, -0.3760366649239075}, \
{-0.7149318668675283, -0.3030645826027648}, {-0.6963101244327764, \
-0.22786302547605497`}, {-0.6845186982614417, -0.18980976863634777`}, \
{-0.6699267503607662, -0.15106929364344476`}, {-0.6500854415841525, \
-0.11185920582972926`}, {-0.6280566188238771, -0.07124774029358055}, \
{-0.605898357872575, -0.029296330043247023`}, {-0.5853351051998575, 
                  0.011643986231630803`}}]}}, {
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.40217622473961795`, 
                  0.5222872193238544, -0.3447046610772783], 
                 
                 ArrowBox[{{-0.5808311834990557, 
                  0.02100716821837421}, {-0.5613190391866607, 
                  0.06277139854461247}, {-0.5399256461777492, 
                  0.11313819648630571`}, {-0.5295304598221594, 
                  0.13946085201028371`}, {-0.519348956547291, 
                  0.16661457606327001`}, {-0.5093741692697016, 
                  0.19463577044219554`}, {-0.4900297715300826, 
                  0.25342128660450025`}, {-0.4714632318738658, 
                  0.3161551526167457}, {-0.4536493703382221, 
                  0.3831810080043994}, {-0.4469961530388951, 
                  0.4135795516420762}}]}}, {
                Arrowheads[{{0.008965369071859384, 1.}}], {
                 LABColor[
                 0.48372389236440183`, 0.5275184212522956, 
                  0.016044725580581252`], 
                 
                 ArrowBox[{{-0.4447744766348146, 
                  0.4237303890609997}, {-0.4386945791390495, 
                  0.45150943505072144`}, {-0.4315456607847848, 
                  0.5236962644073139}, {-0.4391106923977355, 
                  0.5723343851311063}, {-0.4564926734737852, 
                  0.6039980691227588}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.02, 1.}}], {
                 LABColor[
                 0.36672889621961535`, 
                  0.5222781568581532, -0.4316537857818932], 
                 
                 ArrowBox[{{1.0240008135738865`, -0.32635228130900135`}, {
                  1.0301136499694286`, -0.2533199862666439}, {
                  1.0402864368760334`, -0.16694864664312864`}, {
                  1.0445984860485247`, -0.13387800777305897`}, {
                  1.0494409672502847`, -0.0978265749145451}, {
                  1.054885780268358, -0.058158293656591226`}, {
                  1.0578563315984795`, -0.03678217411440891}, {
                  1.0609940852665671`, -0.014365603646404714`}, {
                  1.0647849705797108`, 0.01393973674578211}, {
                  1.0716109867284531`, 0.0864672484006534}}]}}, {
                Arrowheads[{{0.018244590191714795`, 1.}}], {
                 LABColor[
                 0.49197635809820073`, 0.5280561663828081, 
                  0.052809666188873665`], 
                 
                 ArrowBox[{{1.0725846568531627`, 0.09681264896506425}, {
                  1.0726619085846754`, 0.09763346094903153}, {
                  1.0731514285473045`, 0.16562197547745885`}, {
                  1.0675270990630907`, 0.2216202714709817}, {
                  1.0632964182569502`, 0.2470376039240464}, {
                  1.057699256381523, 0.27025168265937427`}, {
                  1.047201391054772, 0.2940201249264803}, {
                  1.0346543794220278`, 0.3156727403407093}, {
                  1.005162056338072, 0.3553100750904639}, {0.9669787547977884,
                   0.3885944439180552}, {0.9221304821335976, 
                  0.4174957688376388}}]}}}}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.011160432995853413`, 1.}}], {
                 LABColor[
                 0.27362478242570215`, 
                  0.5224444025332416, -0.6541675418434472], 
                 
                 ArrowBox[{{-0.3041869524086682, -0.283168516633716}, \
{-0.3313447340700502, -0.2707379044151776}, {-0.3555631083711158, \
-0.2557644973675911}, {-0.3667992862072778, -0.24749208968330771`}, \
{-0.3770169092214017, -0.23827625068694405`}, {-0.38536695097681517`, \
-0.22611151629314097`}, {-0.3924038718753769, -0.2124725599603061}, \
{-0.40375111052274454`, -0.18199186361758202`}, {-0.4095244964633148, \
-0.14461783456305605`}, {-0.40936202452656684`, -0.09917665134745327}}]}}}}, {
             
              Hue[0.67, 0.6, 0.6], 
              Directive[
               RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                Arrowheads[{{0.00817081792182162, 1.}}], {
                 LABColor[
                 0.30892605456209343`, 
                  0.5223813689724391, -0.5697994260133921], 
                 
                 ArrowBox[{{-0.8505634664372438, -0.7442646586577388}, \
{-0.8338401463408152, -0.7638324195364037}, {-0.8247823899118436, \
-0.7756429507556396}, {-0.8149572628124717, -0.7897665935118657}, \
{-0.8028632302182841, -0.810339153952817}, {-0.7892887409016477, \
-0.8353185940382933}, {-0.7630723158771177, -0.8889375540459789}}]}}}}}}}}}, 
        TagBox[{}, Annotation[#, "GeoGridLines", "WolframGeoGraphics"]& ]}}}, 
     
     TagBox[{}, Annotation[#, "GeoScaleBar", "WolframGeoGraphics"]& ]}, 
    CoordinatesToolOptions -> {
     "DisplayFunction" -> (
       GeoGraphics`GeoGridPositionDisplay[#, {
        "EckertVI", "LongitudeDetermination" -> -2.842170943040401*^-14, 
         "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
          179.99999999999997`}}, "Centering" -> 
         GeoPosition[{0., -2.842170943040401*^-14}]}, "ITRF00"]& ), 
      "CopiedValueFunction" -> (
       GeoGraphics`GeoGridPositionCopiedValue[#, {
        "EckertVI", "LongitudeDetermination" -> -2.842170943040401*^-14, 
         "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
          179.99999999999997`}}, "Centering" -> 
         GeoPosition[{0., -2.842170943040401*^-14}]}, "ITRF00"]& )}, 
    Method -> {"VectorMapRemoveLabels" -> True, "OriginalInput" -> HoldForm[
        GeoGraphics[{
          GeoStyling[], {
           Opacity[0.8], {{
             GraphicsComplex[
              GeoGridPosition[CompressedData["
1:eJxtmnlc11W6x3/8fiyijZpLOmaMazO5ReM2hfr56WiXDB0qIZu0zG3UchmH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               "], {
               "EckertVI", "Centering" -> 
                GeoPosition[{0., -2.842170943040401*^-14}]}], {{{
                 EdgeForm[], 
                 Directive[
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  AbsoluteThickness[2.], 
                  Opacity[1], 
                  FaceForm[]], 
                 GraphicsGroup[{
                   Polygon[CompressedData["
1:eJxNmgX4H8URhm8XJyRosAIBgiaBAA0eoEhxCU6AJhDcoRDcobiUUFyDFnd3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                    "]], 
                   Polygon[CompressedData["
1:eJwllemPzmcYhd/njk8+1C61VIwtkZbQhtAiaqeWGmZGxDq2qrEz9qqlZmyl
jH1pJ9aqpbVXUTGIPTpIxL6kaROJP0Fcx/lwJddv8r6/91nOuScrf3L2pMhk
MoVQAbrycBZOpkzmFEzDe8EIfD5Uwe9DGV6Rz8/A+8BInhfAHfweXMBnwl28
GxQn/20ungdj8EXQBH+p7+CtYRe+G7bgwyELfwK38ErQDG8IU/A5cAI/Dp+x
lh08f4zXg234bGiKfwhb8R8hB/8fnuGd+U4xXgTLeV4BN/ASWIefgwb4U7iD
fwAd8cnh386DfPwxXMdz4U/8NPTF18BefE94bTthKP4IruIDtGf8D/gteQ9j
8OdQzvMg2ID/Apvwo7BW74IN+O+wH9+nz+Cl0EZ3B4e0V97XFp8XPuvD2iO+
MnwWveAA/ivswnfDTXwjrMfPwxt8QPis/uP5mr4b3ttf8DX+AK7gPWAqXhlW
4fOUGbw2rMYXQ13tNfxbDzM+6zrwU/KZf4l3gcH4UhgYXoN+uycorC2hKz5L
Z4bPDGevG3TCx8FUfBlc17thLX4WOuDDYSJ+HG7jQ6AAP5ac1QKYkZzZT/FX
2iPeiPWuC9+Bzl7v7Btek9aiDmzV3iEHL4Fvwp1636Xku20UzrLu+Dx+Lpx9
dU5d6A7DkjsxEf9bmcIL4edwRpVNZeJCuDPqij7zL94DOuKPkrszKpxNdagM
vwg12cuZ5Gwr08qyMq5u5IazoY68VvfD2X+RfBY6c521zmR7OBPKgjI5WNkO
Z3GcMh++A539Rjiis4P9yWs4hdcKZ/VIcpY/D7syrSwrw8quMn0Yb6HMJr/j
GH40nD11qDScYWV3M1zCL4f32gUOhjOgu9+bnP324btXB85oL+HvZuuMwx1U
99QJdb0+vM2485od/+iOkmdIeXgGavbpb5qVvcO/rZnZGW8Oc5MzXjU8YzVb
lenl4Rmm2bUSquGF8B2eD1+FM6EsaCZXCndOXdPMHIsvgR+SOzBBDkXJmdZs
3BLOpmbkF/i28F1pZmltjcNZ1RrXh+9Qd6eODgrPNM0yzfD+eCtYiI9KXmuN
sGvNo8OdVpc1s78Nd1TdnJ783WwYnfwO3W2/8F51x5qVH4VnhWbmZrxd+G7U
2ZHhjCqb6pxmUfVwVzWTPsEPhe9ad7YwPIM1e5fAMJ1t2DUTZodnjmbN98qo
uh12rbFnuGPqljqq/y2acZpt+h+zNDzDNbt1Bzr78eG96g7eAQgO9zM=
                    "]]}]}, {}, {}, {}, {}}}], {}}, {{{}}, {{
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.00007224463614766065, 1.}}], {
                  LABColor[
                  0.3353766719310453, 
                   0.5223341390428278, -0.5065838925522138], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.1716887870193479, \
-0.00015259273526993812`}, {-0.17316079297801482`, 5.093593268642099*^-6}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.22233413145649794`, 
                   0.5225359865519132, -0.7767494013653833], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.7723176052780472`, \
-1.0803870112164469`}, {-1.7536860360115551`, -1.1059606941556261`}, \
{-1.7118760751728281`, -1.1290833425395022`}, {-1.6483848314005713`, \
-1.144248927400029}, {-1.582362935159195, -1.1466785889300952`}, \
{-1.512368976577881, -1.1427046345533607`}, {-1.4445025607953634`, \
-1.1366432924892886`}, {-1.3784535297712635`, -1.1277977481980745`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2822019992338795, 
                   0.5224290871498439, -0.6336684612897518], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.3682057892739454`, \
-1.1261184578147616`}, {-1.304459468649336, -1.1127688196466101`}, \
{-1.2397392964506597`, -1.0913605517630913`}, {-1.1892999084298996`, \
-1.0657052993994187`}, {-1.1431073686477602`, -1.0298389205670984`}, \
{-1.1016483762251426`, -0.9836261888222545}, {-1.084050130373865, \
-0.9593077203868495}, {-1.0676048296415197`, -0.9333341844874635}, \
{-1.0523356657356637`, -0.906108605900036}, {-1.0458984875041535`, \
-0.8945663270985005}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.2900432737266605, 
                   0.5224150858568991, -0.6149282427473095], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.0408372200271498`, \
-0.885491145674634}, {-1.0292102835216945`, -0.8646432931020896}, \
{-1.0079525550887585`, -0.8289747286480688}, {-0.9886123328629105, \
-0.7977086513873676}, {-0.9739589859170993, -0.7748449707070588}, \
{-0.9605318025550447, -0.7533302624062174}, {-0.9487756324342781, \
-0.731444630295725}, {-0.9392491479164364, -0.7068217024773719}, \
{-0.9340725133254533, -0.6760562889485693}, {-0.9358790355166191, \
-0.6343171588425163}, {-0.9496549927742097, -0.5733673760891583}, \
{-0.9554312372617443, -0.555309110407428}, {-0.9624418618316078, \
-0.5353107752708062}, {-0.9708531246916196, -0.5131207709539505}, \
{-0.9746964448316493, -0.5034788674370446}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.5077968885835146, 0.5290870598763435, 
                   0.12329052396475847`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.9786248282403233, \
-0.493859059374807}, {-0.9808344751139446, -0.48848949484553456`}, \
{-0.9890763809225357, -0.4692873251020521}, {-1.0161124960965098`, \
-0.4101662410748128}, {-1.0419269947800507`, -0.3599103402882265}, \
{-1.0875058969723506`, -0.2832872438304651}, {-1.1356567365222758`, \
-0.21713430490211216`}, {-1.181447300156291, -0.16860937752398583`}, \
{-1.2060992130015176`, -0.15197477453233044`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.25356526458893636`, 
                   0.5224802205862668, -0.7021086958564969], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.2147127589281297`, \
-0.14616253116853292`}, {-1.2389830666082287`, -0.12978542748175168`}, \
{-1.2864736892324673`, -0.1199647065217323}, {-1.3421774470267422`, \
-0.12821584897302477`}, {-1.3972194965969857`, -0.14249413358379945`}, \
{-1.4288168863566917`, -0.14785548124602815`}, {-1.4594817838546406`, \
-0.14780138196085418`}, {-1.4880917348131228`, -0.14095820814813897`}, \
{-1.5017367844226583`, -0.13575559864823258`}, {-1.5145962005501676`, \
-0.12911409479952687`}, {-1.5288103129120387`, -0.11767255717229846`}, \
{-1.5413232305538118`, -0.10580667086039347`}, {-1.563260436297262, \
-0.08251354657938217}, {-1.5795072215549253`, -0.061361510750677646`}, \
{-1.5847292467226208`, -0.05363258255494482}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.007144644978771635, 1.}}], {
                  LABColor[
                  0.2075974585657392, 
                   0.5225623001919175, -0.8119692461515283], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.5905466204704286`, \
-0.045022500730235955`}, {-1.5914493777314116`, -0.04368636277144602}, \
{-1.6102212513486067`, -0.015184233459852427`}, {-1.6251725399314318`, 
                    0.005510451710021589}, {-1.6405151997699599`, 
                    0.024192508012973186`}, {-1.6474710576255143`, 
                    0.031941519830996766`}, {-1.6554650548534569`, 
                    0.04037070507229182}, {-1.6728107044295932`, 
                    0.054613943744904594`}, {-1.6906006858865765`, 
                    0.05990855852514021}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.3546275526958193, 
                   0.5222997648832083, -0.4605753370554638], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA9cgXX2r3AsCMQdQGwRjlPwmCXCLZ
5gLAGIa7bP4c5T8paqAPT2sCwKhdpF6Hc+U/cZvj45oKAsBdl2F4/d3lP+4l
VSPolgHAsgQ3jpda5j+VIoLvyxQBwO/KN75AtuY/j948PZn9AMBuY4JPQL7m
P24Bnhh85gDA9jIrTAzC5j9soDB8kM8AwLeISwY5weY/t/VAlQLLAMCfvpyo
fcDmP0VnoIB3xgDASdZZu5S/5j/EquYZEcMAwPVzVWTIvuY/8OAIauu/AMCs
Ix4E6r3mP/wT+427uwDA/1JaVJ+85j+wYQGKjrcAwP3M7Cctu+Y/HKuCv9+i
AMB+7uBNd7HmP5Or+TiMjgDAcKgDD5mj5j8fDumln3oAwLZMLjuHkeY/KQAH
hUXN/7+AT9sIR1jlP5g2PWygo/+/hizFvVHr5D/fFKRQ
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.5396982371827451, 0.5311658076614755, 
                   0.26541182739187885`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.9711373157330543`, 
                    0.6454700959081243}, {-1.9351980806583131`, 
                    0.5984550635325507}, {-1.9168434873112088`, 
                    0.5535549684578726}, {-1.9038505680728521`, 
                    0.500445563844388}, {-1.8924554588844618`, 
                    0.41199551720580485`}, {-1.8868282550173097`, 
                    0.3444128283318271}, {-1.8817769466629097`, 
                    0.28995627150238973`}, {-1.8774280572153064`, 
                    0.2485879083941554}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.012670194590905385`, 1.}}], {
                  LABColor[
                  0.4331323660580572, 
                   0.524496369548637, -0.20087197642680865`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.8761603551545818`, 
                    0.2382750337656797}, {-1.8685686912881208`, 
                    0.17980125914602818`}, {-1.8604074611443822`, 
                    0.13177555654052261`}, {-1.8526433094636343`, 
                    0.09676312935862467}, {-1.8452286456330582`, 
                    0.07112582302483729}, {-1.8344675804403276`, 
                    0.04392300273298738}, {-1.8249253416779376`, 
                    0.026434844868031143`}, {-1.8167879517032572`, 
                    0.014635512028804717`}, {-1.8099262657143496`, 
                    0.006473840127347684}, {-1.8019198352792694`, \
-0.0012596626219341994`}, {-1.7955838419021006`, -0.00577744966506491}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.23258496205403362`, 
                   0.5225176827822573, -0.7522504750982016], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.0980954045632028`, -0.501379352140422}, {
                    1.081962427837263, -0.4773497450913674}, {
                    1.0803276449190735`, -0.43728165683359493`}, {
                    1.093532968254583, -0.38305073953665264`}, {
                    1.116092744476593, -0.31413394320360094`}, {
                    1.1280472478280057`, -0.27688948999894214`}, {
                    1.1410237653563642`, -0.23426571271370572`}, {
                    1.1547864729060082`, -0.18484963324010556`}, {
                    1.1618298775051474`, -0.15824004488607077`}, {
                    1.168968663477028, -0.12948264867169898`}, {
                    1.1744035389466412`, -0.10390852136129755`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.46240389220142414`, 
                   0.5261291726761754, -0.07893640673123221], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.176411297870591, -0.09371353797943931}, {
                    1.1806580089412884`, -0.07167737436690011}, {
                    1.1916902879447528`, -0.008243479801205149}, {
                    1.2008856723262369`, 0.05688994750859088}, {
                    1.207441658853219, 0.11575110290695347`}, {
                    1.2121154872113684`, 0.177559707240203}, {
                    1.2136399300274547`, 0.22789357859099793`}, {
                    1.212689731923392, 0.2695569920492878}, {
                    1.2095613845250452`, 0.30417177225990627`}, {
                    1.2056530953854312`, 0.3186955449433328}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.29296598591145434`, 
                   0.5224098670943713, -0.6079431199678276], 
                  Arrow[
                   
                   GeoGridPosition[{{1.2029529411006998`, 
                    0.32872971223257563`}, {1.1921361538252755`, 
                    0.36892647197608636`}, {1.1603661869574735`, 
                    0.4124542106638245}, {1.1111423581473654`, 
                    0.4465014905029794}, {1.0409505420355014`, 
                    0.47980236173680246`}, {0.9957681562573844, 
                    0.4975750239948481}, {0.947144741066452, 
                    0.5139835312736054}, {0.8973680544041005, 
                    0.5285659860492027}, {0.8674597916139186, 
                    0.5361254154631886}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3239677185551192, 
                   0.5223545107436984, -0.5338506691205167], 
                  Arrow[
                   
                   GeoGridPosition[{{0.8573854874860412, 
                    0.5386717349028692}, {0.8487258542117257, 
                    0.540860490797768}, {0.8015537561526402, 
                    0.553091675442454}, {0.7561873758901564, 
                    0.5674841699064136}, {0.7133708990819334, 
                    0.5861578606954763}, {0.67384851138563, 
                    0.611232634315472}, {0.6381982291376971, 
                    0.642357952747987}, {0.6069980686745855, 
                    0.6791832779746076}, {0.5792397591799766, 
                    0.7218860710285497}, {0.5539150298375518, 
                    0.770643792943029}, {0.5476183914222887, 
                    0.7847017739921633}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.35350042616225097`, 
                   0.5223017774678712, -0.46326910802133203`], 
                  Arrow[
                   
                   GeoGridPosition[{{0.5433707726016564, 0.794185079360255}, {
                    0.5325071577179499, 0.8184393690444214}, {
                    0.5108567996117451, 0.8703763849713608}, {
                    0.5034940930933975, 0.8872112033009045}, {
                    0.4971977126993973, 0.8988316512660421}, {
                    0.4903685321802077, 0.9095660956322943}, {
                    0.47530419290642145`, 0.9284484121209182}, {
                    0.45860211883861635`, 0.943997685660405}, {
                    0.44061742322393943`, 0.9564415504269665}, {
                    0.37768591939403895`, 0.9788729518814446}, {
                    0.3145921450233307, 0.9817674363533982}, {
                    0.25632298331570114`, 0.9719006916213306}, {
                    0.22759907533336887`, 0.9614310509898447}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2874793571433574, 
                   0.5224196639579721, -0.6210558636002625], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA+CYm9w7iyz8ZlWxl5KbuP/Zt74QV
d8o/uANFHNGF7j8prWn7B3rCP8LoittnPe0/asDhsoSqtj9Vf6xHNM/rP0CS
3SLpxKA/gmE0R6q/6j9rxsBx8HeUP7l46DkBmOo/a2eMnHbxfz/nhb+OsHnq
Pyxm82ughW+/qFQBCuxj6j9PncvzJqyOv52CmwvlVOo/ChOR5wUvob/Imz/E
4kXqP2l/nhOz+Km/255eF6lC6j97Kg6VLAuxvzzHTpzvR+o/C6cuHVBUtb+i
5IWplVTqPw1FtuZCQbm/qvkQcbFk6j9Ug7ELPty8v2m6wq1Qduo/bcAkSvtE
wL9QqjWq94rqP3T9Mf8p88G/Xl/WBx2g6j+OFufCe3zDv1mmJ1ckteo/yupo
3U0ixL/uZaXq0b7qP2t+o3g=
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.004852267887244553, 1.}}], {
                  LABColor[
                  0.21107070477446999`, 
                   0.5225560984019301, -0.803668377069181], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.1674159008044099, 
                    0.8381558189974774}, {-0.17243288618912672`, 
                    0.8393270729859349}, {-0.18938609159919273`, 
                    0.8436458405413936}, {-0.2035674512004715, 
                    0.8474569034682023}, {-0.21845722383049324`, 
                    0.8516546825647775}, {-0.23009667756639204`, 
                    0.8551202235434983}, {-0.23913673343048836`, 
                    0.8579423255917793}, {-0.2505552974480957, 
                    0.8617640097373245}, {-0.25751290270439015`, 
                    0.8643753054886085}, {-0.2617906422512824, 
                    0.8660678215665374}, {-0.26401603566978943`, 
                    0.8668289974132709}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.4592294558874002, 
                   0.5259223208424263, -0.09307859966054122], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.9816574596148085, \
-0.31671293434763953`}, {-1.005903480049338, -0.25371156295300706`}, \
{-1.0260748033799367`, -0.19975889315024783`}, {-1.0467150417852584`, \
-0.14129484655572355`}, {-1.0628519090375588`, -0.09072719222111392}, \
{-1.0750180506330793`, -0.046309222632865646`}, {-1.0922900793518724`, 
                    0.03155086425170179}, {-1.1002127866145954`, 
                    0.08056609329624737}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2786748261053175, 
                   0.5224353852311425, -0.6420982127704757], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.1018708623902345`, 
                    0.09082407219426152}, {-1.1030736698756893`, 
                    0.09826545333344067}, {-1.1098385369185833`, 
                    0.15551867904648645`}, {-1.1150543951946075`, 
                    0.20499467582497477`}, {-1.1196707470071263`, 
                    0.25585682606221183`}, {-1.1229548352083305`, 
                    0.300001298909314}, {-1.1261053227287023`, 
                    0.37218525494904975`}, {-1.124588330631832, 
                    0.42900070997616}, {-1.1178173237767737`, 
                    0.4746078096046975}, {-1.1102405100881112`, 
                    0.5038130445691933}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2248805734934028, 
                   0.5225314396531968, -0.7706635437256344], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.107631091250245, 
                    0.5138711895114008}, {-1.1048765792224855`, 
                    0.5244886039403209}, {-1.0859615925760455`, 
                    0.5819741212830148}, {-1.0712594919006537`, 
                    0.6226621728289683}, {-1.0534345563329013`, 
                    0.6638984805030325}, {-1.038845873821864, 
                    0.6854587099554043}, {-1.0228788469361365`, 
                    0.7041931420696375}, {-0.990250783382837, 
                    0.7335205198704499}, {-0.9595717746879989, 
                    0.7445064069394893}, {-0.9339350991143499, 
                    0.7378979066863935}, {-0.9135909587120571, 
                    0.7229145100918959}, {-0.8941251493522043, 
                    0.7062060253228578}, {-0.8750576186470912, 
                    0.6914456357804657}, {-0.8544398491731295, 
                    0.678337279663657}, {-0.8517991930155269, 
                    0.6770753905575873}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0032250429210250544`, 1.}}], {
                  LABColor[
                  0.20430474306849747`, 
                   0.5225681796282646, -0.8198386566756983], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8424235816540995, 
                    0.6725950716013814}, {-0.8360122848338492, 
                    0.6695313082295541}, {-0.8202893910744601, 
                    0.6643301458115818}, {-0.8118782421371895, 
                    0.66229494967135}, {-0.8048028273880613, 
                    0.6608324977797745}, {-0.7989267324522777, 
                    0.6598437350057739}, {-0.7943935491395826, 
                    0.659232212650405}, {-0.7906932590151938, 
                    0.6588161729578783}, {-0.7877100903116736, 
                    0.658527144151098}, {-0.7851857934865005, 
                    0.658312657907338}, {-0.7832153663067416, 
                    0.6581638088337656}, {-0.7816874281879416, 
                    0.6580583623261338}, {-0.7794169177377054, 
                    0.657925782656693}, {-0.7775086245119357, 
                    0.6578696393524003}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.21607784619849654`, 
                   0.5225471577056237, -0.7917015820480958], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.7318964441529756`, -0.731233690084737}, {
                    1.7522220799574784`, -0.7425506014774217}, {
                    1.7666298906861675`, -0.7456957846880167}, {
                    1.7854652229118804`, -0.7463917928736481}, {
                    1.7871759850593418`, -0.7462515710251909}, {
                    1.7892652822036001`, -0.7460654066976995}, {
                    1.7965606185608427`, -0.7452832033462728}, {
                    1.8043938161905608`, -0.7442400927034726}, {
                    1.8128162264550793`, -0.7429136992573177}, {
                    1.892503116204232, -0.719270611240956}, {
                    1.9400254172761355`, -0.695984523666038}, {
                    1.9873712152658494`, -0.6625800797798886}, {
                    2.0323660831571866`, -0.6199908449606284}, {
                    2.0728355939339593`, -0.5691503845863778}, {
                    2.0782777446428926`, -0.5604228984609663}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.36437681003839273`, 
                   0.5222823567172048, -0.4372751435225706], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.0837759218319687`, -0.5516055636058421}, {
                    2.117990147587864, -0.496736781657904}, {
                    2.155768976217591, -0.41628150260076435`}, {
                    2.1811752869595806`, -0.3316563400583744}, {
                    2.193970667535312, -0.263013365373023}, {
                    2.202678572574615, -0.1977955171031162}, {
                    2.2058621332708315`, -0.15980832656473576`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01886194204750932, 1.}}], {
                  LABColor[
                  0.3419463193257748, 
                   0.5223224083531545, -0.4908827934467861], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.206729930911799, -0.14945350770566362`}, {
                    2.2078277541874023`, -0.13635395474366738`}, {
                    2.211641038254433, -0.06431516615374265}, {
                    2.214330457860989, -0.0008809578727457176}, {
                    2.2265088815302185`, 0.0717698390276591}, {
                    2.2581845347196587`, 0.11761329269575724`}, {
                    2.3106807047225733`, 0.14555971840492585`}, {
                    2.3239554465710808`, 0.14990346830780393`}, {
                    2.337062968557727, 0.1536678202333676}, {
                    2.351068605486165, 0.15716538528907817`}, {
                    2.357011132874223, 0.1584779370831727}, {
                    2.3631114500758406`, 0.15975567426630508`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.25232988608023177`, 
                   0.5224824264644584, -0.7050611831411946], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.12323179189942203`, -1.0832568816986252`}, {
                    0.12424731569096102`, -1.0581575006363972`}, {
                    0.11349626546506048`, -1.0283202133276599`}, {
                    0.08714985088738296, -0.9989826349726374}, {
                    0.0583638666285448, -0.9828649399399946}, {
                    0.02200193738747834, -0.9741488372978024}, \
{-0.018319409737852725`, -0.9756005220005155}, {-0.08046235464088956, \
-1.000311271324841}, {-0.11907809503662778`, -1.0411577628077384`}, \
{-0.12862045959240576`, -1.0810733909902206`}, {-0.12385169206150089`, \
-1.0970058247198804`}, {-0.11474938405767557`, -1.1099896437154984`}, \
{-0.10557326344300651`, -1.117775096036702}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.26640944795614435`, 
                   0.5224572861546092, -0.6714117978557597], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.09698215806491708, \
-1.1235495767110533`}, {-0.08849835464880565, -1.1284454329235432`}, \
{-0.07321352347218925, -1.1349892761131164`}, {-0.05720602766722647, \
-1.1404484322434192`}, {-0.03837015662054575, -1.1458909606928798`}, \
{-0.01907074158306623, -1.1508773262946692`}, {
                    0.0007681633270146364, -1.1556523804821928`}, {
                    0.04607251713271342, -1.165793719499313}, {
                    0.09798032324881631, -1.1736289148221255`}, {
                    0.1570080856706771, -1.1743094601257502`}, {
                    0.20708931603347744`, -1.166520114170183}, {
                    0.2555556905081495, -1.1473348061291013`}, {
                    0.295304138600818, -1.1144266135808476`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.33742170481394246`, 
                   0.5223304874547471, -0.5016963754544185], 
                  Arrow[
                   
                   GeoGridPosition[{{0.3019894867623137, -1.10659423229186}, {
                    0.32007673063225134`, -1.0802802030585674`}, {
                    0.3369732241161773, -1.0386511585258045`}, {
                    0.34702322975796335`, -0.983632199931703}, {
                    0.34879520762081645`, -0.9498695074490028}, {
                    0.3475405174442475, -0.9103236676841019}, {
                    0.34335784592181035`, -0.8650726063403833}, {
                    0.33864306757499524`, -0.8181579657607789}, {
                    0.33473564363975966`, -0.765758620144915}, {
                    0.3329710891801406, -0.7173852606344651}, {
                    0.3334605575596161, -0.7014557083290792}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.5059794768375354, 0.5289686341417739, 
                   0.11519390932168515`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.3337796955089504, -0.6910694916300516}, {
                    0.3356332736941121, -0.6307455322268002}, {
                    0.34578785936626, -0.5550609767700534}, {
                    0.3525871408026256, -0.5196557832632285}, {
                    0.36075810191311025`, -0.4867075762966373}, {
                    0.3713275561252079, -0.45738338734660133`}, {
                    0.3807511227954025, -0.43090762788881465`}, {
                    0.3939104941570347, -0.3899690867749841}, {
                    0.4022125247980739, -0.35525566856857643`}, {
                    0.4066150528951289, -0.32516324476256697`}, {
                    0.40624555891396935`, -0.28461413174665773`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.27439905768756606`, 
                   0.522443019995904, -0.6523170661799953], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.40615087629050745`, -0.2742234444955333}, {
                    0.4061406780729876, -0.2731042688232402}, {
                    0.39466864392030576`, -0.23132328158139484`}, {
                    0.37336595725163185`, -0.19670455528046787`}, {
                    0.3154409069510603, -0.15150116259816343`}, {
                    0.2748545267544588, -0.13424589186816077`}, {
                    0.22560474221203589`, -0.12058556331422343`}, {
                    0.16668117767928275`, -0.11067275053220998`}, {
                    0.0970734575116909, -0.10466002711797913`}, {
                    0.06485819636902607, -0.10327974280432832`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.006840853233110581, 1.}}], {
                  LABColor[
                  0.3669754133343102, 
                   0.5222777166799217, -0.43106462331754025`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.05447383316289323, -0.1029094932024373}, {
                    0.02330966868982748, -0.10192963973106925`}, \
{-0.014758178157315623`, -0.1004216984009956}, {-0.0873715897059461, \
-0.09406671685266041}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.25697394231917886`, 
                   0.5224741340890398, -0.6939621419175535], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.2901671316425865`, \
-1.0194359321482782`}, {-1.2892377181130732`, -0.9707066072515094}, \
{-1.3016445323590482`, -0.9362160470357865}, {-1.328185691113244, \
-0.8962427546819475}, {-1.368683805107044, -0.8530602050851613}, \
{-1.3957240007563119`, -0.8276478377489326}, {-1.4229648957422003`, \
-0.8045501767636298}, {-1.4798907924856248`, -0.7586954328311231}, \
{-1.5358749183156346`, -0.7123874426260637}, {-1.5393192321950309`, \
-0.7095002068328351}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.35010232447813944`, 
                   0.5223078450806273, -0.47139038578661346`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.547282576294578, \
-0.7028248418913453}, {-1.6030429252903386`, -0.6560830869001597}, \
{-1.6703666690509147`, -0.598521524800054}, {-1.7048262257161815`, \
-0.5718220887296475}, {-1.7400094960253876`, -0.5491785946710733}, \
{-1.7997429801441849`, -0.5170138375115929}, {-1.8610608718999646`, \
-0.496696678254279}, {-1.8971806323441425`, -0.4919041202097934}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.019999999999999997`, 1.}}], {
                  LABColor[
                  0.32725693072012313`, 
                   0.5223486375628625, -0.5259896313693981], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.907481471570728, \
-0.4905373511810613}, {-1.9242528181659222`, -0.4883120415152933}, \
{-2.0069886780641677`, -0.4854319409309963}, {-2.0839760895315926`, \
-0.4781285364986858}, {-2.15177513027054, -0.4607643199273635}, \
{-2.2089908080717358`, -0.43436290502438424`}, {-2.2551652464397347`, \
-0.40034259400663447`}, {-2.286347143827102, -0.36351813182515874`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.27239861164966156`, 
                   0.5224465919702078, -0.6570980231490708], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.293062059242808, -0.355588109296201}, \
{-2.3106032968916472`, -0.33487267192587455`}, {-2.3424941171506966`, \
-0.26740181588812467`}, {-2.35231107032151, -0.20401474392617186`}, \
{-2.327303764704242, -0.11796767217812551`}, {-2.2992169093918395`, \
-0.08367184127547679}, {-2.2627024805228833`, -0.05298638434670522}, \
{-2.2198957602162293`, -0.024701937253814536`}, {-2.205415696396265, \
-0.01620314671325364}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.013890125910196168`, 1.}}], {
                  LABColor[
                  0.25488266905801577`, 
                   0.5224778682434281, -0.6989601709984438], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.196454129727904, \
-0.010943330252730681`}, {-2.173577527929945, 
                    0.00248364419834972}, {-2.149767531780297, 
                    0.015654145414543436`}, {-2.1256573303908066`, 
                    0.027054548594476317`}, {-2.101322104503469, 
                    0.03440252057933382}, {-2.0767942046450365`, 
                    0.036500147188668564`}, {-2.036576496148013, 
                    0.03173511940683456}, {-1.9991696351981894`, 
                    0.022310268294942603`}, {-1.9669885405669967`, 
                    0.013644342500654653`}, {-1.9431074955828014`, 
                    0.007406146367437447}, {-1.9226692924308042`, 
                    0.0020048664953056555`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.22493738373265204`, 
                   0.5225313382134624, -0.7705277703510434], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8449096888787017, \
-0.6384460904620362}, {-0.8339367441754579, -0.6284183218083594}, \
{-0.824060103584809, -0.6190534834683216}, {-0.815039356837434, \
-0.6096767044457942}, {-0.8069686540011257, -0.5995894786152866}, \
{-0.8008027659573184, -0.5893592442278949}, {-0.7957159098761964, \
-0.576598908813619}, {-0.7921557838226482, -0.5592433806253553}, \
{-0.7909141065322137, -0.5409476840894002}, {-0.7918364001292082, \
-0.5157272159623207}, {-0.7966801569624333, -0.4800108179067247}, \
{-0.8010976770892138, -0.45732751478965905`}, {-0.8067275434141891, \
-0.4314830383061615}, {-0.812992240929164, -0.40319070695408576`}, \
{-0.8241161256559342, -0.34461534064558896`}, {-0.8318599104698969, \
-0.2859887201245433}, {-0.8339759823518562, -0.24511676226794443`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.39243378812489055`, 
                   0.522232258487676, -0.3702204955229942], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8345132441988927, \
-0.2347395422135376}, {-0.8356229521881775, -0.2133055169529287}, \
{-0.831549322199426, -0.14409957834891557`}, {-0.8234002145853536, \
-0.09641108695925715}, {-0.8104174825987763, -0.05012844174114879}, \
{-0.7930150712112525, -0.004840993283836877}, {-0.7716069253943406, 
                    0.039861907823432144`}, {-0.7473011286022246, 
                    0.0855850150254583}, {-0.7212057642890887, 
                    0.13393308176704163`}, {-0.7099343329245008, 
                    0.1546719617466328}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.4212851773301414, 0.523449805150371, -0.2621213067230701], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.7049723330916153, 
                    0.16380179767113384`}, {-0.696737239559867, 
                    0.1789539652043725}, {-0.6716358703487084, 
                    0.22672780977240797`}, {-0.652838894151711, 
                    0.2655051496046719}, {-0.6335038722313375, 
                    0.3070598428041438}, {-0.6140084212902917, 
                    0.35008691091205224`}, {-0.5941921123079006, 
                    0.3960587288368339}, {-0.56885935469538, 
                    0.46303488912632673`}, {-0.5554644126506221, 
                    0.5175880499460139}, {-0.5550402569679788, 
                    0.5480127162662723}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.012527074363680406`, 1.}}], {
                  LABColor[
                  0.31580000042223755`, 
                   0.522369094930794, -0.5533710701655493], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAA9NKuAaDI4b9i3aoncN3hP2nTOeup
E+K/WS7kWcbP4j/SdZ4dUZjiv3eaMPode+M/7CvziSEy478U7Rsp6+zjP1cL
Kq0Z8eO/a6wWAltG5D+ZUhkPL6TkvxHx9BrXf+Q/NVc8pnJB5b/aSoTg/qfk
P4FfM1APx+W/hjdM4JfE5D8tqjImODnmv+NQgPag2OQ/5McEl1ya5r/mSCCc
IebkP8ju3R4wC+e/YfEx57Dx5D9VCpRwBmTnvxAo53A1+OQ/+0GbXNip57/3
sNgcofzkP6sa/CK78ee/zsvV4N8A5T+xk8dbOyfov0ri1MG8A+U/GELFD61P
6L+J6X5qvgXlP4T4sAdih+i/QTa6kFMI5T+GFU0BiKfov7OjVDK3CeU/AJxl
H+e66L+YEK3fpwrlP0m1aN0byOi/BjIOvYAL5T8SA67f
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.36745256363124323`, 
                   0.5222768646856327, -0.4299242601214363], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.4282658599552593`, \
-1.358232344415472}, {-1.37617300936248, -1.359237883751074}, \
{-1.3001658916561625`, -1.3611361194683549`}, {-1.2241510661907322`, \
-1.3629166530695924`}, {-1.1481290351862272`, -1.3645871088171826`}, \
{-1.0721003008626846`, -1.3661551109735213`}, {-1.020056610803509, \
-1.3671274378141804`}, {-1.0127199266695184`, -1.3672459761483493`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.36750169045872816`, 
                   0.5222767769653134, -0.4298068496820731], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.002330164058571, \
-1.3674138428753093`}, {-0.9679231000414185, -1.367969755597971}, \
{-0.9150769903973667, -1.3681315181506901`}, {-0.8608955036923069, \
-1.3670621792981341`}, {-0.8057234310755517, -1.3651294113229753`}, \
{-0.7499055636964131, -1.3627008865078856`}, {-0.6875543462629728, \
-1.359565875913638}, {-0.6245363095779439, -1.3560740041014092`}, \
{-0.5870327936830657, -1.3537814928162542`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.38785650437353697`, 
                   0.5222404316348798, -0.38115995414162923`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.5766610346505425, \
-1.3531474889352415`}, {-0.5607657677636154, -1.3521758446013883`}, \
{-0.49615703494227664`, -1.3478219709437644`}, {-0.4305533292214655, \
-1.3429201143963203`}, {-0.3637978687087201, -1.3373780062268392`}, \
{-0.2958744844864193, -1.3312230747419715`}, {-0.22676700763694185`, \
-1.324482748248368}, {-0.1624125296976301, -1.319388984955596}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.39859532902766853`, 
                   0.5222212565084375, -0.35549474868393605`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.15203632852922513`, \
-1.318883134655228}, {-0.09413381464815873, -1.3170169948927453`}, \
{-0.03266073899007656, -1.3178265833575176`}, {
                    0.025891148332735203`, -1.321120807467138}, {
                    0.07579123656799036, -1.3250859277189537`}, {
                    0.12570866662688107`, -1.328839557502612}, {
                    0.17603596187387466`, -1.332246510655509}, {
                    0.2263806304376604, -1.335464545486223}, {
                    0.26289362245743575`, -1.3377370949446223`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.36677075845823937`, 
                   0.5222780821094033, -0.4315537373138523], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.2732646730613333, -1.3383825836906598`}, {
                    0.282307113638313, -1.3389453804459817`}, {
                    0.33825018378014726`, -1.342239295917272}, {
                    0.394209840863163, -1.3453462919000938`}, {
                    0.4501860848873604, -1.3482663683944474`}, {
                    0.5061789158527393, -1.3509995254003324`}, {
                    0.5621883337593, -1.353545762917749}, {
                    0.6182143386070421, -1.3559050809466975`}, {
                    0.6742569303959658, -1.358077479487177}, {
                    0.6884072837674666, -1.3585875736006157`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3669337971452557, 
                   0.5222777909893282, -0.4311640837405243], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.6987916574984916, -1.3589619111010918`}, {
                    0.7303133761596947, -1.3600982108607098`}, {
                    0.7863809429318522, -1.3620025273888168`}, {
                    0.8424596307124386, -1.363790429071498}, {
                    0.8985494395014535, -1.3654619159087533`}, {
                    0.9546503692988973, -1.3670169879005833`}, {
                    1.0107624201047698`, -1.3684556450469878`}, {
                    1.0668855919190705`, -1.3697778873479656`}, {
                    1.1142637128372497`, -1.370795622427947}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.013024268141605812`, 1.}}], {
                  LABColor[
                  0.36712695826760056`, 
                   0.5222774460829662, -0.43070243918899387`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.1246524133379223`, -1.371019771970523}, {
                    1.1294913680118566`, -1.3711266485037867`}, {
                    1.1359629668275013`, -1.371268405806634}, {
                    1.1424346810994288`, -1.3714089929611724`}, {
                    1.1489065107496146`, -1.3715484161402698`}, {
                    1.1553784557250666`, -1.3716866813861401`}, {
                    1.1683225778137778`, -1.3719609016289214`}, {
                    1.1812671649271635`, -1.3722305215946042`}, {
                    1.1942122208647397`, -1.372495572296059}, {
                    1.2589798858207146`, -1.3734809652911801`}, {
                    1.3238299619396423`, -1.3738094296228873`}, {
                    1.388164103114676, -1.3780244475142207`}, {
                    1.3950279682672746`, -1.3793973379808409`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.1957464752833431, 
                   0.5225834611764966, -0.8402924500974429], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.8318828732259265`, -0.15567637686738015`}, {
                    1.8281826534381946`, -0.15866612573390723`}, {
                    1.823475117394196, -0.16296505363332833`}, {
                    1.8165856541868384`, -0.16967991712786168`}, {
                    1.8061429227419834`, -0.18007355599030336`}, {
                    1.7917187163714192`, -0.1941718451752051}, {
                    1.769444585448407, -0.2147441207471703}, {
                    1.7313224545031025`, -0.24623194554748276`}, {
                    1.692594266739533, -0.2749303132548981}, {
                    1.6364763371950797`, -0.3135737190690733}, {
                    1.5664776328779162`, -0.3622752905016969}, {
                    1.5293725936707856`, -0.38884539131981616`}, {
                    1.5038210410736739`, -0.4096866712804224}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.4916225186647004, 0.528033109585181, 
                   0.051233302690115765`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.4958485243376112`, -0.4163402626657208}, {
                    1.4835444200210222`, -0.4293686269649098}, {
                    1.4715996836224947`, -0.44305256205844773`}, {
                    1.4608899588494328`, -0.45655629825065536`}, {
                    1.4510557836861153`, -0.4698651861899695}, {
                    1.4419401230364532`, -0.4829054624618591}, {
                    1.4247492676795188`, -0.5082133018771701}, {
                    1.4091425575996375`, -0.5320633677752581}, {
                    1.394167417042385, -0.5547358722110007}, {
                    1.349268103337752, -0.6143699834438674}, {
                    1.287963538630131, -0.6713179922445502}, {
                    1.2480842621160986`, -0.6990235444483106}, {
                    1.216252246138696, -0.7173266361503389}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.5008578009102251, 0.5286348967620846, 
                   0.09237671536336463], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.2072440810795055`, -0.7225062412140715}, {
                    1.2010965995440415`, -0.7260409817834405}, {
                    1.147173891747757, -0.7516307761724783}, {
                    1.0874960468619366`, -0.774390145342527}, {
                    1.0580815206872132`, -0.7833470015655645}, {
                    1.0300874838889047`, -0.7896690939711696}, {
                    1.002802191792858, -0.7929900342689331}, {
                    0.9527711758412397, -0.7885820397053399}, {
                    0.9099734975846934, -0.7709485928741395}, {
                    0.8741845421163748, -0.744641047698726}, {
                    0.8366012411217383, -0.7016111175954484}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.42089107975441054`, 
                   0.5234241250616396, -0.2638770212492482], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.8297656375528483, -0.6937848879668953}, {
                    0.8271432557866318, -0.6907824666489673}, {
                    0.7940257440941437, -0.6394112965806438}, {
                    0.7707029065381927, -0.5937534258609484}, {
                    0.7539087470758803, -0.5550932327883544}, {
                    0.7331060212012744, -0.4997360948458766}, {
                    0.7208790526746807, -0.46441295556229273`}, {
                    0.7137805282129188, -0.4397979999414748}, {
                    0.7094818805907838, -0.4204083451776024}, {
                    0.7051153799484328, -0.3958014782634208}, {
                    0.7010259089967674, -0.3732184604831171}, {
                    0.6968325619855037, -0.3509719916936368}, {
                    0.6925908626560386, -0.3280679562312816}, {
                    0.6880117259446364, -0.307318110464759}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.019665133325605214`, 1.}}], {
                  LABColor[
                  0.21633291605593058`, 
                   0.5225467022557094, -0.7910919789948799], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.685772462409353, -0.2971711382479145}, {
                    0.6776855123843909, -0.26052602884952036`}, {
                    0.6557523622475635, -0.203418571414833}, {
                    0.6202674678344585, -0.16713174918199186`}, {
                    0.606194207682588, -0.16043428093476203`}, {
                    0.5896215490241759, -0.15440919533284156`}, {
                    0.5697766739279158, -0.1482860758256028}, {
                    0.5156671296820798, -0.1336029549955687}, {
                    0.4304494158156674, -0.11329324070073343`}, {
                    0.36993898340823456`, -0.10190790842073295`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3640638560300655, 
                   0.5222829155244183, -0.4380230865406583], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.21275470080847414`, -1.0318358860251367`}, {
                    0.20826772784129158`, -0.9823039063176967}, {
                    0.19028445615155565`, -0.9215048191090295}, {
                    0.15679771368518922`, -0.8568052184318979}, {
                    0.12219070067837245`, -0.8061774355271554}, {
                    0.08932842682048664, -0.7642994139366167}, {
                    0.04403083273286052, -0.7131250573275715}, {
                    0.012026375431010095`, -0.6790410499745618}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3278216792475636, 
                   0.5223476291541427, -0.5246399131781142], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.004902113148790068, -0.6714766722211656}, \
{-0.021859774373768237`, -0.6432094442099239}, {-0.04813948138749989, \
-0.6144655571362597}, {-0.0689093146332401, -0.5894873805174867}, \
{-0.08475477637939909, -0.5661563372682771}, {-0.0927981281578262, \
-0.5523604023046413}, {-0.0992442308861499, -0.5384681182012635}, \
{-0.09978316827462988, -0.5368544688195437}, {-0.10142693534249023`, \
-0.5311951331780147}, {-0.10253276855151215`, -0.5263007353118304}, \
{-0.10337418934801827`, -0.5212104276221523}, {-0.10282278753012272`, \
-0.4950974637290915}, {-0.09385344399704533, -0.461015245772859}, \
{-0.07755241252128547, -0.41857569349785584`}, {-0.0616975981529303, \
-0.3730993231882272}, {-0.05384697024220145, -0.33114331360348287`}, \
{-0.055320618652404875`, -0.30082048578864506`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.29554177814163346`, 
                   0.5224052677882746, -0.6017871169662847], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.05739864532079104, \
-0.2908155237493649}, {-0.07813638119367929, -0.2441279686555163}, \
{-0.11859894867463405`, -0.20542152390648508`}, {-0.16766833431299763`, \
-0.1724760536287324}, {-0.20902890181168857`, -0.14593075766650415`}, \
{-0.24613103109272175`, -0.11477954564825342`}, {-0.2752322372772641, \
-0.07507269344730172}, {-0.2948179164987066, -0.023846434818843545`}, \
{-0.3021936441776411, 0.023378023789246204`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.34963685323092775`, 
                   0.5223086762209345, -0.47250283669060894`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.30379713604656394`, 
                    0.03364467661166904}, {-0.3049662119163222, 
                    0.04112990077182834}, {-0.3084619542213784, 
                    0.12086090920838641`}, {-0.3081313894468269, 
                    0.16692313897381322`}, {-0.3065946044007831, 
                    0.21768748245233488`}, {-0.30400390508546304`, 
                    0.27349175481115895`}, {-0.30051159750308243`, 
                    0.3346737712174932}, {-0.29799250150561896`, 
                    0.37366441448013216`}, {-0.29509114966581684`, 
                    0.4146692821537746}, {-0.2925088930753095, 
                    0.4486561779131775}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.5195855564832659, 0.5298552301375485, 
                   0.17580933339285026`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.29175121237117624`, 
                    0.4590194796095841}, {-0.2898956379069271, 
                    0.48869835937075407`}, {-0.28880184625888, 
                    0.5177370987561438}, {-0.2882843818391597, 
                    0.5703532687079594}, {-0.29084504678496687`, 
                    0.6127949784364282}, {-0.29602488599818483`, 
                    0.6465567830089213}, {-0.3268260949551183, 
                    0.7073994452760036}, {-0.38316468559308753`, 
                    0.7230206180194977}, {-0.4243103384056423, 
                    0.7162806508434012}, {-0.47431853533028245`, 
                    0.7012350328214784}, {-0.48090504120641836`, 
                    0.6989289506586299}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0018945154491367168`, 1.}}], {
                  LABColor[
                  0.36042996519438747`, 
                   0.5222894041596735, -0.4467078875232895], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.4907124115036686, 
                    0.6954951722437526}, {-0.5016565288750998, 
                    0.6916633934018298}, {-0.5279416842516584, 
                    0.6826835235273973}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.25889214675901784`, 
                   0.5224707089644233, -0.6893777378841581], 
                  Arrow[
                   
                   GeoGridPosition[{{1.2922111179840778`, 
                    0.35100553297567666`}, {1.302483894224064, 
                    0.3782022685664044}, {1.3114174642683143`, 
                    0.39271814226928675`}, {1.3228194653674448`, 
                    0.40364097704307356`}, {1.3392412477879823`, 
                    0.41184508931391717`}, {1.3653061117600909`, 
                    0.41816831383352165`}, {1.4108525477465064`, 
                    0.4237860453162701}, {1.4942069517828784`, 
                    0.4289271532209845}, {1.552936291426656, 
                    0.4307842323981001}, {1.6282562101670013`, 
                    0.43148080757670393`}, {1.6732890649113703`, 
                    0.4295537643880663}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.6658124089755509, 0.48929335396332346`, 
                   0.7440252537133614], 
                  Arrow[
                   
                   GeoGridPosition[{{1.6836706827370305`, 
                    0.42910951482779436`}, {1.704934101449632, 
                    0.42819961190403194`}, {1.7397434505225409`, 
                    0.42496656178066033`}, {1.7711252505159647`, 
                    0.42028325392929716`}, {1.7970865885958638`, 
                    0.4130859564481381}, {1.8206148101619417`, 
                    0.40495931387147177`}, {1.8632515792032691`, 
                    0.3874949221598543}, {1.8980124903501776`, 
                    0.36852523464398734`}, {1.9269800867630191`, 
                    0.3496003158661568}, {1.9753962396807578`, 
                    0.31231777376886555`}, {2.0138113889607188`, 
                    0.282222128885673}, {2.0454070616153426`, 
                    0.2586801124021367}, {2.050652711920687, 
                    0.255274272647372}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.00888165405295055, 1.}}], {
                  LABColor[
                  0.28289711856746336`, 
                   0.5224278459524556, -0.6320071639794191], 
                  Arrow[
                   
                   GeoGridPosition[{{2.05936798773238, 0.2496157115338035}, {
                    2.0729121587634447`, 0.24082189695261927`}, {
                    2.1264804360229363`, 0.21561638915195996`}, {
                    2.1777762535477336`, 0.2025180636274263}, {
                    2.233651956379396, 0.19571483818916163`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.1979432024048675, 
                   0.5225795387248623, -0.8350423920394858], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAArc5B79549D9DI056WFPgP1f3JxnA
cvQ/GMaHtrmT4D+hO9rJ3Wz0P7a0ZdSF2eA/oOG7/Jxm9D8lIHbSwjDhP8eI
dwg8YfQ/ze9LN0iP4T8kXXLCHF30P7es78r99OE/3LZlUKha9D/jJ8jvnm3i
P8Thd6dFW/Q/dFLt1VPu4j9kLFVzBGD0P/ShRVuGduM/prPWNKpr9D/+9oTP
JhTkP/wXBTIKgPQ/jOv9+uK45D+CDNQLMp/0Pxn4Flm5Y+U/Ebvx/JXJ9D9Z
31ugmA/mP60O3ORUAPU/O06ka1LA5j9ZAT+MzEH1PxEYzeZqduc/AD9A2ZF2
9T8uLdGnlQDoP8LONf3nq/U/WseJqi+P6D/X5BnYRt71PzZzEHy5Iuk/DFnX
ml4E9j9dYLO/EqXpPw7rh7PEI/Y/rhle5yEr6j+TDDITJj32P4bJMjzfs+o/
VspmoqdU9j8GXs8uT1XrP0wOdUaeZPY/d1YZ/yH16z83x8etuG72P+g7FNkl
j+w/IYnYfshu9j/c0Zcv3Y/sP/W807s=
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.20976869142822333`, 
                   0.5225584232625501, -0.8067801179827662], 
                  Arrow[
                   
                   GeoGridPosition[{{1.403813464656615, 0.9028013390306202}, {
                    1.4052088387912274`, 0.9108885393402698}, {
                    1.4114047032142996`, 0.9273569256694824}, {
                    1.4226599917001348`, 0.94132770960149}, {
                    1.4376597105625533`, 0.9505030323164746}, {
                    1.4609077380070126`, 0.9565828898134933}, {
                    1.4984282713219994`, 0.9578244704588046}, {
                    1.52457625552925, 0.9561161235907487}, {
                    1.5561972265336232`, 0.9529361817650913}, {
                    1.5928832757412708`, 0.9487335262327676}, {
                    1.6735772594097058`, 0.9412700182057587}, {
                    1.7592414830252128`, 0.9372281305023364}, {
                    1.7768713517430215`, 0.9367619149940106}, {
                    1.7902735751398395`, 0.9365729008002125}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.015589494874925516`, 1.}}], {
                  LABColor[
                  0.33773369342373155`, 
                   0.5223299303713387, -0.5009507396862046], 
                  Arrow[
                   
                   GeoGridPosition[{{1.8006642679962426`, 
                    0.936510664403336}, {1.8015738797080965`, 
                    0.936510664403336}, {1.8037592329408247`, 
                    0.936510664403336}, {1.805944586173553, 
                    0.936510664403336}, {1.8670812997277995`, 
                    0.936510664403336}, {1.928218013282046, 
                    0.936510664403336}, {1.9936949585884263`, 
                    0.936510664403336}, {2.060610606306324, 
                    0.9365106644033359}, {2.124648849201187, 
                    0.9365106644033359}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.22339457400866636`, 
                   0.5225340930374294, -0.7742150014795436], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.8634464207133243`, -0.2862106185034364}, {
                    1.8786663399563648`, -0.2892192818739126}, {
                    1.9004992943594439`, -0.28698361029231195`}, {
                    1.9282676984013762`, -0.2777781288462722}, {
                    1.9511911309225936`, -0.2658175943357089}, {
                    1.9740998556254816`, -0.24940812923723535`}, {
                    1.995168620794452, -0.2289502805750147}, {
                    2.0050269309528757`, -0.217781946691828}, {
                    2.013980352722218, -0.2057907439595237}, {
                    2.0264957677104385`, -0.17532683454298473`}, {
                    2.033839707942932, -0.14392357829727476`}, {
                    2.039079357620466, -0.08234908600715626}, {
                    2.027767510874151, -0.02156157765625198}, {
                    2.0130167374412884`, 0.022906820817631044`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.007389584074092327, 1.}}], {
                  LABColor[
                  0.2689636567109937, 0.5224527253877272, -0.665307378183554], 
                  Arrow[
                   
                   GeoGridPosition[{{2.009824184845599, 
                    0.03279303008074613}, {1.9999329718532404`, 
                    0.07014466443738501}, {1.9999980984796681`, 
                    0.09544740895315645}, {2.0066061964773634`, 
                    0.11278749747294961`}, {2.016372370585747, 
                    0.12506956218854223`}, {2.0286591427523972`, 
                    0.13495228798924344`}, {2.043120913204222, 
                    0.1431569021774765}, {2.064365724454762, 
                    0.15193484101253185`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2162177431871195, 
                   0.5225469079071092, -0.7913672358722749], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.2904145354534655`, \
-0.025777992649403968`}, {-1.3010333592530987`, -0.0020438231236712626`}, \
{-1.3053302753488203`, 0.014900943141397633`}, {-1.308155315328491, 
                    0.03283062000851909}, {-1.3101941953039693`, 
                    0.05136031441781898}, {-1.3203318408575562`, 
                    0.13228977910208023`}, {-1.3280291318875619`, 
                    0.17782119544458364`}, {-1.3381939197897759`, 
                    0.22742609990572288`}, {-1.3488027009634025`, 
                    0.2723660872958118}, {-1.361811537312759, 
                    0.32129669074437006`}, {-1.378654314494176, 
                    0.3756720105050902}, {-1.3798188750992737`, 
                    0.37872244303495783`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2505410434650744, 
                   0.5224856206020326, -0.7093364194662266], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.3835249867628274`, 
                    0.38843017617339626`}, {-1.3953463087276925`, 
                    0.4193947690935224}, {-1.419311899794942, 
                    0.4721026753787329}, {-1.44853664929506, 
                    0.5413977854903534}, {-1.4651024224118923`, 
                    0.5984337449920917}, {-1.4770387027273164`, 
                    0.6696531408224398}, {-1.4820221196347863`, 
                    0.7332492658861577}, {-1.4824351260505764`, 
                    0.787245031362288}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.4193644098223191, 
                   0.5234225765343644, -0.2676575327645945], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.4825146040075625`, 
                    0.7976358460370003}, {-1.4825859779235817`, 
                    0.8069671520001591}, {-1.4790527948720533`, 
                    0.8871637905247896}, {-1.4763375496954885`, 
                    0.9279245341898963}, {-1.4733348383541476`, 
                    0.9637389108058411}, {-1.4712591310670402`, 
                    0.9836963295484135}, {-1.4691941827993342`, 
                    1.001913668616326}, {-1.4650852362808107`, 
                    1.0352428370353186`}, {-1.461077496722466, 
                    1.0629567423513087`}, {-1.4572722699102918`, 
                    1.086114242770048}, {-1.4478793206175915`, 
                    1.1334742634247714`}, {-1.441246064958029, 
                    1.1637124835372643`}, {-1.4367726927092215`, 
                    1.183526942051398}, {-1.4336741948152867`, 
                    1.1966274184541066`}, {-1.43172894147049, 
                    1.2053743870414577`}, {-1.430999692843506, 
                    1.2091255310445987`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.00032168183799009527`, 1.}}], {
                  LABColor[
                  0.19225210023807754`, 
                   0.5225897006939006, -0.8486438159471936], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.4293635926852806`, 
                    1.21938404244781}, {-1.4292681809699697`, 
                    1.220117979788961}, {-1.4290515108748092`, 
                    1.2227344387813723`}, {-1.4289556750621215`, 
                    1.2243510515541494`}, {-1.4288637000168019`, 
                    1.2260488513809145`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.244082901922017, 0.5224971521880913, -0.7247710256653008], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.5454250455885374`, \
-1.0703908218369307`}, {-1.5205360296723176`, -1.0201505359006704`}, \
{-1.5285094482998987`, -0.9868863612350728}, {-1.5530596222418818`, \
-0.9460318122400228}, {-1.5982555684397222`, -0.8965334303633279}, \
{-1.6073455712102784`, -0.8880670113050313}, {-1.617095010532791, \
-0.8794288342423373}, {-1.6274816667927072`, -0.8704176807941251}, \
{-1.6860703913571526`, -0.8323531100446891}, {-1.7541903785375272`, \
-0.8109677806046931}, {-1.7843687033338538`, -0.8094838519121503}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01878263750471728, 1.}}], {
                  LABColor[
                  0.3873228608841902, 
                   0.5222413845027878, -0.3824353329876724], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.7947472824273143`, \
-0.8089735163846301}, {-1.8321758353928264`, -0.8071330794471683}, \
{-1.8738610813170562`, -0.809958729148336}, {-1.9178851921510385`, \
-0.8167969196665497}, {-2.0049380331273343`, -0.8353595647557281}, \
{-2.0598166455753, -0.8480083464685}, {-2.1154074247293853`, \
-0.8611562776577963}, {-2.150361168880918, -0.8696158954859737}, \
{-2.1779409353112213`, -0.8751208967934848}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.19705434590023257`, 
                   0.5225811258571988, -0.8371667106263515], 
                  Arrow[
                   
                   GeoGridPosition[{{0.6951420964085137, 
                    0.011181223133700634`}, {0.6849810802790083, 
                    0.02401245463055547}, {0.6603082867974441, 
                    0.038796602468524594`}, {0.6126676442435841, 
                    0.05501838833747919}, {0.5760220329414859, 
                    0.06490459074005642}, {0.5301018824493268, 
                    0.07636230730568866}, {0.47556455631816336`, 
                    0.09059064778780468}, {0.4259344456457189, 
                    0.10556066268946625`}, {0.3745939105727062, 
                    0.12595385063354825`}, {0.323511302399727, 
                    0.15666380715536604`}, {0.31552724091857026`, 
                    0.16542957722675922`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.30381081521058956`, 
                   0.5223905026872083, -0.5820245691878002], 
                  Arrow[
                   
                   GeoGridPosition[{{0.30853013762590425`, 
                    0.17311175737705686`}, {0.27747674782882925`, 
                    0.20720554229353644`}, {0.2638233692751112, 
                    0.23564681994888603`}, {0.25382390415868594`, 
                    0.2705558572047339}, {0.24877892485560224`, 
                    0.31300290669372366`}, {0.24766954750444511`, 
                    0.33623481871925076`}, {0.24813474189833043`, 
                    0.36157834525280985`}, {0.25210457761539246`, 
                    0.38992937614051987`}, {0.25796264668192326`, 
                    0.41998520179658466`}, {0.270181543858342, 
                    0.4783716147506311}, {0.2807517007595804, 
                    0.5309159967804854}, {0.28598189231275056`, 
                    0.5683702333920309}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.013813026278761594`, 1.}}], {
                  LABColor[
                  0.38439136555015313`, 
                   0.5222466189484096, -0.3894414470150008], 
                  Arrow[
                   
                   GeoGridPosition[{{0.2871678535963011, 0.578683071966251}, {
                    0.2894334003159152, 0.648035769578713}, {
                    0.28172929290069143`, 0.7031511458201173}, {
                    0.26627209759208115`, 0.7439668843020925}, {
                    0.22349621036838943`, 0.7890859913599206}, {
                    0.1714520005682779, 0.81031362895605}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.20453601462151164`, 
                   0.5225677666723394, -0.8192859302725957], 
                  Arrow[
                   
                   GeoGridPosition[{{0.7818478166614065, 1.196813471871301}, {
                    0.7918408860823712, 1.2007306854228932`}, {
                    0.8108747857731419, 1.205618001873415}, {
                    0.8525823237603295, 1.197254847054767}, {
                    0.8948299890418083, 1.1518874507717365`}, {
                    0.9270504651132019, 1.077777930455328}, {
                    0.9418631907474228, 1.0316544101297995`}, {
                    0.9530756245284643, 0.9863375748020303}, {
                    0.9563669353585722, 0.9654093013862497}, {
                    0.9588512816611334, 0.9454135298563096}, {
                    0.9622411110257733, 0.9074030029975396}, {
                    0.9622736306223743, 0.8821074931373963}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.012624085809408325`, 1.}}], {
                  LABColor[
                  0.27920246416511285`, 
                   0.5224344430864631, -0.640837186573653], 
                  Arrow[
                   
                   GeoGridPosition[{{0.962101867102312, 0.8717277345715488}, {
                    0.9584262485350803, 0.8421823343266089}, {
                    0.9322318377956218, 0.7783444043885932}, {
                    0.8809048015878432, 0.7183042116909311}, {
                    0.8099505633656399, 0.6722478737549774}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.2491609382072475, 
                   0.5224880849027056, -0.7126347957910268], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.19793606528554786`, \
-0.48116780721246527`}, {-0.2228917272417787, -0.48318231795756844`}, \
{-0.25509547090543105`, -0.4963328083105882}, {-0.29970157832359645`, \
-0.527351516520979}, {-0.3530364447981533, -0.5782333826056961}, \
{-0.3815977409635137, -0.6115412016132076}, {-0.41116211626782717`, \
-0.6509371136479993}, {-0.4417188404357689, -0.6974579234240853}, \
{-0.473489938667839, -0.7525340664005475}, {-0.4805412293561421, \
-0.7662306789976269}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.6748854050710672, 0.46860406705636337`, 
                   0.7490866993236412], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.48529749032928976`, \
-0.7754693654792203}, {-0.5084539427617735, -0.8204490680770082}, \
{-0.542379237427034, -0.8964639328991357}, {-0.5470558832968349, \
-0.908641500159345}, {-0.5511104682124008, -0.9202142249226849}, \
{-0.5545956320189458, -0.9312240141968092}, {-0.5552279690521158, \
-0.9333613015342002}, {-0.5558412306874907, -0.935479264919665}, \
{-0.5562889735548722, -0.937055327218157}, {-0.5604274243412889, \
-0.9558124661094137}, {-0.5631791623350724, -0.9730554385599478}, \
{-0.566312655113833, -1.0048456859487154`}, {-0.5653020064799634, \
-1.0317861960044654`}, {-0.5611294882163783, -1.0548011039908405`}, \
{-0.5407882381846904, -1.0995914249421892`}, {-0.5099542095214897, \
-1.1301633774739095`}, {-0.4858997147966735, -1.1430899661829468`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01414740383807972, 1.}}], {
                  LABColor[
                  0.3630850952375364, 
                   0.5222846631888562, -0.4403622714741351], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.47674653523471344`, \
-1.1480087719583745`}, {-0.4715486022329701, -1.1508020770275242`}, \
{-0.4249421181508218, -1.1648492860127344`}, {-0.3742798293180409, \
-1.1736907967878623`}, {-0.321357027704797, -1.1793305172220188`}, \
{-0.25386856567432237`, -1.183403714725615}, {-0.1867096882542269, \
-1.1848592845390389`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.19776737404951258`, 
                   0.5225798526820276, -0.8354626122228684], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8143021794060818, 
                    1.2218723079222726`}, {-0.8123672839192768, 
                    1.2193990112715902`}, {-0.8090069204461183, 
                    1.2155998198029192`}, {-0.8029140762551884, 
                    1.2094597636657534`}, {-0.7914289347276815, 
                    1.1990012962852359`}, {-0.7711791189049998, 
                    1.1811527806170496`}, {-0.750546623285641, 
                    1.1619624888089561`}, {-0.7263418690065222, 
                    1.1359059121835782`}, {-0.7025699005375077, 
                    1.1026918223018893`}, {-0.6914368861564442, 
                    1.084337783648341}, {-0.6820727319864066, 
                    1.0644226073641774`}, {-0.678350385210598, 
                    1.0421570187803202`}, {-0.677808035373161, 
                    1.0193257609854063`}, {-0.6826592298441482, 
                    0.973054067139236}, {-0.6980468262241528, 
                    0.9266695849195983}, {-0.7200103114676367, 
                    0.8824058444334156}, {-0.7289809383115691, 
                    0.8668292031662806}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.005287773041992017, 1.}}], {
                  LABColor[
                  0.4101171613824279, 
                   0.5239341663361503, -0.2744866149854904], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.7341667171941358, 
                    0.8578245908075508}, {-0.753044985521482, 
                    0.8250442713721604}, {-0.7711201007031239, 
                    0.7868223695633075}, {-0.7821389318559008, 
                    0.7591519021431611}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.0031469740121606617`, 1.}}], {
                  LABColor[
                  0.5093154963429996, 0.5291860150194684, 
                   0.13005595939772158`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.9320706520873907`, 
                    1.0828672210314725`}, {-1.8725072899795712`, 
                    1.0686045619338989`}, {-1.8704313158318873`, 
                    1.0681074625339322`}, {-1.8684675155304862`, 
                    1.0676372235607878`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.7454101402859695, 0.30778547245566934`, 0.7884295038076], 
                  
                  Arrow[
                   
                   GeoGridPosition[{{-2.2745063234236422`, 
                    0.7709674008730931}, {-2.238422330603371, 
                    0.7830838410630351}, {-2.179012693133939, 
                    0.8023275082215727}, {-2.123444197787761, 
                    0.817615159260604}, {-2.0688082532569743`, 
                    0.8279623924678882}, {-2.017471295588868, 
                    0.8328965936931856}, {-1.9717997608307327`, 
                    0.8319451487862572}, {-1.8960909542833293`, 
                    0.817815344047046}, {-1.8692627774326966`, 
                    0.8112449893786845}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01977768261864233, 1.}}], {
                  LABColor[
                  0.4596691029464338, 
                   0.5259509690153198, -0.0911199610505341], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.8591699282639742`, 
                    0.8087732001467144}, {-1.8359111967689543`, 
                    0.8030770204953988}, {-1.7838413499308785`, 
                    0.8053717477054849}, {-1.7762567093925283`, 
                    0.8077528291241515}, {-1.7687271680078578`, 
                    0.8107199946080451}, {-1.7604904838931044`, 
                    0.8146745855947882}, {-1.7586234411202286`, 
                    0.8156748963067559}, {-1.7571306372231685`, 
                    0.8165003076458375}, {-1.7557248884565468`, 
                    0.8173062262358955}, {-1.7539682856707939`, 
                    0.8183418415106276}, {-1.7462418919331137`, 
                    0.8233092671975693}, {-1.7392142001066424`, 
                    0.8284134129045394}, {-1.7321745017143688`, 
                    0.8340757506201032}, {-1.6902721587677472`, 
                    0.8774596260006869}, {-1.649604280192144, 
                    0.9307199883840862}, {-1.6133709321675807`, 
                    0.9813432371675658}, {-1.5633854376020504`, 
                    1.0510894550404135`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.21281730025130466`, 
                   0.5225529797003783, -0.7994941091014856], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8815839556382834, 
                    1.3004584163459656`}, {-0.8887074788016484, 
                    1.2951084558637573`}, {-0.9007062378794525, 
                    1.2884772044762483`}, {-0.9203765758094283, 
                    1.2797566571262458`}, {-0.9442048568630719, 
                    1.2705695202730913`}, {-0.980368658450065, 
                    1.2578798974798382`}, {-1.031538520097613, 
                    1.241176528625745}, {-1.1035917606859607`, 
                    1.2214457066248345`}, {-1.1346498440731037`, 
                    1.214696830592457}, {-1.161106760961808, 
                    1.2106922421837822`}, {-1.191346077648871, 
                    1.2108200866422745`}, {-1.2178361812701568`, 
                    1.2132912208477735`}, {-1.2650776805770927`, 
                    1.2186121188367163`}, {-1.2811035255469503`, 
                    1.2208926540177136`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0017915680686370495`, 1.}}], {
                  LABColor[
                  0.25823988334632497`, 
                   0.5224718736387535, -0.6909366118800063], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.2913910039188492`, 
                    1.2223565990636687`}, {-1.3012363934554922`, 
                    1.223757633283778}, {-1.328212045492005, 
                    1.2278760025463953`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2465578898074133, 
                   0.5224927328771171, -0.7188559395520773], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.165774461918939, 
                    0.6098232502813477}, {-1.165417519932498, 
                    0.6805246055887513}, {-1.1657525440656682`, 
                    0.7661976173367194}, {-1.165585735745351, 
                    0.8067065027230363}, {-1.1655751956704563`, 
                    0.8502343897400653}, {-1.1688263400542662`, 
                    0.8941879766042933}, {-1.171905987943261, 
                    0.9156973321224883}, {-1.1773893407698914`, 
                    0.9356879223984225}, {-1.189935655267461, 
                    0.954295182880794}, {-1.2056487565528509`, 
                    0.9715937478097207}, {-1.237460483926371, 
                    1.0003593240957929`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.004611088924652203, 1.}}], {
                  LABColor[
                  0.2896373473769779, 
                   0.5224158106744962, -0.6158983845925149], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.245598780538241, 
                    1.0067790436545656`}, {-1.2835909459092847`, 
                    1.0324765776073117`}, {-1.3259377153971512`, 
                    1.0589896314268457`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.019926197812345735`, 1.}}], {
                  LABColor[
                  0.2628121103635296, 
                   0.5224637095207982, -0.6800092385803012], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8522240030560234, 
                    1.098967210521785}, {-0.8763704972869959, 
                    1.0575905639742458`}, {-0.9071250159977149, 
                    1.0209223607019393`}, {-0.923559115070808, 
                    1.004357048631103}, {-0.9392384195161144, 
                    0.9902646048905943}, {-0.9551283665493113, 
                    0.9804534161938004}, {-0.9698006345867188, 
                    0.9743983642982539}, {-0.997016220611954, 
                    0.9697109850229937}, {-1.0225545065469097`, 
                    0.9779783542399185}, {-1.0528608106255801`, 
                    0.995181870980552}, {-1.087844254685661, 
                    1.0146350094465186`}, {-1.1331722026349873`, 
                    1.0374460749896062`}, {-1.1870061162670875`, 
                    1.062318190475508}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.003675548863957351, 1.}}], {
                  LABColor[
                  0.37329379571531446`, 
                   0.5222664346462758, -0.41596403389629905`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.6241838924320917`, 
                    1.2327625076564828`}, {-1.5911318892504387`, 
                    1.2299632038632229`}, {-1.5480051431821282`, 
                    1.2271903487459936`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02000000000000001, 1.}}], {
                  LABColor[
                  0.24414662850822616`, 
                   0.5224970383986044, -0.7246187225985452], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAApXKSLQDjAcCo26AH3ZfcP2JJ8LJA
GALAoj6QcW3u3D+8EaLeq0ECwKCO6dhozN0/qUo39o9lAsAcTYqnGrHeP6jz
RkADhALAW28fnQ1p3z/avqk2MKMCwOhKiBptAeA/DT3nd0bBAsCXQS/a3Szg
P9C53+fC4wLAfrRKtX4y4D/g5+opJwQDwKliKyaMGOA/5ySFh2UvA8COFEHG
fbffP+yME4ePawPAypJhQ+Tc3j8tiubZnpsDwOYqIEOzGN4/EG+pvHXWA8Ao
5C5dKhjdP2Jx/R+AHQTA3PfsctnP2z+XlF/hL0QEwApPMS5XGNs/j7Cp/FNt
BMBeBkHpuE3aP9QGF4AcmATAP3V6g6Jn2T8PN1hHpcIEwPl8HTBMfdg/19oI
mkzPBMDE2vwgnTbYP6PslJI=
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0021550323874617687`, 1.}}], {
                  LABColor[
                  0.492378955008534, 0.528082400303078, 
                   0.054603245462625113`], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.6097400285795813`, 
                    0.3723844117722507}, {-2.6201357857791283`, 
                    0.3651254937678062}, {-2.626368732644504, 
                    0.3607677542113198}, {-2.6325578031664283`, 
                    0.3564383853430699}, {-2.6464459602212305`, 
                    0.3467232459399122}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01052634556552145, 1.}}], {
                  LABColor[
                  0.20434068654839715`, 
                   0.5225681154479848, -0.8197527537183262], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.387303917095061, 
                    0.15698781402444842`}, {-2.4006515620219067`, 
                    0.16124586707343014`}, {-2.4265924760859283`, 
                    0.15993358966096674`}, {-2.4584025127734592`, 
                    0.149615426610144}, {-2.4922397538489927`, 
                    0.13144060649075867`}, {-2.520885495585075, 
                    0.11077094768808213`}, {-2.5441576027002384`, 
                    0.08987115151418745}, {-2.5596287782056053`, 
                    0.0722238201657985}, {-2.565263065359131, 
                    0.0645210134227862}, {-2.568790892572544, 
                    0.05811918427433449}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01999999999999999, 1.}}], {
                  LABColor[
                  0.35538891812345275`, 
                   0.5222984053975277, -0.45875571519199676`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.653503681905538, \
-0.6961015480758568}, {-1.7036291864190392`, -0.6634452350916423}, \
{-1.7529589410640307`, -0.6389209388037811}, {-1.8050712358435819`, \
-0.6226996928798051}, {-1.8597427339786412`, -0.6141690497296604}, \
{-1.9167500986901576`, -0.612716561763293}, {-1.9749660422078437`, \
-0.6155694264442411}, {-2.0332632767614123`, -0.6199548412360427}, \
{-2.0502829788374055`, -0.6208860436634142}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.3573317282827398, 
                   0.5222949363372109, -0.45411250483058974`], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.060658579211064, -0.62145372600064}, \
{-2.1132780320818627`, -0.6243327048465362}, {-2.189655476575841, \
-0.6230132387371732}, {-2.2619999966767934`, -0.6137374397667801}, \
{-2.3299159788181667`, -0.5942463047941834}, {-2.402256599944804, \
-0.557515080697653}, {-2.4492846549991425`, -0.5173711611530978}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3369234237994299, 
                   0.5223313771798115, -0.5028872399135204], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.457187935368959, -0.510624791333266}, \
{-2.4643822669819717`, -0.5044835918063894}, {-2.513248279776212, \
-0.4364469443107061}, {-2.548910001864637, -0.3641256057691509}, \
{-2.5748678386650887`, -0.29879363574754353`}, {-2.5935124259685955`, \
-0.24304429887990422`}, {-2.6011799642844764`, -0.21750644625122434`}, \
{-2.6073338459342636`, -0.1941664585060376}, {-2.611311149604872, \
-0.17070818352266945`}, {-2.6135712297685885`, -0.14949647464003485`}, \
{-2.614119749718011, -0.1327331621543153}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.005867244581393959, 1.}}], {
                  LABColor[
                  0.24300878209211463`, 
                   0.522499070124571, -0.7273381134992587], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.6144595803441075`, \
-0.12234760191447118`}, {-2.6148255120403596`, -0.11116436714030546`}, \
{-2.60985222076379, -0.08014147897897177}, {-2.5993221115622114`, \
-0.054857743818256026`}, {-2.564883765378997, -0.01597983614834115}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2841074536805887, 0.522425684791474, -0.6291145290448249], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.2475898955164015`, 
                    0.5561267632865635}, {-2.234057772583832, 
                    0.5601072488340033}, {-2.2187267888323285`, 
                    0.5628611817852909}, {-2.187997240908049, 
                    0.5621772312251144}, {-2.1566743518098845`, 
                    0.5491953630912303}, {-2.130561993337522, 
                    0.5177077230328897}, {-2.121390261312668, 
                    0.4940882777501265}, {-2.1157703141839272`, 
                    0.465941198970063}, {-2.1133093739224695`, 
                    0.4353005364674422}, {-2.1120633393442354`, 
                    0.3686665675716178}, {-2.1103913158429366`, 
                    0.31128438650129214`}, {-2.108737551723856, 
                    0.2850507464960915}, {-2.106358083460014, 
                    0.2610018658485881}, {-2.1041790090327765`, 
                    0.24756024282635045`}, {-2.1027908272651543`, 
                    0.24017760938444785`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.004991725676318546, 1.}}], {
                  LABColor[
                  0.32995740707462057`, 
                   0.5223438156221736, -0.5195356401083382], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.1007472478768094`, 
                    0.2299903134222144}, {-2.09650075954415, 
                    0.210245313646958}, {-2.0904035687905007`, 
                    0.18801349495834374`}, {-2.0835611499752273`, 
                    0.16780182196630447`}, {-2.0676789108963693`, 
                    0.1320164026680316}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.017123674858405862`, 1.}}], {
                  LABColor[
                  0.21658277143752, 0.5225462561167055, -0.7904948382546466], 
                  
                  Arrow[
                   
                   GeoGridPosition[{{-1.7146349895678465`, 
                    0.5685184114818724}, {-1.7030187051013341`, 
                    0.5794716084447832}, {-1.696993547489213, 
                    0.5883671899648458}, {-1.6903264287321083`, 
                    0.6007314898940981}, {-1.6895332304318285`, 
                    0.6024028695756999}, {-1.6866882014236844`, 
                    0.60851533892543}, {-1.6841544545605356`, 
                    0.6140922248228571}, {-1.6814585282998833`, 
                    0.6201361540009985}, {-1.6582954082774473`, 
                    0.6748446621684469}, {-1.6423670969150992`, 
                    0.7143382371942633}, {-1.6226258090128787`, 
                    0.7647247385513561}, {-1.5993877082003594`, 
                    0.82474051772239}, {-1.5729689581071156`, 
                    0.8931219261900294}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.1913081597043819, 
                   0.5225913861836698, -0.8508997823604103], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAyPB0p+lW9r/k8E4K6O+LP6xuUD0Q
ava/wHFlUmEglz9T+A4R9Yr2v2pYUe6VdKM/Zsech9+q9r9bNaeq4/yqP1iQ
fGtB2fa/PAYeyPC+sj+IpVQzJh73v07Z6qvVFLo/DGeZl3mI978jLqXEGkXC
P9J8qFC50fe/KhFK9HibxT//H8i8EDH4v2KxTRrIuMk/jfCvNhqy+L/CjZDB
kP7OP5GC0oYtX/m/NuYJQLKY0j8U1SA7WYb5vxxDT6ggM9M/RgU6CAav+b97
fe+gHMjTP+Rbt6oC2fm/LeE3wJtU1D+Yp08aCgT6v4gwf+MK1dQ/mvEIK70M
+r83wM336ezUPzawqA52Ffq/b4FqJSUE1T8rqp8MBBz6v0hcEAUiFdU/X6Ye
ENEh+r+2biarsSPVP4KvYBPJKPq/ZSA+j8E01T93KePsDkD6v2FoU9DTadU/
T8OmD1ZX+r8m6L6NdJjVP9K60PUcX/q/4G4QOqql1T+X2cFv
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0007121065478924445, 1.}}], {
                  LABColor[
                  0.2540843434321959, 
                   0.5224792937248296, -0.7008681257205582], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.65816775882396, 
                    0.34183635082589087`}, {-1.6723908542764405`, 
                    0.34401708466131925`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.00007063765944939012, 1.}}], {
                  LABColor[
                  0.22886453460402478`, 
                   0.5225243259363334, -0.7611420938712283], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.4800759896632627`, -1.0114516400258353`}, {
                    1.480520176990177, -1.0121978773999964`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.00901039885753047, 1.}}], {
                  LABColor[
                  0.3675469276584552, 
                   0.5222766961902702, -0.4296987352409943], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.57137626425394, -1.1148204383112614`}, {
                    1.5728810916108862`, -1.1152253281260345`}, {
                    1.5743859189678324`, -1.1156302179408075`}, {
                    1.6535641749978423`, -1.1369339703414172`}, {
                    1.6852354774098461`, -1.1454554713016611`}, {
                    1.71690677982185, -1.153976972261905}, {
                    1.7454915717435577`, -1.1521657973315131`}, {
                    1.7526787293826955`, -1.1488673379623435`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.20187673939284345`, 
                   0.5225725150447541, -0.8256414530891513], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.7757750118472153`, -0.05677831496748833}, {
                    1.7629114285843244`, -0.06098481211345074}, {
                    1.743422368889002, -0.07054640606530073}, {
                    1.712655620231274, -0.08493624535556335}, {
                    1.6967399017014089`, -0.09131942278569431}, {
                    1.6776977452546524`, -0.0975953607002574}, {
                    1.655186922435834, -0.10296621187012327`}, {
                    1.6162632928491083`, -0.1067272472683709}, {
                    1.5785571366453148`, -0.09944869957188379}, {
                    1.550800856225079, -0.07377680343101221}, {
                    1.539665750636602, -0.024505031558309912`}, {
                    1.543049884814069, 0.005968575804740344}, {
                    1.5537176339112857`, 0.037114287055324345`}, {
                    1.5713124311880151`, 0.06568110302901682}, {
                    1.5817413050842881`, 0.0789420910523872}, {
                    1.58618387332947, 0.08335664051137684}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01569239007075244, 1.}}], {
                  LABColor[
                  0.3352745196332942, 0.52233432144484, -0.5068280309746388], 
                  
                  Arrow[
                   
                   GeoGridPosition[{{1.5935547105385217`, 
                    0.0906809906659997}, {1.593743090248738, 
                    0.09086818228623468}, {1.6086441541881638`, 
                    0.100040181381835}, {1.6243508607660613`, 
                    0.10768509449660041`}, {1.6565320428178016`, 
                    0.12003090202200448`}, {1.6890344059156177`, 
                    0.12691424607417806`}, {1.7199349985190968`, 
                    0.12948611608926164`}, {1.7603843136082313`, 
                    0.12843780843190752`}, {1.794501367141707, 
                    0.1244957291471639}, {1.8225082992236563`, 
                    0.12015012834176356`}, {1.859999648647989, 
                    0.11421123925062145`}, {1.8880745372506176`, 
                    0.11225957105205783`}, {1.9110040148910847`, 
                    0.11302198143624419`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.3391006571801861, 
                   0.5223274895359851, -0.4976837708332279], 
                  Arrow[
                   
                   GeoGridPosition[{{1.5031752189905792`, 
                    0.7550126591140977}, {1.5447819832305716`, 
                    0.7544659090437615}, {1.5950495601440449`, 
                    0.7526223905863999}, {1.667434223806557, 
                    0.7481069321290578}, {1.7413651511732464`, 
                    0.7410973903662057}, {1.8124304969313658`, 
                    0.7306871239762853}, {1.876218415768165, 
                    0.7159694916377377}, {1.9139348162666228`, 
                    0.7037139626148075}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.3726255708437221, 
                   0.5222676278212104, -0.4175610549087205], 
                  Arrow[
                   
                   GeoGridPosition[{{1.923817301316391, 0.7005027579201532}, {
                    1.934400730046847, 0.6970637892949918}, {
                    1.9886492621306158`, 0.6740893128924766}, {
                    2.0409309031169274`, 0.6490804494600767}, {
                    2.091910376547996, 0.6207946857699742}, {
                    2.1141087359387614`, 0.6061567562736553}, {
                    2.1362682352558044`, 0.5906980670900794}, {
                    2.180991916064541, 0.5515816929208958}, {
                    2.2261202790479273`, 0.5042663229496802}, {
                    2.2612758556343207`, 0.467407039723542}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.010886164583329793`, 1.}}], {
                  LABColor[
                  0.41922163354100656`, 
                   0.5233153410204974, -0.2713144457553759], 
                  Arrow[
                   
                   GeoGridPosition[{{2.2684476512728518`, 
                    0.45988768511898914`}, {2.2712486420313134`, 
                    0.45695095297846466`}, {2.324543879416017, 
                    0.40107292621535395`}, {2.377839116800721, 
                    0.34519489945224324`}, {2.4245943466309665`, 
                    0.29617382154782823`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.1986613307004836, 
                   0.5225782564429261, -0.8333261045643123], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.5482153473178506`, -0.8642777374381948}, {
                    1.5458835529000652`, -0.8649539720876104}, {
                    1.542566250935626, -0.8660732659209}, {
                    1.537875821693325, -0.8678107490523761}, {
                    1.5361492687358869`, -0.8684760053580607}, {
                    1.5337823932692876`, -0.8694040124437317}, {
                    1.5310785892090757`, -0.8704845749089342}, {
                    1.528096838709068, -0.8716910799674888}, {
                    1.5111697929664543`, -0.8787845129821431}, {
                    1.4818976623079343`, -0.8916063678235604}, {
                    1.4320028835264074`, -0.9146764333595455}, {
                    1.3608902722072393`, -0.9496885892779683}, {
                    1.2854586341090541`, -0.9906973197610636}, {
                    1.2246647439593594`, -1.0300860016521565`}, {
                    1.199405133915515, -1.0487106024944661`}, {
                    1.1842768656603873`, -1.0617428181369228`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.336916814662962, 0.5223313889810124, -0.5029030353893578], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.176957626098814, -1.0690408507923503`}, {
                    1.1670105131017596`, -1.0823701105754406`}, {
                    1.1590813861979101`, -1.097519754381376}, {
                    1.1509227876035781`, -1.1259954159581378`}, {
                    1.1572064102419708`, -1.151035380971233}, {
                    1.176148189210087, -1.17304941619801}, {
                    1.223324866261014, -1.2004735922676404`}, {
                    1.287897023181697, -1.2235280755728115`}, {
                    1.3631319038959382`, -1.2441142865804977`}, {
                    1.4420672331474573`, -1.2645850500519862`}, {
                    1.4563234982599198`, -1.2683874827052402`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.00345937778335597, 1.}}], {
                  LABColor[
                  0.36754692765845526`, 
                   0.5222766961902702, -0.42969873524099417`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.4663636265303603`, -1.2710653868601656`}, {
                    1.521187022868416, -1.28568788937072}, {
                    1.535828819891972, -1.2895931511391772`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2399092499067517, 
                   0.5225046046149348, -0.7347458264401221], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.1870303275771592`, -0.46696493739019085`}, {
                    1.203091029605166, -0.4939643131139029}, {
                    1.1996134629182837`, -0.5311083987473895}, {
                    1.176416202494712, -0.5609808464679729}, {
                    1.1333768064153702`, -0.5849343845496189}, {
                    1.0762155496222674`, -0.5945047860792095}, {
                    1.0098445397214353`, -0.5753053844233976}, {
                    0.9574229686334804, -0.5213057846436459}, {
                    0.9366950438098269, -0.4676322811399614}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.347374033773424, 0.5223127166863121, -0.4779108518282949], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.932951595277344, -0.4579388844476499}, {
                    0.9284612226860799, -0.4463113804374545}, {
                    0.9203154508637421, -0.3976560427143404}, {
                    0.9148611934939662, -0.34794783359645876`}, {
                    0.9119326561044574, -0.2962451920245042}, {
                    0.9113640442229206, -0.24160655693917166`}, {
                    0.9129582057967248, -0.18617987500908315`}, {
                    0.9166676652761894, -0.12581844831849442`}, {
                    0.9228518647642845, -0.059527543878725185`}, {
                    0.924396671791531, -0.04469727796964998}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.4336995281167571, 
                   0.5242587460050578, -0.20681506443343015`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.9254732463974575, -0.03436207920679406}, {
                    0.9302311578141048, 0.011314235204123849`}, {
                    0.9337767056759249, 0.08079031889708396}, {
                    0.9296990161091077, 0.1433000868792898}, {
                    0.9256763895460047, 0.17245423098725032`}, {
                    0.9197891478957723, 0.19951744709280506`}, {
                    0.9095780338014923, 0.22461580285920568`}, {
                    0.8976352695351926, 0.24776597565583697`}, {
                    0.8707465706617671, 0.290764872606688}, {
                    0.8385122907049003, 0.32833266476151396`}, {
                    0.8189614204205973, 0.3469906059895132}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01169309176983704, 1.}}], {
                  LABColor[
                  0.34803273072200375`, 
                   0.5223115405243315, -0.4763366020324245], 
                  Arrow[
                   
                   GeoGridPosition[{{0.8114441304206093, 
                    0.35416456566363635`}, {0.8020652691941362, 
                    0.3631150747204936}, {0.7611584593088516, 
                    0.39837623636502006`}, {0.7179035489584699, 
                    0.4366989518636961}, {0.6749081706070753, 
                    0.47873633771712953`}, {0.6360850098779555, 
                    0.5219840251277643}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.2579645502023372, 0.522472365270568, -0.6915946430833596], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.21143322673708148`, \
-0.3857907072761036}, {-0.2428735830388657, -0.37362135003918384`}, \
{-0.2843643044251848, -0.3711809159647071}, {-0.3085120049272396, \
-0.37365033857807123`}, {-0.334000780584417, -0.3779861963238582}, \
{-0.3598803499270943, -0.3834506098842066}, {-0.4447051214341897, \
-0.3952553505801199}, {-0.4766875491740394, -0.3919146580039998}, \
{-0.49989282867762364`, -0.38156255552793}, {-0.5157375298967571, \
-0.36455499377673095`}, {-0.521983420886613, -0.35444512776462245`}, \
{-0.526718357053896, -0.3427843187226985}, {-0.52894186377522, \
-0.32618176410954375`}, {-0.5297112186227405, -0.30754318516462037`}, \
{-0.5285261250050615, -0.2700989784795449}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2741517882907406, 0.5224434615174021, -0.652908026557627], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.5275382771889963, \
-0.2597689967824713}, {-0.5213413064708301, -0.2150442772156203}, \
{-0.5081651014795351, -0.1529670845314982}, {-0.4914886082381227, \
-0.0893543191317447}, {-0.4689197285709182, -0.013278384859258963`}, \
{-0.45577423037999004`, 0.02985718809244605}, {-0.44239983015082684`, 
                    0.07614009276511165}, {-0.42921125940616617`, 
                    0.1255808423263305}, {-0.42514428402093485`, 
                    0.1425779649995649}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.006954185431696186, 1.}}], {
                  LABColor[
                  0.41935952373553503`, 
                   0.5233243261872397, -0.27070014150064353`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.4227262125300322, 
                    0.15268381858126437`}, {-0.41662324966874553`, 
                    0.17818994994369505`}, {-0.40465987958082744`, 
                    0.23423346134301792`}, {-0.3931219975672601, 
                    0.2941234408548086}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.32758066754303306`, 
                   0.5223480595019747, -0.5252159180123216], 
                  Arrow[
                   
                   GeoGridPosition[{{0.25440413290163744`, 
                    0.09266263051306087}, {0.2023190674777099, 
                    0.10622691336155035`}, {0.14600770106505373`, 
                    0.12807373709615538`}, {0.0873029610305784, 
                    0.1643294949929749}, {0.05554877638078681, 
                    0.19683367179625313`}, {0.028201018374073447`, 
                    0.24056859072619236`}, {0.007296535966364072, 
                    0.29892939499165644`}, {-0.0013646366502538363`, 
                    0.34215005166328444`}, {-0.0043239036744193125`, 
                    0.3713302374122006}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.016831812665088732`, 1.}}], {
                  LABColor[
                  0.6461994401507739, 0.5011950027121475, 0.6785478854593321], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.005372326613529535, 
                    0.3816683298711899}, {-0.006645738845024341, 
                    0.39422495458485163`}, {-0.008412838688190883, 
                    0.45523463553219734`}, {-0.008454968485675191, 
                    0.47055749634620897`}, {-0.008533955564008473, 
                    0.4851089367357006}, {-0.008650780958825828, 
                    0.49894392996504}, {-0.008678845251365237, 
                    0.501629083598929}, {-0.008708421192821678, 
                    0.5042898511932623}, {-0.008731593774754964, 
                    0.5062697769180687}, {-0.00935449468869651, 
                    0.5351354656209022}, {-0.010220951978928078`, 
                    0.5611628429276434}, {-0.012447933897265222`, 
                    0.608305550998931}, {-0.015595372788198052`, 
                    0.6467283417186211}, {-0.01952010799110037, 
                    0.6782786234792216}, {-0.030144410221221232`, 
                    0.7298513033410813}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.010036350695621274`, 1.}}], {
                  LABColor[
                  0.3427025657961855, 
                   0.5223210580078272, -0.4890754056120028], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.026447407293671, -0.9017198488878848}, {
                    2.080023080935266, -0.8780480301299445}, {
                    2.1335987545768615`, -0.8543762113720043}, {
                    2.187174428218457, -0.830704392614064}, {
                    2.217232264651168, -0.8174236700784814}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.26330229447872266`, 
                   0.5224628342534676, -0.6788377252691412], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.5268185639016545, 
                    1.3853958204842542`}, {-0.4384555172668779, 
                    1.385304853573006}, {-0.3502487787388815, 
                    1.3852147579708523`}, {-0.26213248842198467`, 
                    1.385135240951997}, {-0.17404078642050666`, 
                    1.3850760097906443`}, {-0.11117397235400764`, 
                    1.3850510332693176`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2637098885132056, 0.522462106458071, -0.6778635977481829], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.1007828545456636, 
                    1.3850469049548895`}, {-0.08610156648544261, 
                    1.3850410721874782`}, {0.001581447309804307, 
                    1.3850075205218175`}, {0.08911036937730248, 
                    1.3849446890858186`}, {0.17658731412912027`, 
                    1.3848219121716363`}, {0.26401359577539807`, 
                    1.3846711423896587`}, {0.3148615950688712, 
                    1.3846003869906245`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.26166100797983827`, 
                   0.5224657649164739, -0.6827603105208335], 
                  Arrow[
                   
                   GeoGridPosition[{{0.32525270363717085`, 
                    1.3845859276796708`}, {0.3511618553303814, 
                    1.3845498748871878`}, {0.43779119741229644`, 
                    1.3844657577617527`}, {0.5236607266393697, 
                    1.3844264391108811`}, {0.5798129388994782, 
                    1.3844217146541973`}, {0.6359571250741848, 
                    1.3844217146541973`}, {0.6924829779620953, 
                    1.3844550444372732`}, {0.7359987707357372, 
                    1.3845462217423623`}, {0.7408972490559627, 
                    1.3845599539146187`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.26329712870566463`, 
                   0.5224628434774148, -0.6788500711851192], 
                  Arrow[
                   
                   GeoGridPosition[{{0.7512883268537726, 
                    1.3845890837914745`}, {0.7799875654168725, 
                    1.3846695379369889`}, {0.8239698013790863, 
                    1.384777086354246}, {0.8497719566615339, 
                    1.3848333547497242`}, {0.8755705954494465, 
                    1.3847258297185825`}, {0.9013710758737603, 
                    1.3843271545664382`}, {0.9251817892555337, 
                    1.38362218090892}, {0.9490076798429045, 
                    1.3824015641917922`}, {0.9728486590066342, 
                    1.3806085935292478`}, {1.0030554385923778`, 
                    1.3762579560413748`}, {1.0334417917365044`, 
                    1.3661393435995093`}, {1.0638994310560816`, 
                    1.346453026427847}, {1.1027992783793636`, 
                    1.305902871054453}, {1.1256608635439043`, 
                    1.2743447397266021`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.018300965470804776`, 1.}}], {
                  LABColor[
                  0.3071270868374064, 
                   0.5223845811892968, -0.5740988607981931], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAAW6yeLq0b8j9QjZN+P0H0PxdEinL+
OfI/8tEV2GUX9D8yBs3kg77yP5rpWne+ZfM/P8DaSZX88j/OAcC4fR7zP4nN
rrVoNfM/59PIcBXt8j9XoGLEloHzP7/HB+YtuvI/Dk1/v4/S8z+vHzKB26Ty
P9D3tOkDGvQ/SSHt4rue8j9RCLss0pf0P7zDUbsFoPI/ZnOwWLn49D8zIDll
Xa/yP4Tsib9DRfU/C1UXH0O/8j8lH+vTk7f1P/I5LAoF3vI/hFnwSpEH9j93
CO3G6fjyPx6khon8RPY/npb83fgO8z88nnJfPoj2P+qT5ovNJfM/6a6O1QHF
9j8kURIc8DLzP2AslY2BFfc/yqibhtU08z/SUYlHuDP3P6FMxe2pM/M/Oq+y
M29W9z+WSRYLwTLzP8+F2UDBX/c/F1wovKIy8z9zZdUhTWn3P8afCVeXMvM/
KoOyBg==
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.21775931865328135`, 
                   0.5225441552870194, -0.7876829545526836], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.3922674176732043, 
                    1.1359510400131962`}, {-0.391861729259368, 
                    1.1270221185120903`}, {-0.39352649482861896`, 
                    1.116020425286261}, {-0.39411376664593967`, 
                    1.1135048472707443`}, {-0.39463180435717904`, 
                    1.1114664758900026`}, {-0.3950985612140151, 
                    1.1097360228618838`}, {-0.39575924976843946`, 
                    1.107417029103871}, {-0.4002120214369817, 
                    1.0940665575123776`}, {-0.4069990619274498, 
                    1.0771656760081003`}, {-0.4171993943810133, 
                    1.0553615427735554`}, {-0.43672218506114646`, 
                    1.0203388231458728`}, {-0.4731470507932536, 
                    0.9683469958435076}, {-0.5246337788441019, 
                    0.9097542455749161}, {-0.5770536648106265, 
                    0.8577923072726658}, {-0.6243577748830539, 
                    0.8130894821954587}, {-0.6314782488105088, 
                    0.806270857711574}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.003343053902478618, 1.}}], {
                  LABColor[
                  0.5005891648860369, 0.5286173919679362, 0.0911799351775249], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.6389832318175717, 
                    0.7990840241658765}, {-0.656992489493674, 
                    0.7818382106739713}, {-0.6887174289000928, 
                    0.750574073371049}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.6752465421270729, 0.46778056089745185`, 
                   0.7492881626051843], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.3254293625046512`, -0.8807538089707863}, {
                    1.2781734875090607`, -0.9011416399319495}, {
                    1.2350082279283097`, -0.9208108642457369}, {
                    1.1956827443077074`, -0.9398237439877029}, {
                    1.1292388634471482`, -0.9740999634390863}, {
                    1.0771398381544293`, -1.0025268462839623`}, {
                    1.0130982730582587`, -1.0354081515007978`}, {
                    0.9717429372167042, -1.0502382624045934`}, {
                    0.9487400640575379, -1.0512527140467007`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2599916262266078, 
                   0.5224687457460553, -0.6867500418986989], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.9383992607726097, -1.0510981908363248`}, {
                    0.9245897028154598, -1.0486527484303199`}, {
                    0.9088887383916017, -1.0412433316631178`}, {
                    0.907320968749948, -1.0400717352322426`}, {
                    0.9018026908612404, -1.0356576238110764`}, {
                    0.8970054098110377, -1.031471287734988}, {
                    0.8919945495453631, -1.0267842626008894`}, {
                    0.8488702448324329, -0.975638467163808}, {
                    0.8256564711227525, -0.9418934318264156}, {
                    0.7978545795510726, -0.896511203318482}, {
                    0.7594322624353758, -0.8279372164393759}, {
                    0.7283442435946138, -0.7651907250640364}, {
                    0.7081082510259169, -0.7169673761879112}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0075691956600747535`, 1.}}], {
                  LABColor[
                  0.39137319494102923`, 
                   0.5222341522711261, -0.37275525541036764`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.7044535772588645, -0.7072450177533826}, {
                    0.6834425729778207, -0.6471576913446496}, {
                    0.6689947468647928, -0.5961494645858345}, {
                    0.6596535739154913, -0.5566027058648695}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3291448610408254, 0.522345266495378, -0.5214775808302368], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.3700825588778677, -1.1610470764904859`}, {
                    0.45463282627016394`, -1.133285043438695}, {
                    0.4937737881685055, -1.11765514422746}, {
                    0.5311025789610881, -1.0999110780818648`}, {
                    0.5646060849485495, -1.0782356275967566`}, {
                    0.5801412497281541, -1.066142568173053}, {
                    0.5941654333995801, -1.052501548174491}, {
                    0.6047178175501083, -1.033923312565089}, {
                    0.6127997449918194, -1.0123620560492192`}, {
                    0.623489123703278, -0.9623916152489608}, {
                    0.6226778597908329, -0.897210852908104}, {
                    0.6223272551400976, -0.8938876790746648}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.00986927698498089, 1.}}], {
                  LABColor[
                  0.4236105515021669, 
                   0.5236013306068783, -0.2517617068065951], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.6212370123319417, -0.883553913208867}, {
                    0.6149942235203536, -0.8243822154494516}, {
                    0.6109980161616105, -0.7843245937872836}, {
                    0.607543655505289, -0.7473728393009266}, {
                    0.601902800203425, -0.6793701681755586}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.0000801147818072866, 1.}}], {
                  LABColor[
                  0.23671691812759205`, 
                   0.5225103048072259, -0.7423753253508556], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.1473070684265308, 
                    1.1433851026497808`}, {-0.148314446171109, 
                    1.142678099651784}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3734034536962717, 
                   0.5222662388421987, -0.41570195730021076`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.1020742839485225, \
-0.7039643538594976}, {-0.1277804694543367, -0.716578877299921}, \
{-0.15665432527616, -0.7369224080592243}, {-0.18942892591930902`, \
-0.7672050164340707}, {-0.2068794634228422, -0.785156069554832}, \
{-0.22536626861453832`, -0.8062710829000641}, {-0.24392396851536047`, \
-0.8321847109201989}, {-0.26343742029686634`, -0.8625934792176955}, \
{-0.29183517006830245`, -0.9100443068125554}, {-0.31287418996453503`, \
-0.9518503164111707}, {-0.3269976469304638, -0.9875844432551547}, \
{-0.33181730300837503`, -1.003429423121501}, {-0.335337455067284, \
-1.018065305459915}, {-0.33766861193594444`, -1.0315733366756918`}, \
{-0.33767559757643784`, -1.0316880368677246`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0024972114671999207`, 1.}}], {
                  LABColor[
                  0.4259092495784402, 
                   0.5237972155404909, -0.2400990037475898], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.33830728238070745`, \
-1.0420599374003137`}, {-0.339125259163307, -1.0554906448825037`}, \
{-0.33695929705437966`, -1.0758118959881258`}, {-0.3317403800856013, \
-1.0930446512959815`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.26122662807595026`, 
                   0.5224665405404224, -0.6837984548093418], 
                  Arrow[
                   
                   GeoGridPosition[{{0.6287031321201222, 
                    0.14014797335746815`}, {0.5782519015553721, 
                    0.18438180103391286`}, {0.5528007284766367, 
                    0.21236489302784992`}, {0.5278357115146746, 
                    0.24627633240177643`}, {0.5049960218803683, 
                    0.2877605036838639}, {0.4943346207137248, 
                    0.31063174816308514`}, {0.4847935466679236, 
                    0.3359155925987905}, {0.4789555231678689, 
                    0.3618376913436816}, {0.47435896685904255`, 
                    0.39023937546685805`}, {0.46745682834080926`, 
                    0.4509551813110338}, {0.46372687983067773`, 
                    0.5033711126583195}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3835922131248814, 
                   0.5222480459061349, -0.39135137774272905`], 
                  Arrow[
                   
                   GeoGridPosition[{{0.4629893068298722, 
                    0.5137360213611661}, {0.46286635286981936`, 
                    0.5154638592419044}, {0.4568336363631395, 
                    0.5777500405812651}, {0.4433943568919862, 
                    0.6595660730219872}, {0.4248216909195629, 
                    0.7315585053946121}, {0.4008443923959307, 
                    0.7917534856292499}, {0.3410908155998091, 
                    0.8562112644469245}, {0.2999965984815461, 
                    0.8611049592110598}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0013027471832960577`, 1.}}], {
                  LABColor[
                  0.2890054893897015, 
                   0.5224169389131247, -0.6174084907340929], 
                  Arrow[
                   
                   GeoGridPosition[{{0.2894480279477038, 
                    0.8623611331452661}, {0.26302469271042733`, 
                    0.8655077495397216}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.39667027547709327`, 
                   0.5222246938627505, -0.3600955217185872], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.9499640901965458, \
-0.1778112948200504}, {-0.9583796394343298, -0.11595610682565971`}, \
{-0.9623780423148466, -0.060409884534954314`}, {-0.9633440394211332, \
-0.01053785039682163}, {-0.962251923957271, 
                    0.03433746473718119}, {-0.9549173964827323, 
                    0.11210665576788327`}, {-0.9414270387844187, 
                    0.18783034373399632`}, {-0.9296630283468932, 
                    0.23408738380044378`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.015500672940569999`, 1.}}], {
                  LABColor[
                  0.28725340653023446`, 
                   0.5224200674128859, -0.6215958732471153], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.9271019033851358, 
                    0.24415793419653073`}, {-0.9239931395529386, 
                    0.2563818449034063}, {-0.9022480719985376, 
                    0.32064680024488557`}, {-0.8885488587289174, 
                    0.3564244309307267}, {-0.8727349801765271, 
                    0.3930963561580474}, {-0.853125736717661, 
                    0.43265395716141}, {-0.8320536251037313, 
                    0.47321248275498107`}, {-0.7971921167681294, 
                    0.5380068675565006}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.008975315575308186, 1.}}], {
                  LABColor[
                  0.23300547948395917`, 
                   0.5225169319109888, -0.7512454613667009], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.14166393270203245`, 
                    1.0547630356764295`}, {-0.16931027428384762`, 
                    1.029254398246608}, {-0.1879851072448493, 
                    1.0232761143422147`}, {-0.2091070730544443, 
                    1.0216290787145652`}, {-0.23213963159725476`, 
                    1.0233627175449995`}, {-0.244150659036749, 
                    1.024868526639508}, {-0.2566901915671377, 
                    1.026617985233787}, {-0.27124059399109246`, 
                    1.027951499571492}, {-0.2862010034423528, 
                    1.028214168638351}, {-0.3166609764863041, 
                    1.0245616175283458`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3866582793510527, 
                   0.5222425711722176, -0.38402364661981664`], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.1060993997673154`, \
-0.4142809668167556}, {-1.1459613728687272`, -0.37885536947138976`}, \
{-1.2218359427073224`, -0.35738113644149166`}, {-1.2578941864770754`, \
-0.3678581399088477}, {-1.295124455929422, -0.39063634260220953`}, \
{-1.3340141714486993`, -0.42114865947614855`}, {-1.3538747988750985`, \
-0.4373761039091052}, {-1.3737141005959879`, -0.45072243353387553`}, \
{-1.3945394384229153`, -0.4583308380868283}, {-1.414886660303188, \
-0.4627941000352082}, {-1.4546343744822545`, -0.46596299493901583`}, \
{-1.4746245601730452`, -0.4618901917344111}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3081421992191735, 
                   0.5223827686158634, -0.5716727975482753], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.4848065010667681`, \
-0.4598157216848329}, {-1.4923995990665404`, -0.4582687028454533}, \
{-1.5279085002986377`, -0.4407060907995721}, {-1.5889375054484862`, \
-0.38540677134126616`}, {-1.6278036267671838`, -0.33700691829434437`}, \
{-1.6619108544976995`, -0.2943280433305472}, {-1.6921874437327977`, \
-0.258639614478783}, {-1.7432240073883307`, -0.20492684101166866`}, \
{-1.7789026386002302`, -0.17233511767292883`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.005658864985965143, 1.}}], {
                  LABColor[
                  0.23498376348854566`, 
                   0.5225133995089664, -0.7465174704490127], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.7866700615626998`, \
-0.1654345660099091}, {-1.8134921794509746`, -0.14239286393069772`}, \
{-1.8410215165668977`, -0.1169843479225693}, {-1.8570590049725062`, \
-0.09676259708031981}, {-1.8638724564691853`, -0.07905671480742651}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.019999999999999997`, 1.}}], {
                  LABColor[
                  0.33278128547052155`, 
                   0.5223387733361653, -0.5127867246960305], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.1203987411222536`, \
-0.8211119531758387}, {-1.1307317090121345`, -0.7719004153642972}, \
{-1.1485895534633115`, -0.7263389993278389}, {-1.1736404503916051`, \
-0.6868067086707388}, {-1.1878771949500282`, -0.6689675352064569}, \
{-1.2036253737070082`, -0.6538777523763073}, {-1.2228693942646134`, \
-0.6446340200102795}, {-1.2431082258202275`, -0.6382058957918938}, \
{-1.2850936042334806`, -0.6293352005601853}, {-1.32959386423843, \
-0.6258639458825718}, {-1.3757666370470043`, -0.6225616736513824}, \
{-1.4237933484841032`, -0.6153450583868453}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.31953481870272016`, 
                   0.5223624260806103, -0.5444450580922581], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.4340691073511205`, \
-0.6138009968411877}, {-1.4384548216148003`, -0.6131419883112653}, \
{-1.4994897218620464`, -0.5895699186956771}, {-1.54247775421728, \
-0.5598712550401208}, {-1.5833820581456366`, -0.5221554709828876}, \
{-1.6219399073955865`, -0.4780127318203171}, {-1.6580129049550028`, \
-0.42995297027594087`}, {-1.691583392829118, -0.38304507992041187`}, \
{-1.7228166166602237`, -0.34537679888510087`}, {-1.7321831132702041`, \
-0.3369866944864669}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.01841995191460892, 1.}}], {
                  LABColor[
                  0.2965927584903973, 
                   0.5224033911693964, -0.5992753312307159], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.7399230794333052`, \
-0.33005356603360264`}, {-1.7662598530411484`, -0.3064622181375769}, \
{-1.8057313195119125`, -0.2784833436411645}, {-1.841496835505599, \
-0.2578483527178806}, {-1.87364374613829, -0.242398430707641}, \
{-1.927624604161288, -0.2197969507328096}, {-1.9682561037485518`, \
-0.20012266060464665`}, {-1.9955913424998704`, -0.17933752896210484`}, \
{-2.0099755766936647`, -0.15643333913405674`}, {-2.002353938629254, \
-0.09988690505571154}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.23728232700016563`, 
                   0.5225092952194013, -0.7410240289707046], 
                  Arrow[
                   
                   GeoGridPosition[{{0.7512148919207207, 
                    1.1593696964042002`}, {0.7326342864337528, 
                    1.1550979088892102`}, {0.7028548642651824, 
                    1.1520066152327135`}, {0.6571666424958454, 
                    1.151809160588834}, {0.629793766459582, 
                    1.1526806540516312`}, {0.5985842818191395, 
                    1.1542605437261628`}, {0.5517176924778866, 
                    1.1569334287421984`}, {0.5066391206883983, 
                    1.1566725229645762`}, {0.4638696509335228, 
                    1.1527605790998547`}, {0.38408444708047945`, 
                    1.1412136932950463`}, {0.33856772993757994`, 
                    1.1306405139988114`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.010644981565240689`, 1.}}], {
                  LABColor[
                  0.3518722245488553, 
                   0.5223046847666507, -0.4671604211100758], 
                  Arrow[
                   
                   GeoGridPosition[{{0.3284461034836597, 
                    1.1282893389144828`}, {0.31643902470665775`, 
                    1.1255001879233275`}, {0.26170952903306505`, 
                    1.1088434192111651`}, {0.19465272506258396`, 
                    1.0698365105050396`}, {0.18469497066937687`, 
                    1.058100425125311}, {0.17618084005416487`, 
                    1.0458707604990143`}, {0.16858029691360793`, 
                    1.0333184634789223`}, {0.1548013919989166, 
                    1.0076329015429015`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.3942564136302159, 
                   0.522229004027747, -0.36586451993225677`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.09562628147351498, -0.64856611379594}, {
                    0.09065318400885476, -0.6036950115417196}, {
                    0.09499341888654644, -0.5541773838817642}, {
                    0.1099005979931873, -0.5020629138190073}, {
                    0.13246601161565635`, -0.44932402461243015`}, {
                    0.14641415983272654`, -0.4201643260101492}, {
                    0.15919854470923034`, -0.3927199659337999}, {
                    0.1666545444730278, -0.3712452967280536}, {
                    0.17217313500970213`, -0.351281410438109}, {
                    0.17972040972089354`, -0.3141395493303535}, {
                    0.18085459115192593`, -0.2821506096000767}, {
                    0.17651513956639303`, -0.2545700465308437}, {
                    0.17393383793385256`, -0.24988555133496215`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0019848935796821588`, 1.}}], {
                  LABColor[
                  0.29693145614481853`, 
                   0.5224027863946135, -0.598465862301971], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.16478044926058244`, -0.23327416244285132`}, {
                    0.1531494810665046, -0.2121665111936693}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.014491413916174, 1.}}], {
                  LABColor[
                  0.2812527258559789, 
                   0.5224307821618808, -0.6359371729098793], 
                  Arrow[
                   
                   GeoGridPosition[{{0.7991964306035013, 
                    1.0666718008958371`}, {0.7900770585763033, 
                    1.0376187606207818`}, {0.7770763668997952, 
                    1.0058917464981605`}, {0.7600846743141728, 
                    0.9720108870396376}, {0.7505909096759631, 
                    0.9546311758717844}, {0.7401998282960013, 
                    0.9372336163083976}, {0.724039499103304, 
                    0.9170991702878899}, {0.7077351893186717, 
                    0.9009146938319781}, {0.6753772330753266, 
                    0.8787380067768528}, {0.6433396234868287, 
                    0.8772676527732555}, {0.6101375772722573, 
                    0.8964892591200548}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01348141290015546, 1.}}], {
                  LABColor[
                  0.33773369342373155`, 
                   0.5223299303713387, -0.5009507396862046], 
                  Arrow[
                   
                   GeoGridPosition[{{2.227809003155278, 0.8015446615202617}, {
                    2.2436181384838396`, 0.7930223445059575}, {
                    2.2517465376893195`, 0.7845000274916534}, {
                    2.2598749368947995`, 0.7759777104773492}, {
                    2.2680033361002794`, 0.767455393463045}, {
                    2.2842601345112388`, 0.7504107594344367}, {
                    2.300516932922198, 0.7333661254058284}, {
                    2.3335698868080987`, 0.6987113620072832}, {
                    2.3666228406939993`, 0.6640565986087381}, {
                    2.3996757945799, 0.6294018352101929}, {
                    2.4245943466309665`, 0.6032756823542327}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.016244457089859474`, 1.}}], {
                  LABColor[
                  0.20707894230339202`, 
                   0.5225632260488164, -0.8132084717497575], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAArjE/IvxQw7/YVlKWGhT1P+nZ+2tr
ZcK//EgMxVoF9T+Yvj7e14fBvyPmnVtg9fQ/Ao5iYJ1TwL/eIxIJTd30P0E9
o2sYIr2/FHCJTBm49D/xLNj29wS6v/uxxSVXlvQ/fAx0cHfEtb9i1K7Q6Wf0
P8jpwbCeG6+/wzJuJmsk9D83xqFyve+kv9hv+y7I7fM/5zymZfiIjb904X0m
AKbzP2YRoTn9l44/g0K/70BV8z80DmJLzd2dP7x+FZVELfM/ok6oW9RQpT9I
fCavggjzP+UwFTmbTqo/mhtR58Lo8j/vH85Tdr+uP7BK4f0Gy/I/L9Eb1r1W
sz+yIAV7EpPyP/IY1H4pebY/AMc1aUNh8j8UexxsP/u4P2IC8ygeNPI/grwd
0YlvvT8o4DOuLtDxP7b8nYE=
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2510142434588797, 
                   0.5224847756613612, -0.7082054972792329], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.8273763893115385`, -0.36479975321520214`}, {
                    1.8249030338926868`, -0.38043709579123586`}, {
                    1.8215804329762302`, -0.3951215001585515}, {
                    1.816271520459092, -0.41151476821619676`}, {
                    1.807958171519425, -0.4299558180852949}, {
                    1.7726115116087369`, -0.4788505792854204}, {
                    1.7075805882469872`, -0.541232584200649}, {
                    1.6670597724524092`, -0.5752069580315531}, {
                    1.6264412346990984`, -0.6083400845765695}, {
                    1.5857738359664213`, -0.6410525874786421}, {
                    1.5550814166465654`, -0.6656965753558861}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.013414385284471192`, 1.}}], {
                  LABColor[
                  0.39315414847873553`, 
                   0.5222309722202013, -0.36849887355034233`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.5469274614148545`, -0.672134929254532}, {
                    1.495431959791839, -0.7094887206472064}, {
                    1.4658944689017481`, -0.7292045416129801}, {
                    1.430998687381578, -0.7502725100251725}, {
                    1.3558950053936634`, -0.7913414755010217}, {
                    1.3080535250924656`, -0.8148140950824154}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.018460723167362376`, 1.}}], {
                  LABColor[
                  0.3049699288080424, 0.522388432986798, -0.5792543508831381], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.5762040137430129`, -0.9808231817650009}, {
                    1.6103849376633594`, -0.9760845199935998}, {
                    1.650324174396316, -0.9685632094441616}, {
                    1.7193399346999956`, -0.9532216100269604}, {
                    1.747914034805549, -0.9455814913938828}, {
                    1.7763734731061682`, -0.9375201522448722}, {
                    1.8321301409025368`, -0.9173978341982373}, {
                    1.886724599894036, -0.8932758764029888}, {
                    1.9413190588855354`, -0.8691539186077403}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01912839279427392, 1.}}], {
                  LABColor[
                  0.23103825744332132`, 
                   0.5225204445608909, -0.7559470147936347], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8286312111134712, 
                    1.3242545494032911`}, {-0.8010955870001482, 
                    1.3234595371249538`}, {-0.7887004120587429, 
                    1.3226524531922148`}, {-0.7745060708132178, 
                    1.320638122777572}, {-0.7570744738076183, 
                    1.316404121499746}, {-0.7415822145368762, 
                    1.3112112344745024`}, {-0.7213171335325917, 
                    1.3027430777028481`}, {-0.6915433080771748, 
                    1.2878062710372602`}, {-0.6678168228427142, 
                    1.2746796428666463`}, {-0.6360097349828806, 
                    1.256100117804449}, {-0.5965369878204827, 
                    1.2324483536986806`}, {-0.575311379310424, 
                    1.2196698101604682`}, {-0.5569383198340321, 
                    1.208138143137204}, {-0.5432545711286867, 
                    1.1984156562688117`}, {-0.5314682380344765, 
                    1.18935177962566}, {-0.51117610390884, 
                    1.1723265013155597`}, {-0.49640085991859295`, 
                    1.1570911265318269`}, {-0.48547654215754765`, 
                    1.1429456668160172`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.2705572168928869, 
                   0.5224498799443044, -0.6614988562274987], 
                  Arrow[
                   
                   GeoGridPosition[{{1.37307377388681, 0.5889146640939517}, {
                    1.40433914906066, 0.5913697219127526}, {
                    1.4227424325811897`, 0.5924900024126541}, {
                    1.444701016228854, 0.5934547846979249}, {
                    1.4464810766021374`, 0.5935051990124492}, {
                    1.448738889777481, 0.5935666092157401}, {
                    1.4591646719626281`, 0.5938124527789276}, {
                    1.4693772411173607`, 0.5939991597536021}, {
                    1.4803417755561505`, 0.5941476521022873}, {
                    1.5303750948248473`, 0.5941689743061666}, {
                    1.5930242218918647`, 0.5932425728208355}, {
                    1.6479784623629423`, 0.5911635872886721}, {
                    1.7040870300987967`, 0.5871350270114405}, {
                    1.758058650154652, 0.5805674115761215}, {
                    1.7873917131384833`, 0.574708369497824}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.49771013227464883`, 0.5284297891571763, 
                   0.07835377310895611], 
                  Arrow[
                   
                   GeoGridPosition[{{1.7975815486960554`, 
                    0.5726730322629892}, {1.806602047585732, 
                    0.5708712605696961}, {1.8884767066915236`, 
                    0.5417181180041832}, {1.9471158011502738`, 
                    0.5072337669240946}, {1.9991228731300583`, 
                    0.4652890572382351}, {2.0612444043688862`, 
                    0.40639909317876}, {2.1143155201545576`, 
                    0.35686130336931005`}, {2.1345034645664844`, 
                    0.33969800751462803`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0010569848181072345`, 1.}}], {
                  LABColor[
                  0.34185224195165065`, 
                   0.5223225763366723, -0.49110763324197604`], 
                  Arrow[
                   
                   GeoGridPosition[{{2.1449513924712815`, 
                    0.3308154351219437}, {2.1566246665485944`, 
                    0.3208911034270662}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.019999999999999997`, 1.}}], {
                  LABColor[
                  0.27294915298732275`, 
                   0.5224456089296888, -0.6557822593668031], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.1938972061549262`, 
                    0.3851739645044792}, {-2.228963455975692, 
                    0.33781299886995536`}, {-2.2553909170142985`, 
                    0.32963357483983974`}, {-2.2898448209907363`, 
                    0.3356410230958547}, {-2.3389766350751207`, 
                    0.3477563016480517}, {-2.409270028579919, 
                    0.3408327264827851}, {-2.478626485163862, 
                    0.31310404218759796`}, {-2.55531848608551, 
                    0.26846395376262294`}, {-2.5631528869334876`, 
                    0.26325472563601704`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.008010172998209109, 1.}}], {
                  LABColor[
                  0.35861648391369116`, 
                   0.5222926422917763, -0.45104200891569374`], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.5718058005290625`, 
                    0.25750125427888154`}, {-2.593657540859253, 
                    0.24297165558306114`}, {-2.6303906883020405`, 
                    0.21751014379972372`}, {-2.666320882079351, 
                    0.1920640252144985}, {-2.6994139688270584`, 
                    0.16855892460294955`}, {-2.700681611901922, 
                    0.16766905979297303`}, {-2.7023103600904244`, 
                    0.16652639499354896`}, {-2.7043353667433445`, 
                    0.16510682665818485`}, {-2.70634831810253, 
                    0.1636969264611305}, {-2.708351363666411, 
                    0.1622949718863567}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.006553388631696423, 1.}}], {
                  LABColor[
                  0.44737596566662924`, 
                   0.5251499266451758, -0.14588619414503357`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.362138563968868, -0.3635795338108835}, {
                    2.3614988486502444`, -0.3078428139835543}, {
                    2.360859133331621, -0.2521060941562251}, {
                    2.3606700487370142`, -0.2356316487796025}, {
                    2.360622777588363, -0.23151303743544685`}, {
                    2.3605755064397114`, -0.2273944260912912}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.013415668608326464`, 1.}}], {
                  LABColor[
                  0.44737596566662924`, 
                   0.5251499266451758, -0.14588619414503357`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.3147192164503245`, -0.7030099070435084}, {
                    2.313922151428957, -0.6335637198305885}, {
                    2.31312508640759, -0.5641175326176685}, {
                    2.3123222568549116`, -0.49416909689317634`}, {
                    2.3115194273022333`, -0.4242206611686842}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.00804346686425916, 1.}}], {
                  LABColor[
                  0.35392359028806164`, 
                   0.5223010218706919, -0.4622577688309601], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.05519418785574674, 
                    1.0913485517556731`}, {-0.02324740160915724, 
                    1.0508637466334125`}, {-0.008762012125095553, 
                    1.0306321627937494`}, {0.00334522066942256, 
                    1.0109209493795928`}, {0.010061607312107118`, 
                    0.9938116029351067}, {0.014682135383663517`, 
                    0.9773544262819546}, {0.019877278043017196`, 
                    0.9456769479988415}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.3145118978163481, 0.5223713949525499, -0.556449565168075], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.7770655259028878`, \
-0.41248636395415816`}, {-1.821189504989873, -0.38571055519463693`}, \
{-1.8640000650575759`, -0.367734205279845}, {-1.9448098665058804`, \
-0.3481156517669697}, {-2.0164536622249014`, -0.3346545258731436}, \
{-2.0494415070536793`, -0.3272353329997657}, {-2.078834949250253, \
-0.31718136857836265`}, {-2.09876387866927, -0.30487097664222346`}, \
{-2.11590883082065, -0.2915685311238698}, {-2.1449471584309188`, \
-0.26358875481686067`}, {-2.1509328118667197`, -0.2540999618504835}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.008898076037961356, 1.}}], {
                  LABColor[
                  0.23427886163637854`, 
                   0.5225146581739116, -0.7482021474454303], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.156476783103788, \
-0.24531134823555986`}, {-2.1638124084506827`, -0.23368250421006587`}, \
{-2.1731716400722547`, -0.20323600616637952`}, {-2.1640969584607275`, \
-0.1388928839583395}, {-2.118636488613507, -0.0800726585260479}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01590337090281396, 1.}}], {
                  LABColor[
                  0.3855305496849213, 
                   0.5222445848338274, -0.38671885903962844`], 
                  Arrow[
                   
                   GeoGridPosition[{{-2.030435069449584, \
-0.6979801264256317}, {-2.0982888003434015`, -0.707378778784645}, \
{-2.1653217682071664`, -0.7147031190913367}, {-2.2163146730338066`, \
-0.7181929875336234}, {-2.2668368346783385`, -0.7185160683831538}, \
{-2.3268659366445297`, -0.7264611584593393}, {-2.3582909206376903`, \
-0.7342927474570661}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.27226355074304837`, 
                   0.5224468331334677, -0.6574208113525447], 
                  Arrow[
                   GeoGridPosition[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAM116GfoO9L+yA8nB6FvPv4z7NHJd
2fS/EpwbUPN/0L9DL0cHk6f1v2QUO35+69G/KZGdYY6r9r+8MNtKt2nTv/fs
yEZlyva/zsZ+r3+F079y8O9DEun2v3UyyybZmtO/OKTlNpMK97/6o6SMiKrT
v/Dj9mQmEve/pOiNxe+s078rECf+Mhj3v8bVU6yRrtO/P6NulCke979c2TsL
1a/Tv+UCCjOaJfe/tIoziw2x0790opNHHkb3vwU7MC9AsdO/AlgUa1dj979s
zBLQJ6rTv/FYCVE2gPe/7k4oklec07/8GDBN/BT4v4LowkQp7NK/l0r71c2b
+L8P8iiNhK7Rv38PuDiwE/m/+xn1pTcd0L+N0RHDCtL5vxz8wpQxrcm/wnd+
7g7i+b8bbCFsbg7Jv8sFrgs=
                    "], {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.009816223743836701, 1.}}], {
                  LABColor[
                  0.2547346705591207, 
                   0.5224781325079098, -0.6993138793421322], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.6242160384371573`, \
-0.18766672095183942`}, {-1.6495140232919943`, -0.15632076129448927`}, \
{-1.677116106011295, -0.12127006813679901`}, {-1.698666671519855, \
-0.09487675264045714}, {-1.7266315238644967`, -0.062019999009138155`}, \
{-1.743289019179204, -0.04209407978962325}, {-1.7524700537410005`, \
-0.02909264458826196}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01181911380548423, 1.}}], {
                  LABColor[
                  0.3546431574850706, 
                   0.5222997370194693, -0.46053804245990443`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.9180502161595794`, -0.4584534160658205}, {
                    1.9403656616575933`, -0.45644665914285654`}, {
                    1.9678585146049288`, -0.45154950646888387`}, {
                    1.9940653592185575`, -0.44143888764526784`}, {
                    2.0175247838657917`, -0.42930092914295065`}, {
                    2.0590905935739006`, -0.4014206389995676}, {
                    2.090339525074357, -0.36728166919190697`}, {
                    2.113016202036568, -0.3290374189130944}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.23416824103184697`, 
                   0.5225148556968386, -0.7484665246593804], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.266463298334419, 
                    0.3359639887639797}, {-1.264986319017017, 
                    0.40030491968075843`}, {-1.2619428557145023`, 
                    0.46580639456016065`}, {-1.2637864917225923`, 
                    0.5027394301864215}, {-1.27298206909679, 
                    0.5439196919190563}, {-1.2913312518710307`, 
                    0.5916330973669156}, {-1.3029472069213106`, 
                    0.6175084416764237}, {-1.3170293216135587`, 
                    0.6459384523721566}, {-1.327069640839081, 
                    0.6643779426975345}, {-1.3380826345039587`, 
                    0.6842043873560425}, {-1.3621542433368683`, 
                    0.7271040256441603}, {-1.363346216531585, 
                    0.7292608817901894}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0021575768037047608`, 1.}}], {
                  LABColor[
                  0.32359577829273656`, 
                   0.5223551748761143, -0.5347395860699489], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.3728781420691856`, 
                    0.746508746314652}, {-1.3855550422137093`, 
                    0.7694473913366233}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.009240115464553396, 1.}}], {
                  LABColor[
                  0.3620535660866551, 
                   0.5222865050758908, -0.44282756990721667`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.346497703985582, -0.14144347668638121`}, {
                    2.3559715420452725`, -0.10576187453628785`}, {
                    2.3667224626829952`, -0.07223273301979463}, {
                    2.3818310693439324`, -0.03977016130983627}, {
                    2.399039973249692, -0.009339189735291131}, {
                    2.4245943466309665`, 0.03262853827391956}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.005791315101380481, 1.}}], {
                  LABColor[
                  0.3953460340618765, 
                   0.5222270584135644, -0.3632603865051679], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.22856118146116447`, 
                    1.214196997004657}, {-0.24595911137683918`, 
                    1.2206653479193388`}, {-0.26069799751826095`, 
                    1.2267676190486185`}, {-0.27755528761092085`, 
                    1.2346165167240997`}, {-0.2887406789900807, 
                    1.2416886070389643`}, {-0.2977429836752867, 
                    1.248358085678438}, {-0.31186901643834336`, 
                    1.2608460788645972`}, {-0.31964738658406305`, 
                    1.271819553146021}, {-0.3234235150291514, 
                    1.2816227587881774`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.26810658660935677`, 
                   0.5224542557626144, -0.6673557290002046], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.7908354831862651, -0.36583779587554355`}, {
                    0.7852015076355239, -0.31455530733383674`}, {
                    0.7820855039561883, -0.26341283938659915`}, {
                    0.7810265227303922, -0.21102341481290832`}, {
                    0.7816007638387396, -0.16980843397036638`}, {
                    0.7833979090078418, -0.12699754560222357`}, {
                    0.7865350192738285, -0.08187956280193019}, {
                    0.7913852720447083, -0.029730993622124894`}, {
                    0.7949399511459126, 0.0251421738394953}, {
                    0.7935090448794573, 0.048859009548621955`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.29301189759302326`, 
                   0.5224097851149808, -0.6078333935519186], 
                  Arrow[
                   
                   GeoGridPosition[{{0.7928832561331377, 
                    0.059231267489631916`}, {0.791615763724411, 
                    0.0802395682603062}, {0.7869658265540912, 
                    0.11106072432710079`}, {0.7788330122471562, 
                    0.14119561608340628`}, {0.7652725319084619, 
                    0.16672210254594352`}, {0.7489291315674607, 
                    0.19122369872448447`}, {0.7114502234522115, 
                    0.23999047312201843`}, {0.6659015616460491, 
                    0.29154647306528897`}, {0.6158671690991291, 
                    0.3543008395639728}, {0.5832321661030109, 
                    0.4044006228460979}, {0.5816957283336806, 
                    0.40755392220199627`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.005140120266397247, 1.}}], {
                  LABColor[
                  0.36879911844595475`, 
                   0.5222744602922597, -0.4267060675265585], 
                  Arrow[
                   
                   GeoGridPosition[{{0.5771442213523815, 
                    0.4168951817824303}, {0.55453454264005, 
                    0.46329802786173524`}, {0.5355989450253174, 
                    0.5151541084623588}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.008372566273097626, 1.}}], {
                  LABColor[
                  0.23590715945944718`, 
                   0.5225117507033412, -0.7443106044208133], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.6879928816757044`, 
                    0.2559832774522089}, {-1.7005004417737752`, 
                    0.24348767113742256`}, {-1.7111702799500705`, 
                    0.22728622101499696`}, {-1.7171870782551069`, 
                    0.21634047680476193`}, {-1.7225132543193638`, 
                    0.2045714034134793}, {-1.7269079130709186`, 
                    0.19123198671953107`}, {-1.7307073765681755`, 
                    0.17805819928295646`}, {-1.7352398801892972`, 
                    0.16100983240412414`}, {-1.7389054625546525`, 
                    0.1447088521071263}, {-1.7418338108149491`, 
                    0.12941736887316027`}, {-1.746771045136571, 
                    0.09594004603708456}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.3730200795190822, 
                   0.5222669233908862, -0.41661820068267036`], 
                  Arrow[
                   
                   GeoGridPosition[{{1.6480982160477184`, 
                    0.8276452486912453}, {1.7223865507430356`, 
                    0.8212483895630127}, {1.7979316288429195`, 
                    0.8139074057493377}, {1.8692365416063372`, 
                    0.8050982758312624}, {1.9036395100752013`, 
                    0.7998695330462823}, {1.936809863243924, 
                    0.7939499250916763}, {1.9691077659551457`, 
                    0.7908370787206683}, {1.985079780974038, 
                    0.7908370787206683}, {2.00105179599293, 
                    0.7908370787206683}, {2.0170238110118226`, 
                    0.7908370787206683}, {2.048967841049607, 
                    0.7908370787206683}, {2.0615013277528336`, 
                    0.7908370787206683}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0037489086236316385`, 1.}}], {
                  LABColor[
                  0.33773369342373155`, 
                   0.5223299303713387, -0.5009507396862046], 
                  Arrow[
                   
                   GeoGridPosition[{{2.071892446381252, 0.7908370787206683}, {
                    2.0809118710873915`, 0.7908370787206683}, {
                    2.1498031548517664`, 0.7908370787206683}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.009548304736182973, 1.}}], {
                  LABColor[
                  0.4473759656666292, 
                   0.5251499266451758, -0.14588619414503376`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    2.1708496075675874`, -0.7307048119203509}, {
                    2.1707641605710988`, -0.7232600389647397}, {
                    2.17067871357461, -0.7158152660091285}, {
                    2.1704650960833884`, -0.6972033336201005}, {
                    2.1702514785921667`, -0.6785914012310724}, {
                    2.1693898952046005`, -0.6035238977922354}, {
                    2.169174499357709, -0.5847570219325261}, {
                    2.1689591035108173`, -0.5659901460728168}, {
                    2.1718174120008906`, -0.5324019257651078}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01804582502088983, 1.}}], {
                  LABColor[
                  0.2494670172307879, 0.522487538371389, -0.711903283611765], 
                  
                  Arrow[
                   
                   GeoGridPosition[{{-2.475054932312673, \
-0.0330192318576986}, {-2.449358958057793, -0.013949747392356746`}, \
{-2.418468048640031, 0.003479776054855312}, {-2.376727782511599, 
                    0.02683779486148481}, {-2.3412792635921997`, 
                    0.050800063038369994`}, {-2.2824016932314004`, 
                    0.0995101050147712}, {-2.249925831287908, 
                    0.13277936978082472`}, {-2.223423618935016, 
                    0.15105811783137685`}, {-2.1957593515169185`, 
                    0.1511086497931823}, {-2.1865224328002264`, 
                    0.14756511015608684`}, {-2.1764324771876953`, 
                    0.14242335184078556`}, {-2.165310456755704, 
                    0.13576622298453095`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.36508174747511973`, 
                   0.5222810979887202, -0.43559038148099477`], 
                  Arrow[
                   
                   GeoGridPosition[{{0.9719528592372769, 1.27583994823877}, {
                    0.9836625492668164, 1.250535163617796}, {
                    0.9953989201892113, 1.2191857298191047`}, {
                    1.0171686473714507`, 1.1577932714061183`}, {
                    1.0358675131282316`, 1.1100424188412414`}, {
                    1.0671950516567557`, 1.043387908395739}, {
                    1.1082070006150861`, 0.9861005458588277}, {
                    1.1425059685823171`, 0.9648557520483575}, {
                    1.1595159657082246`, 0.9601835227407902}, {
                    1.1741449062349743`, 0.9594470275711271}, {
                    1.1759264312581592`, 0.9596813612385842}, {
                    1.1781804014074921`, 0.9600285884310183}, {
                    1.1887595627321497`, 0.9623918950786131}, {
                    1.1946448849562459`, 0.9643862127211831}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.006387125497031769, 1.}}], {
                  LABColor[
                  0.2099042962215951, 
                   0.5225581811281318, -0.8064560299195911], 
                  Arrow[
                   
                   GeoGridPosition[{{1.2042654472249297`, 
                    0.9682854265157987}, {1.2069383148371666`, 
                    0.9694771788876806}, {1.2274937357337312`, 
                    0.9822552907079961}, {1.2440787647271614`, 
                    0.9968215168412657}, {1.2581689968996996`, 
                    1.0120696482603497`}, {1.2716122210221612`, 
                    1.028843230498335}, {1.283942372393758, 
                    1.0456466719538506`}, {1.295886727442131, 
                    1.062228628372159}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.2958932540565384, 
                   0.5224046401967712, -0.6009471086916365], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.2308497580097437`, -0.28201171683100773`}, {
                    1.2611114144204787`, -0.2465710483328765}, {
                    1.2873388432090862`, -0.20312869241971776`}, {
                    1.3094109196689137`, -0.1456601651142686}, {
                    1.3163227320596327`, -0.12110107906231418`}, {
                    1.3231078342690297`, -0.09326312799201474}, {
                    1.3298610289859076`, -0.06150975051433232}, {
                    1.333239164536154, -0.04456650581865296}, {
                    1.3365991583142147`, -0.026470895037510128`}, {
                    1.3475405130837725`, 0.041244723605033076`}, {
                    1.359981266584458, 0.10263472038543081`}, {
                    1.3609894902224058`, 0.10566334530677883`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.020000000000000007`, 1.}}], {
                  LABColor[
                  0.4069412650661715, 
                   0.5228401116613688, -0.3159993247966452], 
                  Arrow[
                   
                   GeoGridPosition[{{1.3642715887233463`, 
                    0.1155225124004023}, {1.3768925337096918`, 
                    0.1534348436312136}, {1.3865402053129612`, 
                    0.17638734753389543`}, {1.397575223760372, 
                    0.1971327795279954}, {1.4131349583444295`, 
                    0.21495762384653072`}, {1.4313873757925326`, 
                    0.23082609666461926`}, {1.475242232416696, 
                    0.2588364517268608}, {1.53623474661748, 
                    0.27929639541725304`}, {1.614190945549032, 
                    0.29125154506586}, {1.665097854178366, 
                    0.29365546374929286`}, {1.6983222902370156`, 
                    0.2925141971690816}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.012074398809990946`, 1.}}], {
                  LABColor[
                  0.48947525750994664`, 0.5278931902850404, 
                   0.041667200706596685`], 
                  Arrow[
                   
                   GeoGridPosition[{{1.708707283850549, 0.2921574703874468}, {
                    1.7138270891858969`, 0.29198160396442896`}, {
                    1.7969837095548116`, 0.27940623302604245`}, {
                    1.8582421551788526`, 0.26056447982733505`}, {
                    1.9091433611940685`, 0.23871677294569627`}, {
                    1.946877705233156, 0.21976622366759516`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.019999999999999997`, 1.}}], {
                  LABColor[
                  0.3412924526667701, 
                   0.5223235758902236, -0.49244549911391255`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.5920116417937247, -1.1829062841229414`}, {
                    0.6523468461098054, -1.1844725831148488`}, {
                    0.7096877661231193, -1.1852983617253106`}, {
                    0.7821729522421497, -1.1833915955721896`}, {
                    0.853192845132116, -1.1847341082973728`}, {
                    0.9004109109018414, -1.1881579206116506`}, {
                    0.9482973411332054, -1.196656834175591}, {
                    0.9992142717028449, -1.209094208330055}, {
                    1.005014363010049, -1.2106639010517966`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.0050214734968402, 1.}}], {
                  LABColor[
                  0.34444553588346943`, 
                   0.522317945779731, -0.48490980212768264`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.015044653069459, -1.2133784226807331`}, {
                    1.0555238384873973`, -1.2243334024159043`}, {
                    1.1158969926807796`, -1.2401952313552203`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.008360572530135894, 1.}}], {
                  LABColor[
                  0.21817741987880143`, 
                   0.5225434087300987, -0.7866837154179839], 
                  Arrow[
                   
                   GeoGridPosition[{{1.1773167442294319`, 
                    0.702679315921386}, {1.1620986548710877`, 
                    0.7451815662216047}, {1.1579922264034923`, 
                    0.7666622337008652}, {1.158183903724183, 
                    0.7880699450841665}, {1.1651682772973961`, 
                    0.8075429568067151}, {1.1739391019701886`, 
                    0.8270621325239687}, {1.1919037224061446`, 
                    0.8663955952994244}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.4179010672815165, 
                   0.5232292906086004, -0.27719760136796145`], 
                  Arrow[
                   
                   GeoGridPosition[{{0.05127269284975232, 
                    0.07994344588491344}, {-0.02010319800553454, 
                    0.09783541437994017}, {-0.05865323692771928, 
                    0.11601080714052436`}, {-0.09109896140686213, 
                    0.14141218663348507`}, {-0.11700347794451696`, 
                    0.1746626735310619}, {-0.1283313201313153, 
                    0.19329828588609038`}, {-0.13815637822742152`, 
                    0.2139047217029526}, {-0.14472868446820902`, 
                    0.23659494205162263`}, {-0.15016426611296527`, 
                    0.26128316025072723`}, {-0.15883378365488193`, 
                    0.31480507846822203`}, {-0.16306784942909372`, 
                    0.37720788364672964`}, {-0.1630898325247508, 
                    0.38298659972309407`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.016936803004271757`, 1.}}], {
                  LABColor[
                  0.5801874683368908, 0.533804156925036, 
                   0.44579236172853504`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.16312936159988295`, 
                    0.3933776431645432}, {-0.1633338063919341, 
                    0.447120229058045}, {-0.1617667546897405, 
                    0.522092902711946}, {-0.16089194221690253`, 
                    0.5847215501215897}, {-0.1611443864785726, 
                    0.6348238910301666}, {-0.16352720501880222`, 
                    0.7006807410870619}, {-0.16757639188506893`, 
                    0.7451115697944416}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.009659298674943141, 1.}}], {
                  LABColor[
                  0.1886675222501131, 
                   0.5225961012766809, -0.8572107619122568], 
                  Arrow[
                   
                   GeoGridPosition[{{1.6375170489340776`, 
                    1.1091681244482299`}, {1.6438325355678032`, 
                    1.1081661012175956`}, {1.646565985168123, 
                    1.1077324085889606`}, {1.648684408608371, 
                    1.107396296801768}, {1.7036816611144816`, 
                    1.0986703619960636`}, {1.7414468949635462`, 
                    1.0926784814298023`}, {1.7730885238888339`, 
                    1.0926784814298023`}, {1.8047301528141215`, 
                    1.0926784814298023`}, {1.8369588822761092`, 
                    1.0926784814298023`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.37447867258606227`, 
                   0.5222643189432499, -0.41313224277303934`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.4541050234507112, -1.0001150127070333`}, {
                    0.4657820223685129, -0.9618058432952875}, {
                    0.4741219409403798, -0.9171646914822611}, {
                    0.47884803686624383`, -0.865291714418017}, {
                    0.48245147770891617`, -0.812468573128024}, {
                    0.4863475038257737, -0.7632123086836097}, {
                    0.4905144237313763, -0.7178524827316943}, {
                    0.4996289230503823, -0.6381668886977687}, {
                    0.5077820750551741, -0.5888542104019183}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.017176535782688896`, 1.}}], {
                  LABColor[
                  0.33735253080395133`, 
                   0.5223306109710938, -0.5018616975670273], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    0.5094770879719905, -0.5786022702166806}, {
                    0.5110445595307763, -0.5691217379426757}, {
                    0.5241523672366188, -0.5149388900915954}, {
                    0.537042688126066, -0.47300669702754367`}, {
                    0.5431405069830836, -0.45473787386243236`}, {
                    0.5484628102944201, -0.43870994288469123`}, {
                    0.5527696489697116, -0.42476910446924887`}, {
                    0.5564401803614626, -0.41203420809615643`}, {
                    0.5625746373174604, -0.38840373961897845`}, {
                    0.5665754330711427, -0.36780831868592667`}, {
                    0.5689163438839957, -0.3492602196461411}, {
                    0.5690090902070328, -0.30670625829129156`}, {
                    0.5611605141008738, -0.2691765121991102}, {
                    0.5447455893387423, -0.23405791111713625`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.007377495651255906, 1.}}], {
                  LABColor[
                  0.25680735235632945`, 
                   0.5224744315502337, -0.6943602828465122], 
                  Arrow[
                   
                   GeoGridPosition[{{1.1950396113792212`, 
                    1.331141215301644}, {1.2441320763762553`, 
                    1.3264136446082124`}, {1.2669853823102266`, 
                    1.3260167226956143`}, {1.2876562485778607`, 
                    1.3258013324018596`}, {1.2898762283527696`, 
                    1.3257963636362657`}, {1.292703988269802, 
                    1.325793102417336}, {1.3101288908445925`, 
                    1.3257963280626393`}, {1.333207054766142, 
                    1.3257969509081677`}, {1.3462635767728406`, 
                    1.3257969509081677`}, {1.3443983593433122`, 
                    1.3257969509081677`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.012188082065004897`, 1.}}], {
                  LABColor[
                  0.2388342285458997, 0.522506524161178, -0.7373150688838992], 
                  Arrow[
                   
                   GeoGridPosition[{{1.14802372269996, 0.593655980037248}, {
                    1.1216575490281335`, 0.6115672359993577}, {
                    1.0931135327335035`, 0.6285791712636145}, {
                    1.0617178144080368`, 0.6423576705647056}, {
                    1.0451647209020392`, 0.6481310263883172}, {
                    1.0275534313949493`, 0.6523414506891606}, {
                    1.0024999700550394`, 0.6529359422094181}, {
                    0.9740036062040776, 0.6509176180333888}, {
                    0.9100171556615388, 0.6417558007492368}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.020000000000000004`, 1.}}], {
                  LABColor[
                  0.3578717666888908, 
                   0.5222939720506101, -0.4528218424820265], 
                  Arrow[
                   
                   GeoGridPosition[{{0.18225741674485568`, 
                    0.19754654519575474`}, {0.14888944779581978`, 
                    0.25991913870540223`}, {0.1382587711203682, 
                    0.29888948818519767`}, {0.13168601636407995`, 
                    0.34619274889936874`}, {0.13027185340985944`, 
                    0.4029599188263264}, {0.13253878440989025`, 
                    0.45586544187730577`}, {0.13541917967529785`, 
                    0.5070404445150689}, {0.13697514083422557`, 
                    0.5519534546134639}, {0.13731992673367177`, 
                    0.5726526644376899}, {0.13726211711599884`, 
                    0.591753773604221}, {0.13675102498540784`, 
                    0.6027592854339939}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.006760719431832908, 1.}}], {
                  LABColor[
                  0.42058458833084217`, 
                   0.523404153543322, -0.2652424481831999], 
                  Arrow[
                   
                   GeoGridPosition[{{0.1361540063679581, 
                    0.6131325060216898}, {0.13541069421824917`, 
                    0.6237036606993054}, {0.13265741414986804`, 
                    0.6523649312453579}, {0.12881159091821498`, 
                    0.6770693765873702}, {0.12403021622519407`, 
                    0.6983911348910505}, {0.10366207828325733`, 
                    0.7486821967890519}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01130607775051467, 1.}}], {
                  LABColor[
                  0.3538353363762885, 
                   0.5223011794558999, -0.46246869086861814`], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.6113811203758304`, -0.20009152294864413`}, {
                    1.5478423146206635`, -0.22753121097636406`}, {
                    1.492247859870997, -0.2507036574696476}, {
                    1.468076373406028, -0.2607728036478641}, {
                    1.4484589466029008`, -0.26952631649095476`}, {
                    1.4268411589553456`, -0.2804127124797705}, {
                    1.4113957780566417`, -0.2905786230583936}, {
                    1.4004135393995285`, -0.3010335276156721}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.00024978215749678036`, 1.}}], {
                  LABColor[
                  0.4473759656666293, 
                   0.5251499266451759, -0.1458861941450334], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.9453432867856921`, \
-1.0142315283813284`}, {-1.947275338601011, -1.0146941650664583`}, \
{-1.9499275299269385`, -1.0153292417210427`}, {-1.9503916057776365`, \
-1.0154403663355656`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.004094493631071427, 1.}}], {
                  LABColor[
                  0.2029486407230988, 
                   0.5225706010696028, -0.8230796673484004], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.7007746122825959, \
-0.5309509666193579}, {-0.6892883625475884, -0.5230983189231798}, \
{-0.6780164672800727, -0.5157632319235982}, {-0.6670865463031586, \
-0.5091477001485902}, {-0.6611158502985676, -0.5056849820909588}, \
{-0.6553558236097192, -0.5024604463237877}, {-0.6498775045622315, \
-0.49947042075551124`}, {-0.6447534056641447, -0.4966784918487817}, \
{-0.6400458543617411, -0.49400467970986034`}, {-0.6357981761799335, \
-0.49133170005016286`}, {-0.6320391981031844, -0.4885610797078613}, \
{-0.6288019841183703, -0.4857733308039501}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.017831542671891402`, 1.}}], {
                  LABColor[
                  0.3101732593228702, 
                   0.5223791419774226, -0.5668186746309924], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.6454019731711366, \
-0.6042264700349396}, {-0.6485494318527407, -0.6248637313472658}, \
{-0.6519323484196041, -0.6493925642386279}, {-0.6554823589598672, \
-0.6786418338393894}, {-0.6572887397615182, -0.694562167998008}, \
{-0.6590999525445941, -0.7118961839096989}, {-0.6609032631604643, \
-0.7328380669497419}, {-0.662678585336486, -0.7558859459827324}, \
{-0.66617369069853, -0.8065751849227532}, {-0.6692008935944879, \
-0.8650944778207811}, {-0.6691112280048204, -0.9234252795909005}, \
{-0.6635042360054565, -0.9732649946995371}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.31432475636974083`, 
                   0.5223717291102457, -0.5568968230227769], 
                  Arrow[
                   
                   GeoGridPosition[{{-1.1026639192013996`, \
-1.1113910567150889`}, {-1.0561598348605157`, -1.103508806718167}, \
{-1.0050637417494832`, -1.0995882502171272`}, {-0.9460363802102641, \
-1.102534301082532}, {-0.9140065441853092, -1.1060772838391484`}, \
{-0.8786070350523624, -1.1118143686549582`}, {-0.8232377894553323, \
-1.1220991261256654`}, {-0.7670092754865012, -1.1319968991461082`}, \
{-0.7398653437580482, -1.1366430156908174`}, {-0.7136766427962096, \
-1.1413278746107778`}, {-0.6915663637235271, -1.1454498062550988`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.003231654779300822, 1.}}], {
                  LABColor[
                  0.4087655856059813, 0.522634006611748, -0.317896400013513], 
                  
                  Arrow[
                   
                   GeoGridPosition[{{-0.6813512405870812, \
-1.1473541711510977`}, {-0.6631207241986076, -1.1507528140242582`}, \
{-0.6153691100022843, -1.159881804272144}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.01011945366283623, 1.}}], {
                  LABColor[
                  0.35113339835799434`, 
                   0.5223060040065196, -0.46892617542646425`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.9208853328328414, \
-0.8902058857404701}, {-0.8961246344652734, -0.911095342044929}, \
{-0.8827348569116702, -0.9230133048518945}, {-0.8682947225185547, \
-0.9361030921782629}, {-0.8588649234948803, -0.9445675336062146}, \
{-0.8491859458268007, -0.9532079739539441}, {-0.8293675005343208, \
-0.9708575836129215}, {-0.8094785374282746, -0.9884880736347605}, \
{-0.7858727960604008, -1.0090674933581183`}, {-0.7626418647074424, \
-1.0286982099991473`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.33175999019508295`, 
                   0.5223405969497051, -0.5152275647247406], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.723991803999137, \
-0.3760366649239075}, {-0.7149318668675283, -0.3030645826027648}, \
{-0.6963101244327764, -0.22786302547605497`}, {-0.6845186982614417, \
-0.18980976863634777`}, {-0.6699267503607662, -0.15106929364344476`}, \
{-0.6500854415841525, -0.11185920582972926`}, {-0.6280566188238771, \
-0.07124774029358055}, {-0.605898357872575, -0.029296330043247023`}, \
{-0.5853351051998575, 0.011643986231630803`}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.40217622473961795`, 
                   0.5222872193238544, -0.3447046610772783], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.5808311834990557, 
                    0.02100716821837421}, {-0.5613190391866607, 
                    0.06277139854461247}, {-0.5399256461777492, 
                    0.11313819648630571`}, {-0.5295304598221594, 
                    0.13946085201028371`}, {-0.519348956547291, 
                    0.16661457606327001`}, {-0.5093741692697016, 
                    0.19463577044219554`}, {-0.4900297715300826, 
                    0.25342128660450025`}, {-0.4714632318738658, 
                    0.3161551526167457}, {-0.4536493703382221, 
                    0.3831810080043994}, {-0.4469961530388951, 
                    0.4135795516420762}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.008965369071859384, 1.}}], {
                  LABColor[
                  0.48372389236440183`, 0.5275184212522956, 
                   0.016044725580581252`], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.4447744766348146, 
                    0.4237303890609997}, {-0.4386945791390495, 
                    0.45150943505072144`}, {-0.4315456607847848, 
                    0.5236962644073139}, {-0.4391106923977355, 
                    0.5723343851311063}, {-0.4564926734737852, 
                    0.6039980691227588}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.02, 1.}}], {
                  LABColor[
                  0.36672889621961535`, 
                   0.5222781568581532, -0.4316537857818932], 
                  Arrow[
                   
                   GeoGridPosition[{{
                    1.0240008135738865`, -0.32635228130900135`}, {
                    1.0301136499694286`, -0.2533199862666439}, {
                    1.0402864368760334`, -0.16694864664312864`}, {
                    1.0445984860485247`, -0.13387800777305897`}, {
                    1.0494409672502847`, -0.0978265749145451}, {
                    1.054885780268358, -0.058158293656591226`}, {
                    1.0578563315984795`, -0.03678217411440891}, {
                    1.0609940852665671`, -0.014365603646404714`}, {
                    1.0647849705797108`, 0.01393973674578211}, {
                    1.0716109867284531`, 0.0864672484006534}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}, {
                 Arrowheads[{{0.018244590191714795`, 1.}}], {
                  LABColor[
                  0.49197635809820073`, 0.5280561663828081, 
                   0.052809666188873665`], 
                  Arrow[
                   
                   GeoGridPosition[{{1.0725846568531627`, 
                    0.09681264896506425}, {1.0726619085846754`, 
                    0.09763346094903153}, {1.0731514285473045`, 
                    0.16562197547745885`}, {1.0675270990630907`, 
                    0.2216202714709817}, {1.0632964182569502`, 
                    0.2470376039240464}, {1.057699256381523, 
                    0.27025168265937427`}, {1.047201391054772, 
                    0.2940201249264803}, {1.0346543794220278`, 
                    0.3156727403407093}, {1.005162056338072, 
                    0.3553100750904639}, {0.9669787547977884, 
                    0.3885944439180552}, {0.9221304821335976, 
                    0.4174957688376388}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.011160432995853413`, 1.}}], {
                  LABColor[
                  0.27362478242570215`, 
                   0.5224444025332416, -0.6541675418434472], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.3041869524086682, \
-0.283168516633716}, {-0.3313447340700502, -0.2707379044151776}, \
{-0.3555631083711158, -0.2557644973675911}, {-0.3667992862072778, \
-0.24749208968330771`}, {-0.3770169092214017, -0.23827625068694405`}, \
{-0.38536695097681517`, -0.22611151629314097`}, {-0.3924038718753769, \
-0.2124725599603061}, {-0.40375111052274454`, -0.18199186361758202`}, \
{-0.4095244964633148, -0.14461783456305605`}, {-0.40936202452656684`, \
-0.09917665134745327}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}, {
               Hue[0.67, 0.6, 0.6], 
               Directive[
                RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
                 Arrowheads[{{0.00817081792182162, 1.}}], {
                  LABColor[
                  0.30892605456209343`, 
                   0.5223813689724391, -0.5697994260133921], 
                  Arrow[
                   
                   GeoGridPosition[{{-0.8505634664372438, \
-0.7442646586577388}, {-0.8338401463408152, -0.7638324195364037}, \
{-0.8247823899118436, -0.7756429507556396}, {-0.8149572628124717, \
-0.7897665935118657}, {-0.8028632302182841, -0.810339153952817}, \
{-0.7892887409016477, -0.8353185940382933}, {-0.7630723158771177, \
-0.8889375540459789}}, {
                    "EckertVI", "Centering" -> 
                    GeoPosition[{0., -2.842170943040401*^-14}]}]]}}}}}}}}}, 
         Sequence[
         GeoRange -> Automatic, PlotRange -> Automatic, 
          CoordinatesToolOptions -> {
           "DisplayFunction" -> (
             GeoGraphics`GeoGridPositionDisplay[#, {
              "EckertVI", "LongitudeDetermination" -> -2.842170943040401*^-14,
                "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
                179.99999999999997`}}, "Centering" -> 
               GeoPosition[{0., -2.842170943040401*^-14}]}, "ITRF00"]& ), 
            "CopiedValueFunction" -> (
             GeoGraphics`GeoGridPositionCopiedValue[#, {
              "EckertVI", "LongitudeDetermination" -> -2.842170943040401*^-14,
                "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
                179.99999999999997`}}, "Centering" -> 
               GeoPosition[{0., -2.842170943040401*^-14}]}, "ITRF00"]& )}, 
          GeoBackground -> GeoStyling["StreetMapNoLabels"], GeoCenter -> 
          GeoPosition[{0., -2.842170943040401*^-14}], GeoGridLines -> None, 
          GeoGridLinesStyle -> GrayLevel[0.4, 0.3], 
          GeoGridRange -> {{-2.770964967578247, 
           2.770964967578247}, {-1.3854824837891235`, 1.3854824837891235`}}, 
          GeoGridRangePadding -> None, GeoModel -> "ITRF00", 
          GeoProjection -> {
           "EckertVI", "Centering" -> 
            GeoPosition[{0., -2.842170943040401*^-14}]}, 
          GeoRange -> {{-90., 90.}, {-180.00000000000003`, 
           179.99999999999997`}}, GeoRangePadding -> Full, GeoResolution -> 
          Automatic, GeoServer -> {Automatic}, GeoZoomLevel -> 1, 
          MetaInformation -> <|"GeoMetaInformation" -> <|"Attribution" -> Row[{
                 Hyperlink[
                 "Wolfram Knowledgebase", "https://www.wolfram.com/"], ", ", 
                 Hyperlink[
                 "\[Copyright] OpenStreetMap contributors", 
                  "https://www.openstreetmap.org/copyright"]}], "GeoModel" -> 
              "ITRF00", 
              "LonLatBox" -> {{-180.00000000000003`, 
                179.99999999999997`}, {-90., 90}}, 
              "PlotRange" -> {{-2.770964967578247, 
               2.770964967578247}, {-1.3854824837891235`, 
               1.3854824837891235`}}, 
              "Projection" -> {
               "EckertVI", 
                "LongitudeDetermination" -> -2.842170943040401*^-14, 
                "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
                 179.99999999999997`}}, "Centering" -> 
                GeoPosition[{0., -2.842170943040401*^-14}]}, "Software" -> 
              "Created with the Wolfram Language: www.wolfram.com", 
              "TileSources" -> {"Wolfram", "OSM"}|>|>, 
          Method -> {
           "VectorMapRemoveLabels" -> True, "OriginalInput" -> HoldForm[
              GeoGraphics[{
                Annotation[
                 Point[{
                   GeoPosition[CompressedData["
1:eJx1lrFtwzAURIVM4izB+leqjRSsXBgx4tYreI1s4RE8ikaJE+bucEfoA8bH
0/mTJ/JT0vvn7ePrbVmW79fvN//FvT9Hvo68HZ3va3Bz5jjUK+qdt2PoPXnk
x8X9gOGH3JwR0ivqneGHek/+/9/Z/YDhh9ycEdIr6p3hh3pPHvlwcj9g+CE3
Z4T0inpn+KHekz2zf3B9DW7OCOkV9c7sH86b7D4yc7/AzRkhvaLemfvF+07e
mXfdyc0ZIb2izpnrA70n+zy5DpOPyPTD6xX1zvTDfU/2cXMfpnUIHxnwo3pn
+KHek582TvbBtA+xDuljyquz1qfMz945yD6c+iD2gX5iXtV7Vv+En51zmOdg
6sPoA0Ted86r8UPvyc+47jydg+hDxLzu7meedy+P8Q8n9wPW89n9gBHSK+qd
9Xx2H+Ix/nZ2P2C9v9wPGCG9ot5Z7y/3Ix7jPy7uB6z3u/sBI6RX1Dvr/e5+
xGP8+9X9gPX9437ACOkV9c76/nE/L/4BJOSHeA==
                    "]]}], "GeoVectorPlotPlaceHolder"]}, GeoBackground -> 
               GeoStyling["GeoPlotMap"], 
               Method -> {"VectorMapRemoveLabels" -> True}, {
               GeoProjection -> "EckertVI", MetaInformation -> {}, PlotRange -> 
                Automatic}]], 
            "BasicGeoRange" -> {{-90., 90}, {-180.00000000000003`, 
              179.99999999999997`}}}, 
          PlotRange -> {{-2.770964967578247, 
           2.770964967578247}, {-1.3854824837891235`, 1.3854824837891235`}}, 
          PlotRangeClipping -> True, PlotRangePadding -> None]]], 
      "BasicGeoRange" -> {{-90., 90}, {-180.00000000000003`, 
        179.99999999999997`}}, 
      "GeoGraphicsOptions" -> {
       GeoBackground -> GeoStyling["StreetMapNoLabels"], GeoCenter -> 
        GeoPosition[{0., -2.842170943040401*^-14}], GeoGridLines -> None, 
        GeoGridLinesStyle -> GrayLevel[0.4, 0.3], 
        GeoGridRange -> {{-2.770964967578247, 
         2.770964967578247}, {-1.3854824837891235`, 1.3854824837891235`}}, 
        GeoGridRangePadding -> None, GeoModel -> "ITRF00", 
        GeoProjection -> {
         "EckertVI", "Centering" -> 
          GeoPosition[{0., -2.842170943040401*^-14}]}, 
        GeoRange -> {{-90., 90.}, {-180.00000000000003`, 
         179.99999999999997`}}, GeoRangePadding -> Full, GeoResolution -> 
        Automatic, GeoServer -> {Automatic}, GeoZoomLevel -> 1, 
        MetaInformation -> <|"GeoMetaInformation" -> <|"Attribution" -> Row[{
               Hyperlink["Wolfram Knowledgebase", "https://www.wolfram.com/"],
                ", ", 
               Hyperlink[
               "\[Copyright] OpenStreetMap contributors", 
                "https://www.openstreetmap.org/copyright"]}], "GeoModel" -> 
            "ITRF00", 
            "LonLatBox" -> {{-180.00000000000003`, 
              179.99999999999997`}, {-90., 90}}, 
            "PlotRange" -> {{-2.770964967578247, 
             2.770964967578247}, {-1.3854824837891235`, 1.3854824837891235`}},
             "Projection" -> {
             "EckertVI", "LongitudeDetermination" -> -2.842170943040401*^-14, 
              "GeoRange" -> {{-90., 90.}, {-180.00000000000003`, 
               179.99999999999997`}}, "Centering" -> 
              GeoPosition[{0., -2.842170943040401*^-14}]}, "Software" -> 
            "Created with the Wolfram Language: www.wolfram.com", 
            "TileSources" -> {"Wolfram", "OSM"}|>|>}}, 
    PlotRange -> {{-2.770964967578247, 
     2.770964967578247}, {-1.3854824837891235`, 1.3854824837891235`}}, 
    PlotRangeClipping -> True, PlotRangePadding -> None, DefaultBaseStyle -> 
    "GeoGraphics"], "\"Fig. 1. Wind speed on the surface of the Earth.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {LightDarkAutoColorRules -> {}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->8457350,ExpressionUUID->"9ce65bc5-c4de-45a8-a611-b3498bfed693"],

Cell["\<\
This chapter will focus on fluid flow in two dimensions. Then, a vector field \
has the form\
\>", "Text",
 CellID->889987501,ExpressionUUID->"c234dc1e-b493-4a55-9ec7-d3ce8075950d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"F", "(", 
    RowBox[{"x", ",", "y"}], ")"}], "=", 
   RowBox[{"(", 
    RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], ")"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->364031605,ExpressionUUID->"b6626fd3-f908-49a7-9170-07a864288e50"],

Cell[TextData[{
 "with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", ",", "\[CapitalPsi]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"141d061e-1d98-413b-abc2-00a411671951"],
 " both functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6f5bad92-7f4e-4eb0-83c0-611f60add284"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath",ExpressionUUID->
  "fd7dbfe7-64f0-4ee3-a10b-0ae73624e1f1"],
 ". The field may look like this:"
}], "Text",
 CellID->22264074,ExpressionUUID->"e3a1d40d-1ea0-45f1-ac06-9c47701a43d3"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}}, {{
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.26353742105440314`, 0.5224624144140566, -0.6782757855720365], 
           
           ArrowBox[{{0.3314870556612831, -1.}, {
            0.3258547951473, -0.9903557012654967}, {
            0.30806016858538454`, -0.9591325193179328}, {
            0.29027529346162106`, -0.9270995997827118}, {
            0.27252144835830494`, -0.8942565995965576}, {
            0.26021430869653817`, -0.8710641633284697}, {
            0.25437033988637286`, -0.8598284482360863}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.27505850752364647`, 0.5224418424895757, -0.6507410170240447], 
           
           ArrowBox[{{0.2525245816436114, -0.856279761646758}, {
            0.2479493673794352, -0.8474833758978343}, {
            0.2357415462094384, -0.8235164994933851}, {
            0.22360576698899015`, -0.7991657963038568}, {
            0.21156120788634966`, -0.7744353710670876}, {
            0.19962364197712262`, -0.7493278544816324}, {
            0.18780288342477147`, -0.7238432976773012}, {
            0.18261981866445923`, -0.7123809668699634}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2846770656170449, 0.5224246676987049, -0.6277531875711396], 
           
           ArrowBox[{{0.18097174780048975`, -0.7087362635312354}, {
            0.17610874639275845`, -0.6979817517839025}, {
            0.16457443945770664`, -0.6718400778803625}, {
            0.15315566815309228`, -0.6453086383075961}, {
            0.14189133745996957`, -0.6184033635008077}, {
            0.13082035235939296`, -0.5911401838952016}, {
            0.11998161783241679`, -0.5635350299259821}, {
            0.11910070655359312`, -0.5612066908311409}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.29230201679702367`, 0.522411052670273, -0.6095299699526506], 
           
           ArrowBox[{{0.11768525326981448`, -0.557465502249762}, {
            0.10941403886009526`, -0.5356038320283532}, {
            0.09915652042348282, -0.5073625206375191}, {
            0.08924796750363378, -0.47882702618868417`}, {
            0.07811013092934488, -0.4449599489412702}, {
            0.06752802331195668, -0.4107114131153887}, {
            0.06617223612429561, -0.40602867527832526`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2976797980816378, 0.5224014501635339, -0.5966773658715273], 
           
           ArrowBox[{{0.06505980863784062, -0.40218647472559776`}, {
            0.057501644651469175`, -0.3760814187110397}, {
            0.04803099494788239, -0.3410699657282231}, {
            0.03922984334670975, -0.30572732319997037`}, {
            0.03121195899346473, -0.2701037601593127}, {
            0.026547114679146035`, -0.2469527317741411}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.30073296228397634`, 0.5223959984673275, -0.5893804698821746], 
           
           ArrowBox[{{0.025757009703120975`, -0.24303154137748087`}, {
            0.023977341888147298`, -0.23419927660625034`}, {
            0.01752599203075747, -0.19801387254078306`}, {
            0.012002812487509193`, -0.16161651489329854`}, {
            0.007552706324616414, -0.12507617059418424`}, {
            0.0041756735420791285`, -0.08839283964344016}, {
            0.003940183510739026, -0.08462878430543758}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3017321166786507, 0.5223942143882992, -0.5869925453514013], 
           
           ArrowBox[{{0.0036904204315319237`, -0.08063658962027191}, {
            0.0018717141398973422`, -0.05156652204106634}, {
            0.0006372794840980421, -0.025795699801693526`}, {
            5.239223735416961*^-6, 
            6.957047776698811*^-6}, {-0.0008125302570612148, 
            0.022401331698664824`}, {-0.002175505766586808, 
            0.04481806589062475}, {-0.004177698147316464, 
            0.06730049106084066}, {-0.005538116279048381, 
            0.07904545933943351}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.30365254998201013`, 0.5223907852838486, -0.5824028144557065], 
           
           ArrowBox[{{-0.005998358605967641, 
            0.08301889324482466}, {-0.006787770451758487, 
            0.08983416339691784}, {-0.01075792188193668, 
            0.12175439544490294`}, {-0.016147142167067457`, 
            0.15386729037042385`}, {-0.02295543130715083, 
            0.1861728481734807}, {-0.03118278930218678, 
            0.2186710688540734}, {-0.037499990970507505`, 
            0.23961129158725486`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3168461822753341, 0.5223672268800565, -0.5508707525730181], 
           
           ArrowBox[{{-0.038655276046375704`, 
            0.24344082372492862`}, {-0.041076310676274964`, 
            0.2514660549992553}, {-0.052883089953514976`, 
            0.2846619091960795}, {-0.06660312713390683, 
            0.31825863144454614`}, {-0.0822364222174505, 
            0.3522562217446551}, {-0.10015221499038476`, 
            0.38679917290437466`}, {-0.10204880491714843`, 
            0.39004808912909983`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.34674553875737935`, 0.5223138389200566, -0.4794129206519735], 
           
           ArrowBox[{{-0.10406539067625048`, 
            0.3935025618640026}, {-0.1207197452389484, 
            0.42203197773167295`}, {-0.14393901296314143`, 
            0.4579546362265501}, {-0.1565430483785989, 
            0.47617466059933056`}, {-0.16981001816296373`, 
            0.4945671483890058}, {-0.1872701126767804, 
            0.5176460033511534}, {-0.1937720891113201, 
            0.5257879572928273}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.39223275046173134`, 0.5222326174583022, -0.3707009645776528], 
           
           ArrowBox[{{-0.19626815612352805`, 
            0.5289136011417914}, {-0.20597782336772907`, 
            0.5410723138481781}, {-0.22601398699865494`, 
            0.564876305216521}, {-0.24745944033240294`, 
            0.5890882027926228}, {-0.2703950201318181, 
            0.6137382319129244}, {-0.29490156315974575`, 
            0.6388566179138668}, {-0.3036319549336318, 
            0.6474063249208304}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.45514977084179664`, 0.5256564814147856, -0.11125369826020642`], 
           
           ArrowBox[{{-0.3064898005320484, 
            0.6502050243572849}, {-0.32105990617903085`, 
            0.664473586131891}, {-0.3489508859525183, 
            0.6906193619034376}, {-0.37871263469577443`, 
            0.7173398979746267}, {-0.4105009139944339, 
            0.7446859862945563}, {-0.42543571635099736`, 
            0.7571432851177343}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5277567745399057, 0.5303876810270222, 0.21221231357359657`], 
           
           ArrowBox[{{-0.42851820300806726`, 
            0.7596923820585838}, {-0.4444230046664436, 
            0.7726951110041345}, {-0.4622177545230632, 
            0.7869600257990753}, {-0.4805861875297506, 
            0.801404756244269}, {-0.499541713788749, 
            0.8160339878573288}, {-0.5190977434023022, 
            0.8308524061558684}, {-0.5392676864726533, 
            0.845864696657501}, {-0.5551349806923854, 
            0.8574698276767113}}]}}, {
          Arrowheads[{{0.013963220541581438`, 1.}}], {
           LABColor[
           0.6058789928664764, 0.5354782616904322, 0.5602487440917115], 
           
           ArrowBox[{{-0.5583635949377834, 
            0.8598311938182516}, {-0.5600649531020456, 
            0.8610755448798404}, {-0.5815029533927226, 
            0.8764896363405}, {-0.6035950974469276, 
            0.8921116565570932}, {-0.6263547953669042, 
            0.9079462910472339}, {-0.6497954572548961, 
            0.9239982253285353}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.25300286257851234`, 0.5224812248050718, -0.7034528060000402], 
           
           ArrowBox[{{0.35448994131861084`, -0.945602945521961}, {
            0.34054249664033576`, -0.9156125953537406}, {
            0.3269003540209877, -0.8850231774074417}, {
            0.3136460684147763, -0.8538683565873225}, {
            0.300862194775911, -0.8221817977976416}, {
            0.29189428102535997`, -0.7984109531259014}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.26073452330466973`, 0.5224674192372553, -0.6849745583838392], 
           
           ArrowBox[{{0.2904823574654, -0.7946684310002714}, {
            0.2860702457587503, -0.7829734454138308}, {
            0.27214089857144264`, -0.7430168116802863}, {
            0.2590741532139881, -0.7023118965970077}, {
            0.24687000968638653`, -0.6608587001639951}, {
            0.2418198709089116, -0.642311688123133}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2654218075194322, 0.5224590496744416, -0.6737722046547282], 
           
           ArrowBox[{{0.24079337989912653`, -0.63844578123066}, {
            0.23579771013822734`, -0.6187855455424078}, {
            0.23078696766253456`, -0.5975646050963334}, {
            0.22612649671909968`, -0.5762207558934052}, {
            0.2218162973079228, -0.5547539979336233}, {
            0.21785636942900366`, -0.5331643312169875}, {
            0.2142467130823425, -0.5114517557434979}, {
            0.21098732826793923`, -0.48961627151315446`}, {
            0.2099432736155791, -0.481552823057111}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2674591721154297, 0.5224554117787691, -0.6689030143445587], 
           
           ArrowBox[{{0.20942964157720287`, -0.4775859373606038}, {
            0.2081501730000525, -0.4677043388258363}, {
            0.20580720529294094`, -0.4457624179814225}, {
            0.20395842514660462`, -0.42379050897991316`}, {
            0.20260383256104347`, -0.4017886118213081}, {
            0.20174342753625754`, -0.3797567265056075}, {
            0.2013772100722468, -0.3576948530328113}, {
            0.20150518016901126`, -0.33560299140291944`}, {
            0.20200194605527394`, -0.31793965449461786`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.26764735722042177`, 0.5224550757575285, -0.668453262203216], 
           
           ArrowBox[{{0.20211439808916837`, -0.3139412354895519}, {
            0.2021273378265509, -0.313481141615932}, {
            0.2036025344762311, -0.28653109011582023`}, {
            0.2059091133110207, -0.2596448592155016}, {
            0.20904642021615788`, -0.23284999273613083`}, {
            0.21301380107686912`, -0.20617403449895244`}, {
            0.2183601671936934, -0.1767694044997581}, {
            0.2229579417727346, -0.15553103743656443`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2671544253541478, 0.5224559559312129, -0.669631342489656], 
           
           ArrowBox[{{0.22380427443766696`, -0.15162159744850112`}, {
            0.22467463439947524`, -0.1476011688632775}, {
            0.23442208457434943`, -0.10866739263578472`}, {
            0.24530671828628947`, -0.07030851257914926}, {
            0.25732853553529533`, -0.0325245286933711}, {0.26940725614124, 
            0.001629901556859728}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2641019061633245, 0.522461406475694, -0.6769266969366521], 
           
           ArrowBox[{{0.27075538005293553`, 0.005395741539270098}, {
            0.27995119285774844`, 0.029812595593358943`}, {
            0.28953075243089255`, 0.05460166473564241}, {0.29922621504079927`,
             0.07905176644840013}, {0.30903758068746867`, 
            0.1031629007316322}, {0.3189648493709008, 0.12693506758533843`}, {
            0.3290080210910955, 0.150368267009519}, {0.3305154118433454, 
            0.15379496014564487`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2561605611587516, 0.5224755864534372, -0.695906078546573], 
           
           ArrowBox[{{0.3321260491948638, 0.1574563597853856}, {
            0.3391670958480529, 0.17346249900417376`}, {0.349442073641773, 
            0.19621776356930287`}, {0.3637384043821347, 
            0.22710991273164827`}, {0.37804578299745656`, 
            0.2573124922813911}, {0.39236420948773865`, 0.2868255022185312}, {
            0.40005818982481933`, 0.302301784003293}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2455929004356435, 0.5224944559514585, -0.721162211540738], 
           
           ArrowBox[{{0.40183886321857504`, 0.3058835715828084}, {
            0.4066936838529809, 0.31564894254306863`}, {0.42103420609318354`, 
            0.3437828132550036}, {0.4353857762083463, 0.37122711435433575`}, {
            0.4497483941984692, 0.39798184584106533`}, {0.4641220600635524, 
            0.42404700771519227`}, {0.4732223140879315, 0.4403248347787382}, {
            0.4770658977353447, 0.44707245485468544`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.23418363622249772`, 0.5225148282073567, -0.7484297309930492], 
           
           ArrowBox[{{0.47904571462888224`, 0.4505481310576801}, {
            0.48233703423300667`, 0.45632622157799324`}, {0.4989967856856753, 
            0.4832508531940829}, {0.515810834956235, 0.5092697382077253}, {
            0.5329475920018354, 0.5343288599669396}, {0.5503509201700931, 
            0.5584462240223862}, {0.5684863303538616, 
            0.5831055347026594}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.22331333455718258`, 0.5225342380976948, -0.7744091593395287], 
           
           ArrowBox[{{0.5708561944461378, 0.5863279164590843}, {
            0.5741586709454338, 0.5908184018236409}, {0.5988063829181883, 
            0.6213382061685936}, {0.6242940560883572, 0.650005637057245}, {
            0.6506216904559399, 0.6768206944895946}, {0.6782431186485163, 
            0.7015984235453887}, {0.6799493375023488, 
            0.7029088003101693}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2166732136133212, 0.5225460946241574, -0.7902786863852626], 
           
           ArrowBox[{{0.6831217188131651, 0.7053451904305695}, {
            0.7076121732936661, 0.7241538693043739}, {0.7387288543913891, 
            0.7444870317665496}, {0.7715931619416855, 0.7625979109319162}, {
            0.8069178879787475, 0.7781220760218408}, {0.8219749653911567, 
            0.7830395587735116}}]}}, {
          Arrowheads[{{0.01359657024343731, 1.}}], {
           LABColor[
           0.2240991461200985, 0.5225328349612657, -0.7725311125455055], 
           
           ArrowBox[{{0.8257773211891422, 0.7842813680928221}, {
            0.8454158245367671, 0.7906950962576907}, {0.8870869716157447, 
            0.800316971639466}, {0.9091124991005924, 0.8040212300100759}, {
            0.9319313292156798, 0.8069877021671668}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3583339291127138, 0.5222931468185015, -0.45171729948553774`], 
           
           ArrowBox[{{0.03364783752763265, -0.984647038209557}, {
            0.018340919204301333`, -0.968535926309402}, {
            0.002768549500545641, -0.9521559672084526}, \
{-0.013069271583634417`, -0.9355071609067085}, {-0.029172544048238856`, \
-0.9185895074041699}, {-0.045541267893267665`, -0.9014030067008366}, \
{-0.062175443118720836`, -0.8839476587967088}, {-0.07666328904320739, \
-0.8687529202498615}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.38525865995588965`, 0.5222450703171183, -0.3873686606689668], 
           
           ArrowBox[{{-0.07942367126472623, -0.8658580472186214}, \
{-0.09624014771090031, -0.8482304213860694}, {-0.11947259121402266`, \
-0.8239398838369133}, {-0.14331680386267054`, -0.7991206624787378}, \
{-0.16777278565684395`, -0.7737727573115429}, {-0.19030670213246936`, \
-0.7505117597028321}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.41600340168258954`, 0.5231056353923195, -0.28565174892693984`], 
           
           ArrowBox[{{-0.19309073678099833`, -0.7476396287360543}, \
{-0.21862436221168968`, -0.7214590483728702}, {-0.24522856803220633`, \
-0.6944295502469411}, {-0.272653154058093, -0.6668076739575419}, \
{-0.30089812028934965`, -0.6385934195046727}, {-0.3056367813255773, \
-0.6339178091124908}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4536602739713862, 0.5255594231882127, -0.11788944395650165`], 
           
           ArrowBox[{{-0.3084840875522299, -0.6311083879529519}, \
{-0.33013812410184623`, -0.6097424709671122}, {-0.36054782287145276`, \
-0.5802105124236391}, {-0.37619130786517235`, -0.5651891543996854}, \
{-0.39212721659816935`, -0.5499975438742536}, {-0.4083555490704438, \
-0.5346356808473436}, {-0.42375703540796905`, -0.5201558554664653}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4978735677879645, 0.5284404389016616, 0.07908188239582398], 
           
           ArrowBox[{{-0.42667006071610436`, -0.5174146364932565}, \
{-0.44113942749011714`, -0.5037908558096951}, {-0.45774989497534924`, \
-0.48830043448628113`}, {-0.47469117232307134`, -0.4726358102963189}, \
{-0.49201286577714487`, -0.45678645639699184`}, {-0.5178057850941027, \
-0.4341115776714278}, {-0.5444509578702309, -0.4110501762539326}, \
{-0.5454267575216855, -0.41022233903751987`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.550103488635706, 0.5318438320824274, 0.3117674820558759], 
           
           ArrowBox[{{-0.548476969856556, -0.4076346364440592}, \
{-0.5721437462735944, -0.38755650023921606`}, {-0.600819029581505, \
-0.36364580026237503`}, {-0.6194582692874708, -0.3480870167758293}, \
{-0.6386090249963553, -0.33233091788052066`}, {-0.6582712967081582, \
-0.3163775035764487}, {-0.6717206053422482, -0.30561025690738736`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6114719287402652, 0.5358427071941656, 0.5851654128618317], 
           
           ArrowBox[{{-0.6748431970146984, -0.3031103726606382}, \
{-0.6784450844228797, -0.30022677386361374`}, {-0.6991303881405196, \
-0.2838787287420157}, {-0.7203272078610785, -0.2673333682116545}, \
{-0.7420355435845556, -0.2505906922725302}, {-0.7642553953109512, \
-0.23365070092464285`}, {-0.787077706943994, -0.21649028643547552`}, \
{-0.801724002105166, -0.20565058558230717`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6699207820489852, 0.47992497020758523`, 0.7463171434749145], 
           
           ArrowBox[{{-0.8049392182865991, -0.20327100895890313`}, \
{-0.8105934223874123, -0.19908634107251127`}, {-0.8348025416412058, \
-0.18143886483575009`}, {-0.8597050647053749, -0.1635478577251921}, \
{-0.8853009915799195, -0.1454133197408371}, {-0.9115903222648395, \
-0.12703525088268525`}, {-0.9353749812347151, -0.1106207396264168}}]}}, {
          Arrowheads[{{0.004172492370318108, 1.}}], {
           LABColor[
           0.7231857898157876, 0.35846398684692515`, 0.7760314668257244], 
           
           ArrowBox[{{-0.9386674745593444, -0.10834929231230594`}, \
{-0.9662491950658056, -0.0895485205449909}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2845683485720252, 0.5224248618226572, -0.6280130153816358], 
           
           ArrowBox[{{0.261395895782136, -1.}, {
            0.25844039371455774`, -0.9957349553215935}, {
            0.23947602339948806`, -0.9680180417625567}, {
            0.2202801091536064, -0.939597010000947}, {
            0.20085566316890321`, -0.9104660615823982}, {
            0.18268869996409828`, -0.8829407899932602}, {
            0.1723444461424879, -0.8670778502711846}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3002038364911532, 0.5223969432684866, -0.5906450516798248], 
           
           ArrowBox[{{0.17015954420339952`, -0.8637272975531143}, {
            0.16433405964697978`, -0.8547939020695934}, {
            0.14579263747867138`, -0.8260185746412713}, {
            0.1270653287202967, -0.7966079845381677}, {
            0.10816115506150877`, -0.766557111711788}, {
            0.0890826370491372, -0.7358594936163319}, {
            0.08458569248317561, -0.7285395716771983}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.31504242270594784`, 0.5223704476531791, -0.5551816396054056], 
           
           ArrowBox[{{0.0824918777135119, -0.7251313551772767}, {
            0.06982091823007043, -0.7045061433357156}, {
            0.050367142151197024`, -0.6724880739538552}, {
            0.029360964818066167`, -0.6375114543245785}, {
            0.00812666102593478, -0.601746658335164}, {
            0.00005144979116332091, -0.588008656679964}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3294168429550834, 0.5223447808474823, -0.5208275588832334], 
           
           ArrowBox[{{-0.0019755180078492953`, -0.5845602655273008}, \
{-0.01336065434101809, -0.5651912339016931}, {-0.03512586639861358, \
-0.5278427289402462}, {-0.04609367857252492, -0.5088742842354226}, \
{-0.057096472216958474`, -0.4897131613673239}, {-0.06815196617824884, \
-0.4703568833253978}, {-0.07927787930273085, -0.45080297309909123`}, \
{-0.08199797834508461, -0.4460114050325431}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.34400730831896165`, 0.5223187282740198, -0.4859571421153031], 
           
           ArrowBox[{{-0.08397270813376016, -0.4425328360362865}, \
{-0.09049193043673931, -0.4310489536778513}, {-0.10181183842660893`, \
-0.4110923480511251}, {-0.11325532211867438`, -0.3909306792083599}, \
{-0.12484010035927055`, -0.37056147013900287`}, {-0.13646515889179128`, \
-0.3500016689193842}, {-0.14807265913342713`, -0.329261159957877}, \
{-0.15974508344120786`, -0.3083268707419917}, {-0.1626145885980161, \
-0.3031944270275952}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.36034053340917066`, 0.5222895638480793, -0.44692162461426194`], 
           
           ArrowBox[{{-0.164566586674688, -0.2997030514378499}, \
{-0.17156491417216332`, -0.2871857287592395}, {-0.18361463368332318`, \
-0.2658246614971312}, {-0.19597672433171723`, -0.24423059644317763`}, \
{-0.20873366847437524`, -0.22239046108488975`}, {-0.2219679484683269, \
-0.20029118290977843`}, {-0.23778598505378126`, -0.17466960954716104`}, \
{-0.24589488326887174`, -0.1619450454752799}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3830006648411429, 0.522249102168203, -0.3927651458904799], 
           
           ArrowBox[{{-0.24804454496633319`, -0.15857177486851454`}, \
{-0.2543378885875566, -0.14869619719933194`}, {-0.27162365906965313`, \
-0.12237094586629124`}, {-0.2896432965000707, -0.09569385554803882}, \
{-0.3086437660039298, -0.06862302892021903}, {-0.3288720327063507, \
-0.04111656865847606}, {-0.33946115815822075`, -0.02732641874959234}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.42127814497433397`, 0.5234493469097415, -0.26215263604353467`], 
           
           ArrowBox[{{-0.34189730006544, -0.02415384682639027}, \
{-0.35032809660733355`, -0.013174474762809908`}, {-0.3730119577068783, 
            0.015203252766779425`}, {-0.3971994825459587, 
            0.04407970986681753}, {-0.4231665376655485, 
            0.07351799247382997}, {-0.44550885051618566`, 
            0.09767490372508723}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4778914845048336, 0.5271383713342694, -0.009938796857100574], 
           
           ArrowBox[{{-0.44822483303978333`, 
            0.1006114729702289}, {-0.4509131230656479, 
            0.10351810058781677`}, {-0.4804392387462566, 
            0.13408003420877787`}, {-0.5101704507818585, 
            0.16422860070076692`}, {-0.5257580854980163, 
            0.17952534274680437`}, {-0.5418695824051096, 
            0.1949827502499154}, {-0.5610989618726965, 
            0.2122010455269233}, {-0.5620208023719403, 
            0.2130076069578936}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5457329904983209, 0.5315590427640463, 0.2922968038812877], 
           
           ArrowBox[{{-0.5650311884586972, 
            0.21564153474898062`}, {-0.5810223309567654, 
            0.22963293433130805`}, {-0.6017228326267776, 
            0.24730436982284268`}, {-0.6231727525595796, 
            0.2652067009482696}, {-0.6446518173790995, 
            0.2831181383257101}, {-0.6669385902348446, 
            0.30127868384107015`}, {-0.6879569390056316, 
            0.3180333588235483}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6216223774603363, 0.5365041282224745, 0.6303859149976396], 
           
           ArrowBox[{{-0.6910932451117896, 
            0.3205159409369584}, {-0.7139352600550115, 
            0.33834709928554874`}, {-0.7387032136093085, 
            0.35727368942123533`}, {-0.7643949883795821, 
            0.37648682810797757`}, {-0.7910105843658319, 
            0.3959865153457754}, {-0.8185500015680582, 
            0.41577275113462875`}, {-0.8192568861835517, 
            0.4162706344817554}}]}}, {
          Arrowheads[{{0.017633254220689534`, 1.}}], {
           LABColor[0.685495162981103, 0.4444104795023469, 0.755005440171157], 
           
           ArrowBox[{{-0.8225271404266911, 
            0.41857398794686435`}, {-0.8470797909782881, 
            0.43586727113555634`}, {-0.876666503588549, 
            0.45629181100957683`}, {-0.9073101393988408, 
            0.4770463707566901}, {-0.9390106984091632, 
            0.4981309503768962}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.22511191034873018`, 0.5225310265806685, -0.7701106612535633], 
           
           ArrowBox[{{0.47336019246399175`, -0.991328575309543}, {
            0.46657262514043085`, -0.9661857055975498}, {
            0.4603829583076852, -0.9407357207125774}, {
            0.45486831183106124`, -0.9150190631157402}, {
            0.4500672456432232, -0.8890559540376499}, {
            0.44436156065016125`, -0.8520396360926921}, {
            0.4424641409417045, -0.8345350229857289}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.22732528883566613`, 0.5225270743965406, -0.7648208073400818], 
           
           ArrowBox[{{0.4420330842720935, -0.8305583170439244}, {
            0.4403024608676398, -0.8145924803901794}, {
            0.4381374504794129, -0.7769498049915414}, {
            0.43811403366923424`, -0.7393469279582079}, {
            0.4399742708872336, -0.7079840622694271}, {
            0.4436574050538, -0.6768824031256987}, {
            0.4446936323878815, -0.6710782731979991}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.22746796349314577`, 0.5225268196382513, -0.764479822687128], 
           
           ArrowBox[{{0.4453966473792078, -0.6671405365483524}, {
            0.4491634361689337, -0.6460419505270225}, {
            0.45649236423263473`, -0.6154627044733987}, {
            0.4658211966180623, -0.5853668988026606}, {
            0.47732694069837583`, -0.5559767673526415}, {
            0.49100959647357545`, -0.5272923101233414}, {
            0.4970609410363452, -0.5166167821336126}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.22975868267066413`, 0.5225227293554422, -0.7590051287396608], 
           
           ArrowBox[{{0.49903345484622913`, -0.5131369560934467}, {
            0.5068691639436609, -0.49931352711476057`}, {
            0.5250074336192703, -0.47229496713693814`}, {
            0.5455261960110411, -0.4464911789999133}, {
            0.5684254511189737, -0.4219021627036863}, {
            0.5937051989430678, -0.39852791824825706`}, {
            0.6017188009862698, -0.39163541412385233`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23903141136824552`, 0.522506172073713, -0.736843812688624], 
           
           ArrowBox[{{0.6047513909086157, -0.3890270816368243}, {
            0.6080205155134767, -0.3862153055215739}, {
            0.6230442932643173, -0.3743365254459844}, {
            0.6534903741393482, -0.3555911292221658}, {
            0.6863342332821228, -0.3386220360062905}, {
            0.7203826655991025, -0.3226076002509315}, {
            0.7448049197345851, -0.3131588420437762}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.2562109440702067, 0.522475496490268, -0.6957856661350009], 
           
           ArrowBox[{{0.7485354500923185, -0.31171553221909204`}, {
            0.7568402442644918, -0.3085024794166052}, {
            0.7957616729535624, -0.2964384550062942}, {
            0.8372016553415854, -0.28654730852298127`}, {
            0.8588854360799913, -0.28245166847248565`}, {
            0.8812375190577092, -0.2789694558408125}, {
            0.9041146943472432, -0.2761185173546116}}]}}, {
          Arrowheads[{{0.0024925159022293865`, 1.}}], {
           LABColor[
           0.2801567467767566, 0.522432739129994, -0.6385565031579759], 
           
           ArrowBox[{{0.9080962294018515, -0.2757352305204256}, {
            0.9279465917310821, -0.2738453128339342}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2759813060119628, 0.5224401947508087, -0.64853557894665], 
           
           ArrowBox[{{0.17890789001991894`, -0.5387041690348265}, {
            0.1689741156272862, -0.49650601801207817`}, {
            0.16448009577983555`, -0.4752302091225412}, {
            0.16030132083162874`, -0.4538365779808958}, {
            0.1564377907826657, -0.43232512458714173`}, {
            0.15288950563294648`, -0.41069584894127925`}, {
            0.14971970649192545`, -0.3889871177030941}, {
            0.1487997127043267, -0.3816523775383479}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2778880177087406, 0.522436790147507, -0.6439786419426027], 
           ArrowBox[{{0.14830189486182493`, -0.37768347625516047`}, {
            0.14699163446905697`, -0.3672372975323721}, {
            0.144705289564341, -0.3454463884291135}, {
            0.14286067177777756`, -0.323614390393318}, {
            0.1414577811093667, -0.30174130342498584`}, {
            0.14049661755910833`, -0.27982712752411687`}, {
            0.13997718112700253`, -0.25787186269071116`}, {
            0.13989947181304926`, -0.23587550892476875`}, {
            0.14032547641508225`, -0.21804011183762528`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.27810268302168595`, 0.5224364068435001, -0.6434656035479155], 
           
           ArrowBox[{{0.1404209905507193, -0.21404125236899008`}, {
            0.1405059007504518, -0.21048634446012965`}, {
            0.1417741723872869, -0.185124793083663}, {
            0.14368995446202104`, -0.15981613581778215`}, {
            0.14624608084387986`, -0.13457301317377873`}, {
            0.15026567139570232`, -0.10263227091571332`}, {
            0.1551528793768312, -0.07087098263432953}, {
            0.15792718652676704`, -0.05514401102696263}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.277201224626237, 0.5224380164776334, -0.6456200399667892], 
           
           ArrowBox[{{0.15862207504678744`, -0.051204832185535926`}, {
            0.16072204886766422`, -0.03930051630691849}, {
            0.166787523948599, -0.007932239910771093}, {0.173090203104651, 
            0.023208808538484962`}, {0.17942974129714137`, 
            0.054108527055891226`}, {0.18570861732092653`, 
            0.08477195171016051}, {0.1899177782626271, 
            0.1056999569938607}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2721828904151022, 0.5224469771596566, -0.6576135851388478], 
           
           ArrowBox[{{0.19070648718106614`, 0.10962142843223363`}, {
            0.19182930997086295`, 0.11520411857000558`}, {
            0.19625850913243936`, 0.137886413258455}, {0.20049722503460576`, 
            0.16041823725986915`}, {0.2045072250440549, 
            0.18281679430687936`}, {0.2082502765274798, 0.205099288132117}, {
            0.2116881468515733, 0.22728292246821347`}, {0.21478260338302824`, 
            0.24938490104779995`}, {0.21700041555007923`, 
            0.26740130935728723`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.26576970989667, 0.5224584284638074, -0.6729407369402801], 
           
           ArrowBox[{{0.2174891249338684, 0.2713713424979797}, {
            0.21749541348853754`, 0.27142242760350793`}, {0.2197883445347941, 
            0.29341270586796875`}, {0.22197161042884286`, 
            0.32042592621555777`}, {0.22342733829377365`, 
            0.34740012282250743`}, {0.2241555281295865, 
            0.37433529568881757`}, {0.22415617993628137`, 
            0.4012314448144882}, {0.2233078837030933, 0.4281486758091032}, {
            0.2231094471930905, 0.4310945198790956}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.2642564601218532, 0.5224611305058563, -0.6765573214018338], 
           
           ArrowBox[{{0.22284061038900665`, 0.435085475500594}, {
            0.22148922941925708`, 0.4551470942822461}, {0.21870021708477289`, 
            0.4822267002339172}, {0.21494084669964064`, 0.5093874936641163}, {
            0.21004439187680507`, 0.5367090323577082}, {0.20384412622921083`, 
            0.5642708740995577}, {0.19634004975685798`, 0.5920730188896648}, {
            0.19620645864463535`, 0.59249834469934}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2746079827923614, 0.5224426469415493, -0.6518177465698387], 
           
           ArrowBox[{{0.1950078277001163, 0.5963145317831766}, {
            0.18753216245974647`, 0.6201154667280293}, {0.17954603514466413`, 
            0.6438908401362521}, {0.17048930054347133`, 0.6679000461945899}, {
            0.15554727317800449`, 0.6990695945437136}, {0.1383124650896141, 
            0.7308747335012408}, {0.13154619458099975`, 
            0.7426382406304723}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.30241061904386135`, 0.5223930028619859, -0.5853709616895466], 
           
           ArrowBox[{{0.12955181082928022`, 0.7461055787234303}, {
            0.11980780348452082`, 0.7630460335458367}, {0.0987634348460218, 
            0.7959496557645701}, {0.07492659959484332, 0.8296871481298526}, {
            0.06186622214727165, 0.8469066761071039}, {0.04804453815171164, 
            0.8643600586140955}, {0.037706498073891315`, 
            0.876852039101533}}]}}, {
          Arrowheads[{{0.0095939293492534, 1.}}], {
           LABColor[
           0.34604794562238206`, 0.5223150845346372, -0.4810801302128162], 
           
           ArrowBox[{{0.03515624927746061, 0.8799336346422073}, {
            0.03338129181930626, 0.8820784061623783}, {0.017796227361198395`, 
            0.9000928292635038}, {0.0012893447773880161`, 
            0.9184033279174716}, {-0.016139355932124858`, 
            0.9370099021242818}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23982209728554263`, 0.5225047602336905, -0.7349541164533728], 
           
           ArrowBox[{{0.4128225890847784, -0.9831680434076564}, {
            0.40207131057664736`, -0.9566105782779981}, {
            0.3916906321795128, -0.9296028778105759}, {
            0.38174343624401086`, -0.9021730910342992}, {
            0.3722926051207781, -0.8743493669780773}, {
            0.3656353749235554, -0.8534548107112794}, {
            0.35932574094753933`, -0.8324597408836869}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.24554155340186884`, 0.5224945476361538, -0.7212849281520909], 
           
           ArrowBox[{{0.3582355388823949, -0.8286111896887224}, {
            0.3532696940143318, -0.8110513454887076}, {
            0.3475612433023308, -0.7895424365329337}, {
            0.34221747061251534`, -0.7678529718329873}, {
            0.3372867941386637, -0.7460071798743546}, {
            0.33276921388077574`, -0.7240050606570355}, {
            0.3286647298388517, -0.7018466141810303}, {
            0.32502648515130916`, -0.6795630337369146}, {
            0.32403404845704475`, -0.6724424007300331}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24809490523900485`, 0.5224899883993745, -0.7151825564665023], 
           
           ArrowBox[{{0.32348188648713994`, -0.668480694385667}, {
            0.32190762295656605`, -0.6571855126152644}, {
            0.31930814325462215`, -0.6347140508160795}, {
            0.3172280460454777, -0.6121486483393601}, {
            0.31581083845934016`, -0.5895116733839649}, {
            0.31499842843811343`, -0.5668377952187065}, {
            0.31482559082652817`, -0.5441545359450897}, {
            0.31530971304694927`, -0.521475656613935}, {
            0.3159189976322999, -0.5089148587154555}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24838599270784195`, 0.522489468636812, -0.7144868732856627], 
           
           ArrowBox[{{0.3161127971204569, -0.5049195562540153}, {
            0.3165673022593072, -0.4955496372864564}, {
            0.3187572533469316, -0.46968791489223827`}, {
            0.32190060575332585`, -0.44392945193832617`}, {
            0.3260183989219936, -0.4183132109317657}, {
            0.33116835056218513`, -0.3928593409242721}, {
            0.33737883577055344`, -0.3676030417318249}, {
            0.34316903290298806`, -0.3476337023838876}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.248580292897478, 0.5224891216965439, -0.7140225064254069], 
           
           ArrowBox[{{0.34428296898858685`, -0.343791938935001}, {
            0.3446268800717056, -0.342605852007866}, {
            0.352889508990249, -0.3179293104058372}, {
            0.366147235505755, -0.28401007527493183`}, {
            0.3813485414990604, -0.25094528091376933`}, {
            0.39849342697016504`, -0.21873492732234961`}, {
            0.41068355981051313`, -0.19871064859434423`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.24983164936587654`, 0.5224868872882843, -0.7110318326881365], 
           
           ArrowBox[{{0.41276352705309416`, -0.19529396361182244`}, {
            0.417581891919069, -0.18737901450067276`}, {
            0.4384955849165372, -0.1570723132534716}, {
            0.461116154533334, -0.12800959438547896`}, {
            0.48544360076945975`, -0.10019085789669492`}, {
            0.5114779236249142, -0.07361610378711939}, {
            0.5136447013008032, -0.07165059457466093}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.2516559522543062, 0.5224836298332386, -0.7066718482432283], 
           
           ArrowBox[{{0.5166073785802896, -0.06896311558169839}, {
            0.5392025116854949, -0.048466807737477725`}, {
            0.5686007535369992, -0.0249244454284952}, {
            0.5996726491794273, -0.002989016860171822}, {0.632418198612779, 
            0.017339477967492415`}, {0.645605062124322, 
            0.02500641243965254}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25728678858981446`, 0.5224735754742016, -0.693214456386675], 
           
           ArrowBox[{{0.6490630733962969, 0.027016924325440585`}, {
            0.65122002156432, 0.028270989042922776`}, {0.6705698734753361, 
            0.03864330629283068}, {0.7050229218109983, 
            0.053105064172271836`}, {0.7412040164942721, 
            0.06579374908994992}, {0.7782960213525978, 0.07755015427218498}, {
            0.798584010242539, 0.08270733568053931}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.27173884844520496`, 0.5224477700360832, -0.658674821238356], 
           
           ArrowBox[{{0.8024607200420041, 0.0836927904642463}, {
            0.8172098465610269, 0.08744199998353397}, {0.8580476977099678, 
            0.09537608502515008}, {0.9009117803898283, 
            0.10125920819818647`}, {0.923132992068846, 
            0.10340536766605751`}, {0.9459194286605793, 
            0.10498620383092416`}, {0.9606541243904957, 
            0.10562698363267427`}}]}}, {
          Arrowheads[{{0.003568279138448952, 1.}}], {
           LABColor[
           0.29501976585962664`, 0.5224061998876276, -0.6030346978609022], 
           
           ArrowBox[{{0.9646503473659084, 0.10580077065976129`}, {
            0.9692710901650279, 0.10600171669278635`}, {0.9931879765821916, 
            0.10645190625164411`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5274015308435889, 0.5303645327251689, 0.21062969404897763`], 
           
           ArrowBox[{{-0.37142236806729656`, -0.9603878284551726}, \
{-0.38991601018930144`, -0.9461443091148745}, {-0.4087206131789608, \
-0.9317118092768757}, {-0.42783617703627463`, -0.9170903289411761}, \
{-0.44726270176124283`, -0.9022798681077757}, {-0.4670541761023224, \
-0.8872652239087392}, {-0.4872645888079704, -0.8720311934761316}, \
{-0.49871480823236586`, -0.8634538508790671}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5775336275958104, 0.5336312280112173, 0.43396943505704494`], 
           
           ArrowBox[{{-0.5019161929486347, -0.8610556982779092}, \
{-0.5078939398781865, -0.8565777768099524}, {-0.5289422293129707, \
-0.8409049739102021}, {-0.5504094571123235, -0.8250127847768808}, \
{-0.5722956232762444, -0.808901209409988}, {-0.5946007278047335, \
-0.792570247809524}, {-0.6173247706977908, -0.7760198999754888}, \
{-0.6307749726379916, -0.7662138702446639}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6329511415712187, 0.5372423303467679, 0.680855841579233], 
           
           ArrowBox[{{-0.63400716396188, -0.7638574027091818}, \
{-0.6393488722652813, -0.7599629667245451}, {-0.661837698295544, \
-0.7436835009894454}, {-0.6847733818035052, -0.7271858803554111}, \
{-0.7082095237443853, -0.7104569720667775}, {-0.7408732895126344, \
-0.6877782952673142}, {-0.76462264145508, -0.6714607847876355}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6796493432529366, 0.45774078850823036`, 0.7517443014811229], 
           
           ArrowBox[{{-0.7679194680241304, -0.6691956281542868}, \
{-0.7745012699026037, -0.6646734575541193}, {-0.8092619980591087, \
-0.6410988983084247}, {-0.8450992962672109, -0.6170691377364865}, \
{-0.8707196398389321, -0.5998857117778212}, {-0.8969967118138364, \
-0.5824442478944002}, {-0.9007388169308661, -0.5799851297842378}}]}}, {
          Arrowheads[{{0.007083858400842509, 1.}}], {
           LABColor[
           0.7272370757934681, 0.34922577963819557`, 0.7782915100806589], 
           
           ArrowBox[{{-0.9040816304607103, -0.5777884054718375}, \
{-0.9239305121919235, -0.5647447460862232}, {-0.9515210409731931, \
-0.54678720635329}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.20152251204397365`, 0.5225731475491875, -0.8264880371409711], 
           
           ArrowBox[{{0.5939820075846389, -0.9705120851751494}, {
            0.5978087635294522, -0.9471949232370406}, {
            0.6030615020355671, -0.9240601173276055}, {
            0.6101071130502075, -0.9008369407063173}, {
            0.6190669317983812, -0.8782031627678839}, {
            0.6299409582800886, -0.8561587835123061}, {
            0.6427291924953292, -0.8347038029395832}, {
            0.6512135195613894, -0.8229715216258072}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.20553563966931776`, 0.5225659817529181, -0.8168968809064968], 
           
           ArrowBox[{{0.6535574808629997, -0.819730249434745}, {
            0.6576373352294376, -0.8140885528365829}, {
            0.6748710872677476, -0.794563364990172}, {
            0.6944304486102593, -0.776128239400351}, {
            0.7163154192569727, -0.7587831760671194}, {
            0.7283705631964249, -0.7499959155271243}, {
            0.7411109177141825, -0.7415820925625529}, {
            0.7691144751601603, -0.7280790965546753}, {
            0.779316720531528, -0.724193800520661}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2247539033925143, 0.522531665833927, -0.7709662783608814], 
           
           ArrowBox[{{0.7830548266939802, -0.7227702267367506}, {
            0.799853388642023, -0.716372871670478}, {
            0.8319902213349648, -0.7056486229855061}, {
            0.8669228924500654, -0.6968883266989848}, {
            0.9047346786856365, -0.6902583060051044}, {
            0.9382882412784288, -0.6866922808848603}}]}}, {
          Arrowheads[{{0.005891627678437179, 1.}}], {
           LABColor[
           0.25454169151958095`, 0.5224784770891469, -0.6997750887256853], 
           
           ArrowBox[{{0.9422658405901216, -0.6862695472623266}, {
            0.9455088567399912, -0.6859248840980557}, {
            0.9670294092911781, -0.6846640160628565}, {
            0.9893356929809927, -0.684066534470892}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2598793567491514, 0.5224689462131916, -0.6870183598290451], 
           
           ArrowBox[{{0.24802605777055142`, -0.46674675879168503`}, {
            0.24737657289547527`, -0.44483084853560995`}, {
            0.2472682667370142, -0.42290406134656516`}, {
            0.2477011392951681, -0.40096639722455024`}, {
            0.24870398773234054`, -0.37905114679434737`}, {
            0.2503056092109349, -0.35719160068073885`}, {
            0.25250600373095144`, -0.3353877588837242}, {
            0.25530517129238994`, -0.31363962140330365`}, {
            0.2563158411432564, -0.30721156154850027`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25979284567337535`, 0.522469100686411, -0.6872251165836871], 
           
           ArrowBox[{{0.2569371201213909, -0.30326010454742736`}, {
            0.25871169197333577`, -0.29197347709814603`}, {
            0.2627341458518741, -0.27041561482692}, {
            0.2673679206305156, -0.24898405662933387`}, {
            0.272608404011771, -0.22769682454509557`}, {
            0.2797458211346699, -0.20212806843956696`}, {
            0.2877255130310039, -0.17682530302843957`}, {
            0.2968098199547051, -0.15097055270665302`}, {
            0.29763525851234357`, -0.14880932040358213`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25935901386574656`, 0.5224698753316849, -0.6882619509520175], 
           
           ArrowBox[{{0.29906242808750905`, -0.14507258559847191`}, {
            0.30652933801518467`, -0.12552209720599522`}, {
            0.31688406721244256`, -0.10047993652646607`}, {
            0.32787400754647866`, -0.07584407066806559}, {
            0.3394991590172932, -0.05161449963079377}, {
            0.3517595216248861, -0.027791223414650654`}, {
            0.3646550953692572, -0.0043742420196362045`}, {
            0.36698551580688327`, -0.00041108875494285085`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25618827557410867`, 0.5224755369668838, -0.6958398426048206], 
           
           ArrowBox[{{0.36901304933562395`, 0.0030369697987700046`}, {
            0.3781858802504068, 0.018636444554249634`}, {0.3989683609116601, 
            0.05152677853625799}, {0.42065397229333434`, 
            0.08322997673002053}, {0.44324271439542956`, 
            0.11374603913553724`}, {0.45988457649171804`, 
            0.13452292465183255`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2502887106537916, 0.5224860711647076, -0.7099394811283609], 
           
           ArrowBox[{{0.4623852211093917, 0.1376449074346326}, {
            0.4667345872179457, 0.14307496575280812`}, {0.491177809290754, 
            0.1711109482650263}, {0.5166205991437254, 0.1977481783553849}, {
            0.5430629567768603, 0.22298665602388404`}, {0.5705048821901585, 
            0.2468263812705236}, {0.5753214064598949, 
            0.25058090548370376`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24648295364304434`, 0.5224928666823028, -0.7190350328995042], 
           
           ArrowBox[{{0.5784761666621905, 0.25304006958274483`}, {
            0.59912866127706, 0.2691388758487712}, {0.629116579931005, 
            0.28979566151209435`}, {0.6604686381519935, 
            0.30879673826049325`}, {0.6931848359400254, 
            0.32614210609396777`}, {0.7119618669265062, 
            0.33542851173810834`}, {0.7144784733163609, 
            0.3365664758776072}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2512191430372648, 0.5224844097949418, -0.7077157984577306], 
           
           ArrowBox[{{0.7181231772471162, 0.33821454543230983`}, {
            0.7312417199469917, 0.3441465144581868}, {0.7686032676948915, 
            0.3566900855898304}, {0.8080613036908293, 0.36709670517245574`}, {
            0.8486596972698564, 0.3763709355331045}, {0.8720888484526642, 
            0.3802009010680866}}]}}, {
          Arrowheads[{{0.013666836766303533`, 1.}}], {
           LABColor[
           0.2690610321192194, 0.522452551515276, -0.6650746562666654], 
           
           ArrowBox[{{0.8760364513372446, 0.3808462160808146}, {
            0.8915388060150625, 0.38338038744980035`}, {0.9138796905294422, 
            0.3860029770953003}, {0.936882877744285, 0.3879936833370808}, {
            0.9605483676595921, 0.389352506175142}, {0.9848761602753622, 
            0.39007944560948365`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.29696246691019257`, 0.5224027310221341, -0.5983917482633905], 
           
           ArrowBox[{{0.13685420723867397`, -0.7053323584118028}, {
            0.12346538136637378`, -0.6789640503604037}, {
            0.11011018444701168`, -0.6521900157399808}, {
            0.09678861648058752, -0.6250102545505338}, {
            0.08377201639609806, -0.5978423970574611}, {
            0.07084333126293496, -0.5702880521305936}, {
            0.06680634955948143, -0.5614939137924863}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.30691207457363084`, 0.5223849651128153, -0.5746127283864491], 
           
           ArrowBox[{{0.06513756691463676, -0.5578586470231466}, {
            0.05801872559971565, -0.5423510029639984}, {
            0.045306281665791585`, -0.5140331411548034}, {
            0.03364562038139971, -0.4875805647448085}, {
            0.022098935028820838`, -0.46080648128250434`}, {
            0.010672635733045657`, -0.43371444786190994`}, {
            0.0013620176095370355`, -0.4111319708543368}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.31555429380868516`, 0.5223695336618036, -0.5539582955763591], 
           
           ArrowBox[{{-0.00016265480949084667`, -0.40743394786702913`}, \
{-0.0006268673809351603, -0.4063080215770443}, {-0.011791166792732035`, \
-0.3785875527157045}, {-0.02281345289827459, -0.3505559570106649}, \
{-0.03368971244705093, -0.3222206397234104}, {-0.04441593218854919, \
-0.2935890061154261}, {-0.056387096664168204`, -0.2604891850693471}, \
{-0.05725932960127535, -0.25798348405393107`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.32296401231365685`, 0.522356302950454, -0.5362494723169529], 
           
           ArrowBox[{{-0.05857433300421344, -0.2542058173070804}, \
{-0.06803247513443905, -0.22703500624110884`}, {-0.07950395556418162, \
-0.19322053337919717`}, {-0.09095342591821581, -0.15903983023209783`}, \
{-0.10237359458857681`, -0.12450773444501276`}, {-0.10961314087989038`, \
-0.10256739019362704`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.33095852149880806`, 0.5223420280433384, -0.5171430312138865], 
           
           ArrowBox[{{-0.1108665308967808, -0.09876883606533567}, \
{-0.11388451362552758`, -0.08962246454577094}, {-0.12582908648122965`, \
-0.054353155606799}, {-0.1385502166078445, -0.01866894270052347}, \
{-0.15242104228156664`, 0.01742312720278133}, {-0.1666100732897821, 
            0.05114119920907957}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3487711058546517, 0.5223102220898672, -0.47457192572057416`], 
           
           ArrowBox[{{-0.16819300349191543`, 
            0.05481415034446798}, {-0.184965253184559, 
            0.09097704484948085}, {-0.20425188174047326`, 
            0.12859161100285704`}, {-0.2147378226091982, 
            0.1476204114461988}, {-0.22579283520301036`, 
            0.16678897025065173`}, {-0.2374798751369378, 
            0.18611844592667756`}, {-0.24360070398438857`, 
            0.1957636279494067}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.38423333798942183`, 0.522246901120673, -0.3898191242697071], 
           
           ArrowBox[{{-0.24574396378727068`, 
            0.19914096971732856`}, {-0.24986189802600856`, 
            0.2056299969847382}, {-0.2630018594852507, 
            0.22534478193529545`}, {-0.27696271512969217`, 
            0.24528395928881117`}, {-0.29180742057436104`, 
            0.2654686875557472}, {-0.30759893143428535`, 
            0.2859201252465652}, {-0.32879204825866026`, 
            0.3119184452513363}, {-0.3417530515582938, 
            0.32694647578742386`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.43854123800879047`, 0.524574240307219, -0.18524512614284758`], 
           
           ArrowBox[{{-0.34436548116003923`, 
            0.32997553695813736`}, {-0.3516158093420064, 
            0.3383821510756062}, {-0.37607021468432367`, 
            0.36531124271937493`}, {-0.4021552642856124, 
            0.3927057201826426}, {-0.4300865096212951, 
            0.42063929284692686`}, {-0.4555792761363922, 
            0.44490249795728926`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.506771155051765, 0.5290202212817109, 0.11872085550551754`], 
           
           ArrowBox[{{-0.4584767143267702, 
            0.4476601875578316}, {-0.46007950216679483`, 
            0.4491856700937456}, {-0.47584915364322605`, 
            0.4636886604356054}, {-0.4921342419221115, 
            0.47834485192309883`}, {-0.5089347670034511, 
            0.49315424455622575`}, {-0.526250728887245, 
            0.5081168383349863}, {-0.5441500635920435, 
            0.5232557714635906}, {-0.5627007071363974, 
            0.5385941821462483}, {-0.5795379169054673, 
            0.5522185614999386}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.58239151019983, 0.5339477761556359, 0.45561142318277137`], 
           
           ArrowBox[{{-0.5826534344527626, 
            0.5547271977832195}, {-0.6017559207437704, 
            0.5698694361737245}, {-0.6222604908067899, 
            0.5858062795185432}, {-0.6434163697093643, 
            0.6019426004174153}, {-0.6652235574514941, 
            0.6182783988703411}, {-0.687682054033179, 
            0.6348136748773204}, {-0.7098962555790499, 
            0.6511822800353397}, {-0.7101532065851278, 
            0.6513682054147558}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6574855084071282, 0.5082813082280636, 0.7393800236387988], 
           
           ArrowBox[{{-0.7133938291320951, 
            0.653713064793927}, {-0.7328224556941914, 
            0.6677712886562458}, {-0.7564414538285156, 
            0.6845742205883238}, {-0.7808108516322848, 
            0.7016105162867171}, {-0.807166427260949, 
            0.7191321615026062}, {-0.8343398780997738, 
            0.7369105119737108}, {-0.8454216747067178, 
            0.7440410414552051}}]}}, {
          Arrowheads[{{0.014996782074038161`, 1.}}], {
           LABColor[
           0.716923599481731, 0.3727437518907253, 0.7725380523633605], 
           
           ArrowBox[{{-0.8487854884354142, 
            0.7462054714491373}, {-0.8624096540878293, 
            0.7549718762380895}, {-0.8913496052454256, 
            0.7733074847830563}, {-0.9203169380228262, 
            0.7916522188201398}, {-0.9502092092093755, 
            0.8102894481220441}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.27105444833679904`, 0.5224489920933416, -0.6603105001849108], 
           
           ArrowBox[{{0.19709430508743975`, -0.12859095867861797`}, {
            0.2050081179196709, -0.0915702657779736}, {
            0.21394503482335528`, -0.05490636953027194}, {
            0.2234979856643148, -0.018694652757876247`}, {
            0.23366697044254944`, 0.017064884539213305`}, {
            0.23652335900284804`, 0.02641596084578271}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.26754146292615166`, 0.5224552648412082, -0.668706343793313], 
           
           ArrowBox[{{0.23769190209671692`, 0.03024146826804336}, {
            0.24445198915805932`, 0.052372242360997044`}, {0.2526493753818725,
             0.07802837218214032}, {0.2608849134237612, 
            0.10340350624554165`}, {0.26909366212316677`, 
            0.12849848502837113`}, {0.277243150899786, 
            0.15331372876914148`}, {0.2868118701314009, 
            0.18251093155782597`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.25927429889913595`, 0.5224700265977916, -0.6884644151036754], 
           
           ArrowBox[{{0.28805532081030794`, 0.18631274856781202`}, {
            0.2980301399153159, 0.21700464523373453`}, {0.3080266661150244, 
            0.24816184452931206`}, {0.31770896738464643`, 
            0.2788798627002088}, {0.32706048600395743`, 
            0.30915184873580637`}, {0.3360349848982806, 
            0.3389444806908207}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24932063875564808`, 0.5224877997431739, -0.7122531201869997], 
           
           ArrowBox[{{0.3371523762877531, 0.3427852384152281}, {
            0.34461006102351277`, 0.3684296556817794}, {0.3526842439607359, 
            0.39751679096697484`}, {0.36080072261479984`, 
            0.42865914684473383`}, {0.36823906535741807`, 
            0.45945513118940806`}, {0.3749992721885904, 0.4899047440009977}, {
            0.3765936786898238, 0.49779626717396386`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.239942815089951, 0.5225045446813151, -0.7346656074822024], 
           
           ArrowBox[{{0.3773858339854256, 0.5017170438811547}, {
            0.38108134310831693`, 0.5200079852795026}, {0.3863646670655192, 
            0.5498450124887924}, {0.39072863300911875`, 0.5794959830927362}, {
            0.39417324093911565`, 0.6089608970913346}, {0.3966984908555099, 
            0.6382397544845871}, {0.39777374101818175`, 
            0.660228246412418}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.23435878133444038`, 0.5225145154701833, -0.7480111437241725], 
           
           ArrowBox[{{0.3979691099160481, 0.664223472437782}, {
            0.3981263950003616, 0.6674398977189478}, {0.39827896561573095`, 
            0.6966686692408706}, {0.39715620270161794`, 0.7259260690503556}, {
            0.3947581062580226, 0.7552120971474027}, {0.3928324648092956, 
            0.7737978528894461}, {0.3903081471655159, 0.7924428095747478}, {
            0.38314512072381557`, 0.8230017972748583}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.23985113728774932`, 0.522504708380184, -0.7348847124313193], 
           
           ArrowBox[{{0.38215990437671127`, 0.8268767105632251}, {
            0.3721068654714511, 0.8597227930845011}, {0.36026757870857234`, 
            0.894003780318667}, {0.34551295411689487`, 0.9290074588414134}, {
            0.3274680816102557, 0.964908432423587}, {0.3217893693910544, 
            0.9745794599365358}}]}}, {
          Arrowheads[{{0.0031848685390807015`, 1.}}], {
           LABColor[
           0.26522670503454265`, 0.522459398047279, -0.6742384889569], 
           
           ArrowBox[{{0.3197639730535708, 0.9780287743142213}, {
            0.3068627309047292, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.31209910070838365`, 0.5223757032163604, -0.5622160187137907], 
           
           ArrowBox[{{0.16988658920223604`, -0.9845108045090915}, {
            0.15092645807183333`, -0.9605663552641864}, {
            0.13164493445396488`, -0.9360768542709066}, {
            0.11202929443731915`, -0.9110320721894226}, {
            0.09206681411058443, -0.8854217796799042}, {
            0.07122858972990492, -0.8585494085383101}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3320305051587878, 0.5223401139211801, -0.5145810487095829], 
           
           ArrowBox[{{0.06877966868745332, -0.8553866934902773}, {
            0.0465019409407002, -0.8265151585030958}, {
            0.02301596691939267, -0.7959641409691015}, \
{-0.0009900636898400568, -0.7646565412557564}, {-0.025526736023937863`, \
-0.7325743690297167}, {-0.028655694607139008`, -0.7284761633226362}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3524774876752404, 0.5223036040155116, -0.46571387523611346`], 
           
           ArrowBox[{{-0.03108306464037542, -0.7252968749239932}, \
{-0.05062678608849781, -0.699699159694939}, {-0.07636171390926688, \
-0.6660116186956556}, {-0.10280301951199206`, -0.6314924514760992}, \
{-0.11628581272034738`, -0.6139193679329537}, {-0.12832168357444643`, \
-0.5982353658414702}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3744469595717707, 0.5222643755696572, -0.4132080351482471], 
           
           ArrowBox[{{-0.13075768687764125`, -0.5950626878173385}, \
{-0.143761051967003, -0.5781445169412753}, {-0.15779874939641658`, \
-0.5599331373651689}, {-0.17206666629062942`, -0.5414993803171684}, \
{-0.1865874283451983, -0.5228384397334871}, {-0.20138366125567975`, \
-0.5039455095503378}, {-0.21647799071763044`, -0.4848157837039338}, \
{-0.22911082392413462`, -0.46886443864364413`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.39972012367212684`, 0.52221924808757, -0.3528065508059095], 
           
           ArrowBox[{{-0.23159420181916557`, -0.46572870360533625`}, \
{-0.23180535099981506`, -0.46546208776511416`}, {-0.24733256416255886`, \
-0.4458908358012177}, {-0.26313008758875966`, -0.4260876044932069}, \
{-0.27926837866131526`, -0.4060379705220442}, {-0.2958178947631232, \
-0.3857275105686924}, {-0.3128490932770812, -0.36514180131411417`}, \
{-0.33043243158608704`, -0.3442664194392719}, {-0.3326464357380314, \
-0.3416908060163783}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4348167895513649, 0.5243315487182529, -0.20183763688482967`], 
           
           ArrowBox[{{-0.33525389990611987`, -0.33865746946859226`}, \
{-0.3486383670730385, -0.32308694162512813`}, {-0.3716414191444128, \
-0.2969790770580079}, {-0.39568554759223296`, -0.27040044458405377`}, \
{-0.420770752416499, -0.2433510442032657}, {-0.44276153072254454`, \
-0.2201870158017927}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.48133336301854956`, 0.5273626501704706, 0.0053948577401506945`], 
           
           
           ArrowBox[{{-0.44551553781007414`, -0.2172860771671717}, \
{-0.4468970336172109, -0.2158308759156437}, {-0.4743023017038073, \
-0.1877899706020157}, {-0.5032244671857271, -0.15917835914320944`}, \
{-0.5182543864499332, -0.14465853860936448`}, {-0.5336635300629701, \
-0.12999604153922503`}, {-0.5494518980248377, -0.11519086793279104`}, \
{-0.5599437645527066, -0.10549054610612588`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5400829508165246, 0.5311908762761028, 0.26712573622268737`], 
           
           ArrowBox[{{-0.5628808117619556, -0.10277508045717315`}, \
{-0.5656194903355363, -0.1002430177900625}, {-0.5822379405011354, \
-0.08513507285916166}, {-0.5993788820277048, -0.06984961488821084}, \
{-0.6170423149152447, -0.05438664387720995}, {-0.6352282391637549, \
-0.03874615982615901}, {-0.6539366547732356, -0.02292816273505804}, \
{-0.6731675617436867, -0.006932652603907066}, {-0.6838989075828779, 
            0.0018535978429000226`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6086844418397277, 0.5356610696623682, 0.5727470892176717], 
           ArrowBox[{{-0.6869938802668686, 
            0.004387595491942227}, {-0.6929209600751081, 
            0.009240370567293934}, {-0.7131968497674999, 
            0.025590906778544975`}, {-0.7317514609710805, 
            0.04056187956811458}, {-0.7508089225929625, 
            0.055698118138920547`}, {-0.7703545195393751, 
            0.07099548191918098}, {-0.7904323970916304, 
            0.08646639262424159}, {-0.8129804510159523, 
            0.10297794848100889`}}]}}, {
          Arrowheads[{{0.01306821138426105, 1.}}], {
           LABColor[0.6725175744939521, 0.4740034660686938, 0.7477657855313], 
           
           
           ArrowBox[{{-0.8162076867576697, 
            0.1053411982493113}, {-0.8168507243457532, 
            0.10581208372303233`}, {-0.844141146725096, 
            0.1254404655854782}, {-0.872407878515662, 
            0.14538292234105463`}, {-0.9016161816221173, 
            0.16562899261326985`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2866513827609376, 0.522421142379865, -0.6230346772342419], 
           
           ArrowBox[{{0.1044280643507825, -0.3569635151914612}, {
            0.10056361994476788`, -0.33397790648281517`}, {
            0.09712382526055491, -0.3109106173585455}, {
            0.09410868029814362, -0.2877616478186522}, {
            0.09151818505753395, -0.2645309978631352}, {
            0.08935233953872593, -0.24121866749199433`}, {
            0.08761114374171959, -0.21782465670522996`}, {
            0.0866297237975849, -0.19807015633000677`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.28735434977795665`, 0.5224198871697401, -0.6213546243883437], 
           
           ArrowBox[{{0.08643124527368554, -0.19407508358028736`}, {
            0.08637098270014427, -0.1928620890423758}, {
            0.08571169083498055, -0.16787352189187532`}, {
            0.08564096526006082, -0.1428800757353731}, {
            0.08616265453230021, -0.11789231081378197`}, {
            0.08737156848244923, -0.09033182935142267}, {
            0.08927661449277867, -0.06282956232755767}, {
            0.09169264799485358, -0.035388840579293104`}, {
            0.09180221840826985, -0.034294851551874915`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2869291919355867, 0.5224206463268777, -0.6223707284525977], 
           
           ArrowBox[{{0.09220085108164867, -0.030314764619191803`}, {
            0.09443452442023899, -0.008012994943735356}, {0.09724816497723883,
             0.01928033220047275}, {0.09993463825276591, 
            0.046484947707917765`}, {0.1023915207462987, 
            0.07361469459133729}, {0.10451638895731562`, 
            0.10068341586346928`}, {0.10619305579678598`, 
            0.12905289149645915`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.28398190885794544`, 0.5224259089629198, -0.6294145743264145], 
           
           ArrowBox[{{0.10642904834919911`, 0.13304592386737796`}, {
            0.10643032655146178`, 0.1330675512575615}, {0.10749105583241247`, 
            0.16539785802121063`}, {0.10760007902759723`, 
            0.19771295597247313`}, {0.10665889836444559`, 
            0.2300514649294057}, {0.10459656778243825`, 
            0.26243625966537176`}, {0.10153283554769554`, 
            0.29279481098852256`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2858983477861712, 0.5224224869907812, -0.6248343897695214], 
           
           ArrowBox[{{0.10105604980460814`, 0.29676548109511974`}, {
            0.09669793474434404, 0.32750863277344594`}, {0.09059851263419356, 
            0.36031123888893096`}, {0.08302321273856664, 
            0.39331740329820064`}, {0.07386706303935847, 
            0.4265744918910571}, {0.0653827320459198, 
            0.45244458633275175`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.30074752654675174`, 0.5223959724615411, -0.5893456620881646], 
           
           ArrowBox[{{0.06413621990488531, 0.45624540301897243`}, {
            0.06283897685597536, 0.46020090643050665`}, {0.0496478675078237, 
            0.4943150486795555}, {0.04000102675262485, 0.5163215605563597}, {
            0.029339876976744075`, 0.5385846904345437}, {
            0.017664418180181423`, 0.561104438314108}, {0.004974650362936834, 
            0.5838808041950521}, {-0.0048512314582956125`, 
            0.6002712326488051}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.33266064007762813`, 0.5223389887592434, -0.5130750606076278], 
           
           ArrowBox[{{-0.006907925322443047, 
            0.6037019775167861}, {-0.008865547954141456, 
            0.6069674629223776}, {-0.023992298250205227`, 
            0.6304180893410855}, {-0.040405600525254486`, 
            0.6542326834511759}, {-0.05810545477928925, 
            0.6784112452526491}, {-0.07727245744659962, 
            0.7030219017522803}, {-0.09808720496147563, 
            0.7281327799568448}, {-0.10177246949475563`, 
            0.7323346145810639}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3796677001724838, 0.5222550534730251, -0.4007307497400092], 
           
           ArrowBox[{{-0.10440999615374583`, 
            0.7353418480477432}, {-0.12054969732391736`, 
            0.753743879866343}, {-0.14465993453392478`, 
            0.7798552014807746}, {-0.1704596324151893, 
            0.8071317717434502}, {-0.19824653366181771`, 
            0.8350232838800123}, {-0.2153115865476128, 
            0.8505433202507287}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4413759601578798, 0.5247589557705968, -0.17261636828864146`], 
           
           ArrowBox[{{-0.2182707985349947, 
            0.8532346144400984}, {-0.229332984303671, 
            0.8632952645077221}, {-0.2457725240034014, 
            0.8777199034117042}, {-0.26280960662233427`, 
            0.8923369747091043}, {-0.2798692330886276, 
            0.9069616291679147}, {-0.29757149016884427`, 
            0.921793882342963}, {-0.3159163778629844, 
            0.9368337342342495}, {-0.3349038961710477, 
            0.9520811848417741}, {-0.3404769041097975, 
            0.9564632337729496}}]}}, {
          Arrowheads[{{0.004961756610391509, 1.}}], {
           LABColor[
           0.5139960220745233, 0.529491006279239, 0.15090781823432203`], 
           
           ArrowBox[{{-0.34362128452626933`, 
            0.958935656025824}, {-0.35457921099409895`, 
            0.9675518594287257}, {-0.3749874882332025, 
            0.9832613832582936}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3079946066344536, 0.5223830321555492, -0.5720255357792146], 
           
           ArrowBox[{{0.01311537175729751, -0.3410387937801206}, {
            0.004676918546016768, -0.31384111700156914`}, \
{-0.004438062045990642, -0.28333750229055604`}, {-0.013146294306604647`, \
-0.25256473297523657`}, {-0.02143981611522664, -0.2215383285482478}, \
{-0.02931066535125809, -0.1902738085022263}, {-0.030059553830307905`, \
-0.18700858682148203`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3121374587764534, 0.5223756347246186, -0.5621243450223321], 
           
           ArrowBox[{{-0.030953748767091765`, -0.18310981580806893`}, \
{-0.03652849052447046, -0.15880343620687787`}, {-0.04304085164033912, \
-0.12714607993025323`}, {-0.04910665382182152, -0.09529716651250664}, \
{-0.05498480219187497, -0.06325212279379261}, {-0.0609098747258708, \
-0.031047807395485877`}, {-0.06185378227422702, -0.026141463723312407`}}]}}, {
         
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3154838672577349, 0.5223696594146734, -0.5541266111935733], 
           
           ArrowBox[{{-0.06260946515878392, -0.0222134943525067}, \
{-0.06713883580204928, 0.001329753111943735}, {-0.07395605336498531, 
            0.03391693647122138}, {-0.08164589535925382, 
            0.06675012042507222}, {-0.09059006629404874, 
            0.0998478670097292}, {-0.10100783932060767`, 
            0.13297410186306047`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.329858424604383, 0.5223439923641768, -0.5197722028158204], 
           
           ArrowBox[{{-0.1023589504351693, 
            0.13673874922698764`}, {-0.11332046482474613`, 
            0.16699324846625774`}, {-0.1274418205547126, 
            0.20115639651916092`}, {-0.1435630709660519, 
            0.23576553518992652`}, {-0.16183958778224639`, 
            0.2708734897918868}, {-0.16840211851241224`, 
            0.2822046645353481}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.361447524379262, 0.5222875872172557, -0.44427597654734113`], 
           
           ArrowBox[{{-0.1704068073864072, 
            0.28566605479339197`}, {-0.18251208913162617`, 
            0.3065676045786593}, {-0.2058212931425213, 
            0.3429352238038615}, {-0.2184792249587772, 
            0.36137831025670814`}, {-0.23178734302557794`, 
            0.37998884661776156`}, {-0.24580882334661736`, 
            0.39878897768422633`}, {-0.2605185886054787, 
            0.4176874641072958}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.40880132875870245`, 0.5226363356982229, -0.31773716337693236`], 
           
           ArrowBox[{{-0.26303865958149875`, 
            0.42079374798938585`}, {-0.27624457476618786`, 
            0.43704660312220855`}, {-0.29278519787210655`, 
            0.4565483870881351}, {-0.31029188724703943`, 
            0.4763283449482915}, {-0.32882781889468027`, 
            0.4964086214998824}, {-0.35377276824495624`, 
            0.52219842130484}, {-0.37077662710642134`, 
            0.5389432297645798}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4742991031880887, 0.5269042854716515, -0.025942945194432483`], 
           
           ArrowBox[{{-0.37362668091174095`, 
            0.5417498635680502}, {-0.3804998339407535, 
            0.5485183054801457}, {-0.40900901598207196`, 
            0.5753682740257996}, {-0.43930031436891165`, 
            0.6027483269418016}, {-0.4551706357887605, 
            0.616656648432171}, {-0.4715992434887064, 
            0.6307365178021034}, {-0.4885861374687497, 
            0.6449879350515983}, {-0.4927940883815338, 
            0.6484470690348355}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5480179353353711, 0.5317079337742301, 0.30247629010239657`], 
           
           ArrowBox[{{-0.49588405571782207`, 
            0.6509871678243851}, {-0.5061313177288901, 
            0.6594109001806563}, {-0.5242347842691277, 
            0.6740054131892769}, {-0.5428965370894627, 
            0.6887714740774604}, {-0.5621165761898947, 
            0.7037090828452068}, {-0.5818949015704241, 
            0.718818239492516}, {-0.6023029919866428, 
            0.734123291229318}, {-0.622396856116579, 0.7489017369100142}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6270330745443002, 0.5368566987272706, 0.6544907054152092], 
           
           ArrowBox[{{-0.6256334656939068, 
            0.7512520747605033}, {-0.6452229041929248, 
            0.7653941216011895}, {-0.667734725982988, 
            0.781359900236259}, {-0.6909477915643328, 
            0.7975459211707514}, {-0.7148621009369592, 
            0.8139521844046663}, {-0.739477654100867, 
            0.8305786899380037}, {-0.7571569571100709, 
            0.8423431623624652}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6908828679518012, 0.4321248163393355, 0.7580110157700377], 
           
           ArrowBox[{{-0.7604870461595095, 
            0.8445591287256597}, {-0.7647944510560563, 
            0.8474254377707637}, {-0.7898155083203635, 
            0.8640868590989086}, {-0.8156005520899137, 
            0.8809898722683704}, {-0.8421293583094275, 
            0.8981276851606861}, {-0.8694625991447418, 
            0.9155206741312437}, {-0.895040219038534, 0.931107910389462}}]}}, {
          Arrowheads[{{0.013582797488878275`, 1.}}], {
           LABColor[
           0.7512202676529266, 0.2945365532678435, 0.7916707312199192], 
           
           ArrowBox[{{-0.8984559303493883, 
            0.9331894762041558}, {-0.8987306601201213, 
            0.933356899047304}, {-0.9288624970923174, 
            0.9514690774490867}, {-0.9599383828958987, 
            0.9698840235701013}, {-0.9919315599193428, 
            0.9885927993325115}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25716326851684657`, 0.5224737960302768, -0.6935096626269269], 
           
           ArrowBox[{{0.34211926794469216`, 0.0858665799749416}, {
            0.35481162199693383`, 0.11041525111145079`}, {
            0.36773435967405665`, 0.13447749261909459`}, {
            0.38087122491157344`, 0.1580475291970576}, {0.3942560663237433, 
            0.18145620385279207`}, {0.4077414738549121, 0.2043861693967132}, {
            0.4204554927127377, 0.22533027504615832`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.24803247419006827`, 0.5224900998755645, -0.7153317632698073], 
           
           ArrowBox[{{0.422561402829929, 0.22873088775151415`}, {
            0.43514384333150113`, 0.24874085246056782`}, {
            0.44912573330554884`, 0.27013100963622766`}, {0.4633380454558501, 
            0.29097333701152645`}, {0.47781324379671875`, 
            0.3112505544143276}, {0.4925837923424685, 0.3309453816724941}, {
            0.5135228827146263, 0.3571781798159907}, {0.5151421658296398, 
            0.35906260933011747`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.23886822671149974`, 0.5225064634544299, -0.7372338151216474], 
           
           ArrowBox[{{0.5177490952857462, 0.362096405435805}, {
            0.5350757824902377, 0.3822602177101739}, {0.5572424916693028, 
            0.4061914953550436}, {0.5800230102518217, 0.4289720127505999}, {
            0.6035972262274176, 0.4505142812483714}, {0.6281450275857141, 
            0.4707308121998867}, {0.6320371317008919, 
            0.4736117267637288}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.234017518824481, 0.5225151248247439, -0.7488267425178213], 
           
           ArrowBox[{{0.6352522000650622, 0.4759915031006377}, {
            0.653666414326711, 0.48962160560514595`}, {0.6801613864504084, 
            0.507186661464149}, {0.7078743090133183, 0.5232967233301381}, {
            0.7370495470719528, 0.5378225347563552}, {0.767687100626312, 
            0.5507640957428006}, {0.7746597365464103, 
            0.5532310961953536}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.24089743067764222`, 0.5225028401302877, -0.7323841282719256], 
           
           ArrowBox[{{0.7784306664453936, 0.5545652954671845}, {
            0.7997869696763957, 0.562121406289474}, {0.8188047872626772, 
            0.5682414331941054}, {0.8384016913578604, 0.573779999598639}, {
            0.8770269498724456, 0.5805569119086375}, {0.9181430781379537, 
            0.5850723424671825}, {0.9345184611591444, 
            0.5863474769740037}}]}}, {
          Arrowheads[{{0.0027719681210995766`, 1.}}], {
           LABColor[
           0.2633033080745992, 0.5224628324436021, -0.6788353028302561], 
           
           ArrowBox[{{0.9385063888737932, 0.5866580128700543}, {
            0.9606152058623052, 0.5883796040786728}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.24591188255652827`, 0.5224938863805141, -0.7203998616622818], 
           
           ArrowBox[{{0.378213110735377, 0.3350796104430537}, {
            0.38744114786724965`, 0.35787560975210314`}, {
            0.39651984592895184`, 0.3803484478612816}, {0.40544920492048364`, 
            0.4024981247705891}, {0.414229224841845, 0.4243246404800255}, {
            0.42285990569303594`, 0.445827994989591}, {0.43134124747405644`, 
            0.46700818829928553`}, {0.43793556083261953`, 
            0.483515360732473}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.23449175576545278`, 0.522514278032511, -0.7476933420836326], 
           
           ArrowBox[{{0.43941946369150714`, 0.48722993100444056`}, {
            0.4396732501849066, 0.487865220409109}, {0.44785591382558626`, 
            0.5083990913190615}, {0.46371695073033325`, 0.5485970485254343}, {
            0.47886808502219613`, 0.5877017589044848}, {0.49330931670117517`, 
            0.6257132224562131}, {0.4972827939654779, 
            0.6363963612905478}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.22283549611133768`, 0.5225350913207348, -0.7755511671740152], 
           
           ArrowBox[{{0.4986772219794712, 0.6401454372452052}, {
            0.50704064576727, 0.662631439180619}, {0.514725170220188, 
            0.6838114660789264}, {0.5220965289911271, 0.7047101724460176}, {
            0.5358997494870689, 0.7456636235865524}, {0.5484503072550951, 
            0.7854917926022229}, {0.5502273210346091, 
            0.7915792596098168}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.21161381617340497`, 0.5225551286282273, -0.8023703704353993], 
           
           ArrowBox[{{0.5513481944649079, 0.7954190047515222}, {
            0.5597482022952059, 0.8241946794930294}, {0.5635867466006109, 
            0.8379136646271768}, {0.5672433227670847, 0.8515130486697577}, {
            0.5724260758889901, 0.8753007579739647}, {0.5769125338904844, 
            0.8988102801026557}, {0.5804913472288882, 0.9221891423086925}, {
            0.5832329657517616, 0.9453881688411214}, {0.5839569193736118, 
            0.9517509926667581}}]}}, {
          Arrowheads[{{0.004532462335026259, 1.}}], {
           LABColor[
           0.20309206573498179`, 0.5225703449714891, -0.8227368893893309], 
           
           ArrowBox[{{0.5844091164809347, 0.9557253501967407}, {
            0.5858793153500284, 0.9686469188032851}, {0.5874979322835507, 
            0.99184527995131}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.23805377350088883`, 0.5225079177330682, -0.7391803138921591], 
           
           ArrowBox[{{0.3807898193083796, -0.7489203829537388}, {
            0.3766434019087714, -0.7079929586724193}, {
            0.37457056297045976`, -0.6668686044178628}, {
            0.37476902507358867`, -0.6256850003117754}, {
            0.3772822757910707, -0.5892691949191127}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23822353309290228`, 0.5225076146122196, -0.7387745977223023], 
           
           ArrowBox[{{0.377557682200674, -0.5852786872685061}, {
            0.3776058420293916, -0.5845808742973898}, {
            0.383121420279984, -0.543765105399775}, {
            0.3881152218510592, -0.5171776714633456}, {
            0.3943796773062984, -0.49083378830191593`}, {
            0.40193585003167637`, -0.46479137989471236`}, {
            0.41080480341316766`, -0.4391083702209616}, {
            0.41443823819717085`, -0.4301196949790781}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23907093825399156`, 0.5225061014949431, -0.7367493455866414], 
           
           ArrowBox[{{0.41593729383386624`, -0.42641121386168085`}, {
            0.42102925867953345`, -0.4138143128405588}, {
            0.4326346107853055, -0.38896145764886425`}, {
            0.4456159337051145, -0.3646417731283019}, {
            0.4599683014135912, -0.34094722776129605`}, {
            0.4780655288414295, -0.31473787596173375`}, {
            0.49780747840106304`, -0.289726681452979}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.24335453442233954`, 0.5224984527530371, -0.726511784279954], 
           
           ArrowBox[{{0.5004671262207709, -0.2867395408406558}, {
            0.5196024177963665, -0.2653964074280786}, {
            0.5430420793234653, -0.24226429069398558`}, {
            0.5682571609331482, -0.22033440004687968`}, {
            0.5952422713415784, -0.19978321655192477`}, {
            0.6210896421259142, -0.18254949351842098`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2521107944240224, 0.5224828176720947, -0.7055848002549647], 
           
           ArrowBox[{{0.6244338384446778, -0.18035633711306343`}, {
            0.6545225785546828, -0.16281697101846795`}, {
            0.6868825182330842, -0.1465844931606386}, {
            0.7211419724576884, -0.13209589081630524`}, {
            0.7573009412284957, -0.11935116398546797`}, {
            0.7702055968473903, -0.11562105743911744`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2676771580680736, 0.5224550225454646, -0.6683820398020287], 
           
           ArrowBox[{{0.7740482872034333, -0.11451032307502583`}, {
            0.7953594245455058, -0.10835031266812674`}, {
            0.8189750942928026, -0.10221824739352624`}, {
            0.8433282258086446, -0.09679391512410061}, {
            0.8826706105376307, -0.09153260241524688}, {
            0.9238840526572105, -0.0881181369200195}, {
            0.9312920478211079, -0.08768854027265345}}]}}, {
          Arrowheads[{{0.0038548211501910896`, 1.}}], {
           LABColor[
           0.2906117356867666, 0.5224140708175149, -0.6135696496544059], 
           
           ArrowBox[{{0.9352853388382221, -0.08745696554899951}, {
            0.9660721841815014, -0.08567160726381781}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4328936398781561, 0.5242062329150282, -0.2104053166301452], 
           
           ArrowBox[{{-0.16932679781793666`, -0.9485798470158647}, \
{-0.18805843383442558`, -0.9317537644978406}, {-0.20707647748057523`, \
-0.9146749008837436}, {-0.2264206384709774, -0.8973323736049424}, \
{-0.24613062652022405`, -0.879715300092806}, {-0.266246151342907, \
-0.8618127977787035}, {-0.2868069226536184, -0.8436139840940042}, \
{-0.2886525422943551, -0.8419910869467943}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4729642151511612, 0.5268173018276361, -0.03188990468259586], 
           
           ArrowBox[{{-0.2916564036110868, -0.8393497204084579}, \
{-0.3078526501669499, -0.8251079764700763}, {-0.3294230435974935, \
-0.8062838923382891}, {-0.35925867863488875`, -0.7804986504907767}, \
{-0.39012041947531545`, -0.7541125740948756}, {-0.4128414529431631, \
-0.7348836022042691}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5180527682222377, 0.5297553509680903, 0.1689807234719402], 
           
           ArrowBox[{{-0.4158947673369786, -0.7322995605613154}, \
{-0.4220082661187737, -0.7271256631505859}, {-0.4549222185652635, \
-0.6995379176579075}, {-0.47181043418160906`, -0.6855069457357668}, \
{-0.4890480756826402, -0.6713021927362167}, {-0.5066351430683568, \
-0.656923658659258}, {-0.5245716363387589, -0.64237134350489}, \
{-0.5393211223879696, -0.6304932230184229}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5692753022988741, 0.5330931010613016, 0.3971783899488753], 
           
           ArrowBox[{{-0.5424364898581113, -0.6279843416888294}, \
{-0.5428575554938465, -0.6276452472731131}, {-0.5614929005336198, \
-0.6127453699639274}, {-0.5804776714580784, -0.5976717115773325}, \
{-0.5998118682672227, -0.5824242721133285}, {-0.6195619737733452, \
-0.5669869394954914}, {-0.6397944707887387, -0.5513436016473969}, \
{-0.6605093593134033, -0.535494258569045}, {-0.6684892302665046, \
-0.5294501053850192}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6274344636877489, 0.5368828539473336, 0.6562789040573752], 
           
           ArrowBox[{{-0.6716778303327526, -0.5270349802086519}, \
{-0.6817066393473389, -0.5194389102604355}, {-0.7033863108905456, \
-0.5031775567215688}, {-0.7255483739430232, -0.4867101979524446}, \
{-0.7481928285047719, -0.470036833953063}, {-0.7713196745757915, \
-0.453157464723424}, {-0.7935668497684311, -0.436902803970442}, \
{-0.8003770448490917, -0.43197957397524495`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6785226218971133, 0.4603100678454434, 0.7511157506914606], 
           
           ArrowBox[{{-0.8036186869488798, -0.42963612427514875`}, \
{-0.8163391697865856, -0.42044022578498297`}, {-0.8396179085946412, \
-0.40377428250150843`}, {-0.8634592442994397, -0.38689131711663344`}, \
{-0.8953397694198718, -0.3651407389725345}, {-0.9281998348238478, \
-0.3430232287860814}, {-0.9350821963186653, -0.3384619590122379}}]}}, {
          Arrowheads[{{0.008799786335772556, 1.}}], {
           LABColor[
           0.72894254930523, 0.34533676321786433`, 0.7792429225279565], 
           
           ArrowBox[{{-0.9384164158681394, -0.3362522124213582}, \
{-0.9621840142638132, -0.3205002894454042}, {-0.9972441164889528, \
-0.2975847533211264}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2623311785901752, 0.5224645682672496, -0.6811586392988914], 
           
           ArrowBox[{{0.2566645283395399, 0.1974479603953517}, {
            0.26417670943326765`, 0.22761612545798587`}, {
            0.27125831287404834`, 0.2574903750750265}, {0.2778639253161549, 
            0.28709041173593375`}, {0.2839442464363784, 0.3164326920643496}, {
            0.28945308549349547`, 0.3455362693765707}, {0.2908392083293407, 
            0.35371396510281494`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.2541391847839358, 0.5224791958007189, -0.7007370578797734], 
           
           ArrowBox[{{0.29150767533672767`, 0.35765771355575093`}, {
            0.2943496935147574, 0.3744247412010395}, {0.29859332152741563`, 
            0.4031217050661983}, {0.3032311158441622, 0.44067175326286917`}, {
            0.30666192329877784`, 0.4779370643727993}, {0.30861040471022294`, 
            0.5150623084042805}, {0.30861837114679436`, 
            0.516612452419894}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.24949072544013248`, 0.5224874960382728, -0.71184662228397], 
           
           ArrowBox[{{0.3086389275113454, 0.5206123995990297}, {
            0.3088012208974573, 0.5521921553656036}, {0.3079226627133661, 
            0.5752499398200289}, {0.3062527649310641, 0.598375439189371}, {
            0.3037915275505516, 0.6215686534736304}, {0.30053895057182844`, 
            0.6448295826728068}, {0.2963715400882316, 0.6682204489624302}, {
            0.2938733555297728, 0.6795377206867346}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25508866893084065`, 0.5224775004123353, -0.6984678425332169], 
           
           ArrowBox[{{0.29301114834254277`, 0.683443690318758}, {
            0.29116580219309757`, 0.6918034745180304}, {0.2849217368864267, 
            0.7155786593396075}, {0.2776393441682188, 0.7395460034271614}, {
            0.26914458473407227`, 0.763787040875191}, {0.2592634192795854, 
            0.788383305778195}, {0.24799584780475836`, 0.8133347981361739}, {
            0.23805060460034727`, 0.8332243137720148}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2782692652355056, 0.5224361093961429, -0.6430674811387154], 
           
           ArrowBox[{{0.23626168037065057`, 0.8368019876113137}, {
            0.23534187030959103`, 0.8386415179491272}, {0.2236261419119362, 
            0.8610108513102556}, {0.21068225848506353`, 0.8837230588244535}, {
            0.19155596566537844`, 0.9119149156880905}, {0.17008635087334806`, 
            0.9408550025451177}, {0.1477546291998935, 
            0.9696605661540126}}]}}, {
          Arrowheads[{{0.004448250163023297, 1.}}], {
           LABColor[
           0.3189690819403031, 0.5223634362539116, -0.5457971381112591], 
           
           ArrowBox[{{0.1452043855016857, 0.9727416015961663}, {
            0.12232768982072198`, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25476071693499136`, 0.5224780859997892, -0.6992516299238132], 
           
           ArrowBox[{{0.3081842788401342, -0.26712022680593805`}, {
            0.32207758453375385`, -0.22635737783575838`}, {
            0.33840104552451644`, -0.18650649136385153`}, {
            0.3517121851360459, -0.15784281323016147`}, {
            0.3661781524994382, -0.12979227608979071`}, {
            0.3714676548033361, -0.12048494447983826`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.25439733759091626`, 0.5224787348459241, -0.7001200867452197], 
           
           ArrowBox[{{0.3734440442833535, -0.11700731818834623`}, {
            0.38174722683732576`, -0.10239715847807576`}, {
            0.3983676873723414, -0.07569973893035306}, {
            0.4159314598467641, -0.049724729570566825`}, {
            0.4343755527871559, -0.024510895651775128`}, {
            0.4537158695925735, -0.00012159540298515843`}, {
            0.4654823237582082, 0.013532472383925201`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2523583542241979, 0.5224823756320556, -0.704993145829159], 
           
           ArrowBox[{{0.4680935355492214, 0.01656258343510361}, {
            0.4739683136620735, 0.023379812946795857`}, {0.4977763185084925, 
            0.0486144076311783}, {0.5226959688041075, 0.07259952932565475}, {
            0.5487272645489188, 0.09533517803022513}, {0.5758702057429262, 
            0.1168213537448895}, {0.5860996634674975, 
            0.12407551723222465`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25220644166643613`, 0.5224826468854373, -0.7053562085601496], 
           
           ArrowBox[{{0.5893625125531436, 0.12638934865311469`}, {
            0.6042346364176603, 0.13693583320996086`}, {0.6339304006046516, 
            0.1555563931657522}, {0.6649574983038997, 0.17268303361226356`}, {
            0.697315929515405, 0.1883157545494949}, {0.7299813410232753, 
            0.20180275411242754`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2602310612944856, 0.5224683182134482, -0.6861778051401356], 
           
           ArrowBox[{{0.733736890160381, 0.20317479953949968`}, {
            0.7667885174650482, 0.2144984868118318}, {0.8040931054506516, 
            0.22489826036586605`}, {0.8431098894434428, 
            0.23350363886847741`}, {0.8674966936471368, 
            0.23821806859711706`}, {0.888773349672675, 
            0.24159191169385852`}}]}}, {
          Arrowheads[{{0.010712373274131477`, 1.}}], {
           LABColor[
           0.2793170181645193, 0.5224342385401096, -0.6405634087603951], 
           
           ArrowBox[{{0.8927251565987525, 0.2422082587692512}, {
            0.934409789077636, 0.24524240139596176`}, {0.9560938770127554, 
            0.24600167374338394`}, {0.9782991546699819, 
            0.2462528358840205}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.31284803827739915`, 0.5223743659217267, -0.560426098754871], 
           
           ArrowBox[{{0.1345366616794401, -0.8786704459968757}, {
            0.11782922421984215`, -0.8552618049182278}, {
            0.10090713648673134`, -0.8314019947020574}, {
            0.08376847140905296, -0.8070854293893872}, {
            0.06640833274458267, -0.782306123195029}, {
            0.04881662820154997, -0.7570573906379281}, {
            0.04242915633763882, -0.7478433841459791}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.330437816781733, 0.5223429578079178, -0.5183874870996039], 
           
           ArrowBox[{{0.04015025614869208, -0.7445560426777378}, {
            0.030983265488184326`, -0.7313325462370293}, {
            0.008996815830930049, -0.6994267693274769}, \
{-0.013356804930684984`, -0.6667994885157923}, {-0.03613076933434375, \
-0.6334335238369772}, {-0.0503278042239619, -0.6125956189238035}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.34846605581093226`, 0.5223107667838488, -0.47530097869416243`], 
           
           ArrowBox[{{-0.0525800004770856, -0.6092899250424202}, \
{-0.05937824991772922, -0.5993116953260335}, {-0.08309374317408855, \
-0.5644200083639153}, {-0.10731868643221759`, -0.5287419200548147}, \
{-0.11966082174663505`, -0.5106014121513522}, {-0.13217666348312226`, \
-0.4922564280185913}, {-0.14260931653849315`, -0.47702246248862096`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3678257906442886, 0.5222761982556091, -0.4290322679080719], 
           
           ArrowBox[{{-0.14486944105526753`, -0.4737221841414697}, \
{-0.14488165961555488`, -0.4737043423590146}, {-0.15779125811780853`, \
-0.4549425298751045}, {-0.17087430149070698`, -0.4359766314972067}, \
{-0.18411657967982017`, -0.41680928225462577`}, {-0.19755896182614302`, \
-0.3974333479982822}, {-0.21124231707067068`, -0.3778416945790969}, \
{-0.2252075145543982, -0.3580271878479902}, {-0.2363206797602559, \
-0.3424365386111926}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3913012939786276, 0.5222342806566888, -0.3729270947905676], 
           
           ArrowBox[{{-0.23864244784667296`, -0.3391793323001194}, \
{-0.23949542341832067`, -0.3379826936558827}, {-0.25414691280343316`, \
-0.3177010778536949}, {-0.26920285185073073`, -0.2971752062923476}, \
{-0.28460664057936036`, -0.27642341326035375`}, {-0.3003371223255047, \
-0.25545477179619286`}, {-0.31648833120571224`, -0.23424825587573497`}, \
{-0.3331543013365317, -0.21278283947485027`}, {-0.33450097276224944`, \
-0.21108765976681795`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.42565481681464823`, 0.5237345385174256, -0.24265445386846424`], 
           
           ArrowBox[{{-0.3369890670365757, -0.20795566569241986`}, \
{-0.3504290668345116, -0.1910374965694089}, {-0.3684066618162006, \
-0.168991201135281}, {-0.3871811203981471, -0.14662292714833666`}, \
{-0.4068464766968999, -0.12391164858444606`}, {-0.43117931058970993`, \
-0.09681778425341811}, {-0.44092594447352923`, -0.08637528674885668}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.47504207515812746`, 0.5269526988273542, -0.02263298654289528], 
           
           ArrowBox[{{-0.4436552628029934, -0.08345110798269839}, \
{-0.4569388482876643, -0.06921913723989788}, {-0.48412508979076324`, \
-0.04111570754388536}, {-0.5127380350990065, -0.01250749516538062}, \
{-0.5276447319973323, 0.0020022393954126512`}, {-0.5430385254814942, 
            0.016670839358041693`}, {-0.55685572961236, 
            0.02957150895408648}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5373199969501137, 0.5310108373598056, 0.25481670785725963`], 
           
           ArrowBox[{{-0.559787249396397, 
            0.03229288290267007}, {-0.5752874022073262, 
            0.046484635488806894`}, {-0.5921424854489963, 
            0.061629831656943045`}, {-0.6094846652765026, 
            0.07693389322691496}, {-0.6273139416898449, 
            0.09239682019872258}, {-0.6456303146890233, 
            0.10801861257236592`}, {-0.6645085480479014, 
            0.12382083268299658`}, {-0.680670603923552, 
            0.13707539727921597`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6089380850056536, 0.5356775974955956, 0.5738770758461256], 
           
           ArrowBox[{{-0.6837635175586667, 
            0.1396119077258181}, {-0.6840234055403427, 
            0.13982504286576616`}, {-0.7041748871663474, 
            0.15603124312067468`}, {-0.7249629929259152, 
            0.17243943344772208`}, {-0.7463877228190461, 
            0.18904961384690844`}, {-0.7684490768457406, 
            0.2058617843182337}, {-0.7911470550059981, 
            0.2228759448616979}, {-0.810545951311935, 
            0.2371883516631592}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6746321621255115, 0.4691815406827825, 0.7489454256603857], 
           
           ArrowBox[{{-0.8137647094611451, 
            0.23956313501683457`}, {-0.8144816572998189, 
            0.240092095477301}, {-0.8363555917298846, 
            0.25623803858294475`}, {-0.8588594415924363, 
            0.2725826605965749}, {-0.881976349947684, 
            0.2891206827347438}, {-0.9057568876149966, 
            0.30586794134779416`}, {-0.9374706725740053, 
            0.3270898715471861}, {-0.9445232935115185, 
            0.33172554152268036`}}]}}, {
          Arrowheads[{{0.0077735218057738385`, 1.}}], {
           LABColor[
           0.7327551704951688, 0.3366427868471282, 0.7813698246650589], 
           
           ArrowBox[{{-0.9478658782053406, 
            0.33392261402139906`}, {-0.970288203119882, 
            0.34866075170213556`}, {-1., 0.3678244053752419}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.22126971761016392`, 0.522537887157496, -0.7792932924277692], 
           
           ArrowBox[{{0.5364950728535816, 0.6276177901941129}, {
            0.5471919198012003, 0.6476438927160784}, {0.565230154565526, 
            0.6803710704550041}, {0.5833649683935624, 0.7117518464148539}, {
            0.6015963612853097, 0.7417862205956283}, {0.6169662324465766, 
            0.765844007281666}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.20947894400999936`, 0.5225589406323329, -0.8074725985156981], 
           
           ArrowBox[{{0.6191197516014134, 0.769214816568729}, {
            0.6199243332407676, 0.7704741929973268}, {0.6385755981513205, 
            0.7977662897485459}, {0.6577768699083528, 0.8236130369778817}, {
            0.6775281485118646, 0.8480144346853343}, {0.6978294339618557, 
            0.8709704828709036}, {0.7065614322864654, 0.8804057012764366}, {
            0.7154383711380916, 0.8895682322788098}, {0.7197363369385987, 
            0.893156536325503}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2007825908692088, 0.5225744687442475, -0.8282564084091929], 
           
           ArrowBox[{{0.7228068786959859, 0.8957200833440188}, {
            0.7427640620121334, 0.912382021799993}, {0.7722648825038412, 
            0.9325880800082335}, {0.8031194778671862, 0.9513622659509531}, {
            0.8366816229738058, 0.9672727073626314}, {0.8602885269634116, 
            0.9754543667963634}}]}}, {
          Arrowheads[{{0.012164786233346738`, 1.}}], {
           LABColor[
           0.20774083812915764`, 0.522562044174956, -0.8116265768118113], 
           ArrowBox[{{0.8640679741728077, 0.9767642441919195}, {
            0.8735151263801006, 0.9800384296595579}, {0.9141837966424717, 
            0.9893784582580226}, {0.9361409268013308, 0.9926622067384483}, {
            0.9594260635874983, 0.9948862704304908}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3246441800036789, 0.5223533028616232, -0.5322339631381897], 
           
           ArrowBox[{{-0.01758778324047018, -0.46491841735704}, \
{-0.03200763837176961, -0.43561107499674406`}, {-0.04638129839894478, \
-0.40589854332870096`}, {-0.06209598311864108, -0.37280613783073224`}, \
{-0.07781120016751158, -0.33922584426473257`}, {-0.0865214675649813, \
-0.3205348598195883}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.33584472132275434`, 0.5223333032990145, -0.5054652800234266], 
           
           ArrowBox[{{-0.08821106713722848, -0.31690922149158834`}, \
{-0.09369465783530567, -0.3051422224128835}, {-0.10946945449915269`, \
-0.2705877031532062}, {-0.12551602129492614`, -0.23552394242461405`}, \
{-0.14174718238143386`, -0.19996294335302411`}, {-0.15492618643363293`, \
-0.17148255537928875`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.34906371797786057`, 0.5223096996048986, -0.4738725986989081], 
           
           ArrowBox[{{-0.1566060130231042, -0.16785237871288458`}, \
{-0.15844563137065426`, -0.16387688526479774`}, {-0.17589406187456594`, \
-0.12723794748629588`}, {-0.19428775675946044`, -0.09005739669131277}, \
{-0.21389192748817898`, -0.05231522967569614}, {-0.22426906207734817`, \
-0.033210188369350684`}, {-0.22881600998292778`, -0.02511460823211114}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3719970930623448, 0.5222687500241806, -0.4190630825424839], 
           
           ArrowBox[{{-0.23077482401106436`, -0.02162705212458034}, \
{-0.23509416056752444`, -0.01393672094888736}, {-0.2464156712720582, 
            0.005514513272013658}, {-0.2582820425042998, 
            0.025152854979672214`}, {-0.27069480179676547`, 
            0.044963418411483255`}, {-0.2836725387840929, 
            0.06494012742263258}, {-0.2972892949328147, 
            0.08510553712612635}, {-0.31161911170946355`, 
            0.10548220263497066`}, {-0.3171106327411956, 
            0.11296936756183326`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4122835519183398, 0.5228632434622603, -0.30222377237616127`], 
           
           ArrowBox[{{-0.31947634887661575`, 
            0.1161947957762899}, {-0.32673603058057216`, 
            0.12609267906217167`}, {-0.3427140930126731, 
            0.14695952152073552`}, {-0.35962734047229905`, 
            0.16810528512366843`}, {-0.3775498144259827, 
            0.18955252498397632`}, {-0.40111858990581917`, 
            0.21640081804951372`}, {-0.42194854419253924`, 
            0.23893989678982835`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.47223330569311245`, 0.5267696744863554, -0.035146124542455], 
           
           ArrowBox[{{-0.4246633988623925, 
            0.24187750876583472`}, {-0.42639695281724865`, 
            0.2437533030451336}, {-0.45338490316027097`, 
            0.2716099799708358}, {-0.4820824409348861, 
            0.2999708488266203}, {-0.4971308889870297, 
            0.3143593650023198}, {-0.5127239016530487, 
            0.3289119487085925}, {-0.5288614789329433, 
            0.3436285999454385}, {-0.5395502772432672, 
            0.353163167067002}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5427223065673202, 0.531362861322568, 0.27888413190129446`], 
           
           ArrowBox[{{-0.5425352766121349, 
            0.3558258309150797}, {-0.5455436208267133, 
            0.35850931871285774`}, {-0.562770327334359, 
            0.3735541050108504}, {-0.5805415984558799, 
            0.3887629588394161}, {-0.5988574341912766, 
            0.40413588019855523`}, {-0.6177178345405486, 
            0.4196728690882675}, {-0.6371949390510475, 
            0.4353978810166961}, {-0.6573608872701248, 
            0.45133487149198376`}, {-0.6657596965082567, 
            0.4578385139488358}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6198832882234441, 0.5363908061198651, 0.622638229085416], 
           
           ArrowBox[{{-0.6689223473392704, 
            0.46028752185431276`}, {-0.6782156791977803, 
            0.4674838405141307}, {-0.699759314834014, 
            0.4838447880831369}, {-0.7219917941788259, 
            0.5004177141990023}, {-0.7449131172322161, 
            0.5172026188617267}, {-0.7685232839941845, 
            0.5341995020713105}, {-0.7928222944647311, 
            0.5514083638277534}, {-0.7978703269458213, 
            0.554985626577219}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6850202597737123, 0.44549340829536144`, 0.7547405115049203], 
           
           ArrowBox[{{-0.8011339450987971, 
            0.5572983731157671}, {-0.8164348654107452, 
            0.5681412930988514}, {-0.840773370841718, 
            0.585099520694438}, {-0.8658187181757189, 
            0.6022766765741857}, {-0.8916281851585395, 
            0.6196918708590772}, {-0.9199611469338329, 
            0.6379260299813139}, {-0.9337996617291512, 
            0.6466974709182505}}]}}, {
          Arrowheads[{{0.009251208582129354, 1.}}], {
           LABColor[
           0.7449397271423376, 0.30885816249002507`, 0.7881670799604178], 
           
           ArrowBox[{{-0.9371781599968902, 
            0.648838907224771}, {-0.9491551263529867, 
            0.6564304193595644}, {-0.9792915396535771, 
            0.6752321395857374}, {-1., 0.6879633190029311}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.21392583198135146`, 0.5225510003183907, -0.7968447787022712], 
           
           ArrowBox[{{0.5246262583133636, -1.}, {
            0.5229116711527654, -0.9906026072717081}, {
            0.520018795486874, -0.9690075199155506}, {
            0.5178107921336259, -0.9472975016465199}, {
            0.5163540842687206, -0.9255159523417298}, {
            0.5156818834800099, -0.9036845719397847}, {
            0.5160044222977063, -0.8702233772194813}, {
            0.5181289000115529, -0.8405966625358927}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.21432073777354077`, 0.522550295178979, -0.7959009753886496], 
           
           ArrowBox[{{0.5184244076720825, -0.8366079111892873}, {
            0.5231214613787633, -0.8035198234937333}, {
            0.5303901666713846, -0.7708309251628476}, {
            0.5382771879210172, -0.7451567559664805}, {
            0.5480817093081458, -0.7200796193262033}, {
            0.5598037308327705, -0.6955995152420165}, {
            0.5658376373807946, -0.6850340258318912}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.21677720099638462`, 0.5225459089454372, -0.7900301622089875], 
           
           ArrowBox[{{0.567821321702731, -0.6815605554475489}, {
            0.5734432524948911, -0.6717164437139199}, {
            0.5891520947395339, -0.6486581856306668}, {
            0.6070820780117245, -0.62665252188101}, {
            0.627233202311463, -0.6056994524649496}, {
            0.6496054676387494, -0.5857989773824857}, {
            0.6743173531233133, -0.5672097414817444}, {
            0.6763863622955362, -0.5659137085460539}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.22957463260824623`, 0.5225230579931965, -0.7594449983546879], 
           
           ArrowBox[{{0.6797762167296412, -0.5637902945695579}, {
            0.7014873378948844, -0.5501903896108519}, {
            0.7311154219534627, -0.5347409217698085}, {
            0.7632016052990481, -0.5208613379586138}, {
            0.7815780951350447, -0.5136384092774912}, {
            0.8007325645947488, -0.5069760510835458}, {
            0.8260413963342712, -0.5010988444139481}}]}}, {
          Arrowheads[{{0.016444109106629093`, 1.}}], {
           LABColor[
           0.2529142639845436, 0.5224813830057405, -0.7036645518093544], 
           
           ArrowBox[{{0.829937719264046, -0.5001940418791864}, {
            0.8374658145858733, -0.49844587062852685`}, {
            0.8767031586624707, -0.4919737546822467}, {
            0.9172180052383052, -0.48659892184775394`}, {
            0.9602878568126144, -0.48341865523683625`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6541895371044963, 0.5157971602354235, 0.7375413388972109], 
           
           ArrowBox[{{-0.6270992616767315, -0.9887631492107477}, \
{-0.6517782460327745, -0.9723001216044673}, {-0.6769418096416611, \
-0.9555918249554296}, {-0.7025899525033912, -0.9386382592636346}, \
{-0.7287226746179649, -0.9214394245290822}, {-0.753775960738176, \
-0.9049369676308198}, {-0.7605514786458992, -0.9005002146525952}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6967719693296489, 0.41869581154888086`, 0.761296299484877], 
           
           ArrowBox[{{-0.7638978617741283, -0.8983089319325648}, \
{-0.7793492220480114, -0.8881910531745989}, {-0.8054239876387183, \
-0.8712064079172802}, {-0.8320556702365537, -0.8539688515882807}, \
{-0.8681739823391308, -0.8311125873285576}, {-0.8868019345243061, \
-0.819435675578695}, {-0.8986237159318715, -0.8120099022787952}}]}}, {
          Arrowheads[{{0.011906541786416674`, 1.}}], {
           LABColor[
           0.7425672282753366, 0.3142682066726821, 0.786843561924109], 
           
           ArrowBox[{{-0.902010915279463, -0.8098822555553761}, \
{-0.9053034875686176, -0.8078140481888325}, {-0.9241041572014144, \
-0.7960694938879583}, {-0.943602991548183, -0.7840308632284949}, \
{-0.9633810917805408, -0.7718746020255963}, {-0.9830195590701041, \
-0.7597771560944153}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.19164749918293406`, 0.5225907802628529, -0.8500887795069838], 
           
           ArrowBox[{{0.6925508771717744, -1.}, {
            0.7164984623127247, -0.9650600150998575}, {
            0.7316649023582245, -0.9486218166791551}, {
            0.7488445812790975, -0.9330395494068402}, {
            0.7682432660448915, -0.9185804443631951}, {
            0.7900667236251548, -0.9055117326285029}, {
            0.8102927094751075, -0.8957705886610835}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.20987768210264554`, 0.5225582286500081, -0.8065196362129161], 
           
           ArrowBox[{{0.813896527652716, -0.8940349347374172}, {
            0.8143149540198872, -0.8938334142027636}, {
            0.8409879572290886, -0.8835454890859773}, {
            0.8553254670504774, -0.8786133063037358}, {
            0.8703542805562859, -0.8741258905674509}, {
            0.9030567053356277, -0.8683879823769806}, {
            0.9385771500498509, -0.8647497963554227}, {
            0.9696984296374109, -0.8626444414550403}}]}}, {
          Arrowheads[{{0.0032894160605322804`, 1.}}], {
           LABColor[
           0.24197801121946955`, 0.5225009106576324, -0.7298015996886961], 
           
           ArrowBox[{{0.9736893078870055, -0.8623744584983314}, {
            0.9755453429373595, -0.8622488977071193}, {
            1., -0.8621100577374678}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.33757258532599005`, 0.5223302180441748, -0.501335779256419], 
           
           ArrowBox[{{0.08429036061258213, -0.9557007612858808}, {
            0.05991957456928018, -0.9274276824184235}, {
            0.03497853092619573, -0.8984056059965344}, {
            0.00941844341868628, -0.8686119613701937}, \
{-0.016809474217890603`, -0.8380241778893824}, {-0.019970955689228347`, \
-0.8343353969725784}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.36089588150936214`, 0.5222885722246583, -0.445594372931605], 
           
           ArrowBox[{{-0.02257396419649358, -0.8312982360102479}, \
{-0.043722846354445996`, -0.8066219588840748}, {-0.07136422687687616, \
-0.7743831885002501}, {-0.08548485170064421, -0.7579421904707655}, \
{-0.09981979632230106, -0.7412825673118971}, {-0.11437983330898653`, \
-0.7244011565953941}, {-0.12686887377491946`, -0.709961886031918}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3860923139333857, 0.522243581753803, -0.3853762731123985], 
           
           ArrowBox[{{-0.12948594614170397`, -0.7069368355029029}, \
{-0.14419399131835803`, -0.6899648420823675}, {-0.15942992112099502`, \
-0.672411008657162}, {-0.17490754265433472`, -0.6546276681131966}, \
{-0.19065087393696012`, -0.6366091929462792}, {-0.20668393298745433`, \
-0.6183499556522182}, {-0.2230307378244002, -0.5998443287268218}, \
{-0.23486357633973312`, -0.5865412474267441}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4153785672318364, 0.5230649200844215, -0.2884354019844579], 
           
           ArrowBox[{{-0.23752202018535643`, -0.5835524891026791}, \
{-0.2397153064663809, -0.5810866846658987}, {-0.25676165693197944`, \
-0.5620713959652567}, {-0.27411077336039413`, -0.5428104578484607}, \
{-0.2917338340287815, -0.5233094572744367}, {-0.3097001481626615, \
-0.5035531543420345}, {-0.32807902498755437`, -0.4835263091501052}, \
{-0.34513738209677214`, -0.4651548194517044}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4530490298968539, 0.5255195934530479, -0.12061255154909803`], 
           
           ArrowBox[{{-0.3478660496307792, -0.4622300636402449}, \
{-0.36635170361245933`, -0.44260003238306483`}, {-0.3863841238635117, \
-0.4216701210056544}, {-0.4071063437076576, -0.4004087077641174}, \
{-0.4334680309486649, -0.3739472233421872}, {-0.45990398334984456`, \
-0.3480269295394046}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.4997194619959173, 0.5285607206033719, 0.08730538711716213], 
           
           ArrowBox[{{-0.4627791792323176, -0.34524614011253957`}, \
{-0.489669552890462, -0.31945597313809415`}, {-0.5195093875912519, \
-0.2914262073559313}, {-0.5349235685223698, -0.2772020692972162}, \
{-0.5507465853716369, -0.26282080112993933`}, {-0.5669784381390528, \
-0.24828240285410041`}, {-0.5802111282710145, -0.23659650588729356`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5566882601986858, 0.532272907337963, 0.34110280355144107`], 
           
           ArrowBox[{{-0.5832093560364315, -0.23394874640677374`}, \
{-0.5836191268246178, -0.23358687446969978`}, {-0.6006686514283317, \
-0.2187342159767372}, {-0.6181270119501947, -0.20372442737521285`}, \
{-0.6359942083902065, -0.18855750866512655`}, {-0.6542702407483674, \
-0.17323345984647837`}, {-0.6730280922392957, -0.15773422428184586`}, \
{-0.6923407460776102, -0.14204174533380648`}, {-0.7058633962321896, \
-0.13122923549192972`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6229515539923977, 0.5365907396948226, 0.6363074295892156], 
           
           ArrowBox[{{-0.7089875036288826, -0.12873124570533573`}, \
{-0.7122082022633103, -0.12615602300236026`}, {-0.7326304607963965, \
-0.11007705728750716`}, {-0.7536075216768687, -0.09380484818924727}, \
{-0.7751393849047269, -0.07733939570758049}, {-0.7972260504799709, \
-0.060680699842506854`}, {-0.8198675184026007, -0.04382876059402638}, \
{-0.8361831905862014, -0.03168256878409134}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.6813859524532258, 0.4537807729178119, 0.7527130832287442], 
           
           ArrowBox[{{-0.8393917187828506, -0.029293982002894698`}, \
{-0.839681484457072, -0.02907826613048541}, {-0.8599816125615488, \
-0.014164287772272507`}, {-0.8807544934839153, 
            0.0009094390923953064}, {-0.9020403549205185, 
            0.01615412062816911}, {-0.9289524142922312, 
            0.034631550529073234`}, {-0.9566474224175178, 
            0.05336783946814313}, {-0.9703971299276916, 
            0.06252399559676519}}]}}, {
          Arrowheads[{{0.003935913683290008, 1.}}], {
           LABColor[
           0.7373162961606076, 0.3262419846735664, 0.7839142861895908], 
           
           ArrowBox[{{-0.9737264834891421, 
            0.06474106683216926}, {-0.9852098883473694, 
            0.07238805479117179}, {-1., 0.08209451066330148}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2316707365260932, 0.5225193152132411, -0.7544354242676837], 
           ArrowBox[{{0.43465664628715045`, 0.5639254561614093}, {
            0.44245299365333074`, 0.5928123857070107}, {0.449566548674569, 
            0.6213475257496921}, {0.45599731135086574`, 0.6495308762894543}, {
            0.4617452816822207, 0.6773624373262965}, {0.46669147381944426`, 
            0.7049282383562296}, {0.46892206266446307`, 
            0.7201035344945919}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.22307157110374656`, 0.5225346697878412, -0.7749869608126359], 
           
           ArrowBox[{{0.4695037648925132, 0.7240610112813692}, {
            0.470716901913347, 0.7323143088752644}, {0.47382156596392894`, 
            0.7595206488834007}, {0.47600546597118987`, 0.7865472583806381}, {
            0.47708440084111703`, 0.8135090543763535}, {0.47687416947969724`, 
            0.840520953879923}, {0.4753747718869306, 0.8675829568913468}, {
            0.4737315373641294, 0.8835594782221813}}]}}, {
          Arrowheads[{{0.014497057088083957`, 1.}}], {
           LABColor[
           0.22208604380002753`, 0.5225364295344868, -0.777342317338956], 
           
           ArrowBox[{{0.47332228402106497`, 0.8875384871064628}, {
            0.47258620806281715`, 0.8946950634106247}, {0.4705176442336513, 
            0.9110459347874802}, {0.46790109087413345`, 0.9274609968006052}, {
            0.4628114395839313, 0.9485437305489605}, {0.4565843063515045, 
            0.9698706030758217}, {0.44973684793138174`, 0.9913446006848328}, {
            0.4465208880590613, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2741525906160386, 0.5224434600847789, -0.6529061090439066], 
           
           ArrowBox[{{0.166141352071487, 0.20421959951556073`}, {
            0.16785739284699483`, 0.22775100515737126`}, {
            0.16939207438505988`, 0.25882171957433864`}, {0.1700114499010062, 
            0.2898529571632763}, {0.1696264858839699, 0.3208856655183735}, {
            0.16814814882308715`, 0.35196079223381965`}, {0.1671311043747121, 
            0.36403275315110695`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.27414496244960085`, 0.5224434737055486, -0.6529243399458157], 
           
           ArrowBox[{{0.16679530005475976`, 0.36801863265991064`}, {
            0.1655244388164823, 0.3831033098579355}, {0.16167372907508903`, 
            0.41435097097573687`}, {0.15646254575725782`, 
            0.44576389323645466`}, {0.14975741502133888`, 
            0.47740219428932007`}, {0.14156129945825863`, 
            0.5092737055190916}, {0.1368162320880163, 
            0.5248532253222802}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.28611808033871905`, 0.5224220946387674, -0.6243092409484431], 
           
           ArrowBox[{{0.13565080465309112`, 0.5286796830698482}, {
            0.13176801251288256`, 0.5414280873221055}, {0.12008035662446989`, 
            0.5739882008649604}, {0.10620113423227988`, 0.6070769073142546}, {
            0.09637948997065732, 0.6278867263169358}, {0.08558408080128381, 
            0.6489571343171052}, {0.07381490672415936, 0.6702881313147626}, {
            0.07119784747812466, 0.6747224662693768}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.31508576040483915`, 0.5223703702698637, -0.555078064867766], 
           
           ArrowBox[{{0.06916479011011317, 0.6781672707251296}, {
            0.061071967739284, 0.6918797173099083}, {0.04722610358707072, 
            0.7137835771157819}, {0.032148154007932486`, 
            0.7360513955456233}, {0.015838119001869308`, 
            0.758683172599433}, {-0.0017040014311187832`, 
            0.7816789082772103}, {-0.020649571077450503`, 
            0.8051040887868597}, {-0.023465710676068417`, 
            0.808386794304562}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.3598917289635503, 0.52229036522833, -0.4479942427711047], 
           
           ArrowBox[{{-0.02607015120638406, 
            0.8114227273611443}, {-0.04116995372354454, 
            0.8290242003362851}, {-0.06326514936940088, 
            0.8534392429254867}, {-0.08693515801501953, 
            0.8783492165544641}, {-0.11221599121851591`, 
            0.9043536417631763}, {-0.1359740271129497, 
            0.927616114569766}}]}}, {
          Arrowheads[{{0.01052951759308863, 1.}}], {
           LABColor[
           0.41703845610445367`, 0.523173414146334, -0.2810302902027135], 
           
           ArrowBox[{{-0.1388321051414623, 
            0.9304145766443587}, {-0.13939225131378186`, 
            0.9309630388640134}, {-0.16971355262578472`, 
            0.957992515830168}, {-0.20231314053924926`, 
            0.9857751476459928}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.23334842357362928`, 0.5225163195538182, -0.7504258436892208], 
           
           ArrowBox[{{0.5245512447433112, 0.44660813008705347`}, {
            0.5388310561694, 0.4654713226184014}, {0.5533728806716842, 
            0.48374222019581026`}, {0.5682275600105198, 0.501398167459622}, {
            0.5834459359462624, 0.5184165090501786}, {0.6036664466306356, 
            0.539378260075026}, {0.6245952769123191, 0.5592453926935034}, {
            0.6314719155619549, 0.5652116034700503}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.22631155796249294`, 0.5225288845031674, -0.7672435688597782], 
           
           ArrowBox[{{0.6344932673102007, 0.5678329454190093}, {
            0.6462324267913133, 0.5780179069056108}, {0.6685778962676181, 
            0.5956958027113485}, {0.6918363667672504, 0.6121810269333238}, {
            0.7162125197162272, 0.6273755263941445}, {0.7417063551145486, 
            0.6412793010938105}, {0.7683178729622144, 0.653892351032322}, {
            0.7685458297469457, 0.6539833888541117}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23021631792705663`, 0.5225219122069936, -0.7579114054265159], 
           
           ArrowBox[{{0.772260550132512, 0.655466915886915}, {
            0.7963107375596332, 0.6650717042663454}, {0.8259486132072134, 
            0.6746743888525473}, {0.8572314999049548, 0.6827004047909276}, {
            0.8901593976528578, 0.6891497520814862}, {0.910204519510658, 
            0.6925119547146583}, {0.9268323015444733, 
            0.6947171812024036}}]}}, {
          Arrowheads[{{0.00865480357271281, 1.}}], {
           LABColor[
           0.2514800296481221, 0.5224839439586971, -0.7070922936809542], 
           
           ArrowBox[{{0.9307975811727831, 0.6952430685185761}, {
            0.9309276820138284, 0.6952603228836001}, {0.9709959204745449, 
            0.696828315645341}, {1., 0.6963345788808086}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.293653339700195, 0.522408639763054, -0.6063003818863033], 
           
           ArrowBox[{{0.04848637025768895, -0.07958755561010898}, {
            0.04878393870984293, -0.05755564366967076}, {
            0.04935517091256448, -0.035533172467230936`}, {
            0.05011199164070032, -0.013515843393588486`}, {
            0.050966325669097166`, 0.008500642160457676}, {
            0.05183009777260174, 0.03052058280410882}, {0.05261523272606076, 
            0.052548277146566236`}, {0.05317097700339912, 
            0.0803369749974983}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2928528093816155, 0.5224100691811303, -0.6082136057039165], 
           
           ArrowBox[{{0.053226813459007656`, 0.08433632980922176}, {
            0.05301083840598492, 0.11433662224119602`}, {0.05184992472354032, 
            0.14525024786861912`}, {0.04965225496138517, 
            0.17622710630930433`}, {0.04632999364123377, 
            0.2072971246176682}, {0.04178700662856531, 
            0.23849644666050782`}, {0.04082392269540537, 
            0.24364038314064207`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2976642226197863, 0.5224014779749062, -0.5967145903761999], 
           
           ArrowBox[{{0.04008780537517788, 0.2475720661506088}, {
            0.03591263714044761, 0.2698720957262866}, {0.02859622839394849, 
            0.30147109510346765`}, {0.019776783344354752`, 
            0.33332272654632356`}, {0.009353577156378036, 
            0.36547046503647923`}, {-0.002843638638776625, 
            0.39798262370342674`}, {-0.004148197991875936, 
            0.40102180953032096`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.3169337026125513, 0.5223670706047111, -0.5506615837385551], 
           ArrowBox[{{-0.005725970703580991, 
            0.40469749086446827`}, {-0.016985112509904195`, 
            0.43092751567665816`}, {-0.03307154625664753, 
            0.4643142603381978}, {-0.051239279013971115`, 
            0.49819933206804395`}, {-0.07186201525365243, 
            0.5327220764926498}, {-0.0805686183612799, 
            0.5458274964182291}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.352985826130165, 0.5223026963319929, -0.4644989740427444], 
           
           ArrowBox[{{-0.08278207572248598, 
            0.5491592536888181}, {-0.09531345944746893, 
            0.5680218392384683}, {-0.11188033485134581`, 
            0.59095500842286}, {-0.12977437755202637`, 
            0.6142730150142788}, {-0.14899558754951062`, 
            0.6379758590127248}, {-0.16954396484379852`, 
            0.662063540418198}, {-0.181235766015795, 0.6750739565357294}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.4034915603914788, 0.5224445904201138, -0.33663431342135947`], 
           
           ArrowBox[{{-0.18390940397237354`, 
            0.6780491304931885}, {-0.1915928672833133, 
            0.6865991437399533}, {-0.215315652716478, 
            0.7116457534872458}, {-0.24071232114329275`, 
            0.7372033696600752}, {-0.2677828725637575, 
            0.7632719922584416}, {-0.29675235578795256`, 
            0.7899310722430295}, {-0.2975227630875305, 
            0.7906082065825921}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.47085110939898334`, 0.5266796081533883, -0.04130384349601987], 
           
           ArrowBox[{{-0.3005272104568958, 
            0.7932489064907062}, {-0.32784581962595816`, 
            0.8172600605745233}, {-0.34418904427514, 
            0.83117577037036}, {-0.36106326407777456`, 
            0.8452589572529232}, {-0.3784684790338616, 
            0.8595096212222129}, {-0.3964046891434014, 
            0.873927762278229}, {-0.41475160649723714`, 
            0.8886949091684848}, {-0.42348663490170463`, 
            0.8955855168812206}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5453751316656028, 0.5315357240553219, 0.2907025338587963], 
           
           ArrowBox[{{-0.4266271217266989, 
            0.8980628829224098}, {-0.43372336611324175`, 
            0.9036607395105305}, {-0.4533019027566735, 
            0.9188190611962699}, {-0.47354141213175766`, 
            0.934188450549991}, {-0.49497120382393545`, 
            0.9495929235999525}, {-0.5170879760669663, 
            0.965219346678696}, {-0.5399609668523202, 
            0.9810912573018418}, {-0.5560468221893814, 
            0.9920687418933491}}]}}, {
          Arrowheads[{{0.0006380675110825469, 1.}}], {
           LABColor[
           0.6243907412798434, 0.5366845196607968, 0.6427190448390002], 
           
           ArrowBox[{{-0.5593507890397189, 
            0.9943234709351345}, {-0.5635670968495072, 
            0.9972008096308498}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.7198870216399831, 0.36598621660546066`, 0.7741912218253978], 
           
           ArrowBox[{{-0.801036748660002, -1.}, {-0.8240949734355715, \
-0.9855488620611145}, {-0.8514358890910132, -0.9685041553461695}, \
{-0.8793088994320908, -0.9512095699968723}, {-0.9077705225078082, \
-0.9336503779266985}, {-0.9264844939023438, -0.9222798179464551}, \
{-0.9371316033503035, -0.9158724650130002}}]}}, {
          Arrowheads[{{0.00647368271550967, 1.}}], {
           LABColor[
           0.7659436798798783, 0.26096253906063066`, 0.7998843080141682], 
           
           ArrowBox[{{-0.940558861442381, -0.913809966050506}, \
{-0.9458471260355932, -0.9106275269274915}, {-0.9654692224643283, \
-0.8988625434930398}, {-0.9849615867453205, -0.8871539062663323}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.22075229954452166`, 0.5225388110534671, -0.780529893395746], 
           
           ArrowBox[{{0.4781011297085227, -0.852067830217916}, {
            0.47785622146661266`, -0.8131556869850813}, {
            0.4804084562502726, -0.7743033731491817}, {
            0.4858710735599451, -0.7357659116894328}, {
            0.49486607916622816`, -0.6951388911637612}, {
            0.49536176810459986`, -0.693599253892738}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.22098154645879886`, 0.5225384017127143, -0.7799820057688441], 
           
           ArrowBox[{{0.4965876102277616, -0.689791720427477}, {
            0.5077161318931173, -0.6552259163495141}, {
            0.5246519858755442, -0.6165110128953488}, {
            0.5459043952484406, -0.5794782064499221}, {
            0.5622610074653762, -0.5564417988031161}, {
            0.5689742969958591, -0.5483951075701514}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.22639370081873056`, 0.5225287378297925, -0.7670472519116838], 
           
           ArrowBox[{{0.5715367717800593, -0.5453236709388113}, {
            0.5806416215727075, -0.5344104048460422}, {
            0.6010462375704346, -0.5133840245787008}, {
            0.6234748554585575, -0.4933626580010916}, {
            0.6480018282526605, -0.4745636486704398}, {
            0.6747015089683271, -0.4572043401439705}, {
            0.6954326234722622, -0.44577365407586733`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.2415411996274581, 0.5225016906235763, -0.730845555579247], 
           
           ArrowBox[{{0.6989354465202005, -0.44384227356057965`}, {
            0.7035738976055581, -0.44128473242168376`}, {
            0.734618994164353, -0.4268048255035794}, {
            0.7679239326797943, -0.4139995754794308}, {
            0.803575847186965, -0.403103938439011}, {
            0.8415747376858644, -0.39411791438232}, {
            0.8498866985103033, -0.39266004876355215`}}]}}, {
          Arrowheads[{{0.0183804808588852, 1.}}], {
           LABColor[
           0.2648925918914334, 0.5224599946360095, -0.6750370011535505], 
           
           ArrowBox[{{0.8538265567066491, -0.3919690224307059}, {
            0.881920604176493, -0.38704150330935794`}, {
            0.9060687083760978, -0.38348111208648344`}, {
            0.9310470292863995, -0.38064897071816234`}, {
            0.9740835716802909, -0.37940987775389357`}, {
            0.9964593236339648, -0.37960053802767435`}, {
            1., -0.37971329672570214`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.20776656331156584`, 0.522561998240355, -0.8115650950283566], 
           
           ArrowBox[{{0.5565969743539343, -0.9122063686218409}, {
            0.5607701007368622, -0.8813499124310034}, {
            0.5672492732289929, -0.85074653326913}, {
            0.5762654240129634, -0.8206944679576522}, {
            0.5880494852714105, -0.7914919533180023}, {
            0.5995131423182825, -0.7692126221341385}, {
            0.6046372334104602, -0.7610244004143971}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.21059691048884563`, 0.5225569444037623, -0.8048007195812222], 
           
           ArrowBox[{{0.6067591502873473, -0.7576336086532325}, {
            0.6129573582022569, -0.747728964149583}, {
            0.6283821329233341, -0.7270409793643358}, {
            0.6457874664815142, -0.7071486677783967}, {
            0.665318325233471, -0.6882852722996918}, {
            0.6871196755358786, -0.6706840358361468}, {
            0.7111915173887371, -0.654344958387762}, {
            0.721443669351261, -0.6484771843930488}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.22585337585044954`, 0.5225297026280754, -0.7683385991281149], 
           
           ArrowBox[{{0.7249152697227277, -0.6464902292197162}, {
            0.7375338507920463, -0.639268039954537}, {
            0.7662750075078628, -0.6257174465786463}, {
            0.7975433192982422, -0.6139573443022633}, {
            0.8313387861631852, -0.6039877331253889}, {
            0.8676614081026917, -0.5958086130480225}, {
            0.8753300584559546, -0.5943224961288646}}]}}, {
          Arrowheads[{{0.014411265974149818`, 1.}}], {
           LABColor[
           0.25231162235298427`, 0.5224824590759676, -0.7051048324536032], 
           
           ArrowBox[{{0.8792569998672312, -0.5935614894584592}, {
            0.8884775109564018, -0.5917746355921764}, {
            0.9101060454892176, -0.5883752689990055}, {
            0.9507816666671759, -0.5858195245940552}, {
            0.9940287207789993, -0.58550531494427}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.24715591062444753`, 0.5224916650577652, -0.7174267024026229], 
           
           ArrowBox[{{0.46467131341496093`, 0.21892700433782825`}, {
            0.48219070915805634`, 0.2410391704404471}, {0.5001212121676022, 
            0.2624121028060129}, {0.5185290338621988, 0.28300609850444075`}, {
            0.541375718490757, 0.30666687616962474`}, {0.565044192015006, 
            0.32911757946556364`}, {0.5731694328400647, 
            0.33616467526003674`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.24133090753785072`, 0.5225020661188039, -0.7313481422085785], 
           
           ArrowBox[{{0.5761912280815443, 0.33878550595250256`}, {
            0.5895344544349456, 0.35035820839225784`}, {0.6148465057505759, 
            0.370388762949707}, {0.6411660223793547, 0.38910470505768}, {
            0.6686786807387401, 0.4064014966359457}, {0.697384480828732, 
            0.422279137684504}, {0.708602261174999, 0.4277038169842682}}]}}, {
         
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.24397393196098882`, 0.5224973467636477, -0.7250314579312686], 
           
           ArrowBox[{{0.7122033107686399, 0.42944520775722517`}, {
            0.7272834226493303, 0.4367376282033549}, {0.75861890192777, 
            0.44963177751910255`}, {0.7916343143912858, 
            0.46081639495835125`}, {0.8263296600398777, 
            0.47029148052110087`}, {0.8627049388735458, 
            0.47805703420735157`}, {0.8640275497615264, 
            0.47830264008782747`}}]}}, {
          Arrowheads[{{0.01587192727853596, 1.}}], {
           LABColor[
           0.2604916760501127, 0.5224678528626251, -0.6855549500825383], 
           
           ArrowBox[{{0.8679603163721681, 0.47903294604167274`}, {
            0.885125713639684, 0.48222052187967557`}, {0.9082498511292125, 
            0.485703885380169}, {0.9500487234039919, 0.4882224678718081}, {
            0.9718682058436373, 0.48864795958441265`}, {0.9943010524847868, 
            0.4885175849415407}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.5812333950357488, 0.5338723113418281, 0.45045199125073304`], 
           
           ArrowBox[{{-0.47417732083792613`, -0.9898298016623017}, \
{-0.49401464929781186`, -0.9755726140175383}, {-0.5142411318106933, \
-0.9611116819233948}, {-0.5348567683765704, -0.9464470053798715}, \
{-0.5558615589954431, -0.9315785843869683}, {-0.5772555036673116, \
-0.9165064189446853}, {-0.5990386023921757, -0.9012305090530222}, \
{-0.6046937114673492, -0.8972823701506913}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[0.63587421809846, 0.5374328031362763, 0.6938782203911046], 
           
           ArrowBox[{{-0.6079734804926853, -0.8949925851956254}, \
{-0.6212108551700355, -0.8857508547119793}, {-0.6437722620008911, \
-0.8700674559215567}, {-0.666789307866948, -0.8541626394997421}, \
{-0.690328477750412, -0.8380187322645237}, {-0.7143897716512828, \
-0.8216357342159013}, {-0.7389731895695606, -0.8050136453538751}, \
{-0.7398639544121, -0.8044153971225846}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.6806766721610201, 0.4553981552365529, 0.752317405375073], 
           
           ArrowBox[{{-0.7431845572422121, -0.8021852408848624}, \
{-0.7640787315052456, -0.7881524656784452}, {-0.7897063974583378, \
-0.7710521951896114}, {-0.8158561874288367, -0.7537128338873738}, \
{-0.8425281014167427, -0.7361343817717323}, {-0.8682191292945125, \
-0.7191869072888375}, {-0.876522875373517, -0.7137511499212545}}]}}, {
          Arrowheads[{{0.015643323820785718`, 1.}}], {
           LABColor[
           0.7266112441499328, 0.35065287277173646`, 0.7779423847430529], 
           
           ArrowBox[{{-0.8798695746697727, -0.7115603501082999}, \
{-0.8944759513799494, -0.7019987957133763}, {-0.9212787931576726, \
-0.6845749878138871}, {-0.9486869781738237, -0.6669006612847537}, \
{-0.9852059619475688, -0.6439955752516309}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24344066410504717`, 0.5224982989608289, -0.7263059390339525], 
           
           ArrowBox[{{0.3655532137941376, -0.4303542958040841}, {
            0.3771626209131767, -0.39238334861339014`}, {
            0.38804399236277987`, -0.3628835164016888}, {
            0.40060441181442363`, -0.33394816790318727`}, {
            0.4148222566110505, -0.3056534091120091}, {
            0.4276014059003068, -0.2834235603863074}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.24538712809328617`, 0.5224948233762755, -0.7216539962205519], 
           
           ArrowBox[{{0.42959493706597895`, -0.27995573203249663`}, {
            0.4306759040956029, -0.2780753460222781}, {
            0.44812818696432466`, -0.25126186820902385`}, {
            0.46715437363081824`, -0.22528343838255138`}, {
            0.4877514950140649, -0.20025002223989713`}, {
            0.5099165820330457, -0.17627158547809757`}, {
            0.5304899488850199, -0.15645322950790186`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.24965914970193956`, 0.522487195301775, -0.7114440974805059], 
           
           ArrowBox[{{0.5333921949476449, -0.15370173267230258`}, {
            0.5574469306768527, -0.1330324273084884}, {
            0.5833564869378387, -0.1131675116086222}, {
            0.6106956311582133, -0.09447237149871501}, {
            0.6395104565953463, -0.07708537420972122}, {
            0.6650602418797323, -0.06366013778149918}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.25835648678094025`, 0.5224716654329512, -0.6906579360283317], 
           
           ArrowBox[{{0.6686011716712132, -0.06179954212101756}, {
            0.6698470565066077, -0.06114488697259529}, {
            0.7017054308919977, -0.04665090978733723}, {
            0.7350855797515161, -0.03360344265394702}, {
            0.7701075902146028, -0.022155783921994975`}, {
            0.8068915494106976, -0.012461231941051396`}, {
            0.8194939712244222, -0.009864809960738666}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2751154565221288, 0.5224417408020743, -0.6506049120224515], 
           
           ArrowBox[{{0.8234116884887933, -0.009057659766258911}, {
            0.8454374573398006, -0.004519786711116287}, {0.8857453140019114, 
            0.0016685517678103555`}, {0.9122231412450035, 
            0.0050831795882294185`}, {0.9394921072432257, 
            0.007706295098362582}, {0.9800464945918895, 
            0.008534841607374267}, {0.9821227158832185, 
            0.008489586773185044}}]}}, {
          Arrowheads[{{0.001735191292288958, 1.}}], {
           LABColor[
           0.29954827020624925`, 0.5223981138403889, -0.5922118193601895], 
           
           ArrowBox[{{0.9861217660268137, 0.008402420558331842}, {1., 
            0.008099920444341711}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23273157818841272`, 0.5225174209861105, -0.7519000705303419], 
           
           ArrowBox[{{0.4079633527419537, -0.6706876385967131}, {
            0.41127006435770275`, -0.6320094742350747}, {
            0.4173134813427435, -0.5936331020060361}, {
            0.4261037256799501, -0.5557565810563729}, {
            0.4335020185648727, -0.5304860800476026}, {
            0.4391803357553828, -0.5143383016825018}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.23336368230715254`, 0.5225162923079925, -0.7503893761479851], 
           
           ArrowBox[{{0.4405072725980666, -0.5105648101142685}, {
            0.442262480230859, -0.5055734186706144}, {
            0.45240630606498883`, -0.4810816600961699}, {
            0.4639546914543418, -0.45707386749503043`}, {
            0.47693736619906324`, -0.43358055239736215`}, {
            0.49137723256884597`, -0.4106582676458077}, {
            0.5072852446550911, -0.3884091383798419}, {
            0.5200433814976135, -0.3726522777140362}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.23840223528505716`, 0.5225072955235631, -0.7383475092256452], 
           ArrowBox[{{0.5225604822565475, -0.369543547463697}, {
            0.5246723565491996, -0.36693528973894}, {
            0.5455509266790066, -0.3443154335555847}, {
            0.5682358138459769, -0.32284510160536284`}, {
            0.5927270180501104, -0.3025242938882745}, {
            0.6190245392914074, -0.2833530104043197}, {
            0.6445791497053336, -0.26714820215986773`}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.24959196650862997`, 0.5224873152633414, -0.7116046616497821], 
           
           ArrowBox[{{0.6479891192229602, -0.2650603118061182}, {
            0.6771665367128072, -0.2491795369262519}, {
            0.7090430138497394, -0.23435747712974922`}, {
            0.7427898099374929, -0.22104520196160063`}, {
            0.7784989052122405, -0.2094350071474814}, {
            0.7957375289543295, -0.20499982769520203`}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.26788472163201593`, 0.5224546519222623, -0.6678859742002814], 
           
           ArrowBox[{{0.7996113710851762, -0.20400315967360372`}, {
            0.816262279910155, -0.19971918841306652`}, {
            0.8560799340312368, -0.19189774575835622`}, {
            0.8979518675754854, -0.1859706791833504}, {
            0.9242674385825717, -0.18291587316418578`}, {
            0.9514047660720464, -0.1806490010211072}, {
            0.9576194429367306, -0.18061308111562915`}}]}}, {
          Arrowheads[{{0.004797915415545888, 1.}}], {
           LABColor[
           0.2926742453671458, 0.5224103880230582, -0.6086403639634389], 
           
           ArrowBox[{{0.9616193761250524, -0.18058996209831393`}, {
            0.9944152583290274, -0.18040040679005154`}, {
            1., -0.1805554470595586}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.3827319177926799, 0.5222495820399582, -0.3934074366845939], 
           
           ArrowBox[{{-0.029358566105563724`, -0.9986407347331245}, \
{-0.04462668407126176, -0.9837767165164717}, {-0.060136033481336795`, \
-0.9686908336350799}, {-0.0758957061293713, -0.9533795919209908}, \
{-0.09191479380894775, -0.9378394972062453}, {-0.10818768071945319`, \
-0.922070061417149}, {-0.12471409927634569`, -0.9060697033548208}, \
{-0.1415111635973143, -0.8898332891635209}, {-0.14420289005047673`, \
-0.8872372306662838}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.41427864778774914`, 0.5229932474057225, -0.29333557053289006`], 
           
           ArrowBox[{{-0.14708201862759748`, -0.8844604305949054}, \
{-0.15859598780004802`, -0.8733556849875099}, {-0.1759856860022358, \
-0.8566317569710487}, {-0.19369737232156659`, -0.8396563712583969}, \
{-0.21174816087572937`, -0.8224243939938155}, {-0.2301551657824132, \
-0.8049306913215651}, {-0.24887555522047175`, -0.7871833224499372}, \
{-0.26281832034133695`, -0.7739848714364055}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.45182888423666323`, 0.5254400866233987, -0.1260483308879511], 
           
           ArrowBox[{{-0.265723221435156, -0.7712350442354474}, \
{-0.2678882958919715, -0.7691855491093935}, {-0.28724319969942075`, \
-0.7509250412274506}, {-0.30699007854532767`, -0.7323894687316246}, \
{-0.3271787443322006, -0.7135665015494321}, {-0.34785900896254746`, \
-0.6944438096083891}, {-0.3690806843388767, -0.6750090628360123}, \
{-0.3830000132317017, -0.6624002910843338}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.49418165807287723`, 0.5281998675941737, 0.062634332562269], 
           
           ArrowBox[{{-0.38596455655732964`, -0.6597148706571987}, \
{-0.3908935823636965, -0.6552499311598177}, {-0.42042667303161907`, \
-0.6288620504428862}, {-0.4510733707331679, -0.601889336613729}, \
{-0.4828336754683429, -0.5743317896723461}, {-0.5062841615532958, \
-0.5542565246267385}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5435305839847744, 0.5314155300956789, 0.2824850279493716], 
           
           ArrowBox[{{-0.5093227977410529, -0.5516552383836554}, \
{-0.5157075872371442, -0.5461894096187374}, {-0.532615783363126, \
-0.5318862535870554}, {-0.5499096564554573, -0.5174115821017311}, \
{-0.5675892065141379, -0.5027653951627644}, {-0.5856544335391679, \
-0.4879476927701552}, {-0.6041053375305473, -0.47295847492390375`}, \
{-0.6229419184882761, -0.45779774162400977`}, {-0.6328092088693489, \
-0.44992729522569785`}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6007800752986473, 0.5351460072853331, 0.5375329391923294], 
           
           ArrowBox[{{-0.6359362961221188, -0.44743303675601914`}, \
{-0.6421641764123542, -0.44246549287047343`}, {-0.6617721113027818, \
-0.4269617286632947}, {-0.6818380416463264, -0.41126911340838784`}, \
{-0.7024342859297557, -0.3953703115116672}, {-0.7235608441530694, \
-0.37926532297313265`}, {-0.7452177163162679, -0.36295414779278423`}, \
{-0.7627581067964071, -0.349896116246269}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.659357570936503, 0.5040124164121454, 0.7404243691418414], 
           
           ArrowBox[{{-0.7659666263208517, -0.3475075178159634}, \
{-0.7674049024193512, -0.3464367859706221}, {-0.7901224024623191, \
-0.32971323750664605`}, {-0.8133702164451715, -0.31278350240085606`}, \
{-0.8371483443679087, -0.29564758065325236`}, {-0.8592125703133662, \
-0.27973445170768085`}, {-0.8818079278373587, -0.2636266968256159}, \
{-0.8956811376568378, -0.25384257166195867`}}]}}, {
          Arrowheads[{{0.01523417870669886, 1.}}], {
           LABColor[
           0.7098716875808717, 0.3888243306789811, 0.7686040852196598], 
           
           ArrowBox[{{-0.8989499778016927, -0.2515372117969084}, \
{-0.9049174005438881, -0.24732866800828088`}, {-0.9285920376209489, \
-0.23082730925200523`}, {-0.959362699329273, -0.2101981545080428}, \
{-0.9910545842170524, -0.18924393546085488`}, {-1., \
-0.18341933405269356`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.47766013918623224`, 0.5271232964678529, -0.010969446019756413`], 
           
           
           ArrowBox[{{-0.26680933009761787`, -0.9550630070283739}, \
{-0.28850964135563323`, -0.9369724779012434}, {-0.310702903770951, \
-0.9185642242385023}, {-0.3334311404899854, -0.8998263956356818}, \
{-0.3567363746591511, -0.8807471416883141}, {-0.38889038003586274`, \
-0.854659088541106}, {-0.39039698848844523`, -0.8534488070170089}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5228096801999036, 0.5300653196895342, 0.1901728849396927], 
           
           ArrowBox[{{-0.39351541428380654`, -0.8509437280643958}, \
{-0.4221650474228674, -0.8279290412684148}, {-0.4392226293702297, \
-0.8143232698350131}, {-0.45656037682016526`, -0.8005569998702409}, \
{-0.474178289772674, -0.7866302313740979}, {-0.4920763682277561, \
-0.7725429643465842}, {-0.5103029648018154, -0.758282550043815}, \
{-0.5189251782804669, -0.751587114871373}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5732817064652556, 0.5333541653784198, 0.4150270204044444], 
           
           ArrowBox[{{-0.5220844916862275, -0.749133803068079}, \
{-0.5289064321112563, -0.7438363397219052}, {-0.5478867701560783, \
-0.729204333380855}, {-0.567243978936282, -0.7143865310206645}, \
{-0.5869780584518667, -0.6993829326413333}, {-0.607089008702833, \
-0.6841935382428618}, {-0.6275768296891806, -0.6688183478252498}, \
{-0.6484415214109096, -0.6532573613884975}, {-0.6495535729619833, \
-0.6524347402075666}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6296901988249483, 0.5370298416022822, 0.6663282603373433], 
           
           ArrowBox[{{-0.652769351132858, -0.6500559231158746}, \
{-0.6697517420669452, -0.6374934888728384}, {-0.6915761498562126, \
-0.621509640218506}, {-0.7139147447787118, -0.6053058154255004}, \
{-0.7367675268344425, -0.5888820144938215}, {-0.7601344960234052, \
-0.5722382374234697}, {-0.7825141583285984, -0.5564347689094534}}]}}, {
          Arrowheads[{{0.020000000000000007`, 1.}}], {
           LABColor[
           0.6787105785309713, 0.4598814675591637, 0.7512206038479425], 
           
           ArrowBox[{{-0.7857864944578875, -0.5541343874140405}, \
{-0.8084109958010258, -0.5382907548667462}, {-0.8333205263896838, \
-0.5209870493803747}, {-0.8571895068440416, -0.504390083605572}, \
{-0.8816111184882007, -0.4875730496623769}, {-0.9065662040691397, \
-0.4705406830386789}, {-0.917430647297482, -0.46319938633407226`}}]}}, {
          Arrowheads[{{0.011832127757780187`, 1.}}], {
           LABColor[
           0.7273698826541962, 0.3489229381935512, 0.7783655974819067], 
           
           ArrowBox[{{-0.9207449385434273, -0.4609598610412812}, \
{-0.9321122353459218, -0.45327877727080884`}, {-0.9659733494098077, \
-0.4311620230675862}, {-1., -0.4092090338542758}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.21361525056291603`, 0.5225515548891339, -0.797587051359868], 
           
           ArrowBox[{{0.6247309889411997, 0.7152927611359171}, {
            0.6467031795122749, 0.7419417327433324}, {0.6635855186389296, 
            0.760543731694481}, {0.6810486276294456, 0.7781924736991749}, {
            0.699092506483823, 0.7948879587574139}, {0.7177171552020616, 
            0.8106301868691983}, {0.73712585929177, 0.8253298009431327}, {
            0.7389541165617547, 0.8265459750537578}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.20892568364553898`, 0.5225599285279161, -0.808794860623778], 
           
           ArrowBox[{{0.7422845558866293, 0.8287614149431091}, {
            0.7575219042605563, 0.8388974438878216}, {0.7789052901084211, 
            0.8513331157032653}, {0.8012760168353638, 0.8626368163894634}, {
            0.8249041311768703, 0.8726723387584681}, {0.8500596798684262, 
            0.8813034756223305}, {0.8767426629100319, 0.8885302269810512}, {
            0.8884832474038369, 0.8909533736260918}}]}}, {
          Arrowheads[{{0.01354082807534628, 1.}}], {
           LABColor[
           0.2228108715557785, 0.5225351352900687, -0.7756100185193053], 
           
           ArrowBox[{{0.8924006818390138, 0.8917618953920886}, {
            0.9049530803016868, 0.8943525928346298}, {0.9215859917290736, 
            0.8972918828930078}, {0.9388170888702364, 0.899716560888774}, {
            0.9742771816011013, 0.9011988801148628}, {1., 
            0.9007281305986446}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.19634309569474387`, 0.5225823958576935, -0.8388665598411044], 
           
           ArrowBox[{{0.8006648858613382, -0.9981369714386574}, {
            0.8216379256146634, -0.9866649538684849}, {
            0.8450701400449798, -0.9767063206856741}, {
            0.8709615291522884, -0.9682610718902255}, {
            0.8993120929365886, -0.9613292074821388}, {
            0.9142808165965497, -0.9582043266779}, {
            0.9299302233989841, -0.9555440859009446}, {
            0.9529342723985427, -0.9541071762752484}}]}}, {
          Arrowheads[{{0.005386012762568028, 1.}}], {
           LABColor[
           0.22792082845836265`, 0.5225260110075818, -0.7633975001098234], 
           
           ArrowBox[{{0.9569264918225628, -0.953857808934813}, {
            0.9643586886663765, -0.9533935691314136}, {
            1., -0.9534817378937528}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.1960646298405994, 0.5225828930832406, -0.8395320780509412], 
           
           ArrowBox[{{0.6441072224163584, -0.9700862967617184}, {
            0.6522073953653396, -0.9497210733771009}, {
            0.6621177298278934, -0.9299857203380566}, {
            0.67383822580402, -0.9108802376445853}, {
            0.6873688832937195, -0.8924046252966872}, {
            0.7028995008999409, -0.8747907105965441}, {
            0.7206198772256334, -0.858270320846338}, {
            0.7387811697420739, -0.844198502467722}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.2075354173334234, 0.5225624109720551, -0.812117521314362], 
           
           ArrowBox[{{0.7420298143360273, -0.8418707286231177}, {
            0.7626299060354321, -0.8285101161957373}, {
            0.7870960110739059, -0.8155448622284053}, {
            0.8141047799405862, -0.8042222550771356}, {
            0.843656212635473, -0.7945422947419285}, {
            0.8757503091585662, -0.7865049812227838}, {
            0.8897171471217843, -0.7834843527055804}}]}}, {
          Arrowheads[{{0.013346240892239191`, 1.}}], {
           LABColor[
           0.23542992056218745`, 0.5225126028558339, -0.7454511793668677], 
           
           ArrowBox[{{0.8936281300738513, -0.7826457747162182}, {
            0.9118884830239632, -0.7793984359143855}, {
            0.9495235573397689, -0.7765669922913431}, {
            0.9899369989352444, -0.7759976594532975}, {
            1., -0.7761523069686977}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.016435598238028672`, 1.}}], {
           LABColor[
           0.6683457829862159, 0.4835164638161773, 0.745438517273765], 
           
           ArrowBox[{{-0.6807192232083086, 
            0.9286565487457067}, {-0.7050900785915444, 
            0.9450884404298232}, {-0.730222297389907, 
            0.9617631909035724}, {-0.7569355748387059, 
            0.978692708328869}, {-0.78445262570953, 
            0.9958806619536122}, {-0.7911477940888966, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.018059206230432508`, 1.}}], {
           LABColor[
           0.20325231882377684`, 0.5225700588253475, -0.8223538932438846], 
           
           ArrowBox[{{0.6156833770536783, 0.867453281307786}, {
            0.6254136277091875, 0.8897961272425364}, {0.6348827763111051, 
            0.9115627614682036}, {0.644090822859431, 0.9327531839847873}, {
            0.6530377673541649, 0.9533673947922879}, {0.6577534388533466, 
            0.9642393271946493}, {0.6624000101991008, 0.9749634963831936}, {
            0.6731633577603785, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25685616776809683`, 0.5224743443859746, -0.694243616673736], 
           
           ArrowBox[{{0.2654252522828865, 0.43522806069026493`}, {
            0.26577631944762403`, 0.46746391209058097`}, {
            0.26488949274660123`, 0.49970580510129176`}, {
            0.26263651075317807`, 0.5320186753039486}, {0.25902790213181354`, 
            0.5644095334992868}, {0.25433071799401036`, 
            0.5945715531654762}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2611138620098273, 0.5224667418942619, -0.6840679595595277], 
           
           ArrowBox[{{0.25363521554771784`, 0.5985093796579052}, {
            0.2471474852440397, 0.6297197110627017}, {0.2382860579057118, 
            0.6629079210678406}, {0.23185937611443339`, 0.6830946519949815}, {
            0.2245735861744989, 0.7034842726514402}, {0.21642868808590832`, 
            0.7240767830372166}, {0.20742468184866159`, 0.7448721831523106}, {
            0.20479876783614165`, 0.7504096870060594}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2815773707208749, 0.5224302024796031, -0.635161289381961], 
           
           ArrowBox[{{0.2030848842354814, 0.7540239093295181}, {
            0.19744235923195777`, 0.7659228153115543}, {0.18636251200499576`, 
            0.7872810218297797}, {0.17418514016777553`, 0.8089468027069867}, {
            0.1609102437202972, 0.8309201579431753}, {0.14637638778039036`, 
            0.8532680605098066}, {0.13042213746588457`, 0.8760574833783412}, {
            0.11978082975018439`, 0.890285550727402}}]}}, {
          Arrowheads[{{0.01758810425934315, 1.}}], {
           LABColor[
           0.3199018817693171, 0.5223617706568614, -0.5435677973748557], 
           
           ArrowBox[{{0.1173851174017792, 0.8934887619823303}, {
            0.11304749277678, 0.8992884265487798}, {0.09425245371307658, 
            0.9229608900211218}, {0.07484550742858119, 0.9467337119164145}, {
            0.053843983006261024`, 0.971016043457763}, {0.029115139295162747`,
             0.9965946614298841}, {0.025640104029314843`, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24233289506795835`, 0.5225002769809605, -0.7289534466385781], 
           
           ArrowBox[{{0.35117333723783767`, 0.5773559183791722}, {
            0.3519707720578378, 0.6136862026247247}, {0.35147540281230705`, 
            0.6363340105547343}, {0.3501915198462814, 0.6590391494263598}, {
            0.348119123159761, 0.6818016192396014}, {0.34525821275274576`, 
            0.7046214199944589}, {0.34148291561434324`, 0.7275638354693041}, {
            0.33961584116552734`, 0.7365318570880912}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.24674008193877942`, 0.5224924075568639, -0.718420510290972], 
           
           ArrowBox[{{0.3388005528871454, 0.7404478888835614}, {
            0.3366673587336608, 0.7506941494425082}, {0.33081154211069863`, 
            0.7740123619140717}, {0.3239154657454566, 0.797518472883994}, {
            0.3158001067433437, 0.8212984146395795}, {0.30628644220976886`, 
            0.8454381194681314}, {0.29537447214473217`, 0.8699375873696504}, {
            0.28512254298301604`, 0.8906402168897931}}]}}, {
          Arrowheads[{{0.015761128464663213`, 1.}}], {
           LABColor[
           0.2691575649511347, 0.5224523791473198, -0.6648439480612227], 
           
           ArrowBox[{{0.2833474683731539, 0.8942247824324249}, {
            0.28306419654823356`, 0.8947968183441359}, {0.2720196541847879, 
            0.9160541350509466}, {0.25981327446987046`, 0.93763905807304}, {
            0.24091971676230417`, 0.965589541622026}, {0.21960740101762644`, 
            0.9943242529527558}, {0.21520119385043635`, 1.}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.2539367205156714, 0.5224795573186753, -0.7012209364428571], 
           
           ArrowBox[{{0.4129568128053834, 0.008427880659598411}, {
            0.4312674248260852, 0.03362532503483267}, {0.4502570527914265, 
            0.058038772571147944`}, {0.46996784760931976`, 
            0.0816119161206138}, {0.4904419601876775, 0.10428844853529987`}, {
            0.5145558361941637, 0.12878182245113118`}, {0.5162235681530203, 
            0.1303239452328244}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.25016733827940146`, 0.5224862878858759, -0.7102295544861014], 
           
           ArrowBox[{{0.519160430484815, 0.13303961083154706`}, {
            0.539680820057443, 0.15201445872668848`}, {0.5658169117775155, 
            0.17398635736197174`}, {0.5929641113543811, 
            0.19469751835698104`}, {0.6212666389698499, 
            0.21403167959951097`}, {0.646519788216178, 
            0.22925152084224346`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.2515003461841258, 0.5224839076817153, -0.7070437382675345], 
           
           ArrowBox[{{0.6499456862462217, 0.2313162781373613}, {
            0.650868714805731, 0.23187257897735586`}, {0.6817703388620255, 
            0.24822021649051598`}, {0.7139715111387326, 
            0.26307459213899115`}, {0.7476844104370983, 
            0.27628612483450854`}, {0.783121215558368, 0.287705233488795}, {
            0.7977003194151315, 0.29148202976647897`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.26384315187750546`, 0.5224618685044828, -0.6775451055728383], 
           
           ArrowBox[{{0.8015724986566953, 0.29248513889374395`}, {
            0.8202819265025422, 0.2973319181018508}, {0.8591665432696207, 
            0.30516617867367574`}, {0.8834535648802425, 0.3094056523304373}, {
            0.9084710732084896, 0.3129138233431919}, {0.950879227716032, 
            0.3152347007151451}, {0.9594968441574444, 
            0.31538028071289637`}}]}}, {
          Arrowheads[{{0.0039992860386299746`, 1.}}], {
           LABColor[
           0.2872636413482473, 0.5224200491377082, -0.6215714125900526], 
           
           ArrowBox[{{0.9634962735122709, 0.31544784428113365`}, {
            0.9729087983667805, 0.315606852906833}, {0.9954886979488474, 
            0.3154534807689953}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.37453315553436006`, 0.5222642216591005, -0.4130020314969417], 
           
           ArrowBox[{{-0.19889403807276249`, -0.32079133369989066`}, \
{-0.2113558790021219, -0.3015290621804768}, {-0.2240488617269054, \
-0.2820751018738931}, {-0.23702224455628218`, -0.2624210414047534}, \
{-0.2503252857994213, -0.24255846939767134`}, {-0.264007243765492, \
-0.2224789744772607}, {-0.2781173767636634, -0.20217414526813532`}, \
{-0.28816396616370515`, -0.18802904225287626`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4015611011917313, 0.5222159608584874, -0.3484067149015712], 
           
           ArrowBox[{{-0.29048020044576434`, -0.1847678984733698}, \
{-0.29270494310310446`, -0.18163557039490907`}, {-0.30774065727612215`, \
-0.16088159881708317`}, {-0.3232237951629731, -0.13992084846329067`}, \
{-0.33924645715475144`, -0.11873031141184313`}, {-0.3559007436425511, \
-0.09728697974105223}, {-0.37327875501746616`, -0.07556784552922942}, \
{-0.38788974807934706`, -0.057885811606968124`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4464454010188789, 0.5250892894218179, -0.15003188285314864`], 
           
           ArrowBox[{{-0.3904376983464692, -0.05480231530629379}, \
{-0.3914725916705907, -0.05354990085468621}, {-0.41057435399301867`, \
-0.031210137795734227`}, {-0.4306761423758442, -0.008525548430685037}, \
{-0.4560025668653187, 0.018902514511902627`}, {-0.4829565613904081, 
            0.04685752217725631}, {-0.49889931319757985`, 
            0.06274471047106212}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5058997764080216, 0.5289634407221036, 0.11483884192097744`], 
           
           ArrowBox[{{-0.5017326734117034, 
            0.06556819588753264}, {-0.5115381259511124, 
            0.075339474565376}, {-0.5417472605474314, 
            0.10434837167626171`}, {-0.5575266105055757, 
            0.11906856458087586`}, {-0.5738417407658822, 
            0.13395677382244967`}, {-0.590692651328351, 
            0.14901299940098317`}, {-0.608079342192982, 
            0.16423724131647618`}, {-0.6193836380434596, 
            0.17394564812452107`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.5757340684131589, 0.5335139655809626, 0.4259523540287255], 
           
           ArrowBox[{{-0.6224181414935288, 
            0.1765517541875044}, {-0.6260018133597749, 
            0.17962949956892882`}, {-0.6444600648287304, 
            0.1951897741583412}, {-0.6634540965998479, 
            0.21091806508471314`}, {-0.6829839086731276, 
            0.22681437234804475`}, {-0.7031250272211513, 
            0.2429020394182027}, {-0.7239529784165006, 
            0.25920440976505393`}, {-0.7454677622591754, 
            0.27572148338859825`}, {-0.7470181661404391, 
            0.2768899123567435}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.6501667826886749, 0.5249703065025426, 0.7352972122090868], 
           
           ArrowBox[{{-0.7502125934584071, 
            0.279297324683334}, {-0.767669378749176, 
            0.29245326028883567`}, {-0.7905578278865022, 
            0.3093997404657664}, {-0.814133109671154, 
            0.3265609239193903}, {-0.8383952241031314, 
            0.34393681064970727`}, {-0.8633441711824344, 
            0.3615274006567174}, {-0.8797959372258727, 
            0.3731319566495832}}]}}, {
          Arrowheads[{{0.017597632447908993`, 1.}}], {
           LABColor[
           0.7079853150565709, 0.39312585378753284`, 0.7675517567680701], 
           
           ArrowBox[{{-0.8830645999493956, 
            0.37543756806520645`}, {-0.8869422572693493, 
            0.3781727450286849}, {-0.9112279901072003, 
            0.3950333652668874}, {-0.936183464645708, 
            0.4121034742745071}, {-0.9618623960357099, 
            0.4294004333419971}, {-0.9962076199581709, 
            0.45141098856909145`}, {-1., 0.45379944381897125`}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.42448719134172913`, 0.523658453995226, -0.24785625446350132`], 
           
           ArrowBox[{{-0.29013251255099815`, -0.45253699981513523`}, \
{-0.3078183507280607, -0.4321582488619181}, {-0.32583358268410606`, \
-0.41153216434335005`}, {-0.34426478597062465`, -0.3906395141911109}, \
{-0.3631985381391069, -0.36946106633688025`}, {-0.3827214167410433, \
-0.3479775887123378}, {-0.3965385225838991, -0.3330597179627429}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.4658508310534849, 0.5263537812528917, -0.06358020820048192], 
           
           ArrowBox[{{-0.3992566061433801, -0.33012509332513096`}, \
{-0.4029199993279243, -0.3261698492491631}, {-0.42388086345124043`, \
-0.3040186158790357}, {-0.4456905866624819, -0.28150465653363554`}, \
{-0.47271391406860575`, -0.25437055902372263`}, {-0.5010936190129102, \
-0.22669687297507182`}, {-0.5118539030583843, -0.21648763143856234`}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.5183376995934065, 0.5297739175956073, 0.17025009983488043`], 
           
           ArrowBox[{{-0.5147556545836832, -0.21373448086414307`}, \
{-0.5308297014953953, -0.19848359838768312`}, {-0.561922161516061, \
-0.16973073526155652`}, {-0.578041896326179, -0.15513672109389148`}, \
{-0.5946304519667764, -0.14037733598639168`}, {-0.611687828437854, \
-0.12545257993905728`}, {-0.629214025739411, -0.11036245295188829`}, \
{-0.6336013375793271, -0.1066430553837468}}]}}, {
          Arrowheads[{{0.020000000000000004`, 1.}}], {
           LABColor[
           0.5814121220476418, 0.5338839575071606, 0.45124822454503605`], 
           
           ArrowBox[{{-0.6366524614337837, -0.10405642761292906`}, \
{-0.6472090438714477, -0.09510695502488462}, {-0.6656728828339643, \
-0.07968608615804626}, {-0.6846055426269606, -0.0640998463513733}, \
{-0.7040070232504366, -0.04834823560486566}, {-0.7239534847853738, \
-0.03241088454380838}, {-0.7445210873127535, -0.016267423793486453`}, \
{-0.7610775436124629, -0.003492199616139566}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.6503828907826208, 0.5240078310322086, 0.7346373633840558], 
           
           ArrowBox[{{-0.7642443857776599, -0.001048613992362342}, \
{-0.7657098308325758, 0.00008214664610014334}, {-0.7875197153448403, 
            0.016637826774951372`}, {-0.8099507408495477, 
            0.033399616593067234`}, {-0.8330029073466976, 
            0.05036751610044776}, {-0.85667621483629, 
            0.06754152529709292}, {-0.880970663318325, 
            0.08492164418300277}, {-0.8931885751190634, 
            0.0936643563694298}}]}}, {
          Arrowheads[{{0.01570589062292542, 1.}}], {
           LABColor[
           0.7055288639093805, 0.3987273355937766, 0.7661814052607044], 
           
           ArrowBox[{{-0.8964415393059725, 
            0.09599206425460068}, {-0.9028242724717115, 
            0.10055932582440885`}, {-0.9252467548732377, 
            0.11638216048855818`}, {-0.9482230329340282, 
            0.13238567273160895`}, {-0.9717983394207079, 
            0.1485832888850864}, {-1., 0.1671260429163135}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.015967151774877807`, 1.}}], {
           LABColor[
           0.7064843652854678, 0.39654849170342904`, 0.7667144395742541], 
           
           ArrowBox[{{-0.8944595703288236, 
            0.195674501357058}, {-0.9175111927855144, 
            0.2119338335395303}, {-0.9411609835380144, 
            0.2283845575667091}, {-0.965457570755088, 
            0.24504160690256874`}, {-0.9971706705066505, 
            0.26578885611040176`}, {-1., 0.2676098392648773}}]}}}}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.25225159860508434`, 0.5224825662537075, -0.7052482859386735], 
           
           ArrowBox[{{0.40895748777441676`, -0.12792172003103547`}, {
            0.42707543401499337`, -0.10163282190667029`}, {
            0.4462835299780131, -0.07615605857228895}, {
            0.46659271854078554`, -0.051568691975383635`}, {
            0.4880139425806205, -0.027947984063446514`}, {
            0.5109284360688515, -0.00505858826389749}}]}}, {
          Arrowheads[{{0.02, 1.}}], {
           LABColor[
           0.252190496404466, 0.5224826753571206, -0.705394316866945], 
           
           ArrowBox[{{0.5138397527654933, -0.0023174245753290277`}, {
            0.5374609817885101, 0.018975406961983857`}, {0.5640162071383104, 
            0.04056256693727787}, {0.5917925696520141, 
            0.060900036554291076`}, {0.620883844912992, 
            0.07985907517081986}, {0.6424317553077797, 
            0.09218863958634502}}]}}, {
          Arrowheads[{{0.019999999999999993`, 1.}}], {
           LABColor[
           0.2561578609563261, 0.5224755912748886, -0.6959125318831587], 
           
           ArrowBox[{{0.6459035839894046, 0.09417519580388506}, {
            0.651383808504614, 0.09731094214466054}, {0.6832924604268806, 
            0.11325563747581319`}, {0.7166098006797914, 0.1276931611642777}, {
            0.7515095404687888, 0.14047015902697985`}, {0.7881653909993152, 
            0.15143327688084524`}, {0.7942736804507097, 
            0.15288819329662706`}}]}}, {
          Arrowheads[{{0.019999999999999997`, 1.}}], {
           LABColor[
           0.26949908488703067`, 0.5224517693331023, -0.6640277340336199], 
           
           ArrowBox[{{0.7981648246583649, 0.1538150140750038}, {
            0.8265773522713703, 0.16058251472587393`}, {0.8667454242849543, 
            0.1679178725620659}, {0.8922445931516204, 0.17191141159445675`}, {
            0.9184993181404879, 0.17514056881040826`}, {0.9561640547807014, 
            0.17671686060566322`}}]}}, {
          Arrowheads[{{0.004980302344400544, 1.}}], {
           LABColor[
           0.29250279294420295`, 0.5224106941666068, -0.6090501259069265], 
           
           ArrowBox[{{0.9601605564301816, 0.17688411659420164`}, {
            0.9605757549623398, 0.17690149290153906`}, {0.9823625563772274, 
            0.17704561428647758`}, {1., 0.1767711721357453}}]}}}}}}}, {
    DisplayFunction -> Identity, PlotRange -> {{-1, 1}, {-1, 1}}, 
     DisplayFunction -> Identity, AspectRatio -> 1, Frame -> True, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Small, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, DisplayFunction -> 
     Identity, AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> Small, 
     Method -> {
      "VectorLengthFunction" -> 
       Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
         System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
         System`VectorPlotsDump`imin = If[
            NumericQ[System`VectorPlotsDump`min], System`VectorPlotsDump`min, 
            
            Min[System`VectorPlotsDump`m], 
            Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
            NumericQ[System`VectorPlotsDump`max], System`VectorPlotsDump`max, 
            
            Max[System`VectorPlotsDump`m], 
            Max[System`VectorPlotsDump`m]]; Map[If[
            
            Or[# > System`VectorPlotsDump`imax, # < 
             System`VectorPlotsDump`imin], #, System`VectorPlotsDump`imax]& , 
           System`VectorPlotsDump`m]], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "TransparentPolygonMesh" -> True}, PlotRange -> {{-1, 1}, {-1, 1}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], "\"Fig. 2.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->69031813,ExpressionUUID->"104fd843-6421-401b-be93-e529d1f4216d"],

Cell[TextData[{
 "In general, the vector field describing a fluid flow varies in time, but \
the discussion in this chapter will deal only with fields in a stationary \
state, i.e. those that do not vary with time: then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "F"}], 
     RowBox[{"\[PartialD]", "t"}]], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b4071871-f383-4b02-b5d2-3b96b050e358"],
 " and ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath",ExpressionUUID->
  "58064564-4a92-4be1-91f8-1973af0e5179"],
 " is a function only of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2e689499-a717-43b8-a6f5-f72322536f73"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e5ab0c13-ed45-4089-82ff-78d5e6288662"],
 ", not ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a74ae8d5-36c8-48e8-9838-7324c88d2c8b"],
 "."
}], "Text",
 CellID->93869886,ExpressionUUID->"2d4348d2-5dbf-435b-8ea2-d1faf0c6d952"],

Cell[TextData[{
 "Two important properties of vector fields are the ",
 StyleBox["divergence",
  FontSlant->"Italic"],
 " and the ",
 StyleBox["curl",
  FontSlant->"Italic"],
 ". In two dimensions, the divergence is"
}], "Text",
 CellID->314369978,ExpressionUUID->"d0d65431-8746-4be3-8652-79781679e63e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[Del]", "\[CenterDot]", 
    RowBox[{"F", "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "\[CapitalPhi]"}], 
     RowBox[{"\[PartialD]", "x"}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"\[PartialD]", "\[CapitalPsi]"}], 
      RowBox[{"\[PartialD]", "y"}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->180420225,ExpressionUUID->"3cd9e754-ed90-4238-a836-55e9faccb79d"],

Cell[TextData[{
 "In Wolfram Language, the divergence can be computed with the command ",
 ButtonBox["Div",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->181589327,ExpressionUUID->"55a203b8-40dc-443b-875b-21bbbf615d91"],

Cell[TextData[{
 "A positive or negative divergence of ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c90ba869-52af-4afb-913b-1540a27f4fbf"],
 " is associated with the presence of sources or sinks of fluid. In Fig. 3 \
the two fields"
}], "Text",
 CellID->264160732,ExpressionUUID->"9fb4a2ff-c066-47a1-be21-7ea65f5e3a28"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["F", "1"], "(", 
        RowBox[{"x", ",", "y"}], ")"}], "\[AlignmentMarker]", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "x"}], ",", 
         RowBox[{"2", "y"}]}], ")"}]}], ","}]},
    {
     RowBox[{
      RowBox[{
       SubscriptBox["F", "2"], "(", 
       RowBox[{"x", ",", "y"}], ")"}], "\[AlignmentMarker]", "=", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "+", "y"}], ",", 
        RowBox[{"x", "-", "y"}]}], ")"}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->538759814,ExpressionUUID->"3d6d6240-1352-425c-b7e3-e6255e655d7a"],

Cell[TextData[{
 "are plotted. Their divergences are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Del]", "\[CenterDot]", 
     SubscriptBox["F", "1"]}], "=", "4"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a5259c0f-9291-40c0-906d-1fb49bbde86a"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Del]", "\[CenterDot]", 
     SubscriptBox["F", "2"]}], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dced30db-7acd-43eb-8008-f652766a1270"],
 ":"
}], "Text",
 CellID->426454610,ExpressionUUID->"81a417f0-9265-4244-af1f-b06c5c6c3734"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Div", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "x"}], ",", 
       RowBox[{"2", "y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"Div", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "+", "y"}], ",", 
       RowBox[{"x", "-", "y"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellID->420526946,ExpressionUUID->"12d538ea-cecc-44f1-8cb8-e669178c0cbf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "0"}], "}"}]], "Output",
 CellID->108037005,ExpressionUUID->"f1cbb93f-1c61-4146-80ce-44ed168cac2f"]
}, Open  ]],

Cell[TextData[{
 "The field ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["F", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "37ebabb1-67da-45ea-9b1d-afcc2c1036f1"],
 " is divergenceless or source free."
}], "Text",
 CellID->82608895,ExpressionUUID->"5b7163f2-898f-4fd4-96eb-0a91e4fb8657"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     GraphicsBox[{{{{}}, {{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.18873570695564684`, 0.5225959795268253, -0.8570478041833658], 
             
             ArrowBox[{{-0.00012449100373488147`, -0.00012449100736160488`}, \
{-0.0006552759612646528, -0.0006552759803544233}, {-0.0011441599382909535`, \
-0.0011441599716230945`}, {-0.001998515577709522, -0.0019985156359311057`}, \
{-0.0034636160913870256`, -0.0034636161922905243`}, {-0.005963253323799734, \
-0.005963253497523699}, {-0.010404792635658714`, -0.010404792938775442`}, \
{-0.01860350817348169, -0.018603508715446793`}, {-0.02477177303875497, \
-0.02477177376041652}, {-0.03298941108429734, -0.032989412045358525`}, \
{-0.043955709976223355`, -0.0439557112567593}, {-0.050796281722966276`, \
-0.0507962832027846}, {-0.05869830547792422, -0.05869830718794757}, \
{-0.08376587062122066, -0.0837658730615227}, {-0.10004483511043687`, \
-0.10004483802498443`}, {-0.1132615743456043, -0.11326157764518739`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2598939628240853, 0.5224689201327458, -0.6869834521062559], 
             
             ArrowBox[{{-0.11609000142915103`, -0.11609000481113303`}, \
{-0.11942435542867856`, -0.11942435890779834`}, {-0.13226738784655004`, \
-0.13226739169981838`}, {-0.1463649747083438, -0.14636497897230885`}, \
{-0.16200920455312937`, -0.16200920927284862`}, {-0.1794921659199763, \
-0.17949217114901642`}, {-0.20418013396509077`, -0.204180139913351}, \
{-0.22922708477102044`, -0.2292270914489588}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.33097241134076383`, 0.5223420032417903, -0.517109835248867], 
             
             ArrowBox[{{-0.2320555118545672, -0.23205551861490445`}, \
{-0.23224806267424244`, -0.2322480694401892}, {-0.247676297217814, \
-0.24767630443322247`}, {-0.2642030918073584, -0.2642030995042323}, \
{-0.2818284464428757, -0.2818284546532187}, {-0.3005523611243658, \
-0.3005523698801817}, {-0.32053753157800075`, -0.32053754091603287`}, \
{-0.34194665352995235`, -0.3419466634916839}, {-0.3451925951964366, \
-0.34519260525273027`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.40280800708481046`, 0.5224237275483081, -0.33894916081571247`], 
             
             ArrowBox[{{-0.3480210222799833, -0.34802103241867594`}, \
{-0.3647797269802207, -0.36477973760713484`}, {-0.3890367519288058, \
-0.3890367632623856}, {-0.4101047007589732, -0.4101047127063132}, \
{-0.43231355403191757`, -0.4323135666262551}, {-0.4611581056218527, \
-0.4611581190565017}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4831058595605242, 0.5274781491516287, 0.013291374029483551`], 
             
             ArrowBox[{{-0.46398653270539947`, -0.4639865462224474}, \
{-0.47781120074918926`, -0.47781121466898313`}, {-0.4940053612684211, \
-0.49400537565999}, {-0.5102177914376398, -0.5102178063015159}, \
{-0.526980900046903, -0.5269809153991288}, {-0.5442946870962106, \
-0.5442947029528289}, {-0.5621591525855626, -0.5621591689626159}, \
{-0.5771236160472689, -0.5771236328602731}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5638999995414821, 0.5327428369128571, 0.37323128213869383`], 
             
             ArrowBox[{{-0.5799520431308156, -0.5799520600262188}, \
{-0.5806117468214462, -0.5806117637360682}, {-0.5996899201103487, \
-0.5996899375807639}, {-0.6193936724522704, -0.6193936904967033}, \
{-0.6397230038472106, -0.6397230224838861}, {-0.6607211295851352, \
-0.6607211488335367}, {-0.6824312649560091, -0.6824312848368794}, \
{-0.693089126472685, -0.6930891466640446}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6435163518845445, 0.5315167584245343, 0.7172667928562763], 
             
             ArrowBox[{{-0.6959175535562316, -0.6959175738299903}, \
{-0.7048534099598325, -0.7048534304939142}, {-0.7279875645966056, \
-0.727987585804641}, {-0.7441946754205071, -0.7441946971006947}, \
{-0.7607605240894125, -0.7607605462522034}, {-0.7776942298264355, \
-0.777694252482546}, {-0.7950049118546902, -0.7950049350151027}, \
{-0.8090546368981011, -0.809054660467816}}]}}, {
            Arrowheads[{{0.009955484390646236, 1.}}], {
             LABColor[
             0.7020324120349409, 0.4067003464079671, 0.7642308807806837], 
             
             ArrowBox[{{-0.8118830639816478, -0.8118830876337617}, \
{-0.8127016893972909, -0.8127017130732533}, {-0.8307936816773516, \
-0.8307937058803774}, {-0.8492900079179863, -0.8492900326598547}, \
{-0.868199787342309, -0.868199812635065}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.36285775516043184`, 0.5222850691247816, -0.44090560186415245`], 
             
             ArrowBox[{{-0.30794724774662013`, -0.2574227182010823}, \
{-0.3366916186551027, -0.28145103521442355`}, {-0.36793398729392257`, \
-0.3075675065155817}, {-0.38463569227190053`, -0.32152898311744815`}, \
{-0.40213442249409265`, -0.3361567180032962}, {-0.4204876865643755, \
-0.35149878441046817`}, {-0.4307056662529001, -0.3600403126273649}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.43831597355993096`, 0.5245595616809321, -0.18624868487918506`], 
             
             ArrowBox[{{-0.43377462671555705`, -0.36260575248802196`}, \
{-0.43975299308662574`, -0.3676032555763064}, {-0.46472892132715393`, \
-0.3884814137164371}, {-0.4912047519053207, -0.41061338704607314`}, \
{-0.5191804848211261, -0.4339991755652146}, {-0.5486561200745702, \
-0.4586387792738615}, {-0.556533045221837, -0.4652233469143045}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5190116125372927, 0.5298178309441329, 0.1732523988030134], 
             
             ArrowBox[{{-0.559602005684494, -0.46778878677496155`}, \
{-0.579819890624771, -0.4846895479789881}, {-0.6128600294308463, \
-0.5123088314875686}, {-0.6300837369298371, -0.5267066662931542}, \
{-0.6477765364927964, -0.5414966297996031}, {-0.6659384281197245, \
-0.5566787220069156}, {-0.682360424190774, -0.5704063812012441}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5997733466861981, 0.5350804070845502, 0.5330479381224333], 
             
             ArrowBox[{{-0.685429384653431, -0.5729718210619013}, \
{-0.7037278797703322, -0.5882681043911087}, {-0.7234722242037033, \
-0.6047730183019444}, {-0.7438024451107343, -0.6217676846475989}, \
{-0.7647185424914253, -0.639252103428072}, {-0.7862205163457765, \
-0.6572262746433639}, {-0.808187803159711, -0.6755894154881839}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6702187890629595, 0.4792454204152684, 0.7464833891424795], 
             
             ArrowBox[{{-0.811256763622368, -0.6781548553488409}, \
{-0.8309820934754585, -0.6946438743784036}, {-0.8542416967507895, \
-0.7140873028981516}, {-0.8738611446580525, -0.7304878119036671}, \
{-0.8939418476094961, -0.7472738984005414}, {-0.9144736567686484, \
-0.7644370786595307}, {-0.934015182128648, -0.7807724497751235}}]}}, {
            Arrowheads[{{0.010250353201719745`, 1.}}], {
             LABColor[
             0.7276757531385363, 0.3482254572137004, 0.7785362298511901], 
             
             ArrowBox[{{-0.937084142591305, -0.7833378896357805}, \
{-0.9613477501884461, -0.8036205967121552}, {-0.9879019685932343, \
-0.8258180968732549}, {-1., -0.8359312190147917}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2088891419022435, 0.5225599937764485, -0.8088821933980497], 
             
             ArrowBox[{{0.03299030585699544, -0.03298750766677755}, {
              0.04395702101406545, -0.04395329264286627}, {
              0.050797866406741714`, -0.05079355780489106}, {
              0.05870021700377106, -0.05869523813592667}, {
              0.08376847019499252, -0.08376136507402507}, {
              0.1000478651350919, -0.10003937921929729`}, {
              0.11942788374202325`, -0.1194177540409687}, {
              0.13227132468066977`, -0.1322601056174567}, {
              0.14613218901086328`, -0.14611979428910532`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.28016052597759855`, 0.5224327323818948, -0.6385474710740003], 
             
             ArrowBox[{{0.14896073608970997`, -0.1489481014546635}, {
              0.1620140958217398, -0.16200035401952517`}, {
              0.17949762503862582`, -0.1794824003086493}, {
              0.20418640857267906`, -0.20416908977564913`}, {
              0.2322552731852091, -0.23223557362751798`}, {
              0.2476840257245914, -0.24766301752233613`}, {
              0.2621026192435778, -0.26208038807699124`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3513935366277055, 0.5223055395065045, -0.4683044591442287], 
             
             ArrowBox[{{0.26493116632242447`, -0.26490869524254945`}, {
              0.2818373305843444, -0.28181342554797123`}, {
              0.3005618829047151, -0.30053638967878815`}, {
              0.3205477372445849, -0.3205205488472839}, {
              0.3419575956964569, -0.34192859134580444`}, {
              0.36479145826033094`, -0.3647605171743497}, {
              0.3780730494762923, -0.37804098186487717`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.42536094136050856`, 0.5237153890777867, -0.24396367634404856`], 
             
             ArrowBox[{{0.380901596555139, -0.3808692890304354}, {
              0.3890493249362072, -0.38901632633291966`}, {
              0.41011799362566725`, -0.41008320800825243`}, {
              0.43232760785160684`, -0.43229093844670796`}, {
              0.4621463023210128, -0.462107103737405}, {
              0.4778268884993599, -0.4777863599110215}, {
              0.49402163397346993`, -0.4939797317701501}, {
              0.4940434797090068, -0.49400157565276315`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5059824762867389, 0.5289688295911409, 0.11520727194267393`], 
             
             ArrowBox[{{0.4968720267878535, -0.49682988281832136`}, {
              0.5102346498765364, -0.5101913725085636}, {
              0.5269983659332785, -0.5269536666910591}, {
              0.5443127821436965, -0.5442666143176367}, {
              0.5621778985077901, -0.5621302153882963}, {
              0.580631166932691, -0.5805819186335527}, {
              0.5997100393255306, -0.5996591727839204}, {
              0.6100139099417214, -0.6099621694406491}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5867772655534974, 0.5342335596609699, 0.4751500726363156], 
             
             ArrowBox[{{0.6128424570205682, -0.6127904766062072}, {
              0.6194145156863091, -0.6193619778393997}, {
              0.6397445960150262, -0.6396903337999903}, {
              0.6607434974678026, -0.6606874541561959}, {
              0.6824544372007585, -0.6823965523985198}, {
              0.7048774152138939, -0.7048176285269621}, {
              0.725984340174436, -0.725922763228535}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.660838903494019, 0.5006345119179273, 0.7412507427114616], 
             
             ArrowBox[{{0.7288128872532827, -0.7287510703940933}, {
              0.7442201185407187, -0.7441569948623666}, {
              0.7607865566707483, -0.7607220278509793}, {
              0.7777208654710761, -0.7776549003076296}, {
              0.7950321645154805, -0.7949647310325871}, {
              0.8127295733777395, -0.8126606388261209}, {
              0.8308222116316317, -0.8307517424885003}, {
              0.8419547704071506, -0.841883357016421}}]}}, {
            Arrowheads[{{0.004144590220678274, 1.}}], {
             LABColor[
             0.7183156114340472, 0.36956952649084646`, 0.7733145976975958], 
             
             ArrowBox[{{0.8447833174859973, -0.8447116641819792}, {
              0.8493191988509357, -0.8492471608199945}, {
              0.8682296546094296, -0.8681560126208727}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.20888918108124116`, 0.5225599937064909, -0.8088820997623811], 
             
             ArrowBox[{{-0.03298756297487399, 
              0.032990377711699416`}, {-0.04395335137042158, 
              0.0439571017874135}, {-0.05079361690371019, 
              0.050797950981498974`}, {-0.058695296311608844`, 
              0.05870030461768267}, {-0.08376146425029808, 
              0.08376861138263268}, {-0.1000395070831247, 
              0.10004804317549379`}, {-0.11941791783804658`, 
              0.11942810743620545`}, {-0.1322602833667889, 
              0.13227156876821178`}, {-0.14611982123159406`, 
              0.1461322892287619}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2801605650333449, 0.5224327323121573, -0.6385473777328959], 
             
             ArrowBox[{{-0.14894812768801205`, 
              0.14896083701668847`}, {-0.1620005630234204, 
              0.16201438608003205`}, {-0.17948262682702298`, 
              0.17949794157942345`}, {-0.20416933931151615`, 
              0.2041867605123009}, {-0.2322358482278789, 
              0.23225566426565927`}, {-0.24766330545252052`, 
              0.24768443787223565`}, {-0.2620803859447321, 
              0.262102748533751}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.35139357568345186`, 0.522305539436767, -0.4683043658031243], 
             
             ArrowBox[{{-0.2649086924011501, 
              0.26493129632167756`}, {-0.28181374185276103`, 
              0.2818377882340505}, {-0.3005367210283599, 
              0.3005623649892889}, {-0.3205208958400204, 
              0.3205482449948982}, {-0.34192895460681855`, 
              0.34195813045169515`}, {-0.3647608973287543, 
              0.3647920213596798}, {-0.37804095065787013`, 
              0.37807320783874004`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4253609848423685, 0.5237153919111409, -0.24396348263127818`], 
             
             ArrowBox[{{-0.38086925711428815`, 
              0.3809017556266666}, {-0.38901672400582765`, 
              0.3890499177188522}, {-0.41008362230781636`, 
              0.410118613600568}, {-0.43229137000749285`, 
              0.43232825622547155`}, {-0.4621075524940756, 
              0.46214698284382}, {-0.47778681738530016`, 
              0.4778275856030259}, {-0.49398019804181376`, 
              0.4940223479955864}, {-0.49400151537100817`, 
              0.4940436671437291}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5059825177123153, 0.528968832290504, 0.1152074564946496], 
             
             ArrowBox[{{-0.4968298218274262, 
              0.4968722149316557}, {-0.5101918475725445, 
              0.5102353808211962}, {-0.5269541506169988, 
              0.5269991141462593}, {-0.5442671071751766, 
              0.5443135479707759}, {-0.5621307172470776, 
              0.5621786822947457}, {-0.5805824295523425, 
              0.5806319690332039}, {-0.5996596928106108, 
              0.5997108601011854}, {-0.6099620800841462, 
              0.6100141264487182}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5867773098125717, 0.5342335625449687, 0.4751502698115944], 
             
             ArrowBox[{{-0.6127903865405642, 
              0.6128426742366447}, {-0.6193625070218831, 
              0.6194153554986904}, {-0.6396908721861592, 
              0.6397454552257188}, {-0.6606880017789869, 
              0.660744376445104}, {-0.682397109275914, 
              0.6824553363196793}, {-0.7048181946769407, 
              0.7048783348494446}, {-0.7259226447972843, 
              0.7259845857537072}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6608389341150274, 0.5006344420923898, 0.7412507597936434], 
             
             ArrowBox[{{-0.7287509512537023, 
              0.7288131335416338}, {-0.7441575802677004, 
              0.7442210771603535}, {-0.7607226233790346, 
              0.7607875337206563}, {-0.777655506118615, 
              0.7777218612959356}, {-0.7949653472889865, 
              0.7950331794668184}, {-0.8126612656926941, 
              0.812730607813932}, {-0.8307523801322834, 
              0.8308232659179036}, {-0.8418832095104224, 
              0.8419550450586962}}]}}, {
            Arrowheads[{{0.004144734087998817, 1.}}], {
             LABColor[
             0.7183156429366412, 0.3695694546550166, 0.7733146152715773], 
             
             ArrowBox[{{-0.8447115159668404, 
              0.8447835928466227}, {-0.849247809410299, 
              0.8493202733593601}, {-0.868156672329286, 
              0.8682307497189286}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.1897856789229927, 0.5225941047085019, -0.8545384284244104], 
             
             ArrowBox[{{0.002007544284919709, 0.0018570898457417307`}, {
              0.003479472140665735, 0.003218704777528737}, {
              0.005990712884127766, 0.00554174179341343}, {
              0.010451450847518732`, 0.009668171899367143}, {
              0.01868428485374477, 0.017284000127660036`}, {
              0.024986840658086113`, 0.023114213923880737`}, {
              0.033420018501058545`, 0.03091537131660277}, {
              0.044724345221850516`, 0.041372500717844984`}, {
              0.051799101821304976`, 0.047917043092643274`}, {
              0.05998960196311393, 0.05549371014759093}, {0.08539192741801219,
               0.07899227056037153}, {0.10186081632678554`, 
              0.09422690652475565}, {0.1194602061998883, 
              0.1105073186033844}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.2609965933769645, 0.5224669512878348, -0.684348225198748], 
             
             ArrowBox[{{0.12239652274776253`, 0.11322357432232547`}, {
              0.13455136862466052`, 0.12446748113130815`}, {
              0.14894421426289967`, 0.1377816618878094}, {
              0.16492224139838466`, 0.15256222347800205`}, {
              0.18278640491363024`, 0.1690875658657339}, {
              0.20803693343053375`, 0.19244570568890046`}, {
              0.23675935659724864`, 0.21901554069014256`}, {
              0.23984918466273114`, 0.22187380307996818`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.33217201792848283`, 0.5223398612375448, -0.5142428409050898], 
             
             ArrowBox[{{0.24278550121060535`, 0.22459005879890925`}, {
              0.25255339792259285`, 0.23362590519808918`}, {
              0.26947715140700484`, 0.24928131613164908`}, {
              0.2875306170504847, 0.2659817734908224}, {0.30671379485303235`, 
              0.283727277275609}, {0.3271947812052916, 
              0.30267332597364643`}, {0.3491416724979063, 
              0.32297541807257235`}, {0.36023816312557394`, 
              0.33324028755655194`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.40409134669771335`, 0.5225193610673131, -0.33286142162405824`], 
             
             ArrowBox[{{0.3631744796734481, 0.335956543275493}, {
              0.37255446873087633`, 0.34463355357238673`}, {
              0.3974331699042018, 0.3676477324730895}, {0.41902156254570266`, 
              0.38761819342958104`}, {0.4417826144506352, 
              0.4086734292660056}, {0.4724233104130713, 
              0.43701777303253697`}, {0.4806271415884167, 
              0.4446067720331357}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.48441164661520836`, 0.5275632365246385, 0.019108687916158676`], 
             
             ArrowBox[{{0.4835634581362909, 0.4473230277520768}, {
              0.48854057553257624`, 0.45192713748312346`}, {
              0.5051891187442724, 0.46732796364525714`}, {0.5218566486944894, 
              0.48274635359394125`}, {0.5390934302139394, 
              0.4986913328272734}, {0.5568994633026224, 0.5151629013452536}, {
              0.5752747479605382, 0.5321610591478816}, {0.5942582111241713, 
              0.5497218158111425}, {0.6010161200512595, 
              0.5559732565097195}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5651598820097279, 0.5328249330625621, 0.3788440899482162], 
             
             ArrowBox[{{0.6039524365991337, 0.5586895122286606}, {
              0.6138887797300059, 0.5678811809110211}, {0.6341664537780421, 
              0.5866391544475176}, {0.6550912332682798, 0.6059957364206318}, {
              0.6767080705322259, 0.6259925102310443}, {0.6990619179013875, 
              0.6466710592794358}, {0.7214050985141023, 
              0.6673397409863033}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6454593212939945, 0.5356181552068394, 0.7325271496203812], 
             
             ArrowBox[{{0.7243414150619765, 0.6700559967052444}, {
              0.7459806429553567, 0.690073483090156}, {0.7626273844338248, 
              0.7054726425490903}, {0.7796434566951258, 0.7212134534732854}, {
              0.7970382721377216, 0.7373046228535355}, {0.8148212431600741, 
              0.7537548576806348}, {0.8330017821606451, 0.7705728649453774}, {
              0.8417940769769451, 0.778706225462887}}]}}, {
            Arrowheads[{{0.007712475265014885, 1.}}], {
             LABColor[
             0.7029288535691094, 0.404656177546824, 0.7647309680749163], 
             
             ArrowBox[{{0.8447303935248193, 0.7814224811818281}, {
              0.8515893015378964, 0.787767351638557}, {0.8705932136902896, 
              0.8053470247509682}, {0.8900229310162868, 
              0.8233205912734045}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.21552489174780692`, 0.5225481450549706, -0.7930231130389417], 
             
             ArrowBox[{{0.002324708049016789, 0.06176008529619711}, {
              0.0026952501488256867`, 0.07160420817421112}, {
              0.003124672589365072, 0.083012594086167}, {0.004362875984302695,
               0.1159077128163367}, {0.005155349109623191, 
              0.1369611985800384}, {0.006088967000271581, 
              0.16176445100775166`}, {0.00675829240696119, 
              0.17954629429149022`}, {0.007493987667099655, 
              0.1990913730971391}, {0.008312267896902426, 
              0.22083047139388437`}, {0.008342997473802925, 
              0.22164685833386746`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.286699342755011, 0.5224210567430305, -0.6229200554631182], 
             
             ArrowBox[{{0.008493454709422579, 0.22564402765980923`}, {
              0.009229348212584951, 0.2451943731509119}, {0.01055301777451446,
               0.28036005560438026`}, {0.012065575869942499`, 
              0.3205439045090194}, {0.012900115063757793`, 0.3427149516712}, {
              0.013796730283026365`, 0.36653516102751715`}, {
              0.014511744134208714`, 0.3855308006974796}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.3579741040559009, 0.5222937893181403, -0.45257726175416213`], 
             
             ArrowBox[{{0.014662201369828367`, 0.3895279700234213}, {
              0.014755421527748225`, 0.3920045325779711}, {
              0.015776188797923363`, 0.4191230663225615}, {
              0.016868651320627107`, 0.44814631447349296`}, {
              0.018042428322934775`, 0.47932982924296963`}, {
              0.019297519804846373`, 0.5126736106309915}, {
              0.020633925766361895`, 0.5481776586375586}, {0.0206804907946145,
               0.5494147430610916}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.43283794092659233`, 0.5242026034737263, -0.21065345684814074`], 
             
             ArrowBox[{{0.02083094803023415, 0.5534119123870334}, {
              0.02178371565747721, 0.5787239122963871}, {0.02299757483876648, 
              0.6109722828415419}, {0.023822221256754594`, 
              0.6328805104728308}, {0.02467527005513768, 
              0.6555432988484465}, {0.025560012865077177`, 
              0.6790480961197298}, {0.026475352476185942`, 
              0.7033657529029009}, {0.02684923745502028, 
              0.7132986854247036}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5134676541389647, 0.5294565768985386, 0.14855392590725883`], 
             
             ArrowBox[{{0.026999694690639932`, 0.7172958547506454}, {
              0.027391843764086446`, 0.7277140060686678}, {
              0.02834123520673969, 0.7529363115115137}, {
              0.029323526804145683`, 0.7790326692314391}, {
              0.03033871855630442, 0.8060030792284437}, {0.03138917548421289, 
              0.8339103725743963}, {0.032477262608868074`, 
              0.862817380341165}, {0.03301798411542606, 
              0.8771826277883157}}]}}, {
            Arrowheads[{{0.013453893389873371`, 1.}}], {
             LABColor[
             0.5942345503079043, 0.5347194894052282, 0.5083724621546396], 
             
             ArrowBox[{{0.03316844135104571, 0.8811797971142574}, {
              0.03360297993026999, 0.8927241025287503}, {
              0.034766327448418614`, 0.9236305391371519}, {
              0.03597005503621732, 0.9556097455270794}, {0.03721691256656946, 
              0.9887347770592423}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.21567477768044158`, 0.5225478774203082, -0.7926648938315161], 
             
             ArrowBox[{{0.0007123166287611039, -0.062145083944672996`}, {
              0.0008253703315546636, -0.07200829865381347}, {
              0.0009563124714281104, -0.08343216543688078}, {
              0.0013358157279768671`, -0.11654140476001462`}, {
              0.0015787714243263818`, -0.13773774011826273`}, {
              0.0018650557885910512`, -0.16271422547733472`}, {
              0.0020699181377430704`, -0.18058715918561816`}, {
              0.00229508227506066, -0.20023129446190466`}, {
              0.0025455023030213067`, -0.22207884515871854`}, {
              0.0025461410813987766`, -0.22213457449913693`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.28685600757011565`, 0.5224207770040705, -0.6225456350961645], 
             
             ArrowBox[{{0.0025919866927147186`, -0.22613431176299853`}, {
              0.002826132324102499, -0.24656202512858413`}, {
              0.0032312041768730333`, -0.28190196144009716`}, {
              0.003694044609943719, -0.3222818380354155}, {
              0.003949397868656563, -0.3445597816598056}, {
              0.004223732921574333, -0.368493765795755}, {
              0.0044258111453523916`, -0.38612380231746246`}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.35812410350562907`, 0.522293521480783, -0.4522187712470719], 
             
             ArrowBox[{{0.004471656756668333, -0.39012353958132406`}, {
              0.004517049768697033, -0.39408379044326364`}, {
              0.004829348410024658, -0.42132985560233155`}, {
              0.005163568268700368, -0.4504884071996783}, {
              0.005522648767867318, -0.48181589116202345`}, {
              0.005906589907525509, -0.5153123074893671}, {
              0.006305481209306005, -0.5501130301357879}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.4330079148992892, 0.5242136792756841, -0.209896218561702], 
             
             ArrowBox[{{0.006351326820621946, -0.5541127673996495}, {
              0.006667183460078126, -0.5816692452087191}, {
              0.007038571162363116, -0.6140704541692086}, {
              0.007290775283371747, -0.6360736556086211}, {
              0.007551659709859526, -0.6588341583532206}, {
              0.007822229644984462, -0.682439659969108}, {
              0.008102150021027217, -0.7068609279342501}, {
              0.00818515127325962, -0.7141022579541135}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5136260490481643, 0.5294668981884255, 0.1492595791771087], 
             
             ArrowBox[{{0.008230996884575561, -0.7181019952179751}, {
              0.008382422082756746, -0.7313128782331245}, {
              0.008672747956777645, -0.7566419595487176}, {
              0.008973127643089912, -0.7828481718810301}, {
              0.009283561141693545, -0.8099315152300612}, {
              0.009604770637402681, -0.8379549956160077}, {
              0.009937478315031448, -0.8669816190590656}, {
              0.010064821337213235`, -0.8780914857724391}}]}}, {
            Arrowheads[{{0.013916079724113586`, 1.}}], {
             LABColor[
             0.594404533918259, 0.5347305658351927, 0.5091297433770842], 
             
             ArrowBox[{{0.010110666948529176`, -0.8820912230363007}, {
              0.010281684174579853`, -0.8970113855592352}, {
              0.010637388216047887`, -0.9280442951165159}, {
              0.011005430056418821`, -0.9601535989590834}, {
              0.011386649312675919`, -0.9934125483151126}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.21619010873260766`, 0.5225469572508853, -0.7914332807119664], 
             
             ArrowBox[{{0.06333484387684285, 0.0004633272530306289}, {
              0.0732374606646444, 0.0005357700341801164}, {
              0.08468382130657892, 0.0006195061028082814}, {
              0.11853624153865289`, 0.0008671541258311998}, {
              0.14023855834232482`, 0.0010259178365083534`}, {
              0.1658368773992536, 0.0012131828256494244`}, {
              0.18399615983912324`, 0.001346027401160385}, {
              0.20395069064807503`, 0.00149200515020489}, {0.2233305627032322,
               0.0016337789722239585`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2873966133504347, 0.5224198117043729, -0.6212536167542719], 
             
             ArrowBox[{{0.22733045567389193`, 0.0016630402652037918`}, {
              0.25098822645946306`, 0.001836109136617158}, {
              0.28683826980804317`, 0.002098370809481245}, {
              0.3277835046866951, 0.0023979064527348964`}, {
              0.35036623607348977`, 0.002563110853012858}, {
              0.3746215995901859, 0.0027405514253983085`}, {
              0.3873261745002813, 0.0028334919843971216`}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.35863983590653076`, 0.5222926005947163, -0.45098619892592523`], 
             
             ArrowBox[{{0.391326067470941, 0.0028627532773769547`}, {
              0.40054959523678363`, 0.0029302281698912495`}, {
              0.42815022301328276`, 0.0031321410864916794`}, {
              0.457681528467051, 0.003348177912301329}, {0.48940155714545586`,
               0.003580226384421929}, {0.5233103090484974, 
              0.0038282865028534787`}, {0.5513217862973304, 
              0.004033204996570285}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.4335868648196205, 0.5242514046671622, -0.20731698223128267`], 
             
             ArrowBox[{{0.5553216792679901, 0.004062466289550118}, {
              0.5594077841761756, 0.004092358267595978}, {0.5905045339304247, 
              0.004319847130911628}, {0.6233298910094894, 
              0.004559981653936061}, {0.6455686204215201, 
              0.004722669501235469}, {0.6685696026988154, 
              0.004890933623844949}, {0.6924207051402143, 
              0.00506541681665765}, {0.7153173980943794, 
              0.005232918008743448}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5141724894341769, 0.5295025052016713, 0.15169398472155704`], 
             
             ArrowBox[{{0.7193172910650392, 0.0052621793017232806`}, {
              0.7417953061304753, 0.005426617647763911}, {0.7673802726362994, 
              0.005613784956063828}, {0.7938475381635766, 
              0.005807406739608942}, {0.821197102712307, 
              0.006007482998399252}, {0.8494920691945647, 
              0.006214475362986284}, {0.878795540522424, 
              0.006428845463921562}, {0.8793130098914285, 
              0.006432631020916611}}]}}, {
            Arrowheads[{{0.007139577892685357, 1.}}], {
             LABColor[
             0.5949889764321551, 0.534768649133694, 0.5117334493487852], 
             
             ArrowBox[{{0.8833129028620882, 0.006461892313896444}, {
              0.9091075166958852, 0.006650593301205087}, {0.9404279977149478, 
              0.006879718874836857}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.23484215249152884`, 0.5225136523679953, -0.7468559130114497], 
             
             ArrowBox[{{-0.038687238013930744`, 
              0.09865002999999725}, {-0.04679568600621281, 
              0.11932606371954092`}, {-0.05663334022554136, 
              0.14441146484114342`}, {-0.0684810675320771, 
              0.17462242623881868`}, {-0.08275667113655225, 
              0.2110243198902196}, {-0.09128847362651402, 
              0.23277988102088773`}, {-0.09710248814348697, 
              0.2476052533132513}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3059222929276536, 0.522386732455967, -0.5769782525588255], 
             
             ArrowBox[{{-0.09856286939672587, 
              0.2513291338960827}, {-0.10062545107717619`, 
              0.2565885877909459}, {-0.11094256150822354`, 
              0.2828965721750887}, {-0.12241476293934066`, 
              0.31214996614801055`}, {-0.13022209810449287`, 
              0.332058181047843}, {-0.1385594757755955, 
              0.3533179710871168}, {-0.14742689595264855`, 
              0.37592933626583214`}, {-0.15682435863565197`, 
              0.39989227658398874`}, {-0.1569781195262821, 
              0.40028435720933675`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.37693844249940545`, 0.5222599268053181, -0.4072535267833603], 
             
             ArrowBox[{{-0.158438500779521, 
              0.4040082377921681}, {-0.16682775113338777`, 
              0.425400299918403}, {-0.17751296075463785`, 
              0.45264691414589103`}, {-0.1888799874994023, 
              0.48163211926645294`}, {-0.20092883136768108`, 
              0.5123559152800887}, {-0.21375599729235953`, 
              0.5450643837116894}, {-0.21685375090907721`, 
              0.5529634611054222}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4545247103998288, 0.5256157513809041, -0.11403835811422133`], 
             
             ArrowBox[{{-0.21831413216231613`, 
              0.5566873416882535}, {-0.2274579902063231, 
              0.5800036060861458}, {-0.24203481010957173`, 
              0.6171735824034583}, {-0.2574864570021055, 
              0.6565743126636266}, {-0.27099803171655046`, 
              0.6910279805746632}, {-0.2767293822918724, 
              0.7056425650015076}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5352754191677478, 0.5308776090881732, 0.2457080628580013], 
             
             ArrowBox[{{-0.27818976354511127`, 
              0.7093664455843389}, {-0.2852186183007612, 
              0.7272895842757285}, {-0.2944058253338082, 
              0.7507163858762957}, {-0.3038785370066471, 
              0.7748712063979981}, {-0.31366628756359094`, 
              0.7998293563110862}, {-0.3237592322565356, 
              0.8255657321254768}, {-0.3338624499443709, 
              0.8513283034323912}, {-0.33660501367466755`, 
              0.858321668897593}}]}}, {
            Arrowheads[{{0.017558204729249936`, 1.}}], {
             LABColor[
             0.6159712270195088, 0.5361358893555257, 0.6052098988798594], 
             
             ArrowBox[{{-0.33806539492790644`, 
              0.8620455494804243}, {-0.3442914077579883, 
              0.8779214916256552}, {-0.3550461056973879, 
              0.9053452967052696}, {-0.3661265437625696, 
              0.9335997186712337}, {-0.3775537471315039, 
              0.9627383704084167}, {-0.389348740982161, 
              0.9928148648016872}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2360841434835535, 0.5225114346826266, -0.7438876222521202], 
             
             ArrowBox[{{0.04542411914695592, 0.09882678223972056}, {
              0.055114048583379524`, 0.11990863400295654`}, {
              0.06690684535255981, 0.145565579700343}, {0.08114531356075327, 
              0.17654343955682017`}, {0.09835134378418416, 
              0.2139776624770242}, {0.10840720052836758`, 
              0.23585564235542633`}, {0.11224506090750176`, 
              0.2442054661732111}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.30713908529486406`, 0.522384559764984, -0.5740701851390083], 
             
             ArrowBox[{{0.11391558445151541`, 0.24783993327154835`}, {
              0.11940586293916634`, 0.25978483317767814`}, {
              0.13154916187908808`, 0.28620434735966965`}, {
              0.14503892821064027`, 0.31555329731729065`}, {
              0.1541889183540524, 0.3354604325657059}, {0.1639529644600708, 
              0.35670353593060045`}, {0.17433106652869537`, 
              0.37928260741197417`}, {0.18073652621206132`, 
              0.39321861720503887`}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.3781848009946983, 0.5222577013213839, -0.40427479792932985`], 
             
             ArrowBox[{{0.18240704975607497`, 0.3968530843033761}, {
              0.18532322455992614`, 0.4031976470098271}, {
              0.19701626044524884`, 0.42863754838516205`}, {
              0.20949699607614916`, 0.455791205198982}, {0.22276543145262714`,
               0.4846586174512869}, {0.23682156657468273`, 
              0.5152397851420767}, {0.24922799151662084`, 
              0.5422317682368667}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4558943457333863, 0.5257049992196661, -0.10793659855319361`], 
             
             ArrowBox[{{0.2508985150606345, 0.545866235335204}, {
              0.251775547981208, 0.5477743480974608}, {0.267737522211095, 
              0.5825019461435483}, {0.2847074892643438, 0.6194225792803395}, {
              0.3026854491409543, 0.6585362475078341}, {0.3177194568211804, 
              0.6912449192686945}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5366790091290716, 0.5309690694699892, 0.2519610911323419], 
             
             ArrowBox[{{0.31938998036519406`, 0.6948793863670317}, {
              0.33496525924359283`, 0.7287656723962368}, {
              0.34559933825463274`, 0.7519016589707712}, {0.3565593042200495, 
              0.7757466600442059}, {0.36787835536172236`, 
              0.8003729031799153}, {0.3795454256056917, 0.8257563125234413}, {
              0.38621092212573993`, 0.8402580703005222}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6173233098602495, 0.5362239934430931, 0.6112334616477402], 
             
             ArrowBox[{{0.3878814456697536, 0.8438925373988595}, {
              0.39122403481669765`, 0.8511648265691392}, {0.4032737410640732, 
              0.877380716226997}, {0.4156945443478186, 0.9044039814970153}, {
              0.4284864446679335, 0.9322346223791936}, {0.4416730483078516, 
              0.9609239977788049}, {0.4547023874302994, 
              0.98927122133235}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.23540791858356097`, 0.5225126421423234, -0.7455037628962679], 
             
             ArrowBox[{{0.09923607039933356, -0.0406660250919881}, {
              0.12017611531352691`, -0.049247062092760585`}, {
              0.14561184195901833`, -0.05967038794429945}, {
              0.17627446617101294`, -0.0722356481422642}, {
              0.21326149651357698`, -0.08739259155947286}, {
              0.23517591875877855`, -0.09637291939101277}, {
              0.2472872459322437, -0.10133602940485625`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3064784285377415, 0.5223857394263771, -0.57564911877045], 
             
             ArrowBox[{{0.2509885253205664, -0.10285277951267796`}, {
              0.2591531043946486, -0.10619854860808922`}, {
              0.28563868730696057`, -0.1170520958611578}, {
              0.3150783013814875, -0.12911617780067403`}, {
              0.335091000815546, -0.1373171971887745}, {
              0.3564564675010433, -0.14607256810217484`}, {
              0.3791747014379795, -0.15538229054087493`}, {
              0.3990397008534765, -0.16352278382554614`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.37745907930163103`, 0.5222589971620065, -0.40600923321043036`], 
             
             ArrowBox[{{0.4027409802417993, -0.16503953393336784`}, {
              0.4032457026263544, -0.16524636450487487`}, {
              0.42886223821602704`, -0.17574378419176354`}, {
              0.45621707535685624`, -0.18695354379912982`}, {
              0.4853102140488421, -0.1988756433269738}, {
              0.5161416542919846, -0.21151008277529543`}, {
              0.5489563145400875, -0.22495722746436386`}, {
              0.5507921557747094, -0.22570953824623596`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.455154938970806, 0.5256568181791297, -0.1112306741166095], 
             
             ArrowBox[{{0.5544934351630322, -0.22722628835405767`}, {
              0.5839991132469549, -0.23931744271444821`}, {
              0.6212700504125868, -0.25459072852554854`}, {
              0.6607691260369829, -0.27077708489766483`}, {
              0.6953195102776103, -0.2849355132474901}, {
              0.7025446106959422, -0.28789629266692585`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5359170985331783, 0.5309194220402339, 0.24856676043041256`], 
             
             ArrowBox[{{0.706245890084265, -0.28941304277474755`}, {
              0.7316764530770956, -0.2998342526091181}, {
              0.7551166785613795, -0.30943984051551054`}, {
              0.7792815402535973, -0.31934237764707707`}, {
              0.8042455687735772, -0.32957240596344844`}, {
              0.8299839205813764, -0.34011974481141444`}, {
              0.8542970656171751, -0.3500830470876155}}]}}, {
            Arrowheads[{{0.018801024424408022`, 1.}}], {
             LABColor[
             0.6166014555904861, 0.5361769561537513, 0.6080175828774711], 
             
             ArrowBox[{{0.8579983450054979, -0.3515997971954372}, {
              0.8823386157106418, -0.3615742153203997}, {
              0.9097551993763893, -0.37280927808337827`}, {
              0.9379979404428798, -0.38438289251868085`}, {
              0.9671198735576725, -0.39631679173504186`}, {
              0.997174033368326, -0.4086327088411959}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.23616020721537584`, 0.522511298864069, -0.7437058340799529], 
             
             ArrowBox[{{0.04225420278827801, -0.10042311674255242`}, {
              0.05123627957076853, -0.12177029846168892`}, {
              0.06216083512663654, -0.14773405698872896`}, {
              0.07534427006706979, -0.1790663633328981}, {
              0.091266153542731, -0.21690698172177966`}, {
              0.10060951061851431`, -0.23911279739152974`}, {
              0.104306878112896, -0.24790011659357172`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3072191582031431, 0.5223844167876852, -0.5738788152536843], 
             
             ArrowBox[{{0.10585819499601146`, -0.2515870415898472}, {
              0.11082969508364193`, -0.2634025179387283}, {
              0.12211491438468856`, -0.29022344510218445`}, {
              0.13465337596822877`, -0.32002288062070705`}, {
              0.1431682839742404, -0.34025976936345276`}, {
              0.15225606197596225`, -0.36185816504897006`}, {
              0.16191670997339433`, -0.38481806767725873`}, {
              0.16791087032062943`, -0.3990640414408665}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3782622307402579, 0.5222575630636873, -0.4040897450588038], 
             
             ArrowBox[{{0.16946218720374487`, -0.402750966437142}, {
              0.17215022796653662`, -0.40913947724831884`}, {
              0.18303783458925693`, -0.43501542138573235`}, {
              0.19466074847542292`, -0.46263892771308135`}, {
              0.20701896962503474`, -0.49200999623036584`}, {
              0.22011249803809224`, -0.5231286269375857}, {
              0.23151486252836292`, -0.5502279662881613}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.45598314051586936`, 0.5257107852433145, -0.1075410155832522], 
             
             ArrowBox[{{0.23306617941147836`, -0.5539148912844367}, {
              0.23404442506414522`, -0.556239831074992}, {
              0.24891784205274325`, -0.5915886198828357}, {
              0.2647327490038865, -0.6291749933611173}, {
              0.2814891459175748, -0.6689989515098362}, {
              0.29511885473609634`, -0.7013918911354561}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5367715824327188, 0.5309751017086992, 0.2523735075082819], 
             
             ArrowBox[{{0.2966701716192118, -0.7050788161317315}, {
              0.3115756631438835, -0.740503834631962}, {
              0.3214992628190486, -0.7640886792846676}, {
              0.3317279244907314, -0.7883985471177541}, {
              0.3422928314066517, -0.8135075495501936}, {
              0.35318358915090287`, -0.8393909827756619}, {
              0.3587228469438298, -0.8525558159827508}}]}}, {
            Arrowheads[{{0.012441367589171045`, 1.}}], {
             LABColor[
             0.6174077460544758, 0.5362294954534921, 0.6116096269983224], 
             
             ArrowBox[{{0.3602741638269452, -0.8562427409790262}, {
              0.36408518726448563`, -0.8653001796791334}, {
              0.37533431694506236`, -0.8920353347316399}, {
              0.3869309781926333, -0.919596447933182}, {
              0.39887517100719805`, -0.9479835192837589}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.23478248832145923`, 0.522513758903677, -0.7469985071251091], 
             
             ArrowBox[{{-0.039920292568020016`, -0.09800632999206305}, \
{-0.048297691648798435`, -0.11857326690483773`}, {-0.05846388399529475, \
-0.1435317814291445}, {-0.07070950346824055, -0.1735953943392411}, \
{-0.08546756025373711, -0.20982716746306015`}, {-0.09427534859575448, \
-0.231450731701152}, {-0.10027714551791699`, -0.24618544559876557`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.30586146416171067`, 0.5223868410711383, -0.5771236299931299], 
             
             ArrowBox[{{-0.10178606684166441`, -0.24988992348893313`}, \
{-0.1039141279617935, -0.25511442078006097`}, {-0.11456430363818229`, \
-0.2812611387690412}, {-0.126406280911249, -0.31033378973734677`}, \
{-0.13446129900950207`, -0.33010926509200006`}, {-0.14306267921924695`, \
-0.35122608696366076`}, {-0.1522104215404837, -0.37368425535232885`}, \
{-0.16190452597321228`, -0.39748377025800435`}, {-0.16214291979156137`, \
-0.3980690390956357}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3768806383885006, 0.5222600300196987, -0.4073916754570235], 
             
             ArrowBox[{{-0.16365184111530878`, -0.40177351698580327`}, \
{-0.17222313948964485`, -0.42281648643559555`}, {-0.1832444090619935, \
-0.4498742586400105}, {-0.19496833469025823`, -0.47865708687124936`}, \
{-0.20739491637443908`, -0.509164971129312}, {-0.22062351390424523`, \
-0.5416418447050578}, {-0.22400869406520574`, -0.5499526325925058}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4544557775252939, 0.5256112595939875, -0.1143454557890233], 
             
             ArrowBox[{{-0.22551761538895315`, -0.5536571104826734}, \
{-0.23475348706938576`, -0.5763316408893457}, {-0.24978483586986083`, \
-0.6132343596821761}, {-0.26571756030567034`, -0.6523500010835488}, \
{-0.27965033036697845`, -0.6865556537101029}, {-0.2858744683388501, \
-0.7018362260893759}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5352051893105639, 0.5308730327875939, 0.2453951870931597], 
             
             ArrowBox[{{-0.2873833896625975, -0.7055407039795435}, \
{-0.29431365163004486`, -0.7225548463522674}, {-0.3037826233923128, \
-0.7458016492066581}, {-0.31354552195898766`, -0.7697700571779735}, \
{-0.32363271484760625`, -0.7945346240521031}, {-0.3340340795523231, \
-0.8200704985670838}, {-0.3444460064551219, -0.8456323038106257}, \
{-0.3477402426124945, -0.853719819586246}}]}}, {
            Arrowheads[{{0.017354246611493068`, 1.}}], {
             LABColor[
             0.615902294144974, 0.5361313975686091, 0.6049028012050575], 
             
             ArrowBox[{{-0.3492491639362419, -0.8574242974764136}, \
{-0.35519322957018296`, -0.8720172781521413}, {-0.36627574889750636`, \
-0.8992254215916307}, {-0.3776935644370918, -0.9272567341290933}, \
{-0.38946829251956433`, -0.956164284945544}, {-0.40162154947554873`, \
-0.9860011432219964}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.2364849746621194, 0.5225107189629107, -0.7429296575881024], 
             
             ArrowBox[{{0.10204437116378126`, 0.040252629462116406`}, {
              0.12372701514491075`, 0.04880560915102619}, {
              0.15009678931004491`, 0.05920748371170337}, {
              0.18191701356015358`, 0.07175935385930135}, {
              0.22034424405353242`, 0.08691743708000844}, {
              0.24289678148182303`, 0.09581355670109441}, {0.2508831717051843,
               0.09896388437458134}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3075431758194935, 0.5223838382254158, -0.5731044308155935], 
             
             ArrowBox[{{0.25460414171871937`, 0.10043166574739296`}, {
              0.26756520635365066`, 0.1055443135714172}, {0.2948036865323177, 
              0.11628885966679497`}, {0.3250663898811262, 
              0.12822634696304575`}, {0.3456316117667192, 
              0.13633854606747606`}, {0.367581101609175, 
              0.1449967863156599}, {0.3909148594084939, 
              0.15420106770759737`}, {0.4034429422601224, 
              0.15914292065985786`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.37860539578390373`, 0.5222569503119836, -0.403269599313368], 
             
             ArrowBox[{{0.40716391227365745`, 0.16061070203266947`}, {
              0.41563288516467567`, 0.1639513902432884}, {0.4419315365208636, 
              0.1743252095566044}, {0.4700071711202005, 
              0.18539998128141655`}, {0.4998597889626867, 
              0.19717570541772503`}, {0.5314893900483217, 
              0.20965238196552968`}, {0.5560027128150605, 
              0.2193219569451344}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.45633559246585154`, 0.5257337516300838, -0.1059708333581626], 
             
             ArrowBox[{{0.5597236828285956, 0.22078973831794604`}, {
              0.5651452375639066, 0.2229283357866765}, {0.6010765946962411, 
              0.23710189174301116`}, {0.6198955893686897, 
              0.244525270521874}, {0.6392834614453259, 
              0.25217304983453387`}, {0.6592402109261495, 
              0.26004522968099064`}, {0.6797658378111606, 
              0.26814181006124443`}, {0.7085624833699987, 
              0.27950099323041094`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5371408962842482, 0.5309991668465255, 0.25401880992519316`], 
             
             ArrowBox[{{0.7122834533835338, 0.28096877460322256`}, {
              0.7151883993779014, 0.2821146654876013}, {0.7524568120768933, 
              0.29681563909256387`}, {0.7764392999039271, 
              0.3062758198460119}, {0.8011595361263327, 0.3160270143266895}, {
              0.8266929892766004, 0.32609899200487447`}, {0.8530145031772335, 
              0.33648182972380775`}, {0.8611222539249369, 
              0.3396800295156875}}]}}, {
            Arrowheads[{{0.013249969933437996`, 1.}}], {
             LABColor[
             0.6177553751068835, 0.5362521475718027, 0.613158323094465], 
             
             ArrowBox[{{0.864843223938472, 0.3411478108884991}, {
              0.8793622534692193, 0.34687501670284715`}, {0.9065505372942755, 
              0.35759976224284684`}, {0.9345793546524027, 
              0.3686560663438072}, {0.9634487055436003, 
              0.3800439290057278}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2165507814488593, 0.5225463132376752, -0.7905712925834963], 
             
             ArrowBox[{{-0.06398670641273432, -0.0033087845041311265`}, \
{-0.08237013601853518, -0.004259400818402833}, {-0.1038030807656108, \
-0.005367709081678421}, {-0.13095286503441753`, -0.006771637968089312}, \
{-0.1523662024206442, -0.007878932324955568}, {-0.17725855041768246`, \
-0.00916612805578081}, {-0.20626612931757535`, -0.010666124429202919`}, \
{-0.22377321641300046`, -0.011571424635157703`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.2876335793705553, 0.5224193885804702, -0.6206872808852393], 
             
             ArrowBox[{{-0.22776787916300711`, -0.011777990638433367`}, \
{-0.2400251594123659, -0.012411820713859776`}, {-0.2588988678691243, \
-0.013387789592057615`}, {-0.27938523754716016`, -0.014447149986376903`}, \
{-0.30148426844647347`, -0.01558990189681764}, {-0.3251959605670642, \
-0.016816045323379828`}, {-0.34443296137579205`, -0.017810800230302327`}, \
{-0.3648079114513965, -0.018864399061405603`}, {-0.3875543891632733, \
-0.02004063076945994}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.35889206074572944`, 0.5222921502248351, -0.4503833953111853], 
             
             ArrowBox[{{-0.39154905191327993`, -0.020247196772735607`}, \
{-0.3961961791558122, -0.020487502040358447`}, {-0.43028501974313965`, \
-0.022250252990088495`}, {-0.4658446086022221, -0.024089057066536315`}, \
{-0.5043456940048147, -0.02607996739641969}, {-0.5460371713666858, \
-0.028235854485832993`}, {-0.551335561913546, -0.02850983690376218}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.43390456276783673`, 0.5242721064222665, -0.20590162995060496`], 
             
             ArrowBox[{{-0.5553302246635528, -0.028716402907037846`}, \
{-0.5681726428132642, -0.02938049075514876}, {-0.5911679361036043, \
-0.030569588840870604`}, {-0.6150971952522886, -0.031806982766974405`}, \
{-0.6400345642738993, -0.03309650655743604}, {-0.6659800431684363, \
-0.034438160212255514`}, {-0.6929336319358997, -0.035831943731432815`}, \
{-0.7151167346638189, -0.03697904303806442}}]}}, {
            Arrowheads[{{0.015406867775575352`, 1.}}], {
             LABColor[
             0.5146173393649885, 0.5295314924028083, 0.1536758022550618], 
             
             ArrowBox[{{-0.7191113974138256, -0.037185609041340086`}, \
{-0.7275649819180179, -0.03762274811256236}, {-0.7639233366392094, \
-0.039502856770151265`}, {-0.8021039007769117, -0.041477192785556366`}, \
{-0.842201879008563, -0.043550679240134546`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.23466953314456407`, 0.5225139605951906, -0.7472684638397303], 
             
             ArrowBox[{{-0.09855660940093708, 
              0.03785010843857318}, {-0.11916301838301346`, 
              0.045763883265467376`}, {-0.14415339356281812`, 
              0.05536129551641318}, {-0.1742394443847756, 
              0.06691567317836111}, {-0.21047648806201116`, 
              0.08083230485850533}, {-0.23220010463606336`, 
              0.08917513694256081}, {-0.24792046538573628`, 
              0.0952124525795875}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3057529088231081, 0.5223870349063493, -0.5773830713341049], 
             
             ArrowBox[{{-0.2516545617853563, 
              0.09664651118311286}, {-0.25597567901527574`, 
              0.09830601181652937}, {-0.28224999525973793`, 
              0.10839651437183342`}, {-0.3114698374295398, 
              0.11961822949989545`}, {-0.33136411001301713`, 
              0.12725851237050312`}, {-0.3526111348999622, 
              0.1354183121125617}, {-0.3752109120903752, 
              0.14409762872607124`}, {-0.399163441584256, 
              0.15329646221103171`}, {-0.4010184177701555, 
              0.1540088553241272}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3767836482357766, 0.5222602032042418, -0.4076234766342667], 
             
             ArrowBox[{{-0.4047525141697755, 
              0.15544291392765255`}, {-0.42466272996844634`, 
              0.16308931969988602`}, {-0.4519027838297879, 
              0.173550708325077}, {-0.48088360316828077`, 
              0.18468062808660468`}, {-0.5116051879839247, 
              0.19647907898446898`}, {-0.5443143345212798, 
              0.20904084172059956`}, {-0.5541163701545747, 
              0.21280525806866687`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4543327595514788, 0.525603243527212, -0.11489350392965887`], 
             
             ArrowBox[{{-0.5578504665541947, 
              0.21423931667219223`}, {-0.5792578390249055, 
              0.22246069699692594`}, {-0.616435701494802, 
              0.23673864481344817`}, {-0.6558479219309693, 
              0.2518746851701662}, {-0.6903075266387111, 
              0.26510870146665205`}, {-0.7072143225389939, 
              0.2716016608132065}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5350799522666801, 0.5308648721223236, 0.24483725294003908`], 
             
             ArrowBox[{{-0.7109484189386138, 
              0.2730357194167319}, {-0.726577693246309, 
              0.2790380538208702}, {-0.7500277626378261, 
              0.2880439203452573}, {-0.7742079565529708, 
              0.29733018706361347`}, {-0.7991939609204803, 
              0.3069259207288172}, {-0.8249605470974426, 
              0.3168214324232423}, {-0.8507534620188577, 
              0.32672705552306835`}, {-0.860312274923413, 
              0.33039806355774626`}}]}}, {
            Arrowheads[{{0.017191014352352752`, 1.}}], {
             LABColor[
             0.6157792761711587, 0.5361233815018336, 0.6043547530644217], 
             
             ArrowBox[{{-0.864046371323033, 
              0.3318321221612716}, {-0.8773796162386311, 
              0.3369526794629176}, {-0.9048390097567631, 
              0.34749830424279027`}, {-0.9331316425732535, 
              0.3583639298626861}, {-0.9623114033930011, 
              0.3695702519749459}, {-0.9924321809209047, 
              0.3811379662319102}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.24777334948696478`, 0.5224905625657663, -0.7159510571831088], 
             
             ArrowBox[{{-0.12669140852366, -0.04969205058181572}, \
{-0.15390759447011687`, -0.060367029291543035`}, {-0.18678657534392556`, \
-0.07326312066584274}, {-0.22654432715005104`, -0.08885726581579036}, \
{-0.24963208135767215`, -0.09791295367398778}, {-0.2748783465084719, \
-0.10781527222498238`}, {-0.2756434654691921, -0.10811537410671426`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3190063601370717, 0.5223633696903759, -0.5457080452533372], 
             
             ArrowBox[{{-0.2793672668928304, -0.10957595719483673`}, \
{-0.30274312465491005`, -0.11874464763598577`}, {-0.333686417849446, \
-0.13088150607420954`}, {-0.354698222169159, -0.13912294608373788`}, \
{-0.3771173387002572, -0.14791637482247433`}, {-0.4009437674427409, \
-0.15726179229041903`}, {-0.42617750839660995`, -0.16715919848757185`}, \
{-0.4283193238383625, -0.16799928071973527`}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.3900354953327474, 0.5222365408527406, -0.375952284544652], 
             
             ArrowBox[{{-0.43204312526200084`, -0.16945986380785774`}, \
{-0.4530171167339817, -0.17768647252010994`}, {-0.4816611476269731, \
-0.18892149349421017`}, {-0.5121096010755843, -0.20086426140987262`}, \
{-0.5443624770798153, -0.21351477626709725`}, {-0.5786715702457309, \
-0.2269717992245657}, {-0.580995182207533, -0.22788318733275628`}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.46935194467576175`, 0.5265819199525823, -0.0479826597176435], 
             
             ArrowBox[{{-0.5847189836311713, -0.22934377042087875`}, \
{-0.6152886751793953, -0.24133409144095935`}, {-0.6344627320591336, \
-0.2488547135212532}, {-0.6542137918808092, -0.25660165291627834`}, \
{-0.674541854644422, -0.26457490962603486`}, {-0.695446920349972, \
-0.27277448365052265`}, {-0.731537071159781, -0.28693008915246526`}, \
{-0.7336710405767033, -0.28776709394577726`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5501232685914985, 0.5318451209790133, 0.31185560225211867`], 
             
             ArrowBox[{{-0.7373948420003416, -0.28922767703389973`}, \
{-0.7695001002469276, -0.30182029191854415`}, {-0.7938759937969875, \
-0.3113812254449902}, {-0.8189973322999241, -0.32123454413579716`}, \
{-0.8449398795016948, -0.33140996473293083`}, {-0.8716783808203139, \
-0.341897581655736}, {-0.8863468989458737, -0.34765100055879816`}}]}}, {
            Arrowheads[{{0.012589111839209138`, 1.}}], {
             LABColor[
             0.6307684443539788, 0.5371001019706904, 0.6711318710537878], 
             
             ArrowBox[{{-0.890070700369512, -0.34911158364692063`}, \
{-0.8984432130609336, -0.352395526331016}, {-0.9260566612624026, \
-0.36322632283691714`}, {-0.9545187254247215, -0.3743899711734396}, \
{-0.9838294055478896, -0.38588647134058296`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.27995841458870807`, 0.5224330932697537, -0.6390305062746188], 
             
             ArrowBox[{{-0.1751316312088006, 
              0.11372317249532476`}, {-0.1924335868218223, 
              0.12495834040362919`}, {-0.211364527277567, 
              0.13725130308597064`}, {-0.2321375164075962, 
              0.15074041530271964`}, {-0.25496561804347123`, 
              0.1655640318142466}, {-0.27986813298062, 
              0.18173468575161744`}, {-0.30701937244337735`, 
              0.19936556754934182`}, {-0.3093219454378894, 
              0.20086076235812977`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.35059540734627936`, 0.5223069646373155, -0.47021194461394644`], 
             
             ArrowBox[{{-0.3126767032936166, 
              0.2030392021046999}, {-0.336864915906665, 
              0.21874601792295553`}, {-0.369850342845405, 
              0.2401653775879945}, {-0.39195983902171355`, 
              0.2545223617038183}, {-0.41547087570934715`, 
              0.26978944773685987`}, {-0.44038345290830605`, 
              0.28596663568711933`}, {-0.4468670175227053, 
              0.29017679196750495`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.424318732171484, 0.5236474769004507, -0.24860674426724771`], 
             
             ArrowBox[{{-0.4502217753784325, 
              0.29235523171407507`}, {-0.4666975706185899, 
              0.30305392555459654`}, {-0.4945995877245233, 
              0.3211723310214104}, {-0.5242758631104301, 
              0.3404428657696795}, {-0.5557263967763106, 
              0.360865529799404}, {-0.5844120896075212, 
              0.37949282157688013`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5049982823584755, 0.5289046977898738, 0.11082266345269878`], 
             
             ArrowBox[{{-0.5877668474632485, 
              0.38167126132345025`}, {-0.5889511887221648, 
              0.3824403231105839}, {-0.6062873584025961, 
              0.3936977082064}, {-0.624183946358049, 
              0.40531900554194067`}, {-0.6426409525885235, 
              0.41730421511720595`}, {-0.6616583770940196, 
              0.4296533369321957}, {-0.6812362198745376, 
              0.44236637098691023`}, {-0.701374480930077, 
              0.45544331728134935`}, {-0.7219571616923373, 
              0.4688088511862553}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5858811797442816, 0.5341751691391585, 0.471157988013555], 
             
             ArrowBox[{{-0.7253119195480645, 
              0.47098729093282543`}, {-0.7433322578662209, 
              0.4826889465894013}, {-0.761430540005148, 
              0.49444121571033683`}, {-0.7799805335018629, 
              0.506486807335638}, {-0.798971735483597, 
              0.5188189013380478}, {-0.8184356545686557, 
              0.5314579580993368}, {-0.8426377974684887, 
              0.5471738196644742}, {-0.8595022337771533, 
              0.5581248807956304}}]}}, {
            Arrowheads[{{0.016442814416635892`, 1.}}], {
             LABColor[
             0.6601645138508997, 0.5021723325745979, 0.7408745288937933], 
             
             ArrowBox[{{-0.8628569916328805, 
              0.5603033205422006}, {-0.8675326043625593, 
              0.5633394683203518}, {-0.8931855438110152, 
              0.5799974166177138}, {-0.9195747929604738, 
              0.5971334937063121}, {-0.9459867201952912, 
              0.6142842969971122}, {-0.9731803133018286, 
              0.6319426814835523}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.28696296947172917`, 0.522420586014083, -0.6222900019827211], 
             
             ArrowBox[{{0.1320311500129426, 0.18210589374391395`}, {
              0.14490884475281518`, 0.19986764246560507`}, {
              0.1589859648396672, 0.21928371613083705`}, {
              0.17441675588701677`, 0.240566860256884}, {0.19135546350838192`,
               0.2639298203610198}, {0.20981782199261775`, 
              0.2893942981911585}, {0.2259480022362061, 
              0.3116420850900921}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.35759579377673834`, 0.5222944648247875, -0.4534814026964142], 
             
             ArrowBox[{{0.22829592354178768`, 0.31488048987374656`}, {
              0.22993037468830968`, 0.3171348305107021}, {0.2520135807985715, 
              0.34759341536015675`}, {0.2763878995265169, 
              0.3812120507800285}, {0.29267720805809627`, 0.40367931769638}, {
              0.3099837218976522, 0.4275495799037062}, {0.3222127757650512, 
              0.4444166812199247}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4323593218015947, 0.524171415812712, -0.2127857169837343], 
             
             ArrowBox[{{0.3245606970706328, 0.4476550860035792}, {
              0.32830744104518483`, 0.452822837402007}, {0.347648365500694, 
              0.47949909019128256`}, {0.3681395906854104, 
              0.5077619120769118}, {0.3899142120205646, 0.5377948768642731}, {
              0.4129722295061567, 0.5695979845533672}, {0.41847754929389636`, 
              0.5771912773497573}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5130319304784376, 0.5294281843811679, 0.14661276613542296`], 
             
             ArrowBox[{{0.42082547059947795`, 0.5804296821334117}, {
              0.43731364314218657`, 0.6031712351441936}, {0.4500072272061456, 
              0.6206790465247214}, {0.4631048676867737, 0.6387441586246116}, {
              0.4766065645840709, 0.6573665714438646}, {0.49051231789803723`, 
              0.6765462849824804}, {0.5048221276286727, 0.6962832992404588}, {
              0.5147423228227415, 0.70996587347959}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5938058384212748, 0.5346915537873337, 0.5064625400103464], 
             
             ArrowBox[{{0.517090244128323, 0.7132042782632444}, {
              0.5195359937759774, 0.7165776142177998}, {0.5346539163399511, 
              0.7374292299145035}, {0.550175895320594, 0.75883814633057}, {
              0.5633675819526185, 0.7770329729595811}, {0.5768833854957766, 
              0.7956748425763548}, {0.5907158780593782, 0.8147535101540726}, {
              0.6048873433154939, 0.8342997107731901}, {0.6110070963515866, 
              0.8427404696094226}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6658614243427243, 0.48918158349812935`, 0.744052597339701], 
             
             ArrowBox[{{0.6133550176571682, 0.8459788743930771}, {
              0.6224427644725223, 0.8585132820367752}, {0.6404916224407488, 
              0.8834074332354781}, {0.6590796442211905, 0.9090452340039095}, {
              0.6781915874801754, 0.9354056611305325}, {0.6973193569862578, 
              0.9617879168398198}, {0.7072718698804317, 
              0.9755150657392553}}]}}, {
            Arrowheads[{{0.001572222472174453, 1.}}], {
             LABColor[
             0.7233183884183012, 0.3581616202965613, 0.7761054380484116], 
             
             ArrowBox[{{0.7096197911860133, 0.9787534705229097}, {
              0.7170027004650784, 0.9889364560726273}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.28028441475438026`, 0.5224325111674663, -0.6382513836517346], 
             
             ArrowBox[{{-0.11473055721596406`, 
              0.17537069771323902`}, {-0.1260578568119698, 
              0.19268497284239358`}, {-0.1384510429297908, 
              0.21162850235285505`}, {-0.15204940859223762`, 
              0.2324142017502186}, {-0.16699224682212058`, 
              0.25525498654007933`}, {-0.1832922592919714, 
              0.2801702717869855}, {-0.20106342075454464`, 
              0.3073342729083228}, {-0.20232527050517438`, 
              0.3092630656950663}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3509213213636558, 0.5223063826888533, -0.46943302788079266`], 
             
             ArrowBox[{{-0.20451513833740464`, 
              0.31261037489461196`}, {-0.22059693385298523`, 
              0.33719210593894255`}, {-0.24218400123043804`, 
              0.3701888869136961}, {-0.2566509560794039, 
              0.3923022630465548}, {-0.2720342672220947, 
              0.4158163300370543}, {-0.2883339346585102, 
              0.44073108788519466`}, {-0.29210985162661496`, 
              0.4465027428764392}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.42469595521354914`, 0.523672057414994, -0.2469262062092944], 
             
             ArrowBox[{{-0.2942997194588452, 
              0.4498500520759849}, {-0.3055499583886505, 
              0.4670465365909758}, {-0.32380408154382245`, 
              0.4949487658797258}, {-0.34321804725533267`, 
              0.5246238654767731}, {-0.3637918555231814, 
              0.5560718353821175}, {-0.3818944327480555, 
              0.5837424200578122}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5053724614094005, 0.5289290799526194, 0.11248964045422469`], 
             
             ArrowBox[{{-0.3840843005802858, 
              0.5870897292573578}, {-0.3855255063473685, 
              0.589292675595759}, {-0.3968654354268502, 
              0.6066262554453185}, {-0.40857165056293926`, 
              0.6245197196262069}, {-0.4206441517556355, 
              0.642973068138424}, {-0.433082939004939, 
              0.66198630098197}, {-0.44588801231084985`, 
              0.6815594181568448}, {-0.4590593716733678, 
              0.7016924196630484}, {-0.47167901386949607`, 
              0.7209820972391852}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5862471687482185, 0.5341990176240885, 0.47278847815154135`], 
             
             ArrowBox[{{-0.47386888170172636`, 
              0.7243294064387308}, {-0.48650094856822557`, 
              0.7436380756694422}, {-0.498336763044424, 
              0.7617296381359979}, {-0.510467748265803, 
              0.7802723820557164}, {-0.522887046197331, 
              0.7992558246207246}, {-0.5356152309441027, 
              0.8187114142546411}, {-0.5514385628246068, 
              0.842898072276433}, {-0.5614635949909367, 
              0.858221774420558}}]}}, {
            Arrowheads[{{0.016696763873549403`, 1.}}], {
             LABColor[
             0.6604312342725815, 0.5015641260604511, 0.7410233210781261], 
             
             ArrowBox[{{-0.563653462823167, 
              0.8615690836201038}, {-0.5677143309954878, 
              0.8677762990471226}, {-0.5844852543937077, 
              0.8934113923388325}, {-0.6017370933736125, 
              0.919781586227522}, {-0.6190037293850473, 
              0.9461743980290542}, {-0.6367808750412272, 
              0.9733475462532516}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.28370897240487775`, 0.5224263963152295, -0.630066877569133], 
             
             ArrowBox[{{-0.12024511114763109`, -0.18116943432670757`}, \
{-0.13204651118926203`, -0.19895022349476332`}, {-0.14495287617281272`, \
-0.21839582773569693`}, {-0.15910747499346595`, -0.23972210567734903`}, \
{-0.17465357654640445`, -0.26314491594756023`}, {-0.19160498274231746`, \
-0.28868505344042916`}, {-0.2087246667675853, -0.31447872971639684`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3543423936032901, 0.5223002740601277, -0.46125685174013414`], 
             
             ArrowBox[{{-0.21093665565808417`, -0.3178114621011391}, \
{-0.230374464834494, -0.3470977828457479}, {-0.2527897992839075, \
-0.38087024497485966`}, {-0.26779446130950096`, -0.4034772857559414}, \
{-0.28374316327446614`, -0.427506681094023}, {-0.29941621127803836`, \
-0.4511207574908284}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.428656409335045, 0.5239301275466552, -0.22928228434939305`], 
             
             ArrowBox[{{-0.3016282001685372, -0.45445348987557066`}, \
{-0.31847268702251164`, -0.4798325354411859}, {-0.33737802782540716`, \
-0.508316603245066}, {-0.35747644660730477`, -0.538598243195543}, \
{-0.37876794336820446`, -0.5706774552926173}, {-0.39010775578849144`, \
-0.5877627852652599}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5093008586931905, 0.5291850612045529, 0.1299907483028526], 
             
             ArrowBox[{{-0.3923197446789903, -0.5910955176500021}, \
{-0.4012525181081062, -0.6045542395362886}, {-0.41298119040127607`, \
-0.622225452149233}, {-0.4250860935513828, -0.640463519671096}, \
{-0.4375672275584265, -0.6592684421018777}, {-0.45042459242240707`, \
-0.6786402194415783}, {-0.46365818814332455`, -0.6985788516901975}, \
{-0.47726801472117886`, -0.7190843388477354}, {-0.48079930029894447`, \
-0.7244048130396914}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5901189935134196, 0.5344513125115615, 0.4900375540192948], 
             
             ArrowBox[{{-0.4830112891894433, -0.7277375454244336}, \
{-0.4912540721559702, -0.7401566809141921}, {-0.5056163604476984, \
-0.7617958778895675}, {-0.5178341471741272, -0.7802040234584451}, \
{-0.5303545211995274, -0.7990680675604596}, {-0.5431704969918405, \
-0.8183774853195522}, {-0.556303031147242, -0.8381638513638996}, \
{-0.5714908448093975, -0.8610468408141229}}]}}, {
            Arrowheads[{{0.01960758187485821, 1.}}], {
             LABColor[
             0.6632331205021793, 0.4951749435374414, 0.7425863763917185], 
             
             ArrowBox[{{-0.5737028336998964, -0.864379573198865}, \
{-0.589360515640093, -0.8879704980431207}, {-0.6066258984220269, \
-0.9139836939409287}, {-0.6243823748942998, -0.9407368048775355}, \
{-0.6421538310476171, -0.967512485216884}, {-0.6604463402533625, \
-0.9950732194005146}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2814662962924482, 0.5224304008128733, -0.6354267512102787], 
             
             ArrowBox[{{0.17676678003466492`, -0.11755270569075132`}, {
              0.19418028252446595`, -0.12913296037903224`}, {
              0.21322933531869115`, -0.1418008818989468}, {
              0.23412705180351595`, -0.15569819402437907`}, {
              0.2570865453651157, -0.17096662052921308`}, {
              0.2821276713835207, -0.1876193655553391}, {
              0.3094248916436771, -0.20577244895024227`}, {
              0.30999625129874697`, -0.20615241216144534`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3521024526459843, 0.5223042736739087, -0.46661018850965086`], 
             
             ArrowBox[{{0.31332698808034903`, -0.2083674048232127}, {
              0.3394232291391347, -0.22572181804619917`}, {
              0.3725677068634426, -0.24776342017548592`}, {
              0.3947688125690479, -0.2625275067561686}, {
              0.4183725340410018, -0.2782243550149587}, {
              0.4433788712793044, -0.2948539649518563}, {
              0.4465564593444311, -0.2969671112939067}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4260632055917492, 0.523761149845885, -0.2408350716838499], 
             
             ArrowBox[{{0.4498871961260332, -0.299182103955674}, {
              0.46978782428395555`, -0.31241633656686135`}, {
              0.4977852222793226, -0.3310350492345402}, {
              0.5275568944897726, -0.350833682329459}, {
              0.5591028409153057, -0.3718122358516178}, {
              0.5831166673901153, -0.38778181042636806`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.506728648730645, 0.52901745149533, 0.11853148878509015`], 
             
             ArrowBox[{{0.5864474041717173, -0.38999680308813545`}, {
              0.5924230615559218, -0.3939707098010167}, {
              0.6098067464485128, -0.40553113531535123`}, {
              0.627750443378128, -0.41746397769533616`}, {
              0.6462541523447676, -0.42976923694097113`}, {
              0.6653178733484313, -0.44244691305225636`}, {
              0.6849416063891196, -0.45549700602919185`}, {
              0.705125351466832, -0.4689195158717776}, {
              0.7196768754357994, -0.47859650955882943`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5875806291954555, 0.5342859082438576, 0.4787290776920387], 
             
             ArrowBox[{{0.7230076122174014, -0.4808115022205968}, {
              0.7258691085815687, -0.4827144425800136}, {
              0.7471728777333297, -0.49688178615389983`}, {
              0.765303318813862, -0.5089388163490833}, {
              0.7838847094396872, -0.5212957351272279}, {
              0.8029065978200733, -0.533945591882119}, {
              0.8224003393272158, -0.5469092384324004}, {
              0.8466177946481421, -0.5630142294118226}, {
              0.8562370834814834, -0.5694112086912909}}]}}, {
            Arrowheads[{{0.017658881855262085`, 1.}}], {
             LABColor[
             0.661398227926144, 0.4993590761601596, 0.7415627664533324], 
             
             ArrowBox[{{0.8595678202630854, -0.5716262013530583}, {
              0.8715255493262279, -0.5795782803863114}, {
              0.8971885602476074, -0.5966445887129543}, {
              0.9235851751169026, -0.6141987552727224}, {
              0.9500042865097602, -0.6317678823766202}, {
              0.9772019948976584, -0.6498547888019026}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2831855460470632, 0.5224273309395405, -0.6313178380278378], 
             
             ArrowBox[{{0.12063518826914202`, -0.1794627970601572}, {
              0.13248337155728918`, -0.1970887331031998}, {
              0.14544157249858317`, -0.21636598561267376`}, {
              0.15965385238270466`, -0.23750886719806832`}, {
              0.17526427249933427`, -0.2607316904688727}, {
              0.19228663245740946`, -0.28605498439722}, {
              0.20989540268620555`, -0.3122506508805268}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3538200873182143, 0.5223012066844493, -0.4625051352860582], 
             
             ArrowBox[{{0.21212690804663212`, -0.31557034722603605`}, {
              0.231221574065065, -0.3439765048469136}, {
              0.25373490632779033`, -0.3774684373168931}, {
              0.2688058208911459, -0.39988866578091486`}, {
              0.28482561954949004`, -0.42372050056159977`}, {
              0.3013871224636957, -0.4483582010464056}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4280512372015061, 0.5238906934698072, -0.2319783412934684], 
             
             ArrowBox[{{0.3036186278241223, -0.4516778973919149}, {
              0.3197118691511446, -0.4756189890729589}, {
              0.3387035736810877, -0.50387197615563}, {
              0.3588946694792854, -0.5339092362589578}, {
              0.3802851565457375, -0.5657307693829423}, {
              0.39287884224118585`, -0.5844657512122845}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5087007399406367, 0.5291459564148665, 0.1273172042970651], 
             
             ArrowBox[{{0.39511034760161245`, -0.5877854475577937}, {
              0.4028750348804442, -0.5993365755275837}, {
              0.414658961949521, -0.6168669208813066}, {
              0.42682116918791785`, -0.6349600142875054}, {
              0.43936165659563453`, -0.6536158557461803}, {
              0.4522804241726709, -0.672834445257331}, {
              0.4655774719190274, -0.692615782820958}, {
              0.47925279983470365`, -0.7129598684370608}, {
              0.484370562018676, -0.7205733013781633}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5895271012884212, 0.5344127437768283, 0.48740065939888444`], 
             
             ArrowBox[{{0.4866020673791026, -0.7238929977236725}, {
              0.49330640791969976`, -0.7338667021056398}, {
              0.5077382961740158, -0.7553362838266946}, {
              0.5200161132374297, -0.7736013640541759}, {
              0.5325982267544497, -0.7923191305457826}, {
              0.5454776070029357, -0.811479125543576}, {
              0.5586753431493071, -0.8311127223213713}, {
              0.5750567483535787, -0.8554825006581486}, {
              0.5758622817961662, -0.856680851544042}}]}}, {
            Arrowheads[{{0.019105038737155265`, 1.}}], {
             LABColor[
             0.6628047221031204, 0.49615182672964214`, 0.7423473908158911], 
             
             ArrowBox[{{0.5780937871565928, -0.8600005478895513}, {
              0.5919031734073742, -0.8805440652314416}, {
              0.609258180124028, -0.9063622207220249}, {
              0.6271072478990954, -0.9329153655696406}, {
              0.6449713995129599, -0.9594909498724413}, {
              0.6633597798628319, -0.9868464024426449}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.2923167670014336, 0.5224110263324713, -0.6094947177682712], 
             
             ArrowBox[{{0.20208289927138307`, 0.12693262856475593`}, {
              0.22184988113052234`, 0.1393486963033867}, {
              0.24352998321621427`, 0.15296643612803906`}, {
              0.2673429860476469, 0.16792389692413798`}, {0.2933098502012561, 
              0.18423424448192516`}, {0.3216105922076795, 
              0.20201055106778887`}, {0.33757220175966385`, 
              0.21203638236703626`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.36354977765154056`, 0.522283833457081, -0.4392517058384996], 
             
             ArrowBox[{{0.34095943432187087`, 0.21416397621209327`}, {
              0.3527035765174075, 0.22154072528137403`}, {
              0.38704716758093016`, 0.24311267572232514`}, {
              0.41004872595133246`, 0.2575604507471675}, {0.4344993168812746, 
              0.27291839438262205`}, {0.4603989403707566, 
              0.2891865066286888}, {0.47644873681015165`, 
              0.2992677300143737}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.43890018221225663`, 0.5245976297406036, -0.18364602076661107`], 
             
             ArrowBox[{{0.4798359693723587, 0.3013953238594307}, {
              0.4877475964197785, 0.3063647874853676}, {0.5167366754993672, 
              0.32457345343637534`}, {0.5475575680805493, 
              0.34393272096542865`}, {0.580210274163325, 
              0.3644425900725276}, {0.6146947937476943, 
              0.38610306075767203`}, {0.6153252718606395, 
              0.38649907766171104`}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5197068841917024, 0.5298631360636696, 0.17634985135907968`], 
             
             ArrowBox[{{0.6187125044228465, 0.38862667150676805`}, {
              0.6326839136588509, 0.3974024150529765}, {0.6512508470571546, 
              0.40906470646472287`}, {0.6703955939426055, 
              0.421089934992911}, {0.6901181543152033, 0.4334781006375408}, {
              0.7104185281749485, 0.4462292033986125}, {0.7312967155218407, 
              0.459343243276126}, {0.7527527163558799, 0.4728202202700812}, {
              0.7542018069111274, 0.4737304253090484}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6005652830826245, 0.5351320110480915, 0.5365760345143901], 
             
             ArrowBox[{{0.7575890394733343, 0.4758580191541054}, {
              0.7747865306770664, 0.4866601343804782}, {0.7935337439754643, 
              0.49843566348665025`}, {0.8127458927981971, 
              0.5105032286257065}, {0.8324122300251959, 0.5228560792996843}, {
              0.8525649970166673, 0.5355144670024717}, {0.8775830937673111, 
              0.5512288732867066}, {0.8930783419616151, 
              0.5609617729563858}}]}}, {
            Arrowheads[{{0.008947394314782184, 1.}}], {
             LABColor[
             0.6706180213268876, 0.4783350451914758, 0.7467061041495696], 
             
             ArrowBox[{{0.8964655745238221, 0.5630893668014428}, {
              0.9033119096497233, 0.5673896975899417}, {0.9298180770840944, 
              0.5840387931727598}, {0.9570793852636945, 
              0.6011622089483001}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2787076287984648, 0.5224353266590168, -0.6420198161222106], 
             
             ArrowBox[{{-0.20473255640473847`, 
              0.032578091565790605`}, {-0.24760269345003783`, 
              0.03939980704976446}, {-0.2729263132355597, 
              0.04342943095832864}, {-0.30062215378366874`, 
              0.04783653476835535}, {-0.33120118691308525`, 
              0.052702426929219406`}, {-0.36274456668105176`, 
              0.057721770859765556`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.34973125666637456`, 0.522308507655205, -0.47227721762663416`], 
             
             
             ArrowBox[{{-0.3666948669379596, 
              0.05835036284211492}, {-0.3884586715188572, 
              0.06181353074714894}, {-0.4133233254314334, 
              0.06577012165843622}, {-0.43976834618025806`, 
              0.06997818862415749}, {-0.46779373376533107`, 
              0.07443773164431267}, {-0.497625689054144, 
              0.07918474495793641}, {-0.5247068772142729, 
              0.0834940421360899}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4236842848405764, 0.5236061352004344, -0.25143322294553844`], 
             
             ArrowBox[{{-0.5286571774711807, 
              0.08412263411843926}, {-0.5294904129141879, 
              0.08425522280406328}, {-0.5633879053454631, 
              0.08964916518269328}, {-0.5993181663479693, 
              0.0953665720938264}, {-0.637568839818349, 
              0.10145321490557194`}, {-0.6784275696532441, 
              0.10795486498603907`}, {-0.686669187747494, 
              0.10926631341241418`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5044075431504165, 0.5288662041877452, 0.10819090555150174`], 
             
             ArrowBox[{{-0.6906194880044018, 
              0.10989490539476356`}, {-0.6998349557073852, 
              0.1113613177520433}, {-0.7218943558526549, 
              0.1148715223352279}, {-0.7446057700890537, 
              0.11848547873559294`}, {-0.7679691984165814, 
              0.12220318695313838`}, {-0.808296656878827, 
              0.12862029841537892`}, {-0.848631498280715, 
              0.1350385846887385}}]}}, {
            Arrowheads[{{0.014334124237954948`, 1.}}], {
             LABColor[
             0.5851308014602564, 0.534126273175056, 0.4678150340485422], 
             
             ArrowBox[{{-0.8525817985376228, 
              0.13566717667108788`}, {-0.8781747899667739, 
              0.13973966437340074`}, {-0.9064612216956519, 
              0.14424074607293813`}, {-0.9356894412504655, 
              0.14889168986850784`}, {-0.9658299878571073, 
              0.15368780781104444`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.27907912882377917`, 0.5224346633126835, -0.6411319513153704], 
             
             ArrowBox[{{-0.034837377591671805`, 
              0.20522783539810255`}, {-0.038318973023506, 
              0.22573799843569198`}, {-0.042149553189283574`, 
              0.2483040389957992}, {-0.046455921733502055`, 
              0.27367296042023254`}, {-0.051165371489579566`, 
              0.30141644302918075`}, {-0.05636455318947038, 
              0.3320449483838748}, {-0.0616142921895025, 
              0.3629712880185536}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.35009682525853064`, 0.522307854899973, -0.47140352862166873`], 
             
             
             ArrowBox[{{-0.06228371505444826, 
              0.3669148743340649}, {-0.06609609216269857, 
              0.3893736802412734}, {-0.07032012284883596, 
              0.41425754734895054`}, {-0.07481220962354086, 
              0.4407205393685772}, {-0.0795723524868133, 
              0.4687626563001533}, {-0.0846388496670786, 
              0.498609513935184}, {-0.08906062965227894, 
              0.524658326954516}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4241052791553172, 0.5236335679278189, -0.24955768277643697`], 
             
             ArrowBox[{{-0.08973005251722471, 
              0.5286019132700273}, {-0.09004999939276209, 
              0.5304867280651747}, {-0.09580580166386381, 
              0.5643942986901255}, {-0.10190625648038373`, 
              0.6003322258100362}, {-0.1084000482118953, 
              0.6385873102255407}, {-0.11533586122797189`, 
              0.679446352737273}, {-0.11650696711505538`, 
              0.6863453658904783}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5048285374651573, 0.5288936369151297, 0.11006644572060355`], 
             
             ArrowBox[{{-0.11717638998000116`, 
              0.6902889522059896}, {-0.1189695257177221, 
              0.7008523582792247}, {-0.12271369552861358`, 
              0.7229093533452332}, {-0.1265683706606463, 
              0.7456173379352985}, {-0.1305335511138203, 
              0.7689763120494209}, {-0.13737863562613356`, 
              0.8093008707474026}, {-0.14395330457783187`, 
              0.8480324048264407}}]}}, {
            Arrowheads[{{0.014546553794306857`, 1.}}], {
             LABColor[
             0.5855517957749973, 0.5341537059024405, 0.46969057421764415`], 
             
             ArrowBox[{{-0.14462272744277765`, 
              0.851975991141952}, {-0.149234983063711, 
              0.8791469007460424}, {-0.15403173011959911`, 
              0.9074046538631277}, {-0.15898783365950125`, 
              0.936601179888271}, {-0.16409831887492288`, 
              0.9667071721041063}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.28229936927081223`, 0.5224289132869837, -0.6334357522099607], 
             
             ArrowBox[{{-0.04089540536509323, -0.211663124885464}, \
{-0.045032176483461576`, -0.23307388959198436`}, {-0.049589354644662686`, \
-0.2566605630006053}, {-0.054622833857442, -0.2827124367920871}, \
{-0.06012499306983857, -0.31119006654330755`}, {-0.0661954367351255, \
-0.3426089769114765}, {-0.07124765014576663, -0.368757813646014}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3533397202275111, 0.5223020644226096, -0.4636531864438977], 
             
             ArrowBox[{{-0.07200645626528347, -0.3726851808650278}, \
{-0.07293376930657594, -0.377484692553804}, {-0.07753945638903838, \
-0.4013224345058795}, {-0.0824545556740024, -0.4267616070605986}, \
{-0.08767906716146798, -0.4538022102179614}, {-0.09321299085143514, \
-0.48244424397796776`}, {-0.09910012452540856, -0.5129143933487151}, \
{-0.10235870104595689`, -0.5297798696255778}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4277545465252238, 0.5238713605853597, -0.23330010565389178`], 
             
             ArrowBox[{{-0.10311750716547372`, -0.5337072368445915}, \
{-0.10538426596489286`, -0.5454393433383007}, {-0.11206541516988812`, \
-0.5800190939467248}, {-0.11914357214039428`, -0.616653645173987}, \
{-0.1266743134545158, -0.6556306457690609}, {-0.13346975194614713`, \
-0.6908019256051415}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5084778048350639, 0.5291314295726706, 0.12632402284314836`], 
             
             ArrowBox[{{-0.13422855806566397`, -0.6947292928241553}, \
{-0.13471321569035707`, -0.6972377444809195}, {-0.13892322715392266`, \
-0.7190275806306434}, {-0.14326027884791814`, -0.7414749413095633}, \
{-0.14772437077234357`, -0.7645798265176793}, {-0.15231550292719898`, \
-0.7883422362549917}, {-0.16024619969163947`, -0.8293892938570502}, \
{-0.16436387108669104`, -0.8507012037634876}, {-0.16458080284633733`, \
-0.8518239815847054}}]}}, {
            Arrowheads[{{0.01696864676732932, 1.}}], {
             LABColor[
             0.589201063144904, 0.5343914985599814, 0.4859481513401888], 
             
             ArrowBox[{{-0.16533960896585417`, -0.8557513488037192}, \
{-0.16858982478012385`, -0.8725735524145845}, {-0.17395664393943172`, \
-0.9003507000871172}, {-0.1794883644320714, -0.9289813307169452}, \
{-0.18520183334396012`, -0.9585526400860551}, {-0.19109143497979228`, \
-0.9890355629337848}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2820716119995477, 0.5224293199678465, -0.6339800796712756], 
             
             ArrowBox[{{0.04997162375800525, 0.20916677818896562`}, {
              0.055049422083676365`, 0.23042097479497062`}, {
              0.060645891236948246`, 0.2538461776199295}, {
              0.06679271703842382, 0.2795750143535465}, {0.073511325714045, 
              0.3076971689866945}, {0.08092281242589222, 
              0.33871951087845803`}, {0.08715059901370603, 
              0.36478722607077835`}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.35311355774109304`, 0.5223024682558421, -0.46419370245637487`], 
             
             ArrowBox[{{0.08808007339509856, 0.36867773726782366`}, {
              0.08914827233604587, 0.37314890938792156`}, {
              0.09475815466936731, 0.3966302559089473}, {0.10074351087286876`,
               0.42168322756066745`}, {0.10710434094655019`, 
              0.4483078243430822}, {0.11384064489041164`, 
              0.4765040462561915}, {0.12100535795057869`, 
              0.5064934649451025}, {0.12525904865079937`, 
              0.5242981851496363}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.427496445556692, 0.5238545422739016, -0.23444995190410428`], 
             
             ArrowBox[{{0.12618852303219188`, 0.5281886963466816}, {
              0.12865141537317692`, 0.5384976520549218}, {0.1367788171582064, 
              0.57251660758565}, {0.14538756330566702`, 0.6085503315372868}, {
              0.15454477361958685`, 0.6468797680158151}, {
              0.16336749828789265`, 0.6838091442284944}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5082197038665319, 0.5291146112612124, 0.12517417659293584`], 
             
             ArrowBox[{{0.16429697266928517`, 0.6876996554255397}, {
              0.16431756790399377`, 0.6877858611272176}, {
              0.16943480903512992`, 0.7092051539202469}, {
              0.17470594615888785`, 0.7312686108714945}, {
              0.18013097927526756`, 0.7539762319809609}, {
              0.18570990838426907`, 0.7773280172486458}, {
              0.19534729364176348`, 0.8176673272986422}, {
              0.20035048462429983`, 0.8386092391234219}, {
              0.20147594792498597`, 0.8433201033073524}}]}}, {
            Arrowheads[{{0.01633433081857328, 1.}}], {
             LABColor[
             0.5889429621763721, 0.5343746802485233, 0.48479830508997634`], 
             
             ArrowBox[{{0.20240542230637848`, 0.8472106145043977}, {
              0.20548480499065816`, 0.8601000206601961}, {
              0.21199405193366494`, 0.8873458475738552}, {
              0.21870235932813958`, 0.9154248840205885}, {
              0.22562995876195494`, 0.9444218135814922}, {
              0.23277010637248677`, 0.9743084083962013}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.28031623372684644`, 0.5224324543518611, -0.6381753380422663], 
             
             ArrowBox[{{0.2071726357595487, -0.040068667169667685`}, {
              0.22800822619182087`, -0.04409841914561485}, {
              0.2509473237972443, -0.04853500442993308}, {
              0.27650740944446617`, -0.05347850751793454}, {
              0.30445419370991056`, -0.05888361516204572}, {
              0.3352978310087432, -0.0648489948691575}, {
              0.36426154982164505`, -0.070450784916647}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.3513357859005393, 0.5223056426255638, -0.46844248023366725`], 
             
             ArrowBox[{{0.36818877267319744`, -0.07121033786032148}, {
              0.36954847575613, -0.07147331414616083}, {
              0.3929727687184369, -0.07600373967726626}, {
              0.4179769906234799, -0.0808397347481235}, {
              0.4445611414712589, -0.08598129935873255}, {
              0.4727252212617739, -0.09142843350909341}, {
              0.5026938367672085, -0.09722457775285678}, {
              0.5252776867352937, -0.10159245560730076`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.42550720135031184`, 0.5237249196350581, -0.24331208444267718`], 
             
             ArrowBox[{{0.5292049095868462, -0.10235200855097525`}, {
              0.5346915947597457, -0.10341317264367338`}, {
              0.5687184952393859, -0.10999421818154322`}, {
              0.6047745382061289, -0.11696771436646626`}, {
              0.6431449694128085, -0.12438882976397218`}, {
              0.6841150346122578, -0.13231273293959056`}, {
              0.6862938236489425, -0.13273412629795459`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5062304596601518, 0.5289849886223689, 0.11631204405436309`], 
             
             ArrowBox[{{0.690221046500495, -0.13349367924162908`}, {
              0.7055749299592714, -0.136463229944192}, {
              0.7276847338044773, -0.1407394238933215}, {
              0.7504444461478758, -0.14514131478697914`}, {
              0.7738540669894668, -0.14966890262516494`}, {
              0.8142787236281388, -0.15748731989038234`}, {
              0.8473099605625913, -0.1638757969886084}}]}}, {
            Arrowheads[{{0.015344761293725993`, 1.}}], {
             LABColor[
             0.5869617438307178, 0.5342455805888308, 0.47597192796105137`], 
             
             ArrowBox[{{0.8512371834141438, -0.1646353499322829}, {
              0.8568150677670185, -0.16571415259763894`}, {
              0.884224566888444, -0.17101534545815922`}, {
              0.9124802306930586, -0.17648019261084574`}, {
              0.9416689562324736, -0.18212550056600937`}, {
              0.971761777822819, -0.18794566715354655`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.281994590207456, 0.5224294574971059, -0.6341641575552546], 
             
             ArrowBox[{{0.04377881712055286, -0.21036891683085163`}, {
              0.04821079768507805, -0.2316657679588105}, {
              0.053093585081502935`, -0.25512886639915194`}, {
              0.05848241798239562, -0.28102364873695607`}, {
              0.06437302682691126, -0.30932959859125725`}, {
              0.07087200162138603, -0.34055890943033}, {
              0.0763772132550586, -0.36701292268315944`}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.35303307824394037`, 0.5223026119591414, -0.4643860440669402], 
             
             ArrowBox[{{0.07719217315842124, -0.37092902282946716`}, {
              0.07808593237215619, -0.37522377472244933`}, {
              0.08301350744013979, -0.3989020898948289}, {
              0.08827187258682928, -0.42416993980415973`}, {
              0.09386102781222472, -0.45102732445044197`}, {
              0.09978097311632603, -0.47947424383367526`}, {
              0.10607849459036803`, -0.5097355176265501}, {
              0.10979056929292696`, -0.527573028681775}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4274091622878569, 0.5238488547431314, -0.2348388010430565], 
             
             ArrowBox[{{0.11060552919628962`, -0.5314891288280827}, {
              0.11280037832558536`, -0.5420359655017559}, {
              0.11994662432197813`, -0.5763755874592935}, {
              0.12751723257954625`, -0.6127543834991622}, {
              0.13557156248510782`, -0.6514575913397382}, {
              0.1432039253307954, -0.6881331346803905}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5081324205976969, 0.5291089237304422, 0.12478532745398377`], 
             
             ArrowBox[{{0.14401888523415804`, -0.6920492348266982}, {
              0.14416897342548088`, -0.6927704486993971}, {
              0.14867133428372176`, -0.7144054959488828}, {
              0.15330946540066548`, -0.7366929555781392}, {
              0.15808336677631207`, -0.7596328275871662}, {
              0.16299303841066154`, -0.7832251119759641}, {
              0.1714738281581386, -0.8239775733349386}, {
              0.17587700080242424`, -0.8451359947067838}, {
              0.17661728136866378`, -0.8486932406790061}}]}}, {
            Arrowheads[{{0.016574521279709223`, 1.}}], {
             LABColor[
             0.588855678907537, 0.5343689927177531, 0.48440945595102425`], 
             
             ArrowBox[{{0.17743224127202642`, -0.8526093408253138}, {
              0.18039588306809773`, -0.8668504317345852}, {
              0.18613263615010905`, -0.8944170635297188}, {
              0.19204548316202336`, -0.9228298737218651}, {
              0.1981523951603106, -0.9521752180404053}, {
              0.20444738179281421`, -0.9824243112422124}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.2943061658700987, 0.5224074740838706, -0.604740162931402], 
             
             ArrowBox[{{-0.20924233999046568`, -0.12399216109576444`}, \
{-0.22966542277431148`, -0.13609440661032965`}, {-0.25206110090659317`, \
-0.14936556640979134`}, {-0.2766554003352289, -0.16393957823231167`}, \
{-0.3034702208625939, -0.17982941939320937`}, {-0.33269076320749746`, \
-0.19714483554607778`}, {-0.346889937354023, -0.20555893705289055`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3655391765202057, 0.5222802812084802, -0.4344971510016304], 
             
             ArrowBox[{{-0.35033112728811194`, -0.2075981064518187}, \
{-0.36478800469250977`, -0.2161649169364916}, {-0.40023292264020083`, \
-0.2371687538100255}, {-0.4239736764931752, -0.25123697430692404`}, \
{-0.44920707846510405`, -0.2661897034842032}, {-0.4759331285559875, \
-0.2820269413418628}, {-0.48797872465166925`, -0.28916488240894483`}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.4412001463626464, 0.5247474994355675, -0.1733996231300887], 
             
             ArrowBox[{{-0.4914199145857582, -0.291204051807873}, \
{-0.5041518267658256, -0.29874868787990305`}, {-0.5340599073185568, \
-0.31647152323974614`}, {-0.5658541044381191, -0.33531202756281436`}, \
{-0.599534418124513, -0.3552702008491078}, {-0.6290675119493154, \
-0.37277082776499915`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5219361606854234, 0.5300083996270376, 0.1862813337226399], 
             
             ArrowBox[{{-0.6325087018834044, -0.3748099971639273}, \
{-0.6351008483777383, -0.37634604309862635`}, {-0.6536529364530393, \
-0.38733958051270967`}, {-0.6727997121423012, -0.39868551602382857`}, \
{-0.692541175445524, -0.41038384963198293`}, {-0.7128773263627077, \
-0.4224345813371727}, {-0.7338081648938525, -0.4348377111393982}, \
{-0.755333691038958, -0.44759323903865905`}, {-0.7701562992469617, \
-0.4563767731210534}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6028075039581205, 0.5352781180900624, 0.54656518442151], 
             
             ArrowBox[{{-0.7735974891810506, -0.4584159425199816}, \
{-0.7774539047980245, -0.4607011650349555}, {-0.8001688061710519, \
-0.47416148912828743`}, {-0.8194924108042692, -0.48561220937325267`}, \
{-0.8392942872323446, -0.49734634239900755`}, {-0.8595634004261419, \
-0.5093573491030432}, {-0.8803328554730696, -0.5216648467928857}, \
{-0.9061041454523452, -0.5369363159367578}, {-0.911245086544608, \
-0.5399827184771077}}]}}, {
            Arrowheads[{{0.010649873420156997`, 1.}}], {
             LABColor[
             0.6722481496902329, 0.47461783942511454`, 0.7476154846851706], 
             
             ArrowBox[{{-0.9146862764786969, -0.5420218878760358}, \
{-0.9326058654740217, -0.5526406209946744}, {-0.9599063237604679, \
-0.5688182398360402}, {-0.987982750904228, -0.5854556798377206}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2919559047377629, 0.5224116706841352, -0.6103571589047391], 
             
             ArrowBox[{{0.23344811032498222`, 0.045337932526110424`}, {
              0.25708655216810977`, 0.04992875178703384}, {0.28317333284232, 
              0.054995062670357434`}, {0.31168849564068457`, 
              0.06053298938616413}, {0.34314783662317755`, 
              0.06664270463206874}, {0.37806715184977274`, 
              0.07342438110568607}, {0.39051347100748957`, 
              0.07584157941748844}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3631187767143326, 0.5222846030475841, -0.440281774580859], 
             
             ArrowBox[{{0.39444010502455223`, 0.07660417058977288}, {
              0.40193235473948574`, 0.07805923960520228}, {0.4274001692925392,
               0.08300534114436847}, {0.4544705955089333, 
              0.08826268572318463}, {0.48314363338866795`, 
              0.09383127334165078}, {0.5136460334887142, 
              0.09975514120117282}, {0.5462045463660425, 
              0.10607832650315657`}, {0.5515054657070596, 
              0.10710781748115086`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.438697605084207, 0.5245844294599027, -0.18454850692306274`], 
             
             ArrowBox[{{0.5554320997241223, 0.1078704086534353}, {
              0.5808191720206534, 0.1128008292476021}, {0.6174899104525464, 
              0.11992264943450937`}, {0.6565044690149904, 
              0.12749966267817053`}, {0.6981505550612535, 
              0.13558774459287776`}, {0.7124974604066296, 
              0.13837405554481333`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.519420863394047, 0.5298444984472134, 0.17507562157397755`], 
             
             ArrowBox[{{0.7164240944236924, 0.13913664671709777`}, {
              0.7199604208908174, 0.13982343630187366`}, {0.742428168591336, 
              0.14418689517863106`}, {0.7655537981628094, 
              0.14867812122314997`}, {0.7893373096052377, 
              0.15329711443543043`}, {0.8304218826038959, 
              0.16127614496124695`}, {0.8517530005054978, 
              0.16541885908638176`}, {0.8734894551061997, 
              0.16964029360847577`}}]}}, {
            Arrowheads[{{0.014359708159661259`, 1.}}], {
             LABColor[
             0.6001441217038871, 0.5351045674345242, 0.5346997500710181], 
             
             ArrowBox[{{0.8774160891232624, 0.1704028847807602}, {
              0.9014417245963697, 0.17506890087513036`}, {0.9300922468976368, 
              0.1806331157455116}, {0.9596835992668268, 
              0.18638004912271067`}, {0.9901867261928994, 
              0.19230405813903753`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.30503744576918396`, 0.5223883124292595, -0.5790929890269401], 
             
             ArrowBox[{{-0.2624386455834278, -0.05537494775706377}, \
{-0.2889546945122515, -0.060969873843094755`}, {-0.31793061850702703`, \
-0.0670838372567387}, {-0.34988498735193596`, -0.07382625700007742}, \
{-0.38533637083116007`, -0.08130655207519281}, {-0.40952969393183863`, \
-0.08641137952844971}, {-0.4189915982975929, -0.08840785553818974}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.37639622268476225`, 0.5222608949870177, -0.4085494025792925], 
             
             ArrowBox[{{-0.422905422115447, -0.08923367823271788}, \
{-0.43533840501719456`, -0.091857056268823}, {-0.46276250408722797`, \
-0.09764358229631265}, {-0.4918019911419387, -0.10377095761091869`}, \
{-0.5226840160564473, -0.11028711117691334`}, {-0.555635728705874, \
-0.11723997195856874`}, {-0.5794583748296122, -0.12226658601384385`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.453664498505872, 0.5255596984662837, -0.11787062355003422`], 
             
             ArrowBox[{{-0.5833721986474663, -0.123092408708372}, \
{-0.590657129090219, -0.12462953995588498`}, {-0.627748217209482, \
-0.132455815168862}, {-0.6671968681438947, -0.14077953967111076`}, \
{-0.7092909569736878, -0.14966145553624197`}, {-0.7313300405993522, \
-0.15431173522988853`}, {-0.7399251513616314, -0.15612531648949796`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5343877568157119, 0.5308197674535946, 0.24175350494700606`], 
             
             ArrowBox[{{-0.7438389751794855, -0.15695113918402612`}, \
{-0.7540304836988618, -0.15910156276425574`}, {-0.7773922862722166, \
-0.1640309381393436}, {-0.8014154483194164, -0.16909986135515206`}, \
{-0.8429261378351743, -0.17785867909018743`}, {-0.8644746848213105, \
-0.18240545481731102`}, {-0.8865869258816939, -0.18707117083938632`}, \
{-0.9003919278936506, -0.1899840469651521}}]}}, {
            Arrowheads[{{0.012225160449476045`, 1.}}], {
             LABColor[
             0.615111015125552, 0.5360798364409054, 0.6013776334440464], 
             
             ArrowBox[{{-0.9043057517115047, -0.19080986965968025`}, \
{-0.9145940848460394, -0.19298072337890132`}, {-0.9434554560551495, \
-0.19907051598299258`}, {-0.9732576039247036, -0.20535881387317595`}, {-1., \
-0.21100149954653075`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3567641725037384, 0.522295949758528, -0.45546893220005696`], 
             
             ArrowBox[{{-0.30114249591236614`, 
              0.24360265546789472`}, {-0.32940893815165473`, 
              0.26646817754992047`}, {-0.3601435904269804, 
              0.2913303043197354}, {-0.3765798151330314, 
              0.30462602989353876`}, {-0.39380507611394056`, 
              0.3185600291564594}, {-0.41187670129165765`, 
              0.3331786762808873}, {-0.42553790109970047`, 
              0.3442296059746}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4313630996681825, 0.5241065002325167, -0.21722391142755484`], 
             
             ArrowBox[{{-0.4286477862293838, 
              0.34674527973726765`}, {-0.43085201858813227`, 
              0.3485283454392124}, {-0.4554753288037675, 
              0.36844683531147543`}, {-0.48158711390815745`, 
              0.389569394487871}, {-0.5091873739013023, 
              0.41189602296839917`}, {-0.5382761087832022, 
              0.43542672075306016`}, {-0.5530431914167182, 
              0.44737223024397293`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5121727563069498, 0.5293721990863625, 0.14278512377908367`], 
             
             ArrowBox[{{-0.5561530765464016, 
              0.4498879040066406}, {-0.5690414305313765, 
              0.46031365692416887`}, {-0.6016714511233445, 
              0.4867090005640404}, {-0.6186857234857515, 
              0.5004723251847624}, {-0.6361661705591067, 
              0.514612751672675}, {-0.6541127923434106, 
              0.5291302800277783}, {-0.6725255888386628, 
              0.5440249102500723}, {-0.6805484817337359, 
              0.5505148545133458}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5929535576399501, 0.5346360176779125, 0.5026656078790613], 
             
             ArrowBox[{{-0.6836583668634193, 
              0.5530305282760134}, {-0.6914629888122084, 
              0.5593439070168248}, {-0.7109834210313921, 
              0.5751345350053038}, {-0.731086885496214, 
              0.591396794215509}, {-0.7517733822066739, 
              0.6081306846474406}, {-0.7730429111627722, 
              0.6253362063010984}, {-0.7948954723645083, 
              0.6430133591764824}, {-0.8080537720507536, 
              0.6536574787827186}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6653019223776115, 0.49045742408698917`, 0.7437404745595906], 
             
             ArrowBox[{{-0.8111636571804369, 
              0.6561731525453862}, {-0.8173310658118828, 
              0.661162143273593}, {-0.8403496915048954, 
              0.6797825585924298}, {-0.8597969183769835, 
              0.695513968711664}, {-0.8797049131121724, 
              0.7116181069464224}, {-0.9000634645182102, 
              0.728086713175394}, {-0.9209032061718525, 
              0.7449445677625111}, {-0.9355590623677712, 
              0.7568001030520916}}]}}, {
            Arrowheads[{{0.009860662041364543, 1.}}], {
             LABColor[
             0.7227588864531883, 0.35943746088542133`, 0.7757933152683011], 
             
             ArrowBox[{{-0.9386689474974546, 
              0.7593157768147593}, {-0.9465703357079809, 
              0.7657074325129543}, {-0.9729312391322824, 
              0.7870315105220614}, {-1., 0.8089281943747462}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3572602738210232, 0.5222950639255068, -0.45428327709849525`], 
             
             ArrowBox[{{-0.24483105131885904`, 
              0.30161770348562483`}, {-0.26780107749102217`, 
              0.32991544801489026`}, {-0.2927760290959878, 
              0.3606831447885474}, {-0.30613168342631597`, 
              0.3771365389391738}, {-0.32012816690349805`, 
              0.3943793975574791}, {-0.33481201212375167`, 
              0.4124690461123236}, {-0.3456679735313873, 
              0.425842963069594}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4319292369441269, 0.5241433907296312, -0.214701755747345], 
             
             ArrowBox[{{-0.3481888965867005, 
              0.42894859455919326`}, {-0.3502297516832946, 
              0.4314628100725677}, {-0.37023490862673136`, 
              0.45610800708759236`}, {-0.391448700263179, 
              0.48224217218283094`}, {-0.4138711265926378, 
              0.5098653053582838}, {-0.43750218761510756`, 
              0.5389774066139507}, {-0.44902581879922865`, 
              0.5531738541431626}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.512729445581533, 0.5294084739351497, 0.14526518837765554`], 
             
             ArrowBox[{{-0.45154674185454186`, 
              0.5562794856327617}, {-0.46249453864614887`, 
              0.5697665384748105}, {-0.48900083500132235`, 
              0.6024207634658418}, {-0.5028217126754586, 
              0.6194472858851721}, {-0.5170210766806279, 
              0.6369400815870451}, {-0.5315989270168301, 
              0.6548991505714611}, {-0.5465552636840655, 
              0.67332449283842}, {-0.5523836640670701, 
              0.6805047452167309}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5935086779794141, 0.5346721902921376, 0.505138682832558], 
             
             ArrowBox[{{-0.5549045871223832, 
              0.6836103767063301}, {-0.5619374972754034, 
              0.6922745154981537}, {-0.5777930383839136, 
              0.7118076256608938}, {-0.5941218870095962, 
              0.7319238233266406}, {-0.6109240431524507, 
              0.7526231084953938}, {-0.628199506812478, 
              0.7739054811671539}, {-0.6459482779896772, 
              0.7957709413419203}, {-0.6557415093349115, 
              0.8078356362902993}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.6657022205672665, 0.48954461821702955`, 0.7439637842021278], 
             
             ArrowBox[{{-0.6582624323902247, 
              0.8109412677798985}, {-0.6641703566840489, 
              0.8182194890196932}, {-0.6828657428955927, 
              0.8412511242004727}, {-0.6986584295221436, 
              0.8607068012745576}, {-0.7148250518598928, 
              0.8806231455305841}, {-0.7313573280303995, 
              0.9009899541730232}, {-0.7482801036689863, 
              0.9218378355884629}, {-0.759099354602753, 
              0.9351665273638677}}]}}, {
            Arrowheads[{{0.009938049854475623, 1.}}], {
             LABColor[
             0.7231591846428432, 0.35852465501546166`, 0.7760166249108384], 
             
             ArrowBox[{{-0.7616202776580662, 
              0.9382721588534669}, {-0.7691214385324486, 
              0.9475131554681524}, {-0.7905257290255715, 
              0.9738820041435884}, {-0.8117263956640655, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3655236807615848, 0.5222803088775354, -0.4345341850199272], 
             
             ArrowBox[{{0.27058708956686933`, 0.30470773978984095`}, {
              0.29577876047410084`, 0.3330760448555378}, {
              0.32315484285139706`, 0.3639042125956877}, {0.3377872406282664, 
              0.3803817350873657}, {0.3531159840169883, 0.3976434113900764}, {
              0.36919115393234153`, 0.4157456375512934}, {
              0.37682733657143785`, 0.4243447320472873}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.44135683915304047`, 0.52475770981241, -0.17270155284195746`], 
             
             ArrowBox[{{0.37948334274655204`, 0.42733565685372343`}, {
              0.38606283128910496`, 0.43474480961848977`}, {
              0.40792390032545517`, 0.4593625286165345}, {0.4310936763324259, 
              0.4854539806877399}, {0.45557215931001716`, 
              0.5130191658321059}, {0.48135934925822893`, 
              0.5420580840496327}, {0.4857235897511206, 
              0.5469726491111697}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5220845088326809, 0.5300180662523084, 0.18694222841753536`], 
             
             ArrowBox[{{0.48837959592623487`, 0.5499635739176059}, {
              0.4947846311826616, 0.5571762750830017}, {0.5086189335224374, 
              0.5727550634290017}, {0.5228622562775563, 0.5887944490876326}, {
              0.5375145994480183, 0.6052944320588942}, {0.5525759630338236, 
              0.6222550123427869}, {0.5680463470349723, 0.6396761899393106}, {
              0.5839257514514637, 0.6575579648484651}, {0.5946198429308033, 
              0.6696005661750523}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6028171519678865, 0.535278746771288, 0.546608166545578], 
             
             ArrowBox[{{0.5972758491059175, 0.6725914909814884}, {
              0.6002141762832987, 0.6759003370702505}, {0.6169623685416245, 
              0.6947604527423216}, {0.6342210752375893, 0.7141954580023326}, {
              0.6519902963711928, 0.7342053528502839}, {0.6702700319424352, 
              0.7547901372861752}, {0.6890602819513165, 0.7759498113100067}, {
              0.703516096110486, 0.7922284832389347}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6723697893300112, 0.47434046275922187`, 0.7476833423602219], 
             
             ArrowBox[{{0.7061721022856002, 0.7952194080453708}, {
              0.7083610463978366, 0.7976843749217783}, {0.7281723252819957, 
              0.8199938281214902}, {0.7484941186037936, 0.8428781709091421}, {
              0.7656213638204947, 0.8621651375828336}, {0.7831497498534075, 
              0.8819038283636912}, {0.8010704814435967, 0.9020843389230374}, {
              0.8124123492901687, 0.9148564003028172}}]}}, {
            Arrowheads[{{0.013733657682393523`, 1.}}], {
             LABColor[
             0.729826753405588, 0.343320499557654, 0.7797361830689327], 
             
             ArrowBox[{{0.8150683554652829, 0.9178473251092534}, {
              0.8194099443678663, 0.9227363822469034}, {0.8419725187395726, 
              0.9481440654133384}, {0.8651378282198365, 0.9742304877351213}, {
              0.8880217146879668, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.37461848329674663`, 0.5222640692987924, -0.41279810279678797`], 
             
             ArrowBox[{{-0.27115797361930377`, -0.33130606930479434`}, \
{-0.296416046349436, -0.3621668722630851}, {-0.3099220469167677, \
-0.37866876560690094`}, {-0.32407525763851275`, -0.39596143286531266`}, \
{-0.3389226040293485, -0.4141022085419322}, {-0.3545110116039522, \
-0.43314842714037133`}, {-0.3724960257868581, -0.4551228661575883}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.451649914052447, 0.5254284246125314, -0.126845647521017], 
             
             ArrowBox[{{-0.37502947709104695`, -0.45821828607890813`}, \
{-0.39617573514581633`, -0.4840551941481007}, {-0.41883812129008896`, \
-0.5117445369113256}, {-0.44272052368325515`, -0.5409245191807904}, \
{-0.4679768010920259, -0.5717831285806345}, {-0.4763675292586012, \
-0.582035082931702}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5323731723622871, 0.5306884935998422, 0.23277848097602344`], 
             
             ArrowBox[{{-0.47890098056279007`, -0.5851305028530219}, \
{-0.49476081228311175`, -0.6045083527349964}, {-0.5087257180470229, \
-0.6215709453451217}, {-0.523072557256513, -0.6391001916438765}, \
{-0.5378013299115817, -0.6570960916312608}, {-0.5529120360122294, \
-0.6755586453072746}, {-0.5684524467398586, -0.6945462204275304}, \
{-0.5802390327303444, -0.7089472997058158}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6130964306721272, 0.5359485625871531, 0.5924026094730638], 
             
             ArrowBox[{{-0.5827724840345332, -0.7120427196271357}, \
{-0.5844703332758724, -0.7141171847476413}, {-0.6009656956202705, \
-0.7342715382676064}, {-0.617938533773053, -0.7550092809874263}, \
{-0.6353888477342202, -0.776330412907101}, {-0.6533166375037716, \
-0.7982349340266303}, {-0.6717219030817075, -0.8207228443460143}, \
{-0.6841105362020875, -0.8358595164799296}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.6796243253190968, 0.45779783727201023`, 0.7517303450206464], 
             
             ArrowBox[{{-0.6866439875062764, -0.8389549364012494}, \
{-0.6906046444680279, -0.8437941438652529}, {-0.7065502029306479, \
-0.863276736343014}, {-0.722872684893493, -0.8832198612610404}, \
{-0.7395637552334468, -0.9036133346043087}, {-0.7566484193198585, \
-0.9244877084178874}, {-0.7776853728417261, -0.9501910660896141}, \
{-0.7879820396738306, -0.9627717332540435}}]}}, {
            Arrowheads[{{0.005513443683285909, 1.}}], {
             LABColor[
             0.7370112328371801, 0.32693762507247504`, 0.7837441041016715], 
             
             ArrowBox[{{-0.7905154909780194, -0.9658671531753634}, \
{-0.7992895892122076, -0.9765875165077145}, {-0.8184515731580044, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.37465430438976743`, 0.5222640053370452, -0.412712492337384], 
             
             ArrowBox[{{0.331355059217417, -0.27122832712451983`}, {
              0.3622195097000681, -0.29649220355905537`}, {
              0.3787233211436705, -0.3100012810410735}, {
              0.3960179729568626, -0.3241576952831608}, {
              0.4141608023156978, -0.3390083792229938}, {
              0.4332091463962299, -0.3546002657982491}, {
              0.4551663145598702, -0.3725731496391695}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.45169050752615353`, 0.5254310697544224, -0.12666480258351026`], 
             
             ArrowBox[{{0.4582615959434316, -0.37510677020203576`}, {
              0.4841212904088328, -0.39627403919248694`}, {
              0.511813481100161, -0.4189412849359537}, {
              0.5409964175815071, -0.4428287700436522}, {
              0.5718580937936539, -0.46809037561879707`}, {
              0.5820728512858848, -0.47645159271668536`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5324137658359936, 0.5306911387417332, 0.23295932591353022`], 
             
             ArrowBox[{{0.5851681326694461, -0.47898521327955157`}, {
              0.6045865036773844, -0.4948799827646029}, {
              0.6216507337460937, -0.5088477869265037}, {
              0.6391816472326987, -0.5231975914810697}, {
              0.6571792441371995, -0.5379293964283008}, {
              0.6756435244595964, -0.5530432017681972}, {
              0.694632857517912, -0.5685867852909036}, {
              0.7089793880118994, -0.5803300357942012}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6131370241458335, 0.535951207729044, 0.5925834544105705], 
             
             ArrowBox[{{0.7120746693954607, -0.5828636563570674}, {
              0.7142056126301688, -0.5846079247865649}, {
              0.734361789796367, -0.6011066202551809}, {
              0.7551013890165064, -0.6180828716967515}, {
              0.7764244102905875, -0.6355366791112773}, {
              0.7983308536186098, -0.6534680424987576}, {
              0.8208207190005734, -0.6718769618591928}, {
              0.8358859247379139, -0.6842084788717171}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6796530904125004, 0.45773224380497135`, 0.7517463918649528], 
             
             ArrowBox[{{0.8389812061214752, -0.6867420994345833}, {
              0.8438940064364784, -0.6907634371925827}, {
              0.8633781133557514, -0.7067120143403431}, {
              0.8833227693625352, -0.7230375706682595}, {
              0.9037177904655648, -0.7397317701427102}, {
              0.9245937286386359, -0.7568196208645602}, {
              0.9502989008851841, -0.7778604067917317}, {
              0.9627924614639284, -0.788086921949233}}]}}, {
            Arrowheads[{{0.005510364475048456, 1.}}], {
             LABColor[
             0.7370403378609185, 0.3268712564572769, 0.7837603405789153], 
             
             ArrowBox[{{0.9658877428474897, -0.7906205425120992}, {
              0.976697185262186, -0.7994685347238711}, {
              1., -0.8185428879978401}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3758170171892231, 0.5222619292099396, -0.40993367213615844`], 
             
             ArrowBox[{{0.2738144216653974, -0.33269559238237556`}, {
              0.2992944107108111, -0.363654809204488}, {
              0.31291817483285617`, -0.38020823340871185`}, {
              0.32719408334367517`, -0.3975540394108788}, {
              0.34216935973517904`, -0.4157496056628619}, {
              0.3578912274992791, -0.4348523106165347}, {
              0.3754899213785536, -0.45623543517845483`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4530051855189287, 0.5255167364765405, -0.12080787934595581`], 
             
             ArrowBox[{{0.3780318088713825, -0.4593239312483568}, {
              0.3782832056119948, -0.45962938845193396`}, {
              0.3999039591898588, -0.485899478155722}, {
              0.42275348823287145`, -0.5136625797278992}, {
              0.44683179274103246`, -0.5429186931684652}, {
              0.47229363815106307`, -0.5738558647400571}, {
              0.4797073085845387, -0.582863774044436}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.533731384799365, 0.5307769971026497, 0.23882935124842003`], 
             
             ArrowBox[{{0.4822491960773676, -0.585952270114338}, {
              0.49929378989968454`, -0.6066621407053119}, {
              0.5133707306509667, -0.6237661928355627}, {
              0.5278322479868968, -0.6413375210642293}, {
              0.5426783419074744, -0.6593761253913115}, {
              0.5579090124126997, -0.6778820058168095}, {
              0.5735723010635873, -0.6969135347796306}, {
              0.5839246957905239, -0.7094921129104172}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6144546431092051, 0.5360370660899605, 0.5984534797454603], 
             
             ArrowBox[{{0.5864665832833528, -0.7125806089803193}, {
              0.5897162494211511, -0.7165290847186825}, {
              0.6063408574853915, -0.736728655633965}, {
              0.6234461252563082, -0.7575122475254781}, {
              0.6410320527339015, -0.7788798603932219}, {
              0.6590986399181713, -0.8008314942371965}, {
              0.6776458868091176, -0.8233671490574018}, {
              0.688142082996509, -0.8361204517763985}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6805868091546184, 0.45560307117635856`, 0.7522672745567093], 
             
             ArrowBox[{{0.6906839704893379, -0.8392089478463005}, {
              0.6966737934067403, -0.8464868248538377}, {
              0.7127372979997049, -0.8660046323666358}, {
              0.7291799779091537, -0.8859831532186628}, {
              0.7459934591748641, -0.906412212709697}, {
              0.7632028636775031, -0.9273223349404024}, {
              0.7843903360474694, -0.953065970459444}, {
              0.7923594702024942, -0.9627487906423797}}]}}, {
            Arrowheads[{{0.005530638944410644, 1.}}], {
             LABColor[
             0.7379849899498818, 0.32471715235648474`, 0.7842873225282725], 
             
             ArrowBox[{{0.7949013576953231, -0.9658372867122818}, {
              0.806148304230053, -0.9795027814554234}, {
              0.8230178816156228, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3702319858164256, 0.5222719017801423, -0.4232815926290556], 
             
             ArrowBox[{{0.33252207558266517`, 0.2533261217791294}, {
              0.3636255507427009, 0.2770217597975639}, {0.38026178945870603`, 
              0.28969578701074267`}, {0.39769886300064555`, 
              0.30297991621574893`}, {0.4159951469199763, 
              0.31691861980447256`}, {0.4352090167681554, 
              0.33155637016880324`}, {0.4597955846651859, 
              0.3502872164811877}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4466790112933498, 0.5251045118767285, -0.14899114325562055`], 
             
             ArrowBox[{{0.4629774223922489, 0.35271124384873914`}, {
              0.4866190873384434, 0.3707222323905575}, {0.5145936384277461, 
              0.3920341543841498}, {0.5440812000531543, 0.4144987369662187}, {
              0.5752736445258284, 0.4382621546978904}, {0.5902509314747696, 
              0.4496723385507974}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5274022696031898, 0.5303645808640393, 0.21063298524141968`], 
             
             ArrowBox[{{0.5934327692018326, 0.4520963659183489}, {
              0.6083628441569284, 0.46347058214029074`}, {0.6256187271568883, 
              0.47661667450301415`}, {0.6433487989464546, 
              0.4901240192934198}, {0.6615530595256273, 0.5039926165115075}, {
              0.6802315088944065, 0.5182224661572775}, {0.699443781091533, 
              0.532858999379124}, {0.7192495101557475, 0.5479476473254417}, {
              0.7207062782843534, 0.5490574606204072}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.6081255279130299, 0.5356246498513502, 0.5702571137384604], 
             
             ArrowBox[{{0.7238881160114164, 0.5514814879879586}, {
              0.7396486960870499, 0.5634884099962302}, {0.7606413388854403, 
              0.5794812873914897}, {0.7822274385509187, 0.5959262795112203}, {
              0.8044069950834852, 0.6128233863554221}, {0.8271800084831394, 
              0.6301726079240947}, {0.8505464787498818, 0.6479739442172384}, {
              0.8511616250939372, 0.6484425826900169}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6760868303702532, 0.46586443921452814`, 0.749756924323479], 
             
             ArrowBox[{{0.8543434628210003, 0.6508666100575683}, {
              0.8703025382984018, 0.6630247523125943}, {0.8905284573065755, 
              0.6784335146114019}, {0.9112137865959283, 0.6941922705899753}, {
              0.9323898737018834, 0.7103249018193718}, {0.9584826097889669, 
              0.7302031959986826}, {0.9816169719035209, 
              0.7478277047596267}}]}}, {
            Arrowheads[{{0.0023887438130679537`, 1.}}], {
             LABColor[
             0.7334484029160122, 0.3350619987263085, 0.7817565500814971], 
             
             ArrowBox[{{0.984798809630584, 0.7502517321271781}, {
              0.9852833907797234, 0.7506209017920301}, {1., 
              0.7618324928810699}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3647220273785703, 0.5222817403009432, -0.4364500929003121], 
             
             ArrowBox[{{-0.40553423930342625`, 
              0.01686581615757715}, {-0.4311675003421126, 
              0.01793188118069397}, {-0.45852454307150703`, 
              0.019069636784466118`}, {-0.48760536749160954`, 
              0.0202790829688936}, {-0.5184099736024201, 
              0.021560219733976406`}, {-0.5511826304060768, 
              0.022923206014975182`}, {-0.5653960460895499, 
              0.023514329606167977`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.44070333465542394`, 0.5247151263140112, -0.17561293167310146`], 
             
             ArrowBox[{{-0.5693925912592029, 
              0.023680542442382747`}, {-0.5861676069047177, 
              0.02437820074715056}, {-0.623364903098343, 
              0.02592520393050255}, {-0.6627745189869523, 
              0.027564215565031136`}, {-0.6833864537927383, 
              0.028421447999174006`}, {-0.7047064824739953, 
              0.029308129441485732`}, {-0.7267346050307224, 
              0.03022425989196629}, {-0.7292543980453265, 
              0.03032905589097357}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5214265929652641, 0.529975195301322, 0.18401119682393904`], 
             
             ArrowBox[{{-0.7332509432149796, 
              0.03049526872718834}, {-0.7494708214629204, 
              0.0311698393506157}, {-0.7729151317705892, 
              0.032144867817433975`}, {-0.7970675359537285, 
              0.033149345292421084`}, {-0.8219280340123386, 
              0.03418327177557705}, {-0.8474966259464193, 
              0.03524664726690186}, {-0.8693054916174157, 
              0.03615365901428014}, {-0.89169048934007, 
              0.03708463159239478}, {-0.8931127500011032, 
              0.03714378217577916}}]}}, {
            Arrowheads[{{0.012872456141684852`, 1.}}], {
             LABColor[
             0.6021998903018557, 0.5352385249193146, 0.5438582504328149], 
             
             ArrowBox[{{-0.8971092951707563, 
              0.03730999501199393}, {-0.914637506875249, 
              0.03803897808549929}, {-0.938188880940352, 
              0.039018459240833143`}, {-0.9681223293840515, 
              0.04026336531653447}, {-0.998977515163089, 
              0.041546605646009496`}, {-1., 0.0415891299007133}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.35629856808815175`, 0.522296781136619, -0.4565817013692084], 
             
             ArrowBox[{{-0.3438330140826451, 
              0.17530930020958696`}, {-0.3770905957881947, 
              0.19226626227158855`}, {-0.41382746032877815`, 
              0.2109971977859893}, {-0.438479419702267, 
              0.22356643218045824`}, {-0.464688313924206, 
              0.23692949714841624`}, {-0.486374326841995, 
              0.247986491658082}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.43088926903546493`, 0.5240756245980517, -0.21933483871064602`], 
             
             ArrowBox[{{-0.48993785966097875`, 
              0.24980342144429438`}, {-0.4924541429945951, 
              0.2510863926898633}, {-0.5217769069134344, 
              0.2660371188047996}, {-0.5528628063943999, 
              0.2818868105481402}, {-0.5859180421511675, 
              0.29874060297480043`}, {-0.6209426141837375, 
              0.3165984960847804}, {-0.6324791724203286, 
              0.3224806128927894}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5115461550717324, 0.5293313686516923, 0.13999359965272454`], 
             
             ArrowBox[{{-0.6360427052393123, 
              0.3242975426790018}, {-0.6579365224921097, 
              0.33546048987807997`}, {-0.6772365778962184, 
              0.34530096205009564`}, {-0.6971581676622711, 
              0.3554583344311833}, {-0.7177012917902679, 
              0.3659326070213429}, {-0.7388659502802087, 
              0.37672377982057437`}, {-0.7606521431320938, 
              0.387831852828878}, {-0.7785840179986622, 
              0.39697473412749684`}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.592335785655145, 0.5345957625726734, 0.4999134182834346], 
             
             ArrowBox[{{-0.782147550817646, 
              0.3987916639137092}, {-0.783059870345923, 
              0.3992568260462534}, {-0.8060891319216958, 
              0.4109986994727007}, {-0.8297399278594131, 
              0.42305747310822}, {-0.8498721774321947, 
              0.4333222540911211}, {-0.8705051228698872, 
              0.4438423236533623}, {-0.8916271603284871, 
              0.45461176537130554`}, {-0.9132731013400065, 
              0.4656483285158655}, {-0.9246888635769958, 
              0.4714688553622043}}]}}, {
            Arrowheads[{{0.010066920560097666`, 1.}}], {
             LABColor[
             0.6648150744958373, 0.49156759049729437`, 0.7434688824583553], 
             
             ArrowBox[{{-0.9282523963959795, 
              0.4732857851484167}, {-0.940163682190406, 
              0.4793589633823002}, {-0.9678206798850052, 
              0.49346036933563586`}, {-0.9963162059352311, 
              0.5079893136963086}, {-1., 0.5098675607905672}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.367967528930937, 0.5222759451692934, -0.4286935211303552], 
             
             ArrowBox[{{0.20838572870202055`, 0.3563550227995085}, {
              0.22828864945546212`, 0.39039049069381593`}, {
              0.2502435580038077, 0.42793500962531295`}, {
              0.26492260037829635`, 0.4530372587698107}, {
              0.28051373582681305`, 0.4796992545928122}, {
              0.28915309835147956`, 0.49447320407883044`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4441128648335761, 0.5249372972759732, -0.1604233897173492], 
             
             ArrowBox[{{0.29117228259271605`, 0.4979261586108135}, {
              0.297016964349358, 0.5079209970943177}, {0.3144322859459311, 
              0.537702486274327}, {0.3328784076683532, 0.5692467199792934}, {
              0.35247403656844506`, 0.6027566960556696}, {
              0.37193965224217496`, 0.6360443398901355}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5248306579869831, 0.5301970101441126, 0.19917639137151585`], 
             
             ArrowBox[{{0.37395883648341144`, 0.6394972944221186}, {
              0.39511381590163824`, 0.6756738753226524}, {
              0.40652927243291187`, 0.6951951510731897}, {0.4183062451824664, 
              0.7153346463199004}, {0.4304447341503017, 0.7360923610627845}, {
              0.442944739336418, 0.7574682953018417}, {0.45472620613287046`, 
              0.7776154757014405}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.605559381453256, 0.5354574352505947, 0.5588248672767315], 
             
             ArrowBox[{{0.45674539037410694`, 0.7810684302334235}, {
              0.46902929836349305`, 0.8020748222684763}, {
              0.48261385220445197`, 0.8253054149960536}, {0.4965599222636917, 
              0.8491542272198042}, {0.5084061131886874, 0.8694120906707155}, {
              0.5205418611184469, 0.8901651180355716}, {0.5329605617490228, 
              0.9114020154657086}, {0.5375127600235658, 
              0.9191866115127456}}]}}, {
            Arrowheads[{{0.011202063803435445`, 1.}}], {
             LABColor[
             0.6742273267342905, 0.4701046928004388, 0.7487195849025797], 
             
             ArrowBox[{{0.5395319442648023, 0.9226395660447286}, {
              0.5456820279922568, 0.9331566645071181}, {0.5614245701198372, 
              0.9600775769598993}, {0.5776070418874759, 0.9877508016650103}, {
              0.5847700056672471, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.35683034830430793`, 0.5222958315957509, -0.4553107756445077], 
             
             ArrowBox[{{-0.1776567979566107, 
              0.34400450041919234`}, {-0.19482881623252346`, 
              0.377255418121972}, {-0.21379584779409222`, 
              0.41398209726861546`}, {-0.22652021286489768`, 
              0.43862083273880503`}, {-0.24004743315469435`, 
              0.4648141713071855}, {-0.25107428214205446`, 
              0.4861659333603389}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.4314918973865773, 0.5241148929175786, -0.21665011438070692`], 
             
             ArrowBox[{{-0.25290971924669053`, 
              0.48971996918386757`}, {-0.2543775086634823, 
              0.492562112973757}, {-0.26951043939126157`, 
              0.5218646577385195}, {-0.28555244595365653`, 
              0.5529274851489622}, {-0.30260974896629156`, 
              0.5859562747525742}, {-0.3206823484291666, 
              0.6209510265493554}, {-0.3263272034321343, 
              0.6318814021250141}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5121515027643291, 0.5293708141682761, 0.14269043871677978`], 
             
             ArrowBox[{{-0.32816264053677036`, 
              0.6354354379485427}, {-0.3397702443422818, 
              0.657911740539306}, {-0.3497281997121001, 
              0.677193757898572}, {-0.3600065216833199, 
              0.6970961148898345}, {-0.370605210255941, 
              0.7176188115130935}, {-0.38152426542996354`, 
              0.7387618477683489}, {-0.39276368720538757`, 
              0.760525223655601}, {-0.40158012472221416`, 
              0.7775968708896893}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5929384140062572, 0.5346350308922003, 0.5025981426133737], 
             
             ArrowBox[{{-0.40341556182685023`, 
              0.781150906713218}, {-0.40432347558221293`, 
              0.7829089391748496}, {-0.4162036305604398, 
              0.8059129943260948}, {-0.428404152140068, 
              0.8295373891093365}, {-0.4387884666880053, 
              0.8496449840865429}, {-0.4494307829952163, 
              0.8702521589690897}, {-0.4603251272936621, 
              0.8913473464929402}, {-0.4714894208874593, 
              0.9129652484502039}, {-0.476833046012294, 
              0.9233123396543645}}]}}, {
            Arrowheads[{{0.010288813640811205`, 1.}}], {
             LABColor[
             0.6652440115363601, 0.4905894790330135, 0.7437081685197605], 
             
             ArrowBox[{{-0.47866848311693005`, 
              0.9268663754778932}, {-0.48535522909426954`, 
              0.9398142093678552}, {-0.499615769212305, 
              0.9674275066660016}, {-0.5143081338333888, 
              0.9958769643258596}, {-0.5164374237549918, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3625084213005335, 0.5222856928914553, -0.4417404907441165], 
             
             ArrowBox[{{-0.18711077051935798`, -0.3538137579377755}, \
{-0.20509591907539987`, -0.387822452253018}, {-0.22494903565456983`, \
-0.4253633472221089}, {-0.23825073254385915`, -0.4505159525493461}, \
{-0.2523859837576206, -0.4772447524866968}, {-0.2619096018309469, \
-0.49525326739118264`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4379264499766377, 0.5245341796415645, -0.1879840221550071], 
             
             ArrowBox[{{-0.26377957261373663`, -0.4987892551275178}, \
{-0.26735478929585427`, -0.5055497470341608}, {-0.28315714915856016`, \
-0.5354309361917385}, {-0.29990253899395436`, -0.5670953309742981}, \
{-0.317700434450253, -0.6007499423967078}, {-0.336550835527456, \
-0.6363947704589678}, {-0.3385784039253256, -0.640228764580925}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5186178142894041, 0.5297921703601284, 0.17149801778983556`], 
             
             ArrowBox[{{-0.34044837470811534`, -0.6437647523172603}, \
{-0.3564537422255635, -0.674029815161078}, {-0.36683412945470173`, \
-0.693658422344921}, {-0.3775461316335569, -0.7139140908744154}, \
{-0.3885897487621289, -0.7347968207495605}, {-0.39996498084041765`, \
-0.7563066119703568}, {-0.4116718278684234, -0.7784434645368041}, \
{-0.4152472060197043, -0.7852042617706675}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5993729665963178, 0.535054317616186, 0.5312642348390738], 
             
             ArrowBox[{{-0.417117176802494, -0.7887402495070026}, \
{-0.42371028984614595`, -0.8012073784489023}, {-0.4360803667735854, \
-0.8245983537066517}, {-0.44878205865074167`, -0.848616390310052}, \
{-0.4595845386119078, -0.869043146180379}, {-0.47065349334888945`, \
-0.8899737877520221}, {-0.4819827934979788, -0.9113967248145339}, \
{-0.491916008114083, -0.9301797589604098}}]}}, {
            Arrowheads[{{0.009372805881384977, 1.}}], {
             LABColor[
             0.6698239785093293, 0.4801457127478076, 0.7462631408229028], 
             
             ArrowBox[{{-0.4937859788968727, -0.933715746696745}, \
{-0.5079832538790147, -0.9605618293672662}, {-0.522782043613977, \
-0.9885453355787179}, {-0.5288397251987719, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.7046534809794808, 0.4007234842087971, 0.7656930656823324], 
             
             ArrowBox[{{0.8168573127999085, -0.817488934753374}, {
              0.8393534193070035, -0.8400024360178089}, {
              0.8624210356906765, -0.8630878890697637}, {
              0.8817708743556476, -0.8824526896903975}, {
              0.9015648791101811, -0.9022619998449735}, {
              0.9217934913824297, -0.9225062535706303}, {
              0.9299506655207445, -0.9306697351143919}}]}}, {
            Arrowheads[{{0.011751241317336925`, 1.}}], {
             LABColor[
             0.7621104450550575, 0.26970352100722933`, 0.797745906391043], 
             
             ArrowBox[{{0.9327779993387654, -0.9334992551234174}, {
              0.9424853868879348, -0.9432141487559513}, {
              0.9679111430186883, -0.9686595649491221}, {
              0.9940028004804009, -0.9947713973708882}, {
              0.9992273632992278, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.36475890278806583`, 0.5222816744566201, -0.4363619626820134], 
             
             ArrowBox[{{0.3575980925862961, -0.19103041307813062`}, {
              0.3918961064929788, -0.20935255712807946`}, {
              0.4297475002340557, -0.2295729317101837}, {
              0.4550953509989013, -0.24311386076612582`}, {
              0.4820274044827436, -0.25750107761298063`}, {
              0.4987234973627973, -0.2664202010249653}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4404767591209741, 0.5247003622550894, -0.1766223313284339], 
             
             ArrowBox[{{0.5022516324822098, -0.26830494572363617`}, {
              0.5105436606855827, -0.2727345822507481}, {
              0.5406441196074184, -0.2888143746794283}, {
              0.5725362509832969, -0.30585128610871914`}, {
              0.6064275245482635, -0.3239561477483185}, {
              0.6423179403023189, -0.34312895959822654`}, {
              0.643377037258711, -0.3436947336704709}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5211802795016487, 0.529959145084343, 0.1829138642020357], 
             
             ArrowBox[{{0.6469051723781235, -0.34557947836914177`}, {
              0.6802074982454627, -0.3633697216584431}, {
              0.6999668184342163, -0.37392523405086375`}, {
              0.7203556499627889, -0.38481703406275486`}, {
              0.7413739928311807, -0.3960451216941164}, {
              0.7630218470393915, -0.4076094969449483}, {
              0.7852992125874214, -0.41951015981525064`}, {
              0.7880305771546247, -0.4209692663159764}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6019232757406542, 0.5352205002297111, 0.5426259256656468], 
             
             ArrowBox[{{0.7915587122740372, -0.4228540110146473}, {
              0.8082060894752704, -0.4317471103050234}, {
              0.8317424777029384, -0.44432034841426654`}, {
              0.8559083772704257, -0.45722987414298016`}, {
              0.8764538673718664, -0.4682053618268909}, {
              0.8975047403525731, -0.4794508271817969}, {
              0.9190494018297668, -0.49096007643939354`}, {
              0.9326841170505383, -0.49824379896148197`}}]}}, {
            Arrowheads[{{0.009039867475465407, 1.}}], {
             LABColor[
             0.6716392300732009, 0.4760063678150121, 0.7472757938608613], 
             
             ArrowBox[{{0.9362122521699509, -0.5001285436601528}, {
              0.9411226349517845, -0.5027516909045947}, {
              0.968473442292518, -0.5173626078324018}, {
              0.9965940131280426, -0.5323847356738886}, {
              1., -0.5342042282622941}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.36162497915027114`, 0.5222872703559807, -0.4438518693192148], 
             
             ArrowBox[{{0.1891163926353006, -0.35043628805115223`}, {
              0.2073030751551452, -0.38413655816210757`}, {
              0.22737967663822747`, -0.4213388842131405}, {
              0.24082975171393742`, -0.44626213025152384`}, {
              0.2551229872886566, -0.4727477688006081}, {
              0.2651031339863609, -0.49124117127203726`}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.4369253083956967, 0.5244689435015465, -0.19244413286022838`], 
             
             ArrowBox[{{0.26700280252013736`, -0.49476129335255936`}, {
              0.27025938336238514`, -0.5007957998603934}, {
              0.28623893993512295`, -0.5304062234308796}, {
              0.3031724376477459, -0.5617843181557395}, {
              0.3211706571411297, -0.5951353626786455}, {
              0.34023359841527434`, -0.630459356999598}, {
              0.34298954387119757`, -0.6355661765734444}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5176110239120285, 0.5297265661346346, 0.16701274155565332`], 
             
             ArrowBox[{{0.34488921240497405`, -0.6390862986539665}, {
              0.3603612614701799, -0.6677563011185966}, {
              0.37085901864137266`, -0.6872088456847862}, {
              0.3816922662096651, -0.7072830603653328}, {
              0.3928610041750572, -0.7279789451602365}, {
              0.40436523253754886`, -0.7492965000694976}, {
              0.4162049512971402, -0.7712357250931157}, {
              0.42087595375603426`, -0.7798911818748515}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5983718250153768, 0.534989081476168, 0.5268041241338524], 
             
             ArrowBox[{{0.42277562228981075`, -0.7834113039553736}, {
              0.4283801604538312, -0.793796620231091}, {
              0.44089086000762184`, -0.8169791854834234}, {
              0.4537370499585121, -0.8407834208501132}, {
              0.4646626606354938, -0.8610287861353793}, {
              0.4758578811170402, -0.8817737435385856}, {
              0.48731650785839187`, -0.9030067977727927}, {
              0.4987623636408711, -0.9242161871762586}}]}}, {
            Arrowheads[{{0.010264372810118664`, 1.}}], {
             LABColor[
             0.669111388890735, 0.48177064137235576`, 0.745865616834245], 
             
             ArrowBox[{{0.5006620321746477, -0.9277363092567807}, {
              0.5136151884595876, -0.9517387552837335}, {
              0.5285844339350925, -0.9794770530921025}, {
              0.5396598442673148, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3595442956573403, 0.5222909856013961, -0.4488245894313693], 
             
             ArrowBox[{{-0.37997215161099895`, 
              0.1019783241949162}, {-0.41779460303449323`, 
              0.11212925287944855`}, {-0.4434624790369994, 
              0.11901809188851956`}, {-0.47080522656918344`, 
              0.12635643908158287`}, {-0.4998228456310452, 
              0.1341442944586385}, {-0.5305153362225846, 
              0.14238165801968644`}, {-0.5345034856507465, 
              0.14345201223801143`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.43432510374457556`, 0.5242995096093523, -0.2040281094136056], 
             
             ArrowBox[{{-0.5383667690017402, 
              0.14448885443908882`}, {-0.5631124378371999, 
              0.15113018809531434`}, {-0.5978438899682885, 
              0.16045154301610967`}, {-0.6347096926158512, 
              0.1703457227820726}, {-0.6737098457798875, 
              0.18081272739320303`}, {-0.6928981030414877, 
              0.18596254248218408`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5152906774414442, 0.5295753682919646, 0.15667554017445823`], 
             
             ArrowBox[{{-0.6967613863924814, 
              0.18699938468326147`}, {-0.7151341422359061, 
              0.19193033250091354`}, {-0.7368640164892244, 
              0.19776227611026598`}, {-0.7592723747594154, 
              0.20377631375661653`}, {-0.7823592170464793, 
              0.20997244543996527`}, {-0.8061245433504158, 
              0.21635067116031212`}, {-0.8305683536712251, 
              0.22291099091765712`}, {-0.8512927204322289, 
              0.22847307272635675`}}]}}, {
            Arrowheads[{{0.01874622996259407, 1.}}], {
             LABColor[
             0.5960726786269042, 0.5348392650680038, 0.5165613696470602], 
             
             ArrowBox[{{-0.8551560037832227, 
              0.22950991492743414`}, {-0.855690648008907, 
              0.22965340471200027`}, {-0.8771261025879019, 
              0.23540633088581112`}, {-0.8991124087160315, 
              0.24130709662529212`}, {-0.9216364102069643, 
              0.24735217102474621`}, {-0.9447375756196937, 
              0.2535521468012644}, {-0.9737340711766116, 
              0.2613343329743371}, {-1., 0.2683836796000717}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3600227448668595, 0.5222901312877831, -0.4476811219049993], 
             
             ArrowBox[{{-0.10555951426108832`, 
              0.38013622090144017`}, {-0.11605786510957111`, 
              0.4179424143570951}, {-0.12317865948045402`, 
              0.4435855018694966}, {-0.13076344855249367`, 
              0.47089950643234746`}, {-0.13881223232569015`, 
              0.49988442804564814`}, {-0.14732501080004337`, 
              0.5305402667093984}, {-0.14836977618702585`, 
              0.5343026292848251}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4348658819057229, 0.5243347476621022, -0.20161892922211255`], 
             
             ArrowBox[{{-0.14944003273517428`, 
              0.5381567894944097}, {-0.15636533363968147`, 
              0.5630958746434128}, {-0.16599675050873236`, 
              0.5977801040675057}, {-0.17621926140719615`, 
              0.6345929549816774}, {-0.18703286633507282`, 
              0.6735344273859275}, {-0.19225029466111176`, 
              0.6923231978777946}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5158328695905009, 0.5296106984826449, 0.15909101971734313`], 
             
             ArrowBox[{{-0.1933205512092602, 
              0.6961773580873792}, {-0.19851770393611734`, 
              0.7148931129945935}, {-0.20454188698048567`, 
              0.7365871326434585}, {-0.21075391285408468`, 
              0.7589576035220116}, {-0.21715378155691442`, 
              0.782004525630253}, {-0.2237414930889749, 
              0.8057278989681826}, {-0.23051704745026608`, 
              0.8301277235358003}, {-0.23613081313519768`, 
              0.8503437664707642}}]}}, {
            Arrowheads[{{0.018914895254881582`, 1.}}], {
             LABColor[
             0.5966136105145408, 0.5348745131378412, 0.5189712346938965], 
             
             ArrowBox[{{-0.23720106968334612`, 
              0.8541979266803488}, {-0.23748044464078794`, 
              0.8552039993331062}, {-0.24342166290828954`, 
              0.8765992499229546}, {-0.24951535467364755`, 
              0.8985435812817747}, {-0.25575788283919254`, 
              0.9210238956554437}, {-0.2621601586979325, 
              0.9440794863063292}, {-0.27019216193450146`, 
              0.9730039785985691}, {-0.2776886506915037, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5247674072413796, 0.5301928886146755, 0.19889460772277906`], 
             
             ArrowBox[{{-0.7365966641257315, -0.07759208798956192}, \
{-0.7594777186462529, -0.08000234706636275}, {-0.783066347738057, \
-0.08248714108347491}, {-0.8073625514011432, -0.08504647004089838}, \
{-0.8323663296355118, -0.08768033393863316}, {-0.8580776824411629, \
-0.09038873277667922}, {-0.8800164315895076, -0.0926997306907408}, \
{-0.8957162857862371, -0.09435353191953376}}]}}, {
            Arrowheads[{{0.012607586999705248`, 1.}}], {
             LABColor[
             0.6055477349525512, 0.5354566763441971, 0.5587729818257013], 
             
             ArrowBox[{{-0.8996942763277497, -0.09477256801778305}, \
{-0.9025309071022134, -0.09507137483481816}, {-0.9256070921041053, \
-0.09750218869039728}, {-0.9492870372207068, -0.09999660181302002}, \
{-0.9792823836068973, -0.10315627069210337`}, {-1., \
-0.10533863614717312`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3790350530621144, 0.5222561831207031, -0.4022427418427576], 
             
             ArrowBox[{{0.39111794866646266`, 0.19780566094812754`}, {
              0.42901167096375237`, 0.2169701938220517}, {0.4544159749951236, 
              0.22981827498781246`}, {0.48141463176794863`, 
              0.24347269091494897`}, {0.5100076412822275, 
              0.25793344160346116`}, {0.5338967312205162, 
              0.2700152119256976}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.45638152938674414`, 0.5257367449603584, -0.10576618323021031`], 
             
             ArrowBox[{{0.5374662007843675, 0.27182045070013683`}, {
              0.5401950035379601, 0.2732005270533491}, {0.5721864505669412, 
              0.28938001803766866`}, {0.6061917144009652, 
              0.306577985329476}, {0.6422107950400323, 
              0.32479442892877103`}, {0.6802436924841424, 
              0.3440293488355537}, {0.680244983338421, 
              0.3440300016777069}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5372438576456997, 0.5310058759892881, 0.2544775053576636], 
             
             ArrowBox[{{0.6838144529022723, 0.3458352404521462}, {
              0.7000809467193564, 0.3540619264729937}, {0.7205529035783669, 
              0.3644155013247871}, {0.7416595630611738, 0.375090073390934}, {
              0.763400925167777, 0.38608564267143425`}, {0.7857769898981769, 
              0.39740220916628805`}, {0.8087877572523732, 
              0.40903977287549526`}, {0.8265932354563259, 
              0.41804479142971623`}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.6181014121934671, 0.5362746959548302, 0.6146999269431677], 
             
             ArrowBox[{{0.8301627050201772, 0.4198500302041555}, {
              0.8324332272303657, 0.4209983337990558}, {0.8567133998321548, 
              0.43327789193696986`}, {0.8773677678753312, 
              0.4437237201997134}, {0.898532464747645, 0.4544276443429773}, {
              0.9201957344535807, 0.465383718839406}, {0.942392844979684, 
              0.47660978027106593`}, {0.9699245231399943, 
              0.49053376871005083`}, {0.9729414875742308, 
              0.4920595811817256}}]}}, {
            Arrowheads[{{0.003290270786981297, 1.}}], {
             LABColor[
             0.6831393803295457, 0.4497824054522101, 0.7536912474133323], 
             
             ArrowBox[{{0.9765109571380821, 0.4938648199561649}, {
              0.9982349863067738, 0.5048516232026555}, {1., 
              0.5057442687622916}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3657489379226564, 0.5222799066608418, -0.43399583268567105`], 
             
             ArrowBox[{{0.13313425960415048`, 0.38535398876291543`}, {
              0.14626592636589025`, 0.42336328990589533`}, {
              0.1551367769721155, 0.44903975872010476`}, {
              0.16457861118241587`, 0.47636892617103466`}, {
              0.1745914289967913, 0.5053507922586848}, {0.18517523041524178`, 
              0.5359853569830554}, {0.18538169763348805`, 
              0.5365829714989324}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.44132886767247853`, 0.5247558871417136, -0.1728261664852922], 
             
             ArrowBox[{{0.1866878835842215, 0.5403636960673328}, {
              0.19640719308924617`, 0.5684960092444125}, {
              0.20836449467028323`, 0.603106137943022}, {0.22104713515835303`,
               0.6398157430788842}, {0.2344551145534555, 0.678624824651999}, {
              0.23893532161355913`, 0.6915926788033498}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5222924462261561, 0.530031615817299, 0.18786859469010891`], 
             
             ArrowBox[{{0.24024150756429258`, 0.6953734033717502}, {
              0.24145537715094573`, 0.6988869203916789}, {0.2486855160947976, 
              0.7198143878189778}, {0.25614553138501095`, 
              0.7414072269338952}, {0.26383542302158597`, 
              0.7636654377364314}, {0.2717551910045226, 0.7865890202265865}, {
              0.2799048353338208, 0.8101779744043601}, {0.2882843560094806, 
              0.8344323002697527}, {0.29248894559363015`, 
              0.8466023861077673}}]}}, {
            Arrowheads[{{0.01978680099766343, 1.}}], {
             LABColor[
             0.6030830888026828, 0.535296075681525, 0.5477929217753756], 
             
             ArrowBox[{{0.2937951315443636, 0.8503831106761677}, {
              0.29689375303150206`, 0.859351997822764}, {0.3042353671742871, 
              0.8806021275962144}, {0.3117631569096478, 0.9023911382514351}, {
              0.3194727296454858, 0.9247063155337247}, {0.327377263158096, 
              0.9475858022071875}, {0.33725234195620835`, 
              0.9761689859460339}, {0.3454856144905764, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.37880813321935997`, 0.5222565883062628, -0.40278506789558854`], 
             
             ArrowBox[{{0.4199990085026196, -0.12526017246799004`}, {
              0.4456739267745186, -0.13291743980846651`}, {
              0.47301535153795377`, -0.1410717247283251}, {
              0.5020232827929253, -0.1497230272275658}, {
              0.5326977205394331, -0.15887134730618863`}, {
              0.5652659603188006, -0.1685844734068589}, {
              0.573325319154736, -0.1709880902186457}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.4566486900095456, 0.5257541536147667, -0.104575975994336], 
             
             ArrowBox[{{0.5771584769210388, -0.17213128816241208`}, {
              0.5999552976723508, -0.17893019397224186`}, {
              0.6367657326000844, -0.18990850900233758`}, {
              0.6756972651020006, -0.20151941849714602`}, {
              0.6960300437742469, -0.20758345034407635`}, {
              0.7170362985019784, -0.2138483391577026}, {
              0.7304847875731552, -0.21785920591306773`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5373719483193858, 0.5310142226020776, 0.25504815250270463`], 
             
             ArrowBox[{{0.734317945339458, -0.21900240385683412`}, {
              0.7387160292851946, -0.22031408493802465`}, {
              0.7610692361238959, -0.2269806876850426}, {
              0.7840959190180823, -0.23384814739875642`}, {
              0.8077960779677537, -0.24091646407916617`}, {
              0.8321697129729098, -0.24818563772627175`}, {
              0.857216824033551, -0.2556556683400732}, {
              0.8785845340614771, -0.26202835729685514`}, {
              0.8876442559915744, -0.26473032160748977`}}]}}, {
            Arrowheads[{{0.01415576828015523, 1.}}], {
             LABColor[
             0.6181319879041248, 0.5362766883217238, 0.6148361424965123], 
             
             ArrowBox[{{0.8914774137578773, -0.26587351955125615`}, {
              0.9004985746888877, -0.268563983459989}, {
              0.9229459583315086, -0.2752586734226018}, {
              0.9459656477421616, -0.282124047405312}, {
              0.9748052803834111, -0.2907251566589636}, {
              1., -0.2982392099318701}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3491248370781431, 0.5223095904713096, -0.4737265273813606], 
             
             ArrowBox[{{-0.02419614144615424, 
              0.3686368997276741}, {-0.026646523744527667`, 
              0.4059693535666528}, {-0.028328429417874938`, 
              0.43159379019167793`}, {-0.030123269830559657`, 
              0.45893882810652264`}, {-0.03203104498258182, 
              0.48800446731118696`}, {-0.034051754873941444`, 
              0.5187907078056709}, {-0.03467547805573484, 
              0.5282933543551745}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4225603380037237, 0.5235328968547123, -0.25644043412783163`], 
             ArrowBox[{{-0.03493746147097436, 
              0.532284765720862}, {-0.03620137695599228, 
              0.5515409717961849}, {-0.03849588868008808, 
              0.586498681488939}, {-0.04093529004622887, 
              0.6236638368839338}, {-0.04351958105441463, 
              0.6630364379811686}, {-0.044871128273297804`, 
              0.6836277449758565}, {-0.04541679808055495, 
              0.6919412203483625}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5034830528772009, 0.5288059627812779, 0.10407227833339505`], 
             
             ArrowBox[{{-0.04567878149579447, 
              0.69593263171405}, {-0.04626903410073907, 
              0.7049253420115651}, {-0.04771329853673843, 
              0.7269292290882943}, {-0.0492039215812959, 
              0.749639406206044}, {-0.05074090323441145, 
              0.7730558733648144}, {-0.05232424349608511, 
              0.7971786305646055}, {-0.05395394236631686, 
              0.8220076778054172}, {-0.055629999845106706`, 
              0.8475430150872495}, {-0.05615811810537507, 
              0.8555890863415504}}]}}, {
            Arrowheads[{{0.017590206749909278`, 1.}}], {
             LABColor[
             0.5842341738014702, 0.5340678473453769, 0.4638205354724357], 
             
             ArrowBox[{{-0.056420101520614586`, 
              0.8595804977072379}, {-0.05705968629172571, 
              0.8693248012632462}, {-0.058527090972459346`, 
              0.8916812382743012}, {-0.06003129111128106, 
              0.9145982672964352}, {-0.06157505503627052, 
              0.9381180648015861}, {-0.06353578735239174, 
              0.9679905254093772}, {-0.06555678235729123, 
              0.998781109710978}, {-0.06563678639883538, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.01974443199395664, 1.}}], {
             LABColor[
             0.7335669320281384, 0.3347917150425297, 0.781822672523075], 
             
             ArrowBox[{{0.8868628048248357, 0.8640470764821936}, {
              0.9068079977733431, 0.8834791527439045}, {0.9271919115743228, 
              0.9033386631790955}, {0.9480435453314064, 0.9236538608507849}, {
              0.9736675749199681, 0.9486186781068913}, {0.9999639262915937, 
              0.9742385207716079}, {1., 0.9742736664357589}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.38023172939265687`, 0.5222540463486924, -0.39938275065387874`], 
             
             ArrowBox[{{0.1310560875041227, -0.4216585777035925}, {
              0.13904826984265597`, -0.44737254720926456`}, {
              0.14755787914356222`, -0.47475128117704407`}, {
              0.15658491540684155`, -0.503794779606931}, {
              0.1661293786324939, -0.5345030424989253}, {
              0.17626164627775412`, -0.5671025015975205}, {
              0.1785449145688298, -0.5744486667277774}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4582612053432795, 0.5258592279400124, -0.09739217997663416], 
             
             ArrowBox[{{0.17973213524544746`, -0.578268418953382}, {
              0.1870520957998571, -0.60181958864721}, {
              0.1985007271988028, -0.6386543036479936}, {
              0.2106075404745912, -0.6776066465998716}, {
              0.21692992356861454`, -0.6979482203023466}, {
              0.22346116863647486`, -0.7189617844823466}, {
              0.22722096231015462`, -0.7310585079775669}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5389844636531196, 0.5311192969273232, 0.26223194852040616`], 
             
             ArrowBox[{{0.22840818298677232`, -0.7348782602031715}, {
              0.230201275678172, -0.7406473391398711}, {
              0.23715024469370605`, -0.7630048842749206}, {
              0.24430807568307705`, -0.7860344198874952}, {
              0.25167476864628496`, -0.8097359459775946}, {
              0.2592503235833298, -0.8341094625452187}, {
              0.2670347404942115, -0.8591549695903679}, {
              0.2736749680884397, -0.8805191730877624}, {
              0.2758970100514794, -0.8876683492273564}}]}}, {
            Arrowheads[{{0.014204049390908184`, 1.}}], {
             LABColor[
             0.6197389642923118, 0.53638140171957, 0.6219952623736966], 
             
             ArrowBox[{{0.27708423072809707`, -0.891488101452961}, {
              0.28048455193528565`, -0.9024282617405432}, {
              0.28745947520538195`, -0.924869311841081}, {
              0.29461178838683055`, -0.947881094512263}, {
              0.3035644599027012, -0.9766853325291405}, {
              0.310810912985267, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3740104109515734, 0.5222651550660417, -0.4142513625504992], 
             
             ArrowBox[{{-0.12154183369647462`, -0.4095780527016216}, \
{-0.12900655823685725`, -0.43473307339054024`}, {-0.1369582032752541, \
-0.4615289443392567}, {-0.14539676881166524`, -0.4899656655477712}, \
{-0.1543222548460906, -0.5200432370160837}, {-0.163801427090594, \
-0.5519866493462168}, {-0.16705978286838333`, -0.5629668277250357}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.451210408007499, 0.5253997856283629, -0.12880365790975695`], 
             
             ArrowBox[{{-0.16819773159768103`, -0.566801547100621}, \
{-0.17390105125723918`, -0.5860208931401933}, {-0.18462112734602612`, \
-0.6221459683980132}, {-0.1959616553569548, -0.6603618751196764}, \
{-0.20188564188144953`, -0.6803248359467481}, {-0.20800684748293416`, \
-0.7009523959743789}, {-0.21371568076958972`, -0.7201903221240351}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.531933666317339, 0.5306598546156737, 0.23082047058728336`], 
             
             ArrowBox[{{-0.21485362949888745`, -0.7240250414996204}, \
{-0.22084091591687288`, -0.7442013136313159}, {-0.22755377874932708`, \
-0.7668226712606226}, {-0.23446386065877114`, -0.7901086280904881}, \
{-0.24157116164520503`, -0.8140591841209123}, {-0.24887568170862878`, \
-0.8386743393518952}, {-0.25510741347104504`, -0.8596743562397704}, \
{-0.26037157867079613`, -0.8774138165230345}}]}}, {
            Arrowheads[{{0.015483722858240873`, 1.}}], {
             LABColor[
             0.6127188377494487, 0.5359239579705407, 0.5907204235877561], 
             
             ArrowBox[{{-0.26150952740009387`, -0.8812485358986198}, \
{-0.268047272282546, -0.9032797718655032}, {-0.27476304231732857`, \
-0.9259109263378578}, {-0.28319120517496915`, -0.9543125920532622}, \
{-0.2918692494884698, -0.9835563214185622}, {-0.2967488929027603, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3645436012084148, 0.5222820588967377, -0.4368765217194387], 
             
             ArrowBox[{{-0.03655167904027948, -0.4038173013949783}, \
{-0.03885684396103413, -0.4292844072027227}, {-0.04131665512357907, \
-0.4564600207909665}, {-0.04393111252791433, -0.4853441421597097}, \
{-0.046700216174039876`, -0.5159367713089523}, {-0.04964582348094087, \
-0.5484793856258292}, {-0.050975175276674396`, -0.563165858829047}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4404982613862956, 0.5247017633803828, -0.17652653820029643`], 
             
             ArrowBox[{{-0.05133576268258427, -0.5671495727648987}, \
{-0.05278979186760245, -0.5832134624974754}, {-0.056132121334024614`, \
-0.6201390019238906}, {-0.059672811880207365`, -0.659256003905075}, \
{-0.06152447451701583, -0.6797128865633494}, {-0.0634395913413782, \
-0.7008708012796034}, {-0.06541816235329442, -0.7227297480538374}, \
{-0.06575925891897919, -0.7264981301989675}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5212215196961356, 0.5299618323676936, 0.1830975902967439], 
             
             ArrowBox[{{-0.06611984632488906, -0.7304818441348192}, \
{-0.06746018755276456, -0.7452897268860509}, {-0.06956566693978858, \
-0.7685507377762442}, {-0.07173460051436648, -0.7925127807244172}, \
{-0.07396698827649828, -0.8171758557305702}, {-0.07626283022618396, \
-0.8425399627947027}, {-0.07822114806640959, -0.8641751556579935}, \
{-0.08023108645417128, -0.8863806443531004}, {-0.08054334256128398, \
-0.8898304015688879}}]}}, {
            Arrowheads[{{0.013327498686543841`, 1.}}], {
             LABColor[
             0.6019884831017597, 0.5352247492556433, 0.5429164260852306], 
             
             ArrowBox[{{-0.08090392996719385, -0.8938141155047397}, \
{-0.08229138348020021, -0.9091424875014347}, {-0.08440582487230287, \
-0.9325025092387622}, {-0.08709018624953949, -0.9621589188972639}, \
{-0.08985695140519417, -0.9927257127651712}, {-0.09051538632449001, \
-1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.36729703551216725`, 0.5222771423949207, -0.43029596384685265`], 
             
             ArrowBox[{{0.41005076415933966`, -0.038017874938429105`}, {
              0.4358401374353542, -0.04040893783513669}, {
              0.4633546126029023, -0.04295994363087245}, {
              0.49259418966198387`, -0.045670892325636404`}, {
              0.5235588686125989, -0.04854178391942854}, {
              0.5564917061893715, -0.05159515342827017}, {
              0.5693674798305809, -0.05278893135727997}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4436195127085755, 0.5249051495868575, -0.16262128573530354`], 
             
             ArrowBox[{{0.573350397722362, -0.05315820776775124}, {
              0.5916357591269255, -0.054853535868182576`}, {
              0.6289910274252608, -0.058316931239165766`}, {
              0.6685575110843776, -0.06198533954121974}, {
              0.6892469966256806, -0.0639035661185126}, {
              0.7106433619100817, -0.0658873310828018}, {
              0.7326671133936032, -0.0679292641866021}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5243427710184156, 0.5301652185741683, 0.19700284276173702`], 
             
             ArrowBox[{{0.7366500312853843, -0.06829854059707338}, {
              0.755556731708179, -0.07005147617236923}, {
              0.7790737362218753, -0.07223185629764746}, {
              0.8032976204786699, -0.07447777480992204}, {
              0.8282283844785627, -0.07678923170919297}, {
              0.853866028221554, -0.07916622699546022}, {
              0.8757395153999594, -0.08119422833749115}, {
              0.8959667469566256, -0.08306959701592423}}]}}, {
            Arrowheads[{{0.01255992941231009, 1.}}], {
             LABColor[
             0.6051263227902426, 0.5354292163891328, 0.5568955801352662], 
             
             ArrowBox[{{0.8999496648484067, -0.08343887342639551}, {
              0.9211979373657477, -0.08540890796316333}, {
              0.9448109293765523, -0.08759818757352898}, {
              0.9747510068515338, -0.09037408319568277}, {
              1., -0.09271504472469635}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.015907308340412766`, 1.}}], {
             LABColor[
             0.7419632064007131, 0.3156455666682785, 0.7865066033457473], 
             
             ArrowBox[{{-0.9084000324281641, -0.8760824795173828}, \
{-0.9288361048355316, -0.8957915111632608}, {-0.949741476857719, \
-0.9159531464589746}, {-0.975432467595453, -0.9407301456479877}, {-1., \
-0.9644236550450178}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4156320765376082, 0.5230814391950869, -0.2873060117063285], 
             
             ArrowBox[{{-0.4237976277631617, -0.2995060340375397}, \
{-0.4434112672409161, -0.31336737489503796`}, {-0.46889639873138134`, \
-0.33137821346419605`}, {-0.495931343886412, -0.35048433552189356`}, \
{-0.5245161027060081, -0.37068574106813057`}, {-0.554460933015668, \
-0.3918483356142838}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4960870956412931, 0.5283240292456077, 0.07112310443910405], 
             
             ArrowBox[{{-0.5577275156469806, -0.3941568931537024}, \
{-0.5865321790610796, -0.41451370955797984`}, {-0.6203577320409206, \
-0.4384188863651055}, {-0.6379995269466903, -0.4508866862756883}, \
{-0.6561273341296926, -0.4636979605242843}, {-0.6747411535899278, \
-0.4768527091108935}, {-0.688390820899487, -0.4864991947304464}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5769355382320769, 0.5335922554600632, 0.4313049320290518], 
             
             ArrowBox[{{-0.6916574035307996, -0.488807752269865}, \
{-0.6938409853273957, -0.49035093203551605`}, {-0.7134881264200119, \
-0.504235949136447}, {-0.7337438739456917, -0.5185510802519814}, \
{-0.7546082279044355, -0.5332963253821194}, {-0.7760811882962428, \
-0.5484716845268607}, {-0.7981627551211143, -0.5640771576862058}, \
{-0.8208529283790493, -0.5801127448601543}, {-0.822320708783306, \
-0.581150053846609}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6539553547620434, 0.516331169687268, 0.7374106983484069], 
             
             ArrowBox[{{-0.8255872914146186, -0.5834586113860276}, \
{-0.844151708070048, -0.5965784460487062}, {-0.8680590941941105, \
-0.6134742612518618}, {-0.8882854489480068, -0.6277686199233579}, \
{-0.9089944002602469, -0.6424040389778312}, {-0.9301751836779217, \
-0.6573729109668482}, {-0.9518600925597597, -0.67269805823571}, \
{-0.9562505966671249, -0.6758009129627718}}]}}, {
            Arrowheads[{{0.006196509513260757, 1.}}], {
             LABColor[
             0.7114123188376201, 0.38531120648570016`, 0.7694635390571175], 
             
             ArrowBox[{{-0.9595171792984375, -0.6781094705021904}, \
{-0.9785904521675, -0.6915889237574623}, {-1., -0.7067194680120248}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.37042253040617035`, 0.5222715615458319, -0.4228262014477898], 
             
             ArrowBox[{{0.0581422009145724, 0.4149460274040282}, {
              0.061775541813948426`, 0.4408762527598901}, {
              0.06565027540305125, 0.4685292360449482}, {0.06976640168188086, 
              0.49790497725920285`}, {0.07412392065043728, 
              0.5290034764026538}, {0.07875659382259183, 
              0.5620656807707197}, {0.08034449097029965, 
              0.5733980968644217}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.44715866641648067`, 0.5251357670451968, -0.1468542677225123], 
             
             ArrowBox[{{0.08089954822169283, 0.5773593986009316}, {
              0.08369818271221577, 0.597332537658819}, {0.08894868731930915, 
              0.6348040470669517}, {0.09450810764387194, 
              0.6744802089951178}, {0.09741434710601704, 
              0.6952212972327955}, {0.10041918730915482`, 
              0.7166660737576456}, {0.10310183827742007`, 
              0.735811468061325}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5278819247263207, 0.5303958360325076, 0.21276986077452847`], 
             
             ArrowBox[{{0.10365689552881326`, 0.7397727697978349}, {
              0.10672466993840843`, 0.7616666916688628}, {
              0.11002531236452431`, 0.7852225330552302}, {
              0.11342455553163285`, 0.8094820627287698}, {
              0.11692239943973405`, 0.8344452806894818}, {
              0.12051884408882794`, 0.8601121869373661}, {
              0.12358792397854607`, 0.8820154256863648}, {0.1258591855845405, 
              0.8982248392582284}}]}}, {
            Arrowheads[{{0.0123461762712681, 1.}}], {
             LABColor[
             0.6086634356068799, 0.5356597008594202, 0.5726535059265719], 
             
             ArrowBox[{{0.1264142428359337, 0.9021861409947383}, {
              0.12673721497958537`, 0.9044911106357626}, {0.129964771542593, 
              0.9275253568970898}, {0.13327643031562744`, 
              0.9511598191357548}, {0.1374630925219254, 0.981038957236124}, {
              0.14011991216862524`, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3639008022083533, 0.5222832066715176, -0.4384127762850844], 
             
             ArrowBox[{{0.04392636033298939, -0.4015895905763511}, {
              0.04669485330369053, -0.4269000863740737}, {
              0.049648950402547395`, -0.4539074376651788}, {
              0.05278865162956, -0.48261164444966687`}, {
              0.05611395698472833, -0.5130127067275375}, {
              0.059651080266077114`, -0.5453502798751161}, {
              0.06132359292502339, -0.5606409542867533}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.43976812717936425`, 0.5246541865558235, -0.17977930429709738`], 
             
             ArrowBox[{{0.06175852373982424, -0.5646172383795134}, {
              0.06342623527163103, -0.5798640192687274}, {
              0.06743942200139011, -0.6165539249083717}, {
              0.07169064045535432, -0.6554199967940487}, {
              0.07391382397626135, -0.6757450898172154}, {
              0.07621314022291566, -0.6967662138780217}, {
              0.07858858919531722, -0.7184833689764677}, {
              0.07915575633185823, -0.7236686020899157}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5204913854892043, 0.5299142555431343, 0.1798448241999429], 
             
             ArrowBox[{{0.07959068714665908, -0.7276448861826758}, {
              0.08104017089346603, -0.7408965551125533}, {
              0.08356788531736212, -0.7640057722862788}, {
              0.08617173246700549, -0.7878110204976438}, {
              0.0888517123423961, -0.8123122997466486}, {
              0.09160782494353399, -0.8375096100332932}, {
              0.09395867447238754, -0.8590018687281226}, {
              0.09637145083055326, -0.8810602833675978}, {
              0.09698791973869307, -0.886696249893078}}]}}, {
            Arrowheads[{{0.013747441513701608`, 1.}}], {
             LABColor[
             0.6012517254426035, 0.5351767408353288, 0.5396341523436213], 
             
             ArrowBox[{{0.09742285055349392, -0.8906725339858381}, {
              0.09884464107244745, -0.9036710220932871}, {
              0.10138278403482122`, -0.9268755804804846}, {
              0.10460396361112154`, -0.9563246897946438}, {
              0.10792393460848415`, -0.9866769835756268}, {
              0.10938122243145647`, -1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.37410463716299863`, 0.5222649868167614, -0.4140261670422741], 
             
             ArrowBox[{{0.4103827922372502, 0.11957802177901393`}, {
              0.4355967966538585, 0.12692492039732217`}, {0.46245615933593, 
              0.13475124624850549`}, {0.49096088028346485`, 
              0.1430569993325639}, {0.5211109594964631, 0.1518421796494974}, {
              0.5531321033296948, 0.1611725538930292}, {0.5639945548475985, 
              0.16433767311525638`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4513177226699321, 0.5254067784398471, -0.12832556841286968`], 
             
             ArrowBox[{{0.5678348489128573, 0.16545666439866244`}, {
              0.5872500181379297, 0.17111388875688252`}, {0.623464703921168, 
              0.18166618424105743`}, {0.6617761606794099, 
              0.1928294403455539}, {0.6817893553464662, 
              0.19866091835348504`}, {0.7024690971018916, 
              0.20468661596262128`}, {0.7214466115232057, 
              0.2102163157349049}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5320409809797721, 0.5306668474271579, 0.23129856008417082`], 
             
             ArrowBox[{{0.7252869055884643, 0.21133530701831096`}, {
              0.7458282218778496, 0.21732066998450883`}, {0.7685076048983823, 
              0.22392902639726026`}, {0.7918535350072838, 
              0.23073160241121665`}, {0.8158660122045546, 
              0.23772839802637813`}, {0.8405450364901945, 
              0.2449194132427447}, {0.8616000318523619, 
              0.25105445287305833`}, {0.8788986681988127, 
              0.2560949583545535}}]}}, {
            Arrowheads[{{0.015267195134447216`, 1.}}], {
             LABColor[
             0.6128250582520842, 0.5359308794846549, 0.5911936385754641], 
             
             ArrowBox[{{0.8827389622640714, 0.2572139496379595}, {
              0.8831960738634737, 0.2573471435774295}, {0.9053202411202212, 
              0.2637937202958326}, {0.9280112978325303, 
              0.27040547820834443`}, {0.9564924645997386, 
              0.27870436803609344`}, {0.9858184827898578, 
              0.2872494320791357}, {1., 0.29138166619297123`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.674377567405788, 0.4697620967797878, 0.7488033978987754], 
             ArrowBox[{{-0.7837757090115414, 
              0.7273039213985526}, {-0.8055069138911803, 
              0.7474693722334727}, {-0.8278222652977197, 
              0.7681768812807118}, {-0.8507217632311596, 
              0.7894264485402702}, {-0.8742054076915, 
              0.8112180740121481}, {-0.8939327534857763, 
              0.8295240457206323}, {-0.9010590586869215, 
              0.8361368938330245}}]}}, {
            Arrowheads[{{0.016372120652578506`, 1.}}], {
             LABColor[
             0.7318561884843656, 0.3386927487946368, 0.7808683201450085], 
             
             ArrowBox[{{-0.903991142428806, 
              0.8388577181438863}, {-0.9141156030473834, 
              0.8482527017154275}, {-0.9347441001601864, 
              0.8673948959301749}, {-0.9558478134725893, 
              0.8869780665639506}, {-0.9817864969762049, 
              0.9110478431737508}, {-1., 0.9279490459276823}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6851075947474827, 0.44529425706567655`, 0.7547892320394561], 
             
             ArrowBox[{{-0.7494293595176444, 
              0.8050241511546967}, {-0.7701874195922032, 
              0.8273221028947986}, {-0.7914887685217883, 
              0.8502036461953255}, {-0.8133334063063998, 
              0.873668781056278}, {-0.8316828544976818, 
              0.8933794432644564}, {-0.8504558902541801, 
              0.9135451159626796}, {-0.8584504105444307, 
              0.9221326924017589}}]}}, {
            Arrowheads[{{0.01279831398616186, 1.}}], {
             LABColor[
             0.7425837389798432, 0.314230557069511, 0.7868527725566241], 
             
             ArrowBox[{{-0.8611759368201004, 
              0.9250604059329355}, {-0.8696433499826707, 
              0.9341559557764345}, {-0.8892727244628266, 
              0.9552414928292609}, {-0.9133989979620125, 
              0.9811575216017512}, {-0.9309402189272096, 1.}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.376104563014918, 0.5222614157712959, -0.4092464532893435], 
             
             ArrowBox[{{0.42938764570064913`, 0.04310322349452858}, {
              0.45654663732239453`, 0.045829524769098184`}, {
              0.48541165667300423`, 0.048727082238906275`}, {
              0.5159827037524783, 0.051795895903952845`}, {0.5485006714849368,
               0.05506014732057879}, {0.583206452794499, 
              0.05854401804512496}, {0.5885875475745855, 
              0.05908418852574706}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.45333398153554416`, 0.5255381614012321, -0.11934308489384417`], 
             
             ArrowBox[{{0.592567545121434, 0.05948371265152752}, {
              0.6201000476811657, 0.06224750807759142}, {0.6591814561449364, 
              0.06617061741797811}, {0.6796189741720775, 
              0.06822219695459912}, {0.7007562130011781, 
              0.07034401657011528}, {0.7225931726322379, 
              0.07253607626452663}, {0.745129853065257, 
              0.07479837603783314}, {0.7517674469953703, 
              0.07546467768274599}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5340572398453842, 0.5307982303885429, 0.2402810436031964], 
             
             ArrowBox[{{0.7557474445422188, 0.07586420180852645}, {
              0.7683662543002358, 0.07713091589003483}, {0.7923023763371738, 
              0.0795336958211317}, {0.8169382191760712, 
              0.08200671583112373}, {0.8422737828169281, 
              0.08454997592001096}, {0.8638852860714816, 
              0.08671940362516475}, {0.8860660049448846, 
              0.08894597090636716}, {0.9088020346484167, 
              0.09122828195910013}, {0.9149473464161552, 
              0.0918451668397449}}]}}, {
            Arrowheads[{{0.010185013317557747`, 1.}}], {
             LABColor[
             0.6147804981552243, 0.5360582993758538, 0.5999051721002369], 
             
             ArrowBox[{{0.9189273439630036, 0.09224469096552537}, {
              0.932135089548238, 0.09357052419691769}, {0.9617451089700046, 
              0.09654286701486525}, {0.9922630651009422, 
              0.09960635125079756}, {1., 0.10038300804904461`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.39376994260419124`, 0.5222298726650266, -0.36702715916273654`], 
             
             ArrowBox[{{-0.4247095943602693, -0.20753677741935586`}, \
{-0.44996061359311434`, -0.21987583268848043`}, {-0.47680312426703586`, \
-0.2329925793715911}, {-0.5052371263820341, -0.24688701746868796`}, \
{-0.5352626199381089, -0.26155914697977095`}, {-0.5670899177840746, \
-0.27711173848377785`}, {-0.5684643148826287, -0.27778334550305905`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4735930990162765, 0.526858281002471, -0.029088211383127498`], 
             
             ArrowBox[{{-0.5720581828956877, -0.2795395097051516}, \
{-0.6009293327687453, -0.29364756255964614`}, {-0.6367808648921212, \
-0.3111666192073761}, {-0.6746445141542022, -0.32966890842696756`}, \
{-0.6943967442408584, -0.3393209488646341}, {-0.7147837266693929, \
-0.3492831646721113}, {-0.715812903418047, -0.34978607778885484`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5543163573261165, 0.5321183499897818, 0.33053591711391295`], 
             
             ArrowBox[{{-0.719406771431106, -0.3515422419909474}, \
{-0.7358054614398062, -0.35955555584939924`}, {-0.7574619485520977, \
-0.3701381223964979}, {-0.7797531880062681, -0.3810308643134074}, \
{-0.8026791798023171, -0.3922337816001275}, {-0.8262399239402445, \
-0.40374687425665845`}, {-0.8504354204200505, -0.41557014228300015`}, \
{-0.8631614919534654, -0.4217888100746506}}]}}, {
            Arrowheads[{{0.018537775949103663`, 1.}}], {
             LABColor[
             0.6350515951147276, 0.5373791995809246, 0.6902134144875711], 
             
             ArrowBox[{{-0.8667553599665243, -0.42354497427674315`}, \
{-0.8710281265610793, -0.42563288616165057`}, {-0.8921319196851017, \
-0.43594537562373015`}, {-0.9137349777143545, -0.4465018337431841}, \
{-0.9358727668821272, -0.4573195912981767}, {-0.9633601505660896, \
-0.47075145887360004`}, {-0.9916290780497333, -0.48456523230599446`}, {-1., \
-0.48865573129320033`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3896671862955693, 0.5222371985012809, -0.37683252306381476`], 
             
             ArrowBox[{{-0.44334272127195284`, -0.1326806250245718}, \
{-0.47056295125098735`, -0.14082691220521884`}, {-0.49944361484883426`, \
-0.14947012278121063`}, {-0.5299847120654934, -0.15861025675254714`}, \
{-0.5624129158412695, -0.1683151512708331}, {-0.5966255521553802, \
-0.17855407874633364`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4687035290592444, 0.5265396680545947, -0.05087136745660625], 
             
             ArrowBox[{{-0.6004576229274659, -0.1797009150893777}, \
{-0.6336106618910862, -0.18962273340306746`}, {-0.6723802041651268, \
-0.20122542101701588`}, {-0.6926290594850716, -0.2072853621212127}, \
{-0.7135491934211546, -0.21354619897057786`}, {-0.7351406059733756, \
-0.22000793156511117`}, {-0.7537404538108932, -0.22557436881113951`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5494267873690845, 0.5317997370419055, 0.30875276104043453`], 
             
             ArrowBox[{{-0.7575725245829789, -0.22672120515418354`}, \
{-0.7803372669262321, -0.23353408398968242`}, {-0.8039425153268674, \
-0.2405985038197204}, {-0.828219042343641, -0.2478638193949266}, \
{-0.8531668479765527, -0.255330030715301}, {-0.874449965312154, \
-0.2616994987928578}, {-0.8962776798395926, -0.2682319502517416}, \
{-0.9108553554664062, -0.2725946588759453}}]}}, {
            Arrowheads[{{0.011131393290405626`, 1.}}], {
             LABColor[
             0.6301610663401885, 0.5370605241548191, 0.6684259868581914], 
             
             ArrowBox[{{-0.9146874262384919, -0.27374149521898933`}, \
{-0.9186370358049195, -0.27492350778112906`}, {-0.9415669004699813, \
-0.28178580331348996`}, {-0.9703022275680233, -0.2903855185602302}, \
{-0.9998853453335464, -0.2992389548905798}, {-1., \
-0.29927326796729703`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6862902845494394, 0.44259735205469464`, 0.7554490052878315], 
             
             ArrowBox[{{0.8364827679227858, 0.719334420211573}, {
              0.8597358587842228, 0.7393309452738597}, {0.8835848127569109, 
              0.7598398835765549}, {0.903649747955106, 0.7770947501211682}, {
              0.9241809767458707, 0.7947506064337985}, {0.9451683489819434, 
              0.8127987238823977}, {0.9577953216478321, 
              0.8236573050868857}}]}}, {
            Arrowheads[{{0.006458006744763494, 1.}}], {
             LABColor[
             0.7437472486250162, 0.3115773888531267, 0.7875018459965422], 
             
             ArrowBox[{{0.9608281354909582, 0.8262653772087685}, {
              0.966642315105108, 0.8312652883631084}, {0.9930459757506764, 
              0.853971149918521}, {1., 0.8599512719166661}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6100365096023984, 0.5357491727674221, 0.578770584812375], 
             
             ArrowBox[{{-0.6180477112055792, -0.6732340769922074}, \
{-0.6351645753722692, -0.6918793304885502}, {-0.6527610418925168, \
-0.7110470107198629}, {-0.6708896703110367, -0.7307943703479245}, \
{-0.6895504606278291, -0.7511214093727353}, {-0.7087434128428938, \
-0.7720281277942951}, {-0.7262508097723018, -0.7910987852833669}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6774140438789287, 0.4628379746620579, 0.7504973213121549], 
             
             ArrowBox[{{-0.72895588723647, -0.7940454029906459}, \
{-0.7487258029678407, -0.8155806028276628}, {-0.7695152408777227, \
-0.8382263594394703}, {-0.7908368406858771, -0.8614517954480269}, \
{-0.8087688842956939, -0.8809850169281133}, {-0.8271170201973007, \
-0.9009714841769775}, {-0.8371589858031926, -0.9119101112818053}}]}}, {
            Arrowheads[{{0.014447627664862605`, 1.}}], {
             LABColor[
             0.7348848646820557, 0.3317864137601425, 0.7825578921104737], 
             
             ArrowBox[{{-0.8398640632673606, -0.9148567289890843}, \
{-0.8458722037964808, -0.9214013449956246}, {-0.8650615688758835, \
-0.9423041559810389}, {-0.8886538788465954, -0.9680030571164613}, \
{-0.9128706123900932, -0.9943821375002732}, {-0.9180279672811826, \
-1.}}]}}}}}}}, {
      DisplayFunction -> Identity, PlotRange -> {{-1, 1}, {-1, 1}}, 
       DisplayFunction -> Identity, AspectRatio -> 1, Frame -> True, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> Small, 
       Method -> {
        "VectorLengthFunction" -> 
         Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
           System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
           System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
           System`VectorPlotsDump`imin = If[
              NumericQ[System`VectorPlotsDump`min], 
              System`VectorPlotsDump`min, 
              Min[System`VectorPlotsDump`m], 
              Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
              NumericQ[System`VectorPlotsDump`max], 
              System`VectorPlotsDump`max, 
              Max[System`VectorPlotsDump`m], 
              Max[System`VectorPlotsDump`m]]; Map[If[
              
              Or[# > System`VectorPlotsDump`imax, # < 
               System`VectorPlotsDump`imin], #, 
              System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
         "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "TransparentPolygonMesh" -> True}, PlotRangeClipping -> True, 
       PlotRangePadding -> {{
          Scaled[0.05], 
          Scaled[0.05]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, Ticks -> {Automatic, Automatic}, DisplayFunction -> 
       Identity, AspectRatio -> 1, DisplayFunction :> Identity, Frame -> True,
        FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImageSize -> Small, 
       Method -> {
        "VectorLengthFunction" -> 
         Function[{System`VectorPlotsDump`m, System`VectorPlotsDump`vrange}, 
           System`VectorPlotsDump`min = Min[System`VectorPlotsDump`vrange]; 
           System`VectorPlotsDump`max = Max[System`VectorPlotsDump`vrange]; 
           System`VectorPlotsDump`imin = If[
              NumericQ[System`VectorPlotsDump`min], 
              System`VectorPlotsDump`min, 
              Min[System`VectorPlotsDump`m], 
              Min[System`VectorPlotsDump`m]]; System`VectorPlotsDump`imax = If[
              NumericQ[System`VectorPlotsDump`max], 
              System`VectorPlotsDump`max, 
              Max[System`VectorPlotsDump`m], 
              Max[System`VectorPlotsDump`m]]; Map[If[
              
              Or[# > System`VectorPlotsDump`imax, # < 
               System`VectorPlotsDump`imin], #, 
              System`VectorPlotsDump`imax]& , System`VectorPlotsDump`m]], 
         "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "TransparentPolygonMesh" -> True}, PlotRange -> {{-1, 1}, {-1, 1}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {{
          Scaled[0.05], 
          Scaled[0.05]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
     GraphicsBox[{
       Opacity[0], 
       LineBox[{{0, 0}, {1, 0}}]}, ImageSize -> 40], 
     GraphicsBox[{{{{}}, {{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6630661181584674, 0.4955557614466321, 0.7424932127586046], 
             
             ArrowBox[{{0.27448118503913793`, -1.}, {
              0.27349648317137515`, -0.9982622164525605}, {
              0.2582184357403669, -0.9717677254452523}, {
              0.24317221749415513`, -0.9461503752171981}, {
              0.2251655928057159, -0.916055375450235}, {
              0.20745858982094192`, -0.8871655266285343}, {
              0.19215083650122802`, -0.8628245176524397}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5934425285552005, 0.5346678798797221, 0.5048439854983394], 
             
             ArrowBox[{{0.19002122671288718`, -0.8594385535453148}, {
              0.1728560027010599, -0.8328824320487992}, {
              0.15591669543528708`, -0.8074297614047046}, {
              0.1391895636118498, -0.7830633919337515}, {
              0.1226527456654156, -0.7597536111929101}, {
              0.10628438003065219`, -0.7374707067391499}, {
              0.0990047879633631, -0.7279043499379226}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5200167743395863, 0.5298833290488202, 0.17773041969459963`], 
             
             ArrowBox[{{0.09658252312237946, -0.7247211702320099}, {
              0.09007987216543605, -0.7161758178780656}, {
              0.07402834861011323, -0.6958334105521152}, {
              0.058098529423055476`, -0.6764187622735643}, {
              0.04225913466263473, -0.6579071505546786}, {
              0.026478884387222654`, -0.6402738529077234}, {
              0.01072649865519102, -0.6234941468449646}, \
{-0.005029302475088325, -0.6075433098786672}, {-0.0084743392931748, \
-0.6042387332269699}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4562331431280488, 0.5257270758516797, -0.10642724771251118`], 
             
             ArrowBox[{{-0.011361001301988298`, -0.6014697654686034}, \
{-0.020819798945243585`, -0.5923966195210972}, {-0.04795183474113439, \
-0.5682954549017112}, {-0.07537683681783391, -0.5463279337372762}, \
{-0.10309480517534221`, -0.5264940560277925}, {-0.1311057398136593, \
-0.5087938217732602}, {-0.1383303952906037, -0.5048186085975644}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.41734213172967594`, 0.5231928693884502, -0.2796876731877231], 
             
             ArrowBox[{{-0.1418349203535617, -0.5028903181414611}, \
{-0.15963413528205167`, -0.49309667830263837`}, {-0.18890448612978583`, \
-0.4792720729448866}, {-0.21891679235686184`, -0.467320005700005}, \
{-0.24967105396327965`, -0.45724047656799327`}, {-0.2814135061084317, \
-0.4489624636435015}, {-0.2910658864196025, -0.44704599537935963`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.42361600803183236`, 0.5236016861639144, -0.25173739783088456`], 
             
             ArrowBox[{{-0.29498930025640274`, -0.4462670063773804}, \
{-0.3143903839517102, -0.4424149450211793}, {-0.3486016874931153, \
-0.4375979207010268}, {-0.38404741673264703`, -0.43451139068304406`}, \
{-0.40785555854586897`, -0.4330449374643226}, {-0.43231355403191757`, \
-0.4323135666262551}, {-0.454061895975257, -0.4332706126433796}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.4706354709410717, 0.5266655567735422, -0.04226451820267338], 
             
             ArrowBox[{{-0.45805802862828954`, -0.433446464340463}, \
{-0.47430195263827457`, -0.43416128585728175`}, {-0.4961266029627029, \
-0.4357869247565511}, {-0.5185048873012977, -0.43788041651165777`}, \
{-0.5409086615973012, -0.43997740337481006`}, {-0.5639170498222883, \
-0.44254923330989093`}, {-0.587530051976259, -0.4455959063169003}, \
{-0.6117476680592134, -0.4491174223958384}, {-0.6171232943829323, \
-0.4499827142518329}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5378882539850443, 0.5310478659841309, 0.25734830711660617`], 
             
             ArrowBox[{{-0.6210724601514055, -0.4506183947793938}, \
{-0.6366220095037963, -0.4531213400380033}, {-0.6622051877426527, \
-0.45761521773469355`}, {-0.6884972027757822, -0.46259905548590896`}, \
{-0.7154980546031854, -0.46807285329164955`}, {-0.7432665271112766, \
-0.47404887312610133`}, {-0.7718614041864704, -0.48053937696344984`}, \
{-0.7779303852360842, -0.48198435611058893`}}]}}, {
            Arrowheads[{{0.006396676027770061, 1.}}], {
             LABColor[
             0.6125181392233294, 0.5359108801028338, 0.589826306649745], 
             
             ArrowBox[{{-0.7818216124555587, -0.482910828304678}, \
{-0.801282685828767, -0.48754436480369545`}, {-0.8315303720381665, \
-0.4950638366468379}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6932264353398974, 0.42678074503503105`, 0.7593183941425178], 
             
             ArrowBox[{{-0.5370714950623473, 
              0.9862937942661628}, {-0.5277967637020594, 
              0.9544783683455189}, {-0.5190000729998399, 
              0.92354108903133}, {-0.5106814229556892, 
              0.8934819563235962}, {-0.5028408135696071, 
              0.8643009702223176}, {-0.4954510609894729, 
              0.8358946585520789}, {-0.49449129430297784`, 
              0.8320733938680068}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.6347391405043251, 0.5373588394909018, 0.6888214214075894], 
             
             ArrowBox[{{-0.4935168998246751, 
              0.8281938893377023}, {-0.4884849813631654, 
              0.8081595491374642}, {-0.48194257469068486`, 
              0.7810956419784739}, {-0.47582384097203106`, 
              0.7547029370751079}, {-0.4701287802072044, 
              0.7289814344273666}, {-0.46485739239620444`, 
              0.7039311340352493}, {-0.4600096775390313, 
              0.6795520358987563}, {-0.458614161889085, 
              0.672073639343781}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5588274514175525, 0.5324123007869377, 0.3506329537693704], 
             
             ArrowBox[{{-0.4578804029472969, 
              0.6681415155136675}, {-0.45558563563568516`, 
              0.6558441400178878}, {-0.45157035605264223`, 
              0.6327237836469802}, {-0.4479489281563789, 
              0.6101073040403702}, {-0.4447213519468951, 
              0.5879947011980579}, {-0.44188762742419085`, 
              0.5663859751200431}, {-0.43740173343912137`, 
              0.5246801532569065}, {-0.43630236770132064`, 
              0.5096881025613339}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.48889803012903826`, 0.5278555771372498, 0.03909563833225571], 
             
             ArrowBox[{{-0.4360098335227452, 
              0.5056988139337255}, {-0.43449124620117013`, 
              0.4849898384509602}, {-0.433023781812113, 
              0.4582488771575253}, {-0.43229137000749285`, 
              0.43232825622547155`}, {-0.43443108794139135`, 
              0.39122525149064963`}, {-0.4387441782070975, 
              0.35186735555378457`}, {-0.4395469166565503, 
              0.3461523794687231}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.43473880733256565`, 0.524326467260204, -0.20218504961396297`], 
             
             
             ArrowBox[{{-0.44010330383885243`, 
              0.34219126430965874`}, {-0.4441627657882682, 
              0.3132905333493538}, {-0.4517923480003679, 
              0.2762758586097917}, {-0.4616736654497272, 
              0.2406402155879797}, {-0.4738474587426768, 
              0.20620048853679931`}, {-0.48163072191132084`, 
              0.18830536405627293`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.41495494526218263`, 0.5230373161344377, -0.2903226484217142], 
             
             ArrowBox[{{-0.48322610459452886`, 
              0.18463729179769897`}, {-0.48837997031744873`, 
              0.17278762583251273`}, {-0.5053374426122752, 
              0.14023257585138213`}, {-0.5181690620674907, 
              0.11873985317358535`}, {-0.5321803242089351, 
              0.09754880629224699}, {-0.5474028774208264, 
              0.07660029247632288}, {-0.563868370087383, 
              0.05583516899476888}, {-0.5687823298265845, 
              0.05011769589669774}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4424479019716759, 0.5248288053778725, -0.16784084078074135`], 
             
             ArrowBox[{{-0.5713895513109121, 
              0.04708415075418536}, {-0.581608450592823, 
              0.03519429311654078}, {-0.6006547673213646, 
              0.01461852211059456}, {-0.6210389686572262, \
-0.005951286754114036}, {-0.6427927029846257, -0.02657427620862922}, \
{-0.6659910833454632, -0.04728437585282062}, {-0.6860726115070939, \
-0.06419257390637953}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5009946367725533, 0.528643813226693, 0.09298632254185596], 
             
             ArrowBox[{{-0.689132448668615, -0.06676888843395072}, \
{-0.6907225965224633, -0.06810775740004266}, {-0.717038951511082, \
-0.08909192675156671}, {-0.7449918573067754, -0.11028438980866422`}, \
{-0.7746330229049989, -0.1317326524726063}, {-0.806014157301209, \
-0.1534842206446644}, {-0.8180101629555038, -0.16147691866847258`}}]}}, {
            Arrowheads[{{0.007883638559866707, 1.}}], {
             LABColor[
             0.57244066089142, 0.5332993613748095, 0.4112801414026587], 
             
             ArrowBox[{{-0.8213389581553032, -0.16369482816116887`}, \
{-0.8391869694908609, -0.17558660022610992`}, {-0.8742031684694108, \
-0.19808729711821405`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6630666638720895, 0.49555451704780545`, 0.742493517189444], 
             
             ArrowBox[{{-0.27448690980873885`, 1.}, {-0.27349132380600116`, 
              0.9982430078952494}, {-0.25821349352634265`, 
              0.971748889003329}, {-0.24316749040594943`, 
              0.9461319030345487}, {-0.2251613302039423, 
              0.9160376755743422}, {-0.20745478223891445`, 
              0.8871485608473313}, {-0.19215739332629567`, 
              0.8628240211316701}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5934429421939287, 0.5346679068331467, 0.5048458282691867], 
             
             ArrowBox[{{-0.19002794106369827`, 
              0.8594379565928111}, {-0.19002598578643065`, 
              0.8594348474857717}, {-0.17285308012205572`, 
              0.8328668241219188}, {-0.15591420452135438`, 
              0.807414779388028}, {-0.13918749825989118`, 
              0.7830490019163537}, {-0.12265110061323109`, 
              0.7597397803391522}, {-0.1062831508569388, 
              0.7374574032886785}, {-0.09901263887802388, 
              0.7279029592541189}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5200165216619044, 0.5298833125838995, 0.17772929400922619`], 
             
             ArrowBox[{{-0.09659037719719235, 
              0.7247197771434668}, {-0.09007905480600309, 
              0.7161630117384976}, {-0.07402793953380393, 
              0.6958210730835164}, {-0.05809852620349301, 
              0.6764068655880031}, {-0.042259535978222004`, 
              0.657895667516226}, {-0.026479690021142463`, 
              0.6402627571324531}, {-0.010727709495405923`, 
              0.6234834127009525}, {0.005027684435835914, 
              0.6075329124859927}, {0.008464837415748099, 
              0.6042358806147626}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4562317516391389, 0.5257269851798235, -0.10643344683029968`], 
             
             ArrowBox[{{0.011351492032035879`, 0.6014669051496737}, {
              0.02081777060943138, 0.5923865347518416}, {0.04794939491474609, 
              0.5682855984936183}, {0.0753739770843542, 0.5463182880883648}, {
              0.10309151711825573`, 0.5264846035360814}, {
              0.13110201501645075`, 0.508784544836768}, {0.13831916381966092`,
               0.50481343987291}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.41733808274327155`, 0.5231926055493998, -0.2797057115231106], 
             
             ArrowBox[{{0.14182368433455442`, 0.5028851411510594}, {
              0.15962996397170057`, 0.49308755939363985`}, {
              0.1888998571767666, 0.4792630946099118}, {0.21891169463164895`, 
              0.4673111504855841}, {0.24966547633634747`, 
              0.4572317270206564}, {0.28140743595756695`, 
              0.44895380239415733`}, {0.29105378512310254`, 
              0.4470385229539696}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.42360963924199807`, 0.5236012711624068, -0.25176577094839325`], 
             
             ArrowBox[{{0.2949771982876624, 0.4462595305662287}, {
              0.3143838071620119, 0.44240635478511514`}, {0.3485945899496825, 
              0.4375893841935299}, {0.3840397843205786, 
              0.43450289061940145`}, {0.40784750711739204`, 
              0.4330364595271904}, {0.43230507341325075`, 
              0.43230509953529367`}, {0.4540496903789889, 
              0.4332619870749078}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.47062819964264657`, 0.5266650829629931, -0.04229691201845742], 
             
             
             ArrowBox[{{0.45804582298809715`, 0.43343783977014394`}, {
              0.4742929291088047, 0.4341528053832973}, {0.49611730315674063`, 
              0.43577843285726936`}, {0.5184953080047827, 
              0.43787191003122156`}, {0.5408988028262831, 
              0.4399688823335836}, {0.5639069083948063, 
              0.44254069459274537`}, {0.5875196247103524, 
              0.44558734680870693`}, {0.6117369517729211, 
              0.44910883898146836`}, {0.6171111050828065, 
              0.4499738980648168}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5378808486993779, 0.5310473834427383, 0.25731531638432176`], 
             
             ArrowBox[{{0.6210602703517908, 0.4506095816954447}, {
              0.636611001058499, 0.4531127296472901}, {0.6621938840430728, 
              0.457606577342433}, {0.688485600726642, 0.46259038206689684`}, {
              0.7154861511092068, 0.4680641438206816}, {0.7432543191754291, 
              0.47404012465345285`}, {0.7718488889099707, 
              0.480530586614876}, {0.7779181742011836, 
              0.48197564420594663`}}]}}, {
            Arrowheads[{{0.006396558317317088, 1.}}], {
             LABColor[
             0.612510772751888, 0.5359104000906443, 0.5897934888358002], 
             
             ArrowBox[{{0.7818094005529893, 0.48290212004427835`}, {
              0.8012698603128316, 0.487535529704951}, {0.8315172333840117, 
              0.49505495392367765`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6647156841326743, 0.4917942318093392, 0.7434134367255413], 
             ArrowBox[{{0.5305939463795191, -0.8971287481963596}, {
              0.5230524234036089, -0.867231928898181}, {
              0.5159657867583227, -0.8380422263123705}, {
              0.5093340364436605, -0.8095596404389279}, {
              0.5031571724596222, -0.7817841712778533}, {
              0.49743519480620796`, -0.7547158188291467}, {
              0.494738379220641, -0.741218541673356}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.597028311725745, 0.5349015357955699, 0.5208187389298322], 
             
             ArrowBox[{{0.49395465235809677`, -0.7372960715071308}, {
              0.4921681034834175, -0.728354583092808}, {
              0.4873558984912511, -0.7027004640688373}, {
              0.4829985798297087, -0.6777534617572347}, {
              0.47908129259626997`, -0.6534235832952067}, {
              0.47558918188841504`, -0.6296208358199601}, {
              0.47252224770614365`, -0.6063452193314945}, {
              0.46988049004945576`, -0.5835967338298103}, {
              0.46944607843401687`, -0.5792417321668435}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5255551935272992, 0.5302442221497429, 0.20240421526895025`], 
             
             ArrowBox[{{0.4690490485992306, -0.5752614850249829}, {
              0.46766390891835163`, -0.5613753793149074}, {
              0.4658725043128311, -0.5396811557867858}, {
              0.46356522467854083`, -0.4978741016908862}, {
              0.4629489648841903, -0.45787902308842876`}, {
              0.46401403866738467`, -0.4193993715257306}, {
              0.4643039000417493, -0.41549809268570487`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4657445883681162, 0.5263468582933118, -0.06405352201281879], 
             
             ArrowBox[{{0.46460027937298937`, -0.4115090878860069}, {
              0.46676044602812405`, -0.38243514700279163`}, {
              0.4711881869664083, -0.3469863495196117}, {
              0.47479455452177877`, -0.32323936444414725`}, {
              0.47919487629070945`, -0.30007690326060754`}, {
              0.49079238222470883`, -0.2618916769309541}, {
              0.49351947247255534`, -0.2547784165744913}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4335315467805201, 0.524247800046784, -0.20756342547475623`], 
             
             ArrowBox[{{0.4949513723715448, -0.2510434918524555}, {
              0.5049875443535281, -0.22486544206240627`}, {
              0.5205282640073368, -0.1883274367534556}, {
              0.538760098711124, -0.15276589056369924`}, {
              0.5597810045611867, -0.11799737271992848`}, {
              0.5664706496346767, -0.10843941336722378`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.44502879466016315`, 0.524996980868735, -0.1563428995024163], 
             
             ArrowBox[{{0.5687642858166312, -0.10516233645863138`}, {
              0.5836889376538222, -0.08383845244893462}, {
              0.6106150350411763, -0.050113494171066204`}, {
              0.6252590717399277, -0.03334788743718478}, {
              0.6406904337753954, -0.016646862306671922`}, {
              0.6624539058119933, 0.0054709545216369854`}, {
              0.6731775433048055, 0.015653090870734205`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.49313759407398705`, 0.5281318345541761, 0.05798300141487102], 
             
             ArrowBox[{{0.6760782594194397, 0.01840733233115517}, {
              0.6857307536314434, 0.02757241388500016}, {0.710576449742718, 
              0.04971823540635649}, {0.7370464666547882, 
              0.07196913870864492}, {0.7651962768766258, 
              0.0943858434148043}, {0.7950813529172027, 
              0.11702906914777376`}, {0.7994129096743273, 
              0.12016473017448823`}}]}}, {
            Arrowheads[{{0.008821126959954465, 1.}}], {
             LABColor[
             0.5598680626901305, 0.5324801088412375, 0.35526890293495794`], 
             
             ArrowBox[{{0.8026530276106905, 0.12251028677334873`}, {
              0.8267571672854901, 0.139959535530492}, {0.86027919249046, 
              0.16323796218589812`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6659338813412454, 0.4890163587349929, 0.7440930180731872], 
             
             ArrowBox[{{0.40901754683438313`, -0.9621192922796817}, {
              0.3971967220714977, -0.9327928189648914}, {
              0.3857577267081404, -0.9043666909412362}, {
              0.3746881464325871, -0.8768092099658495}, {
              0.36397556693311367`, -0.8500886777958634}, {
              0.3536075738979959, -0.8241733961884103}, {
              0.34940299074071896`, -0.8136400783117704}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5940807999224876, 0.534709470760651, 0.507687500354048], 
             
             ArrowBox[{{0.3479200869477217, -0.8099251090870373}, {
              0.3435717530155097, -0.7990316669006229}, {
              0.3338556899739307, -0.7746317916896334}, {
              0.3244469704615349, -0.7509420723125741}, {
              0.3141286647491644, -0.7248851648177921}, {
              0.3041589668751594, -0.6996245260964868}, {
              0.29453787683951993`, -0.6751601561486582}, {
              0.2890490081579121, -0.6611497653465904}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5133994818061053, 0.5294521346698504, 0.14825021646458447`], 
             
             ArrowBox[{{0.2875899027836371, -0.6574253846589106}, {
              0.285265394642246, -0.6514920549743064}, {
              0.27634152028333764`, -0.6286202225734312}, {
              0.26776625376279467`, -0.6065446589460327}, {
              0.25953959508061736`, -0.585265364092111}, {
              0.25166154423680553`, -0.5647823380116661}, {
              0.23679879153441777`, -0.5258069299378961}, {
              0.23013265488123735`, -0.5080993230308073}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.43278450888616493`, 0.5241991217483268, -0.2108914979205013], 
             
             ArrowBox[{{0.2287233833472916, -0.5043558014610003}, {
              0.2230255211257707, -0.48922027249141253`}, {
              0.2103417330108644, -0.45502236567221543`}, {
              0.19874742718969876`, -0.4232132094803047}, {
              0.18813406429416454`, -0.3934915050227361}, {
              0.1783931049561525, -0.3655559534065653}, {
              0.17442592048767, -0.3538585033090363}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3582987872164206, 0.5222932095674826, -0.45180128670179154`], 
             
             ArrowBox[{{0.17314119780759, -0.35007043155215417`}, {
              0.1695245491756625, -0.33940655463179226`}, {
              0.16152839695269464`, -0.3150433086984169}, {
              0.15682474745026925`, -0.3004406400744796}, {
              0.1524244200650961, -0.2864295295371984}, {
              0.1446835555917742, -0.25913906266279574`}, {
              0.13820404428109834`, -0.23398646799281564`}, {
              0.1323340340174701, -0.20980174094648651`}, {
              0.12950157134564755`, -0.1962521111760537}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.2891743045925171, 0.522416637478567, -0.6170050316029321], 
             
             ArrowBox[{{0.12868308944252033`, -0.19233674562808079`}, {
              0.12768302584793711`, -0.18755274914745937`}, {
              0.12187585132420659`, -0.14805365863430142`}, {
              0.12055335311522374`, -0.11400469788919124`}, {
              0.12477096594436785`, -0.07949081734775243}, {
              0.13532757807949078`, -0.048983547176133534`}, {
              0.14267862196077205`, -0.036996538991768656`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.25354363273052977`, 0.5224802592118737, -0.70216039481875], 
             
             ArrowBox[{{0.1447697319859154, -0.033586662327907475`}, {
              0.15269827571774353`, -0.020657951774903212`}, {
              0.1778430233352772, 0.006714354063702549}, {
              0.19367598089816826`, 0.02049023514895487}, {
              0.21203289298504197`, 0.034523483889838585`}, {
              0.23310724027228583`, 0.04897933030178288}, {
              0.25709250343628737`, 0.06402300440021698}, {0.2654814333970296,
               0.06889942149100696}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3094086672601168, 0.5223805072245472, -0.5686460079764846], 
             
             ArrowBox[{{0.26893961757064583`, 0.0709096359624876}, {
              0.28434041048765435`, 0.07986199223958934}, {0.3152931164851204,
               0.09672792618235945}, {0.3502797426772618, 
              0.1148222557059731}, {0.3693886262365159, 
              0.12439302177229804`}, {0.38962941031265497`, 
              0.13434643028787602`}, {0.4108993919079236, 
              0.1446188783910163}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3795956887637547, 0.5222551820557997, -0.4009028530809105], 
             
             ArrowBox[{{0.41450557735462173`, 0.14634955804603628`}, {
              0.43842722986393257`, 0.1577000831689406}, {0.4653606359677987, 
              0.1702816281525646}, {0.4941011919245636, 0.1835243014209753}, {
              0.5247370119597883, 0.1974715899162171}, {0.5573562102990327, 
              0.21216698058033404`}, {0.5598329488230955, 
              0.21327267200560004`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4570402471156426, 0.5257796681620442, -0.10283157932372025`], 
             
             ArrowBox[{{0.5634854978363177, 0.21490328100410622`}, {
              0.5920469011678577, 0.22765396035537036`}, {0.628897198791824, 
              0.24397601618337036`}, {0.6681245174657331, 
              0.261223255966126}, {0.6887167723469381, 
              0.27022892687596334`}, {0.7098846897755635, 
              0.2794559472842992}}]}}, {
            Arrowheads[{{0.012073799132955115`, 1.}}], {
             LABColor[
             0.5376809980770649, 0.5310343608259295, 0.25642497687890914`], 
             
             ArrowBox[{{0.7135532279793034, 0.28105025807554224`}, {
              0.7319508426857211, 0.2890449984251082}, {0.7546296059384476, 
              0.298871650141436}, {0.7780408197768302, 0.3089882132036145}, {
              0.8022029580984434, 0.319402813150154}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.20432022897944938`, 0.5225681519767934, -0.8198016461927935], 
             
             ArrowBox[{{-0.036082359888581036`, -0.0021284647075908054`}, \
{-0.04560930634462087, -0.009318486892441618}, {-0.059069113902546766`, \
-0.017317310222599528`}, {-0.06769535599500222, -0.021846086828465013`}, \
{-0.07778355923851171, -0.0268528835655998}, {-0.11719573910964504`, \
-0.045056599356170984`}, {-0.13579461564545958`, -0.053246902231499985`}, \
{-0.15743671721886332`, -0.06263024120889382}, {-0.17956845029586718`, \
-0.07211347772705638}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.27444762126301614`, 0.5224429332813211, -0.6522010018822879], 
             
             ArrowBox[{{-0.18324591587270836`, -0.07368708059651814}, \
{-0.212020279565423, -0.0859099240468765}, {-0.2462271271264397, \
-0.1003456693713706}, {-0.28600797330076727`, -0.11705325372574005`}, \
{-0.2983352655459683, -0.12222058330020938`}, {-0.31119761372252863`, \
-0.12760689376899387`}, {-0.33071393454970516`, -0.1357602949157323}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3456139337090693, 0.5223158595015058, -0.482117395023912], 
             
             ArrowBox[{{-0.33440479028231396`, -0.13730223653624482`}, \
{-0.33813477319576335`, -0.13886052445501504`}, {-0.3674153511146613, \
-0.15107773237456593`}, {-0.3979729135496349, -0.16382058659726284`}, \
{-0.43108444501675997`, -0.177614733426252}, {-0.4669675491299599, \
-0.1925508066896387}, {-0.48209597425788653`, -0.1988433616766097}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.41883651263662375`, 0.5232902458674037, -0.2730301689868774], 
             
             ArrowBox[{{-0.4857892307837912, -0.20037954403357855`}, \
{-0.5058398295031583, -0.20871944021552832`}, {-0.5264618395093932, \
-0.21729296549862623`}, {-0.5479610010249003, -0.22622862769077878`}, \
{-0.5703373140496796, -0.23552642679198602`}, {-0.5935907785837309, \
-0.24518636280224787`}, {-0.6231382048517646, -0.2574578563779151}, \
{-0.6335402535841843, -0.2617768920731941}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4995761855252214, 0.5285513844574345, 0.08666708686780406], 
             
             ArrowBox[{{-0.6372344687980741, -0.2633107675418895}, \
{-0.6541551571786838, -0.27033640825791283`}, {-0.6867224421218379, \
-0.28385558982388376`}, {-0.7209208662385765, -0.29804897245747075`}, \
{-0.75683123608625, -0.3129501275403167}, {-0.7850128348129776, \
-0.3246422793435777}}]}}, {
            Arrowheads[{{0.01176462425894106, 1.}}], {
             LABColor[
             0.5802993653328619, 0.5338114483294045, 0.44629086563558795`], 
             
             ArrowBox[{{-0.7887074739134949, -0.3261751335169836}, \
{-0.7945343582222076, -0.32859262645406434`}, {-0.834111039203799, \
-0.34501004058035645`}, {-0.8546272163108795, -0.3535198319049701}, \
{-0.8756420855883744, -0.362235941300836}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6698534770732146, 0.48007844673720373`, 0.7462795968397593], 
             
             ArrowBox[{{-0.4046189588204245, 
              0.9761077265097665}, {-0.39232809655707823`, 
              0.9464121459264678}, {-0.3804198809436802, 
              0.9176397309350331}, {-0.36888099376058403`, 
              0.8897582781028233}, {-0.3576981167881433, 
              0.8627355839971987}, {-0.34685793180671187`, 
              0.8365394451855201}, {-0.3434353755926615, 
              0.8282680528031988}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5995717206892328, 0.5350672687812176, 0.5321496892786785], 
             
             ArrowBox[{{-0.3419060023430559, 
              0.8245719714372938}, {-0.3363471205966433, 
              0.8111376582351478}, {-0.3261523649382912, 
              0.7864980197134426}, {-0.3162603466120094, 
              0.762588326187765}, {-0.30548376666031574`, 
              0.7365384495769787}, {-0.29504123731081044`, 
              0.7112937454629438}, {-0.2849327585634936, 
              0.6868542138456601}, {-0.2807431113510225, 
              0.6767237360992733}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5188484959166954, 0.5298072019792561, 0.17252571019115664`], 
             
             ArrowBox[{{-0.2792144128255934, 
              0.6730273756165348}, {-0.2751583304183654, 
              0.6632198547251282}, {-0.26571795287542566`, 
              0.6403906681013479}, {-0.25661162593467446`, 
              0.6183666539743191}, {-0.2478393495961117, 
              0.5971478123440417}, {-0.23940112385973747`, 
              0.5767341432105159}, {-0.22336400549323152`, 
              0.5379283871338865}, {-0.21809034608618166`, 
              0.5251630859261887}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4381253228943201, 0.524547138549426, -0.18709803834810124`], 
             
             ArrowBox[{{-0.21656304941359883`, 
              0.5214661459924167}, {-0.20833745213483357`, 
              0.5015554504445984}, {-0.19432146378454365`, 
              0.4676153331426517}, {-0.18131604044236183`, 
              0.4361080352280466}, {-0.16919902296241332`, 
              0.40673752093409177`}, {-0.15784825219882342`, 
              0.3792077544940959}, {-0.1555240119699264, 
              0.37356674029524123`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.36268416567955486`, 0.5222853790842372, -0.441320471259593], 
             
             ArrowBox[{{-0.1540001889210419, 
              0.36986836723189453`}, {-0.14726372815159222`, 
              0.3535187359080592}, {-0.13744545082071963`, 
              0.32967046517598164`}, {-0.13155879718628655`, 
              0.31536560195400815`}, {-0.12592994052813003`, 
              0.3016790776407929}, {-0.11503840190687689`, 
              0.2751356871241831}, {-0.10511973044143762`, 
              0.2509145651598484}, {-0.09564800785814556, 
              0.22775778656529938`}, {-0.09323985666691247, 
              0.22185432904332114`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.29144392767730554`, 0.5224125848647075, -0.6115807561669597], 
             
             ArrowBox[{{-0.09172903414305349, 
              0.21815062612578032`}, {-0.08707018303914794, 
              0.20672969471032182`}, {-0.07228166990100403, 
              0.17028792151749894`}, {-0.060188949800491595`, 
              0.1401972602468405}, {-0.04890293700565208, 
              0.1116488351718267}, {-0.04012800392131382, 
              0.0888309131678756}, {-0.0331478023455347, 
              0.06927718450523052}}]}}, {
            Arrowheads[{{0.004221410074279173, 1.}}], {
             LABColor[
             0.22055804446654537`, 0.5225391579131843, -0.7809941524415945], 
             
             ArrowBox[{{-0.031803015999253406`, 
              0.06551001717647335}, {-0.02816374027493342, 
              0.05531526717257233}, {-0.0220278822039784, 
              0.033204406005729804`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.7248876133096892, 0.35458329361619234`, 0.7769808430804916], 
             
             ArrowBox[{{-0.7317807272887166, 
              0.9685679989497714}, {-0.727509816621793, 
              0.9363304860456853}, {-0.7237683330191671, 
              0.9047140450202238}, {-0.7205562764808384, 
              0.8737186758733877}, {-0.7178736470068074, 
              0.8433443786051769}, {-0.7157204445970738, 
              0.813591153215591}, {-0.7154889980356174, 
              0.8094387704510143}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6771750195907712, 0.46338302527415554`, 0.7503639796440544], 
             
             ArrowBox[{{-0.7152663905483259, 
              0.8054449695162403}, {-0.7140966692516378, 
              0.7844589997046304}, {-0.7130023209704994, 
              0.7559479180722948}, {-0.7124373997536584, 
              0.7280579083185844}, {-0.7124012309976996, 
              0.7007072679644787}, {-0.7128931400992072, 
              0.6738142945309573}, {-0.7139131270581818, 
              0.64737898801802}, {-0.7140232093199089, 
              0.6455317285943277}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6327787326737196, 0.5372310958808425, 0.6800877556420889], 
             
             ArrowBox[{{-0.7142611560113632, 
              0.6415388121949993}, {-0.7154611918746231, 
              0.621401348425667}, {-0.7175373345485311, 
              0.5958813757538981}, {-0.7201415550799058, 
              0.5708190700027136}, {-0.7232738534687472, 
              0.5462144311721132}, {-0.7269342297150554, 
              0.5220674592620972}, {-0.7325113010955637, 
              0.48807687481238266`}, {-0.7335629244951885, 
              0.4828270102211183}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5917763151866396, 0.5345593064964158, 0.4974209633965946], 
             
             ArrowBox[{{-0.7343485746218543, 
              0.47890492482193714`}, {-0.7391652208052407, 
              0.45485949158430317`}, {-0.7464864923177497, 
              0.42924924988590724`}, {-0.7545310711677087, 
              0.4040263152309139}, {-0.7633294206184628, 
              0.3791220753914375}, {-0.7728713862488972, 
              0.35455940111010653`}, {-0.7824243568015065, 
              0.32997382116108687`}, {-0.783685688322753, 
              0.32700466517106913`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5782306985899861, 0.5336766503788868, 0.43707490371663243`], 
             
             ArrowBox[{{-0.7852496629666962, 
              0.3233230916877467}, {-0.7927429533781457, 
              0.3056839954348352}, {-0.8038271759788155, 
              0.28168992393135167`}, {-0.8156770246035151, 
              0.2579916066506361}, {-0.8283154289469462, 
              0.2345431137579915}, {-0.8417653187038094, 
              0.21129851541872063`}, {-0.8560266938741057, 
              0.1882578116328237}, {-0.8600582191962539, 
              0.1821496695063467}}]}}, {
            Arrowheads[{{0.016180207833367852`, 1.}}], {
             LABColor[
             0.5936790096913633, 0.5346832894050121, 0.5058975148562859], 
             
             ArrowBox[{{-0.8622616457141141, 
              0.17881126995260985`}, {-0.8710995544578339, 
              0.16542100240030058`}, {-0.887013813500594, 
              0.1427440619601186}, {-0.9037993840479855, 
              0.12018296455124516`}, {-0.9214562661000081, 
              0.0977377101736803}, {-0.9399844596566616, 
              0.07540829882742384}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6308595355388052, 0.5371060376319404, 0.6715376845534262], 
             
             ArrowBox[{{-0.04902201152863256, -0.9554338272335645}, \
{-0.06857123653039358, -0.9381690218855125}, {-0.088218168844025, \
-0.9215796514589353}, {-0.10796280846952684`, -0.905665715953833}, \
{-0.12780515540689913`, -0.8904272153702057}, {-0.1477452096561418, \
-0.8758641497080534}, {-0.16778297121725486`, -0.8619765189673757}, \
{-0.17510255571412153`, -0.8571736616662696}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5901347664467189, 0.534452340303539, 0.4901078228304204], 
             
             ArrowBox[{{-0.17844687729746114`, -0.8549792339168988}, \
{-0.18791844009023834`, -0.8487643231481731}, {-0.20815161627509216`, \
-0.8362275622504454}, {-0.22854458496742808`, -0.8243292061596603}, \
{-0.24915943136285768`, -0.8130322247612857}, {-0.269996155461381, \
-0.8023366180553216}, {-0.291054757262998, -0.7922423860417679}, \
{-0.31233523676770875`, -0.7827495287206248}, {-0.3194281393948304, \
-0.7798165284041081}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5750261296064618, 0.5334678350475824, 0.42279846899338147`], 
             
             ArrowBox[{{-0.32312457373100656`, -0.7782880084669344}, \
{-0.3338375939755132, -0.7738580460918921}, {-0.3555618288864113, \
-0.7655679381555698}, {-0.3775079415004032, -0.7578792049116579}, \
{-0.40841589427572145`, -0.7475265349700311}, {-0.43988346230771797`, \
-0.7382970225268434}, {-0.4656051849734085, -0.7329351180556353}, \
{-0.47568094731023847`, -0.7311230891099828}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.5903238216845054, 0.534464659474172, 0.4909500686285991], 
             
             ArrowBox[{{-0.4796177901198232, -0.7304150857959928}, \
{-0.49177016153274467`, -0.728229598681232}, {-0.5184533630263701, \
-0.7241739913919231}, {-0.5456297991074038, -0.7207704538582788}, \
{-0.5728320218131078, -0.7173653001021703}, {-0.6005790523555599, \
-0.7146089836567979}, {-0.6288708907347608, -0.7125015045221621}, \
{-0.6384645723363376, -0.7120162280748096}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6321946037088431, 0.5371930330137448, 0.6774854465390875], 
             
             ArrowBox[{{-0.6424594648713635, -0.7118141547376421}, \
{-0.65770753695071, -0.7110428626982622}, {-0.6871414742484272, \
-0.7102303795152343}, {-0.7172251858729315, -0.7100613763032135}, \
{-0.7479586718242233, -0.7105358530622001}, {-0.7793419321023022, \
-0.7116538097921937}, {-0.802369950107505, -0.7129196560396591}}]}}, {
            Arrowheads[{{0.013295736348363188`, 1.}}], {
             LABColor[
             0.6769168812216854, 0.46397166200710316`, 0.7502199750284567], 
             
             ArrowBox[{{-0.8063639204044148, -0.7131392039100702}, \
{-0.8114326126962252, -0.7134178290664209}, {-0.8442883595950492, \
-0.7158304934581079}, {-0.8779091727987742, -0.7188918029672545}, \
{-0.9122950523073999, -0.7226017575938608}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.630818255207789, 0.5371033477332233, 0.6713537796494788], 
             
             ArrowBox[{{0.04903333165661754, 0.9553492715118506}, {
              0.06858154600395694, 0.9380859448544784}, {0.0882274773312124, 
              0.9214980216857218}, {0.10797112563838404`, 
              0.9055855020055812}, {0.12781249092547167`, 
              0.8903483858140562}, {0.14775157319247542`, 
              0.8757866731111469}, {0.16778837243939526`, 
              0.8619003638968533}, {0.17511629791553815`, 
              0.8570922755604131}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5900969728066362, 0.534449877603714, 0.48993945122151844`], 
             
             ArrowBox[{{0.17846067016257428`, 0.8548979250247752}, {
              0.1879228886662312, 0.8486894581711755}, {0.20815512187298318`, 
              0.8361539559341133}, {0.22854715702002795`, 
              0.8242568292982725}, {0.2491610790677423, 0.8129610503762588}, {
              0.2699968880161261, 0.802266619168072}, {0.2910545838651794, 
              0.7921735356737121}, {0.31233416661490226`, 
              0.7826817998931792}, {0.31944523609481007`, 
              0.7797415279827642}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5749953172795789, 0.5334658272623609, 0.42266119930885326`], 
             
             ArrowBox[{{0.32314171459816676`, 0.7782131148598743}, {
              0.3338356362652946, 0.7737914118264734}, {0.3555589928163565, 
              0.7655023714735945}, {0.3775042362680878, 0.7578146788345425}, {
              0.4084107904775813, 0.7474635108175847}, {0.4398769710642703, 
              0.738235438016356}, {0.4655976439464861, 0.7328745566313248}, {
              0.4757009659975451, 0.7310578810251601}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5903024023321441, 0.5344632637516326, 0.4908546448797671], 
             
             ArrowBox[{{0.47963782982745984`, 0.7303499946043913}, {
              0.49176157669985365`, 0.728170026957405}, {0.5184437399199939, 
              0.7241153781420913}, {0.5456191434083668, 0.7207127671362192}, {
              0.5728203334002723, 0.7173085406262913}, {0.6005663366674752, 
              0.714553120917693}, {0.6288571532099759, 0.7124465080104246}, {
              0.6384855974354984, 0.7119597350537961}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.632180927676906, 0.5371921418595352, 0.677424519475815], 
             
             ArrowBox[{{0.6424804954512644, 0.7117577700973591}, {
              0.6576927830277743, 0.710988701904486}, {0.6871257091546606, 
              0.7101770253682972}, {0.7172084146244248, 0.7100088011702774}, {
              0.7479408994370673, 0.7104840293104278}, {0.7793231635925876, 
              0.7116027097887473}, {0.8023909457063646, 
              0.7128712824183722}}]}}, {
            Arrowheads[{{0.013290291179057737`, 1.}}], {
             LABColor[
             0.6769111476171328, 0.46398473643018806`, 0.7502167764899268], 
             
             ArrowBox[{{0.8063849108729437, 0.7130909235988293}, {
              0.811412853071138, 0.713367426551064}, {0.8442676138528702, 
              0.7157807635432051}, {0.8778874459377844, 0.7188427207651708}, {
              0.9122723493258803, 0.722553298216961}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.7240205023526733, 0.3565605795293578, 0.776497118090333], 
             
             ArrowBox[{{0.7395315437000674, -0.9595327041364583}, {
              0.735598408400264, -0.9274305480433276}, {
              0.73219759108511, -0.8959387497479716}, {
              0.7293290917546054, -0.865057309250391}, {
              0.7269929104087502, -0.8347862265505859}, {
              0.7251890470475442, -0.8051255016485557}, {
              0.7249751314445945, -0.8002382778737778}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6770118089620634, 0.4637551968796598, 0.7502729312503896], 
             
             ArrowBox[{{0.7248002174303008, -0.7962421040677974}, {
              0.7239175016709877, -0.7760751345443009}, {
              0.7231782742790807, -0.7476351252378212}, {
              0.7229713648718228, -0.7198054737291166}, {
              0.7232971643522583, -0.6925052251070464}, {
              0.7241560636234311, -0.6656534244604692}, {
              0.7255480626853413, -0.6392500717893851}, {
              0.7257644877216298, -0.6363321482848943}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6341335359605242, 0.5373193772374433, 0.6861234380650154], 
             
             ArrowBox[{{0.7260603586297207, -0.6323431057424105}, {
              0.7274731615379888, -0.6132951670937943}, {
              0.7299313601813737, -0.5877887103736967}, {
              0.7329226586154958, -0.5627307016290921}, {
              0.7364470568403552, -0.5381211408599806}, {
              0.7405045548559519, -0.5139600280663624}, {
              0.7466499312962852, -0.4799407027602192}, {
              0.7479482877533206, -0.47397110597316994`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5954262135940341, 0.5347971402734654, 0.5136813518068815], 
             
             ArrowBox[{{0.748798392720703, -0.4700624845353185}, {
              0.7538845648003328, -0.44667722978465585`}, {
              0.7617083977591119, -0.4209747286909663}, {
              0.7702669394698777, -0.3956496126546409}, {
              0.7795920866285585, -0.3706332191491893}, {
              0.7896732070031783, -0.3459484356834418}, {
              0.7997658247761038, -0.3212407205177894}, {
              0.800748972659321, -0.319032173656836}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5845884378289515, 0.534090931810292, 0.4653987905479658], 
             
             ArrowBox[{{0.8023756975532054, -0.31537789313673126`}, {
              0.8106374105615792, -0.2968187519920312}, {
              0.822287964359605, -0.2726825301061675}, {
              0.8347174861701808, -0.24883205486019794`}, {
              0.847949907244007, -0.22522133506229092`}, {
              0.8620091588317838, -0.2018043795206148}, {
              0.8768952409335112, -0.1785811882351695}, {
              0.8791639132073735, -0.17525613807661483`}}]}}, {
            Arrowheads[{{0.01695206391419449, 1.}}], {
             LABColor[
             0.6022530396551191, 0.5352419882243229, 0.5440950321268109], 
             
             ArrowBox[{{0.8814183407639441, -0.17195196550361333`}, {
              0.892608153549189, -0.15555176120595499`}, {
              0.9091789059641524, -0.1326719143663695}, {
              0.9266385074637367, -0.10989746364981101`}, {
              0.9449869580479415, -0.0872284090562796}, {
              0.964224257716767, -0.06466475058577532}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.654788792658623, 0.5144306689508035, 0.737875638544421], 
             
             ArrowBox[{{-0.34709024142399203`, 
              0.9520305798565506}, {-0.33397424579867996`, 
              0.9239633383028845}, {-0.32119225521928035`, 
              0.8968123437758929}, {-0.3087737774293632, 
              0.8706745522824806}, {-0.29665006503923497`, 
              0.8453693800694303}, {-0.28480572027485984`, 
              0.8208647766953665}, {-0.2783180663104629, 
              0.8075672870422154}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5787034895819971, 0.5337074582685412, 0.439181199374454], 
             
             ArrowBox[{{-0.2765641373195066, 
              0.8039723276412369}, {-0.27323304424927297`, 
              0.7971447169397108}, {-0.26255189280052377`, 
              0.7754260830862221}, {-0.25209189857035347`, 
              0.7543600212136593}, {-0.24184529386635456`, 
              0.7339317778695735}, {-0.23180431099611948`, 
              0.7141265996015158}, {-0.21230813998731043`, 
              0.6763264244836895}, {-0.20431871875515148`, 
              0.6612198099911788}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.498868584806391, 0.5285052759544523, 0.08351470802233531], 
             
             ArrowBox[{{-0.20244866687463667`, 
              0.6576838651437323}, {-0.19354124400466557`, 
              0.6408414682405884}, {-0.17546324036739058`, 
              0.6075637233479212}, {-0.15801633930791809`, 
              0.576377166205156}, {-0.14111228865682782`, 
              0.5471517450783423}, {-0.12466283624469969`, 
              0.5197574082335292}, {-0.12379753870438245`, 
              0.518381486730241}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.42041019278591507`, 0.5233927896239684, -0.26601938468417036`], 
             
             ArrowBox[{{-0.12166808948408363`, 
              0.5149954202781215}, {-0.10485946803325288`, 
              0.4882678004511287}, {-0.08550183234982331, 
              0.4591635760812799}, {-0.06658992919441106, 
              0.43244473512398296`}, {-0.04812375856701606, 
              0.4081112775792377}, {-0.029909285096898112`, 
              0.3859199947303764}, {-0.02892132105070547, 
              0.38481583174017}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.354930801250515, 0.5222992234059455, -0.4598505895424277], 
             
             ArrowBox[{{-0.026254098522150306`, 
              0.3818349050414456}, {-0.011752473413316991`, 
              0.36562767786073125`}, {0.006346676483727309, 
              0.34723432697030227`}, {0.024388164594234797`, 
              0.33073994205908935`}, {0.04256190306007124, 
              0.3159824776711583}, {0.06105780402310238, 
              0.3027998883505747}, {0.07987586748332827, 
              0.2911921740973388}, {0.09738449495064239, 
              0.28201457900854676`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3180547957722754, 0.5223650687931736, -0.5479822322072438], 
             
             ArrowBox[{{0.10096219090884381`, 0.28022714661172277`}, {
              0.11064919044151077`, 0.2755870359431356}, {
              0.12246777789726188`, 0.27054117278540263`}, {
              0.1482571750577447, 0.2633128503084864}, {0.17542168885380874`, 
              0.2581133923672565}, {0.20338940583282206`, 
              0.25391974050840826`}, {0.23296352917773394`, 
              0.25173770081432356`}, {0.2569956996675224, 
              0.2515968532585618}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3461430479645308, 0.5223149147209476, -0.4808528407999272], 
             
             ArrowBox[{{0.26099563097152323`, 0.25157341049264004`}, {
              0.26438257240426943`, 0.2515535603329338}, {0.2978850490281534, 
              0.2533536061121705}, {0.3337451248917548, 
              0.25715950175363156`}, {0.3722369658374423, 
              0.26299291085891496`}, {0.39562367943977517`, 
              0.2672828885859176}, {0.41942202972077147`, 
              0.27215745276305053`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.40814674842964144`, 0.5225936820967616, -0.32065333506398597`], 
             
             ArrowBox[{{0.4233274733014232, 0.2730216192920856}, {
              0.44552660560919133`, 0.27800094625971783`}, {
              0.47218568171585207`, 0.2844508453372203}, {0.5000784088635329, 
              0.29164253732892753`}, {0.5292762188220221, 
              0.2995869318001917}, {0.5598505433611086, 
              0.30829493831636534`}, {0.5780365240740628, 
              0.3136802238950372}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4856252375263916, 0.5276423162353546, 0.024515265684749397`], 
             
             ArrowBox[{{0.5818718976086351, 0.31481596587731253`}, {
              0.5918728142505811, 0.3177774664428008}, {0.6254490849800634, 
              0.3280789466039542}, {0.6606960618760517, 
              0.33925412333477506`}, {0.6977011559636432, 
              0.35132937736635594`}, {0.7342557088861054, 
              0.363562689048802}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5654378448732017, 0.5328430456099046, 0.38008242143562526`], 
             
             ArrowBox[{{0.7380455242879898, 0.36484219130437673`}, {
              0.7773353398140247, 0.37828564025616807`}, {0.7984792887480865, 
              0.38562847418392826`}, {0.8201392516270092, 
              0.3932194105765844}, {0.8423261548289298, 0.4010617470255231}, {
              0.8650509247319855, 0.40915878112213094`}, {0.8883244877143137, 
              0.41751381045779457`}, {0.8890349700362402, 
              0.41777066742218966`}}]}}, {
            Arrowheads[{{0.0025734359430521067`, 1.}}], {
             LABColor[
             0.6450095180471294, 0.5345855653593239, 0.7288562480616367], 
             
             ArrowBox[{{0.8927966882802926, 0.41913062177891025`}, {
              0.9121577701540512, 0.4261301326239003}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6616043167845286, 0.4988891286946743, 0.7416777348206299], 
             
             ArrowBox[{{0.3591094947003786, -0.9683775778091654}, {
              0.3463088523259608, -0.94060065775074}, {
              0.33382223574322045`, -0.9136777344694025}, {
              0.32163459273915074`, -0.8875764216512521}, {
              0.3097383972073044, -0.8622805261394576}, {
              0.2984587308123764, -0.8384440964660437}, {
              0.29131133482091953`, -0.8234536320387679}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5881715594261765, 0.5343244142933575, 0.48136168660395756`], 
             
             ArrowBox[{{0.28958981803729317`, -0.8198430392946755}, {
              0.28743150263149375`, -0.8153163346945456}, {
              0.27664856945190563`, -0.792880938054178}, {
              0.266101788060861, -0.7711216037741555}, {
              0.2557830152456093, -0.7500220290836932}, {
              0.24568410779339964`, -0.7295659112120054}, {
              0.23579692249148118`, -0.7097369473883072}, {
              0.22611331612710311`, -0.6905188348418133}, {
              0.21885112485094235`, -0.6763356679563944}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5081062995139419, 0.5291072216348448, 0.12466895737456085`], 
             
             ArrowBox[{{0.2170280902254254, -0.6727752543913481}, {
              0.20734410705057013`, -0.653862292137733}, {
              0.18931530279991526`, -0.6194683288615694}, {
              0.17193795004440562`, -0.587191715278518}, {
              0.15512309545330846`, -0.5568872216537737}, {
              0.14084651892650246`, -0.5320995473144526}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4291701656524385, 0.5239636048087076, -0.2269934871455772], 
             ArrowBox[{{0.13885014811503024`, -0.528633352919572}, {
              0.13508395913238677`, -0.5220943156491998}, {
              0.11564535700515824`, -0.4898395877360926}, {
              0.09680728907162285, -0.4601230379144523}, {
              0.07856975533178066, -0.43294466618427885`}, {
              0.060742751583316684`, -0.4080326855563192}, {
              0.050845030192614875`, -0.39514937020646185`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.36023580768326613`, 0.5222897508451764, -0.4471719133896738], 
             
             ArrowBox[{{0.048408124398185606`, -0.3919773850001475}, {
              0.04313627362391593, -0.38511530904132013`}, {
              0.025750321453578445`, -0.36419253663928197`}, {
              0.008584895072304193, -0.3452643683502044}, \
{-0.00853917559664394, -0.3281441901537615}, {-0.025801060630003068`, \
-0.3126453880296269}, {-0.04320076002777322, -0.2987679619778008}, \
{-0.060738273789954375`, -0.2865119119982831}, {-0.06704797821487436, \
-0.28241017825427217`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.31416977552276437`, 0.5223720058423307, -0.5572672187977118], 
             
             ArrowBox[{{-0.07040164924610713, -0.2802300657309674}, \
{-0.07137827471716865, -0.27959519325832155`}, {-0.08213239433997903, \
-0.2732163883015189}, {-0.10636023806227488`, -0.2629218485816323}, \
{-0.13171894817102128`, -0.2548234918619842}, {-0.15776052322781267`, \
-0.24780224696793896`}, {-0.18516782818069408`, -0.24293522572509926`}, \
{-0.21418320912975702`, -0.2401841478767629}, {-0.22361472951478858`, \
-0.23997837566469168`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.33236562605540243`, 0.5223395155330163, -0.5137801280369958], 
             
             ArrowBox[{{-0.22761377784776146`, -0.2398911264208729}, \
{-0.24504901217509298`, -0.23951073316622765`}, {-0.27804211698939874`, \
-0.24091748549918846`}, {-0.3134394032453711, -0.24440690878134044`}, \
{-0.3563863821514669, -0.2508834927397219}, {-0.37928066465468346`, \
-0.255165188973127}, {-0.3863732204755111, -0.256642944685379}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3917558733066761, 0.522233468964872, -0.37184067497956014`], 
             
             ArrowBox[{{-0.3902891267294979, -0.2574588357381472}, \
{-0.40321233199551, -0.2601514251071832}, {-0.42824902627706996`, \
-0.2658489039402716}, {-0.4544583896024865, -0.2722643282707734}, \
{-0.4819080640748829, -0.27940440089706964`}, {-0.5106656917973823, \
-0.2872758246175415}, {-0.5408309417683053, -0.29592088069944333`}, \
{-0.5452202170175731, -0.2972331189220528}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.4677816140657378, 0.5264795944578667, -0.054978521739397934`], 
             
             
             ArrowBox[{{-0.5490526124834753, -0.2983788697644842}, \
{-0.5725133374152636, -0.30539279763122124`}, {-0.6057953024853179, \
-0.31571469904304406`}, {-0.6407592607255281, -0.3269097085650805}, \
{-0.6774876358829549, -0.33900094982749934`}, {-0.7014489551878458, \
-0.34708259120341955`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5473688459659833, 0.5316656379733248, 0.29958458077759703`], 
             
             ArrowBox[{{-0.705239178427854, -0.34836095257286936`}, \
{-0.7160628517046588, -0.3520115464604694}, {-0.7565673319377001, \
-0.3659646220941595}, {-0.7775688036294285, -0.3733018156707022}, \
{-0.7990835003291389, -0.38088330035873813`}, {-0.8211414115207654, \
-0.3887224811630528}, {-0.8437756765307299, -0.3968344454165937}, \
{-0.8562146054945893, -0.4013279532495405}}]}}, {
            Arrowheads[{{0.01765821970615706, 1.}}], {
             LABColor[
             0.6275990341553471, 0.5368935776474291, 0.6570120695938703], 
             
             ArrowBox[{{-0.8599766594882325, -0.4026869785432391}, \
{-0.8670013230911477, -0.40522460706537533`}, {-0.8908333789341338, \
-0.41389838005541246`}, {-0.9152868717918031, -0.4228611783327194}, \
{-0.9403768293962699, -0.4321184158433107}, {-0.9661182794796495, \
-0.44167550653320076`}, {-0.9925262497740566, -0.45153786434840426`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6857265729325068, 0.44388279197473024`, 0.7551345341187766], 
             
             ArrowBox[{{-0.4622507529283329, 1.}, {-0.45155434023103747`, 
              0.9707731047780949}, {-0.4410690906540096, 
              0.9418980707329169}, {-0.4309568958223716, 
              0.9138169125532585}, {-0.42121185009732354`, 
              0.8865133245384222}, {-0.4114263590321043, 
              0.8588715724595324}, {-0.40812040077646966`, 
              0.8494362283307655}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.622101285927404, 0.536535334737525, 0.6325194641593693], 
             
             ArrowBox[{{-0.4067977203589948, 
              0.8456612426999016}, {-0.40201549789507907`, 
              0.8320125783314213}, {-0.39297252251277504`, 
              0.8059156868202874}, {-0.3842906887117191, 
              0.7805602425923288}, {-0.3759632523184387, 
              0.7559255903137438}, {-0.3679834691594607, 
              0.7319910746507305}, {-0.3603445950613122, 
              0.7087360402694873}, {-0.35560555076648176`, 
              0.6940763968024609}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5420286514941834, 0.5313176615423003, 0.2757938812551069], 
             
             ArrowBox[{{-0.35437515842484907`, 
              0.6902703312899333}, {-0.35303988585052043`, 
              0.6861398318362125}, {-0.3460601727903407, 
              0.6641880185633617}, {-0.33939716880339954`, 
              0.642863906192024}, {-0.3269996013115718, 
              0.602002581990484}, {-0.3158038098997131, 
              0.5633634549047819}, {-0.3085708473837988, 
              0.5369826951488066}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.46287306373228443`, 0.5261597447153977, -0.07684623586308383], 
             
             
             ArrowBox[{{-0.3075131781448583, 
              0.5331250617057487}, {-0.30576642109249946`, 
              0.5267541206081079}, {-0.2955078393781213, 
              0.4865723290454812}, {-0.28667309328401647`, 
              0.44862106423468273`}, {-0.27926218281018517`, 
              0.41290032617571293`}, {-0.27327510795662724`, 
              0.3794101148685714}, {-0.27292023232845686`, 
              0.3769812038939763}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.3891086911248677, 0.522238195744076, -0.3781672960734169], 
             
             ArrowBox[{{-0.2723419525711526, 
              0.3730232255562018}, {-0.26866015789259956`, 
              0.34782354772245083`}, {-0.2653656217873589, 
              0.31781374214654384`}, {-0.2633914996409053, 
              0.28938069814085027`}, {-0.2627377914532388, 
              0.2625244157053702}, {-0.2634057899062072, 
              0.236983559446272}, {-0.2653043821310638, 
              0.2136332658804644}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.33573598783186365`, 0.5223334974523324, -0.5057251471386577], 
             
             ArrowBox[{{-0.2657972504366192, 
              0.2096651941865189}, {-0.268710784779593, 
              0.18906411927572622`}, {-0.2733477812000103, 
              0.16668553536427866`}, {-0.2766034054964589, 
              0.1532590085489971}, {-0.28036807571295164`, 
              0.14014278763142493`}, {-0.2915611392972704, 
              0.11443630480596831`}, {-0.30519800146237724`, 
              0.08944976119945117}, {-0.32012650987936986`, 
              0.0647266297140429}, {-0.3221754217020985, 
              0.06189561877454765}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.33198588696340386`, 0.5223401935909359, -0.514687683764029], 
             
             ArrowBox[{{-0.32452061195411236`, 
              0.058655235667280974`}, {-0.33763831080013446`, 
              0.040530322470852406`}, {-0.3578804887236864, 
              0.016665217276110558`}, {-0.38100012814904116`, \
-0.007064308063951703}, {-0.4071956292966854, -0.030850237928546263`}, \
{-0.43650371197277105`, -0.05475269684430352}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.38122516318208105`, 0.5222522724843136, -0.39700849805777383`], 
             
             ArrowBox[{{-0.4396908326951474, -0.05716954628676644}, \
{-0.4554055021994402, -0.06903818442525184}, {-0.4753917160474378, \
-0.08335999804172503}, {-0.49668210764696713`, -0.09789718744721278}, \
{-0.5193347507138972, -0.11269694254262325`}, {-0.5434077189640971, \
-0.12780645322886466`}, {-0.5689590861134355, -0.14327290940684517`}, \
{-0.5729199704680636, -0.1455935661442471}}]}}, {
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.4530586819048967, 0.5255202223948081, -0.12056955161260752`], 
             
             ArrowBox[{{-0.5763712340154915, -0.14761563931952923`}, \
{-0.5960469258777814, -0.15914350097747312`}, {-0.6247293119730039, \
-0.17546541784165653`}, {-0.6551172624701512, -0.19228386677140663`}, \
{-0.6873380860110968, -0.20964344434522764`}, {-0.7164262870963681, \
-0.22493645566626838`}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5317436972996878, 0.5306474759015432, 0.22997415387702336`], 
             
             ArrowBox[{{-0.7199667907773493, -0.22679786203913782`}, \
{-0.7214742921679465, -0.2275904251737677}, {-0.7576083905128056, \
-0.24617108386767467`}, {-0.7958228906177799, -0.26543169503759656`}, \
{-0.8157360755715933, -0.27533144361689055`}, {-0.8362003020549753, \
-0.2854185332941814}, {-0.8572258837644386, -0.29569874839579985`}, \
{-0.8629963002656857, -0.2984985915793785}}]}}, {
            Arrowheads[{{0.007931648924490508, 1.}}], {
             LABColor[
             0.611624880077021, 0.5358526737713317, 0.5858468148807163], 
             
             ArrowBox[{{-0.8665950508602067, -0.3002447285036875}, \
{-0.8788231343964971, -0.3061778732480771}, {-0.9010023676476635, \
-0.31686169217734417`}, {-0.9237738972144514, -0.32775598950993184`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6876212607410506, 0.4395623074007919, 0.7561915013201782], 
             
             ArrowBox[{{0.47493294961136734`, -1.}, {
              0.46732313483496446`, -0.9785459583329481}, {
              0.45713878302850197`, -0.949550822374454}, {
              0.44733412100126785`, -0.9213432737756116}, {
              0.43683061474412654`, -0.8908204192630939}, {
              0.4267698367311136, -0.861201794261527}, {
              0.4226152914331465, -0.848797665223932}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6249612942099657, 0.5367216978896765, 0.6452608723686712], 
             
             ArrowBox[{{0.4213449229117088, -0.8450047555466867}, {
              0.41714399772784844`, -0.8324621511650749}, {
              0.4079453084999499, -0.8045762423679015}, {
              0.3991659798130375, -0.7775188202641703}, {
              0.39079822243273005`, -0.751264637248045}, {
              0.38283424712464703`, -0.7257884457136897}, {
              0.37526626465440743`, -0.7010649980552678}, {
              0.37272470563814, -0.6925780392925125}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5453371793019379, 0.5315332510127901, 0.29053345513237827`], 
             
             ArrowBox[{{0.3715771900790835, -0.6887461718572111}, {
              0.3680819964060619, -0.6770747668727455}, {
              0.3612707962660497, -0.6537961446912517}, {
              0.35482732375357273`, -0.6312007637926942}, {
              0.34874623838783303`, -0.609260256458981}, {
              0.33764986717337353`, -0.5672303916137188}, {
              0.32962192596043177`, -0.5343686924118451}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.46709449298683536`, 0.5264348204441147, -0.0580396632783554], 
             
             ArrowBox[{{0.32867266241383936`, -0.5304829622720759}, {
              0.32793895877628704`, -0.5274796084107277}, {
              0.31906643596067774`, -0.4874159134434991}, {
              0.31164606785655885`, -0.44944865261876504`}, {
              0.3056778544639304, -0.41357782593652564`}, {
              0.30116179578279256`, -0.3798034333967811}, {
              0.3005111133587924, -0.3730854436838912}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.39518294838965345`, 0.5222273496175356, -0.3636501523705785], 
             
             ArrowBox[{{0.3001254910754266, -0.36910407514348054`}, {
              0.29806356616233, -0.3478156710864332}, {
              0.29634883995172745`, -0.31730473509238405`}, {
              0.29601761715098507`, -0.2882706254146337}, {
              0.2970698977601028, -0.2607133420531822}, {
              0.29952331784347647`, -0.2343807261062226}, {
              0.3032957184830155, -0.20967420431799774`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.34818138050695197`, 0.5223112750969207, -0.47598133715057644`], 
             
             ArrowBox[{{0.30410341734178986`, -0.20575768729589736`}, {
              0.3086864846261789, -0.18463301975035842`}, {
              0.3153962313255078, -0.1612179293414539}, {
              0.3200622995878123, -0.14679744469933537`}, {
              0.3253058877449481, -0.13267205263502013`}, {
              0.33933872989490366`, -0.10587245732161435`}, {
              0.3559481692888514, -0.07965256067380622}, {
              0.36874213396071176`, -0.06112788520286554}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.35182076439928683`, 0.5223047766533243, -0.4672834080620091], 
             
             ArrowBox[{{0.3710152718678357, -0.05783655658736751}, {
              0.37392048456756244`, -0.05363003235372915}, {
              0.39461855161580006`, -0.02800224068911425}, {
              0.41819880776335727`, -0.002581865628204112}, {
              0.44481769034002727`, 0.022818412880758584`}, {
              0.4746805886095928, 0.04838456575247323}, {0.4834944688775094, 
              0.05524203612668826}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4019987864911991, 0.5224684468974417, -0.33954829728634806`], 
             
             ArrowBox[{{0.4866514905885259, 0.057698296274997125`}, {
              0.5079928918358364, 0.0743025639016392}, {0.5295837484261776, 
              0.08997698468972802}, {0.5525477566723314, 
              0.10586443185012082`}, {0.5769484737578198, 
              0.12201410458616538`}, {0.6028494568661645, 
              0.1384752021012093}, {0.6185446534241739, 
              0.148088240049491}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.4751394491793823, 0.5269590438892372, -0.0221991828503138], 
             
             ArrowBox[{{0.6219556972137649, 0.1501774457036793}, {
              0.630314263180888, 0.15529692359860042`}, {0.6594064498855119, 
              0.17252846828168644`}, {0.6901895741635582, 
              0.19021903535381515`}, {0.7227271931985487, 
              0.20841782401833406`}, {0.7571371279514183, 
              0.22717336207833555`}, {0.7610316921652985, 
              0.2292438679987015}}]}}, {
            Arrowheads[{{0.015237660474078355`, 1.}}], {
             LABColor[
             0.5533490276482668, 0.5320553170926279, 0.3262264392800177], 
             
             ArrowBox[{{0.7645635842565232, 0.23112156293024516`}, {
              0.7935538959299976, 0.24653397075221778`}, {0.832066099138153, 
              0.2665485393662875}, {0.8521356770795301, 
              0.27681633656536353`}, {0.872762339579751, 
              0.28726595724685144`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6656726227759469, 0.48961211049741593`, 0.7439472728304298], 
             
             ArrowBox[{{-0.3262490263913259, -0.9921291608738606}, \
{-0.3513667810504153, -0.9798538377265135}, {-0.37671875370342695`, \
-0.9682880458917428}, {-0.4023049443503607, -0.957431785369548}, \
{-0.42812535299121657`, -0.9472850561599298}, {-0.45425482412971463`, \
-0.937819909758813}, {-0.47404070710754065`, -0.9312442276151373}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.666093731316776, 0.48865185047652937`, 0.7441821916987938], 
             
             ArrowBox[{{-0.4778365675497936, -0.9299827033375511}, \
{-0.48076820226957473`, -0.9290083976621233}, {-0.5076654874107969, \
-0.9208505198698602}, {-0.5349466795533813, -0.9133462763820239}, \
{-0.5626117786973276, -0.9064956671986146}, {-0.590660784842636, \
-0.9002986923196319}, {-0.6190936979893065, -0.894755351745076}, \
{-0.6332066648237967, -0.892360630118393}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6837621310355178, 0.44836233782606677`, 0.7540386540245397], 
             
             ArrowBox[{{-0.637150294987447, -0.8916914656151892}, \
{-0.6479105181373391, -0.8898656454749471}, {-0.6885026059032494, \
-0.8834807773042528}, {-0.7299976972268313, -0.8783358885665029}, \
{-0.7619555515180113, -0.8764471865003407}, {-0.7945046792226701, \
-0.8752098189205272}, {-0.7961001536796456, -0.8751817842876669}}]}}, {
            Arrowheads[{{0.016245684820600535`, 1.}}], {
             LABColor[
             0.7151728954266816, 0.3767359081864827, 0.7715614076849054], 
             
             ArrowBox[{{-0.8000995363182379, -0.8751115097536871}, \
{-0.827722393219015, -0.8746261389924201}, {-0.8615829225476433, \
-0.8746953623275667}, {-0.89546999988563, -0.8747658551502595}, \
{-0.9300529885746163, -0.8754917902112984}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6655940973320955, 0.48979117322600463`, 0.7439034667647275], 
             
             ArrowBox[{{0.3262708056951957, 0.9918860509924539}, {
              0.3513855860416472, 0.9796150900418148}, {0.37673462240931044`, 
              0.9680535545838057}, {0.40231791479818524`, 
              0.9572014446184267}, {0.42813546320827156`, 
              0.9470587601456778}, {0.4542621112052205, 0.9375975614410119}, {
              0.4740690095674345, 0.9310170864872411}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.6660275311636719, 0.4888028076627155, 0.7441452613980639], 
             
             ArrowBox[{{0.4778649956901668, 0.929755940438592}, {
              0.48077270235468295`, 0.9287899087798814}, {0.507667236656659, 
              0.9206358021622867}, {0.5349457141111486, 0.9131352415882275}, {
              0.5626081347181517, 0.906288227057704}, {0.5906544984776684, 
              0.9000947585707159}, {0.6190848053896987, 0.8945548361272635}, {
              0.6332400552573815, 0.8921543614061296}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6837102278746154, 0.4484806933699224, 0.7540096994186805], 
             
             ArrowBox[{{0.6371837507257504, 0.8914855818813482}, {
              0.6478990554542425, 0.8896684597273468}, {0.6884871664620402, 
              0.8832882530821792}, {0.7299783331572608, 0.8781478446156199}, {
              0.7619331386273112, 0.8762621704891855}, {0.7944792339940493, 
              0.8750277343517453}, {0.7961359037878685, 
              0.8749987634856274}}]}}, {
            Arrowheads[{{0.016236535217299276`, 1.}}], {
             LABColor[
             0.7151342880989349, 0.3768239450457575, 0.7715398702690958], 
             
             ArrowBox[{{0.8001352923090022, 0.8749288245335011}, {
              0.8276939301276212, 0.8744468952983491}, {0.8615514567379781, 
              0.8745188669639803}, {0.8954355307374111, 0.8745921100784173}, {
              0.930015529991782, 0.8753207068094937}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.754570106627598, 0.2868978660128863, 0.7935394664860871], 
             
             ArrowBox[{{-0.8764697254305269, 
              0.9575777418358922}, {-0.8752702013991134, 
              0.9240486363812603}, {-0.8746649481152546, 
              0.891167810573947}, {-0.8746539655789507, 
              0.8589352644139523}, {-0.8752372537902015, 
              0.8273509979012759}, {-0.8757176098706985, 
              0.804739859369259}, {-0.8759680555856413, 
              0.7976196543907166}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.7139283665208219, 0.37957382581879157`, 0.7708671369830209], 
             
             ArrowBox[{{-0.876108664420788, 
              0.7936221265102036}, {-0.876502798896263, 
              0.7824168309628893}, {-0.8775928137377456, 
              0.7603899056679005}, {-0.8789876757825944, 
              0.7386351045270914}, {-0.8838749660156847, 
              0.7010210135513697}, {-0.8897788907116113, 
              0.6641657783164635}, {-0.8953751201093961, 
              0.6350191300668762}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6837896958633815, 0.44829948134225345`, 0.7540540312908276], 
             
             ArrowBox[{{-0.896129353544706, 
              0.6310908821209007}, {-0.8967319791068188, 
              0.6279522482235731}, {-0.9047233881224921, 
              0.592419473472298}, {-0.9109941790667473, 
              0.5641221894822247}, {-0.9179448254806661, 
              0.5361767182584765}, {-0.9255753273642485, 
              0.5085830598010532}, {-0.9338856847174943, 
              0.48134121410995495`}, {-0.9356272668918684, 
              0.47613208247618793`}}]}}, {
            Arrowheads[{{0.01291923086486849, 1.}}], {
             LABColor[
             0.6673951304406109, 0.4856842508468115, 0.7449081879202417], 
             
             ArrowBox[{{-0.936895588947634, 
              0.472338487985094}, {-0.9428758975404041, 
              0.4544511811851817}, {-0.9525459658329772, 
              0.4279129610267334}, {-0.9628958895952141, 
              0.40172655363461013`}, {-0.9739256688271145, 
              0.3758919590088118}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000007`, 1.}}], {
             LABColor[
             0.6985787102222082, 0.4145758736254898, 0.7623042047747378], 
             
             ArrowBox[{{0.6345244238102161, -0.9457332223825143}, {
              0.62856806575816, -0.9145887849876847}, {
              0.6231015242355397, -0.8841032548347236}, {
              0.6181247992423551, -0.8542766319236303}, {
              0.613637890778606, -0.8251089162544055}, {
              0.6096407988442927, -0.7966001078270488}, {
              0.6085435179645454, -0.7878870298545614}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.6470429203118769, 0.5295336297675098, 0.7293008179482273], 
             
             ArrowBox[{{0.6080437258999186, -0.7839183766961038}, {
              0.606133523439415, -0.7687502066415604}, {
              0.603116064563973, -0.74155921269794}, {
              0.6005884222179667, -0.715027125996188}, {
              0.5985434856138394, -0.6890693751773268}, {
              0.5969741439640341, -0.6636013888823787}, {
              0.5958803972685511, -0.6386231671113437}, {
              0.5955234478488821, -0.6244823987192111}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.58349659460953, 0.5340197853925465, 0.46053460178178895`], 
             
             ArrowBox[{{0.5954225096983623, -0.6204836724858}, {
              0.5952622455273903, -0.614134709864222}, {
              0.5951196887405513, -0.5901360171410136}, {
              0.5954527269080349, -0.5666270889417184}, {
              0.5962613600298403, -0.5436079252663364}, {
              0.597545588105968, -0.5210785261148676}, {
              0.5993105341695149, -0.49896733885549965`}, {
              0.601561321253578, -0.47720281085642025`}, {
              0.6038498464647394, -0.46088535152464877`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5332551041506168, 0.5307459618208462, 0.23670750908282467`], 
             
             ArrowBox[{{0.6044054094636321, -0.4569241206863535}, {
              0.6075204184832526, -0.4347137326391265}, {
              0.6154228797949923, -0.3936112914629868}, {
              0.6252687051887964, -0.35389548732800064`}, {
              0.6328440619552683, -0.3265685589922096}, {
              0.6408867717600992, -0.301379921006779}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5086586167036724, 0.5291432115909205, 0.12712954422610212`], 
             
             ArrowBox[{{0.6422977424281925, -0.2976411314043438}, {
              0.6505095626205528, -0.2781000318991463}, {
              0.6603516272231743, -0.25668946961247524`}, {
              0.6709606345168668, -0.23549379253850605`}, {
              0.6823229486080182, -0.21453544616435513`}, {
              0.6936999430891091, -0.1935545087859369}, {
              0.705859605147537, -0.1727657200988023}, {
              0.7163652898390308, -0.1560467976489636}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5217494933585388, 0.5299962360568641, 0.18544972612706903`], 
             
             ArrowBox[{{0.71849348923008, -0.1526599455187492}, {
              0.7188019347833029, -0.15216908010295138`}, {
              0.7325269319964061, -0.1317645887983841}, {
              0.7470651040372818, -0.11150682057723574`}, {
              0.7624469581563647, -0.0913503498316415}, {
              0.7786724943536552, -0.07129517656160146}, {
              0.7957417126291527, -0.05134130076711561}, {
              0.8136934337431885, -0.031444457884188474`}, {
              0.8176075935089275, -0.027320616410318535`}}]}}, {
            Arrowheads[{{0.00930921508976011, 1.}}], {
             LABColor[
             0.5641989036960781, 0.5327623140314308, 0.3745629076001947], 
             
             ArrowBox[{{0.820361300653775, -0.02441939305448807}, {
              0.8325664784560929, -0.011560383348824536`}, {
              0.8523608467678662, 0.008310922838976146}, {0.8730765386785079, 
              0.02816946067921352}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6667854573957355, 0.48707449728934005`, 0.7445680767900038], 
             
             ArrowBox[{{-0.6027974726151488, 
              0.8574053789632062}, {-0.597929004060937, 
              0.828444821930849}, {-0.5935342273161391, 
              0.8000867548324132}, {-0.5896131423807554, 
              0.7723311776678989}, {-0.5861657492547856, 
              0.7451780904373063}, {-0.5831920479382299, 
              0.7186274931406351}, {-0.581291486811616, 
              0.6989011824918292}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6060214758326823, 0.5354875461302262, 0.5608835092587815], 
             
             ArrowBox[{{-0.5809078771280242, 
              0.6949196195310493}, {-0.5806920384310883, 
              0.6926793857778857}, {-0.5786657207333606, 
              0.6673337683490574}, {-0.577113094845047, 
              0.642590640854151}, {-0.5760301289046051, 
              0.6183701135696131}, {-0.5754127910504928, 
              0.5945922967718913}, {-0.5752610812827098, 
              0.5712571904609856}, {-0.5755749996012564, 
              0.5483647946368957}, {-0.5760355257885572, 
              0.5351023795583172}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5459195405800032, 0.531571198694317, 0.2931278891465598], 
             
             ArrowBox[{{-0.5761743387548954, 
              0.5311047889138945}, {-0.5763545460061323, 
              0.5259151092996217}, {-0.5775997204973375, 
              0.5039081344491636}, {-0.5814869537387367, 
              0.46122231620869547`}, {-0.5872690090703647, 
              0.42003551143605844`}, {-0.5949781962371326, 
              0.38007589165181976`}, {-0.5968168016393496, 
              0.37268576022896543`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.506032681838565, 0.5289721010728882, 0.1154309389278678], 
             
             ArrowBox[{{-0.5977825301943227, 
              0.3688040894085442}, {-0.6046145152390405, 
              0.34134345685597983`}, {-0.6161779660760882, 
              0.3038382070485382}, {-0.6249159427753358, 
              0.278105149584485}, {-0.6346181288133316, 
              0.2528473981970226}, {-0.6448240016043081, 
              0.2320647633197069}, {-0.6519100058918617, 
              0.21876657765879776`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.49901361504851066`, 0.5285147263792094, 0.08416082136711375], 
             
             ArrowBox[{{-0.6537910439819238, 
              0.21523646495468537`}, {-0.6557707879205469, 
              0.21152111263643839`}, {-0.6675044494212862, 
              0.1911496719491605}, {-0.6800096655534469, 
              0.1709726993238922}, {-0.6925313255983189, 
              0.15077327530187315`}, {-0.7058574281000345, 
              0.13072341654836214`}, {-0.7199879730585944, 
              0.11082312306335929`}, {-0.7349229604739979, 
              0.09107239484686441}, {-0.7421441301973413, 
              0.08207824639993942}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5288089226712313, 0.5304562408432576, 0.2168996597325616], 
             
             ArrowBox[{{-0.7446483729657947, 
              0.07895914906951691}, {-0.7506965168541655, 
              0.07142603379256658}, {-0.7673427687070173, 
              0.05183884179415469}, {-0.7848617160325534, 
              0.03231081885162869}, {-0.8032533588307738, 
              0.012841964964988677`}, {-0.8225606537073914, \
-0.00661215726560212}, {-0.8428265572681193, -0.026095985239980427`}, \
{-0.8546756410385394, -0.03698987495656017}}]}}, {
            Arrowheads[{{0.004787454757107625, 1.}}], {
             LABColor[
             0.5828039762870634, 0.5339746531687695, 0.45744896988568745`], 
             
             ArrowBox[{{-0.8576202648003626, -0.03969712280286214}, \
{-0.8640510695129575, -0.045609518958146224`}, {-0.8862341904419061, \
-0.06515275842009957}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6297648482275089, 0.5370347058881838, 0.6666608252870339], 
             
             ArrowBox[{{0.12003617374486997`, -0.9464063898289757}, {
              0.10337465657699561`, -0.9252204390355345}, {
              0.08681088543472633, -0.9048036893941096}, {
              0.07034486031806211, -0.8851561409047008}, {
              0.053976581227002975`, -0.8662777935673079}, {
              0.037652224391619686`, -0.8481080579410473}, {
              0.021317966041982998`, -0.8305863445850347}, {
              0.015922572735372596`, -0.8250161469915148}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5649396076432727, 0.5328105795987902, 0.3778627621534112], 
             
             ArrowBox[{{0.013139587616950308`, -0.8221429964854258}, {
              0.0049738061780929335`, -0.8137126534992704}, \
{-0.011380255200050492`, -0.7974869846837541}, {-0.02774421809244728, \
-0.7819093381384862}, {-0.04411808249909742, -0.7669797138634664}, \
{-0.07689551585515775, -0.7390645321241716}, {-0.10651824901531244`, \
-0.716199714801636}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5156451967543078, 0.5295984693917225, 0.15825493255273113`], 
             
             ArrowBox[{{-0.10968470615092507`, -0.7137556302678427}, \
{-0.10992769071125211`, -0.7135680784455973}, {-0.14342974251040086`, \
-0.6903169918074719}, {-0.17740167125260414`, -0.6693112722097952}, \
{-0.21184347693786187`, -0.6505509196525673}, {-0.23601270740803768`, \
-0.6382576984094012}, {-0.24749216794647166`, -0.6329769515668229}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4946796565114846, 0.5282323180452271, 0.06485292802319116], 
             
             ArrowBox[{{-0.2511261063211307, -0.6313052781868888}, \
{-0.260514822994708, -0.6269863090363907}, {-0.2817984393256877, \
-0.6194066190008238}, {-0.30341348204525026`, -0.6124959741486324}, \
{-0.3254346117173071, -0.60623946028369}, {-0.3478369414872211, \
-0.6006420488047056}, {-0.3702650004297763, -0.5950402760036606}, \
{-0.3931257178154709, -0.5900888829444524}, {-0.4048162107289417, \
-0.5879302878967895}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5123937859058959, 0.5293866017624069, 0.14376981615346662`], 
             
             ArrowBox[{{-0.40874971841209806`, -0.5872039840302501}, \
{-0.4164190936443051, -0.5857878696270812}, {-0.4401451279162787, \
-0.5821372360515467}, {-0.4643562593831333, -0.5791288763473014}, \
{-0.4891049267966105, -0.576754684643798}, {-0.5143911301567103, \
-0.5750146609410363}, {-0.5402148694634326, -0.5739088052390162}, \
{-0.566633736804213, -0.5734353220579593}, {-0.5679533273612228, \
-0.5734429795170823}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5588766017361255, 0.532415503507837, 0.35085191966411117`], 
             
             ArrowBox[{{-0.5719532600155023, -0.5734661907477421}, \
{-0.5937053242664871, -0.5735924159180867}, {-0.6214296318502551, \
-0.5743800868193988}, {-0.6498066595555165, -0.575798334761895}, \
{-0.689155924348123, -0.5787222779105482}, {-0.7298651482343548, \
-0.5828224018186484}, {-0.7315784599793219, -0.5830369918976712}}]}}, {
            Arrowheads[{{0.010117734245238345`, 1.}}], {
             LABColor[
             0.6223549509901345, 0.5365518639975868, 0.6336495483386334], 
             
             ArrowBox[{{-0.7355474498765218, -0.5835341027464018}, \
{-0.7720254795216023, -0.5881029287566877}, {-0.7936782942866665, \
-0.5911871628214633}, {-0.815728066517256, -0.5945680809951586}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6297268871404775, 0.5370322322772222, 0.6664917076978003], 
             
             ArrowBox[{{-0.12001195988595978`, 
              0.9463317200124526}, {-0.10335111147060021`, 
              0.9251473102110133}, {-0.08678799341276289, 
              0.9047320723418014}, {-0.07032260571244782, 
              0.8850860064048175}, {-0.05395494836965505, 
              0.8662091124000613}, {-0.03763119739243291, 
              0.8480408031150599}, {-0.02129752878882971, 
              0.8305204913373399}, {-0.015895636707542182`, 
              0.8249438437418897}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5649038443798962, 0.5328082492018698, 0.3777034359233593], 
             
             ArrowBox[{{-0.013112584821694797`, 
              0.8220707579094299}, {-0.004953942558845482, 
              0.8136481770669016}, {0.011399561297519777`, 
              0.7974238603037449}, {0.02776298278026603, 
              0.7818475410478697}, {0.04413632188939328, 
              0.7669192192992764}, {0.07691275298679083, 
              0.7390065683239342}, {0.1065495846731688, 
              0.7161324110810896}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5156147040059339, 0.5295964824307968, 0.15811908659842958`], 
             
             ArrowBox[{{0.10971612151164523`, 0.7136884298105861}, {
              0.10994399259094137`, 0.7135125554474263}, {
              0.14344517870307386`, 0.6902638287394605}, {0.1774163113231883, 
              0.6692603882000367}, {0.21185739045128466`, 
              0.6505022338291552}, {0.23602593092011953`, 
              0.6382106222142409}, {0.2475292952923866, 
              0.6329194676958257}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.49466014319547397`, 0.5282310465233567, 0.06476599571382553], 
             
             ArrowBox[{{0.2511633042487359, 0.631247947757215}, {
              0.26052738619653004`, 0.6269407900505244}, {
              0.28181046452551994`, 0.6193623247464204}, {0.3034249883284246, 
              0.6124528706964546}, {0.32544561815771045`, 
              0.6061975169225646}, {0.3478474671625553, 0.6006012337507712}, {
              0.3702750453727373, 0.5950005903264102}, {0.3931353011691524, 
              0.5900502969990102}, {0.40485740283324817`, 
              0.5878863629478963}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.512387619993967, 0.5293861999807793, 0.1437423468620842], 
             
             ArrowBox[{{0.4087909403165333, 0.5871602204910803}, {
              0.4164282345518009, 0.5857503537685717}, {0.4401538455206825, 
              0.5821007606350943}, {0.46436457293359995`, 
              0.5790934138682002}, {0.48911285564835616`, 
              0.5767202097375119}, {0.5143986936649508, 0.574981148243029}, {
              0.540222086983384, 0.5738762293847516}, {0.5666406280907144, 
              0.573403659689731}, {0.5679956383878767, 
              0.5734115674295749}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.5588804912578708, 0.5324157569558906, 0.3508692475804657], 
             
             ArrowBox[{{0.5719955702735516, 0.5734349107361252}, {
              0.5937119094740004, 0.5735616456850183}, {0.6214359311332419, 
              0.5743501873706136}, {0.649812693068439, 0.5757692847465168}, {
              0.6891614202714939, 0.5786943218540861}, {0.729870130906188, 
              0.5827954925379538}, {0.7316202162028845, 
              0.5830147326090626}}]}}, {
            Arrowheads[{{0.01011301577530693, 1.}}], {
             LABColor[
             0.6223643450435026, 0.5365524761305683, 0.6336913990806163], 
             
             ArrowBox[{{0.735589193751157, 0.5835119420431141}, {
              0.772029972830149, 0.5880770218204356}, {0.793682551731113, 
              0.5911617412556305}, {0.8157320939010038, 
              0.5945431347238469}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.7538973851358723, 0.28843188275931386`, 0.7931641832604149], 
             
             ArrowBox[{{0.8807091631513069, -0.9510647325294269}, {
              0.8797101690035416, -0.9176043440325017}, {
              0.8793072888891775, -0.8847867041095785}, {
              0.8795005228082144, -0.852611812760657}, {
              0.8802898707606526, -0.8210796699857372}, {
              0.8809182407835507, -0.7985116144049094}, {
              0.8812286642188851, -0.7911078247486848}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.7137804990976743, 0.37991101008620304`, 0.7707846479229669], 
             
             ArrowBox[{{0.881396227565801, -0.7871113359741766}, {
              0.8818525052256293, -0.7762288334512469}, {
              0.8830926063064881, -0.7542392855842293}, {
              0.8846387173673267, -0.7325190954254184}, {
              0.8897934494979463, -0.6950426896887316}, {
              0.89596427110136, -0.6583128592203158}, {
              0.9018939320133197, -0.6286655730617822}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.684394326609793, 0.4469207329273324, 0.7543913295333319], 
             
             ArrowBox[{{0.9026784224642118, -0.6247432555411754}, {
              0.9031843703023015, -0.622213603245733}, {
              0.9114426843925263, -0.5867835886897961}, {
              0.9179369637347047, -0.5585222783664436}, {
              0.925113776208512, -0.5306072921879653}, {
              0.932973121813948, -0.5030386301543612}, {
              0.9415150005510124, -0.4758162922656311}, {
              0.9434698532552556, -0.4701206827357965}}]}}, {
            Arrowheads[{{0.012893106447130598`, 1.}}], {
             LABColor[
             0.6689255983169291, 0.48219430235992927`, 0.7457619720322061], 
             
             ArrowBox[{{0.9447683822311137, -0.4663373214658598}, {
              0.950739412419706, -0.44894027852177537`}, {
              0.9606463574200284, -0.4224105889227937}, {
              0.971235835551979, -0.39622722346868616`}, {
              0.9825078468155589, -0.37039018215945285`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.32817988020525213`, 0.5223469895544773, -0.5237838324178532], 
             
             ArrowBox[{{-0.08851938824193666, 
              0.30877047400366014`}, {-0.07661021818154506, 
              0.2877333656927554}, {-0.054188576019911394`, 
              0.25088285170702906`}, {-0.033110880153357156`, 
              0.22017970171308673`}, {-0.012858812931429094`, 
              0.1948063428546014}, {0.003250641568397182, 
              0.17841318835693065`}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.26501157695469457`, 0.5224597821775974, -0.6747526333392553], 
             
             ArrowBox[{{0.006054273883656419, 0.17556018190043005`}, {
              0.009919035427989543, 0.17162735890548675`}, {
              0.033029392730694884`, 0.15385390363174722`}, {
              0.05722431481584049, 0.14101075193680926`}, {
              0.08325585752257993, 0.13262267872409936`}, {
              0.09000972203799931, 0.13107879602612238`}, {
              0.09692660073572101, 0.12979449319551173`}, {
              0.10969679819626185`, 0.12876863705017924`}, {
              0.12317295294761126`, 0.1284800951203675}, {
              0.15170486665672256`, 0.12938700333449024`}, {
              0.15348130130154508`, 0.129603159049577}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.2774120227198491, 0.5224376400788907, -0.6451162440154731], 
             
             ArrowBox[{{0.1574520143073553, 0.130086313502614}, {
              0.18374019384193113`, 0.1332850465729167}, {
              0.22001576444768384`, 0.1402595223014883}, {0.2506028944712795, 
              0.1476490210496077}, {0.2844805498395614, 0.157000773902582}, {
              0.313156446651123, 0.16569931547545347`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.3442599029969291, 0.5223182772437586, -0.48535345460606905`], 
             
             ArrowBox[{{0.31698421528477355`, 0.16686043014991128`}, {
              0.32209234428041744`, 0.1684099291148498}, {0.3424371729430256, 
              0.1749157664352308}, {0.36388189152173517`, 
              0.18197163494084959`}, {0.38652164572377007`, 
              0.18961691152794147`}, {0.4104637947921196, 
              0.1978994295125664}, {0.43578211074641815`, 
              0.2068437670562664}, {0.4625503656062998, 0.2164745023205833}, {
              0.46837044645025616`, 0.21860194710100342`}}]}}, {
            Arrowheads[{{0.019853399873202587`, 1.}}], {
             LABColor[
             0.4165724134545819, 0.5231427131966344, -0.2831167872951646], 
             
             ArrowBox[{{0.47212732367438554`, 0.21997521820417937`}, {
              0.4908423313913988, 0.22681621346705907`}, {0.5207317801213495, 
              0.23789347865723567`}, {0.5522924838157861, 
              0.2497308760526551}, {0.5855982144943426, 0.2623529838148591}, {
              0.620808785561892, 0.27582573243291447`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.018851637220087328`, 1.}}], {
             LABColor[
             0.660113443014983, 0.5022887901555045, 0.7408460386072835], 
             
             ArrowBox[{{-0.8527830932619508, -0.5748994005822836}, \
{-0.8918779771104459, -0.5825097379523735}, {-0.9322518332169609, \
-0.590982203811117}, {-0.9629680176739226, -0.5982966359302329}, \
{-0.9944326406331556, -0.6060672116005472}, {-1., -0.6074892891290886}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.018853599259688797`, 1.}}], {
             LABColor[
             0.6604249451897649, 0.5015784671488199, 0.7410198126614707], 
             
             ArrowBox[{{0.8527282157801066, 0.5765697366550302}, {
              0.891861597940182, 0.5841317289372511}, {0.9322734954036106, 
              0.5925581008605156}, {0.963012354971984, 0.5998419382989799}, {
              0.9944993080470738, 0.6075828185505183}, {1., 
              0.608981996582703}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.6714823725172512, 0.47636405241493945`, 0.7471882895811678], 
             
             ArrowBox[{{-0.665870318460845, 
              0.8270038327690554}, {-0.6634549542603817, 
              0.8033783348440674}, {-0.6613565643744842, 
              0.7801693533310304}, {-0.6595776902316389, 
              0.757364935121707}, {-0.6581208732603323, 
              0.7349531271078588}, {-0.6569886548890506, 
              0.7129219761812476}, {-0.6561835765462801, 
              0.6912595292336359}, {-0.6558341704009734, 
              0.667384807428511}}]}}, {
            Arrowheads[{{0.019999999999999993`, 1.}}], {
             LABColor[
             0.6193874266423864, 0.5363584949101948, 0.6204291533781573], 
             
             ArrowBox[{{-0.6557756367374965, 
              0.6633852357251608}, {-0.6555650056602187, 
              0.6489929348424577}, {-0.6562854920300389, 
              0.6080577190684199}, {-0.6583653670836314, 
              0.568358257045618}, {-0.6618249622488873, 
              0.5297989239081482}, {-0.6651903177788796, 
              0.5038195173179216}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5698693348582763, 0.5331318092639756, 0.3998248198124206], 
             
             ArrowBox[{{-0.6657041816966532, 
              0.4998526616520308}, {-0.6666846089536975, 
              0.49228409479010604`}, {-0.6739510762192915, 
              0.45057183153734176`}, {-0.6830431612277514, 
              0.4099559615105991}, {-0.6939608639790775, 
              0.37043648470987783`}, {-0.7025884297206731, 
              0.3444230387099423}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5450270381934038, 0.5315130416746037, 0.2891517687609039], 
             
             ArrowBox[{{-0.7038476145483543, 
              0.34062640157034924`}, {-0.7067041844732698, 
              0.3320134011351784}, {-0.7213478108165547, 
              0.29448211634838745`}, {-0.737966431115159, 
              0.25763803591139206`}, {-0.7565600453690827, 
              0.22148115982419225`}, {-0.7713900490088191, 
              0.19590746248819152`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5524759217018119, 0.5319984239789487, 0.32233673051883016`], 
             
             ArrowBox[{{-0.7733966438622658, 
              0.1924471767927436}, {-0.7771286535783257, 
              0.18601148808678802`}, {-0.7997890002576065, 
              0.15104012170851625`}, {-0.8246578299216429, 
              0.11637816169871372`}, {-0.8379204258729448, 
              0.09916320908198847}, {-0.8517351425704356, 
              0.0820256080573805}, {-0.8661019800141152, 
              0.06496535862488986}, {-0.867541697983036, 
              0.06332646515297594}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5895634490267706, 0.5344151122591624, 0.48756258947951336`], 
             
             ArrowBox[{{-0.8701816165560812, 
              0.060321331224564234`}, {-0.881020938203984, 
              0.04798246078451656}, {-0.9022317194180834, 
              0.024329960122155277`}, {-0.9245847608445964, 
              0.0007395863394179138}, {-0.9457459809457266, \
-0.019174669494526186`}, {-0.9677955904075548, -0.03912484003191373}, \
{-0.9832638980447538, -0.05259906904461774}}]}}, {
            Arrowheads[{{0.0022512731981620517`, 1.}}], {
             LABColor[
             0.6454238192831898, 0.5322902898927431, 0.7268433594547012], 
             
             ArrowBox[{{-0.9862800474988337, -0.055226395151261806`}, \
{-0.9908029267301326, -0.05916621274402592}, {-1., \
-0.06689287104702676}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.7476671780499757, 0.30263871593028707`, 0.7896886109164976], 
             
             ArrowBox[{{-0.8176905199747998, 
              0.9833408210660946}, {-0.8149393106111056, 
              0.9508049025725422}, {-0.8127288397197973, 
              0.9188411174967523}, {-0.8110591073008746, 
              0.8874494658387244}, {-0.8099301133543377, 
              0.8566299475984589}, {-0.8093418578801868, 
              0.8263825627759558}, {-0.8093374088271788, 
              0.8236040464214093}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.7033326774363979, 0.4037353320221203, 0.764956244545764], 
             
             ArrowBox[{{-0.8093310039020508, 
              0.8196040515492958}, {-0.8092943408784214, 
              0.7967073113712145}, {-0.8097875623490418, 
              0.7676041933842356}, {-0.8108215222920481, 
              0.739073208815019}, {-0.8123999717073414, 
              0.7110382092193352}, {-0.8145266615948229, 
              0.6834230461529548}, {-0.8168436489688163, 
              0.6598668335621302}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.6668985118619942, 0.4868166975213343, 0.7446311451552874], 
             
             ArrowBox[{{-0.817242624364361, 
              0.655886855622706}, {-0.8204247627863509, 
              0.6294522296081037}, {-0.8241961740903974, 
              0.6030965761296332}, {-0.8285158258666321, 
              0.5771607591804659}, {-0.8333837181150549, 
              0.551644778760602}, {-0.8387998508356661, 
              0.5265486348700413}, {-0.8447797194020227, 
              0.5018055349057046}, {-0.8456479516519093, 
              0.4985681661485914}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.6429020623635656, 0.5378907497856129, 0.7251874418220666], 
             
             ArrowBox[{{-0.8466840984234809, 
              0.4947046962227654}, {-0.8513388191876817, 
              0.47734868626451243`}, {-0.858477150192643, 
              0.4531780889464647}, {-0.8661947124169069, 
              0.4292937429515614}, {-0.8744915058604732, 
              0.40569564827980265`}, {-0.8833675305233418, 
              0.38238380493118834`}, {-0.8928227864055129, 
              0.35935821290571857`}, {-0.8996367234542919, 
              0.3439170214915974}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6343925818714425, 0.5373362571230034, 0.6872774940571202], 
             
             ArrowBox[{{-0.9012516109581264, 
              0.34025749442516395`}, {-0.9028572735069865, 
              0.33661887220339326`}, {-0.917444087051087, 
              0.3046929233026042}, {-0.9332290041336742, 
              0.27321354068655745`}, {-0.9493053865232952, 
              0.24675390394228758`}, {-0.966330619472172, 
              0.22051078914338976`}, {-0.9796687187456682, 
              0.20120587733928103`}}]}}, {
            Arrowheads[{{0.003837147190293217, 1.}}], {
             LABColor[
             0.6507254928806414, 0.5236962714056742, 0.7356088932920253], 
             
             ArrowBox[{{-0.9819424647117323, 
              0.19791496875929782`}, {-0.9843647029321745, 
              0.19440913976107643`}, {-1., 0.17309255360924863`}}]}}}}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           RGBColor[0.2947336, 0.4054232, 0.5678384000000001]], {{
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.6557283730884366, 0.5122881298292243, 0.7383997912269439], 
             
             ArrowBox[{{-0.3117581929496931, 
              0.9669969380997736}, {-0.29619436879400074`, 
              0.9368203699899611}, {-0.28097584078159826`, 
              0.9077326203476286}, {-0.266085854739105, 
              0.879702577589709}, {-0.2515076564931403, 
              0.8526991301331355}, {-0.23723302768838164`, 
              0.8266894553241747}, {-0.23668624376626174`, 
              0.8257099440988629}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.5810769887309848, 0.5338621196328915, 0.4497551972632272], 
             ArrowBox[{{-0.23473656167882073`, 
              0.8222172746673375}, {-0.22325064603566713`, 
              0.8016413527166081}, {-0.20953910146085736`, 
              0.7775246440386416}, {-0.19607698388981243`, 
              0.7543091510184807}, {-0.1828428832483929, 
              0.7319646953843314}, {-0.169815389462459, 
              0.710461098864399}, {-0.1569730924578711, 
              0.6897681831868894}, {-0.15354040493748394`, 
              0.6843769274029269}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.5034599000359512, 0.5288044541015643, 0.10396913184834285`], 
             
             ArrowBox[{{-0.15139206184099116`, 
              0.6810028168623915}, {-0.14429458216048963`, 
              0.669855770080008}, {-0.13218430061821268`, 
              0.6513313246122929}, {-0.1201785878955322, 
              0.633455000696955}, {-0.09648086890896049, 
              0.5996467175234101}, {-0.07320142520077444, 
              0.5684309205593733}, {-0.05891473450688911, 
              0.5505432789613236}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.4309294017410101, 0.5240782397154817, -0.2191560465067867], 
             
             ArrowBox[{{-0.05641845058962896, 
              0.5474178083400526}, {-0.05034025677097405, 
              0.5398076098048443}, {-0.027697667390717013`, 
              0.5135381716623818}, {-0.005073960831160981, 
              0.489383992534544}, {0.017530862907694067`, 
              0.46734507242133116`}, {0.04011680382584807, 
              0.447421411322743}, {0.05643976259651323, 
              0.4345349577980034}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.3781251993510905, 0.5222578077454191, -0.4044172426081545], 
             
             ArrowBox[{{0.059579302346322145`, 0.43205639164811555`}, {
              0.06288142775327342, 0.4294494693255515}, {0.08602230051994243, 
              0.4132657065165285}, {0.10953942212585517`, 
              0.39887012289567414`}, {0.13343279257101157`, 
              0.38626271846298804`}, {0.1489794421837199, 
              0.37870077919710704`}, {0.1647649959445815, 
              0.3718300861506115}, {0.1958815943628407, 0.362527708159893}, {
              0.20172820157745536`, 0.3612529206668504}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.36898671330281163`, 0.5222741253249596, -0.42625772604607953`], 
             
             ArrowBox[{{0.2056363809580816, 0.3604007857427639}, {
              0.22841484385231792`, 0.3554341959681469}, {
              0.26176469766075616`, 0.34943324028313205`}, {
              0.2967477601071164, 0.3456173976115795}, {0.33358613732086234`, 
              0.3439659048147081}, {0.3643186575097342, 
              0.3443545204322791}}]}}, {
            Arrowheads[{{0.020000000000000004`, 1.}}], {
             LABColor[
             0.4084833617114324, 0.5226555186637214, -0.3179228765586546], 
             
             ArrowBox[{{0.36831833775125783`, 0.344405096766325}, {
              0.3725019354314576, 0.34445799875373667`}, {
              0.41374540607363863`, 0.3471031251125276}, {
              0.43533386295709997`, 0.34923661758078245`}, {
              0.45756680088214174`, 0.3519107295749434}, {
              0.48578631923155774`, 0.35594622663274905`}, {
              0.5151313423814406, 0.360831026358218}, {0.5270678903879309, 
              0.3630750448383738}}]}}, {
            Arrowheads[{{0.02, 1.}}], {
             LABColor[
             0.47704019070642495`, 0.527082899538385, -0.013731331954885692`], 
             
             ArrowBox[{{0.5309990257922969, 0.36381408098941137`}, {
              0.5456790771235929, 0.36657386601764164`}, {0.5775067302498168, 
              0.3731834828773112}, {0.610691508551915, 
              0.38066861420351816`}, {0.6453106188216897, 
              0.38903799726255367`}, {0.6814412678509435, 
              0.39830036932070917`}, {0.6868698098855719, 
              0.39976317739616146`}}]}}, {
            Arrowheads[{{0.019999999999999997`, 1.}}], {
             LABColor[
             0.5532102772244003, 0.5320462758718345, 0.32560830268