(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    236717,       6058]
NotebookOptionsPosition[     72081,       2532]
NotebookOutlinePosition[    210737,       5490]
CellTagsIndexPosition[    210660,       5485]
WindowTitle->32. Sample Final Exam | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Sample Final Exam"
}], "Section",
 CounterAssignments->{{"Section", 31}},
 CellID->587956081,ExpressionUUID->"397cb451-930c-4ad2-b692-df8457d268ee"],

Cell[CellGroupData[{

Cell["Question 1", "Subsection",
 CellID->701465740,ExpressionUUID->"9851b3d4-67c0-4453-a1df-5d75fa401184"],

Cell[TextData[{
 "Calculate the absolute value of the number ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["5", "2"], "-", 
    RowBox[{"2", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"602a5527-3354-4ca0-b27e-a7025d109751"],
 "."
}], "Text",
 CellID->229945384,ExpressionUUID->"476d0780-cbec-48c1-ad29-12fc116b83cd"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->345128362,ExpressionUUID->"ba7e4762-f5e2-4d99-8e5e-3c6a9db93b4f"],

Cell[TextData[{
 "The answer is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["5", "2"], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "2"]}]], "=", 
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["25", "4"], "+", "4"}]], "=", 
     FractionBox[
      SqrtBox["41"], "2"]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f3ed1e9f-f2a0-4e33-a3bc-5a3637362bef"],
 ". Check with ",
 ButtonBox["Abs",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->306695457,ExpressionUUID->"198e0a71-1a1a-4128-bb51-933dba1ea9cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{
   RowBox[{"5", "/", "2"}], "-", 
   RowBox[{"2", "\[ImaginaryI]"}]}], "]"}]], "Input",
 CellID->935080457,ExpressionUUID->"d3f2cc0a-018d-4fe6-9de7-ec4510234029"],

Cell[BoxData[
 FractionBox[
  SqrtBox["41"], "2"]], "Output",
 CellID->8867906,ExpressionUUID->"91ba5a1e-be23-45b5-8c0f-a31ec31884ad"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 2", "Subsection",
 CellID->108565473,ExpressionUUID->"0a84064e-84cc-4d34-b822-55c6e308d51b"],

Cell[TextData[{
 "Find the real part of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
     RowBox[{
      RowBox[{"4", 
       SuperscriptBox["z", "2"]}], "-", "z", "+", "1"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "7c52f959-e3b2-4eee-979c-83918dc8a884"],
 "."
}], "Text",
 CellID->680436152,ExpressionUUID->"5381e30a-f504-494d-b111-887a9e85d186"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->602229183,ExpressionUUID->"f6a80323-f1c5-488c-9b22-bb823ab27d3e"],

Cell[TextData[{
 "One can write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"4", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}], "-", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "+", "1"}], "=", 
     RowBox[{
      RowBox[{"4", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"4", 
       SuperscriptBox["y", "2"]}], "-", "x", "+", "1", "+", 
      RowBox[{"\[ImaginaryI]", "(", 
       RowBox[{
        RowBox[{"8", "x", " ", "y"}], "-", "y"}], ")"}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "4f8cda96-789e-4e9a-a392-7f412ebbd571"]
}], "Text",
 CellID->191430127,ExpressionUUID->"ea3b2d3e-3c5c-42c7-8874-c651ce892abb"],

Cell[TextData[{
 "so the real part is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"4", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"4", 
      SuperscriptBox["y", "2"]}], "-", "x", "+", "1"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a3035524-35c6-41ac-8657-b741e6d2dc80"],
 ". Check with ",
 ButtonBox["ComplexExpand",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->581771998,ExpressionUUID->"4246e317-5308-45ba-87a9-775676b64a79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"ReIm", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", 
      SuperscriptBox["z", "2"]}], "-", "z", "+", "1"}], "/.", 
    RowBox[{"z", "->", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", "*", "y"}]}]}]}], "]"}], "]"}]], "Input",
 CellID->362306368,ExpressionUUID->"843f0cf7-d440-4cad-870f-be92d0e7e524"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", "x", "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "y"}], "+", 
    RowBox[{"8", " ", "x", " ", "y"}]}]}], "}"}]], "Output",
 CellID->104733062,ExpressionUUID->"9105ee03-a3c8-4bba-a766-d51d2ad5c315"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 3", "Subsection",
 CellID->83448002,ExpressionUUID->"c73d4341-31a3-44d3-a08e-63fc1e555e4c"],

Cell[TextData[{
 "Find the Cartesian coordinates of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     RowBox[{"3", "\[Pi]", " ", "\[ImaginaryI]"}], "4"]], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"12f4f81c-bd31-4c4f-a554-97f3271f78ff"],
 "."
}], "Text",
 CellID->31794797,ExpressionUUID->"171a0de9-4a1c-4f6f-a804-2bfa7ef09c3a"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->95407196,ExpressionUUID->"13f64a1b-ea8f-4eca-85f3-2d41c509e755"],

Cell[TextData[{
 "Use Euler\[CloseCurlyQuote]s formula: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      RowBox[{"3", "\[Pi]", " ", "\[ImaginaryI]"}], "4"]], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"cos", "(", 
       RowBox[{
        FractionBox["3", "4"], "\[Pi]"}], ")"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"sin", "(", 
        RowBox[{
         FractionBox["3", "4"], "\[Pi]"}], ")"}]}]}], "=", 
     RowBox[{
      FractionBox[
       SqrtBox["2"], "2"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[ImaginaryI]"}], ")"}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "62cdc170-99c6-4862-9214-f898c16ac84e"],
 ". Check with Wolfram Language:"
}], "Text",
 CellID->170139159,ExpressionUUID->"31ce7aa3-7bfe-4e78-922f-69a735fb71a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{"3", "/", "4"}], "Pi", "*", "\[ImaginaryI]"}], "]"}], "//", 
  "ReIm"}]], "Input",
 CellID->71497430,ExpressionUUID->"b11e5c03-8450-4328-9432-b5b6abd16fc4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["2"]]}], ",", 
   FractionBox["1", 
    SqrtBox["2"]]}], "}"}]], "Output",
 CellID->13571737,ExpressionUUID->"15f436e8-5cfc-4364-9e2e-fef320203f29"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 4", "Subsection",
 CellID->14780930,ExpressionUUID->"b1b164fb-bce3-415a-8a3a-702a950626a2"],

Cell[TextData[{
 "Find the solutions of the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "3"], "=", "9"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1a225b35-5811-4130-bfb6-8e123d9e549b"],
 "."
}], "Text",
 CellID->54291060,ExpressionUUID->"2077081e-8e8d-4cfe-826a-87287afcb7a7"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->57862147,ExpressionUUID->"0583d3f6-62df-437a-bf87-e03967f2da79"],

Cell[TextData[{
 "The solutions are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RadicalBox["9", "3"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ea79fa39-4995-40bc-ae9e-5cad14ead8d0"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "2"], "=", 
    RowBox[{
     RadicalBox["9", "3"], 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], "3"]]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "2267ff86-1f4b-4c1c-bdaf-37036bdae78a"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "3"], "=", 
    RowBox[{
     RadicalBox["9", "3"], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["4", "3"], "\[Pi]", " ", "\[ImaginaryI]"}]]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "43052320-ea3f-491b-abe9-3cf002bb1892"],
 "."
}], "Text",
 CellID->170558200,ExpressionUUID->"34923d83-d9f9-4bd7-a8b5-35b67bb8c9f4"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 5", "Subsection",
 CellID->89605895,ExpressionUUID->"8eb123c7-a229-4ecf-8d06-ecac54d64c87"],

Cell[TextData[{
 "Calculate the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", 
    RowBox[{
     RowBox[{"-", "2"}], "-", 
     RowBox[{"2", "\[ImaginaryI]"}]}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1d28c475-7e09-42b8-952d-a1f190aad2d5"],
 "."
}], "Text",
 CellID->405618000,ExpressionUUID->"6ced36f4-b411-450a-b18e-66473c1d6718"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->544989682,ExpressionUUID->"b209d98d-58f0-41a4-818a-44162c9eeb9a"],

Cell[TextData[{
 "The answer is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"log", "|", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      RowBox[{"2", "\[ImaginaryI]"}]}], "|", 
     RowBox[{
      RowBox[{"+", "\[ImaginaryI]"}], " ", 
      RowBox[{"Abs", "(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}]}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"log", " ", "8"}], "2"], "-", 
     RowBox[{
      FractionBox["3", "4"], "\[Pi]", " ", "\[ImaginaryI]"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "df2fb388-e1ca-482a-a382-9396f0ac2b60"],
 ". Check with Wolfram Language:"
}], "Text",
 CellID->668367796,ExpressionUUID->"e93e73e6-e3e0-48ed-b3ef-81fdca328923"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "-", 
    RowBox[{"2", "\[ImaginaryI]"}]}], "]"}], "//", "ComplexExpand"}]], "Input",\

 CellID->353162876,ExpressionUUID->"aaaddc83-6ceb-4fdf-8a53-10e4ec27fa0f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"3", " ", "\[ImaginaryI]", " ", "\[Pi]"}], "4"]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", "8", "]"}], "2"]}]], "Output",
 CellID->67311233,ExpressionUUID->"256ee494-c316-4114-b9c9-2731c52321d1"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 6", "Subsection",
 CellID->293835027,ExpressionUUID->"a500b116-8651-4dbb-8e61-33cb467fe235"],

Cell[TextData[{
 "Find the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "0"}]], 
    FractionBox[
     RowBox[{"z", "+", "1"}], 
     RowBox[{"z", "-", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"749feebd-195b-478c-9474-7f877f46b716"],
 "."
}], "Text",
 CellID->271891448,ExpressionUUID->"f754ee75-d884-4b68-a349-f09d1f59368c"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->701091331,ExpressionUUID->"437cecfd-4fe5-4915-9520-d156eee05129"],

Cell[TextData[{
 "The limit is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "37935049-7cd0-4a37-86f6-be1dbfcfcbd3"],
 ". Check with ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->206743486,ExpressionUUID->"7c05c52a-af8d-4d3d-86c2-73c64c139435"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", "-", "1"}]], ",", 
   RowBox[{"z", "->", "0"}]}], "]"}]], "Input",
 CellID->823702169,ExpressionUUID->"967da23f-a02e-4dae-b4a1-515c3ddd748c"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellID->319006647,ExpressionUUID->"8777e044-d0b2-413d-a129-886529937898"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 7", "Subsection",
 CellID->436905328,ExpressionUUID->"b177eb6e-92e6-44f3-871b-6ea1aad6cc56"],

Cell[TextData[{
 "Find the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    FractionBox[
     RowBox[{"4", 
      SuperscriptBox["z", "2"]}], 
     RowBox[{"3", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c4765730-db65-4391-8002-4c5145de7e2a"],
 "."
}], "Text",
 CellID->378761218,ExpressionUUID->"d019608c-c8a4-4fa6-a06b-92f4500f04c5"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->438214530,ExpressionUUID->"4845631d-2d64-4712-8a83-bebdf933a1ba"],

Cell[TextData[{
 "The limit is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "/", "3"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "56407b5b-f96c-4731-8261-bc3405e1e36a"],
 " because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     FractionBox[
      RowBox[{"4", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "/", "z"}], ")"}], "2"]}], 
      RowBox[{"3", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "z"}], "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"1", "/", "z"}], "+", "1"}], ")"}]}]]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      FractionBox["4", 
       RowBox[{"3", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["z", "2"]}], ")"}]}]]}], "=", 
     FractionBox["4", "3"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e487fe89-2902-49ab-b887-20bfb86622f5"],
 ". Check with ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->301107725,ExpressionUUID->"b9959212-455a-4cf4-b060-38c2702ba761"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"4", 
     SuperscriptBox["z", "2"]}], 
    RowBox[{"3", 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}]}]], ",", 
   RowBox[{"z", "->", "ComplexInfinity"}]}], "]"}]], "Input",
 CellID->172864316,ExpressionUUID->"32395614-e5e3-42a5-9395-03e2540a03b2"],

Cell[BoxData[
 FractionBox["4", "3"]], "Output",
 CellID->423683524,ExpressionUUID->"72226ded-1aed-433d-bb02-49298e489546"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 8", "Subsection",
 CellID->178921358,ExpressionUUID->"d63621ac-ee26-480c-9dc6-8e9eef2c8c35"],

Cell[TextData[{
 "At which points is the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     SuperscriptBox["z", "2"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1ba3b4de-03e1-48a7-be77-ded24de55025"],
 " not a conformal transformation?"
}], "Text",
 CellID->19735981,ExpressionUUID->"27fbc697-f5e4-46e4-a5a5-45c894c60a84"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->290054477,ExpressionUUID->"2f93aa2d-2071-4670-9d7f-6bf3b04ae158"],

Cell[TextData[{
 "It is not a conformal transformation at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "92e7abf7-1955-43f8-8b23-e01cb810bf26"],
 " because it is not analytic. It is also not a conformal transformation at \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", "2"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5e1d9107-3c6e-4e50-8bdb-4d679beb3b64"],
 " because the derivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "z", ")"}]}], "=", 
    FractionBox[
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "2"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b1ab7f45-f2a0-4a8a-8f05-ba43ebcb0e28"],
 " is zero at those points."
}], "Text",
 CellID->342965823,ExpressionUUID->"8cb4ae81-108d-4a18-a1ff-d677a229506c"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 9", "Subsection",
 CellID->241553394,ExpressionUUID->"f7a0e0c3-8243-41ef-a656-04b25ebf95b9"],

Cell[TextData[{
 "Given ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"3", "x"}], "-", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"57a6229f-2d98-4594-b30d-c19805ad6876"],
 ", find which function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b96b67bb-6c33-46b5-bc93-3f0315da9507"],
 " does not obey the Cauchy\[Dash]Riemann equations with it:"
}], "Text",
 CellID->6018790,ExpressionUUID->"f3c4180b-c2df-45a0-94c1-a72a15e63591"],

Cell[TextData[{
 "A) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "y"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b5dc3039-153f-492a-adb9-61a358a02ce6"]
}], "Text",
 CellID->497547435,ExpressionUUID->"50ca1f2b-8909-40d8-95fe-69363689d466"],

Cell[TextData[{
 "B) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", "y"}], "-", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"96d0de8b-76cb-4cce-b326-593514505f82"]
}], "Text",
 CellID->756936108,ExpressionUUID->"85402af7-088c-4b43-9fa5-6bf434040fec"],

Cell[TextData[{
 "C) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", "y"}], "+", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cdb95b93-7adf-4a43-9a44-8ae3835d6230"]
}], "Text",
 CellID->415029986,ExpressionUUID->"7ad33f1f-7d9c-477f-803e-53c575e8194f"],

Cell[TextData[{
 "D) ",
 Cell[BoxData[
  FormBox[
   FractionBox["y", "3"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2eac4140-4b21-4216-b3e7-bd348ab8aad1"]
}], "Text",
 CellID->13109463,ExpressionUUID->"df21221c-07f1-41dd-9628-d702bc91d27e"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->180192049,ExpressionUUID->"792e839c-4f75-4497-be15-e3b929d10ac6"],

Cell[TextData[{
 "The answer is D, because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "x"], "!=", 
    SubscriptBox["v", "y"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5acdcc66-2890-4fc5-bbc6-46b891531852"],
 "."
}], "Text",
 CellID->701818970,ExpressionUUID->"dd4a7322-8492-4deb-98f0-2e26610828ac"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 10", "Subsection",
 CellID->135089850,ExpressionUUID->"d9ab0d90-b728-4047-aad6-ca3225fc3659"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", "3"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b1a5aae5-caff-4a04-9d80-4fd27a4f489f"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6e37c13a-348d-43e4-9b35-00936fb957f9"],
 " is the line from ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath",ExpressionUUID->
  "521e1986-b2db-4b46-8941-d5d3dec758d9"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"62045731-ac70-48ff-bef8-b13f840bb6c9"],
 "."
}], "Text",
 CellID->425397965,ExpressionUUID->"ad47112f-dd82-4a8c-a86e-e7002d1f1837"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->762731603,ExpressionUUID->"7a6957a5-8b03-4b7e-8ee5-0088a6930379"],

Cell[TextData[{
 "The contour can be parametrized as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"t", "(", 
     RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f7007dc2-299d-400a-966a-c9a8c0bebdce"],
 ", so the integral is:"
}], "Text",
 CellID->96366124,ExpressionUUID->"b5395fbd-822a-4484-a0da-cd9d6975cb74"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "1"], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"[", 
       RowBox[{"\[Rho]", "(", "t", ")"}], "]"}], "3"], 
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}], 
     RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "1"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["t", "3"], "(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], "4"], 
      RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
    RowBox[{"-", "1."}]}]}], TraditionalForm]], "DisplayFormula",
 CellID->5105429,ExpressionUUID->"d20eca6d-2c95-4645-b4b6-f94501359ef4"],

Cell[TextData[{
 "Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->702876376,ExpressionUUID->"553e260f-7656-4860-81d4-b791f602b1ed"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   SuperscriptBox["z", "3"], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], "]"}]], "Input",
 CellID->11100463,ExpressionUUID->"a297c2d2-3836-4242-80cf-0e19271b618e"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellID->321597722,ExpressionUUID->"2c0ab1ca-46a3-45ef-b625-b92ae6f9063f"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 11", "Subsection",
 CellID->278399723,ExpressionUUID->"4c56d352-d438-45c2-8024-6620ac1c9e8b"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"exp", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"322596ac-cae1-4738-8c4c-cd6eea4ed336"],
 " over the contour in the figure."
}], "Text",
 CellID->20514312,ExpressionUUID->"9fd9567e-cefb-42c1-9980-ba851a5681e8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"BSplineCurve", "[", "pts", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "}"}], "]"}], "}"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<\[Pi]\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "12"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]}], "Input",
 CellID->21736800,ExpressionUUID->"bd790c19-0b53-4dfa-a452-7a1c8d0c535a"],

Cell[BoxData[
 GraphicsBox[{
   {Arrowheads[0.08], 
    ArrowBox[BSplineCurveBox[
      NCache[{{0, 0}, {-2, 0}, {1, -2}, {1, 2}, {0, Pi}}, {{0, 0}, {-2, 0}, {
        1, -2}, {1, 2}, {0, 3.141592653589793}}]]]}, 
   PointBox[NCache[{{0, 0}, {0, Pi}}, {{0, 0}, {0, 3.141592653589793}}]], 
   StyleBox[
    InsetBox["\<\"\[Pi]\"\>", NCache[{0, Pi}, {0, 3.141592653589793}], NCache[
     ImageScaled[{Rational[-1, 2], 0}], ImageScaled[{-0.5, 0}]]],
    StripOnInput->False,
    FontSize->12]},
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  ImageSize->Small,
  PlotRange->{{-2, 2}, {-2, 4}}]], "Output",
 CellID->454216506,ExpressionUUID->"c29f14da-7cc4-46e9-ad42-6e8012512027"]
}, {2}]],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->453079999,ExpressionUUID->"36247e09-6fdf-4774-8d9f-d8bf02d772aa"],

Cell[TextData[{
 "Use the fundamental theorem for complex line integral to deduce that the \
answer is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"exp", "(", 
      RowBox[{"\[Pi]", " ", "\[ImaginaryI]"}], ")"}], "-", 
     RowBox[{"exp", "(", "0", ")"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", "1"}], "=", 
     RowBox[{"-", "2"}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "649fdbe2-faa0-4b1e-b658-eaba89930bed"],
 "."
}], "Text",
 CellID->591168569,ExpressionUUID->"ac15991c-1e81-4293-961d-833f2e648879"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 12", "Subsection",
 CellID->441552462,ExpressionUUID->"a9be1522-5c1b-489f-8165-09c113ed9286"],

Cell["\<\
The integral of which of these functions is zero along a circle in the \
complex plane centered at the origin and having radius 2?\
\>", "Text",
 CellID->426008402,ExpressionUUID->"f4c0b9da-e155-40bc-8da0-48d39e4315f0"],

Cell[TextData[{
 "A) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c8445f45-400e-4684-b608-c69c43a8c667"]
}], "Text",
 CellID->24713105,ExpressionUUID->"9d9664ff-b524-4ca5-b4c3-ffffb7221b0d"],

Cell[TextData[{
 "B) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"adb9fcd1-3076-4d30-8d56-f556a913b2fa"]
}], "Text",
 CellID->790172659,ExpressionUUID->"d57a970b-f28c-4c3a-94e7-4e3c2fadbfc8"],

Cell[TextData[{
 "C) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"z", "+", "1"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"53270d5a-744a-482d-8b8e-978ffcac5552"]
}], "Text",
 InitializationCell->True,
 CellID->432551159,ExpressionUUID->"c74dc53f-dafb-4e8f-8e0e-b2eb0a39f8dd"],

Cell[TextData[{
 "D) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"z", "+", "3"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"afb6eb1e-6d72-4da3-8791-4b1a193ec972"]
}], "Text",
 CellID->196626408,ExpressionUUID->"b5b7aaac-71e3-47c0-92ed-f8f4ce3de395"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->32032195,ExpressionUUID->"3e39e963-ff7c-45d9-a72e-c8d2c68d3b16"],

Cell["\<\
The answer is D, because the function is analytic in an open neighborhood \
containing the circle.\
\>", "Text",
 CellID->132670541,ExpressionUUID->"381d5dcc-7384-4fbe-9046-55a876e4a11e"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 13", "Subsection",
 CellID->29468958,ExpressionUUID->"eac31358-15cc-43db-ab1e-85e405605eef"],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "2"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "z"], "+", 
       FractionBox["1", 
        RowBox[{"z", "-", "1"}]]}], ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5d958627-6566-4a46-80f0-f98bec11b404"],
 "."
}], "Text",
 CellID->235071694,ExpressionUUID->"5e3bf1a0-945a-40f3-a084-77570a126634"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->661484380,ExpressionUUID->"87d97429-cd35-4fa0-a16e-7a0ef503e6e4"],

Cell[TextData[{
 "The answer is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0c68dff5-f65c-4154-809a-fbc58faa8855"],
 " as can be deduced, for example, by deforming the contour into two small \
circles surrounding the singularities."
}], "Text",
 CellID->9956720,ExpressionUUID->"b1ca86c6-98f0-44fb-b3ff-5e3b78f6904a"],

Cell[TextData[{
 "Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->764918667,ExpressionUUID->"8a6ccaaf-65e8-4ee0-8347-92784df56b05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "z"], "+", 
    FractionBox["1", 
     RowBox[{"z", "-", "1"}]]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], "]"}]], "Input",\

 CellID->8567869,ExpressionUUID->"61fcab89-995a-4cf3-9a1a-1bdba1640214"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "Output",
 CellID->12522303,ExpressionUUID->"0a40de8e-7d82-4dc4-b7fa-41774dab0de3"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 14", "Subsection",
 CellID->973330725,ExpressionUUID->"dd711d9d-a188-4b78-bcb8-fb0480bd02da"],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{"sin", " ", "z"}], 
      SuperscriptBox["z", "2"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0f77c078-602a-46ab-82eb-52f5821b739f"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "20947b06-6533-4b8b-87b5-dd092d9a32e7"],
 " is a closed curve surrounding the origin."
}], "Text",
 CellID->96568439,ExpressionUUID->"0ad73ee9-703e-4a08-977e-7d09ad2b7607"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->177964512,ExpressionUUID->"ae0eb682-26a0-4dd1-bf13-7db2d65df2b6"],

Cell[TextData[{
 "Using Cauchy\[CloseCurlyQuote]s integral formula, the result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "\[Pi]", " ", 
     RowBox[{"\[ImaginaryI]", "\[CenterDot]", 
      RowBox[{"cos", "(", "0", ")"}]}]}], "=", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a21f298a-3b1b-492e-a29d-0f85f884a696"],
 "."
}], "Text",
 CellID->448987867,ExpressionUUID->"855b199b-c59a-48f9-9919-64d7f25c0b51"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 15", "Subsection",
 CellID->65965701,ExpressionUUID->"ed28d64d-27d8-4f35-b407-7d3f3ddef37a"],

Cell[TextData[{
 "In which of these open regions can the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    SuperscriptBox["z", "3"], "|"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4d98f173-8be0-414d-8914-99f42ab6fd01"],
 " have a minimum?"
}], "Text",
 CellID->28769971,ExpressionUUID->"79cecc12-3314-4957-97f3-f8b618423980"],

Cell[TextData[{
 "A) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "<"}], " ", "|", "z", "|", 
    RowBox[{"<", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "809ffe1e-9ca4-45e1-aaf2-3f2e232df4a5"]
}], "Text",
 CellID->36439273,ExpressionUUID->"761f3338-3290-4484-960a-f3a70abbda7d"],

Cell[TextData[{
 "B) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bd2cbd65-83fd-4ef3-8d04-d2cd98cd5ecc"]
}], "Text",
 CellID->216575354,ExpressionUUID->"0fb1a7a6-720f-4ace-b0f9-513beedc88a8"],

Cell[TextData[{
 "C) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", "2"}], "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dcbf8f16-5247-47ab-b4e6-71856a524849"]
}], "Text",
 CellID->210904032,ExpressionUUID->"1394ea91-cac1-476f-bc31-1b2b73d7a867"],

Cell[TextData[{
 "D) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7e0e0c71-c141-48d4-bb98-4fc303995162"]
}], "Text",
 CellID->271815648,ExpressionUUID->"339f27ce-77e2-4ec3-b7dd-dbf9984e2e1b"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->701330768,ExpressionUUID->"c0ebef62-4307-4ace-a2bb-8e87ea8b162c"],

Cell["\<\
The absolute value of an analytic function obeys the minimum value theorem. \
It cannot have a minimum in an open region, except if the function takes the \
value zero in the region. So B is the only possible correct answer. \
\>", "Text",
 CellID->44007503,ExpressionUUID->"fb62a47e-0750-4bff-a984-9e9d1ef11d96"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 16", "Subsection",
 CellID->851453876,ExpressionUUID->"6cbfc641-ee89-4617-9337-e3d0ff027cce"],

Cell["Which of these functions is harmonic?", "Text",
 CellID->229151912,ExpressionUUID->"b35a25a0-f2ed-4f4c-9209-0d5682a72d9c"],

Cell[TextData[{
 "A) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["y", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1d6d6fab-95ce-40df-a97b-d0fcc0f371c7"]
}], "Text",
 CellID->11827812,ExpressionUUID->"6f73fed7-8cc7-4b2f-9d2c-148f492a50ab"],

Cell[TextData[{
 "B) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", 
    RowBox[{"x", "-", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"21076c1f-7b7e-476b-887a-f85f0e61c240"]
}], "Text",
 CellID->145066444,ExpressionUUID->"9944f15c-ad5d-4bc1-a884-bf8684ed0f9a"],

Cell[TextData[{
 "C) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    SuperscriptBox["y", "3"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ea2a4b4c-afef-4671-91fa-712204f72908"]
}], "Text",
 CellID->445605434,ExpressionUUID->"561748b3-0223-4e20-9306-4e2a7c73c5d0"],

Cell[TextData[{
 "D) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "3"], "-", "y"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1efd8382-b19c-4421-b5b7-37fc4fd00f37"]
}], "Text",
 CellID->188186560,ExpressionUUID->"917ca7ea-4f30-4717-9420-f1933b5b3139"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->533059042,ExpressionUUID->"89c205ab-6dec-4a0c-8f04-0ff972c43046"],

Cell["The answer is A, because:", "Text",
 CellID->5486397,ExpressionUUID->"e20e35c8-55f0-4ba1-91d8-2afa57250edb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellID->248631961,ExpressionUUID->"447771b5-d229-4b22-8a50-62f55c94fc55"],

Cell[BoxData["0"], "Output",
 CellID->122040834,ExpressionUUID->"7aa0f7b6-a0a2-4a16-bfa4-3feca966b9d1"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 17", "Subsection",
 CellID->63472839,ExpressionUUID->"3f4f2a4b-2bf4-4513-b07e-847dea53e3fc"],

Cell[TextData[{
 "Which of these functions satisfies the mean-value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"0", ",", "0"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4ddcbcc7-71f7-4035-b347-5951bdbb5659"],
 "?"
}], "Text",
 CellTags->"QuestionText",
 CellID->332403458,ExpressionUUID->"6450f425-7ac4-49e2-a775-9446af6f1a2e"],

Cell[TextData[{
 "A) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"2", 
     SuperscriptBox["y", "2"]}], "+", "x"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9d9c8f97-6f36-4482-ac25-1463645c96a5"]
}], "Text",
 CellID->211081748,ExpressionUUID->"e4233483-c5e8-43bb-b4fc-022ae21e064d"],

Cell[TextData[{
 "B) ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    RowBox[{"x", " ", "y"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "cc0984ca-a5dd-48e3-95e6-7532e3030437"]
}], "Text",
 CellID->182051195,ExpressionUUID->"3513e800-1ce5-4cc8-8b62-f44c2e76e5d8"],

Cell[TextData[{
 "C) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", 
    RowBox[{"x", "+", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a86e6cb4-83aa-465a-801f-5f21dc37352b"]
}], "Text",
 CellID->259155977,ExpressionUUID->"0af718b9-1e66-4746-9502-613f38a5b451"],

Cell[TextData[{
 "D) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    SuperscriptBox["y", "3"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bf00c111-bf13-4b4d-887f-01ff5cffc50a"]
}], "Text",
 CellID->147459708,ExpressionUUID->"17395664-bc82-445b-8ed7-541dce7bb9a4"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->521673994,ExpressionUUID->"ec9d6087-dcf3-4839-8b6b-c6c6a1c72f02"],

Cell["The answer is A, because it is a harmonic function.", "Text",
 CellID->305164189,ExpressionUUID->"e4adb5ab-f43e-4c61-8a5a-94c9fdee491e"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 18", "Subsection",
 CellID->595401235,ExpressionUUID->"22232011-2a52-4be3-83e6-a015c37c2515"],

Cell[TextData[{
 "Find the radius of convergence of the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "z"}], ")"}], "n"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f82d72f4-fab2-4e64-98aa-e67997aa8ba9"],
 "."
}], "Text",
 CellID->7500439,ExpressionUUID->"7bad8719-055c-4e1e-86cb-719cde809265"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->65811520,ExpressionUUID->"2a97c9b9-e3d4-4687-a9bb-e168eb9cc951"],

Cell[TextData[{
 "Using the ratio test, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"2", "z"}], ")"}], 
         RowBox[{"n", "+", "1"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"2", "z"}], ")"}], "n"]], "|"}]}], "=", 
     RowBox[{"2", "|", "z", "|"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e5c01adf-e0bd-49b4-9475-9680fb0254fd"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "<", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1b73be6d-1e4f-42b6-a501-54bf62f180cb"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", 
     RowBox[{"1", "/", "2"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3a559a58-75f3-471e-a475-24a5bea64bf1"],
 ". From this one finds that the radius of convergence is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d7c05543-37be-4632-a0ac-869c5683470d"],
 ". Check with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->171718772,ExpressionUUID->"8ea3824a-1f95-4cae-a925-1013d0d11b14"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "z"}], ")"}], "^", "n"}], ",", "n"}], "]"}]], "Input",
 CellID->2682673,ExpressionUUID->"a80fc95c-b3a1-462c-b4d0-88576318a62a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", "z", "]"}], "<", 
  FractionBox["1", "2"]}]], "Output",
 CellID->46118051,ExpressionUUID->"da9960b6-a46e-4a6d-9ae2-edce9338d55e"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 19", "Subsection",
 CellID->324823373,ExpressionUUID->"4fca6a80-13fc-48d7-b718-a276a247a6cb"],

Cell[TextData[{
 "Find the first three terms in the Taylor expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"exp", "(", "z", ")"}], 
     RowBox[{"z", "-", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"610a9b20-6878-47a6-9ee7-6d6c8112ab3b"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e5ec477c-3a0b-496d-90f9-3faa986fc1ff"],
 "."
}], "Text",
 CellID->331767475,ExpressionUUID->"bce9b4de-ab8b-42b9-a78a-18e9511dd149"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->71531695,ExpressionUUID->"8868639b-9cb2-4eb8-886b-ccafc7f342f7"],

Cell[TextData[{
 "The first term is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "0", ")"}], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "84c4f6d6-3704-427e-bb78-917a38e7f9ce"],
 ". The second term is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"z", "\[CenterDot]", 
      RowBox[{"f", "'"}]}], 
     RowBox[{"(", "0", ")"}]}], "=", 
    RowBox[{
     RowBox[{"-", "2"}], "z"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"42a42297-8679-4b97-96fe-b637eb6099d5"],
 ". The third is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["z", "2"], "\[CenterDot]", 
     FractionBox[
      RowBox[{
       RowBox[{"f", "''"}], 
       RowBox[{"(", "0", ")"}]}], "2"]}], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], 
     SuperscriptBox["z", "2"]}]}], TraditionalForm]],ExpressionUUID->
  "a0c35a81-8b7e-4add-8e86-4eb77c7e18f5"],
 "."
}], "Text",
 CellID->146440356,ExpressionUUID->"46c03ba4-09a1-4764-87eb-4e23814b4359"],

Cell[TextData[{
 "Check with ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->186270951,ExpressionUUID->"dd3c7ad6-b3d9-4254-b826-f6f42bf0117f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellID->295315,ExpressionUUID->"7ff0949a-2e79-415f-b09c-e85ee96e4825"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "z"}], "-", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["z", "2"]}], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {-1, -2, 
    Rational[-5, 2]}, 0, 3, 1],
  Editable->False]], "Output",
 CellID->478669734,ExpressionUUID->"79e4db79-3227-4abc-8dac-075c52c20a3f"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 20", "Subsection",
 CellID->24594851,ExpressionUUID->"10ccafc0-384f-4097-ac8c-c99913625b86"],

Cell[TextData[{
 "Find the first three terms of the Laurent expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox["z", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "2"}], ")"}], "2"]}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"3160bd65-e3ce-4c46-a571-74f0511daf08"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "662f8705-f303-49fc-9792-203576cad080"],
 "."
}], "Text",
 CellID->45392781,ExpressionUUID->"5ef7ff6d-4973-4253-87ee-9c55bc4998cb"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->358510001,ExpressionUUID->"9ac7ff0c-c436-47c3-829c-0e708cec4d7e"],

Cell[TextData[{
 "Find the answer with ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->449548470,ExpressionUUID->"661faf1a-4eda-4b2b-aff2-95ad36dbe6ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox["z", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellID->166911674,ExpressionUUID->"a63f6998-2eb2-4d51-ba2c-1af5a0c574fe"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "-", "1"}]], "+", "3", "+", 
   RowBox[{"5", " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "2"],
    SeriesData[$CellContext`z, 1, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {1, 3, 5}, -1, 2, 1],
  Editable->False]], "Output",
 CellID->350856828,ExpressionUUID->"7d37868d-0f32-472a-aaa5-40aefaba778c"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 21", "Subsection",
 CellID->70365291,ExpressionUUID->"a84fec23-600e-4755-af6a-381fb3a448f3"],

Cell[TextData[{
 "Find the order of the pole at infinity of the function ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SuperscriptBox["z", "3"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"65da4da1-2e39-42e3-8420-edce69245c21"],
 "."
}], "Text",
 CellID->71178080,ExpressionUUID->"2faa3b51-3c1e-4faa-928c-e07aad131751"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->319738746,ExpressionUUID->"c4ba26f1-87cb-4740-86fa-123da37c6400"],

Cell[TextData[{
 "Consider ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"1", "/", "z"}], ")"}], "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "/", "z"}], ")"}], "3"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"1", "/", "z"}], "-", "1"}], ")"}], "2"]], "=", 
      FractionBox["1", 
       SuperscriptBox[
        RowBox[{"z", "(", 
         RowBox[{"z", "-", "1"}], ")"}], "2"]]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"35ef2e76-a15b-4581-be39-17eebeee8c22"],
 ". Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7fba339a-cb13-45ed-938b-fdb85816d3c9"],
 " has a simple pole at the origin, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7cc011ea-ddab-4ac8-86f7-09ae0f27d2a3"],
 " has a simple pole at infinity."
}], "Text",
 CellID->179131595,ExpressionUUID->"f49b3051-0a1d-4200-b771-bfa613b0bee1"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 22", "Subsection",
 CellID->382567890,ExpressionUUID->"4812e8ff-b2e0-4493-bc92-4411ec98929e"],

Cell[TextData[{
 "Calculate the residue at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "213ce511-b5e0-4aa3-98a3-0074bb20906c"],
 " of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"3", "z"}], "+", "1"}], 
     SuperscriptBox["z", "2"]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f0db8508-ac26-4a98-b4bd-d4c97d819341"],
 "."
}], "Text",
 CellID->742849510,ExpressionUUID->"6907f4c2-fc02-4864-a755-e8c2891907ef"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->42610947,ExpressionUUID->"8ad88e20-ee30-43e4-96c6-1435b55a4ab1"],

Cell[TextData[{
 "The residue is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "0"}]], 
     FractionBox[
      RowBox[{
       RowBox[{"3", "z"}], "+", "1"}], 
      SuperscriptBox["z", "2"]]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "0"}]], 
      RowBox[{
       FractionBox["d", 
        RowBox[{"d", " ", "z"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "z"}], "+", "1"}], ")"}]}]}], "=", "3"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "6acaf54c-44a8-4f36-af78-c663e1453c16"],
 "."
}], "Text",
 CellID->148354345,ExpressionUUID->"079b1cb4-208e-41ba-afea-89d6eb526882"],

Cell[TextData[{
 "Check with ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->314401147,ExpressionUUID->"e4c756fd-28cc-47fb-9fda-7f12240bde4b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"3", "z"}], "+", "1"}], 
    SuperscriptBox["z", "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellID->9460561,ExpressionUUID->"f79cde52-d23f-4cca-8a6a-057e0c190e0f"],

Cell[BoxData["3"], "Output",
 CellID->821109254,ExpressionUUID->"f487916a-f740-44ed-aca3-0bce4fec3577"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 23", "Subsection",
 CellID->77878008,ExpressionUUID->"cceff9e5-3ca4-421e-9884-0979aa7dd11b"],

Cell[TextData[{
 "Compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"2", "z"}], "+", "1"}], 
     RowBox[{"z", "(", 
      RowBox[{
       RowBox[{"2", "z"}], "-", "1"}], ")"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8d748f7c-35ec-4e37-a5b7-b3194052bc41"],
 " over the contour in the figure."
}], "Text",
 CellID->435381204,ExpressionUUID->"84447040-2078-462a-94ed-36fca2d3f70d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"BSplineCurve", "[", 
        RowBox[{"pts", ",", 
         RowBox[{"SplineClosed", "->", "True"}]}], "]"}]}]}], "}"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"3", "/", "2"}]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]}], "Input",
 CellID->32572864,ExpressionUUID->"7114cbe2-1edf-4a3e-9925-c5fd1d3a0166"],

Cell[BoxData[
 GraphicsBox[
  {Arrowheads[0.08], 
   ArrowBox[BSplineCurveBox[
     NCache[{{-1, 0}, {Rational[1, 4], -1}, {2, 0}, {2, 1}, {1, 1}}, {{-1, 
       0}, {0.25, -1}, {2, 0}, {2, 1}, {1, 1}}],
     SplineClosed->True]]},
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  ImageSize->Small,
  PlotRange->NCache[{{
      Rational[-1, 2], 2}, {-1, 
      Rational[3, 2]}}, {{-0.5, 2}, {-1, 1.5}}]]], "Output",
 CellID->221532883,ExpressionUUID->"5885afc8-3b6c-4fe9-b7bb-ec95f0315c45"]
}, {2}]],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->34808795,ExpressionUUID->"d05a2261-e762-4019-869b-074bddfae290"],

Cell[TextData[{
 "The poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", 
    RowBox[{"1", "/", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2e0b8879-c01e-4621-a0ed-e931bb81e589"],
 " are inside the curve. The residues at those poles are ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "0"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6a678f3c-5752-48f3-8df6-83b586650019"],
 ":"
}], "Text",
 CellID->61640621,ExpressionUUID->"a3334cf1-f01b-48bc-8f66-fba4697e1bff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "z"}], "+", "1"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "z"}], "-", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellID->463647224,ExpressionUUID->"0042dceb-dbc8-4040-8531-8edfc603ae38"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellID->53558687,ExpressionUUID->"380fc4a6-839e-4316-bd82-4438f9397de7"]
}, Open  ]],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", 
       RowBox[{"1", "/", "2"}]}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", "2"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9505fb4e-8231-4181-ae5e-8034d9cf12ee"],
 ":"
}], "Text",
 CellID->59784013,ExpressionUUID->"ac08e70c-0137-45d8-8df4-b3bf10b34fdd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Residue", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "z"}], "+", "1"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "z"}], "-", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellID->154565020,ExpressionUUID->"25de9a3a-f8a8-4f6b-84e3-8657eaa7f63c"],

Cell[BoxData["2"], "Output",
 CellID->81225068,ExpressionUUID->"0f4394c1-bf4d-4f0d-9b25-ae05bb371142"]
}, Open  ]],

Cell[TextData[{
 "So the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "\[Pi]", " ", 
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "2"}], ")"}]}], "=", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a22d925a-20c1-4e26-a362-e8e0109662a9"],
 "."
}], "Text",
 CellID->965625417,ExpressionUUID->"f74352cf-a0e5-45a5-8f83-8bbb97965983"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 24", "Subsection",
 CellID->132401314,ExpressionUUID->"3a671c32-d5c5-42dd-aa5b-909791aef466"],

Cell[TextData[{
 "How many solutions does the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"2", 
      RowBox[{"sin", "(", "z", ")"}]}]}], "=", "1"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"1b36a2cd-e812-4bf2-bb2c-5c68df624872"],
 " have in the unit circle?"
}], "Text",
 CellID->86448612,ExpressionUUID->"d4af7009-158e-4fec-a6bc-44004ea37f53"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->78916208,ExpressionUUID->"2dd4309e-61fc-4599-bedb-153d3668482e"],

Cell[TextData[{
 "To use the argument principle, we consider ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"3", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"2", 
      RowBox[{"sin", "(", "z", ")"}]}], "-", "1"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"af100310-2c0b-43d6-a04e-6986ac3e8cec"],
 " and compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "1"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"f", "'"}], 
       RowBox[{"(", "z", ")"}]}], 
      RowBox[{"f", "(", "z", ")"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"18e63982-b81c-4aa3-b52e-e631ca7b0c42"],
 ":"
}], "Text",
 CellID->27219095,ExpressionUUID->"ac30798e-22bd-48c6-a9bc-70bce7885859"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "z", "]"}]}], "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"f", ",", "z"}], "]"}], "/", "f"}], ")"}], "//", 
  "Simplify"}]}], "Input",
 CellID->394407033,ExpressionUUID->"52708902-adbf-4eb9-a295-db9eba76d59e"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", "z"}], "+", 
     RowBox[{"Cos", "[", "z", "]"}]}], ")"}]}], 
  RowBox[{"1", "-", 
   RowBox[{"3", " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"Sin", "[", "z", "]"}]}]}]]], "Output",
 CellID->718011873,ExpressionUUID->"515aac0c-e2bf-468d-bfbd-3f203aa9f92d"]
}, Open  ]],

Cell["The number of solutions is", "Text",
 CellID->565463428,ExpressionUUID->"83a5b7fb-76b2-4102-b6ac-1aa8367aed73"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], "*", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"f", ",", "z"}], "]"}], "/", "f"}], ")"}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", "]"}]}]}], "]"}]}]], "Input",
 CellID->531725718,ExpressionUUID->"a208ebbb-b469-4db5-af18-f4488b66b661"],

Cell[BoxData["2"], "Output",
 CellID->18138512,ExpressionUUID->"c9b82207-e051-4d4a-aa96-4051c4885feb"]
}, Open  ]],

Cell[TextData[{
 "Check using ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->155074021,ExpressionUUID->"38aed967-689a-4b4a-a2c0-db45fca84aab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"2", 
       RowBox[{"Sin", "[", "z", "]"}]}]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}], ",", "z"}], "]"}]], "Input",\

 CellID->68632041,ExpressionUUID->"8be2e5a8-cd77-4b2c-b043-0cba540c7afa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      InterpretationBox[
       StyleBox[
        TemplateBox[{"\"-0.336\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        ShowStringCharacters -> 
        False], -0.33648270192335283379492238964303396642`15.954589770191003, 
       Editable -> False], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 RowBox[{"2", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}], "+", 
                 RowBox[{"3", " ", 
                   SuperscriptBox["#1", "2"]}]}], "&"}], ",", 
             RowBox[{"-", "0.3364827017195534714`6.900514997831991"}]}], 
           "}"}], "]"}], Short[#, 7]& ], -0.33648270192335283`},
     "NumericalApproximation"],
    Root[{-1 - 2 Sin[#] + 
      3 #^2& , -0.3364827017195534714`6.900514997831991}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      InterpretationBox[
       StyleBox[
        TemplateBox[{"\"0.932\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        ShowStringCharacters -> False], 
       0.93194453919657482821037319808965548873`15.954589770191003, Editable -> 
       False], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "1"}], "-", 
                 RowBox[{"2", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}], "+", 
                 RowBox[{"3", " ", 
                   SuperscriptBox["#1", "2"]}]}], "&"}], ",", 
             "0.93194453919657478207875690311933353932`13.90051499783199"}], 
           "}"}], "]"}], Short[#, 7]& ], 0.9319445391965748},
     "NumericalApproximation"],
    Root[{-1 - 2 Sin[#] + 3 #^2& , 
      0.93194453919657478207875690311933353932`13.90051499783199}]]}]}]], \
"Output",
 CellID->1875257839,ExpressionUUID->"03b3e70c-0482-40fa-b2ec-3085927c7f10"]
}, Open  ]],

Cell["Numerically, the solutions are", "Text",
 CellID->623805788,ExpressionUUID->"103a6aea-7257-4fae-992c-967c8b1af6ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellID->586183936,ExpressionUUID->"e7603d7a-20f7-4f59-a522-90516262fb51"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   RowBox[{"-", "0.33648270192335283`"}]}], "||", 
  RowBox[{"z", "\[Equal]", "0.9319445391965748`"}]}]], "Output",
 CellID->130852270,ExpressionUUID->"6c3c858d-b84a-4678-9b91-ece7c669421c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellID->445427444,ExpressionUUID->"29964cfa-4518-4310-a8bc-bade60bb83b1"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 25", "Subsection",
 CellID->658311913,ExpressionUUID->"f8dde7d6-9154-41cd-8f40-d174a2c76a74"],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"exp", "(", 
       RowBox[{"\[ImaginaryI]", " ", "x"}], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "\[ImaginaryI]"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6d5b42bc-74ac-4eaa-9c90-5922ed0b396b"],
 "."
}], "Text",
 CellID->118634228,ExpressionUUID->"2cb0df68-b97f-4930-bd23-61e126920965"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->25969986,ExpressionUUID->"b7b44bea-0663-4b01-8102-fa8bcc2f036d"],

Cell[TextData[{
 "Use Jordan\[CloseCurlyQuote]s lemma and close the contour in the upper \
half-plane. The answer is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     SubscriptBox["Res", 
      RowBox[{"z", "->", 
       RowBox[{"2", "\[ImaginaryI]"}]}]], 
     FractionBox[
      RowBox[{"exp", "(", 
       RowBox[{"\[ImaginaryI]", " ", "x"}], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "\[ImaginaryI]"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}]]}], "=", 
    FractionBox[
     RowBox[{"2", "\[Pi]"}], 
     RowBox[{"3", 
      SuperscriptBox["\[ExponentialE]", "2"]}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"30725581-6f36-4a6d-bffd-716e332bd3f4"],
 "."
}], "Text",
 CellID->281752392,ExpressionUUID->"a8377942-f89b-48d5-97d2-930ea0059740"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"Residue", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Exp", "[", 
      RowBox[{"\[ImaginaryI]", " ", "x"}], "]"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "\[ImaginaryI]"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"2", "I"}]}], "}"}]}], "]"}]}]], "Input",
 CellID->63536575,ExpressionUUID->"20486c89-b6ce-4280-92a3-793f36aff9c2"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "2"]}]]], "Output",
 CellID->369591741,ExpressionUUID->"20c19221-1055-445e-afdb-fb740a8254d9"]
}, Open  ]],

Cell[TextData[{
 "Check with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->428647634,ExpressionUUID->"7de7d59a-bbc4-485b-bbcd-5456631fef55"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Exp", "[", 
     RowBox[{"\[ImaginaryI]", " ", "x"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "\[ImaginaryI]"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"2", "\[ImaginaryI]"}]}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellID->139269512,ExpressionUUID->"80b4f05b-ad01-4156-8cea-52608345b609"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "2"]}]]], "Output",
 CellID->763469224,ExpressionUUID->"c8f7db58-457e-4c17-bf91-8f18f996602c"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 26", "Subsection",
 CellID->292611051,ExpressionUUID->"81b67e49-c1d6-4d45-8c63-36d2d64790e9"],

Cell[TextData[{
 "What type of singularity (if any) is the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "3"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "abe1a32b-c4c2-4622-b99d-900a54580a63"],
 " for the Gamma function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a346c3e5-19e6-4b2e-b6f5-67439ccb1fe9"],
 " ?"
}], "Text",
 CellTags->"QuestionText",
 CellID->839495662,ExpressionUUID->"df866534-b5b1-4314-bf60-46e78d90aee0"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->807223007,ExpressionUUID->"608d381f-19ea-4239-aff6-3fb44832b469"],

Cell["It is a simple pole.", "Text",
 CellID->320770277,ExpressionUUID->"ee44e922-5680-4613-9901-48ff392f856d"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 27", "Subsection",
 CellID->37741075,ExpressionUUID->"7f26de08-7d80-4bff-97cb-62dfe5afb96c"],

Cell[TextData[{
 "Calculate the inverse Laplace transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "s", ")"}], "=", 
    FractionBox["3", 
     SuperscriptBox["s", "3"]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"05fe528b-f5e8-46ba-a6e9-e2dd1ebc8fe0"],
 "."
}], "Text",
 CellID->343585878,ExpressionUUID->"4a583dab-2f5f-4d0f-aede-239f6e468e4c"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->59949866,ExpressionUUID->"2bcee052-28c8-4c11-a857-a342ccbf310d"],

Cell[TextData[{
 "Deforming the integration contour into a circle around the origin, the \
result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{
        RowBox[{"|", "s", "|"}], "=", "1"}]], 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"s", " ", "t"}]], "\[CenterDot]", 
        FractionBox["3", 
         SuperscriptBox["s", "3"]]}], 
       RowBox[{"\[DifferentialD]", "s"}]}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"s", "->", "0"}]], 
      FractionBox[
       RowBox[{"3", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"s", " ", "t"}]]}], 
       SuperscriptBox["s", "3"]]}], "=", 
     FractionBox[
      RowBox[{"3", 
       SuperscriptBox["t", "2"]}], "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cf56d590-0ce1-464d-a790-61577b938408"],
 "."
}], "Text",
 CellID->159260011,ExpressionUUID->"13077a1c-d739-4ab0-8cfe-60a4dbcf8c05"],

Cell[TextData[{
 "Check with ",
 ButtonBox["InverseLaplaceTransform",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->37148016,ExpressionUUID->"15179c91-65e9-4135-b21a-213ac291b43f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   FractionBox["3", 
    SuperscriptBox["s", "3"]], ",", "s", ",", "t"}], "]"}]], "Input",
 CellID->225713041,ExpressionUUID->"6bea38d9-3da6-42bc-8fab-35a0c0b9d2b0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["t", "2"]}], "2"]], "Output",
 CellID->359753391,ExpressionUUID->"1beb2013-6c7f-4177-92b0-4dd1d1c43f86"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 28", "Subsection",
 CellID->60095934,ExpressionUUID->"8ec488a0-49ce-48e6-8cd1-ae65d388e8e1"],

Cell[TextData[{
 "Find the velocity vector field associated to the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"2", "z"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fa597743-c59b-4850-bc46-e88d8a86993b"],
 "."
}], "Text",
 CellID->21229999,ExpressionUUID->"2fa17fa0-bda4-4773-b80d-5c5e828cd022"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->72598322,ExpressionUUID->"c063750b-4b3b-4951-baee-1248d35f6acb"],

Cell[TextData[{
 "One has ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"2", "x"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0ea6be90-4eaa-45fb-9f89-08be0bd71a69"],
 ", so the vector field is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["u", "x"], ",", 
      SubscriptBox["u", "y"]}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"2", ",", "0"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0e97470a-e888-45b6-bd87-ce8354ffbc03"],
 "."
}], "Text",
 CellID->211594067,ExpressionUUID->"47b408c9-5eb3-4669-b265-ba40d1bc4565"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Question 29", "Subsection",
 CellID->829898368,ExpressionUUID->"73e99aa7-16f5-45b0-9a40-d9222b98359d"],

Cell[TextData[{
 "Is the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", "x", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"254b90a9-f9d6-4b2c-b5b1-bddbf3d3f97a"],
 " an elliptic integral?"
}], "Text",
 CellID->32272953,ExpressionUUID->"b7c3e5e5-93e4-4d53-b0a4-1965bb9491b9"],

Cell[CellGroupData[{

Cell["Solution", "Subsubsection",
 CellID->80687769,ExpressionUUID->"eac92298-411c-466f-921f-34cc38235b39"],

Cell["\<\
No, because the polynomial inside the square root has order 2.\
\>", "Text",
 CellID->50931170,ExpressionUUID->"30912db0-9b5d-44ec-86e1-1bc153a4da03"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1830674834,ExpressionUUID->"40087970-7c32-4eeb-8f23-f492ef5fb5f0"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"32. Sample Final Exam | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "31. Complex Analysis in a Nutshell"}, "PrettyTooltipTemplate"], 
      "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "References"}, "PrettyTooltipTemplate"], "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, 66}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, CellMargins -> {{64, 64}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {30, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -40}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], FontFamily -> "Source Sans Pro", 
       FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Appearance -> None, ButtonFunction :> (Documentation`HelpLookup[
              Part[#, 1]]& ), ButtonSource -> ButtonContents, Evaluator -> 
            Automatic}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Closed]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Closed]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}]}, Open]]}, 
  Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"0dbef908-1603-444a-acdf-069e1e18a818"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "QuestionText"->{
  Cell[36357, 1285, 449, 13, 36, "Text",ExpressionUUID->"6450f425-7ac4-49e2-a775-9446af6f1a2e",
   CellTags->"QuestionText",
   CellID->332403458],
  Cell[66302, 2330, 547, 15, 36, "Text",ExpressionUUID->"df866534-b5b1-4314-bf60-46e78d90aee0",
   CellTags->"QuestionText",
   CellID->839495662]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"QuestionText", 210340, 5475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[644, 23, 224, 7, 108, "Section",ExpressionUUID->"397cb451-930c-4ad2-b692-df8457d268ee",
 CounterAssignments->{{"Section", 31}},
 CellID->587956081],
Cell[CellGroupData[{
Cell[893, 34, 107, 1, 56, "Subsection",ExpressionUUID->"9851b3d4-67c0-4453-a1df-5d75fa401184",
 CellID->701465740],
Cell[1003, 37, 356, 10, 39, "Text",ExpressionUUID->"476d0780-cbec-48c1-ad29-12fc116b83cd",
 CellID->229945384],
Cell[CellGroupData[{
Cell[1384, 51, 108, 1, 54, "Subsubsection",ExpressionUUID->"ba7e4762-f5e2-4d99-8e5e-3c6a9db93b4f",
 CellID->345128362],
Cell[1495, 54, 668, 25, 70, "Text",ExpressionUUID->"198e0a71-1a1a-4128-bb51-933dba1ea9cf",
 CellID->306695457],
Cell[CellGroupData[{
Cell[2188, 83, 209, 5, 70, "Input",ExpressionUUID->"d3f2cc0a-018d-4fe6-9de7-ec4510234029",
 CellID->935080457],
Cell[2400, 90, 134, 3, 70, "Output",ExpressionUUID->"91ba5a1e-be23-45b5-8c0f-a31ec31884ad",
 CellID->8867906]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2595, 100, 107, 1, 56, "Subsection",ExpressionUUID->"0a84064e-84cc-4d34-b822-55c6e308d51b",
 CellID->108565473],
Cell[2705, 103, 537, 17, 36, "Text",ExpressionUUID->"5381e30a-f504-494d-b111-887a9e85d186",
 CellID->680436152],
Cell[CellGroupData[{
Cell[3267, 124, 108, 1, 54, "Subsubsection",ExpressionUUID->"f6a80323-f1c5-488c-9b22-bb823ab27d3e",
 CellID->602229183],
Cell[3378, 127, 939, 29, 70, "Text",ExpressionUUID->"ea3b2d3e-3c5c-42c7-8874-c651ce892abb",
 CellID->191430127],
Cell[4320, 158, 545, 18, 70, "Text",ExpressionUUID->"4246e317-5308-45ba-87a9-775676b64a79",
 CellID->581771998],
Cell[CellGroupData[{
Cell[4890, 180, 372, 10, 70, "Input",ExpressionUUID->"843f0cf7-d440-4cad-870f-be92d0e7e524",
 CellID->362306368],
Cell[5265, 192, 375, 11, 70, "Output",ExpressionUUID->"9105ee03-a3c8-4bba-a766-d51d2ad5c315",
 CellID->104733062]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5701, 210, 106, 1, 56, "Subsection",ExpressionUUID->"c73d4341-31a3-44d3-a08e-63fc1e555e4c",
 CellID->83448002],
Cell[5810, 213, 376, 10, 39, "Text",ExpressionUUID->"171a0de9-4a1c-4f6f-a804-2bfa7ef09c3a",
 CellID->31794797],
Cell[CellGroupData[{
Cell[6211, 227, 107, 1, 54, "Subsubsection",ExpressionUUID->"13f64a1b-ea8f-4eca-85f3-2d41c509e755",
 CellID->95407196],
Cell[6321, 230, 864, 27, 70, "Text",ExpressionUUID->"31ce7aa3-7bfe-4e78-922f-69a735fb71a8",
 CellID->170139159],
Cell[CellGroupData[{
Cell[7210, 261, 227, 6, 70, "Input",ExpressionUUID->"b11e5c03-8450-4328-9432-b5b6abd16fc4",
 CellID->71497430],
Cell[7440, 269, 240, 8, 70, "Output",ExpressionUUID->"15f436e8-5cfc-4364-9e2e-fef320203f29",
 CellID->13571737]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7741, 284, 106, 1, 56, "Subsection",ExpressionUUID->"b1b164fb-bce3-415a-8a3a-702a950626a2",
 CellID->14780930],
Cell[7850, 287, 318, 9, 36, "Text",ExpressionUUID->"2077081e-8e8d-4cfe-826a-87287afcb7a7",
 CellID->54291060],
Cell[CellGroupData[{
Cell[8193, 300, 107, 1, 54, "Subsubsection",ExpressionUUID->"0583d3f6-62df-437a-bf87-e03967f2da79",
 CellID->57862147],
Cell[8303, 303, 1003, 34, 70, "Text",ExpressionUUID->"34923d83-d9f9-4bd7-a8b5-35b67bb8c9f4",
 CellID->170558200]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9355, 343, 106, 1, 56, "Subsection",ExpressionUUID->"8eb123c7-a229-4ecf-8d06-ecac54d64c87",
 CellID->89605895],
Cell[9464, 346, 367, 11, 36, "Text",ExpressionUUID->"6ced36f4-b411-450a-b18e-66473c1d6718",
 CellID->405618000],
Cell[CellGroupData[{
Cell[9856, 361, 108, 1, 54, "Subsubsection",ExpressionUUID->"b209d98d-58f0-41a4-818a-44162c9eeb9a",
 CellID->544989682],
Cell[9967, 364, 756, 24, 70, "Text",ExpressionUUID->"e93e73e6-e3e0-48ed-b3ef-81fdca328923",
 CellID->668367796],
Cell[CellGroupData[{
Cell[10748, 392, 245, 7, 70, "Input",ExpressionUUID->"aaaddc83-6ceb-4fdf-8a53-10e4ec27fa0f",
 CellID->353162876],
Cell[10996, 401, 267, 7, 70, "Output",ExpressionUUID->"256ee494-c316-4114-b9c9-2731c52321d1",
 CellID->67311233]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11324, 415, 107, 1, 56, "Subsection",ExpressionUUID->"a500b116-8651-4dbb-8e61-33cb467fe235",
 CellID->293835027],
Cell[11434, 418, 396, 13, 40, "Text",ExpressionUUID->"f754ee75-d884-4b68-a349-f09d1f59368c",
 CellID->271891448],
Cell[CellGroupData[{
Cell[11855, 435, 108, 1, 54, "Subsubsection",ExpressionUUID->"437cecfd-4fe5-4915-9520-d156eee05129",
 CellID->701091331],
Cell[11966, 438, 326, 11, 70, "Text",ExpressionUUID->"7c05c52a-af8d-4d3d-86c2-73c64c139435",
 CellID->206743486],
Cell[CellGroupData[{
Cell[12317, 453, 253, 7, 70, "Input",ExpressionUUID->"967da23f-a02e-4dae-b4a1-515c3ddd748c",
 CellID->823702169],
Cell[12573, 462, 120, 2, 70, "Output",ExpressionUUID->"8777e044-d0b2-413d-a129-886529937898",
 CellID->319006647]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12754, 471, 107, 1, 56, "Subsection",ExpressionUUID->"b177eb6e-92e6-44f3-871b-6ea1aad6cc56",
 CellID->436905328],
Cell[12864, 474, 539, 18, 41, "Text",ExpressionUUID->"d019608c-c8a4-4fa6-a06b-92f4500f04c5",
 CellID->378761218],
Cell[CellGroupData[{
Cell[13428, 496, 108, 1, 54, "Subsubsection",ExpressionUUID->"4845631d-2d64-4712-8a83-bebdf933a1ba",
 CellID->438214530],
Cell[13539, 499, 1167, 41, 70, "Text",ExpressionUUID->"b9959212-455a-4cf4-b060-38c2702ba761",
 CellID->301107725],
Cell[CellGroupData[{
Cell[14731, 544, 395, 12, 70, "Input",ExpressionUUID->"32395614-e5e3-42a5-9395-03e2540a03b2",
 CellID->172864316],
Cell[15129, 558, 123, 2, 70, "Output",ExpressionUUID->"72226ded-1aed-433d-bb02-49298e489546",
 CellID->423683524]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15313, 567, 107, 1, 56, "Subsection",ExpressionUUID->"d63621ac-ee26-480c-9dc6-8e9eef2c8c35",
 CellID->178921358],
Cell[15423, 570, 453, 13, 41, "Text",ExpressionUUID->"27fbc697-f5e4-46e4-a5a5-45c894c60a84",
 CellID->19735981],
Cell[CellGroupData[{
Cell[15901, 587, 108, 1, 54, "Subsubsection",ExpressionUUID->"2f93aa2d-2071-4670-9d7f-6bf3b04ae158",
 CellID->290054477],
Cell[16012, 590, 979, 29, 88, "Text",ExpressionUUID->"8cb4ae81-108d-4a18-a1ff-d677a229506c",
 CellID->342965823]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17040, 625, 107, 1, 56, "Subsection",ExpressionUUID->"f7a0e0c3-8243-41ef-a656-04b25ebf95b9",
 CellID->241553394],
Cell[17150, 628, 624, 18, 60, "Text",ExpressionUUID->"f3c4180b-c2df-45a0-94c1-a72a15e63591",
 CellID->6018790],
Cell[17777, 648, 250, 7, 36, "Text",ExpressionUUID->"50ca1f2b-8909-40d8-95fe-69363689d466",
 CellID->497547435],
Cell[18030, 657, 275, 8, 36, "Text",ExpressionUUID->"85402af7-088c-4b43-9fa5-6bf434040fec",
 CellID->756936108],
Cell[18308, 667, 275, 8, 36, "Text",ExpressionUUID->"7ad33f1f-7d9c-477f-803e-53c575e8194f",
 CellID->415029986],
Cell[18586, 677, 252, 7, 39, "Text",ExpressionUUID->"df21221c-07f1-41dd-9628-d702bc91d27e",
 CellID->13109463],
Cell[CellGroupData[{
Cell[18863, 688, 108, 1, 54, "Subsubsection",ExpressionUUID->"792e839c-4f75-4497-be15-e3b929d10ac6",
 CellID->180192049],
Cell[18974, 691, 332, 10, 70, "Text",ExpressionUUID->"dd4a7322-8492-4deb-98f0-2e26610828ac",
 CellID->701818970]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19355, 707, 108, 1, 56, "Subsection",ExpressionUUID->"d9ab0d90-b728-4047-aad6-ca3225fc3659",
 CellID->135089850],
Cell[19466, 710, 837, 25, 38, "Text",ExpressionUUID->"ad47112f-dd82-4a8c-a86e-e7002d1f1837",
 CellID->425397965],
Cell[CellGroupData[{
Cell[20328, 739, 108, 1, 54, "Subsubsection",ExpressionUUID->"7a6957a5-8b03-4b7e-8ee5-0088a6930379",
 CellID->762731603],
Cell[20439, 742, 415, 11, 70, "Text",ExpressionUUID->"b5395fbd-822a-4484-a0da-cd9d6975cb74",
 CellID->96366124],
Cell[20857, 755, 733, 22, 70, "DisplayFormula",ExpressionUUID->"d20eca6d-2c95-4645-b4b6-f94501359ef4",
 CellID->5105429],
Cell[21593, 779, 176, 6, 70, "Text",ExpressionUUID->"553e260f-7656-4860-81d4-b791f602b1ed",
 CellID->702876376],
Cell[CellGroupData[{
Cell[21794, 789, 424, 12, 70, "Input",ExpressionUUID->"a297c2d2-3836-4242-80cf-0e19271b618e",
 CellID->11100463],
Cell[22221, 803, 120, 2, 70, "Output",ExpressionUUID->"2c0ab1ca-46a3-45ef-b625-b92ae6f9063f",
 CellID->321597722]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22402, 812, 108, 1, 56, "Subsection",ExpressionUUID->"4c56d352-d438-45c2-8024-6620ac1c9e8b",
 CellID->278399723],
Cell[22513, 815, 427, 12, 38, "Text",ExpressionUUID->"9fd9567e-cefb-42c1-9980-ba851a5681e8",
 CellID->20514312],
Cell[CellGroupData[{
Cell[22965, 831, 2011, 63, 70, "Input",ExpressionUUID->"bd790c19-0b53-4dfa-a452-7a1c8d0c535a",
 CellID->21736800],
Cell[24979, 896, 824, 21, 237, "Output",ExpressionUUID->"c29f14da-7cc4-46e9-ad42-6e8012512027",
 CellID->454216506]
}, {2}]],
Cell[CellGroupData[{
Cell[25837, 922, 108, 1, 54, "Subsubsection",ExpressionUUID->"36247e09-6fdf-4774-8d9f-d8bf02d772aa",
 CellID->453079999],
Cell[25948, 925, 571, 17, 70, "Text",ExpressionUUID->"ac15991c-1e81-4293-961d-833f2e648879",
 CellID->591168569]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26568, 948, 108, 1, 56, "Subsection",ExpressionUUID->"a9be1522-5c1b-489f-8165-09c113ed9286",
 CellID->441552462],
Cell[26679, 951, 229, 4, 60, "Text",ExpressionUUID->"f4c0b9da-e155-40bc-8da0-48d39e4315f0",
 CellID->426008402],
Cell[26911, 957, 254, 7, 36, "Text",ExpressionUUID->"9d9664ff-b524-4ca5-b4c3-ffffb7221b0d",
 CellID->24713105],
Cell[27168, 966, 306, 9, 36, "Text",ExpressionUUID->"d57a970b-f28c-4c3a-94e7-4e3c2fadbfc8",
 CellID->790172659],
Cell[27477, 977, 333, 10, 36, "Text",ExpressionUUID->"c74dc53f-dafb-4e8f-8e0e-b2eb0a39f8dd",
 InitializationCell->True,
 CellID->432551159],
Cell[27813, 989, 306, 9, 36, "Text",ExpressionUUID->"b5b7aaac-71e3-47c0-92ed-f8f4ce3de395",
 CellID->196626408],
Cell[CellGroupData[{
Cell[28144, 1002, 107, 1, 54, "Subsubsection",ExpressionUUID->"3e39e963-ff7c-45d9-a72e-c8d2c68d3b16",
 CellID->32032195],
Cell[28254, 1005, 197, 4, 70, "Text",ExpressionUUID->"381d5dcc-7384-4fbe-9046-55a876e4a11e",
 CellID->132670541]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28500, 1015, 107, 1, 56, "Subsection",ExpressionUUID->"eac31358-15cc-43db-ab1e-85e405605eef",
 CellID->29468958],
Cell[28610, 1018, 553, 18, 40, "Text",ExpressionUUID->"5e3bf1a0-945a-40f3-a084-77570a126634",
 CellID->235071694],
Cell[CellGroupData[{
Cell[29188, 1040, 108, 1, 54, "Subsubsection",ExpressionUUID->"87d97429-cd35-4fa0-a16e-7a0ef503e6e4",
 CellID->661484380],
Cell[29299, 1043, 403, 9, 70, "Text",ExpressionUUID->"b1ca86c6-98f0-44fb-b3ff-5e3b78f6904a",
 CellID->9956720],
Cell[29705, 1054, 176, 6, 70, "Text",ExpressionUUID->"8a6ccaaf-65e8-4ee0-8347-92784df56b05",
 CellID->764918667],
Cell[CellGroupData[{
Cell[29906, 1064, 412, 13, 70, "Input",ExpressionUUID->"61fcab89-995a-4cf3-9a1a-1bdba1640214",
 CellID->8567869],
Cell[30321, 1079, 150, 2, 70, "Output",ExpressionUUID->"0a40de8e-7d82-4dc4-b7fa-41774dab0de3",
 CellID->12522303]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30532, 1088, 108, 1, 56, "Subsection",ExpressionUUID->"dd711d9d-a188-4b78-bcb8-fb0480bd02da",
 CellID->973330725],
Cell[30643, 1091, 621, 18, 41, "Text",ExpressionUUID->"0ad73ee9-703e-4a08-977e-7d09ad2b7607",
 CellID->96568439],
Cell[CellGroupData[{
Cell[31289, 1113, 108, 1, 54, "Subsubsection",ExpressionUUID->"ae0eb682-26a0-4dd1-bf13-7db2d65df2b6",
 CellID->177964512],
Cell[31400, 1116, 485, 12, 70, "Text",ExpressionUUID->"855b199b-c59a-48f9-9919-64d7f25c0b51",
 CellID->448987867]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31934, 1134, 107, 1, 56, "Subsection",ExpressionUUID->"ed28d64d-27d8-4f35-b407-7d3f3ddef37a",
 CellID->65965701],
Cell[32044, 1137, 346, 9, 36, "Text",ExpressionUUID->"79cecc12-3314-4957-97f3-f8b618423980",
 CellID->28769971],
Cell[32393, 1148, 309, 9, 36, "Text",ExpressionUUID->"761f3338-3290-4484-960a-f3a70abbda7d",
 CellID->36439273],
Cell[32705, 1159, 280, 8, 36, "Text",ExpressionUUID->"0fb1a7a6-720f-4ace-b0f9-513beedc88a8",
 CellID->216575354],
Cell[32988, 1169, 305, 9, 36, "Text",ExpressionUUID->"1394ea91-cac1-476f-bc31-1b2b73d7a867",
 CellID->210904032],
Cell[33296, 1180, 285, 8, 36, "Text",ExpressionUUID->"339f27ce-77e2-4ec3-b7dd-dbf9984e2e1b",
 CellID->271815648],
Cell[CellGroupData[{
Cell[33606, 1192, 108, 1, 54, "Subsubsection",ExpressionUUID->"c0ebef62-4307-4ace-a2bb-8e87ea8b162c",
 CellID->701330768],
Cell[33717, 1195, 323, 5, 70, "Text",ExpressionUUID->"fb62a47e-0750-4bff-a984-9e9d1ef11d96",
 CellID->44007503]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34089, 1206, 108, 1, 56, "Subsection",ExpressionUUID->"6cbfc641-ee89-4617-9337-e3d0ff027cce",
 CellID->851453876],
Cell[34200, 1209, 128, 1, 36, "Text",ExpressionUUID->"b35a25a0-f2ed-4f4c-9209-0d5682a72d9c",
 CellID->229151912],
Cell[34331, 1212, 306, 9, 36, "Text",ExpressionUUID->"6f73fed7-8cc7-4b2f-9d2c-148f492a50ab",
 CellID->11827812],
Cell[34640, 1223, 287, 8, 36, "Text",ExpressionUUID->"9944f15c-ad5d-4bc1-a884-bf8684ed0f9a",
 CellID->145066444],
Cell[34930, 1233, 307, 9, 36, "Text",ExpressionUUID->"561748b3-0223-4e20-9306-4e2a7c73c5d0",
 CellID->445605434],
Cell[35240, 1244, 281, 8, 36, "Text",ExpressionUUID->"917ca7ea-4f30-4717-9420-f1933b5b3139",
 CellID->188186560],
Cell[CellGroupData[{
Cell[35546, 1256, 108, 1, 54, "Subsubsection",ExpressionUUID->"89c205ab-6dec-4a0c-8f04-0ff972c43046",
 CellID->533059042],
Cell[35657, 1259, 114, 1, 70, "Text",ExpressionUUID->"e20e35c8-55f0-4ba1-91d8-2afa57250edb",
 CellID->5486397],
Cell[CellGroupData[{
Cell[35796, 1264, 284, 8, 70, "Input",ExpressionUUID->"447771b5-d229-4b22-8a50-62f55c94fc55",
 CellID->248631961],
Cell[36083, 1274, 103, 1, 70, "Output",ExpressionUUID->"7aa0f7b6-a0a2-4a16-bfa4-3feca966b9d1",
 CellID->122040834]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36247, 1282, 107, 1, 56, "Subsection",ExpressionUUID->"3f4f2a4b-2bf4-4513-b07e-847dea53e3fc",
 CellID->63472839],
Cell[36357, 1285, 449, 13, 36, "Text",ExpressionUUID->"6450f425-7ac4-49e2-a775-9446af6f1a2e",
 CellTags->"QuestionText",
 CellID->332403458],
Cell[36809, 1300, 359, 11, 36, "Text",ExpressionUUID->"e4233483-c5e8-43bb-b4fc-022ae21e064d",
 CellID->211081748],
Cell[37171, 1313, 278, 8, 42, "Text",ExpressionUUID->"3513e800-1ce5-4cc8-8b62-f44c2e76e5d8",
 CellID->182051195],
Cell[37452, 1323, 287, 8, 36, "Text",ExpressionUUID->"0af718b9-1e66-4746-9502-613f38a5b451",
 CellID->259155977],
Cell[37742, 1333, 307, 9, 36, "Text",ExpressionUUID->"17395664-bc82-445b-8ed7-541dce7bb9a4",
 CellID->147459708],
Cell[CellGroupData[{
Cell[38074, 1346, 108, 1, 54, "Subsubsection",ExpressionUUID->"ec9d6087-dcf3-4839-8b6b-c6c6a1c72f02",
 CellID->521673994],
Cell[38185, 1349, 142, 1, 70, "Text",ExpressionUUID->"e4adb5ab-f43e-4c61-8a5a-94c9fdee491e",
 CellID->305164189]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38376, 1356, 108, 1, 56, "Subsection",ExpressionUUID->"22232011-2a52-4be3-83e6-a015c37c2515",
 CellID->595401235],
Cell[38487, 1359, 535, 15, 36, "Text",ExpressionUUID->"7bad8719-055c-4e1e-86cb-719cde809265",
 CellID->7500439],
Cell[CellGroupData[{
Cell[39047, 1378, 107, 1, 54, "Subsubsection",ExpressionUUID->"2a97c9b9-e3d4-4687-a9bb-e168eb9cc951",
 CellID->65811520],
Cell[39157, 1381, 1317, 42, 70, "Text",ExpressionUUID->"8ea3824a-1f95-4cae-a925-1013d0d11b14",
 CellID->171718772],
Cell[CellGroupData[{
Cell[40499, 1427, 233, 6, 70, "Input",ExpressionUUID->"a80fc95c-b3a1-462c-b4d0-88576318a62a",
 CellID->2682673],
Cell[40735, 1435, 175, 4, 70, "Output",ExpressionUUID->"da9960b6-a46e-4a6d-9ae2-edce9338d55e",
 CellID->46118051]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40971, 1446, 108, 1, 56, "Subsection",ExpressionUUID->"4fca6a80-13fc-48d7-b718-a276a247a6cb",
 CellID->324823373],
Cell[41082, 1449, 583, 17, 40, "Text",ExpressionUUID->"bce9b4de-ab8b-42b9-a78a-18e9511dd149",
 CellID->331767475],
Cell[CellGroupData[{
Cell[41690, 1470, 107, 1, 54, "Subsubsection",ExpressionUUID->"8868639b-9cb2-4eb8-886b-ccafc7f342f7",
 CellID->71531695],
Cell[41800, 1473, 1050, 36, 40, "Text",ExpressionUUID->"46c03ba4-09a1-4764-87eb-4e23814b4359",
 CellID->146440356],
Cell[42853, 1511, 166, 6, 36, "Text",ExpressionUUID->"dd3c7ad6-b3d9-4254-b826-f6f42bf0117f",
 CellID->186270951],
Cell[CellGroupData[{
Cell[43044, 1521, 320, 9, 25, "Input",ExpressionUUID->"7ff0949a-2e79-415f-b09c-e85ee96e4825",
 CellID->295315],
Cell[43367, 1532, 526, 16, 57, "Output",ExpressionUUID->"79e4db79-3227-4abc-8dac-075c52c20a3f",
 CellID->478669734]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43954, 1555, 107, 1, 56, "Subsection",ExpressionUUID->"10ccafc0-384f-4097-ac8c-c99913625b86",
 CellID->24594851],
Cell[44064, 1558, 685, 21, 41, "Text",ExpressionUUID->"5ef7ff6d-4973-4253-87ee-9c55bc4998cb",
 CellID->45392781],
Cell[CellGroupData[{
Cell[44774, 1583, 108, 1, 54, "Subsubsection",ExpressionUUID->"9ac7ff0c-c436-47c3-829c-0e708cec4d7e",
 CellID->358510001],
Cell[44885, 1586, 176, 6, 70, "Text",ExpressionUUID->"661faf1a-4eda-4b2b-aff2-95ad36dbe6ee",
 CellID->449548470],
Cell[CellGroupData[{
Cell[45086, 1596, 393, 12, 70, "Input",ExpressionUUID->"a63f6998-2eb2-4d51-ba2c-1af5a0c574fe",
 CellID->166911674],
Cell[45482, 1610, 539, 16, 70, "Output",ExpressionUUID->"7d37868d-0f32-472a-aaa5-40aefaba778c",
 CellID->350856828]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46082, 1633, 107, 1, 56, "Subsection",ExpressionUUID->"a84fec23-600e-4755-af6a-381fb3a448f3",
 CellID->70365291],
Cell[46192, 1636, 415, 12, 42, "Text",ExpressionUUID->"2faa3b51-3c1e-4faa-928c-e07aad131751",
 CellID->71178080],
Cell[CellGroupData[{
Cell[46632, 1652, 108, 1, 54, "Subsubsection",ExpressionUUID->"c4ba26f1-87cb-4740-86fa-123da37c6400",
 CellID->319738746],
Cell[46743, 1655, 1147, 35, 70, "Text",ExpressionUUID->"f49b3051-0a1d-4200-b771-bfa613b0bee1",
 CellID->179131595]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47939, 1696, 108, 1, 56, "Subsection",ExpressionUUID->"4812e8ff-b2e0-4493-bc92-4411ec98929e",
 CellID->382567890],
Cell[48050, 1699, 579, 18, 41, "Text",ExpressionUUID->"6907f4c2-fc02-4864-a755-e8c2891907ef",
 CellID->742849510],
Cell[CellGroupData[{
Cell[48654, 1721, 107, 1, 54, "Subsubsection",ExpressionUUID->"8ad88e20-ee30-43e4-96c6-1435b55a4ab1",
 CellID->42610947],
Cell[48764, 1724, 716, 26, 41, "Text",ExpressionUUID->"079b1cb4-208e-41ba-afea-89d6eb526882",
 CellID->148354345],
Cell[49483, 1752, 167, 6, 36, "Text",ExpressionUUID->"e4c756fd-28cc-47fb-9fda-7f12240bde4b",
 CellID->314401147],
Cell[CellGroupData[{
Cell[49675, 1762, 299, 9, 48, "Input",ExpressionUUID->"f79cde52-d23f-4cca-8a6a-057e0c190e0f",
 CellID->9460561],
Cell[49977, 1773, 103, 1, 36, "Output",ExpressionUUID->"f487916a-f740-44ed-aca3-0bce4fec3577",
 CellID->821109254]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50141, 1781, 107, 1, 56, "Subsection",ExpressionUUID->"cceff9e5-3ca4-421e-9884-0979aa7dd11b",
 CellID->77878008],
Cell[50251, 1784, 495, 15, 41, "Text",ExpressionUUID->"84447040-2078-462a-94ed-36fca2d3f70d",
 CellID->435381204],
Cell[CellGroupData[{
Cell[50771, 1803, 1549, 48, 70, "Input",ExpressionUUID->"7114cbe2-1edf-4a3e-9925-c5fd1d3a0166",
 CellID->32572864],
Cell[52323, 1853, 636, 18, 177, "Output",ExpressionUUID->"5885afc8-3b6c-4fe9-b7bb-ec95f0315c45",
 CellID->221532883]
}, {2}]],
Cell[CellGroupData[{
Cell[52993, 1876, 107, 1, 54, "Subsubsection",ExpressionUUID->"d05a2261-e762-4019-869b-074bddfae290",
 CellID->34808795],
Cell[53103, 1879, 652, 20, 70, "Text",ExpressionUUID->"a3334cf1-f01b-48bc-8f66-fba4697e1bff",
 CellID->61640621],
Cell[CellGroupData[{
Cell[53780, 1903, 371, 12, 70, "Input",ExpressionUUID->"0042dceb-dbc8-4040-8531-8edfc603ae38",
 CellID->463647224],
Cell[54154, 1917, 119, 2, 70, "Output",ExpressionUUID->"380fc4a6-839e-4316-bd82-4438f9397de7",
 CellID->53558687]
}, Open  ]],
Cell[54288, 1922, 395, 13, 70, "Text",ExpressionUUID->"ac08e70c-0137-45d8-8df4-b3bf10b34fdd",
 CellID->59784013],
Cell[CellGroupData[{
Cell[54708, 1939, 397, 13, 70, "Input",ExpressionUUID->"25de9a3a-f8a8-4f6b-84e3-8657eaa7f63c",
 CellID->154565020],
Cell[55108, 1954, 102, 1, 70, "Output",ExpressionUUID->"0f4394c1-bf4d-4f0d-9b25-ae05bb371142",
 CellID->81225068]
}, Open  ]],
Cell[55225, 1958, 450, 13, 70, "Text",ExpressionUUID->"f74352cf-a0e5-45a5-8f83-8bbb97965983",
 CellID->965625417]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[55724, 1977, 108, 1, 56, "Subsection",ExpressionUUID->"3a671c32-d5c5-42dd-aa5b-909791aef466",
 CellID->132401314],
Cell[55835, 1980, 447, 13, 36, "Text",ExpressionUUID->"d4af7009-158e-4fec-a6bc-44004ea37f53",
 CellID->86448612],
Cell[CellGroupData[{
Cell[56307, 1997, 107, 1, 54, "Subsubsection",ExpressionUUID->"2dd4309e-61fc-4599-bedb-153d3668482e",
 CellID->78916208],
Cell[56417, 2000, 900, 29, 43, "Text",ExpressionUUID->"ac30798e-22bd-48c6-a9bc-70bce7885859",
 CellID->27219095],
Cell[CellGroupData[{
Cell[57342, 2033, 442, 14, 46, "Input",ExpressionUUID->"52708902-adbf-4eb9-a295-db9eba76d59e",
 CellID->394407033],
Cell[57787, 2049, 415, 13, 58, "Output",ExpressionUUID->"515aac0c-e2bf-468d-bfbd-3f203aa9f92d",
 CellID->718011873]
}, Open  ]],
Cell[58217, 2065, 117, 1, 36, "Text",ExpressionUUID->"83a5b7fb-76b2-4102-b6ac-1aa8367aed73",
 CellID->565463428],
Cell[CellGroupData[{
Cell[58359, 2070, 433, 12, 47, "Input",ExpressionUUID->"a208ebbb-b469-4db5-af18-f4488b66b661",
 CellID->531725718],
Cell[58795, 2084, 102, 1, 36, "Output",ExpressionUUID->"c9b82207-e051-4d4a-aa96-4051c4885feb",
 CellID->18138512]
}, Open  ]],
Cell[58912, 2088, 167, 6, 36, "Text",ExpressionUUID->"38aed967-689a-4b4a-a2c0-db45fca84aab",
 CellID->155074021],
Cell[CellGroupData[{
Cell[59104, 2098, 400, 13, 25, "Input",ExpressionUUID->"8be2e5a8-cd77-4b2c-b043-0cba540c7afa",
 CellID->68632041],
Cell[59507, 2113, 2265, 59, 45, "Output",ExpressionUUID->"03b3e70c-0482-40fa-b2ec-3085927c7f10",
 CellID->1875257839]
}, Open  ]],
Cell[61787, 2175, 121, 1, 36, "Text",ExpressionUUID->"103a6aea-7257-4fae-992c-967c8b1af6ec",
 CellID->623805788],
Cell[CellGroupData[{
Cell[61933, 2180, 129, 2, 25, "Input",ExpressionUUID->"e7603d7a-20f7-4f59-a522-90516262fb51",
 CellID->586183936],
Cell[62065, 2184, 242, 5, 36, "Output",ExpressionUUID->"6c3c858d-b84a-4678-9b91-ece7c669421c",
 CellID->130852270]
}, Open  ]],
Cell[62322, 2192, 133, 2, 25, "Input",ExpressionUUID->"29964cfa-4518-4310-a8bc-bade60bb83b1",
 CellID->445427444]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62504, 2200, 108, 1, 56, "Subsection",ExpressionUUID->"f8dde7d6-9154-41cd-8f40-d174a2c76a74",
 CellID->658311913],
Cell[62615, 2203, 736, 22, 41, "Text",ExpressionUUID->"2cb0df68-b97f-4930-bd23-61e126920965",
 CellID->118634228],
Cell[CellGroupData[{
Cell[63376, 2229, 107, 1, 54, "Subsubsection",ExpressionUUID->"b7b44bea-0663-4b01-8102-fa8bcc2f036d",
 CellID->25969986],
Cell[63486, 2232, 902, 26, 70, "Text",ExpressionUUID->"a8377942-f89b-48d5-97d2-930ea0059740",
 CellID->281752392],
Cell[CellGroupData[{
Cell[64413, 2262, 559, 16, 70, "Input",ExpressionUUID->"20486c89-b6ce-4280-92a3-793f36aff9c2",
 CellID->63536575],
Cell[64975, 2280, 212, 5, 70, "Output",ExpressionUUID->"20c19221-1055-445e-afdb-fb740a8254d9",
 CellID->369591741]
}, Open  ]],
Cell[65202, 2288, 169, 6, 70, "Text",ExpressionUUID->"7de7d59a-bbc4-485b-bbcd-5456631fef55",
 CellID->428647634],
Cell[CellGroupData[{
Cell[65396, 2298, 519, 15, 70, "Input",ExpressionUUID->"80b4f05b-ad01-4156-8cea-52608345b609",
 CellID->139269512],
Cell[65918, 2315, 212, 5, 70, "Output",ExpressionUUID->"c8f7db58-457e-4c17-bf91-8f18f996602c",
 CellID->763469224]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66191, 2327, 108, 1, 56, "Subsection",ExpressionUUID->"81b67e49-c1d6-4d45-8c63-36d2d64790e9",
 CellID->292611051],
Cell[66302, 2330, 547, 15, 36, "Text",ExpressionUUID->"df866534-b5b1-4314-bf60-46e78d90aee0",
 CellTags->"QuestionText",
 CellID->839495662],
Cell[CellGroupData[{
Cell[66874, 2349, 108, 1, 54, "Subsubsection",ExpressionUUID->"608d381f-19ea-4239-aff6-3fb44832b469",
 CellID->807223007],
Cell[66985, 2352, 111, 1, 70, "Text",ExpressionUUID->"ee44e922-5680-4613-9901-48ff392f856d",
 CellID->320770277]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67145, 2359, 107, 1, 56, "Subsection",ExpressionUUID->"7f26de08-7d80-4bff-97cb-62dfe5afb96c",
 CellID->37741075],
Cell[67255, 2362, 381, 11, 40, "Text",ExpressionUUID->"4a583dab-2f5f-4d0f-aede-239f6e468e4c",
 CellID->343585878],
Cell[CellGroupData[{
Cell[67661, 2377, 107, 1, 54, "Subsubsection",ExpressionUUID->"2bcee052-28c8-4c11-a857-a342ccbf310d",
 CellID->59949866],
Cell[67771, 2380, 1107, 35, 70, "Text",ExpressionUUID->"13077a1c-d739-4ab0-8cfe-60a4dbcf8c05",
 CellID->159260011],
Cell[68881, 2417, 182, 6, 70, "Text",ExpressionUUID->"15179c91-65e9-4135-b21a-213ac291b43f",
 CellID->37148016],
Cell[CellGroupData[{
Cell[69088, 2427, 232, 5, 70, "Input",ExpressionUUID->"6bea38d9-3da6-42bc-8fab-35a0c0b9d2b0",
 CellID->225713041],
Cell[69323, 2434, 171, 4, 70, "Output",ExpressionUUID->"1beb2013-6c7f-4177-92b0-4dd1d1c43f86",
 CellID->359753391]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69555, 2445, 107, 1, 56, "Subsection",ExpressionUUID->"8ec488a0-49ce-48e6-8cd1-ae65d388e8e1",
 CellID->60095934],
Cell[69665, 2448, 365, 10, 36, "Text",ExpressionUUID->"2fa17fa0-bda4-4773-b80d-5c5e828cd022",
 CellID->21229999],
Cell[CellGroupData[{
Cell[70055, 2462, 107, 1, 54, "Subsubsection",ExpressionUUID->"c063750b-4b3b-4951-baee-1248d35f6acb",
 CellID->72598322],
Cell[70165, 2465, 672, 22, 70, "Text",ExpressionUUID->"47b408c9-5eb3-4669-b265-ba40d1bc4565",
 CellID->211594067]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70886, 2493, 108, 1, 56, "Subsection",ExpressionUUID->"73e99aa7-16f5-45b0-9a40-d9222b98359d",
 CellID->829898368],
Cell[70997, 2496, 436, 13, 39, "Text",ExpressionUUID->"b7c3e5e5-93e4-4d53-b0a4-1965bb9491b9",
 CellID->32272953],
Cell[CellGroupData[{
Cell[71458, 2513, 107, 1, 54, "Subsubsection",ExpressionUUID->"eac92298-411c-466f-921f-34cc38235b39",
 CellID->80687769],
Cell[71568, 2516, 160, 3, 70, "Text",ExpressionUUID->"30912db0-9b5d-44ec-86e1-1bc153a4da03",
 CellID->50931170]
}, Closed]]
}, Open  ]]
}, Open  ]],
Cell[71767, 2524, 310, 6, 135, "SmallText",ExpressionUUID->"40087970-7c32-4eeb-8f23-f492ef5fb5f0",
 CellGroupingRules->"SectionGrouping",
 CellID->1830674834]
}
]
*)

(* NotebookSignature QTsCfXqbLd#RbkIEidl2JgmD *)
