(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    167126,       3488]
NotebookOptionsPosition[      3452,         89]
NotebookOutlinePosition[    166183,       3470]
CellTagsIndexPosition[    166140,       3467]
WindowTitle->Introduction | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Introduction", "Section",
 CellChangeTimes->{
  3.652728456208679*^9, 3.652728527108994*^9, {3.96028553184334*^9, 
   3.9602855341456633`*^9}},
 CellID->1398035018,ExpressionUUID->"ed99423c-f25c-42b2-8d4a-852fb7ac2096"],

Cell["\<\
Complex analysis is a versatile tool that is used extensively in science, \
engineering and other fields. It is also a beautiful topic in itself. A \
course in complex analysis is a standard part of the curriculum for students \
of physics and engineering and a stepping stone for more advanced topics in \
mathematics.\
\>", "Text",
 CellID->119274048,ExpressionUUID->"976b0cf0-b328-4643-a77d-0092dc6ee7cb"],

Cell["\<\
This book is a basic introduction to the subject. It covers the elementary \
functions, the Cauchy\[Dash]Riemann equations, complex integration, Cauchy\
\[CloseCurlyQuote]s theorem and the residue theorem. The emphasis is on \
visualization and hands-on exercises, rather than on comprehensive proofs.\
\>", "Text",
 CellID->559126605,ExpressionUUID->"22e80794-95bd-4112-bb3e-d8d473f01462"],

Cell["\<\
The book makes extensive use of Mathematica, a powerful system originally \
designed by Stephen Wolfram as a \[OpenCurlyDoubleQuote]system for doing \
mathematics by computer.\[CloseCurlyDoubleQuote] Hence, Mathematica is \
ideally suited for topics in pure mathematics, such as complex analysis.\
\>", "Text",
 CellID->15061320,ExpressionUUID->"f93e834f-9bbe-4b1c-9989-aacc8500da67"],

Cell["\<\
The reader will get exposure to the capabilities of Mathematica in this \
domain, and will appreciate the power of Mathematica to visualize all kinds \
of functions and contours, as well as its computational abilities. Tedious \
residue calculations or contour integrations or series expansions can quickly \
be solved by dedicated Mathematica functions so the reader can focus on the \
important points.\
\>", "Text",
 CellID->80292473,ExpressionUUID->"56bfc67a-5bdb-4b18-8726-d00cf6d8fbc1"],

Cell["\<\
A first course in complex analysis is a necessary milestone for further \
studies. We hope that this book will be a good springboard to your next level \
of mathematical understanding.\
\>", "Text",
 CellID->177453611,ExpressionUUID->"c8f89cc9-2ffe-4989-b642-872c93fc43f9"],

Cell["\<\
The Wolfram Mathematical Computation Team
November 2025\
\>", "Text",
 CellID->478190513,ExpressionUUID->"b5a0f269-37a1-4595-925e-031069f55ff0"],

Cell["", "Text",
 CellID->411233405,ExpressionUUID->"036ea560-957f-47cc-8099-3888ad33e40f"]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1490618158,ExpressionUUID->"2963af2f-9c6f-4318-a907-efd9a2ce43ad"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Introduction | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], "Cover"}, 
        "PrettyTooltipTemplate"], "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "1. What Is Complex Analysis?"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"139d7777-dab5-44f0-8faf-c5e4f33e8306"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[635, 23, 225, 4, 108, "Section",ExpressionUUID->"ed99423c-f25c-42b2-8d4a-852fb7ac2096",
 CellID->1398035018],
Cell[863, 29, 418, 7, 107, "Text",ExpressionUUID->"976b0cf0-b328-4643-a77d-0092dc6ee7cb",
 CellID->119274048],
Cell[1284, 38, 400, 6, 83, "Text",ExpressionUUID->"22e80794-95bd-4112-bb3e-d8d473f01462",
 CellID->559126605],
Cell[1687, 46, 394, 6, 83, "Text",ExpressionUUID->"f93e834f-9bbe-4b1c-9989-aacc8500da67",
 CellID->15061320],
Cell[2084, 54, 502, 8, 130, "Text",ExpressionUUID->"56bfc67a-5bdb-4b18-8726-d00cf6d8fbc1",
 CellID->80292473],
Cell[2589, 64, 283, 5, 60, "Text",ExpressionUUID->"c8f89cc9-2ffe-4989-b642-872c93fc43f9",
 CellID->177453611],
Cell[2875, 71, 154, 4, 60, "Text",ExpressionUUID->"b5a0f269-37a1-4595-925e-031069f55ff0",
 CellID->478190513],
Cell[3032, 77, 91, 1, 36, "Text",ExpressionUUID->"036ea560-957f-47cc-8099-3888ad33e40f",
 CellID->411233405]
}, Open  ]],
Cell[3138, 81, 310, 6, 135, "SmallText",ExpressionUUID->"2963af2f-9c6f-4318-a907-efd9a2ce43ad",
 CellGroupingRules->"SectionGrouping",
 CellID->1490618158]
}
]
*)

(* NotebookSignature TQWq8Mf1RNn7PiY8o3#3tynt *)
