(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   4015535,      72631]
NotebookOptionsPosition[   3837240,      68948]
NotebookOutlinePosition[   4000012,      72330]
CellTagsIndexPosition[   3999969,      72327]
WindowTitle->3. Complex Functions | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Complex Functions"
}], "Section",
 CounterAssignments->{{"Section", 2}},
 CellID->453001635,ExpressionUUID->"565709cb-d594-47a5-883b-294b5d8eb676"],

Cell[TextData[{
 "This chapter contains an introduction to the concept of a complex function. \
A complex function is a function that assigns to the complex number ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6c0a6128-e5b7-49df-8dd5-f01a0733b185"],
 " the complex number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f4f453cb-37ff-43a0-85c9-3272aec9d180"],
 "."
}], "Text",
 CellID->16601600,ExpressionUUID->"84b6a5ee-5aaf-4361-b304-67960309b288"],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "704c7cd4-4728-4a06-8cea-32c2dc4635f9"],
 " of the function, being a complex number, can be written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f50e7273-c189-4e26-899c-a8c8ada24ca3"],
 ", so:"
}], "Text",
 CellID->723865904,ExpressionUUID->"bd2342b7-d3d5-4e0d-a09c-5206aa62fab8"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], "=", 
     RowBox[{
      RowBox[{"f", "(", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
      RowBox[{
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "y"}], ")"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"v", "(", 
         RowBox[{"x", ",", "y"}], ")"}]}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->190724934,ExpressionUUID->"1ec8f12d-7cd3-49c5-993e-f1ca8807d79a"],

Cell[TextData[{
 "having separated ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ae9d75ef-22cd-4359-8170-667d62402b68"],
 " into its real and imaginary parts."
}], "Text",
 CellID->492971970,ExpressionUUID->"9aa8073d-324b-49d9-a580-76d88ee47f3a"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->11668042,ExpressionUUID->"f98d7432-bd38-472c-a1df-9122977d22c9"],

Cell[TextData[{
 "Find the real and the imaginary parts of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["z", "2"]}], "+", "3"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"657489f2-9eba-4ee3-a5fc-acbd7bb8c72e"],
 "."
}], "SolvedExampleNote",
 CellID->583495455,ExpressionUUID->"cd9aeec1-7eac-4991-9327-07071d17f4f9"],

Cell[TextData[{
 "Using the arithmetic operations introduced in ",
 ButtonBox["Chapter 1",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}], "+", "3"}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "-", 
          SuperscriptBox["y", "2"], "-", 
          RowBox[{"2", "\[ImaginaryI]", " ", "x", " ", "y"}]}], ")"}]}], "+", 
       "3"}], "=", 
      RowBox[{
       RowBox[{"2", 
        SuperscriptBox["x", "2"]}], "-", 
       RowBox[{"2", 
        SuperscriptBox["y", "2"]}], "+", "3", "+", 
       RowBox[{"4", "\[ImaginaryI]", " ", "x", " ", "y"}]}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "a50ef89f-3716-451d-b3d4-711997be45dd"],
 "."
}], "SolvedExampleNote",
 CellID->566641116,ExpressionUUID->"266afb43-a979-4881-9045-0cb5052016bf"],

Cell[TextData[{
 "Or use ",
 ButtonBox["ComplexExpand",
  BaseStyle->"Link"],
 " to find the answer:"
}], "SolvedExampleNote",
 CellID->706432227,ExpressionUUID->"a7b88590-ea40-4228-b0e9-2d36f60d503a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"z", "^", "2"}]}], "+", "3"}], "/.", 
   RowBox[{"z", "->", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", "*", "y"}]}]}]}], "]"}]], "SolvedExampleInput",
 CellID->356636232,ExpressionUUID->"3e99e2ac-701b-4339-9176-ba5b4a6d6c8d"],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"4", " ", "\[ImaginaryI]", " ", "x", " ", "y"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["y", "2"]}]}]], "SolvedExampleOutput",
 CellID->240372332,ExpressionUUID->"17002a48-a589-46b5-80f0-6a4178ccd580"]
}, Open  ]],

Cell[TextData[{
 "So, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"2", 
      SuperscriptBox["y", "2"]}], "+", "3"}]}], TraditionalForm]],
  ExpressionUUID->"499e990b-8e61-4ee8-bdd7-bda44e170d9f"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"v", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"4", "x", " ", "y"}]}], TraditionalForm]],ExpressionUUID->
  "9bbaf398-ff31-4486-8849-4ee1572c054f"],
 "."
}], "SolvedExampleNote",
 CellID->642260787,ExpressionUUID->"7d3ad983-1b05-4fdc-8f71-8c3b1c34a7b5"],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"32d17228-49ad-4c60-a30e-02c8d0607216"],

Cell[TextData[{
 "A complex function is harder to plot than a real function, because both ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "59840535-6531-4155-9b5e-127b656eaaef"],
 " and ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]], "InlineMath",ExpressionUUID->
  "db1481d2-80d8-4a3e-ad24-92451f0c60e2"],
 " are complex numbers and require two real dimensions to be described. \
However, you will see some very useful visualization methods based on colored \
plots that can help with understanding the main features of a complex \
function. Another possibility is to exploit an analogy between a complex \
function and a vector field."
}], "Text",
 CellID->46424756,ExpressionUUID->"50d2cb74-7d62-41cb-903c-2f5fbd664d67"],

Cell[CellGroupData[{

Cell["Visualization of Complex Functions", "Subsection",
 CellID->89986701,ExpressionUUID->"2e609b54-f7db-46ee-bc66-f2793245e0c7"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s see a few visualization methods based on the example \
of the complex function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], "=", 
     SuperscriptBox["z", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5280869e-6d19-47ea-8d41-27c350414369"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1b209a01-cb20-4dde-9d69-ca6a46fc5781"],
 "."
}], "Text",
 CellID->137180708,ExpressionUUID->"98fc7c59-4bf1-4e0e-a565-967accef77dd"],

Cell[CellGroupData[{

Cell["Visualization Methods in Two and Three Dimensions", "Subsubsection",
 CellID->630772653,ExpressionUUID->"2c16dcc6-aaf2-4eb3-8021-1479156b7968"],

Cell["\<\
One possibility to make sense of this function is to plot its real part and \
its imaginary part.\
\>", "Text",
 CellID->262427916,ExpressionUUID->"a60a20e5-931f-45e5-939e-f19203c7fbb1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}], ",", 
      RowBox[{"Im", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["6", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1792", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {{-3, 3}, {-3, 3}, {-10, 10}}, BoxRatios -> {1, 1, 1.5}, 
      PlotStyle -> Directive[
        Opacity[0.8]], Mesh -> None, AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> {
        ToString[
         Re[$CellContext`z^2], TraditionalForm], 
        ToString[
         Im[$CellContext`z^2], TraditionalForm]}],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["616", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 1. Real and imaginary parts of " <> ToString[
       HoldForm[$CellContext`w == $CellContext`f[$CellContext`z] == \
$CellContext`z^2], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->214848256,ExpressionUUID->"3a224646-70d8-4321-9e8f-b23e111cebe7"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "+", 
              RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}], ",", 
          
          RowBox[{"Im", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "+", 
              RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1.5`"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Opacity", "[", "0.8`", "]"}], "]"}]}], ",", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            FormBox[
             RowBox[{"Re", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12], ",", 
           StyleBox[
            FormBox[
             RowBox[{"Im", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12]}], "}"}]}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           FormBox[
            RowBox[{"Re", "(", 
             SuperscriptBox["z", "2"], ")"}],
            TraditionalForm], ",", 
           FormBox[
            RowBox[{"Im", "(", 
             SuperscriptBox["z", "2"], ")"}],
            TraditionalForm]}], "}"}]}]}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Fig. 1. Real and imaginary parts of \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           TagBox[
            RowBox[{"w", "\[Equal]", 
             RowBox[{"f", "[", "z", "]"}], "\[Equal]", 
             SuperscriptBox["z", "2"]}],
            HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->517836062,ExpressionUUID->"3e51820e-efa2-4f93-b6e1-347aa4af25c0"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJytmg+Q1dV1xx/LKmRbbNZiTLaIu7ql1USJf0oQXny3lWkhTaJhDYxWiKIo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          "], {{{
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.880722, 0.611041, 0.142051], Lighting -> {{"Ambient", 
                 RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                "Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNmgnYlsMax5+xb0XRQkWIbCch0YJQ9kQKkTbbR7RvorTKkkKyJpQtFVmP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                 "]]}, Annotation[#, "Charting`Private`Tag$12529#1"]& ]]}, {
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.368417, 0.506779, 0.709798], Lighting -> {{"Ambient", 
                 RGBColor[
                 0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
                "Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNmGuUllUVx5nnAbk4YHEdrsplAEUE5DpcZ7jNDNeZ4U6ShYiIBAqWmSKS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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwlkMFKAlAQRZ/v2dZFbVyJ/oAf4ycIqaioRAgFLhRBEUMEFREXRkqQSBgS
ISJ9TiuXugvPZRYHDm/mMXcmla1mKt45F4coNIJzMx4+4BPPw1/EuQuM8Dnc
UbuFKv4G/9ROUMB/YEltDC/4K6TwJCzwgf5469njfejgXfjC6/CM92CNN4Nl
2UMLf4cEHoMK/ghpb28PeC1YNs3UbGVW9jPc40PYahYc8UMwVyZla8Ovtx71
roLN0o5F/ClYNt1og5ch6u0mus0OJt520m5TuPHWU8JzwbLoTTXdSLfSn2/8
CvorNVw=
                 "]]}, Annotation[#, "Charting`Private`Tag$12529#2"]& ]]}, {
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> {{"Ambient", 
                 GrayLevel[0.8]}}], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJxNULsOgkAQvOM+QP7AWEphw59YQgIJVBZqLGws7P0DbI1RNMZoo/JVPrDH
2eyYUMzt3dzu7Oz2sulw4hljAsABKY4YCIE1Pg5AKRHvrtwRC3J7YOk054w4
AGrc31bjF7Ce1nUAH9gg54n/EeLjrw00VvmXVa7vVF+8BE7fxlNdyzrxIR53
TvVn7G/oQXKkx91TXcM+IfWEvyJWiBfOUbHGsEZ0Iqez1PST09PWqd6Y+4pb
Pv3WzIaeV/Rb8K+hpwV3feIOI86RU/OGe0b+Y5VLyQuX0Z/0Ljmv8AnzE9aK
9typjyO9BtzzD27qQmg=
                "]], 
               
               Polygon3DBox[{{944, 697, 681, 894}, {881, 527, 543, 937}, {940,
                 665, 649, 885}, {942, 681, 665, 890}, {873, 495, 511, 932}, {
                877, 511, 527, 934}}]}]}, {
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> {{"Ambient", 
                 GrayLevel[0.8]}}], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJw1kb1OAkEUhWd3nsBHoN6180nsTCABQi2FhSaaSGJiCJTGEEKIlbzAaigo
/FkfRaBGsfc7mUPx7bl7Z+b+Nrr90/M8hFBChGs+zziW6G8Wwg57j474j9gz
tIIJ9hU6hiPsJ7QFZ/CTJz2O6X3H/m/irOEvSzEP93RHOV/hBd7xfaBv6Ak0
oYBhTG8n9vWgdOyW48vuOHfP977ypG3b6ku95FBBDZ/OrzoWsIrpbBCTX/lV
m2reOcbSs7pxfbXrjz7fe36q5dC3dJOlWpru7x62+B7QqXscOl7lmHeeiWZz
69pWfl+4RuVaO2/h2dTuvfS9C+9Le3t0XuW/9E6127l3rZ3/A/bCT7o=
                "]], 
               
               Polygon3DBox[{{949, 678, 677, 891}, {896, 691, 706, 957}, {892,
                 677, 692, 953}, {919, 501, 486, 901}, {927, 529, 514, 905}, {
                923, 515, 500, 903}, {903, 500, 501, 921}, {905, 514, 515, 
                925}, {953, 692, 691, 895}, {901, 486, 487, 917}, {888, 663, 
                678, 949}, {957, 706, 705, 899}}]}]}, {}, {}, {}}, {{
             GrayLevel[0], 
             Line3DBox[CompressedData["
1:eJwt0LtKgmEAx+EvzdJOdgVFVC6SW06FbhVFJ7fa2myw1a7ArsAIWhNcQkIh
3MKuIDPtYNmd+AgOD7//y/cu37tycXVamAiCIEeI0V5kmRTbHJD04VwfNc2l
/aRZru1dvdFbKjR4pc07HT7o0uPQ/U991iPu+HJu6jH3fDuf6I/2+eWPAf+8
0aLOA2X23C/pi+5QtGuaIW9v6pnus8UGS8RZYJ45Zpkh4X5Mq7pOdPR/usa0
vapTGmGS8PgdhxjmJV8=
              "]]}, {
             GrayLevel[0], 
             
             Line3DBox[{865, 484, 861, 754, 499, 514, 529, 883, 907, 927, 905,
               925, 906, 923, 903, 921, 904, 919, 901, 917, 902, 915, 487, 
              486, 485, 813, 865}], 
             
             Line3DBox[{489, 488, 871, 916, 869, 918, 870, 920, 875, 922, 876,
               924, 879, 926, 880, 929, 928, 544, 559, 574, 589, 604, 619, 
              634, 886, 939, 889, 941, 893, 943, 897, 898, 698, 699, 700, 701,
               702, 703, 704, 900, 913, 958, 914, 956, 911, 954, 912, 952, 
              909, 950, 910, 948, 908, 946, 648, 633, 618, 603, 588, 573, 558,
               884, 882, 935, 878, 933, 874, 931, 872, 494, 493, 492, 491, 
              490, 489}], 
             
             Line3DBox[{496, 495, 930, 873, 932, 877, 934, 881, 937, 936, 543,
               528, 513, 756, 866, 498, 862, 814, 497, 496}], 
             
             Line3DBox[{938, 649, 664, 679, 810, 867, 694, 863, 819, 695, 696,
               697, 945, 944, 894, 942, 890, 940, 885, 938}], 
             
             Line3DBox[{678, 663, 887, 947, 888, 949, 891, 951, 892, 953, 895,
               955, 896, 957, 899, 960, 959, 705, 706, 707, 812, 868, 708, 
              864, 820, 693, 678}]}}}, VertexNormals -> CompressedData["
1:eJzVewlYjlv3dxEyR2VIRBlLUUqk0zaEFKF0iBxHSIocCSHzPEQ54phC1IkK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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Re", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Im", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1.5}, DisplayFunction :> Identity, 
         FaceGridsStyle -> Automatic, 
         Method -> {"DefaultBoundaryStyle" -> Directive[
             GrayLevel[0.3]], 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {-10., 10.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           RowBox[{"Re", "(", 
             SuperscriptBox["z", "2"], ")"}], 
           RowBox[{"Im", "(", 
             SuperscriptBox["z", "2"], ")"}]}, "SwatchLegend", 
          DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #}, {
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]|>, 
                    "RGBColorSwatchTemplate"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]|>, "RGBColorSwatchTemplate"]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}]}], "}"}], 
               ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 Graphics3DBox[
                  SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                  PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, ImagePadding -> 
                  0]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "12"}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 1. Real and imaginary parts of \
\\!\\(\\*FormBox[TagBox[RowBox[{\\\"w\\\", \\\"\[LongEqual]\\\", \
RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", \
SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->1013004978,ExpressionUUID->"37695661-bc56-47e5-b716-608cea854072"]
}, {3}]],

Cell[TextData[{
 "Another possibility is to plot the absolute value and the argument of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], "=", 
     SuperscriptBox["z", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"24b13229-765d-4a22-856f-7dd3351d8a61"],
 "."
}], "Text",
 CellID->411342485,ExpressionUUID->"716ad439-9571-4502-afa1-139a903cfbe6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Abs", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}], ",", 
      RowBox[{"Arg", "[", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["7", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1664", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {{-3, 3}, {-3, 3}, {-4, 10}}, BoxRatios -> {1, 1, 1.5}, 
      PlotStyle -> Directive[
        Opacity[0.8]], Mesh -> None, AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, Exclusions -> All, 
      PlotLegends -> {
       "Abs(\!\(\*SuperscriptBox[\(z\), \(2\)]\))", 
        "Arg(\!\(\*SuperscriptBox[\(z\), \(2\)]\))"}],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["664", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 2. Absolute value and argument of " <> ToString[
       HoldForm[$CellContext`w == $CellContext`f[$CellContext`z] == \
$CellContext`z^2], TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->535953922,ExpressionUUID->"36453b66-8d77-42ce-b131-d9e6eb49b57f"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "+", 
              RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}], ",", 
          
          RowBox[{"Arg", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"x", "+", 
              RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "]"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1.5`"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Opacity", "[", "0.8`", "]"}], "]"}]}], ",", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            FormBox[
             RowBox[{"Re", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12], ",", 
           StyleBox[
            FormBox[
             RowBox[{"Im", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12]}], "}"}]}], ",", 
        RowBox[{"Exclusions", "\[Rule]", "All"}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          
          RowBox[{"\"\<Abs(\\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\))\>\"",
            ",", "\"\<Arg(\\!\\(\\*SuperscriptBox[\\(z\\), \
\\(2\\)]\\))\>\""}], "}"}]}]}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Fig. 2. Absolute value and argument of \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           TagBox[
            RowBox[{"w", "\[Equal]", 
             RowBox[{"f", "[", "z", "]"}], "\[Equal]", 
             SuperscriptBox["z", "2"]}],
            HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->1565913001,ExpressionUUID->"3b9665fa-2f63-4e4f-b730-696b99ce361d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJyVnXm8zdX+/898dso8JBeZIlLpplAnn1VKVOYhhFRXCqekOVGkkCYypHQq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          "], {{{
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.880722, 0.611041, 0.142051], Lighting -> {{"Ambient", 
                 RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                "Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNmgnY11MWx38Xb9mXtGpmkKUwg4nSYgaV0lCK7A0t1CsjLUqpCMW0K/HM
FFMJWV5FnhmFtsGkZJmxixFaZioVKSWjOZ/u5/+8nuc9zz2/+7vLuWf5nnN/
//fobjdd1HuvoihO37so4q84MBXFk0G3BN8iqGHQaUFnB50a9Ougp8qK4pRo
10d7VpF53rUJOiOoSVDroMY+t3SN05kfa6+PtlHQBsecG3SOa7Pfea7RNOh3
Qc2CmgddWOT9kOXtsty3I9r20f7Wdx1dC9nbugbzG8a+G0uyBP9VtK2QKfhN
yrBZuS8Jui/orqARQfcHjQy6O+hE12PdL2Lvw6OdHm2DWOeN4D8Jmh388UGv
B/9mtMcFLQ/+2WjrB60I/rGYUzfardEuCVoafFmVoqinDtDFseoM3VWLd0ui
/TDGzgiqHvyqaDuoD848TXmQ68NoXwtaFjQl9lwTbc2g1UE1gmK54uPovzjo
Z0EPBq2NvlpB+wcdEVQnaFH0r4u2NmeLdd+KtnpMrlkl8/TVDv7N4FcGv3eV
fBbOdLTnwDcuVbdttG2DoBN4jvV/iPbmoKFBfwi6MShF/03R3hb0fvCPBbUN
2ow8QQcFzQvqGnRIYkJR9I5mGHOCvy7osKADggZoR2wIPxA9Rv9TQR2DHgiq
G1Q9qHbQrfF+VNDoIvNDgsbYIuNYW/aqE+MPDbo9+PXR/tfYqRHtndFORO8p
+9KkoOuDPyKoWtB+KZ+bd/sG37/Ic14MvmfQ4UFX6MfEwTptU0ebYsuqQQu0
HzY+psg+gH98m/LYBvpSdW1/nC3+8HWM2RL0SdD2oG1B/w5anLLt1+rv+P1J
+v0JPjdyreP12Xruf5l2Jo4vt22rLxztuNMce6xr4W/EQ2PXq19k7Kiv/Kc7
9jj3r+OcY1yroe8aOfZ41+J5WJyjfdDw4H+rv12L3oKeDpodtNB2TtCVQf8r
su6f1E9qBfUKqnCdp8TJQUX2oafkF7nGM0EvBVW4x2L7ng16N2LjEWxpTNM3
N+j96H8u2gOj/wX2Zp+geUGPBz0R9HzQLJ9f9D17zPc9c3aX5THzy7K/Vehz
c1LGpo+LHB9PGCP17QevHo92VtDgIsfCLOOhrTF4ffCPypMr5qaMayuL3M51
vTuDXtKH30nZR/HPEdH+PagbPp3yfuy1Qn1hE9Z+1L2ujXZmUCtlnCO2PiPP
Web4fGVQuefqW2TZHxcrGign++ydMq6ALz2CfyTo3JRtzr7lRY4/+vsVGdcX
6CNv2mLn17UBcoPL2PLQKjmGiL36+ukJ+jC2mhr0oLb6c9AUbfknnyt8/5C2
nOKcreaL5WXZ7090XfxocpFz1BZjF98nnomHmj+JpcbK0cRn5jf1eb05vSLa
J8tyrG8rq8SLEn7QEnNrxffHzTn0EdfIeJLyHayexwVdFvzRQX8xPqYFTS+y
v8/0HMTBjKCHgy6NsUcG3VvkPLPIGFqmrxMfS40H4mO5fdjjNfsYl6rkMQtC
zqNSxmP2fcZ2hkT/JPemJf/P9XmmdJ+6rpey/LO11VjPiK3IGWO0ZSmHdIrx
Pw8ary3HOAeb/9Fxl8T7XwRNCP4OY4ecsDroS31y/2h7FDmH3R38GfhZ8M2j
3RFt96D3gp8edHbQ50Grgm4oMh6Dy+ThEi7zDC5f4TM55kqfG5EXor0q6PdF
zsnk5pHR35RcUeR4KXc8NRV11MVFru+os0r1HnUetVZr96e+2u2aV9vHua5T
pp4+X+76PO8qMmYz97tYs3O07YK2BnUpct33ddA1Ra6JLpRn/UbKhDzEwAb7
kBWZOxW5BiKGqPG+TznXEru/TDnPUi8RC/DE1D/Fo/riSgMxkDNSR57rXq3l
O9mP/BcVuf5k/7dSrhHBtLv0MfyvvbKje+qW+/W9lp6llWfe6HqtXLOl/Ab3
bemYFj5v8j2YPDXoVyljQRtlJUefU+SacrUYTz2DDw7UFtRfa80L1DzkRvRG
HUQcEPPk2P7aDL+9Wfse4Dl5fp61g6qkXDdxTvYY4Jmp2W5POX+Tp6jxhuo3
7E1sETt/jf4+QXul7KOMoVabj4wp14fbioz3+AqxdYe56aKU8xxx+IH5grx0
M9gftE/KNV4145c8Wt04pWasIUadoz06qO+O6px7x1faiDqKGGvr2SZrb+4g
m/WRhs5jPfCYOw13m1O1Cc9NXYM4Pk0bt/B9yffPssWPwGHwZlhRWcuOLipr
WZ5rio3Unz1+Ygdq1Du15cFVMl5Tp3xT5HqbGGuiLG2UlT2JzY0x99OU8/4p
xtR++Gnwn6VcW5ITwWywm9z3ks/kRDAc7AaDwWLyw5OOBds3luX95pTlfDrf
OeSf5up7rT7BucHw51yLmmyB+5XqP57JC4uLnG/Yb4nPM3x+xj3IMUvdc5nP
rEV9QV0wxzUWKu9yx73oe57BZuK7dOeBJ+Y3id0/6iOlu8vV6ha7zjL/koe3
qG8wEQzE97oUGTPBVuKOXAFW4odNzRvgT3OxHN8jh4BPxCwY216Z0Msbnu0a
98fPwALwGpz+xj2Jsd2Owz/Osq4ir9wUfG/jtH9QN+PrB2UEE8pdj5wyMN4N
EB++Vy78sIfnYu/p2gR9U2OQm7Et+ZbcDB7dE3zfoGbEQco1JfXkpeqIM48C
A4LODGqR8nk4S2P5a9TXt+oQ2qqum6jbrkW+X+zyPOh0u/N2+L3iu2gHxZjf
eKZXzLOlfAZ/QdC70f9Q0MmpMrd1UJ6v1fXo4Lsr84SUa1nq2Eu0Jfuzzw51
19o90eFA9YgNu0R/SzHy5ZRrdHQFtlLHUKeADTPUd6lO4hnsoKYp1T5TnAOu
POg76h9qG2pa6hzqOupAajxqMmopcHCm6zZRli7OByOIe+pHMIJ1SrU4fkmc
veUz31r49kGsTdMviO8fvRNxNyKmHnG/Ka5dqsdpS/U47SzPUaEcw1O+n5M7
uENxN+Guwf1mYdC+RdYldwz8B4wlb4G956QcG8QFPsY3Dvi+xkRXbQHfJ/jz
Us6dA7QVPH51vnPJs6+m7ENgxRfoUh5/Za+r3RcZwJi/6f/E3f0pn4e78SDj
jBqSuxu+Qv2JDORsYrNDyvmA/H2h78kNb0S7IuU6YHDQBZ7/Yf2Tvdo4F98b
F+0QY5A8Sj69V92i1zs848Hq7T8p3+W4x61J+Y5GXYKPMYYYZ89D1QlrH6IO
dxgDnGukscLdc7Bj+G6zNOW7PGsuU4cHuS5rkvdfiHZoynUIZ6+hnK+n/F2g
veOqeSZ0hN5GqE/OxV2SczJ3YlH5bYh44s5a7vqTg+4Lapeyzmuq5w3KiZ4n
KQ9jemi7Peu7DjhAzUhd+4AxQwwSd9iKfmq2CfaP18/BTcaOl0cHA9QbOuyc
cq3Ld07u+lelXANjw7raEdnrqFv0cYQ6qVBXPF+Rcqx+VORvV8QPsbPcGCZ+
yTesTb7kmwG4RO7ivs9d/3j1eFSq1Gtd7QIuIOcKdX6kMrAW89hnq1gDzoDr
5MgSrsN3LXJdRn1G7Uxd19Ax1ODcbUp1N/3UYQs9C3X1Jud2cgx3JHIBvkzN
yXcP6k74UfpaHW2xyfGsv+fbledakvK3OfLCBmXgLkNOIDcQ9+Scpu5Fvm3i
WbgzNpOnFqMm298Yaa6c3RxDjHDX4f7DN0byEndCctM37oXeyJnN9Q3wtp4+
Bo6R7/eServvP1LGLO6n5EnyJbnpB3nwDawCs8DGMSnX9mAF+7awH/yDB2PJ
FS3lZ6T8TZhn6g7qD74j7RYHb3QsY8Ao8Ps61wefwCmwbmLKd5MSDtL2N6bB
RDCZ+eAOmDM+5fsCcQcmnW8/35B62r88ZXzhfpEcA769ljIG8Y0NPbRxr0Nd
nzh6O+W7In7P9+r2+gP3mAvla8iDFZylg3xNeTDpo5TxuqM+eJF+CB7wW8AD
xj05u4QZnfRJ+Eu075HyE+TJ5dOMRXhijnxNTfa0fnGZc4lv4p88zf2snWf8
V8r3ajCF2AVruFPjR/jTNu0LD7Yfoh3hr3ed4UXOk+dpR3JQN/35Hvnvilxb
gps7i4y9+AB5nHtfd/u5e4KlVVO2I+P7aetyx0/Q7ow/XFuXcLinc6l1r3Xf
mfLMHee+ZcrV3zF78r/nIm5u8uzgJvgJ1pIjOHM112MueXasc1mHe3Ff+QrH
DxdPesk3c0zXItcG/ZSNOpG8SWxSJwzzLOh4qHPJCwM9Ozq7WRnIRbwDE+Bv
USej7Wc8fj1Yu8+TJ57OVP/d3H+Q6zwvj1ytXRMebOutfnooD3viG7e6/gvK
j8x8Exiizm/zLGXa4Tb5fp4FOSe5Dv3UfcPVwxjXwUasfbv95fKHufZt8qXY
mF5Uxg99FcYJMQL236dN28kjP/UDeNTavsmOYV9sU8oP9ysDdQ75khxAriBn
7GeMTP6JDSd5rj34kTLO3Wo/Y6htHtDfblEG7Ei+5m7C/Z2WZ3I33x2pnXoV
ueWZWvRs+V7mFH674hsa35/gyS+bncu3yrrue0eR6x3qHr5B8Y2I703ULSN9
hqcm5FsVd0fuNV86njv0F8pADcl3K74bUT+ucTzPfCMY4nju3p21EXYBA7dG
+03K46a5JnKWu1dP29Xu+4rrsO965a9lu94xpfMgL3IhHzUndcNUdYJe+YbC
9xN+i/tKnW/1LMgwy7mc41PH8xvuZ46vrb6nus5G7cWYk7XjvuLwfP2BOCPe
iKMh9hNPxOi8VIm78MQs8boHZ4uMPWBQK8eA18RIN8fsoy+x/p47fcq4A+ZQ
Tz6XMv6zDvgFdnEXXuzZOdMiz4X/E9uH2ccY/ByZxyjDOnVH/1DHgwN9XR+s
7acM+7g/cpB3wG9ivqr63qzO+7h+H+Ufq5zcnamxqCXBMWojsOsM+7sWuVai
f7s6ISeVMPge12Ff8gc1Q7l8VeWcYD/xPVKd8z0TjCB+ifkRytBMnjHg2zh1
wjy+d5ypfcdp9x6uv1NsH+0YZBjvvt3tZ8wo1+IsXbR1S883yv5+zsW+yPKy
shErxCB3Lr417Ug57ogvaiSwgt/9lzrmA/sPso+aaZD4sFQev6F+4M6wxngo
4cw79vGeOoPfDalDqUevcuwnjid+X7V/i8/wyLhTOanFqMm4v8x2X9akPuMd
dwwwDAxtr+zLPRfY8IrrvOdeYMVO9bBKf3lZ3+D/NFbiH0Wu3eC5w/G7HDLz
ex+/P/M/DbXUB7or/Wb7fqq826LH0u+uH6jPifoP2F6q1WaLk9TQ1M977uUp
YzLyIje4Dn4Qn8TmYnlwZbpjfhSL+F0SzFmgLcA5/vfgU/v53wPGEddvqkN0
u9b5jFmhLqhV3/C8HeU/Uj8XOwYevbAvv3/20hbkMmpv6m7uEdiJ/bgP8rvt
rpR/u2XeNueCId8rG3kA/L1BX92sDskNvONbLnNYo4HzdjkXW23RXqsczzpb
1EUJt7e7P2swv47n2OKYTx3/iTJud/1dPsN/qF5q6U/4Fd9yj/O8Hzn+e/dZ
6Xj0tlIdrlDGVZ6L78HEKt8pyYGfK/86dYIOdtrf2Xy68yf7f6cMtVyb3P1/
Pj3E4A==
                 "]], 
                Polygon3DBox[CompressedData["
1:eJwtkU0rxFEUhw/j3DRpkrc0NsZ2FmavfACxmaWlD8DX8AXIDkNGKBpKFspL
MikvTURDsrCwEFnITp5fx+Lp/5x7Tuf8z72FqZnydKuZDUIbvLlZie8wbOLb
MIpPwCfehEv8CvqT2Q/xCF6EDfwQ9vFzyJDf8uilHu+4p8jV4YT4FYbwAlTx
HvLX+BHcEz96zNJZX4oz5Y6hi7hGPImPwQ6+BN0WPdW7g5pdfBVuibMpfA4a
xHdQs6jJkdsjnsUXdOZRo9p5aCe/7vGvpf+7+vbYfQDW8AOoWtxBC/WdKf5V
MzRLO2v3BzjFK0CJ9cKzx0zNVo9f/MKjdx6+PHbUrrrzG4830duMwwf+oju0
uINF/AyeLN5Mb6cZmqWaZY+e6p2FFfwPvWZJJw==
                 "]]}, Annotation[#, "Charting`Private`Tag$12981#1"]& ]]}, {
             EdgeForm[], 
             Directive[
              Specularity[
               GrayLevel[1], 3], 
              RGBColor[0.368417, 0.506779, 0.709798], Lighting -> {{"Ambient", 
                 RGBColor[
                 0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
                "Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{0, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 2, 2}]}, {"Directional", 
                 RGBColor[
                 0.15473514000000002`, 0.21284718000000002`, 
                  0.29811516000000005`], 
                 ImageScaled[{2, 0, 2}]}}, 
              Opacity[0.8]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNm3f811P7x+t9ziclRYq0uLMz2kqDSigNGiqjklQaGrRLWspeiZQyb7L3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                 "]], 
                Polygon3DBox[CompressedData["
1:eJwtlmeMVVUUhZ/cs2M0GhSlqAgMdukoVelI701A2oyKNIeOgCCggICA9CZg
b9ixN8RCLBRRo1IUNMRYAAEBiVGj38p6P745a99595629zqnoGhkt+ISuVxu
AyR4lT9lIpf7PcvlfuAfS4gT8T7i72Ec+iq4lOcd4Rb0FVAZfQOMQF8Jl6Db
Qj/05VCAbgYd9C5URNeHKeir4TJ0V+ghDZXQ18MaWACr6LsvvI9+CXYytkLi
eejNyfokz8rx7nBow7M74ADcTNyS9lb4CVYSF9EOhu2wmvhO2mn5vj6A2zL3
+Ri6uuZMOxU+hMdhXwn/piL/mw/9eHY2XIQeCx3QE+FvmEvcm/Z2KEDX1JzR
5eFfeB1O8q3dmgP6BTiB/gJO47dvEv+J3gsNiTcQnws1oB3x87TnQT0YRvwa
bbnkNWhO/CxtKbgGgvht2lOZ93RmeA4aey9YgX5H80heo8rE9aE6+uLkvusS
V8uPoaX2Giqgr9Wehd/Rb2vqWXjOmmvV5LE0Jq6VH1Nt9FO050AV6Ev8BG1J
aAIHoU743SFQQXsFXdCT4Ag0Cvc1FL7WPodz8SblTXKOKDc2a03R/cO52BeO
K2/DYx8Ge6Cacpp2AKxDP6o85d0ZtA/Dt8pB4o2qEfT9/Ka/akF5Ad2Jr1Pe
5ffyu+S+tafKnfc0tsw59CT6TH7/G/EB4me0FsSHiP+A57S3xIfRx+Fp5Rnx
QfQxKKm+wrkwLl8b70LvzDWisW9Krh3N4T70R6oN9GIoxbstwrkxHrZCz3Dt
9czn5gXERzLn6FrNV/mF3gKrk7+pb6nPT5PnpLksIP4ZPYP3u6umknPvG3gw
cw6eQncMe8Fw2AufJL+7CSbzv7eIL0ze8wdgIZyfeQ3/Qs8K5+4IOEtzCefS
WPhPdRf2omLI0OPD3jUSTkdPDXvPqORaK098NHPNfay9CudiUzgDvRQGoUfD
Nlgfzo2ZmleyZ8or9Y0x/O8NrWGyJ3QjflHjT86RBeEcUu7IQwrDniWvagGV
iBfBQHQZWB72MHlXIdwbXgPN/UboHF5TrWUD7U3Yg+Q9ffR7OATbGds2WJ5/
Jq2c6hrOYeVuQ6gR9kh5ozxwSdgT5YVag/naE55N15jZ82nhNdVadlOehddc
a90JWodrTrVWB1YRLwvPZYz2JLxn2qt2sDbch74tj24SrnnVujykXtgj5A3y
pEXwT7KX7oJ1+WfSOtPmok8ke+tOWK/chT2Zc/xl9I/Jub2fPh9CL4X9mXNW
v82FvVjv7CKuojMuP8YtyR4hb1CN7U7+jf4nz1iZPAb1rZqegz4Kn6N3wIrk
Z9LyANXal7Auc819lXxG62zWs3vCNaba6qHvJM9BY1+buVZ2JGvVzJpwzipX
tWdViR+hnZLsedOJZ9NOTq7ZgWHPlFc2V45F3iOgkfoNe668tlXyt2aHc1Hf
1NnUKrzXOqN0NxgCrZPvCKqN4vBeq0bk/fPCuaozQGfD3eG56YzQ2XRXOLd0
Rs0J14hqQ2fsQvRG2tLJnqyzqSnUTj6jtFfyeHm79kx3j4nQOfkOortHl3Du
6w6iu84oaJ9855EXTQjnsjxJtdwpXGuqad1t2kDd5DuOxtIrvFYa09DwHUV3
E63BpPCZprNMY2iLLg0Tkr/RIOzx8nadwbXCHidv0x1idPjOobuGxrg47FHy
JnlGs7DHy9u1BkXoV2jLJt+JlsEs+CzzGfRr8hmjs2Vr5rtbb2icfIfT3WJw
eK91x9Ddb1DYq3QH7BP2THml3lFfA8K5Uzbf1y/J31afh5PPPJ118qRjyWee
zjrVhNaiffhuozX5H/r6TI0=
                 "]]}, 
               Annotation[#, "Charting`Private`Tag$12981#2"]& ]]}, {}, {
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> {{"Ambient", 
                 GrayLevel[0.8]}}], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJw1k8tqk1EUhU9+Pb9IrW11IErihXaitdIH0Cdw5qiTRHBaLw/Rh2iddFQF
BxkIaREVFW2LgmjTRsVBrWkQG0QQEcFLwW+xl5CVtc9/9tlnX9Y5deXGpetF
SqkB9oCNnNIsvAu/Buewv8Dn4bNgAvzMYTfhl+AQdg8+Vqa0iX20DL8aOA5e
sXcS/gz/AFXsO/A+/N5hl2XEq/qMfIfBiHnbtvYPgEGwCt6CN6BNrAvwV3gR
XgHLjiXfg+AbewPwAny5klIfeydF7oVrf8Eev7TJ3yr4gH2E3JZ8n+IeZr0G
P2H/KnHmQJf1afgM+Ig9DTfBWCXumvd9smfAEHarEue79p8FGym+KY7iNcA1
UElh3wTjoO6z8pmqxPlR7zfs3/MZ9W7eeejeOZ+t+85px5i0j3rS9HflM+Pv
k46l+9WvP9R/Ef4Nr7v+doo8VLf6/8s+8l1w/7/n8FWf2s5x3LEf5ehzQY+f
pojb9pz61tKu9fkX7ltX0lcX7MV+Dm95jprnXWtDGqk5luIs59CqNPs4x0w1
20/Ws3RdWp/vva+ct8Ai61vw/jI0Mep6pzyHToq5qbaedSOddjzflmf8IEed
Q2VA9sMcvR9zLJ2VpqXB22at7+ewE+cGQAvzXo6clNuS653wux32uzrhHtT8
LurW0bo1s23fwm9jxN8K2+rBmucy6DhV17fid/I/745nqLqepdDQju/9B67G
jp0=
                "]], 
               Polygon3DBox[CompressedData["
1:eJwtkcFKQmEQRgd17sZaGEgggbYPn0CfwF2P4APU4/gECi1qJRYqKiUWRFQI
iYuUiAiJNiFCO8/HuDje893/Z2ace1w/Pz1LmVkBMpBLzF55vsDQzQ7JC/wd
xuQ8eWnxbkLuQBNvQ5aze3J6V+sDf4IiXoIVfgkneAWuPJDX4B/PUONNtWFA
TiXhHeiS+3BrMaNm/SQfWPRUb0vibguuyTces93BPmdz8syih3rpju42YIpf
wJHFjBv8EXIWPb7wB4//plZLfv4gi+9B06OHemnGnsc7nanmGv/22IVqqvYv
VPEyPOM/Hq6daXcjj2+hnWv3Wyq3Oj8=
                "]]}]}, {}, {}, {}}, {{
             GrayLevel[0], 
             
             Line3DBox[{409, 1, 365, 227, 16, 31, 46, 61, 1457, 1489, 1517, 
              1487, 1515, 1485, 1513, 1486, 1511, 1483, 1509, 1484, 1507, 
              1479, 1505, 1480, 1503, 1481, 1501, 5, 4, 3, 2, 299, 409}], 
             Line3DBox[CompressedData["
1:eJwt0UsrRHEYwOH/pGFIkiRbe5eVNVuyMVaGlR2FLZ+AT2DrVghlMjYW1BBp
VtPkMrckSZJIEis8pyyefu+ped9zajomZpMzsRDCNJ2GWl2Lh3DLKncsc88K
D2zyyBZP7PDMLi/s8cYrQ+71ujum59rPlDmng8ybk7qoB36f4YdfDon5oCOt
0azG9URPKdoZtVvSvKZIU/ZciN5Jhornca3qmb0y7e5UtE2r2qo32qJFbdYr
bdJrbdRLbdCCJnTJvRF3F7Skw8yZL3SASXNf9F26bydNnm++2OaTDT7I8c56
9B47PXbrNavdJMzH2kXd///1Bzb/QTI=
              "]], 
             
             Line3DBox[{12, 11, 1520, 1444, 1522, 1445, 1524, 1449, 1526, 
              1453, 1454, 1529, 1531, 1530, 75, 60, 45, 30, 233, 414, 15, 387,
               304, 14, 13, 12}], 
             
             Line3DBox[{1532, 151, 166, 181, 196, 292, 429, 211, 407, 344, 
              212, 213, 214, 215, 1543, 1542, 1497, 1540, 1470, 1538, 1466, 
              1536, 1463, 1491, 1533, 1532}], 
             
             Line3DBox[{180, 165, 1461, 1545, 1462, 1547, 1464, 1549, 1467, 
              1551, 1468, 1553, 1471, 1555, 1472, 1557, 1478, 1559, 1476, 
              1562, 1561, 221, 222, 223, 224, 298, 436, 225, 408, 349, 210, 
              195, 180}]}, {
             GrayLevel[0], 
             
             Line3DBox[{968, 508, 938, 738, 522, 536, 550, 564, 578, 592, 606,
               621, 635, 649, 663, 677, 691, 803, 988, 705, 966, 834, 706, 
              707, 708, 709, 710, 711, 806, 991, 1171}], 
             Line3DBox[{510, 509, 812, 968}], 
             Line3DBox[{510, 511, 512, 513, 514, 813, 958, 1243}], 
             Line3DBox[{743, 515, 996, 741, 911, 1146, 1158}], 
             Line3DBox[{517, 516, 743}], 
             
             Line3DBox[{517, 518, 519, 520, 815, 959, 521, 969, 745, 535, 549,
               563, 577, 591, 605, 620, 634, 648, 662, 676, 690, 704, 836, 
              967, 718, 993, 811, 717, 716, 715, 714, 713, 809, 712, 992, 808,
               1001, 1138, 1432}]}, {}, {}, {}, {}, {}, {}}}, 
          VertexNormals -> CompressedData["
1:eJzMu3lcjt3XNxyKJIQyJgqVKWVIiBXJEJkSEZJMaUIilAYKiRJFSioVTaSS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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Re", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Im", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1.5}, DisplayFunction :> Identity, 
         FaceGridsStyle -> Automatic, 
         Method -> {"DefaultBoundaryStyle" -> Directive[
             GrayLevel[0.3]], 
           "DefaultGraphicsInteraction" -> {
            "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
             "Effects" -> {
              "Highlight" -> {"ratio" -> 2}, 
               "HighlightPoint" -> {"ratio" -> 2}, 
               "Droplines" -> {
                "freeformCursorMode" -> True, 
                 "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
           "RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {-4., 10.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
          "\"Abs(\\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\))\"", 
           "\"Arg(\\!\\(\\*SuperscriptBox[\\(z\\), \\(2\\)]\\))\""}, 
          "SwatchLegend", DisplayFunction -> (FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               TagBox[
                GridBox[{{
                   TagBox[
                    GridBox[{{
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]}, {
                    "Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #}, {
                    GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, 
                    Opacity[0.8]]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                 False, GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                 GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                "Grid"], Alignment -> Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]& ), 
          InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.30100577, 0.224146685, 0.090484535]|>, 
                    "RGBColorSwatchTemplate"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.2642166, 0.1833123, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}], ",", 
                   RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]|>, "RGBColorSwatchTemplate"]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|"color" -> 
                    RGBColor[0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}]}], "]"}]}], "}"}], 
               ",", 
               RowBox[{"{", 
                 RowBox[{#, ",", #2}], "}"}], ",", 
               RowBox[{"LegendMarkers", "\[Rule]", 
                 Graphics3DBox[
                  SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                  PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, ImagePadding -> 
                  0]}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "12"}]}], "]"}]& ), 
          Editable -> True], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 2. Absolute value and argument of \
\\!\\(\\*FormBox[TagBox[RowBox[{\\\"w\\\", \\\"\[LongEqual]\\\", \
RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", \
SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->1225288409,ExpressionUUID->"bd747ef2-a1aa-4dc2-bbc5-9d05339203d1"]
}, {3}]],

Cell[TextData[{
 "The disadvantage of the plot in Fig. 2 is that it uses two surfaces, which \
can be confusing. A second disadvantage is that the discontinuity in the blue \
surface does not correspond to a \[OpenCurlyDoubleQuote]real\
\[CloseCurlyDoubleQuote] discontinuity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"776b67cb-0864-4007-ab1d-a181d8d43a48"],
 " and is only due to the fact that the argument of a complex number is \
restricted to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}]}], "]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a28d5f54-5ab2-4c6b-b680-0faff9b4852b"],
 ". Indeed, the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c8b3a047-ea9d-4824-9860-9d3dfac2d473"],
 " is continuous, as you will see in ",
 ButtonBox["Chapter 7",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "Text",
 CellID->9886687,ExpressionUUID->"15796094-fb01-469d-8a95-05028ce42d49"],

Cell[TextData[{
 "A solution is to use colors to represent the argument. For this, you can \
use the command ",
 ButtonBox["ComplexPlot3D",
  BaseStyle->"Link"],
 ", as in Fig. 3."
}], "Text",
 CellID->136815536,ExpressionUUID->"9f0c405f-1936-47ac-bfe4-aacdc25300c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot3D", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "3"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["5", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["1320", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {{-3, 3}, {-3, 3}, {-4, 10}}, BoxRatios -> {1, 1, 1.5}, 
      PlotStyle -> Directive[
        Opacity[0.8]], AxesLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> 
      Automatic],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["656", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 3. Absolute value and argument of " <> ToString[
       HoldForm[$CellContext`f[$CellContext`z] == $CellContext`z^2], 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->24154187,ExpressionUUID->"f10e3699-513a-44d6-834e-ff4a8c27cae6"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        SuperscriptBox["z", "2"], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "3"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"BoxRatios", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1.5`"}], "}"}]}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{"Opacity", "[", "0.8`", "]"}], "]"}]}], ",", 
        RowBox[{"AxesLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            FormBox[
             RowBox[{"Re", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12], ",", 
           StyleBox[
            FormBox[
             RowBox[{"Im", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12]}], "}"}]}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Fig. 3. Absolute value and argument of \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"f", "[", "z", "]"}], "\[Equal]", 
             SuperscriptBox["z", "2"]}],
            HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->1494824930,ExpressionUUID->"816cbd70-f5e0-4dcc-aea6-b5c6a44b3628"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJydnHuwVtV5hw8gHnBQjIgYsXKNSawXiFghYt5VMkqoZmgxeEVjNFaIGqNM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          "], {{{
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> "Neutral", 
              Opacity[0.8], 
              Texture[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJy1vWdUlee6773H+46xEpNY05OJNTGmiCJVxYqCvQFib7HX2HvBEkuw994r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                  "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                  RGBColor], 
                 BoxForm`ImageTag[
                 "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                 Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                ImageSizeRaw -> {144., 144.}, 
                PlotRange -> {{0, 144.}, {0, 144.}}]]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNm3n81VP+x+/n3msZy9jXIcrYB6ONZCtbJEuLLSqlsofsY18i7ZihpPKN
dmX5DUpoLy2YpUKIyUQYs2RL4vd+Os/zuP54Pd73fM7+Ptv7nPfr1u/aq+2V
5VKptOvGpVIlZKMItA2cGRhRlEq3B+4IjFTeGRilvCvweOA209UF7g7cE9gm
8L8ob23g4/g9NzCPPBHuFrgocLeye+DOQFfjhke6Wy330cBNgZsDTwbuDfQJ
TAoMCAwMPK0cFHgscIv5Z0WHBgRujN9P2F7aN9o2UtZQy/5DYJiS/HdEOy60
TffYxh6BPoGegYsDIwK3l1LaVdVS6YKoq0fI4RG+NXBb4HEl6Uaalr6Ottx7
A6P8hm6eUKKbOiXp+geuCFwZ6Be43PADgcsM32e7Lgncr7zUOnrYbtrRxb6V
oq3D+Bbyh0pq8x/id1/zUe53lZT+hvj+p0D7+N0i5GT1PTjwUYQ7RbqeISdG
uL9jMz7wQKBf4JnAkMCDgWeVDwWWB14KTA0MjzJeCPn3wBTLHmJ5VwSutFxk
L8cceZV1XG66QX67OrC0SGW+yByI8h8JPB+/37bOaYGH49tDgYfj9zt+e5l5
Et+GBv4vfi+zDNr6hu2jT28q6dPISPvHwHPxe0mRdJT7QVuusc/XBq5TB70N
M+/OD1wQuD9wSeBS5+tFge7OWWSPwIyop3/ghvg9LtBXXQ+qpPXyCOVXUllj
AmMtt6/znjJ6uia6WQdruqvhh23j9ZZ7mfodYj96W9alxvWxvIuLtBd0CVxY
pD3jQstlTXYKdC7S2u5sugmOH+P8t2jzuMAs6om51q6U5tygwFWBqwMrAzMC
MwMfKmcFPgksCLwe+FS5MPBB4DXz/CMwOzAn8JH5CK8OzDf/KuPnBv4ZmGfc
GstbFGgdc/0t1nTIsa431s1T7hGsxUUR90bso+eGfDPwefzuGPJfEfdG4M3A
54HFgSWBL5TEfWk8dXxmnaT72HbRpq8CSwPLAl8rlwfWBd4NrAh8r3wvUBSp
//SvUqSy6N93gXfM80PgfXW23nyES0XSF/k3GL/SuFfVb7VI5aHLzYvUH/q6
SZHGA/19G3jb+r6xvYQ3LtL4kW6jIpVBeNMi5UMHWxSpPHSzWZF0Rx2/KlI8
Yc6P4wMnkCfm0b4hrwidVwMvxu+7q2lPP850rQO/CxwUaBXYP3BA4GTlgYFT
lKQ71bQHB84IHBpoGGjjt0MCpyl/HzhdSbqTAvtZRy/zn1lKc7ptKc31wYaZ
+wNKab8n7UDlVeJM8wwxbe/Ag9G3xiGPCvlVJfXv6vj9RSXVe1n8/l8l9b13
NZVB2xsFTiwlXe1nP7cM/LqUzoBT7d+l6ovwJeqFcA/71sr2nm7fLjcf+rhC
SdxFjg91dleSv6dloPuLlafYT9pI3+6L9m/lGDA+mzMvHJ8tbPf9kWZrx6Nv
/N7G8aCv2wW2DzxZSudiH8eHNNs6TtuabrNqsmH6hhwf5cxh/QRWFek3Ns1K
9uLAzMDZgcMDzQLnKI8o0vxDt59XUvt/p27PirjDzHOuaZsHOgSaGnee344M
dFQe5TlxdOCYQPvYV3oHrimn/X+WNs/pEca4uyJwRqCXYWy7qwyfFbgucK12
39XGtbM8wm0ClwcuC4yPvtwYckLIDuaj7vNtF21qH2hiH9oFGhvmTD4z0LZI
52Fb469RtvesaBk4zjOmvfrgLDpLHV/rN8I3qGv0d6PyPM+VFpbFOXOs4U7q
jHCrwP6BAwInKw+0XY1s96mBgwIHB9ooDwmcpvw9elYeGjhD2dC+NrSs80JH
N5WT7q63H7S7Y4RvNu6CwC2BPwROCvQIdA+cqLwocIKyW6Bl4MJAl8ApgUsC
FwdaBXqa/2S/ET420DnQKdDCfISP8Rv1Hxfoarnk6RO4l3kVmBx4OtA/MJE5
EHiAOREYFzjedpF/oGknBfqZlnQD/DbRdt1nHbT9fsNH25bzA03KaX4zHxsr
29q+OwK32/Zb1R39uc1wF+Nvs013mqeHfbrH9t5lHHq923B34wmfVk5riDVw
quvg0nLaA1a5J7T2G/1oWk5ro73fWpvvsHJab8Q1C5wTODtwlH1lLhzuN9Jx
d5mNTcm6N/480zJHmDe9nHPMtZMC+zmnr3ReEneL+wVz/2b3EdbrtkW6n2FH
sAftEtg1sDjqfLyS7lvsbdyd6tzjkNyfRlSSXYkOXivSnZB03PGwNce5fnYI
7OhesFNg5yLtaztbXzPr/I1rjzN+S/eLHc3D2trG9h6q3M71t7VxrLHtra+h
8YTZo7P9u6BIdxLszfm2kfDiIt0hsdcXFeluSXhhke4zhF83H+H3Aq8EXg28
W6S7wvTACiVxH6gX9Pe+aQlz5+CeyT11mnK4ZSAftwzkCMtCjrSMker69dD/
kEqy8x8NOTjwp/j9p5ADnTPcVYZaH3eXR3O4kn5zLzpC3e9WpP2xQWCvIu2b
yN8WaS9G7h2oHygXyX5soMTuO974fQInKPcN7Fkku7NsGdh2G1t21TBzFhtu
M8sgHpvxRMsgnnsdey5zmjsG+/UpRbqrHG+dFynJx12ljXm62gfSdTeetdJD
yTnAPaZ1kfb7y5Tk72n8ybZlU9v6UyndPT4qpb5uYtz+9gP7l/OwXmAP2l1N
83p0NZ0zxDPXuatxXuWzfXfzHG0+9Nfc8SHuWMcA3R9jfH3jfiyldrGusPux
31lbSOx61gY2NzY45WHHk6ee/cHGZ81wlyAda4i9gTBrkXzcFZgvlEd+1jH3
DepjrRJPmLaXHHv2wL7u79S3Ut1xt3illO4PXxfpjs17wDdK7ug7lFP428CO
5SS/o11FutsvM4603N3XFun9YKnp+MYaXadkja4v0hpmXe5UTumIZ+/dJbBr
oGFgu8D25fQmhtzBfZv437if72yeQwPbmqexaWnvEabdzbOMbzt5Ruxk/u9t
F236wXaxf4ytpL78L/Bc/J4U+Hf8fj7k5MB/4vczIf8bcqsopxT4qEjn0Rbx
+18hvyxSu9aqs63LKT1l0qev1fc25fSNdBusH9sW22PfwH6c4VHXqMBb8X1N
kfZH9svPlD/vo5wbgb/G70+LtG+SbgrnReBv8ftz0/JGMjG+1QX+Er+/8Bvv
K/9S8r7C2bd7oJ76pR+0G90xbugPu2gf2/qEZzhn9+JyskOwXUZ7pnP2XxDr
cFPqDVln2nvs568Cm1nWpoYPCGxeTnrd33jCewc2DmwS+G2Ut1Fg48Begarh
QwPbBrYLHB7YJbBroJnyN4G9zbcJ703VlP6AkPVDlgOVQAMl5dYL/MSYh9wz
UJjud/Fty8CvAwfaXsK/DWxkW7H39gzULyebENkg8PtymgfMl0PKaa4Qxh7b
wzwtTLuXdks941r6jXqOU6Kbg8tpbm5t/iJQtk5kxfXxg/Ougd+qlle13ay5
9a6PXVwzhA+yr1vZlp+KtA72cD0Urj3K/rFINurezpWGjsn2gbcDzwY+LNJ4
f+Y8xRZjX8j2WjPXNDYgNl0b5xM2JfYydtth5sFWa15O8xebr6lxHf2W7b6j
1HEnx4Yxwd7E7uQON7ic7mHcxx6wbmzRfkrS9ldyv2tXTXe6mdVkb/ONux42
/FWWNdBvhIdYNve4B5Xc6y6wXbQJW7aJfbjcftM+bHjuGNw/8v3kRHXRyrh5
vq/yLoq9fbzpujpXCOd7DveeC51Px6nXkywLe76FcZ3VE2Hutuy/7NnY2qyB
gxwfJHMw3x+a2NYDTdfG+EPsD5J1cKblZX9II/Ofbjz1PaSe0DV7wRfuWxO8
I+8c8pFy+s397lbHON9ROpdrd5Qu9ht9HWD77vAbemI/66aO7/Qb4XvUXQ91
tL/57zYtccx19qdNlZ+6f7M28nsGaxGJr4b1h/xnkXS/X7m2533uPs0+8ol7
PGuUtKuLVMcazwTWLd9Id4vzif73cX4wd7jHnG/cY+WUDj09qs644wxVknaY
knTDTYsuR6kX9PS439DrCCW6HKkkHfYIdglr6T7bwt3tSseYOXWV8yC/i7R1
HtEu1jbruJdpSXeN8fk9BtnBtne0n8wV9oiznTsdDN9v/bTpsFgrO3tONA3s
ZLhJYEfD70a6lwPTA+8Ephl+OzDV8PLAS4Y/CLwWmBFYYb5XAu8pXw18FlhU
TmfmmsBCw5/7bUlgWeBFy11peTOZL4G5gXnMo8Acw/8IzDb8vvXQjn+adn7g
k8CCwOuBDy1vVuBTv9GO1aYl3ff2gbavV1L2D0r6OjnW3p9D1gv593L6/ULg
q8BS+/G1Ej11qKb1PLua0rFumYNz/U78M+W0Vz6oDohnbj5jHQ1Cri2n30vF
C6ZdV05jRrt/VHf0dYPtJcxZ/pE6+8l4wt85xuQ/V5/C6yG/se2M+bfKd8wz
S70z9qwZ1hbrcIE2GeuVu/rP9+BS8l3gSxyvxMc4QYnvsTHvxdG+6fj4/Mb7
9NOl9DaNf2aS3whPKaW3bN6nn1E+GJhsWuLwGYwqJZ/n9FLyleJTfT/qaBF1
da0mn8TLxq9QcmdYEXEtI023kFNLyY/5mGmHW9Y0vw03D2WP9L4x0rrHlJKv
Bv/NDNtSV0p+odG+E+P7Gadu8LuMNTzbeHw+c5SUt8C06A9/0UR1s0iJzpao
C/T0umlJN9cyqGOxaUn3hmnR5d+0XbFhD64m+/KlkMuryY7sXE2+IPwdL5WS
r2WausHXMtXwTPtKP9+07GdLySfzkumeivIeC/y5SGt+qPNpSjnZJawHbOtB
hvEDHxM4NtA70D7QIXCt8ix8vIGzA9cFjtKW3SMwzTnGXOvm+L4T8uqQbQPt
AtcoKffIwO7m76kPemXIm0N2DJyvPNJ6OqufpZaNjY7N/mLgnMD15iHt0eg0
cG7ghkry7R9t324KnGfZN5qGcPPAbrbpCO16wjtU0lpljXbUD7jEMVzjvku6
De4N3BlWuy9i73/sfomOStr61PGj+0Rj6+BsaKQ9u4P3iU/cR7lXIKnvOfep
farpXFnnnsq58p17FWV9697DOfS9ey1ls2/SH/r3g3sY95W17q/Y1F+5v3K/
We/e3MI7zF7Oj/qGj/EOU18d72F4tfsTexbnEO/GT3seTDTM2cUZz9m+xLnI
3OTcmGC6N/zG/s35Md64s93T51fT2Yk9ge2AftmDV5kf2xo7ekw52Qqc1WOV
fW3TQNfAU+Vk35Bumvsu5Y4z7QO2e4B5xvstv5H3s7755iGet7NVpeSvnWfd
xHGOYvdw323r2Dd2bXHPbOZ6O8ww66+p4XOdo81/MXePdB00M+4F95aDXZcN
rYO118Sy2lknYe6lzFPmLmc492ru3NPVK+P0qmNFuzmfnlRns0xLeK66pp/c
aRmHj427V/3OMR/pZqiDOnU8zrzYU9j6rR2PMTlPlLm8kt5P2IveraT9ifsf
98AffVchDW8lvLUsMz1+0+NiHNZW0jsH33mT4W1mqb/r/M3bC7yZLpF+XSXl
61pK3BveYHnD5f0WP223Uo3/dFcp8YHIB18H/lDmSxGHvxXfJbygzPXhDOvu
N9LhS+1juouNJ8xet6KS9l7acYd1sNe9V0l7ID5UfJT4VNn7/1JJ7zlj/M0b
Dlydv/ob3+jfA7Pt+5uV9J6Dft4y71B/8x0/Lr5u/LrfVhK/A24RvA/4Hx/6
9kX5vH/hk8Y/jJ8Yfy5+Xfy7+HnxA+MPzj5gfML4cvHp4vPF14vvOPt+kfh4
97U8/ND/raQ24T/PPmDyw4Hh3gpnp5HtPdNxulPd4R/HXsJ+4m3sjUp6H3tE
PfB7fSX55x+tpjLw7+PDx8eCrwWuyx/Ny3sXvpUlgafU86JKeqs/03y91N81
loX+ehuGN8GbOm/rvC3zzs8cgy+EPwm/ADwb/Bj4M/AN4YPI3Ddk5sQNNT88
DN7kKRd+Bm/dhPEz42/G73CG7cL/f6n6YF5m3//lpZq//yLbiz2Y+QvIzH1A
DrIs7ElsTXwdCyuJi/VTJeUdVk3zk+/YJ9TRz/G4wnz9SjX+xAD1N8gwXDc4
bxsqNc5B5iD0dJ2dYHtZl6e43kjXxj5lfsRl9nuY40V7TrcPtKW18Zc4l3uo
i8wvyXyTk0s1Hkor09JW7MBsXyMnlmr2+rhSzV4fb/8mmyfb31PU97OG+5pv
rPqeYp7+lj3Bb9idS8zzpuGRcp9GVNP4z3EOEAc/B05OX7kTm1cTRwk/Ar5G
7E/8CN/YlrcsN3OYSLfc+K+dQ7RxjOm+tI77/IbNnXmWw+0/9vd847Gn51jG
PMPjjJ9nP183z2T7ulgdLDQu2+4L1eliw/jZ5lfSuxb+twWVxC1kH+PtHH9p
pZr6Obya9tkRtvVW28v95I5Suo8Qx/7OHWRUKe3d3C9Gl9J+M8p07O91puvj
mcbZ2Ed9kGeI48Lax/7/Tr1zn1pnmP7D18qcMuQq9YX8R6nGsVtZqvHqPlF/
q82/wG+r1dEa080wH1yxWaXkK6Os2ZZN+HY5qEW1xp1ibbGvs64yPwvJOmH/
Zh/M3Ctk5lidbv6hjgV7xRDPWdbjwZZNua/ZLvhr3A3xRXG/vNf5umk18Sfn
Bu4rUlvxZ2W/H/JH8+MLW2+f8HeRDr2wB2eeHRI7LnPy1lnnesPom3jy064N
lgvHk3MIzshK69zgHITvBu+NuxprJt/5kPSBs4u3V7ip3OXeNl2+S+e7NZI5
ssjyGL9X7RttnGY8+TNPkbrzvZfxhKsDnxV+KFydn8/OIq1n/Ij47FnT+CC3
t5/4LvETMi/xLxJH2fhG8aHSFnyt+FWpj2+E2QPwpWY+IJI86AY/6G6OE37N
3R0P6slh/KzN/YafFT8tPCP6ABeJ8cCHmn2byOzbRNJWxoB6si8UmX2tSPKP
1udbV02+dThJcJHYB9EHvIV+1cRh+HU1heE6HFLUuA6E0V9Dw5QNZwK+xtam
PdjzGN85PnbO530Mo7t9DW9k/F62+wjL2k19HGG7Kfuwoubjzz7/+o4Z+/L2
tqtqeQ3UC7yNzPtANipqnI/MAWlquu2Np2+cFdvYp3qOCeOE3x7/Pbyw7OPv
ZlvwhR9j3S0MZ+4C4czralXUeAwtixpHIXMWjjcOngF8APgB+5uPMPwv+ACt
1Q3crbOKGifs1KLGCWtT1DhhpxU1TtjpRY0Tdob9bmsYPbUzjF7aG0ZPHQwf
Zp0dHM8Tf9GHbuoI/swp9pmxhAt3jrqE7wPHgPl+gWHK6K5OMx+ie1HjGp7n
eB9T1LiGnczf0jHpot47G4fOeloW7bjYMP2E/9erqHEsLlVflxtubp3nqmvi
L1GPV5gOPV5pOPMIrypqPMKr1W8v02UuJmP2K8cY/bFfHOA4c3bP1oahDrjo
D1hHf8P5vwf9bSvxfdUdHP3Mo0feWdT+nzDAPmGL31jUOPG32z/KyHx/5H1F
jetPuX/0TpD/X/CIdwr+yzDU+xT/McBXju+cOcL+e611w12a6Hjca7mMRx/D
9I17wPiixqGEU5n/2/CG+uMbZxDzhnvCzbYdDtVY9THeMGfmg95fqAMe2Wj7
R9ox9h9e0+NF7f9FhPmPADwo7iS3GT/cdlNGXVH7D9JI9f2E4fy/AsroYh2E
ma+32O5OxhPualnUzxwa5JjdbT2Uy5ziTMv/4Rhsuo7qgHGdrO4XF7X/I2UO
Gd8W2We4aHOKGvdralHj1cET4z44034OM/4l63/GceY+BpfrBdsx2XoGG/9z
WyrpDjnbPlB25ugh4ZFxxnM2cFZwrrIOWBucpewjrA32GuYR5+LZjv91RY2X
Nr2o8dJeKWo8tmlFjcdGOP/nhz48pD2CbcD/bgZqP2OjDdNOo3/wepZaNnyY
92z7B4ZfMJ73Ad6oh/sWwX92HvPNgXmNr4P3Q9bAQsOTHJOF6mal5V5rux60
P9S5wj7AHYJLNNQxoY1w7QZr88PBG6LNyRyf53izHuYbHm9b5lvGcvvJOL9t
eJr1vF3UOIXU/aR2FnY0bzzcCerEzFKyteFA4MvOnAhk5oMg8SnD7cB3nbke
yMz1OMT8+HDhvuA3hm/T0DzwIvYzDl/w/obxBcOpgPOBH/wA40b63scbLW+K
vC3yNsn7I++SvEeyv410T+P9kTf1/B6JzO+U55p/lO+er/rmN8Pw4ZZNuVvY
V9oBHwReCPwhOCBwQTLfBLmrfYYHcKr5eDPMfnhkq3KNT5D5Ba1NR7/hL8BV
gLsCHwFeAtyVloYzJ6aleqG8k9TvCeZHpyca3s94wpkrk7kzyMxtQdK3jayD
OpuqV95oM4eGdm1ifbQXDho8iMxTQ2aOWyPHu2I+6oZvA58F7grvv7w18x7c
xHraed8d59sde9x495+P/A3PgPe8sa5T3lX5DedslnnZ+/AN4JvBV8D7K2+O
pOUtcaLnXZ2/eWvFZ4AvAR8C3yf84v1tpHvLaNcN6+TVSnpD5P2QPXmE5xTn
G3et692jHjbvQH9zn5ltevq3o/3n7Tv/z4T76yjbwNtv5nhlztfhlZpvH8lY
8eY3yjOe8/wJ95M37Q99gVMyyjIfMQ164O0ZvfAujc8q+7vwoVxgGL10MrzU
MtHbW+alHPbL0e5dQ/3N/omP6chKza/VvFLzax1h3/a0jqPVRTvnxx5+o10N
HE/GibqeqtTekPnNnv8Xx5p665mPund23mW+ZFPnLuu2mfMSPsco9xt4H/ga
MjcEiQ8m8z8yH2SE6RjzmY4vfAx8/fj3B/qd99K73Guo4xbLwweaeVf4bOCE
wAeAN5B5KvhK4cGwb7Kn4n/f2PWK/73qOoMv80tuDpJ0+L9IW3VNwjHJXCdk
5iIh4S5lrgztyPywzBdD4huB3zLAdtN/fDMvq49XDNM/fFdT1d/LhtHVDHUy
wN+sm+wPw7+CDxhfG344fMPPGB5medmHjIQX8bQ8jclypeBLEM5cNMqAh4Nv
LXPWBtqHa4ynTnigOztHrvYbeeBB1Tl+j1ondeBH4s0sc0JHm45+8a7NXSBz
odiD2cfYczlP2MvYiwlzPsNFXOeZDRc585eRXxc1/nHmI39nuqed8/9xfbPO
2Qcmujb/rQ2y3jqWWR781ynupeyN2EDwdtlLlxq/1nMPbiFcQ846eIusGcpj
/bCvZw4oHD9sE+Yo825Pv8H/290y4DLSdnTMGUKbKAO9Z/4c5+ge5qNu3vHu
d4+cb9nMfeywT60PPXEOcf5knjdh+oH9gc1Cv4knjK+NM/5L90Z+Y3dkHhtj
A08NG4W1B1+NeMLohfIy3xmJ7QO/Gj8fthL8avx/2FCZi0wZmeucuc9r7MMS
46lznv1j7iz2G3mwWX9wLBkz6sRew+eIXZJt0A2mm+BeTR+nV9L/BvnPIO95
2EzY0K9Ukm7xf8EZgMuQecd7VWp8YSTnZOF+zd6MH5+zHJ9u2Xji4Bjh/8fv
n/lV+P5L5mNvzlwr4uAf8G139YXe6Ndydfgfx2eSuqUf020ztgL9p+9wGXb3
nIG3sLf9oR7OG85SeAa7ef7Qb/q/tWcv5zp+P9Y2vCs4WPiB8aNnnzky+5aR
c1z3+J7xV+Prh1sAdwC/+wLzT/Ab4cyZg8eF3x9eHNwEztZJjhfv1fSTuT/J
eMplH0W/cLTY/+BuZT7dMtv9lO3CNz7NtPC62EPhMcBxmOo38k/2G+2Ybruo
YzvH9lD3kqcdizH+5pxlvj/nPjPXOcsawpeLzcaex/9r8UvhjyL9847zJPNu
6Zg/b/mZ/7Gt85rxxZ8OlwSbCV7K475B8/Y8yrd43pvv9j/aG1XTHGeuY4Ph
H5jqO3fmb/Fm/5hv08QNtzzC2Ej4ZbCjnvBuRB0jzEfd3B/edyzhsuzgmuAO
ASeAewTzHrstc2SQcGQyn4Z5Ci+h4hpiPTBPd3Ffn+L+jI4mq7dl7jPofKxp
sIXgylA/uoNDUXXtwn0ou3bh8lAnax0eD/wh2sFapV3oF+7FRu4BH7o+WVtw
DDe4blf6jTA8F8rO3EMkeV4zDzp60vnIOuEO9qJ6wmZ7zPbzLsH9HX8TtuVQ
59gCf2eblrHB5lxoXmxO/KXk5U5PP7CLmzhXGrtPsSZW2V7WMTpC99y/H7Uc
1ihj84nr+2Pz1Lm+Z7ieV5uftcIYM7ZDLIdzf77tzH497vnYPNxB4XvBB+Pe
A78NPlrmt/V27lzr/Ml8Nfhr9BF7F1uXew5vPdx7nvQ3bz746wapQ+4FrAHs
f2x6OG2Zd3aT7Rho29DtXy0fWwAuBzwOxmq2OvvI/euTco2f86FzgXqH2HfG
a7D6nGH8B+5NrO215Rp3ljB3J976uEvd72/eMN9VF/BMFlo+fV/h/KF92Nf9
1S37HPOYfQI9v5TbX0k2GW2baZ+x1Xmn5Dv2Z+a/so5ftE7m53K/fe3+CO8O
rh1vduj5Rsd6oDqcbd9pzyLTZh70GufWLHWJ7t6zncyH/wedNF08
                 "]], 
                Polygon3DBox[CompressedData["
1:eJwlk0tIVlEUhe9/75Yekj0HNQmKNCsq0hIhAkud1EBSQYkKEwoiSER+yOAP
GoSDMKKCoqJBMweCSQ8JIUQiItSiJCJCopmaUAoVFfUt1uC7rHP2vufsc/Y6
G9o7Gs+mSZLUQEA1n/NZkhyFk+h78Jr5B5ChJ6GU2CLloO+GY9fgH3PdjC+g
C/CHcY7xbfQQXES/gcXMT7PpEfQZKCe2GaaZL2M8T2wV+iF6NexVrubQ7bCf
2AH4iC7AncR76ABaU2vPwAR6OWzLJckyaECfgmP8exw+o6fCugZOoIfhMLoR
9oTvQHehf76gd0JF5pyn6CJ4wtaTcCm8htZSjZ+0FrRQSys8Q98P1zJH/hL0
KFwnlocmdF5rEGuDn6xxg3ETejd8YzyT+a7qoYPYvnCsEq6ir8AO1t8Oveiv
5BcT2wKnGbfCGHuNwyv1Jty7LvhN7ki4FtWs2m+FY83wg3iz8lPX/By9Fs6h
b8I69Sacq5pV+6/MZ5En5I1OqEPXwvfMZ9BZNLfA+G9m76in6q3OpLOtgTli
LxgPpK5BtWyEd6k9M4heCQdz7rl6/yHslU3qeRhpefh9uAfqhTx+CN0j/6k2
WIreGvbiLngs74Z7rRzlyiPySidUoYvD/65g/8voofC/8oy8ox6oF/L8LHNj
Ya+qJ+rNeniU+kwD4TvV3WquP/wG9BZ0533ol+Fe6k5awm9Sb1Nv7C26JFyL
PCFvzGe+e3lMXtOb1NuUhwP9H+sce2A=
                 "]]}, 
               Annotation[#, "Charting`Private`Tag$13627#1"]& ]]}, {}, {
             EdgeForm[], 
             GrayLevel[0.82], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJxNl1mI1mUUxj+//5ummQtkmmbOuI45aguZS+UyLrmNIuRuLo2m5kbouGSm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                "]], 
               Polygon3DBox[CompressedData["
1:eJwtk01IlFEUhr/5PGQz9IMLJ9CkhnQyLMhCpQmMxkEiImOgoI2muJJwRMSi
mSJCIsRN+FNDBC3ctRCtdNEuXIiLJEdaRItwrTi2cNEiel5Pi2fmud/ce79z
33sm0ZfLDoZBEKTAYJmPBR7MQw2+Ctv4FpzEU3CQeVG4j/fDUEUQ5OAzHocH
zL0LWTyESeYuwFv8HHQwtxd+4Ht8t/LbbXhlvof2ugXn8ePwkb1m4A5eEMzt
hgw+Amm8Htrxv6wbCfydbxg/hSKeh078IfTgVyGNl5kfx1u0hvEZSPIsA9/x
Bojip2Edn4ff1FKCE3gdrIWekbKaM/9NNav2WvMsNWcFX4IunQ2a8IR5tjHG
X/H35mdVhsryk/ncKtWAfzB31XAKPwZTod+Z7q4aRkN/9sV8T+2tM9Tj47DL
WUtwAz9gfjffoNI8k/1sYNQ8M2WnzJ+YZ67sleEj84yUle70LP5SNQSeafl/
ZspOmTbiP+Ee3gPN5j2gXtCzi/gveIwX4BK+ae55aNNa895QhsryOWzwrkW4
jl82780YDODT5nerHlOvHWZ8JEKtMIuPma99DdfwPxXei+qhIuMJOBrxzG7i
V9QTeBKG8EFz139C/w1lqCx34J15T6o3tWbY/B16l3rymfkd6C50hhf4IfO1
qlG1XjDPSpkom39v7mmt
                "]]}]}, {}, {}}, {{
             GrayLevel[0], 
             
             Line3DBox[{998, 1, 994, 902, 31, 61, 91, 121, 151, 181, 211, 241,
               271, 1040, 1104, 1164, 1102, 1162, 1100, 1160, 1101, 1158, 
              1098, 1156, 1096, 1154, 1097, 1152, 1094, 1150, 1095, 1148, 
              1092, 1146, 1093, 1144, 1090, 1142, 1091, 1140, 1086, 1138, 
              1087, 1136, 1088, 1134, 1082, 1132, 1083, 1130, 1084, 1128, 10, 
              9, 8, 7, 6, 5, 4, 3, 2, 955, 998}], 
             Line3DBox[CompressedData["
1:eJwt0ktIFlEYgOHjDVJTU1sYlKALF0K1sYiiRVtdhF3Q7qRkSdiPZaWFSISJ
RBEiESIKlYuCIioi4rcokYgSCQ0tjZJ23UALLMrsGXDx8DID38zh4xRUxbYc
SQgh3GMx6XxLCqE2OYSvelg/a51+0Zj+1Hqd0WP6Q4/rLz2pv7VJ/+ppndNm
DbSQwBmSOUsKrSyijTTaSec8mVzkAisdtoxa2hj07T4d0gEd1SmdZ0ViCBvI
NZfDDW6SxzJucZt87lDIXYq4TzEPWMVDVvOIEuKsYS31/nk02gUNvIv2wQQn
mIz2QmO0F06xztwBPlHDFAf5wH7eU8UE1bxlL2Ps4w27GWEPr9nJMLsYopKX
7OAFFTxnG4NsZ4CtPKWcJ9Gcna1nOf/scdx5P+qIPtNXel3PcYhSss1lsZlr
XCWVMnrpIYlu5s136R+9orN6WTfRybTnDt3IJb57Xur65JJDNo+9W6L9mqVx
zdSMhXv8H64QXuE=
              "]], 
             
             Line3DBox[{22, 21, 1167, 1007, 1169, 1008, 1171, 1013, 1173, 
              1014, 1175, 1018, 1177, 1022, 1179, 1026, 1181, 1030, 1031, 
              1184, 1185, 1036, 1037, 1188, 1190, 1189, 300, 270, 240, 210, 
              180, 150, 120, 90, 60, 907, 999, 30, 995, 959, 29, 28, 27, 26, 
              25, 24, 23, 22}], 
             
             Line3DBox[{1191, 601, 631, 661, 691, 721, 751, 781, 811, 841, 
              949, 1000, 871, 996, 985, 872, 873, 874, 875, 876, 877, 878, 
              879, 880, 1214, 1213, 1124, 1211, 1072, 1209, 1120, 1207, 1067, 
              1205, 1063, 1203, 1059, 1201, 1055, 1199, 1052, 1110, 1196, 
              1195, 1046, 1106, 1192, 1191}], 
             
             Line3DBox[{660, 630, 1044, 1216, 1045, 1218, 1047, 1220, 1050, 
              1222, 1051, 1224, 1053, 1226, 1056, 1228, 1057, 1230, 1060, 
              1232, 1061, 1234, 1064, 1236, 1065, 1238, 1068, 1240, 1069, 
              1242, 1075, 1244, 1073, 1246, 1074, 1248, 1081, 1250, 1079, 
              1253, 1252, 891, 892, 893, 894, 895, 896, 897, 898, 899, 954, 
              1001, 900, 997, 989, 870, 840, 810, 780, 750, 720, 690, 
              660}]}}}, VertexNormals -> CompressedData["
1:eJztfHlYz1v3dsY0CBkyJiRCpkIybDJlniWVIRIyz0OmDA0ic2ZCJFOZSTYa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           "], VertexTextureCoordinates -> CompressedData["
1:eJyF233MnmV5gPFO+SiGLPYPM0TM5NMwmTCHDnVwQxgFtyUMxgQhDnBDO0AQ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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Re", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
              RowBox[{"Im", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
              False], HoldForm], TraditionalForm], None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1.5}, DisplayFunction :> Identity, Lighting -> 
         "Neutral", Method -> {"RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {-4., 10.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ
igyJEhkP5ziZxzgcZz4kKal8zvcP+P5wr7X3Xnvtdd/X3vf79bq2yllfa3cB
Pj6+Ft7g543/Oy7qHRx6Kd0C4llZdlIqDfzG16QNdzDwJ+hzS+5FAtTfymjd
3EbD8UVhOfcQBmaYi/fT/NqxNmKljQt5Eu7j9ST5GgbEprd9ctpOwsiZh4ty
PpPYLFof6vCXgYUrVy49d+3Ak0XS1Rdik1gbl6KgDSYqRmyiW1aR4ayvNKGY
R8Xx7XXnkyOYOLRRiZPwhgzJKTua834qbAM76fc+MMEXO/vB3OQz9r9hfP33
ywRCLSXZ2xaZGE+JFamu/YwPCaLiViETsGwYux24h4U0+plLDls6UdPS0PVN
dgJ+YfwVp8NYEBBteHE4pRMOgt2XT5SMI3G57cbZdyx4/yy/Fc7pxOHGxgz/
o+PYopUdZPCLBRGRrps1O7uAu1ecTOkUoHtOStOIDYfz7YYvwrrQbh5k8CGK
gjz/FbtJAWyMuZt695Z3QUKWzBhSoqCTcWqtbikbqdNf6cWTXVB0lw68Vz6G
J7ELlebTbLASiseSJLpx27t+bvDYGMiOqdNrdTjIVKsrJ2/qxgrt55H59FH4
PpGMK7/AwTkp578F+7oxV6Qgwb06ioibUvpSzzhQeDUh/c+xbhye22qSvXoU
VSaJ/lsoHHQ95AfTphvWr60yHFy+4I+uWrP8Wi64N+2XuG7qwQ/nHMtVpBGc
0x7p7VfiIl/tAPPcXA8k/ApntHePwNJJaTpBkYvxTxr6eyt6cbB7FtHPh2Er
bb3OWIELK4Ho9Ys+fejzb7ERkBmG3hF64MhqLu6EFDreXNuP6uKyU9dCh9DM
2SMcKMdFumuwd3pjP1Z4KKtSKIMoXfFiQEiWi8hu4dn+8wM4beeT8cNsEO7b
IwXjZLhYKWky37NkELlVOyxS8weQfoc/WViaCwdVTQnxtEFEBT5JTRAZwEk9
r5QgKS7clJ2DqRpDiFW2ouW79iPg7A+FMUkuxJsiG+tKhvBtEyf3SXUfMkhk
/b3LuXjDnn3/02gYi04bvu5a2YdPzarsFHEuXGbnJTqrhlEb90thrVsvbCLF
7ChiXOieqLybYsSrl6JpJvd1D/KOPI5QW8pF2rIZv7CSEZSMmGaaLHRjW/fv
QBcRLtS3ifPXaX4BqTWn9CG6seusumWiEBfRJLHolIwvMGTXlnqHd0F4qZpU
pQAXh07NMpKERvE9f98yoYpOlLN/knr4ufCh3/Qk7hrFvxySbjL9Mx4FZqaz
Fznw0Ta+nujHe99TOfIKKz/DOkUwbP4PBzW3w/bUskbRvrmLGfaOjOxp1a9m
9Rws7J05Qj07hoje6+LyZ8mYXHaRWxDDQUzEzuVOPWNINr91qEqIjNGtJg/U
LDno77q+LciMgsCMk5e0nnVAPaNDoUKaA83E9iVhpRRMmrhbbdrfAcdjf+67
9LNhYJ8q/3zNOMgqzxLZlSQYewZvV85mI+ls7Ij+jXF4xFD+CxgnIjimQWXO
jY2pfIWHh5m8fXiuvMxQiAhTf6OoCS02Sh/98lU8OoGC9mQhxzXt6NwoHMWc
ZsFGo3SR8GIC4fQInUmtNvxYZW4hWsHCfm6qcoQ4Fbdea2QXahMQlLcovoe3
34PCJK1sLlDx7fNolplKK4o3a36N28/CGbmoTR6fePnCJkYIirTgqFyZ+sxS
FsInxeu61kxi0XT2fNtgE8I8s4f8Opj4e2Ez7XXAJFadCnX9ldkIxyaOiWgq
E7m2vy6tapvEufg4Tw3zBhRl1cRWOjEhTPwYIa1CQ6GgdX9Hdz20uBaTkRuY
oBziJr73p0FURevtJ5M6dNsJ3nJjMSBfYNik0URD0dSEv8KNWug/j8w7XcIA
68UJPpfVdKQViXJd19bAYvJx4OVgBq4LneDk2tEx/4kkXk+thoWi7W2FeTpC
p6y/kZPoqFPVfFP2phqEXa3dcsF0rPI0lOBvp+MuKePCwbhqfAsRZnrP07DU
AUnmQgw01iuuibpQjTjWtgNKV2jQ393kUrWLgbBNyr9dj1XjhUymmerCJBSM
5/54+TGgkXbnBMO4GreHdHUiQifhNrL44d9cBu5HnHkool+NfwcLpPX/UhHw
LXu0v4vHgV0O54p1qzFG1mfvuEqFYviJjDJBJqR+BaU28e5/RbQKSVlCxULD
oInMVibqxTzvG+6pxmOqufX+GxP4xJS1FTzNxJjA5YRhq2okDqQ17xOdQNob
sTvJcUx0O/5tTb5YjT2vUmfj48YRsX9ghljGxOVEpxV6vPVWODMea0qOI32L
AbNuhAmCXYD09ZJqXKmvtBBPpqDXzg4hwizIqpgynUarMV99XtxQjoLbxz/q
C+iw0Hm39GaMTA0W2/0Tn2aMIVNh4pq7NQuRukyjNssaxDB2i9usG4NWafWV
osssJHslqU7F16B4p4H6nqej0NPKnh5LZ8GVv/FdWVcNsp8IjDtrjWLDim0n
JatZsC1JNR1Xfg8+J4b8GV5OCz+cC7rUxcKoosLwjdBavAqdfmz7cATJO1qn
jdgsiNX2Nz0lf8SZrvPf5QeHIeexkO0qwIb0/SfdBdL12KW8JjZr9TAubJo7
9EOejeMnj51vPPAJSWuPSH62HYLgi7b7Pzaz0aT145zbxQZwfp3WyEkaREb8
UxmPA2zMIyn0/LVG5CTyKc0RB2D+QXqHhQMbHQk6z44lNeHOYmxUpdgAiqPs
z+b5sHF3pnzueFozbEx7iW0H+nFLP60vNIoNSc4tO//7LShSKCNJX+3D3Dou
kZTC416vrEL0nVaU1sZLXnzbC8Pxa265+Wy4/6pU3x1OgMj2Uqm8rz3Q3xL7
9FcVG9T5zir9C23YutPxbKZmD454bbzd18ZGt4DmHaZlO6JcpLxknHm8bHXl
3zvCm7++27uezUSk7d3AR77bBX8x1vDWKTaCBWf7HcRJ4NPmBt2q70RIPJNZ
vshGyO4dzsQJEoQfi1nTZz7jSnIjhSDJgWs7+8AHxw6s6lEQiFH+jFPm5H8D
lDnQkzbhP9nQAcG2y2TuQTKSHee2l+tycClnlM9Km4xGjUX1Wz4dMK5w+pS4
m4P4fT5v6+6SoaImHbpfmYTesh+xXCcOWKShe+1SnVh6756OYC0RWkp2do/C
OCgmerLLeX4RQ1RP4j9FREJa88KTTA40ZlKvJPd3425v327GVDsqaT2HFqo4
yG5353fQ7EXE0hvTLuHtMFs6L/K4jwMPhSAPU68+NG433sgn3I6SjZZzqd85
YB+L9BXL60fG8uSLJ6PbECJl3T7I4+fJS/a/hQcGELj9nTzjLwEB9MTdXjpc
0Dd8bbcSHkJV55MBFV8CvinaT5kf5AK+xucJ2sOYehm017mnFQvbPKO8z3Ih
RZxe0LccgWAXLX1sayt2eebdGQzh4ollvYSa5xeYrvG+RY5ugcSHyqzEe1wk
LP3sKm0yitPLbeZ0ic2wdKvZEVfERa5cOKWrbRSxMo1FbaLNaDNl97XUc+G5
ZfuQiN0Yav+6FpkYNCHYxZB9eICLZbsPPeoZHsPz4Pf3h/5p5HGf2Sc+zZtP
08sV59woeGB2vuaqYwP+WzSflxCawsLM0es9DAqeCtzIjbP+hJWBazIt5KfQ
QSoNNfUZh5B8TGGaXj3yu+wFm7Sn4NB8c0fL13E4OBNitWY+wpv0wCMEUyh8
q74lxH8CC0mkTfJ3a2G/wi5fTHwKS7pz9JPaJhBMDqGzNtXCtmOTR30vF/LX
DoYmr6eiNetTn3H0B5jU5tRnP+ZCVDx6Y3wwFZNv9F72Fr2H+LhwQroXz9cG
IzQTiVRIOG0zEyfU4M+pJOsCAy5WB++zf6Y6iczHhHxNXm7NGa48QODx/4QK
M3+Ixyva1v+8TrPeQbF4jdn3TxyI8gVu3NM8iQTqZG8jqwqyT6t718VxULn4
XL1bngYW2+CA+ehbnuf4y5lZcdAcF2hUeJGGtGMq4hlNlTha8KzcUYbnoSI2
x1uqaAjWVKPvelSBPJ3NM6d62bj/b2GPoRgd11JVd/3jUY7iVLVbO9PZuPjj
Y/rfk3TU19xMTVlThueLz0u49mwcuav/Y0MeHZuJJ4/q1ZQikvBgpQ8vr/yJ
Rr2vZ+mguTk/DNlfAu+9ki9e9LIg9w+7snAfA8GxidsKCl/B+YVnX849Fq5+
j69aHc9A7BM/Q7eRF5AQG9bZY8VC1cLSnL/9DCST6k7ELy2A93n+oAAxFsi5
JSNn1Zgoa7JeT65+ikWHoOwd9Uy8P+OZftiPiXzri2J/vj7ClIlYSsgV3jn/
tldVVUzML2msz92Qhkyb9hV7BxkwHzjke6eSiY+thAvFOg9ACBw4mrqTAX6C
kWEFjz8//a+ltBzNhNcZ55/OaXQoqmsq7SxhoprP6urN61lwk38f4TdLQ09f
+PrVxUwkbW3dUuPxCMrcu46PLGnQeRthevw5E/Fd9sYKD3JQL+6jXfNsEvq2
Ix6cXCa+usT8Xt/zGCz9Q6nxv6nQrbXwpj9k4o+NSEKu0hOkPvrO6TxGRWjH
ElUznq88pZYZRHk8RWzYyEWTRxOo34Ejoom856vKhBNePcMEVfZ7FGccd2h1
OXoxTJjOEkLfzOXhwX41o82G42B+N+us5fVpAcLR7ro7n0NiTovYHkpBTjYn
quoyE6eFDpzTCSnAa9kb8u01Yxi/VHxI2ZsJjZ1P1ue/LcRKrzfbQ+d5Hrvu
ffn0WSZs5QItUr8XYem812r+zaOwWz1zTO8kExsK7Pd+1y3GiWK/5HtVI9h8
al3SFwsmfovlN9S4v8RGvfab34SGIfow5OviXiaowwKTcxavcLtSMy7GeBCS
y9j9SduY8NTLyvxIfYUQm0tKwfb9OD3p9jJdg4njK3a47Al7DQ8fRb0Z215U
aRkSVykwkVC5d8BLugQ758oF/X73YKD156CzNBMF73UqrB9Xw3hN3ZBZdg+u
ZVW0FoszcaVBJMTUrg4p/I+Lt+/pwdtmvo9CwrzvyF65cqqqAfrXWUd/9nWD
duc21XWRgZXvm/tZ1c2wcqfpGft2w150j0vLTwZkGEcl/wkhoG7nJk4+Xzds
+lRtt88wsHwpbXS/KBHnDkbY9t/uwjTpP24BzxebloWEvzbsgNj+jYoO0l24
8iDBWoPKQFZDZOQxRzKPi1+anyV3wttF8HnhCAMZuwNdu/w/gya0YkhNohOk
0zfkjfp4frkgVON0rRNCkxHP1kd8xrKUKUIbmYEyvS0asbe6kC2YHESgk6Fk
fJB+gcAA5c2zrKwYXn8TIGK99hAZ077V9yUbGOjY4DeVFdkDFZtYOjWrA/Kv
Hi3WvGfAsvQinAN68eG1r7YpmYQHHn5HAioZmLhqlBHr1gd209rhgYNEEC61
Pzbg+a7lZt/dZcf60eFA8X2W3YYTqRG6i4W8upk1ZZ80HMBOlrLIalIrVv6+
JPf5KQMXHzIEhhUH8VQt944sjxvcR9XRxdkMmOQsmcz4M4iZl/lGTgmNuNec
8PReOgMnk2WfUYaGsMc+8y0howkb2HSv0QgGflaAeFpwBKpBOqcEbzajPKsn
UuscA2oF6buW8Pq3aHfW1gCbFtyXltS6ZMGA0jsT9Q0bRpF62u+/EuFWzJ5p
KarSZ8Ar/n5MR8ko1ji9in6V3YrFgEZrfnle/WWS/A32jqHq0xIL5joCrm91
OGe+SMeKS075IW1juKZKK7kSR0Bjq//WO1Q6lN4rxTaeoODeX5mduqME7N9b
JNJJoIOv8oWIAYUCasXy5njlNjA0zPTlS+hQVrc+TPEcx6qHtv6sQ20Iv7dP
8DQvb6QYjgcnZ8ehYXVki5NLG2p3nenIC6cj29rR2C5sAkKvKF+aedcbSQas
aTc6rmS6iBwQosJ3hij25XAbdOM1C3cdocPicGZU/W0qOpe1msuva0OkULRH
zBY6gqTe1Y9KT0JFrOjvmxECDkjdCuuVo+Pm4Am7ggeT+L3uzLLCGwQoSZwz
2/iXhtVmpV7avL5I/nLdoVxpAmRhpxI+QYPEqObS//JoMAgLuUqJbsXb4Fyf
nlYajI4VqtzQoSOiwVdDb7gFad9LE/Vf06Ate/C9Tykd/9//q/8Byu2M5A==

                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 3. Absolute value and argument of \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], \\\"\[LongEqual]\\\", SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], \
HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->1842150106,ExpressionUUID->"ad61b3a7-0c31-402c-9818-24f93baea699"]
}, {3}]],

Cell[TextData[{
 "In Fig. 3, the absolute value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"970b79ef-733d-4ade-ab5b-174936712ea4"],
 " is plotted using the height of the three-dimensional surface, and the \
argument of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"91607b78-5f34-4e9f-b0be-66b74a055e18"],
 " is represented by the color on the surface."
}], "Text",
 CellID->49658052,ExpressionUUID->"0c19798b-7cea-45d5-a6b2-3d88efaccb29"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s plot the functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", ",", " ", 
    OverscriptBox["z", "_"], ",", " ", 
    RowBox[{"1", "/", "z"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0c15be7c-464a-4d6e-8e50-c5c1215f8295"],
 " using this method."
}], "Text",
 CellID->778750483,ExpressionUUID->"7287391d-f405-4d83-bdd7-1f3980397476"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ComplexPlot3D", "[", 
      RowBox[{"z", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Opacity", "[", "0.8`", "]"}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
            ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
            ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Abs", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}],
             ",", "12"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"ImageSize", "->", "160"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ComplexPlot3D", "[", 
      RowBox[{
       RowBox[{"Conjugate", "[", "z", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Opacity", "[", "0.8`", "]"}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
            ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
            ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Abs", "[", Cell[TextData[Cell[BoxData[
                FormBox[
                 OverscriptBox["z", "_"], TraditionalForm]],ExpressionUUID->
                "c352c0c1-49d7-4cbf-bdcd-8b20141a9247"]],ExpressionUUID->
                "18a3cf70-61e5-43e1-aa81-eaf74231efb6"], "]"}], ",", 
              "TraditionalForm"}], "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
       
       RowBox[{"ImageSize", "->", "160"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ComplexPlot3D", "[", 
      RowBox[{
       RowBox[{"1", "/", "z"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Opacity", "[", "0.8`", "]"}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Re", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
            ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"Im", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
            ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"HoldForm", "[", 
               RowBox[{"Abs", "[", 
                RowBox[{"1", "/", "z"}], "]"}], "]"}], ",", 
              "TraditionalForm"}], "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
       
       RowBox[{"ImageSize", "->", "160"}], ",", 
       RowBox[{"PlotLegends", "->", "Automatic"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"StringJoin", "[", 
      RowBox[{"\"\<Fig. 4. Plots of the functions \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{"z", ",", "TraditionalForm"}], "]"}], ",", "\"\<, \>\"", ",", 
       
       RowBox[{"ToString", "[", 
        RowBox[{
         InterpretationBox[Cell[BoxData[
           FormBox[Cell[BoxData[
             FormBox[
              OverscriptBox["z", "_"], TraditionalForm]],ExpressionUUID->
             "d788c0a5-09b1-4f5e-80f3-da3d612ce423"], TraditionalForm]],
           ExpressionUUID->"513e523a-0ab3-412f-9c90-97c342356bed"],
          TextCell[
           RawBoxes[
            Cell[
             BoxData[
              FormBox[
               OverscriptBox["z", "_"], TraditionalForm]]]]]], ",", 
         "TraditionalForm"}], "]"}], ",", "\"\<, \>\"", ",", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"1", "/", "z"}], ",", "TraditionalForm"}], "]"}], 
       ",", "\"\<.\>\""}], "]"}]}], "]"}], "&"}]}]], "Input",
 CellID->480139609,ExpressionUUID->"38bc296c-4fad-48dc-bbde-f28b7704648b"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJx1nA2QV+V1xleXhQVEMWikQhLxo7GRCdZaaSr2nDGjJiC1KlMDSNJqFE2q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        "], {{{
           EdgeForm[], 
           Directive[
            GrayLevel[1], Lighting -> "Neutral", 
            Opacity[0.8], 
            Texture[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyVmmeQVUW7hb+6t0pURECv4dMzIygCBmCYTJSMRGFgyEGQHCXnHCWJ5Kgk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                "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], DefaultBaseStyle -> "ImageGraphics", 
              ImageSizeRaw -> {100., 100.}, 
              PlotRange -> {{0, 100.}, {0, 100.}}]]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnHm4jlXbh/fz3M3zPEcoc1KZUpKURCEhJEMSQqQiZEpFEoXMMmQIZUgU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               "]]}, 
             Annotation[#, 
              "Charting`Private`Tag$38236#1"]& ]]}, {}, {}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0jdOHUAQBuAlp0eOJlm0hAsQekJHRego8AMbMGAeOdkkURMuAAi7JDTQ
QUODRHaLL2DDBYAPufg0f7HS7MxuVc9Q+2BcCGGZu4QQ3vOFusZHuYluJtnm
mFueyXa4jjb6WGWXc/7wSkV8CA10Ms4mh1zzj0x9amhhjwc+ccMJUfro5zNf
GGCQIb4yzAijfGOMGONMMMkU08wwyxzzLLDId36wz2+WuOWUXpqpJsJf977i
gA1idFBPOS/mfuSMHVaI0kotWTzZ3w1HbDFBF42s63FPpXyp/qJCLqeMUj5Q
QjFFFFJAPnnkkvP+RmSRSYQM0kkjlRSSSSIRrYIRws+E///hDQCcOrs=
            "]]}}}, VertexNormals -> CompressedData["
1:eJx9XAlUTlvYNs9zRRRxrzLczHPT1nWRmSIkIg0qRDJGwpUhc+Z5KjJdisy9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         "], VertexTextureCoordinates -> CompressedData["
1:eJyN21Go3mUdwPFDtThGF+4iiplQCUEgNUK9iTUMO2J0k4EMuogNJLCLanpR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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
         FormBox[
          TagBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
          TraditionalForm], 
         FormBox[
          TagBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
          TraditionalForm], 
         FormBox[
          TagBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
          TraditionalForm]}, AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 1}, DisplayFunction :> Identity, ImageSize -> 160, 
       Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 6.}}, 
       PlotRangePadding -> {Automatic, Automatic, Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJx1nA2QV+V1xleXhQVEMWikQhLxo7GRCdZaaSr2nDGjJiC1KlMDSNJqFE2q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        "], {{{
           EdgeForm[], 
           Directive[
            GrayLevel[1], Lighting -> "Neutral", 
            Opacity[0.8], 
            Texture[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJyVmXW0ldX6ts/4fWMoIeU5nnPUtREUQUCaXZR0N2y6O6VLulMpaZRUWhql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                "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], DefaultBaseStyle -> "ImageGraphics", 
              ImageSizeRaw -> {100., 100.}, 
              PlotRange -> {{0, 100.}, {0, 100.}}]]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnHm4jlXbh/fz3M3zPEcoc1KZUpKURCEhJEMSQqQiZEpFEoXMMmQIZUgU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               "]]}, 
             Annotation[#, 
              "Charting`Private`Tag$38340#1"]& ]]}, {}, {}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0jdOHUAQBuAlp0eOJlm0hAsQekJHRego8AMbMGAeOdkkURMuAAi7JDTQ
QUODRHaLL2DDBYAPufg0f7HS7MxuVc9Q+2BcCGGZu4QQ3vOFusZHuYluJtnm
mFueyXa4jjb6WGWXc/7wSkV8CA10Ms4mh1zzj0x9amhhjwc+ccMJUfro5zNf
GGCQIb4yzAijfGOMGONMMMkU08wwyxzzLLDId36wz2+WuOWUXpqpJsJf977i
gA1idFBPOS/mfuSMHVaI0kotWTzZ3w1HbDFBF42s63FPpXyp/qJCLqeMUj5Q
QjFFFFJAPnnkkvP+RmSRSYQM0kkjlRSSSSIRrYIRws+E///hDQCcOrs=
            "]]}}}, VertexNormals -> CompressedData["
1:eJx9XAlUTlvYNs9zRRRxrzLczHPT1nWRmSIkIg0qRDJGwpUhc+Z5KjJdisy9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         "], VertexTextureCoordinates -> CompressedData["
1:eJyN21Go3mUdwPFDtThGF+4iiplQCUEgNUK9iTUMO2J0k4EMuogNJLCLanpR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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
         FormBox[
          TagBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
          TraditionalForm], 
         FormBox[
          TagBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
          TraditionalForm], 
         FormBox[
          TagBox[
           StyleBox[
           "\"\\!\\(\\*FormBox[TemplateBox[List[InterpretationBox[Cell[\
BoxData[FormBox[Cell[BoxData[FormBox[OverscriptBox[\\\"z\\\", \\\"_\\\"], \
TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[OverscriptBox[\\\"z\\\", \\\"_\\\"], \
TraditionalForm]]]]]]], \\\"Abs\\\"], TraditionalForm]\\)\"", 12, 
            StripOnInput -> False], HoldForm], TraditionalForm]}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 1}, DisplayFunction :> Identity, ImageSize -> 160, 
       Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 6.}}, 
       PlotRangePadding -> {Automatic, Automatic, Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJyVnHm0VtV5xgFBEYeCKGqizaJpwRoVEUqMA+82ONaxDiERjVO7BK0mTqCY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          "], {{{
             EdgeForm[], 
             Directive[
              GrayLevel[1], Lighting -> "Neutral", 
              Opacity[0.8], 
              Texture[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJyVmXW0ldX6ts/4fWMoIeU5nnPUtREUQUCaXZR0N2y6O6VLulMpaZRUWhql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                  "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
                  RGBColor], 
                 BoxForm`ImageTag[
                 "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                 Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                ImageSizeRaw -> {100., 100.}, 
                PlotRange -> {{0, 100.}, {0, 100.}}]]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxVnHf8ztX7x+/7ft/tpT00RJRUSLREQlpKIWmSrJKZHYoWUTRRMipJJe1B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                 "]], 
                
                Polygon3DBox[{{1189, 1046, 986, 1188}, {1192, 1040, 976, 
                 1177}, {1199, 1076, 990, 1181}, {1179, 986, 1071, 1194}, {
                 1170, 1071, 914, 1174}, {1180, 990, 994, 1198}, {1182, 1038, 
                 1095, 1191}, {1172, 994, 1104, 1196}, {1175, 917, 1076, 
                 1173}, {1186, 973, 1038, 1187}, {1196, 1104, 1046, 1171}, {
                 1190, 1070, 973, 1176}, {1185, 1072, 917, 1175}, {1191, 1095,
                  1040, 1183}, {1174, 914, 1070, 1184}, {1178, 976, 1072, 
                 1233}}]}, 
               Annotation[#, "Charting`Private`Tag$38524#1"]& ]]}, {}, {
             EdgeForm[], 
             GrayLevel[0.82], 
             GraphicsGroup3DBox[{
               Polygon3DBox[CompressedData["
1:eJxNkjtOw2AQhP9AepeuOUbihiqyHQdEEhlHihOJA8C5aAlv8RYQQDwCLeIu
zCgfEsVoVvvP7s6uvbaz199dCSGsC6tC2QyhI0TCWMiIH4XPRghz8bbQIp/C
HypOxDFxRK3jY/Ghak/EU2GIbkNoC9/SXItn0tyIt5rLXj/KT8Rd4pF48K82
x1NM7FnuPUKTMM9xT6iZZV8TenrXktld8vY6pParsdyxRpNxF2taxBG+KmZ1
uFGErwqfKbMi+qX4qfHn/hU1MV4yZuXsbL1vtkn8yj3fuFuB5zZ6z73A0yVe
BuQLanyHObkn7t0nn6Bxz3u+14M9oTtCW6C3p5RvMeY/sf8p38N9Snaf8U/4
/ZRd3cO1t9zkjl177PvnyZqcnON9PBz4jTkL8RkezoV38n5/5g4vwhVe/A/+
AkyBYZY=
                "]], 
               
               Polygon3DBox[{{1205, 1099, 436, 1206}, {1226, 1107, 1113, 
                1227}, {1213, 1094, 435, 1214}, {1232, 466, 1100, 1193}, {
                1202, 1100, 1106, 1203}, {1224, 465, 1107, 1225}, {1218, 1101,
                 1103, 1219}, {1216, 435, 1101, 1217}, {1219, 1103, 1082, 
                1220}, {1211, 1111, 1094, 1212}, {1221, 1082, 465, 1222}, {
                1229, 1108, 466, 1230}, {1203, 1106, 1099, 1204}, {1208, 436, 
                1081, 1209}, {1210, 1081, 1111, 1211}, {1227, 1113, 1108, 
                1228}}]}]}, {}, {}}, {{
             GrayLevel[0], 
             Line3DBox[CompressedData["
1:eJwl0sVNRVEUBdDL5+PuDmECCdIAMkdmjJAZA5yPu3sDSANAAUgD0ADSADSA
NACsFwYrZ7/kJvvKqx+e6UskhRCOOIyHEOWEeZkcQp3cyRBrXHDPK9/kWdxK
L+OccMUj7/xSEwuhnQFWOOOWZz7J0dNMN0HvMaPyvtnAmDzOBJNMMU2CGWaZ
Y54FFllimRVWWWOdDTbZYpsddtmL+jggpvOEw+jbbGRE7qKJbD7s+4kbTlmm
nzaq+XHuNx645Jgxemghly/HfeGOc1YZpINrHUd6a+VNM06NXE0VlVRQThml
lFBMEYUUkB+9EbnkkE0WmWSQThqppPxff4ieIRbN+P//8AeI3DRn
              "]], 
             
             Line3DBox[{1233, 1178, 1197, 1177, 1192, 1183, 1191, 1182, 1187, 
              1186, 1200, 1176, 1190, 1184, 1174, 1170, 1194, 1179, 1195, 
              1188, 1189, 1171, 1196, 1172, 1198, 1180, 1201, 1181, 1199, 
              1173, 1175, 1185, 1233}], 
             
             Line3DBox[{1209, 1208, 1207, 1206, 1205, 1204, 1203, 1202, 1193, 
              1232, 1231, 1230, 1229, 1228, 1227, 1226, 1225, 1224, 1223, 
              1222, 1221, 1220, 1219, 1218, 1217, 1216, 1215, 1214, 1213, 
              1212, 1211, 1210, 1209}]}}}, VertexNormals -> CompressedData["
1:eJztfHlYzt23d4ZCpgyFzGMyz0NoUZnnKUMIGcoUGSJz5ijzXERFKaEoDdqI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           "], VertexTextureCoordinates -> CompressedData["
1:eJyd233In1UdgPFVKrPCHBXVzCilIBq2avVHZU+FTczSSqhFQU16YUpvFmVs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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\
\")\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
            TraditionalForm], 
           FormBox[
            TagBox[
             StyleBox[
             "\"\\!\\(\\*FormBox[TagBox[TemplateBox[List[FractionBox[\\\"1\\\"\
, \\\"z\\\"]], \\\"Abs\\\"], HoldForm], TraditionalForm]\\)\"", 12, 
              StripOnInput -> False], HoldForm], TraditionalForm]}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 1}, DisplayFunction :> Identity, ImageSize -> 
         160, Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"},
          PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 6.}}, 
         PlotRangePadding -> {Automatic, Automatic, Automatic}, 
         Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]}, "Legended", 
      DisplayFunction -> (GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ), 
      InterpretationFunction -> (RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> 
      True]}, "RowDefault"], 
   "\"Fig. 4. Plots of the functions \\!\\(\\*FormBox[\\\"z\\\", \
TraditionalForm]\\), \
\\!\\(\\*FormBox[InterpretationBox[Cell[BoxData[FormBox[Cell[BoxData[FormBox[\
OverscriptBox[\\\"z\\\", \\\"_\\\"], TraditionalForm]]], TraditionalForm]]], \
TextCell[RawBoxes[Cell[BoxData[FormBox[OverscriptBox[\\\"z\\\", \\\"_\\\"], \
TraditionalForm]]]]]], TraditionalForm]\\), \
\\!\\(\\*FormBox[FractionBox[\\\"1\\\", \\\"z\\\"], TraditionalForm]\\).\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->94324370,ExpressionUUID->"75c6e426-1d52-4a35-860b-738d007205c0"]
}, {2}]],

Cell[TextData[{
 "The three-dimensional plot can be compressed into two dimensions by using \
",
 ButtonBox["ComplexPlot",
  BaseStyle->"Link"],
 ", as in Fig. 5. In this case, the color of a point corresponds to the \
argument of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"78d0517e-2e03-449a-8358-9d64ed61e2e6"],
 ", and the lighter or darker tone to its absolute value, as shown in the \
legend."
}], "Text",
 CellID->114722607,ExpressionUUID->"e6b4fe31-17fe-4c66-8e1b-286da5a3ac6a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot", "[", 
   RowBox[{
    SuperscriptBox["z", "2"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"3", "I"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"3", "I"}]}]}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["2", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["576", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[FrameLabel -> {
        Style[
         ToString[
          Re[$CellContext`z], TraditionalForm], 12], 
        Style[
         ToString[
          Im[$CellContext`z], TraditionalForm], 12]}, PlotLegends -> 
      Automatic],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["656", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 5. Absolute value and argument of " <> ToString[
       HoldForm[$CellContext`f[$CellContext`z] == $CellContext`z^2], 
       TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->8557720,ExpressionUUID->"a197b0c3-a01a-4b58-b90a-1050fc894a36"],

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ComplexPlot", "[", 
       RowBox[{
        SuperscriptBox["z", "2"], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", 
          RowBox[{
           RowBox[{"-", "3"}], "-", 
           RowBox[{"3", "I"}]}], ",", 
          RowBox[{"3", "+", 
           RowBox[{"3", "I"}]}]}], "}"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           StyleBox[
            FormBox[
             RowBox[{"Re", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12], ",", 
           StyleBox[
            FormBox[
             RowBox[{"Im", "(", "z", ")"}],
             TraditionalForm],
            StripOnInput->False,
            FontSize->12]}], "}"}]}], ",", 
        RowBox[{"PlotLegends", "\[Rule]", "Automatic"}]}], "]"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\"\<Fig. 5. Absolute value and argument of \>\"", "<>", 
         RowBox[{"ToString", "[", 
          RowBox[{
           TagBox[
            RowBox[{
             RowBox[{"f", "[", "z", "]"}], "\[Equal]", 
             SuperscriptBox["z", "2"]}],
            HoldForm], ",", "TraditionalForm"}], "]"}]}], ")"}], 
       "<>", "\"\<.\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"BaseStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"FontFamily", "\[Rule]", "\"\<Source Sans Code\>\""}], "}"}]}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", "\[Rule]", "3"}], "}"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellID->46141840,ExpressionUUID->"c90e6d20-70dc-4e50-a2b7-5bc143551da8"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{
         GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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          "], {{{
             EdgeForm[], 
             Directive[
              Opacity[1.], 
              Texture[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJxE2seSI2mW6PcxcsMlX4FvwS2X3F4aH+DO7Z7W3dWldVVWZaVWkRkZWmuB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                  "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                  RGBColor], 
                 BoxForm`ImageTag[
                 "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                 Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                ImageSizeRaw -> {144., 144.}, 
                PlotRange -> {{0, 144.}, {0, 144.}}]]], 
             GraphicsGroupBox[
              TagBox[{
                PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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                 "]]}, 
               Annotation[#, 
                "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, {{
             Directive[], 
             LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
              "]]}}}, VertexTextureCoordinates -> CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         PlotRangePadding -> {{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.02], 
            Scaled[0.02]}}, PlotRangeClipping -> True, ImagePadding -> All, 
         DisplayFunction -> Identity, Axes -> {False, False}, 
         AxesLabel -> {None, None}, AxesOrigin -> {Automatic, Automatic}, 
         DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
         FrameLabel -> {{
            FormBox[
             TagBox[
              StyleBox[
               RowBox[{"Im", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
               False], HoldForm], TraditionalForm], None}, {
            FormBox[
             TagBox[
              StyleBox[
               RowBox[{"Re", "(", "z", ")"}], FontSize -> 12, StripOnInput -> 
               False], HoldForm], TraditionalForm], None}}, 
         FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
         Method -> {
          "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
           "TransparentPolygonMesh" -> True, "AxesInFront" -> True}, 
         PlotRange -> {All, All}, PlotRangeClipping -> True, 
         PlotRangePadding -> {{
            Scaled[0.02], 
            Scaled[0.02]}, {
            Scaled[0.02], 
            Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{{}, 
                 RasterBox[CompressedData["
1:eJzt1j1IVXEcxvEbZUM2FIQ5OFSLLUbUUhC6NFRDN6IisqGCmoRehmrIpUCa
pDAiQ7LIgkzK3qTQyGsvammZld1eNEsrtRcbahGhznmeXJIv/7HFH+dy4H7Q
c8/5/X/P/8zdtnPt9smJRKI1+kyKPlOiz8nyuF4V/HtOqH6M+37sPL+4M7e4
cxh9zUhVcqSKfZ+KvfLnyuhgb96dEx3sw99V6LOLUllFKfaCwbL8wTL2HSr2
0r4l0cFetyUzOth7uuP6hj61sDajsJY9L30wOtjXq9jV3lz2c8m4wV/R29vi
Yv8Vt7eSPUcNZl+uYld7s9iP5ccN/oLeUB8Xe3/c3lL2TDWYfbGKXe3NYD+k
Bg+hX6yOi13tLWbX+CbZ56nYV2mAB9H3qMHsPrOrvUXsGt989pkq9qUa4AH0
rWow+2EVu9pbyK7xzWN3PrM7nz+jO5/Z9yuf2Z3P7M5ndufzJ3S1N8Wu7pax
O5/Znc/szmd25/NHdOcz+wI1mH2D8pnd+czufO5HVzy3sau9lezOZ3bnM7vz
md353IfufGZ3PrNPV4PZnc/szmd2jW/6A7riuZrd+czufGZ3PrM7n9+jO5/Z
dSpnb9IAsw8pn9mdz+zO5150jW8du/OZ3fnM7nxmdz6zr1YD36Gf0gCy+/W2
J5CP7M4/dudbdyC/2A9oAbM7f94G8oXd+cHufHiDPk3zz75JC4Dd8/s6MJ/s
KzR/478fO5+A78fOA5ofdsdfOrD+2bscYOh+v3iJ7vcH9ha9H7Bnq8Fd6N7f
2b1/s3t/foHu/Zdd7R15ju79k937I7v3v2fo3t/YF2n/Ynd7O9G9/7B7f2Hf
pQF+it6o/YF9hvKf3fnegX5J+c0++juuJ+gVaiD7MuXrY/RexWd7IB/ZnX9t
gXx7hL5Z+cU+qgX8MJA/rYF8aUH3/sjufGhGn6X5f4B+XQuAfZ3m935gPu8F
5u8u+kLNF3uH5qcpMB+pwPpnr9H6buT+6QbvcH+0Pm+jZ2v9NaBv1PqqRz+i
863A+rjJ11f/6/j66u8Nvn/171qgP1cDz/8K+mk938voc/T8agLP5wJfX/d/
nv9e93c28PvPoCf0+yrYdf3j7Pr/RwN/XxLwvex/a8In/H/6H5X32l8=
                  "], {{-11.25, 
                    Rational[-225, 2]}, {-3.75, 
                    Rational[225, 2]}}], 
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{-3.75, 
                    Rational[-225, 2]}, {11.25, 
                    Rational[225, 2]}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{11.25, 
                    Rational[-225, 2]}, {-11.25, 
                    Rational[-225, 2]}, {-11.25, 
                    Rational[225, 2]}, {11.25, 
                    Rational[225, 2]}, {11.25, 
                    Rational[-225, 2]}}, {{
                    11.25, -112.5}, {-11.25, -112.5}, {-11.25, 112.5}, {11.25,
                     112.5}, {11.25, -112.5}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{11.25, -112.5}, 
                    Offset[{4., 0}, {11.25, -112.5}]}, {{11.25, -56.25}, 
                    Offset[{4., 0}, {11.25, -56.25}]}, {{11.25, 0.}, 
                    Offset[{4., 0}, {11.25, 0.}]}, {{11.25, 56.25}, 
                    Offset[{4., 0}, {11.25, 56.25}]}, {{11.25, 112.5}, 
                    Offset[{4., 0}, {11.25, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{11.25, -101.25}, 
                    Offset[{2.5, 0.}, {11.25, -101.25}]}, {{11.25, -90.}, 
                    Offset[{2.5, 0.}, {11.25, -90.}]}, {{11.25, -78.75}, 
                    Offset[{2.5, 0.}, {11.25, -78.75}]}, {{11.25, -67.5}, 
                    Offset[{2.5, 0.}, {11.25, -67.5}]}, {{11.25, -67.5}, 
                    Offset[{2.5, 0.}, {11.25, -67.5}]}, {{11.25, -45.}, 
                    Offset[{2.5, 0.}, {11.25, -45.}]}, {{11.25, -33.75}, 
                    Offset[{2.5, 0.}, {11.25, -33.75}]}, {{11.25, -22.5}, 
                    Offset[{2.5, 0.}, {11.25, -22.5}]}, {{11.25, -22.5}, 
                    Offset[{2.5, 0.}, {11.25, -22.5}]}, {{11.25, -11.25}, 
                    Offset[{2.5, 0.}, {11.25, -11.25}]}, {{11.25, 11.25}, 
                    Offset[{2.5, 0.}, {11.25, 11.25}]}, {{11.25, 22.5}, 
                    Offset[{2.5, 0.}, {11.25, 22.5}]}, {{11.25, 22.5}, 
                    Offset[{2.5, 0.}, {11.25, 22.5}]}, {{11.25, 33.75}, 
                    Offset[{2.5, 0.}, {11.25, 33.75}]}, {{11.25, 45.}, 
                    Offset[{2.5, 0.}, {11.25, 45.}]}, {{11.25, 67.5}, 
                    Offset[{2.5, 0.}, {11.25, 67.5}]}, {{11.25, 67.5}, 
                    Offset[{2.5, 0.}, {11.25, 67.5}]}, {{11.25, 78.75}, 
                    Offset[{2.5, 0.}, {11.25, 78.75}]}, {{11.25, 90.}, 
                    Offset[{2.5, 0.}, {11.25, 90.}]}, {{11.25, 101.25}, 
                    Offset[{2.5, 0.}, {11.25, 101.25}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, -112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, -56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, 56.25}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {11.25, 112.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False], 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{-11.25, -112.5}, 
                    Offset[{-4., 0}, {-11.25, -112.5}]}, {{-11.25, 90.}, 
                    Offset[{-4., 0}, {-11.25, 90.}]}, {{-11.25, 112.5}, 
                    Offset[{-4., 0}, {-11.25, 112.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{-7., 0.}, {-11.25, -112.5}], 
                    ImageScaled[{1, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["14.`", TraditionalForm], 
                    Offset[{-7., 0.}, {-11.25, 90.}], 
                    ImageScaled[{1, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Infinity]\"", TraditionalForm], 
                    Offset[{-7., 0.}, {-11.25, 112.5}], 
                    ImageScaled[{1, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", 
                 RowBox[{"(", 
                   RowBox[{
                    RowBox[{"1", "-", 
                    RowBox[{"Rescale", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0.9`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "&"}], ")"}]}],
                ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "\"0\""}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.9`", ",", "14"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "\"\[Infinity]\""}], "}"}]}], "}"}]}], 
               ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 5. Absolute value and argument of \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], \\\"\[LongEqual]\\\", SuperscriptBox[\\\"z\\\", \\\"2\\\"]}], \
HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 3}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 ShowCellLabel->False,
 CellID->1889510027,ExpressionUUID->"b961dc36-24a0-4a1a-9ece-0b41fbeebf5a"]
}, {3}]],

Cell[TextData[{
 "The two-dimensional plots for the functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", ",", " ", 
    OverscriptBox["z", "_"], ",", " ", 
    RowBox[{"1", "/", "z"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "265b5475-b78b-4843-a572-7027e1ce333d"],
 ", with level curves of equal modulus and equal argument, look like this."
}], "Text",
 CellID->458965340,ExpressionUUID->"0ed13e38-2201-461d-8012-6204df03b119"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ComplexPlot", "[", 
       RowBox[{"z", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "3"}], "}"}], ",", 
        InterpretationBox[
         DynamicModuleBox[{Typeset`open = False}, 
          TemplateBox[{"Expression", "SequenceIcon", 
            GridBox[{{
               RowBox[{
                 TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                 TagBox["Sequence", "IconizedItem"]}]}, {
               RowBox[{
                 TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                 TagBox["4", "IconizedItem"]}]}, {
               RowBox[{
                 TagBox["\"Byte count: \"", "IconizedLabel"], 
                 "\[InvisibleSpace]", 
                 TagBox["1064", "IconizedItem"]}]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
             "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
            Dynamic[Typeset`open]},
           "IconizedObject"]],
         Sequence[PlotRange -> {{-3, 3}, {-3, 3}, {0, 6}}, FrameLabel -> {
            Style[
             ToString[
              Re[$CellContext`z], TraditionalForm], 12], 
            Style[
             ToString[
              Im[$CellContext`z], TraditionalForm], 12]}, ImageSize -> 160, 
          Mesh -> 10],
         SelectWithContents->True,
         Selectable->False]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ComplexPlot", "[", 
       RowBox[{
        RowBox[{"Conjugate", "[", "z", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "3"}], "}"}], ",", 
        InterpretationBox[
         DynamicModuleBox[{Typeset`open = False}, 
          TemplateBox[{"Expression", "SequenceIcon", 
            GridBox[{{
               RowBox[{
                 TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                 TagBox["Sequence", "IconizedItem"]}]}, {
               RowBox[{
                 TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                 TagBox["4", "IconizedItem"]}]}, {
               RowBox[{
                 TagBox["\"Byte count: \"", "IconizedLabel"], 
                 "\[InvisibleSpace]", 
                 TagBox["1064", "IconizedItem"]}]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
             "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
            Dynamic[Typeset`open]},
           "IconizedObject"]],
         Sequence[PlotRange -> {{-3, 3}, {-3, 3}, {0, 6}}, FrameLabel -> {
            Style[
             ToString[
              Re[$CellContext`z], TraditionalForm], 12], 
            Style[
             ToString[
              Im[$CellContext`z], TraditionalForm], 12]}, ImageSize -> 160, 
          Mesh -> 10],
         SelectWithContents->True,
         Selectable->False]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ComplexPlot", "[", 
       RowBox[{
        RowBox[{"1", "/", "z"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "3"}], "}"}], ",", 
        InterpretationBox[
         DynamicModuleBox[{Typeset`open = False}, 
          TemplateBox[{"Expression", "SequenceIcon", 
            GridBox[{{
               RowBox[{
                 TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                 TagBox["Sequence", "IconizedItem"]}]}, {
               RowBox[{
                 TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
                 TagBox["5", "IconizedItem"]}]}, {
               RowBox[{
                 TagBox["\"Byte count: \"", "IconizedLabel"], 
                 "\[InvisibleSpace]", 
                 TagBox["1128", "IconizedItem"]}]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
             "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
            Dynamic[Typeset`open]},
           "IconizedObject"]],
         Sequence[PlotRange -> {{-3, 3}, {-3, 3}, {0, 6}}, FrameLabel -> {
            Style[
             ToString[
              Re[$CellContext`z], TraditionalForm], 12], 
            Style[
             ToString[
              Im[$CellContext`z], TraditionalForm], 12]}, ImageSize -> 160, 
          Mesh -> 10, PlotLegends -> Automatic],
         SelectWithContents->True,
         Selectable->False]}], "]"}]}], "}"}], ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"LightDarkAutoColorRules", "->", 
       RowBox[{"{", "}"}]}], "}"}]}]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["1096", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ((((("Fig. 6. Plots of the functions " <> 
         ToString[$CellContext`z, TraditionalForm]) <> ", ") <> ToString[
         TextCell[
          RawBoxes[
           Cell[
            BoxData[
             FormBox[
              OverscriptBox["z", "_"], TraditionalForm]]]]], 
         TraditionalForm]) <> ", ") <> 
     ToString[1/$CellContext`z, TraditionalForm]) <> "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->814139146,ExpressionUUID->"cbf35d8d-52c7-4dc2-b8e2-e35f033db081"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     GraphicsBox[{{
        GraphicsComplexBox[CompressedData["
1:eJylfXl0TtcXdmQuHQQ1pEUr2qqaSqgh7Guo1jxUNSilxlBTEENMNVNBFa0p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         "], {{{
            EdgeForm[], 
            Texture[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJx03FesJHd+6HfBfvGjAb/65V77wb7WwzVsyLJly5IgQVrpKnEvV4G7q2VY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                "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], DefaultBaseStyle -> "ImageGraphics", 
              ImageSizeRaw -> {100., 100.}, 
              PlotRange -> {{0, 100.}, {0, 100.}}]], 
            GraphicsGroupBox[
             TagBox[{
               PolygonBox[CompressedData["
1:eJxFnHf8V/MXxz/jjs/nfq0yMpJSkVKZhZAV2dnK3hmZyd6aCNkjMlIpGRmJ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                "]], 
               PolygonBox[CompressedData["
1:eJw1nXfgV9P/x+973Pcd79JSSkalpISGhmigSEgiGpRKUSJl01DKzpY9SjYh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                "]], 
               PolygonBox[CompressedData["
1:eJwt1nuQl1MYB/B32233tz+VGdMmly1KIrlmGNJlKa0ymNwSMTVIrFracskg
UbrIdiFdyGXYtnu2qXY1XcdlRkoXIYsURZdtatJKrfU5c/rjO7/zfJ/v93nO
e855z/s7f8CQ3oMbJElSAg1hcjpJKrOTZE1WktyUkSRNUkmyFvetuI/4epgi
fheO053J9DXuKbpRuLRiB8RNc5Jkn/gT+JeuOd03+FF0o3EP0RVAR7pD4kx8
rf7ltB/o9SyuMW618SpozdsyN0lycWcaV9Atxz9HVwrjxSXi7WocU/N3uvl6
zoNp+szhzcFdyNstIz5j1mlJ8gd+iTiX7nO+GvFI9VLiH8U7M5OkXzrOuRj3
Gryo3od0C2AQTRluEW6/+jvFV5rDCb6uemTSLOMtMO6AvwqKxfvoxhl3Mucn
5HLoduMewbXB9cU1xA2hrVWrs7id3K801fpM1K+X8Qi9vxeXwxy4nX4D/R1+
l/Mfp6umOQhjccNgqPoT1PtBvVo1fqX7BQrk1vPelI7P9g3vBqjkPYr7B3L4
OtG0hMXiDD0zrF+pmrPl8viexheKh4in63FQj+dxVbjluI70ab7XcP3UfgoG
6PMe73hcQ5pmcJcelbgNtD3l+9O1V2sm7jtcOLgFYc3wG8V5MFztvfps429D
NxZOGjeiWSG3kKY5jDCeDrvkck+L8wnz2sT7VXY843vVvkb8cHbcl7A/dem4
X0XiJ+GvcGbgI+P+tC/LTaT5DZeHq8uMez8hrJW5XGG8TO5+/H96Xqp3hbi3
+E6oT8U9DnvdWL2e9G/w1qXierQXL5VfEt4r3Hm4bNyMnLgfx8OZ5X2DdyZ+
Eu4Qrhw3EDca9yYuMZdi3nbZsf9n4qPqnbCmNeGs4BaFc5qK+/+YeIHcLvHW
sM64TjlxX8L+7IBXjd/F341fyDsOjopLc+I8w3z74LaKs2EPrkh8LB37nSVu
nhnPaQ1ttXpf8A8Oz2Z+h3C7Qj9cSVgD3E7cx7j3cfeFdxF3DLc7vKviA3KH
U3Gtw5rne965+KpT98E8azIXcuz92eH8QR1NE/4q3OJT99o14h5wsXpv0/SF
WroG4Y6hu5euCPdPeOdxC3CDwn2Am6jvGj3T+FfUmpqO5+5ffd+hyw/nANc+
Hd/F1fSXGf9sXA3XGa/FXet3PrRW6za1LjeXL3m/gFvEhdAIN43nBrqO0BVW
8f6UG+/JFba+Mol3QL34augAO+Sn0F1ifDN0h25QYX6z1W8K9xhvMe89vC+G
NeH5Ozt+OMrkOoT9Mbdm8nlZ8R7MoknBBOMuuM5Z8Z0pDPvEm8Fbztud9wLc
ZtzGrNgr9HxBny3iP8Ndj7uQZm14lrCmfs+hORcSuhm4L9X+CurlLoJ+PNt4
98NL6fju7wtzgAfk2tKcwDcRFyrzaBLv3dkw0FoOC2cNNvP9GM648Sh4UO4D
msm58VvXNtyx6q1MxW9ZnvEczzImrLP8M3pMM54PbeXO4Wvl3e/Fd2m4yxvE
e60CDhtvx38HR9SalRu/k/eLb5TbhMvHtVCnTL3PYEQ6fn/Cd+hx2pW0r6fj
+QjnpBXuOtw6cQl+MM9IqPG8TXPjN6WY7la6UroxNGeEb4B8UVg7GI77Hrcd
uhivy4xnrAz+86zn8v1w6p3ZTbNerU1QQZdH81bYEz1upusO68M3C1/Pmy/e
wfsp7iTdLJ5JfivFVbAGTuftSXeemvP45sqvwC0M7xv8QdMIN9Wce4QzBEOD
Lty9PC1pftFjWfhehjsQ1wJXjVuaiv8bwv+HcebTl/eI+H/bNz+U
                "]], 
               
               PolygonBox[{{2234, 2233, 2740, 1996, 1995, 2739}, {2076, 2075, 
                2738, 1982, 1761, 2346}}]}, 
              Annotation[#, 
               "Charting`Private`Tag$21663#1"]& ]]}, {}, {}, {}, {}}, {{
            Hue[0.67, 0.6, 0.6], 
            LineBox[CompressedData["
1:eJwl0jlPVFEYgOFPRlmUQcVdAWNjIjCimFiIJpSonTQinQWCC6CyqiyKUUPN
8geEAI2JSmIkNNrYkAi4dEQaGxOExAI1AZ4JxZP35jv3zJ0zd45db7rSuCUi
XvElEZG+/qQvOOr6AkVbI2r1Z1ZEpw4zSbP5vK6w08YUl1kwb9DnjFCcHVFC
KSlOUsYpTlPOR/ctsk7ltojCjIgKamhnkAnzNzrLb1btS/qea+YlepFRvnGD
Od5TTwPHMyNu6i1uc4cTZo3aRDORE3FX75Gydl9baKWNdjoos9apD8iw56E+
oosz1rq1h14ec9bsifYxxneeMs8UdVSRdF+x/ne2XF1yzs9MO+NrHaCNq5yj
2rxA1/xuP3hn3wd9yTNWvIt6vUQpeSw7Zp/5nL5liF/ebYemzK/pefo9/ytF
rmd0gkLXBSTcd0QPc4iDrFs/oPvZx6LP3Kt7+GctX3ezK/1/IY8kf63l6g4W
7Nm++RrCUeKPNaPws4SjhsfGsln6VTl2jCc2/7cbXeZPuw==
             "]]}, {
            Directive[
             GrayLevel[0.4], 
             Opacity[0.6], 
             AbsoluteThickness[1]], 
            LineBox[CompressedData["
1:eJwVzL8rxHEcx/E3+XH3vemKUjpFmRQpdZMf05VJ3S1+DDpZKC4pgxSL0ZUU
4/0PFmXBxehGNq4UJoZb/Fg8DM+ez/fr+7kbXKkUN9siYgFP3RE/SUQFz/qI
t/CLznTEi+0NF+53TmwfXHVfoqW/8I1j9xUiFdHnXQe3ZyJ2bYk+4Rtk9bDv
vbzonvLmgM/Rb7v2rUvXeY1L/79BDtN4sI/xAGreF3gZ9/Y03/KZfdz/fupX
VN37fMg99pp3e3rHts0Z26ltXW/YmrqsV/U8L/GjbU4XdYFnuWGb1DN6gvN8
ZxvSo3qE/wC2CC4f
             "]], 
            LineBox[CompressedData["
1:eJwNzL8rxHEcx/H3dced+xoYTim/LiVJkVKixHRl4kzKoJNS6hiUAWUyqRsZ
759gUYpiZBKjkxILg8mP8hhePZ+f5+fz/RYrm+VqKiJWrZGNOMpHnNmWpVsi
nrQMPuOv1sxfeA7f8E/L8nee4AfWtHP74u3aN7bhD0YSUeCpXEQnNmFa6+G7
vunGRCvilfOeDfAO7QIzzpPen+KQc5d+ife2oK1b2fr0QZyxKXtwP4q9VndX
whW71fN4jSf6mH9/8lerOR/gIRb0unf7fEfbxlbtWNvgVa3BK3yNL+EyPmrz
fJGXcA7vtGk+y8dxAm+0fj7Ch/Ef3lsvMA==
             "]], 
            LineBox[CompressedData["
1:eJwVzK9LQ1EchvHvELl3MyhoUQQZmARhIJgGKw5MghqE+QPRJIwNLgwUURCs
gmVG/4+BWDTOajVtTWEGbdPPDQ/Pc95z7i2ftHdahYjYxTCJGGBcisjwqUfo
6W/+wb3+Qwe/+Vs85xtPpBHnujAVkerFYkSRL2yTtmk9g0Rf2Zbdzzlf69Q2
rxew71xzvuFDHODJ24SX3G9wHUfo21N+4Qd3Fd996QHu8n/zLc/aH7271B1b
xiVb13amm7YPfaxP9R43+N22pbd1nTf5zVbVNb3G6/xqK+tVvcL/C/IpQw==

             "]], 
            LineBox[CompressedData["
1:eJwVz70rxHEAx/Evcefcg7qTE+E85CEPkRKllOnKIDIpA8okN3iciMUqGRhv
8ycYiFKMjGSRSTEw2CivGz6939/399uvu9alwuxaWQihYB/REGKxED4xiRfV
Iaxbgn9pNfiDKbzUN6yW/2kZvHLesjT/1bJYXhVCHd7o29bII1oDRrEiHsKx
nuI5LYEtmMSIu3ae5m2YwR689X7PunlW68J6jHl/ojfxXq0ZK52v+YC7A/7K
+0rfKv1Om7Zz7zpx1F7cjeMTDmHOiu7zuGgPehzv8Ewf9t1v/m5Hzvt4WPrP
etG7Xb6jbWJSO9VWeUF748t8hc/jAj5rM3yO53EKH7UJPslHcAzvtQ4+yPvx
HwQgLkg=
             "]], 
            LineBox[CompressedData["
1:eJwVzz8oxGEcx/HnNn8WGUQWErrEoIiUSZmuZFAmdYOUkDIp0+UsBsmJ4uqU
82egKJMNC4qBYnALUnIpitt43fDp/f5+nu/z/PrVx6cGJyMhhAlpLwmhozSE
KF6XhdDLe3g/9uG9boDH+DAOYU4X5yN8HMfwTTfDp/kmrywPYZbP6RKY1dXq
FnlSl8I8/kiXPm2+4hX27nAUY5LVN2KntEqbROXXzoLsOK8yF3jAP+z23hLW
mKslIqf2lnXvPCGr/EKXwjOsc2eFn/N1vMQ1zNudlzS/Lf4b3uAGfuqTssUf
dBl8xAZvZfkT38Yc7uMrNjnb4898F1+wWXfIP/hB8Zt4jF/Y4uyIf/MTLOA/
atxBww==
             "]], 
            LineBox[CompressedData["
1:eJwVzqlLw3Ech/GPzQuTYvFgYdgURRAFYWAaGGRgmWAYwpJHEkyDpXlj1Lji
5jGPef0HGjUqFjeD1v0Fvgxvnuf7/A6+idx6Zq0tIrL21B5x2BHxiMNdEWed
EQ/8QLvHIa2q3fF9rY6DWkW75XvaDQ5op9o139V++RXf4TXcxh/tkpf4BX5j
n9bEMd+faw3eq31hHhesqo/gtH3qs/iOE5iwsudpzNmr3o3PeKJP+m/r/z52
5FzEEvbrZe8V+Ja2iT3asbbKN7QmX+F5voTL+KFl+CJP4zy+aSk+x6dwBl+0
JB/no/gHBr0ykA==
             "]], 
            LineBox[CompressedData["
1:eJwVzb8rxHEcx/G3zZGsykQxWBSJiFKmKwbqotQVXRn4yqRMyoDVyKJu5S+4
DCzcQFEoPwYy3Ul+6xJ5GJ49n5/X99Pn2zQ1P5pURUQW39URX/ioifjkFzyj
rTZizVbWu6mId13S97hDi++rtht9iVd9wdvunvMJnmzHXMSjPuIdPuQDlPU+
z3GBE86g39vjPIsJ7HnzFz8Yca5wI/eiG7fOA3zFndyMvPfSPI1Te93//3nL
3uX9N13ChvMKr3ODPe/esl6yLXK9bdOW6AXbg87pGT3JWb62jemMTvMwn9kG
9ZDu4T4u2lp1h27nP/kjPE4=
             "]], 
            LineBox[CompressedData["
1:eJwVzz0ohWEYxvGbyccgkzrbKcNJDIoUmZTplNJRJoWkzoAyKZMyyEgpkUFn
8h3lK0YDk49J6WwskvIVOfF7h6v//77e57l7n/TQeO9YWUQMS1RGnEpTdcRf
RcReVUQJj3Xz/EuO+LfuEOfMn7Ij77oD3QvuYsaOJ77BH3ETi/jm7Lbc83Xd
Db6at+Sar+mucBnTdlzwJX6OC5hyrkN/Zt7nJ/irL+c/mMec1EmDdElR34it
Ui8Fd7I4Ire+1eAlrurb7P7gz7Jonk3ejil9wbkZPq2bwlrdim6CTybv5KM8
zwdwEB90fbyfZ7EH75L/4t28HTuTN+syvIU34z9Rxzys
             "]], 
            LineBox[CompressedData["
1:eJwVzj8ohAEch/HfnYVTsiqLPyUxKFLqFsp0ZRAZpCQpKVemK5O66TYZz/jW
FYurM7Cw0k3ORrIoMkid8i/53PDtee75ve/19q3l57dTEbFs6Y6Ir0xECv/a
I87xFz+1E/vmJRztjPjgp+5vWMVh7YU/26NVtEHtjif8Ft+928C6lbV+96J2
bJfaEma1C17jZ7jvuTb+g1u4aEd6L87YtD24jeCEDVjinsN1u3Hrwis81Cf9
f5O/2oHfRSxhj554bo/vagXs1spanu9oT3yDb/IVXMV7baH17TyHc9hofRuf
5VOYxWttiI/zMfwHptM1Sg==
             "]], 
            LineBox[{921, 993, 913}]}, {
            Directive[
             GrayLevel[0.4], 
             Opacity[0.6], 
             AbsoluteThickness[1]], 
            
            LineBox[{1008, 1592, 1006, 1591, 1007, 1604, 1030, 1603, 1031, 
             1619, 1054}], 
            
            LineBox[{1012, 1595, 1011, 1594, 1009, 1593, 1010, 1606, 1032, 
             1605, 1033, 1621, 1055, 1620, 1056, 1629, 1070, 1628, 1071, 1647,
              1096, 2814, 1646, 1097, 1656, 1112, 1672, 1136}], 
            
            LineBox[{1017, 1599, 1016, 1598, 1015, 2810, 1597, 1013, 1596, 
             1014, 1609, 1036, 1608, 1034, 1607, 1035, 1623, 1057, 1622, 1058,
              1632, 1074, 1631, 1072, 1630, 1073, 1648, 1098, 1658, 1113, 
             1657, 2745, 1114, 1674, 1137, 1673, 1138, 1683, 1156, 1700, 1178,
              1699, 1179, 1711, 1202, 1725, 1220, 1739, 1246}], 
            
            LineBox[{1018, 1019, 1600, 1020, 2742, 1601, 1021, 1022, 1047, 
             1618, 1048, 1049, 1065, 1066, 1091, 1645, 1092, 1093, 1655, 1109,
              1133, 2748, 1134, 1153, 1154, 1698, 1177, 1200, 1201, 1724, 
             1219, 1738, 1245, 1265}], 
            
            LineBox[{1023, 1024, 1602, 1025, 1026, 1050, 1051, 1067, 1068, 
             1094, 1095, 1110, 2744, 1111, 1671, 1135, 1155}], 
            LineBox[{1027, 1028, 1029, 1052, 1053, 1069}], 
            
            LineBox[{1344, 1343, 1834, 1365, 1848, 1389, 1407, 1408, 1874, 
             1429, 1451, 1452, 2855, 1472, 1473, 1917, 1495, 1511, 1927, 1512,
              1513, 1537, 1538, 1555, 1954, 1556, 1557, 1578, 1971, 2861, 
             1579, 1972, 1580, 1581}], 
            
            LineBox[{1363, 1833, 1364, 1847, 1388, 1861, 1406, 1873, 1427, 
             1872, 1428, 1889, 1448, 1899, 1467, 1898, 1468, 2858, 1915, 1490,
              1914, 1491, 1924, 1506, 1942, 1530, 1941, 1528, 1940, 1529, 
             1950, 1545, 1949, 1546, 1965, 1568, 1964, 1566, 1963, 1567, 1976,
              1585, 1975, 2809, 1584, 1974, 1582, 1973, 1583}], 
            
            LineBox[{1450, 1449, 1901, 1471, 2859, 1493, 1494, 1509, 1510, 
             1535, 1536, 1553, 1554, 1575, 1970, 1576, 1577}], 
            
            LineBox[{1469, 1900, 1470, 1916, 1492, 1926, 2805, 1507, 1925, 
             1508, 1944, 1531, 1943, 1532, 1952, 1547, 1951, 1548, 1967, 1569,
              1966, 1570, 1979, 1588, 1978, 1586, 1977, 1587}], 
            LineBox[{1534, 1533, 1551, 1552, 1573, 1574}], 
            
            LineBox[{1549, 1953, 1550, 1969, 1571, 1968, 1572, 1981, 1589, 
             1980, 1590}], 
            LineBox[CompressedData["
1:eJwl009MznEcwPFvPJVpFaWkGIZ01JTNpck6KUWZfzmQS8my6FCL+TebjUtl
Jn8OjQqb2JzKsKUnRQduwiYnhoOZZGPL6zeH916f72/f5/v7Pb9nz8q6I9VN
CSGEuLYkhZAWC+HP/BD2mteY93AVd3M1D7KYdVzPAyziUZazmRU8zlq2cx8v
8hhnnX3B3GK+xHPs43X28gYf8CGfMs4nHOUEP/Atf/AzQ2II0xxxblyjeq4x
jeuFXmpCmfbOSQ5hBdNZyDyWcqd2aaN1E0/rjGqsLzM/JYR7HNCwnumNJvVF
5+37ym+a63m6rWOccd9EZuuma4t5izns5RL2MZf9zONtLuUdLuNdJvO3s66a
k8zXOC96b/zlnh2cZidn2MWP0XfgFM/yNVv5im0cYj0H+dPZDeZ+8352spId
rOIJlrGRxTzEDaxmAUuYy3VM43ImRHpvGdH5nnXWb/aJ3znJ93ynYT2yvs8B
XVGP9Sk+9lwneViN2qEabVZpdN2+TSzQWtVa5/Ovz2UzS9tdW8RtzGQVM1jJ
hdzKBaxgOsuZGvv/f/gH9sNjmg==
             "]], 
            LineBox[CompressedData["
1:eJwl0jtIVmEcwOFXsoIkKHARQhARlyDIUDMt0NX7lIMGUV4hB/NzSSsUxbuL
l6mmLoKhgWA0RIGRi5qlYGrlJDh4qS/cjJ5Dw4/nfw7v956P95y0282V9xJC
CJO6cyqEnMQQWlnG+yxhC0vZwWq2s4ZDbOUgYxxjN0f57kwIPeaX5id8wad8
zVl+4Ce+5wIXuc1NxrnLhJMhHHHRXkta1met6Iu+alVrSrb2xOkQ0niOl3mB
hbypKuW5bmanupSeFMI4JzStGc3rozbUYf0mt7QX/RfP6XVv39zHA/bzkAP8
xUH+5hDjHOZFz/ljHjH/4EN+5yP+5GMuM8YltvENaznHOj5nDZ/xFjPsOWIu
Ng+zhA9YxAZmsZ5XWMFMFjCFl3iWqQyR9jpvjjvrv85+hwdc5wa/Re9Lb12/
4pTGo3fnPMai7yL6JtSoBlWqQjHry3lD13VsfZN7BdFa5kfreY31zGMdr7KW
ubzLOb/LTvz/ff4DrXFgbg==
             "]], 
            LineBox[CompressedData["
1:eJwl0j1IlHEAx/H/xVOBOdQgtNyQQ+QiZGNOutUSjaVk96JNd2cZpReYmkcO
aonSy5Took1ZCuoiCdpdL2N35RU0tDQYSOAk9Tkavnx+f+55uIfn7lQiezkT
CyE81uCRELoim/18xDuc5F0+5UM+4RgX+YILnGXsWAhL9rK9ySLfssRP/MEq
//AXDx0OYZ+f60Ioq6Iv+qodVfVN39Xg2uhoCI08wXOMs51XdFXnnX+7NmeP
qqBneq5XSvh8ia+1pYzzGc+8bWftd8yxyF6WeJPveYsf2Mcm93y0b9vLTPIN
U1xhmvPs4Bw7OcELHOdF5rnnWdvsHvssu9nCSzzNVp5kM+sZ51/vK+77j9fu
tw+8y5/cZZmVmtrQqnPk2pe130ozmtY95TXl8wHeUI8KzuueqdsetdN8wBRH
mOQwExzidd7nmnuuRf//P/8AsElThQ==
             "]], 
            LineBox[CompressedData["
1:eJwl0b8rxHEcx/GPuFMMysByKWEUg81CGZiU/P6xiJUoA/8AufN74g7nLMRG
bCxMlIlNfjOIkpRB8ijDs8dreHf3/d6V9g+3DGWFEMa0HA0hnhPCLjPc4Sb3
ecA9HjKSH8KpfWaf8JwXvOc1v/jK7EgI37zJC+FWd7rXgx71pGe9qMhtJDeE
MhayhiVsYK/e3PRxRKOa1JSSanWX4qebNnvVbucaO7jOTqbZxXLPv2F32xn2
MMFGxtnECdZxnPUc5LvPr7IH7Go2s4K1LGYl8xnjr/eO+Z4C+8P+8Zs88o1X
vOKlom6OeaRtbWlJi0q7W2Bws27P22uc4ypnmeIMkzz2fAl7xZ7O+f8//wDN
wUSJ
             "]], 
            LineBox[CompressedData["
1:eJwl0LsuRFEUgOGFGRMzZtwSCg0xKpdOIy4VKgoPQIyewvUVeA6Xig7jVkmo
CKHWjEaMhEYiIvGdKP58a2ev4uzTXVqeXaqJiAUd1EfspiJOeMbaXMSxuWw+
4ilveMtr3vGBFWbs3ptfzM/84jtT6Ygq08zayalReRXUpGa1qFXfdjvsFtWr
tkzEELvcTXBSc5rXij6yESN2Vs1r2kp2nLc5xQ2Ocp2fdsfMm+ZxLnKAJQ5y
hj2cTr7ZbtE8bG5nPxvYl7yDnXy18+t7C+a8fry54lzllbs3PulRl7pQnXeU
7Zyb97WnQ+ed1P///wNKaTFF
             "]], 
            
            LineBox[{2753, 1232, 1748, 1255, 1747, 1253, 1746, 1254, 2824, 
             1759, 1271, 1775, 1286, 1774, 1287, 2835, 2836, 2837, 2838, 2839,
              2840, 2841, 2842, 2843, 1786, 1304, 1318, 1319, 1812, 2794, 
             1334, 1351, 1823, 1352, 1353, 2849, 1376, 1835, 1377, 1836, 2850,
              1355, 1824, 1354, 1825, 1356, 1826, 1337, 2795, 1813, 1322, 
             1799, 1321, 1800, 1306, 2792, 1788, 1292, 1291, 1274, 1762, 2825,
              1258, 1257, 1749, 1256, 1234, 2754, 1233, 1737, 1231, 1736, 
             2753}], 
            
            LineBox[{2007, 2006, 2009, 1288, 2879, 2008, 1776, 1289, 1989, 
             2864, 2865, 2866, 2867, 2868, 2869, 2870, 2871, 2872, 1787, 1305,
              1990, 1993, 2873, 1992, 1991, 2000, 2001, 1994, 2875, 1335, 
             1995, 1996, 1336, 2876, 2002, 2005, 2013, 1320, 1798, 2003, 2877,
              2004, 2012, 2011, 2010, 1988, 2863, 1987, 1999, 1985, 1986, 
             2862, 1290, 1984, 1273, 1998, 1983, 2874, 1997, 1761, 1982, 1272,
              2878, 1760, 2007}]}, {}, {}}}, VertexNormals -> CompressedData["

1:eJx8fXVcVsHWtViImIANdndgAg42CBZ2BwJ2i4mBioFiKzaKqNgiFiBb7ACR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          "], VertexTextureCoordinates -> CompressedData["
1:eJy9nXdYFFm37lERwYyOihhHzLYJwTi4DIgZzGIGMxgGMYsYMYtxREUFxYAg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          "]], {}}}, {
      PlotRange -> {{-3, 3}, {-3, 3}}, Axes -> False, DisplayFunction -> 
       Identity, 
       Method -> {
        "MessagesHead" -> ComplexPlot, "AxisPadding" -> Scaled[0.02], 
         "DefaultPlotStyle" -> Automatic, "DefaultMeshStyle" -> Automatic, 
         "DefaultBoundaryStyle" -> Automatic, "DomainPadding" -> Scaled[0.02],
          "RangePadding" -> Scaled[0.02], "GridLinesInFront" -> True}, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.02]}}, FrameLabel -> {
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
         
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm]},
        ImageSize -> 160, AlignmentPoint -> Center, AspectRatio -> Automatic, 
       AxesLabel -> None, AxesOrigin -> Automatic, AxesStyle -> {}, 
       Background -> None, BaselinePosition -> Automatic, BaseStyle -> {}, 
       ColorOutput -> Automatic, ContentSelectable -> Automatic, 
       CoordinatesToolOptions -> Automatic, Epilog -> {}, FormatType :> 
       TraditionalForm, Frame -> True, FrameStyle -> {}, FrameTicks -> 
       Automatic, FrameTicksStyle -> {}, GridLines -> None, 
       GridLinesStyle -> {}, ImageMargins -> 0., ImagePadding -> All, 
       ImageSizeRaw -> Automatic, LabelStyle -> {}, PlotInteractivity :> True,
        PlotLabel -> None, PlotRangeClipping -> True, PlotRegion -> Automatic,
        PreserveImageOptions -> Automatic, Prolog -> {}, RotateLabel -> True, 
       Ticks -> Automatic, TicksStyle -> {}}], 
     GraphicsBox[{{
        GraphicsComplexBox[CompressedData["
1:eJyNfXd8jtcbdyQiKaqCqqK0jZaq3VD7uo2qttRqCUrtVYqIGVtsQRFbqJXW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         "], {{{
            EdgeForm[], 
            Texture[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJx021eQXHd+6HeV/eJHV/nVL/faD/a1HuyyS5YtW5ZUUkkrXSXu5Spwd7UM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                "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
               False], DefaultBaseStyle -> "ImageGraphics", 
              ImageSizeRaw -> {100., 100.}, 
              PlotRange -> {{0, 100.}, {0, 100.}}]], 
            GraphicsGroupBox[
             TagBox[{
               PolygonBox[CompressedData["
1:eJxNnHX8VcX39W+cuPd+VEQBBVHKAFHsBAnrByooGISNiWJjt4iUimIXJlKK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                "]], 
               PolygonBox[CompressedData["
1:eJw1nXXgFsUTxu+Ney9eGhWwaFFUlBAQJEUFUUTKQEBAEBRRsQAJUbBRUbAL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                "]], 
               PolygonBox[CompressedData["
1:eJwt1nuQzlUcx/HfsrvP7hOaaSzKNZISFc3oYtyiiJTpYkQymSQll6xuGiUh
19BFUXSZskuo1rgPYsJMLrmGNmkVURiN3Nf2OnP2j8/8zvd9Pt/v+Z7f5TzP
tX0HPzSoQpIk+ZRFa3OS5Eqgs6BeKknmp5OkUm6SvGeuY2aSdKdhWD4NMh5F
J8xV5WmDrauYJK1d94n30x56F2uKNaPmNAfrb43h1sin7dZsi6/m+9Vcq3Ss
sQG/z3wnqsQ/w9wxbLn4Gb0twErEX/M2ED+A34JtxEZjaeN/MvRm7liI8Zbi
bXrelK0v7Co1t+h/IPY6vYh9Tz8Z9+C9KyP6iuUOUe9+taZaZxx2SO568TYq
0nselmBDjBurX4SvFBcGblxHXrF6i9U6SSXqbQ73wNy3fAexL7FPscewudhv
ro2lV9ZPZzUnq3WCr5hvA98g89/wnXQt5OvPN5bvHb7fsTysVD/tsEnYbLpg
XEPuFr2MUKsUew4byPs8HZX3PnYeq873I98AvhXh3tMl632s5jTXI7wtrPkU
bz+5h8QFcsvEteXul/udnMvUS05tfB7PCrln+MYbX43XoPHiUr5HjJvwLQ73
BfsjPGO15tMM+y6Quw97SzyansA+w07wf6GHJ/Xzhvwpck/zXTR/IiuutQg7
47qHbwJPT95/w37l38B3L989tF7ecexb/eeKf+A5I35J/gw5X1MjczWxebRM
7kK+BfSn3Ll8l9WvJd7L9w12gerZWzY+Mzy30At2iGeM+B81TombXhHfnYd4
H6YybB5vBlaX94B6S7AJYX/iqalYN9TP0Mut6i9Jxfsd7vtYvj5qt6OW+Mnw
bF0PugeT7WMW/zSsBu8ItT+iEixXHyV81XjyqBl/pvoP8m5Wu5trgZxCetV4
Bc/S7PiNpcu/wRb660g3WvsDuVOxZeosp2H8ZeXrHjM+So/LbcSXwq437kDL
1czUSw4+SV4bvtaZ8T3NCHvmmSqew5eXG7//cA7UN3+ntdeJq1J3vh08h3lH
WvccpcSt7KVuxfg8FoTzIHyXFeI5cxqbSFl81bLju7k8fKs0xXitNdJ8bwYf
VspTRbyi/JmPxy5hlbBl2EJsM3VW/0msifxZPNfRdr6tmbHP0O9rau4Q/0Wv
YNeHczgdn80F7EOsNt8NeG/jXdjf4Rzj6UBF2Ffm7zfuSrWMa9L34TmE3l3H
4L31MZT66mk21pr+y44/CHPVaCknj140PqL+LnMNeYan4zOcJN7LftZedvOF
H5R2xv3kbxV3C986T4a4UI2uWCJ3ph428m2iMp47wtmL3e76i7iY2hmvx9q7
HgjnIfWls+pVCGeCen3K3/Eh4Tuikdb/nKcHtlPtbDqsxkDxC9RJz4Plf6SN
46n4Tk4U52fGcyGcD8dognGrzHg2ptSr7x3son5T9btUiM+tiE4Z78F30796
qRjul74K5I0L77haO8P9M98qFZ99eAem58bfpkb4cf5V2P5wrpn/BHvU3MLy
d3JA+D3AFpn7OyfeizX2dLP5m6hJ+E3GzlmzYjiH1BuaE3+3poR+5Y/Af86J
Z3Q4qxvqrSd/VnifU/H7vqhm21Cj/BuczzOPUupdgy2l8+oVh56z4pk9inKM
94UzRX5v8UWqIq+Tmk8ncY2Pc+P504v3bjW25cS9hD09i6/C307H+3dWTqE+
PlPjZSwXq66HImxp+B6wytga49XUwFxd9QfjZ8N/kOz4uxl+P6en4xmylq89
XxV5tXnrGM/FVtIIniXp+Dt5m7zmNET8P2snP9w=
                "]], 
               
               PolygonBox[{{2740, 1996, 1995, 2739, 2233, 2234}, {2738, 1982, 
                1761, 2346, 2075, 2076}}]}, 
              Annotation[#, 
               "Charting`Private`Tag$21821#1"]& ]]}, {}, {}, {}, {}}, {{
            Hue[0.67, 0.6, 0.6], 
            LineBox[CompressedData["
1:eJwl0jlPVFEYgOFPRlmUQcVdAWNjIjCimFiIJpSonTQinQWCC6CyqiyKUUPN
8geEAI2JSmIkNNrYkAi4dEQaGxOExAI1AZ4JxZP35jv3zJ0zd45db7rSuCUi
XvElEZG+/qQvOOr6AkVbI2r1Z1ZEpw4zSbP5vK6w08YUl1kwb9DnjFCeHXGa
U5RxkhSllFDMR/ctsk7ltojCjIgKamhnkAnzNzrLb1btS/qea+YlepFRvnGD
Od5TTwPHMyNu6i1uc4cTZo3aRDORE3FX75Gydl9baKWNdjoos9apD8iw56E+
oosz1rq1h14ec9bsifYxxneeMs8UdVSRdF+x/ne2XF1yzs9MO+NrHaCNq5yj
2rxA1/xuP3hn3wd9yTNWvIt6vUQpeSw7Zp/5nL5liF/ebYemzK/pefo9/ytF
rmd0gkLXBSTcd0QPc4iDrFs/oPvZx6LP3Kt7+GctX3ezK/1/IY8kf63l6g4W
7Nm++RrCUeKPNaPws4SjhsfGsln6VTl2jCc2/7cbX8ZPuw==
             "]]}, {
            Directive[
             GrayLevel[0.4], 
             Opacity[0.6], 
             AbsoluteThickness[1]], 
            LineBox[CompressedData["
1:eJwVzL8rxHEcx/E3cfgadMOVdAbDlVWJUhiU6Uq5FAZFSW64IxMZpEyixMh4
9wdYlMWPkZFJYVDHIIuu/Fg8DM+ez/fr+7nrWShPlhoiYgZPLRE/SUQZz3qP
V/GL5raIF9srztxvnNg+eN99jk/9hW8cuC8QrRGd3jVxY3vEhi3Rh3yFtM75
nuFZ94g3W3yKrO3St5S+5mUu/P8G3RjFg32Ac6h6n+dF3Nk7+IZP7IP+t67f
ceTe4V3usle829abtnVO245tK3rNVtNLuqjneJ4fbVN6Wud5gu9tY3pcD/Ew
39p6db/u4z8UUy8p
             "]], 
            LineBox[CompressedData["
1:eJwVzr8rxHEcx/H3dccd39IZKIlcCZmUKJKkTFfKpUxKSCxOJnUWZZIyGBn5
E1iUYmMkgzIgBgyWm/woD8Or5/Pz/Hy/376F+XJpNRURC/aUjditjzi1NUvX
RTxqGXzGH62Wv/AcvuGvluXvPMFP3NPOrMobtS/M4zdGEtHEU7mIFqzBtNbO
K95pw0Qr4KXzpnXxZu0cM87Dnj/BXudW/QLvbEpbtpJ16D04ZqN2734AO+3Y
XREX7UZvwCs81Ad9u8o/bN95G3f+/1U/8twWr2gbmNcOtDJf1175El/hsziH
D9o0n+FFnMRbbZxP8CEcwWutm/fzPvwDHiYv4w==
             "]], 
            LineBox[CompressedData["
1:eJwVyzFLglEcRvG/RLyvNSTRUgkRtLQKQRDUIjQJohBIReAQQaAYBRUYRNDk
4NKYo98hiL5AjbW2VZNDDbaVP4fDOfe59y7Xm5VGJiKq+EwiPvA3FXGCgf7G
g/7hIbr6H2f4Hb/F03jjiTTiXGemI1Kdz0Zk+cI2aZvROSS6bVtxP+d8pVPb
vF7ArvOW8zXvYw+P3ia85L7IJRzi1Z7jZ+65W/dvqAe4c77lDi/a+97d6Lbt
kmdt97aWPrV96SN9rA+4zu+2HV3TJS7zm62ot/UGb/KLbVWv6QKPAHJyKoM=

             "]], 
            LineBox[CompressedData["
1:eJwVzr8rxGEAx/GHuHPcnbqTu8jPKz8iShTJoExXUpRJKVKmu0SuLMRkvUyM
LP4DA1EWRiYlZTBhULJRXjd8er+f9/Pt6du1UpwvVIUQivYRDSEWC+ETE3hR
H8KmxfmX1og/mMRLfcua+J+WxivnbUvxXy2D1XUhNOONXrJWHtFaMIo1DSGU
9STv1OLYgQmMuMvxFO/GNPbjre93rY9ntF7MYsz3R3obH9Dasdb5mg+52+ev
fLDyVuU/bc7OK2/ghL24m8InHMWcnbnP46o9VP4N7/BEH/PuN3+3svMBHmJW
P/XdHt/RStioHWsFvqG98TW+zpdwGZ+1Bb7I8ziLj9o0n+HjOIn3Wg8f4cP4
DygMLqc=
             "]], 
            LineBox[CompressedData["
1:eJwVzj0oxHEcx/HfbeeMSixyKeLyUEopZboyKRZlkJiUh1ImZfE0KYmL4kR5
HCjKZLuziJjEgIFb5KEY3Mbrhk/v9/fz+/5+/398YKx7NBJCGJG6aAj1RSHE
MRsLoYU383Zsw2tdB0/yLuzEO10v7+GD2I/PumE+xFd4rDiEcT6hm8S0rkQ3
w6d0C5jDT2nSp8wZHrV3hX2YlE19BTZKQhqkVn7tzMue81Jzngf8w1bvLWK5
uUwicm5vSffGpyXFLwr/ihmsdGeZZ/kaXuIqftidlTS/1W3gDa7jl35Otvm9
bgsfsMpbu/yR7+ATHmIOq50d8Be+j69Yozvm7/yo8E08xW9MODvhP/wM8/gP
kt5AbA==
             "]], 
            LineBox[CompressedData["
1:eJwVzjsvw2EcR/GfzaUxEQsaTRiJkBAxSExNDNKkC4mhkXRymZqYmpjqHiNj
DYq61P0dMDJJxEINtXoFPoZvznnO/5KnL7eSWW6KiDl7bI7Ya4l4wGRbxGlr
xD3f1e6wVzvRbvmOdoM9WkW75ttaDbu1Y+2Kb2k//JJv8gvcwIZ2zku8it/Y
qdVxyPdn2hfv0D4xj7NW0Qdw3D70SXzDEUzZkedpzNmLnsAnPNRH/ff3/z62
77yOJezSy94r8jWtgO3agbbEV7U6X+R5Po8L+K5leJancQZftSk+zcdwAp+1
fj7MB/EPBGEyjQ==
             "]], 
            LineBox[CompressedData["
1:eJwVzr8rxHEcx/G3DZf1FtMVi1JyRUjKdKUU6UJJXJm4m5RJmc5oZMPMXyAD
wx2DHwsSi5vkJCc/ksjjhmfP5+f1/fb5flPzhfF8Q0TM4qcx4gsfzRGfXMMr
OhIR67aq3m+KeNdPuoIHtHtetN3rG7zpa9727hWf48V2xqd41ie8x2U+RlUf
8RIfcJ6zGHT3JC9iCofu/MMvRp2/uZX70Ys754H697mbU9h1X4bncGFPcIm3
7Gn31/QjNpzXuMhJ+473VvWKbZlbbJv1f9EFW0Xn9IKe5hm+tY3pCZ3hEb60
Delh3cN9XLa16S7dyf/XPzvy
             "]], 
            LineBox[CompressedData["
1:eJwVzj0oxHEcx/Gvm5xblbLoTDoPUcogpdSVSV0GZZCH6QqDMimTQcqiXFlO
GT1HcYkJiygWZcDEhiIi4mX49H7/3vf7/7r00HhurCwihi2SEQfWmIr4LY/Y
roj4wZI2xz9sn39qezjr/G6b9qbtak+4hXXeeOSr/AHX8A5f3d2wG76iXeGL
87pd8qJ2hkuY9sYpL/AjXMBq99r1Q+cdXsJvPcG/MI+9VmUZ67JbvQGbrcaW
fZPFATv3WxKPsaC3ePv5/z/bvPM0zmClXnRvik9qE5jSFrU8H9Xu+SAf4X3Y
j9daD8/xLHbjhdbBO3krtuGJVsubeD3+Afl0O6s=
             "]], 
            LineBox[CompressedData["
1:eJwNzD8ohAEch/HfsXCsNoN/izqJUgaps1yZrpMkBl3ddHUWdZMyyGCRibJQ
SrGcYrnFLWcSA4MycBMmDMq/dJ/h2/O8z+993978cq6UiIgFa2mP+E5GJPC/
LaKKf/ilVeyHb2KqI+KTn7u/4SkOaq/8xZ7sSBvQHvghv8MP397ile1pfe7r
2onVtDmc0C74Ga/itvda+S8WcdaO9W6csrQ9ug3hiPXYgXsGl+zaLYl13NVH
/f+dP9uW5zXcwC5933urvKytYKe2oxV5SWvwPC/weVzEey3LZ3gGp/FGm+Rp
PobjeKn182GewiZwmzSl
             "]], 
            LineBox[{921, 993, 913}]}, {
            Directive[
             GrayLevel[0.4], 
             Opacity[0.6], 
             AbsoluteThickness[1]], 
            
            LineBox[{1008, 1592, 1006, 1591, 1007, 1604, 1030, 1603, 1031, 
             1619, 1054}], 
            
            LineBox[{1012, 1595, 1011, 1594, 1009, 1593, 1010, 1606, 1032, 
             1605, 1033, 1621, 1055, 1620, 1056, 1629, 1070, 1628, 1071, 1647,
              1096, 2814, 1646, 1097, 1656, 1112, 1672, 1136}], 
            
            LineBox[{1017, 1599, 1016, 1598, 1015, 2810, 1597, 1013, 1596, 
             1014, 1609, 1036, 1608, 1034, 1607, 1035, 1623, 1057, 1622, 1058,
              1632, 1074, 1631, 1072, 1630, 1073, 1648, 1098, 1658, 1113, 
             1657, 2745, 1114, 1674, 1137, 1673, 1138, 1683, 1156, 1700, 1178,
              1699, 1179, 1711, 1202, 1725, 1220, 1739, 1246}], 
            
            LineBox[{1018, 1019, 1600, 1020, 2742, 1601, 1021, 1022, 1047, 
             1618, 1048, 1049, 1065, 1066, 1091, 1645, 1092, 1093, 1655, 1109,
              1133, 2748, 1134, 1153, 1154, 1698, 1177, 1200, 1201, 1724, 
             1219, 1738, 1245, 1265}], 
            
            LineBox[{1023, 1024, 1602, 1025, 1026, 1050, 1051, 1067, 1068, 
             1094, 1095, 1110, 2744, 1111, 1671, 1135, 1155}], 
            LineBox[{1027, 1028, 1029, 1052, 1053, 1069}], 
            
            LineBox[{1344, 1343, 1834, 1365, 1848, 1389, 1407, 1408, 1874, 
             1429, 1451, 1452, 2855, 1472, 1473, 1917, 1495, 1511, 1927, 1512,
              1513, 1537, 1538, 1555, 1954, 1556, 1557, 1578, 1971, 2861, 
             1579, 1972, 1580, 1581}], 
            
            LineBox[{1363, 1833, 1364, 1847, 1388, 1861, 1406, 1873, 1427, 
             1872, 1428, 1889, 1448, 1899, 1467, 1898, 1468, 2858, 1915, 1490,
              1914, 1491, 1924, 1506, 1942, 1530, 1941, 1528, 1940, 1529, 
             1950, 1545, 1949, 1546, 1965, 1568, 1964, 1566, 1963, 1567, 1976,
              1585, 1975, 2809, 1584, 1974, 1582, 1973, 1583}], 
            
            LineBox[{1450, 1449, 1901, 1471, 2859, 1493, 1494, 1509, 1510, 
             1535, 1536, 1553, 1554, 1575, 1970, 1576, 1577}], 
            
            LineBox[{1469, 1900, 1470, 1916, 1492, 1926, 2805, 1507, 1925, 
             1508, 1944, 1531, 1943, 1532, 1952, 1547, 1951, 1548, 1967, 1569,
              1966, 1570, 1979, 1588, 1978, 1586, 1977, 1587}], 
            LineBox[{1534, 1533, 1551, 1552, 1573, 1574}], 
            
            LineBox[{1549, 1953, 1550, 1969, 1571, 1968, 1572, 1981, 1589, 
             1980, 1590}], 
            LineBox[CompressedData["
1:eJwl009MznEcwPFvPJVpFaWkGIZ01JTNpck6KUWZfzmQS8my6FCL+TebjUtl
Jn8OjQqb2JzKsKUnRQduwiYnhoOZZGPL6zeH916f72/f5/v7Pb9nz8q6I9VN
CSGEuLYkhZAWC+HP/BD2mteY93AVd3M1D7KYdVzPAyziUZazmRU8zlq2cx8v
8hhnnX3B3GK+xHPs43X28gYf8CGfMs4nHOUEP/Atf/AzQ2II05xw7ku90LjG
9FyjimtEmfbOSQ5hBdNZyDyWcqd2aaN1E0/rjGqsLzM/JYR7HNCwnumNJvVF
5+37ym+a63m6rWOccd9EZuuma4t5izns5RL2MZf9zONtLuUdLuNdJvO3s66a
k8zXOC96b/zlnh2cZidn2MWP0XfgFM/yNVv5im0cYj0H+dPZDeZ+8352spId
rOIJlrGRxTzEDaxmAUuYy3VM43ImRHpvGdH5nnXWb/aJ3znJ93ynYT2yvs8B
XVGP9Sk+9lwneViN2qEabVZpdN2+TSzQWtVa5/Ovz2UzS9tdW8RtzGQVM1jJ
hdzKBaxgOsuZGvv/f/gH+KNjmg==
             "]], 
            LineBox[CompressedData["
1:eJwl0jtIVmEcwOFXsoIkKHARQhARlyDIUDMt0NX7lIMGUV4hB/NzSSsUxbuL
l6mmLoKhgWA0RIGRi5qlYGrlJDh4qS/cjJ5Dw4/nfw7v956P95y0282V9xJC
CJO6cyqEnMQQWlnG+yxhC0vZwWq2s4ZDbOUgYxxjN0f57kwIPeaX5id8wad8
zVl+4Ce+5wIXuc1NxrnLhJMhHHHNXqv6qi9a0Wcta0mLSrb2xOkQ0niOl3mB
hbypKuW5bmanupSeFMI4JzStGc3rozbUYf0mt7QX/RfP6XVv39zHA/bzkAP8
xUH+5hDjHOZFz/ljHjH/4EN+5yP+5GMuM8YltvENaznHOj5nDZ/xFjPsOWIu
Ng+zhA9YxAZmsZ5XWMFMFjCFl3iWqQyR9jpvjjvrv85+hwdc5wa/Re9Lb12/
4pTGo3fnPMai7yL6JtSoBlWqQjHry3lD13VsfZN7BdFa5kfreY31zGMdr7KW
ubzLOb/LTvz/ff4Dr1Fgbg==
             "]], 
            LineBox[CompressedData["
1:eJwl0j1IlHEAx/H/xVOBOdQgtNyQQ+QiZGNOutUSjaVk96JNd2cZpReYmkcO
aonSy5Took1ZCuoiCdpdL2N35RU0tDQYSOAk9Tkavnx+f+55uIfn7lQiezkT
CyE81uCRELoim/18xDuc5F0+5UM+4RgX+YILnGXsWAhL9rK9ySLfssRP/MEq
//AXDx0OYZ/f60L4pqp29FVfVFFZn9Xg2uhoCI08wXOMs51XdFXnnX+7NmeP
qqBneq5XSvh8ia+1pYzzGc+8bWftd8yxyF6WeJPveYsf2Mcm93y0b9vLTPIN
U1xhmvPs4Bw7OcELHOdF5rnnWdvsHvssu9nCSzzNVp5kM+sZ51/vK+77j9fu
tw+8y5/cZZmVmtrQqnPk2pe130ozmtY95TXl8wHeUI8KzuueqdsetdN8wBRH
mOQwExzidd7nmnuuRf//P/8AsilThQ==
             "]], 
            LineBox[CompressedData["
1:eJwl0b8rxHEcx/GPuFMMysByKWEUg81CGZiU/P6xiJUoA/8AufN74g7nLMRG
bCxMlIlNfjOIkpRB8ijDs8dreHf3/d6V9g+3DGWFEMa0HA0hnhPCLjPc4Sb3
ecA9HjKSH8KpfWaf8JwXvOc1v/jK7EgI33zJC+FZT3rUg+51p1vdqMhtJDeE
MhayhiVsYK/e3PRxRKOa1JSSanWX4qebNnvVbucaO7jOTqbZxXLPv2F32xn2
MMFGxtnECdZxnPUc5LvPr7IH7Go2s4K1LGYl8xnjr/eO+Z4C+8P+8Zs88o1X
vOKlom6OeaRtbWlJi0q7W2Bws27P22uc4ypnmeIMkzz2fAl7xZ7O+f8//wDP
oUSJ
             "]], 
            LineBox[CompressedData["
1:eJwl0DsvQwEYx+EXpxqt1i1hsBA1uWwWcZkwMfgARO0Mrl+Bz+EysaFuk4SJ
EGZLLaISFomIxNMYfnn+J+cdetpdXJ5dqomIBR3UR+wmESc8Y2024tgu2Uc8
5Q1vec07PrDMtNt7+8V+5hffmaQiKkyx1U2LmtWkvHJqVFYZfbvtcFtQr9rS
EUPs8m6Ck5rTvFb0kYkYcbNqr2mreuN5m1Pc4CjX+el2zN60x7nIARY5yBn2
cLr6m90W7GG7nf1sYB8z7OSrm1+/N2/n9OOby54rvPLujU961KUuVOc7Sm7O
7X3t6dDzTvL///8BTEkxRQ==
             "]], 
            
            LineBox[{2753, 1232, 1748, 1255, 1747, 1253, 1746, 1254, 2824, 
             1759, 1271, 1775, 1286, 1774, 1287, 2843, 2842, 2841, 2840, 2839,
              2838, 2837, 2836, 2835, 1786, 1304, 1318, 1319, 1812, 2794, 
             1334, 1351, 1823, 1352, 1353, 2849, 1376, 1835, 1377, 1836, 2850,
              1355, 1824, 1354, 1825, 1356, 1826, 1337, 2795, 1813, 1322, 
             1799, 1321, 1800, 1306, 2792, 1788, 1292, 1291, 1274, 1762, 2825,
              1258, 1257, 1749, 1256, 1234, 2754, 1233, 1737, 1231, 1736, 
             2753}], 
            
            LineBox[{2007, 2006, 2009, 1288, 2879, 2008, 1776, 1289, 1989, 
             2872, 2871, 2870, 2869, 2868, 2867, 2866, 2865, 2864, 1787, 1305,
              1990, 1993, 2873, 1992, 1991, 2000, 2001, 1994, 2875, 1335, 
             1995, 1996, 1336, 2876, 2002, 2005, 2013, 1320, 1798, 2003, 2877,
              2004, 2012, 2011, 2010, 1988, 2863, 1987, 1999, 1985, 1986, 
             2862, 1290, 1984, 1273, 1998, 1983, 2874, 1997, 1761, 1982, 1272,
              2878, 1760, 2007}]}, {}, {}}}, VertexNormals -> CompressedData["

1:eJx8fXVcVsHWtViImIANdndgAg42CBZ2BwJ2i4mBioFiKzaKqNgiFiBb7ACR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          "], VertexTextureCoordinates -> CompressedData["
1:eJyNvXVYFV3U94+NdSuiqGBjoGIhtrBMbDBQj94GGCi2qBhggi2KhYoK3hYG
KgbqMVBCRLo7DnHoMsHkHd8f35nnWeflun7+M9fHOcys2d8da6+99kznJetn
Lq+tpqZGjdXU/h6Ff4NNHJYY4/h8VubmFx7/EVi9y3uF3OOhyP1d2x90sXsh
ct+GL1zkHr4ijxqvLPDQCBTZfG9zIxe7YJFXvh7h7KgMF9nH/vFGuUeUyEHa
ky56pcaIHP08PcBDI17k1DmbS91MEkXO/dKwjYtdssjlp9xHO3mlivyz/6DV
jsp0kfetWB5s5KQQ+dDg/ovlHpkiH6v387OhX5bIp2LfHfJKzRbZ5Zpze/2K
HJEv2vz7yEMjV+Qro7tP0NXPE/lG848pbib5It/JeLlB27JA5Af3D9RzsSsU
+cnOGa4aLkUiv5jarp+TV7HIb3Ty/NVDSkQOKHwoc1SWihwsty+pqiqjmnTl
R+gLhr5g6AuGvmDoC4a+YOgLhr5g6AuGvmDoC4a+YOgLhr5g6AuGvmDoC4a+
YOgLhr5g6AuGvmDoC4a+YOgLhr5g6AuGvjW1U64rP0JfMPQFQ18w9AVDXzD0
BUNfMPQFQ18w9AVDXzD0BUNfMPQFQ18w9AVDXzD0BUNfMPQFQ18w9AVDXzD0
BUNfMPQFQ9+a+l3eTrmu/Ah9wdAXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfcHQ
Fwx9wdAXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfcHQFwx9wdC3pnGU97u8nXJd
+RH6gqEvGPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKh
Lxj6gqEvGPqCoS8Y+oKhLxj61uQX8XGU97u8nXJd+RH6gqEvGPqCoS8Y+oKh
Lxj6gqEvGPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKh
b01+LveL+DjK+13eTrmu/Ah9wdAXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfcHQ
Fwx9wdAXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfWuat3A/l/tFfBzl/S5vp1xX
foS+YOgLhr5g6AuGvmDoC4a+YOgLhr5g6AuGvmDoC4a+YOgLhr5g6AuGvmDo
C4a+YOgLhr5g6FvTPJTPW7ify/0iPo7yfpe3U64rP0JfMPQFQ18w9AVDXzD0
BUNfMPQFQ18w9AVDXzD0BUNfMPQFQ18w9AVDXzD0BUNfMPQFQ9+a4gp8Hsrn
LdzP5X4RH0d5v8vbKdeVH6EvGPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKhLxj6
gqEvGPqCoS8Y+oKhLxj6gqEvGPrWFCficQU+D+XzFu7ncr+Ij6O83+XtlOvK
j9AXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfcHQFwx9
wdC3prgfjxPxuAKfh/J5C/dzuV/Ex1He7/J2ynXlR+gLhr5g6AuGvmDoC4a+
YOgLhr5g6AuGvmDoC4a+YOgLhr5g6AuGvmDoC4a+NcVxedyPx4l4XIHPQ/m8
hfu53C/i4yjvd3k75bryI/QFQ18w9AVDXzD0BUNfMPQFQ18w9AVDXzD0BUNf
MPQFQ18w9AVDXzD0rSkuz+O4PO7H40Q8rsDnoXzewv1c7hfxcZT3u7ydcl35
EfqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+oKhb03rLDwu
z+O4PO7H40Q8rsDnoXzewv1c7hfxcZT3u7ydcl35EfqCoS8Y+oKhLxj6gqEv
GPqCoS8Y+oKhLxj6gqEvGPqCoS8Y+ta0bsbXWXhcnsdxedyPx4l4XIHPQ/m8
hfu53C/i4yjvd3k75bryI/QFQ18w9AVDXzD0BUNfMPQFQ18w9AVDXzD0BUNf
MPQFQ9+a1kH5uhlfZ+FxeR7H5XE/HificQU+D+XzFu7ncr+Ij6O83+XtlOvK
j9AXDH3B0BcMfcHQFwx9wdAXDH3B0BcMfcHQFwx9wdC3pnVtvg7K1834OguP
y/M4Lo/78TgRjyvweSift3A/l/tFfBzl/S5vp1xXfoS+YOgLhr5g6AuGvmDo
C4a+YOgLhr5g6AuGvmDoW1OeAl/X5uugfN2Mr7PwuDyP4/K4H48T8bgCn4fy
eQv3c7lfxMdR3u/ydsp15UfoC4a+YOgLhr5g6AuGvmDoC4a+YOgLhr5g6FtT
3gnPU+Dr2nwdlK+b8XUWHpfncVwe9+NxIh5X4PNQPm/hfi73i/g4yvtd3k65
rvwIfcHQFwx9wdAXDH3B0BcMfcHQFwx9wdC3pjwinnfC8xT4ujZfB+XrZnyd
hcfleRyXx/14nIjHFfg8lM9buJ/L/SI+jvJ+l7dTris/Ql8w9AVDXzD0BUNf
MPQFQ18w9AVD35rywngeEc874XkKfF2br4PydTO+zsLj8jyOy+N+PE7E4wp8
HsrnLdzP5X4RH0d5v8vbKdeVH6EvGPqCoS8Y+oKhLxj6gqEvGPrWlOfH88J4
HhHPO+F5Cnxdm6+D8nUzvs7C4/I8jsvjfjxOxOMKfB7K5y3cz+V+ER9Heb/L
2ynXlR+hLxj6gqEvGPqCoS8Y+oKhb015mzzPj+eF8TwinnfC8xT4ujZfB+Xr
ZnydhcfleRyXx/14nIjHFfg8lM9buJ/L/SI+jvJ+l7dTris/Ql8w9AVDXzD0
BUNfMPStKQ+X523yPD+eF8bziHjeCc9T4OvafB2Ur5vxdRYel+dxXB7343Ei
Hlfg81A+b+F+LveL+DjK+13eTrmu/Ah9wdAXDH3B0BcMfWvKq+Z5uDxvk+f5
8bwwnkfE8054ngJf1+broHzdjK+z8Lg8j+PyuB+PE/G4Ap+H8nkL93O5X8TH
Ud7v8nbKdeVH6AuGvmDoC4a+NeXJ87xqnofL8zZ5nh/PC+N5RDzvhOcp8HVt
vg7K1834OguPy/M4Lo/78TgRjyvweSift3A/l/tFfBzl/S5vp1xXfoS+YOgL
hr417XvgefI8r5rn4fK8TZ7nx/PCeB4RzzvheQp8XZuvg/J1M77OwuPyPI7L
4348TsTjCnweyuct3M/lfhEfR3m/y9sp15UfoS8Y+ta0j4Xve+B58jyvmufh
8rxNnufH88J4HhHPO+F5Cnxdm6+D8nUzvs7C4/I8jsvjfjxOxOMKfB7K5y3c
z+V+ER9Heb/L2ynXlR+hb037kvg+Fr7vgefJ87xqnofL8zZ5nh/PC+N5RDzv
hOcp8HVtvg7K1834OguPy/M4Lo/78TgRjyvweSift3A/l/tFfBzl/S5vp1xX
fvxmuSpePSRNPNaLCD5jp50pHjs9a3X5pcdJ8Yj6AJ4ws7Wun02ZeB7X/R+/
F/4pqNg/1lPDJUW8LriR29meFYZZKudhD86DcT1uN/4f+vH/xxF68ufFedyP
213Tc/yPddb/ZRfO/491uv9lBy9nvr5ZUznhfjWVE66D87gefy4w1xH6gms6
/j90/l9/x9ed8Rwof16O3E6+js/15uXOywXMyw335fWE61ST3fg9X5/k5cnb
GcrF97GB0s1EIR53nncd5GeTIR7///4/7MT/8/pV0+8UO3eVvPbYKx7V609W
t5SX1fj//Ahd8bttHyKumMjSxfuBcb9xOucfpMYoVBi/59fF72q6Lrim68Iu
Xv78Ofm4xv+fPzd+B515+8X/o17w87z+oF6BUd9r+n/wph91m4QYSUeUC3RG
OfD6UNPvAvf93q5tmanCOPJ+ZVLhknGyUun3OM+fH4zr4O/47/D/OIr5ZFuM
VwXYnKNOm2/Wr6V2T/Q79FKaDrh18rnKviz8fo7+yM6r6gao7ONR06+bP89v
Jl1KvzTeUi7tC4E/oVBrOvG8nQv9s2lBg0G1o1XykC0mrKjXMdNBynv02uTd
8I4Gtdn3PlV9ipQH+cX40km7ZGndT1wHrP49/ANcD/4B7r8tcIa98o+0jiQL
On/fY4YU5xLjXtXPI8aNqp+/8IvXVuUfKQ52cVz69+AS1XkYfu9z/mxZVT/J
b8cR5Y7f8X2MQ8uu9O1TcYsiP4X46uq/VtlHc15n+WX7VZ6kN3hClIZWqMo+
jPM9Tw3qU3FVLM82z9btUVN7SD1fXHO3e5GgkjeaqMw59TD1ntgeZIoCN3vt
u2L/u2dhcdcl8ttiPQWjnuH38N9wPeiD+xd16dvfr0uOyroO7IW/hufbYnD/
qN2PfJU4FMrn5t7Ag3bzi1XmQSjf6U3up1qPU90vjHoOf7q5e1aavMcT8cj3
oXXSbD6jYchjst8wNFFDK1BlH0QT+YnZsYee0dBe+/aZLY1WyaP3nH2gVm76
Y7F+glE/8ffZhT7GsvBclTg57q/I/njYbkehSpwGdnfwHBugbleiMk/A86Ic
UK9QjnyfrN7J1oPVRklHvs9yzbsNW9T2SPu4lo0L8vdKfUuG8npbdUPDVPf9
7PBoaK/9SqyP9msKJrjo+NL9Hp4tQnYmqOQpq008aDXI742Uz/K7e4pjNx+x
Pupfa6wxQfZarI9gMZ+l+vdiHkj19VAfcX+94tu22qNzVNcRq+1FfcTzPTpp
3KXiWL5KXBvlgfqJcnuqs+NT1YMilTgLyr/Jx1Z9nDZI83T0D+hn0T/wcuf7
ILUU6+o3nBJAc1o96aO2J0hlH86cJYV6g2q/o2Xtv98zqYxW2ccxNcC8yijM
T6yfYNRP/L3pxjq3Ux1yVdZpcP87P059qcqQ1nFm5s34WPWgWCXugOdD+xT3
i1b3u3w/KNod2gHfD4rnhh18X9mXWd7lNhHvqe5hzROOygiVfQ1eQz4bhqR9
oMiGy6bLjieo5MXbvtR+6bUgSKyPj7ze/Ge29L1YH98ejTxYWiDlbYJRH/F7
1EdcD/UR92/zMywhZmiOyro17PdpPyLVrX6+yroJnv/HhGU+RiWFKnFZlN+l
32lxbgekuF7h78Yxbt9U93NiHEd/gXEG/TLfv4l2j3bC92m2+Gz6wUQWIh75
PrCA418buweG06Uxtz+7Baru3zSPPhtkUhki5eVUsxjfqf77R4t6H/Bql6uy
Doz7jhjrOa20Z4HKOgTszyttGhETVKQS58Tzm9zvOVg2THW/JMoL4xjv9/h+
R9RDUVe2z/FFXQ0NtVHSke+zca5ftFG+NYp+vD0cYlOWoLJPY4XLO+2QnZFi
fU20XPzSzi9CrK+l43UOyntEiPUVjPqK36O+4nqor7i/Q8cRribqOSp5FLD7
6s6tFVWL81TWafH8te9Gj9VtIq3zPW8essvLXlo3sEq7qe8UKcUh0T/Cj4Rf
x/cnYhzGuMr3J6IfRL/G9yeiHqJe8X1rwTmup5Xp0fSfxuZD2pmxKnn187Ja
Zal7x9DUeNkWM/80lbxsnE8+M2u8rEOmSt4Yrt+v4t1LmxNKlbwF2Gd6qbaR
zDRfZV0Uz7dqxTtvmzeFKusuKJ90ddMtyn9U9xOifL+fe2OkO1WKC8Kv5n4N
H0d4u+X7/1BueE6+j6ifeeHQii+xdP2av0Xp7USVfSiKMas6uujEivUVjPqK
v+/b1y1C/W62Sp4W7u/qZDDYyVnK41p1NHlaaS0pb6AkvNcer6nSOuTkQRGk
6yita2QtKXSw8/of+/Gq5yF8/x38bvjBfP8d/CD4JXz/HcYljBN8/x36AbRL
vs8u8tyy814L4sUj3+fxaPrwCU6JCTShy/Jl8h5pKvsEcD51Xdg03TWZKnmq
uG6bJ2GPPaJyVPKkYN8z+0YTdMflqeRh4Pk0DfwNnA4VqKzzonwyr9dbpy0v
UllHQvm27/mprCpDWmdaYv7ogc3/Yz8d5pWYp3C/k4/7vF/l+99QT1Hv+L43
r8Z392lnJolHvm+q2/LiYJutUt4+GPUZf6e3446PTTPV/W64f37ckaWO+5Xi
+VDDyzbavlKeWpcZw6Ji8qW8F7XW/WbJG0jrrFcfRuUadlHdr4bywjyP++Xc
L+LjDm+3/Ll5PHKtk0ZHy4apNOa8SUrMUCl+uTbssKtJgJQH7Zw+udzwk1Lk
wz30NCybSXlaMZrOrfV7SHkfpp0uLjMbIa0j/7DUGCwzldalMK/l8wzu5/Fx
lO+vQr+Pfp7vr0I7Q7vi+6vsI2wmyY6nieXA92ngPNofrnczYckCuabq/inY
E/PP1+N23aS8U8e+w9w0Bkt5bM3TGi9yHC/lxbgeTW9fYS6ts+sNf5hmvay0
xrgAn5dxv5j7HSgf3s+A8fxgPB8YzwPG84DxPGA8DxjPA0b95vNI7sdzP4nv
z8G4zscpsV+u7kd5u0d953n7+D3qP88Lxv3QHnAe7QGM9gBGewCjPYjPV90/
8nk0n8dwP5GPw7wf4/tTJg3busHsp7ROA0Z/h9+jfwOjfwOjfxPtre7fwOjf
xPPV4zXfT4A4I8ZrHjfg8zbuF/P9HfBDME7y/R14Tt7PoV3z/Rw4j3rB93fg
euI+h+r7Y3zG7zEegzH+gjHegjG+8nVZlBfGW5yHv8j3YyAOyONiYvypOi7D
4xLwh8R5MpsXwh/CvAT+Jd9/gXLAuMn3W/B+BizGM6v/HuXK87Jxf/iXPO8T
9sPf5HlleH74nzxvBeUHfxTn4Y+CMT/icUYe1+HzaL7fAfMQ+M18fwPaJR+X
Me7w/Qw4j36L72/A9fD/uD+O+H/Mf8CY74AxvwFjPsP3k2BdAPN3vt8AcVnM
5/l+A8TFMJ/n+w0Ql8C8mO8vQD2Bn8z3D/BxDgyd8feodzxPHPfHfJznocJ+
zMd5nhueH/NznkeD8sN8XYzrV8eLeByV5+8jroU4Dc/fh92Y9/J8ffRj3O/l
fiH3e7jfwMdNPs7wfhPPCftQzjxvG8+H+BPOI94ERnxJzK+vjofyfGysW6E/
xToJ4qM8vx5xazFOy/LpYRfiMjyfHu2Mz5Mxb+P57TiPfo7nu+N6eE7cH+XE
82RhP+KbPA8Pz4/4Js/zQXkh3inm+1fH13n+OtZZEG/n+euIcyPuyvPV0Y4Q
h+H56Rhn+byMz1u4X879Wu7XcT+Ij+uor7AP7Z7nmeP5cOR5rCgfxPdxHvF8
vl8A66ZYb+LrJDxfHDojLsvzw9HP8zgN4gQ8XxvnMa7y/G1cD/UC90e9w++x
nsPzAPF8WM/h+fNYp8Q6Hc+vxnX5ugni9jy/Gv0Gj5sirsfzqeHH8Xk/nxfz
eR+fN/F5A/ezud8o7uurtg/jCM+fxvOg3uD5Uc94/jTKC+0f5Yv1TzFfvLp9
83xarNujvePvsC7H85/Rr2AdgOc7w8/gcULEpXj+Mc7Dj+P5yLge6iPuj36O
5xfDfpQDz1PE86J98nxx5Clg3ZznD6NeY92O5wtj3OJxe8SReX4w5hE87sTj
MjzuwOftfN7K53l83oL6CPvgt/B8YDwP6hueH+2c5/Wi/HDk+dkod6zD83xd
nOfrclhX4vm58GN5HJrHPRG34/m0OI95G8+vxfW434z6CPswrvJ8Wl7PwKiH
+H1x6eHW9tpepJYSFrBT+zK9Tc8zaxjyhCw2JbTdo32Y5riNSNIY/I7UNmxZ
FmBzidbc+TfMJPE9WSiGJH6yPkZ75nnleJwMJrX6Hz0/apjQss51DPSnxFB/
jaWz+w5xJfWtxoEewnzF64hP1WYzZwpMC0tXPxpParI1r81ku8izc8NV8glS
vpGF+/y6IWnZwvnmezNvdaYLu5vlW69TksXxQ6O2RjjRzX3lp022FdCeAQXP
BumvEO3Gc7xt3FUr1MhDPHrV9Z9hOewttTF4dK+Fyz2qr6Z00PX0ozb9nHou
kd+gK20DCmwiwqj8yYMefSruU/QLgzSjaZHkZXio/Tm7WxTQKvKPdUAUlesE
phk7XSXXU3U3OXZLpMrm6p/NdB9ShX5usnpREjnX3ZDYMOQ+dRh0MjMmKIX2
zNbxvaXhSe3+Kym3Dkij5u9mlLmb3KHvVtk2ZtkZ5FVn1qMWLrepf8MxOW5a
mXR+3d0WoUZ3qF0f1076c4X+/PWeo7lunvTpyqZhTm+zqcn+QVbugV7Uq0eU
tv7cPJJ5nngwQXZd1Am6Ta23cMOgMc/E47G2eqsH+b0ki/+iAmSljyhy9fxG
sYeCSH/9w84tXJ5SXd9WD5QdQsTz91f4Da9YEEOhYbXrPbR/LuqndvrSMZeX
3hTff283y+3x1Kb2jKXuJo+pzdqwE3arlNR83T2bQWO8xXJGueO6sEM/bGVu
6iZf8diuy9LFFU/8qUno+jYtXHxIkfxPZqqmlGfRsq/tWtm6cIrf/mWTU39f
yiheXeF2IJJSo2ePaxjiQ5VDtjUYVBhFbQ72T3fc/5I2ecvUBrVIpAWB+14o
jX3pts3xr9YBSaI9u5ZqDfc7lULO5mbNJiT6kEubf34Y7kujUK+ElYP8XlOf
10G6+ucy6FfwautBY15TS8fZDspSBb3a5WYae+g1dRoxI0p9YBZV+nRr0yLe
h5zPb06MuZVN3dtuiTNJfEubuxywU97Po9Ar7XrdOulDL66vW6+9V/ALJy+M
l3u8ENsR2hXqIeolygHlsmaIQcPYQx9owc/6T5Ud3lHk/gb7SgtCyLPpwxQN
LX96avb5s9uBGGr3YNhFx+XvxHjfL7tfUSaJ/qRuVXzbZFs8uSyNs6jY7Eee
d4Zs0d6rJMduc77aRPjT/TmG79TvFlPLtePHuPx8J7ZrtHPUE9Qb6AKdYBfs
3FBs1n3QmPfiMXSbsaNZdiRt2N59id+nIOpkaDZQXz+aaj9pt9ZJ+z25lUWY
yf5JpMRH76vUGwfTqPUXF5feTiJ124GhJolB5DOtyT0NqxQq/Vag6Z77nnaV
F28xG5tG89X2zNQf8p7+3EoIMZqWQRMH9bqrnRlIFX9WdtF/r6AW1z5Psvwe
SJT5bJG8WRZ1KK+T7/HwPaVo2TV1uZhN9keUZvpbP1C41sTgmPwysvpq5KXs
IPVj6NfQL6CfQH1Gu0G9RD2FLtApsFbHSA2tMPHoM7XWY68FEeTZPH6x36dg
etZz7S/r2BgySXGYWREbTgH9dto6dosj07vbPhs1DaPQRF/NEKd4mugbn5y6
KYRcYw3myyuUtGz8hX4hO8PFfgr9FtoF2gnKHTrgvrDj1aglvqmbosSj+oCV
903OR9OfU9GOZksjxf7O/vnYb24HoqjuuIkbHW8kUWrIx2CPqEhq2TX6s/W4
FMpqmqvrMiKSRh2emKDeOI3q33F6aecaQQ3eje9TUTeD9igXtFzVNYKSt9v7
2rgrKKj++TWyvhHkZdZnn7I0k+pptDmuXStSjOdV9FtWZT0uinJXv/oR3KeY
tF5+Vh90NZKG12uw3+5FKd19uDDYY0aUOM5g3EE/jX4b/Rj6NfQT6DfQbtCO
UC9RT6ELdEK5oJyePR07tMIxju63uf+P2vQYGr3h3Wr5+3jqY+jaJmRhNNmP
tqml9jadJvc+MED/WQw18rvja7NVQQkRMYe1H8aI4yLvZ8Fox2jXqBeoJ7gv
7Jg80HVYxYJY8Zjs8X27mX8SBa4O7245L44uhfVu7TIihXZ9XuXqdSmWzIe9
/2GYlUr6vhvMZf/E0sSpw4utYzNposlCb43BsXTzfltDJ4t8Cp7jOsWpeSy5
294Zo9ukiDzuOLcK+R1LxjPvzJDPFfz2bssV6r3jhPH9dxe/Q2UUqpbZT183
ThznMe5j3ES9wjiCcQX9Nvpx9Fvox9BPoN9Au0A7QT3F9aEDdLn61abSelyC
eDy38YiJ04ZEcor50s5lRDxdGXd9teP+dNq3KrvULTeBSkb6WMjNFPSoVncd
l5AE+lGat1H5p4yMfSdXWI+T/Bb4MfAD4Bdg3ME4hH4N/RzaEdoVdIJusAt2
Ttkzf5qsb7J4fD6zzTazpSn04Mk+U1nfJBo4t9lrj6hU6qiTYy1fkUgPHtbt
VSHoqT+tvaP2f4lUN3+aWsjCPDHubnG5frHh1QKaFN1QGROUSE/lVyeXfigi
RbiWmex+Ii0yG6apn1dCOj5tnJS7EkW/Bn4OxlGMq+in0W+jX0A/gXqHegi7
8RzBik9L5CvS6e2YhcP8DFLJtsNir9QeCkpSO900RJlCq+Z9fG3zIJv+u/Tt
rsacVEpdMKNbRY6SNqw42kN/birtrPj83KYqj9wtbvw07JJKlXWq6rloFtJe
I+cxTooU6jzx5yujbsX09vDChaUXUqj/lwnnNAaXUtCNEB+PGSminwa/DX4B
/ASMOxiH0M+h30M7R7tHu0I7Q71CPYNO0A3PjXIw/ZOUY22YT1OaNNip7ZtO
I1o73PMYXUgtavd96bFRmJf117dVmhZTYoX5d8Mu6aQ1Kc5Yd0EpuZfYDfGL
ThP9TPid8Gvg52DcxDiKfhr9Nvop9FtoB2gX0AU69aha88lQO4e6HXAwdrLI
oJZttF7a9MilYrs79toaGeQemL9DOTif7NsvtHbcqaD7NoNmyycU0p7eLbUt
5ynoyoHomfK5xWT9n06ptaGC3kUkx7pZlZLD1OMmsn8Uop8Mvxl+Gfw0jPvw
AzDOYNwpWXy72Hpzpnjc8KnpFN3QbLIy39ZZ/1wmvZl8/JBXkxzySusTbPRa
Qavc38fFVCppztJL+5THM2l+4cg86665NCbDpKpKuN6us+00LNvmk8XLf8/Y
7cikgqrFRYYGheR7sOF42aJMym2onCmfUEzenyv3KY0z6UF2o1ou/5aSTb/D
DULaZ4p+Pvx++JXwM+G3wI/BOIlxE/00+m20c7T7Wzd8EmNWZtP1+M9jZaZZ
NOpA8COPh0oyaLvqi+GSLPrne5NSw6w8+laiVT9kYRaN21dvhKx+IXVO2t6z
YmoWrWul1aGiazGNCv+S5TY4i25NLt2kNC6lDcuHNHPRyRLnJZinwA+GXww/
C34XxnWM82jHaNfQAbrAbjxH8puZSTH5WeJxmMv+j4ZZOWT4/sUC+ftsah98
fo3ZLCVp6tcZK+uQTRraB7X1z+XRn7R/3xv1yaadXT5PLf1QQBYTDSLVe2dT
rPGJux4fi+hu4NB6Ie2z6VnVtiVmmqXkWHDslF0jaZ7ea/3Pybqp0rwU81TU
c9R71BvUI9gFO/vtD6wTslA6FigfbdKOyqWMCe0n617KIT/ddEevkXn0+OnO
QKOSbLpnNvmDum4BuWp2tNWW59BkzX/eGu0soAHqbRJjKrNJ2yO4h9+SIvoV
2vBuqn8OWZsuPmniVUQmN2J2K79l0+uMs5r650rozApaayacz/ztVsslpUS8
/vQe+y3M/MuoncYFZ7sXOeI8G/NucV5XPc/DvAHzCPih8EvRD6NfRrtBO0K9
Qz2ETtBtfq7BUsco6Xjr863Kqrm5dL1r+lJHIyXpx3V28HqVT+1X+gYYrVVS
rcw9U0obFonrlVfWrunrNLGE7AIU7fRPKOlO49oyx51lIqMfQr+Edox2DR2g
C+4LO/Y8dTGSheeRXV7IrdTHf99vt7i33+R86rr6Q62QVrlUFf38+oJhhVS+
XJZbUJBLQ88MSHK7WUhdZfUPeI3MpfZlw5aZnSimujlj7ZWN8sjk5uIM6/Ji
0gt1W+I4I5dGu+m20E8opfZfz6mFtM8j2zxzJ5O+ZTRt/Z9c6/m54rwfcQDM
MzHvxLiOcR7jIMZFjCMYV9APo19GP4Z+Df0C+gm0I7Qr1CPUW5QLyulqhqm7
hol0jLVrtNJsbAFFelJMjF4+XbO0XWHmX0AX/BVGsuOC/eO3JLh1LybnhpMd
vV7lkbd9j+Mm20rJ5aqVhmVSnuiHwi9Fu0A7Qb1APYEu0An3hR3HqfKo3Yt8
8Xj2leZhu+FFdLTDrsWO9QroSGbta6mPi2jH5qs51suEvwtZnmd4tYR8Tgw/
YzK0gB7W3d/HqXkpnft+fLzusXzy8T/jYPejjNwLYuq7/CvFqRC3gp8Fvwt+
CfwUjOsY5zEuYpzEuIJxBv00+m30a+jn0E+g30C9RD1FuUOH7Lprntr0KxSP
PUfvOmXyXKi/No9/B18uENcFJk569V7drpC0oz+8NOpTQk2WW/8OTiugXZ3c
DWXHy2hZq9tTSxtKcQ/EQTBvwDwC/Rb6MbRjtGu0G7Qj6AKdYBfs3FX/0ysj
Yb64fUgPPb8WRfRPnxVp1tdL6c+b+h0rzItoj3lqqnW7MlrV5uFhu0eFYtwD
cRDMMzHvhB8Mvxh+I/xI+F3ww+C3wI/BuA8/AOMoxlWMOxiH0G+jH0c/gX4D
7QLtBPUS9RS6QCeUA8rFO3R5oPq1IvGI+hz+y3Wm/GAxpad2jXPrXirag3kd
5nkYRzCuoF9Fv4t+DP0a2gnug3qCeoP74vycxV9myFtLR4Or56vOXiwjvbp1
4t2sSsR5P+IAmJdgngI/Hn49/GD4xfAj4VfCD4NfBr8Gfg78APgF6O8wjqKf
Rr+Nfgr9FvoF9BOoh6iXKGeU+7g3l411j0lHvZNJGvqty6iL3z87vX6ViHEq
xK0wz8a8G/NSzFPht8CPwTiPcZ+PkxhnMO6gH0O/hnaNdo52hHYFnaAb7MZz
aPqPdjfxyhDnDa4nDpjqhirEeQ/88m6j7nXXb51GVxbNyHbLzRTnQ8qxI456
vZL2mZ/ePXi7dtMs8bpgPm/EedwH98V9cF+sfyEPdPC2wwVuB6T3VcAO2FXT
fcE8jxbXwXWRZ4l1NuQV8/30eG7YjfvzvFX8ju/Px//j+nzfPezBEf+P8sGR
54nCDtjl7Vm5SJ6QSYmy2mftChU0s+h7Z/0emRQ7c3Gx9ZNMSj9ddsfkfJz0
XrS7ZwI8ZkjfxTLP6HRVI156j/SY1Z/7+hkoxd8bFG9r8nTH/3ivtPaSFiGv
E8R15F1+61/bdJTeM61m/NW/Uv1fle+d3m9boT9on7TPY85xg+8G29/SRoMG
+vpbE1XeO25V33Oi1aa3VHlxxToz/2yV9/7EynZMcLHzpa1X5/V2KpfeC+Ts
rtg5Xfe29N7F6ngHOCm550L5Cum95pHv/Ix110jvicJz/iiO2qlb/J7aNFw4
peHz5+I65ctap4vdcpNELjadG6neOFvlvWGd9Gefd1S+l77fWrzyspluCL26
KrOTrfNT+e5Qoe30T0ZNw8lu76Ge+u7JKu/Nt9c6tbu0YTj98XMcK7svvVd/
X5Ozy82Wqn7/EPFyPFdgRucKt8BIuhW3rFHs7iBp3XrEV+/UWSkiaxncLLI2
z1J5D6Xe5Moq64BI8TlDP/g3U7OIpjGzXCOMmkrf0XFu7HbJpFLKC8f66SLr
epe9FkRTeWKDGM15+Sr7z9ZOOtHR5af0fbyNAwcMrTgTR7vjWn2yDpC+y7Nx
ssVRr0vSdyCwvl03xuadx8k4atHp/qbhcdL+JqxvRzxermf5XfrOXsvHvyY4
9U+ggaHHLngtiBPrZeuvj0Y13SntB8J6sG37mOmyvgnUOuL6EKfpSpX9Ri/a
rdrguDyZxr0qi1MfJH1HxsXg5UazbOm7I6jf7Q6O2m62NJlCd6wY1jQkW2X/
jE/9JoeVf1Iowjh/imxdith/3P8vta3lYem9Ph2HBeamF0j7KFBfZt6cpuXy
M4WWeHl20p8gvf+mfWWrbvpbpe/X6NnFBhv1kd53I75v7e9rQ35miDzoW4sQ
owqJO+0+rfz2SeK8end0fEslPm2Qr3epUGInq48fDuZK/GyL7SuHLImvbxjw
5kS6xDd2Z568m5whvQ+u2h4w7BHfH1VtDxj2gGEPGPaAYQ8Y9oBhj/jehWp7
wLAHDHvAsAcMe8CwBwx7wLBHfH90tT3i+++q7QHDHjDsAcMeMOwBwx4w7AHD
HvH91dX2iO/fq7YHDHvAsAcMe8CwBwx7wLAHDHvE92dX2yPuw6+2Bwx7wLAH
DHvAsAcMe8CwBwx7xPd3V9sjvn+w2h4w7BHfv1FtDxj2gGEPGPaAYQ8Y9ojv
D6+2R3z/YbU9YNgDhj1iPl61PWDYA4Y9YNgDhj3ivvVqe8T3L1bbA4Y9YNgD
hj1g2AOGPWDYA4Y94vvTq+0R9wlX2wOGPWDYA4Y9YNgDhj1g2AOGPeI+6Gp7
xPdPVtsDhj1g2AOGPWDYA4Y9YNgj7vestkccV6vtEd9/WW0PGPaAYQ8Y9oBh
Dxj2iPnu1faAYY/4/vpqe8T3b1bbA4Y9YNgDhj1g2AOGPWDYA4Y94vvzq+0R
3/9ZbQ8Y9oBhDxj2gGEPGPaAYQ8Y9ojv76+2R3z/aLU9YNgDhj1g2AOGPWDY
A4Y9YNhzo9xhs5md6vfVYA/YvnKNjmW/DKoYb20i66v6/TX8Xnw/ajWL70et
ZvH9qNUs7vupZnFfRzWL70etZvH9qNUsvh+1msW86GoW349azeL7UatZzKOs
ZvG9mtV8/ZVJqFGJtO91Q/alY82PSs99XtE4OWai9L4z1LcE/aQvhrWl/YVF
Bm7bdzwW5oGuh9tZDlP9HlbWwlXPdj8S5oed1c/aKaXvY4nf4/i1fYSTWhbF
XtPSGh0q7bND+7eTqfucuphNUZZPnZWL4lS+52TzavFYWXgWdX8nbxyyS9rP
h+O1j8HvjcKk7/bM9NYvvO0q+MEXhj32mKFU+X7U+I0uCTErc6j9aipwC5S+
FzSq1df6IZel7wGJ/vrNWgvkK3IoUPNNw/g4ad8Qxps23cNWm9WRvnezy8Wk
vf4QaT/XmsVOkxzaKEmR7x9o0yxVZT9X/xsvRh1qraTF8QZtLL9L+7lQnyZY
5S11HKQU69Okf4eWG9bOpbh1s789mC/t38J4PH3KzoceUbm0ZtFcincIEq8T
c/Gxnv7cFJGnLal3Q2OO9L0U1E9tnQ6VVRHSe4qKkuuohVzOo8qwu9Z+Nn6i
HXV2fNtmdk36vseYNyOKrL2yVN7L3675ekevS3k0I6FnpvUyab+O+L376jij
Rfu+HVv4PVfZf2NoNNn392rpeyIWO3QsHHfmk96SGYtLC5JUvh8xPmu1g5d9
PnXZ/fSwV5Nslf0w/RsMsMhZJb13vDzgRhv9IdJ+oMonhUlu9Qup8mqMZqjR
bfE5pk32HO/UP0lkrGvy91j7Oh7tVFG3kBp861wZvLZUZT9HRqsRVhExhaTW
4uXU28pFol3NgvrrWm6X3tvw3upXgXVAtsp+iSbncraOjy4ky3puDnafVN9X
H2LdeZ32f0VUx67Tfm3fBPE5vT+F22p3zlF5L++ZYX5PbNyL6LGple0ROymf
Xjba52XqLOn91Lp3vNvrJ0jvh0b7zfGuqLKeVEb2PdtetXONU8mH7p852GnY
xDJqPvjQndSBSvH84A9Tl+Wk5ZDXvWsKY80rlDy1ZyvLC0I7TGwzwt/mHj1f
XTno6J4EOl/S58aEpc/oksuGybrmOSQzaF9qttSbDqup77nxIZuayP02Of3r
S992lIyW/ZNDU8PmT49Vf0VzFgWPL/1eRhYXyytsTvjSyCuRwTYnEqn4oo2Z
5TA/Gt5UPszJMZtyejy6p/0wgMZ7JvupPy4lkymHTsknvKNbHd7FuM0po1eJ
9R101/jTsn5zAtRXl1B+RKixy88g2rY0L3dzs1Lquix3i0z3PTWUr7mX+jiL
FhytbavrGU5LG8SZl37PIq9D297azQ+hskb2/Z32FJH5J2W+zYlwqu81RWHd
tZguTf5uXvEklLzLps+Uvy+mcU2zP5gkBlPrZtem1lkn9JMn6ujOqYqkdNmx
ex7DCkknysc3VTeKRoXY+hilFVJ86z9yjcGRdDO9sK7a2xTabXVmkW5xNJlO
GXpDo1cWTb3p/9vaM5p+pzR44PExn9ZrZrYO+R1NegP/HafrUkAvdD+1CdGI
ptSmFGDyPIJq+0/21jCJpa3jzd/auGfSw/juB7VrxdPZNj4rDHMyKSt9mefN
2bFU3q5SJm+QR5vW78uPCYqjKwt+B6vfzaP30yuu2iXHUvuKojaW8zJJPbHI
svR2Am2rZ3ze5K2SztgPe5F6LYGSt+rdTl2aSzP8tz3SeBpP4UVjNwWUJlDi
4aRLL3WT6YB5y0lqijSyaVPwVcM2iX4kZvWqaJlJIcPWP9CYk0T5E5/0qIjN
pjNpubN11yTTuUPyCybbcijf59/mITuTaL1+YHxMOyUdX5lhUXoykRxGPOiy
7YiCPg0f+KnW3VQ68uH2WNnxLCrR/q2ImZhK73JiO+tPyCRbp13l1l3Tqf9C
+15rHE/Skr/h1N/C/H1w0JyllieprMdFO9e/8+OtL89cMT5JtRbsMFv3PYMU
UQYy3XYn6W7UQzsTwf95a6SrVfTdmVYlOld0+SqcDzo3riLBmXQ6b3tR57PA
qx7Mn/DUmYZfTHqZX55Be9JcI5PPOJPVzKGfowT/yGK7a8eHm5xJd6qe7E2x
cD+dqw1rrblDhZPCjJr+EeaDQ58bj51xh4413eDo/SODvE727pM27A692Gbs
F/TXH9wdmba02x3apzXr/DDh/haRFs+3a96hk51uzPol+GNvtdwTQuvcoUUF
x57V/yicP/P1VKtvt0lDXhFuVibcrzw0uWX6bTp6/dMzM+H+zbfcn94y9Db1
iLt/s5ngr11pMHVurPpTsXwSfy/q0kLtqVg+ncJTNlpWeIvlE3pd3sWv1Fss
n6A3g1oY5nqL5XMsK7r9szRvsXyahMh0p8R5i+Xz3CNGrTzUWywfz+Onz9wI
8BbLZ2T9Mc3eZ/vQrynGTs5VwvOYa+57Ee9DB9w/WU/7lUFt2pjO0wr2oU3T
fRd3FezxrBcxI+G1DyUdzbzc8ptgf9HRMT8e+tDSd83ntxfuH1nop2N/04e6
7F8UaSTcP3FA/9x5F30oK/77mC0lwvP/M9nP2dmHWpqq/fATymNPO4e89gd8
yOmk6dju+Rli/ifKR6ti/zNljL9YPiMXj1vsFOEvlo/z5MfPjEL8xfL5R7bx
wbdAf7F8NhTQoOd+/mL5eKXVHrrPx18sn/pT3940f+Evls8eurKh31N/sXy8
xrlsThwfRI+9nLwuCeVjc2bDzvGjguhM4g/DGKF8vuzoER00PIjip8zJaCnU
p/T9R9suGRREk2eoO1gK9lxSi/7ZvH8Q3T7e+8vzL4I9lie6xPUKIk060kDn
b30KfTj0frcgerH54qmDQv1Zct+u8GKnIDq6fM/qP8L9d63cpbysE0QX/GpZ
7xbKq+uXmdt0PUPF8hm5PnWhn0eoWD4WCa71Vl0LFcvniV/DRdruoWL5GES+
nx3jGiqWzxlLl5QzLqFi+cTOnpe+6FSoWD76AVrTBhwPFcvn+rNvWk2OhIrl
88gr3C7yWCRV1s51OyWUz+ANReNSjkSSvV/tlZf/2vdtS2XBoUjaN9FJx1Ow
b9CKC8d/HYgkO7nXQx/Bvqknnata7I+kU9keXeL+6hd2Y2wfh0ia3fG1VZlg
3/x0g1lT9kbSlf6TbZsK5bcv7kr3tbsj6UOP55P6CeX3unzF01M7I6nO2N1J
5oK9yBtG+bzSeHA38FOsWD7h44/vdi2PFctn28t3d21KY8XyGex3vYdZcaxY
PvmNjhX2K4wVy0d9f0lRy/xYsXwGjpyq+0cZK5ZP+aCRh4qyY8XyGevc6phy
UZJoT+S05D9PFiSJ9mTtlUcfmp8k2nOsovyPhSxJtGfKn4gdRkK/DXt+mTwz
6mCeJNrTzrcN1ZmZJNozcdtW22KzJNGeejYrUpKmJYn2DNfpnR7zPJ2uLlA4
KG0VNOpqyBiZabZon96553XirHNI76m2ZZig5+RRlmvMHJTieQ27tqvPueVS
7uiHqUuF87J7vr38ovPF80umzDWXNygSeW1B8U6vkSUibzu4z8NjY5nIrZ9N
SVTvLfj3Ew/0qliWSRnxE9xMDiko50aLgX5XM+lzs4Ji40tJpHl61aLDM7Po
8Iu75GSRTuaTBy+S786iLh6bZsoC40g+xTlC/ZkwHyo9FmrTLIGOdYreqj06
m/quO+elMSeRBp9sMrv0QxY1MR1+RyM+jbSXTtSrMM+mqc0f3DMZGkNz3fy7
V1zPoWZfHSJsdsfS09HZVzX65tA7Db1wo2lp9EuzUYR67xz6758pvXqczyQv
u7v5F/KEcbNC/ar2u3Aa4Rs+2KlhLr0xqbeq9HYkXZrr2NfvlJI6BDYzdSqP
IpMgn8YuOkpqsWXubm3fVPI4s+aVTVUOHRpZblqqkU+73OZ3q0hV0oKBp0tt
PD5Ql9IDm7QrckndWTHWclgoTbRttll7by4tsz7hnXo3hZL1O9QKuZ1L95yP
/K7qmCX0I97TSw/n0p/orvUbHg2gll/UdCty8ujApfBJlm3fk825Tu4a6/Jo
25Cb12fcyiLnMZeOvdTPJ9m+bWsH+cnp/siD00onFVDo7qu/vVJ9RF3HxTYz
DvntS6scAsfrLsin4R9nz9FtkkyxaZnNLHsWUIlT9xsm55NJb+HuLhXm+RQ6
euCT2jrF9DI2+uuJkHzaE3T45EP1B/TN6kBWzyGFpHA0TZN7PKF6oVM3aPsW
kF7m5znXHJIo8vrP65eqhM56hrFVTr9smtW7KutDeAGp9V5wsJv+WYqaZNyx
omsReY2YHb0p4jr1LVl4UeN+IR1TOh1TfkukBranzeXC/CDrwTlXk+fZVG+e
rqfHRsG/v3kgPt9kIukl1Rmje6mIWjbqZm+WnUBzbn7ZotxVTEHRHVbL5yaQ
97yRtV1mldBUq3txRmHxZG9jGhqjV0qfzMYMXRuUQ53OLd307mkpfWk5qJ/f
szhKzvPo0jSmjG6u9h3ltCGNxss01zh2S6c+k90XywV/KG3Wtw9GJQp62aWX
hTxCQbLVp8c6qaXQ5q7Jp+0KMyl43ec7GoPTaMzMDf42Zek09EnyBbsXqbR1
404L+UEFNdi9vpXLy1TS6RugX7E5g5IH3rytMSedZKGjMmKC0sT2ozxcb+a1
wDSxP6l4ndNta0Ca2J/8N7DdTDO/NLE/WTz8Z1jvt2lif9LcIcu5iU+a2J/0
/z321MeXaWJ/suDJ1Q/J8jSxP2l7/1TfoGdpYn9ypuJ0mFGYZE9KrqLcOkJo
X3aHlW6CPVZXryx1ikoj5zcfbOwEe2ovPjvxVkwafa4d52Qh2OM58Zvvi7g0
mtx2c0vTr3/jOxs/BiSkkcnjypyxgj3aPfpVBialUcrwEemjBX/r+u2ob29T
0mjm8/MZE4TxUvfq9qaP09Io+k150GzBvzD7duus3XzpOxBiv1R9hF04wi4c
YReOsAvH/5teUEshXm/TmBFO/WsrxOsN7XTRZEwdhXi9v183qBL6yYFKN5O/
7+n/S3/Z3eT/e2//v83sj3o5SnkPg+sObmvZNlO8fuyFxc1ddCTWutFi3POB
WfR/0/MFTlrZ64bG4CzxvGnfu96pp1NETi5ar+d5MkWsHyUdzX7tPpEi1o9z
Zw/oyZxSxPox59Ly64ZHU8T6UV85dUWrwyli/ei++P7KHwdSxPoxU6vplWzH
FLF+NGv+u27UvhSxfsR4J289cT5FtLf3tkPm311T6O2UqbI2gj0bQqdnmV1O
IbsKh2DfygxqmX7n5Wn3FEpQ9vy4U/Ave3UcbvvuvxTyve46eKow/g/N/XJV
eS2FnqRlNNQXxv8mCZPCv9xIoYziI+ntBHv+7TRuz2ePFHK+5qzfQbBn8bn7
I7Nup9Ax/e4b+hVL8dC6265ayFcoaMvgOa88NgrtV/62QUiJFOcMmzDWQ8NK
QYWVslsathm0Y0rFSsc4YR6Uf9nacbyCNHP1e1fEKkijfT1yKk8n+1ETvxoK
49XHOltKrAOk6yAfBfkiiG9FjhrbXMswkyZnNihw+yblyRSu8dxmlp1MR2z2
NnNJySQLzfux6lMyxPMHuqub6S6Qrmu0z66L/jOFyndlHAv2jG4akkqfH5VZ
yidkqHxvBXk9YMQ/wYhHgxGPBiMeLeYlVcejwYhHgxGPBiMeDUZ8vMXmPpvM
rkk63WvgM17mp/o9GP0pH1Y7LpcY9uP5+fOsmq8TbBSmIK+Gc1c53pDi3CPd
b/p4bFT9jo3xUVq83TWT9v9Uf+lxUvoezM1V5wz9Zioo9VfYWbvhCtr+JdzQ
r4uCGm5yOWu3SkFNWy9xsXshtLO2MbHqvTPoQuCiJfK8dLE9Krzv7lcWpIv9
xeqNqyvVi9PF/qJBX4s03dJ0sf952Np3zmChfqH/ebJz5IFRn9LF/rHjt+/H
xnxJF/vH29suHR35LV3sHx9fijTVPSb1V83/tNP2naEgnT7r3esfFvy5E3Ur
DAX7O5gZzyvtmUGXnVqVWS/IoBl9y31tRgjPmflNw+VlBm1MtIhRX60Q+zN8
dwT9Gbiq6n8zvu9Se+QMr9SBEkMfcOaYUBuzComPe2ep9/4s8c3NE/16lEn8
rl722XFFEs/3U+zbkydx45O2zsnZEk946B42QyH13/w7OrAHvFG+O8TogsQD
N74y9DOQ/k6Mb1Qz9ARDTzD0XN11rZ9NhGTXGaNVSjct1e/7YLwIXvvBzaSN
ZGeiY+9BftGSXXWLQrrqP0unj7ZuD1M1M2jhxcabzbKl+tbK02e6bqZU346W
/0mrSpfqW+nARt9zUqX6Nm7y7d3RyVJ9G53TZ3pQolTf4ldvmBQYL9W3aQVh
k0NjpfoWVt7NMDk6XRyPdzVyLbG+rqCDAf09NIT5xhKbwuYu1wS/yIQqDVsI
9czgx3jZcak8jzrE9K4Yp6DG1hp9K8wFP3/WZhuzsQqaeWTqAeWidOrc87ml
fKsw75lfEmq0MJ3mzmutY7k9gxJeJI10ilTQ+iJdM13h7z/NPNzWMkqov4ev
R6kXZdLA7JfF1sL8Ar8b+ujAXuUuaR3n4JJmproDM2m8zdtstwNSHiHue+Li
p1+GtVNoYvHTBaU9U+nCsEPd9Yekka3O7qF+n6T8wYrer8KNwlKpLGjaJNl9
6Xs+qF9g1Hcw6jsY9R2M+g5GfQejvoNR38F7D2VMV6ZK31mCPbodGpZaj5O+
JwR/Eyz3L9HV3yr9HcY/cN3C/9pYXsikQzrzUmL0MulT3817lceFeVnTZ1Hq
KdL3gQZ1bHrZ5LyUN6aWrDsvvNJFjHfvGduw1ttoF3JdMlCzSF36Xgzi/+HX
1nYqfCq9B8bxluYKP68AMh+p/ep1nvRdWKx/jMwesXudufS+ff3GCT/Up4fT
Mr1eGxplSN/xvjXuTvdRZ6X3rW9O3Fs8yzxa5f3fbt5HdpVFxon1RW+0cs33
8Dha2153h+so6T2r+Lt/z97s7RmcSLLn0TE7VySqvD+5kVmZQ3KQ9D7s4eN6
n1S7mCre79PwzKXyC1Je7KJd2zNizqXRikYDnJTW0nuaN++/uXj76P/x3tY3
19ocnS29f3LkJcVjr4vS+xVdgq1+N1JI7+VKW3Qm/k++9B1ZPIfVn9i13bOl
93CuWvB49OPMIrrY45+8042k9wsd2LI8v0NXJb1t0cRz3XZb0rawO9FtfTxV
OgV+uHX6OrksdBg45EoSPZpZZ3NiQBCtaXbAvK9xNr1ao7HGqVYQXfm4fFFh
jzfU/N4TvbdRodT85OOnCx4k06uvx8M0pkVQfb+dc+Wm+XR455JTyuIYep1l
ffdhRCq5q9/uG9o/nupvO3pYMSCbkpN6jS2Zn0KPvo/aHuobTeX3/GzOCePQ
8/QBs86/iaZvpx5PXSr0L18z151d+TqaDFzKjw8U6n+v1T2GGL2MphUdb/dX
F/pDU4dL/bTk0XRkSIeemYL/OfphJ9vPT6Np5/Kr630E/zMxvnXtuCfR1PLo
hZ/ugj/U9Z+K4BePosnCb1vAfsH/rHVwXNB1r2gyGhHou17wj4a2C9/fqHcC
WZ7pqp/3J4NsjKa+TdBLIFfvq1ZPfmXQyiWzLW53T6CTyXfrH/gh9NdbOizc
3TWBjEs211kg+MOXvpbcm9clgd6tHWc+WLBHN0Fn8tBOCTTVzKa8pWBP7gKN
njodEqhZ3IqICqE/dquYOKZ2uwR6v949P13oPzrrmjqVtE2gSRevDwwW+mO/
uI1eEc/zaNS8UKM0wZ5GBitPa5UWkDzOycteKK/+xott33Uppk8Pp+sWC+ej
Bwbd6icrpY6WFYbRwvnXcVtSqppl0vtNjetVjMumto0WBV5Wz6GWI04P6FKa
RXHhDv3PDUml485ht/XjlBSdKbf6rptCWkN3lZrvyaPSP2VVT9Yk0usZza61
u11EXYPrLH9BOTRtzPzG5zRL6MxaqyFDxsVTt3dfNUL/lNLYpfU2P8hPp1sW
EUOX3Eul74f+e9GsKF3or3Pr774jtAvT3+NvHVWQp9n5bNPbUp52L1f/Jo0v
pNKmpB9hNq2UZPFi1ZprVgfIY7+14/DFiRT6qXF6raa+pN98lprtj1Kas6ve
uDnbAmhP15Nu+tu9aUnl8VVOZh/ovuOXfa7/JdGpLx65K9KDSO34uoXz9LPp
mJ9vC/fcINpWtLxvH9MSyjm0PTZq5gfa375W0843i+hQZFW/3t3CydnsraZ7
oyD6+GxrSczuKHq8bsQX64Jk8pnrr+syL5IWzF+yKOBHAamPWj1XZhdFxf1r
X7i4JY1GtnAqNR6QSEde92+uNS6TfAtW+CUYJNJx66nOL3/lUNSS4pIOrxLJ
649JXuz52+L4Pn33rSv2Ars8N6w4I9SfDZ00u2Wdu039lnVy+Tt+j2q7dOI6
gTO7znAyEepHombGktYCr/D2DpwozI/eNr7Q6Ozf9/QcD20XKowvzxvYps8S
+OyPhPdOygzy2r9s4kCB33stvLwuR+CAf393EVhxtJN6hjD+jFJc6K038bW4
nnB+/aGzlRNei+sJG470sA8WGOsJ2zxPxlwWGOsJa3aOcrYRGOsJEw1iXncQ
WDHO02SRUH8TXx7TizR5Tcub7Or6U7Av1NPV/oDAG5/ZGJYK8wtPnxWrRwsc
1nqlpoEwv1iS9d87u5xAcnodYBMhtP8fXcNfWQicb+6knCyUj3290cdMBD7s
8cb+k9Cef5kO7dNH4LMrhiYECPfTT+9xoaXAVyzT3N7mZ1BO+bMPv7IDKWXg
+EM5wvOqO/g/Vwrs+N5yZr8MYb7/fI5FhMDOtn0C3YX5zB7zey/kAusGzX9q
GJ9BU6Nrd6/sFiHGy12Hvyr5KHCtfR0H3BL0M3k9J7xI4KY6zdeGCf5Bfty6
90qBvT82b1lbaO/dj19NzBC49rst+eOF/sZx68layX+53uF75/+u59xIHR37
lysP9vgh2Gt8s/uFcIEHl7nprBL0G75bs8EHgZ2OKM3yMwV/NP5iQXprKd6b
/KfQ/1h3Kb7rFzTUwdUqiWzkd6YuXZFFtkX/aWXOyqar+wf93m2dRRdMXmcs
+pNDdVtcrdv4SjZttnoXdFDoD8d8mrOsXVwOqd9/32L0rVwqmFCc4SNw7dHX
Z1Y8D6efsTG1QprkUsDhade0BqRS04rQzTPTlLR398NLtnmZZLnn3e2uqUo6
GPvmgcfMfDJYp3liRONcujUn8Pq6omSKvjPczDUqj0z3tLi2QGhvzwc45Xyw
zacW9jPVvgntOai2XKtJZiGVPEiJeS2095IHm173eV1EK/WuVfpqJ9D8jr8r
LbxKqLVus9dfbHIo96B5XqeHJTS+cE37JlpK6j2gyrTzzTLa0rv7u7yYOBrl
PXCU59YDFCXP3K8l/H3k23/fVdo+otDV9+u4C3+vX6/10Er7R9RQr4VW58hs
mjpqQKNJjX0p0Tjxh/v0K5T+RedGhF0ABf3x3uRk5UsdhoWsTewaTp6xl+5N
PJJF8+8csQxZEEmKe2qjLb3DyVU3KfNQQQz9Ubsc2EIoH6OqzZ5PJ8RShxHz
7m8WykepYaX17/hYelM2p7ffjHxqOEf2yzo3hsqvbUje+SCa+mzoMWqfeTwF
Tr2s8+pmLtnrzBzyfnY8hdvsHzWmjjA+p7z8VvAmkTR7voo2kiXRyy9n6qn1
SSH3i0t9Hk3NpnZOd6yGDUihReP2WRU+iqHAy4P9TgnjQfypDYpPAmueTz7U
VxivWuptHfpT4K21lylShPnC76vt19d5HEMDJpzY5yqMRz8cChwbC5yYPqDX
KqE9bR60aIemwJ2KB52eXJBBei1/m+kIbFhwdscIoX5abB1fX1fgWVYyt5FC
/Wwif3K5l8A7k46+npYmzH9tZ6fJIhOozbRwoz5Ce27X6Pf97QLfyndwDRfa
8+Cqhb8vCPzhXuDGvUJ7sd+wP1gucPwKz51/28uvsdvaJAn848iS7dpCe+k3
dWBBhcCn4np2VhPay+iVd421ohJIrc5Mg29C+86+FqZtKPDzE4NW/xLat8uc
3btnCGx0fNDRFoI/3aXNa4c9g/NpcOwy+Xuhf6v/oeubNJNCcTz9FTF3aOUc
aTzt+qR41SoraTzN0V+Rcah+PJ0Lb3i4/L9sKnJ0y4jZmkYdG4d2OJObTYfz
dg00GJ9JWbbyQxZ52eTsYnugtGUQ/Vw8OXbWmDy6OTGr3pSjWdTJvEOpYUwe
tStuNkL2u4AadB3XUGtUHhUf/hlit8KX0hqrGXoL7WPU9chjLse9BT0zj0y5
W0BqOV3GT/NIogUnzEbIAgvo9uv9Pgb9siml9pz6VkEFtCGlz5rk6SWUN3rB
jXaeBTT0d/gPd9kVWnXlz7pCoX3pG4W8XiLU92l1dh5686qI2k5rtEw7Lo60
ZpvaLBfaz8K88ih1YVy+NnHMTN1T0v61Ae2+WNf9Ke2L4+z+baKT7JvEVg4r
1/31b8CWrW0tU0skbhc9s16dQol7+340XpEr8WTfb4b1sv/H9TZenJKUIfHe
+LhOCkHP8QM6LCgV/Iz7KelzSgdn0p2Jb9tm/qeg4mWPfn7RSqW763aHGr1K
pyNh3fft/5JJU8IiH6ReVVDHwZ/eGAj8Z3WtlXUFv4T+OTlw36BMWrV80RWT
F+nkd1pnj2vrVKqr97tfxd1U2puddv7nmTT6P26RxE4=
          "]], {}}}, {
      PlotRange -> {{-3, 3}, {-3, 3}}, Axes -> False, DisplayFunction -> 
       Identity, 
       Method -> {
        "MessagesHead" -> ComplexPlot, "AxisPadding" -> Scaled[0.02], 
         "DefaultPlotStyle" -> Automatic, "DefaultMeshStyle" -> Automatic, 
         "DefaultBoundaryStyle" -> Automatic, "DomainPadding" -> Scaled[0.02],
          "RangePadding" -> Scaled[0.02], "GridLinesInFront" -> True}, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.02], 
          Scaled[0.02]}}, FrameLabel -> {
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Re\\\", \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm], 
         
         FormBox[
          StyleBox[
          "\"\\!\\(\\*FormBox[RowBox[{\\\"Im\\\", \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", 12, StripOnInput -> False], TraditionalForm]},
        ImageSize -> 160, AlignmentPoint -> Center, AspectRatio -> Automatic, 
       AxesLabel -> None, AxesOrigin -> Automatic, AxesStyle -> {}, 
       Background -> None, BaselinePosition -> Automatic, BaseStyle -> {}, 
       ColorOutput -> Automatic, ContentSelectable -> Automatic, 
       CoordinatesToolOptions -> Automatic, Epilog -> {}, FormatType :> 
       TraditionalForm, Frame -> True, FrameStyle -> {}, FrameTicks -> 
       Automatic, FrameTicksStyle -> {}, GridLines -> None, 
       GridLinesStyle -> {}, ImageMargins -> 0., ImagePadding -> All, 
       ImageSizeRaw -> Automatic, LabelStyle -> {}, PlotInteractivity :> True,
        PlotLabel -> None, PlotRangeClipping -> True, PlotRegion -> Automatic,
        PreserveImageOptions -> Automatic, Prolog -> {}, RotateLabel -> True, 
       Ticks -> Automatic, TicksStyle -> {}}], 
     TemplateBox[{
       GraphicsBox[{{
          GraphicsComplexBox[CompressedData["
1:eJzNvXdcVscTPooixS72HnssWGIv6LyWEDt2scResCsqFhAVe0GNijEWbFFi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           "], {{{
              EdgeForm[], 
              Texture[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJws20VzI123J/oTfSd3eL9Cf4s77WFPu8/7PlhPMTOXy0ySxczMZNmybFlm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