(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1512391,      27587]
NotebookOptionsPosition[   1329608,      23821]
NotebookOutlinePosition[   1492617,      27210]
CellTagsIndexPosition[   1492541,      27205]
WindowTitle->7. Limits and Continuity | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Limits and Continuity"
}], "Section",
 CounterAssignments->{{"Section", 6}},
 CellID->172022211,ExpressionUUID->"ed9f8f5d-3d86-48cb-b42c-145849993fc9"],

Cell[CellGroupData[{

Cell["Overview", "Subsection",
 CellID->330182076,ExpressionUUID->"e26e1d7b-7f99-4bbd-8baa-64052bac26ec"],

Cell["\<\
This chapter is about how limits and continuity are defined for complex \
functions. The main difference from real analysis is that in complex \
analysis, a number can be approached from many directions, not just from \
above or from below.\
\>", "Text",
 CellID->470909355,ExpressionUUID->"3bf78991-3d37-4c31-967e-2b1c48298182"],

Cell["\<\
Recall from single-variable calculus that the limit is about the behavior of \
a function in the vicinity of a point.\
\>", "Text",
 CellID->516883246,ExpressionUUID->"bd7188af-f8b9-49e8-88e1-68f8db58943d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", ",", "fit", ",", "pt", ",", "x1", ",", "A"}], "}"}], ",", 
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", "0.7"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3", ",", "2.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.8", ",", "2.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1", ",", "2.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.2", ",", "2.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "3.5"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"fit", "=", 
     RowBox[{"Fit", "[", 
      RowBox[{"pts", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "x1", ",", 
         RowBox[{"x1", "^", "2"}], ",", 
         RowBox[{"x1", "^", "3"}], ",", 
         RowBox[{"x1", "^", "4"}], ",", 
         RowBox[{"x1", "^", "5"}], ",", 
         RowBox[{"x1", "^", "6"}], ",", 
         RowBox[{"x1", "^", "7"}], ",", 
         RowBox[{"x1", "^", "8"}], ",", 
         RowBox[{"x1", "^", "9"}], ",", 
         RowBox[{"x1", "^", "10"}]}], "}"}], ",", "x1"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"pt", "=", 
     RowBox[{"fit", "/.", 
      RowBox[{"x1", "->", "3"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{"fit", ",", 
      RowBox[{"{", 
       RowBox[{"x1", ",", 
        RowBox[{"-", "1"}], ",", "4.5"}], "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "4"}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}]}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Epilog", "->", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"3", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3", ",", "pt"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "pt"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Darker", "[", "Green", "]"}], ",", 
           RowBox[{"Opacity", "[", "0.3", "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"2.9", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3.1", ",", "pt"}], "}"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Purple", ",", 
           RowBox[{"Opacity", "[", "0.2", "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"pt", "-", "0.08"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"3", ",", 
               RowBox[{"pt", "+", "0.07"}]}], "}"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"A", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "pt"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "0"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             SubscriptBox["x", "0"], ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Thin", ",", "Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.9", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2.9", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Thin", ",", "Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"3.1", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3.1", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", ".03", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"2.6", ",", 
                RowBox[{"-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"2.9", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", ".03", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"3.4", ",", 
                RowBox[{"-", "1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"3.1", ",", 
                RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\[Delta]", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"3", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", ".03", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "/", "3"}], ",", 
                RowBox[{"pt", "+", "0.5"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "/", "3"}], ",", 
                RowBox[{"pt", "+", "0.07"}]}], "}"}]}], "}"}], "]"}]}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", ".03", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "/", "3"}], ",", 
                RowBox[{"pt", "-", "0.5"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], "/", "3"}], ",", 
                RowBox[{"pt", "-", "0.08"}]}], "}"}]}], "}"}], "]"}]}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\[Epsilon]", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "pt"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"10", ",", "0"}], "}"}]}], "]"}]}], "\[IndentingNewLine]",
         "}"}]}]}], "\[IndentingNewLine]", "]"}]}]}], "]"}]], "Input",
 CellID->129514938,ExpressionUUID->"a06b6810-3b5b-46e9-a161-32ee909a7393"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV13k81E0YAPDdZXdzF4ocUVGUitySmUSvhCQkCQkpR5SkUiRXbqVIbh3K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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwV13k81E0YAPDdZXdzF4ocUVGUitySmUSvhCQkCQkpR5SkUiRXbqVIbh3K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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-0.9999998877551021, 4.499999887755102}, {-2., 
            4.}}, "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{-0.9999998877551021, 4.499999887755102}, {-2., 
           4.}}, "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV13k81E0YAPDdZXdzF4ocUVGUitySmUSvhCQkCQkpR5SkUiRXbqVIbh3K
EakcyW9RKeUoKvd951hyn+/jr/18P8/8ZmbneGZms81FIzsKiUQ6wkIirf4S
uz6Ur6yMER/+jLKGtbYTEyM2SrsnxojORr5Mq852Ylv2mhcWPWOE/L4I4Y29
7UTobuPwwi9jhM4h7QCN4XaCGJ0jDRSNEV3am+JfjMH32UmXN2SNEd9fhbya
m2gnzPb8NbscNUY80mSy/TfXToSMRX5LuTNGiL6IvnhwsZ0oeaWkUXtljGjU
lF67daWdkJT13brLfIwo3vpgizalgzBjbn94Sm+MuNwgfyuIpYMIzalaE6wx
Rlw8KBJXzNpBTMhuHO3bMkao6XurTNM6CMnxEuv168eIG7tuGSzQ4ftc27qD
9DHCq6XmCHNNBxHixn7o0twoEeHbOV/P1kGUyOUUJP8dJW4o2G17wd5BjI+b
7KxpHSWC1IweOXF0EBKvFxKWakaJBNPeTWKcUN+llLUyZaPEWbYUXwY4ZO9/
d8zfjBJKv/UjDbmgvonhqaBno8T2gHm+GvDE63sO+bGjhNSFxcZ93NC/yyrN
vcGjRPPjseyHYDP5Nn3+m6NE+v58q3ZwyL87DM2Lo8TnwpuF63mgvjxpebcz
o8Rm0tu7quDxyzVPk46PEhfLNyTqgiUUrghWa48S+94++agDPjEpFLKoPEr8
YqR/kwcHv2Es7dgxSkRpv73NsVqfu73rSZFR4sXRp29roL1xBc7uQO5R4mFt
vJIPWGIq1+QdaZQQ/r2mXmS1f29PfOmZGCG8GEmnn8L/CbmypMbXO0K0XD2T
tnH1/yqmZR34M0K4JsdcuQbjMT6lI+76dYRYqPr15OPq+L0bvZf4foTY9W6O
vADje8IjmlqVNUJI2+y0FAEHK6l5LiSNEHxWrcFSMB8fptuHpO+NEF0j30+K
wXwx3/mfNvMbIX7IURJIMJ8nlH9ovnUYIV73/Pp6G+Y/eMbjbbf5CHEkcdFs
M6yPknwRKV79ESJl7trzl2RoX8WB66LcCPHW+l7KP1hvJ2a5fBK2jhDvgynP
b8F6DC7Im/i2foS4c6uwsnmqnWCqrPyRmh8m2p5t4eMYbSe2zj3RPTE8TLTL
nAttGWwnTAt1P/i3DRM+uQJVt2A/fFB9mNpVNky84/cyVmiB+tR2OceHDBP7
EowdzSvaiU/0QMMUr2Ei9Gm6nExpO0H61SH/zHmY6LNycSovaic8LkbPvzo6
TJBlaJk4q53IVR9tfYOHCV31o4OSz9qJYTad0kK5YYL0aJajJrGdsHmyEFjO
N0wwx5/ecIxoJxLcTBy/sA4TQQK9dMvAdqJB45VB1dRfYsB2YYbXu50waLRZ
/+fPX8Iz7EZImXM7ocZdmTr0+C+RfVLcfrdOO3GleWvAWOhfIm7TzXFpjXYi
J/3m+cmbf4mY49dovfKw/w/KyS5b/SWkrS65xm5qJ3g9Yz+sk/hL0F2thoaY
bYS+9kTyhvV/CZrwa5vGnjYiiFfPT5j2l7g8oVrq19BGLGeu6EoODBEtZ++O
rSXaiKFO+waVzCGCdPbj1emgNkLyFeP9/oQh4mHICd/y622EtZdQkmb4EPGN
s4J2xKmN+L2h2k7PdYgo2e16IsigjSg7ovjPSmGImDfMQm942oglwYjftpJD
hPeXZjX9lVZCpW+g8PyGIYL7XMn1xNFWItsn3ufy7CAhLXSxxOF7KxH3loU7
sHiQeGbkqPHAr5X45Xt6PCRrkDi5ZZPmoFsrsdYwvz4ycZCgl98N/WfZSgQM
XXgc5zNInPYZoO1QaSUuif2UytYaJOKTHPcJ9rcQuneTD/76PkDs16GWflVq
IezrL+k1lAwQuw+Ics6ItxC+YtomzTkDxMDGaOlO9hai6O2gfWf0ALHy5772
39ZmYmfX3uARiwHiRH4mR51PM8G571MtdaSfqBSJVKsrbCKkAmIa17T3E8w5
GccPSU2E1o/zXRw/+olzC57WNv5NxM1z3JPr3vYTw0yaTMvRJmL0/gmBTTf7
CeugEpfQzkaiZnjwtBJXPzH+TW+8cqaBGFYutldd6SN63BfGTRobiDV3wi+q
j/cR3+J7j8QVNRB4o/xtzV99xC4Wq88GXg1EjrbXE4OEPiKygWW93eIf4l4i
91/7XX3EXxN+/n1jvwljQ3nPGP1ewvGy8g69pHrizb8oogP1Etfykj+99qwn
+GKYtB17ewn7JvPb9cfqiZ+tWQ+KN/QS40WPrA+z1BOGjlJ5ne09xJPBzxxz
NnWEfoDo6M5LPURcyA1V9/U/iUPFdFvGw27i3rnbOjLh1cQzK/sMtrvdBNvn
3F/Ne6oJKsunCaMb3QQzXWAN648q4uNh39u9Vt1Ekt/c35J1VYTmn8VEdulu
gqWO9rMr9BuhMTHeaPy+i/ie9P4g/cIXQlmq5ehgeyeBRy/95C8tJRIbRuls
PzqJymv1Wz/qlBK0u2SGVFknUbB8M6q5hkHUD26TdXjSSbTRcoWDCgjiUobb
2n6HTsLOQKCcreU9kbWb/qNnvIPoaWAdlPqbR2xV3GvUAXlJSNbGNunaXULU
b+2L7KMthMo5Lv9WgoGyO7bZDsm3ECf2K7mEGZYivH+/2DbBFuLbt27b9M5S
ZDN9/kFCRzNxtSU5UZRajp45lN8OdWsmWJ3fiMwafkK79T3ML9xvIp4eTBWl
LH5FGhtaOLb9aSCsrl/5PFf1A1mnP3dJsPxFxNw2PjE90YyEUoJF7uZ+I85O
9mw/3zyIMs+r1+5sKCRemwp/nmL/h4K/sF+ft7+BOhWHbOZezCLBvLP50rEE
8mO181lnsoz4HcYK21kYqD/9YfuKwzJKmJaJfbmPgdy97nzq9lpG2XzpxjiD
gcINekdCniyjWv3EKsfgUlSelLXb4h98XxZMlOmUoxt55dHM8BX0+OXZNNdP
n9HAM+EPny1J+OWN9Y7fS6rQAWZ329x1MpZ8sfnorakqdEQ/9bv2HTJO/r1L
XlamGk2KJWqHhJDxQ7lDC/cfVSPetWoVlHgyvt3vEXLKvQahK0dD04rJOFN6
2GQquhZpCGwxTl8kY78H+h5+uj9RGL53JPUqBWtmHndotfuJ+NIavAW8KXil
7KS50u2fSH/9fIl/AAVfZ9ppDOT/RB6lZEP9BxTseuQWTU+yDp1wv2QZ9JqC
LcivHvKR6lFoNeN4xl8Klndem5/69hfqZIQmRZix4I7z2RUGdb/QvP3+9Gwr
Fhxur9cwz/yFGkLOrftkz4KHrILmjGR+o5fPROb+uLPgVCOSOkvab6S6dOr7
g0gWvFaFyTgb+QeFuOuJXPzMgkcptZUSjo0oW/H2y8CdrDh+xbm5NqgRbWTI
1obJsWLdRY5hr2eNqHhxkDNEmRU/nfqP61dnI7I/5fzpwkFWDKnmqL9ZExLZ
tMBOmLPib1Wv6nu1m1FEp+SPwkBWnB4b0fZMvBX5Gi3Njzex4uhH6k9M1VuR
y0gn9m9nxd5xg+dpZq2IXq6VvbaHFZvGH5yyi2hF28JNV3hGWDFr8gyH5HIr
Ej+geyNnmRVbP7dSTWtuQ4YDjAVPcSrWS+dcMZppQx4PZj6FS1Cx8ovCjxS+
drTPuakoXoqKuTP4DG1025GHy+NtKbJUXJxdYb+5sB3NbX2yXg9TMWezQOXR
Ix1IMVtxaIclFfueGs3cfrIDNReHZJSfoeLZ5o8RK/YdSKZdOc3Yjoq7W9xM
Xvl2oPB1yapWTlRc1Patg7uoA12dbBYXuE7FDl3eM1VSnYjqINnLG03FbTam
TU+VOpFWuM3DPTFUbNwt8+GmVie6XdAapRVHxain0XeXdScaoqU6n0im4g19
8txhMZ2o2fRlj3gmFX8c7JfQo3Whi5bVelplVLz3NHuM/vouZBLa9mLTJypO
rpVhOyrRha79KhVkVlCxV77byDHNLiTscEDJs4qKFfwX3p641YVOue4pEm2g
4tRZUamTYV0onffRWE4TFa91wnHm8V0o7LOd3r5WKh428r91uqgLzZLeBSp2
UXGaOM9/Z6e70KCeoRnjL5SPliu0pXajqSvpwlyjVHyLbrzTnr8btbPd3XSM
ScXmo7E85/d2o8WJd2Mlk1TMW7ylwcWlG13mIYT3LsH4nlA6f72vGwke+B53
jZOGmZVmzTemutF2Gdbhfdw0bKlxQ/8maw+K2R32ZoqHhtUkGXI+W3rQGtxQ
dJSPhscnDs/7W/YgJp8+W+JGKG/v5BTo3INElT/dFhGm4e+N4W1BXj1Iks4T
dU+EhtMZdWUhcT0oVf6un50YDVuHnw6J+t2DOowVFJ5L0HA12WfpXm8PWnZb
39AlScPqV1IvRk/2oMYvsQobttOwoEX/8RjeXrRpg5C0rTQNB9SwfY7d3Itc
/5v9emsHDU9qyqjEyfaiSX5VxaidNFwr7SaSYNCLfAVYbybsomGNhPvhiad7
UfH0G5uY3TScufYdKdmpF1Hy1kve3UPDQTPzPanBveh7wH0jYzkaRp/8stI/
96KcLUK/7irQ8IUOoc6zv3pRzUJIHVKk4eiFHH6xHqifMbRpFDwk13rjAbkP
bczc+EpemYb59S+/Mlzbh15aGy1VgpEDWzeHWB9KYDucYa4C3ycq6vqq96FW
xQeqZ1VpuKTw2839R/rQB8HIrS3gwfozubMn+9CF+Ps++mpQH3OmJ8+hD/lt
9zfJB2twhAtevNqHKKHHnm/cR8MO2yT0dgT0oZ9Lw9fdwfcPFHn3Rveh42zH
f1WASywM85LT+lDL3YD3fOo0PHC1r+/U6z6klBy11wzMe99LSKC0D7G88EcP
wPuzeQ1+1vSh/+Rv9FeCHb6m3w5rg/8zHbVnDnyvR+OtzkgfWvjKFBHfT8PF
K/UDLIt9yOvRpzcI3C/kKEKw9yPl09qLJ8C8SmTD6xv7kTFP5qwDWP1YzB1F
qX50MlX91SWwvdOufKZSP/KewZJXwFGB5UMZ2v2opZ7N2nW1/tSTm84Z96OX
zaO2tuC+D2PHtpztR7duGageA69t9PdvdetHtjNhXUrgfZPChbE+/WiDxkb7
9av187wePh7Rj8SWbb4OQ/8jd+iI8yT2o5nQnnUfwEXabccrM/vRug5R7QBw
r7V7oP/7frTs+8BBB7zWi/09ruxH7mENt1nAajHJowsN8H8eXX+YD+Nr+1pp
S35/P3pTsD7TFhxR9d3k0nQ/anXU/cIO7mGZKx7gG0Cu17bs1IT54xaLYKZt
GUDrU7bdrIP5VlWTlLCSG0DVXf7Dp8HhrsdCfhkMoDNSFmqWsF4KQ/pLIk8P
ILcGO4l6WE89z25OHHEaQF/6xjQPglVbX5wsuzuATO6NKHApQX9mUdjN2AG0
z0OC3wHWZzjfb4bK8wFkJGeDimE99xymSL36OIDQ+qIoQ3noj13sqQt1A8il
4fPHyL1Qn8/uCMmuATR+jzhVCfsh/J359OOVAVRc+KhKWpaGC34wpU9wDyLJ
b4/fHIX90z0ccJpXdBD5sH0TuAj7S2Vr3scgtUH0Z7usY5wMDXdFcNy/cmUQ
WZwqn0iTomGZXdIpe+8MIuXpPx/TYX9fqTz0aixyEAUPcQikb6PhNVTfb+cz
B1FknZrhQ8gPu67Pslh2DyLL0xefyonTsIfABl7h8UGkf1p0DQfkE8YbefGG
5UGUMriZv12Uho3GXNSNhIbQTCXv/quQjzxte90PHRtC/tlJdg4baLiMzHKH
xWoIzUb9eyqwnoY5ksSjGE5DyDbgU2Ep5LfExlNZakFDSMp7nxttHQ2XG/zs
3U0MIfuU2LdGHDBeqoSpwK6/KCHIyXBhmYrNfrfY1qv9RZ3eE0fNIb+mXJ6/
FKXzF0mHNl17swD5P1sxgsP2L7r+eM7GfJaKT27NrFiJ+4vmWVW2OY9T8ROu
RyoDa4bR+/dmZnmQ79W6LgkV9gwjYUVvpaFSOE8uteQn/RtGxJ7W2rsEFX+g
HDIJoIygNW2h9yQ+UDHeujHyuPgIaub4+uJIARUfsiWoo6dGkEX68znrbCo+
3scxvqVuBMV3Hc3PfkTFTkNPKkJLR1F4c9sghzMVH73mqCZ7lIk2BRzcdnMN
FftQbD0kTJnows6eDRZUKs4JsXgteJqJZgP4vVQocP4k6u8gOzJRzKGkD4ML
rLi2bI/QzwAmamArqNk9xoqNOCfnLpcwUbWVU5nOL7hPJHkV5u8aR7HB1+wG
kuC+8ilMBXFOoNfRhwJUZFmxi+tucZ/Rf8j5aEnJTQUWzM+npTRXMYUUhA/k
uPxHwdk7Ougd1VPoitifUhktCtbR9Gr8/GsKMRfic4cxBXu5vfGK7p5Cn21O
ql9So+CeGonyPStTSIp3wi16FwW/CaUa2itNI6Gs0gEVfgo2plWcr3syjdiH
fSxEu8l4VPTsvqKMabRDxrxvUwcZBymucKa8nkaHZQUqt7SScbGtco4LYxpd
MjiTJfeHjCXKn0+ztUwj4VB+badvZDzpHXQH882gI7Fl7068IeMHc4cTsm7P
oDk75xubguC+yh6qJH13BmUkZe5W8SfjMuHqmieRMwid7dhk4gvt7zeixCfN
oGQJ4mOsFxkf8jU/F/xhBoUzO4P/cyPjaXZHuXNzM2iqtJnj0CkyNhMJ/STu
Nov8bhNprXJk7LKr2jLecxaZ/rjvYbcH7sMaa2cFfGZRQsPFYaYMGedYR+/g
iZhFe3snv/FKkTHb0/iIpcxZFFt/Mc13ExkX7co62TQwi9blzHfzc5KxMKoe
uW89hyRkOwL4hkgYrzN2jzw3hzyM3DcpDZCwfXfjfKjLHLqYPLfJoo+EXwf2
0gO85pBpv6H16y4S1qld3OwZO4cMU3eyBTWTsPuZnaYWtXNocPEwvbGKhOPk
c1vM/syhtjLPT3u/kzBBVT5r0jaHHt/PX4moJGH2l5quBsNzyHfEdNi4goST
J04G4zXzKP3EGcaaUhL+fieoRALPI8sSxrqNb0l4woRbe/N/8+iMWNz8yzwS
FpCK/iZqMI8qg/2d8GsStvme1LDBYh6pPVsaufKKhGf58yfWeM4j5gPOqxwv
SVjiWe+2kVfzKJA3mL0ziYR1PR2zBt/NI/mw24yMRBK+qDsu3/dhHj3e6Um7
nkDCRaOLuP3bPOq7r3tw82MSNlTmP/Wjfx65x971j3tIwl5fNCPeii2g1KYx
rBJOwj4uvtPh2xbQNpsfTBxGwn78Zacddi2gW3Qhbv1QEg6xPiAjvG8Bnbx6
PPJiMIzPLPrqY7qAXhqbZbcGkHBiores+ekFdCEu+CMZnKpFxMjbLqD85BuH
pP3hfRWpYd/ntoBen7AM9b1DwoVS+1n0whZQh5DpBksfEi6u9rogGb2AjojU
+yR4kzDDvfjHctwCEtzMZdxxi4S/MPYl56YvoImlir2uN0m4wUxtv8DHBSSe
3FxWcJ2EW5avPWFWLqA9Kz9s+cAdTwo5Kn8soOTJ7Y5u10i4n6nS5NW+gKLL
rFKVPUl4Okj5atf8Aqq79/P58BUSnt99te09eRFZ+JactAEv17/TfrBmEQWy
nLrQ7E7CtM1K/DobFtFhiwtP/lyG+a+4cmOz6CLKv7L3uzmY2/lt1/zWRaTx
wuRo5yUSXl+okJslt4i4UjbZzrqRsKCVu2CgyiJas5b5LwgsQn3jbY0W0dl/
l5tFwBLH5A349BfRxdjcLANXElYYlPvr6bCIfHmLNJtcSFglws3I6OIiWuKY
u+wPVlfMLdzpsYiOSadOyoMP3pYNaruziFRKs9rjnEn40HbXsfzgRdTBWfrf
cbBu1SvTqKhFtLI1eZ4bbLRxj6RW0iIK6Pm7L9KJhE0Jl1DRZ/C9UGeFCdjc
LvvfdOYiSlbNe7QJbMkxal6bt4i82IVyhhxhvebuKntRtIi0zL+wFYHtTzhL
3yldRDtWHJ+Ggi8sZUZafFlEbs1Zt23ALmnDM4o1i0ioQy5hH9jtsIwVz+9F
VM8TMy0AZg6sC7/Zuoiyyl0nJi+QsGvQTPHfnkWUxvR//wvM3N769+TwIvI4
RjIsWo1XlAl9+beIZtso2amrcfv0w0oLi0i1/kVd+GqcFu75hLKEwvPYiVur
8aeXn/OyL6E3RxRcLq3GtU/+9lm3hJjvd7efX433aFDHBJdQ27UFHrvVuJ+E
wmnxJRRm8mD57Gp8K/vZb9uXEL83M91+NV4+FqW6ZwnJhsxzOq/GbX4xnist
obuecVJXV+OU92PrNZZQ5ZucOb/VeEryJj/tJRS0WeDWw9X4gQD9Cb0lVLwx
JS9jNd7h6GVtvITKPIRjP67GfY5lVJ9aQlEP9KQ7V+Niyk3qZ5fQZotJWzKM
lyshwpZxYQm90PiuI7k6fpYUlY2XllCzVuBPvdX4cr994LUl9Ijn58pV8MX9
eR/PBi2hiXsv9jWCR1ti//2IWEJdRRe1eWB+XbxubcExS+hfpMqgzqrfH/YR
ebaE2Bkrk5/Bo+Z7XgVnLaGenVQzDlg/LvP8bbNvltC4h/CR1fXlotqx71f5
Epo9o/VnBDzaAM/+b0tI2FnGEcP6dPHMeJT7cwmFqNb6PVx1vsdMWOcS2u71
WkP/IpQ3tdi2OLCExC4+aMwCu0wfMLnAXEJU6Ztj62A/uChy5R1aWUKvb525
3QMerZ/ofENbRm/tf84Ywf5xcW9Yu5V7GV0okm37uOq8NJcVEXCTxdhr2I/O
cmo7CtSW0cvNxT/zYT8P14qd3Ka5jNpVODwPwH53cqUGRR9eRsMLS1eqV/2q
ttfVbBmV5L2/OOEB3nUuRdpjGVWO/2K1gXziJB0t+Dh3GXEN8U+1QH5auPtB
IbhgGSVOzQ+EQf4KHuozvEYso93mP+MOQH57kaF690TVMtJocdiVe5uE+3a1
z/ENLiPxijZGjh8Jn9m7ozlUfAUV2JhK7wmB+bx3fObG9hWUNnQZjmbIz/+8
+Bx3ryDNfHbGADjxTc2Rw+orKPAeIzQT8neL0pViqtkKarp3yMHoHuznfYyE
WxEryEo08wZ/HAn3Ph4sdH64gkTk5eIE4DxwX+T9bZGwgjYtrQiIxpPw/Q92
3PsyVpDnpzcSe+A8qUUc3jOfV9D8O1Opi6kkfETL1Np1eQV9ZsQvnsqA826b
x7pcJejXyxcmP0pI+FndaZbLaiTcZX3/niKDhDN9tKcUNCDv+rpsjIfzML+J
v7FAm4R3qnyduPiRhKvD85IZxpDX22aO74XzdGGauacW5unxI8pH0d/Q/wpH
g7FsEm5TDNN3GSNhLoczIbu2k3HB/jc2PdvIWEsyUOQQHwW7uJloTSeQMSPe
eerdBgqOOflkXWESGe/nN67eLkTBDRZrc2+kkLESy2Yfts0UvMxrZ0p6SsZS
nUXd33dTcHGy2ndaJhlzJYy+PK5LwQczX42zFpHxb35T1TO3KThsuunry19k
7MAqaeo1RsHvOTUYn9kpONWz7Z7yPwq+o1y6w5eTgluHY2ompin4qXLNAXVu
Cjb6xX74/DIFOwn6nc1cR8H7nzH3mXKxYMa9zpkbghTMq1O8WXYnCz71t9Ov
XhL6EXJ8pNueBfPV5C7rIQqeXuHckXSBBXM/7fX/BfdHOffP9uYuLHi6oFTW
QpOCn1modtReYcEeXJc6z2pTcNQusboPfiw42O4NsjhCwfY1QwUxqSyYveVC
4IgpBfPw+fodaWPBUjwLVE8nCv55rlW5opMF+54yX5PuTMHRxSp/NXtZ8HJe
AOtvFwoWtB87pjbMglvSTrTvdKPgLYUWYtLzLDiOTauu5AoFK1gpF9E2sGJX
gxk771vQ37x7zr4bWXHwGYXPYd4UXLhmVHxZhBXvVrk9/ciHgjVePwmc2sqK
zT55fsjwpeD/qLwmPXKs+OeaHSlvAijYPGN4rFSfFRc32+aeDKdgEZJO2v5j
rFjvfs3UwQgKbjNOMy00ZsUqy1K9OyMp+OzyyQ85p1jxx441xZNRMM7HKoKT
zrPiS1dVeS48oGDvmRTJm/6s2F2GcbvzMQVr6i01zAax4m2zP7yexlMwa4pZ
qHsoK7Z0TqScS6DgIF2ef4734d6/wPW8K5GC7yV4McxTIG67KF6cQsFPDp44
pfKBFUuNbTObfkbBpr483qkM+P9k7i0RzymYXlqRyvmRFccnGV2RTKfgCxoq
Qx2V8M5g6r7WfUHBsqobr91tYMVBWy5ZXc2g4K6rP+L/NbNiT494/UXw/Xd3
GafbWXELzbToViaMp/w8fW8fK653d2P3yoL1sbv5YdM/Vpzefeis2StY9873
i7RmWPGbkx+3fgWLZR5py55nxd9/6Z9UzqFgX+liyTtkKu5g3S7GmQvvEYmE
Nzt5qJixJ3j24WsKnrcxaXjAC++yoaaD/8AZKVyLK+upWGU3bVEvjwLv/1sH
60WomFNB9dUsuG6j1U+vHVQs9fjkGrm3FOxnJjDdtwvehTdTUjzBSjE1G4/J
UbGr6VDyB3AsPz4jqULFDT7XqtE7CtY9PusXsQ/i1boLXuCFqJz0OQ0q1lor
H5IPtuTZzKzSpuKWobgfEvkUvNagkU/lMBUXh/4IOAEuDY1STtWj4nTVsPhA
8KVvh09xGlLxm6PKvG/BEuwUb4/jVOxZqNHfDv6tU5TaYUrFMpMCwmsKKDgw
8NJnXXMqNuTen7ULPMTazSV2hoqt114ccgXHH3wsd9eWio25QqPDwfq+x03+
nYP+C61//AK8zOC4dtqRinWOJC+VgnNWyuMrXGD8jL++/wO20fBiyF2C/kfI
/RoC891U6Hl8hYojF7wPL4A/vh+m065Rcez+M4JshRTsMf9kp6sXFVukBx7g
B0upnj7a5E3F8coZH0XAjVfXX9a6A/P38G7KFnDwu6qH2QEwH1v7/kiC1af8
iwSDqXhy8O65beBReY023zCoL+ugoQQ46dI0eSSSinv6+qPEwIa52ZInoqn4
Y4WhjCCYwrQ/XBpDxYtqlmLc4Es7J2qvPIb/87lKiQTutL9ptiMJxvuTyO4x
6L9h6pqOtlQqDpVRpTaDGa33z91/RsWsw4LF5WDZjWJj/72E/zdeaLQ6XknG
Lz0Ws6hYdteWryFg7kjF5ZxcaC/MSswRfOsbw9/uLfSPI8jkP/AoTY9LqJCK
B9IKHcXBpzX/RFcXQ3unhWymYT6/37QRucOgYgmDBpWvYPXCkTTlj1D+oTQz
Fpw56blzuIKKmY56QXZgYVnWvORvVDzMG0jeA55/JlTGVgdxU//YAlhvF7qe
Hi75TcUOzKV3nuBGUbkfl5qoONp0Nl8RXBD9X0dzJ5TPVjz7DNazVO3Pc5G9
MP8+Ltzm4BgOyzGtQSrO6eRPZAd7+LovZzGpWCF0zMnmDQX3fVjxt5mE8ak1
z2IDm8wFcwnMUrHX45T6LNhPCq4pIj4rVOx3/W7TMOy/idPVakbcNNzzk9yo
DfvV5tHJMhovDdfmHrWrh/38o77n8Pv1NBy9obXNCpxzZMFMQpSG19L9EpxX
84Gq1NXpnTSszu5sZwv5os09b/nlHhoeODBwtQnyiX6ORoCVPA1rRfD56INl
tps8+KJGw6QqA48dkH+G+H3z4g7TcEHVhCgD8pe5Ide+o/o0bChvSN4E/hoS
W8ZyjIal9rX0eEK+S6e8+uFkBi499VoS8qE9s3lM4xz4v89Rp9IouPuboky3
Hw13fMmtU4X82tRvs8MsiIbX5H6J8YD8+5MlUqoqhAb3/pXfOZCfGfuGJPLv
QX93q1aJxsF+zEgUDUmG+loEKhofQr4NofPIF9NwenmHRzOcB/rPFbjSCfBt
tSImnBda5Wc4RMtpmBG44wELWH7hPZ1eCd93lW3cEgr5xNGV1PyHhq0Fuh9q
BlFwpW7juO8/Gm7Qd9jPB+dTqT2NOTNNw+J7H01R4Pwq8JUfdZoHly2cY96k
4OdFYUOmZDr2DP7h9/EG5L8dmt07eOg4SPBy17GrcL6xZ9T/3EHHDOVmSxY4
P19/9crfYkPHWP/TpvqTFHyuy2tjlx0dk2oib5w1g/NtwetGynk6Zgqdv8+E
8zlQ5iYSd6Pj5F+CrKzGFGwRcbNC1IeOa902mq81oGCaya0/gonQfu2Rq2UH
YH46vGe4m+D7Cb6ll9spmGXGV3nh2BpsvSfY89EoGWseIluPy7Fhn5HCG33X
ydhFmvTCShGc0ZMneo2M4zhXxqtU2DAzsVLb5CoZT/xcvPMSsWFMJ0I+XSbj
NKvZ52f12bDsgWD5DCcyZr02NvbLgQ2TSn/ej7Ak488Zrd5FSWzY+rISvUsT
vg9v+SKVxoY7NI592n2AjDddal4X84wNJ9+LD/JCZOyh0ph2OQu8EK8grE7G
2z/VV8i8h/omHN/bKZJxUNs3nqTf0H5zkaGCFBkfWVeUdIeLHeN99RJt3HB/
Gw/RU1/HjsV957gVuchY/MfpuUl+dpwsqL0YxkHGk5Hk4/Yi7LhDxH9Rew0Z
x689TDu8kx1bP1h3soZMxqM8DU7ch+H77Wsy9adIuGHsxcYKPXbsQ51d/+Uf
CZfV3PjsbQj1fXv+T2uChGMixMTHT8D31w22HYL7J+Y5V1dnD/EXKTLnBkk4
inta9ZEfOyYVR/yRbiNhr9GKvmNB7Jghc6C8ugXew9WP7rOHQpxd4J5HMwmr
he8fuXEf2r/zcbK6Ae7JXP7Jlqlgp6zwtDp473Px0yUY0P+tymu7vpLwppHe
vJZy+P8X5GwLvpDwmqp86wcVUN9DhzX3Kki4NfRUEa0Gyi+cszj6iYQDONOc
B1uhvqHmkQm4f//h2FufvQDfb8y4011Awjrfn85sX4H/yx0zQwYXhW4UTqFw
YNzA+XJrPrwnuMg299k4sPWVR+2ub6H/PLVjVwXA6oFi8q9hvGoO8o0LgQ/s
EHLKJWHdyHylC5s4sHjSild6DgnvXpd000IS4mNVETtfkfA0rwvHAXkOTBpk
ep7KJGGHus7dRUrgBFWtHHg/NN03MZJX48AMA9vkNeAS/v2PJA9w4OTyc2If
X5Cw/wbO7exHoby3Q7n9c6jvt7fuHSOIO4unNDyD+mL+OS+aQHt7TZUNwHqC
zW9GLaC8e26y1lMS5hd6qVl3Af7f3uOjlmkwPk2i9nouHLhj6ZDAGLxnZuOi
7n5y48A+8ZJid8Atwtdq8z2h/Nrrbe9SSNigZfifrBdY0iDJFMyItxZ46Q39
vf712HwyCaeJ6ljGB0D8k3KiPpi/7f3t9cEQp1geWEqC9hL3PA0Pg/hK1EAO
eNYy7Qs9CtoLtYp1AF8QExj2iQZ/1zORALe0B/PMx8D36k1be+D9ZZC8vPfy
Y4hH+65JB+/d3HfNLhXqqxmXVAc/6TyZ0PYU/u9M5DlO8IbUKsaJF1DefqG2
I4GEg2wO9NRmQtwg3L4QPL/lLV03B+JNyTIPwU7dUjvL86A9ut/2q+C2tHgD
9Xxwru8pC7Ch7dpLb4vge7fO79rgUgm/B7tLoP3nbd7y4L29MwXPSyGu+9pT
EvzkqWOL+CcwKfy9MHiDffvKoy9Q33i83obV/mw7vpXvO8R/s8iuX+1P3+dD
oTUQr+w4L7jan+dqF6h1YIsjy2Kr/TmXHXbrN9jNeHznan+ktuTONML3irT/
1ME+vQ4q71shHpE/YQTOSX1F3OqE+Pqoahdwh9X0Ic1e+L+Mx+0R4LWi+6up
g9D/qd873oFx0x2Tr8MQv67ythPsGlPZEsoEW2be4YXxTDZeZ2s4ubp++R/r
rL6H15n95ZuF9rx0SX5gUk3ipT8LEPcXLvgIlg3tnYtbge/d9CrYYT6tD8vc
tmThxKSgmL2m4Eja5TVb6JzYpz9z+RmYUV4Y0csOcau9sqvrhelDEnjBzYkZ
F8q/mcF6OroQJim7AeIrB46Lw/q7VVCf+W8jmLpXJxScfUVYIV8UfGtv4RKY
m5muqSEJ9QtPio/DetbIGvtKlob6as6IX4b173JB6dgnGYj3qWTNg6t7yq30
FDgxPIx9hGC/LKew9/OoQH3ButWvwbutjrnU7YP4vrQiQ9hf4Y1tXuYHIe78
5mYC7EeD6rlHDkYQf00WufES+heCN8uYQv3/qr9i2M/ZOoHpYych/v23Aifs
f+5y/nyPM9AfCd1jb7Kg/fw99X6uUP4ZZY0u5JNld49TOu5gmX2sGpBvdu/9
0MXhCeVZGxqV86D9TN3xe95Qn/C5TfshP+mn2HGnhIPVZOzDCyH/WmY+sL0H
5UVlA3OLSDhT+J+I1EOI2z+Oa3pPwpwPfXa+SgDXyz3RKCHh78GPdT5kgslK
kQblkD/cf/g2VoIPlXJFVpOwo/CV6yHVq/OhfYWzloSDywQv7f8J8aHckvAf
JPxlrfWZlEYYD8rQ8pN6EtbOGkXnB6B8jvM5Qcj3Gn0cS7NULsi397AInBen
w15NvmTjwligPmJmCPqrcHzYggviqpaNDcOQj33jmhn8EL/uYZXFJGElMemi
oK1csL4/HEucJeE9ZoeuCh6A8ttfuySzkbHByqBLpRbExw6XNsP55/IszN5L
B+LVuwRF4bzMnKw36TgKLtOry+UlY6moswrpllyY5Jt1a6sInJ+VPuPKXuB3
y+7bZcmYV/2944l8KH+FazLTgowLy0lNX4sgTqt0dbciY+sjh3TUS8CJ+bwH
bMg4y/yHxOZPUH58hhg8R8Y61/pbh35CPHMhyhPuD97v+AxvjYKrJzyDQ8h4
WNZJ4akkN/a5k1FxkSDj+wW5qQLS4OfPpv6UkbEanlkbLMMN99FTy1qfyTjw
qO+IizyYZev9XVVkvMUl9pnKAbD6RWeVZjI2y/go+N0CfFL1p9wsGX+SFF2a
uA++ljoWo0jBO14q1ryKAW8RchtSpeDw3QYpTo/BhQk8mhoUbKbsrd2XCu0v
3g0m/UfBwzqdYY25EL+3VFYI9zNep6ebGDUQbw02FYD7n/XrXTiMgwf+3++v
R77C+1VD4872O+B4O2WGMwvm+fC3QV1uLSbZvxsces+KA2J/LeQlggP6I+Io
NHy8RJc9IhlMemfZQod7ZQ8heCEVzD99R4iLhov2vFQUfwYukIgKEaDhkc+3
LoZmrcbdxzVkaNh4anu3bTF4/Y/UFmMa3mJ0vXJ9E7h/6o9vKg2PXR1rYDaD
vdv3yD6n4eIE2/5vreDJB81/MmjYdNCA1bcTPCc/tv4tDd/12aoxOgDm9TQ4
UgH38OzvuZ9nwJU3tcKGaJjgEHt0df06OD8E2Vlk4B66ubdrrwC41lHn8R46
7lDOkBkVBHMuMGXk6Zhiq8ywFQGnvjBSV6NjreKj/ce2gsV9Bdl16LjSyUdR
Rg5sWNB1Au7Fzb6HvPv3gmMPet2Ge/FwLOfXVAWwbkx1mgMdc32KtdioAlZ7
ePmnCx0biubeoSGww6aE39fp+HdV548OPfBay1S3KDru734uHG8Arq+gbomm
49k5Z7sThuBqjTuVD+l447b52arj4Oic5yzxdGxxi1f8vTlYyf/x+md07Bzd
cN7DAmz+sM4/nY5vvUzMk7NcrX+qbeQlHSf93vFf+hnww20GT1/Rcdfugy4P
HMDD217mFNDxPy22AsMLYFJhTFsRHbOeqiFzOoG/3xZk/UDHkoGnHvheBBdU
vVUspWOH9svFFz3AeyOi936l42tTqrSdnmDLw4Yi3+g4mINk2HcN7Btgv/Sd
jjOUQ7stboJtQoKe1tLxaMQTdl2/1f4KTIb+oWPtllNdKgFgl5ANZxrpOF6K
r2h70Op4X1Dc0UzHuqW3z1NDwU/O6T5uo+MULtUDk2FgXr69BztgvE4yBbsj
wB1ac+2ddPx8wvIL4z54vo5jtoeOlzU2JL96ALa9p3u5jw7vsaqriTHgorij
3f3wfyXUt3s9Bi8PPkgZomNrk40Bymlg7mHfh2N0nJ9Se3rbU3Bl0Zl8Jh1z
jwYqrn8OXuTp+D5Oxx8CpnsmXoLDazJ//aNj/rqs4s5MMH42+WWSjp3E7KJr
s1fLt1bnTNGxUEHdwezX4N96spYzdOzGGiKc8AZM25a3dZaOvxhq/gt5t/p/
nxKtYLGEucrrBavljxuHztGxx2BO6vkisCeL6555Oq5SdLhuVry6nuvWVYAl
fMWM/isBW+xSPb5Ax17Vv6WVGODQyt46cJ1QOFmyDFySI3B4kY53nNNu5Pu4
+r1izWuwb95iDuXz6vwucq5bouPGlbyg8Qrwl4UfZ8Gyeo7WHV/BL6+LZYAD
Y7eo1HwDC/HO9IHbehp5SqrA2dnmAst0rCgX1Z9ZAx6I1FMHh97UIR7/ABsZ
1JiAu7+uPAyuAzv97D0LVtuQ73LtF1jD6r49+J6NyyGHP6vthTefBg9mS246
0bi6Xo+XHQbjhZYp7ebV8Z05sgMc+190lUIruG3rzRXoz9j9I0+3toN//jH/
Cj7UQbnJ2wlOdBsKBCfIFBmTu1fzQ4bcPvCkp5sMs2d1PycpdcN4HPkkxdre
B84pX/EGp67raK4aAH9k3l8Hnjsdk1c8BJ60nI+B8TV8aRCSMby6HtLV+MAr
mh/U7jLBcdvOD8D8mUa483pOrO6H2w6a4OzmnUP2k6v7m2YbBfNt4R73SGt2
db0iD25YH3mMY27y86v5wSBFfZqO2bnYDm9ZBGtpjlvBejpzkiG+bhmsYujm
Ceut4OnV2ZUVMENoVwCsx/8Bh7r7PQ==
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{-0.9999998877551021, 4.499999887755102}, {-2., 4.}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["x", HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"f", "(", "x", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{{
     Dashing[{Small, Small}], 
     LineBox[{{3, 0}, {3, 2.2608607618608403`}, {0, 2.2608607618608403`}}]}, {
    
     RGBColor[0, 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], 
     Opacity[0.3], 
     RectangleBox[{2.9, 0}, {3.1, 2.2608607618608403`}]}, {
     RGBColor[0.5, 0, 0.5], 
     Opacity[0.2], 
     RectangleBox[{0, 2.18086076186084}, {3, 2.33086076186084}]}, 
    InsetBox[
     FormBox[
      StyleBox["A", 12, StripOnInput -> False], TraditionalForm], {
     0, 2.2608607618608403`}, 
     NCache[
      ImageScaled[{2, 
        Rational[1, 2]}], 
      ImageScaled[{2, 0.5}]]], 
    InsetBox[
     FormBox[
      StyleBox[
       SubscriptBox["x", "0"], 12, StripOnInput -> False], TraditionalForm], {
     3, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]], {
     Thickness[Tiny], 
     Dashing[{Small, Small}], 
     LineBox[{{2.9, 0}, {2.9, -1}}]}, {
     Thickness[Tiny], 
     Dashing[{Small, Small}], 
     LineBox[{{3.1, 0}, {3.1, -1}}]}, {
     Arrowheads[0.03], 
     ArrowBox[{{2.6, -1}, {2.9, -1}}]}, {
     Arrowheads[0.03], 
     ArrowBox[{{3.4, -1}, {3.1, -1}}]}, 
    InsetBox[
     FormBox[
      StyleBox["\[Delta]", 12, StripOnInput -> False], TraditionalForm], {
     3, -1}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]], {
     Arrowheads[0.03], 
     ArrowBox[
      NCache[{{
         Rational[-2, 3], 2.7608607618608403`}, {
         Rational[-2, 3], 2.33086076186084}}, {{-0.6666666666666666, 
       2.7608607618608403`}, {-0.6666666666666666, 2.33086076186084}}]]}, {
     Arrowheads[0.03], 
     ArrowBox[
      NCache[{{
         Rational[-2, 3], 1.7608607618608403`}, {
         Rational[-2, 3], 2.18086076186084}}, {{-0.6666666666666666, 
       1.7608607618608403`}, {-0.6666666666666666, 2.18086076186084}}]]}, 
    InsetBox[
     FormBox[
      StyleBox["\[Epsilon]", 12, StripOnInput -> False], TraditionalForm], {
     0, 2.2608607618608403`}, 
     NCache[
      ImageScaled[{
        Rational[11, 2], 
        Rational[1, 2]}], 
      ImageScaled[{5.5, 0.5}]]]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.9999998877551021, 4.499999887755102}, {-2., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{{}, {}}]], "Output",
 CellID->367824627,ExpressionUUID->"9a9750c4-b440-4043-a72e-8b593befda47"]
}, {2}]],

Cell["\<\
In single-variable calculus, the limit can be approached only from above or \
from below.\
\>", "Text",
 CellID->248841943,ExpressionUUID->"177e0919-ee0d-40e4-bca4-279b185b34b0"],

Cell["\<\
The limit in complex analysis is more similar to what happens in two-variable \
calculus, where a point can be approached from many directions.\
\>", "Text",
 CellID->309407912,ExpressionUUID->"f51853c8-ba82-4115-b843-53583a4b51f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "f", ",", "x", ",", "y", ",", "a", ",", "b", ",", "L", ",", "\[Delta]", ",",
      "\[ScriptCapitalD]"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f", "=", 
     RowBox[{"2", "+", 
      RowBox[{
       SuperscriptBox["x", "2"], "/", "2"}], "+", 
      RowBox[{
       SuperscriptBox["y", "2"], "/", "2"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"L", "=", 
     RowBox[{"f", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "->", "a"}], ",", 
        RowBox[{"y", "->", "b"}]}], "}"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"pts", "=", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"List", "ListIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["List", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Dimensions: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox[
               RowBox[{"{", 
                 RowBox[{"44", ",", "2"}], "}"}], "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["4272", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"],
       ExpressionUUID -> "5dc6e10d-83b4-4b5b-a801-70dad6005480"],
      CompressedData["
1:eJxTTMoPSmViYGDQAWIQbbnlRNm++X/s39XYm8bt+m4v1Hzg1ELXP/a90/OA
zB9wfj6Y8dP+9s+6rD0lv+0NOdbIRKX8tgdrl/pt/1INJPLHPoxPd9Pc9z/t
Ty903fb57x97dbDCb/YzQMad+mt/8BRI4rO9Zkz/oa8a/+yBmvXvqnywBxo6
WYLln/25Veevhr15bQ8y3fr+X/svOWG167a9sAc7Y9tf+72PRWRPPn0M559g
t50dOv++PVvjVOfunL/2/g7CiYcv34bbP6W9Nerynutw981ZpLzzT/sV++6c
579Xfvxl76n3X/Hvt7P2PuadjglPf9if67h07wH3aXvxm+e+Bz/+bh/yeOns
Iwon7Fd9vOSbJPDNPjB7VvmcRaeh7v8C118tss79YdUne2VwAF2A0h/spefF
aZ4WuGyfoZRTUbX0DVz+XZST3YubL+yP9huW6yqeh4bnc3vvVywmgmZn7I2P
bNTLW/zU/oLLjQ9fvE7a/3r7+oCl8iM4v/bC5sivO+/Zg50Rc9n+JCga9G9C
3fHE/trRXJOG7RfswVyRD/ZWyl7VzfpnoPH6xX6HQ9Oj4zNO28u3vg7cIffT
XmLqFc4MpQvwcAkAK7xiD0sfTNrtYjfP3baXBsYWW+Nf+98xuUf/bXpob8t1
fXGB7T97o1ADrZXCz+D89ycPO63NfGEPMu2S7z/7J83zzq46/xbOh8U7jH8Y
6Iv+Qx/h6QKSHj9D09Nf+28g6a9f7EGxdEHpr/0OOZDDv9kDAFHUffs=
      "],
      SelectWithContents->True,
      Selectable->False]}], ";", "\[IndentingNewLine]", 
    RowBox[{"\[ScriptCapitalD]", "=", 
     RowBox[{"MeshRegion", "[", 
      RowBox[{"pts", ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"Range", "[", 
         RowBox[{"Length", "[", "pts", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Delta]", "=", 
        RowBox[{
         SqrtBox["2"], 
         RowBox[{"(", 
          RowBox[{
           SqrtBox[
            RowBox[{"1", "+", "\[Epsilon]"}]], "-", "1"}], ")"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Show", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Plot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"f", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
            "\[ScriptCapitalD]"}], ",", 
           RowBox[{"Mesh", "->", "None"}], ",", 
           RowBox[{"PlotRange", "->", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "0.1"}], ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "0.1"}], ",", "2"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"Opacity", "[", "0.7", "]"}]}], ",", 
           RowBox[{"RegionFunction", "->", 
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], ",", 
              RowBox[{
               RowBox[{"Norm", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"x", ",", "y"}], "}"}], "-", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ">", "0.02"}]}], 
             "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1", ",", "0.01"}], "}"}], "+", 
            RowBox[{"r", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
               RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", "0"}], "}"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "0", ",", "\[Delta]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"Mesh", "->", "None"}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"ColorData", "[", 
               RowBox[{"97", ",", "4"}], "]"}], ",", 
              RowBox[{"Opacity", "[", "0.8", "]"}]}], "]"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x", ",", "y", ",", 
               RowBox[{"z", " ", "f"}]}], "}"}], "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x", "->", 
                RowBox[{"1", "+", 
                 RowBox[{"\[Delta]", " ", 
                  RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], ",", 
               RowBox[{"y", "->", 
                RowBox[{"1", "+", 
                 RowBox[{"\[Delta]", " ", 
                  RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}]}], "}"}]}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", "0", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", "0", ",", 
             RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
           RowBox[{"Mesh", "->", "None"}], ",", 
           RowBox[{"PlotStyle", "->", 
            RowBox[{"Directive", "[", 
             RowBox[{
              RowBox[{"ColorData", "[", 
               RowBox[{"97", ",", "5"}], "]"}], ",", 
              RowBox[{"Opacity", "[", "0.4", "]"}]}], "]"}]}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"a", ",", "2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "b", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "b", ",", "0"}], "}"}]}], "}"}], "]"}], ",",
             "Black", ",", 
            RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "0"}], "}"}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{"\"\<\[ScriptCapitalD]\>\"", ",", 
              RowBox[{"{", 
               RowBox[{"1.6", ",", "1.6", ",", "0"}], "}"}]}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "f"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "f"}], "}"}]}], "}"}], "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "->", "a"}], ",", 
                RowBox[{"y", "->", "b"}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "f"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "f"}], "}"}]}], "}"}], "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "->", 
                 RowBox[{"1", "-", 
                  RowBox[{"\[Delta]", "/", 
                   SqrtBox["2"]}]}]}], ",", 
                RowBox[{"y", "->", 
                 RowBox[{"1", "-", 
                  RowBox[{"\[Delta]", "/", 
                   SqrtBox["2"]}]}]}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"x", ",", "y", ",", "f"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "f"}], "}"}]}], "}"}], "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "->", 
                 RowBox[{"1", "+", 
                  RowBox[{"\[Delta]", "/", 
                   SqrtBox["2"]}]}]}], ",", 
                RowBox[{"y", "->", 
                 RowBox[{"1", "+", 
                  RowBox[{"\[Delta]", "/", 
                   SqrtBox["2"]}]}]}]}], "}"}]}], "]"}], ",", 
            RowBox[{"Thickness", "[", "0.015", "]"}], ",", 
            RowBox[{"ColorData", "[", 
             RowBox[{"97", ",", "4"}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", 
                 RowBox[{"f", "/.", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"x", "->", 
                    RowBox[{"1", "-", 
                    RowBox[{"\[Delta]", "/", 
                    SqrtBox["2"]}]}]}], ",", 
                    RowBox[{"y", "->", 
                    RowBox[{"1", "-", 
                    RowBox[{"\[Delta]", "/", 
                    SqrtBox["2"]}]}]}]}], "}"}]}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", 
                 RowBox[{"f", "/.", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"x", "->", 
                    RowBox[{"1", "+", 
                    RowBox[{"\[Delta]", "/", 
                    SqrtBox["2"]}]}]}], ",", 
                    RowBox[{"y", "->", 
                    RowBox[{"1", "+", 
                    RowBox[{"\[Delta]", "/", 
                    SqrtBox["2"]}]}]}]}], "}"}]}]}], "}"}]}], "}"}], "]"}]}], 
           "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"AxesLabel", "->", 
          RowBox[{"{", 
           
           RowBox[{"\"\<\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)\>\"", 
            ",", "\"\<\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)\>\"", ",",
             "None"}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"AxesOrigin", "->", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"BaseStyle", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", 
            RowBox[{"FontSize", "->", "18"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Boxed", "->", "False"}], ",", "\[IndentingNewLine]", 
         RowBox[{"BoxRatios", "->", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Ticks", "->", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
              "a", ",", \
"\"\<\!\(\*StyleBox[\"a\",FontSlant->\"Italic\"]\)\>\""}], "}"}], "}"}], ",", 
            
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
              "b", ",", \
"\"\<\!\(\*StyleBox[\"b\",FontSlant->\"Italic\"]\)\>\""}], "}"}], "}"}], ",", 
            
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
               "L", ",", "\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\)\!\
\(\*StyleBox[\" \",FontSlant->\"Italic\"]\)\>\""}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"L", "-", "\[Epsilon]"}], ",", 
                RowBox[{"Style", "[", 
                 
                 RowBox[{"\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) - \
\[Epsilon]\>\"", ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"\[Epsilon]", ">", "0.4"}], ",", "Black", ",", 
                    "White"}], "]"}]}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"L", "+", "\[Epsilon]"}], ",", 
                RowBox[{"Style", "[", 
                 
                 RowBox[{"\"\<\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) + \
\[Epsilon]\>\"", ",", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"\[Epsilon]", ">", "0.4"}], ",", "Black", ",", 
                    "White"}], "]"}]}], "]"}]}], "}"}]}], "}"}]}], "}"}]}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Epsilon]", ",", "0.8"}], "}"}], ",", "0.01", ",", "1"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ControlPlacement", "->", "Top"}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Times\>\""}], ",", 
         RowBox[{"FontSize", "->", "18"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"SaveDefinitions", "->", "True"}]}], "\[IndentingNewLine]", 
     "]"}]}]}], "]"}]], "Input",
 CellID->4070603,ExpressionUUID->"4a787496-dd78-44ec-bbb1-65a7bd0aff63"],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`f$$ = 2 + Rational[1, 2] $CellContext`x$$^2 + 
  Rational[1, 
     2] $CellContext`y$$^2, $CellContext`x$$, $CellContext`y$$, \
$CellContext`a$$ = 1, $CellContext`b$$ = 1, $CellContext`L$$ = 
  3, $CellContext`\[Delta]$$ = 
  0.22895411014240336`, $CellContext`\[ScriptCapitalD]$$ = 
  MeshRegion[CompressedData["
1:eJxTTMoPSmViYGDQAWIQbbnlRNm++X/s39XYm8bt+m4v1Hzg1ELXP/a90/OA
zB9wfj6Y8dP+9s+6rD0lv+0NOdbIRKX8tgdrl/pt/1INJPLHPoxPd9Pc9z/t
Ty903fb57x97dbDCb/YzQMad+mt/8BRI4rO9Zkz/oa8a/+yBmvXvqnywBxo6
WYLln/25Veevhr15bQ8y3fr+X/svOWG167a9sAc7Y9tf+72PRWRPPn0M559g
t50dOv++PVvjVOfunL/2/g7CiYcv34bbP6W9Nerynutw981ZpLzzT/sV++6c
579Xfvxl76n3X/Hvt7P2PuadjglPf9if67h07wH3aXvxm+e+Bz/+bh/yeOns
Iwon7Fd9vOSbJPDNPjB7VvmcRaeh7v8C118tss79YdUne2VwAF2A0h/spefF
aZ4WuGyfoZRTUbX0DVz+XZST3YubL+yP9huW6yqeh4bnc3vvVywmgmZn7I2P
bNTLW/zU/oLLjQ9fvE7a/3r7+oCl8iM4v/bC5sivO+/Zg50Rc9n+JCga9G9C
3fHE/trRXJOG7RfswVyRD/ZWyl7VzfpnoPH6xX6HQ9Oj4zNO28u3vg7cIffT
XmLqFc4MpQvwcAkAK7xiD0sfTNrtYjfP3baXBsYWW+Nf+98xuUf/bXpob8t1
fXGB7T97o1ADrZXCz+D89ycPO63NfGEPMu2S7z/7J83zzq46/xbOh8U7jH8Y
6Iv+Qx/h6QKSHj9D09Nf+28g6a9f7EGxdEHpr/0OOZDDv9kDAFHUffs=
   "], {
    Polygon[{{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
     19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
     37, 38, 39, 40, 41, 42, 43, 44}}]}, 
   Method -> {
    "EliminateUnusedCoordinates" -> True, "DeleteDuplicateCoordinates" -> 
     Automatic, "DeleteDuplicateCells" -> Automatic, "VertexAlias" -> 
     Identity, "CheckOrientation" -> Automatic, "CoplanarityTolerance" -> 
     Automatic, "CheckIntersections" -> Automatic, "BoundaryNesting" -> 
     Automatic, "SeparateBoundaries" -> Automatic, "TJunction" -> Automatic, 
     "PropagateMarkers" -> True, "ZeroTest" -> Automatic, "Hash" -> 
     7856824301709777151}]}, 
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`\[Epsilon]$$ = 0.35000000000000003`, 
     Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
     1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
        Hold[$CellContext`\[Epsilon]$$], 0.8}, 0.01, 1, ControlType -> 
       Manipulator}}, Typeset`size$$ = {
     240., {117.36834193820809`, 124.60076381320809`}}, Typeset`update$$ = 0, 
     Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`\[Epsilon]$$ = 0.8}, 
       "ControllerVariables" :> {}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, 
       "Body" :> ($CellContext`\[Delta]$$ = 
         Sqrt[2] (Sqrt[1 + $CellContext`\[Epsilon]$$] - 1); Show[
          Plot3D[{$CellContext`f$$, 0}, 
           
           Element[{$CellContext`x$$, $CellContext`y$$}, $CellContext`\
\[ScriptCapitalD]$$], Mesh -> None, 
           PlotRange -> {{-0.1, 2}, {-0.1, 2}, {0, 6}}, PlotStyle -> 
           Opacity[0.7], RegionFunction -> 
           Function[{$CellContext`x$, $CellContext`y$}, 
             Norm[{$CellContext`x$, $CellContext`y$} - {$CellContext`a$$, \
$CellContext`b$$}] > 0.02]], 
          ParametricPlot3D[{1, 1, 0.01} + $CellContext`r {
              Cos[$CellContext`\[Theta]], 
              Sin[$CellContext`\[Theta]], 0}, {$CellContext`r, 
            0, $CellContext`\[Delta]$$}, {$CellContext`\[Theta], 0, 2 Pi}, 
           Mesh -> None, PlotStyle -> Directive[
             ColorData[97, 4], 
             Opacity[0.8]]], 
          ParametricPlot3D[
           Evaluate[
            
            ReplaceAll[{$CellContext`x$$, $CellContext`y$$, $CellContext`z \
$CellContext`f$$}, {$CellContext`x$$ -> 
              1 + $CellContext`\[Delta]$$ 
                Cos[$CellContext`\[Theta]], $CellContext`y$$ -> 
              1 + $CellContext`\[Delta]$$ 
                Sin[$CellContext`\[Theta]]}]], {$CellContext`z, 0, 
            1}, {$CellContext`\[Theta], 0, 2 Pi}, Mesh -> None, PlotStyle -> 
           Directive[
             ColorData[97, 5], 
             Opacity[0.4]]], 
          Graphics3D[{Gray, 
            Line[{{$CellContext`a$$, 0, 0}, {$CellContext`a$$, 2, 0}}], 
            Line[{{0, $CellContext`b$$, 0}, {2, $CellContext`b$$, 0}}], Black, 
            PointSize[0.02], 
            Point[{$CellContext`a$$, $CellContext`b$$, 0}], 
            Text["\[ScriptCapitalD]", {1.6, 1.6, 0}], 
            Line[
             
             ReplaceAll[{{$CellContext`x$$, $CellContext`y$$, \
$CellContext`f$$}, {
               0, 0, $CellContext`f$$}}, {$CellContext`x$$ -> \
$CellContext`a$$, $CellContext`y$$ -> $CellContext`b$$}]], 
            Line[
             
             ReplaceAll[{{$CellContext`x$$, $CellContext`y$$, \
$CellContext`f$$}, {0, 0, $CellContext`f$$}}, {$CellContext`x$$ -> 
               1 - $CellContext`\[Delta]$$/Sqrt[2], $CellContext`y$$ -> 
               1 - $CellContext`\[Delta]$$/Sqrt[2]}]], 
            Line[
             
             ReplaceAll[{{$CellContext`x$$, $CellContext`y$$, \
$CellContext`f$$}, {0, 0, $CellContext`f$$}}, {$CellContext`x$$ -> 
               1 + $CellContext`\[Delta]$$/Sqrt[2], $CellContext`y$$ -> 
               1 + $CellContext`\[Delta]$$/Sqrt[2]}]], 
            Thickness[0.015], 
            ColorData[97, 4], 
            Line[{{0, 0, 
               
               ReplaceAll[$CellContext`f$$, {$CellContext`x$$ -> 
                 1 - $CellContext`\[Delta]$$/Sqrt[2], $CellContext`y$$ -> 
                 1 - $CellContext`\[Delta]$$/Sqrt[2]}]}, {0, 0, 
               
               ReplaceAll[$CellContext`f$$, {$CellContext`x$$ -> 
                 1 + $CellContext`\[Delta]$$/Sqrt[2], $CellContext`y$$ -> 
                 1 + $CellContext`\[Delta]$$/Sqrt[2]}]}}]}], 
          AxesLabel -> {
           "\!\(\*StyleBox[\"x\",FontSlant->\"Italic\"]\)", 
            "\!\(\*StyleBox[\"y\",FontSlant->\"Italic\"]\)", None}, 
          AxesOrigin -> {0, 0, 0}, 
          BaseStyle -> {FontFamily -> "Times", FontSize -> 18}, Boxed -> 
          False, BoxRatios -> {1, 1, 1}, 
          Ticks -> {{{$CellContext`a$$, 
              "\!\(\*StyleBox[\"a\",FontSlant->\"Italic\"]\)"}}, \
{{$CellContext`b$$, 
              "\!\(\*StyleBox[\"b\",FontSlant->\"Italic\"]\)"}}, \
{{$CellContext`L$$, 
              "\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)"}, {$CellContext`L$$ - $CellContext`\[Epsilon]$$, 
              
              Style[
              "\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) - \[Epsilon]", 
               
               If[$CellContext`\[Epsilon]$$ > 0.4, Black, 
                White]]}, {$CellContext`L$$ + $CellContext`\[Epsilon]$$, 
              Style[
              "\!\(\*StyleBox[\"L\",FontSlant->\"Italic\"]\) + \[Epsilon]", 
               If[$CellContext`\[Epsilon]$$ > 0.4, Black, White]]}}}]), 
       "Specifications" :> {{{$CellContext`\[Epsilon]$$, 0.8}, 0.01, 1}}, 
       "Options" :> {
        ControlPlacement -> Top, 
         LabelStyle -> {FontFamily -> "Times", FontSize -> 18}}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{290.5, {165.3683419382081, 172.6007638132081}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     Initialization:>({
       Attributes[$CellContext`x$] = {Temporary}, 
        Attributes[$CellContext`y$] = {Temporary}, $CellContext`r = {-100, 28,
          0}}; Typeset`initDone$$ = True),
     SynchronousInitialization->True,
     UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]],
  DynamicModuleValues:>{}]], "Output",
 CellID->58897804,ExpressionUUID->"d07c5144-08c0-4462-b9cb-8a09079be467"]
}, {2}]],

Cell["\<\
Next, you will see how limits are defined in complex analysis.\
\>", "Text",
 CellID->32979258,ExpressionUUID->"8a755375-2388-4d59-a5ba-d809c72168df"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Limits", "Subsection",
 CellID->223760667,ExpressionUUID->"71d8e598-c87b-426a-9469-910ed1dbc293"],

Cell[CellGroupData[{

Cell["Definition", "Subsubsection",
 CellID->172100181,ExpressionUUID->"405345db-9cd0-4f8e-942d-d82ff735cf2c"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"acd18cbf-79be-4c87-8102-4e9b6928dd1f"],
 " has limit ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath",ExpressionUUID->
  "94d9b4b9-4f06-41fa-ae8a-59c8c6a99685"],
 ", written"
}], "Text",
 CellID->12329778,ExpressionUUID->"12ebd10c-b96b-412a-b92d-bb76fb186f97"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", "A"}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->7617918,ExpressionUUID->"736e06cb-99be-4210-b167-c4ed02dc062e"],

Cell[TextData[{
 "if for every ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Epsilon]", ">", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6f14f186-5ca2-41be-b01b-279a964b70a5"],
 " there is a number ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", ">", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"37a1301d-0874-4c2b-b958-fec5949a34e3"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], "-", "A"}], "\[RightBracketingBar]"}], "<",
     "\[Epsilon]"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a6be2bb3-0081-4167-b813-27c9e74716f7"],
 " for every ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "0d49c822-1c32-417c-9b85-3b1cff8c7ed9"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", "a"}], "|", 
    RowBox[{"<", "\[Delta]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a9900a88-ad1a-474a-a77a-1fbf8cbe9315"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "!=", "a"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b4c6473f-17b0-42db-a7d2-9219d0db1d26"],
 "."
}], "Text",
 CellID->309826210,ExpressionUUID->"be40a1ae-aff7-4cf8-8f1c-a1352a7cc446"],

Cell[TextData[{
 "In real analysis, the limit can only be calculated \
\[OpenCurlyDoubleQuote]from above\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]from below,\[CloseCurlyDoubleQuote] but in complex \
analysis, the limit, if it exists, must be the same along all of the \
infinitely many possible paths as ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c8180adb-f684-4595-bf7f-c35d1a2f8a5d"],
 " approaches ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "deb5f900-c0d5-42d7-98c3-57fab687d0dc"],
 "."
}], "Text",
 CellID->74174823,ExpressionUUID->"ea7c1f03-26f1-4b3b-bc51-7a6f15c7f1c2"],

Cell[TextData[{
 "In Wolfram Language, the limit can be computed with the command ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ". It is important to use the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Direction",
    BaseStyle->"CodeLink"], "\[Rule]", "\[DoubleStruckCapitalC]"}]], 
  "InlineCodeText",ExpressionUUID->"8fa56fe1-8a6a-9a43-b84d-1c06230569c5"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Direction",
    BaseStyle->"CodeLink"], "\[Rule]", 
   ButtonBox["Complexes",
    BaseStyle->"CodeLink"]}]], "InlineCodeText",ExpressionUUID->
  "31cca2ea-c643-ca47-9302-6325a1c65266"],
 " in order to compute the complex limit."
}], "Text",
 CellID->381342474,ExpressionUUID->"f0f197fa-7e8a-c842-86e5-9ea38b60c36e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->158097839,ExpressionUUID->"f165f408-9167-4e05-9eaa-53f23ec8a1ca"],

Cell[TextData[{
 "The limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "2"}]], 
    FractionBox[
     SuperscriptBox["z", "2"], 
     RowBox[{"z", "-", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e79923f2-9714-48ca-abbb-9baacd6f001f"],
 " is 4. You can check in Wolfram Language:"
}], "SolvedExampleNote",
 CellID->526205217,ExpressionUUID->"d2033d1e-d8ba-46b8-935f-eb1e60e4da0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{"z", "-", "1"}]], ",", 
   RowBox[{"z", "->", "2"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    TemplateBox[{},
     "Complexes"]}]}], "]"}]], "SolvedExampleInput",
 CellID->22796543,ExpressionUUID->"0079176e-082a-4a50-b241-65362f70f990"],

Cell[BoxData["4"], "SolvedExampleOutput",
 CellID->100353373,ExpressionUUID->"dff141a4-0d8b-4d51-92f5-7a9c4397211f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"4389328e-2a1d-41f7-bb5c-8f3c153f4b0f"],

Cell["Let\[CloseCurlyQuote]s visualize the limit in Example 7.1.", "Text",
 CellID->370991071,ExpressionUUID->"e9894cdc-b3d4-459f-9538-71b5a72a973b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      FractionBox[
       SuperscriptBox["z", "2"], 
       RowBox[{"z", "-", "1"}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "4"}], "}"}], ",", 
      RowBox[{"PlotLegends", "->", "True"}]}], "]"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["2", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["768", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
      Graphics3D[{
        PointSize[Medium], 
        Point[{2, 0, 4}]}], 
      ListPointPlot3D[{
        Callout[{2, 0, 4}, 
         ToString[$CellContext`z == 2, TraditionalForm], Above]}]],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["824", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ((("Fig. 1. The function " <> 
       ToString[$CellContext`z^2/($CellContext`z - 1), TraditionalForm]) <> 
      " and the point ") <> ToString[$CellContext`z == 2, TraditionalForm]) <> 
    "."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->4531589,ExpressionUUID->"8549fc6e-4f32-464e-a45b-b2af99d4a994"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[
        InsetBox[
         Graphics3DBox[{{
            GraphicsComplex3DBox[CompressedData["
1:eJyVnWVcVVnYt+k8hziAigMoWKNiYPfZdg2OmFiA3R3YBUooISoqBoMtBmLL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             "], {{{
                Texture[
                 GraphicsBox[
                  TagBox[
                   RasterBox[CompressedData["
1:eJy1nWeUVNW2tu+43xhHRZFgOIaqBgRBcuiG7ibnKDlDEyXnnEWSIjmDRMmK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                    "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                    RGBColor], 
                   BoxForm`ImageTag[
                   "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                   Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                  ImageSizeRaw -> {144., 144.}, 
                  PlotRange -> {{0, 144.}, {0, 144.}}]], 
                EdgeForm[None], 
                GraphicsGroup3DBox[
                 TagBox[{
                   Polygon3DBox[CompressedData["
1:eJxNnXXcVcUWhk/sY+I1sDBRBAREuiREMLAVBZUQFK6C1w4E6xJiYIIF2IqK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                    "]], 
                   
                   Polygon3DBox[{{1367, 1130, 439, 1368}, {1353, 469, 1098, 
                    1363}, {1377, 1171, 993, 1376}, {1348, 439, 1058, 1370}, {
                    1360, 993, 469, 1361}, {1344, 1132, 1130, 1352}, {1347, 
                    1098, 1132, 1344}, {1343, 1208, 1170, 1356}, {1356, 1170, 
                    1171, 1357}, {1346, 1058, 1208, 1372}}]}, 
                  Annotation[#, "Charting`Private`Tag$74665#1"]& ]]}, {}, {
                GrayLevel[0.82], 
                EdgeForm[None], 
                GraphicsGroup3DBox[{
                  
                  Polygon3DBox[{{1359, 1251, 1371}, {1125, 1133, 991}, {1126, 
                   1131, 991}, {1349, 1125, 1369}, {1125, 1251, 976}, {1375, 
                   976, 1374}, {1126, 1133, 976}, {1217, 1126, 976}, {1342, 
                   1151, 1355}, {1374, 976, 1373}, {1133, 1126, 991}, {1350, 
                   1126, 1351}, {1133, 1125, 976}, {1354, 1131, 1362}, {1365, 
                   991, 1364}, {1151, 1125, 991}, {1345, 1217, 1358}, {1366, 
                   991, 1365}}], 
                  
                  Polygon3DBox[{{1358, 1217, 976, 1375}, {1355, 1151, 991, 
                   1366}, {1364, 991, 1131, 1354}, {1371, 1251, 1125, 1349}, {
                   1369, 1125, 1151, 1342}, {1351, 1126, 1217, 1345}, {1362, 
                   1131, 1126, 1350}, {1373, 976, 1251, 1359}}]}]}, {}, {}}, {
              
               GrayLevel[0], 
               Line3DBox[CompressedData["
1:eJwl0jdSG0AABdBFgAlGEjkKM24JFyC2hI6K0FGQTTQgkaN9AULPQEVHuABc
AExJgy9gYAabDvtpXLzZX+zO3/R5aLp3KiOEsMefrBDS+cx4nBlCndzGICmO
uOKeF+ImN9HDGN855Yaf/KU2EkIL/SxxwAV3PBHV00AXUb2x7BBG5Fe5nVF5
jHEmmOQLU0wzwyxzzPOVBRZZIkmKZVZYZY11Nthki212iOuM28Ou/FvuYFju
pJ4Cftn3Lefss0gfzSR4d+5HrjnhG6N000iMZ/f3g0sOSTJAKyc63vR+kh+M
RdTKCWqopopKKiinjFJKKKaIwvQbESNKAR/JJ49ccviAIwc1QXWIpNdm/f8P
/wCsqDav
                "]], 
               
               Line3DBox[{1345, 1351, 1350, 1362, 1354, 1364, 1365, 1366, 
                1355, 1342, 1369, 1349, 1371, 1359, 1373, 1374, 1375, 1358, 
                1345}], 
               
               Line3DBox[{1372, 1346, 1370, 1348, 1368, 1367, 1352, 1344, 
                1347, 1363, 1353, 1361, 1360, 1376, 1377, 1357, 1356, 1343, 
                1372}]}}, VertexNormals -> CompressedData["
1:eJxsvHc01///Pm41JCGjYSfSFpUyuiFkJVkVUlIZJclsiFKyQqVUlJBVkh1S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              "], VertexTextureCoordinates -> CompressedData["
1:eJyF23+sn1V9wPEGYbZxMdwRo6mSwOqYC13WMdENrd84XYmLgpakdI7F3TpL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              "]], {}}, {
            PointSize[Medium], 
            Point3DBox[{2, 0, 4}]}, {{{
              RGBColor[0.216, 0.5399999999999999, 0.7200000000000001], 
              PointSize[
               NCache[
                Rational[7, 360], 0.019444444444444445`]], 
              Point3DBox[{2., 0., 4.}]}, {{}, {{}, 
               Inset3DBox[
                GraphicsBox[
                 GraphicsGroupBox[{{
                    GrayLevel[1], 
                    AbsoluteThickness[4], 
                    Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]], 
                    CapForm["Butt"], 
                    JoinForm["Round"], 
                    BSplineCurveBox[{
                    Offset[{1.8369701987210297`*^-16, 3.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 8.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 10.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 12.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 12.}, {0., 0.}]}]}, {
                    RGBColor[
                    0.6666666666666666, 0.6666666666666666, 
                    0.6666666666666666], 
                    AbsoluteThickness[1.25], 
                    BSplineCurveBox[{
                    Offset[{1.8369701987210297`*^-16, 3.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 8.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 10.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 12.}, {0., 0.}], 
                    Offset[{4.898587196589413*^-16, 12.}, {0., 0.}]}]}, {
                    EdgeForm[None], 
                    FaceForm[{
                    GrayLevel[1], 
                    Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]}], 
                    PolygonBox[{
                    Offset[{19.999999999999996`, 34.}, {0., 0.}], 
                    
                    Offset[{20.000000000000004`, 12.000000000000004`}, {0., 
                    0.}], 
                    
                    Offset[{-19.999999999999996`, 11.999999999999996`}, {0., 
                    0.}], 
                    Offset[{-20.000000000000004`, 34.}, {0., 0.}]}]}, {
                    RGBColor[
                    0.6666666666666666, 0.6666666666666666, 
                    0.6666666666666666], 
                    AbsoluteThickness[1.25], 
                    EdgeForm[None]}, {}, 
                   InsetBox[
                    StyleBox[
                    RotationBox[
                    "\"\\!\\(\\*FormBox[RowBox[{\\\"z\\\", \\\"\[LongEqual]\\\
\", \\\"2\\\"}], TraditionalForm]\\)\"", BoxRotation -> 0.], StripOnInput -> 
                    False, LineOpacity -> 1, FrontFaceOpacity -> 1, 
                    BackFaceOpacity -> 1, Opacity -> 1, FontOpacity -> 1], 
                    Offset[{4.898587196589413*^-16, 23.}, {0., 0.}], 
                    NCache[
                    ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    ImageScaled[{0.5, 0.5}]]]}], AspectRatio -> Full, 
                 ImageSize -> {69, 51}, PlotRange -> {{-0.5, 0.5}, {0, 1}}], {
                2., 0., 4.}, 
                Offset[{0., -2.58434862838554}, {0, 0}]]}}, {}}, {}}}, Axes -> 
          True, AxesLabel -> {None, None, None}, 
          AxesOrigin -> {Automatic, Automatic, Automatic}, Background -> None,
           BoxRatios -> {1, 1, 0.4}, DisplayFunction -> Identity, FaceGrids -> 
          None, ImageMargins -> 0., Lighting -> "Neutral", 
          Method -> {"RotationControl" -> "Globe"}, 
          PlotRange -> {{-4., 4.}, {-4., 4.}, {0., 8.62114661373909}}, 
          PlotRangePadding -> {
            Scaled[0.02], 
            Scaled[0.02], 
            Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}], {0., 
         0.}, 
         ImageScaled[{0., 0.}], {240., 235.0831624602757}, ContentSelectable -> 
         True], AspectRatio -> 0.8984096612928154, Background -> None, 
        ContentSelectable -> True, ImageMargins -> 0., ImagePadding -> 0., 
        ImageSize -> {240., 215.6183187102757}, 
        PlotRange -> {{0., 240.}, {0., 215.6183187102757}}, PlotRangePadding -> 
        None], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 1. The function \\!\\(\\*FormBox[FractionBox[SuperscriptBox[\\\
\"z\\\", \\\"2\\\"], RowBox[{\\\"z\\\", \\\"-\\\", \\\"1\\\"}]], \
TraditionalForm]\\) and the point \\!\\(\\*FormBox[RowBox[{\\\"z\\\", \\\"\
\[LongEqual]\\\", \\\"2\\\"}], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1045233902,ExpressionUUID->"32480aeb-e278-4da4-ae49-79341f3bc11d"]
}, {2}]],

Cell[TextData[{
 "It is visible from the graph that the limit for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "72a93268-1548-4fa1-9740-c2cf3210c130"],
 " exists: the function\[CloseCurlyQuote]s graph is smooth at that point, \
both in the height of the surface (modulus) and in its color (argument)."
}], "Text",
 CellID->28576462,ExpressionUUID->"bd8f8efd-ab1a-428a-95a8-3065f3305221"],

Cell[TextData[{
 "The big spike at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e6c94c3f-84d0-4d56-bc1f-078de20a97d8"],
 " corresponds to a singularity. The limit does not exist at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "eebdcaab-49c0-4579-b464-5701b2b71019"],
 ". You will later see that singularities such as this are called ",
 StyleBox["poles",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->43824269,ExpressionUUID->"1f21d866-a3c6-4bc7-a707-a3342a2d0713"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellTags->"Example72",
 CellID->418528963,ExpressionUUID->"b1b5cdca-c438-4323-9dca-427632ab8a2a"],

Cell["The limit", "SolvedExampleNote",
 CellID->531570879,ExpressionUUID->"62ca0458-4fc3-425c-a95f-6783354a99f6"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"1c6ee29c-bf01-47e0-b892-37269c3b0801"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     FractionBox["z", 
      OverscriptBox["z", "_"]]}], "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "0"}]], 
     FractionBox[
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], 
      RowBox[{"x", "-", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8b08a236-c041-44ff-96dc-eadf2d165964"]
}], "SolvedExampleNote",
 CellID->158359860,ExpressionUUID->"7fd954f9-ce72-4c86-9e0c-aa9e6a1b44cb"],

Cell["does not exist. This is because along the real line, it is", \
"SolvedExampleNote",
 CellID->7155740,ExpressionUUID->"53d52189-6f9f-4f3d-bdb7-b9b0c1e1f476"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"6fcc70aa-eaff-41b4-bb1a-6b7905e95914"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"x", "->", "0"}]], 
     FractionBox["x", "x"]}], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4d098302-36f5-42a8-9c14-b7d8192025ce"]
}], "SolvedExampleNote",
 CellID->273673067,ExpressionUUID->"950ee6c3-4189-44c4-836c-5f07fc8fdd25"],

Cell["and along the imaginary axis it is", "SolvedExampleNote",
 CellID->4782356,ExpressionUUID->"9b198cab-3d84-4851-b1e1-07ae0251d7a3"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"9f35d5fc-ae9d-4ffa-b62e-66f0cb2222f8"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"y", "->", "0"}]], 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "y"}], 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "y"}]]}], "=", 
     RowBox[{"-", "1"}]}], ","}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7e0f244a-c706-4b34-b861-fba2e65a652a"]
}], "SolvedExampleNote",
 CellID->360883093,ExpressionUUID->"d7bbe6ce-8f8b-4056-9de2-a97349198483"],

Cell[TextData[{
 "and since the two limits do not agree, the limit for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "91559006-c37c-477e-a717-7c3c722ab1d7"],
 " cannot exist."
}], "SolvedExampleNote",
 CellID->122611559,ExpressionUUID->"fa80307d-4964-47f7-b239-2b63c6d24351"],

Cell["In Wolfram Language:", "SolvedExampleNote",
 CellID->510411673,ExpressionUUID->"fe233e35-c6ad-4317-a97e-d5f01edfbb22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{"Conjugate", "[", "z", "]"}]}], ",", 
   RowBox[{"z", "->", "0"}], ",", 
   RowBox[{"Direction", "\[Rule]", 
    TemplateBox[{},
     "Complexes"]}]}], "]"}]], "SolvedExampleInput",
 CellID->190705125,ExpressionUUID->"56cd6ead-f7e9-4389-aa6a-5d962dc45b14"],

Cell[BoxData["Indeterminate"], "SolvedExampleOutput",
 CellID->82929659,ExpressionUUID->"560e79f8-8087-4aa9-af0b-2435cef0b515"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1616222061,ExpressionUUID->"9d61cf07-1aa2-4ccf-a009-9163eca3a419"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s see now a plot of the function in Example 7.2, whose \
limit does not exist at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9d09553a-8275-4db0-84fb-eb192ce2854c"],
 "."
}], "Text",
 CellID->240763666,ExpressionUUID->"2541f67c-dc25-4b05-bb71-712dbab27226"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      FractionBox["z", 
       RowBox[{"Conjugate", "[", "z", "]"}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      RowBox[{"PlotLegends", "->", "True"}], ",", 
      RowBox[{"ImageSize", "->", "250"}]}], "]"}], ",", 
    RowBox[{"ListPointPlot3D", "[", 
     RowBox[{"{", 
      RowBox[{"Callout", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"ToString", "[", 
         RowBox[{
          SubscriptBox["z", "0"], ",", "TraditionalForm"}], "]"}]}], "]"}], 
      "}"}], "]"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Fig. 2. The function \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{
         Cell["",ExpressionUUID->"42f1e442-2fb8-4fb4-8165-3da70b27d9d5"], 
          RowBox[{
           OverscriptBox["z", "_"], "/", "z"}]}], ",", "TraditionalForm"}], 
        "]"}], "<>", "\"\< and the point \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{Cell[TextData[{
          Cell[BoxData[
           FormBox[
            SubscriptBox["z", "0"], TraditionalForm]],ExpressionUUID->
           "3c92792e-0d68-4cb9-a742-7f2ced80f58e"],
          "=0"
         }],ExpressionUUID->"699dcae9-5cb9-41c2-870d-af00d8d6b15b"], ",", 
         "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}], "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellID->622516393,ExpressionUUID->"ac60cb61-e5f0-419e-8c6e-d800e0dd0efc"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[
        InsetBox[
         Graphics3DBox[{{
            GraphicsComplex3DBox[CompressedData["
1:eJx13E/opVUdx/E7jTgahtUiwZ0M0aZN6M7ieWjhKghmU1AbjShzMTBCiLpU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             "], {{{
                Texture[
                 GraphicsBox[
                  TagBox[
                   RasterBox[CompressedData["
1:eJyFnWdUlGm2tmedb61Ru1tFe7qnp7swdqvdRiSViqKiImYJBsScs2LOopgx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                    "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
                    RGBColor], 
                   BoxForm`ImageTag[
                   "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                   Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
                  ImageSizeRaw -> {100., 100.}, 
                  PlotRange -> {{0, 100.}, {0, 100.}}]], 
                EdgeForm[None], 
                GraphicsGroup3DBox[
                 TagBox[
                  Polygon3DBox[CompressedData["
1:eJxNnHf8j9X7x9/3fbf33koobaRERBSSZCRRiIRkFtIgIskomRmVpkppT1Ha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                   "]], 
                  Annotation[#, 
                   "Charting`Private`Tag$76010#1"]& ]]}, {}, {}, {}, {}}, {
               GrayLevel[0], 
               Line3DBox[CompressedData["
1:eJwl0kkyHUAYB/COKaZHxDyXLXIBYW/YWRl2FngSc/KMMSYoZVrgxbDkAoYL
cAHDBeQCwgXwe2Xxq+9f1V319dfdNT3D7UMfQgh/OEgOIZH31BWq5Sa6mSLO
Jfc8k2vzF9qIssop1/zjlcqkEL7SyQR7nHPLfyL61NHCOkf0EWebfqIM8I3v
DDLEMCOMMsY4P/hJjAkmmWKaGWb5xRzzLLDIEstscMxv/rJDL83Uks2jc99w
xi4xOmigghdzP3DFCSv000o9OTy5vzsu2GeSLhpZ0+OQqsSaukWlXEE5ZZRS
QjFFFFJAPp/J41PijcghQjZZZJJBOh9JI5UUtApGCJvJ7//hDeewN+o=
                "]]}}, VertexNormals -> CompressedData["
1:eJztXM2LHUUQf6iQi/d4MghuECEoyyaKZN+OS2RBBJ8fiycRBYkHMacgqBhP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              "], VertexTextureCoordinates -> CompressedData["
1:eJx12z+o1mUYh/FDYeimQxSWUAlNUg7lEmYOKUVLFhE0hIIUNFTipgaWlEOC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              "]], {}}, {{{
              RGBColor[0.216, 0.5399999999999999, 0.7200000000000001], 
              PointSize[
               NCache[
                Rational[7, 360], 0.019444444444444445`]], 
              Point3DBox[{0., 0., 1.}]}, {{{}, 
               Inset3DBox[
                GraphicsBox[
                 GraphicsGroupBox[{{
                    GrayLevel[1], 
                    AbsoluteThickness[4], 
                    Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]], 
                    CapForm["Butt"], 
                    JoinForm["Round"], 
                    BSplineCurveBox[{
                    
                    Offset[{2.121320343559643, 2.1213203435596424`}, {0., 
                    0.}], 
                    Offset[{5.656854249492381, 5.65685424949238}, {0., 0.}], 
                    Offset[{7.65685424949238, 5.65685424949238}, {0., 0.}], 
                    Offset[{9.65685424949238, 5.65685424949238}, {0., 0.}], 
                    
                    Offset[{9.65685424949238, 5.65685424949238}, {0., 
                    0.}]}]}, {
                    RGBColor[
                    0.6666666666666666, 0.6666666666666666, 
                    0.6666666666666666], 
                    AbsoluteThickness[1.25], 
                    BSplineCurveBox[{
                    
                    Offset[{2.121320343559643, 2.1213203435596424`}, {0., 
                    0.}], 
                    Offset[{5.656854249492381, 5.65685424949238}, {0., 0.}], 
                    Offset[{7.65685424949238, 5.65685424949238}, {0., 0.}], 
                    Offset[{9.65685424949238, 5.65685424949238}, {0., 0.}], 
                    
                    Offset[{9.65685424949238, 5.65685424949238}, {0., 
                    0.}]}]}, {
                    EdgeForm[None], 
                    FaceForm[{
                    GrayLevel[1], 
                    Opacity[
                    NCache[
                    Rational[2, 3], 0.6666666666666666]]}], 
                    PolygonBox[{
                    
                    Offset[{28.656854249492376`, 18.85685424949238}, {0., 
                    0.}], 
                    
                    Offset[{28.656854249492383`, -3.1431457505076192`}, {0., 
                    0.}], 
                    Offset[{9.656854249492381, -3.143145750507623}, {0., 0.}], 
                    
                    Offset[{9.656854249492378, 18.85685424949238}, {0., 
                    0.}]}]}, {
                    RGBColor[
                    0.6666666666666666, 0.6666666666666666, 
                    0.6666666666666666], 
                    AbsoluteThickness[1.25], 
                    EdgeForm[None]}, {}, 
                   InsetBox[
                    StyleBox[
                    RotationBox[
                    "\"\\!\\(\\*FormBox[SubscriptBox[\\\"z\\\", \\\"0\\\"], \
TraditionalForm]\\)\"", BoxRotation -> 0.], StripOnInput -> False, 
                    LineOpacity -> 1, FrontFaceOpacity -> 1, BackFaceOpacity -> 
                    1, Opacity -> 1, FontOpacity -> 1], 
                    Offset[{19.15685424949238, 7.856854249492379}, {0., 0.}], 
                    
                    NCache[
                    ImageScaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    ImageScaled[{0.5, 0.5}]]]}], AspectRatio -> Full, 
                 ImageSize -> {48, 51}, PlotRange -> 
                 NCache[{{-1 + 2^Rational[-1, 2], 1 + 2^Rational[-1, 2]}, {-1 + 
                    2^Rational[-1, 2], 1 + 
                    2^Rational[-1, 2]}}, {{-0.29289321881345254`, 
                   1.7071067811865475`}, {-0.29289321881345254`, 
                   1.7071067811865475`}}]], {0., 0., 1.}, 
                
                Offset[{-2.1627865594543785`, -1.4229872457874095`}, {0, 
                 0}]]}, {}}, {}}, {}}}, Axes -> True, 
          AxesLabel -> {None, None, None}, 
          AxesOrigin -> {Automatic, Automatic, Automatic}, Background -> None,
           BoxRatios -> {1, 1, 0.4}, DisplayFunction -> Identity, FaceGrids -> 
          None, ImageMargins -> 0., ImageSize -> 250, Lighting -> "Neutral", 
          Method -> {"RotationControl" -> "Globe"}, 
          PlotRange -> {{-3., 3.}, {-3., 3.}, {0.9999999999999998, 
           1.0000000000000002`}}, PlotRangePadding -> {
            Scaled[0.02], 
            Scaled[0.02], 
            Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}], {0., 
         0.}, 
         ImageScaled[{0., 0.}], {250., 236.14043098384877`}, 
         ContentSelectable -> True], AspectRatio -> 0.8165773489353951, 
        Background -> None, ContentSelectable -> True, ImageMargins -> 0., 
        ImagePadding -> 0., ImageSize -> {250., 204.14433723384877`}, 
        PlotRange -> {{0., 250.}, {6.097656249999993, 210.24199348384877`}}, 
        PlotRangePadding -> None], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ
igyJEhkP5ziZxzgcZz4kKal8zvcP+P5wr7X3Xnvtdd/X3vf79bq2yllfa3cB
Pj6+Ft7g543/Oy7qHRx6Kd0C4llZdlIqDfzG16QNdzDwJ+hzS+5FAtTfymjd
3EbD8UVhOfcQBmaYi/fT/NqxNmKljQt5Eu7j9ST5GgbEprd9ctpOwsiZh4ty
PpPYLFof6vCXgYUrVy49d+3Ak0XS1Rdik1gbl6KgDSYqRmyiW1aR4ayvNKGY
R8Xx7XXnkyOYOLRRiZPwhgzJKTua834qbAM76fc+MMEXO/vB3OQz9r9hfP33
ywRCLSXZ2xaZGE+JFamu/YwPCaLiViETsGwYux24h4U0+plLDls6UdPS0PVN
dgJ+YfwVp8NYEBBteHE4pRMOgt2XT5SMI3G57cbZdyx4/yy/Fc7pxOHGxgz/
o+PYopUdZPCLBRGRrps1O7uAu1ecTOkUoHtOStOIDYfz7YYvwrrQbh5k8CGK
gjz/FbtJAWyMuZt695Z3QUKWzBhSoqCTcWqtbikbqdNf6cWTXVB0lw68Vz6G
J7ELlebTbLASiseSJLpx27t+bvDYGMiOqdNrdTjIVKsrJ2/qxgrt55H59FH4
PpGMK7/AwTkp578F+7oxV6Qgwb06ioibUvpSzzhQeDUh/c+xbhye22qSvXoU
VSaJ/lsoHHQ95AfTphvWr60yHFy+4I+uWrP8Wi64N+2XuG7qwQ/nHMtVpBGc
0x7p7VfiIl/tAPPcXA8k/ApntHePwNJJaTpBkYvxTxr6eyt6cbB7FtHPh2Er
bb3OWIELK4Ho9Ys+fejzb7ERkBmG3hF64MhqLu6EFDreXNuP6uKyU9dCh9DM
2SMcKMdFumuwd3pjP1Z4KKtSKIMoXfFiQEiWi8hu4dn+8wM4beeT8cNsEO7b
IwXjZLhYKWky37NkELlVOyxS8weQfoc/WViaCwdVTQnxtEFEBT5JTRAZwEk9
r5QgKS7clJ2DqRpDiFW2ouW79iPg7A+FMUkuxJsiG+tKhvBtEyf3SXUfMkhk
/b3LuXjDnn3/02gYi04bvu5a2YdPzarsFHEuXGbnJTqrhlEb90thrVsvbCLF
7ChiXOieqLybYsSrl6JpJvd1D/KOPI5QW8pF2rIZv7CSEZSMmGaaLHRjW/fv
QBcRLtS3ifPXaX4BqTWn9CG6seusumWiEBfRJLHolIwvMGTXlnqHd0F4qZpU
pQAXh07NMpKERvE9f98yoYpOlLN/knr4ufCh3/Qk7hrFvxySbjL9Mx4FZqaz
Fznw0Ta+nujHe99TOfIKKz/DOkUwbP4PBzW3w/bUskbRvrmLGfaOjOxp1a9m
9Rws7J05Qj07hoje6+LyZ8mYXHaRWxDDQUzEzuVOPWNINr91qEqIjNGtJg/U
LDno77q+LciMgsCMk5e0nnVAPaNDoUKaA83E9iVhpRRMmrhbbdrfAcdjf+67
9LNhYJ8q/3zNOMgqzxLZlSQYewZvV85mI+ls7Ij+jXF4xFD+CxgnIjimQWXO
jY2pfIWHh5m8fXiuvMxQiAhTf6OoCS02Sh/98lU8OoGC9mQhxzXt6NwoHMWc
ZsFGo3SR8GIC4fQInUmtNvxYZW4hWsHCfm6qcoQ4Fbdea2QXahMQlLcovoe3
34PCJK1sLlDx7fNolplKK4o3a36N28/CGbmoTR6fePnCJkYIirTgqFyZ+sxS
FsInxeu61kxi0XT2fNtgE8I8s4f8Opj4e2Ez7XXAJFadCnX9ldkIxyaOiWgq
E7m2vy6tapvEufg4Tw3zBhRl1cRWOjEhTPwYIa1CQ6GgdX9Hdz20uBaTkRuY
oBziJr73p0FURevtJ5M6dNsJ3nJjMSBfYNik0URD0dSEv8KNWug/j8w7XcIA
68UJPpfVdKQViXJd19bAYvJx4OVgBq4LneDk2tEx/4kkXk+thoWi7W2FeTpC
p6y/kZPoqFPVfFP2phqEXa3dcsF0rPI0lOBvp+MuKePCwbhqfAsRZnrP07DU
AUnmQgw01iuuibpQjTjWtgNKV2jQ393kUrWLgbBNyr9dj1XjhUymmerCJBSM
5/54+TGgkXbnBMO4GreHdHUiQifhNrL44d9cBu5HnHkool+NfwcLpPX/UhHw
LXu0v4vHgV0O54p1qzFG1mfvuEqFYviJjDJBJqR+BaU28e5/RbQKSVlCxULD
oInMVibqxTzvG+6pxmOqufX+GxP4xJS1FTzNxJjA5YRhq2okDqQ17xOdQNob
sTvJcUx0O/5tTb5YjT2vUmfj48YRsX9ghljGxOVEpxV6vPVWODMea0qOI32L
AbNuhAmCXYD09ZJqXKmvtBBPpqDXzg4hwizIqpgynUarMV99XtxQjoLbxz/q
C+iw0Hm39GaMTA0W2/0Tn2aMIVNh4pq7NQuRukyjNssaxDB2i9usG4NWafWV
osssJHslqU7F16B4p4H6nqej0NPKnh5LZ8GVv/FdWVcNsp8IjDtrjWLDim0n
JatZsC1JNR1Xfg8+J4b8GV5OCz+cC7rUxcKoosLwjdBavAqdfmz7cATJO1qn
jdgsiNX2Nz0lf8SZrvPf5QeHIeexkO0qwIb0/SfdBdL12KW8JjZr9TAubJo7
9EOejeMnj51vPPAJSWuPSH62HYLgi7b7Pzaz0aT145zbxQZwfp3WyEkaREb8
UxmPA2zMIyn0/LVG5CTyKc0RB2D+QXqHhQMbHQk6z44lNeHOYmxUpdgAiqPs
z+b5sHF3pnzueFozbEx7iW0H+nFLP60vNIoNSc4tO//7LShSKCNJX+3D3Dou
kZTC416vrEL0nVaU1sZLXnzbC8Pxa265+Wy4/6pU3x1OgMj2Uqm8rz3Q3xL7
9FcVG9T5zir9C23YutPxbKZmD454bbzd18ZGt4DmHaZlO6JcpLxknHm8bHXl
3zvCm7++27uezUSk7d3AR77bBX8x1vDWKTaCBWf7HcRJ4NPmBt2q70RIPJNZ
vshGyO4dzsQJEoQfi1nTZz7jSnIjhSDJgWs7+8AHxw6s6lEQiFH+jFPm5H8D
lDnQkzbhP9nQAcG2y2TuQTKSHee2l+tycClnlM9Km4xGjUX1Wz4dMK5w+pS4
m4P4fT5v6+6SoaImHbpfmYTesh+xXCcOWKShe+1SnVh6756OYC0RWkp2do/C
OCgmerLLeX4RQ1RP4j9FREJa88KTTA40ZlKvJPd3425v327GVDsqaT2HFqo4
yG5353fQ7EXE0hvTLuHtMFs6L/K4jwMPhSAPU68+NG433sgn3I6SjZZzqd85
YB+L9BXL60fG8uSLJ6PbECJl3T7I4+fJS/a/hQcGELj9nTzjLwEB9MTdXjpc
0Dd8bbcSHkJV55MBFV8CvinaT5kf5AK+xucJ2sOYehm017mnFQvbPKO8z3Ih
RZxe0LccgWAXLX1sayt2eebdGQzh4ollvYSa5xeYrvG+RY5ugcSHyqzEe1wk
LP3sKm0yitPLbeZ0ic2wdKvZEVfERa5cOKWrbRSxMo1FbaLNaDNl97XUc+G5
ZfuQiN0Yav+6FpkYNCHYxZB9eICLZbsPPeoZHsPz4Pf3h/5p5HGf2Sc+zZtP
08sV59woeGB2vuaqYwP+WzSflxCawsLM0es9DAqeCtzIjbP+hJWBazIt5KfQ
QSoNNfUZh5B8TGGaXj3yu+wFm7Sn4NB8c0fL13E4OBNitWY+wpv0wCMEUyh8
q74lxH8CC0mkTfJ3a2G/wi5fTHwKS7pz9JPaJhBMDqGzNtXCtmOTR30vF/LX
DoYmr6eiNetTn3H0B5jU5tRnP+ZCVDx6Y3wwFZNv9F72Fr2H+LhwQroXz9cG
IzQTiVRIOG0zEyfU4M+pJOsCAy5WB++zf6Y6iczHhHxNXm7NGa48QODx/4QK
M3+Ixyva1v+8TrPeQbF4jdn3TxyI8gVu3NM8iQTqZG8jqwqyT6t718VxULn4
XL1bngYW2+CA+ehbnuf4y5lZcdAcF2hUeJGGtGMq4hlNlTha8KzcUYbnoSI2
x1uqaAjWVKPvelSBPJ3NM6d62bj/b2GPoRgd11JVd/3jUY7iVLVbO9PZuPjj
Y/rfk3TU19xMTVlThueLz0u49mwcuav/Y0MeHZuJJ4/q1ZQikvBgpQ8vr/yJ
Rr2vZ+mguTk/DNlfAu+9ki9e9LIg9w+7snAfA8GxidsKCl/B+YVnX849Fq5+
j69aHc9A7BM/Q7eRF5AQG9bZY8VC1cLSnL/9DCST6k7ELy2A93n+oAAxFsi5
JSNn1Zgoa7JeT65+ikWHoOwd9Uy8P+OZftiPiXzri2J/vj7ClIlYSsgV3jn/
tldVVUzML2msz92Qhkyb9hV7BxkwHzjke6eSiY+thAvFOg9ACBw4mrqTAX6C
kWEFjz8//a+ltBzNhNcZ55/OaXQoqmsq7SxhoprP6urN61lwk38f4TdLQ09f
+PrVxUwkbW3dUuPxCMrcu46PLGnQeRthevw5E/Fd9sYKD3JQL+6jXfNsEvq2
Ix6cXCa+usT8Xt/zGCz9Q6nxv6nQrbXwpj9k4o+NSEKu0hOkPvrO6TxGRWjH
ElUznq88pZYZRHk8RWzYyEWTRxOo34Ejoom856vKhBNePcMEVfZ7FGccd2h1
OXoxTJjOEkLfzOXhwX41o82G42B+N+us5fVpAcLR7ro7n0NiTovYHkpBTjYn
quoyE6eFDpzTCSnAa9kb8u01Yxi/VHxI2ZsJjZ1P1ue/LcRKrzfbQ+d5Hrvu
ffn0WSZs5QItUr8XYem812r+zaOwWz1zTO8kExsK7Pd+1y3GiWK/5HtVI9h8
al3SFwsmfovlN9S4v8RGvfab34SGIfow5OviXiaowwKTcxavcLtSMy7GeBCS
y9j9SduY8NTLyvxIfYUQm0tKwfb9OD3p9jJdg4njK3a47Al7DQ8fRb0Z215U
aRkSVykwkVC5d8BLugQ758oF/X73YKD156CzNBMF73UqrB9Xw3hN3ZBZdg+u
ZVW0FoszcaVBJMTUrg4p/I+Lt+/pwdtmvo9CwrzvyF65cqqqAfrXWUd/9nWD
duc21XWRgZXvm/tZ1c2wcqfpGft2w150j0vLTwZkGEcl/wkhoG7nJk4+Xzds
+lRtt88wsHwpbXS/KBHnDkbY9t/uwjTpP24BzxebloWEvzbsgNj+jYoO0l24
8iDBWoPKQFZDZOQxRzKPi1+anyV3wttF8HnhCAMZuwNdu/w/gya0YkhNohOk
0zfkjfp4frkgVON0rRNCkxHP1kd8xrKUKUIbmYEyvS0asbe6kC2YHESgk6Fk
fJB+gcAA5c2zrKwYXn8TIGK99hAZ077V9yUbGOjY4DeVFdkDFZtYOjWrA/Kv
Hi3WvGfAsvQinAN68eG1r7YpmYQHHn5HAioZmLhqlBHr1gd209rhgYNEEC61
Pzbg+a7lZt/dZcf60eFA8X2W3YYTqRG6i4W8upk1ZZ80HMBOlrLIalIrVv6+
JPf5KQMXHzIEhhUH8VQt944sjxvcR9XRxdkMmOQsmcz4M4iZl/lGTgmNuNec
8PReOgMnk2WfUYaGsMc+8y0howkb2HSv0QgGflaAeFpwBKpBOqcEbzajPKsn
UuscA2oF6buW8Pq3aHfW1gCbFtyXltS6ZMGA0jsT9Q0bRpF62u+/EuFWzJ5p
KarSZ8Ar/n5MR8ko1ji9in6V3YrFgEZrfnle/WWS/A32jqHq0xIL5joCrm91
OGe+SMeKS075IW1juKZKK7kSR0Bjq//WO1Q6lN4rxTaeoODeX5mduqME7N9b
JNJJoIOv8oWIAYUCasXy5njlNjA0zPTlS+hQVrc+TPEcx6qHtv6sQ20Iv7dP
8DQvb6QYjgcnZ8ehYXVki5NLG2p3nenIC6cj29rR2C5sAkKvKF+aedcbSQas
aTc6rmS6iBwQosJ3hij25XAbdOM1C3cdocPicGZU/W0qOpe1msuva0OkULRH
zBY6gqTe1Y9KT0JFrOjvmxECDkjdCuuVo+Pm4Am7ggeT+L3uzLLCGwQoSZwz
2/iXhtVmpV7avL5I/nLdoVxpAmRhpxI+QYPEqObS//JoMAgLuUqJbsXb4Fyf
nlYajI4VqtzQoSOiwVdDb7gFad9LE/Vf06Ate/C9Tykd/9//q/8Byu2M5A==

                  "], {{
                    Rational[-15, 2], (-125)/GoldenRatio}, {
                    Rational[15, 2], 125/GoldenRatio}}], {
                 Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], (-125)/GoldenRatio}, {
                    Rational[-15, 2], (-125)/GoldenRatio}, {
                    Rational[-15, 2], 125/GoldenRatio}, {
                    Rational[15, 2], 125/GoldenRatio}, {
                    Rational[15, 2], (-125)/GoldenRatio}}, {{
                    7.5, -77.25424859373685}, {-7.5, -77.25424859373685}, \
{-7.5, 77.25424859373685}, {7.5, 77.25424859373685}, {
                    7.5, -77.25424859373685}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -77.25424859373685}, 
                    Offset[{4., 0}, {7.5, -77.25424859373685}]}, {{
                    7.5, -38.62712429686842}, 
                    Offset[{4., 0}, {7.5, -38.62712429686842}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 38.62712429686843}, 
                    Offset[{4., 0}, {7.5, 38.62712429686843}]}, {{7.5, 
                    77.25424859373685}, 
                    Offset[{4., 0}, {7.5, 77.25424859373685}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -69.52882373436316}, 
                    Offset[{2.5, 0.}, {7.5, -69.52882373436316}]}, {{
                    7.5, -61.803398874989476`}, 
                    Offset[{2.5, 0.}, {7.5, -61.803398874989476`}]}, {{
                    7.5, -54.077974015615794`}, 
                    Offset[{2.5, 0.}, {7.5, -54.077974015615794`}]}, {{
                    7.5, -46.35254915624211}, 
                    Offset[{2.5, 0.}, {7.5, -46.35254915624211}]}, {{
                    7.5, -46.35254915624211}, 
                    Offset[{2.5, 0.}, {7.5, -46.35254915624211}]}, {{
                    7.5, -30.901699437494738`}, 
                    Offset[{2.5, 0.}, {7.5, -30.901699437494738`}]}, {{
                    7.5, -23.176274578121056`}, 
                    Offset[{2.5, 0.}, {7.5, -23.176274578121056`}]}, {{
                    7.5, -15.450849718747369`}, 
                    Offset[{2.5, 0.}, {7.5, -15.450849718747369`}]}, {{
                    7.5, -15.450849718747369`}, 
                    Offset[{2.5, 0.}, {7.5, -15.450849718747369`}]}, {{
                    7.5, -7.7254248593736845`}, 
                    Offset[{2.5, 0.}, {7.5, -7.7254248593736845`}]}, {{7.5, 
                    7.7254248593736845`}, 
                    Offset[{2.5, 0.}, {7.5, 7.7254248593736845`}]}, {{7.5, 
                    15.450849718747369`}, 
                    Offset[{2.5, 0.}, {7.5, 15.450849718747369`}]}, {{7.5, 
                    15.450849718747369`}, 
                    Offset[{2.5, 0.}, {7.5, 15.450849718747369`}]}, {{7.5, 
                    23.176274578121056`}, 
                    Offset[{2.5, 0.}, {7.5, 23.176274578121056`}]}, {{7.5, 
                    30.901699437494738`}, 
                    Offset[{2.5, 0.}, {7.5, 30.901699437494738`}]}, {{7.5, 
                    46.35254915624211}, 
                    Offset[{2.5, 0.}, {7.5, 46.35254915624211}]}, {{7.5, 
                    46.35254915624211}, 
                    Offset[{2.5, 0.}, {7.5, 46.35254915624211}]}, {{7.5, 
                    54.077974015615794`}, 
                    Offset[{2.5, 0.}, {7.5, 54.077974015615794`}]}, {{7.5, 
                    61.803398874989476`}, 
                    Offset[{2.5, 0.}, {7.5, 61.803398874989476`}]}, {{7.5, 
                    69.52882373436316}, 
                    Offset[{2.5, 0.}, {7.5, 69.52882373436316}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -77.25424859373685}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -38.62712429686842}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 38.62712429686843}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 77.25424859373685}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], ImageSize -> 
                NCache[{Automatic, 250/GoldenRatio}, {
                  Automatic, 154.5084971874737}], BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", 
                 FractionBox["250", "GoldenRatio"]}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 2. The function \
\\!\\(\\*FormBox[FractionBox[RowBox[{InterpretationBox[Cell[\\\"\\\"], \
TextCell[\\\"\\\"]], \\\" \\\", OverscriptBox[\\\"z\\\", \\\"_\\\"]}], \
\\\"z\\\"], TraditionalForm]\\) and the point \
\\!\\(\\*FormBox[InterpretationBox[Cell[TextData[{Cell[BoxData[FormBox[\
SubscriptBox[\\\"z\\\", \\\"0\\\"], TraditionalForm]]], \\\"=0\\\"}]], \
TextCell[Row[List[ExpressionCell[TraditionalForm[Subscript[z, 0]]], \
\\\"=0\\\"]]]], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1889425196,ExpressionUUID->"6d38ef88-bba1-4838-95c3-79d60491ddcd"]
}, {2}]],

Cell[TextData[{
 "Around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "baa01d5a-910d-4348-ac83-6b453d9af1da"],
 ", the plot does not converge on the same color in all directions: the limit \
for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d7be0e9a-f3ec-4a3d-a707-6532bf4709c8"],
 " does not exist."
}], "Text",
 CellID->84757345,ExpressionUUID->"4b53e33a-1128-4eb8-b8a3-19c72788e198"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->304648325,ExpressionUUID->"559a2376-1b23-46e0-bc0e-6f950d667722"],

Cell[TextData[{
 "The limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "0"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", "z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"63375e86-2ac1-4fd0-a8ae-9d6beb1d2d9f"],
 " does not exist:"
}], "SolvedExampleNote",
 CellID->98894829,ExpressionUUID->"a617397d-7e15-48af-8ad7-099ad4b83d82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"z", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->78790704,ExpressionUUID->"29a67ada-1d6d-45a0-8253-957f98c90ed0"],

Cell[BoxData["Indeterminate"], "SolvedExampleOutput",
 CellID->320293485,ExpressionUUID->"b7af90ec-028e-48bb-b687-cdff0f2040b2"]
}, Open  ]],

Cell["Visualize the function around this point:", "SolvedExampleNote",
 CellID->23941712,ExpressionUUID->"371d1dfd-241a-4d23-ac13-3d200c582587"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["496", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[
    PlotRange -> {{-1, 1}, {-1, 1}, {0, 50}}, PlotLegends -> Automatic],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->154742790,ExpressionUUID->"f87e1879-142a-40ec-b6a9-5e58605ca206"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXdcj9///1sqZUSkSDKSkZ2tXi97r8ie2TPzbZP0tsnIHvUWskpGyHqR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      "], {{{
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJy9vWeUVVXatvuNc8ZoI0G721a7CsEcyaFIigGMiCRBzAFzQERAVBREVEBM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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         EdgeForm[None], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnXf8l9P7x9/ztiKbjK80ZEsiO5soI3uvykhWQkJCyMheDVp2ZJOQEdl7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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkrlKREEQRXuc9/oh6jeoGBkaCWYiaD6KoaCZgdsHiIqJYO4XKBiYKhO4
Ie7iLu77juO+DChu51ITHOpWd7/uqluvsKEl0ZzlnCuGALIi5yq9c88x526J
01DBRnXo3CU6xn4JsYm1JeI2FLDXAQ/oXShCD8Mn+hzK0G2cX0UfwWDcuU7W
HtFbUAVJ8i/iKdRztof8Bf0BXYG9qbeniLmQDd/wmqm1lPNv6Flvd9fAFToF
3Xw/wpuT6B/IgXLW9r31pN5S5Gvoi8zeAOfH0DPQHlqPO956VK9pzmyg76Ex
tDdGvXkib9RTnHqviX0xq/nXW4/qVR5vwoo3b3SH7kp7q13fJNET3mqXB3fo
MDJvW8mDyDySV3XkJ+hjyA/NY3n9Dr3kQ+Tj6D3oj5sH8mLZ212akWY1D7WB
zVCzVI/qVWtz6HVvXskTeXPmzXu9sYhe8FaLanhCH3jzUv/QYWZmml0eJCKr
SbVp5jfov8yealSt/2pJaVg=
             "]]}, Annotation[#, "Charting`Private`Tag$239019#1"]& ]]}, {}, {
         GrayLevel[0.82], 
         EdgeForm[None], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxFlltPnVUQhj90r295rtFYymnjptp6iFpKiaCxpaX1FI0FiqXWll290JAG
/kETIEZi4LryBxqhqaaU6g/wllJq8Q94IdfUcu/7dh6yL1Zmvllrzcx6512z
vto3U8OTjxVF8Y/G4xrVsihmNeqVojitMZaKYrWpKK5InpJ9R7Z9kic0lrWh
K2uT5vZLNst2QeO21n8l20XpI1r/juYeyHZIckjfZzV3tSnWH9f4T7YT2Jfk
80gKP7Z/pD0/a+3HktdTrB+W/XyKHB5WYgwSd1X2/hTxfpCsc5Yj2v+bfPdK
TlZiza/6/jJFbMedTvFtvV37xjX+kJ8lzuI81lLEOqM9yynW7KAbn1PkcpI1
rejO8Ykc/p/MYWtljbFtASv7sC/77JK8p/G34l5LgY9zvSP5r8Zfspc5bFny
YBn2G8p/g72jmntN9i3pl6XXJW9pbDbF/Ab+V1LgYkymJMfBZ4X1nrsp2aex
3RS+7PO+9BOZc+c4g/Hyd2cZNRsGh/UU5/0xUZtK4LxBnuaM95tXA+xdhSdr
+PHZtzjjOFi5Rt0pMNrl0TU49kwOHj+bg1PmlnliTPrwY5+TZZzFXL6AvUV7
vpbeKlkzB3bPWwb/nOdEJda4FkPw0v5dC/uZAEtjatx8vzrhsLn6PXPOoYrd
eNfB3HfRdvs3HzrKwGpW+jlyqKbAbpnafUeN3sihvwnn7dN3wH4uoX9bhm4O
mOP2Y57Pp8jbdT7E/e3OYb8IN14vw6/9LKboFUv4r8Oxy5zf+fjOrXLedc6y
yZ1qKxvY7uO+OE6NWOb1HeriWK6j+4NrWGC3T/Psd2JNwefr9AFzyfoAvcU5
doHDGhww/j30CvcMY1wF2x34OkpfHMCn6+x63yBP19z16gO/beJ20otqnNd3
wdxvp89Uqal5O1cGvg/wY77al+39cGMLu+Pupw+/kiMH5zMBht5nbA9qbsF7
JN/NUfu+HBxcpWc+p+8e6XskZ8DZNbWfeXz5HjWDofnuWpnzxmOMulyhh7kW
rdTT+hc57uppyf4cvHsvx11up5d+kAOPozmw/QlMncsQsX5J0Ut9t3uQrsVd
OGNs7WuUuPeotb/bc/jrkOxN0Y9cl2qOWJ05ODsP946Sz7EcnO2C25fw6TO8
TK61HP3CPaFN8jONYemf56jnXNnopQtw9xPNHZb8NAcuxmcoRw/rhg/Oc5Y+
sIcaPS/5EmfYK/kWtXxb8qkcGD2dg2s1etcK+GyCu3N/P8e9r3L3z4HzVTh5
GPuHvMV+kw/AJXPKfJyDq0PkP8K5q+R/nH5ubrzK3gO8g4Pww3FniW3+PHoP
qftMavw7zMDJSd6F+9yRm+B5Hj++s1v0Da/xG2u/5sNecGvO4cdrhnl/H/3r
VCLOWeIOEus2PdzrXQtzcDo1/pUWOeMgb+LJHP2shb50DC4N5Fg/nRr/PIvo
o/RHr3etVuChub2eGj2zmX+eh/yTeX0H76x9tJHzGd6RXnjeyZtivU5ddnW/
y75Ht4jrWLNgahwWwHmbmjbTM/12LFGzFnq49RFycy18lrv4/LOMt9r/L+vY
nafxGAPPF3Lk86Lk/49aOiI=
            "]], 
           Polygon3DBox[CompressedData["
1:eJwlktsqxFEUh9cw/1nOOYYwDpkyjjE5hWIycqZRrrjABbkwTyGlXPMIuHGj
PIAXkPIgPIHv17r46lv/vddea6/9HzyvlG+qzCwHaci72W/K7DIxG8Xb4Ba/
g3Z8FT5YfyVew7vgm/iEuBvfhhk8Czv4JFzhf+yZwpfhK4kzVvBZeKs2O+Pb
HL4EP6nYo721cIw/Qx0+5tFbhWbH8WmPs/MZ6nog15kFfBOeUtHTFr4AF5mo
sYg3Q4G1d+IWj57Vexl28XqP2ofUa8CHwYgfIIePeLhmptnteeQ+Eu/jR+qR
uEj+J3U7deckZqbZ6Q66i2Y04ZGjXOUceMxEs1HP8x5voLfQGR0ePat3vVEr
3g/3+CkM4H1wnY5vWXzQY013GPJ4Q71liT1F3D161cxr8EaPu2tGTXgJXpKY
6Qa+7pGrb1rr8fgXVLMX/wfQpTVT
            "]]}]}, {}, {}}, {
        GrayLevel[0], 
        Line3DBox[CompressedData["
1:eJwl0kkyXWEYBuD/6pt7CeLqqUyFDVwyF21VRpqZgb4LCa4+KCxAs4FkA5oN
iMJQswFGykQzT4lHGTz1voNz/u87zafe8W9jkRDCFu0ZIbz1h/QQ7lJDqNG/
0EOSPY645pl8F9fTwiCb/OEvt/ynKiWEBrqYYYcDLnkkZs5nvnKS5hw79Out
stgeA/ogQwwzwihjjDPBdyaZ4gc/mWaGWZLMMc8CiyyxzAq/WGWNUzsMmb2u
t8m4Hfr0JmqJ8mDvC/bZZppOElTy4rkj7ruRL847lv/kb7nBAM3UkceTd3nF
IbvM0k0j9+Z12KNaT8hz51TplVRQThmllBCnmI8UUUgBH96+F3nEiJJLDtlk
kYkRwerBmGB08DjhLO3933gFqZI47w==
         "]], 
        Line3DBox[CompressedData["
1:eJwl0FdOAkAUQNFBEdfhikhYAguQ7VkA0ViRIgoIdlGKil1UBMST+HFyZyYv
ecksJFOJxUgIIU5iPoRxLIQNfumwxCdttnninAuWeWaPFy555YoVumT5IM81
77zRY8a+I/2hyqz7vkZ0oKvcs0aBHA+k6VMimC1riyJ3RL3NMXRusMuIHQ55
pM43x2xR4YsDbtnkjFNqZLhhnRMmNJnG/v/tD3fVQZE=
         "]], 
        Line3DBox[CompressedData["
1:eJwl0Fs2gmEAQNGvl/5KbqFColKIcqmI3CVCIjMwAAZpYvZaPex13k/p+3fy
EwshjHmLQnjlhSHPPDHgkT4P3HPHLTdcc8UlPS44p8sZp3Ro0+KEY444pEmD
A/aps8cuO9Sosk2FMiW22KTIBgXWWWOVPDmyrLDMEhkWWWCeOWZJM0OKJAki
4vzFQ/jSTz4Y884omn77B8X4Enc=
         "]]}}, VertexNormals -> CompressedData["
1:eJy8vGk41W37/k0REkkkkpJKhYhMGQ4yRSokKVHmlFKSeSxSEY2GSjJGpcGY
8TRlnud5tpZlDaIyJZ51uu/rfn7bf7t/L/7Pi6d337Zra+vSsb5r34/9sx/C
Vk5GtmsYGBhOszAwrGX4zy//LYdz1HqftkB9vtTH67E06BXly5WIjkAW++u6
nqJWOCRUzSh6nQYGh7vbzUkpyGptbOQlYhtUWuwPv3mYBvt+Z1sLPM9Ef1cC
eneutIPFwQyf7B9U2MxjKZwlVoTKFYRlPs51QPc5wZIdcVQQ03kj8zetHNWY
+bBvLOwEptjztDgNKhy9rvwjZ1stej12iH9BtgsMXEnBvB0UaLI45njwYDMy
jU99laPRBXl6TRkOJhTYTEt1ipVoR2E69rFSZZ3w0tli60IpGdbx+uV8vd2N
RHfEfrUL7wCHJGZ/pm1kALEZG9PhfmT0ycx3LKgNLH+K9epenIR93sefaAoN
I7uMU5a00GaQT7jXF/2UBDIq91LviIwi/d8/r/09XAtFOysYFPMmgIc38Lhz
/xiS8+8/ctqlBPw0VZta+onQy/prA7MYAY0yNtSF+KTANXDVGFhHhHMHL9/a
MUNA10P8owPOpSJO12e7g4EAz8fPhoSIEBEX6x4mbbMy1GSnKmv7ZBxknhPY
SwoIaE2nKcOJ/U2of3OdlwXTOHQu25M1K8eR0a5P6zcad6DJyetNszFjkDsn
m3DAZAy961DjjJvqRcvixSaClmNg1nBxy7s7IyjaXJd3wW4IST+q3X7m5Bhc
uE+JfXl5CCVEHwmRcBhBQrwLv3bajEHIQRPFczp9aMT3D0FmfhRd+2rU7BA7
Bus4t+++/bIT/cmyuxvDM47uMDr8oPwZg0WDa8WHZluQmMfOtXLl4+hsUHZS
hMs4GNpcu864VIca3/YVenIR0AnDrYstawmQOrAjojO6HLE9qv6mwUxAXuOz
pzsTCHBUYNsge1cusglzbk35PI5+H1X+OnGSCMvZ20IP7k9Bhxr3dApvH0f1
L3m+vV4hwj9zKw2LCl3nx9DSiloK99cJmNgroeHS8wLuhsQkEbe2wrU3uS4d
92n/+e9bp+s0Djm3wUzFdEeWEQ3kR5jknw+9RP1HbINkGtrhngfI93LTYCzy
xvxAXRoaMDLWIQl3wv2vdle1KqlA2cFz/mHxN2RzmEXhvnkXBNBIfc+uUWGt
q1LPglIpOvpT8e7Rq91w7Nn5ILa1VJBVN6nP2FqNfFKFicIHe2DkYPrepEAK
vK26sY3Vtwm1ntW8ejmgB/Tq9meaT5GBS81KTJHchuz/sqWKKvaA1gvvrc/V
yGC1SeVPWkE3+pZ42GludzckP6r++911Er6ygm5A5QB6GTnBGcfbCdKDdbHu
9LkVDNn9pXp8GLUdyS0YGG+FInOdc+KRExD/QCXYQWkMVfGtMf/C1ggmvB7V
f0OIULJ4+aWOPAEd09Y99mi5DKyTtyg99CJAj/5hnpJPRNQfKHzNbNtHsNl2
6PSA8zjIXw4yMw6YQJZMqmu0eNMQX22xW7zfGJh8CvjI9mYCBd9WedUuWoGe
RFCrBT+NwtVLfp5azBNI9tzpi98dW9Af92WBLyyj8Hati95CBQHdboms/WDU
jfxK0pwPPR0BGcdn6jbLY4hhb5pLhM8gyiQczVhrMAIb2QUS/tSNoDFnou0+
ixHERxjyTVUbgbiS6usVZ4aQgB3PFVHPMVT09be4u+UIPFTPjEe3ehHfyvtL
+hsJqPMUS6fcpxFISvFMfy7egW6T9pdlChOR5rvM4AjhUXDf+makmrkZAfdm
9Z48IrIPvR3/IGsUBmcWA8uOVaFdOdXWb4lE9GUft8d96zGYghdbP4YWoZ6i
VNG6bCJyplzNat49DnE7ktQvvfmIZlXunx2SJ6Jq49fyaTPjsCRcx5tRoa1a
fOmbjK4nAf3rmQA7Aq1jJlNS4Pa4vmBJ6DhanD2wg+sVEQiajqbVMu/g6Kyl
iLR7K7wWuTxMcKa/hxOX08cHo6HII+XCr79tkJX2uJ1FgQaHBL5Wb59RKVoz
evJ5Ev29969nKoQ+9w/xE3qLPI8aFjGIdMHMw5csGW+oMHnxxwr30lfUlqGF
TqV0w+2pl8crj1ChJbvjes2GIrTrUoVINGsvuOuFhlaWUkA99p68CFSgZ11C
3z+I9EFiSvDAG2kKzFAjTUXzGlB+bsdsYEMfsBGGwueDyBB6WTDig0IbOqYY
+2Bdax+kcM1taf02CdYanD78r7tRRShZxWOmF6z9DkT4V5FA66xDXqvJIJJg
uJUUTOmGL9nOL7izJuDliobU9kcjaHrHq+2+IR1wIoh4ZuIOESI0Sxkfq46j
vXc7Pu/KbIYjvh2z+UoEEK7t93gcSEQTlqyZkhMVUPbwc6wNbQx0iUtHhkVJ
yCTwZ9vOnV8gInSCPPlxFMr2JJrIM0yi/tCGHQ3vv6CCI0k6Nx6MgEmQ9umw
PySUJbBpuPpkNXpKqPYReTYMLNrKhKc7SKg8TEEkaaoNGQTzHbdtG4LDN746
ZgQRkXdy6J71EX1IpdYx3tVoCDIbzBcOG4+jbXI/9+UkDqPeb8KbNDmHwIVd
jtqXPYJ6Whn6dziOIW7xLpPXzEOg7Gcc3P11EHHmctaORxCQ/bGAh3qHh0Dj
YfUJ3dJuZHNzun333gnULnxSv/f5ECRySmnfHmxFDRwdD1hESEin3vkHh/Aw
ePVtMT3sVoeWCPV+ua9ISHiIuG5jyzBQp2e/LM6WIJ3r5drscSR0IFP15uu3
I+BzN+jk+qEv6M1Sd3ijJgnZsat5iQeNQtHBteJ73DVVVxbde+ujJtC/nseg
oHHgNL9UGkwUiH3ip78nFtYH3t1Dfz8E77jbSJnIg8krsk4JzwmoyE3A0tSR
AC01DyeXLNPhzumhKzrJrTAQWbRByIIGfBSCVZH3B/hGPVSqZdIOuSEr+2qF
aNAetUmkbOAN9P2m7K0S7ARl1gc7xFqp/3mfx2yOlt403QVLh0eYTrlT4e60
f+F0QAKS5jF39S7vAQuuu83311NhOq+urISUhThK9aeZ/fvgDkMKm0EQBYJn
NBn7rpSi6Fj1OD3GAejk/VOvNkqGn/G7TB/b1qL5Tt5Od75BEPR7Mm4qRIaH
R3/LO8y1IEnRaL9LAYPg79mo/l5qErY48HXJTHehbAktNSJtADSaQ14X85LA
4gGSvnZ1EPGSOIaXWPtBQ0yJ0FhHhPdC2tE2a0dRidAt2at3uqFBZjlPw4wA
Rsr7ssSECKjfpzWzR7INVK035z1oGIPiMybPNb5NoE8LxhzpKjUg8emL+GOl
UeBX3ncl/sEkumFRvvjLNx361bwMj+UPQ11s/zPHS2R0xVCyJYUnA/3MPfne
ynYILv8y3Vx5gIw4hva9K+uoQwmj1LHHkQMQn2CcyjxHQn1bfFny0jvRHa++
HebTfeBU9il3P4WIGsSn5/Q2DKETXQFfHw70gmvh4WvsQP+evqP7+mj8KOLh
CYb7Zr2QZ//u/aZ9I0ju4u+bgYEEdPI+z7v1F3vhC+1Ct2FOPyrT9Tlz4tME
smJ4aLahvxeqZ53MmTd0ohaJO15IdBL9lStItKzqA6aqxNDDz5pQiJV4yigD
GT2IOsusvnkA7h1eFyC/XI6UMsTNP50gozVuqebweRA4T4ROsFVmIFb1Rw+O
i5BRf5rJnecVQ/+ZkyGi78aHEZPoc+E8g1/DMKSRN15glvwKOx+vNd2cT0Kg
GlsnQKR/3v0L9vIUIqgo/1PHlzCBwpYbH+5lHQNlm5qnt/q/Q27TOVnxi0Tk
9G0gpGL/OBBFPfI9CnMht9uCQSWqFc5+trf7o0cD6iVW97jyLLCnLFPCrrVD
DOfKlUwWGrw509JDtf0CLmEOvmM2ndBc8GyaOYcK9yZyisPC4+HE6MH3Y27d
IM5wb1fYGbquGA3L+TGgXKTvzqyh8LL3388UuBuhYGvf9g7l7Rw8dyO7H2aY
d7W+OUGBPjFvtluzeYhFVIWvI3UQCsQ3dWS8JAPzYffIS3UVqKbJgeNr7BDY
2BVN8xVNwjQo9gTRv+/Udycwh/AOw3tlgpX6ZxIkt+jldD/tRGuWz124zDQM
BQrGUZz2E3Dpwv0owe4BJGzD2/rn0BBcSBzx3jhKAFk3Q6VcmVGkt9e85UV9
HzxfOZ5WQv/5kH93HIisIqAgcrPqR4ZOcFruNMw9MQqmIp+lD5WTEJkQlRm2
sQGWmyO6vjgOg0794NZnlWQ0dHyrUopcFgQyvdGzMBoEO9eVkaznFHR09qLF
ydYspPjEcusejT5QZ3ZiTNhGQV3pubddbJvQI7cNJrKt3WAldEt3nfskOrL9
b4VEbg+q9uaTusndBX3s6ft/jRLRoy6K+NzkMGqkfVvpWO4Af5Xscst3Y+iF
d+TZYrr+PB9XGXMvtANmXmcuLbMNo6nOivq4aPrnz0VwH8vHDvg1/Yh1z/Me
RBwvXb8/bRJtspk99elEJ/xS9/QakWpFRWGVTbFLZMTjOueYZ9UFunmPzeYv
VaG3IrK5rHEUdCdk15Nt/d0g7KjAxrcuBwk77yw6lEVBZvzWL3I+9f5nbrnE
xA/3GlHQuzmxtk9V/fBQrJ3fmC8TpHOlu12fkNHyhHysG8cQ7Bnq/2kdWQpD
k0zaY0GT6IH2sYfb9YbhTnzvJ93UapjefO5R4lESkjawVTzzZARarTNPRRk1
wkLObJJoFxExf/77Q7tnFHZtULEerSyGH6q7zYw0WsEdDZb+UqRBQ2X6mPH1
Itig9GzvjGw7JF7Ojr/+kwoCbWfren7kQsXiGLu6SSc8N1XY8oGuK34FFkyl
Z2YAVSn5hWAc/d/jlC03WZ4Kdx4cJfT6JcODn2Z6rRx9cMVWxFkxjwIZH5eH
2XcoFw1/swmMfDjw72cK7Cr/wpRrk4Ya25w/RXoNgdOGUs4JczJMXtNgrSop
RmUfS1obwobh85uD0dqOk0Dyvr4+ya8OiYiecv5uPALrHdLqD6uSIDtR32Te
sB0lUB2u/nk8Avc2TAc9qSLC0QDLx3xX+lGVPHVjwewwaAhOcTYxE8CnNP+c
FNMoiuxacrwpNwQZo2FmC0uj8Jqycomyj4ie3xT2ND7UA5bPAgXuVQ6D0dwd
4e/Rk4iZi5A2eKQZ9ANOz5J3DMJGxV1VZp0UJJl7dkPH+W9Qn2zBH7mB/jn+
21LL84yKXjYlhZgtfEMZjrfKnOI64WeWwiH2EgqSzU2bnYltQd+rjrenMLfD
4C3pNsrjSdQ1l9ERxD6AjvRxn1qr2gqVI/b5X84S0XHNl9UphFFUUPIwIfVI
C7xQqrkY7jqKTMP4XDq/E1GCrkTAqzG6ry1YI3oofAD1DsnZpb+eRDcPpai9
2dMCGxi0lfn3dqBLyZLPTX0p6NVi3LMt5BYojVuxPyhdh7h7G3eLhVBRY+ft
E2N72gCRVtL6U/NQoeEWWTsiFW3hGm1ermr/z9wm+DQleGdR0XD81vz2yk7Q
EV5grTDMAd+nPnfCN1ORvkdL9U+eHnD37Oxgff0dfhdaJE0JUBDftPqYcFwf
XI68zn59qB6Gz/fc/jI0iTi7WCn7zAbhDee+VwKaLeBXWnMg0pWE8vovxAtu
HYZr800R3R1tEBx+NHWWTEQqDX5lN++NAGlFeq9gVznwz+pXlsW0gI6n+lcH
MRrslqx8klpZBhv1tLiM4tuAU33eMXiECmd38YlL8pZCD4/pT/PBDuDY5D8/
85AKom288R38CCrfdqY9P9MNV98ZJn3bSQXhcMOV2q4cGOr5Uy7E2Adn/Nfm
+ryhQMCv3YavfT+Ad9jL8JX2AVBDk3k/l8hgqCN6S1JarMjQM9tyff/Qv5/J
sHPr4FFhg3S0cGnPQpPKCOxzsnjPd2gSzhzWLgvb8B39OH/u3qzlKEzW1s4+
IE1A9lGNC7F/mpF8sZWwFtMYGFimM7/QI8LO32D5sr8HOaX8DGEsGwW/eMvI
7mPj8L5ue+ca4xHkFHBDlCQ+Ap3GI0QaaQQkgqS4H+0homEHfkWbxn4Q9X1S
VXWKridlLL8J0nXCZyuS8pOaVsjROs523KkXGu47UcXSqYhzwmVPG3sBLFw8
vutuTQfs3XXAUs2EhnabVvDVJhcg4dRLhOWNrfAq1hQ4N1GRnhyL4lmJdkRo
64o+c7EJFB9U7faQmkTnl7JOaPcPoef1PTNZBvVQ3e5gck2KgNb+jZLgYySg
FY0zPnOPaqEw/Feg3PNh5LkxOyygj4T+fjD+8UeiFkQbyU3ykd1oJkXGWNib
gi46qaoszdWC+rNP7VynmtCv8KvxPGw0JOXc1ralvB7MXJuvG7YXoQzpHm3v
bBqS7IuZMFJqglbW+5dU/hqqDpdPLOdl0dC/npthmHv/3HVyHuwahjmaFA1d
XBwon9jeBlwhAZlBP6pAQbJ6U4wuFTVFeO5SfdoBEQezf/lDM3C8VrwayU9B
HObnT2Tp07/P25UGOLe3g6zADa2SzEkU8a3yXqtyH9gzhuhK7uyCyeWNW0YO
kFC+5tsap1ODkMaX+0H8fA/UFm9O3/6AiNT96jd3yw9DL9Fow+bfVdAHW0ll
sc2QUJcSErGDBgX1I0tPbldBok2405t3rVDTk/X4XDsVjmQb5G6zrwQ3m6K5
1B/tcNA5eM91byqkPR0OVor4DsJ/CxhC/bqgfJ7CMMFFhROht3JeF5UCpa5g
auFMLxRHiX6/8IgCPboc0ns2FMLG9U+TQp0GoNu70Ut8kgycR6dZCLQvoHC8
+MwcfZ51n7wt8BEkw3OBj5cZePWKGvbqD8k+HPn38yS8/37sWv6mHPQo2e/q
Xt4xGO9+uZkZTYCg7t4rrYU1yKpYQOSF3Dj81EulpTMSQaLJ82oysQN5/NCd
E/MYB9tuxhLVyjEY5E721J8fQptEVEoewBjEhPLDdc4RiH99M/7CawKadei7
qfV7CBqS+cSX1wyALCmv3s6GjCo9H/1839oBw9/8xBR/dsK1Zhl1iTM0tIe2
P2gSimFAJWH6cEYLdMub/PzeT0PX9iY38D0oRm+mvhXdv1kPB2flJq6soaKy
zCC/T+JdCCICkuq3V8GdgrbXH9TovtJlrsb/xwj6qvT8Refa73D/dZlf2qkx
ZCR+8/R+5QnkYL0yN5BYBq8OrpPcVNaPstz3ag0RyKiAdXPJ4usy+Hlw1ol1
qQXJZM3pxAnR0KM0EcNXH8ohsbBYspRYgsyo+m3J4lPoeWvAvO6HCij60JTX
fU9XdWvjR/+bZlPoX8/V4MT4uFKQDcEeES7rzZM0NKQa8DhMqh563f0C1r+v
gxavidslrDR0LEWspau+CYqXYrRrqlohaNCET7SHghiumX1df6EV5lh9g35J
d8H3Smv3265k1OHBWP5cvgPmyXKs0qm94L6hcuYNjYSmhniv6xh2g5juoxOa
agPg8FDZmvvUBFIXuLm0J6IPNhz4q6y0bggspdlvFcQRkM1Uzo7zPwZh8UJb
svRKHZA4j73212yCNaa1xAdbaDBzOk1vz7Z66NhrEqyl2gItYSxbFmupsNfV
fuBUSR18c9zxONS3DXZnqJpq3KKC9osxa6+SWjibqnzRj6MTHMu25tWyUkHj
t1NeT3c1OMT90JWc6Qb3QfWesGAKSDG7svt8qYD8sqjOS1L9QHLaLXRyggwf
V576vagpAX3NKY21VkPw9l3OHOwkg5xsaPxzpixYDnrJ8Pf4CMSKtslt3DEJ
DW0XeI9EHy2KP/CbGq84BkXbmm+eqJuAhaMdU3nXClGCh/2ejeRx6CgJVyIw
E6G60ivRWq4ZoSgJf98RAtzbJSQrmjQGLHw8wW3X+1Hd/qEYkiEBciyHg7pf
DINsKve+5PPj6N6+HbpiOqNwvyjVKnpdHxxq62rvliKjL2Oepm13eiDyu2C6
3FAbBPQT1EKLaeh4dZSNF1sZSFVdyTjeWQ/mtRUrD+hzM/JOxe2MfhnS19Nr
CQ74Tp+TkGCDexTEf4zSVNLYi15oxCx98iwGrgapQ+mviWiwaNNdJsNxJGlc
7C5Rnw9xv5h2rr03jJg4DQ9WP5tEL6eVDjEw5cHC1tjdXfYdaHRbA/emGiqK
Rsq5gkl5dP1uN65L//5yOuFhcvL8FGrcykM7f6gQKiZ8vSo366oe8xtVaM2d
QpKvjI16coph6OpeqsxiCXRbtz4o059Crn1PrnMmlcGa180cH7ybQFV65gaX
OQ2RXIY4CswqYUb5QCXEdYDA7FvWCkH651Kl7urvjlpg0Tu3RHrSC6cuGbf0
fSAjz8SUbe73mmA+h7pno/Mg/FU292MWmkRuciXla11bgXzT/ftTyWHY8mva
2MhvAq3fE9wWTNf5MWTTs2UKIzBm07stppOAbm1QexLN1wPG9SoJxwZHQDl6
/HOT+Djy2fbrecPbfjhRjpifODSBySf76W1b6PN7LfHADi4aqE6JXXStaALi
7UcJz6yb4FnT+izxCipwzRfSeOeagGzfc8vzbgscf3PYhs+JCjPrGcekCU2g
kC2dfeZ3G8jGFNYSWKhQTWb1VHRtgm7ui9a65Z0wz7RicieUAnsv9aTe/dMA
58kV5HV/eqBkdp0nbZYMYW7Ppz8E1sINfX6addwApMutlBJUyODbpW6gPPwd
8uKzP+maDYPTxiQ7E6NJoPifXMeunQde8T9O+j8ZhcX5Kjn2bSSwsizlMtA7
UdTeo935p2YcTmY23Eq+ToRyh4c9ZTxlKJX9oOn4ayJQfTbJ6HGNQ7nOmP6x
0A5EeXc0cNf2CRgoO3EjopT+/bWLes2eYxS9NzTY+rVtHM5PcUds3t8LGnv3
JsTaTKI9+e+/7982COLr3rEE+rbAWH7Vsc+/aOiy+sPbThkVIL4skOS/vxJu
1ZOO3tWaQh5rY19n0SrQuiv39m3jK4QG7da0bC8yKtv09xu79BDSYU7xjJPJ
hJRLK+uuroyhOPmI22c2TqDeO8kVwde+wGBnz+hOzl6knl1qKDhFQTnHRVmk
9D+DC9+wTrxeNWp8+9LiAn0OLXQfH/nc8wWKd5xlnBY0Ua2xv8HfTJxCzu97
P8y8ywBlrhiXIb7vcFQ3fP7x1SnULnh4oOVnDhiJ8jfqbWsFV45MeUUDGtqu
Y2iuW0L/e8aW3gqnv49yqBHX6ocpqOh9WeDuR6WQaUuz2X1uEH4Z9xWG65NR
0+yxe92MlcB4LZAt7vsw7K2a6b2XQkKFEzn27UfqINvm7Rc3s1FoOqTiWMw4
gaItztYE8zaD8JDZvRHfMVjLJeRebk5ABuvOmZ0yb4MNNo8cVZXH4cb61F2b
EP3nwZeWsWO0E/plT+64FTMOl2fKLNRER9GKc0O60eNeSK+Wy5+n+wPHHf7z
W2lVYHLocxLDBhrwXuK2O9HQAn+lvwi5yNZBei7HG5syKrwt6o5+eq4ViIsu
nbGMTfBgQ9IONvo8W+9StBHKbgXLiR/eovIt0OdbY9WzgQpm8+VWi3R9+Uxf
7dPpqjYIU5j12POSAqyvD/BWubTC8Jqdsh/KOuGxDpvL5s0UiBCwiPnh3wL+
x2qvlCv0wt7m7+EhN8kgr6UlmpPUBAXhlKs5coNg9+3ActP7SThmlmVTOlED
OTvmYm6PDkNmU6SI/3sS2L6OjhwOKIYSLrpnuDYGj/27e3yOTcDLAz5mjTdO
Fy2MuyhFshBBaEP45Sp5AqjmjmYMmFcj770cv+zmJ+DrmYAljj8jsCXPW83m
xADKmmbie3NuAr6ZTrFI2NB97eaam0mJE8gmymbRy2sEqv33E4LONANLQc2R
IxQaIp52K3jZVgvv1aLuqL0qgcChI5fv75lCKXP+zAdZ61CA/vwig/dXELGQ
8JZ4TkLMtjlKuyRHEe8f+9PxLYnAoeXFHTs+hMLgiM+YKBktX2mQ9XN8Cyw3
6p/m+TQiEvUnX/kKDf2UbDhfHPUW7ubXhDRHmara2am8nFmgv4et2p1c0hLA
R0RIrcKgGrx/u0j/Pj2FSgjCBcgwFTwE0/bnenbA29HliAOjVJRubPb0T8MX
sFzLI/2YYQBIyrYKwTspyMwuu+6TTTa0Hs7MCBwYBuY0Od4W3Ul0S4TfwiSw
EBIfM3dosI/BhgV5HQ+vCbRyliPYYEcZuORf8/v7fhxOj7Azni0moI+J29hc
9argnaPPTeggALMAm0a4wDi63uowZ3ikAUY43BaW6e8XtjsPm1zujyJKlJ3f
pGMLaBrObPnKNgETcy9aNFlGkKTpes3Pazvgp+uj639FJuCkVsb1tOdDaCiY
z6a5phu07DZc7o1vhaLGWsU64XJ4eLbvSjobDX7/ro08E9YGxDZtRc+eChA9
5erUVkqFddkHUuautEMMl9M6Y5YauLl9ur7yJhUa5vW6kg90wBEh9xSfwnr4
vF0j5A4vFZg/XKvdndsBO+fIob3rm0HsA6lhTRoF9p8Nbn280AH+JwctHSJa
gXkiIUBangItPkPwrbQDGtg7+vfT/YOCgnbLzXQybGt65KXd3Q4ZKVvO1m7q
AfUDi5UK28gQ+k1UMHC8FXSQ9e0DEgMAGaLpjpcnISBj2kbQoglqwkrU+AKG
wYPzjPxoAAl2vdlQz/u+HKzziXevnR2DY5cTtTj2TcCRRyfmj940LSL7aB+x
8SWCzL7WhDV543AwJFDF8lUzEjRuaTyaRgI/NGx3fWYIXqnJJWbxjiO+u2v4
okQIUDe0/EKM0ALvf8cTzofSULNy74vB5maI2p+UsJGVrhN0Yx3nMmgoslCK
9c9EM/pS+qIklTUOGJgWbJa4CGheSyrZSYyIrqoqoqk74fBrkwrZsKQNfX/s
PRepSUMX3s+Z77Z9AAaLk61uMxdV313qm9u+MoXMPtt8s9wUBvnKb04o+TdC
MmOO3ZE1U0j79LhVk9oLGM5MeV/F1wsnRNQfOC1QUOvBcxbXP8VCefu9xaio
YbCNFRZd+DyJVPcdkBkPfAf8Qg2CVnfGQPEVp3+q+wSqfxRDZln7FfwPbQ4L
jyXAguKBk/pOBBRwPtJjpSUHjgn07BOi//wyRm7am0WNoQtGThaWe4qhUthZ
Z1yVRNeFpFmxqRHEUv0hYkzhO+xe6X36bp4E7KcE3og4DiON+RCJi9trIeG+
vIWI5SSkWcvIuLMMoYudbsZzg02Q3sHd3OI7CYXep62JLv3o97DFRUn/NjhN
5r7ac2YSXuWdZhNg6EWdYy/ONJl2wXPSxAbBpja4qF7WqhVRCDVWoeeTWGkQ
f67sAPdMO8hfdm80aC+G2D77/lD6+3mkct+rRa5O0KjybWpSKAOf9yUfym9T
QTHwl0qicBdo7V4oM1pXAecb5+5q76C/nx31ecM2d4MGw0OOY4bVwBF/ZLGk
mAIq703Fixq6oRP1aJMk66HiYC3johkFnPt10rKlesBxK2f7tf4muB9VwCn6
iwy2V5HDQdYesPO/X7LrXitQwiv1doaRgZG6+8uWjd3g+6ZX2i62A977FHWG
SZLB9G+6/86RDvg7PN7rpEDXW72nlud7JsGhQdKJY7oFRhlL0oRuDgDj1b8r
zQGT8JtXYkXhThXYXzyu8ov+HsovCxb+00qC5s6YF9taLYrilNmW9AvG4e2X
05Va3kRQFaOkznztQY0fbedb1pFAX7vfLDuuHx4q/sh0ukxFD5d3s6YHdMH6
2fcxRWzf4J3iVrnbD6hIaXqBRz6mC33jy9peXBwI330+zG0WGkBTQp9OyihT
UPOAwa2BOAf4c5DhRIuzvSovk23lL/rcXk7o5bSouwIWanMTiSVt8P74r3gu
LRrq5WTYIyHtBrOS1abRxCGo0VRazy1GRqonjxc+ZbgHy1t4L/qy0f/el9xG
hwQmUNuTzV3bl5/BNcNq4tlCIgRVs6f6XB9H4S9kGrUm3sJTKZun6Y9J8Pae
668g8VH0RuRo7f2093B/2YnQ2zIJEyupup1awygvy46FqTUDJral7mD6QoZz
Z3g9ZA0G0cb5bUUqzAWgvfBHe48aBUT6MgI+B/Uh3sjzfnxLpWDcUPYKwilw
0bx78xxXD3LqzA1obqoChVyrixrxFOjwZXZ61NeJOhOlCi84NUICm/0uW08K
jHr3u3J1tSPW7IF6PbqvLPPvHU3jo0DCp5Xw/LlWtLNPTKcPOmE6zisx4W07
BGn+vfOaLx3sNnLPnKTPM4fvmynSRAf0bDu+cPVNJlSx+s0mllNh6EX0UTe5
LkBbErXcXuRA6w25MDcP+nu4bS0Hm383PK2971a6KR9IP5T3hotSQXBggGiT
0wOTG7ZO6IkhKLQRTZ1vooBXYgfiqOwFIYEFEvNyCTRzeNTXelDg1+4W64qw
PmB3edN9taEcOLp35uvup0CZ+54u4YE+SBzXcbrJWQWKfqoJF8n09/alTtUD
jn2wpnx/0tHsWnC7UXzKpIUMOznz9h2v64Ev6dTrpi8aQVHdkd1hjgxcnp49
9g6dwMFf2MwR3gxv/TatuXKbAlaZugw7MptBz4OXJy+iBbbUGxTtN6CCfeJf
pt+VZXDfS/bt7ZAWkJk1f/VBkQbumhoSFw6aFbkFFaQJn+qAU0WSSGqZCkdO
f5QoYCYhn4bD2/XLRyDPTKTwJlstHLzvIBQdTUIhItN8MjKjqFmkjs/ohtY/
+9v/49eP//X3ZypSPRI3EYBpX8OOneJEdOE+qcl9oyXwkg/d9o4mgfP8K9ft
9D9fuaNx01Ehd7C3vh/J/4RMf69cZ0hWHUKC5btvcMqFgIA/z7RsCQVO7uJX
OcjWh9yl5N5u3fgSNLdGBaA7VBjvPB8ZG9mFfJwXf9RIJMNQr/Dc0xUqrB89
piLU247Yme58kz/5Fbwi/rBYHqfBvb1OxRaxrcgo2eh4pE4u9PbbsCtep8Ge
nVcHjxc3IxGe6JNhwSXQFhp29JkDDYxUTZbO7m5Cr23CN288WQmJ0sa8Mko0
UL7D633QuR49WuZq/EKoB5NZDmfVQSrkbcyVDRqpQV/E7Dx9o1tA/5zVQy4j
KnTwmRsLBlchA6moB3J3O6DryjlvDfYOGDWZzrt9Pgoa9MgD6vR5htLAj3r2
nYBinkuFVLyC75KaDDbfqXDn9+Nzw3VdkJ9qaxJRGwudgjqJ77yoUDSo+emr
TA9MOdxs4NSIh/JeyVAdcSoUWIp89gjrBbYh30gO9iRge0Xg29xDgd/8hTEe
VX3g7aEsrXkyBY57NfU5PaTAV53D2w+U9MPo2mOxS/wf4aRB2tthbboOCTso
+0ZzANSGEi6zy38BDlJDxdEdFBjJ9u20+NsPap8vS6c8ToeBVz3VgeIUGMq+
9qn+fB983POKe0dtJoTFqVCoTygQf+qItpVTF3xoChHr+psFXDUWoknOVDja
+PNbtFAzKOUyOrMuZMCFvUsfH+fTgMn2T8V0VgGw3HL8+ZPyDu7WTbeeKpuC
uQ1Om1/8vAc71h37+lkuAGxsDRSkV6bAcN5vdkWiunBA2G9wV50Y3JKn/lyh
//7/7dz+3/6+bq6HsrDCFGTU5b6a3FqHYvZt6FAMvwFfRPQV1TymwPTFWdtk
nkp0S9KQc6IwCPZ5tq6kxkyBwyb5/gtPy9DfmtNpZ4MjoGA8TELr6xQsH+Mf
tlksRkc8UvlOb0wEGYfO2ss59P+/l5dvG/8qRIP7bhoe2foFVi7EVqz7TP/z
i4O9TpXkoUuBwoxV0zlwevz4Lc3nU/B6r+39G9u/IXIy04HLTcUQuVn5wQXL
KSBfJWuvGcxCG+bFRGLDKmDp9EbZGxun4JbrD7XNpAyU+oJkpSNSD0PVFy7f
j6RBqdqC8jHRdJSqPX9BSKEF9sldudP8kwqJD6+5hYV8QbJMip9Dd3eA36ld
q/PcuHHfRbfzUUhT/u3qPGuxHE3F89xy8YMjfZ6RrkLP6jz3LnlcwPPM0Kzk
HVkbi+rlzRLwPG/V4szB8yw+uei1USMeje6peYDn2SOsJRPP8y71EQp9nlFd
v/4WPM8Gn3e+xfOsdMq7jz7PaEk/qRfPs7T77m14niuu89z6y/8RqafZrs5z
0Bm/w3ien778UEafZ8QkKL46z537KC14nmP3CX+jzzOySP66Os9b5W6tzvPV
J86f6POMhp+5TuJ5/pv9QQvP89gB5gb6PCMrlsg9eJ6Z9u1cnecr1ICNbAsZ
6MUh/w94nv38KlbnueUkZ8Mvyjt0oO/E6jzrc6Vw43nmdq5t+yIXgLjjtFfn
uTTEe3ZFrrqwg/esv0SdGJI/+P/PPBMF78ngeX50bOAIeWsdlFxY14zn2emd
sTSe5w+zF/7S5xlC17Cx4XlWzHu4iOf5gd2QrfnTMuhmCE/B86z423U/nueq
3FdmtovFYLlOhwfP88i0UzWe50s3RvjO/CqE5BANIzzPJJ+n5XieBWjnBQ1K
8uBmPuefSvo8Xwsj3sTz/G0xfoY+zxDfVSyB53mxkRiM5zn97Eo/fZ5BoWyX
IJ7n701IBs+z7eGlbPo8g9kDfls8zzKGJHs8zzwtHNX0eQbVeO2zeJ5VS4oC
8DyXs8Q10ucZcjTyPuF5dt708B3WG1eNXD7T9QZS3SAwjfUGWZIyj/XG81+i
Mo5vMtFBT55fWG84nmtTx3rj1iWDGLreQKVntR9hvbHy+Qc71hvrDzr10fUG
qrNYswfrjXXvGYex3ji97r7UcTGEDmkHreoNHbXEEqw3Lgpd37BuuQTN7vpY
i/VG80WLS1hv3L6axeXYUI7mP9zOxXoDKYav6g1+9bBEut5ArJmab7HeuP2W
6QjWGxZjziS63kCfg/P1sd64adu3C+sNp5lviK430LGtO1mw3oin2HdivaFe
+WSFrjeQVWDcHwe63kj4k74kRNcbd7YKGdD1BtJnPZuF9Uaoic3SL7reWHPo
7iJdb6DH6wYeYb3x5H4GJ9YbQh+2WO861YHOpbjGYL1haGY6l0/XG1u6p6/Q
9QaaH9S4g/WGSduDOqw33q2tkJSWGQUjn7bU/y96IymtPATrjSpKOCddb4Bx
2MQA1hvxGUmrekPrLSPWGyD9fBsX1hu3+OeeYr3xuEuSla43gHaXbIP1Btnl
IgnrjbMTxRfoegOSL2tHYL1xIeWlB9YbEsaokK43QEyXn4b1Rtn49BTWG9Hn
R23oegOS2V5nYb0hbWe3cgnrDZb633S9ATZyddpYb7TwfWDCekNYtoFTv7gZ
ooVcdbHeaMyIUsN6ozxs/XrT3U3g9j1oC9YbDHu38WC9Ia0v+oKuN+Djwr4a
rDekKu7fwnpDaPekAl1vwDnjQiesNyQVAoKx3rAU+3KXrjfgiUdmCNYbxMLw
jdgP2sbpbNeOKETWW36bYj/Ywop2Yj/IyVHTSfeDSFHz9wD2gy0LZTHYD475
fx2n+0HkXW75HvtBtZpkRewH76t+J9L9IFIfPLDqB19JS/JgP2hbc2A/3Q+i
xoif89gP6llW7MF+MFw46BbdD6J3dlcYsB8sqnJLxn5Q2aFkku4HUfbhjRzY
D25hULLCfjDvystuuh9Ebs/1jmE/yG21PQ37wVjNwZN0P4h0lGNasB808Gr1
wH5QXH5wke4HUdZh+XnsB1mY42yxHzwsK9dD94Mou5/2C/vB1DdNU9gPFsi7
mdL9IMrclrgR+8GfNdHXsR983CkqeKJgHMmg6FTsBztEHPywH/QN7NnUuo6E
Gv32i2M/6F5ilov94NfS3JmvAV3ojc7CW+wHhZQqzmA/+FBl3FsupgtctvbI
YD+oIHk5l4fuB58Ur91G94PQ4SazdZDuB99zqfQ7vbZTNQ20wX4QLJtt3mE/
aM2bIJJE94PPMsai6H4QdrrP2GA/GJkW5Ij94Fnpmb+bxMiw9sKfDuwHIy7V
2WI/+M0kup/uB6HPL2kQ+0GNjwWT2A9m1lcm0f0gHCfoNWA/yCr38hH2g2uE
hhbpfhCK649WYD/oRvTrx37wj8Xjs3Q/CGUyeuuwHyQaE7ZjP/j641o/uh+E
6cQrZdgPtk5EamI/eOCURAjdD0JX8NlVPxj6RPsl9oO70l8J0v0gdD8xdcd+
0LuszRT7wd+2PY/pfhA+3V/Own4wvOLhDuwHRYTUH9P9IBys4ijFflB2hXEA
+0FRq/Mf6H4QSi//PI794DriMRu8r1MybDhWJ1yO8ru6Vvd1c/kWq/u62cZP
Op49FShVrOs63tcN3FL4ivd1RBK/gDFLDTJ1la3F+zqCNFMz3tfVXdIu8ims
R5Rj6qv7ugoDqTq8r4vbPp7Qu74ZbdY/V4v3dckih5vxvm5cneO2Q0QrMp+q
8sX7us6jFBW8r2O84Ene/7QDKfuNN+J9XTBfnjve1zmEsF+u3dSDTuu5l+N9
nXbz+q14X+dSKxtyQGIAMSimf8T7uo52r0t4X6fzjHqcL2AYGTyxlML7urIp
WiXe13XtvBd+7ewY+lQurIz3dcFcSWFlg+ZFmzxqtW18icjKXzcC7+vWvluQ
wfu6DM1DXUfTSEjaKe0C3tcpeR2Px/s6tjN7+KNECKi18OFzvK8b+vhjEu/r
dI4yuw82NyMdC553eF/3I77QFe/rpLbnlS5ONEOpJrEC7+t+M3i+xfu6t/4+
15zEiOB2y3fzjzvh4Jbkp2JU0oaE9M1JkZo0SHRMKsH7ulvynQcrSZdUDWI7
8L4Ovuy3ErDaFAaf457dx/u6J0+nrY6soesCV7dQvK8LRFsL8b7O9etEoNMC
BTQtvP3wvm7kzdya6KhhqM65L7zweRKYDbyU8b7u3qWFnXhfd//ePe9U9wnY
2MQ9hfd1e78FP8X7Op+2dF19JwKQ8te4431dt5KSGN7XGXNP2JhFjUHad51z
eF83oJynjvd1gcrhy2JTI/Dol9Hqvu7xpYHQ1X3docR3Io7D8LxNTxTv6wIT
Ws3xvi7a6c1hd5Yh2M4dZIj3deb2+U14X/fms5890aUf2NbvNsP7uqz8dDu8
r3tEERIRYOiFjQWk43hf56cmX4jzlPXHPx7gp1Uhx5LKeJyn1DNH2uI8ZbC/
S9xFtg7x+uvF4DxF9uTka5ynBOW+7YllbEL7UZYQzlOEWO854DxlSeTdA1H5
FvThEOEizlMqWJ7Y4DzFyv5z3umqNpTgYOOG85Tw6os8OE8R3SCh9KGsEznF
jDnjPGXp7PYonKfY92p4lCv0Iqn2TY9wnnJnj+1+nKc8sr7vmSM3iJK8whdw
nrKyrsgS5yk6r74m3x4dRv3SmdtxnmKjyf0S5ymibitawdfG0PrFR+04T3FN
uNlkxGFUtL+zUS2ShYiOMq2xxnmKdovVJ5yn5E8Hz9nNT6AiIet5nKfctpMF
nKeUiJfjPAW9SS1Yh/MUouxFN5ynDCd0T3t5jaDKru5JnKeU7NVQwXlKMZ9G
+Mu2WmSS+zYQ5ykJG+odcZ5ilDOaIcFaB2vfH/mL85Ri9YuvcZ5SK5nGtUty
FI6s3XMd5ynNjIVKOE8RnrltPSZKBprQZQucp2zdnziF85R3m+c2la/QIOX4
hWCcpzzXqy/CeUq87m6cp0CqUmIUzlN2RoXp4zxF/1XWod+np8A6fHwY5yle
d/MB5yk3uTOfHhilwgvD7nicpzzlPqCG85QT7S6Hg3dS4EysfS/OU8wc1xbi
PGWEKZezRXcS7kRY2uM8ZTOHQRfOU/J9lbU8vCbgQZ/yA5yn7LJlvIfzlDw2
mT8mxQSQv9O/5r/kKfBPnsLY6zCH85R4DmhzuT8KPnGHPXGe8vFKKA/OU1qV
Jts0WUaA8eaINs5TDn6PuInzlHCDSzhPAYn8sHM4TzlsEr742IGuY3gEWAW3
1KN+5rrVvBuNa53BebdrnmnMM+smtPWiXg7OuwvWryfjvFs/I8DN824LMhU5
sJp319sMdeO8my1DJOfM7zZ01JG9HufdjJZpfjjvFtQlX9Ut70RHLtkb47yb
eYXxM867tTTEptf96UFViRbuOO9uOWg1ifNuH47N09ZxA6jMNmY1774o0HwC
590BcWYZumbD6IhPljXOu3l3mXPhvJu/v9rQ/8ko0vSyO4zzbpU5GifOu/dP
dnX9qRlHNd9NnXHebdJh2Y3z7sxNlufGXxPRFoGaQzjvvmxNPI3z7pq8K3d2
bZ9AmmXPV/NumvLNWzjvvtTEselr2zjq/DMVg/NuS5ULqTjvNmdnS9u/bRAN
0WI5cN7dSvDQw3l3+oHKk04ZFcgVkZJx3l3u80cT592Pif3Xs2gV0Cl66wDO
u6smrxfjvFuBSTyaXXoIPohN38N5t3+uwm6cd7+SbTE7s3ECqilCgzjvNrzm
yyXM2YtePduiIzhFgZELhoDz7qicNU447/509cKFC/pTMJiqfh7n3aW75oRw
3q10VxLn3eCy5lAFzruR2dcnOO8++2fd3OOrU7Amz3Ee5915gwajOO9eeLnj
sKIBDcK/rnHDeXf37N27OO/ONMt3qB+mwJR7dijOu30YjG7jvHv/86Jv4fpk
iArhC8N59+xiPBPOu+8Z8w3eSyHBHj6Jqzjv5vqSn4HzbrtLzy4XM05AvlpP
E867PUp4H+K8W698v2u5OQE8W2nGOO/mT/G3xHn3JvMYyU1oDMh1s2n/Je+G
f/Lu56oa7zCPdMa5LMpfswlV2apOYB7pZ9mcLOaRHj5MCNRSbUEhtEw+zCMx
VlRPYx4p7pxKdKhvG5Jv9ziDeSRZ59OrPJKrvK2VH0cnavzhn4t5pPfD9xDm
kdyeRRhJznQj828MXZhHes+VyYR5JL3ZIcwjoRVXh1UeyfPm0aBVHmncQHut
1RAi1rPPYh7J12xtJeaRBEbKmf4eH0EXem7J/BceCf3DIx2ycD6Qf60QXT9/
SmQjeRwd8bZSxjyShF3NG8wjBbKz+vmOEBCL/jN5zCNx56s9wDySYTvXS5Ih
Ae21aXiAeaSGGUtxzCN9Jbqoi+nQPy+qb65gHkkqcXMP5pGYWas02u70IM2Q
C9mYR7rkUqaOeSRSYdRxL7Yy9NBnXxbmkfyf7GN8KD6FphdvG53RLwPBc6qt
mEfK2nT6GeaRckU+xJY09sLgxdY1nz2LwWlpvSbmkeTPfb3GZDgOsw+XH2Me
6XVMiBzmke66TQpVP5sENUm+M5hHMqfd08U80tATNfZNNVQQldo5jnkk+a73
NMwjPStzOXPy/BTc23SC3+xQIXi5Ntn25BioCigC5pH+/VwMdr7rGQ4vlsCi
t8n9MvrnwstT7i7mkQ4KRO3HPJKhoKcjlzkNDrlfFsQ80kWVq1WYR9o6p8lS
IUiF7hVXX8wjrf9uvXHySS9s1Y+t6/tAfx8FCu3CPJLR5Lm9mEd6t3aTL7PQ
JFxuYKvFPNIjw4x8zCNVCkWeM/KbgBtk7gHMI4mZlZhhHul43GH+mE4CiGQr
hGEeSaY+LRLzSENyj4qbxMfBa2v9HcwjDb+V34Z50eQR2fGy2GbE0OSyyova
uCdQMS/6IqPY9c27VnQp6uQqL7r7ct5XzIt2Sh/5k/qjHT0iqK/yohzBG2Mw
L2rQy4p5UdSkxrfKi3b+5inHvOjibfb5hTO9aGgiqRTzonoU4MO86C4pSAh1
GkCxUsPemBfNsnHdhXnRc6d6Teb6h5C58qf8/5cXPfIPL4r+4UXfOPa6Y160
T+2c417eMSQpgLgxL5pT8MAS86KjX3iFX8iNoxXpvdOYF01ON7uFedHtpo9+
iHmMI96Tdd8xLzqc3uSPedEijwvfHsAYYnA+qoF5UaYt48mYF02adrii9XsI
8RfckcS8aPZYWCPmRW/08JPet9LnaHyrBOZF22VGVnnR570yzpNQjBiPm6zy
ohtOFv7CvGhjT2wK34Ni+JwVWoB50aPaRBrmRde8sDf/JN4FVxOfpmFeVCnR
6hPmRXnXZ6T7/xiBb9YM8ZgXla/e/hzzole476jvV56Az7dOsg0mlsG0z3tj
zIveFDlwZIhAhh9iyR2YF9UUUgjCvKi4ppVGnBANLiuTrmFelI1//W7Mi15U
utGaLD4FT07k8eh9qIAtt5otRPacVqXQ7P1umk1BNa2kFfOijW67YjEvOu6Q
YbV5kga7fazjMC9q9JcvFPOiG45edilhpYF5p2UX5kWZ1l28jnnR4L9lnKI9
FBjz78zHvGhuYkYo5kUl77revu1KhmPU2BrMi9618l06lNoLhJf9mBeF5vxg
T8yLzj1+Y4F50aRbOy25T00Aj2/YNOZF772q08K86M4YRceCOALclTYXxryo
1v5BPszzX/l0uLwspgVZ8JxPxzx/zsaUd5jntzyfvdEovg0ZK+9f5fnflzor
Yp6f3Td+yXywA6mOS81inl+w/3Mg5vmVDDS+Pj/TjWLruVZ5/uqkD5x1XTnQ
F8WBhBj7UGaRRh7m+SmTnx5gnr/WvyB0pX0Aidv45GOe3/u2eUSCreY/PD/6
X3h+9A/Pr+RZkYN5/mW7j0GzlqOIuYk6h3n+29/3m2Oen8fwxjYtpjH0Vyt+
Peb5E9HZa5jn17x8JpCxbBQ5uiW8xDx/w6eXXZjnV3auFyaJj6Ajc71kzPNb
fDm1BfP8Me9/7LFp7EcSPB61mOd/Hyybh3l+8oYs6Sc1rah36vIqz//4U+4q
z7/L8QdnG3sB2nIscJXnP2xCWuX5UYvAj5rkAngZcG4c8/zxj9ZoYp7fM/iY
0FmJdtiqZPQK8/zuBA8JzPNL+ImCdv8QpFe9WMI8/9Px2MuY568+W8fPx0iA
oA8fwjHPn3eKHIl5fk4rFf+APhI84rJjXZKoBYHKT1OY5//dln5c2JsCBt0K
ZzHPH2KTMY55ftkTTm946P4/lHnTDOb577f06GOe/7SqkpZ3Ng3WFUzOY57/
3wtDfzWGyqW8LBpsb97ihHl+hyvGo5jnv+Ow9IsmRYNnMkJtmOdPSTjegXn+
i+tZOWN0qRCWFyeOef6oTKe1AdAMxbU6lyP5KbDOx9YA8/wE0oN2zPPPiKtg
nh92fGMNwzy/+fNPB1d5fqlMgZEDJND3sGv6Lzw//MPzp+u+v4L7Vvo8y+eN
NFoRtTdhtW+VuufyN9y3MgtgEp2RbUc7Lpgk4L7Vh9zDk7hvVb3TgVXdpBOd
sfNb7VtNML4fXu1bMaY/FYzrRjbbDm3GfasY8oYdfX7JUCOx40QrRx+yUte7
iftW//x8uL6nBUQ+HEAnzfNH/kvfCv3Tt+KN4tmD+1a5amZ1DWHDyIT992vc
t5JVfMeC+1YDGlrXv9Pn8btNQxPuWwmyR5vivpWCpLv9n8cjyPh6wH3ct7oU
/DgS9602CzqzF8wOI7N8KS7ctwpI8jXHfauZlAzrm3JDqP/PnYu4b1V165wt
7lsxTJ+yMz7UgxSS9grivtWlU827cN+q8x13wuCRZiSe3TOH+1bz/FOVuG/F
FO1CaD//DVn4nRfEfassTupq36orYM7CbOEbFLuMfcd9q4LXHYdx38oyXap3
JrYFGIP7unHfyinRsh/3rZhFNmcEsQ+ARv+f07hvJX6jswL3rVQe/s5LIYxC
N5GUgvtW0qdNruO+VdlVDrvO70R4/9g3FPetJDooCrhvlR2dczH99SRcHIg+
hvtWKrlOWrhvlTxRFm7qSwEe8oME3Le6JpASjvtWMlWbdoqFUEGg2c4M961e
eMwW4b5V9dvT0nZEKtgLoMH/2bc6OB/81juLCnr9/rX/pW8F//StGFVY8nHf
ate168lTAhTw+2oyjvtWtz1oP68N1QOpkAf3rYDmpvML961ej7PF4r7VeZEU
0UhXEtjOLCf9l74V/NO3Mvz6Khf3Ya0Gt3KqRLWic99lbf5LHxb904e1jv7x
BvdhL2hKB43ZdKKz/KU//ksfFv0vfVj0Tx82qO+3BO7Dzul6GN/I7kdX5PLb
cB/21Za3U86zeWjxtxV3R+og4nbs6cR9WBtaZhTuw5oxLKz/GjuEzlAO/cR9
2F+HBIZxH3apdmRNCC99zv9EWOM+rLmh43fch71PjTS+zDSMysNOv8R92BK+
O/G4D3vvyWD1n0NDKP/pen/ch40b5Fjtw9pkn699Ud+HKkfIn3Ef1nxw837c
h026uEXlI0Mnsn5wwxj3YQ88+HwY92EN96i/DNvYgEhH3Vf7sGtfbOXHfdh1
111o7+SykO6WzSf+Sx8W/unDWu4YWoP7sPofeGxdbJtg+6DJedyHTeiqOoH7
sMNaZ9IkcntgQ3uAIu7DUlgsZXAf9pQsafvc5DBsKNNe17ncAUfuarfgPuyK
p6Ju8edxeHXQLAH3YR8X2TOvsA2j5RjTsrjoCcgMPaKE+7DkULH9uA9ryV+4
si9tEtoPKpvjPuyRU+bPcB+2NNa5Opb+ffnBt9UL92FXuF5q4T7sDtLZbNY4
CpQyLsfjPuyLMFFu3Ict7XXMP5RFgQEm4bf/sw/b+PWMZK8RBQYXnxJwH5Yn
+dUa3IeNKjRud31Chv2mBsm4D2sXvmOnTWQpbPkspzoWNAl/VY89w33YqhZS
PO7Dltx48TDxKAl6RaRUcR9WqVH1b6RRI7wq7U8Q7SJCqnziH9yH/T/uFaB/
7hVIbdsZh+8VlD36mKll0o4IZWJi/+VeAfrnXoH5jmCWU+4qRdyt/Hs3TXeh
fz1Twe6a/xy+V7B0G/C9ArSTZrV6r+CUmO4Ivlcg6BY1zuzfh9g65TbgewUv
lm8L4XsF/vVOL/QYB9C5wF+N+F7B9qY2F3yv4O6sQa073yBKUBQm4nsFybYU
CXyv4KBahNulgEG0xZRNG98rcLq10o/vFUzLqewj0gaQ8V3v+NV7BcKTivhe
gY6GTscSaz86zS5KxPcKeHX9IvC9gogPMXuv3ulGv5ZelOB7Bc7Myzn4XsGW
IvuYHsk2VLq3qOC/3CtA/8u9AvTPvYI5BZbVewU3Pd9npPBkQFjl0Y/4XoFw
5kNefK9AuCvaq6yjDqRu2xHxvYKdNyM/4nsFp/+W/spN7wRxFj8RfK9gkopK
8L2C7bLRJL0NQ2BR0ZWN7xUEhll74HsFJYuZoUfjR2GD92VtfK9gm5pwAb5X
kOklbBUYSABWg9qP+F4BG3fRIr5XUBV7XPvEpwmwP1JxDd8r2PDwnjO+V2D1
Z4szEp2EPY282fhewY3bgTH4XsG3Z71vRxnI4MFhuAXfKzBw/R2L7xVEWfKc
+XSCDH/rb7jgewVzsTX1+F4Bp9jxe8dFyNCyR+D+/7xX0BOvyPIwYhJa9hpx
4HsFBQouafheAedhX6PN+SSIE//Tgu8VGAp6meN7BXKM58r5EiagiIPn/2Hu
zcOp/N63YUOlkrEBJYQUKaFkvjQbikgoJZUphQohJRkrGUuFDCEzKZmHZZYM
mefMe9vbZu9KSJP3XvX7HJ/nfY7v5/e83+f4Psf7/HUfex/3sa17res6r/O8
1rpPj7BfwXK0zwn7FRxc1SgtfXYCTmVrPcF+BS+C36/HfjJ2uy2l5Fzb0U5B
12HsJyPaIquE/WSeXL1+4cvPDvRe+WbH334yR//yk0F/+ck8/pxVi/1kXMqV
sZ8Mmqd5/PaTSTEwTMN+Mm4vY3P0UnpRC9sPXewnoyXNGYT9ZISCI/kilvcj
KSZyEPaTqVLPUsJ+Mh8PosJ0sQEk2rNvBPvJGO25Z4P9ZEo3C9N8mgdQ0Y+O
UOwnQ4bV0dhP5lOgifey9gE0vMqYD/vJnOou8MF+MtUHTsu5fe5HH7ktn2A/
mSF5thrsJ7OF1BntP9WLosTWPMJ+MrQ6bxnsJ3PB2muNR0AXuuOQaYL9ZLpO
jy3FfjKBdf4Jom9aUVms8Sz2k5kV1r2F/WTcnMbCZCi1KKZ+XQz2kykt1v7t
J/OGpzhLRCQbURK1prGfDD9l9LefjMrE2LemtGyY+9r620/mzKWdv/1kbg0K
Vtbr1kNAZY4n9pPxM3n7208m1fXUuheMDqgYO6T7208mTdwF+8lYJvgtriB0
UaAtayL2k5lnlDLtNiQhbY3v6/MTR8CV/eU67CfDE9E+i/1kjNewtglfHodz
996dwn4yi2HmwdhPRpmsV0l6TIYXnyvDsJ+Mn2WFJfaT4bLSahSXoECTFZc+
9pNZclrTCPvJNFqreLGJUaHR9uMc9pOZIuU5Yz+Z4huRroVRVKgt0+HEfjJp
r1ofYT+Zs1mie9mfU8ExO/sG9pMJIDm5YT8ZHdOpgPcHCJ5vWnEb+8n8Fecs
NM3upqcUOHaZXRb7yTxIv82yfmcmCDHrpAtkTUBtf5Uv9pMxq99jOk0pAk6u
EzYJj8iQF2Bjif1knG4KKTr3hUPDtZCYCf521LI8xRn7fXkcUuvNNVAvO1co
oyB7rQP9+UwH36NXt4QPR6Jdzfuw3xfSWuT67fdVse7zN+z3tSXpvDJ1Uzfq
zZ+ww35f8odUXLDfl+9wxZ67Z3rQjNzj335fvjFXKdjv6wqpxWvfpV4klDHq
8y/8vtBffl8jb96IYr+vQpMSC5s7fWj1eMJvv6890cJbsN9XKO1ZzBalPjT2
+f0G7PfFt2qYJQv7ffl9PT8v3os2KHb9wn5fFm9iTLDf12nD0Y9xa7sRVXXm
Ofb7Wh5j8Qb7ffGQrrwYJLWjmG2kU//C7wv95fc1YhYXjf2+zgePKAf+qkLN
1cmK2O/rg0f8Wuz3tY+3b63phgw0Ks5lgP2+thof+e33xdbx9fjBtZkQxxn6
2+/rrmBrJvb7EhHmcu7cUgsNZQvvsN+X0dZnHtjva9jzkmrN5TZ47qchhP2+
nDfU/fb7ErQMKEs36IWI0KLr2O+r8lCDBvb74qVVWz6+NQT9cyFF2O/LZ1Aq
Fft9VdDUzbaajYKSiZEn9vs6fCH7Ovb7kpO4Yr7lxjhIf8zcif2+jkSczcV+
X45k9xNHuMhAu2b+Aft9SdzsK8d+X/S913PfbJqAudsbHmG/r6Gs4HHs95V9
ol+9r2gCzqXlJmK/r2xG2Ans9/W06NPpuIkJUMiO9cF+X4pzXCLY7yvqOUm0
MW8CGkUiirDf1ybeqV/Y70s44tWR4T0TIFgluA/7ff0V55vDdmzVukGGSGWZ
Tdjva63atklqSgqwrWJZXfGABNz957Ziv6+/7of6Et3+sDZ024E77V/4MaJ/
8GNEf/kxvs9QOYf9GG+76TFEFjvR57F1N7Afo+boc1Hsx2i9JVM6Y74L3bYy
rsR+jJmbRfZgP8ZMa43PnKXdqEdBfwb7MbaLW3zCfowWN5asXtjdg1yWid/D
foyhM0x22I+xuuBpeP7+HvSzlCkX+zFqtipew36MZ3sdA3dWEfyWWrAB+zHy
mVwrwH6MyVMv062IOiISv/wO9mNcARRr7MfYN/7s8rhvB2Jlq/+A/RgL/Kt+
+zEGiFiZ0h+0ouivSh+wH2Pei01//Bh5K91+7mpAdyUP/Cs/RvSXH2OA4yoO
7Mc4ot4fE3ArBe1/Fvzbj9Hg+e7ffozw/tDnOydTwf3a+d9+jHU1vg+wH+Od
ml+9B02rwPmtscK/8GOEf/BjhL/8GG9bOyZjP8Zdil6zcYx+II0vnsJ+jNev
nRfAfoyZvE0cC1bDIDLDvwn7MS4Efnzx24/x4uNb2y+OQsHItR/Yj3Hduw97
sR/jJfq9D/Jfx4AiHNCN/Rh3xaZKYD9G6Qf2ntFrSES+ZX7GfoxvHqs2YD/G
uRP5X3ZXk+B80adX/8KPEf7yY9zPKRiK/Ridd6Ky/YQOX8nqpIv9GO2TJvux
H6PbjoiuFIL/O02aZv0LP0b4n/0Y73nEyfacGgdZ9WNZ2I8x9eCr1W0Z08iC
vdFHLPcdUmu01rg40g5OWrGf1AZoyPVF+ypBjj60o1YkrTmzFYySW195lVPQ
7d3b1pwPGUU3hXJalxu1QKNym3P6Bjq6v3x7FOvjZlSoay9TV9wMdBuBMf04
GoorkR5tdvmAzudrcihefQcvVR4HrCNwzGlPc+2DtHF0kXtefZ7jLRS/HTwn
J8VAf43XqO/z9uscTcB72jUqW52OjG/6loQmtqISm/biisu1kLs+iZI0Oome
Hdq46n7RMKoXUOna4VYJDx7qBmmPkpC7Rv8v629klBh7/rno/XKQ4Pdpu3X/
79/v80BJuyNrwJCLdfc8Jx1F040NHjzrQJtJ2h/2qZRBbWLy1S+3qKj1bYed
i9AYmpHXXi5zKx8yPu8590t0DEUM8LP+8qaiPSPSss41b+CoHifjVS0DXUxt
vbZRmVP9z7UMqDWytLnr06hE9Wp/U2AP+sCS7GG+5jVU03JnvcUnkNek/zXL
lWTUufVSjO7nVBB3EUPnKH+Pk0U0eox8OQeu0MySPu+ZQnMPrb0CBAbR9qR1
1ej5c9jaP/NpQXYMvVV4tvPrEyo6XFWwcbT7MaSnlJgvrmkE3zs/TtbKM5Co
lfqHN8ueg6jo5nOSF06XebaplHevmwAGXdeEvoUM7hbSjehEJxpkT//EH0mF
BWXWfjKN4MNnT+278/Xv8TwwLw8NIr2ACv2CjbIRVORQtpmJJDeGxIwWvBd6
/OBkrEOfZXQPWtIU/S3z3jTyWtJ3hkPBHSz8t3dS/C3UOzwftlcuMlBpavcB
Zq3bwH01YGwXrRX44jxuvc2nI+dczS2cdH/IDXE8UnLOvKxj+aNeN9NRKFk/
tfrb7kl4c9t7d0fsCKLVfR2qvk3w54C64HUWvQB3LcJ8fv09zs7CdFfzGw8h
Ql69V5bQ+6zf75s9Jcardveck/6VE+CRQNrRF3hZnf/uIu0XMZ6pbdsPMkcf
g/7vPJ2+0T0g6xHI3UGM//VhS5bRrnOQslmsqnjP3rKIyF3R4lw5sL5FZWI/
lQFqDjGHKYt//91LlCi/Pe6O//b5SRU784Hk43vLGnclaktw5aCNI0pj+PcV
/uv3HYdiiN9tV/tz/fd//5++X3W38vFu1Slo4C8y4RMaBPPzSWytPZawYuRx
UNw9QgdLC1qbEvNxdEWo8I2tt0Hsx5I2gQMEjxuO/va9vAPCbjg5skuGQpR9
rohZtnmZrHjH6humo+jjOhHaArFeOf367Hi9vLW2cNfcnkAzIiEGeL2u+v1Z
L4dH+cQ6zaj9uT6ELVGnJfRaLqt/cf69LiBOnm7B61Iet2ubHzGOdOeoX+3E
uI52xu3F6zK7JevLJvkxoNrtj/OKoMKilE8XIfqg1Xnz54ptE6CXcItXh4cM
TJoT9xNl/CHmcGYLz1MqzAZqXOWQG4Npj3GLeJHHYJmrtCxLggbcfCdEB8eH
QTM/docrUwJ0nhoybJSZAmVDSaE+7kFYYmwa+3xpFixhnpxiGZkC+9pR+MzU
DwtqwYe1d+eBV31X9MR1szJVjpvtRH6hnUJwAOeXtlpPHs6vlXJ+TAKRVPQq
LqoQ51fDNr9XpHVURGJlZ5NuHUWPRSsDUx3qwc3pT95tvBJP5NtS9T/XF1BF
NjTGefdYQT9nnBi//9EreTjv8mZvcpx8eF5d8W4ozi9Ipw/V4Pyqbdfi3U3k
V2xd2nUiv+D4lfyzOL9mRcVv5QgOwqzkvApFeQpmGjT0F+IeAjON5Nqzcwzi
bH3nnR9TIffXkqH27FiI2s9cKs1Ohk0v42xPbJ6A1Hs6w7w+KeDRrJf/bBUF
3B79kGT/OQ4yeoEZqwRew7j3mdPvXamw1nxfeNT6MbCzauIKf1gI41vcKzpc
JmEDelX/yHEEFEXzl/Ker4BmKc2XazOa0IZOmXfT9lQ065KaGfl5BCRj9opN
vhtBV86y/dpTOIEMtG+wbOHogQzqH5xEAvYEPrKW/bnmwJKs5Qjj5Im9NZsJ
nASvLzIdGCeP3+pJXsg2Vz9yYtMv158MuHaGoinvEAHFDao3MU4aVJ8zIXAS
YgPUvmKcLNuc/6PycQ+8cqAW5d2ZBk7h/R+lS5Nhs/QOMR2FYTCLsFg35UWD
RLKvJG9YNjjl8i0tFR4Dtp1e2Um3qbDJrLFxe2UePJjyzz6sTYLFUwJlKuET
QHco079yvwxUXedJ58eIek7UULNGEtQOcbpL/agCwbZrOoHLKaDh0ZZ1WXwc
ipawt7h410Nd7Krf9cWKd78jri9/rmUQEek+j+vL1hP8cUR9AcNV9/1wfUmS
dAt9uawOum8/Y99txYDq3TXtpo2vINnHSz0jowNOtnMJu0vQQfTR65rH1XmQ
trN+l89APyw9O11q9XAK9PKe85SrlcLRnKTTeYXDUNRt02MwMgm7yqIEyAmV
gEb5j/0aGoXFngbbFCkq6JWvWmhxrIOfq64wCXuMwyM/29073CfgtFKYR/ry
pn+sv9fdi1Rx/V1xJ0acqL9wMpuDhOuv28HY2NOFrWDgGOJ94jyhDxfv3jUe
roSeXOU+2NMDUhZnzglwTYNE4PoZka+14OKrKJ9v+QFcHWULTINpoFlj/iC7
vQEW7lgnORDjP5Oz0bf1KxVyAo+6bX3TAgsVk/8vvtFmsvk33/jrM52bSVbK
vR0+7G3W3O9Oh/k4pWfXpH2h9X2n6/q+NjgjOcK99tHf/tUOImvZp21I6AnK
4jd/OwGmix9W/nzwBDoPPGJQ58dRA1sYv7kkBb4OKQok8NFQ+jd/pQfmHWir
fnyWm3Y/9L/7nMeRRkNcqYMieRzdKKF2ubugQxdMyWiKblagoqpAnZ70vA9I
otGxy53UCx7+S+oeqVARv8XaUO6EYfTiPMvjR8s6gcZzWNxzdgp9nc9XybWq
Q5JXVCEXx3H7z7vfTk4jtRWLus6/3iKbMbWqVMUusH0XcY+phYYS82Ls++/0
oDQvv3zm5R1wz8aDcoGLigpkOtMTH40g/dEnx2VftIE7ee6D9wIJKdmaqMRP
j6Nlv8yV9PQ6QCX4lOP423FUGvPuCnXpBErz5fIJuvEexj5HU7ympxFLczfT
ypBGtCm4kC/1cSuQv7wOXd5EQ0y7KS1zr/vRzMHV1g5NzeCn/019VoeCfrWF
Wh99MobW1b+4XabeCC0zu380jYyi5y1lZbzbqSiCFCmXIlcHogfZMmef0ZFF
VDOTaIKo+p9rG1j65K/NpNKR1nz4Dbv7ImV/ri1w77lF2aQCHdVNT975Yt2C
Xl0vP+/o+g7qVHdI2R2nIYbxr5Rl54bQZ+omty79WrhYwq2iNkpG2lSVp4ca
SCiv8e1RPvFqKD1+7MQqoWHENMbrVXeShpKyFwpj15ZD1sfeyqtn/46rD5ta
a/P21IPr/r0bvsvSkfZ3x2Uqy9tRjSzPmOrzSriU2jeQqzmJbo1xJVR9GEF5
p9jnDg6XwuCOvbkiSeMo9kXhkYOKFDTAIkEyDi6CNzbx4z5nq1DEK3+VuzoM
JK3c+eCVVSVIuMUkOhnrqb8dvHJVKIyoq9/L7L6OV4OWV1Sv5styYFztPse9
mYFofleO68u/hW3u4B5cPIz0PQpIF/XIYHvp0qb+80MQG54fPdA+gWhVyIo0
OAJ6VdbFmlbdoOQqN7JWZxoNaVkOK6/rAJbzX96SRFqgmOm5yZ2Mv583tex8
2U3lSjh7qGX1tbZpdMtaFW2270IZtM721W354BCwq++QCwVdfczDrXSH4P+T
IjRa1yvI4PO6dXzdIPr6keJP3zWFhkl8oTUsyfAdKnct/1WLLng+jLI5xUB6
v8rc79zPg69UCtfc4WPqZn7mejc6GejU9b3kklVFEO9wNcTKvgpeSL1bGXaB
gTRWHTRIFkZw1Kw0AOPJOR2SH4EnyObqxVsYT3j1mezerehDSXb8UdsvUqCC
28qgd80wpFQ+0Q98TUKiI47hq9LGwdGXMsNw6QLLujFzy6EplK3FvvY2Vw/M
jHy7JbKsAcYsOXYc6Pt7HtS1GLMz9wtAzK7ox6P0SSTHdoSaE06s75Q98662
THj9S57z+MwU6pfKnubh7Uc/lCp/koTSQPfj44LN9iR0+RSpdq5kAkmHv2NY
9j6Hm0v3yfhOtiK/83HxUXl0VDZ6THDwTDgwFSkqULkbkY322iuqMgyUz3Jm
x1XVFHjy5tkO9Qsn1Cd4V8VqzjBQ/ccWioFPBhzr/umP60JbsMoqoi4ggfUv
y3BdYH6tL43rAlOSrShRF9AupbRXuC7MPnwogetC5prnFURdQMtm8llwXTiW
u/l3XR5fGv+TqMuwvvz0ElyX3ffkHw4opSEvjsGGb48/QLrq/SapgTpwmHnv
kvWOjjipXkFNh99DTn7VlgPZZdAef/ia2jc6Kqg4+22j63vUnE26Z3MkFTxo
5dc2fSae56Pdyp66n2p/rpnweeCGNlWAglYsY/dPWk5CzewHlDO/R8K5kZQn
U5I01J+tPT9KHkbNlCoZsYhw8Ho6L5OmPoxyQn5s3RRKQz93ii91Dr0Pgr+E
Vsg7nFRfxboD8wH053ME7NrE2XORqQzWHf4UJl/NQPdLFwaWSEdDU8hjEuYD
WX2NiOADiEuW0Yv5wBWrGH7MBzY0vRYk+ABqN+gRwXzAsCbiN68LCp5ZRvA6
kLSP/83rTsnwKNzYREf6h1NT1VI7ILaV3dLvQQHoC+9pcXMio9yHJ4tLzpPg
hY7VWFzkewhQV5GI209HHusGzqaUdyD1z603mkMfgVo057LzP/6Ot5e5ahtl
7GJA9Yjcc17pCbR8p6PIUx4y8uL6kma20RGYG4s+9qypQ31bp4p93RgoIHrf
pfSH7vDEv0z/E38jqrLS95FUZKAns0c6WsOtQUYi/dLph1UQorf7yqFYBjqb
dEDz/aIXhLCCOeaNQV0v9xO8EfE9iVHCvPF23iZ7zBt/cEUvErwRMfV7tWDe
qHJJqh3z7WeVdDuCb6MTGr2WmG/f7DxTgvlk9u19lwg+iVxXuPVhPnngPssq
zMOtvyzyEzwcnZpvV8A8PM7sEcI8U1YjQITgmUhryf40zDN/WhSdwvzcjUls
OcHPkbTp0wTMz0nXRs9g/vkmTv4hwT/RHvpxHsw/PezEP2Hevj72+XaCt6OU
+PfamLebh4Y69Jx5C+9YVVbbqn0AcuTAiGIzDbIT4m9Ztr6Dy7KpLKs2VsOV
/bf1eEfpILeve5pkmQPnhxLOyX0ohEOavhwXyxjA2rB3aIhrCnHGiLY10D/A
4XXh8lH6JbDv5KdiGdUplJnN85FbaBDxm1z42MZrD0qV8VP+/4N+HBphLzwz
6Qv1u8+v8KG1oplaR0n9AjoS08/4osGi+486rrzgdsU8fyPETvCSZYh15L5O
6RvVMIatHelDWB9pey7NJvQRqsoJLsX66J9+57nig1isB0Vf1uzhw+Nc48iJ
9WBlMtsU1lNbVk7yE3oKjaar+GE9RUfCT7FOPCpkrEToRHS1MkkK68SdmUJ9
WCcy7ho3EDoRWU/duIF14phRb8rNN3R4c9XzlSa1FRn/ZJOMmI+FO/Ufcg8s
0EE39sjaTS7vUX5HcvHY3TR4X+ctLSjMgDNk4LZiaUSMolX5xgfewE8QtAnT
n4ayKvG0RPseNHpg8xN7aQQzNSm57ZIMWOtX7FC0ox6dOtcivX51Kdwxiukf
u9yKAmT2vuxW6YYdZ8/9/O499R/T0f+p74MCf738Tui3YT85Ttfn9uotB3LY
mKLNIWF/78Z24vvaxrBdHsIX1StlFE7ta7wBnZKeRuzE9zpl9vSdgRfUed9p
a+tqBoOleYie6w8G3B8oUCJxmqn/ucbArasDQROzDNi+p3TXMddz6ldWnuzZ
cTEVmOsQfXCCAdz3XVgm75uocyyvbTaMzwEmAT6NUyvpMDLuQVu6twLda9rD
Z6bTAcl1Wys3N26Axz9jfy5uLyxVPfr9x3/3frTEafeId3q6cIvLa8Wu3YbI
Nu7TnZ//zf0bD7r5/Pof8kLPxYob3I9DxPYcV7VzdGjb+vzwu61m6ns2rPOV
3dAByyz33MR5emZWxJbIUyTQeFoH56ngT8ZZnNf84iPniLxGP8NXNuO8ziKn
0HD+UnxbdeQ/FKL11sErcf5K5/jq1nvGgm6WE+sw+TWqurygW05iwISuSCxj
cx4cYv3u8Pl7G2KKfXpV1IEOQtp5cTiuLuiI5PaqdKMzduPPcFyx8eVoOTo3
oaBFgbDBjBH0QHKyzjeB+o/P+xcO/Mn/ztK/cOCf7jeINb8qJz+G3JddnXoS
QQUTAx4hgysn/u14q9p7lsVlGw2iJKQdeyaGQXBrsdjxi0ZwQDDBBr8PvFey
8sFT4vePL/Xc3WZiAIYXF9gpP6agwKGmlW1DP+w/ozZYvssRPjXcSmQVpID8
Rt6jN1eSYEekaV5QnB0cTlwSLjczDZufBMu/9euC1RFFSqsK/KFE4bE1NW8S
6lN6taSjR+D5pWdbtIO8QF+pWh3H24bTb8SX7a0A74skXhxvwjNnTAWU20Hb
MCe5Mb4X0Yrmjm/NoUGxnudpns5auJ/5bhlX2BhazM49fDuNAgtqSRaF70tg
/fBzuTjmYfTo1bpZMzcaFKgcHLpYWgIBNcttLj0dQ3fPc9xtXUmFIGvnKb93
9Wj6k0O97gYy2npWweSwIhmey947szq9BqWMqN6yXU1B0mUK96TPjkNxoGIf
xvkbcgYkAufRRg7PHRjn13GaV+A6PrWssZGo48hq/+73uI4/5qtZxPjf4JX3
iUtoEHTj7yi2E/i/MfFPHa97J0LUb3rpn2sMeNBXIIz/89RZTgL/4ftFH9F9
BP73vrVYxPU9lHav9AkPGdhlJr7i+p4tMmjxlcD/nUdGBwj8B8W6N2fHCPxf
TD96worA5Qs0lpFMAqdVKjJJuB8bPMXR/FN9GHiz2eKzQmlwP9X73t6hS2Am
/ZlGX1MHlZtVzePdGJDM/XMqRPwq2PizsehfJcFHixJtt/IJWMY1RC9c6gmm
B+c9tdgHoPuk9nezqimwoxrwaX+7DYLMmdXIlwK7vAsFTgWOQ1xZnliRRgik
+qsvZMiNQVD3qzQywQuC1cSSDlED4YCC0x4lp0l4dVTZw/j7CMxIJp/XNY4G
6oGVJAc/Mkis3MFDyiPDVB9HlqVaJDCdSpO4UECDjPx+rbmOIZgQTTdj3ZAC
FVzeOmkGRbBqwJ5evY+EJnfX/9LKnoCY+qMud2SMy5xUHru+tZ5AfnceFZu2
keDUJT2+dTsrka5cLOvuJgrqdOB69iVnDMLWv1sT0lGGeu8plFaSKejZOT6J
wMIx+K4oq/6VeRQtigWtjmOhoFBleleGfBdEyFi5PvP+gHaonhVuW0lFvz4f
/HKoug+MnhxRwXyP5VvPfYLvodV8izaY703k/+G3f+Hb0KEXv/lt6vtDiRxE
Xl+wPq9qTeQdilSVcHtD1NPi8DO9BH9LWzedR/A3MDzm8AnztySji+LfZMfQ
i/G8lV+fUIGjnGaC+/+XreTSMX/bWVVqR/A3MOac9sX8Lcg3v7jzWQ/Qvlqe
YSLigdEu82jDsyAIWXOI2qE/AvsLUttvkCZB4ZlwkxtHBKzsW8+/hdwJj505
VhZw0mFoS46hADkClo8dHm4rGwcp54ls1RMUUNCKqTFoTwCBFUYSEzeGQNKJ
9UB1Jw38JPcOiZ1MAAcdOvfCpgmwUn97ZYGNDIuS5L622Uw4JXjuYPy2Mbin
enuVdzAVnoopPm62zIBLSltsT7dRoOfDwfwMViLfHpUpHIvLhRBP9jwvz0pg
Srim/C5oHLHeGDq7ay0F+E56ZdjXvIGAz2pqSr9I6J6r5RETgQmoCZL9ud6m
CKUyvRSzf0FBk3X7FyXEx+FVia/YmqweVJbB57TmGBWJSoY8vWU5CInbuHWx
fomaVMwh9Asq9M9vxfrlL333R9ctV/9L380hl+tYjxTYPzIk9AjM14TaYj2S
9Wq1NdZryTFXIgm9BmBzwxzrtesDgaek3rTD5MTnFPdLdHilvtOphDsRUjR0
96o0DgDfkrjFJX5T0P5rVOXt2gyAH2H2t2pHQOFWQbvR7Uko8t7w/YFrDig4
tgs+1RoHToGzzjf8KLDlJP0997UiOGFWNdsnQYYz1sI83hlk2NWSy7bXrwKY
E5+sUH1rVJY8OThV5EpGfz6TwVcpx4V3sgZZPTsZfvEkBdV/PbZjGds4LBs3
uIR18aimDdbFyCoj8rcuNmkoP4F18YYon2BCFyO9jPQFrIvT5+WtsC5uLTzz
zYOrB2k8l/TCuviv/sCfvgCv+l/9gZXL7db5iE+gVUMsxyxXksF8nr8K73+t
tykvwX2A1dvGrtN3TcFBcnAl7gO8PCJ3B+vceJecS4TOBSnPRAusc9t3fOQV
zy9HxmsV2WQbyMjmSpjGCQIXj7JXv9NKakfxj6mXTB5NoLBsTiPBQ2MgITnn
ifsexe5RQxf1yIjOFyOB+x50AdV43PcYj2oyIw2OoIFthytw3+Ovfs6fPo6A
+l/9HMH2Y/54f9BcJPSYi9AYCGWCIN4f3F1GuYX3B2Uc5ad/elPh1nGKLt4f
fHk05S79bg9KYNp6WOjqNBgJfvROevkGrjYmHF/UbEa5cylLldeS0dqJiNmZ
URIc5damtTJ6kR7b1L56ZjLKf+X+WZ8Yv/txW74EzjG0vj46IJRlHB07zpen
LDb8X31K9bL/6luiv/qWJufMUq5K+4JM0PDV9X1t6NneXzz/om8Jf/Utg24e
HfPQe4KYFIKTJCvGYbr4fq+fCQXKUy4/NPP1RTSljFsHJNtB2G+fX4U/HfYs
zezD9y89IvaKuB+pytxtwfdfngqVX3GZhq7ZrTo4m9mJjtCWbC8e6AEl/c1f
Xh6monaepu5k5yEkKRa78qljNzgVJ4Rvvk5C3L4PAhLmSSjVVGq1w/dWuLw5
RVyWPoa0rcobvvNREE1nTidqdwP0Saj0PYgZQUK3m4ya9k+i0+eMJLpvVMGC
D7/asvzXiLKqsbPqHgORbDyuqQdUQf6WdB+L069gm0Jg+4gdA60Q26qadq0W
4nSOh4adHke+/pIC5nfHYezFV/+XNv1g6EZP7hqZRJ6rxBPiMgZAt+cmadvD
dohuGI6s1B5BYaKzJbf7JhHX7qXJXh4v4eWuT79qhPKQE3/abG8JAzGmnQUG
+AvgxXicioLBG3DZrM3hmMNAL+6/07ptUQJ8fT3ZJ3oagBVc5c5+pKNJrWVj
EsIVoPHpk6T2yREk7fxxbQGBl0HFz8s2XeqHOM6VCrszqIj1ilm3wfQwTF7f
oLI+txU6hqZqL0f2oOE3T1wE/abRh7RlyjJ8cTAeHJP6sKsInVTp3KzwloGa
F1Lj05amQX+atZ3j4QLwcH+dfLiBgQYjwk0X3ryEByrnuaPPtIB8wbb7bp10
VPg+R/WJwBtwYAmrvnyrBwwjPhjqXZhGEZVKa4ffF8LLQ98XLHZMoAcqFsRI
xuGKXfzRssetMLBkZnvyj3LEbeS25FYuA524KeRzvfUxaC0XO4RxT/ecQQaB
e4hcqnUK415A+HlJjHsRGqVLl/pNoUDT71sw7oWdadDEdfZ4ivtyos7CXlb7
cVxnzx7XCcP1S8tnpRVRv5BhQ7o5rl8Lyac/4PrVl3Cyn6hfaF1FZRGuX3sN
b/7mD6f3I26CPyCn8YUXmD9M7/6RyVVKgVusJY5zGuPo7vTk3sMXX8DdL7Xh
wRqT0DO4nZ+xYxSV2Tfp3zubDa1sGc93H6HB6D2Hz5/th5FY/D7Z/W/yYZWF
83O3hQZ4VtLJqp/UBgH2x5j2NE3DrMDxNKwXbF/em//0vQ089TV8sF5QnkXp
mHcFL6rnEbwLyXwmH8O8i934pzrm2znev9LxPjXv7DgX5ttGJ78/w7zaZy7j
BMGrUdKVA1mYV3Mo6F/C/PnOatkDBH9GupXyUpg/3486af1VeQrMUitQteAg
eqsvx7R060PwCCw1uyE9DSdsEjck7e5D+yRMeuIVngOfdXqa5NtpeGirdMNN
ohudK/daHTifDqxtSssnpAidtUnX9M3LDjTHpep4jScXuO4ZUfII/RVo1naZ
PakNmYZmSj79VPof078yU0ftaKwMYKxv3z1z5z3aeuv7jp3d58AoSTXv6RkG
qMkrLASb1KO7ZjaHsvrcgT3oXOeSIAZEcOmqM8vUoOQOKepr1hB4FWdzUDmV
AZ2HnNT0ZCqRv/hXrib/GAh6KVXOkscASWO7HT2dCL2dJTvEZ6fCa9NIE8Vc
BlzncS5OPFiCZIyDXqW8y4F9d099a8ibhujrXe0U13LkZZAdyavZRYy/ti7V
aloNj1ojJbLkr/GfWVZTiX3XNCRy3+bwG6n/uXYB/1TRExwnZh9IR4g4QbZ6
TrMKTdP/OA+ks85f8d/tPdi+lepaDplyfOH4767KSmhuWdEC90ScJvkchxFb
V+SkPBGvL+TGOT7zNyLmmGI3SYL/x71QudYWbg22oHGl1DUfqFemn26lkJDH
k496s2IT4Lhe7CLui5YdO8S2ieD/Vb2ZFrgvSnp+8yfO67Jn0VeJvEaGHSL6
OK+rD+rQZ1cMIIkXQrkslVNA+uXLc089HGw6nH/FDOWgUkF5sZa7E2i/+dT2
bfdJIFgqrBnC2obYhta9elpIQYuuXfnmu0fBpDl7G8a3+aMXVxP4hvyel1Vi
fFuteE4V45teb1QjgW/Ibqk7YHw7bMj8cGj7GOLo7za6HUaFzsLH+uEdyXBH
3PqSzGgnkohbJnBoBR3SjgSqvcL/j3On9cbFfQ0od1FecPHMBFIK1DNh1IwD
RTV+bKthH5KauqZacHgCuYtfF9gUNgJ8j33DMf7vebJxNYH/6FplTCDGf+/x
E5fuOBJ8IkQrvwmfuxLPsaEW54KlU7n1sNUQOu8vtJGrmgZt13oOJjm9gUsr
VNJNdDpQ8o2YKm1VMtqZVPgpMnkcAn3YxGI+DaH8u+8Sy3RI6GnfuqZjlSOw
VmUsFNfT7JbQAKKeIjbLNT64nrYeGG3F+4YjO55SqPPjcFT3qhDeN5RUPoM4
JaYJXXmt4+ZUJ9wSM4pUvtYEesJP7WiXp9ARfWdji0d98DM3OsBGoB6ecG5w
wPPm/PDTVWLe0PsdmpvwvFlsrNqN581c5osoMW/oVZX2Cjxvm/lCraxzJpHq
zyflYtHDoMBzcUQ1qw66tr8Iw+uup3angVh3xJYh1HaXWPf2H5wnsE5xa2h2
IXQK6lbuSHAldMo/xfNf/ZyAQktucE9Q+3M9Di8Zz5bg/sM5yTCHnolhtHTl
sS24//Dv4obPT64LGDdiSkW7CdyA9bp8khg3niWXZGHcuBdSEBhiUg8TyXZq
GDeu3dz8HuOGT9F0G4Eb4N/jRca4oR6Sbobxk/+JwTCBn/Ddx2NhCYGf4isk
L+P5yeRanU/MD5LkMZ3A85NxMs8Rz//WMCNVYv7RZ574YDz/r+nCo3gfh1Sp
83yuZAIu5/byWvU+h5pe57O4Pqb+rGYh6iM8MYmrxfVRKfkevy1TGRzRZITK
VzMgoSpjw1LpaGj5IHDLoYWGwqopFUNOQ+hmi9liXkY6bN+YoRxM8OroNfzL
hubLkYbP2xy9h2lwa4Xw5bYnVHTdxOrLB0IXLv1VYB7Q+wRepki5pLgwULdZ
w2331XVoxqWzwWjNE5g7aLRWtYCO9n36ruFKa0XV7HrVb9b+584X/bvfp2Q3
bmTNa0YGr4LD498NIPB8GHXInwaV4o9O9hD1Xt1C/rR/dA8823lYT15B59/+
fZMz8RXJ5RMgXSUr4n6VBN20otcq54/Djaa1EjcnJqFQPDVC+PgIVM9JfSsL
uAKnbcPVkkOmwF/r9tB81wAEVV+zdnjrA9PH9OcyM+uQ605n2pzuBCo5+ULJ
VpAEnhfcOI9LU5EBE88XtZFR5FpdajxzqA7WxkUdidnDQHeEDi468jdC3dNj
Gk+i7oIdc8jpTf5dMKNxVyV1Zhoc0l5SlDrs4LjPhy/8P0egU/njg+brk2Ds
YOTTZHobdKYvf2cl9E3zLrmrLtsmgIsre+/+liBg8eXvmHtBgYVVVdUJF8ZB
7n78xtEHUeApX7k1fO8wysjOf1KcTEHDg2bpli96II152aku9ymU3FKieL+m
H23beMzwRnsFZBlevX7FfwCqRUaUtOOnYM2LW7JGuyJA8HBPteGZUbioJn7D
efskPJqbp/24mgBZx+zYzz+gol1rPRO1JMdQyQf6GU6NbEBsSwea2Ojoceie
MxtHOlHAlUmL7v2p4CgUt1GC4GGfxRzfvvYloz0xjqrbP8ZAqdj389aRDKQS
NWtmElKFXsWTly2eiwcZ1okFUQJ30gMZDmtXDqBF50eHys49Ao8gl68iBO/Z
+kG8pidvEpEfccapPfMB/dyBILYN/Sh2rDKJ8mMKRT04YT2/eA1qy9rX43VZ
EZI9SqwLBK/wvIDXZdmswD68LvcerilyIupnt6yMIl4Xn5txjAcErtW9E6NI
EjgnJ58jnfzG4R/jSiR3R5jAhn7w8UIF34m/GxQT1CVpexzkTGUXu7EfHeLg
vBfdgx58pX6XI+J2CU+ujt6BUaTaUf3+ilU/dFdMmZ69RP6/bj/i/7bv58j6
zOI8dLg5/fLn5EQnbNv3tN3pri2wJtlZ7GprQNJyul8Oao2jVH1HGykiz3XL
9k1F9I2j0CvPo/xJJFSYzXnT/lMH5Gg9m+O9OIjcP0qmDjhQ0EGj7fPGC/1Q
waMmg/Gw8b5ZsAutFUYqdDv+d/DwKuU163oiHrKlFGKIeIBEySRRKSIeYuKP
eL8i6tBH+71+FURdKjfaWb56wgKkHbup3wPH4XGD9Q9PPwrIntE2yR65BLN1
jrGvT1JgiWxseFzlONiv+mnw6ZsnrIpsXp3DNY4OPn3zOPkHGe2r+lV89mg7
JE1f/HWZ0An+O1/3f9pAAVYOfkbTBVcIX7og6qnaDsVnYyMoPnTYYDCqWrvy
DliQJwrFPwyBOGlIzBvRoHSpsE9IWyD4DLB/d10zDnxJWVmyExTIhc2LydYR
ILWOpM542wvsEmWbZPdPE3WrLvPQgwSwbPR7fnHVFDLdrMcVGNELBo/rgrvE
WkF06wrzXm4aWv6wKUPu2SCURPpsM9RohuOXVS3HXk2jVfc4033iO4FN/vy4
wppqkFV9HTdAoaDYH9X6L7JGwSWPezjGrwliaxUMMV6djd+iT+AVdJ3KPIbx
as7KbxOeB067OX9iHqAvS7Yez8M3iveShAAGyvE7sspmew266L9h+a+waHht
4fMZP1fP99Bc4rmQXMWpL/i5tur1h2SzMpAG0jyQT+iOLXqkixYKngSPsuzA
6+JgeY7zjh8FtfTIqeB1ufSaPxvXkTufYuSJOoKyX5Jf4DryT/FwZMq1s/Pe
NMTNv0og6hc6W3XalJphCi4ZugdVVafQ7WXWAxuFBtG7QK8LHT2b/7N5lJRG
6BOJ3Girn2r/X+6PS8D3/zjRaPWz9H91v2LTYcoiwevuMa2mbnF/WPrnKg+2
oQ7HuBv7UO+n3lcpJWS0dUnswhj/6D//TqbrWjViHq4ern+/XmgQPEMeLun8
35iHGz1C2oEEbr9/fMOBwG3I2qP/DON20NmGI+UmHWj7dt+1nrYUND2XfDGU
ZRRowRI3g9d3o+2F9j8UXk+gh4nGHkhsFH5K2qy64ziOPKdbA44nk9GbhLRm
mlo7iFqZhnUS+L5fYOry7Pp+KPnUIi1+5QZMTtXE4fix2RWulUfwTyklzWs4
fgbynFQ3EXUqk/3oU6JOgcP2so+4TrGveaaJ66C++bJoog5CDleaC66Dwzdv
J+L4b7wnf4SIfxSpL0TC8f/RocgK55F1n+ZDIo9Qp9+iHM6j03GfjLX2jqOT
qYUkp1IKeJ/tyT8an/i/mjfPwEp3NqWl7XDZQq12IJAOQdxv+xpBU73BOXyb
1sg4+vOZAtz3JEWad06icMQYvvlhGMbqzq1l0m6C83EszyTKJ5D+SEbMMiL+
ye9Z3Qtv3geafsR97o2DSDQq8QOoTKFjOUt52SZDoFPfjn3Krwt5aJxfe2Fm
Gpn7BMhnDXgB08CljQLME+iVxY+qgOpxuOmjVC08/B7CE6+8wDi2QuqU5OcN
FKRm0X0X49jyWt+6LkInXLAx2uW8jYYsAq9rJJaYQ7PGM+2rOxhI+rGWjhx3
I8xKf45T0UqFCHFRS7xeTXcv7Jhb348UdPpY8XrdkMje9oXIc2uFkjPTxLot
ry2naQ6Z/uO8fSXVzZhen0biUZYd2oE9UH//gMQqs9f/x+tdlHNbXGVRFqwY
YYnfYVOLHmoKmN65xgA2bwUzzWXmZY77nBdS4gbRs1gnKXaBKfhlN2/oprex
7PNDWbERuIviPMR/XF5kgNd9SqMuwTeor5yFnaz60YkmlXIzgm+McQ7nOG8f
Rnv2ZE18CiWhKaWhdTMqI//Hn0vVLbse4yF9QWMA8/kiqw16GA9DxRfqqoJz
UfHu8I0HbUfQwJfQ3pHcSRD7VcXweElHYymVb8zIrSg7nRrhDSmgK3YyKZmH
jJYcsDsmKj0B01XtfJUiR6ClpmpfNxEniczJE06EvuRLCy3EccKSfIBlG8Hn
8q5/2x8UQQW2F+H0lZN2wLrP8HVVWTcqLFl/mmxBRWyGFUuKPgzCSdEVBwX6
hlATm/cb22KiLpHNePJke4HX9PEtg0M0dCoqgv6IdxiZ9EcZr0ytBI+87Jll
lxmoVEoodGZlHbLYG/eutzUT3td5OOD4n1kexELEP6TeNPHD8Z8jNTqN84VF
Q7SKyBdo61nQxvkyOUl6bXdyDN07qc5hvG4Cseoac+952gmiGcx3ypXJSOPr
BcOqbSRUJj9Nl+Ztg9M2b0j4fObLqcBq5XUdqDpx5B0+n/n905aagUB19XKv
a5xEvqM/n//u/xvxxIoT+Q733tcO43xfvNAjjfdD1yYrft7VRAHTxIJsvB9q
aVX8Fe+bn5o5pXXp6Rgwc0XG4n1zCyF9L7w/3qZna2a7mgJ6nHLpeH9c9e6+
Hf7v6tFE7MAD3Q1kSMt4E4z30zfIK1/HcXsx6aMZEbfguSnEEMdtzOajqfi8
BDVTjmswYwSKd+ls8Ptvzkv8//X90VtjCvg83hOBpF/J5R2QpSDuh8/j/Qyc
scT6haTFyUvoF+jcv2kF1i+pQ+E1636Wg1XV661H8hiwaVuw2qvkUHgfoeqO
z0Man7lj3HT4Pbq/UVQan4e07eaxxbzonn9qMMGL0JzfagrmRRtUJ13xOUkJ
++ehG13fQ39kehA+J3nQUT71WA4DCWSV3r3+sRTabb9t4Vn2GsrnzjSNfqUj
fcVS1h1s9SjoynMuNeVqsHbYWI37SIfOjhTenOpEd+p3xeA+kpqcgy/evz64
+yF/G7GuZGGjRbx/LbzluzGfQTsSetEsz5FNBRe7LNVxp2E4zdT9CJ8T2NOo
bBHvxkCGNdMv8DmB6E0Nz/DztsStkyKeFx1IHeLGzyuxZKcmPiegYyK64mzV
FDKxODyg9e02JIw/8cLnNE5zyLDEMQ+Dy6c27rNuNHA2fym7muDnB0g1fgQ/
h7o7IjImBD+fe0rJxzwfHQyNIng+BDGJZmGe3zkksg7r6K18dZqEjkaHanbe
xzqab+UVA3yex7rswrdB8mswKr+sj8/zOJtT7+A+w7aU1k3P3w1ARGbDLO4z
/Lvx8JjT7Sbuq/AvnWN3X10HPjWF73FfJfaigtvpUBqSFuhe2qQ+DB/P/pxc
X+EDtwNFSvE51R28K4tHycPwKVnrKD6nGvIpWhX3c/gV6xsG58th9RPBPNzP
YROU5sz3nUZOqdOq/JE9cJlu2M8zFQeWHEyPcZ9nqt+75IPsGLxfmeuH+zx9
OpufeXU6wYJR14br+W3grLHJCkXQQdnkRAOOh32H1mwn4gH07Y9y4ngQLKhn
Fxeno0sxHL/WhLfCrXPHRpiK30Jd5Gx4y+gkOrzQ9XLjsREUr8I/9mUuHvZK
cew105lE+RLy3pcURtFJA8V6mesxIChazhAMHEfe8YViLr4UpDg26CU6EwYG
5iubFfNI6JWyEeOVxwTKtzpT8MXnKbgLbvuRRzxXODg/JJ4LpXKxtuLncrJ7
myi5Yxpt3CH8XHJPHxJITrhIfRUJ/eX3igvlxlCpptnM/FMqGvuZOqp35QHk
KQS5Yxz+liX0mcBhmBeJMcI4LGxG/4hxWDHIv4nAYfCeZn6LcfiUgUgD8+cJ
tL0k4rA/zzg8SwrnscpsANE0ia2Y72X90Lcj+B403jWhYL53IHGHJl5Hw+Wc
J4l1RKEPv9TgdTQsmPZmz59EzGHlLfsIflfwZbE/Y/wGHN/HKKRNdKKupUe3
SfDQEd8ucbJTvTW0tPhUJZrUoz3JrttyzjCQROin6D3B1+C8FiXnZ347Url2
08niKh0Js2+slzW+BldHpGYkyJ3wdVcrdwEnHdWuWSKJz11Yfyv4iM/PrI3m
e0Um5sHdRDgEn5855cyijM/P2Cddv2H8fQQlvr9pic/P6CjxtOG+UK/e7rqE
C+OoIHS9KO4L/U/nc9Bf53PWRMkpcYRNQs01Hw729hF0Snj3M5PbocDxqVQ0
ktDR7utjTxE6GhQjGK+xjlY2ipzCdTlhq9c7oi6DK/fKJ7gu8zO9m0ki6nJw
hfs3oi6joIt+uyqIutzwwzdvpSAF7bnSn+5F8DudzpHRcQtzMD1g33mbfQBd
uSgV/4TAh6dVJzc9SDsGpicvV+Fzbkt9RNvx/6m4H6F4uM1EDsLDtW1YYRjd
PnCcq5BYHzPyTkW57r3gJ28wf+wqCQLuWxu6Efx0y8tBMj6nFMbhMYT7aYY/
XaKar08iKYNdFrifZhzSsxafZ9OIvZ+M+0b593aO4fNs2WxW23A/sLLSJlT4
+AjKH5L8gfuB7Jd2fMX9N/n12k4u2yaQnZKDAu6/eSrzR2Odnip/4Smh05Gl
tIk+1ul7LnnF/D7/tmU181ui/lu/ZN6Pz7+5Jl4/hPuKAi/0Sua7BtBibJ89
7it6PXyw5eRVOrB1zHbNEXEhLzgaYkm7/n9dHfxPfV8Wldr4Us8ezT8KKhTe
7YSY7PSEewi+attM3hucVAR99Pynsyp9SLPquq3e4hRcs00dwTyc/oC0TSew
B51s/7oe83BexTV8qpLxSPoGtWSjKEJeMQtbmMoY8O2ketH8C4OygwbTHkYP
6tHT6NBFSVMGXI914V3VkoN+iq1dYrekH2k0WUZJTUyB6KchDh9aFhI9c5zF
a3sr8m2t4R+rov/Hnpf3Y4JoOME7CxOX/ZIh9Gn+9yMnrCrOQ3jpVq0vd3MR
ezPz8ssC4+hbtOeqtRUU2J71IvrYZ/My87beX1TrcZR3tTLvUBIFjopf08V6
J6SetozQO+jWtGgi1jsB/ltrML4NGmnoEfiGGrId2DG+OfqTd7ETebc9cNUG
Iu/gvVuiIonIuzdlCztmCR10J+TgUUIHgVTIymYtQgdJJD0b8yTy0WiJnjmR
j2DrW1GB87GuKrwG455yrZQdgXsQ8ahIKJPAvZe76zZgHff09HgNoeOQ7q/j
VVjHLd1krYn5Q3O2KhD8ATU8uiiD+cN+Nte08uk+JP1uie24OhV5c8T5a6YO
QFSIll/1hWE06FqmGWxPQau924o3bu+Fj3nHerDelFnRb0roTbhUeKAM682K
97JblhN5++PRZm+cx82zn9pwv5dFaI3ERgLXxi9vmbtO4ByzfWQerkf1KYq8
MaN+6MjHgpvyweNI/WXB22EfCrwRZc3FfNtGXIad4NuQKxTGg/n2pdx9nphv
c2RbnSD4Nhy/MjCN+fbJcvsWrBfypbZrEXoBHkyNbsN6IXVa0hLrBUmyeQKh
F0DgHJs01gvUGNppHM/9vtcliHgGEjPNG8fzfyqu/lPfc1Ykl+D/O7j6825+
Am/h0Svp3e0E3nrJcG5aQuBt7t5r8QWhNDC7zWCRJ/DWeyfzsSmi3j39OsdF
1Du4c0L7rjNR72zfeRm+IOrd6LLN4kS9A89MweWKRL3Ltr72Dddx3euS1UQd
h1V5w2rHiDpuErtWAvcZJA2Xdt/8MIz8lJgFcZ8h3c6K347JGS15feYj62Ab
OtStydf+kA7kEP+aSiZ/2KZj8v1g2jhwdCXs4rWngEiZmAC+f0/LeSpxP2i4
nebH9wufO/MW34/a3s4T9yNaRtIefP+7LnfylhXj6H7a2Xg/WTJsvtUTJ9jc
BbNHdz1UCiShj/ahJnCWBOa55w/JH+oA8h1aycLCBKooN3OXOzEGS2tt2NnO
tMLgoWqL6AoK6vw8ysg+MI62KRndL9sQBkaTLay3QvuQyUXpnTyC04itdUdQ
YPQ9SLy4bCfel2FPGwkuTqaAzuqgfLwv47UYNTD9egzlvnl3nXXDBBxosu4X
290BnFoHI6SIdTlSUhRG6FY07fBLG+vWs5FLU3F/gDlDp3m7TS2cpnpY4P6A
KefbMeOaFGCXPNrfx9wBXxTs1AxM6fAp3MJvpmcKPRaa2WSz0AfUD/zz9XKF
hH5sLvOL7kGejmsyCV2OogXPvXfacAbon47MnZgfR7Ntxoul82NQuZz+VGdv
///xOFT7srIVj/9sL599P3MHell2ZDMef9Ex12fmEgEoUsVTQlk7Dklm+pM3
ff/n9whkaceflkxMoit7Sq7nlA6jBYNA8S+tFbDNbfeJ69sI3uhwmLt7YhhM
c3lvnJ8+DV071bh52qYRJ3ORzoAdUa+/7T2a9iUf1swftcHrqLhFSYBYRwif
PfcJr2NqgQAX5s+izJJkgj8j5Ztp45g/856a9vchePh0ZNcygoejI2wGFzEP
31WUvh7jzw3vqasE/sDA9tpWjD/5PmZmtjvOlmkNfv3Y8pAMb9YXPrfIJINe
06cMPP7BB9mGxPghul1DDo/fWSL2G+7bFMWaXP8USoLeYL3z/13fZqs9z5I9
1S1w7Fouc8cwHY5FPz7GLhsCpcPK1fi9+y9ed6qn7amQrvogB793v3ztJyF8
/jkoZuh1JZkCbTdJcvj8M8vWBQt83v7iBeMvnGFjEFHbfwKft2fbftwMn7um
xu3qr95HAtuT+Vza2RPw3O3nD0ED07LqzcEmV89OwMS3nxe0+0lwO6dLnmZv
qa4ysktqfJGBjLTXy9xZ7wz3jpgNKhDjPMTbs4wYJ8qoEt2Bx/lCUfXjbdV2
2P889jnFh47kXw1z4/2L/XF1W5dUmJddD5FvJ+ojBM2P9+H6ePyi45W91gZl
HiM+kice1MOWk1+4pYi6X/A0c51Y5RSqZW5fWLNyAM49RKfwfqLXDR52vO57
j3pbE+sOyzd+0cTrHt6dYoz3Q3mPh+3Vjp9CEcoTa/B+6A7rG0F430Tv7cmd
3oiGjgk7ncf7JmEFsTTcl6TqfS3E/aeWDUdW4LjaXnvp9/svFoFhB2R3G4IJ
9+ff778kz3pbu+lsLHt58Mq2D3AXDkQZ/u7XCa8wj8Fx3kJRJytox0G1hwwF
x7mtvqoQ5jkec2kB60URkOvdd2Ge80/rXrNEL9SrtgKittxe2jZdjti3l2+e
sWaA/au2n5UXyuA4oyT+6aW3aDbA+6j3DgKn922wf70EgeamMftLz9pQYETP
rWEzOvi+/vYA48AX17hnZfMEH1+5jvu/w4GAuizy00oK7L/Z2eJxcBysXtbY
u+uaAnW/+sWTsW+Q14nBaFInCS0/oh7GojEB89r772Jc+kzuEyBwCbEvLf6K
cSnbYsAb75cYv1jmg/uFK60DipwJXBLnf9iFcTLEWPsWgZOIlWVPJ8bJA69v
flcu6EX3QmSqfd2oyPz73dKU2QHI3/+ynP8uGakNigqHFhD6ruOcy77bXlA0
/+2Ci+cQKjY7Y/OyjwYH5hRorBk3IY7jvDB+P9f18lwCD28/RFrs4yALpYHi
oZHXWBcXv+nyInQx5EVS57Eunsp6tYh1ruIeywpC54LLWBgD69y9W248xPO/
v3v6Set0OWzyPiOJ53/gijFbFTH/AR/5mYn5h7Gxwyfw/Ae65G79RfD+xJuh
5wg9CMC9ZZccoQftXhdM4DrFp9YXS9QpxO2gl4TrVM/DjnBcp5Ty3E4QdQoV
Be7TxHWKJhhZgevU5u1xTkSdQiYL4Vy4Th1PeG9feH8c5XfNeUQokyFuHbN6
UG0HLHDsORA9Qke77ejd+4urkT396Vlr83dg+o3ng5k8HTUrfygNY2tBp7iS
LzPHNoD4c6EtWZl1yN52pnxOdwL0lm61xOcfjq+IuDntyUC392l/SOcsQHJ1
VRpf5ioh32TN+LzLBPKAyuJj7uMgdnzXsQD9JmBl7YwT/k7kM/++ORa395Ah
yioYKZQCkg4b0oMdp1Gi69TC3P0ekIjh5S5KyAGOfdvnU0kUtJ6faVF19TjE
u4dpNH+Kg0fntrwviMyDpNgFbQGZOqgNCn49b8yAxtEHl+sk2pBjdh0rnUqB
Emu7K5snR6BG2eRL8Vc6snPN/qHSUocSrd7vtE2pAQuvBcm7W6iInkFyffFh
FB4xBY0K1tWBuljQCPPxIXWHyHn3vR7d6oMs3xbx+27KFj82HxSbQLaRDL/5
wjFU7yO/zG2mHaKquKXw+wUrR+qurDlGheptmjH4/YJ9sjPX1ayG0dnBtXF7
RSiwYaPjWzXdPujITB6JWhxFNuP1Y8HzZPAcaXLw0eqGRc55tlO84qB0Y9WB
JesU4aDxtU78d9Vk4taGpxM69uaZqpzwETi1Y+cG/F752uVfwvB5IdvnJk5D
TkMQbWyxOj8jHQLCvunsukBDDnuvPX53cxgM56Ny329MhoUTiU4ZNmRUZHyY
PHx3HMn3th4xWNIBs4jHUV8gAahiG2poB2TLDoY8vXTkGwOSPl8UEDmcAqLt
66xcSBGQ4XDynuQXBuTkJ73GfF54G78lwefhcqBWKObz8l2GU15cg+iWrZaG
bgkFPN2k3LR0+mHzxS2GCknxMHowZ+3UowTwWCLFFEr8zs7D+7pkNVwhvu6J
4aAeR1l563H1fuJ5p6uamaIzHoLpURf1VV+ug5X/hxnTXwzwPcm86kHABJpf
a7CjPJ2ErNzmBVXCJaE+6PTv82bhpL2O76krUIr45PkMl+NA/a/vDU4eWdJE
XQHF//W9syqSt1nTjAYbt7x4vJ4B9AiJjM8Fh6Dx/2nf2qOhTONwRXTRJKKS
FGVtSBeVaMaPkqncGk1ya4tasyO5hHWKQlmiHbKTpCSKEKtxJ/K6ltSkFoMS
mmkyU8xESop236/LP3tO//eHv75zfuc5z3me533Oe97zfe93s8MpvKgVzkcp
Dh+mSqBaTTO+Od8O9P9xDuog+ZhyKw4fJb5/Ghr5nxKpU8E1yS6U1SdFpIhp
LqXVhWBBvcb8ZeMB8DJeoaUf4W0qV/AZD5dS5rqJMb5cVE3/Sf02mNDL5bsi
pNCbZL+oUGcbJIezBzywnuBb3WVYDxqA2uJBrGf3jaGP0MxHnuhykLtAjGKi
5U9aFa7+7j58ucXwVRjW/6jhg5w/VYLC4izFD7D+h+KXZkda++CyaprgsIsQ
pZ9xgqYee2hMKU2j1r5C/D209jFeD0r0CLE119CCN67BBfPjpdAQFmsbMF6P
LHw2hLIqdkGROTmbmDdHKqwIHK+HfFb5UWI+Frum+eCZAaSRlneNf6wDGcTI
f+rZJyQzfc+ytmL+oMa7qaO8HnhREyAi+J309IpujbSipm42s3ejBNhZ+Yxb
b8kwMl3ZXb42C6T1D2d5vpPCFIVe+8VJ28H0QPq0C5NfQW7CkICp+wwYK11q
3/jQQVsl8Qy3mw+XRlVVZnWIQUONGUSm0KCtKiFjV7EABGU50YPrxFBHtm8I
CabB7k4nDwJv6SMxxHgkYNF3EHjFu7PCCDy3ZEomxqNcF5urBF6tKP1xIk8C
rwuKGk+pPkLeDDOShbMDUI/HvzXD68KRmNe6CcRAmyQ5ZI3XhcQJSzYJ6UYO
OYptr7X64ebAcNKnMhOQ3bMtSQ77Wu3oRcK+kI9er5cG9vWCo1Rcw+qHaPm/
PS2fd6HZ2ZLr3Kl0uCbzdAbh12DMvxf7RXmu1HrCL2dtIJfQ82C/QCda9RFo
9/vKEnqW37DKqcR5ytqFJeI80Z1tf45W4DwN7nOOxOe3orpAqsUw7sO68y25
RqoU4N9dk6+NeyggCUm4h4g5OW5fAe7hHe8D2ZasB7AoJu/iBmUparwzsInM
swLHow4hRM/1ru2NLasuRLqttxlEz8OPRc5tzpei9tSTjuz0GhTj8F49UEsf
2uO+9GE8+XMfID7gSx8Wf70XGvmzgyIEF1K+PHfC1q7lsqer+9GqGyLfKfO7
wP6j8XWLZ+bgdj/Tluit3WSbVtxb2HvlqRXRWzVJFO3jpyr0uiGGe7NOinbw
fn3i1rkZMjSPR3e0PAGbnO28eY/6kR5tl9HGrTtAr50SEYP5+TvOhcjO70LC
3AJngj+inbHrUksfYpZSFT1dhahMpo521tEEprFvrCR8WVm3WZ1Jr4EaUF9H
+HJa1rQmBeNZV3cvYLoKYdIHlmUCxjMs3j1f4vcKOm1NAlsCe2Elp69yhgcd
rP06Lo9hnY48v0asEyLbORx3rNM/IMWXinPeedo3DucMBxOyRoic3WymjRL6
87T3VGD9kD1n9RFCv/945qosAwnk/9uzxnlzG5pdHKSCpUNyJutC06J+1Jn2
u/n6uG6kfo+RlimzFBb/73/qbzl/3SfQ1Q2hHimp58ik4uE8WTUHk2/3Ot5O
VhAMOpVRRhg8EXGvw7rjsRYL77eqdc7/VuUIwTCh3YqM99tLW+fKs6V9SCk2
WGUORQimT5xYf9zUAQ03btA9rEf1nJGyYVw33CrTMcrCepr63EP/wj10qYqf
h3sIj5ly6sa4hyr18wbiMU/xMHWnEkWItM/VBkZgniZala6rvQDCtJlXFp4Q
I/0+vv2JkzTwCM8VETnrqc3wwTmjsSGVGiJnP8cFS4l87gk6Q3E+MHPKPAUi
n7VVUealanzEsJ7K7nZ/CaXPdR/GVm6E6SNNYuI8Xmm3bCxk9JBpuWahikh9
N1CRglcJxm8aOa7d4/4Spc5MPsXC+FRuNMe/pxXZlVyoUTaTIM+XVfVSGQqY
uDXY8bUESH795tkPMsRoC1nk6idaDVWatolz5NqQpNEtar+xBD00+61Dt5QM
Nqcj7Qlfhb2WEdgXZGZwgghfvsXk8gDM/yl0kI354TFvieEg5heGKG0XYP7s
vnA6N0MMQz7PLA9jfp2rMleUML+R9yQnzA/GSioW+pjfa0uUWUlAP1x8v783
0PIp3M2UayoxoIOd7Mih0S0D+DzbPsDv7AT2mHflzAr6D/c+amI+MZ+YT8wn
5hPzH2F+dsY+dWN8nh9SXkQZ1OpHCy+Qto3j8/z38P8B1QIgag==
       "], VertexTextureCoordinates -> CompressedData["
1:eJyN3X+wV3Wdx/E7+At/RKJj66Cssii6SUU7aK7FHi1F0ojU1a6TprBiq2Yq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       "]], {}}, Axes -> True, AxesLabel -> {None, None, None}, 
    AxesOrigin -> {Automatic, Automatic, Automatic}, BoxRatios -> {1, 1, 0.4},
     DisplayFunction -> Identity, FaceGrids -> None, 
    ImageSize -> {240., 228.42203883498607`}, Lighting -> "Neutral", 
    Method -> {"RotationControl" -> "Globe"}, 
    PlotRange -> {{-1., 1.}, {-1., 1.}, {0., 50.}}, 
    PlotRangePadding -> {Automatic, Automatic, Automatic}, SphericalRegion -> 
    True, Ticks -> {Automatic, Automatic, Automatic}, ViewAngle -> 
    0.43782284161739216`, 
    ViewPoint -> {-0.6963345062035325, -3.007699426096691, 
     1.3852300955898662`}, 
    ViewVertical -> {0.09233465324907704, 0.39882395761228057`, 
     0.9123671205407671}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->362065001,ExpressionUUID->"c7a3a850-2729-46b8-8a63-85a59bf0bfbc"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->362820769,ExpressionUUID->"2885c994-08b5-48a2-8b85-ea621e19163e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties of Limits", "Subsubsection",
 CellID->190490095,ExpressionUUID->"be835001-8e3b-401d-a3c9-9183c809f102"],

Cell["The properties of limits are familiar from real analysis. If", "Text",
 CellID->79802254,ExpressionUUID->"398c4daa-0ed8-41d4-8c3c-943b006a079f"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "a"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["w", "1"], "       ", "and", "      ", 
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"z", "->", "a"}]], 
      RowBox[{"g", "(", "z", ")"}]}]}], "=", 
    SubscriptBox["w", "2"]}]}], TraditionalForm]], "DisplayFormula",
 CellID->6017166,ExpressionUUID->"60f995bc-3cd4-4f99-b4f1-195515d94ec7"],

Cell["then:", "Text",
 CellID->1188640,ExpressionUUID->"56375a6d-7a4a-4cdc-be21-65ac6c57293e"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], "+", 
       RowBox[{"g", "(", "z", ")"}]}], ")"}]}], "=", 
    RowBox[{
     SubscriptBox["w", "1"], "+", 
     SubscriptBox["w", "2"]}]}], TraditionalForm]],ExpressionUUID->
  "da88307a-5088-44f5-816b-9b6ff23270ba"],
 " if the two limits on the right exist."
}], "Item",
 CellID->29692211,ExpressionUUID->"0d48a509-cf0d-47ee-95de-9737af8d9bc2"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], 
       RowBox[{"g", "(", "z", ")"}]}], ")"}]}], "=", 
    RowBox[{
     SubscriptBox["w", "1"], " ", 
     SubscriptBox["w", "2"]}]}], TraditionalForm]],ExpressionUUID->
  "ec3f2078-cc24-45b4-b95a-64d411616fb6"],
 " if the two limits on the right exist."
}], "Item",
 CellID->57923086,ExpressionUUID->"72166d4c-d6c6-4a75-855e-b2f646f340d0"]
}, Open  ]],

Cell[TextData[{
 "And if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", "A"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5c6c305d-e955-4d54-9f2e-da007d542db2"],
 ":"
}], "Text",
 CellID->91365266,ExpressionUUID->"44b23204-5ca4-47ae-93bb-9283030768bf"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     OverscriptBox[
      RowBox[{"f", "(", "z", ")"}], "_"]}], "=", 
    OverscriptBox["A", "_"]}], TraditionalForm]],ExpressionUUID->
  "a6444392-2151-4100-b170-227b47b5b67f"],
 "."
}], "Item",
 CellID->370810246,ExpressionUUID->"389a3b9b-28a1-4d07-8885-d20e1d82c7aa"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     RowBox[{"Re", " ", 
      RowBox[{"f", "(", "z", ")"}]}]}], "=", 
    RowBox[{"Re", " ", "A"}]}], TraditionalForm]],ExpressionUUID->
  "36e02353-12c7-47eb-bc5d-4dcd7c27ad79"],
 "."
}], "Item",
 CellID->167156167,ExpressionUUID->"0dabc763-2c98-45d2-be98-afa216bf2917"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"z", "->", "a"}]], 
     RowBox[{"Im", " ", 
      RowBox[{"f", "(", "z", ")"}]}]}], "=", 
    RowBox[{"Im", " ", "A"}]}], TraditionalForm]],ExpressionUUID->
  "2da5b7fa-2a1a-4592-8a1d-ec651fe65d89"],
 "."
}], "Item",
 CellID->125940498,ExpressionUUID->"6c5f0c55-3a84-48e6-b979-2abf794b147b"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Continuous Functions", "Subsection",
 CellID->225749355,ExpressionUUID->"41ac74d9-95f3-4c16-8d95-7cc4367fd561"],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5c63145b-ee74-4c86-be6d-e89fa47a3550"],
 " is ",
 StyleBox["continuous",
  FontSlant->"Italic"],
 " at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9af3400a-bb8f-4f37-8a8b-11fc80ba7cc5"],
 " if"
}], "Text",
 CellID->464313472,ExpressionUUID->"b9eba9ec-b04c-41f1-ab31-bece17e9a646"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"z", "->", "a"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"f", "(", "a", ")"}], "."}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->118273987,ExpressionUUID->"907459b3-7056-46ad-b72f-14f1c03a01ed"],

Cell["\<\
The definition is the same as in real analysis, although the limit in Eq. (2) \
is the complex limit.\
\>", "Text",
 CellID->654766572,ExpressionUUID->"c472abcd-9732-4240-b0bf-f37e462fe12c"],

Cell["Examples of continuous functions are:", "Text",
 CellID->232235834,ExpressionUUID->"f4a4e4f5-d000-48dc-ae9d-574b61ce501c"],

Cell[CellGroupData[{

Cell[TextData[{
 "Polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sum]", 
     RowBox[{"n", ">=", "0"}]], 
    RowBox[{
     SubscriptBox["a", "n"], 
     SuperscriptBox["z", "n"]}]}], TraditionalForm]],ExpressionUUID->
  "d10223e7-7564-4d60-87ca-db343ff6e2c6"],
 " are continuous for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "\[Element]", "\[DoubleStruckCapitalC]"}], TraditionalForm]],
  ExpressionUUID->"5ba3d38d-4aac-4e0e-9c1f-6ab7d29694b8"],
 "."
}], "Item",
 CellID->71653335,ExpressionUUID->"9b7b0ad4-bab0-4e47-86d4-1d60780ef363"],

Cell[TextData[{
 "The exponential functions, and therefore sine and cosine, are continuous \
for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "\[Element]", "\[DoubleStruckCapitalC]"}], TraditionalForm]],
  ExpressionUUID->"3035c3fc-e399-4486-a119-c17e2511b54a"],
 "."
}], "Item",
 CellID->353181038,ExpressionUUID->"0094e3e5-440a-486e-84cd-f06585c156b2"],

Cell["The argument function, except at its branch cut.", "Item",
 CellID->36501409,ExpressionUUID->"d175e46e-c22f-43ff-9c66-5272c620ec17"],

Cell["The complex logarithm, except at its branch cut.", "Item",
 CellID->25969572,ExpressionUUID->"3a838bd7-5970-40d5-8872-25d0623f66b8"]
}, Open  ]],

Cell[TextData[{
 "In Wolfram Language, the command ",
 ButtonBox["FunctionContinuous",
  BaseStyle->"Link"],
 " can be used to determine if a function is continuous."
}], "Text",
 CellID->5631740,ExpressionUUID->"84506747-5892-470b-b461-b928458c5268"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->440251404,ExpressionUUID->"e47e1c44-6042-4a5d-8ffb-2c1b307b893a"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["z"], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], "log", " ", "z"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"16c9b4be-f9bd-4873-8fea-a3cd5af4a6b7"],
 " is continuous except at its branch cut. It is not continuous in the whole \
complex plane:"
}], "SolvedExampleNote",
 CellID->666722247,ExpressionUUID->"40571330-e73f-4f25-8169-b4e0d1dd66f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionContinuous", "[", 
  RowBox[{
   SqrtBox["z"], ",", "z", ",", "Complexes"}], "]"}]], "SolvedExampleInput",
 CellID->377893771,ExpressionUUID->"8dae8cad-5c72-478c-8f6c-230b7e4091ab"],

Cell[BoxData["False"], "SolvedExampleOutput",
 CellID->44624716,ExpressionUUID->"6dba8234-caae-473f-a9d6-9ad7332032e3"]
}, Open  ]],

Cell["But it is continuous away from the negative real axis:", \
"SolvedExampleNote",
 CellID->468383221,ExpressionUUID->"993088c1-218a-4afb-a83b-c7c0c2b8ef66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionContinuous", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SqrtBox["z"], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "z", "]"}], "!=", "0"}], "||", 
      RowBox[{
       RowBox[{"Re", "[", "z", "]"}], ">", "0"}]}]}], "}"}], ",", "z", ",", 
   "Complexes"}], "]"}]], "SolvedExampleInput",
 CellID->272736283,ExpressionUUID->"618c9a6d-e33d-4f26-a0f6-b2f6451eb066"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->14314436,ExpressionUUID->"83154506-0020-4fa7-bbe8-fd31cdfbbe04"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->39009084,ExpressionUUID->"19576807-a94d-40a2-9fcb-e4d9f320a93f"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s look again at the plot of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["z"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b930c3d6-0e96-4757-ae20-a9d712b15534"],
 "."
}], "Text",
 CellID->87222540,ExpressionUUID->"253487f2-ec86-4f90-b1c8-632ef7e4b7f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot3D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], 
      RowBox[{"Log", "[", "z", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "3"}], "}"}], ",", 
    RowBox[{"PlotLegends", "->", "True"}]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["464", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, ("Fig. 3. The function " <> ToString[
       Sqrt[$CellContext`z], TraditionalForm]) <> 
    " is not continuous along the negative real axis."]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->15395625,ExpressionUUID->"dd2ba492-5625-42d4-b3d7-c294a48f0d08"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       Graphics3DBox[{
         GraphicsComplex3DBox[CompressedData["
1:eJx1nAuwV9V1xi+aUWgSBbVoEYMYW5kYogRKLIJrBytJC/iglRBwghAFjLG+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          "], {{{
             EdgeForm[], 
             Texture[
              GraphicsBox[
               TagBox[
                RasterBox[CompressedData["
1:eJzFm3m4l1W1x3vufR45gN0mM8vfAZxQEVFQEEMty+Ysx7LUShNnydDEITUt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                 "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
                 RGBColor], 
                BoxForm`ImageTag[
                "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
               ImageSizeRaw -> {144., 144.}, 
               PlotRange -> {{0, 144.}, {0, 144.}}]], 
             GraphicsGroup3DBox[
              TagBox[{
                Polygon3DBox[CompressedData["
1:eJxNnHnAjUX7x59z3+37vpcUoZRIIimkVNYQZU8oEikqvESpVIqSFEq2LEmW
SLZCEhEKUSpCFMqS9uU3n3c+9++8f0xzrplrrrmuz8w553nu56vCrTrV65gU
FBS0PrSgIA39k+E/2OeGdkFoYbjgsNCKhnaIdpHQDtYu5vzhoRUuiGuJc1Fo
R4V2dGgXhnakdsXQzgrt7NBKhHaEc8WNgX1laGfqd57xDgrtfHv2LmnsY0Ir
FdpxoR0f2mWhnRTayaFd6tgJoZV17JTQyoV2aminhVYhtDPcr3xop2tfbOxj
Q3svJNA/tKdDu8Qx9rvCGKy53NjEvTq0QjKsG1rp0MqEVsecsK+VI1yrWhv2
Na6DZTXnOYfr7OF9o0xhXEMW5PtSaN1C6x5aZWPAr7p84X2DPeuvN15xc4LT
iaFVcR051TQ2ddeTLyxvtibs2p4BtdV3Hh4N7OF9q6w521rGY03jgngnrgrt
Jmuinoby5Uwa2bP+FuMx97K19jCXEz37pqFV8hzukCP8Wskd+3a5Y7d2Hh7N
PQP43SVr8rpTdtgPhXabubeVL3NtjIH9oDXj18J4cG1pz97tjM0ZdpALLO+V
L7zvcYy709kxGN8vX3g8ICP26yo77PbGrimnJrK52zH262IM1txn7AYyxbdZ
aM+E1jG0TqH1Nyfs3nKE68PWhv0f18Gyj/OcwyP28H5cpjDuJwvyfVF2MO5p
DPj1lS+8H7Nn/aPGayNr7hf3qZfryOlJY1P3APnC8llrwn7aM6C2gc7D4zl7
eA+WNfk9ZbwO1spd4948YU3UM0i+nMkL9qx/3nhd5MjZ8jkxVO7w+z60ZaF9
HNoIWcPyVVljD9MXTq85D+PhjsFgpGNwGidreIyWKSxHOY89xjHOZ6w9Nb1i
PPZ+3TFijTcePCbLF35vyhd7ony5O285D9cp9vB4W76c/wTjsWZmaEMK4mfb
IeHLZXuuoGBHaNPkC9fp9qyfajzm3nEdnxPvyneYTCeZ4zyZwni28/CbY0/d
852H8Xv2cH3fHn4fyAs2C+ULy7nGYI8F+jL3oecBv0X6sv4NOfGeW2w8/GZZ
BzUsN3d4L5Uv65bZU9sK5+H9iT28V9rDaU1oM2S8uiAyheUS8+IcVunL3EeO
sd+n+nJuP8h0uXs/49mv8wzI/WvZwewrmWJv9Aywv3EeThs8D85hi3zh8a28
sH8Oba37bJY7c5uMgb3fOvH7wnicyZf27L3V2JzJduuE605rguUOx2C8yzG4
/ihTOO0L7TP32yNTOG0zNlwPmO/noX3nGPv9ZAzW7DY2cX/Rd31oh+Xi5wK8
D83FnLD/lCNc/7A27F9dB8u/nOcc/raHdy4XmcI4zUUW29yTc+N985sx4Pev
fOFdkIs96/8x3iZZz/Tsf3cdOR2Ui7Gp+4hc5AvLw3OxJuxDcvEMqO3IXJyH
x1G52MP7+FxkzdkenIvxtlsr+XJvklysiXqOyUW+nMlx4fVez+roXIzHHN8D
fAbzvXtCLsbmfp2Yiz3ndkYusobl6bnIGvuUXGQNpzNzcR7Gp+biGAzOysUx
OF2aizWwzzm5yBSWZ+fiPHahXBzjfM61p6bTcjEeexd2jHM7zx7GxXORKYyL
5iJT7ssF9tyjIrnIjrkS+sL7olxkDZtSuciLXM83NmtKmztsLnQday4J7VjX
lDQG7Mvoe1Jol9mfHNp15lQstCusDa5lnYfr5fawLO8851DBHt5X2sP46lxk
B7OrZArjcsZgj4r6Mlc5FznCr5K+hczpMDleYzz86lo/NV2vH7yvlSm8q9lT
W3XnYXyDPcxutId3bVlzL2qGdrEsq5gX7G/SF65VHWO/WvqWktkvvu/rGI9c
+4d2T2gdQ2skR/g1lDt2fbnD+1bn4drAMfjd5lhF45E3+zSRNfwaO4/d1DHO
pJk9LG8xHns3d4xzaGFP3W3kC79W8oXrHfbcndtlwVxbfWF8l3xh1kFG5NrS
2FVlUcfzvNN1rLnbM2BN+9BqaHfS9+bQ7rWvF9oj5tQ6tC7WBtfOzsP1PntY
dnWec3jAHt4P2sO4h+xg1k2mML7fGOzxkL7M9ZQj/Lrr29Qcuae85/5jvObm
dZnn/ai5w7u3TOHdx57a+joP48fsYfa4PbyfljX34knZwbKXecG+X2jtnHvY
MfZ7Sl/WP+PZwHuArGH5dWjvhfZ+aFvTyGtwaC/IFJaDPAPsccHnmTRyGmgM
zmGofOHxsryw38jF9wn7vyR35p5N4+shoU20TvyeMx5n8rw9ew8zNmfyqnXC
dZSsYTnCMRiPdgyur4f2hJwmyIX9xssUe7ix4TrJfJ8N7RXH2G+cMVgzxtic
1Zv6DpDla6GNDG2+OWFvD/V+l0auU60NrpNdB8vxYf6xNPJ/LvQDQnsxvJ4l
UxjPlgX58nl/wJ9l3jIG/F5II+uZob0jd9Z/H8Y/Cu3xNOYEJ95nU1xHTnOM
Td0L5Dva+zFSe55nQG0LnYfHB6GNlfdHsuZs5xqPNcu8EzB+15qo50P5ciZL
7Fm/2Hjj3P8Rz3upsYn1sfE4h5WhtoXUD7vQpoWxVaGtkDWc5oTxWaENDW1Q
aDPC2GehfS5r8tpuDeyzw57cPzEGzNb+D+N19qwfnMbxNTB3HTmudB3nv8Gz
hPc38oX3Rvlyd76y5059KUfmNukL+y1yh9N3siPvL4zNmvXWxH7fhrbINdvk
zpqtxsA+NIk1k/sP5r48tD/Nj7xmhBpfCe2J0JaFNiSNnHfqC+/FYezV0IaF
tju0b0PrF9oBecH7V/ODB+8hPp/4bNplDHjvlyW8f7Zn/aY0ju8L7S/z4vNs
t+vg/Zux4fGPrOH3t77Yf8iX2njQullOuST2MD44iXy5F78b70tr5d5xt36x
JupJk8gUxgclsWd9ksR4zPH9wPct38eHJXnetUNdpUK7lPdpaHvC2DFh/q3w
ekRoPwX7iCSyhtP+MLYvtM2hHZnEMRjsTSOb48JYkSTWwO/6JySRKSyPT6IP
9olJHON8TkpiT01HJTHej6GdnMQxzu2UJPYwPiuJTGF8ehKZcl/OSGLP+ZyW
RHbMnRNe/yvvc5PIGjbnJ5EXuZ6axNisKWru3M1CSVzHmvOSyJo1hY2BfYG+
cC1mf3hoFZKY05mhXZTE2o4OrbjzcC1hD8uSzsP/YvtjQ7vEHrZlksgOZpcm
kSmMLzQGe5TSl7mySeQIv9L6nmhOf3k3LzMeftWSWD81XakfvK9IIlN4l7en
tqtCOzuJjCvZw+xqe3hXlTX3orLsYHm5ecH+Gn2ZK+cY+1XRl/V9QmsV2h2h
XWs8cu0d2u3O1ZAj/G6SO3Z1ucO7pvNwvcEx+NVyrJTxqrpPHVnDr7bz2HUd
40xutofljcZj73qOcQ717am7cWgV5ddQvnBtZM/duUUWzDXRF8bN5AuzljIi
1wbGLieLaz3Ppq5jTQvPgDXNjVFZpvheF1pr++tDe8Ccbg3tLmuDaxvn4drW
HpbtnOcc2tvD+257GHeSHczukSmM7zQGe3TQl7nOcoRfR33rmiP3lPfcvcar
Z17FPO+HQrtN3l1kCu+u9tTWzXkYd7eHWQ97eD8sa+5FT9nB8j7zgv1/9GXu
fsfYr5e+LeXI2fLeekTu8F4T2ozQZob2hKxh2VfWMH7MHk79nIfx446x5knH
4P2srGHztEzh/YwcmRsoX+p4ynX4DXAdc885T00jkvh+4704RL7wGyRfuL5g
z915yXm4vmwP16H2MHtVvsQdLl+Y9Tdfch2mL3PPmwv7vaIv6/8K7avQvg7t
NXOE8ajQHpXlaHtYjrGH31h72L9uD+Nx9nAdbw+nCfZwnWhPvpNlB9dJsuYc
3rRn7i3n4fpiaA/KcYpj1DdHFtQ3Tb5wfTu0wa6bYc85zLSH9zv28J5lD+93
7WE52549RsoJRnPdkzOZZ8+ZTzWvQfpxZ7mX852H9/vGgveHsoPZYpliL/QM
YL/EeVgucoxz+MgxuG40D/ZZFtobcl3qPPbHjsF4uT3n8IHx2HuFY7D/xB7e
a2UHs09Dmy7jz+xhvMr6OYd1+sJ1vUxh+aXsyHWlsVnzlbm/F9rnrmPNF54x
azYYA/trfWH5jf2C0PaZE58TW6wNrpuch+tme1hudZ5z2GYP7+/sYfyD7GC2
Q6Yw/tYY7LFdX+Z2yRF+3+v7sfm+5tnvNN4K8xrlee83d3jvCW21vPfaU9vP
zsP4gD3MfrGH9x+y5l78JjtY7jYv2P+qL3M/OsYZ/q4v6/80Bufzt9zh/TO/
M4S2l5+r08gRfkkauWP/K3d4H5TGebgictgsv4PTOAa/09OYN3semkbW8Dsk
jfPYh6VxjDM5PI09LHNpjMfeR6RxjHM4Mo09dZ+QRr7wOzaNfOF6XBp77s4x
/Cwv+xPT6Avjk9PIF2anpZERuR6VxtjwOyONufP5elIa17Hm1DSeAWtOSWMM
7DPT6AvXs9LY/5PE3zPI6fjQzk1jbXA9O43zcD0njT0sCzvPOZxnD+/z7WFc
LI3sYFY0jUxhXCiNMdijiL7MlUgjR/hdoO9h5rTPe1rcePhVSGP9Z/o7En7w
vjiNTOF9iT21lXYexmXsYXaZPbyvSCNr7sXlaWQHywvNC/Zl9WWuZGhHu185
fVn/QGiNQrs1tPLGI9euoTV0rrIc4XeN3LGvkju8qzgP10qOwa+qY0WMd4X7
VJM1/K51Hvs6xziT6+1hebXx2Lu6Y5zDDfbUXUe+8KspX7jWsufu1JAFc3X1
hXE9+cLsFhmR602hXeSaRubOed7sOtY08AxYU98Yl8sU3ytDu82+YmgdzInf
m5tZG1wbOw/XJvawbO4859DCHt4t7WHcWnYwayVTGDc1Bnvcri9zbeUIvzv0
vc4cuae859oYr7p5neV532Pu8G4vU3jfbU9tHZ2HcSd7mN1rD+8usuZe3Cc7
WI6U+12hddaXuXaOs9/9+rL+QVnD+CF7WKLvuaMg6k56yhF+/5E7djd94d3L
ebh2dwx+DzsGv6fSqI1D19VH1vDr7Tz2I45xJo/aw7KH8dh7amijPQc+qgoX
RL0XGjq0WJnmjh7tV6Z7O68g6uOK64dOroQ2OjU0WiXjx9Z/fYmLTu0S5/7x
O4rvHnR46KzQgB3tOuwjHSMu+rZSrkcXhj7sUnOC77UFUe+Gvgu9F9qrMvqh
wbpMGz1cOf3Qyl2hjWauvDa6OjQ7aALR4aHhQet1srGJdYZj5eWF1gbNDRrB
iq5BF1hEXoWcRwd2vLmXKshr6arpV7Ug6rGKWFNV+V6vH3yra2f6ueoyRUNV
Q3bouG6Ue2Xzu9CxGzyTKs6VdB1rDpFpEVnXMi651taGFxqtTE9HX1++/L26
rhwb6pdp5hpaPzquJsZFs9TeuB204VvPWHBER3WrXBtrV3CskXnd4/qy5lLP
mtFrNZMduqw7ZHp7QdRiwbiVdhXHWsi3jWvghbarrZzIt53sWrjH1e7T1PNo
6/qb9M20e3cZi2dmP/jcF71VR2sgj94FUdcEV3RZmQ6OvrN8O7kGvl30g29X
bfiisetmXuiy0HJx7+rIDL73GguW6MgekO9D2o0c6yqnPuZXz1zutf6e7gGv
Rwvy2rpHXNPSmnrJpa9+mX6ur1zRbvWTay/jlrbmOvLtYW2wRPf1uIz7ad/p
GHG5T08Zl/vxtDas+2vDDo1Wpq2jHygXdEPPyHSQftQ8wLlMSzfIPdApjZMd
2rFMozdYP84DDdgQa3hZu7N7DrC+oc7BdJg2LEcWRL0XLNFwveJ5jNDu5dhw
+Y5yDSzQdI2WEzm+Lt/h7gGXCdbQV99RMsU309+NNRbsJroGlm9okwv6qXnW
hNZrshwn6Qe7N7Uz7d1b8p2qDdNp2jBCvzNTlui8pstrsrEy7d00eaG9mSVr
1qEt6yO/EfKdZVxqQPe0pCCvq5svS3RZc+Q7Txum7+sHowXaMFuoDWN0Votl
hkZskaxnm98YxxYW5HV+s+W92DXoidC5oHcZb47ERbvEGDqbTEuXaevoV8gX
LdwyOa7SD17LnYPXaueyuFvlhXbsM7l+qh8s1zoHu3Xak91zuVw/d44612vD
C63XVwV53dsXct2oPcexDTL9xjUw2lwQNV2LzXGLvDa4xxJ5bfMMNrn+A32/
lfe3xuLMt7sGPd0ObXJBS/WHNaH72inH7/WD3Q/a8N6tH3x/1IbpT9owQru1
X6ZovvbKa6ex4LvHNfDib9QHZL3fNRPN9SP5HjBuprlcKt+/rAGWaLR+k+8f
2pn27i8Z/aMNs3+1Ycz9QtcFM3Rf6MBg/av5wZGxfz2H35yDN+tYM9+cNsoX
nRd3Gl0POhN0J7BDu4X2C6bondCHwQXdE3amvcMPZvgyB1/0XcxlOjk0YfBF
/4UODH6MoR8jb/RJaAFgjS6M9bBkjPXUgNbrZN97aJzQP8ELfRd6Lzii4ULL
BVf0YNhwRNOFHxzRdp0lIzRdZ+fyOrnCubyuDq0XZ0yOx8maMdbAlX1O8TwK
u4Zn8zxD5rk2TIuYa6axKyq7YtrwKq4NvxLaML1QG44XacOlpDYc0XddbH6l
tDMtXRm5o/O6VI5ltOFYVj/uJfxOz+V1dWWtB/3V1XJEk1VOv/Lamd6ufC6v
t6sg34ra8L1KG3aVtAsZG/sQ2RSRZWX35kyqaJ/q/uTHe/5Q18G3qn6Zxu5a
GaHzyvR09DfImr9XXyc7NFw15F7dOTjWco646JFayBFtWKbLq60fTOs6B+Ob
tTNtX3VZ13MOvvW1YYRe61aZogG7RaaNtMs51kCOjV0DO/RcTXJ5nVxzGTVw
D9jcbg1X6dtYvvhm+rtmxoJdK9dkurpWubwuras1oe9qK8fW+sGujTa879IP
vmi72sn0bm0YoZfoKEs0Yh3k1dZYtRy7W17ote6VdUfXFDHvqrm8Do+4F5hf
tVxeS/eALNFk3S/frtowfUg/GHXThll3bRijp+opMzRdPXJ5PV9nOfZwTQP3
uU/ePV3DeTxsLFj31s40dr1zeS3dYzJFN/SIXPpqwxRN1xO5vA6vr3yfdA4W
aFOekSXasafkx1h/80DjNFzWT7kelgNcT20DtannOW3YoQV7XpYvaKPHe0Hm
aO4GyzbTxrEePR5auhflhc4r09nRD/GM+5s3XIfq19N8M23dMOfg+Kr1wHGE
Nlxf04bjSG04jtKG3WhtWI7Rhi86rrEyHacNo/HaMJugDS90NZPMHZ3XRHlP
0objZP3IFa3THJm+5Rz1oH2aJTO0V2iw0OJNlTPaPHR3aMU+S6MOD+3d22nU
4aGXQzeHrm6GXNF6zZTjLG0YzTMPWM527+HmNdszm2J+T1vTBJnOdz36LXRG
38kLrdYi+aITe0++C7ThuFg/WC90DqYfOgczdFzL3I89lsiRsaXmiK5pQy6v
w/tQvstdD9MV2tTwiTZau5XyHZhGLRg8Z4fX76ZRj7ea8TTq7mCw0vXo5dDf
zcjltXSZto5+jZyWmje8P9dvtvlmGrf1znEGX1oPTDdqZ7q6jXL8WhuO32jD
bpM23NGAbZbvFm2YbtWG0TbtJZ7bNnnxbOT7XF5HuF3e32vDcad+5IrW6TeZ
7nKOetBcocdCZ7dbdj+kUXuHBg8tHjo7tGFo7tDZoRtDc4dObq8c0Xnty+W1
dPvleED7NbnMl+Wv7r3BvH71zHabH99bfBb0ke8f1gBTtEx/yghdVqano+ch
Laz/1g926Lbwg/s/zmX6OebYHw0S+iQ4ogfLdHn0+MEU3RdzMEb3hc35see/
sua5FXPwReuFjYYOzRy6LnR26LbQvKG7Q4eHDoy6GUfXBUf0XOi6YIeGCy1X
po1DuwUjfNkDLuinqAHu+LIevvhmmjt6YsESTRdrMi0ddqZFKylHNF1ovOCI
Ngw/2KERO1Pu5+oH38LaMD1PG0bodorKFB3X+fIi9tnyPd818ELLU0zWRV2D
BpH89uTy2rsLrAHNFDqoTD9HDbBEk4U262hrukimpfSD0aXaMCutDWO0VWVl
h6arTJLX8BWXYxnXHOk+JTybsq451bwuT/JaOnLd6P3lHDL9XCWZohWqIBc0
YBVleo1+MK2sDa8q2rBAI1VNXujBqiZ5rd5VMq7qGnLi96L6Mq7mGvK9xTkY
X29cakOvVV2O6L5ulGsNbbjX1IZvLe0L9b1B1rWdgx3arkxzV8e54u5zfZLX
29VN8rq6TGdXzzl+F+R3AH72h29Da8h0ae1kgL6riXzRZjWSL3qw2+TbTD/4
NteGbwttOKHjaiVLNGIt5dvEWFUca2ENaGday7eVazL9X8Mkr8Mj7hnmVz7J
a+nayw/N152ybqcNxw76we4ebVh21IYZv/t2lhdar05JXs/XRr6dXHOD+7SV
cWfX8DydZ5Q8y4Qvmqz7rQP9V1d5od3K9HT03eWL7ulBOfbUD17dnINXL+fI
F33UQHmhF8t0eQ/rB8s+zsHuEe1M29dNro86R519teGFputJOaIBe1yu/bTv
dOwxmT7tGhih9eovG3IckOR1e33l8rw13KPv03LEN9PrPWssWA5yTaarG5Tk
dWmvJ3ld3UtyRA82WHZDtDO93cvyHaYN0+HaMELDM0KW6L5ekddLxurl2HB5
oe0ZKesRrmkvv37yHWlcakAPNSXJa+nGJXnt3Zgkr70bm+Q1duOTvMZugsze
0IYxOq7JSV5jNynJ6/xGyXGSazLN32h5T3YN+iB0Lrs9mylJXifG2K4kr5/L
9HT07yR5Hd7bSV5X926S1+TNkNcc57K4K5K8xi7T3M3VD5bznYPde9qZtm+m
XN93jjoXaMMLfdeHckTDtUiui7XHOLZQph+5BkZoupbKhhyXy2uhe0yR1yee
wVLXZ9q7TIv3sbE481WuQVuH1mu1uaCl2mJNaL3WJnnt3aeyW6MN78/1g+96
bZhu0IYReq6NskTn9YW81hprjmMbkrzG7mtZb3QN77Fp5v6e88QdbH7Tk7yu
bqss0Whtlu8W7Uxvt01G27VhtkMbxtyvnTJD9/W9rDeZ3zLHdiR5nd8mee90
DUzRdv2U5HV12Oh60JmgO8m0dJm2jv5n+e5zDRx/1Q9e+52D12/OkRNahL/l
hV4s09b9rh8s/3QOdn9pr3XP/XL92znq+de4MEKvlWnr6NF+wRQ9FwIJ2KHn
wg8u6LiwM20c2i044Utc3sfoqpjL9N9dkrzeDg0YLFmHDW/GiAtTtFdosDJd
3bFpXpeGngqW6LvQe8ELnRh+1IkeDBumaLrwgyPaLmx4oenChgUaHnRcsEPT
hdYLZsQmFowZYw280PWg74Ev61jDHUQ7B69Mh0dc7gS5H5PmtXTn6Yc+C51W
Yk3nyreIfvAtqg2XC7RhioarhOzQdxVL83q+s+VbzDUF7nOO51TCNbyXUveH
Nbqti8z1Ym14odHK9HT0ZeSLfqyUHC/XD0bltKkfjVQF46JHutG4NbThW9pY
cEQzdoXnUUH7NMfKmVdN12eav9LWjAasouzQblWRKXqwq2VcWbuQY5Xke61r
4IW2q1qa18xVl10l9zjLfa70PKq5vri+mRbvemON8/OLz+BMY1fTPNBVNZMr
2q1MK0dfV761XQPf+vrBt4E2nNB0NTIvNFroujKt5MXyrWMsWKIju0W+jbTL
OdYgzevnmsu3ruszvV1jeaHjyrR1LV1ztTU1lUsr/eB0h/aHoY1Ko36tkr7E
Pc6aL0nzWsBbZYkurLWM22pf5xhx+T7l5xV+BuFuoYG7K83r7dqneV1dJ1mg
z+tgbR214dtZv0yT11HW9zlHTmjpHpAZ+rz7ZckYmtBpoU1I4/PHBs7fl+a1
dw/KsZs29XfXhh/aux6eQU9t+PbShvfD2k317S7r3s7BBY1dpr/r41xDc+yS
5rV3+O0IbZs5j3YczkvT+KyUZ9Fv+Jpnei+n8RkVzwQ/9jXPqWaGfngan1X9
GNoWX88PbWya1wXSn8vfl51DM/h6GvVtaNvQU/Ga/9cZz715Hs7fHWg8N8/+
Tfsz5kae+PBs/Kc0Pn/k2RhzPPfFl2e8L+jD+fBMk+eZK9JYD/b7aXw+/HYu
1vqc8eeG/p3QJoY2L7TpoU0O7YM0chlk3fQ89yQuz095djopjfvO9PVgGa51
v4nW3d9630zj2lXmO0n/gea5ymd1PDfkWdYnaayB57Ez9FkdxheZM+M7zZnn
tLvN9b//Pjr066xlleOf5uL5cF58tW+0zqFp/rkkZ73O1+zFc0qeUe7xPoww
N54F8ZrnQMy95lpsXvNcaaZr2Zf3L58NN9qP8vUU7btcP8y92npf29iP8e4u
8TVjn6bx/0vI/eK+jPNMn/U1d4r3LH8jmO59Ge+d4f0wwXuy0Nf4rEnj3xU4
uwVp/LfnvH7b+8D9GeTrGZ7Vm57dYM90pneEcZ797krjc/XJnsNMmXyVxn93
PTmLnfrv/dP4HBMe69P42QqnDdY/1Tqo7f/rMP853ofn0xh/uns9Z3zyJ68h
5vaKd2u17/0Z3oUR5sB58l3FZ+rdnif5896f7T183vpm+3qeNq83ypB939GH
ezvX8eft5/iavztwJwcZe67j0/UZqv9cz2W6++HziftSy7uOw/aLNH4W8Vj5
fc91oveG+8N7FD7McUe+dPycgrjXAvOHM3dloOf1geNPGf9J+SyW+SL9p1v7
Il8v9DUcPtefe/+1Z31nGt/3K/XJ/qbFfZuiz0jvAfeB98IL+gzx/vO5yXvh
e18zzpnyHuZeZf8vAO7tN8bp671gnPf4SvOg3h9cy/gCWVE7dS//H7ZrZcjn
0io5vOvZvCSPlcYcrs8g+9W+/sDXnDXvxTVyG6893bu6wrPmrD71vFa412o/
hz8zn3eMM9Gxtb5e4xwx4bpe/rwv1nku6zynYXLaIKv53q2x3hfuTX/P8ytr
p5aNslpsHO7kLMepkb8b8zdO/r453bX4THV8mrlxP/jc3JPG70L+VsT3MM/x
s//vAK95Zs93NH9P4m9Je3zN98LPruPvIf1cz1q+d/kbNn+/3u84a6mX+8Fn
Lj9H4JN9fm7z9VZfUwc/x/NzGT+rkft28//WvNmb+8i9fNx1O1y73dfEXuad
+9HvHV5zZ6d7tz415m7r4o7t8tw/Mj53fpX+Q2UAl36e6S457zBPchhuzH7O
rzMm/6YNdnutAf5r/JlkjznAnfnjPId9nsUBX8Nzr3HgD+P9nt8Wc8Nnn+N7
/U75yfibshz0OWA+/wf4IyYe
                 "]]}, 
               Annotation[#, 
                "Charting`Private`Tag$77183#1"]& ]]}, {}, {}, {}, {}}, {{
             GrayLevel[0], 
             Line3DBox[CompressedData["
1:eJwl0rcyJ1AUB+Ar5xwWy+5ohRcQeqFTsTqFtCusxZ9dOc4YpdAb1OIL0CqE
RpgRXsDyAvj+o/jmnOLM/O6595Z3DLT0x4QQFrmNCyHan6krfNfX0844mxxz
xStZhqtppodldjjliXfKYkOopY0I6xxywX8y5FTSyBb3dHHNHt300MtPftFH
PwMM8psh/jDMCKNEGGOcv/xjgkmmmGaGWeaYZ5sHFrhhn04aqCCdZ+c+54A1
RmmlhlLe7P3ICdss0U0TVWTy4v4uOWKDMX5Qx6qMO75FZ9RdyvSlfKWEYor4
QiEF5JNHLjlkR9+ITDJIJ41UUkgmiUQSiEdUsELYifv8Dx8elDrS
              "]]}}}, VertexNormals -> CompressedData["
1:eJx1XAlUTd/3z5QhIkIIaTAmlJDoCE0yhxQSlZRCJVOalMwZIxSplDIls9Jp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           "], VertexTextureCoordinates -> CompressedData["
1:eJyF21+o32UdwPFDtThGF56LKGZCJQSB1Aj1JtYS7IjRTRYx6CI2kKIuquVF
clygjfKigUkdZNIyIg5E5Mwgz8TCaVYbJKVI5HGeWUdzua3oj5CE2cXrUd/1
0G4e3t/fb7/z+33fv+d5Ps/n8/m9de9nrr7mVQsLC39/9cLCf8YX/122/KW9
7zXe/eFT1x5d+/YuvPi2n2+ur905eMehC7+yunJ08DvPO7q6vnbf4Pe9f+uZ
taUHB3/khvN3rq4cH/zJe99z84GtXw3+yfV3fW597deDf7H9qtuObDw8+Dd3
n3xgbenRwRsfvfbs4eXfDn7qb+e9aXXld4P/fMu3Lj94ZGPw8zsu/fSBrZOD
b/zENcd3HtwcfNNlOz6+vnZq8Fe3Pf/XS449OfiWR35205GN3w9e/c7NF178
3B8G37bvYz9cW3pq8O2Xv/3Kiy5+evB3z//LY4eX/zj4e0/c89nte54ZfMcP
vrxtdeX04B/t/9ChpdU/DT76wTe/6+CRZwf/9IKn7188cWbwA6fv3H1g6+zg
4+vXn3nhhXO7Zl478ov5xfxifjG/mF/ML+YX84v5xfxifjG/mF/ML+YX84v5
xfxifjG/mF/ML+YX84v5xfxifmfztF478ov5xfxifjG/mF/ML+YX84v5xfxi
fjG/mF/ML+YX84v5xfxifjG/mF/ML+YX84v5xfzO1t3O03rtyC/mF/OL+cX8
Yn4xv5hfzC/mF/OL+cX8Yn4xv5hfzC/mF/OL+cX8Yn4xv5hfzC/md7aPdt3t
PK3XjvxifjG/mF/ML+YX84v5xfxifjG/mF/ML+YX84v5xfxifjG/mF/ML+YX
84v5xfzO4qLuo113O0/rtSO/mF/ML+YX84v5xfxifjG/mF/ML+YX84v5xfxi
fjG/mF/ML+YX84v5xfxifmdxbuOi7qNddztP67Ujv5hfzC/mF/OL+cX8Yn4x
v5hfzC/mF/OL+cX8Yn4xv5hfzC/mF/OL+cX8zs4tjXMbF3Uf7brbeVqvHfnF
/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8zv7Bzac0vj
3MZF3Ue77nae1mtHfjG/mF/ML+YX84v5xfxifjG/mF/ML+YX84v5xfxifjG/
mF/ML+Z3llfoObTnlsa5jYu6j3bd7Tyt1478Yn4xv5hfzC/mF/OL+cX8Yn4x
v5hfzC/mF/OL+cX8Yn4xv5jfWZ6oeYWeQ3tuaZzbuKj7aNfdztN67cgv5hfz
i/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8wv5hfzO8v7NU/UvELPoT23NM5t
XNR9tOtu52m9duQX84v5xfxifjG/mF/ML+YX84v5xfxifjG/mF/ML+YX8zvL
4zbv1zxR8wo9h/bc0ji3cVH30a67naf12pFfzC/mF/OL+cX8Yn4xv5hfzC/m
F/OL+cX8Yn4xv5jfWV6+edzm/Zonal6h59CeWxrnNi7qPtp1t/O0Xjvyi/nF
/GJ+Mb+YX8wv5hfzi/nF/GJ+Mb+YX8wv5ndWZ2levnnc5v2aJ2peoefQnlsa
5zYu6j7adbfztF478ov5xfxifjG/mF/ML+YX84v5xfxifjG/mF/M76xu1jpL
8/LN4zbv1zxR8wo9h/bc0ji3cVH30a67naf12pFfzC/mF/OL+cX8Yn4xv5hf
zC/mF/OL+cX8zuqgrZu1ztK8fPO4zfs1T9S8Qs+hPbc0zm1c1H20627nab12
5Bfzi/nF/GJ+Mb+YX8wv5hfzi/nF/GJ+Z3Xt1kFbN2udpXn55nGb92ueqHmF
nkN7bmmc27io+2jX3c7Teu3IL+YX84v5xfxifjG/mF/ML+YX84v5nfUptK7d
OmjrZq2zNC/fPG7zfs0TNa/Qc2jPLY1zGxd1H+2623larx35xfxifjG/mF/M
L+YX84v5xfxifmd9J+1TaF27ddDWzVpnaV6+edzm/Zonal6h59CeWxrnNi7q
Ptp1t/O0Xjvyi/nF/GJ+Mb+YX8wv5hfzi/md9RG176R9Cq1rtw7aulnrLM3L
N4/bvF/zRM0r9Bzac0vj3MZF3Ue77nae1mtHfjG/mF/ML+YX84v5xfxifmd9
Ye0jat9J+xRa124dtHWz1lmal28et3m/5omaV+g5tOeWxrmNi7qPdt3tPK3X
jvxifjG/mF/ML+YX84v5nfX5tS+sfUTtO2mfQuvarYO2btY6S/PyzeM279c8
UfMKPYf23NI4t3FR99Guu52n9dqRX8wv5hfzi/nF/GJ+Z32b7fNrX1j7iNp3
0j6F1rVbB23drHWW5uWbx23er3mi5hV6Du25pXFu46Luo113O0/rtSO/mF/M
L+YX84v5nfXhtm+zfX7tC2sfUftO2qfQunbroK2btc7SvHzzuM37NU/UvELP
oT23NM5tXNR9tOtu52m9duQX84v5xfxifmd91e3Dbd9m+/zaF9Y+ovadtE+h
de3WQVs3a52lefnmcZv3a56oeYWeQ3tuaZzbuKj7aNfdztN67cgv5hfzi/md
9cm3r7p9uO3bbJ9f+8LaR9S+k/YptK7dOmjrZq2zNC/fPG7zfs0TNa/Qc2jP
LY1zGxd1H+2623larx35xfxifme/e2iffPuq24fbvs32+bUvrH1E7Ttpn0Lr
2q2Dtm7WOkvz8s3jNu/XPFHzCj2H9tzSOLdxUffRrrudp/XakV/M7+x3LP3d
Q/vk21fdPtz2bbbPr31h7SNq30n7FFrXbh20dbPWWZqXbx63eb/miZpX6Dm0
55bGuY2Luo923e08rdeO/M5+l9TfsfR3D+2Tb191+3Dbt9k+v/aFtY+ofSft
U2hdu3XQ1s1aZ2levnnc5v2aJ2peoefQnlsa5zYu6j7adbfztF47/mPPpx5d
PPH4GLc9dPzrK9tPTa93fMuP3/DNe9a+NkbfF3zl1W+86Ni+c+Nxf/dlz3/x
3+auZ+9/5PtLq4+N18Ue7/txna9eN3o9/LrD33jHc5c8OZ6P+z5m7+tlddVX
vK/WHWfvw9j6Za/XQ98n7n12//Fs/B8eXvH/Wjd2H7zf+uh96efC3jf2ur1v
vT/9vP0ee99f+OVDty/vPjnG++5699bh5c0xXnHBrXdsPLz5X89zveP+Ww9d
emzfE2P0Ov/vus/her8Ps+dt7v/imXvXbhjj4ms/sLhn/dxgz+vnc59c9/qu
436u3pf+3Y7Ww64L7avp97f1TH9n9jn6Od0n77Pv2+Pep7/jc87ui//Xx/u6
vT/9/tVT903Xfa97/1vP7333OuZB1xPX3ec+Xm/mHeZtdh1//p+vef2JnS+N
D974r+u27zk1ve5zdX647nnuLzb6XJ5/1em9V+w++9LzPd7Pj72O/9fnuW78
N7wMEd4=
           "]], {}}, {
        DisplayFunction -> Identity, DisplayFunction -> Identity, 
         DisplayFunction -> Identity, 
         Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
         DisplayFunction -> Identity, Axes -> True, 
         AxesLabel -> {None, None, None}, 
         AxesOrigin -> {Automatic, Automatic, Automatic}, 
         BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
         "Neutral", Method -> {"RotationControl" -> "Globe"}, 
         PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 2.059767072880663}}, 
         PlotRangePadding -> {
           Scaled[0.02], 
           Scaled[0.02], 
           Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
       FormBox[
        FormBox[
         TemplateBox[{
           FormBox[
            StyleBox[
             StyleBox[
              PaneBox[
               GraphicsBox[{
                 RasterBox[CompressedData["
1:eJx1mPk3Ve37x8mYSCIylChDQlKiUu+SaJA8QpGhQinj80TIFJVEIRIikoqQ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                  "], {{
                    Rational[-15, 2], -75}, {
                    Rational[15, 2], 75}}], {Antialiasing -> False, 
                  AbsoluteThickness[0.1], 
                  Directive[
                   Opacity[0.3], 
                   GrayLevel[0]], 
                  LineBox[
                   NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                    7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                    7.5, -75}}]]}, {
                  CapForm[None], {}}, 
                 StyleBox[{Antialiasing -> False, 
                   StyleBox[
                    StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                    False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                  "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
                Scaled[0.02], PlotRange -> All, Frame -> True, 
                FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
                Opacity[0], FrameTicksStyle -> Opacity[0], 
                ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
               Left, AppearanceElements -> None, 
               ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
               "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
             FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
             False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ),
           InterpretationFunction :> (RowBox[{"BarLegend", "[", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{
                    RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1lvs71IkXxwkpEWHVSG5FUlQiknqXa21Kj5CVS4skJLuR3FK62ZS7hi50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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
               RowBox[{"LabelStyle", "\[Rule]", 
                 RowBox[{"{", "}"}]}], ",", 
               RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
               RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
               RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
               RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
               RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
                 RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
               RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], ",", 
               RowBox[{"Charting`TickLabels", "\[Rule]", 
                 RowBox[{"{", 
                   
                   RowBox[{
                    "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                    "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
               RowBox[{"Ticks", "\[Rule]", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                   "}"}]}], ",", 
               RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
               RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], 
             "]"}]& )], TraditionalForm], TraditionalForm]},
      "Legended",
      DisplayFunction->(GridBox[{{
          TagBox[
           ItemBox[
            PaneBox[
             TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline},
              BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
           "SkipImageSizeLevel"], 
          ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
        GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
        AutoDelete -> False, GridBoxItemSize -> Automatic, 
        BaselinePosition -> {1, 1}]& ),
      Editable->True,
      InterpretationFunction->(RowBox[{"Legended", "[", 
         RowBox[{#, ",", 
           RowBox[{"Placed", "[", 
             RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]},
    {"\<\"Fig. 3. The function \\!\\(\\*FormBox[SqrtBox[\\\"z\\\"], \
TraditionalForm]\\) is not continuous along the negative real axis.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1906977948,ExpressionUUID->"00c94cbb-328e-4742-8230-0f7685a7e2db"]
}, Open  ]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->334491371,ExpressionUUID->"e0dc2ce7-5d65-46bb-a794-8ff70d8ab4c6"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"(", 
     SuperscriptBox["z", "2"], ")"}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ab1c9f89-2654-405f-ae0d-b95a466a7011"],
 " is continuous in the whole complex plane because it is the composition of \
functions continuous everywhere:"
}], "SolvedExampleNote",
 CellID->836996147,ExpressionUUID->"32561139-7bd0-4daa-bb63-20cb981712e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionContinuous", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", "z", ",", "Complexes"}], 
  "]"}]], "SolvedExampleInput",
 CellID->212879176,ExpressionUUID->"062225f0-fc81-4362-a183-b80f1367e927"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->235841592,ExpressionUUID->"52685a0d-b5bc-4c0c-b51b-0d49ce3e99de"]
}, Open  ]],

Cell["Let\[CloseCurlyQuote]s see a plot of the function:", "SolvedExampleNote",
 CellID->289785456,ExpressionUUID->"b87d2083-9c23-478f-850d-b57401ccdacd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    SuperscriptBox["z", "2"], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotLegends", "->", "Automatic"}]}], "]"}]], "SolvedExampleInput",\

 CellID->412966827,ExpressionUUID->"4f629845-a8df-4ad0-a742-61b7818fbaee"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJytvXm0z9X3x+/ea8pQMiSlMhZFhgainIMUFcosRGkuKUqlSZKSITIkRClz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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJzUvWVwXWe3pdt1b9UXswNfTmhLZogTk1iWZJTMbMvMzIwxMzMzxgwxoyRb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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnXW8VcX6h/c5Z5999t7H7sIO1GshCIgoihgoooKFgoGKgRK2ItKCdBio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             "]], 
            Polygon3DBox[CompressedData["
1:eJwllFlI1lEQxa/f55f6v0Egmb20+NCDaUKL0kLbSxuFldECRqWWRalRtNJC
FrQvtC+aWlFQtFiBBQlFVmZkFFSm7VnQYj61IFn9DvNw4MzcuffOzD1zk3KK
JheGnHPZIBo8Cpwri3KuHFyAV3jnfsc6dz7OuRPwWSCetZSIc7Phm0ESG/9h
b4H3BEPhycT0gJdyRg3rhZxxD34SxLE+PMa5+/Aq0JUE2oh/Bk9kzy/Wl+Lr
Av+LLxc7j/W38A34PmBns14MPwXaObsV+w7rO7ATOjh3CHsnfC2oIz6RHNbB
C0EtZ30CRfBy9jSw1o98auGVoIm1avAEfi6wXhSDevhr0Bi2GlTLG9CKPQz7
NHw+ZxYQux0sgM8DmVHmy4ePAcdjrCefic/EPkzfq8BE+GiQRj2XyH8UfDfo
i51O/B74Qm9nnwWLvEFcNRXA14CO0Vazatcb6a0q6MkceAnI5/6R2KXwi4HV
qjfX20/D15n7EsB0+HiwylmOE+DZoFPENDATfos99SHL+SV8Lr5ecVazas8F
qRHz5cF/BKYN9fAnfDm+y6wnccYKbz1QL+I5b5J6A9LhI8j3iLc31FtKA+u9
7dHeK9gr4ft1B/FpxB/wVoNqUc4z4FPBU2c1qlb1RL1RjjnwcaCZXJ9zx0Bv
mpf2pTFprZqcU+JMo43wQfhexJqGpKVv4Dvnv8E3xFsOyuUxPT/obUY0KzXY
W73FKPYu/WgJzKc1aXibtxnRrMSypxV+NbBZkUal1QxiHrL/IHeWBHaH7lLP
DnnTtLStmsZid/d2lnLsBi/zpgXNeDn8OvHvsRuJaYB/DSw31TjYm8al9WZ8
dfCbgWk1hfU+rO/yNnvSrLR71NvbSXPH4LeJbwmZZqQd7dFe9VS93ehttvWn
bIKfwZcVsRl7AH8X2CzqT9DfoD9Bf4Ni2uHL2BMOmaakLc24Zv0jWAyPgKaI
1ahao73VmkwO17D/aH7ClmMN9hJve3XmUnh/UBm2nqv3A7z9bfJpLQVkhOxP
6w3P8qZlaW6KZsmbVjWjq+FfAtOa/oRXgfVUvdUf2gZP9ZabztTZNwL7G1WD
atnr7W+Q5vfB/wPyFM4M
             "]]}, Annotation[#, "Charting`Private`Tag$5766#1"]& ]]}, {}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNmnlwleUVxu8N3Jt7v1cQFJ2CiIBhS4KotVOXKu6K2tZxlCBi7VTADe3U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            "]], 
           Polygon3DBox[CompressedData["
1:eJwllEtI1VEQh8+93fR6podmSK9FkUVQi14QQWhFj0XRQgpaB+2yNm1at2vZ
JogIjAI1LbOyzBfYw5JML9lDlDLz0cNM09KyoO/HLH7wzZn/mf/MmTln1bFT
JSeTIYTDKIUWWQgZFqbTIeyEP8UQ2rNDKMgKYQH2WpSPr5tv18DNqGtOCPMS
IbTAeaiYQFv5ZhP8m/2H8G1EM/APlAcP4t+B/xkaYv9+1trhy/jriJ2Lf7W5
xBdYu4hvEHsd9jZyHIIr0R183axdh++j7eQ7QQ718E3USPy3+GvgP6iTvVuw
Z+GFaH2W16ha92IvSXvOe+AG/XNuCAfx94hREfvbWEvij+gv3IR/GN897PGU
56BcHqoG/PuwH8HZqCDlMR7w/RfsI3Af33yFR1g7k/SYit1hfjYl2C/gItWb
9JyL4ZbovTlK/F542PxsFHMEnkTn4Ty+mYLvqr/Bc6yDr0XvTS7xJ+EG87Or
Jl4jvNm8l/pna/SaVftK7I/Yy8zPRjWptsXoUpb3WL1Wzsr9OHYn/A19xn+a
/WNwt3pCf87ifwUPsCdBrCT+uugzolmZJOeJ6D1T78bw/4PLUWnaZ6AC3o2u
pH2Gd8G3zHuvmmvh72g07Wcybj7DmmXNXCHcaj7L6pl6N60YSZ+ZGcWOnssU
OY7B5ehEwmfmefQeqpeqcRQ+oJ5HvxMrzO+U7pbW8s17ot5syAnhp3nNqn1Q
5wEH87PWmSTgd4qPbxa9N58pzVYh/3wMv2TPE3xtqBa+HT2W1uSrie6rQBm4
Ep1LeA0dcDUx+nP8ztwwnwnNhnp6NXrNql1vQBncZd5b9TBjnpNyW0rO/fAv
89p0hjrLD+Y+3eEBeL7uX8pnvlm5m9dST01t6p1mnHjNqMf8jumu6U6msZvM
Z1VvkN4ivQF6C1RDlflMabbK0Gu4Knrtqlm1Lze/O8pBufSa/0tn3Ae/Md+r
HJTLU/Pc9Gbp7dIMa5Y1U5qt/7X30U0=
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwd1FdsjWEcwOEXVav2XsWNC6WRELu3tGK1qFWrVou2VNGpw95q1h5FI4JI
CBISglASxIWImJdWuMCFFc9x8Zzf//3anO9tv/ecHuk5Kdl1QgjdvFRGhxCZ
uza21gSmUcCoJiGMZgxjGUcyKYxnAhNJZRKTmcJUppHGdGYwk1nMJp05zGUe
81lABpksZBGLySKbHJawlFyWkcdyVrCSfAoopIhiSlhFKWWUU8Fq1rCWdaxn
AxvZxGa2sJVtbGcHlexkF7vZw172UcV+DnCQQxzmCEc5xnFOcJK7/udf6oZQ
3TCEpvVCOKVxWqNJekYX6AbPKEN7NLI3c7LrmdZbzAt1EYvJIpsclrCUXJaR
x3JWsJJ8CiikiGJKWEUpZVS6T7luc58K7WK/283x9rHa+pd5jfZ0fb4m0osY
fvv77rjeV2/rLV4Sbz2C4cRw07U+ekNfkGBuRHvaEc111+vrNX1OlPmq9tY4
enHF+hmXucRFnnKBx5znCWd5xBne8Ze3/KGGh/zmDad5wE9+0d19uvHd/IOO
5m/6mmpqI8+Tr8T6WVc+mYfqZ+2gH3WIDo6cB/N9kswjGcQH61ckmt/rwMgZ
0nv0N/djQORsWe/1Gc3wjPI1Xadqmg7TVI3VtVH2oeesK8x/GniO1qXmztqJ
jnSgPe1oSxta04qWtKA5zWhKDLYRbCM4DsHbB28dHIkwPfK8tMrFqMh3iRdH
ItT6xXyzI///e+cfQLaMYA==
          "]], 
         Line3DBox[CompressedData["
1:eJwl0bsr73Ecx/E3Cv1+uTuLS447g0SZnNxNtrNZbRZG+Qv8BVKUu5IoHZfB
KepnZRCSTDgHk8LgsvAow6Pn6/Pp+/ssv8qh0d8jaRExzkwiYkp3uMqOONWf
7p40z0dNDDDMBNuZESv6kRWRsiv85tD5yL7WT8rTI9oZZIzw3qTO+3ZLF/RE
F3UpGdFLGz10U0gXRQxQRgEttJLyXpXm00EneTy4z9VmDuwrSu0c9u1KTXJv
J/ROs/WvXlJiZ7Fn/yfD/qfpequhaVzYn9ywyzlbnPKHMzY5YYN11jhmlSMa
vdNPH+/Ob/ywX3WFF5Ypdvesv/RJG7SeRfuRBeqca6lhznmWans68f3/fgHj
10IS
          "]], 
         Line3DBox[CompressedData["
1:eJwt0ckuH1AUB+DLoqbEE1gQW4nYegRLK0sRi24QkVix9QQeATUrNbWGmmeq
f/Os5tasagzpJ7H48jv35p7k3ntS8oqyC6NCCOUUx4bQLgtkdUIINXyiljrq
aaCRJppp4TOttPGFdjropItuvvKNHnrpo5/vDDDIEMOMMMoY40wwyRTTzDDL
HD+Y5ycRFlhkiWVWWGWNdTbYZIttdtjlF3vsc8AhRxxzwm/+cMoZ51xwyRXX
3PCXW/5xxz0PPPLEMy9vb4vXHx1ChpyX+XEhlPn3NnWqvUpZSg6ZJJFu/9Ww
cp2NfHBv9XOMP1En6x2yHlRXyQo+kkUaiZzquzLfEmcj7/P+D8nfYk4=
          "]]}}}, VertexNormals -> CompressedData["
1:eJzcvHk01133P0xJ0YQiNJjnKSVNdFDJ3CQlMg8NGgwpJENFhhRNKiHzUEJK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       "], VertexTextureCoordinates -> CompressedData["
1:eJyVnWmUV8W1R3Hi4RARFAecMESXQ0cJgvoMWjgwqBgEUVFJAk4JYpSgUQMR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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, 
     AxesLabel -> {None, None, None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
     "Neutral", Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 108.0845165183032}}, 
     PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], 
       Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->642304547,ExpressionUUID->"e211970c-d287-4566-8c56-cdfd0a6de4b8"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->54911288,ExpressionUUID->"2870cfba-36d7-4b30-b263-d0ad371070cd"],

Cell[CellGroupData[{

Cell["Properties of Continuous Functions", "Subsubsection",
 CellID->193521445,ExpressionUUID->"befb67f1-0114-4801-a9b5-f9ef22543671"],

Cell[TextData[{
 "If two functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"25c70891-763b-4c86-a703-94f48005e0ff"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"437a13c7-b4a4-4d65-b075-7c42136d6a12"],
 " are continuous at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "47a2495a-c2a4-4379-b1ef-4337c8443e1b"],
 ", then:"
}], "Text",
 CellID->116478783,ExpressionUUID->"75b944d6-8a24-42b7-bd03-22599be5ffe6"],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "+", 
    RowBox[{"g", "(", "z", ")"}]}], TraditionalForm]],ExpressionUUID->
  "04c0e2a0-c8fc-4cd1-b93c-ba66454de390"],
 " is continuous at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "b5dce979-b85e-4a68-9a33-d4da7d8195ee"],
 "."
}], "Item",
 CellID->31187310,ExpressionUUID->"bad9bb79-af31-4e28-9aa4-69b8381f1c7a"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], 
    RowBox[{"g", "(", "z", ")"}]}], TraditionalForm]],ExpressionUUID->
  "921f409e-5a86-4d93-8a22-bd073ae9b381"],
 " is continuous at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "c9947b5c-210a-4348-9bef-7a983281d61b"],
 "."
}], "Item",
 CellID->138810943,ExpressionUUID->"0c55a85f-2313-47c5-a3e4-11586a8517f8"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "/", 
    RowBox[{"g", "(", "z", ")"}]}], TraditionalForm]],ExpressionUUID->
  "45009492-23c0-42b5-b539-c8471ca676ba"],
 " is continuous at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "b5b8bedf-d535-45d2-bfc9-0f2abd99f103"],
 " except if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "a", ")"}], "=", "0"}], TraditionalForm]],
  ExpressionUUID->"c3dcaadc-0daf-46d4-8dae-02bb8e19280b"],
 "."
}], "Item",
 CellID->63232647,ExpressionUUID->"9bd1949b-c8b7-405b-ac6a-424d12013429"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]],ExpressionUUID->
  "f8dde111-da65-4e57-abb7-f613975ffb52"],
 " is continuous at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", "a", ")"}], TraditionalForm]],ExpressionUUID->
  "6d9c01e7-1bd9-4999-a231-553653f1078a"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"g", "(", "a", ")"}], ")"}], TraditionalForm]],ExpressionUUID->
  "b47b647a-dee3-4b72-963e-4de32e3da4d3"],
 " is continuous at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "6e5f4c5c-0a16-4c49-84d0-67972c8cf934"],
 "."
}], "Item",
 CellID->229217596,ExpressionUUID->"e827812f-2431-4f55-baf1-fde4870d60ec"]
}, Open  ]],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->12547386,ExpressionUUID->"e32ca137-b997-46bd-aa5a-555229fd3c67"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["z", "2"], "+", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"be8d7c6f-e020-4489-8391-a3a12aa0fc84"],
 ":"
}], "SolvedExampleNote",
 CellID->412677045,ExpressionUUID->"89e7f10a-0b10-4099-be2d-f65c0167c78a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{
    SuperscriptBox["z", "2"], "+", "1"}]}], ";"}]], "SolvedExampleInput",
 CellID->57657332,ExpressionUUID->"25a13333-8c83-4a85-a96f-81be4a9f6445"],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    SuperscriptBox["e", "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2a305cc7-883a-4bcb-a515-200b128257dd"],
 ":"
}], "SolvedExampleNote",
 CellID->128975082,ExpressionUUID->"8f97aa73-4b6f-4df2-b473-6ac3e121d853"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "z_", "]"}], ":=", 
   SuperscriptBox["\[ExponentialE]", "z"]}], ";"}]], "SolvedExampleInput",
 CellID->65802463,ExpressionUUID->"ce06ea1a-cc9d-4fa4-8e61-3401093536eb"],

Cell[TextData[{
 "whose limits for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d2e2dc11-48d8-4f6a-9af4-81daef79fd9e"],
 " are:"
}], "SolvedExampleNote",
 CellID->13052927,ExpressionUUID->"48254b21-210c-442f-823d-f80e246ac1b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], ",", 
   RowBox[{"z", "->", "1"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->443136753,ExpressionUUID->"41434d6e-5f2a-409b-87e2-82a0d293d6b5"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->24342986,ExpressionUUID->"2c79f104-4ecf-4286-85b8-8b49aee4d257"]
}, Open  ]],

Cell["and:", "SolvedExampleNote",
 CellID->426420093,ExpressionUUID->"f5f8b614-66ba-46d5-8752-67383f5750e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"g", "[", "z", "]"}], ",", 
   RowBox[{"z", "->", "1"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->471259362,ExpressionUUID->"dca190cb-089e-42e4-86d8-ec46a792e83d"],

Cell[BoxData["\[ExponentialE]"], "SolvedExampleOutput",
 CellID->92003856,ExpressionUUID->"b187fef8-cf1b-42bf-993f-f1881abcde98"]
}, Open  ]],

Cell["then compute the limits below:", "SolvedExampleNote",
 CellID->565928211,ExpressionUUID->"8280f782-b999-4298-b640-580dcba58ad3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], "+", 
      RowBox[{"g", "[", "z", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], "*", 
      RowBox[{"g", "[", "z", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], "/", 
      RowBox[{"g", "[", "z", "]"}]}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"g", "[", "z", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"z", "->", "1"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "SolvedExampleInput",
 CellID->312946480,ExpressionUUID->"0d1af9a6-d35c-4055-953f-20a388b279e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "\[ExponentialE]"}], ",", 
   RowBox[{"2", " ", "\[ExponentialE]"}], ",", 
   FractionBox["2", "\[ExponentialE]"], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["\[ExponentialE]", "2"]}]}], "}"}]], "SolvedExampleOutput",\

 CellID->278082900,ExpressionUUID->"9be3b64f-69cc-4fdb-82b9-08e16eadecc7"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->941447777,ExpressionUUID->"e3a6cf2c-8529-45e6-ba81-bee29626b55e"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"f86dec32-fee2-4022-81bb-56558d88a319"],

Cell["\<\
For the complex limit to exist, it must be the same in every direction.\
\>", "SummaryList",
 CellID->93427494,ExpressionUUID->"bd30c8ef-27ff-47c3-a3e2-1dc7978de00e"],

Cell["\<\
The existence of a real limit does not guarantee that of the complex limit.\
\>", "SummaryList",
 CellID->366272386,ExpressionUUID->"91f1a9cf-f902-463a-a6d8-5e2148d192e6"],

Cell[TextData[{
 "A function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bb5e485b-9ea4-4300-a658-b06973035eeb"],
 " is continuous at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b7fd0d7e-1335-49d7-8d40-271dadcf8922"],
 " if its value is the same as its limit for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "->", "a"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c37bdd4e-1734-4260-8722-b8fe9f243b94"],
 "."
}], "SummaryList",
 CellID->53700530,ExpressionUUID->"668725a4-fca9-4d4c-9334-d687c4926747"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->409992952,ExpressionUUID->"905cf077-c42b-4e9f-b569-f912a228e816"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "0"}]], 
    FractionBox[
     RowBox[{"sin", " ", "z"}], "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bb5b8b44-99e7-4e3c-ab9b-d96b1f119c60"],
 "."
}], "Exercise",
 CellID->7764700,ExpressionUUID->"f53ccba3-cd1f-4f8f-94a9-3843f8f14027"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"250b18b6-a746-4902-9eb0-b190970ae359"],

Cell[TextData[{
 "Find the answer using ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->683483954,ExpressionUUID->"a528ed14-eaa8-4848-9d0b-0644b483c1d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "z", "]"}], "z"], ",", 
   RowBox[{"z", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "ExerciseInput",
 CellID->41826623,ExpressionUUID->"92285f24-ce3f-4512-91a7-73dfd6f8b0d2"],

Cell[BoxData["1"], "ExerciseOutput",
 CellID->124123477,ExpressionUUID->"e6964094-d1ab-403c-ae67-d674464fca4c"]
}, Open  ]],

Cell["Plot the function:", "SolutionAnswer",
 CellID->23117620,ExpressionUUID->"587c15f0-636d-46d4-b868-21e48b22b142"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ComplexPlot3D", "[", 
    RowBox[{
     RowBox[{"Piecewise", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", "z", "]"}], "/", "z"}], ",", 
          RowBox[{"z", "!=", "0"}]}], "}"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], "\[Pi]"}], ",", 
          RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], "\[Pi]"}], ",", 
          RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"6", "\[Pi]"}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "ExerciseInput",
 CellID->851958017,ExpressionUUID->"6c8bb4ee-aeab-429b-99fd-ff73e52867ec"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{{
      GraphicsComplex3DBox[CompressedData["
1:eJyVnXm8jtX6h7chtiFj5mlvc+aQxNZ+FSpF0ol2QjqKRCgSiUopnSZTIg72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       "], {{{
          Texture[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJyNfHV0VFm291vft1Z349Cvu6elKrhbPBWFCMGChQR3dwvu7u4S3L1xixKS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              "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {100., 100.}, 
            PlotRange -> {{0, 100.}, {0, 100.}}]], 
          EdgeForm[None], 
          GraphicsGroup3DBox[
           TagBox[{
             Polygon3DBox[CompressedData["
1:eJxNnHnclmP2wJ/7uW+EGEvWSJgxso6xjH3fskuUCDNjxl62aCFJSEUllKVF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              "]], 
             Polygon3DBox[CompressedData["
1:eJwtk9dSVEEURdvmHsWICcOj/+FX+Al8gD4hqARTGRBRUQSVoDgDM4KWVZIM
mKBURmYGMCNiwPQRqKxT24dVs3bf26dPd9/ZUbFn1+4YQtgJCSyzEO7xexee
MFBCfoDfhzHycvJLPAfPyWvI0/gUFMirTV6EPPkvDONDMIqv4PlkUI0JckIe
DVpjnPwn0buD8BBfZapVgEnySpPnvYY3bOp1BB6T/yVyX/MRXmp619fMkaNp
L77Hp+R95EEOYAj24x2QwbPQiWe9XzwPN/Be33/UWAZ/kegsfsN2E+6/YI5n
20z+Ez6S+0y1CtCPH/N+8A44jl/zmvgEdONpyEWt2YPfNM0twi38tsmnYJH6
B0x7GYYavNbkI1CHH/H7jVrzKH7Izy9q7DBeb3rXxw763VJzLuiOniX/zySq
xy68Eu7gA7AXv27q3XtO4VtNe/8Bs8zfYvLv8IG8ifwN/wpvyRtN/gXekDeY
/DO8Jpeb5i7Ae3KVaW2/w2q8BVJ4Gi7il6AH74XLeKvpmY+14ee956g5F/Bz
0B011oyf8TuJGjuLn4Iu/Co04iehM2qsAd9s6s339I7+rpjW9m+qHT9tmus1
m/B18CnojP2s/Rvwb8FrnsDXm/Y+D694XmZynzNDXkueCfoPFslLzBifkA==

              "]]}, Annotation[#, "Charting`Private`Tag$12095#1"]& ]]}, {}, {
          GrayLevel[0.82], 
          EdgeForm[None], 
          GraphicsGroup3DBox[{
            Polygon3DBox[CompressedData["
1:eJxNmVe4VtURhrfn31sl9haVonAORSkiIiAivQtIExCkIwiKoIgVu4gmETQx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             "]], 
            Polygon3DBox[CompressedData["
1:eJwlk2lTiFEYhs+80/MrhBb70oKaItljsieiVKNCttL4MS3CD1CEPtKi/Zvs
NVOohDZClnxxPXN/uN657vOe85ztfePLqvOqohBCFsTATx6TNPTBFD4Kj/Fh
SLIQbsAj+rXCM97tJjfit2APvtfkt2EfXgUP8IdQjV83udeowcvgLt4E5XiO
aewd2I9XmN41w3l8E0yxli/wm/lTTf4ZfpG3kuvoWw/b8GT4FGlPvrfL5Pu8
a4EreDY04DdhB55lGutt2/FKuBc05hK+GaYjreEP9VJMc/scC+QMcm3QGjLx
C6a1e42L+FXT3H4m1/AN8Jaxb2Ce8WnkWXwGFsl55Kf07YIT+Fnow/uhGD8F
3XgPFOD5pr7edhIvMfUdgFL8GHQG1TyOrzTdda+fIfMdIXcE9TmK50Ib3g4H
8Y0wFGnN3+lfSO4NWlMRftq0Fm87g58zze137Hftd+p36zUP4IdMtX3Ow/gq
eE7tQT8D6q8mv4jUNk1eQ34ZqW2WnOD7x7vgIznOzwvvhHHycpN3wBh5vems
X8M3cjp5LtKZ/yMvM/Vthw/kpSZvg/fkWJM/gXfkJSb3f2SEvMJ0lj3+TZDX
meZ6BV/JW0x369/QX/Ja0zvf0xw53rQX38NEjP45//f8zH+QE021fc+T5J2m
b9f/wV34fxrWlXQ=
             "]]}]}, {}, {}}, {
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwt0UVOA1AQBuCHFqe407AAjoC1uDvFW7S4tIWwgYvANSBhA6fgSHwkLL7M
P8lk8iavJ5NP5gpCCFkK+csxEqR54Y2BkhAGGWKYEeIkGGWMcSaYZIppZphl
jnkWWGSJZVZYZY11NkiyyRbb7LDLHvukSHPAIUccc8IpGc4454JLrrjmhlvu
uCdLjjwPPPLET3EIn+5+5ZkUcbrpopMO2mmjlRaaaaKRBuqpo9++D6Lyt9rH
O7X6L7WXGrmaKiqpoJwyIpTiacFoKPr/r1/tWSFE
          "]], 
         Line3DBox[CompressedData["
1:eJwl0kszl1EcwPGDv0sSoqiZLOzzBngH7Kxq26o2NWNCNxW534kokTsR02Qs
iyjp6lohC72D2hc+Mxaf+c7znHnOzPk9J/vStcKrUSGEMd5EQpjVDf6SYqE9
JoQcndACvUINIyzymwOyokNI9H2eZulFLaWTGa7HhlBMCaXc4Ca3uM0dyrjL
Pe5TTgUPqKSKamqopY56GmikiWZaaKWNdh7SQSeP6KKbxzyhh6f00scz+hlg
kCGGGWGUMcZ5zgSTvGCKaV7yzwxWnfsVHZSQ7d0FrdRcPce+2e2xwDDVXGbe
vPN1XM9rMn/8k3WK7H+CFfsk6Tc9rl81Ub/oMf2sCfpJ4/WjxukHjdVlPau7
ekZ/aabuaIZu62nd0lP6U9P1h6bpdz2pm5qqG5qi65qsa7rEeyKe32mMLmq0
LmiUvtWg83rAHPu85n/k6F4eAsOZXPY=
          "]], 
         Line3DBox[CompressedData["
1:eJwl0TVOBFAUQNGPTAcbwAeHwW0N0LIECnxmcHeogL2QQAmbYAG46+DacBKK
m/Ne8/KTH+1KdibSQghx3WeGsJ8eQkrZGSHE1KEe9apP/RrQoOJKKKkhDWtE
oxrTunvbGjfvckM7mrDvcVOT5ilNa0azmtO8FrSoJS1rRataU7faVa0sPXrz
ViSENv2628oftvCbzfxiEz/ZyA828J31fOOtblRmv2Ypr1jCSxbzglGes4hn
LOQpC3jCfB4zj0fM5QFzeMg6vrKWL6zhM2N8YjVTrOIjK/nACt6xPPL/X3/a
ZjzU
          "]]}}, VertexNormals -> CompressedData["
1:eJztvHk019/XPkyliGiQkhAJRVE0GLIbKaKiJBpUIg2GylChQkJSSkWUlKTB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        "], VertexTextureCoordinates -> CompressedData["
1:eJyFnH+czlW+wGcrLdoraisrkktuSZsKl9U4uWWy0gptUbduWiW7lTVXpSXJ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        "]], {}}, {
      PointSize[Medium], 
      Point3DBox[{0, 0, 1}]}}, Axes -> True, AxesLabel -> {None, None, None}, 
    AxesOrigin -> {Automatic, Automatic, Automatic}, BoxRatios -> {1, 1, 1}, 
    DisplayFunction -> Identity, FaceGrids -> None, ImageSize -> {200., 200.},
     Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
    PlotRange -> {{-9.42477796076938, 9.42477796076938}, {-9.42477796076938, 
     9.42477796076938}, {0., 18.84955592153876}}, 
    PlotRangePadding -> {Automatic, Automatic, Automatic}, SphericalRegion -> 
    True, Ticks -> {Automatic, Automatic, Automatic}, ViewAngle -> 
    0.5176274012586664, 
    ViewPoint -> {2.206282690106683, -0.7372502080706949, 
     2.4573926877964243`}, 
    ViewVertical -> {-0.6887876207524348, 0.23016489183065492`, 
     0.6874559884580126}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "ExerciseOutput",
 CellID->122849871,ExpressionUUID->"daa2ead7-fd55-4841-b209-3535ba36aa98"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"z", "->", "2"}]], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}], "2"], 
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      RowBox[{"3", "z"}], "+", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"308f545b-08ef-41a8-a1ec-672500edf6d0"],
 "."
}], "Exercise",
 CellID->396714205,ExpressionUUID->"24207c92-0c59-4f0b-8376-25cb1aa18c8f"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"cf01c242-6cf0-4f4f-8f75-3ee4dd0ede3c"],

Cell[TextData[{
 "Find the answer using ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->265121206,ExpressionUUID->"10e10609-2080-49f5-8610-25c8c2ddb215"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "3"}], ")"}], "2"], 
    RowBox[{
     SuperscriptBox["z", "2"], "-", 
     RowBox[{"3", "z"}], "+", "1"}]], ",", 
   RowBox[{"z", "->", "2"}], ",", 
   RowBox[{"Direction", "->", "Complexes"}]}], "]"}]], "ExerciseInput",
 CellID->56038475,ExpressionUUID->"56d28da5-a87d-416c-b5cf-53b596011155"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "ExerciseOutput",
 CellID->143772839,ExpressionUUID->"8139b3fa-3320-44c1-bbdf-053f1d645bcc"]
}, Open  ]],

Cell["Plot the function:", "SolutionAnswer",
 CellID->88301958,ExpressionUUID->"e9484008-e161-4921-aff0-cc23f6f8e0bf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ComplexPlot3D", "[", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "3"}], ")"}], "2"], 
      RowBox[{
       SuperscriptBox["z", "2"], "-", 
       RowBox[{"3", "z"}], "+", "1"}]], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "4"}], "}"}], ",", 
     RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "ExerciseInput",
 CellID->159762978,ExpressionUUID->"8825b818-d66f-455c-85c4-1d997ff65b21"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{{
      GraphicsComplex3DBox[CompressedData["
1:eJyVnXVYVUvYt0E6RLDFTo6BgYWBe4vdqHhsxUY9NmIiJmF3i4Fio4IKKgii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       "], {{{
          Texture[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJylmnV0VVf6/md9f2sNUFqkM9OZ6dwb3J0ACe5QpIUixSlQpKW4FitFirs7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              "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", 
            ImageSizeRaw -> {100., 100.}, 
            PlotRange -> {{0, 100.}, {0, 100.}}]], 
          EdgeForm[None], 
          GraphicsGroup3DBox[
           TagBox[{
             Polygon3DBox[CompressedData["
1:eJxNnXng1sP2x5/n+TyPkKVsLZY2KpUkwpUl+5KkIvsSZU8RSkhliYQKFyHa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              "]], 
             Polygon3DBox[CompressedData["
1:eJwtkrdKRkEQhffXO4II+gQWvoGFDyBWttqo2Nmbc84Zc8455wCinYLaCuIz
KD6Dit9hbvFxz97d2dk5M1lllYUVSSGEHIigzkJ4TA6hhUU9egheWV+xHkYv
Qwr6A1bQ0/DDfj3rGfQiGLoRltAjcIm+S4Qwiq6Ad8638q8SvQEZPCCT7ybs
wy17f3CALofrhMco9greEv7vBr0OafEduqsH7lQI316ohifF8q8mzqFcqbAF
p5DP3gucobfjvXTu2+F7BEnsrcExetW8duVcM69BtShHFXoKuiP3RN7IQ3l5
z7rB/A16izyuNfdIXslTeTsPA5F7uIA+h+fIa74w91he/xI/i54z14pR7Ji5
1x8wji6BWfUCctH9kK1ewoA50urxoPkZna2BAnSxcqrXkGdeg2pp4v5GdLO5
/mS/BV0Ku5HHKFYzo9nRDGgW9mJv1WP1ukieRR6jWOVU7mV4MPdc3qtHJ+g2
81zN5Gw3f5PephpVq2IUqzt1t87o7DfrDnSnuf6CLvMZ06ypx4fxzITYoz71
0vysZkqzpRnRrKgn6s2Eudfq+ST6H38qdbo=
              "]]}, Annotation[#, "Charting`Private`Tag$14804#1"]& ]]}, {}, {
          GrayLevel[0.82], 
          EdgeForm[None], 
          GraphicsGroup3DBox[{
            Polygon3DBox[CompressedData["
1:eJxNlk1slGUQx7e+z5MQQzghJ2KCCoofFFG7W0GNXT+x8VCVA0G6AaQqhLYJ
R0z3UBKTtmxo7W4Peqk3mtBDP8SQ4mFrwPXkbsu2HDy3bA3gBWhD4vwzP6OH
JzPv7LzzzMd//u/uONbdceaxVCoVm1KpxGQ5pFJ/2mnYwyWTv9iZtd8y6Mtm
/8vONdPrJi+bnLRTNJ/FxPURk3PBfapmD9Gfp02/zW9V9BPYS6afNH1BeZic
snPP9Efod03fY3G+M79Wk/PcrXuHTP5oZ81sdZPjdm6ankMvNXlNqu0P0zfZ
+zXiK3YV/WHietHkRuI+yus98//e5F6Tm+0sUeNh0+/Ye0+bvEW/1KsL5DNj
+s/22z377arJieA+qlG1TqBfQldvG8HrUs69wXutPqvuJTtjxM/gP4m/8slE
//2QyYv2vGBnyp7PBddHm7zft7FX6a3qbTO5knh/fje9wt1ng/dCfVDtPfac
tvOu7jJbh8kHifdHvficXj1nsiu4j2rMB6+5RF8X0LPkIzwojnB3F7xphurn
MDiZAktpsHeTnshngvjqSXdwLE4z9yx4nsQuzLQGn5nevUatykFzuwCWisFn
IL3fZHvw2kJwjAozwlcu/JfLQPAZ5KlRmBoMjkv53NccwL/yGiU35V4gf8ki
9/ai15p8Due59wE5KR/l1c+OtASf0Qh72su755njD4n3rwd8bjDjv9mjEr1V
D8bIoYC+TLwS9kPg7aPoPRigRvVwiPia4yD2FnTZC8yrBia74QHF+dbOr+b/
WfS83onegwL+Y8xI+WTQFTPNvcq/mTjaI81L9av2RfAhTGn+Xezgp+B1R3Q8
XgdvkjfgDfX8N+YlLpF+hzneAMcrvCt/zbrCfsl/Hvtbdseq2T42+XL0vA6a
7Au+e5rbKu8ofgV7kZlWwE8bMeU7DsbU45/gnCsmZ9BnTX7CXR9Gx2aeHexg
l7Mm18GD7Dujc8aT0XHcR//fJuZ09Lz6yE079U1wrionzjt6/0X46HWTz9sp
mP5qdE46xyy0O3p3Fm7Mc1cOLAhnmtsJ/Ie5Q7t82mI9bmd3dC69BeeMgZk1
MC/uEMY+iI6JHN8l2evsteJot8VRm6hb/DAHrp6F6/dH50/5aB/fZKadJrfb
2fq/b5R04fAJk9uwq+4ydbzPnV3Re6RevRQdq0vsRQkuqsPrw3D4Lr6JR6Jj
8Do47Ax+n+56gZ7vM3kquv3r6Lk14ArhZ4190TchgU90v/KQjzhD34AR9qDM
LnRSu3C9JTrnCufHZdfMwJUwpn3ehn2ePOeZ427m+BX9Ux+1x19i15xnwZ4w
rv1uBh/6n6B9Ew4Vezu1LzBLzVF5Kb9/91W68tzLN0vfLtX+CDzfJ676UIe7
tF9L9EGYSke//6jJk9SluoVlYVqzWaPP6m2DPivOgeh88Ub0PS6zywfZU+3r
M3CguHCAmOJS/RfLsC/ivDQc2E4+afZLWNIOKp9W/BfBj3quHubITbkch/e2
gKcs3KndEM6f4j/PYTDbTn8KzFIxB4ipnd3KDBX/GPoXzHaV+e0Dn+KGV+Cc
ndjK5H+UulrAxmVwo3wvsguvsTviG71XoMY+OLUGntPslOYwzixGqVW82oNN
/bwC3vQ/bhpdnDpI/2eYaQt7pDm2gX/t4gq55cFgjf+fVZ4r4Fb3aqf0jVF/
+9HV21F8GnDwQ3Cehbebo3P2Ovsl7GygizeG4MA5uEG1X6UWcXkDrOsu7Yre
1ayPwC172N8SvCrsiWeX2el17P8AFGnkFw==
             "]], 
            Polygon3DBox[CompressedData["
1:eJwtkE1KA0EQRkuna+PebAQ1KiqISDARg9GFJP6giSDu1RijJqBHCYJCFskl
vEMu4QniSvAEvo+axWNeV1f3fNXF9tv166yZLUCCjpv9IAW+97AInzNm75lZ
Ba/CBz6kto8fwDfrKmeW8SI8paht4D2Yh1tqS/mdhbzWhxeYg8T+Gd8yDLL4
5y7+CDspMnXxlvKx/8v+Cr7tke2B/S+PDMqijOt4Hf7oHbJu4Jswwi/pucJX
Pe5S7QS/8Jhtoh78EKb4Mf1N/BzGWdy5hu959Cpj22NGzaoZtjzO6KwyH+lt
IEsx8zPc5bPrzpJHJmVTz6nHTJpNGWp6C49Z9MY3+D+yOizm
             "]]}]}, {}, {}}, {
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0jdOXVEUBdCL+diYaLDJSTSI5AnY0BM6KmLjgpzTJ5pgwgQIE4AK0RAm
ABMgSNQgMCVBgtZmfVEsnS3dJ+137nulv4aaBuNCCKv8jYQQy8fmXnwIJXIt
bUyzHTvjkmfSPfydRnpYZ5dTbvhP0YcQftJClE0OOeeRVD1V1FOm94Uu+dZs
p1vuoZc++hlgkCGGGWGUMcaZYJIoU0wzwyxzzPObBRZZYpk/lOt8ZUW+Mzvo
lOuoJIUH733GARtM0swPCvln72tO2GGNbhqoJo0n93fBEVtM0UoN+zru9RbL
V2YlRXIhBeSTRy45ZJPFN76SSQZfYt+INFJJIZkkPpPIJz6SgJqgOlghVETe
/4c3bgM42w==
          "]], 
         Line3DBox[{1458, 1325, 1338, 1324, 1333, 1310, 1317, 1331, 1332, 
          1322, 1330, 1323, 1311, 1386, 1387, 1377, 1380, 1379, 1382, 1381, 
          1378, 1334, 1374, 1335, 1356, 1355, 1366, 1336, 1337, 1326, 1372, 
          1318, 1312, 1339, 1319, 1313, 1364, 1327, 1347, 1362, 1349, 1348, 
          1365, 1316, 1353, 1363, 1354, 1329, 1376, 1352, 1385, 1321, 1388, 
          1384, 1383, 1351, 1359, 1320, 1373, 1328, 1350, 1315, 1370, 1314, 
          1358, 1343, 1375, 1342, 1357, 1341, 1340, 1458}], 
         Line3DBox[{1453, 1452, 1451, 1450, 1449, 1448, 1447, 1446, 1445, 
          1444, 1443, 1442, 1441, 1440, 1439, 1438, 1437, 1436, 1435, 1434, 
          1433, 1432, 1431, 1430, 1429, 1428, 1427, 1426, 1425, 1424, 1423, 
          1422, 1421, 1420, 1419, 1418, 1417, 1416, 1415, 1414, 1413, 1412, 
          1411, 1410, 1409, 1408, 1407, 1406, 1405, 1404, 1403, 1402, 1401, 
          1400, 1399, 1398, 1397, 1396, 1395, 1394, 1393, 1392, 1391, 1390, 
          1389, 1360, 1459, 1457, 1456, 1455, 1454, 1453}], 
         Line3DBox[{1466, 1361, 1344, 1369, 1346, 1368, 1371, 1367, 1466}], 
         Line3DBox[{1345, 1460, 1461, 1462, 1463, 1464, 1465, 1467, 1345}]}}, 
       VertexNormals -> CompressedData["
1:eJy8vGVUlWv77k0rCiigEgYG0iEgZZ2IiiCIIgaKCqKghCAYCIJSAiYgiKCk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