(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   1598958,      29126]
NotebookOptionsPosition[   1416479,      25373]
NotebookOutlinePosition[   1579290,      28756]
CellTagsIndexPosition[   1579247,      28753]
WindowTitle->9. Complex Derivatives | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Complex Derivatives"
}], "Section",
 CounterAssignments->{{"Section", 8}},
 CellID->153227131,ExpressionUUID->"da3f449e-3307-4bb6-b052-54b72170b816"],

Cell[CellGroupData[{

Cell["Overview", "Subsection",
 CellID->120929416,ExpressionUUID->"12e52651-69e1-4224-aea8-975f58f694eb"],

Cell["In this chapter you will see:", "Text",
 CellID->684008645,ExpressionUUID->"6584a89e-6ae6-49b0-89c4-ec0ac4466615"],

Cell[CellGroupData[{

Cell["The definition of the complex derivative", "Item",
 CellID->236740399,ExpressionUUID->"3c62b9b9-cbee-404e-9014-b2ed57d0039f"],

Cell["The definition of analytic functions", "Item",
 CellID->187317839,ExpressionUUID->"1271d194-452b-4ca0-966e-907e40b166c6"]
}, Open  ]],

Cell["\<\
In single-variable calculus, the derivative measures the rate of change \
(slope) of a function:\
\>", "Text",
 CellID->36051403,ExpressionUUID->"b4269622-6179-41fa-9dbc-b12644c22441"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "func", ",", "x1", ",", "p1", ",", "p2", ",", "dx", ",", "x", ",", "f", ",",
      "h", ",", "p"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"func", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x1", "-", "1"}], ")"}], "^", "2"}]}], "/", "4"}], "+", 
      RowBox[{"x1", "/", "2"}], "+", "1"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"p", "=", "0.8"}], ";", "\[IndentingNewLine]", 
    RowBox[{"p1", "=", 
     RowBox[{"func", "/.", 
      RowBox[{"x1", "->", "p"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"dx", "=", "0.5"}], ";", "\[IndentingNewLine]", 
    RowBox[{"p2", "=", 
     RowBox[{"func", "/.", 
      RowBox[{"x1", "->", 
       RowBox[{"(", 
        RowBox[{"p", "+", "dx"}], ")"}]}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{"func", ",", 
      RowBox[{"{", 
       RowBox[{"x1", ",", 
        RowBox[{"-", "1"}], ",", 
        RowBox[{"11", "/", "4"}]}], "}"}], ",", 
      RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", "2"}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}]}], "}"}]}], ",", 
      RowBox[{"Ticks", "->", "None"}], ",", 
      RowBox[{"AxesStyle", "->", 
       RowBox[{"Directive", "[", "12", "]"}]}], ",", 
      RowBox[{"Epilog", "->", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Thin", ",", "Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"p", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"p", ",", "p1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Thin", ",", "Dashed", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"p", "+", "dx"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"p", "+", "dx"}], ",", "p2"}], "}"}]}], "}"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"p", ",", "p1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"p", "+", "dx"}], ",", "p2"}], "}"}]}], "}"}], "]"}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", "Red", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"p", ",", "p1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"p", "+", "dx"}], ",", "p1"}], "}"}]}], "}"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", "Blue", ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"p", "+", "dx"}], ",", "p1"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"p", "+", "dx"}], ",", "p2"}], "}"}]}], "}"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"x", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"p", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"HoldForm", "[", 
              RowBox[{"x", "+", "h"}], "]"}], ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"p", "+", "dx"}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"HoldForm", "[", 
              RowBox[{
               RowBox[{"f", "[", 
                RowBox[{"x", "+", "h"}], "]"}], "-", 
               RowBox[{"f", "[", "x", "]"}]}], "]"}], ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"p", "+", "dx"}], ",", "p1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.1"}], ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"h", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"p", "+", 
              RowBox[{"dx", "/", "2"}]}], ",", "p1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
        "}"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellID->47059709,ExpressionUUID->"fa0cf4d5-12ea-4ec0-83d1-6557e6d87ada"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwV13k8VN0bAPA7wyQlW0hSUWgT8krizXOyFUpaXlIaLbaUpUIKZU97IcVP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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwV13k8VN0bAPA7wyQlW0hSUWgT8krizXOyFUpaXlIaLbaUpUIKZU97IcVP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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-0.9999999234693877, 2.749999923469388}, {-0.5, 
            2.}}, "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{-0.9999999234693877, 2.749999923469388}, {-0.5, 
           2.}}, "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwV13k8VN0bAPA7wyQlW0hSUWgT8krizXOyFUpaXlIaLbaUpUIKZU97IcVP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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{-0.9999999234693877, 2.749999923469388}, {-0.5, 2.}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 432}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["x", HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"f", "(", "x", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{{
     Thickness[Tiny], 
     Dashing[{Small, Small}], 
     LineBox[{{0.8, 0}, {0.8, 1.3900000000000001`}}]}, {
     Thickness[Tiny], 
     Dashing[{Small, Small}], 
     LineBox[{{1.3, 0}, {1.3, 1.6275}}]}, {
     PointBox[{{0.8, 1.3900000000000001`}, {1.3, 1.6275}}]}, {
     Thickness[0.004], 
     RGBColor[1, 0, 0], 
     LineBox[{{0.8, 1.3900000000000001`}, {1.3, 1.3900000000000001`}}]}, {
     Thickness[0.004], 
     RGBColor[0, 0, 1], 
     LineBox[{{1.3, 1.3900000000000001`}, {1.3, 1.6275}}]}, 
    InsetBox[
     FormBox[
      StyleBox["x", 12, StripOnInput -> False], TraditionalForm], {0.8, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]], 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{"x", "+", "h"}], HoldForm], 12, StripOnInput -> False], 
      TraditionalForm], {1.3, 0}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]], 
    InsetBox[
     FormBox[
      StyleBox[
       TagBox[
        RowBox[{
          RowBox[{"f", "(", 
            RowBox[{"x", "+", "h"}], ")"}], "-", 
          RowBox[{"f", "(", "x", ")"}]}], HoldForm], 12, StripOnInput -> 
       False], TraditionalForm], {1.3, 1.3900000000000001`}, 
     ImageScaled[{-0.050000000000000044`, 0}]], 
    InsetBox[
     FormBox[
      StyleBox["h", 12, StripOnInput -> False], TraditionalForm], {1.05, 
     1.3900000000000001`}, 
     NCache[
      ImageScaled[{
        Rational[1, 2], 1}], 
      ImageScaled[{0.5, 1}]]]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.9999999234693877, 2.749999923469388}, {-0.5, 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{{}, {}}]], "Output",
 CellID->35493587,ExpressionUUID->"6008f5b7-38c9-4717-9013-d8845e4c3b3b"]
}, {2}]],

Cell["It is defined by the limit of the ratio", "Text",
 CellID->436403170,ExpressionUUID->"b4ecae8b-fa18-4751-a603-85e3c8520586"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "x", ")"}]}], "=", 
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"h", "->", "0"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"f", "(", 
        RowBox[{"x", "+", "h"}], ")"}], "-", 
       RowBox[{"f", "(", "x", ")"}]}], "h"], "."}]}]}], 
  TraditionalForm]], "DisplayFormula",
 TextAlignment->-0.5,
 CellID->151991981,ExpressionUUID->"ed6cd15c-31f1-4e72-a311-472a203cfb80"],

Cell["\<\
In this chapter, you will see how this concept is extended to functions of a \
complex variable.\
\>", "Text",
 CellID->175816761,ExpressionUUID->"b5f6a09d-b660-412b-84a5-a8cd569b650c"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Derivative", "Subsection",
 CellID->247654185,ExpressionUUID->"3a42b181-7a29-426c-9c15-e253fc308886"],

Cell[TextData[{
 "The derivative of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"82cac170-9980-45bc-a893-40a08599cdd0"],
 " defined in an open neighborhood of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "a"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4707c570-5a3a-42e7-9c7d-436daec4ac6d"],
 " is defined as the limit"
}], "Text",
 CellID->263677741,ExpressionUUID->"61c96c7a-40f3-490d-8a82-fe9f8d57a315"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "a", ")"}]}], "=", 
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"z", "->", "a"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], "-", 
       RowBox[{"f", "(", "a", ")"}]}], 
      RowBox[{"z", "-", "a"}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->86919273,ExpressionUUID->"3c653d08-23b5-4c5a-9566-c17b7599ad80"],

Cell["\<\
Remember that for the limit of a complex function to exist, it must exist no \
matter the direction by which it is approached.\
\>", "Text",
 CellID->262595275,ExpressionUUID->"1f6579a4-0e01-48fa-9e0f-becbea29f712"],

Cell["The derivative can equivalently be defined as", "Text",
 CellID->194286438,ExpressionUUID->"ac200bdd-483e-47ee-bf42-5d5314c1bd7f"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "a", ")"}]}], "=", 
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"h", "->", "0"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"f", "(", 
        RowBox[{"a", "+", "h"}], ")"}], "-", 
       RowBox[{"f", "(", "a", ")"}]}], "h"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->177459430,ExpressionUUID->"a38ba3c9-2485-406e-8e1e-d1f727d6ddda"],

Cell[TextData[{
 "A function that is differentiable at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "a"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "32b34da5-6837-42f2-b8c7-834f15f7dfbb"],
 " is also said to be ",
 StyleBox["analytic",
  FontSlant->"Italic"],
 " or ",
 StyleBox["holomorphic",
  FontSlant->"Italic"],
 " at ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f47875c8-eb5e-40bf-833f-fd5457f58a1e"],
 "."
}], "Text",
 CellID->864437492,ExpressionUUID->"8979a778-68fd-4cf0-a898-9d8a56db87a1"],

Cell["\<\
It is called analytic (or holomorphic) in a region of the complex plane if it \
is analytic at every point in the region.\
\>", "Text",
 CellID->71325706,ExpressionUUID->"2f9c4598-5831-4b1a-af86-1f019bcdcb80"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->110820182,ExpressionUUID->"4ee0185e-1c07-401a-ad93-7ea768dd1ea6"],

Cell[TextData[{
 "The derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6c2f55bd-106b-41f0-9782-3f2cfb0edbec"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b7fd76de-32fb-479d-bb2c-46030fa98b77"],
 ":"
}], "SolvedExampleNote",
 CellID->714621731,ExpressionUUID->"dca106cf-5d61-4eda-9fa6-91d6d9b11b53"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"z", "^", "2"}], ",", "z"}], "]"}]], "SolvedExampleInput",
 CellID->246011873,ExpressionUUID->"b8683d35-65f2-4b2f-b7a6-0e1efc6cb008"],

Cell[BoxData[
 RowBox[{"2", " ", "z"}]], "SolvedExampleOutput",
 CellID->102954065,ExpressionUUID->"0dccc4f6-33ed-4ec8-8286-f50e73e9d5f2"]
}, Open  ]],

Cell[TextData[{
 "Plot both ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7c824d47-c0fc-4a2c-86bf-b1a93d8ae6aa"],
 " and its derivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "z"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "44e8c63e-cd51-4521-a38a-1c04b45cbe23"],
 ":"
}], "SolvedExampleNote",
 CellID->255907023,ExpressionUUID->"0c3b439d-0318-4437-aa29-fe14c0d2e990"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      SuperscriptBox["z", "2"], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", "SequenceIcon", 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Sequence", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["2", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["256", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       Sequence[PlotLegends -> Automatic, PlotRange -> {0, 15}],
       SelectWithContents->True,
       Selectable->False]}], "]"}], ",", 
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{"2", "z"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", "SequenceIcon", 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Sequence", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["2", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["256", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       Sequence[PlotLegends -> Automatic, PlotRange -> {0, 15}],
       SelectWithContents->True,
       Selectable->False]}], "]"}]}], "}"}], "]"}]], "SolvedExampleInput",
 CellID->943067975,ExpressionUUID->"3ac47f43-3a75-4b31-b024-6e33f26e6cd6"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJytnH2wl2WZxw9ve4AhMQlQdOPd1EQhMWHFriuaRMccEk1dJXMtV9RaXRit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        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJy1vWdUlee6773H+46xEpNY05OJNTGmiCJVxYqCvQFib7HX2HvBEkuw994r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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnHfczuUXx+/7/mrvtLfSUKEQpYVoallRdklJpGghLU0VSiIiMkNpoKTC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               "]], 
              
              Polygon3DBox[{{1041, 63, 62, 1042}, {1040, 33, 63, 1041}, {1037,
                34, 33, 1038}, {1010, 89, 58, 1007}, {1068, 897, 867, 1034}, {
               1032, 838, 839, 1020}, {1057, 843, 874, 1023}, {1044, 62, 92, 
               1046}, {1017, 839, 809, 1031}, {1046, 92, 91, 1012}, {1031, 
               809, 810, 1016}, {1051, 120, 89, 1011}, {1034, 867, 868, 
               1024}, {1021, 868, 838, 1032}, {1055, 812, 843, 1056}, {1036, 
               4, 34, 1037}, {1006, 58, 27, 1005}, {1053, 781, 812, 1054}}]}, 
             Annotation[#, "Charting`Private`Tag$31046#1"]& ]]}, {}, {
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             Polygon3DBox[CompressedData["
1:eJwtkr1OAlEQhS/clTcw/gTFH4wa4hOg1mppaWkiSqPvILLF8jprgRY8xxaI
yI+gFlqoiSbGM7lfcXZm7s7MPTPnrp5eHV/mnXP7ghcyfR6FVFiInKvqbFG2
p7glJMKM4hWdv8rfkn8muy07ku0LXR/qisKS8Kv4SPgRfBTuedOnLP9AdkO2
KJzo/FNxQf6e/A8fzqzXrjAXhZ7zUeB4C88Me4G180OhJrR94LemmrrsH1zq
5D8I90KT3Ab5T/yLhR3VXsvmZEsu5Nr8HfZhMybsx3jaDu7o18ZvcG8Kt4EP
O+1wt3HIM2tCn5Qa41nBt9oKfIyXcRxTbzsZCufChNj8L+q/hU30Mt1efNDC
NImZ17i8M5/pPEXTG+EZzssu5NqOcvJn0avAOxmQY3UjatfRuox2E3Tq0bfF
u+mzszF8rP+QWTL21WPvXXJrxFXeW8wcJThM0aDJjm22f1RRZD0=
              "]], 
             
             Polygon3DBox[{{1062, 870, 869, 1063}, {1066, 899, 898, 1067}, {
              1061, 840, 870, 1062}, {1050, 59, 90, 1052}, {1009, 61, 31, 
              1028}, {1048, 28, 59, 1049}, {1022, 873, 842, 1019}, {1028, 31, 
              32, 1008}, {1026, 2, 3, 1002}, {1003, 32, 2, 1026}, {1018, 842, 
              811, 1014}, {1065, 869, 899, 1066}}]}]}, {}, {}}, {{
           GrayLevel[0], 
           
           Line3DBox[{998, 1, 994, 902, 31, 61, 1045, 1030, 1009, 1028, 1008, 
            1029, 1003, 1026, 1002, 1027, 1004, 3, 2, 955, 998}], 
           Line3DBox[CompressedData["
1:eJwt0rcyRGEYgOEjx92Vc2wNN8Ad0KkYnUrOOWsoNcINcANCh4LRMSMVBgUX
ICuYkR5D8Zx35j/fnm9355Q3d9d3RQVBsEAcsaS6hAgTIY10MsgkixxeY4Kg
yfwoK2xxxhMRD62ijlbmOTC/pke6r+d6q98URwdBDY0Ms8QGJzwQMltsZwml
lFHOt/M22umgky666aGXPvoZ4JJBrhjimmFGGGWMcSaYZIppZpil0s7k2L8/
KoVPZ4n6oUn6rgn6phWkcu/7H7POIkM0UE0RX37/hbkbPdM9PdRVnaOFWioJ
82j9KZssM0KhnS8+88zD707uKHSvgHzyyCWHbLLIJIN0ds2n6Y5GdFvDGvp9
J0ghmSQSSSD+/735AR0NP0I=
            "]], 
           
           Line3DBox[{29, 28, 1047, 1048, 1049, 1050, 1052, 1013, 90, 60, 907,
             999, 30, 995, 959, 29}], 
           
           Line3DBox[{1015, 811, 841, 949, 1000, 871, 996, 985, 872, 873, 
            1058, 1022, 1019, 1018, 1014, 1015}], 
           
           Line3DBox[{870, 840, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 
            1066, 1067, 1069, 1025, 898, 899, 954, 1001, 900, 997, 989, 
            870}]}}}, VertexNormals -> CompressedData["
1:eJztfHlYz133bo95iMhMEQpFmcm4lTEkY0kZQgqVDOFJMo8RhUKhASEiQw+i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         "], VertexTextureCoordinates -> CompressedData["
1:eJyV22+o3mUZwPEhKlMq3ItILKGyosJqL3QRYieDtEyEFKyoEAURlNDMF9k0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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-2.999999793103448, 
        2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 
        15.}}, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True], 
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJx1nHuwl9V1hokI4h3kdgRU8FKNMsFaqk3FrjVm1AhSqzI1oiStRtGkiEFr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        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJytm2eUlVW2rs+4d4w2Ej223boLjIitkopQREGSiImcQZAcRIJkyUgQEcki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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnHncTdXbh88++1GaB42KzJqJSiopmVJKCkWDIUqEqFTKEKlESSRFE1JI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               "]]}, 
             Annotation[#, 
              "Charting`Private`Tag$31225#1"]& ]]}, {}, {}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0scyHWAYBuA/zjlKOHp3yNgSNyCxV3ZWyi4LJThK9GgpylgrN8ANaIOl
3IAyw5YbIGZsleeMxTPvt/hn3r/VfhtuT34IISyTHg0hNT9FQljjk7mJbmbY
5pArHsmzuIE2+llll3/c8Up1Wghf6GSKTfa54IG4nnpaOKLUHnplVF7LPvr5
zgCDDJFkmBFGGeMH40wwyRTTzDDLT+aYZ4FFlvjFb/5wTJnuvzImb2QPzdSR
w719n7PHBpN00EiCF+e+5YwdVuijlc/k8t/9XXLAFtN08ZV1HRm6a8zP5lOq
zQmqqKSCcsoopYRiiiikgPzUG5FLnByy+UgWmWSk3p0YKoOq4AjhJPL+H94A
1Js2EA==
            "]]}}}, VertexNormals -> CompressedData["
1:eJx1XHVYVdnXdkb9oWLH2Dk2gqJiYGwdO1BRbBRsUbFAsbsLDLDFwi4UE2XR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         "], VertexTextureCoordinates -> CompressedData["
1:eJyF22+onmUdwPERLo4R5HkRxTGhkopAaoT6JtYwalIEkYEIvagjSGBIunxR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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-2.999999793103448, 
        2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 
        15.}}, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->300311371,ExpressionUUID->"cf015d0f-97be-4aac-bab6-01a0ce237afd"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"bdd89605-2308-463f-8af6-eab8a65ea3c4"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->9519175,ExpressionUUID->"8703caba-9c43-4bcc-af41-60794980136e"],

Cell[TextData[{
 "The derivative of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["z", "_"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "18189e3e-c25a-4235-97bc-31f1c3b2de09"],
 " does not exist anywhere in the complex plane. This is because"
}], "SolvedExampleNote",
 CellID->22374429,ExpressionUUID->"db14fce8-f020-4778-b250-443f549713ff"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"7ea1002f-80da-4b9c-ab03-c5ae13363c08"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["d", 
      RowBox[{"d", " ", "z"}]], 
     OverscriptBox["z", "_"]}], "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"h", "->", "0"}]], 
     FractionBox[
      OverscriptBox["h", "_"], "h"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"00b900f0-875c-470b-a53a-37f1057df311"]
}], "SolvedExampleNote",
 CellID->112950487,ExpressionUUID->"2550590f-3e77-450d-8c2c-be10244d90fa"],

Cell[TextData[{
 "does not exist, as seen in ",
 ButtonBox["Chapter 7",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "SolvedExampleNote",
 CellID->37954302,ExpressionUUID->"99e432b9-07d8-4f3e-927d-354d9d7394db"],

Cell["", "SolvedExampleEndCap",
 CellID->1172503745,ExpressionUUID->"3704bcd2-4078-4667-a094-352d46549521"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Properties of the Derivative",
 FontWeight->"Bold"]], "Subsubsection",
 CellID->113221043,ExpressionUUID->"497c68ae-6457-48e0-b74f-79119fcedd97"],

Cell["\<\
The well-known properties of the derivative in real analysis, which are \
\>", "Text",
 CellID->135104506,ExpressionUUID->"32f031d5-6302-41a8-ad4e-adcb74ca8550"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["\[DifferentialD]", 
     RowBox[{"\[DifferentialD]", " ", "z"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", 
       RowBox[{"(", "z", ")"}]}], "+", 
      RowBox[{"g", 
       RowBox[{"(", "z", ")"}]}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "z", ")"}]}], "+", 
    RowBox[{
     RowBox[{"g", "'"}], 
     RowBox[{"(", "z", ")"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->25590853,ExpressionUUID->"22e92dc9-aedf-4b93-826f-3e280b06df87"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["\[DifferentialD]", 
     RowBox[{"\[DifferentialD]", " ", "z"}]], 
    RowBox[{"(", 
     RowBox[{"f", 
      RowBox[{"(", "z", ")"}], "g", 
      RowBox[{"(", "z", ")"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "z", ")"}], "g", 
     RowBox[{"(", "z", ")"}]}], "+", 
    RowBox[{"f", 
     RowBox[{"(", "z", ")"}], 
     RowBox[{"g", "'"}], 
     RowBox[{"(", "z", ")"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->338260851,ExpressionUUID->"b3785176-c21d-4c39-a484-40c7ba94a522"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["\[DifferentialD]", 
      RowBox[{"\[DifferentialD]", " ", "z"}]], "f"}], 
    RowBox[{"(", 
     RowBox[{"g", 
      RowBox[{"(", "z", ")"}]}], ")"}]}], "=", 
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", 
     RowBox[{"g", 
      RowBox[{"(", "z", ")"}]}], ")"}], 
    RowBox[{"g", "'"}], 
    RowBox[{"(", "z", ")"}]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->22201124,ExpressionUUID->"169b9c73-de94-41b4-8532-631583c36a81"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["\[DifferentialD]", 
      RowBox[{"\[DifferentialD]", " ", "z"}]], 
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]]}], 
    RowBox[{"(", "z", ")"}]}], "=", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["f", 
        RowBox[{"-", "1"}]], "(", "z", ")"}], ")"}]}]]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->497150033,ExpressionUUID->"9361077c-a3cf-4589-bdf4-a3217eac4239"],

Cell[TextData[{
 "are still valid in complex analysis. Here, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["f", 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "114f4cb1-0ad3-4c6f-b849-e88d5865462e"],
 " refers to the inverse function, i.e. the function such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"f", "(", "z", ")"}], ")"}], "=", "z"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a312dde6-1a2e-49a9-830e-63f098da7c67"],
 "."
}], "Text",
 CellID->494180068,ExpressionUUID->"59656303-7013-4ce8-b8cd-a459915945f8"],

Cell[TextData[{
 "In Wolfram Language, the derivative is computed using the command ",
 ButtonBox["D",
  BaseStyle->"Link"],
 ". Wolfram Language is aware of these rules. For the derivative of a sum:"
}], "Text",
 CellID->39750712,ExpressionUUID->"ad766221-33f7-4df3-9739-3b77e955fcd9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], "+", 
    RowBox[{"g", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellID->447744683,ExpressionUUID->"cf023117-bfcd-4e8c-955c-09d2e00ca123"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "z", "]"}], "+", 
  RowBox[{
   SuperscriptBox["g", "\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellID->73693202,ExpressionUUID->"6ec3c609-fb9a-40fe-8545-d84d045f2976"]
}, Open  ]],

Cell["Of a product:", "Text",
 CellID->551864373,ExpressionUUID->"4f67bf74-5e2f-4e37-a538-54a3bdd997a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], "*", 
    RowBox[{"g", "[", "z", "]"}]}], ",", "z"}], "]"}]], "Input",
 CellID->69892618,ExpressionUUID->"bf5896c6-58ab-4c4b-86cd-e80269987a8f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "z", "]"}], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}]}], "+", 
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], " ", 
   RowBox[{
    SuperscriptBox["g", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}]}]}]], "Output",
 CellID->268256969,ExpressionUUID->"f580c159-62d6-45e1-848c-d0f3ec212589"]
}, Open  ]],

Cell["Of a composition:", "Text",
 CellID->112933372,ExpressionUUID->"66084285-90d7-4461-a631-4c8b9fdbff22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", "z", "]"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellID->76214329,ExpressionUUID->"9db91e66-fda7-43f0-b44c-113c304340e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{"g", "[", "z", "]"}], "]"}], " ", 
  RowBox[{
   SuperscriptBox["g", "\[Prime]",
    MultilineFunction->None], "[", "z", "]"}]}]], "Output",
 CellID->386038796,ExpressionUUID->"32192fc3-feaa-440f-9e84-bda13353f268"]
}, Open  ]],

Cell["And finally, for the inverse:", "Text",
 CellID->425256752,ExpressionUUID->"13c0642c-7781-49ad-950f-8f02aad7b18f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"InverseFunction", "[", "f", "]"}], "[", "z", "]"}], ",", "z"}], 
  "]"}]], "Input",
 CellID->102440091,ExpressionUUID->"31c9edb8-1369-41b7-8fc0-47f3f64aff51"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{
    TagBox[
     SuperscriptBox["f", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]],
     InverseFunction,
     Editable->False], "[", "z", "]"}], "]"}]]], "Output",
 CellID->34156602,ExpressionUUID->"a157b7a2-7499-478c-9fbd-03b8308f6957"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Important Derivatives", "Subsection",
 CellID->345123475,ExpressionUUID->"be7ce05f-35ca-484a-a725-6c6188079c73"],

Cell["\<\
Table 1 lists a few important derivatives of elementary functions. Together \
with the properties listed previously, they allow us to compute the \
derivatives of most commonly encountered functions.\
\>", "Text",
 CellID->1662575,ExpressionUUID->"5f17c29f-9a98-4a5f-abd3-8e27c0b65b0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", ",", "a", ",", "P", ",", "Q", ",", "ts", ",", "f"}], "}"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ts", "[", "a_", "]"}], ":=", 
     RowBox[{"ToString", "[", 
      RowBox[{"a", ",", "TraditionalForm"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"TableForm", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ts", "[", 
             RowBox[{"z", "^", "a"}], "]"}], ",", 
            RowBox[{"ts", "[", 
             RowBox[{"a", "*", 
              RowBox[{"z", "^", 
               RowBox[{"(", 
                RowBox[{"a", "-", "1"}], ")"}]}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ts", "[", 
             RowBox[{"Exp", "[", "z", "]"}], "]"}], ",", 
            RowBox[{"ts", "[", 
             RowBox[{"Exp", "[", "z", "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ts", "[", 
             RowBox[{"Sin", "[", "z", "]"}], "]"}], ",", 
            RowBox[{"ts", "[", 
             RowBox[{"Cos", "[", "z", "]"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ts", "[", 
             RowBox[{"Cos", "[", "z", "]"}], "]"}], ",", 
            RowBox[{"ts", "[", 
             RowBox[{"-", 
              RowBox[{"Sin", "[", "z", "]"}]}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{Cell[TextData[Cell[BoxData[
             FormBox[
              RowBox[{
               RowBox[{
                SubscriptBox["a", "n"], 
                SuperscriptBox["z", "n"]}], "+", 
               RowBox[{
                SubscriptBox["a", 
                 RowBox[{"n", "-", "1"}]], 
                SuperscriptBox["z", 
                 RowBox[{"n", "-", "1"}]]}], "+", "\[CenterEllipsis]", "+", 
               SubscriptBox["a", "0"]}], TraditionalForm]],ExpressionUUID->
             "445edf80-6553-467b-bae5-ea7aae3cbbde"]],ExpressionUUID->
             "34cebcd5-f923-41c4-a310-1cbc61076fcc"], ",", Cell[TextData[Cell[
            BoxData[
             FormBox[
              RowBox[{
               RowBox[{"n", " ", 
                SubscriptBox["a", "n"], 
                SuperscriptBox["z", 
                 RowBox[{"n", "-", "1"}]]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"n", "-", "1"}], ")"}], 
                SubscriptBox["a", 
                 RowBox[{"n", "-", "1"}]], 
                SuperscriptBox["z", 
                 RowBox[{"n", "-", "2"}]]}], "+", "\[CenterEllipsis]", "+", 
               FormBox[
                SubscriptBox["a", "1"],
                TraditionalForm]}], TraditionalForm]],ExpressionUUID->
             "b6e7d9d0-1819-405d-850c-d1515fc1cc36"]],ExpressionUUID->
             "3f726c6d-a8ea-48f1-9d61-4b939dd98e07"]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ts", "[", 
              RowBox[{
               RowBox[{"P", "[", "z", "]"}], "/", 
               RowBox[{"Q", "[", "z", "]"}]}], "]"}], "<>", "\"\< with \>\"", 
             "<>", 
             RowBox[{"ts", "[", "P", "]"}], "<>", "\"\<, \>\"", "<>", 
             RowBox[{"ts", "[", "Q", "]"}], "<>", "\"\< polynomials\>\""}], ",",
             Cell[TextData[Cell[BoxData[
             FormBox[
              FractionBox[
               RowBox[{
                RowBox[{
                 RowBox[{"P", "'"}], "Q"}], "-", 
                RowBox[{"P", " ", 
                 RowBox[{"Q", "'"}]}]}], 
               SuperscriptBox["Q", "2"]], TraditionalForm]],ExpressionUUID->
             "68e8845f-b57d-4968-873a-572bbf1c8d57"]],ExpressionUUID->
             "1e6f25b8-6698-4275-b030-373e6fddeb37"]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"ts", "[", 
             RowBox[{"Log", "[", "z", "]"}], "]"}], ",", 
            RowBox[{"ts", "[", 
             RowBox[{"1", "/", "z"}], "]"}]}], "}"}]}], "\[IndentingNewLine]",
          "}"}], ",", 
        RowBox[{"TableHeadings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"None", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{"f", "[", "z", "]"}], ",", "TraditionalForm"}], "]"}], 
             ",", 
             RowBox[{"ToString", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"f", "'"}], "[", "z", "]"}], ",", "TraditionalForm"}],
               "]"}]}], "}"}]}], "}"}]}]}], "]"}], "\[IndentingNewLine]", ",", 
      RowBox[{
      "Text", "[", "\"\<Table 1. The derivative of elementary functions.\>\"",
        "]"}]}], "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellID->33602098,ExpressionUUID->"d6fee6d7-af0d-4d3c-a2b1-b3de176d417d"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    TagBox[
     GridBox[{{
        TagBox[
        "\"\\!\\(\\*FormBox[RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\"", HoldForm], 
        TagBox[
        "\"\\!\\(\\*FormBox[RowBox[{SuperscriptBox[\\\"f\\\", \
\\\"\[Prime]\\\", Rule[MultilineFunction, None]], \\\"(\\\", \\\"z\\\", \\\")\
\\\"}], TraditionalForm]\\)\"", HoldForm]}, {
       "\"\\!\\(\\*FormBox[SuperscriptBox[\\\"z\\\", \\\"a\\\"], \
TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[RowBox[{\\\"a\\\", \\\" \\\", \
SuperscriptBox[\\\"z\\\", RowBox[{\\\"a\\\", \\\"-\\\", \\\"1\\\"}]]}], \
TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[SuperscriptBox[\\\"\[ExponentialE]\\\", \
\\\"z\\\"], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[SuperscriptBox[\\\"\[ExponentialE]\\\", \
\\\"z\\\"], TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[RowBox[{\\\"sin\\\", \\\"(\\\", \\\"z\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[RowBox[{\\\"cos\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], TraditionalForm]\\)\""}, {
       "\"\\!\\(\\*FormBox[RowBox[{\\\"cos\\\", \\\"(\\\", \\\"z\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[RowBox[{\\\"-\\\", RowBox[{\\\"sin\\\", \
\\\"(\\\", \\\"z\\\", \\\")\\\"}]}], TraditionalForm]\\)\""}, {
        InterpretationBox[
         Cell[
          BoxData[
           Cell[
            BoxData[
             FormBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["a", "n"], 
                  SuperscriptBox["z", "n"]}], "+", 
                RowBox[{
                  SubscriptBox["a", 
                   RowBox[{"n", "-", "1"}]], 
                  SuperscriptBox["z", 
                   RowBox[{"n", "-", "1"}]]}], "+", "\[CenterEllipsis]", "+", 
                
                SubscriptBox["a", "0"]}], TraditionalForm]]]]], 
         TextCell[
          RawBoxes[
           Cell[
            BoxData[
             FormBox[
              RowBox[{
                RowBox[{
                  SubscriptBox["a", "n"], 
                  SuperscriptBox["z", "n"]}], "+", 
                RowBox[{
                  SubscriptBox["a", 
                   RowBox[{"n", "-", "1"}]], 
                  SuperscriptBox["z", 
                   RowBox[{"n", "-", "1"}]]}], "+", "\[CenterEllipsis]", "+", 
                
                SubscriptBox["a", "0"]}], TraditionalForm]]]]]], 
        InterpretationBox[
         Cell[
          BoxData[
           Cell[
            BoxData[
             FormBox[
              RowBox[{
                RowBox[{"n", " ", 
                  SubscriptBox["a", "n"], 
                  SuperscriptBox["z", 
                   RowBox[{"n", "-", "1"}]]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"n", "-", "1"}], ")"}], 
                  SubscriptBox["a", 
                   RowBox[{"n", "-", "1"}]], 
                  SuperscriptBox["z", 
                   RowBox[{"n", "-", "2"}]]}], "+", "\[CenterEllipsis]", "+", 
                
                FormBox[
                 SubscriptBox["a", "1"], TraditionalForm]}], 
              TraditionalForm]]]]], 
         TextCell[
          RawBoxes[
           Cell[
            BoxData[
             FormBox[
              RowBox[{
                RowBox[{"n", " ", 
                  SubscriptBox["a", "n"], 
                  SuperscriptBox["z", 
                   RowBox[{"n", "-", "1"}]]}], "+", 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{"n", "-", "1"}], ")"}], 
                  SubscriptBox["a", 
                   RowBox[{"n", "-", "1"}]], 
                  SuperscriptBox["z", 
                   RowBox[{"n", "-", "2"}]]}], "+", "\[CenterEllipsis]", "+", 
                
                FormBox[
                 SubscriptBox["a", "1"], TraditionalForm]}], 
              TraditionalForm]]]]]]}, {
       "\"\\!\\(\\*FormBox[FractionBox[RowBox[{\\\"P\\\", \\\"(\\\", \
\\\"z\\\", \\\")\\\"}], RowBox[{\\\"Q\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}]], TraditionalForm]\\) with \\!\\(\\*FormBox[\\\"P\\\", \
TraditionalForm]\\), \\!\\(\\*FormBox[\\\"Q\\\", TraditionalForm]\\) \
polynomials\"", 
        InterpretationBox[
         Cell[
          BoxData[
           Cell[
            BoxData[
             FormBox[
              FractionBox[
               RowBox[{
                 RowBox[{
                   RowBox[{"P", "'"}], "Q"}], "-", 
                 RowBox[{"P", " ", 
                   RowBox[{"Q", "'"}]}]}], 
               SuperscriptBox["Q", "2"]], TraditionalForm]]]]], 
         TextCell[
          RawBoxes[
           Cell[
            BoxData[
             FormBox[
              FractionBox[
               RowBox[{
                 RowBox[{
                   RowBox[{"P", "'"}], "Q"}], "-", 
                 RowBox[{"P", " ", 
                   RowBox[{"Q", "'"}]}]}], 
               SuperscriptBox["Q", "2"]], TraditionalForm]]]]]]}, {
       "\"\\!\\(\\*FormBox[RowBox[{\\\"log\\\", \\\"(\\\", \\\"z\\\", \\\")\\\
\"}], TraditionalForm]\\)\"", 
        "\"\\!\\(\\*FormBox[FractionBox[\\\"1\\\", \\\"z\\\"], \
TraditionalForm]\\)\""}}, RowSpacings -> 1, ColumnSpacings -> 3, 
      RowAlignments -> Baseline, ColumnAlignments -> Left, 
      GridBoxDividers -> {
       "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}}, 
      ColumnAlignments -> Left], {None, OutputFormsDump`HeadedColumns}], 
    Function[BoxForm`e$, 
     TableForm[
     BoxForm`e$, 
      TableHeadings -> {
       None, {"\!\(\*FormBox[RowBox[{\"f\", \"(\", \"z\", \")\"}], \
TraditionalForm]\)", 
         "\!\(\*FormBox[RowBox[{SuperscriptBox[\"f\", \"\[Prime]\", \
Rule[MultilineFunction, None]], \"(\", \"z\", \")\"}], \
TraditionalForm]\)"}}]]], 
   InterpretationBox[
    Cell[
     BoxData[
      FormBox[
      "\"Table 1. The derivative of elementary functions.\"", TextForm]], 
     "InlineText"], 
    Text["Table 1. The derivative of elementary functions."]]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {FontFamily -> "Sorce Sans Code"}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->326176517,ExpressionUUID->"4b63afe3-c26f-42b9-bd31-ef60958e3f8a"]
}, {2}]],

Cell["\<\
Let\[CloseCurlyQuote]s use the properties of the derivative and the \
derivatives from Table 1 to compute the derivative in some examples.\
\>", "Text",
 CellID->131808803,ExpressionUUID->"6116edd9-a2db-4a14-a8a0-2ce95d8ebd29"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->336919484,ExpressionUUID->"342356cb-d029-47fe-b72a-8b8898414d80"],

Cell[TextData[{
 "Compute the derivative of ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"1", "+", "z"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "da27d278-92d3-4923-87ac-d99ce886fa6f"],
 ". This is the composition ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"g", "(", "z", ")"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b58da8e8-b4fb-4812-b88a-ba2f4b442d80"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SqrtBox["z"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e74910d7-3588-4b2c-bb28-e853fde25b83"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    RowBox[{"1", "+", "z"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "924b07ca-6cdc-4469-94b0-3883dbbba969"],
 ". So the result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "z"}], ")"}], 
        RowBox[{"1", "/", "2"}]]}]], "\[CenterDot]", "1"}], "=", 
    FractionBox["1", 
     RowBox[{"2", 
      SqrtBox[
       RowBox[{"1", "+", "z"}]]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ec74aa72-acc9-4908-b83d-8cc41774c253"],
 ". With the command ",
 ButtonBox["D",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->87602613,ExpressionUUID->"3b35d260-4574-47a6-bc96-bcf89eda12b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", "z"}]], ",", "z"}], "]"}]], "SolvedExampleInput",
 CellID->277161573,ExpressionUUID->"faf3bf19-bb0b-458d-b1a9-7d3bac342594"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"1", "+", "z"}]]}]]], "SolvedExampleOutput",
 CellID->782466814,ExpressionUUID->"9b95335b-267a-48db-86e1-a8caee67dee1"]
}, Open  ]],

Cell["Plot both functions:", "SolvedExampleNote",
 CellID->125266278,ExpressionUUID->"30d0ff28-3739-4225-a642-62be3aedc6b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", "z"}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", "SequenceIcon", 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Sequence", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["2", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["256", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       Sequence[PlotLegends -> Automatic, PlotRange -> {0, 2}],
       SelectWithContents->True,
       Selectable->False]}], "]"}], ",", 
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"1", "+", "z"}]]}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", "SequenceIcon", 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Sequence", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["2", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["256", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       Sequence[PlotLegends -> Automatic, PlotRange -> {0, 2}],
       SelectWithContents->True,
       Selectable->False]}], "]"}]}], "}"}], "]"}]], "SolvedExampleInput",
 CellID->630734095,ExpressionUUID->"517f5911-e769-4cb2-8a75-b03657ada615"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJzVnHdQVle3h0Epauy9kdhQg5LYxbq3LVGMQlBjgYgVS8TeSwSNijGxoyKJ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        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJzVnGe0ldW1hjPuHUOaRk217H0QlGKjCYoFE40pxhijxkSNJtGIJfbeEgux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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnHf819MXxz9LZSaRTVtGSsNK01YpqZ+ZkkhJ2WQTZQu/KG2bL8KPIkmp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               "]], 
              Polygon3DBox[CompressedData["
1:eJwlkckuhFEQRm93F2lzjI02tdaGtHloBBFNJLYSsSQ2dmxYWlra9Ct4AR7B
AxBvYE/iDSTOl29x/pzcqr9uVd3S1e3pTTalVIaAfT7fHPzAJH4E9VxKhzCD
78E7sQ+YwEvhXJ0p1gPXmZROYAkPOKNuDXJ4NuwFyOBdUCW3HTrxNvgk9gqt
+HT47grU8Wa4S67ZhB/DBbFLmMMH4Itab7CG98Jjxj0t47PhXM2k2bZVj97v
YQTvD//7DKt4X9hVYwXvgN/kHufxlnCvDcjjU+qZ2nk4CM+k2fTPQngGzaKc
Ct4d3pV2sIiPh3f7Arv4WNgbsBO+Q3dpB1V8NBzTDJplGM7lsImXw73oTfW2
xfCsytnCh8K5RajhBfjLeIfr+GA4prMN/Akect65dv8PnsEvUQ==
               "]]}, Annotation[#, "Charting`Private`Tag$34003#1"]& ]]}, {}, {
          
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             Polygon3DBox[CompressedData["
1:eJxNlElP1EEQxf8wfRHRs7KYeBKJd5nBI5uoUTHOgisMM+IGRmUgasBBJCKE
CwOfYIxnGD6Bp7kQ0TuJxAsHFj+B8VXqR+TwUr1UV796Vd1nB0f7RmqjKJoT
YsJMiKIODT7KXhWSWrsmuyun41qvE+aFBeGS9qa0d0zj97I54VdNFOVl9+Rf
H/MzaxovCSWhJeb+Fue2/A4UIym7IjsuTAjT2ssKQ0JRGGReEcpCXtgRNoQZ
oaQzY0JByCrWN3EYkl1mzeL+EP5Eft8HYufgcT7mvIo6c052WvaR8FdxhoNz
txxWhXHNv8tOBM+tlfPtketimgyYHsKUMCC/suIMyo4Fj1HAbtZ6rMeaN8k+
IfZ+rev3Ft3fBfddhcdTzROyz2RHhYLGL6iD5WE5vIL3a9nnQlrjkeAabqCj
cRxA39Pi3SZcFLbxMd/fQlU4g4ZrQkXo4p4WNDAt6tGijvkd3der3O/Krkde
jxXOl5hbvCXmVpPOmMe2encw7wvudyt4zWy/O+a1PKn4J2q8tsbvp5AKvpYO
Prf77P48eVuMHri2kusX9qrkvMB4i9ytLzNCf+T+O5yx/koJaepvfdAsNAhx
NB1nPwOHbu5v1DyBXwXulsMWd3/FtwWuZe60/r0RXLebwf2qvMumyDkk4LnN
GzGdDngDVqc9+mxR5ydNh+D8EpyfpJ/sfafII04ecfyq6DRPvXfp2zf0rfVv
HC0a0WGFulufnYq873qCjy/LvqRvrX/74WJvKsmZozxSoMD7T3NHAa0nmF9H
K9OsN3icK8FzMF5N9F+Ffmynzod6ZIjdjm8zdywf6eN1zreRUwOcSvR3mbrl
qGUPtW0jB8vvgTjNqk4P+Ye66P99/olN/s9u9oaIOc1/be9lNvh+Pvb/reTw
vae9YcW/L7tA3RfpH6uh5fUp+J8wFxw2/hw8lyRcL/DmrKc6iZ3lHynyr2Th
VeQdH+6neZsZ2X/fbbkt
              "]], 
             Polygon3DBox[CompressedData["
1:eJwlkUkuhFEURp/yTUjMDUzEwMRcYsxAH4XSN1W60lUhqjTREwSzsgQbYAk2
IHZgAcQOxLn5BufP+fO++96977UWytlSJqXUBoJFPrd1Kb1APhy661MqwB1e
hD/WWihaxy+ggbV2uMQLcu07LOHLsn/BCr4h13bBJn4l1/bANb4qZ+OMNbwf
OukrBwP4I5yTPYMnPAe/rDWRn8CHoMJ/DYbxXmhO3qMPH5T3ikxk96FGL69Q
wU+hsd4znckzx+x5uMeP4IfsNxzLPUfvcUc3+C48Z7znHl6V9/6AA3xE7u0N
svio7J8whs9CH7MUYQ6flz3eZEHORDZmHse35LuchG38RO4tZohZDuWzo+fo
fUq+qw6YxktybRXK+I7sMUPMEpnIRk8z+IN8F/EG8Rb/btpB4A==
              "]]}]}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0stO00EUB+DpjbaU3i94Q6wiSrCIKCggigoa486dYedGi1K8F0TWJCYu
jYlbIg+g8Ql8AsMLCBuWxifQ7x8XX+Yk52RmMr9pPly934mFED6znwghqnet
7xlUz7HEOp/4HvX5Q9Fwi3u02eILP9jjLwPxEGZ5QJePfOMnv8k7Z5S7bHPA
I37xlce0WeYJT1mhwyrPeM4LXvKK17yhyxrrvGWDd2zyIRnCbUa4w1kWOMMi
w9zkNLcY4ganuM5J5mkyxwmuMchVjjPLANMcY4ajXOEIlznMFIeYpJ9LNLhI
nQlqXKDKOBXOU2aMEkUKtMhzjj5y9JIlwyhpekiRJEGcWHQH2TaoU6NKhTKl
KHcK5OkjRy9ZMqTpIYXtgucOog47if9/7B+CFy4w
            "]], 
           Line3DBox[CompressedData["
1:eJwt0TkuhAEYBuDfUoraMiTaiROIAzD2sY19Z+z7GGOdxVijEicgepzACUQv
IRqVOIF4JIon31u9X/HWjC9HlwqCIEhRThkNxUHQSIQmmmmhlTba6SBKJ110
00MvMfroZ4BBhhhmhFHGGGeCSaaYZoY4s8wxzwKLLLHMCqussc4GmyTYIsk2
KXbYZY99DjgkTYYsOY7Ic8wJp5xxzgWXhP86inRwSJoMWW75JMc7D0zTQJgS
vgqD4Jl7rkgQo44QP4Z444kb8sSJUEsp3/Z54ZFrkvRTz4UfH1TLr+4dVXKI
Sir+N/4FtbI5Mw==
            "]]}}}, VertexNormals -> CompressedData["
1:eJzUfHk01e3fLippojJGZIqSkEZNH/MQDRQZm2SoDIkMkVSEJELIUEgypYyZ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         "], VertexTextureCoordinates -> CompressedData["
1:eJy9m3twVcUdgNEBBXwM2IcahIqIhUKFUkCJ4KqlwScqthZRqgEBRacqxRHk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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-2.999999793103448, 
        2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 
        2.}}, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True], 
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJyNnHd4TlnXh/UwOkN0YojehxFtbb13ozPG6GUQJrroNWr0SKKFRJvo5EWi
RYYgyZNeiBIRkZ6IEnzfQ35rX3Peb13X559zuW2n7H2f8+yy9rIaP2vQxHx5
8uSxKZAnT/7/Pf5dvu3Lr18tfHC85bc9p11kANWJ/WFNt+GFmE/cn1jgbdVA
cvWIrL3ZswDzOVk3U7LHBpLl3BO+psL5mZfrUK5zxwOBtLXdosmVfs/L/KPV
j483BQdSyWI7S92y/eoNXmvbsMIbCwVRHtcWg/r/lMN8dFTA3qSmQZTWzOQY
bXrPfM+uVsuWDAqi53dsQ6auzmJesk10SN1pQWQaVsYy++d05oWn1OxVd34Q
rQ/542zhB0nMhxasNMliYRBN+3T4558axjMfn/Nb94uzgqiP1fPL7TfHMv/P
nXZj14wKolFbOtl5RpuYb0jyjLVuH0QLpuTP2LXYi3n7zFfHHcsF0ZLvnMCP
5j99/kNcII3+fh7mQQ1LVj7ydyCuy9x1Z+k7T+cG4j6Zn5qY0TCjRSCei7mp
QbPBFmkBqAfmQ51SL9Q6FYB6Y95n27NLjScFoJ6ZB3vknfSiegDahXlqn1UW
/zn/GO3IfML0odFN6j1GuyvwJrR16IuDj+AJ8yNuhRtOqPwIXjGvO7LphYr7
HsJD5gFDV1v1rvQQ19PnOexuqu3qz/cBf0sXO7kwtHMg+4xjga9x2eu2aZ/B
V/TfYB8eqX0G73ik3ok5VkHsM/jJyKtBj8cHsc/gP5XMSu3nrH0GfzOm2yF6
rH0Gv9i5d74C2dpn8DVkn795WRP7DD5h4ft1l2qa2GfwWjS9ZUYtE/sM3r7e
7kcBFU3sM3jR4lOzb+Y1sc/gvcZHX78Yo30GP5Nh9TnnjPYZ/NFnjx7m9ws+
g9uv+tHr5S/8HjHPO6Lb8+h07TP42iflChzy0D6DTymZtHXPmED2GXx79vDm
WSUD2WdwT7vyz7xuap/B689eW/rKXO0z809pM7daB7DP4Nd3dbJbeFH7zD70
PFOkldVj9hnc2m3X1+Bt2mfwkotnuJ0s8Ih9Bq+W2rJP0hLtM3harXnJ5z5o
n+Fpw6H387qf0z6DL3a6UyW6SBD7jGNcwIf7dX8LYp/Bl07fVOmDp/YZ3C+k
zzDbz9pn8IW/3eywopOJfQYfO3DAi4ylJvYZfJvb3g8HT5vYZ/BhffvH7nus
fQbvWmbj/HHPtc/g796MmlE+TvsMXvHG9A/7w7TP4G9SAmZs9dI+g6/tG9+2
41YT+wxeucXUGfbDTOwzeI3IfzwmljOxz+C+cde/1HmgfQb3uHF3bvwi/h1h
PuVJxaOO1vy7w9wixW1jxGPtM3gJy0XDqi7QPoNvGN+w1pIagewz+P720+YE
/aN9Br+2/EPmnXnaZ/DqbWrluW8VwD6D1+3o8HLCYe0z+OplvUb8Uegx+wx+
bsauY36ztM/graJeXDj5RPsMHjgj+V2Rwcx94KOLpbW7uX7gM3iN1u5bftio
fQY/v6hCrQlvtc84HhtT6Oy93ib2GXzrjYrx6W4m9hl80+DBS7q81z6Dnyjj
VT6Sgtln8Co/Nipyd2Ew+wzer8+J+MFHgtlncLsZDRImeQWzz+DOLT6Ovn49
mH0G35np7lXndDD7DN7DYcbgrRuC2WfwUW2i2wYOCWafwd3Gf/GbXzqYfQZ3
jw1sN+mW9hl848S0Yhun8XvEvNWIn11civF7x7xUpQ9JFie1z+DNnh+reqs7
97uYB24YuXHcS+0z+KkR3TeVX6l9BrdNu590xyqQfQZvWsz1duE72mdw33+e
LOg5VfvM37krT5vcLR3APoM3v1a4QqvF2mfwmDZF3x6L0D5zu485bv2wwyP2
GbztXY+/Vp7QPsO7rqfsr3R01T6D/6ex76GvpfR3BLzEzjYuMSt1e4DnNG/S
yCdd+4xj+qrPn5PHBLPP4EctLNeUvxnMPoMPXGqVPrFCCPsM7jBxk53ptxD2
GTyxy+fL6x1D2GfwCVd/qDTNM4R9Bt+x4F6z/RdC2GeuB9tyXoGuIewz/85c
cug+c24I+ww+5aj/qQbNQ9hn8NFV7hy58FT7zNfdPuR4ieXB7DN4aunnjepY
8nvE/Enx3juXu2ufwX9fm92h8C/8u8M8e1eRmGJ3tc/gTqVcu/ccwv005vZZ
086Z+/PwGVwlRyVlLNI+g4fU6W9/oyyPg5g367HI8ain9hm8QT/nVr4Dtc/g
X0OOfuqZrH1mf6bUVKM6Pmafufz2TdbLDmifwYvmd7P97av2GX51W3Svf+Eq
uj8Hvq9d0tXBLtpn8LXLOw5zqRnMPoO3+rI7ac+xYH5OcAfPoaHF6oSwzzgG
Lhl03ewPfAbvdSeia2jRUPYZ/PyzYoPtJoayz+DD5qbXqnA8lH0G7/3h/asi
/qHsM7j74X2mqYGh7DP4zuFnrvtdCmWfwbdtXhDeeVko+wye4DTl9x8ahrLP
4Cev7Z+46m4I+wz+8UTllxMGhLDP4F8uDGz2OVD7DG7XetIpv378O8Lces+V
K33ua5/B00YO8rDqzv0u5qeu7X344z3tM/irw5N/HNSbxynMa/087oF5/A6f
wWvmvdSryh/aZ3C/HefX18jWPoOXyixcw2Gb9hm89bH5Cb80CWCfwW94uXiF
u2mfuT7zD9of+E77DD5pX9rhgAHMfeDRyOIfnfydtM/gzm6n71g1C2afwT/Y
HOjZ/IH2GXz6D8UjXCeHsM/gTfyrDXqYL5SfH3ziete6zntC2WccZ7XwdRpT
PYx9Blfr0k6V2xHGPoOfz6nlOT4+jH0GzztsaNZry3D2Gfymd8m2eaqHs8/g
AdeSNqZ/CmOfwR9tsinc9FwY+wxePE9U4dE9wthn8LL9Tnfx9A1ln8H/2nph
+dSWoewzeIHbOUsvOvHvAvNWIV0zbL5qn8EbBPu2KjGB+1HM+3UdMjndX/vM
57EZkrK/LY87mO+bElXOPN6Bz+BXSiTn2DXicTrzPS4FbWqf1T6DV8xq5RHV
lue1FLhv8S+dBjzUPoMfy944x3qi9hm8z5xuTT/k43k25udqVM5/u89j9hn8
Yk+76Exn7TN8qWXf3PNJlWD2GXxS4znZAfe0z+D5Jsx9MGZxCPsMvrdK5fXm
9oLP4G/ORwc3Tdc+g0flORF57mQY1wv4255RHdqPCGefcTyxecnExSnh7DPf
f+Iqten3CPYZ/Oe47qY/jkSwz+CbKxc5VuZ0BPsMnnPzT/dRSyPYZ/AmPZML
1q8UwT6Dx3fb57tuSzj7DN7tgP8J8/sFn8EbWqW+vdU0jH3m86xqs6X7PP5d
YH48dsyQR1e4X8Tc7anL8H/ycT+K+aNqi23M/Xn4DF7CfZ1HC0/tM3himRLu
5vEpfAY/2uNu1aGrtc/gP/R7+cUtR/sMbtX3s8l/qfYZfGiz5HNNLHgejPn1
Lr4tm+zVPoNfGXbLtUlT7TO47fy4422ctc/gt8fms3gSp32GFxe7ldxvOqB9
Bp/nvG+hub8Kn8Ht7BvYX24ayj6Dd7dae7t1iTD2Gfz0jR3VSmSFsc/gBXac
f+7/JJx9Bv9U8J7PcZ8Iri/wd7ud5x3bGMk+4zhx+tbiG+pGsc/gZ84fKHB0
TRT7zDzsTuBfjlHsM/j6gMULz/SPYp/BX9qYWtHdSPaZ7+dzjP0Oi0j2GXxW
yLXFRxtEsM/g72/sL/Zj53D2GfzekQanx47k3wXmPzxfkdhpIfeLmFtHzopK
O6J95vvfU2R9p2jtM/gW53kDzP1D+Azus7pJ4EE77TP4i9C0fkvCtM/gwX96
7W/ZheepmL+2GdXa9z/aZ/CK9Cy8cXvtM7j7rJo7lt/TPoNnDOl2K3aE9hl8
wWr7rLLx2mdwpw/up3bXeazn3zEf8P5zpnn8BZ/BfY4t7zs+S/sMnjyv2t/1
4rXP4H08Lqxvkax9Bq83dZ1rYuEI9hl8S8TDftHNItln8IJrkid+HB3FPoOH
lv1c1W1eNNcj+L24FgnHh8ewzzjuM/1lvf5FDPsMHpEUsNr2fQz7DL4zOGWN
644Y9hm8hkd8TBu/aPYZfPqnT9u9r0exz+Cp65LmNNgdyT6DLyl1J9h7WgT7
DH6q3tuX03uFs8/gla81Xra8XRj7DJ6y18HDuTOPC5jfyfpztvn7A5/BH4Ze
mZC2VfsMHrS4S8XOQdpn8JgFcc3M8/PwGXxe7OT0tmu1z+BfahfbvCRT+wy+
cvaWXupP7TP4hpZ+f3dI1z6DL22ZMnO4vfYZ/K5HfkvHHwPYZ26v1bvq1huv
fUY7p6z5a+D0TdpncMd1g8b1WhXKPoNHfvTIO3tvGPsM/mZB9t5fH4Wzz+AR
A4u71KsTyT6DJ3wadnjaoSj2GbzwsHK//9Iihn0G39LfodrBW0/09yiXd5q3
rc2NEtoD8GsvK1kXWBbLPuM4dJlNZNOtsewz+AeLhg6u7WLZZ/DJO/ZYDKGn
7DP4DKsTLTZ6xbDP4HOf3Zy8t3Y0+wwe4376yD+HItln8J/8ttmNbs/9HOZj
flm2xtyfh8/gK86UuN8uWvvMz3to6asCUdpncJepcV7Omdpn8JHFI9usqM3z
orqeHIsXNc8fwmfwm9Und85zU/sMntfO57B5vhc+sw/D+qv++7TP4HVHr8zv
YMnrdMwf2ta2eOmqfQZ3ONjgYJ1m2mfwHmNSO7vv1D6jPdv+5DwsPVX7DB6x
st3TpHxh7DN4obH3e99rG84+8zxu3SeR5v4qfAZ/uujs2ZWdothn8OUHiu0I
qxHDPoNXv/Glstkf+AweXip86qs7+vcYvMnqlo7OMc/YZ/C4JzOLnD78nOud
n+v+2cWrbz1nn3EcYVXrj8KNnrPP4MXa1G243/oZ+wy+c/LTfHnyxLLP4J0u
RSTEPYphn8ETD3Rs6B4ZxT6DD4zttdn8vsNncLepj7ZbnOFxK/P6U0OXrpsU
xj6DF7QsE/1HD57nYe70YGz89j48z8m89rMxs/vN1D6Dz55T7pl5vQA+g6+4
/c7OJ137DD6rzbGtngO0z+Dzbk5z6Htd+8z8l/hPjq20z9zvs316ItJL+wxe
wqqstU8P7TP45Pr1w1vf0D6j3W5VvH/B/PsFn8FLXa/z4vgM7TN4/Zm9Ojf2
1T6DH0u5vGXtmEj2GXxcc+8q57tEs8/gpQtmNhjn+IR9Bj+9LWahyzk9LgJv
03fW1wKTnrPP4H9+zptg0fsl+wx+p4hVTvcncewzeOYf7d+0tn7F7cHrJymX
696Oe8k+49io4YLDmwq+YJ/By88Of7O27TP2Gfyxbde4MvOess/gwxsPGH4r
J5p9Bl/7/MbBr1naZ/BHl+3yDOjG41bmJ/bHvoiJ0D6DZwTb2iQc0j6Dpyzf
ddY8Pw+fwWdseBpnnl+Fz+CBya9qJAdrn8Hn7Kr0wBwPAJ/BI9/2ObBtjvYZ
fPX4vZ27RGifwT+0LtR0Tz/tM7jXe/d6xx5rn8Hft769LG6k9hm8Yo3WIZWf
aJ/RPoeOjIo1z6/CZ/CrCzJbXLqifQbvcNZxg3m8w+tkuTyzfKsEtwTtM7ht
77/ynS0Rwz6DB9cybXf0fco+g3+eufmqOvWMfQZfdKbCqDpVXrLP4HcbpBw6
sVT3L8ELLv1aZsu8RPYZvNqbopsWjnvLPoOnLlxiWhz8mtsJPHx4ycN+1eLY
Zxw/Ff31tfn9gs/gI4p9KtJkZiz7zPW2p3p5c38ePoP3Sgr3NY9P4TP4+79M
IaZL2mee/35wun+/RjwPyfzO6WUZfz/TPoNPLddxvHk+HD6Dr/066Nfdj7TP
4PXXdB65Ikv7zPdveSHJ52ftM7hynuRTc732Gfx8lN2yiW+1z+ClT8xINMez
wWd+3tutC/rHaJ/B28972veXydpncOv+naMvZ2if0Q7JY5/38jmgfQZfN6aA
g1Os9hm8qadXd/P8GHwGn/rll4l2LaPYZ/BGt1xmFbfXPoOHxG7Ya+6vwmfw
OU3r37Ls+Zx9Bo/bd/vzx5Fx7DP4/KzbbbefeMM+g3vbFcls1yWDfQafPuz1
kNae79hnjieyOni++SL9vQNf/fKQz8i7r7j9wGcEuC6NrfuCfcax6F3fyjvD
tM/gIw6PWbJy4hP2Gbxj5582/pqgfQa/uqWJc2K69pl5r5otzPOZ8Bn8mcPH
QHP/ED6Dd2u52jT2qfYZPMdhwc56L7TP4GMqFktqWojXbZmrP/vbmONt4DP4
jfuq/UFH7TPfZ9ffs6q80z6D+w2KdO46WfvM80OOK//Keql9Bq/V4ca1OTO1
z+Ct6w1af+iL9hn1bfQZ3OgzuNFncKPP4EafwY0+gxt9Bjf6DG5n8Bn8hsFn
cKPPHAdn8Bnc6DO40Wdwo884Gn0GN/oMbvSZucFncKPP4EafwY0+gxt9Bjf6
zPVs8Jnv0+AzuNFnntc0+Axu9Bnc6DPq1djfADf2N8CN/Q1wY38D3NjfADf2
N8CN/Q1wY38D3NjfAM9v6G+AVzX0N8CTDf0NcGN/A9zY3wA39je43gz9DRyN
/Q1wY3+D18kN/Q1wY38D3NjfADf2N8CN/Q2+f0N/A9zY3wA39jfAjf0Nfl5D
fwPc2N8AN/Y3UH/CeJCE8SAJ40ESxoMkjAdJGA+SMB4kYTxIwniQhPEgCeNB
EsaDJIwHSRgPkjAeJGE8SMJ4kITxIAnjQRLGgySMB0kYD5IwHiRhPEjCeJCE
8SAJ40ESxoMkjAfJOB5EPQnzdSTM15EwX0fCfB0J83UkzNeRMF9HwnwdCfN1
JMzXkTBfR8J8HQnzdSTM15EwX0fCfB0J83UkzNeRMF9HwnwdCfN1JMzXkTBf
R8J8HQnzdSTM15EwX0fCfB0J83VknK9DfQjrKSSsp5CwnkLCegoJ6ykkrKeQ
sJ5CwnoKCespJKynkLCeQsJ6CgnrKSSsp5CwnkLCegoJ6ykkrKeQsJ5CwnoK
CespJKynkLCeQsJ6CgnrKSSsp5CwnkLCegoJ6ylkXE/huO//e72bhPVuEta7
SVjvJmG9m4T1bhLWu0lY7yZhvZuE9W4S1rtJWO8mYb2bhPVuEta7SVjvJmG9
m4T1bhLWu0lY7yZhvZuE9W4S1rtJWO8mYb2bhPVuEta7SVjvJmG9m4zr3Xg+
IR6JhHgkEuKRSIhHIiEeiYR4JBLikUiIRyIhHomEeCQS4pFIiEciIR6JhHgk
EuKRSIhHIiEeiYR4JBLikUiIRyIhHomEeCQS4pFIiEciIR6JhHgkEuKRSIhH
IiEeiYzxSHgOIV6UhHhREuJFSYgXJSFelIR4URLiRUmIFyUhXpSEeFES4kVJ
iBclIV6UhHhREuJFSYgXJSFelIR4URLiRUmIFyUhXpSEeFES4kVJiBclIV6U
hHhREuJFSYgXJSFelIzxorhfIZ6fhHh+EuL5SYjnJyGen4R4fhLi+UmI5ych
np+EeH4S4vlJiOcnIZ6fhHh+EuL5SYjnJyGen4R4fhLi+UmI5ychnp+EeH4S
4vlJiOcnIZ6fhHh+EuL5SYjnJyGen4zx/LgvYb8VCfutSNhvRcJ+KxL2W5Gw
34qE/VYk7LciYb8VCfutSNhvRcJ+KxL2W5Gw34qE/VYk7LciYb8VCfutSNhv
RcJ+KxL2W5Gw34qE/VYk7LciYb8VCfutSNhvRcJ+KxL2W5FxvxWuL+yHVcJ+
WCXsh1XCflgl7IdVwn5YJeyHVcJ+WCXsh1XCflgl7IdVwn5YJeyHVcJ+WCXs
h1XCflgl7IdVwn5YJeyHVcJ+WCXsh1XCflgl7IdVwn5YJeyHVcJ+WCXsh1XC
flgl7IdVxv2wuI6Qr0AJ+QqUkK9ACfkKlJCvQAn5CpSQr0AJ+QqUkK9ACfkK
lJCvQAn5CpSQr0AJ+QqUkK9ACfkKlJCvQAn5CpSQr0AJ+QqUkK9ACfkKlJCv
QAn5CpSQr0AJ+QqUkK9ACfkKlJCvQBnzFeB8Qj4ZJeSTUUI+GSXkk1FCPhkl
5JNRQj4ZJeSTUUI+GSXkk1FCPhkl5JNRQj4ZJeSTUUI+GSXkk1FCPhkl5JNR
Qj4ZJeSTUUI+GSXkk1FCPhkl5JNRQj4ZJeSTUUI+GSXkk1FCPhllzCeD/yfk
+1JCvi8l5PtSQr4vJeT7UkK+LyXk+1JCvi8l5PtSQr4vJeT7UkK+LyXk+1JC
vi8l5PtSQr4vJeT7UkK+LyXk+1JCvi8l5PtSQr4vJeT7UkK+LyXk+1JCvi8l
5PtSQr4vJeT7UsZ8X/h3IR+jEvIxKiEfoxLyMSohH6MS8jEqIR+jEvIxKiEf
oxLyMSohH6MS8jEqIR+jEvIxKiEfoxLyMSohH6MS8jEqIR+jEvIxKiEfoxLy
MSohH6MS8jEqIR+jEvIxKiEfoxLyMSohH6NCPsbv9ZPtvehbfUd6+2bu2l59
yUsa+a2eM5h38tq/MKlqPC389vc3zCtc6ZL2dxziy18wP7egU4Q5nhPn//7/
7ntbv0lPN8db4vzgKw/Mu26Oc/vejqnM/awTLt+an8bXBf9yxrXj5eBkvi64
W5nsReOGvebrLv7OyXhdcON1wY3XBf9kuC44rmuoNxLqjYR6I9Tb9G/3b+GD
49G61dYfaR7I3x/wCl/jto8vEYjyCnyB0+PPe4rqdgevYWc/fYO/P98nrj+z
z/wKDZxeMMd7XDSs4Mc1jeK4flC+zO87n5rjvsDR7om3hyWZ4xL/fX6T941P
lpGTVyfw9wTlnXc9aFnowmvD+U3e40r5OBU6rOMeUX58+eDlrT1fcb2h/Jhq
NzNiI1/lfk8+sg/xi5rYruv7gr+H4M0Gd8zJDtPxmeB7WgQ3r9lW3yf4Rcdl
R2yt0vg+83z7s7zd92Me3vfFPq9wW96OErndUf6890l7c9wy7h/8d5+r8w9+
TGBvwcM2v6/s+b+eoD7B7S2H2i/vkcrl8b0cemjVpfDdujz4hFU7O0e1TtHz
1bnnObvgXG8Huy/8XCgf1a55apaN3neH8i9PjSy62S6Znwvlx/1zLqB3WBqh
nVD+TpB/VXNcH35f8L7EjosfV7hoKt8P+AVDPeO9gFe4H5Rfbqhn/D7cLx/3
aXTkG74flHepe9Xf7C3qH+XhD+4T153y26XALJvXfP7c/0db2p/sPzDlhfE9
VcJ7qoT3VOE9xd/xviY8TB3aMdqfz4/zzcw8rYbnBBjL+6A86g3vLw06NDC9
9Svm+L2Nzm1fPBc42hH1A/5Tq0AX8/vL6yO57XuzQHKQuf55XSOXl9yxcZe1
RTxfF/WM9xrl0S6DCtkNeFj2Fd8Pfs8bp3Z3bnEyzlgPCvVg+L4pfN8M7eiN
dsT7gufC+4LyeH/hJ94jlMd7xOtBuc/7uumColM3ZnG94b1AvRm+e4TvXvq3
79Jr7+/Xue09d4Lb0KSjyVTqWz8hxXvZt/InCN8ZlAf/0MjSp/KZVD5P32/1
FkCZ4VZ0dEQiuXzrJ2Tm1meAd48KJePG70mg8t/6FRnMExof/NNXveXyuJ9O
vS9MXuOXSNu+9U/SmK/8dVTY6xysA71lPuu036bKRbF+H8c8qEP25e6Ob/i6
3324TW3qbBnZvF4qnx8c5wfHc1lWOnPQXD+4LsrjuqgHcNRn8Lf2es7cM+9p
98NH4vn8dt/r0/v0hp+31Wz7gesfHPWP8qj/U7nlcT8o37n0lOIPy77j+wFH
e6E8ztMltzyua/x9QXnwaYE+nawtsvn+4dupnN/Wf/HP4vfO6A/Kw+eThvLG
5y1eZJZD6d0WPjg2G++R5FcwkHL/zv9ul7Knkl+wP98/vFqW96dD42emkOE8
SjiPwnn+/b01eT/I/Z6jPnH+d7me47uE7wl+x/H+4vuDfgg8/P7dCCO3x9F5
/Qol8Hcb91tj+vzy1pkB/Fzfvx9h3jZXu0ebfUZ9gg+pPdo31eYNty/us1dZ
etc0I4nPAw8jB08ZVYUy+X1Be30+9rWY+b0DR7uA4zx4Lxbn1jOuC47rgqN+
fNpltHIansr1j+d+tvK6867ruh3x/kbn3ic8Ad/dqv+yW6UyuR5Qn6gHnAcc
9Yb6xfc78WzV/SMS9fcc9xVfrsf1mIv+xvI+QnkflP/370iA91qf9wnPzr3l
esB3/mZuPfx7n0KAt8uJR03qJyUbfVDwwVBvCvWG88OHLxs2OTR8lcDfVbRL
99zvMOoT5V93yyj3z7o31MXrQd6G2W9z42Yfem/vU2R5mzcpht/T24T6hyf4
PtQq3erD7Ey9nwjXxXPhPGiXuNzrXlvldNi2fyJf1z8l8LcCK5N1npHcdrfZ
tL156tQMvs/v93/P2/aJZd3u59IofnDewHfVU7yLJjZ+29P9b/7+VE6/PfV2
qTTv8Ipt2l2afdDbyJ9+51x+cNfyk6fGJv3X9xD3X2Jy3qWpd/X3Dbz4d66/
Y5YD97SenPZf52mz/48tS+2SvQfvfu/q9OcuPs/+WmUS2geleG9dYHvdw8aT
ueG5vI3nafj9PMyd/n0e5je6/Xo5fut/f5/Bjd9h6Xn/n/fJXHpeqZ6l55Lq
QXpeqV2k55U8kdpR8keq5/8Bk9/k3A==
        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJzVnHm0llXZxlvft5ZMZjY5vu8RVEAGRUYVUZvLsjLTzCzLgZy1RFIzQxNx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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnHf8V9Mfxz/3c7/2yNYQDSvZMkKSlEikUhJFw0waRmghiqYySgspqYwk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               "]], 
              
              Polygon3DBox[{{1063, 431, 943, 1064}, {1054, 461, 944, 1062}, {
               1065, 964, 431, 1063}, {1067, 997, 964, 1059}, {1058, 944, 999,
                1081}, {1056, 999, 978, 1060}, {1061, 943, 461, 1054}, {1060, 
               978, 997, 1055}}]}, 
             Annotation[#, "Charting`Private`Tag$34182#1"]& ]]}, {}, {
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             
             Polygon3DBox[{{998, 1003, 935}, {1008, 998, 935}, {1073, 998, 
              1074}, {1069, 982, 1070}, {1003, 982, 935}, {1078, 935, 1079}, {
              1079, 935, 1080}, {1066, 1006, 1068}, {1076, 1008, 1077}, {1074,
               998, 1075}, {1070, 982, 1071}, {982, 1006, 935}}], 
             
             Polygon3DBox[{{1072, 1003, 998, 1073}, {1071, 982, 1003, 1072}, {
              1077, 1008, 935, 1078}, {1080, 935, 1006, 1066}, {1075, 998, 
              1008, 1076}, {1068, 1006, 982, 1069}}]}]}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0jVORUEYBtDB9eGuoUU2gPRIR4V0FLi7u2wACT1sAGkJ0kKCbAA2gNQk
wHmhOPn+m0zyzdyZqp6x9tGYEMIO6fEhROfvuBCOqDQ30c0CR1zywheZFtfR
xgB7nHLHG7+Ux4bQQCdzHHDOEx9E9NTQwhXZ9tAnU+W97GeAQYYYZoRRxhhn
gkmmmGaGWeaYZ4FFllhmhVXWWGeDTba4Jkf3tkyTD7KXZqpJ592+Hzljn1k6
qKeMH+d+5ZYTdumnlVoy+PT/nrngkHm6aORYR0R3hTlB3vouN5dRSgnFFFFI
AfnkkUsO2WRF74gMItH7JY1UUkgmicRoD6qCquAI4Sbu/z38AaAuNV4=
            "]], 
           
           Line3DBox[{1081, 1058, 1062, 1054, 1061, 1057, 1064, 1063, 1065, 
            1059, 1067, 1055, 1060, 1056, 1081}], 
           
           Line3DBox[{1076, 1075, 1074, 1073, 1072, 1071, 1070, 1069, 1068, 
            1066, 1080, 1079, 1078, 1077, 1076}]}}}, 
        VertexNormals -> CompressedData["
1:eJx0vHlUT//3PR5FyhAiGogkotKASuWIQgNFJQ2iSLNGKUUhSvM8z/M8z9ND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         "], VertexTextureCoordinates -> CompressedData["
1:eJx122msXVUZgOFGReuIjTGaqhHFIUqjxFCMA55AoESRIGiwaqKUWE1FBSsR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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-2.999999793103448, 
        2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 
        2.}}, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ
tooIDYmsw4yx741lxuzkQevDZ75/wPeHe84999xz7v56v99303lv6wtCAgIC
zfwiyC//Vy/qHRx6I90M0vm1nPikSQga35Y2MGJCOLCjOfsKEVsrZNTv7ZiE
9aKo7IUgJjisxSfJPm3YELb6lAuFjovjdWS5KiZEp3d8cdpFxsi5Z4uyV+nY
vrQu2GGBif9u3PB97dqOF4vkm4XidKyPTpTXBAsVI6cimtdQ4KynOKHwigbr
XbWXEsJYsNimyI19T8HKKdtJ5/002Pp3Mh5/YkEgavaThVkHzN4zv/39dQJB
xyU5OxZZmEiMEiPUdKA6dqnEiaAJWNWPPvDfy0Yy45yvg24nCM31Xf+unYBP
iOCHsyFsCC+tLzyc2Al74e7rdsXjiF1ps232IxsuP8ruh3I7caShIdXv2Dh0
1TMCdv5iQ1Ss617V7i7sfXTD6QBjDCbd81JqhhzYXWozKAzpQptFwM5P4WN4
5bfKhHyNA/qFA169ZV2QWEthDimOoYN5ZoN2CQcp098YRfQuKFyQ9n9cNooX
Ub/LLaY5YMcWjcav6MYDr7r5QatRUByTpjdocfFUpbaMotGNVZqvb+UyqPB+
IRlddpkLXynnhbx93ZgrkF/Bu0lF2D0pPakcLja8nZA+adUNy3l9s4x1VJSb
xfnpjnHR+UwQrFPdOPnuRKqDy1f80VZpktvAA/ue/RJXjR58d846voY8AjfN
kd5+RR5yVQ6yLs73YIVP/oymyQiOOSlOxyrwMPFFVc/0Qy8su2cR8XoYNtLW
G43leTgjFLF58Wofuv2aTwnJDEPnCMN/ZB0Pj4LyHe9t6EdVUemZ28FDqOfu
FfWX5SHVNdArpaEfUu5KymNjgyhZVTggspaHsG7R2f5LAzhrezX1u/kg3Hbd
Eo6W4UFK0uxnz5JBvKg0OpqUO4CUh4IJotI8OCqrrZBIHkS4/4ukWLEBnNbx
TAyQ4sFVyTmQpjqEKKUTk7mu/fA//11+VJIHycZbDbXFQ5jV4Ga/IPThKZmi
Z7qShxLObPUPw2EsOm35tmd1H+qalDmJEjy4zP5c0Vk5jE/Rv+Q3uPXi1C1x
2zFxHjTsyh8lGo7gksKBNN67HuQceR6msoyHlOUzPiHFIygeOZBm9rsb+t1/
/F3EeFDdISFYq/YV5Jaskmfoxp7zW4/HifBwlywekZj6FYacmhKv0C6ILlOR
Khfi4fCZWWa8CBVzufuWi3zoRCnnB7lHkAcfxj0P0h4qvLhk7QRGBzL901I4
i1x4ahrfifOh4uNUlpz86g6cTBQO+fkfFx8fhOytYVNB2t7FCvlIQea08jfz
Oi4WTWeO0M6PIqD3joTceQpoy6/w8iK5iAzbvdKpZxTxFvctK0Uo+Kpv9lTl
OBf9XXd2BJiP4XrqaV/1nHaopLbLf5DmYltc25KQkjHQzS6c0NjfDger/564
9HOwwz5J7vX6cbRvyonjlJNh7BG4SymDg/jzUSN6d8fhHjn2z7VxEvwj6zfN
u3EwlSv/7DBrHHEXy0oNREjY72cYPqHOQXHmL2+FYxMoaEsQcVzfhq5touGs
aTasVEsWiYUTiGGEadHVW/F9jcXRpR/YMOMlKYVJ0BD5TjUjX5OIwFeLEnv5
790/RPLEqcs0zHdQ0803teDNdrVv0fvZOCsbruH+hc8XDilMWKwZx2VLt84s
YyOELlHbtZ4OgYOzl1oHGxHskTHk087CwuXtk++u0bH2TLDrr7QGnGnkmi1N
YiHb5pfvmlY6XGOiPVQt6pGfXhVV7sSCCOlzmPSmSbwWtu5v767DNt5R+q0t
fF5Z8uKq/SbB3Khe8cWsFr22wvfd2EysyzNoVG2cROHUhJ/83Rrovr716mwx
E+xCOwGXdQw8KVjKc91QhaP05/7XA5m4LWLHzbZl4M8XskQdjYAjCjYP5H8y
EDRl/S8lngGCstr70vcEtOxp6ZYNZGCNh8EKwTYG/96nXj4UTcBMkCjL6+ck
ljnwj1yEieo6hfXhlwmIZu84qHhjEnomjS6Ve5gI0FD642pFQIFMmrnybzrW
Gc//5+nDxMbkh3ZMYwIeDGlrhQXTcX5k8dPf2UwMhZ17JqZHgPdgnrTeAg2+
/2ZQ+7uYMDV2uFikTQCVoscxuknDulC71FJhFpx/BSQ18vu/IZ0ISlxCw+/6
QTMZfRbKxT2eGOwl4DnNwnr/3Ql8Ya21ET7LQo/Q9djhEwTEDSQ37Vs6geT3
4g8TolmgOi60JFwhYO/bpNmY6HGE7h+YIZWyQIhzWqXDX+8HZ+ZzNclxpOju
ZNWOsNBge036TjEBgXXlRyUSxtBja4sgUTY2bjrAcqIS8INwScJAdgzRf33W
E9JiY+hRyb1ImSostPnFvUwdRZr8xO0L1mxEabMMW49XIZJpInFq4yjUSwg3
Cq6zEeMZrzwVU4XC3Tu37n1JhY56xvRoChuegg0fS7uqkPVCaNxZnYrNq3ac
liSw4VicdGBcqRpCTky5c3xOizybD/Dt4o+rID98N7gG74Knn9s8G8Ejo5Zp
Qw4bK2v6G19SPuNC16U5ucFhyLr/znAV4mDVkxfdedJ1MFJaH5W+bhjuGvOW
3+U4sD1tdanh4BfEbzgi2WEzBOHC1ifft3PQoP79otuVenB/nVXNih/Es5iX
Mu4HOaAhPvjS7QZkxQkozpMGYP5J2uioAwddsVo5VvGNiFuMCi8XH0BRuP35
V1c5iJspm/8ruQk2B3pJrQf7EamX3BcczsFq7n1bvyfNKJAvJUvf7MP8Rh6J
nMgBq3etfMTDFpTUxEheqeiFwfhtt+xcDtx/lW81CSVCdFeJ1KtvPdDTjXr5
q5IDxs/OSr3LrdDf7Xg+Ta0Hhzy3Pehr5WBCSO0h63gbbrtIeco4d2Nli6ug
6QgH4vpuH3u2k5BsukWA8qgLfuLsYf0pDgKEZ/sdJMgQ1OQF3K/rRHAMi1W2
yEGoiZEzaYIMkefi1oyZDgQmNIwRJblwbeMc/OTYDpkeeaFIpQ44WFD+vqbE
ha60meDp+naItV6n8A5REO84v6tMmwu/LKrACU0KGlUXt96/2g7jD05f4ky4
iNl3taL2EQXKKtLB+5XI6C39HsVz4oJNHnrcJtUJ8cePtYRrSFBXtLXNDOGi
iOTBKeP7i0jS1njBMyTEJDf9fpHGhepM0o2E/m7E9/aZMKfaUDHZY/m7kovM
tguCDmq9uLns7rRLaBvMl/0Ue97Hhbt8gPsBzz407DLeJiDahuJtx+eT5rjg
Wd3yFn/Vj6crE66cjmhFkJR12yBfP0/72v8RHRhAwK6PcswFIq4x4kw8tXhg
bPnWdkJ0CJWdLwY2eRPxr4L9lMUhHuBtfImoOQzOmwBT554W/N7hEe51nq/b
pOnfesdHsNA5mTKq34I9Hq8eDgbx8PJ43QoVj68wX+91nxLRjBWfytPjHvMQ
u6zDVdqMinMrT81rk5pwzK3KKLqAh2zZ0LGuViqiZBoKWpc2gXiA09dcx4OH
7q4hMdtR1Cy4FpjtbESgiwHn8AAPy00sM3uGR/E6sPrJ0MkGLG9k9UlM87C6
8c2qi25jSDW/VHXTsR5/L1r8XCEyhV8zx+70MPn+TehudrT1F0j5r087KjeF
dnJJ8IGr4xCRi8xP1qnDyy574UbNKZxpumfU/G0cds7EKPWZz/AiP3UPwhQK
KrbqBvlN4Hc8WUPuUQ3sVtnmiktMYUl3ll586wQCKUEMtkYNbNo13Ot6eZC7
fSg4YTMNLelf+owjPmFfTVZdxnMelkpEbIsJpGHivc6b3oJqLB8XjU3x5IE3
GKYWR6JhpdMOcwliFf6cibfO28mDbOA++xxlOtKeE3PV+NyaM1h9kMjXf7tN
rNwhvl5N6P/jeZb9EfJF683nvnAhJuC/bW8THfE0em8DuxJrXhJ6N0ZzUb74
emu33CTonJ0HLagV0LbzkzU/wUVjtL9h/pVJPLbaJJHaWI5jeTlljjJcXBA7
9Vdz5SQC1FQYezI/IE9r+8yZXg4S/87vMRBn4EGS8p6T7mUoTFK5vzuFgyvf
P6csnGagtupeUuL6UuQuvi7m2XNg+Ujv+5ZXDCiSTh/TqSrBTeLT1Vf5vPIj
Gfa+m2WA4eb8LGh/MTxNJQsLe9lYe5JTnr+PCb+ouB15+W/hVOjRl/WYjZtz
MZXrYph49MLHwG2kEBLiw1p7T7BR8XtZ1kI/EwnkWruYZXnwuiQYcE2cDUp2
8ch5FRZeNVpvphBe4j+HgAyjOhaqz3mkHPZhodb6ivh/3zIxZSaeGHSD309w
x9vKSr7OLGmoy96SjNRTbatMB5kwH7D0fljOgmYL8XKR1lMQ/QeOJe1mQpBo
aPCBrz9Uv9uJzcfS4HnO+YdzMgMKW9UUdxez8FPgxM17d9LhKlcd5jM7ie6+
0M3rilh4qt+iW+WeifW8R46ZxyehURF24K/XLBzusjeWf5qFOomrmlU5dOja
jLhzs1mYcon8s7nnOdh6lkkxf2jQrjnqxXjGgrCNWGy24gskZc5xO61oCGpf
omzO9ytvaKU7w91fIjJk5IpZ5gQ+G+HI0jgWdJVlQolvc/CVtnYunDuOh5O1
WTqRLGjMEoPfz79C6n4Vw+0G42DOmXfW8HPaNdGIC9q7X2PlvDqpLXgMWRnc
8MrrLLiIHLyoFZSHN2vvyrVVjWLMt8hSyYuFXqMXm3Mr8rHa8/2u4J9U/L2x
umz6PAtHZP2PJs0VYNlPz3WC26mwXTdjpXOaBaU8e9M57SLYF/kkPK4cwfYz
G+O/HmVhTjy3vurCG2zTabv3r8gwlj4L+rZoysLIsBB9/uhbPChXi440HsTK
5Zz++B0seOqkp32mvYXXKV/FQPt+uNDd3qSo8vdzlZHL3pB3cL+qoDNj04sK
dQPSGnkWHpebDnhKF8NovkzY508P+lt+DDpLs5BXrfXB+jkBJutrh8wzenA7
/UNLkQQLN+rFgg7Y1uKJ4POiXXt7UNEk8FlElH+P7JXKpyrroX+HfexHXzcm
Hz6guS4yIVnd1M8mNMH6wqSOsXc3Ti/d69L8gwkZ5jHJk0FE1OzW4OYKdOOv
PmWbXTNMrFo2Sd2/lIRLh8Js+h90YZr8Dy+P7xeblgeFvjNox/L92xQcpLtw
42mstSqNiYz6W7esHCl8n/S1KSehE14uwq/zR5hIM/F37fLrAF1k1ZDKik6Q
z96VM+zj5/nfIlVOtzshTA/L2RzWAfHEKWIrhYlSHV3VqPtdyBROCCAyKFA0
PsS4TGRi9H1OenokP99cE7PeYEnBlDfhiWQ9E+QtPlPpt3qw6VQUg5beDrm3
mYtV1UwcL7kC52u9qHnnrXmAQsZTd58j18qZmLhpmBrl1gdW44bhgUMktPi2
Pd/J97vHt3ublFr1o9VhzDsnoxU2SWHai/lMrDZvzDhtMABDtpLYOnILVv/x
le14yYTnM6bQsMIgQlWyH67l6wY3kxBRlMGEWdYSeup/g5h6k2voFNuA+KbY
l49TmLBPWJszNjSEg/ZpFcTURqhwGJ7UMCZ+fgDprPAIFAO0zgjfa0JZes8t
9YtMqOSl7FnCz293LrD1r51qxhNpSXXfo0wofDTbumULFelnff4pFm3B7Lnm
gko9/nxinkS2F1Ox0eltxNuMFixea7AWlGPiqUy8307TUdR+WXKUtZGI2/oO
Fy0WGVjl65Qb1DqKCOXJ4hvRRDS0+Ok/pPF5WK0Y1WA3hscLMru1qUTsNy0Q
6yQyIFBeKLZzbAysDyubYpRawVA115MrZmDDVuvDYx7jWPnMxo9t2YqQx/uE
z/J5I810PESfHYf2iSO6Ti6tqN5zrv1VKAMZ1o7GtiETWHgz9rWJ395A3sme
dmMgMM1F7KAIDVdnSOJfD7dCO0Ytf88RBo4cTguve0BD7vIWC7mNrQgXiXCP
1GUgQOpjHVWajg3iBQvvR4g4KHU/pFeWgXuDdrZ5T+n4s/Hc8vy7RCisuGi+
bWES68xLPDX5uUj+eq1ltjQRa2C7KXRiEiuoasv+eTWJQyFBN8ciWlARmH21
p2USBlb5m+5qMXCz3ltVZ7gZyXMlcXrv+Fxce6j6agkD/9//1f8Aa2OKuw==

                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->437071906,ExpressionUUID->"05897fef-7a95-4dc3-a014-de0af6c8b7aa"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1959729799,ExpressionUUID->"d918b38c-08a8-419f-baca-45c5ff0778cc"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->39918211,ExpressionUUID->"9f8fd99f-03a0-408f-8b2e-6876dc824df0"],

Cell[TextData[{
 "Compute the derivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", 
    RowBox[{"z", "-", 
     SuperscriptBox["z", "2"]}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bfe4ed9d-d431-4d74-a5e9-c338380a7607"],
 ". This is the composition ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"g", "(", "z", ")"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cc7df13c-349b-4711-90a1-490d908fc4ea"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"log", " ", "z"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"437203a5-17e2-43a1-9cd5-072100cab234"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    RowBox[{"z", "-", 
     SuperscriptBox["z", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d0263df5-296e-4d9f-8e32-277b61d6a371"],
 ". So the result is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "-", 
       SuperscriptBox["z", "2"]}]], "\[CenterDot]", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", "z"}]}], ")"}]}], "=", 
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"2", "z"}]}], 
     RowBox[{"z", "-", 
      SuperscriptBox["z", "2"]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e88dbf8e-58fe-4f12-b8b4-f26c1fe4d106"],
 ". With ",
 ButtonBox["D",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->344191013,ExpressionUUID->"bc2dd51c-335f-4adf-abd9-630e4bfc2304"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"z", "-", 
     SuperscriptBox["z", "2"]}], "]"}], ",", "z"}], 
  "]"}]], "SolvedExampleInput",
 CellID->614502905,ExpressionUUID->"95caec55-55ff-47a7-80a6-ce4fa0e316d2"],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "z"}]}], 
  RowBox[{"z", "-", 
   SuperscriptBox["z", "2"]}]]], "SolvedExampleOutput",
 CellID->143809054,ExpressionUUID->"a116ef8a-da5f-4c25-b9c1-48b7c81397e7"]
}, Open  ]],

Cell["Plot both functions:", "SolvedExampleNote",
 CellID->58849336,ExpressionUUID->"5cf8a813-f80d-43df-9cf8-584521a38b66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"z", "-", 
        SuperscriptBox["z", "2"]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", 
          RowBox[{
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
            "\[Rule]", 
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]]}], 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Rule", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["56", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       PlotLegends -> Automatic,
       SelectWithContents->True,
       Selectable->False]}], "]"}], ",", 
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "z"}]}], 
       RowBox[{"z", "-", 
        SuperscriptBox["z", "2"]}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", 
          RowBox[{
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
            "\[Rule]", 
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]]}], 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Rule", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["56", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       PlotLegends -> Automatic,
       SelectWithContents->True,
       Selectable->False]}], "]"}]}], "}"}], "]"}]], "SolvedExampleInput",
 CellID->675661662,ExpressionUUID->"de0e9f98-d42e-4c7f-b5bb-4eb1b6f3214e"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJyVnXVYV0vU7+lG7C5UTEzEBGdEwUTswELFVuzuPmK3GKjHLuzC+KmICCaC
haioKCEqjfQ9j+7vmte5d573ueef/fBxMew9+ztrr5lZs47t8Ek9Rxro6ekd
NtHTM/zveqZ069jCQtPbuLab1dqvgpEVrxVjscKtvwnxyCN9mp50t+T7jkfZ
rTtrRNwpJizk5WYLXmbaifsRZobEF9X//Msm0pxvcJo7uvwwfeLriz51LChm
zm2stha9O7VQB24zpeK4te5mXG+fQ0+P6nnEv5U2m/lrlSlPaRyxJTriF/Gf
Fh6nP9814Z/uTX0xdnkG8b6bo5OG65nwiH7Fy2Q1TSVe2fbEO8t2xvyfFyPO
mT38TnzW/kFhueuM+Ljcf5tWt48jvva8c7OIWEPe1fbTFed1McTblmi3fX8X
Qz5wvcvMs9ERxM91t/ty8b4Bnz3GMG3bvEDxd/e0YkM9Dfj8P5yBO1Q+rrfZ
woAP+tMO8eotH5ybF6WPv0u81Kfj5jUf6eM+ibt8fNOmcYw+not4t4GV4m6W
MkA/EE8+nnBmzTgD9Btx0wdZbdu/NUA/E6/UZGLI+xGGeC/i76a3tzTRM8J7
JP6rVZsyk08a4b1z8M32yydUHm4MnRDPudVg2oqqJtAV8SEViq71/2wCHRJ/
9qxGy8RjpviZeJHyeXGjfczoZ+i3z5wrd0M+WZKecX049VdptxpCz+B5FX7Z
NfYSegbvUa/3spfbhZ7BdSseugQ+MCM9g7vY9L59NNOU9AyeFBJ3IthW6Bn8
ZY91P091EXoGbzz5ZuclM41Jz+Bzx0ZkmB02Ij2Dl9tyw0oXZUh6Bu8/oY1e
VAWhZ/CbTYvVdZ5oQHoGL3vEbHaXSH3SM3ibkJ96W/rqk57BX5eu6dM9W4/0
DO43PmTSy9t6pGfwpk75LzPO6JGewUd594teF6JHegYvYV935mgTfdIzeIU2
X+uMGatPegZPrxLX1jJJn/QMHl189ui8fwxIz+D2tUaWON3KkPQMPn77j3dh
uYakZ3DPNR+s14UYkZ7BW3w4Uz7az5j0DP5g0+ekgZOEnsm/7vJ4N9xV6Bk8
f0Rts6/lhJ6hU7vvOyq3fiT0DL7X+EO6hYnQM65u3Ye912sp9AwezCY9bjVS
6Bm8xzrfqxZrhJ7BbZwr17M4KfQMfvBS+5wm901Iz+C9HU+OyX9nTHoGfzFo
X71l6UakZ/DORWY5HLYSegYPrNB7XcO6Qs/gTU476KX1MCA9g5efVNk7ZLU+
6Rn830+vu498rUd6Budbvh0wctUjPYPbh03yGHu6kEHP4C+fj8z+WbOQQc/g
tnU6+fsXFDDoGdz72sXSWc0KGfQMblLRI2veo0IGPdNzmQfvbTRQj/QM3jC7
3IXi6XqkZ3DHFvN2647rk57Bi3wLzrKYYUB6Bt+45EjAIA+hZ/DM8IQJpg5C
z+BRIzyjR1UQegYfsrp099dGQs/gVS7mnvRPIn9NfNZ898Cbz4S/hh4bOg8P
/XRH6JniCL1TZofSLej3wet3brvQsYrQM645M8ovndNW6BncpY1jwKKBQs/g
VUZmDtg1UegZ3GuXTf95s4WewReMeN13wAKhZ/A578OPVl4o9Azuem9vwP4F
hqRn8DFdzJpHLzIgPYOnzNxzr74vffeJP8m/YzrjoB7pGXyWy9znRY8VMugZ
3Mq/z/1jnQsY9Aw+8vJWb1OXfNIzuN1eT69e+/JIz+Af+o2c0ssnj/QMPn17
k/v3z+eRnsGve79rNHt0PukZvEY9z93LFxUw6Bm87MiCsY0SChn0DD71xJTI
fx7okZ5JDxfb+XU+r096Bt/zoe7uO8cNSM/gFvNb/eNxzJD0DO7e5s6DF8dI
x8Snxs3JWXvUmPQMnjXzvPnDA0LP4BkJB1uGbBN6hu7eHtswxCFY6Bk8/yz/
/ihF6Bn84FuDn+9KCj2DVx4e9Eu/gdAzrsF1DyZkOAk9g8eVMr90uq3QM3iz
KXPnTnMSegbv961ucPEGQs/gPXe/flq8rNAzeF2rerf08w1Iz+Ce4SULn8ZQ
XEp85JPplRxD6btP/Gnxi5PLzi9k0DP4zNiypc225JOewefNKf8i9Gcu6Rlc
F+ER1eR0DukZvKBFA69psdmkZ/C7JX6e3n00m/QMfuvcpB7r8rJJz+AedqbN
q77NIT2DZ/bo4RTQMI/0DN5g8MoRo2LySc/gJ7ZnZu55XsigZ/CLi4q1b5il
R3oG73r/xgfzokLP4GNWnN45wl7oGXzzkLFXXrkJPYOP77T35pWBQs/gAS3n
dz06RugZvGKWT5N2E4Seoa/gHp2W7Xkl9AweFeaxq32h0DN44/Ide5arKPQM
vr31kK+j6gs9g59PLNl4dROhZ1zDSzoPKKwr9Ax+OSG8rW9poWfwQxWquXtm
GJGewZ/1SS7T84Eh6Rn8cPDbjt6bhJ7BKxv17lest9AzeFznckOMSws9g9v6
NLm2VZdPegZ/6tzX6cXcXNIzeP8+J9IHL8gmPYOX7/150ZmkLNIzuOeapSO/
/8gkPVM/L3s3ocOBTNIz+PLwF1O2W2eRnsGbmw8yaVPzF+mZ2rmefOvBw2zS
M7hLqehDe1/lkp5JD/8uKJpTo4D0DP4j2//unc5Cz+Cdd0UearSadEzvme9e
Ne5+sAHpGbzooumnWS7FH8TN2k8fN6am0DN4xKwnNZe5Cj2Df6vw4cyzfkLP
0JGBvWHO7ByhZ3D394cmBVYW8TN45OXwTL3mQs/g597vOurqIvRM9hZrms1l
Qs/glqXqT9hRX+gZ1572iZsvWwo9g/d1+KTn9EboGfzbunJTKmwXegbvuHLH
zrbthJ7Bn6W8aNfoM82ziHdyGHz8fEYBdCXa1zW/NM8uj/QM/tBhcYnlk7NJ
z/S8Xp39o/MzSc/g253PlJ6ln0F6Bk/4vjr13OU00jP1v/3oarEeaaRncJfJ
LXYU/5BGeqZ+G15j4JwuGaRn8BExZ7cdHJpFegbf0/1suf0x2aRncNNzB5ct
2JNHega/H+9arL8P6Zj4vPfVdu2pLPQMzlde+HhzvtAzeMuqXW3LPhZ6Bg9o
+mHqXGuhZ/Airo1+1nUWeqb+j+2a1GuQ0DP0UtrNelNuA7FeB24RYjTqcg+h
Z/CNXe0KfUcLPYMf6agXXm2S0DN4V99pTYxHCz2D77nn2n2vu7g/8MBevTw7
2Qo94/pqZ8qPOTFCz+ARXuNyk1YLPdPvFf+YXbKS0DOtl5w+mRW0S+gZfFvV
nO4+VkLP4N3cEou3e5xDegbfPahUs8Obs0jP4Nfnt3Aptzqd9Az+uIvr/k4Z
KaRn8GOONz7vbJpMeqZ5cBm7hLadf5KewXfUj7MaNiGZ9AzuOabSOM9+qaRn
8JHzHlhdNMogPYPHL/X8Maf8L9Iz+Cxfd89h/XNJz+Bx3ikBvbYVkJ7Bg781
Gb4mWo/0DL7zVb/MCQOFnsFv1dpZb+M9oWfwrSvc7SaWEXoGf7nauvm13kLP
4KENF1iHLhB6hi4uNzELLzdT6Jn839pwtwV+Qs/gsWZlB486I/QMbtYpLKv1
ZaFn8Mxbkf/WOiX0DD7Z0cez6AahZ3DXFgmzdg0SzwNuvdWxpUNxET/jGv3J
5Y3DaaFn8BKhDys2rif0DG5nvTp+p6/QM/imXQ7mu3fkk57BeW/HLz++ZJOe
wfMLt5rsKZVJegYPHn7l2ZUeqaRncAdj//QJEd9Jz+ATiux8/iQ8nvRM/Tn7
wb3pleNIz+BjDhf/WGtWAukZ/N9XLeb2/vCD9Ay+5HSpR4E/6Gfic7tv8865
mkl6Bh+3YdWnmStzSM/gK4pXcl/SSOiZ+t+lqpn9c6Fn8NqRffT2TxR6Bh87
a9zgY4lCz+Der3oZWXYRegafc66Uj+smoWfwOv75xoU6oWe8/9xlAXkzngk9
gzv0a/8sNVPoGfxXxQ/tnttYkp7BH3eZdLt7OQvSM/iTqyfH9v0f+yngi6N3
pI3MEHoGf3l86jzfu0LP4ANW7nDtOEPoGfxgUYcXfuZiPojrTf93xYrME3oG
fxTay7dRsNAz+KBNlz2NQ4WewUc4Tp4SelboGfzD64kLR3fNID2DfzUJde1+
PZn0DN7d78D8Z0viSc/gZbvHLwpKjyE9g3PLBKPFsW9Jz+Bniw242dfoE+kZ
PL16A941LYH0DF7dLbWi+aIU0jP43M7+maWshJ7pvReUeuc6UugZvPzKDc88
Jwk9g0/22zezWDERb4AfOrS5dNnbQs/g9fVnVVzWUcwHwavW63vxeYDQM7jF
jKabxmUJPYNvnnimSKuaYv2Z/FazhD2d21iTnsGPVjAJmT/OivQMfrtXtcLp
q4Weaf/NZ1CZMX5Cz+CNfqwLr7NT6Bm8iItTneLLxP4geAuP4d+j+orvCniC
d0vzGTZi3NK6RUUXu9dHRb+AO5Y0L/emnFivw9Xv5PpC+yFiPgjuavpvwfc3
It4Adxp/eL/jIhFv0Hp2g1ktPY8LPYMzPQef3eOEnsGbzek48k70F9Iz9Y/Z
zYuh4S9Iz+BZH7aWndruJukZfFXDNwVfR70hPYPvLbJo+YaLpHvizrfsjlfo
LvQM3uSm7kLQIqFn8NAuzW6eaiviDfDB01fcubFKxM/gW8u0urL/pNAz+PPC
0Cs1hor1DfDKte/7tvsq9AzeIWDx3Iodxfoz+Psa6TOP+Yr9FPBXxt7pd88L
PeN9jj88rpunTugZ/GX56bGJaULP4Kbu8VHNK1qRnsFHnkr082tmSXoGd3+d
PNairQXpGXxYy0HbzFqak57BDz4rNn5CBTPSM7ir9/ZA+1ihZ/AW37xiLdaL
/UFw/+F2n6oWF/0F/jSzg7HnaLH+jOukC6melZaK9Q3wGMvG6fNPiPkg+IiT
gw/3CRDxM/ibnWc3H6ks4g3wW+Pfj6ruJ/wztX/NLyNj4lvSM3jJ6bOW9p7/
jPQM3mvKix4Lg96TnsFb8mnj769KJD2D25cft+dkiTTSM3jk3NZfBq4X8TP4
km9Lq5WflE96Bne4taDS7ldifQP89auVPk3Oi/U68NTz9Q0m9hb7KfTet1/3
mBsq9lPAi/V6HGNWnvb/xPfz5Q2DM11Jt8QNZ409M3mUOekZ7+2IofOerz2L
kJ7BbxSMyhq92Zr0DP41Zey7BiFCz+CTEtPPffkp9AzeaODE+B8WlqRncOfa
+i/dS1uQnsFLlC4MXG5jTnoGX/FmQJ1haSJ+Ap9S4vboEzfF9wk84Mn5lF1j
RP4G+Lbp9S7mfhP9C84O9Jh5sLXYH8T1WsWAOSNcxX4K+Lt3x16EfxLrdeC2
MYYjvo0X6xvgIe1GX+t0Ppn0DO4eXee1c3cRP4MP3eS1tkiFL6Rn8IF6u9sY
LRPxM/jmhJjK0/emkJ7Bv10Z1OaYl1jfAN/p3XDogKs03yMeteZh4E9/sZ8C
HmvWcuWvVWJ/ELzJgZZf/RuI/A3wPTUGe/88KPI3wC/0e67fMU3kb4BfHnX5
3bAaZqRn8FOnSp+/4ES6JX5rQadcF25Besb7yY1mzc9mCT2Dt3lT1mZ2+yKk
Z/CswIphm/+xJj2Dd1lm5F0ryIr0DN7g6IBY5zShZ/AVyxvdvlbGkvQM/jL0
3I2eDS1Iz+A1W48ru6aFOekZ3GJI2ph9jc1IzzRv21b9oXdZ8X2i/AufTmN+
JBiTnsHDwsZ7jjsg+he8+dH4CtkOIh8J10qtTN12Lhb5G/Tvy+fM9u4g9gfB
m9R0d38VLNafwTelvmtTbQvpj3iz8gEXXuUkk57Bc4boTX3gKNbrwL0jrrw9
/lGsP4OvDzB4fNmR5m/Ea3oVPWkcLvI3wDttbhzVb7rIRwLv5RWV4x4l8pHA
6yyw75VbifY/qJ+8dvhtOdyR9vOIr/FbW/vIEDPSM3jb6rElbg03Jz2DW010
LmPYj3RLPHRV+WH1nC1Jz3gPD57F3dQ/ZUN6Br9Zp0aKsZkN6ZnixOfvz4UP
LkJ6Bp+0JDa31mlr0jN41XfVu33OsCI9g5u3tN5l3sKK9Ax+YP8bnx/TLEnP
4LNjXgf6nLAgPYM/3lnYaNA7c9Iz+HVnz9auRc1Jz+Cpc8fnZXcyIz3Tcy3v
sfv4DjH+wUNnNJ20qYToR/DPUWM3BqeYkJ5xzWcrbeu0MqX8DVqfftsj16qo
PuUjgWduXV16xpMs0jP4tPezD9dcRfEB8XLjd/ndfETxLvEqOc+t0zeI/Drw
gG03PmW0pu8a8ZJ31nGv7zTvJt6kcHHyjho0Tyf+tojF/EoXaD+D+MrRwS4V
xpmRnsE7H9o4qkUTc9IzeIh+7NATheakZ/BfC3wcez+yID2DN52/5obxNtIt
8bW7jh2o2t+K9Iz+lvUMLuuZ5jeSnsFlPYPLegaX9Qwu65l0IekZXNYzuKxn
cFnP9FySnsFlPdM6nKRn8DxJz7gWRv2tZ3BZz+CynsFlPYPLegY/JekZvLSk
Z/DGkp7BZT2Dy3oGl/UMLusZXNYzuKxncFnP6Fc53gCX4w1wOd4Al+MNcDne
AJfjDXA53gCX4w1wOd6g9V0p3qA8TSneAJfjDfBmUrwBLscbFEdI8Qa4HG9Q
HocUb4A7SvEGeLYUb4DL8Qb4WineALeT4g1wOd4Al+MNcDneAB8qxRvgcrwB
Lscb4HK8AS7HG+g/xXyQKeaDTDEfZIr5IFPMB5liPsgU80GmmA8yxXyQKeaD
TDEfZIr5IFPMB5liPsgU80GmmA8yxXyQKeaDTDEfZIr5IFPMB5liPsgU80Gm
mA8yxXyQKeaDTDEfZIr5IFPMB5k8H0Q/KdbrmGK9jinW65hivY4p1uuYYr2O
KdbrmGK9jinW65hivY4p1uuYYr2OKdbrmGK9jinW65hivY4p1uuYYr2OKdbr
mGK9jinW65hivY4p1uuYYr2OKdbrmGK9jinW65hivY4p1uuYvF5H+6X/7/0U
pthPYYr9FKbYT2GK/RSm2E9hiv0UpthPYYr9FKbYT2GK/RSm2E9hiv0UpthP
YYr9FKbYT2GK/RSm2E9hiv0UpthPYYr9FKbYT2GK/RSm2E9hiv0UpthPYYr9
FKbYT2GK/RQm76fguRX73Uyx380U+91Msd/NFPvdTLHfzRT73Uyx380U+91M
sd/NFPvdTLHfzRT73Uyx380U+91Msd/NFPvdTLHfzRT73Uyx380U+91Msd/N
FPvdTLHfzRT73Uyx380U+91Msd/NFPvdTN7vxvMp8pGYIh+JKfKRmCIfiSny
kZgiH4kp8pGYIh+JKfKRmCIfiSnykZgiH4kp8pGYIh+JKfKRmCIfiSnykZgi
H4kp8pGYIh+JKfKRmCIfiSnykZgiH4kp8pGYIh+JKfKRmCIfiSnykZicj4Tn
UOSLMkW+KFPkizJFvihT5IsyRb4oU+SLMkW+KFPkizJFvihT5IsyRb4oU+SL
MkW+KFPkizJFvihT5IsyRb4oU+SLMkW+KFPkizJFvihT5IsyRb4oU+SLMkW+
KFPkizJFvihT5IsyOV8U96vI52eKfH6myOdninx+psjnZ4p8fqbI52eKfH6m
yOdninx+psjnZ4p8fqbI52eKfH6myOdninx+psjnZ4p8fqbI52eKfH6myOdn
inx+psjnZ4p8fqbI52eKfH6myOdninx+psjnZ3I+P+5Lcd6KKc5bMcV5K6Y4
b8UU562Y4rwVU5y3YorzVkxx3oopzlsxxXkrpjhvxRTnrZjivBVTnLdiivNW
THHeiinOWzHFeSumOG/FFOetmOK8FVOct2KK81ZMcd6KKc5bMcV5K6Y4b8UU
562YfN4Kf19xHpYrzsNyxXlYrjgPyxXnYbniPCxXnIflivOwXHEelivOw3LF
eViuOA/LFedhueI8LFech+WK87BccR6WK87DcsV5WK44D8sV52G54jwsV5yH
5YrzsFxxHpYrzsNyxXlYrjgPyxXnYbl8HhZ/R1GvgCvqFXBFvQKuqFfAFfUK
uKJeAVfUK+CKegVcUa+AK+oVcEW9Aq6oV8AV9Qq4ol4BV9Qr4Ip6BVxRr4Ar
6hVwRb0CrqhXwBX1CriiXgFX1CvginoFXFGvgCvqFXBFvQKuqFfAFfUKuFyv
AO0p6slwRT0ZrqgnwxX1ZLiingxX1JPhinoyXFFPhivqyXBFPRmuqCfDFfVk
uKKeDFfUk+GKejJcUU+GK+rJcEU9Ga6oJ8MV9WS4op4MV9ST4Yp6MlxRT4Yr
6slwRT0ZrqgnwxX1ZLiingyX68ng9xT1vrii3hdX1PviinpfXFHviyvqfXFF
vS+uqPfFFfW+uKLeF1fU++KKel9cUe+LK+p9cUW9L66o98UV9b64ot4XV9T7
4op6X1xR74sr6n1xRb0vrqj3xRX1vrii3hdX1PviinpfXFHvi8v1vvDvinqM
XFGPkSvqMXJFPUauqMfIFfUYuaIeI1fUY+SKeoxcUY+RK+oxckU9Rq6ox8gV
9Ri5oh4jV9Rj5Ip6jFxRj5Er6jFyRT1GrqjHyBX1GLmiHiNX1GPkinqMXFGP
kSvqMXJFPUauqMfIUY9R7/d/i508f/drms4qssnI/aE/2Lzf/R/GwD2+Wb55
ujOO+J/+TtZtPP653z/hH9nc3zyK+OAr42YczkKe+mfiay+XfzDp3QvY6+b8
aU+na9Hd5fgqI46fcT3WuUuJ4z0NNZ7IwKf02Dtn4e5s3B9xp4s/upXaBH+b
Rbz/8o5j31xAfm2OaCdp2rGYK8aaPj/r8HxtLoRknVlrzHGf4Lek+wQ/ot0n
+hN81N7Vrh4b9Dh+xnVCg03TTw75RfcPLt8/eD/t/qV+Zop+Zuhn9Bu4nuel
+v3HfCaOv68X39rk9ol4Nv733zW9jev8+74jN4n8TOLX37qbN0y15NrPuN5e
n9S33b5ooTPwru9X1vniYoZ+1uYZObqDfSbkD76SQvcD7l2i2rBqX1JJV1p/
6N7+/Nkweec3el7wk0btw3w+fKN2wA+W9Mw90PQntQM9O9auX2WM7WdqB9x7
A4++vvX/6h8d+gf28JejX72Z0n7qe7mfdehn9Dva6WvkFLerSDJx2O/pV+pw
5aHf6X3Avn41j9S+DdOJw355uQtH25zB+m0W2bftdvKaed9fxGG/z2jciQWT
f5GetPvVrTOoFPB0v9iPhv3cVcvaj3ofTv0G+y+mXUaG1w2W8uKSdatrF5ru
2/yO+gf2toPCj64a94j9PX4TdV5V/Bc13PiJ+gHcrT6zdaz1QxrXibr7dYof
HXQ8nf09rhN1PeuPrLLlUbbkTxJ10z90MsnP+UUc4zupbHBnL8M89refSdRF
Ol2ZeP6O8COw/3D2ENt1N5NhXMP+2z0vRy+nJOKwNy3/aGqhnthXgn2GeSfb
+4EvqP9hv/b01FM5+V+p/2HfNspkUcvP56n/YV/G98nOo5HvqZ/BTWwqe91p
Tb9PvPkQx9zAc/HUz+Df+43cy7JTqJ/BQ7p1dj8QkEX9huuSOI9Qp7165PfA
z3ueP7HJV+Tdop2uTnesDBd+oucCr3/aJ/JKxXd0P2gnsuhb/wrhWdL7itAt
Si36IX+UAf/7vUTo+hcudbCbIvwqfs+zlnnMGo8U6jfwcxumWLzqmkT9Rs/X
clVK3tck6jfwrT1HT11cKVXqzwjdU4vK9RddzJB0G6YLHFUjc4OTPvk78KST
RYOMc4sQh14abCzat/gtG/KrsP+1v+tE0+42/PPveMOYeGrfmREruxQhjnZi
QvPCXlex0fyqIdnf/rxqYPut1sRh36Fbuyl35xfR4hwDsh8+X2/w6Ugr4rD3
Y43sCiKteZffz6tH9gMSC040sLIiDvta+hNWFtS21uKrfPqOezSa/a11K0vi
sB9u2GXd4TlW+C6TvePyuQO8hlgQh33pJ+UvrX9gie8j2Tc2cbIbPNucOOy7
MH5nU1lLDv9I7etfchr6jxlx2Pdbuq7BRR8LDr9G/dnuaivPDabEYf+j5AUX
w//idoxbikOCJn1bs8GEOOx7fTlxzXeAOcUbsEe8gfgZ/FRC+2l5FiI+QTuj
z0W6FNiaU1wN+54H1k+olWdIcQvZ3xvXoGChOcUnsB+txSf4Gf8esL9R09Vz
LMke10Hfp7cP+lmK//0dCdNN1OKZv78X//nXyf5Joebp5PfQzp1h5Tq8TcyT
vhdhupldTNMjx6ZTO7Avc8i6+fvjYn8H9ollGl7yGZBJ7cDedvEuZleDvhPE
e0c+yupRS6zDoJ0Fb+v2WH0J60vJZJ9WV896Ws/iIp9Dsw9pmltjjL0Rp/hJ
s795e/D4Wt8sKH4DL9lxfcryIeYUf4Kvdd4/sEoNnGPKp/YPBswJWxJoQhz2
+47/027rOHOMO3pv7v17uY65Zkoc9iEtm9ask4TzU8KPvnK53cb8nBlx2NvN
zx/u5msBv0H2pZndnNH7zInDfvEWt6eHHS3hl8i+0T0eeHWZBXHYt3xU7GGZ
ryJuJP/5IKxu3GDBYb/nRZOqVjusyH9CR/CrlG+g2buOCbt5yrgo+UnYw3/C
H4LDT8LvgcMfwr+Bw+/Bj4HDv8FfgTfV/Bj8Ejj8FfwP2Wt+CX6G7lPzP/An
NF/Q/Az8A53vu1O6tZe7KfkB8KfWgXFB/+NcG/qt6NrVPxLXFKH3Afu2q4s2
cCwv3gd4hZjmmce3GtN8nMZdcA331SdEnAn7gie7Zg1ekSvyEDR7/Qm711Vz
yKTxTn5F8xuUn6DZ+6Q+HGsbnE3jHfbwGxjv4JO1eSLlLWjtdHQPH7vK3prG
O+zxHad8BozTclv6H/9A74ueq+6tyluPmpnSeAefdTv65sNsExrvaB/zTYxr
cIx3jF9wjGuMU3CMX4xH8FLaOMW4A8d4pDwH7bl2dnzd/O0PGl9kj/GI8QWO
+ATfKfC/v1MRxPE9gt7AK3m8nHS5m1jnAb88e4XfrHl51O/Qxbqjnr3fh2dS
nEnjsahPb6eN4lwNeHL3Rb7PT4g8FvCha2f2OWNVQHoAh//HeweX/Tzup0xM
HxPXUWL/FPbR34ccdW1mTP1MfP5aH7cQ8T2FfjFfkOJYpohjmSKOZYo4liGO
leJ8hjgfuoV9fFuPqOh0PdIz7G2yLH6cCs+T50cM8yNpPsUwn/o73khkmDdJ
8yCGeZA0P2WYn0rzIKaYBzHMg6R5K8O8VZofMcyPpHkrU8xbmTxvxe9hPiXN
Z5liPsswn5XmrUyet6I9C727J4+cFOtZ4IvjLnkZvxN+Dbx6VJ9jnc9+k9fr
GNbrpPkmk+ebGDfdzJxLmSwMoecE7xh+eOuyyMf0++BFg1fGTav/SczHtOf+
UDvhn19HxP2DNy0Rcj1jvtAJONYh/z6vl8yiUm/VGn5XfCdgj/VJaR2DYR0D
fgb2lfiFcpPzEuV1IaZYF2JYF8J9YnyElmoQ2ve5GL/gIecPvHeY80Nev2KK
9SuG9Su0g++GWePQE34HxDoYxY8LR0RV2pcir9dxxXodV6zXcazX4Wf4rdU/
avBblmYUd6G9npO2OM84binb34b93/UZcnSZGxv5dmsgzkMiDqq+qX/K4R7f
pPNoWbrkUmuv32oqzlUiPir0TavQ4OQnsgcPuXLRvvDMF9Ih1UvUuZW9fv0L
6QDcePaoGz7jxXikfbxLy495hIr1NPAxp6K/TGgr/Dudl6q/89+R/WLk8aJT
jBedYrzoMF5wn+D3RjtvdHMU64Hg2Un3Ft5JE/dJ+adXYg5//Sn8BvZnTtjx
IUZtxXo3ON/Z5v7hjHRJz3G6xt+trOPG/5D0HKezvjb07drkT5Ke43Qmz1s1
nFA3QtJznK7i9K2dFq8Q68/gZs1uRHo/jKXnpfb9wt82aEjrpMRv58VeuPYx
Q/KHMbqWKWse2PUokPxhjK5573kP3dpkS+urMboWux/c6DE/nfwJ2vOtV/XQ
h1M/SG/gbeL9PVqdE/oED/+5JXZG5E/J/0foMnpU3Du/dR6NR8Q7ThYPVt73
FOs54O0POxe/ckHMRyg+2nbUr5uJWJ8Bv2NfPXtAT7EOA36kom3z+zvEfAQ8
XT95Q+BLMR8BXxDcclmwjVg/AU/L6b/fvr0FzUfAt+Rs67dwpjnNR8B7FevZ
4OhJM5qPgG+bcf19+e+mNB8BvyXNR8Dl+QjeZ2UtPsTP+Pd20nwEvKI0H6F1
Ki0+/NuvBurk+QjsETf+7W8DdS1MjRd0zMwgnYNXi9x/vdiYTNI5+A9728FB
ffJJJ+AT2lXRt9poQvEkeD1pHgEuzyPAH62dm7fb25TmEdT+gcObhv/nhzGP
oPf1MPVW8iMx3we/6HAgQ7dTzOvBs4t5nOk3SszfwadPKjjVtbGo14F+Q3yL
7wLsHVIWh/fJIk51Y+RxAS6PC/A50rgAl8cF+GFpXIDL4wJcHhdUT0YaF+Dy
uACXxwU4xgV0BS7rClzWFbisK/Axmq6gE3BZJ+CyTuj+JZ2AyzoBl3UCDp1Q
XKJx6AHjF+N1eY9bViur5ZL/B9/8OXrarHCxnoXx+uLd11VTl6fJ/pwp/DlT
+HMGf/73/loMW2voFrbFLkfaR4thbdMGBx4qWSh/T5nie8oU31OG76m0P8Kw
PyJ9Zxm+s3/Xc/vMuiSe/vjw/Wf5+8sU31+m+P4yxfeXyd9fxPkNG8d3qFH9
F/UDuKF5q6PxJUU8Dx65pF7HkcO+yXEUk+IoOlebONBn652VYr4AXnJH4PNB
JqJ98Lsfr37cniDmleAGOzuPsJ0QSzrB830e8uVC7Q+xcpzJEGf+XW8hi/W2
OBqwZXyyVG8hi5Xze3BrSECSHN8yxLd/1zfLYQ1XhVVrWCjidvhRxNXSvjnH
vjmdn9Kee5fhZrZ5kqjfBT7hTOSSuCeifhf44XPO7ybXKSLOT2ncxGVuwtxF
1uL8lMYf+FbQPx4u6neBO08f/7m+rZU4P6Vx90Prz9WfbCnOT2l8ywDrGT53
LcT5KY0XJr2ZeLSyhTg/pfGzG1vfqL/JXJyf0niVwIpxRk3Mad0JfGMVe4ty
jmIfBHzFnLtpJ2tYkN8B37Njxaw4Y3H+DTzfkh96VYfqhxD/stPV3tCZ8q+I
x1iuOzX6iLk4l6TxM1d3d3rRwkKcS9L49gcdjn1/byHOJeF+rneI37rOUpxL
0nijpnuvXmhjRfMp6DpB2+8I/f4yuuldk9sLf/MTrP2XicPejLDhba8cWTCv
vDHxtqlbmt7TFeHXFs+sfHeqIXHv9t36FCldhDfu7KYze6hPfOIch1G6Udb8
eInSXh7V9Yg3NRpgUfa8FW8f+FDfPitPB24WdunItV+WvKn7+HbXjmYTD6nY
PiuxtSWv+fu5MomXm/BlcPGFFrz07/5JI17B1OeoX5A5L/q7n38ST3+e0OtM
SXOe+vt9xROfH7yOmSwx45G/dfWJePNWQYte1sY89BXxu5/31f3WF/t9QcRZ
QJpx3Vhzjp9xXV365dKGVUz4xt/vN4V4jSTHlalmltz/93tMJ74uwrrSg/1m
POD3+M0i7nomRr9jdTN+Y9nuf6d65BL3Xjv8xn5PM/4oOdfri38B8ZUHmun3
/GDGvzcIsLHP0qP7Cn2VuHnKKnM+Y+R7ny/+BsQfmr4/5cQseP7uIk/83YyI
l35TzHZ7ngVf8bxN/f4/jIl7nrxsVSrQEv3G0N8+SfGhS60fa/4qiK76tx7X
XOmdxyR7Bvs/fuoVw/t56r3XwSj4Oelz5p+/q4M+tfsh3qFYnaglxYVuwaFb
2OP+Ya89L9kfXOT1ce94oXNw6Bz2aAf2Wn+Sfe3QuGNldNY0LsAxLmCPdmCv
vS+yrz7h5WYbazGOwDGOYI92YK/pQQf7J882tUvuI8YdOMYd7NEO7DW9kT3b
ojv27y4xTsExTmFP40Kz1/RM9iv5cNuEaAsa1+AY17AnPWv22ngh++S+TkON
qwo/AA4/AHu0A3ttPJK91Y5ShzPGCr8BDr8Be7QD+z9+Ponsaw1j5/ODzcjP
gC/Q/Azs0Q7s/3zvvpC9P3+6aGBn4ZfAW2h+CfZoB/arf38H35F9VbdzDjVr
CT8GHqT5MdijHdj/+T4+I/sB+x+4zHsl/B441/we7NEO7GGH66foXYbtd1iS
HwH31fwkfsa/f9Ts4T/x7zU1/6m9d+Lt+0+/dG4GvXfi8KuwR/vtNHv4W9i7
af5W0znxb+Pq/CrfWPhh8g+aH4Y92k/U7LVxR/YT+gwIP7Nd+G0aF5rfhj3a
gb3mB6ifbg/pHb+4kTn5eXD4edijHZ1mr/klsh/lVsuvzifxXQDHdwH2aAf2
mp8k+4MzWp09sFd8R8DxHYE9+U/NXvPbZO+wYfJm34GW9N0Bx3cH9mgH9tr3
guw3ZR8bGlfGijjswbG+AO5Y/Lmf71UL0jniqH5tokzsjlhh3NF37Yltr0jH
yZnaOcck4nVfn/V60ELsD6L9WVMPX71dg/yPiAMT/inwnmND+gSvvaBTxV9P
RZwA3skgePEjdwtubT5pbbHtprdxPVZxWpb9Y0tw+vedXs8j6tU04+5/xinu
978vzi0b65tR9F2Gn2sa03TGzpxXTPMP9H23vL7RJ65kGHG0cy9y8rHrPc8y
9A/saxcZ+Liix0tqH/ab762dU8pUR+3An/WdalipQoGwB385Le6si+VrhvvH
+/l8+cnyGS1+Ecd77zhqdWC3WjnUPuzzrK1WXLyfThz2jtsiur4vlUn3D3u8
X3DYN0y0i/1VkMXQv/TdjGrw8ckFG9IV7JtpuoIddPLB/pWVST3k+72i9l8P
MeqWyLPoufB7eC5wtPNJ6wf0G9rpv9ZrmlH3THpe0rn2vOBoB/2jfb+onThr
75L1juVSP6CdBlo/gNM6z9DTq+uPoP0Pagf6hz7Bh/U/X/PBdCvqB9xPsyme
eys9zqDnAk8+129Su5x06gfEkw0rZlqEXIum58Jz3AkPcXLPCKZ2wMetXc/c
IkNlPTPoWdI/g/4xTwef4b9u4ZOOoUwaj1wxHjnGo7QvqcO+pPRcOjzX33lr
ibplNSp3d133hvofccf61z1rFNZ/Ka/z6OR1HsyDf5UsWfH1xK+0noL1Ei8t
zwH9gnEB/yblbzM5fxvvX85vp/ps2v6atK+qw76qtA6jwzoM1rXAR74/Y3a0
yTuaR8CP5RRuaZRcECXbM9hDB3iPC266znaxpPM/5Fcd/eKHvsqxpPM+uE+H
6kuqnG0u8iWwbpFUrkGNiE/fZJ3ooBO8X7yvvt92Rv6aKO4ffvLfWQ33ztr3
RNazTqFnnaxn6OSIXe/6ZWtdIXvwtbv7+BW9eIc44k3D735dO3YQ61fQwxUt
rwbjEHow1OZ3VO8F6w8z7U7pZRkjria/kdYqp+e8jub0faJ5iuY/wek7aH35
Z3SsDfkL/P0NvgkRn4LF+gi41/MZW2YcMSB/gr8r+1X8XqnIebvLTcwR/a/x
kmffN5o1VZyfQfs5F88vSrLJoX5D+/0kf4t2dvab0DCsbab4DmrcrpSuW/L8
TNIh2vkq+VvYJ+Tsdg5p+ovswavuy7hhkp/LtPkUtXMgp1NAJjPDPIv8MDj8
Eezhh8HR/sKBR2eZBVlJ54ZimJm1SXif+1/kvH2GvH3p/ALD+QVJ5ww6l/wb
U/g3Bv/2d33mZNblVmXbZae+0ntCnPW6feykJY5f5DiEyXEI/q5ivDCMF9w/
dF3DoF3xPoPE/gHaD/qan/20fRBx2Ldx2GowqexTah/jptOR+9nB/vfofnD/
U++eG3Gqzis5TmOI08ARP7rO2jXC7kwMvkeUX1HQYYRPBWczLt2/DvcPTv8/
tdALNlN3PJPvX4f7l55Xh+eVnkuH54I9/JXzGYtofe9H9HcR7w12GfD+5oe3
ZA/e61mZz3pPXpPO0M7bS4Ep7WqFk77hlzZq/gEccVmfmZ+vJUeL+QDsY7R4
DLoHHy75E/DmWnzydx5RkC5X8g/gKVrcgnZo/zR1SPrWs5lSHlGQ7mD/rctb
29K+CT1f5vWhS2vPF/4E7ZSqmLbD/VGGlHcUpNvxKu7neF/B0Y7PK2u/2unC
/8C+dusDK0eNzCaO9rPCX/usuZFDOoa91WrjLbyhAfl5Wj/R/Dz0Cvu2422u
J7kZUd4s+Ovzb3fF/jc/RP9QPCn1D94b+gEc4x79hv5BO3L/0Hq11g/gaGe7
1m/oB/BaWv/gecEttX7A84LjeaX5DlPMdxjmO9K4YBgX0nopw3qpNL4Yxpc0
XhjGC+4Pz7HP+Xh65wWfKY7FPlKj/vPHfn8p9pXgV5p8f/3Vsz99Ryi/S2F/
G/b4/sI/+BZL75/l+Fb2ezr4PXxvwBtbPinulv6S7NFOyMyqMyca3BbfTc0v
pQ092aZUpQjisO8bf+/iMOtIqa5dki6zw9GrM1odlOqRftFVfbahU9bVl1K8
GqRrv7O+z0bHQtIT5c+8bLEua6AhH/Lb7gL7s09+W7egXEbB9Tb6/O/81Qjd
wMRuuXoPxLkV8OXzfPtu6JpC7x3rbc7hG6Z1ck+jeIZ43hTXdi0ypLzHZ7rp
H5sFtagq5k24zx3+N7L3DMum/oR9vRGfVgdOSZXyYyN0WT3epbr5p5BuYX+m
bJzb2L0iTw+8+compyNGpVL7+LuOL/iRr1sz6L2QP9Tmj9AT+jUlNWeW21sb
8tuUj6H1M54X/uejXZupH6aI9QHYb9eeF/cJ+4wRF0dPNxXxG+xxn4hPaF58
rvLmE8uz6Rw+eF7LTxOe/WtF94NxFhYeNXRAuKg7B25q+zT10zWxLoF+TR9m
uDQ47qM8X2OYr0lxO0PcDjvwwR0G2f/79COT1n8Y1n+k8cgwHtEO/Mbtg++6
V/94Tx53TDHumDzu4GewLiSNR4bxKM2/OOZfUjzDEc+gHcxfavucaDv/eiy1
D3+80m9qG2drcW4UV5yb/vv/x5HMNlUdfjaxTzw9D9pxPR4/0/vqV/b39yuN
4Vy2dH6c4fy4NH9kivkjw/xRygfWIR8YHPPNoMljVxzT/0Z6wr5H6IfOIxcG
Jcp53TrkdUvxs04RP+sQP0vza4b5NfoHf7eEV9d/ikR8I11hvnni7r4+YbPF
94vOKTsFDr9e9JmsNx30Js07dJh3SONFh/Ei6V8H/eN9YZy+CS1pfua0JcUt
6Kf2zue+nvcoSnEz7FM1/4Of0X+9tXgS4532LzT/g/uh/WjNz8CfgMOfYL6G
+8lK3DU7fLP4/6fAHn7m7/npf/Mw6TtC+VHadwTvBVcn7XuB90Jc+76gn8Hl
7wLaz5S+C7AP0L4LaJ/WLf4Ny2p0+bOsBybrAfrCd1mapzDMU6Q4gSFOkOIc
HeKcv9c3EnVlr4f7rpss9I94YPTpVofqlRPPie/+Q8mfg8OfQ1dUP+xrrNmm
eCPsD9Lfl+NqcH/NHrrFfb3U4mQpPmGIT6R5E8O8SXpepnhe9vfzBlE/+3Wv
0Nb0P/73uA7TeTW/ULfhI7EPguc4ZP0zI8xJfA8wP108wLbSXrME2W8w+A30
M/4O4ha8d+g9vr5D01FHhM5hH7lgRXd+K5V0BvsOl5cdsvoq6qTg/S4dsfTI
/dbie4zx3X39inrGCeL/YwdufCG1ZPpoA4rr/rz3C7qhZ0uVd6yOOCSI4h9d
yOZ1SY1/SedonumG9Q++Y7Qtk/wS+hl5++hHmld1t97nu0LUYcF6Js4jwA79
PO/FpC4jS32n8Yv9XhfTmdaHF8RTf6FfGxdv0dk1NoV0g3/3ix3h7/ZcnPsC
X3KsZL3qpdOo3+C329Y297IeF0sc46tfo5jlDf4RuqK89G25tT95FWjt3qY4
+doMqzqn0gVHPx9Jcdl+ercejQt8Z23NU9Yt7CX+vyzgE942D338Lpn0Bv96
f4NJfFTUDynujdEN94h/HtDoi7TPEsGG3Vma/H1jGpvwu90Qus8zvo9XjrAU
66Lgq4vV63J1nMizxfd94UL715OrpND7wv3MCul+oG58stRvYbqxMf+k3++Q
Q/3w57lCdK8vlW44aXWe1D9Buou26fF3b+Uz+4L7PlcTjulwxbl7X4vT15pP
PMaW/rkSh13TP1cG7tTsvF+ZhtdoPxQcP7d7vOlpnWFXmczZH07thz59mvuk
9lUmt4P7wfV/a19l/7+1Lz+v6j5V/fb/2z//Bw7Tepo=
        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJy9nXd0FUe29d9631rjQDD2zJt5MyNhsslBKCKJJHKWhMjYgMk5Y4LJJhsD
JpucMcnYBmOTc1IO2OQsRJTAYPB/366qruqq6uq+V8bz1jozC0v3Xl31T3uf
far7dhXvNiiu53//13/917A38X9xXUfVGTq06+j4IviPhIHD+vQa2KN744HD
e/TqMTS82//DF+dZ/yP/frmwPKkv1VpQ4Te55ks1r6JVX/Cai6pE6nNacyq9
IFX5xWxasyq/mFmF1Axa06u8mFb1Oeqzqs+noqo9n1Lt+eRqzycF/Tox6NcJ
tMZX//XT6r+Oq/5sbPCzMcHPPgl+Nirk2ciQpyNCng4PfTo09OmQ0LzBYXkD
w/IGhOX1C8/tG57bOzy3V0Ruj4gnH0c86VbjSZcajz+s8bhT5OMOkY/aRT5q
E/WwddTDuKiHraIftIh+0Cz6QeOa9xvWvN+g1v36te/Xq5NTLyYnpl5OTP2c
ug1z6jS6V6fxvdpN7tVqdq9W83s1W9yr2TI7ulV2VGx2VFx2ZHx2ZMLdGm3u
1mh7NwLV7m54+7thHe6EdbwT2ulOaOc7IR+SCv7oTnCX28Fdb1dHdbsd9DGp
at1vV+txC1W1J61et6qgepOq3IdW35uVWPUjVbE/rwE3K1hl8ZJLYVfhZT7A
adQkZDI1IJvOkX0mI6tGkE1UkYHXaBXZMI5sEEXWP5wg60N59Yx40p3z+qjG
486RjztGPmof+aht1KMED151LV51G0i8mgpeBFY0hRUFWK2za1BeAlY4hRVG
YVm88gOrsgXrZmWZVD8nqZsVBqJeLirHywFuobvoXoeaQWg2MltoDNlYFRmR
GEU2JPSpU2LgRSRW40lXE6/4qIexnFcTT14QF+MlxBUtxNWai8uCdZfAksXl
E5abrDRS/RVS5UndKD/o5eJypBZpVd6ATxKdb3Ae1IxCgzcyZJNVZONkZA5X
tCQWZkushyQxaomPiCX6w6s+59WY85LN0EVcuhMyWF38h6XKSiM1kJG6QUmx
snhp5cTnJzh3anZT04Xm2c4+VZFprgiJDXJIrLtLC2O8Wuq8cmRejublLS7b
CS1YH5lh6R7olJUbqUF2lRuMermkrFTlSHnhcwHnJjcjNaPQDO1MQ6ZmD+6K
VvCAxPpKEkPqkC1RRI7Y6IdGXjEaL9G8RNIwiku0LStj+IJlkpWhVamkKCZe
Q14uLWvXkrK+8RnZuYEzUjMKTfFGFdn4IDsu8kZmu+LgUFViauqQWpgVEcGr
ucyrDuUlhUOpeWUTXnbSMMQMyQm9YCke6JSVT1JDbpS16uWysgoyb3z+gssn
NVtofiMTrqhJzGSJSkT0l5dmhpK4TLDuOGDpDUvzQCErv0ndKDsU9WrZB1q9
JOUTn5GdDs6LmtEeqdB8IJMbGVxRBI8BauoQlsgihxzpCa9onZccNhQzNImL
xAxnIPQBS5eVNykV040PWA17tfwDvYwEvfC5g5NN0o2aJjS5nYnQOMmR8HVX
tCSmpQ6lhbGI6MnLbl6yGYoZ2SguG1Y3d1iarOxQ4SBlxnSdVZlhr74qY9Vy
Vg58DoI6Pg9witwkkxTU5lrULKEpHc0PZLIrqhIjg5hlibyFtXHjxYcvO2zI
ZsjElaDEDBsWb1sGWI6GpcrKTumupGxM18sMZ2XzcisjRB/sNHAuJmlTE/ao
CY22Mycyu5ExV5QlJgV7ZomihfGISEawphovHg7t5sXN0BaXPHCZMoYGS/ZA
TVYepFwwkSo9AvVqRWlaZczlD0EjOw2cLDcnNckebaFp7cyJjDcys8RkS+Qt
TOdVX+bFw4a9rGElDUlcwgkdGUPAcjYsW1ZupFRBmTDxGvlqZWlzrZDLE6KM
T7DzAqdSmy9RkzuaCzJ5KLNdkQUPZHshMdkSO9Op2TevxoKXNHZp4pLalhcs
2QOFAbqS4oIyYhpJqpRVr1aVtsuNnZmjCZ+DnR01GTgPaqo9Kt7ohsxqZLYr
2hLTLLEjX5WKi7J4NdJ5Sc1LmKFTXKJtecPiHijLqtwghZRRUDKmUqJGsbpW
ctSrVaX8K3embvgEOwM41SRFGrGFVtESmgcylvDHOlyRSYylju5SC2MREbxa
SrzqufGKlWK8HDOktkXSOx+KOSynByqyciPljgmMaH3C6tXqUvkoN45u+Gx2
EjhNbjI1rakxoUntzIFMc0VJYix19JBaGIscbGSWeYlwqJkhkoYiLtUJSSB0
h6XIykhKE5QXo2slWI1G/b6mpL+1uuQrUj45mtg5wL2UwQmTXKjao+aNrJ0J
ZJM0ZPRsiyYxZom0hZHIwSI9XULkvOq68IqTxWXFDOaEVtvyAcuWlZ39JFJC
UG6YJEZWFSf1+9qSfpVvlEZ8GjtJdAKcTE3qawo1kRt1ZFIjY65IgweTmJU6
hCWyyMFGMAMvpxkm8KV4IS7mhKxtOWCJhmXLyoOULSiHlBRA14qPkev3tSX0
WsfL+S1DmYEqStTYyeBYjxPdTVCzkr8qNNHOTMjIRMZcUUisn2qJNHKQiCjx
4osbdvPKjm4piastFxdxQglWdxWWyIGarHj2k0k5MemMJEDFUGNFXS021qZj
VXH3KuGjNI5GfIydDE7ITZikTE0WmtzONGTIHswVWfBgEusfxi2xxpOPrMih
8mInU3jYMJohMrzlhDxjKLAcHihk5UZKmJ6CSWZk07Hq/XGifl9f/M8sDasJ
nxc4apImapo3SsimVrWzB3NFFjyExJglshbWnkbEWBMvq3lZZmjFeFtcPMBb
6d0BS3igMECW/WxSsqAcUpIBSXTsKvopK3KQN/xJ5QpRw6d2PQWcbZIKNSE0
BzK6YMXjIndFSWI0dfRgLYxHjliyhKjwssJGc7LGaxIXd0IzLElWkgE6STFB
CUzU6wyMitp0pBrP6tWG4v+hcuVoYsfBcblxkyTUZKExb6TtjCQQGRni4gTJ
FZnEWOqglkhaWAcr0ku8Yjgv1ryYGcri4pnQyhgaLEVW7qQk0xNSMslHRiPV
BFGvNhZXq9ifV/QFjRAN7FTFydScQuPtTEFmNTLuikJiJHVwS+xII6LGS4RD
0rzI2CWJizuhHQhdYEFWwgAtUqqghJoMjBQuV5SaqJXr0d5E6uXrFXkRd4gK
O9b4ODid2nJBzRKa5Y0sNDJkNHtYrigkNphKTFhiJxoR48mSlMyLhw1uhpa4
JCe0MoZIgyJdqLLSSVmCsjHpjDzQTDJWvqFs9rs8OMr4BDtZdABny01QoxlS
CI14I125kpFN5q7IgsdQmjqYJXajkQMR0cCriTBDmjS4uCwndMBCulBkxeYp
6n6CVLExDkwaIzc0kz3qDxD5LZ/lk6aZnaU4ITebGhHaYjpZM2/8giObLiGD
K37CJEZTR2+y0IGpGRERkZ7wakx5seGrNufFzNAWF3FCkjGQ3hmsCjIsW1Yq
KS4oCZMLIBvE5aJT/CnfULZ41/v+leOJGkqNHQOnyo1QExmSCQ3e6EQ2lTYy
5opcYrBEq4V1oJG+pcaLNi+yZkjN0BIXc0KaMTisGxYs4YHCADkpW1BCSjIj
hkajM/VyoL+l0PFJZKteL/Jf9tM1lCo7AY7LjVNjfU0W2kIJ2Uw6lLFGBldE
th9OL6DqRy2xK40cbVReLBzS5iWJS3JCboM8XQyVZKWS4oLimGRGTjSfOWqa
z3Kl4xPK139GaRwFPomdDY6ZpKBG7ZEE/sU8gXxR8QVFRuIiXHF8kC0xpI7e
tIV1orxa0Y88CF61mllmSJIGEReJGXBC2rbo2uAAK118wGBxA1RIMUHZmFRG
NpRLdk3Pb/kFyPOYP9/2uuWEyAVI2CmKY3Kj1Cx7tL1RIOPZg7kik9ggyxLJ
1NxW8KqD4YuGw+Y0yZOkwcVFnbBKLwqrP4dFPVDIComCk5IENdnBSEMzw71m
0vJ4wIx8AXI54EVJbXetX01leCR5HQdBSXeS3Bg1SWjMGxeVs5DNpsimsuBB
JYbZuR9J9ZiaSUSMlXghbJDmxcyQiYs5YS8yajFYZYeQhkU80JIVSRQ2KR2T
BEhjMfMiqVn5LPIs9nRvRn7SsUHseO2SaVKCOjjqk3Sy430N1KjQdGTTmSuS
bP90GLXEXiRykIiIkbkJ5YUwT3i1ZGZIFjQgLuaEaFsE1kABi3rgaG6AKikF
kwVIRTNbrTkuNdu9yOv4wUgH5IPOTlLPDBWo1C5ayhftB5MXkQgq7LhVWtRY
X1vLhEbbGUM2l8RF0sgm0Ww/MgSpg1hiNxI5yAhm82pKm1cCSRoQF2IGccLe
JGMwWJiwSlMPLG4ZICNFY56GaaZKx6LwS+Dnf6CMNPPHyC86nIVUT0V946vo
w+znUo42Pg0co8b62jra0eCNNIFYyGZSV0TwgMSGEkskLawT4xVNLgZAmEfY
iIqFGdriIm2rH1nBILBow4IHWgbISRFBaZhmq3Tm8voiPzXXUQpEHZN/jDwA
eXHZTSrPUAG0lC+SB0vP5fg4u+0GakRozBuXU2QI+Z9XIo0Mrjiu+tMRIWQQ
60kjR2vGq25O3UYkbETFk6RBxUWdsC8ZtcoJWKNptxpPEwUhRQWlYOKA2DGf
97NV8/NT4lnzfiFlhqhhcvU6p7NpjLzQBFj1rVK5or5zFP268ngKVGe3g1kl
p8bsEdER3siRoZHBFRE8SFAcEprbO5xEjjZRD5pGk5MpCPOkebUmSYOIqztx
QrStcoMprFHMA6kB2qQkTBYjic4CWl9e8KN+tmqBWgaIgl3+MPlipADS0Dih
fE/qCal/exZ9JH8Wx2eZJ96VTM0S2rrixBuX0142ryJpZFOoxIZTS+xaA5Ge
8UKYR/MiZhjaCRkemfBmxX4MFkkXgEW61USaKAQppibBSNBZeCFwkVSLXWqR
WgulMkJU2OULk8HrXBgZAGlc9tj1mNVezxKPp0+32e0OYIrDewY1OCQyJIQG
b+TIypO4OKPKrxODno0ilogWhkj/oBl4xSAckiQPM4S4qnW/Wbkv0jvSIIFl
eeBkmigEqbn0uDFGDNDirADUElpL/aglUpHnOjg68dns/gRM7owU7bii+dej
Hxy1z1HSd/EUmyBlZymOmiSjRoS2gbYzIFtYHo0MEzSR2NBQpPrHHQSvZkjy
SBpEXHBCtC0KCw0LHghZIVGAFBfUfHoMGSNGZ1kmqeW0vvKs5VKRZ2WRckL0
wY6R8tf0/MFkZCQBcnJ5yOpH1D9FPUD95Cj7AeQpjKPFjoGjciMOuY0IjXgj
RYa4CFckEhsZkts3HBHxQfPonJh6CBvEDEM+vFWtB2lbZYeiZ9GGNZHKaibV
FEgtwEGjcljKAX2VEbAiI2AlrVWetZIXHr8ik5QGUcNnZGeBcxWUuTfZppc/
TCojDZBCZP8/75P6X6sOuBT9Lh7MIXJ2e/6Nd4K3h18B1EhH20SRLfsAjQzB
49nYYFgiIseDFpRXzZYwQxILK/chbavUSAprMpXVbE5qEcXEGBE66QGr0wPW
0FrLKi1gHSvxFV5reK3OIKUTlPBZ7LzB+SDlU1CemAw6cjISgCiIHFYHWf3j
3iEfhceQR1KCeDW8Mn4QfjTeD94zscdtFrKXS8rCFSExWCKm5octwat+dnTs
nbBORFwVBl4vPQKwqAfOpH1qQVbgYvrHv4IyWsO5rE8L2JAasNG9NqRZtZ6W
hlLgk9kx6fkG54uUH4IymJ5vTDojCuieAHT4H9msjvwddZfVUZeij8GDyROB
7wDRHX4W3gbeJH4XdDS0M4JsUXkEDwR7TGEPW0Xn1G2AJH8nuAumYwRCCmsq
ZEX7FEgtx5HEscWhTiWANqUEbE4J2JISsJXX18kBX6eQ2irVFlqbU0ltokUg
avhUcDI7H+Dcs4QrqSfupEym5xOTxogDoizuHP2fO8dI3T7O6m+kTvztllrW
14+TR+JZeAW8IH7EA0bt2wBEqd+QQFaVgitiFkOqfxgXheELZghx3Sg7BGkQ
DQu5Aj2CklpNMW3EwU8mXLYlBWxPCtiRFLDTpfCtHckB22ltS7ZQyvgEOyE9
N3BGq2Q9bqmZlEuWcCflaE9UUHZmEC3JDZPMiAK6wwFZUE7+9SbqFKkbp967
cdql6ANunST48CJ4WfwsvAG8W/xZYqZ+taLMi5lVYImPEqIQ5u+EdkbMuFZ8
NMYrBHUckHRCagPFBEY7EwO+OR+w+3zAt+cDvjsf8P05XudJfUcL3/o2MWA3
HklrlyAo2KXY7ITuFHDpOjhXub22pszWp5OSBCVMT1OTpCOuIM6Isbh+BvXu
tbO0zhW5yup8kSvn35ELX8HX8Rg8GGTxOhApfhzeG347sgyyuByCPUYwhEPM
XMgYlwKnQVY4RDiMOMKU0XfnAvacDfjhTMCPtH5Si3zxbMA+Wj+cC9iLB5+T
CHJ8uzzBaVbplNsqVW6E2p9AykVTwvrs9mQWlHA8A6brp21GNp3Edy4nFb6E
Si50EZVSEPULKhVVgFZB+sVCeMDlxHfwRLwU/hLwHvCLoJe9mF0ZETE7Kh7T
MWBBVjhuOLY45gBxOuDAqYDDJwOOnAw8eiLwmCj858kA1BF891TAoVMBB/HI
0wH7GUETOwtckgHcVs0n5QbnQU1fl/ArUfjnfr5Isd4km56F6ZSlJoHJYpTI
GVl0Cvyc9vaF9LdQWRlvZma+gcrI+gurdP4PfBHfvZD2Np4F3PgpeLe/ry+O
KQxmeDlwKg4LjuqZgP3AcTzw5NHAM0cDzx0JPE+q6HnrH4HnjgaexbeOBZ4+
FngKDzseeOJE4HFKkOGz2cngfMlNN0mf1Hyk9PwmCm/380nK8j3b8UDqMlMT
w5Ra8Oe0AhcoJsYIRNKy/pKS9ZekrDfOZ71xNuuNM1lvnMp642TWmyey3jye
9eYxWvgHvoJv4ZGgjJ8OiV0rMRq9Ccf/YPGkn0qn/PhB6r6yaT+UI4V/7Cub
iq/8VCYV39pfKvlAyeSDJZIOFUs8/H4iCALfMYKPsKPgjjFwpyk4SXGy3HxS
07RmcEiTAbrNU85WZc5+WqKw+5TJ/cykzjNSkqC4mhgmyCc16y/JnBEAgc7R
rDcPZb15IOutHzPf+iHzre8z39qd+fauzLe3Z769NbPApswC6zMLrM4ouDyj
0LyMwp1T//Z5vQerom6uj7i2Mfzq5tDLW0MufR18cXv1X3YE/bKr2s/fVL3w
beWs7yplfl8xY2/5dAoR+MAuhbArniSBO32cgDtBPDPgqJCbRo1GFH+0pvc1
aXBb/Qdl9ccM8JgqK8v9/iq5n1FTOiloJDHrjXNZb5zmmA5mvfkTZfRd5tvf
UEBbMgtssOgUXJhR6POMwlPT3/kkrUiP1HfbpVRskhwXfnJZ/Jx7Qz/Om9Ay
d2aDRwvq5iytfWdF9K01kTfW1yAEt4Re/jrkEvDtlNjtqUDBfcDAWYqDbcJC
udwYtSMOagaHpH0Ng4CGbIuHPfqxTOHvSGWUlTNUUFJ/cyYKu0/5IsUEBYs7
QtT05r7Mt/ZQKTFMENGqjILLMgotyCg0J51gGpNeZGDaux+mvtc+pVx8Ss2G
yW2qnB8VfnRXs7WX2o3NG9g7b3SHXFD7rOETKG5B3XtLat/9quat1VE31tW4
zqTHwEF0u6vYiuNyk6kxrcEhBbVD1CHlviankXwL7U+R1f185QqnrOxWRQzw
IoeFPpWV8RZrUqm0QwlNMVI/UtNjgtqcWWBdZsEVGQUXU7ubmV54Uvo7o9KK
9KekOqSWbpMS0iq5foOktsGJA0JPzw07/EPDrVmt59z7cFTegD55Iz/MHZeQ
O7E5oTa7/sP5MTmL62Qvr3l7ZdTNtZHXN0Rc3Rx2ZSuXG6O2p0KGpbXSRodk
fc1pj/4LzZBD8j1Y+d+tNA906VZWStdDhVlWJ7PeOEabFNxvb+Zb32a+vYNr
amVGwSWEVCFGCtYHTXVLfa9j6vvtUiq3TolskdwYsGok9a52bnz4ya9CD++P
2Zkeu/hmwqTHXYfn9e+bN7xr7pj2uePjcic1zZ3W8PEcUKubs7j2XVBDm1tb
4/oGprXgSzuI1i6A2veVMvfCIcum/VgmFX3NJDSRIQ9RZPvz29G0+drHcrpr
CMy/B57Itwey7MdCxRkuq4OSrLZlFtiYWWANbVJfwv1okxqXXmRoWpFeae92
Sv1Hh9QybVOqx6fUapHcpGFS2+ik7pUSh4ecmRVxfH3ooUN1vklrsfJq69k5
bcflfTyUIBvWLfeTjrnjWudObJE7pRHpa3Pr3f+y7r2lte+uoA6JcLKJCm1b
9Yukr1W5IIT2IxfaIQitKIRGOtpxpaN5eKO/IcRPD3zdxC43rDO+YWVm2rBU
D3xrHw0VO2nk20Bb1dKMQvMdsuqUGtg+pXyblNC4lDrNk5uiZ9VK6lY9cVDQ
uYlhpxaGH9sacuhwrW9Tm627FLfgTsLURx1H5/UYkte/T97QbnmjOuWObZM7
oVXuZCG0GFtorKkhjWwLvrgjiEUR3tF0bzx31BFCHMj25qedbfq/GITdYRlz
oLNh8WhhJUAGS/LAwjPSC09If2dkWpF+ae9+RDywWLuUSgkpYXEpdQGrUXJC
7aQuYYn9qpz/JOTMTJhh+NEdIYeORn+f0mTjL62W3IDEEibkopH1HEx6GULj
qM65Y9vmjo/NndTM6mjzYnIW1cleVuvOymjLGzmyXxRkZV8T2W7vsdr/lUA/
15deG5ZfynLCGkFhfUhgFaewwmM5rLpJH0Yk9a6cOLT6uUmhp+eFn1gTfnR3
yMFjUXuSG2250HLFtfh5dxM+e9h2bF6XEXm9BuUN6G0hG9OWtjMb2X0Z2UY3
ZK+rMhuZM+o7G5Z/s/DrwspXz2KhHT0Lw+/Xkg2ydDFRUZYFi9lg4+TWMUmd
o5J6BiUOqnp+bMiZGWGnFkcc3xh+5Lvgg8cj9yQ1+Dqr+eorsYtuEYlNetJh
dF63YXm9B5KQP6wbV1mcrjKnMe6kxujdy/4UZL7Txf8hLDkNnqFp8CgPGHt4
wNhEAwYbr2alF57Me1ZXAqto+5SKtGfVRsBonBxXL6kjMkZI4oDK50dWPzs5
9PQXMMOIY1vCjuwFrxp7k+ptz2i67lKrZTfiv7jbetrDhPF5nT4h2aPPgLyB
vUj8YL2MGCPpZU9EaPyq5m06oFnxYzuNHzznpzNkZCWELWHxgRrxw+/RzIzM
/zOMfxyWa3QvZK0HukzEiO6Hs97cr0Z3NmQtoksWn9E0OISuWnRK/Vf7lLJt
UoIxEbdMbtQkObZ+UntkjLDEvpUShyHDo3ORpAEzPLY97PC+4IMnIn5IRKRH
C2ux4mrcwtut5+QkTHmErIhGhuzRt3/eoJ4k5JPEmEAG6smNc2c0eDy33gOS
GGtZiyEbIq5hNMNATVax6DIIb2RpyjTtmMtEyD9th3zf0/R/GpY+Z0lD8S/+
DcVGJ5wvOWHftHc7p/61Q2qptilVMWdhKG6W3AKjFjIG2lbVxCFVz48JPvsZ
FdfyiOMbwo/uCjv8U/DBk+BVd1dao80Xmq+53GrpDXSx1jPvwxXb00aG7IGE
P6RH3oiPcke3z/00nkzTUxvlzuKNzM0V0cjcR2l5iZiN0oa5zCPk/1mwDEu4
p3wutstt64001QnluXg3X8FYm1nwK2k9cGx6kcFp73Yn6T2gfUoFGgjriIwR
SdsWMiFxwjNzwk4tCj+xGmYYfuTb0MMHqh88Gb4vsfbuVLSwpusvInWgi8XP
zW49/SGyIhoZhmg0MjsusoTfJHd6g8efM4mJ9UYuMXnNai9zxTJmV/RjmdE8
Sr8mrLvy9RUnDMtN18+6tS3dCY0BXhbXRrp+y8Q1iy839bOWm0pScUW1TG4I
J7TbVuJIDFwYkMNOfUk6FxHXjrAje0IPHax+8FTYvvO1vk1BC2u86WcisWXX
476EK95DVhSNjLniiC6WxCbJC1amicyWmLTG6LFa5dLI9rqd8fQXlnkFw7Tk
bsoYVttSlwcdAf4v503ikhadCq6ky4NfZBSenl54fPo7w9OK9KbrGLRzhSBm
sNGYTlukbQWRtjUj7PR8OGH4iXUYk5Hk0bwwLBNeP57HCFZ3Z3rDrVlNN1xs
seoKXBHjM8mKUx+1GZf30UhpIutkdbEpjcm6xxcx9xeKbM8WGNlSFe1iu3kX
E0tVB0okHypmZUUp3ru5ojN7WGuM/lzC5M8VF25ty6cTOsUlrzvxWPj2JtUM
1aTBzDA8Nrle0+SWEBecsGri4GrnxoWcmc5hrSVOeHQnEdfh/RiWqx84Hfrj
eYxgsERIDIMYXLHFqqsWslk5CZMftx9D4j0kNrgHWRBGtmeW6EwdYp0qnwvC
Wry3XVFaYFQamX7xs/v1Zjqso/rlMTd9OmFSIREzNHEZYiFfzZDNEDH+S3qW
ZAo9S4Lm9TGN8XTmimiV3KBJclydpI9CE/tVPT86+Oz0sFMLqA0yZe0KP/J9
2OEfQw8dCj54DLxCfjpX44ekmt+l1Pkmrf72TIJsw0WMY8QYCbL7bNEDE/Sg
XiR1jGlHgv3kprnTGz7WzrysR7APv7JVtUQRFKnE+OnpouedEjvJJebtikD2
R686M7UttwBPM6GbuEQs5GZonSYWZigvFbKxazbnNchagSe8WqfUaJncAAMy
MjwyYfWzU0nPOrEq4vim8KPbiQ0e2YtYiM4FcSHMVz9wJnj/OUSOyL0Wspgd
Gcge6GXN1l5q+dW1uAW3W09/AIn1GExmMROvnCXWIKYtKtrBXsxi/kjMeFZa
Q/bAa9XdLWP4dELHpTImcckzl5sZ7pbOmLAkz8ZkWV/CD5HkGyfH10z6GJkQ
yoo4vh7pIvzId2GHf4AHUlJHoCwC6+CpoANnqu8/F/rTeSCDymCMoAZvRDur
vy2TJJDVV+Lm3034lMxi0Jflh7E0Iir6UiLH14wXPduiWCJSh+v5aG+JWVmR
uaL/GcPDCfVMmB9xsaThPGv8o+ms8VJJX2Np/+pJ+tc/ed6og8kLSR5mCFK0
Tx0OOQg1HaeMTgITbBAFWEEHzqKADCqDMQIc4kf4vvMYymrsTYr6Hn0tDR0N
qQOpfkh3O2/IU7PGy3kmGrzk2ZkGe5E67KDoLjE9ePBPW6wWn7bgl/SLq/o3
qZeOf82uT07m1yfDVKm1WhfB0stf99KOuY9eV7mfXs53kF3RRy/kO4E3ibeK
NwxngD8cKp4Er0CIgs/jV8MvCCeB/39T5QJ6N359HAQMOMhga2tcx8FBikaW
hh3hjxx/6viDRwzAfDSycy6CQc9BeZh5G23+GWKBanDwoSBEd6QLQAEaAKq+
/yzjRVRGCRKUB08CK+ACMUDDPCOOba6SOBQBpnlys/iUWm1TqndILdM59e8I
pcPSioxLfwcz4JyMwmipMGr8OcG0Yd0wBPyZ4Y8Nf3IH6Z8f/ghP0T/IRHqB
Vpp1od2bWRlvXUh/G3MNu2CSXC2ZVBjBjFz1eq7INX7V63XqWuTa5pN/ZRe2
aR+QEZ/CkJBtFshUXjYyidcehoxdGXuaIAOvQ/wKzOOU1yn0XPyZof/CImAU
+PPDHyEGFvDCnyX+OPEnusvmdXlDuMJrft2cOfUfTmv4ZFJTsiSL5oIpaUBv
MjQlTHyCSarZmsuNNl9AkKi7Kx3sYHeRe5IhH7ADNYrsDDCBUcjBYwAEwww9
/FPYkR8wUIcf245IGXp6LoYCTAdNk1vFJse0SQltn1KuU+q/IGpIGwInvNIt
Xqs5LzRctF00X7TgQ7Qdw+RPU8OH7afSayOtqyLT34LbwHPI1a3JhS4RWIXR
Pq4yXoBFeLHrzAWvlU5k/CMwTGIysi0mZEaJ7XGRGLli9jiR2ClZYgepxNhF
gDB8tGnO6wLaAeYatIaNGq8YzqsZ4YV5dnjXXMxK3YfmtR2X13rm/diFt1qs
uNp03SVorcG2zJidhFr0dylQHJARlR04TWAdOgJSyI2I+ogl4ce2kQX8Eysx
CASdm1Q9cSACJ2bwVsn10CLbp5TvlPrvHjIvqq/llBdCLKIsAi1iLcLtfsrr
GLn0kUQpBKpkuoyTofAqwHj5Iy7kBOkTgqvdkW1UkW31A9keyRXdJHaaS4xb
YmnNErMQjMELoYvxWkd5fcX9UOfVJXdgbzLhdvqEWCLGXqis5fLrzddcbrLh
l4ZbL2DOQg7EjAyVEV4HT0FZFNY+xBJMZ2RGO7EW81rY6XnBZ6dWPj8yPKlP
TFJnqi/wCpN5YQDEGIhhcCHhVXBNZkEMidsyC2Bg/D6TrMwcyHrLaYZ+iMu+
/p+Li32I46+ICuqHOvPRyDgv+4M2FJkmsb1cYj9pXUyRmMkS5Ra2rfpFjKIY
SDGWYtjByLOE8Lpn9a+mJGYTP/wod1BPciqk6/C8dmPzEqY+aj3nHpC1Wnaj
+aormK0abrlQb0cGVIYMTywRvA4dQZ/CXIZ8EnF8M1m9P7k0lMCaVvX8mKDE
QdFJ3esntW+W3Dw2pS73w3/2ov3r0/R3pqW/Mzej8KKMQisyCq7LLLg5s8B2
tXkxM2TiYmboEJfdua4IcZ1lvBQnZNfA0A8PviYy8cEor+Bx2nJFSOywoYu9
L0lMt0Q5clxbE3ljRfStpbXuIJ4hpCGqibwxqnMuglz/viSBdx6Vhyie8NnD
eAvZdeRzqAwTVt1dacghJHgcPInZmTSso7uosgSs6dXOjUPSiEjqDTNslNy6
RXLj+JSaNG+U7pz6t75p745IKzIh/Z0Z6YXnZRReQsPGet68hBkepmboU1yX
hLjUD9doTsg+5kY/pZJfZG7Zw9UVncHDGRRViUkpUbVEq4XVur2oTva8mPuz
6j+a0ohczjSude4nHUgLw6wEiXUbltdxdF7ChNzW0x7Gf34vbiExxmZrkUB+
hsSQPRAX0bxCDx8gTkh61npqg/NDzswIOje+UuLw0MR+NZO6QVxNk1tissM8
3i6lcsfUYl1S3xuY9u7otCKT09+ZzcPGmgzFDEUy1JKGJK63f04t8AtzQi4u
O2bITnjScsLbhNf/8M+CKchcEn4+sgf9jJu3K1rBQwqKPiRmskS0sAfTGj6e
xCyxbS6mWiaxXoPIOaz2Y0hWbD3jQfwX2bGLb7ZYebXJhosYh2t9m0p5HSdm
ePQb6oQrw04tDDkzK+jcRLSt4MQBUUk9YpI6YQBvkdwkLqU25jtmhgiHQ01m
uIUmeZYM8yUuJWbQdQZn26KwyCcQpRtHvC6yJB2ZR1bUXNERFLUuJkmMpfqV
0TeX1bqzsE72FzH3ZzawJTa6A0kdg3vm9etHXPGjkXlt0cgmP249637c/Dtw
RUgMwQMtLMzitY92rvXUCedWPzulyvnRaFs1knrBCRsmtyGdKzkmISWCiqv4
R6nv9U97d1RakUnp78xKL7yAJ/mNDnHJnUuKhe5OKGVCrW0JWJTXstdGttUF
mTHeO11RQiYFDwTFH+CKbhKLdKQO0cU65Q7jrohszxvZI7hi7KJbLVZdbbzp
Z7SwcET6g8fCjuwNP/Z1+IlVYae+DD7D2taQiKQ+tZO6NkhqR52wQXxKdNuU
IEzKnVL/oSWNxRmFVtLOtUXuXFlEXMf9cUJjJpTblv3pbLpge5TxckXm0suM
yL5WkXlkD4FMy4rkg3LEFYtprkhmZysoqsGeDGJ1sjGIza7/8DMe7OGKCB5D
PybXOPUeKDWyGQ8gMXQxWCJmsfB9iSGHjiIZkgXhk8tCT39OnNBuWx0wc7VM
bhSfUos6IWJ8wMep7w1Ke3dMepEp9thVcK0UC8WMzGYudydUMqHPjCFg3T36
d9NNdf6zyHw3Mml83veBv66I4DG1ETn/+2k8yfZoZECG8RmNDPGeNLIpj5EV
0cWarb2EQQwjGMI8GZCPr0PnQoCHEwYnDkSAr5fUsUlyHDIhbVvI8BU6phbt
mvregLR3P3F3QjnDn7SdkKw+ubUtKcDbGcMD1t0jf+c3dtDvg/RHkW31RLbH
HdlxjsyjkWXtqmotd5DlqYirayKB7JaNrAFBNlFCRrJHHzJBo5G1+TSv9fQH
cQvuwBKR6mv8kBRy6DBmZCQNKq7xVROHRCb1xHQsZQzAqtgx9f0uFBZrWzPT
C8/PKLSULxiyBQ0+IFuZUGtbfxasbMJriX/InAtWzpBvjB/5QubIHnq894WM
q4ytKIq4iOxBFj0mPkEXgyU22nIBIzOGL9K8Ti6BuConjghP6lM36cPGZNpq
4qYsf2Cd/o/Byj78D/VecM67jQlv9BPZZpfE6Kcx+qWybyxkFzcrxsgmMt7L
aMIf25Ys2g/tntevL8kecEWMY0gdGJwxMmP4iji+Mez0PHLlQGL/2kld+GiM
nhXcPqVsp9R/dU99dzDvWbNVG/zTlGUKGCwN3hWwDls38DHdvs8tgazSQqNj
jdFr9cMR8r3ihz+9bGeQHD/YUHZbJEay7tGYnK4al0ASI3oZEn634XkJ4/Pi
52Y3X3M5+vuUsMM/hp9YTZaeEofUSurWKDmBBgykwWodUkt1Tv1rn7R3h/M0
yNYJv6IBg47Gb//hnqXcIUSFdVuB9Xd2rx4Bi/Iy3nHxtdqZL2S7nXOZaelD
JEYS8v1Yqrq6NtIWmhwa0c4wlw3rlgtkaGTI9rBEjMzkCoFTi6ueH43RmMJq
gDkLHogo2D31PU1WS6UzXOyMiX+LTiK6FxIrTs45S17BsGFZHvj3exxWzsH/
FTcvzXJQMyHLlzdqodG4xiivfvgapY0LwlXZOU17QXhN5A3W0fiC1UMSQloS
b8QoDWSI9/Hz7tbdlR5+9JuQMzMwbcEGMRRjyOqYWqIrW25KJ8tNs2i3WmIN
WWQFw7ice9pxrsR7BUOc1fKnYd0T9zGjt6HjN0Jc5J/QXAfq/HvjHxjNlGla
W2PcaTqzyR2SaG1KI9LR4I1AhuDRcOsFNK9qiYMR3VunRGIcBil6luQdcZZE
PgtpPGvsfhZSX3j3mIh9eqB9z0DC60sdmU7Nz9zoz3TmtpjvPCVtDCHm89E/
lOPno2kUQV+D3Ag4pbWRxRCkkekNHyM6YpRutewGxNU8uSlIoU+NTS8i1gPR
pNZQTExQbJVJnH/Uzhf7vzB4/ay2iuuHrKgHosRdOqU7b/+HhJbfjqbb4ynL
Hq0ccozfL0hEEX6W02ptUBzrbmCHBockSfAFX9oaStocIwjDnNI4d2hakQWc
zvrMAptp5NtOr3j8ljP6iWa/wxIm1qeSDSezXEid009meXcro6zodYbksij1
fukLvam5L179kbTvHh29TnTKJ84EuEPFkqA4etEOvaigTCq9uZByfyHygazS
KdAmuONH36zY79WqUjh6ONTJ/LOB8v2LTtA1pVP0W+f4CUfpahkbk7Ue6H5O
32P91pnYzaT2W5exSbe4X2AWWmC+omO+x2qj1kwOKcmNXFTAwLEzaEx0Zyk+
/VZd/CMhJ/EsvBR+EN7w1aLjsyMTno0M+W1LMRwNHEYcYRxz+UK7dOmmYRlZ
b9D7ib3JGNGLmoiaVEyOE47SaREvUkdsUvdkUgekexT/ZN1oWrodvbYxQb7s
0Z/A/8fOeAq5KWdkWPin7Kwb35nufWd9IA5PxB8AXh/vAb/LlaKTb1bqd69W
89xeEWQ3ga3vP977bxwrHE8cYRxt8rkMcZs+6R59jI51HkQwSlRuumiYqgzu
lz9SD6Rbgjt2+vgTqfnUms+rQWxw/N6eNjthmM6bSYorLek1lrvw4sg/eG/4
1S4XnXq9zLDbwV3v1Wn8+KMazycFvVr+wYuv38/9LgCHBccNxxNJwPkxQ+ct
MYXjqWpyYjImChf3cyfFbgDusj/Lf5SaMUPq4KQkabPj+L7ld/J03qBVfPpm
J14Er4mfhfeAd4vfFLCulRx1s1Lfu+Edcuo2fNwhkljinEpoZFDZ028CITQc
JRxDHFVyDbN96bKPO9DKjJTUZ8SkZj9jn3LeZp+V5646r0XNj/MyXuA4O+GW
9uWpbnc8Zp8Ypc/dTO+5tA4/F+8Kb/5i4JzLRadcKz76RvlBt4M+zq6RkBNT
/1HbqLxBYc8nV3v5Zfnf15T8bev7z3YGQmg4LDhiOIzkWnT+ySnl+nP5Vs/S
3Z51RiY1+RCUILVPJ8Xu5ODcpio/1BY5V0X8k5sRnHato4xPvou480bi9j3o
6DXJ6/Di+HGU1CL8LhcDZ10uOvlasTE3Phh6q3KfOyEfZkfF5cTUe9g6KrdP
+LOxwS9mVX65pNzva0sgfvy6o2je7sAn35P7/OC44W+egbvnuHe38c7qMiAD
I0VNVkT3FpS1+Qjff8Rtc7GfdbktyFfyV8O/eUVLu0LVwU6+INz7zvzi9oCr
KaavsixSC/CrXQqccYXAGnu9zPCbFQfcDuoOM7xXs2VOvZiHcVFPekQ8HRHy
fEq1376o+GrZB7+vK/Fyc7Hn295/tisw71tyJzQcKBxA8ime/f80fMzKrQ4q
gGQpyaZnwMRJPeaC0vb6UXfrc24Jly+T9BecapVO3SlbXbhveCHf23Ylfdll
+Lmc1BcXA2dfCpx2pegkAqv0CDjhrSq97wR3uRvRFuGQ8IqNftK1xtPBYb9+
Wv3FjCq/LaiA7AGVvdxUDAkEQkNHs6jt+bf1wXztbj++dgyhD1MAaVvAuKrJ
sSUT2SDm+wB5e0QPcL7k5g1Os0rnhj4rMkwEfe0gs0LcSx8vTncYWchJzYGs
LgdOvVJ0IoFVauSNckOQ4SGuO6GdsiNb36vdLKde3YetohER8/qHP/skBF3s
xezKLxeWf/VVGbLj28ZiaGfPt5GdZRg1dqdc+8ZN2s3QfOzOQ+nIgGRGqpSM
mMQ9YJ07lpqo/QFwtlW6sHPi839XJrFFxRKO6Uu8GUYK3QqyQrq4WnSCBavs
UDjhraq9EONhhmhe92o3uQ9eLaMfd4rM7R3+dFgoJPZ8WtXf5lZ6uagcRVby
1cbiaGdEaNs5td2BuRzckz2Oew8at8FSd8IyiEjWkQsjtuEguy22Y7dZb7l5
gPOHnbyeLBPM105nYrMeCxPdLnAuJzWdymrS1aLjrxUfc73UKGSMmxUGImYQ
cYV8CDPMjm6F4et+vToPWkQj0uf2jMgbHPZsdDBmsRczq2CCfrmYIltT8vcN
xeGNVGgWtWd07xJ2B3j71qz52XVOoSMBMjD6Tt0Ukt553rF9c77BST3OzM6E
T9s60J/dA61ty/h+c/P5ro6fc1IzyGbiRafAA68W/ZTCGnn9g2FoW3DCW1V7
Qlx3wjrerZFAwkadRvfr13nQPPpR+8gnH0fkDQhD6iASm1oVrvjb/AoM2avV
pcg+ffDGzcVecGq/cmpMcfp9+/3f4dFJ5zvjrp0B8gas7vtuGzZ3VveW9Z+d
jM8J0eeOnPI2jvP4fqmf892lZ1JSMEBLVlffH3etxGgLVrnBNyv2R8zAzEXE
Fd4+OzL+Xq0WGJYtXm2jEDly+4Y/HRoKif06MejF9KqYoJE9LGSrSpGdgpnQ
tljUnm/nm9xJuwUZtp4x7gspfSvPTCfAuEMuKz82TDfvyu0HOyfBP7LFrbqn
rcA0i77b6YQUMcDJlqyKjVVhDSBOWK0HEVdoJ2KGaF61mlm8mkU/ahOFyJHb
KwKD87ORVGJTqpGs+DlHtvyDV6tKI4EwoSHt/7bF2g4eaeRXAW6n9+5p6j65
jh2Nn7rQcW5I7djm3gbni50HPo3g62wbLe/0LTDNoKQ+k0hRWRUfc63kJ9dL
c1gVBtys1Jc4oSWuDjBD0rxqN82p2+B+/dqEV0LU486RuT2oJQ4LfTYm+NcJ
Qc8/q4oJmmQPgWxladLO1hVnQqPUinFq7z+X9mz1a/dPdy7KXuHqpuGs+F7q
cvnJzgvfn7QPO3vZWRet9zCDvr1ptE8xUpOuFJ1Ath2HrCxYIzisgaRtwQmr
db8d3IWKqx2SfHbNlgiHOTH1Ca+m0Q9bRyEiooURSxwS+mxUyK/jqj+fVO3F
NNrIvqj48kuKbNkHZOd0tDNLaDa13yg1vkd80efafrvOvcVF2SxEFXXWr/L2
7juK0m2F5fJg5xOfk6AXTRXKbInOLJWRhClwKk0UEinIqtgY4oElR3FYQwSs
W3DC6t2IuJA0iBnG36vZQuEVH/W4Y+STbjWQ6vMGhj0dTrvY+CDiitOryMhe
AhlpZ0xoJRAdbWqSSXJw9i7krtvE57fo69CDwGqaL3ZOfApBDtHI0bvkFxGA
GCMbEyU1iW4KP4EZoC0rNKzSI24wZZUfSDJG5T7MCam4OiNpEDOMir1XqznC
vM0rLopExC41SKrvH0ZSB5UYggfJijOqvED2YMgWlXu5tCxBtpIJjdgjo/Zq
UzFbblveJ4rj7CR8yj7yhg3lpXI+TBQ5FKQ+c5Q/+IwEjSWzcJb8goKRjGmy
QkoYYInR1yArwCozHHOWBKvvrSq9iBNW7wpxkRjPzBDNC2GjTqOcmHqEVxPK
q10kIseTHsQSMYg9HR5CJVb9+eRqpJFhImPIFlBkS8qSdraCC43ao0Vto0VN
ByexcxDMd6ERkArUyonPIuiA6MbRn7JeQQLEGDkxIVFwUsQAAWv0tRKQFfVA
FRbJGMwJg7rdscSFpNEGZkial8YrlkR6RA7SwpglMomNpcFjCm1kyB6fE2Qk
MS4qT5Axb4TQkPZlagRcMSE3bpWUnYzPQdD/YkdGLf8JGmh6lvNZ/PX5T6eM
bExXJEyclCQrAmvYjbIOWMwJZXERM4yjzQvhsGFOTAzlVfNhKxrpO9EWhlTf
P/zp4FDMzkRinzJXpI1MRrawPGlnS7nQmD0yanDI9YyaBE5npxBk9cLv4sdn
8mVSTnYqRAPH/FfRqeorT5YYaZgEqbESKSYr4oEkXZQdIsHqZ7Ut4oQQ10eW
uJA0iBnGWmEDvOqpvDrSFsYscSAN9qNCSLaHK06ijcyITAgN0XGVTE2WGwW3
kYPj7Cx8CkGJo3vxozTZrXxxzFdpLz5JY6RgYqSKKaQkWVEPNMDqRaZjFjOY
uEjSoGZImldzyqsB5VWL8GpJR7AOtIV1p5aIQWwIldgnwSR4wBVZI5shIZtf
4eWX5Vk7s4Rm2aOgVtKiJsBtsMAp7CR8cv3mXtJBM5Yrx3yW9rITVUYOTMz6
ENQZqRIKKSIrBqv8IBLdBawqvW4xWMQJPyIzlyUuZoakeZFwKHg1JrwwgiEi
Pv6wxpOPqSX2C88bRCU2kkqMueKUas+nmZAJb4TQhD0KarLcFHA2Ox3fJh80
pUOnlTdHP8v5shPMjDgmW1AKKWqAlqyshmWARdoWc0LEDElcthkibDBedRmv
B4wXIiIiR1eS6oklyhIby11RIJvNkc3j3iiEZtkjp7aqlC03GZzMzsKnEFR6
n1riAErlRjBfpbymRMfESGBigiLZT7ifSVYGWL2tthXUzXJCS1zt6NhFzZCF
DRIO69u8WpCR+VE7Gjm6cEvsL0lsNHfFSdWQPWyVIeTP5ciIN1od7eUybo+M
2kqJmgxOZafgswk6IG4sxg/gBK1MHL1Kffp4R31qYKRjYoJykpJkZcMa4IAl
O2FnS1wsaUTF2c3LyQsjWFsSOUgLQ6qHJbLUAYlhFhvFXZE1MmQPBVklgox4
oxCaZI+M2gpOzQ2czE4iqEOkZTq2r1mf6iUDshk5MBHrU0kZZYV04QqLOqEi
LmGGtHmxcMh53Re82tDIgRbWjVpiH0gsjMzOTGLcFUkjY8imW8heMGS0nelC
k6l9xalxudngBDsbX3Edn8TRcHhfszQ6NI1LjHhvEr5nYTKRwmyly8oJi2UM
0raoE2rikszQChsNybAMXg0or+YWr0cdrBZGFjpgif2ExGi2Z644nmePz2Rk
ajtjIQRC06gtL6PKzQb3anVJAztZfRJE/dgWHecCwknBvYqNZaXryGZkEpRC
SpWVNyzWtuCEGLhIhlfFxcyQNi8zr1gS6UlE7ExbGLVEK3VQibHgYbviJBdk
rJ0JoZmpCbnx7iZZpc5Ow0cJ5oOCi3BUNE4RaZg+EZgkQRlJmTywYj+ygiFg
WRmDti3LCW1xkaQRGc/NsDkNGzQcEl51FF4sInaiLcy2REliLHiMdUfGQuNc
p9CoPXJqZJF/mUpNAaexK/W7hm9NSXHA/SkdipBPsTEGQAYpqZh8knLIygWW
7ISauOKV5oWwIfNqVPNBs+iHrVikp5GDtjBqiTR1MIkNpRLTXBFx0YlsjoTM
KTRBzSi3FVKPM7Fj5YLARMQAxQOQLCUPTDIp0aosWbnCYqMWzxjkXD9zQsQM
W1yqGSq8MCyrvOJpRCSRg7aw7tQS+/BgD4nx4EFcUSCbrCKbSUYzkkCYN3Jq
L72p+QQns1tVyhOBJxqdDgdkM3JgcgpKIyXLyvJAD1g0Y+hOKMTFkkZsNjdD
3rzq08UNBy8RObrQhQ6ROoTEhlsSe8ZccXyQgmwaR2a3M01oJmoe4GR2Ej5X
Fq5QvAHJjEyYbFLDJFKKASqyYrAqazZIYdltizohEVcHh7js5uXKqyXn1d5u
YcQSWepAsOcSs11xbHXWyHjCdyBj3qgKzbZHRs1KI7bcrO4mwC0v42BXxhOH
CY1OxwJkYGTGRAQl9SmHATJZ2R7Y75YrLN62qBNK4mqbzZKGYoYsbLjwQqRP
oJGDtTBmiSx1UInlWRJTXVFkD47suYqMe6MkNDdqqtwc4GzRKSC00rkodAgg
n4xkTEJQTlIWrIG6rJgHusISbYvGDF1c1AyjW6rNy8GrafQDmxeNHKoluknM
bmROZNOriARie6MqNJWabJIaOG6VnJ0LFB2NqiAjIzdMQlBS9tNJcQP0CUsE
QtUJeYYX4tLMUAmHOq8WJNKTiMgiR2duiSJ10NnZltgIqZFpyKaoyHRv5ELT
qHnITYDjonNCMaFR6bgx0jDJgvIgZcvK9kC7YXnDkp1QE5dthrx52bzquvGy
W5iwRKQOWWIseDBXFBOZlfC9kFlCyy81BzgHFxMaD0A6IwuTwfo8SOmykqOg
AZbUtmQnJOK6K4lLMkMeNrx5iciBFiYssZc9O+uuyBoZyx5mZGo7k4Um7NGV
mhMcYeeLjgmQPDe5YZIFJbIfJ8VbldStKvbTPdADlmhbBnHJSYOaIW1eDl61
FV4i0rPIwVpYN0fqGBhGru4QwUNuZCLhC2RTq1qjmbfQDNS8wKloXOiYdWQz
cmByCMomNUgipcjKAaunAiuIwRJtizuhQVzgFSuZoRo2nLyac14scogW1pWu
JRJLZMGeIhMSs1xRRTbBhMzpjXJ0dFJjGVKTGweXT0D+YXIj5TRAW1YMVm93
WN1sWLYT8gyvi0uYIW1eHryacF4sIralU3Mnnuo/5oOYIjEaPJgr8kZmZQ8D
Mkc7m1nZFpovak65eVqcByM/MPkgxaOFIisjLGfG0JxQExc3Q7l5WWGDhHkf
vOQW1s1OHbrE5KxoNTKfyGg7MwpNbmpGalxuXoDcGNmY3EgNciE1wEHK0LCM
sAxtSzihLS6RNBzNS+J138mLjmB2ROyoWqJRYrIrikaG7METvhmZ5o1caL6p
cXBugPxi5C4okiiMpCwDNHoghUVIucPSnNAsLrpmKJmhFDZ88ZIiB+dFLdEp
MRY8bFeUkH3qjkz2Rge137yoWeBkQAZGfmLyIGU2QKcH+oTl4oSKuETSkMyQ
NC85HGq8+JJUrIiINHI4LVFIrH+YNT5bEpNcUYmLDmQ8gVje6OxoPqnNq3jD
S0cqIx+YhPV5kXKB1dMTlqNtMScMt2BZ4rKThmyGaF48bNi86li8Glq8Hghe
SuRwWKIuMR48hCtq2UND5uaNmtBYU1Oo8TTyRUUTIz8wSR3KBymDATpkJWAF
+YSlOqEuLpI0bDNUwoYIhyZeLVReegsTqUOVmAgewhV59jAjm1TN5I1SCHE2
NQc1MyCLkQ9MkvX5IOUHrO4OWHIgtNqW0wnN4tKalwgbYvHQyauVg5dmiTx1
2BJTgoeEbLR/yJzeaBCaTu3/A02f51Q=
               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxVnXf81tP7x+/7ft/3be+VTUIKDaGQkqQdkUpKadiSFYpKQ0RGw94kJLNo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               "]], 
              
              Polygon3DBox[{{1693, 1296, 1052, 1690}, {1700, 1352, 1050, 
               1689}, {1691, 1186, 1351, 1687}, {1686, 1350, 1186, 1691}, {
               1687, 1351, 1273, 1692}, {1692, 1273, 1296, 1693}, {1690, 1052,
                1352, 1700}, {1689, 1050, 1350, 1686}}]}, 
             Annotation[#, "Charting`Private`Tag$36737#1"]& ]]}, {}, {
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             
             Polygon3DBox[{{1695, 1009, 1696}, {1696, 1009, 1697}, {1698, 
              1009, 1699}, {1697, 1009, 1698}, {1694, 1009, 1695}, {1688, 
              1009, 1694}, {1699, 1009, 1701}, {1701, 1009, 
              1688}}]}]}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0rtOVFEUBuClM4zcZhQUVJgZY2HDJcRopWiNmlgYC4TOAmdAZ5hBuXoB
NFraqDTGBnyBQV9AXgAhWmsricoLqN+JxZf17+Tstc45e5++Xb1RORARL2nK
RCR5vSnibSrilHyJcRZY4yO77HPYw4Nco8wLvtj3Xr2uVzYdUVS3rM/K39W/
FA5GXOQWc7xmk8/8IqtHP1eo2HdOjztySv1hXZLLTDLFXe4lz1Jlmhp1ZrjP
A2aZY54FFlniIY94zBOWWWGVp0k/M8+b/UxOq3vWE/IIfbTz03tv0+AVs4xy
gTx/fPdl+76pN/UYks+on6wb8ob6nBJXGSDHb/95hw+8YZ4xhnlnbkaPovzV
mdX1Kch5eunhJCc4TjddHOMonXRwJDlLcmRpp41WWmjmEJnkjmBMGB0+K2rp
//fmH48cOGU=
            "]], 
           Line3DBox[{1700, 1690, 1693, 1692, 1687, 1691, 1686, 1689, 1700}], 
           
           
           Line3DBox[{1688, 1694, 1695, 1696, 1697, 1698, 1699, 1701, 
            1688}]}}}, VertexNormals -> CompressedData["
1:eJx0XHc01v3/FrIaekgiKdKQmWhQXhUpiZJCoUEDISslyUxJSCFJ2WnIHplv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         "], VertexTextureCoordinates -> CompressedData["
1:eJyF3H9031V9x/GIwoI6JYq/Ajow/mCHqFWLcLAhghhE0YI9YpyopIqcOhVW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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 5.484143323551816}}, 
       PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], 
         Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ
tooIDYmsw4yx741lxuzkQevDZ75/wPeHe84999xz7v56v99303lv6wtCAgIC
zfwiyC//Vy/qHRx6I90M0vm1nPikSQga35Y2MGJCOLCjOfsKEVsrZNTv7ZiE
9aKo7IUgJjisxSfJPm3YELb6lAuFjovjdWS5KiZEp3d8cdpFxsi5Z4uyV+nY
vrQu2GGBif9u3PB97dqOF4vkm4XidKyPTpTXBAsVI6cimtdQ4KynOKHwigbr
XbWXEsJYsNimyI19T8HKKdtJ5/002Pp3Mh5/YkEgavaThVkHzN4zv/39dQJB
xyU5OxZZmEiMEiPUdKA6dqnEiaAJWNWPPvDfy0Yy45yvg24nCM31Xf+unYBP
iOCHsyFsCC+tLzyc2Al74e7rdsXjiF1ps232IxsuP8ruh3I7caShIdXv2Dh0
1TMCdv5iQ1Ss617V7i7sfXTD6QBjDCbd81JqhhzYXWozKAzpQptFwM5P4WN4
5bfKhHyNA/qFA169ZV2QWEthDimOoYN5ZoN2CQcp098YRfQuKFyQ9n9cNooX
Ub/LLaY5YMcWjcav6MYDr7r5QatRUByTpjdocfFUpbaMotGNVZqvb+UyqPB+
IRlddpkLXynnhbx93ZgrkF/Bu0lF2D0pPakcLja8nZA+adUNy3l9s4x1VJSb
xfnpjnHR+UwQrFPdOPnuRKqDy1f80VZpktvAA/ue/RJXjR58d846voY8AjfN
kd5+RR5yVQ6yLs73YIVP/oymyQiOOSlOxyrwMPFFVc/0Qy8su2cR8XoYNtLW
G43leTgjFLF58Wofuv2aTwnJDEPnCMN/ZB0Pj4LyHe9t6EdVUemZ28FDqOfu
FfWX5SHVNdArpaEfUu5KymNjgyhZVTggspaHsG7R2f5LAzhrezX1u/kg3Hbd
Eo6W4UFK0uxnz5JBvKg0OpqUO4CUh4IJotI8OCqrrZBIHkS4/4ukWLEBnNbx
TAyQ4sFVyTmQpjqEKKUTk7mu/fA//11+VJIHycZbDbXFQ5jV4Ga/IPThKZmi
Z7qShxLObPUPw2EsOm35tmd1H+qalDmJEjy4zP5c0Vk5jE/Rv+Q3uPXi1C1x
2zFxHjTsyh8lGo7gksKBNN67HuQceR6msoyHlOUzPiHFIygeOZBm9rsb+t1/
/F3EeFDdISFYq/YV5Jaskmfoxp7zW4/HifBwlywekZj6FYacmhKv0C6ILlOR
Khfi4fCZWWa8CBVzufuWi3zoRCnnB7lHkAcfxj0P0h4qvLhk7QRGBzL901I4
i1x4ahrfifOh4uNUlpz86g6cTBQO+fkfFx8fhOytYVNB2t7FCvlIQea08jfz
Oi4WTWeO0M6PIqD3joTceQpoy6/w8iK5iAzbvdKpZxTxFvctK0Uo+Kpv9lTl
OBf9XXd2BJiP4XrqaV/1nHaopLbLf5DmYltc25KQkjHQzS6c0NjfDger/564
9HOwwz5J7vX6cbRvyonjlJNh7BG4SymDg/jzUSN6d8fhHjn2z7VxEvwj6zfN
u3EwlSv/7DBrHHEXy0oNREjY72cYPqHOQXHmL2+FYxMoaEsQcVzfhq5touGs
aTasVEsWiYUTiGGEadHVW/F9jcXRpR/YMOMlKYVJ0BD5TjUjX5OIwFeLEnv5
790/RPLEqcs0zHdQ0803teDNdrVv0fvZOCsbruH+hc8XDilMWKwZx2VLt84s
YyOELlHbtZ4OgYOzl1oHGxHskTHk087CwuXtk++u0bH2TLDrr7QGnGnkmi1N
YiHb5pfvmlY6XGOiPVQt6pGfXhVV7sSCCOlzmPSmSbwWtu5v767DNt5R+q0t
fF5Z8uKq/SbB3Khe8cWsFr22wvfd2EysyzNoVG2cROHUhJ/83Rrovr716mwx
E+xCOwGXdQw8KVjKc91QhaP05/7XA5m4LWLHzbZl4M8XskQdjYAjCjYP5H8y
EDRl/S8lngGCstr70vcEtOxp6ZYNZGCNh8EKwTYG/96nXj4UTcBMkCjL6+ck
ljnwj1yEieo6hfXhlwmIZu84qHhjEnomjS6Ve5gI0FD642pFQIFMmrnybzrW
Gc//5+nDxMbkh3ZMYwIeDGlrhQXTcX5k8dPf2UwMhZ17JqZHgPdgnrTeAg2+
/2ZQ+7uYMDV2uFikTQCVoscxuknDulC71FJhFpx/BSQ18vu/IZ0ISlxCw+/6
QTMZfRbKxT2eGOwl4DnNwnr/3Ql8Ya21ET7LQo/Q9djhEwTEDSQ37Vs6geT3
4g8TolmgOi60JFwhYO/bpNmY6HGE7h+YIZWyQIhzWqXDX+8HZ+ZzNclxpOju
ZNWOsNBge036TjEBgXXlRyUSxtBja4sgUTY2bjrAcqIS8INwScJAdgzRf33W
E9JiY+hRyb1ImSostPnFvUwdRZr8xO0L1mxEabMMW49XIZJpInFq4yjUSwg3
Cq6zEeMZrzwVU4XC3Tu37n1JhY56xvRoChuegg0fS7uqkPVCaNxZnYrNq3ac
liSw4VicdGBcqRpCTky5c3xOizybD/Dt4o+rID98N7gG74Knn9s8G8Ejo5Zp
Qw4bK2v6G19SPuNC16U5ucFhyLr/znAV4mDVkxfdedJ1MFJaH5W+bhjuGvOW
3+U4sD1tdanh4BfEbzgi2WEzBOHC1ifft3PQoP79otuVenB/nVXNih/Es5iX
Mu4HOaAhPvjS7QZkxQkozpMGYP5J2uioAwddsVo5VvGNiFuMCi8XH0BRuP35
V1c5iJspm/8ruQk2B3pJrQf7EamX3BcczsFq7n1bvyfNKJAvJUvf7MP8Rh6J
nMgBq3etfMTDFpTUxEheqeiFwfhtt+xcDtx/lW81CSVCdFeJ1KtvPdDTjXr5
q5IDxs/OSr3LrdDf7Xg+Ta0Hhzy3Pehr5WBCSO0h63gbbrtIeco4d2Nli6ug
6QgH4vpuH3u2k5BsukWA8qgLfuLsYf0pDgKEZ/sdJMgQ1OQF3K/rRHAMi1W2
yEGoiZEzaYIMkefi1oyZDgQmNIwRJblwbeMc/OTYDpkeeaFIpQ44WFD+vqbE
ha60meDp+naItV6n8A5REO84v6tMmwu/LKrACU0KGlUXt96/2g7jD05f4ky4
iNl3taL2EQXKKtLB+5XI6C39HsVz4oJNHnrcJtUJ8cePtYRrSFBXtLXNDOGi
iOTBKeP7i0jS1njBMyTEJDf9fpHGhepM0o2E/m7E9/aZMKfaUDHZY/m7kovM
tguCDmq9uLns7rRLaBvMl/0Ue97Hhbt8gPsBzz407DLeJiDahuJtx+eT5rjg
Wd3yFn/Vj6crE66cjmhFkJR12yBfP0/72v8RHRhAwK6PcswFIq4x4kw8tXhg
bPnWdkJ0CJWdLwY2eRPxr4L9lMUhHuBtfImoOQzOmwBT554W/N7hEe51nq/b
pOnfesdHsNA5mTKq34I9Hq8eDgbx8PJ43QoVj68wX+91nxLRjBWfytPjHvMQ
u6zDVdqMinMrT81rk5pwzK3KKLqAh2zZ0LGuViqiZBoKWpc2gXiA09dcx4OH
7q4hMdtR1Cy4FpjtbESgiwHn8AAPy00sM3uGR/E6sPrJ0MkGLG9k9UlM87C6
8c2qi25jSDW/VHXTsR5/L1r8XCEyhV8zx+70MPn+TehudrT1F0j5r087KjeF
dnJJ8IGr4xCRi8xP1qnDyy574UbNKZxpumfU/G0cds7EKPWZz/AiP3UPwhQK
KrbqBvlN4Hc8WUPuUQ3sVtnmiktMYUl3ll586wQCKUEMtkYNbNo13Ot6eZC7
fSg4YTMNLelf+owjPmFfTVZdxnMelkpEbIsJpGHivc6b3oJqLB8XjU3x5IE3
GKYWR6JhpdMOcwliFf6cibfO28mDbOA++xxlOtKeE3PV+NyaM1h9kMjXf7tN
rNwhvl5N6P/jeZb9EfJF683nvnAhJuC/bW8THfE0em8DuxJrXhJ6N0ZzUb74
emu33CTonJ0HLagV0LbzkzU/wUVjtL9h/pVJPLbaJJHaWI5jeTlljjJcXBA7
9Vdz5SQC1FQYezI/IE9r+8yZXg4S/87vMRBn4EGS8p6T7mUoTFK5vzuFgyvf
P6csnGagtupeUuL6UuQuvi7m2XNg+Ujv+5ZXDCiSTh/TqSrBTeLT1Vf5vPIj
Gfa+m2WA4eb8LGh/MTxNJQsLe9lYe5JTnr+PCb+ouB15+W/hVOjRl/WYjZtz
MZXrYph49MLHwG2kEBLiw1p7T7BR8XtZ1kI/EwnkWruYZXnwuiQYcE2cDUp2
8ch5FRZeNVpvphBe4j+HgAyjOhaqz3mkHPZhodb6ivh/3zIxZSaeGHSD309w
x9vKSr7OLGmoy96SjNRTbatMB5kwH7D0fljOgmYL8XKR1lMQ/QeOJe1mQpBo
aPCBrz9Uv9uJzcfS4HnO+YdzMgMKW9UUdxez8FPgxM17d9LhKlcd5jM7ie6+
0M3rilh4qt+iW+WeifW8R46ZxyehURF24K/XLBzusjeWf5qFOomrmlU5dOja
jLhzs1mYcon8s7nnOdh6lkkxf2jQrjnqxXjGgrCNWGy24gskZc5xO61oCGpf
omzO9ytvaKU7w91fIjJk5IpZ5gQ+G+HI0jgWdJVlQolvc/CVtnYunDuOh5O1
WTqRLGjMEoPfz79C6n4Vw+0G42DOmXfW8HPaNdGIC9q7X2PlvDqpLXgMWRnc
8MrrLLiIHLyoFZSHN2vvyrVVjWLMt8hSyYuFXqMXm3Mr8rHa8/2u4J9U/L2x
umz6PAtHZP2PJs0VYNlPz3WC26mwXTdjpXOaBaU8e9M57SLYF/kkPK4cwfYz
G+O/HmVhTjy3vurCG2zTabv3r8gwlj4L+rZoysLIsBB9/uhbPChXi440HsTK
5Zz++B0seOqkp32mvYXXKV/FQPt+uNDd3qSo8vdzlZHL3pB3cL+qoDNj04sK
dQPSGnkWHpebDnhKF8NovkzY508P+lt+DDpLs5BXrfXB+jkBJutrh8wzenA7
/UNLkQQLN+rFgg7Y1uKJ4POiXXt7UNEk8FlElH+P7JXKpyrroX+HfexHXzcm
Hz6guS4yIVnd1M8mNMH6wqSOsXc3Ti/d69L8gwkZ5jHJk0FE1OzW4OYKdOOv
PmWbXTNMrFo2Sd2/lIRLh8Js+h90YZr8Dy+P7xeblgeFvjNox/L92xQcpLtw
42mstSqNiYz6W7esHCl8n/S1KSehE14uwq/zR5hIM/F37fLrAF1k1ZDKik6Q
z96VM+zj5/nfIlVOtzshTA/L2RzWAfHEKWIrhYlSHV3VqPtdyBROCCAyKFA0
PsS4TGRi9H1OenokP99cE7PeYEnBlDfhiWQ9E+QtPlPpt3qw6VQUg5beDrm3
mYtV1UwcL7kC52u9qHnnrXmAQsZTd58j18qZmLhpmBrl1gdW44bhgUMktPi2
Pd/J97vHt3ublFr1o9VhzDsnoxU2SWHai/lMrDZvzDhtMABDtpLYOnILVv/x
le14yYTnM6bQsMIgQlWyH67l6wY3kxBRlMGEWdYSeup/g5h6k2voFNuA+KbY
l49TmLBPWJszNjSEg/ZpFcTURqhwGJ7UMCZ+fgDprPAIFAO0zgjfa0JZes8t
9YtMqOSl7FnCz293LrD1r51qxhNpSXXfo0wofDTbumULFelnff4pFm3B7Lnm
gko9/nxinkS2F1Ox0eltxNuMFixea7AWlGPiqUy8307TUdR+WXKUtZGI2/oO
Fy0WGVjl65Qb1DqKCOXJ4hvRRDS0+Ok/pPF5WK0Y1WA3hscLMru1qUTsNy0Q
6yQyIFBeKLZzbAysDyubYpRawVA115MrZmDDVuvDYx7jWPnMxo9t2YqQx/uE
z/J5I810PESfHYf2iSO6Ti6tqN5zrv1VKAMZ1o7GtiETWHgz9rWJ395A3sme
dmMgMM1F7KAIDVdnSOJfD7dCO0Ytf88RBo4cTguve0BD7vIWC7mNrQgXiXCP
1GUgQOpjHVWajg3iBQvvR4g4KHU/pFeWgXuDdrZ5T+n4s/Hc8vy7RCisuGi+
bWES68xLPDX5uUj+eq1ltjQRa2C7KXRiEiuoasv+eTWJQyFBN8ciWlARmH21
p2USBlb5m+5qMXCz3ltVZ7gZyXMlcXrv+Fxce6j6agkD/9//1f8Aa2OKuw==

                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True], 
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJytnXdUVUfU9ikW7F1jbyj2gjUamVHsXbHFXoMtdkWjxoYdjQ2xC2KLKPaG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        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJy1nWeUlVW2rs+4d4w2k2y7W92FoIIZkFjkoCA55yQ5Sg6SgwICoqJEUVHM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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxVnXn811P2xz+7bFnGWoaytSGFLIl2u4oopbTaSYns+1IpZY9RsmRJhBnM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               "]], 
              Polygon3DBox[CompressedData["
1:eJwllMlvj1EUhu9Pv56NFCFE7EQT8zwTU01tTdFQNZYGIWhjrFaLGFvz0Kga
Y6aGkBARf0ATG4uy8BeQWAjdWnhe7+JNnnPvuee7Z7jfwKqasupuKaUSlKHd
kVJlfkqNuZT2wAvRfuz+bBbDa1FnXkqXsNfBm1Ee+wfx3wIvRuXsFbK2BL6H
fmF/Zf8+vDXse5kY2+CT6Bt2X3xOwRXoC3t12KvhIegQ3IrPUHgKOoH9G3sq
PAkVZF6bHI7xPxY6Dc9AT4nXgyRnwsvRZ86+QWXwddSbvef4tMHn0CDONqPz
8Aj0Hf6BRsIvlI98Of8SPoJ6kutH7KPwM/Q+Z592eKni5fuby+Bm1I9Yb9EZ
uCRc20+oFF6p73H2BnY5fCwcWzU6Dq8I310+8h2LBhC/k7VxcCOay9lerB2G
p6H2zDWYHq6paqseroFnhWtTwdrscM7KvRBdCPdYve7Afz28Icy1fK8SHhzu
pXqkXikn5aYanoVfhWvVhv2HO90M1/o19i34MfqZuWZP1Gv0IXMODfDD8OzI
5xG8NzybG4m1D65GDTnPbA18FfUhn2LsFvhA2Lc7qg3PhGZDPWiCd2oGMsfY
FZ5Zza56pt7pjrprF/u3wz1SrzTji8IzqFlUjVXrOeFaFnCHIrgeFWXOSbmp
pqptKfEvwtfCd9UMtobvqLvW603Bm8K11hurCq9pTzHrVPtwLOV8BZ4X/vZf
9ueH34zeThf2MHh4mDXTmu3x4dl5gD0hPHOaPb3BVfDE8J7emN7agnBs/RP0
bxiD3uU8g5pFzZxmT29Cb2NU+O3IZ3R4BjQLLcTfjn0nXFv9I+7CO8J76ol6
8w9lA42f
               "]]}, Annotation[#, "Charting`Private`Tag$36928#1"]& ]]}, {}, {
          
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             Polygon3DBox[CompressedData["
1:eJxNmF1wleURx088775tJilt4IB1qgHaai+rM6XeAMKN2KlyEehFR2+qjg1t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              "]], 
             Polygon3DBox[CompressedData["
1:eJwtk8lvSFEUxm/73rmGhaHmWU1b/0K7Y2PRnbDRDYmo2IiNpbAUFZGQ1lCt
mVoYYh4XxhA1q3lM2dAihvh9+d7iy/2dc4d37rnfq29e2dRSm1JqQCWanVNq
jZSWEexizMQ/4Z1FSgU8Da0h30M8FH4N/4G/1qS0Fx5LbgbrD5I7S9yOFms9
ub+Mo5hvZOxi/g3jc7Sdvb3EvfAV9AxuZ/03eAd6WPibU9nbXe1dzfwn+HOY
96HT8P5wLZ2seQJfRo/gTcwvZf/38NnbyN2Ar4W/3UhuIvOz0IbwHXSX91Uv
1qI++AGqg7vRGfgkamN/C/EPfQsN8P0Oco/hU2FexXyXakPDSu/5Av+rerOR
+Bw8mW8uYdyMJsBtYs7bwvxF+ATaWvhOJfPXifvgeZzRAd9Gv4mbiF/BQ7J7
0QCPhI+Hz1rO/Af4JuonXkC8B34pFX6TF/Ag9vwqfece4lriAp4Lj4CHZ3OQ
uxfukXqlN7wKd4Z7oxoPh9dorTwV2T1Rb1TDEfgjWlH6G3fDNak21XQofCfd
TZ67A9dk3109SdlvrLeWZy7pHYnXM04nNxp+Cy8snavP7oF6oZ7dgp+Gvas3
PACPY82iysPysjwv7ys3Hu6XR0vXrNrlKXlLuYHwP6N/Rz0cnO0ZeUc1vAt7
Vt6VJ+7DR8NvtU41s/4Y4/ywJ2cS72ZsDntkUvaddDetGZPtYXlZa6bAF8Le
kofOV2fqbP2Dddkek9f0z8+B/wOBapLU
              "]]}]}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0kVOZVEUBdCLU7gUbqGLtCtYHwkdGmgPEpz/cSncJ4BMACaAhNCFCSAT
gAkgA0AWobFy9k1ess9971X2RzsiMSGEXboTQvjJH/EhXMWFUCE30ccSx1zy
yDuZHq6ljRH2OeWWZ74oiw2hgR4WOOSce15J11NNC//0Ru0wJHea/c7D8gij
jDHOBBGiTDLFNDPMMsc8CyyyxH+WWWGVNdbZYJMttqnTOal7R+4yB5wH5Waq
SOPF3necccA83dRTyqd7P3HDCXsM00oNGbx5fw9ccMQivTRyraNHd7ncbjbY
oUwupYRiiiikgHzy+EsuOWST9fONyCCdNFJJ4Q/JJJGImqAmqA6uEOrjf/+H
b/RPNT8=
            "]], 
           
           Line3DBox[{1639, 1475, 1515, 1441, 1540, 1463, 1535, 1536, 1537, 
            1444, 1482, 1549, 1454, 1446, 1527, 1464, 1491, 1517, 1518, 1449, 
            1528, 1492, 1467, 1514, 1513, 1457, 1507, 1555, 1554, 1568, 1456, 
            1553, 1545, 1466, 1498, 1450, 1532, 1448, 1506, 1488, 1550, 1487, 
            1505, 1486, 1485, 1511, 1462, 1481, 1461, 1473, 1438, 1452, 1471, 
            1472, 1459, 1470, 1534, 1533, 1439, 1559, 1560, 1546, 1567, 1566, 
            1440, 1474, 1639}], 
           
           Line3DBox[{1711, 1477, 1516, 1510, 1521, 1442, 1573, 1574, 1561, 
            1564, 1563, 1443, 1565, 1562, 1478, 1547, 1479, 1502, 1501, 1531, 
            1503, 1504, 1480, 1548, 1453, 1445, 1484, 1455, 1447, 1465, 1495, 
            1519, 1497, 1496, 1530, 1451, 1499, 1520, 1500, 1469, 1558, 1572, 
            1571, 1458, 1557, 1556, 1570, 1569, 1508, 1509, 1468, 1494, 1529, 
            1493, 1543, 1544, 1539, 1542, 1541, 1490, 1551, 1552, 1538, 1489, 
            1512, 1525, 1526, 1483, 1524, 1523, 1476, 1711}], 
           
           Line3DBox[{1613, 1612, 1611, 1610, 1609, 1608, 1607, 1606, 1605, 
            1604, 1603, 1602, 1601, 1600, 1599, 1598, 1597, 1596, 1595, 1594, 
            1593, 1592, 1591, 1590, 1589, 1588, 1587, 1586, 1585, 1584, 1583, 
            1582, 1581, 1580, 1579, 1578, 1577, 1576, 1575, 1460, 1640, 1638, 
            1637, 1636, 1635, 1634, 1633, 1632, 1631, 1630, 1629, 1628, 1627, 
            1626, 1625, 1624, 1623, 1622, 1621, 1620, 1619, 1618, 1617, 1616, 
            1615, 1614, 1613}], 
           
           Line3DBox[{1686, 1685, 1684, 1683, 1682, 1681, 1680, 1679, 1678, 
            1677, 1676, 1675, 1674, 1673, 1672, 1671, 1670, 1669, 1668, 1667, 
            1666, 1665, 1664, 1663, 1662, 1661, 1660, 1659, 1658, 1657, 1656, 
            1655, 1654, 1653, 1652, 1651, 1650, 1649, 1648, 1647, 1646, 1645, 
            1644, 1643, 1642, 1641, 1522, 1710, 1709, 1708, 1707, 1706, 1705, 
            1704, 1703, 1702, 1701, 1700, 1699, 1698, 1697, 1696, 1695, 1694, 
            1693, 1692, 1691, 1690, 1689, 1688, 1687, 1686}]}}}, 
        VertexNormals -> CompressedData["
1:eJysfHc01v0ffhlRUhINEoqMNGiSvGQWSkRCKSRlFFIkq6XsjIxChETI3rzt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         "], VertexTextureCoordinates -> CompressedData["
1:eJyVnHl0VFWegFFbDeJCxoURV0QZPYIrOIjCU7sFQUEhNIQGGgGRRkVl1Rbb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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 2.602954596292145}}, 
       PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], 
         Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ
tooIDYmsw4yx741lxuzkQevDZ75/wPeHe84999xz7v56v99303lv6wtCAgIC
zfwiyC//Vy/qHRx6I90M0vm1nPikSQga35Y2MGJCOLCjOfsKEVsrZNTv7ZiE
9aKo7IUgJjisxSfJPm3YELb6lAuFjovjdWS5KiZEp3d8cdpFxsi5Z4uyV+nY
vrQu2GGBif9u3PB97dqOF4vkm4XidKyPTpTXBAsVI6cimtdQ4KynOKHwigbr
XbWXEsJYsNimyI19T8HKKdtJ5/002Pp3Mh5/YkEgavaThVkHzN4zv/39dQJB
xyU5OxZZmEiMEiPUdKA6dqnEiaAJWNWPPvDfy0Yy45yvg24nCM31Xf+unYBP
iOCHsyFsCC+tLzyc2Al74e7rdsXjiF1ps232IxsuP8ruh3I7caShIdXv2Dh0
1TMCdv5iQ1Ss617V7i7sfXTD6QBjDCbd81JqhhzYXWozKAzpQptFwM5P4WN4
5bfKhHyNA/qFA169ZV2QWEthDimOoYN5ZoN2CQcp098YRfQuKFyQ9n9cNooX
Ub/LLaY5YMcWjcav6MYDr7r5QatRUByTpjdocfFUpbaMotGNVZqvb+UyqPB+
IRlddpkLXynnhbx93ZgrkF/Bu0lF2D0pPakcLja8nZA+adUNy3l9s4x1VJSb
xfnpjnHR+UwQrFPdOPnuRKqDy1f80VZpktvAA/ue/RJXjR58d846voY8AjfN
kd5+RR5yVQ6yLs73YIVP/oymyQiOOSlOxyrwMPFFVc/0Qy8su2cR8XoYNtLW
G43leTgjFLF58Wofuv2aTwnJDEPnCMN/ZB0Pj4LyHe9t6EdVUemZ28FDqOfu
FfWX5SHVNdArpaEfUu5KymNjgyhZVTggspaHsG7R2f5LAzhrezX1u/kg3Hbd
Eo6W4UFK0uxnz5JBvKg0OpqUO4CUh4IJotI8OCqrrZBIHkS4/4ukWLEBnNbx
TAyQ4sFVyTmQpjqEKKUTk7mu/fA//11+VJIHycZbDbXFQ5jV4Ga/IPThKZmi
Z7qShxLObPUPw2EsOm35tmd1H+qalDmJEjy4zP5c0Vk5jE/Rv+Q3uPXi1C1x
2zFxHjTsyh8lGo7gksKBNN67HuQceR6msoyHlOUzPiHFIygeOZBm9rsb+t1/
/F3EeFDdISFYq/YV5Jaskmfoxp7zW4/HifBwlywekZj6FYacmhKv0C6ILlOR
Khfi4fCZWWa8CBVzufuWi3zoRCnnB7lHkAcfxj0P0h4qvLhk7QRGBzL901I4
i1x4ahrfifOh4uNUlpz86g6cTBQO+fkfFx8fhOytYVNB2t7FCvlIQea08jfz
Oi4WTWeO0M6PIqD3joTceQpoy6/w8iK5iAzbvdKpZxTxFvctK0Uo+Kpv9lTl
OBf9XXd2BJiP4XrqaV/1nHaopLbLf5DmYltc25KQkjHQzS6c0NjfDger/564
9HOwwz5J7vX6cbRvyonjlJNh7BG4SymDg/jzUSN6d8fhHjn2z7VxEvwj6zfN
u3EwlSv/7DBrHHEXy0oNREjY72cYPqHOQXHmL2+FYxMoaEsQcVzfhq5touGs
aTasVEsWiYUTiGGEadHVW/F9jcXRpR/YMOMlKYVJ0BD5TjUjX5OIwFeLEnv5
790/RPLEqcs0zHdQ0803teDNdrVv0fvZOCsbruH+hc8XDilMWKwZx2VLt84s
YyOELlHbtZ4OgYOzl1oHGxHskTHk087CwuXtk++u0bH2TLDrr7QGnGnkmi1N
YiHb5pfvmlY6XGOiPVQt6pGfXhVV7sSCCOlzmPSmSbwWtu5v767DNt5R+q0t
fF5Z8uKq/SbB3Khe8cWsFr22wvfd2EysyzNoVG2cROHUhJ/83Rrovr716mwx
E+xCOwGXdQw8KVjKc91QhaP05/7XA5m4LWLHzbZl4M8XskQdjYAjCjYP5H8y
EDRl/S8lngGCstr70vcEtOxp6ZYNZGCNh8EKwTYG/96nXj4UTcBMkCjL6+ck
ljnwj1yEieo6hfXhlwmIZu84qHhjEnomjS6Ve5gI0FD642pFQIFMmrnybzrW
Gc//5+nDxMbkh3ZMYwIeDGlrhQXTcX5k8dPf2UwMhZ17JqZHgPdgnrTeAg2+
/2ZQ+7uYMDV2uFikTQCVoscxuknDulC71FJhFpx/BSQ18vu/IZ0ISlxCw+/6
QTMZfRbKxT2eGOwl4DnNwnr/3Ql8Ya21ET7LQo/Q9djhEwTEDSQ37Vs6geT3
4g8TolmgOi60JFwhYO/bpNmY6HGE7h+YIZWyQIhzWqXDX+8HZ+ZzNclxpOju
ZNWOsNBge036TjEBgXXlRyUSxtBja4sgUTY2bjrAcqIS8INwScJAdgzRf33W
E9JiY+hRyb1ImSostPnFvUwdRZr8xO0L1mxEabMMW49XIZJpInFq4yjUSwg3
Cq6zEeMZrzwVU4XC3Tu37n1JhY56xvRoChuegg0fS7uqkPVCaNxZnYrNq3ac
liSw4VicdGBcqRpCTky5c3xOizybD/Dt4o+rID98N7gG74Knn9s8G8Ejo5Zp
Qw4bK2v6G19SPuNC16U5ucFhyLr/znAV4mDVkxfdedJ1MFJaH5W+bhjuGvOW
3+U4sD1tdanh4BfEbzgi2WEzBOHC1ifft3PQoP79otuVenB/nVXNih/Es5iX
Mu4HOaAhPvjS7QZkxQkozpMGYP5J2uioAwddsVo5VvGNiFuMCi8XH0BRuP35
V1c5iJspm/8ruQk2B3pJrQf7EamX3BcczsFq7n1bvyfNKJAvJUvf7MP8Rh6J
nMgBq3etfMTDFpTUxEheqeiFwfhtt+xcDtx/lW81CSVCdFeJ1KtvPdDTjXr5
q5IDxs/OSr3LrdDf7Xg+Ta0Hhzy3Pehr5WBCSO0h63gbbrtIeco4d2Nli6ug
6QgH4vpuH3u2k5BsukWA8qgLfuLsYf0pDgKEZ/sdJMgQ1OQF3K/rRHAMi1W2
yEGoiZEzaYIMkefi1oyZDgQmNIwRJblwbeMc/OTYDpkeeaFIpQ44WFD+vqbE
ha60meDp+naItV6n8A5REO84v6tMmwu/LKrACU0KGlUXt96/2g7jD05f4ky4
iNl3taL2EQXKKtLB+5XI6C39HsVz4oJNHnrcJtUJ8cePtYRrSFBXtLXNDOGi
iOTBKeP7i0jS1njBMyTEJDf9fpHGhepM0o2E/m7E9/aZMKfaUDHZY/m7kovM
tguCDmq9uLns7rRLaBvMl/0Ue97Hhbt8gPsBzz407DLeJiDahuJtx+eT5rjg
Wd3yFn/Vj6crE66cjmhFkJR12yBfP0/72v8RHRhAwK6PcswFIq4x4kw8tXhg
bPnWdkJ0CJWdLwY2eRPxr4L9lMUhHuBtfImoOQzOmwBT554W/N7hEe51nq/b
pOnfesdHsNA5mTKq34I9Hq8eDgbx8PJ43QoVj68wX+91nxLRjBWfytPjHvMQ
u6zDVdqMinMrT81rk5pwzK3KKLqAh2zZ0LGuViqiZBoKWpc2gXiA09dcx4OH
7q4hMdtR1Cy4FpjtbESgiwHn8AAPy00sM3uGR/E6sPrJ0MkGLG9k9UlM87C6
8c2qi25jSDW/VHXTsR5/L1r8XCEyhV8zx+70MPn+TehudrT1F0j5r087KjeF
dnJJ8IGr4xCRi8xP1qnDyy574UbNKZxpumfU/G0cds7EKPWZz/AiP3UPwhQK
KrbqBvlN4Hc8WUPuUQ3sVtnmiktMYUl3ll586wQCKUEMtkYNbNo13Ot6eZC7
fSg4YTMNLelf+owjPmFfTVZdxnMelkpEbIsJpGHivc6b3oJqLB8XjU3x5IE3
GKYWR6JhpdMOcwliFf6cibfO28mDbOA++xxlOtKeE3PV+NyaM1h9kMjXf7tN
rNwhvl5N6P/jeZb9EfJF683nvnAhJuC/bW8THfE0em8DuxJrXhJ6N0ZzUb74
emu33CTonJ0HLagV0LbzkzU/wUVjtL9h/pVJPLbaJJHaWI5jeTlljjJcXBA7
9Vdz5SQC1FQYezI/IE9r+8yZXg4S/87vMRBn4EGS8p6T7mUoTFK5vzuFgyvf
P6csnGagtupeUuL6UuQuvi7m2XNg+Ujv+5ZXDCiSTh/TqSrBTeLT1Vf5vPIj
Gfa+m2WA4eb8LGh/MTxNJQsLe9lYe5JTnr+PCb+ouB15+W/hVOjRl/WYjZtz
MZXrYph49MLHwG2kEBLiw1p7T7BR8XtZ1kI/EwnkWruYZXnwuiQYcE2cDUp2
8ch5FRZeNVpvphBe4j+HgAyjOhaqz3mkHPZhodb6ivh/3zIxZSaeGHSD309w
x9vKSr7OLGmoy96SjNRTbatMB5kwH7D0fljOgmYL8XKR1lMQ/QeOJe1mQpBo
aPCBrz9Uv9uJzcfS4HnO+YdzMgMKW9UUdxez8FPgxM17d9LhKlcd5jM7ie6+
0M3rilh4qt+iW+WeifW8R46ZxyehURF24K/XLBzusjeWf5qFOomrmlU5dOja
jLhzs1mYcon8s7nnOdh6lkkxf2jQrjnqxXjGgrCNWGy24gskZc5xO61oCGpf
omzO9ytvaKU7w91fIjJk5IpZ5gQ+G+HI0jgWdJVlQolvc/CVtnYunDuOh5O1
WTqRLGjMEoPfz79C6n4Vw+0G42DOmXfW8HPaNdGIC9q7X2PlvDqpLXgMWRnc
8MrrLLiIHLyoFZSHN2vvyrVVjWLMt8hSyYuFXqMXm3Mr8rHa8/2u4J9U/L2x
umz6PAtHZP2PJs0VYNlPz3WC26mwXTdjpXOaBaU8e9M57SLYF/kkPK4cwfYz
G+O/HmVhTjy3vurCG2zTabv3r8gwlj4L+rZoysLIsBB9/uhbPChXi440HsTK
5Zz++B0seOqkp32mvYXXKV/FQPt+uNDd3qSo8vdzlZHL3pB3cL+qoDNj04sK
dQPSGnkWHpebDnhKF8NovkzY508P+lt+DDpLs5BXrfXB+jkBJutrh8wzenA7
/UNLkQQLN+rFgg7Y1uKJ4POiXXt7UNEk8FlElH+P7JXKpyrroX+HfexHXzcm
Hz6guS4yIVnd1M8mNMH6wqSOsXc3Ti/d69L8gwkZ5jHJk0FE1OzW4OYKdOOv
PmWbXTNMrFo2Sd2/lIRLh8Js+h90YZr8Dy+P7xeblgeFvjNox/L92xQcpLtw
42mstSqNiYz6W7esHCl8n/S1KSehE14uwq/zR5hIM/F37fLrAF1k1ZDKik6Q
z96VM+zj5/nfIlVOtzshTA/L2RzWAfHEKWIrhYlSHV3VqPtdyBROCCAyKFA0
PsS4TGRi9H1OenokP99cE7PeYEnBlDfhiWQ9E+QtPlPpt3qw6VQUg5beDrm3
mYtV1UwcL7kC52u9qHnnrXmAQsZTd58j18qZmLhpmBrl1gdW44bhgUMktPi2
Pd/J97vHt3ublFr1o9VhzDsnoxU2SWHai/lMrDZvzDhtMABDtpLYOnILVv/x
le14yYTnM6bQsMIgQlWyH67l6wY3kxBRlMGEWdYSeup/g5h6k2voFNuA+KbY
l49TmLBPWJszNjSEg/ZpFcTURqhwGJ7UMCZ+fgDprPAIFAO0zgjfa0JZes8t
9YtMqOSl7FnCz293LrD1r51qxhNpSXXfo0wofDTbumULFelnff4pFm3B7Lnm
gko9/nxinkS2F1Ox0eltxNuMFixea7AWlGPiqUy8307TUdR+WXKUtZGI2/oO
Fy0WGVjl65Qb1DqKCOXJ4hvRRDS0+Ok/pPF5WK0Y1WA3hscLMru1qUTsNy0Q
6yQyIFBeKLZzbAysDyubYpRawVA115MrZmDDVuvDYx7jWPnMxo9t2YqQx/uE
z/J5I810PESfHYf2iSO6Ti6tqN5zrv1VKAMZ1o7GtiETWHgz9rWJ395A3sme
dmMgMM1F7KAIDVdnSOJfD7dCO0Ytf88RBo4cTguve0BD7vIWC7mNrQgXiXCP
1GUgQOpjHVWajg3iBQvvR4g4KHU/pFeWgXuDdrZ5T+n4s/Hc8vy7RCisuGi+
bWES68xLPDX5uUj+eq1ltjQRa2C7KXRiEiuoasv+eTWJQyFBN8ciWlARmH21
p2USBlb5m+5qMXCz3ltVZ7gZyXMlcXrv+Fxce6j6agkD/9//1f8Aa2OKuw==

                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True]},
  "RowDefault"]], "SolvedExampleOutput",
 CellID->531792481,ExpressionUUID->"fe2ec5a2-957e-478b-b790-ce097204ce0e"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->609024600,ExpressionUUID->"4690dd67-3ed2-45f8-86f2-ac301243ee95"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->616549313,ExpressionUUID->"24b1c54a-e923-4130-b732-87e058e185c1"],

Cell[TextData[{
 "Compute the derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["z", "2"], "+", "\[ImaginaryI]"}], ")"}]], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "377bbdf4-5db3-4576-bb7c-964767cbcdc6"],
 ". This is the composition ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"g", "(", "z", ")"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"52e1f6f2-874f-4896-a607-fc652cc705a7"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6ec10adf-115c-4135-888b-4790b3dfc143"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["z", "2"], "+", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e4082782-a910-4dc6-983d-3d7846b8db78"],
 ". So the derivative is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", "\[ImaginaryI]"}], ")"}]], "\[CenterDot]", 
     RowBox[{"(", 
      RowBox[{"2", "z"}], ")"}]}], "=", 
    RowBox[{"2", "z", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", "\[ImaginaryI]"}], ")"}]]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "3bb1e5b0-13d9-4d31-bcc5-7e20f3107203"],
 ". With ",
 ButtonBox["D",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->105134410,ExpressionUUID->"1e86577c-07fa-4911-bbe5-f3abecf4e631"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     SuperscriptBox["z", "2"], "+", "\[ImaginaryI]"}], "]"}], ",", "z"}], 
  "]"}]], "SolvedExampleInput",
 CellID->15156176,ExpressionUUID->"b84fd153-6a92-47f0-bb92-eb8ef262986c"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["z", "2"]}]], " ", "z"}]], "SolvedExampleOutput",
 CellID->114810223,ExpressionUUID->"c145b3ad-1fec-4afd-97e4-f3024c75675f"]
}, Open  ]],

Cell["Plot both functions:", "SolvedExampleNote",
 CellID->78387022,ExpressionUUID->"ecacd9b6-2b5f-4aa2-9e07-2b7b884de366"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", "\[ImaginaryI]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", 
          RowBox[{
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
            "\[Rule]", 
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]]}], 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Rule", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["56", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       PlotLegends -> Automatic,
       SelectWithContents->True,
       Selectable->False]}], "]"}], ",", 
    RowBox[{"ComplexPlot3D", "[", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", "+", 
         SuperscriptBox["z", "2"]}]], " ", "z"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "3"}], "}"}], ",", 
      InterpretationBox[
       DynamicModuleBox[{Typeset`open = False}, 
        TemplateBox[{"Expression", 
          RowBox[{
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], 
            "\[Rule]", 
            DynamicBox[
             FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]]}], 
          GridBox[{{
             RowBox[{
               TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
               TagBox["Rule", "IconizedItem"]}]}, {
             RowBox[{
               TagBox["\"Byte count: \"", "IconizedLabel"], 
               "\[InvisibleSpace]", 
               TagBox["56", "IconizedItem"]}]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
           "Column", 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
          Dynamic[Typeset`open]},
         "IconizedObject"]],
       PlotLegends -> Automatic,
       SelectWithContents->True,
       Selectable->False]}], "]"}]}], "}"}], "]"}]], "SolvedExampleInput",
 CellID->31257799,ExpressionUUID->"09f2a9f8-308e-4b95-a313-e35bf577516a"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJytvXm4j1UX/++cY8qUDKFUxkpmJaLsbSoSMlNEqTQZIpQmSUqGyJCMpcc8
JqGSzydlnjOkRCeHRI7MhJPf88t+rc91r/ve3+fbdX39c67zts6+1732+957
7bXXXrv4Y92bP5GcKVOmjJyZMqX89+eCa2seuHw5W5yfl//596e5JTXHW/e2
zSr44KbHbt7aeLuZMuun0sMWZhY809bCb1Xr+IUp1Gv26u3ZUwT/ZPneZhll
ppr37u7X5bpHkwTfY19rcXWroebqXKPzrux5OQbe5/pSORrke9FkmnJ786Yl
LwnecNcv3Qbe96Q5UXn7qJ+3nxf8i7bfTf+mT2uz/7ueO58eeEbw3R3+eGrO
3AZme5t8hc7dcVLwb2bPuv/5QfeYd3Z2/jT7hnTB/8jU8VTHWrebZy5OvaNk
uUOCH0g1mb5uUdY8UHz/0nuGpQo+qfU968qULG0eHl6nz8Kftwv+Y/Pl30/e
Uty8+FTKqTEvfyn4xV45DvdvV8y8cgU3Gm9/pR2j23HPFXyye67T02g93XsJ
ftS9l7OD4CudHZzdjLabs7PRdnb9Ivj9rl9cPwre2/Wj63cL/pPrd8cTq3ni
eGU1rxwPBR/ieOh+Fzwp0///77joAX8vrj5e6dBbOSy/8zOTk4fP4IV/zlnm
nWw7hc/gHXsNLmWKrhA+g9dLOjh39sszhM/g3fL2eG70qVHCZ/BO43/c3Krv
AOEz+A/LM6q9Ormn8Bm8Z6u9lYf0elz4DP711sol177YVvgMvqxL3xef+q2p
8Bl8wJuZs3eefq/wGfynOW22ZH6rtvAZ/EfHE/gM3m/HS8vqX1dT+Az+ksPh
M/hu1w581s+Fz1pP+Ay+1L0XfAZf4ewAn8Gfd3aDz9rO8Fn3C3zW/Qifweu4
fofPmifwWfMKPoMz3sJn8EuOt/AZng7pfGl0lgqlRA58Q8myn6xvm93yOz/h
OXwGf+6j/Yu/+n2X8Bn8WMVnNvy+9xvhM3ibSdOSCrWfL3wGz3O0VHq/IhOF
z9KO+97hM/gjO+c02nLj68JncPoFPoNfdTp+oVn9p4TP4Cmf3Frvk5qPCp/B
H7r42mfxmQ8Jn8HXu3EMPoNPv6X4bb9Pbil8Bp/mcPgsdnbtwGfwdu658Fnr
CZ/Bs7v3gs/aDvBZ2w0+g//p7AyfwXO7foHP4G1dP8Jn3e/wWfMEPoMrP8Fq
HsJnzVv4DB+z/fXtH1kq3S18Bi9z3bzn8iQVl78Hf2bW0CKPt8tq+Z2f8Bw+
g797b4FaJ0/vFj6Dv/NVycM33rFK+AzeYsCle1M++kz4DL7tt97Lp6z7RPgM
PrrOp8NuWD5G+Az+YYPNtU8mvSt8Bv+xUJcCvU/1Fz6Dj3LzJnwGT3V8gM/g
RS+NfXxDp+7CZ/D1g3vcsnjTc8Jn8HUOh8+6Hfisnwuf5X2dnvBZvxd81naA
z/K+zm7wGfx7Z2f4DN7S9Qt81v0In3W/w2fNE/iseQWfNQ/hM3hWx1v4DO+a
dVu/rFa+5sJn8Hkjn39s2KaqwmfwSusq5cg9s6i0C959z6iup97MbPmdn+gP
n8GznG/8V0qlPcJn8Kx5blv7c5l1wmf5Ppx/BZ/Bqx05vrXzvjnCZ/BsKxdX
7z33I+Ez+FjXj/AZ/KJNOtNh73DhM3ifYuu6zvrlbeEzeKn2Gdfsv2Gg8Bm8
m5uX4bPG4bNuBz6D93bPhc9aT/gMPib4XRttB/is7Qafwa91dobPul/gs+5H
+Kz7HT5rnsBn8MqOV/AZfI7jIXzWvIXP8OvRt84vfSrLw8Jn8DELVz00eFZD
4TP4vPx5n31gbyXhM3iREu3jH5QuLM8DH/7hmzbbzmTL7/zkfeEz+OjkmwoU
n7xX+Ay+dcKmd9J/3iR8Frz/tysmPxkXPoO3deMJfBb996x6LGXMLOEz+Fdu
nQKfwW908yx8Bu/yzKW6ved9IHwG53uBz2JPh8Nn8CddO/BZPxc+gy93esJn
8PnuveAzeBtnB/is7QaftZ3hs+jv+gU+636Ez7rf4TP49Y4n8FnzCj5rHsJn
zVtZTzoeaT5rXPxmh5eae+/696rXScwfDt9arPTkLdfelvg+Hb548NZSW9oW
ED0knlFtysA+DZMsv8tPZx/4DL6leMbao8VThc/gtaZ/+XDrZduEz+BD3TwI
n8EfWf30ubWffCV8Bof/8Bn8Gecfwmdwvgv4DN7arYPgM3grh8NncHgIn8Gf
c8+Fz1pP+KzfCz6DD3F2gM/abvBZ2xk+636Bz7of4bPud/iseQKfNa/gs+Yh
fPbgcfii+axx+Axex43z8Bm8aKHCm07+cpfwGfwl57fDZxl3a040RUtfI/qB
/12lXdHPl18WPvOT9QJ8Bj+Z+v6xfKN+FT6LPm69DJ/Bny9c++FZT28QPoP3
PtKv+Yo+3wqfwXu49Th8Bmdehs/gbWf0X9/g/qXCZ/A2DofP4AVdO/BZ9HTP
hc9aT/is3ws+azvAZ7Grsxt8Bk8KzptG9wt8Bs/r+hE+636Hz5on8Bm8btDv
tZqH8NmDx+GF5rPG4bPG4TP4r41aDX9j+H3CZ/BFV2e+rkrHKsJn8NuaNFu0
utpNwmfww6W2frXlQC7RG7ze7kp18pfIED7zE57DZ/DPdu3KXb10mvAZfJhb
p8Bn8HvceAWfwXs6nsBn8FUXpsSbFFkjfAZnPITPGofPuh34DK6+O8GN0xM+
6/eCz2J/Zwf4LPNbcB4UvLazM3zW/QKfwcu5foTPut/hM3iq4wl89vAwhMNn
Dx6n/zWfNQ6fNQ6fwfd2KrHlmwUthM/gf311OW+Wz2sJn8HXuXkHPoMXdP4V
fAZf4+I2vA/4vEpZ9pdccUH4LH6H6y/4DD4/0/FyTfccED6Dj3X+IXwG7+vi
S/AZ/AMX54fP4HwX8Bmc+R0+g49z7cBn8D7uufAZHD8WPss+knsv+KztAJ/B
5zi7wWdtZ/gMXsD1C3wGXxv0My34Bdfv8Bl8n+MJfPbwMITDZw8ep581nzUO
nzUu8RqFw2fwfe57hM/gB/Y3vTwm5Q7hM3jF5vVb3jyohPAZfOazX97cdV4+
4TP4s269zHuC/zFjSoFnhp4XPosf7foXPoPn6vPZ5uHLfhM+g+PPwGdw1q3w
GZz1PnzWOHwGHxX8jox+LnwGz+P0hM/gap4S/KizA3zWdoPP4DOcneEzeAXX
L/AZ/KDrR/gMvtf1O3z28CqEw2eNw2cPHqc/NZ81Dp81LnFDhcNn8MVb2nec
NfZB4TP4L+evxA9l3eVwxm34DJ5n2JCVxZpcJ3wG/93Ng/BZ9rHdOoX3B2+2
sV61Ne+cFT7zEz7AZ/APuv92oU/8d+Ez+Fw3HsJncPwc+AzOvA+fwZkv4DP4
OPdc+Kz1hM/gzd17wWdtB/gMfiTo1xltZ/is+wU+g6e6foTPut/hs4dXIRw+
axw+e/A4/ab5rHH4rHH4rHH4LHGvlhcv1+jZSvgMXtitZ+Ez+CcubgOfwW9y
cXX4DM64DZ/BO7n4PHwGxw/HLuAtHp1asdeC08JnfrI+gs/gW198Z+sPZ48I
n8HhIXzWOHwWv8a1A5/B4S181nrCZ/1e8Bm8o7MDfAZnHIbP2s7wWfcLfNb9
CJ91v8NnD69COHzWOHz24HH6R/NZ4/BZ4/BZ4/AZvNfYkS3f79VO+Axul56/
+NmU+sJn8DQ3f8FncNbL8Bl8S77aUx+/7VrhM/gRt78PnyWfyI1X8Bkc/wR7
gQ989o7mZy6dFD7zE57DZ/Cu974yf3fHdOEzeHeHw2eJ/7l24DP4W+658Bn8
aNCPMvq94DP4YWcH+Ay+1dkNPms7w2fdL/AZ3Lh+hM/gvV2/w2cPr0I4fNY4
fPbgcfpB81nj8Fnj8Fnj8Fnj8Bkc/wo+g090+0HwGXxExx2X11wsLXwGL+zW
KfAZ/A83n8JncOL88BmcdSV8Bmc8xI7gv87ZuPeGbieEzxKHdvyEzxqHz+Bp
rh34rJ8Ln7We8Fm/F3zWdoDPsj8fXHcLPtLZGT6DT3D9Ap91P8JnD09COHz2
8DCEw2cPHsfems8ah88ah88ah88ah8/gms/gExSfwUcqPoMXVHwGP6z4DK75
DD5X8Rlc8xk8TfFZ9k8UnzUOnyWep/isnwufwTWfZV9d8VnbAT6DX6v4DD5C
8Rl8ouKz7kf47OFJCIfPHh6GcPjswePYVfNZ4/BZ4/BZ4/AZ/AXlb4Ab5W+A
H1D+Brj2N8C3KX8D/Hflb0jesfI3wNOVvwE+SPkbsr+n/A3w7srfAO+q/A1+
Jil/A3yg8jfAVdzG6PeCz9oO8FnbDT6D91P+Brj2N8BrKX8DvJfyNzy8CuHw
WePw2YOzXgvxWeNqPRjis8bVetB41oPGsx40nvWg8awHzYzo9aDpGL0eNJ71
oPGsBw3rMrUeNJ71oPGsB41nPWi2Ra8HhedqPWg860HjWQ+aTtHrQTMzej1o
POtB41kPGs960HjWgyE+e3gYwtV6MMRn7OSJ14X4rHEVrwvxGdwTrzOp0fE6
44nXGU+8zhyJjtcZT7zONI+O1xlPvE54qOJ1Zl50vM4sio7Xmc+i43XSjorX
mQ+i43XGE68zzaLjdcYTrzO/R8frjCdeZzzxOvNLdLzOeOJ1IT57eBjCVbwu
xGfs4dlPCfFZ42o/JcRn8L3R+ynmYPR+iqkQvZ8i47DaTzGe/RRzNHo/xag4
mOB5ovdTjGc/xXj2U0zW6P0UwdV+irSj9lOMZz/F5IreTxH/R+2niH+i9lOM
Zz9Fxm21n2IqRu+niH+o9lPMvuj9lBCfPTwM4Wo/JcRn3tuz3x3is8bVfrfZ
F73fbS5E73ebtdH73aZA9H638ex3mznR+93Sv2q/2yyI3u82Y6L3u02f6P1u
49nvNp79buPZ7zae/W7TN3q/24yN3u8286P3u8UOar9b1pVqv9t49rtl3a32
u2XcVvvd5q/o/W6zN3q/O8Rnjav97hCfeT9PPlKIzxpX+UgmNTofyXjykUy5
6Hwk48lHMrWj85H0uCT4ouh8JOPJRzImOh/JPB+dj2Q8+UjGk49khkbnI5nV
0flIpmd0PpJ8LyofyXjykcTPUflIMk+pfCTxw1U+kvHkI5nbovORjCcfyfwa
nY8U4rPGVT5SiM+8hydfNMRn8LrR+aLGky9qPPmiJm90vqjx5IvK+kjli5oT
0fmixpMvajz5osaTL2qej84XNQWj80VNm+h8UdM2Ol/UFIrOFzU9ovNFjSdf
1HjyRY0nX1T8GZUvKjxX+aLGky9qro7OFzWefFHjyRc1daLzRUN89uDk24f4
rHGVz288+fzGk89vPPn8xpPPL+Otyuc3nnx+48nnl3FS5fMbTz6/8eTzm+ei
8/nN3Oh8ftMqOp/ftInO5zfzovP5zTPR+fzGk89vPPn8Mi+ofH7jyec3nnx+
6ReVz288+fzGk89vPPn8xpPPH+KzB+c8VIjP4J7zVsZz3spcH33eynjOW4l9
1Hkr8WPVeSvjOW9lPOetTJvo81ZmfvR5K7M8+ryV8Zy3Mk9En7cyY6LPW5mx
0eetpB113sp4zluZr6LPW8l3oc5bCf/VeSvjOW9lPOetZN2qzltJP6rzVsZz
3soUiT5vZTznrYznvFWIzzzfcx7Wzok+D2srR5+HtZ7zsNZzHtZ6zsNaz3lY
e230eVjrOQ9rPedh7Zjo87DWcx7W9o4+D2s952Gt5zys9ZyHtZ7zsLZP9HlY
6zkPa8dGn4e1nvOw1nMe1haKPg9rPedhrec8rPS7Og9rPedhbaXo87B2XvR5
WKvPw/KcrNH1CqynXoH11Cuw6jsV3FOvwHrqFdiW0fUK7PfR9QrsqOh6BdZT
r8B66hXY0dH1CqynXoG9PrpegfXUK7Bro+sV2Bui6xVYT70COyq6XoH11Cuw
nnoFdnR0vQK7LbpegW0RXa/AeuoVWE+9AuGJqldgPfUKrKdegc2m6hXQnqee
jPXUk7GsF1Q9GeupJ2M99WRs2+h6MjZ3dD0Z+2d0PRnrqSdjPfVkbPboejLW
U0/GtouuJ2M3RNeTsZ56MoKrejJ2fXQ9GftQdD0Z66knY6+KridjPfVkrKee
jD0WXU/G5omuJ2PbRNeTsZ56MtZTT0Z4rurJWE89GavryfB3l6LrfQlvVb0v
66n3ZT31vmyd6Hpf1lPvy3rqfel+Efz56HpfdkV0vS+7NLrel/XU+7Keel/W
U+/Lvhxd78v2i673Je2oel/WU+/Leup92WXR9b7s19H1vmzP6Hpf1lPvy3rq
fVlPvS9bL7rel/XU+7Keel/Cc1Xvy15U9b74/6TgdyH4kOh6jNZTj9F66jHa
n6LrMdre0fUY7f3R9Ritpx6j9dRjtCuj6zHao9H1GK2nHqOdHF2P0XrqMdoL
0fUYraceo/XUY7STousxWk89RvtHdD1G+010PUbrqcdoPfUYbcPoeoy2T3Q9
Rrsnuh6j9dRjtJ56jHZwdD1GGW/T/nmvLPFn/7FTtvi4ot9XPVl6h+uvFMEf
CMR/kgXvsvvHzOVm/Afcgj/lcNeO4I1dO+65go91z3W/Cx48D5ISR9+aJfrs
unhyp+gDvtqt0xv9w4dMgk98dvjNPT6bDW7BJzgc/XU76K+fi/7g2BP9wXMe
KJL22NNXWfTkPcY/mn51zcM/iJ7gTwfiyRkx8DynsgwYUudTcKNx3ku3w3uB
T3DP5b3AGfd4L/C++x8YNrmF9IfgNdx+N/rzfuklyv34SK6fRH/wtYH9pguC
X/4jX7+eDy4BNxrnfcHXuHZ4X/Bj7rm8L3imIH8EXzmz0/5pT0v/CW7dfhDv
Cz4i9/Slj62vbnkv3vu3E216PtPpZ3kv8D6BfY1zgp9+uuXH5sfl4Ebj2AG8
t2sHO+jnYgfw4LnRZMFf+Lv/udQZ0t+C3+jyc7ADeNaiSwYdKHe72AF8eu2W
lXu+0MTyXthjx7td+hevt9U89E/7pwSfXO7VhaemrQQ3GscOuh3sAF7rru7p
yw/vEzuA07/YAbzqo2+3T8kpPBB8o8sjxQ7gIxfdWjjT7PJiB/D7Xb4odgAn
nsb70v/jA/v7x4UXp/LVPZt+/Vqxg5bHDuB7Xpj96dBdqWIH8GCeQ4bg92Ub
fiTLCOGBBZ8eyM9MFrz2yNKPHDlxs9gBPPPyK/v42AH8WNPlTdo91lrsAI4d
eF948YJbR/C+4N91bXnyhzb75X3Bg/nJFwRv83OlMnWe+lveF3zhqQtfnnvp
anlf8Dovrx3dI1Zc3hd8nIsj8b7gx+s2GBYv31jeF5z34n01/tI/eh4Rvmd3
cTDsAF6y6IQJoy6miR3AeV/sAP5G6fs7vnf4otgBPJgfniH4tjotik1/4Xqx
A/jnBWrsKXa2gtgBvFmFpJkjM9cVO4D3c/nP2AFc20Hj2MG9d+ypGcW+2P7d
QbEDOO+LHcAfrrnswXpT/hI7gD/q4ifYAXxf5mfen3x3QbEDOOdHsAN4Dzdu
YwfwAW4cww7yXPde2EHj2EHj2MH9VOe1jws+pdYXNQq8Jf0t+NDAuZVzgj9g
G06o3DWv2AH8FjdPYQfwzkN3FH381kpiB/ACbv8LO4Dvdd81dgDXdtA4dtA4
drjSXlrs7WWb5uT64IzYATz59iv719gBPMX5S9gBnPx/7ACenqvUqTNXl7ZB
vyhNzmcF/aK0WNH2o0/bsQ1s0C9KE/2DflFayA4aD/pFIdz5dWlGtRPC8as0
HvQbE3jQb0wzvFfQb0yT81aM1+DYjXENHDvznYPTL/LdOpx+hAfg9Dt2gBfa
DhrHDhrHDuDwFjuAw3PsAM53gR3A+Y6wg4xn7rvDDuB8p9gBnO8aO4CrdUGc
70DbQePYQePYAZxxDDuA91D+KjjjJHYAZ1zFDvJcNw5jB/mO3biNHcAZ52X8
cjjzAnbgu9d20Dh2AGeewg7gzGvYAZx5EDuAM29iB3DmWewAzryMHcB5X+wA
zryPHcDxE7AD45y2g8axAzh+C3YAHxcc9wTHL8IO4PhR2AEcvws7gKt5XHD8
OuwAjh/I+zJ+6/cFPxacjwTHL+V9wfFjeV9w/F7eFxw/mfcFV/6Y4Pjhys83
ys8X3OPnizx2YL7SdgBn3YEdwFmnYAdw1jXYAZx1EHYAV/624Kyz1PrOeNZ3
xrO+M571nbSDHZifWVdiB3DWodgBnHUrdgBnnYsdwIPnXGT9bj3rd9s7ev1u
Pet361m/2z7R63d5LnbAHyHOgB3AiUtgB3DiGNgBXK2LBT8WHZ+xa6LjM9YT
n7Ge+IxdGx2fscSFgn5RiiWOFPSLUixxp6BflNhvVfE0OyE6nmY98TTriadZ
TzzNeuJpljge74WfSNyP9wIPnmeUeKb1xDOtJ55pJ0THM+3E6Him9cQz5bno
jz9L3FXFh+3Y6PiwbRwdH7ZPRceHbZfo+LB9IDo+bMcF48MSf1ZxS7nH6rEv
RraqdnCV6Ale9uLQm9tfNV/sRjtza82fs2XLCInDg89r+fviB/KNF3n2eU4d
vnguZ8PJEp9H/mjBFhVPLFko74v8nm71a9Yev0jeF33KO32I59POrPlfb01v
u0bkaWdgth1r7j+4Vuyj35f4P+00OHdmZb9vfxV5uRcp7/Tte0rvl3g17czb
uCapYudfBUf+1rbrrl34/SX5XuR7dfl47GuAV204MCX/Bx+LPPtgO7JUHXyg
23/EzsjHjxV+99bFi8XOyE9+qPvUbTmWip2RtxVfWXJ8yHqxM/IVm+3ZPanJ
RrEn8hdu7fV1h3f3iz2RT75pX8NcJ/aL3ZA/s/rT7j3uvCR2k3tnCr236fVJ
F8U+4Ofuq38hI72gWp+mxJNc/lWwHk5K/Mjue6a3XT5DxlX2A9NX9V3Q8/05
Yk/kW2c/0LrItC/EnsjX7vTh4anvLhd7yrph/tLkChU3iz2R/7xc+v2bC20V
eyJ/+tUFb55qlyb2RH5c9keX3bQqTeyJ/N4eS+zGbBfFnnKPSb1lNer1viD2
RP5CowabfhxRQMYd5BcfSmr0XMP88p2DZ3RpY1Z+XEHiAIwr5DkHzzElx5e3
e6nVf1IWyrzMPupR990FzzclxwffcF2fY9/GxP5yTqLJ7BPV50k+jMjfnZb6
QEqZbWJ/5Hs82vXl1g98L/ZHflWB916aVOWA2B/51w88P/mlqQfE/sj3qNFs
6K6Df4n9kV9lnuzcs91fYn/kfzpbJP7wtflkHkJ+9cPX/9X5bF51rio5PvmJ
AXMOv1VW7I98zY8nnNr55a1if/Bxg6766KlP6kpcl/mnvxu3wZlXOWeBHyjr
8jm7b3hi8ELZPwXflrz667MTPhd59rcfq7qnWIHrvpD+RX5ArZ4tHpr7rfQv
8i+5cY/+Rb7fS5uevThgu/Qv8i+cuVy4xuYd0r/iL5TpWP+bAgelf6Vewr4W
O98YfFD6F/lcg3M2zLZV9JN87Xa1x970VsNE/hnyD05stnvW1qvFH0J+4qSz
f5bYlVvyZmQd02nU1JbVE/F55HvuaFEz+7mS0r/ID/92RKFDh6z0L/LT+6y4
pdf190j/yv0Upd+92PiGNhKvox9zHBi1JGnhAtat4g9+H8wbF/n6nyzet/jW
r4UP5CMUL1+o6vg/4+pcbUbs12Jt2rV6JLE+Qv6b20s1PXvjBul35D9plrdW
j4q7pN/lPgXTek2+mT9IvyP/5oxBl9dm+k36Hfn8vyV/859+v0m/I9/ns2XF
fl6VWJ8gv3DhzD2X6sk4IuunBXPmdy16MafEFZFvuar32o/uyaHO82bEBnw6
eULz44n9COTvzNZ3RO0bi6lzvv+1Z7vSE2fnuUv6HfksN59YWvL9qur8b0bs
xtSpZwflbSH9jnzDAq1u39KzqfS7vqdArcdDuN7vIK6H/MoXf3k4V9NlxFtl
ncS5wmA9rgux1933C6+QX9olz+sNym4RXkmc0s1f8Ip8lldfmHHo0oatwivk
+22q3H7BXT8Kr5BvcSgt+djBn4RXyA9d+MDjJc/9JrxC/qFfc7/Zok/iPIys
hy43vX336rPCK+SXThzUvmOjs8Ir5CsuuWPmjxOyS1wa+V8fKXMmd4FEHjPy
hUbdvvrC2aLCK+S/v/+j1j2zXqfqhl2IDclZtvTGkVWEV8hXH1M0Y9n5iqqe
2IXYsd+G/lLteEPhFfIFmsRrr3m8vqozdiEU99b3AsArDx7X+0QqrhXCtXyw
TsW52P3O34NvyE9y64Jg/YpzsS/6ftB/3qffC9/Ie+rjxv9gXYtzsTF9a6W+
P/9n4RvyjXZkLth/zD7hG/JDum7MVu/8IeEb8gWqza6Y+dXfhW/IbxnV+uc3
v5e/F/mC9RsOqtY+cW4K+TV3Vc760X9k/1Xkn3oqx9GcD2RWdTPOxYrXrdKz
4WOFhG/It/1p+u5YckFVT+NcbJDzB+Ab8ul3Ti8+/NNbVJ2Nc7HXHk6fXHFa
beEb8qPd/BKsv3EulqNO0rIl09oK35D/4fRjbxft10LV5QjxIVS3H7558Lhn
/y6Eq3iy7HuqeHuIh8j/WSrfxR23/CA8RH6rO9cGD5F/qla/vQ83SRUekmf3
hVtnwUPkK71XYegnmQ8LD5GfOLlIlirvHRYeIn98z9f9nvv9tPAQ+bR1DUoX
7HtaeIj8+LIrfjiY6FeRL9hq4PjdPybO1yF/fsLA2ftS89lg/OdkLOb8THiI
/JyClzqPf6KUDcaFTsbajRu0Mv97xYWHyJfr0H/QL0nVbTBedDL2x00bG+Ta
dLvwEPmnC11/ucXaJsJD5IfW+6Ri7RYNhId6PAnm/4Tr7XvGq5B8MC8ohMc9
+6chXO1zxTz7O7H+Li6q9r9i+1ycvN8/v/8kPDzp4mzBelbHY+Pc+BasZ3U8
xro4WM/qeOztI7V/ihUVvgqeI3/RmqWyn1b+f3ps+90vfjF0goyDIt/95nfv
+c/Xkpcg8i1H2U53PZk4tyx5AmOStnd6OY8Nxo3TY2VON3q6a+ecqi7W8diY
NTfcdl/NG4WfyO9082awXtbx2NnaH2Y62LKS8BP5dWfuuPj58URdC+QH96tT
6VR12VeS+k8Fn5+e2ubRRL0L5DNqXxn3gnlH6bFhlTt9V35Wc1V3KzQueevn
+/ITtHwwTymEs18c4qdnHzyEv/yPndfLvtYutz8CD8Gp28A4Cb6i1dbVJ5ck
6k+B3/nNsPZFa/8hPAS/sKD0gdqVZVwT/PVuuwo26ynznOBlnd8l594dfv6L
EjOe73Kt8Af8cbfOgifgFdy4BB/A2y6e1CBW+wHpd8/3K/Uad/ab2ah0g4ek
3z3jgLfOvC8fQ8sH85QOhfqLfszt6iPRX+C9R8y+9MHOw9Jf4LouOnitoU2n
deqcqKME3i0QxziZaOfhI40z70tRdaTTYuvOZs7UY3xeVUc6Tb7rYNwsLbbr
xNkHFl8sr+pIp8WqXDsl+7AqVtWRTovldeujYLwrwedgXCstZH+N0x/OfjHq
ygb3/dfHHnP7p/w98o9UnHLd8G2JfBfkqSOHHD+xP78jP/SP4YXrV+Z7WC/y
tQZOvW1FqaNuf6//3eDUOUSen7QPT5C/x7UDT7Q+8AS8o3sv/BzwOYG6u8cF
7+b26WRf3+EL3H50cD5dH7I/75fJ5Z9w7gD5XG6ews7IT3Z5GpxHQL7s3+tv
KvlrQj/kqaPO78i/f6lr5a9mHhN78v9VHrslf6nPjpvgOLle8t9E78DP42r8
TPQv7SB/u2s/OK6G+GO0/sH8tPWxTo6fwTyu9aH5gnaCeZ6p8r5/Ov9T6lc4
/NvxAw7dNPmE2JP34L2CdcD73z2nZvon15Q7LvoF3/u4qrOckOd35OmXYN3b
hD7I8VPzWfMEe2r9kQfH/thZ8xMceW1/bWfsj7zmP3hHNc6AU7+R/gLPGfgu
tgsO/+kXcNN2fFL5jGNif3DrcOys21HjiTFuPMEv5f/5TtU4E+oX8Eeixxmp
7409td1kvefkGWfwq8AZl9Q4L3Xn1HhuGPfUuC36q/HZ3BM9PksdWuwMfofz
i4L3ayTyAIPxunCdVV/+oa/+qi8v0VeXFXnm2WA+0iGD/xO8vyPNMF8H7+9I
M8zvwfs70gz+QPD+jjSD/8B6DBx/Az8YHP+EfhR5Nc+C4xfRj+DUw1T5otpu
El/35JGGcC2v8ktDuJaHJ552vPVLffmZWh6e+PI2tTw8QR7/OZi/lG5YH8m+
jpOvEIwPiDzrL/iDPP58MN8p3bC+k/tTnTzrgmAeVLph/QjfkGd9EcyPSjes
T+Eh8qxTgnlT6Yb1L/xEnvUO45LUfXTr66DfeMSwngr6h0ekbl7Q3ztiWK+p
PHBDPEHlyZv+0XnyId5qXOXJh/jpkffWI/XlzWr5YF3044b1eDBv6mSIn8iz
3g/mU500xJeCddSPG+IJwTyrk4b4VbC++nEZx4L5VycN8bFg3fX/+jcuHhLM
yzppiL8F67EfN8Rb4KfU83TxPfiJPPEc+Ik88UP4iTxxIfiJPPFJ+Ik8cVHm
U+SJf8Jb5Ilf0Q7rg0nBvKPEuiH63EqIhxqHhx55bx1RX96yr74o8sQt4SHy
xMPhIfLEReEh8sTb4SHyxF3hIfLE8+Eh8sR14SHy7BfIfpiTJ24MD5FnPwIe
Ik9cGh4iz34HPESeuDc8RJ79FHiIPHF1eCj5BW6/hjgI8sTt4SHxRfYf4Rs4
+5jqXFiIVxoP1r0PyXvreSLPvgm80vLBOvnnDPsy8Ap59vWC9fPPGfZ94BXy
7BsG6+qfM+wrwSvk2ZcM1ts/Z9i3glfIs+8ZrMN/zrAvBq+QZ181WJ//nGHf
DV7J/obbt4VXyLOvB6+QZ18YXiHPviG8Qp59Z3iFPPuS8Io49PeBfMs0wdk3
V+coQ/zRuKzHPfUzJX/e7fPCH+TJBwjeU3bBsI8Mf5An3yB4f9kFwz61nK92
8uQzBO81u2DYB4c/yJMvEbzv7IJhn13O9zp58jGC96BdMOzjy/lYJ0++R/B+
tAuGPAE5d0odS5dPAn8kj8/lIci5TSdPvgr8QZ48h6D/liF1aOEJOPk2wfsF
Mgx5HfS71Dl0eTvBewcyDHkj9Dvy5P8E7yPIMOSl0O/Ik18UvKcgw5D3Qr8j
T/5S8P6CDENeDf2OPPlRwXsNMgx5O/S77Nu4/KvgfQcZhrwg+h158ruC9yBk
GPKO6HeJ97v8Mfpd7Onymuh3OU/p8tnoX3Dy4uhHcPKy6Efi0+TX0Y9ybtut
X+hH5MnTox+RJ6+MfkSePED6EXny1uhH5MkzpB8l/93lxdGPyJPHSD8iT94d
/Yg8eZL0I/Lk9dGPUrfY5WFKHoaTJ28w6N8mW/JCg/caJFvyHrE/+wDklwbv
O0i25FVif+TJUw3eg5BsewTiCYn6geTBBu9HSLbkhWJ/5MmzDd6bkGzJO8X+
yJPHG7xPIdmS14r9kSdPOHjPQrIlbzZ4PjTFkrccjDulWPJ4sSf7J+Q/B+NO
KZY8YeyJPHnUwbhTiiUPGXsiT552MO703/WoG5+xJ/LkgQfjTimWPGrsiTx5
5sF4VIolTxt7SvzG5b1jH3DyxrEP+0jkz2Mf5Nl/xz5Sz8rl52Mf5G0gDypR
D41zAdgHefLqsQ/ynEfAPsiTt4998FM4H8H7gnO+gPelvhDnCHhf5DnXoM5r
WM4v8L7Ic55CneOwnJvgfZHnvIY6Z2E596HOTchzVd0hOWek3kvOR7BexX6/
zug/dma7RN4sPFrkeKX8/1BeJTh5s7QDXnDKyDwdflpt1Po0tI+vcdoHP5w0
IEe7XZvVubOToXY0ruInofbBq9Z6cVLnVT+qc47pofY1ruKHoXwY8KEuTqji
3p48w0Oh9jUu9zU6v6yR4zP7FOCt3DwYvH85LTbMrUeQB//7mb/urtPzqDoX
vz12sxsHgvHn7bH8bl0cjD9vjx25ufH0ybUS95Dy/+wLBOPS22Nvfzr01Yqt
jul9hFhVJy/3JhJ3aXLztPjCxD124CvdfhlxfPCtAf88XfB3mmQfdHUOyd8S
vIzz//l+fPu5vF8bFxcNrpu+jC1w/j/tglfudLZutXWJ/UTaZ3+K3/n/T+d1
7jD1rcR+Iv/PPhf7MsjfdXr7gY0z/zRBniT2i9ln0u0H+bNe8qbY19H6B/Nh
1seec34F45S2m9yzoPYNsQ/vR/v8PTh68vfgvC/vpeXlHgG1/8t76ecyPkg9
P9ePjG/g9LvUs1PvxfvqfT2+Z/Cuzm78Lveiuu8CPcH5vtATnO8RPcH5ftFT
68M4yHPKBPLA0wXne0F/cL4v9m3B+R75zsHvd9+vGh8M3zvt837k7dA+OOMV
7YMTb1F5SqH4v8ZVPlKov7AreV/B/I0jhvE2mKdxxNzvxmeVX2eYF1QeXUhP
jat8uZCezPP4aegJTl4l4xXjH/OgyjsN6aNxlV8a2vcnzkkeO8+Ve47c/K7y
qEPta5z25T4d52/QPjj+icr/l3Ykj9PFSZQ/Izh+Eetr1uOc/6IdcPwr1n2s
EznfJ+co3HqHc5T47fj5nD/Fv8Uf5jyvOg8rfmywXtmh2Dy3HgzWKzsUW9P9
naxzW5SQ/FLwoZ1G/fjJ+SqqXtmhWFYXpw3Wy0qNFXD7NcF6WamxW6bsfCP/
2Fwqr2977B01vmn/IZjXtz2WT41v4KXd+BY8H/RlyN8DX6jGc/C2bjwPxjkT
7dC+vu8bnoC3Vv4AOM+lfV87Uv9Y+V16nGfe1PMC8yY4/lWwHk6qoV+C9XBS
Df0YrMdyyNDvwXoshww8CdZjOWTgVbAeyyEDDzMm5Nk8+d7Mdl36rp/vWJk1
vt/VIXnr+1rl2x7LIrjtaI50Of2r6f3Evm4HJyfb2kunv/rydVniT7g6FbQD
/pG9Y2G3r/dLO+Bvuno46RXmX13uXCb7Rf8+N67smRJf6PZTaB/8x1kVq9n3
0qR98MUur4b2wUtuLNdmwJH8duPxi50OTv7bVL7/3lj2DUlx7hXiueBLN7b4
s9YzB+S54B1cnSKeC17h+t135R14jeW54D+7+4OWvzlhas+mF82s/Nd2aloy
U/xjt/+IPuDfNjo0dluTg6IPOPezow/47R/OWtZqSx7pL/Dk3FfqcaEPeN35
eVoX7Gjs/H/Go3Om3pcbksqduxTjvkj0BJ918+BnOt/zm+gJ/pHLZ0NP8EVL
bnhoQ+GcFj3BuYcaPcEnp5cvvshUEz3Bdw7I2/jxB5uJnnc0frbuFzP+ip1t
27/N43ceEj3BW7j8NPQEX3/8+E+bd2Sz6Am+wdVrQk/wJxtft2BRjcqiJ/hR
d08feoIzPqDnzf+M/2elTh16gifNG5Pt/TOZhYfgW1y9HfQEfyG9xIVHB5cR
PcFfSt/75dNZregJXv2BhTbpcCvRE1zree0/89qpWOMmf4w73i1Z+Ale67NZ
+fMdvEb0BJ+eedqgr4+WED3BP3R1otATvEOThvurdGgkeoKjD3pqPPdV3Yde
M5Z99m9D+Gv/jGezZXxmPBrxzzx+QnDGF40zLmic7xb8blc3ie8H/MNntt85
/mJlee7kf/yB06Hnapzngm9yPOe54GvnVd9ruteQ54IPcfXW5PtxeGE3vsFL
8Odc/iE8AH+oX/VFySXOGPSHF1p/jaM/eKdV/f4+0LWu6A/+jqsrhf7g7Y+8
frz5nMKiv7Tj6sKhP/i59XfsmpznrHwn4MtdnhL6w1+tP3iNLkm1Rr33gOgP
ftjdp4z+4DkfGjxgyPAbRX/wv9Ou1OFBf/CqdV8rMTpLYpwC5/5o9AdfOLf2
qRldd4v+fGcfNl04+XxGS9Ef/Po37x8xPamm6A8+zX2P6A/O/aToD14i/nOv
1tnOyzgO3sXV00N/8C3Nnnv18ss7RU+++/KuLiJ6gi9ZW3xERo9bRE/wB139
Q/QEH966xbJHCvwl8x/4XHcfMXqCX7Uk+5e3Hfxe9GG8uTHnjfdUvqq86AP+
qavbhj7g8976+Zay5S+IHwBOnT30AT/R5rNXqk3eKs9lPDvq6hzyXPAe//n4
ddP8ouG54HNdHh3PBS/bq/z4HDU3SfuMi+81XWdKD7xkaB/8W1cfj/bBjxVt
/dRdn6+Tdhgvj7r7QGkHfEmmm/dfO3G1+DMOj2+6d9fZhv/1f137Ms7tdHXJ
XDsiTztOTnCeSztOzzh60g4470U74NjB2Y35JI7daB8cO9M+OP1C++D0o+t3
5rE4/c5zweEJzwWHVzwXHB7yXHB463iOPxWH5+gDzneBPuB8R+gDzneHPuB8
p+gDznftxgH8qRjjAHqCM26gJzjjDHqCMy6hJzjjGHqCM+6hJzjjpBtX8bNi
jKvoD844jP7gjNvoD844j/7gzAvoD848gv7gzDvoD848hf5uXosxr6E/OPMg
+oMzb6I/OPMs+oMzL6O/tOPmcfQHV/5VCEd/51fE8CvQHxw/BP3B8VvQHxw/
B/3B8YvQHxw/Cv3Btf4a57nOr4vh1/FccPxAnguu/I0QznM1zrjm/F7xWxiP
NM54AY5fzXcLjh/OdwKO3w7/wPHz6Vdw1gXoST9rPcFZd6AnOOsU9ARnXYOe
4KyD0BOcdRN6grPOQk94p/UEZx2HnuCs+9ATnHUieoKzrkRPcNah6AnOuhU9
+Q5Y56KnfB9uXYye4Kyj0ROcdTd6grNOR09w1vXoCU4cAD35PogboCc4cQb0
BCcugZ4yj7k4BnqCE/dAT3DiJOjDd0lcBX3AicOgDzhxG/QBJ86DPuDEhXgu
3z1xJJ4LTtyJ54ITp+K54MS1aJ/xgzgY7YMTN6N9cOJstMN4Q1yOdsCJ4+E3
guPXIY9/iB+If0ic9c7pPWaUOfKN+BvkcVSd90v9w02+lX0K/Ma5909+rMqH
Kw1+oWddH+9zZV0fwvV6H/188lfiq9+G5DXOPj52QE/yTPi7qu1mVh1R+xux
D3Fi7MB+otaHuL/WX+6/dPrSPv1Ke6+sqf9amSlxiWci3zjWoMQXyxL38IEX
/vqh3tfX+Un6C15scv4bzwVv/PZzpdMu75H2wclXoX3w9m3XPDSh8RmJQ2KP
GZdb5JrY5QepUwdefsIbX9fYs1f0AVf3Mwres9bYATf9dFr0AWe8RR/wt1d+
ku3Ql1dLfInvo1bjI+PvTpU6m4Ln7/B43kEDckncCbxRpdzvTr+/mLQP3uuP
+lkzfZqIo/Idn9sxbn7XnneIPPiADYPLd7irpjofl7jfR+Vdh/JMiNOnu/NT
Km/fk39yLvanq9+uzoNIfSRV3z72oKtvr84lxYa4c0nqnoiQ/uxvaP01jj4a
D9YP2R6qO+GRt1qe70R/X3Ifnvoelf6hfUyNM475cPZl9D6slg+ea0sNPVfj
6j6REM5+zQ/uPKy6l8c8qO7lYb8RnjAua7+OcVzj6v4mAz9pR/tdtKNx4g/g
eVuMq7GuaEvJ8wR/OuPli/U/a6LvyQrFe/Fb9HPBnyye+p/XcreR5wq+aPT0
139M5EuD1+s5vfGIB2pJvAj8ummP3LtsW1nJ1wV/wo0P6IPfsj73ui6x041E
H4kr/P5IkZf31xN9wBe6dQf6gH++e9uj1/YqK/qAL5k38tuTtxcRfcBbZK2x
buX0/KIP/sws50+iD/jXNfZuuOeRyqIPeGqN15Yd/P0G0Qd8faVqpfZtv1b0
Ac/m/HP0AZ94zYjZ89tkEn3wF1q7+yPQB/xX80rWJwZeJ/qA7z40Y9RtO+We
YMEvr8pZqFjXJGmf+XNkyZc7ffxLdmkf/OHyKePPjU7sU4Iz39E++NuzH25Q
77nfxV9ivMfP4bn4D2reFHzF9ELp+w4dkvgb4xPzu8prjc90ea0qfzV+ROWv
6jreKi9X6oTzPDk34M4R49/wHk12V6qTv0SGzhOO13Z5wiofOK7zgXmPSi5f
WuVFS/1t9KGd6u5cGPpgp1XFim+/edq1qj5ASryxy9NW+dhxnY/Neyxx+e0q
j13qXaMP7eS/q9iYWM7Kog/938vd+6Py6uM1XV69yp+Pv6vy53mPbu78gjqn
ED/pzimgD+1MGNrsvr+23Cv6ED8++/o9RV6+rb5V5ybiL7tzE+p8hK57HJPz
VS5vmecir/1n4uLj3TlZdS5G1+MlP0fq8dK+9oton3i/nsd1HVHk9T6sqmsR
mvfJe9Hn3bR8sN5jaqgd8jf0PK5xVZfYaDt4zuVZfS5P1T3W548S9WJdP6p6
13IuRtW1tvBE1S238FDVJ7fwVtU/t/Bc1Tm3NVWdc31+RNWTt3ynql69nLNQ
deltY1WXXp+/UPX8LeOSui9AzjWoewFsbXUvgD7vgB763IS6x8EeUfc40P91
SqR9P+35sfq+Bsv4r/Zl7Ba3Hlf3Mtj7XB6jWidatU6UeQR5td6P0z7jDv41
erIuQj75h2UlHn7kE8FZJx79c0iOjl1jEvfgOaPcPT7EW/i7bydN2PZW8dUS
/+Hvhmx66acP6643yk/2fdfa/w+dewXX/iQ4PNI4/cY4jP+Hn3PUxVWQhxfM
I/hn+C2ZN1eYPvvB70QevjEP0i5+yGsFaq8zNybiDFJf383jap9O4jlqHzDu
2QeU/Tv4w3O2vLZzZfXLG2W/jPbwc5CnH37P9WGp/fN/EnnwjEF1Wt65Rvwf
aafPN4srvTNmh+SXwp/Xbu6avqTM7+KfoKe+F5t2FryzrE6Dd86IPO3M6bKj
+U1nrxI78t7oj93AH3yp261Dntsl3zW83dfw8RPvLPhd3gt5/EwZLxxesNTU
1sPzn5H3op3CRbtkn/u33Acj8ss+qtJ/4fK88t3K93JPoYNDW5UU/fFD8IfR
H5z3Qn++r9Y7p3Uonyp+uMjjh6Mn+Nrlu0ouzJ9HcNqptH15+17jC4v+yF+z
bvEt3fffIvojf0jt1+C3sF7gvcBZdzDuMQ784uLw6I886xr0BH+mRnr+Gz8r
KTjtvLni7zdPpVYQ/ZEfuKpG1Y8aGtEf+U1b2necNfZB0R//h/UX+oOzjkN/
xrlmK6Ys+fDjiqI/8qwT+Y6QZ59Czrk5+bcXDTsyd0tz0RN5lZ8jfhTrVvQE
Z/2Lnoy7zV5oNWHnF1b01P4YeiKf9Zr8Ez483Fb00fubahwOxWl9/puu463y
lEL7brRDPAH9dfvor9tR9VtCz9X7hqp+i9YnJI8+Oh8PO1yZv7aG/FsPHm98
BQ/Fk3W8SNUdDcnr+jNq/zTUjpZX+6oheV23RO0jG9UvoXwz5edrPJT3RTvg
8JPxFBye0w75Trp95m3WO3KflsP5Hnku7fD98lxwxgHkyWsinsxzwRl/wPEL
WPehDzjjGOsX2mHcA0eecRI9kWe8RU/i/cTJ0QeccR6ccYj1MnqCM1/wXNoh
bo+e4Mw74LTDPMW6HXnmO+Yn5JXfIvlX7C+gPzjzLzjfB3EJ3guceZz3oh38
FvQHxx+QOItrB/+BeRR59ll4X3D8E96XdvBneF/GP+zAe4HjL4HzvRIX4n3B
8bt4X9phv4n3AsevY5ykHfxA9NTrF8Zh5kP8SeTB8T/Rn3awP/Ksv/BvVT6b
9eSzSR6d0lP241S9yhjxefTf8c//7w/NFxqnf/V6R+yixn91f4FhHwc/UNcH
U/ewhMZbz7hqtd3UfZRxzXPm1fqu/oDad5Z8QlUfID4veH+i4PPdeXz8Ntq5
uHtTiQ1Zpst3IfWHgv6wxCGp/0A79APrLFWfIf5Q8F5Cwe909Q3wz2in7LsD
dnz14lwT3F9LjnMPpqrXEf/Q1eugHezEOlHV09D3AAr+h6svgd8m+dojG5Qa
0WWR2FnqJzl9VD0WuVeOdrAT61xVLyXeLniPnuDUA8EPo513R+d5ov6GpWJn
qc/k9FF1e+TeNHW/cMy4+4VV3R65l03V29H3xwn+vasDg39GP9T7rVyzpG9X
6HucY9zjrOo+xYa4uk+qXlOsravXpOoCxeq5ukCcf8DeP9V8+9Lg/Ym6Tzz3
ZPA+aOqGxcibVfWmYrrelL7HKnifyPqQP6xxvjedvyH1wdQ5a9rROO3ofVva
0eegaUfjtKPHQ8YpjeOP6vu41f1f5iVX1wu/lvGwy6c7xyx/7XuJ3+pxUt1X
KPWd1L2Eci41eM9IhoHP6t46qU+Ff4w/udzlEal7LS3fo7q/Us63ojf+HnE2
9Jb76Nz3qO43lDpO6CHnq3Y+UWfs6j3yXrr+j7qf1B5152ppB/+NeGBwXkuW
e4TV/ZhSBwk9aKd9m7Kby7z+o75n1jKeq/tk5Twv7Ygf6OKWwfrMCX9S3X9q
z7i6QypPRvw3dV+wZb5T9wLbE+4cMe0wDxNf5X30fdDqvlqpC6Tyguxm56fR
PvM/cV2+R/ETp3z+dv+1m3TdobhqX+LAtK/OR8d5L+IsyP8xLmenVjlm6TpO
cWVPiSdjT3UuW+4FJj6C/NXDWyXFKy7UdbTiij+sI+LwR50Hj8Nb4h3I7y96
46YK6Yt13bO4+l4kvs33os6hyz2zxCnkXMD41m1O5f5K16+LqfGB8zsxxgd1
Ll7uRSVOgXz2HN99m/vVb3Sdw5gaDznHFGM8VHkvel4Ixe3xq7Xfq/zk0Lzg
yasJxf+VXx1a1+t4AuMz4yXzqbr/Uep8cr6e8Yx5Wd07KfUeyauWvHiX14o+
Oo9F3YdrlP8guPIf5HwA/oO659Tgn5Dfg/ymzuc72wtbRR/Gob965MuoO76l
rB/Alb8k5yfwl9Q9uVJHkfdH/kSmV+yYiRvlfeTe1KAfaHT9Rsljdu1sO/ba
qPczfhb9mRe+KV741iarrKxzdJ069CEegl+q7lmW+oQ8D/kqC9849vHExHqT
8f/UsFwDC+Uto+4bSrHKP5f9B/xzdV+2ZV3A8yQO7c658Fy+s/q9Fjyyr9I1
cp8RuFqnSJyPdQr66fp4an/ENnPxBJ7L/DW91rCqe6ad0ffdW7Vek++e9Zq6
R96yTlT7RBIfUPkzkh/L3zN+kG9D++ANitzR49kb9sj+Ee+xq3rZdl9OPyQ4
89F3SadfuK1Swi48n7wg7AZ+0Oxts+Lwz6IPOHlHEr9w81GJmp0a9xpdVNpn
vUZeE+2DzzajKzb++LS0D07eFO0zH6VPH3dy4eDEvYesv8jL4rng5HfxXOad
I9smpRSuUFD6CXnyx3iu5Nd/dOf67m81kOeyniI/jeeCk+fGc5mPbsmUqcuS
J2+V58q5TJdHR/8in+WvrM+MXVdb9NH7I+jDOov8PfQBJw8QfZjvxq+qU9xu
vkv0kf0Ul2eIPsi/6uLD6KP3R1QcW+8vyP4F+ZA8V+9r8Fy9r8E6Re+n4Odp
efluo/dHQvsXfFd6nyJ4/0hoXRnC+c51O+B6vSn7xyq/V+6tjl6HhnAZX1Q7
4L46A/ocAc/1rFtDOO3rdsD1upXxUPszyo8K5TPo/Rf4pvdZJL6mcPwrn7xe
/yIPDv/x48H5jmhH77/QDjjfNe2Aq/FB9i90Hr7Ud3HjEu2Aq/FN9hHI/6cd
cMZV1hvgnC+gfeZPNW5L3J7zC5In4XA1LwjO+QjWIeCcs+C58EXNRxKH5xwH
zwVX853gnBOhX+Ad8yntM65wDoX2wZln1TkXyYNV+S06T1XWoSoPRPCdrn3F
/9B46xn3QrgaP0Nxcs93EcJV/q3V+bd6n0L5J5b3ws56ncW4NPgff3lvaJ9a
y+OXaHnVfmjcu6LXD6H30vLo7ZPX+Vcq/zO0jtP5QqoeQvw7t17DL6GfM7er
eOMHlcbpfbE4fqyqzxCf5+oG4GfQ/kttMrLna/6RtC/5+M4PV3UkpD4A/gHt
J/94xe+lff6OdYSqgxGf4877M9/TfmrecV8NWDovUafJ/R3rIOTBWWep+h4x
4jPM6zx33OIO/T/LtVhwnsM6UdUziS1wdiCOTfsXP7wSrwBH/pjTB1zq1qjz
njo+gB01TpyW9dx5d+8POPMF8Q1w1kMd3fpa1cWS87DgUofExWHAWd/kP5Vl
wJA6n+q6Xva74PlWibcRLwJnvpi+Z9VjKWNm6bpkdknwvKrE84hrgTO+1rj1
uuztz0zV9dP0uVSJBxJ/A2ecv/xHqfR+RSbqem52SrCem3ynnD9V+7OSH8jz
dD8SL2P8XtFh4S8p9QdIXE7qk9ikMx32Dtf3PsS490HVt5E6FaqeZKyEqyfJ
+Xz4udHt/zIeaj0lzqjw4P3XiXNq2MHjJ4fqIiLv8W9DdQ7lfKbyJ/E/9fiP
/fX4j319eUp6PsXu9G/TAw+XvLD1VYnHYr+cr+R/+LY970r8E33fqfPpsBuW
j5H4Ku83YmSLZSN+GSQ49u629NsWd349SuKujAfFNmy4u8/EyRJHxQ9a0npR
nxxDRwqO39T8r3OpZTNPkngp42qeN8t9/9Twaer+suT4tpEZnXMfHS84cdrU
O49Wm9NimsRF4Wn3SdOSCrWfr+/1iL/h7vVQ9Uhjqa4eKTzETs+8nO2OAo9+
LvK8xwtuXFL3E8U+cPVjGVd5v1uCceZEXNDF2fhd339EfI9x1T5Xasym23+V
+B4/aUd+V/fm8PeMq7H9h8qcGP2LxNnwB6o++nb7lJzJsv+k73lhPOUnzyVu
xt+94OqNgOt7SRhP+cm+UrC+brJdObPT/mlPZ5E4gL6PQ+Xfij7BezlTbN/9
Dwyb3ELOO8n6nnsrVH6y9gNlnyX3gSt1adR9EHHug1D3TMVec/dMwSv4ULdE
n10XT+7U59f0uW957jl3D4WqTyV1mVbcuvXqWSXkXqFQ/men/L2H3Lg6cZ4I
P7Bb6sV7x09N4HUHbpi9onU2q9tBn5QKNV/r3iiRj/pF5XWnqjfIGjpPfa7w
+l7bG2W1Gp91765C19YOn6dmfKk+otzAd3ckxr3kb0bsXdYicR8d+ItvPjJp
7Bvh+wsYX9IfLXgq+8Y/BT9f7fG2T26W+tKCf161bOcPa8l5XsFXFD/53oAZ
SaH8H4eH9lPy7po6d/PzSaF5x+Ghc9OMXyMX/D14dK9VgjdsmdyxQ5Ok0HzE
9/NxtHyoHi/t6HkKeY2jz+Qr7Rv9XvpcFfqMipYPncNS9tR46Py16hfj6Uej
+/2bL9ePe33hn8bDEy1vHU+Mh29G87Pxj5P2Nl+UOJet+KzlreOz4O57CZ0v
k3OkfXdtvK9uCLfuu0vY7cr3LuOz/t7dd63P0Vg3Dgh+tW3+xsYp2eyMn6s8
O7pIYhzo06bM/CLNstpHF569PLNy4vt997er2u3tm9nmbFSg+7ozie+x7bTb
qm/Yk2wH5ur8x22vHxP8t1nDXlz8RLItV+zarh8tOyz4mue7HT19KCle7uyi
DTNmJvy3fpu/s5P6JsUX3vCBXTNih+C1CtbIkvxBki356qo3aj37i+CvzG7Z
q3vTJJs6+/O+pxcuF/zU7a9Xmts9yVbffl2FEk9tD30XyztmPXC65LLQdxS/
ghvVTvyuK+0Y9dz4gSvPNUrPuNPTqPeyn155L8Fbj72vWLeU5HiT0V2b7Zh6
QPCr1i0qO2ZRsn2w/Fv18/Q8Kvjpkp9P/+axlPh1Zy+1vv6NRN3URzplu63p
VZltpyob96ZXTeSBP1Gvygcr8mWJP3mp5KcvXZ3g5623bqnb5O6sNrni8i2P
/JGIH/ZtsPnVHCez2udr5r6phknE7VX7MY+eMfVe1r2X7ner+13xwSj+xB1/
tH3i2j6Oh3HHQ8F/LfJ50gdHUuKN+3bomBY/pe0W13bb2WWCKTgnS3x0iUU3
mgrh86HVG+c7P2Fbwj4XvyrfcPzqrKFztX/seP7xw19nCZ2fdeOG1fMg/smz
731Xoe/ExP5CtVp78+f8O3P8m+ybl6ZWD82b1o1Lgt/aIfvMmRszh/Yd1PsK
/uAPh/afOJQS73Hp3MTyqxPnKVofeef8+81T4q2fbvXZix8n6qc1Wvz6c//5
U+7t1fOy1fMyflhy5ixv5no9Ia/6S/Mqrnml+KDnfevGf8H3FrncM+etcs+1
4H/PKFLx8MtyX7bg+J3l7+9QqevQ3wQvf+TA5GfPM4+naZzzy3r+iuv5i/WM
a98ofUL3sLv5LnQPuxpXNf+t5r/rR+v60Sj7hO7jZv3m+ssonljHE6P4ELpP
2c2nofuUHZ+t47NRvA3tm+AHu+9CcPd9hc6ZOv8zdL+q+05D50+d3xvX8yl+
vvveffbRfmbo3iv1Xeh2rLazG3+sG3+kHTeOWTeOCZ705eid5RunxIstWLLz
RMFE/05YlOlUteQs8cdy/7n5xS0Je7pxPu7GeT1fWDdfxFQ71rUjuJuPrJuP
tD7W6aP9h7jzH+S5zt+IO39D8DtPnT+b5UDW+ImDS8vVfTgx3rr5K+7mL8Hr
XPXuPYOnZol/+cuOEm1Mwm6KP4JfPv/V3NeeyxwvcfPCNYNyhdYdofvXmK8b
/5/nNT2/28ZqfmecqaDGAaePdfoY9V7WvZfgP3/5d/ah7bPEL9f/qty4kn9p
u1lnN8EPnku98PWUrPFc05euKnJ3gv/vf7H2TPHh4Xo+mw6eH/HYn+F6FJdO
Xz9lwa5sdtzllT3TOyfw8QOrFph3InyO+4V8TW5afDabHVR6yyuDxybk/+5f
6rG378tmf8808vO/aibWm05P6/QU/OM82SZ8cU9We+Zi2deqHkv0+5IF2e5d
mPHf9f66q55fWSmBO/tYZx89f4XOD6p5zajnxt1zjXpu3D3XqPeKu/cS3Pnb
cedvW2XPuLOntlvc2U1wNb/o+SteQc1fyt/Q46rV4+rzDz93sfJ14fwNqbNw
ZZ0SU/wJnVd17YT2l31xCV8cwzcO/Nu4xP+rccMXx/gffloovvFvxx+f/+bj
s8+v881fvriKzw/0xVt8fp1vfvy3/t6/5f//GLdD61Bf/Me3PvXFf/5tnOd/
rE9D8RzfOtQXz/GtZ31xHt961hfP8a3jfH6yb/3r85N9frVvnejzq33rR5+/
7VtX+uJOPr/a56f51vW++JXPP/etc33+uW/96/Pbff6bLz7m8+d9fqkvXuGL
s/n8H996wbeu960jfPO7zx/wrTt8/q0v7ufzx3z+m29d4/PzffOyb73j82d8
66Z/6+f4/EZfPNPnF/n2NXz+57/1b33xUt++ic+/9cWRfH6XLy7nizv5/Gef
n+bz63xxYN/+zr/1z33xMd/61xcf8/n5vjjbv13n+uJpvvibL07u28/yxVd9
cTZfHMAXZ/PF5f7t+t0XT/PF33z7Ar79OF882Rev8+0v+Pb1fPE9X7zaF/fz
xbF9+4O+/Qvf/qBv/8K3D+jbB/kf+4Oh/Y7/sT/4f73f59vv8O33/b+Kn/j2
DX3xUt8+i2+f0Rdf9e0n+uKu/zYe+D/irqF4hW8/yLe/6Ys7+fYxffHbfxtn
8MW1fPtT/2P/NLRP6ouD+fZDffuq/x8xFJpu
        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJzsvXdQ1Hnb5f3U+1bNjGOeuSd3m3NCoMk5g2IgGTBiQsUE5oRiwpwTZhQx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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnXW8VcX6h/c5Z5999t7H7sIO1GshCIgoihgoooKFgoGKgRK2ItKCdBio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               "]], 
              Polygon3DBox[CompressedData["
1:eJwllFlI1lEQxa/f55f6v0Egmb20+NCDaUKL0kLbSxuFldECRqWWRalRtNJC
FrQvtC+aWlFQtFiBBQlFVmZkFFSm7VnQYj61IFn9DvNw4MzcuffOzD1zk3KK
JheGnHPZIBo8Cpwri3KuHFyAV3jnfsc6dz7OuRPwWSCetZSIc7Phm0ESG/9h
b4H3BEPhycT0gJdyRg3rhZxxD34SxLE+PMa5+/Aq0JUE2oh/Bk9kzy/Wl+Lr
Av+LLxc7j/W38A34PmBns14MPwXaObsV+w7rO7ATOjh3CHsnfC2oIz6RHNbB
C0EtZ30CRfBy9jSw1o98auGVoIm1avAEfi6wXhSDevhr0Bi2GlTLG9CKPQz7
NHw+ZxYQux0sgM8DmVHmy4ePAcdjrCefic/EPkzfq8BE+GiQRj2XyH8UfDfo
i51O/B74Qm9nnwWLvEFcNRXA14CO0Vazatcb6a0q6MkceAnI5/6R2KXwi4HV
qjfX20/D15n7EsB0+HiwylmOE+DZoFPENDATfos99SHL+SV8Lr5ecVazas8F
qRHz5cF/BKYN9fAnfDm+y6wnccYKbz1QL+I5b5J6A9LhI8j3iLc31FtKA+u9
7dHeK9gr4ft1B/FpxB/wVoNqUc4z4FPBU2c1qlb1RL1RjjnwcaCZXJ9zx0Bv
mpf2pTFprZqcU+JMo43wQfhexJqGpKVv4Dvnv8E3xFsOyuUxPT/obUY0KzXY
W73FKPYu/WgJzKc1aXibtxnRrMSypxV+NbBZkUal1QxiHrL/IHeWBHaH7lLP
DnnTtLStmsZid/d2lnLsBi/zpgXNeDn8OvHvsRuJaYB/DSw31TjYm8al9WZ8
dfCbgWk1hfU+rO/yNnvSrLR71NvbSXPH4LeJbwmZZqQd7dFe9VS93ehttvWn
bIKfwZcVsRl7AH8X2CzqT9DfoD9Bf4Ni2uHL2BMOmaakLc24Zv0jWAyPgKaI
1ahao73VmkwO17D/aH7ClmMN9hJve3XmUnh/UBm2nqv3A7z9bfJpLQVkhOxP
6w3P8qZlaW6KZsmbVjWjq+FfAtOa/oRXgfVUvdUf2gZP9ZabztTZNwL7G1WD
atnr7W+Q5vfB/wPyFM4M
               "]]}, Annotation[#, "Charting`Private`Tag$37609#1"]& ]]}, {}, {
          
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             Polygon3DBox[CompressedData["
1:eJxNmnlwleUVxu8N3Jt7v1cQFJ2CiIBhS4KotVOXKu6K2tZxlCBi7VTADe3U
3Y79q9VW/7Rug0rYROyIu3ZUhLA7LqMorVUgKKuCQnLDEkLQPj/Ok4kzufOd
+97zvds573Oec94M+cMfr7itKpfL3d8jl9NfbkQ5l7u3lMtdUMjl2nrmchsl
98nnckOzXK5Z8lq1rS+FvCYXv2/SpyJ5t3+jfY/fpf1b9fmV5F2Sl6rfBg14
mj6VntG+SgNnav/aOtvLIX+i9i+k8z/JCyXfoeeX+nwqna3lkHn3R8k7JB+j
PtvVz3eS76yK5/f6PCJ5cSF0GHeznlv0afM8+d5Xa3y0mMutYwy1bVOfayW/
IZ0NevcotU2sijZ0Pst17wVrfKIY+8CeHa9np/obIP0aye/q/f6S1xVDPpUN
l97LkgdLXq/2Jrdvtswe/ai1vSR5kOSy9JdLPkPyJM0tq87lHtT3fZLLkh+T
XJE8SOM9UIg9GSF5ieSLq0OH9j3V8e7j6OtZdD8/SH97KebcXIz3Tvfc2Dv2
rad84Drp16ttlvT76XmK5rVJz0XSGS+dpO+veF05y8dJznu9Vd4H9H/pdS2T
/CuPu9RjbbE8oSrmNrwU88h6xp7Q59XlmP/dhbD7Tun8syr2mLWwn/jxXZIv
kz0mS3+0Pvfr+0E9/8wzH2uZKfkx6ddqjXdLvlntz6l9luTX1P6M5EbJOclP
S57BPkvn2FLID0oeUgqdHyXXav5/kfyx9Cdnca7u0fcLC/H8tXQuzuKsMdbN
km/S51rpXVMOG2OXjflo25QPu9G+XHJf9d+id1+pinXv8trH6HmiPnX6vd79
3yL9k7OYzyfSOTGLtf+g9m/1vE+fryWfkIXMmOcXYh9ukny92oeXYx/3e5/v
Uj9LNMY3kudK5yv9vsbn9E+lkF/PhT9+Y5+kb8bD917Xu9tKYbuBpZD/rn4+
LIYO83k+RR//0vPJYpxZzuthemer5NUaa2c55F7S31mM844v3F6KeYAVYMjt
lvHdUySPVVuj1vWm2mbouVSf17WmoSn26ee23fvVsZ+PV8W5X2t86GNseEKf
6Vk8n8pizNt/gld3GqPAOuSWXDzvsMy6B3ofxmmsXj7L15Vjvw7tlea0Wrpv
pMBC1sP3A+p3in7/m9Y+T++1uH2x9A5TW1MKjESftYNvzH2NMfk0vwN2gWXg
GDg/JAtdMLCv18s+n10dOD1Tv/XR80SNcaHajpdcK/kptfcuRLx40brgOTie
CjGn1ixwd6TmtsTzXKrnRdIfJp06fX/TMjZ9w/2j97b0WjWXd/RcoU+N2lfq
+bTnA4Zv6RHtXfPBX2jHf4hPjP2k2yvew6ukP5W5Sb4SvJQ8pxjYAW5sU/sI
yfWSOyRPlvzXfLyLPMXvjpd8g+UG9wnu7rZNO92OzkHJEyTfKLlimfa13ivW
PrcYeAFWtHiejDW9GHGGfT6yFOvCpsRM9meX4xE6rZK/K4f/4W/E24p1GGu4
96rFa2fOI8sx7jS3XyH5IslbrY+N1nlPkDl/h3nOtCP3ltxofxgj+ZLqiKPE
UGLpBmN+PziA5Ksl75B+M7hjnY3Wf1s+cxYxQc/t0llfCPy5tDp00D3O/aB/
NDFd8jWSV/p3xmIO6DDme4XQO1Ptgz3WNe7za8vE3xcda4hTCxyLiWu05yV3
luPMziGG9gidY/3uC4WIFz9YHuT1LvfaGZ+xmEPmOIgOcQecAqNGOU7RPzHi
d8b/y6pjjfRRSiG/o9+3Sb5KfXyj52+lc6AQe1Ol3xqqI2Yv9L6x7sslH7SM
bq2e91SFf061T87QO70kn5CPWL+uEGNMd/vhap+UhT4xsdO4hC9tse16pNh7
5oKtl3ncup6x9hXeh82273hzgGZzoWSbnel9Qz7Ur/qfoL6OLobOqkL3eDw3
6/dvPec73c8K2xS/WPmT/V9pu7DH4O/jxmG+ExNvzCI2z8vHeMQG4sJD+n6M
bPSwnv2N58SyIZrDfYyp565ytP+DM1uM9bP2IeYLxLuvUvDEr1PEe7gSPtZR
Dj7ZrM9ozWFGOfwK3nGsecggy3N9fo9x3L9N+rfqM9hcYID5BrG9v+P7emMI
eDgiBUbOzgKj29w20PrMn3g+yGPBdZnzAXMh2udInpLFWOxNm9Z6nOSlWvcw
c0zWM9ScHQ4GHztQDj/vKITvHmefRL6Xdwrhr/jqIvsgHLLJ/gLfw78bbBfs
nHzGl5k7Yt8jrYOvD0xxzvqm4Kfw1MHmkPTN2sBM4iRx/KDngF3BALAAX1rE
PoJ/+TjrnH/OMm2slf1Zl+L39cQvPTfnw86LbVt095RDbsoHbhzCknyMu8z7
gD9ea59s13NvOeILvAn+hN8Scwbr+wfF4KRDzF3h9eQFA6sirhIDwH94dGt1
Nw85AFbmI/bDAeBJxDdiFZhArCDOTTVXxI8u1ednpYgbv8lH/rfHcWpc1s1/
4VhwrT4pODC8klhLnCHeEOOIXeAK8Ys8pUOfZ/OxJta2VPKnWttezxNuTG6z
zHKb8xr8rs3t+F/F7ay34j5ZXx+vkVgGb4FbwlFbrcO+7nHeBN7vNeZvd16C
79U6VhPvehsvWTu5yzD7Olg+1HnHCMsDnZ8Ot859theYUK/n6FI3ZiDjA1tS
+OfWFP7FOcTH+L3eOvQ9wn1yjmjH5+FWxGliN/np8T6TzHG45T6O23CnUeZB
rAe8H50P2+zLggM+q+c5heBJ48CfQvgCeuxrX3Nl1swYXfOtMXZw1mo8bk0K
O8DN+zlWkPNWzK/onzwePyZPJE6Sk+JPbaXI7ci9qvX+PvP881P443617U/B
6ztS+B15Df5LfnRSFrz/HPi2dI5IETfAFmLHesciuAdxidwUrnJQejvhGlnk
i4zL++SUu0uRPx7hfI0c7W6PCw6DyeSGYHUlRa2ijXhRjJyOfIs1sbZX2Ydi
yKyRfJz+ycHpu7UU+eAq4x44NiyLdsYnVlZKEXfwp4rzGrARfgNeLbIvjzeu
ssesmdh3gz4TnXNf7TgIP/l9OXJJ/PY649KEcuiAJ1Oz+E7soG2C353kXBc+
Q15Ofk5+epPHASMZs0Hyc/noZ4q/1/tM4M+cQXwI//kxCwzfmAW3Osr4v8G8
D/ynrkBtY4JjRGYMx6c4i/z2rXnU9hS5/wvmdy8b84nNI+2/nMOZ5YgH4D75
9Zgszt8O4wNncL+57aPO2dvNY7Ed+Ty+AW+CP5HTwenerQ4u+lmK3GNNivoD
XAuO1t9cA/wd5ZjLPtdlwQGIvy+myEdfSpGvkLeQv5AHkKeRC5BzkGuRZ4F/
tK92/Y3ckrwSHAVDwU/O+zvVceaxzcp82Gu+Pqv8vc5nE//EzhNt67F69+3q
yCdGuB+wCE4KN53o2MR8iE8dbh/s3J/8kFxjuPshfg1zO7iGL4MZxM4vU8Tm
tXq2lCOuzs4HDo+y37b63HH+qJ/Uua5FfBllTsJewqumOZaN9JmlVjDaftth
fsv873c757TT/Bo7Hp/FWcQH7vHZJ/bNcsyHC8BhxvhctxuvwK0Fevd5+EUW
fAS7wEna1EdrOWoscNDnbYfp5VgrvvTfFGN8nsL2tM/yOW3weaTOMcaYQNwj
/nF+b8mC28HrHnLf2BwMA8vAzyNTYO6lKbD6PLVd4vMLdtA/9uc7756Uog5z
cgrfuNFnnlx1Rzl8jxoz3JTaBH7N2ce3qU/cZk77VDnWyRqpv8I54A7YaLI5
B3WjzeYirHeqMWSicWWF43Vfx2542CLbgj7oC1vvdy4AB7jW+AR/m5tFDaJf
Cm4C54KPbXbfnAU4GDgChjR4H+bZf0523FnpfWV/4UXXmxs9p35v1XN+irVi
D2yxJouz9rKeG/KRJ8AdqVFRu4G7wYX2e87Ugqibf2FOhw5xGdvSJ3kEMZD5
4M+0TXM7+4zM+Ld6/7HLavvkAs9lvv2P+sOt1hnsHAQux76B7+wLe3lz1t2G
vNx+cpPlZ732eSm4Rx/zEM45NYZ6n31wAkzAH6nh9je3AocHmlNR34RX4Utg
JfG3d4pcbkwKv2Ku1PbBt63mSGAc41xibsP48CFyMfrcaI6E78D/1pvnN6cY
n3gAzmAb+D22Ak/q7FdwAOwNDsz3GXvYeF7reZLzjfZYTT67nGH8BpvtNLc8
0XGnsRwxiXgEL4WnwYE+d3wkTh7KSezv5HTUc8EQsASsxMdqssAsuMdux2vw
n1hH/+Snv9A6Z+v9c1PkIqxxide72PPt9Di0ca6HusbIng+1n/TzvcJjxska
YyXxYovzlE8dB4mHe/SpJ/9J3X1hO/xqv2NNf9sa3IA71Xgts4uBW/BU+BE8
qev3YR73NtdCmdvLrr2+koL/tzvnIjeklgoej0qR/1yQAhuvt+3wkdH2PeJv
h3OcWVnU74anOFucsQds1+ne/7dc86T2CS94ylhH/KfmQhs5FbadZj8Bk7AL
XJRaEhx4qnkFudsUcwByN7Aav6YOeaXzL+qfYAc8nLoitaN8FlzrzRRr/bee
Xzi2EmPhQ4wL5hHTJtu34Sj0zf0IXBXOWm/uCR/l7G3yvPHt/2TRx2tZ1Ewm
mEN+kUXNa4DG2piCe23Sc63rP8dI/jCL/ccOC4mXan83RawGw9mnV41TYCfc
hPkQZ7HVxbbXHPvzeSn6Zp5wZvaAveiqMVR5T+5x/srZv8vxEHz4LkXt6fsU
tRp4W1dd7WnbepPXsjkFx3zGtR3O/SjjGPc4deZ24513kwfNMzY+53O3zz75
qu8LXnP9n7uGVfadScZz6jm7vLct5g+c2YplfA874T/kL/h8p7GL89xi/U7X
bWjnSR3noM97h2V4CnGHOXDnwHmBc1Ib3+d+OtwP+uSg3PkNMKYdNAcjl+Ve
Ey693Tpwa97rtA71p4rnzzoq5W5Ma/NYcNvvzTHgG8hwYe43uOcgjuzwWOQE
2DiXRV0057MARn2UxZmbb649zbjN3Rf3QHBuavLwae5Avje/YdwdlqnJd30n
nrEnbZ4zWLvb3Iyca7exd473H5zA7u3ef84KNgXrqGOwFsZmj/d67cyH+3Uw
ZY/beZezQjvzxNfqfX4HOE49ZJxscS7J+6c5d2jyPQ73OYzHPtIP+fKdziWb
neuQS3I/c6F5OzkaNXfyNPJaMBh8httf5LxgmGViPPpHm0snj9XLc+Nd8l9i
Mfc3nEHqWOPMyTpc8yGH4U6ceEcdaaPnQJ/cx8F7yamIm9zBcK5Z8y7zdvLy
Xc7XLvBY6FxofbCYWhE1I+pOSzweNqUGfolzHGIU/Iw41eZ7efTPM/4QV7Et
Zw8bVZzzgkXMYafrA3t9b/iVuUS9sQI/zRmjWn3XTy0LP0LGr6hVzHKdhFyF
XIM9ZL/G+d6ql/eQ/jd4/uTS+OrFrsUxB/KlOc6BOCvUbl4zFnGHyd3sd857
4cllv4u/Ix/CAedK1K+IFzOdB4Gps21T8oCpjunkf/ADfAm+do5rRHDsKfZb
YtrZhYhrWyxzn7XcNYEzXPfgboOcv8X5IHnhpsz/y5Ci/3PdT6tlxiJ/Zdw6
9z/WOtucB6HTngUHOyqFj9Q6Zs+0DHdc5zlwXvCpUY4prHukY8qHKeb+kZ7v
W/4gxR0NOtTcGv3uCR6PcanVcR65X2lwDYT/tzjdtT7mwRzIkbg3hWdT1yH/
/dRzRIe+RtoWcCfGafS78HPmMdo6yMyht3WQ2Wf+/+NU19O4zwMj2i131dZ2
WAbf11u/yfJprtU0W27yuti3b1y3oX7DGrd4vfge/x/wiOsw9H+3x0KHWhA1
mJ3F7v8hYZ7Udl5I8f8NC/Rcpc9bsvd7KdbFXpE38r8BcFD4Jz4Lj8Vvm90O
j+L/Asi9iAt9XAM/y/3VFLp9E3/FrldZhqed7d/xK3Ip8ivyKXJo4jR9kf/S
zj0OOS/33NzfjE1R0zjc9+zDnS9RX0mWqcOsc57zgf0KXzvbOuA5d0RPun+w
CO5GrYD/Z6j4foQ4T7xnncQT4gqxAn7XaG7TYA4DFx3rPIt1URsm/hPf3/Y8
+Q1cIFY1+VxzpsmT4cy3ZN11DuoacGN4Nnybscht4Z5zzf9rHSPO9RwY91yP
wzmlZkNOXuuckDUuzuJ+vmIue55l9D9OweU/SdG+zXwaTBjh79RVuCvEBrtt
LzjVdW573fXDRudT8AQ4CntKTesw22ZRFvdO3CsOc37Emnhvht+l/s89wZGO
V0fYn8mT+nrt+HhfnwW4U4c5ABye2ib9MOZq59gN7g9b8/9cOdeWr3Iewfob
nF/gq+zVQduXM91uHgA+TDe2THK+wzvUa2g/PN/9fxXYkZoJ9RLuv/ifL3JZ
6rSNzmuxL/ftP/iuDY7NuNi76+6QOLTaOSO5I/VU6nFd/xuQuT5MPRl94g7x
lfu2+9w/9URqicn3uduyuH+mxn6W9yS5hkz9rJ/3Ku9cAa643P1Qf37J4zJn
7jY7PO5O7xX2wnbgFHzjcs+ZsRdaH/4w2PPk3R3WBzPzKXJ8cv3/A0/pvLY=

              "]], 
             Polygon3DBox[CompressedData["
1:eJwllEtI1VEQh8+93fR6podmSK9FkUVQi14QQWhFj0XRQgpaB+2yNm1at2vZ
JogIjAI1LbOyzBfYw5JML9lDlDLz0cNM09KyoO/HLH7wzZn/mf/MmTln1bFT
JSeTIYTDKIUWWQgZFqbTIeyEP8UQ2rNDKMgKYQH2WpSPr5tv18DNqGtOCPMS
IbTAeaiYQFv5ZhP8m/2H8G1EM/APlAcP4t+B/xkaYv9+1trhy/jriJ2Lf7W5
xBdYu4hvEHsd9jZyHIIr0R183axdh++j7eQ7QQ718E3USPy3+GvgP6iTvVuw
Z+GFaH2W16ha92IvSXvOe+AG/XNuCAfx94hREfvbWEvij+gv3IR/GN897PGU
56BcHqoG/PuwH8HZqCDlMR7w/RfsI3Af33yFR1g7k/SYit1hfjYl2C/gItWb
9JyL4ZbovTlK/F542PxsFHMEnkTn4Ty+mYLvqr/Bc6yDr0XvTS7xJ+EG87Or
Jl4jvNm8l/pna/SaVftK7I/Yy8zPRjWptsXoUpb3WL1Wzsr9OHYn/A19xn+a
/WNwt3pCf87ifwUPsCdBrCT+uugzolmZJOeJ6D1T78bw/4PLUWnaZ6AC3o2u
pH2Gd8G3zHuvmmvh72g07Wcybj7DmmXNXCHcaj7L6pl6N60YSZ+ZGcWOnssU
OY7B5ehEwmfmefQeqpeqcRQ+oJ5HvxMrzO+U7pbW8s17ot5syAnhp3nNqn1Q
5wEH87PWmSTgd4qPbxa9N58pzVYh/3wMv2TPE3xtqBa+HT2W1uSrie6rQBm4
Ep1LeA0dcDUx+nP8ztwwnwnNhnp6NXrNql1vQBncZd5b9TBjnpNyW0rO/fAv
89p0hjrLD+Y+3eEBeL7uX8pnvlm5m9dST01t6p1mnHjNqMf8jumu6U6msZvM
Z1VvkN4ivQF6C1RDlflMabbK0Gu4Knrtqlm1Lze/O8pBufSa/0tn3Ae/Md+r
HJTLU/Pc9Gbp7dIMa5Y1U5qt/7X30U0=
              "]]}]}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwd1FdsjWEcwOEXVav2XsWNC6WRELu3tGK1qFWrVou2VNGpw95q1h5FI4JI
CBISglASxIWImJdWuMCFFc9x8Zzf//3anO9tv/ecHuk5Kdl1QgjdvFRGhxCZ
uza21gSmUcCoJiGMZgxjGUcyKYxnAhNJZRKTmcJUppHGdGYwk1nMJp05zGUe
81lABpksZBGLySKbHJawlFyWkcdyVrCSfAoopIhiSlhFKWWUU8Fq1rCWdaxn
AxvZxGa2sJVtbGcHlexkF7vZw172UcV+DnCQQxzmCEc5xnFOcJK7/udf6oZQ
3TCEpvVCOKVxWqNJekYX6AbPKEN7NLI3c7LrmdZbzAt1EYvJIpsclrCUXJaR
x3JWsJJ8CiikiGJKWEUpZVS6T7luc58K7WK/283x9rHa+pd5jfZ0fb4m0osY
fvv77rjeV2/rLV4Sbz2C4cRw07U+ekNfkGBuRHvaEc111+vrNX1OlPmq9tY4
enHF+hmXucRFnnKBx5znCWd5xBne8Ze3/KGGh/zmDad5wE9+0d19uvHd/IOO
5m/6mmpqI8+Tr8T6WVc+mYfqZ+2gH3WIDo6cB/N9kswjGcQH61ckmt/rwMgZ
0nv0N/djQORsWe/1Gc3wjPI1Xadqmg7TVI3VtVH2oeesK8x/GniO1qXmztqJ
jnSgPe1oSxta04qWtKA5zWhKDLYRbCM4DsHbB28dHIkwPfK8tMrFqMh3iRdH
ItT6xXyzI///e+cfQLaMYA==
            "]], 
           Line3DBox[CompressedData["
1:eJwl0bsr73Ecx/E3Cv1+uTuLS447g0SZnNxNtrNZbRZG+Qv8BVKUu5IoHZfB
KepnZRCSTDgHk8LgsvAow6Pn6/Pp+/ssv8qh0d8jaRExzkwiYkp3uMqOONWf
7p40z0dNDDDMBNuZESv6kRWRsiv85tD5yL7WT8rTI9oZZIzw3qTO+3ZLF/RE
F3UpGdFLGz10U0gXRQxQRgEttJLyXpXm00EneTy4z9VmDuwrSu0c9u1KTXJv
J/ROs/WvXlJiZ7Fn/yfD/qfpequhaVzYn9ywyzlbnPKHMzY5YYN11jhmlSMa
vdNPH+/Ob/ywX3WFF5Ypdvesv/RJG7SeRfuRBeqca6lhznmWans68f3/fgHj
10IS
            "]], 
           Line3DBox[CompressedData["
1:eJwt0ckuH1AUB+DLoqbEE1gQW4nYegRLK0sRi24QkVix9QQeATUrNbWGmmeq
f/Os5tasagzpJ7H48jv35p7k3ntS8oqyC6NCCOUUx4bQLgtkdUIINXyiljrq
aaCRJppp4TOttPGFdjropItuvvKNHnrpo5/vDDDIEMOMMMoY40wwyRTTzDDL
HD+Y5ycRFlhkiWVWWGWNdTbYZIttdtjlF3vsc8AhRxxzwm/+cMoZ51xwyRXX
3PCXW/5xxz0PPPLEMy9vb4vXHx1ChpyX+XEhlPn3NnWqvUpZSg6ZJJFu/9Ww
cp2NfHBv9XOMP1En6x2yHlRXyQo+kkUaiZzquzLfEmcj7/P+D8nfYk4=
            "]]}}}, VertexNormals -> CompressedData["
1:eJzcvHk0ll/7N4wiU4kyJBEiGZJIKmw0KTSHEGWK0qAMIYoGMxkSGTMPITKV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         "], VertexTextureCoordinates -> CompressedData["
1:eJyVnXe0VsW5h7FxsUQExYINQ3RZzlWCWK4RBwtFxSDYEDEBWy5ilKBRIxEx
IoYkKFGDHSseMEQPzVAEqaIQpCsi0uQAh3JOTDRgv1zvPO9HHtZerMs/33qY
vWdmz2/PzDvvvLPPUdfc0uH6XWvVqvX13rVq/e/vtn+ntrrvmrP4HXvJqtvG
lz+f4Drfn7lyXPmI4CZPHv7AoF7jg0/cc/ygceVTgs9pWVlVXu+t4Mvv3a/5
oF6zgm+c+KOBfSvfDX7z16N+Ma58fvA7Dc9/qmLZwuCFY5dPL6/3XvBHl99W
PbjVkuB1n+558KBeS4M/efjZswdULAv+sskp3ftWLg++72fXz2o+YGXwb09t
8tNx5auCB+zx5T+bTV0d/PCiGb+tWPZx8KAXBx5etmVN8NM9rxpZXm9t8HNn
H9O6cdm64Jf3++TDwa3WB7+yYkKPhl2rgite7bfHoF4bgkff3f7JeoM2Bo9v
e9hJAyo2ldrr0HXT6szeHDx9w4iOfSurg2eN+/Xmb7+tSUW6+hd9YfSF0RdG
Xxh9YfSF0RdGXxh9YfSF0RdGXxh9YfSF0RdGXxh9YfSF0RdGXxh9YfSF0RdG
Xxh9o72yvjD6wuhb1E+tq3/RF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXR
F0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9I32yvrC6Aujb9G4635qXf2LvjD6
wugLoy+MvjD6wugLoy+MvjD6wugLoy+MvjD6wugLoy+MvjD6wugLoy+MvjD6
wugb7ZX1hdEXRt+iedTjrvupdfUv+sLoC6MvjL4w+sLoC6MvjL4w+sLoC6Mv
jL4w+sLoC6MvjL4w+sLoC6MvjL4w+sLoG+2V9YXRF0bfIrvI86jHXfdT6+pf
9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h
9I32yvrC6Aujb5Gda7vI86jHXfdT6+pf9IXRF0ZfGH1h9IXRF0ZfGH1h9IXR
F0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH2jvbK+MPrC6Fu0brGda7vI86jHXfdT
6+pf9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0bf
aK+sL4y+MPoWrUO9brGda7vI86jHXfdT6+pf9IXRF0ZfGH1h9IXRF0ZfGH1h
9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRN9op6wujL4y+RX4Fr0O9brGda7vI86jH
XfdT6+pf9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9I32
yvrC6Aujb5GfyH4Fr0O9brGda7vI86jHXfdT6+pf9IXRF0ZfGH1h9IXRF0Zf
GH1h9IXRF0ZfGH1h9IXRF0ZfGH2jvbK+MPrC6Fvk97OfyH4Fr0O9brGda7vI
86jHXfdT6+pf9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0bfaK+s
L4y+MPoW+XHt97OfyH4Fr0O9brGda7vI86jHXfdT6+pf9IXRF0ZfGH1h9IXR
F0ZfGH1h9IXRF0ZfGH1h9IXRN9or6wujL4y+RX55+3Ht97OfyH4Fr0O9brGd
a7vI86jHXfdT6+pf9IXRF0ZfGH1h9IXRF0ZfGH1h9IXRF0ZfGH1h9I32yvrC
6Aujb9E+i/3y9uPa72c/kf0KXod63WI713aR51GPu+6n1tW/6AujL4y+MPrC
6AujL4y+MPrC6AujL4y+MPpGe2V9YfSF0bdo38z7LPbL249rv5/9RPYreB3q
dYvtXNtFnkc97rqfWlf/oi+MvjD6wugLoy+MvjD6wugLoy+MvjD6RntlfWH0
hdG3aB/U+2beZ7Ff3n5c+/3sJ7JfwetQr1ts59ou8jzqcdf91Lr6F31h9IXR
F0ZfGH1h9IXRF0ZfGH1h9I32yvrC6Aujb9G+tvdBvW/mfRb75e3Htd/PfiL7
FbwO9brFdq7tIs+jHnfdT62rf9EXRl8YfWH0hdEXRl8YfWH0hdE32ivrC6Mv
jL5FcQre1/Y+qPfNvM9iv7z9uPb72U9kv4LXoV632M61XeR51OOu+6l19S/6
wugLoy+MvjD6wugLoy+MvtFeWV8YfWH0LYo7cZyC97W9D+p9M++z2C9vP679
fvYT2a/gdajXLbZzbRd5HvW4635qXf2LvjD6wugLoy+MvjD6wugb7ZX1hdEX
Rt+iOCLHnThOwfva3gf1vpn3WeyXtx/Xfj/7iexX8DrU6xbbubaLPI963HU/
ta7+RV8YfWH0hdEXRl8YfaO9sr4w+sLoWxQX5jgix504TsH72t4H9b6Z91ns
l7cf134/+4nsV/A61OsW27m2izyPetx1P7Wu/kVfGH1h9IXRF0bfaK+sL4y+
MPoWxfk5LsxxRI47cZyC97W9D+p9M++z2C9vP679fvYT2a/gdajXLbZzbRd5
HvW4635qXf2LvjD6wugLo2+0V9YXRl8YfYviNh3n57gwxxE57sRxCt7X9j6o
9828z2K/vP249vvZT2S/gtehXrfYzrVd5HnU4677qXX1L/rC6Aujb7RX1hdG
Xxh9i+JwHbfpOD/HhTmOyHEnjlPwvrb3Qb1v5n0W++Xtx7Xfz34i+xW8DvW6
xXau7SLPox533U+tq3/RF0bfaK+sL4y+MPoWxVU7Dtdxm47zc1yY44gcd+I4
Be9rex/U+2beZ7Ff3n5c+/3sJ7JfwetQr1ts59ou8jzqcdf91Lr6F32jvbK+
MPrC6FsUJ++4asfhOm7TcX6OC3MckeNOHKfgfW3vg3rfzPss9svbj2u/n/1E
9it4Hep1i+1c20WeRz3uup9aV/+iL4y+MPoWnXtwnLzjqh2H67hNx/k5Lsxx
RI47cZyC97W9D+p9M++z2C9vP679fvYT2a/gdajXLbZzbRd5HvW4635qXf0b
8TmZIz6n4ByLzz04Tt5x1Y7Dddym4/wcF+Y4IsedOE7B+9reB/W+mfdZ7Je3
H9d+P/uJ7FfwOtTrFtu5tos8j3rcdT+1rv5F36JzST7H4nMPjpN3XLXjcB23
6Tg/x4U5jshxJ45T8L6290G9b+Z9Fvvl7ce1389+IvsVvA71usV2ru0iz6Me
d91Prat/V84+7dDHer2SGv21wTMTyv+YDvvJP04eWu/14DbvtVnat3JS8GmV
r1/XrvGm4DNH3/v5rOabg8+5r+2DrTpWB7fucFDjqT1rdsifcskfPr283eSK
ZdOCmx64ae7COhuDKR+mfJjyYcp3edSD8uC2H9+1/7Ot3g7+z9ZH/ahjdVUw
9YGpD0x9YOoDUx+XT70oH+5y5Ms3DKj4W/Cxd17+8rKF64OpH0z9YOoHUz+Y
+sHUz/WhntQHHv+X9cuaD5gX3HjY7+t1HbcumPrC1BemvjD1hakvTH1h6uv6
UO/pF/aufcrUBcFHLJ3868rBa4OpL0x9YeoLU1+Y+sLUF6a+MPV1/WjXQ/b+
17pufSuDqS9MfWHqC1NfmPrC1BemvjD1hamv60c7Uz+Y+sHUD6Z+MPWDqR9M
/WDqB1M/+IAzT7ikutuaaFfqC1NfmPrC1BemvjD1hakvTH1h6gtTX5j6vlu1
f5OyLYuivjD1hakvTH1h6gtTX5j6wtQXpr4w9YWp75IHhl3ZuOz9qC9MfWHq
C1NfmPrC1BemvjD1hakvTH1h6rv66HRfw64fRH1h6gtTX5j6wtQXpr4w9YWp
L0x9YeoLM0/W/XmXST3bfRzzFsy8ATNOw4yDMOMMTD+G6Tcw7yWM7jDtClNf
2pn6wtQXpr4w9YWpL0x94aJ+7n7k9xSmvrwH1BemvjD1hakvTH09bnuc9Djk
fu5+BFNf3lPqC1NfmPrC1NfznucVj+MeJz0OuZ/D1Jd+RH1h6gtTX9sNnpc9
73me8TjucRKmfvRr6gdTP9tZtmNsJ3ge9rznecXjNkw7wtSXcYf62i61HWg7
y3aM7QTPy573YOoH064w9bXdbrvZdqrtQNtZtmNsN8DUB6YdYeoJe13jdYbt
fNvVtlttF9ruoj4w9YGpV9E6y+serzts59uOtp1K+TDlw9SjaJ3ndZfXPV5n
2I6nPJjyYMotWld6ned1ltc15A+TP0w5XrfyS3n4RSgP9nvFet39wn5uv4ek
Uz/7Uf1exLn0XH/75awb1/OcXA+T7nEHf4THIe/DuN/bj+9+Zj+w33P7Ef3e
kU79YY/r+Fc8zntf0OOq95U8jnlfwuOG/drut/aLuh+RzvPBnkfxJ3le9T62
5zXvg3oe8T6ax23vw3ictB/f45T9wB43SOf54Z3ZZbaD8L/ZLnLchu0Q7/vb
DvC+sedd7zt6nvO+lecV73t4XLff3OMs6THOZd6Z3Y3/0nau45bc3o57sR3n
uAnbUd53t93ifVvbCd7387zsfSPPi953sD+HdNoTZpyl/WCvs4rWYfiPi9Y9
6OF1huPGbNc77sh2tONWbMc67sF2o/fNbad539V2kfft7J/yvo/9VaSjB0z7
Y8cyb9CeMOmx31qwLo79V61DHYfpdZ/j+LzOchyY1zWOI/K6wnEotuMdx2C7
2fvg9sd5H9X+Oe/D2V9HOvrA6MM6CD1g5kHaHyY99tcK/Bax3yY/geNkvS53
nKXXwY7T87rTcV5e9zlOyOssx5nY/+g4Bfsjvc9t/6T3Se2vJB29YPRi3Y9e
MPrAzOPoAZO+1+A/Hbel2epIZ3/N+lpPGP3sR3FcrP0Wjqu0n8BxeV6nO67L
/lfHBdkf67gS+2cdl2B/rfe17b8lHf1g9MPfiH4w+sF7zJ31aK+Gq3bQy35A
GL1g9ILRC0YfGD1g2h+mvWHaF6Y97T92XIf9yY4LsH+ZdNoTpn1oL9oHpn1g
2gemfWDaB6Z9YNoHpn1g2gemfWDaB6Y9YJ4fph02TVs0vN6gD4P/1fXG9+rM
/iiuIx0mnf/3L+m+7v8+abuy8Dram3TaG6a9YcZ7mPEBZjyA6R+Ux/NSL+IJ
/PykE19Q9Fz8+rn4f57P/88vz+v2IJ3nJ53rSac9SOd9hnl+P6+fzzpRj+3O
Hf/bc5K+3bnVf3su0rc79/hv/88vz+f2cDrM8/r5Sd/O//FdOs/vcc/9HKZ9
YNrH7eHn9/P6OXku5kP/P788L8zzwTwf9zPPe971uO5xzP3M76HfM5jnhfEr
ef/I5x29/+Xzj94P83lI74/5fCTprNtg1g0wdiqMHQQzr3qc9zjkfgkz/5jR
kfmHdJh09CUdJp329v6Xzx96/87nEb2f5/OJ3t/zeUXv9/n8ov0QPs9ov4TP
N3qd7POO3i/0+UfvH3pe9jzicRTG3jAz76AvjJ4w+sHo5/1Any/0fqbPG3p/
0+cPvd/p84j2s/l8ov1uPq/o/VGfX/R+qc8zev/U5xu9n2o7yvurpNsucFwA
eoWfMOsFoxeMXt4P9XlB7+f6/KD3d32e0Pu9Pl9Y5PdEL+8H+/yh94d9HtH7
xT6f6P1jn1f0frLPLxbFkThOAz1g9IDRw/u/Pt/n/Wqf9/P+tc//Ffnh0cP7
2z4f6P1unxf0/rfPD3o/3OcJvT/u84XeL/d5w6I4HsfJ0P4w7e/9bJ+/8368
z+MV7ePQ/t6v93k979/7/J73832ez/v7Pt/n/X6f9/P+v8//FcVxOU7K+3K0
p8+7Fe3b0Z6OH/B5OMcT+Hyc4wt8Xs7xBj4/5/gDn6dzPILP1xXF5dnPQnsV
7cvSXo5X8Hkyxy/4fJnjGXzezPENPn/meAefR3P8g8+nFcVR8vyOJ/D5Ksc/
+LyV4yF8/srxET6P5XgJn89y/ITPaxXFrXqfnOfz+SLHT/i8keMpfP7I8RU+
j+R4C59PKooL9r597Ffo/IzjLXyexvEXPl/jeAyftymKq3acAPXz+Q/HY/g8
iOMzfD7E8RhxXiTXC+Y614f4hbCrte7w/pzXeV5neP+Ifhbvj9aF3s9gnOJ6
mOf3OtL+deYF7oe5H0ZP+3eZt7kf5n5/h4t5Bn8DTDrzPOn2D+L34P9h7Gt/
l8/+PX/XjXTKhykfZl0Ps26Dbefznti/R72ov+vp7wjaf+fv0Nl/5++Y2S/m
72DZr+LvKJFOv9iuPP5u1L/551wv++Hsl/J3uIr8Ory/MP3H56i28/d9Vz/K
sR/dfjHKgykPpjyf0yIf+hX50E9gyofx58G8l9bB91Mv7oe53/6d8Efl8Q1m
XPP3tnhO8ofJ3/4G+gHlhT8mlwdTnr//xDhKeV4f06/IP/wFOX+Y/Iv2fbzP
wf0w9xftE3lfhOu9r+d9JO/Leh/P++iOa3BcieNymF+pD+8l6yjaGbsfxq6F
seuKdGGdXOSH9nvs99LvEfMH7znXw1wP83ww99P/aW8YvWDu9/WedzwPeByN
c7hZT+8jw+hD/0I/GH0dBwJ/87PRy7v13ZxanHTTuY/3ejLtdto9t1YOrg7e
+njV+dXdNqWt/3HtzfdXvhrXw1wP//OdI8b0bLcxHfvVA1c/22ps3A9zP8z9
cPUXlzTa0mxDOvaMml3OGjC5lF/myC9z5Jc58stcdUL/3/dqWJXOur3hZWVb
pkf+MPnD5A+TP0z+8JrOk/717bfr0sUjWw5t2PWdKA+mPJjyYMqDKQ+mPJjy
bqju8WWd2XOiPJjyYMqDKQ+mPJjyYMo7s8GPy3s1nB/lwZQHUx5MeTDlwZQH
U17rUR/P69luYZQHUx5MeTDlwZQHUx5cp/YFdbqOq0l3vjP3uVYdlwdPGdW0
cnCrldEPlk46dk6d2ZXxnsO8t8H5vYN5T2DyWzHgn137Vq6N/GDyC875weQH
817A6AbTrjDl086UD1N+cC4fLnrv/V76vYEpH10pH6b84IJ+7H7mfuD3FKZ8
3iPKj3GnYBzyuOF+7X4HUx7vadE46XHO45LHDbhonPa463HT4xxMfh7nPW57
3C2aRzxPeNznevod18Pku/Lu3psnlt+betVqd0DZllI9+8w9ZFh5vepI7zd4
TfPGZTU7XD/voX3eHlrv5bge5nr49h/2vadi2ca03+TOe41YNiruh7kf5n64
xzXjNjSbum08PH1UxYCKNyI/mPxg8oPJD77pkerLxpVXpWZL+p5wytSpkT9M
/jD5w+QPkz98w/TGU5oPWJ9aHVDRu3HZzCgPpjyY8mDKgykPpjz4ms86lk3t
uS51vvjD+fUGzY7yYcqHKR+mfJjyYcqHKR+m/NNa3Ve/Vq15UT5M+TDlw5QP
Uz5M+TDlw5R/zpqDz9zSbEGUD1M+TPkw5cOUD1M+TPnO78LfvHp9dbdFkR9M
fjD5weQH0286H/PgY606ro1+APMew7x3MO8FjE4w7QZTHu1IeTDlwZQHF72H
fi9gykMnyoMpDy7qV37P/d7BlMd7QHlw0bjgfut+5Pcapjzei6JxzOOOxwX3
U7hoXPW46HHM4wxMfh6XPa56HCyaBzyue1z2POFxn/nM6Z6/WEdSD/v5mc+Y
t7BH4d6PP3nK1J4rgrFPKcfp5x36+GvLFpbSYfyl1Df+Hne+jvr7HB35s+6n
/Djflsul3biPeZ70OO+WmfahnckP5n6Y+2HsFuqNHwMmf5j8YfKHyd/3815w
Pxzrl8zc73TeQ9Jh3gvW7TD+ffzdrONh/Pmxf5XX9bHfk/33sT+S/QgwfkTY
32vAL0F5MPk7vhR/C+8N6bD/Pg/vD+8T7xf5Od4Ppr+Y4+9BZH8b6TDp5Afj
X8QvBOMfgR0/g9+Lfst8Qb+OeT6Xj1+M6xnvuR7G/oXpnzD1x69Gfozn5AeT
H0x+MOMXzP4WTP6M5+QPkz9M/jD5w+QPkz/jO/nD5A+TP0z+MPnD5O9xFyZ/
mPyL1hncD3M/zP0w9aPfkx/jL/nB5Of9SPoFz+fvj5EP/dnfteN6xnnqQX70
c/Yv/X0x6oG/0d/J43qv48gvzv/mfUx/L4x6MA76u3tcT/60K/lRT8ZNf++L
ejCO+jt+8Zzkn9e15Ec9GXf9fS5/BzDaKefHOptx2d/L8ncDSed+1v2k8xyk
43dAd4/n/vuFPi9DOtfjf2a8gRkH/V0/x0v5+9r+voa/x8y+APf5exfsV5CP
v+/LOE2+/h4FdkHEleh7sYzr5OvvRzDvx/lBfX80vuNFnIi+/xB2Ad/T0vcs
/T0Hf/+QdOwRdPe+DPYG6bwP6Ipdg/3Fe8+8jN1COoy9hd1CPtjnsc7L9j/X
US+/X/57QegMo5u/QwHTTsxTjPfxHLmdmWcYz0lHH+6z3Uq9uY/x2XY64xxM
+5OP7yOddiAdph5cTz1pf3SlPOppP5rXOZ7nYNrJ6xrSKd/sdYL9dl5XMV5T
Pkz59n/F+I79JOb6iM/M6ZTvdSDjedRHfkv7x0iP8sV+v0mnfK87Gf8p3/tL
9pd5v4l0yiOd8uyPY76gPO8v2T/m/SbSyR/mvY71SH4PPf8wL/Je2j/G9ZTv
/Seuj+8v53ky+kX2Z8V3VHJ6vKfyf7EPQH1v/WL3fWY3/yieDyb9rd98/auG
XUvfuY5z83m8jTipnM68yPOx38L1pFMfpzMvks5+Cf0Yjvk+rweoL/sbXA/T
D2GuZ38CZpxkHLL/huvJDyad/QjyMzPOkj+M/RHXZ7a/iHSv+2McFtMP7Hch
v7g+l2fmeuxO76fYn+R9CjPvhcd5+xko32z/FOnUz/sz9l/ZD2P2PGR/Vlyf
6+P9He+jeJ3BuEV6xFfm8j1vYf/Euiqnh99K19ueIb6E8q8b8NJFHas/iPrC
tF/Yxzlf+j92huODHN8T5y/y/fQ32snrJP/GuYKsH/VmHYEurFviu3953uF6
nse/cS6B/b/cDqwz4vtTeR0Dx/5gvp729S/rNa7nOZgnqAfrHJh5h+t5Xv/y
3HF9fg7mGerB+gxmXuF6nte/PDf15f/juyx8jyjPMxEXnddz8f2iPM/QDtQv
4qwy0w7E81Aefrn4vnKOU+C5uZ78qA/5cr/TaRd0Jc6I9w7mPQr/c+n7cN/F
O3I9zPX487ieuC2uh7me/kW/gJkHWQ/Qz2DmTfoX98PMs6wXYNZ55MP6gn4L
M88yv1EfxgGYdR/lMj9RLr+UC5Nv7Pfn+jCuxLmbvC6MOIU8/1APfqkHHHEG
+fr4Xlcep+L7Odlu4frwc2OP853qXA+YfLme52I8j+9JZ7uG6xkH4/tdfEeH
cweZyTfml3x/rHsYN5k38rjG/zNfMS/QL3kPsctJZ9yK79fl+ZV8wg+Ty8HO
Jp1xifGG/MmHfkg52NGkM65QT/InH/p1nEvJdjHp9Ov4HlhOJ5/4Dg7nIrJd
TDrjV4xzOZ16ogv+fJj5kvmY+ZT+/eNx//nBwjql8+7442HW/8wrcT3riWzf
0n/pdzD9lvhR+g3zNMy+se1l/AbcT7/gfpj7uZ564HfCz086+dMPGL9grg//
eK4n4wT1JJ16+JfrKZfrKZ/xgHaCyR/7mnoxjpBP2Of4gXL/57lhyo84CL53
n8cN8iGd/HiP4hxeZsoPe5fvceVxgnwc98P4w3PAlB9xEHy/Po9P5GO/Ry19
b9T+GNu1rof3M+1vgWOczMz93q+0v8T7CnCcO8rjCzpg/0R+mcnP+5Okk1+M
Rzm/8Gfn/GDyi/En50c67Wd/Bkz+2DvkD5M/4xP5k07+pJM/jE4w+WMnkh8c
ftw8rsbfqcnjMvMS6eHHzRx+32wX8t7gbyB/7C+uh3kvuR7GPiM/9k+3+17u
d/bZdn/36Dvmfq6HHe9KvAD5xfdWcn4w93M9jD1H/2J8Jx2mn8V59awPdhjr
HJj5w+nh38jpMPM6zPXh/8jXw1wPYzdgJ3E/zPUw12O3cH3YMdmOgLnf+5OO
Gwm/f74fxq6wP8D7lfY7xz5Bzs/re+9P8p57H5FytjsX9Z2e8X3prCe//n+u
j+9XMn/l/hPfkVb/432hHhE3nvsf7HOWXM+v/5/nxd6hP3TrfMvqhXU+jPYi
nXGbdO7H3uH+8zdcc17H6tJ6h3TKdXp8hzqnez8/4n4zM98wbtOOEf+br4OZ
XxiXfT/XxTyR5xPGWd/PdXDEweVx1PdzHenm2FfK42bY1ZljPsgc431eL8f8
ktnplMNzY7/yXHDE1We7CWZ8gLFbeO/QC2Z8gLFLyIf7Iy4+jw8w4wP5+H76
Pxz7Pjkf309/h+nv5GP/Ie8b7HGE9mIdQ79GN95H/B6sV9ARvfBvcB1xpuhH
/6I8+iPM+EW8EfUN/35O53wX6RE/l9M5v0U68xvzH/2f56f/h72s/Qb/HS/H
ffFctAPlOu4r9v3zc9MuEf+mODA4vnuQx9GIV1NcGBzn7PN6EB3RB53jO515
fYle1tP+qfh7V7k/Ui/Gdf+yjmH9RH9k/eRf1ilcR38s+rsZrEPohxH3XfB3
LFhn0A8jnrXg70xg19IPI2674O9CYJfSD71/4L9zyPtDe+MXQA/al37ML/eR
n/t5k7+3v7LqFw+HvnEe+46eq3ZrOa30XYRLu2we9+K0VNax6czjHip9j538
h069atcDW81Kz21+5v3POrwQ/bvdhH4vnPZR6fvjF+87cZc3z/9L1J/3vN8F
q8tfnDkvXX7C3lVHDyh9n3nJOVdf+8CWv8Z7FX6WFVtfLb9hcfpi7jkDn+hf
+v7su417PjbhuNL3U2u/PPf4zzdODn9G7wPbjtllRunvXPdp+OLJJ/aaEuNJ
l/866NZmz5f+7jX95Ke/WHz+T05dns46st1fRnwwZYe/g311Tm9y+vBHH+lf
+jvZXM94QzpM/u1bN/hw3pqVUR//HW3SqR/pPB/+Fp4vzpPm9iDekfby9/Jm
v3PUeQ3aVEZ7++80dxh437HD21aGPv4+2C1tVpz/1sB1oa//zu/EpfuWnfj0
unTMUf1emLe09HdheX/uXfD0E1O7l/5O7OV1u91z181VqXePU8b0uGnHv6/+
6YbyvvUOKv1d0RbXvPgfb564MY0+/g9//ujNmlRdp/HqI+rNSJ+v6fHOhJXV
6fgb96l123/PSrVrrvrRWUM2px83fqbLDzrPT5UHz7zrgYc3pePbN+v89OLF
6Ym3Rg2Zc+6m9PQFL3545M/fT9VH9+1/eItt6+Tdbqn39swP0hsn/vPrEd2n
pLFHn/nL/g8vS72vnd9xl/Eb012T9/zTL6ctTR0O+7jtBb/bNo7c3HHeZ3OW
p7ZzLm309rMb01FNX77oi2nL4n3Y7Y17bu/zTel9+faoydPf7LMyvTtreO8V
faakmrVlH+w6eFV6/cFb//bee1NS5dsLD9rjiZWpds/xT39x0JQ07chep7Qc
vDq1b3Zfn/2HbEw/2Ny15YTXV6XTl5cNG735zfS96jPH3tnj43TVh0cdvu8d
m9LpTQft/ZeJa1KLFg/9cMtTY9NPyofNHLW4MlVt2P2w3121Oc3a77xnX3pj
bZrX6+E6dU9/LX3/0q4Dj91jfWrYY8X7yxdsW19eX1Vz24+r0kv39/+mdtua
NLni3HtH/nlm3N99+R1TXu+3IMob+NTC9UP6vpf+67qlN56/66a0tnG/h/Y9
8oPU91+Dn9laszHak/a9unebLYce9nE6fXbXBQ+vmphGdjqxfo/z16Rjj/7k
wIdavxH1X3L6zOOmd5+Qur9fOf+HDSrT0EZntL1/5ph0y4J3jnz+T2vT2KFL
jnyt8Zh4nkZX9Lvy8BVD07IuP9qrwfhS/No+T6z76f3r30od7j6iX72TSvF4
rT++8PGnepe+13/oSWvqXndC6Xv98d2aQS9N2XvpnNRk9L6DbtmrIl366WNj
jhs9N973799y9k23Lp+XZqzvNGPGR6Xvz1M/2mv4fSc89dziManLrhWbTp2/
IK18++i7W/5jbDqs7syPdk+LUtM7X3nm5xeUvoc+5IpH96+7S+l76Mwrl37d
/pIXai2M9uF9pv3Qg/bl/Y7vFt30xh2Lb1mc1k+4dEvnGaXve186Y8JtT3XY
8fvUn/zx909+2GtJuvWTzd3+8UXpe83NzmjT8dQDJkf8xMBVN5/XeGTpe6YR
h3na+Kb1p36cuiw+qtMPuk+Mc/plfaruPnnUhBif6I+8D/RX9F/T6qqL/7pq
U+p552F/vHtlZXqjUaeWBy8et8P3Iy/f5Yr3Xr1nbfrdQ09uurDl5jTvm/L+
1z22za4/a3j9R4aPKX1fcMjLf503aFSMb3cdd9b3Rn6zOW3c9cmHP6u/Pi0Z
d+zi+fV2/P7er5YOqnt3//Vp4Oyze7U6cGjYKftd+Oj795e9EOPd5MuanDn3
8CdL3zv7tNvJD57yhxjfmO8nHlJ76PKWJX8F+tI+zHe8D96/5nkffPJnx+/b
szoN/HX99/980Jy0ccKdl9dtve39vOqmyRMXLUhDZ639w951x6W9Ks9s/eWI
yrTywa0rLlv/Wrp99yE1C2rWpR4Xzj2x0T2D0rz9X/vp/g02pHOX3F73nn2q
052v3TXp6o1zU/07ar1w1y7V6YAtYxp1ajQvbT3o3UPu3bQpnTdieI/HL12U
/nzMtQ8esXxT2nhKv1/s+fSi9LcHGh2973sj05U3j5i7uf22/Cs++e9zP30+
3V751berr9/WHvud3f2EVx5LB9w55pD2/Wamjt/U+U39BS+kb7p3alH21qzU
4pnUsM0Zw1KdE9Ycs6rWnGh/+mPFXQ3eGFF/VHp07Yq7vmw7P/SMfdw8Pno8
YvxhvGL8jL/3lN/XVy6+++1hz2xOr+8z8JzfXLkuldXu3Puqm6rTWZ+1en3m
m+tTn1XXfLboB8NTramPjGvadX361ZYhL716Tk368vmHx3U/YkNqseugqYs7
PZN2X73u7FGTqlKT/n//oM+CwWG//rZ6SJdNn5bii7++aOIBv1xTk266/KLG
yy6Ynmqd3O7aMw65JOzVi/ZpduOcz2tSq0/KRq2dNi19c9nBm3a/vyY1urTq
e6M6vZWq221sf1yDmvT3O7psbbrHO6n76N3rz19YncZ3mnHFtVNnpV/Neu3E
RsOqU9PBz0z6atLstH7+sIqRzavTrlsrDjml17vRP+K7dXk8or9cPG70iuqp
L6QOw/Y9/mftqlKPjrs1+PrnQ9Jtj3ec12K/qtSlz4bPp096MG195f4zL+m2
Ia3s8Nlhf6rTJ01vfkfrsRO2zee7jTxn4++6p+tfKdvSZvM2/tu7J10xq016
dVqzS2rX3RjjB/Yc4wfjD+NzfL8yj8/0x+fW/eOr2TfU7OCv/mrMH5747OJZ
6fVeTT7vvmcpPu7ve7/Ytc8xj8Q62/aw7WW/rzuzh/+/77PtZc83tp939v57
/rG+no88/tge93xl+9zzkcevnc1PO9Pf/dn2mu1/22+2/3dm79t+s31ve832
ve072/u272zf217yfGv7z/Ot52PbW56PbX95frY95vWE52PPN7ZHvf7w/G17
z/O37T/P555/vH7ZYX7XfGj72Osdj/+2D2yP2l7w+Onx1faE50+vpzy/eP6x
PeL53uOh7ZMdxnfZMzsd7zWfeX3n+cD+CM9/O5s/vT60P8Pzp9cLnk+8HvJ6
wvOv5xvPR16v2n+ys/nb6xfbf16/eL73emdn9p7XN17/eL1t/47Xj17v2F71
esfroZ3Zn17feP1jf4D9S17fen1k/4H9UV4/eX3s9ZTXy/Zf2f9g/5X9D/ZX
2V9h/5X9E/Zf7cw/Zf+E/VP/X/vb/iyvD+3vsL/L60f7t7ye3Nn6yutJ28f2
r9h/5vWE/WVef+7M3vV6xP4b+9/sb/N6xf41++P+B1G/VyQ=
         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, 
       AxesLabel -> {None, None, None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, 
       BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, Lighting -> 
       "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-3., 3.}, {-3., 3.}, {0., 108.0845165183032}}, 
       PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], 
         Scaled[0.02]}, Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                   Directive[
                    AbsoluteThickness[0.2], 
                    Opacity[0.3], 
                    GrayLevel[0]]}, StripOnInput -> False], 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ
sjR2QkWWzuFw7Fs6lrN9z8I0aJoa5vz+gN+L+7qe63lxv7rv5/NoeVw+dkFM
REREVKgLQv1vLhkcHStV/ACqx1peSgYLohaxiqa7OOARS/czAzuhHqXg6E5j
wmuquYvUwMG/4eFBv3t249lSV3SxFBNq8enKW0HAbrMqP7GCBrkZZ9YZKwac
Q3rZaW8ITKffkax/24PGxBUyRyOm4dAycTdkLxfiK1qKf0zvxSnx/qsnyqaQ
KOe0ee41F8sl+243mPdhb3K4mzV7Env6F+R1zXhgXrC+NFjVB5m1NM6Y6iR6
OKfVt5XzwE0smUiR7cfdS80Low4ToLlmzKrr8xEkf2bxxf5+zBcpywqi6Yi6
LW8oX8BHb7YoCMd+/PTH0Ycu7p/wfZtOO0ldgEIdG8JrYQCygS8/b90zjsNu
qrOJKgKcFru1filgCP3BHxzFlD5ixyF2yPg6AR56hl3Kah2GvI+G9uTkKMpX
F49IrBVAfpXl14Flo3hWt8s+o3AEWfdEU5crCuCpcSaMsWkMdzSOsgo9hxHi
8UV5YpUA5by5xr/NPmLJbcOfuxWG0NyuzUuXEWDLiZrkdLNxeKtYPxL8MYCC
Q0+idFYKsMlYRrRJ9xO6yHnl2ejHbo+NR5IkBPjx9BwnRYKO+cL90hLVvajk
/d01ICqA/1aLG0mBdLyeySMpK/Tgp3Txa1//5WNp3+dDDI8JhA7ekCF50MCQ
9hW8iONjuO+GcajtJK4+PBmkV9ANnYfdytWKfBifyiD9rjaFbq2CJF5NFyz8
wnZqPOZhplA5+0diCkleVZWmElRYBZvFTOvx4LCpfIlSPI0EdpQ+U68DX9bY
2a+o5iLk2qqjjhcZWOih59hqkVG6XffPeCsurjFlmvrUmBCxmfPuGG1DpN/j
scBuAk+d/gla08GEZ0K83ya7FrzMabhT4ybM1UFBUmMwCxxNvdr3lk0YdBb/
7TyXA27xCRH3dWzcL1oh8FRvgD3zScjVMA4iZo79RUtho15bt6Kyoh7k3eT+
H8LYWOmCFDsJDhqbVdRiLtYjnmtsoxrOwjqLhX/9AznQzLx3gmNRj7tj2/Sj
IpkI+usxfbiPg30WLl4l2+pBpxnydkUz8L1l1FLJiECVlN990731yGPYHbO6
OY3MCql7qfEE6K6L5FTfeux9lTGXED+FLAMTommcQKvzFcUbZfUIa66xl0md
RPzxd4Zi+lyMJZffjlNqwGJncFL+wwnoldeHF13lIsE/RXsmoQHF5iYb9+bT
sX618clV9Vy4lmVYT2k0QsyNQzonzHXqLvKsGY8L2bfDbfm0d3Dv854njX6E
z5aFg19IPDifdPButXmPFPVDq3qcxpCdkK/kY8MDAymR3rGtyEsSUV2gjqAk
5pTH8wAekj5XLRzPbIeT9SC1w2YYC5oCalc6D8TgWuVb98gof5uwyrd2EIYG
d/L/qeOB/bW3zvBiB4zMXT0e6Q5Ajuwpum+cBymj868HtlORvm+DCC25D5EJ
BFG1xMOve3adoU53QeKJ1DH25x642NF+vqLBh4GipejJlm5IdlylCQ7QYFHt
9j5pDx8J+wNqm5Jp0NZRjLTS6IKeqrNz7jU+Sqh+vKprfYijbkwRPU1FLWvg
4Lc6PnI7L4i66A4ieuXNWfdfO1G2+chCxjwfAofrl6WeD+OBXKrvyVsduMJO
2uOvLwB7w5+dR5ePoa732YjWZQq+GfvFXPIQ9ps6+83wyDgWe1lZE0ZkyL6p
yUlKEyBxZY+noiUd5+QcF7ZR20Gx5g19aBYgwGDnmKTzBGoWPYssTdog3UYM
ycwKoNBWutrr/CQe2no3RLu2QD5E7ZE9aQbdXeWR1gFTkCDFvczc0YxLXQ98
IjCDotqNBhHB0/iW0rWFlPwWTt1bfJoHBSDFHohMXc8AOef9kMWtN5CeWp6Y
5S+AYDRKN4nKgJybsa0MpQHzpgo2FGHvT2gRhWNXmJg2+sX/LPc11uTXD2rG
81Gz9PvGfhILTJ6JjR29FodfFFS5KvFxQdLx+Ic6FkJ1ddi7c6tRnKHzm3kW
D75f3mUtnmSjqeF2RrpaJaIpDxQChLkKppoN/jHHBvv8mewIqzK4FfsN5aVx
ET2fULcugYPkZ4Gm58eL4estGnpFiovep2XjHjoEnrcdW0+rzwfXUio9IpxA
oajxq7o6Aopirc1PN2SCEjJyOMOcA1GKmWl1pbBPwbHpHw4/giepMSpwjoX+
oV/Xrysh8MCIbNDgk4tmmYCtDQVMGDiN+/CfEphxj/u+fuAJMnLn+b0ODER0
L9O2zSBQyqg0ifHJxyfG2vkY/hTusZrydsQR2DJHiaxYeA65BT1qZ+Qk8h7z
Y+quEnCXsPHSj3gBBf+KnZFf6fhZs7Fq1oPAoR9C7DPmi3CqJDA1rW4c209r
pnyyJzAvVdjScKEUd2t04+MsRiEnzRtOMSbgvyPn0TvGK/gEqOz47DSIWj1T
6hplAmk1+0b8FcuwR61pzPbxAGJzqsklMgTCWyQjrJ2bYHCDe/jvoX6w7t1l
eC5xoN3YPsytb8cb8y38QpF+HB/Sdtr5WXi3VrLoViuokLbarOKi2IfwB4nH
NjE4eNxy/bqDKw1MidVjOrK96Dp7k2Q2JOT9N4kGt9he5IqnhlLYNKhaHGBf
pHAwUVGQkxPXDy3HO2xGTjdIr3KXGho5OFLuizNXBkG0qX8cOUAFOajziUmZ
cL/98p5Kh2GYcTUk13WRofA96IeefA78szliH1VGMVNaaOaW2IqU9sT8tCwO
TqWuLZgcG4NqqP5p8dvtqMoZuK7nxYHOi6zdy4Scyzkb+EvZcjLmzn0oqjMU
+iTcj+suo6Pp/TJ7QpOCWCMXL7slNlYHuRVGdEwgfFHJfBudgv37iiR7KWyI
1RRLmkxOQjXbKZh7sAORafvFz2ayocRxPcCcm8Ji6eSndvcOtHaZcGfPsxH2
yF3SRoKBQmmyHUmzAzESt3ziDNgIlX/dTFdk4rvmOemXNylQkfWy3bwo5IRt
uf9WLRYOXIuInrxFRm3Y04ABMgumDi+1buqz8f/+q/8A5ejSSA==
                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True], 
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJytvXeUVUXTxgsz5BwFCZJzkJyhNzkrQSSjAhKUJEhWkhIVDEhSyUkygkSB
cwAlKjlLTkNmyDAIXC/0r853au+9vvutdd9/Zvm8RZ/u6md3V1dVV2dr273R
hxGxYsValjRWrMj/9+9r5S++eBE/yN9uCyus6/M4q5PnbKLhNZrFE3ze88v3
U+yIdKYvOJFr7PI4gmcuPenZoixXTbpeC7cdTBAp+LvRLx4WbrfffFNhQMcM
H8QWvOSMLN/UqLDeJE/yQ4otPV8EwOcOavp5gwlzTazpxRu9neNfwZ3PXsv4
SZvx5k7Rg+NPHnws+JCtGxKefjTMnP+j5+HOXz4Q/Js5sQ+tr/mpOdg0VbpH
Je4KHri94d/bSzuaUYfb/Zpg903BS3+ffHvFsm3MR09nlchRMErwP47eq/Z5
2iamXrbzayqOPSv4hvSbqjqvNTAtx1Xps/zkQcET7dyw/+Y/dUy/TpH3Jgxc
L3iB3fGH/zu6lvnsFW7A81m81at2BE9i27G/K/hG+7u2n4Jvtf204xK8pB2X
1YPRerB6E3yc1ZvVs9F6tvMieGU7L3YeBZ9v59HOuwNeys675YmjeWJ55Whe
WR4KPt/y0P63o3nLf8PfVhmTpzhbqLzwmb8jSzy/tXxKFuEz+M1g+72FI+M4
8Bm85/Sqc+dOuy58Bk88JuXYBNsOCZ/BM505UytZws3CZ/CMSeOcmNx/qfAZ
fN6jkeNvbZoqfJb2u+5q9NrKb4TP4N3+7Bl7Qa9hwmfwIl0irpwc0Ff4DL6v
4cojv7/bQ/gMnm3OsoTJzncSPoM37repe8tN7YXP4M2edaudO7qt8Fnj8Fm3
A5/Bc9jfhc+6n/AZvKgdF3zWeoDPWm/wGXy+1TN81vMCn8Ez23mEz+CJ7LzD
Z/BPLE/gM/gNyyv4DD7C8hA+gze3vIXP8HTTjIypBz5tLHLga/5pUOW9AqWF
z/wtkuaLjz+tkln4DP5rinSpemeN48Bn8GE38z6oX/CW8Bm8+wcPN02Zf0z4
DD7twYUV7R7/KXwG/3n3zX8PtFolfAa//Unj2ZuWzBM+gx8atuTGvvo/Cp/B
o7Z2fTxtybfCZ/B43VIdz5hzpPAZvPfVBNHR44cKn8ErRk8purjy58Jn8CSD
fxw1c9kA4TN4UovDZ90OfAb/1P4ufAaPb/sJn8Ev23HBZ/DDVg/wWesNPms9
w2fB7bzAZ/Aedh7hM/gXdt7hs+YJfNa8gs/gay0P4bPmLXyGj+8PiVdy2NOP
hM/gr22Jm+FJ0bfl34M3HbSuwIhZxYXP/D1+L/6V0tczCJ/Bq36b7v7rGeI4
8Bl8TaDDzIhW0cJn8IrFh7WqnOCU8Bl82rsJ5y3L8JfwGfzN3H/s/mblRuEz
ePMfnh68n+tX4TP4tXJ5Mk2fP1f4DB6Tvec7L25NFT6DZ2q49Nn1hROFz+C3
ln+f8McD3wufRT+pVu8um/s74TN4M4vDZ/Cbth34DJ7Z/i58Bn9s+wmfwW/Y
ccFn8BZWD/BZ6w0+az3DZ/AKdl7gM/haO4/wWc87fAY/ZnkCnzWv4LPmIXwG
b2t5K3an5d39737757WDnwufwY8crP/3V7XbCZ8F//yLDv2K1ZJ2wdPHXKpd
e0QR4TN/vzj4dfun49MLn8GHrHyn2JirkQ58Bi+brPTlmhPuCJ/BC5RYPirJ
7bPCZ/ADJiZuir/3C5/B01SfEfX0kz+Ez+Crij4+1n3ZOuEz+I62FXq2XfSr
8FnwLv3SZ/hlofAZfH7PCRVmpponfJb+pOu9YGmaOcJnjcNn8F9sO/BZ/y58
1v2Ez+C/2XHBZ/C0Vg/wWesNPms9w2fwMnZe4DP4YDuP8FnPO3wGf93yBD5r
XsFn8MOWh/BZ8xY+wy/NZ+Hd50vLNbnaW/gMPjh7yWXx27cUPoOPv3QnstnM
KvJ74FkuDK9/dkIB4TN/C69MeW5ThdeEz9J+8k7tGo2MdOAz+Le/FbubY8Vd
4TN49JorN2eMvCB8Bt+SsfK+PLWPCJ/BG3zVPjhn/27hM3ixWvP6pIu3VfgM
Xrpvm7M5x20QPoMnm9b868C4NcJn8A69m74RbLdK+Aze3uLwGTypbQc+g5ex
vwufwYvafsJn8IZ2XPAZfLPVA3wGv2P1Bp9l3q2e4TP4EDsv8FnPI3zW8w6f
wX+wPIHP0r7lFXwGH2d5CJ81b+EzPNJ81jh8Bh9f0EledFAX4TN4gSQrSuWo
11j4DJ6ySso/W3avIP0Af5puT+qru3MLn/l77PuJrYddSi18Bp/1YFOa+Ncj
HPgMvuPLZdP7T70nfAaPubkuUbKSl4XP4Pu2D1l4e/A/wmfwBfVSf//lggPC
Z/DuB8qbMQd3C5/Bx+1Nm23y0W3CZ/C1Z68krrLsD+Ez+DqLw2fZl2w78Fn/
LnwGX2j7CZ/1uOCz6NnqAT5rvcFnrWf4DH7Uzgt81vMIn2V9svMOn8ELWp7A
Z/AJllfwWfMQPvvgQfii+axx+Ax+oueeoh2cgcJn8KHF/r779L22wmfwxeU+
n3bodh3hM3iLec+Wz+lbUvoHPmrsqMhdP2UXPvN3WM+MJ6qPSyl8Bp+QruiD
gokjHPgMHrGh5h8zyt8XPou/ZPr1CVP+viJ8Bn801VmVd+FZ4TN43a5Ldiac
cUz4DH69da1URVMfEj6D9/qo5C+FMh0QPoP3tDh81u3AZ/278Bn8oe0nfNbj
gs/gkVYP8FnrDT5rPcNn8NF2XuAzeEs7j/AZfImdd/gMPsTyBD6Dn7S8gs+a
h/DZBw/CC81njcNnjcNn8Mf/FmjaK30P4TP49WR9m9ft11T4DB4v4tfSZSZW
ET6Ddz9769eTT9+UfoMXTrl8cf6rmYXP/G0+x1mSqlsy4TP44iexW+Y8FcuB
z+BDsg2Mm7rzfeEz+O3CPU9uT3Fd+Ax+tXuPzVsCF4TP4EMfjP/jg3NnhM/g
y88u+77XlJPCZ43DZ+mPbQc+g1+zvwufwaNtP+Gz9MeOCz5rPcBn8BZWb/AZ
vKDVM3wG72bnBT6Dx7fzCJ/1vMNn8EeWJ/DZh4cuHD774EHmX/NZ4/BZ4/AZ
3Gm98o9/H/QXPoM/X1N+/KSDbYXP4NVb35/01oz6wmfwn97ImaJonbLCZ/Bx
qT9es7ZLHhkPeOcHXSfXHpdO+Mzfpe3qzJsSSCh8Bs865GCjKgufC5/Bk82f
/1u7J/eEz+BVN350ZuOsG8Jn8OIZkl46+Mdl4TN4sO+TJo3NReEz+GaLw2fw
ErYd+Axexf4ufAZPavsJn8Ez23HBZ60H+AzeyeoNPms9w2fwH+28wGfRj51H
+Az+ws47fA7Jv+IJfPbhoQuHzz54kHnWfNY4fNY4fNY4fAafee2X2FOOfCx8
Bm+xNvFXP2xtInwGH/HXd5uzdKsifAZf13f4EHO5iPAZfEzPmL4ltmeVcYJv
+yjLV1cTpxI+8zcyxzvTs6aM68Bn8N+r93r8w18xwmfwmLrjv9yz5q7wGbzG
znOZU6e8KXwGX52+RLGLfa8KnzUOn3U78Bn8X/u78Fn3Ez7rccFnrQf4DD7a
6g0+g6+3eobP4MPtvMBn8JZ2HuEz+Cw77/DZh1cuHD5rHD774EHmU/NZ4/BZ
4/BZ4/AZ/OSAPKuqPe8pfAZPX63e9QnDWwufwdtUjF8r695awmfw7MeGH1s0
vJTwGfzHHgdH3EyRW/gMvqHktPspGqaT8YNnnbP7StkfEgmf+dv0fOvJ89vG
cuAzeI+L5syueA+Fz+AZJ6Yc9EW3aOGz/O6K8nc/iLghfAbfaHH4DJ7JtgOf
9e/CZ/Bmtp/wGTybHRd81nqAz+BTrN7gM3gOq2f4rOcFPut5hM/g/9h5h88+
vHLh8Fnj8NkHDzJvms8ah88ah88ah8/g5X+Zcarc3b7CZ/AkG4/mKfVlW+Ez
eJEK0YlTX3tL+Axe9lqviVn2lRc+g6eNnJKi49X8wmdwxzTo/d3tjMJn8Drp
0txrEj+56AV88MW7Jz/sFCF85m/zqnuzt+70SPgMvrNP5f17qob4DN6lbNnL
2zJdEz5rHD6D77LtwGfwFvZ34bPuJ3wGr2vHBZ/BjdUDfNZ6g8/g5aye4TN4
UTsv8Bk8qZ1H+Axewc47fPbhlQuHzxqHzz54kPnRfNY4fNY4fNY4fAYf/9P5
2pluDhQ+gx//+UGBX774UPgs8eSIWTMPn24ofAaPv3Rwqee3jPAZ/HbzT4bP
nlRY+Ay+PeHhT2fVyiJ8Bv+w5uCS2R+lED6Dz9lzY2KGpiG9g5eKXaZyzSuh
9Zm/cb/8M9+R124In8HjTVz3zaPSF4TPGofPuh34rH8XPoPPtf2Ez3pc8Bl8
h9UDfBY/jdUbfAZPYPUMn/W8wGfwE3Ye4TP4D3be4bMPr1w4fNY4fPbBg8yD
5rPG4bPG4bPG4bPG4TP4vLfqPfq9cEfhM3jStLV6dSjRWPgMvjXjj3dTpa8s
fAZff6Nm8tO1igifwTskOv7z+aFZhc/gL77Z3yT/nJTCZ/D0+zf/cO6bEJ/B
C/a9FRh9IMQD8CYJhv+yZ0/oPMjfJRHHM15cF/LXgS+1OHwGb2bbgc/ghezv
wmfwDLaf8FmPCz5rPcBnrTf4rPUMn/W8wGfw2XYe4bMPT1w4fPbhoQuHzz54
EH1rPmscPmscPmscPmscPoPPVnwG13wG13wGX6v4DP6h4jO45jP464rP4IUU
n8GbKT5Lfqjis8bhs24HPoMXVHzW/YTPelzwWesBPmu9wWetZ/is5wU+63mE
zz48ceHw2YeHLhw+++BB9Kr5rHH4rHH4rHH4DP6DsjfATyh7Q/LOlL0BnlDZ
GxKXUPYGuLY3wLW9AT5P2RvgpZW9Aa7tDXBtb4DHV/aGyCt7A7yksjd0P+Gz
Hhd8Bt+m7A3waGVvgGt7Q88LfAY/ruwN8PHK3vDhlQuHzxqHzz445zUXnzWu
zoMuPmtcnQdNBe/zoEnqfR40Rb3Pg6ac93nQ+JwHjfE+D5q63udB43MeNC28
z4PG5zxounqfB43PeVDaUedB09z7PGh8zoOmjvd50Dje50Hjcx40Zb3Pg6aI
93nQJPE+D5ry3udBF599eOjC1XnQxWf05OOvc/FZ48pf5+Iz+D/e/jrj468z
Pv46k8PbX2emePvrjI+/zmTz9teZZt7+OuPjrzOZvP11ZqO3v874+OtMZm9/
nfHx15mm3v46k9XbX2d8/HXmR29/ncnu7a8zPv464+OvMye9/XUuPvvw0IUr
f52Lz+jDJ57i4rPGVTzFxWfwWd7xFNPSO55ihnvHU8x673iKGe0dTzE+8RTj
E08xPvEU8693PMVU946nmLXe8RSzxjueYnziKSbGO55ifOIpxieeYnziKWaM
dzzFrPOOp5gR3vEU08I7nmJmesdTXHz24aELV/EUF58Zt0+828Vnjat4t6nq
He82L7zj3aaqd7zb/Ogd7zY+8W7TyTvebXzi3Sazd7zbJPWOd5sq3vFu4xPv
Nj7xbuMT7zY+8W5T1TvebZJ5x7tNVu94t/GJd5vO3vFu4xPvNj95x7tNde94
t3nuHe82jne828Vnjat4t4vPjM8nH8nFZ42rfCTzyDsfyfjkI5n43vlIppt3
PpIp6J2PZFp45yMZn3wkM9Q7H8lEe+cjmWve+UhmiHc+klnmnY9kfvXORzJD
vfORzFXvfCRz2zsfyQzxzkcyPvlIprl3PpIp7J2PZLp75yOZeN75SMYnH8k8
9s5HcvFZ4yofycVnxuGTL+riM/hJ73xRM8Q7X9Qs8c4XNS2980XNaO98UeOT
L2p88kVNpHe+qPHJFzUPvfNFjU++qPHJFzU++aLGJ1/U+OSLGp98UfPIO1/U
+OSLmgjvfFHjky9qfPJFzSjvfFHTwjtf1Cz2zhc1Q73zRc0J73xRF599cPLt
XXzWuMrnNxO88/lNQe98fpPcO5/f+OTzm6Pe+fzGJ5/f+OTzm6fe+fzGJ5/f
LPTO5zc++fzmG+98frPOO5/frPXO5zfjvPP5jU8+v1ngnc9vfPL5TYx3Pr/x
yec3Pvn85ph3Pr/xyec3Kb3z+U0B73x+M947n9/FZx+c+1AuPoOP875vZYZ4
37cyP3jftzI+962Mz30rM8T7vpX5xvu+lbnjfd/KbPa+b2Uaet+3MkW971uZ
Mt73rYzPfSvzofd9K9PB+76VtKPuW5nS3vetTDHv+1amgfd9K7PF+76Vifa+
b2W+9b5vZQZ737cyPvetjM99KzPe+76VGex938p8433fysVnfl/zGfyw931Y
x+c+rPO6931Yx+c+rDPY+z6sU8b7Pqzjcx/W8bkP66T1vg/r/OZ9H9bxuQ/r
+NyHdXzuwzo+92Edn/uw0o66D+v43Id1fO7DOqu878M6abzvwzo+92Edn/uw
Tlnv+7DOEO/7sI7PfVgnvfd9WMfnPqxzxPs+rKP5zO+09a5X4PjUK3B86hU4
x7zrFTg+9Qqctd71CpwK3vUKHJ96BY5PvQKnhXe9AueGd70C57F3vQIns3e9
Auemd70Cp5l3vQKnqXe9AueWd70CJ5N3vQInxrtegXPNu16B09y7XoHjU6/A
8alX4FT0rlfgrPGuV+D41CtwjnvXK3B86hU4PvUKnPdVvQLa86kn46z1rifj
+NSTcXzqyThfeNeTcXp415NxfvauJ+P41JNxfOrJOIe968k4l73ryTjxvevJ
OJ9615NxKnnXk3GSeteTcZJ415NxfOrJOL2968k48bzryThR3vVknEPe9WQc
n3oyjk89GWeadz0Zp7t3PRlnmHc9GcennozjU0/GWeNdT8bR9WT4d8296305
I7zrfTk3vOt9OZ941/tyEnnX+3Iye9f7cnzqfTnzvet9OT71vhyfel9OUe96
X45PvS8nh3e9L8en3pfT3Lvel+NT78vxqfflZPOu9+X41PtyinjX+3J86n05
PvW+nHne9b4cn3pfTibvel9OYu96X05P73pfzk3vel/OSO96X04rVe+L/9+n
HqMz37seo+NTj9HxqcfolPKux+jM967H6FT2rsfo+NRjdMZ512N0fOoxOiW9
6zE6W73rMTobvesxOkm86zE6+b3rMToFvOsxOsm86zE6G7zrMTp/eNdjdEp7
12N0fOoxOt9412N0fOoxOo53PUZnrnc9Rqekdz1Gx6ceo+NTj9GZ512PUXj7
arwRwY9f6il+sOc/7deminvQ1H2pz1iCL52Z/Y/z1zdavT0LgD9+N9OzWwsX
gBvwhxa37TjgS2w79ncd/buveBIp+PlbX1cb0uqaufBS/3EFbz6pzNC4V0VO
8Fd5F1kd+m//XfDQlsY//DHviPQfPMOODydXar3V8jBG8GDJivcKJF8Bzu8H
N1uc8YK/btthvPp3GS94l1u503918YaMF3zHqRkJLqWNw38L3vJlvOMNGS94
ls+/2/pVprIO47LtBeMlqfxnqx0nZFzgyQ6l3dTk7A77XTwS/P65ret+L825
mHyryOA9i6MH8OS2HfQAnsD+LnoAH1ayztGlvW6LHsBTJOl6JUt28vgjBX+V
r5hJ9AD+9/0UByc2Kyl6AM/YrH+DPQsbOowXXn927KO9yz88I+MFz9Zq1fHR
i/eaFi///T3BM+a+ezvQczO40Tj60e2gH/D+9nfRD/i7Fw/HpH8aLfoBX1d7
87tj4hMfjRD8VTz3ddEPeMkn+WpOil9M9AN+7scJTz4cXFf0A54mutbGEYc6
OIyX76NSlzGx37xHPly04KeGz/gj1YXt4LIenLQ4+tHtoB/wdVlnrDxe6rzo
B/zQ2+MmfJL3rugH/KfN867lCETy/cp33PRlPl460Q94v7uxr7UpV1j0A16t
1o4e553qoh/wd9K3GNex2vuiH/CJkZki42