(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    550384,      10945]
NotebookOptionsPosition[    368156,       7209]
NotebookOutlinePosition[    530949,      10592]
CellTagsIndexPosition[    530906,      10589]
WindowTitle->10. The Cauchy\:2013Riemann Equations | Essentials of Complex \
Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "The Cauchy\[Dash]Riemann Equations"
}], "Section",
 CounterAssignments->{{"Section", 9}},
 CellID->493745813,ExpressionUUID->"52ebc09d-ebe3-4955-9830-43d3dc72d44c"],

Cell["\<\
In this chapter, you will study a crucial property of differentiable \
functions (also called analytic or holomorphic functions): that they obey a \
set of equations called the Cauchy\[Dash]Riemann equations.\
\>", "Text",
 CellID->144698969,ExpressionUUID->"bb2680c9-6e21-4581-9fbf-c1d3a7c00c0d"],

Cell["\<\
This is a remarkable difference between complex and real analysis: in complex \
analysis, analyticity is a very stringent requirement that imposes many \
interesting properties on analytic functions.\
\>", "Text",
 CellChangeTimes->{{3.968834509197134*^9, 3.968834509700926*^9}, {
  3.9729980347919703`*^9, 3.972998035416112*^9}},
 CellID->729175485,ExpressionUUID->"a6d81c77-05c8-4af8-bc37-d26f95bb5f85"],

Cell[CellGroupData[{

Cell["Cauchy\[Dash]Riemann Equations", "Subsection",
 CellID->858602993,ExpressionUUID->"cd27839e-9a7c-43b0-8340-0a83ebe58971"],

Cell["Suppose that the function", "Text",
 CellID->32867425,ExpressionUUID->"07d30c27-130a-4fc9-b769-44ff2432b65b"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"u", 
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "v", 
      RowBox[{"(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->170619754,ExpressionUUID->"e2dcb77e-bf04-4709-9309-b69dd4831d74"],

Cell[TextData[{
 "is analytic. This means that its derivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "z", ")"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1c852556-e858-4954-ac08-69ac63df0e73"],
 " exists. Therefore, it must be the same whether it is computed as a limit \
from the real or the imaginary direction."
}], "Text",
 CellID->141962840,ExpressionUUID->"0dae21a6-f505-46bd-9f8d-a3019d9d0ca6"],

Cell["Along the real direction,", "Text",
 CellID->102806856,ExpressionUUID->"a10e57d9-007b-41df-9277-bd07ce455448"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], 
       RowBox[{"(", "z", ")"}]}], "\[AlignmentMarker]", "=", 
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"h", "->", "0"}]], 
       FractionBox[
        RowBox[{
         RowBox[{"f", "(", 
          RowBox[{"z", "+", "h"}], ")"}], "-", 
         RowBox[{"f", "(", "z", ")"}]}], "h"]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         SubscriptBox["lim", 
          RowBox[{"h", "->", "0"}]], 
         FractionBox[
          RowBox[{
           RowBox[{"u", "(", 
            RowBox[{
             RowBox[{"x", "+", "h"}], ",", " ", "y"}], ")"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"v", "(", 
             RowBox[{
              RowBox[{"x", "+", "h"}], ",", " ", "y"}], ")"}]}], "-", 
           RowBox[{"u", "(", 
            RowBox[{"x", ",", " ", "y"}], ")"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"v", "(", 
             RowBox[{"x", ",", " ", "y"}], ")"}]}]}], "h"]}], "=", 
        RowBox[{
         FractionBox[
          RowBox[{"\[PartialD]", "u"}], 
          RowBox[{"\[PartialD]", "x"}]], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          FractionBox[
           RowBox[{"\[PartialD]", "v"}], 
           RowBox[{"\[PartialD]", "x"}]]}]}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->645243383,ExpressionUUID->"d48a9fac-c424-4d20-8b43-6b6d71d69869"],

Cell["Along the imaginary direction,", "Text",
 CellID->650696508,ExpressionUUID->"992c36e6-52e5-49b4-a721-a848dde97b2f"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], 
       RowBox[{"(", "z", ")"}]}], "\[AlignmentMarker]", "=", 
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"h", "->", "0"}]], 
       FractionBox[
        RowBox[{
         RowBox[{"f", "(", 
          RowBox[{"z", "+", 
           RowBox[{"\[ImaginaryI]", " ", "h"}]}], ")"}], "-", 
         RowBox[{"f", "(", "z", ")"}]}], 
        RowBox[{"\[ImaginaryI]", " ", "h"}]]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         SubscriptBox["lim", 
          RowBox[{"h", "->", "0"}]], 
         FractionBox[
          RowBox[{
           RowBox[{"u", "(", 
            RowBox[{"x", ",", " ", 
             RowBox[{"y", "+", "h"}]}], ")"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"v", "(", 
             RowBox[{"x", ",", " ", 
              RowBox[{"y", "+", "h"}]}], ")"}]}], "-", 
           RowBox[{"u", "(", 
            RowBox[{"x", ",", " ", "y"}], ")"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"v", "(", 
             RowBox[{"x", ",", " ", "y"}], ")"}]}]}], 
          RowBox[{"\[ImaginaryI]", " ", "h"}]]}], "=", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          FractionBox[
           RowBox[{"\[PartialD]", "u"}], 
           RowBox[{"\[PartialD]", "y"}]]}], "+", 
         FractionBox[
          RowBox[{"\[PartialD]", "v"}], 
          RowBox[{"\[PartialD]", "y"}]]}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->134273854,ExpressionUUID->"45336c0f-41d7-4409-a86b-f46716476889"],

Cell["\<\
Equating these expressions, one can conclude that for any analytic function, \
the real and imaginary parts must satisfy the Cauchy\[Dash]Riemann equations:\
\
\>", "Text",
 CellID->53463100,ExpressionUUID->"5ad0e6bc-a637-41d6-995c-479feaa0a3af"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FrameBox[
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[PartialD]", "u"}], 
       RowBox[{"\[PartialD]", "x"}]], "=", 
      FractionBox[
       RowBox[{"\[PartialD]", "v"}], 
       RowBox[{"\[PartialD]", "y"}]]}], ",", "       ", 
     RowBox[{
      FractionBox[
       RowBox[{"\[PartialD]", "v"}], 
       RowBox[{"\[PartialD]", "x"}]], "=", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[PartialD]", "u"}], 
        RowBox[{"\[PartialD]", "y"}]]}]}]}]], "\t\t", Cell[
   "(Cauchy\[Dash]Riemann equations).",ExpressionUUID->
    "e6260c70-70aa-470e-bc36-725918003964"]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{
  3.972997660984745*^9, {3.972997694904125*^9, 3.972997696682884*^9}},
 CellID->464752000,ExpressionUUID->"337bb773-1bcd-4722-97f9-d00902b9e820"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->14514036,ExpressionUUID->"e4494468-3b0b-4c51-b6a0-9e87004466cb"],

Cell[TextData[{
 "Verify the Cauchy\[Dash]Riemann equations for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["z", "3"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"94be2a55-e66d-4591-b8cc-ba1b79c20c83"],
 "."
}], "SolvedExampleNote",
 CellID->48679376,ExpressionUUID->"ed0841ca-a8da-40a1-8d29-29fd1060d38f"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"26dcd0b3-271c-4939-afa7-67056896e3dd"],
 " to deduce ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      RowBox[{"3", "\[ImaginaryI]", " ", 
       SuperscriptBox["x", "2"], "y"}], "-", 
      RowBox[{"3", "x", " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["y", "3"]}]}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "-", 
        RowBox[{"3", "x", " ", 
         SuperscriptBox["y", "2"]}]}], ")"}], "+", 
      RowBox[{"\[ImaginaryI]", "(", 
       RowBox[{
        RowBox[{"3", 
         SuperscriptBox["x", "2"], "y"}], "-", 
        SuperscriptBox["y", "3"]}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"428729ee-a31d-42c9-a8e4-1ef6fa18bd43"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dfadc34e-5ede-47e9-be54-682e8d96470d"],
 " is:"
}], "SolvedExampleNote",
 CellID->224612217,ExpressionUUID->"3ed09b6c-9c5c-45b2-b192-61c369a8d00b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"3", "x", " ", 
     SuperscriptBox["y", "2"]}]}]}], ";"}]], "SolvedExampleInput",
 CellID->48378144,ExpressionUUID->"e92c58cc-e58f-4268-9a95-c801b87af398"],

Cell["And:", "SolvedExampleNote",
 CellID->66269597,ExpressionUUID->"f3a99284-21f3-4b77-9d77-108e4f7d59e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"3", 
     SuperscriptBox["x", "2"], "y"}], "-", 
    SuperscriptBox["y", "3"]}]}], ";"}]], "SolvedExampleInput",
 CellID->179294475,ExpressionUUID->"333cf47e-2ab6-4a02-8716-c07ace006db3"],

Cell["Checking the first Cauchy\[Dash]Riemann equation:", "SolvedExampleNote",
 CellID->156141472,ExpressionUUID->"612b0568-0f07-44b6-851f-a074bf97986e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->322109515,ExpressionUUID->"e5aec4aa-3740-4e99-bb98-7345c8b31901"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->955556110,ExpressionUUID->"be087da4-ff44-48eb-a189-3eef5d9a5b87"]
}, Open  ]],

Cell["Checking the second one:", "SolvedExampleNote",
 CellID->38902700,ExpressionUUID->"6207a8d2-3a82-4010-9417-c5564e8491fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], 
    "]"}]}]}]], "SolvedExampleInput",
 CellID->163545968,ExpressionUUID->"991812e5-5aed-453b-9a3a-ef4e4a897639"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->83198450,ExpressionUUID->"dde8953d-c0a0-4f94-b923-4bdceb707859"]
}, Open  ]],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f30cbca4-4214-49eb-9104-f7288aa4d266"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"51700044-40ea-4bca-8225-90894b6b57b6"],
 ":"
}], "SolvedExampleNote",
 CellID->540803316,ExpressionUUID->"373d2114-e8fa-4440-a79f-b5e3fa83206f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"v", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["592", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[
    PlotRange -> {-2, 2}, ImageSize -> Small, 
     PlotLegends -> {"\!\(\*u(x,y)\)", "\!\(\*v(x,y)\)"}, 
     AxesLabel -> {$CellContext`x, $CellContext`y}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->19481094,ExpressionUUID->"9393e3fd-423e-453e-b6aa-19a5ba5704d1"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJy0vQu4jdX2B7xTSiXpTqmEROl+UZ1q7lSihO51Kt2lQpJuuukmXU/RBd3Q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      "], {{{
         EdgeForm[], 
         Directive[
          Specularity[
           GrayLevel[1], 3], 
          RGBColor[0.880722, 0.611041, 0.142051], Lighting -> {{"Ambient", 
             RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
            "Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
             ImageScaled[{2, 0, 2}]}}], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxFm3eYFcUSxef2wrL3DrAzq/cuqIgJ88Occ8RIUsSAAcQsoiLmgGBEEEXM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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtmnncTeUWx/feOO85e795z35zjpkGlG63ebyaJxpJodlQVBpMzVSG5qho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             "]], 
            Polygon3DBox[CompressedData["
1:eJwt1nmQz2UcB/Cv2/4Wu1v2t+u+r1wdhkZy1Ix1lJUpplTTuCpCx6AxMiwq
iSLhD5pIckuKlK2srok0WyqNo4NyLQZpnNXrmccf7/k9n/fn/Tme8/trNGTs
gDHlkyQZD5WgYTpJKlczhsXsyTlJ8lh2ksyrnCQdqibJR+WSZAbuXtzzxmsy
k2Q1pMWNwM/HrWOvhTxcKd0meRaJn50lHtca1wH3M81eqI07IzZXbDZ7AZxl
b6HLSiXJOfYivpG4F6HYOBe3XL7ZYpvhbse9TlsIv4jbk5skZRlJMhZ68d1I
U4r7iz0MuuKa457ErZLnvHy/WYgu1+ld/OEqSXIImumzBbuuOmU0J6FIbH/c
4zDfvDZDJzlO0WxUf1BYF9w0aIf/RY2zao6HbmGd2V/SjaRbS/MCtKdrim9j
jVvDXL6h+luDO8q3Rez7YieoeSlPfdxJcdX1uIeuBV2tMMavkbsLboDxILkG
wgqxG+S4D1eDLgvWqlHRfCrk2yu/w+iGwg1y9RX/EH9DdgPopu5l/Fa5p9J2
tlbdcRWt1wq6BLc+5GJ/ha9Nl2Jv5Jsk13HcI7hVYY9wHXEP48YJLcyK85lu
/aam41reBDvoXqWrDlPENZZvJ24xu73YospxncN634HL1N9U9u+wnv6yXBn6
2SKuBtSkuyKulLalObWA6nT1reclsVuMn6PrZG43072XHf399DJanw+yr9B9
jCuiu42uB25uTuw19HwSFqh7AteHf15YE6iGGyt2JX8bKOZrpbfz+CXsbXpu
Gs6/uJdwC9jL1LyVbyv7HvwX6k62h33wA9hLYJeYbbipqRibL+d6/kbsn9St
lY7rH/Yhkz0WX6aPWfjTzkD3JJ7NEvYf5jKY/03oSd9W3CtQYryJZhK+atgL
43rWri48wHeBfVXOHfz91biM6yxXWTir8hfjl+DPXdvLJvxPiV1sbn+rWz4/
ntmD5lxHTy3lqh/ehHAn8dPoH82J6x/2YT/uAFROx30K+zWJ9gPcBbEF8u6X
axV0oX9GfwV04+UppRkGR4POWm0Tm6fmPtom4XzT5fAfTsWzGc7oRbWXy/9p
iJXjErsXvpLYgfjh+GNiD0KDVLxn4b6Fd7KBHv+luQo9w36KqxfWnv097QT5
dtHthgx9HNPHXfqv40x+SJtNM5P2TrUO03yLWy7PejUq4SfkxDe2aSpywTcq
O97NcEen0Gzmu6i3XHUXsRdCR7q2NAXiuxqPE7uJrhc7RXtOX73pVuhljric
zPj2h2/ALfA2fQO63fr9DorleFq+EkjL83KYr/pH5KsS3jBzO1Ilnq9j6Xg+
wjkppBuCO0KzE1ffeG5mvDvhDn2OW0x3Wo05UINuf3jr6FboYZG6E8P9o8vD
zRZbIPYorpw6u3AzcN1whTTd7Pkh4yfMYRQ0lyvBjVCjSL6VtP+JbYUfzv9n
VnwbZ+L24WrKt5TuHfpTuH7XzmQVfF/aIjXb4Qv4l4ZvQTirNL1hpv6rWoNn
+e6nOSBfXf7V8m3FTQ/fT1ypPKNw7eRtLG5aOp6Ju7PimRwYzlBufBvW0b2F
G4k7GO6IngdDx/DOO0N76dqHO67uHNz2cM/D+2L8K+5EEr+X4dtYZlyix4V8
h2iu5sU5NZGvMXydE/OdyYjnJZybVmL/wS+1Rp+FNxd3Gpcv/hNccfgvgJtF
Uwkm0tTGbTff2ezydD+EdcqM9yncq4HXvgsp/I9QgaYq/wYx7fXRDt5QP8F/
w78zFfcg7EUxXB/6CPtEP1qNHvBuKr4D4T0I34oxsIz/aoiFE+HbmxPfvfD+
7TLv19IxPuS5ghsFx3Pj2QpnbI6ezofvHN3/4AQ+Sg==
             "]], 
            
            Polygon3DBox[{{4415, 2734, 3985, 1654, 59, 4416}, {5665, 3087, 
             3086, 2152, 2151, 4576}, {5591, 2544, 2420, 2072, 2071, 5380}, {
             5659, 3047, 3046, 1818, 1662, 5384}, {5760, 3894, 3978, 2138, 
             167, 4486}, {4306, 2597, 3888, 1681, 2131, 5392}}]}, 
           Annotation[#, "Charting`Private`Tag$20062#1"]& ]]}, {
         EdgeForm[], 
         Directive[
          Specularity[
           GrayLevel[1], 3], 
          RGBColor[0.368417, 0.506779, 0.709798], Lighting -> {{"Ambient", 
             RGBColor[
             0.19699838300000003`, 0.252204821, 0.33320940200000004`]}, {
            "Directional", 
             RGBColor[
             0.15473514000000002`, 0.21284718000000002`, 
              0.29811516000000005`], 
             ImageScaled[{0, 2, 2}]}, {"Directional", 
             RGBColor[
             0.15473514000000002`, 0.21284718000000002`, 
              0.29811516000000005`], 
             ImageScaled[{2, 2, 2}]}, {"Directional", 
             RGBColor[
             0.15473514000000002`, 0.21284718000000002`, 
              0.29811516000000005`], 
             ImageScaled[{2, 0, 2}]}}], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxFm3e4FEXWxkfv9FzQmb7udDODbnBdFTEBJjCwqxgABQVBWAEzIkEQFcWM
CggmJEuQqGQFJQsCImICQcG0GMAIqBjBVVFx359vfc/3Rz/nTN3q6urqqnPe
855zD7qiZ6tr9s5kMj2zmUyFZFQzk6ncL5MZU8pkcoVM5ks1js9nMvvHmcz7
0jtLtokyme/Uf4d+n1A9k9kpvb5k6zSTyepve5JMZmY5k1mp+34uZjJ/U3sn
9a1UeyO1dZA+UWPPUJ8X9XtvtW/XtVntx0seov43Sq+Sfr/61FXfszSfqEr9
Nf4SzWG+7rugUnPWXPup/Xg9fx/p9SR/0XyOkXxZfW/WtUu//6J7PtCYXSR3
696N0u+VrNLv16R3kuytvtvVd5V+t5b8XNfz0t/VPLZJP0HyYM3tBrXF0lvW
0HpIry79dOmDNZ8lkqdrrr3Ufpfe/Rz97XDNv7HeY6qeMVPj/Ee/P5M+S/om
6Q/oudfrOkK/H5esq+t+6Xvn1Ff6JOnL1e9ByWWS9dT2QNbPbq7xj1BbE43/
X405Tu2v6vdpere6ms9urc3ZmtMW9V2n+Tysfufp7y00x+PV51y1D9TvA/Ve
V0mvpvFGqM8X+ltJ+u+SH6p9uORItX8pWVb7GOkX6L5WGucR6W2lXyB9vPQL
pbeVPlH6LvU/TP1fleyqcZpKvqv5v63rSM21u577u+SP6nNNygbUnpE+tlom
0036I9W8nrU05vsab6GukXrPG9V2W+x1XlTwunWN/A6zJLtE3nMDJK+O/M1u
jd02S/2v1P0zJN9j3fT8lpH3xKPq01367ZLnaa43qe0H6Vt1NeQ7qe3v7Hfp
/fS3rNb3eemL9fcrda1U2wTJ0erTQO399fse9TlW+iWSl8Vu+1Hya12n8iyN
eb6+9Wrpp+k6XvoKyRPZu7pO0nWv7pkdeW6cjQd177XS75K8V7JneNZeeqeP
JUdqzIf0bo30+xy965bU++ZQ1lhtH6nPCPW5RW0/aK4bWJ/Ia8E6VFef71gP
9Yml75Y+Q/q+Olc/S89LtufMSN/JGSp6TL5dc+23gv7+guRujXdJ5Hv6qF9f
ydoab6Darglr+Fjs+d8peUfs91uqPtV0fSt9sp77pP7eI/Lzuut9DlG/N/V+
PaXXk/6O9PVF71X20mL9Hq/22/T37rHt2AGSb2vM2prTsZLjdD7GqP0Nyf76
NkPVvkLtFep3rvRLpe8tvTnvIH2y9E3S95L8XVcT9lvss885ukjPH6CxFktv
InmnxrxA/buxP2Pbkz9JTme+0jOSl2t+bdT/8qLfi3lukt5CYz6jMRZJ7tBz
vtR1vu4ZJDlfsp6uzRq3LntR8nNdJ0k/S3KYzsxZnFnJ59T/U7W30vWC9K2S
b+tqpHEbq8+RkjfqOXuprbXkefqdkf6V5rBR89so/TeNuU/47nz/biX7gjXq
85PW+kj1u0DrfUni9Zys9mHSn9Z916h9q2R9jXMa/kTXKdKbSO7Q1VB6U8kv
dJ0svbHkqYnP3UjJXbH3bTvJ4Yn3RU+NWa/Saz5E8lCdl1Xh7IzXOx+ocSZg
P2Lb/r9JbtacztDc1+n9Zsc+71dLbkvsF9bq788W/V4V6rddzzlR954pubLo
Psep7/dqa5+1z7i25DOyRX9fousN6b9or76ksc+L7DM4C6zbVv19otpeUtvp
uq7QWLOxXZKj1L5Sbf/U9VBsX9BX8vnYdvI5ybc0j8P47pIf6KqDPyrY1tXR
dZ9+P6nraF3jNe7u2OvRUfJVXWer/SL1n8j5wlbQntrOPCb5pv5WS33qSE7R
2g3WGFMlV8e208ep/V3pY6Wvlb4nsq85SNfUrO8donveUvubuv6h3+vVvynr
pf4/xbaHl4IjCp7n8bxLbP+2rmBbtzHyObwk2NBXCvaj2PnDCvbffIsbpP+M
X1Wff0sWtAfy7AP93lLw+ThR8qms12qC7pmb9XmZyN7CZrOGfA/dtyTrPbpN
9zSgTfJrXf+S3gw7xL6Ufq7kWuyd7l8u+aF+H6P2kyW3qO197Ld+f6zfx0o2
5Oxr/o/pmS2kd9P3Xo0vlpwR2Z5gX6ZFtgnNdM2MfU5jyZ/APtLbSO5V5bOc
V/sbse3BVWp/VPe+LP0MfmvchRr/WckXde3RN1ylPdhdehf1vVlnZ4j6L8x6
3ifmbBca6cpVGTM9o7E7pF7/R3VfE+3pLhXGHmuDTtvF6jNGfaYkxjnshTGS
tVJjlTo6H1OK3o+Xqf0U3T9c+t2x/RDnmvN9sZ57gs7xTZU+c8tZA/X7j57x
C2uqPp/m/R3Z+8cEG44trxvOBefjKY35gfrPlVymMRtqvMsk79Lvh9V+t+RW
jXO39AEa85O89yH78WPpR0l/r+B5Hhu+4QOa983SDy/5rHJmayS2cdi6Zmqf
JH10hf3sqKLPTnv1OU1rO0/3TtLvsdhEyVtY16LPyhzpryS2x99Kvyt8l0fB
EGA1yTtS76unWWd8NHhLc1+k7zhGfYaq7Ub1uTP4hcn63Tfyfp4W9vlSzqj0
xXrWnArjumlFn4nLE+/3Zbpm6Pf0os9HR7Wv1bif6Fnz9KyZRY99b2ocxDlj
rK3SV0t/CnxQ9Lv2V5+ndf+TFcaKSxL/vabkRPUZJf1i6Q/qukX3HqF36pva
DvZLjSU515zv5fq9Xe0rJDvr+g9ntmSM2UT6bsln9Y2/1z6/Vt/w6tR45hT1
uV7jt+NcqG2ErikaZ6Rkj9Q4p6H6PCv9c7W/DpZMbNvPSo1tOXecv8/z9ln4
LuIF7PqfwRSJ/cvJGmdY3hj7QLWfmTo+2poY/3K+wRE78z7f4AdwNPb+q4Kx
Nn4Qf7hDeiPpu6R/Jb0/tl39nwn4Hz+4pGD8f6H058qOZ+prDvfr9z3EBuAo
Pbur+uzP3pB+tfQDpH+hK6/1Gq37WpdsV8ZKvyL1c3l+p9TzZL7N9fdHNOYY
fKb6t9TvUeq/VGMcrfPVvsoYZiR2Tu1dU8dO+MF1+v1ywTYEX3mSxlhddiwB
Tuure1fpalTdGG+m+t6pe89Xvz66pxt4SeMtLjge+ndsPNsg2On1GmtNwfan
ka4/q/0w9d+Wty0Hd5wR/Dj+/JGi7Q/nexhnSO2fSL9Dc1vDGpcdiz2h9pH4
GLUPV/uCsmOW2VmfyYvz/vtLsX0k532a5BQ9eyGxqfq/IDmROfOueduHy4h9
9LwR0j/FJ8s+VOYcB7aUXB4wP7aNOJG5nqr2aVmf8zYav0/WcTRr1bbC6982
9boRu00vGE821LMe1jPmZP3c2qn96jj16aNnTM/aHj1UNAbHpr5T8HPAGIOK
xurE3awxmBxsflaYJzgAzI6PIO64I++4eU/sGBpszG+wUGPOF++sORyi+z9J
HW+DoTKaf1bfv5n6RNV9dltEjkc6B87h+oIxZ039fl1r+15q/7gpnNfPsh6r
oL+vr7Cf61c0hjybmF3PzOW8to/q3vnq92TYm8SFxHp8h+uINzXWwZHtUvuA
Z/iOA6U3zhn3TABHpMYtszT+buIbsCd+WuswQH0Hacy2ed+3Svo66d2Yj+Qh
6ntr1jxI0xAXH6S5PKb2F9Q+N8QPxBEDJTfpWafrbw1Sx5q9dL2Vtc16U/L3
gv09fv8vkit0LZD+Z2xw0X5gie6dU7QfGEzMrf36se7NaM0HcFbVvrf0N/GL
at83tu1EZ01fTcyFYBNa5czDMKef8/5WA4NtA8PM1+/liSX2pLX675/zPpge
MA/zeyfxd6sj+YXa3836HdYFjARvcLjuq50zPmmS2sbCw4D3X1T/efi/vO8j
RtsQYnZid2wmHElj6ReltpmbJVvo980V5mV+jYwx+HYt9Jxl0o+J/J34Xv9g
bbUWQzij8GCSg7LGQAvhEfDp+vuFqTE4vBD2GR7irLxtF5wD3MNr4Db12VNw
TIf+rP72nO5ZJPlXyXlFYx/4k9lF+/z7Nfbcov0zHMtT0qdXmHtpn9o2wpXB
F3He8a+rEu+fv0nWzzkOZK80Ts3Xfa72Dolt0TiNNyI2Hv6UuFv999F1OPu7
aDwCX7RNY+ybs1/vnfecLw3r80ZkHuoe9b+lwnZmZuq9vL/09dJ/Jh6tYS6F
cb4pmP/C/mE38zWNL2vrWbPU//XI94J9tgRcDdYAcxBXcOZ+Dd9uGbGMnnVw
YtzIGeQsboi8t9gfnBd8PXHQ41m/J++4PNzLGOABvskzqTE+cwD3E9+si4zb
zi455v6s7HhifWTMRLz2TuTzTgyE7eD89y96vzXT3C5MzPPNkGxccly1TePs
LBvff5aaBzpMczsna5+D7yEGG1Y0D4TNwSa9FeKsoUU/p13ieJH++KknNdZ7
kXEm2Bh/tZ14XNcr0m8vGccRN4Hlxhft1+alPhOs7UNZ28bqwU8R3/At2Jff
Bc7xw9SxFc+qG/psDt9rfmqdMdljwyL7VM463wWeparK3wKfCN/JPmYPs5fR
sbOdS44Rvy6brwF7d5Z8CVume/6d2C5jn4lDXmEvSz8z62/JNz0ksQ2nP/vj
GO3FUzTGihqOZfeE9v00n/3wB/jQ1H5sTWL+Z6r6TCJ21j3Hyl6+qzXrkRjz
dA04E/7v07K/IZiT73hD5HuxkWuytoPYwE1BByOOTm1jsbVPa/wOmttPGn9p
6nfBhn9Rth0BD1cP+AGftTK1nT468Xf7OXw7bAy2hlixUOX2TeDG1Db/qMQx
N7E3e+s9MGSF+7QrOb78smwOcleIzeGiGJM1/SzyeQTfv5j6PLWBt1fbb+Fs
4leZJ7bmfI3ZGkytMXek9svTEsfgH0b2Vc9G9qnc+3HgS+FNibs/iYzVYr1L
pHs+ir2XP8Jma9xFqe0Vdmth6niEuAS8NzRynE6chE48k5PNWaPvnNMc7szb
73TFjsXGLDNi+118HbgFX4RPImarKXlkzr74Wb3PT3mv52+sr+79OXZsfXjw
X/1i+6vzNX6fvL/1rNi+9Iicn/GAnjE+ss1nzc4O61atprEs8Wb1mo5JiEOb
Juaj26V+L+JAuI8ZWeM8MN4FiTHlpanjQtZ6WsBmJ+fMVbVOHEdfoj5Xpuax
D018vuCjhsDB5O3Tp2nON+S9fzkLS/XuYyVv0dzmssfDmtyTeo2JHRdE5prB
Ctibc4LNGQ2nFJljmRmZg4Z/HpjazxBH3hvyNU+o79N61nd523m+3bfEMnru
L7HnDAe/SGPcHjnGYF7jIvM296Xep8SjAwNugRtsHrgdOB5w8X1h3eB4j8oZ
04J50Ik/78ub6/s7sVjZ73BTyXwu+Oeb2Dwf3xGuD66eMeGce8ONRI7ZGwSe
Cr5qa2pMPT41vj4+4FXiYtaJ2P0p/F4473AaxBRwDxm1Ncn5Nz58eGReq09q
HQ5hW2r7DddXpXW7W+t2Tg3zfzyLM08+AA7/yLBv4YbYx2AHMATri43EhmIn
wWANcuYZfw/t2OA7U9tvYv1bU8cxxF6cb/YesdlJgTeDP+N9zwpz4Lkn5Yzv
h2geD0Xm8XZVM/fyQzXnf0bglwt+XzgOcG391OeMGH9g7DX4TH32rbIf+LHg
vAj5kaNif2vOCPuePU7sh/8j/kPHTy9m/SKvS9vE9g07R560l8YdUHJM3Shn
/Aa/xFy65h1fwulgj25Kvafggcj/Ed/9wa1k/Y7YqepV9p/w+kvDe/EOPXVv
v8j8ycIwJmtHvA/n91/1XxDOPuetssp4BU73+azvhcd8ObZvfjE2Zwx3DDY9
Luf8CrmV6wr2C+B/eBNiAHjvXgX7F2Ks9trzRf3+p979KO2h5hX2U+Q/4OTJ
+Q4POYgRksvkx3phcyVX591eO2+ehfiNnG+/rLE1uPo2zaVD1mfspsi+FVv5
dmI/ho+7RHM4gHNbsm9tFuKOTgVjOTB254J9FPHR5VqTM/T8aD+tf+J8yP/F
HRsCDsEP45vxxb+EM85Z3xjiBeKGd/KOiy+QvCdrzoE4YUzgP4k3yWthk4mr
yeWQ0+mheW4K8SBxYa+S83eXBe6O74ctgOcES16ZN34Dc04P3CD7ie9+pnBH
dc5MdX8Hcjdz8s7foLeSvKLo+JLcOrw5/Dn50v76+wFZx5xv5I3ViWu2FZ3j
O1ffs1PZ32mP2m5IfF6eK5rvgt/qU3Y+g7wGuf72kfO25OpqR+Yo4CbIm+8H
F6X+B+Jnct5jSyrNTT1Y6fwNe2ap5LjYPPYPBe9p9nYr9mNsnEq80D/xHrmf
eUXG6NjuKxNz7HDt5HaJy7qRj0v8fboXzanBcbUMsTZ5EPIi9yXOCXctG8uA
aZoGe4HdAK+clngP9C6as4O7A29gXzij2CI4KNbzpqI5N9af7zAm8jnkDHZJ
HN8R53VOHNMR292T+JtcLX1nsHXYvGsS70PyS9eXvD9Xqm1IahuxMHGMzd7H
P99c8j6ZnziGgk94RnrvkvfYvMT2hDhqKTxwsJnYzhN0/xH6Dr/qrFyhtViu
3zuLjvk5f2CWZfDa7CHmnnod4IrvrnT+8S7Jr6s5l/eNZLuC/fh3fLtKc7bd
Ko1p8QcLJKemjk1f1jj7R+YqsSkdCvbX30u+lPibgOHJo/CtO+eNl4gPF6j9
4oLjzZ2S16a2Cx2ZY+Dc4N7gBomdr5acm9gXwUWDUfGv+Fbys+AYcM52sFBk
LET9Bn2mSI5KjK+/Tp1nnhx5r5Ln+kfO+f2hqXEWHAz7elLkPX1oyPUTF4xI
zOuSM/mgbM4X3mZRwIpgxpNCjgZfvFbns051n9OPyub4yGt8HuLGWonXEp+N
jWsQcqOMBV+yKjyX2oNSzrndryLr2M1aOXNM4Dfy7QeGM1vUnvh7zrl+aglo
h0uhXuKJyLle9tpj4UxxttD5HtRlUJ8BT9El+B24krqhHa5kauJcEjklaivm
RKE2IDHHSD4KrH1IwJYfp8bX35eNYQ4OeGlQ+v/8E5wq34JxOS+sP9zXsNTY
FZ7so9TfnBhkacD8YH9s0YTIuRZyqGAcajxYv0NDbL466PyNedUKc1ulOR0a
2+YfHr4d8cKWsvO7N7BnQ4xArPBB4JPhlWcEfoB4dnPecfwlefOzrAc1EvgN
8Dy4ihiLeIlY6fvAwcLFfpG4nurVovNt9GXfzkzMJcAVbMkbp12aNw4iZgAL
La90zmu45Gd5x/pdQt6Ms3Z8wJZwE08ljvHBTE8mxv41wzqQXyPH1FFyVjXn
1x6XfDfvWBNu/JHEHAbcSHvOpv6+s8r5OPKGV+RdH8J+IBcMhwiXyHdCHhD0
HYm5Y/I/XyXO75DnIeZYGPlv61KvFfEpHOrcsM/ZqyvDvmV84iJyPMRG6H9w
1+FMgYGpH2BM4pH3EvPdXTT22sTxAXmqbzm/kePHBSGmJrYG44N32ZPzYp8t
6mjgpeEeH07Mb/Nu70pOT7w/2acnhLogxqKeZH7k+JG6NXTmEQuX3qX1a1rD
uH556N89YB6wD7gaX/CR1vOcgv0SuW5sEWecnCyYAQxDrQ7+Br8zPHX9G9jx
Ecn3E9e0jE3NFXyt9lXSr0qN28akzm8enTOvxfqwJhOkD01ct9VDZ+IMzfU2
zblb2T4b3008Tj6OPP/tZWNj8qn7SJ6SOr8wMXW+Gx/9eOqcEX4DTNq36HqD
cal9A/v2Qendq+xfqHnrGHzEQ6n3JPtwReyzA0cKV7qh7Bq4k0M+kVzEbWVz
cXBVs7Er+n2dxj2xhvNu5A3qSJ+TmGf8Ix+d2P4+ndo346MXp7Zj2A5yI+T1
2We/Ss5OfB5vTl1XQ85rTer4cbD+PqjsvcF+oI7jODgsznJiDhZO54nUdSbk
FjemrnUhL0l+cojeZ5rO9/rEeUC4XHjoTon5id5lc0RfhW+6sey6MfKqbUrm
luGYT0hdw/Z66n3O+aqocnw3WPpQtTVNndOZlJqnYF+xv+DfiF1fhjcrOEYg
jwjGpoaHmr+OmmP9StfOEdeQD6smOTYxjq2nuYxOHDvUlf5a6loQ5tMz1HRR
20X9D/g0l9p3H5QzbwmvuFeYQ9vAW2Gff60Wap8km5Sc4yO3D/dLjozce9OS
+WDy+dSgUg/7V73vYLVP1n319H5nlhwvkE97rex8Cflr6q8e0HvdK9lO9/5L
fQbofbfE5touVds1eWNFarqal1wbNURjnFty/dSwsjEQWOhfBe+34zTniySv
yjvupP7k7NT1TpNTz5m6oQcDvquvPodJ9sgbi1LvdHnq+gfypN0DXqIehpia
2oJ7Y9c8UftEDEitGDVjxGILNO/DhU+6VNkHUotbKzb3hM/Cj1Fj1kR9BtVw
nRuxwu9F16xydiYUnMckjqBGM0usrrWaV2X+HI4drr1T3tw7NuGivGMl9gZ1
g9SUXgsnVLZfPLZkHoxayV6aS8Oya1Kp6wD/kz8lj9pH86lOTbPanigaN4F1
8dHE/tRlYbvAL+R8/ll2bo8aBvAnuIDaqkZlx43syRZl12VSbwCGJz+/GVuX
N4ZnPcE/xODwP2Ce2cF2we9Rw3odHGTZMRt7/sYaPhsNapi7o57y+tTnlxiH
fD71cuS8yH3Bj8FdYluIPTmXH5bt39kzcALgDbAH9WbkFN4O69w1NkdIXRC5
cjAduR3wP+tPHqF58OP4c+JcYuGVsWuY4HKo2QZvgD2oKbuxbFzOXoXPI74j
zqM2mfiC2ipiG9aHGk5y8WChCaG2ECxJ7gv8AQ6hHpgYZ5Tu+7js2IYYB16O
mIj6hU/KjoXAqXCV1NLA1ZAXpaYN30xuGL+ML967yjlx7PDg4OsXBL9DTp+8
BPVr1FuTP6BOCc4BP7shdjwDFifvNCVgDzBI75CXog7jtGDHsGfU28CHw4tT
awdXD2cPpwHvQc0XHDN2idrMH/W3FdoDrWLjSXhkauSJHcDw1CaDaanporaL
PDLYjLNQ2E82Q/u8Z2w8TA0Z/r1TyTWwO7RWe6vPT7Jj29TnN92/Qc/aHLvP
GOnLtfdmle1T62PrdN2Ona7puIj4CDxDDEjsRj0gPBg1rDcHnLY42CViPfAX
tYrUlHJ+qQ3fnZhboDacPAscMXijIxhHc7i/0jlLeEBquvqVXetPfhMegbiL
+pm+Zf8PAzU51N6TbyLvdGrwHfgQ+Gpi9QFg27JzydSwkVOAa8Bfwz+AjakL
I2anToA6JjAT2Ik4idpLfHpSZf6BXP+gxBh1UfCD5P42BfxAvQ0YbpTknwrm
dqiVGVXNWGi0ZC+t7cWVXmfqcMDk5IfPK7l+dnjZ+VzsNvZ7V2Lbex5jV/n/
MqiTJv4H+/GO+BQwNjV6Oe2Fb9VeKXlNpfk31pYaQvbbW4lzN/gC8s/kqmYE
jEe9LHUaQ/LOeRPPgefInU0L78X/glDPg48jH09enr0yCx+t92tLjXzq2jJq
wOA9/qidTl2jTK0yXAR10tS3wE0R600M+I3Ygxjk9tQ+lzrW+wJHuB/2h1w8
sXOlsRkYhrrRcWXnkuDP76gKte5Z15eztnBx1MRNDTzA9rC2+Hpyf68XzY8N
CP8vwxpSp9JD14lal/lVxg/Uuj6A/ZZ8VO/7RJW5P2K521LXLcElYs+b1XBt
VOuy9z9cdRvp35ZdGwp+7gq/o+fOp2Y5bxzSIe/cJbmVPlXmdohR4QbOTf1e
+DXwA3EZNYDYjFYhr0ENInEqcQdxQ8sQOxMjjI5sW4fmHVfC68GR/pH31N+v
D7Xu1LxTUwS3jj+6tcrY8qa8YyRiFGrVvkkd/9YKWIzaC+ou7i46/sff9ajy
2ZlUcEzDc3n+uFDjTa03+YUhYQ3Jz7QKeTTwOJwutfzEH61D/Qn1LtS97CU5
h/fSfni8yv9HAP8JD8r/JMFP3lMwf9AycAuDi+btwQ/kT6hFoe7vf559s4k=

             "]], 
            Polygon3DBox[CompressedData["
1:eJwtm3m8TVUbx0/ds++5t87e13v3vkf1DtXbpHkklSJlijQYCqUSyRAlGkQy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             "]], 
            Polygon3DBox[CompressedData["
1:eJwl1nuQl1UZB/BXLsvi7C7b7rLYxWmaCpQQRIQg4rrcr7oCKUgiLXHXdFG5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             "]], 
            
            Polygon3DBox[{{5672, 3275, 3143, 3142, 3964, 5444}, {5430, 3948, 
             3463, 845, 1840, 5491}, {5695, 3354, 3257, 1880, 2376, 4845}, {
             5690, 3327, 3219, 3218, 3615, 5099}, {5450, 3969, 3218, 3219, 
             3970, 5451}, {4851, 3261, 3111, 1828, 1829, 5419}, {4839, 2349, 
             2348, 3958, 3632, 5743}}]}, 
           Annotation[#, "Charting`Private`Tag$20062#2"]& ]]}, {
         EdgeForm[], 
         Directive[
          GrayLevel[1], Lighting -> {{"Ambient", 
             GrayLevel[0.8]}}], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJw1mnmAlMXRxt9ld2d3ZmdmZ96ZnfFCEQXkUoMg96Ggn0bxQOVQQC4RRBGQ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            "]], 
           Polygon3DBox[CompressedData["
1:eJxFmnm81nPax3911vs+933u9ZyTJSqSNmYo1UkLxTCPnSyT9oRBFGPJEgaV
rcQwj12WYXjI7jVMKUsaFEZZ4sEMjz2TpQyqeb9dv9fr+eN7zvf6Xd99ua7r
8/neXSeefMjUjkmSHMefWv7XVpOksS5JJpLeLSdJ79YkaUGxTT5JhrYlyVMt
SfJGY5KcUJMkZ6Lv1Zwka8kfSfmp5L+m/qj6JNmTbzMqSTKF+jPIj0Z3P/UX
UOdT6n9CGkJbx6O/FP1E9A+ir+2UJN8WkuTchiQZjP55+r2W/s+nzKpcktxO
/eHovqD+UPTPor8G/eWOAf016C8j/wH502hvA+0PbkqSjzskyeMlxod+JPod
0H+P/lnG+zVjf4f2Tqe9/pSpkr+TMbSgf472/0D7M6nzOnXW096F2SRZxFpd
UKQu8rnIDyCfinxrJcbjuE6l/mWsRY61nUr/95P/hvLnUX4h5U+j/NOU21AX
Y1jFGuzOGM5jfkNI1zLW65H/Sb39KZ8jv4bxFdEtYHxZ2n+V+rfT35WMbw3j
+5w6x9DWGbQ1Bv3b1OmOriu6AciXo7+D8q9Rb1/kzcz/EPRL0P8buTvtHkZ/
U0g9yH/C2i1l/A2syTzkhbTXh/4Po05f88ynlfa2pb1h1G/j20LqzqbsA+jG
M97zmXuOOqPQzaadLsgvk+aQ7+8ZoOxXpOso3458DmXvQ7eLa8G3H+nrHtee
9rem3NG030Sfj/LtbdbyBNamL2W2Rb60HOvhuuxD+cORd0LXRLmByJ8i/4Tc
zvpsQN6COu9Tf0e+bUm+kzJj65nKfem/jfa60N5wyh+HPAfdBOovTOtb9gPq
9GOttmN8kxjfeOp0I58wh98ij6DMj6x1F1Jv9ucw6r9E/R1or0rZzrTfjvw8
6VfoVjL/K6k7inwfys+izIP5GIfjmUh7I3PRju1dwrcH0J3O2nUiPwn90fT/
Au1dxfdT+Fal7wMo353yZyPfxvfdaGM4Zad6h1wz9FuhP9kzhXw4cl/k2cgP
Iy+jvSvyUb5CexlSHv3plHsb3b7874w8Hf18yg2g/a3rov95yJeSXmmM+TlP
z43nZwJjGEHZA/m2A+XP4dvt6liDlsa4k97NpZQZlIszu4m+DyPVUf6X1HuG
/qcw583oHmcdniFfRr9lXfTl2k5viPM0jm8vkq9wX29wP1N7cRDleqA7l/7v
pP9/sz97sq9fsr9/LYVN2Bv5gA4xHtu1/ZNqY26/ybAebPtu6K/kzE3mvB1Y
E2txHHVn0d71aX9zkaukvWhvf88P7W0sx91qRz8Z3ZP8754Lm7qRucxAf1JN
7MV09L/k2wL6XpkP++mZWpCP/fWsaUO1pd4p79bBtHUe9beuDXt2cCVs66Hk
Z1P3kFzYus61YW9f5NvcfJyHrathn7Q1g2jvEfJHUeYK5O1qw/70a477Nd4z
QH4T830oG/ZrCPZupvaBujuiu4S2B/B/o+tB+VM9O+xZjvxY5rttIc6V56sz
8tfNMU7Huw39rSb/C8Z0G/kV+biPyzzztP8VZRr4VuHbcNZ3JOvbqxR+Rn/z
PW2+Sf4s1vPEmrhb09rCz+nvxvNtz1zcS+/nwcgDc+Hz9H3etVPawg5oD7Th
b3jG6P9B+t9UG/7wZMqPrYmzdCLlezHe+egW58Mfas+7Yl9L1JnK2vxNn5GP
87QVZQfxbTr1X0b/EPmOfGtI1+otyibI9elav4k8lf7G1MTdOUF7b5vUnZbe
D22ottQ9+qEaPlBfqI3SVp1TDn+n3xuBLt8p7tTBtLGiJdbUuS1viLV23V3/
D7ify5G7uSf6V9K13IW3SO/SdB/Wfw/OQRtngE/J+/y5lbPxJv/fQe6Nfjj6
N5DXIPdCHob8BO01036JOW5BX48j55ELyJ2QtynEWWlGHsIcv6fNPdjvL6j/
VCnWe1d060k3cdbHp/7/mfR+Dab+BuayntSb/HnliDeMO0ain4l8HfIy5L2Q
5/B/BXN9mTQ7H9/VX1AT57GpGmPTB+uLc9UY+xTSF8jZSpyf1dR/kvXsyRj3
YKyfMu+7GfuHjbGeNczpI/I/UWcddUcif14NP64/d423I9+V+v2p/w/qL6D+
U6zBi3VxZ4wB9EH6omOp35N8F8r3o/wHlL+tNfZrBuu9c9reruj/C/1X6O9F
v2Mh6lZpbwTt/Q9lNtVEjFjMhz/0DLj3V5E/ivH2rwmfPsH4qS3qaJOnod+1
KXys/vbqYpxJbfejDXFWb2qI+KQ7aQb5Hui+pOyz5Jsof1ZDrLVrfj35XzdE
7PmT/o/8c9XY67MpM4uxnNwQ9Y/g2zJtP/0tZW5LmXOlJfyEY5uE/iXy37E/
G2mrZ2qfbMO2ljDHL9si5prcFHfWu2v8+E1dxLiXUPb41H6P1ea2RFxpbKeN
eJf8ROrM03ek8dFG0gbGcyTfRpbCnrVTvpY1v7cSPlZ/rF/W9xoTeP48h/qz
xdRdzFy6Ub8P9+Ul5BXIPZB3Q764GHMdRP6vrWHD9a/6WW37W40xdufwtmea
8Z/j/Ujj1+PKEWu8wJ4NbosYQv+unze2OJ32H6L9nWj/qdawWcYXxhnaMm2g
++M+aRtPK0dsYowylPndQZ2rqDuA8d5CWxsp9yRruy/yJmNG1uSkDhHj7Yf+
8FLE0ici7488uhh5Y0xjzQb25n7ys/l2E2vxAPr9PM+kxcb/rOut5M9Gv7Y+
4vl+9N+db2X08yn/nvEk8pbIW5TCdmnD5hVjjI71/0iPoXuaVGHdyqQW9uYC
/j/bIfDAhY2xv7cw74vqI34fUYq93g/9L2jrhaZoi2VKlpEfRPqoQ8QQ8xhX
rhR7uzjFC2KYHcl/nAlsM5DyHxpfJxFvrKLMa+RXZmK/9en6TO/MiNbwx5vQ
HUWdvWmrE+Wp9rNN0DbsVQrdaL4NLUb/YpVHqfMqdfdFHo3+6NSf237ffNxX
Y4lOpbDl2vS56CvIOxjvp3jpSPZ/Qm3YJPGhNuP9xrgf2pLPWKuzG+NMPUaf
P3GeJrJ2E+ojfhYfnlGIGER8tJoyt6ObJx7MRh/25Z66t2spexm6l/i2azYw
rD7eeHMa9b9AP7Mx5tgN/RDkHzh3/yYdSts9WiPWHJSefzFTn3zEIGIpMUbv
fMRMYo9b6X8g820ndWPuNxcjFnRPHxVbluJuekcvRHdPMWKTbZC7kL+bNAL5
c9KTlP0T8p7kPyP9BXlnztDR9PUaY/4L+TnlwL5izttYz7ZS+E596JXUnVKO
uS7LBb54jzpPo3uaua1mbm8w3yJttXvmC4EHj2E9J9dHfK2N0FYYU4xrDbzb
KxsYLkNfl2fj7HiGDqfNG+lzS/JHpP7FO+L5bueczqfQw8j/7BA+S9/Vpxxn
bRNyX/LfML6VyC9T/73WmI979wb6P6fn07uzHnkJ+TnZuKve2bczEe/dzLc+
SazfduQ/Z17nMMcCbT/Bt086hM/tme6Hd0s7uqo17MsY5Hr2/8aWsPdi7QdZ
j07InZGvo2wrNuoVyk4uhq3R5pyFPJR5fkp+K779N33/njofN0bML99hzG/s
L+aQv/iStgZQtiNl/m4/xbBN9mFf3jdj5w20uZT8b9DPJX8uaSzy/ciD0E9L
/fXt2fDfPfl2bCb8q7GfeEesJH6R29BmabvENGIb6+j7X0gxnJhlfGv476HN
EdMY23if5T5WaK9L4ZP0TQfo81rDPnZGPyYTtl0foC/wzI5pDXwiZjUGmtQa
fEhvxtyV9ppo7xrq9+8YGPwh5GwpdItSfuX5NAY7sTawnfdra3SjtQO0dVMx
1v6oNB7Sf2irNtPGMvJXZOPssU3JkZmwV9qLN/l2r3MjrdUXU+BOyl5LGoaM
2UlGZWI82nZt/PzUP3iX9bv/S3/XUX44ui3SO3AX4+mV7oXxnXjvT9m4b4vT
+91b/g39PejvLMbeTUHuS9k/ZuOsbpnOaVhT2ALnfEM2Ylix4qE1Edt2yQXf
4fmQD8lXAsuO49sp5cCIYqDBdYEdfyjHWg5zf8oRnzvX9+hrs3xcJbCf50Es
Kx4Y1hwxrbFtrhJYXYwj1qmrBPY/CPkY5OW5GJ8xkbGRNnRQOl5jCzHFEw3R
pm0bYxtTi+9+RVuPUXZIfcS0bXyvqQQ28rxNElsjb18bnI/215h9e7FcTcTy
+6Qcmfj0gEpgfO+f91Gu0P665wNjGeuLebYT29UEFhITig3lX+ZWwqZqW/U1
HRhvuRLcyFTKn035buzhK94P1u99uatycCVyLGPJH1wObHRWEvd3/0qMTQx9
GbqmSmB37a1YrlgJbkeMKlY1Bn6uIeJdY2MxqFjUMldS9thyYFUxa3sl5iOW
E++PqASHJYdkDGYsNr0cWFfMOxj9PsiFmrBJ4qdpqf+Qo9kd/alpPCgHNaQS
/tLz8iNjeo18phi8ivZGuyMnKMdjnVPT8yBvNTHdfzkRuRHPzPmV4OjEja6R
3N0R5cAmxszGzm3U7VETnN0ayk0oxlqKiQ5K19ezv1NaX4wh1rDOIcijysEV
zqTMuFKcF7GefMde9F+qxF7Lsci1yJmKuRyDYxFTi60987MqgenF9t6x2XK/
7HmHxohfV3G296zE2su5nFsOzkbuxjMzrxL4ql9NxDjisx0KwRUek/Kv27cG
HysvKz/btRCx0HGkXoU4w55lOaD7vAuF8N3ieXG9a+5dWJmLvdicYl4xuHdd
PsP4/83G4PYfJn1diJjOeNH99y6syEXsJF8tf9Ge8h3ycfY5MrU/s1P+/WrK
3FKJNZtDX+VsrOXCYuBN99i9tq+bGyJ+tE85+DWNgUfEVsspdwXy5Y0Rvy3N
R9uDU/5mXDneGlyjdfqDSuhXNwdek+OQL96qENyHMZCcjjGdsdFq+abG8KH7
FAK3il+7NQQnbbwnV66NOagSfIPc85iUn/r5DlH+lVzcrSNJuzUH/+T7yVHI
A5Efo70zWyJm1h8ZgxuLv1MO7ksOpwNj/USOoDY4zc2VwLPf1cWay1/oA/WF
xmDGYsbcrp2Y2Xi0oRr8mTya/LZ7aOzf3hB7K4Yw3tHn6nvlw52La+RafYY8
uS7aaKxGG7ZlGctq8/YqREymLZQz8jw+lb6nrGsOrm5/Uqnw/28KnmdjyzXl
4AbF2OsZ+/JqcB1yHuJd6+dqYwzyffKfcureD7GA98O3CflQedHhhdg79/CP
LfHmsXtzcBTyL2IE31J8UxI7yEkckZ5XuQpjav2pfvXGbOCxWR3TGJ78uEzE
5sboN2XDT+uvxZR3IC8g/drYnDofNUUcom82Zjf+Mw4yHjKm11//Vr+eBH98
N/LxmYhV5X/vMlbNhq0zvjQG9H1De5ZFnpuJN5h65rq4Y7zNyA/pa8Xkz6Tr
K9+xa8oHygfJRcmZ6T/PbA4uSk5N/uyiYvirAdnAA8ZAxkIvytu1Rsxt7P03
ebrWsKHa0tZc+LfLSacznmdo4/VixITGhoso/3prYGjj89nZiOc9X/K9g9P3
gmuYz8WNEVP5jva75uBi5GTkl05rjrdI97OQj/vie2P/lP9ckw1b3sR6zMtE
jGesN0cehP6eLwW2mI38cmuMcWfq/KEQY19Gmk/+Q87ThpbgN3yrWJeup5hX
7Psg4/sSfd9s4FLxqdyHayaWWpLEWoohxBJirK9aov8T6f/5joFvfkzfA+R0
5HbEP+pKfNu3HGv2+2xgZtdSfyyX6RnbpRQxm7ZPG3tf6q/ka/rxrTe611oi
XvXNU37AmHhuNjCosbI2yfV0XbVVchI/44tMcBXiV8+75168Jn9irDo9E/Gw
+NTz6rn1vhizXp+N824se2A1uDbPoPfbeNDY0zeVztXwifpGOVq52tUtMTff
WHxrEaMYO/hGo/1zD5dngwNyb31f0FZ6hv6ciz1379XXZwPT/KtDvNGIdYyx
5X58YzH2Fh8Zjxvjj+BbQy74FNe4MRfxvrH7x+kaGs8be4sZd2+KeFx8IcYb
0hSYUOwnJyhW7FONvXBP9H/eA++DGEabKyYV2/smIVb1Xnm/5J/kLLx33j/3
v3828IrcjhzPgKbApA0NwYGJVesaI1bTHmgXtKdyh75xXF0OjC5WvwTdaOp+
Xp++x3aMt+lVKQYVexq7yEH+oz44K8+D+F6sJGbfjcxOtN/f97Ga4BuOzgR3
JScmXzWVeut8F2CMh7QEJ6Ztc0/cG+2b+FYO7gc5yUy8BTtGfdrMTGB7OTLP
pDysvsL3Ct8tjHmNfbUBN+fC/i7qGBjWMyQm0Xb4ZiGe0A5oD+SsNmfCDmgP
5Lj0wWJabYsctVhXG2GZn310S+Aw8dii1L6L+bU3uWzgc+3HI9loX3y+S3P4
bn34I7mw2dpubUCd97oc+PCTFN95/vI1wXkek9rcF1MOd11L2FzPiBj1Xy1h
Xy7KBockdyHmnJUNjlIsqv1YlHLCa1vCfs3MBocol+d9ck3kODa3xD30PjoG
z/9YdN92DB8oH3mKcVoSvwHQ33iGtNna6kzKtxrfyYd7B1y/F7KpzSsFfhQb
yjnLPRu/+fZmTGOMJmcxLe1D/qF3Oc6yGER75+9J5Aonpe+f2ht9sHd4fUvY
MG2Zb2I11eCgl6T2WPssvrg6H2MQv9Y2BJeizfN3FfowsdqrSfg24/s78oG3
pqb476F8vAGIv3y/kFuVY5WfkCP3tx7aY2Nf9++SbHCg96b7Izcgp/V1Gp+c
kb5pZqvhE+W69MH6SvHBI/mwH+IP8blY1zdm+Q7jSX2k7y91yAOzMf5XUv8j
XnSsvnn1rMYbo7+9UfYtTH9gjKIN+5bx3FAMezcqfY/buxLY2zcw8fPISmAj
3wTFw3I6Y9IY57uW4FjkJbSR8nlyzivT9fTtwTZtu1OKN/wNSFND2AD5ejmR
Y9M7Jh/n/TCWyjGHHUvBIcqjOEb5aWN6z43nx7cZ/fHTqb/9XTHegH2TFZ/4
lrJ3OW0rCe5cTKu91Obpf7xfF2eDMzXW0S5rn43ZjPe8o9oAx+TYXO8l6fuR
85OPEKv75uHbh3yaZ3ltJvyZ/etLvPPOR75A26kN7VsNe2KsJyYSj8qniD39
zUfXavBQ+irPu/Gm78TeNe/cd/XBF3hW/Q2I7/3yPXIR/majWzViLN/QjaeN
vRob4y47xoy/sSlELDOD/KeFiKl8WxaTGGvpR7Xd+nzjVfHuXfkYo3yP8ZSx
n29qvq0Zc/oWbYxvLPr39P3JNfNuylcszAfmFHvql/XPxtTGv/8BRaz4GQ==

            "]], 
           Polygon3DBox[CompressedData["
1:eJwl1Xlo12UcB/DHNDd3ON1yLipoHg3dVnRM3dRpnlEe0zIzj9ShYFkeIC6I
zTTnLN08EMFymZhQSTpTMTpMDVTwCMn+6PIo88BmWmlhaq+H7x9v+H7ez/v9
ub7f3/PLnzpr9Ct3hBAq4U74tH0IF1qEUJ4ewrq0EK51CKEUqlLEsLZVCDXZ
IbTIo3G+IjWEesinOQYn24TwNPxLu0b8TrsQTot7yPeLvJ/IPxw3U63W/Ifg
Nt0kOfu3lC8zhJUwOTeEPHxT6xAaYC39q7yv4bZmhTABKuln8K2X74waPdX4
VY0ddCV0z+uhM4ylndIxhLfpTtE9A8qGPHHhXSE8ZvAJbUPYrm5DTgjdcI/i
xuO24epxE9Xpp94y8XKYpL9K3AhcffTBC7g/1a2TfCn8rMZKNebBV56LcDXw
e4eEj+ePi5fAVVx7fXfV/2H8W3Y6CTeM7qX4bmgOwi3cx7jLZhho3mb6L/ne
x53H9cGdx+3GHdfTJu9rvR1Mg9n2kMs/wnmxnPPtdYp4Ie9RcYn8i6AZ97LZ
JpjtPTk2QqXZvonP8q3Dn9PfLfk60+9Udxt/NW4sbyf7K7a/Z+1vM0+d/Z3E
96Q9QnuMdpGaO/V4Vi+lel7p7O8OybuL77AXrgH3F+4RedqoO8YMO+Fh8Th8
mnq95JojZ3+97OO9zrvYXKvEB/RcAAcz7Aqm6Ht6dlI79tBD/jfgslwNuB9x
/cSL4Y84B28uX0c46WwVzQzcMTOd0kNLdVbLtwL/k/P+fLVwJc6hp6/18roe
F0CntGR/v3k+m5p4Y44m3gxnP6Qlv4nx4vvsr8D+Kpyv5llgf3PlK3PeljcT
njDfB+2S9/iis0b+7uafrPYNO8qLs6hfgMvhP22G52CZHazR80B8X5oqfZyB
QeLN8l2Qq296cgfEu6CLeffy9YJRvFf0NkS+OZ6H4brqb6g4H1+k5zF63oRb
ghsJNXSj6YpwFeLhUI0bhSvEjRCfULdU//vU3q+nWvFxc5wTT4PPXFAFet7C
8xH0VCNFrSz+Ve2TPcd9V8uRLv6Ot1k8G/bwFvJWm+MeO7sX0nxL57OT++of
u7oOvfG33RFluOX6G6fOfFxvcaOcR9T4Qr6FamSLB+l7Nt1TdF30MVg8AGbh
nsR1xg0U76W9xlvDu513iDjFrsrM8CHdTfpUcU68Y73X+fAQ3Q29hHgP0TXS
NdO1EBea42hGUiPW6q1GLW03uhvikWapkWs0HPV8BObiy+ke4D3ANwAm48pw
Gzy/C935b9lLir6L4jeekcwWZ+xDVy7fJb1dhCp7aVCzMc6Xmdyd8Q4t0l8/
z7vjnQtZ8t3tfBd9qbheri6tknsoLb53ub5NTe6ZeN9sjbsXH7KrwVnJf0qx
nCVyT5R3h1wr+HY7O5ya3Mcz5avDb8Dvz0x0Uf8g33Rz7MGdwF3F1WYn31H8
nm7q57+U5PexJDeZ6TZckHcjTZXaFc4r+ebF+8a83+OyvZv1+qvzeirorsLn
9pTPWxK/mziHfHXi5X5XS+mmqrGF9yJuF28TLivOFu/UjOR3FH9PfXOS/4A3
9bA0Nfnm4re3ze8hXd376YrpxqhxCabrrUpv5TBHrv8BgAsKLQ==
            "]], 
           
           Polygon3DBox[{{5397, 2066, 2065, 3885, 2727, 4404}, {5109, 3624, 
            4032, 1990, 1367, 5199}, {4861, 3267, 3927, 1827, 1835, 5421}, {
            5122, 3637, 3231, 3232, 3638, 5123}, {5423, 2257, 2256, 3466, 
            3467, 5725}, {4307, 2606, 3890, 2169, 2168, 5395}, {5475, 1672, 
            93, 2559, 2740, 5623}, {5399, 3893, 2810, 416, 1777, 5477}, {5129,
             3643, 3243, 3244, 3644, 5130}, {5124, 1007, 1867, 4110, 3640, 
            5125}}]}]}, {
         EdgeForm[], 
         Directive[
          GrayLevel[1], Lighting -> {{"Ambient", 
             GrayLevel[0.8]}}], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxFmQe0lcW1xw+3nnbvPf2gFGkqogIXiAKCiIAiTQEjKBAQfGqCgnmRjk8R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            "]], 
           Polygon3DBox[CompressedData["
1:eJw1mnmYldWRxr/uS9++ffe+K5F9ERUQaSBGEBRUUJtFASOrESEjmYCgiew4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            "]], 
           Polygon3DBox[CompressedData["
1:eJwl1VlsVlUUBeBTplJKS+caBWkRDZYAFoi0hFKGlqmIDEYq1YDIAyoURKEt
qBEkEcQxKAqoyANoECEqRMKDBCMGjQEVgSJKxFLEaiRGBg1I/I73YeW/e521
1977nHPvXzx7wdT6diGEOdARQm4I09uHsLtzCJe6hZB+XQgZeSHkW6zKDOGp
jBDqCkJYlhVCf4mL0kO4GTJx5XCtawgvwgT6EfI2dQmhOiWE451C+BwqefbO
DmEY7hVrk6CZV9/sRBf10+Akrozfv7xegPH8hvPLhALP1XpZrpd7aXrT9tL6
ZHlT4Gx+CEUwWq1p0C41hG3iIbRXeT0P43gM41VeGMKbfGrM/JmZF9Hl8OvA
bzSvKjiN6571/9aE8eIJcAa3DncqLYRRXRJ9zPuRqE2Qo795fGeomYc3ehhL
Nw5a5OZmJftdLR4DP+M20i+Ru8HvbXoshfX2paf9vQCn7PfQnBDet76cbrvf
4TSV8D1dkfUH6P7hN0/cQw0jhhrxRGhVY7/9yNRzqvz2GlgsvsLnUPSzB6Ps
VYq8rfJLeP0NrXxHqLsKP9BzA64fZJttLc/DPObzLFWrhGY1DKJrpOkPOXSD
4ZI+V0KVuuUaGxP3QV4H+iYeq2ie1MtO57ADhujnCfHXdC10s6CnGtfTV+Ql
ZxjPMt9en7bvrTnJXAVy+uPq+Q3AF8W8tORc4vnEeTebsxqyHcxvtLN4NvD+
1T61QZrctwqTvnLkZkOR3M10rZ7vSEvuQ7wXZR7O6nW9XpbybhCv9FuB+8Ic
B+EhPnnm2KLewk7J/Y/vQdzXuL9v4FL08w7uL7Pl0W/hd5HHBfGJeA/oJvFa
bW2X/ibj6+zBVrp+Zrii7hQ1PuWzH07KfQQ3Mi95H+N7WUjXiiuBg9ZX4Obo
9eGo49nd815ctr06r7dX45026w048pAtrsHnip/Bz8BNFH8V74K+KvR3D65O
v315Xqb7Xc1c8x2Lc9GVuhNLYbB5nuWXgeshng+34ubjUuTWKlgR34F438XF
cL5rcl7x3I5EP9w5XJCzKZ6p+bP49eH1GAzg97i1n/AVzvWonpvJ18T3Od4P
mqb05L7Ge3s33S7e22g+pB1ppuFQ73kg7oC1Wppp5is3axnU4O8SP4jfZP1L
8XcpyVk24HbIX6fHFvN8Y69ewh2lG4MfCjfmJ3ejTZ6WwgJr94m7CW7R26Pp
ybc2fnMbzbssI7lr8c41iStpV5h9bmqyFy+7t5V5yTczfjsL7FcL3Qh+Jebo
AzvxM+kO439w1h1pZvOtjecDf1hvgr3xv0DPY9V4j/92aIv3GjeI7iLN0zBa
rTI13zbzbjPsUeMmfW8WX1On3JyfmGtfp2Te+H3+Np4hVFkL/mc+kPOux8u4
j6DIeV1WZ1+8tzTD1K0T16gzVb2N+F76/jM36T/OUcijAO43y1q1D6Qk/Wzk
N1fNznr+he+5Lsn7Xhu/afKP836O30J5C8XlkO75dVyrtSPqluKOeV6Dq7e2
INbl18zrBCzhN53fIdgS74S7MRUa9TFBz1P0vEFusV7Py70dzvB7DbeE32Lx
kNykXqzbGP8PxB+bPd9Me/B3dkhmK1ZjkZm2wmDrV+3xzKykh9b4HwipevsP
wQD3/Q==
            "]], 
           
           Polygon3DBox[{{4824, 1869, 1905, 3956, 3619, 5739}, {5499, 2227, 
            1310, 3658, 3479, 5730}, {5765, 3947, 4027, 2242, 1314, 5144}, {
            5694, 3347, 3247, 2344, 2343, 4832}, {5669, 3269, 3135, 3134, 
            3484, 4994}, {4501, 1790, 1683, 2480, 2843, 4502}, {5636, 2774, 
            2904, 519, 2111, 5476}, {5478, 2124, 133, 2806, 2807, 5643}, {
            5587, 2538, 2412, 1652, 1650, 4129}, {5667, 3262, 3121, 3120, 
            3458, 4987}}]}]}, {}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[{755, 1, 696, 303, 4112, 16, 4122, 31, 2036, 5769, 3974, 
          1702, 1650, 1652, 4048, 1658, 1706, 4047, 5523, 1659, 4046, 1732, 
          5464, 1733, 1660, 4045, 1734, 1751, 1735, 1661, 1736, 1752, 3975, 
          5460, 1753, 1703, 1731, 1648, 1701, 5469, 1647, 4043, 1729, 1749, 
          5520, 1727, 1726, 1644, 2386, 7, 2385, 6, 2384, 5, 2382, 4, 2380, 3,
           3108, 817, 2, 2869, 482, 755}], 
         Line3DBox[CompressedData["
1:eJwl1NtPz3EYwPGP5byR2SQ5lvMpx0t/BXPOKYcSlcPiznFjQskhJaXSWhau
zGHYzB1zWJsZnRQi5MwNN16fuXj3fp7n83w+3+f7/X2/pWbmL8zrFUIY5E9u
3xD6i1v6hdCKNiwaFkI7v0JpYggdXKLWya/xBm/RhVNJITzS8078Ht34gI/4
hHJrPfwZJ53xhcvUvvJRe4vF38TfUST+wT/xG03y0/bsNGPakBDSzdlbPtzA
yRiBl3pSOFN9JI/CaDSrj+EK9bE8DqnYKk/j8ZiAiZiEyZiCSutTeRqmYwaq
1GZyizPTeRZm44L6HG5Vn8vzMB8nzZtt3nrzDtWzWK2el/BSdOpfxsuxAoXy
lZyBVViNi2pr+LhnVCdeK25wxrp4r1iPDeiytpE3IQvZ2IxL6tv054i3xPtG
LvKQH9etbePz+rbzDuTEZ80FqHUPzeYvFt8VP0OG9Rq+g0r7qvmqWhMHv9dT
foI/KDX3Zz1nxNdxGo/wFzdwztowex6LrzjjJleolXKhvcfEt8RncVxcFq+J
2+iWN9pTJd7tOV9z+SHyRWYtUfuFDj0nOEv9Jye61uD4Tsf3TV6nXsRfcQy5
8kHxPRX3YGB8h/kDBohrrRfGWeP3Ij/CNWrd3O7Mw3wZfaxVqx8St8Xvgg+i
EQcwy7wLzJugJ8m85XxJvRUv9CfY3yDehRJ5J++P94NXqFLbx0WeUb34YXxG
znjAezHS/vb4e1kbEb9n8R6kiAu4QT1ff7K8RT6cmzmJn8ffzdr2eKa++5yH
NWp1fK/v//8X/wCpsp1W
          "]], 
         Line3DBox[{2388, 9, 3883, 2038, 2039, 2040, 5525, 2041, 2042, 4050, 
          2043, 5472, 2044, 2045, 2046, 2047, 2048, 2049, 5780, 4051, 2050, 
          2051, 2052, 2053, 2054, 3984, 2055, 2056, 2057, 2058, 5465, 2059, 
          4053, 5528, 2060, 4054, 2061, 2062, 2063, 2064, 4055, 2065, 2066, 
          2067, 4005, 2068, 2069, 5473, 1655, 45, 4128, 30, 4386, 314, 757, 
          15, 697, 313, 756, 2398, 14, 2396, 13, 2394, 12, 2392, 11, 2390, 10,
           2388}], 
         Line3DBox[{1657, 61, 4144, 76, 4158, 91, 4681, 785, 382, 758, 106, 
          790, 399, 4186, 121, 4193, 136, 4196, 151, 2101, 1782, 1679, 1713, 
          4002, 1808, 5486, 1809, 1781, 1677, 3976, 1712, 5477, 1777, 1778, 
          1774, 1803, 5461, 1804, 1711, 1771, 1675, 1710, 1767, 1799, 5532, 
          1798, 1765, 1672, 5475, 1764, 3986, 1669, 1796, 1763, 5530, 1668, 
          3999, 1762, 1656, 1657}], 
         Line3DBox[{4156, 75, 2102, 2103, 2104, 2105, 4000, 2106, 5483, 2107, 
          2108, 2109, 3987, 2110, 5476, 2111, 2112, 2113, 2114, 5466, 2115, 
          2116, 2117, 2118, 2119, 2120, 2121, 5539, 2122, 2123, 2124, 5478, 
          2125, 3977, 2126, 2127, 2128, 5541, 2129, 4001, 2130, 2132, 1689, 
          165, 4199, 150, 4195, 135, 4682, 794, 414, 765, 120, 801, 532, 4185,
           105, 4171, 90, 4156}], 
         Line3DBox[{1691, 181, 4217, 196, 4526, 476, 768, 211, 743, 475, 767, 
          2512, 212, 2513, 213, 2514, 214, 2515, 215, 2516, 216, 2517, 217, 
          3891, 2164, 1747, 1746, 5546, 1794, 1744, 4071, 1695, 5481, 1793, 
          1692, 1722, 1823, 1791, 1822, 5781, 4070, 1821, 1825, 1812, 1717, 
          1820, 3979, 1785, 1824, 1811, 1716, 5462, 1739, 4068, 5543, 1784, 
          4067, 1715, 1783, 1810, 1714, 4066, 1683, 1790, 1690, 4007, 1789, 
          1788, 5480, 1691}], 
         Line3DBox[{4230, 195, 2166, 5772, 3989, 2167, 2168, 2169, 4073, 2170,
           2171, 4074, 5548, 2172, 4075, 2173, 5463, 2174, 2175, 4076, 2176, 
          2177, 2178, 2179, 2180, 2181, 3988, 5467, 2182, 2183, 2184, 2185, 
          2186, 5470, 2187, 4078, 2188, 2189, 5551, 2190, 2192, 1699, 2518, 
          219, 2519, 220, 2520, 221, 2521, 222, 2522, 223, 2523, 224, 2868, 
          481, 769, 225, 754, 565, 4244, 210, 4230}]}, {
         GrayLevel[0], 
         Line3DBox[{1583, 819, 1519, 1121, 4696, 834, 4703, 849, 4711, 864, 
          4722, 879, 4733, 894, 4747, 909, 5426, 2220, 1916, 1917, 4084, 1853,
           1918, 5556, 1849, 4022, 1893, 1949, 1914, 1894, 1950, 4082, 5555, 
          1850, 1915, 1847, 1913, 1946, 1912, 5554, 1997, 1998, 4081, 1890, 
          5492, 1910, 1842, 4015, 5500, 1886, 1836, 5552, 1835, 1827, 1882, 
          5783, 4079, 1826, 821, 3882, 1640, 820, 3651, 1300, 1583}], 
         Line3DBox[CompressedData["
1:eJwl1NlvjUEYB+ChpbVURcK9BLUrrSql9pbEFSIEsSbWFBERLmyxRdXWaova
9+KiaqulpSERS6z/haBU7cUzcfH0N/POO3PmfOdLu85fMbmgRQihgz9p7UPI
SghhWmoI+5NDqJSrOodwwLiYEtabH5SllHcJoUFPWRxTZe2QvK52WB5hs1qF
PMoxjnOCk+y1/7LeU8anOcNZztGofl5usf+CvMgVtUp5idwk57prhvX35h/4
SK2eBvmJ+9Y+yzq1RvmFJr7yje+07BjCA30/jH/yi980U6/+R/4ltAmhBS1J
IJFWFOppLZNIpg0b1NrKdrTnkXmKTI17fd5Ud6/2rJMTQ1jkbn3U+9KP/jzV
P0A+tpYuBzKIZ+oZsq0zMuVgshhCtd5sOZRh5MTP1jdcjiCXFPORchSjqbdn
jHzu3LFyHOPjPfXlySL1fDmB6e5c484d3Xmxfb3UrslNetZYm8Jk1plPkis5
5PdNctZE4x3qBXIXE9huvlxWspM8lnGOffZdjb+/8bbYS348g1bOGxvr9i+R
J6jSu1UuZVx8tp2c6914F98/803c0zNSbqTO3uHyrlqFfMMi3nKEVzRbq9WX
Y/yabBbyIp4V33P5kiwWsEZtrRwcv6PxPFnCQGazWi09fjdux2dpvlfu4bfP
6h33er657j3D/Im7F6mlMZNb+nvKh9Zq5G76c1N9lvypPiDejWIyuaRWLudS
xnfzOjmHUmr5ppYhD9Iv3s38gLzh3DvxGbGfJvUe8bdSL5Td6Zb0/3/GP1oC
kbE=
          "]], 
         Line3DBox[{3113, 823, 2221, 2222, 2223, 5557, 2224, 4025, 2225, 2226,
           2227, 5499, 2228, 4086, 2229, 2230, 2231, 4037, 2232, 2233, 2234, 
          2235, 4016, 2236, 2237, 2238, 4089, 2239, 2240, 2241, 2242, 4027, 
          2243, 5490, 2244, 2245, 2246, 4091, 2247, 5513, 2248, 2249, 2251, 
          1833, 829, 3123, 828, 3872, 1631, 827, 3459, 1127, 1585, 3119, 826, 
          1603, 1125, 1584, 3117, 825, 3115, 824, 3113}], 
         Line3DBox[{3126, 831, 2252, 4024, 2253, 2254, 5518, 2255, 2256, 2257,
           5562, 2258, 2259, 2260, 2261, 5563, 2262, 2263, 5564, 2264, 2265, 
          2266, 2267, 5494, 2268, 2269, 2270, 2271, 2272, 5777, 4041, 2273, 
          2274, 2275, 2276, 2277, 2278, 4094, 2279, 5507, 2280, 2281, 4095, 
          2282, 2284, 1856, 4771, 923, 4757, 908, 4745, 893, 4731, 878, 4720, 
          863, 4709, 848, 5355, 1604, 1137, 1586, 833, 1566, 1308, 3127, 832, 
          3126}], 
         Line3DBox[{4773, 939, 4789, 954, 4792, 969, 4796, 984, 4807, 999, 
          4822, 1014, 5357, 1612, 1291, 1595, 1029, 1563, 1290, 3249, 1030, 
          3250, 1031, 2318, 4033, 1907, 1972, 5519, 1870, 1905, 1869, 5572, 
          1965, 1987, 1964, 1963, 5571, 1985, 1986, 1901, 1929, 1961, 1960, 
          2010, 1957, 5501, 2009, 1956, 1984, 2007, 2005, 5778, 4042, 2006, 
          1955, 2008, 1954, 1861, 1953, 4097, 1858, 5508, 1923, 1951, 4096, 
          1896, 1922, 1857, 4773}], 
         Line3DBox[{4790, 953, 5428, 2320, 2321, 2322, 4100, 2323, 2324, 5574,
           2325, 4023, 2326, 2327, 2328, 2329, 2330, 4102, 5575, 2331, 2332, 
          2333, 2334, 2335, 2336, 5576, 2337, 2338, 2339, 5577, 2340, 4014, 
          5495, 2341, 2342, 5578, 2343, 2344, 2346, 5786, 4104, 1881, 1041, 
          3258, 1042, 3650, 1299, 1598, 1043, 1582, 1383, 4849, 1028, 4835, 
          1013, 4820, 998, 4805, 983, 4794, 968, 4790}], 
         Line3DBox[{1878, 1033, 3252, 1034, 3253, 1035, 3645, 1294, 1596, 
          1036, 3857, 1613, 1296, 1597, 3254, 1037, 3255, 1038, 3256, 1039, 
          2377, 1879, 1976, 5582, 1873, 4035, 1975, 1996, 1872, 5496, 1974, 
          4110, 1867, 1971, 1992, 4039, 1993, 1970, 1969, 4038, 1866, 1967, 
          1966, 1989, 4107, 1988, 1903, 1991, 1990, 4032, 1968, 5503, 1871, 
          1906, 1995, 4105, 1994, 5516, 1973, 1877, 1908, 1878}]}, {
         GrayLevel[0.2], 
         Line3DBox[{5524, 4130}], 
         Line3DBox[{4143, 4418, 4417, 5884, 4142, 4416, 4415, 5883, 5387, 
          4414, 4413, 5882, 5386, 5774}], 
         Line3DBox[{4200, 4485, 5598, 5901, 4573, 4486, 5760, 5902, 4574, 
          4487, 5401, 5903, 4488, 5773}], 
         Line3DBox[{5547, 4215}], 
         Line3DBox[{4787, 4969, 6045, 5718, 4786, 4968, 6043, 5716, 4785, 
          4967, 6041, 5714, 4784, 5713, 6121, 5300, 5306, 5305, 4783, 5265, 
          6071, 5755, 5045, 5264, 5263, 4782, 5754, 6070, 5260, 5044, 5259, 
          5258, 4781, 5712, 6039, 3407, 4779, 4964, 6038, 5711, 4778, 5302, 
          5303, 5043, 5752, 6115, 5256, 4777, 5253, 5254, 5042, 5750, 6114, 
          5252, 4776, 5301, 6118, 5756, 5288, 4963, 4775, 5710, 6035, 4961, 
          4774, 5709, 6034, 4960, 4772, 5708, 6032, 4959, 5427}], 
         Line3DBox[{5529, 5379}], 
         Line3DBox[{5380, 5591, 5824, 4137, 5592, 5825, 5381, 5593, 5826, 
          5771}], 
         Line3DBox[{5392, 4306, 5819, 4203, 4305, 5818, 4202, 5405, 5817, 
          5770}], 
         Line3DBox[{5542, 5394}], 
         Line3DBox[{5459, 4382, 4250, 4118, 4311, 4383, 5471}], 
         Line3DBox[{5468, 4521, 4374, 4237, 4373, 4520, 5482}], 
         Line3DBox[{5474, 4423, 4424, 5887, 4145, 4426, 5827, 5624, 4146, 
          5626, 5828, 4428, 4147, 2654, 4329, 4148, 5867, 4330, 4406, 4331, 
          4149, 5928, 4595, 4332, 4407, 4333, 4596, 4150, 4597, 4334, 4410, 
          4335, 4598, 5888, 4151, 4336, 4634, 4337, 5938, 5663, 4152, 4338, 
          4636, 2657, 4674, 4153, 4339, 5829, 5607, 4154, 5629, 5830, 4432, 
          4155, 5889, 4433, 4434, 5536}], 
         Line3DBox[{5479, 4301, 4471, 5896, 4197, 4300, 5816, 5644, 4587, 
          4299, 5815, 4470, 4586, 2589, 4351, 4585, 5868, 5597, 4484, 4350, 
          4482, 5926, 4594, 4593, 4483, 4349, 4618, 4480, 4592, 4591, 4481, 
          4348, 4617, 5900, 4479, 4298, 4644, 4347, 5939, 5664, 4478, 4297, 
          4643, 2673, 4677, 4477, 4296, 5814, 5612, 4476, 4295, 5813, 4475, 
          4572, 5899, 5596, 4474, 5535}], 
         Line3DBox[{5484, 4552, 6141, 5762, 4174, 5632, 5912, 4553, 4439, 
          4175, 5633, 5913, 4554, 4655, 4654, 4176, 5660, 5914, 4656, 4555, 
          4624, 4623, 4177, 2662, 4440, 4343, 4178, 4344, 4631, 4639, 3035, 
          4179, 4345, 4577, 4609, 5930, 5654, 4180, 4657, 4658, 4556, 5661, 
          5935, 4659, 4181, 4442, 4557, 5839, 5635, 4182, 5763, 5915, 4558, 
          5538}], 
         Line3DBox[{5485, 4564, 6138, 5764, 4190, 4281, 5920, 4563, 4449, 
          4580, 4280, 5919, 4562, 4664, 4663, 4458, 4279, 5892, 4662, 4459, 
          4626, 4625, 4579, 2574, 4457, 4346, 4189, 4278, 4640, 4675, 3072, 
          4456, 4277, 4578, 4610, 5931, 5655, 4454, 4276, 4661, 4455, 5662, 
          5936, 4660, 4452, 4275, 4453, 5804, 5638, 4188, 4274, 5918, 4561, 
          5533}], 
         Line3DBox[{5487, 4649, 5411, 4679, 4648, 5863, 5588, 4400, 4318, 
          4136, 4269, 4398, 4317, 5862, 4135, 4268, 4396, 5779}], 
         Line3DBox[{5488, 4668, 5414, 4671, 4208, 5872, 4357, 4493, 4358, 
          4209, 4359, 4495, 4360, 5873, 4210, 5407, 4497, 5782}], 
         Line3DBox[{5489, 4698, 5986, 4851, 5419, 5441, 5512}], 
         Line3DBox[{5491, 5430, 6058, 5146, 4991, 4706, 4866, 6056, 5145, 
          4989, 5422, 5559}], 
         Line3DBox[{5493, 5431, 5159, 4929, 4727, 5954, 5680, 5018, 4928, 
          4726, 5953, 5679, 5016, 4927, 5013, 6061, 5678, 5158, 5012, 3828, 
          5157, 5343, 5342, 5212, 5011, 5999, 5156, 4879, 5210, 5010, 5998, 
          5275, 5155, 4878, 5208, 5009, 5997, 4725, 5553}], 
         Line3DBox[{5497, 5978, 5693, 4831, 5744, 6084, 5126, 4830, 5581}], 
         Line3DBox[{5498, 5989, 4862, 4705, 5729, 6059, 4863, 5455, 5558}], 
         Line3DBox[{5502, 5107, 5197, 6100, 5740, 4825, 5741, 6082, 5198, 
          5108, 4826, 5580}], 
         Line3DBox[{5504, 4846, 5982, 5695, 4845, 5454, 5517}], 
         Line3DBox[{5505, 5207, 6108, 5698, 4736, 3367, 5209, 4936, 5233, 
          4737, 6093, 5026, 5211, 5027, 5276, 4738, 6094, 5028, 5213, 5029, 
          5277, 5350, 6063, 5282, 5014, 5358, 5015, 5344, 6129, 4739, 4937, 
          5017, 4938, 5958, 4740, 4939, 5019, 4940, 5959, 5292, 4741, 5020, 
          5160, 6124, 5733, 5565}], 
         Line3DBox[{5506, 6027, 5703, 4759, 4954, 6028, 5704, 4760, 5294, 
          5295, 5287, 6117, 5705, 4761, 5237, 5238, 6029, 5037, 5240, 5239, 
          4762, 5241, 6112, 5747, 5216, 5243, 5242, 4763, 3387, 5217, 4955, 
          4764, 6005, 4956, 5038, 5297, 5296, 6120, 4765, 5298, 5299, 5039, 
          5244, 6068, 5748, 4766, 5245, 5246, 5040, 5749, 6069, 5247, 4767, 
          4957, 5041, 6113, 5249, 5248, 4768, 5706, 6030, 5322, 4958, 4769, 
          5707, 6152, 5567}], 
         Line3DBox[{5509, 6044, 5717, 5058, 4894, 6042, 5715, 5057, 4893, 
          5354, 6040, 5291, 4966, 5055, 4892, 6110, 5746, 5056, 5267, 5266, 
          5054, 4891, 6109, 5232, 5219, 5262, 5261, 5053, 3308, 5218, 4965, 
          6006, 4780, 4890, 5052, 5304, 6075, 5757, 5289, 4889, 5290, 5051, 
          5753, 6074, 5257, 5049, 4888, 5231, 5050, 5751, 6073, 5255, 5048, 
          4887, 6037, 5170, 5251, 5250, 5047, 4886, 6036, 5330, 4962, 5046, 
          4885, 6153, 5568}], 
         Line3DBox[{5510, 6051, 5226, 4974, 4793, 3323, 5225, 4973, 5274, 
          5084, 6081, 5686, 5224, 5083, 5279, 5179, 6095, 5685, 5223, 5067, 
          5278, 6128, 5081, 5339, 5338, 5360, 5065, 5349, 6131, 5079, 4910, 
          5080, 4972, 6008, 5312, 4909, 5078, 6123, 5721, 5314, 5313, 4908, 
          6079, 5077, 5062, 5570}], 
         Line3DBox[{2307, 4799, 6011, 4978, 5187, 4915, 4800, 6012, 4979, 
          5189, 4916, 5096, 6013, 5082, 4917, 5191, 6014, 5099, 5690, 6097, 
          5192, 5280, 5100, 5227, 5691, 6098, 5193, 5281, 5101, 5229, 5692, 
          5967, 4801, 4980, 5511}], 
         Line3DBox[{5514, 6060, 5005, 4998, 4716, 5949, 5674, 5004, 4997, 
          4715, 5948, 5673, 5003, 4996, 5002, 6156, 5672, 5444, 6151, 5456, 
          4873, 5443, 5994, 5151, 4872, 5206, 5001, 5993, 5150, 4871, 5205, 
          6107, 5732, 4714, 4870, 6150, 5784}], 
         Line3DBox[{5515, 5186, 6096, 5738, 4810, 6018, 5094, 5188, 5095, 
          4811, 6019, 5097, 5190, 5098, 4812, 6158, 5448, 5449, 4813, 6159, 
          5450, 5451, 5971, 4814, 5111, 5228, 5112, 5972, 4815, 5113, 5230, 
          5114, 5973, 4816, 5766, 6149, 5785}], 
         Line3DBox[{5521, 5377, 5858, 4313, 4389, 4260, 4127, 4314, 4390, 
          5585, 5859, 5378, 5526}], 
         Line3DBox[{5522, 4319, 5382, 5864, 4320, 5410, 4321, 5383, 5865, 
          4322, 4397, 4323, 4139, 5658, 5866, 4324, 4399, 4325, 4140, 4326, 
          4401, 4327, 5927, 5653, 4141, 4408, 4650, 4409, 5934, 5659, 5384, 
          4411, 5415, 4412, 6146, 5416, 5385, 4328, 5527}], 
         Line3DBox[{5531, 4159, 4427, 4547, 5832, 5625, 4160, 5627, 5910, 
          4548, 4620, 4619, 4161, 5628, 5911, 4549, 4622, 4621, 4162, 2659, 
          4429, 4600, 4599, 4163, 5929, 4601, 4602, 4430, 4604, 4603, 4164, 
          4605, 4606, 4431, 4608, 4607, 5891, 4165, 4340, 4635, 4638, 3033, 
          4166, 4341, 4637, 5833, 5608, 4167, 4342, 5834, 5609, 4168, 5634, 
          5835, 4441, 4169, 5537}], 
         Line3DBox[{2085, 2449, 109, 2907, 525, 759, 110, 745, 2908, 526, 760,
           111, 3054, 715, 388, 761, 112, 2450, 113, 2451, 114, 799, 527, 762,
           2452, 115, 750, 528, 3022, 659, 116, 800, 529, 2453, 117, 3924, 
          1802}], 
         Line3DBox[{5534, 5412, 4451, 5808, 4285, 4461, 5610, 5809, 4286, 
          4462, 5611, 5810, 4642, 4287, 4463, 3074, 4676, 4641, 4288, 4464, 
          5894, 4611, 4612, 4466, 4589, 4289, 4465, 4613, 4614, 4467, 4590, 
          5595, 5925, 4581, 4615, 4616, 4468, 2581, 4582, 4627, 4628, 4469, 
          5895, 4290, 4583, 4629, 4630, 4567, 5921, 4291, 4584, 5642, 5811, 
          4568, 4292, 5390, 5540}], 
         Line3DBox[{5544, 5402, 4575, 5418, 6147, 4489, 5417, 5403, 4576, 
          5665, 5940, 4490, 4667, 4303, 4491, 5656, 5932, 4352, 4492, 4304, 
          4645, 4353, 4494, 4633, 5869, 5657, 4632, 4354, 4496, 5761, 5870, 
          4201, 4355, 5413, 5404, 5871, 4588, 4356, 5549}], 
         Line3DBox[{5545, 4222, 5876, 4365, 4508, 4366, 4223, 4367, 4509, 
          4368, 5877, 4224, 5550}], 
         Line3DBox[{5560, 4856, 5420, 4990, 5137, 6057, 4857, 4700, 5442, 
          5561}], 
         Line3DBox[{5566, 5425, 5320, 5735, 6126, 5167, 5034, 4754, 5293, 
          5702, 6119, 5033, 4953, 4753, 3779, 4952, 5032, 4951, 5319, 4752, 
          6111, 5236, 4950, 5318, 4949, 5325, 5284, 6067, 5351, 5283, 5324, 
          5031, 5345, 5030, 5356, 5323, 6066, 4751, 5235, 4948, 5215, 3377, 
          4750, 5234, 4947, 5214, 6026, 5701, 4749, 5700, 6025, 4946, 5424, 
          5775}], 
         Line3DBox[{5569, 5326, 5327, 5328, 5173, 6072, 4899, 5308, 5309, 
          5310, 6122, 5063, 4900, 5307, 5311, 3792, 5064, 5285, 5352, 4901, 
          5220, 6116, 5268, 5269, 5174, 5286, 5353, 4902, 5359, 6130, 5346, 
          5348, 5347, 5175, 5337, 5682, 6080, 5066, 5270, 5271, 5221, 3315, 
          5068, 5272, 5273, 5222, 6047, 4903, 5069, 4970, 6048, 5432, 5070, 
          5776}], 
         Line3DBox[{5573, 5452, 4838, 5118, 5203, 6103, 5743, 4839, 5453, 
          5579}]}, {
         GrayLevel[0.2], 
         Line3DBox[{8, 4118, 23, 4127, 38, 4136, 53, 4140, 670, 68, 4150, 355,
           83, 4164, 370, 98, 4178, 113, 4189, 128, 421, 4465, 143, 437, 4480,
           158, 692, 4645, 173, 4209, 188, 4223, 203, 4237, 218}], 
         Line3DBox[{3111, 3261, 5986, 3112, 3268, 5989, 3131, 3274, 6150, 
          4080}], 
         Line3DBox[{4092, 3125}], 
         Line3DBox[{4099, 3251}], 
         Line3DBox[{3257, 3354, 5982, 3246, 3346, 5978, 3940, 3955, 6149, 
          4103}], 
         Line3DBox[{4010, 3926}], 
         Line3DBox[{3929, 3462, 3264, 6057, 3124, 3463, 3948, 6058, 3931, 
          3488, 3949, 6060, 3933, 1911, 5493, 1891, 3934, 3973, 6124, 3518, 
          3972, 3951, 3935, 3807, 6126, 3533, 3805, 3296, 3168, 3734, 6113, 
          3392, 3558, 3303, 3179, 6121, 3411, 3575, 3851, 6040, 3852, 3190, 
          3423, 3587, 3953, 6048, 3938, 3434, 3967, 3954, 6051, 3939, 1930}], 
         
         Line3DBox[{3943, 3958, 3632, 6103, 3240, 3342, 3620, 6100, 3229, 
          3334, 3608, 6096, 3216, 2307, 2306, 3206, 6079, 3320, 3794, 3581, 
          3822, 3196, 6072, 3313, 3789, 3567, 3814, 3186, 6037, 3307, 3565, 
          3401, 3785, 6118, 3173, 3850, 3849, 3550, 3382, 6117, 3164, 3848, 
          3847, 3540, 3374, 6025, 3156, 3287, 3366, 6108, 3149, 4021}], 
         Line3DBox[{4020, 3944}], 
         Line3DBox[{3978, 3894, 5902, 2919, 2834, 2470, 2585, 5899, 2917, 
          2824, 2462, 4059}], 
         Line3DBox[{3980, 5817, 3896, 2477, 5816, 2819, 2962, 2818, 2914, 
          5811, 2805, 2958, 2804, 2911, 6138, 3920, 3919, 3924, 3917, 3916, 
          5915, 2905, 2772, 2903, 2771, 5835, 2438, 2756, 2896, 2755, 5830, 
          2429, 2733, 2890, 5882, 3998}], 
         Line3DBox[{3981, 5818, 2596, 2478, 2821, 5896, 2820, 3925, 4063}], 
         Line3DBox[{3982, 5825, 2545, 2421, 2739, 5887, 2552, 2432, 4058}], 
         Line3DBox[{3983, 5826, 2546, 2422, 5827, 2741, 2940, 2553, 2433, 
          5832, 2742, 2944, 2560, 2442, 6141, 3915, 2567, 2449, 3918, 2573, 
          5918, 2456, 2796, 2811, 2579, 5808, 2463, 2825, 2826, 2586, 5813, 
          2471, 2835, 2836, 5903, 4003}], 
         Line3DBox[{3985, 2734, 5883, 2891, 2735, 2430, 2757, 5889, 2897, 
          2758, 3887, 4062}], 
         Line3DBox[{3990, 5858, 2639, 2709, 2646, 5862, 2647, 2721, 3031, 
          3032, 5866, 3028, 2653, 2730, 2972, 5928, 2973, 2749, 2975, 2974, 
          2751, 2980, 5929, 2981, 2948, 2983, 2982, 2766, 2662, 2950, 2663, 
          2450, 2664, 2800, 3073, 3072, 3037, 3039, 3040, 2815, 2991, 5894, 
          2990, 2816, 2996, 2997, 2830, 2999, 5900, 2998, 2831, 2677, 2841, 
          5932, 3006, 3005, 2842, 2682, 5872, 3063, 2683, 2850, 2688, 5876, 
          3996}], 
         Line3DBox[{3991, 5859, 2534, 2404, 2648, 3044, 5863, 2540, 2415, 
          2967, 2968, 5927, 2887, 2547, 2425, 2976, 5888, 2977, 2752, 2964, 
          2554, 2434, 2984, 5891, 2985, 2767, 3068, 2561, 2443, 3035, 3036, 
          2785, 2568, 2451, 2665, 2952, 2574, 2457, 2992, 2993, 2954, 2965, 
          5925, 2580, 2465, 3000, 3001, 2832, 2966, 5926, 2587, 2473, 2678, 
          3029, 5869, 3030, 2593, 2483, 2684, 5873, 2601, 2492, 2689, 5877, 
          3997}], 
         Line3DBox[{3992, 2649, 2423, 5828, 2743, 2941, 2744, 3007, 2893, 
          5910, 2745, 2945, 2746, 3008, 2899, 5912, 2762, 2763, 2907, 2780, 
          2781, 5804, 2797, 2666, 2812, 2667, 5809, 2464, 2670, 2827, 2671, 
          5814, 2472, 2676, 2837, 4004}], 
         Line3DBox[{3993, 5864, 2939, 2650, 2424, 2654, 2942, 2655, 2969, 
          2894, 5911, 2747, 2946, 2748, 3009, 2900, 5913, 2764, 2949, 2765, 
          3010, 2908, 3058, 2783, 3084, 2784, 3057, 5936, 2799, 2668, 2813, 
          2669, 5810, 3041, 2672, 2828, 2673, 3076, 3042, 2838, 2920, 6147, 
          2839, 4069}], 
         Line3DBox[{3994, 5871, 2963, 2680, 2475, 2589, 2960, 2675, 3004, 
          2467, 5895, 2582, 2956, 2802, 3012, 2459, 5919, 2576, 2953, 2787, 
          3011, 3022, 3021, 3020, 3056, 2770, 3055, 5935, 2445, 2563, 2769, 
          2660, 5833, 2436, 2556, 2754, 2657, 3071, 2427, 2549, 2732, 6146, 
          2731, 4052}], 
         Line3DBox[{3995, 2681, 2476, 5815, 2590, 2961, 2817, 3014, 2468, 
          5921, 2583, 2957, 2803, 3013, 2460, 5920, 2577, 2788, 2453, 2570, 
          2773, 5839, 2446, 2564, 2902, 2661, 5834, 2437, 2557, 2895, 2658, 
          5829, 2428, 2550, 2889, 4006}], 
         Line3DBox[{4011, 3502, 6156, 3275, 3143, 3516, 3517, 6061, 3281, 
          3150, 3829, 6129, 3830, 3532, 3804, 3288, 3157, 3725, 6111, 3726, 
          3714, 3293, 3165, 3783, 6120, 3784, 3782, 3301, 3176, 6039, 3408, 
          3572, 3308, 3187, 3750, 3751, 3584, 3823, 6080, 3314, 3197, 3838, 
          3839, 3686, 6095, 3321, 3207, 3614, 3690, 6097, 3327, 3219, 3970, 
          5971, 3695, 4109}], 
         Line3DBox[{4012, 3539, 3292, 3163, 6028, 3381, 3549, 3300, 3172, 
          6035, 3400, 3564, 3306, 6036, 3185, 3856, 3966, 3815, 4098}], 
         Line3DBox[{4013, 3547, 3298, 3170, 6032, 3398, 3562, 4030}], 
         Line3DBox[{4017, 3578, 3416, 6045, 3182, 3397, 3561, 4029}], 
         Line3DBox[{4018, 3588, 3962, 3191, 6042, 3413, 3576, 3412, 6041, 
          3180, 3394, 3559, 3393, 6030, 3809, 3854, 3965, 3806, 4093}], 
         Line3DBox[{4019, 3693, 6158, 3968, 3217, 3600, 6013, 3611, 3599, 
          3685, 3840, 6131, 3841, 3596, 3836, 3835, 3684, 3742, 6116, 3743, 
          3716, 3421, 3571, 6075, 3786, 3787, 3773, 3406, 6038, 3174, 3388, 
          3554, 3387, 3713, 3748, 3749, 3544, 3811, 6066, 3810, 3680, 3831, 
          3832, 3679, 6094, 3530, 3709, 3514, 5999, 3672, 3513, 3141, 3963, 
          5994, 3666, 4087}], 
         Line3DBox[{4026, 3930, 3497, 3665, 5993, 3498, 3706, 3511, 3671, 
          5998, 3512, 3746, 3708, 3528, 6093, 3678, 3529, 3747, 3711, 3377, 
          3542, 3378, 3724, 3712, 6112, 3729, 3385, 3552, 3386, 3730, 3555, 
          6115, 3737, 3404, 3568, 3405, 3738, 6074, 3570, 3419, 3788, 3420, 
          3792, 3583, 3431, 3793, 6008, 3432, 3597, 3443, 6012, 3444, 3688, 
          3612, 6019, 3613, 3971, 4106}], 
         Line3DBox[{4028, 3936, 6152, 3395, 3560, 3396, 3181, 6043, 3414, 
          3577, 3415, 6044, 3937, 4101}], 
         Line3DBox[{4031, 3184, 6153, 3305, 3563, 3399, 6034, 3171, 3299, 
          3548, 3380, 6027, 3162, 4083}], 
         Line3DBox[{4034, 3233, 3336, 3696, 5972, 3627, 3220, 3328, 6098, 
          3691, 3757, 3756, 3208, 3322, 6081, 3601, 3755, 3754, 3198, 3315, 
          3585, 3745, 3744, 3188, 6109, 3309, 3721, 3573, 3740, 3739, 6070, 
          3177, 3302, 3718, 3556, 3732, 3731, 6068, 3166, 3294, 3777, 3779, 
          3778, 3158, 3289, 3776, 5958, 3369, 3151, 3282, 5953, 3361, 3144, 
          3276, 5948, 3486, 3136, 4090}], 
         Line3DBox[{4036, 3461, 3270, 6056, 3137, 3487, 5949, 3277, 3145, 
          3362, 5954, 3283, 3152, 3775, 3370, 5959, 3774, 3290, 3159, 3781, 
          6119, 3379, 3780, 3295, 3167, 6069, 3733, 3391, 3557, 3719, 3720, 
          3178, 6071, 3741, 3410, 3574, 3722, 3723, 6110, 3189, 3422, 3586, 
          3316, 6047, 3199, 3433, 3323, 3209, 3616, 5967, 3329, 3221, 3628, 
          5973, 3337, 3234, 6084, 3641, 3345, 4111}], 
         Line3DBox[{4040, 3622, 3621, 6082, 3692, 3610, 6018, 3609, 3687, 
          3442, 6011, 3441, 3595, 3796, 6123, 3430, 3795, 3429, 3582, 3791, 
          6122, 3418, 3790, 3417, 3569, 6073, 3736, 3403, 3566, 3402, 3735, 
          6114, 3553, 3728, 3384, 3551, 3383, 6029, 3727, 3543, 3376, 3541, 
          3375, 6026, 3710, 3368, 3367, 3707, 3510, 5997, 3509, 3705, 6107, 
          3496, 3495, 3132, 6059, 3477, 3476, 4085}], 
         Line3DBox[{4044, 2720, 2651, 5865, 2652, 2729, 2656, 5867, 2943, 
          2971, 2970, 2750, 2659, 2947, 2979, 2978, 2901, 5914, 3052, 3053, 
          2782, 3051, 3082, 3050, 3054, 3023, 3065, 3024, 2798, 2989, 2988, 
          5931, 2951, 3025, 3067, 3026, 2814, 3075, 3074, 3038, 2674, 2829, 
          5939, 3078, 3077, 3043, 2840, 2921, 5940, 3087, 3086, 3061, 4009}], 
         
         Line3DBox[{4056, 3911, 2419, 2736, 5884, 2892, 2737, 3886, 3914, 
          4061}], 
         Line3DBox[{4057, 3913, 2420, 2544, 5824, 2411, 4049}], 
         Line3DBox[{4060, 2584, 2469, 2833, 2918, 5901, 2591, 2479, 3922, 
          4065}], 
         Line3DBox[{4064, 3921, 3888, 2597, 5819, 2487, 4072}], 
         Line3DBox[{4077, 3889, 3895, 5870, 2679, 2474, 2588, 5868, 2959, 
          3003, 3002, 2466, 2581, 2955, 2995, 2994, 2458, 5892, 2575, 3059, 
          2801, 3019, 3066, 3018, 2452, 2569, 3083, 3017, 2786, 2987, 2986, 
          5930, 2444, 2562, 3081, 3049, 2768, 3034, 3033, 2435, 2555, 2753, 
          5938, 3070, 3069, 2426, 2548, 2888, 5934, 3047, 3046, 3884, 4008}], 
         
         Line3DBox[{4088, 6151, 3964, 3142, 3515, 3673, 3828, 3858, 3827, 
          3674, 3762, 3842, 6063, 3763, 3531, 3802, 3853, 3801, 3803, 3764, 
          3843, 6067, 3765, 3545, 3813, 3855, 3812, 3546, 3389, 6005, 3390, 
          3175, 3407, 6006, 3409, 3715, 3766, 3844, 3767, 3683, 3834, 3859, 
          6130, 3833, 3837, 3768, 3845, 3769, 3598, 3753, 6128, 3824, 3752, 
          3717, 3770, 3846, 3771, 3689, 6014, 3615, 3218, 3969, 6159, 
          4108}]}, {}, {}, {}, {}, {}}}, VertexNormals -> CompressedData["
1:eJzsvXk019v+P65ZmSqNpKgkiURSpp0hSklIEg2kojQoSRlSQtGgJFRKKRKF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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
       FormBox[
        TagBox[
         TagBox["x", HoldForm], HoldForm], TraditionalForm], 
       FormBox[
        TagBox[
         TagBox["y", HoldForm], HoldForm], TraditionalForm], None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, 
     BoxRatios -> {1, 1, 0.4}, DisplayFunction :> Identity, FaceGridsStyle -> 
     Automatic, ImageSize -> Small, 
     Method -> {"DefaultBoundaryStyle" -> Directive[
         GrayLevel[0.3]], 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "RotationControl" -> "Globe"}, 
     PlotRange -> {{-2., 2.}, {-2., 2.}, {-2., 2.}}, PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], Automatic}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"\\!\\(\\*u(x,y)\\)\"", "\"\\!\\(\\*v(x,y)\\)\""}, 
      "SwatchLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]}, {
                    "Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]}, {
                    "Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #}, {
                   GraphicsBox[
                    InsetBox[
                    Graphics3DBox[
                    SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                    DirectedInfinity[1]}, 
                    PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, 
                    ImagePadding -> 0, {DefaultBaseStyle -> {"Graphics3D", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    Specularity[
                    GrayLevel[1], 3], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}]}, Lighting -> {{"Ambient", 
                    RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{0, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 2, 2}]}, {"Directional", 
                    RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`], 
                    ImageScaled[{2, 0, 2}]}}, ImageSize -> {12, 12}, BoxStyle -> 
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]}], Center, Center, 
                    ImageScaled[{1, 1}], 
                    BaseStyle -> {
                    Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
                    AspectRatio -> Full, ImageSize -> {12, 12}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.16666666666666669`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.3}}, "Rows" -> {{0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"SwatchLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.30100577, 0.22414668499999998`, 0.090484535]|>, 
                    "RGBColorSwatchTemplate"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.2642166, 0.18331229999999998`, 0.04261530000000001]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Specularity", "[", 
                    RowBox[{
                    
                    TemplateBox[<|"color" -> GrayLevel[1]|>, 
                    "GrayLevelColorSwatchTemplate"], ",", "3"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"Lighting", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"Ambient\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.19699838300000003`, 0.252204821, 
                    0.33320940200000004`]|>, "RGBColorSwatchTemplate"]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{"\"Directional\"", ",", 
                    
                    TemplateBox[<|
                    "color" -> RGBColor[
                    0.15473514000000002`, 0.21284718000000002`, 
                    0.29811516000000005`]|>, "RGBColorSwatchTemplate"], ",", 
                    RowBox[{"ImageScaled", "[", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", "0", ",", "2"}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             Graphics3DBox[
              SphereBox[{0, 0, 0}], ViewPoint -> {0, 0, 
                DirectedInfinity[1]}, 
              PlotRange -> {{-0.7, 0.7}, {-0.7, 0.7}, All}, ImagePadding -> 
              0]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "12"}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->49088804,ExpressionUUID->"22892989-17db-489b-90c1-eda446f74a2f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"3404ba10-098d-4b14-a8f2-600ce1c05f03"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->792923168,ExpressionUUID->"51f0e6be-b491-45ef-a828-bd6a82383039"],

Cell[TextData[{
 "Prove that the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    OverscriptBox["z", "_"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6332f981-ded4-4fcb-b92d-0098a55f096e"],
 " is not analytic."
}], "SolvedExampleNote",
 CellID->35151441,ExpressionUUID->"3040801e-d91c-4878-92aa-d5e482224fed"],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "x"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"3c4fb955-ce51-4799-9f38-c058aa1fd4e8"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"v", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"-", "y"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e5a8dd76-52b6-4c20-a36b-c233156b695f"],
 "."
}], "SolvedExampleNote",
 CellID->100228963,ExpressionUUID->"c1e4f421-e5aa-42f4-9aa3-d5da97ebb76b"],

Cell[TextData[{
 "Therefore, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[PartialD]", "u"}], "/", 
     RowBox[{"\[PartialD]", "x"}]}], "!=", 
    RowBox[{
     RowBox[{"\[PartialD]", "v"}], "/", 
     RowBox[{"\[PartialD]", "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bda0eac7-15ca-40e6-a258-ccc466ab1921"],
 ", and the function is not analytic."
}], "SolvedExampleNote",
 CellID->42005725,ExpressionUUID->"d8e922d3-bd96-4f9c-9b0e-9f6fb568bde1"],

Cell["", "SolvedExampleEndCap",
 CellID->839614050,ExpressionUUID->"fdfd121b-7edf-402a-b5d5-45d5c01eca3e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->25445746,ExpressionUUID->"d0dbd00c-212e-426d-902f-f83e4b9fac48"],

Cell[TextData[{
 "Verify the Cauchy\[Dash]Riemann equations for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"sin", " ", "z"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"70d7ad13-3086-4fc6-a70a-5362106e7410"],
 ". Using ",
 ButtonBox["ComplexExpand",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->28898262,ExpressionUUID->"4368bbe4-30fa-4104-961a-b42459d41ba1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", 
    RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "//", 
  "ComplexExpand"}]], "SolvedExampleInput",
 CellID->460532335,ExpressionUUID->"cb2f614e-38c6-468e-b371-85b0238d5a39"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "SolvedExampleOutput",
 CellID->523416269,ExpressionUUID->"473c4922-a067-4532-b856-b62c23fae3f2"]
}, Open  ]],

Cell["So:", "SolvedExampleNote",
 CellID->691391758,ExpressionUUID->"cdb0adc4-b7f9-4b44-941c-02e344735cee"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Cosh", "[", "y", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}]}], ";"}]], "SolvedExampleInput",
 CellID->378518246,ExpressionUUID->"fe307cc6-8e8b-4f0f-91e7-9357c72a71a7"],

Cell["And:", "SolvedExampleNote",
 CellID->56411497,ExpressionUUID->"91dd6a2b-a77d-42c4-9687-6305d5c25716"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sinh", "[", "y", "]"}]}]}], ";"}]], "SolvedExampleInput",
 CellID->55444139,ExpressionUUID->"d1dc0bb5-c530-43b7-b691-a63a2f3080fc"],

Cell["Checking the first Cauchy\[Dash]Riemann equation:", "SolvedExampleNote",
 CellID->20455507,ExpressionUUID->"af8d4e5f-bb39-4941-95cf-47b0ded434d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->32638965,ExpressionUUID->"b604956d-6c70-496c-85c2-4ab4a430108d"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->98530620,ExpressionUUID->"ec1d49bc-ab7e-4402-8bde-2508cb29cff7"]
}, Open  ]],

Cell["Checking the second one:", "SolvedExampleNote",
 CellID->591662043,ExpressionUUID->"00c4fcdc-5483-4c24-ae3d-6152e35709ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], 
    "]"}]}]}]], "SolvedExampleInput",
 CellID->498576719,ExpressionUUID->"2149cd14-103d-4636-86e2-6a0a5e2426bb"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->523343313,ExpressionUUID->"abb4be1f-5364-4c66-8349-f1f07a67a47c"]
}, Open  ]],

Cell[TextData[{
 "Plot the level curves of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0143e8ff-3cba-495d-935e-4bbf32452a52"],
 " in orange and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"772e886d-f717-494f-afcb-d73e8a030230"],
 " in blue:"
}], "SolvedExampleNote",
 CellID->28416999,ExpressionUUID->"f6bfa673-304b-45e5-b19f-7b0da910e5b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", "SequenceIcon", 
      GridBox[{{
         RowBox[{
           TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["Sequence", "IconizedItem"]}]}, {
         RowBox[{
           TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["5", "IconizedItem"]}]}, {
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["3880", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Sequence[{$CellContext`u[$CellContext`x, $CellContext`y] == 
     3, $CellContext`u[$CellContext`x, $CellContext`y] == 
     2, $CellContext`u[$CellContext`x, $CellContext`y] == 
     1, $CellContext`u[$CellContext`x, $CellContext`y] == 
     1/2, $CellContext`u[$CellContext`x, $CellContext`y] == 
     0, $CellContext`u[$CellContext`x, $CellContext`y] == (-1)/
      2, $CellContext`u[$CellContext`x, $CellContext`y] == -1, \
$CellContext`u[$CellContext`x, $CellContext`y] == -2, \
$CellContext`u[$CellContext`x, $CellContext`y] == -3, \
$CellContext`v[$CellContext`x, $CellContext`y] == 
     3, $CellContext`v[$CellContext`x, $CellContext`y] == 
     2, $CellContext`v[$CellContext`x, $CellContext`y] == 
     1, $CellContext`v[$CellContext`x, $CellContext`y] == 
     1/2, $CellContext`v[$CellContext`x, $CellContext`y] == 
     0, $CellContext`v[$CellContext`x, $CellContext`y] == (-1)/
      2, $CellContext`v[$CellContext`x, $CellContext`y] == -1, \
$CellContext`v[$CellContext`x, $CellContext`y] == -2, \
$CellContext`v[$CellContext`x, $CellContext`y] == -3}, {$CellContext`x, -2, 
     2}, {$CellContext`y, -2, 2}, ContourStyle -> Join[
      Table[Orange, 9], 
      Table[
       RGBColor[
        Rational[35, 128], 
        Rational[185, 256], 
        Rational[21, 32]], 9]], ImageSize -> Small],
   SelectWithContents->True,
   Selectable->False], "]"}]], "SolvedExampleInput",
 CellID->32272408,ExpressionUUID->"b2d049b6-ed5d-478d-b49b-68f2ef594884"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxkXXdcz9/3zwrZmyiVvSuSfbJDtoyKjIySFZkh2ZkloYxkbxJCnESSQqKh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    "], {{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53}], 
        LineBox[{54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", "3"}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], 
        LineBox[{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
         112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
          126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
         139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152,
          153}], LineBox[{154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 
         164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177,
          178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 
         191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
          205}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", "2"}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwNz2UiHgAAANBPd3f7NNM1zab/OoIDcAFn1DFsumu66/14B3jByemJqZBA
IDDDLHPMs8AiSyyzwipr/GGdDTb5yz+22GaHXfbY54BDjjjmhFPOOOeCS674
zzU33HLHPQ888sQzL7zyxjsffPJFQCiEUMIIJ4JIoogmhljiiCeBRJJIJoVU
0kgng0yyyCaHXPLIp4BCiigmSAmllFFOBZVUUU0NP6iljnoaaKSJZlpopY12
ftJBJ11000MvffQzwC9+M8gQw4wwyhjjfAP63joM
         "]], LineBox[CompressedData["
1:eJwVztc6ggEAgOHfpbgdZKRkjzRkJZvIntl7ZmaEe+x18D7Pd/jVxrPh8Zog
CBLUiXoaCNFIE820EKaVCFHaiNFOB5100U0PvfTRzwBxBkmQJEWaITIMM8Io
Y/yPZZkgxyRTTDPDLHPMs8AieZZYpsAKq6yxzgabbLHNDrvssU+RAw454pgT
TjnjnAsuueKaG265454HHinxxDMvvPLGO2U++OSLbyr88MsfVaTZMro=
         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", "1"}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0DVSA1AAQMGf4O5QcyWOQEkBNyMkwd0dgru7u/tS7MyrX3VtQ019JIRQ
R6OI0UScBEmaaaGVNtrpoJMuuumhlz76GWCQIYYZYZQxxplgkimmmWGWFHPM
s8AiSyyzwiprrLPBJltss8Mue+xzwCFHHHPCKWecc8ElV1xzwy133PPAI088
88Irb7zzwSdffPPD7//MaAgRoqSRTgaZZJFNDrnkkU8BhRRRTAmllFFOBZVU
8Qed2Ehp
         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", 
         FractionBox["1", "2"]}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == Rational[1, 2], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwNw+c2AmAAANBPTxEJWdl7VlaypYVQVnZU8v4/3HvOTTQ65XZPCKFmNBJC
r33G7DfugIMOmXDYEUcdc9ykE0465bQzzjrnvAsuuuSyK6665robbpoybcYt
t91x1z2z7pvzwEOPPPbEU888N++FBYuWLFvx0iuvrXrjrXfWrHvvg48++WzD
F199890PP/2y6bc/tmzb8deuf/4DT/obTA==
         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", "0"}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == 0, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwNwwNSRQEAAMBXN+lKHaED1DTZdj/bNn+2bdsXaXdmo2LiomMjgiCINyEy
CBJNMtkUU00z3QwzzTLbHHPNM98CCy2y2BJLLbPcCisNWWW1NdZaZ70NNtpk
sy222ma7HXbaZbc99tpnvwMOOuSwI4465rgTTjrltDPOGnbOeRdcdMllV1x1
zXU33HTLbXfcdc99Dzz0yGNPPPXMcy+89Mprb7z1znsffPTJZ1989c13P/z0
y29//PXPf4xbToI=
         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", 
           FractionBox["1", "2"]}]}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == Rational[-1, 2], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwNw0NyAAEAALCtbdu2bdu+9QHttQ+ubSuZScn+4epBSBAERx6HBsGJp555
7oWXXnntjbfeee+Djz757Iuvvvnuh59++e2Pv/4ZhAVBiKGGGW6EkUYZbYyx
xhlvgokmmWyKqaaZboaZZpltjrnmmW+BhRZZbImlllluhZVWWW2NtdZZb4ON
Ntlsi6222W6HnXbZbY+99tnvgIMOOeyIo4457oSTTjntjLPOOe+Ciy657Iqr
rrnuhptuue2Ou+75DxHELjw=
         "]], LineBox[CompressedData["
1:eJwNw1VSAlAAAMDneBKv5LeJgYqC3WKB3a2oGGB3d53M3ZktiiSK4wUhhKgl
hSGUWma5FVYascpqa6w1ap31Nhiz0SbjJmy2xVbbbLfDTrvstsde++x3wKSD
DjnsiKOmTDvmuBNOOuW0M84657wLLrrksiuuuua6G266ZcZtd9w16577Hnho
zrxHHnviqWeee+GlV15746133vvgo08+++Krb7774adffvvjr3/+A6RfPNk=

         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", "1"}]}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == -1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], 
        LineBox[{963, 964, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 
         975, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988,
          989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 999, 1000, 1001, 
         1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012}], 
        LineBox[{1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 
         1023, 1024, 1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 
         1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044, 
         1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 
         1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 
         1067}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", "2"}]}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == -2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[1, 0.5, 0], AbsoluteThickness[2], 
        LineBox[{1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 
         1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 
         1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 
         1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 
         1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118}], 
        LineBox[{1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 
         1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 
         1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 
         1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161, 
         1162, 1163, 1164, 1165, 1166, 1167}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cosh", "[", 
             TagBox["y", HoldForm], "]"}], " ", 
           RowBox[{"Sin", "[", 
             TagBox["x", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", "3"}]}]],
      Annotation[#, Cosh[
          HoldForm[$CellContext`y]] Sin[
          HoldForm[$CellContext`x]] == -3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[{1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 
         1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 
         1189, 1190, 1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 
         1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 1210, 
         1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", "3"}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[{1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 
         1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236, 1237, 1238, 1239, 
         1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 
         1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 
         1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270, 1271, 1272, 
         1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 
         1284, 1285, 1286, 1287, 1288, 1289, 1290}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", "2"}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[{1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 
         1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311, 
         1312, 1313}], LineBox[CompressedData["
1:eJwNw9VWVAEAAMDLAx9Cd3c3SHd3N0uowNIoqXTDzzJzzkRNhbrWIoIgCBsd
GQQxxhpnvAkmmmSyKaaaZroZZppltjnmmme+BRZaZLElllpmuRVWWmW1NdZa
Z70N/rDRJpttsdU22+2w0y677bHXPvsdcNAhhx1x1DHHnXDSKaedcdY5511w
0SWXXXHVNUOuu+GmW/70l7/ddsddw+6574GHHnnsiaf+8a9nnnvhpVde+8//
3njrnfc++OiTz7746pvvfvjpl9+QVzGZ
         "]], 
        LineBox[{1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 
         1446, 1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 
         1457, 1458, 1459, 1460}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", "1"}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[{1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 
         1471, 1472, 1473, 1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 
         1482, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491, 1492, 
         1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 
         1504, 1505, 1506, 1507, 1508}], LineBox[CompressedData["
1:eJwNw4dWjgEAANAvKpRVkTJKO5WSNIy0aM+/RNEkpEU0aDyI9yNlhLJauvec
mzI8FZoMC4LgvR8iguCjK35y1TU/+8WvfnPd7/7wpxtu+svf/vGv/9xy2x13
3fO/QWQQhHnAg4YbYaSHPOwRo4z2qMc87glPGmOscZ7ytPGeMcFEz3rO814w
yWQvmmKqaaabYaZZZnvJHHPN87L5FnjFQq9a5DWLLbHUMq97w5vestzbVlhp
ldXWeMe71lpnvQ022mSzLbbaZrsdhuy0y3t2e98H9tjrQx/ZZ78DDjrksI99
4ohPfeZzR33hmONOOOmUL33ltK9944yzzjnvW9+54KJLLrsPvN4+lg==
         "]], 
        LineBox[{1663, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671, 1672, 
         1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, 
         1684, 1685, 1686, 1687, 1688, 1689, 1690, 1691, 1692, 1693, 1694, 
         1695, 1696}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", 
         FractionBox["1", "2"]}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == Rational[1, 2], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[CompressedData["
1:eJwNw2k2AmAAAMDPn+7hSp4TdADOZE32CmXJXpGtRIQsESqEHMDMe9MfHR4Y
6gshDDoSCWHUMcedcNKYU8addsZZ55x3wUUTJk255LIrps246prrbph10y23
3XHXPffNmbfggYcWPfLYE089s2TZcyteeGnVK6+teeOtd9a998FHn2z47ItN
X33z3ZZtO3746Zddv/3x155//gMpbEZy
         "]], LineBox[CompressedData["
1:eJwNw4V2SAEAANC3YZML3UxtutvUMG2mm+nadLfpnO7u7u7u9gE+QhvuPefG
pKQlp4YEQfDFr2FB8M3v/vCnv/ztHzP96z+D8CAIMdQsZjWbYYab3RzmNJe5
zWOEkUYZbV7zmd8CFrSQhS1iUYtZ3BKWtJSljbGMZS1neSsYa5wVrWRlq1jV
ala3hjWtZW3rWNd61reBDW1kY5sYb1Ob2dwWtjTBVra2jYm2tZ3t7WBHO9nZ
LibZ1WS72d0e9rSXve1jX/vZ3wEOdJCDHWKKQx3mcEc40lGOdoxjHed4U01z
ghOd5GSnONVpTneGM53lbOc413nOd4ELXeRi013iUpe53BWudJWrXeNa17ne
DDe40U1udotb3eZ2d7jTXe52j3vd534PeNBDHvaIRz3mcU940lOe9oxnPed5
L3jRS172ile95nVveNNb3vaOd73nfR/40Ec+9olPfeZzX/jSV772jW9953s/
+NFPfvY/gDFsdg==
         "]], 
        LineBox[{2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 
         2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026, 
         2027, 2028, 2029, 2030, 2031, 2032, 2033, 2034, 2035, 2036, 2037, 
         2038, 2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046, 2047, 2048, 
         2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 
         2060, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069, 2070, 
         2071, 2072, 2073, 2074, 2075, 2076, 2077, 2078, 2079, 2080}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", "0"}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == 0, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[CompressedData["
1:eJwNw+dajgEAANC3f26jaJCGZIRSZpGiYZRCGkJlFaWSUIiWIirxldBQEWWX
K3PO85zwsrq82rAgCEKGrwmCCNe6zkijjDbG9W4w1o3GGW+CiW4yyc0mu8Wt
bnO7Ke5wp7tMNc3dppvhHve6z/0e8KCZZnnIw2Z7xBxzPeox88y3wEKPe8KT
nrLIYk9bYqlnPOs5yzxvuRVWWuUFq73oJS9bY611XvGq17zuDett8Ka3bLTJ
2zbbYqt3bPOu7d7zvg/ssNOHPvKxXT7xqd322Guf/T5zwEGf+8IhX/rKYUcc
9bVjvvGtIced8J2TvveDH51y2hln/eSc8y742S8u+tVvLrnsd3/401/+9o9/
XXHVf/4HR5dPOQ==
         "]], 
        LineBox[{2243, 2244, 2245, 2246, 2247, 2248, 2249, 2250, 2251, 2252, 
         2253, 2254, 2255, 2256, 2257, 2258, 2259, 2260, 2261, 2262, 2263, 
         2264, 2265, 2266, 2267, 2268, 2269, 2270, 2271, 2272, 2273, 2274, 
         2275, 2276, 2277, 2278, 2279, 2280, 2281, 2282, 2283, 2284, 2285, 
         2286, 2287, 2288, 2289}], 
        LineBox[{2290, 2291, 2292, 2293, 2294, 2295, 2296, 2297, 2298, 2299, 
         2300, 2301, 2302, 2303, 2304, 2305, 2306, 2307, 2308, 2309, 2310, 
         2311, 2312, 2313, 2314, 2315, 2316, 2317, 2318, 2319, 2320, 2321, 
         2322, 2323, 2324}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", 
           FractionBox["1", "2"]}]}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == Rational[-1, 2], "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[CompressedData["
1:eJwNw9NWRAEAAMDbYx+Qudm2bW52bdamzXaf3cw5E4qchaNxQRDETIgPgkST
TDbFVNNMN8NMs8w2ZI655plvgYUWWWyJpZZZboWVVlltjbXWWW+DjTbZbIut
ttluh5122W2PvfbZ74CDDjnsiKOOOe6Ek045bdgZZ51z3gUXXXLZFVddc90N
N90y4rY77rrnvgceeuSxJ54a9cxzL7z0ypjX3njrnfc++OiTz7746pvvfvjp
l9/++Ouf/0fFKc4=
         "]], 
        LineBox[{2441, 2442, 2443, 2444, 2445, 2446, 2447, 2448, 2449, 2450, 
         2451, 2452, 2453, 2454, 2455, 2456, 2457, 2458, 2459, 2460, 2461, 
         2462, 2463, 2464, 2465}], 
        LineBox[{2466, 2467, 2468, 2469, 2470, 2471, 2472, 2473, 2474, 2475, 
         2476, 2477, 2478, 2479, 2480, 2481, 2482, 2483, 2484, 2485}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", "1"}]}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == -1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[CompressedData["
1:eJwNwwk2gmEAAMDvD5FbuJLnBA6Q22VtQVmyF7KVJVshQmWNmfdmbHJqPBmF
ECZMJUKYdsZZ55x3wbQZs+ZcdMll8xZccdU11y264aZbbrvjrnuWLLvvgYdW
PPLYE089s2rNcy+89Mq619546533Nmz64KNPtnz2xbavvvlux649P/z0y29/
/LXvn2E0hMiYAw46ZNxhR0z4D4g+RFw=
         "]]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", "2"}]}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == -2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {RGBColor[
         NCache[
          Rational[35, 128], 0.2734375], 
         NCache[
          Rational[185, 256], 0.72265625], 
         NCache[
          Rational[21, 32], 0.65625]], AbsoluteThickness[2], 
        LineBox[{2570, 2571, 2572, 2573, 2574, 2575, 2576, 2577, 2578, 2579, 
         2580, 2581, 2582, 2583, 2584, 2585, 2586, 2587, 2588, 2589, 2590, 
         2591, 2592, 2593, 2594, 2595, 2596, 2597, 2598, 2599, 2600, 2601, 
         2602, 2603, 2604, 2605, 2606, 2607, 2608, 2609, 2610, 2611, 2612, 
         2613, 2614, 2615, 2616, 2617, 2618, 2619, 2620, 2621, 2622, 2623, 
         2624, 2625, 2626, 2627, 2628, 2629}]},
       RowBox[{
         RowBox[{
           RowBox[{"Cos", "[", 
             TagBox["x", HoldForm], "]"}], " ", 
           RowBox[{"Sinh", "[", 
             TagBox["y", HoldForm], "]"}]}], "\[Equal]", 
         RowBox[{"-", "3"}]}]],
      Annotation[#, Cos[
          HoldForm[$CellContext`x]] Sinh[
          HoldForm[$CellContext`y]] == -3, "Tooltip"]& ]}], {}},
  AspectRatio->1,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->Small,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->594052184,ExpressionUUID->"2adfe14e-6c7d-4b99-abda-cba45031d4a5"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->896301646,ExpressionUUID->"30e6d6b1-cf59-44ae-a3bf-1ae9afac231e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Properties of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "4edfd495-b1d0-4b5d-ae8a-c4169ac59f01"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]],ExpressionUUID->
  "7cb12a19-1f00-4f92-b74d-0ea89adb88d4"]
}], "Subsection",
 CellID->390042084,ExpressionUUID->"55c67cec-2c3d-4262-be89-0f837390b7c3"],

Cell["From the Cauchy\[Dash]Riemann equations it follows that", "Text",
 CellID->131845348,ExpressionUUID->"c6b879a2-d445-4545-a17e-01a6199d537b"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[PartialD]", "2"], "u"}], 
    RowBox[{"\[PartialD]", 
     SuperscriptBox["x", "2"]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox["\[PartialD]", 
      RowBox[{"\[PartialD]", "x"}]], 
     FractionBox[
      RowBox[{"\[PartialD]", "v"}], 
      RowBox[{"\[PartialD]", "y"}]]}], "=", 
    SubscriptBox["v", 
     RowBox[{"x", " ", "y"}]]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[PartialD]", "2"], "u"}], 
    RowBox[{"\[PartialD]", 
     SuperscriptBox["y", "2"]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      FractionBox["\[PartialD]", 
       RowBox[{"\[PartialD]", "y"}]], 
      FractionBox[
       RowBox[{"\[PartialD]", "v"}], 
       RowBox[{"\[PartialD]", "x"}]]}]}], "=", 
    RowBox[{"-", 
     SubscriptBox["v", 
      RowBox[{"x", " ", "y"}]]}]}]}], 
  TraditionalForm]}], "DisplayFormulaNumbered",
 CellID->8053507,ExpressionUUID->"5dfa82e8-4009-46b3-b52c-0ef9086daa0b"],

Cell[TextData[{
 "and similarly for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a25327d3-f202-4996-a0c6-5e2ffdfe0195"],
 ". So:"
}], "Text",
 CellID->61792551,ExpressionUUID->"23b31ddd-2485-429e-acd0-963d3543f406"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["y", "2"]}]]}], "=", "0"}], ",", "       ", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "v"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "v"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["y", "2"]}]]}], "=", "0"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->230939,ExpressionUUID->"7be08f91-a80a-4fda-b78d-14399e2c1c16"],

Cell[TextData[{
 "In other words, ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bba5576d-2056-4f25-8b3a-a570e1a4191c"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b2a57448-3eb3-499c-bbe2-aa734f16f267"],
 " satisfy the ",
 StyleBox["Laplace equation",
  FontSlant->"Italic"],
 ". Functions satisfying this equation are called ",
 StyleBox["harmonic functions",
  FontSlant->"Italic"],
 ". This book will discuss harmonic functions in more detail later, but here \
are two facts:"
}], "Text",
 CellID->71092133,ExpressionUUID->"6c52632d-95af-48f1-9afa-c34bcfd010b0"],

Cell[CellGroupData[{

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"53679e61-6213-4e28-8284-9568805647c2"],
 " is the real part of an analytic function, then the imaginary part ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"55d08a9c-5a18-48bd-8cca-14ddc586b4a1"],
 " is uniquely determined up to a constant and vice versa."
}], "ItemNumbered",
 CellID->119405265,ExpressionUUID->"0dfe785c-2ecf-43d9-bc61-15cccfc98da1"],

Cell[TextData[{
 "Given two harmonic functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2da49d4d-60ee-4a4c-8a9a-f297de4c1876"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"caedd1b4-786b-48f2-ab0a-3bd76e3cb5c9"],
 " with continuous partial derivatives and obeying the Cauchy\[Dash]Riemann \
equations, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"v", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"eb0f7564-d443-4fcf-9254-6d9950ec8249"],
 " is analytic."
}], "ItemNumbered",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 15000.},
 CellChangeTimes->{{3.972997572522546*^9, 3.9729975733759108`*^9}},
 CellID->1267754363,ExpressionUUID->"7e0e6c6f-7f83-45a3-868e-8cc17b833f09"]
}, Open  ]],

Cell["The proof of these two facts will be given later.", "Text",
 CellID->531497873,ExpressionUUID->"2bf7572c-32de-40c5-b8fd-863d2d3796bf"],

Cell[TextData[{
 "In Wolfram Language, the Laplacian operator ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Del]", "2"], "u"}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["y", "2"]}]]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5dd14d43-6492-4a54-ac28-fe44f1d77b3a"],
 " can be computed with the command ",
 ButtonBox["Laplacian",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->231203809,ExpressionUUID->"1de97643-8757-4cbb-8c6d-f44007640deb"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->506017796,ExpressionUUID->"56c678bf-1cda-4b5e-832f-7fc1f7edad61"],

Cell[TextData[{
 "Check that the real and imaginary parts of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"70af3cd2-43ae-43b1-8ee0-2a6fefd90f9e"],
 " are harmonic functions."
}], "SolvedExampleNote",
 CellID->92023731,ExpressionUUID->"10ed538e-930c-4eb1-915f-891a42bbeeca"],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "z"], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}]], "=", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "(", 
      RowBox[{
       RowBox[{"cos", " ", "y"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", "sin", " ", "y"}]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "20b4c9f6-f528-4274-add7-cebd37599548"],
 ", then:"
}], "SolvedExampleNote",
 CellID->146930315,ExpressionUUID->"5044d8cb-ee2a-43f8-a279-9bbe524eafd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["E", "x"], 
    RowBox[{"Cos", "[", "y", "]"}]}]}], ";"}]], "SolvedExampleInput",
 CellID->173937506,ExpressionUUID->"2a10f6a5-9c42-495e-ba1b-bbddf5f1c7bb"],

Cell["And:", "SolvedExampleNote",
 CellID->19355732,ExpressionUUID->"fbfdbb6b-dcd2-4fa8-911f-5803c701ab61"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["E", "x"], 
    RowBox[{"Sin", "[", "y", "]"}]}]}], ";"}]], "SolvedExampleInput",
 CellID->40945846,ExpressionUUID->"910d5eb5-46d3-4f8f-9036-c0ad7f90e938"],

Cell[TextData[{
 "Check with ",
 ButtonBox["D",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->398478110,ExpressionUUID->"d564c40c-3b6a-4b34-838e-696ae5275c9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "+", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]], "SolvedExampleInput",
 CellID->736893384,ExpressionUUID->"8085235f-7d4e-4e8a-87d5-4c894defcf5c"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->32361694,ExpressionUUID->"86f5f7fa-b4a2-42bf-ae81-2443ce5f11d7"]
}, Open  ]],

Cell["And:", "SolvedExampleNote",
 CellID->435763039,ExpressionUUID->"ed010b5d-bdea-4c35-b790-7b4450e4d5d7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2"}], "}"}]}], "]"}], "+", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]], "SolvedExampleInput",
 CellID->163191275,ExpressionUUID->"05685fa1-5cde-4b97-adc0-2daeed3da3b3"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->108965,ExpressionUUID->"d37d7c9b-3adf-48cc-bad3-727be785e5d9"]
}, Open  ]],

Cell[TextData[{
 "You can also use the command ",
 ButtonBox["Laplacian",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->549833508,ExpressionUUID->"b305f852-7273-4e26-93fc-f40b74f5765f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->191508368,ExpressionUUID->"a366c8d9-6abc-484d-b35d-5aae5d24a5ae"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->609866650,ExpressionUUID->"28183de7-a110-4b55-ade3-5ab987e1adfb"]
}, Open  ]],

Cell["And:", "SolvedExampleNote",
 CellID->336961762,ExpressionUUID->"62a7e5fb-f49d-4149-ae72-586094420a52"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->10189789,ExpressionUUID->"976a42ef-00a3-4438-8acf-d1331e37d56c"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->59395615,ExpressionUUID->"455d5397-42e8-484c-9289-d04e01bf7241"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->687583589,ExpressionUUID->"afc2cf09-58c1-4b38-a7cf-b2fe6ec4734d"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"af6605e9-cba7-46bd-b69a-7fa4f754dc65"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"v", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3182c55b-215b-48c9-aabb-af96b191fc11"],
 " is analytic, then its real and imaginary parts obey the \
Cauchy\[Dash]Riemann equations:"
}], "SummaryList",
 CellID->444140794,ExpressionUUID->"b258ab26-f73a-471e-b0b7-bbb14ed0d78f"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "u"}], 
     RowBox[{"\[PartialD]", "x"}]], "=", 
    FractionBox[
     RowBox[{"\[PartialD]", "v"}], 
     RowBox[{"\[PartialD]", "y"}]]}], ",", "     ", 
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "v"}], 
     RowBox[{"\[PartialD]", "x"}]], "=", 
    RowBox[{"-", 
     RowBox[{
      FractionBox[
       RowBox[{"\[PartialD]", "u"}], 
       RowBox[{"\[PartialD]", "y"}]], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->14579854,ExpressionUUID->"5ef975b9-d92d-40d6-9ebd-8bf486ba221d"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"v", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c97f3943-8f94-44a3-b341-c736648e7b86"],
 " is analytic, then ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "218db172-339f-42fe-88a3-2538d20090b5"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e9ff9206-826e-4ff4-88f3-7665c1fe80aa"],
 " are ",
 StyleBox["harmonic functions",
  FontSlant->"Italic"],
 ", meaning that they satisfy the Laplace equation:"
}], "SummaryList",
 CellID->384169377,ExpressionUUID->"fe085774-2ab7-4810-a6e3-f6182eb32a1b"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]]}], "=", "0"}], ",", "       ", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "v"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "v"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}]]}], "=", "0."}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->174555907,ExpressionUUID->"9352e89a-5919-4b85-9278-9341a6777005"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->569871912,ExpressionUUID->"e9dfe3fe-9fd4-484f-b996-87dd27497e99"],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[VeryThinSpace]", "z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8b56c822-04fe-491b-b7e9-98182aa2ea1d"],
 " is differentiable using the Cauchy\[Dash]Riemann equations."
}], "Exercise",
 CellID->9975064,ExpressionUUID->"b632af77-658b-4968-a6cb-9dc166da0472"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"a41d0c72-88d2-4ded-b450-345005661f5e"],

Cell[TextData[{
 "Writing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "z"], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}]], "=", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "(", 
      RowBox[{
       RowBox[{"cos", " ", "y"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", "sin", " ", "y"}]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "9fa6aa5c-edbf-4e5f-aed6-c8110c5a9600"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], "cos", " ", "y"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "fd11c98f-51b0-4336-9547-fc94c4737635"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"v", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], "sin", " ", "y"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "68cc5a9c-e3d5-436e-8e95-196f5f55a604"],
 "."
}], "SolutionAnswer",
 CellID->145807791,ExpressionUUID->"3c2d21fe-d4a8-4990-aadd-c41e5cbfb109"],

Cell[TextData[{
 "Therefore, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "x"], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "cos", " ", "y"}], "=", 
     SubscriptBox["v", "y"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b4830fc5-09a5-40f8-990e-dfcb2438f893"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["v", "x"], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "sin", " ", "y"}], "=", 
     RowBox[{"-", 
      SubscriptBox["u", "y"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2dad0b25-8d34-49b5-84d5-d784b06b2f24"],
 " and the Cauchy\[Dash]Riemann equations are satisfied, so ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[VeryThinSpace]", "z"}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"425da67b-0429-4873-96d3-5d494499b591"],
 " is analytic."
}], "SolutionAnswer",
 CellID->238642397,ExpressionUUID->"49270781-135c-42ae-8b38-34f9548d09c9"],

Cell["In Wolfram Language:", "SolutionAnswer",
 CellID->264181642,ExpressionUUID->"b65ffb6b-7743-430f-b508-bfc91beafd09"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["E", "x"], "*", 
    RowBox[{"Cos", "[", "y", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["E", "x"], "*", 
    RowBox[{"Sin", "[", "y", "]"}]}]}], ";"}]}], "ExerciseInput",
 CellID->566842735,ExpressionUUID->"150f223a-33e7-40d0-9e60-b878a8ee9cd4"],

Cell["The first Cauchy\[Dash]Riemann equation is satisfied:", "SolutionAnswer",
 CellID->39202430,ExpressionUUID->"e7ec86e2-6196-44e6-8ada-60f72a088021"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]], "ExerciseInput",
 CellID->301459265,ExpressionUUID->"13b88378-6b92-47e6-887b-d9053102f558"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->262934719,ExpressionUUID->"5ef54dca-e1bb-4a8a-98c1-272ca6a86ab7"]
}, Open  ]],

Cell["as is the second:", "SolutionAnswer",
 CellID->150646002,ExpressionUUID->"882a55fe-f15f-43d0-940c-f760ba05c077"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]], "ExerciseInput",\

 CellID->217313121,ExpressionUUID->"8a747242-67ee-41d3-89cb-7880c37706b7"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->187444889,ExpressionUUID->"fe20e4d1-fb7c-44e5-b4ab-194c6b999f8c"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[VeryThinSpace]", "z"}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d2eb8701-94be-416b-8fcd-6dcceab70922"],
 " is analytic."
}], "SolutionAnswer",
 CellID->337571827,ExpressionUUID->"349b86ae-c41b-4329-8e49-52557181c0cb"]
}, Closed]],

Cell[TextData[{
 "Check that the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["z", "2"], "+", 
     RowBox[{"3", "z"}], "+", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"431af2ca-e412-4ec0-b129-2245dd9c71cb"],
 " is differentiable."
}], "Exercise",
 CellID->106947760,ExpressionUUID->"8b5c9986-4516-4403-9656-2be4ef2b67a8"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"f8cd6430-33c0-41e9-9588-57829b2c8b8b"],

Cell[TextData[{
 "Writing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"f", "(", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0a8acae3-2b98-43c2-bbd0-bf04e4103cd8"],
 ", then:"
}], "SolutionAnswer",
 CellID->158174085,ExpressionUUID->"ef7c4f09-8f58-48ff-894d-921d92cd2a33"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["z", "2"], "+", 
    RowBox[{"3", "z"}], "+", "1"}], "/.", 
   RowBox[{"z", "->", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}]}]}], "//", 
  "ComplexExpand"}]], "ExerciseInput",
 CellID->62050744,ExpressionUUID->"639cae2e-972b-4570-8e27-5d4cedc3ec58"],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "-", 
  SuperscriptBox["y", "2"], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", "y"}], "+", 
     RowBox[{"2", " ", "x", " ", "y"}]}], ")"}]}]}]], "ExerciseOutput",
 CellID->148254445,ExpressionUUID->"67f73cb4-f729-4e2d-94b7-ae6527a8afad"]
}, Open  ]],

Cell[TextData[{
 "Therefore, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"adcf9c6e-efcb-4521-ae95-b3509d5523e2"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1694f2a7-b59c-4876-bfbb-eb592d3464db"],
 " are:"
}], "SolutionAnswer",
 CellID->178170500,ExpressionUUID->"d1f93932-c68f-4459-9be0-c7aa288a984b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"1", "+", 
    RowBox[{"3", "x"}], "+", 
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["y", "2"]}]}], ";"}]], "ExerciseInput",
 CellID->32675848,ExpressionUUID->"ddfb0535-85b8-4e13-96e3-995315fb1fbb"],

Cell["and:", "SolutionAnswer",
 CellID->84716200,ExpressionUUID->"cf0aa014-0e52-41c2-9c02-38ab10ffb73d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"3", "y"}], "+", 
    RowBox[{"2", "x", " ", "y"}]}]}], ";"}]], "ExerciseInput",
 CellID->120871740,ExpressionUUID->"ff93aed8-6568-4872-bb0b-b949864dd496"],

Cell["The first Cauchy\[Dash]Riemann equation is satisfied:", "SolutionAnswer",
 CellID->427059956,ExpressionUUID->"9f881c83-dadc-41fd-91d7-29c6d4f058fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]], "ExerciseInput",
 CellID->88207459,ExpressionUUID->"17401708-5622-40c6-9cda-f6ae741c8866"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->20005568,ExpressionUUID->"c08904f4-a4fe-493f-962a-16f100866ae4"]
}, Open  ]],

Cell["as is the second:", "SolutionAnswer",
 CellID->509415742,ExpressionUUID->"0d68dc21-0420-4d92-a5b1-229fcdae1f9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]], "ExerciseInput",\

 CellID->2221379,ExpressionUUID->"267b18e8-6687-40c5-ae11-3046cb52ed04"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->11821865,ExpressionUUID->"08e02e5f-5771-47a7-ab5c-e0113ce5f449"]
}, Open  ]],

Cell[TextData[{
 "So, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a2ebe9fd-e8aa-46a5-bcab-3977a4a167b7"],
 " is analytic."
}], "SolutionAnswer",
 CellID->104932552,ExpressionUUID->"e3da26dc-0880-44ab-8052-58dc01bfec85"]
}, Closed]],

Cell[TextData[{
 "Prove that if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c23c07b2-bd86-4305-9c17-0e7c8cb3446e"],
 " is analytic, then ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    RowBox[{"f", 
     RowBox[{"(", 
      OverscriptBox["z", "_"], ")"}]}], "_"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"106f59d6-0dae-4622-89f2-93c3af01440e"],
 " is also analytic."
}], "Exercise",
 CellID->109129629,ExpressionUUID->"c9bbed3d-58fd-4f70-8dfb-d024835b18c4"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"885fcb16-38de-40b8-90d1-331d62f91976"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
     RowBox[{
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "y"}], ")"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"v", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"977a1ba8-9587-2046-90d7-5ea0e4c6f20c"],
 ". Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    OverscriptBox[
     RowBox[{"f", 
      RowBox[{"(", 
       OverscriptBox["z", "_"], ")"}]}], "_"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"u", "(", 
       RowBox[{"x", ",", 
        RowBox[{"-", "y"}]}], ")"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"v", "(", 
        RowBox[{"x", ",", 
         RowBox[{"-", "y"}]}], ")"}]}]}], "=", 
     RowBox[{
      RowBox[{"a", "(", 
       RowBox[{"x", ",", "y"}], ")"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"b", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f4b1b190-1497-4741-8c74-0be274d30051"],
 "."
}], "SolutionAnswer",
 CellID->10328729,ExpressionUUID->"dde2effb-f4a7-4e4f-a540-33dec56da65d"],

Cell[TextData[{
 "One needs to show that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "x"], "=", 
    SubscriptBox["b", "y"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ae80b102-288f-4e28-a319-e9b7447d0898"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "x"], "=", 
    RowBox[{"-", 
     SubscriptBox["a", "y"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b5042607-8cdb-43a5-b9b7-a5f84051f38a"],
 ". But from their definitions:"
}], "SolutionAnswer",
 CellID->828391129,ExpressionUUID->"dbf0f1b4-3cf4-41ef-b222-3c82c9465791"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "x"], "=", 
    SubscriptBox["u", "x"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "43f8309c-732c-4ced-b4d5-814eafaeae44"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "y"], "=", 
    RowBox[{"-", 
     SubscriptBox["u", "y"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f8af117a-8037-4896-9ec1-33672b6e4841"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "x"], "=", 
    RowBox[{"-", 
     SubscriptBox["v", "x"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7254d1ee-7dbe-4d92-b28a-b6d88cd38391"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "y"], "=", 
    SubscriptBox["v", "y"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "99896345-d787-4a3c-a6d6-61d2703582d2"],
 ". So:"
}], "SolutionAnswer",
 CellID->165356073,ExpressionUUID->"cb4f5837-48c9-4efc-96f3-9671a2d7aadf"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "x"], "=", 
    RowBox[{
     SubscriptBox["u", "x"], "=", 
     RowBox[{
      SubscriptBox["v", "y"], "=", 
      SubscriptBox["b", "y"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"568e54df-fcc5-4c9c-aea2-949908f09846"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "x"], "=", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["v", "x"]}], "=", 
     RowBox[{
      SubscriptBox["u", "y"], "=", 
      RowBox[{"-", 
       SubscriptBox["a", "y"]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f8cb27e8-d6eb-42bd-90c2-716111531deb"],
 ". This proves the statement."
}], "SolutionAnswer",
 CellID->609201821,ExpressionUUID->"bdfd027b-e3dd-4f98-935e-460a475924d4"]
}, Closed]],

Cell[TextData[{
 "Check that the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"1", "/", "z"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ab725ef4-8614-4209-9a2b-1cdb3744e4ee"],
 " is analytic except at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bcc66deb-f783-47ea-82ee-2eb711442386"],
 "."
}], "Exercise",
 CellID->313508086,ExpressionUUID->"f709a60f-6356-48a4-87ef-2cab08e585d1"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"6de3568f-ccde-4474-bff2-188b357f9952"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}]], "=", 
      RowBox[{
       FractionBox["x", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}]], "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        FractionBox["y", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"]}]]}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"c34cf235-7266-4fe3-afd9-b65408b749fa"],
 ". So:"
}], "SolutionAnswer",
 CellID->522284161,ExpressionUUID->"adb6a766-b826-4afc-b9b4-243635777ba9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   FractionBox["x", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}]]}], ";"}]], "ExerciseInput",
 CellID->74050163,ExpressionUUID->"9fee7a89-28bb-4011-8461-710a03b488be"],

Cell["and:", "SolutionAnswer",
 CellID->1417879,ExpressionUUID->"751f635b-c608-4e76-a9ee-8793670279b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"-", 
    FractionBox["y", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]]}]}], ";"}]], "ExerciseInput",
 CellID->438679034,ExpressionUUID->"98841b77-59c4-48e2-8702-eeebb7abfe90"],

Cell["The first Cauchy\[Dash]Riemann equation is satisfied:", "SolutionAnswer",
 CellID->777025458,ExpressionUUID->"279cd79e-ce65-4d47-84ba-cf3b505e43ba"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}], "//", 
  "Simplify"}]], "ExerciseInput",
 CellID->25420751,ExpressionUUID->"4f4f5c34-a6cd-427b-9113-f9bd0949ebc5"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->737715633,ExpressionUUID->"3391af2c-efe2-4c94-bdf9-2dad5c90e89b"]
}, Open  ]],

Cell["as is the second:", "SolutionAnswer",
 CellID->221949377,ExpressionUUID->"b71855a4-65d9-4a63-a96c-411cd004ec59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "==", 
  RowBox[{"-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}]], "ExerciseInput",\

 CellID->86437942,ExpressionUUID->"f3f93d62-3b57-45e5-b66d-03869e17b51b"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->236693036,ExpressionUUID->"01d87181-4473-4d82-8339-182dfcad0c33"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"31fa491f-8687-44c9-928d-b3993eca017b"],
 " is analytic, except at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c4c7b743-7224-4bed-b959-63ea1b5c69a0"],
 ", which is a singularity."
}], "SolutionAnswer",
 CellID->420370057,ExpressionUUID->"560fbcf2-07fd-45e3-924c-ae8fd1de0305"]
}, Closed]],

Cell[TextData[{
 "Check that the real and imaginary parts of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["z", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"48c60109-895d-401b-9bad-ac15a7f6ecea"],
 " are harmonic functions."
}], "Exercise",
 CellID->632027901,ExpressionUUID->"ede857e3-69fe-43a2-9ab1-2fe8f67d53c3"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"472bba6a-1e51-4769-80ac-530693700546"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", "+", 
       RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"], "=", 
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox["y", "2"], "+", 
       RowBox[{"2", "\[ImaginaryI]", " ", "x", " ", "y"}]}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "59f5f826-e885-4030-87df-463a1e10ed63"],
 ". So:"
}], "SolutionAnswer",
 CellID->199505212,ExpressionUUID->"4fca3de6-8a38-45d9-aad7-4479b89ee361"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox["x", "2"], "-", 
    SuperscriptBox["y", "2"]}]}], ";"}]], "ExerciseInput",
 CellID->113006128,ExpressionUUID->"79492236-536c-4c35-85be-71c13d121d2a"],

Cell["and", "SolutionAnswer",
 CellID->165998474,ExpressionUUID->"d46f4dd7-89e1-4554-8d3c-e970ed159f63"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"2", "x", " ", "y"}]}], ";"}]], "ExerciseInput",
 CellID->228750644,ExpressionUUID->"1d6e6e81-06bb-46b1-9dc1-42cf0afe806f"],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6b0b310e-1c34-45de-a596-4fd77b75eb8a"],
 " is harmonic:"
}], "SolutionAnswer",
 CellID->317477581,ExpressionUUID->"77bca92c-42b8-45d8-b6c1-ff784eefda64"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->1693352,ExpressionUUID->"5185236d-063f-4410-8ffb-c5116b6c3da8"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->559649861,ExpressionUUID->"41a9069a-7c2d-4a87-8f11-024f3b64ed30"]
}, Open  ]],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"248624ec-da08-4f0e-850d-8176259a8e06"],
 " is harmonic:"
}], "SolutionAnswer",
 CellID->688073807,ExpressionUUID->"30543eb0-34e0-48fc-9ca0-6a55d3a2d425"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->305422579,ExpressionUUID->"e66fb6c7-8167-48b1-a7e9-a2a973cb7c64"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->408351788,ExpressionUUID->"39b18ffb-3c0f-4d8d-a942-af4d4d2aae06"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1668919103,ExpressionUUID->"b30ff8fb-6218-4fe1-aba2-4dfe47bb8c63"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"10. The Cauchy\[Dash]Riemann Equations | Essentials of Complex \
Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "9. Complex Derivatives"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "11. Complex Line Integrals"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"83867851-cb20-417c-a5ca-e3a0c818ebc3"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[662, 24, 240, 7, 108, "Section",ExpressionUUID->"52ebc09d-ebe3-4955-9830-43d3dc72d44c",
 CounterAssignments->{{"Section", 9}},
 CellID->493745813],
Cell[905, 33, 307, 5, 83, "Text",ExpressionUUID->"bb2680c9-6e21-4581-9fbf-c1d3a7c00c0d",
 CellID->144698969],
Cell[1215, 40, 415, 7, 83, "Text",ExpressionUUID->"a6d81c77-05c8-4af8-bc37-d26f95bb5f85",
 CellID->729175485],
Cell[CellGroupData[{
Cell[1655, 51, 127, 1, 56, "Subsection",ExpressionUUID->"cd27839e-9a7c-43b0-8340-0a83ebe58971",
 CellID->858602993],
Cell[1785, 54, 115, 1, 36, "Text",ExpressionUUID->"07d30c27-130a-4fc9-b769-44ff2432b65b",
 CellID->32867425],
Cell[1903, 57, 553, 18, 32, "DisplayFormulaNumbered",ExpressionUUID->"e2dcb77e-bf04-4709-9309-b69dd4831d74",
 CellID->170619754],
Cell[2459, 77, 458, 11, 60, "Text",ExpressionUUID->"0dae21a6-f505-46bd-9f8d-a3019d9d0ca6",
 CellID->141962840],
Cell[2920, 90, 116, 1, 36, "Text",ExpressionUUID->"a10e57d9-007b-41df-9277-bd07ce455448",
 CellID->102806856],
Cell[3039, 93, 1621, 48, 65, "DisplayFormulaNumbered",ExpressionUUID->"d48a9fac-c424-4d20-8b43-6b6d71d69869",
 CellID->645243383],
Cell[4663, 143, 121, 1, 36, "Text",ExpressionUUID->"992c36e6-52e5-49b4-a721-a848dde97b2f",
 CellID->650696508],
Cell[4787, 146, 1775, 52, 68, "DisplayFormulaNumbered",ExpressionUUID->"45336c0f-41d7-4409-a86b-f46716476889",
 CellID->134273854],
Cell[6565, 200, 256, 5, 60, "Text",ExpressionUUID->"5ad0e6bc-a637-41d6-995c-479feaa0a3af",
 CellID->53463100],
Cell[6824, 207, 860, 25, 60, "DisplayFormulaNumbered",ExpressionUUID->"337bb773-1bcd-4722-97f9-d00902b9e820",
 CellID->464752000],
Cell[7687, 234, 186, 8, 71, "SolvedExample",ExpressionUUID->"e4494468-3b0b-4c51-b6a0-9e87004466cb",
 CellID->14514036],
Cell[7876, 244, 372, 10, 39, "SolvedExampleNote",ExpressionUUID->"ed0841ca-a8da-40a1-8d29-29fd1060d38f",
 CellID->48679376],
Cell[8251, 256, 1430, 44, 61, "SolvedExampleNote",ExpressionUUID->"3ed09b6c-9c5c-45b2-b192-61c369a8d00b",
 CellID->224612217],
Cell[9684, 302, 318, 9, 27, "SolvedExampleInput",ExpressionUUID->"e92c58cc-e58f-4268-9a95-c801b87af398",
 CellID->48378144],
Cell[10005, 313, 107, 1, 39, "SolvedExampleNote",ExpressionUUID->"f3a99284-21f3-4b77-9d77-108e4f7d59e9",
 CellID->66269597],
Cell[10115, 316, 314, 9, 27, "SolvedExampleInput",ExpressionUUID->"333cf47e-2ab6-4a02-8716-c07ace006db3",
 CellID->179294475],
Cell[10432, 327, 153, 1, 39, "SolvedExampleNote",ExpressionUUID->"612b0568-0f07-44b6-851f-a074bf97986e",
 CellID->156141472],
Cell[CellGroupData[{
Cell[10610, 332, 358, 11, 25, "SolvedExampleInput",ExpressionUUID->"e5aec4aa-3740-4e99-bb98-7345c8b31901",
 CellID->322109515],
Cell[10971, 345, 119, 1, 36, "SolvedExampleOutput",ExpressionUUID->"be087da4-ff44-48eb-a189-3eef5d9a5b87",
 CellID->955556110]
}, Open  ]],
Cell[11105, 349, 127, 1, 39, "SolvedExampleNote",ExpressionUUID->"6207a8d2-3a82-4010-9417-c5564e8491fd",
 CellID->38902700],
Cell[CellGroupData[{
Cell[11257, 354, 381, 12, 25, "SolvedExampleInput",ExpressionUUID->"991812e5-5aed-453b-9a3a-ef4e4a897639",
 CellID->163545968],
Cell[11641, 368, 118, 1, 36, "SolvedExampleOutput",ExpressionUUID->"dde8953d-c0a0-4f94-b923-4bdceb707859",
 CellID->83198450]
}, Open  ]],
Cell[11774, 372, 492, 15, 39, "SolvedExampleNote",ExpressionUUID->"373d2114-e8fa-4440-a79f-b5e3fa83206f",
 CellID->540803316],
Cell[CellGroupData[{
Cell[12291, 391, 1560, 41, 27, "SolvedExampleInput",ExpressionUUID->"9393e3fd-423e-453e-b6aa-19a5ba5704d1",
 CellID->19481094],
Cell[13854, 434, 258520, 4314, 170, "SolvedExampleOutput",ExpressionUUID->"22892989-17db-489b-90c1-eda446f74a2f",
 CellID->49088804]
}, Open  ]],
Cell[272389, 4751, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"3404ba10-098d-4b14-a8f2-600ce1c05f03",
 CellID->943814759],
Cell[272498, 4754, 187, 8, 71, "SolvedExample",ExpressionUUID->"51f0e6be-b491-45ef-a828-bd6a82383039",
 CellID->792923168],
Cell[272688, 4764, 365, 10, 39, "SolvedExampleNote",ExpressionUUID->"3040801e-d91c-4878-92aa-d5e482224fed",
 CellID->35151441],
Cell[273056, 4776, 573, 18, 39, "SolvedExampleNote",ExpressionUUID->"c1e4f421-e5aa-42f4-9aa3-d5da97ebb76b",
 CellID->100228963],
Cell[273632, 4796, 490, 14, 39, "SolvedExampleNote",ExpressionUUID->"d8e922d3-bd96-4f9c-9b0e-9f6fb568bde1",
 CellID->42005725],
Cell[274125, 4812, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"fdfd121b-7edf-402a-b5d5-45d5c01eca3e",
 CellID->839614050],
Cell[274234, 4815, 186, 8, 71, "SolvedExample",ExpressionUUID->"d0dbd00c-212e-426d-902f-f83e4b9fac48",
 CellID->25445746],
Cell[274423, 4825, 436, 13, 39, "SolvedExampleNote",ExpressionUUID->"4368bbe4-30fa-4104-961a-b42459d41ba1",
 CellID->28898262],
Cell[CellGroupData[{
Cell[274884, 4842, 244, 6, 25, "SolvedExampleInput",ExpressionUUID->"cb2f614e-38c6-468e-b371-85b0238d5a39",
 CellID->460532335],
Cell[275131, 4850, 332, 8, 36, "SolvedExampleOutput",ExpressionUUID->"473c4922-a067-4532-b856-b62c23fae3f2",
 CellID->523416269]
}, Open  ]],
Cell[275478, 4861, 107, 1, 39, "SolvedExampleNote",ExpressionUUID->"cdb0adc4-b7f9-4b44-941c-02e344735cee",
 CellID->691391758],
Cell[275588, 4864, 301, 8, 25, "SolvedExampleInput",ExpressionUUID->"fe307cc6-8e8b-4f0f-91e7-9357c72a71a7",
 CellID->378518246],
Cell[275892, 4874, 107, 1, 39, "SolvedExampleNote",ExpressionUUID->"91dd6a2b-a77d-42c4-9687-6305d5c25716",
 CellID->56411497],
Cell[276002, 4877, 300, 8, 25, "SolvedExampleInput",ExpressionUUID->"d1dc0bb5-c530-43b7-b691-a63a2f3080fc",
 CellID->55444139],
Cell[276305, 4887, 152, 1, 39, "SolvedExampleNote",ExpressionUUID->"af8d4e5f-bb39-4941-95cf-47b0ded434d6",
 CellID->20455507],
Cell[CellGroupData[{
Cell[276482, 4892, 357, 11, 25, "SolvedExampleInput",ExpressionUUID->"b604956d-6c70-496c-85c2-4ab4a430108d",
 CellID->32638965],
Cell[276842, 4905, 118, 1, 36, "SolvedExampleOutput",ExpressionUUID->"ec1d49bc-ab7e-4402-8bde-2508cb29cff7",
 CellID->98530620]
}, Open  ]],
Cell[276975, 4909, 128, 1, 39, "SolvedExampleNote",ExpressionUUID->"00c4fcdc-5483-4c24-ae3d-6152e35709ff",
 CellID->591662043],
Cell[CellGroupData[{
Cell[277128, 4914, 381, 12, 25, "SolvedExampleInput",ExpressionUUID->"2149cd14-103d-4636-86e2-6a0a5e2426bb",
 CellID->498576719],
Cell[277512, 4928, 119, 1, 36, "SolvedExampleOutput",ExpressionUUID->"abb4be1f-5364-4c66-8349-f1f07a67a47c",
 CellID->523343313]
}, Open  ]],
Cell[277646, 4932, 529, 15, 39, "SolvedExampleNote",ExpressionUUID->"f6bfa673-304b-45e5-b19f-7b0da910e5b3",
 CellID->28416999],
Cell[CellGroupData[{
Cell[278200, 4951, 2306, 48, 27, "SolvedExampleInput",ExpressionUUID->"b2d049b6-ed5d-478d-b49b-68f2ef594884",
 CellID->32272408],
Cell[280509, 5001, 51580, 989, 202, "SolvedExampleOutput",ExpressionUUID->"2adfe14e-6c7d-4b99-abda-cba45031d4a5",
 CellID->594052184]
}, Open  ]],
Cell[332104, 5993, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"30e6d6b1-cf59-44ae-a3bf-1ae9afac231e",
 CellID->896301646]
}, Open  ]],
Cell[CellGroupData[{
Cell[332247, 5999, 460, 14, 56, "Subsection",ExpressionUUID->"55c67cec-2c3d-4262-be89-0f837390b7c3",
 CellID->390042084],
Cell[332710, 6015, 146, 1, 36, "Text",ExpressionUUID->"c6b879a2-d445-4545-a17e-01a6199d537b",
 CellID->131845348],
Cell[332859, 6018, 1051, 36, 103, "DisplayFormulaNumbered",ExpressionUUID->"5dfa82e8-4009-46b3-b52c-0ef9086daa0b",
 CellID->8053507],
Cell[333913, 6056, 309, 9, 36, "Text",ExpressionUUID->"23b31ddd-2485-429e-acd0-963d3543f406",
 CellID->61792551],
Cell[334225, 6067, 863, 28, 54, "DisplayFormulaNumbered",ExpressionUUID->"7be08f91-a80a-4fda-b78d-14399e2c1c16",
 CellID->230939],
Cell[335091, 6097, 652, 18, 83, "Text",ExpressionUUID->"6c52632d-95af-48f1-9afa-c34bcfd010b0",
 CellID->71092133],
Cell[CellGroupData[{
Cell[335768, 6119, 602, 15, 50, "ItemNumbered",ExpressionUUID->"0dfe785c-2ecf-43d9-bc61-15cccfc98da1",
 CellID->119405265],
Cell[336373, 6136, 1107, 30, 50, "ItemNumbered",ExpressionUUID->"7e0e6c6f-7f83-45a3-868e-8cc17b833f09",
 CellGroupingRules->{"GroupTogetherNestedGrouping", 15000.},
 CellID->1267754363]
}, Open  ]],
Cell[337495, 6169, 140, 1, 36, "Text",ExpressionUUID->"2bf7572c-32de-40c5-b8fd-863d2d3796bf",
 CellID->531497873],
Cell[337638, 6172, 756, 24, 67, "Text",ExpressionUUID->"1de97643-8757-4cbb-8c6d-f44007640deb",
 CellID->231203809],
Cell[338397, 6198, 187, 8, 71, "SolvedExample",ExpressionUUID->"56c678bf-1cda-4b5e-832f-7fc1f7edad61",
 CellID->506017796],
Cell[338587, 6208, 419, 10, 39, "SolvedExampleNote",ExpressionUUID->"10ed538e-930c-4eb1-915f-891a42bbeeca",
 CellID->92023731],
Cell[339009, 6220, 642, 19, 39, "SolvedExampleNote",ExpressionUUID->"5044d8cb-ee2a-43f8-a279-9bbe524eafd4",
 CellID->146930315],
Cell[339654, 6241, 289, 8, 25, "SolvedExampleInput",ExpressionUUID->"2a10f6a5-9c42-495e-ba1b-bbddf5f1c7bb",
 CellID->173937506],
Cell[339946, 6251, 107, 1, 39, "SolvedExampleNote",ExpressionUUID->"fbfdbb6b-dcd2-4fa8-911f-5803c701ab61",
 CellID->19355732],
Cell[340056, 6254, 288, 8, 25, "SolvedExampleInput",ExpressionUUID->"910d5eb5-46d3-4f8f-9036-c0ad7f90e938",
 CellID->40945846],
Cell[340347, 6264, 174, 6, 39, "SolvedExampleNote",ExpressionUUID->"d564c40c-3b6a-4b34-838e-696ae5275c9f",
 CellID->398478110],
Cell[CellGroupData[{
Cell[340546, 6274, 455, 14, 25, "SolvedExampleInput",ExpressionUUID->"8085235f-7d4e-4e8a-87d5-4c894defcf5c",
 CellID->736893384],
Cell[341004, 6290, 115, 1, 36, "SolvedExampleOutput",ExpressionUUID->"86f5f7fa-b4a2-42bf-ae81-2443ce5f11d7",
 CellID->32361694]
}, Open  ]],
Cell[341134, 6294, 108, 1, 39, "SolvedExampleNote",ExpressionUUID->"ed010b5d-bdea-4c35-b790-7b4450e4d5d7",
 CellID->435763039],
Cell[CellGroupData[{
Cell[341267, 6299, 455, 14, 25, "SolvedExampleInput",ExpressionUUID->"05685fa1-5cde-4b97-adc0-2daeed3da3b3",
 CellID->163191275],
Cell[341725, 6315, 113, 1, 36, "SolvedExampleOutput",ExpressionUUID->"d37d7c9b-3adf-48cc-bad3-727be785e5d9",
 CellID->108965]
}, Open  ]],
Cell[341853, 6319, 200, 6, 39, "SolvedExampleNote",ExpressionUUID->"b305f852-7273-4e26-93fc-f40b74f5765f",
 CellID->549833508],
Cell[CellGroupData[{
Cell[342078, 6329, 276, 7, 25, "SolvedExampleInput",ExpressionUUID->"a366c8d9-6abc-484d-b35d-5aae5d24a5ae",
 CellID->191508368],
Cell[342357, 6338, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"28183de7-a110-4b55-ade3-5ab987e1adfb",
 CellID->609866650]
}, Open  ]],
Cell[342488, 6342, 108, 1, 39, "SolvedExampleNote",ExpressionUUID->"62a7e5fb-f49d-4149-ae72-586094420a52",
 CellID->336961762],
Cell[CellGroupData[{
Cell[342621, 6347, 275, 7, 25, "SolvedExampleInput",ExpressionUUID->"976a42ef-00a3-4438-8acf-d1331e37d56c",
 CellID->10189789],
Cell[342899, 6356, 115, 1, 36, "SolvedExampleOutput",ExpressionUUID->"455d5397-42e8-484c-9289-d04e01bf7241",
 CellID->59395615]
}, Open  ]],
Cell[343029, 6360, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"afc2cf09-58c1-4b38-a7cf-b2fe6ec4734d",
 CellID->687583589],
Cell[CellGroupData[{
Cell[343160, 6365, 109, 1, 69, "SummarySection",ExpressionUUID->"af6605e9-cba7-46bd-b69a-7fa4f754dc65",
 CellID->1198545324],
Cell[343272, 6368, 568, 16, 52, "SummaryList",ExpressionUUID->"b258ab26-f73a-471e-b0b7-bbb14ed0d78f",
 CellID->444140794],
Cell[343843, 6386, 608, 20, 50, "DisplayFormula",ExpressionUUID->"5ef975b9-d92d-40d6-9ebd-8bf486ba221d",
 CellID->14579854],
Cell[344454, 6408, 871, 26, 52, "SummaryList",ExpressionUUID->"fe085774-2ab7-4810-a6e3-f6182eb32a1b",
 CellID->384169377],
Cell[345328, 6436, 859, 28, 50, "DisplayFormula",ExpressionUUID->"9352e89a-5919-4b85-9278-9341a6777005",
 CellID->174555907]
}, Open  ]],
Cell[CellGroupData[{
Cell[346224, 6469, 160, 3, 65, "ExerciseSection",ExpressionUUID->"e9dfe3fe-9fd4-484f-b996-87dd27497e99",
 CellID->569871912],
Cell[346387, 6474, 436, 11, 29, "Exercise",ExpressionUUID->"b632af77-658b-4968-a6cb-9dc166da0472",
 CellID->9975064],
Cell[CellGroupData[{
Cell[346848, 6489, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"a41d0c72-88d2-4ded-b450-345005661f5e"],
Cell[346942, 6491, 1215, 39, 22, "SolutionAnswer",ExpressionUUID->"3c2d21fe-d4a8-4990-aadd-c41e5cbfb109",
 CellID->145807791],
Cell[348160, 6532, 1023, 30, 44, "SolutionAnswer",ExpressionUUID->"49270781-135c-42ae-8b38-34f9548d09c9",
 CellID->238642397],
Cell[349186, 6564, 121, 1, 22, "SolutionAnswer",ExpressionUUID->"b65ffb6b-7743-430f-b508-bfc91beafd09",
 CellID->264181642],
Cell[349310, 6567, 498, 15, 43, "ExerciseInput",ExpressionUUID->"150f223a-33e7-40d0-9e60-b878a8ee9cd4",
 CellID->566842735],
Cell[349811, 6584, 153, 1, 22, "SolutionAnswer",ExpressionUUID->"e7ec86e2-6196-44e6-8ada-60f72a088021",
 CellID->39202430],
Cell[CellGroupData[{
Cell[349989, 6589, 349, 10, 25, "ExerciseInput",ExpressionUUID->"13b88378-6b92-47e6-887b-d9053102f558",
 CellID->301459265],
Cell[350341, 6601, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"5ef54dca-e1bb-4a8a-98c1-272ca6a86ab7",
 CellID->262934719]
}, Open  ]],
Cell[350470, 6605, 118, 1, 22, "SolutionAnswer",ExpressionUUID->"882a55fe-f15f-43d0-940c-f760ba05c077",
 CellID->150646002],
Cell[CellGroupData[{
Cell[350613, 6610, 373, 12, 25, "ExerciseInput",ExpressionUUID->"8a747242-67ee-41d3-89cb-7880c37706b7",
 CellID->217313121],
Cell[350989, 6624, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"fe20e4d1-fb7c-44e5-b4ab-194c6b999f8c",
 CellID->187444889]
}, Open  ]],
Cell[351118, 6628, 333, 9, 22, "SolutionAnswer",ExpressionUUID->"349b86ae-c41b-4329-8e49-52557181c0cb",
 CellID->337571827]
}, Closed]],
Cell[351466, 6640, 417, 12, 25, "Exercise",ExpressionUUID->"8b5c9986-4516-4403-9656-2be4ef2b67a8",
 CellID->106947760],
Cell[CellGroupData[{
Cell[351908, 6656, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"f8cd6430-33c0-41e9-9588-57829b2c8b8b"],
Cell[352002, 6658, 407, 12, 22, "SolutionAnswer",ExpressionUUID->"ef7c4f09-8f58-48ff-894d-921d92cd2a33",
 CellID->158174085],
Cell[CellGroupData[{
Cell[352434, 6674, 339, 10, 27, "ExerciseInput",ExpressionUUID->"639cae2e-972b-4570-8e27-5d4cedc3ec58",
 CellID->62050744],
Cell[352776, 6686, 380, 10, 30, "ExerciseOutput",ExpressionUUID->"67f73cb4-f729-4e2d-94b7-ae6527a8afad",
 CellID->148254445]
}, Open  ]],
Cell[353171, 6699, 499, 15, 22, "SolutionAnswer",ExpressionUUID->"d1f93932-c68f-4459-9be0-c7aa288a984b",
 CellID->178170500],
Cell[353673, 6716, 322, 9, 27, "ExerciseInput",ExpressionUUID->"ddfb0535-85b8-4e13-96e3-995315fb1fbb",
 CellID->32675848],
Cell[353998, 6727, 104, 1, 22, "SolutionAnswer",ExpressionUUID->"cf0aa014-0e52-41c2-9c02-38ab10ffb73d",
 CellID->84716200],
Cell[354105, 6730, 281, 8, 25, "ExerciseInput",ExpressionUUID->"ff93aed8-6568-4872-bb0b-b949864dd496",
 CellID->120871740],
Cell[354389, 6740, 154, 1, 22, "SolutionAnswer",ExpressionUUID->"9f881c83-dadc-41fd-91d7-29c6d4f058fa",
 CellID->427059956],
Cell[CellGroupData[{
Cell[354568, 6745, 348, 10, 25, "ExerciseInput",ExpressionUUID->"17401708-5622-40c6-9cda-f6ae741c8866",
 CellID->88207459],
Cell[354919, 6757, 113, 1, 28, "ExerciseOutput",ExpressionUUID->"c08904f4-a4fe-493f-962a-16f100866ae4",
 CellID->20005568]
}, Open  ]],
Cell[355047, 6761, 118, 1, 22, "SolutionAnswer",ExpressionUUID->"0d68dc21-0420-4d92-a5b1-229fcdae1f9f",
 CellID->509415742],
Cell[CellGroupData[{
Cell[355190, 6766, 371, 12, 25, "ExerciseInput",ExpressionUUID->"267b18e8-6687-40c5-ae11-3046cb52ed04",
 CellID->2221379],
Cell[355564, 6780, 113, 1, 28, "ExerciseOutput",ExpressionUUID->"08e02e5f-5771-47a7-ab5c-e0113ce5f449",
 CellID->11821865]
}, Open  ]],
Cell[355692, 6784, 289, 8, 22, "SolutionAnswer",ExpressionUUID->"e3da26dc-0880-44ab-8052-58dc01bfec85",
 CellID->104932552]
}, Closed]],
Cell[355996, 6795, 541, 16, 25, "Exercise",ExpressionUUID->"c9bbed3d-58fd-4f70-8dfb-d024835b18c4",
 CellID->109129629],
Cell[CellGroupData[{
Cell[356562, 6815, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"885fcb16-38de-40b8-90d1-331d62f91976"],
Cell[356656, 6817, 1320, 43, 22, "SolutionAnswer",ExpressionUUID->"dde2effb-f4a7-4e4f-a540-33dec56da65d",
 CellID->10328729],
Cell[357979, 6862, 592, 18, 23, "SolutionAnswer",ExpressionUUID->"dbf0f1b4-3cf4-41ef-b222-3c82c9465791",
 CellID->828391129],
Cell[358574, 6882, 960, 32, 23, "SolutionAnswer",ExpressionUUID->"cb4f5837-48c9-4efc-96f3-9671a2d7aadf",
 CellID->165356073],
Cell[359537, 6916, 795, 26, 23, "SolutionAnswer",ExpressionUUID->"bdfd027b-e3dd-4f98-935e-460a475924d4",
 CellID->609201821]
}, Closed]],
Cell[360347, 6945, 515, 15, 25, "Exercise",ExpressionUUID->"f709a60f-6356-48a4-87ef-2cab08e585d1",
 CellID->313508086],
Cell[CellGroupData[{
Cell[360887, 6964, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"6de3568f-ccde-4474-bff2-188b357f9952"],
Cell[360981, 6966, 856, 27, 28, "SolutionAnswer",ExpressionUUID->"adb6a766-b826-4afc-b9b4-243635777ba9",
 CellID->522284161],
Cell[361840, 6995, 307, 9, 47, "ExerciseInput",ExpressionUUID->"9fee7a89-28bb-4011-8461-710a03b488be",
 CellID->74050163],
Cell[362150, 7006, 103, 1, 22, "SolutionAnswer",ExpressionUUID->"751f635b-c608-4e76-a9ee-8793670279b8",
 CellID->1417879],
Cell[362256, 7009, 331, 10, 47, "ExerciseInput",ExpressionUUID->"98841b77-59c4-48e2-8702-eeebb7abfe90",
 CellID->438679034],
Cell[362590, 7021, 154, 1, 22, "SolutionAnswer",ExpressionUUID->"279cd79e-ce65-4d47-84ba-cf3b505e43ba",
 CellID->777025458],
Cell[CellGroupData[{
Cell[362769, 7026, 390, 12, 25, "ExerciseInput",ExpressionUUID->"4f4f5c34-a6cd-427b-9113-f9bd0949ebc5",
 CellID->25420751],
Cell[363162, 7040, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"3391af2c-efe2-4c94-bdf9-2dad5c90e89b",
 CellID->737715633]
}, Open  ]],
Cell[363291, 7044, 118, 1, 22, "SolutionAnswer",ExpressionUUID->"b71855a4-65d9-4a63-a96c-411cd004ec59",
 CellID->221949377],
Cell[CellGroupData[{
Cell[363434, 7049, 372, 12, 25, "ExerciseInput",ExpressionUUID->"f3f93d62-3b57-45e5-b66d-03869e17b51b",
 CellID->86437942],
Cell[363809, 7063, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"01d87181-4473-4d82-8339-182dfcad0c33",
 CellID->236693036]
}, Open  ]],
Cell[363938, 7067, 475, 13, 22, "SolutionAnswer",ExpressionUUID->"560fbcf2-07fd-45e3-924c-ae8fd1de0305",
 CellID->420370057]
}, Closed]],
Cell[364428, 7083, 384, 10, 25, "Exercise",ExpressionUUID->"ede857e3-69fe-43a2-9ab1-2fe8f67d53c3",
 CellID->632027901],
Cell[CellGroupData[{
Cell[364837, 7097, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"472bba6a-1e51-4769-80ac-530693700546"],
Cell[364931, 7099, 738, 23, 22, "SolutionAnswer",ExpressionUUID->"4fca3de6-8a38-45d9-aad7-4479b89ee361",
 CellID->199505212],
Cell[365672, 7124, 283, 8, 27, "ExerciseInput",ExpressionUUID->"79492236-536c-4c35-85be-71c13d121d2a",
 CellID->113006128],
Cell[365958, 7134, 104, 1, 22, "SolutionAnswer",ExpressionUUID->"d46f4dd7-89e1-4554-8d3c-e970ed159f63",
 CellID->165998474],
Cell[366065, 7137, 236, 6, 25, "ExerciseInput",ExpressionUUID->"1d6e6e81-06bb-46b1-9dc1-42cf0afe806f",
 CellID->228750644],
Cell[366304, 7145, 321, 9, 22, "SolutionAnswer",ExpressionUUID->"77bca92c-42b8-45d8-b6c1-ff784eefda64",
 CellID->317477581],
Cell[CellGroupData[{
Cell[366650, 7158, 269, 7, 25, "ExerciseInput",ExpressionUUID->"5185236d-063f-4410-8ffb-c5116b6c3da8",
 CellID->1693352],
Cell[366922, 7167, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"41a9069a-7c2d-4a87-8f11-024f3b64ed30",
 CellID->559649861]
}, Open  ]],
Cell[367048, 7171, 321, 9, 22, "SolutionAnswer",ExpressionUUID->"30543eb0-34e0-48fc-9ca0-6a55d3a2d425",
 CellID->688073807],
Cell[CellGroupData[{
Cell[367394, 7184, 271, 7, 25, "ExerciseInput",ExpressionUUID->"e66fb6c7-8167-48b1-a7e9-a2a973cb7c64",
 CellID->305422579],
Cell[367668, 7193, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"39b18ffb-3c0f-4d8d-a942-af4d4d2aae06",
 CellID->408351788]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[367842, 7201, 310, 6, 135, "SmallText",ExpressionUUID->"b30ff8fb-6218-4fe1-aba2-4dfe47bb8c63",
 CellGroupingRules->"SectionGrouping",
 CellID->1668919103]
}
]
*)

(* NotebookSignature UTsm6xRGetnwPkYwn1y8t7GS *)
