(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    460137,       9998]
NotebookOptionsPosition[    275878,       6204]
NotebookOutlinePosition[    438922,       9593]
CellTagsIndexPosition[    438847,       9588]
WindowTitle->11. Complex Line Integrals | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Complex Line Integrals"
}], "Section",
 CounterAssignments->{{"Section", 10}},
 CellID->592339613,ExpressionUUID->"f7744ab9-dd4e-40a8-b7e9-6c49113ffa29"],

Cell["\<\
This chapter presents how the concept of integration is extended to complex \
functions.\
\>", "Text",
 CellID->360210785,ExpressionUUID->"4c2c5285-37ec-4e2f-91fd-68dfa66a5a43"],

Cell[CellGroupData[{

Cell["Review: Integration in Real Analysis", "Subsection",
 CellID->250400948,ExpressionUUID->"b54dd712-47c9-439a-93bd-82ac37b3607d"],

Cell["\<\
In real analysis, the definite integral is defined as the limit of the \
Riemann sum:\
\>", "Text",
 CellID->109580523,ExpressionUUID->"1160049d-a954-4427-ba2d-8088b287a62a"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", "b"], 
    RowBox[{
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"n", "->", "\[Infinity]"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{
      RowBox[{"f", "(", 
       SubscriptBox["x", "k"], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["x", 
          RowBox[{"k", "+", "1"}]], "-", 
         SubscriptBox["x", "k"]}], ")"}], "."}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->60871971,ExpressionUUID->"55eccf49-e19c-4242-b9a9-1606235a4791"],

Cell[TextData[{
 "The geometric meaning of the Riemann sum is shown in Fig. 1. As the number ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d6698184-be2e-4b61-a2d3-8c3dded6d79f"],
 " of subdivisions goes to infinity, the integral becomes equal to the \
(signed) area under the function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "004e3747-9241-4ab1-b8bd-f805c15f5450"],
 "."
}], "Text",
 CellID->83932821,ExpressionUUID->"3692c289-eb1a-420d-a8c5-895764ec28b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "pol", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pol", "=", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["31", "35"]}], "+", 
        FractionBox[
         RowBox[{"2833", " ", "x"}], "840"], "-", 
        FractionBox[
         RowBox[{"823", " ", 
          SuperscriptBox["x", "2"]}], "840"], "+", 
        FractionBox[
         SuperscriptBox["x", "3"], "12"]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{"pol", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"1", "/", "2"}], ",", 
          RowBox[{"15", "/", "2"}]}], "}"}], ",", 
        RowBox[{"AxesOrigin", "->", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], ",", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
        RowBox[{"AxesStyle", "->", 
         RowBox[{"Directive", "[", "12", "]"}]}], ",", 
        RowBox[{"ImageSize", "->", "300"}], ",", 
        RowBox[{"Ticks", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"-", "3"}], ",", "10"}], "}"}]}], "]"}], ",", 
           RowBox[{"Table", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", 
               RowBox[{"-", "1"}], ",", "5"}], "}"}]}], "]"}]}], "}"}]}], ",", 
        RowBox[{"AxesLabel", "->", 
         RowBox[{"{", 
          RowBox[{
          Cell["x",ExpressionUUID->"4e5e9ded-8dda-45d0-b774-9a923be2d9fb"], ",",
            Cell["f(x)",ExpressionUUID->
            "85067136-093d-4a66-a2e5-82f099669a63"]}], "}"}]}], ",", 
        RowBox[{"Epilog", "->", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Pink", ",", 
              RowBox[{"EdgeForm", "[", 
               RowBox[{"Thickness", "[", "0.001", "]"}], "]"}], ",", 
              RowBox[{"Opacity", "[", "0.4", "]"}], ",", "#"}], "}"}], "&"}], 
           "/@", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"Rectangle", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"1", "+", 
                  RowBox[{"i", "/", "2"}]}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"1", "+", 
                  RowBox[{"i", "/", "2"}], "+", 
                  RowBox[{"1", "/", "2"}]}], ",", 
                 RowBox[{"pol", "/.", 
                  RowBox[{"x", "->", 
                   RowBox[{"1", "+", 
                    RowBox[{"i", "/", "2"}], "+", 
                    RowBox[{"1", "/", "4"}]}]}]}]}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "0", ",", "11"}], "}"}]}], "]"}]}], ")"}]}]}],
        "]"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   ",", "\"\<Fig. 1. Geometric meaning of the Riemann sum.\>\""}], 
  "]"}]], "Input",
 CellID->148174721,ExpressionUUID->"605d6a4c-1f82-43c9-8afe-803abe0b9d18"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      InterpretationBox[{
        TagBox[{{{}, {}, 
           TagBox[
            {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
             LineBox[CompressedData["
1:eJwVmHc81W8Ux+80ojLuvea1ooyG8SOVPCcrJFSUhpKKjBDJSKKpQpIVlUhI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              "]]},
            Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
         {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
        StyleBox[
         DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
               Annotation[{
                 Directive[
                  Opacity[1.], 
                  RGBColor[0.24, 0.6, 0.8], 
                  AbsoluteThickness[2]], 
                 Line[CompressedData["
1:eJwVmHc81W8Ux+80ojLuvea1ooyG8SOVPCcrJFSUhpKKjBDJSKKpQpIVlUhI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                  "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{-3., 10.}, {-1., 5.}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0., 0.}, "ImageSize" -> {300, 300}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  RGBColor[0.24, 0.6, 0.8], 
                  AbsoluteThickness[2]]}, 
               "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
                   (Identity[#]& )[
                    Part[#, 1]], 
                   (Identity[#]& )[
                    Part[#, 2]]}& ), 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> Plot, "GroupHighlight" -> False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{-3., 10.}, {-1., 5.}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0., 0.}, "ImageSize" -> {300, 300}, 
              "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 RGBColor[0.24, 0.6, 0.8], 
                 AbsoluteThickness[2]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> ({
                  (Identity[#]& )[
                   Part[#, 1]], 
                  (Identity[#]& )[
                   Part[#, 2]]}& ), 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> Plot, "GroupHighlight" -> False|>|>],
          
          ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}],
         Selectable->False]},
       Annotation[{{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwVmHc81W8Ux+80ojLuvea1ooyG8SOVPCcrJFSUhpKKjBDJSKKpQpIVlUhI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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-3., 10.}, {-1., 5.}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0., 0.}, "ImageSize" -> {300, 300}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
      Axes->{True, True},
      AxesLabel->{
        FormBox[
         TagBox[
          TagBox["x", HoldForm], HoldForm], TraditionalForm], 
        FormBox[
         TagBox[
          RowBox[{"f", "(", 
            TagBox["x", HoldForm], ")"}], HoldForm], TraditionalForm]},
      AxesOrigin->{0., 0.},
      AxesStyle->Directive[12],
      DisplayFunction->Identity,
      Epilog->{{
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[{1, 0}, 
          NCache[{
            Rational[3, 2], 
            Rational[17579, 8960]}, {1.5, 1.9619419642857143`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[
          NCache[{
            Rational[3, 2], 0}, {1.5, 0}], 
          NCache[{2, 
            Rational[66191, 26880]}, {2, 2.4624627976190476`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[{2, 0}, 
          NCache[{
            Rational[5, 2], 
            Rational[24119, 8960]}, {2.5, 2.6918526785714287`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[
          NCache[{
            Rational[5, 2], 0}, {2.5, 0}], 
          NCache[{3, 
            Rational[4861, 1792]}, {3, 2.712611607142857}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[{3, 0}, 
          NCache[{
            Rational[7, 2], 
            Rational[1987, 768]}, {3.5, 2.5872395833333335`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[
          NCache[{
            Rational[7, 2], 0}, {3.5, 0}], 
          NCache[{4, 
            Rational[21309, 8960]}, {4, 2.378236607142857}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[{4, 0}, 
          NCache[{
            Rational[9, 2], 
            Rational[19247, 8960]}, {4.5, 2.1481026785714286`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[
          NCache[{
            Rational[9, 2], 0}, {4.5, 0}], 
          NCache[{5, 
            Rational[52667, 26880]}, {5, 1.9593377976190476`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[{5, 0}, 
          NCache[{
            Rational[11, 2], 
            Rational[3359, 1792]}, {5.5, 1.8744419642857142`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[
          NCache[{
            Rational[11, 2], 0}, {5.5, 0}], 
          NCache[{6, 
            Rational[3505, 1792]}, {6, 1.9559151785714286`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[{6, 0}, 
          NCache[{
            Rational[13, 2], 
            Rational[60917, 26880]}, {6.5, 2.2662574404761906`}]]}, {
         RGBColor[1, 0.5, 0.5], 
         EdgeForm[
          Thickness[0.001]], 
         Opacity[0.4], 
         RectangleBox[
          NCache[{
            Rational[13, 2], 0}, {6.5, 0}], 
          NCache[{7, 
            Rational[3671, 1280]}, {7, 2.86796875}]]}},
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->300,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-3., 10.}, {-1., 5.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{{-3, 
          FormBox[
           RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}, {5, 
          FormBox["5", TraditionalForm]}, {6, 
          FormBox["6", TraditionalForm]}, {7, 
          FormBox["7", TraditionalForm]}, {8, 
          FormBox["8", TraditionalForm]}, {9, 
          FormBox["9", TraditionalForm]}, {10, 
          FormBox["10", TraditionalForm]}}, {{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}, {5, 
          FormBox["5", TraditionalForm]}}}]},
    {"\<\"Fig. 1. Geometric meaning of the Riemann sum.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Background->None,
 CellID->1801049108,ExpressionUUID->"32abfaad-3bc9-457c-8036-8280048b875d"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Complex Integration", "Subsection",
 CellID->101008060,ExpressionUUID->"c5fbde01-7a2f-4a02-86aa-ebc73cad12c0"],

Cell[TextData[{
 "In complex integration, the integration path or ",
 StyleBox["contour",
  FontSlant->"Italic"],
 " is a curve in the complex plane. There are three equivalent definitions of \
a complex integral."
}], "Text",
 CellID->657921177,ExpressionUUID->"25ba6eca-e45d-4550-bb0e-7138f5f08205"],

Cell[TextData[{
 "This discussion assumes that all paths used for complex integration are \
smooth curves, i.e. parametrizable as continuous functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "(", "t", ")"}], ":", 
     RowBox[{"[", 
      RowBox[{"r", ",", "s"}], "]"}]}], "->", "\[DoubleStruckCapitalC]"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "fbf0b9c3-645b-430e-b1ee-e35d6368965f"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}]}], "!=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"475b8073-89a2-40a3-a3a9-fa7cf090575f"],
 ". Piecewise smooth curves are also admissible as contours."
}], "Text",
 CellID->498985828,ExpressionUUID->"1f376b57-d13f-40d2-96ad-523334c88794"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["First Definition of Complex Integral",
 FontWeight->"Bold"]], "Subsubsection",
 CellID->103174132,ExpressionUUID->"2dbaefa1-b710-43fd-b17b-980f118406f2"],

Cell["\<\
Dividing the path into many small segments, the integral is defined as the \
limit, for infinitesimally small subdivisions of the path, of the following \
sum, in analogy with the real case reviewed previously:\
\>", "Text",
 CellID->107626032,ExpressionUUID->"2947efe9-6c10-4405-afde-6e8377814506"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"n", "->", "\[Infinity]"}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{
      RowBox[{"f", "(", 
       SubscriptBox["z", "k"], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["z", 
          RowBox[{"k", "+", "1"}]], "-", 
         SubscriptBox["z", "k"]}], ")"}], "."}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->11009606,ExpressionUUID->"e7bc9d8e-ca73-4db7-8a36-6a5be519fec0"],

Cell[TextData[{
 "The path ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "28286ff8-f9b6-4800-a0be-3831d775f81b"],
 " is described by the continuous function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", ":", 
     RowBox[{"[", 
      RowBox[{"r", ",", "s"}], "]"}]}], "\[Rule]", 
    TemplateBox[{},
     "Complexes"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c170f902-af04-4fca-b85a-d14177c7b080"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "r", ")"}], "=", "a"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"93345552-e80f-4125-a3cd-297e5e1349ea"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "s", ")"}], "=", "b"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cb7f370f-8b61-44f9-86c2-f0f39dd1c314"],
 "."
}], "Text",
 CellID->357829839,ExpressionUUID->"9b2f0438-e93a-4f64-98e5-0eb55fd8cc8a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "a0", ",", "b0", ",", "pts", ",", "curve", ",", "pol", ",", "\[Theta]", ",",
     "Subdivisions", ",", "t", ",", "i", ",", "z"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "pol", ",", "\[Theta]", ",", "curve", ",", "x", ",", "t", ",", "a0", ",",
          "b0", ",", "pts"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"pol", "=", 
         RowBox[{
          RowBox[{
           FractionBox["164", "153"], "-", 
           FractionBox[
            RowBox[{"181", " ", "x"}], "164"], "-", 
           FractionBox[
            SuperscriptBox["x", "2"], "109"], "+", 
           FractionBox[
            RowBox[{"4", " ", 
             SuperscriptBox["x", "3"]}], "77"]}], "/.", 
          RowBox[{"x", "->", "t"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"\[Theta]", "=", 
         RowBox[{"Pi", "/", "6"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"curve", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"t", " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
            RowBox[{"pol", " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"t", " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "+", 
            RowBox[{"pol", " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}]}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"a0", "=", 
         RowBox[{"(", 
          RowBox[{"curve", "/.", 
           RowBox[{"t", "->", 
            RowBox[{"-", "5"}]}]}], ")"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"b0", "=", 
         RowBox[{"(", 
          RowBox[{"curve", "/.", 
           RowBox[{"t", "->", 
            RowBox[{"45", "/", "10"}]}]}], ")"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
          RowBox[{"Subdivisions", "=", "5"}], ";"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"pts", "=", 
         RowBox[{"Thread", "[", 
          RowBox[{"curve", "/.", 
           RowBox[{"t", "->", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], "+", 
               RowBox[{
                RowBox[{"9.5", "/", "Subdivisions"}], "*", "i"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "0", ",", "Subdivisions"}], "}"}]}], 
             "]"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ParametricPlot", "[", 
         RowBox[{"curve", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            RowBox[{"-", "5.5"}], ",", "5"}], "}"}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
          RowBox[{"TicksStyle", "->", 
           RowBox[{"Directive", "[", "12", "]"}]}], ",", 
          RowBox[{"Epilog", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"curve", "/.", 
                   RowBox[{"t", "->", 
                    RowBox[{"-", "0.8"}]}]}], ",", 
                  RowBox[{"curve", "/.", 
                   RowBox[{"t", "->", 
                    RowBox[{"-", "0.75"}]}]}]}], "}"}], "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Pink", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"curve", "/.", 
                 RowBox[{"t", "->", 
                  RowBox[{"-", "5"}]}]}], "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"a", ",", "12"}], "]"}], ",", "a0", ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Pink", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"curve", "/.", 
                 RowBox[{"t", "->", "4.5"}]}], "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"b", ",", "12"}], "]"}], ",", "b0", ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "]"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Pink", ",", 
               RowBox[{"Line", "[", "pts", "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"C", ",", "12"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}]}]}], 
         "]"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
     
     RowBox[{"{", 
      RowBox[{"Subdivisions", ",", "4", ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"\"\<Fig. 2. An integration contour from \>\"", "<>", 
    RowBox[{"ToString", "[", 
     RowBox[{"a", ",", "TraditionalForm"}], "]"}], "<>", "\"\< to \>\"", "<>", 
    RowBox[{"ToString", "[", 
     RowBox[{"b", ",", "TraditionalForm"}], "]"}], 
    "<>", "\"\< in the complex plane.\>\""}]}], "]"}]}], "Input",
 CellID->297254086,ExpressionUUID->"a944421b-da17-4f3e-8eed-a1c4ae87a6c4"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`Subdivisions$$ = 4, Typeset`show$$ = True,
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`Subdivisions$$], 4, 10, 1, ControlType -> 
          Manipulator}}, 
       Typeset`size$$ = {240., {107.13997395833333`, 114.37239583333333`}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       False}, 
      DynamicBox[
       Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`Subdivisions$$ = 4}, 
        "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Module[{$CellContext`pol$, $CellContext`\[Theta]$, \
$CellContext`curve$, $CellContext`x$, $CellContext`t$, $CellContext`a0$, \
$CellContext`b0$, $CellContext`pts$}, $CellContext`pol$ = 
           ReplaceAll[
            164/153 - 181 ($CellContext`x$/164) - $CellContext`x$^2/109 + 
             4 ($CellContext`x$^3/
               77), $CellContext`x$ -> $CellContext`t$]; \
$CellContext`\[Theta]$ = 
           Pi/6; $CellContext`curve$ = {$CellContext`t$ 
              Cos[$CellContext`\[Theta]$] - $CellContext`pol$ 
             Sin[$CellContext`\[Theta]$], $CellContext`t$ 
              Sin[$CellContext`\[Theta]$] + $CellContext`pol$ 
              Cos[$CellContext`\[Theta]$]}; $CellContext`a0$ = 
           ReplaceAll[$CellContext`curve$, $CellContext`t$ -> -5]; \
$CellContext`b0$ = 
           ReplaceAll[$CellContext`curve$, $CellContext`t$ -> 
             45/10]; $CellContext`pts$ = Thread[
             
             ReplaceAll[$CellContext`curve$, $CellContext`t$ -> 
              Table[-5 + (
                  9.5/$CellContext`Subdivisions$$) $CellContext`i, \
{$CellContext`i, 0, $CellContext`Subdivisions$$}]]]; 
          ParametricPlot[$CellContext`curve$, {$CellContext`t$, -5.5, 5}, 
            PlotRange -> {{-6, 6}, {-6, 6}}, AxesLabel -> {
              Style[
               Re[$CellContext`z], 12], 
              Style[
               Im[$CellContext`z], 12]}, TicksStyle -> Directive[12], 
            Epilog -> {{
               RGBColor[0.368417, 0.506779, 0.709798], 
               Arrowheads[0.07], 
               Arrow[{
                 ReplaceAll[$CellContext`curve$, $CellContext`t$ -> -0.8], 
                 
                 ReplaceAll[$CellContext`curve$, $CellContext`t$ -> \
-0.75]}]}, {
               PointSize[Medium], Pink, 
               Point[
                ReplaceAll[$CellContext`curve$, $CellContext`t$ -> -5]]}, 
              Text[
               Style[$CellContext`a, 12], $CellContext`a0$, {2, 0}], {
               PointSize[Medium], Pink, 
               Point[
                ReplaceAll[$CellContext`curve$, $CellContext`t$ -> 4.5]]}, 
              Text[
               Style[$CellContext`b, 12], $CellContext`b0$, {-2, 0}], {
               Thickness[0.005], Pink, 
               Line[$CellContext`pts$]}, 
              Text[
               Style[C, 12], {-2, 2}, {0, 0}]}]], 
        "Specifications" :> {{$CellContext`Subdivisions$$, 4, 10, 1}}, 
        "Options" :> {}, "DefaultOptions" :> {}], 
       ImageSizeCache -> {
        300.46642578125, {155.13997395833331`, 162.37239583333331`}}, 
       SingleEvaluation -> True], Deinitialization :> None, 
      DynamicModuleValues :> {}, 
      Initialization :> ({$CellContext`x[Blank[] Removed["t"], 
           Pattern[$CellContext`\[Tau], 
            Blank[]], 
           Pattern[$CellContext`e, 
            Blank[]]] := Cos[
           $CellContext`\[CapitalPhi][
           Removed["t"] + $CellContext`\[Tau], $CellContext`e]], \
$CellContext`\[CapitalPhi][Blank[] Removed["t"], 
           Pattern[$CellContext`e, 
            Blank[]]] := ReplaceAll[$CellContext`\[Phi], 
           FindRoot[
           Removed["t"] == $CellContext`\[Phi] + $CellContext`e 
              Sin[$CellContext`\[Phi]], {$CellContext`\[Phi], Removed["t"]/(
             1 - $CellContext`e)}]]}; Typeset`initDone$$ = True), 
      SynchronousInitialization -> True, 
      UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
      UnsavedVariables :> {Typeset`initDone$$}, 
      UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> True,
      StripOnInput -> False], 
    Manipulate`InterpretManipulate[1]], 
   "\"Fig. 2. An integration contour from \\!\\(\\*FormBox[\\\"a\\\", \
TraditionalForm]\\) to \\!\\(\\*FormBox[\\\"b\\\", TraditionalForm]\\) in the \
complex plane.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    BaseStyle -> {FontFamily -> "Source Sans Code"}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->120369159,ExpressionUUID->"669e0176-da14-41f3-98f6-328af33e4156"]
}, {2}]],

Cell[TextData[{
 "For example, let\[CloseCurlyQuote]s try integrating the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", "z"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"50ab1870-0fc6-4359-9e89-6cc3a452bccc"],
 " over the path depicted in Fig. 2."
}], "Text",
 CellID->590193366,ExpressionUUID->"eb323f32-655e-4620-9594-9657e6266172"],

Cell["\<\
Approximating the integral by dividing the path into five segments, which \
have endpoints:\
\>", "Text",
 CellID->188435328,ExpressionUUID->"a0bb998e-160f-4640-8292-0c8dad26dcee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"-4.264\"\>",
        ShowStringCharacters->False],
       -4.2637889269680915`,
       AutoDelete->True], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"2.615\"\>",
         ShowStringCharacters->False],
        2.6149009457416788`,
        AutoDelete->True], " ", "\[ImaginaryI]"}]}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["4", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["648", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[-4.11342241925783 + 0.9246566231474502 I, -2.1858846974405735` + 
       1.3860633554543964` I, 0.44988917354861213` + 0.6207690936386319 I, 
       2.724964128774662 + 0.48022368015962524` I],
      SelectWithContents->True,
      Selectable->False], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3.57\"\>",
        ShowStringCharacters->False],
       3.57040510330251,
       AutoDelete->True], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"2.816\"\>",
         ShowStringCharacters->False],
        2.815876957476846,
        AutoDelete->True], " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellID->76110827,ExpressionUUID->"68778f1d-b9fe-4c4a-8075-99db24e525fe"],

Cell["One can use Eq. (2) and obtain the approximation:", "Text",
 CellID->45333929,ExpressionUUID->"39c23042-6632-4133-88fb-ef582c64a461"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"pts", "[", 
     RowBox[{"[", "k", "]"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"pts", "[", 
       RowBox[{"[", 
        RowBox[{"k", "+", "1"}], "]"}], "]"}], "-", 
      RowBox[{"pts", "[", 
       RowBox[{"[", "k", "]"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellID->755312259,ExpressionUUID->"91a8252c-6f40-4e10-8178-47983400eabf"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.1487715676311554`"}], "-", 
  RowBox[{"2.1549370441641464`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellID->29907437,ExpressionUUID->"d54fb3dd-df93-441a-8376-880eb5ceabc0"]
}, Open  ]],

Cell["\<\
Compare this approximation to the one obtained by using 15 subdivisions, with \
endpoints:\
\>", "Text",
 CellID->608037992,ExpressionUUID->"3f4ffebf-5b20-4543-ae47-5c9d0ba8444d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"-4.264\"\>",
        ShowStringCharacters->False],
       -4.2637889269680915`,
       AutoDelete->True], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"2.615\"\>",
         ShowStringCharacters->False],
        2.6149009457416788`,
        AutoDelete->True], " ", "\[ImaginaryI]"}]}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["14", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["2240", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[-4.477113871949095 - 0.9787446358460814 
       I, -4.4137949735156115` + 0.17825048165449964` I, -4.11342241925783 + 
       0.9246566231474496 I, -3.6155863967659383` + 
       1.3290460050201571` I, -2.9598770936301237` + 
       1.4599908436600109` I, -2.1858846974405743` + 
       1.386063355454397 I, -1.3331993957874757` + 
       1.1758357567907036` I, -0.4414113762610187 + 0.8978802640563197 I, 
       0.4498891735486109 + 0.6207690936386322 I, 1.3011120660512268` + 
       0.4130744619250284 I, 2.0726671136566397` + 0.34336858530289693` I, 
       2.724964128774661 + 0.48022368015962524` I, 3.218412923815105 + 
       0.8922119628826003 I, 3.5134233111877853` + 1.6479056498592124` I],
      SelectWithContents->True,
      Selectable->False], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3.57\"\>",
        ShowStringCharacters->False],
       3.57040510330251,
       AutoDelete->True], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"2.816\"\>",
         ShowStringCharacters->False],
        2.815876957476846,
        AutoDelete->True], " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellID->149717011,ExpressionUUID->"82729676-9463-46a7-89fc-0b18d3b3a127"],

Cell["Obtaining for the integral the approximation:", "Text",
 CellID->274271816,ExpressionUUID->"78c40a8a-831b-4412-aa4f-37e26cd9e3ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"pts", "[", 
     RowBox[{"[", "k", "]"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"pts", "[", 
       RowBox[{"[", 
        RowBox[{"k", "+", "1"}], "]"}], "]"}], "-", 
      RowBox[{"pts", "[", 
       RowBox[{"[", "k", "]"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellID->362936641,ExpressionUUID->"90800376-4638-4f12-a442-1523c5a78d84"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2.603614093542141`"}], "-", 
  RowBox[{"0.9513077263650134`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellID->519880666,ExpressionUUID->"f9fb21d9-aa46-4163-bc82-d9697ea3f7dc"]
}, Open  ]],

Cell["With 50 subdivisions:", "Text",
 CellID->543967574,ExpressionUUID->"a5e2c5a0-0e44-47e0-ab76-df4bcf5ddca6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"-4.264\"\>",
        ShowStringCharacters->False],
       -4.2637889269680915`,
       AutoDelete->True], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"2.615\"\>",
         ShowStringCharacters->False],
        2.6149009457416788`,
        AutoDelete->True], " ", "\[ImaginaryI]"}]}], ",", 
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"Expression", "SequenceIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["Sequence", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["49", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["7920", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      Sequence[-4.359189630182531 - 2.069662080696471 I, -4.427198205671482 - 
       1.5718677725992243` I, -4.468883588499885 - 1.1196665716074712` 
       I, -4.485314713732671 - 0.7112070278787597 I, -4.477560516434777 - 
       0.3446376915706246 I, -4.446689931671138 - 0.018107112840608952` 
       I, -4.393771894506688 + 0.2702361581537467 I, -4.319875340006364 + 
       0.522243571254901 I, -4.2260692032351 + 
       0.7397665763053167 I, -4.11342241925783 + 
       0.9246566231474496 I, -3.9830039231394907` + 
       1.0787651616237608` I, -3.8358826499450163` + 
       1.2039436415767106` I, -3.6731275347393426` + 
       1.3020435128487573` I, -3.495807512587403 + 
       1.3749162252823601` I, -3.3049915185541345` + 
       1.424413228719979 I, -3.101748487704471 + 
       1.4523859730040733` I, -2.8871473551033486` + 
       1.4606859079771033` I, -2.6622570558157013` + 
       1.4511644834815272` I, -2.428146524906465 + 
       1.4256731493598054` I, -2.1858846974405743` + 
       1.386063355454397 I, -1.936540508482963 + 
       1.3341865516077607` I, -1.681182893098569 + 
       1.2718941876623577` I, -1.420880786352325 + 
       1.2010377134606458` I, -1.1567031233091667` + 
       1.1234685788450856` I, -0.8897188390340305 + 
       1.0410382336581363` I, -0.6209968685918491 + 
       0.9555981277422568 I, -0.3516061470475601 + 
       0.8689997109399077 I, -0.08261560946609603 + 0.7830944330935471 I, 
       0.18490580908760557` + 0.6997337440456357 I, 0.44988917354861213` + 
       0.6207690936386319 I, 0.7112655488519861 + 0.548051931714996 I, 
       0.967965999932795 + 0.4834337081171869 I, 1.2189215917261023` + 
       0.4287658726876643 I, 1.4630633891669715` + 0.3858998752688881 I, 
       1.6993224571904706` + 0.356687165703317 I, 1.9266298607316619` + 
       0.3429791938334109 I, 2.1439166647256123` + 0.3466274095016294 I, 
       2.3501139341073856` + 0.3694832625504312 I, 2.544152733812047 + 
       0.413398202822277 I, 2.724964128774661 + 0.48022368015962524` I, 
       2.891479183930294 + 0.5718111444049362 I, 3.0426289642140096` + 
       0.6900120454006687 I, 3.1773445345608726` + 0.8366778329892814 I, 
       3.2945569599059485` + 1.0136599570132352` I, 3.3931973051843034` + 
       1.2228098673149908` I, 3.4721966353309988` + 1.4659790137370048` I, 
       3.5304860152811033` + 1.7450188461217364` I, 3.56699650996968 + 
       2.0617808143116507` I, 3.5806591843317936` + 2.4181163681492 I],
      SelectWithContents->True,
      Selectable->False], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3.57\"\>",
        ShowStringCharacters->False],
       3.57040510330251,
       AutoDelete->True], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"2.816\"\>",
         ShowStringCharacters->False],
        2.815876957476846,
        AutoDelete->True], " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellID->269915670,ExpressionUUID->"349d77dd-d9ad-4e66-8900-27309676c67d"],

Cell["The result is:", "Text",
 CellID->864088875,ExpressionUUID->"b45bf3dd-80f0-4e81-870a-25ef021de5d0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"pts", "[", 
     RowBox[{"[", "k", "]"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"pts", "[", 
       RowBox[{"[", 
        RowBox[{"k", "+", "1"}], "]"}], "]"}], "-", 
      RowBox[{"pts", "[", 
       RowBox[{"[", "k", "]"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellID->7091304,ExpressionUUID->"e9d9be3c-d6eb-465c-a8cc-527fea4e692e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.0542129041961674`"}], "-", 
  RowBox[{"1.0347638715059237`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellID->131976548,ExpressionUUID->"87f4851b-0c05-40c0-a361-c4aa216aa81c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Second Definition of Complex Integral",
 FontWeight->"Bold"]], "Subsubsection",
 CellID->124855073,ExpressionUUID->"dc49d41c-01c5-4701-8f9a-01e8de12170d"],

Cell[TextData[{
 "If the path ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "51694f04-f7ce-4d6b-b6b5-8e1dc8a40d5f"],
 " is parametrized by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "(", "t", ")"}], ":", 
     RowBox[{"[", 
      RowBox[{"r", ",", "s"}], "]"}]}], "\[Rule]", 
    TemplateBox[{},
     "Complexes"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2cf24400-30f8-4041-91bf-d15b2c63c375"],
 " and ",
 Cell[BoxData[
  FormBox["\[Rho]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f31255ff-0417-4b04-8ac2-e6d3ca05274d"],
 " has continuous derivatives, an equivalent definition of the complex \
integral is"
}], "Text",
 CellID->343173542,ExpressionUUID->"4595d5b2-bfff-4fb1-912b-8daeb5c21857"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{"f", 
     RowBox[{"(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Integral]", "r"], "s"], 
    RowBox[{"f", 
     RowBox[{"(", 
      RowBox[{"\[Rho]", 
       RowBox[{"(", "t", ")"}]}], ")"}], 
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}], 
     RowBox[{
      RowBox[{"\[DifferentialD]", "t"}], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->399295,ExpressionUUID->"67c8028c-d101-4e93-8885-06fdf0f0d4bd"],

Cell["\<\
As learned from multivariable calculus, this definition is equivalent to the \
first definition.\
\>", "Text",
 CellID->277792137,ExpressionUUID->"44a4eb24-a802-4b54-a9b7-478a89c7c662"],

Cell[TextData[{
 "For example, let\[CloseCurlyQuote]s again compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", "z"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8e8c1a8c-c6cd-492a-93f1-4742ae11d4d8"],
 " over the contour in Fig. 2. In Wolfram Language, you can describe the \
curve of Fig. 2 as a ",
 ButtonBox["ParametricRegion",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->8558990,ExpressionUUID->"a87e9ae3-d260-43eb-b729-10a0c518743b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"curve", "=", 
   RowBox[{"ParametricRegion", "[", 
    RowBox[{
     InterpretationBox[
      DynamicModuleBox[{Typeset`open = False}, 
       TemplateBox[{"List", "ListIcon", 
         GridBox[{{
            RowBox[{
              TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["List", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
              TagBox["2", "IconizedItem"]}]}, {
            RowBox[{
              TagBox["\"Byte count: \"", "IconizedLabel"], 
              "\[InvisibleSpace]", 
              TagBox["2760", "IconizedItem"]}]}}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
          "Column", 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
         Dynamic[Typeset`open]},
        "IconizedObject"]],
      {-(82/153) + (181/328 + Sqrt[3]/2) $CellContext`t + $CellContext`t^2/
        218 - 2 ($CellContext`t^3/77), (1/2) ($CellContext`t + 
        Sqrt[3] (164/153 - 181 ($CellContext`t/164) - $CellContext`t^2/109 + 
          4 ($CellContext`t^3/77)))},
      SelectWithContents->True,
      Selectable->False], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "5"}], ",", 
        RowBox[{"45", "/", "10"}]}], "}"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellID->309390273,ExpressionUUID->"528acbaf-215b-4b28-844c-642da2b92962"],

Cell[TextData[{
 "Then you can use ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 " to compute the integral exactly:"
}], "Text",
 CellID->384997391,ExpressionUUID->"753c1397-f46d-49f1-a84d-349acd2b2925"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{"z", ",", 
    RowBox[{"z", "\[Element]", "curve"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellID->159448145,ExpressionUUID->"aa04e828-c00b-4ec8-96b8-fd1e1c026ab5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1918120585", "1684777248"]}], "-", 
    FractionBox[
     RowBox[{"854615450033083", " ", "\[ImaginaryI]"}], "662575717875456"]}], 
   ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SqrtBox["3"]}], ")"}]}]], "Output",
 CellID->767179684,ExpressionUUID->"b5353b61-20ad-48ff-ba0f-47a0cb6e5e08"]
}, Open  ]],

Cell["Numerically, this is:", "Text",
 CellID->270276300,ExpressionUUID->"9ea53311-c009-489c-9181-8daa44b4b892"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellID->1734267,ExpressionUUID->"ef041947-edaa-479a-ac6f-e67ddd620965"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.261779747827726`"}], "-", 
  RowBox[{"1.095564238324482`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellID->86234154,ExpressionUUID->"2cbdce9e-54b2-4665-9b88-96bac84dd07d"]
}, Open  ]],

Cell["\<\
You can compare this with the approximations obtained previously.\
\>", "Text",
 CellID->718103005,ExpressionUUID->"b54af1e8-c070-4e15-95d7-b8d864deae70"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Third Definition of Complex Integral",
 FontWeight->"Bold"]], "Subsubsection",
 CellID->528080467,ExpressionUUID->"6f0f6eac-91da-44a0-a01c-2eea9a2867bf"],

Cell["\<\
The third equivalent definition reminds us of the line integral of a vector \
field in two variables:\
\>", "Text",
 CellID->86437159,ExpressionUUID->"bad6115c-b74f-4457-b637-e7c8b1dcad34"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u", "+", 
        RowBox[{"\[ImaginaryI]", " ", "v"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[DifferentialD]", "x"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"\[DifferentialD]", "y"}]}]}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{"u", " ", 
       RowBox[{"\[DifferentialD]", "x"}]}]}], "-", 
     RowBox[{"v", 
      RowBox[{"\[DifferentialD]", "y"}]}], "+", 
     RowBox[{"\[ImaginaryI]", 
      RowBox[{
       SubscriptBox["\[Integral]", "C"], 
       RowBox[{"v", " ", 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
     RowBox[{"u", " ", 
      RowBox[{
       RowBox[{"\[DifferentialD]", "y"}], "."}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->285803505,ExpressionUUID->"98816ace-66c3-4b0e-ac2d-aa77594788c1"],

Cell["\<\
Notice that the two line integrals involve purely real functions.\
\>", "Text",
 CellID->4712656,ExpressionUUID->"8bcae073-60b8-4f40-baae-851423854a67"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s again compute the contour integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", "z"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cce591cd-5f5f-4db1-b033-117dba9acd65"],
 " using this third definition, for the contour used in the examples in the \
previous sections: since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "x"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"6c1f9128-49e2-47d7-8a3a-d06d9018fb0d"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"v", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "y"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b9f28b17-e6cb-407f-adf4-2a1f5d12e52b"],
 ":"
}], "Text",
 CellID->427412820,ExpressionUUID->"9983bb52-da6e-411e-83e6-a834721a7b27"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"LineIntegrate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "y"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "curve"}]}], "]"}], "+", 
   
   RowBox[{"I", "*", 
    RowBox[{"LineIntegrate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"y", ",", "x"}], "}"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "curve"}]}], "]"}]}]}], 
  "//", "Simplify"}]], "Input",
 CellID->296231045,ExpressionUUID->"8bdeec39-e815-496a-8bb4-9d8454594300"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1918120585", "1684777248"]}], "-", 
    FractionBox[
     RowBox[{"854615450033083", " ", "\[ImaginaryI]"}], "662575717875456"]}], 
   ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SqrtBox["3"]}], ")"}]}]], "Output",
 CellID->474025373,ExpressionUUID->"71bfb203-9c97-46ff-a9a4-3d3efe34c451"]
}, Open  ]],

Cell["which agrees with the result in the previous section:", "Text",
 CellID->134135276,ExpressionUUID->"2db34ff6-6a88-4484-bab1-aaa6e4cbc2d5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellID->212615684,ExpressionUUID->"148dd377-e94c-4b8a-b452-d5e37674ec86"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.261779747827726`"}], "-", 
  RowBox[{"1.095564238324482`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellID->225867510,ExpressionUUID->"f0bd1c78-57e4-4f73-8b08-73a9b4b89f60"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties of Complex Integration", "Subsection",
 CellID->321595196,ExpressionUUID->"37c3b783-d21e-4b51-a5c9-790f163c930d"],

Cell["The complex integral has these important properties:", "Text",
 CellID->409937423,ExpressionUUID->"eeb9f0c7-3bd6-47d8-b544-8c782a57e0ad"],

Cell[TextData[{
 "The complex integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]],ExpressionUUID->
  "f014945c-d258-4615-95ee-a12ce33f1f6a"],
 " does not depend on the parametrization of the path ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]],ExpressionUUID->
  "7ea38fd2-62b6-42ee-9d3d-7faa323d0a8a"],
 ", except for the direction: if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}], TraditionalForm]],ExpressionUUID->
  "bd97f309-b26d-42c1-955f-4bb4b0c863e1"],
 " is the path traversed in the opposite direction, then"
}], "Item",
 CellID->303977933,ExpressionUUID->"e7ec1e99-16e8-4db5-a6fb-675eb0113a09"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{"f", 
     RowBox[{"(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{"-", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{"-", "C"}]], 
     RowBox[{"f", 
      RowBox[{"(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->971858,ExpressionUUID->"d4a57a06-cef4-4ca6-bf97-ef2eec877f29"],

Cell[TextData[{
 "If the path ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]],ExpressionUUID->
  "d8c17c92-87d9-41fd-a928-300bbf618b72"],
 " starts where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]],ExpressionUUID->
  "d86a07d8-cf24-44c4-80fe-74ab43d46f58"],
 " ends, then"
}], "Item",
 CellID->330242352,ExpressionUUID->"0d16c035-14ec-4d16-9769-c2520b702351"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "1"]], 
     RowBox[{"f", 
      RowBox[{"(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "2"]], 
     RowBox[{"f", 
      RowBox[{"(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      SubscriptBox["C", "1"], "\[Union]", 
      SubscriptBox["C", "2"]}]], 
    RowBox[{"f", 
     RowBox[{"(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->128456185,ExpressionUUID->"1c49cdf4-becb-40bd-84f1-e48f75a7135f"],

Cell[CellGroupData[{

Cell[TextData[{
 "where the path ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "1"], "\[Union]", 
    SubscriptBox["C", "2"]}], TraditionalForm]],ExpressionUUID->
  "cb003305-59bb-4057-a68d-f93fe619a627"],
 " is (obviously) the path that traverses ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]],ExpressionUUID->
  "38d63b92-69e5-4ec7-9c1f-5c8300f1c05c"],
 " and continues with ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]],ExpressionUUID->
  "8eb7c00b-22fa-40bf-831a-a9461afb52b5"],
 "."
}], "ItemParagraph",
 CellID->371530895,ExpressionUUID->"4efdf6dd-5361-428c-a10b-893abc434c5a"],

Cell["The complex integral is bounded by:", "Item",
 CellID->287643639,ExpressionUUID->"434ec2d7-5049-4c07-82f6-b85e1822a011"]
}, Open  ]],

Cell[BoxData[
 FormBox[Cell[TextData[Cell[BoxData[
   FormBox[
    RowBox[{"|", 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{"f", 
       RowBox[{"(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}]}], "|", 
     RowBox[{"<=", "M"}], "|", "C", "|"}], TraditionalForm]],ExpressionUUID->
   "19968d7f-e67f-45de-b1c6-adc6a66dcacc"]],ExpressionUUID->
   "90651a31-6e07-4efe-8720-b7e1d66ee905"], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->196560669,ExpressionUUID->"263fb596-96ed-49f0-9fdc-4b81afbd2d16"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "C", "|"}], TraditionalForm]],ExpressionUUID->
  "cba519c5-822b-470c-8e06-c034104a9a9a"],
 " is the length of ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]],ExpressionUUID->
  "ce269ea3-9136-4414-86bf-5f5123de04b2"],
 " and ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]],ExpressionUUID->
  "9f5b92a3-21f7-4453-9d95-39d6435e1292"],
 " is an upper bound for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"f", "(", "z", ")"}], "|"}], TraditionalForm]],ExpressionUUID->
  "e882ddcf-eeab-41ea-be1c-dfe14ae267e3"],
 " on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]],ExpressionUUID->
  "cf15dd99-ee2a-42a8-97b2-aada7e5d0626"],
 "."
}], "ItemParagraph",
 CellID->1015371295,ExpressionUUID->"7a9eb0ad-0f9c-4e2a-9082-f49b1d3ae9e3"],

Cell[TextData[{
 "If the integral is over a closed contour, you often see the symbol ",
 Cell[BoxData[
  FormBox["\[ContourIntegral]", TraditionalForm]], "InlineMath",
  ExpressionUUID->"812133fa-9d17-47f0-be85-e4bdce2560b4"],
 " being used."
}], "Text",
 CellID->355727786,ExpressionUUID->"d7bad65f-a954-43fb-af2a-50b98467060f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection",
 CellID->251702679,ExpressionUUID->"6bb5d8d1-6750-4817-b044-1539d7afc714"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->782981345,ExpressionUUID->"ff5f0989-1c0f-4047-abbe-4bb6e5db09f9"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{"z", " ", 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dffdb5ba-87e0-4b77-887c-efc7664f0914"],
 ", where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b65154af-8b29-4904-bae1-b49ef386c51b"],
 " is a circle of radius 1 around the origin in the complex plane, traversed \
counterclockwise."
}], "SolvedExampleNote",
 CellID->264510557,ExpressionUUID->"2e2d6388-a585-4152-a11a-ea2699721928"],

Cell[TextData[{
 "The circle can be parametrized as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    SuperscriptBox["e", 
     RowBox[{"\[ImaginaryI]", " ", "t"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d874dd66-efff-4590-8ad4-18341dc91ec9"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8d86fe9c-40d4-442d-84cf-fb6276bc4e17"],
 ". Therefore, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"\[Rho]", "(", "t", ")"}], ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "t"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ab56ad38-6fbb-490a-a01d-1dd9e98405ec"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"dfd704aa-4a13-4aa8-a2d8-cd81a41d2b11"],
 ". So the integral is"
}], "SolvedExampleNote",
 CellID->201170782,ExpressionUUID->"bfa5b3da-1d35-4349-b6e9-f537de9059b4"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"3766c74b-88b7-48f9-bcdd-af11007d7d3a"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"\[VeryThinSpace]", "0"}], 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"\[VeryThinSpace]", "0"}], 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "\[ImaginaryI]", " ", "t"}]], 
        RowBox[{"\[DifferentialD]", "t"}]}]}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[ImaginaryI]", "\[CenterDot]", 
         FractionBox["1", 
          RowBox[{"2", "\[ImaginaryI]"}]]}], 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", "\[ImaginaryI]", " ", "t"}]]}], 
       SubsuperscriptBox["|", "0", 
        RowBox[{"2", "\[Pi]"}]]}], "=", "0."}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b8f706f7-0628-4903-9b19-602707ac1bbd"]
}], "SolvedExampleNote",
 CellID->938546473,ExpressionUUID->"ebc9d371-9316-4ab4-b3f9-26bec693136f"],

Cell[TextData[{
 "In Wolfram Language, you can compute complex contour integrals using the \
command ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->477632082,ExpressionUUID->"51f3cbed-1ba5-4fc8-8714-45bd5a81b946"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{"z", ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->130584303,ExpressionUUID->"47d75263-30d4-4554-a1b4-6a86c749f69a"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->8847827,ExpressionUUID->"3b1ae002-2f5b-44f7-99b3-140629d77772"]
}, Open  ]],

Cell["Plot the function and the contour of integration:", "SolvedExampleNote",
 CellID->293291947,ExpressionUUID->"d92bbb1f-bfe3-4dd6-8440-780c6a8552e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{"z", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1040", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[]]}, ImageSize -> Small, FrameLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, FrameStyle -> Directive[12]],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->215134320,ExpressionUUID->"5427a16d-34b5-4a46-ac05-fa40a9d54b94"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GDGkyCdUXEalwxDJ9kVNFinWAwKWPt1BlXDEarxTCjIDgX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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx03FesJHd+6HfBfvGjAb/65V77wb7WwzVsyLJly5IgQVrpKnEvV4G7q2VY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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[12],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->868702115,ExpressionUUID->"cbd84863-51a4-4bb0-b333-39045b71026d"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->363881016,ExpressionUUID->"0df6a0e8-f0d7-4af7-b7a0-fd29eb3f5a1e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellTags->"Example112",
 CellID->430700739,ExpressionUUID->"126c3765-98a0-4c3d-92b8-b84253fec9cf"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "a"}], ")"}], "n"], " ", 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"263e5308-85f1-4815-9e7c-183530f54086"],
 " for integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a449b2d0-6e8c-49b2-8e7b-f19ef970ae46"],
 ", where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2467e833-5011-4f35-a1de-807177099ee4"],
 " is a circle of radius 1 around ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a48fd27d-a639-449b-8450-1866767c0010"],
 " in the complex plane, traversed anticlockwise."
}], "SolvedExampleNote",
 CellID->177274235,ExpressionUUID->"43bbfb4f-b057-42db-99e3-9a203e882824"],

Cell[TextData[{
 "The parametrization of the circle is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"a", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f6c8f0cb-7f04-431f-b894-690b063c165c"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"48811782-d953-4ba3-a93c-b347ac4901a7"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c74aea78-4545-43fc-bf89-25f058af8c99"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"\[Rho]", "(", "t", ")"}], ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"n", " ", "\[ImaginaryI]", " ", "t"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7767b59c-6689-4875-bb50-0ac91832fb0d"],
 ". So the integral is"
}], "SolvedExampleNote",
 CellID->81990820,ExpressionUUID->"a050b28c-d157-4e99-bd3e-5502c266a2aa"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"4e3d262a-9943-4c45-b767-6aeac37b7fa1"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"\[VeryThinSpace]", "0"}], 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"n", " ", "\[ImaginaryI]", " ", "t"}]], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]], 
      RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", 
        RowBox[{"\[VeryThinSpace]", "0"}], 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "\[ImaginaryI]", " ", "t"}]], 
        RowBox[{"\[DifferentialD]", "t"}]}]}]}], "=", 
     RowBox[{
      TagBox[GridBox[{
         {"\[Piecewise]", GridBox[{
            {
             RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], 
             RowBox[{
              RowBox[{"if", " ", "n"}], "=", 
              RowBox[{"-", "1"}]}]},
            {"0", 
             RowBox[{
              RowBox[{"if", " ", "n"}], "!=", 
              RowBox[{"-", "1"}]}]}
           },
           AllowedDimensions->{2, Automatic},
           Editable->True,
           GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
           GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.84]}, 
               Offset[0.27999999999999997`]}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}},
           Selectable->True]}
        },
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.35]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}],
       "Piecewise",
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True,
       Selectable->False,
       StripWrapperBoxes->True], "."}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4a52cd8f-5fe6-4df4-a942-e6000b03a285"]
}], "SolvedExampleNote",
 CellID->69425760,ExpressionUUID->"c070a2b5-09fa-4986-bee5-d7f74c1e5667"],

Cell["", "SolvedExampleEndCap",
 CellID->526169082,ExpressionUUID->"6ff0880e-331d-42e4-b05b-77ad3162936e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->314925169,ExpressionUUID->"a2a24d1a-30d1-48a7-8e3d-e28e72ada3af"],

Cell[TextData[{
 "Calling ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c3533320-03b2-4ec7-88cc-fc449c8b38f0"],
 " the circle defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "=", 
    "r"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e16c41d2-8f30-4f14-9a97-4e65b8388141"],
 ", prove that the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"I", "=", 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "/", 
         OverscriptBox["z", "_"]}], ")"}], "2"], " ", 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7a11f701-1a58-4c67-81de-15e99eb5aa60"],
 " is zero in the limit of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a806b761-7bb0-4234-8a77-ee1ceec97187"],
 "."
}], "SolvedExampleNote",
 CellID->226880252,ExpressionUUID->"a6b79c50-4a02-4cf7-bc70-44bfa7eed491"],

Cell[TextData[{
 "To write a bound for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "I", "|"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4ac2f029-315f-4d6b-b9f6-44bca4dcb852"],
 ", use Eq. (6):"
}], "SolvedExampleNote",
 CellID->75502952,ExpressionUUID->"59c004c8-e04f-4e27-ad48-9a67ebc167d9"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", "I", "\[RightBracketingBar]"}], "<=", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["r", "2"]], "\[CenterDot]", 
      RowBox[{"(", 
       RowBox[{"2", "\[Pi]", " ", "r"}], ")"}]}]}], "=", 
    FractionBox[
     RowBox[{"2", "\[Pi]"}], "r"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"719f3b77-7052-44b6-a584-d733919fbb83"],
 ", which is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a484a69e-ea1a-4098-ab96-36e4400f8bde"],
 "."
}], "SolvedExampleNote",
 CellID->743341451,ExpressionUUID->"9c1582e3-6226-415a-867d-817d283232e4"],

Cell["", "SolvedExampleEndCap",
 CellID->1415271019,ExpressionUUID->"840a629a-1292-4763-b37f-adc97b1d07a6"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->153931642,ExpressionUUID->"a628e15e-43b3-4442-9f1a-caa7c27bb114"],

Cell[TextData[{
 "Prove that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     OverscriptBox["z", "_"], " ", 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b9464401-c30c-4301-a04f-483b7636d93c"],
 " around a closed contour ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "613e8051-0d3d-45fd-b6a9-acef3614d28b"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0c8f0f8f-ada3-415c-8016-83087a7e136d"],
 " times the area enclosed."
}], "SolvedExampleNote",
 CellID->538180421,ExpressionUUID->"5607c355-51ed-4202-86b8-84c240fa7fb5"],

Cell[TextData[{
 "This is a consequence of Eq. (4) and Green\[CloseCurlyQuote]s theorem for \
line integrals of real analysis, which states that for a vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"L", ",", "M"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3c99b538-6d18-4624-b9ac-a9dd08f46c35"],
 ":"
}], "SolvedExampleNote",
 CellID->34484980,ExpressionUUID->"570243b7-4b4a-4780-93bb-cf23f4b13eb0"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{"L", " ", 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
    RowBox[{"M", 
     RowBox[{"\[DifferentialD]", "y"}]}]}], "=", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SubscriptBox["\[Integral]", "D"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"\[PartialD]", "M"}], 
         RowBox[{"\[PartialD]", "x"}]], "-", 
        FractionBox[
         RowBox[{"\[PartialD]", "L"}], 
         RowBox[{"\[PartialD]", "y"}]]}], ")"}], 
      RowBox[{"\[DifferentialD]", "x"}], " ", 
      RowBox[{"\[DifferentialD]", "y"}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"08646434-0528-4d7e-b5d7-bf184c65cec1"]], \
"SolvedExampleNote",
 CellID->14126930,ExpressionUUID->"6ddf650a-b741-4bc3-aac2-cb50f4809574"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    OverscriptBox["z", "_"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "422e70db-476b-434c-a979-d13462d7a7a6"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "x"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f5ff7db0-18ac-4aa6-aa44-8e0e9478dbba"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"v", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"-", "y"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6275ab43-17d5-4bbb-a9c1-36bc474e0f45"],
 ". The complex integral is then:"
}], "SolvedExampleNote",
 CellID->787509019,ExpressionUUID->"aa7a4da6-4252-4feb-9df0-cc7c06516c7f"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     OverscriptBox["z", "_"], " ", 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ContourIntegral]", 
         RowBox[{"\[ThinSpace]", "C"}]], 
        RowBox[{"x", 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
       RowBox[{"y", 
        RowBox[{"\[DifferentialD]", "y"}]}]}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ContourIntegral]", 
         RowBox[{"\[ThinSpace]", "C"}]], 
        RowBox[{
         RowBox[{"-", "y"}], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
       RowBox[{"u", 
        RowBox[{"\[DifferentialD]", "y"}]}]}], ")"}]}], "=", 
    RowBox[{
     RowBox[{"0", "+", 
      RowBox[{"\[ImaginaryI]", 
       RowBox[{"\[Integral]", 
        RowBox[{
         SubscriptBox["\[Integral]", "D"], 
         RowBox[{"2", 
          RowBox[{"\[DifferentialD]", "x"}], " ", 
          RowBox[{"\[DifferentialD]", "y"}]}]}]}]}]}], "=", 
     RowBox[{"2", "\[ImaginaryI]", " ", 
      RowBox[{
       RowBox[{"area", "(", "D", ")"}], "."}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"c1184bad-c4b7-4c89-b873-aabef6550567"]], \
"SolvedExampleNote",
 CellID->238604914,ExpressionUUID->"2622f6ac-c082-4bfb-aa7b-9e29413bad78"],

Cell["", "SolvedExampleEndCap",
 CellID->1463241023,ExpressionUUID->"026752ba-deab-4f10-a8bf-bb28ca77c8e4"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->219659473,ExpressionUUID->"757b5bea-a751-469f-a9eb-e878244a7e96"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", "2"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4744ad30-39ff-4ee6-bc85-523fcbf6a656"],
 " if ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c0a0b687-022b-4932-a5ed-9324a7104625"],
 " is a straight path from 0 to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c43822df-f254-4ed7-aa70-e044bb1cf262"],
 "."
}], "SolvedExampleNote",
 CellID->119113669,ExpressionUUID->"7d8fd023-518a-4ed7-9fc3-57ea3e598b3b"],

Cell[TextData[{
 "The contour can be parametrized as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"\[ImaginaryI]", " ", "t"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d819efe4-edf3-450c-a101-c678eabb57f8"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "2"}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"95f1bea2-44d9-43df-acf0-4766c841733b"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}]}], "=", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"010ecd80-f1b2-41a9-a58d-8709bb19fbef"],
 " and"
}], "SolvedExampleNote",
 CellID->226755097,ExpressionUUID->"9d4eecdf-2046-4e8b-a9e1-a88070f2038b"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", "2"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], " ", "=", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"\[VeryThinSpace]", "0"}], "2"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[ImaginaryI]", " ", "t"}], ")"}], "2"], "\[ImaginaryI]", 
      RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       FractionBox[
        SuperscriptBox["t", "3"], "3"]}], 
      SubsuperscriptBox["|", "0", "2"]}], "=", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["8", "3"]}], 
      RowBox[{"\[ImaginaryI]", "."}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"bed3e743-4555-427f-a40c-ffc071eae9be"]], \
"SolvedExampleNote",
 CellID->28762006,ExpressionUUID->"d27a4890-00b6-44d3-b31f-689aea9429a1"],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->180446814,ExpressionUUID->"b393e388-685d-439f-9e9a-56249fad9220"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   SuperscriptBox["z", "2"], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->13195382,ExpressionUUID->"22415231-1f92-4158-b050-7d5c151ea276"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]"}], "3"]}]], "SolvedExampleOutput",
 CellID->235164002,ExpressionUUID->"ef8f911c-e843-4ac9-8ff6-db83ea295690"]
}, Open  ]],

Cell["Plot the function and the contour:", "SolvedExampleNote",
 CellID->210529817,ExpressionUUID->"c1fe4806-2a4b-4c5b-8d5c-da44cd61dc58"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   SuperscriptBox["z", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["4", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1232", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[{{0, 0}, {0, 2}}]}, ImageSize -> Small, FrameLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, FrameStyle -> Directive[12]],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->144449912,ExpressionUUID->"49fd6b6f-9f97-4e22-87eb-cf38327d837a"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJw8uneQnOeVr7dl/+Oy77W9vt5b17tr7UpXu9qVZKWVKJEiKZGixEyRYAAF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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[{{0, 0}, {0, 2}}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
       RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], None}},
  FrameStyle->Directive[12],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->569097589,ExpressionUUID->"92b45aa7-d2d0-4e6b-bbe6-3f921fe3b241"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1170476267,ExpressionUUID->"92c8abbe-7d3e-4eff-847f-c50904bafe1a"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"6fabdde2-9860-4fcd-b212-ba209368e2fd"],

Cell["\<\
You have seen three equivalent definitions of complex integrals.\
\>", "SummaryList",
 CellID->273736510,ExpressionUUID->"2d27fd59-4114-464f-8dc6-c74425652cc1"],

Cell["\<\
The integration contour is an oriented curve in the complex plane.\
\>", "SummaryList",
 CellID->508186619,ExpressionUUID->"35a06d95-7789-48b3-b38e-d5d98d1a651e"],

Cell["\<\
Complex integrals change sign if the contour is traversed with the opposite \
orientation.\
\>", "SummaryList",
 CellID->45758559,ExpressionUUID->"bfa46f39-46d1-42f7-8d83-e682b95ae0d8"],

Cell["A bound for a complex integral is:", "SummaryList",
 CellID->13594917,ExpressionUUID->"d5eca143-68e3-4447-8b57-afd2492e46e9"],

Cell[BoxData[
 FormBox[Cell[TextData[Cell[BoxData[
   FormBox[
    RowBox[{"|", 
     RowBox[{
      SubscriptBox["\[Integral]", "C"], 
      RowBox[{"f", 
       RowBox[{"(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}]}], "|", 
     RowBox[{"<=", "M"}], "|", "C", "|"}], TraditionalForm]],ExpressionUUID->
   "29af20fa-632f-414f-86b5-11fdfbe250d8"]],ExpressionUUID->
   "b03b62fc-5841-4553-8e1e-03ce6306eeb3"], 
  TraditionalForm]], "DisplayFormula",
 CellID->124775987,ExpressionUUID->"4651d255-31e3-415c-82ba-2ea278936da7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->7858937,ExpressionUUID->"8e648545-f987-42ba-8107-e46ab66975d9"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "+", 
       SuperscriptBox["z", "2"]}], ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9661e482-d16a-445b-bced-3fdec62c9b01"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2b859c53-7c0d-424f-95b7-1869565d29bd"],
 " is the straight line between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9f1c515b-5387-444b-9646-ae1351b7b6bc"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6c0b82e8-f807-4ac1-87c1-0d7904f93838"],
 "."
}], "Exercise",
 CellID->90133499,ExpressionUUID->"0d2198c2-dbe8-44cf-87ac-8b23ed8f843c"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"71fe1ce4-b9cc-478c-852d-752274d63358"],

Cell[TextData[{
 "The straight line can be parametrized by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"\[ImaginaryI]", " ", "t"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6982166b-844b-4299-a454-469555359da2"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d9a12c82-8c9d-4354-8b6b-3f7a36c5c68c"],
 ". So:"
}], "SolutionAnswer",
 CellID->199505212,ExpressionUUID->"0cdfddde-89d8-4bd0-9caa-f47052a0f900"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", 
        SuperscriptBox["z", "2"]}], ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", 
       RowBox[{"\[VeryThinSpace]", "1"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Rho]", "(", "t", ")"}], "+", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"\[Rho]", "(", "t", ")"}], ")"}], "2"]}], ")"}], 
       RowBox[{"\[Rho]", "'"}], 
       RowBox[{"(", "t", ")"}], " ", 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["\[Integral]", "0", 
        RowBox[{"\[VeryThinSpace]", "1"}]], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "t"}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[ImaginaryI]", " ", "t"}], ")"}], "2"]}], ")"}], 
        "\[ImaginaryI]", " ", 
        RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "-", 
       FractionBox["\[ImaginaryI]", "3"]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"41c0d181-e926-48cb-acfa-c9438e36794f"],
 "."
}], "SolutionAnswer",
 CellID->282017256,ExpressionUUID->"2afcca1f-325e-4071-82fb-6245d57d8608"],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->408431724,ExpressionUUID->"4c16801e-8a3d-46e3-ada4-4bc10140ec92"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{"z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->200129570,ExpressionUUID->"6551306b-e51b-446b-b0bc-ac6a7f27a7bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "-", 
  FractionBox["\[ImaginaryI]", "3"]}]], "ExerciseOutput",
 CellID->423508579,ExpressionUUID->"de99f626-3f7a-4849-b7fb-6fac9bd4b037"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"z", "-", "1"}]], "+", 
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "1"}], ")"}], "2"]]}], ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"34d52dbb-3a57-44f4-b128-0690de7a0a1d"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "0c8a6931-ec09-448b-905f-9051159bcd1a"],
 " is a circle of radius 2 centered at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ee652ca9-4844-4598-996b-c4c21494372e"],
 ", traversed anticlockwise."
}], "Exercise",
 CellID->18889578,ExpressionUUID->"876ea211-b62b-4525-91ff-0d4550f8fdf0"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"1893f0ac-cfbe-48a5-8b9c-febd27877880"],

Cell[TextData[{
 "The circular contour is parametrized by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"2", 
      SuperscriptBox["e", 
       RowBox[{"\[VeryThinSpace]", 
        RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"4132cea0-ff6f-4780-a2b1-874774e957b4"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{"2", "\[ImaginaryI]", " ", 
     SuperscriptBox["e", 
      RowBox[{"\[VeryThinSpace]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"3ef24f88-8bbb-483d-9d2b-098607c18310"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"34d1617c-34c7-4abf-b217-90a79dffb200"],
 ". The integral is:"
}], "SolutionAnswer",
 CellID->126449404,ExpressionUUID->"9cd82092-3b94-4038-ac5a-c9f01f7e0a57"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"z", "-", "1"}]], "+", 
        FractionBox["1", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"z", "-", "1"}], ")"}], "2"]]}], ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", 
       RowBox[{"\[ThinSpace]", 
        RowBox[{"2", "\[Pi]"}]}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"2", 
           SuperscriptBox["e", 
            RowBox[{"\[VeryThinSpace]", 
             RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}]], "+", 
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", 
             SuperscriptBox["e", 
              RowBox[{"\[VeryThinSpace]", 
               RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}], ")"}], "2"]]}], 
        ")"}], "2", "\[ImaginaryI]", " ", 
       SuperscriptBox["e", 
        RowBox[{"\[VeryThinSpace]", 
         RowBox[{"\[ImaginaryI]", " ", "t"}]}]], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "0", 
         RowBox[{"\[ThinSpace]", 
          RowBox[{"2", "\[Pi]"}]}]], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            FractionBox["1", "2"], 
            SuperscriptBox["e", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "t"}]]}]}], ")"}], 
         RowBox[{"\[DifferentialD]", "t"}]}]}]}], "=", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"6ae1c4e1-bdf1-4e2d-add2-4f01e616713e"],
 "."
}], "SolutionAnswer",
 CellID->107067571,ExpressionUUID->"5c655933-fa90-48a9-ba69-3511709cbf73"],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->275088157,ExpressionUUID->"bb346650-564e-41e0-a2a0-8490efd4edbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "-", "1"}]], "+", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->995109897,ExpressionUUID->"443ee07c-f258-47b0-a76f-93bbb09c373f"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->496187958,ExpressionUUID->"a731d149-3565-4da6-9c5c-aac8c0d5d8b0"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"2", "z"}], "+", "7"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "2"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"362302aa-d0c7-490f-96a1-74c8569a6500"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "4a64811a-4d08-49ef-966f-01e51b9574cc"],
 " is a circle of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7946e77b-1bb2-4986-89a3-9ad2aa7a0241"],
 " centered at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ac74bd7a-0b55-434a-b9ef-16bb612839c2"],
 " traversed anticlockwise, after decomposing the integrand into partial \
fractions. Discuss the result for all possible values of ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1cf5dc17-425e-4e4a-a7ee-41d9d3d2c864"],
 "."
}], "Exercise",
 CellID->350576821,ExpressionUUID->"53a6db67-b9f1-468c-a142-13b0afe5b918"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"9704921f-1338-4975-974f-d8d7b2c2e7eb"],

Cell[TextData[{
 "The integral can only be computed if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "!=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4b28c8ee-7d8b-7347-8255-7ca807de5de4"],
 "; otherwise, there is a singularity on the contour. Decompose the integrand \
using ",
 ButtonBox["Apart",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->324560064,ExpressionUUID->"5c08ea5a-fac0-654b-a5e2-82b381ff552c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"2", "z"}], "+", "7"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "+", "1"}], ")"}], "2"]], "]"}]], "ExerciseInput",
 CellID->804729440,ExpressionUUID->"89ba3c80-d291-4b17-9378-562079c0da6b"],

Cell[BoxData[
 RowBox[{
  FractionBox["5", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "z"}], ")"}], "2"]], "+", 
  FractionBox["2", 
   RowBox[{"1", "+", "z"}]]}]], "ExerciseOutput",
 CellID->81961311,ExpressionUUID->"07d9e7f3-7d0c-410e-9419-cd6e8e9c74bf"]
}, Open  ]],

Cell[TextData[{
 "For any value of ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "fc83e03d-d1cd-4a34-9b00-a7eabf701d46"],
 ", the term ",
 Cell[BoxData[
  FormBox[
   RowBox[{"5", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"-", "2"}]]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7c81747f-06dc-43bd-94bd-296a2442027c"],
 " does not contribute to the integral. The term ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}], 
     RowBox[{"-", "1"}]]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "34173e15-bfbb-4ef1-8272-112ba210ecab"],
 " contributes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5e7110a5-814f-4bbe-bb5a-77f8ab254717"],
 " only if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", ">", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ef9eac81-b2cc-45e3-86c6-fcbe1512cc04"],
 "."
}], "SolutionAnswer",
 CellID->412401964,ExpressionUUID->"47d2dc25-71a2-45e0-85ff-491511129dfd"],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->2029491257,ExpressionUUID->"c32955d0-7d97-4839-9a91-9966808812e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "z"}], "+", "7"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], "2"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", "r"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->13211504,ExpressionUUID->"409f5b49-6591-47db-be40-17eb4d754eb0"],

Cell[BoxData[
 TemplateBox[{
   TagBox[
    GridBox[{{"\[Piecewise]", 
       GridBox[{{
          RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}], 
          RowBox[{"r", ">", "1"}]}, {"0", 
          TagBox["True", "PiecewiseDefault", AutoDelete -> True]}}, 
        ColumnAlignments -> {Left}, ColumnSpacings -> 1.2, ColumnWidths -> 
        Automatic, AllowedDimensions -> {2, Automatic}, Selectable -> True, 
        Editable -> True]}}, ColumnAlignments -> {Left}, ColumnSpacings -> 
     0.5, ColumnWidths -> Automatic], "Piecewise", SyntaxForm -> Equal, 
    SelectWithContents -> True, StripWrapperBoxes -> True, Selectable -> 
    False, Editable -> False, DeleteWithContents -> True], 
   RowBox[{"r", "\[NotEqual]", "1"}]},
  "ConditionalExpression"]], "ExerciseOutput",
 CellID->90025083,ExpressionUUID->"ee3ae1e7-a9d4-4173-b9e7-e159e838e2cc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     SuperscriptBox["z", "2"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"969382ea-db5d-4dc4-864b-30507b6d044f"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "763c69e2-e569-4605-8d7d-07f19e6ef35e"],
 " is the contour pictured here:"
}], "Exercise",
 CellID->232718658,ExpressionUUID->"6fdcfb9d-6fde-4aef-9264-3e3d8c725e1c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "t", "]"}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "2.5"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", "Black"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "170"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]], "ExerciseInput",
 CellID->19139565,ExpressionUUID->"3b538d99-680c-44ab-bc6d-03f8fb185bd4"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[CompressedData["
1:eJxd2XlUjd3bB/CjZGiSpEJISJ4UqUjom5BkKprQqGh4RIokaTAkoVSiKM1J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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJxd2XlUjd3bB/CjZGiSpEJISJ4UqUjom5BkKprQqGh4RIokaTAkoVSiKM1J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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-0.5, 2.5}, {-0.5, 2.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {170, 170}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{-0.5, 2.5}, {-0.5, 2.5}},
           "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {170, 170}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             Thickness[0.01], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxd2XlUjd3bB/CjZGiSpEJISJ4UqUjom5BkKprQqGh4RIokaTAkoVSiKM1J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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {{-0.5, 2.5}, {-0.5, 2.5}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {170, 170}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]]}, 
       "HighlightLabelingFunctions" -> <|
        "CoordinatesToolOptions" -> Identity, 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{
    Arrowheads[0.07], 
    ArrowBox[{{0.2, 2}, {0, 2}}]},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->170,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-0.5, 2.5}, {-0.5, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->49745357,ExpressionUUID->"33fd6893-4081-44e9-a52e-64235b3f5c50"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"8ea9683d-732b-4109-9147-f6f992cbaf1d"],

Cell[TextData[{
 "The contour is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"\[ImaginaryI]", "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[VeryThinSpace]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9951b7c4-eaf8-4da5-85ef-192ba59f772f"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "'"}], 
     RowBox[{"(", "t", ")"}]}], "=", 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[VeryThinSpace]", 
       RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"db28ac4e-065d-4b7b-84fa-d6490dbaa870"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["\[Pi]", "2"]}], ",", 
      FractionBox["\[Pi]", "2"]}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1bd7a212-8329-4bdd-bf1f-a2534c010133"],
 ". So:"
}], "SolutionAnswer",
 CellID->58419633,ExpressionUUID->"8bc4a8b4-e55f-4a55-a1b1-225bac044e17"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      SuperscriptBox["z", "2"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], 
       RowBox[{"\[VeryThinSpace]", 
        RowBox[{"\[Pi]", "/", "2"}]}]], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", "+", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"\[VeryThinSpace]", 
            RowBox[{"\[ImaginaryI]", " ", "t"}]}]]}], ")"}], "2"], 
       "\[ImaginaryI]", " ", 
       SuperscriptBox["e", 
        RowBox[{"\[VeryThinSpace]", 
         RowBox[{"\[ImaginaryI]", " ", "t"}]}]], 
       RowBox[{"\[DifferentialD]", "t"}]}]}], "=", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", "\[ImaginaryI]"}], "3"]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"32bd6be0-1448-4ba3-b45a-65171107d85d"],
 "."
}], "SolutionAnswer",
 CellID->494583253,ExpressionUUID->"162eff70-2edd-417d-bc78-cd816dc668f6"],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->87074535,ExpressionUUID->"91ef95a7-9894-4cc8-87a7-eb1b9560898c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   SuperscriptBox["z", "2"], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "Pi"}], "/", "2"}], ",", 
        RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->673767498,ExpressionUUID->"ec6386b9-b020-41c8-91a9-054eccfaa5c4"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"8", " ", "\[ImaginaryI]"}], "3"]}]], "ExerciseOutput",
 CellID->648079561,ExpressionUUID->"be520226-9bc1-43a2-9119-d3e33e8b7573"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     RowBox[{"log", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a0216bce-016d-4bf8-8760-0864b9dd77e8"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5f81b29f-a062-41c2-8f2c-49d0f52c21a4"],
 " is the contour pictured here:"
}], "Exercise",
 CellID->103266790,ExpressionUUID->"488adceb-c974-4af1-b7d2-765864e6c9d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", "Black"}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "170"}]}], "]"}]], "ExerciseInput",
 CellID->67821223,ExpressionUUID->"8380d2cc-bf2a-4b2a-8e88-d1ebc62782a2"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.01], Opacity[1.], FaceForm[Opacity[0.3]], 
         LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7BlQwAf7pN9iJ9slW+xR+VPg/JNBwQwfPi6B
82t/GK91k1sP59/zdZ94uHsLnG9wetLz6V92wvkXNmS1MTLuh/OFEgsWnLc5
BOfLvTz5PuLNETg/cGnm4zW5x+H8uPIbT6RUT8H5k2p7u4LXnYHzNZgTFx3T
Og/n+55nfLLy3QU4X9L824mrBpfg/Eual7bw9V2G821i9t588uQKnL9rxemA
BSrX4HyVhoPnMuqvw/mLCm/NEzt8A87nfXer9KLiLThfc9WrVs2q23B+ZIPs
i7Tdd+D80ofmgRvF78H5S2NKeR7G3IfzD3MnMlz3fQDnr9L7/ffwLwR/9r1l
S5TnPITzmUKOneP0fgTnO2XmTt33DcHv4VZjfTbtMZzvUxz0Y7LLEzhfLGPC
lC3PEPwdf0LPLm59CudfDOvvlDR6Bud/tr31jvEygt/zasb1gsbncL6+SmZm
kMoLhPv/HpjOdATBnzOnx9Oy8CWcP/1E5pJHQq/gfM5du5qEDiH4Id6T/wrk
vYbzV2TWKjbxvYHzi31vn6jcg+C77/OSfBL3Fs7/cs6RTfYfgi++dE3ZnVXv
4HwXDs0JfD7v4XylFhEP9mUIPowGAAwPDhQ=
          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]], 
             Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7BlQwAf7pN9iJ9slW+xR+VPg/JNBwQwfPi6B
82t/GK91k1sP59/zdZ94uHsLnG9wetLz6V92wvkXNmS1MTLuh/OFEgsWnLc5
BOfLvTz5PuLNETg/cGnm4zW5x+H8uPIbT6RUT8H5k2p7u4LXnYHzNZgTFx3T
Og/n+55nfLLy3QU4X9L824mrBpfg/Eual7bw9V2G821i9t588uQKnL9rxemA
BSrX4HyVhoPnMuqvw/mLCm/NEzt8A87nfXer9KLiLThfc9WrVs2q23B+ZIPs
i7Tdd+D80ofmgRvF78H5S2NKeR7G3IfzD3MnMlz3fQDnr9L7/ffwLwR/9r1l
S5TnPITzmUKOneP0fgTnO2XmTt33DcHv4VZjfTbtMZzvUxz0Y7LLEzhfLGPC
lC3PEPwdf0LPLm59CudfDOvvlDR6Bud/tr31jvEygt/zasb1gsbncL6+SmZm
kMoLhPv/HpjOdATBnzOnx9Oy8CWcP/1E5pJHQq/gfM5du5qEDiH4Id6T/wrk
vYbzV2TWKjbxvYHzi31vn6jcg+C77/OSfBL3Fs7/cs6RTfYfgi++dE3ZnVXv
4HwXDs0JfD7v4XylFhEP9mUIPowGAAwPDhQ=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 1.5}, {-0.5, 1.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {170, 170}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              Thickness[0.01], 
              GrayLevel[0]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 1.5}, {-0.5, 1.5}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {170, 170}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             Thickness[0.01], 
             GrayLevel[0]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]], 
         Line[CompressedData["
1:eJxTTMoPSmViYGAwAWIQDQEf7BlQwAf7pN9iJ9slW+xR+VPg/JNBwQwfPi6B
82t/GK91k1sP59/zdZ94uHsLnG9wetLz6V92wvkXNmS1MTLuh/OFEgsWnLc5
BOfLvTz5PuLNETg/cGnm4zW5x+H8uPIbT6RUT8H5k2p7u4LXnYHzNZgTFx3T
Og/n+55nfLLy3QU4X9L824mrBpfg/Eual7bw9V2G821i9t588uQKnL9rxemA
BSrX4HyVhoPnMuqvw/mLCm/NEzt8A87nfXer9KLiLThfc9WrVs2q23B+ZIPs
i7Tdd+D80ofmgRvF78H5S2NKeR7G3IfzD3MnMlz3fQDnr9L7/ffwLwR/9r1l
S5TnPITzmUKOneP0fgTnO2XmTt33DcHv4VZjfTbtMZzvUxz0Y7LLEzhfLGPC
lC3PEPwdf0LPLm59CudfDOvvlDR6Bud/tr31jvEygt/zasb1gsbncL6+SmZm
kMoLhPv/HpjOdATBnzOnx9Oy8CWcP/1E5pJHQq/gfM5du5qEDiH4Id6T/wrk
vYbzV2TWKjbxvYHzi31vn6jcg+C77/OSfBL3Fs7/cs6RTfYfgi++dE3ZnVXv
4HwXDs0JfD7v4XylFhEP9mUIPowGAAwPDhQ=
          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1, 1.5}, {-0.5, 1.5}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {170, 170}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          Thickness[0.01], 
          GrayLevel[0]]}, 
       "HighlightLabelingFunctions" -> <|
        "CoordinatesToolOptions" -> Identity, 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[12],
  DisplayFunction->Identity,
  Epilog->{
    Arrowheads[0.07], 
    ArrowBox[
     LineBox[{{1, 1}, {0, 1}}]]},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->170,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{{-1, 1.5}, {-0.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->220558848,ExpressionUUID->"56bb55c3-c0ef-42d9-b9a4-381689f881fd"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"884a12ec-2012-459a-88c3-f23f16ac0c55"],

Cell[TextData[{
 "The contour can be split into two parts. For the first, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", " ", "t"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dea00a67-51fc-4284-950d-d5b204ece101"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f3e9f549-7553-4e48-8f7f-19e140e1fe67"],
 ". Its contribution is:"
}], "SolutionAnswer",
 CellID->34566889,ExpressionUUID->"37c5ae1e-a38d-40b2-97ba-478bc57ed571"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "*", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", "*", "t"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
   "Expand"}]}]], "ExerciseInput",
 CellID->120521889,ExpressionUUID->"576d0b52-2321-4de4-acdd-4e0cea6426f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "4"], "-", 
     FractionBox["\[ImaginaryI]", "4"]}], ")"}], " ", "\[Pi]"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
   RowBox[{"Log", "[", "2", "]"}]}]}]], "ExerciseOutput",
 CellID->224260997,ExpressionUUID->"3964ce9f-c61c-4961-9b6f-a737aadf71a6"]
}, Open  ]],

Cell[TextData[{
 "For the second, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Sigma]", "(", "t", ")"}], "=", 
    RowBox[{"1", "-", "t", "+", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"6977cb8c-9940-43c0-bdce-67201f436ec3"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"661b8c18-6414-4910-bf4b-4bec3aa95c09"],
 ". Its contribution is:"
}], "SolutionAnswer",
 CellID->583275233,ExpressionUUID->"92a387ba-3fcc-4d34-bd6d-b66c65a7f63b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "*", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "t", "+", "\[ImaginaryI]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], "//", 
   "Expand"}]}]], "ExerciseInput",
 CellID->136004492,ExpressionUUID->"83fa4ede-b7a4-4fec-afca-1cdf662a95a4"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "4"], "+", 
     FractionBox["\[ImaginaryI]", "4"]}], ")"}], " ", "\[Pi]"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "4"], "+", 
     FractionBox["\[ImaginaryI]", "4"]}], ")"}], " ", 
   RowBox[{"Log", "[", "4", "]"}]}]}]], "ExerciseOutput",
 CellID->164710003,ExpressionUUID->"585c28b2-c547-47d6-9276-d03ac4e7d95d"]
}, Open  ]],

Cell["The total is:", "SolutionAnswer",
 CellID->217063613,ExpressionUUID->"a0689456-a826-4cef-b32a-0ec09d8c9e82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i1", "+", "i2"}], "//", "FullSimplify"}]], "ExerciseInput",
 CellID->139938030,ExpressionUUID->"635bd9e3-aa6f-41b8-a652-754e980c8559"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "-", 
  FractionBox["\[Pi]", "2"]}]], "ExerciseOutput",
 CellID->34001278,ExpressionUUID->"9f78ad0d-2ede-4aaa-9448-b41e0890b09b"]
}, Open  ]],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->535448003,ExpressionUUID->"c1af0ca2-b039-4936-b679-00ca2822a6ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", "z", "]"}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->167710769,ExpressionUUID->"d8653756-529c-43f8-9b10-a90d2226c028"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], "-", 
  FractionBox["\[Pi]", "2"]}]], "ExerciseOutput",
 CellID->247436032,ExpressionUUID->"e7bc32a9-5219-4273-bf52-a47733d1ad50"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1082123849,ExpressionUUID->"36777578-6cc5-4a4f-a99e-b6751d3ec310"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"11. Complex Line Integrals | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "10. The Cauchy\[Dash]Riemann Equations"}, "PrettyTooltipTemplate"], 
      "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "12. Fundamental Theorem for Complex Line Integrals"}, 
        "PrettyTooltipTemplate"], "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"8c0c330d-7f38-4fb1-a406-0f5498109a1d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Example112"->{
  Cell[139440, 3096, 212, 9, 71, "SolvedExample",ExpressionUUID->"126c3765-98a0-4c3d-92b8-b84253fec9cf",
   CellTags->"Example112",
   CellID->430700739]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Example112", 438668, 9581}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[649, 23, 229, 7, 108, "Section",ExpressionUUID->"f7744ab9-dd4e-40a8-b7e9-6c49113ffa29",
 CounterAssignments->{{"Section", 10}},
 CellID->592339613],
Cell[881, 32, 187, 4, 36, "Text",ExpressionUUID->"4c2c5285-37ec-4e2f-91fd-68dfa66a5a43",
 CellID->360210785],
Cell[CellGroupData[{
Cell[1093, 40, 133, 1, 56, "Subsection",ExpressionUUID->"b54dd712-47c9-439a-93bd-82ac37b3607d",
 CellID->250400948],
Cell[1229, 43, 184, 4, 36, "Text",ExpressionUUID->"1160049d-a954-4427-ba2d-8088b287a62a",
 CellID->109580523],
Cell[1416, 49, 742, 24, 56, "DisplayFormulaNumbered",ExpressionUUID->"55eccf49-e19c-4242-b9a9-1606235a4791",
 CellID->60871971],
Cell[2161, 75, 539, 12, 83, "Text",ExpressionUUID->"3692c289-eb1a-420d-a8c5-895764ec28b0",
 CellID->83932821],
Cell[CellGroupData[{
Cell[2725, 91, 3529, 92, 70, "Input",ExpressionUUID->"605d6a4c-1f82-43c9-8afe-803abe0b9d18",
 CellID->148174721],
Cell[6257, 185, 38922, 743, 196, "Output",ExpressionUUID->"32abfaad-3bc9-457c-8036-8280048b875d",
 CellID->1801049108]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45225, 934, 116, 1, 56, "Subsection",ExpressionUUID->"c5fbde01-7a2f-4a02-86aa-ebc73cad12c0",
 CellID->101008060],
Cell[45344, 937, 301, 7, 60, "Text",ExpressionUUID->"25ba6eca-e45d-4550-bb0e-7138f5f08205",
 CellID->657921177],
Cell[45648, 946, 824, 22, 83, "Text",ExpressionUUID->"1f376b57-d13f-40d2-96ad-523334c88794",
 CellID->498985828],
Cell[CellGroupData[{
Cell[46497, 972, 177, 2, 54, "Subsubsection",ExpressionUUID->"2dbaefa1-b710-43fd-b17b-980f118406f2",
 CellID->103174132],
Cell[46677, 976, 309, 5, 83, "Text",ExpressionUUID->"2947efe9-6c10-4405-afde-6e8377814506",
 CellID->107626032],
Cell[46989, 983, 732, 24, 56, "DisplayFormulaNumbered",ExpressionUUID->"e7bc9d8e-ca73-4db7-8a36-6a5be519fec0",
 CellID->11009606],
Cell[47724, 1009, 939, 29, 36, "Text",ExpressionUUID->"9b2f0438-e93a-4f64-98e5-0eb55fd8cc8a",
 CellID->357829839],
Cell[CellGroupData[{
Cell[48688, 1042, 6983, 174, 70, "Input",ExpressionUUID->"a944421b-da17-4f3e-8eed-a1c4ae87a6c4",
 CellID->297254086],
Cell[55674, 1218, 5696, 118, 358, "Output",ExpressionUUID->"669e0176-da14-41f3-98f6-328af33e4156",
 CellID->120369159]
}, {2}]],
Cell[61382, 1339, 386, 9, 36, "Text",ExpressionUUID->"eb323f32-655e-4620-9594-9657e6266172",
 CellID->590193366],
Cell[61771, 1350, 190, 4, 36, "Text",ExpressionUUID->"a0bb998e-160f-4640-8292-0c8dad26dcee",
 CellID->188435328],
Cell[61964, 1356, 2051, 55, 27, "Input",ExpressionUUID->"68778f1d-b9fe-4c4a-8075-99db24e525fe",
 CellID->76110827],
Cell[64018, 1413, 139, 1, 36, "Text",ExpressionUUID->"39c23042-6632-4133-88fb-ef582c64a461",
 CellID->45333929],
Cell[CellGroupData[{
Cell[64182, 1418, 499, 15, 25, "Input",ExpressionUUID->"91a8252c-6f40-4e10-8178-47983400eabf",
 CellID->755312259],
Cell[64684, 1435, 213, 4, 36, "Output",ExpressionUUID->"d54fb3dd-df93-441a-8376-880eb5ceabc0",
 CellID->29907437]
}, Open  ]],
Cell[64912, 1442, 189, 4, 36, "Text",ExpressionUUID->"3f4ffebf-5b20-4543-ae47-5c9d0ba8444d",
 CellID->608037992],
Cell[65104, 1448, 2563, 63, 27, "Input",ExpressionUUID->"82729676-9463-46a7-89fc-0b18d3b3a127",
 CellID->149717011],
Cell[67670, 1513, 136, 1, 36, "Text",ExpressionUUID->"78c40a8a-831b-4412-aa4f-37e26cd9e3ec",
 CellID->274271816],
Cell[CellGroupData[{
Cell[67831, 1518, 500, 15, 25, "Input",ExpressionUUID->"90800376-4638-4f12-a442-1523c5a78d84",
 CellID->362936641],
Cell[68334, 1535, 213, 4, 36, "Output",ExpressionUUID->"f9fb21d9-aa46-4163-bc82-d9697ea3f7dc",
 CellID->519880666]
}, Open  ]],
Cell[68562, 1542, 112, 1, 36, "Text",ExpressionUUID->"a5e2c5a0-0e44-47e0-ab76-df4bcf5ddca6",
 CellID->543967574],
Cell[68677, 1545, 4316, 91, 27, "Input",ExpressionUUID->"349d77dd-d9ad-4e66-8900-27309676c67d",
 CellID->269915670],
Cell[72996, 1638, 105, 1, 36, "Text",ExpressionUUID->"b45bf3dd-80f0-4e81-870a-25ef021de5d0",
 CellID->864088875],
Cell[CellGroupData[{
Cell[73126, 1643, 498, 15, 25, "Input",ExpressionUUID->"e9d9be3c-d6eb-465c-a8cc-527fea4e692e",
 CellID->7091304],
Cell[73627, 1660, 214, 4, 36, "Output",ExpressionUUID->"87f4851b-0c05-40c0-a361-c4aa216aa81c",
 CellID->131976548]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73890, 1670, 178, 2, 54, "Subsubsection",ExpressionUUID->"dc49d41c-01c5-4701-8f9a-01e8de12170d",
 CellID->124855073],
Cell[74071, 1674, 790, 23, 60, "Text",ExpressionUUID->"4595d5b2-bfff-4fb1-912b-8daeb5c21857",
 CellID->343173542],
Cell[74864, 1699, 616, 20, 45, "DisplayFormulaNumbered",ExpressionUUID->"67c8028c-d101-4e93-8885-06fdf0f0d4bd",
 CellID->399295],
Cell[75483, 1721, 195, 4, 36, "Text",ExpressionUUID->"44a4eb24-a802-4b54-a9b7-478a89c7c662",
 CellID->277792137],
Cell[75681, 1727, 504, 13, 60, "Text",ExpressionUUID->"a87e9ae3-d260-43eb-b729-10a0c518743b",
 CellID->8558990],
Cell[76188, 1742, 1523, 37, 27, "Input",ExpressionUUID->"528acbaf-215b-4b28-844c-642da2b92962",
 CellID->309390273],
Cell[77714, 1781, 214, 6, 36, "Text",ExpressionUUID->"753c1397-f46d-49f1-a84d-349acd2b2925",
 CellID->384997391],
Cell[CellGroupData[{
Cell[77953, 1791, 240, 6, 25, "Input",ExpressionUUID->"aa04e828-c00b-4ec8-96b8-fd1e1c026ab5",
 CellID->159448145],
Cell[78196, 1799, 420, 13, 54, "Output",ExpressionUUID->"b5353b61-20ad-48ff-ba0f-47a0cb6e5e08",
 CellID->767179684]
}, Open  ]],
Cell[78631, 1815, 112, 1, 36, "Text",ExpressionUUID->"9ea53311-c009-489c-9181-8daa44b4b892",
 CellID->270276300],
Cell[CellGroupData[{
Cell[78768, 1820, 127, 2, 25, "Input",ExpressionUUID->"ef041947-edaa-479a-ac6f-e67ddd620965",
 CellID->1734267],
Cell[78898, 1824, 211, 4, 36, "Output",ExpressionUUID->"2cbdce9e-54b2-4665-9b88-96bac84dd07d",
 CellID->86234154]
}, Open  ]],
Cell[79124, 1831, 164, 3, 36, "Text",ExpressionUUID->"b54af1e8-c070-4e15-95d7-b8d864deae70",
 CellID->718103005]
}, Open  ]],
Cell[CellGroupData[{
Cell[79325, 1839, 177, 2, 54, "Subsubsection",ExpressionUUID->"6f0f6eac-91da-44a0-a01c-2eea9a2867bf",
 CellID->528080467],
Cell[79505, 1843, 199, 4, 36, "Text",ExpressionUUID->"bad6115c-b74f-4457-b637-e7c8b1dcad34",
 CellID->86437159],
Cell[79707, 1849, 1154, 36, 45, "DisplayFormulaNumbered",ExpressionUUID->"98816ace-66c3-4b0e-ac2d-aa77594788c1",
 CellID->285803505],
Cell[80864, 1887, 162, 3, 36, "Text",ExpressionUUID->"8bcae073-60b8-4f40-baae-851423854a67",
 CellID->4712656],
Cell[81029, 1892, 869, 24, 60, "Text",ExpressionUUID->"9983bb52-da6e-411e-83e6-a834721a7b27",
 CellID->427412820],
Cell[CellGroupData[{
Cell[81923, 1920, 642, 21, 25, "Input",ExpressionUUID->"8bdeec39-e815-496a-8bb4-9d8454594300",
 CellID->296231045],
Cell[82568, 1943, 420, 13, 54, "Output",ExpressionUUID->"71bfb203-9c97-46ff-a9a4-3d3efe34c451",
 CellID->474025373]
}, Open  ]],
Cell[83003, 1959, 144, 1, 36, "Text",ExpressionUUID->"2db34ff6-6a88-4484-bab1-aaa6e4cbc2d5",
 CellID->134135276],
Cell[CellGroupData[{
Cell[83172, 1964, 129, 2, 25, "Input",ExpressionUUID->"148dd377-e94c-4b8a-b452-d5e37674ec86",
 CellID->212615684],
Cell[83304, 1968, 212, 4, 36, "Output",ExpressionUUID->"f0bd1c78-57e4-4f73-8b08-73a9b4b89f60",
 CellID->225867510]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83577, 1979, 130, 1, 56, "Subsection",ExpressionUUID->"37c3b783-d21e-4b51-a5c9-790f163c930d",
 CellID->321595196],
Cell[83710, 1982, 143, 1, 36, "Text",ExpressionUUID->"eeb9f0c7-3bd6-47d8-b544-8c782a57e0ad",
 CellID->409937423],
Cell[83856, 1985, 787, 22, 52, "Item",ExpressionUUID->"e7ec1e99-16e8-4db5-a6fb-675eb0113a09",
 CellID->303977933],
Cell[84646, 2009, 496, 16, 45, "DisplayFormulaNumbered",ExpressionUUID->"d4a57a06-cef4-4ca6-bf97-ef2eec877f29",
 CellID->971858],
Cell[85145, 2027, 415, 13, 30, "Item",ExpressionUUID->"0d16c035-14ec-4d16-9769-c2520b702351",
 CellID->330242352],
Cell[85563, 2042, 764, 25, 48, "DisplayFormulaNumbered",ExpressionUUID->"1c49cdf4-becb-40bd-84f1-e48f75a7135f",
 CellID->128456185],
Cell[CellGroupData[{
Cell[86352, 2071, 655, 20, 23, "ItemParagraph",ExpressionUUID->"4efdf6dd-5361-428c-a10b-893abc434c5a",
 CellID->371530895],
Cell[87010, 2093, 126, 1, 30, "Item",ExpressionUUID->"434ec2d7-5049-4c07-82f6-b85e1822a011",
 CellID->287643639]
}, Open  ]],
Cell[87151, 2097, 546, 13, 34, "DisplayFormulaNumbered",ExpressionUUID->"263fb596-96ed-49f0-9fdc-4b81afbd2d16",
 CellID->196560669],
Cell[87700, 2112, 816, 26, 23, "ItemParagraph",ExpressionUUID->"7a9eb0ad-0f9c-4e2a-9082-f49b1d3ae9e3",
 CellID->1015371295],
Cell[88519, 2140, 329, 7, 36, "Text",ExpressionUUID->"d7bad65f-a954-43fb-af2a-50b98467060f",
 CellID->355727786]
}, Open  ]],
Cell[CellGroupData[{
Cell[88885, 2152, 105, 1, 56, "Subsection",ExpressionUUID->"6bb5d8d1-6750-4817-b044-1539d7afc714",
 CellID->251702679],
Cell[88993, 2155, 187, 8, 71, "SolvedExample",ExpressionUUID->"ff5f0989-1c0f-4047-abbe-4bb6e5db09f9",
 CellID->782981345],
Cell[89183, 2165, 649, 17, 63, "SolvedExampleNote",ExpressionUUID->"2e2d6388-a585-4152-a11a-ea2699721928",
 CellID->264510557],
Cell[89835, 2184, 1319, 39, 61, "SolvedExampleNote",ExpressionUUID->"bfa5b3da-1d35-4349-b6e9-f537de9059b4",
 CellID->201170782],
Cell[91157, 2225, 1442, 39, 43, "SolvedExampleNote",ExpressionUUID->"ebc9d371-9316-4ab4-b3f9-26bec693136f",
 CellID->938546473],
Cell[92602, 2266, 261, 7, 61, "SolvedExampleNote",ExpressionUUID->"51f3cbed-1ba5-4fc8-8714-45bd5a81b946",
 CellID->477632082],
Cell[CellGroupData[{
Cell[92888, 2277, 243, 5, 25, "SolvedExampleInput",ExpressionUUID->"47d75263-30d4-4554-a1b4-6a86c749f69a",
 CellID->130584303],
Cell[93134, 2284, 114, 1, 36, "SolvedExampleOutput",ExpressionUUID->"3b1ae002-2f5b-44f7-99b3-140629d77772",
 CellID->8847827]
}, Open  ]],
Cell[93263, 2288, 153, 1, 39, "SolvedExampleNote",ExpressionUUID->"d92bbb1f-bfe3-4dd6-8440-780c6a8552e9",
 CellID->293291947],
Cell[CellGroupData[{
Cell[93441, 2293, 1432, 37, 27, "SolvedExampleInput",ExpressionUUID->"5427a16d-34b5-4a46-ac05-fa40a9d54b94",
 CellID->215134320],
Cell[94876, 2332, 44440, 758, 203, "SolvedExampleOutput",ExpressionUUID->"cbd84863-51a4-4bb0-b333-39045b71026d",
 CellID->868702115]
}, Open  ]],
Cell[139331, 3093, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"0df6a0e8-f0d7-4af7-b7a0-fd29eb3f5a1e",
 CellID->363881016],
Cell[139440, 3096, 212, 9, 71, "SolvedExample",ExpressionUUID->"126c3765-98a0-4c3d-92b8-b84253fec9cf",
 CellTags->"Example112",
 CellID->430700739],
Cell[139655, 3107, 983, 27, 63, "SolvedExampleNote",ExpressionUUID->"43bbfb4f-b057-42db-99e3-9a203e882824",
 CellID->177274235],
Cell[140641, 3136, 1365, 40, 61, "SolvedExampleNote",ExpressionUUID->"a050b28c-d157-4e99-bd3e-5502c266a2aa",
 CellID->81990820],
Cell[142009, 3178, 2670, 72, 58, "SolvedExampleNote",ExpressionUUID->"c070a2b5-09fa-4986-bee5-d7f74c1e5667",
 CellID->69425760],
Cell[144682, 3252, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"6ff0880e-331d-42e4-b05b-77ad3162936e",
 CellID->526169082],
Cell[144791, 3255, 187, 8, 71, "SolvedExample",ExpressionUUID->"a2a24d1a-30d1-48a7-8e3d-e28e72ada3af",
 CellID->314925169],
Cell[144981, 3265, 1135, 33, 63, "SolvedExampleNote",ExpressionUUID->"a6b79c50-4a02-4cf7-bc70-44bfa7eed491",
 CellID->226880252],
Cell[146119, 3300, 304, 8, 39, "SolvedExampleNote",ExpressionUUID->"59c004c8-e04f-4e27-ad48-9a67ebc167d9",
 CellID->75502952],
Cell[146426, 3310, 742, 21, 42, "SolvedExampleNote",ExpressionUUID->"9c1582e3-6226-415a-867d-817d283232e4",
 CellID->743341451],
Cell[147171, 3333, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"840a629a-1292-4763-b37f-adc97b1d07a6",
 CellID->1415271019],
Cell[147281, 3336, 187, 8, 71, "SolvedExample",ExpressionUUID->"a628e15e-43b3-4442-9f1a-caa7c27bb114",
 CellID->153931642],
Cell[147471, 3346, 784, 22, 41, "SolvedExampleNote",ExpressionUUID->"5607c355-51ed-4202-86b8-84c240fa7fb5",
 CellID->538180421],
Cell[148258, 3370, 441, 10, 61, "SolvedExampleNote",ExpressionUUID->"570243b7-4b4a-4780-93bb-cf23f4b13eb0",
 CellID->34484980],
Cell[148702, 3382, 932, 28, 45, "SolvedExampleNote",ExpressionUUID->"6ddf650a-b741-4bc3-aac2-cb50f4809574",
 CellID->14126930],
Cell[149637, 3412, 805, 25, 39, "SolvedExampleNote",ExpressionUUID->"aa7a4da6-4252-4feb-9df0-cc7c06516c7f",
 CellID->787509019],
Cell[150445, 3439, 1492, 45, 41, "SolvedExampleNote",ExpressionUUID->"2622f6ac-c082-4bfb-aa7b-9e29413bad78",
 CellID->238604914],
Cell[151940, 3486, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"026752ba-deab-4f10-a8bf-bb28ca77c8e4",
 CellID->1463241023],
Cell[152050, 3489, 187, 8, 71, "SolvedExample",ExpressionUUID->"757b5bea-a751-469f-a9eb-e878244a7e96",
 CellID->219659473],
Cell[152240, 3499, 712, 21, 41, "SolvedExampleNote",ExpressionUUID->"7d8fd023-518a-4ed7-9fc3-57ea3e598b3b",
 CellID->119113669],
Cell[152955, 3522, 837, 25, 39, "SolvedExampleNote",ExpressionUUID->"9d4eecdf-2046-4e8b-a9e1-a88070f2038b",
 CellID->226755097],
Cell[153795, 3549, 998, 31, 43, "SolvedExampleNote",ExpressionUUID->"d27a4890-00b6-44d3-b31f-689aea9429a1",
 CellID->28762006],
Cell[154796, 3582, 191, 6, 39, "SolvedExampleNote",ExpressionUUID->"b393e388-685d-439f-9e9a-56249fad9220",
 CellID->180446814],
Cell[CellGroupData[{
Cell[155012, 3592, 440, 13, 27, "SolvedExampleInput",ExpressionUUID->"22415231-1f92-4158-b050-7d5c151ea276",
 CellID->13195382],
Cell[155455, 3607, 190, 4, 54, "SolvedExampleOutput",ExpressionUUID->"ef8f911c-e843-4ac9-8ff6-db83ea295690",
 CellID->235164002]
}, Open  ]],
Cell[155660, 3614, 138, 1, 39, "SolvedExampleNote",ExpressionUUID->"c1fe4806-2a4b-4c5b-8d5c-da44cd61dc58",
 CellID->210529817],
Cell[CellGroupData[{
Cell[155823, 3619, 1456, 37, 28, "SolvedExampleInput",ExpressionUUID->"49fd6b6f-9f97-4e22-87eb-cf38327d837a",
 CellID->144449912],
Cell[157282, 3658, 49845, 845, 203, "SolvedExampleOutput",ExpressionUUID->"92b45aa7-d2d0-4e6b-bbe6-3f921fe3b241",
 CellID->569097589]
}, Open  ]],
Cell[207142, 4506, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"92c8abbe-7d3e-4eff-847f-c50904bafe1a",
 CellID->1170476267],
Cell[CellGroupData[{
Cell[207274, 4511, 109, 1, 69, "SummarySection",ExpressionUUID->"6fabdde2-9860-4fcd-b212-ba209368e2fd",
 CellID->1198545324],
Cell[207386, 4514, 170, 3, 29, "SummaryList",ExpressionUUID->"2d27fd59-4114-464f-8dc6-c74425652cc1",
 CellID->273736510],
Cell[207559, 4519, 172, 3, 29, "SummaryList",ExpressionUUID->"35a06d95-7789-48b3-b38e-d5d98d1a651e",
 CellID->508186619],
Cell[207734, 4524, 195, 4, 29, "SummaryList",ExpressionUUID->"bfa46f39-46d1-42f7-8d83-e682b95ae0d8",
 CellID->45758559],
Cell[207932, 4530, 131, 1, 29, "SummaryList",ExpressionUUID->"d5eca143-68e3-4447-8b57-afd2492e46e9",
 CellID->13594917],
Cell[208066, 4533, 538, 13, 34, "DisplayFormula",ExpressionUUID->"4651d255-31e3-415c-82ba-2ea278936da7",
 CellID->124775987]
}, Open  ]],
Cell[CellGroupData[{
Cell[208641, 4551, 158, 3, 65, "ExerciseSection",ExpressionUUID->"8e648545-f987-42ba-8107-e46ab66975d9",
 CellID->7858937],
Cell[208802, 4556, 932, 28, 31, "Exercise",ExpressionUUID->"0d2198c2-dbe8-44cf-87ac-8b23ed8f843c",
 CellID->90133499],
Cell[CellGroupData[{
Cell[209759, 4588, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"71fe1ce4-b9cc-478c-852d-752274d63358"],
Cell[209853, 4590, 602, 17, 22, "SolutionAnswer",ExpressionUUID->"0cdfddde-89d8-4bd0-9caa-f47052a0f900",
 CellID->199505212],
Cell[210458, 4609, 1476, 45, 26, "SolutionAnswer",ExpressionUUID->"2afcca1f-325e-4071-82fb-6245d57d8608",
 CellID->282017256],
Cell[211937, 4656, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"4c16801e-8a3d-46e3-ada4-4bc10140ec92",
 CellID->408431724],
Cell[CellGroupData[{
Cell[212149, 4666, 461, 14, 27, "ExerciseInput",ExpressionUUID->"6551306b-e51b-446b-b0bc-ac6a7f27a7bc",
 CellID->200129570],
Cell[212613, 4682, 206, 5, 45, "ExerciseOutput",ExpressionUUID->"de99f626-3f7a-4849-b7fb-6fac9bd4b037",
 CellID->423508579]
}, Open  ]]
}, Closed]],
Cell[212846, 4691, 939, 28, 31, "Exercise",ExpressionUUID->"876ea211-b62b-4525-91ff-0d4550f8fdf0",
 CellID->18889578],
Cell[CellGroupData[{
Cell[213810, 4723, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"1893f0ac-cfbe-48a5-8b9c-febd27877880"],
Cell[213904, 4725, 1130, 34, 22, "SolutionAnswer",ExpressionUUID->"9cd82092-3b94-4038-ac5a-c9f01f7e0a57",
 CellID->126449404],
Cell[215037, 4761, 1993, 60, 28, "SolutionAnswer",ExpressionUUID->"5c655933-fa90-48a9-ba69-3511709cbf73",
 CellID->107067571],
Cell[217033, 4823, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"bb346650-564e-41e0-a2a0-8490efd4edbe",
 CellID->275088157],
Cell[CellGroupData[{
Cell[217245, 4833, 505, 16, 49, "ExerciseInput",ExpressionUUID->"443ee07c-f258-47b0-a76f-93bbb09c373f",
 CellID->995109897],
Cell[217753, 4851, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"a731d149-3565-4da6-9c5c-aac8c0d5d8b0",
 CellID->496187958]
}, Open  ]]
}, Closed]],
Cell[217939, 4857, 1252, 36, 50, "Exercise",ExpressionUUID->"53a6db67-b9f1-468c-a142-13b0afe5b918",
 CellID->350576821],
Cell[CellGroupData[{
Cell[219216, 4897, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"9704921f-1338-4975-974f-d8d7b2c2e7eb"],
Cell[219310, 4899, 437, 12, 43, "SolutionAnswer",ExpressionUUID->"5c08ea5a-fac0-654b-a5e2-82b381ff552c",
 CellID->324560064],
Cell[CellGroupData[{
Cell[219772, 4915, 282, 8, 49, "ExerciseInput",ExpressionUUID->"89ba3c80-d291-4b17-9378-562079c0da6b",
 CellID->804729440],
Cell[220057, 4925, 274, 8, 48, "ExerciseOutput",ExpressionUUID->"07d9e7f3-7d0c-410e-9419-cd6e8e9c74bf",
 CellID->81961311]
}, Open  ]],
Cell[220346, 4936, 1156, 35, 43, "SolutionAnswer",ExpressionUUID->"47d2dc25-71a2-45e0-85ff-491511129dfd",
 CellID->412401964],
Cell[221505, 4973, 188, 6, 22, "SolutionAnswer",ExpressionUUID->"c32955d0-7d97-4839-9a91-9966808812e8",
 CellID->2029491257],
Cell[CellGroupData[{
Cell[221718, 4983, 497, 16, 49, "ExerciseInput",ExpressionUUID->"409f5b49-6591-47db-be40-17eb4d754eb0",
 CellID->13211504],
Cell[222218, 5001, 858, 16, 54, "ExerciseOutput",ExpressionUUID->"ee3ae1e7-a9d4-4173-b9e7-e159e838e2cc",
 CellID->90025083]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[223125, 5023, 558, 16, 27, "Exercise",ExpressionUUID->"6fdcfb9d-6fde-4aef-9264-3e3d8c725e1c",
 CellID->232718658],
Cell[CellGroupData[{
Cell[223708, 5043, 1408, 41, 70, "ExerciseInput",ExpressionUUID->"3b538d99-680c-44ab-bc6d-03f8fb185bd4",
 CellID->19139565],
Cell[225119, 5086, 32635, 587, 154, "ExerciseOutput",ExpressionUUID->"33fd6893-4081-44e9-a52e-64235b3f5c50",
 CellID->49745357]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[257800, 5679, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"8ea9683d-732b-4109-9147-f6f992cbaf1d"],
Cell[257894, 5681, 1159, 35, 26, "SolutionAnswer",ExpressionUUID->"8bc4a8b4-e55f-4a55-a1b1-225bac044e17",
 CellID->58419633],
Cell[259056, 5718, 1142, 34, 26, "SolutionAnswer",ExpressionUUID->"162eff70-2edd-417d-bc78-cd816dc668f6",
 CellID->494583253],
Cell[260201, 5754, 186, 6, 22, "SolutionAnswer",ExpressionUUID->"91ef95a7-9894-4cc8-87a7-eb1b9560898c",
 CellID->87074535],
Cell[CellGroupData[{
Cell[260412, 5764, 502, 15, 27, "ExerciseInput",ExpressionUUID->"ec6386b9-b020-41c8-91a9-054eccfaa5c4",
 CellID->673767498],
Cell[260917, 5781, 185, 4, 45, "ExerciseOutput",ExpressionUUID->"be520226-9bc1-43a2-9119-d3e33e8b7573",
 CellID->648079561]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[261151, 5791, 564, 16, 27, "Exercise",ExpressionUUID->"488adceb-c974-4af1-b7d2-765864e6c9d3",
 CellID->103266790],
Cell[CellGroupData[{
Cell[261740, 5811, 1406, 41, 70, "ExerciseInput",ExpressionUUID->"8380d2cc-bf2a-4b2a-8e88-d1ebc62782a2",
 CellID->67821223],
Cell[263149, 5854, 7609, 173, 136, "ExerciseOutput",ExpressionUUID->"56bb55c3-c0ef-42d9-b9a4-381689f881fd",
 CellID->220558848]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[270804, 6033, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"884a12ec-2012-459a-88c3-f23f16ac0c55"],
Cell[270898, 6035, 659, 18, 22, "SolutionAnswer",ExpressionUUID->"37c5ae1e-a38d-40b2-97ba-478bc57ed571",
 CellID->34566889],
Cell[CellGroupData[{
Cell[271582, 6057, 432, 12, 25, "ExerciseInput",ExpressionUUID->"576d0b52-2321-4de4-acdd-4e0cea6426f9",
 CellID->120521889],
Cell[272017, 6071, 472, 14, 45, "ExerciseOutput",ExpressionUUID->"3964ce9f-c61c-4961-9b6f-a737aadf71a6",
 CellID->224260997]
}, Open  ]],
Cell[272504, 6088, 606, 17, 22, "SolutionAnswer",ExpressionUUID->"92a387ba-3fcc-4d34-bd6d-b66c65a7f63b",
 CellID->583275233],
Cell[CellGroupData[{
Cell[273135, 6109, 423, 12, 25, "ExerciseInput",ExpressionUUID->"83fa4ede-b7a4-4fec-afca-1cdf662a95a4",
 CellID->136004492],
Cell[273561, 6123, 442, 13, 45, "ExerciseOutput",ExpressionUUID->"585c28b2-c547-47d6-9276-d03ac4e7d95d",
 CellID->164710003]
}, Open  ]],
Cell[274018, 6139, 114, 1, 22, "SolutionAnswer",ExpressionUUID->"a0689456-a826-4cef-b32a-0ec09d8c9e82",
 CellID->217063613],
Cell[CellGroupData[{
Cell[274157, 6144, 169, 3, 25, "ExerciseInput",ExpressionUUID->"635bd9e3-aa6f-41b8-a652-754e980c8559",
 CellID->139938030],
Cell[274329, 6149, 216, 5, 42, "ExerciseOutput",ExpressionUUID->"9f78ad0d-2ede-4aaa-9448-b41e0890b09b",
 CellID->34001278]
}, Open  ]],
Cell[274560, 6157, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"c1af0ca2-b039-4936-b679-00ca2822a6ff",
 CellID->535448003],
Cell[CellGroupData[{
Cell[274772, 6167, 509, 15, 25, "ExerciseInput",ExpressionUUID->"d8653756-529c-43f8-9b10-a90d2226c028",
 CellID->167710769],
Cell[275284, 6184, 217, 5, 42, "ExerciseOutput",ExpressionUUID->"e7bc32a9-5219-4273-bf52-a47733d1ad50",
 CellID->247436032]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[275564, 6196, 310, 6, 135, "SmallText",ExpressionUUID->"36777578-6cc5-4a4f-a99e-b6751d3ec310",
 CellGroupingRules->"SectionGrouping",
 CellID->1082123849]
}
]
*)

(* NotebookSignature oRGHYLAm8iMjiluimttAKlcj *)
