(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    464749,      10403]
NotebookOptionsPosition[    280796,       6610]
NotebookOutlinePosition[    443667,       9993]
CellTagsIndexPosition[    443624,       9990]
WindowTitle->13. Cauchy\:2019s Theorem | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Cauchy\[CloseCurlyQuote]s Theorem"
}], "Section",
 CounterAssignments->{{"Section", 12}},
 CellID->103276447,ExpressionUUID->"502dbbca-b19c-4829-8581-c6cbac3f24bd"],

Cell["\<\
This chapter will present Cauchy\[CloseCurlyQuote]s theorem. Before that, it \
will review some notions from topology and Green\[CloseCurlyQuote]s theorem.\
\>", "Text",
 CellID->846796150,ExpressionUUID->"fcb81b30-18e6-435a-97e9-52408a2d5f82"],

Cell["\<\
In real, two-variable calculus, Green\[CloseCurlyQuote]s theorem relates the \
line integral of a vector field over a closed line to an integral over the \
enclosed region:\
\>", "Text",
 CellID->45073467,ExpressionUUID->"eb3d06b8-fdab-49e8-8ae5-789cda673778"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "pts", "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.5", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.6", ",", "0.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.5", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.9", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5.2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "2.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4.5", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "3.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.4", ",", "3.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7", ",", "1.4"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"LightBlue", ",", 
          RowBox[{"EdgeForm", "[", "White", "]"}], ",", 
          RowBox[{"FilledCurve", "[", 
           RowBox[{"BSplineCurve", "[", 
            RowBox[{"pts", ",", 
             RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
             
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"Thickness", "[", "0.007", "]"}], ",", 
            RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"pts", ",", 
               RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
           "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"C", ",", "12"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"D", ",", "12"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", 
      RowBox[{"ImageSize", "->", "200"}]}], "]"}]}]}], "]"}]], "Input",
 CellID->237483354,ExpressionUUID->"c0d9bf13-9c0c-4cdb-a293-92965380aa5a"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0.87, 0.94, 1], EdgeForm[GrayLevel[1]], 
    FilledCurveBox[
     BSplineCurve[{{1.5, 1}, {2, 0.9}, {2.6, 0.6}, {3.5, 0.5}, {4.9, 1}, {
       5.2, 2}, {5, 2.9}, {4.5, 3.5}, {4, 3.9}, {3, 3.8}, {2.4, 3.3}, {2, 
       3}, {1, 2.9}, {0.5, 2}, {0.7, 1.4}}, SplineClosed -> True]], 
    {RGBColor[0.368417, 0.506779, 0.709798], Thickness[0.007], Arrowheads[
     0.07], ArrowBox[
      BSplineCurveBox[{{1.5, 1}, {2, 0.9}, {2.6, 0.6}, {3.5, 0.5}, {4.9, 1}, {
        5.2, 2}, {5, 2.9}, {4.5, 3.5}, {4, 3.9}, {3, 3.8}, {2.4, 3.3}, {2, 
        3}, {1, 2.9}, {0.5, 2}, {0.7, 1.4}},
       SplineClosed->True]]}}, InsetBox[
    StyleBox["C",
     StripOnInput->False,
     FontSize->12], {1, 1}], InsetBox[
    StyleBox["D",
     StripOnInput->False,
     FontSize->12], {3, 2}]},
  ImageSize->200]], "Output",
 TextAlignment->-0.5,
 CellID->77096893,ExpressionUUID->"3aac7fa5-1f23-4386-88bd-a506fa9a8bd9"]
}, {2}]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5272169e-91bd-4a44-a6ab-cac884fb0cac"],
 " is the vector field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"u", ",", "v"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"eb0ed310-5366-4bd7-be9f-a1dc45d27e7b"],
 ", then"
}], "Text",
 CellID->180780243,ExpressionUUID->"a36eea87-b39f-457b-a438-9b2e6752e7b2"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FormBox[
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], " ", 
     RowBox[{"f", " ", 
      RowBox[{"\[DifferentialD]", "s"}]}], "=", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SubscriptBox["\[Integral]", "D"], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"\[PartialD]", " ", "v"}], 
           RowBox[{"\[PartialD]", " ", "x"}]], "-", 
          FractionBox[
           RowBox[{"\[PartialD]", " ", "u"}], 
           RowBox[{"\[PartialD]", " ", "y"}]]}], ")"}], 
        RowBox[{"\[DifferentialD]", "x"}], " ", 
        RowBox[{
         RowBox[{"\[DifferentialD]", "y"}], "."}]}]}]}]}],
    TraditionalForm], "              ", 
   StyleBox[Cell[
    "(Green\[CloseCurlyQuote]s theorem)",ExpressionUUID->
     "0df7eace-5da0-4dcf-8d03-64f0a006abd2"], "Text"]}], 
  TextForm]], "DisplayFormula",
 CellChangeTimes->{{3.9634834516214504`*^9, 3.963483456482834*^9}},
 TextAlignment->-0.5,
 CellID->205072165,ExpressionUUID->"9c07b546-3e7d-4a9e-8daa-06dab88695fe"],

Cell["\<\
The proof of Cauchy\[CloseCurlyQuote]s theorem presented in this chapter will \
use Green\[CloseCurlyQuote]s theorem.\
\>", "Text",
 CellID->227602155,ExpressionUUID->"5ddcdf42-0ffc-4046-a4bf-5fbb2ba6161e"],

Cell[CellGroupData[{

Cell["Notions from Topology", "Subsection",
 CellID->858627792,ExpressionUUID->"b4e23837-ff72-449a-8729-e6a46b0ded26"],

Cell["Let\[CloseCurlyQuote]s introduce some definitions for later use:", \
"Text",
 CellID->144585957,ExpressionUUID->"6fbfd615-3fef-4124-b576-74f52cd7aa5b"],

Cell[TextData[{
 StyleBox["Simple curve",
  FontSlant->"Italic"],
 ":",
 " A curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Rho]", "(", "t", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9ddca4e1-e5c2-424c-a249-ee34a612aaf6"],
 " is simple if it has no self-intersections: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", 
     SubscriptBox["t", "1"], ")"}], "=", 
    RowBox[{"\[Rho]", "(", 
     SubscriptBox["t", "2"], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3cf83521-e8ea-4c76-830d-af7678db982b"],
 " only if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["t", "1"], "=", 
    SubscriptBox["t", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3c416614-5a8c-49f6-8ad5-eefa31d10ab2"],
 "."
}], "Text",
 CellID->5476449,ExpressionUUID->"2f397e09-9d9f-4464-ad54-41e043102785"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"pts", ",", "si", ",", "ip"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"pts", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"1", "/", "2"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"3", ",", 
            RowBox[{"3", "/", "2"}]}], "}"}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"si", "=", 
        RowBox[{
         RowBox[{"Accumulate", "[", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", "0", "}"}], "}"}], ",", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"#", ".", "#"}], "]"}], "&"}], ",", 
              RowBox[{
               RowBox[{"Rest", "[", "pts", "]"}], "-", 
               RowBox[{"Most", "[", "pts", "]"}]}]}], "]"}]}], "]"}], "]"}], "//",
          "Flatten"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"ip", "=", 
        RowBox[{"Interpolation", "[", 
         RowBox[{
          RowBox[{"MapThread", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", 
            RowBox[{"{", 
             RowBox[{"si", ",", "pts"}], "}"}]}], "]"}], ",", 
          RowBox[{"Method", "->", "\"\<Spline\>\""}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ParametricPlot", "[", 
        RowBox[{
         RowBox[{"ip", "[", "s", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "0", ",", 
           RowBox[{"Max", "[", "si", "]"}]}], "}"}], ",", 
         RowBox[{"Axes", "->", "False"}], ",", 
         RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Epilog", "->", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
             
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ip", "[", 
                RowBox[{
                 RowBox[{"Max", "[", "si", "]"}], "/", "2"}], "]"}], ",", 
               RowBox[{"ip", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Max", "[", "si", "]"}], "/", "2"}], "+", "0.1"}], 
                "]"}]}], "}"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", ",", 
         
         RowBox[{"ImageSize", "->", "150"}]}], "]"}]}]}], "]"}], "//", 
    RowBox[{
     RowBox[{"Labeled", "[", 
      RowBox[{"#", ",", "\"\<Fig. 1. A simple curve.\>\""}], "]"}], "&"}]}], 
   "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
   RowBox[{"Labeled", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SuperscriptBox["t", "2"], "-", "1"}], ",", 
          RowBox[{
           SuperscriptBox["t", "3"], "-", "t"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"ImageSize", "->", "150"}], ",", 
        RowBox[{"Axes", "->", "False"}], ",", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}]}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Line", "[", "x_", "]"}], ":>", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{"0.07", ",", "0.07", ",", "0.07", ",", "0."}], "}"}], 
          "]"}], ",", 
         RowBox[{"Arrow", "[", "x", "]"}]}], "}"}]}]}], 
     ",", "\"\<Fig. 2. This curve is not simple.\>\""}], "]"}]}], 
  "}"}]], "Input",
 CellID->13075533,ExpressionUUID->"baaccbe6-1e92-48f4-9a0a-c58db9a9830d"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      InterpretationBox[{
        TagBox[{{{}, {}, 
           TagBox[
            {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
             FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxd2nk01N/7APCZMYxCQihZ0irZS6nw3ChKJVS2SlFSpJCIEioqS6IoaaOI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              "]]},
            Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
         {
         "WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
        StyleBox[
         DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
               Annotation[{
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8]], 
                 Line[CompressedData["
1:eJxd2nk01N/7APCZMYxCQihZ0irZS6nw3ChKJVS2SlFSpJCIEioqS6IoaaOI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                  "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, "PlotRange" -> {{0., 3.}, {0., 1.5}},
                "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
               "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> 
               False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, "PlotRange" -> {{0., 3.}, {0., 1.5}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
              "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>],
          
          ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}],
         Selectable->False]},
       Annotation[{{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]], 
             Line[CompressedData["
1:eJxd2nk01N/7APCZMYxCQihZ0irZS6nw3ChKJVS2SlFSpJCIEioqS6IoaaOI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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{0., 3.}, {0., 1.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
           "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Epilog->{
        RGBColor[0.368417, 0.506779, 0.709798], 
        Arrowheads[0.08], 
        ArrowBox[{{1.5, 0.75}, {1.590576754172458, 0.6982904014570982}}]},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->150,
      Method->{
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None},
      PlotRange->{{0., 3.}, {0., 1.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], 
     GraphicsBox[
      InterpretationBox[{
        TagBox[{{{}, {}, 
           TagBox[
            {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
             FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJxdmnk0lO///2UtoUJEolRS1kS9K7omJKEsIVospcieshNJliwREkn2KBFp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              "]]},
            Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
         {"WolframDynamicHighlight", <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
        StyleBox[
         DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
           Slot["HighlightElements"], 
           Slot["LayoutOptions"], 
           Slot["Meta"], 
           Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
               Annotation[{
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8]], 
                 Line[CompressedData["
1:eJxdmnk0lO///2UtoUJEolRS1kS9K7omJKEsIVospcieshNJliwREkn2KBFp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                  "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{-1.5, 1.5}, {-1.5, 1.5}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
               "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  Opacity[1.], 
                  AbsoluteThickness[2], 
                  FaceForm[
                   Opacity[0.3]], 
                  RGBColor[0.24, 0.6, 0.8]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> Identity, 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ParametricPlot, "GroupHighlight" -> 
               False|>|>]]& )[<|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{-1.5, 1.5}, {-1.5, 1.5}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
              "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>],
          
          ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
           4.503599627370496*^15, -4.503599627370496*^15}}],
         Selectable->False]},
       Annotation[{{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]], 
             Line[CompressedData["
1:eJxdmnk0lO///2UtoUJEolRS1kS9K7omJKEsIVospcieshNJliwREkn2KBFp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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-1.5, 1.5}, {-1.5, 1.5}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
           "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.24, 0.6, 0.8]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
      Axes->{False, False},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->150,
      Method->{
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None},
      PlotRange->{{-1.5, 1.5}, {-1.5, 1.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.05], 
         Scaled[0.05]}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {"\<\"Fig. 1. A simple curve.\"\>", "\<\"Fig. 2. This curve is not \
simple.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1533957413,ExpressionUUID->"31e150ce-8dbd-44c2-be2b-ba0c18249829"]
}, {2}]],

Cell[TextData[{
 StyleBox["Connected region",
  FontSlant->"Italic"],
 ":",
 " A region is connected if it cannot be represented as the union of disjoint \
regions."
}], "Text",
 CellID->16304631,ExpressionUUID->"d7e01fd4-87a2-4d8b-bf8c-b8e4e5ba1e79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", "pts2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pts", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "2.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "3.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.9"}], ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.5"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.4"}], ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1.8"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1.9"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2.1"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pts2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.9", ",", "1.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.1", ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.7", ",", 
           RowBox[{"-", "0.8"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", 
           RowBox[{"-", "0.3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7"}], ",", 
           RowBox[{"-", "0.2"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"LightBlue", ",", 
              RowBox[{"EdgeForm", "[", 
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], "]"}], ",", 
              RowBox[{"FilledCurve", "[", 
               RowBox[{"BSplineCurve", "[", 
                RowBox[{"pts", ",", 
                 RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
             "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"White", ",", 
              RowBox[{"EdgeForm", "[", 
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], "]"}], ",", 
              RowBox[{"FilledCurve", "[", 
               RowBox[{"BSplineCurve", "[", 
                RowBox[{"pts2", ",", 
                 RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
             "}"}]}], "}"}], "\[IndentingNewLine]", ",", 
          RowBox[{"ImageSize", "->", "100"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\"\<Fig. 3. A connected region.\>\""}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", "pts2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pts", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.7", ",", "2.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2.6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.2", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.4", ",", "3.6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.6", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.3", ",", "0.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.3", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.1", ",", "1.6"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pts2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"4.8", ",", "2.4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.2", ",", "2.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "1.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.1", ",", "0.9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.5", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.3", ",", "1.4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4.8", ",", "1.9"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"LightBlue", ",", 
              RowBox[{"EdgeForm", "[", 
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], "]"}], ",", 
              RowBox[{"FilledCurve", "[", 
               RowBox[{"BSplineCurve", "[", 
                RowBox[{"pts", ",", 
                 RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"LightBlue", ",", 
              RowBox[{"EdgeForm", "[", 
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], "]"}], ",", 
              RowBox[{"FilledCurve", "[", 
               RowBox[{"BSplineCurve", "[", 
                RowBox[{"pts2", ",", 
                 RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
             "}"}]}], "}"}], "\[IndentingNewLine]", ",", 
          RowBox[{"ImageSize", "->", "100"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\"\<Fig. 4. The blue-shaded region is not connected.\>\""}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
  "}"}]], "Input",
 CellID->391414181,ExpressionUUID->"18d50d4e-2cd3-4d6f-92e2-fb07f51b305c"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{
       {RGBColor[0.87, 0.94, 1], EdgeForm[RGBColor[
        0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, 
       {GrayLevel[1], EdgeForm[RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{0, 1}, {0.9, 1.1}, {1.1, 0.8}, {1, 0.2}, {
           0.7, -0.8}, {-0.1, -0.3}, {-0.7, -0.2}}, SplineClosed -> True]]}},
      ImageSize->100], 
     GraphicsBox[{
       {RGBColor[0.87, 0.94, 1], EdgeForm[RGBColor[
        0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{1, 2}, {1.7, 2.5}, {2, 2.6}, {2.2, 3}, {3, 3.9}, {3.4,
            3.6}, {4, 3}, {3, 2.2}, {3.6, 1}, {3, 0.3}, {2.3, 0.2}, {
           1.3, 1}, {1.1, 1.6}}, SplineClosed -> True]]}, 
       {RGBColor[0.87, 0.94, 1], EdgeForm[RGBColor[
        0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{4.8, 2.4}, {5.2, 2.8}, {6, 1.8}, {5.1, 0.9}, {
           4.5, 1}, {4.3, 1.4}, {4.8, 1.9}}, SplineClosed -> True]]}},
      ImageSize->100]},
    {"\<\"Fig. 3. A connected region.\"\>", "\<\"Fig. 4. The blue-shaded \
region is not connected.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->395043358,ExpressionUUID->"ea3b68bf-312a-4220-bf5a-37868d3e726d"]
}, {2}]],

Cell[TextData[{
 StyleBox["Simply connected region",
  FontSlant->"Italic"],
 ":",
 " A region is simply connected if it has no \[OpenCurlyDoubleQuote]holes.\
\[CloseCurlyDoubleQuote] More formally, a region is simply connected if its \
complement is connected."
}], "Text",
 CellID->85508443,ExpressionUUID->"4f162a62-ad58-425c-88ad-d0a1c3011f7a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", "pts2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pts", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "2.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "3.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.9"}], ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.5"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.4"}], ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1.8"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1.9"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2.1"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"LightBlue", ",", 
            RowBox[{"EdgeForm", "[", 
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], "]"}], ",", 
            RowBox[{"FilledCurve", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"pts", ",", 
               RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
           "}"}], ",", 
          RowBox[{"ImageSize", "->", "100"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\"\<Fig. 5. A simply connected region.\>\""}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", "pts2"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pts", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "2.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"-", "1.5"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "3.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.9"}], ",", "1.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2.5"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3.4"}], ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "1.8"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1.9"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2.1"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pts2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.9", ",", "1.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.1", ",", "0.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0.2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.7", ",", 
           RowBox[{"-", "0.8"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.1"}], ",", 
           RowBox[{"-", "0.3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.7"}], ",", 
           RowBox[{"-", "0.2"}]}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"LightBlue", ",", 
              RowBox[{"EdgeForm", "[", 
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], "]"}], ",", 
              RowBox[{"FilledCurve", "[", 
               RowBox[{"BSplineCurve", "[", 
                RowBox[{"pts", ",", 
                 RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
             "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"White", ",", 
              RowBox[{"EdgeForm", "[", 
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], "]"}], ",", 
              RowBox[{"FilledCurve", "[", 
               RowBox[{"BSplineCurve", "[", 
                RowBox[{"pts2", ",", 
                 RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
             "}"}]}], "}"}], ",", 
          RowBox[{"ImageSize", "->", "100"}]}], "]"}], "\[IndentingNewLine]", 
        ",", "\"\<Fig. 6. This region is not simply connected.\>\""}], 
       "]"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
  "}"}]], "Input",
 CellID->215367947,ExpressionUUID->"a2c1d22c-bcb5-4a13-b15c-0e202c1a20f1"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      {RGBColor[0.87, 0.94, 1], EdgeForm[RGBColor[
       0.368417, 0.506779, 0.709798]], 
       FilledCurveBox[
        BSplineCurve[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
          1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
          2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
          0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
         True]]},
      ImageSize->100], 
     GraphicsBox[{
       {RGBColor[0.87, 0.94, 1], EdgeForm[RGBColor[
        0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, 
       {GrayLevel[1], EdgeForm[RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{0, 1}, {0.9, 1.1}, {1.1, 0.8}, {1, 0.2}, {
           0.7, -0.8}, {-0.1, -0.3}, {-0.7, -0.2}}, SplineClosed -> True]]}},
      ImageSize->100]},
    {"\<\"Fig. 5. A simply connected region.\"\>", "\<\"Fig. 6. This region \
is not simply connected.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1009077868,ExpressionUUID->"4c7a76c1-d2bd-4669-9de6-ca0f5ec544d0"]
}, {2}]],

Cell[TextData[{
 StyleBox["Homotopic paths",
  FontSlant->"Italic"],
 ":",
 " Two paths ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", "1"], "(", "t", ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"4e62687c-ba14-49f8-a0a0-02a205e48937"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Gamma]", "2"], "(", "t", ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"93db49ff-6333-40da-b266-01985fe9a87e"],
 " are homotopic in the region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "58fc0d54-0428-4980-8507-5b2a03a99e41"],
 " if they can be continuously deformed into one another without leaving the \
region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "72478e38-1e97-4f62-9d11-241414e19b7b"],
 ". We will only talk about homotopy of paths having the same endpoints."
}], "Text",
 CellID->77837169,ExpressionUUID->"d387eeeb-42c6-4ff6-a876-dd7a1eff6424"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"pts", ",", "pts2", ",", "ptsc1", ",", "ptsc2", ",", "ptsc3"}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "2.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "3.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.9"}], ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.5"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.4"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "1.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1.9"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2.1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"pts2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9", ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1", ",", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7", ",", 
         RowBox[{"-", "0.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1"}], ",", 
         RowBox[{"-", "0.3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.7"}], ",", 
         RowBox[{"-", "0.2"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"ptsc1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.7"}], ",", 
         RowBox[{"-", "0.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.3"}], ",", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1.3"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ptsc2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", 
         RowBox[{"-", "0.5"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1.3"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ptsc3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "0.8"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", 
         RowBox[{"-", "0.6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.7", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1.3"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"LightBlue", ",", 
            RowBox[{"EdgeForm", "[", 
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], "]"}], ",", 
            RowBox[{"FilledCurve", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"pts", ",", 
               RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"White", ",", 
            RowBox[{"EdgeForm", "[", 
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], "]"}], ",", 
            RowBox[{"FilledCurve", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"pts2", ",", 
               RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            
            TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
             
             "RGBColorSwatchTemplate"], ",", 
            RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
            RowBox[{"Point", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1.5"}], ",", 
               RowBox[{"-", "1"}]}], "}"}], "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Blue", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"ptsc1", ",", 
               RowBox[{"SplineClosed", "->", "False"}]}], "]"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Pink", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"ptsc2", ",", 
               RowBox[{"SplineClosed", "->", "False"}]}], "]"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Arrow", "[", 
             RowBox[{"BSplineCurve", "[", 
              RowBox[{"ptsc3", ",", 
               RowBox[{"SplineClosed", "->", "False"}]}], "]"}], "]"}]}], 
           "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"8d8284df-9c3e-4cbc-b2d2-9158c27c1d9c\"]],\
ExpressionUUID->\"e21f081d-af6d-47eb-a61f-3a939e3263d4\"]\)\>\"", ",", "12"}],
              "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", 
              RowBox[{"-", "0.5"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"557cb0e3-5c85-42e0-bd5a-6be063f9bb68\"]],\
ExpressionUUID->\"2bf802d9-41c1-4889-8664-f37e6ffc55ff\"]\)\>\"", ",", "12"}],
              "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "0.8"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"3\"], \
TraditionalForm]],ExpressionUUID->\"653e41a5-1902-4b06-a9b4-6a2efe90e75e\"]],\
ExpressionUUID->\"237e2f26-9212-4408-bce5-5106c54f3d4f\"]\)\>\"", ",", "12"}],
              "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             
             RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"\
\[CapitalOmega]\", \
TraditionalForm]],ExpressionUUID->\"c9610965-84d6-4570-ac7f-2e1d4c69305d\"]],\
ExpressionUUID->\"853f6b25-6e76-4a3f-b6f5-1dbea7bec789\"]\)\>\"", ",", "12"}],
              "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "2.5"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "->", "200"}]}], "]"}], "\[IndentingNewLine]", 
      ",", "\"\<Fig. 7. The paths \!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"5586a53d-209e-474d-b6d3-5ff77fea7504\"]],\
ExpressionUUID->\"f714d449-bdc4-466a-9622-b231a10190de\"]\) and \
\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"b512be0d-6db2-4a09-931b-1e5de548cd2e\"]],\
ExpressionUUID->\"c2532fcb-a762-4dce-9553-6455b2ecb87b\"]\) are homotopic in \
the region \
\!\(\*Cell[\"\[CapitalOmega]\",ExpressionUUID->\"c29d14a2-d74c-4581-87ce-\
65df16c3156b\"]\), but \!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"3\"], \
TraditionalForm]],ExpressionUUID->\"61250ad7-88c4-45c1-9dc2-48aac37aaad7\"]],\
ExpressionUUID->\"e760b1d3-7828-4758-9900-d143823ab4e9\"]\) is not homotopic \
to them.\>\""}], "]"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellID->444773140,ExpressionUUID->"8b9eafea-33b5-4911-a414-84bc1f672a96"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{
       {RGBColor[0.87, 0.94, 1], EdgeForm[RGBColor[
        0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{0, -3}, {1, -2.5}, {2, -1.5}, {2.2, 0}, {2, 2}, {
           1.5, 3}, {1, 3.5}, {0.5, 3}, {0, 3.1}, {-1, 3.5}, {-2, 3}, {-2, 
           2}, {-1.9, 1.5}, {-2.5, 1}, {-3, 0.3}, {-3, 
           0}, {-3.4, -1}, {-3, -1.8}, {-2, -1.9}, {-1, -2.1}}, SplineClosed -> 
          True]]}, 
       {GrayLevel[1], EdgeForm[RGBColor[0.368417, 0.506779, 0.709798]], 
        FilledCurveBox[
         BSplineCurve[{{0, 1}, {0.9, 1.1}, {1.1, 0.8}, {1, 0.2}, {
           0.7, -0.8}, {-0.1, -0.3}, {-0.7, -0.2}}, SplineClosed -> True]]}, 
       {RGBColor[0.368417, 0.506779, 0.709798], PointSize[Medium], 
        PointBox[{-1.5, -1}]}, 
       {RGBColor[0, 0, 1], 
        ArrowBox[
         BSplineCurveBox[{{-1.5, -1}, {-1.7, -0.5}, {-1.5, 0}, {-1.2, 
           0.5}, {-1.3, 0.8}, {-1, 1.3}},
          SplineClosed->False]]}, 
       {RGBColor[1, 0.5, 0.5], 
        ArrowBox[
         BSplineCurveBox[{{-1.5, -1}, {-1.2, -0.5}, {-1, 0}, {-1, 1.3}},
          SplineClosed->False]]}, 
       {RGBColor[1, 0, 0], 
        ArrowBox[
         BSplineCurveBox[{{-1.5, -1}, {-1, -0.8}, {-0.5, -0.6}, {1, -1}, {
           1.5, 0}, {1.7, 0.5}, {1.5, 1}, {1, 1.5}, {-1, 1.3}},
          SplineClosed->False]]}, InsetBox[
        StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
         StripOnInput->False,
         FontSize->12], {-2, -0.5}, NCache[
        ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], InsetBox[
        StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
         StripOnInput->False,
         FontSize->12], {-0.8, 0}, NCache[
        ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], InsetBox[
        StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"C\\\", \\\"3\\\"], TraditionalForm]]]]]\\)\"\>",
         StripOnInput->False,
         FontSize->12], {1, -1}, NCache[
        ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]], InsetBox[
        StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"\
\[CapitalOmega]\\\", TraditionalForm]]]]]\\)\"\>",
         StripOnInput->False,
         FontSize->12], {1, 2.5}, NCache[
        ImageScaled[{Rational[1, 2], Rational[1, 2]}], 
         ImageScaled[{0.5, 0.5}]]]},
      ImageSize->200]},
    {"\<\"Fig. 7. The paths \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\", \
\\\"1\\\"], TraditionalForm]]]]]\\) and \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\", \
\\\"2\\\"], TraditionalForm]]]]]\\) are homotopic in the region \
\\!\\(\\*Cell[\\\"\[CapitalOmega]\\\"]\\), but \
\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\", \
\\\"3\\\"], TraditionalForm]]]]]\\) is not homotopic to them.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->639475426,ExpressionUUID->"3eaceb25-3acc-4d9d-b238-78f4e22bc733"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cauchy\[CloseCurlyQuote]s Theorem", "Subsection",
 CellID->481980878,ExpressionUUID->"e85dc5c3-2766-4b80-ae9d-77f4a0fe645e"],

Cell["\<\
Cauchy\[CloseCurlyQuote]s theorem is a central result of complex analysis. It \
has to do with the contour integral of a function around the (closed) \
boundary of a region in which it is analytic.\
\>", "Text",
 CellID->32887749,ExpressionUUID->"75f1d3e9-f7d2-4805-aa4d-97d1c7f26d66"],

Cell[TextData[{
 StyleBox["Cauchy\[CloseCurlyQuote]s theorem",
  FontSlant->"Italic"],
 ": The theorem can be stated in two equivalent ways:"
}], "Text",
 CellID->29208502,ExpressionUUID->"a09adec8-bd75-4e9c-b0fc-5a4d0da08877"],

Cell[TextData[{
 "1. If ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1e99270f-f3ea-4171-8979-a4b37ba662c8"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "07d905ae-3091-47f1-a46e-e4d071c56964"],
 " are two contours with the same endpoints, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"09cba89c-acf9-4462-b1e6-7af50d20175b"],
 " is analytic in the region enclosed by them, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "1"]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "2"]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5b219620-6d2a-485d-8bff-edbbc86e23f8"],
 "."
}], "Text",
 CellID->1661472934,ExpressionUUID->"fafd44fb-4316-4869-b958-3546e34e4d42"],

Cell[TextData[{
 "2. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3d0726d6-8e5f-ef47-ba95-3567e6e0fd11"],
 " is analytic in a region whose boundary is the closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b9b34c7b-bf5d-9249-9c00-ce4108a210de"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "C"}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f48bc6ef-2368-4a44-a974-6b68cf9a6eee"],
 "."
}], "Text",
 CellID->148369735,ExpressionUUID->"270f027d-be29-c041-943f-0dbd80ee48c8"],

Cell[TextData[{
 "It is important to note that for the theorem to be applicable, the two \
contours ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4036493f-a211-4922-8370-757c7f8d4ddb"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "343cc4c4-5203-4fb9-a732-e9d30fb5ee4a"],
 " must be homotopic with respect to the region of analyticity of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b9c65d69-8e47-4951-b9e3-29962cff5a06"],
 "."
}], "Text",
 CellID->84184085,ExpressionUUID->"bea5fd16-8860-4958-81be-5d0f525e7912"],

Cell[TextData[{
 "Proof:",
 " The two formulations are equivalent because the closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6b90fa26-9e9b-4b29-8da6-667fb8733821"],
 " can be split into two curves and vice versa."
}], "Text",
 CellID->539209502,ExpressionUUID->"9baf7385-59ba-410c-8360-4cb6ef0f3235"],

Cell[TextData[{
 "To prove the second formulation, start from the definition of a contour \
integral. According to the third definition of a contour integral, which was \
stated in ",
 ButtonBox["Chapter 11",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "=", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"v", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2d2ec7d2-3a4c-4b65-ac12-16dd07fe0e49"],
 " one has"
}], "Text",
 CellID->91022667,ExpressionUUID->"729c1b27-9109-40de-ac85-de658ea3e4ec"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SubscriptBox["\[ContourIntegral]", 
        RowBox[{"\[ThinSpace]", "C"}]], 
       RowBox[{
        RowBox[{"f", "(", "z", ")"}], 
        RowBox[{"\[DifferentialD]", "z"}]}]}], "\[AlignmentMarker]", "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["\[ContourIntegral]", 
         RowBox[{"\[ThinSpace]", "C"}]], 
        RowBox[{"u", " ", 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "-", 
       RowBox[{"v", 
        RowBox[{"\[DifferentialD]", "y"}]}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{
         SubscriptBox["\[ContourIntegral]", 
          RowBox[{"\[ThinSpace]", "C"}]], 
         RowBox[{"u", " ", 
          RowBox[{"\[DifferentialD]", "y"}]}]}]}], "+", 
       RowBox[{"v", " ", 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          SubscriptBox["\[Integral]", 
           RowBox[{"\[ThinSpace]", 
            RowBox[{"int", "(", "C", ")"}]}]], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              FractionBox[
               RowBox[{"\[PartialD]", "u"}], 
               RowBox[{"\[PartialD]", "y"}]]}], "-", 
             FractionBox[
              RowBox[{"\[PartialD]", "v"}], 
              RowBox[{"\[PartialD]", "x"}]]}], ")"}], 
           RowBox[{"\[DifferentialD]", "x"}], " ", 
           RowBox[{"\[DifferentialD]", "y"}]}]}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"\[Integral]", 
          RowBox[{
           SubscriptBox["\[Integral]", 
            RowBox[{"\[ThinSpace]", 
             RowBox[{"int", "(", "C", ")"}]}]], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{"\[PartialD]", "u"}], 
                RowBox[{"\[PartialD]", "x"}]]}], "+", 
              FractionBox[
               RowBox[{"\[PartialD]", "v"}], 
               RowBox[{"\[PartialD]", "y"}]]}], ")"}], 
            RowBox[{"\[DifferentialD]", "x"}], " ", 
            RowBox[{"\[DifferentialD]", "y"}], " ", Cell[
            "  by Green\[CloseCurlyQuote]s theorem",ExpressionUUID->
             "ec80806f-ca56-44ae-aa79-4c364218ab2b"]}]}]}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", " ", 
       RowBox[{
        RowBox[{"0", "            ", "by", " ", "the", " ", "Cauchy"}], "-", 
        RowBox[{"Riemann", " ", 
         RowBox[{"equations", "."}]}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormula",
 CellID->46846808,ExpressionUUID->"be4d800e-5c55-4972-81cb-dc0efa19b84e"],

Cell[TextData[{
 "Here, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"int", "(", "C", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"52c9de68-f858-4e69-87ab-341f25766e41"],
 " refers to the interior of the region bounded by ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "58e03fea-f794-49c1-b308-51c31ea25e4a"],
 "."
}], "Text",
 CellID->342970093,ExpressionUUID->"de02ae09-e944-4fe2-a58c-d125284c188b"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->384742129,ExpressionUUID->"3f5c23f7-4aaf-463a-a4a9-27ea10877cf4"],

Cell[TextData[{
 "Consider Fig. 7. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6ee0b761-12dc-4532-b68d-1042cc4566b0"],
 " is analytic in the blue-shaded region but not in the white region, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "1"]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "2"]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"61bfb319-2d5d-47aa-bf12-fc8fe198fed2"],
 " by Cauchy\[CloseCurlyQuote]s theorem. The integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "3"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f72c2ba0-6a8e-49c4-86a7-1d197c8f9b21"],
 " is not necessarily the same."
}], "SolvedExampleNote",
 CellID->189638086,ExpressionUUID->"3f3368ae-fdf7-4f68-9c76-39923e03218c"],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"f6a9b326-03ae-45e2-9284-77bf506597e5"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->258066178,ExpressionUUID->"cfeda370-fadf-423c-8691-162f3262e67b"],

Cell[TextData[{
 "Check that the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9dccc9c0-e3c7-4773-9781-cb3d54a0cae9"],
 " has the same value over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dc40132a-429e-4897-a90c-01fe5d1cacca"],
 " and over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "92f7c0a5-23c6-4ed0-b0e8-089ee98b3c7c"],
 "."
}], "SolvedExampleNote",
 CellID->51880908,ExpressionUUID->"fda567f1-cad8-4b76-988e-5b96a82d5d7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "@", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "/", "2"}], "+", "0.05"}], ",", 
          RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Arrow", "@", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"e7604b92-5c89-4d95-8a9a-64f9eb76e832\"]],\
ExpressionUUID->\"0e781dd8-b4c1-4aa1-97fc-bc592d13bd5b\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"d6e7cda2-45c8-4f6e-82d6-003b254a6e7d\"]],\
ExpressionUUID->\"08c0f38d-42db-43be-a760-5e34cb0178eb\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "SolvedExampleInput",
 CellID->47075353,ExpressionUUID->"fa6a6c78-a5de-43dd-8666-4888c818831d"],

Cell[BoxData[
 GraphicsBox[{
   ArrowBox[CircleBox[{0, 0}, 1, 
     NCache[{-1.5207963267948965`, Rational[1, 2] Pi}, {-1.5207963267948965`, 
      1.5707963267948966`}]]], ArrowBox[LineBox[{{0, -1}, {0, 1}}]], 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
    NCache[ImageScaled[{Rational[3, 2], Rational[1, 2]}], 
     ImageScaled[{1.5, 0.5}]]], InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{1, Rational[1, 2]}, {1, 0.5}], NCache[
    ImageScaled[{0.25, Rational[1, 2]}], ImageScaled[{0.25, 0.5}]]]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  ImageSize->200,
  PlotRange->{{-1, 2.5}, {-1.5, 1.5}}]], "SolvedExampleOutput",
 CellID->55037307,ExpressionUUID->"3a9b3fe1-3069-4f49-a5c6-45cf867d5ca8"]
}, {2}]],

Cell[TextData[{
 "The integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1e9b7d32-bd08-4df8-8ae9-652b64a7502e"],
 " is:"
}], "SolvedExampleNote",
 CellID->473923942,ExpressionUUID->"d1056c7f-5404-4f79-9180-bc1c2eca07e4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}]}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->44264937,ExpressionUUID->"99c1c121-3463-470a-b1a9-846d22cc7a50"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcCot", "[", "2", "]"}]}]}], ")"}]}]], "SolvedExampleOutput",
 CellID->64717703,ExpressionUUID->"eda18960-65f6-449c-9fac-d15995cf1d62"]
}, Open  ]],

Cell[TextData[{
 "The integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7cba1df2-0e8c-4f8e-9581-6f8ebd472165"],
 " is:"
}], "SolvedExampleNote",
 CellID->25813259,ExpressionUUID->"531d7d4d-f442-42ea-9934-477e703316b6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}]}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->256771591,ExpressionUUID->"beb4b764-e763-4b2c-95cd-5d0138a3b0dd"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"ArcTan", "[", "2", "]"}]}]], "SolvedExampleOutput",
 CellID->295238491,ExpressionUUID->"28760df7-1712-4055-97f0-ee1547a101c5"]
}, Open  ]],

Cell[TextData[{
 "The two are the same because ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1e5bc207-c6f3-4551-af11-4a977ddb0ea7"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9bf7e1dc-165d-4dce-babb-1d2e14cba120"],
 " can be deformed into one another without crossing the points ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "2"}], ",", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "60836e27-1289-42ca-a69e-7b431fce2620"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0633fca8-f91b-47cc-8190-8bf85eb751cc"],
 " is not analytic:"
}], "SolvedExampleNote",
 CellID->475873205,ExpressionUUID->"d609fe20-5b38-44ed-a0dd-70ea99516a37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i1", "-", "i2"}], "//", "FullSimplify"}]], "SolvedExampleInput",
 CellID->566207344,ExpressionUUID->"ec87a42a-d6d5-4a98-a57f-1b2288b04464"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->25077753,ExpressionUUID->"718d4389-0c5f-4ebe-85d9-0f8b18473517"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1872388982,ExpressionUUID->"bc155def-077c-4e56-8efc-aa08759e49c0"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->58502825,ExpressionUUID->"98638687-d5af-4321-9ec1-c74ed148c902"],

Cell[TextData[{
 "Check Cauchy\[CloseCurlyQuote]s theorem for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f5589b84-cfdc-4880-9036-8aea1bfb8479"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "1"], ",", 
    SubscriptBox["C", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e45df447-d925-4301-94e2-223125ad264a"],
 " as in the figure."
}], "SolvedExampleNote",
 CellID->322016262,ExpressionUUID->"6b20e694-5b55-4065-ba8e-3c8b698b65a0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "@", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Pi", "/", "2"}], "+", "0.05"}], ",", 
          RowBox[{"3", 
           RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Arrow", "@", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"0bcab6c2-0358-4f11-b33b-8e34c4fbe1b9\"]],\
ExpressionUUID->\"3b069880-2d7c-48cc-88cc-835733163208\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"1efd916e-ad8a-497c-a7d2-e5d147d14f44\"]],\
ExpressionUUID->\"bee6b96e-635e-4e67-a636-1f7f3e5f000c\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.2", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "SolvedExampleInput",
 CellID->1020705185,ExpressionUUID->"550d1efa-e8dc-45c3-90d5-cccc2c9016c7"],

Cell[BoxData[
 GraphicsBox[{
   ArrowBox[CircleBox[{1, 0}, 1, 
     NCache[{1.6207963267948966`, Rational[3, 2] Pi}, {1.6207963267948966`, 
      4.71238898038469}]]], ArrowBox[LineBox[{{1, 1}, {1, -1}}]], InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {0.5, 0.4}, NCache[
    ImageScaled[{1, Rational[1, 2]}], ImageScaled[{1, 0.5}]]], InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{1.2, Rational[1, 2]}, {1.2, 0.5}], NCache[
    ImageScaled[{Rational[1, 2], Rational[1, 2]}], ImageScaled[{0.5, 0.5}]]]},
  
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  ImageSize->200,
  PlotRange->{{-1, 2.5}, {-1.5, 1.5}}]], "SolvedExampleOutput",
 CellID->74884816,ExpressionUUID->"16397630-ad4a-4520-83fb-b304bb21cedc"]
}, {2}]],

Cell[TextData[{
 "The integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "78bc59a3-4615-4132-8357-e21381feea51"],
 " is:"
}], "SolvedExampleNote",
 CellID->77209998,ExpressionUUID->"efb272bb-ef1c-4b33-bfc0-c2861eeab024"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], "2"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Pi]", "/", "2"}], ",", 
        RowBox[{"3", 
         RowBox[{"\[Pi]", "/", "2"}]}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->150025850,ExpressionUUID->"b7404084-f50d-4aa8-b436-48fc50569812"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}]], "SolvedExampleOutput",
 CellID->40510553,ExpressionUUID->"e2eabca1-a6f0-4fdb-9cc7-c74f8f9530e2"]
}, Open  ]],

Cell[TextData[{
 "The integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "345786f6-6d73-405a-a4a5-07554db02dc2"],
 " is:"
}], "SolvedExampleNote",
 CellID->57913166,ExpressionUUID->"fc9d8ca1-4b87-4ffe-96a1-3a31d7a84d0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], "2"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->174979517,ExpressionUUID->"d0a494f6-e0d4-4297-8c95-00d188c76200"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}]], "SolvedExampleOutput",
 CellID->384409596,ExpressionUUID->"10770f1f-42bc-464f-a93d-632824111a27"]
}, Open  ]],

Cell["\<\
They are equal due to Cauchy\[CloseCurlyQuote]s theorem, because the \
integrand is analytic in the region enclosing the two curves:\
\>", "SolvedExampleNote",
 CellID->330379225,ExpressionUUID->"9da59460-fb6a-45b7-8296-f3d9a9f0e198"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionAnalytic", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "2"]], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "<=", "1"}], "&&", 
      RowBox[{
       RowBox[{"Re", "[", "z", "]"}], "<=", "1"}]}]}], "}"}], ",", "z", ",", 
   "Complexes"}], "]"}]], "SolvedExampleInput",
 CellID->210860994,ExpressionUUID->"d7afa0ab-5fef-46a2-afcf-0d3579c0beb7"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->14405294,ExpressionUUID->"dca40692-d602-448e-b4e0-73d91bf1c48c"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1081416579,ExpressionUUID->"5ced8c77-211e-457d-9165-5f85f6ee2b74"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->42126189,ExpressionUUID->"7fa2ebe0-bb42-42bf-bc74-76ceac410879"],

Cell[TextData[{
 "Check that the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "2"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b145f985-c6dd-4ebc-b73b-eec826c42120"],
 " over the contour in the figure is zero."
}], "SolvedExampleNote",
 CellID->179515144,ExpressionUUID->"576c0bc4-1ede-4a67-8cf6-ba0dd29709c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "/", "2"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], "/", "2"}], ",", "0"}], "}"}]}], "}"}], "]"}], 
     ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"3", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "10"]}], ",", 
          RowBox[{"3", "/", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "10"], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->252468565,ExpressionUUID->"b69466e3-0d1c-4e7d-8866-17e8df6434d8"],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}, 1, NCache[{0, Pi}, {0, 3.141592653589793}]], 
   CircleBox[{0, 0}, 1.5, NCache[{0, Pi}, {0, 3.141592653589793}]], 
   LineBox[NCache[{{1, 0}, {Rational[3, 2], 0}}, {{1, 0}, {1.5, 0}}]], 
   LineBox[NCache[{{-1, 0}, {Rational[-3, 2], 0}}, {{-1, 0}, {-1.5, 0}}]], 
   ArrowBox[NCache[{{0, Rational[3, 2]}, {
      Rational[-1, 10], Rational[3, 2]}}, {{0, 1.5}, {-0.1, 1.5}}]], 
   ArrowBox[NCache[{{0, 1}, {Rational[1, 10], 1}}, {{0, 1}, {0.1, 1}}]]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  PlotRange->{{-2.5, 2.5}, {-1, 2}}]], "SolvedExampleOutput",
 CellID->566869378,ExpressionUUID->"314d15b9-69f0-433e-b714-a4eee13f3eb3"]
}, {2}]],

Cell[TextData[{
 "This is due to Cauchy\[CloseCurlyQuote]s theorem, because the integration \
path is closed and the integrand is analytic inside it. Using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->811987227,ExpressionUUID->"9ecf65d1-6308-486a-a975-f70077c4175f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "-", "1"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "2"}], ")"}], "2"]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"3", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->340484015,ExpressionUUID->"8c33bb8c-3772-4bc8-9fd7-4c2b6c9889a8"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->198075243,ExpressionUUID->"00d7f115-33d5-4902-897e-178f476083b3"]
}, Open  ]],

Cell["Check the analyticity inside the curve:", "SolvedExampleNote",
 CellID->70795190,ExpressionUUID->"3347e7e5-f2af-4eb3-bc66-359da2c4e5cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionAnalytic", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"z", "-", "1"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "2"}], ")"}], "2"]], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", "z", "]"}], ",", 
        RowBox[{"Im", "[", "z", "]"}]}], "}"}], "\[Element]", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"3", "/", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}]}]}], "}"}], ",", "z", ",",
    "Complexes"}], "]"}]], "SolvedExampleInput",
 CellID->105740634,ExpressionUUID->"70b50238-b50d-4ca6-9e84-160c6655b9a0"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->236883237,ExpressionUUID->"921c0282-27dd-43b6-b2b0-9978bc675554"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->584189319,ExpressionUUID->"882b2338-95a9-4488-a05b-efa72bda6763"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->149379374,ExpressionUUID->"b9099892-96a0-4942-a61e-8f6137e21f53"],

Cell[TextData[{
 "Does Cauchy\[CloseCurlyQuote]s theorem guarantee that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"639ebc58-a421-4acc-bc4a-f0d41c0357fc"],
 " is zero over a circle of radius one centered at the origin?"
}], "SolvedExampleNote",
 CellID->75268082,ExpressionUUID->"7f82e25b-0b10-49c0-b918-2667778cd731"],

Cell[TextData[{
 "Yes, because ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", "z"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"80722c3f-3301-42ad-85c7-9143d3c949fb"],
 " is analytic inside the circle, so:"
}], "SolvedExampleNote",
 CellID->251781873,ExpressionUUID->"922b0fb6-5f9c-4379-b54b-e9859e76594a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "z", "]"}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->59604454,ExpressionUUID->"4cad5889-e6ee-4e76-95ca-9e8b32993548"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->71599171,ExpressionUUID->"8e04b57d-8a4b-4b82-b8bc-89a54684b967"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1444010409,ExpressionUUID->"72fdc847-d721-4cc8-8ff4-9c21aeb7805f"],

Cell["A consequence of Cauchy\[CloseCurlyQuote]s theorem is the following:", \
"Text",
 CellID->18023024,ExpressionUUID->"83e71bfe-31e1-461e-abf8-d054b549e08b"],

Cell[TextData[{
 "Theorem:",
 " If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0adac82b-1690-4748-acd8-08011262776d"],
 " is analytic in a simply connected region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "3126095e-3787-49ce-a676-9bf46c121dd3"],
 ", then it has an antiderivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "z", ")"}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "w", ")"}], 
      RowBox[{"\[DifferentialD]", "w"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"dd465cdb-72cf-445b-9717-64864a2c4dd8"],
 " with ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d6aca531-fea0-43f9-91e3-2717b08896a4"],
 " joining any point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Element]", "\[CapitalOmega]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"d90661fc-9929-43d7-b659-cea9400332b1"],
 " to ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "4d6418aa-4150-4ac1-a135-f0bac034dd97"],
 "."
}], "Text",
 CellID->260214723,ExpressionUUID->"5b1b4a8d-4ffb-4c48-ae9f-9fc043216998"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "pts", ",", "ip", ",", "si", ",", "pts2", ",", "si2", ",", "ip2", ",", 
       "pts3", ",", "si3", ",", "ip3"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pts", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "2.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "5.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "8.5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "10.8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "11.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "11.3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "11"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.7", ",", "10"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.6", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.7", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.8", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "0.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0.6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"pts2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2.5", ",", "4.7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.5", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.4", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "8"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"si2", "=", 
       RowBox[{
        RowBox[{"Accumulate", "[", 
         RowBox[{"Join", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", "0", "}"}], "}"}], ",", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"#", ".", "#"}], "]"}], "&"}], ",", 
             RowBox[{
              RowBox[{"Rest", "[", "pts2", "]"}], "-", 
              RowBox[{"Most", "[", "pts2", "]"}]}]}], "]"}]}], "]"}], "]"}], "//",
         "Flatten"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"ip2", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{
         RowBox[{"MapThread", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", 
           RowBox[{"{", 
            RowBox[{"si2", ",", "pts2"}], "}"}]}], "]"}], ",", 
         RowBox[{"Method", "->", "\"\<Spline\>\""}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"LightBlue", ",", 
             RowBox[{"EdgeForm", "[", 
              TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
               "RGBColorSwatchTemplate"], "]"}], ",", 
             RowBox[{"FilledCurve", "[", 
              RowBox[{"BSplineCurve", "[", 
               RowBox[{"pts", ",", 
                RowBox[{"SplineClosed", "->", "True"}]}], "]"}], "]"}]}], 
            "}"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"\"\<\[CapitalOmega]\>\"", ",", "14"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3.2", ",", "10"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Pink", ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"2", ",", "4"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Pink", ",", 
             RowBox[{"Point", "[", 
              RowBox[{"{", 
               RowBox[{"4", ",", "8"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"z", ",", "14"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"4", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"a", ",", "14"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1.5"}], "}"}]}], "]"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"ParametricPlot", "[", 
           RowBox[{
            RowBox[{"ip2", "[", "s", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"s", ",", "0", ",", 
              RowBox[{"Max", "[", "si2", "]"}]}], "}"}], ",", 
            RowBox[{"Axes", "->", "False"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
              "RGBColorSwatchTemplate"], ",", 
             RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
             RowBox[{"Arrow", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"ip2", "[", 
                 RowBox[{
                  RowBox[{"Max", "[", "si2", "]"}], "/", "2"}], "]"}], ",", 
                RowBox[{"ip2", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Max", "[", "si2", "]"}], "/", "2"}], "+", "0.1"}],
                  "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{"C", ",", "14"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"3.7", ",", "4.8"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"ImageSize", "->", "Small"}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
   RowBox[{"\"\<Fig. 8. A path contained in the region \[CapitalOmega] where \
\>\"", "<>", 
    RowBox[{"ToString", "[", 
     RowBox[{"f", ",", "TraditionalForm"}], "]"}], 
    "<>", "\"\< is analytic. \>\""}]}], "]"}]], "Input",
 CellChangeTimes->{3.9629407051007366`*^9},
 CellID->231178595,ExpressionUUID->"ee97bef5-3dc3-46bd-8c0a-82026abd4587"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.87, 0.94, 1], 
      EdgeForm[
       RGBColor[0.368417, 0.506779, 0.709798]], 
      FilledCurveBox[
       BSplineCurve[{{1, 1.7}, {0.5, 2.5}, {0.5, 5.5}, {1, 6.1}, {2, 8.5}, {
         3, 10.8}, {4, 11.1}, {5, 11.3}, {6, 11}, {6.7, 10}, {6.6, 9}, {6, 
         8}, {5.7, 7}, {5.8, 6}, {6, 5}, {6.4, 4}, {6.5, 3}, {6, 2}, {5, 1}, {
         4, 0.7}, {3, 0.6}, {2, 1}}, SplineClosed -> True]]}, 
     InsetBox[
      StyleBox[
      "\"\[CapitalOmega]\"", StripOnInput -> False, FontSize -> 14], {
      3.2, 10}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]], {
      RGBColor[1, 0.5, 0.5], 
      PointSize[Medium], 
      PointBox[{2, 4}]}, {
      RGBColor[1, 0.5, 0.5], 
      PointSize[Medium], 
      PointBox[{4, 8}]}, 
     InsetBox[
      StyleBox["z", StripOnInput -> False, FontSize -> 14], {4, 8}, 
      ImageScaled[{1, -0.25}]], 
     InsetBox[
      StyleBox["a", StripOnInput -> False, FontSize -> 14], {2, 4}, 
      ImageScaled[{1, 1.25}]], 
     InterpretationBox[{
       TagBox[{{{}, {}, 
          TagBox[{
            RGBColor[0.24, 0.6, 0.8], 
            AbsoluteThickness[2], 
            Opacity[1.], 
            FaceForm[
             Opacity[0.3]], 
            LineBox[CompressedData["
1:eJw92nk0VV/YB/CrZDqGS7gH594bhZBkFpWveR4apLlEUsaSSiFNaJ4oM6k0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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
        "WolframDynamicHighlight", <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
       StyleBox[
        DynamicBox[
         (Charting`HighlightActionBox["DynamicHighlight", {}, 
          Slot["HighlightElements"], 
          Slot["LayoutOptions"], 
          Slot["Meta"], 
          Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8]], 
                Line[CompressedData["
1:eJw92nk0VV/YB/CrZDqGS7gH594bhZBkFpWveR4apLlEUsaSSiFNaJ4oM6k0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                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, "PlotRange" -> {{2., 4.}, {4., 8.}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {2., 4.}, "ImageSize" -> {360, 432}, 
              "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> 
              False|>|>]]& )[<|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{2., 4.}, {4., 8.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {2., 4.}, "ImageSize" -> {360, 432}, 
             "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.24, 0.6, 0.8]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
         ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
          4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
        False]}, 
      Annotation[{{{{}, {}, 
          Annotation[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.24, 0.6, 0.8]], 
            Line[CompressedData["
1:eJw92nk0VV/YB/CrZDqGS7gH594bhZBkFpWveR4apLlEUsaSSiFNaJ4oM6k0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             "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{2., 4.}, {4., 8.}}, 
          "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {2., 4.}, "ImageSize" -> {360, 432}, 
          "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
          Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.24, 0.6, 0.8]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>, 
       "DynamicHighlight"]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Arrowheads[0.08], 
      ArrowBox[{{3.475648520965598, 5.7973548825285555`}, {3.491657870518325, 
       5.901237326074515}}]}, 
     InsetBox[
      StyleBox["C", StripOnInput -> False, FontSize -> 14], {3.7, 4.8}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 
         Rational[1, 2]}], 
       ImageScaled[{0.5, 0.5}]]]}, ImageSize -> Small], 
   "\"Fig. 8. A path contained in the region \[CapitalOmega] where \
\\!\\(\\*FormBox[\\\"f\\\", TraditionalForm]\\) is analytic. \""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.9629407064992237`*^9},
 CellID->74950417,ExpressionUUID->"437c2242-3946-6c41-8e1f-612ca59f6b23"]
}, {2}]],

Cell["\<\
This theorem can be considered the equivalent of the first fundamental \
theorem of calculus but for complex functions.\
\>", "Text",
 CellID->622645828,ExpressionUUID->"82bee58a-04b0-48db-9440-64b8842c202e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->139603462,ExpressionUUID->"19063070-ba22-425e-9bad-3b4578aa4e93"],

Cell[TextData[{
 "Consider the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{"sin", "\[InvisibleSpace]", "z"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"d3aafd14-6e8b-411e-b749-f9fa702e2b97"],
 ". Check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "z", ")"}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "w", ")"}], 
      RowBox[{"\[DifferentialD]", "w"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"07e662b8-a32f-4d9f-8e80-276b100f34a3"],
 " over a line ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "69998f73-a1f8-4cba-b6b3-a75f419dab12"],
 " from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"2", "\[ImaginaryI]"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8847e3e0-bfd2-4064-a1c2-2adc03bb6951"],
 " to the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "y"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "089ae093-fe45-4ce4-b592-6aeaa518171d"],
 " is an antiderivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"919c369c-a960-4344-92eb-20ba780995d1"],
 "."
}], "SolvedExampleNote",
 CellID->56196420,ExpressionUUID->"89cff5bb-9d16-4f85-b11d-fbccf4357e48"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "2"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"1", "/", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"a", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"z", ",", "12"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "w", "]"}], ",", 
      RowBox[{"Im", "[", "w", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "}"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->178699379,ExpressionUUID->"3854742e-c0a6-40dc-8a46-f9217ae1d763"],

Cell[BoxData[
 GraphicsBox[{
   LineBox[NCache[{{-1, -2}, {1, Rational[1, 2]}}, {{-1, -2}, {1, 0.5}}]], 
   PointBox[NCache[{{-1, -2}, {1, Rational[1, 2]}}, {{-1, -2}, {1, 0.5}}]], 
   InsetBox[
    StyleBox["a",
     StripOnInput->False,
     FontSize->12], {-1, -2}, ImageScaled[{1, 1}]], InsetBox[
    StyleBox["z",
     StripOnInput->False,
     FontSize->12], NCache[{1, Rational[1, 2]}, {1, 0.5}], 
    ImageScaled[{0, 0}]]},
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "w", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "w", ")"}], TraditionalForm]},
  AxesStyle->Directive[12],
  PlotRange->{{-3, 3}, {-3, 2}}]], "SolvedExampleOutput",
 CellID->27802434,ExpressionUUID->"d8fa64e7-309f-45e2-9440-ba25dd0c8e21"]
}, {2}]],

Cell[TextData[{
 "Using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->769229553,ExpressionUUID->"bd96d8a6-ad5a-42fa-98a1-d09cb37fb748"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "[", "z_", "]"}], "=", 
  RowBox[{
   RowBox[{"ContourIntegrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "w", "]"}], ",", 
     RowBox[{"w", "\[Element]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}]}], "}"}], "]"}]}]}], "]"}], "/.", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "->", 
    "z"}]}]}]], "SolvedExampleInput",
 CellID->245562541,ExpressionUUID->"78791ef6-12c6-4ea7-9ae2-fecfa730ff96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], "]"}], "-", 
  RowBox[{"Cos", "[", "z", "]"}]}]], "SolvedExampleOutput",
 CellID->155321303,ExpressionUUID->"44147d09-c264-4d6e-ae3e-8dc761a8b197"]
}, Open  ]],

Cell[TextData[{
 "So for this choice of ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath",ExpressionUUID->
  "31b445a3-9547-4e4d-b096-4d5298fdc5b0"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"cos", "(", 
      RowBox[{"1", "+", 
       RowBox[{"2", "\[ImaginaryI]"}]}], ")"}], "-", 
     RowBox[{"cos", "\[InvisibleSpace]", "z"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"43fa0881-61e7-4877-9739-d1e4eddabe06"],
 ". We can check that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ad750477-2aac-4427-b6a8-4a07b3cd4df9"],
 " is an antiderivative of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8e6aab32-d380-4604-87a4-2d74755f92c9"],
 " using ",
 ButtonBox["D",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->83955897,ExpressionUUID->"3fe996ca-8b34-4351-8045-3fe52e56755f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"F", "[", "z", "]"}], ",", "z"}], "]"}]], "SolvedExampleInput",
 CellID->658868197,ExpressionUUID->"c9454e0f-4727-42fe-9279-ca404d696f7d"],

Cell[BoxData[
 RowBox[{"Sin", "[", "z", "]"}]], "SolvedExampleOutput",
 CellID->132094026,ExpressionUUID->"bacc8f98-33fa-4857-a0be-fbd54d94a3a3"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->2121009758,ExpressionUUID->"efd368ed-f109-42c4-a39d-4c64c07c338e"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"fd345a40-afe2-482b-acfc-d0a2ae00a691"],

Cell["Cauchy\[CloseCurlyQuote]s theorem has two equivalent formulations:", \
"SummaryList",
 CellID->426237,ExpressionUUID->"950b1152-ed35-48dc-89d0-220e42d69ed8"],

Cell["\<\
The integral over a closed curve of a function that is analytic in a region \
containing all of the curve and its interior is zero.\
\>", "SummaryList",
 CellMargins->{{105, 12}, {4, 4}},
 FontSize->13,
 CellID->15188509,ExpressionUUID->"d1bcbabd-baa3-47e8-b4d0-830efff98191"],

Cell["\<\
The integral, taken over two paths homotopic in the analyticity region of the \
integrand and having the same endpoints, is the same.\
\>", "SummaryList",
 CellMargins->{{105, 12}, {4, 4}},
 FontSize->13,
 CellID->2085339,ExpressionUUID->"7e08d3cb-a4f3-4fd8-bf68-50e508f84538"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a9d39df3-157f-498f-b966-58e9d0be25a6"],
 " is analytic in ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d0735b43-77e7-4080-9c30-bc9ae390affd"],
 " simply connected, then it has antiderivative ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"F", "(", "z", ")"}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "w", ")"}], 
      RowBox[{"\[DifferentialD]", "w"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"343b3cc5-ae99-4965-8eeb-33b4ea854b5e"],
 " with ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "229da20f-61a9-4970-a6d2-29b1fa5d2829"],
 " joining any point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Element]", "\[CapitalOmega]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"22d5f179-de2d-40af-8b33-55c35cfac038"],
 " to ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "399a3b97-b4cd-4279-a8be-a9dc8eaa92e3"],
 "."
}], "SummaryList",
 CellID->418720821,ExpressionUUID->"9de4580a-99b9-41c0-bbec-f7041f420a08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->131710622,ExpressionUUID->"50478647-2f47-424f-934a-c48684725704"],

Cell[TextData[{
 "True or false: For the following integrals, Cauchy\[CloseCurlyQuote]s \
theorem guarantees that the result is zero:\n1) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f7676fb1-1ac5-415b-ac60-d02962075581"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "20a574a7-a54d-410f-8f23-99ada0dab697"],
 " is a circle of radius 1 around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9087debb-9336-48aa-a5f1-463e44f0f88e"],
 "\n2) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox["1", "z"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8719bc97-b1d2-49e1-bdfe-fe725c49c6c7"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f4f42208-327d-4d88-9ebe-7c53adec38cd"],
 " is a circle of radius 1 around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "221820a7-1660-4bc5-afc9-8e52a1236246"],
 "\n3) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["z", "2"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b072b11b-e5f2-4cfa-a865-8c93969e7734"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6a6c1972-fef3-421f-907a-f3c308c1442f"],
 " is a circle of radius 1 around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7edcce2d-230b-4851-b741-875923bf884c"],
 "\n4) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", "C"], 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["z", "2"]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c67bf51c-f3d3-48e5-8670-0d34b39f520d"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "3f428d35-8845-47ac-a0fc-a50845148938"],
 " is a circle of radius 1 around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bc16d341-0606-4595-b220-d53d5b1e5fb8"]
}], "Exercise",
 LineSpacing->{1.2500000000000002`, 1., 2.},
 CellID->471991,ExpressionUUID->"f547d6a8-7778-46fd-b80f-bd059962f497"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"64cd9df6-92c9-440b-b835-206066e6868e"],

Cell[TextData[{
 "1) False. Cauchy\[CloseCurlyQuote]s theorem is not applicable because the \
contour contains a singularity of the integrand.\n2) True.\n3) False. Cauchy\
\[CloseCurlyQuote]s theorem is not applicable here. However, this integral is \
zero nonetheless, as seen in ",
 ButtonBox["Chapter 11",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ".\n4) True."
}], "SolutionAnswer",
 CellID->78595550,ExpressionUUID->"76534f9e-2402-479f-b87d-5b8580255add"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     SubscriptBox["C", "1"]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0cb5c1a0-dd78-4b53-84bf-9ace8d159183"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     SubscriptBox["C", "2"]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b2869de8-6089-401a-9367-cf78e00cf588"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9a3147d6-7b6d-4cd9-90d1-9147be692aa6"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "38ea27d0-6336-4f2c-9d48-b014e3389961"],
 " are depicted here. Explain why they are equal:"
}], "Exercise",
 CellID->3842121,ExpressionUUID->"d8df0647-3ee0-4874-ab13-d6d3c6c9d71d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Arrow", "@", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "Pi"}], "/", "2"}], "+", "0.05"}], ",", 
          RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Arrow", "@", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"9d953dcf-9641-4ea1-87f3-0a5bc4078158\"]],\
ExpressionUUID->\"8705216a-ee29-4e15-9f83-14bcd5032160\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"90264813-4c4d-4804-aebd-321241d4e05d\"]],\
ExpressionUUID->\"0f5b339e-7b6c-4efa-8dcd-a5d7189cf16e\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "11", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "ExerciseInput",
 CellID->19139565,ExpressionUUID->"4cd21f1b-fbd3-43f0-b869-1ad9f2c5de53"],

Cell[BoxData[
 GraphicsBox[{
   ArrowBox[CircleBox[{1, 0}, 1, 
     NCache[{-1.5207963267948965`, Rational[1, 2] Pi}, {-1.5207963267948965`, 
      1.5707963267948966`}]]], ArrowBox[LineBox[{{1, -1}, {1, 1}}]], 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{1, Rational[1, 2]}, {1, 0.5}], NCache[
    ImageScaled[{1, Rational[1, 2]}], ImageScaled[{1, 0.5}]]], InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{2, Rational[1, 2]}, {2, 0.5}], NCache[
    ImageScaled[{0.25, Rational[1, 2]}], ImageScaled[{0.25, 0.5}]]]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[11],
  ImageSize->200,
  PlotRange->{{-1, 2.5}, {-1.5, 1.5}}]], "ExerciseOutput",
 CellID->180487458,ExpressionUUID->"07ccc013-c815-4f4b-822e-84b26e6d3211"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"d1b8919a-6477-4ebf-81fe-fcfa2e0cc192"],

Cell[TextData[{
 "The integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b4ff91af-e64e-41e3-bad0-3bc37ce940f1"],
 " is:"
}], "SolutionAnswer",
 CellID->207813389,ExpressionUUID->"fa49a49d-95fa-4a9e-af7d-535a779f2953"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "+", "1"}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
         RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->307874265,ExpressionUUID->"2ae76dfa-1752-473d-b279-9af10cb6d535"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "-", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTan", "[", "2", "]"}]}]}], ")"}]}]], "ExerciseOutput",
 CellID->114541089,ExpressionUUID->"27419d7c-a77c-42fc-a8ed-6491a8a0cebc"]
}, Open  ]],

Cell[TextData[{
 "while over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bcd30e08-697e-46fa-aa29-7fd864cad99c"],
 ":"
}], "SolutionAnswer",
 CellID->753986062,ExpressionUUID->"a2d56167-23bd-45ce-8274-abff22d47722"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "+", "1"}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->331577375,ExpressionUUID->"a34906f9-7b54-4a1e-9dd3-15d6ff2decb5"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", 
  RowBox[{"ArcCot", "[", "2", "]"}]}]], "ExerciseOutput",
 CellID->475018854,ExpressionUUID->"964bfb52-880c-448a-8c46-b5598c35eb98"]
}, Open  ]],

Cell["The two are equal:", "SolutionAnswer",
 CellID->53228046,ExpressionUUID->"ee2c31f4-b274-4b2c-aa45-6b7eef4081b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i1", "-", "i2"}], "//", "FullSimplify"}]], "ExerciseInput",
 CellID->79456947,ExpressionUUID->"195bda4a-8f11-4439-ba01-b24255dcbadc"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->41155345,ExpressionUUID->"749ab98d-9ba4-4030-a796-a03ca712eeaa"]
}, Open  ]],

Cell[TextData[{
 "The reason is that the two contours can be deformed into one another \
without crossing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bee874d0-39c1-409d-b974-41a60fc3d0d9"],
 ", which is the only point where the integrand is not analytic."
}], "SolutionAnswer",
 CellID->53252171,ExpressionUUID->"93388691-be7e-4078-a0cf-88676c865e75"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     SubscriptBox["C", "1"]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"072e3228-803a-4e7d-9db3-4439a0b16c56"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Integral]", 
     SubscriptBox["C", "2"]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"38d93a50-3976-4895-bff8-ba34e1d6e6ef"],
 " where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8716358a-ba5d-4095-b833-eb16ab850ca0"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3456fef9-1e94-4765-8da8-d8af428ff73b"],
 " are depicted here. Why does Cauchy\[CloseCurlyQuote]s theorem not apply?"
}], "Exercise",
 CellID->144337947,ExpressionUUID->"29daf7ae-4d96-48d5-baa7-13f2a0c88bf0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"-", "Pi"}], "/", "2"}], "+", "0.05"}], ",", 
            RowBox[{
             RowBox[{"Pi", "/", "2"}], "-", "0.05"}]}], "}"}]}], "]"}]}]}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.07"}], ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Pi", "/", "2"}], "+", "0.05"}], ",", 
            RowBox[{
             RowBox[{"3", 
              RowBox[{"Pi", "/", "2"}]}], "-", "0.05"}]}], "}"}]}], "]"}]}]}],
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"2bf33c3a-b4ae-44f2-b957-2640ac5db838\"]],\
ExpressionUUID->\"5f05db60-20fe-42db-9893-e8f71889f153\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.5", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"3a418507-2761-4945-ab03-024b39d7c3e2\"]],\
ExpressionUUID->\"9fe3c05d-3a05-4b8a-865b-e15fc837b538\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "11", "]"}]}], ",", 
   RowBox[{"ImageSize", "->", "200"}]}], "]"}]], "ExerciseInput",
 CellID->892085063,ExpressionUUID->"66c5637e-cfa4-4e44-9121-8cb063a10755"],

Cell[BoxData[
 GraphicsBox[{
   {Arrowheads[0.07], 
    ArrowBox[CircleBox[{1, 0}, 1, {-1.5207963267948965`, 
      1.5207963267948965`}]]}, 
   {Arrowheads[{-0.07, 0}], 
    ArrowBox[CircleBox[{1, 0}, 1, {1.6207963267948966`, 4.66238898038469}]]}, 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {1, 1}, ImageScaled[{1.75, 0}]], InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], NCache[{2, Rational[1, 2]}, {2, 0.5}], NCache[
    ImageScaled[{0.25, Rational[1, 2]}], ImageScaled[{0.25, 0.5}]]]},
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[11],
  ImageSize->200,
  PlotRange->{{-1, 2.5}, {-1.5, 1.5}}]], "ExerciseOutput",
 CellID->103360501,ExpressionUUID->"fd341e70-dd01-492a-a1cc-41f5ca8623d3"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"7a82e210-a0e0-4886-b732-81f4bc4103ad"],

Cell[TextData[{
 "Over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c270cbcc-57a4-4a28-90fc-b342115f29c8"],
 ", the integral is:"
}], "SolutionAnswer",
 CellID->399503435,ExpressionUUID->"743adc8d-ebfa-4b7d-98b9-6fb1fbf2ef87"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "-", "1"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", 
         RowBox[{"\[Pi]", "/", "2"}]}], ",", 
        RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->248302588,ExpressionUUID->"8284a49f-f26f-4a21-add6-3159f93bb362"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->474177763,ExpressionUUID->"9a25bfdc-d590-4d07-9c65-3f3fb8b535d4"]
}, Open  ]],

Cell[TextData[{
 "And over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "236ee724-55ea-4741-8b99-8b9737ce84f2"],
 ":"
}], "SolutionAnswer",
 CellID->462235798,ExpressionUUID->"f579972f-1969-4a64-9563-db182023d1c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", "-", "1"}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
        RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->51190059,ExpressionUUID->"05ba4798-b410-4775-898f-18a84eaa45d4"],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->298578467,ExpressionUUID->"527a288d-068a-4d9f-967d-25a832416141"]
}, Open  ]],

Cell[TextData[{
 "They are not guaranteed to be the same because the two contours are not \
homotopic over the domain of analyticity of the integrand. In other words, it \
is impossible to deform ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b5f076f1-63eb-491a-a6c7-be3d212cac65"],
 " into ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2b1eb66b-f71d-420e-b2a9-32de72d3aea1"],
 " without crossing the singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "be69de2c-037e-4d36-9423-1675d13c324c"],
 ", because it is located inside the region enclosed by the two curves."
}], "SolutionAnswer",
 CellID->217133960,ExpressionUUID->"628053fe-9455-47d6-b0ac-5583b50b1002"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Verify Cauchy\[CloseCurlyQuote]s theorem by computing ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]z"], 
      RowBox[{"z", "-", 
       RowBox[{"1", "/", "2"}]}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a1ab4b89-cbfe-413f-9101-921ec98d99f0"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "4d9fe53c-c0db-4366-bc11-696e15d7f14d"],
 " is the path in the figure. The equation of the parabola is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", 
    SuperscriptBox["x", "2"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a7dd6389-b346-4d55-a16c-dd3a2ecec551"],
 ":"
}], "Exercise",
 CellID->61064247,ExpressionUUID->"9c7bc75b-fdb1-4fd5-8d18-c05a18cb0706"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "11", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrowheads", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.07", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
     "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "150"}]}], "]"}]], "ExerciseInput",
 CellID->653846337,ExpressionUUID->"067cdbba-a47f-489f-8328-59f6e8484bd4"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {GrayLevel[0], Thickness[0.005], Opacity[1.], LineBox[CompressedData["

1:eJw1mHk0FH7Yxa3Z16ifkmyJIVsolXkoScqaRGQrFCXZd5oQypJ9K3uWsk1k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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0], 
              Thickness[0.005]], 
             Line[CompressedData["
1:eJw1mHk0FH7Yxa3Z16ifkmyJIVsolXkoScqaRGQrFCXZd5oQypJ9K3uWsk1k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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1.5, 1.}, {-0.5, 1.5}},
            "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {150, 150}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           Automatic, "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              GrayLevel[0], 
              Thickness[0.005]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1.5, 1.}, {-0.5, 1.5}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {150, 150}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             GrayLevel[0], 
             Thickness[0.005]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          GrayLevel[0], 
          Thickness[0.005]], 
         Line[CompressedData["
1:eJw1mHk0FH7Yxa3Z16ifkmyJIVsolXkoScqaRGQrFCXZd5oQypJ9K3uWsk1k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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {{-1.5, 1.}, {-0.5, 1.5}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {150, 150}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> Automatic, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          GrayLevel[0], 
          Thickness[0.005]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  AxesStyle->Directive[11],
  DisplayFunction->Identity,
  Epilog->{
    Arrowheads[{0, 0.07, 0}], 
    Thickness[0.005], 
    ArrowBox[
     LineBox[{{1, 1}, {-1, 1}}]]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->150,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-1.5, 1.}, {-0.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->793853956,ExpressionUUID->"e6baae56-7800-4ad7-be7e-28f6c05ec964"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"7fc6323a-f2a3-4720-9a0a-e577cb6ef861"],

Cell[TextData[{
 "Over the horizontal path ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"1", "+", "\[ImaginaryI]", "-", 
     RowBox[{"2", "t"}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "416400ff-01dd-453b-b95e-7de39126f2a3"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "1"}], "]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7217e6f5-764c-43f9-b4cf-b68cd5e9ed2a"],
 ", the integral is:"
}], "SolutionAnswer",
 CellID->75846533,ExpressionUUID->"900e3c72-d733-4431-97a1-4c92c4fa639c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Exp", "[", 
      RowBox[{"\[ImaginaryI]", " ", "z"}], "]"}], 
     RowBox[{"z", "-", 
      RowBox[{"1", "/", "2"}]}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->270755611,ExpressionUUID->"ebc9afd9-722f-4e50-bab4-292dbec66d1a"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   FractionBox["\[ImaginaryI]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"CoshIntegral", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{
       FractionBox["1", "2"], "+", "\[ImaginaryI]"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"SinhIntegral", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], "]"}]}], "-", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     RowBox[{"SinIntegral", "[", 
      RowBox[{
       FractionBox["1", "2"], "+", "\[ImaginaryI]"}], "]"}]}]}], 
   ")"}]}]], "ExerciseOutput",
 CellID->58204864,ExpressionUUID->"70904a74-ab64-438a-9385-404f1c683421"]
}, Open  ]],

Cell[TextData[{
 "Over the parabolic path ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Rho]", "(", "t", ")"}], "=", 
    RowBox[{"t", "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["t", "2"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d8fbb4bf-db2b-4e8e-b7e9-d846ea962940"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Element]", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9cc08010-d1cb-459a-b99c-31831b1f0f80"],
 ", the integral is:"
}], "SolutionAnswer",
 CellID->33135304,ExpressionUUID->"d8d31619-383a-4c73-b537-e65e9830819d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Exp", "[", 
      RowBox[{"\[ImaginaryI]", " ", "z"}], "]"}], 
     RowBox[{"z", "-", 
      RowBox[{"1", "/", "2"}]}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"ParametricRegion", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", 
         SuperscriptBox["t", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"t", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}]}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->13378831,ExpressionUUID->"2e01d4ba-5b5a-4cc2-82a4-03ad662c9dc8"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   FractionBox["\[ImaginaryI]", "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox["\[ImaginaryI]", "2"]}], "]"}], "-", 
    RowBox[{"ExpIntegralEi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      FractionBox[
       RowBox[{"3", " ", "\[ImaginaryI]"}], "2"]}], "]"}]}], 
   ")"}]}]], "ExerciseOutput",
 CellID->307364047,ExpressionUUID->"5a753a77-2be7-4ad1-a063-46def234091c"]
}, Open  ]],

Cell["\<\
Check that their sum is zero as guaranteed by Cauchy\[CloseCurlyQuote]s \
theorem:\
\>", "SolutionAnswer",
 CellID->252489888,ExpressionUUID->"02fdcf43-e1fa-4835-b979-a2ee92915820"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i1", "+", "i2"}], "//", "FullSimplify"}]], "ExerciseInput",
 CellID->75351915,ExpressionUUID->"4c35f450-c665-4852-9509-cc3560e89962"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->326456049,ExpressionUUID->"68fa6ab9-82f2-4492-ad7c-6455b35788a2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Check by explicit computation that the integrals of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox["z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"aa38e401-1e10-42fe-b33f-8d6f4b24bffa"],
 " along ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "021b0345-8c21-431d-b3cb-b0b0d1ffb873"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bb8f0d24-3f84-4eaa-b6f0-c4679a720d93"],
 " are not equal. Why does Cauchy\[CloseCurlyQuote]s theorem not apply in \
this case?"
}], "Exercise",
 CellID->126566430,ExpressionUUID->"d8462638-8acb-4de8-8ca1-ef93adb81277"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", ".9"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "0.07", "]"}], ",", 
       RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
       RowBox[{"Arrow", "@", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.1", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", 
             RowBox[{"-", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"9fd5f0d5-835e-4439-a3f0-a557ea43abc8\"]],\
ExpressionUUID->\"fc8c8b79-83ec-41e8-ab1c-488ece45fc03\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"7cba11a1-8fdb-4b11-a3df-611fd8f41577\"]],\
ExpressionUUID->\"af97895c-dc43-4dcb-91cb-f46a4dc841c0\"]\)\>\"", ",", "12"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.6", ",", "0.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "z", "]"}], ",", 
      RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "11", "]"}]}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "150"}]}], "]"}]], "ExerciseInput",
 CellID->84192800,ExpressionUUID->"813fc902-5ba9-4a96-9508-ba4e6e537326"],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[0.01], Arrowheads[0.07], 
    ArrowBox[LineBox[{{0, -0.9}, {0, 1}}]]}, 
   {Thickness[0.01], Arrowheads[0.07], 
    ArrowBox[LineBox[{{0.1, -1}, {2, -1}, {2, 1}, {0, 1}}]]}, InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {0.3, 0.3}, NCache[
    ImageScaled[{Rational[1, 2], Rational[1, 2]}], ImageScaled[{0.5, 0.5}]]], 
   InsetBox[
    StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\
\\\"C\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"\>",
     StripOnInput->False,
     FontSize->12], {1.6, 0.7}, NCache[
    ImageScaled[{Rational[1, 2], Rational[1, 2]}], ImageScaled[{0.5, 0.5}]]]},
  
  AspectRatio->Automatic,
  Axes->True,
  AxesLabel->{
    FormBox[
     RowBox[{"Re", "(", "z", ")"}], TraditionalForm], 
    FormBox[
     RowBox[{"Im", "(", "z", ")"}], TraditionalForm]},
  AxesStyle->Directive[11],
  ImageSize->150,
  PlotRange->{{-1.5, 2.5}, {-1.5, 1.5}}]], "ExerciseOutput",
 CellID->415048503,ExpressionUUID->"c804d0ee-dfd2-4194-8bef-41871031b114"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"a63c74cf-069a-474d-8b7b-08275cb2ea25"],

Cell[TextData[{
 "Over the contour ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e0584c72-5e35-45c5-9ff8-87efb11ac441"],
 ", the integral is:"
}], "SolutionAnswer",
 CellID->131408514,ExpressionUUID->"63eefebf-00b8-41cb-96c4-fababbcb4690"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i1", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox["z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->304781222,ExpressionUUID->"756128cf-98e9-47c8-af0c-7652e56ae56f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}]}]], "ExerciseOutput",
 CellID->415014507,ExpressionUUID->"173a455b-8736-4ae2-a75c-a08a5503e7cb"]
}, Open  ]],

Cell[TextData[{
 "Over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4f94fbe9-3642-493d-bccf-1e2bf727a689"],
 ", the integral is:"
}], "SolutionAnswer",
 CellID->359479873,ExpressionUUID->"867ffe45-f4d8-468a-b58d-5bdb1ada9248"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i2", "=", 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox["z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->597407880,ExpressionUUID->"2d998ed1-28f1-42d4-82ea-0b568b8d2f58"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"3", " ", "\[Pi]"}]}], ")"}]}]], "ExerciseOutput",
 CellID->930182465,ExpressionUUID->"c55a839c-188b-4bfa-94dd-b1dc2bae2ab0"]
}, Open  ]],

Cell["The two are not equal:", "SolutionAnswer",
 CellID->542438939,ExpressionUUID->"1d3b3c5b-26ca-42bc-acb9-5ffd1a4dbcee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"i2", "-", "i1"}], "//", "FullSimplify"}]], "ExerciseInput",
 CellID->58319117,ExpressionUUID->"9bc1437f-9f1d-4158-8cc2-e4c456f7c363"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->435537851,ExpressionUUID->"b3d6bc14-af6c-46f9-883a-9724bf2a8fa0"]
}, Open  ]],

Cell[TextData[{
 "Cauchy\[CloseCurlyQuote]s theorem cannot be applied because of the \
singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "07b09b05-2538-417d-b06a-75110b19e499"],
 ", inside the square."
}], "SolutionAnswer",
 CellID->148402553,ExpressionUUID->"f9cfd3ee-c755-437d-a11d-8157e895753b"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->392434739,ExpressionUUID->"ede7bf34-5fda-4b04-ad42-02e886ff6f0a"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"13. Cauchy\[CloseCurlyQuote]s Theorem | Essentials of Complex \
Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "12. Fundamental Theorem for Complex Line Integrals"}, 
        "PrettyTooltipTemplate"], "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem"}, 
        "PrettyTooltipTemplate"], "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"1bb7c506-1baa-4b2e-929d-0ffdabee5b4d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[648, 23, 240, 7, 108, "Section",ExpressionUUID->"502dbbca-b19c-4829-8581-c6cbac3f24bd",
 CounterAssignments->{{"Section", 12}},
 CellID->103276447],
Cell[891, 32, 254, 4, 60, "Text",ExpressionUUID->"fcb81b30-18e6-435a-97e9-52408a2d5f82",
 CellID->846796150],
Cell[1148, 38, 270, 5, 60, "Text",ExpressionUUID->"eb3d06b8-fdab-49e8-8ae5-789cda673778",
 CellID->45073467],
Cell[CellGroupData[{
Cell[1443, 47, 2905, 79, 70, "Input",ExpressionUUID->"c0d9bf13-9c0c-4cdb-a293-92965380aa5a",
 CellID->237483354],
Cell[4351, 128, 942, 21, 168, "Output",ExpressionUUID->"3aac7fa5-1f23-4386-88bd-a506fa9a8bd9",
 CellID->77096893]
}, {2}]],
Cell[5305, 152, 493, 15, 36, "Text",ExpressionUUID->"a36eea87-b39f-457b-a438-9b2e6752e7b2",
 CellID->180780243],
Cell[5801, 169, 1073, 30, 50, "DisplayFormula",ExpressionUUID->"9c07b546-3e7d-4a9e-8daa-06dab88695fe",
 CellID->205072165],
Cell[6877, 201, 216, 4, 36, "Text",ExpressionUUID->"5ddcdf42-0ffc-4046-a4bf-5fbb2ba6161e",
 CellID->227602155],
Cell[CellGroupData[{
Cell[7118, 209, 118, 1, 56, "Subsection",ExpressionUUID->"b4e23837-ff72-449a-8729-e6a46b0ded26",
 CellID->858627792],
Cell[7239, 212, 157, 2, 36, "Text",ExpressionUUID->"6fbfd615-3fef-4124-b576-74f52cd7aa5b",
 CellID->144585957],
Cell[7399, 216, 854, 27, 36, "Text",ExpressionUUID->"2f397e09-9d9f-4464-ad54-41e043102785",
 CellID->5476449],
Cell[CellGroupData[{
Cell[8278, 247, 4236, 117, 70, "Input",ExpressionUUID->"baaccbe6-1e92-48f4-9a0a-c58db9a9830d",
 CellID->13075533],
Cell[12517, 366, 80855, 1411, 176, "Output",ExpressionUUID->"31e150ce-8dbd-44c2-be2b-ba0c18249829",
 CellID->1533957413]
}, {2}]],
Cell[93384, 1780, 251, 7, 36, "Text",ExpressionUUID->"d7e01fd4-87a2-4d8b-bf8c-b8e4e5ba1e79",
 CellID->16304631],
Cell[CellGroupData[{
Cell[93660, 1791, 7812, 214, 70, "Input",ExpressionUUID->"18d50d4e-2cd3-4d6f-92e2-fb07f51b305c",
 CellID->391414181],
Cell[101475, 2007, 1807, 38, 153, "Output",ExpressionUUID->"ea3b68bf-312a-4220-bf5a-37868d3e726d",
 CellID->395043358]
}, {2}]],
Cell[103294, 2048, 348, 8, 60, "Text",ExpressionUUID->"4f162a62-ad58-425c-88ad-d0a1c3011f7a",
 CellID->85508443],
Cell[CellGroupData[{
Cell[103667, 2060, 7515, 212, 70, "Input",ExpressionUUID->"a2c1d22c-bcb5-4a13-b15c-0e202c1a20f1",
 CellID->215367947],
Cell[111185, 2274, 1641, 35, 153, "Output",ExpressionUUID->"4c7a76c1-d2bd-4669-9de6-ca0f5ec544d0",
 CellID->1009077868]
}, {2}]],
Cell[112838, 2312, 1019, 27, 83, "Text",ExpressionUUID->"d387eeeb-42c6-4ff6-a876-dd7a1eff6424",
 CellID->77837169],
Cell[CellGroupData[{
Cell[113882, 2343, 10873, 294, 70, "Input",ExpressionUUID->"8b9eafea-33b5-4911-a414-84bc1f672a96",
 CellID->444773140],
Cell[124758, 2639, 3452, 71, 267, "Output",ExpressionUUID->"3eaceb25-3acc-4d9d-b238-78f4e22bc733",
 CellID->639475426]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[128256, 2716, 130, 1, 56, "Subsection",ExpressionUUID->"e85dc5c3-2766-4b80-ae9d-77f4a0fe645e",
 CellID->481980878],
Cell[128389, 2719, 295, 5, 60, "Text",ExpressionUUID->"75f1d3e9-f7d2-4805-aa4d-97d1c7f26d66",
 CellID->32887749],
Cell[128687, 2726, 227, 5, 36, "Text",ExpressionUUID->"a09adec8-bd75-4e9c-b0fc-5a4d0da08877",
 CellID->29208502],
Cell[128917, 2733, 1165, 35, 64, "Text",ExpressionUUID->"fafd44fb-4316-4869-b958-3546e34e4d42",
 CellID->1661472934],
Cell[130085, 2770, 819, 23, 38, "Text",ExpressionUUID->"270f027d-be29-c041-943f-0dbd80ee48c8",
 CellID->148369735],
Cell[130907, 2795, 684, 18, 60, "Text",ExpressionUUID->"bea5fd16-8860-4958-81be-5d0f525e7912",
 CellID->84184085],
Cell[131594, 2815, 351, 8, 60, "Text",ExpressionUUID->"9baf7385-59ba-410c-8360-4cb6ef0f3235",
 CellID->539209502],
Cell[131948, 2825, 922, 26, 83, "Text",ExpressionUUID->"729c1b27-9109-40de-ac85-de658ea3e4ec",
 CellID->91022667],
Cell[132873, 2853, 2833, 78, 85, "DisplayFormula",ExpressionUUID->"be4d800e-5c55-4972-81cb-dc0efa19b84e",
 CellID->46846808],
Cell[135709, 2933, 447, 12, 36, "Text",ExpressionUUID->"de02ae09-e944-4fe2-a58c-d125284c188b",
 CellID->342970093],
Cell[136159, 2947, 187, 8, 71, "SolvedExample",ExpressionUUID->"3f5c23f7-4aaf-463a-a4a9-27ea10877cf4",
 CellID->384742129],
Cell[136349, 2957, 1097, 30, 66, "SolvedExampleNote",ExpressionUUID->"3f3368ae-fdf7-4f68-9c76-39923e03218c",
 CellID->189638086],
Cell[137449, 2989, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"f6a9b326-03ae-45e2-9284-77bf506597e5",
 CellID->943814759],
Cell[137558, 2992, 187, 8, 71, "SolvedExample",ExpressionUUID->"cfeda370-fadf-423c-8691-162f3262e67b",
 CellID->258066178],
Cell[137748, 3002, 842, 26, 43, "SolvedExampleNote",ExpressionUUID->"fda567f1-cad8-4b76-988e-5b96a82d5d7f",
 CellID->51880908],
Cell[CellGroupData[{
Cell[138615, 3032, 2644, 74, 70, "SolvedExampleInput",ExpressionUUID->"fa6a6c78-a5de-43dd-8666-4888c818831d",
 CellID->47075353],
Cell[141262, 3108, 1230, 27, 176, "SolvedExampleOutput",ExpressionUUID->"3a9b3fe1-3069-4f49-a5c6-45cf867d5ca8",
 CellID->55037307]
}, {2}]],
Cell[142504, 3138, 291, 8, 39, "SolvedExampleNote",ExpressionUUID->"d1056c7f-5404-4f79-9180-bc1c2eca07e4",
 CellID->473923942],
Cell[CellGroupData[{
Cell[142820, 3150, 655, 21, 50, "SolvedExampleInput",ExpressionUUID->"99c1c121-3463-470a-b1a9-846d22cc7a50",
 CellID->44264937],
Cell[143478, 3173, 292, 7, 54, "SolvedExampleOutput",ExpressionUUID->"eda18960-65f6-449c-9fac-d15995cf1d62",
 CellID->64717703]
}, Open  ]],
Cell[143785, 3183, 290, 8, 39, "SolvedExampleNote",ExpressionUUID->"531d7d4d-f442-42ea-9934-477e703316b6",
 CellID->25813259],
Cell[CellGroupData[{
Cell[144100, 3195, 704, 22, 50, "SolvedExampleInput",ExpressionUUID->"beb4b764-e763-4b2c-95cd-5d0138a3b0dd",
 CellID->256771591],
Cell[144807, 3219, 214, 4, 54, "SolvedExampleOutput",ExpressionUUID->"28760df7-1712-4055-97f0-ee1547a101c5",
 CellID->295238491]
}, Open  ]],
Cell[145036, 3226, 891, 25, 61, "SolvedExampleNote",ExpressionUUID->"d609fe20-5b38-44ed-a0dd-70ea99516a37",
 CellID->475873205],
Cell[CellGroupData[{
Cell[145952, 3255, 174, 3, 25, "SolvedExampleInput",ExpressionUUID->"ec87a42a-d6d5-4a98-a57f-1b2288b04464",
 CellID->566207344],
Cell[146129, 3260, 115, 1, 36, "SolvedExampleOutput",ExpressionUUID->"718d4389-0c5f-4ebe-85d9-0f8b18473517",
 CellID->25077753]
}, Open  ]],
Cell[146259, 3264, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"bc155def-077c-4e56-8efc-aa08759e49c0",
 CellID->1872388982],
Cell[146369, 3267, 186, 8, 71, "SolvedExample",ExpressionUUID->"98638687-d5af-4321-9ec1-c74ed148c902",
 CellID->58502825],
Cell[146558, 3277, 671, 20, 44, "SolvedExampleNote",ExpressionUUID->"6b20e694-5b55-4065-ba8e-3c8b698b65a0",
 CellID->322016262],
Cell[CellGroupData[{
Cell[147254, 3301, 2564, 71, 70, "SolvedExampleInput",ExpressionUUID->"550d1efa-e8dc-45c3-90d5-cccc2c9016c7",
 CellID->1020705185],
Cell[149821, 3374, 1174, 26, 176, "SolvedExampleOutput",ExpressionUUID->"16397630-ad4a-4520-83fb-b304bb21cedc",
 CellID->74884816]
}, {2}]],
Cell[151007, 3403, 290, 8, 39, "SolvedExampleNote",ExpressionUUID->"efb272bb-ef1c-4b33-bfc0-c2861eeab024",
 CellID->77209998],
Cell[CellGroupData[{
Cell[151322, 3415, 589, 18, 51, "SolvedExampleInput",ExpressionUUID->"b7404084-f50d-4aa8-b436-48fc50569812",
 CellID->150025850],
Cell[151914, 3435, 189, 4, 54, "SolvedExampleOutput",ExpressionUUID->"e2eabca1-a6f0-4fdb-9cc7-c74f8f9530e2",
 CellID->40510553]
}, Open  ]],
Cell[152118, 3442, 290, 8, 39, "SolvedExampleNote",ExpressionUUID->"fc9d8ca1-4b87-4ffe-96a1-3a31d7a84d0e",
 CellID->57913166],
Cell[CellGroupData[{
Cell[152433, 3454, 542, 17, 51, "SolvedExampleInput",ExpressionUUID->"d0a494f6-e0d4-4297-8c95-00d188c76200",
 CellID->174979517],
Cell[152978, 3473, 190, 4, 54, "SolvedExampleOutput",ExpressionUUID->"10770f1f-42bc-464f-a93d-632824111a27",
 CellID->384409596]
}, Open  ]],
Cell[153183, 3480, 244, 4, 61, "SolvedExampleNote",ExpressionUUID->"9da59460-fb6a-45b7-8296-f3d9a9f0e198",
 CellID->330379225],
Cell[CellGroupData[{
Cell[153452, 3488, 541, 16, 51, "SolvedExampleInput",ExpressionUUID->"d7afa0ab-5fef-46a2-afcf-0d3579c0beb7",
 CellID->210860994],
Cell[153996, 3506, 118, 1, 36, "SolvedExampleOutput",ExpressionUUID->"dca40692-d602-448e-b4e0-73d91bf1c48c",
 CellID->14405294]
}, Open  ]],
Cell[154129, 3510, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"5ced8c77-211e-457d-9165-5f85f6ee2b74",
 CellID->1081416579],
Cell[154239, 3513, 186, 8, 71, "SolvedExample",ExpressionUUID->"7fa2ebe0-bb42-42bf-bc74-76ceac410879",
 CellID->42126189],
Cell[154428, 3523, 498, 14, 44, "SolvedExampleNote",ExpressionUUID->"576c0bc4-1ede-4a67-8cf6-ba0dd29709c2",
 CellID->179515144],
Cell[CellGroupData[{
Cell[154951, 3541, 2357, 75, 70, "SolvedExampleInput",ExpressionUUID->"b69466e3-0d1c-4e7d-8866-17e8df6434d8",
 CellID->252468565],
Cell[157311, 3618, 851, 17, 168, "SolvedExampleOutput",ExpressionUUID->"314d15b9-69f0-433e-b714-a4eee13f3eb3",
 CellID->566869378]
}, {2}]],
Cell[158174, 3638, 316, 7, 61, "SolvedExampleNote",ExpressionUUID->"9ecf65d1-6308-486a-a975-f70077c4175f",
 CellID->811987227],
Cell[CellGroupData[{
Cell[158515, 3649, 609, 19, 51, "SolvedExampleInput",ExpressionUUID->"8c33bb8c-3772-4bc8-9fd7-4c2b6c9889a8",
 CellID->340484015],
Cell[159127, 3670, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"00d7f115-33d5-4902-897e-178f476083b3",
 CellID->198075243]
}, Open  ]],
Cell[159258, 3674, 142, 1, 39, "SolvedExampleNote",ExpressionUUID->"3347e7e5-f2af-4eb3-bc66-359da2c4e5cf",
 CellID->70795190],
Cell[CellGroupData[{
Cell[159425, 3679, 832, 25, 73, "SolvedExampleInput",ExpressionUUID->"70b50238-b50d-4ca6-9e84-160c6655b9a0",
 CellID->105740634],
Cell[160260, 3706, 119, 1, 36, "SolvedExampleOutput",ExpressionUUID->"921c0282-27dd-43b6-b2b0-9978bc675554",
 CellID->236883237]
}, Open  ]],
Cell[160394, 3710, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"882b2338-95a9-4488-a05b-efa72bda6763",
 CellID->584189319],
Cell[160503, 3713, 187, 8, 71, "SolvedExample",ExpressionUUID->"b9099892-96a0-4942-a61e-8f6137e21f53",
 CellID->149379374],
Cell[160693, 3723, 548, 13, 63, "SolvedExampleNote",ExpressionUUID->"7f82e25b-0b10-49c0-b918-2667778cd731",
 CellID->75268082],
Cell[161244, 3738, 333, 8, 39, "SolvedExampleNote",ExpressionUUID->"922b0fb6-5f9c-4379-b54b-e9859e76594a",
 CellID->251781873],
Cell[CellGroupData[{
Cell[161602, 3750, 273, 6, 25, "SolvedExampleInput",ExpressionUUID->"4cad5889-e6ee-4e76-95ca-9e8b32993548",
 CellID->59604454],
Cell[161878, 3758, 115, 1, 36, "SolvedExampleOutput",ExpressionUUID->"8e04b57d-8a4b-4b82-b8bc-89a54684b967",
 CellID->71599171]
}, Open  ]],
Cell[162008, 3762, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"72fdc847-d721-4cc8-8ff4-9c21aeb7805f",
 CellID->1444010409],
Cell[162118, 3765, 160, 2, 36, "Text",ExpressionUUID->"83e71bfe-31e1-461e-abf8-d054b549e08b",
 CellID->18023024],
Cell[162281, 3769, 1278, 37, 62, "Text",ExpressionUUID->"5b1b4a8d-4ffb-4c48-ae9f-9fc043216998",
 CellID->260214723],
Cell[CellGroupData[{
Cell[163584, 3810, 8078, 208, 70, "Input",ExpressionUUID->"ee97bef5-3dc3-46bd-8c0a-82026abd4587",
 CellID->231178595],
Cell[171665, 4020, 39603, 701, 257, "Output",ExpressionUUID->"437c2242-3946-6c41-8e1f-612ca59f6b23",
 CellID->74950417]
}, {2}]],
Cell[211280, 4724, 218, 4, 60, "Text",ExpressionUUID->"82bee58a-04b0-48db-9440-64b8842c202e",
 CellID->622645828],
Cell[211501, 4730, 187, 8, 71, "SolvedExample",ExpressionUUID->"19063070-ba22-425e-9bad-3b4578aa4e93",
 CellID->139603462],
Cell[211691, 4740, 1509, 46, 63, "SolvedExampleNote",ExpressionUUID->"89cff5bb-9d16-4f85-b11d-fbccf4357e48",
 CellID->56196420],
Cell[CellGroupData[{
Cell[213225, 4790, 1984, 64, 70, "SolvedExampleInput",ExpressionUUID->"3854742e-c0a6-40dc-8a46-f9217ae1d763",
 CellID->178699379],
Cell[215212, 4856, 756, 20, 207, "SolvedExampleOutput",ExpressionUUID->"d8fa64e7-309f-45e2-9440-ba25dd0c8e21",
 CellID->27802434]
}, {2}]],
Cell[215980, 4879, 184, 6, 39, "SolvedExampleNote",ExpressionUUID->"bd96d8a6-ad5a-42fa-98a1-d09cb37fb748",
 CellID->769229553],
Cell[CellGroupData[{
Cell[216189, 4889, 715, 22, 25, "SolvedExampleInput",ExpressionUUID->"78791ef6-12c6-4ea7-9ae2-fecfa730ff96",
 CellID->245562541],
Cell[216907, 4913, 259, 6, 36, "SolvedExampleOutput",ExpressionUUID->"44147d09-c264-4d6e-ae3e-8dc761a8b197",
 CellID->155321303]
}, Open  ]],
Cell[217181, 4922, 1022, 31, 61, "SolvedExampleNote",ExpressionUUID->"3fe996ca-8b34-4351-8045-3fe52e56755f",
 CellID->83955897],
Cell[CellGroupData[{
Cell[218228, 4957, 194, 4, 25, "SolvedExampleInput",ExpressionUUID->"c9454e0f-4727-42fe-9279-ca404d696f7d",
 CellID->658868197],
Cell[218425, 4963, 145, 2, 36, "SolvedExampleOutput",ExpressionUUID->"bacc8f98-33fa-4857-a0be-fbd54d94a3a3",
 CellID->132094026]
}, Open  ]],
Cell[218585, 4968, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"efd368ed-f109-42c4-a39d-4c64c07c338e",
 CellID->2121009758],
Cell[CellGroupData[{
Cell[218717, 4973, 109, 1, 69, "SummarySection",ExpressionUUID->"fd345a40-afe2-482b-acfc-d0a2ae00a691",
 CellID->1198545324],
Cell[218829, 4976, 163, 2, 29, "SummaryList",ExpressionUUID->"950b1152-ed35-48dc-89d0-220e42d69ed8",
 CellID->426237],
Cell[218995, 4980, 286, 6, 45, "SummaryList",ExpressionUUID->"d1bcbabd-baa3-47e8-b4d0-830efff98191",
 CellID->15188509],
Cell[219284, 4988, 287, 6, 45, "SummaryList",ExpressionUUID->"7e08d3cb-a4f3-4fd8-bf68-50e508f84538",
 CellID->2085339],
Cell[219574, 4996, 1259, 36, 54, "SummaryList",ExpressionUUID->"9de4580a-99b9-41c0-bbec-f7041f420a08",
 CellID->418720821]
}, Open  ]],
Cell[CellGroupData[{
Cell[220870, 5037, 160, 3, 65, "ExerciseSection",ExpressionUUID->"50478647-2f47-424f-934a-c48684725704",
 CellID->131710622],
Cell[221033, 5042, 2646, 78, 136, "Exercise",ExpressionUUID->"f547d6a8-7778-46fd-b80f-bd059962f497",
 CellID->471991],
Cell[CellGroupData[{
Cell[223704, 5124, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"64cd9df6-92c9-440b-b835-206066e6868e"],
Cell[223798, 5126, 602, 13, 105, "SolutionAnswer",ExpressionUUID->"76534f9e-2402-479f-b87d-5b8580255add",
 CellID->78595550]
}, Closed]],
Cell[CellGroupData[{
Cell[224437, 5144, 1106, 35, 29, "Exercise",ExpressionUUID->"d8df0647-3ee0-4874-ab13-d6d3c6c9d71d",
 CellID->3842121],
Cell[CellGroupData[{
Cell[225568, 5183, 2609, 73, 70, "ExerciseInput",ExpressionUUID->"4cd21f1b-fbd3-43f0-b869-1ad9f2c5de53",
 CellID->19139565],
Cell[228180, 5258, 1190, 26, 170, "ExerciseOutput",ExpressionUUID->"07ccc013-c815-4f4b-822e-84b26e6d3211",
 CellID->180487458]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[229416, 5290, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"d1b8919a-6477-4ebf-81fe-fcfa2e0cc192"],
Cell[229510, 5292, 288, 8, 22, "SolutionAnswer",ExpressionUUID->"fa49a49d-95fa-4a9e-af7d-535a779f2953",
 CellID->207813389],
Cell[CellGroupData[{
Cell[229823, 5304, 568, 17, 45, "ExerciseInput",ExpressionUUID->"2ae76dfa-1752-473d-b279-9af10cb6d535",
 CellID->307874265],
Cell[230394, 5323, 257, 6, 28, "ExerciseOutput",ExpressionUUID->"27419d7c-a77c-42fc-a8ed-6491a8a0cebc",
 CellID->114541089]
}, Open  ]],
Cell[230666, 5332, 278, 8, 22, "SolutionAnswer",ExpressionUUID->"a2d56167-23bd-45ce-8274-abff22d47722",
 CellID->753986062],
Cell[CellGroupData[{
Cell[230969, 5344, 520, 16, 45, "ExerciseInput",ExpressionUUID->"a34906f9-7b54-4a1e-9dd3-15d6ff2decb5",
 CellID->331577375],
Cell[231492, 5362, 188, 3, 28, "ExerciseOutput",ExpressionUUID->"964bfb52-880c-448a-8c46-b5598c35eb98",
 CellID->475018854]
}, Open  ]],
Cell[231695, 5368, 118, 1, 22, "SolutionAnswer",ExpressionUUID->"ee2c31f4-b274-4b2c-aa45-6b7eef4081b5",
 CellID->53228046],
Cell[CellGroupData[{
Cell[231838, 5373, 168, 3, 25, "ExerciseInput",ExpressionUUID->"195bda4a-8f11-4439-ba01-b24255dcbadc",
 CellID->79456947],
Cell[232009, 5378, 110, 1, 28, "ExerciseOutput",ExpressionUUID->"749ab98d-9ba4-4030-a796-a03ca712eeaa",
 CellID->41155345]
}, Open  ]],
Cell[232134, 5382, 436, 10, 43, "SolutionAnswer",ExpressionUUID->"93388691-be7e-4078-a0cf-88676c865e75",
 CellID->53252171]
}, Closed]],
Cell[CellGroupData[{
Cell[232607, 5397, 1134, 35, 29, "Exercise",ExpressionUUID->"29daf7ae-4d96-48d5-baa7-13f2a0c88bf0",
 CellID->144337947],
Cell[CellGroupData[{
Cell[233766, 5436, 3087, 86, 70, "ExerciseInput",ExpressionUUID->"66c5637e-cfa4-4e44-9121-8cb063a10755",
 CellID->892085063],
Cell[236856, 5524, 1151, 27, 170, "ExerciseOutput",ExpressionUUID->"fd341e70-dd01-492a-a1cc-41f5ca8623d3",
 CellID->103360501]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[238053, 5557, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"7a82e210-a0e0-4886-b732-81f4bc4103ad"],
Cell[238147, 5559, 289, 8, 22, "SolutionAnswer",ExpressionUUID->"743adc8d-ebfa-4b7d-98b9-6fb1fbf2ef87",
 CellID->399503435],
Cell[CellGroupData[{
Cell[238461, 5571, 530, 16, 45, "ExerciseInput",ExpressionUUID->"8284a49f-f26f-4a21-add6-3159f93bb362",
 CellID->248302588],
Cell[238994, 5589, 167, 3, 28, "ExerciseOutput",ExpressionUUID->"9a25bfdc-d590-4d07-9c65-3f3fb8b535d4",
 CellID->474177763]
}, Open  ]],
Cell[239176, 5595, 276, 8, 22, "SolutionAnswer",ExpressionUUID->"f579972f-1969-4a64-9563-db182023d1c9",
 CellID->462235798],
Cell[CellGroupData[{
Cell[239477, 5607, 529, 16, 45, "ExerciseInput",ExpressionUUID->"05ba4798-b410-4775-898f-18a84eaa45d4",
 CellID->51190059],
Cell[240009, 5625, 149, 2, 28, "ExerciseOutput",ExpressionUUID->"527a288d-068a-4d9f-967d-25a832416141",
 CellID->298578467]
}, Open  ]],
Cell[240173, 5630, 857, 20, 64, "SolutionAnswer",ExpressionUUID->"628053fe-9455-47d6-b0ac-5583b50b1002",
 CellID->217133960]
}, Closed]],
Cell[CellGroupData[{
Cell[241067, 5655, 912, 25, 50, "Exercise",ExpressionUUID->"9c7bc75b-fdb1-4fd5-8d18-c05a18cb0706",
 CellID->61064247],
Cell[CellGroupData[{
Cell[242004, 5684, 1551, 46, 70, "ExerciseInput",ExpressionUUID->"067cdbba-a47f-489f-8328-59f6e8484bd4",
 CellID->653846337],
Cell[243558, 5732, 23396, 437, 121, "ExerciseOutput",ExpressionUUID->"e6baae56-7800-4ad7-be7e-28f6c05ec964",
 CellID->793853956]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[267000, 6175, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"7fc6323a-f2a3-4720-9a0a-e577cb6ef861"],
Cell[267094, 6177, 629, 18, 22, "SolutionAnswer",ExpressionUUID->"900e3c72-d733-4431-97a1-4c92c4fa639c",
 CellID->75846533],
Cell[CellGroupData[{
Cell[267748, 6199, 619, 19, 46, "ExerciseInput",ExpressionUUID->"ebc9afd9-722f-4e50-bab4-292dbec66d1a",
 CellID->270755611],
Cell[268370, 6220, 963, 27, 84, "ExerciseOutput",ExpressionUUID->"70904a74-ab64-438a-9385-404f1c683421",
 CellID->58204864]
}, Open  ]],
Cell[269348, 6250, 673, 20, 22, "SolutionAnswer",ExpressionUUID->"d8d31619-383a-4c73-b537-e65e9830819d",
 CellID->33135304],
Cell[CellGroupData[{
Cell[270046, 6274, 669, 20, 46, "ExerciseInput",ExpressionUUID->"2e01d4ba-5b5a-4cc2-82a4-03ad662c9dc8",
 CellID->13378831],
Cell[270718, 6296, 620, 18, 45, "ExerciseOutput",ExpressionUUID->"5a753a77-2be7-4ad1-a063-46def234091c",
 CellID->307364047]
}, Open  ]],
Cell[271353, 6317, 191, 4, 22, "SolutionAnswer",ExpressionUUID->"02fdcf43-e1fa-4835-b979-a2ee92915820",
 CellID->252489888],
Cell[CellGroupData[{
Cell[271569, 6325, 168, 3, 25, "ExerciseInput",ExpressionUUID->"4c35f450-c665-4852-9509-cc3560e89962",
 CellID->75351915],
Cell[271740, 6330, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"68fa6ab9-82f2-4492-ad7c-6455b35788a2",
 CellID->326456049]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[271900, 6337, 844, 24, 50, "Exercise",ExpressionUUID->"d8462638-8acb-4de8-8ca1-ef93adb81277",
 CellID->126566430],
Cell[CellGroupData[{
Cell[272769, 6365, 2975, 81, 70, "ExerciseInput",ExpressionUUID->"813fc902-5ba9-4a96-9508-ba4e6e537326",
 CellID->84192800],
Cell[275747, 6448, 1171, 28, 124, "ExerciseOutput",ExpressionUUID->"c804d0ee-dfd2-4194-8bef-41871031b114",
 CellID->415048503]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[276964, 6482, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"a63c74cf-069a-474d-8b7b-08275cb2ea25"],
Cell[277058, 6484, 301, 8, 22, "SolutionAnswer",ExpressionUUID->"63eefebf-00b8-41cb-96c4-fababbcb4690",
 CellID->131408514],
Cell[CellGroupData[{
Cell[277384, 6496, 576, 18, 47, "ExerciseInput",ExpressionUUID->"756128cf-98e9-47c8-af0c-7652e56ae56f",
 CellID->304781222],
Cell[277963, 6516, 266, 7, 44, "ExerciseOutput",ExpressionUUID->"173a455b-8736-4ae2-a75c-a08a5503e7cb",
 CellID->415014507]
}, Open  ]],
Cell[278244, 6526, 289, 8, 22, "SolutionAnswer",ExpressionUUID->"867ffe45-f4d8-468a-b58d-5bdb1ada9248",
 CellID->359479873],
Cell[CellGroupData[{
Cell[278558, 6538, 740, 23, 47, "ExerciseInput",ExpressionUUID->"2d998ed1-28f1-42d4-82ea-0b568b8d2f58",
 CellID->597407880],
Cell[279301, 6563, 252, 6, 44, "ExerciseOutput",ExpressionUUID->"c55a839c-188b-4bfa-94dd-b1dc2bae2ab0",
 CellID->930182465]
}, Open  ]],
Cell[279568, 6572, 123, 1, 22, "SolutionAnswer",ExpressionUUID->"1d3b3c5b-26ca-42bc-acb9-5ffd1a4dbcee",
 CellID->542438939],
Cell[CellGroupData[{
Cell[279716, 6577, 168, 3, 25, "ExerciseInput",ExpressionUUID->"9bc1437f-9f1d-4158-8cc2-e4c456f7c363",
 CellID->58319117],
Cell[279887, 6582, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"b3d6bc14-af6c-46f9-883a-9724bf2a8fa0",
 CellID->435537851]
}, Open  ]],
Cell[280061, 6587, 371, 9, 22, "SolutionAnswer",ExpressionUUID->"f9cfd3ee-c755-437d-a11d-8157e895753b",
 CellID->148402553]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[280483, 6602, 309, 6, 135, "SmallText",ExpressionUUID->"ede7bf34-5fda-4b04-ad42-02e886ff6f0a",
 CellGroupingRules->"SectionGrouping",
 CellID->392434739]
}
]
*)

(* NotebookSignature AQWGdVTOyGKI4jYgaiQNDDNv *)
