(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    648482,      12232]
NotebookOptionsPosition[    472171,       8591]
NotebookOutlinePosition[    635124,      11979]
CellTagsIndexPosition[    635048,      11974]
WindowTitle->18. Properties of Harmonic Functions | Essentials of Complex \
Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Properties of Harmonic Functions"
}], "Section",
 CounterAssignments->{{"Section", 17}},
 CellID->157056355,ExpressionUUID->"ba31ad40-080a-4c38-9983-e0ded3793494"],

Cell["\<\
This chapter will introduce you to two further properties of harmonic \
functions: the mean-value property and the maximum and minimum principles.\
\>", "Text",
 CellID->315481809,ExpressionUUID->"6cdfcdaa-d733-491b-b926-3cb3401ecbdd"],

Cell[CellGroupData[{

Cell["Mean-Value Property for Harmonic Functions", "Subsection",
 CellID->372444181,ExpressionUUID->"591ac6b2-a268-4c11-b5c2-0d68d22248c6"],

Cell[TextData[{
 "As a consequence of Cauchy\[CloseCurlyQuote]s integral formula, a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4c599e1c-ecfa-422b-b8bb-1bba5ab55a39"],
 " that is analytic in a region containing a circle of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "58a0e1db-1891-4490-9f8a-ae210ecd3815"],
 " around ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "48c408a6-eca6-4319-afc2-515fae469ce8"],
 " has the mean-value property"
}], "Text",
 CellID->458002980,ExpressionUUID->"5d31c366-285f-4666-9034-22927d312cd5"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", 
     RowBox[{"(", 
      SubscriptBox["z", "0"], ")"}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Integral]", "0"], 
       RowBox[{"2", "\[Pi]"}]], 
      RowBox[{
       RowBox[{"f", "(", 
        RowBox[{
         SubscriptBox["z", "0"], "+", 
         RowBox[{"r", " ", 
          SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
        ")"}], 
       RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->21074420,ExpressionUUID->"e58e9c17-bcec-448d-953d-068ce9c4def5"],

Cell[TextData[{
 "already discussed in ",
 ButtonBox["Chapter 14",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{
    "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "Text",
 CellID->206676896,ExpressionUUID->"857c1d18-f25e-44a8-b0e3-0e74b0ec0651"],

Cell["Harmonic functions also have this property.", "Text",
 CellID->635667555,ExpressionUUID->"f3edec38-6d23-4eee-b668-6715ea1645ed"],

Cell[TextData[{
 "A real-valued function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5b7b6bcc-5086-452f-aaf1-f4fced84b55a"],
 " is called harmonic if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["u", 
      RowBox[{"x", " ", "x"}]], "+", 
     SubscriptBox["u", 
      RowBox[{"y", " ", "y"}]]}], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fd08f07a-9174-43dd-87b9-65484f62a293"],
 ". The real and imaginary parts of an analytic function are harmonic and \
vice versa. So, writing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], "=", 
     RowBox[{"(", 
      RowBox[{"x", ",", "y"}], ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ef0aeba7-4eea-46db-be0e-698e9eb35d03"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"u", "(", 
      RowBox[{"x", ",", "y"}], ")"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"v", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d9c98688-ca8e-4cdf-b131-810f752c2210"],
 ", one has"
}], "Text",
 CellID->83806537,ExpressionUUID->"92fa212d-d1f5-4988-b81e-02fbe7936431"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"f", "(", 
       SubscriptBox["z", "0"], ")"}], "\[AlignmentMarker]\[AlignmentMarker]", 
      "=", 
      RowBox[{
       RowBox[{"u", "(", 
        RowBox[{
         SubscriptBox["x", "0"], ",", 
         SubscriptBox["y", "0"]}], ")"}], "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"v", "(", 
         RowBox[{
          SubscriptBox["x", "0"], ",", 
          SubscriptBox["y", "0"]}], ")"}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"2", "\[Pi]"}]], 
         RowBox[{
          SuperscriptBox[
           SubscriptBox["\[Integral]", 
            RowBox[{"\[VeryThinSpace]", "0"}]], 
           RowBox[{"2", "\[Pi]"}]], 
          RowBox[{"u", "(", 
           RowBox[{
            SubscriptBox["z", "0"], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
           ")"}]}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"v", "(", 
          RowBox[{
           SubscriptBox["z", "0"], "+", 
           RowBox[{"r", " ", 
            SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
          ")"}], 
         RowBox[{
          RowBox[{"\[DifferentialD]", "\[Theta]"}], "."}]}]}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->89954287,ExpressionUUID->"ad5c324f-d238-46cd-ab7c-3385b2d2855a"],

Cell["\<\
Taking the real part of this formula, it follows that harmonic functions also \
have the mean-value property\
\>", "Text",
 CellID->572690948,ExpressionUUID->"351b73bc-348a-48f2-aeb2-728db8ca2cbb"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"u", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["x", "0"], ",", 
       SubscriptBox["y", "0"]}], ")"}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      SuperscriptBox[
       SubscriptBox["\[Integral]", "0"], 
       RowBox[{"2", "\[Pi]"}]], 
      RowBox[{
       RowBox[{"u", "(", 
        RowBox[{
         SubscriptBox["z", "0"], "+", 
         RowBox[{"r", " ", 
          SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
        ")"}], 
       RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->222976354,ExpressionUUID->"d4e9bfdb-efda-4233-a16c-8662c45c8896"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"v", "(", 
    RowBox[{
     SubscriptBox["x", "0"], ",", 
     SubscriptBox["y", "0"]}], ")"}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "0"], 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      RowBox[{"v", "(", 
       RowBox[{
        SubscriptBox["z", "0"], "+", 
        RowBox[{"r", " ", 
         SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
       ")"}], 
      RowBox[{
       RowBox[{"\[DifferentialD]", "\[Theta]"}], "."}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->358249251,ExpressionUUID->"b1855a07-6f27-45fe-a429-929b242c5a15"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellTags->"Example181",
 CellID->647135627,ExpressionUUID->"368efd31-ec6b-42d9-8b47-280a554e13cc"],

Cell[TextData[{
 "Take ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "-", 
     FractionBox[
      SuperscriptBox["y", "2"], "2"], "-", "x", "+", "y", "+", "1"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "e7f3fd25-c6c6-43f6-a126-b6ca54a39297"],
 " and verify that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"939addf2-ef06-43a4-9631-3b62f9873786"],
 " is harmonic. Check the mean-value property for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "0"], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["x", "0"], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["y", "0"]}]}], "=", 
     RowBox[{"2", "+", 
      RowBox[{
       FractionBox["7", "4"], "\[ImaginaryI]"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"262fcb7a-1e14-4209-a50c-893dee72ef7a"],
 ":"
}], "SolvedExampleNote",
 CellID->74433536,ExpressionUUID->"0404c258-cbca-4821-b03e-5518a27cae94"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "/", "2"}], "-", 
    RowBox[{
     SuperscriptBox["y", "2"], "/", "2"}], "-", "x", "+", "y", "+", "1"}]}], 
  ";"}]], "SolvedExampleInput",
 CellID->478784849,ExpressionUUID->"13a8c05b-5148-4034-ba9c-0d0115dc2d66"],

Cell[TextData[{
 "Use ",
 ButtonBox["Laplacian",
  BaseStyle->"Link"],
 " to check that ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7a3ed752-5afd-45d7-b903-139dad987b38"],
 " is harmonic:"
}], "SolvedExampleNote",
 CellID->83208634,ExpressionUUID->"e5961534-d25e-477d-bbca-0c900dc60585"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->240465215,ExpressionUUID->"869c0ac0-277f-491a-acd7-505777c08937"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->178561954,ExpressionUUID->"c5d9fe48-8bc2-4915-ab5c-a4d02c5187ff"]
}, Open  ]],

Cell[TextData[{
 "The equation of a circle of radius ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bb84417e-5c12-412d-b34f-fa27cfe85f50"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "0"], "=", 
    RowBox[{"2", "+", 
     RowBox[{
      FractionBox["7", "4"], "\[ImaginaryI]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"48501a8f-071e-41f9-b484-980a3811a0c9"],
 " is:"
}], "SolvedExampleNote",
 CellID->55866720,ExpressionUUID->"418636bb-ae47-41a1-abfc-7e98a31f139d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"2", "+", 
   RowBox[{
    FractionBox["7", "4"], "\[ImaginaryI]"}], "+", 
   RowBox[{"r", " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}], ")"}]}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->675806070,ExpressionUUID->"d7bedcf0-3629-4d8f-b026-5547610b3564"],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"r", " ", 
   RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["7", "4"], "+", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], 
    ")"}]}]}]], "SolvedExampleOutput",
 CellID->48054138,ExpressionUUID->"aaefd654-f22d-4696-bedc-9369fa13ffe0"]
}, Open  ]],

Cell["Check the mean-value property:", "SolvedExampleNote",
 CellID->12561172,ExpressionUUID->"e2b6b126-4f83-443a-aa57-eb24a36f15e3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"2", ",", 
    FractionBox["7", "4"]}], "]"}], "==", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]"}]], 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{
       RowBox[{"2", "+", 
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
       RowBox[{
        FractionBox["7", "4"], "+", 
        RowBox[{"r", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]}]], "SolvedExampleInput",
 CellID->108993027,ExpressionUUID->"f91eef30-fb26-4516-9395-fa7761caf28b"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->519278688,ExpressionUUID->"600e6ee1-8b3f-4674-8806-0f3292ebe424"]
}, Open  ]],

Cell["\<\
Visualizing this property, it means that the height of the surface at the \
blue point is the average of the heights of the points on the red curve:\
\>", "SolvedExampleNote",
 CellID->52391262,ExpressionUUID->"a1810c24-fc22-4d4c-8ea0-65ae82f2087f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "/", "2"}], "-", 
       RowBox[{
        SuperscriptBox["y", "2"], "/", "2"}], "-", "x", "+", "y", "+", "1"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"BoxRatios", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"AxesLabel", "->", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "->", 
       RowBox[{"Opacity", "[", "0.8", "]"}]}], ",", 
      RowBox[{"ImageSize", "->", "230"}]}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "0.03", "]"}], ",", "Blue", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"3", "/", "4"}], ",", 
          RowBox[{"47", "/", "32"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "+", 
         FractionBox[
          RowBox[{"Cos", "[", "t", "]"}], "2"]}], ",", 
        RowBox[{
         FractionBox["3", "4"], "+", 
         FractionBox[
          RowBox[{"Sin", "[", "t", "]"}], "2"]}], ",", 
        RowBox[{
         FractionBox["1", "32"], " ", 
         RowBox[{"(", 
          RowBox[{"47", "+", 
           RowBox[{"16", " ", 
            RowBox[{"Cos", "[", "t", "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"Cos", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "+", 
           RowBox[{"4", " ", 
            RowBox[{"Sin", "[", "t", "]"}]}]}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"PlotStyle", "->", "Red"}]}], "]"}]}], "}"}], 
  "\[IndentingNewLine]", "]"}]], "SolvedExampleInput",
 CellID->350235593,ExpressionUUID->"1de5c70f-3eda-4433-9b88-7aeadb40d03d"],

Cell[BoxData[
 Graphics3DBox[{{GraphicsComplex3DBox[CompressedData["
1:eJytnXtYTVn8/4+STINccsslZo5r7sUotEuYDqYxcsmghkgux6URzUzJFCJl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     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.8], EdgeForm[None], 
        Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJwtmQXYFkUXhne+s1hg0yoIKqW00kgp3Ug3SIpi0mVREoIN2AWigN3d3d1g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             "]], Polygon3DBox[CompressedData["
1:eJwtmmWgHdUZRe+cc4NLkeASgrsHSAIEJyRBEiAESCC4OwS34MHd3d3dHYoU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             "]], Polygon3DBox[CompressedData["
1:eJwt1me0VNUVAOD35jF0C1UBpXeV3nuv0gWkI71I7yAdqdKR3pEuoqhAxGgS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             "]], 
            Polygon3DBox[{{1094, 289, 739, 471, 172, 948}, {1193, 738, 741, 
             280, 182, 944}, {1190, 727, 522, 265, 300, 979}, {1167, 693, 489,
              293, 292, 949}}]},
           Annotation[#, "Charting`Private`Tag$4536#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {GrayLevel[1], EdgeForm[None], 
        StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtk8lOVUEQhrtP04gQhcATuFbjAk1kqbwBWzYCulAUNMEncWSBA8OGHUii
MgoCCvdeAREQvJo45DphclUiqAn6Vf6zqPxfV3dX16mqc6C5vaEtcc41YAG7
FJ1bwdFX4lwnVu2dq0dX8dXARfQP5+5j5bZGd7CP2Ch7Vfi+oSe48wVtJN4A
WoH/M3oI/374JHqP9T74KzqEVcKbKY8S75NXzBm4CHsvv0NPE/cxezeI8471
X9w/WG865VTAtlI23wR7T9GfnH0Ez9k+PAbPwt/hcfiJxfH6Jru7jLXx1nP2
uktUm9f4ytBJCjYPH8G/yHrdaog+w9YsTXQay1qNiLkMv4JL0X7uJPjq0AXW
L/En6FHWebSDN09F5XcF3wya48xv7uTgVasDmsFegLtWA7gUfWs+LI9/T6Le
vYH3oseINQ3Xooe9/GVe9bU659McCumZYtpbW2fZW0H/efX0Afw+nYGttFbW
kwy6jb+K/KfSHrVG1eW21SqoJr3wuajvuQVfjpqJg/BUUK9vwnNBuXXB80H9
svNno3Iy/1jQTF6FM0F9tLcWgvLpgSfgh/B1+Dg27PTWUqI+/iLnbNCc3ME/
HvSN1+ALUT2+C7dH9dJiNkXNjb17PqqXdrcSnkw0G7mgebO7S0F9tP/rYlSf
rA7NUTNqbw0myvMD+bREzavlXB2Vq83hmajZsvrYbG5wPiZ6076r4FX7Eesf
/B87KqOE
            "]], Polygon3DBox[CompressedData["
1:eJwtk1lvjVEUhvfe3z4iIob+A9ckLhDEleHCtVs3FBemlgR/xJC4MIX+ACIx
dqRoT0eqpkaCOkUaQw0lKM+bd1+sc9bz7fWt713DXtbcuq0lhRC2Yhm7yE+d
/58xhNZaCJfgAfgXfAg+Dz+Av8EH4I4qhPtwB0l2wnuwj/iZ8w3ZJr8JO42/
ArtFfAM+RuwFuA/+Dh+ER8k3AY8lf28EfgE/StYzDD+HH8ItcGdlPZ1wM9xV
OV8XvAvuqVzPHXh3zXpUz91krSfga/CbaP1DxD+DR5L1nOL8Bvw2Ot8+bCa6
5jqx++Gv0RoGKsco9mYoWrAxxZLvSM01/8BfFN2LvfAX/HvE9BO7imcN/Cls
Df7Rkk8a1mb3XL1XjYPEn81+V5qkTT3TrAaDe3mS8+v4k9H9keZxvZscL81P
4KHkWpTzKTyc/C1peqzakrV+4r9W8veWmat3+oZ2QTPS7qjHmp16qNn2B/f2
DHp6g2tWvsPYK/LMg7dwth5L+Eux4/jrsLngnql37ZXrbYd3wOeyZ6EZSL+e
vY6eqWIXl+/3lXlszq5B2rWPSzSPoq+b87bs2qRJ2pqwnLwT0q8Y7W9P8rub
iP8X/Ezz1Iw1a81wNbwyO7c0SMvy7N3QTDXbqeh3lWM2WaPOu5Pjt2NX8BcS
tzFbl/RpBr/x32N/gvt/Gf8zNp+zl/A4/rQuN3ybv6vJO6RdUk7l1h2ajb4j
ulszPF9Q+qc+6s68K+/rLs3hTwfXVy85PvD/t+yneqR6R5N7p35MJM9cd0E7
OFn2WXdXM22U+6JZ/wft670R
            "]], Polygon3DBox[CompressedData["
1:eJwt0c1OE2EUh/HpzBQwSEC9AOLahQtI1LjlCrwCQnBb48Ir8Xshgh8bdyoJ
JtICFQSltaBtNVo2aoDEaFSIIB/Cb/K6eHLO/3nPvNOeOTl06UIhjqKoF3kc
EVbU9lwUnUBT7kujaJb7Kbfkfvk25vR/uYqz8/JVHJN35c/qoAtPczPmVuXn
/EwS5orcL26OOyefwb6+i3vq7Ipnb3GTXI77wV3kHnINfQdazpbd94Cry+34
xC1x97l3chs+cjXuJleW19y3jmH33eOWuT/yFgr5cJbNbPHd6rg6kIadZLvJ
3n/Z3Bd5Qt5Bp/5xHHaU7SpRezAZh3e8VfNIcdyzY9ySPsEH81W/b5SryTHe
cxVuhKtmHwgN5XUS9pXtLbv7Ox7JX73rGbeHo/on/B2+oh7Idf5VEnY6y21z
i1yZu8aVuN/cS67I3eXecDk0ucX/+3sRhz1l++rxP65zU9yGPG+uZO5UGr7h
N/zjzso3MC1vmlvgpswdAg8cZIY=
            "]]}],
         Lighting->{{"Ambient", 
            GrayLevel[0.8]}}]}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt0k9Ik2EcwPGn/FduqYeydLplms0/FRoSC0eIbDP0FASVt256MCgCvYqg
VwvqKkJdFCKoW7cunTt03SLWH6VDrWUTCT8vdPi+n9/z7oXnebf13Lt/c+FI
COGx/iiaf+mz/h0NoY3xuhBSTPASB5llhjOc4ixv847mzY+4xBWu8QmfcZMv
+IpveK0+hJM2PaWf9stZt5tP64zK7nWwUwlVrLvYrS3P/rZOmlOqms/yC3uY
9/k5frXu5V/28bxq5n5e0Lbn9q3T5m8cYMG9QQ7pwL1hHlezuejcMZZY5HfW
9ElV/dBH7/eB7/mOb/maL/mcG3zKda5ymYt8yAeaM9/iXeY5zascZ5oX2cEk
R521zD21qqJd3XDeFhZ4gjnGOckYJ6L34fXo3Zjlseg3YUZN0Z5s5BgbeIW2
CyO0fbhMX0Eouez8/w8dAu4rPyw=
         "]], 
        Line3DBox[{259, 196, 1077, 231, 248, 211, 244, 236, 510, 212, 511, 
         213, 512, 214, 513, 215, 514, 216, 515, 217, 516, 517, 218, 518, 219,
          519, 220, 520, 221, 521, 222, 301, 264, 752, 275, 263, 1092, 262, 
         763, 261, 751, 1091, 274, 260, 750, 257, 256, 748, 271, 759, 255, 
         1090, 270, 758, 254, 747, 269, 253, 746, 1089, 268, 252, 745, 267, 
         250, 266, 754, 251, 273, 258, 1194, 749, 272, 259}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{766, 1073, 524, 765, 1197, 983, 767, 1198, 984, 768, 1199, 
         985, 769, 1200, 986, 770, 1201, 987, 771, 1202, 1096, 1299, 772, 
         1203, 988, 773, 1204, 989, 774, 1205, 990, 775, 1206, 991, 776, 1207,
          992, 777, 1208, 993, 778, 1192, 1209, 994, 1074}], 
        Line3DBox[{780, 1097, 1300, 779, 539, 781, 1210, 995, 782, 1211, 996, 
         783, 1212, 997, 784, 1213, 998, 785, 1214, 1098, 1301, 786, 1099, 
         1302, 787, 1215, 999, 788, 1216, 1000, 789, 1217, 1001, 790, 1218, 
         1002, 791, 1219, 1003, 792, 1220, 1004, 793}], 
        Line3DBox[{795, 1100, 1303, 794, 1101, 1304, 796, 555, 797, 1221, 
         1005, 798, 1222, 1006, 799, 1223, 1007, 800, 1224, 1102, 1305, 801, 
         1103, 1306, 802, 1104, 1307, 803, 1225, 1008, 804, 1226, 1009, 805, 
         1227, 1010, 806, 1228, 1011, 807, 1229, 1012, 808}], 
        Line3DBox[{810, 1105, 1308, 809, 1106, 1309, 811, 1107, 1310, 812, 
         571, 813, 1230, 1013, 814, 1231, 1014, 815, 1232, 1108, 1311, 816, 
         1109, 1312, 817, 1110, 1313, 818, 1111, 1314, 819, 579, 820, 1233, 
         1015, 821, 1234, 1016, 822, 1235, 1017, 823}], 
        Line3DBox[{825, 1112, 1315, 824, 1113, 1316, 826, 1114, 1317, 827, 
         1115, 1318, 828, 587, 829, 1236, 1018, 830, 1237, 1116, 1319, 831, 
         1117, 1320, 832, 1118, 1321, 833, 1119, 1322, 834, 1120, 1323, 835, 
         1121, 1324, 836, 1238, 1019, 837, 1239, 1020, 838}], 
        Line3DBox[{840, 1122, 1325, 839, 1123, 1326, 841, 1124, 1327, 842, 
         1125, 1328, 843, 1126, 1329, 844, 603, 845, 1240, 1127, 1330, 846, 
         1128, 1331, 847, 1129, 1332, 848, 1130, 1333, 849, 1131, 1334, 850, 
         1132, 1335, 851, 1133, 1336, 852, 1241, 1021, 853}], 
        Line3DBox[{857, 1242, 1022, 855, 1243, 1023, 859, 1244, 1024, 861, 
         1245, 1025, 863, 1246, 1026, 865, 1247, 1027, 867, 1248, 620, 869, 
         1249, 1028, 871, 1250, 1029, 873, 1251, 1030, 875, 1252, 1031, 877, 
         1253, 1032, 879, 1254, 1033, 881, 1255, 1034, 883}], 
        Line3DBox[{882, 1350, 1146, 880, 1349, 1145, 878, 1348, 1144, 876, 
         1347, 1143, 874, 1346, 1142, 872, 1345, 1141, 870, 1344, 1140, 868, 
         1343, 619, 866, 1342, 1139, 864, 1341, 1138, 862, 1340, 1137, 860, 
         1339, 1136, 858, 1338, 1135, 854, 1337, 1134, 856}], 
        Line3DBox[{885, 1147, 1351, 884, 1256, 1035, 886, 1257, 1036, 887, 
         1258, 1037, 888, 1259, 1038, 889, 1260, 1039, 890, 1261, 1148, 1352, 
         891, 636, 892, 1262, 1040, 893, 1263, 1041, 894, 1264, 1042, 895, 
         1265, 1043, 896, 1266, 1044, 897, 1267, 1045, 898}], 
        Line3DBox[{900, 1149, 1353, 899, 1150, 1354, 901, 1268, 1046, 902, 
         1269, 1047, 903, 1270, 1048, 904, 1271, 1049, 905, 1272, 1151, 1355, 
         906, 1152, 1356, 907, 652, 908, 1273, 1050, 909, 1274, 1051, 910, 
         1275, 1052, 911, 1276, 1053, 912, 1277, 1054, 913}], 
        Line3DBox[{915, 1153, 1357, 914, 1154, 1358, 916, 1155, 1359, 917, 
         1278, 1055, 918, 1279, 1056, 919, 1280, 1057, 920, 1281, 1156, 1360, 
         921, 1157, 1361, 922, 1158, 1362, 923, 668, 924, 1282, 1058, 925, 
         1283, 1059, 926, 1284, 1060, 927, 1285, 1061, 928}], 
        Line3DBox[{930, 1159, 1363, 929, 1160, 1364, 931, 1161, 1365, 932, 
         676, 933, 1286, 1062, 934, 1287, 1063, 935, 1288, 1162, 1366, 936, 
         1163, 1367, 937, 1164, 1368, 938, 1165, 1369, 939, 684, 940, 1289, 
         1064, 941, 1290, 1065, 942, 1291, 1066, 943}], 
        Line3DBox[{945, 1166, 1370, 944, 1193, 1399, 946, 1084, 1400, 947, 
         1085, 1195}], 
        Line3DBox[{956, 1070, 1294, 955, 1069, 1293, 954, 697, 953, 1375, 
         1170, 952, 1374, 1169, 951, 1373, 1168, 950, 1372, 1167, 949, 1401, 
         1086, 1292, 948, 1094}], 
        Line3DBox[{968, 1072, 1297, 967, 713, 966, 1384, 1180, 965, 1383, 
         1179, 964, 1382, 1178, 963, 1403, 1196}], 
        Line3DBox[{982, 1078, 733, 981, 1395, 1191, 980, 1394, 1190, 979, 
         1404, 1088, 978, 1095}], Line3DBox[{1082, 1087, 1402, 1093}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{303, 525, 1197, 304, 539, 332, 1304, 554, 347, 1309, 569, 
         362, 1316, 584, 377, 1326, 599, 392, 1338, 614, 1243, 407, 629, 1256,
          422, 1354, 644, 437, 1358, 659, 452, 1364, 674, 467, 1399, 738, 
         741}], Line3DBox[{305, 526, 1198, 306, 540, 1210, 333, 555, 348, 
         1310, 570, 363, 1317, 585, 378, 1327, 600, 393, 1339, 615, 1244, 408,
          630, 1257, 423, 645, 1268, 438, 1359, 660, 453, 1365, 675, 468, 
         1400, 755}], 
        Line3DBox[{307, 527, 1199, 308, 541, 1211, 334, 556, 1221, 349, 571, 
         364, 1318, 586, 379, 1328, 601, 394, 1340, 616, 1245, 409, 631, 1258,
          424, 646, 1269, 439, 661, 1278, 454, 676, 469, 756}], 
        Line3DBox[{309, 528, 1200, 310, 542, 1212, 335, 557, 1222, 350, 572, 
         1230, 365, 587, 380, 1329, 602, 395, 1341, 617, 1246, 410, 632, 1259,
          425, 647, 1270, 440, 662, 1279, 455, 677, 1286, 470, 757}], 
        Line3DBox[{311, 529, 1201, 312, 543, 1213, 336, 558, 1223, 351, 573, 
         1231, 366, 588, 1236, 381, 603, 396, 1342, 618, 1247, 411, 633, 1260,
          426, 648, 1271, 441, 663, 1280, 456, 678, 1287, 471, 739, 742}], 
        Line3DBox[{313, 530, 1202, 315, 544, 1214, 337, 559, 1224, 352, 574, 
         1232, 367, 589, 1237, 382, 604, 1240, 397, 619, 1248, 412, 634, 1261,
          427, 649, 1272, 442, 664, 1281, 457, 679, 1288, 472, 740, 1292, 
         743}], Line3DBox[{317, 532, 1203, 318, 1302, 546, 339, 1306, 561, 
         354, 1312, 576, 369, 1320, 591, 384, 1331, 606, 399, 1344, 621, 1249,
          414, 636, 429, 1356, 651, 444, 1361, 666, 459, 1367, 681, 474, 1372,
          693, 489, 761}], 
        Line3DBox[{319, 533, 1204, 320, 547, 1215, 340, 1307, 562, 355, 1313, 
         577, 370, 1321, 592, 385, 1332, 607, 400, 1345, 622, 1250, 415, 637, 
         1262, 430, 652, 445, 1362, 667, 460, 1368, 682, 475, 1373, 694, 490, 
         1403, 762}], 
        Line3DBox[{321, 534, 1205, 322, 548, 1216, 341, 563, 1225, 356, 1314, 
         578, 371, 1322, 593, 386, 1333, 608, 401, 1346, 623, 1251, 416, 638, 
         1263, 431, 653, 1273, 446, 668, 461, 1369, 683, 476, 1374, 695, 491, 
         1382, 710, 744}], 
        Line3DBox[{323, 535, 1206, 324, 549, 1217, 342, 564, 1226, 357, 579, 
         372, 1323, 594, 387, 1334, 609, 402, 1347, 624, 1252, 417, 639, 1264,
          432, 654, 1274, 447, 669, 1282, 462, 684, 477, 1375, 696, 492, 1383,
          711, 506, 1404, 764}], 
        Line3DBox[{325, 536, 1207, 326, 550, 1218, 343, 565, 1227, 358, 580, 
         1233, 373, 1324, 595, 388, 1335, 610, 403, 1348, 625, 1253, 418, 640,
          1265, 433, 655, 1275, 448, 670, 1283, 463, 685, 1289, 478, 697, 493,
          1384, 712, 507, 1394, 727, 522}], 
        Line3DBox[{327, 537, 1208, 328, 551, 1219, 344, 566, 1228, 359, 581, 
         1234, 374, 596, 1238, 389, 1336, 611, 404, 1349, 626, 1254, 419, 641,
          1266, 434, 656, 1276, 449, 671, 1284, 464, 686, 1290, 479, 698, 
         1293, 494, 713, 508, 1395, 728, 523}], 
        Line3DBox[{329, 730, 731, 1209, 330, 552, 1220, 345, 567, 1229, 360, 
         582, 1235, 375, 597, 1239, 390, 612, 1241, 405, 1350, 627, 1255, 420,
          642, 1267, 435, 657, 1277, 450, 672, 1285, 465, 687, 1291, 480, 699,
          1294, 495, 714, 1297, 509, 733, 734, 735}], 
        Line3DBox[{736, 729, 524, 302, 1300, 538, 331, 1303, 553, 346, 1308, 
         568, 361, 1315, 583, 376, 1325, 598, 391, 1337, 613, 1242, 406, 1351,
          628, 421, 1353, 643, 436, 1357, 658, 451, 1363, 673, 466, 1370, 688,
          481, 1402, 753}], 
        Line3DBox[{760, 1401, 473, 680, 1366, 458, 665, 1360, 443, 650, 1355, 
         428, 635, 1352, 413, 620, 1343, 398, 605, 1330, 383, 590, 1319, 368, 
         575, 1311, 353, 560, 1305, 338, 545, 1301, 316, 531, 1299, 
         314}]}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzs/HlUje/7/42XTKEJKQmRkMwqoTqIJCRSJEMSKWMRkqLJVEQyRaYUDaZK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      "]], {}}, 
   {RGBColor[0, 0, 1], PointSize[0.03], 
    Point3DBox[
     NCache[{2, Rational[3, 4], Rational[47, 32]}, {
      2, 0.75, 1.46875}]]}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[2], Line3DBox[CompressedData["
1:eJw12nk0lN8bAPCXsZZdi31JiFSS7PW8qGSpVLJUIklJhUhZk8qWaKNkb6VC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        "]]},
      Annotation[#, "Charting`Private`Tag$4578#1"]& ]}, {}}},
  Axes->True,
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox["x", HoldForm], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox["y", HoldForm], HoldForm], TraditionalForm], None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 1},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{229.75166050909596`, 239.80882935989996`},
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{0., 3.}, {0., 3.}, {0., 3.}},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-1.9425339468461165`, -2.37910085319974, 1.4200144350163042`},
  ViewVertical->{0.26541217919407134`, 0.3250611619917495, 
   0.9076847559037377}]], "SolvedExampleOutput",
 CellID->292772797,ExpressionUUID->"357a32ec-3a5e-41a0-aaf3-49bdc2a39950"]
}, {2}]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"0d40e52c-80b5-4deb-8309-eb8f33c19358"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->95679362,ExpressionUUID->"82f71ee7-00a3-43c9-aa02-e2cba969cf85"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Omega]", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["y", "4"], "+", 
     SuperscriptBox["x", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2af5753b-f483-4e29-8894-db960653d43c"],
 " does not satisfy the mean value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"0", ",", "0"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"28d377e1-883b-40ba-b845-e2b52e4ef01d"],
 ":"
}], "SolvedExampleNote",
 CellID->193021385,ExpressionUUID->"c39af8cc-38e0-4c54-8cd1-d7110bc707f0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"y", "^", "4"}], "+", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"0", ",", "0"}], "]"}], "==", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]"}]], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
       RowBox[{"r", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}]}], "SolvedExampleInput",\

 CellID->8544700,ExpressionUUID->"61bea227-9f69-4f4f-b45e-1c1f70869315"],

Cell[BoxData[
 RowBox[{"0", "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["r", "2"], "+", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["r", "4"]}], "2"]}], ")"}]}]}]], "SolvedExampleOutput",
 CellID->341933551,ExpressionUUID->"55abea34-419a-4d26-9d74-8887994cc54d"]
}, Open  ]],

Cell[TextData[{
 "The equality is not true for a circle of radius ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "!=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "78372b50-12ac-4133-91f9-910917c9d1a1"],
 ". The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"73f684c1-8ead-4477-89e4-caa75798ceec"],
 " is not harmonic:"
}], "SolvedExampleNote",
 CellID->309444499,ExpressionUUID->"add6a4e2-0596-4bba-8bd1-9b779ff563e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"w", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->1345682,ExpressionUUID->"270ffb2d-e4fd-43cf-a8d3-171b8b3158d2"],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["y", "2"]}]}]], "SolvedExampleOutput",
 CellID->292334741,ExpressionUUID->"650f35e2-d969-42f6-824c-73cbeefded7f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1741144738,ExpressionUUID->"d6c6206e-f993-4ced-af5c-7383be0e4f03"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Maximum and Minimum Principles for Harmonic Functions", "Subsection",
 CellID->214428598,ExpressionUUID->"ea8b9080-1ce5-4d58-b2e8-0fe968b2c2b9"],

Cell[TextData[{
 "You have learned that for an analytic function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d98d003e-cf8a-4ad0-9341-2523786c013b"],
 " that is not a constant, its absolute value ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"f", "(", "z", ")"}], "|"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"94309f98-5fd0-4965-8e1c-5a633103f227"],
 " cannot have its maximum in an open set but only on its boundary."
}], "Text",
 CellID->73486028,ExpressionUUID->"d65b1934-8da7-463c-acad-9a83b9d55ae8"],

Cell["\<\
Harmonic functions obey a similar theorem, which can be deduced from the \
mean-value property:\
\>", "Text",
 CellID->388093397,ExpressionUUID->"0d08d688-81b1-48f4-914f-da9e09ec3c69"],

Cell[TextData[{
 "Theorem:",
 " If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d9a77cce-6df8-4c54-9c30-079b909ce87a"],
 " is a harmonic function in the open set ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "62265940-7a4e-48b8-a671-6740474f7c51"],
 ", then:"
}], "Text",
 CellID->84429583,ExpressionUUID->"7ae03d27-22f3-4812-bcc9-ccc5114e2270"],

Cell[TextData[{
 "1. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7e899b0d-9280-0648-8f2a-c5f303b5ab48"],
 " has its maximum or minimum in ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "51491577-7588-d547-9fdd-b70cf36a001c"],
 ", then ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1483d150-b92c-2447-81e3-a0a7e4fe40e7"],
 " is constant."
}], "Text",
 CellID->97552304,ExpressionUUID->"bee6c135-0164-304f-af06-cc1b04815243"],

Cell[TextData[{
 "2. If in addition, ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6fcaaba0-98ec-9d46-ad53-7298ebd0bc46"],
 " is continuous on the boundary ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "302f392d-bcad-9640-9c33-8573859d24c9"],
 " of ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "cffa823b-a626-f541-9973-4e3d73c1feb8"],
 ", then its maximum and minimum occur on ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "704021bf-9949-b843-9fbb-00343182e067"],
 "."
}], "Text",
 CellID->350174740,ExpressionUUID->"d9c4db02-e899-7e48-8013-3f28f85f038f"],

Cell[TextData[{
 "Proof:",
 " The proof is similar to that of the maximum modulus theorem for analytic \
functions. From the mean-value property, it follows that, calling ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "0"], "=", 
    RowBox[{
     SubscriptBox["x", "0"], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SubscriptBox["y", "0"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"501963e9-4dc6-4992-8f2d-39981764df62"],
 ":"
}], "Text",
 CellID->193407973,ExpressionUUID->"a8892cb9-76b9-4838-bac1-58f135cfca4b"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{"u", "(", 
       RowBox[{
        SubscriptBox["x", "0"], ",", 
        SubscriptBox["y", "0"]}], ")"}], "\[AlignmentMarker]", "=", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]"}]], 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Integral]", 
          RowBox[{"\[VeryThinSpace]", "0"}]], 
         RowBox[{"2", "\[Pi]"}]], 
        RowBox[{
         RowBox[{"u", "(", 
          RowBox[{
           SubscriptBox["z", "0"], "+", 
           RowBox[{"r", " ", 
            SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
          ")"}], 
         RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"<=", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", "\[Pi]"}]], "\[CenterDot]", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]"}], ")"}], "\[CenterDot]", 
        RowBox[{
         SubscriptBox["max", "C"], "(", "u", ")"}]}]}]}]},
    {
     RowBox[{"\[AlignmentMarker]", 
      RowBox[{"=", 
       RowBox[{
        RowBox[{
         SubscriptBox["max", "C"], "(", "u", ")"}], "."}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->28247623,ExpressionUUID->"ccce96ae-3395-4fce-9413-de15a64b65ed"],

Cell[TextData[{
 "Suppose that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4d161b72-450a-490f-91f0-5a43dd5b33b2"],
 " is a local maximum. Then we must have that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{
      SubscriptBox["x", "0"], ",", 
      SubscriptBox["y", "0"]}], ")"}], "=", 
    RowBox[{
     SubscriptBox["max", "C"], "(", "u", ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"6fb82215-d744-4096-9a7f-03afd8d7d479"],
 " and the inequality in (5) must become an equality. But if ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b10cefcc-e10f-4226-afb4-dc1c3b3d9058"],
 " is a maximum, the equality ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", 
       RowBox[{"\[VeryThinSpace]", "0"}]], 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      RowBox[{"u", "(", 
       RowBox[{
        SubscriptBox["z", "0"], "+", 
        RowBox[{"r", " ", 
         SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]\[Theta]"]}]}], 
       ")"}], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "\[Pi]"}], ")"}], "\[CenterDot]", 
     RowBox[{
      SubscriptBox["max", "C"], "(", "u", ")"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9d60b8be-ac2b-4275-aa81-7a0e83c983b1"],
 " is possible only if ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "eaff4f29-4019-4273-8a27-f2192c6bc089"],
 " is a constant function."
}], "Text",
 CellID->54068897,ExpressionUUID->"f2a18442-6ecd-4c22-827b-52eac4ca8b78"],

Cell[TextData[{
 "By considering ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"-", "u"}], ")"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c634367c-3fba-4a8d-9192-ed299b5b2238"],
 ", the proof carries over for the minimum."
}], "Text",
 CellID->687820202,ExpressionUUID->"b15cc1f7-0ee6-4b24-8908-1566cb01d467"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->20251286,ExpressionUUID->"05f54faf-e6f6-4b1f-a184-392533f250fb"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["cosh", "2"], "y", " ", 
      SuperscriptBox["sin", "2"], "x"}], "-", 
     RowBox[{
      SuperscriptBox["cos", "2"], "x", " ", 
      SuperscriptBox["sinh", "2"], "y"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"de0d4da9-1196-4002-81c9-0bf3c99eca75"],
 " is harmonic, because it is the real part of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sin", "2"], "z"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"31060543-e4d6-4364-8d35-26e32656ef58"],
 ":"
}], "SolvedExampleNote",
 CellID->110116075,ExpressionUUID->"fbe095e0-100b-4e61-bb5b-233717b56dc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "^", "2"}], "//", "Re"}], 
  "//", "ComplexExpand"}]], "SolvedExampleInput",
 CellID->24659456,ExpressionUUID->"bf9c4c08-0b81-42fc-a6b7-965b1d391683"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", "y", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", "y", "]"}], "2"]}]}]], "SolvedExampleOutput",
 CellID->142652402,ExpressionUUID->"e26bcb3b-149b-417c-96ac-899d95e5d93a"]
}, Open  ]],

Cell[TextData[{
 "The plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cd47ffa2-a594-4a50-b5aa-2459113acde7"],
 " is shown here, with a closed curve marked in red:"
}], "SolvedExampleNote",
 CellID->207591563,ExpressionUUID->"ed094c75-f9a5-47e0-bec8-ba0b69de87a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cosh", "[", "y", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sinh", "[", "y", "]"}], "2"]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", "4"}], "}"}]}], ",", 
       RowBox[{"BoxRatios", "->", 
        RowBox[{"{", 
         RowBox[{"1", ",", " ", "1", ",", " ", "1"}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"x", ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"y", ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"HoldForm", "[", 
               RowBox[{"u", "[", 
                RowBox[{"x", ",", "y"}], "]"}], "]"}], ",", 
              "TraditionalForm"}], "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
       
       RowBox[{"PlotStyle", "->", 
        RowBox[{"Opacity", "[", "0.8", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "/", "2"}], 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"1", "/", "2"}], 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], ",", 
         RowBox[{
          RowBox[{
           SuperscriptBox[
            RowBox[{"Cosh", "[", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}], "]"}], "2"]}], "-", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", 
                RowBox[{"Cos", "[", "t", "]"}]}], ")"}]}], "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"Sinh", "[", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"Sin", "[", "t", "]"}]}], ")"}]}], "]"}], "2"]}]}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Blue", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.546", ",", "0.7096", ",", 
             RowBox[{"-", "0.0039"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1.283", ",", "0.913", ",", "1.834"}], "}"}]}], "}"}], 
         "]"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "}"}], ",", 
   RowBox[{"ImageSize", "->", "250"}]}], "]"}]], "SolvedExampleInput",
 CellID->370972587,ExpressionUUID->"9c782935-dbcc-41c7-aca9-872b3c5cdc3d"],

Cell[BoxData[
 Graphics3DBox[{{GraphicsComplex3DBox[CompressedData["
1:eJyVvXmciNX3Bz72ZYRQ1iIUSkKyf9yhkjVbyp4QEZGEkDVCWZJ9C5WdECLL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     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.8], EdgeForm[None], 
        Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxNnHX8FdX39W99Zu69M3NREBVEVMIG0a/dRQiKCgo2BnZ3oXSDSpiogICo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             "]], Polygon3DBox[CompressedData["
1:eJwtnAf8TtUfx+8zfs99njueQmlSinZpaP6blKKiSDRRirRLaSAUWYX2Qmga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             "]], Polygon3DBox[CompressedData["
1:eJwl13u0j1UaB/A3l99xnPM7cilEcjhuxy2R3CaOCZVGF5cy09QsuUQlZiaS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             "]], 
            Polygon3DBox[{{2693, 2692, 3608, 1992, 1993, 3609}, {3510, 1268, 
             1305, 1782, 1783, 3567}, {2788, 1725, 1969, 3599, 2690, 2691}, {
             2686, 2685, 3605, 1982, 1983, 3606}, {3590, 1874, 2559, 1521, 
             1520, 2735}, {2789, 1726, 1970, 3600, 2692, 2693}, {2682, 2681, 
             3596, 1963, 1964, 3597}, {2783, 1721, 1962, 3595, 2681, 2682}}]},
           
           Annotation[#, "Charting`Private`Tag$10929#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, 
       {GrayLevel[1], EdgeForm[None], 
        StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtVltvVFUU3jPnMudM50x4sGD0QQgSYsRYhiDlUi4tb8pVLkbk1iiYAG0C
CMIDEJUEeCCFIrSFVmMgQeTyA4CkEkwbLqUMUpnWSlJCxBAFtJjwxvfNtx72
rH3WXnuttff6vrVnTH3j4oa0c66I4WGsS5yb4zv3GeSl2LkaLL4dOdcN3SmM
mfjuwliBeSHl3J7Aud+xbxZkJ+zrsDYR9n6Fc69Cvyrn3CLYdmG8i7U/Q+f6
oT8KeRH2m6Dfg1iV2H8P+iiQ7QxP9h95ilXC2i6sYZv7G99nsGcB5GbIw7Ab
g3Edax22dyK+f8TaTXyfhkyga8R8DnIegryBMRo23yC/AuRbkEOhfDSFmtPm
GXL8HvJX7J8Eu79CnbcFcjv0S+DvCvy3mf/alGL2mP922JUwfw4/W2F3G3aV
kH2Qd83ntLxzOd4j7P6D3S3IYciVGEXYfALZDLsI8xuIfR7fLfjegnsu5KW7
knVuPu78GuadmJdg0wqbrbC5hnivQLcLtk/yijE5r7yZ/yD8noSuljWGHIA8
ibEUa6Ox72Pk1gw/LYn0bYlyYF0vxNJxzyinnJjbo0i1KFodv0hkvw1yOvy9
wXNDrseogM06yN0YCOeewq4zkn6cYY/1Y+1G2BzqMsYeQi6tkK7b8Pk/annU
E66I2W6r+9qMMBsjyErYtMP2QE51XmD14j0QT5sQYCPsa2Cfhv1U3NeBQFh6
MxIeWZfLsXKZCvlzVvjZkuhOP4XuPvadjVWX12H4HeLcwdqAU84jDDPEAzFW
lRZ+P/SF4SbD5LlYfBmJ+YScaktf9PMi1j1kre7t0N+L5afDeFdA7Llp5VQ0
Pf2zVoxLTk6IdH/1sOn1VS/u3WDcJEeJ4YW+ztiBtTWeYkexbOozqjXzfYqz
PwjFzQb4Pm/8JY/ZU9hbZsDuUSgurMI8HxsGQuXGWLyTg7C/Cvkv1rdHik1O
kb+/YD4WsX6C7WPDLc9E3vJcl6zPXLR+thHzjN0j7/NmVvu4n3fEuvAeWNdv
PdkTBzwLuXbIzkQuszabrRcR2+Rur91bXaB+WBuIH/RNjpCzrM9wXuci7oiN
LzPiI/sn8++z/jCdfPd0VwN2Rvo6EcrflFCYIh7Yy/7Ia+0B8qnz1c+JafYH
4n9sTlh5aPdcaX3pSKJ+QWyxFqPw3e/Jz13Lh7VoivQGDFvtiMFjkP/4qh15
vBM2P5CLsHmeVx/sweJv1suIh9We8ANVucez1zO/RuM4ecEe2GUxmQ95TX63
erqT2Sn1RWKAtTnmaW22YYAYYs799n6xDzAWfZasV5Kb7IczY/XxGsgGX77o
h3rijbibYne+I6M+wnyJeebcZj2qIaMz0c94YgC6J+yV1j/ZR1lrYq86Vr6M
NSulM7XanPVkLQrWj1hDvkd8T/rtLLy/1cZB4pR4JbYX++IOz78tUD+qCNTj
h6zX8S1mj2CvLmM8LZwvDFS7RZAuEO+WBeqZXCdfpsXKmX2PfZK8noyfDwL1
1XmQh3HOvZDFRPbkFHtMKqszsbcPGu/I2Wrrb+SpF6imy+1dHDSbrwK9u19D
tiaqxTvIq8reZf4fqcqJH/R7BDH60nq/eH/kArn72N4s+iRWyzKj9525lXOM
xEfWmjEZuzfRfxr+tyGe9wWKsx+yB2uvQXeavLa8+a7zbSY2+R+Dd3Ic+uZE
vGat3gvVJ0ppnf/9QBxJQ1aHisXcWGvikNhan6iWnye6h1P2LtNHu/nhf5Ba
q/VL96Y/UA==
            "]], Polygon3DBox[CompressedData["
1:eJw1lltsVFUUhveczh7mzMyZBxPF4ANiVULACDVohRZty5sXLooaFYyNog9S
jZRbNcbEOxqCFLGg9cGUBBXl2ahJhRoSBETxVhRNIEZ4IKICiW9+f/9N0pWu
fdZlr8u/1p5pvU8u7ctCCG9AZWhFHsJ2PvwCf6oSwmsxhI8QHIdegT9VDaGj
JYT9nFfDb5gUwt2lELbx7aaK7X+An42PfuRrixCWoHsEehr+Cr5diWwR593o
nsXmD+56CJsm57c535DZh+5fh34X/ndwXoC8Mzffzbc+7n6uGcJ/fMuJ7QD+
B/i2DNkI/tux31GYn8wd2+FXNEJ4L/Od5XoIf2N7EPkJaBV3zcXmLfx34uMJ
fN2smDj3If8CfhAf78BPw8c++PbcuasG69GfhY9bSraZh+wR6HiStyHbi00/
sb4ArcNPK/G0IXsY213k8iD636E/B/9Xo78Zuj7zt+XKs0Zc2F4VbfM7Ntfw
rR59j2qsWn8DfVg4flyEBZnj+YBvr6O7HhqDr2H7VHT9VMddfNsYrSPdIepx
FL9t2J+uuN+q5cLM+ZxE5xjyXmx/I5atnIfL7v+lhWNaG52zcl9Wd+11l3q3
k/896G9BfyS3H/lTDVVL1XgNti9H174D+VCSz6waj0PYHsPnn8TXO8n1vA+d
Krp7oKVl63wiW8XLeRzaA3+hYV+6czLnX/l+Ab0Z1GUe8X3Pt1b4Ue5pbRov
ivVr7jvBfTdCt5Yc03xkb3L+tsX4OAn/KPYbiH0AWpni70RGmBP653PHIowL
64e46zJkw+gsb7hH6tWz0OOFZ1CzqDg3RddA8a/i/HluvO8sO0flKgwIC/8i
+6tpvE3F9wHuuLNu/4eRHyq73+ebnpuRi/XB7n30F0fXZHPFszsxM/D38v0r
5FVy7oD/tHA/1dcz+LquYby8WzE+VEPpt0TX9h/0xrSAOE/H/xHtCNU793wI
Lz3kd3maV82IcC/8H07zLpliHKAWqwv3Rj3ohz+H/s+5MSlsnkmY6+b8GOdt
xHVX2TtN+NG3Z/B9bc262jf8TewM7R/hUb3tKruf6q945azcN5Lvj5n3h/q3
lZgewF8XlOFzSXSsinmKcqiZV81Ve2FcWH8J2lJYR3LVYDp8H/4GsT8YjK+z
TWNcO3ZNwupK9Ootxuwo5/2ZZ0L9/rLmeZCNbGcT48LoHaJdItLO0nxLpl50
I+/J3JNLorEjDM2Hn4o8i47pp9z4Ve7C+KyGMSvsqqaq7YyGYxcGXmy4hpoN
zfi+JNeu0Ru0t+Z+Li47ZsV+R/RsjEMz4c/lxrd2pHbl84VnQTOh2VZPStEz
qF4pJsWmWfkMmlN1bpo57e97ovGoHJXr3Kb53Wl+NA+aPb0xwpswrZ2l/Sqs
qz/Ch94I1UOYExa1F4RFvYnajcLjeO4Z0/wPp/6rJx/nxrDyHUT//mgMCUva
qbJXTS7iW75V07Y0b4pFO0Dvnd40vW3Cu/ar5k2zrjd4U9XvsfIbS2fVT+9Z
e6qP3v5XozEiPKgGqsWi9L4I7+rH7ciPFv5NoN8GwqP2bZbwoJlQ/HrfxoMx
qfdMPVQv1YOe6B2iXSI83ZZ2nmLXjtKuUr/0lmo3jKYdo1ktpd3zPwNwJt8=

            "]], Polygon3DBox[CompressedData["
1:eJwlj71vQWEYxY+P6+P6iEEisSAidkkjuiD+AInEarhLhwoWRpPJ1LRJE0Fn
S/8HsZgYSNDE1qlDVdDdTwwn7z3n+Z33uW/CalYadkkhZCCbKRX4yKM9/scl
dYNSmPzPKZVsUtUnPZCdvdIFzblgynxCFuV8pBsjS/qlVYBvsi3ckP4rPgk3
9UgplIHrwdlhivR+YVipuluakQ2Yf9HdoQy9JdkY4B//waxG14Ld0XmmX0de
8363zyE9Gff33N61Znec843Zhm6f7pG7iHRgbwvOxHTgyvgXZp/saeMnaEF2
wqdhcvzLN9kIJove2RXBXwHNJyo+
            "]]}],
         Lighting->{{"Ambient", 
            GrayLevel[0.8]}}]}, 
       {GrayLevel[1], EdgeForm[None], 
        StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw1mHnwlWUVx9/f777v3bj3ktWkJQjYjCAqCMi+WcmiAppjxWayqAmoLAoh
JRhm/VFmKsgMEBqMGJVNyb4LCQhKrAqyL4KRZpNpNQna98P3MHPfOc/73POc
5zxn+Z7zvM1GjL3tgfokSbbUJUlOdJZertLzpsZ/Fs1r8lLRDcUkqWquWz5J
xmk8U3OnRMfqmaHxb0pJcjxv3ks0d1bv67MkaVNOkqdCzmat76pxReOO2m+z
xiWNW4i+UJEO+n+t+NcVPb9WtGFqfnRcr/eyxs1Ej2mvL2vyPo1HSrEe4nu/
liTDtedy8fYVnS2et8V/ULp0zflsnKuR6N5674denBPdVkmHTnpfKfqk5O5K
rMNJPe01P19yBmVe20R0pub3aTyukCS/LXktNrlZutyk51n996WqdUCXd/Vf
Z41/J96faY9LJb+V6Dz9d0jzRzU/oWg90fd03r64XHM9Ja9DzrZcpb0XiK4W
LYtnh+Q0EH1d789r/g3RQ6IrRXdp/6P6b5N4nhA9pWevxjNEW2jvT8SzQzxN
NW4tn/RrkCQ1jVto3EfjQXq2iecN8czX/N0ab9e4ueS3Es9OyTor3dbr/Xb9
9w2d4XnpuVH0sN5P6v8joof1vlB8R0Qn6jyzxf+yxh9I1hfEs12yr6h3XGF3
ZBNXyE+k60aROtHuktFNzy/13yKt75U69p4omqeg+GknviHSYanm39a4pv07
av643n8v/hOik8Q/RzL+Jjqq4Hh8WmsOiL+h+DuJ/z/S6Vea+69oqvkNkp+J
vqL3Hpo/g6/07JecZ0Xn1nvcv86ye4qnveiA1P4k9s5EXBFf74TO6L6u4rNu
Ltv/XXL2PeuurHdcEDfEz2mNb09tL2Q1LToGhuocj8uek1Of88WwD3ZaW7HM
NaLLKz7L8rJzljx4Mm+ff0UyX02cX+TEL0Tbie8vskm+bDnky2MVx+db4pkp
+hK+lfze+m+5eHuJrhBtR4xq3FZ0tHS7QXyjRH+iNcu09oR0X1ZxbC8VbV7z
+V6veZ64elR0hNZ01dphonmtvVjzhbzzoUNg1OKK5b1Xs9+Rzz7k9Ub9P120
m86Q09w52aSN6EWJfdc/tX2wPXGeabyg4jz6oezaSzJ7iL9pYjvgR2JgieQ8
J56DegbWWQewYknFtmC+UeJYICaOabxYa76VOv5ZjxzisH2d8+IouCN7XSW6
LjP21sipovEO3APvsGev8PMw5enQOuceedxSPHu0fmfOMXQ1sSS9P8ucI2Av
uLtbPD+WnIfIIz1jNb5R9H7RwZJ5q2TN0/qBGvercy4MSn0eznKb5rtq/mPN
P6I1o8A90R/pGa/xHNFviqeDeIaKp2Nm/P0stc7/kIzV4vlEZ7ha40dl67OZ
/XUuM15xnvFFYwRYsU36byo75kvyyz0F264kGXdI7lDpJpJsldyi1hfEM1QT
gzR/JDEeEutjio5ZsHSEZP+gYEyerPmpBfttnWRO0dqH9QypMyW/yLPGFcfh
iopjmti+r2r8JOaJgWERt3eJXl8ynqwXbaU9rq+3T+8Pm48XXaX/fi6edqKv
6f2yzDg8lhjU/teIf1NmX2/OjF2dNR6dWufBGl8nnjs0vlbjr2rcsui6O7xk
nCfHV4s+JJ5bxDMx9dmJ33biba3na+IZWXKek++X1+wbfPR1ze/V3s00flN0
qZ6t4lkmemfF+dCk5pidq6ev5O7RHnv0fwv57SbwUfNiOe/3VzXftmzeOcFP
HBMbxMik1DHIfmByT635sOYaAx/6zIm9box4PZM4fu+SztdprkHZ+P6Mnk56
/0hyPi+eaVX3F89ET8KexPllog9qbePE+80NXP9c4lpNnR0mGW9lzpF9mfdl
jJ7UEfqQn+adEwPqjDXYmlwj5zpHzaHvYv+nQ4cN9Bji2Zi5jwIHNpRsB9bj
M84H5QzIxl/Ib5bZ751Fm1dcp9dXLO90av8RdwdzjqchBddaasfUyF/y+N7U
+nSKmD8dcc/+p+IMe2LMefeJdz/8Uff2R+2D7ovx7MBbcHe31r2T2r5jUscv
9qBfwtZgxYnEcxfsUwl9pge2gDHkRYW+UjIvqTr2iEFioRbxwDn71Ll/HZc6
VpgfVrJud4o+qPkJqWOzbd4487Fol3pjl37nY6mquR5l48ngnGOrQ73xB9we
XTD2vCe+L4YvxovOyfs8DUrG0r9qvFdyPso7D7qLbqu5J1gZNbpjzthyLvDw
08y9HbG3PXPP0D1n/yLvZu3VkF5eB92SGVc369mv8SrR71fdN0wRHSY6Mmfb
tWQvyXy8Yn2QNUHn+DTvfJhWcB9I/BPz9LU7cu4jP6SvFS2W3U+2iDqLL4ix
3WXXQXAWfDmQ2bYH6U2lw8nUMXwoesXD0dvCT9x3jViHB30aR17Sa9IbjBD9
X8k8+Gt1rF+TWcedUfugO6KX6hrzjOdFTae2t4qefFfZdfu5qN3gJzFwb8F4
gS5bxdMndb9KH0Zvj12oU/Tr9G7cU/ql7ino38ZHPJCjS6qOtz1l113yCT2I
KWKLOoX/Z0Sf/VjVZ4ef+wj9L/WLuxa9z8XcEertV3z6ft72rMg2i6vOL3R+
WOPvRAzMrDofZ1UdC6zFl/CCQ9SWUtwvuGccKDnGyRf6j6fi/vVIzfFNXQYn
9gZWbAjsOkYfHn7H/9QYYoG+ivsCdZUYW1N2z0mPCpZewDn8RQ+NH8npi1Ln
77hq8Jdt5/5ha3oY7l8PxFnpu8CfQWFbcpa8mR15OyNnDAJryH/80jfqyKTA
WzAD7CBXp4Y9sWs7TRzSGf5dM56Ba2DTrQ1sN/qUaTXHKDl4OnoJcBg6Jcb0
l7OL7jev0XNP6t4aDAaLwUB6YO4+w8nvmu/D1GUweVLgMHlDL47duQPQD9Cr
nIi7D77gfXDgOj4nbt6NutArcPJUYD0yiZP50ddNjFpG73AqagCxy12COwW9
6Etl997oOabqO86KsmMW/elfubNTH/9Q9hrWLiz5nXnuAgtj/lzEW8+IOfKi
d+rcoI4OiB6GPFqUuha+mBp/OBPfBXpED9ar7NoO9u4K33IW/Ivv8Ts694le
Dl3pzbg/05vhl+8WjFusp16+UvO3AHqeWdE70UMtCp3I67lVYwl4eCTuwsQN
dl2Quj/7p9b/SXPX1ryOc3E+YqBz5OP0wA3wg1pyImrNBzXnAD0k2NU77iO7
o2/F37Mi36nDRwJvj2auq3xnobZe6HHhB8/II3ASG6EPZ+YbDXfGYs2YOjd1
LehSZ32IVeZ2BPZOjrpD/aEfBQOxIXdw6k7zovuEntE/8L2Gbyb0q6PCzuy9
KHp9ev4ri/4mBCZzZ+bujN2oT9QpejTu+9iBfjgf307ASnK2UfjkljgTmH5F
0bj7vYJ7A/CBbxXjI6+xCf3r7sxxz30D/ICfe+v5GNH/q8u+Q/MtBYzCL/iH
HhTsubvg72bUjSZFf++ijvBdjW9A6E7vjf3wAfZvUfR9C1tRS5hDLjjPnYdv
HeQX8Yoe1J9W9f7mwN2GWAAb2mTOzT6Zfb07ejBigBjEpq2l58v6/19gf+b4
3Zk5Nrm3cn/lG8jm6BnIlb5RC0fpnKuLvjuDvQMDf7kD0jvfUHbvDeZyZ6T3
4A76Wtk9BDjEvnwvIne5J2FTzgSeU7/45rGl7NxBZ2oV3xu4g1C/uSOBY3yX
o/4R53+XzF+n7veIsRmRUydCFjK5079Qc0/MnZH72vl6UHA+ktcDonZ8O3V8
/LHk2MOPnesdz8cTxzL3ZPb6P/sNtYk=
            "]], Polygon3DBox[CompressedData["
1:eJwtl2eMVVUQx8++ffe9e+++9+yClWJCU0FYYWkuoqwgYIJGlGZhQRRUmg0r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            "]], Polygon3DBox[CompressedData["
1:eJwlkj8sQ2EUxa8+r32vfcoiDLRpDZqIRHSUsBADEjFISEUjYURiYCMkTEYT
gxAMJqlFGynSP5SSWISIQcSGDaFav5dvOOl3zj333Pt9r4GxqYFJh4j4gQ6W
nSJuhDDEC+7hVxUiF5yrqPeViQx5REyvyISLXxOuiaTdIgvwCPU03hT4pTaP
r5raHbyf2jC9BtoI3gZDpJlZx9QTzPgg3wc+y0Wy8G68IXpSaEW0c7Qc3nV2
8pAdYW7eElmBt1GfZUYleICfUp9DO4EnQcFUM7KcM7raM+pR/XaORf2Nvnc8
N+AHzy1zQ+wXwrOBtkfeE75HEOYOfrDGHaa5Sxd5o/i+QS/nGbQOfF/wFnwH
nGNgkIwMd3CCa2bkwSYz2pntQivBi+AMbZXsHXpr0V3Ua9DqyQuiJakFQBPa
EtoReDFUj90bh2+DBDxI/ziZW/BDS31f+zs/U4vB/9hLgztAJ/vtmurtffS0
6srvxbdoqeyC/W119S5RS+1/Cc/p6r+R561K5NSh65qaG2eHHrR9sl+Z28gd
/gEoC1T9
            "]], 
           Polygon3DBox[{{3591, 1883, 1884, 207, 1545, 3529}, {3514, 2554, 
            1781, 19, 1497, 3526}}]}],
         Lighting->{{"Ambient", 
            GrayLevel[0.8]}}]}, {}, {}}, {
       {GrayLevel[0], 
        Line3DBox[{570, 1, 2628, 16, 1481, 3532, 1482, 1483, 1484, 1485, 1486,
          2611, 1487, 1488, 1489, 1490, 2600, 1491, 1492, 1493, 1494, 1495, 
         2581, 1496, 3526, 1497, 1498, 1499, 3639, 2576, 1500, 1501, 1502, 
         1503, 1390, 859, 1587, 4, 1898, 314, 3, 1128, 312, 1039, 2, 2089, 
         570}], Line3DBox[CompressedData["
1:eJwl1Ftoz2Ecx/FHTpmcNqexOW9mRxcjMucQFkVyPivswoqEC0kph8iMYc7H
OZcLQlwoN0qupDkt25zNec5SXk8u3v/P+/l+n9/ze/o9z9Z9QfGkZQ1CCMl+
8puE0JhX+2mPJViKdPRPCOFxixDSeDK+NgrhkXEC76f3zTiTp+AX3yrz1XPl
euTgp3qK2mw+BxMxAX3w0Fr1+qP1u9rDmPisLJSDZWnzENbZYyE/zsv4TH6R
n+WrzCsyvsm38DW8kpfwTbyOl/E9vFxWxHXkZXnVu2vs4Ymslc/wHC+QZM5L
+Qqv8QYd1N7KOrzDe3zAQPWPsso6n+RnfEF9/F4Y0NK3i9+Kf8eP+K3QFJX2
0bRZCFMbhtDGOSQiCW3RDkM8O9Sz7XkHdEQyOmGYeq13duYpSEUXdMVwvW6y
O3qgJ3ohDUOtOUI/nfdGBvogM66pN1Ivi2cjB7nIwwr7LbHPcl5l363jmmrL
0RO94pnJGntqHL8hGqHauJscrN8v3im0xlikquXLtWiDceiitlAuwhT8dT+G
yKfWaSKv6d/y/vPykjwmT8qf7sQv572b1/DXfCO/y+/x1fw6v8E3e2apcQVf
yWfwEr6Yj+fTZYEcJ3PkFe++7d0PZIt4hvaUHfePRHP+GG/jfbEBefFvSf23
+lw+D5MxKc5RnxXP3lqj5Gh0xrR4b8y/o54Rv4d5HWVRvHvxXunZfmjlvsx3
DtvjeWAHSrETg5xfpud28TLsxh7sRZb6fWuX833YjwM4iEPI1j8sj+AojuE4
CqyZo3eCn0QFTuF0PFO9XL0z/CzO4TwuoBizG/7///IPPsCINg==
         "]], 
        Line3DBox[{1589, 6, 1454, 1406, 1261, 1345, 1371, 1370, 2592, 3539, 
         1356, 1357, 1323, 1347, 1346, 2587, 3536, 1410, 1411, 1396, 1398, 
         1291, 2597, 1348, 1416, 1417, 1415, 1422, 1292, 3642, 2601, 1360, 
         1361, 1306, 1319, 1263, 2580, 3530, 1289, 1392, 1262, 1407, 1264, 10,
          2318, 863, 9, 1902, 322, 1040, 8, 2493, 1134, 320, 1590, 7, 917, 
         1589}], Line3DBox[{1595, 12, 867, 2552, 1455, 1456, 1457, 1458, 2607,
          1459, 3542, 1460, 1461, 1462, 1463, 1464, 3537, 1465, 2593, 1466, 
         1467, 1468, 1469, 1470, 2609, 1471, 1472, 1473, 1474, 1475, 2610, 
         1476, 1477, 1478, 1479, 3527, 1270, 30, 2629, 15, 331, 1597, 14, 
         1136, 329, 1041, 1596, 13, 327, 1595}], 
        Line3DBox[{1278, 196, 2747, 211, 554, 1684, 212, 1180, 556, 1102, 213,
          558, 1685, 214, 2355, 908, 1528, 1300, 1393, 1313, 1337, 2618, 3550,
          1336, 1369, 1311, 1335, 1279, 3533, 1381, 2594, 1276, 1364, 1378, 
         1377, 1352, 2616, 1295, 1399, 1329, 1351, 2615, 1294, 1331, 1330, 
         1310, 3528, 1278}], 
        Line3DBox[{1288, 216, 2312, 856, 217, 2084, 561, 1107, 1686, 218, 
         1184, 563, 1687, 219, 979, 1688, 220, 1584, 1408, 1343, 1344, 1383, 
         1382, 2595, 3540, 1283, 1367, 1340, 1355, 1282, 2591, 3538, 1413, 
         1414, 1397, 1402, 1401, 1281, 2598, 1403, 1404, 1400, 1419, 1418, 
         3641, 2599, 1280, 1366, 1298, 1339, 1338, 2586, 3534, 1314, 1388, 
         1387, 1301, 1288}], 
        Line3DBox[{858, 222, 2086, 566, 223, 2522, 1185, 568, 1113, 224, 2088,
          569, 225, 2760, 210, 1530, 3535, 1531, 1532, 1533, 1534, 1535, 2619,
          1536, 1537, 1538, 1539, 2620, 1540, 1541, 1542, 1543, 2584, 1544, 
         3529, 1545, 1546, 1547, 3525, 1548, 2622, 1549, 1550, 1551, 1389, 
         2314, 858}]}, 
       {GrayLevel[0.2], Line3DBox[{3545, 2630}], Line3DBox[CompressedData["
1:eJwNzb0uA2AUxvFjEf1g95XUJaB6CYrRZG2rVFoaot2JCFKXIAY3wOACKk18
RiIs6GBwAUxCDP0N/5xz/s+T950o1hc3+iJiCflkRCEVUUpHDA9GlBMRk/YT
e5HfNw+wMxRxaJa4X/mAuYyz/og5b3zJZnVWuBv5La7xjCc+wa/hVXeKy3Bt
VLiy+42fNjv+r3J/9hFvjuJDL+s+tV+iJr8wz7Ery2FVnuTX8clXuXlvptx1
PLrvdR5whxd86+X5Lfm77gzXwhW3yVXsYzrjyNmz/A+2ZUdcC8douPf4f520
vYmu9xbQA5KWMe0=
         "]], Line3DBox[CompressedData["
1:eJwVzztOQlEYReGfygiCL1RaxiOiovhojWI0CiQWPkg0gLlXRBmCE8AJUDMA
5mJnbPwodvZeKznn5JTPWrVmJiKqUslGPOQizpciHvW0EFGWbf4Jp/mIjv7l
xvYOn8cXUpAbvsotLkRc4mXZxbf8in0tq5K4f49P+GfcwC/6U+/zKd/Ff7in
x7jG9+0v777qCXfArdlNWZ83d8gV7bZsyIyrcz/O9e07bnP+F3cf8W/cAF/h
dz3Sx/yAH+Khcx/6W5/wLX4L30tJTrl/ZJ0mCg==
         "]], Line3DBox[CompressedData["
1:eJwVzssrRHEYxvHHSq47C3fzD1lYYlzGoIZc9pTNMCXnzCiikKzxxyj+EZeF
Uj5n8fS83+95z9uv1thf2OtLMi/bg0ltKLmQOTkcTba415HkAZf6vmp+k+8N
J3d4Vz/1J03uwzzLves3ez/+2eC/dR13fJuRBneAp81nMiXrXGsgOTU/2m9X
u3qNL+ze4j93b6o34lW+i6/xjr7S5/wK38GT+ETGvK3OTZiPpW3ny91l7rNq
fMSPyxL3wv1yPVyYu3qRf+ZKd0vc0oW+lH8oKSwL
         "]], Line3DBox[CompressedData["
1:eJwNzDtOQlEUheFtZRQ1cQTKG1816DAYgBgqH3CvIk7CWKigJFpAYu0EjLOw
UEqchA8o+Io/66x/77OzzbSeLEREHVfLEZVMxBBldNYiutzuasQeDlYidmR3
KeKSf9QHSPFmdx0d/ksf4xMf3MyfC34qj/Rnt0s45/65BvekF5Fy7/oWv419
NyqyjMTszqzoXULNrCDz+Obb5n3uAQleFyNaXMHdAW7s/Nk94/J6H9fcL3fK
/chDvcfncMJluQmXk1U3N+UGjs1u+XuuhzZG/rxgDhkWKwU=
         "]], Line3DBox[CompressedData["
1:eJwVzU1KQnEUhvETpANTJ0XQsKkjaw1lmmngElxADYOIJtLcNQiJpESWQepS
og+z0jZR/e7g4bzvc/7n3u3maeNkJSJqOMtEdNYiStmIu3zEi36r/+rFXMSf
eYAu9vRX+6H9Ncrc0M0bd46cXMa7fIGKPDMvsSkfouLmQx+5z+vVxHN97Pv+
NB3RNlexgxSqdvfezd09uuvhiHvgPrkWbhKnf8lX2JJr+Jaf7NbleuLcLbgx
V9CfsesfadTtBijJS28m3mzYHyfwP9yU+wcSyiyP
         "]], Line3DBox[CompressedData["
1:eJwVzb1KgnEYhvHHGsqPLILA1TmyA8hKy7YmzyC1xnSSIsKKyFw7A0GyLCtw
aOhMWiU8jX4OF/f/ue775c3XmtXzREQco5eKGKcjjjIR7/IpG/HILa9EJFHh
l+Qnv4mu7s3ukP9wr+OB++bOvHO4d6/JUxzYveruuFV3A2VuyN1yW+4ptv2j
xI/me9zoZvzQ+wX7KNi0kxEd3cT3Le7HZgPXXF3+2Vx5P+v39GMug0suLWvY
5Qf6C27B/pdblEU+IWP+H12KP8EO37f/wj/HJiTL
         "]], Line3DBox[CompressedData["
1:eJwNzDlOQgEUheFLY8Fj0MrEobC3E3dBAe+BC3ABELfhGEJ0GyYGqQATNEQl
7kBbTcQBhwXwFX/OcIet/XbaykVEFYf5iMskYoTXYkS3FDHk83yCWiGiQHv6
d7s3ZldI9de6ma7Or/M1fMhH2ODrGNv9lI+xKqe4033Jt/Rc3vG/gsyfIn3D
s75DSyijYbZLx0sRE3d9HOiG9r79OkHGz+kpNvkG7u39yGdYk5t41P3KD3Rb
fsGy303/Vuif2dTsQj+ge/p/3RO/AIhnLkg=
         "]], Line3DBox[CompressedData["
1:eJwNzUkuA3AUx/FnY2G6gyX2VTNXIFG2PUAlWiuXMHShtWo5B7oQkTSlQdMY
I6mkFzCUUp/FN7/hvff/j6Y3ljN9EbGCnYGIscGIa7SHI7IjEVd8kj+jJZpA
Xj9J67qDoYgK3aQn+ndv3Mjb5r9Y1d2bfeh38adL6W7tfMp7yMnj8h2+5Kz9
U92M3XNdmU5hGi19QzfPX9AjOos5vJml3BbRNMvRy37/8xN4QMFOxx/76LlZ
kx/133IeIa/jWfcjP9GivGS3yh/TBSziRT40K/inxm/RrptX/h+1TDmA
         "]], Line3DBox[CompressedData["
1:eJwVzk1KwlEUhvHzNwj6HLSD5mWuoQaNImgUOWsBNkqLGgstQBOyGrUF92EE
IjYIJSM/SqLQSdbPwcN73udezr3rxycHuSQi9lBajNhYiujgfSXidDWibX7E
rt7DNXe4HHGDVz4v+3yV7+qX5sR8hGdnv3a25JO+6fwNU66MPJeevYU//cy9
4kJEQ3+wZxs76LrX55pY0weozN5wv4oP/lwO+Tv+U7/St+QI9Xn/tj/lLIsv
LlDhCnrG/IME37jnXuS+fSmZtavG3cqxfiHn5AT/BMwz6Q==
         "]], Line3DBox[CompressedData["
1:eJwVzcsuA2AQhuGpSiotNq5AgmWT1vm06sapDbVh6wJqiXIjSlW75yo04QIs
nRILERaNRFIh8XTx5pt55/9nRvf2y5VEROzgNB2Ry0S8Io/b4YgxrA1FrKLL
rcgf+cavqzdwNRjxyx3IP3ljdqGu2XeonuQe9FPyUZ7xT/LIbLq3CzM456vc
rPodc6hzde5DvevPp7zTj6PkdhEJfkT2yS8+17vvX1JfRT/aXEM2+Hk7OljA
Pf/MX/IvspCyg19Ekzs2X1J/YxnX3my5leWbSOk39QOyLLcxwbeQ5k6QQcuu
f/+sMWE=
         "]], Line3DBox[CompressedData["
1:eJwVzksug2EYhuFXKCktAy0S0sYK7MBZk85E0DpVYsJIN+CwFaJahybohBV0
CV2Aw4AVSJrgMrjzvM/9ff/7/dMH1bXjnogo42owYnYooos5PKQinocjNtMR
G0jp6zItP/mSuYxHfQSnOORzuDDX7Ov9n/Fj3zxe+Wv+TRYHIn65BdS5E/cW
zeFsSTa4b67ujVGuITOyJbfx4mxHbiHLZ+SY7CQjbnw7bj7DBNruXspbftnu
hPmI68O7+Y7/kAm9g37zinv3/Kr/TOoF/UnueWfGnRom9V19SlbkPr74lp7D
OfJo2vMHf18stA==
         "]], Line3DBox[{3551, 2745}], Line3DBox[{3544, 3511}], 
        Line3DBox[{3548, 3512}], 
        Line3DBox[{3531, 2903, 3649, 3281, 3280, 3267, 2768, 3268, 3788, 2902,
          2821, 3279, 2767, 3643}], 
        Line3DBox[{3541, 3841, 3519, 2822, 2909, 3712, 2775, 3282, 2823, 2910,
          3789, 839, 3270, 873, 3652, 2911, 2776, 3518, 3543}], 
        Line3DBox[{3546, 3510, 3567, 3650, 2907, 837, 3269, 870, 3651, 2908, 
         2773, 3119, 3754, 730, 3169, 2774, 3517, 3836, 3644}], 
        Line3DBox[{3547, 3835, 2899, 3266, 2763, 3265, 3278, 3792, 3624, 2900,
          2764, 3115, 3520, 3838, 3645}], 
        Line3DBox[{3549, 2735, 3590, 3747, 3088, 3303, 3302, 2736, 3304, 3305,
          3799, 3089, 2888, 2737, 1878, 3090, 2889, 2738, 3840, 3554}], 
        Line3DBox[{3552, 2742, 2891, 3098, 3800, 3309, 3308, 2741, 3306, 3307,
          3690, 3097, 2890, 2740, 3236, 2236, 3201, 3108, 2739, 3837, 3647}], 
        Line3DBox[{3553, 3110, 3801, 3315, 3314, 2756, 3313, 2358, 3109, 2895,
          2755, 3521, 3839, 3648}], 
        Line3DBox[{3640, 3750, 3105, 3311, 3310, 2750, 3312, 3751, 3625, 3106,
          2893, 2751, 3516, 3646}]}, 
       {GrayLevel[0.2], Line3DBox[CompressedData["
1:eJwVzrFKQnEYhvGvAi20wKACFzWXTlBBOefgZLQUitBS6GyN4t7Y0AW0ew9e
RYF6biEIcmnQrd8ZXp73e77z/zi1/sv980ZE3EojF/ErP9sRS9zdifjcixjm
I0r6ilvarbHF73Mju0PcxD+7L35LP+JesSBDbm1X1Mv8Ox5k7+RD3uwrWJUH
twfmKbZxgHN+IXfmFE8kkZ75G6+yt+7OzA19JXXzNY65Y72p5/xDorezG3iD
p1jizzH1bYc707t4gWW7SXZXf+Qu8Qnz+A/gcCH5
         "]], Line3DBox[CompressedData["
1:eJwNzjFLQnEYhfFXwmsttjTcoaWIlhxaKmjMKTCCgmgpwpCiodra2trcnPwY
trQ5NYkaDYGfQSrSECMr+g0P5z3n4f65C+WrvctMRJRQTyL6WJuJOM1FrMua
nsgspnBov8hHrLqrXEYG/qYjdrhzbkW/43pYcr/Ytrhl963tGRv6jaxzLVnQ
r+W+/ijPUHI35T1XcR+7H7Con+gH7gbmvZvajmy7+q9/+cE3nmx5btv+pXf1
sRwha099W+Q+9Q43lB+Y2Oa4Tfmut7k3+YqBbZb7B8PcKlE=
         "]], 
        Line3DBox[{2577, 3649, 2320, 1905, 1788, 2289, 1789, 3652, 2325, 1917,
          1798, 2294, 1799, 3655, 2329, 1930, 3715, 1807, 2299, 1808, 2486, 
         2331, 3794, 1817, 2333, 1818, 2487, 2334, 3795, 1827, 1828, 1631, 
         3686, 1992, 1993, 3661, 1640, 2014, 2015, 3668, 2016, 1837, 1838, 
         3672, 2031, 1848, 1849, 3675, 2047, 2343, 1859, 2341, 1860, 2058, 
         2348, 3798, 1870, 2303, 1871, 2070, 2353, 3800, 1881, 2308, 1882, 
         2078, 2359, 3801, 2596}], 
        Line3DBox[{2578, 1931, 2374, 3716, 2502, 2373, 1932, 1809, 3695, 1943,
          2377, 2506, 2376, 1944, 1819, 3697, 1957, 2380, 2508, 2379, 1958, 
         1829, 3698, 1976, 2386, 2512, 2385, 2126, 1977, 3730, 1998, 1978, 
         3663, 2130, 1999, 2019, 3734, 2000, 2135, 2254, 2444, 2255, 2034, 
         2222, 3739, 2221, 2183, 2262, 2448, 2263, 2142, 2227, 3766, 2226, 
         2185, 2268, 2455, 2269, 3746, 2148, 2231, 2230, 2187, 2272, 2465, 
         3818, 2273, 2154, 2234, 2590}], 
        Line3DBox[{2579, 2149, 2271, 3767, 2456, 2270, 1663, 1746, 2143, 3784,
          2265, 2449, 2264, 1656, 1739, 3701, 2036, 2257, 2445, 2256, 1649, 
         1733, 3699, 2020, 2249, 2441, 2248, 1641, 1727, 3731, 2001, 1980, 
         1632, 3760, 1720, 1979, 1960, 3681, 1623, 1714, 2509, 2381, 1959, 
         2218, 3728, 2217, 1616, 1708, 2540, 2411, 2113, 2213, 3756, 2212, 
         1610, 1703, 2535, 2407, 2107, 3779, 2208, 2207, 1604, 1698, 2531, 
         2405, 2101, 2203, 2588}], 
        Line3DBox[{2582, 2106, 3831, 2533, 2534, 2532, 2501, 1942, 3721, 2112,
          2538, 2539, 2537, 2505, 1956, 3727, 2118, 2419, 2541, 2418, 2119, 
         2420, 2421, 1973, 2384, 2511, 2383, 2125, 3759, 2389, 2390, 1995, 
         2388, 2387, 3803, 2426, 2394, 2395, 2017, 2393, 2392, 3805, 2134, 
         2252, 2443, 2253, 2032, 2435, 3738, 2434, 2138, 2260, 2447, 2261, 
         2048, 3743, 2035, 2451, 2452, 2454, 2453, 3745, 2147, 2059, 2461, 
         2462, 2464, 2463, 3748, 2153, 2589}], 
        Line3DBox[{2583, 2150, 3817, 1072, 1664, 1747, 2144, 3816, 1060, 1657,
          1740, 3735, 2139, 804, 1650, 1029, 3732, 2021, 794, 1642, 3764, 964,
          1173, 784, 1042, 3396, 783, 954, 953, 3802, 1624, 943, 1961, 1003, 
         3809, 1617, 935, 1945, 3834, 1239, 1257, 1155, 1933, 3833, 1237, 
         1255, 1148, 3713, 1921, 2612}], 
        Line3DBox[{2585, 3750, 2073, 2565, 1875, 2559, 1874, 3747, 2064, 2194,
          1864, 2063, 1863, 3744, 2053, 2193, 1853, 2052, 3704, 1852, 2337, 
         2489, 3674, 1842, 2039, 1841, 2335, 2488, 3670, 1831, 2023, 1830, 
         1644, 3664, 2003, 2132, 2002, 1634, 3656, 1964, 1963, 3757, 2120, 
         1822, 1821, 3722, 1946, 1812, 1811, 3717, 1934, 1802, 1801, 1922, 
         3654, 1793, 1792, 1909, 3650, 1783, 1782, 1899, 3835, 2614}], 
        Line3DBox[{2602, 1593, 1786, 2323, 1697, 3712, 1602, 1796, 3691, 1702,
          1608, 1805, 3694, 1707, 1614, 1815, 3696, 1712, 1621, 3679, 1825, 
         1718, 1629, 3684, 1969, 1725, 3763, 1638, 1991, 1731, 3773, 1647, 
         2223, 2028, 2030, 1737, 1654, 2225, 2045, 2046, 3742, 1744, 1661, 
         2229, 2056, 3781, 2057, 1751, 1668, 2233, 2068, 3782, 2069, 1758, 
         1675, 2236, 2076, 2077, 1764, 1682, 3839, 2627}], 
        Line3DBox[CompressedData["
1:eJwV0L9KgmEYhvGnxUqic2jvAJqiFoeIBh0cmoowl3RpExoi+uMg5GhRDS4S
2NIgNIWVVCBktFhDQ2Q4dABN/Rwu7ue5r/f9Xvhm1ovpwlhEpDGbjDhPRCxg
fzxibiIiNxnxOR1R16VQ1V/a57k894OGfhlnXIW7kEv6ZzT1GRTMx1xRXvEr
sotrbhVt3xvwB7o7c9uZe/liv+E38GA/tHdkn8+ae/hw75bfwhNXHr0th87s
mL/4DreNnr6ie5V//J75m+9yJfT1Vd27fNSvyTf9Lmr6U7T0J3KT+x29zx1h
yv9bxD9xmjcK
         "]], 
        Line3DBox[{2605, 3836, 2573, 2369, 1925, 2103, 2500, 2499, 2372, 1937,
          3719, 2109, 2504, 2503, 2375, 1949, 3725, 2115, 1951, 2116, 2412, 
         3810, 2413, 1966, 1953, 2122, 2422, 2423, 1984, 1968, 3659, 2128, 
         1988, 2008, 2428, 3733, 2427, 2133, 2011, 2182, 2432, 3775, 2431, 
         2136, 2027, 2184, 2438, 2437, 2140, 2043, 3741, 2186, 2044, 2457, 
         2543, 3832, 2544, 2188, 2067, 2467, 2575, 3840, 2624}], 
        Line3DBox[{2606, 3838, 2563, 1910, 2096, 2201, 3754, 2200, 2169, 1923,
          2102, 3777, 2205, 2204, 2171, 1935, 3718, 2108, 2210, 2209, 2174, 
         1947, 3723, 2114, 2215, 2214, 2177, 1965, 2121, 2220, 2219, 2180, 
         3771, 1982, 1983, 3658, 2127, 1985, 1986, 3666, 2009, 1834, 3700, 
         1835, 2025, 1845, 3702, 1846, 2041, 1856, 3706, 1857, 2055, 1867, 
         3708, 1868, 2066, 1878, 2306, 1879, 2560, 2623}], 
        Line3DBox[{2608, 2564, 1928, 2105, 3778, 1929, 2206, 2173, 1940, 3720,
          2111, 1941, 2211, 2176, 1954, 2117, 1955, 2216, 2179, 3770, 1971, 
         2123, 1972, 2124, 3758, 1974, 1994, 1975, 3662, 2129, 1996, 1997, 
         3669, 2018, 1839, 1840, 3673, 2033, 1850, 3703, 1851, 2049, 1861, 
         3707, 1862, 2060, 1872, 1873, 2558, 2621}], 
        Line3DBox[{2613, 1599, 1791, 1699, 1605, 1800, 3692, 1704, 1611, 3676,
          1810, 1709, 1618, 3678, 1820, 1715, 1625, 3682, 1962, 1721, 3761, 
         1633, 1981, 2131, 1728, 3765, 1643, 2004, 2022, 1734, 3774, 1651, 
         2224, 2037, 2038, 3740, 1741, 1658, 2228, 2050, 3780, 2051, 1748, 
         1665, 2232, 3687, 2061, 2062, 1755, 1672, 2617}], 
        Line3DBox[{2626, 3837, 2574, 1674, 1757, 2152, 2518, 2517, 1667, 1750,
          2146, 3827, 2516, 2515, 1660, 1743, 3736, 2141, 2029, 1653, 1736, 
         3813, 2433, 2137, 2013, 1646, 1730, 2429, 2012, 1990, 1637, 3762, 
         1724, 1989, 2425, 2424, 3811, 1628, 1717, 2181, 2417, 3772, 2416, 
         1620, 1711, 2178, 2410, 2409, 1613, 1706, 2175, 3769, 1939, 1607, 
         1701, 2551, 3714, 2172, 1927, 1601, 1696, 3841, 2603}]}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzsvWdYVcnSNqxizjnnjIhZzJQBc8AcUDCiYgAVc44oioo5oGIOiIqYQJSS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      "]], {}}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[0.5], 
       Line3DBox[CompressedData["
1:eJw12nk01N//B3BCyRZSaSGpEC2KCuGpqLSJUCofpcVSypItUiIqIUkIlRaK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        "]]},
      Annotation[#, "Charting`Private`Tag$10972#1"]& ]}, {}}, 
   {RGBColor[0, 0, 1], PointSize[Medium], 
    Point3DBox[{{0.546, 0.7096, -0.0039}, {1.283, 0.913, 1.834}}]}},
  Axes->True,
  AxesLabel->{
    FormBox[
     TagBox[
      StyleBox[
       TagBox["x", HoldForm], 12, StripOnInput -> False], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox[
      StyleBox[
       TagBox["y", HoldForm], 12, StripOnInput -> False], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox[
      StyleBox[
      "\"\\!\\(\\*FormBox[TagBox[RowBox[{\\\"u\\\", \\\"(\\\", \
RowBox[{\\\"x\\\", \\\",\\\", \\\"y\\\"}], \\\")\\\"}], HoldForm], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
     TraditionalForm]},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 1},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->250,
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1.9999997142857142`, 
   1.9999997142857142`}, {-1.9999997142857142`, 1.9999997142857142`}, {-4., 
   4.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], Automatic},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-3.0233319718153497`, -0.7016099825685572, 1.3480382860138642`},
  
  ViewVertical->{0.3880692322231919, 0.09005734394824723, 
   0.9172196824113018}]], "SolvedExampleOutput",
 CellID->415712415,ExpressionUUID->"e2a207f5-37c5-4d80-a650-6ad7ed0153c4"]
}, {2}]],

Cell[TextData[{
 "The maximum and minimum of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e18ddc0a-d5e5-454c-b665-28a2e2260823"],
 " in the region bounded by the red curve occur on the boundary, marked with \
blue dots in the plot."
}], "SolvedExampleNote",
 CellID->35111040,ExpressionUUID->"0a7db16a-0918-4e40-8672-4e0a4b2f64a9"],

Cell["", "SolvedExampleEndCap",
 CellID->122770069,ExpressionUUID->"423be015-1cce-4f7b-b254-7be858b52384"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->539734450,ExpressionUUID->"f65ec256-52a8-42a9-93ae-e684522c8a0b"],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Omega]", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     SuperscriptBox["x", "4"], "+", 
     SuperscriptBox["y", "4"], "+", 
     SuperscriptBox["x", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"bc785ff6-9bac-4f94-a0f7-4a4053a38bc0"],
 " does not satisfy the minimum value principle."
}], "SolvedExampleNote",
 CellID->279692996,ExpressionUUID->"cd04d34f-74e2-4eed-86d1-7b45579d6984"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"y", "^", "4"}], "+", 
        RowBox[{"x", "^", "2"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"x", ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"y", ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"ToString", "[", 
             RowBox[{
              RowBox[{"\[Omega]", "[", 
               RowBox[{"x", ",", "y"}], "]"}], ",", "TraditionalForm"}], 
             "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"Opacity", "[", "0.8", "]"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Blue", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], "/", "2"}], ",", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], "/", "2"}], ",", 
         RowBox[{
          FractionBox["1", "64"], " ", 
          RowBox[{"(", 
           RowBox[{"11", "+", 
            RowBox[{"8", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"2", " ", "t"}], "]"}]}], "+", 
            RowBox[{"Cos", "[", 
             RowBox[{"4", " ", "t"}], "]"}]}], ")"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}], ",", 
   RowBox[{"ImageSize", "->", "250"}]}], "]"}]], "SolvedExampleInput",
 CellID->465663639,ExpressionUUID->"ca7e54db-e375-4fd8-bbcb-c19692a99e52"],

Cell[BoxData[
 Graphics3DBox[{{GraphicsComplex3DBox[CompressedData["
1:eJx1XXmcz1X3l6xZnigle5YWRYhCOFr0EEK0SrIUytIoxChFm4oyUmPNWjTW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     "], {{
       {RGBColor[0.880722, 0.611041, 0.142051], Opacity[0.8], EdgeForm[None], 
        Specularity[
         GrayLevel[1], 3], 
        StyleBox[GraphicsGroup3DBox[
          TagBox[{Polygon3DBox[CompressedData["
1:eJxFmgkUFtMbxr+ZuXOTohBaRaEIiZKylaVNRKSyJCLiTyH7FtnbrEUpoV1o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             "]], Polygon3DBox[CompressedData["
1:eJwtmwf8V9Mbx++95577S2VVtkpR9l7JSNPKHiGKiiiyCsmKSBTSQBkREdmb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             "]], Polygon3DBox[CompressedData["
1:eJwl13n8TXUex/Hr/u69ZKvIvoVKRtNiSVEp06amFMVMm8qS3VTWGRTJUkIJ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             "]], 
            Polygon3DBox[{{1276, 712, 888, 1584, 1137, 1138}, {1542, 721, 556,
              555, 895, 1375}, {1360, 873, 510, 511, 874, 1361}, {1131, 1130, 
             1577, 879, 880, 1578}, {1545, 733, 571, 570, 905, 1380}}]},
           Annotation[#, "Charting`Private`Tag$10762#1"]& ]],
         Lighting->{{"Ambient", 
            RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
           "Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{0, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 2, 2}]}, {"Directional", 
            RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
            ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
       {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0rtPk1EYx/FTFWhLRWYHDIvGAf8CmIyTDIQ4CPUeGeoAOigFUReCTMQF
xAE2vIDi0nqBEGOqYSKm9uoNNY78E3xOHH79fp/nPU/f95z37b42NjiaCCE8
kXckesHPP8wcCqETj+IxzOmf5Kf4m5YQbqn7+Bm9fjyHWbyOI3KDT+EEzuAs
PsLH2DA/b/4p3+XLvBj/1/VP8Xn0BvQ2pBL7+FxuHwihqr6DNRzHOuaxgUnz
L6xr8hRf5d94mq/xCeu+q1/ySf6Dv+J3+U++zqf4L34Pd/E+/sYH+AcrB0M4
b92m/FW/xddSdo+v6hKW8JlegRf4UtwrX+GLuIBz+BCnMY+T8awkx6/iMA7i
2bhf86d5Ly86m5vqHn5CrwuP6+3he/0jcQ1eiWcnHeoyHsYvmMEdbMemvVzm
6fhO+CWe4nV+kSd5jV/g29KmzuJnaeXDWBK3Dx/R44QPaCRsoSMLVcVQ4v/3
tQ/i01Hr
         "]]}, 
       {GrayLevel[0.2], 
        Line3DBox[{1036, 1313, 640, 1035, 1603, 1234, 1037, 1604, 1235, 1038, 
         1605, 1236, 1039, 1566, 1606, 1237, 1040, 1567, 1607, 1238, 1041, 
         801, 1511, 1736, 1042, 1314, 1608, 1239, 1043, 1315, 1609, 1240, 
         1044, 1316, 1610, 1241, 1045, 1611, 1242, 1046, 1612, 1243, 1047, 
         1613, 1244, 1048, 1737, 1317, 1245, 1318}], 
        Line3DBox[{1050, 1512, 1673, 1049, 652, 1051, 1614, 1246, 1052, 1568, 
         1615, 1441, 1247, 1053, 1570, 1616, 1442, 1248, 1054, 1739, 1320, 
         1443, 1249, 1055, 1742, 1322, 1444, 1513, 1741, 1056, 1324, 1445, 
         1514, 1745, 1057, 1326, 1446, 1790, 1250, 1058, 1328, 1447, 1791, 
         1251, 1059, 1571, 1617, 1448, 1252, 1060, 1618, 1253, 1061, 1619, 
         1254, 1062, 1620, 1255, 1063}], 
        Line3DBox[{1065, 1330, 1515, 1748, 1064, 1516, 1674, 1066, 663, 1067, 
         1569, 1621, 1256, 1068, 1738, 1319, 1449, 1257, 1069, 1740, 1321, 
         1451, 1258, 1070, 1744, 1323, 1453, 1517, 1743, 1071, 1325, 1455, 
         1518, 1746, 1072, 1327, 1457, 1519, 1747, 1073, 1329, 1459, 667, 
         1074, 1572, 1622, 1259, 1075, 1623, 1260, 1076, 1624, 1261, 1077, 
         1754, 1343, 1262, 1461}], 
        Line3DBox[{1091, 1355, 1354, 1760, 1090, 1264, 1626, 1089, 1263, 1625,
          1088, 678, 1087, 1753, 1342, 1460, 1341, 1086, 1759, 1340, 1458, 
         1339, 1085, 1758, 1338, 1456, 1337, 1084, 1751, 1336, 1454, 1335, 
         1752, 1083, 1334, 1452, 1333, 1750, 1082, 1332, 1450, 1331, 1749, 
         1081, 673, 1080, 1676, 1521, 1079, 1675, 1520, 1078, 1755, 1345, 
         1344, 1462}], 
        Line3DBox[{1093, 1522, 1677, 1092, 1523, 1678, 1094, 1524, 1679, 1095,
          1525, 1680, 1096, 862, 1356, 1097, 1756, 1346, 1463, 1347, 1098, 
         1757, 1348, 1464, 1349, 1761, 1099, 1350, 1465, 1351, 1762, 1100, 
         1352, 1466, 1353, 1792, 1101, 1357, 1681, 1573, 1102, 1526, 1682, 
         1103, 1527, 1683, 1104, 1627, 1265, 1105, 1628, 1266, 1106}], 
        Line3DBox[{1108, 1528, 1684, 1107, 1529, 1685, 1109, 1530, 1686, 1110,
          1531, 1687, 1111, 1574, 1688, 1358, 1112, 871, 1359, 1113, 1763, 
         1360, 1361, 1793, 1114, 1362, 1363, 1794, 1115, 1364, 1689, 1575, 
         1116, 1365, 1690, 1576, 1117, 1532, 1691, 1118, 1533, 1692, 1119, 
         703, 1120, 1629, 1267, 1121}], 
        Line3DBox[{1125, 1630, 1268, 1123, 1631, 1269, 1127, 1632, 1270, 1129,
          1633, 1271, 1131, 1578, 1634, 1272, 1467, 1580, 1635, 1273, 1468, 
         1581, 1636, 709, 1469, 1370, 1637, 1274, 1470, 1372, 1638, 1275, 
         1471, 1374, 1639, 1276, 1138, 1640, 1277, 1140, 1641, 1278, 1142, 
         1642, 1279, 1144, 1644, 1281, 1146}], 
        Line3DBox[{1145, 1280, 1643, 1143, 1704, 1540, 1141, 1703, 1539, 1139,
          1702, 1538, 1137, 1584, 1701, 1373, 1136, 1583, 1700, 1371, 1135, 
         1582, 1699, 1369, 1134, 1795, 1368, 883, 1133, 1367, 1698, 1579, 
         1132, 1366, 1697, 1577, 1130, 1696, 1537, 1128, 1695, 1536, 1126, 
         1694, 1535, 1122, 1693, 1534, 1124}], 
        Line3DBox[{1148, 1541, 1705, 1147, 1645, 1282, 1149, 1646, 1283, 1150,
          1647, 1284, 1151, 1585, 1648, 1285, 1472, 1586, 1649, 1286, 1473, 
         1796, 1375, 1542, 1764, 1474, 1376, 722, 1475, 1377, 1650, 1287, 
         1476, 1378, 1651, 1288, 1152, 1652, 1289, 1153, 1653, 1290, 1154, 
         1654, 1291, 1155, 1655, 1292, 1156}], 
        Line3DBox[{1158, 1543, 1706, 1157, 1544, 1707, 1159, 1656, 1293, 1160,
          1657, 1294, 1161, 1587, 1658, 1295, 1477, 1797, 1379, 1296, 1478, 
         1798, 1380, 1545, 1765, 1479, 1381, 1546, 1766, 1480, 1382, 735, 
         1481, 1383, 1659, 1297, 1162, 1660, 1298, 1163, 1661, 1299, 1164, 
         1662, 1300, 1165, 1663, 1301, 1166}], 
        Line3DBox[{1168, 1547, 1708, 1167, 1548, 1709, 1169, 743, 1170, 1664, 
         1302, 1171, 1767, 1384, 1303, 1482, 1799, 1385, 1484, 1304, 1483, 
         1800, 1386, 1487, 1549, 1768, 1486, 1389, 1490, 1550, 1770, 1489, 
         1392, 1493, 1551, 1773, 1492, 1395, 748, 1172, 1665, 1305, 1173, 
         1666, 1306, 1174, 1667, 1307, 1175, 1668, 1308, 1176}], 
        Line3DBox[{1190, 1415, 1414, 1783, 1189, 1310, 1670, 1188, 1309, 1669,
          1187, 761, 1186, 1781, 1410, 1409, 1185, 1801, 1397, 1494, 1396, 
         1184, 1779, 1394, 1491, 1393, 1183, 1771, 1391, 1488, 1390, 1772, 
         1182, 1388, 1485, 1387, 1769, 1181, 1401, 1400, 1775, 1180, 756, 
         1179, 1711, 1553, 1178, 1710, 1552, 1177, 1774, 1399, 1398, 1495}], 
        Line3DBox[{1204, 1431, 1430, 1788, 1203, 1311, 1671, 1202, 771, 1201, 
         1428, 1716, 1594, 1200, 1588, 1715, 1501, 1413, 1199, 1782, 1412, 
         1500, 1411, 1198, 1780, 1408, 1499, 1407, 1197, 1777, 1406, 1498, 
         1405, 1778, 1196, 1404, 1497, 1403, 1776, 1195, 1402, 1496, 930, 
         1194, 1418, 1714, 1589, 1193, 1713, 1555, 1192, 1712, 1554, 1191, 
         1784, 1417, 1416, 1502}], 
        Line3DBox[{1206, 1556, 1717, 1205, 1557, 1718, 1207, 1558, 1719, 1208,
          1590, 1802, 1503, 1419, 1209, 1591, 1803, 1504, 1420, 1210, 952, 
         1505, 1421, 1211, 1786, 1422, 1506, 1423, 1785, 1212, 1424, 1507, 
         1425, 1787, 1213, 1426, 1508, 1720, 1592, 1214, 1427, 1509, 1721, 
         1593, 1215, 1595, 1804, 1510, 1429, 1216, 1559, 1722, 1217, 781, 
         1218, 1672, 1312, 1219}], 
        Line3DBox[{1233, 1440, 977, 1232, 1735, 1565, 1231, 1734, 1564, 1230, 
         1733, 1563, 1229, 1602, 1732, 1439, 1228, 1601, 1731, 1438, 1227, 
         1600, 1730, 1437, 1226, 1789, 1436, 1729, 1599, 1225, 1435, 1728, 
         1598, 1224, 1434, 1727, 1597, 1223, 1726, 1562, 1222, 1725, 1561, 
         1221, 1724, 1560, 1220, 1596, 1723, 1432, 1433}]}, 
       {GrayLevel[0.2], 
        Line3DBox[{445, 641, 1603, 446, 652, 470, 1674, 662, 480, 1675, 671, 
         492, 1678, 682, 505, 1685, 694, 520, 1694, 706, 1631, 535, 718, 1645,
          550, 1707, 730, 565, 1709, 742, 580, 1710, 754, 593, 1712, 765, 605,
          1718, 774, 615, 1724, 784, 630}], 
        Line3DBox[{447, 642, 1604, 448, 653, 1614, 471, 663, 481, 1676, 672, 
         493, 1679, 683, 506, 1686, 695, 521, 1695, 707, 1632, 536, 719, 1646,
          551, 731, 1656, 566, 743, 581, 1711, 755, 594, 1713, 766, 606, 1719,
          775, 616, 1725, 785, 631}], 
        Line3DBox[{449, 643, 1605, 450, 807, 808, 1615, 985, 809, 810, 1621, 
         482, 673, 494, 1680, 684, 507, 1687, 696, 522, 1696, 708, 1633, 537, 
         720, 1647, 552, 732, 1657, 567, 744, 1664, 582, 756, 595, 1714, 946, 
         947, 1027, 1802, 948, 949, 617, 1726, 786, 632}], 
        Line3DBox[{451, 795, 796, 1606, 452, 811, 812, 1616, 986, 813, 1738, 
         814, 990, 836, 1749, 837, 495, 862, 863, 508, 1688, 869, 870, 523, 
         1697, 879, 880, 1634, 538, 889, 890, 1648, 553, 899, 900, 1658, 568, 
         909, 1767, 910, 583, 927, 1775, 928, 1023, 930, 931, 1028, 1803, 950,
          951, 618, 1727, 967, 968, 1032}], 
        Line3DBox[{453, 797, 798, 1607, 454, 815, 1739, 816, 987, 817, 1740, 
         818, 991, 838, 1750, 849, 839, 993, 851, 1756, 864, 852, 509, 871, 
         996, 872, 524, 1698, 881, 1001, 882, 1635, 539, 891, 1006, 892, 1649,
          554, 901, 1011, 1797, 902, 569, 911, 1016, 1799, 912, 1018, 916, 
         1769, 929, 917, 1024, 933, 1776, 934, 1029, 952, 953, 619, 1728, 969,
          970, 1033}], 
        Line3DBox[{455, 799, 801, 456, 819, 1742, 821, 988, 822, 1744, 824, 
         992, 840, 1752, 850, 842, 994, 853, 1757, 865, 855, 510, 873, 1763, 
         997, 875, 525, 883, 1002, 885, 1636, 540, 893, 1007, 1796, 895, 555, 
         903, 1012, 1798, 905, 570, 913, 1017, 1800, 915, 1020, 919, 1772, 
         932, 921, 1025, 935, 1778, 937, 1030, 954, 1786, 956, 620, 1729, 971,
          973, 1034}], 
        Line3DBox[{461, 648, 1611, 462, 831, 832, 1617, 989, 833, 834, 1622, 
         487, 678, 500, 1682, 689, 515, 1691, 701, 530, 1702, 713, 1640, 545, 
         725, 1652, 560, 737, 1660, 575, 749, 1665, 588, 761, 600, 1716, 960, 
         961, 1031, 1804, 962, 963, 625, 1733, 791, 637}], 
        Line3DBox[{463, 649, 1612, 464, 658, 1618, 476, 668, 1623, 488, 679, 
         1625, 501, 1683, 690, 516, 1692, 702, 531, 1703, 714, 1641, 546, 726,
          1653, 561, 738, 1661, 576, 750, 1666, 589, 762, 1669, 601, 771, 611,
          1722, 780, 626, 1734, 792, 638}], 
        Line3DBox[{465, 650, 1613, 466, 659, 1619, 477, 669, 1624, 489, 680, 
         1626, 502, 691, 1627, 517, 703, 532, 1704, 715, 1642, 547, 727, 1654,
          562, 739, 1662, 577, 751, 1667, 590, 763, 1670, 602, 772, 1671, 612,
          781, 627, 1735, 793, 639}], 
        Line3DBox[{467, 805, 1737, 806, 468, 660, 1620, 478, 846, 1754, 847, 
         490, 860, 1760, 861, 503, 692, 1628, 518, 704, 1629, 533, 716, 1643, 
         1644, 548, 728, 1655, 563, 740, 1663, 578, 752, 1668, 591, 943, 1783,
          944, 603, 964, 1788, 965, 613, 782, 1672, 628, 977, 978, 979}], 
        Line3DBox[{629, 783, 966, 1723, 614, 773, 1717, 604, 764, 1784, 945, 
         592, 753, 1774, 926, 579, 741, 1708, 564, 729, 1706, 549, 717, 1705, 
         534, 1630, 705, 1693, 519, 693, 1684, 504, 681, 1677, 491, 670, 1755,
          848, 479, 661, 1748, 835, 469, 651, 1673, 444, 640, 794, 980}], 
        Line3DBox[{633, 787, 1789, 972, 621, 776, 1785, 955, 607, 767, 1777, 
         936, 596, 757, 1771, 920, 584, 745, 1768, 1019, 914, 571, 733, 1765, 
         1013, 904, 556, 721, 1764, 1008, 894, 541, 709, 1003, 1795, 884, 526,
          697, 998, 1793, 874, 511, 685, 866, 1761, 854, 496, 674, 1751, 841, 
         483, 664, 1743, 823, 472, 654, 1741, 820, 457, 644, 1736, 800, 981}],
         Line3DBox[{634, 788, 974, 1730, 622, 777, 1787, 957, 608, 768, 1780, 
         939, 597, 758, 938, 1779, 923, 585, 746, 1770, 1021, 918, 572, 734, 
         1766, 1014, 906, 557, 722, 1009, 896, 542, 1637, 710, 1004, 886, 
         1699, 527, 698, 999, 1794, 876, 512, 686, 867, 1762, 857, 497, 675, 
         856, 1758, 843, 484, 665, 1746, 826, 473, 655, 1745, 825, 458, 1608, 
         645, 802, 982}], 
        Line3DBox[{635, 789, 975, 1731, 623, 778, 958, 1720, 609, 769, 1782, 
         941, 598, 759, 1026, 1801, 925, 586, 747, 1773, 1022, 922, 573, 735, 
         1015, 907, 558, 1650, 723, 1010, 897, 543, 1638, 711, 1005, 887, 
         1700, 528, 699, 1000, 877, 1689, 513, 687, 995, 1792, 859, 498, 676, 
         858, 1759, 844, 485, 666, 1747, 828, 474, 1790, 656, 827, 459, 1609, 
         646, 803, 983}], 
        Line3DBox[{636, 790, 976, 1732, 624, 779, 959, 1721, 610, 770, 942, 
         1715, 599, 760, 1781, 940, 587, 748, 924, 574, 1659, 736, 908, 559, 
         1651, 724, 898, 544, 1639, 712, 888, 1701, 529, 700, 878, 1690, 514, 
         688, 868, 1681, 499, 677, 1753, 845, 486, 667, 830, 475, 1791, 657, 
         829, 460, 1610, 647, 804, 984}]}, {}, {}}},
     VertexNormals->CompressedData["
1:eJx9vXVYlc3zP46JLQZ2NxYqtugoJoqNoliI3aKChYlgKwaIitICoqKUijGi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      "]], {}}, 
   {RGBColor[0, 0, 1], PointSize[Medium], Point3DBox[{0, 0, 0}]}, {{{}, {}, 
     TagBox[
      {RGBColor[1, 0, 0], AbsoluteThickness[2], Opacity[0.5], 
       Line3DBox[CompressedData["
1:eJw12Xc41e//B3DSUCGrUqJEZEa2yosoKyUllZGRooxEykjZyh6pZPvYxTn2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        "]]},
      Annotation[#, "Charting`Private`Tag$10805#1"]& ]}, {}}},
  Axes->True,
  AxesLabel->{
    FormBox[
     TagBox[
      StyleBox[
       TagBox["x", HoldForm], 12, StripOnInput -> False], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox[
      StyleBox[
       TagBox["y", HoldForm], 12, StripOnInput -> False], HoldForm], 
     TraditionalForm], 
    FormBox[
     TagBox[
      StyleBox[
      "\"\\!\\(\\*FormBox[RowBox[{\\\"\[Omega]\\\", \\\"(\\\", \
RowBox[{\\\"x\\\", \\\",\\\", \\\"y\\\"}], \\\")\\\"}], \
TraditionalForm]\\)\"", 12, StripOnInput -> False], HoldForm], 
     TraditionalForm]},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->250,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {0., 2.9999985714288364`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->316586410,ExpressionUUID->"0566a589-32e0-481e-84af-47f7785b6eb1"]
}, {2}]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9268bf03-d787-42d6-b66c-53b8e94a912e"],
 " takes a minimum at a point inside the red circle. It is not harmonic:"
}], "SolvedExampleNote",
 CellID->117279980,ExpressionUUID->"4ecc9e95-a1eb-4b01-b8ac-652950bfcdfb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"y", "^", "4"}], "+", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"w", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "SolvedExampleInput",
 CellID->380284638,ExpressionUUID->"3b1f66ab-487f-4e01-92c1-188e6587bd13"],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["y", "2"]}]}]], "SolvedExampleOutput",
 CellID->587065115,ExpressionUUID->"4d326064-fa39-4701-ba69-f7cc8a10eda4"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1930283605,ExpressionUUID->"ed453168-666d-40b0-a82a-ffd8d668ad43"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"5e2e41c9-9691-47a0-8f87-61ad39071f07"],

Cell["Harmonic functions satisfy the mean-value property.", "SummaryList",
 CellID->518126403,ExpressionUUID->"db6760fb-7c61-4231-9145-e0e4c728fcce"],

Cell["Harmonic functions satisfy the maximum principle.", "SummaryList",
 CellID->37971159,ExpressionUUID->"7d966927-f78e-4bca-8712-30740a71f2e6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->39465049,ExpressionUUID->"9f2b54e9-3644-498b-a622-eee65022f0dd"],

Cell[TextData[{
 "Check that the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["y", "2"], "+", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ea13377d-4568-4f42-b3e5-c37b55b80843"],
 " is harmonic and that it satisfies the mean-value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e3025644-abb0-4fa2-bfa0-33cb25b6b8d8"],
 "."
}], "Exercise",
 CellID->545467999,ExpressionUUID->"ce0d733f-9aaf-4143-813f-e467aa0d9e44"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"42c5c71e-7d0c-4937-b216-0c7a54c29816"],

Cell[TextData[{
 "Calculate the Laplacian of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "3ed6978f-e708-4048-9c50-ffbf0e375e38"],
 ":"
}], "SolutionAnswer",
 CellID->586605357,ExpressionUUID->"1a8ead39-6436-42ed-acd5-7421e9451103"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}], "+", 
    SuperscriptBox["y", "2"], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "ExerciseInput",
 CellID->66966085,ExpressionUUID->"1af274e0-f3e0-4238-bd2c-343e788960ff"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->23831387,ExpressionUUID->"60a426ac-36c2-4d48-b881-692c36906f95"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "be2fd151-3e11-43d2-b0c4-8b9f5cfe47e2"],
 " is harmonic. The equation of a circle around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2c30c0c2-f420-4df7-8421-2f433b6f70b2"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"r", " ", "cos\[Theta]"}]}], ",", 
     RowBox[{"r", " ", "sin\[Theta]"}]}], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b09af225-dcb6-475b-8a8a-93785f767926"],
 ", so to check the mean-value property:"
}], "SolutionAnswer",
 CellID->154471713,ExpressionUUID->"83456228-33f7-446e-8a05-e2374ac759d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"1", ",", "0"}], "]"}], "==", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]"}]], 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{"r", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
       RowBox[{"r", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]}]], "ExerciseInput",
 CellID->31012,ExpressionUUID->"bf412d0b-0115-40ac-9028-eaddd37f54a4"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->295116169,ExpressionUUID->"0addb1cc-3406-4769-8e15-ddc0d40d8915"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Check that the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"2", " ", "y"}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "+", 
     SuperscriptBox["y", "3"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"05264ae2-400d-4a29-b948-9b7fb65c65a0"],
 " is harmonic and that it satisfies the mean-value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"33922a6f-2563-4aa6-aec4-e4d1ae2312ce"],
 "."
}], "Exercise",
 CellID->5684919,ExpressionUUID->"48a16975-bd32-4cbb-844d-49e0151e8473"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"5bc6b470-b987-4d2d-bf5d-29ebc0314607"],

Cell[TextData[{
 "Calculate the Laplacian of ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "bb856099-1e94-4eb3-ade1-c5f9153da614"],
 ":"
}], "SolutionAnswer",
 CellID->414225805,ExpressionUUID->"b6f32d59-80cd-4461-a128-bac02ce8aa4d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"2", " ", "y"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    SuperscriptBox["y", "3"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "ExerciseInput",
 CellID->505486761,ExpressionUUID->"f40603f3-b6a4-4b63-a58e-a08e2e96754d"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->24700,ExpressionUUID->"fd350a7f-ffd2-4b7a-9fdf-1458a708d514"]
}, Open  ]],

Cell[TextData[{
 "So ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1392ab85-941d-4e68-a630-95fd1aa6e865"],
 " is harmonic. The equation of a circle around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c1239e34-d460-4c1a-9ed3-45cfc1e061ae"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"r", " ", "cos\[Theta]"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"r", " ", "sin\[Theta]"}]}]}], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"85e90124-93c8-4738-bd13-e180886e0d53"],
 ", so to check the mean-value property:"
}], "SolutionAnswer",
 CellID->652843586,ExpressionUUID->"935d6a36-4af2-4e2f-95b9-d0dfa557139e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"0", ",", 
    RowBox[{"-", "1"}]}], "]"}], "==", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]"}]], 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]}]], "ExerciseInput",
 CellID->188123579,ExpressionUUID->"008dc32d-39b9-43d5-97a6-f87523554b0f"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->48588571,ExpressionUUID->"4f63418d-d482-44fb-b8e3-f51ab2b2d922"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Does the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"3", "x"}], "+", "y"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cf001cc2-e3e4-472d-9fe0-107db603c1ab"],
 " satisfy the mean-value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"0", ",", "0"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"db417b69-27d4-407a-a805-9de537abc1e6"],
 "?"
}], "Exercise",
 CellID->357501273,ExpressionUUID->"543b8e1e-3c5e-4cae-a4ac-0462fcc9aefa"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"d38d2dc2-e373-4357-b6fa-142c1a2a15f8"],

Cell["The function is harmonic:", "SolutionAnswer",
 CellID->449548618,ExpressionUUID->"2e865112-bf83-40dc-a1f6-6333f97ab643"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "x"}], "+", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->74876164,ExpressionUUID->"30b845ce-430a-4d68-ae1e-e14b1b88432b"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->414351898,ExpressionUUID->"ce8ee69b-960a-4213-8567-327a86254836"]
}, Open  ]],

Cell["So it must satisfy the mean-value property.", "SolutionAnswer",
 CellID->641308473,ExpressionUUID->"31a8cfe2-2082-4ccc-bb3c-652f3d444e8d"]
}, Closed]],

Cell[TextData[{
 "Does the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["x", "4"]}], "+", 
     SuperscriptBox["y", "2"], "+", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"03b84a0e-9c3a-4a7d-9c80-ea7ab80e7223"],
 " satisfy the mean-value property at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{"(", 
     RowBox[{"0", ",", "0"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4f2ab31a-6154-4861-94d8-b0db112c4430"],
 "?"
}], "Exercise",
 CellID->776810,ExpressionUUID->"e9779311-48af-4064-a7cf-3f7cbd7e7a0d"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"5796105c-4f28-4477-9f18-723637006443"],

Cell[TextData[{
 "A circle centered at zero has equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"r", " ", "cos\[Theta]"}], ",", 
     RowBox[{"r", " ", "sin\[Theta]"}]}], ")"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"14d283dd-91e8-4de9-ac5c-141df4817f02"],
 ". The mean-value property is:"
}], "SolutionAnswer",
 CellID->164326409,ExpressionUUID->"34da0954-2cef-4166-8425-2220d9c96524"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"y", "^", "2"}], "+", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"0", ",", "0"}], "]"}], "==", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]"}]], 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{
       RowBox[{"r", " ", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
       RowBox[{"r", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]}]}], "ExerciseInput",
 CellID->659017478,ExpressionUUID->"2e1eb1db-263d-4ce4-9436-799be26d128d"],

Cell[BoxData[
 RowBox[{"1", "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SuperscriptBox["r", "2"], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["r", "4"]}], "4"]}], ")"}]}]}]], "ExerciseOutput",
 CellID->269225039,ExpressionUUID->"89afdd26-8421-4be6-bb54-1593987f9d8b"]
}, Open  ]],

Cell[TextData[{
 "The equality is not true in general, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7da707e9-5f6d-4f10-aa31-8f571f8e5338"],
 " does not satisfy the mean value property."
}], "SolutionAnswer",
 CellID->199399482,ExpressionUUID->"b38b9e06-129b-46af-b638-002b6b569deb"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Can the function whose graph is plotted here be a harmonic function?\
\>", "Exercise",
 CellID->109085738,ExpressionUUID->"241cb1d8-84eb-4cd3-a634-d6acea4d04fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", 
      RowBox[{"HoldForm", "[", 
       RowBox[{"u", "[", 
        RowBox[{"x", ",", "y"}], "]"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "->", 
    RowBox[{"Directive", "[", "12", "]"}]}]}], "]"}]], "ExerciseInput",
 CellID->538158037,ExpressionUUID->"7e773fbd-1d1b-4379-bc48-bde05c24b326"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1nXeYlUXytnFNgHHVXQPBhICCiq646k8tMQ66mF1c10wwAIpiQEFM65ow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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJxNnAf8V9P/xz93nHuvFMnIjCKUSGYqEpWRQiFKGiJCGUklpKhIy14ZGdki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            "]], Polygon3DBox[CompressedData["
1:eJwtm3fgltMbxp/3fc7znFdCEdkKlcrMSGgqWe1EQntZITOUikqDVMhW9t57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            "]], Polygon3DBox[CompressedData["
1:eJwt1nm0lVUZx/EXOOe8F1TAkEk09cIFB2wFagIBMigXUFBwyAFiUtcCRUzL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            "]], 
           Polygon3DBox[{{1595, 1008, 1145, 2003, 1485, 1486}, {1506, 1505, 
            2004, 1146, 1147, 2005}, {1946, 960, 830, 829, 1105, 1652}, {1718,
             1192, 949, 950, 1193, 1719}}]},
          Annotation[#, "Charting`Private`Tag$10619#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt1HmQz3Ucx/GPYxPpEC0KIUIihfirP4wZfzSjmR3+yvjDmMyUoywVy7rC
3msXm2sTWUnZ1qK2HIkc697VgeSIXfctt3h8Zvzx9Hq/36/X5/P5fj/7/Wk1
aETS8BohhLf9swGxvlA7hGRFqXo9zUkI4duaIbyPb1CB5ZiGKbx3ZNZimf7N
WiEUWDfDvJW6JaaYv8WfXCeEqeqxvK/pZ9iHldjE/57+gd8xVWYBPYCDKMFf
+BNrMAzP2nsVPYJ/8AVSnXGUHsNqTLRvGX1OthF+jM8sk04nOKMXv7N5d30n
2g25/ELv8HN8Rv4AjDPL0q9DE5m19CTWxzN4GTKHrdlLe9MEs3z1CXUFzdSf
kj2NDTiDX5AT35U3WKYAm/TjUGRdtnk7Z72M1/AeP9szp5vPk1mMuajDO0vn
8bfQ8zgX/z5yqbQe/wl8pa5LH8dl9RVcxXZMl71Or8X3wWTn1Jd7Ekv0Zfa+
S+9hJnYiTWZW/HtaO5TfRbY5XkE+ryd9EUUyy/jD4j2aF+iXogXvExrofZoe
vzOZRJzE7BAvMoRidRNUIVf/qWwNa3bRmnQ3/RxZvL4yJdgT3wErbDHTvLvc
q+iI1/GRzCXPncmbLbcXL5g3w8fx+fg76AP8jwy5SfQ27mCMteX0+bgXHY3/
cAPb4n3K36I343eGSfIX6SVsjd+0/UfRC8jDb8jHRbmJ1g7hz9C3t38H5Jgv
9S7jzbrqN8ffikwfjOfl6n9FU95G+iGS49m8WTLV1lbSpHin8VtWH1Xuoxn6
atkRGIkqLEJ2/P55A2V248v4G7Mmy6ytc9og0+xd3jTPnKFO4f1EE3mNcUJd
zl9IH9MnIE0mRX8c/8bfrLU/0Ia84fQwhqKBvpDWprUwNt6j7CH6N0rjvdl7
P32G/zTmq+fE54jfiXP689P0rXkvIc+8Bx1j9gYtphtl+sV75E2P3wye4n1H
P0BlvAdeqUyzR/9PPgTF5rib
        "]]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1792, 1606, 1761, 1755, 1791, 2180, 2018, 1684, 1605, 2057, 
        2005, 1506, 1604, 2056, 1504, 1603, 2055, 1502, 1602, 2054, 1500, 
        1601, 2053, 1498, 1600, 2052, 1496, 1014, 2051, 1494, 1599, 2050, 
        1492, 1598, 2049, 1490, 1597, 2048, 1488, 1596, 2047, 1486, 1595, 
        2046, 1682, 1741, 1594, 2176, 1760, 1754, 1769, 1753, 1793, 1797}], 
       Line3DBox[{1912, 1765, 1870, 1764, 1842, 1581, 1841, 2194, 1830, 1840, 
        1839, 1868, 1580, 2172, 2025, 1727, 1634, 1653, 1579, 2171, 1726, 
        1782, 1781, 1752, 2178, 1945, 1757, 1725, 1078, 1650, 1578, 1724, 
        1838, 2191, 2024, 1865, 1577, 1892, 1837, 1828, 2023, 2190, 1836, 
        1867, 1576, 1860, 1756, 1922}], 
       Line3DBox[{729, 380, 1265, 320, 562, 510, 2032, 1729, 1582, 1728, 1998,
         2033, 1730, 1583, 1656, 2150, 1651, 1731, 1584, 1437, 2148, 1652, 
        1946, 2147, 1438, 1654, 1947, 2149, 1439, 1655, 2034, 1585, 1440, 
        1804, 2035, 1586, 1843, 606, 2036, 1884, 608, 1659, 343, 1282, 436, 
        772}], Line3DBox[{1913, 1936, 1714, 2181, 1774, 1857, 1773, 1568, 
        1821, 1822, 1713, 2166, 1996, 1567, 2012, 2142, 1750, 1712, 1566, 
        2010, 2141, 1749, 1710, 1565, 2170, 1721, 1720, 1564, 2168, 1719, 
        1718, 2169, 1563, 1716, 1189, 1562, 1819, 2140, 2019, 1561, 1715, 
        1880, 2196, 1882, 1881, 1560, 1771, 1772, 2139, 1707, 1943, 1927}], 
       Line3DBox[{1914, 1776, 1864, 1775, 1569, 1823, 2186, 2020, 1820, 1825, 
        1824, 1570, 2021, 2167, 1826, 1717, 1648, 1571, 2013, 2175, 1751, 
        1802, 1801, 2177, 1572, 1777, 1778, 1722, 2143, 1997, 1573, 1649, 
        1723, 2022, 2187, 1827, 1574, 1834, 1835, 1833, 1346, 1859, 1575, 
        1779, 1858, 1780, 2031}], 
       Line3DBox[{1915, 1909, 1911, 1937, 1785, 1670, 1736, 1669, 2153, 2029, 
        1457, 1895, 1886, 1888, 1885, 2197, 1456, 980, 1455, 2093, 1954, 1454,
         2092, 1953, 1453, 2091, 1952, 1452, 2090, 1951, 2042, 1451, 1592, 
        2041, 1450, 1591, 2040, 1449, 1667, 1735, 1128, 1448, 2154, 1665, 
        1733, 1664, 1447, 1805, 2182, 1637, 1662, 1636, 1766, 1910, 1908, 
        1923}], Line3DBox[{1916, 1787, 1639, 1674, 1807, 1862, 1806, 2156, 
        1471, 1675, 1739, 2102, 2001, 1472, 1678, 2103, 2002, 1473, 1962, 
        2104, 1474, 1963, 2105, 1475, 999, 1476, 2045, 1964, 2106, 1477, 1965,
         2107, 1478, 1966, 2108, 1479, 1967, 2109, 1480, 1968, 2110, 1481, 
        1969, 2111, 1482, 1141, 1679, 1483, 2193, 1848, 1869, 1849, 1676, 
        1640, 1788, 1924}], 
       Line3DBox[{1917, 1799, 1763, 1694, 1643, 1850, 2161, 1692, 1624, 1745, 
        1691, 2173, 1744, 1623, 2076, 2007, 1528, 1622, 2075, 1527, 1621, 
        2074, 1526, 1042, 1525, 2127, 1983, 1524, 2126, 1982, 2073, 1523, 
        1620, 2072, 1522, 1619, 2071, 1521, 1618, 2070, 1520, 1617, 2069, 
        1519, 2160, 1981, 1873, 1689, 1743, 2184, 1813, 1812, 1690, 1642, 
        1798, 1925}], 
       Line3DBox[{1918, 1758, 1783, 1759, 1661, 1844, 1845, 1635, 1732, 964, 
        1663, 1999, 2037, 1734, 1587, 1666, 2152, 1657, 1588, 1441, 2151, 
        1658, 1589, 1442, 2038, 1948, 2087, 1443, 1949, 2088, 1444, 1950, 
        2089, 1445, 969, 1446, 2028, 2039, 1590, 1889, 2198, 1660, 1887, 1893,
         1894, 1668, 2014, 2179, 1784, 1938, 1905, 1944, 1928}], 
       Line3DBox[{1919, 1904, 1811, 1762, 1688, 1641, 2159, 1687, 1616, 2068, 
        2006, 1518, 1615, 2067, 1517, 1614, 2066, 1516, 1613, 2065, 1515, 
        1612, 2064, 1514, 1028, 1513, 2125, 1980, 2063, 1512, 1611, 2062, 
        1511, 1610, 2061, 1510, 1609, 2060, 1509, 1608, 2059, 1508, 1607, 
        2058, 1685, 1742, 2158, 1979, 1686, 1795, 1796, 1941, 1794, 1931}], 
       Line3DBox[{1920, 1767, 1786, 1768, 1677, 2112, 1995, 1484, 1681, 2113, 
        2003, 1485, 1970, 2114, 1487, 1971, 2115, 1489, 1972, 2116, 1491, 
        1973, 2117, 1493, 1013, 2118, 1495, 1974, 2119, 1497, 1975, 2120, 
        1499, 1976, 2121, 1501, 1977, 2122, 1503, 1978, 2123, 1505, 2004, 
        2124, 1683, 1507, 2157, 1680, 1740, 1790, 1810, 1940, 1789, 1930}], 
       Line3DBox[{1921, 1907, 1800, 2146, 2017, 1818, 1817, 1856, 1647, 1705, 
        1089, 1559, 1704, 1748, 2174, 2008, 1558, 2011, 2138, 1711, 1557, 
        2165, 1709, 1708, 1556, 2137, 1994, 1555, 2136, 1993, 2086, 1554, 
        1633, 2085, 1553, 1065, 1552, 1879, 1902, 2202, 2027, 1903, 1551, 
        1891, 2009, 2135, 1877, 1706, 1878, 1550, 1770, 1803, 1939, 1906, 
        1942, 1926}], 
       Line3DBox[{1929, 2015, 1863, 1855, 1701, 1854, 1702, 2199, 1890, 1539, 
        1899, 1875, 1898, 1876, 2195, 1540, 2201, 1900, 1901, 1541, 2082, 
        1631, 1542, 2083, 1632, 1543, 2084, 1989, 2131, 1544, 1990, 2132, 
        1545, 1991, 2133, 1546, 1992, 2134, 1547, 1168, 1703, 1548, 2164, 
        1697, 1747, 1698, 1549, 2145, 1645, 1700, 1646, 1815, 1816, 2016, 
        2030}], Line3DBox[{1932, 1638, 1847, 2192, 1470, 1883, 1809, 1829, 
        1808, 2183, 1469, 2101, 1961, 1468, 2100, 1960, 1467, 2099, 1959, 
        1466, 2098, 1958, 1465, 2097, 1957, 1464, 2096, 1956, 2044, 1463, 
        1593, 2043, 1462, 985, 1461, 2095, 1955, 1460, 2000, 2094, 1738, 1673,
         1459, 2155, 1672, 1737, 1671, 1458, 2188, 1846, 1861, 1871, 1872, 
        1935}], Line3DBox[{1933, 1851, 2144, 2026, 1831, 1874, 1814, 1853, 
        1984, 2185, 1529, 1896, 1897, 1985, 2200, 1530, 2077, 1625, 1531, 
        2078, 1626, 1532, 2079, 1627, 1533, 2080, 1986, 2128, 1534, 1987, 
        2129, 1535, 1988, 2130, 1536, 1055, 1537, 2081, 1628, 1538, 2162, 
        1695, 1746, 1629, 1696, 2163, 1693, 1699, 1630, 1832, 2189, 1852, 
        1866, 1644, 1934}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1261, 1240, 1241, 1226, 1230, 2178, 958, 825, 1104, 2147, 
        960, 830, 2087, 966, 838, 2090, 976, 850, 2096, 988, 863, 2106, 1001, 
        877, 2118, 1014, 891, 2125, 1027, 905, 2126, 1040, 919, 2128, 1052, 
        932, 2131, 1061, 942, 2136, 1068, 950, 1193, 2168, 1072, 954, 1273, 
        2177, 1274, 1229, 1235, 1228, 1258, 1280}], 
       Line3DBox[{1402, 1400, 1098, 1429, 1243, 1080, 1112, 1081, 2032, 1323, 
        1209, 1115, 1125, 1116, 2037, 1213, 1128, 1135, 1129, 846, 2095, 984, 
        859, 2104, 997, 873, 2115, 1010, 2048, 887, 1023, 2060, 901, 1036, 
        2070, 915, 1048, 2077, 928, 1392, 2201, 1393, 1394, 1395, 2202, 1366, 
        1369, 1367, 1372, 1373, 2196, 1186, 1224, 1187, 1272, 1188, 1401, 
        1416}], Line3DBox[{1404, 1278, 1094, 1201, 1301, 1351, 1300, 2167, 
        1191, 1190, 1189, 948, 2085, 1066, 940, 2083, 1059, 930, 2079, 1050, 
        917, 2072, 1038, 903, 2062, 1025, 889, 2050, 1012, 2117, 875, 999, 
        861, 2043, 986, 848, 2041, 974, 836, 1121, 2151, 1120, 1211, 1102, 
        2150, 1117, 1101, 1205, 2191, 1316, 1353, 1317, 1376, 1099, 1375, 
        1077, 1260, 1411}], 
       Line3DBox[{1405, 1264, 1079, 1108, 1318, 1319, 2172, 827, 1109, 962, 
        2034, 832, 2089, 968, 840, 2092, 978, 852, 2098, 990, 865, 2108, 1003,
         879, 2120, 1016, 2053, 893, 1029, 2064, 907, 1042, 921, 2130, 1054, 
        934, 2133, 1063, 944, 1176, 2165, 1070, 952, 2141, 1177, 1197, 1074, 
        956, 2187, 1302, 1096, 1204, 1237, 1281, 1420}], 
       Line3DBox[{1406, 1428, 1130, 2179, 1246, 1245, 1214, 1386, 1387, 2153, 
        1385, 1131, 1304, 1289, 2183, 1290, 869, 1141, 1142, 883, 2124, 1146, 
        1147, 2057, 897, 1150, 1151, 2068, 911, 1157, 1220, 2173, 1158, 1221, 
        1160, 1164, 2163, 1161, 1167, 1088, 2145, 1173, 1341, 1340, 1342, 
        1254, 1295, 1255, 2146, 1184, 1435, 1415}], 
       Line3DBox[{1407, 1233, 1356, 970, 843, 1325, 2188, 1326, 1305, 1306, 
        981, 856, 1287, 2156, 1288, 1139, 994, 870, 2112, 1084, 1217, 1234, 
        1007, 2176, 884, 1268, 1269, 1218, 2158, 1020, 898, 1086, 1219, 1292, 
        2184, 1033, 912, 1311, 1312, 1310, 2144, 1336, 1360, 1361, 1045, 925, 
        1362, 1363, 1350, 1251, 1421}], 
       Line3DBox[{1408, 1253, 1294, 1252, 1339, 1337, 2189, 1338, 1313, 1335, 
        1334, 1359, 1332, 2161, 1333, 1159, 1087, 1153, 1085, 2159, 1152, 
        1250, 1249, 1227, 2180, 1266, 1267, 1148, 2157, 1144, 1216, 1083, 
        1143, 1331, 2193, 1330, 1358, 1308, 1309, 1291, 1329, 2192, 1328, 
        1357, 1247, 1327, 1248, 1414}], 
       Line3DBox[{779, 439, 1803, 360, 937, 579, 1365, 2199, 601, 926, 1046, 
        2185, 1293, 913, 1034, 2160, 1154, 899, 2058, 1021, 1149, 885, 2046, 
        1008, 1145, 2113, 871, 995, 1215, 1138, 2102, 857, 982, 1137, 2155, 
        1133, 844, 971, 1132, 2182, 455, 540, 321, 1783, 383, 734}], 
       Line3DBox[{1409, 1397, 1282, 1244, 1212, 1384, 1122, 1383, 2198, 1123, 
        1382, 1380, 2197, 1381, 855, 2101, 993, 868, 2111, 1006, 882, 2123, 
        1019, 2056, 896, 1032, 2067, 910, 1155, 1156, 2076, 924, 1162, 2162, 
        1163, 1222, 1165, 2164, 1170, 1166, 1174, 1089, 1182, 1090, 1344, 
        1343, 1185, 1257, 2181, 1271, 1433, 1399, 1436, 1418}], 
       Line3DBox[{1410, 1398, 1270, 2139, 1256, 946, 1371, 1370, 1368, 1175, 
        2135, 1388, 938, 1057, 2195, 1364, 927, 1047, 2200, 1391, 914, 2069, 
        1035, 900, 2059, 1022, 886, 2047, 1009, 2114, 872, 996, 1140, 2103, 
        858, 983, 1136, 2094, 845, 972, 1134, 2154, 1126, 834, 964, 1124, 
        1082, 1324, 1286, 1349, 1232, 1265, 1430, 1231, 1434, 1413}], 
       Line3DBox[{1412, 1262, 1284, 1263, 1106, 959, 2171, 826, 1107, 2149, 
        961, 831, 2088, 967, 839, 2091, 977, 851, 2097, 989, 864, 2107, 1002, 
        878, 2119, 1015, 2052, 892, 1028, 906, 2127, 1041, 920, 2129, 1053, 
        933, 2132, 1062, 943, 2137, 1069, 951, 1196, 2170, 1073, 955, 2143, 
        1095, 1203, 1236, 1279, 1431, 1396, 1423}], 
       Line3DBox[{1417, 1275, 1277, 1276, 1202, 1195, 2175, 1225, 1194, 2169, 
        1192, 949, 2086, 1067, 941, 2084, 1060, 931, 2080, 1051, 918, 2073, 
        1039, 904, 2063, 1026, 890, 2051, 1013, 876, 2045, 1000, 862, 2044, 
        987, 849, 2042, 975, 837, 2038, 965, 829, 1105, 2148, 1103, 1206, 
        1078, 1100, 1239, 1283, 1432, 1238, 1422}], 
       Line3DBox[{1419, 1259, 1200, 1345, 1092, 1199, 1091, 2166, 1183, 1172, 
        1180, 1171, 2174, 1223, 1169, 1168, 936, 2081, 1056, 923, 2075, 1044, 
        909, 2066, 1031, 895, 2055, 1018, 2122, 881, 1005, 2110, 867, 992, 
        2100, 854, 980, 842, 2039, 1378, 1377, 1379, 1389, 2036, 1111, 1390, 
        1110, 1355, 1347, 1207, 1242, 1403}], 
       Line3DBox[{1424, 1076, 1315, 2190, 1303, 1113, 1208, 1114, 2033, 1210, 
        1118, 1127, 2152, 1119, 835, 973, 2040, 847, 985, 860, 2105, 998, 874,
         2116, 1011, 2049, 888, 1024, 2061, 902, 1037, 2071, 916, 1049, 2078, 
        929, 1058, 2082, 939, 1065, 947, 2140, 1296, 1307, 1297, 1298, 2186, 
        1299, 1314, 1093, 1426}], 
       Line3DBox[{1425, 1320, 1354, 2194, 1321, 828, 1348, 1285, 1322, 963, 
        2035, 833, 969, 841, 2093, 979, 853, 2099, 991, 866, 2109, 1004, 880, 
        2121, 1017, 2054, 894, 1030, 2065, 908, 1043, 2074, 922, 1055, 935, 
        2134, 1064, 945, 2138, 1178, 1179, 1071, 953, 2142, 1181, 1198, 1075, 
        957, 1346, 1352, 1374, 1097, 1427}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJx1XWV4lUfTxgnuDsGhuDt0cHcpFHd3imtxK1ogUNyd4gUCExI8SAhJCISE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     "]], {}},
  Axes->True,
  AxesLabel->{
    FormBox[
     TagBox[
      TagBox["x", HoldForm], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox["y", HoldForm], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      TagBox[
       RowBox[{"u", "(", 
         RowBox[{
           TagBox["x", HoldForm], ",", 
           TagBox["y", HoldForm]}], ")"}], HoldForm], HoldForm], 
     TraditionalForm]},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->Directive[12],
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {0., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic}]], "ExerciseOutput",
 CellID->33107683,ExpressionUUID->"ae0b8967-fa69-4ac1-aa33-5be0a0fd8d84"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"c787724d-c579-4e8b-be6a-f2abd91b6189"],

Cell["No, because it does not satisfy the maximum principle.", \
"SolutionAnswer",
 CellID->11015911,ExpressionUUID->"e875f31c-2b99-4a5f-80de-745c0cad26ad"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->656831372,ExpressionUUID->"95036642-45f2-41c9-a041-6762a557632e"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"18. Properties of Harmonic Functions | Essentials of Complex \
Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "17. Harmonic Functions"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "19. Power Series"}, "PrettyTooltipTemplate"], "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"68d8e57a-4222-4c42-aed1-75f0af052d50"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Example181"->{
  Cell[7950, 257, 212, 9, 71, "SolvedExample",ExpressionUUID->"368efd31-ec6b-42d9-8b47-280a554e13cc",
   CellTags->"Example181",
   CellID->647135627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Example181", 634872, 11967}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[661, 24, 239, 7, 108, "Section",ExpressionUUID->"ba31ad40-080a-4c38-9983-e0ded3793494",
 CounterAssignments->{{"Section", 17}},
 CellID->157056355],
Cell[903, 33, 245, 4, 60, "Text",ExpressionUUID->"6cdfcdaa-d733-491b-b926-3cb3401ecbdd",
 CellID->315481809],
Cell[CellGroupData[{
Cell[1173, 41, 139, 1, 56, "Subsection",ExpressionUUID->"591ac6b2-a268-4c11-b5c2-0d68d22248c6",
 CellID->372444181],
Cell[1315, 44, 710, 17, 60, "Text",ExpressionUUID->"5d31c366-285f-4666-9034-22927d312cd5",
 CellID->458002980],
Cell[2028, 63, 709, 23, 48, "DisplayFormulaNumbered",ExpressionUUID->"e58e9c17-bcec-448d-953d-068ce9c4def5",
 CellID->21074420],
Cell[2740, 88, 355, 11, 36, "Text",ExpressionUUID->"857c1d18-f25e-44a8-b0e3-0e74b0ec0651",
 CellID->206676896],
Cell[3098, 101, 134, 1, 36, "Text",ExpressionUUID->"f3edec38-6d23-4eee-b668-6715ea1645ed",
 CellID->635667555],
Cell[3235, 104, 1380, 42, 85, "Text",ExpressionUUID->"92fa212d-d1f5-4988-b81e-02fbe7936431",
 CellID->83806537],
Cell[4618, 148, 1617, 48, 57, "DisplayFormulaNumbered",ExpressionUUID->"ad5c324f-d238-46cd-ab7c-3385b2d2855a",
 CellID->89954287],
Cell[6238, 198, 207, 4, 60, "Text",ExpressionUUID->"351b73bc-348a-48f2-aeb2-728db8ca2cbb",
 CellID->572690948],
Cell[6448, 204, 765, 25, 48, "DisplayFormulaNumbered",ExpressionUUID->"d4e9bfdb-efda-4233-a16c-8662c45c8896",
 CellID->222976354],
Cell[7216, 231, 731, 24, 48, "DisplayFormulaNumbered",ExpressionUUID->"b1855a07-6f27-45fe-a429-929b242c5a15",
 CellID->358249251],
Cell[7950, 257, 212, 9, 71, "SolvedExample",ExpressionUUID->"368efd31-ec6b-42d9-8b47-280a554e13cc",
 CellTags->"Example181",
 CellID->647135627],
Cell[8165, 268, 1144, 36, 70, "SolvedExampleNote",ExpressionUUID->"0404c258-cbca-4821-b03e-5518a27cae94",
 CellID->74433536],
Cell[9312, 306, 373, 11, 27, "SolvedExampleInput",ExpressionUUID->"13a8c05b-5148-4034-ba9c-0d0115dc2d66",
 CellID->478784849],
Cell[9688, 319, 328, 10, 39, "SolvedExampleNote",ExpressionUUID->"e5961534-d25e-477d-bbca-0c900dc60585",
 CellID->83208634],
Cell[CellGroupData[{
Cell[10041, 333, 276, 7, 25, "SolvedExampleInput",ExpressionUUID->"869c0ac0-277f-491a-acd7-505777c08937",
 CellID->240465215],
Cell[10320, 342, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"c5d9fe48-8bc2-4915-ab5c-a4d02c5187ff",
 CellID->178561954]
}, Open  ]],
Cell[10451, 346, 550, 16, 42, "SolvedExampleNote",ExpressionUUID->"418636bb-ae47-41a1-abfc-7e98a31f139d",
 CellID->55866720],
Cell[CellGroupData[{
Cell[11026, 366, 365, 10, 47, "SolvedExampleInput",ExpressionUUID->"d7bedcf0-3629-4d8f-b026-5547610b3564",
 CellID->675806070],
Cell[11394, 378, 388, 11, 54, "SolvedExampleOutput",ExpressionUUID->"aaefd654-f22d-4696-bedc-9369fa13ffe0",
 CellID->48054138]
}, Open  ]],
Cell[11797, 392, 133, 1, 39, "SolvedExampleNote",ExpressionUUID->"e2b6b126-4f83-443a-aa57-eb24a36f15e3",
 CellID->12561172],
Cell[CellGroupData[{
Cell[11955, 397, 723, 22, 47, "SolvedExampleInput",ExpressionUUID->"f91eef30-fb26-4516-9395-fa7761caf28b",
 CellID->108993027],
Cell[12681, 421, 119, 1, 36, "SolvedExampleOutput",ExpressionUUID->"600e6ee1-8b3f-4674-8806-0f3292ebe424",
 CellID->519278688]
}, Open  ]],
Cell[12815, 425, 259, 4, 61, "SolvedExampleNote",ExpressionUUID->"a1810c24-fc22-4d4c-8ea0-65ae82f2087f",
 CellID->52391262],
Cell[CellGroupData[{
Cell[13099, 433, 2535, 71, 70, "SolvedExampleInput",ExpressionUUID->"1de5c70f-3eda-4433-9b88-7aeadb40d03d",
 CellID->350235593],
Cell[15637, 506, 89114, 1471, 260, "SolvedExampleOutput",ExpressionUUID->"357a32ec-3a5e-41a0-aaf3-49bdc2a39950",
 CellID->292772797]
}, {2}]],
Cell[104763, 1980, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"0d40e52c-80b5-4deb-8309-eb8f33c19358",
 CellID->943814759],
Cell[104872, 1983, 186, 8, 71, "SolvedExample",ExpressionUUID->"82f71ee7-00a3-43c9-aa02-e2cba969cf85",
 CellID->95679362],
Cell[105061, 1993, 761, 23, 39, "SolvedExampleNote",ExpressionUUID->"c39af8cc-38e0-4c54-8cd1-d7110bc707f0",
 CellID->193021385],
Cell[CellGroupData[{
Cell[105847, 2020, 841, 27, 68, "SolvedExampleInput",ExpressionUUID->"61bea227-9f69-4f4f-b45e-1c1f70869315",
 CellID->8544700],
Cell[106691, 2049, 346, 10, 60, "SolvedExampleOutput",ExpressionUUID->"55abea34-419a-4d26-9d74-8887994cc54d",
 CellID->341933551]
}, Open  ]],
Cell[107052, 2062, 539, 14, 39, "SolvedExampleNote",ExpressionUUID->"add6a4e2-0596-4bba-8bd1-9b779ff563e7",
 CellID->309444499],
Cell[CellGroupData[{
Cell[107616, 2080, 274, 7, 25, "SolvedExampleInput",ExpressionUUID->"270ffb2d-e4fd-43cf-a8d3-171b8b3158d2",
 CellID->1345682],
Cell[107893, 2089, 246, 6, 38, "SolvedExampleOutput",ExpressionUUID->"650f35e2-d969-42f6-824c-73cbeefded7f",
 CellID->292334741]
}, Open  ]],
Cell[108154, 2098, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"d6c6206e-f993-4ced-af5c-7383be0e4f03",
 CellID->1741144738]
}, Open  ]],
Cell[CellGroupData[{
Cell[108298, 2104, 154, 1, 56, "Subsection",ExpressionUUID->"ea8b9080-1ce5-4d58-b2e8-0fe968b2c2b9",
 CellID->214428598],
Cell[108455, 2107, 598, 14, 60, "Text",ExpressionUUID->"d65b1934-8da7-463c-acad-9a83b9d55ae8",
 CellID->73486028],
Cell[109056, 2123, 194, 4, 60, "Text",ExpressionUUID->"0d08d688-81b1-48f4-914f-da9e09ec3c69",
 CellID->388093397],
Cell[109253, 2129, 491, 14, 36, "Text",ExpressionUUID->"7ae03d27-22f3-4812-bcc9-ccc5114e2270",
 CellID->84429583],
Cell[109747, 2145, 611, 17, 36, "Text",ExpressionUUID->"bee6c135-0164-304f-af06-cc1b04815243",
 CellID->97552304],
Cell[110361, 2164, 723, 19, 60, "Text",ExpressionUUID->"d9c4db02-e899-7e48-8013-3f28f85f038f",
 CellID->350174740],
Cell[111087, 2185, 549, 15, 60, "Text",ExpressionUUID->"a8892cb9-76b9-4838-bac1-58f135cfca4b",
 CellID->193407973],
Cell[111639, 2202, 1413, 44, 85, "DisplayFormulaNumbered",ExpressionUUID->"ccce96ae-3395-4fce-9413-de15a64b65ed",
 CellID->28247623],
Cell[113055, 2248, 1737, 51, 85, "Text",ExpressionUUID->"f2a18442-6ecd-4c22-827b-52eac4ca8b78",
 CellID->54068897],
Cell[114795, 2301, 333, 9, 36, "Text",ExpressionUUID->"b15cc1f7-0ee6-4b24-8908-1566cb01d467",
 CellID->687820202],
Cell[115131, 2312, 186, 8, 71, "SolvedExample",ExpressionUUID->"05f54faf-e6f6-4b1f-a184-392533f250fb",
 CellID->20251286],
Cell[115320, 2322, 778, 23, 61, "SolvedExampleNote",ExpressionUUID->"fbe095e0-100b-4e61-bb5b-233717b56dc6",
 CellID->110116075],
Cell[CellGroupData[{
Cell[116123, 2349, 298, 8, 25, "SolvedExampleInput",ExpressionUUID->"bf9c4c08-0b81-42fc-a6b7-965b1d391683",
 CellID->24659456],
Cell[116424, 2359, 414, 12, 38, "SolvedExampleOutput",ExpressionUUID->"e26bcb3b-149b-417c-96ac-899d95e5d93a",
 CellID->142652402]
}, Open  ]],
Cell[116853, 2374, 362, 9, 39, "SolvedExampleNote",ExpressionUUID->"ed094c75-f9a5-47e0-bec8-ba0b69de87a7",
 CellID->207591563],
Cell[CellGroupData[{
Cell[117240, 2387, 4205, 118, 70, "SolvedExampleInput",ExpressionUUID->"9c782935-dbcc-41c7-aca9-872b3c5cdc3d",
 CellID->370972587],
Cell[121448, 2507, 155867, 2585, 262, "SolvedExampleOutput",ExpressionUUID->"e2a207f5-37c5-4d80-a650-6ad7ed0153c4",
 CellID->415712415]
}, {2}]],
Cell[277327, 5095, 425, 10, 61, "SolvedExampleNote",ExpressionUUID->"0a7db16a-0918-4e40-8672-4e0a4b2f64a9",
 CellID->35111040],
Cell[277755, 5107, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"423be015-1cce-4f7b-b254-7be858b52384",
 CellID->122770069],
Cell[277864, 5110, 187, 8, 71, "SolvedExample",ExpressionUUID->"f65ec256-52a8-42a9-93ae-e684522c8a0b",
 CellID->539734450],
Cell[278054, 5120, 508, 14, 39, "SolvedExampleNote",ExpressionUUID->"cd04d34f-74e2-4eed-86d1-7b45579d6984",
 CellID->279692996],
Cell[CellGroupData[{
Cell[278587, 5138, 2472, 68, 70, "SolvedExampleInput",ExpressionUUID->"ca7e54db-e375-4fd8-bbcb-c19692a99e52",
 CellID->465663639],
Cell[281062, 5208, 88877, 1461, 192, "SolvedExampleOutput",ExpressionUUID->"0566a589-32e0-481e-84af-47f7785b6eb1",
 CellID->316586410]
}, {2}]],
Cell[369951, 6672, 390, 9, 39, "SolvedExampleNote",ExpressionUUID->"4ecc9e95-a1eb-4b01-b8ac-652950bfcdfb",
 CellID->117279980],
Cell[CellGroupData[{
Cell[370366, 6685, 512, 15, 43, "SolvedExampleInput",ExpressionUUID->"3b1f66ab-487f-4e01-92c1-188e6587bd13",
 CellID->380284638],
Cell[370881, 6702, 246, 6, 38, "SolvedExampleOutput",ExpressionUUID->"4d326064-fa39-4701-ba69-f7cc8a10eda4",
 CellID->587065115]
}, Open  ]],
Cell[371142, 6711, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"ed453168-666d-40b0-a82a-ffd8d668ad43",
 CellID->1930283605],
Cell[CellGroupData[{
Cell[371274, 6716, 109, 1, 69, "SummarySection",ExpressionUUID->"5e2e41c9-9691-47a0-8f87-61ad39071f07",
 CellID->1198545324],
Cell[371386, 6719, 149, 1, 29, "SummaryList",ExpressionUUID->"db6760fb-7c61-4231-9145-e0e4c728fcce",
 CellID->518126403],
Cell[371538, 6722, 146, 1, 29, "SummaryList",ExpressionUUID->"7d966927-f78e-4bca-8712-30740a71f2e6",
 CellID->37971159]
}, Open  ]],
Cell[CellGroupData[{
Cell[371721, 6728, 159, 3, 65, "ExerciseSection",ExpressionUUID->"9f2b54e9-3644-498b-a622-eee65022f0dd",
 CellID->39465049],
Cell[371883, 6733, 666, 19, 29, "Exercise",ExpressionUUID->"ce0d733f-9aaf-4143-813f-e467aa0d9e44",
 CellID->545467999],
Cell[CellGroupData[{
Cell[372574, 6756, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"42c5c71e-7d0c-4937-b216-0c7a54c29816"],
Cell[372668, 6758, 271, 7, 22, "SolutionAnswer",ExpressionUUID->"1a8ead39-6436-42ed-acd5-7421e9451103",
 CellID->586605357],
Cell[CellGroupData[{
Cell[372964, 6769, 504, 15, 44, "ExerciseInput",ExpressionUUID->"1af274e0-f3e0-4238-bd2c-343e788960ff",
 CellID->66966085],
Cell[373471, 6786, 110, 1, 28, "ExerciseOutput",ExpressionUUID->"60a426ac-36c2-4d48-b881-692c36906f95",
 CellID->23831387]
}, Open  ]],
Cell[373596, 6790, 760, 21, 43, "SolutionAnswer",ExpressionUUID->"83456228-33f7-446e-8a05-e2374ac759d3",
 CellID->154471713],
Cell[CellGroupData[{
Cell[374381, 6815, 634, 19, 45, "ExerciseInput",ExpressionUUID->"bf412d0b-0115-40ac-9028-eaddd37f54a4",
 CellID->31012],
Cell[375018, 6836, 114, 1, 28, "ExerciseOutput",ExpressionUUID->"0addb1cc-3406-4769-8e15-ddc0d40d8915",
 CellID->295116169]
}, Open  ]]
}, Closed]],
Cell[375159, 6841, 737, 21, 44, "Exercise",ExpressionUUID->"48a16975-bd32-4cbb-844d-49e0151e8473",
 CellID->5684919],
Cell[CellGroupData[{
Cell[375921, 6866, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"5bc6b470-b987-4d2d-bf5d-29ebc0314607"],
Cell[376015, 6868, 271, 7, 22, "SolutionAnswer",ExpressionUUID->"b6f32d59-80cd-4461-a128-bac02ce8aa4d",
 CellID->414225805],
Cell[CellGroupData[{
Cell[376311, 6879, 545, 16, 44, "ExerciseInput",ExpressionUUID->"f40603f3-b6a4-4b63-a58e-a08e2e96754d",
 CellID->505486761],
Cell[376859, 6897, 107, 1, 28, "ExerciseOutput",ExpressionUUID->"fd350a7f-ffd2-4b7a-9fdf-1458a708d514",
 CellID->24700]
}, Open  ]],
Cell[376981, 6901, 814, 23, 43, "SolutionAnswer",ExpressionUUID->"935d6a36-4af2-4e2f-95b9-d0dfa557139e",
 CellID->652843586],
Cell[CellGroupData[{
Cell[377820, 6928, 682, 21, 45, "ExerciseInput",ExpressionUUID->"008dc32d-39b9-43d5-97a6-f87523554b0f",
 CellID->188123579],
Cell[378505, 6951, 113, 1, 28, "ExerciseOutput",ExpressionUUID->"4f63418d-d482-44fb-b8e3-f51ab2b2d922",
 CellID->48588571]
}, Open  ]]
}, Closed]],
Cell[378645, 6956, 671, 21, 25, "Exercise",ExpressionUUID->"543b8e1e-3c5e-4cae-a4ac-0462fcc9aefa",
 CellID->357501273],
Cell[CellGroupData[{
Cell[379341, 6981, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"d38d2dc2-e373-4357-b6fa-142c1a2a15f8"],
Cell[379435, 6983, 126, 1, 22, "SolutionAnswer",ExpressionUUID->"2e865112-bf83-40dc-a1f6-6333f97ab643",
 CellID->449548618],
Cell[CellGroupData[{
Cell[379586, 6988, 260, 7, 25, "ExerciseInput",ExpressionUUID->"30b845ce-430a-4d68-ae1e-e14b1b88432b",
 CellID->74876164],
Cell[379849, 6997, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"ce8ee69b-960a-4213-8567-327a86254836",
 CellID->414351898]
}, Open  ]],
Cell[379975, 7001, 144, 1, 22, "SolutionAnswer",ExpressionUUID->"31a8cfe2-2082-4ccc-bb3c-652f3d444e8d",
 CellID->641308473]
}, Closed]],
Cell[380134, 7005, 733, 23, 25, "Exercise",ExpressionUUID->"e9779311-48af-4064-a7cf-3f7cbd7e7a0d",
 CellID->776810],
Cell[CellGroupData[{
Cell[380892, 7032, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"5796105c-4f28-4477-9f18-723637006443"],
Cell[380986, 7034, 432, 11, 22, "SolutionAnswer",ExpressionUUID->"34da0954-2cef-4166-8425-2220d9c96524",
 CellID->164326409],
Cell[CellGroupData[{
Cell[381443, 7049, 840, 26, 65, "ExerciseInput",ExpressionUUID->"2e1eb1db-263d-4ce4-9436-799be26d128d",
 CellID->659017478],
Cell[382286, 7077, 351, 10, 51, "ExerciseOutput",ExpressionUUID->"89afdd26-8421-4be6-bb54-1593987f9d8b",
 CellID->269225039]
}, Open  ]],
Cell[382652, 7090, 379, 9, 22, "SolutionAnswer",ExpressionUUID->"b38b9e06-129b-46af-b638-002b6b569deb",
 CellID->199399482]
}, Closed]],
Cell[CellGroupData[{
Cell[383068, 7104, 171, 3, 25, "Exercise",ExpressionUUID->"241cb1d8-84eb-4cd3-a634-d6acea4d04fd",
 CellID->109085738],
Cell[CellGroupData[{
Cell[383264, 7111, 741, 21, 70, "ExerciseInput",ExpressionUUID->"7e773fbd-1d1b-4379-bc48-bde05c24b326",
 CellID->538158037],
Cell[384008, 7134, 87503, 1433, 172, "ExerciseOutput",ExpressionUUID->"ae0b8967-fa69-4ac1-aa33-5be0a0fd8d84",
 CellID->33107683]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[471557, 8573, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"c787724d-c579-4e8b-be6a-f2abd91b6189"],
Cell[471651, 8575, 156, 2, 22, "SolutionAnswer",ExpressionUUID->"e875f31c-2b99-4a5f-80de-745c0cad26ad",
 CellID->11015911]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[471858, 8583, 309, 6, 135, "SmallText",ExpressionUUID->"95036642-45f2-41c9-a041-6762a557632e",
 CellGroupingRules->"SectionGrouping",
 CellID->656831372]
}
]
*)

(* NotebookSignature WTGpyh#h9w3nviYj52nUEaRC *)
