(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    611301,      12007]
NotebookOptionsPosition[    427817,       8245]
NotebookOutlinePosition[    590595,      11627]
CellTagsIndexPosition[    590552,      11624]
WindowTitle->19. Power Series | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Power Series"
}], "Section",
 CounterAssignments->{{"Section", 18}},
 CellID->242913651,ExpressionUUID->"3cf14fb2-5955-4f1b-b9b6-8d58c050c498"],

Cell["\<\
This chapter reviews the concept of series and the special case of the power \
series, which you may be familiar with from real analysis. The concept of \
convergence of a series and two convergence tests will be reviewed.\
\>", "Text",
 CellID->120437334,ExpressionUUID->"6559eb98-31e1-4c9f-ae56-e0c14bcd3fa0"],

Cell[CellGroupData[{

Cell["Definition and Convergence of Power Series", "Subsection",
 CellID->1174694,ExpressionUUID->"a5d6bcea-f781-4f64-9d0e-a20fd7bd5dc0"],

Cell[TextData[{
 "A ",
 StyleBox["series",
  FontSlant->"Italic"],
 " is the infinite sum"
}], "Text",
 CellID->614331527,ExpressionUUID->"20c38cfd-9808-40d4-89cf-36bac6e84953"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["c", "0"], "+", 
    SubscriptBox["c", "1"], "+", 
    SubscriptBox["c", "2"], "+", "\[Ellipsis]"}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    RowBox[{
     SubscriptBox["c", "n"], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->519506942,ExpressionUUID->"799581a6-8458-4a7c-ace7-fb46c73c6da4"],

Cell["The quantities", "Text",
 CellID->111014305,ExpressionUUID->"42637813-ec49-4cf8-b110-1028b30dc450"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["s", "n"], "=", 
   RowBox[{
    SubscriptBox["c", "0"], "+", 
    SubscriptBox["c", "1"], "+", "\[Ellipsis]", "+", 
    SubscriptBox["c", "n"]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->188011201,ExpressionUUID->"3f643bef-4f09-4270-bb30-65041a0fad03"],

Cell[TextData[{
 "are called the ",
 StyleBox["partial sums",
  FontSlant->"Italic"],
 " of the series."
}], "Text",
 CellID->310688234,ExpressionUUID->"85b67bdb-b0b4-4002-b75c-c08ecf96fb0b"],

Cell[TextData[{
 "A series is said to be ",
 StyleBox["convergent",
  FontSlant->"Italic"],
 " to ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "4d90211e-391e-44ed-b06f-c42404a79ebc"],
 " if"
}], "Text",
 CellID->83437834,ExpressionUUID->"06200104-74d7-4af4-a7a7-29e641c72bc0"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["lim", 
     RowBox[{"n", "->", "\[Infinity]"}]], 
    SubscriptBox["s", "n"]}], "=", 
   RowBox[{"C", "."}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->474767335,ExpressionUUID->"d16e14db-ecc5-419d-9dfa-4503b6e5bc9d"],

Cell[TextData[{
 "It is ",
 StyleBox["absolutely convergent",
  FontSlant->"Italic"],
 " if"
}], "Text",
 CellID->370813329,ExpressionUUID->"27e34c0d-82a1-4892-b989-12b43787be15"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"|", 
    SubscriptBox["c", "0"], "|", 
    RowBox[{"+", 
     RowBox[{"|", 
      SubscriptBox["c", "1"], "|", 
      RowBox[{"+", 
       RowBox[{"|", 
        SubscriptBox["c", "2"], "|", 
        RowBox[{"+", "\[Ellipsis]"}]}]}]}]}]}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    RowBox[{"|", 
     SubscriptBox["c", "n"], "|"}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->3683173,ExpressionUUID->"f74ddae1-cb1b-489e-8f10-28ecbd237ba5"],

Cell["\<\
is convergent. Of course, an absolutely convergent series is also convergent.\
\
\>", "Text",
 CellID->216447349,ExpressionUUID->"b9671b91-1294-49c7-bf41-efbb36d3ec6e"],

Cell[TextData[{
 "A ",
 StyleBox["power series",
  FontSlant->"Italic"],
 " is a special case of series: it is a function of the form"
}], "Text",
 CellID->183249523,ExpressionUUID->"66ad7beb-fc15-453e-b13b-3c14a17de874"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "0"], "+", 
     RowBox[{
      SubscriptBox["a", "1"], 
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}]}], "+", 
     SuperscriptBox[
      RowBox[{
       SubscriptBox["a", "2"], "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "2"], "+", "\[Ellipsis]"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{
        SubscriptBox["a", "n"], "(", 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}], ")"}], "n"], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->37793012,ExpressionUUID->"a817ea82-eb4b-43cd-9a10-822551b03d1c"],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], ",", "z", ",", 
    RowBox[{
     SubscriptBox["z", "0"], "\[Element]", "\[DoubleStruckCapitalC]"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "6023ac2a-2f64-4b0e-9288-d8e82785d0ce"],
 ". The numbers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "39b2e6f8-9aec-44c6-bade-eddf4dd5d93a"],
 " are called the ",
 StyleBox["coefficients",
  FontSlant->"Italic"],
 " of the power series."
}], "Text",
 CellID->68680460,ExpressionUUID->"49e17a6b-109e-4a16-a3b1-f6b6df3dcaae"],

Cell["\<\
It is useful to investigate when a power series is convergent or not. The \
convergence of a power series turns out to have a straightforward behavior:\
\>", "Text",
 CellID->496433365,ExpressionUUID->"28947aad-0372-4fa1-910a-b3b811c5509a"],

Cell[TextData[{
 "Theorem:",
 " For every power series, there is a real number ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "46bfc637-0a25-4147-bd87-6f5c35c59396"],
 " called ",
 StyleBox["radius of convergence",
  FontSlant->"Italic"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "<=", "R", "<=", "\[Infinity]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"022df42d-3976-471b-a748-b2998386e96d"],
 ", such that:"
}], "Text",
 CellChangeTimes->{3.9640854976217527`*^9},
 CellID->232797302,ExpressionUUID->"4389e203-b0dc-43ad-8135-5c15e3106d27"],

Cell[TextData[{
 "1. The series is absolutely convergent inside the disk ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ad4b1af2-1ef3-0b44-994b-d75a75ef6183"],
 "."
}], "Text",
 CellID->350152096,ExpressionUUID->"a86a2342-5357-f246-94e9-318ae6f5640f"],

Cell[TextData[{
 "2. The series is divergent for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", " ", 
    RowBox[{">", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6bb28edd-dfb2-614b-98d2-e4dfc661a883"],
 "."
}], "Text",
 CellID->151878190,ExpressionUUID->"14c522bf-8b0c-9540-9ea9-92ed93812f72"],

Cell[TextData[{
 "3. The behavior of the series in the circle ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], "|"}], "=", "R"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"5a1cfa33-4d67-594e-9dd4-4a710bebd8ab"],
 " cannot be predicted a priori and must be examined on a case-by-case \
basis."
}], "Text",
 CellID->111653247,ExpressionUUID->"7045bcf3-ccd5-8845-bde0-b9aa85c9ddf7"],

Cell[TextData[{
 "4. In ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ac87633c-9f55-814b-b253-22cf13481336"],
 ", the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e4dc1d3a-4daf-e248-a1eb-3530f07ede63"],
 " is analytic. Its derivative can be obtained by differentiating term by \
term and has the same radius of convergence."
}], "Text",
 CellID->90341842,ExpressionUUID->"63492602-77cb-6341-bb65-0a08f0748180"],

Cell["We won\[CloseCurlyQuote]t prove the theorem.", "Text",
 CellID->150934655,ExpressionUUID->"6e217b20-4978-42ac-8c02-bf7bf4278248"],

Cell[TextData[{
 "Fig. 1 depicts the general behavior of a power series. It is convergent \
inside a disk of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "00da2a1e-88a7-cd40-a3d2-bd3a2921e888"],
 " centered at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7eb84f5f-6017-bd41-8d72-8e821df7b02c"],
 " and divergent outside of it. Its behavior on the border depends from case \
to case."
}], "Text",
 CellID->216404728,ExpressionUUID->"38c53596-ad58-e04d-8f68-fa67418bcdcb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"Null", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
        RowBox[{"AxesLabel", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Re(z)\>\"", ",", "12"}], "]"}], ",", 
           RowBox[{"Style", "[", 
            RowBox[{"\"\<Im(z)\>\"", ",", "12"}], "]"}]}], "}"}]}], ",", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
        RowBox[{"Ticks", "->", "None"}], ",", 
        RowBox[{"Axes", "->", "None"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{"LightBlue", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"7", "/", "4"}]}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"RegionPlot", "[", 
       RowBox[{
        RowBox[{"RegionDifference", "[", 
         RowBox[{
          RowBox[{"Rectangle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3"}], ",", 
              RowBox[{"-", "3"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", 
              RowBox[{"1", "/", "2"}]}], "}"}], ",", 
            RowBox[{"7", "/", "4"}]}], "]"}]}], "]"}], ",", 
        RowBox[{"PlotStyle", "->", "LightPink"}], ",", 
        RowBox[{"BoundaryStyle", "->", "None"}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Blue", ",", "Dashed", ",", 
           RowBox[{"Circle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "2"}], ",", 
               RowBox[{"1", "/", "2"}]}], "}"}], ",", 
             RowBox[{"7", "/", "4"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<convergent\>\"", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", "/", "4"}], ",", 
             RowBox[{"3", "/", "2"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<divergent\>\"", ",", "12"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"-", "3"}], "/", "2"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Point", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", 
              RowBox[{"1", "/", "2"}]}], "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"z\", \"0\"], \
TraditionalForm]],ExpressionUUID->\"77614918-045e-45ab-905d-321ba135642c\"]],\
ExpressionUUID->\"e0dd8013-b198-4e2c-8f99-99136ec0caa0\"]\)\>\"", ",", "12"}],
             "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "/", "2"}], ",", 
             RowBox[{"1", "/", "2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", 
              RowBox[{"1", "/", "2"}]}], "}"}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "2"}], ",", 
               RowBox[{"1", "/", "2"}]}], "}"}], "+", 
             RowBox[{
              RowBox[{"7", "/", "4"}], 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"\[Pi]", "/", "6"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"\[Pi]", "/", "6"}], "]"}]}], "}"}]}]}]}], "}"}], 
          "]"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            
            RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"R\", \
TraditionalForm]],ExpressionUUID->\"51b304cb-d128-4a65-9186-a2ab617a6e3a\"]],\
ExpressionUUID->\"76a39157-c5dd-4b84-8eb4-74c35c4a8600\"]\)\>\"", ",", "12"}],
             "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"3", "/", "2"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], "}"}], 
    ",", 
    RowBox[{"ImageSize", "->", "200"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{
     "Text", "[", "\"\<Fig. 1. Region of convergence of a power series.\>\"", 
      "]"}]}], "]"}], "&"}]}]], "Input",
 CellID->1284592672,ExpressionUUID->"8c058cfe-2ea4-4637-b03b-d86f3371f893"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, 
       {RGBColor[0.87, 0.94, 1], 
        DiskBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
         1.75]}, {GraphicsComplexBox[CompressedData["
1:eJyFenk8lF/Y/mykEkqkkiQJbbRTOU+JtKAoLVSibEVCkSS0KaWoRDtlCckS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         "], {
          {RGBColor[1, 0.925, 0.925], AbsoluteThickness[2.], Opacity[1], 
           EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxN23n8plP5B/DzPCZCQsqSZTDWlG3sS8a+j7EniWFIZBn72I3B2Lch+1rI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             "]]]}, {}, {}, {}, {}}], {}}, {
        {RGBColor[0, 0, 1], Dashing[{Small, Small}], 
         CircleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
          1.75]}, InsetBox[
         StyleBox["\<\"convergent\"\>",
          StripOnInput->False,
          FontSize->12], 
         NCache[{Rational[3, 4], Rational[3, 2]}, {0.75, 1.5}]], InsetBox[
         StyleBox["\<\"divergent\"\>",
          StripOnInput->False,
          FontSize->12], 
         NCache[{Rational[-3, 2], Rational[-3, 2]}, {-1.5, -1.5}]], 
        {PointSize[0.01], 
         PointBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}, 
        InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\
nSubscriptBox[\\\"z\\\", \\\"0\\\"], TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}],
          ImageScaled[{1, 1}]], 
        LineBox[NCache[{{Rational[1, 2], Rational[1, 2]}, {
           Rational[1, 2] + Rational[7, 8] 3^Rational[1, 2], Rational[
            11, 8]}}, {{0.5, 0.5}, {2.0155444566227674`, 1.375}}]], InsetBox[
         StyleBox["\<\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"R\\\", \
TraditionalForm]]]]]\\)\"\>",
          StripOnInput->False,
          FontSize->12], NCache[{Rational[3, 2], 1}, {1.5, 1}], NCache[
         ImageScaled[{1, Rational[3, 2]}], ImageScaled[{1, 1.5}]]]}},
      Axes->{False, False},
      AxesLabel->{
        FormBox[
         TagBox[
          StyleBox["\"Re(z)\"", 12, StripOnInput -> False], HoldForm], 
         TraditionalForm], 
        FormBox[
         TagBox[
          StyleBox["\"Im(z)\"", 12, StripOnInput -> False], HoldForm], 
         TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->200,
      Method->{
       "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
        None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            (Identity[#]& )[
             Part[#, 1]], 
            (Identity[#]& )[
             Part[#, 2]]}& )}},
      PlotRange->{{-3., 3.}, {-3., 3.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{}, {}}]},
    {"\<\"Fig. 1. Region of convergence of a power series.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->996579375,ExpressionUUID->"90cfc5c6-2aad-4606-995c-2e9c139e6b72"]
}, {2}]],

Cell[TextData[{
 "In Wolfram Language, convergence conditions are available from the command ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->204429578,ExpressionUUID->"b0199fce-2b0a-4ac4-ae9b-e238c73d0b20"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->194277603,ExpressionUUID->"f46f9908-d31b-40a1-8f7e-cf8d1ed58b1b"],

Cell[TextData[{
 "An important special case of power series is the ",
 StyleBox["geometric series",
  FontSlant->"Italic"],
 ", which is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "n"], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e436fa76-d34e-4303-b666-f72b5f46a161"],
 ":"
}], "SolvedExampleNote",
 CellID->31915663,ExpressionUUID->"7269adc8-09fb-4fcb-9a48-d633e54c1eeb"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"01cead2d-5ce3-40d8-89e8-6ae25f5d4fbc"],
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"], "+", 
    SuperscriptBox["z", "3"], "+", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8f761f7f-5b97-4e16-9e06-4c50714b45f4"]
}], "SolvedExampleNote",
 CellID->23017979,ExpressionUUID->"95f9f09f-ce27-4e08-8a8a-ada264db49c5"],

Cell["whose partial sums are", "SolvedExampleNote",
 CellID->36566290,ExpressionUUID->"cfc56f41-4b4b-4e3a-9113-3729c3fbbce9"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"185e97f9-9075-4440-b6c5-aad8bb4e65e6"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "+", "z", "+", 
     SuperscriptBox["z", "2"], "+", "\[Ellipsis]", "+", 
     SuperscriptBox["z", 
      RowBox[{"n", "-", "1"}]]}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       SuperscriptBox["z", "n"]}], 
      RowBox[{"1", "-", "z"}]], "."}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7f12a972-749b-47bb-b537-1dc7fbb7692e"]
}], "SolvedExampleNote",
 CellID->43637267,ExpressionUUID->"f67dc5c0-299d-4bef-998a-d8dfd0e2cf4a"],

Cell["Therefore, the geometric series converges to", "SolvedExampleNote",
 CellID->121691467,ExpressionUUID->"e2a4942d-a22e-4565-bac7-52653ff5f71b"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"61e801d2-d15c-4916-b2f6-69e11af18c40"],
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    RowBox[{"1", "-", "z"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "da462788-30ff-4388-bb21-6195f5fa8052"]
}], "SolvedExampleNote",
 CellID->199923384,ExpressionUUID->"61d5e3cf-4aaa-406f-aa61-45bf469e453f"],

Cell[TextData[{
 "for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3d92d62f-b651-4c74-9526-b838b3373af8"],
 " and diverges for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">=", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d617f198-06ea-4523-a935-28791e49425c"],
 ". So its radius of convergence is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c1d32b6e-4802-457b-be6c-7dc8c1dd5391"],
 "."
}], "SolvedExampleNote",
 CellID->19139663,ExpressionUUID->"c4a7dad1-c7d8-46b3-8c34-fb7c40e25aa2"],

Cell[TextData[{
 "Check with ",
 ButtonBox["Sum",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->301148254,ExpressionUUID->"67b48d37-d0cb-4b12-99c7-e972536943ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"z", "^", "k"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->54367541,ExpressionUUID->"6dd9dc0d-7507-477f-ac45-7dd4dc46b4ab"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["z", 
    RowBox[{"1", "+", "n"}]]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "z"}]]], "SolvedExampleOutput",
 CellID->221600778,ExpressionUUID->"d301a29c-c030-4c6a-82f1-01adcbb61a2f"]
}, Open  ]],

Cell["and:", "SolvedExampleNote",
 CellID->95343,ExpressionUUID->"fd1a4f20-5c22-4775-a64b-06a604e473ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"z", "^", "k"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->77089032,ExpressionUUID->"366905d0-c8fa-46dd-8aff-ad9aa2b5555f"],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "-", "z"}]]], "SolvedExampleOutput",
 CellID->115989526,ExpressionUUID->"c3912167-f941-4b5b-82a3-a81cef8d8d5f"]
}, Open  ]],

Cell[TextData[{
 "Get the conditions for convergence of the series using ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->400301595,ExpressionUUID->"670a1323-79cf-4fe7-8388-ee1bea05bc3d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{"z", "^", "k"}], ",", "k"}], "]"}]], "SolvedExampleInput",
 CellID->326987186,ExpressionUUID->"16732078-aa5e-48db-9601-19d4aa12ebd8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]], "SolvedExampleOutput",
 CellID->185847010,ExpressionUUID->"b3db5507-a24a-4838-96ab-77a6707b574f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"cbfa91bc-67f7-4f67-89fe-fd9a173880aa"],

Cell[TextData[{
 "In addition to the geometric series of ",
 ButtonBox["Example 18.1",
  BaseStyle->"Hyperlink",
  ButtonFunction:>
   NotebookLocate[{
    "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", "Example181"}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]],
 ", you have already encountered other series, namely the exponential, the \
sine and the cosine functions, defined respectively as:"
}], "Text",
 CellChangeTimes->{{3.968834509197134*^9, 3.968834509700926*^9}, 
   3.973001104102285*^9, {3.973001163223854*^9, 3.973001164359544*^9}},
 CellID->245460964,ExpressionUUID->"cc97d093-6d29-493f-8ecd-7b5e1ef45b7d"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "z"], "\[AlignmentMarker]", "=", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
          RowBox[{"n", "=", "0"}]}], 
         RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
        FractionBox[
         SuperscriptBox["z", "n"], 
         RowBox[{"n", "!"}]]}]}], ","}]},
    {
     RowBox[{
      RowBox[{
       RowBox[{"sin", "(", "z", ")"}], "\[AlignmentMarker]", "=", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
          RowBox[{"n", "=", "0"}]}], 
         RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "n"], 
          SuperscriptBox["z", 
           RowBox[{
            RowBox[{"2", "n"}], "+", "1"}]]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "n"}], "+", "1"}], ")"}], "!"}]]}]}], ","}]},
    {
     RowBox[{
      RowBox[{"cos", "(", "z", ")"}], "\[AlignmentMarker]", "=", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "n"], 
          SuperscriptBox["z", 
           RowBox[{"2", "n"}]]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "n"}], ")"}], "!"}]], "."}]}]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{"\[AlignmentMarker]"}}, "Rows" -> {{Baseline}}}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->4095132,ExpressionUUID->"9a847823-49ac-43c4-8905-3c343c7e1852"],

Cell["\<\
These three functions have an infinite radius of convergence.\
\>", "Text",
 CellID->5776323,ExpressionUUID->"cf0b646e-14f6-4f91-b46a-dbfeeaebcab4"],

Cell["\<\
In Fig. 2, you can visualize how these series behave as more and more terms \
are added to the partial sums.\
\>", "Text",
 CellID->97649586,ExpressionUUID->"af15e12d-6ecb-4d1f-a708-3c96e5d9cc3b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"func", ",", "zp", ",", "arrow", ",", "z"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"func", "[", 
    RowBox[{"f_", ",", "x_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "===", "\"\<geometric\>\""}], ",", 
     RowBox[{"NSum", "[", 
      RowBox[{
       RowBox[{"x", "^", "k"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"f", "===", "\"\<exp\>\""}], ",", 
     RowBox[{"NSum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "k"}], "/", 
        RowBox[{"k", "!"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"f", "===", "\"\<sin\>\""}], ",", 
     RowBox[{"NSum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", "k"}], "*", 
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "k"}], "+", "1"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "k"}], "+", "1"}], ")"}], "!"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"f", "===", "\"\<cos\>\""}], ",", 
     RowBox[{"NSum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", "k"}], "*", 
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"2", "k"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "k"}], ")"}], "!"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"zp", "=", 
      RowBox[{
       RowBox[{"zz", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", 
       RowBox[{"I", "*", 
        RowBox[{"zz", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"arrow", "=", 
      RowBox[{"Arrow", "[", 
       RowBox[{"Prepend", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"ReIm", "[", 
            RowBox[{"func", "[", 
             RowBox[{"function", ",", "zp", ",", "k"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "1", ",", "N"}], "}"}]}], "]"}], ",", "zz"}], 
        "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"Null", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "z", "]"}], ",", 
          RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
       RowBox[{"AxesStyle", "\[Rule]", 
        RowBox[{"Directive", "[", "12", "]"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"function", "===", "\"\<geometric\>\""}], ",", 
            RowBox[{"{", 
             RowBox[{"Dashed", ",", 
              RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
            RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Point", "[", "zz", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"z", ",", "12"}], "]"}], ",", "zz", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Point", "[", 
           RowBox[{"ReIm", "[", 
            RowBox[{"func", "[", 
             RowBox[{"function", ",", "zp", ",", "N"}], "]"}], "]"}], "]"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"z", ",", "12"}], "]"}], ",", "zz", ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"Red", ",", "arrow"}], "}"}]}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}], 
    "\[IndentingNewLine]", ",", 
    RowBox[{"{", 
     RowBox[{"function", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<geometric\>\"", ",", "\"\<exp\>\"", ",", "\"\<sin\>\"", 
        ",", "\"\<cos\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"zz", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", 
          RowBox[{"1", "/", "2"}]}], "}"}], ",", 
        RowBox[{"ToString", "[", 
         RowBox[{"z", ",", "TraditionalForm"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"N", ",", "5"}], "}"}], ",", "1", ",", "15", ",", "1"}], "}"}],
     "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{
     "Text", "[", "\"\<Fig. 2. Convergence or divergence of series as more \
terms are added.\>\"", "]"}]}], "]"}], "&"}]}]}], "Input",
 CellID->453742080,ExpressionUUID->"968c9b6f-68fd-498e-8b90-281c578cd3f8"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`function$$ = 
        "geometric", $CellContext`N$$ = 5, $CellContext`zz$$ = {
         Rational[1, 2], 
         Rational[1, 2]}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
        Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, 
        Typeset`animvar$$ = 1, Typeset`name$$ = "\"untitled\"", 
        Typeset`specs$$ = {{
          Hold[$CellContext`function$$], {"geometric", "exp", "sin", "cos"}, 
          ControlType -> SetterBar}, {{
           Hold[$CellContext`zz$$], {
            Rational[1, 2], 
            Rational[1, 2]}, 
           "\!\(\*FormBox[\"z\", TraditionalForm]\)"}, {-2, -2}, {2, 2}, 
          ControlType -> Slider2D}, {{
           Hold[$CellContext`N$$], 5}, 1, 15, 1, ControlType -> Manipulator}},
         Typeset`size$$ = {240., {107.13997395833333`, 114.37239583333333`}}, 
        Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        False, Typeset`keyframeActionsQ$$ = False, 
        Typeset`keyframeList$$ = {}}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, 
          "Variables" :> {$CellContext`function$$ = 
            "geometric", $CellContext`N$$ = 5, $CellContext`zz$$ = {
              Rational[1, 2], 
              Rational[1, 2]}}, "ControllerVariables" :> {}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$, 
            Typeset`keyframeActionsQ$$, Typeset`keyframeList$$}, 
          "Body" :> ($CellContext`zp = 
            Part[$CellContext`zz$$, 1] + 
             I Part[$CellContext`zz$$, 2]; $CellContext`arrow = Arrow[
              Prepend[
               Table[
                ReIm[
                 $CellContext`func[$CellContext`function$$, $CellContext`zp, \
$CellContext`k]], {$CellContext`k, 1, $CellContext`N$$}], $CellContext`zz$$]]; 
           Graphics[{
              If[$CellContext`function$$ === "geometric", {Dashed, 
                Circle[]}, {}], 
              Point[$CellContext`zz$$], 
              Text[
               Style[$CellContext`z, 12], $CellContext`zz$$, {1, 1}], 
              Point[
               ReIm[
                $CellContext`func[$CellContext`function$$, $CellContext`zp, \
$CellContext`N$$]]], 
              Text[
               Style[$CellContext`z, 12], $CellContext`zz$$, {1, 1}], {
              Red, $CellContext`arrow}}, Axes -> True, 
             PlotRange -> {{-3, 3}, {-3, 3}}, AspectRatio -> Automatic, 
             AxesLabel -> {
               Re[$CellContext`z], 
               Im[$CellContext`z]}, AxesStyle -> Directive[12]]), 
          "Specifications" :> {{$CellContext`function$$, {
             "geometric", "exp", "sin", "cos"}}, {{$CellContext`zz$$, {
               Rational[1, 2], 
               Rational[1, 2]}, 
              "\!\(\*FormBox[\"z\", TraditionalForm]\)"}, {-2, -2}, {2, 
             2}}, {{$CellContext`N$$, 5}, 1, 15, 1}}, "Options" :> {}, 
          "DefaultOptions" :> {}],
         ImageSizeCache->{290.5, {212.03977864583334`, 219.27220052083334`}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        Initialization:>($CellContext`func[
            Pattern[$CellContext`f, 
             Blank[]], 
            Pattern[$CellContext`x, 
             Blank[]], 
            Pattern[$CellContext`n, 
             Blank[]]] := Which[$CellContext`f === "geometric", 
            
            NSum[$CellContext`x^$CellContext`k, {$CellContext`k, 
              0, $CellContext`n}], $CellContext`f === "exp", 
            
            NSum[$CellContext`x^$CellContext`k/
             Factorial[$CellContext`k], {$CellContext`k, 
              0, $CellContext`n}], $CellContext`f === "sin", 
            
            NSum[(-1)^$CellContext`k ($CellContext`x^(2 $CellContext`k + 1)/
              Factorial[2 $CellContext`k + 1]), {$CellContext`k, 
              0, $CellContext`n}], $CellContext`f === "cos", 
            
            NSum[(-1)^$CellContext`k ($CellContext`x^(2 $CellContext`k)/
              Factorial[2 $CellContext`k]), {$CellContext`k, 
              0, $CellContext`n}]]; Typeset`initDone$$ = True),
        SynchronousInitialization->True,
        UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {"\<\"Fig. 2. Convergence or divergence of series as more terms are \
added.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->465123820,ExpressionUUID->"ffdb1af4-208d-43fa-970a-033198181e09"]
}, {2}]],

Cell["\<\
Because complex addition can be viewed as vector addition, one can plot the \
various terms in the series as back-to-back vectors. When the series is \
convergent, these vectors spiral into the value of the series, as you can see \
by moving the slider in Fig. 2.\
\>", "Text",
 CellID->219531818,ExpressionUUID->"504524d0-e461-496b-80b9-1db608aafd09"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Convergence Tests", "Subsection",
 CellID->510115987,ExpressionUUID->"975e6d71-f464-4e06-9a67-5ca7d489bc0a"],

Cell["\<\
Given a series, two tests can be used in order to establish its convergence \
properties and, in the case of power series, to find the radius of \
convergence.\
\>", "Text",
 CellID->642972206,ExpressionUUID->"18fe53c5-94db-4675-8061-d021c6844f14"],

Cell[CellGroupData[{

Cell["Ratio Test", "Subsubsection",
 CellID->40632655,ExpressionUUID->"8a3d7a57-d9a6-4a98-8dfb-799239b0aca2"],

Cell["The ratio test states that, for a series", "Text",
 CellID->443889050,ExpressionUUID->"04ebe247-f702-4e3e-89cf-c8a6ef31803e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["c", "0"], "+", 
    SubscriptBox["c", "1"], "+", 
    SubscriptBox["c", "2"], "+", "\[Ellipsis]"}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    SubscriptBox["c", "n"]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->186328943,ExpressionUUID->"ea1ec447-3ead-4163-bc0d-dfc86c2d9d7d"],

Cell[TextData[{
 "if the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      FractionBox[
       SubscriptBox["c", 
        RowBox[{"n", "+", "1"}]], 
       SubscriptBox["c", "n"]], "|"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fb3d70a8-6172-4007-b228-ef5937a3b4ea"],
 " exists, then:"
}], "Text",
 CellID->1471017497,ExpressionUUID->"4c474523-b4fa-4deb-a25f-80a815605b59"],

Cell[TextData[{
 "1. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "<", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c19aeb43-d022-4c06-88e0-c47e37e9a8bd"],
 ", the series is absolutely convergent."
}], "Text",
 CellID->211267330,ExpressionUUID->"71d0e53c-e48f-46ac-84d5-d6e36604dfbe"],

Cell[TextData[{
 "2. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", ">", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f8ba3378-d433-4167-8f6a-d28d6b39199e"],
 ", the series is divergent."
}], "Text",
 CellID->12722605,ExpressionUUID->"3717e750-44f0-4995-9122-005aee28b9ae"],

Cell[TextData[{
 "3. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "04c1aa13-5721-4d25-8506-1c4e2d670be1"],
 ", the test is inconclusive."
}], "Text",
 CellID->343519956,ExpressionUUID->"f0920527-14d6-416e-a2fe-95cf3ceae72b"],

Cell["\<\
In practice, the test often helps to compute the radius of convergence of a \
power series.\
\>", "Text",
 CellID->311763549,ExpressionUUID->"58c32fa9-146f-42d7-8e56-f40df9ad6fe6"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->203404213,ExpressionUUID->"385982d5-8b04-4f64-9605-b306a72cfdb0"],

Cell["Apply the ratio test to the geometric series:", "SolvedExampleNote",
 CellID->382612225,ExpressionUUID->"f2fbf1e9-733e-4874-890b-6667840b6bc5"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"98376fc0-1ffc-48ee-af01-0e1e4998b2e1"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       FractionBox[
        SubscriptBox["c", 
         RowBox[{"n", "+", "1"}]], 
        SubscriptBox["c", "n"]], "|"}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"n", "->", "\[Infinity]"}]], 
       RowBox[{"|", 
        FractionBox[
         SuperscriptBox["z", 
          RowBox[{"n", "+", "1"}]], 
         SuperscriptBox["z", "n"]], "|"}]}], "=", 
      RowBox[{
       RowBox[{
        SubscriptBox["lim", 
         RowBox[{"n", "->", "\[Infinity]"}]], 
        RowBox[{"|", "z", "|"}]}], "=", 
       RowBox[{"|", "z", "|"}]}]}]}], ","}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"51ba78c3-0eca-485f-b6d4-6a03c6be1450"]
}], "SolvedExampleNote",
 CellID->16175874,ExpressionUUID->"a3f2c320-fe08-4b7f-84bc-fa902fb1af62"],

Cell[TextData[{
 "which implies that the geometric series converges for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "cc569a12-b62a-4df4-beba-ab71b7e72367"],
 ". This proves that the radius of convergence of the geometric series is 1."
}], "SolvedExampleNote",
 CellID->153109261,ExpressionUUID->"13ab3c10-5fd6-4d35-8279-0e987526c12f"],

Cell[TextData[{
 "With ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ", the ratio test can be requested using the option ",
 ButtonBox["Method",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->446124757,ExpressionUUID->"cb87fc0f-0351-4a46-bd7d-e214a7de21c4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{"z", "^", "k"}], ",", "k", ",", 
   RowBox[{"Method", "->", "\"\<RatioTest\>\""}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->448336427,ExpressionUUID->"2c5b0d29-9e3c-4678-8dbf-7a6b76ba08c7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]], "SolvedExampleOutput",
 CellID->733391596,ExpressionUUID->"e01307d2-3707-4e0d-921a-f61b81362b9f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1564853361,ExpressionUUID->"f65abd6a-358f-49c4-a3de-133ad6b0598e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Root Test", "Subsubsection",
 CellID->663567435,ExpressionUUID->"7365b72c-4647-401d-b2bb-a95e61cad0a6"],

Cell["The root test states that, for a series", "Text",
 CellID->737219293,ExpressionUUID->"0bdd2027-d4dc-4529-9842-45876d9d5fbd"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["c", "0"], "+", 
    SubscriptBox["c", "1"], "+", 
    SubscriptBox["c", "2"], "+", "\[Ellipsis]"}], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"n", "=", "0"}], "\[Infinity]"], 
    SubscriptBox["c", "n"]}]}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->526390522,ExpressionUUID->"9073d57b-690f-4d42-ba3a-3d5ff08492ef"],

Cell[TextData[{
 "if the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      SubscriptBox["c", "n"], 
      OverscriptBox["|", 
       RowBox[{"1", "/", "n"}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7aa63b8e-3185-4e32-82aa-fc0085ae2e9e"],
 " exists, then:"
}], "Text",
 CellID->480524459,ExpressionUUID->"46c5061d-d707-4802-b67d-c82e32c014f8"],

Cell[TextData[{
 "1. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "<", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "805e05d1-f0f9-8b40-842b-347908aa7b55"],
 ", the series is absolutely convergent."
}], "Text",
 CellID->32302646,ExpressionUUID->"e3d8b390-081f-f647-af1e-dc14abe48728"],

Cell[TextData[{
 "2. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", ">", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ad8854de-3b4d-d54b-8463-c17570bf0171"],
 ", the series is divergent."
}], "Text",
 CellID->236336973,ExpressionUUID->"0125e8de-aa17-3249-ba17-61a9d56d079e"],

Cell[TextData[{
 "3. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8cf59e96-8148-b54c-ab25-81f819c3afba"],
 ", the test is inconclusive."
}], "Text",
 CellID->236320815,ExpressionUUID->"5be95e38-c75f-044a-b9d3-841ca0ee15e1"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->511901,ExpressionUUID->"dffa3239-8d83-4523-ab8f-6cab269b8dea"],

Cell["Apply the root test to the geometric series:", "SolvedExampleNote",
 CellID->442206837,ExpressionUUID->"5a1a2578-7275-400a-8fdb-a6b3f75aacb6"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"d11d2cda-930a-4bb7-8183-315747350b5a"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      SuperscriptBox["z", "n"], 
      SuperscriptBox["|", 
       RowBox[{"1", "/", "n"}]]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", "z", "|"}]}], "=", 
     RowBox[{"|", "z", "|", "."}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d1e70bb1-ac07-4b24-b446-f05f5ce2af65"]
}], "SolvedExampleNote",
 CellID->720765755,ExpressionUUID->"d346fc29-2da2-47f2-aa20-1b8a054b4e5a"],

Cell["\<\
Again, this shows that the radius of convergence of the geometric series is 1.\
\>", "SolvedExampleNote",
 CellID->294263374,ExpressionUUID->"20318484-9381-4a61-82a6-76527e407947"],

Cell[TextData[{
 "In ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ", the root test is also available using the option ",
 ButtonBox["Method",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->238100169,ExpressionUUID->"2ed75c43-0a66-46c3-aa7f-3c6a49b4be99"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{"z", "^", "k"}], ",", "k", ",", 
   RowBox[{"Method", "->", "\"\<RootTest\>\""}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->225341602,ExpressionUUID->"7edde848-7c5b-4ad3-aa6d-1291e6df0f16"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]], "SolvedExampleOutput",
 CellID->316064249,ExpressionUUID->"b8297f2c-79d5-495d-9e6e-0292fd951df9"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1215728965,ExpressionUUID->"37de4a02-e988-4cdc-9c26-2b2bdfb19a5e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->268746911,ExpressionUUID->"94028bca-dd18-4fce-b3e9-24cd62d8a600"],

Cell[TextData[{
 "Apply the root test to the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        RowBox[{"2", "n"}], "+", "3"}], 
       RowBox[{
        RowBox[{"5", "n"}], "-", "4"}]], ")"}], "n"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"cbba8968-c41f-4294-b059-953244460893"],
 "."
}], "SolvedExampleNote",
 CellID->2919492,ExpressionUUID->"99a38984-0025-4144-afad-7b9ea0ea7bab"],

Cell[TextData[{
 "Using ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->899508737,ExpressionUUID->"85139266-8d98-442d-8921-e60e9012f6cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       RowBox[{"2", "n"}], "+", "3"}], 
      RowBox[{
       RowBox[{"5", "n"}], "-", "4"}]], ")"}], "n"], ",", "n", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<RootTest\>\""}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->260125112,ExpressionUUID->"87d07b07-2f4d-4d72-82d9-8a0375ce6c7c"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->53118281,ExpressionUUID->"1b92c286-711a-4ff6-a0f0-6d74ff784ab5"]
}, Open  ]],

Cell["The series is convergent.", "SolvedExampleNote",
 CellID->59314548,ExpressionUUID->"7f367a4a-0dc2-4370-8441-d4730123bace"],

Cell["", "SolvedExampleEndCap",
 CellID->515156329,ExpressionUUID->"c34ff345-c8bd-4f79-a8e8-28f1d3b6d987"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection",
 CellID->509614559,ExpressionUUID->"e2a9ad81-c661-400b-b717-9c1c047d224a"],

Cell["\<\
Here are some more examples of how to compute the radius of convergence of \
different series.\
\>", "Text",
 CellID->58553324,ExpressionUUID->"15d59994-306f-45be-940b-a4357309cf09"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->409109291,ExpressionUUID->"f9f32f6b-57cd-4a30-9cbc-a3052e8cc792"],

Cell[TextData[{
 "In ",
 ButtonBox["Chapter 4",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", the exponential function was defined as the series"
}], "SolvedExampleNote",
 CellID->344419435,ExpressionUUID->"ad19b895-0c5f-4a49-af6b-90a4f8f8d72d"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"d7704797-d9db-42c4-ab13-465f20848c75"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "z"], "=", 
    RowBox[{
     RowBox[{"1", "+", "z", "+", 
      FractionBox[
       SuperscriptBox["z", "2"], "2"], "+", 
      FractionBox[
       SuperscriptBox["z", "3"], "3"], "+", "\[Ellipsis]"}], "=", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
      RowBox[{
       FractionBox[
        SuperscriptBox["z", "n"], 
        RowBox[{"n", "!"}]], "."}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f69aecf4-837b-4d52-9b1a-264f166c1622"]
}], "SolvedExampleNote",
 CellID->406179465,ExpressionUUID->"a2b4d549-a92b-4c99-8e30-8e86f713d434"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s use the ratio test to prove that the exponential \
function is an entire function, i.e. analytic on all of ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath",
  ExpressionUUID->"688eebda-8cf5-4091-b5bd-c2cd3c502efc"],
 ":"
}], "SolvedExampleNote",
 CellID->13349720,ExpressionUUID->"800303cd-b28b-4f22-9f13-eca9eb797257"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"2cebfb13-a5e4-4bba-a3ab-a38aa9357ae2"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      RowBox[{
       FractionBox[
        SuperscriptBox["z", 
         RowBox[{"n", "+", "1"}]], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "!"}]], "/", 
       FractionBox[
        SuperscriptBox["z", "n"], 
        RowBox[{"n", "!"}]]}], "|"}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       FractionBox["z", "n"], "|"}]}], "=", "0."}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8725147a-3096-4dee-8e76-8b36fa692477"]
}], "SolvedExampleNote",
 CellID->24230206,ExpressionUUID->"c212026a-3a20-40a1-905d-53ddde8dec82"],

Cell[TextData[{
 "With ",
 ButtonBox["Limit",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->17861973,ExpressionUUID->"41902bea-bbfe-41dd-90d4-6c9b8b5689b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"z", "/", "n"}], "]"}], ",", 
   RowBox[{"n", "->", "Infinity"}]}], "]"}]], "SolvedExampleInput",
 CellID->1614823,ExpressionUUID->"7c4cd0d9-9cb4-43e0-a475-ae58df99b6e7"],

Cell[BoxData["0"], "SolvedExampleOutput",
 CellID->458781176,ExpressionUUID->"28e903ef-5db1-4d77-b32f-68e666f3c6f2"]
}, Open  ]],

Cell[TextData[{
 "Therefore, ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", "z"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"949a0970-17d7-4d4c-9cc7-aedad44770eb"],
 " is convergent for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "\[Element]", "\[DoubleStruckCapitalC]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"97bedf95-4e4d-449b-ac0d-cc5bc837902e"],
 " and its radius of convergence is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"67a3f871-1b23-4e00-9219-1021ab5c4bce"],
 ". Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->74818161,ExpressionUUID->"64aa35c7-fdf9-4d8a-bcb4-4e78cffe97c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "n"}], "/", 
    RowBox[{"n", "!"}]}], ",", "n"}], "]"}]], "SolvedExampleInput",
 CellID->139819750,ExpressionUUID->"bf9c39be-c547-456e-99e9-4e8c27c9210f"],

Cell[BoxData["True"], "SolvedExampleOutput",
 CellID->224445426,ExpressionUUID->"b99bbed4-cace-454d-bf68-35708ab46d4b"]
}, Open  ]],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s apply the theorem on power series to find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["d", 
     RowBox[{"d", " ", "z"}]], 
    SuperscriptBox["\[ExponentialE]", "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ef29657e-9380-4698-a88d-5d0705f7a7a8"],
 " by term-wise differentiation:"
}], "SolvedExampleNote",
 CellID->7165959,ExpressionUUID->"4701d961-8598-45de-951a-e2d8e79d7c37"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"c6811aba-816c-4372-9c0b-d0675b26837a"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["d", 
      RowBox[{"d", " ", "z"}]], "exp", " ", "z"}], "=", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
      RowBox[{
       FractionBox["d", 
        RowBox[{"d", " ", "z"}]], 
       FractionBox[
        SuperscriptBox["z", "n"], 
        RowBox[{"n", "!"}]]}]}], "=", 
     RowBox[{
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "1"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       FractionBox[
        SuperscriptBox["z", 
         RowBox[{"n", "-", "1"}]], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], "!"}]]}], "=", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        FractionBox[
         SuperscriptBox["z", "n"], 
         RowBox[{"n", "!"}]], "."}]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"de231001-6cd9-46ec-9724-e1a8781a0402"]
}], "SolvedExampleNote",
 CellID->744726197,ExpressionUUID->"4c7cd448-d1d9-46bb-8733-022e5ff6b0a0"],

Cell[TextData[{
 "This proves the exponential property ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["d", 
      RowBox[{"d", " ", "z"}]], 
     SuperscriptBox["\[ExponentialE]", "z"]}], "=", 
    SuperscriptBox["\[ExponentialE]", "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4ab57447-a0b8-46f9-a196-caf3f33753ed"],
 "."
}], "SolvedExampleNote",
 CellID->474105480,ExpressionUUID->"3ab5adcd-2b3f-434c-a6d1-a1f9813c9dec"],

Cell["", "SolvedExampleEndCap",
 CellID->1087475563,ExpressionUUID->"c3663234-3fad-4133-9567-9694136bf685"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->301852218,ExpressionUUID->"a13e3603-2c88-4f47-8445-4e59610119d1"],

Cell[TextData[{
 "Find the values of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5dd2fb68-d1a4-456d-b13c-e4db305d9eb2"],
 " such that the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"z", "-", "2"}], 
       RowBox[{"z", "+", "1"}]], ")"}], "n"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7d091138-680c-4cc7-99eb-6b61b8665b10"],
 " is convergent."
}], "SolvedExampleNote",
 CellID->207906595,ExpressionUUID->"c0ad1791-3619-4103-9835-12a988742a69"],

Cell["From the root test:", "SolvedExampleNote",
 CellID->769796789,ExpressionUUID->"c4e0b733-a9b5-4dac-aff6-4320ac66b454"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"783e0273-b5d0-4998-8118-ba955400f06a"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"z", "-", "2"}], 
         RowBox[{"z", "+", "1"}]], ")"}], "n"], 
      SuperscriptBox["|", 
       RowBox[{"1", "/", "n"}]]}]}], "=", 
    RowBox[{"|", 
     FractionBox[
      RowBox[{"z", "-", "2"}], 
      RowBox[{"z", "+", "1"}]], "|", "."}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"92f831cd-3fbe-4626-a8ae-a7a93c873141"]
}], "SolvedExampleNote",
 CellID->798630177,ExpressionUUID->"9ae34076-a04a-4f80-9660-d8ce0be8df86"],

Cell[TextData[{
 "With ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->124183039,ExpressionUUID->"0a008702-1181-4b39-a709-fe316ba25789"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     FractionBox[
      RowBox[{"z", "-", "2"}], 
      RowBox[{"z", "+", "1"}]], "]"}], "<", "1"}], ",", "z"}], 
  "]"}]], "SolvedExampleInput",
 CellID->353721022,ExpressionUUID->"4b3ed5db-1b41-443a-a7f6-25c9acea3464"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", "z", "]"}], ">", 
  FractionBox["1", "2"]}]], "SolvedExampleOutput",
 CellID->323016079,ExpressionUUID->"1b49caf9-4249-462b-8570-3f1b97f06fda"]
}, Open  ]],

Cell[TextData[{
 "So the series converges for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", " ", "z"}], ">", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3600713c-65c4-4512-a777-dcbeaf96aa74"],
 ". Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->126765190,ExpressionUUID->"2e2ab333-299a-4ee4-8a8e-7e46a1063468"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SumConvergence", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{"z", "-", "2"}], 
       RowBox[{"z", "+", "1"}]], ")"}], "^", "n"}], ",", "n"}], "]"}], "//", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{"#", ",", "z"}], "]"}], "&"}]}]], "SolvedExampleInput",
 CellID->294974709,ExpressionUUID->"5e7144a2-3488-4c82-925d-3ff9871f62f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", "z", "]"}], ">", 
  FractionBox["1", "2"]}]], "SolvedExampleOutput",
 CellID->324386536,ExpressionUUID->"a2ec766e-1cf7-4d14-a770-e05079b3574b"]
}, Open  ]],

Cell["Let\[CloseCurlyQuote]s plot the series by using a truncated \
approximation:", "SolvedExampleNote",
 CellID->506829140,ExpressionUUID->"9f540080-144e-4c64-bd9a-39beb442c00a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"z", "-", "2"}], 
        RowBox[{"z", "+", "1"}]], ")"}], "^", "k"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["5", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1184", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[AxesLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, AxesStyle -> Directive[12], 
     PlotRange -> {{0, 2}, {-1, 1}, {0, 100}}, Exclusions -> 
     Re[$CellContext`z] < 1/2, PlotPoints -> 30],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->62400502,ExpressionUUID->"d2441415-12db-43fb-9a63-a490a2ce46df"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx0nXe8FdXVhhELdmM0+tl7SdRYYgX1Yu8Ye8UWFXvDKHaNiiXB3jVYIwEL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    "], {{
      {Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJzMvXV0FFnXNf7+vt9aOIw841MddIDBY52OYQnuEtxlYGBwd3d3d3eCS9xd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           "], {{0, 288.}, {288., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {288., 288.}, PlotRange -> {{0, 288.}, {0, 288.}}]], 
       EdgeForm[None], GraphicsGroup3DBox[
        TagBox[{Polygon3DBox[CompressedData["
1:eJxdm3d0VVX2x+97D5K8gI6gBsl7uT9FkaJr2UBQfyrNWGaNFKkqCT0gSkkI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           "]], Polygon3DBox[CompressedData["
1:eJwllOtrz3EUx8/MZCh5pN/UwQPJo/0FMg8oD2zMlGEuM4aZMblfwnIZuV8X
y91CTC4NkZFhYxmaIQzDWBEtD5Tk9e48eNfr+/ucz/mczznvz29gfkn2/C5m
NgZ1RR/d7Fs/s/7JZm3wWVTCdx+CzsHf0bQUs1GpZj/gA2hlktkQYg7Cl1A6
sW0Js8vwZjSQ9aZuZuXwBHSC3FmclQt3olLy/SX+N7wBPUrEno3wHVROvsI0
s7vwdTSku1kRv92A16PkpNhTBn9Bg6jtD/W0w6/QW+ILe5q9hutQO7Ff0X34
me4Ld6Dn8GO0n/gRxDfCh9FQctVwRiVcg0Z3iRquwZloMLXt0Z3gLR53HUb8
Vvg9SkqNnn6A73ncRTWols+oMhE1q/a1qCERd1oHP/GopY4zm+CTqJm1XHKc
gg+hiqSoUbXeVs5E9KwW3uZRSxbx2+ErHrPRHa56zEyzU44KeLn2M5uRxK+A
z3vM/gN7LqhX6kdyeKBDvdX9+C5j/R380KO3Veyph3ejPHKPU4/gmWgr+XN6
mc2CF6NquICeLYFz0K6U8Mh4eB46Q/xw9hfDez1yyXP75E2PtQy0AD7t0ZtO
1qvgVR53qaem1fAbDy+oZtVehFrS4gydJc/L+5rJJ3kRbeodnpA3StEDi5oX
wUc8vNFK/FHV6nG23ozeTrVH7/QmLsKT5UnuV8uZeeqVh1fVU/V2isdaMWdM
hW96eF0zvQW/UI16D3y3wC89WB6X11s9ZiHPyXtjPbypnmZ75FTuzL7MEC5A
jWkxE81Gb1JvM531ifB0j9h/7M+HZ3vMbgDzmgPv8PCWZrwTPubRC3n0uMce
7dUZM+CnHl7Wm9Pba/Z4e7qT7jbJ42z1SL366fFfo/+IXx4z1qw1g4UeM9Vs
9WbWeHhIXsroYbbUo0bVqhnPhZd5rMnj8ro8Kq9qxg3wf8kY1OY=
           "]]},
         Annotation[#, "Charting`Private`Tag$48020#1"]& ]]}, {}, 
      {GrayLevel[0.82], EdgeForm[None], 
       GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJw0nXm8TdX7x++9huuec+49x53OPncwp0kUihAZMpM0RwPNadAclVQ0USkV
IUXJUFIpQ8jYPIcUKVIaqMw00O/9+X7W74/zWp/17GevvfY+e1hrPc/zeeoO
vK7vtTlZWVnPNM/KqkL5ZkFWVq/irKyFVbOyzkxmZV1XIytrD7hOraysvZQb
K7OyrirJyjqXbTex7RpwP/At4FvAA8BDwQ+ArwWPAA8DXwEeDr4XPAh8D/gO
fn/T5gQ6cAPyC5Dfhmwo+FLwMPCplIMod6F3M/ghcHa1rKy7wY+Dq4FvA48G
54BvBz8CrgLeRV9zKb+jnF+elVWUoV9se5n2R6E3AfwK+GHwJPBr4DHgyeCx
lM9RJth/NPLrqd+nc6EcQ1kV+XLaXMZvCvW30BnPtmng95AdzbFmg+tz3crQ
/Z4+/ITOAnSWIH8fPAX8EngVeDJ4Jnga5RzKYvZ5A7wQnAG/BJ4LLgXPAL8G
LgH/zL5vUV9K/U3wk+DnwUsoJ+ZlZVWiU600K+sL6l8g/xWdpeCV4N/BK8Dv
gPeD3wd/AP6M/n/Fvst13ZG/g/w98L/gj8AfgddQrqZsSPtfoN+e8/2E+lJ0
JrJtunSQd0T+GXgEsicoq6O/OD8rq0ku/zf/6WLut3/Ai8BfID8JfCn4I/CJ
4IvBK8DNwBeBLyniHqR+CvWOXNvLkK3j2g5Evh55J+SdkN+G/Gvkx9CHtcg7
aH901oE7gt+hPJ5yAHono9OO3wDq7yNvQTkQ+WH07QHwveAr2HcL27pQP0B5
BuWNyHeB+4CvB/8DPgt8E7gq+/YH3wrOBp8HvgV8Ge1sQq8z9avAW8FdwYco
z6G8GZ1Pwa3Bl4BPoV+d+F1CfRr6RbR1B/gZcD74VvBj4FzwdeDT0O3D7wrw
2ZRn8bsK/BQ6MXSuBzdG9gn/Sy9wM/Bq8OngeWzfn+tnvwnyz5CfSv048Bfg
08CP0M5ofteAj9e1RX4muAV4Hfhs8DeU51K+kc0zhG6KdodS34j8fB0HecR/
dAF4B//RLHRK0RlG/TXuk/ncJxH3SQ/a7M7vMuSL0amHzn3gDbTTj/JN2nkD
eQXye6jPB9cGjwDPAWfAw8Gv0OabtJmmzb7ga8C7Ocee4CvBO8G1EryL2P4O
L8Ht9Ok9yi8pz6rJfci2gupZWZvZvgD5Bbwn6yJPIP8dWQSuDv4VXAHOA28D
1wRngX8CF4OrgH8GnwduA07R5ntltA3+E3mfCu5D8DU8e3Up/0X2LsfL5plK
0teW9PVwrsdC7o9jOK+llMdRXkj/u9PmsexTgzaPoXyJNj5i31OQH0W9KvLe
4GbgGDiX34+0fydd7Ij8COQ5yPqCTwAnwOWUB9BZRTsf088U9Z06X8p9lCuR
P4r+ldSboj+M8mTKX5Afwf/7K+UaruEodC5j27Fsux98MbgxeAT4InAjcA/K
Msq17NMbXAH+CnwauBZ4HXgO+vdQ70T9dsq2lD8j7wqOwGvAt4HbgLfq2PT5
Za5DIfUj2LeQbbvodwnlHsoV6AxA3oF6MToVXONOXOPv9dwhK0W2Gp3rwCeA
t4BvALfUtdM14b16NfXBHON7jvUKZXO23YysFeVP2pf78Ff+p+78T7VpvzPt
b6L9DLgD+DvwDL63l/GrQb0b8sspdyBfiWwD93CJvheUVfR+Rf4OOBv8tt6N
4P9oewl4GfrfUC9i22juk1H88sAV/BfL2L6B/+JjdDajk9G3D/wpOK5ngG1f
oPMt5R/IDyJvou8FZW3Kj9n2J7g++FPwUvBBPZfgreBK5B+BfwSXgz8EbwfX
BX8C3gs+HPw5+H3a/456Wt8XysP0zUG+Dfk/1I+hvhi8DlwTvAC8BpwEzwV/
Ac4HH8G16km5hX2P5hlpRL0P9cbgxuC+4MMou1P+gE4N5DWpt9H4AFwAbgVO
gdPgk/W9BxeD24KzwPHw3HUHdwAP0PiB6/pPxH0M7ozsUso/ab8zOu2oX6hv
Jf2sDj4efABcBdxM7x1wFvg4cBv0TwT3A9ej7Eq5mXa+575qQf0p7qdm6BwH
PoNteZQtKL9Gpz3yNtTPpz5d73B0zwG3QN4c+Vng7dx3PfmPrtN/B+4NHqz/
AtwXfAP4fO7PKlzPttTvy/P3Su/ndrn+ho4HP4pOOTrX6p0LXhbjmwh+AlwL
+WDwCK7HO+z/IPt8hfwDdJ7UtwD8IXgc+GvO603wSPRWI38fPBb5teDqtNNN
3yzwQfrXCvw0eCE6N4BfBr8Nvgs8ChyhPwg8Frwg5j4cAR4Prgdex7HeAI/g
WGvBr4PvAZ+Ozt+03xKdr5DP1bkgPw95Fm220beM8l1kD3EurcDvgUeBl6vv
bL8bfBTy5chHgj9g33fY9jDbjkG+Avl9yE9Fvp9jnYB8Dcd6DZ272dYD+R7k
zZFX03mB88Gdwc+i0xTcHfxczDrvgFeBR4EPp/1ltDFC7wdkD4bxyQR06hb4
Wl3M/TCQ323gQfrWozdZ3010PgI/DT4J3fdpZzT7voZ8qfqG/B7+x1XIH0B+
LDorwffrPcP2+7Ud3AD50jwf9xP2fZdtj7Ltc/B74MfAHcCTwceCHwKXsM+V
4OngJcjvBPcpZDvn/gLvyofA1yF/Dxwhe5yyHu0/gnww8g+ozwEPAX8Pfgl8
G3ijvh3oL6Q8Af0Xkd+KfAP1rsjnUx6P/Brkl8dc7418EWUL5OXgJ8D1wYPR
uSLmthaCbwf/pO9ZmmeRsgE6tdEfDz5MY1F0LkVnLvUqGqOBXwOn0BlNWRud
EvAYcF1wIfgRcB1wFvoXoz+H+pW0cxn4TfAZ4GbovQgu1pyF32bJkS2lPJF9
63MNx6FfR2Mq9F9g2z9sy0b3vzK3+QPy6cgPgh9Ev5Drfzn6D4CT4EvBU8GL
aed2PfvgBPKB4MngRTHfP3HavAm8lnaqapyf73M8n/bbgF8CPw2+EZ3PwKfk
+zya08/TwEvALcFvojMUnS3Ua9LOLeBvwDdyrDyO20PjfnQ65vt6PgW+AZ1P
wP3BJyKfBX4cfD3yj8DngE9APgM8GXwz8nXg3/mGfc23dzVlHu0vRydJ+xnw
J+A0eDP4ZI77LHgvuAd4Ovh7cFvwMxqbgruBp4G3gTuDnwdvBXcET9Hzzvv8
d933Gvcj+5jnYgrneyTy66mvQt6S8qlcv09uRP4i9W0aV1OOyfXzdTz4iVy/
Pw9H5zq9R6hfQbmIchLy/zjOadRfon4K3/TJyL7hHAchW6I5AfVruba38wzP
pt4a+fhcv7uOBo/O9fvqb9rpTX2mxv+Uj+f6eb+C4z5H/We94zSHpb4V/Cyy
zzivV9F5ELwG2QzwfeAv9UyDO6J7L/XPqT9OuZ7yJeSPgr8GzwKPBn8Fngle
CP4L/Bb4CPBDuX6nNQY/kuv35/G0OZT6h9Rbge/U9QW3BQ8Hfwp+kvJbfR/0
vkJ+q95rmneBZ4J/1/cF/Dz4V70r9V7k96fuN2QLKSfqXJC9wnXbS/1O9F9h
207weMrvKGejMxG8SfMJcBnXfw7leq7/Pei/xrbdbMvXu5p7rKbG5cje1HcM
vXPBr4HHgU9EZxL36lH6nqKbS9lf8036MBH5EdRfR16Nsh/ys9B/PuZv4rng
F2L+Tl0Dfjnm7+YN4NkxP0er+da8Ch6u/4x2qiA7j3Z+yvcxrwEfh/4EdBrq
HgY/DW4A7gueGvP3sUTfbvYpAfcGT4n5W1ZT9zvyInC23hXguL6/9L8r17Ax
+Heex9nIs/WtQecZ9m0EXoAsj/J8+vALOrOo/6f3OduX0N+rJc+37rUaE+a7
PY1hZqDzFjpX6j6hzW/z3efpemcjv0LPHfJv8j0GeJb+TC73WK4q46LCMN7r
z38xV/8t+gPB88ETwG3iPB9sP6RvHO18le937NG0sYD2L0feH/m0mMdLq9le
lus1iC7Id+b72/0F1/8VdIaxTwXyz5FnkH+JfI7GMMjP4rhzkD2lZwedP/L9
rZzF9sVsH4S8Lsetza+Wnhnki5Bfhbwp+t/n+787HvxDvu+ZrlzPo8DPcT2H
MK85m3lIA/Dh3KO9qB+t+Rf36vwC3+ebuB4bON+jmAvVKPCcfgjtD0Pn9XD/
3w6eU+Dn5Tbwy+GZug48PTxTo8BvhbWDe8FvhGfhnLAWofWHMciXhGf+BfrZ
nX6upz+zwX3A34FfBZ8O3gSeCz4L/AN4Pvhc8I/gHM6lN9+4XvzaIvsUWRP6
/CQ6ral/TH0quAv4a3CS4+drPQs8CXkH5GvAM8G9wN+C3wL3B2+VDv18N8yp
ngAvC+tTH4X5l+ZRzyH/IMzBJod3gt4FwzjOnfx+or4dnUNhLnMgzH00v3pS
YzP6vlrjfHR2hznVFvC+MBeqwTlehM6F/MYjXxnmWjeV+z38jsZhWncs8Pu5
HTojwvvwSvAL4R1+E3hW+NacDX4qvJdPBY8J7+Ie4IfDO70f+OnwPj0dPDa8
u7uCHwrv+gvBk8I7sQr97EsfT+N3E9fvANevE+d1C/hvjQX0fHFt09Rfp345
uAz8BrianqkwproIeTHyV6kPAleC54FvANcFvwUeDm4EXgG+CdwAvFhjHvpw
iOP35Hd+WO+6mr5VpzwSnWWah6N/B/iQ5u1h7U3vmWrsew77nc3v67BGqHfI
YJ6p38OcfU1Yk9QzviGsHer9811Ya9Tz+HNYF9R7dRD7/hbW9DaHdUo9y3/S
h3uo5+g5Ah8Ofpv+HOTY/2jtAHwe8iTymeB3NLYEbwd/Ah4E3gF+GHw8+H3w
cvBA8G/gJeALwb+AP9A4FvwHeDDlHsoO9OEx5C2pf0j9C/C14F0aH4Kbgt8F
jwQ3Aa8CdwdXBU/RmBmcC35e42zwPt4t48B71X/wRPD3Gp+j86/Gf+DdyJ8E
/8k9k530esKxyHcgH4u8I/gQ+BmtO4Fj7DsN3BmcDX4WfBY4Hzwd3Ar8F/pP
g9vz3y2t4HnnXtxD+1XDnPoQOBHmyVngM8J4qSr47AKPi/bxH50axnv/gPuG
sdBuzuV32n+M9o/iWNvBj2rdh/d2bZpjKpw1Gp0JfCdu4p3ZEJ1f0XkYnWu4
33qGseK9KZ4lntPr0ekexoyPcf07hfHmo/p+0Z/bCjxuPA58exi33BzGjBpD
/lHk8eQL1IvRuTiMJ1Lgi8I3rEsYh47R+gby88J3JQE+P4w52ofx7CPo3E3f
zqPNwfQtzTX8kXO7EfwI5zWR87oZfBzX9SWt66J3GPgm9ukLHkJ5lr7R6ByD
fCY6Z1A/Ejxda8jgp2nnOdq5S/YR9JeDZ2nNDXkRv9GMywdy3DJ+XdivLr8b
0DuNfTPga8Gngs9lewH1npqby+aEvBd4HG08S5t30uZj4EngW7WOyfZz2H4t
+Enkk5HfDq7Ovv2p9+M3lt8zyIfIToT+2ehfo75xnKup95a9BDwY3Ac8kLIz
5YXo3AU+F3wd+Gb+lx1hbeWGME5/jmsbaR0vjCc6ge8P4+FV4O8LvI73AfiH
sPbVGnx3GNOOo81bi7w+v5zyyALbHioLvIY9nPbrFHidW+sPC9CpX+C17jHc
e4+We01vCfKGBV4nX0773xZ4PXAh+OsCr6FtAO8o8NrcX+DcsDb1NG2ML/ea
1TrNawq89rca/FuB1/g+B/9c4DW+WeDPCrzGOAf8ZYHXEt8Ary3wGt3D5V7D
e5c+r6JvjcJYP11gO8YwrQcibxLmJ63Lvb4vO0GbctsMZCcoYPsQjUc0fg5z
Jc2n2oS5leY4mutoPWMXD2oFfbgyjO+vDnMozY9yuR8u0LeCX6ty2ypkS6hZ
YFvKHWo/2DJkwzgh2Edk4/iYfjYN85PLkTcP87cTwhxKc7eyAtsx7tJcLMzL
NE8rLrAN5E5wy2A3ka3k2GCLkZ2labC5yM7SPNhcZJc5gXMZFuZBQ+jD7rCW
dzt4X7A/dQ42LNmJLgnv/rYcq1/4JrQGT+F91SmMiwaEb8tJyC8I35A24OfR
6RzGZkeH78CROhfkFfn+ZhdoTSLtMVUp+JwwdroDnYbhm/s6uG8Yv70M7hnG
eEt4fibyO5l36XqeqS95Ht+m/ha/abwb2iLfyzM4i2ftReqvMW4dwTu2s9Zk
wA+Bu4OP4388NYwV59H+mWF82IprMg98NNdhBvJuYYx3K7h++ObeCK4Txg9H
hDHFEZojs+9L1Ouz79daZwhjmobIZ4Dr6r8AzwUfCW4Gfg18OLgJ+BXwYXoe
KQs0Z6LNseCUxlzgp8CF4D5aR9Kcjnol9acpiylPQz4JXAruC34WHGkspvla
+OYfDc7jmn+f9ji2cfhuH6W1yjAebgz+mOv6Btd0KtewRRgXH4P88jCOaKf5
heYy1Gtr7BLGCe2RXxXGBSeDm4fxQiPww+AEur205kn7r9P+FNpfCX4F/Cz4
Ff7TV6k/R/118FzwVPB88DzwC+A6PHujKMegXwa+X98fcIL/9x90NlJ/GPl/
GX+PxoBzyvyef4KyRpnf7bNoczb6k2WT4n54sMzf5UrKBykfpc2nKcfzq8t9
VU9jRfS36H3OsfpzLx2ha4H+bO63jeh/r75Sni9fCHTuR6crOhXsO4N9J7C9
PvoP6/uDXkPwo+DHwceAZ9DOE+Dp9G0W+pO0DXm1Mn93nqKMl/n7dR/3+Uid
K/p70F0HngvexrHeoPxCthjkq5G/Rn0neK2uK/hn2v+O+rvUt4A3gFfJXkj5
KuVz6HyLfC31ZfI/AH8NXgFeBl4SvsvbKL+gfFXtI/+J+ifU32dcsBl8RZ6/
23cji8tPBFzM715dV9kuy/yt78q51AQPQH8Zii8jm0ybvZAvpH4Z8lfYvgg8
g23Nwe9TdqHNxeAtyD+i/gvlZ5Rz2Pc+zr8J217U95r/4lz+i4Yaw2vtN4zn
12vtMcw3mnM/vxGex5fD83oO9+qc8EyfC26Nzlvh/fBieP7OQt5W69L5tqu2
l40j3z4Kp4BX5tvO2k1r3fn2RajPM1iv3M/7zPAMnU07LdCZH94P6/murpOd
iv7Xpp+b6P+D9PMbynsp89D/FjwSHNPziM4P1EdpfRn8Uxhbzq7weLkmOuto
c63swLR5JDq/hDHqMeBtYey6EZ1v0DkSnaqyYXMNz+T3Gzp30bcszd3o52Ph
eb4T/Fe+bUJ3gf/Nt3/Df/n2Z5BPQk6B/RPkwyC/BtmGZCf6Mt++CvLZ6Bl8
FWSv7xts9/JDGEmbF+fav6JagX0hZGc6E/ln+fbzOE1j3Xz7XvSS/Sjf/hm7
6fNIcFXwfvAD4Ooat4NHgWuon+BHwDFwUS3uU9r+Sr4/tPNEeBfHtWYe3sVJ
rX2Fd3GR1qbC+zctm0t4/04N794zaKuC86gaeV7TjGP9GeY1J4L3hvnIHxzv
b+7ZtZT7uVeXI78B+duUr3HvZ9HOP8hXUb8J+Tb+j9eR3wb+nGftQ+S3UH+Z
ciCyv/SMoz+X+hXU/wO/Jx3wr+A3wVeBL6MPpWFO/TvyBciv1veAfiyjfj14
Fzp3h2v4B3hYmIf+KhtHuB8eCtevp9aHkd8fru0+8IhwzXvqPOnXW+xyFfJM
mKdfD64V5uk7OeYi+nAt+FPOawL4Rq1ZIH8C3FfzVvBj4D56BsLcrpzjVgnz
ywy4A23+HeaGX1HeTVkDeSLMjyvAA9ApCmsLbcEHwjz0X67t0rTn1BcirxnW
Fg4mPKdMy/4S5rURuHqYd5aBV6NzFzgX/CPtvKq1Os2p6fM4tp2hMQz4EXBv
rSNRXkR5gOtyPMfaFebFz1CeQ7kH+fPg/uB94M/Bd4Kr0/4n4Nu1FqI1JfB5
mk+j8yL4AvB+vQM1T49x/aj3BB9DX6eC7wFfg3wluCX4nJjtUjvZ92bKIto8
O2a7VSF4P/Ih4BKNmbWexrYJ6h/yWymLkV/Ded1EPUN9GeVplNnIV4JPB+eA
u3NNupX5XfQw8mM0v6efTbVeF7Mt7WTweeBJ4NO1LhGzPauJxmkx2/ZKwdU4
l3vAtcBx8H3gs8EXxWzTKQPXQD5C9zbH/JT/dCi4E/J+smnqvQn+l37coXtT
91o430LkOew7nPrqMt+3C/nbH0TnKLUnXxHO907qtanfDB4KrgRPATei/dbg
e5EdrucV/ZeRN0HenvoPtHkc+BTwU+g003OGzjfIh1Ovq/uN9/YG6ofpGWHf
W5GX6zuldfrQh2nIj6F+EvUZnN/g6n5X3IfukeDtuq9kA8/zde4VnsGvURuD
ThPqO6i/TzstYv6fxiI/TvcC8jeQN0XehfoC+f/IXgBeJT+fmP/jmeDG4Hbg
LloLjXkNuQD8H20NA/cAnx/zvRdH9gHflrdpvz77xpD/oTVk5O9RLkFeW35Q
yLdTf1o+SOAWei60Dg0+EVxJm6fG/L//wnW6kjLBuW9lHPK33hnsW45+DXR+
A28Fb+AYF+uZSXj7Yo6VA14JXgSuhk4l9a+otwYn2fcfcDa4DPkacAtwAfK/
wAf4jz7k2C31ztCaMv/Bx1obQScXnV80N0HeBvmH4A/A7cA7tLbA9q3aznEz
nEvvmO/Vreh8x7Eu1X+g9VHkD4E30OaXyM/Xe09r4DHftzU1P4r5Xs0H94j5
mq9D/zP0+4F/pryOMsn1ORWdC2K2m/+W8D2TQt4I+Rkx25tXs+/HbDtX7y7K
symronMIeeeY3xHvIj+TsopscFp7j9k+vRn5IPUFeYnWyWN+Tn+Ub5ruC80v
aKdlzPs30FwvZpv398jXoneh3hdah4/5/VIN3DXmd9Df6JwS87O6Bfw1+gPA
T4KfBh+v+15+WTH341euYfuY74/D+KbsZHzzs8Y34D3gX8EdwNW4b/aD64L/
QP6TfIHA+8HbwM3Af4N/B7cC/wfeDT4JnMO+e+WPpTUH2Qfl24O8BvK/5Jej
ORe/nfIFQh5H/g94ILgOOJ/7NUX5n9rjniji+3sj/b5BY3+2nYysEffJc+Bc
fseAz2XfMvbJo75NY0XKJuhdjrw+8qTW2sANwTXB54MrwXFwb3AB+KB8s0p4
vybtb/wOeGrwJd6p8+BXojE88srgc5YG1wm+brXBDYPvUU1wWfCDKgfXD/5q
9cFHBj+qJuCmwbfqcPDRwQerOfj44Ke0DPxs8AFuCW4Z/JFaJe2n9Jvsocj7
BP/LDuCTgy9TF3DH4EPVG9wlaT+rk8AnBV+ptOYytNNeftGc36xy+2XNKLfP
lPygzkf/9OA7PgB8VvD7PBPcK/jY9QF3D/5b/zHvWB6e5WdoYwuyJLgm/+P1
/IeD+X3FPdk65udxAnhSwu+0L8GtYn7WpoKnJvztWC8/z5if91ngGQm/Yzdy
rGnqu771yKcl/P7/DnxSzM/OZPCzCb8n16P/vOa76P+AvG3Mz8tP4HYxvw/n
J/xeP6R3fsLv+4Pg/3i/bS7zd+pT+bLG/C7YAe4Y8/O8JOHvir47ryB/hXoH
6m8l/J36T/NT5J1ifgfNBr+U8Hcwj2tYEnzqqnNPrg1+5l/yX3xebp/wDei8
HnxwPwXPDD7uq8EvB1/2+cHXXb7yy5L2P68FTnL9r6X/1/Dbiv6i4D//qdou
t9/7xP/3Vc/hGUJnTvCV/x78ZvAnfgfdVeX2t/8N+crgA1+FPn+ZtI/6AeQf
Bx/4g+BPg697HJ2vg797HfCv4M3gP9B5N/jPbwm21KPp827kHwSf+SL0vwvz
wLTm1GFulgRvCHO5ZlzPfK7tfvZtIr9i8F7wXj33XOdP5bcc2Tf91mzboGTj
lh3qvMh+7w9le94ku7x812WbF74F+SmR18Suz/bcWHPkh7PthyAsH4MDhfZF
GJxtG/r60L7ms5LLP+HwYFt/EJ1G5baZvZhtO5hs8f9vm5Z/u2xeFxfZBjZT
+sFer37Khr8htH9hkfH0bNvfZHOXDe7cyL76OpZs8euCXHb+rwOW38S80Df5
FMgvWn4FmntrDv4I+3aJLL8h23N2+UPIF6J95LW767K9FqA1gUez7eegOb7i
ArqHub/iDk4JfkTCvSPHJNycbf+iFUEuP4vXQvs7Cn2sa7Pta6E1CK0/HBXw
qGz7RcwP/f+30L4R+o+0RrEgnIt8QOaG/0h+AZvDte0YWa7/a0+h/UV0Llrn
mB2OdXLkNUn1Qf4YrwS51kleD212Cuf4ODr9I/93o7Ntt/w+HEv+IVpP0VrK
YQHrf5T/xktBLj8HxW9oHUDrAZ8HnAl4CPrnFHm9YBz47Mj6Q7Pt06J1AMU7
yN9Oc88eVe2v9WmQa/75QLg+R0fWOSPb6wAP5nveekzkeeyZyH+ubiz5oqAj
/b/CekL3qp4PjwzXUGsL94XjLgj49Gz7q40I+gfD+oN0+odz0Tn2K7KdWL6y
shXLL0T24nMix548EPxp1wR5n7DW8WS2fTykI9+SY4Nfh+6NAUW2Mc/Itt/H
d+H56hc5/kU68oHZGORnhTYVLyP/Nvm53ZZtH56PgvzM4P+m63lW5Gur/+WM
cP2fyrY/y+rwv2wLPjzXgOsFfxidy2nBL0ht9gxrNU+oncjH+t9xc62j95X8
hd4P76W+QV+4Ee/JJsFnW/5Sq8Iz1S34UOkZHMb7sF7Mc7B+vAurU36rtU2+
B3Vjnludg7yaxteyH6CfQn6Qd+aVWv9gW1pjX3B2zPOCdbxXd/NNfROcizwH
+dfgf/hWfkG7VTRXZ/v8al6HbYdOn4TbbA8+Hfwf+FLwteAS9B9XDEXM88Cb
wLVinks+AT4y5jHtheBB6BcJU8b1zaf9u5HXj3m+15bjn1TmtegGMc9VhW9F
p3bMc9V99PNNraXShyzFmMQ8r6lK+R3lPM0HOcefOYfZmuOAD3EPfQ7+GPwb
8jngH0I8yx00MU/zH+oLtZ4PvirP+Gjaj9Pubrb9xb7FCbdzEJwGfwneo3Fo
nr9T/2oMnGf5KvCPHOslrV/LL5XfTOkgWxzW2avR9qaAXypzf7T2voZ9d6A3
l21XcJyampdo/QT578hf0/xT90CYr/2m8XhemH+CN6EzHfwH+N88z1drcC51
Ev6v5av2VnjHXoosSfubZJsG52seU8U+2fLNvjHba8LCirXpGTn25ibk6zXO
jHtso7HMG5pDMA45rdTzgVo6H46bifkcDtP4LeH5YyNw+4SvbYew/qyYuNYJ
z6c/l32h3PIx2faxWxS+ZX0ix7Dp+y6fw3fC89I1fL/GZtvndXnoZ+ewpq3+
nxzwY9le914Ujts9cmyezld+6UuDvnz8Fgedr2Q7TfsevkRz6pjv/5YJz/U/
01pQwvPmTxS/g05pzPd6k4Tnyx8jL0F2dZ5xS3S6JzwfH6z5e8zrJA+BG8a8
xvEI+PCY1zXagHslPK8/PuG1gU9ppzjm94Pinopifid8CP6L52VFmZ+N5uzb
JeGx1tXgipjXu47V+DbhcdcV4PKY3xuHxbzGpef0XORRzPdKfXTXVwtxYrRd
GPN748iE72cdt1HCz5j6cyb7pmO+txKMaS9jn0v14/45J+k423zkVyK7Qvah
Go6NXcC9dBHbz5atnnpL+TUEfKL8LMD/aBxIO8dSv4p6O/Dl7NNfcy5kdyse
Rd965Fchv0C+B8jv1ThX4zRk54bjtZB/hMbC4EuQnxfaP0vvatmDqDegPJ1y
K/L64NPAP4HHcq8exT5HUT+B8gTKX5HvK6Zv1JtSbxj3ufyi7zttdkV+CvXD
kJ9J+bPWydFvhrw59Up0eoC7qE3w+UnrnSC/D8r96B+H/Lyk+zSNffcU8C4E
bwIXoNcAPBW8E3mO9qGsFvzxvkWej0499RVcM+7+xxQPlWc/vUJkjWsYv4zO
v+wfo/4jOMm2huo3OAU+AjwcvB6dXTx/DTTXRt5D6xLg3vSzG/gCxfUgv1rn
Dj4taZ2Bml8jvxb8PNdza4Z9tNaB/Ax0eoGPl58O5T6t2yCvG7f8BfTPTlr/
RfC0cv83l6HTDJ3B4Mn07Q/6lgUep/lyuc/tF+SHJ93/+uCN3Ktv0/+fKVfn
2sd7K/gL2c3ABeg8QDuvy54N/lW+9+BC8Cjkb4AP8t64AzwL/KN8+Slf0PsT
nV8UU0A9B3wXOi+Dt8ivn/J5jQMVTwCeBo6hMxKdVzVOp81eBY7DuYy+n17g
GJgvtWZM+Tj6a2Ju7wnwUvT7FDh2ZXXMfRmr/x35VQWOhakjPxn53cpmh/zy
AscrVUd+D/gV8AHkQwp8jBu0FqS1d/DV8m8td3zNM5ST+J3INWzE9R5I+TvH
Ohp8EXg7eKpsZFzn9tT7Kk5NtlFwCfgU5B21rhL386hn58i4n2OtmbzCvsdQ
v0RzbfRbo98afFTcz/Q2dOLI2yI/iXoBuD24HXgj36NN9PlR7ukfOZfBnMtz
svtTTgg+Kr8iv5H6VOo7Ofdj2PdY9v2B/T6QTQydW+jDi3wn3qW+i/fUjjKv
bVanD8U17OdTDVyoOTd4N23eQpsvSl9zhJjxBNrfhvwQOA/9MvQ/QD9CZ2zM
Y9jh+Y596YZ8p8bwMc+xitF5POYx5mfIx6O3U2ugsmnGPPfdi/yhmOdPX4En
o7NX66LgieDd4DvzHUvUlfbLZSuMeb4yFp3L8h1jMg58Zb7jUFaA70Rnm9ZO
ZUcD/w5Oc02Skecc92udPN/2mrfld4rOr+BRsmvkO77pQ9lhkf+ptSPZ5mLu
z6Pgi/Md6/QpeHjM51VHz2nMfuDl8vPi9xfySD7A6O8DD0P/anSWg5/nXNoV
OK7n7HzLWnGOQ+VHGnMcUb18238a6j9FflXMsTqN9Q2KOT5qv/7ftO0sh+Xb
nnM4+vfKvpNv29NS8Oh8n2NVjvtIzOOmlcgfzfe1eg/8eL6vVQKdMTGP9z9C
/mS+r0MN5I/GPGaZoHPJdzyR5mGaE2rOdW++52Oai2Wh/3DMYyLN7XTte4Y5
2uiY1wM01xsV8zrBT9xvDZJ+V+dy3a5jny/YZ2i+Y8i6sO8U5OVxP5tr0Y/Q
rwX+BlwOrqNvBrgUXAEu5vmqiPuZjbS+Gve3rA64dtzv+Y3o10r6+zIPnAMu
0L5xfw/XctzNyOsm/Z16Dfwf/10C/Dj4J/Df9D8X/VJk76E/Uu9n+b0ir4E8
Qv4+8geRb0K+D/kj4C3gA+Cv5RMbd//XgONxn9dTeg+j86/em5x7LO7zKor7
uV+jeT3nUivu729Z3O+Sb5F/yr5FST+3Zew7IuZ78lmu+Q35jsMqRH5zvuO8
Emq/3HFk32oOHnPM2mbNtWOOU9uu+XXMMSPTwbfmO45vLfiemJ/fLVoTiPnd
NQPcocCxhL9oDhvzuysd9zv4G/pZGvc4ZB34I32jk75embjfkRu0PoC8GvKU
vuOyfccck1IS9xjkK71XeS4mKGaPZ+JdjRmS/j+iuN/B6/WdSvodqOO+rXju
pN+Dx5bZj2US48DZ9POUAsexvg7uWuC4y9XMFXbleb7zPPgj2h0DXkP5LOUM
2Q6Qv0/9EY2zwTvzPA96ArwY+X3gleA/8jznmiJfWX4j5N+jeW3a868DeV7r
Vpvj0F/Kvg9oXkw5hXKmbJ3oZ6U9hxqDzgK23aP1cc2/8rx+/Say4ZQT0N+X
5zmdfPb25nluKn++PYy9xwX8BfrPgKeDm5VZV/5+X2k+nuf5+P48z0Ol8x7y
P/M8h30G/A77j9Z4WnPDPM9hJ/Bd6079WPlJg08FNwe/Db4Y3El2GY6VlM8Z
bbZBVh/Zqex7r+KsqddWjCu4Fbgu+HbwceBy8F3g5uBK8ALGYpfTRjfNx2lv
IfWBuiboXIROB3SeBfcCNwVPRGdbqa/bc/ItL/V/MYHtKziXh8C3IGtMPYP+
JM2X83yOryM/j3pb6lW5hjn8WoLnIT8f+cm6LuCzwW3kX8L2Q9yfJ4BnIT8D
eStwCfftTRy7D23W03y5zH5rtSlrldkHbyzP+JCkuXXGg+9Imk9nEviupPl0
bgNfljRnz9AwV5jP3ORG5AOT5u0ZAb4uaW6fu8BXJ835czv4yqT5fJ4D35M0
h85j4FuS5uSZC34qaS6dReBJSXPpFCi+UesRWj9A/ljSXD2DwP2T5iB6IGlu
GXH9vIB8ZNLcQLPBjyTN87Oi3Hw++ehci/zCpDmLliJ/u9ycP/OQP500f848
ZG+Wm/PnQeQ3JM1l9Duy7YrLVWwXfSovs5/hLq5/YfBvn8q135rn5zeDLCqz
f+NY5Jvz/JymkZWW2ffvMMoGZfYhfBqdLXm+N54C/5DnZ/OXPD9H8i18Dfm2
PD+rr3MfDZONHfmbyLfn2Vb0MvKhlONkM5INM8828hu5N47W2g31mejcpuOg
86x8//L8bpmleSn4SeS/5vmZlc4c9O8Ajwfv5nyPLnN/ZmtNKc/vqUeR3VLN
+67nWJ/zLn1YbYG7oNcY/Bi4E7gReCjvya94B/4hn7S4v40rubceRn4g5u9X
1bjfzas0VkG+Gv3tWl+k/CHXMVlTxFkR8/zuEvB7bNus+YbisGKeD14P/hz5
b8jPBC8Cf6MxPPgT8C9a7+G8HpI9kfO4kfL6co/zr0W+hDHeY7oe6C7NdczX
ULb/kHE/hoDnFni+tD/m7/ACrZ/EPV9cDs6J+9u+oqp5tsS3pXnQ/ez7Y8bz
0seQ/xXzd/808IICz62eBP8d8/e6ErwB/JbWlfmODCgwl8K74DMLzBWwDnxJ
gXkYMpqTor9A421d85jnU5dy3Icj8zmUIn8E/XngtTHPe56knyXIv4lZXlNx
BDHP7z6k/XMKzHuQj3xdzPPBAeBVyL8HPw3+J+Zx/rngt5Fv0FxJ8+iY56G3
yo4X5hTnI1+Ozkb53inuIOb/6FOO1a/APANfgC8oMM/ASI09+O0An6M5Rczt
T+V/OoJfd+7DizXnjfl+qAV+osDXbRT34Pd5fn7y+b8Tmsug/4jWD/P8bduQ
5/t5JPJD/D8HM8bt5btb5liaeuA7yxzD0hA8rMzxMm3BI8ocNxKjzJNfMvvW
Qn5HmWNMysC3lznm5X6OuzHPz20K+W1ljn9pi3w95WnIH+HZaU/9KOqF6Awp
c1xMKXhomWNYcimr83uAY2XrO87vPq2Z5/l5F66q8YB8r8EPypc4z892f963
R9HWEfwa87urzDE+FyBvSv1YfntjXtuYx73Rmev5aoHXBfbFPCadr/lazM/Z
6+BBijeJ+fkqAz9W4PuwP3h7zP91XfC4As/BG4AnFHj9oT14doHXAqZSfpLn
NvfE/J+/qTlmzO+PN8DH07+7yxyn1BJ8T5njfFqD7y1zjFA/xngDYuYTuEhx
LjHfq3/Kn5kx5/3IT+Z8XyrwmkUzdKYVeA68K+Z3z1ytxSGfUeA1iwPs+3HG
fAiXse9jHG+Rxk383gp+72+D3w7+z3dXeFwi3+m7Knx/yKd9dLj3JL9X/a+w
7/Vvpfaf1z35cMoxUMJTwrdGPuj6D9XGYfzlD6Qc66T/9KGU46F0n99Z4f9e
vvS/lNpXXzrDK/wMyC+9VqXHrBorZqftB65x4OJwLsI5aY85dS6zw9hS+OMw
bj2WPvxaav9/Hfe9sGbfQzF0ur/K3Gc9fzpmQ+Qz8+zr3QX8U6n97fXs6R5W
HICmfbtK7eOuMdJDFR7TKJbg+TCeaoTOpDDWko/65PBdk7/+7lLHLegb92CF
x0CKExhV4W+wdKaF7Y1pZ2epYxvUbqbScX/qz8QwTtNxt5fav11jvJ9LHY+g
53dkyvF0et703Ol616fNraWOC/jfc5hy/Jr0h1X4uVWMwKMpx9CpzSc57hM6
dpnfDdregHZeCNfgGPBC9OcHn5L/Sh0XIDyJ/e5XvHSFxwWKw+iE/r+lHrur
/ir7vhbG/f+UOkZAeH+pY3OeCWOJSaH/M/SOLHNMhX6Kr2iH/MXwvzfR/0ib
L4V9Ne7XuEXj/L9LPV5RbIjGC4rb6JDlOavi4ToxnvwwxMppjvZ9ZL4mYXG9
KI6nTzZtFjq+W3PDR+QXRJv3a8261GMUtfsyfXglzJ00VtIxO3Ksv0odEyF5
4zL37aQsz0fGh3PRGEbnpZiRT8I8SzEVeWnPQRTrcqjUcyI917G04yg0H1kV
yu7suyI875qLVU07xkHP1NIwR1P8RbW051/CH4R5jdpfHmx33WinetpxGWrn
nTAnUnyF7GWKpRIfncZsik1RXJXGbPq/2ut/SXksJ73xYWype15jP+nXQ+dg
qeNHNG7MTXtuovZrpB2PoX7MC/M+ne8b4DeC/o5Sx3tojDo1lEfT5h+ljvXQ
fEfHXhL6qTngktBPzW3fDv2U/U/zR9n+NAeU/EJwHe7f1XHPCb/juF/FPXct
STuWR/LitOOGNOf8IsyjFZtUmvacVvEvh6Vt91Rsifw2xck3LMtcebLRyAYq
u6dig8SJd3zafHqyV8kmKZ3bs+wntiX0LVXTdlLx6DVP2w9V7RbJ1hz2lS1X
2yei3zBt7jnZTzUHV78uyvI8WOfeH1xb39lg210U7JuKi1kCPr7Mts4obZ8w
xfKMrzB/oHxT57N9e8q4Ttq2V+27I9hnFdezGfxN3HOBemlz+qlNzQ/U3gBN
+9PmLdR1/ixuO3hv0WPVMp6m2Ny045G0XpEEfxp3vNm+YGvWdf4wbO+ZZV9a
cR/eJdf7tNc39B99Eve8v1eW1w3eCtchlXZMlLbp+rwV3iFrw1qBjvVesde/
9O44IW2fYB2jlnySgz0yWct2uhfp8964bb+DaKdx2hyLqssevTEct3rwB1As
Vl32aRHshk3T5kgUls36+3A/LAgxY/+7b+M+1tW6r9L2IVA7ssur/aG6rGnH
dOlb+FiYDyoGbGSF54T6ZpVXOl5az879FZ5DSudx9KeEdZ4HKjz/VOxcPO11
Ib2j/ix1bJd0ngzzR+lo7KrYOLqb1Shtvkv5Qvwa9/14OfJDKfsSKN6sRdpc
kbLjyv9a3JbD2dwybT9v1cvkIx3sr/L1Fufl3cGXYHN43lunzZ+p/6JO8BUX
Z2artP3Itc+JaXNO/haetc3heWyWNnel7KkF7Hswbvx38DFQ3NrhafsDCG+P
2+/gCvY9Im2eStVL2bdqOJcj0/Yr0Dn+GbffxJXoH5U236XqOcFXRLF2R6ft
KyK8K+5rdhX630XmD9Qa4Dshzlp4Y2TOQK0DtglxuxpDXh7GwOLlGBniwmvw
vTux2LYxxYDPisxZpPFki8AJINyh2LY37SPuIrXXIMd2M+1XHfxyZA4ijcNP
Krb9THwgr0bmddUc87XI8zvxfnQL8emaq3YP9jhxgOQHf06t886ObOMT70eX
YtsChRdXmCtJ+z4U2j6cPpxSbB4S9WFOZDug2uwd7IM67kuRuZU0nj85xL8L
y86m/ubSzgVhTC6OkYWR5wLCT4c5ZSN0FkTmvtTc4aww7xO3yRuROYU1Zxwb
5ppHof9m5HmfdMaE7UeK+DpuO684W4Zzbe8qN6fKkgrPSYWvA19T4bl/3zAn
FS/K65F5rDQ3fziUR9Dm4sh8nZpvLos8b9H/vijy2oH4Yt6KzOOp85kbeU6k
NieHNY3GOeZZURvHgAeGOaz2nReZf1Pntjwyh6fmVp9E5uLUuoHmK+Lmqcu+
g4vNCaP52A3FnsOIE+aaYs/TpLciMq+mdDSn0fZ6OZ4Die+nPvjmYnP+aP4z
pNjcMpp3XVVsLhr1QXMx6bdHf1VkDk/paF1EnEANc8whtCPovBOZs1T1O4o9
txTvkOaUKg9D593IPKiac2reJy6iDshHFJunSHPO9yJzigrfXey5qI6nueOf
4XlZGZlHVP2/r9hrNOJBej/yOozw6GLzI2nd6dPI6xXi/1kS7CRdNEaNvCYj
vqOHwjqV8EeR+U+179iwVqN9P4681iTuo0fD2o7wZ5H5VdXuuLBOIp6fZ8Na
lviF1kReyxL+IjKnqtZSvoy8xiKeogeKzbmk9aZlYXvXHHMy6V7oDP488rqK
2hefkNZduuWY60hrZt3BqyNzvGrbB5F5YtXmxLBWo2M1SJtHV75eT4Xn72j2
PS/M5cUd1LHSNmDxPowI/A/6r5cUm4NCNpHXi73eJ46IbyJzompd7NXAKSEs
ziWth/Vk3+nFflbFkas1PPFMtEW+ITLPqtYH10XmmdVa39Ji26TFfTG/2GuI
4r74JbL/g7gv9kTmWZV9aGK57TvijVkffEKk83NkXmDZzrROqTZOzvEapPre
Tu+WYnNfaO1yfWSuV+G3is2Dob51UDxmWFucWew1QfFmaN1R5Um081NkXmDZ
5r4KNjvxb2yNbCsX3hyZn1Z2t0+KzSUivCmyvU8cICuKbS8U34jshCo70n6n
StvapSMODx3nEuSPlJunQ9+sHyPbBMX1sSUyL65sgi8Vm2tH65hfR+YHFp5d
7DVN/R/fRuao1f8rW5iu5YU59oXR/6Bn9stgf1T7nxXb5igukR8i2zqFHwt8
JjqueEd07S9l3/mR14h0jx0sNm+J/jvZ+MRZcgc6f0T27xHf1p+ROYLl07Kj
2Hxcsmt+EO6RHjnmQZHd9XLwd8X2FxIf12+R/YWExYMi++1l6PwamcdZ9Z2R
eYbV5rbIHL5qa1ex7bviIxKnl45/Jft+FXnNWjxiz4d1aeG1kXmQ9RzuiMxj
LJ8c+RmJP+w89v2t2H5Iqv9ebBut+JROqTSnmPTFMybfpatybEPW9n7grcX2
TdI1+aHYPkviGfs9Mj+ybOJ7I3MRy266PzKPseyjXSpt9xWHXudKcytJR/ZP
8SJfpGMV2+aquuyo4pI5H/nfxeZlkg11d2ReYuEDkW3oajMWePl0rP3Ftrlq
/6IQUzIwxzZzXcv+4O2R/bvUf3Gnqe9XIN9bbI4p2dRld9X9cAHyXZH5kyWv
FnjUZa/dF5k/WTinxHbc/3FBJ10OYN/cEtuJ1Y/dWmeL+71XP23fWs2naqfN
Ay//0uMKzR+lGNhXKhyPqrj9xoFLSnGv76XNoyKdPWXmwlKM7vtpx+4qrrwo
xNwp5nldwrF3/2U5nlfbS7N5b6cdf60295WZg0t+GorB1TFLsh0TrFjkdLbj
dsUNsI92TgrxuYqVbl1oLi/5gsypcIyt5O1DjK3irz9Lm9dF/h8fph0zrHZb
FJrjS3HH7QI3l3Q+SDseXOe1l7H00hCjuBu8OMQxKuZIMeLr6M/UtLkRFN83
Je34JcW8vxpiKH/McqyS4tr3ZDkuULHvu7UOljZnguIE/6L9FSEG+Pm0Y6Kk
tw35vKBzVC23OavSMYU6zi7aOZL6KWXuw/y0Y9EVjzkzbV4F9X962nwL6r9i
odT/vez7J+0vDLGRH6XNLaNr8luZ4+/3ZzneUXwAB8DT0o6t0vm8mDbPg/ZV
zLX0v9F6Ttpx19rnpbQ5B3ReitsW30DEf/pJ2pw2+u8eYN43knuyHmPUnuCm
8nvmvh2udVDktZD3AR+v+bm+y7JFI68je1aF41s1L1MMqDgnChXLkHaeAvki
11OMUsBd2beJYnRppz7/+5aEYz9vQ343bZbJliC7N7gCfCG4A/oJ8MngI8H7
2Pchvc80pqbN0Xpfgs8AX4LOKegUaI1V7znK09U35C01R5UcfB/bGmhtH1lO
sOl3Qt6I+gHaX5Z2zKr4NBSfqrIm57U8bU4A9Xlx2rG64uBQnK74OVLolIfY
ZMm/T9gmkIN8SdocBIpZ3phwmZ3tuHY9X8Xgd9LmZFAc7tGF5ogTXp9wfLCI
5BamzTugZzsdYofFCfJW2jHOwocj35pwTO7R3J9dg6/dirTjgfU/rUo7Blgc
IB+nHeev+0NxwJIVcayXK8yHoH0Xpc25oH4sSDv2Vu+Zt9OO+9X5r0ybV0HH
fZBrfHSwPSluWNwVf3EKc9PmU1D88r9p8zOLY6ht8Ktqy3EnFpo7WjxFTxSa
z1k6/6TNQyT/upbBt64N+v+lzUMkv6/xheaUFp/RwbQ5iaSXFZmDWm22Dron
sW+TwAsq/6I3KszXIb+jYyvNCy2uquzI/NLCOZF5Y+SnJJ4n7deTdp4pNEeo
5M8VmqdafFniFBcn1qnoVInMcy358eE8WiNPBa5RHfdQ2vzY6v/NheaxlH+d
/OzEO3U8+qvT5thSrP2atPkKxEmxLW1uK/ngiR9R28vEtZJ2PL44LLqFeHzp
r02bB0qx+evS5opSbLjiFQfGnaPntMDDIJ4L8TiKj6Ey29yKsoPVBm9Mm0NK
9fVpczKIm2ND2hxS4mQ4JfADqA9nBq4G6fydNhe3uKK+SZs3Ssc4N9jaxNkh
bkvZx+pwrG/TtrVJ/nXaPA/qWywcp5Zyu6QdLy++jDGF5v1W+3cWmj9Tfo0H
eS+9k3A8++y0+TeEFXcurpS/uWVeSTsGXvVs9n0/4Zj0OWnztwjP5J7pz+/9
DM8lOt1i5pqoCv4o4bj1V9PmGBH+PG3eCX0ft8v+VWj93BDXL16PeIjlV/9f
TzuWX/JP//+50Xp4wrH+B8Evpx2Tr2fszbQ5SrQtGfgBxEsyL+34euE1CX+j
DqH6Wtp8KerDF2nzmmk8UL/SfAXKL7Mvbb598YX9njY/m+5J+YSKF+0Ervkf
aft6qj6k0Dyr8he9PfiXitttV9o8w+JN25k2/5v+i7sCJ4nkcyvsOyr9P9Pm
Z1M729P2PdUzcHehOVrlRzoi8JyIb25P2jwnwo2CL21L+rY3ba461R8odL4A
nctfaXPeyW+2SfCxPVExfWnz3Kk+utB5BMShdiBtjn3hpmG/VujvTpsvT/25
q9i8x1pzKOYaVs+zD9VJfFtqhPfhQsaKz/CMVYAXg5+t4Xxb28GrwMeCa/I9
qiK7hcbScevH9C4FTwTngQczzhyddDzDfZTX17Av0xvyJym3r/9V6P8S2rwZ
/UeTjtPYAf4T/K7mLJQraphD4Gr0t4Obar0Unb1s+1DHoz8HwV9qzI98F/h9
8CD0f6M8Dv2fkS0DNwb/GErFwqeUP0b+Uhpzo/8D5TFaPwVvDce9nDbvTTrW
oGvc1yRezfEs8r2Sz1g32R5D/Rn5qFN/VHNF8J1Jx0Q8kXRsSwE63WVnC/hF
dF5l21jqk8Gzkt73a3DfuOOvpoJnI38MPEV5W+LG/cBDk46RuRg8POk4i6fF
P4DOw+AZ4E7gJ8GPJx1roxxwj3HuY/hdzbM+TRwFcfehHdfz+rjHM2fHfW3K
NVZB56akffufVF4Yto0Cz+H63Zi0D/9CcFvkD2pfdG5NOr7m2xBTNk/XqFTG
EJ51zd3YvqiGY8wTpX63S14tcq4LfZ9GlXmdX7bLGugMiPu//oI2P2f/V8Ff
cdyLtO4PzkbnQs1rwN+g81WIYVsLXg1+vYZ9YGR/l60wJb/KuO/nirTj7MRB
V5l23ivF321L2ZYvfreFiukrs03qd9kj4p4rlaXNgyDOOnG9qBxI+5m082TJ
PqV4PrV9MfLytHNsifPlJ9r5Nm78q3x44j7uZvr8LX1eQN+K6eclsveANyL/
JunrWY78MuTfgn9E/j3yt8AR8ktlvwFvkX84eBf4WsodlM1p/z/0D6D/MfV1
6Pyb9DVcDf4n6Wt4Dfp/UDZDfwX67yGfoflw3M9fXdmtkH+IfJbmtHE/f3WQ
nxP3c6f3ybta50fnZeofihcU/Iru4bif9dp6TpEPpr5HawRxv3PEmTCW+/Rx
ftdx3S+Iu7/1kC/huKto50XqC8DLk36u3k76edS+NwdfUflNbVLMUdzXcyZ4
btLPRZx3+61c99b8P4eDd/PNvJJ9ssE3I2+B/GjwHuRXIc8F34L8RPkXaq2G
8izZeMApcCdwCde/esr/18NaA0B+puba7LuLdq6QvS3uOUFH8BQ9dynrvSgO
45TbfUA2sTJzGrdj378y5jou1/cIfBm4A/jvjPmZV2qewr5dZFMEDwW3AzeR
nxM6g9B5FfltyE+SnxXXtRnbhnOM2pQ75RMsOxE65Sm/Q4fGPdfpgPxY5LVS
fhfrXSoemAKu7T/lxuKBScr/qoZ5Y/SdaVfNXDGFHOubcr9nd8s2Qbul2o5+
LMyb9iMfjjyi/gv4iJTvhwqOm0j5Pu8Bvinu+WAGnJfyfX4q+Oa454N3UhbS
xim0OSTu9sWvcjw6dVO+p3+k/cNTfi6WIR8OPgW968HD2KcYHKX8ndK590V+
S9zztSvBXVP+v0tS/l6o/ZbIG6T8jN3NPTYu6XjFxWoTeUf0F4DvALcHf6gY
urifi7foz/NJvz8/AJ8a9zPSEf0b4p4DdtG9EfdcdVTwXdG9sRT5U3H3f7Te
kynPJW9h+5F59ut+lGM9l7RvyYPoXJDy/LpX3M9uTXR6xP08JcFb0D8z7vfJ
PPYbV8N8Jkvo2+Jyf+/XKNYv7vfqBPD0pL87n4sPJ+73833gCUnHZ/aM+/2R
0no78heS/o6MAj+TdL6KFfRtXNz3cFK+PsEvfSTyfinP8e8En5nyfHwueGzc
9/kQcN+U5+xzwI/HfZ+PA1+T8tw7TZt/0ualstWC92fMs90GfCBjTuxJ6F+X
8hz+bvA5Ka85xGQ3i/tdUR08Ju73wB9cj94p3zODUl4HuIR2irRuljG+MuW5
58UaRyH/PWN8AnhfxtzdizjWk3HfJ9eCe6R8H88APxr3u2gPx+qT8rNzQDGR
KT8v89F5Iu776n+xS/nmtv0rcq432UD/jhwHJE4k5d5UDqV3s51bUvnH3hdv
RnnIXZJrDkzpvCMuEXCvUO9Wbt4TcWOOKHI+EfFhdkDevtx5l8STqXIl+16I
bH7MOdeU51PyVeLKKHdeDR27H+V5AX+XcZ4y8WbfF0rlx7wscr4z8Xnen2cu
bfF2nlluPhHl5hBX55XhvJSHU/g98Knl5p4Qh+cZirUMepsyzh2mtq7kv7ii
wrnV7i/yuYnrUzk/Lw3XYVJkP2TxoovDXr6fCcaBz0TOFaT6+Mg+veK0Hxc5
z5B8ibOLzc+veM7HI/s2i8O/WrG5/eWjnBv8mcV7nw5+zjpWx3LzxYgTOxn8
ltX+hMj+0uLSFx+5/Je30c+u6Hcpd787h1LX/KMi5zgT7/fQIufWEee2OPjl
Ex3PMde+fKJj4Kcj5zpSvSj4TutYEyPnQ9I+X2WcW0284sOKnJ9O/9HwIuek
E++q8qyJx/0j+vB24HtXHOuQyHmghBcVOTeb9G6OnI9PHPFzi5ynT/iWyPmt
5ON9Sbk55YWV20qxR1tp/87IOWnkNz6vyLnuxC3/XpFz24mb/ciw/Tf0VxY5
J5243G+KnB/wf7lWi5xLTnhFkbnoFZ87NHLuOnHaLyty7jrhV4vMma5+3BE5
r57aXFDhPFbad1jkvHrqw22Rc1cp/ndhkTnxhW+NnP9OfX64yM+O8tlcHjmf
oK7n1xnnthPv+uW0f1mF8/HdUeTcfOK//TLjvH7iYF+TcS4/cbBfGjmXn3Qu
Zb9LKpxf6duMcwWKQ16ctv3D83VbwOKEGRm2Kx/uXZFzQemeGxQ576H6qRy2
etY/QOeeIudJFE9ulWL74uueVy5DcdLPRefuIuc3FCfvIPpyVYXzGF4ZOZ+j
9l2fcU5G7XOFbKwF1h8bOVeXnp0nIvvw69k5LzxzedzDm0Kc3f/yVUTOw6XY
Z8VeK2/Gz+LSKXJMtXJnjImcn0vx1f8WOb+G8J8h5ld5MRZVONZAWDHZ2u8X
2tlZ5DwZigveHLOPt3JePBI5n5fk+4ucX0N9+LLIuSPFub+2yLkmlQ/g3sg5
t/4XFxA5t5NiIpqH8g9xT1U4V6X2VY41xW1ncb4nhTwRqj8YOX5WOTP2FDm2
XOe8ge/F9iLHsyi3m2IQs9n3hyLn2FBdfEiKHRRnjjigxLesmGXFLotzVxxN
DSPzREku7iblhVGc8uGRY1zFS7S10LlU1JZiIsXRKx4nxTRruziL6keOYdY2
cfUox41iJxtE5noSPixyHLWOPSpy7KHyhfwU4iWFH4ocR6n/+uci5ylRHOXC
CueDVI6D0ZFjFZXL5KawPYdzrx6Zi1u+uJ9nnJtSuQwuiZzjUu/J34ocB6R9
lUNPsY8/ZTvng+I5toM/K3LuSB1LcfbKhVKV9hsV+55QnpRnI+d7U+xGk2LH
pUtvRuQY8//pFDhepxb7Nix2nL7yczwfOeZduF3IASG96ZFz3in2RPkiFH9Q
kGM/IMUAKdfSC5Hj4pWXJR7iXJRX5anIMSnCyi2jeBr5dD0ZOTee6uUhTkd5
KCZH5hYQ/o576ahix+PfXO68L+rDZeH88mnniGLH7Ou4z0XmK1Aei9rF5isQ
nhI5R536/V2Rc33qvlVeDHEb7Mx2fgrFAP2Z7fwYivdXjoxBQUf4/sj58KTX
NDxDvyM/VGQ+BeXQuS9yblQ9a8ofqnwba7Kdo3BcONbXRc73qpwcD0TOnyqs
XBiKmUpxXlMj8w4oN0a9YnNNCCu/3ttB5+7Iedp0f1wd5Mkc8z2oL79mOw+I
jrsj23lNx4dzGR45d6m+149FzhWo8cN1kXOIK0fqpCLnuFTOj8GRc2IKHxPi
PrszttzB/3JTxvyZe8G3ZBw3d2yIB+2BTrOU40d7gvdW2gb1Q6X9VeW3Kp/S
E1KOK+2l8XPK8ae9NdfWPRBiPysrnfNCvtJTw1qj5oAHtc5Q7nifKjyPj2Qc
B/o8+/ZMOdb1CXDHEFt3HfiwlOMTa2i8nXEc6LkhZrQ/7Y5B5+QQf/cy+PQQ
Q3pWyvGm/dA5q9IxR4qh+iZlH2z5bS+qyX+SMBf4PPCohPMjjJYvdMI5vu8F
D0g439xI8CUJ5/i+jjZfoE+beK5eQH5Hwrm6ByecO1v5tcchvzHhfNuTwLck
nG/7OfCQhPNqPwC+POEc4mPA1yScf3xD8A+X7/gM5HclnCN8dMI5Q8Sb/Cry
kQnnEH8d/EDCuUXeBj+eMKf301yTzinHFN+dcE5z5TK/nv5Pp/8/0f9DlB0p
OygenH3HJ8xt/iF4YsI84SvATybMcz45YS5x8YFPpv1uKccIDwLXS5nfVfEI
jUJM5Ytljqn4X0xKmeNSFG8yLcRWyHdfMQqKs1TMwswy555QDEO9YDeUvfPC
lGOgL6jmeGXFMGttZ2qZ/fXlV7yn0msPmymfL3MsjXyGZ4QYCsUSfJhyDI9i
EyaX2Q9ZvsrvphzzoHgB+a0fV+aYjy9T9u2Wj/enKfuCyz/5pRBvohiNOSGO
QLEZc0MMi2JSXihzfIviFGIpc9y21jpSypy7rcBVU+blPRG8SXOijLl5G3A9
f0+aH3h9uTl1xeV6BPIdSXMFnwD+K2mO36bgfUlzAl8Grp0y7+4AcEXKvL7H
gHcnzSG8u9Lrr5soayPfmjQX6C9J88Zqrfxbjruh3PzDbdA5lDS3cHHKXMBa
38lPmSu4TTVzAp8c1tj/Y7/RGcdx92ffTMp8v9vKzXkr7uD+Kcean6+1UM0B
M+Yxzk6Z/7il1hLZtzRlbuHakTkZlMvmc+7JKQlz06cK7V8iW1Ir8eyB/9aa
Brg5uIbsneIVB8dkHxIHHfiA/mtxZ4H3gRtQ/lvNXFjdkB9HPRf9TuL6BufI
Dsfz0or/9UR+p4svF3kC+SrqL+U5RuJs8d8iL5BtkbJWdefxvZprPYX916Lb
EfnL6H+J/HL0u1EvRa8f+GRwCjxQHNfgYtm2wD3Bkext8nOgjdb8rkN+KvIy
5I3FzwbeQx9uBPcFVyDvLF50cFXZW0t4zyTN49MTPDhpfp/Hi5w7U/nHnyxy
vnLl8Lqg3PkINaa/OnKO4+s0Ti5yvnLha+RLFvYdjzwevk1tKp3vSvmXr9XY
pshttg2yH/jGPVvk3M3KKTWzyLnRlXfqxsi50YWV31gcMFvQvyFyDm7l3Oqa
sX1EHLlTipz7SnpDOd/zEs4Zen3knNFq/8Ui568Sz8ZLRc7dpTFcxyD7Mdu5
o5WfS2sXLxQ5x7eOtZY2X0g4t8GR4oID7+I6/xn8qRSfshn57ITzKMjnR/kv
lEtjX/DnkU/MRvCshPMiZAVfnU78fgm+Pf/z4wm+RvLL2VLmvBungn8L/jny
BToQ7MXyq/kj+CPJD+ffmrYLy/ZaUWifD/l+3KzvcoXtu7LbKmeH8jXUKLTt
VvbcRKFtsbLzFhfaz0M+Fd/Q5vSEcz/Id6NLmfnt6wSfGflaRIX2I5G/R1aw
NctOfVilcxLl6dy1jp9wrqI7aPP8hPPgbAp2EMXt/BjsILKj/JNybINiIjaG
eB/FGv0S7C+yqXxQ6lgh5ffZlXIciPzZ9qccR6H4HcUbKU/PbL2XUo5/UNxE
lZqOpVFMhGJeFOMinsxMiLtRbEh+iNdQ3IviYxTXoXiZZIiNUgzV/grH15zA
7319R8tsp1b8x8LAS9kQ/SL0d8rGFHyQFDPyDrrJhH2WSkIcimJ/CkOsh+Kw
lNtKHDODuCfrROaiUZ6gbwL/jPB/yLslzdtTGjh8xIteFnhvxH9eGbbfy/jz
UGQ+H+mIE128a/drrB43V564x8WJLg62B+RDqNxxQe8g+3ZOmi8ojnxA0lx4
/0bmFxI3+3KuyT+ROYgaBm438atXz5hbT1h87eKKu4/2qyHvG+rZ4J5Jc/Vk
ZcwppP4XBp4itV8Wjn9PjvnDxKc+DPxcuXMl67gnlpjLXX0Tj5+422/PMfeN
zk9+tk1LzNknvndx+4kPfgjyY0rMD6h6nnLrJc3Ld2zgehW+KfBvyH79Ront
u+LcEFecctxVyzHPoXhGZC+uoVx8SXPZHVVizkFxxoqfTOVt6HQNnIrSETeJ
+NMmqJ1a/i8WsL1Vibnota11ibnVdP51wjUbgX5C69xJ/5fiKtS5P51jPkKd
61Dw8SXmwBcPYUz5CQOeWW4Oeu27stycI7KrVc2YW0/8+bUCN5T49rtVmidO
3PWpjHnhhHuUmANf35coY85A8eT3CrbrqfQhg/z2UBf3oXhQnkLePXBIymfg
6hLzJIrnJKk1+/D9urLEHILap6bsYOFYp5SYq07c+7PLzasvO3X3YJeeQvtp
9G8L9V4l5qMTP3++bHRJc9WJc05tDM8xF514/e8Cdywxh7+46gpkWwu4a4n5
/9W3OshHJd1/cT2q7+PYt3/gSxSffyU6dwfb/SWB21D8mbUy5j8UPrnEvHg6
dtsS5x5Q3+qhMybcezkZc4Lpv1CuA/F1jeRY9QJno/6v08NxXkBekTEHo/II
XBR4GoXLMuZvVN+uLzGHpvhwxNupcjz7Xhf4auTjURf9hwOuotyP4di5tez7
sVBjS+Qjgh9Fn+AT8TztlCMfFupnhe3Tcswhqn1fFA5coLpn5EchTh3xiLZm
36XB1ituzzvCM3Jr4PCRr0N9dMYGvKzcfhva984Sc4mKz2dIiblHxecjnlGV
E9G5I3AEyW+jAe08GbCexztCOw8HLp37g/zO8IyLl1RtT8rx2EpcO5O1hkM7
E4Mt7J4S85aKX2h44BSSrfChwDskW9gRGftXiLfnMPD4oHM4eHLQ6VHpmHHp
nJCxz434g44ETwl9G1Ni3wxxEzVD/krSPiQLAi+QbI4rxYGTMX48+HiIQ6lR
xr4cwk8EjiPZ7I5BPi3gccHnRDxLjTP2SxEeEuyBSzn3JshnhPrE4CcjLqZj
M/aTERZXk/xflqF/nPgnQv3Z4PcinqWmGfu6CN8VzmN5jsezupbPgJ8PPi3i
TWqesQ+PsLia5OeyQu895K+F+vTgJ6PrdlTGvi66VvLt0f32FfojAweU/jtx
zA4N79LXA4+TfIPkxyQ+pzf1rtb8NGk76auBu0n+UvLD+R8/U459ioTXaM1W
69tJ218XB+4m4RORvxX2fanEvlbigHq7xPZU5SWRv5Vkb+TYL0t9WK0Yk8BD
Jb8I+fuIM2ptju3S+kYtzLFtVtxUb4EXltgGrHob2QvCvi3AbyTtL9EKvCSc
r3yengv3fM/AbaXzPQWdL5K2/3bK2C6sHBmfBLuw8Lslzqsi27Ps0srxsph2
lge+LNmJ27HvR0HngxLngpGt/OSMbeXKfzEy9GtljrmzZKdeBe5Vadu6dNrK
xhfaXFlim7eOt4p7vn3GbX5UYpu78s58GezayuXxWYnz0ehc3tE6ScZ2edmr
de0Xcaz70WkT93PeOWM/Lu3bBbwmaft4h4zt3Wr//XLn71A7M8P2jYqpCX5f
msskS8zfKFttaca8wcrzckaJuYuFyyLnWxWv5ueBe1O5TgcFTtDzsp07XdvP
lR94ZC5K6VREzs8qvVqR87OKk3BN4CdU/tRlgSNU+XQLI+dMFTfmtUG3n+zF
QaY8BUXlzmHbF5wrO12+eS5myY80cFPWiJynT3hIzHl0T0P/FcWJBA5T5ffb
HNo5Ld9tNge/hk6fsC0vcu4/6deMzFOq3MCVkfkw1f9MZL5T5Yj9OHCQCp+J
/BDyVrnO4/BCzHkelDegTa5zB3wctiuvgfILKO+DdLILrKO8D1XBbXNtF1Pe
hGkx50xQDoLnY84FeTH3zEBxDzE3KQxcr8rPqPyN4nYV53lp5Ny64hQtjpxz
V1yjlwY+0XPQiSLn3FX9wrD9LNnl830Nm+n6R+Zl1f9VEpl/VXmR3w8crcqj
nI7MBys8MBzzbPZdFThgpa9cEG3DOQ7ONydrf/kwK69WvnlLm0bOFSKO0+qB
71S5KY+LzI8q3CwyJ6ryVB4IuSrEX6o8luJMVX6E5pH53lUvCJy3ymV5fGQu
XOHHwnHE/X5sZC538bLGAv+q2hc3qvJqKKfGd4GHUzkuN8hvP8ydlKNYvJ5X
KQdEZL5U5V2tG5mfU/pbAmem5EdEzksie9Ym+c/nm9tzRiivpp0jI/O66tiP
hH6Jc75JZM5Y5STNCVyywsrHcVa+eWDjkfNx6HreHnPOZ+X1KAkcvMpDHaM8
I9+5pwsic9VKrjwg5+abKzYVOT+I8OLA06tnIRGZM1ft5kfOM6LjnhA5h4Xu
v3WF5jvVetpRkXPQ6D8S76xyZoqfXzlKxEur+r8hb4g4aYfG3C/lFmkUOTeN
5I0jc+yLz7Yp7+G+Zb7uymkifl3l5hwVtqv9Q4Xmv5W8MGPuaI3DlVdF+Tv0
TJ0O/gfcMtf5d5S3pYHsX5HzeihXTOvIHMLKdboxbFdukXZFzo/QONc5CLpG
zo2rfDrKFyDcpsj5axrJrof814CVQ1U8ysot0g359tDOF0Gu3CLKr1oWsHLQ
PBtzjt1aReY6Vl7eZiF3rXiPlaNVnNDKLVIaOKKVp7Vl5Jwj4oJuFTmnifRO
jMz5LJ0JYbtykZQFnmedb3PxKsWcw1c5ESbHnPO3B/v+yT7Ham0N/GKBub+a
FnP8gDsg34LOEWqn2NzlmruWKGd10n6/xRnz2yu/2GklzmUm+QrebUUZz61O
LTEHuHQmxZy7SHmLlN9HeZdUb1DuXMM6lvIWKXeP8jgpr5PyBCl/kXI3KD+F
+r8k9F05I56JebtyGyl/k3IV16PeSc8K+Khc5/xpmOu8PxNjblv5oZQ/SDmM
dH2Um2ZO0GtZ5LxR2lc5X5RTRu/t9aFt5QZqi3xWvnMw34T+K7TbM9c5cZRH
RrmelEPq6HLj69H5DXkP8EXobAN3B8+OhTLbuaKmx5z/aiA6f+S7zQHgWIH3
VY6dduH7MqDCa6fD5M+BzgG2nZDrXFrKTaNcw8p91DzX+Y+Uy2ZKzHmHlR+j
aa5zZCjfk/LRKO+z8ms8FzM+FfnesP+7oW3l3fggPHPKiaM8HcrDpTaV92dq
zMe9GPlO5L11T+vaxow/1RxNtsJc57yqk+scWC0i85brO6j8I8rroeflJPD0
fOefrkM742LGyimk50b5etqg80K+nynlbxof8/+inD4vhmP0QmdXOGflgfoB
3Bl8OTovod8FfD7yn/KNLwD/Au4Kvhqdn8HdwBcizy0wvlLvnJh1lPfq6Zjf
OcpZplxgyhumPF/KKab/9FJ0ZsV8XOU5Ui4k5aFSHrGZMWPlRZoR8776nut7
oW+68lkL967qd6O+K/qmKL5BNp+9jBWPKnXuSPnoXpuxfUe4UanjJWTfaVLq
nJLy1x2Usc1G/rfy+5aNaD/tNC91Tkn5xF6Xsc1I+oqxUBv7NBcrtS+49jkt
5BBUO4qbkL1IPsDnZ+xvrzit3FLnoZOvfv+MbUbCF2Rs15Gff2HwaVcuuYLg
h6/8cRdm7N8urDx18s3/lz5clLGdTHXFdOi4O5DHQuyAjnt4qWM/dI0aljpv
pvx3e4e8e4pn6JOxnUtYcS5Lw1xJ8S/Kxfdljn3XJd8J/qXEefrky668fIpJ
UW6+0zK2k0mequVYhkX61lXaz172uGsytnmpD+9V2LYlH/t6pc6RKb/hjci3
ZWzXUy6+H8P1VByM7H57cuz7viX0R7Y16ci+plgV2eVqyq6UsY1MbdYvdYyN
9lf8jnR2s2+/jOMglNNQuQ31P/yDvGqIrZB8QMZxB/pfNlTYlr0sy/mbtIa/
MHCFyc6lNW1dE+Us1Bz22mD7nprl/L+yWShGW7lspD8B/G2FbcffZTnn5Kuh
/fUVtoVNDTxv8h+QLbh9sJGNyHIcgI6l69+i3D5i8h/bl2/ft1cV95RvX7Y5
4Gbllr+W7Tzw0n8dfHy5fTyFtQasPJtaB76pwvkqVFcO+XvCvj1r+tzFeyZu
cPVNHFmKCVFsSJcs/y+yfcoH/tKM41uUQ/GSjO2+8lEvDXEZypmofImKDziY
4zyK8m3/D1yzlv3nF3OuAzO2E0vvsoztrNJTfkbpiADr4ozjPtSmcjPqOIdo
pyzEhqgP8tOT36N8k2RzVT91/8i++0zAur+EdY/1CX4bsq2fG/c9r/9Z/hOS
y5djRrDR1xHHYKl5XeXfrDho+WL0qmKeZ+mI62xRiKPpnOW4o+Vh3UNxRkvC
s6y8mXqOfgCPzTguW/4rQ0P8tfBDGfuKyC+6cfABbyH7GterIfhtyknyGQ8+
8OJIl7wNOhMzjq+Wz0qrsL018jMq7fMvPxPFMhwRznFUxjECkg8ude5a+Xhf
XOrctYrf+LDCNm7JH844ZkE+NleVOg5BvhBXlDqvruIF6gabfHEVxwpoe4l4
azP2o5DOpaWOJ5HeNaXOn6vzfSJjvxad8wNx+/arr4prlk9NzyqOz5Cdvwj8
QMa+H+pn8+A7fyLyFqXOHaw4hdszjlWR/8HQjH2GFGtwSog1kHxIxnF/ssfn
hO0Z2hmfsf1e7d4XYvblGzQu49h8+RLdE2LzhR8Kce71Q7+PDPdYQYVxD/CE
jP08FJvwWMbx7/IpahFkraqYz17++C3BT2XsD6T6sMAPIH+mJzPmDRB+OuNY
e/XtTXEBl3scdWup+cMVL3BTiPfXsU6tdByZ8r0qrki5VbUGqLikleGdfKjE
+VUVj6TYJuVWXY/8nxLHKam+rcT5XxXLdHbGcU9q86yMfTa0r3wrVoT3c1ap
87Qq9uqHEH+hPLLK+6o4jM3o9GDf9UnHf/XMOI5JOWHXljtHrb4vc8L272VD
yTjGUDndvgsxUNLvhXxj0vFQp4I3hWO8HmSb2Ld3xrEf6sO5GcfcKbdsTqlj
7oTfrbC/ivq8r9w5mhWPoLge3ZON5WuUcUyZvok3lDrGR75nHwUfMMUy7Apc
9MJnVjo+SM/Rx8HvS20+mjHfgvYdnLGvkcYtiktTftqv6fOeEuexVRzaGRn7
uggrRk25cL9B568S57RVDNuZGfvMCO8rcWyb9B7P2JdM94bizJQXdx379s3Y
J0f/6c4Sx7zp2Kdn7JOjeLY/S5yTV3h7iePctP+OfK8DvcJ7eB7n1aTc9fng
48r93ZKt+Krwbf2k1P5pN+jdovjjmsa10o5LlL37vVLnBBS+XLFyFebIPbnC
MWPi9F6RcVyYcMcKx4z1A59V4RzKN4JXykaTsnww7Uxj25n8zqhwzsfB+k5n
HMck3ulWFY6fEVasjDi/e9P3kyocSyOe8GtoZyr4NLVDn3vVdJ68Uyucd++a
4Cuj8xVP6Yel9reRzvKMY7LUzoBK554YoHcveESF+aR7VmT9L6/HZfqmlTp3
hmLoppc6d4biZT5HZ3rG+JlSx+PJV215iDPqnGd+DvkbHlvF3B76fjUBP15q
fnLF8zxHG1cHfE6lY3/ku/hixvE48nHqEfzgmrLv2ZWO2ZH83pTjmc6rYh+3
S8PYRv6RwuKPnac5dMr9qahwjJ841T8rda75W8AvZBxnJD/JaaXOzaE4weeR
3xDOfWqp4xL/pyNbRtAZW2r+EZ2nYg3V9qn0pU6FY//E9y7+WfHQ6h4UP634
YS8Mfg7Cyie+JehIvj74TMhfQlyjwldnOaenOGyVu1M+E8LyHZVvxb6gr5hY
xcYuCnyx/wYd+TrI50F8tieE+NkBWeZ6FSetOGYVM1styHOD/8bc0Df5Y+he
Et+reF/V5+aBA1b7zg996J1l/4qc0IetYV/pp4PfheTi6JTvx/xwLsLiPpVP
yL9BfnH4f8+t4thNXcs+4nnNOIZU/PnFFY4HE6f9pgrHgInrXnFhPcO3TzFq
vcPYSXFkvcI3/bsKx8JJ7+2M4zrFCd+iwvFj4oRfmnFcoXDzCsd1SmcM5/4E
57Ikyz7Eiv25r6p90+Wjfj/4fO7V3yocJxpVOEZOz3OjCse+ijO/Hzo/VzhG
tkGFY1l1Xksyjic98/+YOus4qcvviw/sZ2Z3Z3cnd3Z2dwBbsbvAVuzu7u7u
7u4uRGwQFcVACUVRFINWVATEwEAwEet335zD6/f9gxeHy33688wnnnvPCfxa
h3Jp8X+1Q3myuwVOF5Sz2Mn9uk16GeTi9QufE43hIiBGl+fn3jXlf03oouec
qZ6fmzvFPw7nP5zq5HKTx31DpzBaBsSuTGjUGS76deALuuo5Fh127rNnNyn+
kHvTXzlxZsJLRu4wPpyRwT9AvCXvGrNalBP3FOcRziNDB/z6suwDAu/lHDR8
0LV+zT5r55S3Mr6LckVptxDtrpdTrg1j7FUTxof3wSn2QZtubODFow8b1JSn
Rox675zmB/wZ+aE5xd6TG0NeDbk5Pzq3o45x8c2/VZyf58c6Htwp/GjYV3Tc
/oii3tc+hhe6RfXwbtU1p5yfF5wHRN4dOUHkAGEnLy+dU54eeFHOHj79c8p/
gbdzTlmYsZB3wrjIubiwpvnfp6t0oZlbdKLJJ/iwUbkPe3cqx/DRsH8S490q
p7H92KLnOL6nwXFCPBs8JGibUHYD4vPjGju5oFxOtNnJW0SfHd118unQfEfv
iNzZvdGdCf9L/O9hzqsl5viFDuXVgp/tUC4qMehDnHcJHh9rN6BD+aFoGZGT
ugdaM2E7z/9+sk05pMSxN3aTFhL+z4fPRQXlfqKVRB7nnjxjt4lPivhtco75
e3XeZdqkQcO4nuhQHij3o3Q3aSeRlzou8JMdws9xzu56X3Ge6cK4W7e5V9Q5
uEN5wdif6lAuLf0c4Fxa4uoHdij3FrxmTjlo48hfqOk6B6+eUz7gR4HXq8kH
vFpNOTVjA59V1rdB8gH7OLeRddnOuaVcA2Mdo8i3gmVy8qfsOjXV/yHnRzXl
tX0QuGdO9b/PWaHzgskBGNShHN6FuE16UuQFPx32c4w3qeka43o4NfbIE/yu
xp++4XOs323XqCmfjvpXzAnT7io59YH+nInWRjfx75zdoZwI+DTO71CuBb+D
DQXlr9fqFJsIx/gzgb8piCdiQJ14reFtPi7GPq8gzvNBdeLo43nvcL4/+Nlv
YJ3iF/EfXCduduo8OiWOU8oeZZ5w+MC5RxNPCe/0s3Xix4bTHD5z+KvhyIYf
m1hH+MG5xxWL4prn/rhESRxkLYm4xOEEX8gHXhTmvg/fNWWJk2wtqn7upzwD
0Afu1/DSUyf3+vai2n2tTvzVcHcfm1KMJvi5OvFg0+djUorRRht9dNh3qApf
C7deUfrFY8K+Xdjzga9JKR66mfypsG9elQ74FSnFfLcEHhX2PlX5XAnntrXC
Xw/7jtZ9RgN6z6rwA+Gzq3WQ0Wvm+RYd6PvDvoS5wYfXiTMcPvFLwt6tKDws
7LtV9V2Mb2JwuDGf8LntWpXe8z1h36WqsdydEn8ddV4aeNui2kJvmu9q1IMu
c5+iyqLXvFVV47qKvVMSF14u0Xd2zqfQwua8jXM3tCY5swOf5jNWzitP97ke
Z4Gc03F+iZ28cs53OfPlG/XCM9rAOyc6F8bO2S7njNg5qzrU37qPSXTmy7kt
Z9+cAXAmvkvYl/X3/L0SnX9xLsa5G+dbnHPtlujMDcxZ22I+X9sj7Ev4vGDP
ROdo1Mn5Gmc41Mk5zor+br93onMC/DmP4FyNtnZNdJZM33ZKdH6IP2eIq5Z1
vrZPovMmzrc42+LshDOUgxOdoYA5N1mnLJ/9Ep2vcRbFOVSvss6x9k90TsFa
cF7DWRdnduiSc/6ID+dcnLVwjoMeOuc+YM5iOJ8n3oCzoYN9lnR0orMrYg8O
SxSvQGzD4YnOuug/52KcpXJ2Q2wD54O0y9kQZznYD00U40BZYgAW/jZn9fu8
ods9InzWLGtc+yaKqaBdYic4q2FdOK8hB4M9+Fadci1ygd+sE08mnJXwVc4u
igfznzpxYILhwyQ+fsPAf9Qp7nyDwL8H3tca9GjKv0VOR+B5gW+pCn8aZW8L
vF7gzwJ/U1Rbf4fPTXC7BZ4a9nurqnNGSnH6Gwf+M3z2rmpfP5iSHgo6Jtul
lPODfspD/A5YPx2N+H2rwn3D56Gq6oHn8/6q+j8zpXyAjQLPJ2eqKvxl2Bd0
V37AnPh7TFF9/jn+/UGb3s1/4Rkg/HsHnp4SZyNcjvA3LlYSzyNx+HAhwrsI
fyOx/vhkE8Xxw9uWScRzCJ8b/Gx/FcWB2DUR3xrPTzw7kQOAD3kBcITCDfpb
SjH91N+YKB8ATteGRNxu1A9v251w7gX+IqUcCfr8W/T/9qrG8nlKuTr4kDuG
fgTzuX3YfyyKF/XfsM8rqt3/6pTPA19cfSIuUzD8sXBO0gf4J+EdpSx8qttU
dY1dnVJ+F2vXt045XWjNPFin3DM0j9CLJCcNTSV0JJ8qSMsHncEvC+JyeqpO
elXoWC2Xkg4UOk/LBr67U3Z01tCfQrNqGeahUz7oo6HRQ52bpZSfhkYGOomD
CtLyQX8QHSj6s0pK/Jas6ULezqr6AJcUnFQ8GxyWks4P39b5ro5OEZpZq6Wk
QQVGe/HxgrRz0DrkGzz+5OKhG8V4V01JFwmfTVPSh0JPZ+WUdDfo54op5a1h
RxcSHRP0Snh3RlcF3Rfeqb8oSHMFrVW0TPB5uE66KujX7JBS7hy4X510ndDf
6RP2kQXpBz1QJ20g8DYpcWdRJ+/4nxXUFhqvLxVUFp1WdHPQ1+FbBHpPzOfm
KeX7oRWCTiWaPuCV6ENB2lHoS6IHxPWwbUqaQdjRk+JshzOeRTo2YM56yIFF
04V8QDR6wHyvmFpQH9B4nVKQzgvPNgus3YzW88L3xazeB+HmhEcUfk74NOEF
XYX7aU3cnmsEbqzJZ/VEPKL4wEFKTA+xPb0T5dITp0RuPvFexOltkChODx/O
keEahacUTlHilYiJImYJzlL4J+EphW8QLkE4P18sKQ5p/UTxQmDikQaXFOuz
XqKYJTAxP3CTwim6YxdxkNL/HbqI15L6V0rEkUofVk7EbwjP4QqJ+Appd0V0
mWvqW59EcVrks5DnMsuxWFsmiucjLnHTRHGPxPIR30g8H3jjRDGNxEASl0iM
I3iTRNyJtAsvIjylcH7WODe0pjYa3PAxwtkI1yKxdsTLETNJPBxxcRsmitMD
E49H/Bw+GyXiKIDXAE4D4vdYC2LqZlsDGj3un63hjv57P3OxrpmIPwE+BbgU
pjqXZ4tEMZmMl7i7jx2jtXmiOCowMWxzrCOP5js8mXBcw61KbCSxlcRV9i+J
73Wt8Pk65vmLmji1xnRTDji4d5t4/8jrvLBDeeC8n+xgTi1yVi/qEAcXmBxu
eCP5fgK/FnmZfC/dN/yrBfFtndEhbkZyOTlzxJ9vO2d1pBZyANLWzKjn85o4
uDY1zxVnTNu0ieOL/NgLOsTxBd4o7P/l9T51cJs41Djreqebctup59QO5Yxz
trVbd3HfkUt7Woc47sDrt4lrjr7B8UX/OUO/skO55PS/qSAusW5hL/UQJ/Ow
7sp3Je+V88FNjDmvRwuPb1NLcU5tfTv0KNHRA6NzB78EawHv7hMl6cCtHesy
sKT1Wofnz4La6hFlL+1Qjj2cYzn/3T3sF3coD5/+HRj1dxbE0XZVh3Lnwfu1
ibuNfFu43Pi7VKf4W9pFe47vYKwL68OZb8bj2qVNXGfk9F7SIU438Gmd8lmx
TjELlOPseOH7elbv7JuZa70tEa8ue62a+DtZVt/KjnRszHGJv5ll9d2MeBti
bAZ2UfwQcUQnh89JZcVOnZgoPgrMNx/ipYjFOinRuR6Ys5WjHedzfNhvNH8O
fFbHOobnhETnL9RPnMDCOIKsvnctjAvIKjYAfhy4dE5NxP0BV9IpiXhn4Ks5
I/E3sKy+fXGOgw9xCAu/w2X13Qz+GnzODP/DHf9zbKJ8WvoGT84tzqU9JxEn
EjxI8ELc6TzccxNxPoD5ZvKAOR/OS5RHCyaX9iHn0p6fKA8WTM7so85jvSBR
niuYXNenFuXbJsqDBcNn8oy5jy5KxGcEhlvpBXMxXZyIiwkMf85L5lm6JBGv
ERg+nNfM6XRp4liMrGIq4EuCN+myRPxIYLiY4EuCi+nyRDxOYPis4EsihuGK
RLnGzNW7XcTnD/9/RxdxTrF2p4XP7Z16HkM3Fh579APQDkBPAF2BYvisXBLX
eSGRlgF2tAbWLsm/nIj/H60CdArghoYjupaIFxoOarid1yzJp5SIb5x3bTjn
4ZrGHz7q5UviMc8n0jugXfjV4buG+7pbF3Hgw4kPHz5c2NjbE3FJ01ZnIk7s
A7Piu+6fEe5IxC/M/Wt53gFLqqc18EbWR6gk4nKnD/Con1USV/KyYT+tJC7v
ZRLxdR+Tdbw93FCBV2VvloQXS8StDQ823NeHhP0IcNi/4iwu8Ors8ZLwEoni
irnPEptNTDX3QTh/vqyq7GqB/471Ooz5DP9nuwmvEvZjo56jAi8Z9m+qwmt0
EQ8z/YfnGf5n+g8P+Skl9X/pRHzc9LNbIs4s9vjp5G+Z/3m5RPzO8Dz3ZD+G
/ejASwWeXRUmrh5eaPzX7SJeZfzhcEbLAC2E+SlpBZJrzDc39PDQceOdER4l
uKfgVvrN/Eu3Rv1zzSV1SyJOKuzkiv5njprbE/FQwUmFJtoMc1jdyH3cfEc3
BV5g3qrbEvEYYee7+tqO4+3Pmpqz6OZEPFS0Cx8ROlNoS6FVeql1ptA7RqMK
7Sp0dtCCQhPqlUQ6SuhM9Qn7lTVhNMGvr0kDCE1wdN9oF40ttN3Qg0Oviu/1
9IHziMtq0r5C7xiuHjiv4L2BxwourKsT8RnBd8T3f/h04NV5IBF3DhheHc4v
4BRarKs4v+DNu5N9bZ4leLc4cwBzBrGaeZYeThQLDUYXbDlzK/VNxLVFH+AX
Wt6cRQ9xbdTEXYaGOBxA8AJdm4g/iP5fk4izizM1uLng3oK/CD6uu+wPp9AX
5jW6IRGfD2uNThx8P/D+XJeIxwgM/w/8ZrQLFxP6Yswb2kMXWF8M3Wq0ulgj
tLHQPkMHDS2no63T91wirTh05QYwFmuloT2N5ho+6E+hxYYPGlho46GR93j4
9LKu3yOJNOnQjEOHDm04dNzQd9vcun6PJdKDQ/MOrTe07dDSQueOGB/O8zjL
gwuIuCW4x4nXIi6IGK2p9iE+iHxJciTJsSL/kZxN8tTQz6P+pxNpyNGHQYl4
ljjfhOsJXSXaHZhIpw8NQfTXNrKe4KOJdAbpMzpu6BahU4aOElpvaL+h84VW
Gfbh4f+EdbvQ10OfC80j9LzQPQKPSKSFhiba0EQadmB01tBOQ0Pt1UTaY2iQ
DUukm4YdjTP0zNBNey2RPhoYXTN0B9E0fCKRrh7z/1Qi7ULWCL1C9PvQJUQH
EB4tOLXgmEKnEPuT/M5bLw+9b/TR6ANaaWe1arxojqMrhw+6YOgt0i46gPBz
Uef9ibjL4AGDWwz+L/B9iTS20MBChwv9L7Sx0LoaZF2tNxJpYuHzbiL9LzS8
DusqDS3830ukU4ZeGBpV6Caji4p2Epph2Mcm4iyA3+CLRLpWaF19kIgjAK6D
6YlymMmz/jlRLgO5CeR9k+dMvvMvifKvweQdk7eAz0+J8hrIB3+oq3LtyLmb
myhnmTrJoSYnmdzkeYlyyfFZlM+OnRxnNLbQX0OTCw028PvhP7ZVYx+TSKMK
bSZyzNGxQtMKjS10ocAfJtJ4QteJ3PO6ivDURFpX6FXBe4AmFtpYH4W9uSKt
q88CN1RU/6eJtL2YK3SmRlpXbnQirU8wGlijrLn2diJNOvTm0J+C8wHuBbgj
3rFe7TuJdeKapJNFvjo57L+G/Xnr4o3iGc+6dW8m0lZDUw89NbRHaQuNqtda
ZX8rkY4e1ww6WcQL8vsAzxi55NRPbvi5zt3+KxEHBRwH5OR+0aY43tmJ+BHA
5IYTC0B8ADG/G5gz4btEvAfwP5DbTi4/ufbkEW9pDoEfEnEC4E9ON7wK1EOM
wabOzf8+fC50Xvnfic60+a0grgAOPe5NcFHCrwfn3l2JuGHB8KzC5Qqn692J
OFfBcLHCtQrn6j2JOFfB8M3CCQs37L2JuGfB8OyhZ8e9GK20dSuak2/DZ01z
XHyTiCeEvQNHBBwF8CeQO3yCORb+CJ9Tnfs/P/Cx5lj4PVG+Pz7kOMM/gA+5
zOTIsxbkFJ9ZEefFn/zG1rSP5iTiZ4Ajoi9xiRXhHxPxOTDP5MivaE6MrxJx
GcAvMSMRtwB4EU8InAZwlcATwn6H64B8f9olHxm+A3xmJuLugMcD7gX4N6gf
folVzO/xdSJuE/hJ4DmBlwT8ZaJ4VOJaiRMmhpVYVvjxiH0FE4/6krUPUnxL
riimGd0EctjJcyc//fqK8vT/S5S/T74w+c5XO3f430Q58PjXpZWPT53DuyqX
n7LDuip/n1x4ctjJySdPv0v4D6oo9xs9jucqyi1Hq4KcdnLbM8QudZcWx8/d
dR5NfC9n0OTCky9PDjV58uB0WnnflCWfmnx2cs/JjyD3nj4k4TPQOelof5Cr
Th/IpyDfH04AcvnhAgB3TYs3gD7DCUA+NTnXn3VVTji54a1p5Y+DyYl+21zo
5bRy5MlPJ85zqHPV4Sonv5tceGI7RzgvHo5xctjhYyFuk3hXYl+JoSWeldja
jrRiX8HEnBMXi097WvwS5P8T9/t6TZh8d/LfmVti14mpRduimlZeCetOHDv5
2+Rxt6WVB04ueSXwEPPDoP1BHC9libPdpkP+xOuSM47/NJ5DnKsONzv5JuSl
EJ/f03ku6JsQO0xsE3FNsyuKUUb74EfHnaKtQEwTPsTcE7+KDzHMxKziQz4R
cbDEvpIT9LPjWtFx+NvxzGgufFNRH9B0+MOxsmhAEM+Mz/yuytMhl4e8hok1
xQkvnVb+C3gB+9f5JsuklR8EJg+F/CByecj3GVdTDPZSaeWikCvUM62cCDA5
DuQI0dZyacUh4/9nV8X90n9yl8iLIOdi+bRyMcDkWZAPRf4S3+5Wds4U+jLk
QIGJz4cTDx90Yf4zVx6ceXDikXuDRgy5V6wF8fZLO+8GXRvycfDhu+Iazp9C
R4O4ZTAx/8SH8N2VWHq+e/L9E747OAD5brl2Wpx4fKtcJ61cDnI6VkjrOyd5
Rm11yjOiXb7vwQeIHY0PvvFStr1Osf3UTwzeBv7eu25aeSXUSS4J31Fpt1on
3nieHy7pKp4EuBQ+7SpOBq5JYt2JzSaWe5068X8SP79NWrHTYPIyyGsgl4GY
WPIR+GZL/BKxScTQ7ubvmXxn5tsm3xn59giXILFyfKPkO+Nv1obYOq1v0PjD
o3ikcyXQ3SAXgzyOterEBUrM0r5h71sQ5yRnfA8WxEXJ+RecosRi7ZPWd2++
OfO9d671KbZKi9OSPA60JMg9Aa9ZJ25S2toyrTh2/Nf2N1v6z/fbBvef7+SH
+Hs1eh/EJBMbvGudeFCZh73TitcldneXOnEn4rNXWpyoxO6iG0gcMjk2xIiS
z8C9CS5W4pR4nyJeFE5UfNDUID+CnAjyPvo7Nhi9kgcdC40uCXGY1E/89v7+
bozmBd+TwcRFw8HIt350LvhODuab/8OeT84cyc8hTwe+WfIuaBde2Xscw4Ye
IvF4YGKPiVumD8TKkttCWXI63rEuRin87/PacTZ6d0FcmpxRogt0b5O0gdDz
ua9JsaAXMBdNOp8d7/XdvU7xb8TpEedGPB6xYcTXEbeHHS5Z4sG4ZojZI1YM
H/hjbyyoTs55iY0jdg6+yuvD/lCTzoXPdH+IQb3M3D7/JDq34LqC55NcGu65
8HxeE2UfaNL3yasC39+k84Kz0sKcI5zHOjXpTPmctPyXDny2x0sc7HUF+XDW
TAwyMe3EmRNPSD+JadzS9oPS6ucTTYpDhxN1YJPOu+fHGj3t+u+1D/PZpUcq
9XjgD+CtLAhz1nxnQZyrnLHeURDPKmes9xhzXnxuWnVS/5Vui3Hd4rIrBn4g
LQ5Yzqnv69R8XlenOEtiL+F6JSYTTHz1/eZrXYH4Cl8PnOPfVpCds3U4Xp9y
W2cbU/8V4fOkx/WoMfZ73YdNUuKV4x1nWiL+OjhY4JcrmI/l87C/UpDe0xbh
35/f5SbFCcBdCIchZ9az7EMsH9pS05p03v1dQdyG2Dm7f8+/RY+m5YMd3kN8
Dg371wXVSf3vF8Q9S7zEawXpVVEn+SAzmpRbBxflrCbFCj5H3miTOA/hSYQv
kfgB9Ko+df/R//2qSWfuvxbEY0nZYQXVSWzhmwX5YH+1Uz5HpsTBON0+cK4u
3qx4PHJQXgl7T2ISwudl75HnCuLLJeZhQVxvz/raPj8tjB0e3cFNOqO/IfAQ
7+W/w/954wvTwvjAtwvvLuf+QwrC2OHkpa3Nwn6t66SthwKPaVIcwvOun1iC
l93P++rE2/uS52doQRifmwsaFz5zCppPxv5v9O1Fj7FfzM+rge/nvpaWnbID
wz7UZbtW5cM1/GJBdtbx1sCv2b54VWu3dUrcmFN9DZBfS54t/NKHFYUfDp+D
yK0JPJMzWc67A/dnPxbFSf2ly4JHcu8L+xJer/XNl0uc5BFFlcUfHmr4qIeH
ffuq/Ikdvd081bQFx/UpgWfVKWeIPvQLnxPCfgbclXXivj7d+D7zYL+REg/2
WYG/5t6REX6U3z3iFgI/EviYojD193NZ6qlm1C5jJNcDrmziQ/oGnmTcVhXe
zL8z45sUpzGuID5n4lLgdmYPEq8yKfCHTYpvGW5/YmPgDB/nsi94LbjeZhbE
R0rcy5P24TckH+2O9e9k/4Iw9U92u+AJ3stch88GnuJ+DvdYiGmBA3yix0Ju
zgT34Q3vca6Nz12WPvTjmcl4mP0PJKbI9TCW9qp86D88qvSfGJ47zVX+On3w
dUhMzgOBRzcp5m1NcwsTKzsxynY2KxYX/mQwcX3LmRf3irD/GWUrzYq53aIq
zPkIHMVV1zM+LYx9VZfFf+vwrzUrBnhlt0tc7trmbSa+6+O0fnOOC7yuOZzp
A9zO3ZsVc/hR+LQ2K/55dfsQE9ulqPrxn5yWP22lw97DZeH4bXV/tq3KTlu9
3Qd8/okxtnssW1aFmRP0/ND4I54ZDlvOg4hhXp4YJ/+Gf1QQxv5M+H/XpHik
+QVx2BITPteY/o8lZqxJMdvLVYW3S4nn9jvbFxTEl0sfhvC+4uscnlswsUkr
VxWnxHU+MfznNSluHO7ZtPu8njUKuQfBlzvXPiuaw5a46OfTsjOWFauqh7aS
ovh18e/q/Czm7d+C7Mxzqqh+MvZ0lB3m54H3OlX/5SlpLDY16541KvBwX5NX
R7sj7A9n+xtNivF7ulM+7IvXC/Ih3q+e3MkmPZ+8HfbXbb82rbLY7yrIB3tj
+I9q0nPmCPtzf7y3IDtt3Rhl32nSc+l7BfHGY78+7G+5LDzzb3nvNFW1j/Af
UxD/PGt3e0FjZ1xwy7/j34SWqu5TPBt8aH/qecttcZ08zTu5+wbv8Te+ZpaJ
st/ap2Y+YdYUfckGr2mvqjQumVu4hvEh/h/eY3yIUUeHstEYvmLWgph2OJHh
Rr44Jb315mbnIxTULn1AF7PZ/kuZ6xgMB3LR18/QWK9c4BGBFy+KA/nSqGdT
4vmb9YxxTTx3PthNfouZk5n+jDFnMmXhUKb+S3h+I2be+/23gjBt/VJQu9Q5
olP1jwz73z63Ze884N9A7jUXVHX/4n60TNg3DjyO34pOcbODTzW/+uMpcVjD
Zf1S4ExGXOvE5M+Mvq1snNhObD987CvZTgw/PuT8nuU6p4S9HHhV5zP+F/Xs
1qwch2Oib7sYL5ERvzzc8scRq9CsfIGto+x+buvMonyeSImHfjf7/8N3K9/3
4Yrf2e2eaD75x8J+uvHksG9cVLv4pDPiwyfXYBv3k3wEuPLJ4YUrgzze1W3P
hc/yzcoT2cKYsm2B12hWDsh2xuRZ7Edstq8HuPXh2Cceex/z7RN3vWTg3l53
5naFZuWb/BnXS89m5YCQv7mC24K7v6f7wLqsZH+0AVZzH8gDXc197uoxMp/n
ez4/q1NOM9fDZSnloSzVLL2ADYvSD2BdNvIzFc9XU+1zvNdxafvv5f4Txw4f
+v7NygfZIOw7es7/DP9tfc+6Oq7VZ5r0jvZ0QXoWvFsdWZR2AM9LawXeOvBE
ng+rwpT9I+rZyvdQdASoc1L4HO+y+PPeNMjPCUcQ1+377C+tcR8M+6R495kf
uBJ4cuC/A7cFnhL413ZheFRSFZ1JfRL2X9rlD+f29+FfCjwh7D+166zq2LDP
C1xuEuf2nFbhicRItMsfTuyf29UHOKtPLkoHgf4fa8w+Xa+oPmM/qqo55NpG
H2EHz+dfaWHGxTW8T+BP66QXsLfxVsasO/oB6Ai86D2+j/fUX92016bWSaNh
i8ATAh9CTIjnebWiMPbf0vLhuQhdB35DHgp8dFH6DvigAbGV1wLOG/QheLa/
sKg+0LeDyI9wPSsUxY/DvfJg18Pz8OFFlUVXYqWi/Me7zk2NOzJ6JueamZPW
XuM6RK8C3QpyGdCZQW9mCm0Fvjbwj3Wyg19hz2akm4N9a+PJYX+0KI0bnu1v
LErjZrqvc/j/Xw6fU8J+tn3Q37nG9eTD50j7o2eDrs2k8L/UPpS9IfBtgV/j
uTF8bgk8l+cr4qID/xD4zaJ0cLCjhQP+JPyvjzm8MfCrgXfwGNHTuTL8bwg8
NCVtIPBPYX+5qD5Q5+lV9Y35QbvnCPcT/Z6j3J+VM9IMmsZ9PPBhgb+ok4bQ
Ia7/1Krs/KahK3SofXY3Jr8MPaDjmvWedaAx18ytRekTzQj7ycSY2X8Fz+3n
Yd85fA5qVj7aZcb0B22jo1322qL0jGh3f9sZF7pH1L8wZ7yquWVcxbAf47J7
e+z0vymjPlD/RVWtKfcOdJIO9zyfWVVZ+r9H4DWb9bxxTdRzs33QYYLvghzk
7+KaXKdZuXXotazrMe5RFMae8W8mv8mXFHX/BQ/w7yTfEzbLSPcIzaMrot1L
vZcvCP/LjPeqqi2eZwYU5T86Jb2Ytd3Wt2n1mXvTAUXtEfbL0oE38n1qP2Oe
DX4I//V9n9qnKsx9Cr2Y9WznvrOW12iXojD197AP/el0H5irf7qp/9/VSfuJ
/n9fp2eAi5t1f78s2rrQ+Oyi8Lfhsxg5As16VkFP6gLbLw58ZbOeWwYbc53D
M3KTr//hXiP20TVV7S/24ONF6VK9FfjJojSwvgmfMwKfZ9w92j3X1wM6VehV
TQz8QlGY/l8VdV7uPiyXEcbOPrrRfdjEY2Qd+/q3ZVRK2lvnuq1LqmqXMfZ3
f94MPND9ZLxJS5TJKN7yj6Li97pwJs5vL/FpnDXHvWaLFsUlPliKa6hFeRlH
lGQnbj9fi99Y48NKwsRJPlkS7zGx3HCjwvVKrsQr5DHZPs2Y2ML7XD/5IPC1
7tGimMau6Fe0KAby7vDZqEU5IAPMpUzc+Elui3jIl6LObWyfmpEPcebpqHPL
FsVkHh3+fTyucRnVuWr4319SW4wRrlh4Zcn7OCDsG9rnYZclj+D5kjhpyRMZ
kVGf1/e44Gcm7+BVctDgpUzE3wwmpvTZkjidySU5wxh7a01l8f+rLE1NYiAv
jbLpFuV8fcw7aWByvp4xXzTzeY77s7bb3dFzC3furrZfUBIXLnMLJzVliYF/
xXy89P/1sO8duFcirl0wMZ8vuSz2YRnVuZ7HBR8yPNVDzI2M/emS+sBY4MHe
xmt0fNi39loMyWhdmM+rwn5gi/J34O89yDyQbxhjh8v6qBbl7NxWEibnBW5n
OL7JVYG7G75mckbgbAZvRixQzO0pLcofgSOatshzIafmJPu8nRF3NPbhJfF6
k2d0XeBDWpT/8m5JnNTkvLyXEY80eUOvl1QWn0tK4ihm3t7KiJebWFk4uvcz
vqwkTP1wHdMW/OHDSvJnvOh8neJ98UBJml8Lc6Y8Xsb+YUZ85uQ3jSsJkx8E
B/gJ3i9D3R/aqtZ0bbOOmR66ttPx90Phs1WL8pgeM2ZdHvF6safGl8SrTj7R
WGPyj+4idtr29zPiG2eN+ob9tBbl8kwxBzU5O/Asn2o7Oj74kDP1Wvz+DPOz
1jivC/2H1x2+dXKa3i+pftqCy/1Yj/3eksbL2CfZH4wWFJpQv/o57dVm5VSe
aExb7xSl67cwfzbwnb7vjzYmF/XW2Hd3Nes7MLqA6AOSY3tH+NzbrBxVtALv
MYY7AfuI8BlblD/1rJlRPeDb7E+ds4rSypoV+O6ieCFHpsQNidbgNGPs5I3e
Ef15oFnfKtePOvsaf1CUXiF9QBsOO/mnd4X/Q8365vxgURj7h0Xpx5GvisYh
ZckXnmw7Pr3D/rDLov8FJgd5YlFaYNPDPtUY+8bh/4TvOw+Hvb/tG4b9Ud+z
0NICk9f8cVG6WjPCPs0Y+33R58dcD3ph1Enu8ANhf9L33KeKwti/Kkp3jPzl
mUXpi2HfNNodYP++UXagn20+s8/MwPcWNZ/MLfplA1zPPVX1nz7zHDXIZQ81
Jm95utv9knfSouqn7JiSfh/Yp+OLWkfqPyKjtabsD0XpnZH3vVXYhxg/H/YX
/JyAzhl6Z+SDvxT2l5r1LrBN2F9uVr7wqLCPbNaz/Xf2wf5oVT68j3zrOqn/
d/tz3+9fVbvU2S/w8253aPgMddmfvTdTvOcWtafYR/DlDPfz6skZ6bXhc6Ix
edNzi+o//ZnjOinLe8dw+6P3xjyQC/9U9OH1ZuWn7xX2dwMn4YOe2hhjdN9G
NSt3Gz05dOX+CJcFRWHGNTDqedP7dLeMMP7vhc9o2//rpvGSF4+GHFpy5DL8
WxTG/223RX/+dlmekQZF/W97v+yREcYO9wl9Jte7a0k6dNjfL6r/+KMJhzbc
gpT4XdCiI/d8l4zGTv8HR/3ve2+iY0c9f/LbWBQvzDSXBZOrnrbeHPPzpu9T
5Gmig8D9i9zPm8hh8f3rgYr0Zoi1Q38IDRriddGXQZOI+N677EMM2/0V+RDz
dlBFPuCHKtKjIV4OXRs0aYj3QzcH7nTijdGgQeOJGGP0ly52/bdUpDVD/B7a
NWhIEXe6cUX6U8SRnmNtIOIq0Z5Bg4a4AvSF8CEeFU2gY+yPLtWxtm9RUZ34
X2D9GuLnL7IP9hdr0hgidrGf+8+49qtIk4v5QaPnPM/PpTGHy7coX+Yhvrm1
KOf011ivFVuUV3uefXgGuLgkH/KSti7JB3xF4JVblAt8UeCV/Gzwc9TT03Wi
NXuHrz10knfJKScOrfZdc8qL2asiDS9iC++wPhHziZYYOkTEY99dEWYsN9uH
uEq0uk7wnO9W0XpR9raKNI+oEy0kdIyIV7zHGDs6R2e7fvTDzvJaP5zRuJiH
y10/sZ1XWSuKmM9XK9LdIUYRDRk0ochxuLIijP0V6+AQ64gm1AP2QcsKTavm
8LmuIh0o4gOHW0+HGMiR9seO5s39rhPNmwfdh4dcD7GyaGahS0Qc71EVaXUR
L4oe12W+bh+pCGN/oiLdHTC6Q2icET+MZhf6U8Rm325MvCn6SmjzEEf6lDH2
ETW1y1iu8JxwfaJ7hP4RsZ0vWAuJGE50S0/0fF5qnSzmBB2sk2xHbw7NLWKJ
0c9CD454412814jnv9FrQSzu077+8UEL9RTbr3E94MMq2r/scbSo0JEi/vZR
Y+zPV6RPRmwn2kp3eM9eUpFuF2M53z5oh6EVdKL7eZH9KYve0p3G6ILd5Xpe
NKYe9Jnu9lz1sz9xqo8V9czA88OV3lPstQsDL9eifLeZsb/KLcpPPDjspRbl
7u0SONuifMYbM/LB/mLg7n5/GRy/7d1alCN5e0aYXLnVo2ytRfmMxxlj38t1
ki95ckn1YL8yyja1iKtkz5IwOXo/RN8Wb1Ge5meBm1vEc7JH+LS0KI9y18AN
rnO3wPUtyovcwZi8yKmcbbn+yzPy552xraT3R/w7S/KhnmfDp7VF7+/fcc7b
onzPU8NnsRblRcLVsIHfhe8Je+8W8TYcE7jaojzHHUt6V6V+dHYO9/vRmIy0
eLgHvVUS5h6EvhIaPHAFjDbmHWqVwO0tytM8ypj8x8EZtcX7+82B29zuCeHT
aZ87M+o/+Y/ruv+M5YWMfHj3nB5jLLaIb+rWsHe47KHhX3Gds6qqnz4cXtL8
cD2saB+un6+rKsu6/9Gp323uC9dnVD+5ov9w1mZ8Z5Rdr0VcEJcHXtXvm9sH
XsX3gr0Dr2ufv6vCrPstYV/H9mtdFv+noq317XOz6+f96/eq6uQ7zx0l+bBe
Zwdexnvh/ii7rPGc8F+qRbm3r4V96RZ9NxgaeIkWfaM4Pcou2aKc2d7GXKv3
ZlQW+8aun3qGZ7Tv+OZwbkl14vN8N7VLzvLtvpZ4j9s/cC/389+qMDm28znr
5Nrm+crXIfa7M9ovXJ/7Rtmcfa7KCLN39vPeYX/1KGlPgZcqaV3gmdmnpPqp
88ySxkudj0U9a3pP3VAShtNjQfRtLf9WXB/2tX2d32qMzxMZrRc+u5fkj305
/+Zw7c2PelZ3/XyTW83rdWP4rNEibpCrjdk7O5fkj/2akvzBE4p6VuQ5sLGk
50nwTiV97yM/+tx2cQjCHwiP4NI55dHfG88SS+aUn/5y4CWM8cGf/HQ4BZdz
2Svr5U/ZV8N/WT+TXFMvjP+LYV8qp/z3u10nuepX1ctO/Whq1wK/E/avyuK0
JG/36cBb5pSriz51n5zy9Kea9xL7q3H9bJNTPn7/qHPrnPKI4V+Eb5Rc1MlR
dh3jZ8vyIa9/WFljp59Xtssf3tEhYe+eU17/TYG7GcOzCJ/jVcar5cRzOLYs
jP2jwGsYjwy8fE65/EO7iSMSTkg4IMHk9n4YPmvllCc7wRj7K93UFlyR77lO
cjmZf7gd4QQ4v10YDsZB7jPzcHG95pM+n9Gu/sOrgKZ5D+N+9ZpP5vAKNGZy
4it4viwMj8HrZa01bZ3VLk1z1u72sjD+l9arTvD7YV81J07d69u1dszzd2Hf
Nqd852mBN82lFuYCw+G6YU7crf3L0jUnp7tv1LlZTjndaJSD4W340mXxGe81
JTf508Ab5JQvTO4wdV7Pe03gje0/KXzWzym3+pp2aa7DEYFO+sbG55alnwFn
xXmBf20R3wU6QGC46bYrSxsI+xHtwnDcXRf2jpw4Iq5t11joM5rUaKXB4fNc
+HTa57Ca+kDu89Xt4sCF/5Yc6nVzyqeGB3ddX5PfRtktPCdPhs+O3lOvhH0H
r9fQsuzkvw/3d2N8ngr/nWz/2WvBHnk87Nu57K9l+ZB3f0RNdnLzfwr79jnl
yD9RL4z9d7dLnR97/snp/sTzvKj/6xnD0dvLYxxc1p69xfbeXjtyyXsZT/d4
4Qp4oixNesZ+XbswvwOsdW9fPxPapHcCJ8nbvg7R+Li4XZyk7FP0EdFJhCNo
XqzLRcbocKGLBB/gMu3y4bv9d+FzgX1S9fKH1+insF/cIv6iHwKf3yJeo+ds
p+yokrQL4YTsGmUvbRGvUUNZGn7YazXp8MHZyDdq9Nr4Xo2eE7pO8DeiA/Wo
r59aWRpscD+2GS/ihKTs7ok0/ijL91V02B62HX00MFyR6Eb1tw/6kZd4LMu1
C/MNf5DHzrkA+n3oXfId/pewX9YinqgXjPFH9xI9O75dp8rStINLE508MJyZ
6AOi8ccZ0IiS6oQ/87+SyoJ/K2mu6A9amegScnbzlTHzvFS7dDPp2+NhP7tF
vFjoLd7sZ8gvvS5wgn1RkqYhPp+XNJ/M7aO2860bDcSz3dY3YT9nkX9GbdHu
NNvhDZvhfQ1PF3y3q/h3r4e1t+B7RIsLrTQ4NtH5Qp+U7+QfloTh+UTnER07
eEFbjbGXy9IFg4cTzVL0HznXQDcTzTz4PNuN8UEXDw1Tvo2jY3qf25pQkh0f
9Le4zuECWrssnTvwW75P8TsPj+8Kvqe8WRaGZ+bCdvH8wvGLz4q2jwqflXLi
pRljfIXnZGX7v1MWZn7QGqNd+D/zZY2L8RbK0gGFN7Wr9wicq2hNPu7rH/0z
MJyoM0vSngQv5TlnTdGne8JrhG4aunjwmqKNOMDXQ0/bKTu5JL1X9hSaiX29
B6tl6QxiR9/1Qc9tU1k6nvSzvix9T/hR0fdEt5TvbGiAousJ7yuaorf6mvy6
pOuBvr1dkj9lsx47HLBofd7ptX6vJExbaJ3e4fqbXT9l0bm+3N8ZDm+X1hv3
KbTn+D2E0+mGKDu7We8pBwWe5G/sL8cz52R/926JtsY1ixtzSjxDfmT8QlWY
b/sHRNnxxvX2hz+zIfCH9i8Hntqsd8xi4InN4qvssB3OzC+j/k+MW8P+sfF+
GdXDd86VSuozHEGVwFOaxbGZN+YM9Iui+o+9UNK4wEOrqp/v8IdkVD9jPCzw
p7Y3lzQW+tbkfsLb+WnUOcH2a8L/y2a9FyxdEobnednA37hvx4XPTNtHVoX5
Pt8tfKYFbuJ3PvAXzXoH6R7482bxkfL9H59Z4f8mcar+Tn5SRpj6fymqLc6t
qi7Lu/xr4f+Zy7aXNC7qfLGq/rO+Xxflg32F8PmuWfxO10X9XzfrvWPJsM9q
Fh9yz5Ls4BPC5yvjn4ryYVxvVGWnP3M6NS7GeH74/+1v1+PD5x9fGzeF/Ydm
vTvfEvjHZr0j/1ZUf37zecH37tstxmilrVpSWex/hv8cf9uHt2pus769rFFS
nXBY3Wk73FOnBf7JeK3wmdcsDqu7wv57s95Vzwj8s+13BP6lWd8HuoT/r/7G
/m5VPuD1SvLBfx37wCu1QUl1gseG/2/+nv9PUe1yjnBWRnZ83qmqb9hXK2lc
9DMJ/IfLZkuaQ/jiNg38b7O+A29ljP2jqGeB53yTsP/ZLG6rezLCvHdvEfa/
msVBt6Ex79o/dqos9gvD/z+v1+Sos65F+6tUEuadcRu/P/JOul3gLi3i43om
3lPmR9m/wr+X+08fciV+VOSzeUnXBn2eWJWdvdbH9fB9eNvAXd3WORnVST0X
Z2THf8uS+kmdW5X1W8fz3vCoc7rPjL6POZ9hjBYneq/wOW9eFoZDDw1VNEbR
UT2jLIz91LK0SuHWQ+92tjG6qF/5noU+Jvqq8F3Do/VPi7jvjnFZ+Prg95vl
e+u4NmkzwMuH9i76p3BZ3x+46PeOh43hqTsq6iwFfotn17L0J+DiO7pdOt1w
Sj/p9wjerU52ndSPduoPHhfaqrQLNyAavT/YBy1O+gbHIHqfjAsOQDRfvzbu
5XHBib1bWVrDcIWdU5a2KXM+uU06gtgvLAvDE3hku/RY4eWe2Kb3Kd6V0FD9
o0XvSheUheGmO6pd9dMW2qoLXHansurB5/yyNAjhyjuuLH1S1gUNU/RJ4VFE
W3a253YD+7BGVwcueG5PsD9jHN8mDSrWfVKb6qeti8rqA+NCM3Werx+0bvGH
U3Hxkq4xfvNPaVf9rNc54Z8LPKOLtFMzOfXttLJ0bOEtvDlwk9+jLy1LLwS+
xL3KWl+upX3L0laHI3FKm64B7PCQp3K6BvY2xuce10n9x7SrLFzlJ7arXa4B
dHgbc7o+C/DrtijW4rOS4jGIwTgmo30Eh/aCjHx4vr0tyjbkxMd4Ylk6sOAb
bOd7wgn1Gi/249vlQ1vonzDGs8J+SVkaKvBAHlCWZjz2j9tkZyz7oJkW+O3w
ubBemPfl09v1fs03or5RttXv19cELufE5Xhqu/DosD9Y1lrACXlE1JMP/GbY
z/X+wn9g+FRz4nu8MnCL/R+xnXfM04jldn/gma/z3O5rTP/3r9dY4J8/NHBz
4FGBz3K7XHvn2E7915ZVJ+0+7rHQn2PCp+L+n2+Mz8nt6hv9f7oqrnLuR/19
9gRXyQs1nT3BPTKirPNBYsY+irIjcuIxu601nlFy4td6J+o/y+/188L/TH+f
OZNrI3A/nj3K8oEjbpVW+YB7tsoHrrn14KrKiysJHZvTc/p212o7ce//hn/W
+K3ALfbvUhGGu6kXvFV5cR+tD7eV/dcN3JgXP9I9cO1yDhj2G2uqE/vwVvlg
H9YqHzia7qupHjSPukZbpbw4o1ay3jc8eH/EGM/xPKDzfa6/gcwK+yk58d0t
2ypdIfj35pflA5fgqmE/LyfevHFR9vKcON82Dvulxh+F/bKcOOsyrcLYP7dW
EfWv3qo+UOcj7WqX7x5vRNmT7fNm4NO8LrPLmmcwmuVne13uDXxCTlx5M8sq
y3e2/lHnScbH14Th91sy2j0xJ/7AEfXCD4b9m7Laog8bNmje4Mt6n3yEvPjH
3gtctH2N8OmSV07Er/Cb5ZUTkQ77Hznxwv3YKh/yGp6DO87+Q+wPt9WLcGS5
7E+B/8vJZ80G2eHUmk/uQ148aUPhyLK9Pta3khdvWE94rvLiDVsMXqO8uI8y
cFXllWfxbaswvEbLNsgHHrDF4VzKi2cpgQvL9SxVUZ3494BLKi/+pa9a5UP9
S9sOXivqTDyWn1uFyddYvUFjZ7xJ+Bc8h6/CP5ZX/sjaDcJcw73hPfMe+a9V
GH6z0a3aL9jXgVfaZTdo0LqwRu+2qn721J+eK3xWhccvJ16sga3C5Jh8F/jf
nHJM4OxCD4z8lMaK1h3+tGe9LpSdHXh+4HE8W7bq+odX8GvbmeeVG1QP3F8/
hP1vt7Vag9oCD7Adn+V8zVDns3FNXuG981699hp7ZItW2eFjbA98eE6ce+XA
h+XECTYxruFDc+IEu6NePnwr7rAP9glhv8r1zAs8yP2/PXyG58Q9uHXgq3Pi
G7y/XXVSzyZhfzonPs9K4INz4iVrDXyI6/8s+nBcTlyd8Fgem9M30rz94TR7
uF0+7NlX7YN/9/A50uN6MHyOyOnb9ZSyMPaqfeA6u61e7XKOMDfwwJw4RX80
hr/xPPcZnsx1Az/h365TAz+VE8/hD3xjyYkXcb2wP5kTFyL1gOEyPd1lsZ8f
eHBO/KhbBn4uJ97UX+qF4ZNcM+yPuc41Aj/q396TjLF/Xy8f+vNT4Gdy4vbc
IHwGuN1NW7VG9P/CwM+6rcUDH5MTH2Mf21nHs12WeTihVeOCC/SowI/kxPM5
p15jZyw/u13qXxJOvLx41abGnB/t+rtF2aOMuwS+KKfYm97GcGl+EPVcnBOX
6TD/JvO7ulT4HO/1HVyv6woevPqw72vcYgwnXnPg/XLiwYM/9sKceEffjf7s
Y5+1WmVnfv4O+/m+fz0d18yVrjPbKsx1vlmrrnnWJe37FP38MOq/xP1fv1WY
a3udVtVJu2PD5wKPt2urxoj/P2XZ8bmpXn3m2/vd0Yf9czq3agj/vd3n0eG/
Z078tHVh38t7PAm8h+23t8uH74qFsB/o/XVv2A/ydf5Qu9aFPVXzNQAP57iy
fPBvdP3UeV296uc87t/w2d1jH1ivGCqel4rhf4Dn/JZ6tUv/PyhrLNib7ANX
IXy2R3lv3tmudWHsi3mt4R19I8rultPZaKpVGO7cQfXqA/iGes0P4+3pa497
zUqBV86Ll29XODl9D53Fe2hOfKpvw+Wb02/+R3C65sQdOjHwN8YfGsNHemur
ymKvRJ2fev9eE/YZOfFwdjaoTvCNcN7mxFNaDfu0nHiSrw/7lzlxIM9slw+8
u73i3WGlrLgpzo3n1RWyikleJyMMn8b5xMhlFUu8XkaYXOM3nMtGDPaCeo2F
OuGFm0JsFTymGel44nNzTX2gb5dHfz73WNrC77OceDtHtArzzHln4Nk58aZO
g+s1p/v+D3w7zYnzdpbtcI3O4Ywvp2eYL8P+a06cog8G/iknntWpgefmxGua
NMiHeqbbjk/XsM/LiWP2i1Zh6n+4Ve2Cp7dr/pnPK1o1z3CKvulxgd8I/EVO
9/Szq9IjJrZ8TNine73aG+SD/9ftGi/P/BPC51uP/e96Ya6fq12WNf2uXeOi
nzfFWvTMKsdtbJvaIv/ulGh3mazy1J4mfiCrPLvTwr5sVvlxlxflQx7cSVX5
kCN5bODFssrJ6kZ8Tla5qEdXhclXIi8bn4X518SiZJVjdXDgzqzyOk8IvGRW
eVLHw8eSVf7as1VpBP/lmFi0nM6O+p6pKqeJb2sfWUeY+NjXi9LAIp8LXem1
s4qdPq+o+skzvaioPpBPN6woH/KwzimqXfJeDymqb+ST7l+VJtdDUU9btF3L
Kqf1FfLassrrvDp81sgq1vqMwMtllWtwLfmAWcVaDykKk4O2UdSzSla5XRdW
tb+IRd+AGMus8kYvrgq/Gfbniqqf3LFnAq+eVa7cpVXVQww8eWSrZpULdmTY
u2eVm9ZOPFtWubeHVtX/R8LemZEPOcVnVXVtkLNweFX+5B1fV9RYyAO9vKr6
iZO/sqo+EE9+XVXzQM7FVUVdM+Rd3hzX4as58UJ/GniO987Hgb/zdftJ4G55
cR2X4rexe14cvO3G2JeE9zgvzuQUXKl57c0yvFX26RZ48by4kZeG49Q+n7fK
H3u1onrAbfaHJ3afVr1T83z4aKt+H/hNOD7wBzlxOz8Z+MOcnpObG4Sxnxz2
j/zs8YwxnMAt4TPOzyentApjfzrw+JzeF3INwti/Cfvvbvffds0J4128QWOE
a/qDVr0r8dy+HNy8gWfxvgOXb178rjuH/0p5PfOv0CAfntv71+SD/101+cBD
O69V9yDuR3NbdW+ibKffm+CenRH2Jf0O1bVDmN/YWkXzjP1vvue4n7egde93
ur7GcIuNi3qqxhs36P2OsZwR9gmeqwXt8uG+1grPc158ZZNaVT84bzvcZUX4
om3v0SBM2X/j9/B7/06+4PrhZz4z8ETjmeHzbk4c733DPsa/8w8FfjsnzvN+
gUfnxJEOFzr+IwM/HvaxOb3jzKiXP5zw/cP+nu8vV9WE8Z8c43rHbd3nOvlN
PrxVdtqa6WuA99Nv+fabE0f6lFaNBW7t8d47zPO9rfLBnmrQ/sL/s7D/aPvr
gaf6vnlxq54NwJPtwzX2iMdOHy6yP8/qBwR+Iycu97sDv278SuDJOXFZDw48
Kad39kKDMHN7btin2KepQfuIPfJS2D/O6V241CCMTznwJ273ipow3N3nuC3e
ZYoNqpN3n6fC/r734LHGG4Z9fLv6DCf/Pa36Psa+/rxe/ee72V1hH+W5yjfo
eqD+Q8L+ltd6Yrswa5pt0FqjAfFF1POm67+/VRj/B1wn83NL4KE58eRfa8wz
zy6BX7H9+6jzl7x4XH+rCMPR+mvgn/PirV2+TRj7t6xvXvyrXxnDvzor8OzA
q8CXE/jHvPhv3zTG/4G4b36bF7/uDPvDDfsdzzB5ce3+FO3+5LIv86yVF39v
uU0YjtnDYu9/nhfPcKF7/GbkxR/7bZT9Ji9+4MXbhOnPMm2qk/pnR51zPa6l
2tQunK5zK7LjM7JB/aQs3L/olKNRjmY4GE7aI+Cgpp6Yw8Ph7PVZ+ZGB98yL
m33HBvnwe7h/2HfLKyelG1zEfgfcF/7hvPjt94GTMy8u/T3gXrZ9mYr84dI/
2PWTL9ADXmXXf6jrx+f7wD/kxVe8RJsw80//v89L9/zrBmHG0orOe17cv5tE
nf3y4sG+Iep5KK9chh3gbXafD6kIM8blK+oD+C37wym6u8dF7saMitaLtTsk
6p/qNUXvLFsQVzA6aOhvwU+7qzH8tNu2SZsMHtqpDcLwEm/XJo1nOD/Pi3qS
gviQi23C8H+id5YuiI93WoM0tuDg3cp2fLoFbnFb6HC12Gdzzg4K4grubQyH
8H8xlj/z4v6dzPfDgriUd2yTdhv17NQmbTP6/FmD7Iyxo03jxb6NfeDC3axN
9dCfj/lG57Fs2SbMGPt4vHCJD+U53Nd/J5qSefW5uzEcyiW0MvOaq+UC/5oX
f/LnFc0/a10I+8d5cTu/yO9eXvzY+TZhfNinX3tPwY080/W3u37W9FXb4fde
Jey/5cXDjK5cvder0ibMWH5oUH/4Pcn52mO8WfeH+ZwV/ZyeFw9zG1qZec1h
tU1jx35Eh3xot2Yf7KsHXpAX/3N3uMq9jzrDf6e8vq/2iT5s7We8HcJnq7zy
VnYM3CcvfYrNAm+UlzbBzhX5o0+xU+Bt88pF2rxB/jwDtMFn7me5joow/q3w
urutAXFP2SIvrv5KRXbayrotzhH+id/ndfLi81kr7GvmpS+wR7S1Rl76AnsG
Xss+ewVe2z5rVITRWTgw7BvmpZvQuyJMztpfrSqL/64eO314yH2Dj/rQKLt5
XtoBm4TPJnnlcD0T+Ka8eO8fCJ8b8+LDvz/wDXlpFpwUPtfnla/0YNhvzivv
qW/gW1z2aftQ9oyKfJpcDz7w259cUZ34DKioLbjxT3cfaGujwEflpRNxcIP6
yXodFHjjvL7bN1WEF2pMBN7U9t1558/r+/lWtjPeXODNjMkbOjIv/Yvzjckt
KnTIh7nqU9FckWe0TYN+w3le/b1V9bNeC1q1jrT1ZMzz4XnpZawWZffNSyvh
3Ch7WOAF4b9v4CPc7oXGjPHsispiPyfsB+WlH7F+2A/2up9mjDYEuWyHGh9f
kf8Qt3VIXloep1TkwxptF/ZdvEeWqGi/cD86oCI795cDA+9s+97G5C0+W9N9
kHtir4rGQv2PwQmQl7bF6Q3Cd/q6PcR9Wz3898tLF+PMBmG0JI7z/GBPB+6d
1znFncQw58WFtX/498pLZyQTPhv4mj+gQZg9taHLYt/T+5e9uV5Few0dE847
1jV+IPq8vutkr63nsexjjM9+DfKhP2tHPQe4z2eFfX/3+ZiKMHthncAHer1W
rmgv4392g+ysXXuHfq+4ftBS6eV1f6pBuYfkG27VoGcDfmdOdLvUeZ73Ajmq
aHPyG8h9KhW/h3/lpR2wX1yHd+Wk6/RKPFve7W+JS7QKY9838D1+tjzYGDu6
YPfa/6BWYTShXo167svpvG/pVmHsBwa+38+uK0TfVvW6H2Y7PmhLPRD4mcCn
xZz3Dfxs4EPD50G/p5xbE8bnrMAP5aS39Vq9xsK32YvD3s/P3se1CuODNtnD
gRcP+zGtwmhyjXC79Hm3BvWNd8/fwme1vL6F/hB9Hp3Xs+J9aJPmpUnB7xi4
e8ztqGh3eOBJXaUBAUYb4uHwGWH8VuA38sqvfCnqfD2vXMLvjBfpR4zM65lt
lMviMzh8XvPv4csV1YP/6PAZZfxa2N90/XOM0ZV4O3zeyiu/dVhFGPuHjZpn
zp3fadAYsb8ePm/b/xdjtCfGhM87eeW9vlERxj7KfVj0nD/S4x3ZrjVizveM
+bzT7zuTYs6H5KSl9XvgF3LSttsmfJ7P6ezgqlb5oIV3ZeCX/N1yh8Av2s6a
9vc6flevMxfwu+3yQUvrMtdJ/c+E/Zqcvqtf0qp2+SY5Jcq+bP9f63XexLnP
B+H/Wk76a5/U69sRml97tMq+8DtSvc7y8Lkj7MNsv65VdfJuNbZd71mUvck+
fBe9weNiLJ2Bb81JM263wLcYv1wvzJnjc1HP9Tmd671A3LvHkmvVuDhD3Cnw
jTlplpVa5Y8e2Yv1slO2R9jvyEmvbdvAN3jsOxvjv1Xga71G2xtT/3atahef
2fWaf87adg37bZ6HIe0aC+eGu4f9ZvenLfBNxvv7eqAPe7ss490r8O22P98u
f8a+o+thDofWy4f6X2rXWNj7p3TomZzft3lxfY7J6312dOB3fd0+GfiFvPRo
pgUektfz85fG2HfskA851J+G/dm8dGpuaxAmH/mxsD9n+/YdwsTJfBb2Z/LS
qfk68Ct5abhMDTw4r/edEVHPUO/lZ+3D88ywsL9s/HDYB7mebTuEaXdm2F/K
61kXbZ0XA3eGz13G9Hmy+8Az/LCa6kQj6b2aynb6mW2o+/ZF+D/vsd/RIMxY
prvPjPHPip7nmc9pNd1H0EyZUZPWM5op/4bP/Lx0bVaKe80feWm7LAj773m9
C6zZJh/uR3Ma5IP9xwb5UHbD8En5neucGHsXv1u1tAljn9ggH7RsVq3ot5rn
q08qOsfhXaYp/Ccbr289a/RZpoTP055bNLL/zaue+jbpaKObM8njQuNmY5dF
w6WxTf7gXvYHv9ug643fwy2izkfz4jF4L9p6LC/dpd8Dj/UYx0f9H+al1/Nh
2D+yz9uB38tLA+i9BuGF+i8NKov9HZdFI+af8H8/L+2eMcb417WpTnR/ugT+
wD77Rd/G5aX31Bz2SYGXDXvXwOM99gZjymYCT7DPuIrKYh/cIDv1HBB1TsxL
R4nzs8nGkyqyU3a+9yD9T9wuc/5XRX1jz35Q0z2uu7+9vOrr893weTiv7wlv
kdOUl0bVMPvwTjrKPoz9poq+XeD/sv35jjE27I/kpXv1kdcFfLvt8FTcEHU+
7rXbMsb1RF6cJOPDZ6DH9bExmlMTAz+Zl+bUhMBP2X6QzxPZg+/bh7m6s6Jr
g3bvrah+ym4d/gPy4jO5pUHXJ/jBiuzU+UFFfcP/pga1Rd+IqSYXHo1i4p3h
xSDmeaXu0vYdFP/OZ8WlDo86fOpg+FnhyYZ3fhGXNhjua7Q+7rd9VqMw2h/o
w6ATc53t4FVS4uqGsxueb7h40aiAj3dx4wVp8crDaw8/7leN0gdaFR6ewI8F
vo93eeONU9IMQTtkkWYIGA0ROP7h+kfTozkrLnt44+GzBy/if4UTlnOxPsbY
W7LqAxzyYHjq4eylz+u7n8wVGD5btCzQyVikfQFG8wI+bPgoL02JhxI8Ny1t
jUEF8WGiwYLuC1y/aAKgDYBmAv7wXMNdCQfw07Z/36iytAU3LfzCnJHBrbuB
1wt9lcc9D1vbh/nMZcXXf3VK6wuenxZex+ve3Xi+/eHxh5Mfnn7wIv5juH05
g9vOGPsgj+Uu+zNvv6eF13A9ncbYP4vrcKVyzEvcq+9Bn7asPLWBLcLY8Vml
LH32z42xDwq8KjEoYb83K7wMsTNhX43cP3LujJd1/SsGXqpe9dPutV1UdnXX
MznsSxNnE/i2rHLbyFkjvw1cjbLvkx8Q+HCe/Yyx355VfiO5jeQ4gtttJ2eS
HC5yJcEdYf+IPAbiqDinQAvX/SE/bMX/mQfsS3hcK7j/aP6g/XNTWloZXOdo
WKD79LCvebjq0VaBF392o64HrrF3bO/nfdrXPuw18C2uh313A88njaoTPSkw
7aKjQR4SMejEn88wJleJvLdly8prY1zLuv/kui1XVh7cJ8ZLhv27Rl3bXDP4
93RZ1msFryP5TEu4LcouH/ZjAk81XtL19zRGZwYNj81S0uIA9/Peec77Dj5m
9FoeTkmzBVzJ6Pycc/TWjH4fDjXGDo/zeJc93P6cS8P3/UhKvN1gztupE+0W
4kxmNEoPCS2kk2ynLPpI2K9Mi78W/nE4bOEbhncYruJqVhy7cN7C7wvPL3zM
69oHDl7wHvaH13bPovhse7tOOKR7uSz8wO1Z+WBHHwatmnJGfNWH+vcQjupD
PF60R251P/nNR/frmsBfNgqvnJJWA5oNi7QgwGg3wPXepyi+dzh9d/VY4HqH
cx+eeDjd4fiG37uclT92NKnudJ1wtMPnDr87c0I98NDDy7ubMf5oWV2R1pyD
0aRgXAd7Hft5LCt4HvbxXKEjhJ7QpWnpDt1k/JDxcilpjqE9ho4Q1wN1Egfy
ssuiJTTO+5o9zpzv4/WCXxzOaOIxmrLS7UAHAW0N8C9paZugcfJzWrzgK9gO
XslrsZnxL75XruL7VNX4V9/v0Gi5MiWNBTQe5tl/ZfuUbacP6CmhvYQuUjYr
fQi0IdBwAMNHzp56zvuI62pJ29HeQYOnv+994M2j3R9i/gcXpN2ENtRg3xOH
uC3sG/seN9f9YbyXp3SPXt73a+YKDZsrUopn2bf4/3zt+/n+uJExdvYR3Nl9
7X+A91QvXyes9XFeC67543z9E1NEWfzh1T7a9YDp8w1e90JW1yGaAjv4nkvs
ELoWPT2fg3wf3zSlZxK0iDbxuJbz+sLvvq/7Bjc2HNloZDHenvbht/Ep29Ft
e8q/k+Nc5wNelwH+TZvi+9fice3dmVUeODng5NkvVlaO/61Z5W+Tu819Ddxa
r9xf8p/Lgd8JXDTGp+z74H3G+L8buBL4sLC/Z1ypV/3kkJNP/WI8w+9XkDYf
OeWt9rk5q3xjco3JsSbXujnsN2SVt0/OPvn64Ca+SRAnVVZuPjn65Opn+dYS
uEvYD+T7njH+1FlXFr/BTcbNroe2yOkejCZpQXrBb3u8h3IOntU8kO/MnNDP
Qr34GOaUxMNwTVZ4EacCXAxwBVxsjP3ZwHPJXSTGNvA/gRvrxW3ws/2vzQon
9apznuu/yGXheXid/Kfow+qen3/DflrYb/Q8MCfkZDe5n8wtudnkZZPXTn57
yevb5HFRlvlsqVcON/7FwG8FbjFmHuAFgBOAtcu5nntdJ+v7pv0PcZ/nebzD
A6eJfw37G4EbA+frlY91S1n5WS9nhU+qFzcMHDcn1iuH7GbbyeuCL4bcrh7G
J9cLw/8C38tixtip8zbXT34VeVnkNFHPbfYhT458PPKxyBckb3B3nhmyyvEj
v488PPCuYX8+qxxI8h/hX4GTZed6+ZBDSL7eH8a7uk7y98jdW2BM/YOzaov8
xLz7cL7ngfGSi1fzPMCZU3b/ycW8Kat8fnL5WS9wzmtX77W+1Tjn67/Bc85a
/+v9MiT24wEFaW5e0abrn735utfo4ERtNXjv9A28pddxZIvwonxEcl/JwSSH
jFwy8sbIk4ODhly5l6LsjWXl5FXsQx7ZCF8bXHsd9j+uXvmq1wc+vl5lb/C6
s3Y3uB7+/0b7HNeuf5PbuIqfJdDu4b3gR3J668W98YPxoNjvexakZ/p0jH2P
grREnw+8l/EFbfIBD4uym5X/P0+X3F3yNEeRp+j9OMp7k3n7yT74v9Si/E9y
P5lD/OFDeDnsvQOvyHUVeJ3A+/G7yvtm4OX4zh32tWxfvFG/n2jFPtcin33D
Ptg++MOlAY8Geb73Z1Xn8u7DuoH3T8R1gU/PsA91Hw4I+wCPHX3VB7MaL7+l
37r/K/k+wr0DPpi7suKz4Bme520wfBhwmSxRFvcFPkvYDh/Gkr4HTTZe3PUs
ZX98lrId3MNt8b7DexnvbrzHrcF1whmQ8bIe44buJ+u1kfvP78+mgVfl/pWV
D/MwxHOyvO8d+K9cr9xl8qLJUWYeNikr35ZrfhPXM9J1sheG2p8836d9vfH+
+FLM574FadeyjuuXldN8ReA/w6c+8FWBFwTeLpF9fuCTo57rsvKB0+b6rHwW
8db8VdI9kevnb99H8PnH9Vxjnwbfj34tiefnavuf0kUcOb/4XgOnDrxC8AnB
BfJtSe+bA4z/i2eeq7PaO3DOwDfzje3w0My2HZ/Zroe99n1J3CZPG7PvLnJb
W3u8v3iMQzx25uTKwH8EznAfjDk8qCCd2UsC7/M/80kOPPnvz3bIzr74ynbm
uUfsl729x+FKgT+lLewvBu7la4DroZf3IPtlfe+1wW0qS1sPueyid/Y218M3
ATB8R9y7f/N9nDkHp7mu/BvL7+pgrwX253xtoHEM/9DvnoerPXbW8YUOjb03
cTvhf6DnYclGYZ5VuE5+91yRk829CQ4A3sXQ+kXn9w1/Z0P/bnNivYvint8s
K45vOLfhtwbDHQJ/NlzY8GAPNcafsvBlw5XNO/739oc/Gz6OX1Li5ADD1QG3
94/2h/Mb7u9jzaVNWfgQNs6KX35WShwhcJ3A6bJBVrztcLPD3T7V9g2z4kaf
mRI/OvhA2+Fnh1t1Ic9KUTwr+MDPDtf6E8b4L+SzL4orfbzbhV+F/sDVDkc6
PCXwlcDRsl7YxxTFQ79uVrz85HrAfwyGwxu+/HftQ//hjofzBH59eL3h9B5t
vIfrhH8fvn18xtoOB/8Y21/xvDGH97l++PPhoaf+/TPiCP+mKJ5wuN6/Kv4/
rwz9h2tl06x8FnGZf+t15xqY7XWB8/4T1/mCffCHf322/dElmOdrgz4w54v4
e+C+getmsjH2Ls3SyUMjD13E0b4OwWglDkxLmw4ftN3qArcGfrVOWpdoXqJ/
+IbL4l+flc8iXUR80E/8qVF1bpuSJiRakmgwYn/b3x/+C3ue7zBp6V7WF6VT
2pVnqqI04P5oEp6Slq4j+o7PBZ7XKMy3brRh0Xt+Ni2tPPTzpvt72ge2v2vM
t7WkWVp6aNgdG/UUitITRBMSXUY0GTPRh2LYv0prHWf4OnwWbffwOT7sa3dL
pc4NfEJa8/+Jr/kB9j/Y3EJc//AXbZSVBsCXKeGZ3gsLtQW8R2hrustu3Kj6
eQYY3qF2wbtw3/c3PcZS8hoN8FhmpSEwUv+Hhr2rfRgL/PRve48wn+96Duc2
SmtzO39L4Z162cDTG/VdBT13/PEZlJZ25Tte0ztcJ9zj6GCgh7FI+2K0985O
WfEcwXEEJxD4iowwXEhwBE0zxo4/XEjsFziNwIu4kOFmhZe12fhK81IwJ3BT
PBprdFr0bec68RbDXwy38Q5ZcUWxL+CagluKdYFTCo6q88Jn26x4UeFEhRsV
vIi7CM4dOGr+Mca+XVb8UPDPwBEFviAjDIcUv2PjjS/w9UC7lwRespv6eXRa
nFX0DQ2fobHWp4d9l+j/GuFztq839ArgOYLjaI4xPEarhM9Z4XMce5b7T/w5
N+yNtu/Gt77AZwY+1vUscFm0Dv4qSr8AfSfsaAoMalO7u9dJnwFdB/QXmB+4
veAC4swKnmg4nDPG9H/HrLio4KFi7cCXea7gEct4Tdu9vg1eI/ilx3kt8KGe
Dq8R69XhdfzUZamT3wp+N9DqpSz1w1cEh1DOmHsWGiT7Gk/yvexhY+y9s9Iy
QccEPRMwfGMvxDyc5z0+okOY5wSuGXjQ6OdHxvjDrQvH7j6uk3anR3fWz0pz
5RffO9B4QN9hZNR5gd/72Edv+F52mzG8/mjxodtB3tlIY/QfyEtDt4/cNHze
tJ3cx7dcD/fHt7wfx7hdtDLGup9c5/TnA9vRHhnv/nMfgTftosDbZ8WtBu8T
12redq5zeNzgYWL+672P4GSCHwq+pjrji70H4YCD/401LXsvTHFb7E3aKnrv
8I33+pifizgTzOp+h2ZIr6w0aeCCY73Ae2eEP/I69jXe2/xVXA9wQzFGtDHQ
xaAexvur7+9z/by0XuyX86PdE/nG2yjMuo91WeaHs1G04Tkn5d6a9+/tErZz
L0PDfLzPgMDoqQ8O+8+NwjswFVlpP6P7zH0QPMn3xDpf278YY8cf3Wg0o9GI
Bk92nRN8j3vP7dLWf43S7kW3Fx1pNLbRkv4n7PMCv5+WbvbPvvd9Y4z96ybp
AR/p79XgD9Iq+yv3gjr5/Go7PmgJv+7vrr/Z/qPbHed7Mf1EExs9YfqGtjka
42iNo5c+LezfhH2Anz2+KkgnfEG0+3Xgp/z8MK0gTXvmZ0pBczXZ9oN8xoTu
+yL9djCa7/Ojns9s/6xJdVL/X41qd3RaZ8RoLf/odUSTHp1wvuejZc63/XZj
+p/KSrf72JTWBTwh7P9Gnb8XpNuOHY3wwT5vZbycvX7VpLVgPqkHze/nvF4p
z8lcl53gPjMnh6Q0h9T/YVra5n8YczaEZjZ62egx7liUZmJbVniRViTajZz7
rG2MHX1FdDHRWzzIGO1Kyu7ievDZxfaZMcY7CtIHH+Z2OZNCBxh9ZfQn0Ynl
LAktWc7r0f1dpKuMXjL5vDy/oXmMnjDf8zfy/trFPvijybxpUbrMaBRvXpR+
cSkrvEiLmHo421rFfUCLtn+T+nlVWnrL6DGjX0z/Oc+6MXCFe2vgj7x2870v
2CPzbf8l7JMK0oUHT/YeR9d9YuH/9d4neq3Zg+jNozXPmi7wXmh1W5ynfNik
Ol9ISw98iaLOejj3WcLX4aruM9rRaC9v6/5XssKLdDK38xr94OuBvb+G7fig
N70Dz6UZnSVxZnSJ87W3tx0N1h18DbzbJvt9nkPeZ4kV+TzwrMBvem9+acy5
1SuBt/AZ3MuBHwn7UGPO434M/5dsf7FJmHMufF60HR9wn5TOsIYUdJ7FGRb4
Hs8P+5RYjs/d7qNpXc9ogqKPik47eu3osaN7P4rflsBzGoXZI7PC/obtw423
TunM9HV+c9J6l3nd7y+UHWk71/xI14PPCNvr3Qc0SdFjR5f9B8/PUPezMSs7
Wu1v+Zl8kPfyWK8d72jvcR3yGxW4Ofxf5F0mK/w5v8lNevdBs/t7l33G9paw
vxT+fxvjzzP/e34H5H2Kd6jtU7pOeD9Cx5XfpTc9J6zFUK9RA8/zftdjjDXP
cyPP8B4L88M8bJPSGLGjP8+5cA/PwyzXz+9eE8/59sna5+KUrs/u3gtf+Hrj
vsDv2/DAT6T1HlR1n6nnx7CPCfx39GFO4IHs8SbhMb6v/eR2Zxm/5/va3MBH
pbTf5/o+OCHwJ4EfD/9ffa/hXvBKZ4wj8Dtp1U+7h6V0D/qUvoX/pCbda8Af
B/7C96A/G4Xf8O/5dN/Xphq/4XvWjMAHp/QeBx6VVtmZrgefmbZ/2qQ9SD0T
3YfhvDu3qZ+H804dZafaPibs37v/rGn7/+yR4b6eZwQextjDPj3wa8bc0z/y
s8RQ29mnT0b9rwZ+LHy27ya8pa//Dl8bmWa1xfUz3fWzRnMW1Rlle4RP2s82
45vUZ+Z/nNdimOf8W5edbjza3yWqfi/mmpkd9kPdt+/dn+6un9gq7vvf+brC
H/y2fzdmG7+QFUch/ITwEYLhWYS3D35AuPvQNUW3FW3TXYzRPkWvFf53uN8v
NoZbHX3UwfY/Nyu8SAsX7Vi0Vnc3xk798KrDqX5OVtqu6Lqi0QqGw/7ssD9R
knYrnOVwoH+akXYu+qBog55qPCXsZ2Sl3YumLT4P2o4P2pxwP55mjP3MrHRA
4UVH/xP8cUZ6v/1K0vlFx5U+oAeKfz/78H17kPu5gzE87eiWoFOCRslqxqPD
56SsNGzQr0HHBoz+Kjp11xmfnpU2MONCUwX9FfRT1jR+J3xOzkp/Be2Vg112
Q8/bk55D5n+I1wKNX7R+J2akG/yk5xOtYHjn4YE/1/hzz/kAjxefAbajXTzQ
9bNe4EXav2jfonu7o/E0r9F9bpe5RUsYfdU+xswhWrj9bV+re9y7a9YmqAlz
DsXfSxlz3g0mBg/70vbnfArM2RPnXMv8T9llbN+6PZVatibO2MXi7yXiz1Hh
M6lFuIfPd/DhvAbNWLRjv8lIkxY93Uk8q0Q/W2riFC3WhLlOZlTjnlXTtcd1
CJ6c0f/n7YNedP5/7AXXA/8o+JOw7x6/w+016STsGXhx922NaLcj8DFddF6G
fQ+v0SNer7Oymk+0oBt6pFJHxH6f1V3z/6iv8818PdDPs2xnT1H2Ma8F/o8t
snvfoRHwepvq3Dd+W5aN35nDA29QJ73cR9wunCjwvMBdlLjP9PPysHfWpEe8
a6fwnxn9f80+XPPX+zonnqRmn3R3rRnrtSb3djh5G+K3insx8fHhs6Z9roox
Ju2yw+nKfrz6f/YgGF0h9JDRYEavGH0DdA7+yYh3H8594gOxw8sPJz9t4UOd
T9gH/6uy0mDgTAo8i29oGZ1VoeXAGRb4S9v5/Znq3yJ+02Z5bmkLDRX4aNEx
QM8AfQN0fdE5Xqjta/xz2C/NSvcXOz4f2X5JVrrF6AWjVzze9eCPVjSc/2hE
g9GCvs9tEXtzRVZ9YLyPe+z/+BpAW4J5xmeq+4lONfrNaDcfYPwtY89KTxr9
ZXSewehmoIMxwhg9Z3Sd0XxAA+11/44dbPwdv7FZ6aWhKXC9yxKLgvb4i76n
EH+CzgSxIoydeUC/AG0QNEL+cp8/85yf47Ew56fbB30Q5pD5RAMB+2cuSz1o
aSzU0TDGzvWATgYaB9Q5zfPzSlybB8c1uned7hdF733OCtFg4LxvhH04d0Pb
+S6v17HGaEqjXYaG2diM9M3utP20rLXhu0jLHYxOHdfGvb4eTjD+0P5o16Ev
hgYdeqjo0KE/do992CPob6FZh44lOp1vZqShfZnXcT/jURmt9VVedzQ/L7X9
xKw03tB34x53uevBjjYhuoToE17pfbeq2+KeyH3tRt83T81qvCu7n3e4/4e7
//RzWMzhYTGH+8Q8Xx/4UL6T8P7VIczvEr85U7y+w8PnEPvc42tmnn/bPy7p
dwl/MHrdSzfKn3NSrocptjMnl3i8PMNwn/0yo7PvF4xZL3Tp3jW+5X/GcrvX
9JSsfBbqhvva4Npbx/6U5fcQfbVFuutowKOtfJQxduaKOtGSo85b/cyATg73
ETRxuNcUfX/ht7FkzLNB4nsWunDo9pGj8Ven8GJe30xNGn+rxG9suiadwZcz
wmtGuzuHb33t/zXMwejLz62q7MiM8j/+dv2rRj1ZtJfg8Azbz/GnRyJ9g186
pXGwbacwOgloHfzaKR2Eb6vCaCCs2F3l82HfLv7+qfP/dfDA6OJtHX/Piz/X
ZnTeBOZspYvL0u6IqvpwrZ/BGmt6bvmiKry67+/M1XNhXzbKfhr+Q1LiRfus
U9xoW3DPiT+P82wcff4k7LPD/m83+cNLtkGn/JeJeibE39Piz9Co58Dw/7xT
/HIfVKVbgGYB2gVgzkE4Y5rjMdK3LtHWM16vroFXiXYPj/7U1bR224f93/iz
chf51Ln/XaP//3VqXOgk/Oa2VrYdf9YrVdP8cJ10dVn+v4vnhLpT7gN//+v5
XK67xsW3F3J/aJu+Mc9/2wf+rdtq4t26CU3Y+NMt7unZJmF4Dg8L33tr4rUm
9/z+mvLft+wujJ1894W58Q2yPWAf+LDhxYZXG64pOKfgad4qyj5YE0/CIax5
4A0Cz+qQD5xU6IoemFUeU2P4X18Tx1GXJuHGBv25rqb8bjiZ4GaCj/bymjAc
TX/wuxf4N2LD2oXJ/4Wv6XL73BT1j+imfsAHBi/YRg3qIxhOsH41/RuM3ia6
mw9yr2nU9XZ41L9x/L1lTdzp7Lvf7cP6gtHC4Lpire/LSPsRjUm0Jcd2CHf3
nl2o68necZ3UD1fz3TXxGzR1F4aHnL/vMT68U2sKvxrzfq/t/H2f1wvOcvyp
j+vxL//O9Ik674x/nxU+h4btDmP42OBlW6VB/w+Gn63Z/mD+D384nHmWGOnn
h406tad6ZhTLPblT8djM1abx55B68dhv6nnbvKb/e4w4upjbTezD/29mfEVZ
mHJb1bTn0UTYxpi9z7ps7nqmxNyuW1NsJ3Vv7vlEV3EdnnsDr8g7B23U6+8V
/axLH1Z0PR9GPavWpHNEbFjPmmLJ+P+V7PNxizD1vB/+q9Sk43BIN+Ed6vW+
s7Lrn9ChPnzovm3iejb1PDAnx3VT//eKsqvHnJdretfjnR/M+zt/t9rO+yCY
/8/HNV+pSSuN50Dw12HfO3Bb4F6JfNpsB1dt552o5Gf4VwIvV1M8Ie9x4JX9
TtfTdrQm13M/mfP1a9KgRHtxg8AHMvYO+aA1eVg3zedO9dLQxH+femn59Qq8
X+BPw793TVp+C/X7aCvsn3eoTvT4PumQP9qFG/XQt/wfu2v+V6tJPxSNsLUC
71avmJnZnYqr6dMpjB7F7tGf6Z3iON0q/v7W96kVoq7vAu8UPtt0CnNuzvn4
D53i/2Rf/+B7BFyg33fqTLB/1PlF4LXC/mQ32eEIHdQoO3lJD4V9YuBSRucO
4zt1BjE6+j/J9gOq2jvkQfwd/uN8v1u6u/BdnD92qmxd+O/UTWX7cb5fp/sc
97hlugvDjzqwUe1eHnj57hrvvJRiJ77uVBzF2x2aE/o/LvDqNWlWHtFNeJd6
7Ys1atJxQ69tDduPQofUc86zBu/vPONxDaxdU4z0Md2E2YPUzxqh48a+oCxx
2jvSl5re/Xk2AHPvq/MzDHWmAs/wmsL9OdP3+neinq8C7xlle9pnQkrapqv5
2tu8U/59vL5feq2fRVsn8Mjwf6ybMPXs2U11fh725xrlj4YU72Kv/c/7Fxgd
Q+I2Xy3pOwYxxugAbU+uQZQ9syzNlEFZ6b7wWzHXPsQh31WWD78bdxCnX5YG
Lnpr6K7tWC98juO00c89y/4L9WcCb0OcbVb+/HYNzMqONg25loeXlXc5LfAh
gbeoV87doWXl3z2VlZYPOj5PZOXzhPGh9n8y8GGBn+wiTJ19wj4w5n+3eIZf
l2+/LfLBjn7L8e4b4z3dc4KGDBo229nnRMf59+OcsawchNEtwot0fnZyfP58
Y+xjA+8ceN3Aj0fZg8q6LzwceNeyckDGtAivZ/9dyspzwYey6AQ9m5VWK9f8
py2qZ3PXebAxWkAnlaUT9HRWGE2kRo8FrZx6j4XxoonEfKKRiG4SukroJaHp
hHYOWjaUPcXzQJ2nun58TrX9e5elrXfdf8ZL7PSRjqNmrY8NvHXYjwx8ZOn/
NcnROF/S38SOKOkdGe1xfNAib7cP/uifH12SBjoY/fUhGemQH+t6+tgHe1vs
kRNi3Y9Iq91jXOdOcX2eyFlnneKv0KF/PKPvq7v7vWkt48f+j6mzDrO6+rr4
dNwpmLr3TmC3mNgidoHdYmMiKKEYqNjd3Y2B3d1dP7u7u7vf9WEtHt8/5rmL
zf6e7n3OXtmLbZq9GzzzG0S+TcH89PCPw7O9UcJBvkm77/8UWozhxG5JXNz1
OqPbaSBtKyfvN9WZa337YHjUt273uuiqgvmfeINAnwLDZ8V9+51zJx+dnSOn
jnZJmfNWi3bCW2Pu2+8aOeGMSZhwYY1Of6S+dkkb4M42PI7cx94neEzOij/O
WRZp3qbdHPHtwddLvkPBeUHOfmTryOnLO6btddDfo0Odbpc66gq+MeGPEl6w
0u1kVMqH8LeNzhKpI8qZN1ZrKfzF6t2/RgTDcQQH0pR6c0HDtw0fNHL4tuE/
urdgHd6PrBod9O8rmHMavmnwdR3mnYaXDI5tuMngo742csKEV2m/vD1Bn7cq
9xQsJy64weEghxOc8ZVxdny93yXBHc47HXjS4E6DW2mv6DCuzhKdCcJ3FMyJ
RR+fNWEiv6vgb+FcI8yzIoerGf7pySmHq5JH8j6twzxUvAma2uE3TbcUzN0F
bxfcVmD4oKapDa/POXCt16iHSj5VOqNLXh/DCUXaTst80RK7EmtmdI+IPuto
9FlXj8r/geFS4w0UfGrk/bSUD2GeHgyXFJzZcGOtGLx/vd8KTUs9UuZTUxek
4bzYtpBfnjzyLbzLcC6vFLx/yuTK1C91fWXKh3gvj84TaW+M55T5eamvuwvm
uuPt1UvSGSk8lHlQ5bZhyg3uMvjP4DqbWrAOvFpXRof7isi36PD7fTi44BKD
h6smGJ6uF1qsA75E+ht2mDdtn27PfcQF79wGmWt4T7Rmh7m+L5T+6h3mqmNe
Ay9a7/mOvgM/HdyDvMPiTRY6a2QefDgYfd6sDU99/Rw8I3zi4u3SH0kDb9b6
Gv02inm5IuUAJ9qzLU7/UvXmNIPbbO+U5wWpa8ofDL8Z7+wuTDnTXy5Km2ce
Pz39AvnFafPD0v7hSR8W/ckJ/8KEyRn+pzkfph0y//IW7/usc1jz4J9ho6ST
Mt84czfp3yx1+mx0tk/bOD9tj7kefbgH4cHbJPhS6WzaYc416hS8TOSbJZy/
ow9HHveffxuoMte4ty06jKX6dlnpbMmYmTmLswzOMcBrt/uOK2e8I3LuyjkH
Ov2Vvge7dvSRr9Pue48Ls54RvpQzf8nXEx5UaZ7MdSLH3ws8lxfU2e65bs5y
tyhYjh+YzQrmEIUbFLxU+38cnnBqduU8Cv5OzijgEV0q+r9GB304SJdpN7cp
mDDP5my24G8565i1xTpn5wwEflDOQxZI3i9Omof/PwzvJvcq4eOF+xZe2k+D
4RaGM3audvPJMt+Bj4987mB4U5doN7/queqD49TOd6w1vyvctHC8wnk7T8Lf
oOBvW7NmWD/rh5laHM6ZCXPJYMoTblTub8OPCr6QPVrBeSH93BFdNXUBv+hy
Kdt56eM5h0cfrtO+1CP4ojrjNVPvVcHI58u3xLVhwek/IWW+XOqL9KyUtO0g
/Sfb/+NzhuOZd8HYfZ7IOfaUgnWwR5weHfQPlPzpdvN6Yx95Rvi7yP+Xb7Ft
PR0576/hoV87cvSxp7AnelD4yzrfQ7hD+OM623Zva/c5wybBH0XOXmlDxTu5
YBvTR/n29nbzuR8eTDicadzZbvvI5sGcY/AtcWGfwoZFGrCV7Ji8f1Pncng8
+MSkn3TOITxM+NyU7fKpO/rI8pGPLJgrF55czodXbPf57aYFtxN4e/9KXZwX
/ZWjA14xcuprhWDWNjdkrcKZPzaOJRT+2ILtO3OnTh8W/qrO+JHUHfVIXuDy
PqBgHfi7STN5gZ/3wdhrsL+g82i77X2c14Fn8IfDF85b41OCkY9KXMTbo7X9
7ulT9J050jfxFQN39bHCYyTfr912h7n07f7CiysNa2neGY39WPPOCUrPLsLD
q90G0Hkg3x4gPFeNbVVThB+sMz4wfYcwD4j+rtLfS/jeOpcV+ksqrtlaLJ9T
+v3s0YQXqbStfIzwbdLfib1wu/cvw6NzR/ZH6CxcaTw2+n3CuwnPxhiuvIzh
HpTKYe3gtZSXnQvWwT4zi/QnCd8jPKDP+R0l/TlbXD5zJS97B3MmzDxyZc6H
N2/3mXBr8JWZa0a2ey+DjXKLdtvmyAt7sVulMzRzEGfL53S7vthzLR39adkT
jQxmTmFvxdx0erf3buSllz1Lwpyd+Vd4sUrfIwLfV+e2Ojl1PUfyQl1QDuNS
VtTRvqkL6ndy2na7ymTXlOHJ3ca0jfnSTigr4t03ccEHPkfGaup0XOqLct5T
eAi2sEaP+evQrhTXou3m3N64YA5vbFtwYiOHC5uxfUj67PfBp2WOg3ubue+n
YDi94eheLPrsleYTPrHOfX+x6DB/IW+v9NtJuM/hQl9PaZswwO+JBinv47kf
qDyuX3DfwffRRd3WQX5ht3XICzqzJBz62mzt5ovHbjhb+t0niYvy+SLzHXME
dj3yfmqd63ThYOaR+ds9D+4iPF74zpTnBOE5Mg9OiHxm4YmRUy97/L/+tWvq
er3UBW1+dMHtH/1Zo3935BOD502/po83ZP6dWue5eL1geNoHt3vu3qhgPIPj
nbzA806Zz5+6GNTivGAnZd5foN288Hy7YMJBDj65zvbNhdIevgmG+50zkAWi
A/cXHGBlfOhm7cdbpweEf81bJzgA4RGEQw+OSrgq4eiDCxEeR7jvPiqY9w7O
O/DSnf/x3YHhttte9b4qe5Ba8+PB+Qf/3SmSr5a+TJjwFE7nKEy8cPNdG/kM
nr3lExe+mfHFjI/lVwvm/4Mjb0HuJivc4YrrTP2umfYGXxzcdVcpnI9ZYyQv
5AveWbhlDw6ewUO4XNKJPnmHG3GhhP8HNiL9rpJ8LdToPC5cbY5NuDbhsMW/
LFyY+Jg9MviFenMJogO3IDqrRU56Vklc8EDCDQlH7vXB+O+9PjrPJxz8C+Nb
eErKlvL/rGD/tsS7oNK2stK2Qa15dFdKfvl2xaTzk4Ix4fAt/nPxnXtTwofz
Ex+6+MnFRy76K+XbYyJ/KTprBo9K+SzEnYcmc0LABwHPIRyNN9Sbs5G6uzEY
Tsfr6p1OeH/h+nulYDmcjPAQwnd4TeTwFMJRCAdgQ77dJDrIqXf4GuEr3Dw6
Z6SuaxM+vBNwUcDdcHDipXyQw0vxe4N98eJfGB+98CXCZwmX5U7Bd9SbcwOu
C3guwPBz/Kpv3yyYlxTuUfwW478YP8enJkx8AsNH2p/wz0nbxh856Yf7EK7D
lxTOv2nD8C7Cowmn5MQmc34Qb13yQprpF3Au4kuZ9KyWdvtawVyq+EzGv3Jr
yh9uxqbUy5apozPTblvTlpAPTPrheIRj8qZ6hzkw+nC0tkVOXVSnvqYkzfBG
bpB8kZeXC9aBy/LTgvsC/pnpg1XRJxzqGm7bbRIvPJXwcxY6/+O8LaRPTcm3
9F/GjaXSL+BihZ8VXtx3C+aoxk84HJVwVcLD+Yjkj3WYj3LBVuNjJX9M8mc7
zKH5g8bOdVWmQ9SeZ1W5dg0w7ww8t3Dowiv7hPRf7jDHZXu/siudYbUO83HJ
D2fN02qdU6U/OHLimkf4kQ5zbz6qcJ6JPt8+0/EfXyhpPjPtH35T2jbpf0L4
MPZokj8sfHS9+w4covSL2kanB34ieFrgoYG3ZePoEO8Vkq2j/9uk1jzAcOjS
hhcXfqXD/MAPKK7bhA8Vnk3y23MO+aTkr3WYY3Rmye8Q/jRnlbdHf63IDxNe
W/jO4Af17V0d5v0kzFujP3/yQr4eLrh8Dk16XhA+WTqPF4zhGt42dQGnMHlk
/PmzwfVC+o+SfIh0Xkx9ET7ldlzq+jnOFmscJjpH1pgfFZ7UGRynYNrhIq3W
R06YtJMThd8qmNMUToGFJH+a86J66z+d8GmHc3Wat/y9gnni4YiH53zOyOGN
Rw6fOf7t5xV+hPC7jWnD8JnDNw+nOVzo83SaA50w58m3cJgTFzzmk6L/WL15
iekX8Pm+XzDXO/7Pd4bzMfPaLsJrCG+k9rBIo/Eikp8dHeQLN3pOZ058R/L5
kk7SNn/i+lr5HszaoN5xDY78nj7rk/cPCuaJh9cYvk04OPtVdx+yLu005zwc
yPAiz+ByXyRphhMebvjHowOPMlzJ67V6/Dw1YynrAeaFzdJ3jktfe6rD3LXz
Z95k7zA5YcKjfVnCJN69hBdKmZPmhRIv3L+LJ53zKIzlKbtar20Wz7qIMBeM
Pu3hqbQN6mKJjFHNSkMP80qt8z4k6yLCGZLw9211mVySMJdIucGjS9uDH3tC
k+cjuKLgq4fDHo7lSW1qp11q2w3GJwlXKq7lmizHd/Qw7lB12Xf0HtFBf582
y48W3ov7V8GEc2q+vTT4mAaHc1rC3yf6VbXWwX80vqMHKa8LdptDaXnpn9Fl
X9DrSrY4dVFrH9j4wj6iwT6nT0/4M7HWyLf7tfnbY8PFRJjwQ5G206J/sGRL
DLCPmkH5dmWFv5rivbbLXD3w8FwXjK9rfFXjpxquknvxWy35OfjVFh5Qaw4K
uCguk3xEk+XolBT+nN3ml9u1yZxVpAff3vCKtSfM+7vMgXJe8OUJh7jw8w8f
HeHASQfnG9xv8NF9Hwy/G7wWcF1c0WAMpwX+2+EXwi8/fvjPjQ5cGBOEj095
Ph59vl2ryf7H8T1OOsFXcpcMf/xJJzoPRz5aePbu//jxwPCyLSv5EV3mWdtN
8iOF/6kxPxI8SWeHW4kyhwsJjgL4DE4L/9I1kd8UOf78DxG+VPjkBnMUwFsA
j8FKimuqcC1ruTZj5KtKfnXiuj76pZTJVZEfKTyty5wDU4TPFa6Rzv7BxzfY
rzn+zY+LzjmRr9BkjG9z0nBJl7kGiPeqlPlhSXNdrfElSf8xbU5bI3eJy27n
8MShc0XKYeUmY769MO2fNkPdHSX8r8pzd+Gjhe+i7wsfJnyn8FjhQ4UP5g6d
8OFpq9QLdXFo2jDyQ6JzWDDhH5e6uzCYdjK0yW2GeMclDYem350pXF3rNF/e
Ze4GyhZ8argR4FFbNOk/It/+HDmcjeclL4clrmOFD0/bOyby8W2Wk4bzIp/e
JrOWOKXG/WK2tEn84j+dceY36Xze6buFcJnCewq3aa/Kft5uczY2NZkLHL5v
+Drg+ZjBNwKelnV7KWv7NzQ+FzvN34EcfFu900CY8DC+Lp2urF3hnIR7Es5G
4p1PeKVajw9zR36mdO5UmtskH95kPDV8O/DlXCrcl29J8xmS3yr5JdxvbDMf
Dzw7DwSjf1Z0CPOBhAPPziiludxpbhbyAmbttH3yeFvWMzNn78M+CAxPEXsc
uOThK4FnaZbO//iLwPArvV3wvAMnEXg24fNqPE/Nlv0OYfZmPwXXSk/nf1wx
YLhU5ld+V2ZvX2veQrgMf2vwPrQ9+1PWfp3Ct2S/0JW6I48dkTMG3pW+QL0g
h5NlVL4l78ybhA83R3X2d+zpBicNxMv+i30i3IWMgbOlrn9K/U7nG23zmE+d
rt1k7of2zGWPB8MjAU8GXBLwXcB7cXWDx94nMg7zLfpXpR7hRoIX6eFg5p2H
MwfBefRUwoRfa6DWErMOMG8gc82jmVMuzBzEGA6XJpyacJ+yp2FvM4NLE8we
Z50m83/A68GcCA/EddJZt8n47cwXTyb99Dv0r2nwXP908JNJA2nbSWHPwn5b
aV5T4dycfJ0qnZuEL5LOIdJZLGuAfxqMOU84VPIhnLVKPqbJHC3wsxDOLekL
Z6eu6Tv0ozsy98GJOnfmzcW6XT6k4YCEib8+uDvgqYIXa3V9e0OXef9Oihy+
G8a0+TN2nVH2uzLSRh3dnDTAPTs47YG2d0fSQ5oH51veoi2avNyR+RpOG/gD
iRcOwdPanK/WWvfxm4JZU52VuQkfs+zL8DfLvuah7AHhwYYbG67gkYqrP+cz
8PrC9cs9dDh4r+o05/JfwXDzgq/mbKfG/MNwEsO/XdXkMOHa/js66MNFfG2n
uYPh5b6p0xzc6F+bNPwr+Q3CLzN+qn0OVXrWq3U6r4s+d7zv7fTdb/jAr+80
P/hz0ZkRDnI4wyvaHCa4usnp3DJ3xe/pNB8ycS0Xe01jwm+P/k3JF3m8M9/W
NJlTGT7lasbPTvOKVwW/UmOOZXTgOmZcGppxg/3L6Z3mYYdvZ7lu8/XAtQXn
Fhxc2zeZ0xQuUcK8JeHXtjkNcD7Dn3x7p3mfKZ9bUuZ1tO3o1Aa/mvTAIQ3v
M3zOdwfXNhnzbgCde5Iv8ntzwie/tycvryQc8IvRoXzqWN8Kb8N+jXMJ4e2E
G/Gx0Omz5Xc402CPQz02GRclf4+9djDfPhb8Nnt84S7hd4P59q1WxzWDv/r+
Tr93qGeNGn3CfyxpgH8bORzcLYwzwm8knEeSZs7Aj+/02xD4yuAt+0118VvB
GP6yj6KDfAHu4ae/VLAek7yhweETZneDOb0PTLy01SvTp1qThu6U2/3JC+l5
IPpvBCPvaDMPPbztncE9DX7P8mynudfHCy+rNvOz5AMYYyV/s8bfPhP991td
F09IPjA6pQZzPfEtHE+sc+A7h+sczvMXstf+Ivtu2i3hP5lvP0jdESZ19GDK
n7oAb1tl+ZPBnHPCf/ZGvctkWsaET1udl94Gc9HDW8+bnY85S4m8O/K3o/9c
1mOnJ8yrgzdO+F8WjOHjo61OSntmT72H8JfSua7V/OtwoP+A7SZy9vVgzgpY
48E590q9w9lT+CvhzwvmbIOvDd62taPzs+T7C39f7346KfpvJK4fcoZ/QHS+
Kpgrbkb6wXCnU6fDUi/wUo7M2umM4LfqzSkHL91r9eb0I8zbMrbw7S8N5q/b
rdO8gZcn/cOqzB8I1yBchVcL781aqMZ9HA74b+pdJhM6zdU+rdWY8mEMH99p
TsLnghmf4QOEcx1OQOTjonNVwv+63jyB6MBJyFqY9S5rJOwF60Y+LXXEGRTl
jJy1HGW7n/BKKXPqZVrGtH2T5mlJP2l+JXLGOrjot+w0Xzz1PrnTNqYfsbMn
bddE/m3Kc7/UEban/aPPufFeSdtJSv+KsadQR5unXuBL3Ez47hqvVzdIHX1R
MF8gab405bNclesRHda05GvDzAUVmTvo199j00/d3ZX5Ah5G1vus+9kvcMa1
e6d5C6nrscHMv2OEP6v3/D4m/Y4+smni/a5gPlG4RDmnWi7th3TukvaDzs7C
n9abX3SXYDhId0344NGdfr/2TPBnyTttFf7Ey5NO+hf52i3phEtz56ThceHt
hd/nHF54W+F3hb8pmDMVvtSvC+ZehXf1wdQvfWf3Pu27hD8Wvj+Yt3ikf6eU
+X2pI/gtH07499Y4zG3S16jTbRLvlmmrlDP1tWm+bWl0+XOGQ1ntlDKBx5V0
vpc+TtuAZ5b0wwuLvRJu2FHJI3ZMuGbfqbd86+g8lnK4L/pbRYd56thOc4Z+
GMzcRB+Em/NXxivF9XuHbUPrSP6XcG2VzyTB03Jm+JvwFfU+LwVzfviCvv1Z
+PJ6n1WVc/aIzq/RH95qnZNrHObfHT7PJK5fsu8G/5RwSM8fwleyT+z2+S9n
v0/jg6jDPKrPBCPnXPrHDp+p7hV8Wb3T9lPygv3rz5zlgn9P+NgR/kga1o3O
lbE1/JL0NOZMdUHV3Yjkq6bKtpjXsaHU2673Rof3ua9zpihcJZ2nlIY3sY9I
vnN00F+21fKzhHcVfiv44thQ8Fl6qfDasac8o3De6cB5kdql9N/l/FlhriD8
QeTjgi+stz2FtB3Nuq7Re7MVFM6ijbZxc/b+P+m8J51Kffu88LfJF3ER/nkK
Z+VW61xQb/0Pc3+VeN+JDvL3o8Md7/ejMzr5Oi9pKCreBaq9P+xOerBb3Y+t
pN74gdhoOHu/D3uH5HNFjs6cwvcIHxKbDvuULytdd/elftF5MPagDYKP0rcP
FRzXF9G/N+FjP7obe1nCvyv4fslvih2KO9jcTztI8tWFb8R2o7jWCEaO3Qr9
g+t9J/8W0llv7o+bO8x5QZg3Rwd8S+Tcn787trDG2NewPdVoXFoPPwMqq71y
733xatfXD0nDmq3GtHnaJ/U4Nf3i+8hJ53fRL6QuKH/61FfpR1eU3NeqOQPk
TkTsNWsmHOSbdftsmj7e1Oj+3p70fJd4Z0vZfqZymz31RXli0x8eu/kvvc7X
YtXuX7QHzqgr+mwn3VQ6O7TahojdcM7Ei87+GUOmpR9hNzy93vb34fHNgp3x
1qSBtvph+gV2ro+CWTeenPXhJ8F/SP6Hvj1FePUqj5/wLvOGevp76oylcDIf
EfmdwiflW7iUj+w0n/Jt0WFf8L3wxcLP1niNfVSnOZ8fFb5IuKrBY/iFwpWs
txXXpRnP2Ttc3un99Qr9xuwjeFd+iXB19MEjpPOE5BcknCcSJuH8kDQQ198F
6wyvMr4o89p7SdsTwUcmnezLDus0LzR2ruUzHnIPcAXh9fGlVjCvM5zOcDuD
f683PjHrkLuCkW+VdRHhzJtwuP9GOCdlfVhIXIR/Z+Ys5OCjM3+x/wKvqnh/
KZjTmvJnb3ho0vx20s/ekL3egVljM+dfkTXAjdFfKXdpDs46mTst8Gf/mPoF
846euA7+f/KDgsfNaGPS+Vb4fMkrOK8WnipcI/ysvv1EOhdJf6Lkn4Olv5rw
x5Ez9n6a8Xli8MX1/vazDr8ZmTe2QtZg3AsakbU6334Wfd6VfBL9rbu9J2Ut
ukfiRWdc5ppFmXfKCid4MfxbCm+MjanbmPt7u3VbB/kFGSvApO3jzH2MG1+w
Tqj3m6YvO/zu6bmCMXLwFxlbvpTO2Ur/M4yTwmcJ/yOdv6RzjvCa0vlT+Azh
NYQ/b/U5yV9pY6cFPyR8Xsr8eKVtWNoP/hPYX3MWtHnkzEf0kUtTLz+ljp6r
8ThwWtota/VThf9M+KTh73qn85TIv0ld/6/G/Zo0/8u6LvmakZfzsr+YL2dK
nF+xtjw3+uTxrOwL7k+8YOI9M98+EPx3xpBz038vj70Jm+O+sa1g08Q2elbs
p/BOwz8N1/SCkm8s+XfMI23GO0u+lvCGwjsJ7ym8gfCODT7v5NwTzurVJV9X
8h2EF1A463DuWuVw1omc8Ann4sjXTVycfw7Juetw4Y0S10rCqwl/zRojeGvS
L7w6Z5sKZz6FuWrkq0i+tvAo4d0kX1xhftvgs2HSydkseEjSDC86OvBur5V4
v1dcw9oc5lf0QeH1hC+sMl4/eZ9D4S8qvKHwEMmXEP6M9UaT8caSL9xmHTi4
FxNeJPrwcsPPvT5lIryQ8Om0w+ANJF8kOny7pPCSwp/X2IZO+WMHH6A2M/MA
2523lHwxyTfSt7sKryy8VYP110uaqRfS/y3rMclXig76hwj/LfnQyM+tcpqH
JF+LBm+YtBHXGVWOd3Hh36QzG34JuDOJbSV4ULXraBXOvaV/WbP+BiqeOvNx
gOF32Ed4auRThK/A72i18eXCy/FepmD8iLrzfPQd4Y+kc4l0LhZehvfmwpcI
Lxt8qfCn1fZLf3F81O8bOTqDC9Z/WGGOlfwUfKLCYSF8svCivJcvGL9fbZ1T
hRfjvnfBGC7Fs/It8v2TftK8h/C5wksKTxI+J5h4ye8n+vZCyc8XXqrO/tXP
j6/1ic3OI/LV0rapO2yXI4S3a7D9dETsmOislfY/uMn4wtjN1xDeJn1qlfSX
selH2wSjg22dMIcn/BWF10wfnL/JeNuEMzx1St1dmLyALxBemncKBeOHKpz3
i1JHtPOF9e2vNdZB/nG119LXZ/08Om2YNrlV2hhtmzfFvB3mDfheiZe46I/0
rzOVnm263S+4d8S9jJnSR3ZROPtI5wCFs4PwvsJ/Kpyx+nbhbtu2lmqyHB3s
R/sJTxHeMfh2hb+18G5p84Q5Wfgv4Z2C+ZZwiOsO6S8uPFZ4kuR/tDkuxtud
hQ/It4RzYPSXbrL8wAbb4qekHEYHIz8j+gdFZ///Jz8o9tkzg9FZRmEe3GX7
PuGjj31/ZJvTRl0sLPlWwj+w55J8S+FdGzx3jOyyXX5y8GjJD2f9PsB+yRg/
N498oSZjxtINJd9WeCw2N8l3Eb45ZTgmZbKB8HbCuwmvLbyZ8C7CxyT8tRXv
upJvGvm60SGdBwhvLTwm8q2C94+cOxiEv0Xy8gvjcO4PbJy0/aRwFlHatsGm
VmVMen5MmfDtpVUOZ8vI+Xab5AtO1RPVDhepc1taJPW7hPB46dxa5TF8aeGz
KH/sOMLnVLnNDEsbmEf6y2TsHRX9zRrsV2rZLvuSWkZ4qPDIBs9jzGfMm4zb
y0TO/Lhi5q+h0f9SeLnIt2xwvKRhiwaP80ul7yyeuYb5a2T6KfPRNtHZRHhe
pXP5zL87J/1bRL5CwicNywcv22Y5aaD9L5G+Rn6XTZpnH2D5dw2+D7ZJ1idb
pq/RTrYQ3j3tZzvhicK/1/gu0Lgu3/M5Njp7Nfhe0Lhg9KmLvRs8nkxI/6WO
JkS+TcIE0z73EL4lce2Vejw5eHLaOW3ykirna9GsJfZO+lk7YXvdU3gf4e2F
9xber8F3w5Bjkz0yd8mwTe8YHcalJRX+JOF9pb9tmzH5PSFpI0zmqZPw/xye
oJMyZzEfnTbQ3ChzsieC10N4+2bjBaWzo/Axwu9V21cqeKE6h3ls5rudg5Hv
JHwc/qUrzKUCxrcq3x6fcAj/KHxES+fEYOKC7+CQgfZ/f5TwwcLzZq7cO3P9
AcEzSb6J8D4D7dsHv3bg2Zk7JN9X+M1qcx/sG/lmwpMjn7VgPCdvUSXfT/gt
ybdNGt6pNrf4kcILSGcb4UMj3yly8tLPObPwZRXmOh8jXM6cPjZz1jrCuw80
J/JawT3SOV91d7TqdA6OMQr+9iX8YGtddIzkRwnfGJ0DVO97JkzCJ8zdEs4E
/OEPtB+eh9RODpH+eOnPUXCa569zmR+W+t0uGDn5PXyg/R2NTDlQJsdFPrjO
beOIlMMKfaqXhL+c8IHC47jb02wdwn9Q+8GDBtjX5ZqS7yp5KfWyP/7zK1z+
B6QuVhOuatfcwfl8s/Fe0n+2236j8BkFtxIYf1BPSadG+I8Kv7MG7yP56gqn
Vrimxjq1ka9R8Pd8S/iVwr9X+J1aZeKCk+4vpWcP4VUL5mYC39NsDia4b+AE
/FH4pwq/swbvXmd+nJ8Gmg8OnZ8ih7/pZ9ZpFX5fBh5XZx6oX/IG6v7g8Ukb
aaAc4AyqUNom1fn91N+S/4ZvpW5zVMFdtVqj64Jypmwpz7l45ys8Je2Ztn0g
HAT69qGy2wb+kA+PfB7pz8YZyP/TPyjyrdIHb6+wDmHim+7+btcv9X6SdB4Y
aC4keJHAcCd9nzTvmfL8J++/yMs/kT8m/G/ye0jaBumnPSAn75crrj1zvn17
tzmb4AaqDa/W+oxdfdbZpdb1XpE2UIGPtdx1HJF2+HK1++lO6WvwN92b9C+m
eO8RXlvxHiv53cKvZoy6N3Lqib72evxZ3Zd+t5LwAQPMJ0XfuUvyEZI/022d
1yrclghzrYxvtwqvLnx8s+P9Vt8eE/nXwgsqPVdn3LtS8mnCw+osv0r40Qrv
fdBZoc78d9cMNF/etcLXCv8hvCjnxonriGbjryS/Ovp8e0LSTBqW6XNedq/1
t7dHH/7K24TXkP444bOEl+BNYsH4Q+mcK/mZkbP/Yi/zoNJ5nuRnR35uMNxP
k7L3YZw8O/MR+yP2NacLLx58xkDv48YHL540EBc+x0gD+g8IHy35HSnDI5ud
ftJ8ZNL/snSGFKyzpuQHNbs8lxd+QH1kygD7Q6Yu7mTcrvC+8sqB3ieyZ7wy
dXFF6gU+wTujP7zO7W10xr2Dha8baB9rhwlfL/yl8EzYiAeaf2ey5HsK99dZ
Pkn4CsW7frN1mO+u1lxwuNK2r+rlHOHDuD9X4b3qnknbudGZDc6F6Owt/Y2a
HeYg3nsq/D0yHzGP7JF431EbPkr6RzImp49015mLEC6wuSo8Zx2T+agXu610
XpT+qs3GxTrPZeR9KvXe5DD3q3Xd7ZJ6nBCM/nXcE47OecGzV5ifaKJ0+uo8
z45L/72723VE+2Qcu1HyVaVzqPANKduxWW9/kDK/if5eYXyz8Gp1HnOoi5Xr
zPV5U+SLFKxDOOAbEv6RiYu+sEqj5z7aCXv/EwZ6bU+9k87eOtfFEamvtxuN
j6j2nnT8QO+F8b93XdKwd+R8S71PSN53aXb472ftwTpq4dQjOpennUxMW9pM
a7/RWvv9UuP1MPupPbK3Gh38qeQzqxzfF/48eAGlcz3u6kjnHa1Xr24zvqHB
7wJmyX379aXziuTvYteQ/B3h26RznfCrwsVaY3Rukvw54eeF55B8wybrv48N
MfLrG3yH87ngKdxhzB3FTySfSf8enLS91OWzypckf1n4Rum/GDxnre+LvhT5
zk3+ljzuoN/ZYp9qbzTmrI87pcTbmfv/7yYvtwSXk+b3unyfn/cXP3T57uuN
wm+w/m8wfjM6WzRZ5zHsKZL/2OX3EY8FI+cMnrN43uycVDYuK23vSKek/3uj
we8I3kz4GyjMt1K2YOJ9j7so0nldeC7J3xJ+X3ge2lvw7fr2deG3hedOmt+L
nL3U7Lmv+0Z0bpX8mtQjdfdqwr+5wfX+mnB3rdvGa5FT12/l24ndvuexRnRe
jP5G+vYD4Q/SZj7kbEH67wp/JDyvdDaRzsfC93CewJ3ZAeatPjCYN9e8jV4o
eHK332OD30s4hHl7m8Pplfwu4U+E+7jXWva33KO+I3LiQucz4e/YgyvMOaSz
qvRva3Oa72jw3TDu6g/izKFsnW6FMyZliP5o4TljB/k0Yd4v/TuFP00aPhTu
l947km/aZPl9wvdJ/rnwIOls3mT8kOQPSf5Fl+/Pg7/lLKLK9/O/jnyk9L8S
/jn3tL8RfkTfPho8c3S+jpx3HLzX4BwP2+ciKRPq6MO0eb79Kvr3C3/JmUaV
72+DH27w3f4vks5vk7ZHhfdjLBng+/N7BOM7q5k7y/r3spJPS9u4Id9+1+U7
0vSd7xm7qvyWmPrlTVlLvn2rwXeqv0tc9K/v06c4v+KMmncoy6Udcg92O8mb
uz0+vCz9GuHnGzz+1HZ7XGKMqhZ+ln10k+XovCB5VeTgeuE/qoyr8y1h1iX8
F4OfTzjE9SfnjU0Oh2/Hp53QZraS/C+l+akGt40e/d+bqbufUqfvC/cm7zs2
GdNffojO45I/LfyL8BMNlv/c5XvgPwajs2WTdX6t8v3/vxMv3/4TObaef7t8
RvFb5E9zxqtvL+ryWdmBkl8ofGKD30CBeQ91rfDFwidlDLk44xXvmC6KnHdM
53X5nJC3POATGtwezs9YcVXwCYn3AuEHqxzXBYmXu/HX5WyEMqHcKqptr/k3
af6fcAVvKKqMK4X/Fzl5n03fbt1kObjAGJyxF7sYb/Guy9z0bJffIzwXzDz1
Z8InzNeEC8IvNviN268Z86nfP7uchh2aPLbPkzZDm3xJ+pO6/eaE/sJ4WNS/
X2/weN4h/Krwm8Jt3R7DRymcAd0e89+JDmG+Hp2XG3z/tlH4hXzbKfxag/sC
6fyL+4FlvzOhf02QbL7cFSEvTQn/lWDytXd0GNsbU1a86f47cXGn9Otefaf/
W63W71cGJ1/0l4akhzct82e+q+GOhuSvNPj9Cxg/A6RhQOS84/gtbZv+/nvG
hw8SF+Mwb7v+6PKZ7c/ReTJnuX8EU+9/ps3zboV+x1sY+sWvCf/v9PEX0n8b
0scp81bhv6tcnq0p5/dTX/RHfCN05b4K9+07U1+fKJ1z6/+K1e5rvyVevu1O
XX8fndVr3U6Q/6u46hMmdVcp3JI2UxHM/X/4o/Gpgm89xvaDMwaOUzhLdXsM
bGH9EFv5P5rLvur0O4u/ggc32B79pvAswoNYD3DPkLuLrf52Vsl/5C5Z7qV8
x/206M8UfXQ6mGuE96my/jvCs0nezVjXaV/6vF9Yptt3UHlT8Lvkiwo35I3G
4GpzIvwj+euxLf4hPEQ6NcH7Vtmu+mfk3G0mTNoVbxaI69V8iw42ynr6vvBk
fdva5LTtXOW8vBlbPGVFvnaSfG7mceG5Ff7AJr/pe567HNyviJw+2J5+yru/
TySfi/GBOwyd9vM/oMn63BNoF/5CeO8q18UXKf+5EteH0fkyctL2nvDsDb4X
9G7Ks9zmd4WsSZpZkwvvmHy9l7xQd6+m3tsYA7v8TgE5+jPp2z7WeMIzJ5zX
On0nn/v5r0XeG513a3zv4tV8S77I7+gqv1Mg/CUbbCOgnBdnnSO8A3OZvt0k
eHfJF9W3O3bZtjK78AJdtncv0Gb8SY3tyIMjp95/6vRbmKrghSUvMbdKZ0qV
bS6EOU7yTsl/jM45+NiPrXmDbmNsRtgZd82eCBsc9ibO8w+VfKeEs0V0sH8d
0e0zJb49JDq8mT1IeFSX7VPka3vhy6o8V47K/Eg5bJ+8VzIvp48sFLxIg/Ev
nbbpdymc39IveBP0W/JOm/ku7ac+fYd2XpT+v8IHSF5I34HXAnlF6oU2gA64
qc1y+tfgNoe5UIPx950u/wWCkfMG6lvhBRt8b+GXpJl0/po+RXp+TZp5J0X5
8/aKcXVpld2PqccfUi+85/omYxHjxjcJn/L5Nt+Cv46cOv0hff9o1pIDzJ00
i3Tel/x97kYG01+6mJu6/M6F9wtLJQ28eWmOnHcrDV1+28IdkhbhYdJpZ60Y
+YDgpVOGtV0uZ9pedeQ9TQ4TPpRlorMM/bTJ4S/bYPtaQXio8PrCcwgPF55F
OnMKH8l9lTbjEQ2+M1Pu8h2YfuGS8CqS9zcZvxubXVOXbXkdye+ySX8h/WJY
dIamTOqjQ9rAB1bZBleXNPewlhBevsH2/daUSZ/024UPkX5vk3UODh4Qfd7a
gHlTQzgDu/z2uRSMDnx8y+YeCPnqSF7IV7fwoQpz5jbjlRuMi12ej1ZIerhv
0JX6Iv3LJP3YEAdFn28pz7m6zN1D+juTHu4CdXX5vgRpIF8rSn/VyFdKOXQG
9yad6LSxn1Ub26XKdnDqEZvvnMKzp05nF55JePUGy8Ef1NhXBP4guNs/k8KZ
ucvttq3R9xCw1W4XHe4ksL9kX8p+obXRbyp5LzBbm79do8HhDBI+vMp70yVj
JyXeQUkDYyxjKXdyuLf2odI/R4Pnsg/+H/4w89Qc+vZj4TmTFzDpZ07/KHLa
WFXa/7/p46wDKZ+Psk7gbVp15p1BrNWFD1Ma1kjbpj2Tl96UA/ed5s/4Pzh4
3fSRubs8P84mPF/k87RZvlaDeZrmSt9BPlv05wpeM/JZg+HrIZyPE+a8Xb5n
RRrmTfjcT5gn89QI4X7h1Ro85pDmVZP+nuDh0eFuw8xNbg+UG224L99yh2GW
Lt9P2Cjhk370SdsRvK2IDvVLufWl/cM/dZL+RlWZ7+nePnM7IcfnHu8NP1Y7
+VF1cTx7ecZM9uEakj+U/Ptuc4g/0WSdBeEfZ64RPr/WnL+/Cq8QTvlvWffD
AyL8Xbe55j9vtM55nEs0OczBFT4r/kL4QMk/anS8x3K2xtqJfW+F/Q7hVwif
Qtwf583GcY2+2/lGt+984nMInRPiiwhfP/j54du3I8dOSpicRV+v8D/rti0V
f0TocJ8WfnnSfGSt78q+kbjeb3S+DudMCa4Z4WOqzdUMZ/POjbaVYU/FznZG
k33C4g8WP/OvddsHOBzNj3ebBxl+4yfyLbyj8I+u2mgu7Mcj/yo68D7jX/bB
hP9Vt9Mwd4VtesSLjfUL/d/vwhcI39FkPXTQBR9caw53ypzz+fN6VKaUudJz
F/Mpe5MKy8CH1ppDmfQflrv8r6dM+P+vo0+aKYftK6xDHXHnf77UBeW/hNrn
u92+c3gnPFBaY3Uo/BXLxvjnwf/APML3VPle6Pxl+/DBr87gsn3+4LcHjM8c
7q3NXbYvDvxy8C3+QPbKt9wX7eC8tGwfQdydmLXsexfcY0TOfTbuVyxQ9l1W
+myp7HtByItl3y9l/Oku+x7p2tE5LP2up+y7QNxlKpd9f4N7IMS1T9aKs5R9
b4Q7Huhwr2li0n9BlX2JzFW2bxPues1e9j2xUxiLhG+rcpuk/Ln//JbK9JNu
22veFP6YNsZZWZPl2HSw0dDOsZXQZz/ttq1kribXxemN05/2VHwoXFlhuwM6
2CDm67F85vz/R8FH9hjz3RVNjhe7EnfA5ij7bhg+AUg/d8+4c0L6ud/C/TF0
uCdGH6HNY1/G9wt5x48K53Jzlu3vBa7nppJ5Jw9tMcZPNRypzSX7r8ZXDPrc
Q8POjL15hr0FjN0Z+w92IOyuv9B+iqpDpblS4c9fNHc5PObgXXnuJPkCwq9J
Pkuz8RjJayVfVPg9zsqYU4TXkrxG8kWE35F87mbjfSvMQU9cr2L/knxe4dGS
f59vX641l/3swv8TrpZOWXjbCnPQl4rml38jeKUKc8f3CD/MuX3wytQ1Y37R
vOqfUubCa0j+h8LvFX6k1nzu4O0wezc73p2EP6PuhJ+thQDe6XxJuEs6cwrv
TB71W62/1YXvZg9VdN+vgKuxaK75l1mPCd9fa12+uVL4Ps5Ii54X0OWbVWlX
TdZZPXMHOtNqPU5WRueuxHUFZ4Y9Dvfcao/hfzBuS/4l7Ufy5xkDk5c19e0/
jU7/c5w1RWe45L83upwfkvxf4bmFX6g1r/08wi8Kv5q8rEgeVQ5F4W0ES83W
30X4u+iPqPA8zvjAWvS91MUqXCuQfr/wKOEbVbYvd5tTCW6pF5n7FP8Nkr/U
bY6J31usc7DkN0n+Srd5Jf6V/FXG5EZzJ/EtvFR/tVjnEMlvLlgHDgX4HQjz
oEZzVL3Qbd4rOKHAUyQfMVDzv/AY4dObzDvL/ZAt1V/u6v7vngJ9Z/fMQeis
3Gh8b+Y4+H7vS79buNlhnlNhjtl7o0/46MALPEY6T3fb3sqdZ/C4RnM2Pd9t
/i7s+//r9n2zu1Xvs6gMr6l2m5lZ+Klaz6GD0k5+a3QdPSD5rEXr7yj5x+kL
z6Rdoc/cyv+j97TkA5qNd8xcNpPwE5I3Nxszr32UeFdPexgi/LF0lio4nRMb
fS+COxzc3+AeB5j7Vtw14n4Sd5P+bHR7eEzf7tlv+aToPBdMP2Iep+1dl7UW
4/aTzdbhvgq8ZpQV/Fa8g2Ce4n7gepmPWNtzX5F5hzMK7loPLPsONve328q+
a81+bUDZd7CZTwdmPvoTLt2y735f1+t5tKLWd+/5ljve7InQYU/HXNqR+XTl
hAkPKXc4W8v/vQsAc8+TdWx92XtY9ll/l7xvurjXcX9T4zOrv0r/7bPQYS/J
GdQ/Je/XmJf/LbnfseYnTNbGg6LDGRf7RHSm7x3YX0tnvQbbvsGn595pS9l3
Zbn7XSj7fjhvrL4o+QyNs77PSz63JA2fJnzK8PeS8/t99HlPxJu4r0reK3FW
hj7nY5y5fVnymQPnD2DOFXnL81nJZ6TfBPMWifNS4uWMEVvJ6mX7duPeKenk
ni37tcay79ZyzxbM3o33I01l37PtTXniW4P7n8i5P8zd9eay7w+zH/+j5H03
dUtdUL9zN1ln8wbfs6WsuKPL+d4nJb9nJJ0VZe9r2INUlr1/OVz43LJ5p7dW
nz277DvenKtx1sY7D3it0eF85ijpX1D2GyZ8/19Ytt/Lw5r87azxYY8Ob/qO
brLO4LwRIUzO7vBdhw+7WXK3C8z9LriDTi7bzjhZ3x5Z9l6Zt4CHl/1mcF/J
jyjb5yW+tNHh/v9+kh9V9lsZ3qgdXbYN96Amh9kTX6TocH9g/ybrcI8A+wZ2
lN5G2yrB2FO2ED6zbN+P2JyxPfc3eh9aU/a5AevM6vRr2kxV2fv0UuoLHyzs
B2vLPk9gb1tX9lkra9rKrFc5R0LniJxXozMie3bCpB1yPkBc7CXnSBrY/2LT
X6NsO/4iSSe24IMlP7Vs7qONBxhjiz9E8tOpi0bvf2kbtOHNBliOPyv8ZuGj
Cv9U3B8gfO6KYB9cs+z7DItGZyaFc2iTy2pm3g72eS1xTrXf69EOOWfGT84H
JftswW67Stl+wNhHrFy2ne7yYPYU+FFctWz78rRg/Hxelb7G3YYn4cOkDdf6
bslqZd8b4W4JmDsw3A8hLux9+BZbMfuazcr+FpsgfsCWLdv3HeEvnL7M3mGh
sv037h/MPoL3CIuUbcc8MJi3A5whDynbZyP3AZYp27ceNtBFy7afUobgB3MH
gHjxY4bPsaFl+2dj70U68YGGLXK5sv2wcfY+KOPzRsG753yjL+2Hs+uZyj73
xm/kzGXfpefuEHjPBr936C37DcX6+ZY3DpyZ8y3n3ryP6C/7PJx8gacm773J
777Zo7EXw8/nsLJ9tXHHhrzgPw3fpKQff6HY7NDBTx12ZMoZGzF7zOXL9lm3
iX5X0N+bVX7DuGDZ/spoDwumDVwSffakj/ZaH/svc9PHGUsPSV2QZvx/Lla2
v03OSH8p+UyVc/WfS+by5v0FmDNhzlR/LfmslXNXMOeTnA8zp3COyt75p5L5
qTmL/q3kc+Pu4FE5WyYuzmOxc/1Y8hk7djS+XTznkF+XfBb3cfoI75rxkfV+
yT6aCP/9hIl/pw9L9oPEvPBhxhl8NJF3bEk/ZY7jrTfv3D8q2V/TZ8G812YM
IV7GMd4pf1OyzQtbAOnEHsdY9G3J4xU+b5cq29ccPkuXZG5iHpHO4mkznA90
lb3H584M+vi+W6PJfeHitDH08fOJr7yly/abd0+b8UtV9gu6RNl+TfH1CsZH
KPeCiBdfqbxzJC7ePGJr+65kXu5fkxfexWPbIv1z55wQHWwu+F+lPeD3FZvF
9yXbR6bbJkq2iXBu31n22mbV4OnvXtusj90HGwr62DLY6/3b7f3F143GU2u9
Z/yz2/tEuLReLJrTCs6sF4T/rjBH0vNF84XBe4UO/GVwZr1cNF8Y3FgvCf9T
YT6dZ4vmHYN36Tl47lkDRwf+LHjbCRPOJjhcniyaq+XvxAtXF7whTxTNHfaO
fu8rmmPlfe5LC/+gINfhTrXw4dL/occ6g2rMz/JA0TwscL7cL/xjhTloCPP0
3CF/vOh77x9EBz6XP5JmeKDgnCIv8EzBt/JU0Txr8MuA4SBbW/gu4UPrzGVz
VcKEk26a8BvCD3OPuug7/+T3mqLfCHB3Hcx9de57X8FeV+m/smj8S4XfDvDt
mxWW8X/c84eH5croPJC4sNFjrycNE+v8fuHpot8y/BwMZ9xPKXPSAPfcM0Vz
wzW3uDyrlMefe8ylDU8W/E3owF1Vzf6xaF68xhbnvbLSXNV3C39UYf5tvmX/
Ar/b5UW/U3gvdXdUnfmDHiyarwqOIPjh8L++ezCcVvhlxz87/CTHNfnNP+/9
wed3/+fHHYwPGdZdZ3Xbf/ua+RY5fgLOiz7+3eFhgrcFDI/LAon3nKQBffwI
4EOANSTvo3gbxZoQGy3rQ+S8P2RdytspdFhnsnadbjus9tr1qMiPaXJcxItv
CTiWWItuFR32ucc2Of0LxS/OmcGk87Tki3BOTZrfSpkfVmc+nUeL5seBS+iR
ovl34AVGDi/Pt2nzcCrBn/WYcFel35tQF7w9gUfsoaL5++BpQgd+IjhqkcOj
RJ0+XDSf0RfB1C+cxcQLvw++5+GvYh2+StI/wwch6cfnw9jowPECzy99Fj5B
yoG8w32DDjzBcATDdVUomfeqKntqzljmbfY52+QK8wmfkTB5u3l46ot3NLRD
3s7cIv1LhEdzL1ryBoX5dp15x+pL5ibbi3c9wm9KPrnFOutKvn7S8IHkBwg3
Cq8HR4bm+hr2jDXmNastmbNsn4J13iWuFoe5juQTeYfCGRpviBLvW3XmrPyn
aP5KxtufhB+WfKTwj0XzqTF+/lA0T9Pg6DAmw+f4i/CjvK8R/ll4qUpzjRHm
/yQfLfy38FDJdytY5xHe0STNbwjPUnJe1sZfTQuHWApb+N2i8UvS+UV9/LuM
8/A/vpe6q+y1HrzwldJ9v2jOYvi5Pkj76QiGsxgOtbeL5j5jfYLtifVDTa+/
XaTG4zpzwLV15th6J3MBaSEu0jYwaYBbGX5k4iZewgC/IvnYFpf5cpLvybsw
yV+tM+/VD5mP4M6uLplfe2KLddaqNAfoq0Xze9b1Ou/wAG4qne+L5lBbOd++
Vuf3LLSxlyvMhUfdPcQdKu5TcZ4j/BrvR4Q/kM4rwQdJ/jLvdITfl3wt3pII
Hyz5m7wBEf5Q8teDD6Hd8gZH+ADhF/PtFNLZ4m85rB8hnduED6zzXHBd5gXG
c+T/VvhtFHLerDEnXpp5c8WC8a51HsMvzvx7u/BU4TEZzy/LGLJSwXhsnd+a
XSv8VoXfZIF5e3Vnvn0la4Nbsn54gTcUwu9V+G3dDcL71pm78/rMKfDWUeZw
Do7nPZ3wU3XmK/9D+EnhnVosX1Z5n1Bwm3+mzjx9fxXNV75ti+ti6Urzuv4m
/HidebTRebrOfOjI4YQdp3B+F35C8u1bjJepNDc68cID+wzvOBiLspYg/ax/
OK8j/bwZfDY671aYH5Y+C/foc8n7/tJZU/o3Ce9HPQovJvxJrXlpX0l90d9f
zresndBnzcYYy1kEvl6XzpzFnaJdM+9w7rGp8EHCW9R6b867CM4Q2INzJ557
75tFZ1D20XBOLJ09OP6s2V8Pybe8p2AePDjyJaLDvMn9+gMTDuHjn5q9PN8e
kHjxJYZPsZ68n8Dn14zzkF277f+be83cieeuwvDocE4C3i3z9QHS3124o9H3
SQmTe6cjooM+dxh2Tzicw3D3lHun6O+dNHAusX+3zyg4r+DNAGcU+CrDXw++
evDDhw8y/I9xNsXdr4qsSeCb4cxnWPTxHYV/si2iv2T0qRfOjvBnTX1x/wKM
PzP8kG3abd9o+zQZ45+slHjBnKXfQZiNLmfS2ZvyhPcazusNgnuiMzn1O3vK
c2DOlybnW+7U75e8U/68PeDMCn871AVvWygTdLh/u1HKaiR3SITXTzlQX+Py
LfUyPmX+o/5vgNrqLbW2bbUWbRd7mrNi4ZtrbQtDB7vbz9LvFL5L8n/YWwlv
LfkPjf72Jsn/bLLOFpL/2mid+yT/X8JcqMJ3ElqYdyR/KnjBnPnXFW3/4i7B
X0rnxbV+H43NCLv/l43eK12EjT463Df4SvK/hS+R/HbJ/+m2rfybRod5Va1t
cOhgd7s1OpfW+s5DvXSuFn4wmPsP2JWai7YTcf+hkbmv1vXCm4dyo98f8B6m
iO2yyXesaeeU+ejUKe9+9kzb5k70pHyLDnXR2ej2v2fkC0RnzfSFCQl/vsS1
RvoLaeAslLZ3Z9aujySd3NP4Vt80CF9Ta1shGPvad5IXhK+rtX+vcUkD9jjk
2Noe5/y56PskWyV82vZpTbYxbZk7J+hcT/tpdFndUOs7X6y9OR+e1OR2uGza
5NrBI4VvFV5eOqdK55Zuv6vFhnXL/5PflrFx8wHGKyQN9DXe5U2W/GbhYZLv
N8Dvh3k7vH8w+lsmLtK8ifBN0d83346N/Jr0HXxt4nNzSKO5RuEfhXt0QvCi
OUO+JGPd8U3GQ7Jnmdrt/dHJkl9NfhsdJr47N0mZXxr9jRIvOhsKX8v+Qt+e
0uR0kh7k1wkPbTRfLjzBM/yEgfE/zzn8sd0+q+c8/MRu+zfDlx6+hmfwUJ2U
NT/7o2My7m2bb7EJciZ/YvTZHx2fcIYFz5v1/DGJa3j2aOzp9ha+XnhMrfG1
STPlcF3GwH2ig5xyo5zXS35voDyrXdc3pt7Zf8H5yh5kfDDljw76y2UOvTF4
gPB6wv9yTyN1gb863tNfFowtYMdu38UD75A5jvluh8jBO3X/5ytsp8hXz5wy
Y58LLyk2CPwMwXOGrWH1YOYd7voRF3f82H+Niv4q+Za9JHMNPoK579ecPvK3
0r+n0rZWt20f9J21/p98nW6/y4CTDgyXBX2NvA+KHWSLzF+sE+C+Yg2weDD6
vYkXHeZQfC8umLlvVOZB1jD4B2xO+5yWejxJ4V+Ztsq7fN7wL9Fom8hh3T7n
Xz/6Szd67rs6364T/fXSR66iPKvdB69KXzihydyBm0T/ioRPGq5MmCMTF/0a
e9A2Kf8VkxfSvGLST5unjtDB7/LEtAd8LOCDeduUPzrbpb5YFx2avLDuAo9I
XNsmnEHRB8NJ/VbR5zasbXhDyPrnMv0eWzbPI36qLy/ZX/FlJeNHc+dqasm8
ddyXw+8qfHb4k7+yZC42uOHAT8Rn6aUl8/FxF45vua+Ff1e+xXciflyJAx+S
+CI+v2QeSeK8LGnYIXK4cuBLPaVkDk34NMFwm8KheVLJPHdwO55aMkcqvJmn
lcypCo8qGA5NOHfOK5nDCA4gMPw7m+ZbfPNOTPrxYzlZvyeXzO+Jn8xLShXT
LyrBl3pByXxAC+Cfs2RuO7gpp5TMtUd69k+Y+KM+oWTfzgtF/1nJH2btKPxc
pf0Doz+DE/Ogknkw4e4Ew9k3n/ABJXNo4p/5wpL57wZH/r9K+3KfVjKPHnxG
F5XMVTQ6+nBWwmdE+uFjhc8IHTgcd08e4WQci/9V4R8q7eP6xJJ92MItSJlf
HV/Q6MC1B88geYdXFC5Oyg3fxchPL5l3dWQwOvsV7VcO33G8Q+cNOm/k8Yew
Yp39SxxW9Dv5lfMunnfw7JcPZ00n+Sr4NyjaPwX+EPCjgH8KfCnM3a9+02Od
Q9jXNlu+X3QfrrD/CvxPPMKx6iDHe2W/fQLhswa/QBOK9sWD/xl80fCLf6E9
ivY9hN8h/Avxi4+jiUX7JeHbI4r2EUC6Jyav+IjALwX+KfCzd2jRvjBIx0FF
+xvCLx++KfBF96D09y/63T5+5PAnTF3g/xweqLNL5myFe/esknlv4Xs6p2RO
KPitzi2ZM3S7YLiu4M89o2RuXHhywXDpwgXGt3BF0fbOLJnrdqtg2iF8uMQF
T+7WSQOcU/gpxG8gfgsPKNrvIXnAxx5+9Ej/lKJ9RqADf+t++vaZSvtNxM8F
ecdHH34WH6qwn0bmzqG1ftvBGw/sUMyjbZEfWLTfRr6ZO2HCB7Rjr/sw/ML4
WN67ZA5WOGLeKoUTR+G9UfqPB+fNkrlm4M1BZ+sqc5q8LdzZ4Pvk75TM/QGf
Dt/CZcN7FnTgXoErBJ3pfChtDhMOGriBXi/9x+MDhuMGf6ovlOxL/1r9Pl6y
r2Z8/z5aso9f/Pc+VrJ/YPw5owOPMH6enyjZ7zF+8p8smdv6wYSJj1Z8OKOD
L+hbo/Nr/Lu+yJiWeylg7pnwLua1kn3P4m/55ZL9MDN+3lIyFwncBzeXzOkA
/8WNJfOGwFvxsPAKVeZGuSXjLWPmbSVzScB/gT68GPA13Foy7wD8BeD50g5v
Kplj4qRg2iS8QsQL5wIcFleVzCfO3RjSid0QboWXSvYp/VgwfArwL7xSsg9q
fERTnvhefjLyBWJPfLVkG9xPnJMzN9Wbp4O6wA8z/qvRwQcvfnopKzihxhXt
3wrfVvh5fqpk/gLK5+mS/UjjQ/JY4Y8r7ev4mJL9J68S/JHk26vdHif8ifDY
YPgI4AhgHoGnYEXpHy38YaX9mR9fsu90OAXA+MZfNXHhu3iY8FHCH1Ta7z3f
4gMfLuBDSub2hV+APoIfcji29iqZm3iW4Ccr7X9+n5J90eP3Hozvesb7yRnz
d+r1vAan8BzS2bdkf/hzBT9d6XHjkIxdj7COEX6+0nwBpBNf/YxXh2Xs4j7G
syXfC8K/8f/SBvC//UzJ/szhTqK+4L6hLT1Xss9h7kE9X/Ldp7tSF7TVB6JD
e8OPMTr4PcbuTJirpb0R15/xtU4a/oo//Ekl+8xfTDqHl8xzDU8zeYF/GW5l
0g//8hLReaHS90loG9jK4Ws+omS/8UtKfmTJ/uE/LrhtP1tvblzmdDhzWReh
z3pp6ei/WGl/afhTw2fa+KL9OoHxgYffFny2zKm5bVnNiXPU2f8W/rbwtbVb
0b6ZwLsW7bcOn3X4teP3Vg0R82h+nEX4in77fcH/C/5hdiraVw4Yfz748rms
wr678OGFD72di/YxxP8t12M/XmdX2K8X+HbhHYr2T4dPOXzL4XMHvEXRPmgG
1tm/Df5ppnJmXrTPHXx24TsOv3FnVdiP1+aRjyna/xH5xecbOrdJZ8ei/d0Q
Fn6J8HmEb6JdJN+g2RifRdPzK/2FpdMinV84xxNuE/6DPaD0Z2427tbvz9gD
uUKk/2/Wt+cLr4DdQ//3vf7v/D7lX//+lrM1wpH8O+HlJRsWPJN+/9TvkZxv
c+ahf//OHk14lcTRF9kR0tm0aP93LXX2w4OvJnzyjC7aX+F0X4XCSzY7TRfC
0aC/Jbl3jx8ppXU7yVeTzurS+VXhLiZ5q+S/sZfE7tHsvJfz/4dzXs2Zd7N1
nlJYT/Y4j28o7Ee5n4aNCb9W0umgDbSrXDjHxxZQtD0JvBPjf51tah9JXpL8
Zv27inubCvOGOtttsCFhu9mhYLsQ9pcb+my/QWf7gv8fm84uwndy3l9pOxK2
Jb75gnP9Fv/f55yfYf8QvlHhfKZ/3469TO37H8V7XV3sSC22K31atB3uNtqV
8tIT/InkvS3Ow/V9tjfx7e7S6U/4Oxcc9qJKT63ydVfwjgXnFTvgh0Xbh27S
v0fp287gDfFblvrdqui7zpTn1ugLdwqXFc4A6pb2IP2lJW/TvzfD/iDcSh8R
Xq7ZepsX7VsTnVLB/3+Bvh1VtM9E/Ibhpw5fj5dKvn3R/h/5N7618LGFzgVF
+3qj/Vyj31F1tj1dWLTtmX/jmws/W5dwh0TfDk1f3nGgfXjh42uU8EqSdwlv
I9xTcL62K9pXF99vW7RfMPS3Ed49+nCZ3ZB171z6tknf/sD5knQ6m43fk3w5
ybdhbFIdbaK/x9RGzy3arrY1fbVom9m2wtPyi93tvKJ92/HtmUXbYEYKv6Yw
l1WYWzDuFO0rHHxO0X7ZthK+KLrYcS4V3rLOdqu3KIeCdfDJh78//PIdwxl2
s3243RvZaxX26Yc/P/xkflNtjPzkov2obkifTz6wCZ5StC1tI/37KYV/ZvDZ
Rdv/SMepRd//3kT4GemcE/yWyuZxlc3GdfZph287/N1NLtqvKHuWvYu+T4+v
vH2L9q+Hbz384Y0L3qdon2t8u6fwqZmD8FeGrzJ8mE8q2jcx/34zdTKkzj5i
8fGKn9i9pHNG8CXS2Sjjy/PSOV/yzSQ/rWi/5JsKP0v7LxifUbRf9c3r7Bvv
mJTtS8LLFCzHxyC+CV+psH/0sckX/tjw14ZPtiOLvhMAPr1oGx7xrixcFP6p
1j798Of3aoX9/OGvDb9/6woPEW4S3rhoX67gbukX9Hue9DeSfLFm/3uDon1o
1gmvzp4ouFrz77+K53KNT6uxf5S8ljG/aN+y4Fn1+7d0jlKYszdb/2jhdzSe
vai/Rul8JFl9nd9TzKtwOqT3o2QrKZwVgwdL3lxwvoZjY8mcNFTyAZL/JTxC
8tmajRdsdpj7K8wu7ksIn1vh9yC8BSHeRZotPwCbtb5dL2ltx85O22GN0WzM
W6eTir4XtYH+vWTBbRwb8YlF+xFeX/9+TOGfFh3eR/A2An+Y+NLEX+br0j+6
aDs0dUHfoY7uqLB/Wtbp+AE+tmg/m3yzRMFhc5/qoYH20bkec4fKb40eh98h
nZo6rzfmbzbmbsnsqpuleVOkf69XtI9g8FFF+9ykne1etI9I1kX4HJ4vZYX/
UnyXch/s+KL9F/PvE4q+v0UaqMf5Mg4cm3EPfkb2dNdn38fZ1zWsM+t9z/mA
3IXGl8v+ZfM0NQbDx4rfoSlln982B+P7BZ9XB5W9z+YO+X65m80Z74Fln9Ny
ZgvmHBi+JOLCpxe+aCaX7a8G/mi+xZ/W5tzhLdsHAuHvWK6Y7jcJ/2k7lO17
6oNgfLXhQ29XMPcbBxi3VpuHemzZHG4faT7do2yfP7tIPqb8H2cXGA4m/D8Q
L/6vTtDvpLL90tQknb+zHxfeq2x/Wfj42qBs/1dfC69ftt8zfKatV7ZfNXzc
jSrbfw5+wzYs288VPn82KtufFf4D1y3btxu+sNDBdxA+f9DBL9BnbQ7z+yr7
XiMu/JvhM400PJrz84PLtpniZ2bvsjl0Put1XvDbg88l0o9PG+x66OCLBv9U
lDP+u/Dhs0/ZHN9wf+9btj+kd5OX99Metk8bqI4+/pp4a4A+7wvwlUe+7m2w
zZq6gFeL8+rdyvYt8LzWL5uoHQ5lvyy8EfsarXP+J7yx8DKSvxidfSV/WXhT
9m7s44Q3Yw8l+SUFf7u05K9E50jJX43OSvDyJMx9JH9KeEPhpSR/Jnhv7pEK
r8U+Wvgm4ZXYA8KjJLyC8O6Sn6O4VqQfccYSnXGSn8v5JPtNzlgkX0V4vOQX
FBzmIuwZW6xzvOS3Rmc+yR8UXlt4UeGHg/eUzp/CG7DvY/8rvK7wYvXmhZlQ
tv8E/ImNL5sjBnvN7mX7Z8BHE3WErzDO89HHD9VxZfcFfD3Bu43+V9LZVL8T
aWPCf7UZ/15lLoBxZXPNYLsH44/xz8SL3zDOjt4rme/4saRzktJ8ofK+jvAQ
zkZajE+R/CLJ1xNenPPhJreHL/Ttby2WnyqdJ4XXF96r0v5P3i2Z1xiOYzA8
vI9HZwmFc3HBZbUke+EW19FxlR431slYgQ/J4WX7pZykcfIO4TUZr4RvF14D
/6XVxjtX2+52p/D6jbYTgbH7XKnfu/W3oeTbY58t+67m5fq9S38bNNr3M3j9
hHdHwuS98C1lv3ncLt/yBh8b4nVl23an21jLvvPAPdVLyrYbYsMFY5/F/ji1
/J99cGrSRpyXJ15si9eWfecEGw62nMUbzUd3WWw62KCJF9sld3WuL9t+zdtJ
0sn7SuzRN5Rt4+bOwAkZG3/S2HJ82dx2tCnaVlfuqV5U9v3Jafo9sex7Bdwf
OCljzje9ThM2st96rQMn4LwzdBrtb+y4tNUryo4Lfj3GM9LAvQLutPB+qhD7
3Y1l2/pHJi/cEcIWT/qxp28VnaVzn4dyHhK7/E1lvz/lzu3NZb8h5S4oeeHO
LXeMLy7bnsv7bvSx428bfe7x4qOS9oafz8o+1wV+v+EGvCLpx1fbNmX7jmO8
3SrjJ2+Rti7bbxvzzjaZH2m325btv4s5eruy52V85fEt/tbeig5tG99u6OCT
7fWEyfsm3g1tWbavvFeCeUPEGLJx+jJvSUaU7WP2+ryH4i0PPl3pO/hQvSk6
vDfB9+xaZftrvVXytct+y4BfQcJ8OvPgWpk7bo4OPkt518J7mGeEn20z5l0M
89QWZc+zvGHiLRP+LafbYcu2sd6j36vKtuHW97lPjs79Z+po4dxPQJ97Jhun
L2Bnp++iv0FsuNeUbdPHvg/Gnkt7pO0uPcMWnDbc1Od4d601/yzjHmfm+F0k
nby3YuzcNOPni73Gi9V6fcH6hjUGbZn2sKTCf7XX8sVr7Z9zZNlvx7gPxpyO
Tbwtay3WQs9HZ4YPT8oKf4BzxW7LOH8etjClbX7OljUersb5tvClwssKj2Zu
El6GsVTyi4K3kHyq8FDhmSS/PHhXya8SHiY8W73n6KUzn14hvJzwLJJPCx7D
vJy4+iU/X3gp4ZGSn1Lwt0XJT5F8UeEB9Z5z5858epDwXJxRY9sNXr/SPhnm
Ea7DhhuMf4YjhOcTbsh8ukjm0GMU17zC9fWec+fNvHxa4t1U+ETpDBEeKJ1z
k85u7J7CiwlvJp1Rwl0l3/M8UbhTeJNK35Hu4Ey7zne55xCu0rcHcG4h/DXn
GJIXS77neZxwu/DGlc57d9KwfXS+4ewiYXLvev+C4/qyzndNScNXwtcKLy88
B7YP9t/CHfVeJwzJ/Ht60t9e77ly8cynRxdczrWSnyX5EsKdnEtjbxTuwm6e
vHAv/QbhOWesf6K/edZRS2bttF/B+fqcvUzqYsNKt735hSdUmo/7gZJ5qLlL
cH/pP05tMDZ9eLEfLJk/Hb51MNzf8JVjM4Lr/GD1l/tK5suGq/2hkrnm4Z0H
w4EO5zVxwcENJ+a9JXNh75lvuasAP/XtJXNnH5k9EfcBPpH8auHn682bCZ6z
yvY0bG/Y1PbpNYY387OC91bwVJ4RGxZ2f2ym1wm/JPkxwYXY3YgXWx629TtK
5ra+p+R0ntRo+9SdJdukjsd2LNxS7/azoHCz8LHCg4U3UtkeVXAdVWMja7H+
HpKfUHBfaJP86OgX6t2GFyad1Hsw7fk47NfCTZLf3WI8kXASL+2W8Y/xdyOl
8xyl866S+b7PTl64JwCfOOmHQ/y86AyQ/NiC20NjvTnB7y6ZB/zZRuf/enxw
SX9P4ScqzbWNDQXOYmxz6GODo5zuSZ1+3uKx7gTpbCk8sOQ3DowJLWmHHfp2
gvB+iqtNeJzww5IPEB4vvK/kXdF5VPJu4YnCB0jeK7yH8OOSt+TbvSQvRecx
ycvROVDy9oT5CO1fedyd9l9vTmTwU5Xe7+xM38eOI7zljPWq8BbCq0r+QfCx
ld47bCW8uuSfBbOPIO/bCK8p+d/CO5W8X7ha8W4tvIbk9a3GV/PeodXxss+q
FN6FviydSfDRCV/DPQHhXYXHSn6vwlwzbeAr4TWETxSeS+1/deEtVV9vSL65
8MqM84p3uPBCwg9IPiLt8K7MQYwD37ZY56RKt1V0Fq532KsnfH759wJph6Rh
wXqPRezF5hKua3U6r5J+dfJyhvBhSv9o4VHJ+xjGruwLKOfVhBsjvzp2zLEl
2y7fSl6OFn5XeKTwMcK3F6wzTt8WWl1W4+v9pob29pnGvS9TF7RDdLZNefJm
Z1bhfzjnFJ655PcgvI/hncxfnGdFh3c9vBWaTbii3uP87MK7VfotCd/+wTla
dHhPdGTBOpXYdlscJu9uxgvPJPyb9CcEj8i8UCp5XuPtSavwJ9LZpMU+jhYn
DQX3nY+xBUSH9yndqvc24aVrPJ4MyPgzpeAwv62zrC1yfvn3p3V+T1EW/k54
l+Blsw4ZVPLag7dFvcI/1HnPuIPw+vXem29Pfhk3hLdLO3k7dbSK5L9G/5Ts
nekLG9e73aI/ot57zB0ZE7DVBp+aNjmKcpP8+2Da50+JlzOBvoxLcJ2PSTp5
A3Ugdkjh7+s8n4KZHw/C/in8I7aPgtvD8KwxkLMW2l24v+T3RNdnTqeur8la
a2yl3xyh85PCObjgsvq5zm8tubN3ZZ3fZ/EGijdfvNl5DXuD5OV+tUd82fCE
R7/H62/PWvOzgA/XWvEfjeXHCu9Rax9fJwrvJXxWrb89TTpVPZajX1KYxwhP
1P+f3eRvD5P8X/aAwfgHOy5xHd1jfdLQqfXzvsK7sgeU/j7C22N/6TMeLfl3
kk/u8fvNUp/xGMm/Lftb3vH9Lnxoj31tDe0zniSd3yQ/pMe+g5aX/DDyIvmZ
SQdpWGqQ8iH8Cfe/+oz3Zr+vtr1tj+eUrfW7jf6W4SxOv1vpr7/Ke3nOCzg3
OCb6QyW/HH+HwvsLj+71N/8yDiiO7YQ3Y66PDm/qJ/Q6zAvUj75SmHsJb6c0
ju913MRVo9+TUhdH9NgPmsQVR/X430pCxR9l5xFffPhIOzL1Uux3fmeusO5R
kc/T6LMP0n9H4p1+1lFrHcLcrc95Zy5+R3hv4V30H1+XjUdhX5Z8P+Gx1X5P
Maviu0P4VuLs97uJF5uMt1KYD1L2/fZXtkTwPpJfRV6Fz6m1b7e+frc38kIe
SP+0HsvP5t2E8Ez9fsdBm6ItkvaFhAdh95D+ItEZyVsMlWer8GjyoL+WfvPO
nC55s/AOtMUe6zQqnKm91tm5x/XcJbyu5NManc4tOfPvcX4/JF6VQ7fwgdiD
kwb8j+2qcLbQv4+rcbmSzhn9hT5JO/xF5XlQj+/wUxeT0gaG9Fk+kbdXfW7P
ewr/Kp2De/xGYIk+4z0k/77suuCe/8yS74+O5D+Ujbkn/LPwlB7vW2kXxaRn
dri06C+cz/RZZ7zwBfrt7bc/xtUk7xE+KOMB6cfvX1d05sEu3G+dbVVO97LG
pnxTPpTNBIV5foP/Dx8IJ/Ubo/Nj2WngnGTHHtcL/k5H9rgM6Ucb6Xdj2r1w
a7PWXML3KcxhRWPuSzyq38f1dz/34fv970MqfJ/i8ehwn+KJHt+j4NsnEs6S
uZ9waIV/nwrGZ9e9PfYDRjj39Nh/1xn9xjtU2D8cfuLwF0f90w5oh0PSJvgW
net77EeOtgqmnfD/N/T852fshshpv7R12vCvfca3SufppJM8/tbnPIKXVfiP
CH/N3Ywep5l0ntnv+jtb/z5b+Cz9Ha6/CxXXOT32zzlAv2fpb0qt/XYix9co
vjbP7bHPvYt4L097rjZGfoj07+SdSI998eHL8WThfWrd7xkLtkr5XNNjP2aj
G91/sAPiA+2+pHNpjck3K+wv+11Hj6ReKPP7kkfGDMYRxo0/+oyfkPwqhflw
j+8LDe0xxoZJHyUuxiV8+l2b8n+/1mlDjr/T23rsb40yBD9Za3vS+B7zOr2h
drq78A/cSxceR1viDq3wBMaUav9O1N981R4zGDs4T34m32K7qWu0zjCF2cm4
FX3CG59wxtJ3Ez62EzA8QaconO177CN65l73hY3wWS28ofCG+C7rdT/ZhTWt
8CbpL/xuqr+p7KF4fyJ8LLyxgxzm4vq9vdE6O0m+2CDrDBnkcZIxci/OG3vd
J9+vtIy+elqVx0rG1puqXJ53pAxp/7f32JfsWaqvM/v8b/rvndG5t8ltg75D
X7urxz7xPmkyxuce/eLu9BF07o6csO5I+Hf3uuyer3I93pn2U9vjNgmvGb6B
SCfjP77YSD/jDGP+zskL88Xo5IXfXRPms5KPEX65yrxpJyVMfMSgw9xxb3QY
32jbT6fd0o/OS39hLcCaAM4F1gNN/V4T/Ku/KuG1+H/Jq4XX6/Eaob7f6wTW
FWDWFm/q7+8+c/aB/xFeUb9rJxzeznOvDR3utq0UHfSZ2xv6Pb9Tp3X9/421
YOYs7gD+1WfuWmzUf/bZTo2P1h+FZ1IdPR+dZfS7fo/TvFKN21Ftv9sS7RBM
G6TN1vS73dJWp2PaE/lXOH9V+84+mDv5q0he0W/5d8KVwiN6/L7muT6/qeF8
HYy940TJnxdeqtHcIk8I/9Rg28TjfbYj7N5k/EP8UD3UZ39Za0v+sPDVsUE/
1udzWs6Bn+6L/SJ5P1V4Qcqyz/PaFH37FOsAxbu4fr/q89z+ftK/co/vi5F+
fMts1e9vOT85TeWwSr/7F2fChDPDxkH6sbPw7vXJPr9zxGYCxnbDm03SVpL8
DLWtn4SHKsoOxqo++1huD25iraV4jlC5dg3yHU3uLg4TnsY6SPjPft8d4U7I
UMmnCt8m/AXjrv5WxN+55A/1e7xZSPg+4c8Vz9zCDwgvKPm3+r1Mf2/o22Uk
f1h4R8lXGuRx4Jx+z5tH6Pfcfs9NZwav3ed5lfmVeewZ/c6t37n0bUP2Nfgi
QPfMfMv8Bp47YZ6dOe6sYHRm/Ju1CmGThjO4a9nkNnAUfr0k21vpXFlxPdbv
MXJR4UX1/c/Suaza8/AvfZ6LucfBPMQcxPoQnWHcBe1xXUxlfaLfb/u8X1lR
v9/1ec2+lH6/7vOabln9ftPnvcuDCXMpxjWl4Xx4AAa5r/2Z/kjb+7LPa7rT
037wDQUfzar93oOc22uM7y/WCL/lPifpZz2xeI/X4b8mL8T7e/LyZPQZu3gT
TX5Zb+NnGB3W8Gdn7HqtxnYc+s6bsdc80mc7CD6+Vu63Xy98v4OxEfO2YqV+
v5u4j3GLvQp32HstH9jgcW9Yv/dBV2nfvTzroYyBQykX7aM7hBcWfk9t9/6E
06Bv9+61/jP1Dn+FyBkDefPzYoX7JphxZq2Bal/9voPE/Rkwd2jw77FQv89q
WnqN8QFyeafDfLrV+zXS+ZDiWqfF6VmixmPdov2efxnrFhH+vc7jJHjGHI3O
oHqvBVg3sGZgXdHR/9+aAsyaAZ3O7EdYS4BZP3CHZED/f+uFtn6vGRbN3mRM
5kfkzJHck2nv9xqHuYM738wRrEEG9nvNQxraEy/zAmXOOnxWyYf02+5wdsGY
80nmkWXpP5K3thqzTqCPcOfpjAqvnQYkfNberNFZn9M+wazP0SENrImWTdpu
yVxDOMxB1yjvc/T7jtYW+v20zzb3ubij2+f9xHz6/ZzxX3ggd4D7vH8Fc9bA
OcPVjb6LzD3kaxt9v5C7hdwxBN/PExzu6/Z5j074xDWu2vcL+fZi7qjr95M+
77c69PtBn8824G57tM/8a9gAwdgE4dpjfnmuwXZI5ixskbxLfYH5tNFn7GDs
m0X9ftjn849e/X7U5zMSzkvIy1q81dXvx33eC67T5D54LTbcRt/X5K7mq8Jv
E1aD1wkLquyGV3q9AX65zveiFxCevcb3kMF35W7bvP3/8UuDuefGncE50neY
r+cR/l5l8lnwLpI/3+g1D2cg3BslPe9UeM3DXWruQq8uPJ9wm9LzZdnpHFDt
8ucMgvMHzh7AIxrd71jDcFZybK95JjiPgWsC/ECN1wyEebTCH4Xdod9+fv5J
vIMrfX8cOfe3O3u8TmPeZH/Enoh9EJwRZ/Z4f0ReDlA8H6udH6TfKb3mfTif
dyvCH8SWwVkS50j791qfvKN7YK/Pizg3mhJ8UattWtizwOh8onAuwL7Q67GF
/IJZs/GGhndrR0ne3+q3QLwD4g0QmPcm9FfGSvos72VG9bpvorNDr98KYVvZ
IfpDWv0mh/c4vMsBnyj5Bq2Oi/dxpPegpI03vwcl72P7nE/Oyj4ouxyug4tE
v2vrbyfprKnfdVhn13t8PqTX4/la0dmx3nr8G/vLXY3Wv4K9v37X1d+V2Hc4
H9PfbqQtcuwvjDeMQYw59cn7BVnfknfWtMwJeyde3hBP6vX7Yux42PNerHe9
7JF8YSfEXsgb5z1bjbEbgidFflOrv8UOiE1zr8j5dq/U6bfJ8+z69pmCz4ZI
D+MqmLmMtjw+9XusynPOnuk08RWz9xifXO3f2SO/jH4XOVwJrMtZkw/uMebc
jLXq/JFf0ej/Q87/g0/NmnaBHq8bZ0+Y6t4Vl+i3j7U2fRBZ+kKzflv1d3S1
ZfyfsjR9jcm6k3XmQX3Waazw/w8IPiuYcOhrrE21pKg4td/fsjY7tM/hEma/
fnt7pj+DnN5+1k/bmIX5Qn8ncQbbZ0yaqfMxqXfeKY9J2Y5o9Rs52jztHzy1
3u/Ed+v12+26tB/q5d2Cz2cJh3XIhPTBYakj1iT0wd3SL47qc1pJJz487+n1
vpB705wj8eaFfPSnPGfW76Ce6ddJp//OlG8vDT5ROkf3WW+GzsyRk9dZkl9+
Z43O1OCTsn57+v/FSz2qCKb3qfXSBynPtdLv8KF+mzC+1qfp91rOGpT+wU3G
+EWHN+SayFkz3xH9W2j7vfZVi99aMGtpMJwrHdG5I/LV+73fZq/dEvxL9uCX
Bb/Y6PN01rHsjcGbso9TmVwhfHaV/aijzz7+E6X/kl6fjeA7HH/uKzTYn/Cl
veb1g2MLnbUb7Cv+4uSLPeCdSRtrJOqOtRNrpbuDRwRzDsAalrUsa1refB7a
63eshHlh4mUde3yv17ed+fejNV7bHhf5+b3Wx3/7yb0OE14kePH4lu/QuShh
kq+rk2b8Ht/c6/MMyvWW1AV1dN3/w7f2mqeG+qJ+4aNB99bowPd3vfD4BreB
61K/nIEQPmcanIvfFLxmMGcjw/sdFvVOOyFt+O2n/dBOLkiZXNVrP/8b63dz
/Y1Wme2SsZtxm/F7g7TJe7jDJzwNu6R+R+pv13p/NzLfMvYzB4ypd5hg7PLg
LSLfMGMFYd5W8DdjMresmTGE3+GZX+5sNKYvrNzreQvb/drByFfT7+qUj/AO
+Tc66K8WOXiN6BMm+HLprJpv/6+p+462vKruAH6Hx3sz971RRsLwfPf+7lOK
LDQUKVKkZ7nCQmmjwIA4KCPCUAwL19IkKyFRiRQNKtUWgaEJopLEgoUyFLFF
TAhFehkQFBSVYrIEyfm8/Z3AH2/99j3v/M7v1H322eV7vLdf6nBZ2m492tf4
GBw2rH1tTZu1y/r7csZ9Z+dSOstRxR3bQ+0tR7R+vnxYOPnWx+VZI2t+Wzvu
vzOX3HmnvCtS5l6j+m287FnkEPu7fj0sdbi6tWVp+t84HBza85CMozE8IH3O
L+KQjJ02Hpj8yjkw7X178h+dcVyacTeGB4V+Z+gfpq8Ozrc+1tX+sTC6jsXZ
Oy5sz5n290k6mZZnwWDOhD73nAg99/RbLE/oU8cqfUHoD9OXDOZC3uee/dCe
kynnnNCn0c90pWdUJhvoCzNzELxzdjlnffbHJ4Yl15Jp2dycJ1ZEpnUuId/+
oPXP/fw52bVnil42v+R1764zVnZOugS2zg1mi7e9tj03bn+DtkY3as+xQdWH
fpKecu3Q6sXWy8Y3lvT2Su/BQZ15rmv0I6GdfR4dlLx+X6OfCE1uv4cM3/4O
bXW7hf/mTMVrL++K/tq8evrfPmShftHyrNfqN9Xq/GezdX5xTnIWcwah73Qe
OWx+tf9b88q2rM5symzJL6ZvteXFpLNN99IWT3ZueT4Zms36xK7yrcmzVtL1
01jG7uZ+tUusNPsbHR4bHDsbPQ1bG1scPQ17HJnq8vZ7V/LYVMlk5LEtB2U/
+5fkuWzwkv35sshgdEqXJ919Amwo7hR4X7/snbv3yuaJZg9lZzs/8/zbY2U3
ZVuZHpRdhm7ZfXPnNvrE8ZrLZ2c+v6I9P5N0ctlnI7+Z+9YAe80Xp4qW3x1e
3v27ln7+VL0rv/l+TtLPmyra/LdGzg39wKDOxs7F7KXquaxXsgkZ5RPjZat0
TmU7ZvdzXmd/NP70I3QjbP7OuOz+bP7OvnwG2DOds9k32SrpwNgrrZX7snY2
zbnfOX0wrDLppcm2xuj0VoetZ8tuslV7XjxVstenYydaOSi75yVTVeczosO/
YFBnQ+OwMuOL91yQ/BdOFQ/Cf8hxyjytpV80VfI02Q9/kudj4yWXST+l0ben
31aSgZtAd+NM3VN2UuhD25hs1ur6tpbvz9vzqUHRo9aur3YVd/YHMn97vrX9
vSrnX/pyZ2pnbbYFZ94t2/v7N3qL9pw/LJpu1//3zRq8b1Bx+PcZ32Glsyns
kvTP90rfaR7TebJnvjF9QvdJB7pLdK30rHS5WybPntGRstMf2ivdIpq+VF52
nTW2022T31rZJmttt0HV4wu9snMqm21or7T9uV7piHZLnpPpwQZzELFzT2vG
3uH8sV7G1BguDn1e8rB1Dtrz1YOSn0/t6jda2iBjjZ5J+fTwzlPOVqsHVSf1
uXS82q8tvxyUruT52G7Ybei4POko6Sd/NyidyML0+W4Zi4eThx2HDvMtyU/f
suegdC975l3j/pZ8S/r5GQM85EejOqsPZ0snvF3Ggi1n59TnkMaH72x5vj6v
nj9vf0vnFyYVGhbH3e1510xhVtgP0N+YV0//UwbsjruTB3+9JzzW3ob+ZqNv
bHnumCmcK2XfmfJ/Jo1Oa349/YYFBP/w2pny1RfDcp269QtHES2eRdzKqkYf
3K87xdBiWMRuXK9u/bqzDy2OQ2zODdZdv+64RIvTOaKr71457yW9ORv07TNV
5wNb3Y7p6ve/z3vJx4VenW6T3p2e87bQ/Aro23dMObcOSk9K947X4tf47b0Z
Czr/mzLnPx9dqHGiU90x76JX9auP9M/ClLNGbsGj8edb9etM4YAd2RX9r/Pq
6X9L+G32i5bnNmM1U1hkK7qi/21ePf3vHS3/Df2i5dEft2cc7TXq4ez/4zbf
Hmnpo9k6738udhm2HfoOOg17MVnKfjQ/9ETkN/KcfYftkn8SH2k6J7onujht
Oaqr+rjHTl3X1BNtjP5+VPl3im8VmcD2u82w3nVv3VpJ53Ml7/EpH28WV44/
f6KVc3FXv93FdlBXMtJWZPyu7tdTljqt6dsjUze+6Men/u7EdKYlq/Nl1i76
HzK79HPTjqNT/zcNi9Y+d++Zc+YbOxJ7EpnE882hySpo8996eRM9cL9kGzS/
I/S2SWeT5K/DpslugD4udgR5yELK8o2/im8Jex27m3W3Q1drkLy0fWhzQT2X
Zo0cG3r7YdHacRxdsvo0+vhGH9DV3XynNvqMrr6hzB3y3aWxs6o/WyuabOa5
fWjznRxP5nHfnzLJtx9vZa7sCt8Ensr+1sBY4avBWbu5V3ZzuHIw5U4KDd8G
Pg38NfhjMMxgisETg20A4+D6XuEfwEGAiQG/DYYdTDd4ZnDNLu0V/pxvwXOD
OQd7DobMP4SGQXdivvWlXsWhw+uB1QOzB/29XuEEwJMSo7489Bd7hYehDnAY
YGDAWYCxAEMPLh6bFxw1uHhw7mDjob/fK4w07YJ9B9dBu2A1sDdumbkBk0+7
bugV5hzsuUt6Ne/xyivDt9H4ief7QjtDvCvr5Z/bWHypewlrY2nGaNl0jYv5
gF8aK/zzhFGtNfcebknf0NWdkvLvl7XpDCLdfuF/fjuPwJaDNwdrDuYc+sZe
YfwYF1hzf72oYsPYYj6YdsGjgwcr3oEtxrlmeco/nXzeVXv4zx/e1Xlni2HR
7pSEi753sDfF9Ivt/06v7DtbdeWPZ51tnbX2mJiIrnTR7Jnsl2yX+Maq0HuJ
p+hKh+lb30wbYUp9t6t90/2b30r/6KtvZVzc43lVeBSbqzLZKfCuq8Kv2DV9
lw3lU6OyqaA/BIum0XdNVJuvyDguES/TlZ2FT7s8/M/dF/nN9AO9qzqzU9C3
a6M4GnaEa7rSOdA/oOnY19hy6ONvFKfTlb2D3hUNQ2ybV1Z74WmRxchnZOlN
sqd8ij1xVPrB18yWjHZKV3IamRBNDicT+k3eo5+mv7Zn8Xf8aFc6bc+TutJL
f29R8SUynTMFHfSrcna+NHN5o6Q7a8BBuSzzdisxMl3ZVthZ0PZKZ21rgZ3O
XRX6c1H2UPVhe3KmoGumK6YPpiP+RM4R2v7K6Mzlce7YMHnoh+G4GC93fX4o
8xY9tm7RfzNR/gn8oflCH9ny7N3oI/t1r7d775xPnUPk42/MZ4HvAl0EeWmP
rmQnabsknb4CTdZC79qVz7Yz7z4pH+1bf9kr/0P3nfMjZQdAsxdYg9YInxl7
1TZZL3xLt8neZL/bqSvfb3Ldrvku2U+6vYv/xV+kjfy+tVebDh+VH4m97JzQ
xv+QtEeZy0a1ZtVBO3dLW+h59ljTJ62fv9bVWQxeFNwo9+O40+rrjV41Uec1
ec6aqPOB385r0r6ad/HCy8IP8ZnLM0b0MGh81P0hynR/irt4fAuG1AfCV823
OeyrrjCvJiNH0V+pO/94uin13z1j94rsm+RGfiu7JQ/euEVXMe9sqXCs2G1h
WaHZVd2vcaV5MlF3N6H/2CvcLXWAwcVH+KT07caTxQ/hnMB5gzEHXw6+Gpw1
uDRLQsNbs/+uyJ7IJw0OHew5++Yx2UPhtKFhmsGIggMFAwpuHPy4U8Pzj8xe
DLcGPh1surclD0y5/ZN+Wq9w5uSHBQeDBxbPP5IbQ0/Gh+SA6eC0LCw8NVhq
9uiDsi/D80HD9oHLBZ/rY73C1EHDs4LdBcPLXgY/T3th4sG1gm91cq8w3tDr
Z3/Xxot65QfNr4LfI8wc+DL8Jfg+86Plz0PmgSVnP5UX/f/4ckmfannePF33
R/dbOTs1+smWZ8eFRX+kpe/c6F0a/dFe+czyueRD+/3Q6jA5WXl+M164cbDD
YIKRT5ZHRoLvhYbfZc89IrLEepOFcwTXCJaYdNhicIzgGX2uV35i2sWXDJYY
TLFHMje0/bO9wirz3VN6hZmkTGcoGETGC/bQDhmvD/fqnrLf8PmeqHuafj1d
d0UdM1n0NRN1F/xT0xUndexk0de19NflXXecwaiDVeceK/fQwZX7bvwrnpgu
nwr+QmgYdO6Ge5Jva0vfMLR74l6Td91h526au6brjph3TxZ96UTdO+NeIffL
uE/tbmtkorDrYNjBkXMfzT3TdWfNVPK4c2391BPGHGw5GHNw82DooeHLvWey
3r1sou4WNzeeGK97wWDbwbWDUwezD14fLEaYjBf0CgfJeMGegkEnHbYbmc08
h1PnuSxzntyHJpPDSIRdCNcOfiEaXqJ5CLcOJp15CLcOZt1OSTc/YdbBsINf
B8cODb8OPh+cPliCcAXRMPqGaYs7zmDx6Te4fDAItQv+Ht6Kp/ON2WOy7jDi
37Jr6mAt8F9d2egVLf0boWFWPzOod+0FMClhU17lzNvo7Rp9eKPfuLDu6IF/
BXPRfIaPB3MO9tzqXmHUoWHPwdWDr+fM8pXQcPZgy8GYI8PDn4PptiznFDho
cM9gvEl/qFfYdTDsyP9wy+CXwaODPwf/7t05I8jznpxB4GHBwoKbBT8LNhqc
NDQcLRh1sOru7BXuGRquGsw52HP35qyhnjDuyCfw5siTztRoWHOw99QBzh7M
NnWDq3Z+2uLM5TwCxw1Wm7Me7Dn4bOQutD0UphycOBhxsOLQ8OXgcMPjvrpX
GN4fyByDdWo/+nav5p50uN4n5DyF38Kl+1Dm+dGht858g/0N73tFaHMP/h8c
QOcO2HKwAmH/XZj6O09dlDxwAuGBnZY6wBSU/8FezR+44TDDYebBzrumV9jj
2gJX3Dw8OXPv5OQ332Ckw6qDUwevDn172utb8MfsufDX7L8bLCwcNxhu9kpY
b/ZEGG/ywGfbKHmO6xUmKEzS/w3P3zO8F84ivMWj8PyFhQ0KFxROqjJhx9l/
vWuPnl1Y2KlwU18b+tiWPtHoHRr9y/Haf7efrr14/mTRj4/X/rvjdPHzxQsL
gw9O3YLJSv/VePnnw13lIzFKfY5p+ddNPWFCvip5jqSDyneXN3osa/ax8dq7
4eLZx6fzrRW9wqMzz2EqwqiDVXdPrzBmrX3Ys3AZz8w8/ExoGHbmJHw32G6f
zlpz3odZd/p0YdjxwUPf1Ss8OuW/I/MB/h18urNSjrkNOw5OHIw4OLXGBU4r
WQJuLLkCnh8afiw8V7iuR/cKL1Mb4f69OumwXmH/ws/lOwp/Tvl39wp779OZ
k3Qp8tCfHByZzb5Mtv+nyPli/fgwiW10Jjs5ZzT+kJNd4QKRP/td+Uau1RXt
nM6ufX33ko8E2t3x3l3QFX7L3LlnVOcdvgo3dOXnwLd/QcrnhwlHRuyAOIKJ
rnCN+Bq+sqt7aviQ8h9lr2S7XLer2FXnpw+mfPWEEeNcr56TqTM8qPGU/6dh
lb9j0n0Xdo271ZTJn5P8To53DvjZ+lW+s9rcmWxUZ1B6LLozepL9QrMjXdjo
9yed3otOjY33zEYfNaoz18rkoVu5OHno3M5IHjq3S5xvkn5xaDpPOli6VHpU
8vx7I9N/Of38rpxd1N8ZhE8+//tLo1P1Lv0nW4R09gjtPSH5DwrtTPzOUfW5
mFP3By3qakzYzRclHTYXrCXxg/q2l7ETJ/LisDCvxE2g4U3Bv5JHOlym54YV
Q7G4K/9dYyquRJliTB5O+rGxRYph3rdffr+v6wofzJ0sGzZ6Sb/S/E/c5S9C
s28ePKo5Yd5K2zjp8Ltel/zsoRunTPQmaZc2bpJ083OsK+wgMSNjaa+5tlbm
s/GwvugrpK2d9INaHf7Y2rv5WN2H9Pyw7qHTb+anOBr+zvxu+STQU01lDr8+
a0GM6iGjyoOmpz0l47sgZS7Bz2fbvGzPZ9v/Tmt1fmFY31w6qu/5lnWAVv/d
x6tum41VGS+knKfa8w8ZI+MFL0xbrN//SbpYGHngHL6+K19t/fb51I2tgU7r
U/ENNm+Xj4r/zD1D0z+g6QGUc+ioyjIHzcV9oic/LPrxYxZVunkoDujAUcXv
bJ08dAV0BnQH9Kdv6Mpnnb/6A3yfRoW5Jy5tzr8qMWho/l36w5ht2q84oANG
FfvzWOqmnCeHle6+nsdSPhv4r/Jdddhlqny2+Gvd3a8yzQFrxHgYi++y1bZv
/gl/8Qc7sI3h1Y2+n0Kg0dc2epP2/t6NvmZUd2+8tdHfGZUf2YaNvhm/aWMz
0+hVjf6PRk83+ifWcvve89b2qOzc/Zb+s1HdsbfWbM0pc2vvzHNr5h2Zn+pp
zZoP+nlx5qP85iG7Et3NR8J7vWuN8G3D8y9YK3E/ozoz8nvi/8Q/bbOpovlB
8UXkp8i3EE+jf6F7gYv+8fBMsYynjSqW8bzQylyZPGIK8NJTsy7wT3Yj8QUX
hcZLr82cpIu9wJ40qphocaNnjSp2VEyhdLGHnmckj3hD9HHRCZ0e3vuF1uYz
Gz0ar+dZoZXltzhWflNnp6/Y4s5+GR+ml6eHvDS0PeiM7Dv2Dr6QfCL5uIqb
22dUsT9wKd8+Kvyx+4ZFP5X4SPn5T4q51Lf8P/kPmpN8FAft3T1H5Q/J7xG9
64Jau6dmPxK7Z72I4zs865ee7j9b/v1GhSPn9zlZ7/jfe7OuxbMsGVXMixiT
fUcVL3PTsOp/RWJnpIu9FQsjv5hccRzKF7vB/2TD8Gq8aO3wYf4mm2Yfh1v4
u2HNT3P1d+FL+MNvk27N/n5Ya9l+hBY/+Hh4F98VvP2ZpHv36WFh2OIbjw0r
tlGcI3q7fPcXSYdze2+jH11Qf/c0+mnYU6G3zD74THivsTJmxk4f+4Z+Xj2s
dPh1nveHhv+JNr7a8nTqKdbyt6mnNar9+KF+/uGw5gle/eyw8BvFNhmb3TI/
xVqvTmzmD4blP/zT9q2bG73ReMWaob8SzEBlinMR8yL/V9O+e9NGdft16gNX
8zeRAX7eL588/nhkA+niK/Xh4xkveHrexVf3mq17hJ4ZlS+ed+f3K07z8fS5
Pngy38KPn8z4LkkbzSVj9UDGy3x+cFj83zqz3qy7AyN70YfQB87JYf2S1+bk
tn75EuBH7GPksouTB++Rjv/gdeIt+dSQ/+TBf/ho4UFs2vSBF6ZMct/cOu+X
Xww/S35l06Fb1jk+h/fhdewCZyY/uXNlvmutSreH4pXKp1fE8y5KHfj4KEcM
OP8dddw2T3X2f/FK5gN+ZSweSd/qt9WZh7BqH0ofmnvy/D7r4tFh4Ujr719k
PqMfSv+L8300tPisB182zx8evsTHVqdMusbz0vaF9CFd4S18NnWWrp4PJ/+a
vUFcGxnA/u9cQD/qXfrSv40fC5sGf7Ytksd8/lHmP7nmqcxJeKQzXWHgiAUb
tb/9+yULkFfIA/zruqTLg+ZrJ25sGFp83OZd6fPln+0KPwTGqTJh75B514vc
6/vPZS3jhXgufmhvsVfZX65bUDSsg6vbuNwyrLQ7+hU/b/+yV6GvX1Br59m0
645hlblx1vh/Zb27N3M2bRHjBt+E759Yt9eEFnP64/ABfoMwg/brV9wc+rj4
DXqXfA5Hd4O0d9PIZPi28jZIHnLUpuHDYu+mU85MaP3//lbO+l2dBY5v9CDf
HaWf9eEGqadv2Ue066ep5yB5nCnWT5nKnkk5xy2qM8kRGYvF+Zb4SHvY5pET
bkn/X9jKvQGfGa/njelz8+imzCUxkcb+hPDk7yddvAb6isQkbp4+MSc3yzzx
3mZ599p1qnzfPLH9rcp3V4b+dvvuVS3PT4YlR565TmHCwIDZy5l9WHkvSJ3V
03vXp5x900Z7MT5/a/pN7OQdmSfOaOb80eEDd75sXaPFV5pTd4RWzo/zrvRb
Q9vL/jtr33n8DVlH5IKbsmcp//aUI+1HmW+bpz/1lbrdNiysWnPytpSPtyj/
ltTn9qyd/wMtuQWx
          "]], Polygon3DBox[CompressedData["
1:eJwllMtTDmAUxl/1fV18ohrFV97XZFwL5X5NtHDLYEwLw4yFiSVj1x9gtDFj
acbCqhlDVIgMi3ItSsm1QkgiC5cZQi75PXMWZ+Z5zjnv5ZzzvG/e3oM7DiQ4
53ZiEeypdy4GGMxxbl1wLgurSnLuE7wU/Jj4UKJzPfC18Dfw4qhzfSnOZcBP
w0uTLKcJ3I9tI56Q6lwm8UH4Edbuhv8Cz8B3jbVtuc5tBLtge/ls59LA78k5
xvrZrLkPXoqvApxPTiN8MXwXvJX9LsDXw6vZayvx5eBvWGWinbkCPA07RKye
nA3gF6zpot4ovsvggG8gYmcsAzfga0p27iS+VvAifEcjduYScC++uojlKFd7
aK+BuHP3wPPIKSW+nfxC8PxguIsenSOeDffEy/DNBRcEw+p5DfEieDnxcnwL
wV/w7eGsKuo9D+7GKomX4KsHP8P2w3PgdeAeb3c/Ab8Ifoi10I9eejqB/brg
DfBG+Hj4R2+4M+bcA3Aflhy1niUTfwn/HrEeq9ev4DnEjxO/6q2n6q1y8sDP
8TWD+zn/krc76C7qYQv4n7e1Z7KcG0f+a3hB1DSRDj8Lr6EX7fSzGVyCLw/e
zZ3XBKtZtavmW+At+GammubKgmlYWt7HmnxwAtZBbUVI7QP5m4NpUxreBE7F
DqczX/b/Sfy3t7Uj8BHwHywjZpr56u0N6C3oTnPAs4JpNZP9q71pWFpWTaPw
ScFq0cw1+1XBZqEZrATHsNoMe0MRcDE2GrWZrQaPVU0Z5ksET1V9cdOstJuL
9cdNkzk6O5gWNYMpwd6Y3ppmNh0cV8/jpqnJwTQpbRaSfx38FqtIt54Oe9OE
tNHA+iFvGpQWpcHb3t603rZ6+M5bjnLV805vf4j+Ev0xE4PNXLOXxv56e9N6
2+pxmzcNS8t6AzfBtdhwkr2pG+Ar3t66etAO/qE/INXurLvrT9DfoBrveNOg
tKge3QUPaL7ptkZro+p5mmlO2vvsrRfyJQXThLShNSnwR960qJloNk+8aUUz
1Cw74Kdi9ofpL5PmpD35xhBfEOxtqybV9h/bKtLE
          "]]}]}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl1OdvjWEYgPGH0iqlalarqBF71Kb2qlEfSEREREIEtTcfJOJL/wLxD9h7
77333rtVtHTau34nPlznuu77PTl5k/O8b+qUeWPnVgghdPdRkSPdGO2SQujL
aTwxcp1XcC9ey+m8nwfxXR7CZZzB8X4kk9vzaB7FY3gmj+NsHs/rObt2CFNj
QshKDOGseYXO4Ymul/MkTnFjkzmdVyaHMIGnmJfxNF7DM3gvZ/FtnsMlPJ+r
R4WwkNvyYh7B0zEDhQ1CeNnQvekinaOzdLHO1bN0iX6tZ+tSnafn6DL9Rs/V
H/VbPU9/0vl6vv6sC/QC/UV/0Av1KvexiL/aFdot1t90kV6iv+tivVT/0CV6
mf6pS/XyyG838n/gbYrv4A1izd+5CufxN7zGV5xApv0ofNG5qKWP80gegc86
Bwn6GAeujnL9Ca9Q03yUW/BwNEczvLQ7gr+IM//hj3iBGPNhbsoZSEUTPLcb
xj1xSF9DY90IPdAdB+2u4jfK8AwHcAUprjfEU70fl5FsTsITvQ+XMNT8mPfi
IrqYu6Er9pgvoIFORKnejfMYYn7Eu3AOg80PeSfOopO5M9Kww3wG7XVHdMB2
82mUINpcGdv0KdTX9dAObbHVri4PQh3UxgO7gdwGW/Qv/EQx7qOafSVs1ifR
St/jAdwam3R/7ocifRdVdRQ26r7cB4X6DuL1Bk7n3vigb6OGXs/vcQsFuImK
9vlcgW/wO1xHS/O6yPlyhJo76wmcyjUjRyryjuBkrsGJkWeU63Ec1+JqvNo5
r8rx5liO4yocy14TIZqjOYorc+BK9Mcz4vEI2Un/32n/AO7NtHQ=
       "]], Line3DBox[CompressedData["
1:eJwl09dvSGEUAPCLeGgiXmxK4oVE/AXiDxBi1aqiqqpqtWZ1b0VRq2rvqr2q
9i5qr5o1a++q0TcRv8bDL+ec5Pu+e797z+kcnRAW3ygIgt8UhgZBC7Fr+yDo
2ykI+tGfAQwkjEEMZghDGUY4w4lgBCMZRSSjiWIM0YwlhnHEMp44JjCRSUxm
CvEkMJVpTGcGM5lFIrNJIpkUUkkjnQwyySKbHHLJYw75zGUe8ylgAQtZRCGL
WcJSlrGcIlZQzEpWsZo1rGUd69nARjaxmS1spYRtlLKdHexkF7vZw172sZ8D
HKSMQ5RzmCMc5RjHOcFJTnGaM5zlHOep4AIXuUQll7nCVa5xnRvc5Ba3ucNd
qrjHfR7wkEc8pponPOUZz3nBS2p4xWve8JZ3vOcDH/nEZ77wlW/U8p06fvCT
X9TThT/t/PcmeqyjfgtxL3WKOkodqU6Vp5FOBplkkU0OuQ1rravW93kNa8VS
day8F91oRm1j34AyikgknB6E8tcA1ZDsuQX2V8hLyCeO3nSnOXXmq4pyikki
gp4NdVO95h1cLegjxjjLkYE06ICxDFwxaEsbWtOKIvvqFS3llWJ0yP9Z/gcm
E6NL
       "]], Line3DBox[{3593, 1146, 3595, 1903, 3593}]}},
    VertexNormals->CompressedData["
1:eJzs3XlYTl3fOPwMRSSUSCENVMYSEepLEqEUEUUpTZLIUJJGNKGkRBkqRYUm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     "],
    VertexTextureCoordinates->CompressedData["
1:eJxk3X/Yp3OZ//HRVjtWyaBNpJTW15ZqFOXY0ofSoLVZtFIoI5RKGIoaCU3U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     "]], {}},
  Axes->True,
  AxesLabel->{
    FormBox[
     TagBox[
      RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
    FormBox[
     TagBox[
      RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  AxesStyle->Directive[12],
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{0., 2.}, {-1., 1.}, {0., 100.}},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  Ticks->{Automatic, Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->378528672,ExpressionUUID->"41fedf63-7ec5-46d4-82c1-3a4c4779b957"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1694408823,ExpressionUUID->"5c96f29e-5255-4099-8388-c5b91043621d"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"e8c41289-61be-49b6-b746-71ff050a5853"],

Cell[TextData[{
 "A power series is the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "n"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "n"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2e456cf9-aad5-49bc-9dea-557ecd62cce9"],
 "."
}], "SummaryList",
 CellID->313287077,ExpressionUUID->"091cc5af-ab4d-403e-9649-80b232c87be7"],

Cell[TextData[{
 "Power series are convergent for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "cfca022a-9661-4bb2-8db9-3db76b999fb2"],
 " and ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "840f3efd-8e5d-436b-b98e-3045d37556f8"],
 " is called the radius of convergence."
}], "SummaryList",
 CellID->71874767,ExpressionUUID->"f2e2baa0-7432-4d5b-a3a3-0cb8e563612f"],

Cell[TextData[{
 "The geometric series is the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"], "+", 
    SuperscriptBox["z", "3"], "+", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0887d81b-ee04-46e4-9bc5-d6a06e521ae9"],
 " and has radius of convergence 1. Its sum is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d5b3abb4-7efe-43cb-b150-20a785992dda"],
 "."
}], "SummaryList",
 CellID->114880579,ExpressionUUID->"37cbfdb2-51b4-4ab2-9c75-f4fc566f9d71"],

Cell[TextData[{
 "The ratio test for the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    SubscriptBox["c", "n"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0fdac10b-b2da-43d8-bcd2-9395f0361564"],
 " states that for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      FractionBox[
       SubscriptBox["c", 
        RowBox[{"n", "+", "1"}]], 
       SubscriptBox["c", "n"]], "|"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b21bc6ba-7041-421d-8286-1e27680bf9e0"],
 ", if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "<", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bf73b46e-7c93-4e1b-8303-eef183260876"],
 " then the series converges."
}], "SummaryList",
 CellID->645123762,ExpressionUUID->"7c9c890f-bd30-488c-8ede-eb9b1150e278"],

Cell[TextData[{
 "The root test states that with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"n", "->", "\[Infinity]"}]], 
     RowBox[{"|", 
      SubscriptBox["c", "n"], 
      OverscriptBox["|", 
       RowBox[{"1", "/", "n"}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cb0b7dd1-5843-4c61-be2e-da791d162fe3"],
 ", if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "<", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a094b6d7-0a1f-4d16-aa03-d86fa7415c66"],
 " then the series converges."
}], "SummaryList",
 CellID->34159819,ExpressionUUID->"0f0af0b1-fce4-48c3-9e9d-0412df7da068"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->317007102,ExpressionUUID->"1bf82b4d-9dc7-4379-9f37-edc33852bccd"],

Cell[TextData[{
 "Find the radius of convergence of the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    FractionBox[
     SuperscriptBox["z", "n"], "n"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"354735d3-b7ce-41f3-b7b2-838557c76136"],
 "."
}], "Exercise",
 CellID->13935825,ExpressionUUID->"90bec0bd-b72b-4cab-92a7-2479b3841d7f"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"d2e07176-9796-414b-a118-821421b1d67e"],

Cell[TextData[{
 "Using the ratio test, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       RowBox[{
        FractionBox[
         SuperscriptBox["z", 
          RowBox[{"n", "+", "1"}]], 
         RowBox[{"n", "+", "1"}]], 
        FractionBox["n", 
         SuperscriptBox["z", "n"]]}], "|"}]}], "=", 
     RowBox[{"|", "z", "|"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ac90b778-656e-4bb0-a24d-a92425160a9f"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "010175af-d2f7-4c39-8167-3b7bce967e1a"],
 ". Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ": "
}], "SolutionAnswer",
 CellID->414225805,ExpressionUUID->"390fdf60-1439-47de-b2c1-5d150c4dcf74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "n"}], "/", "n"}], ",", "n"}], "]"}]], "ExerciseInput",
 CellID->414906115,ExpressionUUID->"9e4f0523-fd99-40c8-b995-d1f7849c15d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Abs", "[", "z", "]"}], "\[LessEqual]", "1"}], "&&", 
  RowBox[{"z", "\[NotEqual]", "1"}]}]], "ExerciseOutput",
 CellID->344618849,ExpressionUUID->"7eb99c3c-0f04-4e9d-9494-ef14dc5591de"]
}, Open  ]],

Cell[TextData[{
 "In this example, ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 " also returns the behavior at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "z", "|"}], "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"00209998-8d44-4fab-a637-b09bcd18f6ff"],
 ", which the convergence tests we have seen cannot classify."
}], "SolutionAnswer",
 CellID->758516228,ExpressionUUID->"1d6d2fa3-b549-444b-a343-eb8e5ddf0788"]
}, Closed]],

Cell[TextData[{
 "Find the radius of convergence of the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    FractionBox[
     SuperscriptBox["z", "n"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "!"}], ")"}], "2"]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e937cd0e-9683-493a-8405-c0440fd63e6a"],
 "."
}], "Exercise",
 CellID->35530864,ExpressionUUID->"a083228e-68b1-4c8c-9bb2-ca754979b75a"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"eea4a1ba-4667-4b90-8dfa-3ad2224fb73f"],

Cell[TextData[{
 "Using the ratio test, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       RowBox[{
        FractionBox[
         SuperscriptBox["z", 
          RowBox[{"n", "+", "1"}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], "!"}], ")"}], "2"]], 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"n", "!"}], ")"}], "2"], 
         SuperscriptBox["z", "n"]]}], "|"}]}], "=", 
     RowBox[{
      RowBox[{"|", 
       RowBox[{
        FractionBox[
         SuperscriptBox["z", 
          RowBox[{"n", "+", "1"}]], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}], "2"], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"n", "!"}], ")"}], "2"]}]], 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"n", "!"}], ")"}], "2"], 
         SuperscriptBox["z", "n"]]}], "|"}], "=", 
      RowBox[{
       RowBox[{"|", 
        FractionBox["z", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "2"]], "|"}], "=", "0"}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "151ba2ef-6484-4fed-b0aa-540899b13462"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"60001b4c-fc77-4d02-acf8-ec263e0eccc1"],
 ". Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->393777318,ExpressionUUID->"93e54f0a-ee12-4ed7-a00c-9ff2b0310837"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "n"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "!"}], ")"}], "^", "2"}]}], ",", "n"}], 
  "]"}]], "ExerciseInput",
 CellID->250613830,ExpressionUUID->"585b7f05-f75c-4c7b-9bba-73ae25756d47"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->37554071,ExpressionUUID->"319d9add-e3ee-4e08-8056-be618faf1e5d"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Find the radius of convergence of the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      SuperscriptBox["z", 
       RowBox[{"n", "+", "1"}]]}], 
     RowBox[{"n", "+", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4cf98b46-91fd-4930-a0b1-e0621d817187"],
 ", which, in its region of convergence, converges to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    RowBox[{"Log", "(", 
     RowBox[{"1", "+", "z"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b4c617db-4ae5-4ef7-9ba0-a33e6c29ae2b"],
 "."
}], "Exercise",
 CellID->5899690,ExpressionUUID->"5dfbdbeb-62d3-4d0f-9657-c6bc925715a7"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"ba680fbf-2758-4b53-a31c-c5fb61f33208"],

Cell[TextData[{
 "Using the ratio test, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"n", "+", "2"}]], 
          SuperscriptBox["z", 
           RowBox[{"n", "+", "2"}]]}], 
         RowBox[{"n", "+", "2"}]], 
        FractionBox[
         RowBox[{"n", "+", "1"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"n", "+", "1"}]], 
          SuperscriptBox["z", 
           RowBox[{"n", "+", "1"}]]}]]}], "|"}]}], "=", 
     RowBox[{"|", "z", "|"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6ea99412-bb70-4131-83b0-515c27726344"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ac8682f2-090e-4430-8e3e-529e990c5f25"],
 ". Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ": "
}], "SolutionAnswer",
 CellID->370152869,ExpressionUUID->"cb09e449-5299-4716-bc51-48e9724af479"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     SuperscriptBox["z", 
      RowBox[{"n", "+", "1"}]]}], 
    RowBox[{"n", "+", "1"}]], ",", "n"}], "]"}]], "ExerciseInput",
 CellID->299310912,ExpressionUUID->"297a48fc-65b8-475d-b5fb-5836ccceb2a3"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Abs", "[", "z", "]"}], "<", "1"}], "||", 
  RowBox[{"z", "\[Equal]", "1"}]}]], "ExerciseOutput",
 CellID->236215999,ExpressionUUID->"f412f123-8455-4b61-9bcd-cd0cc2a68f08"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Find the radius of convergence of the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     RowBox[{"n", "!"}], 
     SuperscriptBox["z", "n"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f56856cb-4f98-4f38-89b0-23cde08e69cc"],
 "."
}], "Exercise",
 CellID->139441506,ExpressionUUID->"436aafd1-59af-47f0-ab2f-01bf7b578ae3"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"da3c0eee-a996-44ce-9e3c-8399ed1a7b53"],

Cell[TextData[{
 "Using the ratio test, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "!"}], 
         SuperscriptBox["z", 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{
         RowBox[{"n", "!"}], 
         SuperscriptBox["z", "n"]}]], "|"}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"n", "->", "\[Infinity]"}]], 
       RowBox[{"|", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "z"}], "|"}]}], "=", 
      "\[Infinity]"}]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ba01e74e-ddb7-4b41-910f-8d008015fe44"],
 ". So ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c898a6eb-16f5-4db2-8d13-cd061587cf91"],
 " and the series is not convergent, except when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "25a5771d-e533-4026-bc91-71edd6a86961"],
 ". Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->295813446,ExpressionUUID->"4ba0f181-ebb8-42dd-a0e3-eee9d2d7a9ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SumConvergence", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "!"}], 
    SuperscriptBox["z", "n"]}], ",", "n"}], "]"}]], "ExerciseInput",
 CellID->88865564,ExpressionUUID->"558c91c7-2afc-41b4-831e-9059883e6fe9"],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", "0"}]], "ExerciseOutput",
 CellID->58671309,ExpressionUUID->"3fbee09c-1dfc-4f99-b8de-12a445944069"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Find the conditions of convergence of the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"z", "+", "3"}], 
       RowBox[{"z", "-", "4"}]], ")"}], "n"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8477f58d-b6a5-47b0-87d8-c5d98abdb823"],
 "."
}], "Exercise",
 CellID->84639373,ExpressionUUID->"8ab14c78-12fe-4bce-91ff-9bc23336752d"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"eadb1164-7616-45af-8213-75e1f6497a9a"],

Cell[TextData[{
 "Using the root test, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"L", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["lim", 
       RowBox[{"n", "->", "\[Infinity]"}]], 
      RowBox[{"|", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"z", "+", "3"}], 
          RowBox[{"z", "-", "4"}]], ")"}], "n"], 
       SuperscriptBox["|", 
        RowBox[{"1", "/", "n"}]]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"n", "->", "\[Infinity]"}]], 
       RowBox[{"|", 
        RowBox[{"(", 
         FractionBox[
          RowBox[{"z", "+", "3"}], 
          RowBox[{"z", "-", "4"}]], ")"}], "|"}]}], "=", 
      RowBox[{"|", 
       RowBox[{"(", 
        FractionBox[
         RowBox[{"z", "+", "3"}], 
         RowBox[{"z", "-", "4"}]], ")"}], "|"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"3c6c1902-9772-49ac-af73-9aa75d729057"],
 "."
}], "SolutionAnswer",
 CellID->111813037,ExpressionUUID->"f4f1f5a4-0181-46b4-be87-3f9087a1113a"],

Cell[TextData[{
 "To find ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "4954c509-4a8c-4e8b-97b7-05ca7de8ed69"],
 ", use ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->1163349865,ExpressionUUID->"bc899e03-97c7-4808-9331-5a8183138a00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "3"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"z", "-", "4"}], ")"}]}], "]"}], "<", "1"}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->68495893,ExpressionUUID->"9203ce88-6c16-4be9-b4ef-bcfb9d600473"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", "z", "]"}], "<", 
  FractionBox["1", "2"]}]], "ExerciseOutput",
 CellID->82266147,ExpressionUUID->"7362f913-a4d5-48fb-a8a0-1b74617bae60"]
}, Open  ]],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["SumConvergence",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->261149122,ExpressionUUID->"5ba9eb28-698a-4bf5-90db-6b7b5ddde9fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SumConvergence", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"z", "+", "3"}], 
       RowBox[{"z", "-", "4"}]], ")"}], "n"], ",", "n"}], "]"}], "//", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{"#", ",", "z"}], "]"}], "&"}]}]], "ExerciseInput",
 CellID->350068735,ExpressionUUID->"7c8b4976-fd36-47cb-8410-a322fbf90092"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", "z", "]"}], "<", 
  FractionBox["1", "2"]}]], "ExerciseOutput",
 CellID->310676060,ExpressionUUID->"1b976e34-7c69-4c98-8bef-b4fc8f0528ce"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1545359602,ExpressionUUID->"6eef1ea2-3242-4c2e-a367-c3a2970fe7f3"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"19. Power Series | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "18. Properties of Harmonic Functions"}, "PrettyTooltipTemplate"], 
      "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "20. Taylor Series"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"a0f63afb-7a80-4df6-a6c1-9ea6b45e17b8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[639, 23, 219, 7, 108, "Section",ExpressionUUID->"3cf14fb2-5955-4f1b-b9b6-8d58c050c498",
 CounterAssignments->{{"Section", 18}},
 CellID->242913651],
Cell[861, 32, 321, 5, 83, "Text",ExpressionUUID->"6559eb98-31e1-4c9f-ae56-e0c14bcd3fa0",
 CellID->120437334],
Cell[CellGroupData[{
Cell[1207, 41, 137, 1, 56, "Subsection",ExpressionUUID->"a5d6bcea-f781-4f64-9d0e-a20fd7bd5dc0",
 CellID->1174694],
Cell[1347, 44, 177, 6, 36, "Text",ExpressionUUID->"20c38cfd-9808-40d4-89cf-36bac6e84953",
 CellID->614331527],
Cell[1527, 52, 439, 13, 56, "DisplayFormulaNumbered",ExpressionUUID->"799581a6-8458-4a7c-ace7-fb46c73c6da4",
 CellID->519506942],
Cell[1969, 67, 105, 1, 36, "Text",ExpressionUUID->"42637813-ec49-4cf8-b110-1028b30dc450",
 CellID->111014305],
Cell[2077, 70, 319, 8, 32, "DisplayFormulaNumbered",ExpressionUUID->"3f643bef-4f09-4270-bb30-65041a0fad03",
 CellID->188011201],
Cell[2399, 80, 191, 6, 36, "Text",ExpressionUUID->"85b67bdb-b0b4-4002-b75c-c08ecf96fb0b",
 CellID->310688234],
Cell[2593, 88, 315, 10, 36, "Text",ExpressionUUID->"06200104-74d7-4af4-a7a7-29e641c72bc0",
 CellID->83437834],
Cell[2911, 100, 297, 8, 39, "DisplayFormulaNumbered",ExpressionUUID->"d16e14db-ecc5-419d-9dfa-4503b6e5bc9d",
 CellID->474767335],
Cell[3211, 110, 179, 6, 36, "Text",ExpressionUUID->"27e34c0d-82a1-4892-b989-12b43787be15",
 CellID->370813329],
Cell[3393, 118, 563, 18, 56, "DisplayFormulaNumbered",ExpressionUUID->"f74ddae1-cb1b-489e-8f10-28ecbd237ba5",
 CellID->3683173],
Cell[3959, 138, 178, 4, 36, "Text",ExpressionUUID->"b9671b91-1294-49c7-bf41-efbb36d3ec6e",
 CellID->216447349],
Cell[4140, 144, 221, 6, 36, "Text",ExpressionUUID->"66ad7beb-fc15-453e-b13b-3c14a17de874",
 CellID->183249523],
Cell[4364, 152, 858, 28, 56, "DisplayFormulaNumbered",ExpressionUUID->"a817ea82-eb4b-43cd-9a10-822551b03d1c",
 CellID->37793012],
Cell[5225, 182, 637, 20, 36, "Text",ExpressionUUID->"49e17a6b-109e-4a16-a3b1-f6b6df3dcaae",
 CellID->68680460],
Cell[5865, 204, 250, 4, 60, "Text",ExpressionUUID->"28947aad-0372-4fa1-910a-b3b811c5509a",
 CellID->496433365],
Cell[6118, 210, 602, 17, 60, "Text",ExpressionUUID->"4389e203-b0dc-43ad-8135-5c15e3106d27",
 CellID->232797302],
Cell[6723, 229, 388, 11, 36, "Text",ExpressionUUID->"a86a2342-5357-f246-94e9-318ae6f5640f",
 CellID->350152096],
Cell[7114, 242, 369, 11, 36, "Text",ExpressionUUID->"14c522bf-8b0c-9540-9ea9-92ed93812f72",
 CellID->151878190],
Cell[7486, 255, 455, 12, 60, "Text",ExpressionUUID->"7045bcf3-ccd5-8845-bde0-b9aa85c9ddf7",
 CellID->111653247],
Cell[7944, 269, 624, 17, 60, "Text",ExpressionUUID->"63492602-77cb-6341-bb65-0a08f0748180",
 CellID->90341842],
Cell[8571, 288, 135, 1, 36, "Text",ExpressionUUID->"6e217b20-4978-42ac-8c02-bf7bf4278248",
 CellID->150934655],
Cell[8709, 291, 579, 14, 60, "Text",ExpressionUUID->"38c53596-ad58-e04d-8f68-fa67418bcdcb",
 CellID->216404728],
Cell[CellGroupData[{
Cell[9313, 309, 5723, 155, 70, "Input",ExpressionUUID->"8c058cfe-2ea4-4637-b03b-d86f3371f893",
 CellID->1284592672],
Cell[15039, 466, 23593, 413, 241, "Output",ExpressionUUID->"90cfc5c6-2aad-4606-995c-2e9c139e6b72",
 CellID->996579375]
}, {2}]],
Cell[38644, 882, 238, 6, 60, "Text",ExpressionUUID->"b0199fce-2b0a-4ac4-ae9b-e238c73d0b20",
 CellID->204429578],
Cell[38885, 890, 187, 8, 71, "SolvedExample",ExpressionUUID->"f46f9908-d31b-40a1-8f7e-cf8d1ed58b1b",
 CellID->194277603],
Cell[39075, 900, 424, 12, 39, "SolvedExampleNote",ExpressionUUID->"7269adc8-09fb-4fcb-9a48-d633e54c1eeb",
 CellID->31915663],
Cell[39502, 914, 458, 11, 39, "SolvedExampleNote",ExpressionUUID->"95f9f09f-ce27-4e08-8a8a-ada264db49c5",
 CellID->23017979],
Cell[39963, 927, 125, 1, 39, "SolvedExampleNote",ExpressionUUID->"cfc56f41-4b4b-4e3a-9113-3729c3fbbce9",
 CellID->36566290],
Cell[40091, 930, 639, 18, 43, "SolvedExampleNote",ExpressionUUID->"f67dc5c0-299d-4bef-998a-d8dfd0e2cf4a",
 CellID->43637267],
Cell[40733, 950, 148, 1, 39, "SolvedExampleNote",ExpressionUUID->"e2a4942d-a22e-4565-bac7-52653ff5f71b",
 CellID->121691467],
Cell[40884, 953, 390, 10, 43, "SolvedExampleNote",ExpressionUUID->"61d5e3cf-4aaa-406f-aa61-45bf469e453f",
 CellID->199923384],
Cell[41277, 965, 660, 19, 39, "SolvedExampleNote",ExpressionUUID->"c4a7dad1-c7d8-46b3-8c34-fb7c40e25aa2",
 CellID->19139663],
Cell[41940, 986, 176, 6, 39, "SolvedExampleNote",ExpressionUUID->"67b48d37-d0cb-4b12-99c7-e972536943ce",
 CellID->301148254],
Cell[CellGroupData[{
Cell[42141, 996, 249, 6, 25, "SolvedExampleInput",ExpressionUUID->"6dd9dc0d-7507-477f-ac45-7dd4dc46b4ab",
 CellID->54367541],
Cell[42393, 1004, 270, 8, 57, "SolvedExampleOutput",ExpressionUUID->"d301a29c-c030-4c6a-82f1-01adcbb61a2f",
 CellID->221600778]
}, Open  ]],
Cell[42678, 1015, 104, 1, 39, "SolvedExampleNote",ExpressionUUID->"fd1a4f20-5c22-4775-a64b-06a604e473ae",
 CellID->95343],
Cell[CellGroupData[{
Cell[42807, 1020, 262, 7, 25, "SolvedExampleInput",ExpressionUUID->"366905d0-c8fa-46dd-8aff-ad9aa2b5555f",
 CellID->77089032],
Cell[43072, 1029, 159, 3, 54, "SolvedExampleOutput",ExpressionUUID->"c3912167-f941-4b5b-82a3-a81cef8d8d5f",
 CellID->115989526]
}, Open  ]],
Cell[43246, 1035, 231, 6, 39, "SolvedExampleNote",ExpressionUUID->"670a1323-79cf-4fe7-8388-ee1bea05bc3d",
 CellID->400301595],
Cell[CellGroupData[{
Cell[43502, 1045, 202, 4, 25, "SolvedExampleInput",ExpressionUUID->"16732078-aa5e-48db-9601-19d4aa12ebd8",
 CellID->326987186],
Cell[43707, 1051, 168, 3, 36, "SolvedExampleOutput",ExpressionUUID->"b3db5507-a24a-4838-96ab-77a6707b574f",
 CellID->185847010]
}, Open  ]],
Cell[43890, 1057, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"cbfa91bc-67f7-4f67-89fe-fd9a173880aa",
 CellID->943814759],
Cell[43999, 1060, 649, 14, 60, "Text",ExpressionUUID->"cc97d093-6d29-493f-8ecd-7b5e1ef45b7d",
 CellID->245460964],
Cell[44651, 1076, 1934, 58, 98, "DisplayFormulaNumbered",ExpressionUUID->"9a847823-49ac-43c4-8905-3c343c7e1852",
 CellID->4095132],
Cell[46588, 1136, 158, 3, 36, "Text",ExpressionUUID->"cf0b646e-14f6-4f91-b46a-dbfeeaebcab4",
 CellID->5776323],
Cell[46749, 1141, 206, 4, 60, "Text",ExpressionUUID->"af15e12d-6ecb-4d1f-a708-3c96e5d9cc3b",
 CellID->97649586],
Cell[CellGroupData[{
Cell[46980, 1149, 6284, 175, 456, "Input",ExpressionUUID->"968c9b6f-68fd-498e-8b90-281c578cd3f8",
 CellID->453742080],
Cell[53267, 1326, 5182, 109, 472, "Output",ExpressionUUID->"ffdb1af4-208d-43fa-970a-033198181e09",
 CellID->465123820]
}, {2}]],
Cell[58461, 1438, 362, 6, 83, "Text",ExpressionUUID->"504524d0-e461-496b-80b9-1db608aafd09",
 CellID->219531818]
}, Open  ]],
Cell[CellGroupData[{
Cell[58860, 1449, 114, 1, 56, "Subsection",ExpressionUUID->"975e6d71-f464-4e06-9a67-5ca7d489bc0a",
 CellID->510115987],
Cell[58977, 1452, 258, 5, 60, "Text",ExpressionUUID->"18fe53c5-94db-4675-8061-d021c6844f14",
 CellID->642972206],
Cell[CellGroupData[{
Cell[59260, 1461, 109, 1, 54, "Subsubsection",ExpressionUUID->"8a3d7a57-d9a6-4a98-8dfb-799239b0aca2",
 CellID->40632655],
Cell[59372, 1464, 131, 1, 36, "Text",ExpressionUUID->"04ebe247-f702-4e3e-89cf-c8a6ef31803e",
 CellID->443889050],
Cell[59506, 1467, 415, 11, 56, "DisplayFormulaNumbered",ExpressionUUID->"ea1ec447-3ead-4163-bc0d-dfc86c2d9d7d",
 CellID->186328943],
Cell[59924, 1480, 504, 16, 41, "Text",ExpressionUUID->"4c474523-b4fa-4deb-a25f-80a815605b59",
 CellID->1471017497],
Cell[60431, 1498, 301, 8, 36, "Text",ExpressionUUID->"71d0e53c-e48f-46ac-84d5-d6e36604dfbe",
 CellID->211267330],
Cell[60735, 1508, 288, 8, 36, "Text",ExpressionUUID->"3717e750-44f0-4995-9122-005aee28b9ae",
 CellID->12722605],
Cell[61026, 1518, 290, 8, 36, "Text",ExpressionUUID->"f0920527-14d6-416e-a2fe-95cf3ceae72b",
 CellID->343519956],
Cell[61319, 1528, 190, 4, 36, "Text",ExpressionUUID->"58c32fa9-146f-42d7-8e56-f40df9ad6fe6",
 CellID->311763549],
Cell[61512, 1534, 187, 8, 71, "SolvedExample",ExpressionUUID->"385982d5-8b04-4f64-9605-b306a72cfdb0",
 CellID->203404213],
Cell[61702, 1544, 149, 1, 39, "SolvedExampleNote",ExpressionUUID->"f2fbf1e9-733e-4874-890b-6667840b6bc5",
 CellID->382612225],
Cell[61854, 1547, 1056, 33, 45, "SolvedExampleNote",ExpressionUUID->"a3f2c320-fe08-4b7f-84bc-fa902fb1af62",
 CellID->16175874],
Cell[62913, 1582, 423, 9, 61, "SolvedExampleNote",ExpressionUUID->"13ab3c10-5fd6-4d35-8279-0e987526c12f",
 CellID->153109261],
Cell[63339, 1593, 280, 9, 39, "SolvedExampleNote",ExpressionUUID->"cb87fc0f-0351-4a46-bd7d-e214a7de21c4",
 CellID->446124757],
Cell[CellGroupData[{
Cell[63644, 1606, 261, 6, 25, "SolvedExampleInput",ExpressionUUID->"2c5b0d29-9e3c-4678-8dbf-7a6b76ba08c7",
 CellID->448336427],
Cell[63908, 1614, 168, 3, 36, "SolvedExampleOutput",ExpressionUUID->"e01307d2-3707-4e0d-921a-f61b81362b9f",
 CellID->733391596]
}, Open  ]],
Cell[64091, 1620, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"f65abd6a-358f-49c4-a3de-133ad6b0598e",
 CellID->1564853361]
}, Open  ]],
Cell[CellGroupData[{
Cell[64235, 1626, 109, 1, 54, "Subsubsection",ExpressionUUID->"7365b72c-4647-401d-b2bb-a95e61cad0a6",
 CellID->663567435],
Cell[64347, 1629, 130, 1, 36, "Text",ExpressionUUID->"0bdd2027-d4dc-4529-9842-45876d9d5fbd",
 CellID->737219293],
Cell[64480, 1632, 415, 11, 56, "DisplayFormulaNumbered",ExpressionUUID->"9073d57b-690f-4d42-ba3a-3d5ff08492ef",
 CellID->526390522],
Cell[64898, 1645, 476, 15, 44, "Text",ExpressionUUID->"46c5061d-d707-4802-b67d-c82e32c014f8",
 CellID->480524459],
Cell[65377, 1662, 300, 8, 36, "Text",ExpressionUUID->"e3d8b390-081f-f647-af1e-dc14abe48728",
 CellID->32302646],
Cell[65680, 1672, 289, 8, 36, "Text",ExpressionUUID->"0125e8de-aa17-3249-ba17-61a9d56d079e",
 CellID->236336973],
Cell[65972, 1682, 290, 8, 36, "Text",ExpressionUUID->"5be95e38-c75f-044a-b9d3-841ca0ee15e1",
 CellID->236320815],
Cell[66265, 1692, 184, 8, 71, "SolvedExample",ExpressionUUID->"dffa3239-8d83-4523-ab8f-6cab269b8dea",
 CellID->511901],
Cell[66452, 1702, 148, 1, 39, "SolvedExampleNote",ExpressionUUID->"5a1a2578-7275-400a-8fdb-a6b3f75aacb6",
 CellID->442206837],
Cell[66603, 1705, 733, 22, 39, "SolvedExampleNote",ExpressionUUID->"d346fc29-2da2-47f2-aa20-1b8a054b4e5a",
 CellID->720765755],
Cell[67339, 1729, 190, 3, 39, "SolvedExampleNote",ExpressionUUID->"20318484-9381-4a61-82a6-76527e407947",
 CellID->294263374],
Cell[67532, 1734, 278, 9, 39, "SolvedExampleNote",ExpressionUUID->"2ed75c43-0a66-46c3-aa7f-3c6a49b4be99",
 CellID->238100169],
Cell[CellGroupData[{
Cell[67835, 1747, 260, 6, 25, "SolvedExampleInput",ExpressionUUID->"7edde848-7c5b-4ad3-aa6d-1291e6df0f16",
 CellID->225341602],
Cell[68098, 1755, 168, 3, 36, "SolvedExampleOutput",ExpressionUUID->"b8297f2c-79d5-495d-9e6e-0292fd951df9",
 CellID->316064249]
}, Open  ]],
Cell[68281, 1761, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"37de4a02-e988-4cdc-9c26-2b2bdfb19a5e",
 CellID->1215728965],
Cell[68391, 1764, 187, 8, 71, "SolvedExample",ExpressionUUID->"94028bca-dd18-4fce-b3e9-24cd62d8a600",
 CellID->268746911],
Cell[68581, 1774, 644, 19, 42, "SolvedExampleNote",ExpressionUUID->"99a38984-0025-4144-afad-7b9ea0ea7bab",
 CellID->2919492],
Cell[69228, 1795, 182, 6, 39, "SolvedExampleNote",ExpressionUUID->"85139266-8d98-442d-8921-e60e9012f6cb",
 CellID->899508737],
Cell[CellGroupData[{
Cell[69435, 1805, 415, 12, 47, "SolvedExampleInput",ExpressionUUID->"87d07b07-2f4d-4d72-82d9-8a0375ce6c7c",
 CellID->260125112],
Cell[69853, 1819, 118, 1, 36, "SolvedExampleOutput",ExpressionUUID->"1b92c286-711a-4ff6-a0f0-6d74ff784ab5",
 CellID->53118281]
}, Open  ]],
Cell[69986, 1823, 128, 1, 39, "SolvedExampleNote",ExpressionUUID->"7f367a4a-0dc2-4370-8441-d4730123bace",
 CellID->59314548],
Cell[70117, 1826, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"c34ff345-c8bd-4f79-a8e8-28f1d3b6d987",
 CellID->515156329]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70272, 1833, 105, 1, 56, "Subsection",ExpressionUUID->"e2a9ad81-c661-400b-b717-9c1c047d224a",
 CellID->509614559],
Cell[70380, 1836, 192, 4, 36, "Text",ExpressionUUID->"15d59994-306f-45be-940b-a4357309cf09",
 CellID->58553324],
Cell[70575, 1842, 187, 8, 71, "SolvedExample",ExpressionUUID->"f9f32f6b-57cd-4a30-9cbc-a3052e8cc792",
 CellID->409109291],
Cell[70765, 1852, 388, 10, 39, "SolvedExampleNote",ExpressionUUID->"ad19b895-0c5f-4a49-af6b-90a4f8f8d72d",
 CellID->344419435],
Cell[71156, 1864, 902, 25, 44, "SolvedExampleNote",ExpressionUUID->"a2b4d549-a92b-4c99-8e30-8e86f713d434",
 CellID->406179465],
Cell[72061, 1891, 398, 8, 61, "SolvedExampleNote",ExpressionUUID->"800303cd-b28b-4f22-9f13-eca9eb797257",
 CellID->13349720],
Cell[72462, 1901, 922, 29, 45, "SolvedExampleNote",ExpressionUUID->"c212026a-3a20-40a1-905d-53ddde8dec82",
 CellID->24230206],
Cell[73387, 1932, 171, 6, 39, "SolvedExampleNote",ExpressionUUID->"41902bea-bbfe-41dd-90d4-6c9b8b5689b9",
 CellID->17861973],
Cell[CellGroupData[{
Cell[73583, 1942, 255, 6, 25, "SolvedExampleInput",ExpressionUUID->"7c4cd0d9-9cb4-43e0-a475-ae58df99b6e7",
 CellID->1614823],
Cell[73841, 1950, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"28e903ef-5db1-4d77-b32f-68e666f3c6f2",
 CellID->458781176]
}, Open  ]],
Cell[73972, 1954, 767, 21, 61, "SolvedExampleNote",ExpressionUUID->"64aa35c7-fdf9-4d8a-bcb4-4e78cffe97c9",
 CellID->74818161],
Cell[CellGroupData[{
Cell[74764, 1979, 247, 6, 25, "SolvedExampleInput",ExpressionUUID->"bf9c39be-c547-456e-99e9-4e8c27c9210f",
 CellID->139819750],
Cell[75014, 1987, 119, 1, 36, "SolvedExampleOutput",ExpressionUUID->"b99bbed4-cace-454d-bf68-35708ab46d4b",
 CellID->224445426]
}, Open  ]],
Cell[75148, 1991, 447, 11, 43, "SolvedExampleNote",ExpressionUUID->"4701d961-8598-45de-951a-e2d8e79d7c37",
 CellID->7165959],
Cell[75598, 2004, 1527, 45, 45, "SolvedExampleNote",ExpressionUUID->"4c7cd448-d1d9-46bb-8733-022e5ff6b0a0",
 CellID->744726197],
Cell[77128, 2051, 460, 13, 43, "SolvedExampleNote",ExpressionUUID->"3ab5adcd-2b3f-434c-a6d1-a1f9813c9dec",
 CellID->474105480],
Cell[77591, 2066, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"c3663234-3fad-4133-9567-9694136bf685",
 CellID->1087475563],
Cell[77701, 2069, 187, 8, 71, "SolvedExample",ExpressionUUID->"a13e3603-2c88-4f47-8445-4e59610119d1",
 CellID->301852218],
Cell[77891, 2079, 746, 21, 43, "SolvedExampleNote",ExpressionUUID->"c0ad1791-3619-4103-9835-12a988742a69",
 CellID->207906595],
Cell[78640, 2102, 123, 1, 39, "SolvedExampleNote",ExpressionUUID->"c4e0b733-a9b5-4dac-aff6-4320ac66b454",
 CellID->769796789],
Cell[78766, 2105, 785, 24, 43, "SolvedExampleNote",ExpressionUUID->"9ae34076-a04a-4f80-9660-d8ce0be8df86",
 CellID->798630177],
Cell[79554, 2131, 173, 6, 39, "SolvedExampleNote",ExpressionUUID->"0a008702-1181-4b39-a709-fe316ba25789",
 CellID->124183039],
Cell[CellGroupData[{
Cell[79752, 2141, 307, 9, 47, "SolvedExampleInput",ExpressionUUID->"4b3ed5db-1b41-443a-a7f6-25c9acea3464",
 CellID->353721022],
Cell[80062, 2152, 188, 4, 54, "SolvedExampleOutput",ExpressionUUID->"1b49caf9-4249-462b-8570-3f1b97f06fda",
 CellID->323016079]
}, Open  ]],
Cell[80265, 2159, 419, 13, 42, "SolvedExampleNote",ExpressionUUID->"2e2ab333-299a-4ee4-8a8e-7e46a1063468",
 CellID->126765190],
Cell[CellGroupData[{
Cell[80709, 2176, 412, 12, 47, "SolvedExampleInput",ExpressionUUID->"5e7144a2-3488-4c82-925d-3ff9871f62f5",
 CellID->294974709],
Cell[81124, 2190, 188, 4, 54, "SolvedExampleOutput",ExpressionUUID->"a2ec766e-1cf7-4d14-a770-e05079b3574b",
 CellID->324386536]
}, Open  ]],
Cell[81327, 2197, 180, 2, 39, "SolvedExampleNote",ExpressionUUID->"9f540080-144e-4c64-bd9a-39beb442c00a",
 CellID->506829140],
Cell[CellGroupData[{
Cell[81532, 2203, 1582, 41, 47, "SolvedExampleInput",ExpressionUUID->"d2441415-12db-43fb-9a63-a490a2ce46df",
 CellID->62400502],
Cell[83117, 2246, 325880, 5362, 200, "SolvedExampleOutput",ExpressionUUID->"41fedf63-7ec5-46d4-82c1-3a4c4779b957",
 CellID->378528672]
}, Open  ]],
Cell[409012, 7611, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"5c96f29e-5255-4099-8388-c5b91043621d",
 CellID->1694408823],
Cell[CellGroupData[{
Cell[409144, 7616, 109, 1, 69, "SummarySection",ExpressionUUID->"e8c41289-61be-49b6-b746-71ff050a5853",
 CellID->1198545324],
Cell[409256, 7619, 609, 17, 29, "SummaryList",ExpressionUUID->"091cc5af-ab4d-403e-9649-80b232c87be7",
 CellID->313287077],
Cell[409868, 7638, 539, 15, 29, "SummaryList",ExpressionUUID->"f2e2baa0-7432-4d5b-a3a3-0cb8e563612f",
 CellID->71874767],
Cell[410410, 7655, 639, 17, 29, "SummaryList",ExpressionUUID->"37cbfdb2-51b4-4ab2-9c75-f4fc566f9d71",
 CellID->114880579],
Cell[411052, 7674, 1064, 31, 35, "SummaryList",ExpressionUUID->"7c9c890f-bd30-488c-8ede-eb9b1150e278",
 CellID->645123762],
Cell[412119, 7707, 669, 20, 35, "SummaryList",ExpressionUUID->"0f0af0b1-fce4-48c3-9e9d-0412df7da068",
 CellID->34159819]
}, Open  ]],
Cell[CellGroupData[{
Cell[412825, 7732, 160, 3, 65, "ExerciseSection",ExpressionUUID->"1bf82b4d-9dc7-4379-9f37-edc33852bccd",
 CellID->317007102],
Cell[412988, 7737, 532, 14, 34, "Exercise",ExpressionUUID->"90bec0bd-b72b-4cab-92a7-2479b3841d7f",
 CellID->13935825],
Cell[CellGroupData[{
Cell[413545, 7755, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"d2e07176-9796-414b-a118-821421b1d67e"],
Cell[413639, 7757, 884, 29, 28, "SolutionAnswer",ExpressionUUID->"390fdf60-1439-47de-b2c1-5d150c4dcf74",
 CellID->414225805],
Cell[CellGroupData[{
Cell[414548, 7790, 222, 5, 25, "ExerciseInput",ExpressionUUID->"9e4f0523-fd99-40c8-b995-d1f7849c15d3",
 CellID->414906115],
Cell[414773, 7797, 232, 5, 28, "ExerciseOutput",ExpressionUUID->"7eb99c3c-0f04-4e9d-9494-ef14dc5591de",
 CellID->344618849]
}, Open  ]],
Cell[415020, 7805, 454, 12, 43, "SolutionAnswer",ExpressionUUID->"1d6d2fa3-b549-444b-a343-eb8e5ddf0788",
 CellID->758516228]
}, Closed]],
Cell[415489, 7820, 609, 17, 32, "Exercise",ExpressionUUID->"a083228e-68b1-4c8c-9bb2-ca754979b75a",
 CellID->35530864],
Cell[CellGroupData[{
Cell[416123, 7841, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"eea4a1ba-4667-4b90-8dfa-3ad2224fb73f"],
Cell[416217, 7843, 1788, 60, 52, "SolutionAnswer",ExpressionUUID->"93e54f0a-ee12-4ed7-a00c-9ff2b0310837",
 CellID->393777318],
Cell[CellGroupData[{
Cell[418030, 7907, 298, 9, 25, "ExerciseInput",ExpressionUUID->"585b7f05-f75c-4c7b-9bba-73ae25756d47",
 CellID->250613830],
Cell[418331, 7918, 113, 1, 28, "ExerciseOutput",ExpressionUUID->"319d9add-e3ee-4e08-8056-be618faf1e5d",
 CellID->37554071]
}, Open  ]]
}, Closed]],
Cell[418471, 7923, 971, 28, 50, "Exercise",ExpressionUUID->"5dfbdbeb-62d3-4d0f-9657-c6bc925715a7",
 CellID->5899690],
Cell[CellGroupData[{
Cell[419467, 7955, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"ba680fbf-2758-4b53-a31c-c5fb61f33208"],
Cell[419561, 7957, 1247, 41, 31, "SolutionAnswer",ExpressionUUID->"cb09e449-5299-4716-bc51-48e9724af479",
 CellID->370152869],
Cell[CellGroupData[{
Cell[420833, 8002, 398, 12, 48, "ExerciseInput",ExpressionUUID->"297a48fc-65b8-475d-b5fb-5836ccceb2a3",
 CellID->299310912],
Cell[421234, 8016, 218, 5, 28, "ExerciseOutput",ExpressionUUID->"f412f123-8455-4b61-9bcd-cd0cc2a68f08",
 CellID->236215999]
}, Open  ]]
}, Closed]],
Cell[421479, 8025, 551, 15, 25, "Exercise",ExpressionUUID->"436aafd1-59af-47f0-ab2f-01bf7b578ae3",
 CellID->139441506],
Cell[CellGroupData[{
Cell[422055, 8044, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"da3c0eee-a996-44ce-9e3c-8399ed1a7b53"],
Cell[422149, 8046, 1382, 45, 49, "SolutionAnswer",ExpressionUUID->"4ba0f181-ebb8-42dd-a0e3-eee9d2d7a9ac",
 CellID->295813446],
Cell[CellGroupData[{
Cell[423556, 8095, 237, 6, 25, "ExerciseInput",ExpressionUUID->"558c91c7-2afc-41b4-831e-9059883e6fe9",
 CellID->88865564],
Cell[423796, 8103, 139, 2, 28, "ExerciseOutput",ExpressionUUID->"3fbee09c-1dfc-4f99-b8de-12a445944069",
 CellID->58671309]
}, Open  ]]
}, Closed]],
Cell[423962, 8109, 619, 17, 29, "Exercise",ExpressionUUID->"8ab14c78-12fe-4bce-91ff-9bc23336752d",
 CellID->84639373],
Cell[CellGroupData[{
Cell[424606, 8130, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"eadb1164-7616-45af-8213-75e1f6497a9a"],
Cell[424700, 8132, 1041, 34, 26, "SolutionAnswer",ExpressionUUID->"f4f1f5a4-0181-46b4-be87-3f9087a1113a",
 CellID->111813037],
Cell[425744, 8168, 307, 10, 22, "SolutionAnswer",ExpressionUUID->"bc899e03-97c7-4808-9331-5a8183138a00",
 CellID->1163349865],
Cell[CellGroupData[{
Cell[426076, 8182, 359, 11, 25, "ExerciseInput",ExpressionUUID->"9203ce88-6c16-4be9-b4ef-bcfb9d600473",
 CellID->68495893],
Cell[426438, 8195, 182, 4, 44, "ExerciseOutput",ExpressionUUID->"7362f913-a4d5-48fb-a8a0-1b74617bae60",
 CellID->82266147]
}, Open  ]],
Cell[426635, 8202, 186, 6, 22, "SolutionAnswer",ExpressionUUID->"5ba9eb28-698a-4bf5-90db-6b7b5ddde9fb",
 CellID->261149122],
Cell[CellGroupData[{
Cell[426846, 8212, 408, 12, 46, "ExerciseInput",ExpressionUUID->"7c8b4976-fd36-47cb-8410-a322fbf90092",
 CellID->350068735],
Cell[427257, 8226, 183, 4, 44, "ExerciseOutput",ExpressionUUID->"1b976e34-7c69-4c98-8bef-b4fc8f0528ce",
 CellID->310676060]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[427503, 8237, 310, 6, 135, "SmallText",ExpressionUUID->"6eef1ea2-3242-4c2e-a367-c3a2970fe7f3",
 CellGroupingRules->"SectionGrouping",
 CellID->1545359602]
}
]
*)

(* NotebookSignature 0ScsY86i30vQJiuXW1dDwiL9 *)
