(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    611885,      12938]
NotebookOptionsPosition[    427640,       9162]
NotebookOutlinePosition[    590433,      12544]
CellTagsIndexPosition[    590390,      12541]
WindowTitle->21. Laurent Series | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Laurent Series"
}], "Section",
 CounterAssignments->{{"Section", 20}},
 CellID->286168533,ExpressionUUID->"134c92d4-955e-467f-aab0-d7f25d1e0736"],

Cell[TextData[{
 "You have seen in ",
 ButtonBox["Chapter 20",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 " that an analytic function can be represented by an infinite series, the \
Taylor series. The Taylor series is a power series and has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
    SuperscriptBox[
     RowBox[{
      SubscriptBox["a", "n"], "(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "n"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"24363289-26f0-49af-b614-19358b927f2b"],
 "."
}], "Text",
 CellID->365437108,ExpressionUUID->"6ba93b03-781a-4cb3-83bf-aace51bae17f"],

Cell[TextData[{
 "This chapter will be about a more general series called the Laurent series, \
which also allows negative powers of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}], "n"], TraditionalForm]], "InlineMath",
  ExpressionUUID->"04dc2603-77ef-468d-9382-bce098af1c5e"],
 ". In this way, you will be able to represent some functions that are not \
analytic at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "411526c7-c05e-46b8-a09d-e4574e611325"],
 "."
}], "Text",
 CellID->516644382,ExpressionUUID->"0e68a71c-be55-4359-8616-52fad0af8081"],

Cell[CellGroupData[{

Cell["Motivation: Rational Functions", "Subsection",
 CellID->101444006,ExpressionUUID->"5ab3d377-a0d4-4860-bd0f-85aaaeb90c7d"],

Cell[TextData[{
 "Consider, for example, the case of a rational function, such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "+", "1"}], 
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "2"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7913f1f3-0693-487f-9871-9f3e4d89a4cb"],
 ", which is shown in Fig. 1."
}], "Text",
 CellID->9241870,ExpressionUUID->"0cf2c512-1080-4353-ae61-480fcbf8c1d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexPlot3D", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"z", "+", "1"}], 
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "4"}], "}"}], ",", 
    InterpretationBox[
     DynamicModuleBox[{Typeset`open = False}, 
      TemplateBox[{"Expression", "SequenceIcon", 
        GridBox[{{
           RowBox[{
             TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["Sequence", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["5", "IconizedItem"]}]}, {
           RowBox[{
             TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
             TagBox["920", "IconizedItem"]}]}}, 
         GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
         "Column", 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
        Dynamic[Typeset`open]},
       "IconizedObject"]],
     Sequence[
     PlotRange -> {0, 4}, BoxRatios -> {1, 1, 1/2}, PlotLegends -> Automatic, 
      AxesLabel -> {
        Re[$CellContext`z], 
        Im[$CellContext`z]}, AxesStyle -> Directive[12]],
     SelectWithContents->True,
     Selectable->False]}], "]"}], "//", 
  InterpretationBox[
   DynamicModuleBox[{Typeset`open = False}, 
    TemplateBox[{"Expression", 
      RowBox[{"Function", "[", 
        DynamicBox[
         FEPrivate`FrontEndResource["FEBitmaps", "IconizeEllipsis"]], "]"}], 
      GridBox[{{
         RowBox[{
           TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
           TagBox["896", "IconizedItem"]}]}}, 
       GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
       "Column", 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
      Dynamic[Typeset`open]},
     "IconizedObject"]],
   Labeled[#, 
    Text[("Fig. 1. The function " <> ToString[
        HoldForm[$CellContext`f[$CellContext`z] == ($CellContext`z + 
           1)/($CellContext`z ($CellContext`z - 2))], TraditionalForm]) <> 
     "."]]& ,
   SelectWithContents->True,
   Selectable->False]}]], "Input",
 CellID->105897992,ExpressionUUID->"5b761197-a90c-4c59-9905-132cf4266615"],

Cell[BoxData[
 TemplateBox[{
   TemplateBox[{
     Graphics3DBox[{
       GraphicsComplex3DBox[CompressedData["
1:eJyVnXdcT+///1sUSiEyMpJNyc58vcxs75AVkT3K3tl7FFnZOzJDGUVpSKK9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        "], {{{
           EdgeForm[], 
           Texture[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJy9nXd0lVX293/rfdcaxQLYdbxB7J0aSOhVEKX3qoKACIiAqCjSEQEBkd6k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               "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> 
               RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
              False], DefaultBaseStyle -> "ImageGraphics", 
             ImageSizeRaw -> {144., 144.}, 
             PlotRange -> {{0, 144.}, {0, 144.}}]], 
           GraphicsGroup3DBox[
            TagBox[{
              Polygon3DBox[CompressedData["
1:eJxNnXfc1+P3xz/zroyEjKw2DSPR0KBUJJJZkZFEKYmyGxpKlBYSEbJX+fG1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               "]], 
              Polygon3DBox[CompressedData["
1:eJwtkk0rhFEUx++YOU+RZiTZkLcospzl2FvY2dr5AOys5gv4BorBxkuKlCFq
akhmdl5LIjQLTSzYYEqK37/zLH7dc55z7r3n/79P//Ts5ExTCGEEUrBhIfQS
dLEuwirskG9CkfgcvpIhlBIh/BFfQBauyIejEO6I6/R+k7+Z79HebVghvoQc
5GELdmE+5Xfq7iOoEk9BB+c1yO85q4d8nfhJPeQLzNBO/dX8rlbqa8S/5rM1
qJ9qr7mWBt8+WIfY80nvHvkgcR9MkJfhgPoN1IgL1Fuo1c3PHpNGeDGPc7GW
TnquEz6zZj+DdDzjM+u+uXb1qLcbKtKiGai9x7PJs6q5RmmVJ/KmBpn4TJ1d
kN6Uv8GyuefyXpqOyU/MvcvGb5OmvpRwTSVzT+SNPP0x1yztRXlMr8Eo38bh
EZKRx7pTd6tHvdJwaO6hvJwjfohRLE8HIn/jfKyhAs2Re6s7bqEt8rfUjJnI
PZE3+uf07/0Dmppkbw==
               "]]}, Annotation[#, "Charting`Private`Tag$34356#1"]& ]]}, {}, {
          
           EdgeForm[], 
           GrayLevel[0.82], 
           GraphicsGroup3DBox[{
             Polygon3DBox[CompressedData["
1:eJxFlM9L1FEUxd/ovC+BjDDqWFkW0SKK0bQ/ImzruBTM2WurRDethjaujCiM
QPu10CnCFg7kImhZLTKCElqERQURRP4YrU3n8D7g4nLve++++8497957qnpl
eLIlhDAnaZW8iyFclLRlIZSlz0sq+RDeSgawZ6T7JM9zISxpfUH2iPRgTPaW
Ag1r3S97XnYV/23Zde1PSzZyKXYZnwr+a7nkO4B/Sbooadf5EWEK0kezdN4H
Hr85CAbHXiB+P/gdv6A7m9pf07op3ZZP+GvSf1qT/URnU1o/lh6XnJB819mq
9sYkH3OJm0sx5TctPYRtHobI/VCWfG5IOmPiriDplt1rfPI5I58d2S+0dzpL
b72S7EgWdb4r/UvSY/zgqoHZ+R0n1hb+2zHlUeZfzNP1fMLvXKe46zuOaQyl
LPnc1voceM5Kd8T0T+bQnC7n07+YZ+fpHJ1Thf1/2t+XfTMmXMZnTL77V7IL
hiYczvDvFXgbyR/8exOc5uMy/Fs/Ipe9fKon14bxjuPju1Xu2zfg35IlvO/N
V5bOVqiLfjCcZP+Z1l2SSfhxrD0wuw5t+13/8zX+Op8l+xN941pwvS2Tl3N3
zAlq+EtMtfRVugG39nHd1rFrYHOsHmr+GP3oP57HZwnejMvxjXOSHPzWLPVp
P/MzQ745OGmhTqd5q4yP+fe/7YNnE8zGvk297VCv/qc3kjmw3ZW+St261jZY
/ybfOr0wQF+YzzH60fi9t47POnPHOd6LyedzTNz5Tl36NRjcQwv0/yJzpgH+
DzoflfyMiUfz2YiJ+wZv/XDtSj+M6Q2/dT+mnm2nF9b5rwIzKPA/t5g/AQy9
+PuPZuF/mXycy7eYZsoDzmvxYF7WmIHGsgonVWqvyYyZxf8lfef+62BOFqgF
+xv3KHm5nlfoI9e7ee2kj9z/ngOHs3THcYzfs8k95tlQ5A3v+583qXPz3MG7
ReZdgdhF4vv9LnrKeyX2u8DmHCeoW9u71NgderGbu0/B6bnVzVk7PVrC7mXO
Gud/5l7fSA==
              "]], 
             Polygon3DBox[CompressedData["
1:eJwtkjtLA1EQha9mZxGCtSIbQRDE0j8hsRVLwcQfEKuEVFZi7xMjgm9QfIGF
ASUWYiFoGlFEsEqhggiSoKCV3zBTfMyZvXt35hy2b3JqtNAeQuiHCI4lhBlE
CY7Qg3EI3+i3VAj79Gn6YWqF/pw6DyNiz+7hA8ZhnfMadQnK3P+hX0HvQQ56
4RYOxWalYVNshs6apT9B1/W+z+iIbabObnDeSV+h74EiPENVzMguZDgPMMSz
Fnfa0KvojZTtpLvVfFf9xic8+LvT1Ij3D6gTvHsGr+hr+EOPwQL6BjLohNqE
U7HZOfe6A0lkmTzBJeTFMh2ILRPN5pf+Cv0IWfdc928mvnOLeiHmvUk/h+6K
LSv13I3eEstSd26g7zzrvM/eFvOiO72jvzw79aBe1JN608yWYU1slv4T+m8s
iu2qGWgWL2JZZX33f3bOVPw=
              "]]}]}, {}, {}}, {{
           GrayLevel[0], 
           Line3DBox[CompressedData["
1:eJwl0jVORUEYBtDB3V0ehBbZAE6HdNAgHQUOD3fXDSAbgA0gG4ANIBuAmgTZ
AHBeKE7mm5ubfP/MvTXD0d6ZuBDCEe1JIcTye2II1wkhVMstDLHGBXe88E2O
lxvoYZwTrnjgjV8i8SE0McAKZ9zwxCdZeuroollvrxlG5VZr1H5MHmeCSaaY
ZoYos8wxzwKLLLHMCqussc4Gm2yxzQ677LHPQaxXZ5/uQ7nNOms/IndSSyYf
5n7kmlOW6aeRSn6c+5V7LjlmjG7qyebL/T1zyzmrDNIce6ajQ3eVHLG2myEi
V1JBOWWUUkIxRRRSQD555Ma+EdlkkUkG6aSRSgrJqAlqgurgCKEt8f9/+AMT
QzRv
            "]], 
           
           Line3DBox[{1554, 1502, 1503, 1477, 1505, 1478, 1450, 1488, 1509, 
            1489, 1511, 1445, 1513, 1514, 1496, 1516, 1479, 1518, 1519, 1498, 
            1521, 1481, 1435, 1447, 1456, 1446, 1527, 1528, 1529, 1530, 1475, 
            1532, 1533, 1534, 1535, 1486, 1438, 1437, 1539, 1501, 1541, 1542, 
            1543, 1494, 1545, 1546, 1491, 1548, 1468, 1550, 1551, 1552, 1553, 
            1554}], 
           
           Line3DBox[{1473, 1555, 1556, 1465, 1558, 1461, 1439, 1460, 1440, 
            1459, 1564, 1464, 1566, 1462, 1568, 1569, 1570, 1499, 1572, 1573, 
            1574, 1472, 1576, 1487, 1473}], 
           
           Line3DBox[{1506, 1442, 1504, 1441, 1452, 1453, 1454, 1436, 1425, 
            1467, 1549, 1466, 1547, 1490, 1426, 1544, 1485, 1493, 1500, 1540, 
            1492, 1538, 1537, 1536, 1430, 1427, 1476, 1428, 1531, 1474, 1432, 
            1429, 1434, 1526, 1525, 1524, 1523, 1522, 1480, 1520, 1497, 1433, 
            1517, 1469, 1515, 1495, 1444, 1512, 1443, 1510, 1451, 1508, 1507, 
            1506}], 
           Line3DBox[{1448, 1458, 1567, 1457, 1565, 1463, 1563, 1562, 1561, 
            1560, 1559, 1431, 1557, 1455, 1449, 1577, 1578, 1471, 1575, 1470, 
            1484, 1482, 1571, 1483, 1448}]}}}, 
        VertexNormals -> CompressedData["
1:eJycvHc4l/37BywkK4q2IpRRGhSS6h2VhEh7kKRSiKzsskdGZO+sjJKZzWnv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         "], VertexTextureCoordinates -> CompressedData["
1:eJyFm310VsWdgOMHGtAqOX6AULtikLaQFrWKthhG/IiuFKhykICUmlTqCZwu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         "]], {}}, {
      DisplayFunction -> Identity, DisplayFunction -> Identity, 
       DisplayFunction -> Identity, 
       Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
       DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
         FormBox[
          TagBox[
           RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
         FormBox[
          TagBox[
           RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, 
       AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
       Directive[12], BoxRatios -> NCache[{1, 1, 
          Rational[1, 2]}, {1, 1, 0.5}], DisplayFunction :> Identity, 
       Lighting -> "Neutral", Method -> {"RotationControl" -> "Globe"}, 
       PlotRange -> {{-3.9999997241379313`, 
        3.9999997241379313`}, {-3.9999997241379313`, 3.9999997241379313`}, {
        0., 4.}}, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02], Automatic}, 
       Ticks -> {Automatic, Automatic, Automatic}}], 
     FormBox[
      FormBox[
       TemplateBox[{
         FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             GraphicsBox[{
               RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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                "], {{
                  Rational[-15, 2], -75}, {
                  Rational[15, 2], 75}}], {Antialiasing -> False, 
                AbsoluteThickness[0.1], 
                Directive[
                 Opacity[0.3], 
                 GrayLevel[0]], 
                LineBox[
                 NCache[{{
                    Rational[15, 2], -75}, {
                    Rational[-15, 2], -75}, {
                    Rational[-15, 2], 75}, {
                    Rational[15, 2], 75}, {
                    Rational[15, 2], -75}}, {{
                   7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                   7.5, -75}}]]}, {
                CapForm[None], {}}, 
               StyleBox[{Antialiasing -> False, 
                 StyleBox[
                  StyleBox[{{
                    StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                    StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                    StyleBox[
                    StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                    StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                   False], {{
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]], 
                    Directive[
                    AbsoluteThickness[0.5], 
                    GrayLevel[0.4]]}}, StripOnInput -> False]}, {
                "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
              Scaled[0.02], PlotRange -> All, Frame -> True, 
              FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
              Opacity[0], FrameTicksStyle -> Opacity[0], 
              ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
             Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]}, "BarLegend", DisplayFunction -> (#& ), 
        InterpretationFunction :> (RowBox[{"BarLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{
                   RowBox[{
                    InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ
sjR2QkWWzuFw7Fs6lrN9z8I0aJoa5vz+gN+L+7qe63lxv7rv5/NoeVw+dkFM
REREVKgLQv1vLhkcHStV/ACqx1peSgYLohaxiqa7OOARS/czAzuhHqXg6E5j
wmuquYvUwMG/4eFBv3t249lSV3SxFBNq8enKW0HAbrMqP7GCBrkZZ9YZKwac
Q3rZaW8ITKffkax/24PGxBUyRyOm4dAycTdkLxfiK1qKf0zvxSnx/qsnyqaQ
KOe0ee41F8sl+243mPdhb3K4mzV7Env6F+R1zXhgXrC+NFjVB5m1NM6Y6iR6
OKfVt5XzwE0smUiR7cfdS80Low4ToLlmzKrr8xEkf2bxxf5+zBcpywqi6Yi6
LW8oX8BHb7YoCMd+/PTH0Ycu7p/wfZtOO0ldgEIdG8JrYQCygS8/b90zjsNu
qrOJKgKcFru1filgCP3BHxzFlD5ixyF2yPg6AR56hl3Kah2GvI+G9uTkKMpX
F49IrBVAfpXl14Flo3hWt8s+o3AEWfdEU5crCuCpcSaMsWkMdzSOsgo9hxHi
8UV5YpUA5by5xr/NPmLJbcOfuxWG0NyuzUuXEWDLiZrkdLNxeKtYPxL8MYCC
Q0+idFYKsMlYRrRJ9xO6yHnl2ejHbo+NR5IkBPjx9BwnRYKO+cL90hLVvajk
/d01ICqA/1aLG0mBdLyeySMpK/Tgp3Txa1//5WNp3+dDDI8JhA7ekCF50MCQ
9hW8iONjuO+GcajtJK4+PBmkV9ANnYfdytWKfBifyiD9rjaFbq2CJF5NFyz8
wnZqPOZhplA5+0diCkleVZWmElRYBZvFTOvx4LCpfIlSPI0EdpQ+U68DX9bY
2a+o5iLk2qqjjhcZWOih59hqkVG6XffPeCsurjFlmvrUmBCxmfPuGG1DpN/j
scBuAk+d/gla08GEZ0K83ya7FrzMabhT4ybM1UFBUmMwCxxNvdr3lk0YdBb/
7TyXA27xCRH3dWzcL1oh8FRvgD3zScjVMA4iZo79RUtho15bt6Kyoh7k3eT+
H8LYWOmCFDsJDhqbVdRiLtYjnmtsoxrOwjqLhX/9AznQzLx3gmNRj7tj2/Sj
IpkI+usxfbiPg30WLl4l2+pBpxnydkUz8L1l1FLJiECVlN990731yGPYHbO6
OY3MCql7qfEE6K6L5FTfeux9lTGXED+FLAMTommcQKvzFcUbZfUIa66xl0md
RPzxd4Zi+lyMJZffjlNqwGJncFL+wwnoldeHF13lIsE/RXsmoQHF5iYb9+bT
sX618clV9Vy4lmVYT2k0QsyNQzonzHXqLvKsGY8L2bfDbfm0d3Dv854njX6E
z5aFg19IPDifdPButXmPFPVDq3qcxpCdkK/kY8MDAymR3rGtyEsSUV2gjqAk
5pTH8wAekj5XLRzPbIeT9SC1w2YYC5oCalc6D8TgWuVb98gof5uwyrd2EIYG
d/L/qeOB/bW3zvBiB4zMXT0e6Q5Ajuwpum+cBymj868HtlORvm+DCC25D5EJ
BFG1xMOve3adoU53QeKJ1DH25x642NF+vqLBh4GipejJlm5IdlylCQ7QYFHt
9j5pDx8J+wNqm5Jp0NZRjLTS6IKeqrNz7jU+Sqh+vKprfYijbkwRPU1FLWvg
4Lc6PnI7L4i66A4ieuXNWfdfO1G2+chCxjwfAofrl6WeD+OBXKrvyVsduMJO
2uOvLwB7w5+dR5ePoa732YjWZQq+GfvFXPIQ9ps6+83wyDgWe1lZE0ZkyL6p
yUlKEyBxZY+noiUd5+QcF7ZR20Gx5g19aBYgwGDnmKTzBGoWPYssTdog3UYM
ycwKoNBWutrr/CQe2no3RLu2QD5E7ZE9aQbdXeWR1gFTkCDFvczc0YxLXQ98
IjCDotqNBhHB0/iW0rWFlPwWTt1bfJoHBSDFHohMXc8AOef9kMWtN5CeWp6Y
5S+AYDRKN4nKgJybsa0MpQHzpgo2FGHvT2gRhWNXmJg2+sX/LPc11uTXD2rG
81Gz9PvGfhILTJ6JjR29FodfFFS5KvFxQdLx+Ic6FkJ1ddi7c6tRnKHzm3kW
D75f3mUtnmSjqeF2RrpaJaIpDxQChLkKppoN/jHHBvv8mewIqzK4FfsN5aVx
ET2fULcugYPkZ4Gm58eL4estGnpFiovep2XjHjoEnrcdW0+rzwfXUio9IpxA
oajxq7o6Aopirc1PN2SCEjJyOMOcA1GKmWl1pbBPwbHpHw4/giepMSpwjoX+
oV/Xrysh8MCIbNDgk4tmmYCtDQVMGDiN+/CfEphxj/u+fuAJMnLn+b0ODER0
L9O2zSBQyqg0ifHJxyfG2vkY/hTusZrydsQR2DJHiaxYeA65BT1qZ+Qk8h7z
Y+quEnCXsPHSj3gBBf+KnZFf6fhZs7Fq1oPAoR9C7DPmi3CqJDA1rW4c209r
pnyyJzAvVdjScKEUd2t04+MsRiEnzRtOMSbgvyPn0TvGK/gEqOz47DSIWj1T
6hplAmk1+0b8FcuwR61pzPbxAGJzqsklMgTCWyQjrJ2bYHCDe/jvoX6w7t1l
eC5xoN3YPsytb8cb8y38QpF+HB/Sdtr5WXi3VrLoViuokLbarOKi2IfwB4nH
NjE4eNxy/bqDKw1MidVjOrK96Dp7k2Q2JOT9N4kGt9he5IqnhlLYNKhaHGBf
pHAwUVGQkxPXDy3HO2xGTjdIr3KXGho5OFLuizNXBkG0qX8cOUAFOajziUmZ
cL/98p5Kh2GYcTUk13WRofA96IeefA78szliH1VGMVNaaOaW2IqU9sT8tCwO
TqWuLZgcG4NqqP5p8dvtqMoZuK7nxYHOi6zdy4Scyzkb+EvZcjLmzn0oqjMU
+iTcj+suo6Pp/TJ7QpOCWCMXL7slNlYHuRVGdEwgfFHJfBudgv37iiR7KWyI
1RRLmkxOQjXbKZh7sAORafvFz2ayocRxPcCcm8Ji6eSndvcOtHaZcGfPsxH2
yF3SRoKBQmmyHUmzAzESt3ziDNgIlX/dTFdk4rvmOemXNylQkfWy3bwo5IRt
uf9WLRYOXIuInrxFRm3Y04ABMgumDi+1buqz8f/+q/8A5ejSSA==
                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {ShowStringCharacters -> False, NumberMarks -> 
                    False, PrintPrecision -> 3, ShowSyntaxStyles -> False}]}},
                     GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                     "]"}], "&"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
             RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
             RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
             RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
             RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
               RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
             RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], ",", 
             RowBox[{"Charting`TickLabels", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                   "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
             RowBox[{"Ticks", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
                 "}"}]}], ",", 
             RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
             RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )],
        TraditionalForm], TraditionalForm]}, "Legended", 
    DisplayFunction -> (GridBox[{{
        TagBox[
         ItemBox[
          PaneBox[
           TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
           BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
         "SkipImageSizeLevel"], 
        ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
      GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
      AutoDelete -> False, GridBoxItemSize -> Automatic, 
      BaselinePosition -> {1, 1}]& ), 
    InterpretationFunction -> (RowBox[{"Legended", "[", 
       RowBox[{#, ",", 
         RowBox[{"Placed", "[", 
           RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& ), Editable -> True], 
   InterpretationBox[
    Cell[
     BoxData[
      FormBox[
      "\"Fig. 1. The function \\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\
\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \\\"\[LongEqual]\\\", \
FractionBox[RowBox[{\\\"z\\\", \\\"+\\\", \\\"1\\\"}], RowBox[{\\\"z\\\", \
\\\" \\\", RowBox[{\\\"(\\\", RowBox[{\\\"z\\\", \\\"-\\\", \\\"2\\\"}], \
\\\")\\\"}]}]]}], HoldForm], TraditionalForm]\\).\"", TextForm]], 
     "InlineText"], 
    Text["Fig. 1. The function \!\(\*FormBox[TagBox[RowBox[{RowBox[{\"f\", \
\"(\", \"z\", \")\"}], \"\[LongEqual]\", FractionBox[RowBox[{\"z\", \"+\", \
\"1\"}], RowBox[{\"z\", \" \", RowBox[{\"(\", RowBox[{\"z\", \"-\", \"2\"}], \
\")\"}]}]]}], HoldForm], TraditionalForm]\)."]]},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.96294181627194*^9},
 CellID->68386876,ExpressionUUID->"a730fada-a186-ed41-8074-476241947275"]
}, Open  ]],

Cell[TextData[{
 "This function is not analytic at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", "2"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b4d90696-806d-4242-b804-ca83743495c3"],
 " where it has a singularity. A Taylor expansion around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6b73f503-f898-4d3f-910e-f5863860671d"],
 ", therefore, would not be possible."
}], "Text",
 CellID->135742012,ExpressionUUID->"d15dcad2-606e-4eca-a949-ca8aaa575eef"],

Cell[TextData[{
 "But there is still a way to capture the behavior of this function in the \
vicinity of the singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d53474c4-f0ea-402a-9381-95f629affaa4"],
 ", by allowing negative powers of the form ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    SuperscriptBox["z", "n"]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "71ff9e44-9ef2-45e1-a786-97c3c813168f"],
 " in the series:"
}], "Text",
 CellID->302215307,ExpressionUUID->"dca7b364-d4bc-472a-9d29-c2c7a742a3e9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellID->351415378,ExpressionUUID->"1f5b8bd7-9b93-4a18-8620-6f3aad0174b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{"2", " ", "z"}]]}], "-", 
   FractionBox["3", "4"], "-", 
   FractionBox[
    RowBox[{"3", " ", "z"}], "8"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["z", "2"]}], "16"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["z", "3"]}], "32"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["z", "4"]}], "64"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "5"],
    SeriesData[$CellContext`z, 0, {}, -1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    Rational[-1, 2], 
    Rational[-3, 4], 
    Rational[-3, 8], 
    Rational[-3, 16], 
    Rational[-3, 32], 
    Rational[-3, 64]}, -1, 5, 1],
  Editable->False]], "Output",
 CellID->211276620,ExpressionUUID->"3e22c8ab-ecdd-46f5-a875-e87c7bcbc27c"]
}, Open  ]],

Cell[TextData[{
 "We can find its coefficients with ",
 ButtonBox["SeriesCoefficient",
  BaseStyle->"Link"],
 ":"
}], "Text",
 CellID->6889236,ExpressionUUID->"307a877b-73a0-46a1-93ff-b11393a11183"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellID->768956826,ExpressionUUID->"f9f062bf-d136-48cf-b4ee-a205188e1e2a"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"n", "\[Equal]", 
         RowBox[{"-", "1"}]}]},
       {
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "-", "n"}]]}], 
        RowBox[{"n", "\[GreaterEqual]", "0"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "Output",
 CellID->316775577,ExpressionUUID->"c357d0d2-e018-4c58-aaf2-5f190130561d"]
}, Open  ]],

Cell[TextData[{
 "This series, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["g", "1"], "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", "z"}]]}], "-", 
     RowBox[{
      FractionBox["3", "2"], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       FractionBox[
        SuperscriptBox["z", "n"], 
        SuperscriptBox["2", "n"]]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d70167fd-5647-4b41-a457-d851896536d0"],
 ", will converge to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"160a1c54-dd0f-4b51-9842-711a14bc8433"],
 " in the annulus ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", "z", "|", 
    RowBox[{"<", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6c02abe4-fff0-4fdd-9541-659674a51146"],
 ", i.e. in between the singularities, and the truncated partial sums will be \
better and better approximations to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"73f011f9-a35e-49a4-8a7b-f7380cfebcb5"],
 "."
}], "Text",
 CellID->726716848,ExpressionUUID->"8fa38347-387d-462d-83b1-10e6eb0f2f86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"z", "+", "1"}], 
         RowBox[{"z", 
          RowBox[{"(", 
           RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "4"}], "}"}], ",", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"BoxRatios", "->", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", 
           FractionBox["1", "2"]}], "}"}]}], ",", 
        RowBox[{"PlotLegends", "->", "Automatic"}], ",", 
        RowBox[{"PlotStyle", "->", 
         RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", 
        RowBox[{"RegionFunction", "->", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "z", "}"}], ",", 
           RowBox[{
            RowBox[{"Abs", "[", "z", "]"}], "<=", "2"}]}], "]"}]}], ",", 
        RowBox[{"AxesLabel", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "z", "]"}], ",", 
           RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "->", 
         RowBox[{"Directive", "[", "12", "]"}]}], ",", 
        RowBox[{"ImageSize", "->", "250"}]}], "]"}], ",", 
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        RowBox[{"Normal", "[", 
         RowBox[{"Series", "[", 
          RowBox[{
           FractionBox[
            RowBox[{"z", "+", "1"}], 
            RowBox[{"z", 
             RowBox[{"(", 
              RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
           RowBox[{"{", 
            RowBox[{"z", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "4"}], "}"}], ",", 
        RowBox[{"PlotStyle", "->", 
         RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", 
        RowBox[{"RegionFunction", "->", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "z", "}"}], ",", 
           RowBox[{
            RowBox[{"Abs", "[", "z", "]"}], "<", "2"}]}], "]"}]}]}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{"n", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}]}],
        "}"}], ",", "1", ",", "15", ",", "1"}], "}"}], ",", 
    RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Fig. 2. The function \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"HoldForm", "[", 
          RowBox[{
           RowBox[{"f", "[", "z", "]"}], "==", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"z", "+", "1"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"z", 
              RowBox[{"(", 
               RowBox[{"z", "-", "2"}], ")"}]}], ")"}]}]}], "]"}], ",", 
         "TraditionalForm"}], "]"}], 
       "<>", "\"\< and successive approximations by Laurent series in \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"HoldForm", "[", 
          RowBox[{"0", "<", 
           RowBox[{"Abs", "[", "z", "]"}], "<", "2"}], "]"}], ",", 
         "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}], "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellID->2112469082,ExpressionUUID->"5a806ef7-f8e8-4eb3-95c9-e2da36e958cd"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`n$$], 1, 
           Style["\!\(\*FormBox[\"n\", TraditionalForm]\)", 12]}, 1, 15, 1, 
          ControlType -> Manipulator}}, Typeset`size$$ = {
        313.2890685190697, {106.60805123975183`, 113.84047311475183`}}, 
        Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, Typeset`keyframeActionsQ$$ = False, 
        Typeset`keyframeList$$ = {}}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
          "ControllerVariables" :> {}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$, 
            Typeset`keyframeActionsQ$$, Typeset`keyframeList$$}, "Body" :> 
          Show[
            
            ComplexPlot3D[($CellContext`z + 
              1)/($CellContext`z ($CellContext`z - 2)), {$CellContext`z, 4}, 
             PlotRange -> {{-4, 4}, {-4, 4}, {0, 4}}, 
             BoxRatios -> {1, 1, 1/2}, PlotLegends -> Automatic, PlotStyle -> 
             Opacity[0.5], RegionFunction -> 
             Function[{$CellContext`z}, Abs[$CellContext`z] <= 2], AxesLabel -> {
               Re[$CellContext`z], 
               Im[$CellContext`z]}, AxesStyle -> Directive[12], ImageSize -> 
             250], 
            ComplexPlot3D[
             Normal[
              
              Series[($CellContext`z + 1)/($CellContext`z ($CellContext`z - 
                2)), {$CellContext`z, 0, $CellContext`n$$}]], {$CellContext`z,
               4}, PlotStyle -> Opacity[0.5], RegionFunction -> 
             Function[{$CellContext`z}, Abs[$CellContext`z] < 2]]], 
          "Specifications" :> {{{$CellContext`n$$, 1, 
              Style["\!\(\*FormBox[\"n\", TraditionalForm]\)", 12]}, 1, 15, 
             1}}, "Options" :> {}, "DefaultOptions" :> {}],
         ImageSizeCache->{
          363.7890685190697, {154.60805123975183`, 161.84047311475183`}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {"\<\"Fig. 2. The function \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], \\\"\[LongEqual]\\\", FractionBox[RowBox[{\\\"z\\\", \\\"+\\\", \
\\\"1\\\"}], RowBox[{\\\"z\\\", \\\" \\\", RowBox[{\\\"(\\\", RowBox[{\\\"z\\\
\", \\\"-\\\", \\\"2\\\"}], \\\")\\\"}]}]]}], HoldForm], TraditionalForm]\\) \
and successive approximations by Laurent series in \
\\!\\(\\*FormBox[TagBox[RowBox[{\\\"0\\\", \\\"<\\\", \
TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \\\"<\\\", \\\"2\\\"}], HoldForm], \
TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1469261584,ExpressionUUID->"6ebcf323-3ee8-4fb9-becb-307555d37033"]
}, {2}]],

Cell[TextData[{
 "In Fig. 2, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6d2b4292-e82e-4682-83d2-b094125403c0"],
 " is plotted in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", "z", "|", 
    RowBox[{"<", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "82443370-c713-44bf-a79b-5970c15d1725"],
 ", which is the region in which the series converges. By moving the slider, \
you can truncate the series at higher and higher values of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath",ExpressionUUID->
  "7f825544-fd19-49d7-9b23-a0fc1d4b8dc7"],
 ", obtaining a better approximation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"14c6085f-5afa-407b-b4ab-af167c7186ac"],
 " in the region between the singularities."
}], "Text",
 CellID->189250440,ExpressionUUID->"d2fd857e-1634-408e-b45c-7a29085bbde0"],

Cell[TextData[{
 "A different series would need to be built in order to approximate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e9d6310a-c312-4725-a539-61248d5813c7"],
 " with a Laurent series centered at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b70b0af6-be0d-46a6-9002-506ee1eaf2a4"],
 ", but in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "29c08538-c85f-4232-8c5a-a99424c5915e"],
 ", namely ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["g", "2"], "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox["1", "z"], "+", 
     RowBox[{"3", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       FractionBox[
        SuperscriptBox["2", "n"], 
        SuperscriptBox["z", 
         RowBox[{"n", "+", "2"}]]]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7b749174-394e-474d-870a-3803d537e6ef"],
 ". This is visualized in Fig. 3."
}], "Text",
 CellID->7193441,ExpressionUUID->"ba3746e2-e2a4-4008-b424-8d607421ab1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"Show", "[", 
     RowBox[{
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"z", "+", "1"}], 
         RowBox[{"z", 
          RowBox[{"(", 
           RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "4"}], "}"}], ",", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"BoxRatios", "->", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", 
           FractionBox["1", "2"]}], "}"}]}], ",", 
        RowBox[{"PlotLegends", "->", "Automatic"}], ",", 
        RowBox[{"PlotStyle", "->", 
         RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", 
        RowBox[{"RegionFunction", "->", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "z", "}"}], ",", 
           RowBox[{
            RowBox[{"Abs", "[", "z", "]"}], ">", "2"}]}], "]"}]}], ",", 
        RowBox[{"AxesLabel", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "z", "]"}], ",", 
           RowBox[{"Im", "[", "z", "]"}]}], "}"}]}], ",", 
        RowBox[{"AxesStyle", "->", 
         RowBox[{"Directive", "[", "12", "]"}]}], ",", 
        RowBox[{"ImageSize", "->", "250"}]}], "]"}], ",", 
      RowBox[{"ComplexPlot3D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "z"}], "+", 
         RowBox[{"3", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "^", "k"}], "/", 
             RowBox[{"(", 
              RowBox[{"z", "^", 
               RowBox[{"(", 
                RowBox[{"k", "+", "2"}], ")"}]}], ")"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "4"}], "}"}], ",", 
        RowBox[{"PlotStyle", "->", 
         RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", 
        RowBox[{"RegionFunction", "->", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", "z", "}"}], ",", 
           RowBox[{
            RowBox[{"Abs", "[", "z", "]"}], ">", "2"}]}], "]"}]}]}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"ToString", "[", 
           RowBox[{"n", ",", "TraditionalForm"}], "]"}], ",", "12"}], "]"}]}],
        "}"}], ",", "1", ",", "15", ",", "1"}], "}"}], ",", 
    RowBox[{"SaveDefinitions", "->", "True"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Fig. 3. The function \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"HoldForm", "[", 
          RowBox[{
           RowBox[{"f", "[", "z", "]"}], "==", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"z", "+", "1"}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"z", 
              RowBox[{"(", 
               RowBox[{"z", "-", "2"}], ")"}]}], ")"}]}]}], "]"}], ",", 
         "TraditionalForm"}], "]"}], 
       "<>", "\"\< and successive approximations by Laurent series in \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"HoldForm", "[", 
          RowBox[{
           RowBox[{"Abs", "[", "z", "]"}], ">", "2"}], "]"}], ",", 
         "TraditionalForm"}], "]"}], "<>", "\"\<.\>\""}], "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellID->709961825,ExpressionUUID->"a30e78c8-9b8e-4855-aa0c-bdd2f0c64f7f"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`n$$], 1, 
           Style["\!\(\*FormBox[\"n\", TraditionalForm]\)", 12]}, 1, 15, 1, 
          ControlType -> Manipulator}}, Typeset`size$$ = {
        313.2890685190697, {119.58573658490508`, 126.81815845990505`}}, 
        Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, Typeset`keyframeActionsQ$$ = False, 
        Typeset`keyframeList$$ = {}}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
          "ControllerVariables" :> {}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$, 
            Typeset`keyframeActionsQ$$, Typeset`keyframeList$$}, "Body" :> 
          Show[
            
            ComplexPlot3D[($CellContext`z + 
              1)/($CellContext`z ($CellContext`z - 2)), {$CellContext`z, 4}, 
             PlotRange -> {{-4, 4}, {-4, 4}, {0, 4}}, 
             BoxRatios -> {1, 1, 1/2}, PlotLegends -> Automatic, PlotStyle -> 
             Opacity[0.5], RegionFunction -> 
             Function[{$CellContext`z}, Abs[$CellContext`z] > 2], AxesLabel -> {
               Re[$CellContext`z], 
               Im[$CellContext`z]}, AxesStyle -> Directive[12], ImageSize -> 
             250], 
            ComplexPlot3D[
            1/$CellContext`z + 
             3 Sum[2^$CellContext`k/$CellContext`z^($CellContext`k + 
                 2), {$CellContext`k, 0, $CellContext`n$$}], {$CellContext`z, 
              4}, PlotStyle -> Opacity[0.5], RegionFunction -> 
             Function[{$CellContext`z}, Abs[$CellContext`z] > 2]]], 
          "Specifications" :> {{{$CellContext`n$$, 1, 
              Style["\!\(\*FormBox[\"n\", TraditionalForm]\)", 12]}, 1, 15, 
             1}}, "Options" :> {}, "DefaultOptions" :> {}],
         ImageSizeCache->{
          363.7890685190697, {167.58573658490508`, 174.81815845990508`}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {"\<\"Fig. 3. The function \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"f\\\", \\\"(\\\", \\\"z\\\", \
\\\")\\\"}], \\\"\[LongEqual]\\\", FractionBox[RowBox[{\\\"z\\\", \\\"+\\\", \
\\\"1\\\"}], RowBox[{\\\"z\\\", \\\" \\\", RowBox[{\\\"(\\\", RowBox[{\\\"z\\\
\", \\\"-\\\", \\\"2\\\"}], \\\")\\\"}]}]]}], HoldForm], TraditionalForm]\\) \
and successive approximations by Laurent series in \
\\!\\(\\*FormBox[TagBox[RowBox[{TemplateBox[List[\\\"z\\\"], \\\"Abs\\\"], \\\
\">\\\", \\\"2\\\"}], HoldForm], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->909250043,ExpressionUUID->"091a7e34-8892-49d7-b994-51ba0414c236"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of Laurent Series", "Subsection",
 CellID->358614869,ExpressionUUID->"c0d790f8-e860-4b15-9794-a063ac58509e"],

Cell[TextData[{
 "In ",
 ButtonBox["Chapter 19",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", you saw the power series"
}], "Text",
 CellID->87104407,ExpressionUUID->"b3239a49-4586-40fc-984e-9b924b9ebcc8"],

Cell[BoxData[
 FormBox[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n", "=", "0"}], "\[Infinity]"], 
   SuperscriptBox[
    RowBox[{
     SubscriptBox["a", "n"], "(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}], "n"]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->606748749,ExpressionUUID->"10c7fe7f-e0ae-4d54-b583-662617214eb1"],

Cell[TextData[{
 "and learned how it converges inside the disk ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9ab63c4f-7e65-4c1e-b74c-9997906f5125"],
 ", where ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "fd74d64a-3e79-4d72-b9f1-e1f53b2fbc89"],
 " is called the radius of convergence."
}], "Text",
 CellID->487470388,ExpressionUUID->"21db90ec-df37-4924-b6d0-ee248db02239"],

Cell["Then, the series", "Text",
 CellID->475437289,ExpressionUUID->"eb290171-5ebb-409f-875e-9e7759d1f938"],

Cell[BoxData[
 FormBox[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"n", "=", "0"}], "\[Infinity]"], 
   FractionBox[
    SubscriptBox["b", "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}], "n"]]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->138844020,ExpressionUUID->"d654e8f0-a8fa-4f1f-b2fc-ab7f0d9440c2"],

Cell[TextData[{
 "can be seen as a power series in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"95e15401-9ff7-4586-bde7-c3f97db2dba3"],
 ", therefore it will converge outside of a disk ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", " ", 
    RowBox[{">", "r"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bb29873d-eed9-4d33-8411-a6243c62742e"],
 "."
}], "Text",
 CellID->527211048,ExpressionUUID->"e44aa3c1-d7a7-4367-9862-9c5171057ef3"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "<", "R"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d0473cdd-fc3d-4c9d-9ec2-c51c9264e452"],
 ", the two series will both converge and the function"
}], "Text",
 CellID->307648107,ExpressionUUID->"0aabd2db-5a7e-43ca-8a2d-b638df8f6d3d"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]"], 
     FractionBox[
      SubscriptBox["b", "n"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}], ")"}], "n"]]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"n", "=", "0"}], "\[Infinity]"], 
     SuperscriptBox[
      RowBox[{
       SubscriptBox["a", "n"], "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "n"]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->359228655,ExpressionUUID->"5a156ffb-cdab-41c4-b36b-f80d959d2642"],

Cell[TextData[{
 "will be analytic in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ce6eff09-1545-4adb-a05a-a7707fe1cc59"],
 "."
}], "Text",
 CellID->8107276,ExpressionUUID->"4972247e-be1f-4186-8e8b-be807107808c"],

Cell[TextData[{
 "Conversely, given a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b2b6c63a-9482-48bd-8a7c-f0dbf4acec31"],
 " analytic in an annulus ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "99053fa0-5e88-4795-8e4b-f2332f9a58d4"],
 ", it can be expanded in a series of the previous form. This is the object \
of Laurent\[CloseCurlyQuote]s theorem."
}], "Text",
 CellID->509658578,ExpressionUUID->"34aa8421-2cf6-482d-9796-f7c5e7d1863a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Laurent\[CloseCurlyQuote]s Theorem", "Subsection",
 CellID->143748847,ExpressionUUID->"7f663731-415e-4d21-88de-7be6d2867aba"],

Cell[TextData[{
 StyleBox["Laurent\[CloseCurlyQuote]s theorem",
  FontSlant->"Italic"],
 ":",
 " Given a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"68de0c03-815b-8643-a159-df69f8881f47"],
 " analytic in the annulus ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "<"}], " ", "|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "03dbeb65-bb53-9746-a9c1-f3435d8fca96"],
 ", then:"
}], "Text",
 CellID->193227388,ExpressionUUID->"11c1effd-50d1-a444-9d73-ce992a3b0d49"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"639c4780-2c79-4157-81d8-3c1286013c76"],
 " can be developed as the ",
 StyleBox["Laurent series",
  FontSlant->"Italic"]
}], "Text",
 CellID->229254798,ExpressionUUID->"69596119-bed4-44f1-83f1-65da6f964e8e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]"], 
      FractionBox[
       SubscriptBox["b", "n"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", 
          SubscriptBox["z", "0"]}], ")"}], "n"]]}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"n", "=", "0"}], "\[Infinity]"], 
      SuperscriptBox[
       RowBox[{
        SubscriptBox["a", "n"], "(", 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}], ")"}], "n"]}]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["f", "1"], 
      RowBox[{"(", "z", ")"}]}], "+", 
     RowBox[{
      SubscriptBox["f", "2"], 
      RowBox[{"(", "z", ")"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 TextAlignment->-0.5,
 CellID->853239591,ExpressionUUID->"78ccf9b5-c580-4cb9-8f33-7827f9877df4"],

Cell["where", "Text",
 CellID->146790184,ExpressionUUID->"ecc370d3-d9f9-4e2b-a06c-0f5d065ea119"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["a", "n"], "\[AlignmentMarker]", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"\[Zeta]", "-", 
           SubscriptBox["z", "0"]}], ")"}], 
         RowBox[{"n", "+", "1"}]]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["b", "n"], "\[AlignmentMarker]", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       RowBox[{"f", "(", "\[Zeta]", ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Zeta]", "-", 
          SubscriptBox["z", "0"]}], ")"}], 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 TextAlignment->-0.5,
 CellID->314956168,ExpressionUUID->"cf9a8106-60a2-4b2e-9744-0655a0831340"],

Cell[TextData[{
 "and ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "2a56e63d-2f70-43ac-9c3b-15558f3645f6"],
 " is a circle inside the annulus."
}], "Text",
 CellID->32321037,ExpressionUUID->"03daaff8-96ba-44b5-9585-14c7135247f6"],

Cell[TextData[{
 "2. The series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "1"], "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f6ecc9ca-78b0-48b8-bdfa-dd46d2a0ede8"],
 " converges in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", " ", 
    RowBox[{">", "r"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "dd3c169d-df80-481f-90f7-8df2ec54805e"],
 ", and the series ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "2"], "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6bb6809a-5fe5-40bb-b51a-97efb65d2453"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], "|", 
    RowBox[{"<", "R"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "36ed73d2-b4ae-421d-80a5-1513d7cf4602"],
 "."
}], "Text",
 CellID->437311631,ExpressionUUID->"fd4a39f1-c9d8-465d-99f3-d373979c50d5"],

Cell[TextData[{
 "Proof:",
 StyleBox[" ",
  FontWeight->"Bold"],
 "The second point follows from the discussion in the previous section."
}], "Text",
 CellID->839393474,ExpressionUUID->"08df6f9b-b4eb-491f-8667-ef434c20e08b"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[0.015], 
      PointBox[{0, 0}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"z\\\"\
, \\\"0\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], {0, 0}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 1}], 
       ImageScaled[{0.5, 1}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      PointSize[0.015], 
      PointBox[{-1.9, 1.4}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"z\\\", \
TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 12], {-1.9, 
      1.4}, 
      NCache[
       ImageScaled[{
         Rational[1, 2], 1}], 
       ImageScaled[{0.5, 1}]]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Thickness[0.007], 
      CircleBox[{0, 0}, 1, {0.1, 6.183185307179587}]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      ArrowBox[{{0, 1}, {0.1, 1}}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\"\
, \\\"3\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], {0, 1}, 
      ImageScaled[{1, -0.25}]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Thickness[0.007], 
      CircleBox[{0, 0}, 3, {0.03, 6.253185307179586}]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Thickness[0.007], 
      LineBox[{{1, 0.1}, {3, 0.1}}]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      ArrowBox[{{1.8, 0.1}, {1.9, 0.1}}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\"\
, \\\"4\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], {1.8, 0.1}, 
      ImageScaled[{0.75, -0.25}]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      Thickness[0.007], 
      LineBox[{{1, -0.1}, {3, -0.1}}]}, {
      RGBColor[0.368417, 0.506779, 0.709798], 
      ArrowBox[{{2.3, -0.1}, {2.2, -0.1}}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\"\
, \\\"2\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], {1.8, -0.1}, 
      ImageScaled[{0.75, 1.25}]], {
      RGBColor[0.368417, 0.506779, 0.709798], 
      ArrowBox[
       NCache[{{3 2^Rational[-1, 2], 3 2^Rational[-1, 2]}, {
         1.9091883092036783`, 2.3334523779156067`}}, {{2.1213203435596424`, 
        2.1213203435596424`}, {1.9091883092036783`, 2.3334523779156067`}}]]}, 
     
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"C\\\"\
, \\\"1\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], 
      NCache[{3 2^Rational[-1, 2], 3 2^Rational[-1, 2]}, {2.1213203435596424`,
        2.1213203435596424`}], 
      ImageScaled[{0, 0}]], {
      Thickness[0.0015], 
      LineBox[{{0, 0}, {2.6327476856711183`, 1.438276615812609}}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"r\\\"\
, \\\"2\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], {2.2817146609149694`, 1.2465064003709279`}, 
      ImageScaled[{1, 0}]], {
      Thickness[0.0015], 
      LineBox[{{0, 0}, {0.4535961214255773, 0.8912073600614354}}]}, 
     InsetBox[
      StyleBox[
      "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"r\\\"\
, \\\"1\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, FontSize -> 
       12], {0.22679806071278866`, 0.4456036800307177}, 
      ImageScaled[{1, 0}]]}, AspectRatio -> 0.9978407918370467, 
    ImageSize -> {204.4296875, 203.98828125}, 
    PlotRange -> {{-3.4471354166666663`, 3.367187500000001}, {-3.359375, 
     3.4402343749999993`}}, PlotRangePadding -> None], "\"Fig. 4.\""},
  "Labeled",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}, {
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, 
    GridBoxItemSize -> {"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
    BaselinePosition -> {1, 1}]& ),
  InterpretationFunction->(RowBox[{"Labeled", "[", 
     RowBox[{#, ",", #2, ",", 
       RowBox[{"{", "}"}]}], "]"}]& )]], "Output",
 CellID->38726709,ExpressionUUID->"bb04f898-ddae-4dae-b061-a1e564c0502d"],

Cell[TextData[{
 "To prove the first point, consider the integral path in the figure, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "<", 
    SubscriptBox["r", "1"], "<", 
    SubscriptBox["r", "2"], "<", "R"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0d807b2f-c8bd-46db-9653-bde8605f7338"],
 ": since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7eed9c41-e88a-4cf7-8b91-4bb4c400e893"],
 " is analytic inside the region bounded by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "1"], ",", " ", 
    SubscriptBox["C", "2"], ",", " ", 
    SubscriptBox["C", "3"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9813ac5c-aa43-45d4-bf75-b1a022c1cf38"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "4"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f2cec4e0-afa8-4e90-9473-c9e52c356815"],
 ", then by Cauchy\[CloseCurlyQuote]s formula"
}], "Text",
 CellID->17733229,ExpressionUUID->"e585b948-70ec-4e7a-afdf-ad364d08824c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{
        SubscriptBox["C", "1"], "\[Union]", 
        SubscriptBox["C", "3"]}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", "z"}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
       RowBox[{
        SubscriptBox["\[Integral]", 
         SubscriptBox["C", "1"]], 
        RowBox[{
         FractionBox[
          RowBox[{"f", "(", "\[Zeta]", ")"}], 
          RowBox[{"\[Zeta]", "-", "z"}]], 
         RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}], "+", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
       RowBox[{
        SubscriptBox["\[Integral]", 
         SubscriptBox["C", "3"]], 
        RowBox[{
         FractionBox[
          RowBox[{"f", "(", "\[Zeta]", ")"}], 
          RowBox[{"\[Zeta]", "-", "z"}]], 
         RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["f", "1"], 
       RowBox[{"(", "z", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["f", "2"], "(", "z", ")"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->47307797,ExpressionUUID->"23b90b00-fb19-40f4-9260-65cd278c90b8"],

Cell[TextData[{
 "because the integrals over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "90538e63-56c3-491b-8f54-686f7deaa89c"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "4"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fcefcbd5-2089-46cb-9545-39bff2327534"],
 " cancel, and we so define ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3a5e89ce-b688-45e3-9b1f-ea0947a2c9b1"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a086b698-c43b-4b68-b4a0-ff3c75076c41"],
 ". It remains to prove that they have the expansions claimed in the \
theorem."
}], "Text",
 CellID->441854,ExpressionUUID->"7b6d5412-31d9-4bdc-a277-b4d4fe6a0b28"],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9e78e692-4d81-406a-88ed-a37dbff65d59"],
 ", we have"
}], "Text",
 CellID->721465742,ExpressionUUID->"275cc035-0a07-4d91-982a-a54620ee415b"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["f", "1"], 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       SubscriptBox["C", "1"]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", "z"}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       SubscriptBox["C", "1"]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", 
         SubscriptBox["z", "0"]}]], 
       FractionBox["1", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"z", "-", 
           SubscriptBox["z", "0"]}], 
          RowBox[{"\[Zeta]", "-", 
           SubscriptBox["z", "0"]}]]}]], 
       RowBox[{
        RowBox[{"\[DifferentialD]", "\[Zeta]"}], "."}]}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->510462927,ExpressionUUID->"4080bd97-3396-4499-86b3-1e1ebbe8e587"],

Cell[TextData[{
 "Since on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "5955b67a-d17f-4cd8-8e58-5c22ba5b1b59"],
 " we have ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    FractionBox[
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}], 
     RowBox[{"\[Zeta]", "-", 
      SubscriptBox["z", "0"]}]], "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fc9f415d-ec92-4828-b79b-cb1bb101465c"],
 ", then one can use the series expansion of the geometric series to write"
}], "Text",
 CellID->249260538,ExpressionUUID->"7854b733-88b4-43f8-b68e-68a1b0cc4cf7"],

Cell[TextData[{
 Cell[BoxData[{
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", "z", ")"}], "\[AlignmentMarker]", "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       SubscriptBox["C", "1"]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", 
         SubscriptBox["z", "0"]}]], 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
          RowBox[{"n", "=", "0"}]}], 
         RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"z", "-", 
            SubscriptBox["z", "0"]}], 
           RowBox[{"\[Zeta]", "-", 
            SubscriptBox["z", "0"]}]], ")"}], "n"]}]}]}]}]}], 
   TraditionalForm], "\[IndentingNewLine]", 
  FormBox[
   RowBox[{"\t\[AlignmentMarker]", 
    RowBox[{"=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        SubscriptBox["\[Integral]", 
         SubscriptBox["C", "1"]], 
        RowBox[{
         FractionBox[
          RowBox[{"f", "(", "\[Zeta]", ")"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Zeta]", "-", 
             SubscriptBox["z", "0"]}], ")"}], 
           RowBox[{"n", "+", "1"}]]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"z", "-", 
            SubscriptBox["z", "0"]}], ")"}], "n"]}]}]}]}]}]}], 
   TraditionalForm]}],ExpressionUUID->
  "3a8cef54-9d49-4278-90a9-9e438c936bf3"],
 ","
}], "Text",
 CellID->224171107,ExpressionUUID->"998fe661-a5a9-4cd7-88d0-2c9972ca8f39"],

Cell[TextData[{
 "which proves the formula for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2dec8c35-0c0d-4d4c-a2ab-60c9a44a2b57"],
 ". A similar reasoning is applied to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e70020b1-3903-4a5d-a03b-1c183c03d3ad"],
 ", remembering that on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "3"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "42273411-a496-4c2e-8f6a-2fa6338b8316"],
 " one has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Zeta]", "-", 
       SubscriptBox["z", "0"]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], ")"}]}], "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "91f26ba2-fc93-4b29-a1e2-2d3a6039003f"],
 ":"
}], "Text",
 CellID->236992810,ExpressionUUID->"4c6c0e3f-5255-4495-b527-ee4b82d89cf7"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["f", "2"], 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[Integral]", 
      SubscriptBox["C", "3"]], 
     RowBox[{
      FractionBox[
       RowBox[{"f", "(", "\[Zeta]", ")"}], 
       RowBox[{"\[Zeta]", "-", "z"}]], 
      RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{"=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]]}], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{"-", 
        SubscriptBox["C", "3"]}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", "z"}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{"=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]]}], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{"-", 
        SubscriptBox["C", "3"]}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"\[Zeta]", "-", "z"}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{"=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{"-", 
        SubscriptBox["C", "3"]}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}]], 
       FractionBox["1", 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"\[Zeta]", "-", 
           SubscriptBox["z", "0"]}], 
          RowBox[{"z", "-", 
           SubscriptBox["z", "0"]}]]}]], 
       RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{"=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{"-", 
        SubscriptBox["C", "3"]}]], 
      RowBox[{
       FractionBox[
        RowBox[{"f", "(", "\[Zeta]", ")"}], 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}]], 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"n", "=", "0"}], "\[Infinity]"], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"\[Zeta]", "-", 
             SubscriptBox["z", "0"]}], 
            RowBox[{"z", "-", 
             SubscriptBox["z", "0"]}]], ")"}], "n"], 
         RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t", 
   RowBox[{
    RowBox[{"=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"n", "=", "0"}], "\[Infinity]"], 
       FractionBox[
        RowBox[{
         SubscriptBox["\[Integral]", 
          RowBox[{"-", 
           SubscriptBox["C", "3"]}]], 
         RowBox[{
          RowBox[{"f", "(", "\[Zeta]", ")"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"\[Zeta]", "-", 
             SubscriptBox["z", "0"]}], ")"}], "n"], 
          RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", 
           SubscriptBox["z", "0"]}], ")"}], 
         RowBox[{"n", "+", "1"}]]]}]}]}], ","}]}], 
  TraditionalForm]}], "DisplayFormulaNumbered",
 CellID->436346381,ExpressionUUID->"1c298498-245d-4366-ba37-39010eba18ef"],

Cell[TextData[{
 "which proves the formula for the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c1cf3281-605d-439b-880a-467882715b13"],
 "."
}], "Text",
 CellID->30931438,ExpressionUUID->"25decfc5-fb9f-40ff-9aeb-c16d9bb05aad"],

Cell[TextData[{
 "Notice that, unlike in Taylor\[CloseCurlyQuote]s theorem, one cannot write \
the coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "12266c37-a297-43d6-8204-9829ba431ff8"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fbe16557-1edb-4818-ae7b-bd4e13a0accf"],
 " as derivatives, because the derivatives don\[CloseCurlyQuote]t necessarily \
exist at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e61d5863-c4a6-47c3-ac6f-87ee79b79480"],
 "."
}], "Text",
 CellID->152488228,ExpressionUUID->"7f6ec3fe-d451-45c4-a06d-8e75bcab9b30"],

Cell[CellGroupData[{

Cell["Discussion", "Subsubsection",
 CellID->345489541,ExpressionUUID->"30cf209b-7221-4585-962f-b06f48cc5df0"],

Cell[TextData[{
 "Laurent\[CloseCurlyQuote]s theorem allows you to obtain a series expansion \
of a function that is not analytic at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1c58b2cd-0c74-4ef4-9bd8-3ac49e783e73"],
 ", provided that it is analytic in some ring around ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4ca437b2-6b4d-447c-b660-4ce4ec3b7dd8"],
 ", by allowing negative powers of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"z", "-", 
     SubscriptBox["z", "0"]}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a99369e2-ce57-4d7a-a923-b570cbb0cde8"],
 " in the series. This greatly expands the number of functions that you can \
expand in a series."
}], "Text",
 CellID->294799543,ExpressionUUID->"41f58089-57cc-4440-bedf-b02c6500841b"],

Cell[TextData[{
 "In Wolfram Language, the commands ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["SeriesCoefficient",
  BaseStyle->"Link"],
 " can be used to build a Laurent series expansion and to find its \
coefficients."
}], "Text",
 CellID->110566896,ExpressionUUID->"2a611286-aabd-4e4f-81a4-320e384aba57"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Subsection",
 CellID->546980493,ExpressionUUID->"55cf1365-e4c1-4876-9089-b3f746d8b69f"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->9992938,ExpressionUUID->"72a200e3-5bbf-4de0-9f4e-652a7ff8c841"],

Cell[TextData[{
 "Find the Laurent series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "+", "1"}], 
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "1"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8316377b-4abf-4f48-8ca1-0f0a98541527"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["z", "0"], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"591abf46-142e-448b-aaf3-aed8f30f7b37"],
 " in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b6fd0bbb-95d1-44c4-bc5a-346fecfa140c"],
 "."
}], "SolvedExampleNote",
 CellID->91653603,ExpressionUUID->"6bcf04b0-8add-4323-a494-9e1ef9c194d7"],

Cell[TextData[{
 "You can compute the first few terms using ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->274904569,ExpressionUUID->"524c3e33-b32c-4e1f-97fc-cbc5ed81351b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->609354532,ExpressionUUID->"7c772c18-1c46-46da-ab93-27cbb0f107a1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "z"]}], "-", "2", "-", 
   RowBox[{"2", " ", "z"}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "2"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "3"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "4"]}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["z", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {-1, -2, -2, -2, -2, -2, -2}, -1, 6, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->221386080,ExpressionUUID->"9fbbd041-4ad3-4cb2-a5a9-a33716b87df8"]
}, Open  ]],

Cell["The general term of the series expansion is:", "SolvedExampleNote",
 CellID->299814989,ExpressionUUID->"e4b9cb62-085f-4902-8e48-5d396ef7d932"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "+", "1"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "n"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->109506769,ExpressionUUID->"92fd85bd-9570-4dae-a5da-8e52eee75adf"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        RowBox[{"-", "2"}], 
        RowBox[{"n", "\[GreaterEqual]", "0"}]},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"n", "\[Equal]", 
         RowBox[{"-", "1"}]}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "SolvedExampleOutput",
 CellID->766915141,ExpressionUUID->"4457d7af-58b0-41f6-accf-64d7da934771"]
}, Open  ]],

Cell[TextData[{
 "So the Laurent series is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "z"]}], "-", 
    RowBox[{"2", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
      SuperscriptBox["z", "n"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9e737bb5-5af9-4c3c-b66e-e44aa6937457"],
 ". Notice how in this example, the only negative power of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "5b66f720-1bb1-4718-817e-7b0234f8d992"],
 " present is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "346f00ba-dd25-4ea4-ae6f-809a0b42b6a5"],
 ". So the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "437478eb-5b8d-4d24-9c0b-4623997c1161"],
 " is called a ",
 StyleBox["simple pole",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f5be381b-f7b4-4da3-9fdd-59279c93bd26"],
 "."
}], "SolvedExampleNote",
 CellID->267605618,ExpressionUUID->"602f52f8-fc6c-4e17-b043-8a0ea7ac2941"],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"9224409b-1a8e-4afa-aed5-139fdb7111fc"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->364784924,ExpressionUUID->"784d1951-d132-42b4-b71a-00e630aa61e9"],

Cell[TextData[{
 "Find the Laurent series expansion of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     SuperscriptBox["\[ExponentialE]", "z"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"13b57791-ee56-4553-8d7e-7e73630a2fa9"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "450cd369-ff45-4614-884f-b844d2956e06"],
 "."
}], "SolvedExampleNote",
 CellID->69398209,ExpressionUUID->"faf7e038-105f-4593-88fb-8c08c5681ee5"],

Cell[TextData[{
 "To find the answer, write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "-", "1"}], "=", "u"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"176e282b-f148-416a-b310-3920f76358b3"],
 ". Then:"
}], "SolvedExampleNote",
 CellID->366230533,ExpressionUUID->"33995056-6902-4b27-9541-c8cc88e4e2d0"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "z"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"\[ExponentialE]", "\[CenterDot]", 
      SuperscriptBox["\[ExponentialE]", "u"]}], 
     SuperscriptBox["u", "2"]], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[ExponentialE]", "\[CenterDot]", 
       FractionBox["1", 
        SuperscriptBox["u", "2"]]}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "+", "u", "+", 
         FractionBox[
          SuperscriptBox["u", "2"], 
          RowBox[{"2", "!"}]], "+"}], "..."}], ")"}]}], "=", 
     RowBox[{
      RowBox[{
       FractionBox["\[ExponentialE]", 
        SuperscriptBox["u", "2"]], "+", 
       FractionBox["\[ExponentialE]", "u"], "+", 
       RowBox[{"\[ExponentialE]", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
           RowBox[{"n", "=", "0"}]}], 
          RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
         FractionBox[
          SuperscriptBox["u", "n"], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"n", "+", "2"}], ")"}], "!"}]]}]}]}], "=", 
      RowBox[{
       FractionBox["\[ExponentialE]", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "1"}], ")"}], "2"]], "+", 
       FractionBox["\[ExponentialE]", 
        RowBox[{"z", "-", "1"}]], "+", 
       RowBox[{"\[ExponentialE]", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
           RowBox[{"n", "=", "0"}]}], 
          RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
         RowBox[{
          FractionBox[
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "1"}], ")"}], "n"], 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "!"}]], "."}]}]}]}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"c3e666d1-5f2a-4415-a14f-257d275ea325"]], \
"SolvedExampleNote",
 CellID->604614456,ExpressionUUID->"dfc345fe-76e3-44a8-94e9-b0937dd7c770"],

Cell[TextData[{
 "Check with ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->34624335,ExpressionUUID->"cc33bd03-a65b-4b44-bc93-7886102a9055"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "5"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->362163057,ExpressionUUID->"716a5818-0a2f-4128-a16f-fe0be747104c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[ExponentialE]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]], "+", 
   FractionBox["\[ExponentialE]", 
    RowBox[{"z", "-", "1"}]], "+", 
   FractionBox["\[ExponentialE]", "2"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", "\[ExponentialE]", " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "4"]}], "+", 
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "5"]}], "5040"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "6"],
    SeriesData[$CellContext`z, 1, {}, -2, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {
   E, E, Rational[1, 2] E, Rational[1, 6] E, Rational[1, 24] E, 
    Rational[1, 120] E, Rational[1, 720] E, Rational[1, 5040] E}, -2, 6, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->387902704,ExpressionUUID->"4f0cc5bb-9bef-421e-b8ae-f7069806d631"]
}, Open  ]],

Cell[TextData[{
 "and ",
 ButtonBox["SeriesCoefficient",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->933842692,ExpressionUUID->"f0945f9c-e44d-417d-9ba1-551b78825a8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "n"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->416003697,ExpressionUUID->"f44cccdf-3c69-4935-bdf8-fd50766a5769"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        FractionBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "n"}], ")"}], "!"}]], 
        RowBox[{"n", "\[GreaterEqual]", 
         RowBox[{"-", "2"}]}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "SolvedExampleOutput",
 CellID->389521419,ExpressionUUID->"e7920add-8d7c-469d-8f54-608c0ee78951"]
}, Open  ]],

Cell[TextData[{
 "Notice that the highest negative power of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"z", "-", "1"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c4707586-dc04-49f1-aeaa-0266da6b4060"],
 " in the series is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bcabc89a-aa76-48ac-a13a-9974e6cf90c3"],
 ". So, the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0941157b-1d48-4a86-b11e-efef08c7f156"],
 " is called a ",
 StyleBox["double pole",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6fb25c97-6b85-42cd-850b-5e5138db2373"],
 "."
}], "SolvedExampleNote",
 CellID->383108805,ExpressionUUID->"2f14a990-d105-4b9f-9680-bbc8ecc3f192"],

Cell["", "SolvedExampleEndCap",
 CellID->1417454744,ExpressionUUID->"bec9998a-311f-43cb-8603-3d9cb7f4ec8a"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->40033488,ExpressionUUID->"4ba96a41-f3fa-4921-b75d-2542c85d8a38"],

Cell[TextData[{
 "Find the Laurent series of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     SuperscriptBox["z", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d8e56eeb-8834-4d7c-9aca-79b87ac60162"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3e6cd125-9f5a-4d5b-9b47-11262acd97e7"],
 " in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "-", "1"}], "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "bf566f7a-39e1-4300-a8e7-5dff98b8c775"],
 "."
}], "SolvedExampleNote",
 CellID->51632585,ExpressionUUID->"27a9f7a4-be8d-4e52-9976-0e979cc2f28c"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "-", "2"}], "=", "u"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f27405e3-8c41-4035-9252-9db8303a76b5"],
 ", so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "u", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9595dbac-61e6-402e-9672-64e62d06d5a6"],
 " in the region we are considering. With this in mind, we can use the \
formula for the geometric series:"
}], "SolvedExampleNote",
 CellID->81190014,ExpressionUUID->"ca64e538-ec76-40c9-b3ce-f5529e7535d2"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"u", "+", "2"}], ")"}], "2"], 
     RowBox[{"u", "(", 
      RowBox[{"u", "+", "1"}], ")"}]], "=", 
    RowBox[{
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"u", "+", "2"}], ")"}], "2"], "u"], 
      RowBox[{"(", 
       RowBox[{"1", "-", "u", "+", 
        SuperscriptBox["u", "2"], "-", "\[Ellipsis]"}], ")"}]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["4", "u"], "+", "4", "+", "u"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", "u", "+", 
         SuperscriptBox["u", "2"], "-", "\[Ellipsis]"}], ")"}]}], "=", 
      RowBox[{
       RowBox[{
        FractionBox["4", "u"], "-", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
           RowBox[{"n", "=", "0"}]}], 
          RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "n"], 
          SuperscriptBox["u", "n"]}]}]}], "=", 
       RowBox[{
        FractionBox["4", 
         RowBox[{"z", "-", "2"}]], "-", 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
           RowBox[{"n", "=", "0"}]}], 
          RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "n"], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z", "-", "2"}], ")"}], "n"], "."}]}]}]}]}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"4f2bc3d6-8b79-41b5-9705-603e3e0f5ef9"]], \
"SolvedExampleNote",
 CellID->218544171,ExpressionUUID->"3d48d98a-bb8b-49bb-9735-2c53c410f153"],

Cell[TextData[{
 "Check with ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->87624700,ExpressionUUID->"a4cdc62a-1f66-4e44-b8b3-8abf160629d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "5"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->163526257,ExpressionUUID->"ec42cf42-1d9e-4e0a-a842-f1b509d126cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["4", 
    RowBox[{"z", "-", "2"}]], "+", 
   RowBox[{"(", 
    RowBox[{"z", "-", "2"}], ")"}], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", "2"}], ")"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", "2"}], ")"}], "3"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", "2"}], ")"}], "4"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "-", "2"}], ")"}], "5"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "2"}], "]"}], "6"],
    SeriesData[$CellContext`z, 2, {}, -1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 2, {4, 0, 1, -1, 1, -1, 1}, -1, 6, 1],
  Editable->False]], "SolvedExampleOutput",
 CellID->39507825,ExpressionUUID->"f052a512-0b83-4d2f-b8fa-a1895bdfadfe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "n"}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->1755147,ExpressionUUID->"4259183c-8e6b-4b31-a59a-1e94286d6ff4"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {"4", 
        RowBox[{"n", "\[Equal]", 
         RowBox[{"-", "1"}]}]},
       {
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"]}], 
        RowBox[{"n", ">", "0"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "SolvedExampleOutput",
 CellID->856512528,ExpressionUUID->"6e81d049-41d1-4456-97c9-0080e3347386"]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8e4ae6bd-2367-48d2-a58c-81c0770524e4"],
 ":"
}], "SolvedExampleNote",
 CellID->359790643,ExpressionUUID->"15e5187b-dc88-4357-85bd-d96e41ec4583"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot3D", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["5", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["920", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[PlotLegends -> Automatic, PlotRange -> {0, 10}, AxesLabel -> {
       Re[$CellContext`z], 
       Im[$CellContext`z]}, AxesStyle -> Directive[12], 
     BoxRatios -> {1, 1, 5/3}],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->160458930,ExpressionUUID->"27e8bc4c-2e7e-42b6-af5c-f3d17ae8b9f6"],

Cell[BoxData[
 TemplateBox[{
   Graphics3DBox[{
     GraphicsComplex3DBox[CompressedData["
1:eJyVnXVUVsv3/xEFxaQUQUQQVLC7dQ5257W9FnZ317UV9YrdYieoYCs+iIGC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      "], {{{
         EdgeForm[], 
         Texture[
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJy1vXd0lNXaxv2u71tLRZB21KOeBLCAikhPoSO9SAfpIojSEWnSu3TpXZDe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             "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
            False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSizeRaw -> {144., 144.}, 
           PlotRange -> {{0, 144.}, {0, 144.}}]], 
         GraphicsGroup3DBox[
          TagBox[{
            Polygon3DBox[CompressedData["
1:eJxNnXfc19MXwL/r8xjZFRGlUgpRRmREKUWE7IgkJJWRUSKlgUIKpWT3ozQk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             "]], 
            Polygon3DBox[CompressedData["
1:eJwtk0svnlEUhc/He05VCRWipFKXMjAjDExdEiMSP8GgDJr2L7Rh7gdIxFAa
ZgYuiQFDcQny8RUl7qlWVWgRxLOyz2Blr73Pefdlnf1W9X7u+ZTlnGsCCXDB
uX+QPo8Fhfid2FFwBvbBSMq54Wzn+jl7DzL488Tr4HfYBb6fJrYIX/d29wux
C/gP8CKxHFvwN3zTgp3FL4X/hQ9w3og9AI/gFD+F/cr5MbYafxL8h9+CGfhH
3QMV3Bn0ljMfXgla4ZvkfwcvAx/w0/i58JxgvJ4cL4P1qF5zwJ63Gqo1xgzf
4fdgCb8D/FIvwXrvhdcEy6FcU8SWVFdIbGbN/kdzwM/AE/waDCU20xH8AczB
x6m3Ay8mXzd+F/iNn8J/hW0DJ+DcWy8T3N+Fb3jrXTVU67W+9zbzjbc7uqsa
a/C8YG83GLVLgtW6pf/sYG8+GjWW1p5YA7ZZ7xjsjfRWioVgseY4k2bb9jaL
Ziji7Cd+e2IaSstDUJ6YRtJKGktr3VmNO6hd7I6zLHvbLWnwNpiG0lI7cwm/
At/izmh3SoK9hWJV8JW4C9px7XrG29uph8OoqbTVzhQE27lU3GntdtqbNp3x
36gNtnv6B/QvPAPfonbT
             "]]}, Annotation[#, "Charting`Private`Tag$42705#1"]& ]]}, {}, {
         EdgeForm[], 
         GrayLevel[0.82], 
         GraphicsGroup3DBox[{
           Polygon3DBox[CompressedData["
1:eJxNlt1LnnUYx5/yvn+gjHY4lOkaDIRykXt0czqduop8qXy0xpb0NrXozVWr
KDWJnYzAPFKCNaoduI4GRqe5juZi7A+Ym6GyM2EodNTcRt9v10fYwcX1u6/n
uq/f9fL9Xs+999Tp/tHHC4XCuqRM0pgVCquS248VChN5oXBE8r2e1yXTkiuy
L2VhW9C5Qr8PSy7q5QvSQ5Jq/fZmKhR2SL+Vwn+YOI43wnlBekr6D8XZyML+
pPTnemdW+gvpXxR3Hp+tLM6+93399p3OH0jvlf5dsiz7ET3X69wq/Zrkb9mO
S/9aFj5+3ql7OnW+JNvbvkO2d6T7ZV+RvUNyT9KeRazjstdK/pXf6/L7U3pQ
+hTvDkn/qN8HJbvk/66ef5b9PekPU9g/kp6R3pfHO59R45kUdfr8ZYr+VNIH
53kuj7rGpMfziFvOuSaL/k/Qz7uSszrX0WfbPS/7jTGjSelv8qjB2s+eq3Pb
k4WP83U9hyRt+Nj/N+lmyQ/0x/qW46S4dzLFHB9KipKX9HxPv7+coqYq6npR
zwM6d0nf0fOrOh/Lws/+r6SwDWC3DND/KnpinPblMTPPy30doz/GQyW1V9FP
99Cztf9cWdTVmofvOXKzj+fQxBzrPEf57pd+kAX+itTdDM6Nx0Uw2ZLH2Zg1
trvw8Tz+yiKmaynlgT3n0kc+c3nYXWMtdp9973XJAeZbRxzXO8NMG/C5zbuz
xOzNA0O+qxM8LcO1J/LI2fYbcGELe5E8bfc8fO/5PPhmbJynP03gZBf9uEC9
bXDwqOcIB83FPnhYkl6Ds342TiuYVwmf/hR4nIEvB1PccShFzy/msRN263w1
izndIG/XYn6Ug4cR+Gheuge94Mfau87n8iz8Pbv/Z0L/S5yNMffZfb0FB1vw
r2RPOn/PvwVu9rE3/M4q9zm3KXJ2/sPUbv6eZLd4x9wkJ8dfBGc+/8McvP8c
Y4ran9XzZf1Wn4IH+8CG9/Fl9uzT4Nm4Xssjfm2KWnx2j5pS8Pyw9BvscO9y
Y9k9Nw7PsnudyyZ8N69HU+yM0yk4tZM++7/Ds9wBhx6A52444rP/I2rYP7up
1f3ZT87PpNhX08Sxz0383MMl3jUP7sOFTc5FYi/BU9t7yK2CvefZGctN7D3v
gx721bU8+FwNBrrJ2c/O33iw7ubczn7cti+A1RFw4phjKbg8nqKvXfh4T8zC
8RYw7Ny9p7yvzKXt/VsPX7eoa57+OrdJdvc0PdikJyV2qrFtzG3w7lV66hxc
7xCYMUfNVe8N26490ocV+NADDlzXAHw3782ZVfi4wLuO+S34MY4Wmc0CdVXT
tzl2oGPcgdfeRQ+pxTPtIAfX5Z00CDfG+S+o4f4OfCrZ98vE2SBn741O4rue
dnJYw27/p8ChOfR8im+CF+CH8eMdtQc8beOwgVm0Mgtzu4f/vN4UszcGJqS/
kvwkn69T3Om7vQe9y9vp8xm+E/x9dBieNqf41jEWvHd7wK6xfR2uuVclenmJ
7yD3wXM6wc7x7pnGfoVa1jnfJ1aRfjgv98rY28Bu7DfQN9dhHLu2o+TWnuIb
y33yd9MnKbj2aYp5Nj4yx7vgf4Ue2t7I/j9Inm3M8mN2zig8mqfnI+RmjB9I
gd2i9LEUO/k54qyzT/4D/fZZ+w==
            "]], 
           Polygon3DBox[CompressedData["
1:eJwlkksrBFAUxw9mTikfwUYpQ/LWaFDeb9GMUIg8Ul6DhVcG2SnbyUbYWVn4
BLY+go2FrH0AVn7/zuJfv3PPvffc8z+3ajWf3Ss1sxRKoFM3e0ia1ROcwQ3o
sczslrgRPkJF+B0dwxPoG/4rMZuEa1FlIs7UwUNolvt+yQ/DKfSRiD3ae4l+
4Bt0BQ+gmmScGYRb0Rp8j9o8aqq23ngCb3mcXSDehhdRAa5gbUln0RO1q1lb
h3tRD7kicR+8qf7Il7P2xVon8R3cjLrgPEqz3oH2ddYjpzt014FHTp4cwqMo
RzyDxuAsesaLT2rkPDyQF9ozIm88ct3Ec/CORy+quevhubx/IW7y2KO9b5yZ
11s8cvKoxaNH9aqeNuSlR2/yXN6nUYb8q3ry8EBeyPN+eMpjlnrzNLzs4aU8
XIEv0HUyZqbZaSaaje5s19s93qYZaBYZj1ryVN6ee/wt3VHw8Ehe6Q+Nw/9r
Z0ZZ
            "]]}]}, {}, {}}, {{
         GrayLevel[0], 
         Line3DBox[CompressedData["
1:eJwl0skuX1EcB/DTomjNQ80ViZVha2HYozsrw06EP1rzPE/BgrDQ2rARPICy
FeEFDC/ACxheQPu56eKT3/eXnHN+99x7yzoHWwY+hBC2GE4IIcoV6mVcCKVy
Ax1Ms88FD7yRbnE13+llgxNueOIvJR9DqKONSX7xhzteSDWnkia64kPYMbtH
HlRP9DG5lz76+cFPBqI1DDHMCKOMMc4Ek0wxzQyzzDHPAossscwKq3SbuWv2
WnS2eqrvlhupIIVnz33LGXtM0Eotxby794F92/Y/ykdqjX5TvdYfquX6Y3md
GM1Ukcard3vPOb+Zop16rqK72v9NblVjzimRiymikALyyeMrueSQTRaZZETf
jzRSSeELn0kmiUQ+YUwwJhgdXC/0xP//V/4BAfU57g==
          "]], 
         Line3DBox[{1640, 1504, 1531, 1484, 1496, 1502, 1495, 1507, 1497, 
          1558, 1571, 1570, 1559, 1560, 1547, 1549, 1565, 1548, 1574, 1572, 
          1573, 1562, 1511, 1528, 1512, 1552, 1494, 1513, 1566, 1539, 1540, 
          1517, 1556, 1489, 1554, 1499, 1555, 1500, 1532, 1490, 1501, 1515, 
          1516, 1530, 1514, 1488, 1498, 1527, 1509, 1550, 1508, 1524, 1543, 
          1541, 1563, 1542, 1506, 1521, 1520, 1534, 1519, 1492, 1538, 1503, 
          1518, 1491, 1640}], 
         Line3DBox[{1665, 1533, 1522, 1569, 1557, 1485, 1545, 1544, 1546, 
          1561, 1525, 1553, 1526, 1536, 1487, 1493, 1567, 1568, 1551, 1510, 
          1537, 1564, 1486, 1535, 1483, 1529, 1665}], 
         Line3DBox[{1583, 1582, 1581, 1580, 1579, 1578, 1577, 1576, 1575, 
          1505, 1639, 1638, 1637, 1636, 1635, 1634, 1633, 1632, 1631, 1630, 
          1629, 1628, 1627, 1626, 1625, 1624, 1623, 1622, 1621, 1620, 1619, 
          1618, 1617, 1616, 1615, 1614, 1613, 1612, 1611, 1610, 1609, 1608, 
          1607, 1606, 1605, 1604, 1603, 1602, 1601, 1600, 1599, 1598, 1597, 
          1596, 1595, 1594, 1593, 1592, 1591, 1590, 1589, 1588, 1587, 1586, 
          1585, 1584, 1583}], 
         Line3DBox[{1666, 1664, 1663, 1662, 1661, 1660, 1659, 1658, 1657, 
          1656, 1655, 1654, 1653, 1652, 1651, 1650, 1649, 1648, 1647, 1646, 
          1645, 1644, 1643, 1642, 1641, 1523, 1666}]}}}, 
      VertexNormals -> CompressedData["
1:eJy8vHc01/8fPswHSQlREhkpu5KkRPWgVBqkhFIapEQisiKUEVEUEcre2Xs/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       "], VertexTextureCoordinates -> CompressedData["
1:eJyF3HucVlW9x3HyaKGBOYWmmKWRSomJeEmP0j55Ck09klqIJ0PxGohpeKsw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       "]], {}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, DisplayFunction -> 
     Identity, Ticks -> {Automatic, Automatic, Automatic}, FaceGrids -> None, 
     DisplayFunction -> Identity, Axes -> True, AxesLabel -> {
       FormBox[
        TagBox[
         RowBox[{"Re", "(", "z", ")"}], HoldForm], TraditionalForm], 
       FormBox[
        TagBox[
         RowBox[{"Im", "(", "z", ")"}], HoldForm], TraditionalForm], None}, 
     AxesOrigin -> {Automatic, Automatic, Automatic}, AxesStyle -> 
     Directive[12], BoxRatios -> NCache[{1, 1, 
        Rational[5, 3]}, {1, 1, 1.6666666666666667`}], DisplayFunction :> 
     Identity, Lighting -> "Neutral", 
     Method -> {"RotationControl" -> "Globe"}, 
     PlotRange -> {{-2.999999793103448, 
      2.999999793103448}, {-2.999999793103448, 2.999999793103448}, {0., 10.}},
      PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02], Automatic}, Ticks -> {Automatic, Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             RasterBox[CompressedData["
1:eJx1mPk3FNzjx8lWUhIlSyklsmWpUPSWirQpT4gsFZVCPA+FbKWSKERCZElJ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              "], {{
                Rational[-15, 2], -75}, {
                Rational[15, 2], 75}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], -75}, {
                  Rational[-15, 2], -75}, {
                  Rational[-15, 2], 75}, {
                  Rational[15, 2], 75}, {
                  Rational[15, 2], -75}}, {{
                 7.5, -75}, {-7.5, -75}, {-7.5, 75}, {7.5, 75}, {
                 7.5, -75}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -75.}, {7.5, 75.}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -75.}, 
                    Offset[{4., 0}, {7.5, -75.}]}, {{7.5, -37.5}, 
                    Offset[{4., 0}, {7.5, -37.5}]}, {{7.5, 0.}, 
                    Offset[{4., 0}, {7.5, 0.}]}, {{7.5, 37.5}, 
                    Offset[{4., 0}, {7.5, 37.5}]}, {{7.5, 75.}, 
                    Offset[{4., 0}, {7.5, 75.}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False], 
                   StyleBox[
                    LineBox[{{{7.5, -67.5}, 
                    Offset[{2.5, 0.}, {7.5, -67.5}]}, {{7.5, -60.}, 
                    Offset[{2.5, 0.}, {7.5, -60.}]}, {{7.5, -52.5}, 
                    Offset[{2.5, 0.}, {7.5, -52.5}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -45.}, 
                    Offset[{2.5, 0.}, {7.5, -45.}]}, {{7.5, -30.}, 
                    Offset[{2.5, 0.}, {7.5, -30.}]}, {{7.5, -22.5}, 
                    Offset[{2.5, 0.}, {7.5, -22.5}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -15.}, 
                    Offset[{2.5, 0.}, {7.5, -15.}]}, {{7.5, -7.5}, 
                    Offset[{2.5, 0.}, {7.5, -7.5}]}, {{7.5, 7.5}, 
                    Offset[{2.5, 0.}, {7.5, 7.5}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 15.}, 
                    Offset[{2.5, 0.}, {7.5, 15.}]}, {{7.5, 22.5}, 
                    Offset[{2.5, 0.}, {7.5, 22.5}]}, {{7.5, 30.}, 
                    Offset[{2.5, 0.}, {7.5, 30.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 45.}, 
                    Offset[{2.5, 0.}, {7.5, 45.}]}, {{7.5, 52.5}, 
                    Offset[{2.5, 0.}, {7.5, 52.5}]}, {{7.5, 60.}, 
                    Offset[{2.5, 0.}, {7.5, 60.}]}, {{7.5, 67.5}, 
                    Offset[{2.5, 0.}, {7.5, 67.5}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["\"-\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"-\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"0\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 0.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]/2\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 37.5}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["\"\[Pi]\"", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 75.}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], 
                    
                    StyleBox[{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4], 
                    Opacity[0.3]], {
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False]}, {}}, {{
                    Directive[
                    Opacity[1]], 
                    Directive[
                    Opacity[1]]}}, StripOnInput -> False], {"GraphicsLabel"}, 
                   StripOnInput -> False]}, {"GraphicsTicks"}, StripOnInput -> 
                 False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]], 
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4], 
                   Opacity[0.3]]}}, StripOnInput -> False]}, {"GraphicsAxes"},
               StripOnInput -> False]}, PlotRangePadding -> Scaled[0.02], 
            PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 150}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]}, "BarLegend", 
      DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{
                   InterpretationBox[
                    RowBox[{
                    TagBox["ColorDataFunction", "SummaryHead"], "[", 
                    
                    DynamicModuleBox[{
                    Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
                    TemplateBox[{
                    PaneSelectorBox[{False -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxOpener"]], 
                    ButtonFunction :> (Typeset`open$$ = True), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}], True -> GridBox[{{
                    PaneBox[
                    ButtonBox[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "SummaryBoxCloser"]], 
                    ButtonFunction :> (Typeset`open$$ = False), Appearance -> 
                    None, BaseStyle -> {}, Evaluator -> Automatic, Method -> 
                    "Preemptive"], Alignment -> {Center, Center}, ImageSize -> 
                    Dynamic[{Automatic, 
                    3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    GridBox[{{
                    RowBox[{
                    TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"MidShiftBalancedHue\"", "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Gradient: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    StyleBox[
                    GraphicsBox[{
                    RasterBox[CompressedData["
1:eJx1luk71YkbxgkpW1lqOnZKSalskdRd1pqUplCJFIWQzFDWhmgxKbtQERWZ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                    "], {{0, 0}, {1, 1}}]}, {
                    ImageSize -> 65, BaselinePosition -> Bottom, AspectRatio -> 
                    NCache[
                    Rational[1, 8], 0.125], PlotRange -> {{0, 1}, {0, 1}}}], 
                    Selectable -> False, StripOnInput -> False], 
                    "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Domain: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox[
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}], "SummaryItem"]}]}, {
                    RowBox[{
                    TagBox["\"Class: \"", "SummaryItemAnnotation"], 
                    "\[InvisibleSpace]", 
                    TagBox["\"ThemeGradients\"", "SummaryItem"]}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
                    AutoDelete -> False, 
                    GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{2}}, "Rows" -> {{Automatic}}}, 
                    BaseStyle -> {
                    ShowStringCharacters -> False, NumberMarks -> False, 
                    PrintPrecision -> 3, ShowSyntaxStyles -> False}]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    BaselinePosition -> {1, 1}]}, 
                    Dynamic[Typeset`open$$], ImageSize -> Automatic]}, 
                    "SummaryPanel"], DynamicModuleValues :> {}], "]"}], 
                    ColorDataFunction[
                    "MidShiftBalancedHue", "ThemeGradients", {0, 1}, Blend[
                    "MidShiftBalancedHue", #]& ], Selectable -> False, 
                    Editable -> False, SelectWithContents -> True], "[", "#1",
                    "]"}], "&"}], ",", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "150"}], ",", 
           RowBox[{"\"ColorFunctionShading\"", "\[Rule]", "None"}], ",", 
           RowBox[{"OpacityFunction", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionTicks\"", "\[Rule]", "None"}], ",", 
           RowBox[{"\"OpacityFunctionSize\"", "\[Rule]", 
             RowBox[{"Scaled", "[", "0.5`", "]"}]}], ",", 
           RowBox[{"\"OpacityFunctionRange\"", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], ",", 
           RowBox[{"Charting`TickLabels", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "\"-\[Pi]\"", ",", "\"-\[Pi]/2\"", ",", "\"0\"", ",", 
                 "\"\[Pi]/2\"", ",", "\"\[Pi]\""}], "}"}]}], ",", 
           RowBox[{"Ticks", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   
                   RowBox[{
                    "0.`", ",", "0.25`", ",", "0.5`", ",", "0.75`", ",", 
                    "1.`"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    FractionBox["1", "20"], ",", 
                    FractionBox["1", "10"], ",", 
                    FractionBox["3", "20"], ",", 
                    FractionBox["1", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "5"], ",", 
                    FractionBox["1", "4"], ",", 
                    FractionBox["3", "10"], ",", 
                    FractionBox["7", "20"], ",", 
                    FractionBox["2", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["2", "5"], ",", 
                    FractionBox["9", "20"], ",", 
                    FractionBox["1", "2"], ",", 
                    FractionBox["11", "20"], ",", 
                    FractionBox["3", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["3", "5"], ",", 
                    FractionBox["13", "20"], ",", 
                    FractionBox["7", "10"], ",", 
                    FractionBox["3", "4"], ",", 
                    FractionBox["4", "5"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["4", "5"], ",", 
                    FractionBox["17", "20"], ",", 
                    FractionBox["9", "10"], ",", 
                    FractionBox["19", "20"], ",", "1"}], "}"}]}], "}"}]}], 
               "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], 
     "]"}]& )]], "SolvedExampleOutput",
 CellID->393367227,ExpressionUUID->"229df542-26fe-480a-8fae-0e387e368fc1"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->938485369,ExpressionUUID->"16ef9d40-eab4-4286-9bd9-0fee5d858882"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->724465672,ExpressionUUID->"94cd3f11-7624-4203-a335-1cc90d90e640"],

Cell[TextData[{
 "Find the Laurent series of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", "z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6d5ebc57-a289-4e74-9eab-c392e3c6c8de"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "39974e29-8937-4965-a76e-dd08a2c60a3d"],
 "."
}], "SolvedExampleNote",
 CellID->925486181,ExpressionUUID->"ff8585de-175e-432e-9379-55a1ed1b5677"],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "z"], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     FractionBox[
      SuperscriptBox["z", "n"], 
      RowBox[{"n", "!"}]]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6b70d02a-ca8e-4707-9094-ece711ddf5ca"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "/", "z"}]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     FractionBox[
      SuperscriptBox["z", 
       RowBox[{"-", "n"}]], 
      RowBox[{"n", "!"}]]}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "80fdbfcc-14a0-40b2-8fef-81623c6a1735"],
 "."
}], "SolvedExampleNote",
 CellID->99854143,ExpressionUUID->"744abc76-7c95-457b-9876-085e33c2ae2c"],

Cell[TextData[{
 "There are infinitely many negative powers in the series expansion, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f91a5aad-ae9c-48ab-bb66-c0fe1d270f42"],
 " is called an ",
 StyleBox["essential singularity",
  FontSlant->"Italic"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9b738e2a-72b2-4a6c-968d-2fbd0064b76b"],
 "."
}], "SolvedExampleNote",
 CellID->89793167,ExpressionUUID->"dd1ab501-811b-4b7b-a5e5-aec2fae38937"],

Cell["", "SolvedExampleEndCap",
 CellID->748840892,ExpressionUUID->"b94479f4-22e4-48b8-87b9-d7039349ac18"],

Cell["\<\
The Laurent expansion of a function depends not only on the expansion point \
but also on what region is being considered, as the following example shows.\
\>", "Text",
 CellID->230431203,ExpressionUUID->"deaca428-8bff-4d72-ad9e-a203b5568a49"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->599151269,ExpressionUUID->"3cefc2af-b2b4-4c7d-b5a2-6a513ba7b821"],

Cell[TextData[{
 "Find the Laurent expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox["1", 
     RowBox[{"z", "(", 
      RowBox[{"z", "+", "1"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5e1e3525-a68c-44da-acd0-870f51d2e076"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d761d130-fe5d-4749-be3e-add64e73d7ad"],
 ":"
}], "SolvedExampleNote",
 CellID->83607975,ExpressionUUID->"0ff60c64-1a75-4a1b-82a3-78120f9eba28"],

Cell[TextData[{
 "1. in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "23909300-089c-4c22-b005-297631ca59f6"]
}], "SolvedExampleNote",
 CellID->276087372,ExpressionUUID->"be2483c2-2557-4f9e-abf2-bf6725238fda"],

Cell[TextData[{
 "2. in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", " ", 
    RowBox[{">", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "99c9c2e6-95e0-4df6-bc52-eb7f065743cc"]
}], "SolvedExampleNote",
 CellID->222567898,ExpressionUUID->"c3241381-abf1-4236-91ae-423af1b28e19"],

Cell[TextData[{
 "Solution: First, decompose ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5e01a471-9a08-4039-943e-9e4549afce5b"],
 " into partial fractions:"
}], "SolvedExampleNote",
 CellID->138804032,ExpressionUUID->"1777b565-752e-4fb2-b6fb-da055f6f4397"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}]}]], ",", "z"}], 
  "]"}]], "SolvedExampleInput",
 CellID->131682427,ExpressionUUID->"a290fbea-55da-4ee8-bbe7-4524b2ee8b31"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "z"], "-", 
  FractionBox["1", 
   RowBox[{"1", "+", "z"}]]}]], "SolvedExampleOutput",
 CellID->267125,ExpressionUUID->"a6e2b543-8ef5-429b-87e0-92826d946158"]
}, Open  ]],

Cell[TextData[{
 "1. Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "z"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a53a4f48-eb4a-4a94-b217-2ed8fedac73d"],
 " as a geometric series. This is possible because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "907b829b-efb0-4848-a35c-e329ba3603b4"],
 ":"
}], "SolvedExampleNote",
 CellID->780712,ExpressionUUID->"de17e6aa-b38e-4e83-a965-71f1745b4d95"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "z"}]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], 
      SuperscriptBox["z", "n"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2b700045-84b7-494f-a572-641982617c5c"],
 "."
}], "SolvedExampleNote",
 CellID->564609518,ExpressionUUID->"df064f1c-c51c-4d44-bea2-bcc602c819fa"],

Cell[TextData[{
 "So the Laurent series is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "z"], "-", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], 
      SuperscriptBox["z", "n"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"494a99f2-85fa-4e66-82e6-e91df6286e9b"],
 "."
}], "SolvedExampleNote",
 CellID->411107617,ExpressionUUID->"9f4f4fd5-aa7a-437a-b506-d13e853e2753"],

Cell[TextData[{
 "2. In order to write ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "z"}], ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"647ab60e-581c-4d2a-aa23-71d29f2932e6"],
 " as a series expansion, one can do the following:"
}], "SolvedExampleNote",
 CellID->236068090,ExpressionUUID->"3e6509e5-32ae-4c93-8b93-c653124306c4"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", "z"}]], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"z", "(", 
       RowBox[{"1", "+", 
        RowBox[{"1", "/", "z"}]}], ")"}]], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "z"], "\[CenterDot]", 
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
          RowBox[{"n", "=", "0"}]}], 
         RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "n"], 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "z"], ")"}], "n"]}]}]}], "=", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"], 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "z"], ")"}], 
         RowBox[{"n", "+", "1"}]]}]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4af0edce-4543-4149-9cf9-27b28c4318a8"],
 ", so the Laurent series is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "z"], "-", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], 
       RowBox[{"n", "+", "1"}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"df0985b2-d284-42b5-8e84-ed0a8f74c042"],
 "."
}], "SolvedExampleNote",
 CellID->185966202,ExpressionUUID->"4161cbe7-0329-4274-a89a-c8e0907bd8a8"],

Cell["", "SolvedExampleEndCap",
 CellID->442185890,ExpressionUUID->"6d31852e-a2c7-4686-8cdf-0da4aeb15109"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"fee9bdc1-952b-4cd7-8709-697ca02741e0"],

Cell[TextData[{
 "Laurent\[CloseCurlyQuote]s theorem: If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"745d2a4b-eb68-48d2-951b-162817b33e3b"],
 " is analytic in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", 
    RowBox[{"<|", 
     RowBox[{
      RowBox[{"z", "-", 
       SubscriptBox["z", "0"]}], "|", 
      RowBox[{"<", "R"}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0b53ca80-ce55-4627-b050-bc3dde07c173"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      FractionBox[
       SubscriptBox["b", "n"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", 
          SubscriptBox["z", "0"]}], ")"}], "n"]]}], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      SuperscriptBox[
       RowBox[{
        SubscriptBox["a", "n"], "(", 
        RowBox[{"z", "-", 
         SubscriptBox["z", "0"]}], ")"}], "n"]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"975acfd4-50e1-466c-852e-70b248cf87f8"],
 "."
}], "SummaryList",
 CellID->15385668,ExpressionUUID->"3d96e5ed-54f2-40a3-bcb4-99c23129860e"],

Cell[TextData[{
 "The coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "41d4bbd9-7496-4a14-8164-fe6087b6dc6a"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "n"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "fcc06b32-47f4-4990-a026-4ac58e0332a2"],
 " are given by:"
}], "SummaryList",
 CellID->668453209,ExpressionUUID->"b490bfa4-8b8c-43f3-bd56-c063cb8cb70a"],

Cell[BoxData[{
 FormBox[
  RowBox[{
   SubscriptBox["a", "n"], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      FractionBox[
       RowBox[{"f", "(", "\[Zeta]", ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"\[Zeta]", "-", 
          SubscriptBox["z", "0"]}], ")"}], 
        RowBox[{"n", "+", "1"}]]], 
      RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], TraditionalForm], "\n", 
 FormBox[
  RowBox[{
   SubscriptBox["b", "n"], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "\[Zeta]", ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[Zeta]", "-", 
         SubscriptBox["z", "0"]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "\[Zeta]"}]}]}]}]}], 
  TraditionalForm]}], "DisplayFormula",
 CellID->494071528,ExpressionUUID->"5b5e1dec-81d8-4b09-a275-ba38884e27c0"],

Cell["\<\
The Laurent series can depend on the region being considered.\
\>", "SummaryList",
 CellID->60311985,ExpressionUUID->"0e68848e-22c1-4509-95dc-aa17b5d8b4f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->782520772,ExpressionUUID->"2745cb69-262c-4876-885f-d23e17b22750"],

Cell[TextData[{
 "Write the Laurent series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     SuperscriptBox[
      RowBox[{"z", "(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"08f5432e-8be3-4043-8df6-c222a80c27da"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e363db6e-3146-477c-b7d9-a55777f2f5df"],
 ", valid in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "+", "1"}], "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "18c0cff1-9068-4576-9080-d50ba3f17281"],
 "."
}], "Exercise",
 CellID->135800712,ExpressionUUID->"ef8ea695-40f7-46fd-8de1-92086c76d126"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"cba7ec46-85a8-4270-a349-803f20385574"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "+", "1"}], "=", "u"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d576200d-ed43-4be6-a651-cf80dc06e151"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     SuperscriptBox[
      RowBox[{"z", "(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]], "=", 
    FractionBox[
     RowBox[{"u", "-", "2"}], 
     RowBox[{
      SuperscriptBox["u", "2"], "(", 
      RowBox[{"u", "-", "1"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a87dced5-9f58-4514-8959-fd50d1af144e"],
 " and in the requested region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", "u", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "87b3c890-ca03-4ceb-b2e3-710cf5c53af1"],
 ". After expanding into partial fractions:"
}], "SolutionAnswer",
 CellID->65071408,ExpressionUUID->"4461b511-a38b-4e90-a6b6-9216d1cefa89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"u", "-", "2"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"u", "^", "2"}], 
     RowBox[{"(", 
      RowBox[{"u", "-", "1"}], ")"}]}], ")"}]}], "]"}]], "ExerciseInput",
 CellID->11342027,ExpressionUUID->"8a5748a9-0d8a-4c1c-baab-a8d2548a17ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "u"}]]}], "+", 
  FractionBox["2", 
   SuperscriptBox["u", "2"]], "+", 
  FractionBox["1", "u"]}]], "ExerciseOutput",
 CellID->109197952,ExpressionUUID->"9e4b717c-ed47-4cb9-96f9-0b7fd349d1f0"]
}, Open  ]],

Cell[TextData[{
 "Using the geometric series: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", "u"}], ")"}]}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "0"}]}], 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
     SuperscriptBox["u", "n"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8e0e654a-c9af-4b00-a1de-a0f26f18c0f5"],
 ", so:"
}], "SolutionAnswer",
 CellID->4315527,ExpressionUUID->"6013b4b2-82a3-49e6-81b0-39b67167857b"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"u", "-", "2"}], 
     RowBox[{
      SuperscriptBox["u", "2"], "(", 
      RowBox[{"u", "-", "1"}], ")"}]], "=", 
    RowBox[{
     FractionBox["2", 
      SuperscriptBox["u", "2"]], "+", 
     FractionBox["1", "u"], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      SuperscriptBox["u", "n"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"09271bc8-4b4e-4a00-a9e7-3333ad00cc07"],
 ". Substituting back the variable ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "46e50370-df6b-4f96-88ef-49db2f8b227a"],
 ", we get ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox["2", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "2"]], "+", 
     FractionBox["1", 
      RowBox[{"z", "+", "1"}]], "+", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "n"]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"b4f4725d-662f-4510-86ed-aaef50354065"],
 "."
}], "SolutionAnswer",
 CellID->64019269,ExpressionUUID->"52fd23da-dcdd-486f-a09e-9a7f584adeab"],

Cell[TextData[{
 "Check the first few terms with ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->340503088,ExpressionUUID->"c036818b-4a1d-4b44-be33-7825de502c4b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "-", "1"}], 
    RowBox[{"z", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "4"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->532998498,ExpressionUUID->"f266b271-5c20-46d6-8b10-c774bc9d03f3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["2", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "+", "1"}], ")"}], "2"]], "+", 
   FractionBox["1", 
    RowBox[{"z", "+", "1"}]], "+", "1", "+", 
   RowBox[{"(", 
    RowBox[{"z", "+", "1"}], ")"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "+", "1"}], ")"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "+", "1"}], ")"}], "3"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"z", "+", "1"}], ")"}], "4"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "+", "1"}], "]"}], "5"],
    SeriesData[$CellContext`z, -1, {}, -2, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, -1, {2, 1, 1, 1, 1, 1, 1}, -2, 5, 1],
  Editable->False]], "ExerciseOutput",
 CellID->197549002,ExpressionUUID->"04dbc3cd-74a7-43d6-81ac-98b5ef677af9"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Write the Laurent series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     SuperscriptBox[
      RowBox[{"z", "(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"605a9371-baf7-44b3-b875-619c14a1675f"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f83e8b8c-d520-48db-8feb-b3618783b213"],
 ", valid in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "+", "1"}], "|", " ", 
    RowBox[{">", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b3e01262-ffe6-44a1-919a-1c2ab221fdb2"],
 "."
}], "Exercise",
 CellID->92568638,ExpressionUUID->"b8ff43af-ede4-4dbc-a588-6c442e2475b5"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"7f8af07f-c7e2-4995-8297-05a1f8c35d21"],

Cell[TextData[{
 "As in Exercise 21.1, write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "+", "1"}], "=", "u"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"328cfe83-1ff3-4ffa-a41a-6da127560a58"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     SuperscriptBox[
      RowBox[{"z", "(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"u", "-", "2"}], 
      RowBox[{
       SuperscriptBox["u", "2"], "(", 
       RowBox[{"u", "-", "1"}], ")"}]], "=", 
     RowBox[{
      FractionBox["2", 
       SuperscriptBox["u", "2"]], "+", 
      FractionBox["1", "u"], "+", 
      FractionBox["1", 
       RowBox[{"1", "-", "u"}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b1bb8572-e0db-4b8d-beaa-7f5fa3ea7524"],
 ". Now, in the requested region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "u", "|", " ", 
    RowBox[{">", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c23d51ee-b602-406b-972a-c62e6ca3149a"],
 ", so one must expand the third term around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "u"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "3ba8a0ab-9a5f-47bd-9b2b-60a7465ccce6"],
 " as follows:"
}], "SolutionAnswer",
 CellID->718781157,ExpressionUUID->"b1f44030-6102-416c-9c5a-2446c5b0e0ec"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", "u"}]], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "u"]}], "\[CenterDot]", 
      FractionBox["1", 
       RowBox[{"1", "-", 
        RowBox[{"1", "/", "u"}]}]]}], "=", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "u"]}], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "u"], ")"}], "n"]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"7df6ec4d-b0b7-4516-aa90-9a9f855a4be8"],
 ". So the Laurent series requested is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["2", 
      SuperscriptBox["u", "2"]], "+", 
     FractionBox["1", "u"], "-", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      FractionBox["1", 
       SuperscriptBox["u", 
        RowBox[{"n", "+", "1"}]]]}]}], "=", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["u", "2"]], "-", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "3"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      FractionBox["1", 
       SuperscriptBox["u", "n"]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a69f565e-f04a-4c61-afb8-ee43ccd7fd27"],
 ". You can check the first few terms with ",
 ButtonBox["Series",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->120185466,ExpressionUUID->"8284dd32-3d0d-4b99-a663-1b46f98d608c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", "^", "2"}], 
      RowBox[{"(", 
       RowBox[{"u", "-", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "ExerciseInput",\

 CellID->287508375,ExpressionUUID->"99c20cbf-93cc-42d4-b3eb-15bbd9cc188f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "u"], ")"}], "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "u"], ")"}], "3"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "u"], ")"}], "4"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "u"], ")"}], "5"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "u"], "]"}], "6"],
    SeriesData[$CellContext`u, 
     DirectedInfinity[1], {}, 2, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`u, 
   DirectedInfinity[1], {1, -1, -1, -1}, 2, 6, 1],
  Editable->False]], "ExerciseOutput",
 CellID->104744239,ExpressionUUID->"9e656548-d161-42ab-b080-f0368691c1e0"]
}, Open  ]],

Cell[TextData[{
 "and in general with ",
 ButtonBox["SeriesCoefficient",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->604079597,ExpressionUUID->"28f587e4-ccf8-414c-930e-da8420982191"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"u", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"u", "^", "2"}], 
      RowBox[{"(", 
       RowBox[{"u", "-", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "Infinity", ",", "n"}], "}"}]}], "]"}]], "ExerciseInput",\

 CellID->217034993,ExpressionUUID->"4dd678ea-db20-475c-bc50-0d45ab7d464b"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        RowBox[{"-", "1"}], 
        RowBox[{"n", ">", "2"}]},
       {"1", 
        RowBox[{"n", "\[Equal]", "2"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "ExerciseOutput",
 CellID->864844703,ExpressionUUID->"e97464a7-ccbd-468d-ba35-bc4adbd3d1bb"]
}, Open  ]],

Cell[TextData[{
 "Written in terms of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c723ddad-0624-4648-9b0d-af0f2e633728"],
 ", the answer is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "+", "1"}], ")"}], "2"]], "-", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
       RowBox[{"n", "=", "3"}]}], 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "1"}], ")"}], "n"]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e685d7de-88a6-48ba-8db5-b0b91255f000"],
 "."
}], "SolutionAnswer",
 CellID->451442672,ExpressionUUID->"7054988d-c0e6-4709-87c7-8502cf23691f"]
}, Closed]],

Cell[TextData[{
 "Write the Laurent series of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"sin", " ", "z"}], 
     RowBox[{"1", "-", "z"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b0d64cfc-5ebe-4429-a7b7-ee1c57a08b24"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "43be812f-b088-40ec-8bb7-0551046607e6"],
 ". What is its region of convergence?"
}], "Exercise",
 CellID->205318444,ExpressionUUID->"5d9ee143-634c-43f4-bbe1-008e24300da2"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"ab58d1f6-f077-44a9-8cb4-976880f8dcf3"],

Cell[TextData[{
 "Write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "-", "1"}], "=", "u"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e83b6781-c843-4083-bdd3-4a8088b51dfe"],
 ". Then the function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "0dcd2966-fc34-4333-aa60-06cd3dc50c38"],
 " becomes ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"sin", "(", 
     RowBox[{"u", "+", "1"}], ")"}], 
    RowBox[{"-", "u"}]], TraditionalForm]], "InlineMath",ExpressionUUID->
  "54fdd8c9-7f61-4956-a945-10b6a1a8ee17"],
 "and the expansion is around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "088a4146-f81b-4f92-a30a-dc16fb83fc29"],
 ". The series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", 
    RowBox[{"u", "+", "1"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4eeb6db9-5e6f-4419-954b-ad1a2104b8f7"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
      RowBox[{"n", "=", "0"}]}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"sin", "(", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"n", " ", "\[Pi]"}], "2"]}], ")"}], 
      RowBox[{"n", "!"}]], 
     SuperscriptBox["u", "n"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5afcddf6-3abf-45fa-92ac-0d3160f30436"],
 "."
}], "SolutionAnswer",
 CellID->72246331,ExpressionUUID->"a3ad6310-a4d3-43fa-90ae-16020d1f6502"],

Cell[TextData[{
 "So the Laurent series is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      RowBox[{
       FractionBox[
        RowBox[{"sin", "(", 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{"n", " ", "\[Pi]"}], "2"]}], ")"}], 
        RowBox[{"n", "!"}]], 
       SuperscriptBox["u", 
        RowBox[{"n", "-", "1"}]]}]}]}], "=", 
    RowBox[{"-", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
        RowBox[{"n", "=", "0"}]}], 
       RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
      RowBox[{
       FractionBox[
        RowBox[{"sin", "(", 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{"n", " ", "\[Pi]"}], "2"]}], ")"}], 
        RowBox[{"n", "!"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}], 
        RowBox[{"n", "-", "1"}]]}]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3c375759-1bd3-4bae-a7aa-c163d8ae39fe"],
 ". Its region of convergence is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "+", "1"}], "|", " ", 
    RowBox[{">", "0"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d5788e95-41b4-49fb-9d4e-59e8c88766ce"],
 "."
}], "SolutionAnswer",
 CellID->812006206,ExpressionUUID->"1ebaf2a3-43f8-42f6-9979-5fd7100668ca"],

Cell[TextData[{
 "Checking with ",
 ButtonBox["SeriesCoefficient",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->371577429,ExpressionUUID->"0e492485-20ee-470c-969e-8cdf704396e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SeriesCoefficient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "z", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", "z"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "1", ",", "n"}], "}"}]}], "]"}], "//", "ExpToTrig"}], 
  "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{"n", "\[Element]", "Integers"}]}], "]"}], 
   "&"}]}]], "ExerciseInput",
 CellID->278434478,ExpressionUUID->"6818864a-09a7-4876-a615-be29282bf849"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Cos", "[", 
           RowBox[{"1", "+", 
            FractionBox[
             RowBox[{"n", " ", "\[Pi]"}], "2"]}], "]"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", "n"}], ")"}], "!"}]]}], 
        RowBox[{"n", "\[GreaterEqual]", 
         RowBox[{"-", "1"}]}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "ExerciseOutput",
 CellID->97860824,ExpressionUUID->"e3e4ae00-c1d6-4b00-a261-d6590612b0e1"]
}, Open  ]],

Cell["which agrees with the previous formula, because:", "SolutionAnswer",
 CellID->2556837,ExpressionUUID->"7b35652b-01d3-4c74-a362-1176bc1fd2b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Sin", "[", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"n", " ", "\[Pi]"}], "2"]}], "]"}]}], "==", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"n", " ", "\[Pi]"}], "2"]}], "]"}]}], "/.", 
     RowBox[{"n", "->", 
      RowBox[{"n", "-", "1"}]}]}], ")"}]}], "//", 
  "Simplify"}]], "ExerciseInput",
 CellID->12214958,ExpressionUUID->"48c0a764-ad19-47af-9063-2ce1be002748"],

Cell[BoxData["True"], "ExerciseOutput",
 CellID->41338547,ExpressionUUID->"7e20cb1d-f07f-4600-b999-47bfb27856de"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Write the Laurent series of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     RowBox[{
      SuperscriptBox["z", "2"], "+", "1"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f46df9dd-43b0-40ef-a6bf-dc1b53025623"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9dcae3c4-3928-4c71-9ee2-014a350abf90"],
 ". In what region is it convergent?"
}], "Exercise",
 CellID->14616899,ExpressionUUID->"63ed1564-1156-46e2-80c8-82cb40899d67"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"eb943c65-0af5-4790-a72d-9c0ad6e776ab"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"8724470c-d9e2-47aa-855e-eddc93c8c190"],
 " has singularities at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"\[PlusMinus]", "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"8c0c6f37-3e73-4b62-a9b6-bf6c1eed95a0"],
 ". We write the series valid in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "<"}], " ", "|", 
    RowBox[{"z", "-", "\[ImaginaryI]"}], "|", 
    RowBox[{"<", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e7ac1f0c-a219-4c26-beac-2efbe3ed7898"],
 ". By using partial fraction decomposition:"
}], "SolutionAnswer",
 CellID->26342513,ExpressionUUID->"5a3b9399-4668-4cb6-b7f1-f015c4ec10a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apart", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "\[ImaginaryI]"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], ",", "z"}], "]"}], "//",
   "Expand"}]], "ExerciseInput",
 CellID->326088766,ExpressionUUID->"78ef1896-b600-4ba9-a627-4f8856359ff3"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    FractionBox["1", "2"], "+", 
    FractionBox["\[ImaginaryI]", "2"]}], 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}]], "+", 
  FractionBox[
   RowBox[{
    FractionBox["1", "2"], "-", 
    FractionBox["\[ImaginaryI]", "2"]}], 
   RowBox[{"\[ImaginaryI]", "+", "z"}]]}]], "ExerciseOutput",
 CellID->35510218,ExpressionUUID->"70f5ed5c-6d0b-4d46-8f28-0aa938aefb6d"]
}, Open  ]],

Cell[TextData[{
 "so one can write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox["a", 
      RowBox[{"z", "-", "\[ImaginaryI]"}]], "+", 
     FractionBox["b", 
      RowBox[{"z", "+", "\[ImaginaryI]"}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"d16e33b3-0ba4-4e43-b89c-f990c911a53e"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "=", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox["\[ImaginaryI]", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"00ea352b-0f11-422e-89b0-d6d35aae23cb"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox["\[ImaginaryI]", "2"]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"18cb8b5f-9b1e-434f-9263-f52d6385019d"],
 ". The second term gives, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{"z", "-", "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9321f158-1d08-49e4-9665-eecec5dc5a0d"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    FractionBox["u", "2"], "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c2e1cbd3-38bf-4420-8719-f6ca6472e0fe"],
 ","
}], "SolutionAnswer",
 CellID->379447707,ExpressionUUID->"daf39949-6334-42c5-a947-3a3addbe6521"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"z", "+", "\[ImaginaryI]"}]], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"u", "+", 
       RowBox[{"2", "\[ImaginaryI]"}]}]], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[ImaginaryI]"}]], "\[CenterDot]", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         RowBox[{"u", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[ImaginaryI]"}], ")"}]}]}]]}], "=", 
      RowBox[{
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", "\[ImaginaryI]"}]], 
        RowBox[{
         UnderoverscriptBox["\[Sum]", 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
           RowBox[{"n", "=", "0"}]}], 
          RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", 
            FractionBox["u", 
             RowBox[{"2", "\[ImaginaryI]"}]]}], ")"}], "n"]}]}], "=", 
       RowBox[{
        RowBox[{
         FractionBox["1", 
          RowBox[{"2", "\[ImaginaryI]"}]], 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
            RowBox[{"n", "=", "0"}]}], 
           RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "n"], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "n"]}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"2", "\[ImaginaryI]"}], ")"}], "n"]]}]}], "=", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"2", "\[ImaginaryI]"}]], 
         RowBox[{
          UnderoverscriptBox["\[Sum]", 
           RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
            RowBox[{"n", "=", "0"}]}], 
           RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
          FractionBox[
           SuperscriptBox[
            RowBox[{
             SuperscriptBox["\[ImaginaryI]", "n"], "(", 
             RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "n"], 
           SuperscriptBox["2", "n"]]}]}]}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"13f61e38-4ec0-4e81-b460-025ef605943f"],
 "."
}], "SolutionAnswer",
 CellID->326825243,ExpressionUUID->"541e8ba2-7f6a-4c8f-bed9-3a206f99b50a"],

Cell[TextData[{
 "So the Laurent series is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "\[ImaginaryI]"}], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], "+", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], 
       RowBox[{"4", "\[ImaginaryI]"}]], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["\[ImaginaryI]", "2"], ")"}], "n"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "n"]}]}]}]}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "\[ImaginaryI]"}], 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}]}]], "+", 
     RowBox[{
      FractionBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], "4"], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", 
         RowBox[{"n", "=", "0"}]}], 
        RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["\[ImaginaryI]", "2"], ")"}], "n"], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "n"]}]}]}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "45830898-64dc-4b32-bd9e-3f66d24352e7"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"82828775-30f2-41d5-be0a-17ca36e7fe5e"],
 " is a simple pole of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"49d79575-ba48-48db-81ac-dfecd15dc1c2"],
 ". Check using ",
 ButtonBox["SeriesCoefficient",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->87269684,ExpressionUUID->"10d4192c-bbb9-420a-b316-120396c3702c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesCoefficient", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"z", "-", "1"}], 
     RowBox[{
      RowBox[{"z", "^", "2"}], "+", "1"}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "\[ImaginaryI]", ",", "n"}], "}"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"#", ",", 
     RowBox[{"n", "\[Element]", "Integers"}]}], "]"}], 
   "&"}]}]], "ExerciseInput",
 CellID->132872023,ExpressionUUID->"b503beb3-4e7d-484f-9688-ca91bd86e8a8"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\[Piecewise]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], "+", 
         FractionBox["\[ImaginaryI]", "2"]}], 
        RowBox[{"n", "\[Equal]", 
         RowBox[{"-", "1"}]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], ")"}], " ", 
         SuperscriptBox["\[ImaginaryI]", "n"], " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "2"}], "-", "n"}]]}], 
        RowBox[{"n", "\[GreaterEqual]", "0"}]},
       {"0", 
        TagBox["True",
         "PiecewiseDefault",
         AutoDelete->True]}
      },
      AllowedDimensions->{2, Automatic},
      Editable->True,
      GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.84]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}},
      Selectable->True]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.35]}, 
       Offset[0.27999999999999997`]}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}}],
  "Piecewise",
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True,
  Selectable->False,
  StripWrapperBoxes->True]], "ExerciseOutput",
 CellID->116194072,ExpressionUUID->"bd4dfbde-7679-415c-894c-a9d04fb38047"]
}, Open  ]],

Cell[TextData[{
 "You could have looked at the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", "\[ImaginaryI]"}], "|", " ", 
    RowBox[{">", "2"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0d84fe6b-5d58-4303-b901-435b1f08c8db"],
 " and obtained a different series convergent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cd39d20c-08aa-424e-81a7-c802e2fc89b8"],
 " in that region."
}], "SolutionAnswer",
 CellID->654604950,ExpressionUUID->"700c39d7-635d-4e0b-9114-a6ee89ecb674"]
}, Closed]],

Cell[TextData[{
 "Find the first three terms in the Laurent series of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"cos", " ", "z"}], 
     RowBox[{"z", "-", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e69ae4be-3cd6-4acb-9101-3a7736c8c7f7"],
 " around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "28e8325c-76e9-4210-a9a1-919d8f07ac45"],
 "."
}], "Exercise",
 CellID->214716841,ExpressionUUID->"703b1169-1696-4526-8328-8158c4c903d0"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"1707d4dc-e048-4794-9e6d-02461af28a62"],

Cell[TextData[{
 "The region of convergence is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "!=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1ccaf83c-9f69-4fa6-b002-72bcbcaa5a25"],
 ", because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f793e120-6f37-4ee5-9db3-5a397149d5ce"],
 " is analytic everywhere except there. Expanding the cosine at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "33cb5ce3-41c6-4e2c-a11c-e8a3a4310bdf"],
 ":"
}], "SolutionAnswer",
 CellID->107292186,ExpressionUUID->"beec11ac-7ee0-47fc-a098-c66af63c9a2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "3"}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->817901129,ExpressionUUID->"b7c57446-ba96-49ad-a234-8f9e20c851ba"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Cos", "[", "1", "]"}], "-", 
   RowBox[{
    RowBox[{"Sin", "[", "1", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"z", "-", "1"}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "1", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"Sin", "[", "1", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"z", "-", "1"}], "]"}], "4"],
    SeriesData[$CellContext`z, 1, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 1, {
    Cos[1], -Sin[1], Rational[-1, 2] Cos[1], Rational[1, 6] Sin[1]}, 0, 4, 1],
  
  Editable->False]], "ExerciseOutput",
 CellID->246175656,ExpressionUUID->"c966c64b-3aa7-4d47-9df3-911ce0658523"]
}, Open  ]],

Cell[TextData[{
 "Dividing this by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"z", "-", "1"}], ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6b24a754-6ab1-4656-8086-bd143cfff8b8"],
 ", one gets ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"cos", "(", "1", ")"}], 
     RowBox[{"z", "-", "1"}]], "-", 
    RowBox[{"sin", "(", "1", ")"}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"cos", "(", "1", ")"}], "2"], 
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{"sin", "(", "1", ")"}], "6"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], "2"]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"08a5e47b-5ae7-477b-ba30-f975c2059660"],
 "."
}], "SolutionAnswer",
 CellID->76134036,ExpressionUUID->"b8d6f6b5-3c78-47c9-a432-0582b9ddf36c"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->174948793,ExpressionUUID->"77bd9f55-9797-48d3-8896-c42068202bca"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"21. Laurent Series | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "20. Taylor Series"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
              ""}, FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "22. Holomorphic and Meromorphic Functions"}, 
        "PrettyTooltipTemplate"], "menu" -> TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"39d6fb37-9ba5-4677-80ea-82a80314d1a7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[641, 23, 221, 7, 108, "Section",ExpressionUUID->"134c92d4-955e-467f-aab0-d7f25d1e0736",
 CounterAssignments->{{"Section", 20}},
 CellID->286168533],
Cell[865, 32, 919, 25, 60, "Text",ExpressionUUID->"6ba93b03-781a-4cb3-83bf-aace51bae17f",
 CellID->365437108],
Cell[1787, 59, 688, 18, 83, "Text",ExpressionUUID->"0e68a71c-be55-4359-8616-52fad0af8081",
 CellID->516644382],
Cell[CellGroupData[{
Cell[2500, 81, 127, 1, 56, "Subsection",ExpressionUUID->"5ab3d377-a0d4-4860-bd0f-85aaaeb90c7d",
 CellID->101444006],
Cell[2630, 84, 483, 13, 64, "Text",ExpressionUUID->"0cf2c512-1080-4353-ae61-480fcbf8c1d6",
 CellID->9241870],
Cell[CellGroupData[{
Cell[3138, 101, 2354, 60, 50, "Input",ExpressionUUID->"5b761197-a90c-4c59-9905-132cf4266615",
 CellID->105897992],
Cell[5495, 163, 145817, 2484, 261, "Output",ExpressionUUID->"a730fada-a186-ed41-8074-476241947275",
 CellID->68386876]
}, Open  ]],
Cell[151327, 2650, 556, 14, 60, "Text",ExpressionUUID->"d15dcad2-606e-4eca-a949-ca8aaa575eef",
 CellID->135742012],
Cell[151886, 2666, 595, 15, 64, "Text",ExpressionUUID->"dca7b364-d4bc-472a-9d29-c2c7a742a3e9",
 CellID->302215307],
Cell[CellGroupData[{
Cell[152506, 2685, 336, 10, 50, "Input",ExpressionUUID->"1f5b8bd7-9b93-4a18-8620-6f3aad0174b2",
 CellID->351415378],
Cell[152845, 2697, 908, 31, 57, "Output",ExpressionUUID->"3e22c8ab-ecdd-46f5-a875-e87c7bcbc27c",
 CellID->211276620]
}, Open  ]],
Cell[153768, 2731, 198, 6, 36, "Text",ExpressionUUID->"307a877b-73a0-46a1-93ff-b11393a11183",
 CellID->6889236],
Cell[CellGroupData[{
Cell[153991, 2741, 347, 10, 50, "Input",ExpressionUUID->"f9f062bf-d136-48cf-b4ee-a205188e1e2a",
 CellID->768956826],
Cell[154341, 2753, 1557, 48, 83, "Output",ExpressionUUID->"c357d0d2-e018-4c58-aaf2-5f190130561d",
 CellID->316775577]
}, Open  ]],
Cell[155913, 2804, 1418, 42, 88, "Text",ExpressionUUID->"8fa38347-387d-462d-83b1-10e6eb0f2f86",
 CellID->726716848],
Cell[CellGroupData[{
Cell[157356, 2850, 3840, 106, 70, "Input",ExpressionUUID->"5a806ef7-f8e8-4eb3-95c9-e2da36e958cd",
 CellID->2112469082],
Cell[161199, 2958, 3763, 73, 366, "Output",ExpressionUUID->"6ebcf323-3ee8-4fb9-becb-307555d37033",
 CellID->1469261584]
}, {2}]],
Cell[164974, 3034, 1003, 25, 83, "Text",ExpressionUUID->"d2fd857e-1634-408e-b45c-7a29085bbde0",
 CellID->189250440],
Cell[165980, 3061, 1344, 38, 88, "Text",ExpressionUUID->"ba3746e2-e2a4-4008-b424-8d607421ab1d",
 CellID->7193441],
Cell[CellGroupData[{
Cell[167349, 3103, 3923, 109, 70, "Input",ExpressionUUID->"a30e78c8-9b8e-4855-aa0c-bdd2f0c64f7f",
 CellID->709961825],
Cell[171275, 3214, 3725, 71, 392, "Output",ExpressionUUID->"091a7e34-8892-49d7-b994-51ba0414c236",
 CellID->909250043]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175046, 3291, 125, 1, 56, "Subsection",ExpressionUUID->"c0d790f8-e860-4b15-9794-a063ac58509e",
 CellID->358614869],
Cell[175174, 3294, 337, 10, 36, "Text",ExpressionUUID->"b3239a49-4586-40fc-984e-9b924b9ebcc8",
 CellID->87104407],
Cell[175514, 3306, 374, 11, 56, "DisplayFormulaNumbered",ExpressionUUID->"10c7fe7f-e0ae-4d54-b583-662617214eb1",
 CellID->606748749],
Cell[175891, 3319, 549, 15, 60, "Text",ExpressionUUID->"21db90ec-df37-4924-b6d0-ee248db02239",
 CellID->487470388],
Cell[176443, 3336, 107, 1, 36, "Text",ExpressionUUID->"eb290171-5ebb-409f-875e-9e7759d1f938",
 CellID->475437289],
Cell[176553, 3339, 394, 12, 56, "DisplayFormulaNumbered",ExpressionUUID->"d654e8f0-a8fa-4f1f-b2fc-ab7f0d9440c2",
 CellID->138844020],
Cell[176950, 3353, 646, 19, 60, "Text",ExpressionUUID->"e44aa3c1-d7a7-4367-9862-9c5171057ef3",
 CellID->527211048],
Cell[177599, 3374, 312, 8, 36, "Text",ExpressionUUID->"0aabd2db-5a7e-43ca-8a2d-b638df8f6d3d",
 CellID->307648107],
Cell[177914, 3384, 743, 24, 56, "DisplayFormulaNumbered",ExpressionUUID->"5a156ffb-cdab-41c4-b36b-f80d959d2642",
 CellID->359228655],
Cell[178660, 3410, 381, 12, 36, "Text",ExpressionUUID->"4972247e-be1f-4186-8e8b-be807107808c",
 CellID->8107276],
Cell[179044, 3424, 685, 18, 60, "Text",ExpressionUUID->"34aa8421-2cf6-482d-9796-f7c5e7d1863a",
 CellID->509658578]
}, Open  ]],
Cell[CellGroupData[{
Cell[179766, 3447, 131, 1, 56, "Subsection",ExpressionUUID->"7f663731-415e-4d21-88de-7be6d2867aba",
 CellID->143748847],
Cell[179900, 3450, 646, 20, 36, "Text",ExpressionUUID->"11c1effd-50d1-a444-9d73-ce992a3b0d49",
 CellID->193227388],
Cell[180549, 3472, 342, 10, 36, "Text",ExpressionUUID->"69596119-bed4-44f1-83f1-65da6f964e8e",
 CellID->229254798],
Cell[180894, 3484, 980, 33, 56, "DisplayFormulaNumbered",ExpressionUUID->"78ccf9b5-c580-4cb9-8f33-7827f9877df4",
 CellID->853239591],
Cell[181877, 3519, 96, 1, 36, "Text",ExpressionUUID->"ecc370d3-d9f9-4e2b-a06c-0f5d065ea119",
 CellID->146790184],
Cell[181976, 3522, 1211, 36, 94, "DisplayFormulaNumbered",ExpressionUUID->"cf9a8106-60a2-4b2e-9744-0655a0831340",
 CellID->314956168],
Cell[183190, 3560, 268, 7, 36, "Text",ExpressionUUID->"03daaff8-96ba-44b5-9585-14c7135247f6",
 CellID->32321037],
Cell[183461, 3569, 973, 31, 36, "Text",ExpressionUUID->"fd4a39f1-c9d8-465d-99f3-d373979c50d5",
 CellID->437311631],
Cell[184437, 3602, 224, 6, 36, "Text",ExpressionUUID->"08df6f9b-b4eb-491f-8667-ef434c20e08b",
 CellID->839393474],
Cell[184664, 3610, 4695, 112, 244, "Output",ExpressionUUID->"bb04f898-ddae-4dae-b061-a1e564c0502d",
 CellID->38726709],
Cell[189362, 3724, 1044, 28, 60, "Text",ExpressionUUID->"e585b948-70ec-4e7a-afdf-ad364d08824c",
 CellID->17733229],
Cell[190409, 3754, 1590, 50, 50, "DisplayFormulaNumbered",ExpressionUUID->"23b90b00-fb19-40f4-9260-65cd278c90b8",
 CellID->47307797],
Cell[192002, 3806, 843, 24, 60, "Text",ExpressionUUID->"7b6d5412-31d9-4bdc-a277-b4d4fe6a0b28",
 CellID->441854],
Cell[192848, 3832, 269, 8, 36, "Text",ExpressionUUID->"275cc035-0a07-4d91-982a-a54620ee415b",
 CellID->721465742],
Cell[193120, 3842, 1222, 39, 57, "DisplayFormulaNumbered",ExpressionUUID->"4080bd97-3396-4499-86b3-1e1ebbe8e587",
 CellID->510462927],
Cell[194345, 3883, 655, 19, 65, "Text",ExpressionUUID->"7854b733-88b4-43f8-b68e-68a1b0cc4cf7",
 CellID->249260538],
Cell[195003, 3904, 1968, 60, 75, "Text",ExpressionUUID->"998fe661-a5a9-4cd7-88d0-2c9972ca8f39",
 CellID->224171107],
Cell[196974, 3966, 1020, 31, 60, "Text",ExpressionUUID->"4c6c0e3f-5255-4495-b527-ee4b82d89cf7",
 CellID->236992810],
Cell[197997, 3999, 3961, 128, 309, "DisplayFormulaNumbered",ExpressionUUID->"1c298498-245d-4366-ba37-39010eba18ef",
 CellID->436346381],
Cell[201961, 4129, 289, 8, 36, "Text",ExpressionUUID->"25decfc5-fb9f-40ff-9aeb-c16d9bb05aad",
 CellID->30931438],
Cell[202253, 4139, 743, 20, 60, "Text",ExpressionUUID->"7f6ec3fe-d451-45c4-a06d-8e75bcab9b30",
 CellID->152488228],
Cell[CellGroupData[{
Cell[203021, 4163, 110, 1, 54, "Subsubsection",ExpressionUUID->"30cf209b-7221-4585-962f-b06f48cc5df0",
 CellID->345489541],
Cell[203134, 4166, 901, 22, 83, "Text",ExpressionUUID->"41f58089-57cc-4440-bedf-b02c6500841b",
 CellID->294799543],
Cell[204038, 4190, 332, 10, 60, "Text",ExpressionUUID->"2a611286-aabd-4e4f-81a4-320e384aba57",
 CellID->110566896]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[204419, 4206, 105, 1, 56, "Subsection",ExpressionUUID->"55cf1365-e4c1-4876-9089-b3f746d8b69f",
 CellID->546980493],
Cell[204527, 4209, 185, 8, 71, "SolvedExample",ExpressionUUID->"72a200e3-5bbf-4de0-9f4e-652a7ff8c841",
 CellID->9992938],
Cell[204715, 4219, 848, 26, 43, "SolvedExampleNote",ExpressionUUID->"6bcf04b0-8add-4323-a494-9e1ef9c194d7",
 CellID->91653603],
Cell[205566, 4247, 210, 6, 39, "SolvedExampleNote",ExpressionUUID->"524c3e33-b32c-4e1f-97fc-cbc5ed81351b",
 CellID->274904569],
Cell[CellGroupData[{
Cell[205801, 4257, 349, 10, 50, "SolvedExampleInput",ExpressionUUID->"7c772c18-1c46-46da-ab93-27cbb0f107a1",
 CellID->609354532],
Cell[206153, 4269, 728, 21, 54, "SolvedExampleOutput",ExpressionUUID->"9fbbd041-4ad3-4cb2-a5a9-a33716b87df8",
 CellID->221386080]
}, Open  ]],
Cell[206896, 4293, 148, 1, 39, "SolvedExampleNote",ExpressionUUID->"e4b9cb62-085f-4902-8e48-5d396ef7d932",
 CellID->299814989],
Cell[CellGroupData[{
Cell[207069, 4298, 360, 10, 50, "SolvedExampleInput",ExpressionUUID->"92fd85bd-9570-4dae-a5da-8e52eee75adf",
 CellID->109506769],
Cell[207432, 4310, 1423, 43, 74, "SolvedExampleOutput",ExpressionUUID->"4457d7af-58b0-41f6-accf-64d7da934771",
 CellID->766915141]
}, Open  ]],
Cell[208870, 4356, 1343, 40, 66, "SolvedExampleNote",ExpressionUUID->"602f52f8-fc6c-4e17-b043-8a0ea7ac2941",
 CellID->267605618],
Cell[210216, 4398, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"9224409b-1a8e-4afa-aed5-139fdb7111fc",
 CellID->943814759],
Cell[210325, 4401, 187, 8, 71, "SolvedExample",ExpressionUUID->"784d1951-d132-42b4-b71a-00e630aa61e9",
 CellID->364784924],
Cell[210515, 4411, 655, 19, 44, "SolvedExampleNote",ExpressionUUID->"faf7e038-105f-4593-88fb-8c08c5681ee5",
 CellID->69398209],
Cell[211173, 4432, 328, 9, 39, "SolvedExampleNote",ExpressionUUID->"33995056-6902-4b27-9541-c8cc88e4e2d0",
 CellID->366230533],
Cell[211504, 4443, 2202, 64, 45, "SolvedExampleNote",ExpressionUUID->"dfc345fe-76e3-44a8-94e9-b0937dd7c770",
 CellID->604614456],
Cell[213709, 4509, 178, 6, 39, "SolvedExampleNote",ExpressionUUID->"cc33bd03-a65b-4b44-bc93-7886102a9055",
 CellID->34624335],
Cell[CellGroupData[{
Cell[213912, 4519, 363, 10, 25, "SolvedExampleInput",ExpressionUUID->"716a5818-0a2f-4128-a16f-fe0be747104c",
 CellID->362163057],
Cell[214278, 4531, 1537, 44, 103, "SolvedExampleOutput",ExpressionUUID->"4f0cc5bb-9bef-421e-b8ae-f7069806d631",
 CellID->387902704]
}, Open  ]],
Cell[215830, 4578, 183, 6, 39, "SolvedExampleNote",ExpressionUUID->"f0945f9c-e44d-417d-9ba1-551b78825a8a",
 CellID->933842692],
Cell[CellGroupData[{
Cell[216038, 4588, 374, 10, 25, "SolvedExampleInput",ExpressionUUID->"f44cccdf-3c69-4935-bdf8-fd50766a5769",
 CellID->416003697],
Cell[216415, 4600, 1449, 43, 61, "SolvedExampleOutput",ExpressionUUID->"e7920add-8d7c-469d-8f54-608c0ee78951",
 CellID->389521419]
}, Open  ]],
Cell[217879, 4646, 896, 27, 61, "SolvedExampleNote",ExpressionUUID->"2f14a990-d105-4b9f-9680-bbc8ecc3f192",
 CellID->383108805],
Cell[218778, 4675, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"bec9998a-311f-43cb-8603-3d9cb7f4ec8a",
 CellID->1417454744],
Cell[218888, 4678, 186, 8, 71, "SolvedExample",ExpressionUUID->"4ba96a41-f3fa-4921-b75d-2542c85d8a38",
 CellID->40033488],
Cell[219077, 4688, 926, 29, 67, "SolvedExampleNote",ExpressionUUID->"27a9f7a4-be8d-4e52-9976-0e979cc2f28c",
 CellID->51632585],
Cell[220006, 4719, 585, 16, 61, "SolvedExampleNote",ExpressionUUID->"ca64e538-ec76-40c9-b3ce-f5529e7535d2",
 CellID->81190014],
Cell[220594, 4737, 2130, 66, 75, "SolvedExampleNote",ExpressionUUID->"3d48d98a-bb8b-49bb-9735-2c53c410f153",
 CellID->218544171],
Cell[222727, 4805, 178, 6, 39, "SolvedExampleNote",ExpressionUUID->"a4cdc62a-1f66-4e44-b8b3-8abf160629d9",
 CellID->87624700],
Cell[CellGroupData[{
Cell[222930, 4815, 403, 12, 53, "SolvedExampleInput",ExpressionUUID->"ec42cf42-1d9e-4e0a-a842-f1b509d126cd",
 CellID->163526257],
Cell[223336, 4829, 873, 27, 54, "SolvedExampleOutput",ExpressionUUID->"f052a512-0b83-4d2f-b8fa-a1895bdfadfe",
 CellID->39507825]
}, Open  ]],
Cell[CellGroupData[{
Cell[224246, 4861, 412, 12, 53, "SolvedExampleInput",ExpressionUUID->"4259183c-8e6b-4b31-a59a-1e94286d6ff4",
 CellID->1755147],
Cell[224661, 4875, 1474, 45, 74, "SolvedExampleOutput",ExpressionUUID->"6e81d049-41d1-4456-97c9-0080e3347386",
 CellID->856512528]
}, Open  ]],
Cell[226150, 4923, 307, 8, 39, "SolvedExampleNote",ExpressionUUID->"15e5187b-dc88-4357-85bd-d96e41ec4583",
 CellID->359790643],
Cell[CellGroupData[{
Cell[226482, 4935, 1476, 38, 53, "SolvedExampleInput",ExpressionUUID->"27e8bc4c-2e7e-42b6-af5c-f3d17ae8b9f6",
 CellID->160458930],
Cell[227961, 4975, 149257, 2539, 360, "SolvedExampleOutput",ExpressionUUID->"229df542-26fe-480a-8fae-0e387e368fc1",
 CellID->393367227]
}, Open  ]],
Cell[377233, 7517, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"16ef9d40-eab4-4286-9bd9-0fee5d858882",
 CellID->938485369],
Cell[377342, 7520, 187, 8, 71, "SolvedExample",ExpressionUUID->"94cd3f11-7624-4203-a335-1cc90d90e640",
 CellID->724465672],
Cell[377532, 7530, 553, 16, 39, "SolvedExampleNote",ExpressionUUID->"ff8585de-175e-432e-9379-55a1ed1b5677",
 CellID->925486181],
Cell[378088, 7548, 1091, 33, 42, "SolvedExampleNote",ExpressionUUID->"744abc76-7c95-457b-9876-085e33c2ae2c",
 CellID->99854143],
Cell[379182, 7583, 578, 16, 61, "SolvedExampleNote",ExpressionUUID->"dd1ab501-811b-4b7b-a5e5-aec2fae38937",
 CellID->89793167],
Cell[379763, 7601, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"b94479f4-22e4-48b8-87b9-d7039349ac18",
 CellID->748840892],
Cell[379872, 7604, 253, 4, 60, "Text",ExpressionUUID->"deaca428-8bff-4d72-ad9e-a203b5568a49",
 CellID->230431203],
Cell[380128, 7610, 187, 8, 71, "SolvedExample",ExpressionUUID->"3cefc2af-b2b4-4c7d-b5a2-6a513ba7b821",
 CellID->599151269],
Cell[380318, 7620, 570, 17, 43, "SolvedExampleNote",ExpressionUUID->"0ff60c64-1a75-4a1b-82a3-78120f9eba28",
 CellID->83607975],
Cell[380891, 7639, 337, 9, 39, "SolvedExampleNote",ExpressionUUID->"be2483c2-2557-4f9e-abf2-bf6725238fda",
 CellID->276087372],
Cell[381231, 7650, 312, 8, 39, "SolvedExampleNote",ExpressionUUID->"c3241381-abf1-4236-91ae-423af1b28e19",
 CellID->222567898],
Cell[381546, 7660, 326, 8, 39, "SolvedExampleNote",ExpressionUUID->"1777b565-752e-4fb2-b6fb-da055f6f4397",
 CellID->138804032],
Cell[CellGroupData[{
Cell[381897, 7672, 267, 8, 50, "SolvedExampleInput",ExpressionUUID->"a290fbea-55da-4ee8-bbe7-4524b2ee8b31",
 CellID->131682427],
Cell[382167, 7682, 201, 5, 54, "SolvedExampleOutput",ExpressionUUID->"a6e2b543-8ef5-429b-87e0-92826d946158",
 CellID->267125]
}, Open  ]],
Cell[382383, 7690, 553, 16, 39, "SolvedExampleNote",ExpressionUUID->"de17e6aa-b38e-4e83-a965-71f1745b4d95",
 CellID->780712],
Cell[382939, 7708, 633, 19, 43, "SolvedExampleNote",ExpressionUUID->"df064f1c-c51c-4d44-bea2-bcc602c819fa",
 CellID->564609518],
Cell[383575, 7729, 637, 19, 43, "SolvedExampleNote",ExpressionUUID->"9f4f4fd5-aa7a-437a-b506-d13e853e2753",
 CellID->411107617],
Cell[384215, 7750, 391, 10, 39, "SolvedExampleNote",ExpressionUUID->"3e6509e5-32ae-4c93-8b93-c653124306c4",
 CellID->236068090],
Cell[384609, 7762, 1981, 61, 43, "SolvedExampleNote",ExpressionUUID->"4161cbe7-0329-4274-a89a-c8e0907bd8a8",
 CellID->185966202],
Cell[386593, 7825, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"6d31852e-a2c7-4686-8cdf-0da4aeb15109",
 CellID->442185890],
Cell[CellGroupData[{
Cell[386724, 7830, 109, 1, 69, "SummarySection",ExpressionUUID->"fee9bdc1-952b-4cd7-8709-697ca02741e0",
 CellID->1198545324],
Cell[386836, 7833, 1543, 46, 35, "SummaryList",ExpressionUUID->"3d96e5ed-54f2-40a3-bcb4-99c23129860e",
 CellID->15385668],
Cell[388382, 7881, 449, 13, 29, "SummaryList",ExpressionUUID->"b490bfa4-8b8c-43f3-bd56-c063cb8cb70a",
 CellID->668453209],
Cell[388834, 7896, 1113, 35, 94, "DisplayFormula",ExpressionUUID->"5b5e1dec-81d8-4b09-a275-ba38884e27c0",
 CellID->494071528],
Cell[389950, 7933, 166, 3, 29, "SummaryList",ExpressionUUID->"0e68848e-22c1-4509-95dc-aa17b5d8b4f5",
 CellID->60311985]
}, Open  ]],
Cell[CellGroupData[{
Cell[390153, 7941, 160, 3, 65, "ExerciseSection",ExpressionUUID->"2745cb69-262c-4876-885f-d23e17b22750",
 CellID->782520772],
Cell[390316, 7946, 898, 28, 35, "Exercise",ExpressionUUID->"ef8ea695-40f7-46fd-8de1-92086c76d126",
 CellID->135800712],
Cell[CellGroupData[{
Cell[391239, 7978, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"cba7ec46-85a8-4270-a349-803f20385574"],
Cell[391333, 7980, 1002, 31, 49, "SolutionAnswer",ExpressionUUID->"4461b511-a38b-4e90-a6b6-9216d1cefa89",
 CellID->65071408],
Cell[CellGroupData[{
Cell[392360, 8015, 335, 10, 25, "ExerciseInput",ExpressionUUID->"8a5748a9-0d8a-4c1c-baab-a8d2548a17ee",
 CellID->11342027],
Cell[392698, 8027, 296, 9, 46, "ExerciseOutput",ExpressionUUID->"9e4b717c-ed47-4cb9-96f9-0b7fd349d1f0",
 CellID->109197952]
}, Open  ]],
Cell[393009, 8039, 608, 17, 22, "SolutionAnswer",ExpressionUUID->"6013b4b2-82a3-49e6-81b0-39b67167857b",
 CellID->4315527],
Cell[393620, 8058, 1586, 47, 28, "SolutionAnswer",ExpressionUUID->"52fd23da-dcdd-486f-a09e-9a7f584adeab",
 CellID->64019269],
Cell[395209, 8107, 196, 6, 22, "SolutionAnswer",ExpressionUUID->"c036818b-4a1d-4b44-be33-7825de502c4b",
 CellID->340503088],
Cell[CellGroupData[{
Cell[395430, 8117, 394, 12, 49, "ExerciseInput",ExpressionUUID->"f266b271-5c20-46d6-8b10-c774bc9d03f3",
 CellID->532998498],
Cell[395827, 8131, 904, 28, 48, "ExerciseOutput",ExpressionUUID->"04dbc3cd-74a7-43d6-81ac-98b5ef677af9",
 CellID->197549002]
}, Open  ]]
}, Closed]],
Cell[396758, 8163, 872, 27, 31, "Exercise",ExpressionUUID->"b8ff43af-ede4-4dbc-a588-6c442e2475b5",
 CellID->92568638],
Cell[CellGroupData[{
Cell[397655, 8194, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"7f8af07f-c7e2-4995-8297-05a1f8c35d21"],
Cell[397749, 8196, 1364, 42, 49, "SolutionAnswer",ExpressionUUID->"b1f44030-6102-416c-9c5a-2446c5b0e0ec",
 CellID->718781157],
Cell[399116, 8240, 1896, 57, 47, "SolutionAnswer",ExpressionUUID->"8284dd32-3d0d-4b99-a663-1b46f98d608c",
 CellID->120185466],
Cell[CellGroupData[{
Cell[401037, 8301, 436, 14, 25, "ExerciseInput",ExpressionUUID->"99c20cbf-93cc-42d4-b3eb-15bbd9cc188f",
 CellID->287508375],
Cell[401476, 8317, 779, 25, 45, "ExerciseOutput",ExpressionUUID->"9e656548-d161-42ab-b080-f0368691c1e0",
 CellID->104744239]
}, Open  ]],
Cell[402270, 8345, 196, 6, 22, "SolutionAnswer",ExpressionUUID->"28f587e4-ccf8-414c-930e-da8420982191",
 CellID->604079597],
Cell[CellGroupData[{
Cell[402491, 8355, 447, 14, 25, "ExerciseInput",ExpressionUUID->"4dd678ea-db20-475c-bc50-0d45ab7d464b",
 CellID->217034993],
Cell[402941, 8371, 1355, 41, 63, "ExerciseOutput",ExpressionUUID->"e97464a7-ccbd-468d-ba35-bc4adbd3d1bb",
 CellID->864844703]
}, Open  ]],
Cell[404311, 8415, 850, 25, 28, "SolutionAnswer",ExpressionUUID->"7054988d-c0e6-4709-87c7-8502cf23691f",
 CellID->451442672]
}, Closed]],
Cell[405176, 8443, 604, 17, 29, "Exercise",ExpressionUUID->"5d9ee143-634c-43f4-bbe1-008e24300da2",
 CellID->205318444],
Cell[CellGroupData[{
Cell[405805, 8464, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"ab58d1f6-f077-44a9-8cb4-976880f8dcf3"],
Cell[405899, 8466, 1616, 49, 57, "SolutionAnswer",ExpressionUUID->"a3ad6310-a4d3-43fa-90ae-16020d1f6502",
 CellID->72246331],
Cell[407518, 8517, 1571, 47, 32, "SolutionAnswer",ExpressionUUID->"1ebaf2a3-43f8-42f6-9979-5fd7100668ca",
 CellID->812006206],
Cell[409092, 8566, 190, 6, 22, "SolutionAnswer",ExpressionUUID->"0e492485-20ee-470c-969e-8cdf704396e8",
 CellID->371577429],
Cell[CellGroupData[{
Cell[409307, 8576, 541, 17, 25, "ExerciseInput",ExpressionUUID->"6818864a-09a7-4876-a615-be29282bf849",
 CellID->278434478],
Cell[409851, 8595, 1596, 48, 62, "ExerciseOutput",ExpressionUUID->"e3e4ae00-c1d6-4b00-a261-d6590612b0e1",
 CellID->97860824]
}, Open  ]],
Cell[411462, 8646, 147, 1, 22, "SolutionAnswer",ExpressionUUID->"7b35652b-01d3-4c74-a362-1176bc1fd2b0",
 CellID->2556837],
Cell[CellGroupData[{
Cell[411634, 8651, 548, 18, 43, "ExerciseInput",ExpressionUUID->"48c0a764-ad19-47af-9063-2ce1be002748",
 CellID->12214958],
Cell[412185, 8671, 113, 1, 28, "ExerciseOutput",ExpressionUUID->"7e20cb1d-f07f-4600-b999-47bfb27856de",
 CellID->41338547]
}, Open  ]]
}, Closed]],
Cell[412325, 8676, 639, 18, 29, "Exercise",ExpressionUUID->"63ed1564-1156-46e2-80c8-82cb40899d67",
 CellID->14616899],
Cell[CellGroupData[{
Cell[412989, 8698, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"eb943c65-0af5-4790-a72d-9c0ad6e776ab"],
Cell[413083, 8700, 798, 21, 43, "SolutionAnswer",ExpressionUUID->"5a3b9399-4668-4cb6-b7f1-f015c4ec10a3",
 CellID->26342513],
Cell[CellGroupData[{
Cell[413906, 8725, 401, 12, 48, "ExerciseInput",ExpressionUUID->"78ef1896-b600-4ba9-a627-4f8856359ff3",
 CellID->326088766],
Cell[414310, 8739, 430, 13, 52, "ExerciseOutput",ExpressionUUID->"70f5ed5c-6d0b-4d46-8f28-0aa938aefb6d",
 CellID->35510218]
}, Open  ]],
Cell[414755, 8755, 1368, 43, 26, "SolutionAnswer",ExpressionUUID->"daf39949-6334-42c5-a947-3a3addbe6521",
 CellID->379447707],
Cell[416126, 8800, 2486, 70, 29, "SolutionAnswer",ExpressionUUID->"541e8ba2-7f6a-4c8f-bed9-3a206f99b50a",
 CellID->326825243],
Cell[418615, 8872, 2222, 67, 48, "SolutionAnswer",ExpressionUUID->"10d4192c-bbb9-420a-b316-120396c3702c",
 CellID->87269684],
Cell[CellGroupData[{
Cell[420862, 8943, 501, 15, 45, "ExerciseInput",ExpressionUUID->"b503beb3-4e7d-484f-9688-ca91bd86e8a8",
 CellID->132872023],
Cell[421366, 8960, 1738, 52, 73, "ExerciseOutput",ExpressionUUID->"bd4dfbde-7679-415c-894c-a9d04fb38047",
 CellID->116194072]
}, Open  ]],
Cell[423119, 9015, 589, 15, 43, "SolutionAnswer",ExpressionUUID->"700c39d7-635d-4e0b-9114-a6ee89ecb674",
 CellID->654604950]
}, Closed]],
Cell[423723, 9033, 593, 17, 29, "Exercise",ExpressionUUID->"703b1169-1696-4526-8328-8158c4c903d0",
 CellID->214716841],
Cell[CellGroupData[{
Cell[424341, 9054, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"1707d4dc-e048-4794-9e6d-02461af28a62"],
Cell[424435, 9056, 677, 18, 43, "SolutionAnswer",ExpressionUUID->"beec11ac-7ee0-47fc-a098-c66af63c9a2c",
 CellID->107292186],
Cell[CellGroupData[{
Cell[425137, 9078, 255, 6, 25, "ExerciseInput",ExpressionUUID->"b7c57446-ba96-49ad-a234-8f9e20c851ba",
 CellID->817901129],
Cell[425395, 9086, 970, 30, 45, "ExerciseOutput",ExpressionUUID->"c966c64b-3aa7-4d47-9df3-911ce0658523",
 CellID->246175656]
}, Open  ]],
Cell[426380, 9119, 896, 29, 26, "SolutionAnswer",ExpressionUUID->"b8d6f6b5-3c78-47c9-a432-0582b9ddf36c",
 CellID->76134036]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[427327, 9154, 309, 6, 135, "SmallText",ExpressionUUID->"77bd9f55-9797-48d3-8896-c42068202bca",
 CellGroupingRules->"SectionGrouping",
 CellID->174948793]
}
]
*)

(* NotebookSignature kSGHWYVj7Pup5lu2KaRUXwa7 *)
