(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    840815,      16660]
NotebookOptionsPosition[    658400,      12905]
NotebookOutlinePosition[    821152,      16286]
CellTagsIndexPosition[    821109,      16283]
WindowTitle->24. The Residue Theorem | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "The Residue Theorem"
}], "Section",
 CounterAssignments->{{"Section", 23}},
 CellID->319933565,ExpressionUUID->"65b2b7df-0901-482f-8111-bdbcb21d1119"],

Cell["\<\
This chapter is about Cauchy\[CloseCurlyQuote]s residue theorem, which often \
provides the easiest method to compute a contour integral.\
\>", "Text",
 CellID->707889707,ExpressionUUID->"6a454277-cf5b-41ea-9f72-407a269c6c98"],

Cell[CellGroupData[{

Cell["Cauchy\[CloseCurlyQuote]s Residue Theorem", "Subsection",
 CellID->285552759,ExpressionUUID->"cc25c9e9-026e-4922-8b11-1470c4088dff"],

Cell["\<\
The residue theorem describes how to calculate a contour integral over a \
closed curve enclosing some isolated singularities.\
\>", "Text",
 CellID->653667584,ExpressionUUID->"47b2c3f3-66e7-4598-ada8-802c0917c9c7"],

Cell[TextData[{
 "Remember that by the second definition of residue (seen in ",
 ButtonBox["Chapter 22",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{
    "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "), the residue of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"645b8109-3f94-4990-a6d8-8bfbbe1ecf84"],
 " at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7e2c1074-e9ff-4869-b793-795a4b8ac272"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"8a60c9eb-a517-404c-a704-e21845532a82"],
 " times the integral over a small circle enclosing ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c275fae4-bbd4-4631-b7a8-70e460389a54"],
 "."
}], "Text",
 CellID->38253147,ExpressionUUID->"2cb55b8d-25c1-4d4d-80a3-b1fb7e031b1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pts", ",", "pts2", ",", "si", ",", "ip"}], "}"}], ",", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"8", ",", "6.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7.4", ",", "7.4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"6", ",", "7.8"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "7.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "6.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.8", ",", "4.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.6", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.7", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.4", ",", "1.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "0.9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "0.9"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"7", ",", "2.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "4.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"8.2", ",", "5.6"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"pts2", "=", 
      RowBox[{"pts", "~", "Join", "~", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"8", ",", "6.6"}], "}"}], "}"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"si", "=", 
      RowBox[{
       RowBox[{"Accumulate", "[", 
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", "0", "}"}], "}"}], ",", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Sqrt", "[", 
              RowBox[{"#", ".", "#"}], "]"}], "&"}], ",", 
            RowBox[{
             RowBox[{"Rest", "[", "pts2", "]"}], "-", 
             RowBox[{"Most", "[", "pts2", "]"}]}]}], "]"}]}], "]"}], "]"}], "//",
        "Flatten"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ip", "=", 
      RowBox[{"Interpolation", "[", 
       RowBox[{
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"#1", ",", "#2"}], "}"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"si", ",", "pts2"}], "}"}]}], "]"}], ",", 
        RowBox[{"Method", "->", "\"\<Spline\>\""}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ParametricPlot", "[", 
         RowBox[{
          RowBox[{"ip", "[", "s", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "0", ",", 
            RowBox[{"Max", "[", "si", "]"}]}], "}"}], ",", 
          RowBox[{"Axes", "->", "False"}], ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"Thickness", "[", "0.01", "]"}]}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "11"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"Epilog", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ip", "[", "0", "]"}], ",", 
                  RowBox[{"ip", "[", "0.1", "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[\"C\", \
TraditionalForm]],ExpressionUUID->\"421a84aa-7852-4f05-8e2c-ec880ccdc811\"]],\
ExpressionUUID->\"819cbbb0-0a3c-4b58-886d-44bfcef1487f\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"8.5", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"2.6", ",", "3.2"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"z\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"aeb92bb1-45b0-495e-9baa-75a0b9ea12bc\"]],\
ExpressionUUID->\"a30f3e91-cfee-4fdc-83ac-bbf9490db6d3\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"2.6", ",", "3.2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"6.5", ",", "5.5"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"z\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"839e24a5-7d99-454c-8ff7-aaaed7e44d87\"]],\
ExpressionUUID->\"ec04a522-158a-498b-9645-9ad0e607f537\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"6.5", ",", "5.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "260"}]}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"ParametricPlot", "[", 
           RowBox[{
            RowBox[{"ip", "[", "s", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"s", ",", "0", ",", "10.2"}], "}"}], ",", 
            RowBox[{"Axes", "->", "False"}], ",", 
            RowBox[{"PlotStyle", "->", 
             RowBox[{"Thickness", "[", "0.01", "]"}]}], ",", 
            RowBox[{"PlotRange", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "11"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "8"}], "}"}]}], "}"}]}]}], "]"}], ",", 
          RowBox[{"ParametricPlot", "[", 
           RowBox[{
            RowBox[{"ip", "[", "s", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"s", ",", "10.45", ",", "21.75"}], "}"}], ",", 
            RowBox[{"Axes", "->", "False"}], ",", 
            RowBox[{"PlotStyle", "->", 
             RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}], ",", 
          RowBox[{"ParametricPlot", "[", 
           RowBox[{
            RowBox[{"ip", "[", "s", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"s", ",", "22.0", ",", 
              RowBox[{"Max", "[", "si", "]"}]}], "}"}], ",", 
            RowBox[{"Axes", "->", "False"}], ",", 
            RowBox[{"PlotStyle", "->", 
             RowBox[{"Thickness", "[", "0.01", "]"}]}]}], "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.08", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ip", "[", "0", "]"}], ",", 
                  RowBox[{"ip", "[", "0.1", "]"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"C\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"37360d90-92a9-4ed2-9d95-bbdbf3d220b6\"]],\
ExpressionUUID->\"6eb2003c-38d3-4c68-a18d-d7dd380a503c\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"8.5", ",", "7"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"2.6", ",", "3.2"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"z\", \"1\"], \
TraditionalForm]],ExpressionUUID->\"fe4899e2-779d-45bd-a036-a63dfb7b6d4a\"]],\
ExpressionUUID->\"b8a93f78-07e4-4efc-a418-33eebc4a493f\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"2.6", ",", "3.2"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Red", ",", 
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"6.5", ",", "5.5"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"\"\<\!\(\*Cell[TextData[Cell[BoxData[FormBox[
SubscriptBox[\"z\", \"2\"], \
TraditionalForm]],ExpressionUUID->\"0836e9b5-db41-45dd-955e-0ab8a0c5ddba\"]],\
ExpressionUUID->\"99563052-d20c-414b-81f5-db37ffde8939\"]\)\>\"", ",", "14"}],
                 "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"6.5", ",", "5.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"2.6", ",", "3.2"}], "}"}], ",", 
                 RowBox[{"2", "/", "3"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0", ",", 
                   RowBox[{"\[Pi]", "-", "0.2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"2.6", ",", "3.2"}], "}"}], ",", 
                 RowBox[{"2", "/", "3"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"\[Pi]", "+", "0.2"}], ",", 
                   RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.05", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2.6", ",", "3.2"}], "}"}], "+", 
                   RowBox[{
                    RowBox[{"2", "/", "3"}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "1.6", "]"}], ",", 
                    RowBox[{"Sin", "[", "1.6", "]"}]}], "}"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2.6", ",", "3.2"}], "}"}], "+", 
                   RowBox[{
                    RowBox[{"2", "/", "3"}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "1", "]"}], ",", 
                    RowBox[{"Sin", "[", "1", "]"}]}], "}"}]}]}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"6.5", ",", "5.5"}], "}"}], ",", 
                 RowBox[{"2", "/", "3"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"0.2", ",", 
                   RowBox[{
                    RowBox[{"2", "\[Pi]"}], "-", "0.2"}]}], "}"}]}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.06", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"6.5", ",", "5.5"}], "}"}], "+", 
                   RowBox[{
                    RowBox[{"2", "/", "3"}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "1.6", "]"}], ",", 
                    RowBox[{"Sin", "[", "1.6", "]"}]}], "}"}]}]}], ",", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"6.5", ",", "5.5"}], "}"}], "+", 
                   RowBox[{
                    RowBox[{"2", "/", "3"}], 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "1", "]"}], ",", 
                    RowBox[{"Sin", "[", "1", "]"}]}], "}"}]}]}]}], "}"}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  RowBox[{"-", "0.05"}], ",", "0", ",", "0", ",", "0"}], 
                 "}"}], "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"6.5", "+", 
                    RowBox[{"2", "/", "3"}]}], ",", "5.4"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"6.5", "+", "1.7"}], ",", "5.4"}], "}"}]}], "}"}],
                  "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "0.05", ",", "0"}], "}"}], "]"}],
                ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"6.5", "+", 
                    RowBox[{"2", "/", "3"}]}], ",", "5.6"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"6.5", "+", "1.7"}], ",", "5.6"}], "}"}]}], "}"}],
                  "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", 
                  RowBox[{"-", "0.05"}], ",", "0", ",", "0", ",", "0"}], 
                 "}"}], "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2.6", "-", 
                    RowBox[{"2", "/", "3"}]}], ",", "3.3"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2.6", "-", "2"}], ",", "3.3"}], "}"}]}], "}"}], 
                 "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
               RowBox[{"Arrowheads", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "0.05", ",", "0"}], "}"}], "]"}],
                ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2.6", "-", 
                    RowBox[{"2", "/", "3"}]}], ",", "3.1"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"2.6", "-", "2"}], ",", "3.1"}], "}"}]}], "}"}], 
                 "]"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"ImageSize", "->", "260"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", "\"\<Fig. 1. \>\"", "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellID->4867055,ExpressionUUID->"b6bcf3be-6521-4b49-944d-676eab9c92de"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[
        InterpretationBox[{
          TagBox[{{{}, {}, 
             TagBox[{
               RGBColor[0.24, 0.6, 0.8], 
               Thickness[0.01], 
               Opacity[1.], 
               FaceForm[
                Opacity[0.3]], 
               LineBox[CompressedData["
1:eJxd23c81e8bMHB7z+OcY55hJypUkuS+ouxKVoiEvnaLjEQUGRWRSkSkjDJS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                "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
           "WolframDynamicHighlight", <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
          StyleBox[
           DynamicBox[
            (Charting`HighlightActionBox["DynamicHighlight", {}, 
             Slot["HighlightElements"], 
             Slot["LayoutOptions"], 
             Slot["Meta"], 
             Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
                 Annotation[{
                   Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]], 
                   Line[CompressedData["
1:eJxd23c81e8bMHB7z+OcY55hJypUkuS+ouxKVoiEvnaLjEQUGRWRSkSkjDJS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                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 11}, {0, 8}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {260, 260}, 
                 "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
                 Automatic, "DefaultStyle" -> {
                   Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> Identity, 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ParametricPlot, "GroupHighlight" -> 
                 False|>|>]]& )[<|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 11}, {0, 8}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {260, 260}, 
                "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   Opacity[1.], 
                   AbsoluteThickness[2], 
                   FaceForm[
                    Opacity[0.3]], 
                   RGBColor[0.24, 0.6, 0.8], 
                   Thickness[0.01]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> Identity, 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>], 
            ImageSizeCache -> {{
             4.503599627370496*^15, -4.503599627370496*^15}, {
             4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
           False]}, 
         Annotation[{{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.24, 0.6, 0.8], 
                Thickness[0.01]], 
               Line[CompressedData["
1:eJxd23c81e8bMHB7z+OcY55hJypUkuS+ouxKVoiEvnaLjEQUGRWRSkSkjDJS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                "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 11}, {0, 8}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {260, 260}, 
             "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.24, 0.6, 0.8], 
                Thickness[0.01]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>, 
          "DynamicHighlight"]], Axes -> {False, False}, 
        AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
        Identity, Epilog -> {{
           RGBColor[0.368417, 0.506779, 0.709798], 
           Arrowheads[0.08], 
           ArrowBox[{{8., 6.6}, {7.961016142547826, 6.706120206063538}}]}, 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\\"C\\\", \
TraditionalForm]]]]]\\)\"", 14, StripOnInput -> False], TraditionalForm], {
           8.5, 7}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 
              Rational[1, 2]}], 
            ImageScaled[{0.5, 0.5}]]], {
           RGBColor[1, 0, 0], 
           PointBox[{2.6, 3.2}]}, 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\
\"z\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", 14, StripOnInput -> False], 
            TraditionalForm], {2.6, 3.2}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], {
           RGBColor[1, 0, 0], 
           PointBox[{6.5, 5.5}]}, 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\
\"z\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", 14, StripOnInput -> False], 
            TraditionalForm], {6.5, 5.5}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]]}, 
        FrameLabel -> {{None, None}, {None, None}}, 
        FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
        GridLinesStyle -> Directive[
          GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 260, 
        Method -> {
         "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "ScalingFunctions" -> None}, PlotRange -> {{0, 11}, {0, 8}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
        Ticks -> {Automatic, Automatic}], 
       GraphicsBox[{
         InterpretationBox[{
           TagBox[{{{}, {}, 
              TagBox[{
                RGBColor[0.24, 0.6, 0.8], 
                Thickness[0.01], 
                Opacity[1.], 
                FaceForm[
                 Opacity[0.3]], 
                LineBox[CompressedData["
1:eJwl13c8Vf//AHBkRcadXPfecyQjZYTM6LzsishM6aOMZJRdQiiSVLQkFUUJ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                 "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
            "WolframDynamicHighlight", <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
           StyleBox[
            DynamicBox[
             (Charting`HighlightActionBox["DynamicHighlight", {}, 
              Slot["HighlightElements"], 
              Slot["LayoutOptions"], 
              Slot["Meta"], 
              Charting`HighlightActionFunction[
              "DynamicHighlight", {{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]], 
                    Line[CompressedData["
1:eJwl13c8Vf//AHBkRcadXPfecyQjZYTM6LzsishM6aOMZJRdQiiSVLQkFUUJ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                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 11}, {0, 8}}, 
                  "Frame" -> {{False, False}, {False, False}}, 
                  "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                  "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
                  Automatic, "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> Identity, 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> ParametricPlot, "GroupHighlight" -> 
                  False|>|>]]& )[<|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 11}, {0, 8}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
                 "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
                 Automatic, "DefaultStyle" -> {
                   Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> Identity, 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>],
              ImageSizeCache -> {{
              4.503599627370496*^15, -4.503599627370496*^15}, {
              4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
            False]}, 
          Annotation[{{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]], 
                Line[CompressedData["
1:eJwl13c8Vf//AHBkRcadXPfecyQjZYTM6LzsishM6aOMZJRdQiiSVLQkFUUJ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                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, "PlotRange" -> {{0, 11}, {0, 8}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 432}, 
              "Axes" -> {False, False}, "LabelStyle" -> {}, "AspectRatio" -> 
              Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>, 
           "DynamicHighlight"]], 
         InterpretationBox[{
           TagBox[{{{}, {}, 
              TagBox[{
                RGBColor[0.24, 0.6, 0.8], 
                Thickness[0.01], 
                Opacity[1.], 
                FaceForm[
                 Opacity[0.3]], 
                LineBox[CompressedData["
1:eJwV13c81d8bAPDrDmRl3EtEriRbQ4pKz2OlzAZRKSNEooGGkVFZoWxRfYuG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                 "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
            "WolframDynamicHighlight", <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
           StyleBox[
            DynamicBox[
             (Charting`HighlightActionBox["DynamicHighlight", {}, 
              Slot["HighlightElements"], 
              Slot["LayoutOptions"], 
              Slot["Meta"], 
              Charting`HighlightActionFunction[
              "DynamicHighlight", {{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]], 
                    Line[CompressedData["
1:eJwV13c81d8bAPDrDmRl3EtEriRbQ4pKz2OlzAZRKSNEooGGkVFZoWxRfYuG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                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PanelPlotLayout" -> <||>, 
                  "PlotRange" -> {{0., 8.204017627095434}, {
                   0.8423924623806686, 5.395976556409468}}, 
                  "Frame" -> {{False, False}, {False, False}}, 
                  "AxesOrigin" -> {0, 0.8423924623806686}, 
                  "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> Automatic, 
                  "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> Identity, 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> ParametricPlot, "GroupHighlight" -> 
                  False|>|>]]& )[<|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{0., 8.204017627095434}, {0.8423924623806686,
                   5.395976556409468}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0.8423924623806686}, 
                 "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
                 "LabelStyle" -> {}, "AspectRatio" -> Automatic, 
                 "DefaultStyle" -> {
                   Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> Identity, 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>],
              ImageSizeCache -> {{
              4.503599627370496*^15, -4.503599627370496*^15}, {
              4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
            False]}, 
          Annotation[{{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]], 
                Line[CompressedData["
1:eJwV13c81d8bAPDrDmRl3EtEriRbQ4pKz2OlzAZRKSNEooGGkVFZoWxRfYuG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                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{0., 8.204017627095434}, {0.8423924623806686, 
               5.395976556409468}}, 
              "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {0, 0.8423924623806686}, 
              "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
              "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>, 
           "DynamicHighlight"]], 
         InterpretationBox[{
           TagBox[{{{}, {}, 
              TagBox[{
                RGBColor[0.24, 0.6, 0.8], 
                Thickness[0.01], 
                Opacity[1.], 
                FaceForm[
                 Opacity[0.3]], 
                LineBox[CompressedData["
1:eJwd0ntM02cUBuAKTCMIVsX+LoJ+2Ik3bkHruMoL2BKlRUBQFJCWUrVuQqIQ
FYd1hHERU93GwLHClG7LQFGHDpQJ80IDQ9TIBigyZSjOKDAKiqgU9803OTl5
/nxPjktyWrTGSiAQKOj8v2tuFW7gNASh8lrhtGIRfpPdHRRRa38fiYulzrso
z3Ok9sgVnjRSD2VX182kXlj+rxdKRFDmRjhMpe5U+6/ff1yEor4ZX42kEMxe
apX7vFSEXlPam1bqVWfn9Nz+ToSE/nTsp16g0C05XilC9Wfa1MtqgsUeddK2
RhF0A8pGSzLBx1YOCcXtInzv6L1OQn3qCW960y/CrAehNXIVgbPnuN+UtyI8
DpUoNUqC8PV2N8scGGTNZ0h8EkHKH9vL74sZ/Hn51Kh0K4F91iJLjQ+DNUOZ
ayWJBJ5Cx1oiZ1BqTPeajCeoa3yd46FisDLFuPrmFgK3xUXN7ekMfE2aqqLN
BIkTXq3CfAYHjrv5eMcRuNgUVw4aGFiwa969jQSZjEypOscg6pMuxYZYgmcF
vHm3iUGvwVDTtIH2sYnUOncz2HOj/3xINEGJsNYnaZBB/aev9x2LJIhRLNwb
aMWi5ltLzkAEQfaVobDzc1nc6767d66CYHoBUTUtY9Ftm2VaFU4wYR85JTWI
RYKq5bR2LYGP4HrP2WgWpXbmPk0YwaMZsh2F21m4pxN1hpSgTyrQvctk8Wvv
9fJDoQQZ3r6XZ+hZBFSmGaOCCWw8x6xrKlhMNges8g0ikD1vqBj+hYXIu+T0
owCCfY3xw6ZWFhlO5lP5fgTWQh/tiocsfhq+VRzmQ+/VdF/sP8Li9HjVNZOE
wHAy7HzXVA6T9d1Hk1YQjOtnjTnwHOTHvo565UUQy/wte+jGof5tYNM6DwKx
vSU3JJjDN91lrg3LCVKb3XKDYziMur4Lf7qEoGNC+fjODg5x5R1OK10J4l4+
zZs8wGH3u5WsTkzgZ3VueZOew4D/Aj8dIShw7XTijBxChlUqozNBjvP8PLta
DoE7F9Tt5wlcz0kPF7ZyGM+5ZFEwtJ+2L834gMOFwM0Nax0J7pEh8RYzhy/1
18yjQgK5u3iJ4QMetg2JymZ7gtV5JyuyWB7aF1yIwZag2v9RxPgyHup4s3ne
NAKnsrbXb1fzuPajGC3WBEvF5foTUTwygrJDL1GPeeypH6W+mnpJWkV956+K
flk0D0n+z7Ij1LavZvkNUr/Y3uIXSV101/2+bwwP5yf6511WBFFJ0ZPtG3kk
fZSW9mQK/d/ayWabBB6FET2KLmrDzNkPN1G3XHBZ3kL9oPzgyyrqPI2kr5L6
pbeaRCXy0HGHQnZRR47EpZZt5WHsPHFjVECwqGPgmUTFo7r9i5LH1GcD9K/y
qae+2ZLcQR38Yb51D/WZqxkvaqkt0s+57GQe8rE220zqM0XGwFtqHp4Oups7
qY80TJO6pPA4GDT9aDx1jF1TeDp1av8PDoHUA/+s2cRreBTHXmxzp55Imp6w
i9q3s6JgPnXs7UXKK9ROGo10JnXpslL1nG08BO9DsO19ePwH5MLoew==
                 "]]}, Annotation[#, "Charting`Private`Tag#1"]& ]}, {}}, {
            "WolframDynamicHighlight", <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
           StyleBox[
            DynamicBox[
             (Charting`HighlightActionBox["DynamicHighlight", {}, 
              Slot["HighlightElements"], 
              Slot["LayoutOptions"], 
              Slot["Meta"], 
              Charting`HighlightActionFunction[
              "DynamicHighlight", {{{{}, {}, 
                  Annotation[{
                    Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]], 
                    Line[CompressedData["
1:eJwd0ntM02cUBuAKTCMIVsX+LoJ+2Ik3bkHruMoL2BKlRUBQFJCWUrVuQqIQ
FYd1hHERU93GwLHClG7LQFGHDpQJ80IDQ9TIBigyZSjOKDAKiqgU9803OTl5
/nxPjktyWrTGSiAQKOj8v2tuFW7gNASh8lrhtGIRfpPdHRRRa38fiYulzrso
z3Ok9sgVnjRSD2VX182kXlj+rxdKRFDmRjhMpe5U+6/ff1yEor4ZX42kEMxe
apX7vFSEXlPam1bqVWfn9Nz+ToSE/nTsp16g0C05XilC9Wfa1MtqgsUeddK2
RhF0A8pGSzLBx1YOCcXtInzv6L1OQn3qCW960y/CrAehNXIVgbPnuN+UtyI8
DpUoNUqC8PV2N8scGGTNZ0h8EkHKH9vL74sZ/Hn51Kh0K4F91iJLjQ+DNUOZ
ayWJBJ5Cx1oiZ1BqTPeajCeoa3yd46FisDLFuPrmFgK3xUXN7ekMfE2aqqLN
BIkTXq3CfAYHjrv5eMcRuNgUVw4aGFiwa969jQSZjEypOscg6pMuxYZYgmcF
vHm3iUGvwVDTtIH2sYnUOncz2HOj/3xINEGJsNYnaZBB/aev9x2LJIhRLNwb
aMWi5ltLzkAEQfaVobDzc1nc6767d66CYHoBUTUtY9Ftm2VaFU4wYR85JTWI
RYKq5bR2LYGP4HrP2WgWpXbmPk0YwaMZsh2F21m4pxN1hpSgTyrQvctk8Wvv
9fJDoQQZ3r6XZ+hZBFSmGaOCCWw8x6xrKlhMNges8g0ikD1vqBj+hYXIu+T0
owCCfY3xw6ZWFhlO5lP5fgTWQh/tiocsfhq+VRzmQ+/VdF/sP8Li9HjVNZOE
wHAy7HzXVA6T9d1Hk1YQjOtnjTnwHOTHvo565UUQy/wte+jGof5tYNM6DwKx
vSU3JJjDN91lrg3LCVKb3XKDYziMur4Lf7qEoGNC+fjODg5x5R1OK10J4l4+
zZs8wGH3u5WsTkzgZ3VueZOew4D/Aj8dIShw7XTijBxChlUqozNBjvP8PLta
DoE7F9Tt5wlcz0kPF7ZyGM+5ZFEwtJ+2L834gMOFwM0Nax0J7pEh8RYzhy/1
18yjQgK5u3iJ4QMetg2JymZ7gtV5JyuyWB7aF1yIwZag2v9RxPgyHup4s3ne
NAKnsrbXb1fzuPajGC3WBEvF5foTUTwygrJDL1GPeeypH6W+mnpJWkV956+K
flk0D0n+z7Ij1LavZvkNUr/Y3uIXSV101/2+bwwP5yf6511WBFFJ0ZPtG3kk
fZSW9mQK/d/ayWabBB6FET2KLmrDzNkPN1G3XHBZ3kL9oPzgyyrqPI2kr5L6
pbeaRCXy0HGHQnZRR47EpZZt5WHsPHFjVECwqGPgmUTFo7r9i5LH1GcD9K/y
qae+2ZLcQR38Yb51D/WZqxkvaqkt0s+57GQe8rE220zqM0XGwFtqHp4Oups7
qY80TJO6pPA4GDT9aDx1jF1TeDp1av8PDoHUA/+s2cRreBTHXmxzp55Imp6w
i9q3s6JgPnXs7UXKK9ROGo10JnXpslL1nG08BO9DsO19ePwH5MLoew==
                    "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PanelPlotLayout" -> <||>, 
                  "PlotRange" -> {{8., 8.197458849731763}, {5.646511326910573,
                    6.6}}, "Frame" -> {{False, False}, {False, False}}, 
                  "AxesOrigin" -> {8., 5.646511326910573}, 
                  "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
                  "LabelStyle" -> {}, "AspectRatio" -> Automatic, 
                  "DefaultStyle" -> {
                    Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> Identity, 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> ParametricPlot, "GroupHighlight" -> 
                  False|>|>]]& )[<|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{8., 8.197458849731763}, {5.646511326910573, 
                  6.6}}, "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {8., 5.646511326910573}, 
                 "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
                 "LabelStyle" -> {}, "AspectRatio" -> Automatic, 
                 "DefaultStyle" -> {
                   Directive[
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.24, 0.6, 0.8], 
                    Thickness[0.01]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> Identity, 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>],
              ImageSizeCache -> {{
              4.503599627370496*^15, -4.503599627370496*^15}, {
              4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
            False]}, 
          Annotation[{{{{}, {}, 
              Annotation[{
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]], 
                Line[CompressedData["
1:eJwd0ntM02cUBuAKTCMIVsX+LoJ+2Ik3bkHruMoL2BKlRUBQFJCWUrVuQqIQ
FYd1hHERU93GwLHClG7LQFGHDpQJ80IDQ9TIBigyZSjOKDAKiqgU9803OTl5
/nxPjktyWrTGSiAQKOj8v2tuFW7gNASh8lrhtGIRfpPdHRRRa38fiYulzrso
z3Ok9sgVnjRSD2VX182kXlj+rxdKRFDmRjhMpe5U+6/ff1yEor4ZX42kEMxe
apX7vFSEXlPam1bqVWfn9Nz+ToSE/nTsp16g0C05XilC9Wfa1MtqgsUeddK2
RhF0A8pGSzLBx1YOCcXtInzv6L1OQn3qCW960y/CrAehNXIVgbPnuN+UtyI8
DpUoNUqC8PV2N8scGGTNZ0h8EkHKH9vL74sZ/Hn51Kh0K4F91iJLjQ+DNUOZ
ayWJBJ5Cx1oiZ1BqTPeajCeoa3yd46FisDLFuPrmFgK3xUXN7ekMfE2aqqLN
BIkTXq3CfAYHjrv5eMcRuNgUVw4aGFiwa969jQSZjEypOscg6pMuxYZYgmcF
vHm3iUGvwVDTtIH2sYnUOncz2HOj/3xINEGJsNYnaZBB/aev9x2LJIhRLNwb
aMWi5ltLzkAEQfaVobDzc1nc6767d66CYHoBUTUtY9Ftm2VaFU4wYR85JTWI
RYKq5bR2LYGP4HrP2WgWpXbmPk0YwaMZsh2F21m4pxN1hpSgTyrQvctk8Wvv
9fJDoQQZ3r6XZ+hZBFSmGaOCCWw8x6xrKlhMNges8g0ikD1vqBj+hYXIu+T0
owCCfY3xw6ZWFhlO5lP5fgTWQh/tiocsfhq+VRzmQ+/VdF/sP8Li9HjVNZOE
wHAy7HzXVA6T9d1Hk1YQjOtnjTnwHOTHvo565UUQy/wte+jGof5tYNM6DwKx
vSU3JJjDN91lrg3LCVKb3XKDYziMur4Lf7qEoGNC+fjODg5x5R1OK10J4l4+
zZs8wGH3u5WsTkzgZ3VueZOew4D/Aj8dIShw7XTijBxChlUqozNBjvP8PLta
DoE7F9Tt5wlcz0kPF7ZyGM+5ZFEwtJ+2L834gMOFwM0Nax0J7pEh8RYzhy/1
18yjQgK5u3iJ4QMetg2JymZ7gtV5JyuyWB7aF1yIwZag2v9RxPgyHup4s3ne
NAKnsrbXb1fzuPajGC3WBEvF5foTUTwygrJDL1GPeeypH6W+mnpJWkV956+K
flk0D0n+z7Ij1LavZvkNUr/Y3uIXSV101/2+bwwP5yf6511WBFFJ0ZPtG3kk
fZSW9mQK/d/ayWabBB6FET2KLmrDzNkPN1G3XHBZ3kL9oPzgyyrqPI2kr5L6
pbeaRCXy0HGHQnZRR47EpZZt5WHsPHFjVECwqGPgmUTFo7r9i5LH1GcD9K/y
qae+2ZLcQR38Yb51D/WZqxkvaqkt0s+57GQe8rE220zqM0XGwFtqHp4Oups7
qY80TJO6pPA4GDT9aDx1jF1TeDp1av8PDoHUA/+s2cRreBTHXmxzp55Imp6w
i9q3s6JgPnXs7UXKK9ROGo10JnXpslL1nG08BO9DsO19ePwH5MLoew==
                 "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
           "HighlightElements" -> <|
             "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
            "LayoutOptions" -> <|
             "PanelPlotLayout" -> <||>, 
              "PlotRange" -> {{8., 8.197458849731763}, {5.646511326910573, 
               6.6}}, "Frame" -> {{False, False}, {False, False}}, 
              "AxesOrigin" -> {8., 5.646511326910573}, 
              "ImageSize" -> {360, 432}, "Axes" -> {False, False}, 
              "LabelStyle" -> {}, "AspectRatio" -> Automatic, "DefaultStyle" -> {
                Directive[
                 Opacity[1.], 
                 AbsoluteThickness[2], 
                 FaceForm[
                  Opacity[0.3]], 
                 RGBColor[0.24, 0.6, 0.8], 
                 Thickness[0.01]]}, 
              "HighlightLabelingFunctions" -> <|
               "CoordinatesToolOptions" -> Identity, 
                "ScalingFunctions" -> {{Identity, Identity}, {
                  Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
              False|>, 
            "Meta" -> <|
             "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
              "Function" -> ParametricPlot, "GroupHighlight" -> False|>|>, 
           "DynamicHighlight"]], {{
           RGBColor[0.368417, 0.506779, 0.709798], 
           Arrowheads[0.08], 
           ArrowBox[{{8., 6.6}, {7.961016142547826, 6.706120206063538}}]}, 
          InsetBox[
           StyleBox[
           "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"\
C\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, 
            FontSize -> 14], {8.5, 7}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 
              Rational[1, 2]}], 
            ImageScaled[{0.5, 0.5}]]], {
           RGBColor[1, 0, 0], 
           PointBox[{2.6, 3.2}]}, 
          InsetBox[
           StyleBox[
           "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"\
z\\\", \\\"1\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, 
            FontSize -> 14], {2.6, 3.2}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], {
           RGBColor[1, 0, 0], 
           PointBox[{6.5, 5.5}]}, 
          InsetBox[
           StyleBox[
           "\"\\!\\(\\*Cell[TextData[Cell[BoxData[FormBox[\\nSubscriptBox[\\\"\
z\\\", \\\"2\\\"], TraditionalForm]]]]]\\)\"", StripOnInput -> False, 
            FontSize -> 14], {6.5, 5.5}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           
           CircleBox[{2.6, 3.2}, 0.6666666666666666, {
            0, 2.941592653589793}]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           CircleBox[{2.6, 3.2}, 0.6666666666666666, 
            
            NCache[{3.3415926535897933`, 2 Pi}, {3.3415926535897933`, 
             6.283185307179586}]]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Arrowheads[0.05], 
           
           ArrowBox[{{2.580533651799141, 3.8663824020276705`}, {
            2.9602015372454265`, 3.7609806565385977`}}]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           
           CircleBox[{6.5, 5.5}, 0.6666666666666666, {0.2, 
            6.083185307179586}]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Arrowheads[0.06], 
           
           ArrowBox[{{6.480533651799141, 6.16638240202767}, {
            6.860201537245427, 6.0609806565385975`}}]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           Arrowheads[{0, 0, -0.05, 0, 0, 0}], 
           ArrowBox[
            LineBox[{{7.166666666666667, 5.4}, {8.2, 5.4}}]]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           Arrowheads[{0, 0, 0.05, 0}], 
           ArrowBox[
            LineBox[{{7.166666666666667, 5.6}, {8.2, 5.6}}]]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           Arrowheads[{0, 0, -0.05, 0, 0, 0}], 
           ArrowBox[
            
            LineBox[{{1.9333333333333336`, 3.3}, {0.6000000000000001, 
             3.3}}]]}, {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Thickness[0.01], 
           Arrowheads[{0, 0, 0.05, 0}], 
           ArrowBox[
            
            LineBox[{{1.9333333333333336`, 3.1}, {0.6000000000000001, 
             3.1}}]]}}}, Axes -> {False, False}, AxesLabel -> {None, None}, 
        AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
        FrameLabel -> {{None, None}, {None, None}}, 
        FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
        GridLinesStyle -> Directive[
          GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 260, 
        Method -> {
         "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "ScalingFunctions" -> None}, PlotRange -> {{0, 11}, {0, 8}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
        Ticks -> {Automatic, Automatic}]},
      "RowDefault"]},
    {"\<\"Fig. 1.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1895643021,ExpressionUUID->"e58c5c12-5378-4ef7-ba3f-624738f996a3"]
}, {2}]],

Cell[TextData[{
 "Referring to Fig. 1, the integral over the closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "db076833-83b2-48b4-81e5-5b66a4af4f43"],
 " enclosing the isolated singularities ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e01471e3-8d8f-424b-a822-7a0b425f18af"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "2"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "ebda037d-feca-49fb-96ce-b5f8483d5fe2"],
 " is clearly related to that over the curve ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1663015f-5a68-42b3-9c8f-1b7a12540baf"],
 " by"
}], "Text",
 CellID->34505956,ExpressionUUID->"f241ad42-f27d-4086-b713-4dbf11d8e7a8"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ContourIntegral]", "C"], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      SubscriptBox["C", "1"]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "+", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     UnderscriptBox["Res", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "1"]}]], 
     RowBox[{"f", "(", "z", ")"}]}], "+", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     UnderscriptBox["Res", 
      RowBox[{"z", "->", 
       SubscriptBox["z", "2"]}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->200998358,ExpressionUUID->"5b9c2c02-c79e-4433-a6fa-5d4b2e6df485"],

Cell[TextData[{
 "But the integral over ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "1"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "9f24ce2d-5994-4c9d-a91e-0b09ab552d51"],
 " is zero because it excludes all singularities and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"93d0b448-486d-4371-a4d9-c6bc91720d5d"],
 " is analytic inside of it. This argument justifies what is known as Cauchy\
\[CloseCurlyQuote]s residue theorem:"
}], "Text",
 CellID->138128648,ExpressionUUID->"5aac415c-e571-47d1-8dd6-b1f65bd7422e"],

Cell[TextData[{
 StyleBox["Cauchy\[CloseCurlyQuote]s residue theorem",
  FontSlant->"Italic"],
 ":",
 " If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b24a8553-d38c-4091-98d5-f531b0a720f0"],
 " is analytic in a region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "d6eccb29-35bb-49bf-8ec8-e4d00eaabd80"],
 " with the exception of isolated singularities ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "i"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1e2c38cf-8676-41f8-bc53-19e01dc0ba77"],
 ", then for a closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b5b3ba9b-3084-4677-a277-1f8e86d83ae8"]
}], "Text",
 CellID->162770103,ExpressionUUID->"5e84f2cc-b065-4f97-b7be-6315f2be808e"],

Cell[BoxData[
 FormBox[
  FrameBox[
   RowBox[{
    FormBox[
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{"f", 
       RowBox[{"(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}], "=", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
       RowBox[{
        UnderscriptBox["\[Sum]", "i"], " ", 
        RowBox[{
         UnderscriptBox["Res", 
          RowBox[{"z", "->", 
           SubscriptBox["z", "i"]}]], "f", 
         RowBox[{"(", "z", ")"}]}]}]}]}],
     TraditionalForm], "               ", 
    StyleBox[Cell[
     "(Cauchy\[CloseCurlyQuote]s Residue Theorem)",ExpressionUUID->
      "74c89a41-2dd9-4d47-b5df-8115ad5a5208"], "Text"]}]], 
  TextForm]], "DisplayFormulaNumbered",
 CellChangeTimes->{{3.9634837426021175`*^9, 3.96348374450255*^9}},
 CellID->9678041,ExpressionUUID->"67d8b047-4036-4282-94e5-06f6e14d22fa"],

Cell[TextData[{
 "where the sum runs over the singularities enclosed by ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "8b5b7c15-b423-4755-8aa0-fcd9903fabbf"],
 "."
}], "Text",
 CellID->255852303,ExpressionUUID->"febeba12-200b-4fc8-954b-32f49f1fee14"],

Cell[TextData[{
 "The residue theorem is an important method to practically compute complex \
integrals, because residues can be calculated algorithmically in a \
straightforward way, as we saw in ",
 ButtonBox["Chapter 22",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{
    "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 "."
}], "Text",
 CellID->2154169,ExpressionUUID->"e96fb691-69fc-4742-b74b-c4da3f5dc9b8"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->143564869,ExpressionUUID->"29a05808-361f-436f-ad9c-e4df4bfaa0c9"],

Cell[TextData[{
 "Compute the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"z", "(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"z", "-", "3"}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c4dd9378-835f-46a9-a0a2-4e70c0da8f73"],
 " where ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "f5c2162f-756d-46f6-a720-355824eda2c8"],
 " is a circle of radius ",
 Cell[BoxData[
  FormBox[
   RowBox[{"5", "/", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d5694a80-d867-4a88-bece-42767fdc3e84"],
 " traversed counterclockwise."
}], "SolvedExampleNote",
 CellID->271115179,ExpressionUUID->"fd029876-e912-4361-b673-8c38ef839f9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{"z", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "2"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"z", "-", "3"}], ")"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "5"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1408", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {{
        Style[
         RGBColor[
          Rational[1, 3], 
          Rational[1, 3], 
          Rational[1, 3]], LightDarkAutoColorRules -> {}], 
        Arrow[
         Circle[{0, 0}, 5/2]]}, {Red, 
        Point[{2, 0}]}, {Red, 
        Point[{3, 0}]}}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->106213142,ExpressionUUID->"d3eb97c9-c39a-4ef3-b321-4666fc070875"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o2FUYh/HrH3CIoBPTTcqaiBjEJpqsA9OK4QoGkzJMWgw3CauLq9YV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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxk12VwG32e6Pute9+cF/fWOad29yzN7s7s7PAzD0M4MbPQMsjsOGxmZicO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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHkUYRj+0CWiTNoUgtpaCldhZiCCkso0YwUqwDahFWgubIBaCVcDK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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     StyleBox[
      RGBColor[
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}},
       StripOnInput -> False], 
     ArrowBox[
      CircleBox[{0, 0}, 
       NCache[
        Rational[5, 2], 2.5]]]}, {
     RGBColor[1, 0, 0], 
     PointBox[{2, 0}]}, {
     RGBColor[1, 0, 0], 
     PointBox[{3, 0}]}},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->321876268,ExpressionUUID->"7d882371-84d4-4370-972f-a114e0f20e2a"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"z", "(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "3"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"34493e81-40aa-4115-9f62-e38b35f88953"],
 " has poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "2"}], ",", "3"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6c244003-77b5-4a18-b146-f502effab839"],
 ". Only the pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "2"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "df8dd023-d1c0-40b5-b665-70149dd6938b"],
 " is inside the contour, so using the residue theorem:"
}], "SolvedExampleNote",
 CellID->758682999,ExpressionUUID->"b754fb04-30fd-478a-a67b-aa65708ef1b1"],

Cell[TextData[{
 Cell[BoxData[
  TemplateBox[{14},
   "Spacer1"]],ExpressionUUID->"441d098a-31fc-4012-bd47-36f20f741783"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"\[ThinSpace]", "C"}]], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["Res", 
       RowBox[{"z", "->", "2"}]], 
      RowBox[{"f", "(", "z", ")"}]}], "=", 
     RowBox[{
      RowBox[{"2", "\[Pi]", " ", 
       RowBox[{"\[ImaginaryI]", " ", "\[CenterDot]", 
        FractionBox[
         RowBox[{"2", "\[CenterDot]", "1"}], 
         RowBox[{"-", "1"}]]}]}], "=", 
      RowBox[{
       RowBox[{"-", "4"}], "\[Pi]", " ", 
       RowBox[{"\[ImaginaryI]", "."}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"196a70a2-06e3-487e-9d3f-906d4bb32b60"]
}], "SolvedExampleNote",
 CellID->778779165,ExpressionUUID->"fd880782-3ad9-4149-be11-10c2d509f828"],

Cell[TextData[{
 "You can confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->5084018,ExpressionUUID->"535e6d77-d8ff-4ec7-af2b-d70e3ce09434"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"z", "(", 
     RowBox[{"z", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "3"}], ")"}]}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"5", "/", "2"}]}], "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->336307413,ExpressionUUID->"d8fd224c-2c98-4722-96c7-acca87200355"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", 
  "\[Pi]"}]], "SolvedExampleOutput",
 CellID->97175549,ExpressionUUID->"8a3b811d-e162-4481-82ae-5d6a18632acc"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"e879692c-2405-4ab1-9b5e-8fd6e91c3ce2"],

Cell[TextData[{
 "In Wolfram Language, you can compute a sum of residues using the command ",
 ButtonBox["ResidueSum",
  BaseStyle->"Link"],
 "."
}], "Text",
 CellID->664904150,ExpressionUUID->"c0931114-9ab1-4ed8-919e-9d91f8a26709"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->681037522,ExpressionUUID->"e545cff6-911a-4103-bd08-2400139c19ac"],

Cell[TextData[{
 "Compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox["1", 
     RowBox[{"sin", "(", 
      RowBox[{"\[Pi]", " ", "z"}], ")"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1bf20fbd-15d1-4902-96d3-e657f35826c4"],
 " over the path in the figure."
}], "SolvedExampleNote",
 CellID->454938466,ExpressionUUID->"56977a16-a62e-4eea-94b0-521d323ac8d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     RowBox[{"Pi", " ", "z"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "5"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["3176", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {{
        Style[
         RGBColor[
          Rational[1, 3], 
          Rational[1, 3], 
          Rational[1, 3]], LightDarkAutoColorRules -> {}], 
        Arrow[{{-(3/2), -1}, {3/2, -1}, {
          3/2, 1}, {-(3/2), 1}, {-(3/2), -1}}]}, {Red, 
        Point[{{-4, 0}, {-3, 0}, {-2, 0}, {-1, 0}, {0, 0}, {1, 0}, {2, 0}, {3,
          0}, {4, 0}}]}}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->314660347,ExpressionUUID->"2483acc5-f062-4e71-964f-a1d65206c13e"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o2FUYh/HrH3CIoBPTTcqaiBjEJpqsA9OK4QoGkzJMWgw3CauLq9YV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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJzt1mdUVOm6L/o9zh3j7NW5287dKsbWNrSNiQySDJgIkg0EwYyKBBEjghjA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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHkUYRj+0CWiTNoUgtpaCldhZiCCkso0YwUqwDahFWgubIBaCVcDK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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     StyleBox[
      RGBColor[
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}},
       StripOnInput -> False], 
     ArrowBox[
      NCache[{{
         Rational[-3, 2], -1}, {
         Rational[3, 2], -1}, {
         Rational[3, 2], 1}, {
         Rational[-3, 2], 1}, {
         Rational[-3, 2], -1}}, {{-1.5, -1}, {1.5, -1}, {
        1.5, 1}, {-1.5, 1}, {-1.5, -1}}]]}, {
     RGBColor[1, 0, 0], 
     PointBox[{{-4, 0}, {-3, 0}, {-2, 0}, {-1, 0}, {0, 0}, {1, 0}, {2, 0}, {3,
       0}, {4, 0}}]}},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->757016192,ExpressionUUID->"92967d2e-41ea-4c42-a9ec-b2636eab51ea"]
}, Open  ]],

Cell[TextData[{
 "The poles included in the curve are at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", 
    RowBox[{"\[PlusMinus]", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d3bb0385-ca41-4537-b8b9-3d7cfac20962"],
 ". Therefore the integral is:"
}], "SolvedExampleNote",
 CellID->36121136,ExpressionUUID->"eb0a9c8c-7b9f-4881-b462-20fc13e673c3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", " ", "z"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0"}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1"}], "}"}]}], "]"}]}], 
   ")"}]}]}], "SolvedExampleInput",
 CellID->155190754,ExpressionUUID->"ae0b8088-35cd-4c29-bed9-8a5ba6d6c455"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]], "SolvedExampleOutput",
 CellID->510174053,ExpressionUUID->"87fd6b45-ec05-48ba-bebe-4a7818c60d5e"]
}, Open  ]],

Cell["You can also compute it by defining the region as:", "SolvedExampleNote",
 CellID->698309545,ExpressionUUID->"5ae11266-8e24-4c54-84a2-32ed3845199e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"reg", "=", 
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]}], 
  ";"}]], "SolvedExampleInput",
 CellID->14916108,ExpressionUUID->"510f4079-6649-4f69-b716-ecc48f9bb958"],

Cell[TextData[{
 "and using ",
 ButtonBox["ResidueSum",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->86216678,ExpressionUUID->"ded97e9c-d83f-4d55-b3cd-e544fcfe523b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}], "*", 
  RowBox[{"ResidueSum", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Re", "[", "z", "]"}], ",", 
         RowBox[{"Im", "[", "z", "]"}]}], "}"}], "\[Element]", "reg"}]}], 
     "}"}], ",", "z"}], "]"}]}]], "SolvedExampleInput",
 CellID->212835459,ExpressionUUID->"2d108e71-61f5-44af-9ba2-eb7dea7864c9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]], "SolvedExampleOutput",
 CellID->41258660,ExpressionUUID->"53aeb1f4-9073-4eef-86d0-a55c3dbd459e"]
}, Open  ]],

Cell["or directly:", "SolvedExampleNote",
 CellID->175463711,ExpressionUUID->"de8f3519-423c-458b-9592-8a366affa4fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], ",", 
   RowBox[{"z", "\[Element]", "reg"}]}], "]"}]], "SolvedExampleInput",
 CellID->289282402,ExpressionUUID->"5458c82c-3415-4bec-ba82-e728b121509f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]], "SolvedExampleOutput",
 CellID->106260084,ExpressionUUID->"ea3c62db-a9bc-44eb-be99-2eecd6a96861"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1403913282,ExpressionUUID->"c9288a37-d2d7-482c-a850-ee098d8a7687"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Residue Theorem at Infinity", "Subsection",
 CellID->25482850,ExpressionUUID->"d8421a02-2483-4568-8e61-2f6fbac283c7"],

Cell[TextData[{
 "In ",
 ButtonBox["Chapter 23",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", the residue at infinity was defined as "
}], "Text",
 CellID->160347742,ExpressionUUID->"435bb720-7a76-4847-a623-374bbd6bf27f"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["Res", 
     RowBox[{"z", "->", "\[Infinity]"}]], "f", 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]]}], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->232148208,ExpressionUUID->"6a55c087-e4a6-4496-a20b-debae0f9a049"],

Cell[TextData[{
 "with ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "be68d5ef-6046-47ab-92b9-eee8784ebeea"],
 " a closed curve traversed counterclockwise, enclosing all finite \
singularities."
}], "Text",
 CellID->187858047,ExpressionUUID->"72ed7ed5-40cc-473a-a130-f1abff3a4003"],

Cell[TextData[{
 "The reason for this definition is to make sure that the residue theorem \
also holds for the point at infinity. The definition in Eq. (3) clearly \
ensures that it does, since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"-", "C"}], ")"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "4f92226a-af4f-4d00-b353-b1786afc3ec0"],
 " is a closed curve around infinity."
}], "Text",
 CellID->7277549,ExpressionUUID->"f31739fa-3fa8-41f9-90aa-c139c7518a65"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], "-", "\[ImaginaryI]"}], ",", 
      RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "3"}], "+", 
       RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Ticks", "->", "None"}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
          "RGBColorSwatchTemplate"], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"7", "/", "2"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(0\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(1\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(2\)]\)\>\"", ",", "12"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "3"}], ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"C", ",", "12"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"7", "/", "2"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", "250"}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{
     "Text", "[", "\"\<Fig. 2. The residue at infinity is related to the \
contour integral around all finite singularities.\>\"", "]"}]}], "]"}], 
   "&"}]}]], "Input",
 CellID->1542218885,ExpressionUUID->"41b5d6f1-235e-4057-b739-7f0f23c48194"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, {}, {{}, 
        InterpretationBox[{
          TagBox[
           TagBox[
            {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
             PointBox[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
              0.5}, {-1., -0.5}, {0.25, 0.}}]},
            Annotation[#, "Charting`Private`Tag#1"]& ],
           {
           "WolframDynamicHighlight", <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
          StyleBox[
           DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
             Slot["HighlightElements"], 
             Slot["LayoutOptions"], 
             Slot["Meta"], 
             Charting`HighlightActionFunction["DynamicHighlight", {{
                Annotation[{
                  Directive[
                   AbsoluteThickness[2], 
                   RGBColor[1, 0, 0], 
                   PointSize[Medium]], 
                  
                  Point[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
                   0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
                 "Charting`Private`Tag#1"]}}, <|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
                 "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                 Automatic, "DefaultStyle" -> {
                   Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ComplexListPlot, "GroupHighlight" -> 
                 False|>|>]]& )[<|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, 
                "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
                "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   AbsoluteThickness[2], 
                   RGBColor[1, 0, 0], 
                   PointSize[Medium]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>],
            
            
            ImageSizeCache->{{
             4.503599627370496*^15, -4.503599627370496*^15}, {
             4.503599627370496*^15, -4.503599627370496*^15}}],
           Selectable->False]},
         Annotation[{{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               RGBColor[1, 0, 0], 
               PointSize[Medium]], 
              
              Point[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
               0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
             "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                RGBColor[1, 0, 0], 
                PointSize[Medium]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
          "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
      AspectRatio->Automatic,
      Axes->True,
      AxesLabel->{
        FormBox[
         StyleBox[
          RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm], 
        FormBox[
         StyleBox[
          RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
         TraditionalForm]},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Epilog->{{
         RGBColor[0.368417, 0.506779, 0.709798], 
         ArrowBox[
          CircleBox[{0, 0}, 
           NCache[
            Rational[7, 2], 3.5]]]}, 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(0\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], 
         NCache[{
           Rational[1, 2], -1}, {0.5, -1}], 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(1\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], {1, 1}, 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox[
          "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(2\\)]\\)\"", 12, StripOnInput -> 
           False], TraditionalForm], 
         NCache[{
           Rational[-1, 3], 
           Rational[1, 2]}, {-0.3333333333333333, 0.5}], 
         NCache[
          ImageScaled[{
            Rational[1, 2], 1}], 
          ImageScaled[{0.5, 1}]]], 
        InsetBox[
         FormBox[
          StyleBox["C", 12, StripOnInput -> False], TraditionalForm], 
         NCache[{
           Rational[7, 2], 0}, {3.5, 0}], 
         NCache[
          ImageScaled[{
            Rational[3, 2], 
            Rational[3, 2]}], 
          ImageScaled[{1.5, 1.5}]]]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->250,
      Method->{
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& )}},
      PlotRange->{{-4., 4.}, {-4., 4.}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{{}, {}}]},
    {"\<\"Fig. 2. The residue at infinity is related to the contour integral \
around all finite singularities.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->780402502,ExpressionUUID->"ec6e90dd-02d4-4a03-b9e8-4af37d20eb46"]
}, {2}]],

Cell["\<\
In the case of a function with a finite number of singularities, it follows \
that\
\>", "Text",
 CellID->419172361,ExpressionUUID->"a70e803b-aba8-4e61-8ff9-594ba2491175"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     UnderscriptBox["Res", 
      RowBox[{"z", "->", "\[Infinity]"}]], "f", 
     RowBox[{"(", "z", ")"}]}], "=", 
    RowBox[{"-", 
     RowBox[{
      UnderscriptBox["\[Sum]", "i"], " ", 
      RowBox[{
       UnderscriptBox["Res", 
        RowBox[{"z", "->", 
         SubscriptBox["z", "i"]}]], 
       RowBox[{"f", "(", "z", ")"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->511336443,ExpressionUUID->"20afe1c1-33fa-4221-915b-4ec4a4752921"],

Cell["\<\
where the sum runs over the singularities at finite points. This can also be \
written\
\>", "Text",
 CellID->1177878,ExpressionUUID->"afec7386-3b04-49e2-8776-e0d603c76e8e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      UnderscriptBox["Res", 
       RowBox[{"z", "->", "\[Infinity]"}]], 
      RowBox[{"f", "(", "z", ")"}]}], "+", 
     RowBox[{
      UnderscriptBox["\[Sum]", "i"], " ", 
      RowBox[{
       UnderscriptBox["Res", 
        RowBox[{"z", "->", 
         SubscriptBox["z", "i"]}]], 
       RowBox[{"f", "(", "z", ")"}]}]}]}], "=", "0"}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->107744892,ExpressionUUID->"7cc77698-b940-4857-92bd-e18575b620f9"],

Cell["\<\
so the sum of all residues including that at infinity is zero.\
\>", "Text",
 CellID->9843217,ExpressionUUID->"d27a8a3d-66e1-4ded-891f-d7a963365563"],

Cell[TextData[{
 "The reason for this is clear from the definition of residue at infinity as \
the integral (divided by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"ad67d64e-f3ee-4a14-8ded-72097fdfa21a"],
 ") over a curve enclosing all other singularities, traversed clockwise. This \
is clearly the same, by the residue theorem, as (minus) the residue sum of \
the residues at finite points."
}], "Text",
 CellID->388283733,ExpressionUUID->"7a72d609-76df-4b42-ae40-867a4c128fbd"],

Cell[TextData[{
 "We still need to prove the theorem, stated in ",
 ButtonBox["Chapter 23",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ", stating that for a function with a finite number of singularities,"
}], "Text",
 CellID->218035723,ExpressionUUID->"732706cf-d819-4a17-b012-10568278bafa"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["Res", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{
      UnderscriptBox["Res", 
       RowBox[{"z", "->", "0"}]], "[", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["z", "2"]], 
       RowBox[{"f", "(", 
        FractionBox["1", "z"], ")"}]}], "]"}], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->370547823,ExpressionUUID->"61d86768-b771-41ac-b251-08a28d53b34b"],

Cell["The proof of Eq. (6) comes from the change of variables", "Text",
 CellID->194864193,ExpressionUUID->"7d8f6d19-6b12-422c-bc20-09dc25f38b18"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "=", 
    RowBox[{"1", "/", "w"}]}], ",", "            ", 
   RowBox[{
    RowBox[{"\[DifferentialD]", "z"}], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SuperscriptBox["w", "2"]]}], 
     RowBox[{
      RowBox[{"\[DifferentialD]", "w"}], "."}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->91607926,ExpressionUUID->"422c2424-29cb-4d28-a6e2-5637ea84dc29"],

Cell[TextData[{
 "The contour ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ca5d69a5-9575-4bb0-886b-6cea0d031c56"],
 " is a large closed curve enclosing all finite singularities of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "3c9311f7-57ac-4e42-895d-dc401d07d78b"],
 ". With no loss of generality, we can take it to be a circle."
}], "Text",
 CellID->221727902,ExpressionUUID->"0fbd658b-947d-42b9-be17-10738b1ee93b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pts", ",", "pts2"}], "}"}], ",", 
    RowBox[{
     RowBox[{"pts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "-", "\[ImaginaryI]"}], ",", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}], "+", 
         RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
        RowBox[{"1", "/", "4"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"pts2", "=", 
      RowBox[{"1", "/", "pts"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ComplexListPlot", "[", 
         RowBox[{"pts", ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{"Red", ",", 
             RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"Ticks", "->", "None"}], ",", 
          RowBox[{"Epilog", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"Circle", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"0", ",", "0"}], "}"}], ",", 
                  RowBox[{"7", "/", "2"}]}], "]"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(0\)]\)\>\"", ",", 
                 "12"}], "]"}], ",", 
               RowBox[{
                RowBox[{"pts", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "//", "ReIm"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(1\)]\)\>\"", ",", 
                 "12"}], "]"}], ",", 
               RowBox[{
                RowBox[{"pts", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "//", "ReIm"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*SubscriptBox[\(z\), \(2\)]\)\>\"", ",", 
                 "12"}], "]"}], ",", 
               RowBox[{
                RowBox[{"pts", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "//", "ReIm"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"C", ",", "12"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"7", "/", "2"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"z", ",", "12"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "4.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"3.1", ",", "3.9"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3.1", ",", "3.2"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3.8", ",", "3.2"}], "}"}]}], "}"}], "]"}]}], 
              "}"}]}], "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "200"}]}], "]"}], ",", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"Graphics", "@", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Arrowheads", "[", "0.2", "]"}], ",", 
             RowBox[{"Arrow", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ",", 
          RowBox[{"Graphics", "@", 
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"w", "==", 
                RowBox[{"1", "/", "z"}]}], ",", "12"}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", 
               RowBox[{"1", "/", "2"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"ImageSize", "->", "60"}], ",", 
          RowBox[{"ImageMargins", "->", "40"}]}], "]"}], ",", 
        RowBox[{"ComplexListPlot", "[", 
         RowBox[{"pts2", ",", 
          RowBox[{"PlotStyle", "->", 
           RowBox[{"{", 
            RowBox[{"Red", ",", 
             RowBox[{"PointSize", "[", "Medium", "]"}]}], "}"}]}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Re", "[", "w", "]"}], ",", "12"}], "]"}], ",", 
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"Im", "[", "w", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
          RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
          RowBox[{"PlotRange", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "4"}], ",", "4.2"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
          RowBox[{"Ticks", "->", "None"}], ",", 
          RowBox[{"Epilog", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Circle", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"2", "/", "7"}]}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Purple", ",", 
               
               RowBox[{"Point", "[", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*SubscriptBox[\(w\), \(0\)]\)\>\"", ",", 
                 "12"}], "]"}], ",", 
               RowBox[{
                RowBox[{"pts2", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "//", "ReIm"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*SubscriptBox[\(w\), \(1\)]\)\>\"", ",", 
                 "12"}], "]"}], ",", 
               RowBox[{
                RowBox[{"pts2", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "//", "ReIm"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                
                RowBox[{"\"\<\!\(\*SubscriptBox[\(w\), \(2\)]\)\>\"", ",", 
                 "12"}], "]"}], ",", 
               RowBox[{
                RowBox[{"pts2", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "//", "ReIm"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               
               TemplateBox[<|
                "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
                "RGBColorSwatchTemplate"], ",", 
               RowBox[{"Arrowheads", "[", "0.05", "]"}], ",", 
               RowBox[{"Arrow", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"2", "/", "7"}], ",", "0.2"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"2", "/", "7"}], ",", 
                    RowBox[{"-", "0.2"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{
                 RowBox[{"C", "'"}], ",", "12"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], ",", 
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
             RowBox[{"Text", "[", 
              RowBox[{
               RowBox[{"Style", "[", 
                RowBox[{"w", ",", "12"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"4", ",", "4.5"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Thickness", "[", "0.003", "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"3.1", ",", "3.9"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3.1", ",", "3.2"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"3.8", ",", "3.2"}], "}"}]}], "}"}], "]"}]}], 
              "}"}]}], "}"}]}], ",", 
          RowBox[{"ImageSize", "->", "200"}]}], "]"}]}], "}"}], "]"}]}]}], 
   "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Fig. 3. The contour of integration under \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"w", "==", 
          RowBox[{"1", "/", "z"}]}], ",", "TraditionalForm"}], "]"}], 
       "<>", "\"\<.\>\""}], "]"}]}], "]"}], "&"}]}]], "Input",
 CellID->1961108122,ExpressionUUID->"b99a3acd-1118-4d66-b030-cdd1f3addb17"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{{{}, {}}, {}, {{}, 
          InterpretationBox[{
            TagBox[
             TagBox[{
               RGBColor[1, 0, 0], 
               PointSize[Medium], 
               AbsoluteThickness[2], 
               
               PointBox[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
                0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
              Annotation[#, "Charting`Private`Tag#1"]& ], {
             "WolframDynamicHighlight", <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
            StyleBox[
             DynamicBox[
              (Charting`HighlightActionBox["DynamicHighlight", {}, 
               Slot["HighlightElements"], 
               Slot["LayoutOptions"], 
               Slot["Meta"], 
               Charting`HighlightActionFunction["DynamicHighlight", {{
                  Annotation[{
                    Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]], 
                    
                    Point[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
                    0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
                   "Charting`Private`Tag#1"]}}, <|
                "HighlightElements" -> <|
                  "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
                 "LayoutOptions" -> <|
                  "PanelPlotLayout" -> <||>, 
                   "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                   "Frame" -> {{False, False}, {False, False}}, 
                   "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
                   "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                   Automatic, "DefaultStyle" -> {
                    Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                   "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                   False|>, 
                 "Meta" -> <|
                  "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                   "Function" -> ComplexListPlot, "GroupHighlight" -> 
                   False|>|>]]& )[<|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PanelPlotLayout" -> <||>, 
                  "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
                  "Frame" -> {{False, False}, {False, False}}, 
                  "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
                  "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                  Automatic, "DefaultStyle" -> {
                    Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> ComplexListPlot, "GroupHighlight" -> 
                  False|>|>], 
              ImageSizeCache -> {{
               4.503599627370496*^15, -4.503599627370496*^15}, {
               4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
             False]}, 
           Annotation[{{
              Annotation[{
                Directive[
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0], 
                 PointSize[Medium]], 
                
                Point[{{0.5, -1.}, {1., 1.}, {-0.3333333333333333, 
                 0.5}, {-1., -0.5}, {0.25, 0.}}]}, 
               "Charting`Private`Tag#1"]}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{-4., 4.}, {-4., 4.}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  AbsoluteThickness[2], 
                  RGBColor[1, 0, 0], 
                  PointSize[Medium]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
            "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, \
{}}}}, AspectRatio -> Automatic, Axes -> True, AxesLabel -> {
          FormBox[
           StyleBox[
            RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
           TraditionalForm], 
          FormBox[
           StyleBox[
            RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
           TraditionalForm]}, AxesOrigin -> {0, 0}, DisplayFunction -> 
        Identity, Epilog -> {{
           RGBColor[0.368417, 0.506779, 0.709798], 
           ArrowBox[
            CircleBox[{0, 0}, 
             NCache[
              Rational[7, 2], 3.5]]]}, 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(0\\)]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[1, 2], -1}, {0.5, -1}], 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(1\\)]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], {1, 1}, 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*SubscriptBox[\\(z\\), \\(2\\)]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[-1, 3], 
             Rational[1, 2]}, {-0.3333333333333333, 0.5}], 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], 
          InsetBox[
           FormBox[
            StyleBox["C", 12, StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[7, 2], 0}, {3.5, 0}], 
           NCache[
            ImageScaled[{
              Rational[3, 2], 
              Rational[3, 2]}], 
            ImageScaled[{1.5, 1.5}]]], 
          InsetBox[
           FormBox[
            StyleBox["z", 12, StripOnInput -> False], TraditionalForm], {
           4, 4.5}, 
           NCache[
            ImageScaled[{
              Rational[3, 2], 
              Rational[3, 2]}], 
            ImageScaled[{1.5, 1.5}]]], {
           Thickness[0.003], 
           LineBox[{{3.1, 3.9}, {3.1, 3.2}, {3.8, 3.2}}]}}, 
        FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
        GridLines -> {None, None}, GridLinesStyle -> Directive[
          GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 200, 
        Method -> {
         "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
            Directive[
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.95, 0.627, 0.1425], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.455, 0.7, 0.21], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.922526, 0.385626, 0.209179], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.578, 0.51, 0.85], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.772079, 0.431554, 0.102387], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.4, 0.64, 1.], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[1., 0.75, 0.], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.8, 0.4, 0.76], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.637, 0.65, 0.], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.915, 0.3325, 0.2125], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[
             0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
             AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
          "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
          Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
          "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
               Part[#, 1]] + I Identity[
                Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
               Part[#, 1]] + I Identity[
                Part[#, 2]]& )}}, PlotRange -> {{-4., 4.}, {-4., 4.}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
        Ticks -> {{}, {}}], 
       GraphicsBox[{{
          Arrowheads[0.2], 
          ArrowBox[{{0, 0}, {2, 0}}]}, 
         InsetBox[
          FormBox[
           StyleBox[
            RowBox[{"w", "\[LongEqual]", 
              FractionBox["1", "z"]}], 12, StripOnInput -> False], 
           TraditionalForm], 
          NCache[{1, 
            Rational[1, 2]}, {1, 0.5}], 
          NCache[
           ImageScaled[{
             Rational[1, 2], 
             Rational[1, 2]}], 
           ImageScaled[{0.5, 0.5}]]]}, {ImageSize -> 60, ImageMargins -> 40}], 
       GraphicsBox[{{{}, {}}, {}, {{}, 
          InterpretationBox[{
            TagBox[
             TagBox[{
               RGBColor[1, 0, 0], 
               PointSize[Medium], 
               AbsoluteThickness[2], 
               
               PointBox[{{0.4, 0.8}, {
                0.5, -0.5}, {-0.9230769230769231, -1.3846153846153846`}, \
{-0.8, 0.4}, {4., 0.}}]}, Annotation[#, "Charting`Private`Tag#1"]& ], {
             "WolframDynamicHighlight", <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
            StyleBox[
             DynamicBox[
              (Charting`HighlightActionBox["DynamicHighlight", {}, 
               Slot["HighlightElements"], 
               Slot["LayoutOptions"], 
               Slot["Meta"], 
               Charting`HighlightActionFunction["DynamicHighlight", {{
                  Annotation[{
                    Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]], 
                    
                    Point[{{0.4, 0.8}, {
                    0.5, -0.5}, {-0.9230769230769231, -1.3846153846153846`}, \
{-0.8, 0.4}, {4., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
                "HighlightElements" -> <|
                  "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
                 "LayoutOptions" -> <|
                  "PanelPlotLayout" -> <||>, 
                   "PlotRange" -> {{-4., 4.2}, {-4., 4.}}, 
                   "Frame" -> {{False, False}, {False, False}}, 
                   "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
                   "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                   Automatic, "DefaultStyle" -> {
                    Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                   "HighlightLabelingFunctions" -> <|
                    "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                   False|>, 
                 "Meta" -> <|
                  "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                   "Function" -> ComplexListPlot, "GroupHighlight" -> 
                   False|>|>]]& )[<|
               "HighlightElements" -> <|
                 "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
                "LayoutOptions" -> <|
                 "PanelPlotLayout" -> <||>, 
                  "PlotRange" -> {{-4., 4.2}, {-4., 4.}}, 
                  "Frame" -> {{False, False}, {False, False}}, 
                  "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
                  "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                  Automatic, "DefaultStyle" -> {
                    Directive[
                    AbsoluteThickness[2], 
                    RGBColor[1, 0, 0], 
                    PointSize[Medium]]}, 
                  "HighlightLabelingFunctions" -> <|
                   "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                    "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                  False|>, 
                "Meta" -> <|
                 "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                  "Function" -> ComplexListPlot, "GroupHighlight" -> 
                  False|>|>], 
              ImageSizeCache -> {{
               4.503599627370496*^15, -4.503599627370496*^15}, {
               4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
             False]}, 
           Annotation[{{
              Annotation[{
                Directive[
                 AbsoluteThickness[2], 
                 RGBColor[1, 0, 0], 
                 PointSize[Medium]], 
                
                Point[{{0.4, 0.8}, {
                 0.5, -0.5}, {-0.9230769230769231, -1.3846153846153846`}, \
{-0.8, 0.4}, {4., 0.}}]}, "Charting`Private`Tag#1"]}}, <|
            "HighlightElements" -> <|
              "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
             "LayoutOptions" -> <|
              "PanelPlotLayout" -> <||>, 
               "PlotRange" -> {{-4., 4.2}, {-4., 4.}}, 
               "Frame" -> {{False, False}, {False, False}}, 
               "AxesOrigin" -> {0, 0}, "ImageSize" -> {200, 200}, 
               "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
               Automatic, "DefaultStyle" -> {
                 Directive[
                  AbsoluteThickness[2], 
                  RGBColor[1, 0, 0], 
                  PointSize[Medium]]}, 
               "HighlightLabelingFunctions" -> <|
                "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                 "ScalingFunctions" -> {{Identity, Identity}, {
                   Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
               False|>, 
             "Meta" -> <|
              "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
               "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
            "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, \
{}}}}, AspectRatio -> Automatic, Axes -> True, AxesLabel -> {
          FormBox[
           StyleBox[
            RowBox[{"Re", "(", "w", ")"}], 12, StripOnInput -> False], 
           TraditionalForm], 
          FormBox[
           StyleBox[
            RowBox[{"Im", "(", "w", ")"}], 12, StripOnInput -> False], 
           TraditionalForm]}, AxesOrigin -> {0, 0}, DisplayFunction -> 
        Identity, Epilog -> {{
           RGBColor[0.368417, 0.506779, 0.709798], 
           CircleBox[{0, 0}, 
            NCache[
             Rational[2, 7], 0.2857142857142857]]}, {
           PointSize[Medium], 
           RGBColor[0.5, 0, 0.5], 
           PointBox[{0, 0}]}, 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(0\\)]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[2, 5], 
             Rational[4, 5]}, {0.4, 0.8}], 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(1\\)]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[1, 2], 
             Rational[-1, 2]}, {0.5, -0.5}], 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], 
          InsetBox[
           FormBox[
            StyleBox[
            "\"\\!\\(\\*SubscriptBox[\\(w\\), \\(2\\)]\\)\"", 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[-12, 13], 
             Rational[-18, 13]}, {-0.9230769230769231, -1.3846153846153846`}], 
           NCache[
            ImageScaled[{
              Rational[1, 2], 1}], 
            ImageScaled[{0.5, 1}]]], {
           RGBColor[0.368417, 0.506779, 0.709798], 
           Arrowheads[0.05], 
           ArrowBox[
            NCache[{{
               Rational[2, 7], 0.2}, {
               Rational[2, 7], -0.2}}, {{0.2857142857142857, 0.2}, {
             0.2857142857142857, -0.2}}]]}, 
          InsetBox[
           FormBox[
            StyleBox[
             SuperscriptBox["C", "\[Prime]", MultilineFunction -> None], 12, 
             StripOnInput -> False], TraditionalForm], 
           NCache[{
             Rational[-1, 2], 
             Rational[-1, 2]}, {-0.5, -0.5}], 
           NCache[
            ImageScaled[{
              Rational[1, 2], 
              Rational[1, 2]}], 
            ImageScaled[{0.5, 0.5}]]], 
          InsetBox[
           FormBox[
            StyleBox["w", 12, StripOnInput -> False], TraditionalForm], {
           4, 4.5}, 
           NCache[
            ImageScaled[{
              Rational[3, 2], 
              Rational[3, 2]}], 
            ImageScaled[{1.5, 1.5}]]], {
           Thickness[0.003], 
           LineBox[{{3.1, 3.9}, {3.1, 3.2}, {3.8, 3.2}}]}}, 
        FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
        GridLines -> {None, None}, GridLinesStyle -> Directive[
          GrayLevel[0.5, 0.4]], ImagePadding -> All, ImageSize -> 200, 
        Method -> {
         "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
          "DefaultGraphicsInteraction" -> {
           "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
            "Effects" -> {
             "Highlight" -> {"ratio" -> 2}, 
              "HighlightPoint" -> {"ratio" -> 2}, 
              "Droplines" -> {
               "freeformCursorMode" -> True, 
                "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
          "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
            Directive[
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.95, 0.627, 0.1425], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.455, 0.7, 0.21], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.922526, 0.385626, 0.209179], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.578, 0.51, 0.85], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.772079, 0.431554, 0.102387], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.4, 0.64, 1.], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[1., 0.75, 0.], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.8, 0.4, 0.76], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.637, 0.65, 0.], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.915, 0.3325, 0.2125], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[
             0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
             AbsoluteThickness[2]], 
            Directive[
             RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
             AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
          "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
          Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
          "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
               Part[#, 1]] + I Identity[
                Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
               Part[#, 1]] + I Identity[
                Part[#, 2]]& )}}, PlotRange -> {{-4., 4.2}, {-4., 4.}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
        Ticks -> {{}, {}}]},
      "RowDefault"]},
    {"\<\"Fig. 3. The contour of integration under \
\\!\\(\\*FormBox[RowBox[{\\\"w\\\", \\\"\[LongEqual]\\\", FractionBox[\\\"1\\\
\", \\\"z\\\"]}], TraditionalForm]\\).\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1797757395,ExpressionUUID->"daf1eb1b-2221-4f30-9ae8-fa7f47433268"]
}, {2}]],

Cell[TextData[{
 "This change of variables maps the circle ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "9773983d-a6d3-4c91-a03b-628047842b11"],
 " of large radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1c362073-fdef-47d7-8cf5-2b2f4d0c9e19"],
 " traversed counterclockwise (Fig. 3) to the circle ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "'"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8b6225be-5ce7-44d7-a4e2-351dd27338d0"],
 " of small radius ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "R"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "a1a6cf94-7aab-4928-b99a-b0bb2a1d8a5f"],
 " traversed clockwise. Also, it maps the poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cfcd5acc-24a7-49c7-ac4b-1ba5ca20fecb"],
 ", which are all inside ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "343b3e20-5786-4497-8507-ee9c2fc2f2e7"],
 ", to poles of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "w", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1cbd5c97-a617-4d3c-a177-4942d0953988"],
 ", which are all outside ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "'"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c2260e53-7eda-438f-8691-2d2c183c2afe"],
 ". So:"
}], "Text",
 CellID->139843979,ExpressionUUID->"1ad3feb9-b796-415f-8601-f11bd3ca49bf"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    UnderscriptBox["Res", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]]}], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", 
       RowBox[{"C", " ", "'"}]], 
      RowBox[{
       RowBox[{"f", "(", 
        FractionBox["1", "w"], ")"}], 
       FractionBox["1", 
        SuperscriptBox["w", "2"]], 
       RowBox[{"\[DifferentialD]", "w"}]}]}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->227341360,ExpressionUUID->"0b8685e4-ca61-4786-806f-b2f088f0a4c2"],

Cell[TextData[{
 "By the residue theorem, since this last integral encloses only the \
singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"w", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1b6fc353-6de2-46eb-a990-cb68e3ac96cb"],
 ":"
}], "Text",
 CellID->692025257,ExpressionUUID->"46270e26-0e3e-4cc5-b306-82640eda99a3"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", 
      RowBox[{"C", " ", "'"}]], 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["w", "2"]], 
      RowBox[{"f", "(", 
       FractionBox["1", "w"], ")"}], 
      RowBox[{"\[DifferentialD]", "w"}]}]}]}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      UnderscriptBox["Res", 
       RowBox[{"w", "->", "0"}]], "[", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["w", "2"]], 
       RowBox[{"f", "(", 
        FractionBox["1", "w"], ")"}]}], "]"}]}], "=", 
    RowBox[{"-", 
     RowBox[{
      UnderscriptBox["Res", 
       RowBox[{"z", "->", "0"}]], "[", 
      RowBox[{
       FractionBox["1", 
        SuperscriptBox["z", "2"]], 
       RowBox[{"f", "(", 
        FractionBox["1", "z"], ")"}]}], "]"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->402971688,ExpressionUUID->"befee305-c55f-4454-a292-bc59816052e1"],

Cell[TextData[{
 "where the minus sign comes from the orientation of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", "'"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "49291b85-6719-4bbe-b94c-41b5ce46cd80"],
 ", and the last equality is just a relabeling of ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]], "InlineMath",ExpressionUUID->
  "95df38bf-aa5b-4a73-bed5-11ca69c39021"],
 " with ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath",ExpressionUUID->
  "8d423395-9d2a-4a24-b694-18d7e4552ec5"],
 ". This proves Eq. (6)."
}], "Text",
 CellID->348274579,ExpressionUUID->"a7daf961-714f-469b-8894-3d08b7490ca5"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->185748738,ExpressionUUID->"89c78765-99bd-447d-94a2-ae9febd2a390"],

Cell[TextData[{
 "Consider ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"8", "z"}], "-", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "4"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ba839bcd-8ab5-4ddd-84a6-0e088e36f7f2"],
 ". Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6d5c65f0-5cb9-4262-b57c-c4b523740d09"],
 " for a circular contour of radius 5 centered at the origin."
}], "SolvedExampleNote",
 CellID->232675498,ExpressionUUID->"2016124b-40cf-46ae-a2ce-fe8b48ae2672"],

Cell["\<\
Here is a plot of the function and the contour, with the poles marked in red.\
\
\>", "SolvedExampleNote",
 CellID->257756963,ExpressionUUID->"45af5cf6-746c-48c8-a66d-514efee8d0fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", "z"}], "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "4"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "8"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1208", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {{
        Style[
         RGBColor[
          Rational[1, 3], 
          Rational[1, 3], 
          Rational[1, 3]], LightDarkAutoColorRules -> {}], 
        Arrow[
         Circle[{0, 0}, 5]]}, {Red, 
        Point[{{1, 0}, {-4, 0}}]}}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->202706237,ExpressionUUID->"371138d1-1b7d-4d74-ac5a-3ac87c68516a"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GDMyyITBHEiUyxGlcMQ5NxiivWCQaTMmynzrhiMFothlVB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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJw028dzKt27L/ZT9sRD/wueeXanntyBhy57dM55f2/YOUlbOeecExIo55wQ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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{{
     StyleBox[
      RGBColor[
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333], 
       NCache[
        Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}},
       StripOnInput -> False], 
     ArrowBox[
      CircleBox[{0, 0}, 5]]}, {
     RGBColor[1, 0, 0], 
     PointBox[{{1, 0}, {-4, 0}}]}},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->94734540,ExpressionUUID->"20a51321-c8d3-4d46-8bc7-d29a2a0506bd"]
}, Open  ]],

Cell["One can compute the integral as:", "SolvedExampleNote",
 CellID->253028289,ExpressionUUID->"b597212a-8ae0-404c-b9cc-4d546292d659"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "\[Pi]", " ", "\[ImaginaryI]", " ", 
    SubscriptBox["Res", 
     RowBox[{"z", "->", "\[Infinity]"}]], 
    RowBox[{"f", "(", "z", ")"}]}], "=", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
    RowBox[{
     SubscriptBox["Res", 
      RowBox[{"z", "->", "0"}]], "[", 
     RowBox[{
      FractionBox["1", 
       SuperscriptBox["z", "2"]], 
      RowBox[{"f", "(", 
       FractionBox["1", "z"], ")"}]}], "]"}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     RowBox[{
      SubscriptBox["Res", 
       RowBox[{"z", "->", "0"}]], "[", 
      FractionBox[
       RowBox[{"8", "-", "z"}], 
       RowBox[{
        RowBox[{"z", "(", 
         RowBox[{"z", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", "z"}], "-", "1"}], ")"}]}]], "]"}]}]}]}], 
  TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{"16", "\[Pi]", " ", 
     RowBox[{"\[ImaginaryI]", "."}]}]}]}], 
  TraditionalForm]}],ExpressionUUID->"82ecb692-12eb-4dde-a359-705a08a9383d"]],\
 "SolvedExampleNote",
 CellID->223052188,ExpressionUUID->"f3a31301-1424-4f17-8bd4-a9d4724ea4cf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"Residue", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"8", "z"}], "-", "1"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "+", "4"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "\[Infinity]"}], "}"}]}], 
   "]"}]}]], "SolvedExampleInput",
 CellID->19313273,ExpressionUUID->"480c9b0c-3192-422f-b9e6-21136db68656"],

Cell[BoxData[
 RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->35630068,ExpressionUUID->"5fbd38d6-f04f-4516-b5aa-6b0e0c1041e7"]
}, Open  ]],

Cell[TextData[{
 "Alternatively, one can compute it as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "1"}]], 
       RowBox[{"f", "(", "z", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", 
         RowBox[{"-", "4"}]}]], 
       RowBox[{"f", "(", "z", ")"}]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"9021b0f3-6589-4499-b539-35d507475542"],
 ",\nwhich in Wolfram Language can be done by:"
}], "SolvedExampleNote",
 CellID->78982045,ExpressionUUID->"c9328111-27ca-4e03-a90a-c38b0074dbaf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Residue", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"8", "z"}], "-", "1"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"z", "+", "4"}], ")"}]}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1"}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"8", "z"}], "-", "1"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"z", "+", "4"}], ")"}]}]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "4"}]}], "}"}]}], "]"}]}], ")"}]}]], "SolvedExampleInput",\

 CellID->448410397,ExpressionUUID->"eeafb6eb-27db-4589-9322-acd06ac8d27e"],

Cell[BoxData[
 RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->25404056,ExpressionUUID->"266234e8-354e-4199-8ef2-b1362e2f283f"]
}, Open  ]],

Cell[TextData[{
 "Or with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->146586059,ExpressionUUID->"e38846ac-abf2-406f-9fd6-41f058f9f922"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"8", "z"}], "-", "1"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "+", "4"}], ")"}]}]], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->112433444,ExpressionUUID->"8a848108-3570-4096-a851-ebb6a5728c08"],

Cell[BoxData[
 RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->90008991,ExpressionUUID->"ef0a8d92-7b8f-497c-98ea-5674a81fa40f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->261949398,ExpressionUUID->"167f87ad-768c-4255-9b19-350d61187377"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->259668533,ExpressionUUID->"8b516b74-ea4d-4843-bff2-0d90c8165f99"],

Cell[TextData[{
 "Compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"cos", "(", 
      RowBox[{"2", "-", 
       RowBox[{"1", "/", "z"}]}], ")"}], "z"]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"6100ba31-6d2e-41b7-9ee1-9c90ea7802a0"],
 " over the contour in the figure."
}], "SolvedExampleNote",
 CellID->123650846,ExpressionUUID->"cf33804c-88b5-44da-a7f8-30d12a0c9bdc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "-", 
      RowBox[{"1", "/", "z"}]}], "]"}], "/", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      RowBox[{"2", "I"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"2", "I"}]}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["3", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["4176", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Circle[{-(1/2), -1}, 1/2, {0, Pi/2}], 
       Circle[{-(1/2), -1}, 3/2, {0, Pi/2}], 
       Line[{{0, -1}, {1, -1}}], 
       Line[{{-(1/2), -(1/2)}, {-(1/2), 1/2}}], 
       Arrow[{{1/2, -1}, {11/20, -1}}]}, FrameStyle -> Directive[12], 
     ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->309295465,ExpressionUUID->"8c3ca584-dc34-4f16-b499-18b2721066e9"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd2zHolVUYx/GTVrgUubpEtEVDg4uBdFocKwqiJcjAoaVE2lxtEVwiHBoc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx82WVUXOua6Pse937p03q7+9xzW/ZacXeBABEiuFsV7u7u7g4hSLCgwd0J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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJxt2zGoZFcdx/FBm+DabBtEEFtLeaSR6YTdLIhWttFVYiXYhoQUaQXTJMZC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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    CircleBox[
     NCache[{
       Rational[-1, 2], -1}, {-0.5, -1}], 
     NCache[
      Rational[1, 2], 0.5], 
     NCache[{0, Rational[1, 2] Pi}, {0, 1.5707963267948966`}]], 
    CircleBox[
     NCache[{
       Rational[-1, 2], -1}, {-0.5, -1}], 
     NCache[
      Rational[3, 2], 1.5], 
     NCache[{0, Rational[1, 2] Pi}, {0, 1.5707963267948966`}]], 
    LineBox[{{0, -1}, {1, -1}}], 
    LineBox[
     NCache[{{
        Rational[-1, 2], 
        Rational[-1, 2]}, {
        Rational[-1, 2], 
        Rational[1, 2]}}, {{-0.5, -0.5}, {-0.5, 0.5}}]], 
    ArrowBox[
     NCache[{{
        Rational[1, 2], -1}, {
        Rational[11, 20], -1}}, {{0.5, -1}, {0.55, -1}}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameStyle->Directive[12],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->226631966,ExpressionUUID->"bfa00dbe-c6b8-4e12-9152-1abfcce8a12a"]
}, Open  ]],

Cell[TextData[{
 "The function has an essential singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "14a0c41a-f76b-46c1-8041-2d1a5a0ca13c"],
 ", which is inside the curve. Let\[CloseCurlyQuote]s use the residue at \
infinity to calculate the integral:"
}], "SolvedExampleNote",
 CellID->100420980,ExpressionUUID->"e5781d5f-b07a-4003-862e-b85be52aebd4"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[ContourIntegral]", 
     RowBox[{"\[ThinSpace]", "C"}]], 
    RowBox[{
     RowBox[{"f", "(", "z", ")"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", "\[InvisibleSpace]", 
     SubscriptBox["Res", 
      RowBox[{"z", "->", "\[Infinity]"}]], 
     RowBox[{"f", "(", "z", ")"}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", "\[InvisibleSpace]", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "0"}]], "[", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["z", "2"]], "\[CenterDot]", 
        FractionBox[
         RowBox[{"cos", "(", 
          RowBox[{"2", "-", "z"}], ")"}], 
         RowBox[{"1", "/", "z"}]]}], "]"}]}], "=", 
     RowBox[{
      RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", "\[InvisibleSpace]\[InvisibleSpace]", 
       SubscriptBox["Res", 
        RowBox[{"z", "->", "0"}]], 
       FractionBox[
        RowBox[{"cos", "(", 
         RowBox[{"2", "-", "z"}], ")"}], "z"]}], "=", 
      RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", "\[InvisibleSpace]", 
       RowBox[{
        RowBox[{"cos", "(", "2", ")"}], "."}]}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"818b38f8-ce20-4046-adb1-e98e3018ecf8"]], \
"SolvedExampleNote",
 CellID->306463872,ExpressionUUID->"2beadbfe-e913-4229-88b6-083bcd5059d5"],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->19037616,ExpressionUUID->"186e4bfe-c446-42ef-bc29-21d47813f581"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", "-", 
      RowBox[{"1", "/", "z"}]}], "]"}], "/", "z"}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Annulus", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"3", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->217839025,ExpressionUUID->"8554f2ab-696e-40a4-b1b6-88e8b869e89e"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
  RowBox[{"Cos", "[", "2", "]"}]}]], "SolvedExampleOutput",
 CellID->119671527,ExpressionUUID->"a343259f-5de7-455e-b396-0cbc3cb09ab1"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1145953135,ExpressionUUID->"4997a06a-1a70-40e6-905a-2c135ce565f7"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"47891946-93e3-45b0-9e05-dadb98feea85"],

Cell[TextData[{
 "The residue theorem states that the integral over a closed contour is equal \
to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], ")"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "203b110d-4980-4b55-856d-b5f5dd939a35"],
 " times the sum of the residues at the singularities inside the curve:"
}], "SummaryList",
 CellID->108924727,ExpressionUUID->"fd49aa90-8e52-4189-a1c9-ca9f41cb4562"],

Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{"f", 
      RowBox[{"(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     RowBox[{
      UnderscriptBox["\[Sum]", "i"], " ", 
      RowBox[{
       UnderscriptBox["Res", 
        RowBox[{"z", "->", 
         SubscriptBox["z", "i"]}]], 
       RowBox[{"f", "(", "z", ")"}]}]}]}]}], "DisplayFormula"], 
  TraditionalForm]], "DisplayFormula",
 CellID->565877318,ExpressionUUID->"e8ac0a9a-fa5e-4531-8f22-b81378d7e4d4"],

Cell["\<\
The sum of all residues at finite singularity and the residue at infinity is \
zero.\
\>", "SummaryList",
 CellID->391990311,ExpressionUUID->"5a86741a-2b9b-42c7-81ea-f0758383179f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->164711212,ExpressionUUID->"61b93e3f-866e-4acc-8a73-a231d59c7f60"],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"sin", " ", "z"}], 
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "+", "3"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", "2"}], ")"}]}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e337952f-cf30-4b00-b8ef-1d1f6520cf1a"],
 " along the path shown in the figure, an ellipse with semiaxes 1 and 3 \
centered at zero:"
}], "Exercise",
 CellID->82742474,ExpressionUUID->"d0173997-3372-40aa-b41d-f4a5add1b920"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    RowBox[{"Sin", "[", "z", "]"}], 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "+", "3"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ComplexPlot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "4"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1272", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Circle[{0, 0}, {1, 3}], 
       Arrow[{{1, 0}, {1, 1/10}}]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]}], "ExerciseInput",
 CellID->13239756,ExpressionUUID->"a02a9352-04a6-4dd8-9ff7-e7395a8c33e0"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GXOVARReuKiNW4YhiajFO0WCcYTMqwnTrjisFotRhWBUG3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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxkuHdUlPue5tvr3n/unTVzu6fndO8+p8/ZW93msM2JnEFQDKCiooKKCIiK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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL
xd0dSpGi5T17zfOt9f2xV0/3nXNmZj/DhVSytO4R2d0fEBBQ1QsIiGF/9Zn0
95lNmajto4AseKq1LghPdUxTVjzVsUzZ8FTHNmXHUx3HlANPdVxTTjzV8UzB
eKrjm3LhqU5gyo2XxpTWVMxUlDqdqTheIlNiUz5TXuokphA81UlN+fFUJzMV
wFOd3FQQT3UKUyE81SlNoXiqU5kK46lObSqCl5ozF8XTXRKa8nCnhJw5L57u
EmgqwZ2CuXe4qbIpvSmDqZSpJHVG0zd4meBWxlSaWtzK4mWBWzm8ILiVx8sK
twp42eAWhpcdbhXxcsCtEl4o94401eEu6TlrCe6ie1fhTrm5d1W8PGRRDS8v
3Krj5YNbDbwQuNXEyw+3WngF4BaBVxButfEKceY6eDnJvDJ3Kgy3utypCCzr
4anWu4vCK849G5jqU+vuDfHKk2NLUwt6i7M2irXi2IieUrBtjFcWTs1NzajL
M0teaTg3NTVhL3FqxZ5lmNGMNWFwa82aGuTWxdSZDJRFW1MbanFrhxcOt/Z4
VeDWAa8anDqZOjK3q2miaQJ71cLrQi0u3fCqc6bOzKjImdpw5gi4daenNix7
4NWBW0+8unDqbepFrdz74EXBoi9efbj1w2sAl/54DeEyAK8RrAbiNSHnwaZB
1Mp+CF4zuA3Fi+SMvThzc9gOY01LOA03RZOBshhpGkEtLqPwWtATzYxW9Ixg
RmdyF4vx9IrjaGa0h+VY0xhqcRyH1xEu3+J1YuZ4vHbMGMNMvY1q9HWAsbhN
CnBvYotpq+m86S8YitsU02Rq5TIVrydZTcPrBcfpeL3hOAOvDxxn4vWF43d4
/eA4C68/HGfjDYDt93hjuffPpqXUuvcyvCFw+8E0j1oc5uMNg82PeNFw+Qlv
OKwW4I2A60K8kXBahDeKnBfjjSb7JXhjOPNSPL1JvcO5pjnUQzjrXO4ilsu5
0yzuvdH0W4B7N+K20rSCWixX4U2C22q8yXBbgzcFbr/gTYXbWrxpcFuHNx1u
v+LNgNt6vJlw24C3iHvvNe3hLhM463LuIpabuNMc7q13uJlaWWzFmwe3bXg/
wG073ny47cD7EW478X6C2y68BXDbjbeQM+/B+47Mf+NOi+G2jzstgeV+PNV6
dwfwlnHPQ6aD1Lr7Yby15HjKdJLeZaw9wFpxPELPSjgexVsDpxOm49RrmXWC
teJ8jJ51cPqdPVcz4zhrfoXbadZsJ7dLpotkoCz+MJ2hFrc/8TbC8izeZrjp
u+QczMTpQoD7jtF3j75j9C4nsZe4XGbPnXC5greNM11kxnrOdIYz74LbVXp2
w/Ia3h64XcfbB6ebphvUyv0W3gFY3MY7CLc7eIfgchfvMFzu4R0h9/t4R8n5
Ad4xsn+Idxxuj/D2csYbnPkEbB+z5hScnpqekIGyeG56Ri0uL/BO0vOEGb/T
84wZF8n9nektveL4khnnYPmP6RW1OL7GOw+XN3gXmPkWT7P0Nv5m5iW4/sue
l+H2Hu8K3D7gXSOHT6aP1MrmM949cvXsByu/z/VeY+0H1orrF3puwvU/vDtw
8+kHM5+rNVOz5N2C+1d67sMths/teZsZ6v3KZ+IY0+fWvOTuiaxO6HMMxSG2
1bF8rhabOD7nPYFLXJ/znsIqns95z+GSwOr4zNTsvKY8PsdIXJJYndjnanFJ
6nPeCzioTzMe8q50Fp35Ge9Gs7Xnazgm87kZb+GWwurkPsdIOae2OpXP1co+
jc95AeSYyZTR5xirR2tT+txacUzrcz2f4JTO57z/yD6D1enJOIBZ8j7DMdDn
et7xjjRbZ3zDW9RZk3EWsc3MmeKRYy5TMBkoi2ymrNTikh3PD/cszIhBj9YG
sVbcctATB2458eKTe272TADDPHhxOVMwPR57BLHnb6aNpj9Nf8BYXENM+WCk
exYw5YeRcihkKkitbELxAsm1pKkEvclZW4C1YlWYnlRwLYKXltyLm4pRBzKr
OGvFtSg96eFWij3TMKMYazLA9hvW5CCHSqaKMFPuZUylqZVLWbwsZFUOLwg2
5fGywSXMVIHskpJVCHsp+8rsGQyncLzsnKkiMzJyptKcORccq9CTG7ZV8VTr
12o1vBD2rmmqQa3ca+EVgEUEXkG41cYrBJc6eKFwicQrTO518YqQcz28omQf
hVcMbvXx8nFGna06n4ltA9aUhFMjU0MyUBZNTI2pxaUpXgl6GjKjFD2NmfGF
71m9k0B6xbEZM8rBsoWpObU4tsSrAJdWeGGwao1XlhnNmVkRzm1YUwnObfEq
w7EdXlXYdTR1IBNl09nUiYyVay9TT5hXZW171oprF3pqwrUrXm249TB1p45k
Vg/Wins3elpyr+GmaD6rTW83ziKuvTlTU+49xDQYBmLR39SPWhwG4NXjHfRh
Rn16tLYva8VuID2N4TwIrxlZD2XP5nAahteEMw2mJ4o9+rJnC+4YTU8rOI3g
zoOZO880F2biNMo0klrsRuO1g8MYvPawGYvXAbbj8DrBabzpW2pxmoDXBQ4T
8bqS+yS8brCYjNeaM47kDt3hOoU1PeE0zTSVzJXDDNN0amUzE68HPVOZ0Yue
6cwYQs4/kFFf2H3HjP5wm22aRS1u3+MNhMscvEFkPhevHzNmMXODz/0epd+b
zrC3uM3nDItMi017TXvIQFksNC0gU+W4wrScWjmuxBtOj9b+5HPvYjj1j8wa
xT4LYTaeWctgLs5LOMcovMX0TITTKvbUG9Bb+Nm0lM/EaTVrZpHTRu49BRa/
mNZQi8NavOlw+9W0jllTWLuatdP5bC1rxWk9PbPhsIk9Z/6/3LVG31X6ztG7
bsdnszjbBu4+lrssYZY4bmbmHNhuwZtPrjtM26mV9U68pWRzwLQfxvNZu421
YrWLngVw2Y23mHPs87k3sYSZ+/EWwmUPPfPYQ7O3wlRsD5kO+twbEbcjpsPk
qNx+N50iY2V93HSM3hWsPcTd5zF7C4xXs/aoz73laHKYz16r+OwIjMXtpOkE
e4vLac6wHg5n8NZyxlP0rGHGCc6oP7vozyz6fa08zMXprM/9GfCi336mMr0z
vfU7Zjr3X6Zz1LrLebytZHcBbxusLuJth+slvB1wu4y3E25X8HbB5Sreblhd
w9sD1+t4p8jhqekJtXJ4hifueku3TDdhKi53TLepxeou3mFyv4d3BBb38Y7C
7gHeMXJ9iHecrB/hnYDDY7yTnPkJnu6id3mDO+3jzDfxTsP2OXe6yr0/mj74
3PeiuL00vaAWy7/xzsLtFd45uP2D9xfcXuOdh9sbvAtwe4t3EW7v8C7B7V+8
y3B7j/eQe8eytxTT7+7yB2d9zl1070/c6Tr3/ox3gyy+4N2E5X94t+Gmf/H5
lVrcfH7n3YWb3++8e3Dz/M67D7cYfuc94Mw6q7wrZP6BOz2CW2y/u9NjWMbx
O0+13l1cv/Oecc/4Vsfzu1p3T+B33htyTG51Mr/rVY/WasYLOCb0u56XcEzk
d94/cEpqdRK/qzVTs+T9DefEftfzFk4p/G7PV3BXr9a8g1tKv1sTQG6ZTBn9
LgNlkdrqVH5Xi1sav/M+wi2t33mf4JbO77wvsEtvdSBzM5vKmEqzlx8vE7W4
ZMH7CmudJYPfnVVn0llSslbcguiJwbvLihcTbtnwYsMphyk7tXLPiRcXbsF4
8eCWCy8+XHLjJYBLHryE5J4XLxE558NLDLcQvCRwy48XizNm58xJeScFWJMc
ToVMBclAWRQ2hVKLSxG8ZPQUZEYKekKZkZHcxeIbesWxKDPEUCyLm4pRi2MJ
PNViWxIvAzM1qxSz0tKrmZ/5dRzIrMxwK8ub6GTqbBpv+haG4lbeVI5auVTA
y0ZWYXjZ4VgRLwccK+HlhGNlvGA4huPlgmMVvNxwrIqXB47V8Ipz7wam+tTK
oiFeCNxqmmpQi0MtvAKwicArCJfaeIVgVQcvFK6ReIXhVBevCDnXwytK9lF4
xThzfTzdRe+wOnfKx5lr4JWCZWNTIzLQvTuY2vvduxG3pqYm1GLZDK8s3Jrj
lYNbC7zycGuJVwFurfDC4NYaryLc2uBVgltbvMpwa4dXl3v3NvXiLqU5a2Pu
ont35E7VuHcnvOpk0RmvBty64NWEW1e8WnDrhhcBt+54teHWA68O3HriRXLm
XnjhZN6eO9WDWx/uFAXLvniq9e764TXingNNA6h190F4rchxhGk4vXq7/ZnR
BI6D6WkKxyF4LeAUbRpG3YpZ0awV56H0tIbTSPZszoxhrGkDt1Gs6Upuk0wT
yUBZjDGNpha3sXgd4DYOryPcvsXrDKcJfvcdo+8efcfoXZZlL3GZzJ7d4TIF
rwtnmsiMtpxpNGfuAbep9PSE5TS8XnCbjtcHTjNNM6iV+3d4/WAxC28A3L43
zaYWlzl4g+AyF28wuc/DG0LOP+ANJfv5eMPg9iNeb844gzNHw/Yn1oyA00LT
AjJQFotNi6jFZQnecHoWMGMkPYuYMZHcV5lW0iuOS5kxDpbLTD9Ti+NyvPFw
WYE3gZkr8cYy42dmToLravacDLc1eFPg9gveNHJYZ1pLrWx+xZtLrltNW+id
xtpfWCuu6+mZCdcNeN/DbbNpE/VcZm1mrd7Cb/TMg9s29pzNDPVu5DNx3M6a
pdz9gGk/DMVhp2kHtdjswlsAl914C2G1B28xXPaZ9jJTs2+ZbrKXuBzEXwaX
Q3hLONN+ZsznTDs48yL22Muey+F4mBkr4XbUdARGyvmE6Ti1sj+Jt4kcz5nO
wngNa4+xVhxP0bMOTr/jbSD7P0xnyHgTs/5krTiepmcVexzjjCs48xHusBm2
f3GmPdz1uukaGSgL/Yx+kVpcLuNtgft5ZmyjR2svsFbcrtCzC25X8faS+w32
3AeLm3i7OdM1erayxwX21D9L2MzPmfrZ8wBcb/MGDnHPu6Y73Fs53Dfdo1Y2
D/BOk+tz0zN6j7D2LmvF6iE9x+H6CO8UuT81PaE+zaynrBXXx/ScgeUL9jzJ
jCes+RO2f5tekply+GB6DzPl/o/pFbVyeY13nqze4F2AzVu8S3D51+/+GcxB
MrtDhlfJ/iN7XoPTJ7zLnOk9M85yplec+TocP9NzA7Zf8G7C6T+82+yt/5D4
K7Vy93nOuwsLv+e8e3DzPOfdh0sMz3kP4BLTc95Dco/lOe8ROcf2nPeY7ON4
znsCt7ie825xxq+c+Sls43luzXNYJrA6vucyUBaJrU7kuVpcknjOewZ3rdWM
l+SmtQk992t5A+/kNL3imNRzM97AMrnVyTxXi2MKz3nv4JLSc96/sErlOe81
70C9mvkezqk9t+YDnNN4zvsIx7Se876QQ3qrAz1XK5sMnvNikms2U1bPMVeP
1qaDsbhm9FxPAFwz4XlwCzJloY7JrCDWintmelJwr1BTIT7z6M3MWcQ1O2dK
wr3zm0JgIBa5TMHUYpkbLzbvIAcz4tKjtTlhJnZ5TXmoxTkfXlI4FWDPZHAq
iJeYM4XQE4c9crJncu5YiJ6UcCrMnUOYW9NUA2biVNRUhFrsiuGlhUNxvHRw
LIEXCMeSeOnhVAovA5y+wcsIh9J4mci9DF5mWJTFS8UZi3CHLHAtx5qscKpg
Kk/myqGiKYxa2VTCC6KnPDOy0RPGjPzkXIuMcsKuMjNywbqKKRyG4lbNc/8P
RF64VMfLR+Y18IKZEc7MtqZ2ptGmUewtbhGcoZ4pytTH1JsMlEVdUySZKsfG
pkbUyrEJXig9WlvHc+8ilLo2s4qyT12YlWJWQ5iLc33OURQvip7ScGrKniWY
od4GfCZOzVgTTnbtuXc5WLQwNacWh5Z4YXBrbWrFrHKsbcbaMD5ryVpxakNP
VTh0NHXgs//LXWs+8fuM3nVaPgvnbG25ewnuUp9Z4tiJmdVh2xkvgly7m7pR
K+seeA3Ipr+pH4wjWNuVtWLVk55IuPTCi+IcfT33Juozsx9eXbj0pqcme2h2
F/YW2wGcoTHcBpkGkqNyG2EaTsbKeqhpCL2NWTuAu9dkdmcYN2PtYM+95ULk
EMFeTflsEIzFLdo0jL3FZSRnaAOHUXgtOeNwepozYxhnFDe9rTGe+zX1P4uT
Py0=
          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    CircleBox[{0, 0}, {1, 3}], 
    ArrowBox[
     NCache[{{1, 0}, {1, 
        Rational[1, 10]}}, {{1, 0}, {1, 0.1}}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->1660285190,ExpressionUUID->"61b6ebb9-980f-46a3-aef9-ec40ba9193ca"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"b7f05265-2557-46bd-be10-72abf02203ac"],

Cell[TextData[{
 "The integrand\[CloseCurlyQuote]s poles inside the curve are at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     RowBox[{"\[PlusMinus]", 
      SqrtBox["3"]}], "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3441fb21-cf88-46d2-a4a5-b72c9bf03fca"],
 ". So one can compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{"2", "\[Pi]", " ", 
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"z", "->", 
          RowBox[{
           SqrtBox["3"], "\[ImaginaryI]"}]}]], 
        RowBox[{"f", "(", "z", ")"}]}], "+", 
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"z", "->", 
          RowBox[{
           RowBox[{"-", 
            SqrtBox["3"]}], "\[ImaginaryI]"}]}]], 
        RowBox[{"f", "(", "z", ")"}]}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a4eda543-a7f8-4c4a-acc5-9711957ce322"],
 ":"
}], "SolutionAnswer",
 CellID->244671311,ExpressionUUID->"929aface-8ab4-42a6-8b64-a848d7308337"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Residue", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{
          SqrtBox["3"], "\[ImaginaryI]"}]}], "}"}]}], "]"}], "+", 
     RowBox[{"Residue", "[", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", 
         RowBox[{
          RowBox[{"-", 
           SqrtBox["3"]}], "\[ImaginaryI]"}]}], "}"}]}], "]"}]}], ")"}]}], "//",
   "Simplify"}]], "ExerciseInput",
 CellID->121541095,ExpressionUUID->"56041476-7dd6-4938-896f-a434c181e2af"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Sinh", "[", 
     SqrtBox["3"], "]"}]}], 
   RowBox[{"7", " ", 
    SqrtBox["3"]}]]}]], "ExerciseOutput",
 CellID->7424240,ExpressionUUID->"762771de-0601-4c22-96bf-8649b9de0f02"]
}, Open  ]],

Cell[TextData[{
 "Check using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->198728578,ExpressionUUID->"871309b0-9d01-4269-9a13-88048e97bb9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]}], "]"}]}]}], "]"}]], "ExerciseInput",
 CellID->102171682,ExpressionUUID->"637ae7e4-e069-424d-909b-262d63ba7c22"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    RowBox[{"Sinh", "[", 
     SqrtBox["3"], "]"}]}], 
   RowBox[{"7", " ", 
    SqrtBox["3"]}]]}]], "ExerciseOutput",
 CellID->4833483,ExpressionUUID->"e13eb96f-005d-4e6d-bde8-b1dc40262704"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", "z"}]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"16b88afc-54bb-41d5-8777-d57c7e705f3d"],
 " over a circle of radius 2 centered at the origin:"
}], "Exercise",
 CellID->182838476,ExpressionUUID->"b6411d5b-d7b1-446a-b362-277b0db6a3a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "z"}], "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "4"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["816", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Arrow[
        Circle[{0, 0}, 2]]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "ExerciseInput",
 CellID->137000149,ExpressionUUID->"8eab33e3-950c-47f5-84b4-bafdd1a9eede"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GXOVARReuKiNW4YhiajFO0WCcYTMqwnTrjisFotRhWBUG3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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJx012eM5NiB4PnB3ZcD9sPetwEO2D3MYm/35jS7mLm91WilGWk0Gqlbaqml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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    ArrowBox[
     CircleBox[{0, 0}, 2]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->291433386,ExpressionUUID->"eb58d719-bf83-4968-ab7a-f12315156824"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"e5024fa9-0a99-4e93-b34e-2ebbbbcc5ce1"],

Cell[TextData[{
 "The integrand has two essential singularities located at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2f51cdb9-981a-4c3e-bbe6-768b112eff91"],
 ". Both are inside the curve. So the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"z", "->", "0"}]], 
        RowBox[{"f", "(", "z", ")"}]}], "+", 
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"z", "->", "1"}]], 
        RowBox[{"f", "(", "z", ")"}]}]}], ")"}], "."}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"14761eb7-b155-41e2-b36f-3c1349fc43e5"],
 " However, the residues at zero and one are hard to compute. So it is better \
to use the residue at infinity: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     RowBox[{
      RowBox[{"f", "(", "z", ")"}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "\[Pi]", " ", "\[ImaginaryI]", " ", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "\[Infinity]"}]], "[", 
       RowBox[{
        FractionBox["1", 
         SuperscriptBox["z", "2"]], 
        RowBox[{"f", "(", 
         FractionBox["1", "z"], ")"}]}], "]"}]}], "=", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "0"}]], "[", 
       FractionBox[
        RowBox[{
         SuperscriptBox["e", "z"], 
         SuperscriptBox["e", 
          RowBox[{"z", "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", "z"}], ")"}]}]]}], 
        SuperscriptBox["z", "2"]], "]"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"797434ff-7c81-4bf2-a184-d231588d38df"],
 ":"
}], "SolutionAnswer",
 CellID->35880266,ExpressionUUID->"f039e318-6f42-4682-84f6-e4ba96799bbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"Residue", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "z", "]"}], 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"z", "/", 
        RowBox[{"(", 
         RowBox[{"1", "-", "z"}], ")"}]}], "]"}], "/", 
      RowBox[{"z", "^", "2"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0"}], "}"}]}], "]"}]}]], "ExerciseInput",
 CellID->236599034,ExpressionUUID->"42fe072e-4393-41b1-bdcd-c31f8ee44641"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->319147006,ExpressionUUID->"c82f936d-0da9-4dc3-8273-76604d02e3ce"]
}, Open  ]],

Cell[TextData[{
 "The integral is therefore ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Pi]", " ", "\[ImaginaryI]"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"2c3f3f8d-630c-45bc-9ca4-816156153a5a"],
 ". Confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->103052096,ExpressionUUID->"71f71107-b13d-4cf3-97f5-0b6373f383e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "z"}], "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"z", "-", "1"}], ")"}]}], "]"}]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->248595258,ExpressionUUID->"ec7e2b76-f7a8-4d0d-9fac-4c14ee9c46a3"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->498827163,ExpressionUUID->"e7049902-b45d-43de-a78b-a1c676d5520d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "4"], "+", 
      RowBox[{"2", 
       SuperscriptBox["z", "3"]}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "2"], "-", "1"}], ")"}], "2"]]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "c11cf6ef-7082-4939-9569-94b50104ad59"],
 " over the path in the figure:"
}], "Exercise",
 CellID->4016190,ExpressionUUID->"73a4b274-e1b1-4c96-8a21-2d86acbb8e7e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "4"], "+", 
     RowBox[{"2", 
      SuperscriptBox["z", "3"]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["z", "2"], "-", "1"}], ")"}], "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], "/", "2"}], "-", 
      RowBox[{"2", "I"}]}], ",", 
     RowBox[{
      RowBox[{"5", "/", "2"}], "+", 
      RowBox[{"2", "I"}]}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["2112", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       RegionBoundary[
        Rectangle[{-2, -(1/2)}, {2, 1/2}]], 
       Arrow[{{0, -(1/2)}, {1/10, -(1/2)}}]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "ExerciseInput",
 CellID->16112824,ExpressionUUID->"543f84eb-6735-40a5-8238-118f5d604653"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd2zGoFXQUx/GXvcEpanWpcIuIhggaxP/kqFGLS4NBQ1MiTrk02BK8pcHR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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJyM2XdQXFmeL/iJ3X92Y2Jnunvem9fzpm1Vd1V3VXUZlbyE9x4h5JD33oCE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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx12zGIHNcBxvEhaUzkxq0IgZDWZThVZruADkGQqrS2Y4OrgFtjxYXbgN3Y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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    LineBox[
     NCache[{{-2, 
        Rational[-1, 2]}, {2, 
        Rational[-1, 2]}, {2, 
        Rational[1, 2]}, {-2, 
        Rational[1, 2]}, {-2, 
        Rational[-1, 2]}}, {{-2, -0.5}, {2, -0.5}, {
       2, 0.5}, {-2, 0.5}, {-2, -0.5}}]], 
    ArrowBox[
     NCache[{{0, 
        Rational[-1, 2]}, {
        Rational[1, 10], 
        Rational[-1, 2]}}, {{0, -0.5}, {0.1, -0.5}}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->1550213394,ExpressionUUID->"dbc77fce-51ec-411e-abb4-e1fe299d31ce"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"75c21cce-d9d7-4e07-bbff-924b6c3522f6"],

Cell[TextData[{
 "The integrand has poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"\[PlusMinus]", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1e8bb973-6fa5-402c-8cb6-efda31541c39"],
 ", both inside the contour. So the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{"\[ImaginaryI]", "(", 
     RowBox[{
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", 
         RowBox[{"-", "1"}]}]], 
       RowBox[{"f", "(", "z", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "1"}]], 
       RowBox[{"f", "(", "z", ")"}]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"eb1b30d5-fb4c-467e-be72-b4cd39750d1d"],
 ", which is:"
}], "SolutionAnswer",
 CellID->282354347,ExpressionUUID->"22b80174-a91b-4a11-b6f6-9a302572fb8c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Residue", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "4"], "+", 
        RowBox[{"2", 
         SuperscriptBox["z", "3"]}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "-", "1"}], ")"}], "2"]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["z", "4"], "+", 
        RowBox[{"2", 
         SuperscriptBox["z", "3"]}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["z", "2"], "-", "1"}], ")"}], "2"]], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1"}], "}"}]}], "]"}]}], ")"}]}]], "ExerciseInput",
 CellID->310648376,ExpressionUUID->"74f1665f-2fb9-4eb0-9682-1c94483fddab"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->512777348,ExpressionUUID->"de4c352b-87d0-46a0-ae03-790fe188f1d5"]
}, Open  ]],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->80047752,ExpressionUUID->"ebcc2e9f-0af2-4746-b9cf-7a4ff1b4f823"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "4"}], "+", 
      RowBox[{"2", 
       RowBox[{"z", "^", "3"}]}]}], ")"}], "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", "^", "2"}], "-", "1"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]}]}], "]"}]], "ExerciseInput",\

 CellID->90122048,ExpressionUUID->"685ffab7-8fa3-4bc0-8e6c-2214caa11f37"],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->177534748,ExpressionUUID->"3e3c9841-2459-4ecd-bd68-b5eeb36aa75b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"cos", "(", 
      RowBox[{"1", "/", "z"}], ")"}], "z"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5085e7a6-c6c6-4e14-b5c6-127ce8340e82"],
 " over the unit circle:"
}], "Exercise",
 CellID->77847676,ExpressionUUID->"26ed828d-44d3-48e3-9236-e0f99f4d77dc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"1", "/", "z"}], "]"}], "/", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "-", 
      RowBox[{"2", "I"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"2", "I"}]}]}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["1080", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], 
       Circle[], 
       Arrow[{{1, 0}, {1, 1/10}}]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "ExerciseInput",
 CellID->85005941,ExpressionUUID->"027e51fe-1c75-4df4-afad-8c8196a71e0b"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxd2zHolVUYx/GTVrgUubpEtEVDg4uBdFocKwqiJcjAoaVE2lxtEVwiHBoc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxU3EdQW1vb6Plb3ZMedlXPu+pO7qj7dnV973EkGxzJCAlJCAkhBMqAyDnn
nMEYbAzYxhlsosHknHMQyjlrbYmMT6+97fO9/VE/U+Dhv9Ze+3mg7P9OFwQy
/5f/9t/+m/B/g58Cw5Pc4+LCU4L+d/hNMF/IiuJHMp7w4yOjIuPu0P9X+JeM
P3/Qr2MKQGw+iMsHwjyQkAcSc0FSDkjOAanZIC0LpGeBzEyQlQGy00FuGshL
BfkpoDAZFCWBkkRQmgDKhKAiDlTGgGoBqOGBOi6oZ4OGaNDEBK2R1hcMy8sI
82u6sTvc8Jame0/VfgxTfwlV9ZOV34nyQYJsBC/5gROPB4om/I6nfA5nnh3M
Pd5b8Npd8thZdt9cdVtbc1ted13YcJ3ddJnecpnYdh7bcR7dcRredRrYu/9t
737f/v0vB/c+Htx7f3j33eHdN0d3e47udB3f6Ty+81J0u0N0+4Xo9vOTW60n
t5pPbjWJbzWK/6oX/1Un+atW8le15F9Vkn9VSv9VIf1XmfQ/SqX/USL9V7Hs
X0Wyv6BC2V8Fslv5slt5qNu58ts5gkKA5ioAwnwQn/8nV3IuSMFypWeDDCxX
dgbIwXLlp4KCFFCUDIqTQGkiKEsAFUJQGQeqY0CNANTxQD0HNLBAUxRoYdra
Ii0dDHNnhKmbbngbrn9P034K03yhqPpDld9J8qEQtNUYTvwzUDTpfzztezj7
7GD+8d6i1+6yx/aKx8aq++qa29K62/ym68yW69SWy89tlx87ziO7zoN7Tt/3
nPr3nb4e3P90cP/D4b3ew3tv0VB3u47vvj6+80p0p0N0B4ZqO7ndenK75U+o
W/XiW/+E+qtK8tfvUOXSf5VK/4WF+qv4T6hb/4S6nSfHQsnvZPOLAMwVWwji
YK4CNFdiHkjKQ3Ol5oC0HDRXZhbIygQ5GSA3A+Slg4I0UJgKipNBSRIoSwTl
CaBSCKriQE0MqOWDei5oYIOmaNASZWtjWjsizZ0MU3eE4S1d/z5c+4mq+RqG
thogy4eIslGCZCxY/DNINOV/PON7OPfsYOHx3hJs9WBr1WN9zWNl3X1xw31u
0216y21y23V8x2V012V4z3lgz/nbvlPfgdPnA6ePh/ffH95/d3TvzdG9bjTU
3Veiuy9Fd9pFd9pO7jyHocS3m8W3YagGNNStWsmtGhhKCkP9VSH9Cwv1VwlW
qVh2q0h2Cwt1Ox9WQkPdyZXfQUNBvGIAc8UUYbkKQXwBSIC58tFcKTBXLkjP
ARlYruwskJMJ8jJAfjooTANFqaAkGZQlgfJEUJkAqoSgJhbUxoB6PmjggiY2
aIkGbVHWDqalM9LUzTC+jdC/p+s+0TRfqepvFOVAqHyYJBsNkYzjxROwVQDW
ynsfa7Wz4rm1+mBt3WN5w2Nh0312y31q221ix21s13Vk13Voz+X7vnP/gfOX
A6dPh04fDp16j+6/Pbrfc3yv6/heJxrqbvvJ3RdoqDst4jtYqNsNktv/hLpV
Jb31T6i/SmUw1K1iTJHsdqHsNhbqDqz0T6i72fK7WRAXtioGguI/uYS/cxWA
pHyQnA9S80AaliszB2Rlg5wskJsJ8jNAQTooSgMlqaA0BZQngYpEUBUPaoSg
NhbUC0AjDzRxQAsLtEXbOqIsnUxzd6TxLcPwPkL3KVzzlab+FqYcpCiGybIf
RMk4QTyJE00HHs36Hc577y8+2Vv22ln13FzzXFt/sLTxYH7LY2bbfXLH/eeO
249dt+E918F9128HLn0HLp8PnT8eOr8/cnp35PTm+H738f3XonuvRPc60FB3
n5/cbUVD3WkS34Gh6iW3ayW3a6S3qtFQtyqkt8plMNQtqER2u1h2Gwt1p0B2
Jx+tdDcXg4W6l4XJ5JQAXsm/c8UVobkSCkEizFUAUrBc6XkgIxdk5YDsbJCb
BfIyQUEGKEoHxWmgNBWUp4CKJFCVCGriQa0Q1MeCRgFo4oEWDnjOsnVEWzuj
zN1M07tIwweG7jNd2xeu/kZVDoYpRkJlP0iSn7BVsGgm8GjO73DBe3/pyd7K
w+1Vr411r9UNz6XNB3NbD6a3PSZ2PMZ33Uf33Ib23b7vu/YfuH45dPl06PLh
yLn32PnNsVO3yOm16P4r0f2Ok3vtJ/faxDDU3Rbx3SYJDHWnXnIHC3W7Wnr7
n1C3ymS3S2W3sVB3imR3CuV3CuR38+V3/wl1L0d+759Q9zMV9zPYpYBbiuUq
ATHFILYYzRVfhOUqBMlYrrR8NFdmLsjOATk5IC8b5GeBwkxQnAFK0kBZKqhI
AVVJoDoR1MaD+jjQGAua+KCFC56zQTvL2hlt6Y4yvWMaPkTqPzO0fXT1d5pq
iKoYocjGSJKJEPEUXjQTdDTvf7jos7/8ZHf10fbaw/X1hyubXotbnrPbnlM7
D37uevzY8xjZdx/cd/t24NZ36Pr50PXjkUvvscvbY+cekXOXyKnzxOnlyf32
k/tt4nvPxfewUHcbJXdhqDrpnRrpHSzU7QrZ7XLZbSzUnRLZHTSU/G6h/C4W
6l6e/F4uBgt1P0uBVkJDKe6ns8oApwzLVQoEMFcJiC0BwmI0V2IRSCoEKYUg
tQCk54OMfJCVB3JyQW4OyM8GhVmgKBOUZICydFCRCipTQHUyqE0E9fGgMQ40
xYAWPnjOAe0cWyfb0s0yvYsyfmDqP0dq+yI03+mqIZpiNEw2TpZOEMXTeNEs
7mjB/3DJZ3/lye7a4631R2sbj5a3Hi5se83seE7ueo7vPRjd9xja9xg4cO8/
dPty6PbpyPX9seu7Y5c3IpdukfPrE+dXJ04dJ04vxPefi++3SO41S+5hoe7W
Se9ioe5Uye5goe6Uye5goe4Wy+9ioe4VyO/9E+p+DiZbAUM5ZWIyFE7pCqc0
Vjlgl2O5ygC/DAhKQUwpiIO5SkBCMZoruQjNlVYIMgpAZj7IzgO5uSAvFxTk
gKJsUJIJSjNAeTqoTAPVKaA2GdQngsZ40BQHWmLAcx5o59o6OdZutvkdy/gh
Wv+FqeuP1AxEqIbDFT+osvFQ6SRJPEMQzcFWAQfLPvurT3fXnmxuPF7dfLS0
9Wh+++H0rtfEnufYnufI/oPBA49vhx59R+6fj9w+HLv1Hru+Fbl2i1xen7i8
OnHuEMNQTs/FTq2S+82S+42Sew3Se1iou9XSu1ioO+Wyu2Wyu6WyuyXye8Xy
e0Xye1io+/ny+3ny+1gopxyFU7bCKetPJWcoXeGcBrEqbawKG5qrHHDLsVxl
IBbmKgXxMFcJSCpGc6UWgXQsV1YByMkHeXkgPxcU5oDibFCaBcozQWU6qE4D
tSmgPhk0JoKmeNASB54LQDsPdHKt3RzzO7bpA8vwJUrXz9QMMFTDdMUPmvxn
mHSKLJ4NEc0HHy0GHKz47q8921l/urH5ZGXr8eL249mdR1O7D3/uef3Y9xo+
8Bw4fNB/5PHlyOPTsfv7Y7d3IrcekWvXiWvnictLsXO72LlNAkM5oaGk9xuk
9+uk92ql96plMNTdCtldLNS9Uvk9LNT9Ivn9Qvl9LJRTntwpV/GnUrbCOUvh
nIlV+ieUSyrEqrLCXGyoAnAqAA/mKgcxMFcZEMJcpSAR5ioBKcUgrQhkFIHM
QpBdAHLzQX4+KMwDxbmgNAeUZYGKTFCVAWrSQH0KaEwGTYmgJR48jwUvBOAV
39bNs7zjmj6yDV9Yum9RmsFI9UiEcixcPkGVToeKZ4miBfzRUuDBqu/euvf2
xrP1rafL208Xdp7M7D6e3Hs0vv9w5MBr8NDr25Hn16MHn489Pog8ekXub07c
uk/cXotdX4pd28UubRLnVolzi8SpSeqEhbpfK7tfLbtXJbtXIbtXLrtXJr9f
Kr9fIr9fLHcqkjsVyp0K5E5oKIVzrsI5R+GcjclSuGQqXDIULukYNJQSlcKq
trCqrewqLFcl4MJcFUAAc5WDuHIgLAMJZSCxFCSXgNQSkF6M5soqAjmFIK8A
FOSDojxQkgvKckBFNqjKBDUZoC4NNKSC5mSkNRFpEyLtseCVwNbNt7zjmT5y
jV/Z+m8s7VCUejRSOR4hn6RJZyjiOZJoEX+0HHSwBlv5bG16r215L+08m999
Or33ZGL/8Y+DR8OHDweOvPqPvL4ce34UPXgv8nh74tFz4v5a7PZK7NYhcX0h
cXkucWmROjdJnRukTvUyJyzU/SrZ/QrZ/XL5/TK5U6ncqUTuhIVyLpQ7Fyic
8xXOWCiXHIVLtsIlC4OFck2HlK5pStdUpWsKJplVa2HVWNgwV7WVU2XjVAFu
JeBVAkEFiKlAc8WXo7mSykBKKUgrBRklILMYZBeD3CKQXwgKC0BxPijLAxW5
SFU2UpOF1GUgDelIcyrSmoy0JSDtQuRVLOiOsb4TmD/yjV+5+u9s7VC0epSp
/MmQT4VLZ8PE82TREuFoNehg3X93w29zy3d122dx13tu79nU/tPxgyejh4+H
jh59O3r49djrk8jrg8jz3cmDnhOPLrFHp9i9Q+L2QuL2XOraInVpkro0ypzr
Zc61MqdqmVOV3KlC7lQudyqTO5fKnUvkzsVy5yK5S6HCpUDhkq9wyVO4YKFc
sxWuWQrXTEyG8k+lNKVbqtItBZOsdEti1ZlhLjZUY+VA1TZuFQT4MFcliK0A
wgoQXwESy0FyOUgtA+kwVynIKgE5xSC/GBQWgeJCpLQAKc9HKnORmhykLgtp
yESa05HWVKQtGWlPQF4JQXec9V2s5ZPA9JVv+M7VDbPVP6KVE5Hy6QjpHE28
GCpaDjlawx1sBOxu+m9s+63s+C7s+czse08ePBs7fDp89GTg+HH/8aMvoocf
T7x6T7zeiD27xQ86JR4vJe7tEvc2qVur1LVZ6tooc6mXudTKnGvkzlVy50q5
c7ncuUzuUip3KZG7FCtcihQwlGuBwjVf4ZqncM1VuGKh3LIUbplKVIbSLV3p
9rtS6p9K7lCS0j2RVW9i1ZvZdZCFUwtZuTU2brWNVw34VSCmCsRWAmElSKgA
SRUgBeYqB+llILMM5JSCvBKkoBgpKkZKipDyQqQyH6nOQ+pykYZspDkTaU1H
2lKRjiTkVQLSLbT1xlk+xZr6YgwDfN0IVzPGVk1EKWYY0vlw8RJFtEI8Wscd
bAbtbAeu7wQs7/rN7/tOH/j8PPQePXo2dPz02/GTr6LHn04evT95+Fbs1SP2
fC3xfCV50C71aJO6t0rdm2VujTLXeplrrdylRu5SJXeplLuUy13L5K6lCtcS
hWuxwrVI4VqocCtQuOUr3PIUbrkKtxyFW7bSLQut5J6BSVe6pyndU5XuKZjf
ldBQSvcEVqOJ1WBiN5jZ9WZOvYVTZ+HWWbm1Vl6NjVcD+NUgphrEVYH4KpBQ
CZIqQUoFSKsAGeVIdjmSW4bklyKFJUhJCVJWjFQWItUFSF0+0pCLNGcjrVnI
i3SkIxV5lYR0J4DeeOsnobkvzjgQoxvha8a5qkmWYpYpW6CLl6miNdLRBn5/
C7e9E7S2G7i0HzB34D916Dd+5DNy7D0getYvevrl5MkH8eN34kdvJA+7JF6v
pJ4d0gcvpA9aZR7NMvdGmVu93K1W7lojd62Su1bK3SrkbmUKt1KFW4nCrVjh
VqRwL1S45yvc8zC5SvccpXu20j1L6Z75p5IHlKb0SFV6pGCSlR5JKo9ETALE
ajJC7EYTxGkwQ9x6C6/eyquz8mttkKAGxNSAuGoQXw0Sq0ByFUitQtIrkcwK
JKcCyStHCsuQ4jKkrBSpKEGqi5DaQqShAGnOQ1pzkBdZSEc60pmKdCeB3kTr
5wRzf7xxME4/GqP9yVdNcxRz0bJFhniFJlonH20S9rbxW7vBq3u4xYPAmcOA
iSP/H8d+QyKf7yfeX0+efRI/fS958lbyuFv6qFP68KXU64XM87nsQYvMo1Hu
US93r5O71cjdq+TulQr3CoV7mcK9VOFeonAvVngUKTwKFB75Co88pUeu0iNH
6ZGNyVJ6ZCo9Mv6phIV6kKJ8kKxCJakeJGISVA/iIVaLgdVsZENNJg7UaOY2
mnkNFohfb+XX2QR1tphaEFsLhDUgoQYk1SAp1UhaNZJRhWRXIbmVSEEFUlSB
lJYj5WVIVSlSW4w0FCHNBUhrPvIiF3mZhXRmIN2pSG+K7XOy5VuiaShe/yNO
OxGjnuEp5lmyJaZkNVy0EXq0TdzbCdncI6zsB88f4qaPgn4eB4yK/AdP/PrF
Pp/F3h8kz95JnvZIn7yWPn4pe9Que/hc5tUi92ySP2iQe9QpPGoUHlUKj0qF
R4XiQZniQaniQYniQbHiQaHyQYHyQb7yQZ7yQa7yQY7yQbbyQZbyQSYmQ/kg
XfkgTfkgVYVK+adS0j+VElSe8SpPIcRq1bNaDewWyMhphkzcJhOvycxrNPMb
LYIGKxRTb4utA5CwFkmoRZJqkdQaJL0GyaxGcqqR/CqksAopqUTKK5CqcqS2
DGkoRZqKkdZC5EU+8jLX/jrb3pNu700Dn1Mt35JNw0mGsQTtZJx6VqBc4MhW
oiTrEaItytFO6O4eaWOfuHxImDvCTx7jxkRBwycB38X+XyW+HyU+vVLvN9Jn
XbInr2SP22WP2uQPW+ReTXLPBoVnncKzRuFZrfCsVHhWKDzLFJ6lSs8SpWex
0rNQ6Vmg9MxXeuYpPXOVnjlKz2ylZ5bSM1PpmQGpPNNVnmkqz1SVZwomWeWZ
pPJMxPyu9DtUHMR6rofYUKuBA7UYuS1GXouJ12zmN5sFTRYoptEa22CLg+pB
fD2SWIck1yFpdUhGLZJdi+TWIAU1SHE1UlaFVFYiNRVIfTnSVGZvLbG3F9lf
Fdi78uw92fb3mciXDOv3NPNIimE8STcVr56LVS7xZassyQZDtE093A3b2Q9d
OyQvHhFnj0MmRPjRE9ygOKhfEvBZ6v9e6vtW5tMt8+6UP+2QP2mTP25VPGpS
PGxQPKxTPKxRPKxWPKxUPqxQPixTPixVepUovYqUXoVKrwKlV77SK0/plav0
ylF6ZSu9slRemSqvDJVXusorDZOq8kpReSWrvJIwiSqvBEy8ykuIiVN5xaq9
YqNf6FhQm57dpuc8N0Dc50ZeK2Tit5gELWZBszmm2RLbbI1rsgobbcJGEN+A
JDYgKQ1Iej2SWY/k1CH5dUhRLVJai1TUIDXV9voqe1Ol/Xm5vb3U/qrY3lVo
f5Nnf5+NfMmyDWSaR9ONP1N1M0mahXjlcox8nSPZYop26Qf7tO0D6uoRZeGY
PH1CHBeHjIjx3yW4r9Kgj7KAdzK/Hrnva7nPS/mzF4qnrYonzYrHDYrHdcrH
NcrH1cpHlcpHFcpHZcpHpcpHJcpHRcpHhcpHBcpH+cpHeaqHuaqHOaqH2aqH
WaqHmaqHGaqH6aqHaaqHqaqHKZhk1cMk1cNETILqYTykfihUP4zDxKofxkDR
7VoWSsd+oeO80EPcNgPEazPynxsFz02CVlNMqzm21RLXYhG2WOObbQnNtsQm
kNSIpDYiGY1IdiOS14AUNiAl9Uh5vb26zl5Xa2+qsT+vsrdX2jvL7d0l9rdF
9vd59q+5YDDH8iPLNJmhn03VLCapVoXyTb5kJ1q0F7l/ELF1FL5yTJ0/oUyK
yT8kxCFpSL8U/1mGey8PfCMP6FL4vVT4vlB4tyqfNSufNiif1iuf1iqfViuf
VCqfVCiflCmflCqfFKueFKkeF6oeF6ge56se56oe56geZ6seZ6keZWIyVI/S
VY/SVI9SVY9SVI+SMUmqR4nqRwmYePUjIepPpT+h1A8F0S810R1aVoeWjdJx
2nXcdj3Ee2HgvzAIXhgFbcaYNlNsmynuuVn43BLfak1otSa22JJaQHIzktaM
ZDYjOc1IfhNS3GQva7RXNdrrGuxN9fbWOnt7jb2zyt5TYX9Xav9QZO8rRIby
rWN5pqlsw3yGdjlVtZ4g34qR7LFFB9F7R8yNY8byCX1WTJuQUEal5AEZ8auc
8FEe/E4R1K0IfKX0b1f6Plf6NCt9GpU+9UrvWpV3tcq7UvWsQvWsTPWsVPW0
WPW0SPW0UPU0X/U0T/UkV/UkR/UkW/UkS/UkU/UkQ/U4XfU4DZOqfpyifpys
fpyESVQ//l3pd6g4TKz6UQxGgOFHv1JHv9KwoJda9kstB6Xjduh4HXo+1G4Q
tBti2o2x7ca4FybhC3P8C3NCmyWxzZrUZkt5DlKfI+mtSFYrktdqL2yxl7bY
K5vttc32xiZ7a6O9vcHeWefoqXH0Vjk+lTn6SpDhYtt4oXk637CQo13NUG8m
K3aE0n2e6Iize8xaP4laFDNmpPRxGW1YRvkmJ39WEHsVhB5lcKcyqEMZ0Kby
b1H5N6r86lV+tSrfapVvpcq3QuVTpvIpUXkXq7yLVN4Fqmf5qmd5qme5qmc5
qqfZqqdZ6qeZ6qcZ6qfp6idp6iep6icpmGT1kyT1k0T1kwQ01ON49WMhJk79
OBYTo34swPAxvKjX6uhOFKtTw4ZeaTivtNxXWt4rHcR/qRe81Me8NMS+NMS9
NAo7jPEdpoQOc2KHJbndktJuTX1hS38BMtuQnDZ7QZu9pM1e8dxe89ze2Gpv
bXF0NDteNzneNDje1zk+Vzv6K+wj5WCi1DJbbFwq0K3nqLfTFXsJ0sPY42PB
zgl3TcJekEZNySJ/yOmDCupXJeWjkvxWGdKlwr9U4dpUuBZVUJMqsF4VWKsO
qFYHVKr9y9V+ZWq/ErVvsdq3UO1boPbJV/vkqb1z1d7Zau8stXem+lmG+lk6
Jk39NFX9NEX9NFn9NAmTqH6aoH4SjxGqn8Spn8RiYjAC9RM+6jFPg+JGdamg
6C4V67UaYr/WcF5ruCgtr1PL79QJOnUxnfrYTn1cp0HYaYh/ZUx4ZUx8ZUp+
ZU55ZUl7aU1/act8CbI7kLwOe1GHvbzDXt1ub2h3tL5wdLQ5Xj93vG1xfGhy
fG1wfKtxjFYjk5XW+XLTSol+s0Czm6U4TJYeJxydCLclMasy3pycPaGIGlEy
vinpn1XUXlVot5r0Sh3yQk1oVROa1PgGdXCtGletDqpUB5WrA8vUASXqgCK1
f6Hav0Dtl6f2y1X75qh9s9U+WWqfTLVPhto7Xe2dpvZOVXunqJ9ByepnSepn
iepnCain8eqnQvXTOEys5mkMRoB6wtc84WG4GA6zWxnVrYzuVkGsbhW7Ww1x
utTcLg0PpeV3aQVdupguXWyXLq5LH99lSOgyJHYZk7tMKV2mtC5zxmtL1mtr
zmtbXidS0Gkv7bRXdTrqXzlaXjk6Xjq6Ohzv2h2f2k77Wk8HGk9/NNin62yL
Nea1Cv12iWY/T3mcLj1JPZQkbcnil+WxswreuJI9pIrqUzM+qsPfaMJeaygd
mtDnGnKzhtSgIdZqCNUafKUGX64JLtXgSjRBRZrAQk1gvjogT+2fq/bPUftl
q/2y1H6Zat8MtW+62idN7ZOq9klR+ySrvZM03omYBI13vOaZEBOneRaLidE8
wyo95Wue8jBcDAfDZr5RRKGU0T1KFkrF7lFxUGpuj5rXo+H3aAQ9mpgebWyP
Nq5HJ+zRxffoE3v0ST2GlDfGtDemjDemrDeWnB5rXo+tsAeUdNsruh113Y6W
bkdHt6Or67T39ennV6ffOk6H2k7HWxyzzWC50bJRa9it1B4Vq05ypJLMQ1na
piJ5SRk/rYr9oeYNaNhfNMxeTUS3lv5SG96mpbZowxq1oXUacrWGVKkhlmtC
SjWEYg2+SBNcoMHla4JyNYE5msBsTUCWJiBT45+h8U/X+KVp/FI1fika32RM
ksYnUeOToPGJR3kLNd5xmFiNdwwKhnrGx/A0z7gYDoYNQ2mesphv5cy3iihM
9FsF660SYr9Vct6quG9VvLdqiP9WLXiriXmriX2rEb7Txr/TJrzTJb3TpfTq
U3sN6b3GrF5TTq85v9dS1Gsr7QUV7+w17xzN7xzt7067352+f3v6ted0oPt0
tPNsouN0vh1ZfW7dbjYe1OlE5SpJkUSef6DM3lClL6pTJjXxI9qYfi33o471
RhfdqWO26xit2ohGbXidllqtDavUhpZpySVaUrE2pFBLyNfi8zTBuZrgHA0u
WxOUqQnM0ASmawLSUP6pGv8UjX+yxi9J45eI8k3Q+MZrfIUa3ziNDxSr8YnB
CDTefAwPw9V4c1CwEoqFiY7slTF75VBUrzz6nQJivVOw3ykhTq+S26vk9ar4
vSpBryqmVx37Xh33XiN8r0n4oEn8oE3+oE39qEv/qM/8ZMj5ZMz/ZCr6ZCn9
ZK38BGo/2Rs/nrZ/PO3+ePrh42nfh7Oh3rOxt2dTXWdLr+0br2x77abjFr2k
Ri2vkChL9tWF65qceW3GhC55SBf/VR/bqxd067kv4Uahi27SMet1jGodvVJH
K9OFlWgpRVpygZaUryXmakNytIRsLT5LG5ypxWVocenaoDRNUKomMEUTkKwJ
SEL5J2r8EzT+8Ro/ISZO4xuLidH4ClA+fI0PD8PV+HBQ3mwMC9J6R2OiGO9l
ke9lTEzUe3k0hvVewX6v4GC4H5S8D0r+B6Xggyrmoyr2oyrukyr+kzrhszrp
sybliybtqzbzqy6nT5/fZyjqN5b1m6v6rXX9oKnP/qLvtLvv7EPf2be+s5Gv
ZxOfz2bfn6/0OrbfgsMus7jDIG/SqOokmup9bdmarnBOnzNuSB8wpHw2JL41
xHcaYuGQ16zn1OtZNXpmhZ5RpqMX62iFOmq+jpKnC83RkbK1xCxtSKaWkKHF
p2vxadrgVC0uRYtL1gZBSdrARG1ggjYgHuUv1PrHaf1jUX4xWj8Bhq/15WG4
GI7Wh41hYaIxUTCU1pvJ+CiFIj9KmShZ1EdZNErO+ihnf5RzUAruJwXvk4L/
WSH4rIj5ooz9ohR+Vcb3qRL7VMn9qtRv6ozvmuwBbd6grmhQXzZkrBoy1w9Z
W4ZA+5Cja+js49DZ96HzscHz6e/nC/3n619P9z4jovcWWbdR1a7RtEp0jXv6
mjVD+ayx8Icx95sx66MxvceY/NKY0GqIazAIagzcCgOrVB9VrGcU6Ol5+vBc
HTVbR8nShWbqyBk6UrqOmKYNSdUSUrT4ZG0wlKTFJWpxCdqgeFSgUBsYpw2A
YrUBMVp/AYav9edp/SAuhqP1ZWNYmGgUrIRiYiIjPkkYmMhPUiYm6pM0+pMM
Yn2WsT/LONAXOfeLnPdVzv8qF/TJY/rlcd8Uwm+KhO+KxEFFypAybViVOaLK
HVUX/tCWjumqxgwN46bn49ZX40jP+Omn8fPB8fOf4+dzYxcrIxdbQ+eHA3ZJ
n035waTt0eg7JcYXe6bmVXPtjLli1FzSZy54b8p5bcp4YUppMibUGuMqjPxS
A7fIwMo3MHP1jGw9PUtPy9RTM3SUdF1omo6cqiOl6IjJupAkHSFJh0/U4hO0
wfEonFCLi9MGQbHawBhtoAAVwNcG8FD+XAxH68/W+kEsTDTKN0rry8REYhgQ
/bM4AsP4LIn8gmJ+kUR9kULRX6Ssr1I21Cfl9Mm4/TJev4z/TSb4LosZkMUO
yoRDsvgRWdKoPGVMnj6uyPqpzJ9UlUypK6e1DTOGthnT61nru1n7l5mzodnz
qdmLxZmLjamL3Z8XJ+OnihGg+WY2fNKaeiXm7j1Lx4q1ZcraMGKp/mope2sp
fGnOaTFn1JlSKk0JJcbYQiM/z8jJMURnGZgZBka6np6mp6XqqSl6SrIuNFlH
TtKREnXERF1Igo4Qj8ILdcFxKFysFhejxQm0QRBfGwjxtIFcbQDE0QawUf4s
TLTWPwrlx8REYhgo3wiI/vUEivgqhhhfxZEY5lcJs08S1SeJ7pOw+lHsbxLO
dwkXGpDwBiX8YYlgRBI7Kokbk8T/lCROSFOmpOkzspw5eeG8onxRVb+kfb5s
6Fo2f1ixfVtxjCxfzKxcrC5f7ixdHs5fSufO1FOI4YfVPKi19kltH/ZsPSu2
zinbiyFb02drTbe17IWlsMGSU2VOLzEnFZiEuaaYLCMvw8hOM0SlGiJTDBHJ
hvBkPS1JH5aopyTqQxP05HgdKV5HFOpCoDgdIVaHh2J0wQIUjq/D8VBBXAxH
F8jGsHQBULQuIEoL+TMxkRiskl8Ehg6F94nC+07omIi+E0Y/KrJfzIS+iaOg
7+Lo72LWAIo9KOYMiTkjYu6omPfjhD9+Ipg4iZ06iZs5SZg7SV4Qpy9Lclel
JWvymg1V66a2a8vwadsyuI383D6b377c2L482Lo6Wb9Srp3rlxzmaZttQgdG
pci3PeTzCtI7hXQNgvYPoKnTVt1sLa225pdasvItqdnmxAxTXKqJn2LkJBtZ
SUZmooGRYKAnGMLj9dR4fVi8niLUhwr15Dg9KU5HjNURY3QhMTqCAIXn6/A8
XTDE1eEgjg7H1gVBLFRgtC4wCsPUBUCRGAbKPwJDx4Tr/MJp/ce0b6LwbyI6
JgJ1wviOivx+whxARQ2ioodOoodPWCMnrB8i9piI/VPEmTzmTh/zZo/5C0eC
paO41ePEjeO0LVHurrhsT9Z4oOw81H46Mo0c2aaPHctHFztHV6KjK/nBlXbv
wrR9alsByKLeMS1zjO87hlcd/VP2DwP2rndIWztoqLNVlNmK8qw5mZb0VEtS
klmYaIqJN/HijWyhMUpojBQaIuIM9DgDLU5PjdWHxeopsfrQGD05Rk8S6IkQ
XxcC8XQEiKvDc1DBbBSOpcNFo4KiMExUYCSGgQqIwNAx4WgofxpE/X4M0b4f
h2Po0IAoAsMYREUOoZjDIuaIKGpUFPXjOGr8OOrnUfTkUfT0YfTcYdTiQfTK
PmttX7CxG7+1m7azm7e/X3Z01HAi7pAqP8j0o3LLvBzZlJ8fyK6ksmu15Np4
cmU7OrfvIqebxrMVxdnC4dnU2uno5Gl/v6O3x9H93N5RgzQXg5ocW0maNTfR
khZnTogxx8aY+AITR2CMjjEyY4yMGENEjCE8xkATGKgCfZhATxHoQ/l6Ml9P
4qGIXH0IxNERILYOz8JE64KhKBSOqcNFooIYmAhUIB0Tjgqg/YMKhQ0cQdSB
I9ogKnzwGKJDQ8cR0PAxAxo5ZoweR/44jhw7ihw/ipw4jJw8ZMwcMOb2Ixb3
6Cu7zNVt9vqGYHMtYXslfW8l/3C1QrTRLNl9LRd9VilHdMZFHdjVnZ5oL5Xa
a4Pmxqq6tssvzsSO8yPTxZ7qYvP4fHn9fHrifPzb2dCbM7g6vq9yvC60P89E
6pJBqdCWG2NN5ZmFHDOfY+JyTSyuMYpnjOQZI3gGOs8QzjNQeYYwnp6CCeXq
yVw9iYMislEhLBQhWk+I0uMhpg4KjsQwdDgoAhVEx4SjAmkYKiZMF4CiDB5S
hg7DMNShIxo0fBSOoY9gRo8ioB9HEWOHEeOHEROHEZMH9On98Lk96sIudXmH
vrLBXFtlbywKtubid6bT9qfyjqYrxHPNsuUe1Xa/VjRhUK+YLQcWh9xyqTXf
WEw3iOHmTHd5oTq9lFuuJJrLI9HlzsblxvTl8veL2Z6L8ebzgfKzj7mnXamO
5/FIbQwo4dmyOZZkljk22sSNNrFZxii2kckxMjjGCI4hnGOgcQxUjiGMY6Bw
9FAoW0+GWHoSS0+MRoVEYZh6AhSpx0MMPT5CHwzRUbhwDE0HBUFUTBgaKpDy
W+jwAURBHYZBI4dUDG0UFf4DM3YYPn4Y/vMgfOIgfPKANr1Pnd2jzO+GLm1T
lzfoKyuRa/OsjSne9njc7kjywWCWaLBEMtyo+NmtWfhu2J4xS7ZsepEdUdsv
TMg1QH6d2n5dWq6vjGfXetu1RnetkFxLd65Fs9f73682u64W6y8niy4G088/
Jpy+FjhauEgVCxREWzOiLAlMMz/SxGaaoqOMzGgjg2WMYBnobEM420BjG6hs
QxjLQEHpQ6P1ZChKT4KYeiIUqQ+BGHoCFIHC0zHh+mCIhqHqcVAYhqIP+i0U
FUgmjeyTR/ZDRw5CRw8omDDoB4oKjaFo4we0nwe0iX3q5D51ei9sZi90bpe0
uBO6tBG2vBK+Os9Ym4raHGVvf+fvfY476k05eVsge9+o6nujGxs0Lc3aDnbt
KtmpVX9+bju/dpz9ujj9dW2/uQEXN1b7jdl4Y1Lc6PduNLPXsv6r45eXO5VX
y5lXU8KLQd75e9ZpR5S9PhIpibRlM6zJDHMsw8SJMEVHmphMY2SUkRFlpEcb
wqMNtGgDFRMWbaBEoUKZBjJTT47UkyCGnghFoELoKEI4hqbHQ1QUDBUchqGg
oXChfwSRMSTi6B7pxz5ExoRCY/sUTNg45idmYj9scp8ytUeZ2SXP7hLnd4iL
m+SltbDlRdrqDH19jLH5nbnzIWr/Nfu4Le2ktULW1q7q+qz7OmGeWAebolOp
6sJkvjy1X12fX/26uvz75vzm19nlr9PTXw7LL7vqGhxcmufOdF8dijb7cbFj
O/lskXP5k37RRzvrojmaw5HycJBHt6bSLUK6mUc3RdNNTIYxMtLIYBojmEY6
0xgeZaAxDVRMGNNAiUSFQgwDGYowkCL0JLqeCIXrQyAaikDFhOnxEAUTqg/+
jYzCkf5BDBnbg4gYEjS+R8aE/vyDMrFHmUSFTu2FTmOh5nYIC9vExQ3y0kro
8nzYyiRtbZi2+Tl85zV1v0lwVJl9UlIjLelUVX/TvZg1f9lFZuVnR8ZLPXLt
OL+5urr5dXP996+rX7+urv++Ov91Ca4vtBdnBw77jM360axvMCqyTMd86ybd
MUu6HMafvyOePg+1V4aBfKo1jWaJDzfzw02scBOTboyMMDIYxohIIz3SGI4y
0CINVIhhCGMYKFCEIRSiG8hQuIEE0VBEKqQPCcNQ9AQoFAVD4ckYkj74NyIK
FwIRxnehEAzx5x+kn3ukiT0yNImZ2kVN75JmdomzOyHz24SFzZDFNdLSMnl5
NnTlJ2XtO2Wjl7zznLpfFneYmScS1kk5n1SJc/rKA8sblX3CfL5nv9Kc3yDw
TN38gh9//33z6++bm79vLm9u7OdXetv5kc4xK7d+ODFWn2gTFQqq9iDYsux/
OuZ78THwtI1gryKBfIo1LcwSTzXzaSYWzcQMN0XSjYwIYwTEMNIZxnCGkRYB
GaiYMLqBAoUbQiEaikxFkcJQRMofIaEYsp4Akf7AEzEh+uDfCFDwzx08NLFD
wIRM7KImd4m/Te2SoGkUcWYHDTW3jZ/fxmOtiItLpKVZ0vI4afUbceNN8HY9
dS9beMDJO/b/IA1ZUHFF+gK95RVi/3F+tnt9qb25ccDD9OtvWOr3B4x2fXFz
Zrsyq87F+8jckqV3Sl85qYpblBOPJV6aTU8w4XXx6enp80B7BQHkkq0pFIsw
zMynmthUE5Nmigw3MuioCLqRjgmnG2kYargBCqOhKFRUaBiKDFEMJCgURSRj
SIaQ34gGAhTymx5PwOBRwXjc5DYUjMFP7qCmdgiYkOl/zGBmdwhz21DwwhZ+
YYOwsEZYXA5ZmgtZ+hmy8h2/9sZ/q4aykxi3H9Rx7LIofaZQ0kzKHLvm1YVh
7Ma6+8uu+/vy9O9fN3//u9XfN3//Or+5Nl3aT07Va2Drh2m4V/O8VS7slAT9
OHERH/yHZcrp4qPnaZMfUhxsyyRak0ItsRQzL8zEgq2opkiaEc0VbozA0MON
4RgaDUWlosLCDBAFohhCoVAUmYwikTBEA/G3EEMIREARIPwf+ODfAqe2oKCp
bQgHTW8HY/DQDIoAzWLgicIOVfD8VvDCJn5hHb+wgl9cwC9OBS+NBK188Fmv
J2zHxuz9z8nj/0e572XZjjjdzbk66riRDF/LN6/V6hvk/Nf1v0NhB+vv88tf
utPLPcQ4ZTn8oJ9pVb0vkVRmHrMqDm8vH/0P0+R/nHe7Oyp9QQ7OmhxiiSOb
+RQzJ8wUHYa1wnIxMBEYOs0YTkXRwlBUiGIMg0IhA4WMCiWhyMQ/SCEYgoH4
G94QAgWjCBDuDzzOf3ozYHoLCpxBBWFw0Cy0Hfzb70rwRP0OhdoMXtgIXlgL
XljGLcwHLUwGLA54L3c+3EjK3/3vitX/yzH25HKUeTlRcLnw8nJt8GJt4XxD
emZAL/b/f6u/r28uLNcS1fWC0Taql71Vb1bJxoXHPeH7JYwdau/+/2kb+r9P
6zxBlp81MdgSE2Lmkc1sChoq6j9bUU0MqhGK+C3MSMeEU1C0UBSVjAojoShE
VGiI4TcyAYM3kH4LNhB/wxlCfgsyEH4L9J3Z9INmN/0xAZjA2a3Aua0gDO63
P4n+wKE2cfMbQfPrAXOrfnPLPrNzT2bHHsy/bt75P07rXZCSEHtdjON16Vl/
J7q5jI/ZXkztia/0F3p4o//nqTq90l3syYcGzkdU5m8aTZdcUnm8k7CzELY2
9HS5g7L5/zrK7lkET82sQFMU3sQkmphkE5NiYoahIsP+tIJfMFBoqAgKih6K
CiejaCQUlYgKC0FRIAIqFI8JNpAxJNwfxKB/BBpCfgswEAJ8Z9chv9kNv7kN
f0wAJhCa3wzC4P74r8XmUOjxm94OmtwOGtvBfd8L6ZR0uskUzkk6YoJJmG8t
b7J3vT8dGD6f+HG91b4Cjs2mm5tf1//Z6sx0faPd69F8GNLqBhWmd8f6hg11
1rSc910a3qHMIVgVdwU63zD4NoeXDPo00dEg8CD9u9K/UVCMUAzZFEE2RpCM
dIhoDMfQQlBUAgZvDIOCjZTfcMbQ34KMZCgQMpB+CzAQf/P3nV3zm0P5YwJQ
64HzqCAMPDy/oc8dCg0Fn0d4g8ELH31RwjFs5ID6VUTvVLLybK3+uo2/fkgf
v9IyXpnyPoCXI47B2fOlpRvt5tmV5urXzX95Bm+uL66N+w75vMk6JQH9m+Dl
BCh/D7LqkfwE26eH4qP/2ap6kKQN4MBVDg5L6AsOXuAM+Aakoa3gY8jEnkcU
BcUMxZBNkRAJxSCiIkJQdAJkDMf/QQtGUXF/hAWhKFAgKhQKQJEhf8hvbgXy
x8CnKWB+NRAThFrDYYIX1jHwgtpEzW/Bex6+FuEgQZnYh2tjxHcRs1fOajEk
ZdtqwmxjfqIdvyUpc1KbO2NpX3YM71xsiq41qr8v7X//56H6fbL+/nV6c6E9
PzsynK8cX/xYuPj07ezVC0drDtJJN0567B3ceqtwLdT4JukIfH0oC07mRjqc
P+n/bhWF3fPRFBMLEx1qiiZjSKYoiIg9uSGoSAKKAeFNEVCwiQ7hUOE4Y3iQ
kfZboJH6W4Ax7Dd/IwXlN7fkj1oOmEcFYoJQKzhoYSV4YRWzhr34NvD/tCLN
7MCVB66KEcPHUX0SzhsVr8mcXoD+S96Pkbo5pnRfIJYXHxu6xGBccb6ru9bZ
fp1e/H3zX84VfA9eXP+yOm6U2uv9/aul6Yux92d91Y6+JPNYmGzNY/XI5Z3C
vULtl6kjxOtDeQYaC11nGBFwssJCUU2sMBM7DF74KE4oik3GkFAsIio6xARF
ETDw3oOCTZEYBg4VEfQHPRAVDgWgaAFGmj+KivKfW/SfXwzABGKC5pcg3AK0
HIxBZ4OFVfy/c23BiZQ8sxs2tU8fP2QOi9hfZfw3mrhWS2Y5Up2NvExAhlKN
S4W6wya96qPJPGVzHNgv9XBtvoYzw6//Mor+fXnxy277ZVDeSLeudsfOV7qR
+QrTQrxyLeRw79mk+GGP8lG1JjBXF5Ksp8QaaBxjBNyXGXDBQWdRFtUMQ3HC
zFwKiheKIZu5JAzRzIFCUGwCioVHRQejooJNUTgTEwpCRUKBJgYmIuAPuv8f
4ZCf//x8ACYQE7SwAOFQi8EY/MISfmGZsLBCWFhF58+FdXTBmd+GiyF1aj9i
/DB6+ITXL4vt1SR0mDMakMoK5EWJ/UOJfbweWesGoiG7ZuXMKr5wGK8vHL+u
r9DlBhvd4YJz8+vy5tpxc266BtJL/fqZfAQcd5r2i9X7vJNDyvJJ0IDcp1Pl
V63B5+vIqXqq0EDnGRnRcGVGW0XTzGyqmUuFoyk6dEGCULOAjCGZ+RDRzIdj
BkQwcyE8igMFm9kQzsyCgszRmKhAyMSEAkyRv/mbGJgIyA8KmJ+FAqGF2aCF
OQiHCV6Yh7BRc4GwuEhYXEKn9MVVuNqEoEP7Nnlulza9z5g4ZI2e8L/LhJ/U
yT3GjBegtMXe0mR/2+oY6Dyd/Xy+NXEh3rzSya6tphvH6a8LuBDC1Rk9Xld/
X1/9Or+8AeeXurPTY4dt0WboN6ralPLCI6lwTcoYl5M+qnBtmpAqbWi+nppm
oAuNDL4xkmWKijRF0U1sGhqKTzULwiwxFEtsKIZsiSVhiJYYKAQlIKD4eMjM
C0ZxcShOEIoNBcKxBBUdgIqC/FFMfxMU6fdbwPx04AI0E4TBYYIXZyH84hxE
WJwnLC6ELC6GLC6FLC4TF1eJi+shi1vk+R3q7B5j8pA9JhIMSxP6lakfddlv
LIWv7fWvHa/fnH79fPZz9Hx18fJw/0qhvNabb2ynN/ar67Oby8tfF79+nf99
ffbr1HFjQa5U1vMDo31eY+2XGtoPtKWr6uRJNadfQ+vWUpt1tAp9eJ4hItUQ
KTQyeaYoFvrDKxbdzA03C2iWGKolLswSB/fEUIuQjCFhiJa4EAzBEgvhLTFQ
sEUA4Sx8DC8IMnMDURwowMzGsPxR0b/5maMwTN+AhalATBAGBxeWxWkIj5oh
oGZDFuHSN09cWiAuwWV5mbS4SlrcIC1uh83vMmYOWBPHgjFxwpA87Zs654uh
5JO15pO97etp7/DZ0PT57PrlxvGVSA17XBrOLq2X58j16dmN/foG+XUFfjms
NybTlUJ3sas8nTlB+nYtHSumiilDxoA+tlfH6dBH1+ujSg1ROYaoFGN0nInF
M7GiTWyGmUc3C8ItsTSLkGqJD7MkUKwJodYEMoZkTSBiQqzxBJQQb0EFW+KC
LbE4VAwUZBFAgRY+hheA4gaYuf5mDobth2L95muO9g1cmICCoMUJHGoyGINf
nCQsTRGWpkNQM8SlWdLSHGlpgbS0SF5aIS+tkZc2Qxd36PP70TOH/ElR/Lg0
bVSZO6QpGTTUDlnaftjeTNn7lx0Tu6crkrM93ZnYdqY6O9VfIJYrG3Jlurw2
3Vwafzn0N0b1lVR6sXN8Nrtj/7YCXk9Z6oZMBZ+MaV3G+BaDoNrIKzJys4yc
JBMn1sThmDhRZj7DHEu3CMMt8TRLItWaFGZNoliTQ63JZGsyyZpMRCWFYAjW
RDwqIRgVj0MJoSBLXJAlNhAVAwVYBBi+P4oH+Vm4KDMH8jWzUYEL44GL40EY
3OJ48OJPCL8ETRCWJkKWJiHi0hRpaZq0PENeniMvz4cuL1KWVyhL62FLW9Sl
XebCAXf2KG76JGVSlj2hLJ7Q1EzpW2eN3cuWL1vW0WPbrBKsGsEesEkcFsW5
0XCht16qz69U1+eqX3b5jVFyLT282Nw8n1lyDEwhb4ZtzV8s5T3m3BemtHpT
YpkpLs8Uk2YSJJj4AjOfbRYwLXEMSwLdkhhuTaZZU8KsKRRraqg1lQzZUkm2
VKItNcQKpRBQyXhrcrA1CcJZEzEJQaj4QKsQExdggWIhf0sMRuCH4kO+Fh6G
iwpc/BGEwS2OQcFLKPzSGGFpHApZ+klchiZIy5Pk5Sny8nTo8ixleT5seZG6
vEJbXqctb9GX96KXDgQLx4nzJxnz0oJ5RcWiqnFV+3JL/+7Q0C81jmpNcybj
hk2/b9eIz1Sqc7nxQuy4OLk8E12Do1+GvWvZ5uX24vn0xOnAkP3dF9D2xlbT
YS1utGRXmtMKzUlZ5vhkc1ycOZZrFrIsCUxLEsOaEmFNDbem0WzpYbZ0ii0j
1JZBtmWQbBlEWzoUYksn2NIgvC0VCralQDhrMhRkTYICrYmB1gQowBoP+VuF
mDh/a6yfBYqBfC0CDCzG97HwfAIXR4IWRyHcEip4aRSPISz/CEGNEZfH0J/m
Lf8kr0yErkxSVqbDVmaoK3O0lcXwleWIlTXG6iZzdZe9ehC7epS8epK9Jina
kFXvKJoPVS/F6l6lelCrmjQqFq2yNURy6DiRnB5qz3bA2c756daVbfPGsHoj
W7janbpYGDkb/uLo7UHaO0B9k628ylpQbMnKsaSlWpLjLUkCSzLXmsKypjGt
6QxbBt2WGW7LpNqywmxZFFtWqC2LbMsi2bKItqwQVCbBlom3ZUDBtnQIZ0vD
2VKDUCmBqOQAaxIm0R+V4G+N90MJMXG+qFhfCxTjgxLAVsNBSyjc0nAwBr+M
IiyPhGCIK6OklR/klbHQlTHKys+wlQnq6iRtdTp8dTZidYGxtsRcW2Wtb3DX
t7HfOx+k7hzl7IlKDk/qROIXUvFb5UmfVjRqPJq0HCzZ9raRnUP7utKxbD5d
OnUsXFjnr/QzN/Kf1/vDl8t95+O9p187Hd0tSGsNqC6xleTaCtKtuUnWbKE1
S2DN4tiyWbZspi2HYcuh23JpIJcKcsNAbijIJYNcEsglonJCQA4BZONRWcGQ
LROHygiypUOBtjQowJYaYEuB/G3J/rYkf2uSnzURk+BrjccIIR9rHCYW8g5a
GoRwmGBoeRC/PEhADYWsDBFRw6SVYfLKSOjqKGX1R9jqGHX1Z/jqBH1tirE2
w1yfi15f4Gws8TdX47bWE7c303e38/Z3So926052n0t3u5Q7HzTb/YbNEfP6
rHV1zba0DaalyKTePoHYx84sYxe6kWv59+vDL1dr7y+mu84H204/NjheV9pb
i5D6bPT/fShLBMVxoIgPCjmgIBoUMEEBAxTQQQENFISBAgooCAUFZFBAAgVE
kB8C8gkgD8KD3GBUDg5kQ0EgKwhkBkK2jABbOibNH5XqZ0vBJPvZknwhayLk
Y03AxPugxYTe1jjY6juEg5a/B2Pwy98J0Mr3kJUB4soAaWWQtDpIXh0KXR2i
rA5T10Zoa6Pha2MR6+OR6xNR61OsjWnu5qxga164vZi0s5Sxt5J3sFJyvFoj
Xm2WrXQol3s0S+/18wPGuQnzzIJlYtU2IAKDajBgBf12c/+Z9uul/OP18Zur
zdeX8y8uxprO+6tPe0sdnfn2tkx7UwpSl4BUxyIVPKScjZRFIaWRSGkEUhqO
lFCRkjCkhIIUk5FiElJMRIpCkCICUgjhkYJgJD8Y5ONAHg7kBqFyAkE2FACy
AkCmPyrD35buh0rzs6X6olIwyT62JBRaLNHbmoCJh636g5b7cZhgDH6ln4AJ
WflGXP1GQn0nr34PXRsIWxugrg3S1ofC14cj1kcjN35EbYyxN39ytyZitqeE
O9NJezPp+7O5h7PFotlK8Wy9bKZVOdWumXir+9lvGPthHJ0yDyxZPh5YPyqs
H4zWXmB659C+OZd3XR53XO+0Xi01Xk7WXAyVnX8pPHuXc/o63dGe5GgR2hsF
9nquvZZlr46yVzHslXR7JQ2poCLlFKQ8FCkjI2UkpJSIlIYgJQSkBI8UByNF
EA4pDEIKoEAkPxDkBYBcTI4/yMZk+YFMTIavLR2T5mNLxaT42JK9UUkYWCzx
WdDyV+j/6+o+29JM1HaPf6P9rJlJpIMgIB0Ee28xtthiiUYTe++9d43GFk2i
pmh6jwrchQ52UzQqcDdmv9jAzKy91nMcv0/wf30d5xXoFfTVI/jrcojb1nLo
1nLY1nL41kr49krE9sPI7YfR249idh7F7jyOV68mqNeuadava56kap+mA88y
wec3oY0CeOO2frPUuFll3qi3bbTsPes4fDpwvD79bW3p++O1n8sbp3PvzybA
X5O284nv56PnZyOOk2F0fxA39f4Jdfzf7eY/39W7NqqJx+X4Ugk2W4hO5qEj
2chgBtKXhvQkI13XnJ0JzvY4Z1uMsy3a2RrpbIlwNoc7m8OcTaHOxhBnY7Cz
IchZH+SoD3TUqRy1KkeN0qM6wFEV4KhUeFQo7OVye5lXqcx+1+uO1F7icVks
vbwt8SjyKnQXE3sUiJVfllRegV+XgryC3baWQraWQreWwty2l8K3H0RsP4jc
eRC1sxyzsxyrXolTryRoHl7TPLqufZwCPE4HVzOhtRx4LU+3VmhYKzGtlVlW
q22P6/Yethys9B8tT5wszX+bX/k+s/5z9M3pgPpswHTWf3TWc3badXHS5djv
RM2tBNz4p7r2z0+VrldlxNMS4lEhvpiPzeZgU5noWDo6nIIOJiH9iUhvPNId
i3RFI51RSEcE0h6OtIU520KdrSHOlmBnc5CzyS3Q2ahyNqic9UpnndJRF+Co
DXDUKBzVXlVyR6XcUSFzs5fL7GUye6nU467UfkfiUSKxF3tc3hZ7FIkvCz2U
XxZUXz0CvYK2FoK9QrYWQrc9wrYXwncWInYWIncWotSL0erFWPVinGYpQbOU
qH2QBDxIAZfTwOUMeDlLt5yrXy4wLheZHtyxLJXZFqr35lsP5voOZ8eO782c
TC5+G3n4vevlj/atn+3607b905afp42/Tpou9xud5jpUV01oyj2XDO+KXJu3
iPU84mEOvpiJ30/HplOwievo6DV0OB4djEX7Y9C+KKQ3EukOR7rCkM5QpCME
aQ9G2oOQtiBna6CzReVsVjmblM7GAI+GAGe9wlmncNTKPWrkjmqZo0rmqHST
OiqkjnKpvUziUSqx3/W6I7aXeBV7XN4WXRaJlF/nVV/n3ALdtuaCPO4Hb90P
2fYI3b4ftnM/fOd+xM79SPVclHouWjMXo5mL087Fa+cTgfkkYD4ZnE+F5tPh
+UzdfLZhLtc4V2CeLbTO3LHdq9mbbt2f7DkYHzkamToeuH/StfStfvN7w+cf
DdCPeuuPmpMfVacnVef7lXZLhVNXimlLiK1C18e8P1/nuJ5nudYyiJV0fDEF
n7uO37uGTSZg43HYaAw6HIUORqID4Wh/GNobivaEIN3BSFcQ0hmIdAQi7Sqk
TYm0KpGWAKdbs8LZpHA2yp0Ncme93Fknc3PUyhw1Uke11FHlJnFUShwVEke5
m9heJraXet0V2++IPEpE9mIP5df7yq+zKret2UCPmaDtmWCvkO2Z0B2PsJ2Z
cPVMhHomUjMTpZmJ1s7EamfigJkEYCYRnEmCZpLhe6m6e+n66UzDdLZp8qZ5
4pZ1vNQ2VrM70rI33L0/MHjYO37Uce+4cfGk4vm3yg/fKrTfy03fSw+/3/lx
XHK2X3JhKbbrizwnH9t5+Ods17uMP1+muZ6lutaSiZUkYikRn4vHZ2Lx6Rhs
Mgobj8RGw7HhMHQoFB0IQfuD0b4gtDcQ7VEh3SqkU4l0uAUg7QqkTYG0KpAW
ubNZ7mySORtlzgaZs17qUSd11kocNRJHtVeV2FEpdlR4lYsdZSK7W6nIftfr
jtBeIlR+nVFu3VN5BbptTwd5Be9Mh+xMuYWqp8LUU+HqqQiNR5R2Mlo7GQNM
xgKT8eBkAjR5DZ5I0k0k68dTDWPpxtEbppGb5uEiy1CZdaB2t795r6dzv6v/
oG3ksHHiqGLhuPjpccm7k5Kdb8X6b0V73wq+Hef/3C/4Zcm/MOQ5wJuIOgv7
koF/SHO9Sf7zxTXX00TXagKxEkcsxeLz0fhsFH4vAp8KxybCsLFQbDQEGw7G
hoLQgUC0X4X2KdFeJdoTgHYHIF0KpFOBdMiRdjnSJkNaZUiLzNksdTZJnY1S
Z4PEo17irJM4a8WOGq9qsaNK5Kj0qhA5ykXeYkJ7qdddYcDWtHJryk3ltj0V
uD3pFrTjNhG8MxGidhsPVY+HacbDNeMR2vFI7VgUMBYNjMWAo7HQaBw0kgCP
JOqGk/RD1w2DycaBDFN/nrnvtqWnzNpdY+ts2m3r2Gvu3a8fPKgcPSyaOypY
Pyp4c5y/dZIHn+RaT3KOjzO/72efWrPPDVmXUIZDk45spaKfruPvrhGvElyb
sa6nMa7VaOJhFPEgklgIx++H4TOh+HQIPhmMTQRhY4HYiAobVmFDSnQgAO0P
QPsUaK8C7ZGj3XK0S4Z0ypAOGdIuRdqkSKsUaZEgzRJnk8TZKHY2eNWLnXUi
Z63IWSNyuFWLvMWEHhVCR7mXp5ggYGvSTbk1odyeUG2PuwXuuI0FuanHgtWj
IW6a0VDNSJh2JFw7HAEMR7qBQ9HgUAw0GAsPxOn64/V9CYbeJGNPmrE729SV
b+4stnSUWdtqbM2Ntoa23druvYr+/ZKhg+z7h9mrh9mvjrI/H2cBxxmm4/SD
49ST/bQf1rQzY9o5nHqpTXZsJyGfE9H38fibWOJltGsj0vUk3LUa7noYRjwI
JRZDiLlgfDYIvxeITwXikypsXImNBWAjAdiwAhtSYANytF+O9snQXhnaI0W7
pWiXFOmUIB0SpF2CtEmQVjHSIkaaxc4msbNR5Gzwqhd5iwmdNUKHW7XQUeVV
KXBUCBzlHgFb4wHbbmNKj1HVjttIoJt6JEg97BasGQpx0w6GagfDgAG3cLA/
AuyPhPqi4N5ouCdG1x2j70owdCYbOm4Y23NMbQXm1mJzc5mlsdpa12Crbtkt
79wt6dnLG9pPv3+Q/vgw/cVh+sejNM1RiuHo+t7RtaODa99sST9NSWe6a+dA
4uVOguNLHPIxBn0Xjb2KJDbDXc9DXU+CXavBrodBxHIQsRhIzKuI+yp8RolP
B+BTAfiEAhtXYKNybESODcuwQRk2IEX7pWifFO2VoD0StFuCdomRTjHSIUba
xUibCGkVIS0ipFmENAmdjUJng1e90FkndNYKPGoEjmqBo8rLU8xfsT0a4DHi
ptwZdlPtDKnUQ4HqQbcgzYBbsLbfLUTbFwL0hoK9YWBPONQdDnVFwJ0Ruo4o
fXucvi3J0JpqaMk0Nt80Nd0yNZSY68osNdXWynprabOtuH03v2s3Y2jv+uz+
9YcH1zcOrr8/TNo5vAYfJlgP4w4PYk9scd9N8af6uF9g7IU6xr4V7fgUhbyP
QN+EYS9D8c1g4lmQ64nKtap0PVS6lpXEUgCxEEDMKfBZBX5Pjk/J8UkZPi7D
xqTYqBQblmJDEmxQgg1I0H4x2idGe8RotwjtEqGdIqRDhLSLkDahR6sQaREi
zUKkSeBsFDgbvOoFzjpvrlp/Z42/o9rfUeWh2B72GgrYcRtUuqkHlOp+lZum
L9BN2xuk7XELBrqDga4QsCsE6gyFOkLh9jBdW6SuNVbfkqhvTjY0pRsas4z1
uca6QlNNibmqzFxeZblbZ73dZMtvtWV17F4f2kuY2UtY2U94fpDw9iD+60Es
eBBjOojaP4g4skV9M0f90EedQlG/NJEX2xH2L+GOj2HOdyHo62DsRRC+oSKe
Kl3rAa5VueuR3LUsJ5bkxIKMmJMRs1J8RopPS/EpCT4hwccl2KgYGxFjw2Js
SIwNirB+EdonQntFaI8Q7RaiXUK0U4h2CJF2AdImQFoFSItXs8BbzN/Z4FXv
76zz9+T6p5h8e1DhtjPgFrDTH6Duc1Oqe5WaHjeVtlul7Qp0AzoDgY4gsD0I
bAuGWoPhlhC4OULXHK1ritc1JukbUvT1Nwy12caaPGNVoamixFRaZi6ptBTV
WvIbrNktttQ2W8zQbszMXszyXszT/Zg3+9FfDiK1BxGGg7Ddg5DD3dBjc9h3
Q/hPOOxMG/ZrJ/Tia4j9U7DjfZDzTSDySoVuKrHnCvypnFiXuValrkdS14rE
9UBCLEqIeQlxX0zMiPF7YnxKjE+K8AkRPibCRkXYiAgbEmKDQmxAiPUL0T4h
2itAewRotwDtEqCdArRDgLT7I23+SKs/0uKPNHs1+f9drJ7vUcd31nrIt/vl
O259ip1ehdqtxy1A0x2g6QrQdCq1bh1KoF0FtKnAVhXYEgg1B0JNwXBjONwY
pWuI1dUn6uqu62vS9NUZhqocQ0WesazQdLfEVFxqLqw059VYsuut6U3WxHZb
xNBu5L3dyAd7kU/2Il7th3/aD1Pvh+j2g637gfu7gUeWoBNj8Hc4+CcQfKYO
Ot8KuvgcaP+gcrxTOl8HIC8V6KYcey7Dn0iJdQmxKnY9ErlWRK4HImJRRMyL
iDkRMSvE7wnxaSE+JcQnhPi4EB8TYCMCbFiADQmwQQE2IMD6BWivP9rjj3b7
o13+aKdXh7+3GB9p5SMtfKSZjzR5OBv5zgb+v4vJdnrd5Ds9cnW3V5dC0+nV
odC2B2jbAoDWAKAlAGxWgk1KqFEFNQRDDWFwfSRcFwPXxutqrumqk/WV6fqK
TENZjuFuvrGk0Hi72HSr1JRXYc6utqTXWZIardEd1tAhW+i93dCl3dD1vdCX
eyEf9oK39wKhfZVpL2BvT3FgUR4bVd90qh+g6lSjOttWnn9RXnwKsL9XON7K
na9kyAspuiHFnknwJ2J8TUSsCl2PBK4VgeuBgFgUEAsCYk5AzAqIGQE+LcCn
BPikPz7uj4/5Y6P+2Ig/NuSPDfpjA/5Yvz/Wx0d7+WgPH+3mo118tJOPdvCR
dr4n19/FeEgzD2nycDbynA08Zz1PttPtoe6SqTvd5JoOuaZdrmmTa1vdFECL
AmhWAE0KsFEBNiih+iCoLhSqjYBrouDqWLgqQVeZpKtI0Zfd0JdmGe7cNBTn
G4sKjQXFpty7puxy840qc3KtJa7eEtphDRqyBU3bgpZ2g9Z2Azd3A9/vqb7u
BQB7CsOezLYn3bfKDk3yE73iO6T4oVWc7ih+bcnPP8svPsjs76SON1LnSwmy
KUafi7BnIuyJEF8TEI/9iUf+rhW+a5nvWuITC3xijk/c5xMzfOIeH5/m45N8
fIKPj/PxUT42wseG+dgQHxvkYwN8rJ+P9vHQXh7aw0O7eWgXD+3koR08pJ2H
tPGQVq9/F3PnauRKdzqlarcOqbpdpmnzapVpW2TaZpm2SQY0yoAGGVgvB+uU
YG0gVBsC1YRD1ZFwVQxcGQ9XXNOVXdeVpurv3NCXZOlv3zQU5hvyC403i41Z
d003yk3JleaEGnNkvUXZaVUNWVXTNtWiTbm6q9zYDXi7q/iyK9fsSnW7Esuu
aM8qPjBJjvTSE1j2HZD9VMtOt6W/vkjPP0ku30vsb8WO1yLnSxGyKUSfC9Cn
AmzdH1/j44/5xCOea4XnWua6lnjEAo+Y5xH3ecQsj7jHw6d5+BQPn+Dh4zx8
jIeP8rARHjbEwwZ52AAP6+dhf+fiot1ctIuLdnLRDg+knYu0cZFWLtLCRZq9
mrgSdYdE3S5Rt0k1rVJNi4e2WaptkmobpUCDFKiXgnVysDYArAkEq4OhqjCo
MgKqiIbLY+GyBLg0SXc3WVeSpr+doS/K1hfcNOTlG24WGrOKjTfumFLKTIkV
5phqc0iDRdFpUQxZFVNWxYJN/tgmf26TvdmVftqVqHfF8K7QtCvYtQn2zcJD
g+gYFn8DxT804p874rOv4l+fxecfRJfvRPY3QscrgfOFANnwR575o0/52Dof
X+Phj7nEIy6x4uda9nMt+RGLfsS8HzHHJWa5xAyXmObiU1x8kotPcPExLj7K
xUa42DAXG+Jig1xsgIv1c7E+LtrL/d/F/srlKeaHtPghzX5idZtE3SrRtEg0
zRJNk0TbKNE2SLT1EqBOAtRKwBoZWBMAVqvAqiCwMhSqCIfKo6CyGLg0Dr6b
CJdc1xWn6IrSdbcy9AXZ+txcQ06+IbPQmH7bmHLHeK3UFFthCq8yKxvNsi6L
bMgim7JKF6zSRzbJM5vklU380Sba3hWAu/6GXb7Vxtsz8w+MgiOd8AQUftMK
f+wIT7eEZ1+Evz4Kzt8LLt8K7K/9HS/9nZt85wYfecZDn/CwdS62ysUf+xGP
/IgVjmuZ41riuBY5xDyHmOMQsxxixo+454dP+eGTfviEHz7uh4/54SN+2LAf
NuSHDfphA35Yvx/W54f1+qE9fmi3H9rl1emHdvih7X5Im58nV6u7VYtY0yzW
NIk1jWJtg1hbL9bWiYFaMVAjAaplYLUCrFKClUFgRQhYHgaVRUCl0dDdWPhO
PFx8Db59XVeYqruVrsvP1Odm67Nz9Zn5hvRCQ8pt47USY1ypKbLcFFxpkjSZ
xV0W8ZBFPGUVz1vFD62ipzbhS5vgg83/q42vtfH0Nq7Fxtm1cPeNvEM9/xjy
PwH8v6v9f2z7n371P/vk/+uD/8U7/uUbvv0Vz/GS59jkOp9zkWdc9Ikfuu6H
rXLwxxz8IZtYYRPLbNcDX9cim1hgE3Ns4j6bmGET9zj4NAef4uATHHycg49x
8FEONsLBhjnYEAcb5GADHKyfg/Vx0F4O2sNBuzloFwft5KAdXu0cpI0jUjeJ
NI0iTYNIUy/S1om0tSKgRghUS4AqGVCpACuVYEUgWB4MloWCpeHQ3SjoTgxU
EgffToCLkuBbybqCVF3eDd3NTH12tj4jV5+eb0i5ZUi6bYwvMUbfNYaWmQKq
TMIms7DbLByyCKc8w5fCFavgidX/hZX/zsb7YuNqbH6wjWOysW0W9p7J70DP
PYJ5xwDvm4b3fYf3c4t3+pl39pF3/p538ZZ7+Zprf8V1vPBzbPg5n/shTzno
Ew66xsZW2fhjNv7Ql1jxJZZ9XQ9YrkUWseBLzPkS932JWV/iHpuYZuNTbHyS
jY+z8TE2PsrGR9jYMBsbYmODbGyA/Vcu7N+5/rNYO0eoaRBq6oWaOqG2Vqit
EWqrhUCVGKiUApVyoCIALFeBZUFgaQh4Nwy8EwmVREPFsVBRPFyYCBckwfkp
cG6aLueGLitTn5GjT8/Vp+Qbkm4ZEooMMSXG8LvGwDKjtNrk32wSdJv9h8z+
k541Vf8VK3/dytu0ct9a/T5bOTtWNmjzNdpYVitr1+S7b+AcwJwj0O9E6/dN
zf2xxf35hXv6ifvrg9/5O7+Lt36Xr/3sLzn2TY5jg+N8xkaespF1Nrrmi636
Yo988YcsYoVFLLNcD5iuRaZrgUXMs4j7LGKWRcz4EtO++JQvPumLT/ji4774
mC8+4ov/Vy6vPjbWy0Z72Gg3G+1io51stIMt0NQJNLUCbY1AWy3QVgmBSjFQ
IQUq5EB5AFCmAkuDwLsh4J0wsCQCLI6CbsdAhXHQrQS44Bqcdx3OTYFz0nRZ
N3QZWbq0HH1Krj4pX59wyxBTZIgoNgTfMSpKjYIaE7/FxO8284fMvEkLb87C
W7Zw16x+G1a/N1bORyt72+oLWFl6K8NipdvMzD0Da1/newixjwHOiZrzfZvz
4yvn52fO2UfOr/ec83ecizfsy1ds+wu2fZPteO7rfOaLPPFF1lnoGgt7zMIe
sfCHTHyFSSwziQcM1xLDtcAk5pnEfSYxyyRmWMQ9FjHFwidZ+AQLH2d5co16
imHDvtiQLzboiw34Yv2+WJ8v1uuL9vii3V5dbH9Njb+22l9b5a+tFGor3KEk
QLkMKFMApUrgbiB4JxgsCQWLw8HbkWBRNFQYCxXEQ/mJUG4SfDMZzk6FM9N1
NzJ0aVm6lBx9Uq4+IV8fe8sQWWQILTao7hilpUZurZHbYuJ2m7hDZu6k2e++
xW/ZwlmzcJ5b2K+tvh+srK9WptbKgK10k5VmNdN3jYx9PfMAYh0Bvsca3287
vt+32D++sE8/sc8+sH+9Y5+/9b147Xv50tf+wte+wXI8ZzmfspAnLGSdia4y
0cdM7BETf8jAVxjEMsObi+5aYBDzDGKO4c3FJO4xiWkmPsn8JxcLH2XhIyx8
mIUNsbBB1v/P9R/F+NoqvrbSX1sh0FaItOUSoEwGlCqAuwHAHRVwJwgsCQFv
h4FFEWBhFHgrGiqIhfLiodxEKCcJzk6GM1PhG+m6tAxdSpYuKUefkKuPzddH
3dKHFRqCbhsUJQZhmdGvzujXauL0mDhDZs6kd3j9gYW9avF9ZmG9sjDfW5hf
rAy1lQ5ZaUYr1WKh2oy0PT19H2YcgswjLetEzfq2zfrxlfXzM+v0I+vsPevX
O9b5G9bFK9blS5Z9k2XfYDqeMZ1PmcgTJrLOQFcZ6GMG9oiBPaTjK3RimU48
oBOeXHRink7M0YlZBjHDIO4xiGkGPvVXMSY+xsRHmfgI8+9cfxdjYf0srI+F
9bLQHhZPW8n3hCoXacsk2lIpUCr/O1RJIFAcDN4OBYvCwcJIsCAKzI+B8uKg
mwlQzjUo6zqcmQLfSIXT0nUpGbqkLF1iji4uVx+drw8v0AcXGpS3DZISA6/c
yK4zsltN7B4Te8jkO2n2vW/2XTKzHluYzyzMlxbGOwv9s4W2Y6GCForeQjZb
yFYTZddA29PRD0D6kZZxrGac7DC/bzF/fGH+/MQ8/cA8e8/89ZZ5/pp58Yp5
+YJp32TYnzMczxjOpwznOgNZc+eio4/p2CO6NxcNf0AjlmjEIs21QHPN0zy5
7tOJGTpxj+7ORUwx8EkGPsHAxxn/LoYNM7EhJjbIxAaYWD/zr1x8bblAW+YO
JXaH0t6VA3cUQIkSKA4EbgcBRSFgYRh4KwIsiATzo8HcWOhmPJSdAGVdgzKu
w+kpcGoanHwDTsrQJWbp4nJ00bn6iDx9aIE+sFAvLzIIiw3sCoNvvdG3zcjq
MbGGTaxJM2vWzFwyMx+ZGU8t9BcW+lsL7ZOFum2haC1knYVksvhYTCSbgbKn
o+5DtEOAdqShn+zQv20xvn9l/PjM+PmRcfqecfaO8esN4/w14+Il4/IFw75B
tz+nO57RnU/oznU6skZHV2noYxr2iIa5Wy3/lYtKLFJdC1TXPJWYoxH3acQs
zZuLTkzR8Un6P7kY+CgDH2Hgw4z/ytXPdIcSakvF2rtS7R0ZUKIAigOAYpU3
VDBwKxQsCAfzI8C8KDA3BsyJg7LjocxEKCMJSk+GU1Pg5DQ46QacmKGLz9LF
5Ogic3VhefqgAn1AoV5SZOCVGJiVBmaDkdlmZPaYmMMm5oSJMWtmLJnpj8z0
J2bapoX6xkL5aKF8tZA1FhJk8TFarprNPlYjaVdP3oMpByD1UEs7VtNOtmnf
vtK/f6H/+EQ//UA/e08/e0v/9YZ+/op+8ZJ+uUn35qI5ntKcT2jOdRqyRvPk
crd6SMVWqPgyFX9A/SsXsUDx5qIS96meXDM0YppGTNG8uej4OB0fo/9HLq9B
BjbAEGrvirV3JO5Q2hK5J9RtJVAUCBS6Q4UABWHeUJHgzWgwJwbMjoMyE6CM
a1B6EpSaDCenwklpcOINOD5TF5Oli8zRheXqgvP0ygK97JZeWKTn3DEwqgyM
BiOj3cjoNTKGTfQJE33WRFs00x6aqetm6oaZ8tpM/mAhfbGQ1BYf0HJVb7li
Nl+xGK/a9KQ9mLwPkg+1lCMN9XiHerJF/f6F9uMz7edH2ul72tk72q83tPPX
tPNXtIsXtMtNmn2DZn/mzkV1PqE616nIKhV5TEUfUb25KPgyBX9AwZcoxCLF
m4tCzFG8uajEDJW490+xCdrfuTzF6PgIHR+m/5VL5AlVItUWy7W3FUCREihU
AbeCgIIQID8UyAsHcyPAm1FgTjSYFQtmxkM3EqD0a1DqdSg5GUpKhRPT4Pgb
cGwmHJWlC8/RhdzUBebpFPl68S09r1DPvGugVxvojQZ6u5Hea6QNm2gTJtqM
ibpooj40U9bNlA0z+ZWZ9N7s89nss2O+Cpiv6Mx/mMy/W4xXrIaruzqfPYh0
AJAPNeSjHcrJNuXbV8r3z9Qfn6g/P1BP31PP3lJ/vaGev6Kev6RevKBeblDt
z6n2Z1RPrnWqc42CrFKQxxT0EQV9SHHnwv7ORSYWycQC2bVA9uaiELMUby4q
MU0lpqj45F/FaPgY7T9y0cXeUDJ3KG1RgDdUIFAQDOSHAHlhQG44mBMJZrtD
xYAZceCNeCgtEUq9BiVfh5JSoMRUOD4djr0BR2XCEVm60Bxd0E1dQJ5Omq8X
3NJzCvW0UgOt2kBrMtDajdReI3XYSJ0wUWZMlAUTZcVEXjOTnptJL80+78xX
P5mvbJuvaM1/wObfjebfzKbfLYY/bLqre5DPPuhzoCUdqcnH2+STLfK3L+5c
lB8fKT/fU07fUc7eUn69ppy/oly8oFxsUi43KPbnFPsziuMJxblO+Y9cZPQh
GVshY8tk/AH5v3ORiftkby4KcY/yTy4qPkH9JxcNH6HhwzSJ9rZMWyTXFgZo
C5XeUEGeULmhwM1wICcCzI4Cs6LBjFjwRhyYlgClJkLJSVDSdSgxBYpPhWPT
4egbcEQmHJalC87RKW/q5Hk6Ub6eX6Bn3dZTy/TUGgO1yUDtMFJ6jZRho+c1
4IyJvGAirZhIayafZ2afl+arb81XPpqvfDX/oTH/Dpp/05v/ZTL9ZjH8btX/
sQtf2QOvHmh9DjU+Rzuk4y3SyVfyt8/kH5/IPz+Qf74nn74ln70h/3pNPn9J
vnhBvtgkX26Q7c/I9qdkxxOyc53sXCMjq2TkMfm/c5HwJRKxSCIWSMQ8yTVH
8uYiEzNkby4KMUX5JxcVH6Pio1R3Lqk3lEJ7S6ktUAH5QUBeMJAbAtwMA3LC
gexIMDMKzIgBb8SCafFgagKUfA1KSoISk6H4FCg2DY5OhyNvwGGZcEgWrMrR
KW7qJLk6Qb7Or0BPL9ZTyvWUWgOl2UDuMJB7jeRhI3nCSJoxkRZMPssmn1XT
1aemqy/MV96Y//hg/uOL+fcd82+A+V8687+M5v8xG3+z6n+3wX/sQVf2gasH
mquHap/jbZ+Tr6RvX0jfP5F+fCT9fE86fUc+c+d6Tf716p9cG+TL5/8rFwlZ
JSGPSegjEvqQhK2QsGXSX7nwf+ead+ciEbMkby4yMU125yImKfgE5d+5ZN5Q
Ae5Q2vxAIC/IGyoUyA4HsiKAzEgwIxpMjwHT4sCUeDA5EUy6BiUmQQnJUFwK
FJMGR6bD4RlwSCYcmAUH5OhkN3WiXB0vX+dboKeU6MkVenKtgdxsIHUYSH1G
0rCRNGH0mTH6zJuuLpuuPjZdeWq6smn647Xp9w/m37+Yf9s2/0tr/hds/h+j
+f+YjP9j0f/Lqvt9F/pjD/hjX3vlUH31aOfq8ZY7l8+3zz7fP/n8+ODN9ZZ0
9ob06zXp1yvS+QvSxSbpYoN0+Zxkf0ayPyU51knuVk5vK8TbCl35K5cP/sAH
X/LBF32IBR9i3sc170PM+Xhzkf7JRSYmyZ5cnmKU/weAoPXj
           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL
xd0dSpGi5T17zfOt9f2xV0/3nXNmZj/DhVSytO4R2d0fEBBQ1QsIiGF/9Zn0
95lNmajto4AseKq1LghPdUxTVjzVsUzZ8FTHNmXHUx3HlANPdVxTTjzV8UzB
eKrjm3LhqU5gyo2XxpTWVMxUlDqdqTheIlNiUz5TXuokphA81UlN+fFUJzMV
wFOd3FQQT3UKUyE81SlNoXiqU5kK46lObSqCl5ozF8XTXRKa8nCnhJw5L57u
EmgqwZ2CuXe4qbIpvSmDqZSpJHVG0zd4meBWxlSaWtzK4mWBWzm8ILiVx8sK
twp42eAWhpcdbhXxcsCtEl4o94401eEu6TlrCe6ie1fhTrm5d1W8PGRRDS8v
3Krj5YNbDbwQuNXEyw+3WngF4BaBVxButfEKceY6eDnJvDJ3Kgy3utypCCzr
4anWu4vCK849G5jqU+vuDfHKk2NLUwt6i7M2irXi2IieUrBtjFcWTs1NzajL
M0teaTg3NTVhL3FqxZ5lmNGMNWFwa82aGuTWxdSZDJRFW1MbanFrhxcOt/Z4
VeDWAa8anDqZOjK3q2miaQJ71cLrQi0u3fCqc6bOzKjImdpw5gi4daenNix7
4NWBW0+8unDqbepFrdz74EXBoi9efbj1w2sAl/54DeEyAK8RrAbiNSHnwaZB
1Mp+CF4zuA3Fi+SMvThzc9gOY01LOA03RZOBshhpGkEtLqPwWtATzYxW9Ixg
RmdyF4vx9IrjaGa0h+VY0xhqcRyH1xEu3+J1YuZ4vHbMGMNMvY1q9HWAsbhN
CnBvYotpq+m86S8YitsU02Rq5TIVrydZTcPrBcfpeL3hOAOvDxxn4vWF43d4
/eA4C68/HGfjDYDt93hjuffPpqXUuvcyvCFw+8E0j1oc5uMNg82PeNFw+Qlv
OKwW4I2A60K8kXBahDeKnBfjjSb7JXhjOPNSPL1JvcO5pjnUQzjrXO4ilsu5
0yzuvdH0W4B7N+K20rSCWixX4U2C22q8yXBbgzcFbr/gTYXbWrxpcFuHNx1u
v+LNgNt6vJlw24C3iHvvNe3hLhM463LuIpabuNMc7q13uJlaWWzFmwe3bXg/
wG073ny47cD7EW478X6C2y68BXDbjbeQM+/B+47Mf+NOi+G2jzstgeV+PNV6
dwfwlnHPQ6aD1Lr7Yby15HjKdJLeZaw9wFpxPELPSjgexVsDpxOm49RrmXWC
teJ8jJ51cPqdPVcz4zhrfoXbadZsJ7dLpotkoCz+MJ2hFrc/8TbC8izeZrjp
u+QczMTpQoD7jtF3j75j9C4nsZe4XGbPnXC5greNM11kxnrOdIYz74LbVXp2
w/Ia3h64XcfbB6ebphvUyv0W3gFY3MY7CLc7eIfgchfvMFzu4R0h9/t4R8n5
Ad4xsn+Idxxuj/D2csYbnPkEbB+z5hScnpqekIGyeG56Ri0uL/BO0vOEGb/T
84wZF8n9nektveL4khnnYPmP6RW1OL7GOw+XN3gXmPkWT7P0Nv5m5iW4/sue
l+H2Hu8K3D7gXSOHT6aP1MrmM949cvXsByu/z/VeY+0H1orrF3puwvU/vDtw
8+kHM5+rNVOz5N2C+1d67sMths/teZsZ6v3KZ+IY0+fWvOTuiaxO6HMMxSG2
1bF8rhabOD7nPYFLXJ/znsIqns95z+GSwOr4zNTsvKY8PsdIXJJYndjnanFJ
6nPeCzioTzMe8q50Fp35Ge9Gs7Xnazgm87kZb+GWwurkPsdIOae2OpXP1co+
jc95AeSYyZTR5xirR2tT+txacUzrcz2f4JTO57z/yD6D1enJOIBZ8j7DMdDn
et7xjjRbZ3zDW9RZk3EWsc3MmeKRYy5TMBkoi2ymrNTikh3PD/cszIhBj9YG
sVbcctATB2458eKTe272TADDPHhxOVMwPR57BLHnb6aNpj9Nf8BYXENM+WCk
exYw5YeRcihkKkitbELxAsm1pKkEvclZW4C1YlWYnlRwLYKXltyLm4pRBzKr
OGvFtSg96eFWij3TMKMYazLA9hvW5CCHSqaKMFPuZUylqZVLWbwsZFUOLwg2
5fGywSXMVIHskpJVCHsp+8rsGQyncLzsnKkiMzJyptKcORccq9CTG7ZV8VTr
12o1vBD2rmmqQa3ca+EVgEUEXkG41cYrBJc6eKFwicQrTO518YqQcz28omQf
hVcMbvXx8nFGna06n4ltA9aUhFMjU0MyUBZNTI2pxaUpXgl6GjKjFD2NmfGF
71m9k0B6xbEZM8rBsoWpObU4tsSrAJdWeGGwao1XlhnNmVkRzm1YUwnObfEq
w7EdXlXYdTR1IBNl09nUiYyVay9TT5hXZW171oprF3pqwrUrXm249TB1p45k
Vg/Wins3elpyr+GmaD6rTW83ziKuvTlTU+49xDQYBmLR39SPWhwG4NXjHfRh
Rn16tLYva8VuID2N4TwIrxlZD2XP5nAahteEMw2mJ4o9+rJnC+4YTU8rOI3g
zoOZO880F2biNMo0klrsRuO1g8MYvPawGYvXAbbj8DrBabzpW2pxmoDXBQ4T
8bqS+yS8brCYjNeaM47kDt3hOoU1PeE0zTSVzJXDDNN0amUzE68HPVOZ0Yue
6cwYQs4/kFFf2H3HjP5wm22aRS1u3+MNhMscvEFkPhevHzNmMXODz/0epd+b
zrC3uM3nDItMi017TXvIQFksNC0gU+W4wrScWjmuxBtOj9b+5HPvYjj1j8wa
xT4LYTaeWctgLs5LOMcovMX0TITTKvbUG9Bb+Nm0lM/EaTVrZpHTRu49BRa/
mNZQi8NavOlw+9W0jllTWLuatdP5bC1rxWk9PbPhsIk9Z/6/3LVG31X6ztG7
bsdnszjbBu4+lrssYZY4bmbmHNhuwZtPrjtM26mV9U68pWRzwLQfxvNZu421
YrWLngVw2Y23mHPs87k3sYSZ+/EWwmUPPfPYQ7O3wlRsD5kO+twbEbcjpsPk
qNx+N50iY2V93HSM3hWsPcTd5zF7C4xXs/aoz73laHKYz16r+OwIjMXtpOkE
e4vLac6wHg5n8NZyxlP0rGHGCc6oP7vozyz6fa08zMXprM/9GfCi336mMr0z
vfU7Zjr3X6Zz1LrLebytZHcBbxusLuJth+slvB1wu4y3E25X8HbB5Sreblhd
w9sD1+t4p8jhqekJtXJ4hifueku3TDdhKi53TLepxeou3mFyv4d3BBb38Y7C
7gHeMXJ9iHecrB/hnYDDY7yTnPkJnu6id3mDO+3jzDfxTsP2OXe6yr0/mj74
3PeiuL00vaAWy7/xzsLtFd45uP2D9xfcXuOdh9sbvAtwe4t3EW7v8C7B7V+8
y3B7j/eQe8eytxTT7+7yB2d9zl1070/c6Tr3/ox3gyy+4N2E5X94t+Gmf/H5
lVrcfH7n3YWb3++8e3Dz/M67D7cYfuc94Mw6q7wrZP6BOz2CW2y/u9NjWMbx
O0+13l1cv/Oecc/4Vsfzu1p3T+B33htyTG51Mr/rVY/WasYLOCb0u56XcEzk
d94/cEpqdRK/qzVTs+T9DefEftfzFk4p/G7PV3BXr9a8g1tKv1sTQG6ZTBn9
LgNlkdrqVH5Xi1sav/M+wi2t33mf4JbO77wvsEtvdSBzM5vKmEqzlx8vE7W4
ZMH7CmudJYPfnVVn0llSslbcguiJwbvLihcTbtnwYsMphyk7tXLPiRcXbsF4
8eCWCy8+XHLjJYBLHryE5J4XLxE558NLDLcQvCRwy48XizNm58xJeScFWJMc
ToVMBclAWRQ2hVKLSxG8ZPQUZEYKekKZkZHcxeIbesWxKDPEUCyLm4pRi2MJ
PNViWxIvAzM1qxSz0tKrmZ/5dRzIrMxwK8ub6GTqbBpv+haG4lbeVI5auVTA
y0ZWYXjZ4VgRLwccK+HlhGNlvGA4huPlgmMVvNxwrIqXB47V8Ipz7wam+tTK
oiFeCNxqmmpQi0MtvAKwicArCJfaeIVgVQcvFK6ReIXhVBevCDnXwytK9lF4
xThzfTzdRe+wOnfKx5lr4JWCZWNTIzLQvTuY2vvduxG3pqYm1GLZDK8s3Jrj
lYNbC7zycGuJVwFurfDC4NYaryLc2uBVgltbvMpwa4dXl3v3NvXiLqU5a2Pu
ont35E7VuHcnvOpk0RmvBty64NWEW1e8WnDrhhcBt+54teHWA68O3HriRXLm
XnjhZN6eO9WDWx/uFAXLvniq9e764TXingNNA6h190F4rchxhGk4vXq7/ZnR
BI6D6WkKxyF4LeAUbRpG3YpZ0awV56H0tIbTSPZszoxhrGkDt1Gs6Upuk0wT
yUBZjDGNpha3sXgd4DYOryPcvsXrDKcJfvcdo+8efcfoXZZlL3GZzJ7d4TIF
rwtnmsiMtpxpNGfuAbep9PSE5TS8XnCbjtcHTjNNM6iV+3d4/WAxC28A3L43
zaYWlzl4g+AyF28wuc/DG0LOP+ANJfv5eMPg9iNeb844gzNHw/Yn1oyA00LT
AjJQFotNi6jFZQnecHoWMGMkPYuYMZHcV5lW0iuOS5kxDpbLTD9Ti+NyvPFw
WYE3gZkr8cYy42dmToLravacDLc1eFPg9gveNHJYZ1pLrWx+xZtLrltNW+id
xtpfWCuu6+mZCdcNeN/DbbNpE/VcZm1mrd7Cb/TMg9s29pzNDPVu5DNx3M6a
pdz9gGk/DMVhp2kHtdjswlsAl914C2G1B28xXPaZ9jJTs2+ZbrKXuBzEXwaX
Q3hLONN+ZsznTDs48yL22Muey+F4mBkr4XbUdARGyvmE6Ti1sj+Jt4kcz5nO
wngNa4+xVhxP0bMOTr/jbSD7P0xnyHgTs/5krTiepmcVexzjjCs48xHusBm2
f3GmPdz1uukaGSgL/Yx+kVpcLuNtgft5ZmyjR2svsFbcrtCzC25X8faS+w32
3AeLm3i7OdM1erayxwX21D9L2MzPmfrZ8wBcb/MGDnHPu6Y73Fs53Dfdo1Y2
D/BOk+tz0zN6j7D2LmvF6iE9x+H6CO8UuT81PaE+zaynrBXXx/ScgeUL9jzJ
jCes+RO2f5tekply+GB6DzPl/o/pFbVyeY13nqze4F2AzVu8S3D51+/+GcxB
MrtDhlfJ/iN7XoPTJ7zLnOk9M85yplec+TocP9NzA7Zf8G7C6T+82+yt/5D4
K7Vy93nOuwsLv+e8e3DzPOfdh0sMz3kP4BLTc95Dco/lOe8ROcf2nPeY7ON4
znsCt7ie825xxq+c+Sls43luzXNYJrA6vucyUBaJrU7kuVpcknjOewZ3rdWM
l+SmtQk992t5A+/kNL3imNRzM97AMrnVyTxXi2MKz3nv4JLSc96/sErlOe81
70C9mvkezqk9t+YDnNN4zvsIx7Se876QQ3qrAz1XK5sMnvNikms2U1bPMVeP
1qaDsbhm9FxPAFwz4XlwCzJloY7JrCDWintmelJwr1BTIT7z6M3MWcQ1O2dK
wr3zm0JgIBa5TMHUYpkbLzbvIAcz4tKjtTlhJnZ5TXmoxTkfXlI4FWDPZHAq
iJeYM4XQE4c9crJncu5YiJ6UcCrMnUOYW9NUA2biVNRUhFrsiuGlhUNxvHRw
LIEXCMeSeOnhVAovA5y+wcsIh9J4mci9DF5mWJTFS8UZi3CHLHAtx5qscKpg
Kk/myqGiKYxa2VTCC6KnPDOy0RPGjPzkXIuMcsKuMjNywbqKKRyG4lbNc/8P
RF64VMfLR+Y18IKZEc7MtqZ2ptGmUewtbhGcoZ4pytTH1JsMlEVdUySZKsfG
pkbUyrEJXig9WlvHc+8ilLo2s4qyT12YlWJWQ5iLc33OURQvip7ScGrKniWY
od4GfCZOzVgTTnbtuXc5WLQwNacWh5Z4YXBrbWrFrHKsbcbaMD5ryVpxakNP
VTh0NHXgs//LXWs+8fuM3nVaPgvnbG25ewnuUp9Z4tiJmdVh2xkvgly7m7pR
K+seeA3Ipr+pH4wjWNuVtWLVk55IuPTCi+IcfT33Juozsx9eXbj0pqcme2h2
F/YW2wGcoTHcBpkGkqNyG2EaTsbKeqhpCL2NWTuAu9dkdmcYN2PtYM+95ULk
EMFeTflsEIzFLdo0jL3FZSRnaAOHUXgtOeNwepozYxhnFDe9rTGe+zX1P4uT
Py0=
          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJxt2zGoZFcdx/FBm+DabBtEEFtLeaSR6YTdLIhWttFVYiXYhoQUaQXTJMZC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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    CircleBox[{0, 0}], 
    ArrowBox[
     NCache[{{1, 0}, {1, 
        Rational[1, 10]}}, {{1, 0}, {1, 0.1}}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->1576374737,ExpressionUUID->"909752ad-b487-4838-96f6-7cb035fe1f5b"]
}, {2}]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"150fd3a1-9afb-48de-ac5a-a32d4ce6ff95"],

Cell[TextData[{
 "The integrand has an essential singularity at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "2b82be83-ea99-41d4-ab76-43e8932e999c"],
 ". From the residue theorem, the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
    SubscriptBox["Res", 
     RowBox[{"z", "->", "0"}]], 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fc3e6a3d-92b8-444c-839b-85d34c4b89eb"],
 ":"
}], "SolutionAnswer",
 CellID->212196697,ExpressionUUID->"f0418767-2462-489d-b5b6-b6ca796ca78f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"Residue", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"1", "/", "z"}], "]"}], "/", "z"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0"}], "}"}]}], "]"}]}]], "ExerciseInput",
 CellID->71511531,ExpressionUUID->"a336858b-24c8-4f8d-8492-4561b30424d4"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->212060650,ExpressionUUID->"59e04564-bce1-4a65-8f08-4a3f6b413fc8"]
}, Open  ]],

Cell[TextData[{
 "The integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{"\[ImaginaryI]", "."}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6063950d-3e63-4707-aa53-061668fde436"],
 " Confirm with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->107298779,ExpressionUUID->"4f7d3bf5-d492-4933-8728-053553b652d8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"1", "/", "z"}], "]"}], "/", "z"}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", "]"}]}]}], "]"}]], "ExerciseInput",
 CellID->659629305,ExpressionUUID->"1a948ae5-671f-4f9e-8e46-b311b3824b93"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->407042305,ExpressionUUID->"119489e3-65d5-43d9-ad38-35a9fdda5cd9"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute the integral of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{"exp", "(", 
      SuperscriptBox["z", "2"], ")"}], 
     RowBox[{"z", "(", 
      RowBox[{
       SuperscriptBox["z", "2"], "-", "1"}], ")"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"75b47f74-21e1-4357-8ad1-517e517ed368"],
 " over a circular contour of radius 2 centered at the origin."
}], "Exercise",
 CellID->58706369,ExpressionUUID->"0f1daee2-dcfc-4d86-bc82-8528b39dba77"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"dc2bdbd2-d9f3-4d02-a04d-06efe86f2e9c"],

Cell[TextData[{
 "The integrand has poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", 
    RowBox[{"\[PlusMinus]", "1"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"69ab0315-a5d6-4749-9095-c1adb040a122"],
 ". So the integral is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]", " ", 
    RowBox[{"\[ImaginaryI]", "(", 
     RowBox[{
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", 
         RowBox[{"-", "1"}]}]], 
       RowBox[{"f", "(", "z", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "0"}]], 
       RowBox[{"f", "(", "z", ")"}]}], "+", 
      RowBox[{
       SubscriptBox["Res", 
        RowBox[{"z", "->", "1"}]], 
       RowBox[{"f", "(", "z", ")"}]}]}], ")"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"3bc163c8-d748-4d13-9022-67328c55a9b2"],
 ":"
}], "SolutionAnswer",
 CellID->200200665,ExpressionUUID->"880b3130-a8c1-42b1-9b1e-6c3669ae7d90"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"z", "^", "2"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "^", "2"}], "-", "1"}], ")"}]}], ")"}]}]}], 
  ";"}]}], "ExerciseInput",
 CellID->480349563,ExpressionUUID->"e19221c7-4f47-4b7e-b67b-cab89d011a35"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Residue", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0"}], "}"}]}], "]"}], "+", 
    RowBox[{"Residue", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "1"}], "}"}]}], "]"}]}], ")"}]}]], "ExerciseInput",
 CellID->31847898,ExpressionUUID->"78c0dd06-4c0d-48a2-89ea-60d630babd79"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], " ", 
  "\[Pi]"}]], "ExerciseOutput",
 CellID->30989533,ExpressionUUID->"ad8da967-2e46-401a-9f0c-a5a12c5fc629"]
}, Open  ]],

Cell[TextData[{
 "Check with ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->75938532,ExpressionUUID->"ec6f14c6-96df-43e4-a867-d292d943662c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"z", "^", "2"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "^", "2"}], "-", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}]}], 
  "]"}]], "ExerciseInput",
 CellID->19810814,ExpressionUUID->"bd8a376f-e96d-4cbb-8c35-9ac7f6346700"],

Cell[BoxData[
 RowBox[{"2", " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], " ", 
  "\[Pi]"}]], "ExerciseOutput",
 CellID->264557434,ExpressionUUID->"1a4d602e-ea60-4612-9fa1-c10dd3147665"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1578181806,ExpressionUUID->"34b5725a-b40b-4204-a72c-19478708b5ce"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"24. The Residue Theorem | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "23. Residues"}, "PrettyTooltipTemplate"], "next" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "25. Transcendental Equations"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"362517de-a20c-4669-9e2c-b81c0a7ee71d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[646, 23, 226, 7, 108, "Section",ExpressionUUID->"65b2b7df-0901-482f-8111-bdbcb21d1119",
 CounterAssignments->{{"Section", 23}},
 CellID->319933565],
Cell[875, 32, 236, 4, 60, "Text",ExpressionUUID->"6a454277-cf5b-41ea-9f72-407a269c6c98",
 CellID->707889707],
Cell[CellGroupData[{
Cell[1136, 40, 138, 1, 56, "Subsection",ExpressionUUID->"cc25c9e9-026e-4922-8b11-1470c4088dff",
 CellID->285552759],
Cell[1277, 43, 225, 4, 60, "Text",ExpressionUUID->"47b2c3f3-66e7-4598-ada8-802c0917c9c7",
 CellID->653667584],
Cell[1505, 49, 1153, 33, 60, "Text",ExpressionUUID->"2cb55b8d-25c1-4d4d-80a3-b1fb7e031b1a",
 CellID->38253147],
Cell[CellGroupData[{
Cell[2683, 86, 18718, 458, 70, "Input",ExpressionUUID->"b6bcf3be-6521-4b49-944d-676eab9c92de",
 CellID->4867055],
Cell[21404, 546, 140680, 2478, 230, "Output",ExpressionUUID->"e58c5c12-5378-4ef7-ba3f-624738f996a3",
 CellID->1895643021]
}, {2}]],
Cell[162096, 3027, 827, 22, 60, "Text",ExpressionUUID->"f241ad42-f27d-4086-b713-4dbf11d8e7a8",
 CellID->34505956],
Cell[162926, 3051, 906, 27, 47, "DisplayFormulaNumbered",ExpressionUUID->"5b9c2c02-c79e-4433-a6fa-5d4b2e6df485",
 CellID->200998358],
Cell[163835, 3080, 597, 14, 60, "Text",ExpressionUUID->"5aac415c-e571-47d1-8dd6-b1f65bd7422e",
 CellID->138128648],
Cell[164435, 3096, 861, 23, 60, "Text",ExpressionUUID->"5e84f2cc-b065-4f97-b7be-6315f2be808e",
 CellID->162770103],
Cell[165299, 3121, 877, 24, 62, "DisplayFormulaNumbered",ExpressionUUID->"67d8b047-4036-4282-94e5-06f6e14d22fa",
 CellID->9678041],
Cell[166179, 3147, 288, 7, 36, "Text",ExpressionUUID->"febeba12-200b-4fc8-954b-32f49f1fee14",
 CellID->255852303],
Cell[166470, 3156, 517, 13, 83, "Text",ExpressionUUID->"e96fb691-69fc-4742-b74b-c4da3f5dc9b8",
 CellID->2154169],
Cell[166990, 3171, 187, 8, 71, "SolvedExample",ExpressionUUID->"29a05808-361f-436f-ad9c-e4df4bfaa0c9",
 CellID->143564869],
Cell[167180, 3181, 971, 29, 43, "SolvedExampleNote",ExpressionUUID->"fd029876-e912-4361-b673-8c38ef839f9f",
 CellID->271115179],
Cell[CellGroupData[{
Cell[168176, 3214, 1672, 47, 27, "SolvedExampleInput",ExpressionUUID->"d3eb97c9-c39a-4ef3-b321-4666fc070875",
 CellID->106213142],
Cell[169851, 3263, 48405, 822, 200, "SolvedExampleOutput",ExpressionUUID->"7d882371-84d4-4370-972f-a114e0f20e2a",
 CellID->321876268]
}, Open  ]],
Cell[218271, 4088, 938, 28, 66, "SolvedExampleNote",ExpressionUUID->"b754fb04-30fd-478a-a67b-aa65708ef1b1",
 CellID->758682999],
Cell[219212, 4118, 1033, 29, 42, "SolvedExampleNote",ExpressionUUID->"fd880782-3ad9-4149-be11-10c2d509f828",
 CellID->778779165],
Cell[220248, 4149, 197, 6, 39, "SolvedExampleNote",ExpressionUUID->"535e6d77-d8ff-4ec7-af2b-d70e3ce09434",
 CellID->5084018],
Cell[CellGroupData[{
Cell[220470, 4159, 560, 17, 50, "SolvedExampleInput",ExpressionUUID->"d8fd224c-2c98-4722-96c7-acca87200355",
 CellID->336307413],
Cell[221033, 4178, 184, 4, 36, "SolvedExampleOutput",ExpressionUUID->"8a3b811d-e162-4481-82ae-5d6a18632acc",
 CellID->97175549]
}, Open  ]],
Cell[221232, 4185, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"e879692c-2405-4ab1-9b5e-8fd6e91c3ce2",
 CellID->943814759],
Cell[221341, 4188, 232, 6, 36, "Text",ExpressionUUID->"c0931114-9ab1-4ed8-919e-9d91f8a26709",
 CellID->664904150],
Cell[221576, 4196, 187, 8, 71, "SolvedExample",ExpressionUUID->"e545cff6-911a-4103-bd08-2400139c19ac",
 CellID->681037522],
Cell[221766, 4206, 440, 12, 43, "SolvedExampleNote",ExpressionUUID->"56977a16-a62e-4eea-94b0-521d323ac8d8",
 CellID->454938466],
Cell[CellGroupData[{
Cell[222231, 4222, 1589, 40, 27, "SolvedExampleInput",ExpressionUUID->"2483acc5-f062-4e71-964f-a1d65206c13e",
 CellID->314660347],
Cell[223823, 4264, 32276, 557, 200, "SolvedExampleOutput",ExpressionUUID->"92967d2e-41ea-4c42-a9ec-b2636eab51ea",
 CellID->757016192]
}, Open  ]],
Cell[256114, 4824, 392, 10, 39, "SolvedExampleNote",ExpressionUUID->"eb0a9c8c-7b9f-4881-b462-20fc13e673c3",
 CellID->36121136],
Cell[CellGroupData[{
Cell[256531, 4838, 919, 29, 43, "SolvedExampleInput",ExpressionUUID->"ae0b8088-35cd-4c29-bed9-8a5ba6d6c455",
 CellID->155190754],
Cell[257453, 4869, 168, 3, 36, "SolvedExampleOutput",ExpressionUUID->"87fd6b45-ec05-48ba-bebe-4a7818c60d5e",
 CellID->510174053]
}, Open  ]],
Cell[257636, 4875, 154, 1, 39, "SolvedExampleNote",ExpressionUUID->"5ae11266-8e24-4c54-84a2-32ed3845199e",
 CellID->698309545],
Cell[257793, 4878, 487, 16, 25, "SolvedExampleInput",ExpressionUUID->"510f4079-6649-4f69-b716-ecc48f9bb958",
 CellID->14916108],
Cell[258283, 4896, 181, 6, 39, "SolvedExampleNote",ExpressionUUID->"ded97e9c-d83f-4d55-b3cd-e544fcfe523b",
 CellID->86216678],
Cell[CellGroupData[{
Cell[258489, 4906, 522, 15, 25, "SolvedExampleInput",ExpressionUUID->"2d108e71-61f5-44af-9ba2-eb7dea7864c9",
 CellID->212835459],
Cell[259014, 4923, 167, 3, 36, "SolvedExampleOutput",ExpressionUUID->"53aeb1f4-9073-4eef-86d0-a55c3dbd459e",
 CellID->41258660]
}, Open  ]],
Cell[259196, 4929, 116, 1, 39, "SolvedExampleNote",ExpressionUUID->"de8f3519-423c-458b-9592-8a366affa4fc",
 CellID->175463711],
Cell[CellGroupData[{
Cell[259337, 4934, 244, 5, 25, "SolvedExampleInput",ExpressionUUID->"5458c82c-3415-4bec-ba82-e728b121509f",
 CellID->289282402],
Cell[259584, 4941, 168, 3, 36, "SolvedExampleOutput",ExpressionUUID->"ea3c62db-a9bc-44eb-be99-2eecd6a96861",
 CellID->106260084]
}, Open  ]],
Cell[259767, 4947, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"c9288a37-d2d7-482c-a850-ee098d8a7687",
 CellID->1403913282]
}, Open  ]],
Cell[CellGroupData[{
Cell[259911, 4953, 123, 1, 56, "Subsection",ExpressionUUID->"d8421a02-2483-4568-8e61-2f6fbac283c7",
 CellID->25482850],
Cell[260037, 4956, 349, 10, 36, "Text",ExpressionUUID->"435bb720-7a76-4847-a623-374bbd6bf27f",
 CellID->160347742],
Cell[260389, 4968, 548, 17, 48, "DisplayFormulaNumbered",ExpressionUUID->"6a55c087-e4a6-4496-a20b-debae0f9a049",
 CellID->232148208],
Cell[260940, 4987, 319, 8, 36, "Text",ExpressionUUID->"72ed7ed5-40cc-473a-a130-f1abff3a4003",
 CellID->187858047],
Cell[261262, 4997, 486, 11, 83, "Text",ExpressionUUID->"f31739fa-3fa8-41f9-90aa-c139c7518a65",
 CellID->7277549],
Cell[CellGroupData[{
Cell[261773, 5012, 3600, 103, 70, "Input",ExpressionUUID->"41b5d6f1-235e-4057-b739-7f0f23c48194",
 CellID->1542218885],
Cell[265376, 5117, 10556, 257, 273, "Output",ExpressionUUID->"ec6e90dd-02d4-4a03-b9e8-4af37d20eb46",
 CellID->780402502]
}, {2}]],
Cell[275944, 5377, 181, 4, 36, "Text",ExpressionUUID->"a70e803b-aba8-4e61-8ff9-594ba2491175",
 CellID->419172361],
Cell[276128, 5383, 534, 17, 47, "DisplayFormulaNumbered",ExpressionUUID->"20afe1c1-33fa-4221-915b-4ec4a4752921",
 CellID->511336443],
Cell[276665, 5402, 183, 4, 36, "Text",ExpressionUUID->"afec7386-3b04-49e2-8776-e0d603c76e8e",
 CellID->1177878],
Cell[276851, 5408, 543, 17, 47, "DisplayFormulaNumbered",ExpressionUUID->"7cc77698-b940-4857-92bd-e18575b620f9",
 CellID->107744892],
Cell[277397, 5427, 159, 3, 36, "Text",ExpressionUUID->"d27a8a3d-66e1-4ded-891f-d7a963365563",
 CellID->9843217],
Cell[277559, 5432, 565, 11, 83, "Text",ExpressionUUID->"7a72d609-76df-4b42-ae40-867a4c128fbd",
 CellID->388283733],
Cell[278127, 5445, 419, 10, 60, "Text",ExpressionUUID->"732706cf-d819-4a17-b012-10568278bafa",
 CellID->218035723],
Cell[278549, 5457, 554, 18, 50, "DisplayFormulaNumbered",ExpressionUUID->"61d86768-b771-41ac-b251-08a28d53b34b",
 CellID->370547823],
Cell[279106, 5477, 146, 1, 36, "Text",ExpressionUUID->"7d8f6d19-6b12-422c-bc20-09dc25f38b18",
 CellID->194864193],
Cell[279255, 5480, 449, 14, 48, "DisplayFormulaNumbered",ExpressionUUID->"422c2424-29cb-4d28-a6e2-5637ea84dc29",
 CellID->91607926],
Cell[279707, 5496, 495, 11, 60, "Text",ExpressionUUID->"0fbd658b-947d-42b9-be17-10738b1ee93b",
 CellID->221727902],
Cell[CellGroupData[{
Cell[280227, 5511, 11859, 301, 70, "Input",ExpressionUUID->"b99a3acd-1118-4d66-b030-cdd1f3addb17",
 CellID->1961108122],
Cell[292089, 5814, 23656, 550, 230, "Output",ExpressionUUID->"daf1eb1b-2221-4f30-9ae8-fa7f47433268",
 CellID->1797757395]
}, {2}]],
Cell[315757, 6367, 1483, 40, 83, "Text",ExpressionUUID->"1ad3feb9-b796-415f-8601-f11bd3ca49bf",
 CellID->139843979],
Cell[317243, 6409, 948, 30, 48, "DisplayFormulaNumbered",ExpressionUUID->"0b8685e4-ca61-4786-806f-b2f088f0a4c2",
 CellID->227341360],
Cell[318194, 6441, 342, 9, 36, "Text",ExpressionUUID->"46270e26-0e3e-4cc5-b306-82640eda99a3",
 CellID->692025257],
Cell[318539, 6452, 1046, 35, 50, "DisplayFormulaNumbered",ExpressionUUID->"befee305-c55f-4454-a292-bc59816052e1",
 CellID->402971688],
Cell[319588, 6489, 633, 16, 60, "Text",ExpressionUUID->"a7daf961-714f-469b-8894-3d08b7490ca5",
 CellID->348274579],
Cell[320224, 6507, 187, 8, 71, "SolvedExample",ExpressionUUID->"89c78765-99bd-447d-94a2-ae9febd2a390",
 CellID->185748738],
Cell[320414, 6517, 886, 27, 66, "SolvedExampleNote",ExpressionUUID->"2016124b-40cf-46ae-a2ce-fe8b48ae2672",
 CellID->232675498],
Cell[321303, 6546, 191, 4, 39, "SolvedExampleNote",ExpressionUUID->"45af5cf6-746c-48c8-a66d-514efee8d0fd",
 CellID->257756963],
Cell[CellGroupData[{
Cell[321519, 6554, 1644, 46, 27, "SolvedExampleInput",ExpressionUUID->"371138d1-1b7d-4d74-ac5a-3ac87c68516a",
 CellID->202706237],
Cell[323166, 6602, 50729, 858, 200, "SolvedExampleOutput",ExpressionUUID->"20a51321-c8d3-4d46-8bc7-d29a2a0506bd",
 CellID->94734540]
}, Open  ]],
Cell[373910, 7463, 136, 1, 39, "SolvedExampleNote",ExpressionUUID->"b597212a-8ae0-404c-b9cc-4d546292d659",
 CellID->253028289],
Cell[374049, 7466, 1321, 40, 102, "SolvedExampleNote",ExpressionUUID->"f3a31301-1424-4f17-8bd4-a9d4724ea4cf",
 CellID->223052188],
Cell[CellGroupData[{
Cell[375395, 7510, 510, 16, 50, "SolvedExampleInput",ExpressionUUID->"480c9b0c-3192-422f-b9e6-21136db68656",
 CellID->19313273],
Cell[375908, 7528, 164, 2, 36, "SolvedExampleOutput",ExpressionUUID->"5fbd38d6-f04f-4516-b5aa-6b0e0c1041e7",
 CellID->35630068]
}, Open  ]],
Cell[376087, 7533, 685, 19, 61, "SolvedExampleNote",ExpressionUUID->"c9328111-27ca-4e03-a90a-c38b0074dbaf",
 CellID->78982045],
Cell[CellGroupData[{
Cell[376797, 7556, 911, 30, 50, "SolvedExampleInput",ExpressionUUID->"eeafb6eb-27db-4589-9322-acd06ac8d27e",
 CellID->448410397],
Cell[377711, 7588, 164, 2, 36, "SolvedExampleOutput",ExpressionUUID->"266234e8-354e-4199-8ef2-b1362e2f283f",
 CellID->25404056]
}, Open  ]],
Cell[377890, 7593, 186, 6, 39, "SolvedExampleNote",ExpressionUUID->"e38846ac-abf2-406f-9fd6-41f058f9f922",
 CellID->146586059],
Cell[CellGroupData[{
Cell[378101, 7603, 526, 17, 50, "SolvedExampleInput",ExpressionUUID->"8a848108-3570-4096-a851-ebb6a5728c08",
 CellID->112433444],
Cell[378630, 7622, 164, 2, 36, "SolvedExampleOutput",ExpressionUUID->"ef0a8d92-7b8f-497c-98ea-5674a81fa40f",
 CellID->90008991]
}, Open  ]],
Cell[378809, 7627, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"167f87ad-768c-4255-9b19-350d61187377",
 CellID->261949398],
Cell[378918, 7630, 187, 8, 71, "SolvedExample",ExpressionUUID->"8b516b74-ea4d-4843-bff2-0d90c8165f99",
 CellID->259668533],
Cell[379108, 7640, 467, 13, 43, "SolvedExampleNote",ExpressionUUID->"cf33804c-88b5-44da-a7f8-30d12a0c9bdc",
 CellID->123650846],
Cell[CellGroupData[{
Cell[379600, 7657, 1785, 48, 27, "SolvedExampleInput",ExpressionUUID->"8c3ca584-dc34-4f16-b499-18b2721066e9",
 CellID->309295465],
Cell[381388, 7707, 51904, 887, 171, "SolvedExampleOutput",ExpressionUUID->"bfa00dbe-c6b8-4e12-9152-1abfcce8a12a",
 CellID->226631966]
}, Open  ]],
Cell[433307, 8597, 423, 9, 61, "SolvedExampleNote",ExpressionUUID->"e5781d5f-b07a-4003-862e-b85be52aebd4",
 CellID->100420980],
Cell[433733, 8608, 1535, 40, 44, "SolvedExampleNote",ExpressionUUID->"2beadbfe-e913-4229-88b6-083bcd5059d5",
 CellID->306463872],
Cell[435271, 8650, 190, 6, 39, "SolvedExampleNote",ExpressionUUID->"186e4bfe-c446-42ef-bc29-21d47813f581",
 CellID->19037616],
Cell[CellGroupData[{
Cell[435486, 8660, 728, 23, 25, "SolvedExampleInput",ExpressionUUID->"8554f2ab-696e-40a4-b1b6-88e8b869e89e",
 CellID->217839025],
Cell[436217, 8685, 204, 3, 36, "SolvedExampleOutput",ExpressionUUID->"a343259f-5de7-455e-b396-0cbc3cb09ab1",
 CellID->119671527]
}, Open  ]],
Cell[436436, 8691, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"4997a06a-1a70-40e6-905a-2c135ce565f7",
 CellID->1145953135],
Cell[CellGroupData[{
Cell[436568, 8696, 109, 1, 69, "SummarySection",ExpressionUUID->"47891946-93e3-45b0-9e05-dadb98feea85",
 CellID->1198545324],
Cell[436680, 8699, 480, 11, 52, "SummaryList",ExpressionUUID->"fd49aa90-8e52-4189-a1c9-ca9f41cb4562",
 CellID->108924727],
Cell[437163, 8712, 609, 18, 52, "DisplayFormula",ExpressionUUID->"e8ac0a9a-fa5e-4531-8f22-b81378d7e4d4",
 CellID->565877318],
Cell[437775, 8732, 190, 4, 29, "SummaryList",ExpressionUUID->"5a86741a-2b9b-42c7-81ea-f0758383179f",
 CellID->391990311]
}, Open  ]],
Cell[CellGroupData[{
Cell[438002, 8741, 160, 3, 65, "ExerciseSection",ExpressionUUID->"61b93e3f-866e-4acc-8a73-a231d59c7f60",
 CellID->164711212],
Cell[CellGroupData[{
Cell[438187, 8748, 633, 18, 54, "Exercise",ExpressionUUID->"d0173997-3372-40aa-b41d-f4a5add1b920",
 CellID->82742474],
Cell[CellGroupData[{
Cell[438845, 8770, 1720, 47, 96, "ExerciseInput",ExpressionUUID->"a02a9352-04a6-4dd8-9ff7-e7395a8c33e0",
 CellID->13239756],
Cell[440568, 8819, 52572, 888, 195, "ExerciseOutput",ExpressionUUID->"61b6ebb9-980f-46a3-aef9-ec40ba9193ca",
 CellID->1660285190]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[493186, 9713, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"b7f05265-2557-46bd-be10-72abf02203ac"],
Cell[493280, 9715, 1221, 37, 46, "SolutionAnswer",ExpressionUUID->"929aface-8ab4-42a6-8b64-a848d7308337",
 CellID->244671311],
Cell[CellGroupData[{
Cell[494526, 9756, 624, 19, 31, "ExerciseInput",ExpressionUUID->"56041476-7dd6-4938-896f-a434c181e2af",
 CellID->121541095],
Cell[495153, 9777, 293, 8, 61, "ExerciseOutput",ExpressionUUID->"762771de-0601-4c22-96bf-8649b9de0f02",
 CellID->7424240]
}, Open  ]],
Cell[495461, 9788, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"871309b0-9d01-4269-9a13-88048e97bb9d",
 CellID->198728578],
Cell[CellGroupData[{
Cell[495673, 9798, 379, 10, 25, "ExerciseInput",ExpressionUUID->"637ae7e4-e069-424d-909b-262d63ba7c22",
 CellID->102171682],
Cell[496055, 9810, 293, 8, 61, "ExerciseOutput",ExpressionUUID->"e13eb96f-005d-4e6d-bde8-b1dc40262704",
 CellID->4833483]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[496397, 9824, 591, 16, 25, "Exercise",ExpressionUUID->"b6411d5b-d7b1-446a-b362-277b0db6a3a7",
 CellID->182838476],
Cell[CellGroupData[{
Cell[497013, 9844, 1524, 42, 28, "ExerciseInput",ExpressionUUID->"8eab33e3-950c-47f5-84b4-bafdd1a9eede",
 CellID->137000149],
Cell[498540, 9888, 43623, 741, 195, "ExerciseOutput",ExpressionUUID->"eb58d719-bf83-4968-ab7a-f12315156824",
 CellID->291433386]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[542209, 10635, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"e5024fa9-0a99-4e93-b34e-2ebbbbcc5ce1"],
Cell[542303, 10637, 2030, 59, 70, "SolutionAnswer",ExpressionUUID->"f039e318-6f42-4682-84f6-e4ba96799bbe",
 CellID->35880266],
Cell[CellGroupData[{
Cell[544358, 10700, 499, 14, 25, "ExerciseInput",ExpressionUUID->"42fe072e-4393-41b1-bdcd-c31f8ee44641",
 CellID->236599034],
Cell[544860, 10716, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"c82f936d-0da9-4dc3-8273-76604d02e3ce",
 CellID->319147006]
}, Open  ]],
Cell[545034, 10721, 388, 11, 22, "SolutionAnswer",ExpressionUUID->"71f71107-b13d-4cf3-97f5-0b6373f383e1",
 CellID->103052096],
Cell[CellGroupData[{
Cell[545447, 10736, 517, 16, 25, "ExerciseInput",ExpressionUUID->"ec7e2b76-f7a8-4d0d-9fac-4c14ee9c46a3",
 CellID->248595258],
Cell[545967, 10754, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"e7049902-b45d-43de-a78b-a1c676d5520d",
 CellID->498827163]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[546175, 10762, 586, 19, 34, "Exercise",ExpressionUUID->"73a4b274-e1b1-4c96-8a21-2d86acbb8e7e",
 CellID->4016190],
Cell[CellGroupData[{
Cell[546786, 10785, 1819, 52, 52, "ExerciseInput",ExpressionUUID->"543f84eb-6735-40a5-8238-118f5d604653",
 CellID->16112824],
Cell[548608, 10839, 49676, 845, 163, "ExerciseOutput",ExpressionUUID->"dbc77fce-51ec-411e-abb4-e1fe299d31ce",
 CellID->1550213394]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[598330, 11690, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"75c21cce-d9d7-4e07-bbff-924b6c3522f6"],
Cell[598424, 11692, 863, 25, 43, "SolutionAnswer",ExpressionUUID->"22b80174-a91b-4a11-b6f6-9a302572fb8c",
 CellID->282354347],
Cell[CellGroupData[{
Cell[599312, 11721, 984, 31, 52, "ExerciseInput",ExpressionUUID->"74f1665f-2fb9-4eb0-9682-1c94483fddab",
 CellID->310648376],
Cell[600299, 11754, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"de4c352b-87d0-46a0-ae03-790fe188f1d5",
 CellID->512777348]
}, Open  ]],
Cell[600473, 11759, 187, 6, 22, "SolutionAnswer",ExpressionUUID->"ebcc2e9f-0af2-4746-b9cf-7a4ff1b4f823",
 CellID->80047752],
Cell[CellGroupData[{
Cell[600685, 11769, 748, 25, 25, "ExerciseInput",ExpressionUUID->"685ffab7-8fa3-4bc0-8e6c-2214caa11f37",
 CellID->90122048],
Cell[601436, 11796, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"3e3c9841-2459-4ecd-bd68-b5eeb36aa75b",
 CellID->177534748]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[601644, 11804, 419, 12, 29, "Exercise",ExpressionUUID->"26ed828d-44d3-48e3-9236-e0f99f4d77dc",
 CellID->77847676],
Cell[CellGroupData[{
Cell[602088, 11820, 1555, 43, 28, "ExerciseInput",ExpressionUUID->"027e51fe-1c75-4df4-afad-8c8196a71e0b",
 CellID->85005941],
Cell[603646, 11865, 48139, 815, 163, "ExerciseOutput",ExpressionUUID->"909752ad-b487-4838-96f6-7cb035fe1f5b",
 CellID->1576374737]
}, {2}]]
}, Open  ]],
Cell[CellGroupData[{
Cell[651831, 12686, 91, 0, 29, "ExerciseSolution",ExpressionUUID->"150fd3a1-9afb-48de-ac5a-a32d4ce6ff95"],
Cell[651925, 12688, 628, 16, 22, "SolutionAnswer",ExpressionUUID->"f0418767-2462-489d-b5b6-b6ca796ca78f",
 CellID->212196697],
Cell[CellGroupData[{
Cell[652578, 12708, 356, 9, 25, "ExerciseInput",ExpressionUUID->"a336858b-24c8-4f8d-8492-4561b30424d4",
 CellID->71511531],
Cell[652937, 12719, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"59e04564-bce1-4a65-8f08-4a3f6b413fc8",
 CellID->212060650]
}, Open  ]],
Cell[653111, 12724, 397, 12, 22, "SolutionAnswer",ExpressionUUID->"4f7d3bf5-d492-4933-8728-053553b652d8",
 CellID->107298779],
Cell[CellGroupData[{
Cell[653533, 12740, 320, 8, 25, "ExerciseInput",ExpressionUUID->"1a948ae5-671f-4f9e-8e46-b311b3824b93",
 CellID->659629305],
Cell[653856, 12750, 159, 2, 28, "ExerciseOutput",ExpressionUUID->"119489e3-65d5-43d9-ad38-35a9fdda5cd9",
 CellID->407042305]
}, Open  ]]
}, Closed]],
Cell[654042, 12756, 545, 15, 34, "Exercise",ExpressionUUID->"0f1daee2-dcfc-4d86-bc82-8528b39dba77",
 CellID->58706369],
Cell[CellGroupData[{
Cell[654612, 12775, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"dc2bdbd2-d9f3-4d02-a04d-06efe86f2e9c"],
Cell[654706, 12777, 977, 30, 22, "SolutionAnswer",ExpressionUUID->"880b3130-a8c1-42b1-9b1e-6c3669ae7d90",
 CellID->200200665],
Cell[655686, 12809, 444, 14, 42, "ExerciseInput",ExpressionUUID->"e19221c7-4f47-4b7e-b67b-cab89d011a35",
 CellID->480349563],
Cell[CellGroupData[{
Cell[656155, 12827, 594, 17, 25, "ExerciseInput",ExpressionUUID->"78c0dd06-4c0d-48a2-89ea-60d630babd79",
 CellID->31847898],
Cell[656752, 12846, 252, 6, 28, "ExerciseOutput",ExpressionUUID->"ad8da967-2e46-401a-9f0c-a5a12c5fc629",
 CellID->30989533]
}, Open  ]],
Cell[657019, 12855, 185, 6, 22, "SolutionAnswer",ExpressionUUID->"ec6f14c6-96df-43e4-a867-d292d943662c",
 CellID->75938532],
Cell[CellGroupData[{
Cell[657229, 12865, 538, 17, 25, "ExerciseInput",ExpressionUUID->"bd8a376f-e96d-4cbb-8c35-9ac7f6346700",
 CellID->19810814],
Cell[657770, 12884, 253, 6, 28, "ExerciseOutput",ExpressionUUID->"1a4d602e-ea60-4612-9fa1-c10dd3147665",
 CellID->264557434]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[658086, 12897, 310, 6, 135, "SmallText",ExpressionUUID->"34b5725a-b40b-4204-a72c-19478708b5ce",
 CellGroupingRules->"SectionGrouping",
 CellID->1578181806]
}
]
*)

(* NotebookSignature IRGX7mMNaGIfhje8Yn0sx6BC *)
