(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    609386,      12439]
NotebookOptionsPosition[    423879,       8620]
NotebookOutlinePosition[    586639,      12001]
CellTagsIndexPosition[    586596,      11998]
WindowTitle->25. Transcendental Equations | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Transcendental Equations"
}], "Section",
 CounterAssignments->{{"Section", 24}},
 CellID->503192056,ExpressionUUID->"1d30f8e2-1d92-4650-a4be-6ac3a6f853fe"],

Cell["\<\
In this chapter, you will see Cauchy\[CloseCurlyQuote]s argument principle \
and how methods from complex analysis can help us study transcendental \
equations.\
\>", "Text",
 CellID->86193101,ExpressionUUID->"ce90ce5c-c481-4805-a470-3e5f28bd03b0"],

Cell[CellGroupData[{

Cell["Cauchy\[CloseCurlyQuote]s Argument Principle", "Subsection",
 CellID->125003476,ExpressionUUID->"87e1cab5-bbee-46e8-8027-b17ca6a9e07b"],

Cell["\<\
Cauchy\[CloseCurlyQuote]s argument principle is a relation between the number \
of zeros and the number of poles of a meromorphic function.\
\>", "Text",
 CellID->199936453,ExpressionUUID->"66f0e943-255d-4d8a-a060-573334deb387"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a3e8cd07-14b1-48c9-abb4-74d82a77c984"],
 " has a zero at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "33c4293a-2368-43eb-aad2-3a7d81a9a216"],
 " of order ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath",ExpressionUUID->
  "61414b75-1834-4258-a04d-863259edc8ca"],
 ", then we can write"
}], "Text",
 CellID->728516933,ExpressionUUID->"edc8971a-2381-4f60-84a4-a531c6cca3f6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "h"], 
     RowBox[{
      SubscriptBox["f", "h"], "(", "z", ")"}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->563940578,ExpressionUUID->"b611ad03-c3a6-4646-858b-dd3a808c3794"],

Cell[TextData[{
 "with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["f", "h"], "(", 
     SubscriptBox["z", "0"], ")"}], "!=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"58d5fcff-0932-4fe4-885e-38cf87fb1136"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "h"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "78cb25b7-4e79-4bb4-a8ae-e6213f30f705"],
 " analytic at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["z", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "6cfeb5bf-da8f-4540-84fd-e6792f0325e3"],
 ", as seen in ",
 ButtonBox["Chapter 20",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ". So,"
}], "Text",
 CellID->191574415,ExpressionUUID->"75c078d8-e98e-41ad-a6db-dea285c4e338"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"h", "(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], 
      RowBox[{"h", "-", "1"}]], 
     RowBox[{
      SubscriptBox["f", "h"], "(", "z", ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], "h"], 
     RowBox[{
      SubsuperscriptBox["f", "h", "'"], "(", "z", ")"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->795815110,ExpressionUUID->"884931d8-a843-47e3-9631-289cdb8ab597"],

Cell["and", "Text",
 CellID->590058920,ExpressionUUID->"55158178-76fe-49c9-a988-a032084758e7"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "z", ")"}]}], 
    RowBox[{"f", "(", "z", ")"}]], "=", 
   RowBox[{
    FractionBox["h", 
     RowBox[{"z", "-", 
      SubscriptBox["z", "0"]}]], "+", 
    RowBox[{
     FractionBox[
      RowBox[{
       SubsuperscriptBox["f", "h", "'"], "(", "z", ")"}], 
      RowBox[{
       SubscriptBox["f", "h"], "(", "z", ")"}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->273795272,ExpressionUUID->"6c722e69-ad8e-42e0-bebe-2a70a0079c2a"],

Cell[TextData[{
 "Similarly, if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"75ff7dfc-1845-46ae-abe4-b554515f8b8c"],
 " has a pole of order ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath",ExpressionUUID->
  "6aaa5cf8-23fc-491d-8d4c-bf08eacf610d"],
 " at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d6ab9331-c71a-4378-928d-b2c42c1d1434"],
 ", then"
}], "Text",
 CellID->153673324,ExpressionUUID->"60055357-6dc0-4c99-85fb-b4b7371a7dc4"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", 
         SubscriptBox["p", "0"]}], ")"}], "k"]], 
     RowBox[{
      SubscriptBox["f", "k"], "(", "z", ")"}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->189032853,ExpressionUUID->"229fa12f-3828-4f98-9abd-1f06fa27e9bb"],

Cell[TextData[{
 "with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", 
     SubscriptBox["p", "0"], ")"}], "!=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"bfc69525-c974-4602-afd1-49ff8e571467"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["f", "k"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "c9dd10d4-78e0-4ed6-ab6e-1ceef83aed1d"],
 " analytic at ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", "0"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "8358598f-3cfe-4c72-95dd-910db65541f6"],
 ", as you saw in ",
 ButtonBox["Chapter 21",
  BaseStyle->"Hyperlink",
  ButtonFunction:>(
   NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
    FrontEnd`HistoryData :> {
      EvaluationNotebook[]}]& )],
 ". Just as above, one has"
}], "Text",
 CellID->358163300,ExpressionUUID->"ee2a67c1-61f9-45b7-bc8c-82231a077116"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{"(", "z", ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"k", "(", 
        RowBox[{"z", "-", 
         SubscriptBox["p", "0"]}], ")"}], 
       RowBox[{
        RowBox[{"-", "k"}], "-", "1"}]]}], 
     RowBox[{
      SubscriptBox["f", "k"], "(", "z", ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", 
        SubscriptBox["z", "0"]}], ")"}], 
      RowBox[{"-", "k"}]], 
     RowBox[{
      SubsuperscriptBox["f", "k", "'"], "(", "z", ")"}]}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->150991126,ExpressionUUID->"3800d7d9-153b-4924-a6ee-7b673bdb2f7a"],

Cell["so", "Text",
 CellID->113020044,ExpressionUUID->"53369f83-18f3-4e2d-985a-06daadbd391c"],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"f", "'"}], 
     RowBox[{"(", "z", ")"}]}], 
    RowBox[{"f", "(", "z", ")"}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["k", 
      RowBox[{"z", "-", 
       SubscriptBox["p", "0"]}]]}], "+", 
    RowBox[{
     FractionBox[
      RowBox[{
       SubsuperscriptBox["f", "k", "'"], "(", "z", ")"}], 
      RowBox[{
       SubscriptBox["f", "k"], "(", "z", ")"}]], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->45788077,ExpressionUUID->"3355c477-f781-416c-bfd2-0ba0bea771ec"],

Cell[TextData[{
 "So the function ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"f", "'"}], "f"], TraditionalForm]], "InlineMath",ExpressionUUID->
  "117ab54f-04b6-4ffa-b270-1eac6fd2f455"],
 " has simple poles at the zeros and poles of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "37e6d66f-f714-475a-bb6e-faf7c4f42275"],
 " and has residue ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c85ad726-eccd-47af-9a1f-0e3a88994b8d"],
 " at each zero of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "99969542-d821-44b9-a7aa-f92eb56dcd8b"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "k"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "1d5f1c80-b689-46bd-a615-9e4ffb1ab693"],
 " at each pole of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "c07b49d6-d716-4f0a-aeb1-ed831b1ead21"],
 ". This proves Cauchy\[CloseCurlyQuote]s argument principle:"
}], "Text",
 CellID->9189946,ExpressionUUID->"be2d55fc-a51c-43bd-8958-88739af63062"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "a14d102f-d56f-43e3-979c-f7afc7cb223c"],
 " is meromorphic in a region ",
 Cell[BoxData[
  FormBox["\[CapitalOmega]", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e48b676b-c1b4-495b-8d37-773f54fc75de"],
 " containing the closed curve ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "32bd2376-7e8b-4025-ac97-477350674aa1"],
 ","
}], "Text",
 CellID->290643162,ExpressionUUID->"5508da96-0db3-4cff-9aa2-2b26224a228e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", "C"], 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"f", "'"}], 
         RowBox[{"(", "z", ")"}]}], 
        RowBox[{"f", "(", "z", ")"}]], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"number", " ", "of", " ", "zeros"}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"number", " ", "of", " ", "poles"}], ")"}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->248639685,ExpressionUUID->"56e38a47-7d0c-4150-808b-57ef8d5be6bf"],

Cell[TextData[{
 "where the poles and zeros are those inside the closed path ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "1ba8eb7f-3a81-40c3-a6a6-b2a4acdc5d23"],
 " and must be counted with the respective multiplicities. Also, ",
 Cell[BoxData[
  FormBox["C", TraditionalForm]], "InlineMath",ExpressionUUID->
  "b907faba-59f0-4d6b-9413-ebffb2627fd1"],
 " must not pass through the zeros or poles."
}], "Text",
 CellID->379765406,ExpressionUUID->"ebc2b64a-d41d-4f24-8f41-0a365d14e65c"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->5200906,ExpressionUUID->"78213f64-707d-4358-83d3-b0a75b05a8a6"],

Cell[TextData[{
 "Find the number of zeros, counted with their multiplicity, of the \
polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["z", "6"], "-", 
    RowBox[{"3", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"2", 
     SuperscriptBox["z", "3"]}], "-", "z", "+", "4"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e0128778-4a12-4694-b384-a88684198aef"],
 " in the disk ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "b4673b4f-f789-4114-847c-dc680d312b25"],
 "."
}], "SolvedExampleNote",
 CellID->165054837,ExpressionUUID->"14e6d67b-0b2b-4154-a2e0-108c1c461288"],

Cell["Using the argument principle:", "SolvedExampleNote",
 CellID->423914371,ExpressionUUID->"4b7946ac-1e24-41bf-ba32-8158596dc12b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{"z", "^", "6"}], "-", 
    RowBox[{"3", 
     RowBox[{"z", "^", "5"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"z", "^", "3"}]}], "-", "z", "+", "4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", "*", "I"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}], "/", 
     RowBox[{"f", "[", "z", "]"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", "]"}]}]}], "]"}]}]}], "SolvedExampleInput",
 CellID->386631553,ExpressionUUID->"b8849204-e28c-4f4b-8192-724e4ccd8f01"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->7702639,ExpressionUUID->"92ac7f71-eeef-4ec6-9a51-041fc8200e26"]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", 
       RowBox[{"\[ThinSpace]", "C"}]], 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"f", "'"}], 
         RowBox[{"(", "z", ")"}]}], 
        RowBox[{"f", "(", "z", ")"}]], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "2"}], TraditionalForm]],
  
  CellChangeTimes->{{3.911644697859524*^9, 3.911644759148945*^9}},
  ExpressionUUID->"c5bb7cfd-6189-4972-87cb-6f1f4f5140b1"],
 " and there are no poles in the unit circle, the number of zeros is two. \
Find the actual values of the zeros with:"
}], "SolvedExampleNote",
 CellID->284884536,ExpressionUUID->"5242ca5c-d6f3-4c6d-bc73-0eaef4745bca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveValues", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "z", "]"}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}], ",", "z"}], 
  "]"}]], "SolvedExampleInput",
 CellID->244792923,ExpressionUUID->"cb055d8e-43dd-4249-bbe6-84f241c2078b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.373\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.372611357470343074194119026287808083`15.685356525192338, Editable -> 
         False], "-", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.906\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.90585900898436000350244512446806766093`16.071161044660574, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"4", "-", "#1", "+", 
               RowBox[{"2", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"3", " ", 
                 SuperscriptBox["#1", "5"]}], "+", 
               SuperscriptBox["#1", "6"]}], "&"}], ",", "5"}], "]"}], 
       Short[#, 7]& ], 
      Complex[0.3726113574703431, -0.90585900898436]},
     "NumericalApproximation"],
    Root[4 - # + 2 #^3 - 3 #^5 + #^6& , 5, 0]], ",", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.373\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.372611357470343074194119026287808083`15.685356525192338, Editable -> 
         False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.906\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.90585900898436000350244512446806766093`16.071161044660574, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{
           RowBox[{
             RowBox[{"4", "-", "#1", "+", 
               RowBox[{"2", " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
               RowBox[{"3", " ", 
                 SuperscriptBox["#1", "5"]}], "+", 
               SuperscriptBox["#1", "6"]}], "&"}], ",", "6"}], "]"}], 
       Short[#, 7]& ], 
      Complex[0.3726113574703431, 0.90585900898436]},
     "NumericalApproximation"],
    Root[4 - # + 2 #^3 - 3 #^5 + #^6& , 6, 0]]}], 
  "}"}]], "SolvedExampleOutput",
 CellID->2122309117,ExpressionUUID->"423e3c10-8a00-4310-8470-22830120495c"]
}, Open  ]],

Cell["Their numerical values are:", "SolvedExampleNote",
 CellID->236961927,ExpressionUUID->"2fd188f2-6996-4495-8376-e50be2569d15"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "SolvedExampleInput",
 CellID->179476623,ExpressionUUID->"b3bd035a-9760-420e-841b-291799b6248b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.3726113574703431`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.90585900898436`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.3726113574703431`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.90585900898436`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "SolvedExampleOutput",
 CellID->266418266,ExpressionUUID->"f0ab32e3-d33c-4494-8f8c-c6a7a7e4884f"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"5f84d135-25ac-4c4c-be1c-42c18cb7e7d3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Algebraic and Transcendental Equations", "Subsection",
 CellID->566016424,ExpressionUUID->"c035656f-eeae-4cc9-891e-aba138aed06f"],

Cell[TextData[{
 "Equations can be algebraic or transcendental. An equation is algebraic if \
it has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", "(", "z", ")"}], "=", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"08169d4f-7c8f-4f37-8b01-e122330d3e37"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f68f1b53-09d7-4291-901c-da4126805e91"],
 " is a polynomial. It is transcendental if it is not of this form, \
containing functions that obey no algebraic equations."
}], "Text",
 CellID->320573134,ExpressionUUID->"8efad069-6ed8-4262-973e-4f89adba793a"],

Cell["An example of a transcendental equation is:", "Text",
 CellID->511989455,ExpressionUUID->"3f23d7fb-c434-40f6-b05d-279878f55fd6"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "-", 
    FractionBox[
     RowBox[{"sin", " ", "z"}], "2"]}], "=", "1."}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->119320873,ExpressionUUID->"67c816ef-7f60-4017-80c1-cb3e4e8629ea"],

Cell[TextData[{
 "In Wolfram Language, you can use ",
 ButtonBox["Solve",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["NSolve",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["FindInstance",
  BaseStyle->"Link"],
 " and other commands to investigate such equations:"
}], "Text",
 CellID->156022145,ExpressionUUID->"d202fc99-aaeb-4485-8d4c-5c4e7d31f392"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", "-", 
      FractionBox[
       RowBox[{"Sin", "[", "z", "]"}], "2"]}], "==", "1"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "<", "4"}]}], ",", "z"}], "]"}]], "Input",\

 CellID->277309425,ExpressionUUID->"8563859f-de00-4d2f-b963-663aa516542d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-0.559\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -0.55853040502438822123565387300914153457`15.\
450684165851085, Editable -> False], "-", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"2.46\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           2.45772252560980275504221026494633406401`16.09417019574004, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "-", 
                 RowBox[{"Sin", "[", "#1", "]"}], "+", 
                 RowBox[{"2", " ", "#1"}]}], "&"}], ",", 
             RowBox[{
               RowBox[{"-", "0.55853040502438820140531791406110217967`18."}], 
               "-", 
               
               RowBox[{
                "2.45772252560980256064770502956190474498`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[-0.5585304050243882, -2.4577225256098028`]},
     "NumericalApproximation"],
    Root[{-2 - Sin[#] + 2 #& , 
      Complex[-0.55853040502438820140531791406110217967`18., \
-2.45772252560980256064770502956190474498`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-0.559\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -0.55853040502438822123565387300914153457`15.\
450684165851085, Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"2.46\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           2.45772252560980275504221026494633406401`16.09417019574004, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "-", 
                 RowBox[{"Sin", "[", "#1", "]"}], "+", 
                 RowBox[{"2", " ", "#1"}]}], "&"}], ",", 
             RowBox[{
               RowBox[{"-", "0.55853040502438820140531791406110217967`18."}], 
               "+", 
               
               RowBox[{
                "2.45772252560980256064770502956190474498`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[-0.5585304050243882, 2.4577225256098028`]},
     "NumericalApproximation"],
    Root[{-2 - Sin[#] + 2 #& , 
      Complex[-0.55853040502438820140531791406110217967`18., 
       2.45772252560980256064770502956190474498`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      InterpretationBox[
       StyleBox[
        TemplateBox[{"\"1.50\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        ShowStringCharacters -> False], 
       1.49870113351784839395008930296171456575`15.954589770191003, Editable -> 
       False], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "-", 
                 RowBox[{"Sin", "[", "#1", "]"}], "+", 
                 RowBox[{"2", " ", "#1"}]}], "&"}], ",", 
             "1.4987011331160740826`7.40051499783199"}], "}"}], "]"}], 
       Short[#, 7]& ], 1.4987011335178484`},
     "NumericalApproximation"],
    Root[{-2 - Sin[#] + 2 #& , 
      1.4987011331160740826`7.40051499783199}]]}]}]], "Output",
 CellID->1154158109,ExpressionUUID->"ffb63eec-8e4d-409d-984a-d0dd06b0581d"]
}, Open  ]],

Cell["\<\
Transcendental equations are often solved numerically. You can view the \
approximate value of the solutions:\
\>", "Text",
 CellID->267629637,ExpressionUUID->"a8cb2561-8feb-4379-a64e-6ffc9e8fc2ce"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellID->27278787,ExpressionUUID->"f70c18d2-a3f7-47b1-b2c1-9626332f201f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.5585304050243882`"}], "-", 
    RowBox[{"2.4577225256098028`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.5585304050243882`"}], "+", 
    RowBox[{"2.4577225256098028`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", "1.4987011335178484`"}]}]], "Output",
 CellID->632694753,ExpressionUUID->"f9737c33-7786-48b7-98d1-c7e2d509f111"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Separating the Solutions of a Transcendental Equation", "Subsection",
 CellID->132636652,ExpressionUUID->"0613440d-a371-4295-a76a-c886b82dbc3e"],

Cell["Consider, for example, the transcendental equation", "Text",
 CellID->76015022,ExpressionUUID->"ea08528b-b5ff-4afe-af74-982587dede66"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", "(", "z", ")"}], "=", 
   RowBox[{
    RowBox[{"z", "-", 
     FractionBox[
      RowBox[{"sin", " ", "z"}], "2"], "-", "1"}], "=", "0"}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->287644465,ExpressionUUID->"c8929eab-8f1e-48e7-92e5-b619c13ecda2"],

Cell[TextData[{
 "in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "4"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "d9a47fc7-1129-45da-976f-5eb41e10812d"],
 ". Applying the argument principle can help with separating and computing \
the solutions of the equation. "
}], "Text",
 CellID->738311568,ExpressionUUID->"a6f85727-1473-49d6-8805-a3e52a9eaa30"],

Cell[TextData[{
 "In the example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5906a52d-b95b-4ac6-a97a-c244f71ac2e9"],
 " is an entire function:"
}], "Text",
 CellID->179366770,ExpressionUUID->"34a65103-14f0-4b82-b5d5-12745342a539"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{"z", "-", 
    RowBox[{
     RowBox[{"Sin", "[", "z", "]"}], "/", "2"}], "-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FunctionAnalytic", "[", 
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], ",", "z", ",", "Complexes"}], 
  "]"}]}], "Input",
 CellID->20654736,ExpressionUUID->"91be739e-0c0b-4fbf-8003-9d78629fe4a1"],

Cell[BoxData["True"], "Output",
 CellID->640947769,ExpressionUUID->"ba1e10ff-b8e2-46e8-9d55-13cf52169a79"]
}, Open  ]],

Cell["\<\
so the number of poles in the region is zero. Using Eq. (2), one can \
therefore determine the number of solutions of Eq. (3) in the disk:\
\>", "Text",
 CellID->236514224,ExpressionUUID->"1df18d3b-21c8-4048-9bde-06b2278f2169"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}], "/", 
     RowBox[{"f", "[", "z", "]"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellID->298652125,ExpressionUUID->"a34b8a55-c10b-44ee-babc-8848388377f0"],

Cell[BoxData["3"], "Output",
 CellID->300856555,ExpressionUUID->"7663486b-c247-40f6-bf06-5e3d53179670"]
}, Open  ]],

Cell[TextData[{
 "One can then consider smaller portions of the region such as the sector ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "4"]}], "<", 
    RowBox[{"arg", " ", "z"}], "<", 
    FractionBox["\[Pi]", "4"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"f2f2a3a1-420d-4095-a634-ada6320c067f"],
 " and find:"
}], "Text",
 CellID->295440017,ExpressionUUID->"b8c86c29-54ac-4261-b418-61a5e509b01e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}], "/", 
     RowBox[{"f", "[", "z", "]"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "4", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "4"}], ",", 
         RowBox[{"\[Pi]", "/", "4"}]}], "}"}]}], "]"}]}]}], "]"}]}]], "Input",\

 CellID->80106493,ExpressionUUID->"67f17114-1a95-41a0-bca5-298960cf6300"],

Cell[BoxData["1"], "Output",
 CellID->183572054,ExpressionUUID->"866fbaec-263b-4058-884c-410fcdfa2797"]
}, Open  ]],

Cell[TextData[{
 "So one solution of Eq. (3) must be located in the circular sector with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "4"]}], "<", 
    RowBox[{"arg", " ", "z"}], "<", 
    FractionBox["\[Pi]", "4"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7c8e1640-0c3d-4b1d-8078-7205fbf42f98"],
 ". Repeating the process, one can, for example, divide the disk as in Fig. 1:"
}], "Text",
 CellID->893846478,ExpressionUUID->"a9fc2d56-00f8-4629-b20b-a9b8e3f0137d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", "g"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "z_", "]"}], ":=", 
      RowBox[{"z", "-", 
       RowBox[{
        RowBox[{"Sin", "[", "z", "]"}], "/", "2"}], "-", "1"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"g", "[", "z_", "]"}], ":=", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}], "/", 
       RowBox[{"f", "[", "z", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"ComplexListPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Reduce", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"f", "[", "z", "]"}], "==", "0"}], "&&", 
              RowBox[{"0", "<", 
               RowBox[{"Abs", "[", "z", "]"}], "<", "4"}]}], ",", "z"}], 
            "]"}], "//", "N"}], ")"}], "/.", 
         RowBox[{"Or", "->", "List"}]}], "/.", 
        RowBox[{
         RowBox[{"z", "==", "a_"}], "->", "a"}]}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4.5"}], ",", "4.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4.5"}], ",", "4.5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "}"}]}], ",", 
       RowBox[{"Epilog", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", "Dashed", ",", 
            RowBox[{"Circle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", "Dashed", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"2", 
              SqrtBox["2"], 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", 
                  RowBox[{"-", "1"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", "Dashed", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"2", 
              SqrtBox["2"], 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"1", ",", 
                  RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]}], "}"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<1\>\"", ",", "14"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"3", ",", "1"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<1\>\"", ",", "14"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<1\>\"", ",", "14"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", 
              RowBox[{"-", "3"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<0\>\"", ",", "14"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "3"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]}], ",", 
       
       RowBox[{"ImageSize", "->", "250"}]}], "]"}]}]}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Fig. 1. The number of solutions of \>\"", "<>", 
       RowBox[{"ToString", "[", 
        RowBox[{
         RowBox[{"HoldForm", "[", 
          RowBox[{
           RowBox[{"z", "-", 
            FractionBox[
             RowBox[{"Sin", "[", "z", "]"}], "2"], "-", "1"}], "==", "0"}], 
          "]"}], ",", "TraditionalForm"}], "]"}], 
       "<>", "\"\< in each sector.\>\""}], "]"}]}], "]"}], "&"}]}]], "Input",
 CellID->724025106,ExpressionUUID->"b959f152-1bbc-4cbc-a0f8-2ad6aec645c1"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}}, {}, {{}, 
        InterpretationBox[{
          TagBox[
           TagBox[
            {RGBColor[1, 0, 0], PointSize[Medium], AbsoluteThickness[2], 
             PointBox[{{-0.5585304050243882, -2.4577225256098028`}, \
{-0.5585304050243882, 2.4577225256098028`}, {1.4987011335178484`, 0.}}]},
            Annotation[#, "Charting`Private`Tag#1"]& ],
           {
           "WolframDynamicHighlight", <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>}], 
          StyleBox[
           DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
             Slot["HighlightElements"], 
             Slot["LayoutOptions"], 
             Slot["Meta"], 
             Charting`HighlightActionFunction["DynamicHighlight", {{
                Annotation[{
                  Directive[
                   AbsoluteThickness[2], 
                   PointSize[Medium], 
                   RGBColor[1, 0, 0]], 
                  
                  Point[{{-0.5585304050243882, -2.4577225256098028`}, \
{-0.5585304050243882, 2.4577225256098028`}, {1.4987011335178484`, 0.}}]}, 
                 "Charting`Private`Tag#1"]}}, <|
              "HighlightElements" -> <|
                "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
               "LayoutOptions" -> <|
                "PanelPlotLayout" -> <||>, 
                 "PlotRange" -> {{-4.5, 4.5}, {-4.5, 4.5}}, 
                 "Frame" -> {{False, False}, {False, False}}, 
                 "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
                 "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                 Automatic, "DefaultStyle" -> {
                   Directive[
                    AbsoluteThickness[2], 
                    PointSize[Medium], 
                    RGBColor[1, 0, 0]]}, 
                 "HighlightLabelingFunctions" -> <|
                  "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                   "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                 False|>, 
               "Meta" -> <|
                "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                 "Function" -> ComplexListPlot, "GroupHighlight" -> 
                 False|>|>]]& )[<|
             "HighlightElements" -> <|
               "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
              "LayoutOptions" -> <|
               "PanelPlotLayout" -> <||>, 
                "PlotRange" -> {{-4.5, 4.5}, {-4.5, 4.5}}, 
                "Frame" -> {{False, False}, {False, False}}, 
                "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
                "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
                Automatic, "DefaultStyle" -> {
                  Directive[
                   AbsoluteThickness[2], 
                   PointSize[Medium], 
                   RGBColor[1, 0, 0]]}, 
                "HighlightLabelingFunctions" -> <|
                 "CoordinatesToolOptions" -> (Identity[
                    Part[#, 1]] + I Identity[
                    Part[#, 2]]& ), 
                  "ScalingFunctions" -> {{Identity, Identity}, {
                    Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
                False|>, 
              "Meta" -> <|
               "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
                "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>],
            
            
            ImageSizeCache->{{
             4.503599627370496*^15, -4.503599627370496*^15}, {
             4.503599627370496*^15, -4.503599627370496*^15}}],
           Selectable->False]},
         Annotation[{{
            Annotation[{
              Directive[
               AbsoluteThickness[2], 
               PointSize[Medium], 
               RGBColor[1, 0, 0]], 
              
              Point[{{-0.5585304050243882, -2.4577225256098028`}, \
{-0.5585304050243882, 2.4577225256098028`}, {1.4987011335178484`, 0.}}]}, 
             "Charting`Private`Tag#1"]}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"IndicatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, 
             "PlotRange" -> {{-4.5, 4.5}, {-4.5, 4.5}}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {250, 250}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
             Automatic, "DefaultStyle" -> {
               Directive[
                AbsoluteThickness[2], 
                PointSize[Medium], 
                RGBColor[1, 0, 0]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> (Identity[
                  Part[#, 1]] + I Identity[
                   Part[#, 2]]& ), 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ComplexListPlot, "GroupHighlight" -> False|>|>, 
          "DynamicHighlight"]], {{}, {}}}, {}, {{}, {{{}, {}, {}, {}}, {}}}},
      AspectRatio->Automatic,
      Axes->True,
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Epilog->{{
         Thickness[0.002], 
         Dashing[{Small, Small}], 
         CircleBox[{0, 0}, 4]}, {
         Thickness[0.002], 
         Dashing[{Small, Small}], 
         LineBox[
          
          NCache[{{(-2) 2^Rational[1, 2], (-2) 2^Rational[1, 2]}, {
            2 2^Rational[1, 2], 2 
             2^Rational[
               1, 2]}}, {{-2.8284271247461903`, -2.8284271247461903`}, {
           2.8284271247461903`, 2.8284271247461903`}}]]}, {
         Thickness[0.002], 
         Dashing[{Small, Small}], 
         LineBox[
          
          NCache[{{(-2) 2^Rational[1, 2], 2 2^Rational[1, 2]}, {
            2 2^Rational[1, 2], (-2) 
             2^Rational[1, 2]}}, {{-2.8284271247461903`, 
           2.8284271247461903`}, {
           2.8284271247461903`, -2.8284271247461903`}}]]}, 
        InsetBox[
         FormBox[
          StyleBox["\"1\"", 14, StripOnInput -> False], TraditionalForm], {3, 
         1}], 
        InsetBox[
         FormBox[
          StyleBox["\"1\"", 14, StripOnInput -> False], TraditionalForm], {1, 
         3}], 
        InsetBox[
         FormBox[
          StyleBox["\"1\"", 14, StripOnInput -> False], TraditionalForm], {
         1, -3}], 
        InsetBox[
         FormBox[
          StyleBox["\"0\"", 14, StripOnInput -> False], TraditionalForm], {-3,
          1}]},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->All,
      ImageSize->250,
      Method->{
       "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
        "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
          Directive[
           RGBColor[0.24, 0.6, 0.8], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.95, 0.627, 0.1425], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.455, 0.7, 0.21], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.922526, 0.385626, 0.209179], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.578, 0.51, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.772079, 0.431554, 0.102387], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.4, 0.64, 1.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[1., 0.75, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.8, 0.4, 0.76], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.637, 0.65, 0.], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.915, 0.3325, 0.2125], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[
           0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
           AbsoluteThickness[2]], 
          Directive[
           RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
           AbsoluteThickness[2]]}, "DomainPadding" -> Scaled[0.02], 
        "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
        Scaled[0.05], "MessagesHead" -> ComplexListPlot, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& ), "CopiedValueFunction" -> (Identity[
             Part[#, 1]] + I Identity[
              Part[#, 2]]& )}},
      PlotRange->{{-4.5, 4.5}, {-4.5, 4.5}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {"\<\"Fig. 1. The number of solutions of \
\\!\\(\\*FormBox[TagBox[RowBox[{RowBox[{\\\"z\\\", \\\"-\\\", \
FractionBox[RowBox[{\\\"sin\\\", \\\"(\\\", \\\"z\\\", \\\")\\\"}], \
\\\"2\\\"], \\\"-\\\", \\\"1\\\"}], \\\"\[LongEqual]\\\", \\\"0\\\"}], \
HoldForm], TraditionalForm]\\) in each sector.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->835424056,ExpressionUUID->"fc0a5f6c-b9d0-4ef7-a96a-fe9f838fb61c"]
}, {2}]],

Cell["\<\
By refining the subdivisions further and further, it is possible to obtain a \
finer grid, useful as a starting point for further numerical solving \
techniques.\
\>", "Text",
 CellID->855034102,ExpressionUUID->"669e8294-8f62-49a4-a489-4a4255976edd"],

Cell[TextData[{
 "For polynomial equations, the command ",
 ButtonBox["RootIntervals",
  BaseStyle->"Link"],
 " can operate such a separation, by providing small rectangles, each \
containing one solution of a polynomial equation."
}], "Text",
 CellID->30163152,ExpressionUUID->"79632c9a-ba34-4ff9-bb3c-f15f7810e348"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples of Transcendental Equations", "Subsection",
 CellID->111656858,ExpressionUUID->"7e940ca0-d8d6-4ab7-b3cc-7c77e4896d2e"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->195733471,ExpressionUUID->"013096b7-4747-42af-825c-cd02eace6375"],

Cell[TextData[{
 "The equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalGamma]", "(", "z", ")"}], "-", 
      RowBox[{"log", " ", "z"}], "-", 
      RowBox[{"\[ImaginaryI]", "/", "2"}]}], "=", "0"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"39d902ba-0631-40c6-a2cb-f976dd6a0160"],
 " in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"z", "-", "2"}], "|", 
    RowBox[{"<", 
     RowBox[{"3", "/", "2"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b4910536-ff00-4891-bbdb-ffa4eea73939"],
 " is a transcendental equation. A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ead9d002-27b8-43e0-a9c1-b7cba4ed3c41"],
 " and the region is:"
}], "SolvedExampleNote",
 CellID->80131101,ExpressionUUID->"f402c802-b225-4ce2-9e3f-910f4572a730"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "z", "]"}], "-", 
    RowBox[{"Log", "[", "z", "]"}], "-", 
    RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "4"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["920", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], Dashed, 
       Circle[{2, 0}, 3/2]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->124370827,ExpressionUUID->"1e9adcad-086c-4170-8056-3da6ef064f55"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+on1UcgPHLHLghikvKioh1zRXDmBbjJq4IwzDBYFKGbVXjggtGi2FF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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJyU3GdwJFeC4PcN6Ys+KvRJnxRSSBGSTgrpJrS621vt7u3oZmdnbjmznKF3
MySH3pNNb9qS7X03Gg00vPcoAOW99957b9NUVmZW2qoeKV8WqgGQzdnZiD8Z
3UB1o/HDey9fVlXm//Dy+7997b/4i7/4i2P/lfC/37702U8/+uilLx77r4Xf
PPHesTdff+/VV3753sevvv7qR3/18n8pfPCV/f/Ar/PJ3qCcUOJo8V72cLH9
MoOi+6WFIgelhMIHJUMHJYL8oPigACg2LOrfLyIW9u0XGhYcFhDzD/MN8w7z
PMjPu79X4OF5BvlB+3+Pl/d6eJ+b9zl5n53zWbgDq8RDrHI/ZhU90mGr9CGo
1CGoZPCoVeCQlR90YOUDfd/KywfFAsP8Yr5h3kGHoXy8e9C/xOUZ5hXygwb4
4Et4+ICLDzj4oO3AKv8wqAOu2JGOWB2FSh+CSh2CSg6hEgHQgZX/kJUPdMTK
C5QeQAWPQvm/B+XlPQ96AHWIyyX2EKsgyBvYzxfg/X6QMHrBF/XwIRcfdvCH
rfI/YpX7nlUUdNgqc9QqfcgqtQ81tAocsvKDDqx8h6y8QGnQgZXwIx7mF/MN
84o9gHI/SIRyDRpauQKgfaggaN9KzBfk/UIBPhDgg34+JK4GEQ8fdfOHoY5w
HbaK/bhV5JBV+JBV6CFWycAhK/8hKx9o38oLoA6shJ+pWNBzYOU/auV9YCXm
9hxYubxDqB9YuYZQB1Yh3ifmD/GBIB8M8qEgHxYWUnHwx30Pscr/YFAJVrmj
UPtckUMdgkofgkodgjqw8h+y8h2y8h6y8hxA7Vu5+YCYX8w3zCvmcQ+hxFwe
EWrI5RzkBz2wcj2wCoG8D6DCfDDMh0J8OMRHQnwsBBZY4R//UKv8w6xyP7DK
HrXKDKEGDaAGHbHyD618oH0r7z4UsPKADqzcQGnQD60OoNy8e5jLs5/TO+yQ
lTMAGlgBLhHKE+a9Yd4X5v1hPhDhgxE+HOEjET4a4eORXlI8uP+YVf4HUPtc
D7UKP8wqeMgqMLTyD/MdsvIOrTygfSs3KOQeWrnE45GL94v5xLxinv04txvk
GuThnKB9K4dv2NDKKUK5QsDKHRatIrwvwvsjfCDKh6J8OMpHo71YrJeI9VLi
0b/wI1AHXIetjkINOmyVCR1YpR9YBYZWftAA6oFV3Du08gyt3KB9Kxco6Dpq
5RT3PE7eC+I8QgKUmEvM6d7P4RHzCh1YgUQrp2jlCotWEdEqyvujfDDGh2K9
SLwXjffi8V4y0UsnetkEsCr8a6xyP7DKhh9mFRxaBYT41BAqOYRKiEqDgNUQ
KuoeWrlA+1ZOUEDM79y3EpT2oZycW8zlFKHEHEJukN0j5uXsPh7kFwvwjiDv
CPFO0coV4d2CVZT3xXh/jA/G+VCiF0n0oslePNlLpnrpVC+b3rcq/IhVPvYQ
q9xhqMNWof0GUKDA0GoIlRxCJYZQcQ+AiolKgyIu0L6VE7Rv5QD5HbzPwQl5
xTwOzi3mcgArp5jDCazsQm6QzcPZvGI+zubnbaKVXbRyhHnnwCrKe2K8N877
43wg0Qsle5FUL5bqJdK9VKaXyfRy2QOrwo9Y5X8ABToENehftEoNrZIi1CAB
at/KDQJWrqGVEwSshD2z2ADKL5xuiHntnEfMbedcdmDlFHM4gJXdCaxsQm6Q
1cNZvZzVJyZwBXhbkLeHeHuYd0R4Z5R3xXi3aOVL8IFkL5TqRdK9WKaXyPZS
2V4m18vl+4etCj9ilf8zrLJDqEwQNIAaNIBKDaEOrDxDK/fQyiVaOUHAygGg
BlYBO0iAGlh5bSCPjXPb9q2cYg47sLI7OJsTZHWJuTmLR8zLWXycxc9bA7w1
yFtDvC3M2yO8I8o7Bas470nwvmTPn+oF071wphfN9hK5XirfyxT6ueL3rQpx
0A+t8rEjUIP+LCv/0GoIlRxC7Vu5QTEXCFg5h1aOoZWdD4pQARvnt3E+sQHU
wMol5rRxDjG7nbMJOTirkJOzuEBmN2f2cGYvZ/ZxZj9nDvCWIG8J8dYwb4vy
jhjvjPOuBO9J8r4U78/wwWwvnOtF8714oZcq9jKlfq78cKvCD62ioO9Z5Q5B
DRpAgQIHVmkRapAABfIMrUSouGto5RStHCBgZQdQIZtw3gqggJWV84l5rZzH
yrnFXFbOaeUcYnYbZ7NxViE7Z3GAzE7O7OJMbs7k4UxezuTjTH7OFOBMQc4c
4qwRzhbl7HHOmeBcSc6T5nwZzp/lgzk+nOejhV682EuW+plKP1f9UavC0UE1
sMr/wCp31Cp7yCozhDqw8h61coMEqH0rESoqQkXsACosQgErKxcQ81vAcyNe
MY+Fc1s4l4VzijksnN3C2aycVcxi48x2ziTk4IxOzujiDG7O4OEMXs7g4wwB
zihYhTlLhLXGWHucdSRZV4r1ZFhvlvPnuGCBCxe5WIlPlPlUpZep9nK1fvHH
rQoPs8r/wCoXPoDKHoI6sPKBBlYpEQokQiVcQyunmEO0sotWNlDIKsQBKwsI
WJk5r5nziLnNnMvMOc2cw8zZzZxNzGrhLBbObOVMNs4oZOcMDk7v5PQuTu/h
dF5O5+P0Ac4QZE1h1hxlLTHWlmAcKcaZZtxZ1ptj/QU2WGTDJS5W4RJVPlXj
M/VevtErJkA/ZlX4oVUEdBgqFwI9sMo+sPKDDqxEqNQQ6oiVEyRAASs7KCJC
ha2ilYULClBmzi/mM3FeE+cxcW4T5zKCnEbOYeLsJs5m4qwmzmLmzGbOZOGM
Vs5g5fQ2Tm/ndA5O6+K0bk7j4bQ+Thdg9SHWEGZMUcYcZ6xJxp5mnBnGnWO8
BcZfZIJlJlxhY1U2UedSDS7b5PMtfmBV/HGrfbGjVvk/YRUAHViJUGkvaGCV
emDlEhOh4iJUTISK2oBVxMqHLQAqZOaCZi5g4vxiPiPnNXIeI+c2cC4D5zRw
DgNnN3A2A2c1chYjZzZyJhNnNHMGM6e3cDorp7VxGjundnJqF6f2cBofqw0w
uhCjj9DGGG1K0JYUbcvQ9iztytOeIu0r04EKE64x0TqTaLCpFpuFuDx8YLUv
9iNWhR9Y5Y9a5YJHrfzDDluJUCkRKukCCVAJESouQsVEqKgVQEUsghWAAlYm
0coI8hk4r4Hz6Dm3nnPpOaeec+g5u56z6TmLnjMbWJOBNRpZg5HVm1itmdVY
WLWVU9k4pYNTODmlm1V5GXWA0YRoXYTWxyhjgjKlKEuWsuUoR4FylyhvhfLX
qFCdjjbpeItJQWwWZvMo9z2r4o9bFX5glT9qlTtkld2HAlYZESrtAQlQIBEq
KUIlHKC4HRSz8TGraGURrQQoEyho5AIClIHz6zmfnvPqOY+Oc+s4l45zaDm7
lrNpWauWtehYk4416liDntUbWK2R1ZhYtZlVWliFlZXbWbmDlbsZhZdR+mlV
iNJEKG28q092DWnSlCUtBdJeIp2Vrqfa9dW7wSYVaVExmE4iTAZl8m1WWNu/
ZzXooVaFH1jlQ0esckOoQf+iVVKESohQcREKWFlAETMfNnFhIxcyckEDF9CL
UDqQV8u5tZxLwzk1nEPD2TWsTcNaNKxZw5o0rEHL6rWsVsdq9KzKwCqNrNzE
yiys1MpKHazUxci8tNxPKUJdZYRUx0lNitBlCEOOMBUJa5mwVwlXnfQ0SX+r
G4K7UYRKtOk0Ruc6zI9ZgR5mVYiADlsNemCVe2DlAwlQIBEq7QYJUCDn0Mou
WtmGViJU1MxHRChgZeCCei6g4/xCWs6n4Twazq3mXGrOqWYdKtamYq0q1qJi
TSrWqGL1alanZjUaVqVllTpWrmelRnbPxO5Y2B07s+uk9zyU1N+VhUh5lFDE
CVUK12RxbaFjKHVMFdxax+1N3NUivDARQMlwuxvDuskOlSXoP21V/BGrwves
gqAHVrl/0copWjnEBCsbKG7l4xZgFTPzURMfMXJCYQMX0nNBHRfQcgEN59dw
PjXnUXFuFedSsk4la1ewNgVrVbBmBWtSsAYFq1OyWiWrVrFKNSvXsFItu6tn
JUZ2y8xuW+ltByVxd3d85G6I2Ivi0kRHnsYUOUxVxDRlTF/DjA3M0urY4Y4L
xb1tItghIjiZILppkiole6U/abUv9gOrwg+s8kMokAiV9QoBKJAIlXaBBlYp
EWrfyjq0MvMxEx81CnERAxfWcyEdF9JyQQ0XUHN+FedTcR4l51awLgXrlLN2
OWuTsRYZa5axRhmrl7FaOauWs0oFK1eyUhW7q2YlWnZTz24YmQ0LvWHvbrrI
LR+xFexsRzFJor2bae/lUVkJVVRRVR3VtlAjhFqRthNtezEs2OlEcTxBEBmS
HFgN+hNWxSjowCo87KhV/mFW2aFVRoRKO0EC1L6VDSRYJSzAKm7mYiYuZuSi
Bi6i5yI6LqzlQhouqOYCKs6v5HwKziPn3DLWJWMdUta+x1r3WMsea9pjDXus
bo/V7LEqKaOQMjIZs6tgJEpmU82sa5lVPbNqolZt5JqLWPN21oPYehTdSCKb
WWSrAEvK8E4NljcgTQsywJAVgZxt2IshwQ4aJdpJEst0O4etQH/Sqnh0XA2s
Cket8kOrnFe08ohW7n2rzNAqLVql7HxKtEpauaSFS5hBcRMXN3IxAxfVc1Ed
F9FwYTUXUnEBJeeXcz4Z55Wy7j3Wtcc6dln7DmvdYc0S1iRhDRJGJ2HUEka5
w8h3mb09ZkfKbMmYdQWzomIWtfSiobtkIZYc+JIXWwqiS1F4OQUt51orpeZ6
pSmp1WWNurpV08N1C1J3tBterBnEoSgBJ0kk023/0GrQj1kVI6DvWRWOWuV9
AyseJFpl3aCBVWZolbaDUjYOJFolBSsTSLCK69mYjo1q2aiGjajZsJINKtiA
nPVLWe8e695hXRLWIWHt26x1izVvscZNRr/JaDcZ9Saj2GJk28yuhNneYTZ2
mRUpsyhn5lT0nK47Z8Zn7disB50NwrOx1myqOZOvz5dqK5XKVq201ygpWyUd
XDKjZXu74ulUA3g9QjQTXShDwd+3OsRViv+oFeioFejAigcNrXJDq+zQKuMA
pe0caGiVsnApM5c0cUkjmzCwCT0b17ExLRtTs1EVE1EyITkTlDGBPca3y3gk
jGuLdWyy9g3Wus6a1xnjGqNfYzRrjGqNka8ze+uMZIPZ3GTWtumlHXp2j56S
01MactLYmbS1J9zwvWBrPNYYS9fG8+WZUmGpkluvZSWNjKyV0cBZI5qzYgVX
p+gnymGyGu820lTrT1uVYqAfswIdtQL5eaGBVX5olROhQE5QxsGB7CDBCmTl
0sCKTZnYlJFNGtiknk3omLiGiauZmIqJKpiIjAlJ6eAu7ZfQ3m3Gvck41xn7
GmNdYcwrjGGZ0S0zmmVGuczIlpndFXp7hV5fo1fW6flNekpCj+/R40pyTIfd
tSB3XK2RYP1mvHojUxrNZyeKqblKfLkW22xEd1sxJRzXoUkzlnbgWS+RD5Kl
aLeSouvA6kem4QMrUBT0UCtQUAxY8QOrgo8viFZ5D593A6ucS4jLOsUOWWVs
INGKTZvZtIlNG9mUgUnpmaSOSWqYhJqOK+mYnI7K6MgeHdqhg9u0f5P2rtPu
VdqxQluXGNMCY1hgdPOMep5RztOyeXpngd5aoNeW6KVlenaVntig72zTI1Li
tqZ90wRfdzauBCrnE8Ur6fTNXOxuMTRZ9s/XfCsN3xbklyIBVTtkwKJ2POEl
0iEyF6eKabpSTvbKf47VkAsUAR2xGnAFeJAfNLACXB4u7wYJUKChFeiQVcbK
ZixiApeRSRuYtJ5J6eiUhk6q6ISSjsupmJSK7lIRCRXaogIblG+N8qxQriXK
vkBZ5mjjDK2bZtTTtGKKlk7TO9P05gy9OksvzFPTi9TYMnVznbouIa4q2pcN
rQuO6rfB4ql4+lwqciXru1lw3i3bJmvW+aZ1BbLtIk5122PCAk487CfiETKd
pHJZujiwKidA/yorUFgsJBbkQUOroo8vermC0NAqL0INemAFsgmxWauYhc2a
mYyJyRiYjJ7OaOm0hk6pqJSCSsqoxF43ttONbnfDG93QGhlYIb1LpHuh65jt
Wqe7pklKd49Wj9OKcVo6TkvG6Y171MoENT9JTU1To3PUtSXq0gZxYQ89q22c
spe/CGa/jkVOJd1ns+ZLBd31snqkppptaNZbOils0qI2C+Zy474gEY6R8RSV
ztG5w1YP+nO5Dqz4B1YlP6jo4wSrogdYFUQo0MDKATqwsrPAysbmrGzOwubM
TM7EZI10Vk9ndXRGQ2VUVFrRTUm7yV0yISHjm2R0nQivEMElwr9AeGcJ1zRh
nyQt46Thbldzh1KM0Hu3KckItTFCLd+h5kapiTHqzkT3ykz37BJ5Zhs9oap/
biu8F0x8EnV/mdQfz8hPFyQXy1t3q1vzjZ3NllQOq/SozoaZPbgjRHjjZChN
xQt0+qFW5fh+f9qqLBQWC/GgIF8OgEp+ruTjSqJV0Q2sCiJUfgi1n30QCxpY
WZm8hcmbmLyRzhnonI7KaaisqpuVkxkpmd4hUttEYoOIr+LRZTy8gAdncf80
7pnAneO4bZQwjRC6W6TqRld6jZJcpTauUcvXqbkb3Ylb3ZGR7uWx7qmp7vEV
9HNZ7X1L9nV/8N2I4cOE5Fhm6Xhh9kppZrw6t1Bf3GqtKuBtAyq1Y2ovbgwT
9kTXk6GCBTq2b5V8uNV+sUNFh0WGhXmhSoivBAdcXNnPlUWrErBiiy62IORk
8w6ho1yOfau8kI3NW5mChSmY6YKJLhiogo7Ka7p5FZmTk7k9IruDp7fw1Hon
udKJL3aic1h4GgtOYL5xzD2KOW53rDc7xmu45gqhuETuXOhunO+unO/OX+hO
XuqOXO1evkGeGiU/n8E+2q69Zkq96HW8Epa8mpj+MHP7dP7GteL1e5WbS/U7
2817SnjWiC47sC0/Lo8R+nTXVqA8FTr0r7Y6xFWJDOIrAyvAxVUCXMXPVXxc
2cuWPWxJtCo62YJjYCWOIvthLvHjdrYgZGOKVqZooYsmumikivpuUUMWVWRB
TuT38Jykk93sZFax9BKWnG/HZ9rRSTQ8jgZGUe9t1HWjbb/aNl9u6y9g6nMd
2bf49mli5WR34VR36jQ5+i159Tx55gp5bIR4d7n+gj7xtEfzTHjy5cSFT9Mn
vst9dbP41WTl6+XacVnzohG+40JnQthaApfmCG2pa61R7iYdrPw5Vg/jqgyr
RnhQmK+GuGqQqwa4KrBiK4KVmy272JKTLTpEq8F0E62yQ6s8CHxWeEzRzpRs
TMlKl81U2UiV9d2yliyriJIcL+52CttYfh3LrbSzC2h6Fk1OIvFxJDoKh27B
geuw9wrsuoTYziOm7xDdGVR1sr33Dbb5Fb70OTHzOTn+BXnza+L8SeLz88Sb
Y/BTyvg/uzf+OXL6rfi7X6VfOp97ZqL4+83KO+r6F7bWWR98M4ZOprGVAr5b
JTWNrhmiXCgDrAb9C1ZHuSrDqoJVlK9FxMJcLcTVglzNz1Z9bNXLVtxM2cWU
HIyAIIwZYZblxGV8f1V3gKV+sI4JM1QYeyUnU3YwFRtdsVJVc7dqIKtaoqLC
K7JOeRcrb7VLa2hhCc3PIdkpOD0OJUeh+K1W9HordKUVuNjynms5v23ZTkGm
45DuK1j5BbL3Kbp1rL38ATb9Lj76LnHtfeLMJ/i7p/En1zL/r/fGi5FnP078
+5H0363l/0lZetpSfc1b/zjaOp2GrxXa96qdpQYugUgV2jVhtAtnApVkf58r
AfpTVmKV+FBpWE2wivL1CF8Pc/UQVw+y9QBb87E1D1N1MxXh2xdHS0FYt63M
YG8ANlSilbDXEo6PwuIvHAJKYBCCx1cddM1G1SzdupGs64i6Cq/JOrWddnUT
rawg5QW4OA0V7rVyo83MrWbqWiN+uRG90Ah91/CfbnhONJxfN2xfNkyfNXUf
N1UfNGXvtiRvQeuvQQsvI5O/Q289i517vvP2x51ng387G//vlKn/1Zr9d97C
zyKl36aqL+UbH1RaJ+rwZag9hnQWMHwbJ5Vk19SlndS+Vf+BVeXPsRKritXi
vXqMF2pE+UaEa4S5RohtBNiGj6l7mJqLFr5xYZyULLSwYgv7gYyZAftzKzgT
FE4MhbMeYUsv7CuEDYawvlU8bM3N1F10w0E1rN2miWzq8aaq05BhDQlaX0dq
S3B1tlWZaJZGG4Vb9dy1euZSLXWulvi2Gj1VDR2vBr6qej+vuj6p2j+qWt6v
Gt6uat+oqv5Qlf++Kn2msvtYae+XOfVfxyP/03L3279G9P9b3fuTavhvaolf
1jNPNQuvQuWPkdrpdvNaB5og0GUS26FwNU2Yma6bpYIHVoe5/gSU+ICqWC3R
qwvF+YZQjG9GuWaEbYbYZoBp+piGh244qZqdqlqosokSjmtZAy1syJMmNmHh
knbwdF/GDc6vhU2+sM0QjgjC5K2Lf7Dpolr2LmQhIAMOqTFI2m5tI801qLHY
rM/Ua/dqlZFq6XqleKmcP1vOni6njpcTX5Wjn5fCn5QCH5V8H5Tc75Ycb5Zs
rxUtLxdNLxSMT+VMj2YsP0+4/r0//BNp8SffQo89St38B27377uGX+LOx/DA
i3jsHTz9JZE/R5ZvdWvTVHONhqVMW8t2rBzh4clQJdX//tASTR5ulXhg1QdW
yV492Wske80E34rzrRgHRVkozEJBBvLTLQ/VdILhUTORZR1Z0HQzaiqhYWJ6
LmYBL3Kl3HzGx+f84Ixb2MdWwfzlmkG25WdgLwW7uoiNQAw4om4jchjeaUHr
9dZStTlTro8XayOFyrV8+WKu+F0ufzKX/SqX/jSf+KgQez8feTcffCvvfz3v
fSXnfjHnej7rejLtejTp+XnM//eeyP+jyfzVXOU/nmk99mrn4yeokSe49ad5
9Quc9XXWc4wNnWATl9jsKFuc46obXFPOQ3oetfcwXw+PVFP9ahIEuL5n9WAx
H/x28Nlkb/D4WrJfT/UaqV4z1WuleCjJQwkOjrFwhIFDDOynYQ8FObotC9nQ
E1UVXpDhqT0yIqMDGi5k4aIu8J6ZTBC8BiScVwr7NGHRa0S5VoSFwwwaoNue
LmYnMDPW1iFtZQvdrSMbFXipCM3km+PZxu107Wqqcj5ZPpMsHk/mv0hmP06m
P0gl30nH38hEX8mEX8oEf5cOPJsKPJEMPBoPPBIK/cId/Zkx9dOdwn+crP7j
udaTHyOv/AE/+TI1+hqz8jYnO8Ybv+65vusHr/fj9/qZxX5xu19V9hvGPuTo
o/77WPSBVfWoVeXQUa8U27cqg6naB38k1a+l+/V0v5HuNdM9KN2D0zyS4tAE
i8YYNEyjAQr1dBE7CZuESdRp7LZL62hiueNeo50q1mvjwl4+EeIzEfAGgKL4
FYUZLYxPOMGhcRaL0J1AF3fjuA3FjVBHXcek5fZmAV3OIjMpaCzRuhVrXInU
zoUrp8Klr8OFz8K5jyLZ9yLpt6LJ12Lxl2Ox38cjz8UiT0fDT4QjvwlEf+2O
/ZMl+QtV9uebpZ9P1n51pfnMSfjVj9sfvkOc+6A79gmz8g0r/Y7TX+Udd3v+
2X5srZ/Zu1/Q3K9a7jdcf4SCf0Rjg298n0tchQ6sxA0nOKOJiSc7AyvhwWlQ
LdOvZ/qNbL+V7cG5HpLl2xkOS7FYnBG+UyxAYR5SGBhtI4aqEHirUZ+sJi83
FKO0UsXa3FwgxMdjvUyiV0j1SqleVZSHMj00w2NpFk8wZKRL+jukCyYtDUJb
xmX5zlYaW06gM1FkLATdDDQv+RrfeWsnvJUvvaVPvIUPfLl3/Nk3/OlXA8mX
gonfBePPBWNPB2JP+GKPueOP2pK/NmQekef/aaP8yEztN7ebz1+EXz+Nfvg1
9vWXxOVvuhPf0quXWekIp5/iHcs9/3YvquinDf2C/X7Fe78Rvg8lasIIOWpV
He4KyuJ5H3iqKgp+9CVhD5bqVQSoDKiW7ddz/Uau38r34UK/Xeh18jyeZfEk
g0dpPNjFvSTu7OBWtKNrdvYK7alA492dD0fwJX/bkmACqV4i08tme8Vsv5Lr
1/L9xuDvKfaIItfNMVSyS0cwytei7NWuoUAq0sR2rLMcwqb96F0PcsMFXXQ0
z9jr39hqn9sqx+yl9xyFt5y5112ZP7jTL3pSL3iSz3mE3XniSVfycXvqt+b0
b3TZR+WFRzfLv1moPX6v+bvb0BtXkY8utr8+3zl7nrh+qTt1k14fZ+TzrGGd
c+zxAU0vZu6lXf1CoF+J3m+khKkEuMD603tgBYqBPblwolcUlxQwU1K9crpf
EaCyoFquXxe+wUK/Veoj5T5W6RNlnsyzZIohoxQZIgk/QXgw0omQ1npXn6OU
HlY/p2+cUkAZb6Mbr/DpUr9Q7JeK/WqxXy/1m+U+XL3fqfe79R5T4dgCyaZQ
JtRgXCXalOkqY6QkSCx7OtMObNSKXjPD543QKUPzK339U0P1Q0P5HVPxDXPh
VWvuZVvm9/b0847Us87UM47UU/bUk9b0E6bM49rc44ri45Lyk6u1p+eaL05A
b95Fjo20v76NnR3Br4+SY/e6czPU5jKj2GaNcs6p5wPWXtzTywT7hbgwl4R5
JCzRAlQtMUzcNdXETWY1xAunwAkXn06AAVAWxoAIVRVHQr3QbxT7rUofqd/H
W/epZo8uslSa6sbIbpggg3jXj3V9COVtMt4yF0nfr0cwJpyhm1mczkN8odYv
VfqVcr9a7tcr/WatjzTvd5D7dPs+j3C9OsnnYS5eZf05xpagtKHunodcs+Oz
ps5dffuaBj2rhE8oWl8oGseUtfdUlbfU5de0xT/o8y8asy+YM89Z08/a0k/b
0k9Z009ZMk8as0/q8k+pik9Ly89u1V5Ybby00HprFj42jX4zhZ2d7lybI8YW
ybk1an2b3pMxGg1rNnJuB7geLx4G724vZoRhLxz064lDViKXsGsCO8wI1/TS
tbOhTK1XLvUr+X41D6AGVrVCv1bqN6p9CLpPEH/sEX2uQjIpnIri3TDeDQl1
qHCbiSBsAuoVW/fbyP37VIfnWmSvhvarzX611q9W+7VKv1btN+r9FnQfw++z
7B/vU/x9FO9Vm3ymyIVSrDNEGzyUzNbdMBDzGnxMgV2Xts/vICck0KfbrQ8k
jbd3a69LK3+Ql15UFX6nzT2vzz5ryjxjTj9tGZR52pR92pB/RlN4Tll+QVp9
abv+6kbzrVXo2Ary9Ur77Grn2jp+d4uc3e2uKahdLa02MWY76/Rw/iAfjfGp
VC+Xy1GBKGEIEaYQYRYzBQljENcHcXUYV8Zxab6z2jn+WQhvBcl0iIyFyUiY
DEdAkSgZi3eTKSpfYOooj/X72P1uoYeH+I6bw+wcZuXbth7quI9470PR+63i
fbTdp+8TbL/O0Hm6naQaMaoc6xZi3XyCKqSpcoFptDiMvk//fz3qjwTab1Z7
uTQfCbMuD2O00nJdd1NJzu/h49udGxvt82voyRX4s5XW+yvNN9bqr2xWXpSU
XpAKGvlnNdln9Jmnjemn97kEN0Ev97xBkBQ8K6/Ia29IhfWzdUwCfy1Bv9vB
ru517sqJWTW5qqd2zbTKwZg8rCPI+aNcJMkns71cMUZ6oqQ9TFhDhEWwCgrh
xgCu9+MaX0fh6eyY0aVdaE/b9rvxiJ8IB4lQmAhFyFCUDMfIaLIbz1LpMlNo
cYUuV+DYJNcNsoSL7dhYzMyhph5kut+w9AtuPhrhYg1h3a5D97M4EyfRCFkP
ksVwNxftZhPdbJbKl5lyi6t3e80+3/pjt3ofyfWFLUvSx/msrElLy2XU5nZ3
fo0YX8JvzGPnZ9GTM8hnM9D7s83X5+svLlVfWCs/uy3MsvxTyuxTWmHepZ8y
gzkozMRnbMKszL5gyb9oKv7BUH5dV31bU/9Q1fxUBX2jRL5Vta9oOqM6fMZI
rli7O05K5aWNQcYRZX1JLpzlEwU+W4mQ7jDhCBO2EGENEpYgbg7gJj9u8OE6
b0fjwpS2ttLc1lsxh6vj8+H+ABEIEYEwGYiSwTgZTnYjWSpWpOMNJtZmYiQT
pGk3Tdpo3MRgehbR8E3V/bKiF1Uyag2+HstpKX+c9zRJN9by4CU3kfUTqTCZ
FMZnhkoV6XSDTeFcluOy/W76fjt6v+7vZ+29sJ5zylntFi1Z7s7PkOMT+I2x
zvnR9olR5LNR+L2x1msTjd9N155ZKD+1VnxCkn9cnn1ck37CkHrCknrSlnoa
rPPp552Z3zuyL9vzr9qKb1rL75mrx0yNL0ytkyb4nAm9asbuWDtTDmLZTW77
KIUw62OMLQneaxsqcPEyn6mFCVeYcIYIe5CwBQlrALcEcLMfN/pwg6ejd3d0
TkzvwEzOjt3dcflwT4DwhghfmPBFSX+cDCS7gXQ3kKd8VdoP0b427cYpG9k1
dgkt1VHSiJRpbvPFlX5ohl4bab65unWFWncRkhqkhYumdtraibvxaIAQprPA
HspSgTodxJgQzQQ5MtBru+83rfeL+n5cwfu2OfMKo5il18a6k7eI61c75y5j
Jy6jn16B37veevV244W7tSemyo8tFX+7mfuNNPMbTeq3xuTjtsQTzsTT7sSz
3uQL3tSL3swfvLnXPfl33KUPXJVPXbWvnY3TztYFF3zDjd71YjN+fDlIbEe6
8jilS9HWLOMusMEyF6vx6UaIcIUIZ1C0CuDAyo+bfbjJhxu9HaOnY3R3TK6O
xd2xeXCnD3cFcHeQ8IQJT4T0xkhvgvQku+5s11mmXHXKAVE2pGvCulqclBP4
Dtne6LYWqco9JnmJc7zPb//dE/bwd8n4XCW63QrJ0YAR8zs6Pi8u+HtipCvd
tVcoB0w5CMpGE1a2beSbmn5Z2k9v9kLLvGOG040xO7eoxcvk6Fn8/Cns+En0
k9PIO2ehVy41nrtR++3d8q9nC79az/5Kmv61JvmoOf5bR+xxb+ypQOzZYPyF
cOKlcOrVcPrNUPa9UOFYsPR5sHI8WPsu2LwchG6FkPFwey7aWY3jkiSpyIB9
jrVIuytMoMZGG1wKChKuILByBHB7ALf5casft/gAl9nbMXlAZk/H4unYvLjd
hzv9uPBggVcYja4o6YyRjjhpzXStha613DXXu8YmqYVIJULstfENrLOIIZPt
5k20erJeflVdeOTrzKmTxfXRmmapZZYiNl3bbsXsro7NhwurpTFJ6IukoUnq
26SWJFR0W860drnKRi+30I9P9nyjvOUGp7zEbH5HzZwgb37ZOfVp++NPkbe/
gl4+1XzmQu2fb5Z/OZn/5Wrml9LkP+ljv7JFHvWGHwuGn4yGn41HXkhEX0rG
X0sm30qm309mP0kUvkqUTiWq5xL1q4nmSBKaSCEL6fZ6trObJ5TCP6TctVVp
T50JNtkYxKaQgVXgiJXVB7gsXsA1gLJ6ccFK+I7sftwhPFiwFaZthLBHCWuM
NKXA2y2NBVJfJrVVQlUjpA18u9lZbWJzzfZYHblabJ0M1T/arbw1Wjp1tzI1
W99abymksEaD6k1tvR0TJrtwKJHHcUWOUFQJOUTsdfBtcViu0NV5tjDBJUd6
4as91zneeJqTfc2sfkZNfERefq/zxdvo2+/BL33afOpk7ZHLpZ+NZ3+2mvwH
eewfzeH/7An+Ohz4TcL/dMr/Qibwcjb0Wi7yVi72Xj7xYT79WT77Tb5wJle6
mKtez9dH862pArxYRDdK2F6lo64Rxjppb1IeiA4iTAxlU1gAQDkDOLDyAysB
xComWD1IsBI+InwKPEAgDYrHAuHQGSZMEUIfJ/QpQpclNHlCVSBkJXy31Nks
d5ZL2GwBHcsi16PQOWfzhLT+1ULt3GJ9fLWxtN3alsFSDSI3oApLW27H9jzY
dqQjSXe2i/hWvbMOd5ax9hwOTZP18W7pNp25ysTOcv4TPcdnvP4jbu9dZulN
6u5rxNk/tD94CX7xzebjn1b/8Wzx7+6m/2499lNN6GdO3y/Cnn9OuJ5Ku17I
ul7Ou18veN8p+j8ohT4uRb4ox78pp05XsmerhcvV8s1qdazamKm1luvCqSsq
bWKaFm6CCAfS9aJUCKPjHSaNB3CnmMMPrOyi1T7XD6xAg4EnLGvCETMIdmXC
3kwbJTRxQp0klGlcnsH3svh2trOexZYy7dkkOh5FbvugK9bWeUXz7Ebj0kZj
bKs5t9talcNbakSiRyQmdNva3nC114LYWhxbzWIC8kIdm4Hb99rIHaxxE69c
JvJnydQJKvI57fuAtb/Z07/M7f2OXXyeGnkWP/EM8uIzrd++Vf1PJ/N/dTf+
HyTBv7G6fxq2P5K0PJExP583v1y0vF62vVNxfFhxfVL1flkLnKiFz9Rj5+up
K43szUbhbrM82arOQ41VuLWNwHIE1aKYuY07MMLX6YYIKk7SwjFMXIL8wApw
+YZW3iPtow3mpl9c/4WtRQA3BHBdAOxaVRFcEcOFSSRNdHaSna0ktpbAlmLt
2Qg6EUBGXfBNM3RN1bqy07y20xrbbc1IoUUFvKqG17TIugFdNaGLDnTR114I
t+cT7dlse6qIjtfQkRZyDW5dQOrftkvHsdznneSHePhN0vsyZX+O0T/Oy37N
Lv+KuvXrzif/DP32ucrffZH+yWTwL7WO/xA2/jKlfSynfq6kfqmieb2mfaeu
/7Bh+rRh/bLpONH0fNv0X2iFr7Zit6DkXSg7CRfmkfIqWt1qN6TtlgpDDHjb
SmAuEvd1yXC3G6eoNO0/ZOUDVvtcP4QacpnFhD2Y0Q+2rFo/rgrgihAuC3ek
kc5uFLwNcyOKrUbai6H2rB+d9CBjdviOEbqlhm5KW7ekrXEpNC2H5hTwogpe
0iBLOmTBiMzY0Fk3OhNApwTeBDqWQUbyyPUyfLEGnWk2v27VPoNKH8C5t5Dk
y2jkubb/ccz5CGH+OaX6e37zb+hbP0Vf+kXlr46F/82m+S9Din/M7Py2tP1s
beulhuS11u47kPRDSPEJrPkS1p+Azd8i9vOI+wriu4mERtHYJJqca2dX2oVN
rLzbqSrxho5omQnEQba9XSxI4TGaSDHdLPPAynfIyvujVmYxsKPwiftVH9je
K30dmb8jDXR2gx1JENsKYutBbCXQXvShcx502oHcs8JjBviOGhqRQ3fk0Lgc
mlJAs0p4TgXPq+E5LTytRyYtyKQDmfAg437kbhgZicHXk/DlDHQ21zpRbH5e
aXxQq71RK79cyz9XyzxWTzxSj/ysEfjbpvvfwZZ/21H97+zEvy3/5H3l/xVd
+M+Vqcdbk88hUy+1Z15rL7yDLX+ArX+CSb7EpMcx5RlMex4zXcFsNzDXnY5v
ohOa7cSWOsl1PLuDF+REWUPWjGTD1m25KcRPtyM0lmDwNEvkWT/YNTl9h6y8
+1ZDro5lmFnMJOy7vB2Dt6P3drTejtrbUXo6Mk9n19vZ8WHbPmzTh6172yue
9qILnXOgMzZk0oTc08NjaviuEhpTQBMKYDWthGdUoGk1PKGD7xnhcQs85oBH
3fBtL3wjAF0JQeejrTOx5teJxqep+nvp2muZ6u+y5SeypUeyhf+Uzf91OvuT
ZOZ/iab+e0/yv92N/zd/bZv84IPOiTc7Z9/EL7+N33iPuPMhMf4xMf05Of8V
uXy8u3Gmu3OOlF8mNddJ4whpGydd06RvgQytkbFtMiXtZlXdgp4qW6iak254
mVaQQaJsO8liWQ4vcL5DVl4ANUi06lg9IIuYWWyw4xL2qMKuXufpaD0dtaej
dHfk7s6eC5O4sS03BlZpV3vF2V60o/NWdMaMTBmQCS18Tw2PqeB7SmhSCU0p
gRVIBU+q4HENfFcHjxrhOxb4tg264YCuuqCLntZ33uZJX+NLf/3jQO3dQPU1
f+V3vvKTnuKvXIV/sOb+Vp/9v6Xp/2M++T+fjv2Pz4Ue+XvnxJNL2ZcvdD4+
iZ84Tpz/hrh6nLh9khw/TU5/210411292N28Su3eoOQjtGaMNk7R1nnKtUL5
NunQLh1T0CktnTWCl33LbrbmZxthDopzSJpv53isyAtb8QGXF1g94LIJm0/P
w60AlFs8/XF3tO6O2t1RujC5C9tzYjsObNPRXre3V+3tZRu6aEHnzeisEZnW
IZMaeEINWKaUoGlgBRLQJpTQuBIaFWaoFrqth24YoWvm1mVL67y1ecbWPGFr
fGGrH7PV3rVUXzOXf28oPaUpPirL/2Ir99P5zF/fTP3lJ/H/89Xor38dev8f
3dO/0AdfXCi/eRv96Apx/CJx7iJ59SI5com8d6U7c627dJNaH6G271LSCVo1
TevmGdMyY1sHb9P1S9mwio3r2ZQFvMhb9HDlIHgxvZHgoUwPyffQUk+w8gKo
I1Yi1BErd8csnOyICWc9+1aujtbVUQvn105M7sSkDmzXjm3b2pvW9pqlvWJG
F03ovAGZ0yOzOmRGA8+o9yfdjDD7lNCMMA3FyShMSWEFu6OAbqugm+rWdU3r
irZ1Udc8q2ue1jW+0dU/19aOaarvKiuvy8ov7hSfWS88Np9/5G725+fTf/9Z
8h/ejT/5YvTNX4RP/soz/4jN/rws/eZS7YMJ9JM75Mnb5IVb5PXb3dGR7uRo
d34MvHttc5renaMVi4xmlTFuMlYJ65SyXhW4OiNi4hI28Cb8nA+8WbEc69WS
4DUFqACe+/UetfIAqAMrN8jiPmrl6hhcHb1LsMK0TkztxFQOTOHAZMJ+0tbe
sba3Le1NM7pmQleM6LIBWdQjC1pkXiMu4yqQsKrPPrCSQ5PCai+D7spat2Wt
G/LWVXnrsqJ5QdH8TtE4Ja9/I6t9vlc7tlN9d7P8xmrp5fni8/cKT97IPXom
88g36Sc/Sb74dvzt52Nf/ip85THf8mNO0zPG2Bt7hQ9XG5/NoV9PEWcmupcm
urcmu+NT1MwMtThHry/SkhVats6othj9Lrjgwq5i3TpwcWLYBi6PTXn5bBBc
+FBKiC+a5PvNUh+uHLHyCHUOrNxHrVzgJFpo38qJ6ZyilUO0smNyW1tqa+9a
2xJLe8uMbprQdSO6akBWdMiyFhH2BotqeEE48AkJR0DhOKiAZuRg8zAlg+5J
W2N7rTu7rZs7zas7zUs7zfM7jW8l9VPb9W82a5+vVY8tV96bL785WXplpPD7
K/nnz+dePJ155av0m8eSH7yZ+PK5+HdPRO48E1h/1mN40hl+XZf5UFr+fLN5
fAU9vYifm+9eW6DuLFKTS9T8Cr2yRm9tMnsSRrnHaOXgiiebjnOZwCXnQSe4
rU0iwKcj4J4nxVSvkgVP/zbKfah2f2DlAR1YuQHUgZULdGDl7BicGLByYFoH
prFjKjumtAErmbW9Z2nvmNvCVnzLiG4a0HU9sqZDVrXIigZZVsNLKnhRCS8o
4XkFNC+HZuXQjAyalrYm91r3dlt3d1ojkubNrebVzcaF9cZ3q/WTy7VvFqtf
zFY/nqx8MFZ+b6T07o3Cu5fz753LvX8q+9GX6c8+Sn3zRvK7ZxNXn49O/j64
9aJP/zuP/zVr6kNt4Qt57cRO69st9MIGfmW9e2uNGt+gZzbppW16fRdcUiFX
MGo1a9CxFhO4Bt/j4AIePuzn42E+Fetlk71CplfK96ulfr3ab9aBleeBVcch
Qh1YuUAHVk6Q0YkZHOBJLWBlB1ZqG3hKUGFtyyxtqaW9Z0Z3TKjEiG4Z0E09
sqFD1rXIqgZZUcMrKnhZCS8Ju1AFtCCH5mXQrBSa2WtN7bYmdlrjkubodnNk
s3FzvXF1rX5puX5+sfbtXPXUdOX4ROXru+Uvb5e+uF744lL+i7O5r05mj3+Z
OfVR+twbqau/T9x5OTb/Snjn1YD+FZ/3NXfiQ0vuS335pKpxVg5d2mtf28Vv
75B3d6jJXXpeyqzKmS0Vs6dhlXpWZ2JNVnA/B5eb9/nBba+i0V4i0Uune7lc
r1gEr57Uav1G477ngVXH4d5vn8t1yMrZMQMoTMjoGFrZRSubYNVWWdtK4RTY
0paZ21ITumtEdwyoRI9u6ZFNHbIhnMhokDU1vKqCV5TwsgJekkOLMmhBBs1L
W7N7rZnd1pSkNbHdHN9qjm40RtYaN1fq15fqVxZqF2er56cqZ+9Vvr1bPnO7
dPp68fSlwumz+W9P5s5+mb34UebaG+mRV5OTb8RX3orsvRUyvBV0v+mPfeTK
fGktnjJWz+mal9XwDVV7RImPK8kpZXdORS9pmA0ds2Ng5WZWYwUX2lvcnMMH
7q4WiPDheC+eArdGyeb7+VK/VO1X6v16c2jVcbpB+1YukM21zyVA7Vs5MCFg
Zcf0dtHKJli11dZ9K4W5LTehgtWeEd01oDt6VKJDtrXIpgbZUMPrwtmfCl5V
wqsKaEUOLcmgRSm0sNea323N7rRmJM2prebEZnN8vXF3tXFnuX57sXZjvnZt
pnplsnJ5vHJxtHzxVunCteKFS4WLZ/OXT+aufpm9cSxz583MvbdT8+8mNt6L
yd+PGN4Pu94PRj7yp79yF07by+ct9SvG1k0DMqpv39N3pvXEvL67bKTWTcy2
hZXaWKWD07nBPS5sQXDPIl+MDyZ70Qy4O0q6KN7uo9YvN/rVlmi1D7Vv5Tpk
5exYxYCVAzMPrOzACnDZMJ0N01rbGmtbbWmrzOCZecFKZkSlBnTPgO7qkR0d
ItEi2xpkSw1vquANJbyugNfk0KocWpFBy1Joaa+1sNOal7Rmt5szW82pjcbk
WuPeamNsuT66WBuZq92eqd6crNwYr1wfLV+7Vbp2rXj9UuH62cLNU/nbX+VG
P87eey8z80Fq5aOk5Fhc+XHM+HHE9XE49HE49ZU/d8ZTuuCsXrU3blmhuxZk
wtKesXQWLMSKldywUxIHLXUxSg+r9bHGAGcJc44ouKWMP90LZXuxQi9Z6mWq
/Xy9X2z2K1Df3XGJ7Vu5Dlk5D1mJUMDKDqwAl020sraBlWVoZWorTKjciMoM
qFSP7umQXS2yo0UkGmRbDW+p4E0lvKGA1+XQmgxalUIre9Dybmtpp7Uoac1v
Nec2mzPrjem1xuRKY2KpPr5QG5ur3Z2u3pmo3hmrjNwpj9wqjVwrjVwq3jlb
uHsqP/51fvKT3Myx7OIn6Y1PU3ufJdSfx01fxFxfRINfRBNfhXNnAsULvso1
T/22qznmhCed6KxwOuHsrLqITTe54+nKfJQqQGtDjDHCWGOsI8F60pw/y4Xy
fLTEJyp8utbLNXpFqFdGeoetXIesnEMrhxBmETPbgZXJhhltopUVWOksba2l
rTG31aa2yoQqjajCgMoNqEyPSnXInhbZ1SA7akSihrdV8JYS3lTAG3JoXQat
SaHVPWhlt7UsaS1ttxa3mgsbzfn1xuxqY2a5Pr1Un5yvTczW7k1Xxyeq42OV
sTvlsVvlsWul8UvFe+eKk6cL09/kZz/LL3yeXfsis/1lWvZVSvt10vxNwvVN
PHA8Fjsey5yJFC6GytcC1du+xpi3NemF57zokre95uts+vGdACELkqpwVxul
jHHakqQd4q0//Hk2VGSjFS5R49INLtviCzBfQvmBlQtAPbByOIEV4HIIYftW
dmBltg2trEJtvUW0Mu9bqY2oyogqDahCj8p1qEyHSLXIngbZVSM7KliihLcV
8LYc3pJBm1JoYw9a34XWdlqrktbKdmt5s7m00Vxca8yvNuaWG7OL9Zn5+vRs
bWqqOjVRnRyrTN6pTN4qT10vTV0uTZ8vzp4pzh8vLH6VX/06t/lNdvd4Rnki
rTuZspxKuk4l/KcT0dOJ1JlE/mK0dC1SGQnVx4LNqSA0F4SXguhasL0V6uyE
cVmEUMVIbaJrTHYtacqepd152ife9yNSZeJ1NtVkMxCXR7himxOhHlg5nQBq
38oxtLKDLCLUvpVVqG2wiFZmkNbU1gysDPtWCh0q1yIyDSLVIHtqZFcF7yjh
HQUskcPbMmhLCm3uQRu7rfWd1pqktbrVWtlsLm80l9caSyuNxeXGwmJ9fr4+
N1ubm6rNTlRnx6qzdyqzt8qz18tzl0vz50uL3xaXThRXTxQ2TuYlp3Ky01n1
6YzhTNr6bcr1Xcp/Nhk5m0yeS2YvJIvX4uXbsdpYtDEVac5FoKUIshZFN6Pt
nRgmS3SUSVybIgwZ0pzr2vJdV5HylqlAlQ7X6ViTSUBMGmFyKFvAWNe+lUuE
OrByDKwwm31oZQMBKyvIaAFWBnNbL1iZgJXWiGqMqNqAqvSoUidYIQotItcg
MjUiVSF7KnhXCe8q4B05LJFB21Joaw/a2m1t7rQ2tlvrW621zebqenNlrbGy
0lheaiwt1hfn64uztYWp2sJEdWGsujBaWbhdWbxRXrxSXr5QWvmutHa6uHG6
sH0mv/dtXvFdTnM2azybsZ7LuM6n/RfS4Yvp+KV05nK6cC1Vvp2sjiVqk4nG
bLy1mIBWE8hmApUk29IUpkh3NFlcnyNMBcJaIh1l0g3uZUGBe1lAVBymkyid
wZhch3F13AMr5yErB8juwOx2YGU7bGUFmaxtwco4tNKb2jqjaGUAqfWoSocq
tcBKoUHkakSmQqRKeE8B78nhXTm8I4MkUkiyC23vQFuS1uZ2a3OrtbHRXF9v
rq0211Yaq0uNlYX6ynx9eaa2PFVbnqgtj1eXR6vLtysrNyqrV8trF8vrZ0ub
35W2zxZ3zxbk5/Kq83ndhZzpQtZ2Meu6lPFdzoSvZGJXM6lrmdyNTPFWpnI3
XZtM12dTzcVUayUNbaQRSQbdy7blOUydx3TFjrGEWyr797LwPriXBUrF21Sy
Q2VwemDlPLByOh5mZQNZrCBgZWkLGc3AymDat9IZUK1gpQdWah2q0iJKDbBS
qBG5CpEpYakClsrhPRm8K4V296CdXUiyA21LWtvbra2t1uZGc3O9ubHaXF9p
rC811hbqa3P1tdn66lRtdaK2Ol5dG62ujVTXb1bWr1U2LpW3zpW3z5d2LxRl
F4rKiwXNpbzhUt58OWe/knNfzfquZUPXs7Eb2eTNbOZ2Nj+SK43mqhPZ2ky2
sZBtLmdb6zloKwfv5hFZAVUW2+DmDJWOqdqx1nHHg3tZIGSoTUY63TjeTRJd
wcq5b+USoYZWAGrfynbUyiLUNpmBldEErAzGtt6IDqy0elSjA1ZqLaLSIEo1
olQhChUiV8IyBSyTw1IZvCeF9vag3V1oZwfakbQk263tzdb2RnNrvbm12txc
aWwuNTYWGhvz9Y3Z+sZ0bWOitjFe27hb3Ripbt6sbl2rbF+uSC6Wdy+VpZdK
istF9eWi7krBeLVguZZ3XM+7r+d8N3KhW7no7VxiJJe+k8vdzRfG8uV7+ep0
vj6XbywVmmuF1mYRkhThvRIiL6OqaltbaxvqmLnZsbY6Dhh3IbinjfsxItwh
YjiRJAgnsNrncuxbAS475hCt7DZgBbisIItFqD2wMolWxoGVARXS6YGVVodq
tKhagwipRCulElEoYbkClsthmQyWSSHpHrS3C+3tQLuS1s5Wa2ezJdloStab
26vN7ZXG9lJja6GxNV/fmq1vTde3Jmtb92pbd2vbd6rbt6qS69WdK5XdKxXp
lbLiakl1taS9VtRfL5quF6w3Co6bBfetvO92PjiSj9zJx0fzqbF8ZryQnygU
Jwvl6WJ1tlhfKDXAfQbKra0ytFOBpVVEUUPUDVTbbBtabROMWRHMgWKeNubH
sFAHi+JYgug8sHLsB6xEKIcItW9lPWplBplM/38b97XbOo4AYPj9r3ZnTkt1
771bltUl18SpTm+2JFbJSc48wZK0NZtZLPBfC+QHieSFQJ5hcCtdWGnaRlW5
laJshsxK5g0G4UAKpX7Q7/F63aDXod027bRop0nbddKukVaVtCqkWcLNIm4W
cCOHGhnUSKNGEjbisHEMG4egsQ+aP0Hru9/6w2//y+/+y+v925X+7Q7/WKt/
rI0/V9afq9G31fT72/zH2+Ln28Wvt+u9t5v9t/vDt8ejt+fY6i2+WifXbnrt
Z11QcFHJwxWf1AFtQdpFgYSDIQk1GppB6IThZLOZv28WH5uLz831783tX5ut
1eSL1TiyGvE4l8OtOJfNs613lmXyTINn6NxK17iVpm5UhVspw3Aoh8NBKAur
QT+QeoHUDfqdoN+mvRbtNWm3Qbt10qmRTpW0K6Rdwq0ibhVwK4daWdRKo1YS
tuKwdQxbh7C1D9q/QOcH6Pzpd//w+3940p+e/KerfHO1b675fW1/X49/rKY/
Vye/Vou91cX+6upgdXO4ujtaPcRWT/H1S3L9ll6vs66bd72iB8o+rALUAKgF
cRcRCZMhISqlRkDtkI43dPZOTz/o+Se95DdaUAG1jVuNd1bTUWTl7BrZPMd+
d4SVLaysyMoQVrrKrTRlow65lSKshlIos/rBoBcMuoHUCaQ27bdov0l7Ddqr
k26NdKukWyGdEu4UcaeA2znczqJ2GrWTqJ2AnRjsHMHOAezuge4P0PsG+t98
6Zsvf/eU7572wzV+uNZP1/m5Hv9az/bWJ/vrxcH64nB9dbReHq9vY+v7+Pox
uX5OuS8Z9y3nrgqeW/K9iu/XAGhA0Ib8xg8JI5kglSIjQFaIRhs0fUfzD7T4
RBe/0dVfaPLFarzt46vVZGtlR1aWsDKFlSGsdNbG0HjMShdW2pBxhaocKoNQ
kTjXsB/IvUDuBoNOMGgHUotKTdpv0H6d9mqkVyW9CumWSLeIuwXczeFuFnXT
qJtC3QTqxmD3CPYOYG8P9n8C6QcY/ADyD1/56as/Pf2nZ/7y7F/uaM+d7Luz
/fXJwXpxuD4/Wl8er69j65v4+i7pPqTcp4z7nPVe895b0V+V/HUFuDXgNaHX
Rn4X+30MZAIUCvQAmCFwNmD8DmYf4OTTP/vtX/zlTz5PtlZj3s5qtItB/W3F
uSwWt3KElS2sLGFlMiuVpys8ZqXJ3EoVVkqfWw2FldwJ5HYwaNFBk0oNKtWp
VCP9KulXSL9E+kXcK+BeDveyuJdGvRTqJVA/jvrHsH8IpX04+MUC8i+g/PLV
X76+5xt7nrXvOfve+MCdHrizQ/fkyF0cu+cx9zLuXifcm6R7m3Lv0+5j1nvK
ec8F/6Xov5X9typY1eG6Cddt5Hax28fugHhD6mmBZ4SutXGdd3fy4c4+1ye/
14u/1v9r9TEb8biVw+Nc9s5qbL0zq5HJrRyDW9k6t7I0bmUKK4NZDXnMShvw
VClU+6HSC1jDbjAUVnKLyk06aNBBnQ5qRKoSqUKkEpGKRCpgKY+lLJYyWEoh
KYmkOJKO0eAQDg6gvAeHe1DZA+o+0PZ9Y983D3z7wBsdeuNDb3rkzY+802N3
EXPP4+5lwr1OusuUd5v27jLeQ9Z7zPtPBf+55L+UwWsVvNXhWxOuWmjVwase
WUlkJdOVEqy0cGVsVtb7m/P+Nv54nX6+zn+/CKuT8c5qPtpZzf62sneNrf9a
jYSVI6xsYWUJK1PhVsaQp8uhzqwkHrNSe4HaDRRWJxi2g2GLDptUblC5TuUa
latkUCGDMhkUyaCAB3k8yOJBBg/SeJBEchzJMSQfoeEBZCkHUD0A2gEwDoF5
6FuHvnPkj478ybE3O/bmMe805i3i3nnCu0x6VylvmfZuMt5t1rvP+Q95/7Ho
P5XAcwW8VOFLHb420GsLvXbwa5e89snrgL4Og1c1fNHCF2PzbL0/2x9Po8/H
8e9HAbXtH1bOzmoaWU2E1VhAjQSUo/NsjbWxVB6z4jErmcWtdImn9UNNWKkd
ntIOlFagNOmwQYd1OqzRYZXIFSKXiVwkcoHIeSznsJzBchoPk2iYQMMYUo6R
cojUQ8jSD6FxBMwjYB0B+9gfHfvjY38a82cx/yTunya8s4R3nvQuUt5V2rvO
+DdZ/zbn3+X9+4L/UASPJfBUAU9V+FyDzw303EQvbfzSIS898izR50HwPAye
lPBR3Tzq7w/Gx735eTf6fTv+YjX62MagtjGobQyKW5nv25jVKLJyhJUtrCxl
Yw25lSmsjEFoMKs+T+uFWjfQhJXaDtRWoDap0qBKnSo1qlTpsEKGZTIskWGB
DPNkmMPDLFbSWElhJYGVOFKPkXqEtGOkH0PjGJrH0DoGdgw4MTCKgUncn8b9
WcI/SfinSf8s6Z+n/Iu0f5XxmdUy69/k/Nu8f1cA90XwUAaPFfhYhU81+FRH
T0301MJPbcwvKerRxz59kIIHObwfbu6UzY36vtQ+ru3Pq/Hn6dZqxNpZzSOr
2dbK4nGurZXB41yRlSOsbIXHrCxhZQ5CU1gZfZ7eC/VuoHcCrS0SVmqDqnWq
1qhapUqFKGWilIhSJEqeKDmsZLGaxmoKq0msxrEWQyw9howYNGPQikE7Dp04
GMXBOA4mCTBLgHnSP0n6pyn/LOWfp/2LjH/JrLL+Muff5MFtAdwWwV0J3JfB
QwU+VOFDDT3W0WMDPTbxYws/tMlDh9x36V0vuO0HN1K4lDZXg/dL5Z3/Bry1
Gn2xcnYxqG07K/N929ZqrHOrkcZz1I0TWdnMShYJK1MKTWbVEwkrvc1jVloz
0BpUq1OtRrUqVStULRO1RNQiUQtEzREti7UM1lJYS2I9gfU4CxlxZMaRFRdQ
CThKwHGCQ02TYJYE8xQ4SYFFGpylwXkGXGTAZRZc5cB1Dizz4CayuivD+wq8
r7IQ43qoo/sGvm/i+xa5a5PbNr3t0GUnuO6Gl93wvLtZDDan6vtcWJ0KKF4E
NY+gZtbOarq1Mnhbq3FkNRJWjsJjVnZkZUk7K7PHY1ZGJzDaPL0V6M1Ab1C9
TnVhpVWoVqZaiWhFohWIlid6lugZrKexnsRGgmcmEMtKIDuBnCQcJeFYNE3B
WUpApcFpWlhlwHkWXGTBZU5Y5cGywK1uiuC2BG/LkHHdVeBdFd3X0H0d3dXx
XQPfNlnkpkmWLXrVopet4LwZLlrhvBdO5c1IQH21Ooms5pEV5zK51TSymgio
scbbWo0ElDPkMSuesOL1Q0tYmd3Q3Fq1RM3AaASGsNKrVK9QvUz1EtGLRC8Q
PU+MHDEyxEhjI4WNJDaT2OIhO4mcFBrx4DgFJyk4TcNZGs7TkFtlwCIDzrLC
Kies8tzqugCWRWYFb4QVT1jxaui2hm/r+IZHlg1y1SCXdXpep4taMK8Hk1bg
sPGPdlanERTP3lnNrZ3VbGtl8LZWk8hqrO6seMLKkTfOgFvZEm9rZXV5zMps
B2ZLFFkZNWpUqVGhRpkaJWoUiVEghrAys8RMEzOFWVYK2yIOleaN02iSjqAy
8ER0moWLLORWOWGV51ZXBWYFl0W4LHGrm8jqtoJuq7tuangpuqrhyyo5r5JF
hZ6U6LRMRzVqstX1byvn4/SL1UlkNRdQop3VVN9ZTTQesxqrm3FkNYqseMyq
L+qFtrCyOoHVDqwWj1mZjcCsByYbSZWaFWqWqVmiZpGaBWLmiSmsrAyx0ixs
i5w05lAZNM6gSQZNeXCWgfMsPMlGUDneeR5e5OFlHl4VeNfFf1jtqqBdVbTk
4esqvqrgiwo+K5PTIpnnyThHLLYssPPM6HPxxeo0gjqJoHiR1Syy4mk7q0lk
NRZQI1kUWTl93taK1wntyMpqBlYjsOqBVaNWlVoVUZlaJWoVqVUgFhtkltiZ
XU4Gs0YZPOahSRZNRbMsmmcRgzrJwdMcXERQOysBdVXkVtfCavn/rJai6wq6
KqPLMr4o4bMiPs3jWRaP2FvNtuMs7gurRQTFi6xOvlhxLuN9299WUwHFUzYT
YcWLrHiRFfvYnS5va2W3RM3AbgR2PbBrLM5lV6hdpnaJ2kVqF6idJ3aO2Fni
iEZs2Fk8Fk2ymEPl0CyH5qKTHDrNoUUess62UAXepYDaWZV2Vsu/rcqItYy6
LqOrErosovMCOsszfzRj7zDbedkxOAZ7kdUigtrGoLZtoXhbK33X1mr6xWoS
WfE4FLca9UWRldMJnXbosKXyf60C+59WToE6eerkCGsUNc5h1iSHp6LZ1opN
Ko9ORYs8OmPTLMBzAXVRhJfFyKr0D6svRVAl3lURXRbQOXsO+6LZSsj2WXbo
3YfqD9D7D1w90Zs=
           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[{PolygonBox[CompressedData["
1:eJxNmnWYV2W3hmf/Nh3SnUM3Dt0MzQBDDN0MMHR359ANgnR3h4RIKYqkqAjS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           "]], 
          PolygonBox[{{945, 946, 901, 466, 465}, {946, 930, 435, 436, 901}}]},
         
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, {{
       LineBox[{2, 1, 31, 61, 91, 121, 151, 181, 211, 241, 271, 301, 331, 361,
         391, 421, 932}], LineBox[CompressedData["
1:eJwVz8kxwwEUwOG/fUsssZNkJldJBYkCIkcncXSQ2BJbFrHFMhogKlABKqAB
VEADqACfwzfv8ubN7yVWyoultiAICrTTQSdddNNDL330M0CIMIMMMcwIEUYZ
Y5wJJplimhlmiRIjzjzL1LnlkTe+/+8LS5GjyBV3PHEt9N38ISo8zRJVbrjn
hU9CdufIssolF5xzRpNTTjjmiEMaHFCnRpUK++yxyw7blCmxxSYbrLNGkQIL
JAnzpeuVB1rUyJMhxq+/PnimZf8PWa0oqQ==
        "]]}, {}, {}, {}}},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHUUUgB8KErWKjRBsxNZS7CSdRBvRSrCKP4WVYBu0EjvBKopgIFgE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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    Dashing[{Small, Small}], 
    CircleBox[{2, 0}, 
     NCache[
      Rational[3, 2], 1.5]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->1294649447,ExpressionUUID->"3a3ff68e-ac4a-47f9-975d-ef0a8a0afe2a"]
}, Open  ]],

Cell["You can count the number of solutions inside the region by:", \
"SolvedExampleNote",
 CellID->87556395,ExpressionUUID->"16d116d1-8b56-4fdc-b403-ef65ab3c7e22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Gamma", "[", "z", "]"}], "-", 
        RowBox[{"Log", "[", "z", "]"}], "-", 
        RowBox[{"\[ImaginaryI]", "/", "2"}]}], ",", "z"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Gamma", "[", "z", "]"}], "-", 
       RowBox[{"Log", "[", "z", "]"}], "-", 
       RowBox[{"\[ImaginaryI]", "/", "2"}]}], ")"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"3", "/", "2"}]}], "]"}]}]}], "]"}]}]], "SolvedExampleInput",
 CellID->644110373,ExpressionUUID->"2518efd5-98db-4d66-b76b-9d185f3341e3"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->537242030,ExpressionUUID->"4ce5ab8f-9153-4f49-84f3-77cb354fe1e3"]
}, Open  ]],

Cell[TextData[{
 "Finer subdivisions could allow you to further pinpoint the positions of the \
solutions. The numerical result obtained with ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 " is:"
}], "SolvedExampleNote",
 CellID->122542205,ExpressionUUID->"2c2fd188-609d-4f41-b0aa-10c18be6c395"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Gamma", "[", "x", "]"}], "-", 
      RowBox[{"Log", "[", "x", "]"}]}], "\[Equal]", 
     RowBox[{"I", "/", "2"}]}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"x", "-", "2"}], "]"}], "<", 
     RowBox[{"3", "/", "2"}]}]}], ",", "x"}], "]"}]], "SolvedExampleInput",
 CellID->65842531,ExpressionUUID->"f05029cb-d1c2-4c1d-946f-3ed1a0f9c85d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"1.49\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         1.49328747884440993232146865921095013618`16.02668424749547, Editable -> 
         False], "-", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.985\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.98485011225979846027911435157875530422`15.845910962674598, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", 
                   FractionBox["\[ImaginaryI]", "2"]}], "+", 
                 RowBox[{"Gamma", "[", "#1", "]"}], "-", 
                 RowBox[{"Log", "[", "#1", "]"}]}], "&"}], ",", 
             RowBox[{"1.493287478992905006`7.57209447731513", "-", 
               
               RowBox[{
                "0.9848501122779852979`7.39132119245909", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[1.49328747884441, -0.9848501122597985]},
     "NumericalApproximation"],
    Root[{Complex[0, 
        Rational[-1, 2]] + Gamma[#] - Log[#]& , 
      Complex[
      1.493287478992905006`7.57209447731513, \
-0.9848501122779852979`7.39132119245909]}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"2.67\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         2.67100902370461090740150211786385625601`16.085566262081514, 
         Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.820\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.81957060357535471695200612884946167469`15.572477279541374, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", 
                   FractionBox["\[ImaginaryI]", "2"]}], "+", 
                 RowBox[{"Gamma", "[", "#1", "]"}], "-", 
                 RowBox[{"Log", "[", "#1", "]"}]}], "&"}], ",", 
             RowBox[{"2.6710089936112143883`7.630976490935997", "+", 
               
               RowBox[{
                "0.8195706152750037811`7.117887519488612", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[2.671009023704611, 0.8195706035753547]},
     "NumericalApproximation"],
    Root[{Complex[0, 
        Rational[-1, 2]] + Gamma[#] - Log[#]& , 
      Complex[
      2.6710089936112143883`7.630976490935997, 
       0.8195706152750037811`7.117887519488612]}]]}]}]], "SolvedExampleOutput",\

 CellID->1185232097,ExpressionUUID->"cd6c133b-0393-4c1e-aacb-092f77bcb0e9"]
}, Open  ]],

Cell["which numerically are:", "SolvedExampleNote",
 CellID->71474107,ExpressionUUID->"5eef956d-7534-4949-bf74-265cdfd09385"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "SolvedExampleInput",
 CellID->487216114,ExpressionUUID->"121df67e-c5c4-47a0-b67b-c95acff99f06"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1.49328747884441`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.9848501122597985`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"2.671009023704611`", "\[VeryThinSpace]", "+", 
    RowBox[{
    "0.8195706035753547`", " ", 
     "\[ImaginaryI]"}]}]}]}]], "SolvedExampleOutput",
 CellID->29974176,ExpressionUUID->"24f84081-6e6e-4ace-b69b-d689b263b4de"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->712078654,ExpressionUUID->"c7afa28e-55f4-4e9a-b9cc-05706001c0d3"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->202985685,ExpressionUUID->"697176bf-29db-499c-ae2c-3ca0cd627fbf"],

Cell[TextData[{
 "Study the number of solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"sin", "(", 
        SuperscriptBox["\[ExponentialE]", "x"], ")"}]}], "-", 
      RowBox[{"cos", "(", 
       RowBox[{"\[Pi]", " ", "x"}], ")"}], "-", 
      RowBox[{"3", "/", "2"}]}], "=", "0"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"1ed7888b-4d52-47ab-b264-fe2e3b56ad55"],
 " in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "<", "x", "<", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"4b199b9d-94a3-4125-9189-7ae5e34968d9"],
 "."
}], "SolvedExampleNote",
 CellID->71538497,ExpressionUUID->"ebb877d0-272e-4b26-80d7-0b8b83a43bcb"],

Cell[TextData[{
 "A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cda6187d-b07a-4c3c-b032-1a8fd6cae1b6"],
 " is:"
}], "SolvedExampleNote",
 CellID->757515115,ExpressionUUID->"67819d2c-2f00-46a4-9eae-09921160dd6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{"Exp", "[", "x", "]"}], "]"}]}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"Pi", " ", "x"}], "]"}], "-", 
    RowBox[{"3", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["896", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], Dashed, 
       RegionBoundary[
        Rectangle[{-1, -0.2}, {1, 0.2}]]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->229744834,ExpressionUUID->"aa8f6e70-9996-4d1f-b2c9-499c4d98a3c6"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GDGkyCdUXEalwxDJ9kVNFinWAwKWPt1BlXDEarxTCjIDgX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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxEuQdQ0/na/v3M+878n3P2bHF13Q7W1XXthd6RjvSOFAVBqiAgiiLSLCiK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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    Dashing[{Small, Small}], 
    LineBox[{{-1, -0.2}, {1, -0.2}, {1, 0.2}, {-1, 0.2}, {-1, -0.2}}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->888664458,ExpressionUUID->"cb379379-4a55-4779-b6f9-303e70841b37"]
}, Open  ]],

Cell["You can count the zeros in a small rectangle (shown):", \
"SolvedExampleNote",
 CellID->213234498,ExpressionUUID->"98d9a1f7-cfa5-44f1-abbf-4d219e165ebe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"2", 
          RowBox[{"Sin", "[", 
           RowBox[{"Exp", "[", "x", "]"}], "]"}]}], "-", 
         RowBox[{"Cos", "[", 
          RowBox[{"Pi", " ", "x"}], "]"}], "-", 
         RowBox[{"3", "/", "2"}]}], ",", "x"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", 
         RowBox[{"Sin", "[", 
          RowBox[{"Exp", "[", "x", "]"}], "]"}]}], "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"Pi", " ", "x"}], "]"}], "-", 
        RowBox[{"3", "/", "2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "ep"}]}], ",", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", "ep"}]}], ",", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", "ep"}]}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "ep"}]}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", "ep"}]}]}], "}"}], "/.", 
      RowBox[{"ep", "->", "0.1"}]}]}], "]"}]}], "//", 
  "Chop"}]], "SolvedExampleInput",
 CellID->337334014,ExpressionUUID->"63735d23-015d-409b-8739-f821c6e683d6"],

Cell[BoxData["1.999999999999607`"], "SolvedExampleOutput",
 CellID->113097057,ExpressionUUID->"306ed182-9cc8-43de-9506-f0b5712fdef9"]
}, Open  ]],

Cell[TextData[{
 "You can also use ",
 ButtonBox["CountRoots",
  BaseStyle->"Link"],
 " for this:"
}], "SolvedExampleNote",
 CellID->454511699,ExpressionUUID->"d7ae2cc5-3fc7-4bb3-89d3-eb8cf5b7ee89"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{"Exp", "[", "x", "]"}], "]"}]}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"Pi", " ", "x"}], "]"}], "-", 
    RowBox[{"3", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"0.1", "I"}]}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"0.1", "I"}]}]}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->233038955,ExpressionUUID->"28226f8c-a3db-436f-8415-8a3f202c3977"],

Cell[BoxData["2"], "SolvedExampleOutput",
 CellID->413675130,ExpressionUUID->"e255b172-579a-42a3-b301-e46870b3a975"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 " can find the solutions:"
}], "SolvedExampleNote",
 CellID->176187509,ExpressionUUID->"c3a2d1b0-ad11-428b-a810-7506c110be6a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"2", 
       RowBox[{"Sin", "[", 
        RowBox[{"Exp", "[", "x", "]"}], "]"}]}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"Pi", " ", "x"}], "]"}], "-", 
      RowBox[{"3", "/", "2"}]}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], ",", "x"}], 
  "]"}]], "SolvedExampleInput",
 CellID->37095152,ExpressionUUID->"79811160-05fd-4881-97b3-e72aa0e92a7d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      InterpretationBox[
       StyleBox[
        TemplateBox[{"\"-0.676\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        ShowStringCharacters -> 
        False], -0.67646667791447834261475691164378076792`15.954589770191003, 
       Editable -> False], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 FractionBox["3", "2"], "+", 
                 RowBox[{"Cos", "[", 
                   RowBox[{"\[Pi]", " ", "#1"}], "]"}], "-", 
                 RowBox[{"2", " ", 
                   RowBox[{"Sin", "[", 
                    SuperscriptBox["\[ExponentialE]", "#1"], "]"}]}]}], "&"}],
              ",", 
             
             RowBox[{"-", 
               "0.67646667791447829009829066540353259551`20.30028611369073"}]}\
], "}"}], "]"}], Short[#, 7]& ], -0.6764666779144783},
     "NumericalApproximation"],
    Root[{
     Rational[3, 2] + Cos[Pi #] - 2 
      Sin[E^#]& , \
-0.67646667791447829009829066540353259551`20.30028611369073}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      InterpretationBox[
       StyleBox[
        TemplateBox[{"\"0.343\"", 
          DynamicBox[
           FEPrivate`FrontEndResource[
           "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
        ShowStringCharacters -> False], 
       0.34285718598548198254860608358285389841`15.954589770191003, Editable -> 
       False], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 FractionBox["3", "2"], "+", 
                 RowBox[{"Cos", "[", 
                   RowBox[{"\[Pi]", " ", "#1"}], "]"}], "-", 
                 RowBox[{"2", " ", 
                   RowBox[{"Sin", "[", 
                    SuperscriptBox["\[ExponentialE]", "#1"], "]"}]}]}], "&"}],
              ",", "0.34285718598548197856246903380411650275`20.\
306182957142376"}], "}"}], "]"}], Short[#, 7]& ], 0.342857185985482},
     "NumericalApproximation"],
    Root[{
     Rational[3, 2] + Cos[Pi #] - 2 Sin[E^#]& , 
      0.34285718598548197856246903380411650275`20.306182957142376}]]}]}]], \
"SolvedExampleOutput",
 CellID->1185466664,ExpressionUUID->"f7c7edc0-0d57-4a8c-a329-64123fb45654"]
}, Open  ]],

Cell["and compute them numerically:", "SolvedExampleNote",
 CellID->26502621,ExpressionUUID->"c8aa3a5b-df20-49b3-85a0-31c9905055e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "SolvedExampleInput",
 CellID->635582712,ExpressionUUID->"b5f1e8f6-9378-4431-ab34-4202ae7e4804"],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "0.6764666779144783`"}]}], "||", 
  RowBox[{"x", "\[Equal]", "0.342857185985482`"}]}]], "SolvedExampleOutput",
 CellID->509408886,ExpressionUUID->"71e98739-bf46-406f-92df-ede8fd152ce4"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1344109701,ExpressionUUID->"96ccf558-b70f-48d2-a2c3-c60d000b8bd8"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"794faf35-3f8c-40c1-a251-e2ff4e983cd4"],

Cell["Cauchy\[CloseCurlyQuote]s argument principle: for a meromorphic \
function,", "SummaryList",
 CellID->324737511,ExpressionUUID->"e34fa353-e934-4352-b5e6-c8af98973442"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[ContourIntegral]", "C"], 
     FractionBox[
      RowBox[{
       RowBox[{"f", "'"}], 
       RowBox[{"(", "z", ")"}]}], 
      RowBox[{"f", "(", "z", ")"}]]}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"number", " ", "of", " ", "zeros"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"number", " ", "of", " ", "poles"}], ")"}]}]}], 
  TraditionalForm]], "DisplayFormula",
 CellID->581311417,ExpressionUUID->"88e79231-8ff1-41ef-a2a4-6974b6941314"],

Cell["\<\
Transcendental equations contain transcendental functions that do not satisfy \
any polynomial equation.\
\>", "SummaryList",
 CellID->50298559,ExpressionUUID->"b639c292-b3ee-42de-a0e2-4ebf39ea9d78"],

Cell["\<\
The argument principle can be used to count the number of solutions of a \
transcendental equation in a certain region.\
\>", "SummaryList",
 CellID->7723285,ExpressionUUID->"5db45a4f-50eb-4a3d-997b-a9117b04070b"],

Cell["\<\
A repeated application of the argument principle can help locate and separate \
the solutions.\
\>", "SummaryList",
 CellID->546896568,ExpressionUUID->"76fb1f9b-59b5-4ba3-857b-2d6c24492eb2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->281555698,ExpressionUUID->"e1cccfdd-9037-4bc0-b64c-b40fad574b92"],

Cell[TextData[{
 "How many zeros does the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", "z"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "z"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"2", "z"}], "-", "1"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"1b159143-767a-49d8-852b-cfa99dcd0a19"],
 " have inside the unit circle?"
}], "Exercise",
 CellID->52608808,ExpressionUUID->"4d2fb3ad-d8f1-49d0-9817-7120a2804fc2"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"de3e3fc8-0704-4625-9125-79bff075b000"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "'"}], 
    RowBox[{
     RowBox[{"(", "z", ")"}], "/", 
     RowBox[{"f", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c9ad7660-b430-47b5-b689-cda743694a8e"],
 ":"
}], "SolutionAnswer",
 CellID->474285869,ExpressionUUID->"06fb453f-7fe6-48e6-941f-594909c87e89"],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "ExerciseInput",
 CellID->359200403,ExpressionUUID->"2a2ea36d-24e5-4361-a7f7-10c03def41be"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", "z"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", "z"}]}], ")"}]}], 
    RowBox[{
     RowBox[{"2", "z"}], "-", "1"}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "z", "]"}], "/", 
   RowBox[{"f", "[", "z", "]"}]}], "//", "Together"}]}], "ExerciseInput",
 CellID->632602631,ExpressionUUID->"2300b3c8-d69d-461f-8d8e-93794751da9f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "7"}], "-", 
   RowBox[{"12", " ", "z"}], "+", 
   RowBox[{"12", " ", 
    SuperscriptBox["z", "2"]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "z"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "z"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"3", " ", "z"}]}], ")"}]}]]], "ExerciseOutput",
 CellID->563568942,ExpressionUUID->"c2fda0b6-664a-45aa-adae-0e2ec99c66b4"]
}, Open  ]],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", 
       RowBox[{
        RowBox[{"|", "z", "|"}], "=", "1"}]], 
      RowBox[{
       RowBox[{"f", "(", "z", ")"}], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
     RowBox[{
      SubscriptBox["\[ContourIntegral]", 
       RowBox[{
        RowBox[{"|", "z", "|"}], "=", "1"}]], 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"-", "7"}], "-", 
         RowBox[{"12", " ", "z"}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["z", "2"]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "z"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "z"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "z"}]}], ")"}]}]], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"a9b0f670-b06f-4180-8df6-84ea78d24dbd"],
 " as a sum over the poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", 
     RowBox[{"\[PlusMinus]", 
      FractionBox["1", "2"]}]}], ",", 
    FractionBox["1", "3"]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "e0a6b647-42a2-4f5b-95f8-11174db787fb"],
 ". Using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->174628978,ExpressionUUID->"33784081-43dd-4299-9b7b-95de3c106c1a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"-", "7"}], "-", 
      RowBox[{"12", " ", "z"}], "+", 
      RowBox[{"12", " ", 
       SuperscriptBox["z", "2"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "z"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "z"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", "z"}]}], ")"}]}]], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", "]"}]}]}], "]"}]}]], "ExerciseInput",
 CellID->459248,ExpressionUUID->"0d6b4843-d40a-4569-989a-22fe59fbe2fb"],

Cell[BoxData["1"], "ExerciseOutput",
 CellID->119946627,ExpressionUUID->"0129bbaa-cd41-4136-b3c0-010c06fe2f5f"]
}, Open  ]],

Cell[TextData[{
 "So the number of zeros is 2, because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"(", 
      RowBox[{"number", " ", "of", " ", "poles", " ", "of", " ", "f"}], 
      ")"}]}], "=", 
    RowBox[{
     RowBox[{"1", "+", "1"}], "=", "2"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"44fb1eef-480b-4ead-9603-965f13c5e0ab"],
 ". Check with ",
 ButtonBox["Solve",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->379512211,ExpressionUUID->"97ac8634-a294-493c-8b2c-ff1c19d99f5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"3", "z"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", "z"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"2", "z"}], "-", "1"}]], "==", "0"}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->204371087,ExpressionUUID->"0b7697a7-3676-4b64-9e4c-957d358c7032"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "3"]}]}], "}"}]}], "}"}]], "ExerciseOutput",
 CellID->12949826,ExpressionUUID->"c88276ef-8b73-4b2e-abe2-2d3eac7549c8"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Count the solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"sin", "(", 
       SuperscriptBox["\[ExponentialE]", "z"], ")"}], "-", 
      RowBox[{"cos", "(", 
       RowBox[{"2", "z"}], ")"}], "-", "1"}], "=", "0"}]}], TraditionalForm]],
   "InlineMath",ExpressionUUID->"f6a89c61-1eaf-48dd-ace1-555cebf8b5b7"],
 " in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", 
     RowBox[{"Re", " ", "z"}], "\[LessEqual]", "1"}], ",", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", 
     RowBox[{"Im", " ", "z"}], "\[LessEqual]", "1"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"da466958-dd48-4389-b88d-0df3a2ad45be"],
 "."
}], "Exercise",
 CellID->220339749,ExpressionUUID->"fe353f17-9fa9-4f73-b81b-9e20bf0961e5"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"e061da7a-bb8e-4b17-90b7-e3e2d5b7793c"],

Cell[TextData[{
 "A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"350e6423-5e03-47ed-88cd-775a00c78cad"],
 " is:"
}], "SolutionAnswer",
 CellID->22126526,ExpressionUUID->"f14258db-0371-4416-a940-e12c3068e6a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"E", "^", "z"}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "z"}], "]"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["504", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {Dashed, 
       RegionBoundary[
        Rectangle[{-1, -1}, {1, 1}]]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "ExerciseInput",
 CellID->576907846,ExpressionUUID->"5a5537fc-7755-4dc2-92d3-afab77f70481"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3mUYh/GDGkyCdUXEalwxDJ9kVNFinWAwKWPt1BlXDEarxTCjIDgX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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxku2VUW+u39n3G+3442913sbobngR3d3d3p0ApUKBQaEspUNpCDUoFKcWt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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oXEUUgB/aBK3SBhuxtRQ7SSdoI1rZxp/CSrANsUorWEUrwSpg5ZRJ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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    Dashing[{Small, Small}], 
    LineBox[{{-1, -1}, {1, -1}, {1, 1}, {-1, 1}, {-1, -1}}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->1882816687,ExpressionUUID->"8f224351-19b2-4612-af84-ba487646c5b2"]
}, Open  ]],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"115c3691-d51b-4088-a08b-887932cfcd59"],
 " is an entire function, you can count the zeros by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
    RowBox[{
     SubscriptBox["\[Integral]", "C"], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"f", "'"}], 
        RowBox[{"(", "z", ")"}]}], 
       RowBox[{"f", "(", "z", ")"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"1ef6bf24-ed07-44ad-84c5-070abb8a037f"],
 ". Using ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->797135153,ExpressionUUID->"e2ad19f1-8c10-48ad-8eac-d8ce2fa3b78f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"E", "^", "z"}], "]"}], "-", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "z"}], "]"}], "-", "1"}], ",", "z"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"E", "^", "z"}], "]"}], "-", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "z"}], "]"}], "-", "1"}], ")"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}], "]"}]}]], "ExerciseInput",\

 CellID->239966307,ExpressionUUID->"3ff417f8-bac3-470c-93e8-3522d8a6e957"],

Cell[BoxData["2"], "ExerciseOutput",
 CellID->468143859,ExpressionUUID->"cf87f320-02c1-4fad-b4c5-b69994c8c41c"]
}, Open  ]],

Cell[TextData[{
 "Or using ",
 ButtonBox["CountRoots",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->189354212,ExpressionUUID->"8a26e10b-7ac5-4cfd-9c2d-3e77c03c27a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CountRoots", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"E", "^", "z"}], "]"}], "-", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "z"}], "]"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "I"}], ",", 
     RowBox[{"1", "+", "I"}]}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->290099589,ExpressionUUID->"426a6c9b-f96e-4ce6-8e96-167807edfe35"],

Cell[BoxData["2"], "ExerciseOutput",
 CellID->188414645,ExpressionUUID->"86174be6-ba6d-464c-ae09-8b091af04c07"]
}, Open  ]],

Cell[TextData[{
 "There are two solutions. With ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->894917706,ExpressionUUID->"0173db78-928c-4d8e-9c60-ab93072147b3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"E", "^", "z"}], "]"}], "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", 
     RowBox[{"Re", "[", "z", "]"}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", 
     RowBox[{"Im", "[", "z", "]"}], "\[LessEqual]", "1"}]}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->433996504,ExpressionUUID->"33173f2d-cbd9-4af3-82d6-b227ff8deb12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.915\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.915226908360288748944810777175007388`16.094808884331805, Editable -> 
         False], "-", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.202\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.20167483871637634229578850408870493993`15.437931822411029, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"1", "+", 
                 RowBox[{"Cos", "[", 
                   RowBox[{"2", " ", "#1"}], "]"}], "-", 
                 RowBox[{"Sin", "[", 
                   SuperscriptBox["\[ExponentialE]", "#1"], "]"}]}], "&"}], 
             ",", 
             RowBox[{"0.91522690836028880198669899299899519209`18.", "-", 
               
               RowBox[{
                "0.20167483871637634359039414024793484173`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[0.9152269083602887, -0.20167483871637634`]},
     "NumericalApproximation"],
    Root[{1 + Cos[2 #] - Sin[E^#]& , 
      Complex[
      0.91522690836028880198669899299899519209`18., \
-0.20167483871637634359039414024793484173`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.915\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.915226908360288748944810777175007388`16.094808884331805, Editable -> 
         False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.202\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.20167483871637634229578850408870493993`15.437931822411029, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"1", "+", 
                 RowBox[{"Cos", "[", 
                   RowBox[{"2", " ", "#1"}], "]"}], "-", 
                 RowBox[{"Sin", "[", 
                   SuperscriptBox["\[ExponentialE]", "#1"], "]"}]}], "&"}], 
             ",", 
             RowBox[{"0.91522690836028880198669899299899519209`18.", "+", 
               
               RowBox[{
                "0.20167483871637634359039414024793484173`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[0.9152269083602887, 0.20167483871637634`]},
     "NumericalApproximation"],
    Root[{1 + Cos[2 #] - Sin[E^#]& , 
      Complex[
      0.91522690836028880198669899299899519209`18., 
       0.20167483871637634359039414024793484173`18.]}]]}]}]], "ExerciseOutput",\

 CellID->1804811268,ExpressionUUID->"22465e50-d2ca-4e87-99e6-f2564b6b41a8"]
}, Open  ]],

Cell["Numerically, they are:", "SolutionAnswer",
 CellID->403349005,ExpressionUUID->"570f6aaa-6d80-408d-96c6-e1c82ab275f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "ExerciseInput",
 CellID->300871297,ExpressionUUID->"3c54c8f8-a353-4aac-ab6b-700c4261e935"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   RowBox[{"0.9152269083602887`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.20167483871637634`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"0.9152269083602887`", "\[VeryThinSpace]", "+", 
    RowBox[{
    "0.20167483871637634`", " ", "\[ImaginaryI]"}]}]}]}]], "ExerciseOutput",
 CellID->126369278,ExpressionUUID->"d38edead-2017-42d9-a9e4-24bf71708a90"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Count the solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"log", "(", 
       FractionBox[
        RowBox[{"2", "+", "z"}], 
        RowBox[{"3", "+", "z"}]], ")"}], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", "z"}]], "+", "1"}], "=", "0"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"e62997da-ab21-40f9-a1a9-b9a1e67f13ec"],
 " in the unit disk."
}], "Exercise",
 CellID->434250205,ExpressionUUID->"6a854982-7868-4a98-bc79-64703292e13d"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"b65115ee-0f9e-451c-a2bf-1dc6bb620b00"],

Cell[TextData[{
 "A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"3b5680a6-5a04-4b86-9112-5418f261d100"],
 " is:"
}], "SolutionAnswer",
 CellID->31170415,ExpressionUUID->"519578f8-dbde-48c0-babc-c5f15de356ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "z"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"z", "+", "3"}], ")"}]}], "]"}], "-", 
    RowBox[{"Exp", "[", 
     RowBox[{"3", "z"}], "]"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}]}]}], "]"}]], "ExerciseInput",
 CellID->407384613,ExpressionUUID->"4365fa3f-4627-4e74-8cdd-0442cf9ad5f8"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o3lUcx/GLGiyK1hWv2MRgWPCG4UlGFS3WKQaTMmwrBo0rCkZBi8Uw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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJykvHdQVPm6hnvq3j/OjI55ZnR0iIoBc0IBySKKGRUDKiYMmHPOOYGiKCaC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           "], {{0, 144.}, {144., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {144., 144.}, PlotRange -> {{0, 144.}, {0, 144.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNmmd4VtUShXO+Ix0p0nsn9N57DQZCCxBKCITQe+8llNA7SO+gIIKAFCnS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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0UcyhGEQBuCfkc3I2QxlK1xA2As7K2FngRFmxAlyKi4g7BUXEC7ABYQL
cAHhAnimyuKp7sVbX3X31zGVHE3kBUGQJp9c384Ak2S54J5XvqkU6mGEOCdc
cxwKgkf1nV9iHuxjnDRn3PLMJxH5LoaYYZY4c8yzwCIJkiyxzAqrrLFOijQZ
smywyRbb7LDLHvsccMgR0wzSSZgPcz1xwykpxuglyo+93riUfVCvcnszyzDd
VPDlTi/ccU6GCfppI0aUVlpopolGGqinjlpqqKYqd3sqiBCmnDJKKaGYIgop
IPT/r3/VqS8e
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHUUUgB/aBK3SBhuxtRQ7sRO0Ea1s409hJdgGrWwFq2glaBOwcsqk
myAWGxCGwCCLhIkm/q7Ls7L1vYvfWc5376YZvtx79715HzNz5pxzn337gzff
e+Ls7OzrJ8/OLkf/++LGteu3b331cuYS/O7tW1dv3rij12vwx5d49Xu9fwp+
7a31/U8e/6DPt+Cn77306bc/3dfzevA/F5/+8pUf9fw5uF85PCD41cPPexD8
4P7lG0bw54ef/zD4jeee//eFuz8HP3V43C/B3334+sU7HgV/dPj9fg1+8e7l
G34LPj/8vr8Hf3Px2167/kfwO4ff/8/gZy4fd/MvzWcJ/uzij3Pl3t+a3xr8
/08Vb15PjyUYv/n1Gozf/P4pGL/58y0Yv/l5PRi/+flzMH5h/ML4hfEL4xfG
L4xfGL8wfmH8wviF8QvjN89nCcZvnt8ajN+9dXra6zZmv/x/Dc5+i/wW+eXz
LTj7LfJb5LfIb5HfIr9Ffov8Fvkt8lvkt8hvkd8iv0V+i/wW+S3yW+S3yG+R
3+N99/Q63bx6xC+M3/y+KRi/+fMtGL/5eT0Yv/n5czB+YfzC+IXxC+MXxi+M
Xxi/MH5h/ML4hfEL4zfPZwnGb57fGozfvXP09L5bjjzm17cxr98afuG8fmv4
hfP6rVq/Veu3hl84r9+q9Vu1fqvWb9X6rVq/Veu3av1Wrd+q9Vu1fqvWb9X6
rVq/Veu3av1Wrd/juOj0OVqO1qU9wh7xC+M3f74F4zc/pwfjNz9/DsYvjF8Y
vzB+YfzC+IXxC+MXxi+MXxi/MH5h/Ob5LMH4zfNbg/G7F+eejou2c9T7rtep
vXrM+/MUfuG8P0/hF8778xR+4bw/T9qfJ+3Pk/bnSfvzpP150v48aX+etD9P
2p8n7c+T9udJ+/Ok/XnS/jxpf560Px/fW07HueXo3PQ+63Vpj7BH/ML4zc/r
wfjNz5+D8QvjF8YvjF8YvzB+YfzC+IXxC+MXxi+MXxi/eT5LMH7z/NZg/O7d
Q0/fW4rW2R29Xo/2Wa9Le8yf38Z8/rbwC+fzt4VfOJ+/Tedv0/nbdP42nb9N
52/T+dt0/jadv03nb9P523T+Np2/Tedv0/nbdP42nb/HeQX8+p7iuNZxkM9N
77Nel/YIe8QvjN/8/DkYvzB+YfzC+IXxC+MXxi+MXxi/MH5h/ML4hfGb57ME
4zfPbw3G716eKMdX273T9xTHtY6DfG56n/W6tMf8vG3M8VUPv3COr7riq674
qiu+6oqvuuKrrviqK77qiq+64quu+KorvuqKr7riq674qiu+6oqvjvN++HUe
wfdO31Mc1zoO8rnpfdbr0h5hj/iF8QvjF8YvjF8YvzB+YfzC+IXxC+MXxi+M
Xxi/eT5LMH7z/NZg/O7lcXP8vOWFnEfwvdP3FMe1joN8bnqf9bq0x/z8bczx
86z4eVb8PCt+nhU/z4qfZ8XPs+LnWfHzrPh5Vvw8K36eFT/Pip9nxc+z4udZ
8fNxXh6/zvM5L+Q8gu+dvqc4rnUc5HPT+6zXpT3CHvEL4xfGL4xfGL8wfmH8
wviF8QvjF8YvjN88jyUYv3l+azB+9+os+HXe1nk+54WcR/C90/cUx7WOg3xu
ep/1urRH2CN+YfzC+IXxC+MXxi+MXxi/MH5h/ML4zfNZgvGb57UG43evboZf
5+Gdt3Wez3kh5xF87/Q9xXGt4yCfm95nvS7tEfaIXxi/MH5h/ML4hfEL4xfG
L4xfGL95PkswfvP81mD87tVB8eu6ivPwzts6z+e8kPMIvnf6nuK41nGQz03v
s16X9gh7xC+MXxi/MH5h/ML4hfEL4xfGb57PEozfPL81GL97dW38uk7muorz
8M7bOs/nvJDzCL53+p7iuNZxkM9N77Nel/YIe8QvjF8YvzB+YfzC+IXxC+M3
z2cJxm+e3xqM370+Bfy67uk6mesqzsM7b+s8n/NCziP43ul7iuNax0E+N73P
el3aI+wRvzB+YfzC+IXxC+MXxm+ezxKM3zy/NRi/e30n+HUd23VP18lcV3Ee
3nlb5/mcF3IewfdO31Mc1zoO8rnpfdbr0h5hj/iF8QvjF8YvjF8Yv3k+SzB+
8/zWYPzu9RHh130JrmO77uk6mesqzsM7b+s8n/NCziP43ul7iuNax0E+N73P
el3aI+wRvzB+YfzC+IXxm+ezBOM3z28Nxu9eXxh+3WfivgTXsV33dJ3MdRXn
4Z23dZ7PeSHnEXzv9D3Fca3jIJ+b3me9Lu0R9ohfGL8wfmH85vkswfjN81uD
8bvX54df9w25z8R9Ca5ju+7pOpnrKs7DO2/rPJ/zQs4j+N7pe4rjWsdBPje9
z3pd2iPsEb8wfmH85vkswfjN81uD8bvXt4lf94G5b8h9Ju5LcB3bdU/XyVxX
cR7eeVvn+ZwXch7B907fUxzXOg7yuel91uvSHmGP+IXxm+ezBOM3z28Nxu9e
Hy5+3dfnPjD3DbnPxH0JrmO77uk6mesqzsM7b+s8n/NCziP43ul7iuNax0E+
N73Pel3aI+wRv3k+SzB+8/zWYPzu9VXj132a7utzH5j7htxn4r4E17Fd93Sd
zHUV5+Gdt3Wez3kh5xF87/Q9xXGt4yCfm95nvS7tEfaIXxi/eX5rMH73+uRz
fWHru3Wfpvv63AfmviH3mbgvwXVs1z1dJ3NdxXl4522d53NeyHkE3zt9T3Fc
6zjI56b3Wa9Le8zz2cZcX1jCb/6ew7l4+94Dft1H7b5b92m6r899YO4bcp+J
+xJcx3bd03Uy11Wch3fe1nk+54WcR/C90/cUx7WOg3xuep/1urRH2CN+8/dW
zsXb91hy/Wjri3cftftu3afpvj73gblvyH0m7ktwHdt1T9fJXFdxHt55W+f5
nBdyHsH3Tt9THNc6DvK56X3W69Ie8/y2Eb9730vCb+btew/4za9vfdXuw3Xf
pvv83BfmPiL3nbhPwXVt10FdN3OdxXl553Gd93OeyHkF30N9b3Gc67jI56j3
Xa9Te/WYfQ75HvI75HfI75DfIb9Dfof8Dvkd8jvkd8jvkN8hv0N+h/wO+R3y
O+R3yO+Q3yG/Q36H/A75HfI75Je/5yp/58H/AYFFcG0=
     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Epilog->{
    Dashing[{Small, Small}], 
    CircleBox[{0, 0}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->703295164,ExpressionUUID->"03ca4853-130c-46b4-a706-5cbef7d3c13d"]
}, Open  ]],

Cell[TextData[{
 "There are no singularities inside the disk. With ",
 ButtonBox["ContourIntegrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->417340199,ExpressionUUID->"5275a77f-83f4-4295-bf6c-310b929fefa4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
   RowBox[{"NContourIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "+", "z"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"z", "+", "3"}], ")"}]}], "]"}], "-", 
         RowBox[{"Exp", "[", 
          RowBox[{"3", "z"}], "]"}], "+", "1"}], ",", "z"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", "z"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"z", "+", "3"}], ")"}]}], "]"}], "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"3", "z"}], "]"}], "+", "1"}], ")"}]}], ",", 
     RowBox[{"z", "\[Element]", 
      RowBox[{"Circle", "[", "]"}]}]}], "]"}]}], "//", 
  "Chop"}]], "ExerciseInput",
 CellID->655873104,ExpressionUUID->"9dbda6f2-7ad8-47c6-bf02-33ee34307e06"],

Cell[BoxData["0.9999999999998304`"], "ExerciseOutput",
 CellID->689803889,ExpressionUUID->"2ef8ff41-fc11-495d-8548-2fdfb9450f01"]
}, Open  ]],

Cell["There is one solution:", "SolutionAnswer",
 CellID->35043307,ExpressionUUID->"32ff5e19-291d-4f6c-b4b4-c27a2e9a115f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", "+", "z"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"z", "+", "3"}], ")"}]}], "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"3", "z"}], "]"}], "+", "1"}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->203307917,ExpressionUUID->"808d002f-da48-4922-9416-d861b8286965"],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", 
  InterpretationBox[
   TemplateBox[{"Root", 
     InterpretationBox[
      StyleBox[
       TemplateBox[{"\"-0.194\"", 
         DynamicBox[
          FEPrivate`FrontEndResource[
          "FEExpressions", "NumericalApproximationElider"]]}, "RowDefault"], 
       ShowStringCharacters -> 
       False], -0.19361163743741913179086111540527781472`15.954589770191003, 
      Editable -> False], 
     TagBox[
      RowBox[{"Root", "[", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{"1", "-", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"3", " ", "#1"}]], "+", 
                RowBox[{"Log", "[", 
                  FractionBox[
                   RowBox[{"2", "+", "#1"}], 
                   RowBox[{"3", "+", "#1"}]], "]"}]}], "&"}], ",", 
            
            RowBox[{"-", 
              "0.1936116374374191200647746617983587694661321902380981079716`\
30.102999566398122"}]}], "}"}], "]"}], Short[#, 7]& ], -0.19361163743741913`},
    
    "NumericalApproximation"],
   Root[{1 - E^(3 #) + 
     Log[(2 + #)/(
       3 + #)]& , \
-0.1936116374374191200647746617983587694661321902380981079716`30.\
102999566398122}]]}]], "ExerciseOutput",
 CellID->1050619072,ExpressionUUID->"211bc9e8-6e8c-4462-b077-376d975cd85f"]
}, Open  ]],

Cell["which numerically is:", "SolutionAnswer",
 CellID->192581690,ExpressionUUID->"dedcc926-7010-46fe-8839-0a3534584589"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "ExerciseInput",
 CellID->65799174,ExpressionUUID->"b6af0a22-91d9-42ff-b144-d1c398526728"],

Cell[BoxData[
 RowBox[{"z", "\[Equal]", 
  RowBox[{"-", "0.19361163743741913`"}]}]], "ExerciseOutput",
 CellID->631106977,ExpressionUUID->"1e0e50fd-e1f3-4d3e-8451-0e8644469a1c"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Count the number of solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"sin", " ", "z"}]], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"sin", "(", "z", ")"}]}], "-", "2"}], "=", "0"}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "2092f482-b14b-46e3-a491-166047a0d5ca"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "3"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "0684f949-d5d0-4c03-8663-3c18b7bd793d"],
 "."
}], "Exercise",
 CellID->169181395,ExpressionUUID->"b873f7e5-87dc-4060-9dce-b8c7867d4e7a"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"f2d0a117-9966-475f-8335-651629ed1dbf"],

Cell[TextData[{
 "A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"47d52d0d-43e2-4611-bcb8-acae63413525"],
 " is:"
}], "SolutionAnswer",
 CellID->150361944,ExpressionUUID->"5e534c2e-2135-46ca-8d8b-1fcb5e85a3a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Sin", "[", "z", "]"}], "]"}], "-", 
    RowBox[{"I", " ", 
     RowBox[{"Sin", "[", "z", "]"}]}], "-", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}]}], "}"}]}], ",", 
   RowBox[{"ImageSize", "->", "Small"}]}], "]"}]], "ExerciseInput",
 CellID->35281073,ExpressionUUID->"74bb4b5d-2f0a-4f21-8969-ef5593c2d312"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o2FUYh/HrH3CIoBPTTcqaiBjEJpqsA9OK4QoGkzJMWgw3CauLq9YV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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJyVnQdUlGf69v/n+86Jxq5JTGJmsLdYQGlDszfsUuy999672HvX2EvsDXtX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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHkUYRj+0CWiTNoUgtpaCldhZiCCkso0YwUqwDahFWgubIBaCVcDK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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    Dashing[{Small, Small}], 
    CircleBox[{0, 0}, 3]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->1165267393,ExpressionUUID->"efe53baa-9e07-41cb-96f8-efd337b4faec"]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cf49dd19-fbfd-494c-b8ce-7b1686d5da58"],
 " has no poles in the disk, so:"
}], "SolutionAnswer",
 CellID->663386301,ExpressionUUID->"7e483181-98ac-4301-ba31-179a8f21f5cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
   RowBox[{"NContourIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"Sin", "[", "z", "]"}], "]"}], "-", 
         RowBox[{"I", " ", 
          RowBox[{"Sin", "[", "z", "]"}]}], "-", "2"}], ",", "z"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"Sin", "[", "z", "]"}], "]"}], "-", 
        RowBox[{"I", " ", 
         RowBox[{"Sin", "[", "z", "]"}]}], "-", "2"}], ")"}]}], ",", 
     RowBox[{"z", "\[Element]", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}]}]}], "]"}]}], "//",
   "Chop"}]], "ExerciseInput",
 CellID->249678652,ExpressionUUID->"b429ceea-3fc9-40ff-89b4-ed3168a5c416"],

Cell[BoxData["5.0000000000047145`"], "ExerciseOutput",
 CellID->169275109,ExpressionUUID->"e5676a18-52ea-42dc-a887-314ff9cacf51"]
}, Open  ]],

Cell["There are five solutions:", "SolutionAnswer",
 CellID->247041628,ExpressionUUID->"1ca0e7b4-969b-4fa7-b579-1005ef921719"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"Sin", "[", "z", "]"}], "]"}], "-", 
      RowBox[{"I", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "-", "2"}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "<", "3"}]}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->98044949,ExpressionUUID->"beba3146-4371-4a30-99af-1c2f4d09c8a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.0227\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.02265362024117938827272311641536362004`14.194996561468164, 
         Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"1.84\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           1.84167490229196251227961056429194286466`16.105071915346674, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"Sin", "[", "#1", "]"}]], "-", 
                 RowBox[{"\[ImaginaryI]", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}]}], "&"}], ",", 
             RowBox[{"0.02265362024117938869305645663295545004`18.", "+", 
               
               RowBox[{
                "1.84167490229196241653197178309569282675`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[0.02265362024117939, 1.8416749022919625`]},
     "NumericalApproximation"],
    Root[{-2 + E^Sin[#] + Complex[0, -1] Sin[#]& , 
      Complex[
      0.02265362024117938869305645663295545004`18., 
       1.84167490229196241653197178309569282675`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.215\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.21451762197818038946373064845829503611`14.968085288431183, 
         Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"2.93\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           2.93308071392747660155464473064057528973`16.10394632872774, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"Sin", "[", "#1", "]"}]], "-", 
                 RowBox[{"\[ImaginaryI]", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}]}], "&"}], ",", 
             RowBox[{"0.21451762197818040182111071168570009139`20.", "+", 
               
               RowBox[{
                "2.93308071392747676620255701332669836339`20.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[0.2145176219781804, 2.9330807139274766`]},
     "NumericalApproximation"],
    Root[{-2 + E^Sin[#] + Complex[0, -1] Sin[#]& , 
      Complex[
      0.21451762197818040182111071168570009139`20., 
       2.93308071392747676620255701332669836339`20.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.334\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.33398104286231483639468820001638960093`15.218249021852822, 
         Editable -> False], "-", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"2.55\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           2.55205554173200033218904536624904721975`16.101417327314454, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"Sin", "[", "#1", "]"}]], "-", 
                 RowBox[{"\[ImaginaryI]", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}]}], "&"}], ",", 
             RowBox[{"0.33398104286231483286545827064344890278`18.", "-", 
               
               RowBox[{
                "2.55205554173200031608825109850797690943`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[0.33398104286231484`, -2.5520555417320003`]},
     "NumericalApproximation"],
    Root[{-2 + E^Sin[#] + Complex[0, -1] Sin[#]& , 
      Complex[
      0.33398104286231483286545827064344890278`18., \
-2.55205554173200031608825109850797690943`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.559\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.55921239685250689888107444858178496361`16.023466436674894, 
         Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.378\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.37778369854435212005228095222264528275`15.853132860291076, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"Sin", "[", "#1", "]"}]], "-", 
                 RowBox[{"\[ImaginaryI]", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}]}], "&"}], ",", 
             RowBox[{"0.55921239685250691451854895035495431267`18.", "+", 
               
               RowBox[{
                "0.37778369854435211426414427524966480259`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[0.5592123968525069, 0.3777836985443521]},
     "NumericalApproximation"],
    Root[{-2 + E^Sin[#] + Complex[0, -1] Sin[#]& , 
      Complex[
      0.55921239685250691451854895035495431267`18., 
       0.37778369854435211426414427524966480259`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"2.58\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         2.58238025673728621711688901996240019798`16.10050650320269, Editable -> 
         False], "-", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.378\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.37778369854435212005228095222264528275`15.265729524572581, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 SuperscriptBox["\[ExponentialE]", 
                  RowBox[{"Sin", "[", "#1", "]"}]], "-", 
                 RowBox[{"\[ImaginaryI]", " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}]}], "&"}], ",", 
             RowBox[{"2.58238025673728632394409443292455637125`18.", "-", 
               
               RowBox[{
                "0.3777836985443521142641442752496571536`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[2.582380256737286, -0.3777836985443521]},
     "NumericalApproximation"],
    Root[{-2 + E^Sin[#] + Complex[0, -1] Sin[#]& , 
      Complex[
      2.58238025673728632394409443292455637125`18., \
-0.3777836985443521142641442752496571536`18.]}]]}]}]], "ExerciseOutput",
 CellID->1312778166,ExpressionUUID->"e7df07bc-e511-4c8a-900f-7cf13a6fbfe6"]
}, Open  ]],

Cell["Numerically, they are:", "SolutionAnswer",
 CellID->95988000,ExpressionUUID->"ccc9afd8-41b9-46d7-9741-ceaa0211d6f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "ExerciseInput",
 CellID->159310607,ExpressionUUID->"df80204c-247b-4209-84ff-9475ecbabd45"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   RowBox[{"0.02265362024117939`", "\[VeryThinSpace]", "+", 
    RowBox[{"1.8416749022919625`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"0.2145176219781804`", "\[VeryThinSpace]", "+", 
    RowBox[{"2.9330807139274766`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"0.33398104286231484`", "\[VeryThinSpace]", "-", 
    RowBox[{"2.5520555417320003`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"0.5592123968525069`", "\[VeryThinSpace]", "+", 
    RowBox[{"0.3777836985443521`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"2.582380256737286`", "\[VeryThinSpace]", "-", 
    RowBox[{
    "0.3777836985443521`", " ", "\[ImaginaryI]"}]}]}]}]], "ExerciseOutput",
 CellID->326579460,ExpressionUUID->"bea1252f-defe-428b-a12f-c6fee9ac2df9"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Count the solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "z"], "-", 
      RowBox[{"2", "z"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], "sin", " ", "z"}]}], "=", 
     "0"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "068bf09a-c41c-4b5a-9cb6-27c46722eb24"],
 " in the region ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", "z", "|", 
    RowBox[{"<", "4"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "199084d0-addb-4448-84b6-24a749d6e198"],
 "."
}], "Exercise",
 CellID->716152413,ExpressionUUID->"24962966-1ad6-443c-ac89-63973064ed39"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"480af5dd-6d47-4c43-b3e0-b9aa93a76dea"],

Cell[TextData[{
 "A plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"926eb8f9-1cd7-4e58-b19f-5166b0f72585"],
 " is:"
}], "SolutionAnswer",
 CellID->276668645,ExpressionUUID->"01d252d4-55df-4997-b5d0-84cde469bed9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "z", "]"}], "-", 
    RowBox[{"2", "z"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "I"}], ")"}], 
     RowBox[{"Sin", "[", "z", "]"}]}], "-", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "5"}], "}"}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["776", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[Epilog -> {
       Style[
        RGBColor[
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[1, 3]], LightDarkAutoColorRules -> {}], Dashed, 
       Circle[{0, 0}, 4]}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "ExerciseInput",
 CellID->44273721,ExpressionUUID->"7466e005-2018-4bba-8b1e-ae88513f8a90"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o2FUYh/HrH3CIoBPTTcqaiBjEJpqsA9OK4QoGkzJMWgw3CauLq9YV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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxMu3dUVPue9tlr5p9535nuvt09997uvunkoMdzjh5zIkqUJEEBASMmzIoi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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHkUYRj+0CWiTNoUgtpaCldhZiCCkso0YwUqwDahFWgubIBaCVcDK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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    StyleBox[
     RGBColor[
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333], 
      NCache[
       Rational[1, 3], 0.3333333333333333]], {LightDarkAutoColorRules -> {}}, 
     StripOnInput -> False], 
    Dashing[{Small, Small}], 
    CircleBox[{0, 0}, 4]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "ExerciseOutput",
 CellID->249476504,ExpressionUUID->"503d7d07-6c79-40a7-b32e-455f926a6d27"]
}, Open  ]],

Cell["The number of solutions is:", "SolutionAnswer",
 CellID->219861147,ExpressionUUID->"25d619e1-d56d-4bba-9e1c-c998b351a5a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}]], 
  RowBox[{"ContourIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", "z", "]"}], "-", 
        RowBox[{"2", "z"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "I"}], ")"}], 
         RowBox[{"Sin", "[", "z", "]"}]}], "-", "3"}], ",", "z"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", "z", "]"}], "-", 
       RowBox[{"2", "z"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "I"}], ")"}], 
        RowBox[{"Sin", "[", "z", "]"}]}], "-", "3"}], ")"}]}], ",", 
    RowBox[{"z", "\[Element]", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}]}]}], 
   "]"}]}]], "ExerciseInput",
 CellID->95776148,ExpressionUUID->"e3e148c4-b5f9-40a8-b4ca-1d62f1c47146"],

Cell[BoxData["3"], "ExerciseOutput",
 CellID->743035975,ExpressionUUID->"977fda43-7895-4fe0-bb78-2ca817446419"]
}, Open  ]],

Cell[TextData[{
 "With ",
 ButtonBox["Reduce",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->14811347,ExpressionUUID->"ef4d7b26-5d17-47b7-96bd-707b723f71bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "z", "]"}], "-", 
      RowBox[{"2", "z"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "I"}], ")"}], 
       RowBox[{"Sin", "[", "z", "]"}]}], "-", "3"}], "==", "0"}], "&&", 
    RowBox[{
     RowBox[{"Abs", "[", "z", "]"}], "<", "4"}]}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->164523961,ExpressionUUID->"5676a25b-d8fd-43d2-889b-2a781a433410"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-3.02\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -3.02497155035245679499666948686353862286`16.02904513199855,
          Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"1.96\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           1.95911529124562733272796322125941514969`15.840383831881214, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"3", "-", 
                 SuperscriptBox["\[ExponentialE]", "#1"], "+", 
                 RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}], "+", 
                 RowBox[{"2", " ", "#1"}]}], "&"}], ",", 
             RowBox[{
               RowBox[{"-", "3.02497155035245697435737213824188051393`18."}], 
               "+", 
               
               RowBox[{
                "1.9591152912456273805667539291084994281`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[-3.024971550352457, 1.9591152912456273`]},
     "NumericalApproximation"],
    Root[{3 - E^# + Complex[1, 1] Sin[#] + 2 #& , 
      Complex[-3.02497155035245697435737213824188051393`18., 
       1.9591152912456273805667539291084994281`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-0.792\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -0.79198201623609798538439008552813902497`16.07019135019589,
          Editable -> False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.331\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.33076907425455337463660043795243836939`15.691000927915942, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"3", "-", 
                 SuperscriptBox["\[ExponentialE]", "#1"], "+", 
                 RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}], "+", 
                 RowBox[{"2", " ", "#1"}]}], "&"}], ",", 
             RowBox[{
               RowBox[{"-", "0.79198201623609799065361513885385201258`18."}], 
               "+", 
               
               RowBox[{
                "0.33076907425455339932533679683091718872`18.", " ", 
                 "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[-0.791982016236098, 0.3307690742545534]},
     "NumericalApproximation"],
    Root[{3 - E^# + Complex[1, 1] Sin[#] + 2 #& , 
      Complex[-0.79198201623609799065361513885385201258`18., 
       0.33076907425455339932533679683091718872`18.]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   InterpretationBox[
    TemplateBox[{"Root", 
      RowBox[{
        InterpretationBox[
         StyleBox[
          TemplateBox[{"\"2.11\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         2.10584253952900990469743192079477012157`16.10428607685036, Editable -> 
         False], "+", 
        RowBox[{
          InterpretationBox[
           StyleBox[
            TemplateBox[{"\"0.129\"", 
              DynamicBox[
               FEPrivate`FrontEndResource[
               "FEExpressions", "NumericalApproximationElider"]]}, 
             "RowDefault"], ShowStringCharacters -> False], 
           0.12942502714458542500963744714681524783`14.892878447090848, 
           Editable -> False], " ", "\[ImaginaryI]"}]}], 
      TagBox[
       RowBox[{"Root", "[", 
         RowBox[{"{", 
           RowBox[{
             RowBox[{
               RowBox[{"3", "-", 
                 SuperscriptBox["\[ExponentialE]", "#1"], "+", 
                 RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
                   RowBox[{"Sin", "[", "#1", "]"}]}], "+", 
                 RowBox[{"2", " ", "#1"}]}], "&"}], ",", 
             
             RowBox[{"2.10584253952900968328758293472259416329`15.\
149696306659358", "+", 
               
               RowBox[{
                "0.12942502714458543504437799209845019547`13.938288676899845",
                  " ", "\[ImaginaryI]"}]}]}], "}"}], "]"}], Short[#, 7]& ], 
      Complex[2.10584253952901, 0.12942502714458543`]},
     "NumericalApproximation"],
    Root[{3 - E^# + Complex[1, 1] Sin[#] + 2 #& , 
      Complex[
      2.10584253952900968328758293472259416329`15.149696306659358, 
       0.12942502714458543504437799209845019547`13.938288676899845]}]]}]}]], \
"ExerciseOutput",
 CellID->1831782355,ExpressionUUID->"6ff9980c-7962-4093-8b41-8716fc310cf9"]
}, Open  ]],

Cell["Numerically the solutions are:", "SolutionAnswer",
 CellID->312309081,ExpressionUUID->"a0cd2cea-8e94-461c-a737-edb05a9bcd12"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "ExerciseInput",
 CellID->61073247,ExpressionUUID->"a0ed6664-18af-4706-a2ef-71d6a9034235"],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "3.024971550352457`"}], "+", 
    RowBox[{"1.9591152912456273`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "0.791982016236098`"}], "+", 
    RowBox[{"0.3307690742545534`", " ", "\[ImaginaryI]"}]}]}], "||", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"2.10584253952901`", "\[VeryThinSpace]", "+", 
    RowBox[{
    "0.12942502714458543`", " ", "\[ImaginaryI]"}]}]}]}]], "ExerciseOutput",
 CellID->43890839,ExpressionUUID->"b738a2a8-8afc-48c0-9b98-b64d1b2ee1d5"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1143784180,ExpressionUUID->"8d0d801c-0711-46dc-ba95-4ca24e78213c"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"25. Transcendental Equations | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "24. The Residue Theorem"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "26. Definite Integrals"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"9acecd53-f289-4210-a368-4b25ef194609"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[651, 23, 231, 7, 108, "Section",ExpressionUUID->"1d30f8e2-1d92-4650-a4be-6ac3a6f853fe",
 CounterAssignments->{{"Section", 24}},
 CellID->503192056],
Cell[885, 32, 258, 5, 60, "Text",ExpressionUUID->"ce90ce5c-c481-4805-a470-3e5f28bd03b0",
 CellID->86193101],
Cell[CellGroupData[{
Cell[1168, 41, 141, 1, 56, "Subsection",ExpressionUUID->"87e1cab5-bbee-46e8-8027-b17ca6a9e07b",
 CellID->125003476],
Cell[1312, 44, 238, 4, 60, "Text",ExpressionUUID->"66f0e943-255d-4d8a-a060-573334deb387",
 CellID->199936453],
Cell[1553, 50, 586, 17, 36, "Text",ExpressionUUID->"edc8971a-2381-4f60-84a4-a531c6cca3f6",
 CellID->728516933],
Cell[2142, 69, 409, 13, 32, "DisplayFormulaNumbered",ExpressionUUID->"b611ad03-c3a6-4646-858b-dd3a808c3794",
 CellID->563940578],
Cell[2554, 84, 883, 28, 36, "Text",ExpressionUUID->"75c078d8-e98e-41ad-a6db-dea285c4e338",
 CellID->191574415],
Cell[3440, 114, 677, 23, 32, "DisplayFormulaNumbered",ExpressionUUID->"884931d8-a843-47e3-9631-289cdb8ab597",
 CellID->795815110],
Cell[4120, 139, 94, 1, 36, "Text",ExpressionUUID->"55158178-76fe-49c9-a988-a032084758e7",
 CellID->590058920],
Cell[4217, 142, 563, 19, 51, "DisplayFormulaNumbered",ExpressionUUID->"6c722e69-ad8e-42e0-bebe-2a70a0079c2a",
 CellID->273795272],
Cell[4783, 163, 584, 17, 36, "Text",ExpressionUUID->"60055357-6dc0-4c99-85fb-b4b7371a7dc4",
 CellID->153673324],
Cell[5370, 182, 437, 14, 52, "DisplayFormulaNumbered",ExpressionUUID->"229fa12f-3828-4f98-9abd-1f06fa27e9bb",
 CellID->189032853],
Cell[5810, 198, 906, 28, 36, "Text",ExpressionUUID->"ee2a67c1-61f9-45b7-bc8c-82231a077116",
 CellID->358163300],
Cell[6719, 228, 749, 26, 32, "DisplayFormulaNumbered",ExpressionUUID->"3800d7d9-153b-4924-a6ee-7b673bdb2f7a",
 CellID->150991126],
Cell[7471, 256, 93, 1, 36, "Text",ExpressionUUID->"53369f83-18f3-4e2d-985a-06daadbd391c",
 CellID->113020044],
Cell[7567, 259, 585, 20, 51, "DisplayFormulaNumbered",ExpressionUUID->"3355c477-f781-416c-bfd2-0ba0bea771ec",
 CellID->45788077],
Cell[8155, 281, 1102, 30, 66, "Text",ExpressionUUID->"be2d55fc-a51c-43bd-8958-88739af63062",
 CellID->9189946],
Cell[9260, 313, 562, 15, 36, "Text",ExpressionUUID->"5508da96-0db3-4cff-9aa2-2b26224a228e",
 CellID->290643162],
Cell[9825, 330, 734, 22, 51, "DisplayFormulaNumbered",ExpressionUUID->"56e38a47-7d0c-4150-808b-57ef8d5be6bf",
 CellID->248639685],
Cell[10562, 354, 524, 11, 60, "Text",ExpressionUUID->"ebc2b64a-d41d-4f24-8f41-0a365d14e65c",
 CellID->379765406],
Cell[11089, 367, 185, 8, 71, "SolvedExample",ExpressionUUID->"78213f64-707d-4358-83d3-b0a75b05a8a6",
 CellID->5200906],
Cell[11277, 377, 689, 20, 61, "SolvedExampleNote",ExpressionUUID->"14e6d67b-0b2b-4154-a2e0-108c1c461288",
 CellID->165054837],
Cell[11969, 399, 133, 1, 39, "SolvedExampleNote",ExpressionUUID->"4b7946ac-1e24-41bf-ba32-8158596dc12b",
 CellID->423914371],
Cell[CellGroupData[{
Cell[12127, 404, 737, 22, 68, "SolvedExampleInput",ExpressionUUID->"b8849204-e28c-4f4b-8192-724e4ccd8f01",
 CellID->386631553],
Cell[12867, 428, 114, 1, 36, "SolvedExampleOutput",ExpressionUUID->"92ac7f71-eeef-4ec6-9a51-041fc8200e26",
 CellID->7702639]
}, Open  ]],
Cell[12996, 432, 852, 24, 68, "SolvedExampleNote",ExpressionUUID->"5242ca5c-d6f3-4c6d-bc73-0eaef4745bca",
 CellID->284884536],
Cell[CellGroupData[{
Cell[13873, 460, 318, 9, 25, "SolvedExampleInput",ExpressionUUID->"cb055d8e-43dd-4249-bbe6-84f241c2078b",
 CellID->244792923],
Cell[14194, 471, 2958, 76, 45, "SolvedExampleOutput",ExpressionUUID->"423e3c10-8a00-4310-8470-22830120495c",
 CellID->2122309117]
}, Open  ]],
Cell[17167, 550, 131, 1, 39, "SolvedExampleNote",ExpressionUUID->"2fd188f2-6996-4495-8376-e50be2569d15",
 CellID->236961927],
Cell[CellGroupData[{
Cell[17323, 555, 142, 2, 25, "SolvedExampleInput",ExpressionUUID->"b3bd035a-9760-420e-841b-291799b6248b",
 CellID->179476623],
Cell[17468, 559, 394, 8, 36, "SolvedExampleOutput",ExpressionUUID->"f0ab32e3-d33c-4494-8f8c-c6a7a7e4884f",
 CellID->266418266]
}, Open  ]],
Cell[17877, 570, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"5f84d135-25ac-4c4c-be1c-42c18cb7e7d3",
 CellID->943814759]
}, Open  ]],
Cell[CellGroupData[{
Cell[18020, 576, 135, 1, 56, "Subsection",ExpressionUUID->"c035656f-eeae-4cc9-891e-aba138aed06f",
 CellID->566016424],
Cell[18158, 579, 665, 16, 83, "Text",ExpressionUUID->"8efad069-6ed8-4262-973e-4f89adba793a",
 CellID->320573134],
Cell[18826, 597, 134, 1, 36, "Text",ExpressionUUID->"3f23d7fb-c434-40f6-b05d-279878f55fd6",
 CellID->511989455],
Cell[18963, 600, 249, 7, 48, "DisplayFormulaNumbered",ExpressionUUID->"67c816ef-7f60-4017-80c1-cb3e4e8629ea",
 CellID->119320873],
Cell[19215, 609, 392, 15, 60, "Text",ExpressionUUID->"d202fc99-aaeb-4485-8d4c-5c4e7d31f392",
 CellID->156022145],
Cell[CellGroupData[{
Cell[19632, 628, 354, 11, 48, "Input",ExpressionUUID->"8563859f-de00-4d2f-b963-663aa516542d",
 CellID->277309425],
Cell[19989, 641, 4539, 116, 45, "Output",ExpressionUUID->"ffb63eec-8e4d-409d-984a-d0dd06b0581d",
 CellID->1154158109]
}, Open  ]],
Cell[24543, 760, 208, 4, 60, "Text",ExpressionUUID->"a8cb2561-8feb-4379-a64e-6ffc9e8fc2ce",
 CellID->267629637],
Cell[CellGroupData[{
Cell[24776, 768, 128, 2, 25, "Input",ExpressionUUID->"f70c18d2-a3f7-47b1-b2c1-9626332f201f",
 CellID->27278787],
Cell[24907, 772, 479, 11, 36, "Output",ExpressionUUID->"f9737c33-7786-48b7-98d1-c7e2d509f111",
 CellID->632694753]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25435, 789, 150, 1, 56, "Subsection",ExpressionUUID->"0613440d-a371-4295-a76a-c886b82dbc3e",
 CellID->132636652],
Cell[25588, 792, 140, 1, 36, "Text",ExpressionUUID->"ea08528b-b5ff-4afe-af74-982587dede66",
 CellID->76015022],
Cell[25731, 795, 314, 9, 48, "DisplayFormulaNumbered",ExpressionUUID->"c8929eab-8f1e-48e7-92e5-b619c13ecda2",
 CellID->287644465],
Cell[26048, 806, 391, 10, 60, "Text",ExpressionUUID->"a6f85727-1473-49d6-8805-a3e52a9eaa30",
 CellID->738311568],
Cell[26442, 818, 301, 8, 36, "Text",ExpressionUUID->"34a65103-14f0-4b82-b5d5-12745342a539",
 CellID->179366770],
Cell[CellGroupData[{
Cell[26768, 830, 409, 11, 43, "Input",ExpressionUUID->"91be739e-0c0b-4fbf-8003-9d78629fe4a1",
 CellID->20654736],
Cell[27180, 843, 106, 1, 36, "Output",ExpressionUUID->"ba1e10ff-b8e2-46e8-9d55-13cf52169a79",
 CellID->640947769]
}, Open  ]],
Cell[27301, 847, 237, 4, 60, "Text",ExpressionUUID->"1df18d3b-21c8-4048-9bde-06b2278f2169",
 CellID->236514224],
Cell[CellGroupData[{
Cell[27563, 855, 557, 17, 47, "Input",ExpressionUUID->"a34b8a55-c10b-44ee-babc-8848388377f0",
 CellID->298652125],
Cell[28123, 874, 103, 1, 36, "Output",ExpressionUUID->"7663486b-c247-40f6-bf06-5e3d53179670",
 CellID->300856555]
}, Open  ]],
Cell[28241, 878, 451, 12, 39, "Text",ExpressionUUID->"b8c86c29-54ac-4261-b418-61a5e509b01e",
 CellID->295440017],
Cell[CellGroupData[{
Cell[28717, 894, 713, 22, 47, "Input",ExpressionUUID->"67f17114-1a95-41a0-bca5-298960cf6300",
 CellID->80106493],
Cell[29433, 918, 103, 1, 36, "Output",ExpressionUUID->"866fbaec-263b-4058-884c-410fcdfa2797",
 CellID->183572054]
}, Open  ]],
Cell[29551, 922, 516, 12, 62, "Text",ExpressionUUID->"a9fc2d56-00f8-4629-b20b-a9b8e3f0137d",
 CellID->893846478],
Cell[CellGroupData[{
Cell[30092, 938, 4695, 130, 70, "Input",ExpressionUUID->"b959f152-1bbc-4cbc-a0f8-2ad6aec645c1",
 CellID->724025106],
Cell[34790, 1070, 10404, 242, 299, "Output",ExpressionUUID->"fc0a5f6c-b9d0-4ef7-a96a-fe9f838fb61c",
 CellID->835424056]
}, {2}]],
Cell[45206, 1315, 260, 5, 60, "Text",ExpressionUUID->"669e8294-8f62-49a4-a489-4a4255976edd",
 CellID->855034102],
Cell[45469, 1322, 317, 7, 60, "Text",ExpressionUUID->"79632c9a-ba34-4ff9-bb3c-f15f7810e348",
 CellID->30163152]
}, Open  ]],
Cell[CellGroupData[{
Cell[45823, 1334, 133, 1, 56, "Subsection",ExpressionUUID->"7e940ca0-d8d6-4ab7-b3cc-7c77e4896d2e",
 CellID->111656858],
Cell[45959, 1337, 187, 8, 71, "SolvedExample",ExpressionUUID->"013096b7-4747-42af-825c-cd02eace6375",
 CellID->195733471],
Cell[46149, 1347, 945, 27, 61, "SolvedExampleNote",ExpressionUUID->"f402c802-b225-4ce2-9e3f-910f4572a730",
 CellID->80131101],
Cell[CellGroupData[{
Cell[47119, 1378, 1470, 38, 27, "SolvedExampleInput",ExpressionUUID->"1e9adcad-086c-4170-8056-3da6ef064f55",
 CellID->124370827],
Cell[48592, 1418, 41780, 710, 202, "SolvedExampleOutput",ExpressionUUID->"3a3ff68e-ac4a-47f9-975d-ef0a8a0afe2a",
 CellID->1294649447]
}, Open  ]],
Cell[90387, 2131, 164, 2, 39, "SolvedExampleNote",ExpressionUUID->"16d116d1-8b56-4fdc-b403-ef65ab3c7e22",
 CellID->87556395],
Cell[CellGroupData[{
Cell[90576, 2137, 885, 25, 62, "SolvedExampleInput",ExpressionUUID->"2518efd5-98db-4d66-b76b-9d185f3341e3",
 CellID->644110373],
Cell[91464, 2164, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"4ce5ab8f-9153-4f49-84f3-77cb354fe1e3",
 CellID->537242030]
}, Open  ]],
Cell[91595, 2168, 295, 7, 61, "SolvedExampleNote",ExpressionUUID->"2c2fd188-609d-4f41-b0aa-10c18be6c395",
 CellID->122542205],
Cell[CellGroupData[{
Cell[91915, 2179, 459, 13, 25, "SolvedExampleInput",ExpressionUUID->"f05029cb-d1c2-4c1d-946f-3ed1a0f9c85d",
 CellID->65842531],
Cell[92377, 2194, 3668, 93, 45, "SolvedExampleOutput",ExpressionUUID->"cd6c133b-0393-4c1e-aacb-092f77bcb0e9",
 CellID->1185232097]
}, Open  ]],
Cell[96060, 2290, 125, 1, 39, "SolvedExampleNote",ExpressionUUID->"5eef956d-7534-4949-bf74-265cdfd09385",
 CellID->71474107],
Cell[CellGroupData[{
Cell[96210, 2295, 142, 2, 25, "SolvedExampleInput",ExpressionUUID->"121df67e-c5c4-47a0-b67b-c95acff99f06",
 CellID->487216114],
Cell[96355, 2299, 440, 10, 36, "SolvedExampleOutput",ExpressionUUID->"24f84081-6e6e-4ace-b69b-d689b263b4de",
 CellID->29974176]
}, Open  ]],
Cell[96810, 2312, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"c7afa28e-55f4-4e9a-b9cc-05706001c0d3",
 CellID->712078654],
Cell[96919, 2315, 187, 8, 71, "SolvedExample",ExpressionUUID->"697176bf-29db-499c-ae2c-3ca0cd627fbf",
 CellID->202985685],
Cell[97109, 2325, 786, 23, 39, "SolvedExampleNote",ExpressionUUID->"ebb877d0-272e-4b26-80d7-0b8b83a43bcb",
 CellID->71538497],
Cell[97898, 2350, 289, 8, 39, "SolvedExampleNote",ExpressionUUID->"67819d2c-2f00-46a4-9eae-09921160dd6f",
 CellID->757515115],
Cell[CellGroupData[{
Cell[98212, 2362, 1575, 42, 27, "SolvedExampleInput",ExpressionUUID->"aa8f6e70-9996-4d1f-b2c9-499c4d98a3c6",
 CellID->229744834],
Cell[99790, 2406, 52804, 890, 202, "SolvedExampleOutput",ExpressionUUID->"cb379379-4a55-4779-b6f9-303e70841b37",
 CellID->888664458]
}, Open  ]],
Cell[152609, 3299, 159, 2, 39, "SolvedExampleNote",ExpressionUUID->"98d9a1f7-cfa5-44f1-abbf-4d219e165ebe",
 CellID->213234498],
Cell[CellGroupData[{
Cell[152793, 3305, 1495, 44, 81, "SolvedExampleInput",ExpressionUUID->"63735d23-015d-409b-8739-f821c6e683d6",
 CellID->337334014],
Cell[154291, 3351, 133, 1, 36, "SolvedExampleOutput",ExpressionUUID->"306ed182-9cc8-43de-9506-f0b5712fdef9",
 CellID->113097057]
}, Open  ]],
Cell[154439, 3355, 198, 6, 39, "SolvedExampleNote",ExpressionUUID->"d7ae2cc5-3fc7-4bb3-89d3-eb8cf5b7ee89",
 CellID->454511699],
Cell[CellGroupData[{
Cell[154662, 3365, 560, 17, 25, "SolvedExampleInput",ExpressionUUID->"28226f8c-a3db-436f-8415-8a3f202c3977",
 CellID->233038955],
Cell[155225, 3384, 116, 1, 36, "SolvedExampleOutput",ExpressionUUID->"e255b172-579a-42a3-b301-e46870b3a975",
 CellID->413675130]
}, Open  ]],
Cell[155356, 3388, 186, 5, 39, "SolvedExampleNote",ExpressionUUID->"c3a2d1b0-ad11-428b-a810-7506c110be6a",
 CellID->176187509],
Cell[CellGroupData[{
Cell[155567, 3397, 498, 15, 25, "SolvedExampleInput",ExpressionUUID->"79811160-05fd-4881-97b3-e72aa0e92a7d",
 CellID->37095152],
Cell[156068, 3414, 2527, 67, 45, "SolvedExampleOutput",ExpressionUUID->"f7c7edc0-0d57-4a8c-a329-64123fb45654",
 CellID->1185466664]
}, Open  ]],
Cell[158610, 3484, 132, 1, 39, "SolvedExampleNote",ExpressionUUID->"c8aa3a5b-df20-49b3-85a0-31c9905055e6",
 CellID->26502621],
Cell[CellGroupData[{
Cell[158767, 3489, 142, 2, 25, "SolvedExampleInput",ExpressionUUID->"b5f1e8f6-9378-4431-ab34-4202ae7e4804",
 CellID->635582712],
Cell[158912, 3493, 253, 5, 36, "SolvedExampleOutput",ExpressionUUID->"71e98739-bf46-406f-92df-ede8fd152ce4",
 CellID->509408886]
}, Open  ]],
Cell[159180, 3501, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"96ccf558-b70f-48d2-a2c3-c60d000b8bd8",
 CellID->1344109701],
Cell[CellGroupData[{
Cell[159312, 3506, 109, 1, 69, "SummarySection",ExpressionUUID->"794faf35-3f8c-40c1-a251-e2ff4e983cd4",
 CellID->1198545324],
Cell[159424, 3509, 173, 2, 29, "SummaryList",ExpressionUUID->"e34fa353-e934-4352-b5e6-c8af98973442",
 CellID->324737511],
Cell[159600, 3513, 627, 19, 51, "DisplayFormula",ExpressionUUID->"88e79231-8ff1-41ef-a2a4-6974b6941314",
 CellID->581311417],
Cell[160230, 3534, 209, 4, 52, "SummaryList",ExpressionUUID->"b639c292-b3ee-42de-a0e2-4ebf39ea9d78",
 CellID->50298559],
Cell[160442, 3540, 223, 4, 52, "SummaryList",ExpressionUUID->"5db45a4f-50eb-4a3d-997b-a9117b04070b",
 CellID->7723285],
Cell[160668, 3546, 200, 4, 29, "SummaryList",ExpressionUUID->"76fb1f9b-59b5-4ba3-857b-2d6c24492eb2",
 CellID->546896568]
}, Open  ]],
Cell[CellGroupData[{
Cell[160905, 3555, 160, 3, 65, "ExerciseSection",ExpressionUUID->"e1cccfdd-9037-4bc0-b64c-b40fad574b92",
 CellID->281555698],
Cell[161068, 3560, 612, 19, 33, "Exercise",ExpressionUUID->"4d2fb3ad-d8f1-49d0-9817-7120a2804fc2",
 CellID->52608808],
Cell[CellGroupData[{
Cell[161705, 3583, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"de3e3fc8-0704-4625-9125-79bff075b000"],
Cell[161799, 3585, 373, 12, 22, "SolutionAnswer",ExpressionUUID->"06fb453f-7fe6-48e6-941f-594909c87e89",
 CellID->474285869],
Cell[162175, 3599, 141, 2, 25, "ExerciseInput",ExpressionUUID->"2a2ea36d-24e5-4361-a7f7-10c03def41be",
 CellID->359200403],
Cell[CellGroupData[{
Cell[162341, 3605, 582, 19, 66, "ExerciseInput",ExpressionUUID->"2300b3c8-d69d-461f-8d8e-93794751da9f",
 CellID->632602631],
Cell[162926, 3626, 538, 18, 50, "ExerciseOutput",ExpressionUUID->"c2fda0b6-664a-45aa-adae-0e2ec99c66b4",
 CellID->563568942]
}, Open  ]],
Cell[163479, 3647, 1734, 56, 51, "SolutionAnswer",ExpressionUUID->"33784081-43dd-4299-9b7b-95de3c106c1a",
 CellID->174628978],
Cell[CellGroupData[{
Cell[165238, 3707, 800, 25, 51, "ExerciseInput",ExpressionUUID->"0d6b4843-d40a-4569-989a-22fe59fbe2fb",
 CellID->459248],
Cell[166041, 3734, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"0129bbaa-cd41-4136-b3c0-010c06fe2f5f",
 CellID->119946627]
}, Open  ]],
Cell[166167, 3738, 542, 17, 22, "SolutionAnswer",ExpressionUUID->"97ac8634-a294-493c-8b2c-ff1c19d99f5d",
 CellID->379512211],
Cell[CellGroupData[{
Cell[166734, 3759, 442, 15, 46, "ExerciseInput",ExpressionUUID->"0b7697a7-3676-4b64-9e4c-957d358c7032",
 CellID->204371087],
Cell[167179, 3776, 357, 11, 45, "ExerciseOutput",ExpressionUUID->"c88276ef-8b73-4b2e-abe2-2d3eac7549c8",
 CellID->12949826]
}, Open  ]]
}, Closed]],
Cell[167563, 3791, 891, 26, 25, "Exercise",ExpressionUUID->"fe353f17-9fa9-4f73-b81b-9e20bf0961e5",
 CellID->220339749],
Cell[CellGroupData[{
Cell[168479, 3821, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"e061da7a-bb8e-4b17-90b7-e3e2d5b7793c"],
Cell[168573, 3823, 285, 8, 22, "SolutionAnswer",ExpressionUUID->"f14258db-0371-4416-a940-e12c3068e6a3",
 CellID->22126526],
Cell[CellGroupData[{
Cell[168883, 3835, 1368, 35, 28, "ExerciseInput",ExpressionUUID->"5a5537fc-7755-4dc2-92d3-afab77f70481",
 CellID->576907846],
Cell[170254, 3872, 52061, 874, 195, "ExerciseOutput",ExpressionUUID->"8f224351-19b2-4612-af84-ba487646c5b2",
 CellID->1882816687]
}, Open  ]],
Cell[222330, 4749, 861, 27, 28, "SolutionAnswer",ExpressionUUID->"e2ad19f1-8c10-48ad-8eac-d8ce2fa3b78f",
 CellID->797135153],
Cell[CellGroupData[{
Cell[223216, 4780, 970, 30, 65, "ExerciseInput",ExpressionUUID->"3ff417f8-bac3-470c-93e8-3522d8a6e957",
 CellID->239966307],
Cell[224189, 4812, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"cf87f320-02c1-4fad-b4c5-b69994c8c41c",
 CellID->468143859]
}, Open  ]],
Cell[224315, 4816, 178, 6, 22, "SolutionAnswer",ExpressionUUID->"8a26e10b-7ac5-4cfd-9c2d-3e77c03c27a2",
 CellID->189354212],
Cell[CellGroupData[{
Cell[224518, 4826, 452, 13, 25, "ExerciseInput",ExpressionUUID->"426a6c9b-f96e-4ce6-8e96-167807edfe35",
 CellID->290099589],
Cell[224973, 4841, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"86174be6-ba6d-464c-ae09-8b091af04c07",
 CellID->188414645]
}, Open  ]],
Cell[225099, 4845, 195, 6, 22, "SolutionAnswer",ExpressionUUID->"0173db78-928c-4d8e-9c60-ab93072147b3",
 CellID->894917706],
Cell[CellGroupData[{
Cell[225319, 4855, 606, 17, 25, "ExerciseInput",ExpressionUUID->"33173f2d-cbd9-4af3-82d6-b227ff8deb12",
 CellID->433996504],
Cell[225928, 4874, 3697, 93, 37, "ExerciseOutput",ExpressionUUID->"22465e50-d2ca-4e87-99e6-f2564b6b41a8",
 CellID->1804811268]
}, Open  ]],
Cell[229640, 4970, 123, 1, 22, "SolutionAnswer",ExpressionUUID->"570f6aaa-6d80-408d-96c6-e1c82ab275f2",
 CellID->403349005],
Cell[CellGroupData[{
Cell[229788, 4975, 137, 2, 25, "ExerciseInput",ExpressionUUID->"3c54c8f8-a353-4aac-ab6b-700c4261e935",
 CellID->300871297],
Cell[229928, 4979, 435, 9, 28, "ExerciseOutput",ExpressionUUID->"d38edead-2017-42d9-a9e4-24bf71708a90",
 CellID->126369278]
}, Open  ]]
}, Closed]],
Cell[230390, 4992, 576, 17, 29, "Exercise",ExpressionUUID->"6a854982-7868-4a98-bc79-64703292e13d",
 CellID->434250205],
Cell[CellGroupData[{
Cell[230991, 5013, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"b65115ee-0f9e-451c-a2bf-1dc6bb620b00"],
Cell[231085, 5015, 285, 8, 22, "SolutionAnswer",ExpressionUUID->"519578f8-dbde-48c0-babc-c5f15de356ca",
 CellID->31170415],
Cell[CellGroupData[{
Cell[231395, 5027, 602, 18, 25, "ExerciseInput",ExpressionUUID->"4365fa3f-4627-4e74-8cdd-0442cf9ad5f8",
 CellID->407384613],
Cell[232000, 5047, 69657, 1160, 195, "ExerciseOutput",ExpressionUUID->"03ca4853-130c-46b4-a706-5cbef7d3c13d",
 CellID->703295164]
}, Open  ]],
Cell[301672, 6210, 224, 6, 22, "SolutionAnswer",ExpressionUUID->"5275a77f-83f4-4295-bf6c-310b929fefa4",
 CellID->417340199],
Cell[CellGroupData[{
Cell[301921, 6220, 1066, 32, 65, "ExerciseInput",ExpressionUUID->"9dbda6f2-7ad8-47c6-bf02-33ee34307e06",
 CellID->655873104],
Cell[302990, 6254, 129, 1, 28, "ExerciseOutput",ExpressionUUID->"2ef8ff41-fc11-495d-8548-2fdfb9450f01",
 CellID->689803889]
}, Open  ]],
Cell[303134, 6258, 122, 1, 22, "SolutionAnswer",ExpressionUUID->"32ff5e19-291d-4f6c-b4b4-c27a2e9a115f",
 CellID->35043307],
Cell[CellGroupData[{
Cell[303281, 6263, 550, 17, 25, "ExerciseInput",ExpressionUUID->"808d002f-da48-4922-9416-d861b8286965",
 CellID->203307917],
Cell[303834, 6282, 1333, 36, 37, "ExerciseOutput",ExpressionUUID->"211bc9e8-6e8c-4462-b077-376d975cd85f",
 CellID->1050619072]
}, Open  ]],
Cell[305182, 6321, 122, 1, 22, "SolutionAnswer",ExpressionUUID->"dedcc926-7010-46fe-8839-0a3534584589",
 CellID->192581690],
Cell[CellGroupData[{
Cell[305329, 6326, 136, 2, 25, "ExerciseInput",ExpressionUUID->"b6af0a22-91d9-42ff-b144-d1c398526728",
 CellID->65799174],
Cell[305468, 6330, 177, 3, 28, "ExerciseOutput",ExpressionUUID->"1e0e50fd-e1f3-4d3e-8451-0e8644469a1c",
 CellID->631106977]
}, Open  ]]
}, Closed]],
Cell[305672, 6337, 716, 22, 25, "Exercise",ExpressionUUID->"b873f7e5-87dc-4060-9dce-b8c7867d4e7a",
 CellID->169181395],
Cell[CellGroupData[{
Cell[306413, 6363, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"f2d0a117-9966-475f-8335-651629ed1dbf"],
Cell[306507, 6365, 286, 8, 22, "SolutionAnswer",ExpressionUUID->"5e534c2e-2135-46ca-8d8b-1fcb5e85a3a1",
 CellID->150361944],
Cell[CellGroupData[{
Cell[306818, 6377, 642, 18, 42, "ExerciseInput",ExpressionUUID->"74bb4b5d-2f0a-4f21-8969-ef5593c2d312",
 CellID->35281073],
Cell[307463, 6397, 39569, 669, 193, "ExerciseOutput",ExpressionUUID->"efe53baa-9e07-41cb-96f8-efd337b4faec",
 CellID->1165267393]
}, Open  ]],
Cell[347047, 7069, 315, 8, 22, "SolutionAnswer",ExpressionUUID->"7e483181-98ac-4301-ba31-179a8f21f5cb",
 CellID->663386301],
Cell[CellGroupData[{
Cell[347387, 7081, 926, 27, 65, "ExerciseInput",ExpressionUUID->"b429ceea-3fc9-40ff-89b4-ed3168a5c416",
 CellID->249678652],
Cell[348316, 7110, 129, 1, 28, "ExerciseOutput",ExpressionUUID->"e5676a18-52ea-42dc-a887-314ff9cacf51",
 CellID->169275109]
}, Open  ]],
Cell[348460, 7114, 126, 1, 22, "SolutionAnswer",ExpressionUUID->"1ca0e7b4-969b-4fa7-b579-1005ef921719",
 CellID->247041628],
Cell[CellGroupData[{
Cell[348611, 7119, 443, 13, 25, "ExerciseInput",ExpressionUUID->"beba3146-4371-4a30-99af-1c2f4d09c8a5",
 CellID->98044949],
Cell[349057, 7134, 9288, 227, 66, "ExerciseOutput",ExpressionUUID->"e7df07bc-e511-4c8a-900f-7cf13a6fbfe6",
 CellID->1312778166]
}, Open  ]],
Cell[358360, 7364, 122, 1, 22, "SolutionAnswer",ExpressionUUID->"ccc9afd8-41b9-46d7-9741-ceaa0211d6f3",
 CellID->95988000],
Cell[CellGroupData[{
Cell[358507, 7369, 137, 2, 25, "ExerciseInput",ExpressionUUID->"df80204c-247b-4209-84ff-9475ecbabd45",
 CellID->159310607],
Cell[358647, 7373, 908, 18, 45, "ExerciseOutput",ExpressionUUID->"bea1252f-defe-428b-a12f-c6fee9ac2df9",
 CellID->326579460]
}, Open  ]]
}, Closed]],
Cell[359582, 7395, 740, 23, 25, "Exercise",ExpressionUUID->"24962966-1ad6-443c-ac89-63973064ed39",
 CellID->716152413],
Cell[CellGroupData[{
Cell[360347, 7422, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"480af5dd-6d47-4c43-b3e0-b9aa93a76dea"],
Cell[360441, 7424, 286, 8, 22, "SolutionAnswer",ExpressionUUID->"01d252d4-55df-4997-b5d0-84cde469bed9",
 CellID->276668645],
Cell[CellGroupData[{
Cell[360752, 7436, 1527, 41, 28, "ExerciseInput",ExpressionUUID->"7466e005-2018-4bba-8b1e-ae88513f8a90",
 CellID->44273721],
Cell[362282, 7479, 52424, 884, 193, "ExerciseOutput",ExpressionUUID->"503d7d07-6c79-40a7-b32e-455f926a6d27",
 CellID->249476504]
}, Open  ]],
Cell[414721, 8366, 128, 1, 22, "SolutionAnswer",ExpressionUUID->"25d619e1-d56d-4bba-9e1c-c998b351a5a9",
 CellID->219861147],
Cell[CellGroupData[{
Cell[414874, 8371, 979, 30, 65, "ExerciseInput",ExpressionUUID->"e3e148c4-b5f9-40a8-b4ca-1d62f1c47146",
 CellID->95776148],
Cell[415856, 8403, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"977fda43-7895-4fe0-bb78-2ca817446419",
 CellID->743035975]
}, Open  ]],
Cell[415982, 8407, 169, 6, 22, "SolutionAnswer",ExpressionUUID->"ef4d7b26-5d17-47b7-96bd-707b723f71bb",
 CellID->14811347],
Cell[CellGroupData[{
Cell[416176, 8417, 493, 15, 25, "ExerciseInput",ExpressionUUID->"5676a25b-d8fd-43d2-889b-2a781a433410",
 CellID->164523961],
Cell[416672, 8434, 5933, 145, 37, "ExerciseOutput",ExpressionUUID->"6ff9980c-7962-4093-8b41-8716fc310cf9",
 CellID->1831782355]
}, Open  ]],
Cell[422620, 8582, 131, 1, 22, "SolutionAnswer",ExpressionUUID->"a0cd2cea-8e94-461c-a737-edb05a9bcd12",
 CellID->312309081],
Cell[CellGroupData[{
Cell[422776, 8587, 136, 2, 25, "ExerciseInput",ExpressionUUID->"a0ed6664-18af-4706-a2ef-71d6a9034235",
 CellID->61073247],
Cell[422915, 8591, 587, 14, 28, "ExerciseOutput",ExpressionUUID->"b738a2a8-8afc-48c0-9b98-b64d1b2ee1d5",
 CellID->43890839]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[423565, 8612, 310, 6, 135, "SmallText",ExpressionUUID->"8d0d801c-0711-46dc-ba95-4ca24e78213c",
 CellGroupingRules->"SectionGrouping",
 CellID->1143784180]
}
]
*)

(* NotebookSignature fRGx6e6hCuK8gkud6BIjsIwo *)
