(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    384502,       8646]
NotebookOptionsPosition[    201243,       4884]
NotebookOutlinePosition[    364013,       8266]
CellTagsIndexPosition[    363970,       8263]
WindowTitle->26. Definite Integrals | Essentials of Complex Analysis
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 
 CounterBox["Section"],
 StyleBox[" | ", "SectionBar"],
 "Definite Integrals"
}], "Section",
 CounterAssignments->{{"Section", 25}},
 CellID->396629460,ExpressionUUID->"e1e67c37-a81b-49bd-9408-556d9ca4413d"],

Cell["\<\
This chapter contains some examples of how the integral of a real function \
can often be performed more simply by going through the complex plane.\
\>", "Text",
 CellID->382899017,ExpressionUUID->"b41ead46-f531-4d32-992a-8db377c57c06"],

Cell[CellGroupData[{

Cell["Trigonometric Integrals", "Subsection",
 CellID->511715044,ExpressionUUID->"8d397d3a-4edd-4dcf-9837-a092132c7d84"],

Cell["Trigonometric integrals are those of the type", "Text",
 CellID->398528281,ExpressionUUID->"66e8b80d-1cfc-4ce9-8216-cba050126e50"],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", "a", 
    RowBox[{"\[ThinSpace]", "b"}]], 
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"sin\[Theta]", ",", " ", "cos\[Theta]"}], ")"}], 
    RowBox[{
     RowBox[{"\[DifferentialD]", "\[Theta]"}], "."}]}]}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->196299659,ExpressionUUID->"22d6ed1a-626a-4e71-bcc5-a5e19f03e5e9"],

Cell["Often, they can be computed by the substitution", "Text",
 CellID->326482207,ExpressionUUID->"be52dfd6-cae3-4cda-81fb-2d7ab2338c57"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"z", "=", 
    SuperscriptBox["e", 
     RowBox[{"\[VeryThinSpace]", 
      RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]}]]}], ",", 
   "           ", 
   RowBox[{
    RowBox[{"\[DifferentialD]", "z"}], "=", 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["e", 
      RowBox[{"\[VeryThinSpace]", 
       RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]}]], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->27589235,ExpressionUUID->"eb89fd3d-010c-442d-b5f7-622546594768"],

Cell["\<\
which removes the sine and cosine functions because it leads to\
\>", "Text",
 CellID->459039163,ExpressionUUID->"b83951e0-18a2-415e-972d-b3593879245c"],

Cell[BoxData[
 FormBox[GridBox[{
    {
     RowBox[{"cos", "\[InvisibleSpace]", "\[Theta]"}], "=", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], 
       RowBox[{"(", 
        RowBox[{"z", "+", 
         FractionBox["1", "z"]}], ")"}]}], ","}]},
    {
     RowBox[{"sin", "\[InvisibleSpace]", "\[Theta]"}], "=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[ImaginaryI]"}]], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", 
         FractionBox["1", "z"]}], ")"}], "."}]}]}
   }], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->163719195,ExpressionUUID->"73115ade-18f2-408f-b9a3-a4bf3e4d1636"],

Cell["The method is best illustrated by example.", "Text",
 CellID->103463970,ExpressionUUID->"690f3b2a-2a6d-4d0c-b540-69e23a7d5de4"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->54343068,ExpressionUUID->"9e26d494-a1e2-4b75-af28-d4b5da63e1e2"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Integral]", 
      RowBox[{"\[VeryThinSpace]", "0"}]], 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"5", "+", 
       RowBox[{"4", " ", "cos\[Theta]"}]}]], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"646c3fa9-cccd-4d39-a9d9-91da45cd6d1d"],
 "."
}], "SolvedExampleNote",
 CellID->31031473,ExpressionUUID->"229173f0-46b3-454a-bbcd-367716c77f67"],

Cell["\<\
Applying the substitution, you get an integral around the unit circle in the \
complex plane:\
\>", "SolvedExampleNote",
 CellID->191497112,ExpressionUUID->"b94b630b-957b-45cf-8777-f9c71e166be9"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "0"}], 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"5", "+", 
       RowBox[{"4", "cos\[Theta]"}]}]], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], "=", 
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "1"}]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"5", "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"z", "+", 
          RowBox[{"1", "/", "z"}]}], ")"}]}]}]], 
     FractionBox[
      RowBox[{"\[DifferentialD]", "z"}], 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "1"}]], 
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{"\[ImaginaryI]", " ", "z"}]], "\[CenterDot]", 
       FractionBox["z", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "+", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "z"}], "+", "1"}], ")"}]}]]}], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{
        RowBox[{"|", "z", "|"}], "=", "1"}]], 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "+", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "z"}], "+", "1"}], ")"}]}]], 
       RowBox[{
        RowBox[{"\[DifferentialD]", "z"}], "."}]}]}]}]}]}], 
  TraditionalForm]}],ExpressionUUID->"c53cb586-65bc-434a-aca1-56e489d1b9a1"]],\
 "SolvedExampleNote",
 CellID->118689112,ExpressionUUID->"0572dd21-f29a-4a06-835c-2ed3e5503a76"],

Cell[TextData[{
 "The change of variables can be performed with ",
 ButtonBox["ReplaceAll",
  BaseStyle->"Link"],
 " as follows:"
}], "SolvedExampleNote",
 CellID->27009928,ExpressionUUID->"a7c68c0f-d6b9-435d-a1a7-9deaf9d49173"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"4", 
         RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}]}], "/.", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], "->", 
      RowBox[{
       RowBox[{"1", "/", "2"}], "*", 
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{"1", "/", "z"}]}], ")"}]}]}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"I", " ", "z"}], ")"}]}], "//", "Factor"}]], "SolvedExampleInput",\

 CellID->2522036,ExpressionUUID->"0e13e11e-b0c9-4dbc-bd7a-9f3f4c25fab6"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[ImaginaryI]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "+", "z"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "z"}]}], ")"}]}]]}]], "SolvedExampleOutput",
 CellID->219102736,ExpressionUUID->"f7c0c494-3952-4817-95b3-075ed2cfa291"]
}, Open  ]],

Cell["\<\
which finds the new integrand. Visualize the new integrand and the path of \
integration:\
\>", "SolvedExampleNote",
 CellID->252019689,ExpressionUUID->"721b41bd-6b2c-48df-b046-59f697e8228b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "z"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      TemplateBox[<|"color" -> RGBColor[
          Rational[1, 3], 
          Rational[1, 3], 
          Rational[1, 3]]|>,
       "RGBColorSwatchTemplate"], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Circle", "[", "]"}]}]}], "}"}]}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["312", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[BaseStyle -> {LightDarkAutoColorRules -> {}}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->227740522,ExpressionUUID->"8c8ebfa2-0189-406d-bc87-8012b8a9c75e"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y9s1VcYh/FLWUjlsHOkyBoSBKYMsdQ2maqFBNGZZQS3BFUz0WRqbstc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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxM20VzI9vasOkvuic97L/Qk12mYq5djGZmZmZmZmbGMjMzo2xLFjMzU2YK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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mzGoHUUYhR/a2KZNJ7aWaSWVaQUrSyNYWAm2sUypbbASrNJmytwuKSxW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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[
     NCache[
      Rational[1, 3], 0.3333333333333333], 
     NCache[
      Rational[1, 3], 0.3333333333333333], 
     NCache[
      Rational[1, 3], 0.3333333333333333]], 
    ArrowBox[
     CircleBox[{0, 0}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->858618057,ExpressionUUID->"46ed961d-ef6a-4a6a-b6ba-85072ec8d2ff"]
}, Open  ]],

Cell[TextData[{
 "This can be computed with the residue theorem; only the pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"84ff8ad6-7acc-44ea-b7e8-c491c8d7ff86"],
 " is inside the contour:"
}], "SolvedExampleNote",
 CellID->215360412,ExpressionUUID->"eaef6176-a039-4531-82ed-036d4f2b9d8b"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{
    RowBox[{"=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "\[CenterDot]", 
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], 
      SubscriptBox["Res", 
       RowBox[{"z", "->", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}]}]], 
      FractionBox["1", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z", "+", "2"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "z"}], "+", "1"}], ")"}]}]]}]}], "\[IndentingNewLine]",
     "\t\t", 
    RowBox[{"=", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "\[CenterDot]", 
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}]}], 
      RowBox[{
       SubscriptBox["lim", 
        RowBox[{"z", "->", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}]], 
       FractionBox[
        RowBox[{"(", 
         RowBox[{"z", "+", 
          RowBox[{"1", "/", "2"}]}], ")"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"z", "+", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "z"}], "+", "1"}], ")"}]}]]}]}]}], "\[IndentingNewLine]",
     "\t\t", 
    RowBox[{"=", 
     RowBox[{
      FractionBox["2", "3"], 
      RowBox[{"\[Pi]", "."}]}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"a2d4537b-a703-4eae-9767-aa50beefadb1"]], \
"SolvedExampleNote",
 CellID->8255921,ExpressionUUID->"73ad82a9-3604-41c5-925b-0b5f038eb175"],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->250289981,ExpressionUUID->"1d0ed778-dafb-48f7-b1dc-57ab82de4c46"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"5", "+", 
      RowBox[{"4", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->514301818,ExpressionUUID->"18a78b94-91eb-4ac7-915d-a4fa124d932f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], "3"]], "SolvedExampleOutput",
 CellID->484586448,ExpressionUUID->"bc888a3e-66f2-43e8-846d-85b4d2490f46"]
}, Open  ]],

Cell["\<\
Confirm the equivalence to the integral around the unit circle:\
\>", "SolvedExampleNote",
 CellID->107994244,ExpressionUUID->"54134c6a-0972-4316-ab1e-68f111429941"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourIntegrate", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"(", 
        RowBox[{"z", "+", 
         RowBox[{"1", "/", "z"}]}], ")"}]}]}]], 
    FractionBox["1", 
     RowBox[{"\[ImaginaryI]", " ", "z"}]]}], ",", 
   RowBox[{"z", "\[Element]", 
    RowBox[{"Circle", "[", "]"}]}]}], "]"}]], "SolvedExampleInput",
 CellID->191284703,ExpressionUUID->"f5f57847-9b53-4603-80d6-14f8c0006d8e"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], "3"]], "SolvedExampleOutput",
 CellID->42361224,ExpressionUUID->"3ffa681e-c5c9-4309-8c39-c4a5e63c9776"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->943814759,ExpressionUUID->"9ac53420-d992-4cac-8006-b92aa03dd3ed"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->9972039,ExpressionUUID->"eb68e323-f3b8-466d-ae04-916182719753"],

Cell[TextData[{
 "Calculate the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Integral]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "0"}]], 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["cos", "2"], "\[Theta]"}], 
      RowBox[{"2", "+", "sin\[Theta]"}]], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"491b7acb-2b50-4bef-a377-4971a2020a1c"],
 "."
}], "SolvedExampleNote",
 CellID->71072954,ExpressionUUID->"b96eda7e-6ff8-4702-88a5-b2328d198e8a"],

Cell["Applying the substitution:", "SolvedExampleNote",
 CellID->774763465,ExpressionUUID->"2974d9af-d18d-4514-9d05-6b6615ce4fb2"],

Cell[TextData[Cell[BoxData[{
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "0"}], 
     RowBox[{"2", "\[Pi]"}]], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["cos", "2"], "\[Theta]"}], 
      RowBox[{"2", "+", "sin\[Theta]"}]], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], "=", 
   RowBox[{
    SubscriptBox["\[Integral]", 
     RowBox[{
      RowBox[{"|", "z", "|"}], "=", "1"}]], 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", 
         FractionBox["1", "z"]}], ")"}], "2"], "\[CenterDot]", 
      FractionBox["1", 
       RowBox[{"2", "+", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{"z", "-", 
           RowBox[{"1", "/", "z"}]}], ")"}], 
         RowBox[{"2", "\[ImaginaryI]"}]]}]], "\[CenterDot]", 
      FractionBox[
       RowBox[{"\[DifferentialD]", "z"}], 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]}]}], TraditionalForm], "\[IndentingNewLine]", 
 FormBox[
  RowBox[{"\t\t", 
   RowBox[{"=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "1"}]], 
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["z", "2"]}], ")"}], "2"], 
       RowBox[{"2", " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "\[ImaginaryI]", " ", "z"}], "+", 
          SuperscriptBox["z", "2"]}], ")"}]}]], 
      RowBox[{
       RowBox[{"\[DifferentialD]", "z"}], "."}]}]}]}]}], 
  TraditionalForm]}],ExpressionUUID->"9b120268-a64b-473e-bf05-83ff36a9e1a5"]],\
 "SolvedExampleNote",
 CellID->164111970,ExpressionUUID->"8a2abef2-b047-4579-9967-b201f4d95968"],

Cell["Visualize the new integrand and the path of integration:", \
"SolvedExampleNote",
 CellID->594865085,ExpressionUUID->"ee6b1339-a87c-41f4-b15a-ca2e32f1f2b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexPlot", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["z", "2"]}], ")"}], "2"], 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"4", " ", "\[ImaginaryI]", " ", "z"}], "+", 
       SuperscriptBox["z", "2"]}], ")"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      TemplateBox[<|"color" -> RGBColor[
          Rational[1, 3], 
          Rational[1, 3], 
          Rational[1, 3]]|>,
       "RGBColorSwatchTemplate"], ",", 
      RowBox[{"Arrow", "@", 
       RowBox[{"Circle", "[", "]"}]}]}], "}"}]}], ",", 
   InterpretationBox[
    DynamicModuleBox[{Typeset`open = False}, 
     TemplateBox[{"Expression", "SequenceIcon", 
       GridBox[{{
          RowBox[{
            TagBox["\"Head: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["Sequence", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Length: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            TagBox["2", "IconizedItem"]}]}, {
          RowBox[{
            TagBox["\"Byte count: \"", "IconizedLabel"], "\[InvisibleSpace]", 
            
            TagBox["312", "IconizedItem"]}]}}, 
        GridBoxAlignment -> {"Columns" -> {{Left}}}, DefaultBaseStyle -> 
        "Column", 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
       Dynamic[Typeset`open]},
      "IconizedObject"]],
    Sequence[BaseStyle -> {LightDarkAutoColorRules -> {}}, ImageSize -> Small],
    SelectWithContents->True,
    Selectable->False]}], "]"}]], "SolvedExampleInput",
 CellID->5346843,ExpressionUUID->"2cb51427-a9e8-4b26-97fc-be4ec44894c9"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx12y+o2FUYh/HrH3CIoBPTTcqaiBjEJpqsA9OK4QoGkzJMWgw3CauLq9YV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    "], {{
      {Opacity[1.], Texture[
        GraphicsBox[
         TagBox[
          RasterBox[CompressedData["
1:eJxs2WdwHGma4PeN0wedPkm6OJ12Y+92b2fdzPaO65metmx6A8ID5W1WmrLw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           "], {{0, 100.}, {100., 0}}, {0, 255}, ColorFunction -> RGBColor], 
          BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
         ImageSizeRaw -> {100., 100.}, PlotRange -> {{0, 100.}, {0, 100.}}]], 
       EdgeForm[None], GraphicsGroupBox[
        TagBox[PolygonBox[CompressedData["
1:eJxNm3V01UfXhXPvD3e3oMGCBQlO0QDBA4Hg7u4uwSluhQKlRYsXCsXdnUIL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          "]],
         Annotation[#, "Charting`Private`Tag#1"]& ]]}, {}, {}, {}, {}}, 
     LineBox[CompressedData["
1:eJwt0bdNgwEQBtAfTMY2OdsgWsIChJ7QURE6CrDJyYmcBAsQFoAFCAvAAoQF
YAHCAsCzRPGkK06nu+86p5fHlgqCIEhRSL7uYJApclxyzyvfVGnqZZQkp1zz
yDu/xA3rZ4IM59zyzCeRUBB0M8wsCZLMMc8CiyyxzAqrrLHOBinSZMiSY5Mt
ttlhlz32OeCQI46ZYYguwnzY64kbzkgzTh8xftz1xgNXnJBghB6ifMnnhTsu
yDLJAO3EidFGKy0000QjDdRTRy01VOczJ0qEMJVUUE4ZpZRQTBGh/3/+Ac0Z
Le4=
      "]]},
    VertexTextureCoordinates->CompressedData["
1:eJx1mz2oHkUYRj+0CWiTNoUgtpaCldhZiCCkso0YwUqwDahFWgubIBaCVcDK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     "]], {}},
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  BaseStyle->{LightDarkAutoColorRules -> {}},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    RGBColor[
     NCache[
      Rational[1, 3], 0.3333333333333333], 
     NCache[
      Rational[1, 3], 0.3333333333333333], 
     NCache[
      Rational[1, 3], 0.3333333333333333]], 
    ArrowBox[
     CircleBox[{0, 0}]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  ImagePadding->All,
  ImageSize->Small,
  Method->{
   "GridLinesInFront" -> True, "ScalingFunctions" -> None, 
    "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotInteractivity:>True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "SolvedExampleOutput",
 CellID->732562583,ExpressionUUID->"c860fc5d-a6fe-4cd2-a002-966a304b50ad"]
}, Open  ]],

Cell[TextData[{
 "The integrand has poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "\[PlusMinus]", 
       SqrtBox["3"]}], ")"}], "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"51972972-17c2-4526-a772-0619976abae0"],
 ":"
}], "SolvedExampleNote",
 CellID->248601382,ExpressionUUID->"539cb99b-2329-4fb4-8b44-dd450b245246"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["z", "2"]}], ")"}], "2"], 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"4", " ", "\[ImaginaryI]", " ", "z"}], "+", 
       SuperscriptBox["z", "2"]}], ")"}]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FunctionPoles", "[", 
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}]}], "SolvedExampleInput",
 CellID->625415500,ExpressionUUID->"be743973-57e4-4566-8acf-05974072e693"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", "1"}], "}"}]}], "}"}]], "SolvedExampleOutput",
 CellID->314973646,ExpressionUUID->"fd0e9cdb-2c2c-4c6e-a63f-bf9549fc117a"]
}, Open  ]],

Cell[TextData[{
 "Only the poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"z", "=", "0"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SqrtBox["3"]}], ")"}], "\[ImaginaryI]"}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"25b15024-0ab2-4c20-955f-24bfc36c1ab7"],
 " are inside the contour, which is a circle of radius 1."
}], "SolvedExampleNote",
 CellID->368606664,ExpressionUUID->"451bebb9-e1c0-4c92-9081-fe96f244cf83"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "0"}], 
      RowBox[{"2", "\[Pi]"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["cos", "2"], "\[Theta]"}], 
       RowBox[{"2", "+", "sin\[Theta]"}]], 
      RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"z", "->", "0"}]], 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["z", "2"]}], ")"}], "2"], 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", "z"}], "+", 
            SuperscriptBox["z", "2"]}], ")"}]}]]}], "+", 
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"z", "->", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             SqrtBox["3"]}], ")"}], "\[ImaginaryI]"}]}]], 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["z", "2"]}], ")"}], "2"], 
         RowBox[{"2", " ", 
          SuperscriptBox["z", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", "z"}], "+", 
            SuperscriptBox["z", "2"]}], ")"}]}]]}]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "abf6d3b3-93b1-42db-8b2e-57ffccba66b4"],
 "."
}], "SolvedExampleNote",
 CellID->185206872,ExpressionUUID->"f82c7d56-38e8-4f4e-97cc-f8413665c46f"],

Cell["In Wolfram Language:", "SolvedExampleNote",
 CellID->38183647,ExpressionUUID->"ccdf7dc7-0dd5-4ef3-ac02-6aa4d7d968a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}], 
   RowBox[{"ResidueSum", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "z", "]"}], ",", 
       RowBox[{
        RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}], "}"}], ",", "z"}], 
    "]"}]}], "//", "Simplify"}]], "SolvedExampleInput",
 CellID->396453290,ExpressionUUID->"53dd8ff7-7440-4400-9eb9-3192417183ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SqrtBox["3"]}], ")"}], " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->9052795,ExpressionUUID->"54cd9fb0-e50f-44cb-ba5e-01e596c3529a"]
}, Open  ]],

Cell[TextData[{
 "Compare to the result from ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->34866462,ExpressionUUID->"4b16ffbf-ab57-447a-bb5d-54de338e95f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "2"], 
    RowBox[{"2", "+", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "SolvedExampleInput",
 CellID->153008301,ExpressionUUID->"a3bbcf25-1350-4fa5-8923-dacbab9ff770"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SqrtBox["3"]}], ")"}], " ", "\[Pi]"}]], "SolvedExampleOutput",
 CellID->211496755,ExpressionUUID->"77c6ef2c-4cb7-4003-8713-23443d32a8d0"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->346606882,ExpressionUUID->"9e406349-1d3c-47bb-a95d-b54dbe3ca503"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Jordan\[CloseCurlyQuote]s Lemma", "Subsection",
 CellID->131573002,ExpressionUUID->"30ac304d-12b6-4132-89e6-6e5d21444261"],

Cell[TextData[{
 "Jordan\[CloseCurlyQuote]s lemma is frequently used to evaluate some \
integrals over ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], ")"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "3f4157ad-5a82-43ef-8f44-2eb92b5e75ae"],
 " by complex contour integration."
}], "Text",
 CellID->5868228,ExpressionUUID->"93f9578f-fe99-4ac1-b9a1-dd565454e1b3"],

Cell[CellGroupData[{

Cell["Jordan\[CloseCurlyQuote]s Lemma", "Subsubsection",
 CellChangeTimes->{{3.964086112731189*^9, 3.964086115371105*^9}},
 CellID->1985850273,ExpressionUUID->"7af24a8a-1d7b-4ded-8ac6-cd90a38dd411"],

Cell[TextData[{
 "1. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6bc6e009-4d3b-40e2-b8f1-8ef5baa6434c"],
 " is continuous in the upper half-plane except at a finite number of \
non-real points, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", ">", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"6a51fb94-b932-45e3-b1b9-53ac95988f33"],
 " and"
}], "Text",
 CellID->19162524,ExpressionUUID->"dca66791-3f00-412d-9e36-08647e214bfb"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      UnderscriptBox["lim", 
       RowBox[{"R", "->", "\[Infinity]"}]], 
      UnderscriptBox["max", 
       RowBox[{"\[Theta]", "\[Element]", 
        RowBox[{"[", 
         RowBox[{"0", ",", "\[Pi]"}], "]"}]}]]}], "|", 
     RowBox[{"f", "(", 
      RowBox[{"R", "\[InvisibleSpace]", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}], ")"}], 
     "|"}], "=", "0"}], ","}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->335099431,ExpressionUUID->"3fc607d8-4da8-430b-b63d-544431aab632"],

Cell["then", "Text",
 CellID->340271272,ExpressionUUID->"b4c58692-b172-4f7a-be74-62f3cb129575"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
       "\[ImaginaryI]", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", 
        "x"}]], 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", 
     RowBox[{
      UnderscriptBox["\[Sum]", "i"], " ", 
      RowBox[{
       UnderscriptBox["Res", 
        RowBox[{"z", "->", 
         SubscriptBox["z", "i"]}]], "(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
         "\[ImaginaryI]", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]",
           "z"}]], 
        RowBox[{"f", "(", "z", ")"}]}], ")"}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->59810,ExpressionUUID->"6640a225-bd7d-4c18-947f-aaf67aa3d15f"],

Cell["where the sum is over the poles in the upper half-plane.", "Text",
 CellID->90632183,ExpressionUUID->"2c285945-7208-4487-ae21-1394a681f59f"],

Cell[TextData[{
 "2. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "<", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a31e1aa3-76b3-46aa-bca8-881f81e6d5d4"],
 " and"
}], "Text",
 CellID->21211770,ExpressionUUID->"151e64ee-ee45-45a8-b90c-79f917ff9509"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      UnderscriptBox["lim", 
       RowBox[{"R", "->", "\[Infinity]"}]], 
      UnderscriptBox["max", 
       RowBox[{"\[Theta]", "\[Element]", 
        RowBox[{"[", 
         RowBox[{"\[Pi]", ",", 
          RowBox[{"2", "\[Pi]"}]}], "]"}]}]]}], "|", 
     RowBox[{"f", "(", 
      RowBox[{"R", "\[InvisibleSpace]", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}], ")"}], 
     "|"}], "=", "0"}], ","}], TraditionalForm]], "DisplayFormulaNumbered",
 CellID->934369381,ExpressionUUID->"c6a5afc3-698e-4d2e-a174-269789cbd846"],

Cell["then", "Text",
 CellID->273680,ExpressionUUID->"eda7f1eb-3d4e-4c30-9616-b3ffc126859b"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
       "\[ImaginaryI]", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", 
        "x"}]], 
      RowBox[{"f", "(", "x", ")"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{"-", "2"}], "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]", 
     RowBox[{
      UnderscriptBox["\[Sum]", "i"], " ", 
      RowBox[{
       UnderscriptBox["Res", 
        RowBox[{"z", "->", 
         SubscriptBox["z", "i"]}]], "(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
         "\[ImaginaryI]", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]",
           "z"}]], 
        RowBox[{"f", "(", "z", ")"}]}], ")"}]}]}]}], ","}], 
  TraditionalForm]], "DisplayFormulaNumbered",
 CellID->238243430,ExpressionUUID->"b91309c1-3575-42d2-b6d6-0ca308d39034"],

Cell["where the sum is over the poles in the lower half-plane.", "Text",
 CellID->177374090,ExpressionUUID->"cd4e0744-325b-4cba-898d-9b25c14fc003"],

Cell["\<\
The logic behind the lemma is that one can \[OpenCurlyDoubleQuote]close\
\[CloseCurlyDoubleQuote] the contour with a semicircle on the upper or lower \
half of the complex plane (Fig. 1).\
\>", "Text",
 CellID->647142913,ExpressionUUID->"a92def00-d27f-4649-aa25-78f0eb3adbc6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Row", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Circle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "\[Pi]"}], "}"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "+", "0.1"}], ",", "0"}], 
               "}"}]}], "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"1", "/", "2"}], "+", "0.1"}], ",", "0"}], "}"}]}], 
             "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"\[Pi]", "/", "4"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"\[Pi]", "/", "4"}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "4"}], "+", "0.1"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{
                  RowBox[{"\[Pi]", "/", "4"}], "+", "0.1"}], "]"}]}], "}"}]}],
              "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"3", 
                  RowBox[{"\[Pi]", "/", "4"}]}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"3", 
                  RowBox[{"\[Pi]", "/", "4"}]}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"3", 
                   RowBox[{"\[Pi]", "/", "4"}]}], "+", "0.1"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{
                  RowBox[{"3", 
                   RowBox[{"\[Pi]", "/", "4"}]}], "+", "0.1"}], "]"}]}], 
               "}"}]}], "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            
            RowBox[{"\"\<\!\(\*Cell[\"\[Omega] > \
0\",ExpressionUUID->\"8927c6ea-96cc-4d60-9986-c26a250c5b5c\"]\)\>\"", ",", 
             "14"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.8", ",", "1.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Axes", "->", "True"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
       RowBox[{"Ticks", "->", "None"}], ",", 
       RowBox[{"ImageSize", "->", "245"}]}], "]"}], "\[IndentingNewLine]", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"White", ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "->", "50"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Circle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
             RowBox[{"{", 
              RowBox[{"\[Pi]", ",", 
               RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "+", "0.1"}], ",", "0"}], 
               "}"}]}], "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"1", "/", "2"}], "+", "0.1"}], ",", "0"}], "}"}]}], 
             "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"5", 
                  RowBox[{"\[Pi]", "/", "4"}]}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"5", 
                  RowBox[{"\[Pi]", "/", "4"}]}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"5", 
                   RowBox[{"\[Pi]", "/", "4"}]}], "-", "0.1"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{
                  RowBox[{"5", 
                   RowBox[{"\[Pi]", "/", "4"}]}], "-", "0.1"}], "]"}]}], 
               "}"}]}], "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[<|"color" -> RGBColor[0.368417, 0.506779, 0.709798]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"7", 
                  RowBox[{"\[Pi]", "/", "4"}]}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{"7", 
                  RowBox[{"\[Pi]", "/", "4"}]}], "]"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{
                  RowBox[{"7", 
                   RowBox[{"\[Pi]", "/", "4"}]}], "-", "0.1"}], "]"}], ",", 
                RowBox[{"Sin", "[", 
                 RowBox[{
                  RowBox[{"7", 
                   RowBox[{"\[Pi]", "/", "4"}]}], "-", "0.1"}], "]"}]}], 
               "}"}]}], "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            
            RowBox[{"\"\<\!\(\*Cell[\"\[Omega] < \
0\",ExpressionUUID->\"24722a38-53da-4727-a1ad-7ce55e6c79eb\"]\)\>\"", ",", 
             "14"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.8", ",", "1.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Axes", "->", "True"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AxesLabel", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Re", "[", "z", "]"}], ",", "12"}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Im", "[", "z", "]"}], ",", "12"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
       RowBox[{"Ticks", "->", "None"}], ",", 
       RowBox[{"ImageSize", "->", "245"}]}], "]"}]}], "\[IndentingNewLine]", 
    "}"}], "]"}], "//", 
  RowBox[{
   RowBox[{"Labeled", "[", 
    RowBox[{"#", ",", "\"\<Fig. 1.\>\""}], "]"}], "&"}]}]], "Input",
 CellID->551922900,ExpressionUUID->"0c9bf8e5-eae3-4732-a2a7-86f8d126636c"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TemplateBox[{
       GraphicsBox[{{
          RGBColor[0.368417, 0.506779, 0.709798], 
          CircleBox[{0, 0}, 1, 
           NCache[{0, Pi}, {0, 3.141592653589793}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          LineBox[{{-1, 0}, {1, 0}}]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           NCache[{{
              Rational[-1, 2], 0}, {-0.4, 0}}, {{-0.5, 0}, {-0.4, 0}}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           NCache[{{
              Rational[1, 2], 0}, {0.6, 0}}, {{0.5, 0}, {0.6, 0}}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           
           NCache[{{2^Rational[-1, 2], 2^Rational[-1, 2]}, {
             0.6329813066769582, 0.7741670784769464}}, {{0.7071067811865475, 
            0.7071067811865475}, {0.6329813066769582, 
            0.7741670784769464}}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           
           NCache[{{-2^Rational[-1, 2], 2^
              Rational[-1, 2]}, {-0.7741670784769464, 
             0.6329813066769582}}, {{-0.7071067811865475, 
            0.7071067811865475}, {-0.7741670784769464, 
            0.6329813066769582}}]]}, 
         InsetBox[
          FormBox[
           StyleBox[
           "\"\\!\\(\\*Cell[\\\"\[Omega] > 0\\\"]\\)\"", 14, StripOnInput -> 
            False], TraditionalForm], {0.8, 1.1}, 
          NCache[
           ImageScaled[{
             Rational[1, 2], 1}], 
           ImageScaled[{0.5, 1}]]]}, Axes -> True, 
        PlotRange -> {{-1.1, 1.1}, {-1.1, 1.1}}, AxesLabel -> {
          FormBox[
           StyleBox[
            RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
           TraditionalForm], 
          FormBox[
           StyleBox[
            RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
           TraditionalForm]}, AspectRatio -> Automatic, Ticks -> None, 
        ImageSize -> 245], 
       GraphicsBox[{
         GrayLevel[1], 
         LineBox[{{0, 0}, {1, 0}}]}, ImageSize -> 50], 
       GraphicsBox[{{
          RGBColor[0.368417, 0.506779, 0.709798], 
          CircleBox[{0, 0}, 1, 
           NCache[{Pi, 2 Pi}, {3.141592653589793, 6.283185307179586}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          LineBox[{{-1, 0}, {1, 0}}]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           NCache[{{
              Rational[-1, 2], 0}, {-0.4, 0}}, {{-0.5, 0}, {-0.4, 0}}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           NCache[{{
              Rational[1, 2], 0}, {0.6, 0}}, {{0.5, 0}, {0.6, 0}}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           
           NCache[{{-2^Rational[-1, 2], -2^
               Rational[-1, 
                 2]}, {-0.7741670784769467, -0.632981306676958}}, \
{{-0.7071067811865475, -0.7071067811865475}, {-0.7741670784769467, \
-0.632981306676958}}]]}, {
          RGBColor[0.368417, 0.506779, 0.709798], 
          ArrowBox[
           
           NCache[{{2^Rational[-1, 2], -2^Rational[-1, 2]}, {
             0.6329813066769583, -0.7741670784769464}}, {{
            0.7071067811865475, -0.7071067811865475}, {
            0.6329813066769583, -0.7741670784769464}}]]}, 
         InsetBox[
          FormBox[
           StyleBox[
           "\"\\!\\(\\*Cell[\\\"\[Omega] < 0\\\"]\\)\"", 14, StripOnInput -> 
            False], TraditionalForm], {0.8, 1.1}, 
          NCache[
           ImageScaled[{
             Rational[1, 2], 1}], 
           ImageScaled[{0.5, 1}]]]}, Axes -> True, 
        PlotRange -> {{-1.1, 1.1}, {-1.1, 1.1}}, AxesLabel -> {
          FormBox[
           StyleBox[
            RowBox[{"Re", "(", "z", ")"}], 12, StripOnInput -> False], 
           TraditionalForm], 
          FormBox[
           StyleBox[
            RowBox[{"Im", "(", "z", ")"}], 12, StripOnInput -> False], 
           TraditionalForm]}, AspectRatio -> Automatic, Ticks -> None, 
        ImageSize -> 245]},
      "RowDefault"]},
    {"\<\"Fig. 1.\"\>"}
   },
   AutoDelete->False,
   BaseStyle->{FontFamily -> "Source Sans Code"},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"ColumnsIndexed" -> {2 -> 1}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellID->1237895866,ExpressionUUID->"324e3d29-7dfe-431b-b4c5-ceeb4b591771"]
}, {2}]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c2d860cf-7e45-4034-8f0e-eca813660eb0"],
 " decays fast enough, this semicircle will not contribute to the integral, \
but enables us to use the residue theorem. The minus sign in Eq. (7) is due \
to the clockwise orientation of the resulting contour. The proof of the lemma \
is straightforward, based on estimating the integral over the semicircle."
}], "Text",
 CellID->60681172,ExpressionUUID->"f0a5b011-eb90-476c-9cf0-27a1f19720c3"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->253593451,ExpressionUUID->"2a026185-d821-4a6a-a961-a767641260e9"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "x"}]], 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"c15a2a3d-84ca-453b-8774-0166b3ca00c8"],
 "."
}], "SolvedExampleNote",
 CellID->293623877,ExpressionUUID->"b64b81f3-9794-4e18-be9d-db9d901bae3a"],

Cell[TextData[{
 "Here you can apply case 1 of Jordan\[CloseCurlyQuote]s lemma, with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2011bc6b-41dc-461a-aa9d-ee81d7320490"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"2ccfa8a8-db2d-429b-9df7-df6e3cc32d04"],
 " closing the contour in the upper half-plane. Let\[CloseCurlyQuote]s check \
that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b31df473-3a59-42f3-9d23-1336a2cd92d5"],
 " decays fast enough:"
}], "SolvedExampleNote",
 CellID->323857967,ExpressionUUID->"b7f50f01-b534-4194-aa96-3be7954809b6"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"R", "->", "\[Infinity]"}]], 
    RowBox[{
     SubscriptBox["max", 
      RowBox[{"\[Theta]", "\[Element]", 
       RowBox[{"[", 
        RowBox[{"0", ",", "\[Pi]"}], "]"}]}]], 
     RowBox[{"\[LeftBracketingBar]", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"R", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], "4"]}]], 
      "\[RightBracketingBar]"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"R", "->", "\[Infinity]"}]], 
     FractionBox["1", 
      RowBox[{"|", 
       RowBox[{"1", "-", 
        SuperscriptBox["R", "4"]}], "|"}]]}], "=", "0."}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"5c59ee32-a9d0-4069-b1c5-36b8b49edbf5"]], \
"SolvedExampleNote",
 CellID->267372431,ExpressionUUID->"a9441e3a-42cc-4f72-8460-d7a52a62c171"],

Cell["\<\
After closing the path in the upper half-plane, find the poles of the \
function:\
\>", "SolvedExampleNote",
 CellID->120719945,ExpressionUUID->"451e9541-8257-437d-8f8a-6f6485e0d1e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionPoles", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "+", 
      SuperscriptBox["z", "4"]}]], ",", "z"}], "]"}], "//", 
  "ComplexExpand"}]], "SolvedExampleInput",
 CellID->337286927,ExpressionUUID->"49b39410-ef57-447f-ae48-ab82d2e627f1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", "\[ImaginaryI]"}], 
       SqrtBox["2"]]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "\[ImaginaryI]"}], 
      SqrtBox["2"]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", "\[ImaginaryI]"}], 
      SqrtBox["2"]], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "-", "\[ImaginaryI]"}], 
       SqrtBox["2"]]}], ",", "1"}], "}"}]}], "}"}]], "SolvedExampleOutput",
 CellID->40163409,ExpressionUUID->"782a4cbe-0183-45c7-b3b4-7b83423cdb72"]
}, Open  ]],

Cell["and the result is:", "SolvedExampleNote",
 CellID->976897184,ExpressionUUID->"0e08f633-51ab-41ee-a2c4-6eb2fb2c543c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]"}], ")"}], 
    RowBox[{"ResidueSum", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         SuperscriptBox["E", 
          RowBox[{"\[ImaginaryI]", " ", "z"}]], 
         RowBox[{"1", "+", 
          SuperscriptBox["z", "4"]}]], ",", 
        RowBox[{
         RowBox[{"Im", "[", "z", "]"}], ">", "0"}]}], "}"}], ",", "z"}], 
     "]"}]}], "//", "ComplexExpand"}], "//", 
  "Simplify"}]], "SolvedExampleInput",
 CellID->47980667,ExpressionUUID->"51827c70-50a7-4d03-8178-21d579e10ffa"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["1", 
      SqrtBox["2"]]}]], " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["1", 
       SqrtBox["2"]], "]"}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["1", 
       SqrtBox["2"]], "]"}]}], ")"}]}], 
  SqrtBox["2"]]], "SolvedExampleOutput",
 CellID->785455532,ExpressionUUID->"0b7096a1-a882-4d46-8bba-aaa1b2d7dd60"]
}, Open  ]],

Cell[TextData[{
 "Compare to ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->434267304,ExpressionUUID->"f90fa034-bb8b-4d5e-ba39-c7485a88319d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "4"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->154276106,ExpressionUUID->"e2b7b50f-61b2-4cfc-8881-5c6b22cee807"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["1", 
      SqrtBox["2"]]}]], " ", "\[Pi]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["1", 
       SqrtBox["2"]], "]"}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["1", 
       SqrtBox["2"]], "]"}]}], ")"}]}], 
  SqrtBox["2"]]], "SolvedExampleOutput",
 CellID->247186516,ExpressionUUID->"b38ed58d-348c-4fb3-bbff-e8c966cc36b5"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->620922218,ExpressionUUID->"5287b711-9556-4761-8aee-436207fe86ef"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->179013870,ExpressionUUID->"ad4bbee0-ae5b-42ae-8ac4-57b1fa18a59a"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox[
      RowBox[{"cos", " ", "x"}], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5eede171-6efe-4122-9060-dd264d2b7807"],
 "."
}], "SolvedExampleNote",
 CellID->55259230,ExpressionUUID->"b2af81d0-c91a-409a-95f7-a5e2e9e8a9b7"],

Cell[TextData[{
 "First, you should notice that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"9ced0298-6ab4-4598-bea9-3a5da9c026e3"],
 " is the real part of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fbd3384b-0167-481d-bd66-0734cf6a0c8a"],
 ". This should prompt you to calculate instead the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "x"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"fb82951a-6cad-4a36-a5be-9177afaf8b8a"],
 " and then take the real part. Use Jordan\[CloseCurlyQuote]s lemma with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", "1"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"febcc23f-a5cc-49b1-adf0-6d6fbd47d5a5"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "1"}], ")"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"606baa9c-3459-424c-9fc4-24aed3a4a634"],
 ". The function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e2782407-fe8f-4737-8a3c-49f6e792ff69"],
 " decays fast enough because"
}], "SolvedExampleNote",
 CellID->635895713,ExpressionUUID->"d39f8e56-c5b8-4663-ad86-318959ee4619"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["lim", 
     RowBox[{"R", "->", "\[Infinity]"}]], 
    RowBox[{
     SubscriptBox["max", 
      RowBox[{"\[Theta]", "\[Element]", 
       RowBox[{"[", 
        RowBox[{"0", ",", "\[Pi]"}], "]"}]}]], 
     RowBox[{"\[LeftBracketingBar]", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"R", " ", 
           SuperscriptBox["e", 
            RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], "2"]}]], 
      "\[RightBracketingBar]"}]}]}], "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["lim", 
      RowBox[{"R", "->", "\[Infinity]"}]], 
     FractionBox["1", 
      RowBox[{"|", 
       RowBox[{"1", "-", 
        SuperscriptBox["R", "2"]}], "|"}]]}], "=", "0."}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"e22c98b4-6c6e-45cf-86a5-e9c063c09beb"]], \
"SolvedExampleNote",
 CellID->596556397,ExpressionUUID->"99fc69e3-3cf7-41b9-9a9a-ff8119bd4096"],

Cell["So after closing the contour in the upper half-plane:", \
"SolvedExampleNote",
 CellID->139182222,ExpressionUUID->"2bf3e351-a5d6-4e23-aeab-8b2610de7221"],

Cell[TextData[Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "x"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}], ")"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
   RowBox[{
    RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
     SubscriptBox["Res", 
      RowBox[{"z", "->", "\[ImaginaryI]"}]], 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]], 
      RowBox[{
       SuperscriptBox["z", "2"], "+", "1"}]]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "1"}]], 
       RowBox[{"2", "\[ImaginaryI]"}]]}], "=", 
     RowBox[{
      FractionBox["\[Pi]", "\[ExponentialE]"], "."}]}]}]}], 
  TraditionalForm]], \
"InlineMath",ExpressionUUID->"bd6a77fe-b838-41ca-aba9-d46aab4250db"]], \
"SolvedExampleNote",
 CellID->439250185,ExpressionUUID->"09598258-fe4f-4c74-a3d8-68cdf0fac332"],

Cell[TextData[{
 "Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      FractionBox[
       RowBox[{"cos", " ", "x"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}], ")"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{"Re", "(", 
      FractionBox["\[Pi]", "\[ExponentialE]"], ")"}], "=", 
     FractionBox["\[Pi]", "\[ExponentialE]"]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"82673f23-20eb-4dfb-b4c0-ba56fc6225f4"],
 ". Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->143577348,ExpressionUUID->"0698b3b4-5cc6-41aa-b04d-df67de74bbf8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->39689063,ExpressionUUID->"8224738c-83d8-407b-8145-2af98e033a08"],

Cell[BoxData[
 FractionBox["\[Pi]", "\[ExponentialE]"]], "SolvedExampleOutput",
 CellID->64652486,ExpressionUUID->"a8f5b0b5-9204-417e-a8f1-0583aa987850"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->1606591619,ExpressionUUID->"d6c1b64f-4a38-4d99-bf4d-96c6adb257bc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrals of Certain Rational Functions", "Subsection",
 CellID->744405353,ExpressionUUID->"be2a6a62-27c6-436b-84a3-0e12ab6aaf7d"],

Cell[TextData[{
 "At times, integrals of the type ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     RowBox[{"r", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"17eb4ac1-280d-4015-b03d-71dec8588f74"],
 ", with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "(", "x", ")"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"00bbf17d-41ed-4a25-a67e-ff59068b7efe"],
 " a rational function, can be computed by suitably deforming the contour by \
adding a closed semicircle similarly as in Fig. 1."
}], "Text",
 CellID->10322103,ExpressionUUID->"89ebc3ba-24bc-4853-b4e7-8ff9a1b731fc"],

Cell[TextData[{
 "First, the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "R"}], "R"], 
    RowBox[{
     RowBox[{"r", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e3614a50-327e-4cf4-bf0d-cfe32f2f4922"],
 " is considered, then a semicircle of radius ",
 Cell[BoxData[
  FormBox["R", TraditionalForm]], "InlineMath",ExpressionUUID->
  "ae23f0b3-1fd2-4126-a329-cac25c421b3f"],
 " is added and the limit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"92d45fc0-c7b8-4420-94b4-97150a989c2a"],
 " is taken."
}], "Text",
 CellID->364316500,ExpressionUUID->"afc99a27-e682-4c30-8589-05185ba64a93"],

Cell["\<\
Whether this procedure is useful must be determined on a case-by-case basis, \
to ensure that the integral over the semicircle vanishes. If so, the integral \
can be calculated by the residue theorem.\
\>", "Text",
 CellID->63037447,ExpressionUUID->"1b78b560-08b4-485a-afe7-1ef8cc019bba"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"r", "(", "z", ")"}], "|", 
    RowBox[{"<=", 
     RowBox[{"M", "/", 
      SuperscriptBox["R", "k"]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"dced79f2-2f8c-4a3f-b9b8-19f5189c3bf0"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"R", " ", 
     SuperscriptBox["e", 
      RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"4b241d15-4061-4400-bac9-a25882c25df1"],
 ", ",
 Cell[BoxData[
  FormBox["M", TraditionalForm]], "InlineMath",ExpressionUUID->
  "e604371a-2344-430b-91a2-6f1b5bb8f4b6"],
 " a constant and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", ">", "1"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "42b2de4b-b1be-4b21-997c-a04c39744763"],
 ", then the integral on the semicircle is zero as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"d5b8a979-c127-4d6e-baba-3470d7020a0b"],
 ", and the method is certainly applicable."
}], "Text",
 CellID->116172592,ExpressionUUID->"9ae552da-f4cb-4d8a-a313-5e40ffc419b4"],

Cell[TextData[{
 "Example ",
 
 CounterBox["Section"],
 ".",
 
 CounterBox["SolvedExample"]
}], "SolvedExample",
 CellID->68367176,ExpressionUUID->"da1019d4-ce1b-4cf9-94bd-06d8c8a1c091"],

Cell[TextData[{
 "Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["x", "6"], "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"026a62ac-6b70-4b6b-87b0-eb5cb7f65183"],
 "."
}], "SolvedExampleNote",
 CellID->210301810,ExpressionUUID->"acc5c721-d8f2-4604-93db-3a694dfb83d7"],

Cell[TextData[{
 "First, note that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"R", " ", 
         SuperscriptBox["e", 
          RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]]}], ")"}], "6"], "+", 
      "1"}]], "|", 
    RowBox[{"<", 
     FractionBox["1", 
      SuperscriptBox["R", "6"]]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"39366514-64da-4785-bbb6-31703070d6ca"],
 ", so you can close the contour with an upper semicircle. Then the integral \
is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "\[ImaginaryI]"}], ")"}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "6bf704b1-8d8d-444d-8917-dafcd25f9cf3"],
 " times the sum of the residues of the poles in the upper half-plane. Using ",
 ButtonBox["ResidueSum",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->403445262,ExpressionUUID->"dbb89cd3-95fc-45f4-9e95-9f0b85a08147"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", "*", 
   RowBox[{"ResidueSum", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["z", "6"], "+", "1"}]], ",", 
       RowBox[{
        RowBox[{"Im", "[", "z", "]"}], ">", "0"}]}], "}"}], ",", "z"}], 
    "]"}]}], "//", "ComplexExpand"}]], "SolvedExampleInput",
 CellID->163929918,ExpressionUUID->"e0f58eac-2231-484c-ba4c-41d4d5b3483d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], "3"]], "SolvedExampleOutput",
 CellID->67855688,ExpressionUUID->"31e17a3a-91b0-4da6-b896-61356e9da651"]
}, Open  ]],

Cell[TextData[{
 "Then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], 
      RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "\[Infinity]"}]], 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SuperscriptBox["x", "6"], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    FractionBox[
     RowBox[{"2", "\[Pi]"}], "3"]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5ddff9f9-b665-4803-b588-94f1624f5d1b"],
 ". Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolvedExampleNote",
 CellID->145431398,ExpressionUUID->"b2d3c54e-b010-4de4-92a0-0eaca1f34293"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "6"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "SolvedExampleInput",
 CellID->726371589,ExpressionUUID->"5fa1e540-d3fa-4437-b94c-89b96b12dd81"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], "3"]], "SolvedExampleOutput",
 CellID->772110795,ExpressionUUID->"e2f6ecb4-ba5d-4ac6-8bbc-1659170c9a59"]
}, Open  ]],

Cell["", "SolvedExampleEndCap",
 CellID->578123746,ExpressionUUID->"6d11f197-a996-4514-acef-cac59178aea7"],

Cell[CellGroupData[{

Cell["Summary", "SummarySection",
 CellID->1198545324,ExpressionUUID->"45e93b22-c20a-4e17-a682-45af1edd8397"],

Cell[TextData[{
 "Trigonometric integrals of the type ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "a", 
     RowBox[{"\[VeryThinSpace]\[VeryThinSpace]", "b"}]], 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"cos\[Theta]", ",", " ", "sin\[Theta]"}], ")"}], 
     RowBox[{"\[DifferentialD]", "\[Theta]"}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"bfc1563a-a0f7-4042-8cc5-ab8b3ff599e7"],
 " can often be calculated by the substitution ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", "\[InvisibleSpace]", "\[Theta]"}]]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "a9c8cb2a-a39f-4152-9817-94d80d8a89b6"],
 " as complex integrals."
}], "SummaryList",
 CellID->496264327,ExpressionUUID->"106d3aac-3ee5-44e9-a3d8-621ee766454d"],

Cell[TextData[{
 "Integrals of the type ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ThinSpace]", 
       RowBox[{
       "\[ImaginaryI]", "\[InvisibleSpace]", "\[Omega]", "\[InvisibleSpace]", 
        "x"}]}]], 
     RowBox[{"f", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7f5552dc-1c32-483d-b259-0b0993d29134"],
 " can often be calculated by Jordan\[CloseCurlyQuote]s lemma."
}], "SummaryList",
 CellID->242282283,ExpressionUUID->"c20f50f9-b990-4356-93c4-fc407e475a83"],

Cell[TextData[{
 "Integrals of the type ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     RowBox[{"r", "(", "x", ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"e2790fe1-6d16-487a-a40a-fd01dc2bfa2f"],
 " can sometimes be calculated by adding a semicircular contour in the limit \
of infinite radius."
}], "SummaryList",
 CellID->145943732,ExpressionUUID->"ea825997-8256-48d7-8bfc-e071d8c48a7d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["Exercises",
  $Line = 0; Null]], "ExerciseSection",
 CellID->244972492,ExpressionUUID->"38918a00-ac42-484f-809d-a5e8c4dbd812"],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"\[ThinSpace]", 
      RowBox[{"2", "\[Pi]"}]}]], 
    RowBox[{
     FractionBox["1", 
      RowBox[{"3", "-", 
       RowBox[{"cos", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0b2db73d-f016-42cc-8ce7-3b2bd1bcbfb8"],
 "."
}], "Exercise",
 CellID->914307764,ExpressionUUID->"278cb879-10e9-47c3-b7f4-a539142372ac"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"2f7bc760-f6c6-40d6-ac89-0c16be3e5c0a"],

Cell[TextData[{
 "Using the replacement ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"97e15718-3544-4684-918f-1ac39b04d590"],
 ", the integral becomes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "1"}]], 
     RowBox[{
      FractionBox["1", 
       RowBox[{"3", "-", 
        RowBox[{
         FractionBox["1", "2"], 
         RowBox[{"(", 
          RowBox[{"z", "+", 
           FractionBox["1", "z"]}], ")"}]}]}]], 
      FractionBox[
       RowBox[{"\[DifferentialD]", "z"}], 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}], "=", 
    RowBox[{"4", "\[ImaginaryI]", 
     RowBox[{
      SubscriptBox["\[Integral]", 
       RowBox[{
        RowBox[{"|", "z", "|"}], "=", "1"}]], 
      RowBox[{
       FractionBox["z", 
        RowBox[{"1", "-", 
         RowBox[{"6", "z"}], "+", 
         SuperscriptBox["z", "2"]}]], 
       RowBox[{"\[DifferentialD]", "z"}]}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"0ac734cd-23a3-42bf-8925-241abbad66b3"],
 ". To find the poles of this function:"
}], "SolutionAnswer",
 CellID->474285869,ExpressionUUID->"b500de40-02c5-4b66-85de-d8540d161b81"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"6", "z"}], "+", 
     RowBox[{"z", "^", "2"}]}], "==", "0"}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->108159957,ExpressionUUID->"03593d0b-c662-4de1-9196-3cdb2154fbff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"3", "-", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"3", "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}]}], "}"}]}], "}"}]], "ExerciseOutput",
 CellID->792089456,ExpressionUUID->"8c7d8635-4867-4e3e-a5fb-6b3211552e82"]
}, Open  ]],

Cell[TextData[{
 "The first pole is inside the unit circle, so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", 
      RowBox[{"\[ThinSpace]", 
       RowBox[{"2", "\[Pi]"}]}]], 
     RowBox[{
      FractionBox["1", 
       RowBox[{"3", "-", 
        RowBox[{
         SuperscriptBox["cos", "2"], "x"}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[ImaginaryI]", 
      RowBox[{
       SubscriptBox["\[Integral]", 
        RowBox[{
         RowBox[{"|", "z", "|"}], "=", "1"}]], 
       RowBox[{
        FractionBox["1", 
         RowBox[{"1", "-", 
          RowBox[{"6", "z"}], "+", 
          SuperscriptBox["z", "2"]}]], 
        RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", 
     RowBox[{
      RowBox[{"-", "4"}], "\[Pi]", " ", 
      SubscriptBox["Res", 
       RowBox[{"z", "->", 
        RowBox[{"3", "-", 
         RowBox[{"2", 
          SqrtBox["2"]}]}]}]], 
      FractionBox["1", 
       RowBox[{"1", "-", 
        RowBox[{"6", "z"}], "+", 
        SuperscriptBox["z", "2"]}]]}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"86577492-09fb-421d-b5f1-a80024801b53"],
 ". With ",
 ButtonBox["Residue",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->42938819,ExpressionUUID->"bdeff07a-5450-4341-add3-78cd9e073cea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "\[Pi]", "*", 
  RowBox[{"Residue", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"6", "z"}], "+", 
       RowBox[{"z", "^", "2"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"3", "-", 
       RowBox[{"2", 
        SqrtBox["2"]}]}]}], "}"}]}], "]"}]}]], "ExerciseInput",
 CellID->437977753,ExpressionUUID->"d5624666-4026-4a5b-b9c7-98e422fac0b4"],

Cell[BoxData[
 FractionBox["\[Pi]", 
  SqrtBox["2"]]], "ExerciseOutput",
 CellID->313145840,ExpressionUUID->"189b886c-2b11-45ab-b74c-ef19c24955a4"]
}, Open  ]],

Cell[TextData[{
 "Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->52703776,ExpressionUUID->"c4e0fe8d-99c3-426d-84d8-1d159d4a9e88"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->179594352,ExpressionUUID->"31c6248b-20ad-4a00-bcb7-34f1874bab7f"],

Cell[BoxData[
 FractionBox["\[Pi]", 
  SqrtBox["2"]]], "ExerciseOutput",
 CellID->95679940,ExpressionUUID->"942a253f-a457-4e36-8166-11622f965c16"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", 
     RowBox[{"\[ThinSpace]", 
      RowBox[{"2", "\[Pi]"}]}]], 
    RowBox[{
     FractionBox[
      RowBox[{"sin", "(", 
       RowBox[{"3", "x"}], ")"}], 
      RowBox[{"b", "+", 
       RowBox[{
        SuperscriptBox["cos", "2"], "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"0bb5be41-86c9-4a63-b5c0-e6285f7a6e6d"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        SqrtBox["5"]}], ")"}]}], "\[TildeTilde]", 
     RowBox[{"-", "1.06"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"db4b74c8-a3ac-4ff6-ace3-42fc545455a0"],
 "."
}], "Exercise",
 CellID->84226656,ExpressionUUID->"1e3f09dc-5a03-4e75-a98c-855ffde9ff86"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"162b8512-d550-4ccb-979e-d4f4243dfa5b"],

Cell[TextData[{
 "Apply the change of variables ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"946c3d0c-afcb-4ed7-b67a-623888a655eb"],
 " and Eq. (3). Then notice that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sin", "(", 
     RowBox[{"3", "x"}], ")"}], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"3", "\[ImaginaryI]", " ", "x"}]], "-", 
       SuperscriptBox["e", 
        RowBox[{
         RowBox[{"-", "3"}], "\[ImaginaryI]", " ", "x"}]]}], 
      RowBox[{"2", "\[ImaginaryI]"}]], "=", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[ImaginaryI]"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "3"], "-", 
        FractionBox["1", 
         SuperscriptBox["z", "3"]]}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"29434750-fdaa-4287-a97f-9669e9bac4dd"],
 ". So the integral becomes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "1"}]], 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", "\[ImaginaryI]"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["z", "3"], "-", 
        FractionBox["1", 
         SuperscriptBox["z", "3"]]}], ")"}], 
      FractionBox["1", 
       RowBox[{"b", "+", 
        RowBox[{
         FractionBox["1", "4"], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"z", "+", 
            FractionBox["1", "z"]}], ")"}], "2"]}]}]], 
      FractionBox[
       RowBox[{"\[DifferentialD]", "z"}], 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}], "=", 
    RowBox[{
     SubscriptBox["\[Integral]", 
      RowBox[{
       RowBox[{"|", "z", "|"}], "=", "1"}]], 
     RowBox[{
      FractionBox[
       RowBox[{"2", "-", 
        RowBox[{"2", 
         SuperscriptBox["z", "6"]}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], "[", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"4", "b"}]}], ")"}], 
          SuperscriptBox["z", "2"]}], "+", 
         SuperscriptBox["z", "4"]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"1032c7b8-0076-4fa7-ab51-eddd0b6b660f"],
 "."
}], "SolutionAnswer",
 CellID->55624697,ExpressionUUID->"48920228-2186-493c-a151-b32797fdbcfb"],

Cell["To find the poles inside the unit circle, you can use:", \
"SolutionAnswer",
 CellID->131206112,ExpressionUUID->"54d6cb88-c18d-4319-b5e1-ef4d80c5269c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "^", "2"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"4", "b"}]}], ")"}], 
          RowBox[{"z", "^", "2"}]}], "+", 
         RowBox[{"z", "^", "4"}]}], ")"}]}], "/.", 
      RowBox[{"b", "->", 
       RowBox[{
        RowBox[{"1", "/", "4"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", 
          RowBox[{"Sqrt", "[", "5", "]"}]}], ")"}]}]}]}], ")"}], "==", "0"}], 
   ",", "z"}], "]"}]], "ExerciseInput",
 CellID->318131160,ExpressionUUID->"6d8b3e45-e0f4-482d-8940-970c50f516ef"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SqrtBox["5"]}], ")"}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["5"]}], ")"}]}]]}], "}"}]}], "}"}]], "ExerciseOutput",
 CellID->503394871,ExpressionUUID->"41dc0b3a-f093-40bd-acb0-0d0abf2669c4"]
}, Open  ]],

Cell["\<\
Only the first four out of six are inside the unit circle. The sum of the \
residues gives:\
\>", "SolutionAnswer",
 CellID->29439066,ExpressionUUID->"0f1f845e-a6af-489b-9e56-82ae21774430"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResidueSum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"2", "-", 
        RowBox[{"2", 
         SuperscriptBox["z", "6"]}]}], 
       RowBox[{
        SuperscriptBox["z", "2"], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"4", "b"}]}], ")"}], 
           SuperscriptBox["z", "2"]}], "+", 
          SuperscriptBox["z", "4"]}], ")"}]}]], "/.", 
      RowBox[{"b", "->", 
       RowBox[{
        RowBox[{"1", "/", "4"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", 
          RowBox[{"Sqrt", "[", "5", "]"}]}], ")"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}], "}"}], ",", "z"}], 
  "]"}]], "ExerciseInput",
 CellID->65678630,ExpressionUUID->"b15f7e27-b6ef-41d9-808b-6e1f6a33e7d1"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->356641293,ExpressionUUID->"cf4c5a9d-42ce-4f68-b114-18c12648b28c"]
}, Open  ]],

Cell[TextData[{
 "So the integral requested is zero. Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->6551626,ExpressionUUID->"926dc35a-c54a-442a-8a30-f92318029146"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], ")"}]}], "/.", 
    RowBox[{"b", "->", 
     RowBox[{
      RowBox[{"1", "/", "4"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"Sqrt", "[", "5", "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "ExerciseInput",
 CellID->15998534,ExpressionUUID->"a7dd6bc1-b6a6-4097-9893-76f051888150"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->331363847,ExpressionUUID->"3bd90682-e77b-4262-b16e-6707811fd074"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     FractionBox[
      RowBox[{"sin", "(", 
       RowBox[{"3", "x"}], ")"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"422d2f2e-120d-4fe2-8e08-d0636376e63d"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     FractionBox[
      RowBox[{"cos", "(", 
       RowBox[{"3", "x"}], ")"}], 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"302f93db-cc73-4c4d-8672-f5948a6dd33a"],
 "."
}], "Exercise",
 CellID->575428604,ExpressionUUID->"f2e8e160-739c-4bdb-a745-8953a524611e"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"d7f69830-b88d-4689-a0a0-666ea0ea8f80"],

Cell[TextData[{
 "First find ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"3", "\[ImaginaryI]", " ", "x"}]], 
      RowBox[{
       SuperscriptBox["x", "2"], "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"7b245660-74bb-421e-87f4-3f80e8d0986b"],
 " using Jordan\[CloseCurlyQuote]s lemma. After closing the contour in the \
upper half-plane, one has ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", "\[ImaginaryI]", " ", "x"}]], 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", " ", 
      SubscriptBox["Res", 
       RowBox[{"z", "->", "\[ImaginaryI]"}]], 
      FractionBox[
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"3", "\[ImaginaryI]", " ", "z"}]], 
       RowBox[{
        SuperscriptBox["z", "2"], "+", "1"}]]}], "=", 
     RowBox[{
      RowBox[{"2", "\[Pi]", " ", "\[ImaginaryI]", 
       FractionBox[
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "3"}]], 
        RowBox[{"2", "\[ImaginaryI]"}]]}], "=", 
      FractionBox["\[Pi]", 
       SuperscriptBox["\[ExponentialE]", "3"]]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"4ad7ac2a-4cd7-43c0-89bc-dcd3c5c5dfd6"],
 ", because only the pole at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[ImaginaryI]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"a2dcb8db-b21f-4546-95dc-f4b39a7e8ef7"],
 " is in the upper half-plane. The imaginary part of this is zero. \
Therefore:"
}], "SolutionAnswer",
 CellID->145621945,ExpressionUUID->"f8a729cb-f735-4c93-a493-0d13d14ddcc0"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      FractionBox[
       RowBox[{"sin", "(", 
        RowBox[{"3", "x"}], ")"}], 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"004033bf-7277-44ba-97cc-4486155369c9"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      FractionBox[
       RowBox[{"cos", "(", 
        RowBox[{"3", "x"}], ")"}], 
       RowBox[{
        SuperscriptBox["x", "2"], "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    FractionBox["\[Pi]", 
     SuperscriptBox["\[ExponentialE]", "3"]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"db710464-73de-471f-bc50-b72b6ef84618"],
 ". Check with Integrate:"
}], "SolutionAnswer",
 CellID->181291087,ExpressionUUID->"6aa5bbd7-847d-4e90-8b97-e33da3111919"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"3", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "ExerciseInput",
 CellID->10152337,ExpressionUUID->"94fe0276-b9c7-4b16-b90e-ea80f240d720"],

Cell[BoxData["0"], "ExerciseOutput",
 CellID->142512157,ExpressionUUID->"cbff612c-5274-4a19-b4d5-5de01933bb4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"3", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "ExerciseInput",
 CellID->557571507,ExpressionUUID->"eacc5cbd-4868-430a-9899-6ccd07d19473"],

Cell[BoxData[
 FractionBox["\[Pi]", 
  SuperscriptBox["\[ExponentialE]", "3"]]], "ExerciseOutput",
 CellID->545207199,ExpressionUUID->"4d2df421-a0bc-485e-bd00-512fa3266c13"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     FractionBox[
      RowBox[{"x", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], 
      RowBox[{
       SuperscriptBox["x", "4"], "+", "16"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"703cf4ba-7973-44b9-a350-7e3e8ea3d5e3"],
 "."
}], "Exercise",
 CellID->147656287,ExpressionUUID->"688048c2-3f48-4fd5-a01c-6ec414695406"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"8cc3e7bd-25c8-4022-859b-9b42cd767220"],

Cell[TextData[{
 "Use Jordan\[CloseCurlyQuote]s lemma with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    FractionBox["x", 
     RowBox[{
      SuperscriptBox["x", "4"], "+", "16"}]]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"ded33014-eae9-4cb6-8d21-79f2a55e29eb"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "f03b8ddb-c67b-4305-ab5a-8d3ddcd207aa"],
 ". The integrand has poles at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"2", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ThinSpace]", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"\[Pi]", "/", "4"}]}]}]]}]}], ",", 
    RowBox[{"2", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"3", "\[ImaginaryI]", " ", 
       RowBox[{"\[Pi]", "/", "4"}]}]]}], ",", 
    RowBox[{"2", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"5", 
       RowBox[{"\[ImaginaryI]\[Pi]", "/", "4"}]}]]}], ",", 
    RowBox[{"2", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"7", "\[ImaginaryI]", " ", 
       RowBox[{"\[Pi]", "/", "4"}]}]]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"843b649a-5152-4196-9932-959a03d2a638"],
 ". Because ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "<", "0"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"cbdaad88-55d9-4772-bc86-3c0cfd73ba19"],
 ", one must consider the poles in the lower half-plane. So"
}], "SolutionAnswer",
 CellID->59540520,ExpressionUUID->"d14c210d-5656-4627-b2eb-ba90ad3b8c43"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      FractionBox[
       RowBox[{"x", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], 
       RowBox[{
        SuperscriptBox["x", "4"], "+", "16"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{"-", "2"}], "\[Pi]", " ", 
     RowBox[{"\[ImaginaryI]", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"x", "->", 
          RowBox[{"2", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"5", 
             RowBox[{"\[ImaginaryI]\[Pi]", "/", "4"}]}]]}]}]], 
        FractionBox[
         RowBox[{"x", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], 
         RowBox[{
          SuperscriptBox["x", "4"], "+", "16"}]]}], "+", 
       RowBox[{
        SubscriptBox["Res", 
         RowBox[{"x", "->", 
          RowBox[{"2", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"7", 
             RowBox[{"\[ImaginaryI]\[Pi]", "/", "4"}]}]]}]}]], 
        FractionBox[
         RowBox[{"x", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], 
         RowBox[{
          SuperscriptBox["x", "4"], "+", "16"}]]}]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath",ExpressionUUID->
  "78ee551b-0c7e-4eee-be77-92d6530ebe77"],
 ". With ",
 ButtonBox["ResidueSum",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->411778248,ExpressionUUID->"a78a779b-9c9e-4ec4-a025-3e8c23daa19d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], "\[Pi]", " ", "\[ImaginaryI]", "*", 
   RowBox[{"ResidueSum", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"x", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "*", "x"}], "]"}]}], 
        RowBox[{
         SuperscriptBox["x", "4"], "+", "16"}]], ",", 
       RowBox[{
        RowBox[{"Im", "[", "x", "]"}], "<", "0"}]}], "}"}], ",", "x"}], 
    "]"}]}], "//", "FullSimplify"}]], "ExerciseInput",
 CellID->811858528,ExpressionUUID->"7419e8ff-2730-4c85-bf2a-e9fe2f4c8595"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SqrtBox["2"]}]], " ", "\[Pi]", " ", 
  RowBox[{"Sin", "[", 
   SqrtBox["2"], "]"}]}]], "ExerciseOutput",
 CellID->615124005,ExpressionUUID->"0ddc8f94-88fd-402c-9037-03dddd889a8f"]
}, Open  ]],

Cell[TextData[{
 "This is the value of the integral. Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->654375360,ExpressionUUID->"99056ab8-3b74-471b-b9c2-24af016df003"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"x", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], "*", "x"}], "]"}]}], 
    RowBox[{
     SuperscriptBox["x", "4"], "+", "16"}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "ExerciseInput",
 CellID->301245048,ExpressionUUID->"526ed37d-fdfc-4005-8066-19fa7b3e78be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SqrtBox["2"]}]], " ", "\[Pi]", " ", 
  RowBox[{"Sin", "[", 
   SqrtBox["2"], "]"}]}]], "ExerciseOutput",
 CellID->38252815,ExpressionUUID->"5cf24a37-1724-4b9b-b59c-7511cc2e6732"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"3", "x"}], "-", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x", "2"], "+", "2"}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"ae0de7f8-7809-46d9-8853-28ab68d3c8db"],
 "."
}], "Exercise",
 CellID->59232870,ExpressionUUID->"e14e37dd-b36c-452f-83ea-e5c4e0f46b53"],

Cell[CellGroupData[{

Cell["Solution", "ExerciseSolution",ExpressionUUID->"d0fa64bf-c1a9-446c-9efb-e38a360ceec7"],

Cell[TextData[{
 "The integrand goes to zero faster than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "R"}], TraditionalForm]], "InlineMath",ExpressionUUID->
  "7dd226b6-368b-46a1-9095-24d929525d74"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"b0cea4df-255e-413d-ae51-1ed0befd6c49"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{"R", " ", 
     SuperscriptBox["e", 
      RowBox[{"\[ThinSpace]", 
       RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]}]]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"f25a4e27-6c94-414c-99ca-68271df97998"],
 ", so one can close the contour with a semicircle in the upper half-plane. \
Then, compute the integral using the residue theorem, as the sum over the \
residues in the upper half-plane. The poles are located at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"\[PlusMinus]", "\[ImaginaryI]"}]}], ",", 
    RowBox[{
     RowBox[{"\[PlusMinus]", 
      SqrtBox["2"]}], "\[ImaginaryI]"}]}], TraditionalForm]], "InlineMath",
  ExpressionUUID->"5f04c9c5-3a2d-4344-bec4-f142d57a6bc7"],
 ", so:"
}], "SolutionAnswer",
 CellID->22126526,ExpressionUUID->"d64f6fe8-cf0f-47b9-977e-7617fe5aecef"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"3", "x"}], "-", "2"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", "2"}], ")"}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
    RowBox[{
     RowBox[{"2", "\[Pi]", " ", 
      RowBox[{"\[ImaginaryI]", "(", 
       RowBox[{
        RowBox[{
         SubscriptBox["Res", 
          RowBox[{"x", "->", "\[ImaginaryI]"}]], 
         FractionBox[
          RowBox[{
           RowBox[{"3", "x"}], "-", "2"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", "1"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", "2"}], ")"}]}]]}], "+", 
        RowBox[{
         SubscriptBox["Res", 
          RowBox[{"x", "->", 
           RowBox[{
            SqrtBox["2"], "\[ImaginaryI]"}]}]], 
         FractionBox[
          RowBox[{
           RowBox[{"3", "x"}], "-", "2"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", "1"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", "2"}], ")"}]}]]}]}], ")"}]}], "=", 
     RowBox[{
      RowBox[{"2", "\[Pi]", " ", 
       RowBox[{"\[ImaginaryI]", "(", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"3", "\[ImaginaryI]"}], "-", "2"}], 
          RowBox[{"2", "\[ImaginaryI]"}]], "+", 
         FractionBox[
          RowBox[{
           RowBox[{"3", 
            SqrtBox["2"], "\[ImaginaryI]"}], "-", "2"}], 
          RowBox[{
           RowBox[{"-", "2"}], 
           SqrtBox["2"], "\[ImaginaryI]"}]]}], ")"}]}], "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SqrtBox["2"], "-", "2"}], ")"}], "\[Pi]"}]}]}]}], TraditionalForm]], 
  "InlineMath",ExpressionUUID->"75fdc9a1-c1e9-40c4-b6ac-d2b95e7644eb"],
 ". Confirm with ",
 ButtonBox["Integrate",
  BaseStyle->"Link"],
 ":"
}], "SolutionAnswer",
 CellID->87162741,ExpressionUUID->"2ed5dba4-a21b-445c-a634-94f867deb7c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", "x"}], "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "2"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], 
  "]"}]], "ExerciseInput",
 CellID->377408346,ExpressionUUID->"43b66531-c7c4-41f4-8494-39df63154595"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SqrtBox["2"]}], ")"}], " ", "\[Pi]"}]], "ExerciseOutput",
 CellID->200331810,ExpressionUUID->"e9abad99-11cb-4bd3-b72c-56a50625d585"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["\[Copyright] 2025 Wolfram Media, Inc.", "SmallText",
 CellMargins->{{66, 66}, {20, 100}},
 CellGroupingRules->"SectionGrouping",
 FontSize->12,
 FontColor->RGBColor[
  0.7098039215686275, 0.7098039215686275, 0.7098039215686275],
 CellID->1368449107,ExpressionUUID->"88f10bda-256c-4d31-8aae-4326cebf500e"]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellInsertionPointCell->None,
WindowSize->Automatic,
WindowMargins->Automatic,
WindowFrame->"Normal",
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"26. Definite Integrals | Essentials of Complex Analysis",
DockedCells->{
  Cell[
   BoxData[
    TemplateBox[<|
     "label" -> TemplateBox[<|
        "heading" -> "Wolfram eTextbook Series", "title" -> 
         "Essentials of Complex Analysis"|>, "BannerHeadingTitleTemplate"], 
      "previous" -> TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerLeftArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{
             "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "25. Transcendental Equations"}, "PrettyTooltipTemplate"], "next" -> 
      TemplateBox[{
         TemplateBox[{
           TemplateBox[{}, "BannerRightArrowTemplate"], 
           Function[{}, 
            
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
             FrontEnd`HistoryData :> {
               EvaluationNotebook[]}]]}, "BannerButtonTemplate"], 
         "27. Gamma Function"}, "PrettyTooltipTemplate"], "menu" -> 
      TemplateBox[{
         TemplateBox[{{
           "Cover" :> NotebookLocate[{"ComplexAnalysis-00a_Cover.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "Introduction" :> 
            NotebookLocate[{"ComplexAnalysis-00b_Foreword.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "1. What Is Complex Analysis?" :> 
            NotebookLocate[{
              "ComplexAnalysis-01_What-Is-Complex-Analysis.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "2. The Complex Plane" :> 
            NotebookLocate[{"ComplexAnalysis-02_The-Complex-Plane.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "3. Complex Functions" :> 
            NotebookLocate[{"ComplexAnalysis-03_Complex-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "4. The Exponential Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-04_The-Exponential-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "5. The Argument Function" :> 
            NotebookLocate[{
              "ComplexAnalysis-05_The-Argument-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "6. The Logarithm Function and Complex Powers" :> 
            NotebookLocate[{
              "ComplexAnalysis-06_The-Logarithm-Function-and-Complex-Powers.\
nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "7. Limits and Continuity" :> 
            NotebookLocate[{
              "ComplexAnalysis-07_Limits-and-Continuity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "8. The Point at Infinity" :> 
            NotebookLocate[{
              "ComplexAnalysis-08_The-Point-at-Infinity.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "9. Complex Derivatives" :> 
            NotebookLocate[{"ComplexAnalysis-09_Complex-Derivatives.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "10. The Cauchy\[Dash]Riemann Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-10_The-Cauchy-Riemann-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "11. Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-11_Complex-Line-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "12. Fundamental Theorem for Complex Line Integrals" :> 
            NotebookLocate[{
              "ComplexAnalysis-12_Fundamental-Theorem-for-Complex-Line-\
Integrals.nb", ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "13. Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-13_Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "14. Applications of Cauchy\[CloseCurlyQuote]s Theorem" :> 
            NotebookLocate[{
              "ComplexAnalysis-14_Applications-of-Cauchys-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "15. Cauchy\[CloseCurlyQuote]s Integral Formula" :> 
            NotebookLocate[{
              "ComplexAnalysis-15_Cauchys-Integral-Formula.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "16. Three Important Theorems" :> 
            NotebookLocate[{
              "ComplexAnalysis-16_Three-Important-Theorems.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "17. Harmonic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-17_Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "18. Properties of Harmonic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-18_Properties-of-Harmonic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "19. Power Series" :> 
            NotebookLocate[{"ComplexAnalysis-19_Power-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "20. Taylor Series" :> 
            NotebookLocate[{"ComplexAnalysis-20_Taylor-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "21. Laurent Series" :> 
            NotebookLocate[{"ComplexAnalysis-21_Laurent-Series.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], 
            "22. Holomorphic and Meromorphic Functions" :> 
            NotebookLocate[{
              "ComplexAnalysis-22_Holomorphic-and-Meromorphic-Functions.nb", 
               ""}, FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "23. Residues" :> 
            NotebookLocate[{"ComplexAnalysis-23_Residues.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "24. The Residue Theorem" :> 
            NotebookLocate[{"ComplexAnalysis-24_The-Residue-Theorem.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "25. Transcendental Equations" :> 
            NotebookLocate[{
              "ComplexAnalysis-25_Transcendental-Equations.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "26. Definite Integrals" :> 
            NotebookLocate[{"ComplexAnalysis-26_Definite-Integrals.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "27. Gamma Function" :> 
            NotebookLocate[{"ComplexAnalysis-27_Gamma-Function.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "28. Laplace Transforms" :> 
            NotebookLocate[{"ComplexAnalysis-28_Laplace-Transforms.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "29. Hydrodynamics" :> 
            NotebookLocate[{"ComplexAnalysis-29_Hydrodynamics.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "30. Elliptic Functions" :> 
            NotebookLocate[{"ComplexAnalysis-30_Elliptic-Functions.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "31. Complex Analysis in a Nutshell" :> 
            NotebookLocate[{
              "ComplexAnalysis-31_Complex-Analysis-in-a-Nutshell.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "32. Sample Final Exam" :> 
            NotebookLocate[{"ComplexAnalysis-32_Sample-Final-Exam.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}], "References" :> 
            NotebookLocate[{"ComplexAnalysis-33_References.nb", ""}, 
              FrontEnd`HistoryData :> {
                EvaluationNotebook[]}]}}, "BannerMenuTemplate"], 
         "Table of contents"}, "PrettyTooltipTemplate"]|>, "BannerTemplate"]],
    "DockedCell", "Banner"], 
  Cell[
   BoxData[
    TemplateBox[<|"label" -> "Marco Saragnese  |  Cite this eTextbook"|>, 
     "BannerCitationOpenerTemplate"]], "DockedCell", 
   "BannerCitationOpenerLabel"], 
  Cell[
   BoxData[
    TemplateBox[{
      TemplateBox[{"\"Marco Saragnese (2025), \"", 
        StyleBox[
        "\"Essentials of Complex Analysis: A Computational Approach,\"", 
         Selectable -> True, Copyable -> True, FontSlant -> Italic], 
        "\" Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis.\""}, "RowDefault"], 
      RowBox[{"Marco Saragnese (2025), ", 
        StyleBox[
        "Essentials of Complex Analysis: A Computational Approach,", 
         FontSlant -> "Italic"], 
        " Wolfram Media. \
wolfram-media.com/products/essentials-of-complex-analysis."}]}, 
     "CitationClickToCopy2", BaseStyle -> {LineBreakWithin -> Automatic}]], 
   "DockedCell", "BannerCitation", CellOpen -> Dynamic[
     TrueQ[
      CurrentValue[
       EvaluationNotebook[], {TaggingRules, "eTextbook", "CitationOpener"}, 
       False]]]]},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{612, 792}},
ShowCellBracket->Automatic,
TaggingRules-><|"eTextbook" -> <|"CitationOpener" -> False|>|>,
ShowCellLabel->False,
CellLabelAutoDelete->True,
CellLabelTemplate-><|
 "In" -> "In[`1`]:=", "InExpired" -> "In[`1`]:=", "Out" -> "Out[`1`]=", 
  "OutExpired" -> "Out[`1`]="|>,
ShowCellTags->False,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
AutoStyleOptions->{"HighlightComments"->True},
AutoMultiplicationSymbol->{},
Magnification->1,
FrontEndVersion->"14.3 for Mac OS X ARM (64-bit) (July 1, 2025)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[5]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Appearance -> "PopupMenu",
                Method -> "Queued", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False], 
      Cell[
       StyleData[All, "Printout"], PageWidth :> 700, 
       PrintingOptions -> {"PageSize" -> {504, 720}}, 
       AutoStyleOptions -> {"UndefinedSymbolStyle" -> None}, Magnification -> 
       0.6], 
      Cell[
       StyleData[All, "Invisibles"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       DockedCells -> {
         Cell[
          BoxData[
           GridBox[{{
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]], 
              ActionMenuBox[
              "\"Insert\"", {
               "\"Subsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsectionStyle[]), 
                "\"Subsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsectionStyle[]), 
                "\"Subsubsubsection\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToSubsubsubsectionStyle[]), 
                Delimiter, 
                "\"Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToTextStyle[]), "\"CodeText\"" :> 
                Module[{$CellContext`bn = ButtonNotebook[]}, 
                  If[Developer`CellInformation[$CellContext`bn] =!= $Failed, 
                    While[
                    FreeQ[
                    Developer`CellInformation[$CellContext`bn], 
                    "CellBracket"], 
                    FrontEndExecute[
                    
                    FrontEnd`SelectionMove[$CellContext`bn, All, Cell, 
                    AutoScroll -> False]]]; 
                    SelectionMove[$CellContext`bn, After, Cell]]; 
                  NotebookWrite[$CellContext`bn, 
                    Cell["XXXX", "CodeText"], All]; 
                  SelectionMove[$CellContext`bn, All, CellContents]], 
                "\"Hyperlink\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTGenerateHyperlinkDialog[]), 
                "\"Display Formula\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertDisplayFormulaCell[]), Delimiter, 
                "\"Solved Example\"" :> (Needs["WolframBookTools`"]; 
                 
                 WolframBookTools`\
WBTInsertSolvedExampleAndSolvedExampleNoteCells[]), 
                "\"Solved Example Input\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleInputCell[]), 
                "\"Solved Example Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleNoteCell[]), 
                "\"Solved Example Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolvedExampleDisplayFormulaCell[]),
                 "\"Solved Example Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertSolvedExampleDisplayFormulaNumberedCell[]), Delimiter, 
                "\"Theorem\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremCell[]), 
                "\"Theorem Numbered\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremNumberedCell[]), 
                "\"Theorem Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTheoremTextCell[]), 
                "\"Proof/Theorem Display Formula\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTheoremDisplayCell[]), 
                "\"Proof/Theorem Display Formula Numbered\"" :> (
                 Needs["WolframBookTools`"]; 
                 WolframBookTools`\
WBTInsertProofTheoremDisplayFormulaNumberedCell[]), 
                "\"Proof\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofCell[]), 
                "\"Proof Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertProofTextCell[]), Delimiter, 
                "\"Vocabulary 2Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd2ColTable[]), 
                "\"Vocabulary 3Col\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertVocabularySectionAnd3ColTable[]), 
                "\"Add Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[]), 
                "\"Remove Row\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["RemoveRow" -> True]), 
                "\"Apply Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow["AddDivider" -> True]), 
                "\"Remove Divider\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTVocabTableAddRow[
                  "RemoveDivider" -> True]), Delimiter, 
                "\"Exercises\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSection[]), 
                "\"Exercise Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseNote[]), 
                "\"Solution Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertExerciseSolution[]), 
                "\"Solution Text\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertSolutionAnswer[]), Delimiter, 
                "\"Q&A | Tech Notes | More\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQAndATechNotesMore[]), 
                "\"Question\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertQuestion[]), 
                "\"Answer\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertAnswer[]), 
                "\"Tech Note\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertTechNote[]), 
                "\"More to Explore\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertMoreExplore[]), Delimiter, 
                "\"References Section\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTInsertReferencesSection[]), 
                "\"Add Reference\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTAddReferenceCell[]), Delimiter, 
                "\"Comment\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyComment[])}, Appearance -> 
               "PopupMenu", FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              ActionMenuBox[
              "\"Function Name\"", {
               "\"Link\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTMakeSymbolLink[]), 
                "\"Format\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTFormatSymbol[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ButtonBox[
              "\"Resource Function Link\"", 
               ButtonFunction :> (Needs["WolframBookTools`"]; 
                WolframBookTools`WBTResourceFunctionLink[]), Evaluator -> 
               Automatic, Appearance -> "DialogBox", Method -> "Queued"], 
              ActionMenuBox[
              "\"Inline Format\"", {
               "\"Inline Code\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTConvertToInlineCode[]), 
                "\"Traditional Math\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTTraditionalFormCell[])}, Appearance -> 
               "PopupMenu", Method -> "Queued", FrameMargins -> 2.4], 
              ActionMenuBox[
              "\"Mark Cells\"", {
               "\"Tentative\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyTentative[]), Delimiter, 
                "\"Print Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyPrintOnly[]), 
                "\"Web Only\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyWebOnly[]), Delimiter, 
                "\"Locked\"" :> (Needs["WolframBookTools`"]; 
                 WolframBookTools`WBTApplyLock[])}, Method -> "Queued", 
               FrameMargins -> 2.4], 
              ItemBox["", ItemSize -> Fit], 
              GridBox[{{
                 TooltipBox[
                  ButtonBox[
                  "\"Index Field\"", Appearance -> {"AbuttingRight"}, 
                   ButtonFunction :> (Needs["WolframBookTools`"]; 
                    WolframBookTools`WBTInsertIndexField[]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "First put the cursor in a cell to insert a corresponding \
field above to insert index entries.\nList main index entries corresponding \
to the cell separated by commas. Any associated sub-entries\nshould be put \
immediately after in braces.\nExample: programming{functional, rule based}, \
function, relation, lists{flat, nested}\n If $Language is \"ChineseSimplified\
\", \"ChineseTraditional\", \"Japanese\", \"Korean\" or \"Russian\"\ntwo \
index fields get inserted above a selected cell, the top one for inserting \
entries\nintended for the Englsh index and the bottom for the index in the \
language given by $Language.", TooltipDelay -> 0.3], 
                 TooltipBox[
                  ButtonBox[
                  "\"Toggle\"", Appearance -> {"AbuttingLeft"}, 
                   ButtonFunction :> (CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] = 
                    If[CurrentValue[
                    ButtonNotebook[], ScreenStyleEnvironment] === 
                    "Invisibles", "Working", "Invisibles"]), Evaluator -> 
                   Automatic, Method -> "Queued"], 
                  "Toggles index entry fields.", TooltipDelay -> 0.3]}}, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {
                "ColumnsIndexed" -> {2 -> 0}, "Rows" -> {{Automatic}}}], 
              InterpretationBox[
               StyleBox[
                
                GraphicsBox[{}, BaselinePosition -> Baseline, 
                 ImageSize -> {4, 0}], CacheGraphics -> False], 
               Spacer[4]]}}]], "DockedCell", 
          CellFrameMargins -> {{0, 0}, {8, 8}}]}, CreateCellID -> True, 
       TrackCellChangeTimes -> False, ShowPredictiveInterface -> False, 
       AutoStyleOptions -> {
        "UndefinedSymbolStyle" -> 
         None}, $CellContext`GhostCellInEmptyNotebook -> False]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], 
       PrintingOptions -> {"PageHeaderMargins" -> {28, 28}}, StyleMenuListing -> 
       None, FontFamily -> "Source Sans Pro", FontSize -> 8, FontWeight -> 
       "Regular", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0.45]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       8, FontWeight -> "Bold", FontSlant -> "Plain", 
       PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], WindowToolbars -> {}, PageWidth :> WindowWidth, 
       PrintingOptions -> {
        "FirstPageHeader" -> True, "InnerOuterMargins" -> {30, 30}, 
         "PaperOrientation" -> "Portrait", "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, MenuSortingValue -> 
       None, GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       StyleData["TOCPage"], CellSize -> {40, Inherited}, TextAlignment -> 
       Right, MenuSortingValue -> 20010, StyleMenuListing -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ContentsTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          MenuSortingValue -> 20000, FontFamily -> "Helvetica", FontSize -> 
          36, FontWeight -> "Bold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ContentsTitle", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCTitle"], CellMargins -> {{66, 66}, {4, 14}}, 
          CellGroupingRules -> {"SectionGrouping", 70}, TabSpacings -> 36, 
          CounterIncrements -> "TOCTitle", MenuSortingValue -> 20020, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontWeight -> 
          "Bold", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TOCTitle", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TOCSection"], CellMargins -> {{95, 95}, {1, 1}}, 
          CellGroupingRules -> {"SectionGrouping", 75}, TabSpacings -> 34, 
          CounterIncrements -> "TOCSection", MenuSortingValue -> 20030, 
          FontFamily -> "Source Sans Pro", FontSize -> 16], 
         Cell[
          StyleData["TOCSection", "Printout"]]}, Closed]], 
      Cell[
       StyleData["Leader"], TabFilling -> ".", MenuSortingValue -> 10000, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", FontSize -> 
       18, FontWeight -> "Plain"], 
      Cell[
       StyleData["LeaderNoDots"], TabFilling -> " ", MenuSortingValue -> 
       10000, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       FontSize -> 18, FontWeight -> "Plain"], 
      Cell[
       StyleData["PageLink"], MenuSortingValue -> 10000, StyleMenuListing -> 
       None, ButtonStyleMenuListing -> Automatic, FontFamily -> 
       "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[0.269993, 0.308507, 0.6], 
       ButtonBoxOptions -> {
        Active -> True, Appearance -> {Automatic, None}, 
         ButtonFunction :> (FrontEndExecute[{
            FrontEnd`NotebookLocate[#2]}]& )}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{64, Inherited}, {12, 64}}, 
          CellGroupingRules -> {"SectionGrouping", 30}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{62, 4}, {52, 182}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionSingleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{100, 100}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionSingleDigit", "Printout"], 
          CellMargins -> {{100, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]\[VeryThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionBar"], FontFamily -> "Source Sans Pro", 
          FontWeight -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionBar", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumbered"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Subsection"]}], "SubsectionNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{98, Inherited}, {Inherited, 32}}, 
          CounterIncrements -> "Subsection", FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsectionNumbered", "Printout"], 
          CellMargins -> {{102, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionNumber"], FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          GrayLevel[0.25]], 
         Cell[
          StyleData["SubsectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsectionFirst"], 
          CellMargins -> {{64, Inherited}, {2, 72}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {2, 32}}, 
          FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SubsubsectionTopMargin"], 
          CellMargins -> {{64, Inherited}, {2, 14}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontSlant -> "Italic", 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SubsubsectionTopMargin", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsection"], 
          CellMargins -> {{64, Inherited}, {2, 32}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.45]], 
         Cell[
          StyleData["Subsubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsubsubsection"], 
          CellMargins -> {{66, Inherited}, {2, 10}}, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subsubsubsection", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> 
            "Subsubsubsection"}, CellGroupingRules -> {"SectionGrouping", 70},
           PageBreakBelow -> False, LanguageCategory -> "NaturalLanguage", 
          CounterIncrements -> "Subsubsubsubsection", 
          CounterAssignments -> {{"Item", 0}, {"Subitem", 0}, {
            "Subsubitem", 0}, {"ItemNumbered", 0}, {"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> None, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsubsubsection", "Printout"], 
          CellMargins -> {{66, 66}, {2, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySubsectionSM"], 
          CellFrame -> {{0, 0}, {0.75, 0}}, 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Bold", FontSlant -> 
          "Regular", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["VocabularySubsubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 15}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["GrayPointSix"], FontColor -> GrayLevel[0.6]], 
         Cell[
          StyleData["GrayPointSix", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummarySection"], PageWidth :> WindowWidth, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], MenuSortingValue -> 9000, 
          FontFamily -> "Source Sans Pro", FontSize -> 18, FontSlant -> 
          "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["SummarySection", "Printout"], 
          CellMargins -> {{64, 64}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryNote"], PageWidth :> WindowWidth, 
          CellMargins -> {{64, 64}, {4, 8}}, ReturnCreatesNewCell -> True, 
          PageBreakBelow -> False, MenuSortingValue -> 9010, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryNote", "Printout"], 
          CellMargins -> {{68, 68}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SummaryList"], PageWidth :> WindowWidth, CellDingbat -> 
          Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, 78}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 3, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 9020, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SummaryList", "Printout"], 
          CellMargins -> {{82, 82}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsectionSM"], 
          CellMargins -> {{64, Inherited}, {4, 12}}, 
          CellGroupingRules -> {"SectionGrouping", 61}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ExerciseSubsectionSM", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> False, CellMargins -> {{106, Inherited}, {4, 8}},
           CellGroupingRules -> {"SectionGrouping", 62}, DefaultNewCellStyle -> 
          "ExerciseInput", CounterIncrements -> "Exercise", MenuSortingValue -> 
          10020, MenuCommandKey :> "2", FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{108, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSectionNote"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseSectionNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, LineSpacing -> {1., 1., 2.}, MenuSortingValue -> 10050, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSolution"], ShowGroupOpener -> "Inline", 
          CellMargins -> {{106, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellGroupingRules -> {"SectionGrouping", 62.}, PageBreakBelow -> 
          False, CellChangeTimes -> {3.938884624675207*^9}, 
          LineSpacing -> {1., 1., 2.}, 
          CounterAssignments -> {{"ItemNumbered", 0}}, LineColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          FrontFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          BackFaceColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GraphicsColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro Semibold",
           FontSize -> 14, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["ExerciseSolution", "Printout"], 
          CellMargins -> {{106, Inherited}, {4, 8}}, 
          LineSpacing -> {0.8, 1., 2.}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionAnswer"], CellMargins -> {{106, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["SolutionAnswer", "Printout"], 
          CellMargins -> {{106, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolutionItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], ")"}], FontSize -> 14, FontWeight -> 
            "Regular", FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{122, Inherited}, {2, 4}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["SolutionItem", "Printout"], 
          CellMargins -> {{106, Inherited}, {2, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], CellMargins -> {{64, Inherited}, {2, 12}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], CellMargins -> {{66, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> 
          GrayLevel[0.25], $CellContext`DefaultReturnCreatedCellStyle -> 
          "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSubsection"], 
          CellMargins -> {{64, Inherited}, {2, 10}}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["TechNoteSubsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 14}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteItem"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontSize -> 12, FontWeight -> 
            Bold, FontColor -> GrayLevel[0.25]], 
          CellMargins -> {{93, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          CounterIncrements -> "ItemNumbered", MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNoteItem", "Printout"], 
          CellMargins -> {{93, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteNoDingbat"], 
          CellMargins -> {{82, Inherited}, {4, 8}}, ReturnCreatesNewCell -> 
          True, CellFrameLabelMargins -> 4, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], CellDingbat -> Cell[
            TextData[{"\[FilledSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, CellFrameLabelMargins -> 4, 
          LineSpacing -> {1.25, 1., 2.}, MenuSortingValue -> 10040, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["TechNote", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 1, FontSize -> 
          14], 
         Cell[
          StyleData["TechNoteInput", "Printout"], 
          CellMargins -> {{99, 10}, {3, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TechNoteOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 14], 
         Cell[
          StyleData["TechNoteOutput", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], CellMargins -> {{64, Inherited}, {4, 8}}, 
          ReturnCreatesNewCell -> True, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysSection"], CellFrame -> {{1, 1}, {1, 1}}, 
          CellMargins -> {{52, -12}, {-1, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{16, 8}, {6, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "Bold", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[1], Background -> 
          RGBColor[0.901961, 0.411765, 0.027451]], 
         Cell[
          StyleData["TakeawaysSection", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysHeader"], 
          CellMargins -> {{64, Inherited}, {5, 15}}, 
          CellFrameMargins -> {{8, 8}, {5, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontWeight -> "SemiBold", 
          FontSlant -> "Regular", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysHeader", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysTable"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{52, -12}, {12, -1}}, ReturnCreatesNewCell -> True, 
          CellFrameMargins -> {{18, 12}, {20, 12}}, CellFrameLabelMargins -> 
          6, LineSpacing -> {1.25, 1., 2.}, SpanMaxSize -> 1, FontFamily -> 
          "Source Sans Pro Light", FontColor -> GrayLevel[0.25], Background -> 
          RGBColor[1., 0.9490196078431372, 0.8509803921568627], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"TakeawaysDingbat", Inherited}, 
              "Rows" -> {{SpanFromLeft, Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.75}}}}], 
         Cell[
          StyleData["TakeawaysTable", "Printout"], 
          CellMargins -> {{51.5, -12.5}, {12, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TakeawaysText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["TakeawaysText", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TakeawaysDingbat", StyleDefinitions -> StyleData["Text"]], 
          FontFamily -> "Source Sans Pro", FontSize -> 10, FontWeight -> 
          "SemiBold", FontColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["TakeawaysDingbat", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeText", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 10}, {3, 15}}, LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 1540, 
          MenuCommandKey :> $CellContext`MenuKey[
           "7", $CellContext`Modifiers -> {"Shift"}], FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeText", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], LineSpacing -> {1, 1, 1}, 
          MenuSortingValue -> 10010, MenuCommandKey :> "1", FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DisplayFormula"], CellMargins -> {{99, 15}, {2, 12}}, 
          StripStyleOnPaste -> True, DefaultFormatType -> 
          DefaultInputFormatType, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           LanguageCategory -> "Formula", ScriptLevel -> 0, 
          SingleLetterItalics -> True, MenuSortingValue -> 1700, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> GrayLevel[0.2], 
          UnderoverscriptBoxOptions -> {LimitsPositioning -> True}], 
         Cell[
          StyleData["DisplayFormula", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "DisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["DisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Inherited}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, 6}, {Inherited, Inherited}}, 
          TextAlignment -> Left, CounterIncrements -> 
          "DisplayFormulaNumbered", MenuSortingValue -> 1710, FontFamily -> 
          "Baskerville", FontSize -> 16, FontWeight -> "Regular", FontSlant -> 
          "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}], 
         Cell[
          StyleData["DisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{99, 19}, {Inherited, Inherited}}, 
          CellFrameMargins -> {{Inherited, Inherited}, {
            Inherited, Inherited}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Print"], CellMargins -> {{99, 10}, {4, 4}}, FontSize -> 
          15], 
         Cell[
          StyleData["Print", "Presentation"], 
          CellMargins -> {{100, Inherited}, {1.5 Inherited, 1.5 Inherited}}], 
         
         Cell[
          StyleData["Print", "SlideShow"], 
          CellMargins -> {{
            0.135 FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}], 0.01 
             FrontEnd`AbsoluteCurrentValue[{WindowSize, 1}]}, {8, 15}}, 
          FontSize -> 18], 
         Cell[
          StyleData["Print", "Condensed"], 
          CellMargins -> {{18, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "Printout"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Print", "PrintoutGray"], 
          CellMargins -> {{49, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Item"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontFamily -> Automatic, FontSize -> 
            18, FontWeight -> GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{81, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "Subitem", "*" -> "Subitem"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "Item", 
          CounterAssignments -> {{"Subitem", 0}, {"Subsubitem", 0}}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15], 
         Cell[
          StyleData["Item", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{80, Inherited}, {Inherited, Inherited}}, 
          CellDingbatMargin -> 2, 
          CellGroupingRules -> {
           "GroupTogetherNestedGrouping", 1.073741821*^9}, 
          CellChangeTimes -> {{3.8855684925344043`*^9, 
           3.885568495926271*^9}, {3.885643888233819*^9, 
           3.885643900721007*^9}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemParagraph"], CellMargins -> {{81, 10}, {4, 1}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          MenuSortingValue -> 1600, FontFamily -> "Source Sans Pro", FontSize -> 
          15, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["ItemParagraph", "Printout"], 
          CellMargins -> {{80, Inherited}, {Inherited, 0.5 Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ItemNumbered"], CellDingbat -> Cell[
            TextData[{
              CounterBox["ItemNumbered"], "."}], FontWeight -> "Bold"], 
          CellMargins -> {{85, 10}, {4, 8}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemNumbered"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameLabelMargins -> 4, CounterIncrements -> "ItemNumbered", 
          CounterAssignments -> {{"SubitemNumbered", 0}, {
            "SubsubitemNumbered", 0}}, MenuSortingValue -> 1630, FontFamily -> 
          "Source Sans Pro", FontSize -> 15], 
         Cell[
          StyleData["ItemNumbered", "Printout"], 
          CellMargins -> {{90, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, 12}, {4, 4}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Tab" -> "Subsubitem", "*" -> "Subsubitem", "Backspace" -> 
            "Item", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Item"}, 
          CellGroupingRules -> {"ItemGrouping", 80}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subitem", 
          CounterAssignments -> {{"Subsubitem", 0}}, MenuSortingValue -> 1610,
           FontFamily -> "Source Sans Pro", FontSize -> 14], 
         Cell[
          StyleData["Subitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 17, FontFamily -> 
            "Automatic", FontWeight -> "Black", 
            RGBColor[
            0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          CellMargins -> {{105, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubitem"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            RGBColor[0.6, 0.6, 0.6]], CellMargins -> {{129, 12}, {4, 4}}, 
          ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {
           "Backspace" -> 
            "Subitem", $CellContext`KeyEvent[
             "Tab", $CellContext`Modifiers -> {"Shift"}] -> "Subitem"}, 
          CellGroupingRules -> {"ItemGrouping", 90}, CellFrameLabelMargins -> 
          4, CounterIncrements -> "Subsubitem", MenuSortingValue -> 1620, 
          FontFamily -> "Source Sans Pro", FontSize -> 13], 
         Cell[
          StyleData["Subsubitem", "Printout"], CellDingbat -> 
          StyleBox[
           "\:203a", Alignment -> Baseline, FontSize -> 18, FontWeight -> 
            GrayLevel[0], 
            GrayLevel[0.65]], 
          CellMargins -> {{129, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Note"], CellFrame -> {{0, 0}, {0, 1}}, 
          CellMargins -> {{66, 0}, {8, 6}}, ReturnCreatesNewCell -> True, 
          StyleKeyMapping -> {"Tab" -> "SubitemParagraph"}, 
          CellGroupingRules -> {"GroupTogetherNestedGrouping", 15000}, 
          CellFrameMargins -> {{14, 14}, {12, 12}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          LineSpacing -> {1.2, 1., 2.}, MenuSortingValue -> 1600, FontFamily -> 
          "Source Sans Pro", FontSize -> 15, FontColor -> GrayLevel[0.2], 
          Background -> RGBColor[1., 0.9647058823529412, 0.9411764705882353]], 
         Cell[
          StyleData["Note", "Printout"], CellMargins -> {{66, 0}, {10, 8}}, 
          FontSize -> 14]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Echo"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["Echo", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EchoTiming"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}], 
         Cell[
          StyleData["EchoTiming", "Printout"], 
          CellMargins -> {{99, Inherited}, {Inherited, Inherited}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Epigraph"], CellMargins -> {{100, 78}, {6, 24}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, TextAlignment -> Left, Hyphenation -> 
          True, HyphenationOptions -> {"HyphenationMinLengths" -> {3, 5}}, 
          LineSpacing -> {1, 2}, TabSpacings -> {1.2, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontWeight -> "Plain", FontSlant -> 
          "Plain"], 
         Cell[
          StyleData["Epigraph", "Printout", StyleDefinitions -> None]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EpigraphAuthor"], CellMargins -> {{125, 100}, {12, 12}}, 
          TextAlignment -> Left, LineSpacing -> {1, 2}, 
          ParagraphIndent -> -17, TabSpacings -> {1.5, 2.5}, FontFamily -> 
          "Source Sans Pro", FontSize -> 16, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontTracking -> -0.05], 
         Cell[
          StyleData["EpigraphAuthor", "Printout", StyleDefinitions -> None]]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ReferenceSection"], CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ReferenceSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Reference"], CellDingbat -> Cell[
            TextData[{
              CounterBox["Reference"]}], "SR", FontSize -> 13, 
            CellSize -> {30, Inherited}, TextAlignment -> Right], 
          CellMargins -> {{80, 10}, {3, 4}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, 
          CellFrameLabelMargins -> 8, 
          CellChangeTimes -> {{3.738599543211059*^9, 3.738599549834622*^9}}, 
          LineSpacing -> {1, 2}, ParagraphIndent -> -8, 
          TabSpacings -> {0.7, 2.5}, CounterIncrements -> "Reference", 
          MenuSortingValue -> 1870, FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Plain", FontSlant -> "Plain"], 
         Cell[
          StyleData["Reference", "Printout", StyleDefinitions -> None], 
          CellMargins -> {{66, 10}, {3, 4}}, TabSpacings -> {1.2, 2.5}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TextFirst"], CellMargins -> {{66, 10}, {4, 72}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Baskerville", FontSize -> 
          18, FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 12}}, 
          ReturnCreatesNewCell -> True, 
          CellChangeTimes -> {{3.968834509197134*^9, 3.968834509700926*^9}}, 
          FontFamily -> "Baskerville", FontSize -> 18, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`]], 
         Cell[
          StyleData["Text", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SmallText"], CellMargins -> {{66, 10}, {6, 6}}, 
          LineSpacing -> {1, 3}, TabSpacings -> {2.5}, LanguageCategory -> 
          "NaturalLanguage", CounterIncrements -> "SmallText", 
          MenuSortingValue -> 1750, StyleMenuListing -> None, FontFamily -> 
          "Source Sans Pro", FontSize -> 14, FontColor -> GrayLevel[0.2]], 
         Cell[
          StyleData["SmallText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}, Hyphenation -> True]}, Closed]], 
      
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          ReturnCreatesNewCell -> True, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Italic", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, CellEpilog :> 
          Quiet[Needs["WolframBookTools`"]; 
            WolframBookTools`AddCaptionsToRegeneratedOutput[]], SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       StyleData["InitializationCell"], Background -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{18, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Roboto", FontSize -> 9, FontWeight -> "Regular", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.3]]}, Closed]], 
      Cell[
       StyleData[
       "CellLabelExpired", StyleDefinitions -> StyleData["CellLabel"]], 
       CellLabelMargins -> 6, FontSlant -> Italic, FontTracking -> 0.4, 
       FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["IconizedDefaultName"], FontSize -> 12, 
       PrivateFontOptions -> {"OperatorSubstitution" -> False}, FontColor -> 
       GrayLevel[0.15]], 
      Cell[
       StyleData["IconizedFrame"], 
       TemplateBoxOptions -> {
        DisplayFunction -> (
          FrameBox[#, BaselinePosition -> Baseline, 
           FrameMargins -> {{0, 0}, {1, 1}}, FrameStyle -> GrayLevel[0.65], 
           Background -> GrayLevel[0.96], RoundingRadius -> 4, 
           DefaultBaseStyle -> {
            "DialogStyle", FontFamily -> "Roboto", FontSize -> 11}]& ), 
         Tooltip -> None}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", StripStyleOnPaste -> True, PageBreakWithin -> False, 
          GroupPageBreakWithin -> False, GeneratedCell -> True, 
          CellAutoOverwrite -> True, ShowCellLabel -> False, 
          DefaultFormatType -> DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221]], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{106, 10}, {4, 7}}, 
          GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, 
          ShowCellLabel -> False, SpanMaxSize -> 1, FontSize -> 14], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{106, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{106, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{106, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Comment"], FontFamily -> "Verdana", FontSize -> 13, 
          FontColor -> RGBColor[0.3, 0.3, 0.2], Background -> 
          RGBColor[1, 0.9, 0.8]], 
         Cell[
          StyleData["Comment", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Suggestion"], 
          CellFrameLabels -> {{Inherited, Inherited}, {Inherited, 
             Cell[
              BoxData[
               TagBox[
                GridBox[{{
                   ButtonBox[
                   "\"  Insert  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`ReplaceWithSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    ContentPadding -> False, Appearance -> Automatic, Method -> 
                    "Queued"], 
                   ButtonBox[
                   "\"  Stet  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; DocuTools`StetSuggestion[]), 
                    Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "    ", 
                   ButtonBox[
                   "\"  Next  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindNextSuggestion[]), Evaluator -> Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], 
                   ButtonBox[
                   "\"  Previous  \"", 
                    ButtonFunction :> (Needs["DocuTools`"]; 
                    DocuTools`DocuToolsLoader[]; 
                    DocuTools`FindPreviousSuggestion[]), Evaluator -> 
                    Automatic, 
                    BaseStyle -> {FontSize -> 10, FontFamily -> "Verdana"}, 
                    Appearance -> Automatic, Method -> "Queued"], "\"\""}}, 
                 AutoDelete -> False, 
                 GridBoxItemSize -> {
                  "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
                "Grid"]], ShowStringCharacters -> False, Background -> 
              None]}}, Background -> RGBColor[1, 0.8, 0.8]], 
         Cell[
          StyleData["Suggestion", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Tentative"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[
          0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
         "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
       StyleMenuListing -> None, Background -> 
       RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["PrintOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.89, 0.867, 0.99], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.89, 0.867, 0.99]], 
         Cell[
          StyleData["PrintOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Open]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["IndexField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["IndexField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExplanationField"], CellFrame -> True, CellFrameColor -> 
          GrayLevel[0.7], FontFamily -> "Verdana", FontSize -> 12], 
         Cell[
          StyleData["ExplanationField", "Invisibles"], CellFrame -> False, 
          ShowCellBracket -> False, CellOpen -> False, FontSize -> 1]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["EnglishHighlight"], FontFamily -> "WolframCodeSans"], 
         Cell[
          StyleData["EnglishHighlight", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExample"], CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 25}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExample", FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExample", "Printout"], 
          CellMargins -> {{66, 0}, {0, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleNote", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleNote", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, TextAlignment -> 
          Left, LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 
          14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["SolvedExampleDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "SolvedExampleDisplayFormulaNumbered", 
          FontSize -> 14, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          GeneratedCellStyles -> {
           "Message" -> "SolvedExampleMessage", "Output" -> 
            "SolvedExampleOutput"}, 
          CellFrameMargins -> {{32, Inherited}, {3, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleInput", "Printout"], 
          CellMargins -> {{66, 0}, {0, -7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "SolvedExampleOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {14, 7}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleOutput", "Printout"], 
          CellMargins -> {{66, 0}, {6, -6}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SolvedExampleMessage"], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontColor -> 
          RGBColor[
           0.050002574846150734`, 0.050002574846150734`, 
            0.050002574846150734`], Background -> Hue[0.085, 0.07, 0.95]], 
         Cell[
          StyleData["SolvedExampleMessage", "Printout"], 
          CellMargins -> {{66, 0}, {0, -6}}]}, Closed]], 
      Cell[
       StyleData["SolvedExampleEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, 
       LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 2, 
       FontColor -> 
       RGBColor[
        0.050002574846150734`, 0.050002574846150734`, 0.050002574846150734`], 
       Background -> Hue[0.085, 0.07, 0.95]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Theorem"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 16}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 25}}, 
          CellChangeTimes -> {3.968922600990673*^9}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "Subsection", FontFamily -> "Source Sans Pro", 
          FontSize -> 16.5, FontWeight -> "SemiBold", FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Theorem", "Printout"], CellMargins -> {{66, 0}, {0, 16}},
           CellChangeTimes -> {{3.965900023638689*^9, 
           3.965900023829352*^9}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "TheoremStatement", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["TheoremStatement", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormula", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, Inherited}, {12, 8}}, 
          CellFrameLabelMargins -> {{Inherited, -26}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormula", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ProofTheoremDisplayFormulaNumbered", StyleDefinitions -> 
           StyleData["DisplayFormula"]], CellMargins -> {{66, 40}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{32, 46}, {12, 8}}, 
          CellFrameLabels -> {{None, 
             Cell[
              TextData[{"(", 
                CounterBox["ProofTheoremDisplayFormulaNumbered"], ")"}], 
              "DisplayFormulaEquationNumber", CellSize -> {36, Automatic}]}, {
            None, None}}, 
          CellFrameLabelMargins -> {{Inherited, -46}, {Inherited, Inherited}},
           TextAlignment -> Left, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, 
          CounterIncrements -> "ProofTheoremDisplayFormulaNumbered", 
          MenuSortingValue -> 1710, FontFamily -> "Baskerville", FontSize -> 
          14, FontWeight -> "Regular", FontSlant -> "Plain", 
          PrivateFontOptions -> {"FontPostScriptName" -> "Automatic"}, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofTheoremDisplayFormulaNumbered", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Proof"], Editable -> False, 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {0, 20}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontFamily -> 
          "Source Sans Pro", FontSize -> 16.5, FontWeight -> "SemiBold", 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996], 
          GridBoxOptions -> {
           GridBoxAlignment -> {
             "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{Automatic}}, "RowsIndexed" -> {2 -> 0}}}, 
          GraphicsBoxOptions -> {
           ImagePadding -> None, ImageSize -> {900, 1}, PlotRangePadding -> 
            0}], 
         Cell[
          StyleData["Proof", "Printout"], CellMargins -> {{66, 0}, {0, 0}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ProofContent", StyleDefinitions -> StyleData["Text"]], 
          CellMargins -> {{66, 30}, {0, 0}}, 
          CellBracketOptions -> {"OverlapContent" -> True}, 
          CellFrameMargins -> {{25, 13}, {10, 10}}, 
          LightDarkAutoColorRules -> <|"AllColors" -> True|>, FontSize -> 17, 
          FontColor -> 
          RGBColor[
           0.00010000076130382223`, 0.007800042619928998, 
            0.13000297516585294`], Background -> Hue[0.57, 0.098, 0.996]], 
         Cell[
          StyleData["ProofContent", "Printout"], 
          CellMargins -> {{66, 0}, {0, 0}}]}, Closed]], 
      Cell[
       StyleData["ProofTheoremEndCap"], CellMargins -> {{66, 30}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 20}, 
       CellFrameMargins -> {{10, 13}, {0, 0}}, FontSize -> 2, FontColor -> 
       RGBColor[
        0.00010000076130382223`, 0.007800042619928998, 0.13000297516585294`], 
       Background -> Hue[0.57, 0.098, 0.996]], 
      Cell[
       StyleData["Banner", StyleDefinitions -> StyleData["Text"]], Editable -> 
       False, WindowToolbars -> {}, PageWidth :> WindowWidth, 
       Alignment -> {{Left, Right}, {Center, Center}}, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 0}, CellContext -> CellGroup, 
       CellFrameMargins -> {{0, 20}, {5, 0}}, CellFrameColor -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 20, FontWeight -> "SemiBold", FontColor -> GrayLevel[1], 
       Background -> 
       RGBColor[
        0.00009999889888604668, 0.1607913972623736, 0.4000129703059972]], 
      Cell[
       StyleData[
       "BannerCitationOpenerLabel", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellGroupingRules -> {"SectionGrouping", 70}, CellContext -> CellGroup,
        CellFrameMargins -> {{28, 0}, {4, 5}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData["BannerCitation", StyleDefinitions -> StyleData["Text"]], 
       WindowToolbars -> {}, Selectable -> True, PageWidth :> WindowWidth, 
       CellFrame -> {{0, 1}, {0, 0}}, ShowCellBracket -> False, 
       CellMargins -> {{0, 0}, {0, -1}}, 
       CellElementSpacings -> {"CellMinHeight" -> 2, "ClosedCellHeight" -> 1},
        Copyable -> True, CellContext -> CellGroup, 
       CellFrameMargins -> {{28, 0}, {8, 0}}, CellFrameColor -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761], 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 11, FontWeight -> "Bold", FontColor -> 
       RGBColor[
        0.27843797333540327`, 0.40392625458540327`, 0.5137851263583065], 
       Background -> 
       RGBColor[0.8627719122171761, 0.9333285528421761, 0.9999789434671761]], 
      
      Cell[
       StyleData[
       "BannerPreReleaseLabel", StyleDefinitions -> 
        StyleData["BannerCitationOpenerLabel"]], 
       CellFrameMargins -> {{0, 30}, {2, 0}}, 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["BannerHeading"], MenuSortingValue -> None, FontFamily -> 
       "Source Sans Pro", FontSize -> 11, FontWeight -> "Regular", FontColor -> 
       RGBColor[
        0.9999903558940054, 0.5650486394018294, 0.14501301402226988`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["DateObject"], ContextMenu -> 
       FEPrivate`FrontEndResource["ContextMenus", "DateObject"], 
       TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
           
           StyleBox[#, "Text", FontFamily -> "Source Sans Pro", FontSize -> 
            13, FontWeight -> "Plain", FontColor -> 
            RGBColor[
             0.12941176470588237`, 0.34509803921568627`, 
              0.43529411764705883`], ShowStringCharacters -> False], 
           Background -> Hue[0.11, 0, 0.97], FrameMargins -> {{5, 5}, {2, 2}},
            FrameStyle -> GrayLevel[0.65], RoundingRadius -> 2, 
           BaselinePosition -> Baseline, 
           BaseStyle -> {FontFamily -> "Courier"}]& ), 
         InterpretationFunction -> (#2& )}], 
      Cell[
       StyleData["DateObjectLabel"], FontWeight -> "Plain", FontColor -> 
       GrayLevel[0.2]], 
      Cell[
       StyleData["SummaryItemAnnotation"], FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["Caption"], FontFamily :> CurrentValue["PanelFontFamily"], 
       FontSize :> 0.8 Inherited, FontWeight -> "Plain", FontSlant -> "Plain",
        FontColor :> CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["GraphicsEmbeddedCaption"], LineIndent -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 14], 
      Cell[
       StyleData["SummaryPanel"], FontFamily :> 
       CurrentValue["PanelFontFamily"], FontSize :> 0.8 Inherited, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor :> 
       CurrentValue[{"SystemColors", "DialogText"}], 
       TemplateBoxOptions -> {DisplayFunction -> (ButtonBox[
           
           FrameBox[#, FrameStyle -> GrayLevel[0.5], Background -> 
            GrayLevel[0.969], FrameMargins -> 7, RoundingRadius -> 3, 
            BaselinePosition -> Baseline], Active -> False, Alignment -> Left,
            Appearance -> None, BaseStyle -> {Deployed -> False}, 
           DefaultBaseStyle -> {"Pane", Background -> None}, BaselinePosition -> 
           Baseline]& ), Tooltip -> None}, 
       GraphicsBoxOptions -> {
        Axes -> False, 
         DefaultBaseStyle -> {
          "GraphicsNoFontsOrMenu", CacheGraphics -> False}, ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}, 
       Graphics3DBoxOptions -> {
        Axes -> False, DefaultBaseStyle -> {"Graphics3DNoFontsOrMenu"}, 
         ImageSize -> 
         Dynamic[{
           Automatic, 
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}]}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["StandardForm"], LineSpacing -> {1.25, 0, 2}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["StandardForm", "Printout"], LineSpacing -> {1.25, 0, 2}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["OutputForm"], LineSpacing -> {0.6, 1}, FontFamily -> 
          "Source Sans Code"], 
         Cell[
          StyleData["OutputForm", "Printout"], LineSpacing -> {0.6, 1}, 
          FontFamily -> "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputForm"], FontFamily -> "Source Sans Code"], 
         Cell[
          StyleData["InputForm", "Printout"], FontFamily -> 
          "Source Sans Code"]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FormattedFunction"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]]], 
         Cell[
          StyleData["FormattedFunction", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}], 
         Cell[
          StyleData["Link", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {#}]]& ), ButtonNote -> 
            ButtonData, Evaluator -> None, ImageSize -> Full, Method -> 
            "Preemptive"}]}, Open]], 
      Cell[
       StyleData[
       "CaptionFunctionLink", StyleDefinitions -> StyleData["Link"]], 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup["ref/" <> #]]& ), ButtonSource -> 
            ButtonContents, Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["FunctionLink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["FunctionLink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "FunctionHyperlink", StyleDefinitions -> StyleData["Link"]], 
          FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["FunctionHyperlink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ResourceFunctionlink", StyleDefinitions -> StyleData["Hyperlink"]],
           MenuSortingValue -> None, FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourceFunctionlink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Crosslink"], 
          ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
               
               NotebookLocate[#2, "OpenInNewWindow" -> 
                CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None,
             Method -> "Queued"}], 
         Cell[
          StyleData["Crosslink", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeLink"], 
          ButtonBoxOptions -> {
           Active -> True, Appearance -> {Automatic, None}, 
            ButtonFunction :> (FEPrivate`FrontEndExecute[
              FrontEndToken["OpenHelpLink", {
                Part[#, 1]}]]& ), ButtonNote -> ButtonData, Evaluator -> None,
             ImageSize -> Full, Method -> "Preemptive"}], 
         Cell[
          StyleData["CodeLink", "Printout"]]}, Open]], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineMath"], SpanMaxSize -> 0, CellID -> 644119144], 
      Cell[
       StyleData["InlineCode"], AutoSpacing -> True, SpanMaxSize -> 0, 
       FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.94 Inherited], 
      Cell[
       StyleData["InlineFormula"]], 
      Cell[
       StyleData["NoLabel"], 
       GeneratedCellStyles -> {"Output" -> "ExerciseOutput"}, ShowCellLabel -> 
       False], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["DialogElementName"], 
       CellChangeTimes -> {3.642251807158844*^9, 3.8358753610849867`*^9, 
        3.835875471581566*^9}, FontFamily -> "Source Sans Pro SemiBold", 
       FontSize -> 0.95 Inherited, FontWeight -> "Regular"], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariable"], FontFamily -> "Times", FontSize -> 
          1.05 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeVariableLrg"], FontFamily -> "Times", FontSize -> 
          1.1 Inherited, FontWeight -> "Plain", FontSlant -> "Italic"], 
         Cell[
          StyleData["CodeVariableLrg", "Printout"]]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-1, -1}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Open]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontSize -> 0.85 Inherited, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    PaneBox[
                    StyleBox[#4, "EntityTypeLabel"], BaselinePosition -> 
                    Baseline, ContentPadding -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               Directive[
                 RGBColor[1., 0.504768, 0.], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Entity"], 
          AutoStyleOptions -> {"HighlightSyntaxErrors" -> False}, 
          ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Helvetica", FontSize -> 0.85 Inherited, FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> Directive[
                 RGBColor[0.94227, 0.703639, 0.033387], 
                 AbsoluteThickness[1]], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4, 
               BaseStyle -> {FontFamily -> "Courier"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}, 
              TooltipDelay -> 0.4]& ), Editable -> False, 
            InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Open]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell["Template Boxes", "Section"], 
      Cell[
       StyleData["BannerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              Slot["label"], 
              Slot["previous"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["next"], 
              TemplateBox[{10}, "Spacer1"], 
              Slot["menu"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}], 
      Cell[
       StyleData["BannerHeadingTitleTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (PanelBox[
           TagBox[
            GridBox[{{
               StyleBox[
                Slot["heading"], "BannerHeading", StripOnInput -> False]}, {
               Slot["title"]}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
             DefaultBaseStyle -> "Column", 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{0.2}}}], "Column"], 
           Appearance -> None, ContentPadding -> False, BaseStyle -> "Banner",
            FrameMargins -> {{18, 20}, {6, 6}}, 
           ImageSize -> {Full, Automatic}]& )}], 
      Cell[
       StyleData["BannerButtonTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           
           PanelBox[#, ContentPadding -> False, 
            FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, BaseStyle -> 
            Dynamic[
              FEPrivate`If[
               CurrentValue["MouseOver"], {
               Background -> 
                RGBColor[
                 0.08808648687787803, 0.3397116701677621, 
                  0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
           ButtonFunction -> #2, Appearance -> None, 
           FrameMargins -> {{0, 0}, {-1, -1}}, Enabled -> True, Evaluator -> 
           Automatic, Method -> "Preemptive"]& )}], 
      Cell[
       StyleData["BannerLeftArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{25, 180}, {-25, 0}, {25, -180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["BannerRightArrowTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (GraphicsBox[{
            CapForm["Round"], 
            JoinForm["Round"], 
            Thickness[0.1], 
            GrayLevel[1], 
            LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
           Method -> {"ShrinkWrap" -> True}, ImageSize -> 12, 
            PlotRange -> {{-75, 100}, {-275, 400}}, AspectRatio -> 1}]& )}], 
      Cell[
       StyleData["PrettyTooltipTemplate"], 
       TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[#, 
           FrameBox[
            
            StyleBox[#2, FontFamily -> "Source Sans Pro", FontColor -> 
             RGBColor[0.53725, 0.53725, 0.53725], FontSize -> 12, FontWeight -> 
             "Plain", FontTracking -> "Plain", StripOnInput -> False], 
            Background -> RGBColor[0.96078, 0.96078, 0.96078], FrameStyle -> 
            RGBColor[0.89804, 0.89804, 0.89804], FrameMargins -> 8, 
            StripOnInput -> False], TooltipDelay -> 0.1, 
           TooltipStyle -> {Background -> None, CellFrame -> 0}]& )}], 
      Cell[
       StyleData["BannerMenuTemplate"], 
       LightDarkAutoColorRules -> <|"MarkedColors" -> True|>, 
       TemplateBoxOptions -> {DisplayFunction :> (ActionMenuBox[
           TagBox[
            PanelBox[
             GraphicsBox[{
               CapForm["Round"], 
               GrayLevel[1], 
               AbsoluteThickness[3.2], 
               LineBox[{{0, 0}, {2, 0}}], 
               LineBox[{{0, 1}, {2, 1}}], 
               LineBox[{{0, 2}, {2, 2}}]}, ImageSize -> {27, Automatic}, 
              AspectRatio -> 0.62], ContentPadding -> False, 
             FrameMargins -> {{10, 10}, {7, 7}}, Appearance -> None, 
             BaseStyle -> Dynamic[
               FEPrivate`If[
                CurrentValue["MouseOver"], {
                Background -> 
                 RGBColor[
                  0.08808648687787803, 0.3397116701677621, 
                   0.5610151372105242]}, "Banner"], Evaluator -> "System"]], 
            MouseAppearanceTag["LinkHand"]], #, Appearance -> None]& )}], 
      Cell[
       StyleData["BannerCitationOpenerTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (ButtonBox[
           TagBox[
            GridBox[{{
               Slot["label"], 
               PaneSelectorBox[{True -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-180, 25}, {0, -25}, {180, 25}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 11, 
                    PlotRange -> {{-275, 400}, {-75, 100}}, AspectRatio -> 
                    1}], False -> GraphicsBox[{
                    CapForm["Round"], 
                    JoinForm["Round"], 
                    Thickness[0.18], 
                    GrayLevel[0.7], 
                    LineBox[{{-25, -180}, {25, 0}, {-25, 180}}]}, {
                   Method -> {"ShrinkWrap" -> True}, ImageSize -> 8, 
                    PlotRange -> {{-75, 100}, {-475, 200}}, AspectRatio -> 
                    1}]}, 
                Dynamic[
                 CurrentValue[
                  EvaluationNotebook[], {
                  TaggingRules, "eTextbook", "CitationOpener"}]]]}}, 
             GridBoxAlignment -> {"Rows" -> {{Baseline}}}, AutoDelete -> 
             False, GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
           ButtonFunction :> (CurrentValue[
              EvaluationNotebook[], {
              TaggingRules, "eTextbook", "CitationOpener"}] = Not[
              TrueQ[
               CurrentValue[
                EvaluationNotebook[], {
                TaggingRules, "eTextbook", "CitationOpener"}]]]), Appearance -> 
           None, Evaluator -> Automatic, Method -> "Preemptive", BaseStyle -> 
           "BannerCitationOpenerLabel"]& )}], 
      Cell[
       StyleData["CitationClickToCopy2"], 
       TemplateBoxOptions -> {DisplayFunction -> (TagBox[
           DynamicModuleBox[{Typeset`boxobj$$, Typeset`cellobj$$}, 
            TagBox[
             TagBox[
              ButtonBox[
               
               TagBox[#, BoxForm`Undeploy, 
                DefaultBaseStyle -> {Deployed -> False}], ButtonFunction :> 
               FrontEndExecute[{
                  CopyToClipboard[
                   Cell[
                    TextData[#2], "Text", 
                    LinebreakAdjustments -> {0.85, 2, 10, 0, 1}, 
                    DefaultFormatType -> DefaultTextFormatType, 
                    TextClipboardType -> "PlainText", StripStyleOnPaste -> 
                    True, PageBreakWithin -> False, GroupPageBreakWithin -> 
                    False, LanguageCategory -> None, 
                    HyphenationOptions -> {"HyphenationCharacter" -> ""}]], 
                  NotebookDelete[Typeset`cellobj$$], 
                  FrontEnd`AttachCell[Typeset`boxobj$$, 
                   Cell[
                    BoxData[
                    TemplateBox[{"Copied"}, "ClickToCopyTooltip"]]], {
                   1, {Center, Bottom}}, {Center, Top}, 
                   "ClosingActions" -> {"ParentChanged", "MouseExit"}]}], 
               Evaluator -> None, 
               Appearance -> {
                "Default" -> None, "Hover" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, "Hover.9.png"],
                  "Pressed" -> 
                 FrontEnd`FileName[{"Typeset", "ClickToCopy"}, 
                   "Pressed.9.png"]}, BaseStyle -> {}, DefaultBaseStyle -> {},
                BaselinePosition -> Baseline, FrameMargins -> 2, Method -> 
               "Preemptive"], 
              
              EventHandlerTag[{
               "MouseEntered" :> (Typeset`cellobj$$ = MathLink`CallFrontEnd[
                   FrontEnd`AttachCell[Typeset`boxobj$$, 
                    Cell[
                    BoxData[
                    TemplateBox[{"Copy"}, "ClickToCopyTooltip"]]], {
                    1, {Center, Bottom}}, {Center, Top}, 
                    "ClosingActions" -> {"ParentChanged"}]]), "MouseExited" :> 
                NotebookDelete[Typeset`cellobj$$], PassEventsDown -> True, 
                Method -> "Preemptive", PassEventsUp -> True}]], 
             MouseAppearanceTag["LinkHand"]], 
            Initialization :> (Typeset`boxobj$$ = EvaluationBox[]), 
            DynamicModuleValues :> {}, 
            UnsavedVariables :> {Typeset`boxobj$$, Typeset`cellobj$$}, 
            BaseStyle -> {Editable -> False}], Deploy, DefaultBaseStyle -> 
           "Deploy"]& ), 
         InterpretationFunction -> (RowBox[{"ClickToCopy", "[", 
            RowBox[{#, ",", #2}], "]"}]& ), Tooltip -> None}], 
      Cell[
       StyleData["BannerPreReleaseTemplate"], 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           GridBox[{{
              PanelBox[
               StyleBox[
                Slot["author"], FontWeight -> "SemiBold"], BaseStyle -> 
               "BannerPreReleaseLabel", Appearance -> None, ContentPadding -> 
               False, FrameMargins -> {{18, 20}, {6, 6}}, 
               ImageSize -> {Full, Automatic}], 
              TemplateBox[{"Provide Feedback \[RightGuillemet]", {
                 URL[
                  Slot["url"]], None}, 
                Slot["url"], "BannerPreReleaseLabel", {"HyperlinkActive"}, {
                Appearance -> None}}, "HyperlinkTemplate"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Left, Right}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxFrame -> {"Columns" -> None, "Rows" -> {{None}}}, 
            GridBoxItemSize -> {
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Grid"]& )}]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "14.3 for Mac OS X ARM (64-bit) (July 1, 2025)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"],
$CellContext`FileChangeProtection -> None,
ETextbookTools`CreateNotebookCollection`Private`FileChangeProtection -> None,
ExpressionUUID->"3028d1f0-10a3-46d1-886a-ffccd13d3338"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[645, 23, 225, 7, 108, "Section",ExpressionUUID->"e1e67c37-a81b-49bd-9408-556d9ca4413d",
 CounterAssignments->{{"Section", 25}},
 CellID->396629460],
Cell[873, 32, 246, 4, 60, "Text",ExpressionUUID->"b41ead46-f531-4d32-992a-8db377c57c06",
 CellID->382899017],
Cell[CellGroupData[{
Cell[1144, 40, 120, 1, 56, "Subsection",ExpressionUUID->"8d397d3a-4edd-4dcf-9837-a092132c7d84",
 CellID->511715044],
Cell[1267, 43, 136, 1, 36, "Text",ExpressionUUID->"66e8b80d-1cfc-4ce9-8216-cba050126e50",
 CellID->398528281],
Cell[1406, 46, 405, 11, 47, "DisplayFormulaNumbered",ExpressionUUID->"22d6ed1a-626a-4e71-bcc5-a5e19f03e5e9",
 CellID->196299659],
Cell[1814, 59, 138, 1, 36, "Text",ExpressionUUID->"be52dfd6-cae3-4cda-81fb-2d7ab2338c57",
 CellID->326482207],
Cell[1955, 62, 615, 16, 32, "DisplayFormulaNumbered",ExpressionUUID->"eb89fd3d-010c-442d-b5f7-622546594768",
 CellID->27589235],
Cell[2573, 80, 162, 3, 36, "Text",ExpressionUUID->"b83951e0-18a2-415e-972d-b3593879245c",
 CellID->459039163],
Cell[2738, 85, 644, 20, 68, "DisplayFormulaNumbered",ExpressionUUID->"73115ade-18f2-408f-b9a3-a4bf3e4d1636",
 CellID->163719195],
Cell[3385, 107, 133, 1, 36, "Text",ExpressionUUID->"690f3b2a-2a6d-4d0c-b540-69e23a7d5de4",
 CellID->103463970],
Cell[3521, 110, 186, 8, 71, "SolvedExample",ExpressionUUID->"9e26d494-a1e2-4b75-af28-d4b5da63e1e2",
 CellID->54343068],
Cell[3710, 120, 548, 17, 42, "SolvedExampleNote",ExpressionUUID->"229173f0-46b3-454a-bbcd-367716c77f67",
 CellID->31031473],
Cell[4261, 139, 205, 4, 39, "SolvedExampleNote",ExpressionUUID->"b94b630b-957b-45cf-8777-f9c71e166be9",
 CellID->191497112],
Cell[4469, 145, 2034, 66, 104, "SolvedExampleNote",ExpressionUUID->"0572dd21-f29a-4a06-835c-2ed3e5503a76",
 CellID->118689112],
Cell[6506, 213, 228, 6, 39, "SolvedExampleNote",ExpressionUUID->"a7c68c0f-d6b9-435d-a1a7-9deaf9d49173",
 CellID->27009928],
Cell[CellGroupData[{
Cell[6759, 223, 610, 20, 25, "SolvedExampleInput",ExpressionUUID->"0e13e11e-b0c9-4dbc-bd7a-9f3f4c25fab6",
 CellID->2522036],
Cell[7372, 245, 319, 9, 57, "SolvedExampleOutput",ExpressionUUID->"f7c0c494-3952-4817-95b3-075ed2cfa291",
 CellID->219102736]
}, Open  ]],
Cell[7706, 257, 201, 4, 39, "SolvedExampleNote",ExpressionUUID->"721b41bd-6b2c-48df-b046-59f697e8228b",
 CellID->252019689],
Cell[CellGroupData[{
Cell[7932, 265, 1700, 46, 27, "SolvedExampleInput",ExpressionUUID->"8c8ebfa2-0189-406d-bc87-8012b8a9c75e",
 CellID->227740522],
Cell[9635, 313, 52330, 883, 202, "SolvedExampleOutput",ExpressionUUID->"46ed961d-ef6a-4a6a-b6ba-85072ec8d2ff",
 CellID->858618057]
}, Open  ]],
Cell[61980, 1199, 403, 10, 39, "SolvedExampleNote",ExpressionUUID->"eaef6176-a039-4531-82ed-036d4f2b9d8b",
 CellID->215360412],
Cell[62386, 1211, 1559, 51, 101, "SolvedExampleNote",ExpressionUUID->"73ad82a9-3604-41c5-925b-0b5f038eb175",
 CellID->8255921],
Cell[63948, 1264, 184, 6, 39, "SolvedExampleNote",ExpressionUUID->"1d0ed778-dafb-48f7-b1dc-57ab82de4c46",
 CellID->250289981],
Cell[CellGroupData[{
Cell[64157, 1274, 386, 11, 25, "SolvedExampleInput",ExpressionUUID->"18a78b94-91eb-4ac7-915d-a4fa124d932f",
 CellID->514301818],
Cell[64546, 1287, 163, 3, 54, "SolvedExampleOutput",ExpressionUUID->"bc888a3e-66f2-43e8-846d-85b4d2490f46",
 CellID->484586448]
}, Open  ]],
Cell[64724, 1293, 175, 3, 39, "SolvedExampleNote",ExpressionUUID->"54134c6a-0972-4316-ab1e-68f111429941",
 CellID->107994244],
Cell[CellGroupData[{
Cell[64924, 1300, 481, 14, 50, "SolvedExampleInput",ExpressionUUID->"f5f57847-9b53-4603-80d6-14f8c0006d8e",
 CellID->191284703],
Cell[65408, 1316, 162, 3, 54, "SolvedExampleOutput",ExpressionUUID->"3ffa681e-c5c9-4309-8c39-c4a5e63c9776",
 CellID->42361224]
}, Open  ]],
Cell[65585, 1322, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"9ac53420-d992-4cac-8006-b92aa03dd3ed",
 CellID->943814759],
Cell[65694, 1325, 185, 8, 71, "SolvedExample",ExpressionUUID->"eb68e323-f3b8-466d-ae04-916182719753",
 CellID->9972039],
Cell[65882, 1335, 611, 18, 44, "SolvedExampleNote",ExpressionUUID->"b96eda7e-6ff8-4702-88a5-b2328d198e8a",
 CellID->71072954],
Cell[66496, 1355, 130, 1, 39, "SolvedExampleNote",ExpressionUUID->"2974d9af-d18d-4514-9d05-6b6615ce4fb2",
 CellID->774763465],
Cell[66629, 1358, 1881, 58, 93, "SolvedExampleNote",ExpressionUUID->"8a2abef2-b047-4579-9967-b201f4d95968",
 CellID->164111970],
Cell[68513, 1418, 162, 2, 39, "SolvedExampleNote",ExpressionUUID->"ee6b1339-a87c-41f4-b15a-ca2e32f1f2b4",
 CellID->594865085],
Cell[CellGroupData[{
Cell[68700, 1424, 1851, 50, 54, "SolvedExampleInput",ExpressionUUID->"2cb51427-a9e8-4b26-97fc-be4ec44894c9",
 CellID->5346843],
Cell[70554, 1476, 48246, 815, 200, "SolvedExampleOutput",ExpressionUUID->"c860fc5d-a6fe-4cd2-a002-966a304b50ad",
 CellID->732562583]
}, Open  ]],
Cell[118815, 2294, 459, 14, 39, "SolvedExampleNote",ExpressionUUID->"539cb99b-2329-4fb4-8b44-dd450b245246",
 CellID->248601382],
Cell[CellGroupData[{
Cell[119299, 2312, 741, 21, 99, "SolvedExampleInput",ExpressionUUID->"be743973-57e4-4566-8acf-05974072e693",
 CellID->625415500],
Cell[120043, 2335, 606, 19, 44, "SolvedExampleOutput",ExpressionUUID->"fd0e9cdb-2c2c-4c6e-a63f-bf9549fc117a",
 CellID->314973646]
}, Open  ]],
Cell[120664, 2357, 493, 14, 39, "SolvedExampleNote",ExpressionUUID->"451bebb9-e1c0-4c92-9081-fe96f244cf83",
 CellID->368606664],
Cell[121160, 2373, 1908, 58, 45, "SolvedExampleNote",ExpressionUUID->"f82c7d56-38e8-4f4e-97cc-f8413665c46f",
 CellID->185206872],
Cell[123071, 2433, 123, 1, 39, "SolvedExampleNote",ExpressionUUID->"ccdf7dc7-0dd5-4ef3-ac02-6aa4d7d968a3",
 CellID->38183647],
Cell[CellGroupData[{
Cell[123219, 2438, 451, 13, 25, "SolvedExampleInput",ExpressionUUID->"53dd8ff7-7440-4400-9eb9-3192417183ee",
 CellID->396453290],
Cell[123673, 2453, 249, 7, 45, "SolvedExampleOutput",ExpressionUUID->"54cd9fb0-e50f-44cb-ba5e-01e596c3529a",
 CellID->9052795]
}, Open  ]],
Cell[123937, 2463, 197, 6, 39, "SolvedExampleNote",ExpressionUUID->"4b16ffbf-ab57-447a-bb5d-54de338e95f5",
 CellID->34866462],
Cell[CellGroupData[{
Cell[124159, 2473, 417, 11, 53, "SolvedExampleInput",ExpressionUUID->"a3bbcf25-1350-4fa5-8923-dacbab9ff770",
 CellID->153008301],
Cell[124579, 2486, 251, 7, 45, "SolvedExampleOutput",ExpressionUUID->"77c6ef2c-4cb7-4003-8713-23443d32a8d0",
 CellID->211496755]
}, Open  ]],
Cell[124845, 2496, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"9e406349-1d3c-47bb-a95d-b54dbe3ca503",
 CellID->346606882]
}, Open  ]],
Cell[CellGroupData[{
Cell[124988, 2502, 128, 1, 56, "Subsection",ExpressionUUID->"30ac304d-12b6-4132-89e6-6e5d21444261",
 CellID->131573002],
Cell[125119, 2505, 442, 12, 60, "Text",ExpressionUUID->"93f9578f-fe99-4ac1-b9a1-dd565454e1b3",
 CellID->5868228],
Cell[CellGroupData[{
Cell[125586, 2521, 198, 2, 54, "Subsubsection",ExpressionUUID->"7af24a8a-1d7b-4ded-8ac6-cd90a38dd411",
 CellID->1985850273],
Cell[125787, 2525, 516, 14, 60, "Text",ExpressionUUID->"dca66791-3f00-412d-9e36-08647e214bfb",
 CellID->19162524],
Cell[126306, 2541, 633, 17, 43, "DisplayFormulaNumbered",ExpressionUUID->"3fc607d8-4da8-430b-b63d-544431aab632",
 CellID->335099431],
Cell[126942, 2560, 95, 1, 36, "Text",ExpressionUUID->"b4c58692-b172-4f7a-be74-62f3cb129575",
 CellID->340271272],
Cell[127040, 2563, 1052, 29, 52, "DisplayFormulaNumbered",ExpressionUUID->"6640a225-bd7d-4c18-947f-aaf67aa3d15f",
 CellID->59810],
Cell[128095, 2594, 146, 1, 36, "Text",ExpressionUUID->"2c285945-7208-4487-ae21-1394a681f59f",
 CellID->90632183],
Cell[128244, 2597, 273, 8, 36, "Text",ExpressionUUID->"151e64ee-ee45-45a8-b90c-79f917ff9509",
 CellID->21211770],
Cell[128520, 2607, 663, 18, 43, "DisplayFormulaNumbered",ExpressionUUID->"c6a5afc3-698e-4d2e-a174-269789cbd846",
 CellID->934369381],
Cell[129186, 2627, 92, 1, 36, "Text",ExpressionUUID->"eda7f1eb-3d4e-4c30-9616-b3ffc126859b",
 CellID->273680],
Cell[129281, 2630, 1077, 30, 52, "DisplayFormulaNumbered",ExpressionUUID->"b91309c1-3575-42d2-b6d6-0ca308d39034",
 CellID->238243430],
Cell[130361, 2662, 147, 1, 36, "Text",ExpressionUUID->"cd4e0744-325b-4cba-898d-9b25c14fc003",
 CellID->177374090],
Cell[130511, 2665, 286, 5, 60, "Text",ExpressionUUID->"a92def00-d27f-4649-aa25-78f0eb3adbc6",
 CellID->647142913],
Cell[CellGroupData[{
Cell[130822, 2674, 11856, 308, 70, "Input",ExpressionUUID->"0c9bf8e5-eae3-4732-a2a7-86f8d126636c",
 CellID->551922900],
Cell[142681, 2984, 4482, 111, 267, "Output",ExpressionUUID->"324e3d29-7dfe-431b-b4c5-ceeb4b591771",
 CellID->1237895866]
}, {2}]],
Cell[147175, 3098, 571, 11, 107, "Text",ExpressionUUID->"f0a5b011-eb90-476c-9cf0-27a1f19720c3",
 CellID->60681172],
Cell[147749, 3111, 187, 8, 71, "SolvedExample",ExpressionUUID->"2a026185-d821-4a6a-a961-a767641260e9",
 CellID->253593451],
Cell[147939, 3121, 631, 18, 42, "SolvedExampleNote",ExpressionUUID->"b64b81f3-9794-4e18-be9d-db9d901bae3a",
 CellID->293623877],
Cell[148573, 3141, 895, 24, 61, "SolvedExampleNote",ExpressionUUID->"b7f50f01-b534-4194-aa96-3be7954809b6",
 CellID->323857967],
Cell[149471, 3167, 1024, 31, 44, "SolvedExampleNote",ExpressionUUID->"a9441e3a-42cc-4f72-8460-d7a52a62c171",
 CellID->267372431],
Cell[150498, 3200, 193, 4, 39, "SolvedExampleNote",ExpressionUUID->"451e9541-8257-437d-8f8a-6f6485e0d1e7",
 CellID->120719945],
Cell[CellGroupData[{
Cell[150716, 3208, 294, 8, 48, "SolvedExampleInput",ExpressionUUID->"49b39410-ef57-447f-ae48-ab82d2e627f1",
 CellID->337286927],
Cell[151013, 3218, 740, 25, 62, "SolvedExampleOutput",ExpressionUUID->"782a4cbe-0183-45c7-b3b4-7b83423cdb72",
 CellID->40163409]
}, Open  ]],
Cell[151768, 3246, 122, 1, 39, "SolvedExampleNote",ExpressionUUID->"0e08f633-51ab-41ee-a2c4-6eb2fb2c543c",
 CellID->976897184],
Cell[CellGroupData[{
Cell[151915, 3251, 628, 19, 51, "SolvedExampleInput",ExpressionUUID->"51827c70-50a7-4d03-8178-21d579e10ffa",
 CellID->47980667],
Cell[152546, 3272, 483, 16, 81, "SolvedExampleOutput",ExpressionUUID->"0b7096a1-a882-4d46-8bba-aaa1b2d7dd60",
 CellID->785455532]
}, Open  ]],
Cell[153044, 3291, 182, 6, 39, "SolvedExampleNote",ExpressionUUID->"f90fa034-bb8b-4d5e-ba39-c7485a88319d",
 CellID->434267304],
Cell[CellGroupData[{
Cell[153251, 3301, 430, 13, 25, "SolvedExampleInput",ExpressionUUID->"e2b7b50f-61b2-4cfc-8881-5c6b22cee807",
 CellID->154276106],
Cell[153684, 3316, 483, 16, 81, "SolvedExampleOutput",ExpressionUUID->"b38ed58d-348c-4fb3-bbff-e8c966cc36b5",
 CellID->247186516]
}, Open  ]],
Cell[154182, 3335, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"5287b711-9556-4761-8aee-436207fe86ef",
 CellID->620922218],
Cell[154291, 3338, 187, 8, 71, "SolvedExample",ExpressionUUID->"ad4bbee0-ae5b-42ae-8ac4-57b1fa18a59a",
 CellID->179013870],
Cell[154481, 3348, 606, 18, 44, "SolvedExampleNote",ExpressionUUID->"b2af81d0-c91a-409a-95f7-a5e2e9e8a9b7",
 CellID->55259230],
Cell[155090, 3368, 1811, 49, 89, "SolvedExampleNote",ExpressionUUID->"d39f8e56-c5b8-4663-ad86-318959ee4619",
 CellID->635895713],
Cell[156904, 3419, 1010, 31, 44, "SolvedExampleNote",ExpressionUUID->"99fc69e3-3cf7-41b9-9a9a-ff8119bd4096",
 CellID->596556397],
Cell[157917, 3452, 159, 2, 39, "SolvedExampleNote",ExpressionUUID->"2bf3e351-a5d6-4e23-aeab-8b2610de7221",
 CellID->139182222],
Cell[158079, 3456, 1247, 35, 45, "SolvedExampleNote",ExpressionUUID->"09598258-fe4f-4c74-a3d8-68cdf0fac332",
 CellID->439250185],
Cell[159329, 3493, 845, 26, 44, "SolvedExampleNote",ExpressionUUID->"0698b3b4-5cc6-41aa-b04d-df67de74bbf8",
 CellID->143577348],
Cell[CellGroupData[{
Cell[160199, 3523, 403, 12, 25, "SolvedExampleInput",ExpressionUUID->"8224738c-83d8-407b-8145-2af98e033a08",
 CellID->39689063],
Cell[160605, 3537, 153, 2, 51, "SolvedExampleOutput",ExpressionUUID->"a8f5b0b5-9204-417e-a8f1-0583aa987850",
 CellID->64652486]
}, Open  ]],
Cell[160773, 3542, 107, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"d6c1b64f-4a38-4d99-bf4d-96c6adb257bc",
 CellID->1606591619]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[160929, 3549, 136, 1, 56, "Subsection",ExpressionUUID->"be2a6a62-27c6-436b-84a3-0e12ab6aaf7d",
 CellID->744405353],
Cell[161068, 3552, 797, 20, 61, "Text",ExpressionUUID->"89ebc3ba-24bc-4853-b4e7-8ff9a1b731fc",
 CellID->10322103],
Cell[161868, 3574, 791, 22, 61, "Text",ExpressionUUID->"afc99a27-e682-4c30-8589-05185ba64a93",
 CellID->364316500],
Cell[162662, 3598, 298, 5, 83, "Text",ExpressionUUID->"1b78b560-08b4-485a-afe7-1ef8cc019bba",
 CellID->63037447],
Cell[162963, 3605, 1173, 34, 60, "Text",ExpressionUUID->"9ae552da-f4cb-4d8a-a313-5e40ffc419b4",
 CellID->116172592],
Cell[164139, 3641, 186, 8, 71, "SolvedExample",ExpressionUUID->"da1019d4-ce1b-4cf9-94bd-06d8c8a1c091",
 CellID->68367176],
Cell[164328, 3651, 549, 16, 42, "SolvedExampleNote",ExpressionUUID->"acc5c721-d8f2-4604-93db-3a694dfb83d7",
 CellID->210301810],
Cell[164880, 3669, 1011, 30, 89, "SolvedExampleNote",ExpressionUUID->"dbb89cd3-95fc-45f4-9e95-9f0b85a08147",
 CellID->403445262],
Cell[CellGroupData[{
Cell[165916, 3703, 474, 13, 48, "SolvedExampleInput",ExpressionUUID->"e0f58eac-2231-484c-ba4c-41d4d5b3483d",
 CellID->163929918],
Cell[166393, 3718, 162, 3, 54, "SolvedExampleOutput",ExpressionUUID->"31e17a3a-91b0-4da6-b896-61356e9da651",
 CellID->67855688]
}, Open  ]],
Cell[166570, 3724, 691, 22, 42, "SolvedExampleNote",ExpressionUUID->"b2d3c54e-b010-4de4-92a0-0eaca1f34293",
 CellID->145431398],
Cell[CellGroupData[{
Cell[167286, 3750, 372, 11, 25, "SolvedExampleInput",ExpressionUUID->"5fa1e540-d3fa-4437-b94c-89b96b12dd81",
 CellID->726371589],
Cell[167661, 3763, 163, 3, 54, "SolvedExampleOutput",ExpressionUUID->"e2f6ecb4-ba5d-4ac6-8bbc-1659170c9a59",
 CellID->772110795]
}, Open  ]],
Cell[167839, 3769, 106, 1, 20, "SolvedExampleEndCap",ExpressionUUID->"6d11f197-a996-4514-acef-cac59178aea7",
 CellID->578123746],
Cell[CellGroupData[{
Cell[167970, 3774, 109, 1, 69, "SummarySection",ExpressionUUID->"45e93b22-c20a-4e17-a682-45af1edd8397",
 CellID->1198545324],
Cell[168082, 3777, 860, 22, 54, "SummaryList",ExpressionUUID->"106d3aac-3ee5-44e9-a3d8-621ee766454d",
 CellID->496264327],
Cell[168945, 3801, 698, 18, 31, "SummaryList",ExpressionUUID->"c20f50f9-b990-4356-93c4-fc407e475a83",
 CellID->242282283],
Cell[169646, 3821, 549, 14, 54, "SummaryList",ExpressionUUID->"ea825997-8256-48d7-8bfc-e071d8c48a7d",
 CellID->145943732]
}, Open  ]],
Cell[CellGroupData[{
Cell[170232, 3840, 160, 3, 65, "ExerciseSection",ExpressionUUID->"38918a00-ac42-484f-809d-a5e8c4dbd812",
 CellID->244972492],
Cell[170395, 3845, 504, 16, 33, "Exercise",ExpressionUUID->"278cb879-10e9-47c3-b7f4-a539142372ac",
 CellID->914307764],
Cell[CellGroupData[{
Cell[170924, 3865, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"2f7bc760-f6c6-40d6-ac89-0c16be3e5c0a"],
Cell[171018, 3867, 1340, 41, 54, "SolutionAnswer",ExpressionUUID->"b500de40-02c5-4b66-85de-d8540d161b81",
 CellID->474285869],
Cell[CellGroupData[{
Cell[172383, 3912, 274, 8, 25, "ExerciseInput",ExpressionUUID->"03593d0b-c662-4de1-9196-3cdb2154fbff",
 CellID->108159957],
Cell[172660, 3922, 406, 13, 36, "ExerciseOutput",ExpressionUUID->"8c7d8635-4867-4e3e-a5fb-6b3211552e82",
 CellID->792089456]
}, Open  ]],
Cell[173081, 3938, 1339, 44, 47, "SolutionAnswer",ExpressionUUID->"bdeff07a-5450-4341-add3-78cd9e073cea",
 CellID->42938819],
Cell[CellGroupData[{
Cell[174445, 3986, 475, 15, 31, "ExerciseInput",ExpressionUUID->"d5624666-4026-4a5b-b9c7-98e422fac0b4",
 CellID->437977753],
Cell[174923, 4003, 147, 3, 49, "ExerciseOutput",ExpressionUUID->"189b886c-2b11-45ab-b74c-ef19c24955a4",
 CellID->313145840]
}, Open  ]],
Cell[175085, 4009, 180, 6, 22, "SolutionAnswer",ExpressionUUID->"c4e0fe8d-99c3-426d-84d8-1d159d4a9e88",
 CellID->52703776],
Cell[CellGroupData[{
Cell[175290, 4019, 361, 10, 25, "ExerciseInput",ExpressionUUID->"31c6248b-20ad-4a00-bcb7-34f1874bab7f",
 CellID->179594352],
Cell[175654, 4031, 146, 3, 49, "ExerciseOutput",ExpressionUUID->"942a253f-a457-4e36-8166-11622f965c16",
 CellID->95679940]
}, Open  ]]
}, Closed]],
Cell[175827, 4038, 952, 32, 30, "Exercise",ExpressionUUID->"1e3f09dc-5a03-4e75-a98c-855ffde9ff86",
 CellID->84226656],
Cell[CellGroupData[{
Cell[176804, 4074, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"162b8512-d550-4ccb-979e-d4f4243dfa5b"],
Cell[176898, 4076, 2530, 81, 63, "SolutionAnswer",ExpressionUUID->"48920228-2186-493c-a151-b32797fdbcfb",
 CellID->55624697],
Cell[179431, 4159, 157, 2, 22, "SolutionAnswer",ExpressionUUID->"54d6cb88-c18d-4319-b5e1-ef4d80c5269c",
 CellID->131206112],
Cell[CellGroupData[{
Cell[179613, 4165, 743, 24, 25, "ExerciseInput",ExpressionUUID->"6d8b3e45-e0f4-482d-8940-970c50f516ef",
 CellID->318131160],
Cell[180359, 4191, 1207, 43, 99, "ExerciseOutput",ExpressionUUID->"41dc0b3a-f093-40bd-acb0-0d0abf2669c4",
 CellID->503394871]
}, Open  ]],
Cell[181581, 4237, 199, 4, 22, "SolutionAnswer",ExpressionUUID->"0f1f845e-a6af-489b-9e56-82ae21774430",
 CellID->29439066],
Cell[CellGroupData[{
Cell[181805, 4245, 926, 30, 52, "ExerciseInput",ExpressionUUID->"b15f7e27-b6ef-41d9-808b-6e1f6a33e7d1",
 CellID->65678630],
Cell[182734, 4277, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"cf4c5a9d-42ce-4f68-b114-18c12648b28c",
 CellID->356641293]
}, Open  ]],
Cell[182860, 4281, 214, 6, 22, "SolutionAnswer",ExpressionUUID->"926dc35a-c54a-442a-8a30-f92318029146",
 CellID->6551626],
Cell[CellGroupData[{
Cell[183099, 4291, 663, 21, 25, "ExerciseInput",ExpressionUUID->"a7dd6bc1-b6a6-4097-9893-76f051888150",
 CellID->15998534],
Cell[183765, 4314, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"3bd90682-e77b-4262-b16e-6707811fd074",
 CellID->331363847]
}, Open  ]]
}, Closed]],
Cell[183903, 4319, 972, 31, 29, "Exercise",ExpressionUUID->"f2e8e160-739c-4bdb-a745-8953a524611e",
 CellID->575428604],
Cell[CellGroupData[{
Cell[184900, 4354, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"d7f69830-b88d-4689-a0a0-666ea0ea8f80"],
Cell[184994, 4356, 2047, 56, 77, "SolutionAnswer",ExpressionUUID->"f8a729cb-f735-4c93-a493-0d13d14ddcc0",
 CellID->145621945],
Cell[187044, 4414, 1123, 34, 26, "SolutionAnswer",ExpressionUUID->"6aa5bbd7-847d-4e90-8b97-e33da3111919",
 CellID->181291087],
Cell[CellGroupData[{
Cell[188192, 4452, 419, 13, 25, "ExerciseInput",ExpressionUUID->"94fe0276-b9c7-4b16-b90e-ea80f240d720",
 CellID->10152337],
Cell[188614, 4467, 111, 1, 28, "ExerciseOutput",ExpressionUUID->"cbff612c-5274-4a19-b4d5-5de01933bb4c",
 CellID->142512157]
}, Open  ]],
Cell[CellGroupData[{
Cell[188762, 4473, 420, 13, 25, "ExerciseInput",ExpressionUUID->"eacc5cbd-4868-430a-9899-6ccd07d19473",
 CellID->557571507],
Cell[189185, 4488, 173, 3, 43, "ExerciseOutput",ExpressionUUID->"4d2df421-a0bc-485e-bd00-512fa3266c13",
 CellID->545207199]
}, Open  ]]
}, Closed]],
Cell[189385, 4495, 623, 19, 32, "Exercise",ExpressionUUID->"688048c2-3f48-4fd5-a01c-6ec414695406",
 CellID->147656287],
Cell[CellGroupData[{
Cell[190033, 4518, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"8cc3e7bd-25c8-4022-859b-9b42cd767220"],
Cell[190127, 4520, 1622, 46, 47, "SolutionAnswer",ExpressionUUID->"d14c210d-5656-4627-b2eb-ba90ad3b8c43",
 CellID->59540520],
Cell[191752, 4568, 1788, 55, 29, "SolutionAnswer",ExpressionUUID->"a78a779b-9c9e-4ec4-a025-3e8c23daa19d",
 CellID->411778248],
Cell[CellGroupData[{
Cell[193565, 4627, 624, 18, 47, "ExerciseInput",ExpressionUUID->"7419e8ff-2730-4c85-bf2a-e9fe2f4c8595",
 CellID->811858528],
Cell[194192, 4647, 333, 9, 44, "ExerciseOutput",ExpressionUUID->"0ddc8f94-88fd-402c-9037-03dddd889a8f",
 CellID->615124005]
}, Open  ]],
Cell[194540, 4659, 216, 6, 22, "SolutionAnswer",ExpressionUUID->"99056ab8-3b74-471b-b9c2-24af016df003",
 CellID->654375360],
Cell[CellGroupData[{
Cell[194781, 4669, 460, 14, 47, "ExerciseInput",ExpressionUUID->"526ed37d-fdfc-4005-8066-19fa7b3e78be",
 CellID->301245048],
Cell[195244, 4685, 332, 9, 44, "ExerciseOutput",ExpressionUUID->"5cf24a37-1724-4b9b-b59c-7511cc2e6732",
 CellID->38252815]
}, Open  ]]
}, Closed]],
Cell[195603, 4698, 677, 22, 31, "Exercise",ExpressionUUID->"e14e37dd-b36c-452f-83ea-e5c4e0f46b53",
 CellID->59232870],
Cell[CellGroupData[{
Cell[196305, 4724, 91, 0, 25, "ExerciseSolution",ExpressionUUID->"d0fa64bf-c1a9-446c-9efb-e38a360ceec7"],
Cell[196399, 4726, 1274, 34, 65, "SolutionAnswer",ExpressionUUID->"d64f6fe8-cf0f-47b9-977e-7617fe5aecef",
 CellID->22126526],
Cell[197676, 4762, 2368, 76, 52, "SolutionAnswer",ExpressionUUID->"2ed5dba4-a21b-445c-a634-94f867deb7c8",
 CellID->87162741],
Cell[CellGroupData[{
Cell[200069, 4842, 576, 19, 25, "ExerciseInput",ExpressionUUID->"43b66531-c7c4-41f4-8494-39df63154595",
 CellID->377408346],
Cell[200648, 4863, 218, 6, 36, "ExerciseOutput",ExpressionUUID->"e9abad99-11cb-4bd3-b72c-56a50625d585",
 CellID->200331810]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[200929, 4876, 310, 6, 135, "SmallText",ExpressionUUID->"88f10bda-256c-4d31-8aae-4326cebf500e",
 CellGroupingRules->"SectionGrouping",
 CellID->1368449107]
}
]
*)

(* NotebookSignature gRclqLH9TLjHDlIDGWBBZMVa *)
